#! /bin/csh
# Script para criacao de mascaras para qualquel grade
# adaptcoes realizadas por Jose Roberto Rozante e
# Marcos Bottino - METOP - CPTEC - INPE
#
rm -f ctl local.ctl 
rm -f mascara.ctl 
rm -f mas.ctl 
rm -f mascara.gs 
rm -f mascara.dat 
rm -f ctl2 
rm -f ctl3
c
echo "   "
echo "   "
echo '                     Entre com o diretorio e o ctl           '
echo "   "
set ctl=($<)
echo "   "
echo "   "
c
echo '                      Entre com numero de mascara '
echo "   "
set n=($<)

cat << EOF > mascara.gs
'reinit'

'set font 1'
n=0
while (n<30)
  'set string 7 c 10'
  n=n+1
  sz=0.001 + (n-1)*(0.04)
  'set strsiz 'sz
  if(n>10);'set string 8 c 10';endif;
  if(n>20);'set string 2 c 10';endif;

'draw string 5.5 6.0 METOP'
endwhile
'set string 1 c 10'
'draw string 5.5 6.0 METOP'
'set strsiz 0.18'
'set string 3 c 10'
'set font 2'
'set line 5'
n=0
x1=2.1
x2=8.7
dx=(x2-x1)/30
while (n<30)
n=n+1
'draw line 5.29 2.7 'x1+n*dx' '3.3
endwhile
'set string 1'
'draw string 5.4 1.2 Click !'
'q bpos'


'set rgb 90 100 100 100 '
'set rgb 91  50 50 50 '
'set rgb 92 200 200 200'
_fnum = 0

*  put input file name into the ofile argument

rc = ofile('$ctl')

*  Select gridpoints for the mask

'set mpdset brmap_mres'
_aux=0
while (_aux<$n)
rc = newar(1)
'set gxout fwrite'
 
*  output file name as the fwrite operand

'set fwrite '_nome

* say _xnum._fn
* say _ynum._fn

  'set x 1 '%(_xnum._fn)
  'set y 1 '%(_ynum._fn)
  'set z 1'
  'set t 1'
  'd maskarea'
  'disable fwrite'
_aux=_aux+1 
'c'
endwhile
'quit' 

function newar()
'q dialog Entre com o nome para mascaras'
  _nome=result
  rc=write("teste"%_aux+1,_nome)
  _i=0
  'set dfile '_fn
  'set x 0 '%(_xnum._fn+0)
  'set y 0 '%(_ynum._fn+0)
  'set z 1'
  'set t 1'
* say _vars._fn
  varnm = subwrd(_vars._fn,1)

# 
  if (varnm= 'masktemp')
  'define  maskarea= 'varnm
  else
  'define maskarea = const('varnm',-1)'
  endif
  arnam = 'maskarea'  
  'set button 1 90 91 92 7 90 92 91 6'
  'set parea 0.8 10.5 1.5 8.0'
  _mode = 1
  'q dims'
  rec = sublin(result,2)
  _lonlo._i = subwrd(rec,6)
  _lonhi._i = subwrd(rec,8)
  rec = sublin(result,3)
  _latlo._i = subwrd(rec,6)
  _lathi._i = subwrd(rec,8)

*  loop to plot the field, and wait for a 
*  point and click, then modify the field.

   'set dbuff on'
   ret = dodisp(arnam)

   while (1)
     'swap'
     'q pos'
* say result
     x = subwrd(result,3)
     y = subwrd(result,4)
     mb = subwrd(result,5)
     cl = subwrd(result,6)
     if (cl=1) 
       bn = subwrd(result,7)
     endif
     if (cl=2) 
       rn = subwrd(result,7)
       x2 = subwrd(result,8)
       y2 = subwrd(result,9)
     endif

     if (cl=1) 
       if (bn=1); return; endif;
       if (bn=10); _mode = 1; endif; 
       if (bn=11); _mode = 2; endif; 
       if (bn=12); _mode = 3; endif; 
       if (bn=2)
         'set x 0 '%(_xnum._fn+0)
         'set y 0 '%(_ynum._fn+0)
         'q dims'
         if (_i>0)
          _i=_i-1
         endif
         if (_i=0)
          rec = sublin(result,2)
         _lonlo._i = subwrd(rec,6)
         _lonhi._i = subwrd(rec,8)
         rec = sublin(result,3)
         _latlo._i = subwrd(rec,6)
         _lathi._i = subwrd(rec,8)
         endif
       endif
     endif
     if (cl=2) 
       if (x>x2)
         x1 = x2
         x2 = x
       else
         x1 = x
       endif
       if (y>y2)
         y1 = y2
         y2 = y
       else
         y1 = y
       endif
       if (x2-x1>0.1 & y2-y1>0.1)
         if (_mode = 1)
           lon1 = _lonlo._i + (x1-_xlo)*(_lonhi._i-_lonlo._i)/(_xhi-_xlo)
           lat1 = _latlo._i + (y1-_ylo)*(_lathi._i-_latlo._i)/(_yhi-_ylo)
           lon2 = _lonlo._i + (x2-_xlo)*(_lonhi._i-_lonlo._i)/(_xhi-_xlo)
           lat2 = _latlo._i + (y2-_ylo)*(_lathi._i-_latlo._i)/(_yhi-_ylo)
           _i=_i+1
*     say _i
           _lonlo._i = lon1; _lonhi._i = lon2
           _latlo._i = lat1; _lathi._i = lat2          
         endif
         if (_mode = 2)
           i1 = _ilo + (x1-_xlo)*(_ihi-_ilo)/(_xhi-_xlo)
           j1 = _jlo + (y1-_ylo)*(_jhi-_jlo)/(_yhi-_ylo)
           i2 = _ilo + (x2-_xlo)*(_ihi-_ilo)/(_xhi-_xlo)
           j2 = _jlo + (y2-_ylo)*(_jhi-_jlo)/(_yhi-_ylo)
           i1 = intrnd(i1)
           j = intrnd(j1)
           i2 = intrnd(i2) + 1
           j2 = intrnd(j2) + 1
           while (j<j2)
             i = i1
             while (i<i2)
               'set defval 'arnam' 'i' 'j' 1'
               i = i + 1
             endwhile
             j = j + 1
           endwhile
         endif
       endif
     endif
     if (cl=0)
       if (x<_xlo | x>_xhi | y<_ylo | y>_yhi)
         say 'Out of Range'
       else
         i = _ilo + (x-_xlo)*(_ihi-_ilo)/(_xhi-_xlo)
         j = _jlo + (y-_ylo)*(_jhi-_jlo)/(_yhi-_ylo)
         i = intrnd(i)
         j = intrnd(j)
         'q defval 'arnam' 'i' 'j
         val = subwrd(result,3)
* say val
         if (val<0) 
           'set defval 'arnam' 'i' 'j' 1'
           if (i<_xmin.arnum); _xmin.arnum = i; endif;
           if (i>_xmax.arnum); _xmax.arnum = i; endif;
           if (j<_ymin.arnum); _ymin.arnum = j; endif;
           if (j>_ymax.arnum); _ymax.arnum = j; endif;
         else 
           'set defval 'arnam' 'i' 'j' -1'
         endif
       endif
     endif
     ret = dodisp(arnam)
   endwhile

   'set dbuff off'
     
      
function dodisp (arnam)
   'set line 90'
   'draw recf 0 0 11 8.5'
   'set lon '_lonlo._i' '_lonhi._i
   'set lat '_latlo._i' '_lathi._i
* say _lonlo.2 ' '_lonhi.2
   'set grid off'
   'set map 15 1 6'
   'set gxout fgrid'
   'set fgvals -1 0 1 8'
   'set grads off'
   'd 'arnam
   'set gxout grid'
   'set grads off'
   'set ccolor 1'
   'd maskout('arnam','arnam'-100)'
   'draw button 1 0.5 0.3 1 0.5 GRAVA'
   'draw button 2 3.5 0.3 1.3 0.5 UnZoom'
   'draw button 10 6.4 0.3 1.8 0.5 Zoom'
   'draw button 11 8.2 0.3 1.8 0.5 Rectangle'
   'draw button 12 10.0 0.3 1.8 0.5 Toggle'
   if (_mode=1) 
     'redraw button 10 1'
   endif
   if (_mode=2) 
     'redraw button 11 1'
   endif
   if (_mode=3) 
     'redraw button 12 1'
   endif
   'q gxinfo'
   rec = sublin(result,3)
   _xlo = subwrd(rec,4)
   _xhi = subwrd(rec,6)
   rec = sublin(result,4)
   _ylo = subwrd(rec,4)
   _yhi = subwrd(rec,6)
   'q xy2gr '_xlo' '_ylo
   _ilo = subwrd(result,3)
   _jlo = subwrd(result,6)
   'q xy2gr '_xhi' '_yhi
   _ihi = subwrd(result,3)
   _jhi = subwrd(result,6)
   if (_mode=1 | _mode = 2) 
     'set rband 1 box '_xlo' '_ylo' '_xhi' '_yhi
   endif
return

* int function

function intrnd(stuff)

  if (stuff<0) 
    nflag = 1
    stuff = -1 * stuff
  else
    nflag = 0
  endif
  stuff = stuff + 0.5
  res = ''
  i = 1
  c = substr(stuff,i,1)
  while (c!='' & ('x'%c)!='x.') 
    res = res%c
    i = i + 1
    c = substr(stuff,i,1)
  endwhile
  if (nflag = 1 & res > 0) 
    res = -1 * res
  endif
  return res

*  Function to open a file
*  Variables filled in:  
*     _fnum  -  number of open files
*     _znum._fn  - number of levels in file
*     _tnum._fn  - number of times in file
*     _vnum._fn  - number of variables in file
*     _levs._fn  - levels (character); one long string
*     _vars._fn  - vars (character); one long string
*     _vname._fn.vn  - long var description

function ofile (fname) 

  'open 'fname
  rec = sublin(result,2)
  if (subwrd(rec,1)="Open") 
    say 'Open error on file name: 'fname
    return
  endif
  _fn = subwrd(rec,8)
  _fnum = _fnum + 1
  if (_fn!=_fnum) 
    say "Internal logic error on open"
    _fnum = _fnum - 1
    return
  endif
 
* Get info on file 

  'set dfile '_fn
  'q file '_fn
  res = result
  dum = sublin(res,5)
  _xnum._fn = subwrd(dum,3)
  _ynum._fn = subwrd(dum,6)
  _znum._fn = subwrd(dum,9)
  _tnum._fn = subwrd(dum,12)
  xnum._fn = subwrd(dum,3)
  ynum._fn = subwrd(dum,6)
  dum = sublin(res,6)
  _vnum._fn = subwrd(dum,5)

* Get world values for each level 

  i = 1
  _levs._fn = ''
  while (i<=_znum._fn) 
    'set z 'i
    _levs._fn = _levs._fn % ' ' % subwrd(result,4)
    i = i + 1
  endwhile

* Get each variable abbreviation

  i = 0
  _vars._fn = ''
  while (i<_vnum._fn) 
    dum = sublin(res,i+7)
    _vars._fn = _vars._fn % ' ' % subwrd(dum,1)
    j = i + 1
    pos = wrdpos(dum,4)
    _vname._fn.j = substr(dum,pos,100)
    i = i + 1
*   say _vname._fn.j
  endwhile

return
EOF
/grads_metop/grads17B9/bin/grads -lc "run mascara.gs" -g 1300x1000
set oi=1
while ($oi != $n + 1)
set ok = `awk "{print $1}" teste$oi |head -1`
echo $ok "  0 99  mascara de "  $ok >> local.ctl
cat $ok >> mascara.dat
\rm $ok
@ oi = $oi + 1
end
echo "ENDVARS" >> local.ctl
set xdef = `grep -i xdef $ctl`
set ydef = `grep -i ydef $ctl`

cat << EOF1 > mas.ctl
DSET ^mascara.dat
UNDEF -9999.
TITLE mascaras
$xdef
$ydef
ZDEF    1 LINEAR   1000   1   
TDEF    1 LINEAR 10feb1999 1dy
VARS  $n
EOF1
cat mas.ctl local.ctl >mascara.ctl
rm -f  teste*
rm -f  ctl 
rm -f  local.ctl  
rm -f  mas.ctl 
#rm -f  mascara.gs  
rm -f  ctl2 
rm -f  ctl3
c
exit

