#!/bin/bash -x
#
# Verifica se foi passado algum parametro
if (($#<2)) ; then
echo "Use: "
fi
Run_Date=${1}
ifct=${2}
ModelDrive=${3}

# VARIAVEIS
export Dir_scr=/lustre/projetos/grpeta/Team/jorge.gomes/Versoes/eta-v1.4.4-desenv/datain/scripts/Eta
export Dir_home=`dirname ${Dir_scr}` 
export Dir_datain=`dirname ${Dir_home}` 
export Dir_wrk=${Dir_datain}/atmos/${ModelDrive}/${Run_Date}
export Dir_ETAwrk=${Dir_datain}/atmos/ETAwrk/${ModelDrive}/${Run_Date}
export Dir_util=${Dir_datain}/util
export Dir_dprep_exe=${Dir_datain}/dprep/exe
export InitBC=6
export IntSST=24
export FInitBC=${ModelDrive}
export FInitBCexe=`cat ${Dir_scr}/InputModelInf.txt_${FInitBC}|head -1`

FInitBC_Up=`echo ${FInitBC}|awk '{print toupper($1)}'`
cp ${Dir_scr}/InputModelInf.txt_${FInitBC} ${Dir_ETAwrk}/InputModelInf.txt

me=$(whoami)
echo "I am $me."

cd ${Dir_wrk}

dhr=`printf "%07d" "${ifct}"`
if [ "${dhr}" == "0000000" ]  ; then
   datef=${Run_Date}
   ffct=icn
else
   datei=${Run_Date}
   datef=`${Dir_util}/caldate.3.0 ${Run_Date}   + ${InitBC}hr 'yyyymmddhh'`
   ffct=fct
fi
ifile=${Dir_wrk}/${FInitBC}_${Run_Date}+${datef}
ofile=${Dir_ETAwrk}/${ModelDrive}_${Run_Date}.${dhr}
echo '==================================================='
echo 'file in process '${ifile}
echo '==================================================='

echo ${Run_Date} > ${Dir_ETAwrk}/adate.txt
ln -s ${ifile}* ${Dir_ETAwrk}/.
ln -s ${Dir_wrk}/${FInitBC}_${Run_Date}_FF.bin ${Dir_ETAwrk}/.
${Dir_dprep_exe}/${FInitBCexe} << endin
${ifile}
${ofile}
${Dir_ETAwrk}
endin
if [ -s ${ofile}.ETAwrk ]  ; then
  exit 0
else
${Dir_dprep_exe}/${FInitBCexe} << endin
${ifile}
${ofile}
${Dir_ETAwrk}
endin
echo "${ofile}.ETAwrk" >> ${Dir_ETAwrk}/${ModelDrive}.ETAwrk.list
  if [ ! -s ${ofile}.ETAwrk ]  ; then
    echo "Verificar ${ifile}" >> ${Dir_ETAwrk}/${ModelDrive}.ETAwrk.list
    exit 1
  fi
fi
