      SUBROUTINE PROCESS
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C                .      .    .     
C SUBPROGRAM:    PROCESS     DRIVER FOR MAJOR POST ROUTINES.
C   PRGRMMR: TREADON         ORG: W/NP2      DATE: 92-12-21       
C     
C ABSTRACT:
C     THIS ROUTINE CALLS THE MAJOR POST PROCESSOR ROUTINES.
C     THESE ROUTINES ARE
C        ETAFLD2 - CALCULATE NMC SLP, SET BELOW SURFACE FIELDS,
C                  AND POSTS DATA ON ETA SURFACES.
C        ETA2P   - POSTS DATA ON ISOBARIC SURFACES.
C        SURFCE2 - POSTS SOUNDING DATA, SURFACE BASED FIELDS, 
C                  AND STATIC OR FIXED FIELDS.
C        CLDRAD  - POST SOUNDING/CLOUD/RADIATION FIELDS.
C        MISCLN  - POST MISCELLANEOUS (SPECIAL) FIELDS.
C        FIXED   - POST FIXED FIELDS.
C   .     
C     
C PROGRAM HISTORY LOG:
C   92-12-21  RUSS TREADON
C   98-06-01  T BLACK - CONVERSION OF POST FROM 1-D TO 2-D
C   00-01-05  JIM TUCCILLO - MPI VERSION
C   00-07-01  H CHUANG - ADDED CALLS TO SIG2P
C   00-09-22  H CHUANG - ADDED OPTIONS TO INTERPOLATE FIELDS FROM SIGMA
C             TO PRESSURE LEVELS USING SPINE (ADOPTED from Janjic)  
C     
C USAGE:    CALL PROCESS
C   INPUT ARGUMENT LIST:
C     NONE     
C
C   OUTPUT ARGUMENT LIST: 
C     NONE
C     
C   OUTPUT FILES:
C     NONE
C     
C   SUBPROGRAMS CALLED:
C     UTILITIES:
C       ETAFLD2  - POST DATA ETA SURFACES.
C       ETA2P    - POST DATA ON PRESSURE SURFACES.
C       SURFCE2  - POST SURFACE BASED FIELDS.
C       CLDRAD   - POST SOUNDING/CLOUD/RADIATION FIELDS.
C       MISCLN   - POST MISCELLANEOUS FIELDS.
C       FIXED    - POST FIXED FIELDS.
C     LIBRARY:
C       COMMON   - OUTGRD
C     
C   ATTRIBUTES:
C     LANGUAGE: FORTRAN
C     MACHINE : CRAY C-90
C$$$  
C
C     
C     INCLUDE PARAMETERS.
      INCLUDE "parmout"
C
C     DECLARE VARIABLES.
C     
      CHARACTER*6  DATSET,PROJ
      LOGICAL NORTH,SIGMA
C     
C     INCLUDE I/O COMMON BLOCK.
      INCLUDE "OUTGRD.comm"
      INCLUDE "CTLBLK.comm"
c
      common/tim_info/ETAFLD2_tim,ETA2P_tim,SURFCE2_tim, CLDRAD_tim,
     *                MISCLN_tim,FIXED_tim
C
C****************************************************************************
C     START SUBROUTINE PROCESS.
C
C     
C     COMPUTE/POST FIELDS ON ETA SURFACES.
C
      btim = timef()
      CALL ETAFLD2(IGOUT,JGOUT)
      ETAFLD2_tim = ETAFLD2_tim +(timef() - btim)
C
C     COMPUTE/POST FIELDS ON PRESSURE SURFACES.
      btim = timef()
cc      SPLINE=.TRUE.
CHOU 20230201      IF(SIGMA)THEN
CHOU 20230201       IF(SPLINE)THEN
CHOU 20230201        print*,'calling sig2pspline'
CHOU 20230201        CALL SIG2PSPLINE(IGOUT,JGOUT) 
CHOU 20230201       ELSE 
CHOU 20230201        print*,'calling sig2p'
CHOU 20230201        CALL SIG2P(IGOUT,JGOUT)
CHOU 20230201       END IF
CHOU 20230201      ELSE
       CALL ETA2P(IGOUT,JGOUT)
CHOU 20230201      END IF
      ETA2P_tim = ETA2P_tim +(timef() - btim)
C
C     COMPUTE/POST SURFACE RELATED FIELDS.
      btim = timef()
      CALL SURFCE2(IGOUT,JGOUT)
      SURFCE2_tim = SURFCE2_tim +(timef() - btim)
C
C     COMPUTE/POST SOUNDING AND CLOUD RELATED FIELDS.
      btim = timef()
      CALL CLDRAD(IGOUT,JGOUT)
      CLDRAD_tim = CLDRAD_tim +(timef() - btim)
C
C     COMPUTE/POST TROPOPAUSE DATA, FD LEVEL FIELDS,
C     FREEZING LEVEL HEIGHT AND RH, BOUNDARY LAYER FIELDS,
C     AND LFM-NGM LOOK-ALIKE FIELDS.
      btim = timef()
      CALL MISCLN(IGOUT,JGOUT)
      MISCLN_tim = MISCLN_tim +(timef() - btim)
C
C     POST FIXED FIELDS.
      btim = timef()
      CALL FIXED(IGOUT,JGOUT)
      FIXED_tim =  FIXED_tim +(timef() - btim)
C     
C     END OF ROUTINE.
C     
      RETURN
      END
