PROGRAM MAIN
USE data_parameters , ONLY : &
    ireals,                  & ! KIND-type parameter for real variables
    iintegers                  ! KIND-type parameter for "normal" integer variables
USE flake_derivedtypes         ! Definitions of several derived TYPEs

 IMPLICIT NONE
!  Input (procedure arguments)
!REAL (KIND = ireals), INTENT(IN) ::   &
REAL (KIND = ireals) :: dMsnowdt_in   ! The rate of snow accumulation [kg m^{-2} s^{-1}]
REAL (KIND = ireals) :: I_atm_in      ! Solar radiation flux at the surface [W m^{-2}]
REAL (KIND = ireals) :: Q_atm_lw_in   ! Long-wave radiation flux from the atmosphere [W m^{-2}]
REAL (KIND = ireals) :: height_u_in   ! Height above the lake surface where the wind speed is measured [m]
REAL (KIND = ireals) :: height_tq_in  ! Height where temperature and humidity are measured [m]
REAL (KIND = ireals) :: U_a_in        ! Wind speed at z=height_u_in [m s^{-1}]
REAL (KIND = ireals) :: T_a_in        ! Air temperature at z=height_tq_in [K]
REAL (KIND = ireals) :: q_a_in        ! Air specific humidity at z=height_tq_in
REAL (KIND = ireals) :: P_a_in        ! Surface air pressure [N m^{-2} = kg m^{-1} s^{-2}]

!REAL (KIND = ireals), INTENT(IN) ::   &
REAL (KIND = ireals) :: depth_w       ! The lake depth [m]
REAL (KIND = ireals) :: fetch         ! Typical wind fetch [m]
REAL (KIND = ireals) :: depth_bs      ! Depth of the thermally active layer of the bottom sediments [m]
REAL (KIND = ireals) :: T_bs          ! Temperature at the outer edge of 
                                      ! the thermally active layer of the bottom sediments [K]
REAL (KIND = ireals) :: par_Coriolis  ! The Coriolis parameter [s^{-1}]
REAL (KIND = ireals) :: del_time      ! The model time step [s]

!REAL (KIND = ireals), INTENT(IN)  :: &
REAL (KIND = ireals) :: T_snow_in   ! Temperature at the air-snow interface [K] 
REAL (KIND = ireals) :: T_ice_in    ! Temperature at the snow-ice or air-ice interface [K]
REAL (KIND = ireals) :: T_mnw_in    ! Mean temperature of the water column [K]
REAL (KIND = ireals) :: T_wML_in    ! Mixed-layer temperature [K]
REAL (KIND = ireals) :: T_bot_in    ! Temperature at the water-bottom sediment interface [K]
REAL (KIND = ireals) :: T_B1_in     ! Temperature at the bottom of the upper layer of the sediments [K]
REAL (KIND = ireals) :: C_T_in      ! Shape factor (thermocline)
REAL (KIND = ireals) :: h_snow_in   ! Snow thickness [m]
REAL (KIND = ireals) :: h_ice_in    ! Ice thickness [m]
REAL (KIND = ireals) :: h_ML_in     ! Thickness of the mixed-layer [m]
REAL (KIND = ireals) :: H_B1_in     ! Thickness of the upper layer of bottom sediments [m]
REAL (KIND = ireals) :: T_sfc_p     ! Surface temperature at the previous time step [K]  

!  Input/Output (procedure arguments)

!REAL (KIND = ireals), INTENT(INOUT)  :: &
REAL (KIND = ireals) ::   albedo_water ! Water surface albedo with respect to the solar radiation
REAL (KIND = ireals) ::   albedo_ice   ! Ice surface albedo with respect to the solar radiation
REAL (KIND = ireals) ::   albedo_snow  ! Snow surface albedo with respect to the solar radiation

TYPE (opticpar_medium) :: & 
  opticpar_water                       , & ! Optical characteristics of water
  opticpar_ice                         , & ! Optical characteristics of ice
  opticpar_snow                            ! Optical characteristics of snow 

!  Output (procedure arguments)

!REAL (KIND = ireals), INTENT(OUT)  :: &
REAL (KIND = ireals) :: T_snow_out   ! Temperature at the air-snow interface [K] 
REAL (KIND = ireals) :: T_ice_out    ! Temperature at the snow-ice or air-ice interface [K]
REAL (KIND = ireals) :: T_mnw_out    ! Mean temperature of the water column [K]
REAL (KIND = ireals) :: T_wML_out    ! Mixed-layer temperature [K]
REAL (KIND = ireals) :: T_bot_out    ! Temperature at the water-bottom sediment interface [K]
REAL (KIND = ireals) :: T_B1_out     ! Temperature at the bottom of the upper layer of the sediments [K]
REAL (KIND = ireals) :: C_T_out      ! Shape factor (thermocline)
REAL (KIND = ireals) :: h_snow_out   ! Snow thickness [m]
REAL (KIND = ireals) :: h_ice_out    ! Ice thickness [m]
REAL (KIND = ireals) :: h_ML_out     ! Thickness of the mixed-layer [m]
REAL (KIND = ireals) :: H_B1_out     ! Thickness of the upper layer of bottom sediments [m]
REAL (KIND = ireals) :: T_sfc_n      ! Updated surface temperature [K]  

 CALL flake_interface ( dMsnowdt_in, I_atm_in, Q_atm_lw_in, height_u_in, height_tq_in,     &
                             U_a_in, T_a_in, q_a_in, P_a_in,                                    &
                             
                             depth_w, fetch, depth_bs, T_bs, par_Coriolis, del_time,            &
                             T_snow_in,  T_ice_in,  T_mnw_in,  T_wML_in,  T_bot_in,  T_B1_in,   &
                             C_T_in,  h_snow_in,  h_ice_in,  h_ML_in,  H_B1_in, T_sfc_p,        &
                             
                             albedo_water,   albedo_ice,   albedo_snow,                         &
                             opticpar_water, opticpar_ice, opticpar_snow,                       &

                             T_snow_out, T_ice_out, T_mnw_out, T_wML_out, T_bot_out, T_B1_out,  & 
                             C_T_out, h_snow_out, h_ice_out, h_ML_out, H_B1_out, T_sfc_n )

END PROGRAM Main
