    MODULE OPTIONS
!>--------------------------------------------------------------------------------------------------
!> MODULE OPTIONS
!>
!> ABSTRACT:
!> MODULE OPTIONS CONTAINS USER OPTIONS
!> SPVAL : FLAG FOR MISSING DATA ON OUTPUT GRID. THIS CAN ARISE IF OUTPUT GRID EXTENDS BEYOND THE 
!>         FILLED E-GRID.
!>
!> IBESSL: SWITCH FOR TYPE OF HORIZONTAL INTERPOLATION FROM FILLED E-GRID TO OUTPUT GRID.
!>         -1 = 4-POINT LINEAR INTERPOLATION SCHEME WITH GRADIENT CORRECTION. THIS OPTION IS NOT 
!>         AVAILABLE
!>         0 =  4-POINT LINEAR INTERPOLATION SCHEME
!>         1 = 16-POINT BESSEL INTERPOLATION SCHEME. THIS OPTION IS NOT AVAILABLE.
!>
!> KSB   : SQUARE ROOT OF THE NUMBER OF SUB-BOXES WHICH SUBROUTINE CETLIH USES. SUBROUTINE CETLIH 
!>         INTERPOLATES A H-POINT ETA GRID FIELD TO AN OUTPUT GRID CONSERVING THE AREA INTEGRAL OF 
!>         THE E-GRID FIELD.  
!>         WHEN INTERPOLATING PRECIP AMOUNT TO A COARSER RESOLUTION GRID, KSB = 3 IS A GOOD CHOICE.  
!>         IF INTERPOLATING TO A FINER RESOLUTION GRID, KSB = 8 IS A GOOD CHOICE.
!>
!> IOFFS : PLUS/MINUS NUMBER OF POINTS ABOUT SOUTHWEST CORNER OUTPUT GRID POINT OVER WHICH CETLIH4.F
!>	   SEARCHES THE CLOSEST OUTPUT GRID POINT TO EACH SUB-BOX. WHEN INTERPOLATING TO A COARSER 
!>         RESOLUTION GRID, IOFFS=2 OR 3 IS A GOOD CHOICE.
!>         IF INTERPOLATING TO A FINER RESOLUTION GRID, IOFFS = 5 OR 6 IS A GOOD CHOICE.
!>
!> IFLAG : CONTROLS OUTPUT FROM FILLV
!>	   IFLAG = 0 -> TAKE WHAT INTERPOLATION GIVES
!>	   IFLAG = 1 -> TRUNCATE OUTPUT AT ZERO
!>	   IFLAG = 2 -> TRUNCATE AT A VERY SMALL
!>
!> POSITIVE NUMBER (EPS)
!>
!> SATDEL: FRACTIONAL VARIATION OF SATURATION. SUBROUTINE NLYLI (N-LAYER LIFTED INDEX) LIFTS A 
!>         MODIFIED PARCEL.
!>         PARCEL SPECIFIC HUMIDITY IS MODIFIED ACCORDING TO THE FORMULA QMOD = (1+SATDEL) * QGIVEN.
!>         THE NGM USES SATDEL = 0.05
!>
!> USE MODULES: F77KINDS
!>
!> DRIVER     : SURFCE
!>--------------------------------------------------------------------------------------------------
    USE F77KINDS
!
    IMPLICIT NONE
!
    SAVE
!
    INTEGER(KIND=I4KIND)                                                                        ::&
    & SPVAL   , IBESSL  , KSB     , IOFFS   , IFLAG   
!
    REAL   (KIND=R4KIND)                                                                        ::&
    & SATDEL
!
    DATA SPVAL  / 99999      /
    DATA IBESSL /     0      /
    DATA KSB    /     3      /
    DATA IOFFS  /     2      /
    DATA IFLAG  /     0      /
    DATA SATDEL /     0.05   /
!
    END MODULE OPTIONS
