    MODULE O3DATA
!>--------------------------------------------------------------------------------------------------
!> MODULE O3DATA
!>
!> ABSTRACT:
!> CREATED FROM O3CLIM BLOCK DATA
!>
!> USE MODULES: F77KINDS
!>
!> DRIVER     : O3CLIM 
!>--------------------------------------------------------------------------------------------------
    USE F77KINDS
!
    IMPLICIT NONE
!
    SAVE
!
    REAL   (KIND=R4KIND), DIMENSION(33)                                                         ::& 
    & P2
!
    REAL   (KIND=R4KIND), DIMENSION(37)                                                         ::& 
    & PH2
!
    REAL   (KIND=R4KIND), DIMENSION(45)                                                         ::& 
    & PH1
!
    REAL   (KIND=R4KIND), DIMENSION(48)                                                         ::& 
    & P1
!
    REAL   (KIND=R4KIND), DIMENSION(10, 9)                                                      ::& 
    & O3HI2
!
    REAL   (KIND=R4KIND), DIMENSION(10,16)                                                      ::&
    & O3HI1   ,                                                                                   &
    & O3LO1   , O3LO2   , O3LO3   , O3LO4
!------------
! FROM O3CLIM
!------------
    REAL   (KIND=R4KIND), DIMENSION(10,25)                                                      ::& 
    & O3HI   
!
    REAL   (KIND=R4KIND), DIMENSION(82)                                                         ::& 
    & PH
!
    REAL   (KIND=R4KIND), DIMENSION(81)                                                         ::& 
    & P
!
    EQUIVALENCE (O3HI1(1,1), O3HI(1,1)), (O3HI2(1,1), O3HI(1,17)),                                &
    &           (  PH1(1)  ,   PH(1)  ), (  PH2(1)  ,   PH(46)  ),                                &
    &           (   P1(1)  ,    P(1)  ), (   P2(1)  ,    P(49)  )
!
    DATA PH1/                                                                                     &
    &   0., 0.1027246E-04, 0.1239831E-04, 0.1491845E-04, 0.1788053E-04,                           &
    &       0.2135032E-04, 0.2540162E-04, 0.3011718E-04, 0.3558949E-04,                           &
    &       0.4192172E-04, 0.4922875E-04, 0.5763817E-04, 0.6729146E-04,                           &
    &       0.7834518E-04, 0.9097232E-04, 0.1053635E-03, 0.1217288E-03,                           &
    &       0.1402989E-03, 0.1613270E-03, 0.1850904E-03, 0.2119495E-03,                           &
    &       0.2423836E-03, 0.2768980E-03, 0.3160017E-03, 0.3602623E-03,                           &
    &       0.4103126E-03, 0.4668569E-03, 0.5306792E-03, 0.6026516E-03,                           &
    &       0.6839018E-03, 0.7759249E-03, 0.8803303E-03, 0.9987843E-03,                           &
    &       0.1133178E-02, 0.1285955E-02, 0.1460360E-02, 0.1660001E-02,                           &
    &       0.1888764E-02, 0.2151165E-02, 0.2452466E-02, 0.2798806E-02,                           &
    &       0.3197345E-02, 0.3656456E-02, 0.4185934E-02, 0.4797257E-02/ 
!
    DATA PH2/                                                                                     &
    &       0.5503893E-02, 0.6321654E-02, 0.7269144E-02, 0.8368272E-02,                           &
    &       0.9644873E-02, 0.1112946E-01, 0.1285810E-01, 0.1487354E-01,                           &
    &       0.1722643E-01, 0.1997696E-01, 0.2319670E-01, 0.2697093E-01,                           &
    &       0.3140135E-01, 0.3660952E-01, 0.4274090E-01, 0.4996992E-01,                           &
    &       0.5848471E-01, 0.6847525E-01, 0.8017242E-01, 0.9386772E-01,                           &
    &       0.1099026E00 , 0.1286765E00 , 0.1506574E00 , 0.1763932E00 ,                           &
    &       0.2065253E00 , 0.2415209E00 , 0.2814823E00 , 0.3266369E00 ,                           &
    &       0.3774861E00 , 0.4345638E00 , 0.4984375E00 , 0.5697097E00 ,                           &
    &       0.6490189E00 , 0.7370409E00 , 0.8344896E00 , 0.9421190E00 ,                           &
    &       0.1000000E01/
!
    DATA P1/                                                                                      &
    &       0.9300000E-05, 0.1129521E-04, 0.1360915E-04, 0.1635370E-04,                           &
    &       0.1954990E-04, 0.2331653E-04, 0.2767314E-04, 0.3277707E-04,                           &
    &       0.3864321E-04, 0.4547839E-04, 0.5328839E-04, 0.6234301E-04,                           &
    &       0.7263268E-04, 0.8450696E-04, 0.9793231E-04, 0.1133587E-03,                           &
    &       0.1307170E-03, 0.1505832E-03, 0.1728373E-03, 0.1982122E-03,                           &
    &       0.2266389E-03, 0.2592220E-03, 0.2957792E-03, 0.3376068E-03,                           &
    &       0.3844381E-03, 0.4379281E-03, 0.4976965E-03, 0.5658476E-03,                           &
    &       0.6418494E-03, 0.7287094E-03, 0.8261995E-03, 0.9380076E-03,                           &
    &       0.1063498E-02, 0.1207423E-02, 0.1369594E-02, 0.1557141E-02,                           &
    &       0.1769657E-02, 0.2015887E-02, 0.2295520E-02, 0.2620143E-02,                           &
    &       0.2989651E-02, 0.3419469E-02, 0.3909867E-02, 0.4481491E-02,                           &
    &       0.5135272E-02, 0.5898971E-02, 0.6774619E-02, 0.7799763E-02/
!
    DATA P2/                                                                                      &
    &       0.8978218E-02, 0.1036103E-01, 0.1195488E-01, 0.1382957E-01,                           &
    &       0.1599631E-01, 0.1855114E-01, 0.2151235E-01, 0.2501293E-01,                           &
    &       0.2908220E-01, 0.3390544E-01, 0.3952926E-01, 0.4621349E-01,                           &
    &       0.5403168E-01, 0.6330472E-01, 0.7406807E-01, 0.8677983E-01,                           &
    &       0.1015345E00 , 0.1189603E00 , 0.1391863E00 , 0.1630739E00 ,                           &
    &       0.1908004E00 , 0.2235461E00 , 0.2609410E00 , 0.3036404E00 ,                           &
    &       0.3513750E00 , 0.4055375E00 , 0.4656677E00 , 0.5335132E00 ,                           &
    &       0.6083618E00 , 0.6923932E00 , 0.7845676E00 , 0.8875882E00 ,                           &
    &       0.1000000E01/
!
    DATA O3HI1/                                                                                   &
    &  .55,  .50,  .45,  .45,  .40,  .35,  .35,  .30,  .30,  .30,  .55,  .51,  .46,  .47,  .42,   &
    &  .38,  .37,  .36,  .35,  .35,  .55,  .53,  .48,  .49,  .44,  .42,  .41,  .40,  .38,  .38,   &
    &  .60,  .55,  .52,  .52,  .50,  .47,  .46,  .44,  .42,  .41,  .65,  .60,  .55,  .56,  .53,   &
    &  .52,  .50,  .48,  .45,  .45,  .75,  .65,  .60,  .60,  .55,  .55,  .55,  .50,  .48,  .47,   &
    &  .80,  .75,  .75,  .75,  .70,  .70,  .65,  .63,  .60,  .60,  .90,  .85,  .85,  .80,  .80,   &
    &  .75,  .75,  .74,  .72,  .71, 1.10, 1.05, 1.00,  .90,  .90,  .90,  .85,  .83,  .80,  .80,   &
    & 1.40, 1.30, 1.25, 1.25, 1.25, 1.20, 1.15, 1.10, 1.05, 1.00, 1.7 , 1.7 , 1.6 , 1.6 , 1.6 ,   &
    & 1.6 , 1.6 , 1.6 , 1.5 , 1.5 , 2.1 , 2.0 , 1.9 , 1.9 , 1.9 , 1.8 , 1.8 , 1.8 , 1.7 , 1.7 ,   &
    & 2.4 , 2.3 , 2.2 , 2.2 , 2.2 , 2.1 , 2.1 , 2.1 , 2.0 , 2.0 , 2.7 , 2.5 , 2.5 , 2.5 , 2.5 ,   &
    & 2.5 , 2.4 , 2.4 , 2.3 , 2.3 , 2.9 , 2.8 , 2.7 , 2.7 , 2.7 , 2.7 , 2.7 , 2.7 , 2.6 , 2.6 ,   &
    & 3.1 , 3.1 , 3.0 , 3.0 , 3.0 , 3.0 , 3.0 , 3.0 , 2.9 , 2.8/
!
    DATA O3HI2/                                                                                   &
    &  3.3,  3.4,  3.4,  3.6,  3.7,  3.9,  4.0,  4.1,  4.0,  3.8,  3.6,  3.8,  3.9,  4.2,  4.7,   &
    &  5.3,  5.6,  5.7,  5.5,  5.2,  4.1,  4.3,  4.7,  5.2,  6.0,  6.7,  7.0,  6.8,  6.4,  6.2,   &
    &  5.4,  5.7,  6.0,  6.6,  7.3,  8.0,  8.4,  7.7,  7.1,  6.7,  6.7,  6.8,  7.0,  7.6,  8.3,   &
    & 10.0,  9.6,  8.2,  7.5,  7.2,  9.2,  9.3,  9.4,  9.6, 10.3, 10.6, 10.0,  8.5,  7.7,  7.3,   &
    & 12.6, 12.1, 12.0, 12.1, 11.7, 11.0, 10.0,  8.6,  7.8,  7.4, 14.2, 13.5, 13.1, 12.8, 11.9,   &
    & 10.9,  9.8,  8.5,  7.8,  7.5, 14.3, 14.0, 13.4, 12.7, 11.6, 10.6,  9.3,  8.4,  7.6,  7.3/
!
    DATA O3LO1/                                                                                   &
    & 14.9 , 14.2 , 13.3 , 12.5 , 11.2 , 10.3 ,  9.5 ,  8.6 ,  7.5 ,  7.4 , 14.5 , 14.1 , 13.0 ,  &
    & 11.8 , 10.5 ,  9.8 ,  9.2 ,  7.9 ,  7.4 ,  7.4 , 11.8 , 11.5 , 10.9 , 10.5 ,  9.9 ,  9.6 ,  &
    &  8.9 ,  7.5 ,  7.2 ,  7.2 ,  7.3 ,  7.7 ,  7.8 ,  8.4 ,  8.4 ,  8.5 ,  7.9 ,  7.4 ,  7.1 ,  &
    &  7.1 ,  4.1 ,  4.4 ,  5.3 ,  6.6 ,  6.9 ,  7.5 ,  7.4 ,  7.2 ,  7.0 ,  6.9 ,  1.8 ,  1.9 ,  &
    &  2.5 ,  3.3 ,  4.5 ,  5.8 ,  6.3 ,  6.3 ,  6.4 ,  6.1 ,  0.4 ,  0.5 ,  0.8 ,  1.2 ,  2.7 ,  &
    &  3.6 ,  4.6 ,  4.7 ,  5.0 ,  5.2 ,   .10,  .15 ,   .20,   .50,  1.4 ,  2.1 ,  3.0 ,  3.2 ,  &
    &  3.5 ,  3.9 ,   .07,   .10,   .12,   .30,  1.0 ,  1.4 ,  1.8 ,  1.9 ,  2.3 ,  2.5 ,   .06,  &
    &   .08,   .10,   .15,   .60,   .80,  1.4 ,  1.5 ,  1.5 ,  1.6 ,   .05,   .05,   .06,   .09,  &
    &   .20,   .40,   .70,   .80,   .90,   .90,   .05,   .05,   .06,   .08,   .10,   .13,   .20,  &
    &   .25,   .30,   .40,   .05,   .05,   .05,   .06,   .07,   .07,   .08,   .09,   .10,   .13,  &
    &   .05,   .05,   .05,   .05,   .06,   .06,   .06,   .06,   .07,   .07,   .05,   .05,   .05,  &
    &   .05,   .05,   .05,   .05,   .06,   .06,   .06,   .04,   .04,   .04,   .04,   .04,   .04,  &
    &   .04,   .05,   .05,   .05/
!
    DATA O3LO2/                                                                                   &
    & 14.8 , 14.2 , 13.8 , 12.2 , 11.0 ,  9.8 ,  8.5 ,  7.8 ,  7.4 ,  6.9 , 13.2 , 13.0 , 12.5 ,  &
    & 11.3 , 10.4 ,  9.0 ,  7.8 ,  7.5 ,  7.0 ,  6.6 , 10.6 , 10.6 , 10.7 , 10.1 ,  9.4 ,  8.6 ,  &
    &  7.5 ,  7.0 ,  6.5 ,  6.1 ,  7.0 ,  7.3 ,  7.5 ,  7.5 ,  7.5 ,  7.3 ,  6.7 ,  6.4 ,  6.0 ,  &
    &  5.8 ,  3.8 ,  4.0 ,  4.7 ,  5.0 ,  5.2 ,  5.9 ,  5.8 ,  5.6 ,  5.5 ,  5.5 ,  1.4 ,  1.6 ,  &
    &  2.4 ,  3.0 ,  3.7 ,  4.1 ,  4.6 ,  4.8 ,  5.1 ,  5.0 ,   .40,   .50,   .90,  1.2 ,  2.0 ,  &
    &  2.7 ,  3.2 ,  3.6 ,  4.3 ,  4.1 ,   .07,   .10,   .20,   .30,   .80,  1.4 ,  2.1 ,  2.4 ,  &
    &  2.7 ,  3.0 ,   .06,   .07,   .09,   .15,   .30,   .70,  1.2 ,  1.4 ,  1.6 ,  2.0 ,   .05,  &
    &   .05,   .06,   .12,   .15,   .30,   .60,   .70,   .80,   .80,   .04,   .05,   .06,   .08,  &
    &   .09,   .15,   .30,   .40,   .40,   .40,   .04,   .04,   .05,   .055,  .06,   .09,   .12,  &
    &   .13,   .15,   .15,   .03,   .03,   .045,  .052,  .055,  .06,   .07,   .07,   .06,   .07,  &
    &   .03,   .03,   .04,   .051,  .052,  .052,  .06,   .06,   .05,   .05,   .02,   .02,   .03,  &
    &   .05,   .05,   .05,   .04,   .04,   .04,   .04,   .02,   .02,   .02,   .04,   .04,   .04,  &
    &   .03,   .03,   .03,   .03/
!
    DATA O3LO3/                                                                                   &
    & 14.5 , 14.0 , 13.5 , 11.3 , 11.0 , 10.0 ,  9.0 ,  8.3 ,  7.5 ,  7.3 , 13.5 , 13.2 , 12.5 ,  &
    & 11.1 , 10.4 ,  9.7 ,  8.2 ,  7.8 ,  7.4 ,  6.8 , 10.8 , 10.9 , 11.0 , 10.4 , 10.0 ,  9.6 ,  &
    &  7.9 ,  7.5 ,  7.0 ,  6.7 ,  7.3 ,  7.5 ,  7.8 ,  8.5 ,  9.0 ,  8.5 ,  7.7 ,  7.4 ,  6.9 ,  &
    &  6.5 ,  4.1 ,  4.5 ,  5.3 ,  6.2 ,  7.3 ,  7.7 ,  7.3 ,  7.0 ,  6.6 ,  6.4 ,  1.8 ,  2.0 ,  &
    &  2.2 ,  3.8 ,  4.3 ,  5.6 ,  6.2 ,  6.2 ,  6.4 ,  6.2 ,   .30,   .50,   .60,  1.5 ,  2.8 ,  &
    &  3.7 ,  4.5 ,  4.7 ,  5.5 ,  5.6 ,   .09,   .10,   .15,   .60,  1.2 ,  2.1 ,  3.0 ,  3.5 ,  &
    &  4.0 ,  4.3 ,   .06,   .08,   .10,   .30,   .60,  1.1 ,  1.9 ,  2.2 ,  2.9 ,  3.0 ,   .04,  &
    &   .05,   .06,   .15,   .45,   .60,  1.1 ,  1.3 ,  1.6 ,  1.8 ,   .04,   .04,   .04,   .08,  &
    &   .20,   .30,   .55,   .60,   .75,   .90,   .04,   .04,   .04,   .05,   .06,   .10,   .12,  &
    &   .15,   .20,   .25,   .04,   .04,   .03,   .04,   .05,   .06,   .07,   .07,   .07,   .08,  &
    &   .03,   .03,   .04,   .05,   .05,   .05,   .05,   .05,   .05,   .05,   .03,   .03,   .03,  &
    &   .04,   .04,   .04,   .05,   .05,   .04,   .04,   .02,   .02,   .02,   .04,   .04,   .04,  &
    &   .04,   .04,   .03,   .03/
!
    DATA O3LO4/                                                                                   &
    & 14.2 , 13.8 , 13.2 , 12.5 , 11.7 , 10.5 ,  8.6 ,  7.8 ,  7.5 ,  6.6 , 12.5 , 12.4 , 12.2 ,  &
    & 11.7 , 10.8 ,  9.8 ,  7.8 ,  7.2 ,  6.5 ,  6.1 , 10.6 , 10.5 , 10.4 , 10.1 ,  9.6 ,  9.0 ,  &
    &  7.1 ,  6.8 ,  6.1 ,  5.9 ,  7.0 ,  7.4 ,  7.9 ,  7.8 ,  7.6 ,  7.3 ,  6.2 ,  6.1 ,  5.8 ,  &
    &  5.6 ,  4.2 ,  4.6 ,  5.1 ,  5.6 ,  5.9 ,  5.9 ,  5.9 ,  5.8 ,  5.6 ,  5.3 ,  2.1 ,  2.3 ,  &
    &  2.6 ,  2.9 ,  3.5 ,  4.3 ,  4.8 ,  4.9 ,  5.1 ,  5.1 ,  0.7 ,  0.8 ,  1.0 ,  1.5 ,  2.0 ,  &
    &  2.8 ,  3.5 ,  3.6 ,  3.7 ,  4.0 ,   .15,   .20,   .40,   .50,   .60,  1.4 ,  2.1 ,  2.2 ,  &
    &  2.3 ,  2.5 ,   .08,   .10,   .15,   .25,   .30,   .90,  1.2 ,  1.3 ,  1.4 ,  1.6 ,   .07,  &
    &   .08,   .10,   .14,   .20,   .50,   .70,   .90,   .90,   .80,   .05,   .06,   .08,   .12,  &
    &   .14,   .20,   .35,   .40,   .60,   .50,   .05,   .05,   .08,   .09,   .09,   .09,   .11,  &
    &   .12,   .15,   .18,   .04,   .05,   .06,   .07,   .07,   .08,   .08,   .08,   .08,   .08,  &
    &   .04,   .04,   .05,   .07,   .07,   .07,   .07,   .07,   .06,   .05,   .02,   .02,   .04,  &
    &   .05,   .05,   .05,   .05,   .05,   .04,   .04,   .02,   .02,   .03,   .04,   .04,   .04,  &
    &   .04,   .04,   .03,   .03/
!
    END MODULE O3DATA
