    MODULE BANDTA
!>--------------------------------------------------------------------------------------------------
!> MODULE BANDTA
!>
!> ABSTRACT:
!> MODULE BANDTA CONTAINS RANDOM BAND PARAMETERS FOR THE LW CALCULATIONS USING 10 CM-1 WIDE 
!> BANDS. THE 15 UM CO2 COMPLEX IS 2 BANDS, 560-670 AND 670-800 CM-1. 
!> OZONE COEFFICIENTS ARE IN 3 BANDS, 670-800 (14.1 UM), 990-1070 AND 1070-1200 (9.6 UM).
!> THE (NBLW) BANDS NOW INCLUDE:
!>
!>  56 BANDS, 10  CM-1 WIDE    0  -    560 CM-1
!>   2 BANDS, 15 UM COMPLEX  560  -    670 CM-1
!>                           670  -    800 CM-1
!>   3 "CONTINUUM" BANDS     800  -    900 CM-1
!>                           900  -    990 CM-1
!>                          1070  -   1200 CM-1
!>   1 BAND FOR 9.6 UM BAND  990  -   1070 CM-1
!> 100 BANDS, 10 CM-1 WIDE  1200  -   2200 CM-1
!>   1 BAND FOR 4.3 UM SRC  2270  -   2380 CM-1
!>
!> THUS NBLW PRESENTLY EQUALS 163
!>
!> ALL BANDS ARE ARRANGED IN ORDER OF INCREASING WAVENUMBER
!>
!> ARNDM    - RANDOM "A" PARAMETER FOR (NBLW) BANDS
!> BRNDM    - RANDOM "B" PARAMETER FOR (NBLW) BANDS
!> BETAD    - CONTINUUM COEFFICIENTS FOR (NBLW) BANDS
!> AP , BP  - CAPPHI COEFFICIENTS FOR (NBLW) BANDS
!> ATP, BTP - CAPPSI COEFFICIENTS FOR (NBLW) BANDS
!> BANDLO   - LOWEST FREQUENCY IN EACH OF (NBLW) FREQ. BANDS
!> BANDHI   - HIGHEST FREQUENCY IN EACH OF (NBLW) FREQ. BANDS
!> AO3RND   - RANDOM "A" PARAMETER FOR OZONE IN (3) OZONE BANDS
!> BO3RND   - RANDOM "B" PARAMETER FOR OZONE IN (3) OZONE BANDS
!> AB15     - THE PRODUCT ARNDM*BRNDM FOR THE TWO BANDS REPRESENTING THE 15 UM BAND COMPLEX OF CO2
!>
!> DATA FOR ARNDM, BRNDM, AP, BP, ATP, BTP, AO3RND, BO3RND ARE OBTAINED BY USING THE AFGL 1982 CAT. 
!> CONTINUUM COEFFICIENTS ARE FROM ROBERTS 1976.
!>
!> USE MODULES: F77KINDS
!>              RDPARM
!>
!> DRIVER     : RNDDTA
!>--------------------------------------------------------------------------------------------------
    USE F77KINDS
    USE RDPARM, ONLY : NBLW
!
    IMPLICIT NONE
!
    SAVE
!  
    REAL   (KIND=R4KIND), DIMENSION(NBLW)                                                       ::&
    & ARNDM   , BRNDM   , BETAD   , AP      , BP      , ATP     , BTP     , BANDLO  , BANDHI
!
    REAL   (KIND=R4KIND), DIMENSION(3)                                                          ::&
    & AO3RND  , BO3RND  , AB15
!------------
! FROM GFDLRD
!------------
    REAL   (KIND=R4KIND), DIMENSION(64)                                                         ::&
    & ARNDM1  , ARNDM2  ,                                                                         &
    & BRNDM1  , BRNDM2  ,                                                                         &
    & AP1     , AP2     ,                                                                         &
    & BP1     , BP2     ,                                                                         &
    & ATP1    , ATP2    ,                                                                         &
    & BTP1    , BTP2    ,                                                                         &
    & BETAD1  , BETAD2  ,                                                                         &
    & BANDL1  , BANDL2  ,                                                                         &
    & BANDH1  , BANDH2   
!
    REAL   (KIND=R4KIND), DIMENSION(35)                                                         ::&
    & ARNDM3  ,                                                                                   &
    & BRNDM3  ,                                                                                   &
    & AP3     ,                                                                                   &
    & BP3     ,                                                                                   &
    & ATP3    ,                                                                                   &
    & BTP3    ,                                                                                   &
    & BETAD3  ,                                                                                   &
    & BANDL3  ,                                                                                   &
    & BANDH3
!    
    EQUIVALENCE (ARNDM1(1),  ARNDM(1)), (ARNDM2(1),  ARNDM(65)), (ARNDM3(1),  ARNDM(129))
    EQUIVALENCE (BRNDM1(1),  BRNDM(1)), (BRNDM2(1),  BRNDM(65)), (BRNDM3(1),  BRNDM(129))
    EQUIVALENCE (   AP1(1),     AP(1)), (   AP2(1),     AP(65)), (   AP3(1),     AP(129))
    EQUIVALENCE (   BP1(1),     BP(1)), (   BP2(1),     BP(65)), (   BP3(1),     BP(129))
    EQUIVALENCE (  ATP1(1),    ATP(1)), (  ATP2(1),    ATP(65)), (  ATP3(1),    ATP(129))
    EQUIVALENCE (  BTP1(1),    BTP(1)), (  BTP2(1),    BTP(65)), (  BTP3(1),    BTP(129))
    EQUIVALENCE (BETAD1(1),  BETAD(1)), (BETAD2(1),  BETAD(65)), (BETAD3(1),  BETAD(129))
    EQUIVALENCE (BANDL1(1), BANDLO(1)), (BANDL2(1), BANDLO(65)), (BANDL3(1), BANDLO(129))
    EQUIVALENCE (BANDH1(1), BANDHI(1)), (BANDH2(1), BANDHI(65)), (BANDH3(1), BANDHI(129))
!--------------------------------------------------------------------------------------------------
! THE FOLLOWING DATA STATEMENTS ARE BAND PARAMETERS OBTAINED USING THE 1982 AFGL CATALOG ON THE 
! SPECIFIED BANDS
!--------------------------------------------------------------------------------------------------
    DATA ARNDM1  /                                                                                &
    & 0.354693E+00,  0.269857E+03,  0.167062E+03,  0.201314E+04, 0.964533E+03,  0.547971E+04,     &
    & 0.152933E+04,  0.599429E+04,  0.699329E+04,  0.856721E+04, 0.962489E+04,  0.233348E+04,     &
    & 0.127091E+05,  0.104383E+05,  0.504249E+04,  0.181227E+05, 0.856480E+03,  0.136354E+05,     &
    & 0.288635E+04,  0.170200E+04,  0.209761E+05,  0.126797E+04, 0.110096E+05,  0.336436E+03,     &
    & 0.491663E+04,  0.863701E+04,  0.540389E+03,  0.439786E+04, 0.347836E+04,  0.130557E+03,     &
    & 0.465332E+04,  0.253086E+03,  0.257387E+04,  0.488041E+03, 0.892991E+03,  0.117148E+04,     &
    & 0.125880E+03,  0.458852E+03,  0.142975E+03,  0.446355E+03, 0.302887E+02,  0.394451E+03,     &
    & 0.438112E+02,  0.348811E+02,  0.615503E+02,  0.143165E+03, 0.103958E+02,  0.725108E+02,     &
    & 0.316628E+02,  0.946456E+01,  0.542675E+02,  0.351557E+02, 0.301797E+02,  0.381010E+01,     &
    & 0.126319E+02,  0.548010E+01,  0.600199E+01,  0.640803E+00, 0.501549E-01,  0.167961E-01,     &
    & 0.178110E-01,  0.170166E+00,  0.273514E-01,  0.983767E+00 /
!
    DATA ARNDM2  /                                                                                &
    & 0.753946E+00,  0.941763E-01,  0.970547E+00,  0.268862E+00, 0.564373E+01,  0.389794E+01,     &
    & 0.310955E+01,  0.128235E+01,  0.196414E+01,  0.247113E+02, 0.593435E+01,  0.377552E+02,     &
    & 0.305173E+02,  0.852479E+01,  0.116780E+03,  0.101490E+03, 0.138939E+03,  0.324228E+03,     &
    & 0.683729E+02,  0.471304E+03,  0.159684E+03,  0.427101E+03, 0.114716E+03,  0.106190E+04,     &
    & 0.294607E+03,  0.762948E+03,  0.333199E+03,  0.830645E+03, 0.162512E+04,  0.525676E+03,     &
    & 0.137739E+04,  0.136252E+04,  0.147164E+04,  0.187196E+04, 0.131118E+04,  0.103975E+04,     &
    & 0.621637E+01,  0.399459E+02,  0.950648E+02,  0.943161E+03, 0.526821E+03,  0.104150E+04,     &
    & 0.905610E+03,  0.228142E+04,  0.806270E+03,  0.691845E+03, 0.155237E+04,  0.192241E+04,     &
    & 0.991871E+03,  0.123907E+04,  0.457289E+02,  0.146146E+04, 0.319382E+03,  0.436074E+03,     &
    & 0.374214E+03,  0.778217E+03,  0.140227E+03,  0.562540E+03, 0.682685E+02,  0.820292E+02,     &
    & 0.178779E+03,  0.186150E+03,  0.383864E+03,  0.567416E+01 /
!
    DATA ARNDM3  /                                                                                &
    & 0.225129E+03,  0.473099E+01,  0.753149E+02,  0.233689E+02, 0.339802E+02,  0.108855E+03,     &
    & 0.380016E+02,  0.151039E+01,  0.660346E+02,  0.370165E+01, 0.234169E+02,  0.440206E+00,     &
    & 0.615283E+01,  0.304077E+02,  0.117769E+01,  0.125248E+02, 0.142652E+01,  0.241831E+00,     &
    & 0.483721E+01,  0.226357E-01,  0.549835E+01,  0.597067E+00, 0.404553E+00,  0.143584E+01,     &
    & 0.294291E+00,  0.466273E+00,  0.156048E+00,  0.656185E+00, 0.172727E+00,  0.118349E+00,     &
    & 0.141598E+00,  0.588581E-01,  0.919409E-01,  0.155521E-01, 0.537083E-02 /
!
    DATA BRNDM1  /                                                                                &
    & 0.789571E-01,  0.920256E-01,  0.696960E-01,  0.245544E+00, 0.188503E+00,  0.266127E+00,     &
    & 0.271371E+00,  0.330917E+00,  0.190424E+00,  0.224498E+00, 0.282517E+00,  0.130675E+00,     &
    & 0.212579E+00,  0.227298E+00,  0.138585E+00,  0.187106E+00, 0.194527E+00,  0.177034E+00,     &
    & 0.115902E+00,  0.118499E+00,  0.142848E+00,  0.216869E+00, 0.149848E+00,  0.971585E-01,     &
    & 0.151532E+00,  0.865628E-01,  0.764246E-01,  0.100035E+00, 0.171133E+00,  0.134737E+00,     &
    & 0.105173E+00,  0.860832E-01,  0.148921E+00,  0.869234E-01, 0.106018E+00,  0.184865E+00,     &
    & 0.767454E-01,  0.108981E+00,  0.123094E+00,  0.177287E+00, 0.848146E-01,  0.119356E+00,     &
    & 0.133829E+00,  0.954505E-01,  0.155405E+00,  0.164167E+00, 0.161390E+00,  0.113287E+00,     &
    & 0.714720E-01,  0.741598E-01,  0.719590E-01,  0.140616E+00, 0.355356E-01,  0.832779E-01,     &
    & 0.128680E+00,  0.983013E-01,  0.629660E-01,  0.643346E-01, 0.717082E-01,  0.629730E-01,     &
    & 0.875182E-01,  0.857907E-01,  0.358808E+00,  0.178840E+00 /
!
    DATA BRNDM2  /                                                                                &
    & 0.254265E+00,  0.297901E+00,  0.153916E+00,  0.537774E+00, 0.267906E+00,  0.104254E+00,     &
    & 0.400723E+00,  0.389670E+00,  0.263701E+00,  0.338116E+00, 0.351528E+00,  0.267764E+00,     &
    & 0.186419E+00,  0.238237E+00,  0.210408E+00,  0.176869E+00, 0.114715E+00,  0.173299E+00,     &
    & 0.967770E-01,  0.172565E+00,  0.162085E+00,  0.157782E+00, 0.886832E-01,  0.242999E+00,     &
    & 0.760298E-01,  0.164248E+00,  0.221428E+00,  0.166799E+00, 0.312514E+00,  0.380600E+00,     &
    & 0.353828E+00,  0.269500E+00,  0.254759E+00,  0.285408E+00, 0.159764E+00,  0.721058E-01,     &
    & 0.170528E+00,  0.231595E+00,  0.307184E+00,  0.564136E-01, 0.159884E+00,  0.147907E+00,     &
    & 0.185666E+00,  0.183567E+00,  0.182482E+00,  0.230650E+00, 0.175348E+00,  0.195978E+00,     &
    & 0.255323E+00,  0.198517E+00,  0.195500E+00,  0.208356E+00, 0.309603E+00,  0.112011E+00,     &
    & 0.102570E+00,  0.128276E+00,  0.168100E+00,  0.177836E+00, 0.105533E+00,  0.903330E-01,     &
    & 0.126036E+00,  0.101430E+00,  0.124546E+00,  0.221406E+00 /
!
    DATA BRNDM3  /                                                                                &
    & 0.137509E+00,  0.911365E-01,  0.724508E-01,  0.795788E-01, 0.137411E+00,  0.549175E-01,     & 
    & 0.787714E-01,  0.165544E+00,  0.136484E+00,  0.146729E+00, 0.820496E-01,  0.846211E-01,     &
    & 0.785821E-01,  0.122527E+00,  0.125359E+00,  0.101589E+00, 0.155756E+00,  0.189239E+00,     &
    & 0.999086E-01,  0.480993E+00,  0.100233E+00,  0.153754E+00, 0.130780E+00,  0.136136E+00,     &
    & 0.159353E+00,  0.156634E+00,  0.272265E+00,  0.186874E+00, 0.192090E+00,  0.135397E+00,     &
    & 0.131497E+00,  0.127463E+00,  0.227233E+00,  0.190562E+00,  0.214005E+00 /
!
    DATA AP1     /                                                                                &
    & -0.675950E-02, -0.909459E-02, -0.800214E-02, -0.658673E-02, -0.245580E-02, -0.710464E-02,   &
    & -0.205565E-02, -0.446529E-02, -0.440265E-02, -0.593625E-02, -0.201913E-02, -0.349169E-02,   &
    & -0.209324E-02, -0.127980E-02, -0.388007E-02, -0.140542E-02,  0.518346E-02, -0.159375E-02,   &
    &  0.250508E-02,  0.132182E-01, -0.903779E-03,  0.110959E-01,  0.924528E-03,  0.207428E-01,   &
    &  0.364166E-02,  0.365229E-02,  0.884367E-02,  0.617260E-02,  0.701340E-02,  0.184265E-01,   &
    &  0.992822E-02,  0.908582E-02,  0.106581E-01,  0.276268E-02,  0.158414E-01,  0.145747E-01,   &
    &  0.453080E-02,  0.214767E-01,  0.553895E-02,  0.195031E-01,  0.237016E-01,  0.112371E-01,   &
    &  0.275977E-01,  0.188833E-01,  0.131079E-01,  0.130019E-01,  0.385122E-01,  0.111768E-01,   &
    &  0.622620E-02,  0.194397E-01,  0.134360E-01,  0.207829E-01,  0.147960E-01,  0.744479E-02,   &
    &  0.107564E-01,  0.181562E-01,  0.170062E-01,  0.233303E-01,  0.256735E-01,  0.274745E-01,   &
    &  0.279259E-01,  0.197002E-01,  0.140268E-01,  0.185933E-01 /
!
    DATA AP2     /                                                                                &
    &  0.169525E-01,  0.214410E-01,  0.136577E-01,  0.169510E-01,  0.173025E-01,  0.958346E-02,   &
    &  0.255024E-01,  0.308943E-01,  0.196031E-01,  0.183608E-01,  0.149419E-01,  0.206358E-01,   &
    &  0.140654E-01,  0.172797E-01,  0.145470E-01,  0.982987E-02,  0.116695E-01,  0.811333E-02,   &
    &  0.965823E-02,  0.649977E-02,  0.462192E-02,  0.545929E-02,  0.680407E-02,  0.291235E-02,   &
    & -0.974773E-03,  0.341591E-02,  0.376198E-02,  0.770610E-03, -0.940864E-04,  0.514532E-02,   &
    &  0.232371E-02, -0.177741E-02, -0.374892E-03, -0.370485E-03, -0.221435E-02, -0.490000E-02,   &
    &  0.588664E-02,  0.931411E-03, -0.456043E-03, -0.545576E-02, -0.421136E-02, -0.353742E-02,   &
    & -0.174276E-02, -0.361246E-02, -0.337822E-02, -0.867030E-03, -0.118001E-02, -0.222405E-02,   &
    & -0.725144E-03,  0.118483E-02,  0.995087E-02,  0.273812E-03,  0.417298E-02,  0.764294E-02,   &
    &  0.631568E-02, -0.213528E-02,  0.746130E-02,  0.110337E-02,  0.153157E-01,  0.504532E-02,   &
    &  0.406047E-02,  0.192895E-02,  0.202058E-02,  0.126420E-01 /
! 
    DATA AP3     /                                                                                &
    &  0.310028E-02,  0.214779E-01,  0.560165E-02,  0.661070E-02,  0.694966E-02,  0.539194E-02,   &
    &  0.103745E-01,  0.180150E-01,  0.747133E-02,  0.114927E-01,  0.115213E-01,  0.160709E-02,   &
    &  0.154278E-01,  0.112067E-01,  0.148690E-01,  0.154442E-01,  0.123977E-01,  0.237539E-01,   &
    &  0.162820E-01,  0.269484E-01,  0.178081E-01,  0.143221E-01,  0.262468E-01,  0.217065E-01,   &
    &  0.107083E-01,  0.281220E-01,  0.115565E-01,  0.231244E-01,  0.225197E-01,  0.178624E-01,   &
    &  0.327708E-01,  0.116657E-01,  0.277452E-01,  0.301647E-01,  0.349782E-01 /
!
    DATA BP1     /                                                                                &
    &  0.717848E-05,  0.169280E-04,  0.126710E-04,  0.758397E-05, -0.533900E-05,  0.143490E-04,   &
    & -0.595854E-05,  0.296465E-05,  0.323446E-05,  0.115359E-04, -0.692861E-05,  0.131477E-04,   &
    & -0.624945E-05, -0.756955E-06,  0.107458E-05, -0.159796E-05, -0.290529E-04, -0.170918E-05,   &
    & -0.193934E-04, -0.707209E-04, -0.148154E-04, -0.383162E-04, -0.186050E-04, -0.951796E-04,   &
    & -0.210944E-04, -0.330590E-04, -0.373087E-04, -0.408972E-04, -0.396759E-04, -0.827756E-04,   &
    & -0.573773E-04, -0.325384E-04, -0.449411E-04, -0.271450E-04, -0.752791E-04, -0.549699E-04,   &
    & -0.225655E-04, -0.102034E-03, -0.740322E-05, -0.668846E-04, -0.106063E-03, -0.304840E-04,   &
    & -0.796023E-04,  0.504880E-04,  0.486384E-04, -0.531946E-04, -0.147771E-03, -0.406785E-04,   &
    &  0.615750E-05, -0.486264E-04, -0.419335E-04, -0.819467E-04, -0.709498E-04,  0.326984E-05,   &
    & -0.369743E-04, -0.526848E-04, -0.550050E-04, -0.684057E-04, -0.447093E-04, -0.778390E-04,   &
    & -0.982953E-04, -0.772497E-04, -0.119430E-05, -0.655187E-04 /
!
    DATA BP2     /                                                                                &
    & -0.339078E-04,  0.716657E-04, -0.335893E-04,  0.220239E-04, -0.491012E-04, -0.393325E-04,   &
    & -0.626461E-04, -0.795479E-04, -0.599181E-04, -0.578153E-04, -0.597559E-05, -0.866750E-04,   &
    & -0.486783E-04, -0.580912E-04, -0.647368E-04, -0.350643E-04, -0.566635E-04, -0.385738E-04,   &
    & -0.463782E-04, -0.321485E-04, -0.177300E-04, -0.250201E-04, -0.365492E-04, -0.165218E-04,   &
    & -0.649177E-05, -0.218458E-04, -0.984604E-05, -0.120034E-04, -0.110119E-06, -0.164405E-04,   &
    & -0.141396E-04,  0.315347E-05, -0.141544E-05, -0.297320E-05, -0.216248E-05,  0.839264E-05,   &
    & -0.178197E-04, -0.106225E-04, -0.468195E-05,  0.997043E-05,  0.679709E-05,  0.324610E-05,   &
    & -0.367325E-05,  0.671058E-05,  0.509293E-05, -0.437392E-05, -0.787922E-06, -0.271503E-06,   &
    & -0.437940E-05, -0.128205E-04, -0.417830E-04, -0.561134E-05, -0.209940E-04, -0.414366E-04,   &
    & -0.289765E-04,  0.680406E-06, -0.558644E-05, -0.530395E-05, -0.622242E-04, -0.159979E-05, - &
    &  0.140286E-04, -0.128463E-04, -0.929499E-05, -0.327886E-04 /
!
    DATA BP3     /                                                                                &
    & -0.189353E-04, -0.737589E-04, -0.323471E-04, -0.272502E-04, -0.321731E-04, -0.326958E-04,   &
    & -0.509157E-04, -0.681890E-04, -0.362182E-04, -0.354405E-04, -0.578392E-04,  0.238627E-05,   &
    & -0.709028E-04, -0.518717E-04, -0.491859E-04, -0.718017E-04, -0.418978E-05, -0.940819E-04,   &
    & -0.630375E-04, -0.478469E-04, -0.751896E-04, -0.267113E-04, -0.109019E-03, -0.890983E-04,   &
    & -0.177301E-04, -0.120216E-03,  0.220464E-04, -0.734277E-04, -0.868068E-04, -0.652319E-04,   &
    & -0.136982E-03, -0.279933E-06, -0.791824E-04, -0.111781E-03, -0.748263E-04 /
!
    DATA ATP1    /                                                                                &
    & -0.722782E-02, -0.901531E-02, -0.821263E-02, -0.808024E-02, -0.320169E-02, -0.661305E-02,   &
    & -0.287272E-02, -0.486143E-02, -0.242857E-02, -0.530288E-02, -0.146813E-02, -0.566474E-03,   & 
    & -0.102192E-02,  0.300643E-03, -0.331655E-02,  0.648220E-03,  0.552446E-02, -0.933046E-03,   & 
    &  0.205703E-02,  0.130638E-01, -0.229828E-02,  0.715648E-02,  0.444446E-03,  0.193500E-01,   &
    &  0.364119E-02,  0.252713E-02,  0.102420E-01,  0.494224E-02,  0.584934E-02,  0.146255E-01,   & 
    &  0.921986E-02,  0.768012E-02,  0.916105E-02,  0.276223E-02,  0.125245E-01,  0.131146E-01,   &
    &  0.793016E-02,  0.201536E-01,  0.658631E-02,  0.171711E-01,  0.228470E-01,  0.131306E-01,   & 
    &  0.226658E-01,  0.176086E-01,  0.149987E-01,  0.143060E-01,  0.313189E-01,  0.117070E-01,   &
    &  0.133522E-01,  0.244259E-01,  0.148393E-01,  0.223982E-01,  0.151792E-01,  0.180474E-01,   &
    &  0.106299E-01,  0.191016E-01,  0.171776E-01,  0.229724E-01,  0.275530E-01,  0.302731E-01,   &
    &  0.281662E-01,  0.199525E-01,  0.192588E-01,  0.173220E-01 /
!
    DATA ATP2    /                                                                                &
    &  0.195220E-01,  0.169371E-01,  0.193212E-01,  0.145558E-01,  0.189654E-01,  0.122030E-01,   &
    &  0.186206E-01,  0.228842E-01,  0.139343E-01,  0.164006E-01,  0.137276E-01,  0.154005E-01,   &
    &  0.114575E-01,  0.129956E-01,  0.115305E-01,  0.929260E-02,  0.106359E-01,  0.771623E-02,   &
    &  0.106075E-01,  0.597630E-02,  0.493960E-02,  0.532554E-02,  0.646175E-02,  0.302693E-02,   &
    &  0.150899E-02,  0.310333E-02,  0.533734E-02,  0.239094E-03,  0.356782E-02,  0.707574E-02,   &
    &  0.215758E-02, -0.527589E-03,  0.643893E-03, -0.101916E-02, -0.383336E-02, -0.445966E-02,   &
    &  0.880190E-02,  0.245662E-02, -0.560923E-03, -0.582201E-02, -0.323233E-02, -0.454197E-02,   &
    & -0.240905E-02, -0.343160E-02, -0.335156E-02, -0.623846E-03,  0.393633E-03, -0.271593E-02,   &
    & -0.675874E-03,  0.920642E-03,  0.102168E-01, -0.250663E-03,  0.437126E-02,  0.767434E-02,   &
    &  0.569931E-02, -0.929326E-03,  0.659414E-02,  0.280687E-02,  0.127614E-01,  0.780789E-02,   &
    &  0.374807E-02,  0.274288E-02,  0.534940E-02,  0.104349E-01 /
!
    DATA ATP3   /                                                                                 &
    &  0.294379E-02,  0.177846E-01,  0.523249E-02,  0.125339E-01, 0.548538E-02 ,  0.577403E-02,   &
    &  0.101532E-01,  0.170375E-01,  0.758396E-02,  0.113402E-01, 0.106960E-01 ,  0.107782E-01,   &
    &  0.136148E-01,  0.992064E-02,  0.167276E-01,  0.149603E-01, 0.136259E-01 ,  0.234521E-01,   &
    &  0.166806E-01,  0.298505E-01,  0.167592E-01,  0.186679E-01, 0.233062E-01 ,  0.228467E-01,   &
    &  0.128947E-01,  0.293979E-01,  0.219815E-01,  0.220663E-01, 0.272710E-01 ,  0.237139E-01,   &
    &  0.331743E-01,  0.208799E-01,  0.281472E-01,  0.318440E-01, 0.370962E-01 /
!
    DATA BTP1    /                                                                                &
    &  0.149748E-04,  0.188007E-04,  0.196530E-04,  0.124747E-04, -0.215751E-07,  0.128357E-04,   &
    & -0.265798E-05,  0.606262E-05,  0.287668E-05,  0.974612E-05, -0.833451E-05,  0.584410E-05,   &
    & -0.452879E-05, -0.782537E-05,  0.786165E-05, -0.768351E-05, -0.196168E-04,  0.177297E-06,   &
    & -0.129258E-04, -0.642798E-04, -0.986297E-05, -0.257145E-04, -0.141996E-04, -0.865089E-04,   &
    & -0.141691E-04, -0.272578E-04, -0.295198E-04, -0.308878E-04, -0.313193E-04, -0.669272E-04,   &
    & -0.475777E-04, -0.221332E-04, -0.419930E-04, -0.102519E-04, -0.590184E-04, -0.574771E-04,   &
    & -0.240809E-04, -0.913994E-04, -0.908886E-05, -0.721074E-04, -0.902837E-04, -0.447582E-04,   &
    & -0.664544E-04, -0.143150E-04, -0.511866E-05, -0.559352E-04, -0.104734E-03, -0.305206E-04,   &
    &  0.103303E-04, -0.613019E-04, -0.320040E-04, -0.738909E-04, -0.388263E-04,  0.306515E-04,   &
    & -0.352214E-04, -0.253940E-04, -0.521369E-04, -0.746260E-04, -0.744124E-04, -0.881905E-04,   &
    & -0.933645E-04, -0.664045E-04, -0.570712E-05, -0.566312E-04 /
!
    DATA BTP2    /                                                                                &
    & -0.364967E-04,  0.393501E-06, -0.234050E-04, -0.141317E-04, -0.525480E-04, -0.172241E-04,   &
    & -0.410843E-04, -0.358348E-04, -0.256168E-04, -0.509482E-04, -0.180570E-04, -0.555356E-04,   &
    & -0.271464E-04, -0.274040E-04, -0.480889E-04, -0.275751E-04, -0.415681E-04, -0.383770E-04,   &
    & -0.280139E-04, -0.287919E-04, -0.125865E-04, -0.265467E-04, -0.172765E-04, -0.164611E-04,   &
    &  0.189183E-04, -0.171219E-04, -0.132766E-04, -0.344611E-05, -0.442832E-05, -0.185779E-04,   &
    & -0.139755E-04,  0.168083E-05, -0.395287E-05, -0.297871E-05,  0.434383E-05,  0.131741E-04,   &
    & -0.192637E-04, -0.549551E-05,  0.122553E-05,  0.204627E-04,  0.154027E-04,  0.953462E-05,   &
    &  0.131125E-05,  0.732839E-05,  0.755405E-05, -0.305552E-05, -0.434858E-05,  0.308409E-05,   &
    & -0.164787E-05, -0.818533E-05, -0.355041E-04, -0.504696E-05, -0.229022E-04, -0.356891E-04,   &
    & -0.230346E-04,  0.518835E-05, -0.160187E-04, -0.104617E-04, -0.464754E-04, -0.115807E-04,   &
    & -0.130230E-04, -0.603491E-05, -0.125324E-04, -0.165516E-04 /
!
    DATA BTP3    /                                                                                &
    & -0.991679E-05, -0.529432E-04, -0.200199E-04, -0.181977E-04, -0.220940E-04, -0.204483E-04,   &
    & -0.432584E-04, -0.449109E-04, -0.247305E-04, -0.174253E-04, -0.484446E-04,  0.354150E-04,   &
    & -0.425581E-04, -0.406562E-04, -0.505495E-04, -0.651856E-04, -0.153953E-04, -0.894294E-04,   &
    & -0.616551E-04, -0.846504E-04, -0.699414E-04, -0.376203E-04, -0.940985E-04, -0.753050E-04,   &
    & -0.183710E-04, -0.123907E-03, -0.279347E-04, -0.736381E-04, -0.103588E-03, -0.754117E-04,   &
    & -0.140991E-03, -0.366687E-04, -0.927785E-04, -0.125321E-03, -0.115290E-03 /
!
    DATA BETAD1  /                                                                                &
    &  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,   &
    &  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,   &
    &  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,   &
    &  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,   &
    &  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,   &
    &  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,   &
    &  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.234879E+03,  0.217419E+03,   &
    &  0.201281E+03,  0.186364E+03,  0.172576E+03,  0.159831E+03,  0.148051E+03,  0.137163E+03,   &
    &  0.127099E+03,  0.117796E+03,  0.109197E+03,  0.101249E+03,  0.939031E+02,  0.871127E+02,   &
    &  0.808363E+02,  0.750349E+02,  0.497489E+02,  0.221212E+02,  0.113124E+02,  0.754174E+01,   &
    &  0.589554E+01,  0.495227E+01,  0.000000E+00,  0.000000E+00 /
!
    DATA BETAD2  /                                                                                &
    &  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,   &
    &  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,   &
    &  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,   &
    &  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,   &
    &  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,   &
    &  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,   &
    &  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,   &
    &  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,   &
    &  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,   &
    &  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,   &
    &  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00 /
!
    DATA BETAD3  /                                                                                &
    &  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,   &
    &  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,   &
    &  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,   &
    &  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,   &
    &  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,   &
    &  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00 /
!
    DATA BANDL1 /                                                                                 &
    &  0.000000E+00,  0.100000E+02,  0.200000E+02,  0.300000E+02,  0.400000E+02,  0.500000E+02,   &
    &  0.600000E+02,  0.700000E+02,  0.800000E+02,  0.900000E+02,  0.100000E+03,  0.110000E+03,   &
    &  0.120000E+03,  0.130000E+03,  0.140000E+03,  0.150000E+03,  0.160000E+03,  0.170000E+03,   &
    &  0.180000E+03,  0.190000E+03,  0.200000E+03,  0.210000E+03,  0.220000E+03,  0.230000E+03,   &
    &  0.240000E+03,  0.250000E+03,  0.260000E+03,  0.270000E+03,  0.280000E+03,  0.290000E+03,   &
    &  0.300000E+03,  0.310000E+03,  0.320000E+03,  0.330000E+03,  0.340000E+03,  0.350000E+03,   &
    &  0.360000E+03,  0.370000E+03,  0.380000E+03,  0.390000E+03,  0.400000E+03,  0.410000E+03,   &
    &  0.420000E+03,  0.430000E+03,  0.440000E+03,  0.450000E+03,  0.460000E+03,  0.470000E+03,   &
    &  0.480000E+03,  0.490000E+03,  0.500000E+03,  0.510000E+03,  0.520000E+03,  0.530000E+03,   &
    &  0.540000E+03,  0.550000E+03,  0.560000E+03,  0.670000E+03,  0.800000E+03,  0.900000E+03,   &
    &  0.990000E+03,  0.107000E+04,  0.120000E+04,  0.121000E+04 /
!
    DATA BANDL2 /                                                                                 &
    &  0.122000E+04,  0.123000E+04,  0.124000E+04,  0.125000E+04,  0.126000E+04,  0.127000E+04,   &
    &  0.128000E+04,  0.129000E+04,  0.130000E+04,  0.131000E+04,  0.132000E+04,  0.133000E+04,   &
    &  0.134000E+04,  0.135000E+04,  0.136000E+04,  0.137000E+04,  0.138000E+04,  0.139000E+04,   &
    &  0.140000E+04,  0.141000E+04,  0.142000E+04,  0.143000E+04,  0.144000E+04,  0.145000E+04,   &
    &  0.146000E+04,  0.147000E+04,  0.148000E+04,  0.149000E+04,  0.150000E+04,  0.151000E+04,   &
    &  0.152000E+04,  0.153000E+04,  0.154000E+04,  0.155000E+04,  0.156000E+04,  0.157000E+04,   &
    &  0.158000E+04,  0.159000E+04,  0.160000E+04,  0.161000E+04,  0.162000E+04,  0.163000E+04,   &
    &  0.164000E+04,  0.165000E+04,  0.166000E+04,  0.167000E+04,  0.168000E+04,  0.169000E+04,   &
    &  0.170000E+04,  0.171000E+04,  0.172000E+04,  0.173000E+04,  0.174000E+04,  0.175000E+04,   &
    &  0.176000E+04,  0.177000E+04,  0.178000E+04,  0.179000E+04,  0.180000E+04,  0.181000E+04,   &
    &  0.182000E+04,  0.183000E+04,  0.184000E+04,  0.185000E+04 /
!
    DATA BANDL3 /                                                                                 &
    &  0.186000E+04,  0.187000E+04,  0.188000E+04,  0.189000E+04,  0.190000E+04,  0.191000E+04,   &
    &  0.192000E+04,  0.193000E+04,  0.194000E+04,  0.195000E+04,  0.196000E+04,  0.197000E+04,   &
    &  0.198000E+04,  0.199000E+04,  0.200000E+04,  0.201000E+04,  0.202000E+04,  0.203000E+04,   &
    &  0.204000E+04,  0.205000E+04,  0.206000E+04,  0.207000E+04,  0.208000E+04,  0.209000E+04,   &
    &  0.210000E+04,  0.211000E+04,  0.212000E+04,  0.213000E+04,  0.214000E+04,  0.215000E+04,   &
    &  0.216000E+04,  0.217000E+04,  0.218000E+04,  0.219000E+04,  0.227000E+04 /
!
    DATA BANDH1 /                                                                                 &
    &  0.100000E+02,  0.200000E+02,  0.300000E+02,  0.400000E+02,  0.500000E+02,  0.600000E+02,   &
    &  0.700000E+02,  0.800000E+02,  0.900000E+02,  0.100000E+03,  0.110000E+03,  0.120000E+03,   &
    &  0.130000E+03,  0.140000E+03,  0.150000E+03,  0.160000E+03,  0.170000E+03,  0.180000E+03,   &
    &  0.190000E+03,  0.200000E+03,  0.210000E+03,  0.220000E+03,  0.230000E+03,  0.240000E+03,   &
    &  0.250000E+03,  0.260000E+03,  0.270000E+03,  0.280000E+03,  0.290000E+03,  0.300000E+03,   &
    &  0.310000E+03,  0.320000E+03,  0.330000E+03,  0.340000E+03,  0.350000E+03,  0.360000E+03,   &
    &  0.370000E+03,  0.380000E+03,  0.390000E+03,  0.400000E+03,  0.410000E+03,  0.420000E+03,   &
    &  0.430000E+03,  0.440000E+03,  0.450000E+03,  0.460000E+03,  0.470000E+03,  0.480000E+03,   &
    &  0.490000E+03,  0.500000E+03,  0.510000E+03,  0.520000E+03,  0.530000E+03,  0.540000E+03,   &
    &  0.550000E+03,  0.560000E+03,  0.670000E+03,  0.800000E+03,  0.900000E+03,  0.990000E+03,   &
    &  0.107000E+04,  0.120000E+04,  0.121000E+04,  0.122000E+04 /
!
    DATA BANDH2 /                                                                                 &
    &  0.123000E+04,  0.124000E+04,  0.125000E+04,  0.126000E+04,  0.127000E+04,  0.128000E+04,   &
    &  0.129000E+04,  0.130000E+04,  0.131000E+04,  0.132000E+04,  0.133000E+04,  0.134000E+04,   &
    &  0.135000E+04,  0.136000E+04,  0.137000E+04,  0.138000E+04,  0.139000E+04,  0.140000E+04,   &
    &  0.141000E+04,  0.142000E+04,  0.143000E+04,  0.144000E+04,  0.145000E+04,  0.146000E+04,   &
    &  0.147000E+04,  0.148000E+04,  0.149000E+04,  0.150000E+04,  0.151000E+04,  0.152000E+04,   &
    &  0.153000E+04,  0.154000E+04,  0.155000E+04,  0.156000E+04,  0.157000E+04,  0.158000E+04,   &
    &  0.159000E+04,  0.160000E+04,  0.161000E+04,  0.162000E+04,  0.163000E+04,  0.164000E+04,   &
    &  0.165000E+04,  0.166000E+04,  0.167000E+04,  0.168000E+04,  0.169000E+04,  0.170000E+04,   &
    &  0.171000E+04,  0.172000E+04,  0.173000E+04,  0.174000E+04,  0.175000E+04,  0.176000E+04,   &
    &  0.177000E+04,  0.178000E+04,  0.179000E+04,  0.180000E+04,  0.181000E+04,  0.182000E+04,   &
    &  0.183000E+04,  0.184000E+04,  0.185000E+04,  0.186000E+04 /
!
    DATA BANDH3 /                                                                                 &
    &  0.187000E+04,  0.188000E+04,  0.189000E+04,  0.190000E+04,  0.191000E+04,  0.192000E+04,   &
    &  0.193000E+04,  0.194000E+04,  0.195000E+04,  0.196000E+04,  0.197000E+04,  0.198000E+04,   &
    &  0.199000E+04,  0.200000E+04,  0.201000E+04,  0.202000E+04,  0.203000E+04,  0.204000E+04,   &
    &  0.205000E+04,  0.206000E+04,  0.207000E+04,  0.208000E+04,  0.209000E+04,  0.210000E+04,   &
    &  0.211000E+04,  0.212000E+04,  0.213000E+04,  0.214000E+04,  0.215000E+04,  0.216000E+04,   &
    &  0.217000E+04,  0.218000E+04,  0.219000E+04,  0.220000E+04,  0.238000E+04 /
!
    DATA AO3RND /                                                                                 &
    &  0.543368E+02,  0.234676E+04,  0.384881E+02 /
!
    DATA BO3RND /                                                                                 &
    &  0.526064E+01,  0.922424E+01,  0.496515E+01 /
!
    END MODULE BANDTA
