program soma

   implicit none
   
   integer, parameter                        :: dp=kind(1.0d0), qtdexp=15, nciclos=49
   
   integer, dimension(qtdexp)                :: ATM_ncores=0, OCN_ncores=0
   integer                                   :: iletra, nexp, exp, unit, ios, r, ifortunit, temp, k, tfexp, tiexp

   real(dp), allocatable, dimension(:)       :: tempo
   real(dp), allocatable, dimension(:,:)     :: somaCiclos_tWaitR_A, medCiclos_tWaitR_A
   real(dp), allocatable, dimension(:,:)     :: somaCiclos_tWaitS_A, medCiclos_tWaitS_A
   real(dp), allocatable, dimension(:,:)     :: somaCiclos_tWaitR_O, medCiclos_tWaitR_O
   real(dp), allocatable, dimension(:,:)     :: somaCiclos_tWaitS_O, medCiclos_tWaitS_O
   real(dp), allocatable, dimension(:,:,:)   :: tWaitR_A, tWaitS_A, tWaitR_O, tWaitS_O
   
   real(dp), dimension(qtdexp)               :: somaRanksTotalTime=0.0_dp, mediaRanksTotalTime=0.0_dp, maxRanksTotalTime=0.0_dp
   real(dp), dimension(qtdexp)               :: somaRanks_medCiclos_tWaitR_A=0.0_dp, mediaRanks_medCiclos_tWaitR_A=0.0_dp, maxRanks_medCiclos_tWaitR_A=0.0_dp
   real(dp), dimension(qtdexp)               :: somaRanks_medCiclos_tWaitS_A=0.0_dp, mediaRanks_medCiclos_tWaitS_A=0.0_dp, maxRanks_medCiclos_tWaitS_A=0.0_dp
   real(dp), dimension(qtdexp)               :: somaRanks_medCiclos_tWaitR_O=0.0_dp, mediaRanks_medCiclos_tWaitR_O=0.0_dp, maxRanks_medCiclos_tWaitR_O=0.0_dp
   real(dp), dimension(qtdexp)               :: somaRanks_medCiclos_tWaitS_O=0.0_dp, mediaRanks_medCiclos_tWaitS_O=0.0_dp, maxRanks_medCiclos_tWaitS_O=0.0_dp

   ! Soma dos 49ciclos + Soma de todos os ranks:
   real(dp), dimension(qtdexp)               :: somaRanks_somaCiclos_tWaitS_A=0.0_dp
   real(dp), dimension(qtdexp)               :: somaRanks_somaCiclos_tWaitR_A=0.0_dp
   real(dp), dimension(qtdexp)               :: somaRanks_somaCiclos_tWaitS_O=0.0_dp
   real(dp), dimension(qtdexp)               :: somaRanks_somaCiclos_tWaitR_O=0.0_dp
   
   real(dp), dimension(qtdexp)               :: ind1_Med_R=0.0_dp, ind1_Med_S=0.0_dp
   real(dp), dimension(qtdexp)               :: ind1_Max_R=0.0_dp, ind1_Max_S=0.0_dp
   real(dp), dimension(qtdexp)               :: ind1_Sum_R=0.0_dp, ind1_Sum_S=0.0_dp
   real(dp), dimension(qtdexp)               :: ind1_SomaDaSoma_R=0.0_dp, ind1_SomaDaSoma_S=0.0_dp
   
   ! Max(ranks) de cada ciclo:
   real(dp), dimension(qtdexp, nciclos)      :: tWaitR_A_max=0.0_dp, tWaitS_A_max=0.0_dp, tWaitR_O_max=0.0_dp, tWaitS_O_max=0.0_dp
   real(dp), dimension(qtdexp)               :: soma_tWaitR_A_max=0.0_dp, soma_tWaitS_A_max=0.0_dp, soma_tWaitR_O_max=0.0_dp, soma_tWaitS_O_max=0.0_dp
   real(dp), dimension(qtdexp)               :: media_tWaitR_A_max=0.0_dp, media_tWaitS_A_max=0.0_dp, media_tWaitR_O_max=0.0_dp, media_tWaitS_O_max=0.0_dp

   character(len=1)                          :: letra
   character(len=1), dimension(qtdexp)       :: expletras
   character(len=10)                         :: filename
   character(len=200)                        :: sufixo, dirname, rootdir
   
   
   
    

   ! ============================================================
   ! Definicao dos experimentos
   !            1   2   3   4   5   6   7   8   9  10  11  12  13  14  15
   expletras=(/'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o'/)
   ATM_ncores=(/128,128,64,64,256,128,256,384,384,512,512,768,768,1024,1024/)
   OCN_ncores=(/128,64,128,64,128,256,128,128,256,128,256,128,256,128,256/)
   sufixo=""
   nexp=0
   rootdir="/mnt/beegfs/carlos.souza/Doutorado/COAWST.V3.7/Work/ATLSW12"




   ! ====================================================================================================
   ! Esquema dos dados:
   !
   !
   !  r0       r1    ...   rn
   !
   !  cpl1    cpl1       cpl1
   !  cpl2    cpl2       cpl2
   !  cpl3    cpl3       cpl3
   !  .       .          .
   !  .       .          .
   !  .       .          .
   !  cpl48   cpl48      cpl48
   !  cpl49   cpl49      cpl49
   !
   !    |        |         |
   !  med_r0  med_r1     med_rn     ===> MEDIA(ranks), SOMA(ranks), MAX(ranks) (entre os ranks)
   !
   !
   ! ====================================================================================================
   
   
   ! Sugestao Stephan: pegar o valor maximo de cada rank para cada acoplamento:
   !
   !  r0       r1    ...   rn
   !
   !  cpl1    cpl1       cpl1    ---> cpl1_max(ranks)
   !  cpl2    cpl2       cpl2    ---> cpl2_max(ranks)
   !  cpl3    cpl3       cpl3    ---> cpl3_max(ranks)
   !  .       .          .       ---> ...
   !  .       .          .       ---> ...
   !  .       .          .       ---> ...
   !  cpl48   cpl48      cpl48   ---> cpl48_max(ranks)
   !  cpl49   cpl49      cpl49   ---> cpl49_max(ranks)
   !
   !                                       ||
   !                                 media dos cpls_max
   ! ====================================================================================================
   
   
   ! Sugestao JP: trabalhar com a soma de todos os valores
   !
   !  r0       r1    ...   rn
   !
   !  cpl1    cpl1       cpl1
   !  cpl2    cpl2       cpl2
   !  cpl3    cpl3       cpl3
   !  .       .          .
   !  .       .          .
   !  .       .          .
   !  cpl48   cpl48      cpl48
   !  cpl49   cpl49      cpl49
   !
   !    |        |         |
   !  soma_r0  soma_r1   soma_rn     ===> MEDIA(das somas ranks), SOMA(das somas ranks), MAX(das somas ranks) (entre os ranks)
   !
   !  Proximo passo a implementar!
   ! ====================================================================================================
   
      
    tiexp=1
    tfexp=qtdexp
   !iexp=12
   !fexp=14
     
   do iletra=tiexp, tfexp
      letra =expletras(iletra)

      do exp=0,0

         ! Definindo caminho completo do direotrios dos arquivos de dados :
         write(dirname,"(A,'/wr_17022023-',A1,I1,A,'/')") trim(rootdir),letra,exp,trim(sufixo)
       
        
         ! ----------------------------------------------------------------------------------------
         ! Lendo fort.10000 (tempo total)
         allocate(tempo(0:ATM_ncores(iletra)+OCN_ncores(iletra)-1))
         tempo=0.0_dp
         do r=0, ATM_ncores(iletra)+OCN_ncores(iletra)-1
            ifortunit=10000+r
            write(filename, '("fort.", i5)') ifortunit
            open(newunit=unit,file=trim(dirname)//filename,status='old',action='read',iostat=ios)
            if (ios /= 0) then
               print *,"Erro ao abrir ",trim(dirname)//filename, ios
               stop
            end if
            print*, 'Lendo ', trim(dirname)//filename
            read(unit,'(f20.6)',iostat=ios) tempo(r)
            ! Somando o tempo total de cada rank:
            SomaRanksTotalTime(iletra)=SomaRanksTotalTime(iletra)+tempo(r)
            close(unit)
            !print*, r, tempo(r), SomaRanksTotalTime(iletra)
         enddo  !r     
         ! Media dos tempos totais entre os ranks:
         mediaRanksTotalTime(iletra)=somaRanksTotalTime(iletra)/real(ATM_ncores(iletra)+OCN_ncores(iletra))
         ! Tempo total maximo entre or ranks:
         maxRanksTotalTime(iletra)=maxval(tempo)
         deallocate(tempo)




         ! ----------------------------------------------------------------------------------------
         ! Lendo fort.50000 ... fort.(50000+ATM_ncores-1)
         ! Wait receive ATM:
         allocate(somaCiclos_tWaitR_A(qtdexp,0:ATM_ncores(iletra)-1))
         allocate(tWaitR_A(qtdexp,0:ATM_ncores(iletra)-1,nciclos))
         allocate(medCiclos_tWaitR_A(qtdexp,0:ATM_ncores(iletra)-1))
         somaCiclos_tWaitR_A=0.0_dp
         tWaitR_A=0.0_dp
         medCiclos_tWaitR_A=0.0_dp
         do r=0,ATM_ncores(iletra)-1
            ifortunit=50000+r
            write(filename, '("fort.", i5)') ifortunit
            open(newunit=unit,file=trim(dirname)//filename,status='old',action='read',iostat=ios)
            if (ios /= 0) then
               print *,"Erro ao abrir ",trim(dirname)//filename, ios
               stop
            end if
            print*, 'Lendo ', trim(dirname)//filename
            do k=1,nciclos
               read(unit,*,iostat=ios) tWaitR_A(iletra,r,k),temp
               if (ios /= 0) exit
               ! Soma os tempos dos 49 ciclos de acoplamento:
               somaCiclos_tWaitR_A(iletra,r)=somaCiclos_tWaitR_A(iletra,r) + tWaitR_A(iletra,r,k)
               !print*, iletra, r, k, tWaitR_A(iletra,r,k), somaCiclos_tWaitR_A(iletra,r)
            end do ! k, nciclos
            ! Media dos 49 ciclos de acoplamento netre os ranks:
            medCiclos_tWaitR_A(iletra,r)=somaCiclos_tWaitR_A(iletra,r)/real(nciclos)
            ! Soma todos as medias dos 49 ciclos de acoplamento de todos os ranks:
            somaRanks_medCiclos_tWaitR_A(iletra)=somaRanks_medCiclos_tWaitR_A(iletra)+medCiclos_tWaitR_A(iletra,r)
            ! SOMA todos as SOMAS (dos 49 cilcos) de todos os ranks:
            somaRanks_somaCiclos_tWaitR_A(iletra)=somaRanks_somaCiclos_tWaitR_A(iletra)+somaCiclos_tWaitR_A(iletra,r)
            !print*, '===', iletra,r, somaCiclos_tWaitR_A(iletra,r), medCiclos_tWaitR_A(iletra,r), somaRanks_medCiclos_tWaitR_A(iletra)
            !read(*,*)
            close(unit)
         enddo !r
         ! Media dos tempos medios Wait receive ATM entre os ranks:
         mediaRanks_medCiclos_tWaitR_A(iletra)=somaRanks_medCiclos_tWaitR_A(iletra)/real(ATM_ncores(iletra))
         ! Valor maximo entre os ranks:
         maxRanks_medCiclos_tWaitR_A(iletra)=maxval(medCiclos_tWaitR_A(iletra,:))
         ! ST: Usando o maximo valor entre os ranks de cada um dos 49 tempos:
         do k=1,nciclos
            tWaitR_A_max(iletra,k)=maxval(tWaitR_A(iletra,:,k))
            soma_tWaitR_A_max(iletra)=soma_tWaitR_A_max(iletra)+tWaitR_A_max(iletra,k)
            !print*, iletra, k, tWaitR_A_max(iletra,k), soma_tWaitR_A_max(iletra)
         end do ! k, nciclos
         ! Media dos 49 tWaitR_A_max:
         media_tWaitR_A_max(iletra)=soma_tWaitR_A_max(iletra)/real(nciclos)
         !print*,media_tWaitR_A_max(iletra)
         !read(*,*)
         !print*, '=== ===', iletra, mediaRanks_medCiclos_tWaitR_A(iletra)
         deallocate(somaCiclos_tWaitR_A)
         deallocate(tWaitR_A)
         deallocate(medCiclos_tWaitR_A)

         


         ! ----------------------------------------------------------------------------------------
         ! Lendo fort.40000 ... fort.(40000+ATM_ncores-1)
         ! Wait send ATM:
         allocate(somaCiclos_tWaitS_A(qtdexp,0:ATM_ncores(iletra)-1))
         allocate(tWaitS_A(qtdexp,0:ATM_ncores(iletra)-1,nciclos))
         allocate(medCiclos_tWaitS_A(qtdexp,0:ATM_ncores(iletra)-1))
         somaCiclos_tWaitS_A=0.0_dp
         tWaitS_A=0.0_dp
         medCiclos_tWaitS_A=0.0_dp
         do r=0,ATM_ncores(iletra)-1
            ifortunit=40000+r
            write(filename, '("fort.", i5)') ifortunit
            open(newunit=unit,file=trim(dirname)//filename,status='old',action='read',iostat=ios)
            if (ios /= 0) then
               print *,"Erro ao abrir ",trim(dirname)//filename, ios
               stop
            end if
            print*, 'Lendo ', trim(dirname)//filename
            do k=1,nciclos
               read(unit,*,iostat=ios) tWaitS_A(iletra,r,k),temp
               if (ios /= 0) exit
               ! Soma os tempos dos 49 ciclos de acoplamento:
               somaCiclos_tWaitS_A(iletra,r)=somaCiclos_tWaitS_A(iletra,r) + tWaitS_A(iletra,r,k)
               !print*, iletra, r, k, tWaitS_A(iletra,r,k), somaCiclos_tWaitS_A(iletra,r)
            end do ! k, nciclos
            ! Media dos 49 ciclos de acoplamento:
            medCiclos_tWaitS_A(iletra,r)=somaCiclos_tWaitS_A(iletra,r)/real(nciclos)
            ! Soma todos as medias dos 49 ciclos de acoplamento de todos os ranks:
            somaRanks_medCiclos_tWaitS_A(iletra)=somaRanks_medCiclos_tWaitS_A(iletra)+medCiclos_tWaitS_A(iletra,r)
            ! SOMA todos as SOMAS (dos 49 cilcos) de todos os ranks:
            somaRanks_somaCiclos_tWaitS_A(iletra)=somaRanks_somaCiclos_tWaitS_A(iletra)+somaCiclos_tWaitS_A(iletra,r)
            !print*, 'sumCic,medCic, sumR', iletra,r, somaCiclos_tWaitS_A(iletra,r), medCiclos_tWaitS_A(iletra,r), somaRanks_medCiclos_tWaitS_A(iletra)
            !read(*,*)
            close(unit)
         enddo !r
         ! Media dos tempos medios Wait send ATM entre os ranks:
         mediaRanks_medCiclos_tWaitS_A(iletra)=somaRanks_medCiclos_tWaitS_A(iletra)/real(ATM_ncores(iletra))
         ! Valor maximo entre os ranks:
         maxRanks_medCiclos_tWaitS_A(iletra)=maxval(medCiclos_tWaitS_A(iletra,:))
         ! ST: Usando o maximo valor entre os ranks de cada um dos 49 tempos:
         do k=1,nciclos
            tWaitS_A_max(iletra,k)=maxval(tWaitS_A(iletra,:,k))
            soma_tWaitS_A_max(iletra)=soma_tWaitS_A_max(iletra)+tWaitS_A_max(iletra,k)            
            !print*, iletra, k, tWaitR_A_max(iletra,k)
         end do ! k, nciclos
         ! Media dos 49 tWaitR_A_max:
         media_tWaitS_A_max(iletra)=soma_tWaitS_A_max(iletra)/real(nciclos)
         !print*, 'medR, sumR', iletra, mediaRanks_medCiclos_tWaitS_A(iletra), somaRanks_medCiclos_tWaitS_A(iletra)
         !read(*,*)
         deallocate(somaCiclos_tWaitS_A)
         deallocate(tWaitS_A)
         deallocate(medCiclos_tWaitS_A)
      

         

         ! ----------------------------------------------------------------------------------------
         ! Lendo fort.60000 ... fort.(60000+OCN_ncores-1)
         ! Wait receive OCN:
         allocate(somaCiclos_tWaitR_O(qtdexp,0:OCN_ncores(iletra)-1))
         allocate(tWaitR_O(qtdexp,0:OCN_ncores(iletra)-1,nciclos))
         allocate(medCiclos_tWaitR_O(qtdexp,0:OCN_ncores(iletra)-1))
         somaCiclos_tWaitR_O=0.0_dp
         tWaitR_O=0.0_dp
         medCiclos_tWaitR_O=0.0_dp
         do r=0,OCN_ncores(iletra)-1
            ifortunit=60000+r
            write(filename, '("fort.", i5)') ifortunit
            open(newunit=unit,file=trim(dirname)//filename,status='old',action='read',iostat=ios)
            if (ios /= 0) then
               print *,"Erro ao abrir ",trim(dirname)//filename, ios
               stop
            end if
            print*, 'Lendo ', trim(dirname)//filename
            do k=1,nciclos
               read(unit,*,iostat=ios) tWaitR_O(iletra,r,k),temp
               if (ios /= 0) exit
               ! Soma os tempos dos 49 ciclos de acoplamento:
               somaCiclos_tWaitR_O(iletra,r)=somaCiclos_tWaitR_O(iletra,r) + tWaitR_O(iletra,r,k)
               !print*, iletra, r, k, tWaitR_O(iletra,r,k), somaCiclos_tWaitR_O(iletra,r)
            end do ! k, nciclos
            ! Media dos 49 ciclos de acoplamento:
            medCiclos_tWaitR_O(iletra,r)=somaCiclos_tWaitR_O(iletra,r)/real(nciclos)
            ! Soma todos as medias dos 49 ciclos de acoplamento de todos os ranks:
            somaRanks_medCiclos_tWaitR_O(iletra)=somaRanks_medCiclos_tWaitR_O(iletra)+medCiclos_tWaitR_O(iletra,r)
            ! SOMA todos as SOMAS (dos 49 cilcos) de todos os ranks:
            somaRanks_somaCiclos_tWaitR_O(iletra)=somaRanks_somaCiclos_tWaitR_O(iletra)+somaCiclos_tWaitR_O(iletra,r)
            !print*, '===', iletra,r, somaCiclos_tWaitR_O(iletra,r), medCiclos_tWaitR_O(iletra,r), somaRanks_medCiclos_tWaitR_O(iletra)
            !read(*,*)
            close(unit)
         enddo !r
         ! Media dos 49 ciclos de acoplamento:
         mediaRanks_medCiclos_tWaitR_O(iletra)=somaRanks_medCiclos_tWaitR_O(iletra)/real(OCN_ncores(iletra))
         ! Valor maximo entre os ranks:
         maxRanks_medCiclos_tWaitR_O(iletra)=maxval(medCiclos_tWaitR_O(iletra,:))
         ! ST: Usando o maximo valor entre os ranks de cada um dos 49 tempos:
         do k=1,nciclos
            tWaitR_O_max(iletra,k)=maxval(tWaitR_O(iletra,:,k))
            soma_tWaitR_O_max(iletra)=soma_tWaitR_O_max(iletra)+tWaitR_O_max(iletra,k)
            !print*, iletra, k, tWaitR_A_max(iletra,k)
         end do ! k, nciclos
         ! Media dos 49 tWaitR_A_max:
         media_tWaitR_O_max(iletra)=soma_tWaitR_O_max(iletra)/real(nciclos)
         !print*, '=== ===', iletra, mediaRanks_medCiclos_tWaitR_O(iletra)
         deallocate(somaCiclos_tWaitR_O)
         deallocate(tWaitR_O)
         deallocate(medCiclos_tWaitR_O)
         
         
         
         ! ----------------------------------------------------------------------------------------
         ! Lendo fort.70000 ... fort.(70000+OCN_ncores-1)
         ! Wait send OCN:
         allocate(somaCiclos_tWaitS_O(qtdexp,0:OCN_ncores(iletra)-1))
         allocate(tWaitS_O(qtdexp,0:OCN_ncores(iletra)-1,nciclos))
         allocate(medCiclos_tWaitS_O(qtdexp,0:OCN_ncores(iletra)-1))
         somaCiclos_tWaitS_O=0.0_dp
         tWaitS_O=0.0_dp
         medCiclos_tWaitS_O=0.0_dp
         do r=0,OCN_ncores(iletra)-1
            ifortunit=70000+r
            write(filename, '("fort.", i5)') ifortunit
            open(newunit=unit,file=trim(dirname)//filename,status='old',action='read',iostat=ios)
            if (ios /= 0) then
               print *,"Erro ao abrir ",trim(dirname)//filename, ios
               stop
            end if
            print*, 'Lendo ', trim(dirname)//filename
            do k=1,nciclos
               read(unit,*,iostat=ios) tWaitS_O(iletra,r,k),temp
               if (ios /= 0) exit
               ! Soma os tempos dos 49 ciclos de acoplamento:
               somaCiclos_tWaitS_O(iletra,r)=somaCiclos_tWaitS_O(iletra,r) + tWaitS_O(iletra,r,k)
               !print*, iletra, r, k, tWaitS_O(iletra,r,k), somaCiclos_tWaitS_O(iletra,r)
            end do
            ! Media dos 49 ciclos de acoplamento:
            medCiclos_tWaitS_O(iletra,r)=somaCiclos_tWaitS_O(iletra,r)/real(nciclos)
            ! Soma todos as medias dos 49 ciclos de acoplamento de todos os ranks:
            somaRanks_medCiclos_tWaitS_O(iletra)=somaRanks_medCiclos_tWaitS_O(iletra)+medCiclos_tWaitS_O(iletra,r)
            ! SOMA todos as SOMAS (dos 49 cilcos) de todos os ranks:
            somaRanks_somaCiclos_tWaitS_O(iletra)=somaRanks_somaCiclos_tWaitS_O(iletra)+somaCiclos_tWaitS_O(iletra,r)
            !print*, 'sumCic,medCic, sumR', iletra,r, somaCiclos_tWaitS_O(iletra,r), medCiclos_tWaitS_O(iletra,r), somaRanks_medCiclos_tWaitS_O(iletra)
            !read(*,*)
            close(unit)
         enddo !r
         ! Media dos tempos medios Wait send OCN entre os ranks:
         mediaRanks_medCiclos_tWaitS_O(iletra)=somaRanks_medCiclos_tWaitS_O(iletra)/real(OCN_ncores(iletra))
         ! Soma todos as medias dos 49 ciclos de acoplamento de todos os ranks:
         maxRanks_medCiclos_tWaitS_O(iletra)=maxval(medCiclos_tWaitS_O(iletra,:))
         ! ST: Usando o maximo valor entre os ranks de cada um dos 49 tempos:
         do k=1,nciclos
            tWaitS_O_max(iletra,k)=maxval(tWaitS_O(iletra,:,k))
            soma_tWaitS_O_max(iletra)=soma_tWaitS_O_max(iletra)+tWaitS_O_max(iletra,k)
            !print*, iletra, k, tWaitR_A_max(iletra,k)
         end do ! k, nciclos
         ! Media dos 49 tWaitR_A_max:
         media_tWaitS_O_max(iletra)=soma_tWaitS_O_max(iletra)/real(nciclos)

         !print*, 'medR, sumR', iletra, mediaRanks_medCiclos_tWaitS_O(iletra), somaRanks_medCiclos_tWaitS_O(iletra)
         !read(*,*)
         deallocate(somaCiclos_tWaitS_O)
         deallocate(tWaitS_O)
         deallocate(medCiclos_tWaitS_O)


         ! Calculando indice 1:
         !
         !        TWaitATM - TWaitOCN
         !  i1 = -------------------------
         !        max(TWaitATM,TWaitOCN)
         !
         
         ! Media:
         ind1_Med_R(iletra) = (mediaRanks_medCiclos_tWaitR_A(iletra)-mediaRanks_medCiclos_tWaitR_O(iletra)) &
                                / &
                                (max(mediaRanks_medCiclos_tWaitR_A(iletra),mediaRanks_medCiclos_tWaitR_O(iletra)))
         ind1_Med_S(iletra) = (mediaRanks_medCiclos_tWaitS_A(iletra)-mediaRanks_medCiclos_tWaitS_O(iletra)) &
                                / &
                                (max(mediaRanks_medCiclos_tWaitS_A(iletra),mediaRanks_medCiclos_tWaitS_O(iletra)))
         
         ! Soma:
         ind1_Sum_R(iletra) = (somaRanks_medCiclos_tWaitR_A(iletra)-somaRanks_medCiclos_tWaitR_O(iletra)) &
                                / &
                                (max(somaRanks_medCiclos_tWaitR_A(iletra),somaRanks_medCiclos_tWaitR_O(iletra)))
         ind1_Sum_S(iletra) = (somaRanks_medCiclos_tWaitS_A(iletra)-somaRanks_medCiclos_tWaitS_O(iletra)) &
                                / &
                                (max(somaRanks_medCiclos_tWaitS_A(iletra),somaRanks_medCiclos_tWaitS_O(iletra)))

         ! Max:
         ind1_Max_R(iletra) = (maxRanks_medCiclos_tWaitR_A(iletra)-maxRanks_medCiclos_tWaitR_O(iletra)) &
                                / &
                                (max(maxRanks_medCiclos_tWaitR_A(iletra),maxRanks_medCiclos_tWaitR_O(iletra)))
         ind1_Max_S(iletra) = (maxRanks_medCiclos_tWaitS_A(iletra)-maxRanks_medCiclos_tWaitS_O(iletra)) &
                                / &
                                (max(maxRanks_medCiclos_tWaitS_A(iletra),maxRanks_medCiclos_tWaitS_O(iletra)))

         ! SOMA da SOMA:
         ind1_SomaDaSoma_R(iletra) = (somaRanks_somaCiclos_tWaitR_A(iletra)-somaRanks_somaCiclos_tWaitR_O(iletra)) &
                                / &
                                (max(somaRanks_somaCiclos_tWaitR_A(iletra),somaRanks_somaCiclos_tWaitR_O(iletra)))
         ind1_SomaDaSoma_S(iletra) = (somaRanks_somaCiclos_tWaitS_A(iletra)-somaRanks_somaCiclos_tWaitS_O(iletra)) &
                                / &
                                (max(somaRanks_somaCiclos_tWaitS_A(iletra),somaRanks_somaCiclos_tWaitS_O(iletra)))


      enddo ! exp
      
   enddo ! iletra
   
   
   
   ! Escrevendo na tela e no arquivo ascii:
   
   open(16,file='tempos_media_soma_max_Waits_Exp_todos.txt',status='unknown',action='write',iostat=ios)
   do unit=6, 16, 10
   
      ! Tabela da MEDIA usando ainda as medias dos 49 ciclos de cada rank:
      write(unit,*)
      write(unit,*) 'MEDIA:'
      write(unit,*) '#Exp ATM-c  OCN-c  total-c TTotal(med) TWaitR-A(med) TWaitS-A(med) TWaitR-O(med) TWaitS-O(med) Ind1-WaitR(med) Ind1-WaitS(med)'
      do iletra=tiexp, tfexp
         letra =expletras(iletra)
         write(unit,'(1x,1a, 2x, i5, 2x, i5, 2x, i5, 2x, 7(3x, f10.2))') &
            letra, &
            ATM_ncores(iletra), &
            OCN_ncores(iletra), &
            ATM_ncores(iletra)+OCN_ncores(iletra), &
            mediaRanksTotalTime(iletra), &
            mediaRanks_medCiclos_tWaitR_A(iletra), &
            mediaRanks_medCiclos_tWaitS_A(iletra), &
            mediaRanks_medCiclos_tWaitR_O(iletra), &
            mediaRanks_medCiclos_tWaitS_O(iletra), &
            ind1_Med_R(iletra), &
            ind1_Med_S(iletra)

      enddo ! iletra

      ! Tabela da SOMA de todos os ranks usando ainda as medias dos 49 ciclos de cada rank:
      write(unit,*)
      write(unit,*) 'SOMA:'
      write(unit,*) '#Exp ATM-c  OCN-c  total-c TTotal(sum) TWaitR-A(sum) TWaitS-A(sum) TWaitR-O(sum) TWaitS-O(sum) Ind1-WaitR(sum) Ind1-WaitS(sum)'
      do iletra=tiexp, tfexp
         letra =expletras(iletra)
         write(unit,'(1x,1a, 2x, i5, 2x, i5, 2x, i5, 2x, 7(3x, f10.2))') &
            letra, &
            ATM_ncores(iletra), &
            OCN_ncores(iletra), &
            ATM_ncores(iletra)+OCN_ncores(iletra), &
            somaRanksTotalTime(iletra), &
            somaRanks_medCiclos_tWaitR_A(iletra), &
            somaRanks_medCiclos_tWaitS_A(iletra), &
            somaRanks_medCiclos_tWaitR_O(iletra), &
            somaRanks_medCiclos_tWaitS_O(iletra), &
            ind1_Sum_R(iletra), &
            ind1_Sum_S(iletra)

      enddo ! iletra
      
      ! Tabela dos tempos MAXIMOS de todos os ranks usando ainda as medias dos 49 ciclos de cada rank:
      write(unit,*)
      write(unit,*) 'MAX:'
      write(unit,*) '#Exp ATM-c  OCN-c  total-c TTotal(max) TWaitR-A(max) TWaitS-A(max) TWaitR-O(max) TWaitS-O(max) Ind1-WaitR(max) Ind1-WaitS(max)'
      do iletra=tiexp, tfexp
         letra =expletras(iletra)
         write(unit,'(1x,1a, 2x, i5, 2x, i5, 2x, i5, 2x, 7(3x, f10.2))') &
            letra, &
            ATM_ncores(iletra), &
            OCN_ncores(iletra), &
            ATM_ncores(iletra)+OCN_ncores(iletra), &
            maxRanksTotalTime(iletra), &
            maxRanks_medCiclos_tWaitR_A(iletra), &
            maxRanks_medCiclos_tWaitS_A(iletra), &
            maxRanks_medCiclos_tWaitR_O(iletra), &
            maxRanks_medCiclos_tWaitS_O(iletra), &
            ind1_Max_R(iletra), &
            ind1_Max_S(iletra)


      enddo ! iletra
      
      
      ! Escrevendo sugestao JP de 14/11: usar a soma dos 49 ciclos para cada rank, e somar todos os ranks:
      ! Tabela a SOMA de todos os ranks usando agora a SOMA dos 49 ciclos de cada rank:
      write(unit,*)
      write(unit,*) 'SOMA(49)+SOMA(ranks): s49sr'
      write(unit,*) '#Exp ATM-c  OCN-c  total-c TTotal(s49sr) TWaitR-A(s49sr) TWaitS-A(s49sr) TWaitR-O(s49sr) TWaitS-O(s49sr) Ind1-WaitR(s49sr) Ind1-WaitS(s49sr)'
      do iletra=tiexp, tfexp
         letra =expletras(iletra)
         write(unit,'(1x,1a, 2x, i5, 2x, i5, 2x, i5, 2x, 7(5x, f10.2))') &
            letra, &
            ATM_ncores(iletra), &
            OCN_ncores(iletra), &
            ATM_ncores(iletra)+OCN_ncores(iletra), &
            somaRanksTotalTime(iletra), &
            somaRanks_somaCiclos_tWaitR_A(iletra), &
            somaRanks_somaCiclos_tWaitS_A(iletra), &
            somaRanks_somaCiclos_tWaitR_O(iletra), &
            somaRanks_somaCiclos_tWaitS_A(iletra), &
            ind1_SomaDaSoma_R(iletra), &
            ind1_SomaDaSoma_S(iletra)


      enddo ! iletra



      ! Escrevendo sugestao Stephan de 14/11: usar a media dos 49 ciclos maximosentre os ranks:
      write(unit,*)
      write(unit,*) 'MEdia dos 49 valores maximos entre os ranks:'
      write(unit,*) '#Exp ATM-c  OCN-c  total-c TTotal(s49sr) TWaitR-A(s49sr) TWaitS-A(s49sr) TWaitR-O(s49sr) TWaitS-O(s49sr)'
      do iletra=tiexp, tfexp
         letra =expletras(iletra)
         write(unit,'(1x,1a, 2x, i5, 2x, i5, 2x, i5, 2x, 7(3x, f10.2))') &
            letra, &
            ATM_ncores(iletra), &
            OCN_ncores(iletra), &
            ATM_ncores(iletra)+OCN_ncores(iletra), &
            maxRanksTotalTime(iletra), &
            media_tWaitR_A_max(iletra), &
            media_tWaitS_A_max(iletra), &
            media_tWaitR_O_max(iletra), &
            media_tWaitS_O_max(iletra)

      enddo ! iletra
   
   enddo ! unit: 6 e 16
   
   



   
end
