PROGRAM Main
  IMPLICIT NONE
  INTEGER      , PARAMETER :: r8 = SELECTED_REAL_KIND(15) ! Kind for 64-bits Real Numbers
  INTEGER, PARAMETER :: nmu = 20
  INTEGER, PARAMETER :: nlambda = 50
  INTEGER, PARAMETER :: nswbands = 14
  ! number of lw bands
 INTEGER      , PARAMETER    :: nbndsw=14
 INTEGER      , PARAMETER    :: nbndlw=16
 INTEGER      , PARAMETER    :: nlwbands = 16

  REAL(r8), ALLOCATABLE :: g_mu(:)           ! mu:units       = "unitless" ;
  REAL(r8), ALLOCATABLE :: g_lambda(:,:)     ! lambda:units   = "meter^-1" ;
  REAL(r8), ALLOCATABLE :: ext_sw_liq(:,:,:) ! k_ext_sw:units = "meters^2/kg" ;
  REAL(r8), ALLOCATABLE :: ssa_sw_liq(:,:,:) ! ssa_sw  :units = "0 to 1 unitless" ;
  REAL(r8), ALLOCATABLE :: asm_sw_liq(:,:,:) ! asm_sw:units   = "-1 to 1 unitless" ;
  REAL(r8), ALLOCATABLE :: abs_lw_liq(:,:,:) ! k_abs_lw:units = "meters^2/kg" ;
  INTEGER , PARAMETER :: n_g_d = 300
  ! d_eff:long_name = "effective diameter" ;
  ! d_eff:units = "microns" ;
  REAL(r8), ALLOCATABLE :: g_d_eff(:)      !;d_eff :long_name = "effective diameter"
  !;d_eff:units = "microns" ;
  REAL(r8), ALLOCATABLE :: ext_sw_ice(:,:) !;lw_abs:long_name = "Longwave mass specific absorption for in-cloud ice water path" 
  !;lw_abs:units = "meter^2 kilogram^-1" ;
  REAL(r8), ALLOCATABLE :: ssa_sw_ice(:,:) !;sw_ext:long_name = "Shortwave extinction"
  !;sw_ext:units = "meter^2 kilogram^-1" ;
  REAL(r8), ALLOCATABLE :: asm_sw_ice(:,:) !;sw_ssa:long_name = "Shortwave single scattering albedo"
  !;sw_ssa:units = "fraction" ;
  REAL(r8), ALLOCATABLE :: abs_lw_ice(:,:) !;sw_asm:long_name = "Shortwave asymmetry parameter"
  !;sw_asm:units = "fraction" ;
  
  CHARACTER(LEN=456)           :: fNameCldOptSW ='F_nwvl200_mu20_lam50_res64_t298_c080428_litle-endian.bin'
  CHARACTER(LEN=456)           :: fNameCldOptLW ='iceoptics_c080917_litle-endian.bin'

  CHARACTER(LEN=456)           :: fNameCldOptSWTXT ='F_nwvl200_mu20_lam50_res64_t298_c080428.txt'
  CHARACTER(LEN=456)           :: fNameCldOptLWTXT ='iceoptics_c080917.txt'

    INTEGER :: ios
  

    ALLOCATE(g_mu      (nmu))
    ALLOCATE(g_lambda  (nmu,nlambda))
    ALLOCATE(ext_sw_liq(nmu,nlambda,nswbands) )
    ALLOCATE(ssa_sw_liq(nmu,nlambda,nswbands))
    ALLOCATE(asm_sw_liq(nmu,nlambda,nswbands))
    ALLOCATE(abs_lw_liq(nmu,nlambda,nlwbands))
    OPEN(11,FILE=TRIM(fNameCldOptSWTXT),&
         ACCESS='SEQUENTIAL',&
         FORM='FORMATTED',&  
         STATUS='OLD',&
         ACTION='READ', IOSTAT=ios)
    READ(11,*)g_mu   
    READ(11,*)g_lambda  
    READ(11,*)ext_sw_liq
    READ(11,*)ssa_sw_liq
    READ(11,*)asm_sw_liq
    READ(11,*)abs_lw_liq
    CLOSE(11,STATUS='KEEP')

    OPEN(1,FILE=TRIM(fNameCldOptSW),&
         ACCESS='SEQUENTIAL',&
         FORM='UNFORMATTED',&  
         STATUS='UNKNOWN',&
         ACTION='WRITE', IOSTAT=ios)
    IF (ios /= 0) THEN
       WRITE(0, '(/a)') TRIM(fNameCldOptSW)
       WRITE(0, '(/a)') &
           '*** Error: Spectral file could not be opened.'
        STOP
    END IF

    WRITE(1)g_mu   
    WRITE(1)g_lambda  
    WRITE(1)ext_sw_liq
    WRITE(1)ssa_sw_liq
    WRITE(1)asm_sw_liq
    WRITE(1)abs_lw_liq
    CLOSE(1,STATUS='KEEP')

    ALLOCATE(g_d_eff(n_g_d))
    ALLOCATE(abs_lw_ice(n_g_d,nlwbands))
    ALLOCATE(ext_sw_ice(n_g_d,nswbands))
    ALLOCATE(ssa_sw_ice(n_g_d,nswbands))
    ALLOCATE(asm_sw_ice(n_g_d,nswbands))
    OPEN(12,FILE=TRIM(fNameCldOptLWTXT),&
         ACCESS='SEQUENTIAL',&
         FORM='FORMATTED',&  
         STATUS='OLD',&
         ACTION='READ', IOSTAT=ios)
    READ(12,*)g_d_eff
    READ(12,*)abs_lw_ice
    READ(12,*)ext_sw_ice
    READ(12,*)ssa_sw_ice
    READ(12,*)asm_sw_ice
    CLOSE(12,STATUS='KEEP')
    OPEN(1,FILE=TRIM(fNameCldOptLW),&
         ACCESS='SEQUENTIAL',&
         FORM='UNFORMATTED',&  
         STATUS='UNKNOWN',&
         ACTION='WRITE', IOSTAT=ios)
    IF (ios /= 0) THEN
       WRITE(0, '(/a)') TRIM(fNameCldOptLW)
       WRITE(0, '(/a)') &
           '*** Error: Spectral file could not be opened.'
        STOP 
    END IF

    WRITE(1)g_d_eff
    WRITE(1)abs_lw_ice
    WRITE(1)ext_sw_ice
    WRITE(1)ssa_sw_ice
    WRITE(1)asm_sw_ice
    CLOSE(1,STATUS='KEEP')



END PROGRAM Main
