!     path:      $Source: /storm/rc1/cvsroot/rc/rrtmg_sw/src/rrtmg_sw_k_g.f90,v $
!     author:    $Author: mike $
!     revision:  $Revision: 1.2 $
!     created:   $Date: 2007/08/23 20:40:13 $

!  --------------------------------------------------------------------------
! |                                                                          |
! |  Copyright 2002-2007, Atmospheric & Environmental Research, Inc. (AER).  |
! |  This software may be used, copied, or redistributed as long as it is    |
! |  not sold and this copyright notice is reproduced on each copy made.     |
! |  This model is provided as is without any express or implied warranties. |
! |                       (http://www.rtweb.aer.com/)                        |
! |                                                                          |
!  --------------------------------------------------------------------------

! **************************************************************************
!      subroutine sw_kgbnn
! **************************************************************************
!  RRTM Shortwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original by J.Delamere, Atmospheric & Environmental Research.
!  Reformatted for F90: JJMorcrette, ECMWF
!  Further F90 and GCM revisions:  MJIacono, AER, July 2002
!
!  This file contains 14 subroutines that include the 
!  absorption coefficients and other data for each of the 14 shortwave
!  spectral bands used in RRTM_SW.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_SW_INIT to reduce
!  the total number of g-points from 224 to 112 for use in the GCM.
! **************************************************************************
 
 
      subroutine sw_kgb27
! **************************************************************************

      use shr_kind_mod, only: r8 => shr_kind_r8

!      use parkind, only : jpim, jprb 
      use rrsw_kg27, only : kao, kbo, sfluxrefo, raylo, &
                            scalekur, layreffr

      implicit none
      save

! Kurucz solar source function
! The following values were obtained using the "low resolution"
! version of the Kurucz solar source function.  For unknown reasons,
! the total irradiance in this band differs from the corresponding
! total in the "high-resolution" version of the Kurucz function.
! Therefore, below these values are scaled by the factor SCALEKUR.
      sfluxrefo(:) = (/ &
        & 14.0526_r8    , 11.4794_r8    , 8.72590_r8    , 5.56966_r8    , &
        & 3.80927_r8    , 1.57690_r8    , 1.15099_r8    , 1.10012_r8    , &
        & 0.658212_r8   , 5.86859e-02_r8, 5.56186e-02_r8, 4.68040e-02_r8, &
        & 3.64897e-02_r8, 3.58053e-02_r8, 1.38130e-02_r8, 1.90193e-03_r8 /)

! Rayleigh extinction coefficient at v = 2925 cm-1.
      raylo(:) = (/ &
        & 3.44534e-06_r8,4.14480e-06_r8,4.95069e-06_r8,5.81204e-06_r8, &
        & 6.69748e-06_r8,7.56488e-06_r8,8.36344e-06_r8,9.04135e-06_r8, &
        & 9.58324e-06_r8,9.81542e-06_r8,9.75119e-06_r8,9.74533e-06_r8, &
        & 9.74139e-06_r8,9.73525e-06_r8,9.73577e-06_r8,9.73618e-06_r8 /)

      scalekur = 50.15_r8/48.37_r8

      layreffr = 32

!     ------------------------------------------------------------------
!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kao(:, 1, 1) = (/ &
        & 0.22907e+00_r8,0.25625e+00_r8,0.28779e+00_r8,0.32376e+00_r8,0.36426e+00_r8 /)
      kao(:, 2, 1) = (/ &
        & 0.21913e+00_r8,0.24445e+00_r8,0.27422e+00_r8,0.30832e+00_r8,0.34694e+00_r8 /)
      kao(:, 3, 1) = (/ &
        & 0.20602e+00_r8,0.22864e+00_r8,0.25574e+00_r8,0.28721e+00_r8,0.32310e+00_r8 /)
      kao(:, 4, 1) = (/ &
        & 0.19379e+00_r8,0.21352e+00_r8,0.23771e+00_r8,0.26643e+00_r8,0.29940e+00_r8 /)
      kao(:, 5, 1) = (/ &
        & 0.18369e+00_r8,0.20061e+00_r8,0.22200e+00_r8,0.24786e+00_r8,0.27816e+00_r8 /)
      kao(:, 6, 1) = (/ &
        & 0.17517e+00_r8,0.18920e+00_r8,0.20771e+00_r8,0.23069e+00_r8,0.25817e+00_r8 /)
      kao(:, 7, 1) = (/ &
        & 0.16888e+00_r8,0.17988e+00_r8,0.19559e+00_r8,0.21577e+00_r8,0.24042e+00_r8 /)
      kao(:, 8, 1) = (/ &
        & 0.16442e+00_r8,0.17273e+00_r8,0.18565e+00_r8,0.20315e+00_r8,0.22512e+00_r8 /)
      kao(:, 9, 1) = (/ &
        & 0.16159e+00_r8,0.16738e+00_r8,0.17752e+00_r8,0.19242e+00_r8,0.21179e+00_r8 /)
      kao(:,10, 1) = (/ &
        & 0.16037e+00_r8,0.16402e+00_r8,0.17204e+00_r8,0.18463e+00_r8,0.20183e+00_r8 /)
      kao(:,11, 1) = (/ &
        & 0.16036e+00_r8,0.16399e+00_r8,0.17198e+00_r8,0.18455e+00_r8,0.20173e+00_r8 /)
      kao(:,12, 1) = (/ &
        & 0.16036e+00_r8,0.16399e+00_r8,0.17198e+00_r8,0.18455e+00_r8,0.20173e+00_r8 /)
      kao(:,13, 1) = (/ &
        & 0.16036e+00_r8,0.16399e+00_r8,0.17198e+00_r8,0.18455e+00_r8,0.20173e+00_r8 /)
      kao(:, 1, 2) = (/ &
        & 0.20716e+01_r8,0.21925e+01_r8,0.23327e+01_r8,0.24921e+01_r8,0.26726e+01_r8 /)
      kao(:, 2, 2) = (/ &
        & 0.20272e+01_r8,0.21401e+01_r8,0.22723e+01_r8,0.24238e+01_r8,0.25950e+01_r8 /)
      kao(:, 3, 2) = (/ &
        & 0.19684e+01_r8,0.20697e+01_r8,0.21902e+01_r8,0.23301e+01_r8,0.24892e+01_r8 /)
      kao(:, 4, 2) = (/ &
        & 0.19133e+01_r8,0.20021e+01_r8,0.21101e+01_r8,0.22375e+01_r8,0.23842e+01_r8 /)
      kao(:, 5, 2) = (/ &
        & 0.18673e+01_r8,0.19441e+01_r8,0.20400e+01_r8,0.21553e+01_r8,0.22898e+01_r8 /)
      kao(:, 6, 2) = (/ &
        & 0.18277e+01_r8,0.18925e+01_r8,0.19760e+01_r8,0.20788e+01_r8,0.22009e+01_r8 /)
      kao(:, 7, 2) = (/ &
        & 0.17963e+01_r8,0.18497e+01_r8,0.19214e+01_r8,0.20121e+01_r8,0.21222e+01_r8 /)
      kao(:, 8, 2) = (/ &
        & 0.17749e+01_r8,0.18156e+01_r8,0.18763e+01_r8,0.19555e+01_r8,0.20540e+01_r8 /)
      kao(:, 9, 2) = (/ &
        & 0.17600e+01_r8,0.17885e+01_r8,0.18388e+01_r8,0.19071e+01_r8,0.19943e+01_r8 /)
      kao(:,10, 2) = (/ &
        & 0.17526e+01_r8,0.17729e+01_r8,0.18121e+01_r8,0.18716e+01_r8,0.19496e+01_r8 /)
      kao(:,11, 2) = (/ &
        & 0.17525e+01_r8,0.17727e+01_r8,0.18119e+01_r8,0.18712e+01_r8,0.19491e+01_r8 /)
      kao(:,12, 2) = (/ &
        & 0.17525e+01_r8,0.17727e+01_r8,0.18119e+01_r8,0.18712e+01_r8,0.19491e+01_r8 /)
      kao(:,13, 2) = (/ &
        & 0.17525e+01_r8,0.17727e+01_r8,0.18119e+01_r8,0.18712e+01_r8,0.19491e+01_r8 /)
      kao(:, 1, 3) = (/ &
        & 0.12189e+02_r8,0.12619e+02_r8,0.13110e+02_r8,0.13663e+02_r8,0.14275e+02_r8 /)
      kao(:, 2, 3) = (/ &
        & 0.12030e+02_r8,0.12434e+02_r8,0.12899e+02_r8,0.13427e+02_r8,0.14015e+02_r8 /)
      kao(:, 3, 3) = (/ &
        & 0.11816e+02_r8,0.12183e+02_r8,0.12611e+02_r8,0.13101e+02_r8,0.13653e+02_r8 /)
      kao(:, 4, 3) = (/ &
        & 0.11611e+02_r8,0.11938e+02_r8,0.12327e+02_r8,0.12777e+02_r8,0.13289e+02_r8 /)
      kao(:, 5, 3) = (/ &
        & 0.11437e+02_r8,0.11726e+02_r8,0.12076e+02_r8,0.12488e+02_r8,0.12961e+02_r8 /)
      kao(:, 6, 3) = (/ &
        & 0.11284e+02_r8,0.11533e+02_r8,0.11843e+02_r8,0.12215e+02_r8,0.12649e+02_r8 /)
      kao(:, 7, 3) = (/ &
        & 0.11160e+02_r8,0.11370e+02_r8,0.11641e+02_r8,0.11975e+02_r8,0.12370e+02_r8 /)
      kao(:, 8, 3) = (/ &
        & 0.11063e+02_r8,0.11237e+02_r8,0.11471e+02_r8,0.11768e+02_r8,0.12126e+02_r8 /)
      kao(:, 9, 3) = (/ &
        & 0.10990e+02_r8,0.11129e+02_r8,0.11327e+02_r8,0.11588e+02_r8,0.11910e+02_r8 /)
      kao(:,10, 3) = (/ &
        & 0.10945e+02_r8,0.11053e+02_r8,0.11223e+02_r8,0.11454e+02_r8,0.11746e+02_r8 /)
      kao(:,11, 3) = (/ &
        & 0.10945e+02_r8,0.11052e+02_r8,0.11222e+02_r8,0.11452e+02_r8,0.11744e+02_r8 /)
      kao(:,12, 3) = (/ &
        & 0.10945e+02_r8,0.11052e+02_r8,0.11222e+02_r8,0.11452e+02_r8,0.11744e+02_r8 /)
      kao(:,13, 3) = (/ &
        & 0.10945e+02_r8,0.11052e+02_r8,0.11222e+02_r8,0.11452e+02_r8,0.11744e+02_r8 /)
      kao(:, 1, 4) = (/ &
        & 0.55057e+02_r8,0.56143e+02_r8,0.57364e+02_r8,0.58719e+02_r8,0.60208e+02_r8 /)
      kao(:, 2, 4) = (/ &
        & 0.54647e+02_r8,0.55677e+02_r8,0.56842e+02_r8,0.58142e+02_r8,0.59575e+02_r8 /)
      kao(:, 3, 4) = (/ &
        & 0.54090e+02_r8,0.55039e+02_r8,0.56123e+02_r8,0.57342e+02_r8,0.58694e+02_r8 /)
      kao(:, 4, 4) = (/ &
        & 0.53548e+02_r8,0.54410e+02_r8,0.55408e+02_r8,0.56539e+02_r8,0.57805e+02_r8 /)
      kao(:, 5, 4) = (/ &
        & 0.53074e+02_r8,0.53853e+02_r8,0.54766e+02_r8,0.55813e+02_r8,0.56995e+02_r8 /)
      kao(:, 6, 4) = (/ &
        & 0.52644e+02_r8,0.53336e+02_r8,0.54162e+02_r8,0.55123e+02_r8,0.56218e+02_r8 /)
      kao(:, 7, 4) = (/ &
        & 0.52279e+02_r8,0.52887e+02_r8,0.53629e+02_r8,0.54505e+02_r8,0.55516e+02_r8 /)
      kao(:, 8, 4) = (/ &
        & 0.51979e+02_r8,0.52507e+02_r8,0.53168e+02_r8,0.53965e+02_r8,0.54895e+02_r8 /)
      kao(:, 9, 4) = (/ &
        & 0.51734e+02_r8,0.52183e+02_r8,0.52767e+02_r8,0.53485e+02_r8,0.54337e+02_r8 /)
      kao(:,10, 4) = (/ &
        & 0.51565e+02_r8,0.51948e+02_r8,0.52467e+02_r8,0.53120e+02_r8,0.53907e+02_r8 /)
      kao(:,11, 4) = (/ &
        & 0.51563e+02_r8,0.51946e+02_r8,0.52464e+02_r8,0.53116e+02_r8,0.53902e+02_r8 /)
      kao(:,12, 4) = (/ &
        & 0.51563e+02_r8,0.51946e+02_r8,0.52464e+02_r8,0.53116e+02_r8,0.53902e+02_r8 /)
      kao(:,13, 4) = (/ &
        & 0.51563e+02_r8,0.51946e+02_r8,0.52464e+02_r8,0.53116e+02_r8,0.53902e+02_r8 /)
      kao(:, 1, 5) = (/ &
        & 0.17794e+03_r8,0.17973e+03_r8,0.18164e+03_r8,0.18366e+03_r8,0.18581e+03_r8 /)
      kao(:, 2, 5) = (/ &
        & 0.17724e+03_r8,0.17898e+03_r8,0.18083e+03_r8,0.18281e+03_r8,0.18491e+03_r8 /)
      kao(:, 3, 5) = (/ &
        & 0.17624e+03_r8,0.17791e+03_r8,0.17970e+03_r8,0.18160e+03_r8,0.18363e+03_r8 /)
      kao(:, 4, 5) = (/ &
        & 0.17523e+03_r8,0.17682e+03_r8,0.17853e+03_r8,0.18036e+03_r8,0.18231e+03_r8 /)
      kao(:, 5, 5) = (/ &
        & 0.17429e+03_r8,0.17581e+03_r8,0.17744e+03_r8,0.17920e+03_r8,0.18107e+03_r8 /)
      kao(:, 6, 5) = (/ &
        & 0.17338e+03_r8,0.17482e+03_r8,0.17638e+03_r8,0.17805e+03_r8,0.17985e+03_r8 /)
      kao(:, 7, 5) = (/ &
        & 0.17253e+03_r8,0.17390e+03_r8,0.17539e+03_r8,0.17699e+03_r8,0.17871e+03_r8 /)
      kao(:, 8, 5) = (/ &
        & 0.17177e+03_r8,0.17307e+03_r8,0.17448e+03_r8,0.17601e+03_r8,0.17767e+03_r8 /)
      kao(:, 9, 5) = (/ &
        & 0.17107e+03_r8,0.17230e+03_r8,0.17364e+03_r8,0.17511e+03_r8,0.17669e+03_r8 /)
      kao(:,10, 5) = (/ &
        & 0.17052e+03_r8,0.17169e+03_r8,0.17298e+03_r8,0.17438e+03_r8,0.17591e+03_r8 /)
      kao(:,11, 5) = (/ &
        & 0.17051e+03_r8,0.17168e+03_r8,0.17297e+03_r8,0.17437e+03_r8,0.17590e+03_r8 /)
      kao(:,12, 5) = (/ &
        & 0.17051e+03_r8,0.17168e+03_r8,0.17297e+03_r8,0.17437e+03_r8,0.17590e+03_r8 /)
      kao(:,13, 5) = (/ &
        & 0.17051e+03_r8,0.17168e+03_r8,0.17297e+03_r8,0.17437e+03_r8,0.17590e+03_r8 /)
      kao(:, 1, 6) = (/ &
        & 0.37680e+05_r8,0.36801e+05_r8,0.36011e+05_r8,0.35298e+05_r8,0.34715e+05_r8 /)
      kao(:, 2, 6) = (/ &
        & 0.39286e+03_r8,0.39463e+03_r8,0.39616e+03_r8,0.39748e+03_r8,0.39858e+03_r8 /)
      kao(:, 3, 6) = (/ &
        & 0.39169e+03_r8,0.39359e+03_r8,0.39526e+03_r8,0.39671e+03_r8,0.39794e+03_r8 /)
      kao(:, 4, 6) = (/ &
        & 0.39034e+03_r8,0.39239e+03_r8,0.39421e+03_r8,0.39580e+03_r8,0.39717e+03_r8 /)
      kao(:, 5, 6) = (/ &
        & 0.38895e+03_r8,0.39113e+03_r8,0.39309e+03_r8,0.39483e+03_r8,0.39634e+03_r8 /)
      kao(:, 6, 6) = (/ &
        & 0.38742e+03_r8,0.38975e+03_r8,0.39185e+03_r8,0.39373e+03_r8,0.39539e+03_r8 /)
      kao(:, 7, 6) = (/ &
        & 0.38585e+03_r8,0.38832e+03_r8,0.39056e+03_r8,0.39258e+03_r8,0.39438e+03_r8 /)
      kao(:, 8, 6) = (/ &
        & 0.38426e+03_r8,0.38686e+03_r8,0.38924e+03_r8,0.39140e+03_r8,0.39333e+03_r8 /)
      kao(:, 9, 6) = (/ &
        & 0.38264e+03_r8,0.38538e+03_r8,0.38789e+03_r8,0.39017e+03_r8,0.39223e+03_r8 /)
      kao(:,10, 6) = (/ &
        & 0.38123e+03_r8,0.38408e+03_r8,0.38670e+03_r8,0.38909e+03_r8,0.39126e+03_r8 /)
      kao(:,11, 6) = (/ &
        & 0.38122e+03_r8,0.38406e+03_r8,0.38668e+03_r8,0.38908e+03_r8,0.39125e+03_r8 /)
      kao(:,12, 6) = (/ &
        & 0.38122e+03_r8,0.38406e+03_r8,0.38668e+03_r8,0.38908e+03_r8,0.39125e+03_r8 /)
      kao(:,13, 6) = (/ &
        & 0.38122e+03_r8,0.38406e+03_r8,0.38668e+03_r8,0.38908e+03_r8,0.39125e+03_r8 /)
      kao(:, 1, 7) = (/ &
        & 0.18202e+07_r8,0.17771e+07_r8,0.17382e+07_r8,0.17034e+07_r8,0.16716e+07_r8 /)
      kao(:, 2, 7) = (/ &
        & 0.63027e+03_r8,0.63194e+03_r8,0.63388e+03_r8,0.63607e+03_r8,0.63849e+03_r8 /)
      kao(:, 3, 7) = (/ &
        & 0.62938e+03_r8,0.63090e+03_r8,0.63268e+03_r8,0.63472e+03_r8,0.63701e+03_r8 /)
      kao(:, 4, 7) = (/ &
        & 0.62853e+03_r8,0.62989e+03_r8,0.63150e+03_r8,0.63337e+03_r8,0.63550e+03_r8 /)
      kao(:, 5, 7) = (/ &
        & 0.62781e+03_r8,0.62901e+03_r8,0.63046e+03_r8,0.63217e+03_r8,0.63413e+03_r8 /)
      kao(:, 6, 7) = (/ &
        & 0.62717e+03_r8,0.62821e+03_r8,0.62950e+03_r8,0.63104e+03_r8,0.63283e+03_r8 /)
      kao(:, 7, 7) = (/ &
        & 0.62666e+03_r8,0.62753e+03_r8,0.62867e+03_r8,0.63005e+03_r8,0.63168e+03_r8 /)
      kao(:, 8, 7) = (/ &
        & 0.62627e+03_r8,0.62698e+03_r8,0.62795e+03_r8,0.62919e+03_r8,0.63067e+03_r8 /)
      kao(:, 9, 7) = (/ &
        & 0.62600e+03_r8,0.62653e+03_r8,0.62735e+03_r8,0.62844e+03_r8,0.62978e+03_r8 /)
      kao(:,10, 7) = (/ &
        & 0.62583e+03_r8,0.62624e+03_r8,0.62692e+03_r8,0.62788e+03_r8,0.62910e+03_r8 /)
      kao(:,11, 7) = (/ &
        & 0.62583e+03_r8,0.62623e+03_r8,0.62691e+03_r8,0.62787e+03_r8,0.62909e+03_r8 /)
      kao(:,12, 7) = (/ &
        & 0.62583e+03_r8,0.62623e+03_r8,0.62691e+03_r8,0.62787e+03_r8,0.62909e+03_r8 /)
      kao(:,13, 7) = (/ &
        & 0.62583e+03_r8,0.62623e+03_r8,0.62691e+03_r8,0.62787e+03_r8,0.62909e+03_r8 /)
      kao(:, 1, 8) = (/ &
        & 0.55488e+07_r8,0.54180e+07_r8,0.53005e+07_r8,0.51943e+07_r8,0.50978e+07_r8 /)
      kao(:, 2, 8) = (/ &
        & 0.82143e+03_r8,0.82232e+03_r8,0.82327e+03_r8,0.82429e+03_r8,0.82541e+03_r8 /)
      kao(:, 3, 8) = (/ &
        & 0.82092e+03_r8,0.82177e+03_r8,0.82269e+03_r8,0.82366e+03_r8,0.82472e+03_r8 /)
      kao(:, 4, 8) = (/ &
        & 0.82041e+03_r8,0.82121e+03_r8,0.82209e+03_r8,0.82303e+03_r8,0.82402e+03_r8 /)
      kao(:, 5, 8) = (/ &
        & 0.81996e+03_r8,0.82070e+03_r8,0.82152e+03_r8,0.82243e+03_r8,0.82339e+03_r8 /)
      kao(:, 6, 8) = (/ &
        & 0.81952e+03_r8,0.82021e+03_r8,0.82098e+03_r8,0.82184e+03_r8,0.82277e+03_r8 /)
      kao(:, 7, 8) = (/ &
        & 0.81917e+03_r8,0.81977e+03_r8,0.82048e+03_r8,0.82129e+03_r8,0.82218e+03_r8 /)
      kao(:, 8, 8) = (/ &
        & 0.81881e+03_r8,0.81938e+03_r8,0.82004e+03_r8,0.82080e+03_r8,0.82163e+03_r8 /)
      kao(:, 9, 8) = (/ &
        & 0.81846e+03_r8,0.81906e+03_r8,0.81965e+03_r8,0.82035e+03_r8,0.82114e+03_r8 /)
      kao(:,10, 8) = (/ &
        & 0.81821e+03_r8,0.81877e+03_r8,0.81934e+03_r8,0.82000e+03_r8,0.82074e+03_r8 /)
      kao(:,11, 8) = (/ &
        & 0.81821e+03_r8,0.81877e+03_r8,0.81934e+03_r8,0.81999e+03_r8,0.82074e+03_r8 /)
      kao(:,12, 8) = (/ &
        & 0.81821e+03_r8,0.81877e+03_r8,0.81934e+03_r8,0.81999e+03_r8,0.82074e+03_r8 /)
      kao(:,13, 8) = (/ &
        & 0.81821e+03_r8,0.81877e+03_r8,0.81935e+03_r8,0.81999e+03_r8,0.82074e+03_r8 /)
      kao(:, 1, 9) = (/ &
        & 0.10204e+08_r8,0.99477e+07_r8,0.97209e+07_r8,0.95103e+07_r8,0.92960e+07_r8 /)
      kao(:, 2, 9) = (/ &
        & 0.95102e+03_r8,0.95144e+03_r8,0.95133e+03_r8,0.95066e+03_r8,0.94964e+03_r8 /)
      kao(:, 3, 9) = (/ &
        & 0.95048e+03_r8,0.95118e+03_r8,0.95136e+03_r8,0.95103e+03_r8,0.95020e+03_r8 /)
      kao(:, 4, 9) = (/ &
        & 0.94969e+03_r8,0.95077e+03_r8,0.95126e+03_r8,0.95124e+03_r8,0.95074e+03_r8 /)
      kao(:, 5, 9) = (/ &
        & 0.94872e+03_r8,0.95015e+03_r8,0.95101e+03_r8,0.95129e+03_r8,0.95105e+03_r8 /)
      kao(:, 6, 9) = (/ &
        & 0.94752e+03_r8,0.94929e+03_r8,0.95052e+03_r8,0.95116e+03_r8,0.95126e+03_r8 /)
      kao(:, 7, 9) = (/ &
        & 0.94612e+03_r8,0.94825e+03_r8,0.94981e+03_r8,0.95083e+03_r8,0.95126e+03_r8 /)
      kao(:, 8, 9) = (/ &
        & 0.94461e+03_r8,0.94704e+03_r8,0.94894e+03_r8,0.95029e+03_r8,0.95107e+03_r8 /)
      kao(:, 9, 9) = (/ &
        & 0.94291e+03_r8,0.94567e+03_r8,0.94791e+03_r8,0.94957e+03_r8,0.95069e+03_r8 /)
      kao(:,10, 9) = (/ &
        & 0.94135e+03_r8,0.94441e+03_r8,0.94689e+03_r8,0.94884e+03_r8,0.95022e+03_r8 /)
      kao(:,11, 9) = (/ &
        & 0.94133e+03_r8,0.94440e+03_r8,0.94688e+03_r8,0.94883e+03_r8,0.95021e+03_r8 /)
      kao(:,12, 9) = (/ &
        & 0.94133e+03_r8,0.94438e+03_r8,0.94688e+03_r8,0.94883e+03_r8,0.95021e+03_r8 /)
      kao(:,13, 9) = (/ &
        & 0.94133e+03_r8,0.94438e+03_r8,0.94687e+03_r8,0.94883e+03_r8,0.95021e+03_r8 /)
      kao(:, 1,10) = (/ &
        & 0.12764e+08_r8,0.12408e+08_r8,0.12012e+08_r8,0.11438e+08_r8,0.11217e+08_r8 /)
      kao(:, 2,10) = (/ &
        & 0.99589e+03_r8,0.99493e+03_r8,0.99263e+03_r8,0.98974e+03_r8,0.98742e+03_r8 /)
      kao(:, 3,10) = (/ &
        & 0.99532e+03_r8,0.99571e+03_r8,0.99447e+03_r8,0.99207e+03_r8,0.98779e+03_r8 /)
      kao(:, 4,10) = (/ &
        & 0.99446e+03_r8,0.99559e+03_r8,0.99536e+03_r8,0.99386e+03_r8,0.99088e+03_r8 /)
      kao(:, 5,10) = (/ &
        & 0.99288e+03_r8,0.99493e+03_r8,0.99558e+03_r8,0.99487e+03_r8,0.99336e+03_r8 /)
      kao(:, 6,10) = (/ &
        & 0.99069e+03_r8,0.99366e+03_r8,0.99519e+03_r8,0.99534e+03_r8,0.99428e+03_r8 /)
      kao(:, 7,10) = (/ &
        & 0.98811e+03_r8,0.99191e+03_r8,0.99430e+03_r8,0.99510e+03_r8,0.99504e+03_r8 /)
      kao(:, 8,10) = (/ &
        & 0.98531e+03_r8,0.98996e+03_r8,0.99300e+03_r8,0.99479e+03_r8,0.99513e+03_r8 /)
      kao(:, 9,10) = (/ &
        & 0.98264e+03_r8,0.98737e+03_r8,0.99138e+03_r8,0.99390e+03_r8,0.99503e+03_r8 /)
      kao(:,10,10) = (/ &
        & 0.98010e+03_r8,0.98517e+03_r8,0.98974e+03_r8,0.99281e+03_r8,0.99470e+03_r8 /)
      kao(:,11,10) = (/ &
        & 0.98010e+03_r8,0.98509e+03_r8,0.98985e+03_r8,0.99280e+03_r8,0.99468e+03_r8 /)
      kao(:,12,10) = (/ &
        & 0.98035e+03_r8,0.98524e+03_r8,0.98973e+03_r8,0.99279e+03_r8,0.99468e+03_r8 /)
      kao(:,13,10) = (/ &
        & 0.98012e+03_r8,0.98526e+03_r8,0.98973e+03_r8,0.99279e+03_r8,0.99468e+03_r8 /)
      kao(:, 1,11) = (/ &
        & 0.12266e+08_r8,0.12000e+08_r8,0.11724e+08_r8,0.11828e+08_r8,0.11523e+08_r8 /)
      kao(:, 2,11) = (/ &
        & 0.10001e+04_r8,0.99984e+03_r8,0.99745e+03_r8,0.99535e+03_r8,0.98599e+03_r8 /)
      kao(:, 3,11) = (/ &
        & 0.99963e+03_r8,0.99927e+03_r8,0.99848e+03_r8,0.99596e+03_r8,0.99390e+03_r8 /)
      kao(:, 4,11) = (/ &
        & 0.99904e+03_r8,0.99942e+03_r8,0.99870e+03_r8,0.99747e+03_r8,0.99542e+03_r8 /)
      kao(:, 5,11) = (/ &
        & 0.99826e+03_r8,0.99927e+03_r8,0.99919e+03_r8,0.99821e+03_r8,0.99627e+03_r8 /)
      kao(:, 6,11) = (/ &
        & 0.99730e+03_r8,0.99882e+03_r8,0.99938e+03_r8,0.99902e+03_r8,0.99764e+03_r8 /)
      kao(:, 7,11) = (/ &
        & 0.99551e+03_r8,0.99810e+03_r8,0.99919e+03_r8,0.99961e+03_r8,0.99863e+03_r8 /)
      kao(:, 8,11) = (/ &
        & 0.99324e+03_r8,0.99688e+03_r8,0.99871e+03_r8,0.99940e+03_r8,0.99942e+03_r8 /)
      kao(:, 9,11) = (/ &
        & 0.99058e+03_r8,0.99489e+03_r8,0.99773e+03_r8,0.99912e+03_r8,0.99954e+03_r8 /)
      kao(:,10,11) = (/ &
        & 0.98802e+03_r8,0.99297e+03_r8,0.99656e+03_r8,0.99861e+03_r8,0.99937e+03_r8 /)
      kao(:,11,11) = (/ &
        & 0.98800e+03_r8,0.99310e+03_r8,0.99655e+03_r8,0.99860e+03_r8,0.99936e+03_r8 /)
      kao(:,12,11) = (/ &
        & 0.98771e+03_r8,0.99296e+03_r8,0.99669e+03_r8,0.99859e+03_r8,0.99936e+03_r8 /)
      kao(:,13,11) = (/ &
        & 0.98800e+03_r8,0.99296e+03_r8,0.99655e+03_r8,0.99859e+03_r8,0.99936e+03_r8 /)
      kao(:, 1,12) = (/ &
        & 0.12503e+08_r8,0.11946e+08_r8,0.11557e+08_r8,0.11503e+08_r8,0.11901e+08_r8 /)
      kao(:, 2,12) = (/ &
        & 0.10015e+04_r8,0.10004e+04_r8,0.99932e+03_r8,0.99373e+03_r8,0.98591e+03_r8 /)
      kao(:, 3,12) = (/ &
        & 0.10024e+04_r8,0.10021e+04_r8,0.10003e+04_r8,0.99817e+03_r8,0.99146e+03_r8 /)
      kao(:, 4,12) = (/ &
        & 0.10022e+04_r8,0.10027e+04_r8,0.10021e+04_r8,0.99956e+03_r8,0.99610e+03_r8 /)
      kao(:, 5,12) = (/ &
        & 0.10024e+04_r8,0.10024e+04_r8,0.10028e+04_r8,0.10015e+04_r8,0.99826e+03_r8 /)
      kao(:, 6,12) = (/ &
        & 0.10017e+04_r8,0.10025e+04_r8,0.10025e+04_r8,0.10023e+04_r8,0.10008e+04_r8 /)
      kao(:, 7,12) = (/ &
        & 0.10005e+04_r8,0.10020e+04_r8,0.10028e+04_r8,0.10028e+04_r8,0.10019e+04_r8 /)
      kao(:, 8,12) = (/ &
        & 0.10000e+04_r8,0.10010e+04_r8,0.10024e+04_r8,0.10029e+04_r8,0.10023e+04_r8 /)
      kao(:, 9,12) = (/ &
        & 0.99906e+03_r8,0.10004e+04_r8,0.10018e+04_r8,0.10029e+04_r8,0.10028e+04_r8 /)
      kao(:,10,12) = (/ &
        & 0.99791e+03_r8,0.99989e+03_r8,0.10010e+04_r8,0.10024e+04_r8,0.10031e+04_r8 /)
      kao(:,11,12) = (/ &
        & 0.99769e+03_r8,0.99967e+03_r8,0.10008e+04_r8,0.10024e+04_r8,0.10029e+04_r8 /)
      kao(:,12,12) = (/ &
        & 0.99787e+03_r8,0.99985e+03_r8,0.10008e+04_r8,0.10025e+04_r8,0.10029e+04_r8 /)
      kao(:,13,12) = (/ &
        & 0.99768e+03_r8,0.99984e+03_r8,0.10012e+04_r8,0.10026e+04_r8,0.10029e+04_r8 /)
      kao(:, 1,13) = (/ &
        & 0.12359e+08_r8,0.12469e+08_r8,0.12868e+08_r8,0.12776e+08_r8,0.12590e+08_r8 /)
      kao(:, 2,13) = (/ &
        & 0.10045e+04_r8,0.10033e+04_r8,0.99840e+03_r8,0.99184e+03_r8,0.98861e+03_r8 /)
      kao(:, 3,13) = (/ &
        & 0.10050e+04_r8,0.10041e+04_r8,0.10024e+04_r8,0.99701e+03_r8,0.99083e+03_r8 /)
      kao(:, 4,13) = (/ &
        & 0.10053e+04_r8,0.10043e+04_r8,0.10035e+04_r8,0.10017e+04_r8,0.99538e+03_r8 /)
      kao(:, 5,13) = (/ &
        & 0.10048e+04_r8,0.10056e+04_r8,0.10038e+04_r8,0.10026e+04_r8,0.10008e+04_r8 /)
      kao(:, 6,13) = (/ &
        & 0.10042e+04_r8,0.10054e+04_r8,0.10054e+04_r8,0.10039e+04_r8,0.10017e+04_r8 /)
      kao(:, 7,13) = (/ &
        & 0.10029e+04_r8,0.10046e+04_r8,0.10055e+04_r8,0.10046e+04_r8,0.10033e+04_r8 /)
      kao(:, 8,13) = (/ &
        & 0.10002e+04_r8,0.10039e+04_r8,0.10051e+04_r8,0.10054e+04_r8,0.10046e+04_r8 /)
      kao(:, 9,13) = (/ &
        & 0.99825e+03_r8,0.10019e+04_r8,0.10043e+04_r8,0.10051e+04_r8,0.10052e+04_r8 /)
      kao(:,10,13) = (/ &
        & 0.99595e+03_r8,0.99983e+03_r8,0.10034e+04_r8,0.10050e+04_r8,0.10051e+04_r8 /)
      kao(:,11,13) = (/ &
        & 0.99621e+03_r8,0.99979e+03_r8,0.10034e+04_r8,0.10050e+04_r8,0.10054e+04_r8 /)
      kao(:,12,13) = (/ &
        & 0.99597e+03_r8,0.99979e+03_r8,0.10031e+04_r8,0.10047e+04_r8,0.10054e+04_r8 /)
      kao(:,13,13) = (/ &
        & 0.99623e+03_r8,0.99978e+03_r8,0.10031e+04_r8,0.10047e+04_r8,0.10054e+04_r8 /)
      kao(:, 1,14) = (/ &
        & 0.13636e+08_r8,0.13818e+08_r8,0.13518e+08_r8,0.13266e+08_r8,0.13048e+08_r8 /)
      kao(:, 2,14) = (/ &
        & 0.10049e+04_r8,0.99946e+03_r8,0.99774e+03_r8,0.99774e+03_r8,0.99771e+03_r8 /)
      kao(:, 3,14) = (/ &
        & 0.10051e+04_r8,0.10068e+04_r8,0.10007e+04_r8,0.99775e+03_r8,0.99778e+03_r8 /)
      kao(:, 4,14) = (/ &
        & 0.10071e+04_r8,0.10061e+04_r8,0.10050e+04_r8,0.10005e+04_r8,0.99776e+03_r8 /)
      kao(:, 5,14) = (/ &
        & 0.10067e+04_r8,0.10072e+04_r8,0.10061e+04_r8,0.10044e+04_r8,0.99972e+03_r8 /)
      kao(:, 6,14) = (/ &
        & 0.10049e+04_r8,0.10070e+04_r8,0.10074e+04_r8,0.10057e+04_r8,0.10037e+04_r8 /)
      kao(:, 7,14) = (/ &
        & 0.10033e+04_r8,0.10063e+04_r8,0.10072e+04_r8,0.10067e+04_r8,0.10050e+04_r8 /)
      kao(:, 8,14) = (/ &
        & 0.10025e+04_r8,0.10048e+04_r8,0.10068e+04_r8,0.10071e+04_r8,0.10062e+04_r8 /)
      kao(:, 9,14) = (/ &
        & 0.99880e+03_r8,0.10031e+04_r8,0.10060e+04_r8,0.10071e+04_r8,0.10069e+04_r8 /)
      kao(:,10,14) = (/ &
        & 0.99610e+03_r8,0.10023e+04_r8,0.10047e+04_r8,0.10067e+04_r8,0.10072e+04_r8 /)
      kao(:,11,14) = (/ &
        & 0.99601e+03_r8,0.10023e+04_r8,0.10047e+04_r8,0.10067e+04_r8,0.10072e+04_r8 /)
      kao(:,12,14) = (/ &
        & 0.99598e+03_r8,0.10023e+04_r8,0.10051e+04_r8,0.10067e+04_r8,0.10076e+04_r8 /)
      kao(:,13,14) = (/ &
        & 0.99596e+03_r8,0.10027e+04_r8,0.10047e+04_r8,0.10067e+04_r8,0.10072e+04_r8 /)
      kao(:, 1,15) = (/ &
        & 0.14285e+08_r8,0.13947e+08_r8,0.13644e+08_r8,0.13317e+08_r8,0.13015e+08_r8 /)
      kao(:, 2,15) = (/ &
        & 0.99932e+03_r8,0.10011e+04_r8,0.10018e+04_r8,0.10007e+04_r8,0.99706e+03_r8 /)
      kao(:, 3,15) = (/ &
        & 0.10097e+04_r8,0.99743e+03_r8,0.10015e+04_r8,0.10018e+04_r8,0.99920e+03_r8 /)
      kao(:, 4,15) = (/ &
        & 0.10099e+04_r8,0.10076e+04_r8,0.10030e+04_r8,0.10017e+04_r8,0.10013e+04_r8 /)
      kao(:, 5,15) = (/ &
        & 0.10075e+04_r8,0.10079e+04_r8,0.10073e+04_r8,0.10035e+04_r8,0.10018e+04_r8 /)
      kao(:, 6,15) = (/ &
        & 0.10068e+04_r8,0.10088e+04_r8,0.10068e+04_r8,0.10090e+04_r8,0.10033e+04_r8 /)
      kao(:, 7,15) = (/ &
        & 0.10057e+04_r8,0.10073e+04_r8,0.10090e+04_r8,0.10087e+04_r8,0.10062e+04_r8 /)
      kao(:, 8,15) = (/ &
        & 0.10010e+04_r8,0.10054e+04_r8,0.10076e+04_r8,0.10079e+04_r8,0.10072e+04_r8 /)
      kao(:, 9,15) = (/ &
        & 0.99853e+03_r8,0.10054e+04_r8,0.10071e+04_r8,0.10079e+04_r8,0.10078e+04_r8 /)
      kao(:,10,15) = (/ &
        & 0.99742e+03_r8,0.10007e+04_r8,0.10064e+04_r8,0.10076e+04_r8,0.10080e+04_r8 /)
      kao(:,11,15) = (/ &
        & 0.99635e+03_r8,0.10006e+04_r8,0.10064e+04_r8,0.10087e+04_r8,0.10090e+04_r8 /)
      kao(:,12,15) = (/ &
        & 0.99635e+03_r8,0.10006e+04_r8,0.10064e+04_r8,0.10087e+04_r8,0.10069e+04_r8 /)
      kao(:,13,15) = (/ &
        & 0.99635e+03_r8,0.99960e+03_r8,0.10064e+04_r8,0.10076e+04_r8,0.10080e+04_r8 /)
      kao(:, 1,16) = (/ &
        & 0.14326e+08_r8,0.13988e+08_r8,0.13684e+08_r8,0.13409e+08_r8,0.13021e+08_r8 /)
      kao(:, 2,16) = (/ &
        & 0.10008e+04_r8,0.10027e+04_r8,0.10036e+04_r8,0.10037e+04_r8,0.99673e+03_r8 /)
      kao(:, 3,16) = (/ &
        & 0.99286e+03_r8,0.10016e+04_r8,0.10031e+04_r8,0.10038e+04_r8,0.10035e+04_r8 /)
      kao(:, 4,16) = (/ &
        & 0.99278e+03_r8,0.10078e+04_r8,0.10023e+04_r8,0.10035e+04_r8,0.10038e+04_r8 /)
      kao(:, 5,16) = (/ &
        & 0.10074e+04_r8,0.10079e+04_r8,0.10075e+04_r8,0.10028e+04_r8,0.10037e+04_r8 /)
      kao(:, 6,16) = (/ &
        & 0.10069e+04_r8,0.10002e+04_r8,0.10079e+04_r8,0.99212e+03_r8,0.10032e+04_r8 /)
      kao(:, 7,16) = (/ &
        & 0.10060e+04_r8,0.10072e+04_r8,0.10004e+04_r8,0.10003e+04_r8,0.10063e+04_r8 /)
      kao(:, 8,16) = (/ &
        & 0.10009e+04_r8,0.10066e+04_r8,0.10075e+04_r8,0.10080e+04_r8,0.10074e+04_r8 /)
      kao(:, 9,16) = (/ &
        & 0.99860e+03_r8,0.10057e+04_r8,0.10071e+04_r8,0.10078e+04_r8,0.10079e+04_r8 /)
      kao(:,10,16) = (/ &
        & 0.98908e+03_r8,0.10006e+04_r8,0.10065e+04_r8,0.10075e+04_r8,0.10080e+04_r8 /)
      kao(:,11,16) = (/ &
        & 0.99644e+03_r8,0.10006e+04_r8,0.10065e+04_r8,0.10000e+04_r8,0.10005e+04_r8 /)
      kao(:,12,16) = (/ &
        & 0.99644e+03_r8,0.10006e+04_r8,0.10065e+04_r8,0.10000e+04_r8,0.10080e+04_r8 /)
      kao(:,13,16) = (/ &
        & 0.99644e+03_r8,0.10006e+04_r8,0.10065e+04_r8,0.10075e+04_r8,0.10080e+04_r8 /)
  
!     -----------------------------------------------------------------
!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------
  
      kbo(:,13, 1) = (/ &
        & 0.16036e+00_r8,0.16399e+00_r8,0.17198e+00_r8,0.18455e+00_r8,0.20173e+00_r8 /)
      kbo(:,14, 1) = (/ &
        & 0.16050e+00_r8,0.16454e+00_r8,0.17292e+00_r8,0.18592e+00_r8,0.20351e+00_r8 /)
      kbo(:,15, 1) = (/ &
        & 0.16071e+00_r8,0.16519e+00_r8,0.17400e+00_r8,0.18750e+00_r8,0.20554e+00_r8 /)
      kbo(:,16, 1) = (/ &
        & 0.16098e+00_r8,0.16593e+00_r8,0.17517e+00_r8,0.18921e+00_r8,0.20772e+00_r8 /)
      kbo(:,17, 1) = (/ &
        & 0.16129e+00_r8,0.16670e+00_r8,0.17642e+00_r8,0.19093e+00_r8,0.20991e+00_r8 /)
      kbo(:,18, 1) = (/ &
        & 0.16164e+00_r8,0.16750e+00_r8,0.17771e+00_r8,0.19267e+00_r8,0.21211e+00_r8 /)
      kbo(:,19, 1) = (/ &
        & 0.16203e+00_r8,0.16832e+00_r8,0.17901e+00_r8,0.19443e+00_r8,0.21431e+00_r8 /)
      kbo(:,20, 1) = (/ &
        & 0.16255e+00_r8,0.16934e+00_r8,0.18059e+00_r8,0.19653e+00_r8,0.21694e+00_r8 /)
      kbo(:,21, 1) = (/ &
        & 0.16313e+00_r8,0.17044e+00_r8,0.18225e+00_r8,0.19873e+00_r8,0.21967e+00_r8 /)
      kbo(:,22, 1) = (/ &
        & 0.16416e+00_r8,0.17227e+00_r8,0.18498e+00_r8,0.20229e+00_r8,0.22406e+00_r8 /)
      kbo(:,23, 1) = (/ &
        & 0.16539e+00_r8,0.17431e+00_r8,0.18796e+00_r8,0.20612e+00_r8,0.22875e+00_r8 /)
      kbo(:,24, 1) = (/ &
        & 0.16684e+00_r8,0.17666e+00_r8,0.19125e+00_r8,0.21032e+00_r8,0.23385e+00_r8 /)
      kbo(:,25, 1) = (/ &
        & 0.16856e+00_r8,0.17939e+00_r8,0.19493e+00_r8,0.21495e+00_r8,0.23943e+00_r8 /)
      kbo(:,26, 1) = (/ &
        & 0.17067e+00_r8,0.18260e+00_r8,0.19919e+00_r8,0.22024e+00_r8,0.24578e+00_r8 /)
      kbo(:,27, 1) = (/ &
        & 0.17306e+00_r8,0.18613e+00_r8,0.20377e+00_r8,0.22588e+00_r8,0.25248e+00_r8 /)
      kbo(:,28, 1) = (/ &
        & 0.17570e+00_r8,0.18994e+00_r8,0.20865e+00_r8,0.23184e+00_r8,0.25952e+00_r8 /)
      kbo(:,29, 1) = (/ &
        & 0.17882e+00_r8,0.19417e+00_r8,0.21399e+00_r8,0.23828e+00_r8,0.26708e+00_r8 /)
      kbo(:,30, 1) = (/ &
        & 0.18223e+00_r8,0.19870e+00_r8,0.21964e+00_r8,0.24505e+00_r8,0.27492e+00_r8 /)
      kbo(:,31, 1) = (/ &
        & 0.18602e+00_r8,0.20364e+00_r8,0.22572e+00_r8,0.25229e+00_r8,0.28325e+00_r8 /)
      kbo(:,32, 1) = (/ &
        & 0.19018e+00_r8,0.20895e+00_r8,0.23219e+00_r8,0.25994e+00_r8,0.29200e+00_r8 /)
      kbo(:,33, 1) = (/ &
        & 0.19466e+00_r8,0.21461e+00_r8,0.23902e+00_r8,0.26795e+00_r8,0.30114e+00_r8 /)
      kbo(:,34, 1) = (/ &
        & 0.19880e+00_r8,0.21976e+00_r8,0.24520e+00_r8,0.27509e+00_r8,0.30932e+00_r8 /)
      kbo(:,35, 1) = (/ &
        & 0.20129e+00_r8,0.22283e+00_r8,0.24886e+00_r8,0.27931e+00_r8,0.31412e+00_r8 /)
      kbo(:,36, 1) = (/ &
        & 0.20170e+00_r8,0.22334e+00_r8,0.24946e+00_r8,0.28000e+00_r8,0.31492e+00_r8 /)
      kbo(:,37, 1) = (/ &
        & 0.19920e+00_r8,0.22026e+00_r8,0.24579e+00_r8,0.27578e+00_r8,0.31010e+00_r8 /)
      kbo(:,38, 1) = (/ &
        & 0.19662e+00_r8,0.21706e+00_r8,0.24197e+00_r8,0.27135e+00_r8,0.30504e+00_r8 /)
      kbo(:,39, 1) = (/ &
        & 0.19414e+00_r8,0.21396e+00_r8,0.23824e+00_r8,0.26704e+00_r8,0.30010e+00_r8 /)
      kbo(:,40, 1) = (/ &
        & 0.19003e+00_r8,0.20877e+00_r8,0.23197e+00_r8,0.25968e+00_r8,0.29171e+00_r8 /)
      kbo(:,41, 1) = (/ &
        & 0.18597e+00_r8,0.20357e+00_r8,0.22564e+00_r8,0.25219e+00_r8,0.28314e+00_r8 /)
      kbo(:,42, 1) = (/ &
        & 0.18220e+00_r8,0.19865e+00_r8,0.21958e+00_r8,0.24498e+00_r8,0.27484e+00_r8 /)
      kbo(:,43, 1) = (/ &
        & 0.17798e+00_r8,0.19304e+00_r8,0.21257e+00_r8,0.23657e+00_r8,0.26510e+00_r8 /)
      kbo(:,44, 1) = (/ &
        & 0.17397e+00_r8,0.18746e+00_r8,0.20548e+00_r8,0.22798e+00_r8,0.25496e+00_r8 /)
      kbo(:,45, 1) = (/ &
        & 0.17053e+00_r8,0.18239e+00_r8,0.19890e+00_r8,0.21989e+00_r8,0.24535e+00_r8 /)
      kbo(:,46, 1) = (/ &
        & 0.16739e+00_r8,0.17754e+00_r8,0.19245e+00_r8,0.21183e+00_r8,0.23568e+00_r8 /)
      kbo(:,47, 1) = (/ &
        & 0.16454e+00_r8,0.17292e+00_r8,0.18592e+00_r8,0.20351e+00_r8,0.22556e+00_r8 /)
      kbo(:,48, 1) = (/ &
        & 0.16239e+00_r8,0.16903e+00_r8,0.18011e+00_r8,0.19590e+00_r8,0.21615e+00_r8 /)
      kbo(:,49, 1) = (/ &
        & 0.16095e+00_r8,0.16584e+00_r8,0.17504e+00_r8,0.18902e+00_r8,0.20747e+00_r8 /)
      kbo(:,50, 1) = (/ &
        & 0.16025e+00_r8,0.16348e+00_r8,0.17109e+00_r8,0.18322e+00_r8,0.20000e+00_r8 /)
      kbo(:,51, 1) = (/ &
        & 0.16021e+00_r8,0.16179e+00_r8,0.16781e+00_r8,0.17821e+00_r8,0.19335e+00_r8 /)
      kbo(:,52, 1) = (/ &
        & 0.16078e+00_r8,0.16068e+00_r8,0.16511e+00_r8,0.17387e+00_r8,0.18731e+00_r8 /)
      kbo(:,53, 1) = (/ &
        & 0.16197e+00_r8,0.16018e+00_r8,0.16299e+00_r8,0.17017e+00_r8,0.18186e+00_r8 /)
      kbo(:,54, 1) = (/ &
        & 0.16362e+00_r8,0.16026e+00_r8,0.16155e+00_r8,0.16729e+00_r8,0.17738e+00_r8 /)
      kbo(:,55, 1) = (/ &
        & 0.16570e+00_r8,0.16083e+00_r8,0.16064e+00_r8,0.16498e+00_r8,0.17365e+00_r8 /)
      kbo(:,56, 1) = (/ &
        & 0.16825e+00_r8,0.16187e+00_r8,0.16020e+00_r8,0.16311e+00_r8,0.17041e+00_r8 /)
      kbo(:,57, 1) = (/ &
        & 0.17129e+00_r8,0.16340e+00_r8,0.16023e+00_r8,0.16169e+00_r8,0.16761e+00_r8 /)
      kbo(:,58, 1) = (/ &
        & 0.17462e+00_r8,0.16529e+00_r8,0.16069e+00_r8,0.16077e+00_r8,0.16535e+00_r8 /)
      kbo(:,59, 1) = (/ &
        & 0.17607e+00_r8,0.16617e+00_r8,0.16100e+00_r8,0.16051e+00_r8,0.16456e+00_r8 /)
      kbo(:,13, 2) = (/ &
        & 0.17525e+01_r8,0.17727e+01_r8,0.18119e+01_r8,0.18712e+01_r8,0.19491e+01_r8 /)
      kbo(:,14, 2) = (/ &
        & 0.17536e+01_r8,0.17755e+01_r8,0.18165e+01_r8,0.18775e+01_r8,0.19571e+01_r8 /)
      kbo(:,15, 2) = (/ &
        & 0.17549e+01_r8,0.17787e+01_r8,0.18219e+01_r8,0.18847e+01_r8,0.19662e+01_r8 /)
      kbo(:,16, 2) = (/ &
        & 0.17565e+01_r8,0.17819e+01_r8,0.18278e+01_r8,0.18925e+01_r8,0.19761e+01_r8 /)
      kbo(:,17, 2) = (/ &
        & 0.17583e+01_r8,0.17850e+01_r8,0.18336e+01_r8,0.19003e+01_r8,0.19859e+01_r8 /)
      kbo(:,18, 2) = (/ &
        & 0.17603e+01_r8,0.17891e+01_r8,0.18396e+01_r8,0.19082e+01_r8,0.19957e+01_r8 /)
      kbo(:,19, 2) = (/ &
        & 0.17624e+01_r8,0.17934e+01_r8,0.18457e+01_r8,0.19162e+01_r8,0.20056e+01_r8 /)
      kbo(:,20, 2) = (/ &
        & 0.17652e+01_r8,0.17986e+01_r8,0.18530e+01_r8,0.19257e+01_r8,0.20174e+01_r8 /)
      kbo(:,21, 2) = (/ &
        & 0.17683e+01_r8,0.18042e+01_r8,0.18607e+01_r8,0.19356e+01_r8,0.20296e+01_r8 /)
      kbo(:,22, 2) = (/ &
        & 0.17736e+01_r8,0.18133e+01_r8,0.18732e+01_r8,0.19516e+01_r8,0.20492e+01_r8 /)
      kbo(:,23, 2) = (/ &
        & 0.17796e+01_r8,0.18234e+01_r8,0.18868e+01_r8,0.19689e+01_r8,0.20702e+01_r8 /)
      kbo(:,24, 2) = (/ &
        & 0.17857e+01_r8,0.18347e+01_r8,0.19018e+01_r8,0.19877e+01_r8,0.20929e+01_r8 /)
      kbo(:,25, 2) = (/ &
        & 0.17946e+01_r8,0.18475e+01_r8,0.19185e+01_r8,0.20085e+01_r8,0.21178e+01_r8 /)
      kbo(:,26, 2) = (/ &
        & 0.18053e+01_r8,0.18623e+01_r8,0.19377e+01_r8,0.20322e+01_r8,0.21460e+01_r8 /)
      kbo(:,27, 2) = (/ &
        & 0.18172e+01_r8,0.18785e+01_r8,0.19583e+01_r8,0.20574e+01_r8,0.21757e+01_r8 /)
      kbo(:,28, 2) = (/ &
        & 0.18303e+01_r8,0.18959e+01_r8,0.19802e+01_r8,0.20839e+01_r8,0.22069e+01_r8 /)
      kbo(:,29, 2) = (/ &
        & 0.18448e+01_r8,0.19150e+01_r8,0.20042e+01_r8,0.21126e+01_r8,0.22404e+01_r8 /)
      kbo(:,30, 2) = (/ &
        & 0.18606e+01_r8,0.19355e+01_r8,0.20295e+01_r8,0.21428e+01_r8,0.22754e+01_r8 /)
      kbo(:,31, 2) = (/ &
        & 0.18780e+01_r8,0.19577e+01_r8,0.20566e+01_r8,0.21749e+01_r8,0.23125e+01_r8 /)
      kbo(:,32, 2) = (/ &
        & 0.18969e+01_r8,0.19816e+01_r8,0.20855e+01_r8,0.22088e+01_r8,0.23514e+01_r8 /)
      kbo(:,33, 2) = (/ &
        & 0.19172e+01_r8,0.20069e+01_r8,0.21160e+01_r8,0.22443e+01_r8,0.23920e+01_r8 /)
      kbo(:,34, 2) = (/ &
        & 0.19359e+01_r8,0.20300e+01_r8,0.21434e+01_r8,0.22762e+01_r8,0.24282e+01_r8 /)
      kbo(:,35, 2) = (/ &
        & 0.19471e+01_r8,0.20437e+01_r8,0.21597e+01_r8,0.22949e+01_r8,0.24495e+01_r8 /)
      kbo(:,36, 2) = (/ &
        & 0.19490e+01_r8,0.20460e+01_r8,0.21624e+01_r8,0.22980e+01_r8,0.24530e+01_r8 /)
      kbo(:,37, 2) = (/ &
        & 0.19377e+01_r8,0.20322e+01_r8,0.21461e+01_r8,0.22792e+01_r8,0.24317e+01_r8 /)
      kbo(:,38, 2) = (/ &
        & 0.19261e+01_r8,0.20179e+01_r8,0.21291e+01_r8,0.22595e+01_r8,0.24093e+01_r8 /)
      kbo(:,39, 2) = (/ &
        & 0.19149e+01_r8,0.20040e+01_r8,0.21125e+01_r8,0.22402e+01_r8,0.23873e+01_r8 /)
      kbo(:,40, 2) = (/ &
        & 0.18963e+01_r8,0.19807e+01_r8,0.20845e+01_r8,0.22076e+01_r8,0.23501e+01_r8 /)
      kbo(:,41, 2) = (/ &
        & 0.18778e+01_r8,0.19574e+01_r8,0.20563e+01_r8,0.21745e+01_r8,0.23120e+01_r8 /)
      kbo(:,42, 2) = (/ &
        & 0.18604e+01_r8,0.19352e+01_r8,0.20292e+01_r8,0.21425e+01_r8,0.22750e+01_r8 /)
      kbo(:,43, 2) = (/ &
        & 0.18409e+01_r8,0.19099e+01_r8,0.19978e+01_r8,0.21050e+01_r8,0.22315e+01_r8 /)
      kbo(:,44, 2) = (/ &
        & 0.18217e+01_r8,0.18845e+01_r8,0.19660e+01_r8,0.20667e+01_r8,0.21867e+01_r8 /)
      kbo(:,45, 2) = (/ &
        & 0.18046e+01_r8,0.18613e+01_r8,0.19364e+01_r8,0.20306e+01_r8,0.21441e+01_r8 /)
      kbo(:,46, 2) = (/ &
        & 0.17886e+01_r8,0.18389e+01_r8,0.19072e+01_r8,0.19945e+01_r8,0.21011e+01_r8 /)
      kbo(:,47, 2) = (/ &
        & 0.17755e+01_r8,0.18165e+01_r8,0.18775e+01_r8,0.19571e+01_r8,0.20559e+01_r8 /)
      kbo(:,48, 2) = (/ &
        & 0.17644e+01_r8,0.17970e+01_r8,0.18508e+01_r8,0.19228e+01_r8,0.20139e+01_r8 /)
      kbo(:,49, 2) = (/ &
        & 0.17563e+01_r8,0.17816e+01_r8,0.18271e+01_r8,0.18916e+01_r8,0.19749e+01_r8 /)
      kbo(:,50, 2) = (/ &
        & 0.17517e+01_r8,0.17702e+01_r8,0.18074e+01_r8,0.18651e+01_r8,0.19413e+01_r8 /)
      kbo(:,51, 2) = (/ &
        & 0.17504e+01_r8,0.17611e+01_r8,0.17908e+01_r8,0.18420e+01_r8,0.19113e+01_r8 /)
      kbo(:,52, 2) = (/ &
        & 0.17523e+01_r8,0.17547e+01_r8,0.17783e+01_r8,0.18212e+01_r8,0.18839e+01_r8 /)
      kbo(:,53, 2) = (/ &
        & 0.17566e+01_r8,0.17510e+01_r8,0.17675e+01_r8,0.18028e+01_r8,0.18589e+01_r8 /)
      kbo(:,54, 2) = (/ &
        & 0.17623e+01_r8,0.17507e+01_r8,0.17598e+01_r8,0.17881e+01_r8,0.18381e+01_r8 /)
      kbo(:,55, 2) = (/ &
        & 0.17691e+01_r8,0.17524e+01_r8,0.17544e+01_r8,0.17777e+01_r8,0.18201e+01_r8 /)
      kbo(:,56, 2) = (/ &
        & 0.17776e+01_r8,0.17562e+01_r8,0.17512e+01_r8,0.17682e+01_r8,0.18040e+01_r8 /)
      kbo(:,57, 2) = (/ &
        & 0.17881e+01_r8,0.17616e+01_r8,0.17505e+01_r8,0.17606e+01_r8,0.17897e+01_r8 /)
      kbo(:,58, 2) = (/ &
        & 0.17996e+01_r8,0.17678e+01_r8,0.17520e+01_r8,0.17552e+01_r8,0.17794e+01_r8 /)
      kbo(:,59, 2) = (/ &
        & 0.18045e+01_r8,0.17707e+01_r8,0.17530e+01_r8,0.17536e+01_r8,0.17756e+01_r8 /)
      kbo(:,13, 3) = (/ &
        & 0.10945e+02_r8,0.11052e+02_r8,0.11222e+02_r8,0.11452e+02_r8,0.11744e+02_r8 /)
      kbo(:,14, 3) = (/ &
        & 0.10952e+02_r8,0.11065e+02_r8,0.11240e+02_r8,0.11476e+02_r8,0.11774e+02_r8 /)
      kbo(:,15, 3) = (/ &
        & 0.10961e+02_r8,0.11080e+02_r8,0.11261e+02_r8,0.11503e+02_r8,0.11807e+02_r8 /)
      kbo(:,16, 3) = (/ &
        & 0.10971e+02_r8,0.11097e+02_r8,0.11284e+02_r8,0.11533e+02_r8,0.11844e+02_r8 /)
      kbo(:,17, 3) = (/ &
        & 0.10981e+02_r8,0.11115e+02_r8,0.11307e+02_r8,0.11562e+02_r8,0.11879e+02_r8 /)
      kbo(:,18, 3) = (/ &
        & 0.10992e+02_r8,0.11132e+02_r8,0.11331e+02_r8,0.11592e+02_r8,0.11915e+02_r8 /)
      kbo(:,19, 3) = (/ &
        & 0.11003e+02_r8,0.11149e+02_r8,0.11354e+02_r8,0.11622e+02_r8,0.11951e+02_r8 /)
      kbo(:,20, 3) = (/ &
        & 0.11017e+02_r8,0.11170e+02_r8,0.11382e+02_r8,0.11657e+02_r8,0.11994e+02_r8 /)
      kbo(:,21, 3) = (/ &
        & 0.11031e+02_r8,0.11192e+02_r8,0.11412e+02_r8,0.11694e+02_r8,0.12038e+02_r8 /)
      kbo(:,22, 3) = (/ &
        & 0.11056e+02_r8,0.11228e+02_r8,0.11460e+02_r8,0.11754e+02_r8,0.12109e+02_r8 /)
      kbo(:,23, 3) = (/ &
        & 0.11085e+02_r8,0.11267e+02_r8,0.11511e+02_r8,0.11817e+02_r8,0.12184e+02_r8 /)
      kbo(:,24, 3) = (/ &
        & 0.11118e+02_r8,0.11312e+02_r8,0.11568e+02_r8,0.11886e+02_r8,0.12266e+02_r8 /)
      kbo(:,25, 3) = (/ &
        & 0.11154e+02_r8,0.11361e+02_r8,0.11630e+02_r8,0.11962e+02_r8,0.12354e+02_r8 /)
      kbo(:,26, 3) = (/ &
        & 0.11196e+02_r8,0.11418e+02_r8,0.11702e+02_r8,0.12048e+02_r8,0.12455e+02_r8 /)
      kbo(:,27, 3) = (/ &
        & 0.11243e+02_r8,0.11480e+02_r8,0.11778e+02_r8,0.12138e+02_r8,0.12560e+02_r8 /)
      kbo(:,28, 3) = (/ &
        & 0.11294e+02_r8,0.11545e+02_r8,0.11859e+02_r8,0.12234e+02_r8,0.12670e+02_r8 /)
      kbo(:,29, 3) = (/ &
        & 0.11351e+02_r8,0.11617e+02_r8,0.11946e+02_r8,0.12336e+02_r8,0.12788e+02_r8 /)
      kbo(:,30, 3) = (/ &
        & 0.11411e+02_r8,0.11694e+02_r8,0.12038e+02_r8,0.12443e+02_r8,0.12910e+02_r8 /)
      kbo(:,31, 3) = (/ &
        & 0.11478e+02_r8,0.11776e+02_r8,0.12136e+02_r8,0.12557e+02_r8,0.13040e+02_r8 /)
      kbo(:,32, 3) = (/ &
        & 0.11549e+02_r8,0.11864e+02_r8,0.12239e+02_r8,0.12677e+02_r8,0.13175e+02_r8 /)
      kbo(:,33, 3) = (/ &
        & 0.11626e+02_r8,0.11956e+02_r8,0.12348e+02_r8,0.12801e+02_r8,0.13316e+02_r8 /)
      kbo(:,34, 3) = (/ &
        & 0.11695e+02_r8,0.12040e+02_r8,0.12446e+02_r8,0.12913e+02_r8,0.13442e+02_r8 /)
      kbo(:,35, 3) = (/ &
        & 0.11737e+02_r8,0.12089e+02_r8,0.12503e+02_r8,0.12979e+02_r8,0.13515e+02_r8 /)
      kbo(:,36, 3) = (/ &
        & 0.11744e+02_r8,0.12098e+02_r8,0.12513e+02_r8,0.12989e+02_r8,0.13528e+02_r8 /)
      kbo(:,37, 3) = (/ &
        & 0.11702e+02_r8,0.12048e+02_r8,0.12455e+02_r8,0.12924e+02_r8,0.13454e+02_r8 /)
      kbo(:,38, 3) = (/ &
        & 0.11659e+02_r8,0.11996e+02_r8,0.12395e+02_r8,0.12855e+02_r8,0.13376e+02_r8 /)
      kbo(:,39, 3) = (/ &
        & 0.11617e+02_r8,0.11946e+02_r8,0.12336e+02_r8,0.12787e+02_r8,0.13300e+02_r8 /)
      kbo(:,40, 3) = (/ &
        & 0.11547e+02_r8,0.11861e+02_r8,0.12236e+02_r8,0.12673e+02_r8,0.13171e+02_r8 /)
      kbo(:,41, 3) = (/ &
        & 0.11477e+02_r8,0.11775e+02_r8,0.12134e+02_r8,0.12555e+02_r8,0.13038e+02_r8 /)
      kbo(:,42, 3) = (/ &
        & 0.11411e+02_r8,0.11693e+02_r8,0.12037e+02_r8,0.12442e+02_r8,0.12909e+02_r8 /)
      kbo(:,43, 3) = (/ &
        & 0.11335e+02_r8,0.11598e+02_r8,0.11923e+02_r8,0.12309e+02_r8,0.12757e+02_r8 /)
      kbo(:,44, 3) = (/ &
        & 0.11261e+02_r8,0.11503e+02_r8,0.11807e+02_r8,0.12172e+02_r8,0.12599e+02_r8 /)
      kbo(:,45, 3) = (/ &
        & 0.11193e+02_r8,0.11414e+02_r8,0.11697e+02_r8,0.12042e+02_r8,0.12448e+02_r8 /)
      kbo(:,46, 3) = (/ &
        & 0.11129e+02_r8,0.11328e+02_r8,0.11588e+02_r8,0.11911e+02_r8,0.12295e+02_r8 /)
      kbo(:,47, 3) = (/ &
        & 0.11065e+02_r8,0.11240e+02_r8,0.11476e+02_r8,0.11774e+02_r8,0.12133e+02_r8 /)
      kbo(:,48, 3) = (/ &
        & 0.11012e+02_r8,0.11163e+02_r8,0.11374e+02_r8,0.11647e+02_r8,0.11981e+02_r8 /)
      kbo(:,49, 3) = (/ &
        & 0.10969e+02_r8,0.11095e+02_r8,0.11282e+02_r8,0.11530e+02_r8,0.11839e+02_r8 /)
      kbo(:,50, 3) = (/ &
        & 0.10938e+02_r8,0.11040e+02_r8,0.11204e+02_r8,0.11429e+02_r8,0.11715e+02_r8 /)
      kbo(:,51, 3) = (/ &
        & 0.10916e+02_r8,0.10996e+02_r8,0.11138e+02_r8,0.11340e+02_r8,0.11604e+02_r8 /)
      kbo(:,52, 3) = (/ &
        & 0.10900e+02_r8,0.10960e+02_r8,0.11079e+02_r8,0.11259e+02_r8,0.11500e+02_r8 /)
      kbo(:,53, 3) = (/ &
        & 0.10894e+02_r8,0.10932e+02_r8,0.11028e+02_r8,0.11186e+02_r8,0.11405e+02_r8 /)
      kbo(:,54, 3) = (/ &
        & 0.10895e+02_r8,0.10912e+02_r8,0.10989e+02_r8,0.11127e+02_r8,0.11325e+02_r8 /)
      kbo(:,55, 3) = (/ &
        & 0.10903e+02_r8,0.10900e+02_r8,0.10958e+02_r8,0.11075e+02_r8,0.11255e+02_r8 /)
      kbo(:,56, 3) = (/ &
        & 0.10921e+02_r8,0.10894e+02_r8,0.10933e+02_r8,0.11031e+02_r8,0.11191e+02_r8 /)
      kbo(:,57, 3) = (/ &
        & 0.10944e+02_r8,0.10894e+02_r8,0.10914e+02_r8,0.10993e+02_r8,0.11134e+02_r8 /)
      kbo(:,58, 3) = (/ &
        & 0.10972e+02_r8,0.10901e+02_r8,0.10902e+02_r8,0.10963e+02_r8,0.11084e+02_r8 /)
      kbo(:,59, 3) = (/ &
        & 0.10984e+02_r8,0.10906e+02_r8,0.10898e+02_r8,0.10952e+02_r8,0.11066e+02_r8 /)
      kbo(:,13, 4) = (/ &
        & 0.51563e+02_r8,0.51946e+02_r8,0.52464e+02_r8,0.53116e+02_r8,0.53902e+02_r8 /)
      kbo(:,14, 4) = (/ &
        & 0.51593e+02_r8,0.51987e+02_r8,0.52517e+02_r8,0.53182e+02_r8,0.53980e+02_r8 /)
      kbo(:,15, 4) = (/ &
        & 0.51626e+02_r8,0.52035e+02_r8,0.52579e+02_r8,0.53256e+02_r8,0.54069e+02_r8 /)
      kbo(:,16, 4) = (/ &
        & 0.51664e+02_r8,0.52087e+02_r8,0.52644e+02_r8,0.53337e+02_r8,0.54163e+02_r8 /)
      kbo(:,17, 4) = (/ &
        & 0.51701e+02_r8,0.52138e+02_r8,0.52710e+02_r8,0.53416e+02_r8,0.54257e+02_r8 /)
      kbo(:,18, 4) = (/ &
        & 0.51740e+02_r8,0.52191e+02_r8,0.52776e+02_r8,0.53496e+02_r8,0.54351e+02_r8 /)
      kbo(:,19, 4) = (/ &
        & 0.51779e+02_r8,0.52244e+02_r8,0.52843e+02_r8,0.53576e+02_r8,0.54444e+02_r8 /)
      kbo(:,20, 4) = (/ &
        & 0.51827e+02_r8,0.52307e+02_r8,0.52922e+02_r8,0.53671e+02_r8,0.54555e+02_r8 /)
      kbo(:,21, 4) = (/ &
        & 0.51877e+02_r8,0.52373e+02_r8,0.53004e+02_r8,0.53770e+02_r8,0.54669e+02_r8 /)
      kbo(:,22, 4) = (/ &
        & 0.51959e+02_r8,0.52481e+02_r8,0.53136e+02_r8,0.53927e+02_r8,0.54851e+02_r8 /)
      kbo(:,23, 4) = (/ &
        & 0.52049e+02_r8,0.52596e+02_r8,0.53278e+02_r8,0.54094e+02_r8,0.55044e+02_r8 /)
      kbo(:,24, 4) = (/ &
        & 0.52148e+02_r8,0.52723e+02_r8,0.53431e+02_r8,0.54274e+02_r8,0.55252e+02_r8 /)
      kbo(:,25, 4) = (/ &
        & 0.52259e+02_r8,0.52862e+02_r8,0.53599e+02_r8,0.54471e+02_r8,0.55477e+02_r8 /)
      kbo(:,26, 4) = (/ &
        & 0.52387e+02_r8,0.53022e+02_r8,0.53790e+02_r8,0.54693e+02_r8,0.55730e+02_r8 /)
      kbo(:,27, 4) = (/ &
        & 0.52525e+02_r8,0.53191e+02_r8,0.53992e+02_r8,0.54926e+02_r8,0.55995e+02_r8 /)
      kbo(:,28, 4) = (/ &
        & 0.52672e+02_r8,0.53371e+02_r8,0.54203e+02_r8,0.55170e+02_r8,0.56271e+02_r8 /)
      kbo(:,29, 4) = (/ &
        & 0.52833e+02_r8,0.53565e+02_r8,0.54430e+02_r8,0.55430e+02_r8,0.56565e+02_r8 /)
      kbo(:,30, 4) = (/ &
        & 0.53003e+02_r8,0.53768e+02_r8,0.54668e+02_r8,0.55702e+02_r8,0.56870e+02_r8 /)
      kbo(:,31, 4) = (/ &
        & 0.53186e+02_r8,0.53986e+02_r8,0.54920e+02_r8,0.55988e+02_r8,0.57190e+02_r8 /)
      kbo(:,32, 4) = (/ &
        & 0.53381e+02_r8,0.54216e+02_r8,0.55184e+02_r8,0.56287e+02_r8,0.57525e+02_r8 /)
      kbo(:,33, 4) = (/ &
        & 0.53587e+02_r8,0.54457e+02_r8,0.55460e+02_r8,0.56599e+02_r8,0.57871e+02_r8 /)
      kbo(:,34, 4) = (/ &
        & 0.53773e+02_r8,0.54673e+02_r8,0.55707e+02_r8,0.56876e+02_r8,0.58179e+02_r8 /)
      kbo(:,35, 4) = (/ &
        & 0.53883e+02_r8,0.54800e+02_r8,0.55852e+02_r8,0.57039e+02_r8,0.58359e+02_r8 /)
      kbo(:,36, 4) = (/ &
        & 0.53901e+02_r8,0.54822e+02_r8,0.55876e+02_r8,0.57066e+02_r8,0.58389e+02_r8 /)
      kbo(:,37, 4) = (/ &
        & 0.53791e+02_r8,0.54694e+02_r8,0.55731e+02_r8,0.56903e+02_r8,0.58208e+02_r8 /)
      kbo(:,38, 4) = (/ &
        & 0.53676e+02_r8,0.54560e+02_r8,0.55578e+02_r8,0.56731e+02_r8,0.58018e+02_r8 /)
      kbo(:,39, 4) = (/ &
        & 0.53563e+02_r8,0.54429e+02_r8,0.55429e+02_r8,0.56563e+02_r8,0.57832e+02_r8 /)
      kbo(:,40, 4) = (/ &
        & 0.53375e+02_r8,0.54208e+02_r8,0.55175e+02_r8,0.56277e+02_r8,0.57513e+02_r8 /)
      kbo(:,41, 4) = (/ &
        & 0.53184e+02_r8,0.53983e+02_r8,0.54916e+02_r8,0.55984e+02_r8,0.57186e+02_r8 /)
      kbo(:,42, 4) = (/ &
        & 0.53001e+02_r8,0.53766e+02_r8,0.54665e+02_r8,0.55699e+02_r8,0.56866e+02_r8 /)
      kbo(:,43, 4) = (/ &
        & 0.52790e+02_r8,0.53513e+02_r8,0.54370e+02_r8,0.55362e+02_r8,0.56488e+02_r8 /)
      kbo(:,44, 4) = (/ &
        & 0.52577e+02_r8,0.53254e+02_r8,0.54066e+02_r8,0.55012e+02_r8,0.56093e+02_r8 /)
      kbo(:,45, 4) = (/ &
        & 0.52379e+02_r8,0.53011e+02_r8,0.53777e+02_r8,0.54678e+02_r8,0.55713e+02_r8 /)
      kbo(:,46, 4) = (/ &
        & 0.52184e+02_r8,0.52768e+02_r8,0.53486e+02_r8,0.54339e+02_r8,0.55326e+02_r8 /)
      kbo(:,47, 4) = (/ &
        & 0.51987e+02_r8,0.52517e+02_r8,0.53182e+02_r8,0.53980e+02_r8,0.54913e+02_r8 /)
      kbo(:,48, 4) = (/ &
        & 0.51812e+02_r8,0.52288e+02_r8,0.52898e+02_r8,0.53643e+02_r8,0.54522e+02_r8 /)
      kbo(:,49, 4) = (/ &
        & 0.51659e+02_r8,0.52081e+02_r8,0.52637e+02_r8,0.53327e+02_r8,0.54152e+02_r8 /)
      kbo(:,50, 4) = (/ &
        & 0.51535e+02_r8,0.51906e+02_r8,0.52412e+02_r8,0.53052e+02_r8,0.53826e+02_r8 /)
      kbo(:,51, 4) = (/ &
        & 0.51433e+02_r8,0.51755e+02_r8,0.52211e+02_r8,0.52802e+02_r8,0.53527e+02_r8 /)
      kbo(:,52, 4) = (/ &
        & 0.51349e+02_r8,0.51622e+02_r8,0.52029e+02_r8,0.52571e+02_r8,0.53247e+02_r8 /)
      kbo(:,53, 4) = (/ &
        & 0.51285e+02_r8,0.51507e+02_r8,0.51865e+02_r8,0.52358e+02_r8,0.52985e+02_r8 /)
      kbo(:,54, 4) = (/ &
        & 0.51240e+02_r8,0.51417e+02_r8,0.51730e+02_r8,0.52178e+02_r8,0.52760e+02_r8 /)
      kbo(:,55, 4) = (/ &
        & 0.51211e+02_r8,0.51346e+02_r8,0.51615e+02_r8,0.52020e+02_r8,0.52559e+02_r8 /)
      kbo(:,56, 4) = (/ &
        & 0.51194e+02_r8,0.51288e+02_r8,0.51514e+02_r8,0.51875e+02_r8,0.52371e+02_r8 /)
      kbo(:,57, 4) = (/ &
        & 0.51190e+02_r8,0.51245e+02_r8,0.51426e+02_r8,0.51746e+02_r8,0.52198e+02_r8 /)
      kbo(:,58, 4) = (/ &
        & 0.51200e+02_r8,0.51216e+02_r8,0.51357e+02_r8,0.51635e+02_r8,0.52046e+02_r8 /)
      kbo(:,59, 4) = (/ &
        & 0.51207e+02_r8,0.51207e+02_r8,0.51333e+02_r8,0.51594e+02_r8,0.51989e+02_r8 /)
      kbo(:,13, 5) = (/ &
        & 0.17051e+03_r8,0.17168e+03_r8,0.17297e+03_r8,0.17437e+03_r8,0.17590e+03_r8 /)
      kbo(:,14, 5) = (/ &
        & 0.17061e+03_r8,0.17179e+03_r8,0.17309e+03_r8,0.17451e+03_r8,0.17604e+03_r8 /)
      kbo(:,15, 5) = (/ &
        & 0.17073e+03_r8,0.17192e+03_r8,0.17323e+03_r8,0.17466e+03_r8,0.17621e+03_r8 /)
      kbo(:,16, 5) = (/ &
        & 0.17085e+03_r8,0.17205e+03_r8,0.17338e+03_r8,0.17482e+03_r8,0.17638e+03_r8 /)
      kbo(:,17, 5) = (/ &
        & 0.17097e+03_r8,0.17218e+03_r8,0.17352e+03_r8,0.17497e+03_r8,0.17655e+03_r8 /)
      kbo(:,18, 5) = (/ &
        & 0.17109e+03_r8,0.17232e+03_r8,0.17366e+03_r8,0.17513e+03_r8,0.17671e+03_r8 /)
      kbo(:,19, 5) = (/ &
        & 0.17121e+03_r8,0.17245e+03_r8,0.17381e+03_r8,0.17528e+03_r8,0.17688e+03_r8 /)
      kbo(:,20, 5) = (/ &
        & 0.17134e+03_r8,0.17260e+03_r8,0.17397e+03_r8,0.17547e+03_r8,0.17708e+03_r8 /)
      kbo(:,21, 5) = (/ &
        & 0.17149e+03_r8,0.17276e+03_r8,0.17415e+03_r8,0.17565e+03_r8,0.17728e+03_r8 /)
      kbo(:,22, 5) = (/ &
        & 0.17172e+03_r8,0.17301e+03_r8,0.17442e+03_r8,0.17594e+03_r8,0.17759e+03_r8 /)
      kbo(:,23, 5) = (/ &
        & 0.17195e+03_r8,0.17327e+03_r8,0.17470e+03_r8,0.17625e+03_r8,0.17792e+03_r8 /)
      kbo(:,24, 5) = (/ &
        & 0.17221e+03_r8,0.17355e+03_r8,0.17500e+03_r8,0.17658e+03_r8,0.17827e+03_r8 /)
      kbo(:,25, 5) = (/ &
        & 0.17248e+03_r8,0.17385e+03_r8,0.17533e+03_r8,0.17693e+03_r8,0.17865e+03_r8 /)
      kbo(:,26, 5) = (/ &
        & 0.17279e+03_r8,0.17418e+03_r8,0.17569e+03_r8,0.17732e+03_r8,0.17906e+03_r8 /)
      kbo(:,27, 5) = (/ &
        & 0.17311e+03_r8,0.17453e+03_r8,0.17606e+03_r8,0.17772e+03_r8,0.17949e+03_r8 /)
      kbo(:,28, 5) = (/ &
        & 0.17344e+03_r8,0.17488e+03_r8,0.17645e+03_r8,0.17813e+03_r8,0.17994e+03_r8 /)
      kbo(:,29, 5) = (/ &
        & 0.17379e+03_r8,0.17526e+03_r8,0.17686e+03_r8,0.17857e+03_r8,0.18040e+03_r8 /)
      kbo(:,30, 5) = (/ &
        & 0.17414e+03_r8,0.17565e+03_r8,0.17727e+03_r8,0.17902e+03_r8,0.18088e+03_r8 /)
      kbo(:,31, 5) = (/ &
        & 0.17452e+03_r8,0.17605e+03_r8,0.17771e+03_r8,0.17948e+03_r8,0.18137e+03_r8 /)
      kbo(:,32, 5) = (/ &
        & 0.17491e+03_r8,0.17647e+03_r8,0.17816e+03_r8,0.17996e+03_r8,0.18188e+03_r8 /)
      kbo(:,33, 5) = (/ &
        & 0.17531e+03_r8,0.17690e+03_r8,0.17862e+03_r8,0.18045e+03_r8,0.18241e+03_r8 /)
      kbo(:,34, 5) = (/ &
        & 0.17566e+03_r8,0.17728e+03_r8,0.17903e+03_r8,0.18089e+03_r8,0.18287e+03_r8 /)
      kbo(:,35, 5) = (/ &
        & 0.17586e+03_r8,0.17750e+03_r8,0.17926e+03_r8,0.18114e+03_r8,0.18313e+03_r8 /)
      kbo(:,36, 5) = (/ &
        & 0.17590e+03_r8,0.17754e+03_r8,0.17930e+03_r8,0.18118e+03_r8,0.18318e+03_r8 /)
      kbo(:,37, 5) = (/ &
        & 0.17569e+03_r8,0.17732e+03_r8,0.17906e+03_r8,0.18093e+03_r8,0.18291e+03_r8 /)
      kbo(:,38, 5) = (/ &
        & 0.17547e+03_r8,0.17708e+03_r8,0.17881e+03_r8,0.18066e+03_r8,0.18263e+03_r8 /)
      kbo(:,39, 5) = (/ &
        & 0.17526e+03_r8,0.17685e+03_r8,0.17857e+03_r8,0.18040e+03_r8,0.18235e+03_r8 /)
      kbo(:,40, 5) = (/ &
        & 0.17489e+03_r8,0.17646e+03_r8,0.17814e+03_r8,0.17995e+03_r8,0.18187e+03_r8 /)
      kbo(:,41, 5) = (/ &
        & 0.17451e+03_r8,0.17605e+03_r8,0.17770e+03_r8,0.17948e+03_r8,0.18137e+03_r8 /)
      kbo(:,42, 5) = (/ &
        & 0.17414e+03_r8,0.17565e+03_r8,0.17727e+03_r8,0.17901e+03_r8,0.18087e+03_r8 /)
      kbo(:,43, 5) = (/ &
        & 0.17369e+03_r8,0.17516e+03_r8,0.17675e+03_r8,0.17846e+03_r8,0.18028e+03_r8 /)
      kbo(:,44, 5) = (/ &
        & 0.17323e+03_r8,0.17465e+03_r8,0.17620e+03_r8,0.17787e+03_r8,0.17965e+03_r8 /)
      kbo(:,45, 5) = (/ &
        & 0.17277e+03_r8,0.17416e+03_r8,0.17567e+03_r8,0.17729e+03_r8,0.17904e+03_r8 /)
      kbo(:,46, 5) = (/ &
        & 0.17230e+03_r8,0.17365e+03_r8,0.17511e+03_r8,0.17669e+03_r8,0.17840e+03_r8 /)
      kbo(:,47, 5) = (/ &
        & 0.17179e+03_r8,0.17309e+03_r8,0.17451e+03_r8,0.17604e+03_r8,0.17770e+03_r8 /)
      kbo(:,48, 5) = (/ &
        & 0.17130e+03_r8,0.17255e+03_r8,0.17392e+03_r8,0.17541e+03_r8,0.17702e+03_r8 /)
      kbo(:,49, 5) = (/ &
        & 0.17083e+03_r8,0.17204e+03_r8,0.17336e+03_r8,0.17480e+03_r8,0.17636e+03_r8 /)
      kbo(:,50, 5) = (/ &
        & 0.17041e+03_r8,0.17157e+03_r8,0.17285e+03_r8,0.17424e+03_r8,0.17576e+03_r8 /)
      kbo(:,51, 5) = (/ &
        & 0.17002e+03_r8,0.17113e+03_r8,0.17237e+03_r8,0.17372e+03_r8,0.17519e+03_r8 /)
      kbo(:,52, 5) = (/ &
        & 0.16964e+03_r8,0.17071e+03_r8,0.17190e+03_r8,0.17321e+03_r8,0.17464e+03_r8 /)
      kbo(:,53, 5) = (/ &
        & 0.16927e+03_r8,0.17031e+03_r8,0.17145e+03_r8,0.17272e+03_r8,0.17411e+03_r8 /)
      kbo(:,54, 5) = (/ &
        & 0.16896e+03_r8,0.16995e+03_r8,0.17106e+03_r8,0.17228e+03_r8,0.17363e+03_r8 /)
      kbo(:,55, 5) = (/ &
        & 0.16866e+03_r8,0.16962e+03_r8,0.17069e+03_r8,0.17188e+03_r8,0.17318e+03_r8 /)
      kbo(:,56, 5) = (/ &
        & 0.16839e+03_r8,0.16930e+03_r8,0.17033e+03_r8,0.17148e+03_r8,0.17275e+03_r8 /)
      kbo(:,57, 5) = (/ &
        & 0.16812e+03_r8,0.16899e+03_r8,0.16999e+03_r8,0.17110e+03_r8,0.17233e+03_r8 /)
      kbo(:,58, 5) = (/ &
        & 0.16788e+03_r8,0.16871e+03_r8,0.16968e+03_r8,0.17075e+03_r8,0.17195e+03_r8 /)
      kbo(:,59, 5) = (/ &
        & 0.16779e+03_r8,0.16861e+03_r8,0.16955e+03_r8,0.17062e+03_r8,0.17180e+03_r8 /)
      kbo(:,13, 6) = (/ &
        & 0.38122e+03_r8,0.38406e+03_r8,0.38668e+03_r8,0.38908e+03_r8,0.39125e+03_r8 /)
      kbo(:,14, 6) = (/ &
        & 0.38148e+03_r8,0.38431e+03_r8,0.38691e+03_r8,0.38929e+03_r8,0.39144e+03_r8 /)
      kbo(:,15, 6) = (/ &
        & 0.38178e+03_r8,0.38458e+03_r8,0.38716e+03_r8,0.38951e+03_r8,0.39164e+03_r8 /)
      kbo(:,16, 6) = (/ &
        & 0.38209e+03_r8,0.38487e+03_r8,0.38742e+03_r8,0.38975e+03_r8,0.39186e+03_r8 /)
      kbo(:,17, 6) = (/ &
        & 0.38239e+03_r8,0.38514e+03_r8,0.38767e+03_r8,0.38998e+03_r8,0.39206e+03_r8 /)
      kbo(:,18, 6) = (/ &
        & 0.38268e+03_r8,0.38541e+03_r8,0.38792e+03_r8,0.39020e+03_r8,0.39226e+03_r8 /)
      kbo(:,19, 6) = (/ &
        & 0.38297e+03_r8,0.38568e+03_r8,0.38816e+03_r8,0.39042e+03_r8,0.39246e+03_r8 /)
      kbo(:,20, 6) = (/ &
        & 0.38330e+03_r8,0.38598e+03_r8,0.38844e+03_r8,0.39067e+03_r8,0.39268e+03_r8 /)
      kbo(:,21, 6) = (/ &
        & 0.38363e+03_r8,0.38629e+03_r8,0.38872e+03_r8,0.39092e+03_r8,0.39291e+03_r8 /)
      kbo(:,22, 6) = (/ &
        & 0.38414e+03_r8,0.38675e+03_r8,0.38914e+03_r8,0.39131e+03_r8,0.39325e+03_r8 /)
      kbo(:,23, 6) = (/ &
        & 0.38466e+03_r8,0.38723e+03_r8,0.38958e+03_r8,0.39170e+03_r8,0.39360e+03_r8 /)
      kbo(:,24, 6) = (/ &
        & 0.38520e+03_r8,0.38772e+03_r8,0.39002e+03_r8,0.39210e+03_r8,0.39395e+03_r8 /)
      kbo(:,25, 6) = (/ &
        & 0.38575e+03_r8,0.38823e+03_r8,0.39048e+03_r8,0.39251e+03_r8,0.39432e+03_r8 /)
      kbo(:,26, 6) = (/ &
        & 0.38635e+03_r8,0.38877e+03_r8,0.39098e+03_r8,0.39295e+03_r8,0.39470e+03_r8 /)
      kbo(:,27, 6) = (/ &
        & 0.38694e+03_r8,0.38932e+03_r8,0.39146e+03_r8,0.39339e+03_r8,0.39509e+03_r8 /)
      kbo(:,28, 6) = (/ &
        & 0.38753e+03_r8,0.38985e+03_r8,0.39194e+03_r8,0.39381e+03_r8,0.39546e+03_r8 /)
      kbo(:,29, 6) = (/ &
        & 0.38813e+03_r8,0.39039e+03_r8,0.39243e+03_r8,0.39424e+03_r8,0.39583e+03_r8 /)
      kbo(:,30, 6) = (/ &
        & 0.38871e+03_r8,0.39092e+03_r8,0.39290e+03_r8,0.39466e+03_r8,0.39620e+03_r8 /)
      kbo(:,31, 6) = (/ &
        & 0.38930e+03_r8,0.39145e+03_r8,0.39338e+03_r8,0.39508e+03_r8,0.39655e+03_r8 /)
      kbo(:,32, 6) = (/ &
        & 0.38988e+03_r8,0.39197e+03_r8,0.39384e+03_r8,0.39548e+03_r8,0.39690e+03_r8 /)
      kbo(:,33, 6) = (/ &
        & 0.39045e+03_r8,0.39248e+03_r8,0.39429e+03_r8,0.39587e+03_r8,0.39723e+03_r8 /)
      kbo(:,34, 6) = (/ &
        & 0.39093e+03_r8,0.39291e+03_r8,0.39467e+03_r8,0.39620e+03_r8,0.39751e+03_r8 /)
      kbo(:,35, 6) = (/ &
        & 0.39120e+03_r8,0.39316e+03_r8,0.39488e+03_r8,0.39639e+03_r8,0.39766e+03_r8 /)
      kbo(:,36, 6) = (/ &
        & 0.39125e+03_r8,0.39320e+03_r8,0.39492e+03_r8,0.39642e+03_r8,0.39769e+03_r8 /)
      kbo(:,37, 6) = (/ &
        & 0.39098e+03_r8,0.39295e+03_r8,0.39471e+03_r8,0.39623e+03_r8,0.39754e+03_r8 /)
      kbo(:,38, 6) = (/ &
        & 0.39068e+03_r8,0.39269e+03_r8,0.39447e+03_r8,0.39603e+03_r8,0.39737e+03_r8 /)
      kbo(:,39, 6) = (/ &
        & 0.39039e+03_r8,0.39243e+03_r8,0.39424e+03_r8,0.39583e+03_r8,0.39720e+03_r8 /)
      kbo(:,40, 6) = (/ &
        & 0.38986e+03_r8,0.39196e+03_r8,0.39382e+03_r8,0.39547e+03_r8,0.39689e+03_r8 /)
      kbo(:,41, 6) = (/ &
        & 0.38929e+03_r8,0.39144e+03_r8,0.39337e+03_r8,0.39507e+03_r8,0.39655e+03_r8 /)
      kbo(:,42, 6) = (/ &
        & 0.38871e+03_r8,0.39092e+03_r8,0.39290e+03_r8,0.39466e+03_r8,0.39619e+03_r8 /)
      kbo(:,43, 6) = (/ &
        & 0.38797e+03_r8,0.39025e+03_r8,0.39230e+03_r8,0.39413e+03_r8,0.39574e+03_r8 /)
      kbo(:,44, 6) = (/ &
        & 0.38715e+03_r8,0.38951e+03_r8,0.39164e+03_r8,0.39354e+03_r8,0.39522e+03_r8 /)
      kbo(:,45, 6) = (/ &
        & 0.38631e+03_r8,0.38874e+03_r8,0.39094e+03_r8,0.39292e+03_r8,0.39468e+03_r8 /)
      kbo(:,46, 6) = (/ &
        & 0.38538e+03_r8,0.38789e+03_r8,0.39018e+03_r8,0.39224e+03_r8,0.39407e+03_r8 /)
      kbo(:,47, 6) = (/ &
        & 0.38431e+03_r8,0.38691e+03_r8,0.38929e+03_r8,0.39144e+03_r8,0.39336e+03_r8 /)
      kbo(:,48, 6) = (/ &
        & 0.38320e+03_r8,0.38589e+03_r8,0.38836e+03_r8,0.39060e+03_r8,0.39262e+03_r8 /)
      kbo(:,49, 6) = (/ &
        & 0.38206e+03_r8,0.38484e+03_r8,0.38739e+03_r8,0.38972e+03_r8,0.39183e+03_r8 /)
      kbo(:,50, 6) = (/ &
        & 0.38095e+03_r8,0.38382e+03_r8,0.38646e+03_r8,0.38887e+03_r8,0.39106e+03_r8 /)
      kbo(:,51, 6) = (/ &
        & 0.37985e+03_r8,0.38279e+03_r8,0.38552e+03_r8,0.38802e+03_r8,0.39029e+03_r8 /)
      kbo(:,52, 6) = (/ &
        & 0.37873e+03_r8,0.38175e+03_r8,0.38455e+03_r8,0.38713e+03_r8,0.38949e+03_r8 /)
      kbo(:,53, 6) = (/ &
        & 0.37762e+03_r8,0.38067e+03_r8,0.38355e+03_r8,0.38621e+03_r8,0.38865e+03_r8 /)
      kbo(:,54, 6) = (/ &
        & 0.37661e+03_r8,0.37965e+03_r8,0.38261e+03_r8,0.38535e+03_r8,0.38786e+03_r8 /)
      kbo(:,55, 6) = (/ &
        & 0.37559e+03_r8,0.37867e+03_r8,0.38169e+03_r8,0.38450e+03_r8,0.38708e+03_r8 /)
      kbo(:,56, 6) = (/ &
        & 0.37459e+03_r8,0.37768e+03_r8,0.38074e+03_r8,0.38362e+03_r8,0.38628e+03_r8 /)
      kbo(:,57, 6) = (/ &
        & 0.37353e+03_r8,0.37673e+03_r8,0.37977e+03_r8,0.38272e+03_r8,0.38545e+03_r8 /)
      kbo(:,58, 6) = (/ &
        & 0.37251e+03_r8,0.37577e+03_r8,0.37885e+03_r8,0.38185e+03_r8,0.38465e+03_r8 /)
      kbo(:,59, 6) = (/ &
        & 0.37212e+03_r8,0.37539e+03_r8,0.37847e+03_r8,0.38150e+03_r8,0.38432e+03_r8 /)
      kbo(:,13, 7) = (/ &
        & 0.62583e+03_r8,0.62623e+03_r8,0.62691e+03_r8,0.62787e+03_r8,0.62909e+03_r8 /)
      kbo(:,14, 7) = (/ &
        & 0.62586e+03_r8,0.62628e+03_r8,0.62699e+03_r8,0.62797e+03_r8,0.62921e+03_r8 /)
      kbo(:,15, 7) = (/ &
        & 0.62589e+03_r8,0.62634e+03_r8,0.62708e+03_r8,0.62809e+03_r8,0.62935e+03_r8 /)
      kbo(:,16, 7) = (/ &
        & 0.62593e+03_r8,0.62640e+03_r8,0.62717e+03_r8,0.62821e+03_r8,0.62950e+03_r8 /)
      kbo(:,17, 7) = (/ &
        & 0.62597e+03_r8,0.62647e+03_r8,0.62727e+03_r8,0.62833e+03_r8,0.62965e+03_r8 /)
      kbo(:,18, 7) = (/ &
        & 0.62601e+03_r8,0.62654e+03_r8,0.62737e+03_r8,0.62846e+03_r8,0.62980e+03_r8 /)
      kbo(:,19, 7) = (/ &
        & 0.62605e+03_r8,0.62661e+03_r8,0.62746e+03_r8,0.62858e+03_r8,0.62995e+03_r8 /)
      kbo(:,20, 7) = (/ &
        & 0.62610e+03_r8,0.62670e+03_r8,0.62758e+03_r8,0.62873e+03_r8,0.63012e+03_r8 /)
      kbo(:,21, 7) = (/ &
        & 0.62615e+03_r8,0.62679e+03_r8,0.62770e+03_r8,0.62888e+03_r8,0.63031e+03_r8 /)
      kbo(:,22, 7) = (/ &
        & 0.62625e+03_r8,0.62694e+03_r8,0.62790e+03_r8,0.62913e+03_r8,0.63060e+03_r8 /)
      kbo(:,23, 7) = (/ &
        & 0.62636e+03_r8,0.62710e+03_r8,0.62812e+03_r8,0.62939e+03_r8,0.63091e+03_r8 /)
      kbo(:,24, 7) = (/ &
        & 0.62648e+03_r8,0.62729e+03_r8,0.62835e+03_r8,0.62968e+03_r8,0.63125e+03_r8 /)
      kbo(:,25, 7) = (/ &
        & 0.62663e+03_r8,0.62749e+03_r8,0.62861e+03_r8,0.62999e+03_r8,0.63162e+03_r8 /)
      kbo(:,26, 7) = (/ &
        & 0.62681e+03_r8,0.62773e+03_r8,0.62891e+03_r8,0.63035e+03_r8,0.63203e+03_r8 /)
      kbo(:,27, 7) = (/ &
        & 0.62700e+03_r8,0.62799e+03_r8,0.62923e+03_r8,0.63072e+03_r8,0.63247e+03_r8 /)
      kbo(:,28, 7) = (/ &
        & 0.62721e+03_r8,0.62826e+03_r8,0.62956e+03_r8,0.63112e+03_r8,0.63292e+03_r8 /)
      kbo(:,29, 7) = (/ &
        & 0.62745e+03_r8,0.62856e+03_r8,0.62993e+03_r8,0.63154e+03_r8,0.63341e+03_r8 /)
      kbo(:,30, 7) = (/ &
        & 0.62770e+03_r8,0.62888e+03_r8,0.63031e+03_r8,0.63198e+03_r8,0.63392e+03_r8 /)
      kbo(:,31, 7) = (/ &
        & 0.62798e+03_r8,0.62922e+03_r8,0.63071e+03_r8,0.63245e+03_r8,0.63446e+03_r8 /)
      kbo(:,32, 7) = (/ &
        & 0.62828e+03_r8,0.62958e+03_r8,0.63114e+03_r8,0.63295e+03_r8,0.63503e+03_r8 /)
      kbo(:,33, 7) = (/ &
        & 0.62860e+03_r8,0.62997e+03_r8,0.63159e+03_r8,0.63347e+03_r8,0.63562e+03_r8 /)
      kbo(:,34, 7) = (/ &
        & 0.62889e+03_r8,0.63031e+03_r8,0.63199e+03_r8,0.63393e+03_r8,0.63614e+03_r8 /)
      kbo(:,35, 7) = (/ &
        & 0.62906e+03_r8,0.63052e+03_r8,0.63223e+03_r8,0.63421e+03_r8,0.63644e+03_r8 /)
      kbo(:,36, 7) = (/ &
        & 0.62909e+03_r8,0.63055e+03_r8,0.63227e+03_r8,0.63425e+03_r8,0.63649e+03_r8 /)
      kbo(:,37, 7) = (/ &
        & 0.62891e+03_r8,0.63035e+03_r8,0.63203e+03_r8,0.63397e+03_r8,0.63619e+03_r8 /)
      kbo(:,38, 7) = (/ &
        & 0.62873e+03_r8,0.63013e+03_r8,0.63178e+03_r8,0.63369e+03_r8,0.63586e+03_r8 /)
      kbo(:,39, 7) = (/ &
        & 0.62856e+03_r8,0.62992e+03_r8,0.63154e+03_r8,0.63341e+03_r8,0.63555e+03_r8 /)
      kbo(:,40, 7) = (/ &
        & 0.62827e+03_r8,0.62957e+03_r8,0.63113e+03_r8,0.63293e+03_r8,0.63501e+03_r8 /)
      kbo(:,41, 7) = (/ &
        & 0.62798e+03_r8,0.62922e+03_r8,0.63071e+03_r8,0.63245e+03_r8,0.63445e+03_r8 /)
      kbo(:,42, 7) = (/ &
        & 0.62770e+03_r8,0.62887e+03_r8,0.63030e+03_r8,0.63198e+03_r8,0.63391e+03_r8 /)
      kbo(:,43, 7) = (/ &
        & 0.62739e+03_r8,0.62848e+03_r8,0.62983e+03_r8,0.63143e+03_r8,0.63328e+03_r8 /)
      kbo(:,44, 7) = (/ &
        & 0.62708e+03_r8,0.62808e+03_r8,0.62935e+03_r8,0.63086e+03_r8,0.63263e+03_r8 /)
      kbo(:,45, 7) = (/ &
        & 0.62679e+03_r8,0.62771e+03_r8,0.62889e+03_r8,0.63032e+03_r8,0.63200e+03_r8 /)
      kbo(:,46, 7) = (/ &
        & 0.62653e+03_r8,0.62735e+03_r8,0.62844e+03_r8,0.62978e+03_r8,0.63137e+03_r8 /)
      kbo(:,47, 7) = (/ &
        & 0.62629e+03_r8,0.62699e+03_r8,0.62797e+03_r8,0.62921e+03_r8,0.63070e+03_r8 /)
      kbo(:,48, 7) = (/ &
        & 0.62608e+03_r8,0.62667e+03_r8,0.62755e+03_r8,0.62868e+03_r8,0.63007e+03_r8 /)
      kbo(:,49, 7) = (/ &
        & 0.62592e+03_r8,0.62640e+03_r8,0.62716e+03_r8,0.62820e+03_r8,0.62948e+03_r8 /)
      kbo(:,50, 7) = (/ &
        & 0.62580e+03_r8,0.62619e+03_r8,0.62684e+03_r8,0.62778e+03_r8,0.62897e+03_r8 /)
      kbo(:,51, 7) = (/ &
        & 0.62580e+03_r8,0.62602e+03_r8,0.62657e+03_r8,0.62741e+03_r8,0.62850e+03_r8 /)
      kbo(:,52, 7) = (/ &
        & 0.62578e+03_r8,0.62589e+03_r8,0.62633e+03_r8,0.62707e+03_r8,0.62807e+03_r8 /)
      kbo(:,53, 7) = (/ &
        & 0.62574e+03_r8,0.62578e+03_r8,0.62614e+03_r8,0.62677e+03_r8,0.62768e+03_r8 /)
      kbo(:,54, 7) = (/ &
        & 0.62576e+03_r8,0.62580e+03_r8,0.62600e+03_r8,0.62652e+03_r8,0.62734e+03_r8 /)
      kbo(:,55, 7) = (/ &
        & 0.62585e+03_r8,0.62578e+03_r8,0.62588e+03_r8,0.62632e+03_r8,0.62705e+03_r8 /)
      kbo(:,56, 7) = (/ &
        & 0.62587e+03_r8,0.62576e+03_r8,0.62579e+03_r8,0.62615e+03_r8,0.62678e+03_r8 /)
      kbo(:,57, 7) = (/ &
        & 0.62591e+03_r8,0.62574e+03_r8,0.62580e+03_r8,0.62601e+03_r8,0.62655e+03_r8 /)
      kbo(:,58, 7) = (/ &
        & 0.62591e+03_r8,0.62583e+03_r8,0.62578e+03_r8,0.62590e+03_r8,0.62636e+03_r8 /)
      kbo(:,59, 7) = (/ &
        & 0.62590e+03_r8,0.62586e+03_r8,0.62578e+03_r8,0.62586e+03_r8,0.62628e+03_r8 /)
      kbo(:,13, 8) = (/ &
        & 0.81821e+03_r8,0.81877e+03_r8,0.81935e+03_r8,0.81999e+03_r8,0.82074e+03_r8 /)
      kbo(:,14, 8) = (/ &
        & 0.81826e+03_r8,0.81882e+03_r8,0.81939e+03_r8,0.82006e+03_r8,0.82081e+03_r8 /)
      kbo(:,15, 8) = (/ &
        & 0.81831e+03_r8,0.81888e+03_r8,0.81946e+03_r8,0.82012e+03_r8,0.82089e+03_r8 /)
      kbo(:,16, 8) = (/ &
        & 0.81836e+03_r8,0.81895e+03_r8,0.81952e+03_r8,0.82021e+03_r8,0.82098e+03_r8 /)
      kbo(:,17, 8) = (/ &
        & 0.81842e+03_r8,0.81901e+03_r8,0.81959e+03_r8,0.82028e+03_r8,0.82106e+03_r8 /)
      kbo(:,18, 8) = (/ &
        & 0.81847e+03_r8,0.81907e+03_r8,0.81965e+03_r8,0.82036e+03_r8,0.82116e+03_r8 /)
      kbo(:,19, 8) = (/ &
        & 0.81853e+03_r8,0.81913e+03_r8,0.81972e+03_r8,0.82043e+03_r8,0.82123e+03_r8 /)
      kbo(:,20, 8) = (/ &
        & 0.81860e+03_r8,0.81919e+03_r8,0.81980e+03_r8,0.82052e+03_r8,0.82133e+03_r8 /)
      kbo(:,21, 8) = (/ &
        & 0.81868e+03_r8,0.81925e+03_r8,0.81988e+03_r8,0.82061e+03_r8,0.82143e+03_r8 /)
      kbo(:,22, 8) = (/ &
        & 0.81879e+03_r8,0.81936e+03_r8,0.82001e+03_r8,0.82076e+03_r8,0.82160e+03_r8 /)
      kbo(:,23, 8) = (/ &
        & 0.81889e+03_r8,0.81947e+03_r8,0.82015e+03_r8,0.82091e+03_r8,0.82177e+03_r8 /)
      kbo(:,24, 8) = (/ &
        & 0.81902e+03_r8,0.81960e+03_r8,0.82030e+03_r8,0.82108e+03_r8,0.82195e+03_r8 /)
      kbo(:,25, 8) = (/ &
        & 0.81914e+03_r8,0.81974e+03_r8,0.82046e+03_r8,0.82126e+03_r8,0.82214e+03_r8 /)
      kbo(:,26, 8) = (/ &
        & 0.81927e+03_r8,0.81990e+03_r8,0.82063e+03_r8,0.82145e+03_r8,0.82236e+03_r8 /)
      kbo(:,27, 8) = (/ &
        & 0.81941e+03_r8,0.82006e+03_r8,0.82082e+03_r8,0.82166e+03_r8,0.82258e+03_r8 /)
      kbo(:,28, 8) = (/ &
        & 0.81957e+03_r8,0.82024e+03_r8,0.82101e+03_r8,0.82188e+03_r8,0.82281e+03_r8 /)
      kbo(:,29, 8) = (/ &
        & 0.81971e+03_r8,0.82042e+03_r8,0.82122e+03_r8,0.82210e+03_r8,0.82305e+03_r8 /)
      kbo(:,30, 8) = (/ &
        & 0.81988e+03_r8,0.82061e+03_r8,0.82143e+03_r8,0.82233e+03_r8,0.82330e+03_r8 /)
      kbo(:,31, 8) = (/ &
        & 0.82006e+03_r8,0.82081e+03_r8,0.82166e+03_r8,0.82258e+03_r8,0.82355e+03_r8 /)
      kbo(:,32, 8) = (/ &
        & 0.82025e+03_r8,0.82103e+03_r8,0.82189e+03_r8,0.82283e+03_r8,0.82380e+03_r8 /)
      kbo(:,33, 8) = (/ &
        & 0.82044e+03_r8,0.82124e+03_r8,0.82213e+03_r8,0.82308e+03_r8,0.82408e+03_r8 /)
      kbo(:,34, 8) = (/ &
        & 0.82062e+03_r8,0.82144e+03_r8,0.82234e+03_r8,0.82330e+03_r8,0.82432e+03_r8 /)
      kbo(:,35, 8) = (/ &
        & 0.82072e+03_r8,0.82155e+03_r8,0.82246e+03_r8,0.82342e+03_r8,0.82446e+03_r8 /)
      kbo(:,36, 8) = (/ &
        & 0.82074e+03_r8,0.82157e+03_r8,0.82248e+03_r8,0.82345e+03_r8,0.82448e+03_r8 /)
      kbo(:,37, 8) = (/ &
        & 0.82063e+03_r8,0.82146e+03_r8,0.82236e+03_r8,0.82332e+03_r8,0.82434e+03_r8 /)
      kbo(:,38, 8) = (/ &
        & 0.82053e+03_r8,0.82134e+03_r8,0.82223e+03_r8,0.82319e+03_r8,0.82419e+03_r8 /)
      kbo(:,39, 8) = (/ &
        & 0.82042e+03_r8,0.82122e+03_r8,0.82210e+03_r8,0.82305e+03_r8,0.82405e+03_r8 /)
      kbo(:,40, 8) = (/ &
        & 0.82024e+03_r8,0.82102e+03_r8,0.82188e+03_r8,0.82282e+03_r8,0.82380e+03_r8 /)
      kbo(:,41, 8) = (/ &
        & 0.82006e+03_r8,0.82081e+03_r8,0.82165e+03_r8,0.82257e+03_r8,0.82354e+03_r8 /)
      kbo(:,42, 8) = (/ &
        & 0.81988e+03_r8,0.82061e+03_r8,0.82143e+03_r8,0.82233e+03_r8,0.82329e+03_r8 /)
      kbo(:,43, 8) = (/ &
        & 0.81967e+03_r8,0.82037e+03_r8,0.82117e+03_r8,0.82204e+03_r8,0.82299e+03_r8 /)
      kbo(:,44, 8) = (/ &
        & 0.81946e+03_r8,0.82013e+03_r8,0.82089e+03_r8,0.82174e+03_r8,0.82267e+03_r8 /)
      kbo(:,45, 8) = (/ &
        & 0.81926e+03_r8,0.81989e+03_r8,0.82062e+03_r8,0.82144e+03_r8,0.82234e+03_r8 /)
      kbo(:,46, 8) = (/ &
        & 0.81907e+03_r8,0.81965e+03_r8,0.82034e+03_r8,0.82114e+03_r8,0.82201e+03_r8 /)
      kbo(:,47, 8) = (/ &
        & 0.81882e+03_r8,0.81939e+03_r8,0.82006e+03_r8,0.82081e+03_r8,0.82165e+03_r8 /)
      kbo(:,48, 8) = (/ &
        & 0.81858e+03_r8,0.81917e+03_r8,0.81978e+03_r8,0.82050e+03_r8,0.82130e+03_r8 /)
      kbo(:,49, 8) = (/ &
        & 0.81836e+03_r8,0.81894e+03_r8,0.81953e+03_r8,0.82019e+03_r8,0.82097e+03_r8 /)
      kbo(:,50, 8) = (/ &
        & 0.81817e+03_r8,0.81871e+03_r8,0.81929e+03_r8,0.81993e+03_r8,0.82067e+03_r8 /)
      kbo(:,51, 8) = (/ &
        & 0.81790e+03_r8,0.81850e+03_r8,0.81910e+03_r8,0.81967e+03_r8,0.82039e+03_r8 /)
      kbo(:,52, 8) = (/ &
        & 0.81779e+03_r8,0.81830e+03_r8,0.81888e+03_r8,0.81945e+03_r8,0.82012e+03_r8 /)
      kbo(:,53, 8) = (/ &
        & 0.81766e+03_r8,0.81812e+03_r8,0.81866e+03_r8,0.81924e+03_r8,0.81986e+03_r8 /)
      kbo(:,54, 8) = (/ &
        & 0.81744e+03_r8,0.81785e+03_r8,0.81846e+03_r8,0.81906e+03_r8,0.81964e+03_r8 /)
      kbo(:,55, 8) = (/ &
        & 0.81733e+03_r8,0.81777e+03_r8,0.81829e+03_r8,0.81886e+03_r8,0.81944e+03_r8 /)
      kbo(:,56, 8) = (/ &
        & 0.81741e+03_r8,0.81767e+03_r8,0.81813e+03_r8,0.81867e+03_r8,0.81925e+03_r8 /)
      kbo(:,57, 8) = (/ &
        & 0.81785e+03_r8,0.81749e+03_r8,0.81788e+03_r8,0.81848e+03_r8,0.81908e+03_r8 /)
      kbo(:,58, 8) = (/ &
        & 0.81817e+03_r8,0.81731e+03_r8,0.81779e+03_r8,0.81832e+03_r8,0.81889e+03_r8 /)
      kbo(:,59, 8) = (/ &
        & 0.81824e+03_r8,0.81736e+03_r8,0.81776e+03_r8,0.81826e+03_r8,0.81883e+03_r8 /)
      kbo(:,13, 9) = (/ &
        & 0.94133e+03_r8,0.94438e+03_r8,0.94687e+03_r8,0.94883e+03_r8,0.95021e+03_r8 /)
      kbo(:,14, 9) = (/ &
        & 0.94163e+03_r8,0.94463e+03_r8,0.94708e+03_r8,0.94898e+03_r8,0.95031e+03_r8 /)
      kbo(:,15, 9) = (/ &
        & 0.94195e+03_r8,0.94490e+03_r8,0.94731e+03_r8,0.94914e+03_r8,0.95042e+03_r8 /)
      kbo(:,16, 9) = (/ &
        & 0.94229e+03_r8,0.94518e+03_r8,0.94753e+03_r8,0.94930e+03_r8,0.95052e+03_r8 /)
      kbo(:,17, 9) = (/ &
        & 0.94262e+03_r8,0.94544e+03_r8,0.94774e+03_r8,0.94946e+03_r8,0.95061e+03_r8 /)
      kbo(:,18, 9) = (/ &
        & 0.94293e+03_r8,0.94570e+03_r8,0.94795e+03_r8,0.94960e+03_r8,0.95069e+03_r8 /)
      kbo(:,19, 9) = (/ &
        & 0.94323e+03_r8,0.94595e+03_r8,0.94814e+03_r8,0.94974e+03_r8,0.95078e+03_r8 /)
      kbo(:,20, 9) = (/ &
        & 0.94357e+03_r8,0.94624e+03_r8,0.94835e+03_r8,0.94989e+03_r8,0.95087e+03_r8 /)
      kbo(:,21, 9) = (/ &
        & 0.94393e+03_r8,0.94654e+03_r8,0.94857e+03_r8,0.95003e+03_r8,0.95096e+03_r8 /)
      kbo(:,22, 9) = (/ &
        & 0.94445e+03_r8,0.94695e+03_r8,0.94888e+03_r8,0.95025e+03_r8,0.95105e+03_r8 /)
      kbo(:,23, 9) = (/ &
        & 0.94499e+03_r8,0.94737e+03_r8,0.94919e+03_r8,0.95045e+03_r8,0.95113e+03_r8 /)
      kbo(:,24, 9) = (/ &
        & 0.94549e+03_r8,0.94778e+03_r8,0.94948e+03_r8,0.95063e+03_r8,0.95120e+03_r8 /)
      kbo(:,25, 9) = (/ &
        & 0.94602e+03_r8,0.94819e+03_r8,0.94978e+03_r8,0.95082e+03_r8,0.95125e+03_r8 /)
      kbo(:,26, 9) = (/ &
        & 0.94658e+03_r8,0.94861e+03_r8,0.95006e+03_r8,0.95096e+03_r8,0.95127e+03_r8 /)
      kbo(:,27, 9) = (/ &
        & 0.94710e+03_r8,0.94900e+03_r8,0.95033e+03_r8,0.95109e+03_r8,0.95126e+03_r8 /)
      kbo(:,28, 9) = (/ &
        & 0.94759e+03_r8,0.94937e+03_r8,0.95056e+03_r8,0.95118e+03_r8,0.95123e+03_r8 /)
      kbo(:,29, 9) = (/ &
        & 0.94811e+03_r8,0.94973e+03_r8,0.95077e+03_r8,0.95124e+03_r8,0.95116e+03_r8 /)
      kbo(:,30, 9) = (/ &
        & 0.94856e+03_r8,0.95003e+03_r8,0.95095e+03_r8,0.95127e+03_r8,0.95105e+03_r8 /)
      kbo(:,31, 9) = (/ &
        & 0.94901e+03_r8,0.95032e+03_r8,0.95108e+03_r8,0.95127e+03_r8,0.95090e+03_r8 /)
      kbo(:,32, 9) = (/ &
        & 0.94939e+03_r8,0.95057e+03_r8,0.95118e+03_r8,0.95121e+03_r8,0.95071e+03_r8 /)
      kbo(:,33, 9) = (/ &
        & 0.94975e+03_r8,0.95079e+03_r8,0.95125e+03_r8,0.95115e+03_r8,0.95050e+03_r8 /)
      kbo(:,34, 9) = (/ &
        & 0.95004e+03_r8,0.95095e+03_r8,0.95128e+03_r8,0.95105e+03_r8,0.95030e+03_r8 /)
      kbo(:,35, 9) = (/ &
        & 0.95020e+03_r8,0.95102e+03_r8,0.95127e+03_r8,0.95098e+03_r8,0.95016e+03_r8 /)
      kbo(:,36, 9) = (/ &
        & 0.95021e+03_r8,0.95103e+03_r8,0.95127e+03_r8,0.95096e+03_r8,0.95023e+03_r8 /)
      kbo(:,37, 9) = (/ &
        & 0.95006e+03_r8,0.95096e+03_r8,0.95127e+03_r8,0.95104e+03_r8,0.95027e+03_r8 /)
      kbo(:,38, 9) = (/ &
        & 0.94990e+03_r8,0.95087e+03_r8,0.95126e+03_r8,0.95110e+03_r8,0.95040e+03_r8 /)
      kbo(:,39, 9) = (/ &
        & 0.94972e+03_r8,0.95077e+03_r8,0.95124e+03_r8,0.95117e+03_r8,0.95053e+03_r8 /)
      kbo(:,40, 9) = (/ &
        & 0.94939e+03_r8,0.95057e+03_r8,0.95118e+03_r8,0.95123e+03_r8,0.95072e+03_r8 /)
      kbo(:,41, 9) = (/ &
        & 0.94899e+03_r8,0.95032e+03_r8,0.95108e+03_r8,0.95127e+03_r8,0.95090e+03_r8 /)
      kbo(:,42, 9) = (/ &
        & 0.94856e+03_r8,0.95004e+03_r8,0.95094e+03_r8,0.95127e+03_r8,0.95105e+03_r8 /)
      kbo(:,43, 9) = (/ &
        & 0.94799e+03_r8,0.94963e+03_r8,0.95073e+03_r8,0.95123e+03_r8,0.95118e+03_r8 /)
      kbo(:,44, 9) = (/ &
        & 0.94729e+03_r8,0.94914e+03_r8,0.95041e+03_r8,0.95112e+03_r8,0.95126e+03_r8 /)
      kbo(:,45, 9) = (/ &
        & 0.94655e+03_r8,0.94858e+03_r8,0.95004e+03_r8,0.95095e+03_r8,0.95127e+03_r8 /)
      kbo(:,46, 9) = (/ &
        & 0.94568e+03_r8,0.94792e+03_r8,0.94958e+03_r8,0.95070e+03_r8,0.95122e+03_r8 /)
      kbo(:,47, 9) = (/ &
        & 0.94463e+03_r8,0.94708e+03_r8,0.94898e+03_r8,0.95031e+03_r8,0.95108e+03_r8 /)
      kbo(:,48, 9) = (/ &
        & 0.94348e+03_r8,0.94616e+03_r8,0.94829e+03_r8,0.94984e+03_r8,0.95084e+03_r8 /)
      kbo(:,49, 9) = (/ &
        & 0.94226e+03_r8,0.94515e+03_r8,0.94748e+03_r8,0.94928e+03_r8,0.95051e+03_r8 /)
      kbo(:,50, 9) = (/ &
        & 0.94103e+03_r8,0.94413e+03_r8,0.94669e+03_r8,0.94868e+03_r8,0.95011e+03_r8 /)
      kbo(:,51, 9) = (/ &
        & 0.93978e+03_r8,0.94307e+03_r8,0.94580e+03_r8,0.94802e+03_r8,0.94965e+03_r8 /)
      kbo(:,52, 9) = (/ &
        & 0.93828e+03_r8,0.94192e+03_r8,0.94488e+03_r8,0.94728e+03_r8,0.94912e+03_r8 /)
      kbo(:,53, 9) = (/ &
        & 0.93678e+03_r8,0.94072e+03_r8,0.94388e+03_r8,0.94646e+03_r8,0.94851e+03_r8 /)
      kbo(:,54, 9) = (/ &
        & 0.93537e+03_r8,0.93955e+03_r8,0.94287e+03_r8,0.94565e+03_r8,0.94789e+03_r8 /)
      kbo(:,55, 9) = (/ &
        & 0.93380e+03_r8,0.93820e+03_r8,0.94186e+03_r8,0.94483e+03_r8,0.94722e+03_r8 /)
      kbo(:,56, 9) = (/ &
        & 0.93205e+03_r8,0.93688e+03_r8,0.94080e+03_r8,0.94394e+03_r8,0.94652e+03_r8 /)
      kbo(:,57, 9) = (/ &
        & 0.92997e+03_r8,0.93554e+03_r8,0.93969e+03_r8,0.94299e+03_r8,0.94574e+03_r8 /)
      kbo(:,58, 9) = (/ &
        & 0.92808e+03_r8,0.93414e+03_r8,0.93844e+03_r8,0.94204e+03_r8,0.94498e+03_r8 /)
      kbo(:,59, 9) = (/ &
        & 0.92793e+03_r8,0.93341e+03_r8,0.93792e+03_r8,0.94165e+03_r8,0.94465e+03_r8 /)
      kbo(:,13,10) = (/ &
        & 0.98036e+03_r8,0.98526e+03_r8,0.98973e+03_r8,0.99279e+03_r8,0.99468e+03_r8 /)
      kbo(:,14,10) = (/ &
        & 0.98067e+03_r8,0.98568e+03_r8,0.99005e+03_r8,0.99301e+03_r8,0.99477e+03_r8 /)
      kbo(:,15,10) = (/ &
        & 0.98125e+03_r8,0.98614e+03_r8,0.99040e+03_r8,0.99324e+03_r8,0.99485e+03_r8 /)
      kbo(:,16,10) = (/ &
        & 0.98185e+03_r8,0.98662e+03_r8,0.99076e+03_r8,0.99348e+03_r8,0.99493e+03_r8 /)
      kbo(:,17,10) = (/ &
        & 0.98242e+03_r8,0.98721e+03_r8,0.99109e+03_r8,0.99369e+03_r8,0.99498e+03_r8 /)
      kbo(:,18,10) = (/ &
        & 0.98296e+03_r8,0.98755e+03_r8,0.99141e+03_r8,0.99390e+03_r8,0.99502e+03_r8 /)
      kbo(:,19,10) = (/ &
        & 0.98350e+03_r8,0.98800e+03_r8,0.99172e+03_r8,0.99408e+03_r8,0.99505e+03_r8 /)
      kbo(:,20,10) = (/ &
        & 0.98411e+03_r8,0.98852e+03_r8,0.99205e+03_r8,0.99428e+03_r8,0.99507e+03_r8 /)
      kbo(:,21,10) = (/ &
        & 0.98464e+03_r8,0.98894e+03_r8,0.99238e+03_r8,0.99447e+03_r8,0.99496e+03_r8 /)
      kbo(:,22,10) = (/ &
        & 0.98547e+03_r8,0.98983e+03_r8,0.99286e+03_r8,0.99470e+03_r8,0.99509e+03_r8 /)
      kbo(:,23,10) = (/ &
        & 0.98617e+03_r8,0.99062e+03_r8,0.99331e+03_r8,0.99487e+03_r8,0.99508e+03_r8 /)
      kbo(:,24,10) = (/ &
        & 0.98718e+03_r8,0.99115e+03_r8,0.99373e+03_r8,0.99499e+03_r8,0.99503e+03_r8 /)
      kbo(:,25,10) = (/ &
        & 0.98813e+03_r8,0.99180e+03_r8,0.99413e+03_r8,0.99494e+03_r8,0.99492e+03_r8 /)
      kbo(:,26,10) = (/ &
        & 0.98918e+03_r8,0.99244e+03_r8,0.99450e+03_r8,0.99508e+03_r8,0.99475e+03_r8 /)
      kbo(:,27,10) = (/ &
        & 0.99010e+03_r8,0.99304e+03_r8,0.99478e+03_r8,0.99509e+03_r8,0.99499e+03_r8 /)
      kbo(:,28,10) = (/ &
        & 0.99090e+03_r8,0.99357e+03_r8,0.99495e+03_r8,0.99505e+03_r8,0.99433e+03_r8 /)
      kbo(:,29,10) = (/ &
        & 0.99167e+03_r8,0.99393e+03_r8,0.99505e+03_r8,0.99495e+03_r8,0.99385e+03_r8 /)
      kbo(:,30,10) = (/ &
        & 0.99249e+03_r8,0.99447e+03_r8,0.99508e+03_r8,0.99477e+03_r8,0.99348e+03_r8 /)
      kbo(:,31,10) = (/ &
        & 0.99290e+03_r8,0.99477e+03_r8,0.99509e+03_r8,0.99452e+03_r8,0.99326e+03_r8 /)
      kbo(:,32,10) = (/ &
        & 0.99360e+03_r8,0.99496e+03_r8,0.99505e+03_r8,0.99419e+03_r8,0.99287e+03_r8 /)
      kbo(:,33,10) = (/ &
        & 0.99410e+03_r8,0.99506e+03_r8,0.99493e+03_r8,0.99381e+03_r8,0.99210e+03_r8 /)
      kbo(:,34,10) = (/ &
        & 0.99447e+03_r8,0.99508e+03_r8,0.99465e+03_r8,0.99347e+03_r8,0.99121e+03_r8 /)
      kbo(:,35,10) = (/ &
        & 0.99453e+03_r8,0.99509e+03_r8,0.99465e+03_r8,0.99330e+03_r8,0.99083e+03_r8 /)
      kbo(:,36,10) = (/ &
        & 0.99467e+03_r8,0.99509e+03_r8,0.99463e+03_r8,0.99327e+03_r8,0.98992e+03_r8 /)
      kbo(:,37,10) = (/ &
        & 0.99451e+03_r8,0.99508e+03_r8,0.99475e+03_r8,0.99344e+03_r8,0.99124e+03_r8 /)
      kbo(:,38,10) = (/ &
        & 0.99429e+03_r8,0.99507e+03_r8,0.99486e+03_r8,0.99365e+03_r8,0.99174e+03_r8 /)
      kbo(:,39,10) = (/ &
        & 0.99405e+03_r8,0.99505e+03_r8,0.99495e+03_r8,0.99373e+03_r8,0.99219e+03_r8 /)
      kbo(:,40,10) = (/ &
        & 0.99347e+03_r8,0.99496e+03_r8,0.99505e+03_r8,0.99420e+03_r8,0.99289e+03_r8 /)
      kbo(:,41,10) = (/ &
        & 0.99302e+03_r8,0.99477e+03_r8,0.99509e+03_r8,0.99452e+03_r8,0.99315e+03_r8 /)
      kbo(:,42,10) = (/ &
        & 0.99237e+03_r8,0.99435e+03_r8,0.99508e+03_r8,0.99477e+03_r8,0.99348e+03_r8 /)
      kbo(:,43,10) = (/ &
        & 0.99148e+03_r8,0.99394e+03_r8,0.99491e+03_r8,0.99498e+03_r8,0.99395e+03_r8 /)
      kbo(:,44,10) = (/ &
        & 0.99040e+03_r8,0.99324e+03_r8,0.99485e+03_r8,0.99508e+03_r8,0.99453e+03_r8 /)
      kbo(:,45,10) = (/ &
        & 0.98910e+03_r8,0.99241e+03_r8,0.99449e+03_r8,0.99508e+03_r8,0.99476e+03_r8 /)
      kbo(:,46,10) = (/ &
        & 0.98735e+03_r8,0.99138e+03_r8,0.99388e+03_r8,0.99490e+03_r8,0.99500e+03_r8 /)
      kbo(:,47,10) = (/ &
        & 0.98565e+03_r8,0.99006e+03_r8,0.99301e+03_r8,0.99477e+03_r8,0.99509e+03_r8 /)
      kbo(:,48,10) = (/ &
        & 0.98383e+03_r8,0.98834e+03_r8,0.99196e+03_r8,0.99423e+03_r8,0.99507e+03_r8 /)
      kbo(:,49,10) = (/ &
        & 0.98174e+03_r8,0.98651e+03_r8,0.99073e+03_r8,0.99346e+03_r8,0.99492e+03_r8 /)
      kbo(:,50,10) = (/ &
        & 0.97955e+03_r8,0.98480e+03_r8,0.98924e+03_r8,0.99257e+03_r8,0.99470e+03_r8 /)
      kbo(:,51,10) = (/ &
        & 0.97755e+03_r8,0.98298e+03_r8,0.98767e+03_r8,0.99154e+03_r8,0.99399e+03_r8 /)
      kbo(:,52,10) = (/ &
        & 0.97554e+03_r8,0.98111e+03_r8,0.98597e+03_r8,0.99036e+03_r8,0.99323e+03_r8 /)
      kbo(:,53,10) = (/ &
        & 0.97320e+03_r8,0.97892e+03_r8,0.98413e+03_r8,0.98888e+03_r8,0.99232e+03_r8 /)
      kbo(:,54,10) = (/ &
        & 0.97086e+03_r8,0.97720e+03_r8,0.98263e+03_r8,0.98733e+03_r8,0.99135e+03_r8 /)
      kbo(:,55,10) = (/ &
        & 0.96881e+03_r8,0.97539e+03_r8,0.98096e+03_r8,0.98583e+03_r8,0.99029e+03_r8 /)
      kbo(:,56,10) = (/ &
        & 0.96735e+03_r8,0.97336e+03_r8,0.97906e+03_r8,0.98435e+03_r8,0.98900e+03_r8 /)
      kbo(:,57,10) = (/ &
        & 0.96407e+03_r8,0.97115e+03_r8,0.97740e+03_r8,0.98282e+03_r8,0.98752e+03_r8 /)
      kbo(:,58,10) = (/ &
        & 0.96154e+03_r8,0.96893e+03_r8,0.97574e+03_r8,0.98129e+03_r8,0.98611e+03_r8 /)
      kbo(:,59,10) = (/ &
        & 0.95571e+03_r8,0.96861e+03_r8,0.97503e+03_r8,0.98063e+03_r8,0.98557e+03_r8 /)
      kbo(:,13,11) = (/ &
        & 0.98771e+03_r8,0.99296e+03_r8,0.99655e+03_r8,0.99859e+03_r8,0.99936e+03_r8 /)
      kbo(:,14,11) = (/ &
        & 0.98850e+03_r8,0.99335e+03_r8,0.99679e+03_r8,0.99871e+03_r8,0.99939e+03_r8 /)
      kbo(:,15,11) = (/ &
        & 0.98905e+03_r8,0.99377e+03_r8,0.99705e+03_r8,0.99882e+03_r8,0.99942e+03_r8 /)
      kbo(:,16,11) = (/ &
        & 0.98962e+03_r8,0.99419e+03_r8,0.99730e+03_r8,0.99893e+03_r8,0.99945e+03_r8 /)
      kbo(:,17,11) = (/ &
        & 0.99016e+03_r8,0.99444e+03_r8,0.99754e+03_r8,0.99903e+03_r8,0.99947e+03_r8 /)
      kbo(:,18,11) = (/ &
        & 0.99067e+03_r8,0.99497e+03_r8,0.99775e+03_r8,0.99911e+03_r8,0.99948e+03_r8 /)
      kbo(:,19,11) = (/ &
        & 0.99117e+03_r8,0.99532e+03_r8,0.99795e+03_r8,0.99918e+03_r8,0.99949e+03_r8 /)
      kbo(:,20,11) = (/ &
        & 0.99173e+03_r8,0.99572e+03_r8,0.99816e+03_r8,0.99924e+03_r8,0.99949e+03_r8 /)
      kbo(:,21,11) = (/ &
        & 0.99228e+03_r8,0.99610e+03_r8,0.99835e+03_r8,0.99929e+03_r8,0.99946e+03_r8 /)
      kbo(:,22,11) = (/ &
        & 0.99309e+03_r8,0.99663e+03_r8,0.99862e+03_r8,0.99936e+03_r8,0.99953e+03_r8 /)
      kbo(:,23,11) = (/ &
        & 0.99388e+03_r8,0.99698e+03_r8,0.99900e+03_r8,0.99942e+03_r8,0.99925e+03_r8 /)
      kbo(:,24,11) = (/ &
        & 0.99466e+03_r8,0.99758e+03_r8,0.99904e+03_r8,0.99947e+03_r8,0.99905e+03_r8 /)
      kbo(:,25,11) = (/ &
        & 0.99542e+03_r8,0.99800e+03_r8,0.99919e+03_r8,0.99963e+03_r8,0.99878e+03_r8 /)
      kbo(:,26,11) = (/ &
        & 0.99618e+03_r8,0.99839e+03_r8,0.99930e+03_r8,0.99945e+03_r8,0.99847e+03_r8 /)
      kbo(:,27,11) = (/ &
        & 0.99683e+03_r8,0.99872e+03_r8,0.99939e+03_r8,0.99934e+03_r8,0.99751e+03_r8 /)
      kbo(:,28,11) = (/ &
        & 0.99741e+03_r8,0.99897e+03_r8,0.99946e+03_r8,0.99913e+03_r8,0.99749e+03_r8 /)
      kbo(:,29,11) = (/ &
        & 0.99792e+03_r8,0.99917e+03_r8,0.99949e+03_r8,0.99884e+03_r8,0.99707e+03_r8 /)
      kbo(:,30,11) = (/ &
        & 0.99821e+03_r8,0.99929e+03_r8,0.99946e+03_r8,0.99850e+03_r8,0.99637e+03_r8 /)
      kbo(:,31,11) = (/ &
        & 0.99871e+03_r8,0.99938e+03_r8,0.99949e+03_r8,0.99810e+03_r8,0.99532e+03_r8 /)
      kbo(:,32,11) = (/ &
        & 0.99899e+03_r8,0.99961e+03_r8,0.99926e+03_r8,0.99761e+03_r8,0.99460e+03_r8 /)
      kbo(:,33,11) = (/ &
        & 0.99918e+03_r8,0.99949e+03_r8,0.99880e+03_r8,0.99700e+03_r8,0.99413e+03_r8 /)
      kbo(:,34,11) = (/ &
        & 0.99929e+03_r8,0.99946e+03_r8,0.99850e+03_r8,0.99635e+03_r8,0.99329e+03_r8 /)
      kbo(:,35,11) = (/ &
        & 0.99934e+03_r8,0.99941e+03_r8,0.99830e+03_r8,0.99590e+03_r8,0.99292e+03_r8 /)
      kbo(:,36,11) = (/ &
        & 0.99935e+03_r8,0.99940e+03_r8,0.99826e+03_r8,0.99583e+03_r8,0.99287e+03_r8 /)
      kbo(:,37,11) = (/ &
        & 0.99930e+03_r8,0.99946e+03_r8,0.99846e+03_r8,0.99628e+03_r8,0.99327e+03_r8 /)
      kbo(:,38,11) = (/ &
        & 0.99924e+03_r8,0.99949e+03_r8,0.99866e+03_r8,0.99670e+03_r8,0.99350e+03_r8 /)
      kbo(:,39,11) = (/ &
        & 0.99917e+03_r8,0.99949e+03_r8,0.99899e+03_r8,0.99707e+03_r8,0.99451e+03_r8 /)
      kbo(:,40,11) = (/ &
        & 0.99898e+03_r8,0.99946e+03_r8,0.99913e+03_r8,0.99777e+03_r8,0.99505e+03_r8 /)
      kbo(:,41,11) = (/ &
        & 0.99871e+03_r8,0.99939e+03_r8,0.99935e+03_r8,0.99810e+03_r8,0.99546e+03_r8 /)
      kbo(:,42,11) = (/ &
        & 0.99835e+03_r8,0.99929e+03_r8,0.99947e+03_r8,0.99851e+03_r8,0.99637e+03_r8 /)
      kbo(:,43,11) = (/ &
        & 0.99780e+03_r8,0.99913e+03_r8,0.99949e+03_r8,0.99893e+03_r8,0.99722e+03_r8 /)
      kbo(:,44,11) = (/ &
        & 0.99704e+03_r8,0.99882e+03_r8,0.99942e+03_r8,0.99928e+03_r8,0.99778e+03_r8 /)
      kbo(:,45,11) = (/ &
        & 0.99613e+03_r8,0.99837e+03_r8,0.99930e+03_r8,0.99947e+03_r8,0.99849e+03_r8 /)
      kbo(:,46,11) = (/ &
        & 0.99492e+03_r8,0.99787e+03_r8,0.99911e+03_r8,0.99949e+03_r8,0.99897e+03_r8 /)
      kbo(:,47,11) = (/ &
        & 0.99335e+03_r8,0.99679e+03_r8,0.99871e+03_r8,0.99939e+03_r8,0.99936e+03_r8 /)
      kbo(:,48,11) = (/ &
        & 0.99156e+03_r8,0.99560e+03_r8,0.99810e+03_r8,0.99923e+03_r8,0.99951e+03_r8 /)
      kbo(:,49,11) = (/ &
        & 0.98955e+03_r8,0.99414e+03_r8,0.99727e+03_r8,0.99894e+03_r8,0.99946e+03_r8 /)
      kbo(:,50,11) = (/ &
        & 0.98749e+03_r8,0.99256e+03_r8,0.99630e+03_r8,0.99847e+03_r8,0.99918e+03_r8 /)
      kbo(:,51,11) = (/ &
        & 0.98496e+03_r8,0.99085e+03_r8,0.99509e+03_r8,0.99784e+03_r8,0.99916e+03_r8 /)
      kbo(:,52,11) = (/ &
        & 0.98304e+03_r8,0.98897e+03_r8,0.99370e+03_r8,0.99701e+03_r8,0.99883e+03_r8 /)
      kbo(:,53,11) = (/ &
        & 0.98104e+03_r8,0.98693e+03_r8,0.99213e+03_r8,0.99600e+03_r8,0.99833e+03_r8 /)
      kbo(:,54,11) = (/ &
        & 0.97906e+03_r8,0.98440e+03_r8,0.99053e+03_r8,0.99485e+03_r8,0.99771e+03_r8 /)
      kbo(:,55,11) = (/ &
        & 0.97789e+03_r8,0.98286e+03_r8,0.98886e+03_r8,0.99361e+03_r8,0.99696e+03_r8 /)
      kbo(:,56,11) = (/ &
        & 0.97514e+03_r8,0.98117e+03_r8,0.98708e+03_r8,0.99224e+03_r8,0.99622e+03_r8 /)
      kbo(:,57,11) = (/ &
        & 0.97242e+03_r8,0.97945e+03_r8,0.98472e+03_r8,0.99072e+03_r8,0.99500e+03_r8 /)
      kbo(:,58,11) = (/ &
        & 0.96969e+03_r8,0.97814e+03_r8,0.98316e+03_r8,0.98916e+03_r8,0.99384e+03_r8 /)
      kbo(:,59,11) = (/ &
        & 0.96859e+03_r8,0.97725e+03_r8,0.98261e+03_r8,0.98851e+03_r8,0.99335e+03_r8 /)
      kbo(:,13,12) = (/ &
        & 0.99768e+03_r8,0.99984e+03_r8,0.10010e+04_r8,0.10024e+04_r8,0.10029e+04_r8 /)
      kbo(:,14,12) = (/ &
        & 0.99795e+03_r8,0.99992e+03_r8,0.10011e+04_r8,0.10025e+04_r8,0.10029e+04_r8 /)
      kbo(:,15,12) = (/ &
        & 0.99880e+03_r8,0.99996e+03_r8,0.10013e+04_r8,0.10026e+04_r8,0.10031e+04_r8 /)
      kbo(:,16,12) = (/ &
        & 0.99852e+03_r8,0.10003e+04_r8,0.10015e+04_r8,0.10028e+04_r8,0.10029e+04_r8 /)
      kbo(:,17,12) = (/ &
        & 0.99876e+03_r8,0.10000e+04_r8,0.10016e+04_r8,0.10027e+04_r8,0.10029e+04_r8 /)
      kbo(:,18,12) = (/ &
        & 0.99898e+03_r8,0.10001e+04_r8,0.10018e+04_r8,0.10028e+04_r8,0.10028e+04_r8 /)
      kbo(:,19,12) = (/ &
        & 0.99918e+03_r8,0.10003e+04_r8,0.10021e+04_r8,0.10028e+04_r8,0.10028e+04_r8 /)
      kbo(:,20,12) = (/ &
        & 0.99940e+03_r8,0.10005e+04_r8,0.10026e+04_r8,0.10029e+04_r8,0.10031e+04_r8 /)
      kbo(:,21,12) = (/ &
        & 0.99959e+03_r8,0.10007e+04_r8,0.10022e+04_r8,0.10029e+04_r8,0.10026e+04_r8 /)
      kbo(:,22,12) = (/ &
        & 0.99984e+03_r8,0.10010e+04_r8,0.10024e+04_r8,0.10030e+04_r8,0.10023e+04_r8 /)
      kbo(:,23,12) = (/ &
        & 0.99996e+03_r8,0.10013e+04_r8,0.10024e+04_r8,0.10029e+04_r8,0.10025e+04_r8 /)
      kbo(:,24,12) = (/ &
        & 0.10000e+04_r8,0.10016e+04_r8,0.10029e+04_r8,0.10029e+04_r8,0.10023e+04_r8 /)
      kbo(:,25,12) = (/ &
        & 0.10003e+04_r8,0.10023e+04_r8,0.10029e+04_r8,0.10026e+04_r8,0.10019e+04_r8 /)
      kbo(:,26,12) = (/ &
        & 0.10007e+04_r8,0.10022e+04_r8,0.10029e+04_r8,0.10026e+04_r8,0.10015e+04_r8 /)
      kbo(:,27,12) = (/ &
        & 0.10012e+04_r8,0.10025e+04_r8,0.10031e+04_r8,0.10024e+04_r8,0.10010e+04_r8 /)
      kbo(:,28,12) = (/ &
        & 0.10015e+04_r8,0.10027e+04_r8,0.10029e+04_r8,0.10022e+04_r8,0.10005e+04_r8 /)
      kbo(:,29,12) = (/ &
        & 0.10019e+04_r8,0.10028e+04_r8,0.10028e+04_r8,0.10019e+04_r8,0.99992e+03_r8 /)
      kbo(:,30,12) = (/ &
        & 0.10022e+04_r8,0.10029e+04_r8,0.10026e+04_r8,0.10017e+04_r8,0.99965e+03_r8 /)
      kbo(:,31,12) = (/ &
        & 0.10025e+04_r8,0.10030e+04_r8,0.10022e+04_r8,0.10011e+04_r8,0.99843e+03_r8 /)
      kbo(:,32,12) = (/ &
        & 0.10027e+04_r8,0.10029e+04_r8,0.10020e+04_r8,0.10007e+04_r8,0.99748e+03_r8 /)
      kbo(:,33,12) = (/ &
        & 0.10029e+04_r8,0.10028e+04_r8,0.10021e+04_r8,0.10000e+04_r8,0.99658e+03_r8 /)
      kbo(:,34,12) = (/ &
        & 0.10031e+04_r8,0.10026e+04_r8,0.10017e+04_r8,0.99945e+03_r8,0.99563e+03_r8 /)
      kbo(:,35,12) = (/ &
        & 0.10030e+04_r8,0.10025e+04_r8,0.10031e+04_r8,0.99888e+03_r8,0.99496e+03_r8 /)
      kbo(:,36,12) = (/ &
        & 0.10030e+04_r8,0.10025e+04_r8,0.10020e+04_r8,0.99880e+03_r8,0.99482e+03_r8 /)
      kbo(:,37,12) = (/ &
        & 0.10029e+04_r8,0.10026e+04_r8,0.10015e+04_r8,0.99939e+03_r8,0.99547e+03_r8 /)
      kbo(:,38,12) = (/ &
        & 0.10029e+04_r8,0.10027e+04_r8,0.10017e+04_r8,0.99958e+03_r8,0.99634e+03_r8 /)
      kbo(:,39,12) = (/ &
        & 0.10028e+04_r8,0.10028e+04_r8,0.10017e+04_r8,0.99993e+03_r8,0.99613e+03_r8 /)
      kbo(:,40,12) = (/ &
        & 0.10027e+04_r8,0.10029e+04_r8,0.10022e+04_r8,0.10003e+04_r8,0.99696e+03_r8 /)
      kbo(:,41,12) = (/ &
        & 0.10027e+04_r8,0.10029e+04_r8,0.10024e+04_r8,0.10013e+04_r8,0.99857e+03_r8 /)
      kbo(:,42,12) = (/ &
        & 0.10022e+04_r8,0.10029e+04_r8,0.10028e+04_r8,0.10021e+04_r8,0.99929e+03_r8 /)
      kbo(:,43,12) = (/ &
        & 0.10018e+04_r8,0.10028e+04_r8,0.10028e+04_r8,0.10020e+04_r8,0.10001e+04_r8 /)
      kbo(:,44,12) = (/ &
        & 0.10013e+04_r8,0.10026e+04_r8,0.10029e+04_r8,0.10023e+04_r8,0.10016e+04_r8 /)
      kbo(:,45,12) = (/ &
        & 0.10007e+04_r8,0.10022e+04_r8,0.10029e+04_r8,0.10026e+04_r8,0.10015e+04_r8 /)
      kbo(:,46,12) = (/ &
        & 0.10014e+04_r8,0.10016e+04_r8,0.10028e+04_r8,0.10028e+04_r8,0.10020e+04_r8 /)
      kbo(:,47,12) = (/ &
        & 0.99993e+03_r8,0.10012e+04_r8,0.10025e+04_r8,0.10029e+04_r8,0.10024e+04_r8 /)
      kbo(:,48,12) = (/ &
        & 0.99937e+03_r8,0.10005e+04_r8,0.10022e+04_r8,0.10029e+04_r8,0.10027e+04_r8 /)
      kbo(:,49,12) = (/ &
        & 0.99853e+03_r8,0.10002e+04_r8,0.10015e+04_r8,0.10026e+04_r8,0.10029e+04_r8 /)
      kbo(:,50,12) = (/ &
        & 0.99741e+03_r8,0.99993e+03_r8,0.10008e+04_r8,0.10023e+04_r8,0.10029e+04_r8 /)
      kbo(:,51,12) = (/ &
        & 0.99665e+03_r8,0.99912e+03_r8,0.10002e+04_r8,0.10018e+04_r8,0.10028e+04_r8 /)
      kbo(:,52,12) = (/ &
        & 0.99385e+03_r8,0.99826e+03_r8,0.10000e+04_r8,0.10013e+04_r8,0.10025e+04_r8 /)
      kbo(:,53,12) = (/ &
        & 0.99099e+03_r8,0.99714e+03_r8,0.99965e+03_r8,0.10007e+04_r8,0.10022e+04_r8 /)
      kbo(:,54,12) = (/ &
        & 0.98826e+03_r8,0.99612e+03_r8,0.99903e+03_r8,0.10002e+04_r8,0.10018e+04_r8 /)
      kbo(:,55,12) = (/ &
        & 0.98397e+03_r8,0.99379e+03_r8,0.99822e+03_r8,0.10000e+04_r8,0.10013e+04_r8 /)
      kbo(:,56,12) = (/ &
        & 0.98006e+03_r8,0.99120e+03_r8,0.99722e+03_r8,0.99969e+03_r8,0.10006e+04_r8 /)
      kbo(:,57,12) = (/ &
        & 0.97631e+03_r8,0.98840e+03_r8,0.99624e+03_r8,0.99911e+03_r8,0.10002e+04_r8 /)
      kbo(:,58,12) = (/ &
        & 0.97279e+03_r8,0.98508e+03_r8,0.99422e+03_r8,0.99838e+03_r8,0.10001e+04_r8 /)
      kbo(:,59,12) = (/ &
        & 0.97171e+03_r8,0.98327e+03_r8,0.99315e+03_r8,0.99818e+03_r8,0.99997e+03_r8 /)
      kbo(:,13,13) = (/ &
        & 0.99623e+03_r8,0.99978e+03_r8,0.10034e+04_r8,0.10050e+04_r8,0.10054e+04_r8 /)
      kbo(:,14,13) = (/ &
        & 0.99674e+03_r8,0.10002e+04_r8,0.10034e+04_r8,0.10050e+04_r8,0.10053e+04_r8 /)
      kbo(:,15,13) = (/ &
        & 0.99652e+03_r8,0.10007e+04_r8,0.10036e+04_r8,0.10051e+04_r8,0.10051e+04_r8 /)
      kbo(:,16,13) = (/ &
        & 0.99785e+03_r8,0.10007e+04_r8,0.10039e+04_r8,0.10049e+04_r8,0.10053e+04_r8 /)
      kbo(:,17,13) = (/ &
        & 0.99816e+03_r8,0.10017e+04_r8,0.10043e+04_r8,0.10052e+04_r8,0.10052e+04_r8 /)
      kbo(:,18,13) = (/ &
        & 0.99792e+03_r8,0.10021e+04_r8,0.10042e+04_r8,0.10053e+04_r8,0.10051e+04_r8 /)
      kbo(:,19,13) = (/ &
        & 0.99826e+03_r8,0.10023e+04_r8,0.10042e+04_r8,0.10053e+04_r8,0.10051e+04_r8 /)
      kbo(:,20,13) = (/ &
        & 0.99869e+03_r8,0.10028e+04_r8,0.10038e+04_r8,0.10053e+04_r8,0.10044e+04_r8 /)
      kbo(:,21,13) = (/ &
        & 0.99914e+03_r8,0.10028e+04_r8,0.10048e+04_r8,0.10054e+04_r8,0.10048e+04_r8 /)
      kbo(:,22,13) = (/ &
        & 0.99989e+03_r8,0.10035e+04_r8,0.10050e+04_r8,0.10053e+04_r8,0.10046e+04_r8 /)
      kbo(:,23,13) = (/ &
        & 0.10011e+04_r8,0.10037e+04_r8,0.10051e+04_r8,0.10053e+04_r8,0.10041e+04_r8 /)
      kbo(:,24,13) = (/ &
        & 0.10018e+04_r8,0.10041e+04_r8,0.10050e+04_r8,0.10052e+04_r8,0.10037e+04_r8 /)
      kbo(:,25,13) = (/ &
        & 0.10026e+04_r8,0.10040e+04_r8,0.10056e+04_r8,0.10050e+04_r8,0.10036e+04_r8 /)
      kbo(:,26,13) = (/ &
        & 0.10031e+04_r8,0.10048e+04_r8,0.10054e+04_r8,0.10050e+04_r8,0.10030e+04_r8 /)
      kbo(:,27,13) = (/ &
        & 0.10047e+04_r8,0.10050e+04_r8,0.10051e+04_r8,0.10045e+04_r8,0.10025e+04_r8 /)
      kbo(:,28,13) = (/ &
        & 0.10039e+04_r8,0.10052e+04_r8,0.10052e+04_r8,0.10041e+04_r8,0.10018e+04_r8 /)
      kbo(:,29,13) = (/ &
        & 0.10044e+04_r8,0.10053e+04_r8,0.10051e+04_r8,0.10037e+04_r8,0.10011e+04_r8 /)
      kbo(:,30,13) = (/ &
        & 0.10048e+04_r8,0.10054e+04_r8,0.10048e+04_r8,0.10029e+04_r8,0.99977e+03_r8 /)
      kbo(:,31,13) = (/ &
        & 0.10050e+04_r8,0.10053e+04_r8,0.10045e+04_r8,0.10025e+04_r8,0.99968e+03_r8 /)
      kbo(:,32,13) = (/ &
        & 0.10052e+04_r8,0.10050e+04_r8,0.10041e+04_r8,0.10015e+04_r8,0.99880e+03_r8 /)
      kbo(:,33,13) = (/ &
        & 0.10053e+04_r8,0.10050e+04_r8,0.10033e+04_r8,0.10008e+04_r8,0.99675e+03_r8 /)
      kbo(:,34,13) = (/ &
        & 0.10051e+04_r8,0.10048e+04_r8,0.10028e+04_r8,0.10000e+04_r8,0.99529e+03_r8 /)
      kbo(:,35,13) = (/ &
        & 0.10054e+04_r8,0.10047e+04_r8,0.10003e+04_r8,0.99992e+03_r8,0.99481e+03_r8 /)
      kbo(:,36,13) = (/ &
        & 0.10054e+04_r8,0.10046e+04_r8,0.10017e+04_r8,0.99987e+03_r8,0.99445e+03_r8 /)
      kbo(:,37,13) = (/ &
        & 0.10054e+04_r8,0.10048e+04_r8,0.10030e+04_r8,0.99995e+03_r8,0.99517e+03_r8 /)
      kbo(:,38,13) = (/ &
        & 0.10054e+04_r8,0.10049e+04_r8,0.10034e+04_r8,0.10006e+04_r8,0.99603e+03_r8 /)
      kbo(:,39,13) = (/ &
        & 0.10053e+04_r8,0.10051e+04_r8,0.10037e+04_r8,0.10011e+04_r8,0.99693e+03_r8 /)
      kbo(:,40,13) = (/ &
        & 0.10052e+04_r8,0.10052e+04_r8,0.10041e+04_r8,0.10018e+04_r8,0.99860e+03_r8 /)
      kbo(:,41,13) = (/ &
        & 0.10048e+04_r8,0.10053e+04_r8,0.10045e+04_r8,0.10023e+04_r8,0.99951e+03_r8 /)
      kbo(:,42,13) = (/ &
        & 0.10048e+04_r8,0.10054e+04_r8,0.10046e+04_r8,0.10024e+04_r8,0.10003e+04_r8 /)
      kbo(:,43,13) = (/ &
        & 0.10043e+04_r8,0.10053e+04_r8,0.10051e+04_r8,0.10038e+04_r8,0.10013e+04_r8 /)
      kbo(:,44,13) = (/ &
        & 0.10036e+04_r8,0.10051e+04_r8,0.10053e+04_r8,0.10044e+04_r8,0.10012e+04_r8 /)
      kbo(:,45,13) = (/ &
        & 0.10028e+04_r8,0.10048e+04_r8,0.10054e+04_r8,0.10048e+04_r8,0.10031e+04_r8 /)
      kbo(:,46,13) = (/ &
        & 0.10008e+04_r8,0.10042e+04_r8,0.10053e+04_r8,0.10052e+04_r8,0.10038e+04_r8 /)
      kbo(:,47,13) = (/ &
        & 0.10002e+04_r8,0.10039e+04_r8,0.10050e+04_r8,0.10053e+04_r8,0.10045e+04_r8 /)
      kbo(:,48,13) = (/ &
        & 0.99859e+03_r8,0.10025e+04_r8,0.10043e+04_r8,0.10054e+04_r8,0.10050e+04_r8 /)
      kbo(:,49,13) = (/ &
        & 0.99776e+03_r8,0.10009e+04_r8,0.10041e+04_r8,0.10052e+04_r8,0.10053e+04_r8 /)
      kbo(:,50,13) = (/ &
        & 0.99565e+03_r8,0.99944e+03_r8,0.10034e+04_r8,0.10049e+04_r8,0.10054e+04_r8 /)
      kbo(:,51,13) = (/ &
        & 0.99271e+03_r8,0.99811e+03_r8,0.10022e+04_r8,0.10043e+04_r8,0.10053e+04_r8 /)
      kbo(:,52,13) = (/ &
        & 0.99056e+03_r8,0.99717e+03_r8,0.10006e+04_r8,0.10036e+04_r8,0.10051e+04_r8 /)
      kbo(:,53,13) = (/ &
        & 0.98830e+03_r8,0.99502e+03_r8,0.99909e+03_r8,0.10028e+04_r8,0.10048e+04_r8 /)
      kbo(:,54,13) = (/ &
        & 0.98610e+03_r8,0.99275e+03_r8,0.99821e+03_r8,0.10021e+04_r8,0.10042e+04_r8 /)
      kbo(:,55,13) = (/ &
        & 0.98386e+03_r8,0.99045e+03_r8,0.99729e+03_r8,0.10008e+04_r8,0.10038e+04_r8 /)
      kbo(:,56,13) = (/ &
        & 0.98150e+03_r8,0.98846e+03_r8,0.99517e+03_r8,0.99919e+03_r8,0.10028e+04_r8 /)
      kbo(:,57,13) = (/ &
        & 0.97902e+03_r8,0.98636e+03_r8,0.99303e+03_r8,0.99832e+03_r8,0.10022e+04_r8 /)
      kbo(:,58,13) = (/ &
        & 0.97656e+03_r8,0.98426e+03_r8,0.99079e+03_r8,0.99735e+03_r8,0.10008e+04_r8 /)
      kbo(:,59,13) = (/ &
        & 0.97503e+03_r8,0.98337e+03_r8,0.99004e+03_r8,0.99647e+03_r8,0.10002e+04_r8 /)
      kbo(:,13,14) = (/ &
        & 0.99596e+03_r8,0.10023e+04_r8,0.10047e+04_r8,0.10067e+04_r8,0.10072e+04_r8 /)
      kbo(:,14,14) = (/ &
        & 0.99625e+03_r8,0.10024e+04_r8,0.10052e+04_r8,0.10068e+04_r8,0.10071e+04_r8 /)
      kbo(:,15,14) = (/ &
        & 0.99662e+03_r8,0.10025e+04_r8,0.10054e+04_r8,0.10069e+04_r8,0.10071e+04_r8 /)
      kbo(:,16,14) = (/ &
        & 0.99703e+03_r8,0.10026e+04_r8,0.10056e+04_r8,0.10070e+04_r8,0.10070e+04_r8 /)
      kbo(:,17,14) = (/ &
        & 0.99784e+03_r8,0.10032e+04_r8,0.10054e+04_r8,0.10071e+04_r8,0.10070e+04_r8 /)
      kbo(:,18,14) = (/ &
        & 0.99947e+03_r8,0.10032e+04_r8,0.10060e+04_r8,0.10071e+04_r8,0.10069e+04_r8 /)
      kbo(:,19,14) = (/ &
        & 0.10001e+04_r8,0.10036e+04_r8,0.10062e+04_r8,0.10071e+04_r8,0.10068e+04_r8 /)
      kbo(:,20,14) = (/ &
        & 0.10009e+04_r8,0.10037e+04_r8,0.10064e+04_r8,0.10076e+04_r8,0.10067e+04_r8 /)
      kbo(:,21,14) = (/ &
        & 0.10015e+04_r8,0.10046e+04_r8,0.10065e+04_r8,0.10072e+04_r8,0.10065e+04_r8 /)
      kbo(:,22,14) = (/ &
        & 0.10023e+04_r8,0.10047e+04_r8,0.10068e+04_r8,0.10071e+04_r8,0.10063e+04_r8 /)
      kbo(:,23,14) = (/ &
        & 0.10021e+04_r8,0.10055e+04_r8,0.10069e+04_r8,0.10071e+04_r8,0.10060e+04_r8 /)
      kbo(:,24,14) = (/ &
        & 0.10028e+04_r8,0.10059e+04_r8,0.10071e+04_r8,0.10069e+04_r8,0.10057e+04_r8 /)
      kbo(:,25,14) = (/ &
        & 0.10033e+04_r8,0.10062e+04_r8,0.10068e+04_r8,0.10068e+04_r8,0.10052e+04_r8 /)
      kbo(:,26,14) = (/ &
        & 0.10043e+04_r8,0.10066e+04_r8,0.10072e+04_r8,0.10061e+04_r8,0.10047e+04_r8 /)
      kbo(:,27,14) = (/ &
        & 0.10033e+04_r8,0.10068e+04_r8,0.10071e+04_r8,0.10062e+04_r8,0.10042e+04_r8 /)
      kbo(:,28,14) = (/ &
        & 0.10057e+04_r8,0.10070e+04_r8,0.10070e+04_r8,0.10058e+04_r8,0.10036e+04_r8 /)
      kbo(:,29,14) = (/ &
        & 0.10062e+04_r8,0.10075e+04_r8,0.10068e+04_r8,0.10053e+04_r8,0.10030e+04_r8 /)
      kbo(:,30,14) = (/ &
        & 0.10065e+04_r8,0.10072e+04_r8,0.10069e+04_r8,0.10048e+04_r8,0.10022e+04_r8 /)
      kbo(:,31,14) = (/ &
        & 0.10068e+04_r8,0.10071e+04_r8,0.10062e+04_r8,0.10042e+04_r8,0.10014e+04_r8 /)
      kbo(:,32,14) = (/ &
        & 0.10070e+04_r8,0.10070e+04_r8,0.10058e+04_r8,0.10035e+04_r8,0.99925e+03_r8 /)
      kbo(:,33,14) = (/ &
        & 0.10071e+04_r8,0.10068e+04_r8,0.10053e+04_r8,0.10029e+04_r8,0.99808e+03_r8 /)
      kbo(:,34,14) = (/ &
        & 0.10072e+04_r8,0.10065e+04_r8,0.10048e+04_r8,0.10021e+04_r8,0.99788e+03_r8 /)
      kbo(:,35,14) = (/ &
        & 0.10072e+04_r8,0.10064e+04_r8,0.10045e+04_r8,0.10016e+04_r8,0.99700e+03_r8 /)
      kbo(:,36,14) = (/ &
        & 0.10072e+04_r8,0.10063e+04_r8,0.10044e+04_r8,0.10015e+04_r8,0.99731e+03_r8 /)
      kbo(:,37,14) = (/ &
        & 0.10072e+04_r8,0.10065e+04_r8,0.10047e+04_r8,0.10021e+04_r8,0.99778e+03_r8 /)
      kbo(:,38,14) = (/ &
        & 0.10072e+04_r8,0.10067e+04_r8,0.10050e+04_r8,0.10026e+04_r8,0.99820e+03_r8 /)
      kbo(:,39,14) = (/ &
        & 0.10071e+04_r8,0.10068e+04_r8,0.10053e+04_r8,0.10030e+04_r8,0.99855e+03_r8 /)
      kbo(:,40,14) = (/ &
        & 0.10070e+04_r8,0.10070e+04_r8,0.10058e+04_r8,0.10036e+04_r8,0.99965e+03_r8 /)
      kbo(:,41,14) = (/ &
        & 0.10068e+04_r8,0.10071e+04_r8,0.10062e+04_r8,0.10042e+04_r8,0.10010e+04_r8 /)
      kbo(:,42,14) = (/ &
        & 0.10065e+04_r8,0.10072e+04_r8,0.10065e+04_r8,0.10048e+04_r8,0.10022e+04_r8 /)
      kbo(:,43,14) = (/ &
        & 0.10061e+04_r8,0.10071e+04_r8,0.10069e+04_r8,0.10055e+04_r8,0.10031e+04_r8 /)
      kbo(:,44,14) = (/ &
        & 0.10054e+04_r8,0.10069e+04_r8,0.10071e+04_r8,0.10061e+04_r8,0.10039e+04_r8 /)
      kbo(:,45,14) = (/ &
        & 0.10046e+04_r8,0.10066e+04_r8,0.10072e+04_r8,0.10065e+04_r8,0.10048e+04_r8 /)
      kbo(:,46,14) = (/ &
        & 0.10023e+04_r8,0.10060e+04_r8,0.10075e+04_r8,0.10069e+04_r8,0.10055e+04_r8 /)
      kbo(:,47,14) = (/ &
        & 0.10024e+04_r8,0.10044e+04_r8,0.10068e+04_r8,0.10071e+04_r8,0.10062e+04_r8 /)
      kbo(:,48,14) = (/ &
        & 0.10006e+04_r8,0.10039e+04_r8,0.10063e+04_r8,0.10072e+04_r8,0.10067e+04_r8 /)
      kbo(:,49,14) = (/ &
        & 0.99705e+03_r8,0.10026e+04_r8,0.10052e+04_r8,0.10070e+04_r8,0.10070e+04_r8 /)
      kbo(:,50,14) = (/ &
        & 0.99574e+03_r8,0.10014e+04_r8,0.10040e+04_r8,0.10066e+04_r8,0.10072e+04_r8 /)
      kbo(:,51,14) = (/ &
        & 0.99447e+03_r8,0.99966e+03_r8,0.10033e+04_r8,0.10065e+04_r8,0.10071e+04_r8 /)
      kbo(:,52,14) = (/ &
        & 0.99299e+03_r8,0.99670e+03_r8,0.10025e+04_r8,0.10054e+04_r8,0.10069e+04_r8 /)
      kbo(:,53,14) = (/ &
        & 0.99138e+03_r8,0.99552e+03_r8,0.10013e+04_r8,0.10044e+04_r8,0.10065e+04_r8 /)
      kbo(:,54,14) = (/ &
        & 0.98979e+03_r8,0.99462e+03_r8,0.99874e+03_r8,0.10030e+04_r8,0.10060e+04_r8 /)
      kbo(:,55,14) = (/ &
        & 0.98814e+03_r8,0.99291e+03_r8,0.99630e+03_r8,0.10029e+04_r8,0.10050e+04_r8 /)
      kbo(:,56,14) = (/ &
        & 0.98639e+03_r8,0.99150e+03_r8,0.99562e+03_r8,0.10014e+04_r8,0.10045e+04_r8 /)
      kbo(:,57,14) = (/ &
        & 0.98454e+03_r8,0.98998e+03_r8,0.99438e+03_r8,0.99904e+03_r8,0.10032e+04_r8 /)
      kbo(:,58,14) = (/ &
        & 0.98268e+03_r8,0.98844e+03_r8,0.99315e+03_r8,0.99688e+03_r8,0.10025e+04_r8 /)
      kbo(:,59,14) = (/ &
        & 0.98190e+03_r8,0.98779e+03_r8,0.99262e+03_r8,0.99638e+03_r8,0.10024e+04_r8 /)
      kbo(:,13,15) = (/ &
        & 0.99739e+03_r8,0.10017e+04_r8,0.10064e+04_r8,0.10076e+04_r8,0.10080e+04_r8 /)
      kbo(:,14,15) = (/ &
        & 0.99781e+03_r8,0.10021e+04_r8,0.10065e+04_r8,0.10077e+04_r8,0.10090e+04_r8 /)
      kbo(:,15,15) = (/ &
        & 0.99827e+03_r8,0.10029e+04_r8,0.10067e+04_r8,0.10077e+04_r8,0.10079e+04_r8 /)
      kbo(:,16,15) = (/ &
        & 0.99875e+03_r8,0.10040e+04_r8,0.10068e+04_r8,0.10078e+04_r8,0.10089e+04_r8 /)
      kbo(:,17,15) = (/ &
        & 0.99816e+03_r8,0.10041e+04_r8,0.10080e+04_r8,0.10079e+04_r8,0.10078e+04_r8 /)
      kbo(:,18,15) = (/ &
        & 0.99861e+03_r8,0.10065e+04_r8,0.10071e+04_r8,0.10090e+04_r8,0.10078e+04_r8 /)
      kbo(:,19,15) = (/ &
        & 0.10001e+04_r8,0.10056e+04_r8,0.10072e+04_r8,0.10079e+04_r8,0.10077e+04_r8 /)
      kbo(:,20,15) = (/ &
        & 0.99952e+03_r8,0.10059e+04_r8,0.10074e+04_r8,0.10090e+04_r8,0.10087e+04_r8 /)
      kbo(:,21,15) = (/ &
        & 0.10000e+04_r8,0.10061e+04_r8,0.10085e+04_r8,0.10080e+04_r8,0.10085e+04_r8 /)
      kbo(:,22,15) = (/ &
        & 0.10012e+04_r8,0.10064e+04_r8,0.10076e+04_r8,0.10090e+04_r8,0.10073e+04_r8 /)
      kbo(:,23,15) = (/ &
        & 0.10032e+04_r8,0.10067e+04_r8,0.10088e+04_r8,0.10079e+04_r8,0.10070e+04_r8 /)
      kbo(:,24,15) = (/ &
        & 0.10052e+04_r8,0.10070e+04_r8,0.10079e+04_r8,0.10089e+04_r8,0.10067e+04_r8 /)
      kbo(:,25,15) = (/ &
        & 0.10057e+04_r8,0.10083e+04_r8,0.10079e+04_r8,0.10098e+04_r8,0.10062e+04_r8 /)
      kbo(:,26,15) = (/ &
        & 0.10061e+04_r8,0.10085e+04_r8,0.10080e+04_r8,0.10075e+04_r8,0.10068e+04_r8 /)
      kbo(:,27,15) = (/ &
        & 0.10066e+04_r8,0.10087e+04_r8,0.10111e+04_r8,0.10072e+04_r8,0.10051e+04_r8 /)
      kbo(:,28,15) = (/ &
        & 0.10069e+04_r8,0.10089e+04_r8,0.10079e+04_r8,0.10068e+04_r8,0.10054e+04_r8 /)
      kbo(:,29,15) = (/ &
        & 0.10072e+04_r8,0.10069e+04_r8,0.10077e+04_r8,0.10063e+04_r8,0.10034e+04_r8 /)
      kbo(:,30,15) = (/ &
        & 0.10075e+04_r8,0.10111e+04_r8,0.10075e+04_r8,0.10068e+04_r8,0.10088e+04_r8 /)
      kbo(:,31,15) = (/ &
        & 0.10077e+04_r8,0.10080e+04_r8,0.10072e+04_r8,0.10061e+04_r8,0.10007e+04_r8 /)
      kbo(:,32,15) = (/ &
        & 0.10078e+04_r8,0.10089e+04_r8,0.10068e+04_r8,0.10043e+04_r8,0.10013e+04_r8 /)
      kbo(:,33,15) = (/ &
        & 0.10079e+04_r8,0.10077e+04_r8,0.10063e+04_r8,0.10044e+04_r8,0.10009e+04_r8 /)
      kbo(:,34,15) = (/ &
        & 0.10090e+04_r8,0.10075e+04_r8,0.10058e+04_r8,0.10025e+04_r8,0.10002e+04_r8 /)
      kbo(:,35,15) = (/ &
        & 0.10080e+04_r8,0.10073e+04_r8,0.10054e+04_r8,0.10021e+04_r8,0.99972e+03_r8 /)
      kbo(:,36,15) = (/ &
        & 0.10090e+04_r8,0.10073e+04_r8,0.10054e+04_r8,0.10020e+04_r8,0.99964e+03_r8 /)
      kbo(:,37,15) = (/ &
        & 0.10080e+04_r8,0.10075e+04_r8,0.10057e+04_r8,0.10024e+04_r8,0.10001e+04_r8 /)
      kbo(:,38,15) = (/ &
        & 0.10090e+04_r8,0.10076e+04_r8,0.10060e+04_r8,0.10040e+04_r8,0.10006e+04_r8 /)
      kbo(:,39,15) = (/ &
        & 0.10079e+04_r8,0.10077e+04_r8,0.10063e+04_r8,0.10034e+04_r8,0.10010e+04_r8 /)
      kbo(:,40,15) = (/ &
        & 0.10089e+04_r8,0.10089e+04_r8,0.10068e+04_r8,0.10054e+04_r8,0.10014e+04_r8 /)
      kbo(:,41,15) = (/ &
        & 0.10087e+04_r8,0.10090e+04_r8,0.10082e+04_r8,0.10051e+04_r8,0.10018e+04_r8 /)
      kbo(:,42,15) = (/ &
        & 0.10085e+04_r8,0.10090e+04_r8,0.10075e+04_r8,0.10058e+04_r8,0.10025e+04_r8 /)
      kbo(:,43,15) = (/ &
        & 0.10071e+04_r8,0.10079e+04_r8,0.10078e+04_r8,0.10086e+04_r8,0.10037e+04_r8 /)
      kbo(:,44,15) = (/ &
        & 0.10067e+04_r8,0.10088e+04_r8,0.10079e+04_r8,0.10071e+04_r8,0.10048e+04_r8 /)
      kbo(:,45,15) = (/ &
        & 0.10061e+04_r8,0.10075e+04_r8,0.10090e+04_r8,0.10096e+04_r8,0.10057e+04_r8 /)
      kbo(:,46,15) = (/ &
        & 0.10054e+04_r8,0.10071e+04_r8,0.10068e+04_r8,0.10078e+04_r8,0.10065e+04_r8 /)
      kbo(:,47,15) = (/ &
        & 0.10020e+04_r8,0.10065e+04_r8,0.10087e+04_r8,0.10079e+04_r8,0.10093e+04_r8 /)
      kbo(:,48,15) = (/ &
        & 0.99938e+03_r8,0.10058e+04_r8,0.10073e+04_r8,0.10079e+04_r8,0.10087e+04_r8 /)
      kbo(:,49,15) = (/ &
        & 0.99869e+03_r8,0.10038e+04_r8,0.10079e+04_r8,0.10099e+04_r8,0.10089e+04_r8 /)
      kbo(:,50,15) = (/ &
        & 0.99593e+03_r8,0.10003e+04_r8,0.10062e+04_r8,0.10075e+04_r8,0.10090e+04_r8 /)
      kbo(:,51,15) = (/ &
        & 0.99417e+03_r8,0.99877e+03_r8,0.10055e+04_r8,0.10061e+04_r8,0.10090e+04_r8 /)
      kbo(:,52,15) = (/ &
        & 0.99334e+03_r8,0.99717e+03_r8,0.10030e+04_r8,0.10077e+04_r8,0.10077e+04_r8 /)
      kbo(:,53,15) = (/ &
        & 0.99034e+03_r8,0.99548e+03_r8,0.99989e+03_r8,0.10071e+04_r8,0.10085e+04_r8 /)
      kbo(:,54,15) = (/ &
        & 0.98844e+03_r8,0.99385e+03_r8,0.99849e+03_r8,0.10064e+04_r8,0.10081e+04_r8 /)
      kbo(:,55,15) = (/ &
        & 0.98654e+03_r8,0.99323e+03_r8,0.99708e+03_r8,0.10005e+04_r8,0.10066e+04_r8 /)
      kbo(:,56,15) = (/ &
        & 0.98558e+03_r8,0.99048e+03_r8,0.99560e+03_r8,0.99999e+03_r8,0.10071e+04_r8 /)
      kbo(:,57,15) = (/ &
        & 0.98349e+03_r8,0.98867e+03_r8,0.99404e+03_r8,0.99866e+03_r8,0.10054e+04_r8 /)
      kbo(:,58,15) = (/ &
        & 0.98039e+03_r8,0.98688e+03_r8,0.99250e+03_r8,0.99837e+03_r8,0.10028e+04_r8 /)
      kbo(:,59,15) = (/ &
        & 0.97954e+03_r8,0.98614e+03_r8,0.99186e+03_r8,0.99679e+03_r8,0.10019e+04_r8 /)
      kbo(:,13,16) = (/ &
        & 0.98905e+03_r8,0.99319e+03_r8,0.10065e+04_r8,0.10075e+04_r8,0.10080e+04_r8 /)
      kbo(:,14,16) = (/ &
        & 0.98947e+03_r8,0.10009e+04_r8,0.10067e+04_r8,0.10076e+04_r8,0.10005e+04_r8 /)
      kbo(:,15,16) = (/ &
        & 0.98993e+03_r8,0.10052e+04_r8,0.10068e+04_r8,0.10076e+04_r8,0.10080e+04_r8 /)
      kbo(:,16,16) = (/ &
        & 0.99040e+03_r8,0.10054e+04_r8,0.10069e+04_r8,0.10077e+04_r8,0.10005e+04_r8 /)
      kbo(:,17,16) = (/ &
        & 0.99823e+03_r8,0.10056e+04_r8,0.99955e+03_r8,0.10078e+04_r8,0.10080e+04_r8 /)
      kbo(:,18,16) = (/ &
        & 0.99867e+03_r8,0.99832e+03_r8,0.10071e+04_r8,0.10003e+04_r8,0.10079e+04_r8 /)
      kbo(:,19,16) = (/ &
        & 0.99168e+03_r8,0.10059e+04_r8,0.10072e+04_r8,0.10078e+04_r8,0.10079e+04_r8 /)
      kbo(:,20,16) = (/ &
        & 0.99955e+03_r8,0.10061e+04_r8,0.10073e+04_r8,0.99297e+03_r8,0.10003e+04_r8 /)
      kbo(:,21,16) = (/ &
        & 0.10000e+04_r8,0.10063e+04_r8,0.99994e+03_r8,0.10079e+04_r8,0.10002e+04_r8 /)
      kbo(:,22,16) = (/ &
        & 0.10007e+04_r8,0.10066e+04_r8,0.10075e+04_r8,0.10005e+04_r8,0.10075e+04_r8 /)
      kbo(:,23,16) = (/ &
        & 0.10052e+04_r8,0.10068e+04_r8,0.10002e+04_r8,0.10080e+04_r8,0.10072e+04_r8 /)
      kbo(:,24,16) = (/ &
        & 0.10056e+04_r8,0.10070e+04_r8,0.10078e+04_r8,0.10005e+04_r8,0.10068e+04_r8 /)
      kbo(:,25,16) = (/ &
        & 0.10060e+04_r8,0.99977e+03_r8,0.10079e+04_r8,0.99294e+03_r8,0.10064e+04_r8 /)
      kbo(:,26,16) = (/ &
        & 0.10064e+04_r8,0.99996e+03_r8,0.10080e+04_r8,0.10077e+04_r8,0.99839e+03_r8 /)
      kbo(:,27,16) = (/ &
        & 0.10067e+04_r8,0.10001e+04_r8,0.98561e+03_r8,0.10074e+04_r8,0.10052e+04_r8 /)
      kbo(:,28,16) = (/ &
        & 0.10069e+04_r8,0.10003e+04_r8,0.10080e+04_r8,0.10070e+04_r8,0.99700e+03_r8 /)
      kbo(:,29,16) = (/ &
        & 0.10072e+04_r8,0.10078e+04_r8,0.10079e+04_r8,0.10065e+04_r8,0.10036e+04_r8 /)
      kbo(:,30,16) = (/ &
        & 0.10074e+04_r8,0.98555e+03_r8,0.10002e+04_r8,0.99845e+03_r8,0.95900e+03_r8 /)
      kbo(:,31,16) = (/ &
        & 0.10076e+04_r8,0.10080e+04_r8,0.10074e+04_r8,0.99776e+03_r8,0.10037e+04_r8 /)
      kbo(:,32,16) = (/ &
        & 0.10077e+04_r8,0.10005e+04_r8,0.10070e+04_r8,0.10044e+04_r8,0.10038e+04_r8 /)
      kbo(:,33,16) = (/ &
        & 0.10079e+04_r8,0.10079e+04_r8,0.10064e+04_r8,0.99602e+03_r8,0.10038e+04_r8 /)
      kbo(:,34,16) = (/ &
        & 0.10005e+04_r8,0.10077e+04_r8,0.10059e+04_r8,0.10036e+04_r8,0.10037e+04_r8 /)
      kbo(:,35,16) = (/ &
        & 0.10080e+04_r8,0.10075e+04_r8,0.10055e+04_r8,0.10037e+04_r8,0.10036e+04_r8 /)
      kbo(:,36,16) = (/ &
        & 0.10005e+04_r8,0.10075e+04_r8,0.10055e+04_r8,0.10037e+04_r8,0.10036e+04_r8 /)
      kbo(:,37,16) = (/ &
        & 0.10080e+04_r8,0.10077e+04_r8,0.10058e+04_r8,0.10037e+04_r8,0.10037e+04_r8 /)
      kbo(:,38,16) = (/ &
        & 0.10004e+04_r8,0.10078e+04_r8,0.10062e+04_r8,0.99569e+03_r8,0.10037e+04_r8 /)
      kbo(:,39,16) = (/ &
        & 0.10078e+04_r8,0.10079e+04_r8,0.10065e+04_r8,0.10036e+04_r8,0.10038e+04_r8 /)
      kbo(:,40,16) = (/ &
        & 0.10003e+04_r8,0.10005e+04_r8,0.10070e+04_r8,0.99698e+03_r8,0.10038e+04_r8 /)
      kbo(:,41,16) = (/ &
        & 0.10001e+04_r8,0.10005e+04_r8,0.99992e+03_r8,0.10052e+04_r8,0.10037e+04_r8 /)
      kbo(:,42,16) = (/ &
        & 0.99994e+03_r8,0.10005e+04_r8,0.10077e+04_r8,0.10059e+04_r8,0.10036e+04_r8 /)
      kbo(:,43,16) = (/ &
        & 0.10071e+04_r8,0.10078e+04_r8,0.10079e+04_r8,0.99172e+03_r8,0.10038e+04_r8 /)
      kbo(:,44,16) = (/ &
        & 0.10068e+04_r8,0.10002e+04_r8,0.10080e+04_r8,0.10072e+04_r8,0.10049e+04_r8 /)
      kbo(:,45,16) = (/ &
        & 0.10063e+04_r8,0.10074e+04_r8,0.10005e+04_r8,0.99276e+03_r8,0.10059e+04_r8 /)
      kbo(:,46,16) = (/ &
        & 0.10057e+04_r8,0.10071e+04_r8,0.10078e+04_r8,0.10079e+04_r8,0.10067e+04_r8 /)
      kbo(:,47,16) = (/ &
        & 0.10009e+04_r8,0.10067e+04_r8,0.10001e+04_r8,0.10080e+04_r8,0.99247e+03_r8 /)
      kbo(:,48,16) = (/ &
        & 0.99941e+03_r8,0.10061e+04_r8,0.10073e+04_r8,0.10079e+04_r8,0.10004e+04_r8 /)
      kbo(:,49,16) = (/ &
        & 0.99034e+03_r8,0.10054e+04_r8,0.99943e+03_r8,0.99276e+03_r8,0.10005e+04_r8 /)
      kbo(:,50,16) = (/ &
        & 0.99601e+03_r8,0.10003e+04_r8,0.10064e+04_r8,0.10074e+04_r8,0.10005e+04_r8 /)
      kbo(:,51,16) = (/ &
        & 0.99422e+03_r8,0.99882e+03_r8,0.10058e+04_r8,0.10071e+04_r8,0.10003e+04_r8 /)
      kbo(:,52,16) = (/ &
        & 0.98496e+03_r8,0.99726e+03_r8,0.10013e+04_r8,0.99930e+03_r8,0.10076e+04_r8 /)
      kbo(:,53,16) = (/ &
        & 0.99030e+03_r8,0.99555e+03_r8,0.99990e+03_r8,0.99882e+03_r8,0.99991e+03_r8 /)
      kbo(:,54,16) = (/ &
        & 0.98836e+03_r8,0.98653e+03_r8,0.99856e+03_r8,0.99827e+03_r8,0.99962e+03_r8 /)
      kbo(:,55,16) = (/ &
        & 0.98643e+03_r8,0.98485e+03_r8,0.99716e+03_r8,0.10012e+04_r8,0.10067e+04_r8 /)
      kbo(:,56,16) = (/ &
        & 0.97714e+03_r8,0.99044e+03_r8,0.99567e+03_r8,0.99999e+03_r8,0.99885e+03_r8 /)
      kbo(:,57,16) = (/ &
        & 0.97511e+03_r8,0.98860e+03_r8,0.99409e+03_r8,0.99872e+03_r8,0.10058e+04_r8 /)
      kbo(:,58,16) = (/ &
        & 0.98036e+03_r8,0.98678e+03_r8,0.99251e+03_r8,0.99003e+03_r8,0.10052e+04_r8 /)
      kbo(:,59,16) = (/ &
        & 0.97953e+03_r8,0.98603e+03_r8,0.99185e+03_r8,0.99687e+03_r8,0.10009e+04_r8 /)
     
      end subroutine sw_kgb27

! **************************************************************************
