!     path:      $Source: /storm/rc1/cvsroot/rc/rrtmg_sw/src/rrtmg_sw_k_g.f90,v $
!     author:    $Author: mike $
!     revision:  $Revision: 1.2 $
!     created:   $Date: 2007/08/23 20:40:13 $

!  --------------------------------------------------------------------------
! |                                                                          |
! |  Copyright 2002-2007, Atmospheric & Environmental Research, Inc. (AER).  |
! |  This software may be used, copied, or redistributed as long as it is    |
! |  not sold and this copyright notice is reproduced on each copy made.     |
! |  This model is provided as is without any express or implied warranties. |
! |                       (http://www.rtweb.aer.com/)                        |
! |                                                                          |
!  --------------------------------------------------------------------------

! **************************************************************************
!      subroutine sw_kgbnn
! **************************************************************************
!  RRTM Shortwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original by J.Delamere, Atmospheric & Environmental Research.
!  Reformatted for F90: JJMorcrette, ECMWF
!  Further F90 and GCM revisions:  MJIacono, AER, July 2002
!
!  This file contains 14 subroutines that include the 
!  absorption coefficients and other data for each of the 14 shortwave
!  spectral bands used in RRTM_SW.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_SW_INIT to reduce
!  the total number of g-points from 224 to 112 for use in the GCM.
! **************************************************************************
! **************************************************************************
      subroutine sw_kgb25
! **************************************************************************

      use shr_kind_mod, only: r8 => shr_kind_r8

!      use parkind, only : jpim, jprb 
      use rrsw_kg25, only : kao, sfluxrefo, &
                            raylo, abso3ao, abso3bo, layreffr

      implicit none
      save

! Kurucz solar source function
      sfluxrefo(:) = (/ &
        & 42.6858_r8 , 45.7720_r8, 44.9872_r8, 45.9662_r8    , &
        & 46.5458_r8 , 41.6926_r8, 32.2893_r8, 24.0928_r8    , &
        & 16.7686_r8 , 1.86048_r8, 1.54057_r8, 1.23503_r8    , &
        & 0.915085_r8,0.590099_r8,0.218622_r8, 3.21287e-02_r8 /)

! Rayleigh extinction coefficient at v = 2925 cm-1.
      raylo(:) = (/ &
        & 9.81132e-07_r8,8.25605e-07_r8,6.71302e-07_r8,5.53556e-07_r8, & 
        & 3.97383e-07_r8,3.68206e-07_r8,4.42379e-07_r8,4.57799e-07_r8, &
        & 4.22683e-07_r8,3.87113e-07_r8,3.79810e-07_r8,3.63192e-07_r8, &
        & 3.51921e-07_r8,3.34231e-07_r8,3.34294e-07_r8,3.32673e-07_r8 /)
     
      abso3ao(:) = (/ &
        & 2.32664e-02_r8,5.76154e-02_r8,0.125389_r8,0.250158_r8, &
        & 0.378756_r8   ,0.402196_r8   ,0.352026_r8,0.352036_r8, &
        & 0.386253_r8   ,0.414598_r8   ,0.420079_r8,0.435471_r8, &
        & 0.445487_r8   ,0.459549_r8   ,0.452920_r8,0.456838_r8 /)

      abso3bo(:) = (/ &     
        & 1.76917e-02_r8,4.64185e-02_r8,1.03640e-01_r8,0.189469_r8, &
        & 0.303858_r8   ,0.400248_r8   ,0.447357_r8   ,0.470009_r8, &
        & 0.498673_r8   ,0.515696_r8   ,0.517053_r8   ,0.517930_r8, &
        & 0.518345_r8   ,0.524952_r8   ,0.508244_r8   ,0.468981_r8 /)

     layreffr = 2

!     ------------------------------------------------------------------
!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kao(:, 1, 1) = (/ &
        & 0.16461e-08_r8,0.16782e-08_r8,0.19339e-08_r8,0.17100e-08_r8,0.17045e-08_r8 /)
      kao(:, 2, 1) = (/ &
        & 0.28759e-08_r8,0.29469e-08_r8,0.33789e-08_r8,0.34357e-08_r8,0.28833e-08_r8 /)
      kao(:, 3, 1) = (/ &
        & 0.55148e-08_r8,0.54808e-08_r8,0.54190e-08_r8,0.68260e-08_r8,0.51972e-08_r8 /)
      kao(:, 4, 1) = (/ &
        & 0.95336e-08_r8,0.94552e-08_r8,0.93001e-08_r8,0.90961e-08_r8,0.14451e-07_r8 /)
      kao(:, 5, 1) = (/ &
        & 0.14930e-07_r8,0.14736e-07_r8,0.14432e-07_r8,0.14074e-07_r8,0.24102e-07_r8 /)
      kao(:, 6, 1) = (/ &
        & 0.22770e-07_r8,0.22301e-07_r8,0.21778e-07_r8,0.21194e-07_r8,0.20569e-07_r8 /)
      kao(:, 7, 1) = (/ &
        & 0.34699e-07_r8,0.33951e-07_r8,0.33124e-07_r8,0.32144e-07_r8,0.31220e-07_r8 /)
      kao(:, 8, 1) = (/ &
        & 0.62339e-07_r8,0.60405e-07_r8,0.59548e-07_r8,0.58214e-07_r8,0.56977e-07_r8 /)
      kao(:, 9, 1) = (/ &
        & 0.17411e-06_r8,0.17654e-06_r8,0.18315e-06_r8,0.18100e-06_r8,0.17839e-06_r8 /)
      kao(:,10, 1) = (/ &
        & 0.23526e-06_r8,0.22729e-06_r8,0.21947e-06_r8,0.21188e-06_r8,0.20454e-06_r8 /)
      kao(:,11, 1) = (/ &
        & 0.23535e-06_r8,0.22737e-06_r8,0.21956e-06_r8,0.21196e-06_r8,0.20461e-06_r8 /)
      kao(:,12, 1) = (/ &
        & 0.23539e-06_r8,0.22740e-06_r8,0.21959e-06_r8,0.21199e-06_r8,0.20465e-06_r8 /)
      kao(:,13, 1) = (/ &
        & 0.23543e-06_r8,0.22744e-06_r8,0.21962e-06_r8,0.21202e-06_r8,0.20467e-06_r8 /)
      kao(:, 1, 2) = (/ &
        & 0.62912e-08_r8,0.61559e-08_r8,0.84640e-08_r8,0.59240e-08_r8,0.58217e-08_r8 /)
      kao(:, 2, 2) = (/ &
        & 0.83749e-08_r8,0.80756e-08_r8,0.11623e-07_r8,0.11272e-07_r8,0.73636e-08_r8 /)
      kao(:, 3, 2) = (/ &
        & 0.13304e-07_r8,0.12795e-07_r8,0.12343e-07_r8,0.21235e-07_r8,0.11577e-07_r8 /)
      kao(:, 4, 2) = (/ &
        & 0.20704e-07_r8,0.19736e-07_r8,0.18900e-07_r8,0.18228e-07_r8,0.31601e-07_r8 /)
      kao(:, 5, 2) = (/ &
        & 0.31149e-07_r8,0.29669e-07_r8,0.28318e-07_r8,0.27101e-07_r8,0.49649e-07_r8 /)
      kao(:, 6, 2) = (/ &
        & 0.45713e-07_r8,0.43519e-07_r8,0.41488e-07_r8,0.39918e-07_r8,0.38291e-07_r8 /)
      kao(:, 7, 2) = (/ &
        & 0.77265e-07_r8,0.73848e-07_r8,0.70437e-07_r8,0.67945e-07_r8,0.66127e-07_r8 /)
      kao(:, 8, 2) = (/ &
        & 0.15754e-06_r8,0.15664e-06_r8,0.15378e-06_r8,0.15027e-06_r8,0.14633e-06_r8 /)
      kao(:, 9, 2) = (/ &
        & 0.16439e-06_r8,0.14678e-06_r8,0.12610e-06_r8,0.11532e-06_r8,0.10591e-06_r8 /)
      kao(:,10, 2) = (/ &
        & 0.14366e-06_r8,0.13506e-06_r8,0.12583e-06_r8,0.11774e-06_r8,0.11011e-06_r8 /)
      kao(:,11, 2) = (/ &
        & 0.14521e-06_r8,0.13766e-06_r8,0.13072e-06_r8,0.12218e-06_r8,0.11400e-06_r8 /)
      kao(:,12, 2) = (/ &
        & 0.14524e-06_r8,0.13769e-06_r8,0.13074e-06_r8,0.12241e-06_r8,0.11552e-06_r8 /)
      kao(:,13, 2) = (/ &
        & 0.14525e-06_r8,0.13770e-06_r8,0.13075e-06_r8,0.12252e-06_r8,0.11553e-06_r8 /)
      kao(:, 1, 3) = (/ &
        & 0.14060e-07_r8,0.13587e-07_r8,0.24644e-07_r8,0.12716e-07_r8,0.12367e-07_r8 /)
      kao(:, 2, 3) = (/ &
        & 0.17055e-07_r8,0.16577e-07_r8,0.32443e-07_r8,0.31273e-07_r8,0.15381e-07_r8 /)
      kao(:, 3, 3) = (/ &
        & 0.25414e-07_r8,0.24672e-07_r8,0.23874e-07_r8,0.47281e-07_r8,0.22346e-07_r8 /)
      kao(:, 4, 3) = (/ &
        & 0.39536e-07_r8,0.38124e-07_r8,0.36836e-07_r8,0.35587e-07_r8,0.72260e-07_r8 /)
      kao(:, 5, 3) = (/ &
        & 0.59488e-07_r8,0.57630e-07_r8,0.55623e-07_r8,0.53878e-07_r8,0.11230e-06_r8 /)
      kao(:, 6, 3) = (/ &
        & 0.99996e-07_r8,0.96206e-07_r8,0.93184e-07_r8,0.90812e-07_r8,0.89206e-07_r8 /)
      kao(:, 7, 3) = (/ &
        & 0.17678e-06_r8,0.17554e-06_r8,0.17358e-06_r8,0.17091e-06_r8,0.16830e-06_r8 /)
      kao(:, 8, 3) = (/ &
        & 0.18672e-06_r8,0.17850e-06_r8,0.16967e-06_r8,0.16275e-06_r8,0.15875e-06_r8 /)
      kao(:, 9, 3) = (/ &
        & 0.13558e-06_r8,0.13493e-06_r8,0.13633e-06_r8,0.13799e-06_r8,0.13932e-06_r8 /)
      kao(:,10, 3) = (/ &
        & 0.18883e-06_r8,0.20452e-06_r8,0.22206e-06_r8,0.24347e-06_r8,0.26091e-06_r8 /)
      kao(:,11, 3) = (/ &
        & 0.21296e-06_r8,0.23580e-06_r8,0.26439e-06_r8,0.30148e-06_r8,0.34942e-06_r8 /)
      kao(:,12, 3) = (/ &
        & 0.22072e-06_r8,0.25535e-06_r8,0.28661e-06_r8,0.34814e-06_r8,0.39337e-06_r8 /)
      kao(:,13, 3) = (/ &
        & 0.22515e-06_r8,0.26161e-06_r8,0.30833e-06_r8,0.36527e-06_r8,0.40123e-06_r8 /)
      kao(:, 1, 4) = (/ &
        & 0.32735e-07_r8,0.31345e-07_r8,0.58846e-07_r8,0.28258e-07_r8,0.27022e-07_r8 /)
      kao(:, 2, 4) = (/ &
        & 0.37754e-07_r8,0.36873e-07_r8,0.82776e-07_r8,0.80947e-07_r8,0.35190e-07_r8 /)
      kao(:, 3, 4) = (/ &
        & 0.76368e-07_r8,0.75292e-07_r8,0.74075e-07_r8,0.10820e-06_r8,0.73183e-07_r8 /)
      kao(:, 4, 4) = (/ &
        & 0.16392e-06_r8,0.16130e-06_r8,0.15926e-06_r8,0.15700e-06_r8,0.22041e-06_r8 /)
      kao(:, 5, 4) = (/ &
        & 0.29704e-06_r8,0.28924e-06_r8,0.28301e-06_r8,0.27633e-06_r8,0.42284e-06_r8 /)
      kao(:, 6, 4) = (/ &
        & 0.48466e-06_r8,0.47240e-06_r8,0.46143e-06_r8,0.45012e-06_r8,0.43867e-06_r8 /)
      kao(:, 7, 4) = (/ &
        & 0.71637e-06_r8,0.69847e-06_r8,0.67384e-06_r8,0.65368e-06_r8,0.63375e-06_r8 /)
      kao(:, 8, 4) = (/ &
        & 0.11904e-05_r8,0.11714e-05_r8,0.11524e-05_r8,0.11354e-05_r8,0.11172e-05_r8 /)
      kao(:, 9, 4) = (/ &
        & 0.21976e-05_r8,0.21606e-05_r8,0.21332e-05_r8,0.20944e-05_r8,0.20536e-05_r8 /)
      kao(:,10, 4) = (/ &
        & 0.21713e-05_r8,0.21144e-05_r8,0.20553e-05_r8,0.19901e-05_r8,0.19286e-05_r8 /)
      kao(:,11, 4) = (/ &
        & 0.21443e-05_r8,0.20785e-05_r8,0.20048e-05_r8,0.19232e-05_r8,0.18295e-05_r8 /)
      kao(:,12, 4) = (/ &
        & 0.21363e-05_r8,0.20578e-05_r8,0.19811e-05_r8,0.18729e-05_r8,0.17807e-05_r8 /)
      kao(:,13, 4) = (/ &
        & 0.21319e-05_r8,0.20513e-05_r8,0.19580e-05_r8,0.18546e-05_r8,0.17725e-05_r8 /)
      kao(:, 1, 5) = (/ &
        & 0.36050e-07_r8,0.36125e-07_r8,0.46253e-07_r8,0.37280e-07_r8,0.37359e-07_r8 /)
      kao(:, 2, 5) = (/ &
        & 0.65102e-07_r8,0.64266e-07_r8,0.68896e-07_r8,0.65925e-07_r8,0.61190e-07_r8 /)
      kao(:, 3, 5) = (/ &
        & 0.12173e-06_r8,0.11889e-06_r8,0.11625e-06_r8,0.17574e-06_r8,0.10921e-06_r8 /)
      kao(:, 4, 5) = (/ &
        & 0.20555e-06_r8,0.19853e-06_r8,0.19068e-06_r8,0.18313e-06_r8,0.30241e-06_r8 /)
      kao(:, 5, 5) = (/ &
        & 0.30900e-06_r8,0.29996e-06_r8,0.28857e-06_r8,0.27772e-06_r8,0.51631e-06_r8 /)
      kao(:, 6, 5) = (/ &
        & 0.43774e-06_r8,0.42465e-06_r8,0.40920e-06_r8,0.39315e-06_r8,0.37901e-06_r8 /)
      kao(:, 7, 5) = (/ &
        & 0.63869e-06_r8,0.61654e-06_r8,0.60324e-06_r8,0.58966e-06_r8,0.57948e-06_r8 /)
      kao(:, 8, 5) = (/ &
        & 0.98362e-06_r8,0.96271e-06_r8,0.94180e-06_r8,0.92206e-06_r8,0.91105e-06_r8 /)
      kao(:, 9, 5) = (/ &
        & 0.12061e-05_r8,0.11895e-05_r8,0.11564e-05_r8,0.11296e-05_r8,0.11110e-05_r8 /)
      kao(:,10, 5) = (/ &
        & 0.12958e-05_r8,0.12694e-05_r8,0.12425e-05_r8,0.12153e-05_r8,0.11880e-05_r8 /)
      kao(:,11, 5) = (/ &
        & 0.12962e-05_r8,0.12698e-05_r8,0.12429e-05_r8,0.12156e-05_r8,0.11883e-05_r8 /)
      kao(:,12, 5) = (/ &
        & 0.12964e-05_r8,0.12701e-05_r8,0.12431e-05_r8,0.12158e-05_r8,0.11885e-05_r8 /)
      kao(:,13, 5) = (/ &
        & 0.12966e-05_r8,0.12702e-05_r8,0.12433e-05_r8,0.12160e-05_r8,0.11886e-05_r8 /)
      kao(:, 1, 6) = (/ &
        & 0.73925e-07_r8,0.70231e-07_r8,0.21454e-06_r8,0.63477e-07_r8,0.60912e-07_r8 /)
      kao(:, 2, 6) = (/ &
        & 0.67794e-07_r8,0.65807e-07_r8,0.13854e-06_r8,0.13061e-06_r8,0.59361e-07_r8 /)
      kao(:, 3, 6) = (/ &
        & 0.98353e-07_r8,0.95275e-07_r8,0.92426e-07_r8,0.15768e-06_r8,0.87986e-07_r8 /)
      kao(:, 4, 6) = (/ &
        & 0.15855e-06_r8,0.15394e-06_r8,0.14948e-06_r8,0.14655e-06_r8,0.23172e-06_r8 /)
      kao(:, 5, 6) = (/ &
        & 0.27764e-06_r8,0.26941e-06_r8,0.26299e-06_r8,0.25975e-06_r8,0.40526e-06_r8 /)
      kao(:, 6, 6) = (/ &
        & 0.45469e-06_r8,0.44417e-06_r8,0.43276e-06_r8,0.42440e-06_r8,0.41489e-06_r8 /)
      kao(:, 7, 6) = (/ &
        & 0.71540e-06_r8,0.71291e-06_r8,0.70656e-06_r8,0.69823e-06_r8,0.68342e-06_r8 /)
      kao(:, 8, 6) = (/ &
        & 0.79651e-06_r8,0.79807e-06_r8,0.80621e-06_r8,0.80941e-06_r8,0.79835e-06_r8 /)
      kao(:, 9, 6) = (/ &
        & 0.18716e-06_r8,0.16713e-06_r8,0.14725e-06_r8,0.13728e-06_r8,0.11763e-06_r8 /)
      kao(:,10, 6) = (/ &
        & 0.92638e-07_r8,0.86207e-07_r8,0.80877e-07_r8,0.70432e-07_r8,0.64517e-07_r8 /)
      kao(:,11, 6) = (/ &
        & 0.13396e-06_r8,0.12820e-06_r8,0.12387e-06_r8,0.10427e-06_r8,0.94091e-07_r8 /)
      kao(:,12, 6) = (/ &
        & 0.14877e-06_r8,0.14827e-06_r8,0.14350e-06_r8,0.12154e-06_r8,0.10552e-06_r8 /)
      kao(:,13, 6) = (/ &
        & 0.15437e-06_r8,0.15323e-06_r8,0.14992e-06_r8,0.12715e-06_r8,0.10933e-06_r8 /)
      kao(:, 1, 7) = (/ &
        & 0.72717e-06_r8,0.70656e-06_r8,0.13933e-05_r8,0.66449e-06_r8,0.64269e-06_r8 /)
      kao(:, 2, 7) = (/ &
        & 0.52595e-06_r8,0.50791e-06_r8,0.11171e-05_r8,0.10538e-05_r8,0.45644e-06_r8 /)
      kao(:, 3, 7) = (/ &
        & 0.29919e-06_r8,0.29227e-06_r8,0.28284e-06_r8,0.65215e-06_r8,0.26347e-06_r8 /)
      kao(:, 4, 7) = (/ &
        & 0.27961e-06_r8,0.27579e-06_r8,0.27068e-06_r8,0.26343e-06_r8,0.41265e-06_r8 /)
      kao(:, 5, 7) = (/ &
        & 0.37031e-06_r8,0.36318e-06_r8,0.35475e-06_r8,0.34488e-06_r8,0.53740e-06_r8 /)
      kao(:, 6, 7) = (/ &
        & 0.53195e-06_r8,0.52692e-06_r8,0.52224e-06_r8,0.51934e-06_r8,0.51146e-06_r8 /)
      kao(:, 7, 7) = (/ &
        & 0.83043e-06_r8,0.84552e-06_r8,0.84833e-06_r8,0.82800e-06_r8,0.80930e-06_r8 /)
      kao(:, 8, 7) = (/ &
        & 0.14910e-05_r8,0.15179e-05_r8,0.15248e-05_r8,0.15091e-05_r8,0.14853e-05_r8 /)
      kao(:, 9, 7) = (/ &
        & 0.37340e-05_r8,0.37823e-05_r8,0.38311e-05_r8,0.38453e-05_r8,0.38567e-05_r8 /)
      kao(:,10, 7) = (/ &
        & 0.86791e-05_r8,0.89697e-05_r8,0.92118e-05_r8,0.93991e-05_r8,0.95564e-05_r8 /)
      kao(:,11, 7) = (/ &
        & 0.11878e-04_r8,0.12201e-04_r8,0.12588e-04_r8,0.12897e-04_r8,0.13151e-04_r8 /)
      kao(:,12, 7) = (/ &
        & 0.13192e-04_r8,0.13732e-04_r8,0.14137e-04_r8,0.14465e-04_r8,0.14643e-04_r8 /)
      kao(:,13, 7) = (/ &
        & 0.13716e-04_r8,0.14229e-04_r8,0.14617e-04_r8,0.14944e-04_r8,0.15182e-04_r8 /)
      kao(:, 1, 8) = (/ &
        & 0.39538e-05_r8,0.38949e-05_r8,0.56188e-05_r8,0.37475e-05_r8,0.36648e-05_r8 /)
      kao(:, 2, 8) = (/ &
        & 0.34231e-05_r8,0.33633e-05_r8,0.51877e-05_r8,0.50048e-05_r8,0.31425e-05_r8 /)
      kao(:, 3, 8) = (/ &
        & 0.28073e-05_r8,0.27497e-05_r8,0.26875e-05_r8,0.44405e-05_r8,0.25492e-05_r8 /)
      kao(:, 4, 8) = (/ &
        & 0.19229e-05_r8,0.18818e-05_r8,0.18382e-05_r8,0.17896e-05_r8,0.33073e-05_r8 /)
      kao(:, 5, 8) = (/ &
        & 0.11453e-05_r8,0.11293e-05_r8,0.11095e-05_r8,0.10866e-05_r8,0.19344e-05_r8 /)
      kao(:, 6, 8) = (/ &
        & 0.14565e-05_r8,0.14517e-05_r8,0.14369e-05_r8,0.14141e-05_r8,0.13944e-05_r8 /)
      kao(:, 7, 8) = (/ &
        & 0.23228e-05_r8,0.22753e-05_r8,0.22395e-05_r8,0.22124e-05_r8,0.21731e-05_r8 /)
      kao(:, 8, 8) = (/ &
        & 0.34877e-05_r8,0.34362e-05_r8,0.33796e-05_r8,0.33389e-05_r8,0.32924e-05_r8 /)
      kao(:, 9, 8) = (/ &
        & 0.63448e-05_r8,0.63701e-05_r8,0.63619e-05_r8,0.62632e-05_r8,0.61645e-05_r8 /)
      kao(:,10, 8) = (/ &
        & 0.12155e-04_r8,0.11880e-04_r8,0.11762e-04_r8,0.11759e-04_r8,0.11651e-04_r8 /)
      kao(:,11, 8) = (/ &
        & 0.14093e-04_r8,0.13835e-04_r8,0.13547e-04_r8,0.13205e-04_r8,0.12690e-04_r8 /)
      kao(:,12, 8) = (/ &
        & 0.14428e-04_r8,0.14056e-04_r8,0.13932e-04_r8,0.13396e-04_r8,0.12885e-04_r8 /)
      kao(:,13, 8) = (/ &
        & 0.15229e-04_r8,0.14534e-04_r8,0.13849e-04_r8,0.13292e-04_r8,0.12704e-04_r8 /)
      kao(:, 1, 9) = (/ &
        & 0.19250e-04_r8,0.19148e-04_r8,0.21702e-04_r8,0.18906e-04_r8,0.18761e-04_r8 /)
      kao(:, 2, 9) = (/ &
        & 0.18132e-04_r8,0.18040e-04_r8,0.20884e-04_r8,0.20523e-04_r8,0.17656e-04_r8 /)
      kao(:, 3, 9) = (/ &
        & 0.16928e-04_r8,0.16843e-04_r8,0.16742e-04_r8,0.19715e-04_r8,0.16470e-04_r8 /)
      kao(:, 4, 9) = (/ &
        & 0.15526e-04_r8,0.15463e-04_r8,0.15377e-04_r8,0.15268e-04_r8,0.18367e-04_r8 /)
      kao(:, 5, 9) = (/ &
        & 0.13545e-04_r8,0.13511e-04_r8,0.13455e-04_r8,0.13362e-04_r8,0.16722e-04_r8 /)
      kao(:, 6, 9) = (/ &
        & 0.97183e-05_r8,0.97218e-05_r8,0.97084e-05_r8,0.96717e-05_r8,0.96030e-05_r8 /)
      kao(:, 7, 9) = (/ &
        & 0.50307e-05_r8,0.50984e-05_r8,0.51628e-05_r8,0.52093e-05_r8,0.52354e-05_r8 /)
      kao(:, 8, 9) = (/ &
        & 0.45837e-05_r8,0.45939e-05_r8,0.45938e-05_r8,0.45639e-05_r8,0.45109e-05_r8 /)
      kao(:, 9, 9) = (/ &
        & 0.12254e-04_r8,0.12319e-04_r8,0.12397e-04_r8,0.12584e-04_r8,0.12620e-04_r8 /)
      kao(:,10, 9) = (/ &
        & 0.21545e-04_r8,0.21836e-04_r8,0.21718e-04_r8,0.21511e-04_r8,0.21211e-04_r8 /)
      kao(:,11, 9) = (/ &
        & 0.20079e-04_r8,0.19539e-04_r8,0.18859e-04_r8,0.18393e-04_r8,0.18181e-04_r8 /)
      kao(:,12, 9) = (/ &
        & 0.17115e-04_r8,0.16357e-04_r8,0.15410e-04_r8,0.15220e-04_r8,0.15207e-04_r8 /)
      kao(:,13, 9) = (/ &
        & 0.14935e-04_r8,0.14679e-04_r8,0.14593e-04_r8,0.14448e-04_r8,0.14436e-04_r8 /)
      kao(:, 1,10) = (/ &
        & 0.53569e-04_r8,0.53042e-04_r8,0.55454e-04_r8,0.52098e-04_r8,0.51678e-04_r8 /)
      kao(:, 2,10) = (/ &
        & 0.52196e-04_r8,0.51739e-04_r8,0.54777e-04_r8,0.54075e-04_r8,0.50624e-04_r8 /)
      kao(:, 3,10) = (/ &
        & 0.50339e-04_r8,0.50046e-04_r8,0.49769e-04_r8,0.53168e-04_r8,0.49370e-04_r8 /)
      kao(:, 4,10) = (/ &
        & 0.48505e-04_r8,0.48316e-04_r8,0.48143e-04_r8,0.47993e-04_r8,0.51621e-04_r8 /)
      kao(:, 5,10) = (/ &
        & 0.46313e-04_r8,0.46267e-04_r8,0.46119e-04_r8,0.46064e-04_r8,0.50279e-04_r8 /)
      kao(:, 6,10) = (/ &
        & 0.42662e-04_r8,0.42818e-04_r8,0.42935e-04_r8,0.43007e-04_r8,0.43099e-04_r8 /)
      kao(:, 7,10) = (/ &
        & 0.35762e-04_r8,0.36149e-04_r8,0.36450e-04_r8,0.36639e-04_r8,0.36887e-04_r8 /)
      kao(:, 8,10) = (/ &
        & 0.13516e-05_r8,0.18607e-05_r8,0.23061e-05_r8,0.27339e-05_r8,0.36516e-05_r8 /)
      kao(:, 9,10) = (/ &
        & 0.36432e-05_r8,0.40739e-05_r8,0.43830e-05_r8,0.41136e-05_r8,0.43128e-05_r8 /)
      kao(:,10,10) = (/ &
        & 0.62049e-05_r8,0.69116e-05_r8,0.73244e-05_r8,0.65087e-05_r8,0.78951e-05_r8 /)
      kao(:,11,10) = (/ &
        & 0.32156e-05_r8,0.38834e-05_r8,0.41231e-05_r8,0.43386e-05_r8,0.43405e-05_r8 /)
      kao(:,12,10) = (/ &
        & 0.22152e-05_r8,0.26754e-05_r8,0.31971e-05_r8,0.34911e-05_r8,0.37935e-05_r8 /)
      kao(:,13,10) = (/ &
        & 0.19792e-05_r8,0.26543e-05_r8,0.31511e-05_r8,0.34597e-05_r8,0.40624e-05_r8 /)
      kao(:, 1,11) = (/ &
        & 0.75384e-04_r8,0.75103e-04_r8,0.77406e-04_r8,0.74222e-04_r8,0.73734e-04_r8 /)
      kao(:, 2,11) = (/ &
        & 0.75458e-04_r8,0.75244e-04_r8,0.77778e-04_r8,0.77018e-04_r8,0.73942e-04_r8 /)
      kao(:, 3,11) = (/ &
        & 0.75023e-04_r8,0.74844e-04_r8,0.74477e-04_r8,0.77271e-04_r8,0.73633e-04_r8 /)
      kao(:, 4,11) = (/ &
        & 0.73633e-04_r8,0.73539e-04_r8,0.73257e-04_r8,0.72934e-04_r8,0.76232e-04_r8 /)
      kao(:, 5,11) = (/ &
        & 0.71348e-04_r8,0.71322e-04_r8,0.71227e-04_r8,0.71069e-04_r8,0.75258e-04_r8 /)
      kao(:, 6,11) = (/ &
        & 0.67784e-04_r8,0.67873e-04_r8,0.67974e-04_r8,0.67924e-04_r8,0.67903e-04_r8 /)
      kao(:, 7,11) = (/ &
        & 0.61855e-04_r8,0.61922e-04_r8,0.61973e-04_r8,0.62206e-04_r8,0.62496e-04_r8 /)
      kao(:, 8,11) = (/ &
        & 0.36622e-04_r8,0.37413e-04_r8,0.38740e-04_r8,0.40550e-04_r8,0.41833e-04_r8 /)
      kao(:, 9,11) = (/ &
        & 0.28544e-05_r8,0.28831e-05_r8,0.31445e-05_r8,0.32900e-05_r8,0.27967e-05_r8 /)
      kao(:,10,11) = (/ &
        & 0.53755e-05_r8,0.42123e-05_r8,0.51154e-05_r8,0.63481e-05_r8,0.54219e-05_r8 /)
      kao(:,11,11) = (/ &
        & 0.12605e-05_r8,0.14078e-05_r8,0.19167e-05_r8,0.23729e-05_r8,0.30161e-05_r8 /)
      kao(:,12,11) = (/ &
        & 0.11370e-05_r8,0.91524e-06_r8,0.11150e-05_r8,0.14746e-05_r8,0.20128e-05_r8 /)
      kao(:,13,11) = (/ &
        & 0.10511e-05_r8,0.10014e-05_r8,0.11405e-05_r8,0.13852e-05_r8,0.15576e-05_r8 /)
      kao(:, 1,12) = (/ &
        & 0.11184e-03_r8,0.11117e-03_r8,0.11327e-03_r8,0.10989e-03_r8,0.10910e-03_r8 /)
      kao(:, 2,12) = (/ &
        & 0.11379e-03_r8,0.11322e-03_r8,0.11555e-03_r8,0.11462e-03_r8,0.11135e-03_r8 /)
      kao(:, 3,12) = (/ &
        & 0.11508e-03_r8,0.11459e-03_r8,0.11421e-03_r8,0.11671e-03_r8,0.11339e-03_r8 /)
      kao(:, 4,12) = (/ &
        & 0.11596e-03_r8,0.11563e-03_r8,0.11538e-03_r8,0.11511e-03_r8,0.11770e-03_r8 /)
      kao(:, 5,12) = (/ &
        & 0.11597e-03_r8,0.11581e-03_r8,0.11569e-03_r8,0.11553e-03_r8,0.11890e-03_r8 /)
      kao(:, 6,12) = (/ &
        & 0.11443e-03_r8,0.11445e-03_r8,0.11443e-03_r8,0.11443e-03_r8,0.11438e-03_r8 /)
      kao(:, 7,12) = (/ &
        & 0.10852e-03_r8,0.10888e-03_r8,0.10912e-03_r8,0.10934e-03_r8,0.10942e-03_r8 /)
      kao(:, 8,12) = (/ &
        & 0.93194e-04_r8,0.94766e-04_r8,0.95355e-04_r8,0.95090e-04_r8,0.94926e-04_r8 /)
      kao(:, 9,12) = (/ &
        & 0.11836e-05_r8,0.16115e-05_r8,0.12883e-05_r8,0.14202e-05_r8,0.16541e-05_r8 /)
      kao(:,10,12) = (/ &
        & 0.18748e-05_r8,0.34401e-05_r8,0.39984e-05_r8,0.44576e-05_r8,0.33683e-05_r8 /)
      kao(:,11,12) = (/ &
        & 0.29890e-06_r8,0.48741e-06_r8,0.66276e-06_r8,0.99698e-06_r8,0.19230e-05_r8 /)
      kao(:,12,12) = (/ &
        & 0.15034e-06_r8,0.39966e-06_r8,0.56523e-06_r8,0.70494e-06_r8,0.10046e-05_r8 /)
      kao(:,13,12) = (/ &
        & 0.15016e-06_r8,0.25751e-06_r8,0.48928e-06_r8,0.63534e-06_r8,0.93575e-06_r8 /)
      kao(:, 1,13) = (/ &
        & 0.17305e-03_r8,0.17234e-03_r8,0.17389e-03_r8,0.17055e-03_r8,0.16974e-03_r8 /)
      kao(:, 2,13) = (/ &
        & 0.18170e-03_r8,0.18075e-03_r8,0.18265e-03_r8,0.18138e-03_r8,0.17772e-03_r8 /)
      kao(:, 3,13) = (/ &
        & 0.18990e-03_r8,0.18892e-03_r8,0.18776e-03_r8,0.18950e-03_r8,0.18494e-03_r8 /)
      kao(:, 4,13) = (/ &
        & 0.19649e-03_r8,0.19552e-03_r8,0.19424e-03_r8,0.19281e-03_r8,0.19464e-03_r8 /)
      kao(:, 5,13) = (/ &
        & 0.20197e-03_r8,0.20109e-03_r8,0.19993e-03_r8,0.19856e-03_r8,0.20092e-03_r8 /)
      kao(:, 6,13) = (/ &
        & 0.20595e-03_r8,0.20549e-03_r8,0.20452e-03_r8,0.20331e-03_r8,0.20199e-03_r8 /)
      kao(:, 7,13) = (/ &
        & 0.20703e-03_r8,0.20710e-03_r8,0.20649e-03_r8,0.20552e-03_r8,0.20428e-03_r8 /)
      kao(:, 8,13) = (/ &
        & 0.19874e-03_r8,0.19767e-03_r8,0.19696e-03_r8,0.19655e-03_r8,0.19591e-03_r8 /)
      kao(:, 9,13) = (/ &
        & 0.20434e-04_r8,0.23398e-04_r8,0.27400e-04_r8,0.32409e-04_r8,0.38451e-04_r8 /)
      kao(:,10,13) = (/ &
        & 0.18617e-05_r8,0.99513e-06_r8,0.10554e-05_r8,0.16516e-05_r8,0.37792e-05_r8 /)
      kao(:,11,13) = (/ &
        & 0.12517e-06_r8,0.29518e-06_r8,0.77058e-06_r8,0.11660e-05_r8,0.15349e-05_r8 /)
      kao(:,12,13) = (/ &
        & 0.12734e-06_r8,0.36524e-06_r8,0.66699e-06_r8,0.10362e-05_r8,0.14158e-05_r8 /)
      kao(:,13,13) = (/ &
        & 0.12431e-06_r8,0.39389e-06_r8,0.67331e-06_r8,0.10292e-05_r8,0.14448e-05_r8 /)
      kao(:, 1,14) = (/ &
        & 0.29365e-03_r8,0.29046e-03_r8,0.29008e-03_r8,0.28509e-03_r8,0.28286e-03_r8 /)
      kao(:, 2,14) = (/ &
        & 0.31990e-03_r8,0.31668e-03_r8,0.31617e-03_r8,0.31332e-03_r8,0.30885e-03_r8 /)
      kao(:, 3,14) = (/ &
        & 0.34787e-03_r8,0.34432e-03_r8,0.34112e-03_r8,0.34052e-03_r8,0.33589e-03_r8 /)
      kao(:, 4,14) = (/ &
        & 0.37401e-03_r8,0.37027e-03_r8,0.36696e-03_r8,0.36394e-03_r8,0.36355e-03_r8 /)
      kao(:, 5,14) = (/ &
        & 0.39840e-03_r8,0.39446e-03_r8,0.39082e-03_r8,0.38763e-03_r8,0.38760e-03_r8 /)
      kao(:, 6,14) = (/ &
        & 0.42165e-03_r8,0.41729e-03_r8,0.41335e-03_r8,0.41006e-03_r8,0.40721e-03_r8 /)
      kao(:, 7,14) = (/ &
        & 0.44257e-03_r8,0.43782e-03_r8,0.43364e-03_r8,0.43014e-03_r8,0.42736e-03_r8 /)
      kao(:, 8,14) = (/ &
        & 0.45299e-03_r8,0.44953e-03_r8,0.44586e-03_r8,0.44260e-03_r8,0.44006e-03_r8 /)
      kao(:, 9,14) = (/ &
        & 0.40190e-03_r8,0.39751e-03_r8,0.39238e-03_r8,0.38812e-03_r8,0.38612e-03_r8 /)
      kao(:,10,14) = (/ &
        & 0.64278e-05_r8,0.18248e-05_r8,0.16996e-05_r8,0.31086e-06_r8,0.16836e-06_r8 /)
      kao(:,11,14) = (/ &
        & 0.14350e-05_r8,0.94778e-06_r8,0.41349e-06_r8,0.20817e-06_r8,0.20238e-06_r8 /)
      kao(:,12,14) = (/ &
        & 0.16805e-05_r8,0.15323e-05_r8,0.62348e-06_r8,0.99743e-07_r8,0.12977e-06_r8 /)
      kao(:,13,14) = (/ &
        & 0.16858e-05_r8,0.17103e-05_r8,0.80574e-06_r8,0.15825e-06_r8,0.15032e-06_r8 /)
      kao(:, 1,15) = (/ &
        & 0.52181e-03_r8,0.51578e-03_r8,0.51251e-03_r8,0.50356e-03_r8,0.49731e-03_r8 /)
      kao(:, 2,15) = (/ &
        & 0.59491e-03_r8,0.58822e-03_r8,0.58413e-03_r8,0.57646e-03_r8,0.56692e-03_r8 /)
      kao(:, 3,15) = (/ &
        & 0.67653e-03_r8,0.66881e-03_r8,0.66126e-03_r8,0.65540e-03_r8,0.64461e-03_r8 /)
      kao(:, 4,15) = (/ &
        & 0.76388e-03_r8,0.75456e-03_r8,0.74556e-03_r8,0.73649e-03_r8,0.72840e-03_r8 /)
      kao(:, 5,15) = (/ &
        & 0.85507e-03_r8,0.84417e-03_r8,0.83378e-03_r8,0.82338e-03_r8,0.81349e-03_r8 /)
      kao(:, 6,15) = (/ &
        & 0.95034e-03_r8,0.93798e-03_r8,0.92553e-03_r8,0.91287e-03_r8,0.89957e-03_r8 /)
      kao(:, 7,15) = (/ &
        & 0.10496e-02_r8,0.10352e-02_r8,0.10206e-02_r8,0.10054e-02_r8,0.98958e-03_r8 /)
      kao(:, 8,15) = (/ &
        & 0.11507e-02_r8,0.11337e-02_r8,0.11169e-02_r8,0.10991e-02_r8,0.10806e-02_r8 /)
      kao(:, 9,15) = (/ &
        & 0.12408e-02_r8,0.12207e-02_r8,0.11996e-02_r8,0.11773e-02_r8,0.11531e-02_r8 /)
      kao(:,10,15) = (/ &
        & 0.12042e-03_r8,0.11501e-03_r8,0.11424e-03_r8,0.11450e-03_r8,0.13219e-03_r8 /)
      kao(:,11,15) = (/ &
        & 0.68914e-06_r8,0.83960e-06_r8,0.74591e-06_r8,0.18660e-05_r8,0.32503e-05_r8 /)
      kao(:,12,15) = (/ &
        & 0.35963e-07_r8,0.46256e-06_r8,0.56223e-06_r8,0.98816e-06_r8,0.92366e-06_r8 /)
      kao(:,13,15) = (/ &
        & 0.36605e-07_r8,0.56591e-06_r8,0.84008e-06_r8,0.86042e-06_r8,0.68452e-06_r8 /)
      kao(:, 1,16) = (/ &
        & 0.76517e-03_r8,0.75944e-03_r8,0.76010e-03_r8,0.76100e-03_r8,0.76498e-03_r8 /)
      kao(:, 2,16) = (/ &
        & 0.92375e-03_r8,0.91357e-03_r8,0.90997e-03_r8,0.90997e-03_r8,0.90993e-03_r8 /)
      kao(:, 3,16) = (/ &
        & 0.11142e-02_r8,0.10974e-02_r8,0.10835e-02_r8,0.10789e-02_r8,0.10748e-02_r8 /)
      kao(:, 4,16) = (/ &
        & 0.13278e-02_r8,0.13025e-02_r8,0.12802e-02_r8,0.12631e-02_r8,0.12539e-02_r8 /)
      kao(:, 5,16) = (/ &
        & 0.15712e-02_r8,0.15343e-02_r8,0.15017e-02_r8,0.14713e-02_r8,0.14497e-02_r8 /)
      kao(:, 6,16) = (/ &
        & 0.18525e-02_r8,0.17982e-02_r8,0.17525e-02_r8,0.17101e-02_r8,0.16714e-02_r8 /)
      kao(:, 7,16) = (/ &
        & 0.21731e-02_r8,0.20986e-02_r8,0.20340e-02_r8,0.19757e-02_r8,0.19210e-02_r8 /)
      kao(:, 8,16) = (/ &
        & 0.25325e-02_r8,0.24346e-02_r8,0.23473e-02_r8,0.22687e-02_r8,0.21950e-02_r8 /)
      kao(:, 9,16) = (/ &
        & 0.29269e-02_r8,0.28006e-02_r8,0.26863e-02_r8,0.25805e-02_r8,0.24878e-02_r8 /)
      kao(:,10,16) = (/ &
        & 0.29442e-02_r8,0.27008e-02_r8,0.23913e-02_r8,0.21437e-02_r8,0.18865e-02_r8 /)
      kao(:,11,16) = (/ &
        & 0.23220e-05_r8,0.22310e-04_r8,0.48349e-04_r8,0.67183e-04_r8,0.88908e-04_r8 /)
      kao(:,12,16) = (/ &
        & 0.22857e-05_r8,0.11848e-04_r8,0.42066e-04_r8,0.67613e-04_r8,0.86033e-04_r8 /)
      kao(:,13,16) = (/ &
        & 0.22823e-05_r8,0.69105e-05_r8,0.36212e-04_r8,0.66247e-04_r8,0.85488e-04_r8 /)
  
      end subroutine sw_kgb25

