!     path:      $Source: /storm/rc1/cvsroot/rc/rrtmg_lw/src/rrtmg_lw_k_g.f90,v $
!     author:    $Author: mike $
!     revision:  $Revision: 1.2 $
!     created:   $Date: 2007/08/22 19:20:03 $
!
!  --------------------------------------------------------------------------
! |                                                                          |
! |  Copyright 2002-2007, Atmospheric & Environmental Research, Inc. (AER).  |
! |  This software may be used, copied, or redistributed as long as it is    |
! |  not sold and this copyright notice is reproduced on each copy made.     |
! |  This model is provided as is without any express or implied warranties. |
! |                       (http://www.rtweb.aer.com/)                        |
! |                                                                          |
!  --------------------------------------------------------------------------

! **************************************************************************
!      subroutine lw_kgbnn
! **************************************************************************
!  RRTM Longwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original version:   E. J. Mlawer, et al.
!  Revision for GCMs:  Michael J. Iacono; October, 2002
!
!  This file contains 16 subroutines that include the 
!  absorption coefficients and other data for each of the 16 longwave
!  spectral bands used in RRTM.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_LW_INIT to reduce
!  the total number of g-points from 256 to 140 for use in the GCM.
! **************************************************************************
      subroutine lw_kgb16
! **************************************************************************

      use shr_kind_mod, only: r8 => shr_kind_r8

!      use parkind, only : jpim, jprb 
      use rrlw_kg16, only : fracrefao, fracrefbo, kao, kbo, selfrefo, forrefo

      implicit none
      save

! Planck fraction mapping level: P = 387.6100 mbar, T = 250.17 K
      fracrefao(:, 1) = (/ &
     &  1.1593e-01_r8,2.3390e-01_r8,1.9120e-01_r8,1.3121e-01_r8,1.0590e-01_r8,8.4852e-02_r8, &
     &  6.4168e-02_r8,4.2537e-02_r8,2.3220e-02_r8,2.1767e-03_r8,1.8203e-03_r8,1.3724e-03_r8, &
     &  9.5452e-04_r8,5.5015e-04_r8,1.9348e-04_r8,2.7344e-05_r8/)
      fracrefao(:, 2) = (/ &
     &  2.8101e-01_r8,1.9773e-01_r8,1.4749e-01_r8,1.1399e-01_r8,8.8190e-02_r8,7.0531e-02_r8, &
     &  4.6356e-02_r8,3.0774e-02_r8,1.7332e-02_r8,2.0054e-03_r8,1.5950e-03_r8,1.2760e-03_r8, &
     &  9.5034e-04_r8,5.4992e-04_r8,1.9349e-04_r8,2.7309e-05_r8/)
      fracrefao(:, 3) = (/ &
     &  2.9054e-01_r8,2.1263e-01_r8,1.4133e-01_r8,1.1083e-01_r8,8.5107e-02_r8,6.5247e-02_r8, &
     &  4.4542e-02_r8,2.7205e-02_r8,1.6495e-02_r8,1.8453e-03_r8,1.5222e-03_r8,1.1884e-03_r8, &
     &  8.1094e-04_r8,4.9173e-04_r8,1.9344e-04_r8,2.7286e-05_r8/)
      fracrefao(:, 4) = (/ &
     &  2.9641e-01_r8,2.1738e-01_r8,1.4228e-01_r8,1.0830e-01_r8,8.2837e-02_r8,6.1359e-02_r8, &
     &  4.4683e-02_r8,2.5027e-02_r8,1.6057e-02_r8,1.7558e-03_r8,1.4193e-03_r8,1.0970e-03_r8, &
     &  7.8281e-04_r8,4.3260e-04_r8,1.4837e-04_r8,2.2958e-05_r8/)
      fracrefao(:, 5) = (/ &
     &  2.9553e-01_r8,2.2139e-01_r8,1.4816e-01_r8,1.0601e-01_r8,8.0048e-02_r8,6.0082e-02_r8, &
     &  4.3952e-02_r8,2.3788e-02_r8,1.5734e-02_r8,1.6586e-03_r8,1.3434e-03_r8,1.0281e-03_r8, &
     &  7.0256e-04_r8,4.2577e-04_r8,1.2803e-04_r8,1.3315e-05_r8/)
      fracrefao(:, 6) = (/ &
     &  2.9313e-01_r8,2.2476e-01_r8,1.5470e-01_r8,1.0322e-01_r8,7.8904e-02_r8,5.8175e-02_r8, &
     &  4.3097e-02_r8,2.3618e-02_r8,1.5385e-02_r8,1.5942e-03_r8,1.2702e-03_r8,9.5566e-04_r8, &
     &  6.5421e-04_r8,4.0165e-04_r8,1.2805e-04_r8,1.3355e-05_r8/)
      fracrefao(:, 7) = (/ &
     &  2.9069e-01_r8,2.2823e-01_r8,1.5995e-01_r8,1.0170e-01_r8,7.7287e-02_r8,5.6780e-02_r8, &
     &  4.1752e-02_r8,2.3899e-02_r8,1.4937e-02_r8,1.4916e-03_r8,1.1909e-03_r8,9.1307e-04_r8, &
     &  6.3518e-04_r8,3.9866e-04_r8,1.2805e-04_r8,1.3298e-05_r8/)
      fracrefao(:, 8) = (/ &
     &  2.8446e-01_r8,2.2651e-01_r8,1.7133e-01_r8,1.0299e-01_r8,7.4231e-02_r8,5.6031e-02_r8, &
     &  4.1368e-02_r8,2.4318e-02_r8,1.4135e-02_r8,1.4216e-03_r8,1.1465e-03_r8,8.9800e-04_r8, &
     &  6.3553e-04_r8,3.9536e-04_r8,1.2749e-04_r8,1.3298e-05_r8/)
      fracrefao(:, 9) = (/ &
     &  2.0568e-01_r8,2.5049e-01_r8,2.0568e-01_r8,1.1781e-01_r8,7.5579e-02_r8,5.8136e-02_r8, &
     &  4.2397e-02_r8,2.6544e-02_r8,1.3067e-02_r8,1.4061e-03_r8,1.1455e-03_r8,8.9408e-04_r8, &
     &  6.3652e-04_r8,3.9450e-04_r8,1.2841e-04_r8,1.3315e-05_r8/)

! Planck fraction mapping level : P=95.58350 mb, T = 215.70 K
      fracrefbo(:) = (/ &
     &  1.8111e-01_r8,2.2612e-01_r8,1.6226e-01_r8,1.1872e-01_r8,9.9048e-02_r8,8.0390e-02_r8, &
     &  6.1648e-02_r8,4.1704e-02_r8,2.2976e-02_r8,1.9263e-03_r8,1.4694e-03_r8,1.1498e-03_r8, &
     &  7.9906e-04_r8,4.8310e-04_r8,1.6188e-04_r8,2.2651e-05_r8/)

!     The array KAO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels > ~100mb, temperatures, and ratios
!     of water vapor to CO2.  The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amount ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 
!     to that of gas2.
!     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
!     to different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this  pressure 
!     level, JT = 2 refers to the temperature
!     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the reference pressure level (e.g. JP = 1 is for a
!     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

      kao(:, 1, 1, 1) = (/ &
     &2.6621e-07_r8,6.0791e-06_r8,9.3282e-06_r8,1.2208e-05_r8,1.4897e-05_r8,1.7596e-05_r8, &
     &2.0729e-05_r8,2.6390e-05_r8,2.1078e-05_r8/)
      kao(:, 2, 1, 1) = (/ &
     &2.8927e-07_r8,6.1043e-06_r8,9.4020e-06_r8,1.2345e-05_r8,1.5126e-05_r8,1.7938e-05_r8, &
     &2.1210e-05_r8,2.6769e-05_r8,2.1943e-05_r8/)
      kao(:, 3, 1, 1) = (/ &
     &3.1534e-07_r8,6.1325e-06_r8,9.4674e-06_r8,1.2459e-05_r8,1.5335e-05_r8,1.8250e-05_r8, &
     &2.1635e-05_r8,2.7290e-05_r8,2.2718e-05_r8/)
      kao(:, 4, 1, 1) = (/ &
     &3.3330e-07_r8,6.1474e-06_r8,9.4677e-06_r8,1.2509e-05_r8,1.5444e-05_r8,1.8455e-05_r8, &
     &2.1960e-05_r8,2.7695e-05_r8,2.3390e-05_r8/)
      kao(:, 5, 1, 1) = (/ &
     &3.5345e-07_r8,6.1735e-06_r8,9.4652e-06_r8,1.2538e-05_r8,1.5529e-05_r8,1.8608e-05_r8, &
     &2.2197e-05_r8,2.8038e-05_r8,2.3906e-05_r8/)
      kao(:, 1, 2, 1) = (/ &
     &3.4774e-07_r8,6.3116e-06_r8,9.2039e-06_r8,1.1662e-05_r8,1.3842e-05_r8,1.5878e-05_r8, &
     &1.7925e-05_r8,2.1213e-05_r8,1.7372e-05_r8/)
      kao(:, 2, 2, 1) = (/ &
     &3.7649e-07_r8,6.3618e-06_r8,9.2771e-06_r8,1.1777e-05_r8,1.4038e-05_r8,1.6170e-05_r8, &
     &1.8345e-05_r8,2.1716e-05_r8,1.8135e-05_r8/)
      kao(:, 3, 2, 1) = (/ &
     &4.1206e-07_r8,6.4231e-06_r8,9.3322e-06_r8,1.1891e-05_r8,1.4202e-05_r8,1.6428e-05_r8, &
     &1.8750e-05_r8,2.2212e-05_r8,1.8847e-05_r8/)
      kao(:, 4, 2, 1) = (/ &
     &4.4004e-07_r8,6.4581e-06_r8,9.3579e-06_r8,1.1962e-05_r8,1.4316e-05_r8,1.6601e-05_r8, &
     &1.9025e-05_r8,2.2633e-05_r8,1.9458e-05_r8/)
      kao(:, 5, 2, 1) = (/ &
     &4.6078e-07_r8,6.4755e-06_r8,9.3704e-06_r8,1.1973e-05_r8,1.4371e-05_r8,1.6702e-05_r8, &
     &1.9215e-05_r8,2.2953e-05_r8,1.9948e-05_r8/)
      kao(:, 1, 3, 1) = (/ &
     &5.9817e-07_r8,7.8428e-06_r8,1.0496e-05_r8,1.2549e-05_r8,1.4230e-05_r8,1.5565e-05_r8, &
     &1.6588e-05_r8,1.7671e-05_r8,1.4245e-05_r8/)
      kao(:, 2, 3, 1) = (/ &
     &6.5182e-07_r8,7.9343e-06_r8,1.0585e-05_r8,1.2668e-05_r8,1.4392e-05_r8,1.5789e-05_r8, &
     &1.6949e-05_r8,1.8125e-05_r8,1.4996e-05_r8/)
      kao(:, 3, 3, 1) = (/ &
     &7.0221e-07_r8,8.0226e-06_r8,1.0677e-05_r8,1.2755e-05_r8,1.4518e-05_r8,1.5973e-05_r8, &
     &1.7236e-05_r8,1.8551e-05_r8,1.5656e-05_r8/)
      kao(:, 4, 3, 1) = (/ &
     &7.6366e-07_r8,8.1339e-06_r8,1.0778e-05_r8,1.2848e-05_r8,1.4645e-05_r8,1.6156e-05_r8, &
     &1.7457e-05_r8,1.8931e-05_r8,1.6271e-05_r8/)
      kao(:, 5, 3, 1) = (/ &
     &7.9889e-07_r8,8.1643e-06_r8,1.0808e-05_r8,1.2886e-05_r8,1.4686e-05_r8,1.6241e-05_r8, &
     &1.7601e-05_r8,1.9193e-05_r8,1.6837e-05_r8/)
      kao(:, 1, 4, 1) = (/ &
     &1.0320e-06_r8,1.0378e-05_r8,1.2935e-05_r8,1.4632e-05_r8,1.5802e-05_r8,1.6452e-05_r8, &
     &1.6586e-05_r8,1.6155e-05_r8,1.2287e-05_r8/)
      kao(:, 2, 4, 1) = (/ &
     &1.1305e-06_r8,1.0573e-05_r8,1.3130e-05_r8,1.4798e-05_r8,1.5980e-05_r8,1.6653e-05_r8, &
     &1.6853e-05_r8,1.6526e-05_r8,1.3070e-05_r8/)
      kao(:, 3, 4, 1) = (/ &
     &1.2198e-06_r8,1.0772e-05_r8,1.3274e-05_r8,1.4971e-05_r8,1.6111e-05_r8,1.6834e-05_r8, &
     &1.7084e-05_r8,1.6873e-05_r8,1.3795e-05_r8/)
      kao(:, 4, 4, 1) = (/ &
     &1.3096e-06_r8,1.0937e-05_r8,1.3422e-05_r8,1.5096e-05_r8,1.6233e-05_r8,1.6971e-05_r8, &
     &1.7284e-05_r8,1.7149e-05_r8,1.4420e-05_r8/)
      kao(:, 5, 4, 1) = (/ &
     &1.4155e-06_r8,1.1094e-05_r8,1.3596e-05_r8,1.5273e-05_r8,1.6388e-05_r8,1.7112e-05_r8, &
     &1.7471e-05_r8,1.7381e-05_r8,1.4960e-05_r8/)
      kao(:, 1, 5, 1) = (/ &
     &1.6279e-06_r8,1.3142e-05_r8,1.6056e-05_r8,1.7394e-05_r8,1.8017e-05_r8,1.8011e-05_r8, &
     &1.7308e-05_r8,1.5625e-05_r8,1.1008e-05_r8/)
      kao(:, 2, 5, 1) = (/ &
     &1.7835e-06_r8,1.3457e-05_r8,1.6348e-05_r8,1.7668e-05_r8,1.8277e-05_r8,1.8261e-05_r8, &
     &1.7567e-05_r8,1.5970e-05_r8,1.1698e-05_r8/)
      kao(:, 3, 5, 1) = (/ &
     &1.9402e-06_r8,1.3791e-05_r8,1.6620e-05_r8,1.7922e-05_r8,1.8515e-05_r8,1.8474e-05_r8, &
     &1.7802e-05_r8,1.6252e-05_r8,1.2372e-05_r8/)
      kao(:, 4, 5, 1) = (/ &
     &2.0835e-06_r8,1.4086e-05_r8,1.6875e-05_r8,1.8160e-05_r8,1.8703e-05_r8,1.8665e-05_r8, &
     &1.7992e-05_r8,1.6486e-05_r8,1.3071e-05_r8/)
      kao(:, 5, 5, 1) = (/ &
     &2.2582e-06_r8,1.4511e-05_r8,1.7205e-05_r8,1.8422e-05_r8,1.8984e-05_r8,1.8898e-05_r8, &
     &1.8217e-05_r8,1.6724e-05_r8,1.3787e-05_r8/)
      kao(:, 1, 6, 1) = (/ &
     &2.4034e-06_r8,1.6823e-05_r8,1.9391e-05_r8,2.0723e-05_r8,2.0772e-05_r8,2.0043e-05_r8, &
     &1.8498e-05_r8,1.5704e-05_r8,9.8836e-06_r8/)
      kao(:, 2, 6, 1) = (/ &
     &2.6386e-06_r8,1.7226e-05_r8,1.9692e-05_r8,2.1124e-05_r8,2.1126e-05_r8,2.0392e-05_r8, &
     &1.8810e-05_r8,1.6034e-05_r8,1.0751e-05_r8/)
      kao(:, 3, 6, 1) = (/ &
     &2.8660e-06_r8,1.7674e-05_r8,2.0029e-05_r8,2.1524e-05_r8,2.1484e-05_r8,2.0719e-05_r8, &
     &1.9071e-05_r8,1.6298e-05_r8,1.1450e-05_r8/)
      kao(:, 4, 6, 1) = (/ &
     &3.0844e-06_r8,1.8072e-05_r8,2.0407e-05_r8,2.1899e-05_r8,2.1788e-05_r8,2.0987e-05_r8, &
     &1.9304e-05_r8,1.6540e-05_r8,1.2182e-05_r8/)
      kao(:, 5, 6, 1) = (/ &
     &3.2920e-06_r8,1.8533e-05_r8,2.0800e-05_r8,2.2106e-05_r8,2.2044e-05_r8,2.1223e-05_r8, &
     &1.9506e-05_r8,1.6741e-05_r8,1.2836e-05_r8/)
      kao(:, 1, 7, 1) = (/ &
     &3.8221e-06_r8,2.2204e-05_r8,2.4808e-05_r8,2.5531e-05_r8,2.5616e-05_r8,2.3917e-05_r8, &
     &2.1120e-05_r8,1.6870e-05_r8,8.7171e-06_r8/)
      kao(:, 2, 7, 1) = (/ &
     &4.1828e-06_r8,2.2870e-05_r8,2.5558e-05_r8,2.5953e-05_r8,2.6151e-05_r8,2.4347e-05_r8, &
     &2.1524e-05_r8,1.7202e-05_r8,9.2028e-06_r8/)
      kao(:, 3, 7, 1) = (/ &
     &4.5497e-06_r8,2.3564e-05_r8,2.6164e-05_r8,2.6493e-05_r8,2.6591e-05_r8,2.4767e-05_r8, &
     &2.1899e-05_r8,1.7498e-05_r8,9.7937e-06_r8/)
      kao(:, 4, 7, 1) = (/ &
     &4.8742e-06_r8,2.4270e-05_r8,2.6708e-05_r8,2.7099e-05_r8,2.6759e-05_r8,2.5177e-05_r8, &
     &2.2242e-05_r8,1.7759e-05_r8,1.0449e-05_r8/)
      kao(:, 5, 7, 1) = (/ &
     &5.1866e-06_r8,2.4962e-05_r8,2.7348e-05_r8,2.7664e-05_r8,2.7129e-05_r8,2.5537e-05_r8, &
     &2.2515e-05_r8,1.7998e-05_r8,1.1128e-05_r8/)
      kao(:, 1, 8, 1) = (/ &
     &7.4211e-06_r8,3.2998e-05_r8,3.6610e-05_r8,3.7073e-05_r8,3.4983e-05_r8,3.2511e-05_r8, &
     &2.7821e-05_r8,2.0603e-05_r8,7.1809e-06_r8/)
      kao(:, 2, 8, 1) = (/ &
     &8.1099e-06_r8,3.4342e-05_r8,3.7801e-05_r8,3.7976e-05_r8,3.5797e-05_r8,3.2823e-05_r8, &
     &2.8347e-05_r8,2.1030e-05_r8,7.7735e-06_r8/)
      kao(:, 3, 8, 1) = (/ &
     &8.7992e-06_r8,3.5880e-05_r8,3.8837e-05_r8,3.8975e-05_r8,3.6756e-05_r8,3.3300e-05_r8, &
     &2.8882e-05_r8,2.1428e-05_r8,8.4180e-06_r8/)
      kao(:, 4, 8, 1) = (/ &
     &9.4486e-06_r8,3.7431e-05_r8,3.9883e-05_r8,3.9775e-05_r8,3.7762e-05_r8,3.3901e-05_r8, &
     &2.9403e-05_r8,2.1792e-05_r8,9.1057e-06_r8/)
      kao(:, 5, 8, 1) = (/ &
     &1.0041e-05_r8,3.9014e-05_r8,4.1019e-05_r8,4.0539e-05_r8,3.8447e-05_r8,3.4543e-05_r8, &
     &2.9823e-05_r8,2.2110e-05_r8,9.8280e-06_r8/)
      kao(:, 1, 9, 1) = (/ &
     &2.6945e-05_r8,8.1804e-05_r8,8.6984e-05_r8,8.4462e-05_r8,7.8660e-05_r8,6.9398e-05_r8, &
     &5.6216e-05_r8,3.9134e-05_r8,6.0831e-06_r8/)
      kao(:, 2, 9, 1) = (/ &
     &2.9562e-05_r8,8.5456e-05_r8,9.1284e-05_r8,8.7620e-05_r8,8.1311e-05_r8,7.1570e-05_r8, &
     &5.7999e-05_r8,3.9483e-05_r8,6.6855e-06_r8/)
      kao(:, 3, 9, 1) = (/ &
     &3.2110e-05_r8,8.8183e-05_r8,9.6256e-05_r8,9.1033e-05_r8,8.3882e-05_r8,7.3603e-05_r8, &
     &5.9334e-05_r8,4.0067e-05_r8,7.3573e-06_r8/)
      kao(:, 4, 9, 1) = (/ &
     &3.4494e-05_r8,9.0981e-05_r8,1.0082e-04_r8,9.4837e-05_r8,8.6631e-05_r8,7.5471e-05_r8, &
     &6.0778e-05_r8,4.0870e-05_r8,8.0874e-06_r8/)
      kao(:, 5, 9, 1) = (/ &
     &3.6729e-05_r8,9.3406e-05_r8,1.0411e-04_r8,9.8963e-05_r8,8.9287e-05_r8,7.7185e-05_r8, &
     &6.1987e-05_r8,4.1723e-05_r8,8.8598e-06_r8/)
      kao(:, 1,10, 1) = (/ &
     &1.1063e-04_r8,2.0470e-04_r8,2.2594e-04_r8,2.2784e-04_r8,2.0878e-04_r8,1.7781e-04_r8, &
     &1.3876e-04_r8,9.0190e-05_r8,6.6238e-06_r8/)
      kao(:, 2,10, 1) = (/ &
     &1.2128e-04_r8,2.1612e-04_r8,2.3657e-04_r8,2.3782e-04_r8,2.2024e-04_r8,1.8545e-04_r8, &
     &1.4406e-04_r8,9.3147e-05_r8,7.2888e-06_r8/)
      kao(:, 3,10, 1) = (/ &
     &1.3155e-04_r8,2.2685e-04_r8,2.4613e-04_r8,2.4648e-04_r8,2.3100e-04_r8,1.9523e-04_r8, &
     &1.4909e-04_r8,9.5827e-05_r8,7.7784e-06_r8/)
      kao(:, 4,10, 1) = (/ &
     &1.4108e-04_r8,2.3656e-04_r8,2.5475e-04_r8,2.5395e-04_r8,2.3879e-04_r8,2.0427e-04_r8, &
     &1.5511e-04_r8,9.8368e-05_r8,8.3069e-06_r8/)
      kao(:, 5,10, 1) = (/ &
     &1.4988e-04_r8,2.4526e-04_r8,2.6296e-04_r8,2.6141e-04_r8,2.4593e-04_r8,2.1313e-04_r8, &
     &1.6065e-04_r8,1.0083e-04_r8,8.9709e-06_r8/)
      kao(:, 1,11, 1) = (/ &
     &1.6397e-04_r8,2.6056e-04_r8,2.8031e-04_r8,2.7866e-04_r8,2.6081e-04_r8,2.2383e-04_r8, &
     &1.7351e-04_r8,1.0962e-04_r8,6.8264e-06_r8/)
      kao(:, 2,11, 1) = (/ &
     &1.7933e-04_r8,2.7580e-04_r8,2.9343e-04_r8,2.9042e-04_r8,2.7290e-04_r8,2.3596e-04_r8, &
     &1.8069e-04_r8,1.1353e-04_r8,7.5502e-06_r8/)
      kao(:, 3,11, 1) = (/ &
     &1.9324e-04_r8,2.9031e-04_r8,3.0629e-04_r8,3.0108e-04_r8,2.8182e-04_r8,2.4730e-04_r8, &
     &1.8878e-04_r8,1.1713e-04_r8,7.9027e-06_r8/)
      kao(:, 4,11, 1) = (/ &
     &2.0654e-04_r8,3.0384e-04_r8,3.1739e-04_r8,3.1103e-04_r8,2.9049e-04_r8,2.5555e-04_r8, &
     &1.9705e-04_r8,1.2084e-04_r8,8.5383e-06_r8/)
      kao(:, 5,11, 1) = (/ &
     &2.1856e-04_r8,3.1574e-04_r8,3.2801e-04_r8,3.2141e-04_r8,2.9895e-04_r8,2.6285e-04_r8, &
     &2.0518e-04_r8,1.2441e-04_r8,9.1615e-06_r8/)
      kao(:, 1,12, 1) = (/ &
     &1.7554e-04_r8,2.6383e-04_r8,2.7930e-04_r8,2.7562e-04_r8,2.5860e-04_r8,2.2333e-04_r8, &
     &1.7363e-04_r8,1.0883e-04_r8,5.7385e-06_r8/)
      kao(:, 2,12, 1) = (/ &
     &1.9241e-04_r8,2.8007e-04_r8,2.9311e-04_r8,2.8776e-04_r8,2.6852e-04_r8,2.3492e-04_r8, &
     &1.8150e-04_r8,1.1266e-04_r8,6.8723e-06_r8/)
      kao(:, 3,12, 1) = (/ &
     &2.0743e-04_r8,2.9497e-04_r8,3.0602e-04_r8,2.9878e-04_r8,2.7794e-04_r8,2.4424e-04_r8, &
     &1.8850e-04_r8,1.1619e-04_r8,7.4728e-06_r8/)
      kao(:, 4,12, 1) = (/ &
     &2.2033e-04_r8,3.0884e-04_r8,3.1746e-04_r8,3.0874e-04_r8,2.8629e-04_r8,2.5127e-04_r8, &
     &1.9681e-04_r8,1.2004e-04_r8,7.8331e-06_r8/)
      kao(:, 5,12, 1) = (/ &
     &2.3385e-04_r8,3.2096e-04_r8,3.2817e-04_r8,3.1852e-04_r8,2.9492e-04_r8,2.5838e-04_r8, &
     &2.0541e-04_r8,1.2394e-04_r8,8.4107e-06_r8/)
      kao(:, 1,13, 1) = (/ &
     &1.4984e-04_r8,2.2462e-04_r8,2.3735e-04_r8,2.3350e-04_r8,2.1852e-04_r8,1.8858e-04_r8, &
     &1.4655e-04_r8,9.1919e-05_r8,4.7944e-06_r8/)
      kao(:, 2,13, 1) = (/ &
     &1.6431e-04_r8,2.3822e-04_r8,2.4852e-04_r8,2.4374e-04_r8,2.2685e-04_r8,1.9798e-04_r8, &
     &1.5298e-04_r8,9.5139e-05_r8,5.7512e-06_r8/)
      kao(:, 3,13, 1) = (/ &
     &1.7714e-04_r8,2.5149e-04_r8,2.5950e-04_r8,2.5249e-04_r8,2.3438e-04_r8,2.0591e-04_r8, &
     &1.5891e-04_r8,9.8151e-05_r8,6.2816e-06_r8/)
      kao(:, 4,13, 1) = (/ &
     &1.8918e-04_r8,2.6227e-04_r8,2.6867e-04_r8,2.6081e-04_r8,2.4142e-04_r8,2.1149e-04_r8, &
     &1.6602e-04_r8,1.0121e-04_r8,6.5742e-06_r8/)
      kao(:, 5,13, 1) = (/ &
     &1.9984e-04_r8,2.7202e-04_r8,2.7776e-04_r8,2.6884e-04_r8,2.4875e-04_r8,2.1766e-04_r8, &
     &1.7300e-04_r8,1.0449e-04_r8,7.0482e-06_r8/)
      kao(:, 1, 1, 2) = (/ &
     &1.6519e-06_r8,1.6500e-05_r8,2.5026e-05_r8,3.2759e-05_r8,4.0208e-05_r8,4.7995e-05_r8, &
     &5.7218e-05_r8,7.0450e-05_r8,6.2071e-05_r8/)
      kao(:, 2, 1, 2) = (/ &
     &1.7427e-06_r8,1.6766e-05_r8,2.5514e-05_r8,3.3509e-05_r8,4.1226e-05_r8,4.9256e-05_r8, &
     &5.8782e-05_r8,7.2775e-05_r8,6.4227e-05_r8/)
      kao(:, 3, 1, 2) = (/ &
     &1.8342e-06_r8,1.7039e-05_r8,2.6012e-05_r8,3.4217e-05_r8,4.2214e-05_r8,5.0504e-05_r8, &
     &6.0325e-05_r8,7.4727e-05_r8,6.6376e-05_r8/)
      kao(:, 4, 1, 2) = (/ &
     &1.9060e-06_r8,1.7243e-05_r8,2.6493e-05_r8,3.4981e-05_r8,4.3216e-05_r8,5.1749e-05_r8, &
     &6.1747e-05_r8,7.6716e-05_r8,6.8482e-05_r8/)
      kao(:, 5, 1, 2) = (/ &
     &1.9873e-06_r8,1.7462e-05_r8,2.6980e-05_r8,3.5686e-05_r8,4.4149e-05_r8,5.2919e-05_r8, &
     &6.3181e-05_r8,7.8643e-05_r8,7.0600e-05_r8/)
      kao(:, 1, 2, 2) = (/ &
     &2.1537e-06_r8,1.7686e-05_r8,2.5477e-05_r8,3.2084e-05_r8,3.8037e-05_r8,4.3791e-05_r8, &
     &5.0118e-05_r8,5.9749e-05_r8,5.2659e-05_r8/)
      kao(:, 2, 2, 2) = (/ &
     &2.2967e-06_r8,1.7950e-05_r8,2.5979e-05_r8,3.2808e-05_r8,3.8966e-05_r8,4.4991e-05_r8, &
     &5.1587e-05_r8,6.1578e-05_r8,5.4559e-05_r8/)
      kao(:, 3, 2, 2) = (/ &
     &2.4223e-06_r8,1.8241e-05_r8,2.6472e-05_r8,3.3476e-05_r8,3.9818e-05_r8,4.6056e-05_r8, &
     &5.2876e-05_r8,6.3201e-05_r8,5.6392e-05_r8/)
      kao(:, 4, 2, 2) = (/ &
     &2.5452e-06_r8,1.8478e-05_r8,2.6920e-05_r8,3.4112e-05_r8,4.0714e-05_r8,4.7174e-05_r8, &
     &5.4253e-05_r8,6.4831e-05_r8,5.8337e-05_r8/)
      kao(:, 5, 2, 2) = (/ &
     &2.6442e-06_r8,1.8696e-05_r8,2.7330e-05_r8,3.4790e-05_r8,4.1641e-05_r8,4.8326e-05_r8, &
     &5.5567e-05_r8,6.6400e-05_r8,6.0213e-05_r8/)
      kao(:, 1, 3, 2) = (/ &
     &3.6781e-06_r8,2.1946e-05_r8,2.9916e-05_r8,3.5559e-05_r8,4.0089e-05_r8,4.3735e-05_r8, &
     &4.6884e-05_r8,5.0541e-05_r8,4.3984e-05_r8/)
      kao(:, 2, 3, 2) = (/ &
     &3.9348e-06_r8,2.2135e-05_r8,3.0461e-05_r8,3.6306e-05_r8,4.1005e-05_r8,4.4863e-05_r8, &
     &4.8174e-05_r8,5.2207e-05_r8,4.5557e-05_r8/)
      kao(:, 3, 3, 2) = (/ &
     &4.1798e-06_r8,2.2403e-05_r8,3.0963e-05_r8,3.7011e-05_r8,4.1865e-05_r8,4.5861e-05_r8, &
     &4.9330e-05_r8,5.3612e-05_r8,4.7151e-05_r8/)
      kao(:, 4, 3, 2) = (/ &
     &4.4176e-06_r8,2.2879e-05_r8,3.1514e-05_r8,3.7717e-05_r8,4.2706e-05_r8,4.6836e-05_r8, &
     &5.0501e-05_r8,5.4941e-05_r8,4.8733e-05_r8/)
      kao(:, 5, 3, 2) = (/ &
     &4.5930e-06_r8,2.3205e-05_r8,3.1822e-05_r8,3.8274e-05_r8,4.3472e-05_r8,4.7803e-05_r8, &
     &5.1670e-05_r8,5.6326e-05_r8,5.0305e-05_r8/)
      kao(:, 1, 4, 2) = (/ &
     &6.4358e-06_r8,2.9282e-05_r8,3.6943e-05_r8,4.2596e-05_r8,4.5632e-05_r8,4.7319e-05_r8, &
     &4.7633e-05_r8,4.6727e-05_r8,3.6481e-05_r8/)
      kao(:, 2, 4, 2) = (/ &
     &6.8669e-06_r8,2.9817e-05_r8,3.7275e-05_r8,4.3436e-05_r8,4.6592e-05_r8,4.8428e-05_r8, &
     &4.8930e-05_r8,4.8153e-05_r8,3.7877e-05_r8/)
      kao(:, 3, 4, 2) = (/ &
     &7.3364e-06_r8,3.0199e-05_r8,3.7809e-05_r8,4.3827e-05_r8,4.7553e-05_r8,4.9496e-05_r8, &
     &5.0112e-05_r8,4.9423e-05_r8,3.9242e-05_r8/)
      kao(:, 4, 4, 2) = (/ &
     &7.7623e-06_r8,3.0806e-05_r8,3.8513e-05_r8,4.4137e-05_r8,4.8467e-05_r8,5.0544e-05_r8, &
     &5.1178e-05_r8,5.0627e-05_r8,4.0689e-05_r8/)
      kao(:, 5, 4, 2) = (/ &
     &8.2042e-06_r8,3.1502e-05_r8,3.9409e-05_r8,4.4849e-05_r8,4.9430e-05_r8,5.1580e-05_r8, &
     &5.2292e-05_r8,5.1835e-05_r8,4.2152e-05_r8/)
      kao(:, 1, 5, 2) = (/ &
     &1.0402e-05_r8,3.8540e-05_r8,4.6318e-05_r8,5.0020e-05_r8,5.3672e-05_r8,5.3150e-05_r8, &
     &5.0796e-05_r8,4.5989e-05_r8,3.1155e-05_r8/)
      kao(:, 2, 5, 2) = (/ &
     &1.1085e-05_r8,3.9241e-05_r8,4.7238e-05_r8,5.0920e-05_r8,5.3596e-05_r8,5.4294e-05_r8, &
     &5.2010e-05_r8,4.7261e-05_r8,3.2691e-05_r8/)
      kao(:, 3, 5, 2) = (/ &
     &1.1793e-05_r8,3.9912e-05_r8,4.8110e-05_r8,5.1979e-05_r8,5.4361e-05_r8,5.5470e-05_r8, &
     &5.3221e-05_r8,4.8498e-05_r8,3.4229e-05_r8/)
      kao(:, 4, 5, 2) = (/ &
     &1.2505e-05_r8,4.0706e-05_r8,4.8865e-05_r8,5.3127e-05_r8,5.5321e-05_r8,5.6646e-05_r8, &
     &5.4402e-05_r8,4.9696e-05_r8,3.5620e-05_r8/)
      kao(:, 5, 5, 2) = (/ &
     &1.3238e-05_r8,4.1575e-05_r8,5.0157e-05_r8,5.4552e-05_r8,5.6339e-05_r8,5.7036e-05_r8, &
     &5.5608e-05_r8,5.0863e-05_r8,3.6859e-05_r8/)
      kao(:, 1, 6, 2) = (/ &
     &1.5685e-05_r8,4.8160e-05_r8,5.7576e-05_r8,6.0816e-05_r8,6.0795e-05_r8,5.9888e-05_r8, &
     &5.5641e-05_r8,4.7076e-05_r8,2.7125e-05_r8/)
      kao(:, 2, 6, 2) = (/ &
     &1.6746e-05_r8,4.9438e-05_r8,5.8728e-05_r8,6.2091e-05_r8,6.2171e-05_r8,6.0759e-05_r8, &
     &5.6976e-05_r8,4.8239e-05_r8,2.8411e-05_r8/)
      kao(:, 3, 6, 2) = (/ &
     &1.7756e-05_r8,5.0622e-05_r8,5.9836e-05_r8,6.3203e-05_r8,6.3569e-05_r8,6.1458e-05_r8, &
     &5.8288e-05_r8,4.9429e-05_r8,2.9823e-05_r8/)
      kao(:, 4, 6, 2) = (/ &
     &1.8829e-05_r8,5.1859e-05_r8,6.0806e-05_r8,6.4509e-05_r8,6.5119e-05_r8,6.2540e-05_r8, &
     &5.8809e-05_r8,5.0652e-05_r8,3.1085e-05_r8/)
      kao(:, 5, 6, 2) = (/ &
     &1.9856e-05_r8,5.2975e-05_r8,6.2034e-05_r8,6.5989e-05_r8,6.6522e-05_r8,6.3894e-05_r8, &
     &5.9538e-05_r8,5.1853e-05_r8,3.2453e-05_r8/)
      kao(:, 1, 7, 2) = (/ &
     &2.4856e-05_r8,6.4218e-05_r8,7.4055e-05_r8,7.7980e-05_r8,7.5911e-05_r8,7.1057e-05_r8, &
     &6.3849e-05_r8,5.1579e-05_r8,2.5153e-05_r8/)
      kao(:, 2, 7, 2) = (/ &
     &2.6608e-05_r8,6.6305e-05_r8,7.5730e-05_r8,7.9533e-05_r8,7.7616e-05_r8,7.2887e-05_r8, &
     &6.4610e-05_r8,5.2907e-05_r8,2.6881e-05_r8/)
      kao(:, 3, 7, 2) = (/ &
     &2.8288e-05_r8,6.8291e-05_r8,7.7618e-05_r8,8.1185e-05_r8,7.9322e-05_r8,7.4738e-05_r8, &
     &6.5685e-05_r8,5.4242e-05_r8,2.8455e-05_r8/)
      kao(:, 4, 7, 2) = (/ &
     &3.0045e-05_r8,7.0265e-05_r8,7.9536e-05_r8,8.2799e-05_r8,8.1209e-05_r8,7.6305e-05_r8, &
     &6.7186e-05_r8,5.5601e-05_r8,2.9886e-05_r8/)
      kao(:, 5, 7, 2) = (/ &
     &3.1755e-05_r8,7.2003e-05_r8,8.1183e-05_r8,8.4367e-05_r8,8.2925e-05_r8,7.7935e-05_r8, &
     &6.8892e-05_r8,5.5914e-05_r8,3.1298e-05_r8/)
      kao(:, 1, 8, 2) = (/ &
     &4.6308e-05_r8,9.7055e-05_r8,1.0843e-04_r8,1.0990e-04_r8,1.0798e-04_r8,9.8279e-05_r8, &
     &8.2910e-05_r8,6.2908e-05_r8,2.6615e-05_r8/)
      kao(:, 2, 8, 2) = (/ &
     &4.9990e-05_r8,1.0048e-04_r8,1.1189e-04_r8,1.1329e-04_r8,1.1038e-04_r8,1.0108e-04_r8, &
     &8.5246e-05_r8,6.3800e-05_r8,2.8720e-05_r8/)
      kao(:, 3, 8, 2) = (/ &
     &5.3406e-05_r8,1.0353e-04_r8,1.1536e-04_r8,1.1646e-04_r8,1.1270e-04_r8,1.0316e-04_r8, &
     &8.7419e-05_r8,6.5105e-05_r8,3.1055e-05_r8/)
      kao(:, 4, 8, 2) = (/ &
     &5.6634e-05_r8,1.0658e-04_r8,1.1884e-04_r8,1.1968e-04_r8,1.1489e-04_r8,1.0536e-04_r8, &
     &8.9223e-05_r8,6.6739e-05_r8,3.2877e-05_r8/)
      kao(:, 5, 8, 2) = (/ &
     &5.9979e-05_r8,1.0942e-04_r8,1.2217e-04_r8,1.2302e-04_r8,1.1760e-04_r8,1.0763e-04_r8, &
     &9.1750e-05_r8,6.8524e-05_r8,3.4517e-05_r8/)
      kao(:, 1, 9, 2) = (/ &
     &1.6574e-04_r8,2.3675e-04_r8,2.5425e-04_r8,2.5367e-04_r8,2.3792e-04_r8,2.1003e-04_r8, &
     &1.7177e-04_r8,1.1936e-04_r8,3.2512e-05_r8/)
      kao(:, 2, 9, 2) = (/ &
     &1.7873e-04_r8,2.4657e-04_r8,2.6302e-04_r8,2.6299e-04_r8,2.4679e-04_r8,2.1704e-04_r8, &
     &1.7629e-04_r8,1.2297e-04_r8,3.4956e-05_r8/)
      kao(:, 3, 9, 2) = (/ &
     &1.9203e-04_r8,2.5827e-04_r8,2.7104e-04_r8,2.7133e-04_r8,2.5463e-04_r8,2.2408e-04_r8, &
     &1.8102e-04_r8,1.2579e-04_r8,3.6986e-05_r8/)
      kao(:, 4, 9, 2) = (/ &
     &2.0457e-04_r8,2.7047e-04_r8,2.8009e-04_r8,2.7979e-04_r8,2.6236e-04_r8,2.3082e-04_r8, &
     &1.8610e-04_r8,1.2867e-04_r8,3.9201e-05_r8/)
      kao(:, 5, 9, 2) = (/ &
     &2.1654e-04_r8,2.8311e-04_r8,2.9060e-04_r8,2.8789e-04_r8,2.7019e-04_r8,2.3757e-04_r8, &
     &1.9128e-04_r8,1.3157e-04_r8,4.1162e-05_r8/)
      kao(:, 1,10, 2) = (/ &
     &6.9835e-04_r8,7.7425e-04_r8,7.4212e-04_r8,6.8606e-04_r8,6.1917e-04_r8,5.3712e-04_r8, &
     &4.2860e-04_r8,2.7889e-04_r8,3.4936e-05_r8/)
      kao(:, 2,10, 2) = (/ &
     &7.4976e-04_r8,8.1587e-04_r8,7.7895e-04_r8,7.1764e-04_r8,6.4311e-04_r8,5.5763e-04_r8, &
     &4.4404e-04_r8,2.8872e-04_r8,3.8434e-05_r8/)
      kao(:, 3,10, 2) = (/ &
     &8.0421e-04_r8,8.6133e-04_r8,8.1873e-04_r8,7.5123e-04_r8,6.6805e-04_r8,5.7460e-04_r8, &
     &4.5895e-04_r8,2.9845e-04_r8,4.2197e-05_r8/)
      kao(:, 4,10, 2) = (/ &
     &8.5541e-04_r8,9.0651e-04_r8,8.6169e-04_r8,7.8842e-04_r8,6.9649e-04_r8,5.9375e-04_r8, &
     &4.7283e-04_r8,3.0790e-04_r8,4.6109e-05_r8/)
      kao(:, 5,10, 2) = (/ &
     &9.0554e-04_r8,9.5112e-04_r8,9.0374e-04_r8,8.2600e-04_r8,7.2587e-04_r8,6.1366e-04_r8, &
     &4.8709e-04_r8,3.1697e-04_r8,4.9839e-05_r8/)
      kao(:, 1,11, 2) = (/ &
     &1.0573e-03_r8,1.1046e-03_r8,1.0331e-03_r8,9.3641e-04_r8,8.2149e-04_r8,6.9220e-04_r8, &
     &5.4269e-04_r8,3.5137e-04_r8,3.2311e-05_r8/)
      kao(:, 2,11, 2) = (/ &
     &1.1354e-03_r8,1.1699e-03_r8,1.0957e-03_r8,9.8791e-04_r8,8.6081e-04_r8,7.2123e-04_r8, &
     &5.6428e-04_r8,3.6441e-04_r8,3.5797e-05_r8/)
      kao(:, 3,11, 2) = (/ &
     &1.2157e-03_r8,1.2370e-03_r8,1.1565e-03_r8,1.0415e-03_r8,9.0546e-04_r8,7.4993e-04_r8, &
     &5.8345e-04_r8,3.7768e-04_r8,3.9564e-05_r8/)
      kao(:, 4,11, 2) = (/ &
     &1.2894e-03_r8,1.3041e-03_r8,1.2183e-03_r8,1.0951e-03_r8,9.4833e-04_r8,7.8292e-04_r8, &
     &6.0424e-04_r8,3.8988e-04_r8,4.3105e-05_r8/)
      kao(:, 5,11, 2) = (/ &
     &1.3602e-03_r8,1.3714e-03_r8,1.2775e-03_r8,1.1464e-03_r8,9.9122e-04_r8,8.1361e-04_r8, &
     &6.2375e-04_r8,4.0138e-04_r8,4.6502e-05_r8/)
      kao(:, 1,12, 2) = (/ &
     &1.1559e-03_r8,1.1821e-03_r8,1.1002e-03_r8,9.8760e-04_r8,8.5869e-04_r8,7.1597e-04_r8, &
     &5.5368e-04_r8,3.5629e-04_r8,2.8926e-05_r8/)
      kao(:, 2,12, 2) = (/ &
     &1.2387e-03_r8,1.2530e-03_r8,1.1642e-03_r8,1.0435e-03_r8,9.0422e-04_r8,7.4802e-04_r8, &
     &5.7617e-04_r8,3.7052e-04_r8,3.1589e-05_r8/)
      kao(:, 3,12, 2) = (/ &
     &1.3216e-03_r8,1.3229e-03_r8,1.2283e-03_r8,1.1015e-03_r8,9.5193e-04_r8,7.8187e-04_r8, &
     &5.9954e-04_r8,3.8460e-04_r8,3.4577e-05_r8/)
      kao(:, 4,12, 2) = (/ &
     &1.3983e-03_r8,1.3942e-03_r8,1.2931e-03_r8,1.1587e-03_r8,9.9709e-04_r8,8.1633e-04_r8, &
     &6.2085e-04_r8,3.9719e-04_r8,3.7982e-05_r8/)
      kao(:, 5,12, 2) = (/ &
     &1.4751e-03_r8,1.4634e-03_r8,1.3557e-03_r8,1.2116e-03_r8,1.0389e-03_r8,8.4961e-04_r8, &
     &6.4030e-04_r8,4.0878e-04_r8,4.0969e-05_r8/)
      kao(:, 1,13, 2) = (/ &
     &1.0038e-03_r8,1.0239e-03_r8,9.5244e-04_r8,8.5524e-04_r8,7.4348e-04_r8,6.2001e-04_r8, &
     &4.7929e-04_r8,3.0767e-04_r8,2.4695e-05_r8/)
      kao(:, 2,13, 2) = (/ &
     &1.0734e-03_r8,1.0865e-03_r8,1.0094e-03_r8,9.0484e-04_r8,7.8346e-04_r8,6.4723e-04_r8, &
     &4.9815e-04_r8,3.1985e-04_r8,2.6858e-05_r8/)
      kao(:, 3,13, 2) = (/ &
     &1.1391e-03_r8,1.1434e-03_r8,1.0621e-03_r8,9.5239e-04_r8,8.2130e-04_r8,6.7579e-04_r8, &
     &5.1796e-04_r8,3.3140e-04_r8,2.9385e-05_r8/)
      kao(:, 4,13, 2) = (/ &
     &1.2032e-03_r8,1.2025e-03_r8,1.1163e-03_r8,9.9786e-04_r8,8.5960e-04_r8,7.0590e-04_r8, &
     &5.3619e-04_r8,3.4228e-04_r8,3.2189e-05_r8/)
      kao(:, 5,13, 2) = (/ &
     &1.2690e-03_r8,1.2617e-03_r8,1.1676e-03_r8,1.0418e-03_r8,8.9504e-04_r8,7.3293e-04_r8, &
     &5.5106e-04_r8,3.5176e-04_r8,3.4791e-05_r8/)
      kao(:, 1, 1, 3) = (/ &
     &3.4054e-06_r8,3.6169e-05_r8,5.7781e-05_r8,7.9702e-05_r8,9.9450e-05_r8,1.1908e-04_r8, &
     &1.4021e-04_r8,1.6904e-04_r8,1.5965e-04_r8/)
      kao(:, 2, 1, 3) = (/ &
     &3.5406e-06_r8,3.7213e-05_r8,5.9148e-05_r8,7.9930e-05_r8,1.0281e-04_r8,1.2326e-04_r8, &
     &1.4516e-04_r8,1.7473e-04_r8,1.6518e-04_r8/)
      kao(:, 3, 1, 3) = (/ &
     &3.6962e-06_r8,3.8392e-05_r8,6.0628e-05_r8,8.1614e-05_r8,1.0332e-04_r8,1.2805e-04_r8, &
     &1.5083e-04_r8,1.8127e-04_r8,1.7179e-04_r8/)
      kao(:, 4, 1, 3) = (/ &
     &3.8150e-06_r8,3.9649e-05_r8,6.2587e-05_r8,8.4276e-05_r8,1.0580e-04_r8,1.2950e-04_r8, &
     &1.5730e-04_r8,1.8884e-04_r8,1.7648e-04_r8/)
      kao(:, 5, 1, 3) = (/ &
     &3.9425e-06_r8,4.0895e-05_r8,6.4628e-05_r8,8.7067e-05_r8,1.0971e-04_r8,1.3287e-04_r8, &
     &1.5979e-04_r8,1.9707e-04_r8,1.8056e-04_r8/)
      kao(:, 1, 2, 3) = (/ &
     &4.7659e-06_r8,3.7672e-05_r8,5.6772e-05_r8,7.4964e-05_r8,9.3354e-05_r8,1.1163e-04_r8, &
     &1.2805e-04_r8,1.4897e-04_r8,1.4118e-04_r8/)
      kao(:, 2, 2, 3) = (/ &
     &4.9285e-06_r8,3.8459e-05_r8,5.8331e-05_r8,7.6310e-05_r8,9.3490e-05_r8,1.1292e-04_r8, &
     &1.3218e-04_r8,1.5402e-04_r8,1.4609e-04_r8/)
      kao(:, 3, 2, 3) = (/ &
     &5.1241e-06_r8,3.9569e-05_r8,6.0060e-05_r8,7.8269e-05_r8,9.6361e-05_r8,1.1403e-04_r8, &
     &1.3730e-04_r8,1.5986e-04_r8,1.4966e-04_r8/)
      kao(:, 4, 2, 3) = (/ &
     &5.2863e-06_r8,4.0536e-05_r8,6.2133e-05_r8,8.0760e-05_r8,9.8821e-05_r8,1.1724e-04_r8, &
     &1.3737e-04_r8,1.6656e-04_r8,1.5208e-04_r8/)
      kao(:, 5, 2, 3) = (/ &
     &5.4310e-06_r8,4.1540e-05_r8,6.3967e-05_r8,8.3433e-05_r8,1.0178e-04_r8,1.2080e-04_r8, &
     &1.4142e-04_r8,1.7063e-04_r8,1.5631e-04_r8/)
      kao(:, 1, 3, 3) = (/ &
     &8.9186e-06_r8,4.5407e-05_r8,6.3526e-05_r8,7.8550e-05_r8,9.1618e-05_r8,1.0496e-04_r8, &
     &1.2158e-04_r8,1.3284e-04_r8,1.2340e-04_r8/)
      kao(:, 2, 3, 3) = (/ &
     &9.2443e-06_r8,4.6508e-05_r8,6.4784e-05_r8,8.0506e-05_r8,9.3613e-05_r8,1.0642e-04_r8, &
     &1.2005e-04_r8,1.3711e-04_r8,1.2632e-04_r8/)
      kao(:, 3, 3, 3) = (/ &
     &9.5550e-06_r8,4.7677e-05_r8,6.6548e-05_r8,8.2736e-05_r8,9.6188e-05_r8,1.0877e-04_r8, &
     &1.2156e-04_r8,1.4196e-04_r8,1.2696e-04_r8/)
      kao(:, 4, 3, 3) = (/ &
     &9.9051e-06_r8,4.8778e-05_r8,6.8112e-05_r8,8.4988e-05_r8,9.9246e-05_r8,1.1223e-04_r8, &
     &1.2463e-04_r8,1.4159e-04_r8,1.2947e-04_r8/)
      kao(:, 5, 3, 3) = (/ &
     &1.0162e-05_r8,4.9942e-05_r8,6.9999e-05_r8,8.7421e-05_r8,1.0238e-04_r8,1.1576e-04_r8, &
     &1.2839e-04_r8,1.4461e-04_r8,1.3351e-04_r8/)
      kao(:, 1, 4, 3) = (/ &
     &1.6753e-05_r8,5.8237e-05_r8,7.6272e-05_r8,8.8204e-05_r8,9.8762e-05_r8,1.0698e-04_r8, &
     &1.1349e-04_r8,1.2379e-04_r8,1.0697e-04_r8/)
      kao(:, 2, 4, 3) = (/ &
     &1.7441e-05_r8,5.9610e-05_r8,7.7972e-05_r8,9.0358e-05_r8,1.0097e-04_r8,1.0919e-04_r8, &
     &1.1491e-04_r8,1.2294e-04_r8,1.0628e-04_r8/)
      kao(:, 3, 4, 3) = (/ &
     &1.8082e-05_r8,6.1175e-05_r8,7.9988e-05_r8,9.2267e-05_r8,1.0332e-04_r8,1.1211e-04_r8, &
     &1.1776e-04_r8,1.2346e-04_r8,1.0729e-04_r8/)
      kao(:, 4, 4, 3) = (/ &
     &1.8658e-05_r8,6.2685e-05_r8,8.1816e-05_r8,9.5481e-05_r8,1.0615e-04_r8,1.1496e-04_r8, &
     &1.2097e-04_r8,1.2608e-04_r8,1.1024e-04_r8/)
      kao(:, 5, 4, 3) = (/ &
     &1.9340e-05_r8,6.4673e-05_r8,8.3970e-05_r8,9.8481e-05_r8,1.0873e-04_r8,1.1832e-04_r8, &
     &1.2499e-04_r8,1.2979e-04_r8,1.1362e-04_r8/)
      kao(:, 1, 5, 3) = (/ &
     &2.8523e-05_r8,7.5471e-05_r8,9.2112e-05_r8,1.0383e-04_r8,1.0948e-04_r8,1.1290e-04_r8, &
     &1.1403e-04_r8,1.1277e-04_r8,8.7972e-05_r8/)
      kao(:, 2, 5, 3) = (/ &
     &2.9775e-05_r8,7.7638e-05_r8,9.4306e-05_r8,1.0580e-04_r8,1.1226e-04_r8,1.1540e-04_r8, &
     &1.1664e-04_r8,1.1378e-04_r8,8.7781e-05_r8/)
      kao(:, 3, 5, 3) = (/ &
     &3.1032e-05_r8,7.9995e-05_r8,9.6878e-05_r8,1.0807e-04_r8,1.1530e-04_r8,1.1833e-04_r8, &
     &1.1968e-04_r8,1.1643e-04_r8,8.9738e-05_r8/)
      kao(:, 4, 5, 3) = (/ &
     &3.2122e-05_r8,8.2389e-05_r8,9.9387e-05_r8,1.1070e-04_r8,1.1849e-04_r8,1.2073e-04_r8, &
     &1.2266e-04_r8,1.1931e-04_r8,9.1761e-05_r8/)
      kao(:, 5, 5, 3) = (/ &
     &3.3412e-05_r8,8.5294e-05_r8,1.0214e-04_r8,1.1395e-04_r8,1.2220e-04_r8,1.2513e-04_r8, &
     &1.2589e-04_r8,1.2317e-04_r8,9.4332e-05_r8/)
      kao(:, 1, 6, 3) = (/ &
     &4.4933e-05_r8,9.9737e-05_r8,1.1255e-04_r8,1.2118e-04_r8,1.2554e-04_r8,1.2364e-04_r8, &
     &1.1791e-04_r8,1.0852e-04_r8,7.4135e-05_r8/)
      kao(:, 2, 6, 3) = (/ &
     &4.7071e-05_r8,1.0236e-04_r8,1.1567e-04_r8,1.2397e-04_r8,1.2766e-04_r8,1.2658e-04_r8, &
     &1.2060e-04_r8,1.1056e-04_r8,7.5435e-05_r8/)
      kao(:, 3, 6, 3) = (/ &
     &4.9151e-05_r8,1.0514e-04_r8,1.1921e-04_r8,1.2711e-04_r8,1.3040e-04_r8,1.2992e-04_r8, &
     &1.2331e-04_r8,1.1371e-04_r8,7.6849e-05_r8/)
      kao(:, 4, 6, 3) = (/ &
     &5.1024e-05_r8,1.0807e-04_r8,1.2306e-04_r8,1.3034e-04_r8,1.3370e-04_r8,1.3344e-04_r8, &
     &1.2682e-04_r8,1.1612e-04_r8,7.8630e-05_r8/)
      kao(:, 5, 6, 3) = (/ &
     &5.2854e-05_r8,1.1144e-04_r8,1.2670e-04_r8,1.3361e-04_r8,1.3751e-04_r8,1.3677e-04_r8, &
     &1.3113e-04_r8,1.1903e-04_r8,8.1063e-05_r8/)
      kao(:, 1, 7, 3) = (/ &
     &7.4131e-05_r8,1.3771e-04_r8,1.5135e-04_r8,1.5339e-04_r8,1.5199e-04_r8,1.4542e-04_r8, &
     &1.3212e-04_r8,1.1157e-04_r8,6.3305e-05_r8/)
      kao(:, 2, 7, 3) = (/ &
     &7.8122e-05_r8,1.4080e-04_r8,1.5542e-04_r8,1.5789e-04_r8,1.5525e-04_r8,1.4808e-04_r8, &
     &1.3571e-04_r8,1.1400e-04_r8,6.4305e-05_r8/)
      kao(:, 3, 7, 3) = (/ &
     &8.1792e-05_r8,1.4429e-04_r8,1.5980e-04_r8,1.6259e-04_r8,1.5930e-04_r8,1.5173e-04_r8, &
     &1.3906e-04_r8,1.1682e-04_r8,6.5778e-05_r8/)
      kao(:, 4, 7, 3) = (/ &
     &8.5102e-05_r8,1.4854e-04_r8,1.6447e-04_r8,1.6719e-04_r8,1.6365e-04_r8,1.5623e-04_r8, &
     &1.4249e-04_r8,1.1910e-04_r8,6.8216e-05_r8/)
      kao(:, 5, 7, 3) = (/ &
     &8.8343e-05_r8,1.5302e-04_r8,1.6961e-04_r8,1.7246e-04_r8,1.6859e-04_r8,1.6045e-04_r8, &
     &1.4567e-04_r8,1.2333e-04_r8,7.0812e-05_r8/)
      kao(:, 1, 8, 3) = (/ &
     &1.4407e-04_r8,2.1929e-04_r8,2.3408e-04_r8,2.3175e-04_r8,2.1747e-04_r8,1.9684e-04_r8, &
     &1.7181e-04_r8,1.3227e-04_r8,5.5189e-05_r8/)
      kao(:, 2, 8, 3) = (/ &
     &1.5218e-04_r8,2.2535e-04_r8,2.3947e-04_r8,2.3742e-04_r8,2.2354e-04_r8,2.0175e-04_r8, &
     &1.7481e-04_r8,1.3567e-04_r8,5.7508e-05_r8/)
      kao(:, 3, 8, 3) = (/ &
     &1.5981e-04_r8,2.3168e-04_r8,2.4529e-04_r8,2.4373e-04_r8,2.2990e-04_r8,2.0756e-04_r8, &
     &1.7860e-04_r8,1.3869e-04_r8,5.9914e-05_r8/)
      kao(:, 4, 8, 3) = (/ &
     &1.6710e-04_r8,2.3880e-04_r8,2.5211e-04_r8,2.5020e-04_r8,2.3684e-04_r8,2.1373e-04_r8, &
     &1.8326e-04_r8,1.4183e-04_r8,6.3164e-05_r8/)
      kao(:, 5, 8, 3) = (/ &
     &1.7380e-04_r8,2.4599e-04_r8,2.5929e-04_r8,2.5766e-04_r8,2.4400e-04_r8,2.1994e-04_r8, &
     &1.8763e-04_r8,1.4519e-04_r8,6.6105e-05_r8/)
      kao(:, 1, 9, 3) = (/ &
     &5.2627e-04_r8,6.1534e-04_r8,6.0941e-04_r8,5.7646e-04_r8,5.2415e-04_r8,4.5407e-04_r8, &
     &3.6135e-04_r8,2.4279e-04_r8,6.7993e-05_r8/)
      kao(:, 2, 9, 3) = (/ &
     &5.5864e-04_r8,6.4193e-04_r8,6.3124e-04_r8,5.9396e-04_r8,5.3793e-04_r8,4.6535e-04_r8, &
     &3.7115e-04_r8,2.4862e-04_r8,7.5217e-05_r8/)
      kao(:, 3, 9, 3) = (/ &
     &5.8842e-04_r8,6.6676e-04_r8,6.5277e-04_r8,6.1271e-04_r8,5.5239e-04_r8,4.7636e-04_r8, &
     &3.8150e-04_r8,2.5543e-04_r8,8.1799e-05_r8/)
      kao(:, 4, 9, 3) = (/ &
     &6.1785e-04_r8,6.9166e-04_r8,6.7437e-04_r8,6.3091e-04_r8,5.6815e-04_r8,4.8941e-04_r8, &
     &3.9213e-04_r8,2.6284e-04_r8,8.7598e-05_r8/)
      kao(:, 5, 9, 3) = (/ &
     &6.4520e-04_r8,7.1602e-04_r8,6.9663e-04_r8,6.4913e-04_r8,5.8418e-04_r8,5.0317e-04_r8, &
     &4.0334e-04_r8,2.7060e-04_r8,9.2801e-05_r8/)
      kao(:, 1,10, 3) = (/ &
     &2.1645e-03_r8,2.1618e-03_r8,2.0014e-03_r8,1.7923e-03_r8,1.5495e-03_r8,1.2769e-03_r8, &
     &9.6609e-04_r8,6.0453e-04_r8,1.0410e-04_r8/)
      kao(:, 2,10, 3) = (/ &
     &2.3095e-03_r8,2.2836e-03_r8,2.1017e-03_r8,1.8749e-03_r8,1.6151e-03_r8,1.3240e-03_r8, &
     &9.9711e-04_r8,6.2160e-04_r8,1.1408e-04_r8/)
      kao(:, 3,10, 3) = (/ &
     &2.4464e-03_r8,2.3906e-03_r8,2.1944e-03_r8,1.9559e-03_r8,1.6773e-03_r8,1.3715e-03_r8, &
     &1.0290e-03_r8,6.3832e-04_r8,1.2224e-04_r8/)
      kao(:, 4,10, 3) = (/ &
     &2.5757e-03_r8,2.5009e-03_r8,2.2880e-03_r8,2.0317e-03_r8,1.7417e-03_r8,1.4189e-03_r8, &
     &1.0630e-03_r8,6.5627e-04_r8,1.3004e-04_r8/)
      kao(:, 5,10, 3) = (/ &
     &2.6938e-03_r8,2.6117e-03_r8,2.3825e-03_r8,2.1099e-03_r8,1.8067e-03_r8,1.4685e-03_r8, &
     &1.0955e-03_r8,6.7426e-04_r8,1.3892e-04_r8/)
      kao(:, 1,11, 3) = (/ &
     &3.2925e-03_r8,3.1585e-03_r8,2.8624e-03_r8,2.5152e-03_r8,2.1339e-03_r8,1.7245e-03_r8, &
     &1.2749e-03_r8,7.7353e-04_r8,1.1570e-04_r8/)
      kao(:, 2,11, 3) = (/ &
     &3.4939e-03_r8,3.3275e-03_r8,2.9995e-03_r8,2.6330e-03_r8,2.2285e-03_r8,1.7928e-03_r8, &
     &1.3221e-03_r8,7.9717e-04_r8,1.2609e-04_r8/)
      kao(:, 3,11, 3) = (/ &
     &3.6814e-03_r8,3.4852e-03_r8,3.1333e-03_r8,2.7438e-03_r8,2.3219e-03_r8,1.8667e-03_r8, &
     &1.3711e-03_r8,8.2069e-04_r8,1.3849e-04_r8/)
      kao(:, 4,11, 3) = (/ &
     &3.8717e-03_r8,3.6472e-03_r8,3.2720e-03_r8,2.8608e-03_r8,2.4167e-03_r8,1.9357e-03_r8, &
     &1.4194e-03_r8,8.4717e-04_r8,1.4796e-04_r8/)
      kao(:, 5,11, 3) = (/ &
     &4.0507e-03_r8,3.8076e-03_r8,3.4109e-03_r8,2.9754e-03_r8,2.5103e-03_r8,2.0111e-03_r8, &
     &1.4691e-03_r8,8.7324e-04_r8,1.5498e-04_r8/)
      kao(:, 1,12, 3) = (/ &
     &3.6937e-03_r8,3.5033e-03_r8,3.1460e-03_r8,2.7421e-03_r8,2.3088e-03_r8,1.8436e-03_r8, &
     &1.3493e-03_r8,8.0094e-04_r8,1.1298e-04_r8/)
      kao(:, 2,12, 3) = (/ &
     &3.9154e-03_r8,3.6887e-03_r8,3.2999e-03_r8,2.8717e-03_r8,2.4149e-03_r8,1.9245e-03_r8, &
     &1.4017e-03_r8,8.2771e-04_r8,1.2419e-04_r8/)
      kao(:, 3,12, 3) = (/ &
     &4.1285e-03_r8,3.8698e-03_r8,3.4585e-03_r8,3.0012e-03_r8,2.5199e-03_r8,2.0022e-03_r8, &
     &1.4553e-03_r8,8.5423e-04_r8,1.3225e-04_r8/)
      kao(:, 4,12, 3) = (/ &
     &4.3384e-03_r8,4.0509e-03_r8,3.6103e-03_r8,3.1297e-03_r8,2.6243e-03_r8,2.0861e-03_r8, &
     &1.5110e-03_r8,8.8306e-04_r8,1.4212e-04_r8/)
      kao(:, 5,12, 3) = (/ &
     &4.5406e-03_r8,4.2341e-03_r8,3.7730e-03_r8,3.2693e-03_r8,2.7384e-03_r8,2.1705e-03_r8, &
     &1.5683e-03_r8,9.1255e-04_r8,1.5213e-04_r8/)
      kao(:, 1,13, 3) = (/ &
     &3.2602e-03_r8,3.0914e-03_r8,2.7797e-03_r8,2.4220e-03_r8,2.0389e-03_r8,1.6288e-03_r8, &
     &1.1889e-03_r8,7.0223e-04_r8,9.9450e-05_r8/)
      kao(:, 2,13, 3) = (/ &
     &3.4542e-03_r8,3.2567e-03_r8,2.9218e-03_r8,2.5424e-03_r8,2.1356e-03_r8,1.7009e-03_r8, &
     &1.2356e-03_r8,7.2786e-04_r8,1.0781e-04_r8/)
      kao(:, 3,13, 3) = (/ &
     &3.6454e-03_r8,3.4269e-03_r8,3.0649e-03_r8,2.6592e-03_r8,2.2314e-03_r8,1.7744e-03_r8, &
     &1.2855e-03_r8,7.5225e-04_r8,1.1667e-04_r8/)
      kao(:, 4,13, 3) = (/ &
     &3.8341e-03_r8,3.5875e-03_r8,3.2022e-03_r8,2.7784e-03_r8,2.3283e-03_r8,1.8470e-03_r8, &
     &1.3345e-03_r8,7.7860e-04_r8,1.2556e-04_r8/)
      kao(:, 5,13, 3) = (/ &
     &4.0097e-03_r8,3.7448e-03_r8,3.3397e-03_r8,2.8965e-03_r8,2.4238e-03_r8,1.9205e-03_r8, &
     &1.3873e-03_r8,8.0728e-04_r8,1.3156e-04_r8/)
      kao(:, 1, 1, 4) = (/ &
     &7.6190e-06_r8,7.2707e-05_r8,1.2159e-04_r8,1.6797e-04_r8,2.1749e-04_r8,2.7232e-04_r8, &
     &3.3756e-04_r8,4.5000e-04_r8,3.7863e-04_r8/)
      kao(:, 2, 1, 4) = (/ &
     &7.7938e-06_r8,7.4481e-05_r8,1.2500e-04_r8,1.7416e-04_r8,2.2412e-04_r8,2.7984e-04_r8, &
     &3.4630e-04_r8,4.4903e-04_r8,3.8823e-04_r8/)
      kao(:, 3, 1, 4) = (/ &
     &8.0028e-06_r8,7.6115e-05_r8,1.2829e-04_r8,1.8057e-04_r8,2.3237e-04_r8,2.8607e-04_r8, &
     &3.5506e-04_r8,4.5741e-04_r8,3.9983e-04_r8/)
      kao(:, 4, 1, 4) = (/ &
     &8.1270e-06_r8,7.7997e-05_r8,1.3160e-04_r8,1.8544e-04_r8,2.4027e-04_r8,2.9656e-04_r8, &
     &3.6016e-04_r8,4.6576e-04_r8,4.1176e-04_r8/)
      kao(:, 5, 1, 4) = (/ &
     &8.2916e-06_r8,8.0436e-05_r8,1.3585e-04_r8,1.9127e-04_r8,2.4691e-04_r8,3.0708e-04_r8, &
     &3.7489e-04_r8,4.7422e-04_r8,4.3091e-04_r8/)
      kao(:, 1, 2, 4) = (/ &
     &1.0434e-05_r8,7.3238e-05_r8,1.1625e-04_r8,1.5526e-04_r8,1.9383e-04_r8,2.3419e-04_r8, &
     &2.8405e-04_r8,3.6155e-04_r8,3.1532e-04_r8/)
      kao(:, 2, 2, 4) = (/ &
     &1.0681e-05_r8,7.5036e-05_r8,1.1854e-04_r8,1.5997e-04_r8,2.0074e-04_r8,2.4144e-04_r8, &
     &2.9129e-04_r8,3.7038e-04_r8,3.2501e-04_r8/)
      kao(:, 3, 2, 4) = (/ &
     &1.0988e-05_r8,7.7182e-05_r8,1.2126e-04_r8,1.6374e-04_r8,2.0655e-04_r8,2.5052e-04_r8, &
     &2.9566e-04_r8,3.7520e-04_r8,3.3554e-04_r8/)
      kao(:, 4, 2, 4) = (/ &
     &1.1243e-05_r8,7.9396e-05_r8,1.2452e-04_r8,1.6827e-04_r8,2.1213e-04_r8,2.5807e-04_r8, &
     &3.0951e-04_r8,3.7973e-04_r8,3.4985e-04_r8/)
      kao(:, 5, 2, 4) = (/ &
     &1.1433e-05_r8,8.1733e-05_r8,1.2847e-04_r8,1.7400e-04_r8,2.1976e-04_r8,2.6675e-04_r8, &
     &3.1873e-04_r8,3.9060e-04_r8,3.6531e-04_r8/)
      kao(:, 1, 3, 4) = (/ &
     &1.9121e-05_r8,8.5930e-05_r8,1.2401e-04_r8,1.5771e-04_r8,1.8803e-04_r8,2.1587e-04_r8, &
     &2.4191e-04_r8,2.8659e-04_r8,2.6000e-04_r8/)
      kao(:, 2, 3, 4) = (/ &
     &1.9555e-05_r8,8.7968e-05_r8,1.2724e-04_r8,1.6033e-04_r8,1.9279e-04_r8,2.2305e-04_r8, &
     &2.5217e-04_r8,2.9281e-04_r8,2.6982e-04_r8/)
      kao(:, 3, 3, 4) = (/ &
     &2.0014e-05_r8,9.0319e-05_r8,1.3030e-04_r8,1.6432e-04_r8,1.9658e-04_r8,2.2814e-04_r8, &
     &2.6130e-04_r8,2.9767e-04_r8,2.8111e-04_r8/)
      kao(:, 4, 3, 4) = (/ &
     &2.0629e-05_r8,9.3145e-05_r8,1.3414e-04_r8,1.6939e-04_r8,2.0212e-04_r8,2.3402e-04_r8, &
     &2.6796e-04_r8,3.0992e-04_r8,2.9328e-04_r8/)
      kao(:, 5, 3, 4) = (/ &
     &2.0980e-05_r8,9.5719e-05_r8,1.3796e-04_r8,1.7464e-04_r8,2.0857e-04_r8,2.4205e-04_r8, &
     &2.7670e-04_r8,3.1994e-04_r8,3.0523e-04_r8/)
      kao(:, 1, 4, 4) = (/ &
     &3.5480e-05_r8,1.1130e-04_r8,1.4459e-04_r8,1.7323e-04_r8,1.9468e-04_r8,2.1444e-04_r8, &
     &2.2966e-04_r8,2.4128e-04_r8,2.1617e-04_r8/)
      kao(:, 2, 4, 4) = (/ &
     &3.6323e-05_r8,1.1358e-04_r8,1.4824e-04_r8,1.7664e-04_r8,1.9952e-04_r8,2.1840e-04_r8, &
     &2.3716e-04_r8,2.5075e-04_r8,2.2864e-04_r8/)
      kao(:, 3, 4, 4) = (/ &
     &3.7216e-05_r8,1.1624e-04_r8,1.5219e-04_r8,1.8108e-04_r8,2.0484e-04_r8,2.2378e-04_r8, &
     &2.4107e-04_r8,2.5972e-04_r8,2.3687e-04_r8/)
      kao(:, 4, 4, 4) = (/ &
     &3.8132e-05_r8,1.1926e-04_r8,1.5631e-04_r8,1.8514e-04_r8,2.0992e-04_r8,2.3030e-04_r8, &
     &2.4787e-04_r8,2.6623e-04_r8,2.4575e-04_r8/)
      kao(:, 5, 4, 4) = (/ &
     &3.9332e-05_r8,1.2292e-04_r8,1.6148e-04_r8,1.9104e-04_r8,2.1696e-04_r8,2.3764e-04_r8, &
     &2.5623e-04_r8,2.7468e-04_r8,2.5520e-04_r8/)
      kao(:, 1, 5, 4) = (/ &
     &6.0558e-05_r8,1.4537e-04_r8,1.7679e-04_r8,1.9677e-04_r8,2.1242e-04_r8,2.2290e-04_r8, &
     &2.2712e-04_r8,2.2468e-04_r8,1.8402e-04_r8/)
      kao(:, 2, 5, 4) = (/ &
     &6.2024e-05_r8,1.4763e-04_r8,1.8049e-04_r8,2.0169e-04_r8,2.1740e-04_r8,2.2816e-04_r8, &
     &2.3141e-04_r8,2.3210e-04_r8,1.9363e-04_r8/)
      kao(:, 3, 5, 4) = (/ &
     &6.3560e-05_r8,1.5048e-04_r8,1.8446e-04_r8,2.0674e-04_r8,2.2245e-04_r8,2.3297e-04_r8, &
     &2.3732e-04_r8,2.3625e-04_r8,1.9953e-04_r8/)
      kao(:, 4, 5, 4) = (/ &
     &6.5197e-05_r8,1.5389e-04_r8,1.8956e-04_r8,2.1242e-04_r8,2.2805e-04_r8,2.3893e-04_r8, &
     &2.4394e-04_r8,2.4242e-04_r8,2.0731e-04_r8/)
      kao(:, 5, 5, 4) = (/ &
     &6.7408e-05_r8,1.5860e-04_r8,1.9588e-04_r8,2.1916e-04_r8,2.3481e-04_r8,2.4604e-04_r8, &
     &2.5157e-04_r8,2.5058e-04_r8,2.1479e-04_r8/)
      kao(:, 1, 6, 4) = (/ &
     &9.6086e-05_r8,1.8511e-04_r8,2.1787e-04_r8,2.3286e-04_r8,2.3898e-04_r8,2.3907e-04_r8, &
     &2.3360e-04_r8,2.1667e-04_r8,1.5583e-04_r8/)
      kao(:, 2, 6, 4) = (/ &
     &9.8537e-05_r8,1.8825e-04_r8,2.2157e-04_r8,2.3776e-04_r8,2.4456e-04_r8,2.4422e-04_r8, &
     &2.3850e-04_r8,2.2088e-04_r8,1.6156e-04_r8/)
      kao(:, 3, 6, 4) = (/ &
     &1.0106e-04_r8,1.9192e-04_r8,2.2599e-04_r8,2.4309e-04_r8,2.5072e-04_r8,2.5018e-04_r8, &
     &2.4346e-04_r8,2.2608e-04_r8,1.6736e-04_r8/)
      kao(:, 4, 6, 4) = (/ &
     &1.0368e-04_r8,1.9610e-04_r8,2.3144e-04_r8,2.4948e-04_r8,2.5710e-04_r8,2.5653e-04_r8, &
     &2.4933e-04_r8,2.3314e-04_r8,1.7404e-04_r8/)
      kao(:, 5, 6, 4) = (/ &
     &1.0646e-04_r8,2.0089e-04_r8,2.3770e-04_r8,2.5701e-04_r8,2.6421e-04_r8,2.6433e-04_r8, &
     &2.5582e-04_r8,2.4028e-04_r8,1.7876e-04_r8/)
      kao(:, 1, 7, 4) = (/ &
     &1.6042e-04_r8,2.5585e-04_r8,2.8519e-04_r8,2.9642e-04_r8,2.9350e-04_r8,2.7913e-04_r8, &
     &2.5601e-04_r8,2.2211e-04_r8,1.3626e-04_r8/)
      kao(:, 2, 7, 4) = (/ &
     &1.6465e-04_r8,2.6056e-04_r8,2.8988e-04_r8,3.0133e-04_r8,2.9907e-04_r8,2.8588e-04_r8, &
     &2.6187e-04_r8,2.2729e-04_r8,1.4135e-04_r8/)
      kao(:, 3, 7, 4) = (/ &
     &1.6901e-04_r8,2.6578e-04_r8,2.9572e-04_r8,3.0741e-04_r8,3.0551e-04_r8,2.9184e-04_r8, &
     &2.6817e-04_r8,2.3205e-04_r8,1.4656e-04_r8/)
      kao(:, 4, 7, 4) = (/ &
     &1.7367e-04_r8,2.7110e-04_r8,3.0239e-04_r8,3.1497e-04_r8,3.1315e-04_r8,2.9895e-04_r8, &
     &2.7506e-04_r8,2.3781e-04_r8,1.5059e-04_r8/)
      kao(:, 5, 7, 4) = (/ &
     &1.7865e-04_r8,2.7756e-04_r8,3.1008e-04_r8,3.2315e-04_r8,3.2186e-04_r8,3.0753e-04_r8, &
     &2.8375e-04_r8,2.4404e-04_r8,1.5550e-04_r8/)
      kao(:, 1, 8, 4) = (/ &
     &3.1654e-04_r8,4.1629e-04_r8,4.3839e-04_r8,4.3773e-04_r8,4.1826e-04_r8,3.8213e-04_r8, &
     &3.2793e-04_r8,2.5576e-04_r8,1.2647e-04_r8/)
      kao(:, 2, 8, 4) = (/ &
     &3.2537e-04_r8,4.2537e-04_r8,4.4661e-04_r8,4.4494e-04_r8,4.2500e-04_r8,3.8879e-04_r8, &
     &3.3490e-04_r8,2.6206e-04_r8,1.2938e-04_r8/)
      kao(:, 3, 8, 4) = (/ &
     &3.3408e-04_r8,4.3504e-04_r8,4.5626e-04_r8,4.5382e-04_r8,4.3360e-04_r8,3.9751e-04_r8, &
     &3.4272e-04_r8,2.6854e-04_r8,1.3239e-04_r8/)
      kao(:, 4, 8, 4) = (/ &
     &3.4318e-04_r8,4.4480e-04_r8,4.6645e-04_r8,4.6411e-04_r8,4.4358e-04_r8,4.0695e-04_r8, &
     &3.5185e-04_r8,2.7598e-04_r8,1.3521e-04_r8/)
      kao(:, 5, 8, 4) = (/ &
     &3.5364e-04_r8,4.5591e-04_r8,4.7748e-04_r8,4.7551e-04_r8,4.5523e-04_r8,4.1803e-04_r8, &
     &3.6238e-04_r8,2.8454e-04_r8,1.3901e-04_r8/)
      kao(:, 1, 9, 4) = (/ &
     &1.1778e-03_r8,1.2542e-03_r8,1.1993e-03_r8,1.1088e-03_r8,9.9621e-04_r8,8.5814e-04_r8, &
     &6.9027e-04_r8,4.7338e-04_r8,1.4222e-04_r8/)
      kao(:, 2, 9, 4) = (/ &
     &1.2148e-03_r8,1.2865e-03_r8,1.2285e-03_r8,1.1318e-03_r8,1.0140e-03_r8,8.7230e-04_r8, &
     &7.0194e-04_r8,4.8264e-04_r8,1.4691e-04_r8/)
      kao(:, 3, 9, 4) = (/ &
     &1.2493e-03_r8,1.3197e-03_r8,1.2603e-03_r8,1.1590e-03_r8,1.0363e-03_r8,8.9016e-04_r8, &
     &7.1481e-04_r8,4.9330e-04_r8,1.5194e-04_r8/)
      kao(:, 4, 9, 4) = (/ &
     &1.2842e-03_r8,1.3516e-03_r8,1.2898e-03_r8,1.1881e-03_r8,1.0607e-03_r8,9.1030e-04_r8, &
     &7.3056e-04_r8,5.0488e-04_r8,1.5874e-04_r8/)
      kao(:, 5, 9, 4) = (/ &
     &1.3233e-03_r8,1.3878e-03_r8,1.3225e-03_r8,1.2203e-03_r8,1.0882e-03_r8,9.3354e-04_r8, &
     &7.4949e-04_r8,5.1819e-04_r8,1.6715e-04_r8/)
      kao(:, 1,10, 4) = (/ &
     &4.9223e-03_r8,4.6924e-03_r8,4.2372e-03_r8,3.7210e-03_r8,3.1598e-03_r8,2.5466e-03_r8, &
     &1.8894e-03_r8,1.1610e-03_r8,2.5902e-04_r8/)
      kao(:, 2,10, 4) = (/ &
     &5.1019e-03_r8,4.8420e-03_r8,4.3700e-03_r8,3.8242e-03_r8,3.2382e-03_r8,2.6075e-03_r8, &
     &1.9274e-03_r8,1.1773e-03_r8,2.7993e-04_r8/)
      kao(:, 3,10, 4) = (/ &
     &5.2624e-03_r8,4.9912e-03_r8,4.4976e-03_r8,3.9326e-03_r8,3.3295e-03_r8,2.6789e-03_r8, &
     &1.9739e-03_r8,1.2013e-03_r8,2.9275e-04_r8/)
      kao(:, 4,10, 4) = (/ &
     &5.4202e-03_r8,5.1325e-03_r8,4.6211e-03_r8,4.0415e-03_r8,3.4179e-03_r8,2.7474e-03_r8, &
     &2.0231e-03_r8,1.2303e-03_r8,3.0514e-04_r8/)
      kao(:, 5,10, 4) = (/ &
     &5.5922e-03_r8,5.2716e-03_r8,4.7430e-03_r8,4.1489e-03_r8,3.5047e-03_r8,2.8180e-03_r8, &
     &2.0794e-03_r8,1.2643e-03_r8,3.1858e-04_r8/)
      kao(:, 1,11, 4) = (/ &
     &7.2623e-03_r8,6.7979e-03_r8,6.0744e-03_r8,5.2843e-03_r8,4.4298e-03_r8,3.5303e-03_r8, &
     &2.5670e-03_r8,1.5127e-03_r8,3.1480e-04_r8/)
      kao(:, 2,11, 4) = (/ &
     &7.5607e-03_r8,7.0506e-03_r8,6.2894e-03_r8,5.4629e-03_r8,4.5682e-03_r8,3.6306e-03_r8, &
     &2.6328e-03_r8,1.5436e-03_r8,3.2537e-04_r8/)
      kao(:, 3,11, 4) = (/ &
     &7.8471e-03_r8,7.2956e-03_r8,6.4988e-03_r8,5.6385e-03_r8,4.7125e-03_r8,3.7379e-03_r8, &
     &2.7029e-03_r8,1.5776e-03_r8,3.3231e-04_r8/)
      kao(:, 4,11, 4) = (/ &
     &8.1128e-03_r8,7.5290e-03_r8,6.7020e-03_r8,5.8093e-03_r8,4.8535e-03_r8,3.8422e-03_r8, &
     &2.7753e-03_r8,1.6189e-03_r8,3.4203e-04_r8/)
      kao(:, 5,11, 4) = (/ &
     &8.3759e-03_r8,7.7545e-03_r8,6.8899e-03_r8,5.9710e-03_r8,4.9875e-03_r8,3.9509e-03_r8, &
     &2.8575e-03_r8,1.6684e-03_r8,3.5725e-04_r8/)
      kao(:, 1,12, 4) = (/ &
     &8.0096e-03_r8,7.4190e-03_r8,6.5933e-03_r8,5.7152e-03_r8,4.7757e-03_r8,3.7806e-03_r8, &
     &2.7237e-03_r8,1.5850e-03_r8,3.0906e-04_r8/)
      kao(:, 2,12, 4) = (/ &
     &8.3245e-03_r8,7.6924e-03_r8,6.8377e-03_r8,5.9147e-03_r8,4.9319e-03_r8,3.8997e-03_r8, &
     &2.8053e-03_r8,1.6213e-03_r8,3.1505e-04_r8/)
      kao(:, 3,12, 4) = (/ &
     &8.6504e-03_r8,7.9748e-03_r8,7.0681e-03_r8,6.1123e-03_r8,5.0902e-03_r8,4.0202e-03_r8, &
     &2.8850e-03_r8,1.6649e-03_r8,3.2236e-04_r8/)
      kao(:, 4,12, 4) = (/ &
     &8.9354e-03_r8,8.2303e-03_r8,7.2913e-03_r8,6.2946e-03_r8,5.2436e-03_r8,4.1358e-03_r8, &
     &2.9697e-03_r8,1.7144e-03_r8,3.2906e-04_r8/)
      kao(:, 5,12, 4) = (/ &
     &9.2169e-03_r8,8.4842e-03_r8,7.5093e-03_r8,6.4790e-03_r8,5.3967e-03_r8,4.2618e-03_r8, &
     &3.0601e-03_r8,1.7687e-03_r8,3.3757e-04_r8/)
      kao(:, 1,13, 4) = (/ &
     &7.1631e-03_r8,6.6319e-03_r8,5.8920e-03_r8,5.0960e-03_r8,4.2500e-03_r8,3.3594e-03_r8, &
     &2.4169e-03_r8,1.3985e-03_r8,2.7237e-04_r8/)
      kao(:, 2,13, 4) = (/ &
     &7.4650e-03_r8,6.8721e-03_r8,6.1020e-03_r8,5.2700e-03_r8,4.3954e-03_r8,3.4698e-03_r8, &
     &2.4897e-03_r8,1.4341e-03_r8,2.7736e-04_r8/)
      kao(:, 3,13, 4) = (/ &
     &7.7609e-03_r8,7.1282e-03_r8,6.3106e-03_r8,5.4462e-03_r8,4.5330e-03_r8,3.5736e-03_r8, &
     &2.5636e-03_r8,1.4770e-03_r8,2.8124e-04_r8/)
      kao(:, 4,13, 4) = (/ &
     &8.0101e-03_r8,7.3618e-03_r8,6.5123e-03_r8,5.6158e-03_r8,4.6733e-03_r8,3.6861e-03_r8, &
     &2.6445e-03_r8,1.5233e-03_r8,2.8716e-04_r8/)
      kao(:, 5,13, 4) = (/ &
     &8.2606e-03_r8,7.6008e-03_r8,6.7314e-03_r8,5.7990e-03_r8,4.8288e-03_r8,3.8083e-03_r8, &
     &2.7261e-03_r8,1.5712e-03_r8,2.9686e-04_r8/)
      kao(:, 1, 1, 5) = (/ &
     &1.3739e-05_r8,1.5137e-04_r8,2.5878e-04_r8,3.6225e-04_r8,4.6522e-04_r8,5.7109e-04_r8, &
     &6.9199e-04_r8,8.4168e-04_r8,8.0480e-04_r8/)
      kao(:, 2, 1, 5) = (/ &
     &1.3888e-05_r8,1.5627e-04_r8,2.6885e-04_r8,3.7698e-04_r8,4.8125e-04_r8,5.9114e-04_r8, &
     &7.1164e-04_r8,8.7936e-04_r8,8.3421e-04_r8/)
      kao(:, 3, 1, 5) = (/ &
     &1.4142e-05_r8,1.6264e-04_r8,2.8096e-04_r8,3.9281e-04_r8,5.0319e-04_r8,6.1580e-04_r8, &
     &7.3800e-04_r8,9.1340e-04_r8,8.6788e-04_r8/)
      kao(:, 4, 1, 5) = (/ &
     &1.4278e-05_r8,1.6909e-04_r8,2.9347e-04_r8,4.1125e-04_r8,5.2641e-04_r8,6.4515e-04_r8, &
     &7.7492e-04_r8,9.4989e-04_r8,9.0996e-04_r8/)
      kao(:, 5, 1, 5) = (/ &
     &1.4494e-05_r8,1.7605e-04_r8,3.0657e-04_r8,4.3067e-04_r8,5.5274e-04_r8,6.7670e-04_r8, &
     &8.1211e-04_r8,9.9682e-04_r8,9.5292e-04_r8/)
      kao(:, 1, 2, 5) = (/ &
     &1.8692e-05_r8,1.5213e-04_r8,2.4704e-04_r8,3.3748e-04_r8,4.2434e-04_r8,5.1189e-04_r8, &
     &6.0610e-04_r8,7.3668e-04_r8,6.9411e-04_r8/)
      kao(:, 2, 2, 5) = (/ &
     &1.8918e-05_r8,1.5679e-04_r8,2.5663e-04_r8,3.5044e-04_r8,4.4175e-04_r8,5.3243e-04_r8, &
     &6.2710e-04_r8,7.5567e-04_r8,7.2022e-04_r8/)
      kao(:, 3, 2, 5) = (/ &
     &1.9322e-05_r8,1.6205e-04_r8,2.6764e-04_r8,3.6642e-04_r8,4.6108e-04_r8,5.5570e-04_r8, &
     &6.5662e-04_r8,7.8535e-04_r8,7.5176e-04_r8/)
      kao(:, 4, 2, 5) = (/ &
     &1.9585e-05_r8,1.6765e-04_r8,2.7850e-04_r8,3.8286e-04_r8,4.8359e-04_r8,5.8272e-04_r8, &
     &6.8652e-04_r8,8.2260e-04_r8,7.8717e-04_r8/)
      kao(:, 5, 2, 5) = (/ &
     &1.9818e-05_r8,1.7339e-04_r8,2.8992e-04_r8,3.9889e-04_r8,5.0485e-04_r8,6.1010e-04_r8, &
     &7.2141e-04_r8,8.6363e-04_r8,8.2436e-04_r8/)
      kao(:, 1, 3, 5) = (/ &
     &3.4262e-05_r8,1.7533e-04_r8,2.6113e-04_r8,3.3571e-04_r8,4.0540e-04_r8,4.7229e-04_r8, &
     &5.3818e-04_r8,6.1661e-04_r8,5.8845e-04_r8/)
      kao(:, 2, 3, 5) = (/ &
     &3.4716e-05_r8,1.7923e-04_r8,2.6899e-04_r8,3.4836e-04_r8,4.2096e-04_r8,4.9023e-04_r8, &
     &5.6025e-04_r8,6.3703e-04_r8,6.0869e-04_r8/)
      kao(:, 3, 3, 5) = (/ &
     &3.5292e-05_r8,1.8347e-04_r8,2.7811e-04_r8,3.6147e-04_r8,4.3915e-04_r8,5.1242e-04_r8, &
     &5.8378e-04_r8,6.6557e-04_r8,6.3564e-04_r8/)
      kao(:, 4, 3, 5) = (/ &
     &3.6120e-05_r8,1.8884e-04_r8,2.8797e-04_r8,3.7545e-04_r8,4.5740e-04_r8,5.3560e-04_r8, &
     &6.1221e-04_r8,6.9822e-04_r8,6.6452e-04_r8/)
      kao(:, 5, 3, 5) = (/ &
     &3.6636e-05_r8,1.9428e-04_r8,2.9738e-04_r8,3.9013e-04_r8,4.7606e-04_r8,5.5790e-04_r8, &
     &6.3990e-04_r8,7.3219e-04_r8,6.9591e-04_r8/)
      kao(:, 1, 4, 5) = (/ &
     &6.3937e-05_r8,2.1416e-04_r8,2.9895e-04_r8,3.6305e-04_r8,4.1697e-04_r8,4.6136e-04_r8, &
     &4.9950e-04_r8,5.3752e-04_r8,4.9755e-04_r8/)
      kao(:, 2, 4, 5) = (/ &
     &6.4891e-05_r8,2.1788e-04_r8,3.0564e-04_r8,3.7373e-04_r8,4.2957e-04_r8,4.7819e-04_r8, &
     &5.1730e-04_r8,5.5769e-04_r8,5.1340e-04_r8/)
      kao(:, 3, 4, 5) = (/ &
     &6.5931e-05_r8,2.2256e-04_r8,3.1273e-04_r8,3.8551e-04_r8,4.4411e-04_r8,4.9569e-04_r8, &
     &5.4027e-04_r8,5.8134e-04_r8,5.3558e-04_r8/)
      kao(:, 4, 4, 5) = (/ &
     &6.7204e-05_r8,2.2716e-04_r8,3.2137e-04_r8,3.9776e-04_r8,4.6059e-04_r8,5.1431e-04_r8, &
     &5.6246e-04_r8,6.0834e-04_r8,5.5897e-04_r8/)
      kao(:, 5, 4, 5) = (/ &
     &6.9088e-05_r8,2.3323e-04_r8,3.3076e-04_r8,4.1010e-04_r8,4.7742e-04_r8,5.3504e-04_r8, &
     &5.8525e-04_r8,6.3600e-04_r8,5.8418e-04_r8/)
      kao(:, 1, 5, 5) = (/ &
     &1.0861e-04_r8,2.6518e-04_r8,3.4675e-04_r8,4.0531e-04_r8,4.4642e-04_r8,4.7448e-04_r8, &
     &4.8963e-04_r8,4.9041e-04_r8,4.2330e-04_r8/)
      kao(:, 2, 5, 5) = (/ &
     &1.1058e-04_r8,2.6952e-04_r8,3.5268e-04_r8,4.1375e-04_r8,4.5888e-04_r8,4.8791e-04_r8, &
     &5.0614e-04_r8,5.0767e-04_r8,4.3569e-04_r8/)
      kao(:, 3, 5, 5) = (/ &
     &1.1255e-04_r8,2.7465e-04_r8,3.6022e-04_r8,4.2322e-04_r8,4.7137e-04_r8,5.0379e-04_r8, &
     &5.2287e-04_r8,5.2860e-04_r8,4.5259e-04_r8/)
      kao(:, 4, 5, 5) = (/ &
     &1.1490e-04_r8,2.8064e-04_r8,3.6839e-04_r8,4.3377e-04_r8,4.8454e-04_r8,5.2116e-04_r8, &
     &5.4180e-04_r8,5.5017e-04_r8,4.7054e-04_r8/)
      kao(:, 5, 5, 5) = (/ &
     &1.1845e-04_r8,2.8778e-04_r8,3.7745e-04_r8,4.4611e-04_r8,4.9985e-04_r8,5.3937e-04_r8, &
     &5.6277e-04_r8,5.7154e-04_r8,4.9105e-04_r8/)
      kao(:, 1, 6, 5) = (/ &
     &1.7235e-04_r8,3.3181e-04_r8,4.0736e-04_r8,4.5766e-04_r8,4.8926e-04_r8,5.0113e-04_r8, &
     &4.9597e-04_r8,4.6976e-04_r8,3.5862e-04_r8/)
      kao(:, 2, 6, 5) = (/ &
     &1.7547e-04_r8,3.3667e-04_r8,4.1414e-04_r8,4.6509e-04_r8,4.9861e-04_r8,5.1384e-04_r8, &
     &5.0976e-04_r8,4.8537e-04_r8,3.6976e-04_r8/)
      kao(:, 3, 6, 5) = (/ &
     &1.7903e-04_r8,3.4304e-04_r8,4.2198e-04_r8,4.7494e-04_r8,5.0792e-04_r8,5.2713e-04_r8, &
     &5.2630e-04_r8,5.0120e-04_r8,3.8272e-04_r8/)
      kao(:, 4, 6, 5) = (/ &
     &1.8326e-04_r8,3.5076e-04_r8,4.3097e-04_r8,4.8545e-04_r8,5.2030e-04_r8,5.4158e-04_r8, &
     &5.4362e-04_r8,5.1767e-04_r8,3.9660e-04_r8/)
      kao(:, 5, 6, 5) = (/ &
     &1.8798e-04_r8,3.5938e-04_r8,4.4150e-04_r8,4.9742e-04_r8,5.3429e-04_r8,5.5639e-04_r8, &
     &5.6101e-04_r8,5.3674e-04_r8,4.1415e-04_r8/)
      kao(:, 1, 7, 5) = (/ &
     &2.9155e-04_r8,4.4941e-04_r8,5.1334e-04_r8,5.5160e-04_r8,5.6796e-04_r8,5.6534e-04_r8, &
     &5.3624e-04_r8,4.7508e-04_r8,3.0367e-04_r8/)
      kao(:, 2, 7, 5) = (/ &
     &2.9728e-04_r8,4.5662e-04_r8,5.2104e-04_r8,5.6062e-04_r8,5.7827e-04_r8,5.7448e-04_r8, &
     &5.4737e-04_r8,4.8748e-04_r8,3.1275e-04_r8/)
      kao(:, 3, 7, 5) = (/ &
     &3.0362e-04_r8,4.6646e-04_r8,5.3089e-04_r8,5.7148e-04_r8,5.9016e-04_r8,5.8669e-04_r8, &
     &5.6081e-04_r8,5.0270e-04_r8,3.2221e-04_r8/)
      kao(:, 4, 7, 5) = (/ &
     &3.1074e-04_r8,4.7852e-04_r8,5.4299e-04_r8,5.8375e-04_r8,6.0313e-04_r8,6.0067e-04_r8, &
     &5.7534e-04_r8,5.1934e-04_r8,3.3373e-04_r8/)
      kao(:, 5, 7, 5) = (/ &
     &3.1895e-04_r8,4.9180e-04_r8,5.5670e-04_r8,5.9847e-04_r8,6.1763e-04_r8,6.1617e-04_r8, &
     &5.9045e-04_r8,5.3590e-04_r8,3.4594e-04_r8/)
      kao(:, 1, 8, 5) = (/ &
     &5.8477e-04_r8,7.4431e-04_r8,7.7278e-04_r8,7.7426e-04_r8,7.5736e-04_r8,7.1816e-04_r8, &
     &6.5106e-04_r8,5.3737e-04_r8,2.7725e-04_r8/)
      kao(:, 2, 8, 5) = (/ &
     &5.9470e-04_r8,7.5491e-04_r8,7.8490e-04_r8,7.8595e-04_r8,7.6803e-04_r8,7.3022e-04_r8, &
     &6.6291e-04_r8,5.4897e-04_r8,2.8497e-04_r8/)
      kao(:, 3, 8, 5) = (/ &
     &6.0851e-04_r8,7.7097e-04_r8,8.0204e-04_r8,8.0136e-04_r8,7.8218e-04_r8,7.4418e-04_r8, &
     &6.7668e-04_r8,5.6182e-04_r8,2.9265e-04_r8/)
      kao(:, 4, 8, 5) = (/ &
     &6.2426e-04_r8,7.9122e-04_r8,8.2299e-04_r8,8.2167e-04_r8,7.9967e-04_r8,7.6040e-04_r8, &
     &6.9192e-04_r8,5.7414e-04_r8,3.0175e-04_r8/)
      kao(:, 5, 8, 5) = (/ &
     &6.4049e-04_r8,8.1349e-04_r8,8.4675e-04_r8,8.4414e-04_r8,8.2107e-04_r8,7.7949e-04_r8, &
     &7.0895e-04_r8,5.8878e-04_r8,3.1239e-04_r8/)
      kao(:, 1, 9, 5) = (/ &
     &2.2196e-03_r8,2.3078e-03_r8,2.1925e-03_r8,2.0227e-03_r8,1.7963e-03_r8,1.5336e-03_r8, &
     &1.2354e-03_r8,8.8457e-04_r8,3.2582e-04_r8/)
      kao(:, 2, 9, 5) = (/ &
     &2.2570e-03_r8,2.3473e-03_r8,2.2277e-03_r8,2.0540e-03_r8,1.8274e-03_r8,1.5588e-03_r8, &
     &1.2524e-03_r8,8.9724e-04_r8,3.2676e-04_r8/)
      kao(:, 3, 9, 5) = (/ &
     &2.3089e-03_r8,2.3978e-03_r8,2.2707e-03_r8,2.0928e-03_r8,1.8651e-03_r8,1.5919e-03_r8, &
     &1.2779e-03_r8,9.1370e-04_r8,3.3500e-04_r8/)
      kao(:, 4, 9, 5) = (/ &
     &2.3733e-03_r8,2.4602e-03_r8,2.3315e-03_r8,2.1419e-03_r8,1.9119e-03_r8,1.6319e-03_r8, &
     &1.3090e-03_r8,9.3384e-04_r8,3.3899e-04_r8/)
      kao(:, 5, 9, 5) = (/ &
     &2.4406e-03_r8,2.5271e-03_r8,2.3986e-03_r8,2.2033e-03_r8,1.9655e-03_r8,1.6770e-03_r8, &
     &1.3445e-03_r8,9.5837e-04_r8,3.4762e-04_r8/)
      kao(:, 1,10, 5) = (/ &
     &9.4839e-03_r8,8.9137e-03_r8,7.9871e-03_r8,6.9719e-03_r8,5.8780e-03_r8,4.7134e-03_r8, &
     &3.4759e-03_r8,2.1070e-03_r8,4.8830e-04_r8/)
      kao(:, 2,10, 5) = (/ &
     &9.6557e-03_r8,9.0801e-03_r8,8.1340e-03_r8,7.0972e-03_r8,5.9780e-03_r8,4.7945e-03_r8, &
     &3.5398e-03_r8,2.1454e-03_r8,4.8857e-04_r8/)
      kao(:, 3,10, 5) = (/ &
     &9.8746e-03_r8,9.2754e-03_r8,8.2985e-03_r8,7.2339e-03_r8,6.1011e-03_r8,4.8911e-03_r8, &
     &3.6103e-03_r8,2.1918e-03_r8,5.0136e-04_r8/)
      kao(:, 4,10, 5) = (/ &
     &1.0155e-02_r8,9.5179e-03_r8,8.5070e-03_r8,7.4122e-03_r8,6.2501e-03_r8,5.0174e-03_r8, &
     &3.7003e-03_r8,2.2452e-03_r8,5.1609e-04_r8/)
      kao(:, 5,10, 5) = (/ &
     &1.0472e-02_r8,9.8032e-03_r8,8.7668e-03_r8,7.6331e-03_r8,6.4389e-03_r8,5.1659e-03_r8, &
     &3.8012e-03_r8,2.3067e-03_r8,5.2606e-04_r8/)
      kao(:, 1,11, 5) = (/ &
     &1.4268e-02_r8,1.3170e-02_r8,1.1684e-02_r8,1.0078e-02_r8,8.4022e-03_r8,6.6241e-03_r8, &
     &4.7723e-03_r8,2.7954e-03_r8,5.2361e-04_r8/)
      kao(:, 2,11, 5) = (/ &
     &1.4540e-02_r8,1.3417e-02_r8,1.1900e-02_r8,1.0250e-02_r8,8.5500e-03_r8,6.7539e-03_r8, &
     &4.8654e-03_r8,2.8533e-03_r8,5.3348e-04_r8/)
      kao(:, 3,11, 5) = (/ &
     &1.4880e-02_r8,1.3732e-02_r8,1.2163e-02_r8,1.0481e-02_r8,8.7324e-03_r8,6.9009e-03_r8, &
     &4.9833e-03_r8,2.9218e-03_r8,5.5883e-04_r8/)
      kao(:, 4,11, 5) = (/ &
     &1.5319e-02_r8,1.4123e-02_r8,1.2507e-02_r8,1.0772e-02_r8,8.9669e-03_r8,7.0955e-03_r8, &
     &5.1189e-03_r8,2.9943e-03_r8,5.8850e-04_r8/)
      kao(:, 5,11, 5) = (/ &
     &1.5835e-02_r8,1.4577e-02_r8,1.2919e-02_r8,1.1125e-02_r8,9.2533e-03_r8,7.3128e-03_r8, &
     &5.2667e-03_r8,3.0792e-03_r8,6.1073e-04_r8/)
      kao(:, 1,12, 5) = (/ &
     &1.5802e-02_r8,1.4518e-02_r8,1.2819e-02_r8,1.1003e-02_r8,9.1252e-03_r8,7.1742e-03_r8, &
     &5.1262e-03_r8,2.9592e-03_r8,5.0816e-04_r8/)
      kao(:, 2,12, 5) = (/ &
     &1.6146e-02_r8,1.4810e-02_r8,1.3074e-02_r8,1.1225e-02_r8,9.3090e-03_r8,7.3135e-03_r8, &
     &5.2412e-03_r8,3.0249e-03_r8,5.3398e-04_r8/)
      kao(:, 3,12, 5) = (/ &
     &1.6565e-02_r8,1.5205e-02_r8,1.3415e-02_r8,1.1514e-02_r8,9.5432e-03_r8,7.5058e-03_r8, &
     &5.3826e-03_r8,3.1020e-03_r8,5.6164e-04_r8/)
      kao(:, 4,12, 5) = (/ &
     &1.7128e-02_r8,1.5682e-02_r8,1.3836e-02_r8,1.1883e-02_r8,9.8516e-03_r8,7.7437e-03_r8, &
     &5.5313e-03_r8,3.1868e-03_r8,5.8823e-04_r8/)
      kao(:, 5,12, 5) = (/ &
     &1.7790e-02_r8,1.6267e-02_r8,1.4348e-02_r8,1.2311e-02_r8,1.0183e-02_r8,7.9904e-03_r8, &
     &5.7100e-03_r8,3.2821e-03_r8,6.0779e-04_r8/)
      kao(:, 1,13, 5) = (/ &
     &1.4021e-02_r8,1.2885e-02_r8,1.1370e-02_r8,9.7666e-03_r8,8.0956e-03_r8,6.3531e-03_r8, &
     &4.5485e-03_r8,2.6326e-03_r8,4.6002e-04_r8/)
      kao(:, 2,13, 5) = (/ &
     &1.4373e-02_r8,1.3207e-02_r8,1.1632e-02_r8,9.9865e-03_r8,8.2754e-03_r8,6.5087e-03_r8, &
     &4.6669e-03_r8,2.6967e-03_r8,4.8163e-04_r8/)
      kao(:, 3,13, 5) = (/ &
     &1.4774e-02_r8,1.3588e-02_r8,1.1994e-02_r8,1.0306e-02_r8,8.5450e-03_r8,6.7168e-03_r8, &
     &4.8089e-03_r8,2.7710e-03_r8,4.9996e-04_r8/)
      kao(:, 4,13, 5) = (/ &
     &1.5343e-02_r8,1.4084e-02_r8,1.2424e-02_r8,1.0664e-02_r8,8.8287e-03_r8,6.9355e-03_r8, &
     &4.9590e-03_r8,2.8556e-03_r8,5.2093e-04_r8/)
      kao(:, 5,13, 5) = (/ &
     &1.5979e-02_r8,1.4619e-02_r8,1.2888e-02_r8,1.1066e-02_r8,9.1632e-03_r8,7.1872e-03_r8, &
     &5.1400e-03_r8,2.9489e-03_r8,5.4238e-04_r8/)
      kao(:, 1, 1, 6) = (/ &
     &2.4381e-05_r8,3.5965e-04_r8,6.3963e-04_r8,9.0999e-04_r8,1.1781e-03_r8,1.4492e-03_r8, &
     &1.7469e-03_r8,2.1949e-03_r8,2.0167e-03_r8/)
      kao(:, 2, 1, 6) = (/ &
     &2.4551e-05_r8,3.6820e-04_r8,6.5359e-04_r8,9.2911e-04_r8,1.2030e-03_r8,1.4796e-03_r8, &
     &1.7884e-03_r8,2.2546e-03_r8,2.0633e-03_r8/)
      kao(:, 3, 1, 6) = (/ &
     &2.4844e-05_r8,3.7777e-04_r8,6.7015e-04_r8,9.5166e-04_r8,1.2316e-03_r8,1.5153e-03_r8, &
     &1.8326e-03_r8,2.3125e-03_r8,2.1171e-03_r8/)
      kao(:, 4, 1, 6) = (/ &
     &2.5013e-05_r8,3.8840e-04_r8,6.8929e-04_r8,9.7743e-04_r8,1.2638e-03_r8,1.5559e-03_r8, &
     &1.8833e-03_r8,2.3873e-03_r8,2.1814e-03_r8/)
      kao(:, 5, 1, 6) = (/ &
     &2.5349e-05_r8,4.0094e-04_r8,7.1137e-04_r8,1.0079e-03_r8,1.3021e-03_r8,1.6023e-03_r8, &
     &1.9431e-03_r8,2.4704e-03_r8,2.2554e-03_r8/)
      kao(:, 1, 2, 6) = (/ &
     &3.3532e-05_r8,3.4195e-04_r8,5.9227e-04_r8,8.3115e-04_r8,1.0659e-03_r8,1.2984e-03_r8, &
     &1.5375e-03_r8,1.8307e-03_r8,1.7555e-03_r8/)
      kao(:, 2, 2, 6) = (/ &
     &3.3884e-05_r8,3.4950e-04_r8,6.0496e-04_r8,8.4827e-04_r8,1.0865e-03_r8,1.3240e-03_r8, &
     &1.5683e-03_r8,1.8747e-03_r8,1.7936e-03_r8/)
      kao(:, 3, 2, 6) = (/ &
     &3.4432e-05_r8,3.5837e-04_r8,6.1975e-04_r8,8.6913e-04_r8,1.1113e-03_r8,1.3536e-03_r8, &
     &1.6021e-03_r8,1.9222e-03_r8,1.8373e-03_r8/)
      kao(:, 4, 2, 6) = (/ &
     &3.4886e-05_r8,3.6829e-04_r8,6.3662e-04_r8,8.9220e-04_r8,1.1391e-03_r8,1.3857e-03_r8, &
     &1.6406e-03_r8,1.9755e-03_r8,1.8873e-03_r8/)
      kao(:, 5, 2, 6) = (/ &
     &3.5279e-05_r8,3.7968e-04_r8,6.5599e-04_r8,9.1909e-04_r8,1.1730e-03_r8,1.4257e-03_r8, &
     &1.6862e-03_r8,2.0365e-03_r8,1.9484e-03_r8/)
      kao(:, 1, 3, 6) = (/ &
     &6.2269e-05_r8,3.6578e-04_r8,5.8707e-04_r8,7.9355e-04_r8,9.9285e-04_r8,1.1848e-03_r8, &
     &1.3757e-03_r8,1.5822e-03_r8,1.5104e-03_r8/)
      kao(:, 2, 3, 6) = (/ &
     &6.2987e-05_r8,3.7248e-04_r8,5.9883e-04_r8,8.1016e-04_r8,1.0136e-03_r8,1.2090e-03_r8, &
     &1.4023e-03_r8,1.6140e-03_r8,1.5440e-03_r8/)
      kao(:, 3, 3, 6) = (/ &
     &6.3830e-05_r8,3.8077e-04_r8,6.1238e-04_r8,8.2947e-04_r8,1.0380e-03_r8,1.2373e-03_r8, &
     &1.4338e-03_r8,1.6476e-03_r8,1.5800e-03_r8/)
      kao(:, 4, 3, 6) = (/ &
     &6.5057e-05_r8,3.9038e-04_r8,6.2908e-04_r8,8.5186e-04_r8,1.0655e-03_r8,1.2690e-03_r8, &
     &1.4686e-03_r8,1.6847e-03_r8,1.6204e-03_r8/)
      kao(:, 5, 3, 6) = (/ &
     &6.5891e-05_r8,4.0010e-04_r8,6.4778e-04_r8,8.7680e-04_r8,1.0962e-03_r8,1.3060e-03_r8, &
     &1.5104e-03_r8,1.7307e-03_r8,1.6697e-03_r8/)
      kao(:, 1, 4, 6) = (/ &
     &1.1763e-04_r8,4.2852e-04_r8,6.2857e-04_r8,8.0251e-04_r8,9.6160e-04_r8,1.1103e-03_r8, &
     &1.2549e-03_r8,1.3952e-03_r8,1.2948e-03_r8/)
      kao(:, 2, 4, 6) = (/ &
     &1.1903e-04_r8,4.3548e-04_r8,6.3935e-04_r8,8.1698e-04_r8,9.8074e-04_r8,1.1338e-03_r8, &
     &1.2810e-03_r8,1.4231e-03_r8,1.3227e-03_r8/)
      kao(:, 3, 4, 6) = (/ &
     &1.2084e-04_r8,4.4304e-04_r8,6.5330e-04_r8,8.3469e-04_r8,1.0028e-03_r8,1.1604e-03_r8, &
     &1.3104e-03_r8,1.4544e-03_r8,1.3535e-03_r8/)
      kao(:, 4, 4, 6) = (/ &
     &1.2295e-04_r8,4.5274e-04_r8,6.6888e-04_r8,8.5565e-04_r8,1.0277e-03_r8,1.1905e-03_r8, &
     &1.3437e-03_r8,1.4894e-03_r8,1.3881e-03_r8/)
      kao(:, 5, 4, 6) = (/ &
     &1.2576e-04_r8,4.6369e-04_r8,6.8705e-04_r8,8.8171e-04_r8,1.0587e-03_r8,1.2251e-03_r8, &
     &1.3822e-03_r8,1.5303e-03_r8,1.4309e-03_r8/)
      kao(:, 1, 5, 6) = (/ &
     &2.0248e-04_r8,5.1976e-04_r8,7.0294e-04_r8,8.5252e-04_r8,9.7761e-04_r8,1.0816e-03_r8, &
     &1.1680e-03_r8,1.2476e-03_r8,1.1044e-03_r8/)
      kao(:, 2, 5, 6) = (/ &
     &2.0493e-04_r8,5.2640e-04_r8,7.1432e-04_r8,8.6690e-04_r8,9.9395e-04_r8,1.1019e-03_r8, &
     &1.1914e-03_r8,1.2719e-03_r8,1.1285e-03_r8/)
      kao(:, 3, 5, 6) = (/ &
     &2.0806e-04_r8,5.3477e-04_r8,7.2739e-04_r8,8.8542e-04_r8,1.0148e-03_r8,1.1250e-03_r8, &
     &1.2182e-03_r8,1.3005e-03_r8,1.1542e-03_r8/)
      kao(:, 4, 5, 6) = (/ &
     &2.1205e-04_r8,5.4496e-04_r8,7.4280e-04_r8,9.0607e-04_r8,1.0399e-03_r8,1.1525e-03_r8, &
     &1.2484e-03_r8,1.3331e-03_r8,1.1843e-03_r8/)
      kao(:, 5, 5, 6) = (/ &
     &2.1768e-04_r8,5.5787e-04_r8,7.6255e-04_r8,9.3016e-04_r8,1.0697e-03_r8,1.1863e-03_r8, &
     &1.2845e-03_r8,1.3711e-03_r8,1.2208e-03_r8/)
      kao(:, 1, 6, 6) = (/ &
     &3.2402e-04_r8,6.5065e-04_r8,8.1276e-04_r8,9.3175e-04_r8,1.0254e-03_r8,1.0960e-03_r8, &
     &1.1336e-03_r8,1.1359e-03_r8,9.3926e-04_r8/)
      kao(:, 2, 6, 6) = (/ &
     &3.2839e-04_r8,6.5803e-04_r8,8.2121e-04_r8,9.4691e-04_r8,1.0426e-03_r8,1.1132e-03_r8, &
     &1.1537e-03_r8,1.1594e-03_r8,9.5631e-04_r8/)
      kao(:, 3, 6, 6) = (/ &
     &3.3397e-04_r8,6.6749e-04_r8,8.3425e-04_r8,9.6403e-04_r8,1.0654e-03_r8,1.1356e-03_r8, &
     &1.1768e-03_r8,1.1847e-03_r8,9.7614e-04_r8/)
      kao(:, 4, 6, 6) = (/ &
     &3.4074e-04_r8,6.7873e-04_r8,8.5077e-04_r8,9.8417e-04_r8,1.0893e-03_r8,1.1622e-03_r8, &
     &1.2041e-03_r8,1.2139e-03_r8,1.0001e-03_r8/)
      kao(:, 5, 6, 6) = (/ &
     &3.4865e-04_r8,6.9287e-04_r8,8.6902e-04_r8,1.0071e-03_r8,1.1162e-03_r8,1.1933e-03_r8, &
     &1.2370e-03_r8,1.2465e-03_r8,1.0295e-03_r8/)
      kao(:, 1, 7, 6) = (/ &
     &5.4679e-04_r8,8.8419e-04_r8,1.0272e-03_r8,1.1131e-03_r8,1.1586e-03_r8,1.1796e-03_r8, &
     &1.1677e-03_r8,1.1006e-03_r8,7.9375e-04_r8/)
      kao(:, 2, 7, 6) = (/ &
     &5.5453e-04_r8,8.9535e-04_r8,1.0406e-03_r8,1.1278e-03_r8,1.1758e-03_r8,1.1986e-03_r8, &
     &1.1860e-03_r8,1.1193e-03_r8,8.0863e-04_r8/)
      kao(:, 3, 7, 6) = (/ &
     &5.6482e-04_r8,9.0803e-04_r8,1.0560e-03_r8,1.1451e-03_r8,1.1955e-03_r8,1.2220e-03_r8, &
     &1.2089e-03_r8,1.1408e-03_r8,8.2565e-04_r8/)
      kao(:, 4, 7, 6) = (/ &
     &5.7672e-04_r8,9.2334e-04_r8,1.0748e-03_r8,1.1654e-03_r8,1.2195e-03_r8,1.2479e-03_r8, &
     &1.2361e-03_r8,1.1655e-03_r8,8.4564e-04_r8/)
      kao(:, 5, 7, 6) = (/ &
     &5.9187e-04_r8,9.4280e-04_r8,1.0968e-03_r8,1.1862e-03_r8,1.2479e-03_r8,1.2773e-03_r8, &
     &1.2677e-03_r8,1.1958e-03_r8,8.6975e-04_r8/)
      kao(:, 1, 8, 6) = (/ &
     &1.0890e-03_r8,1.4212e-03_r8,1.5274e-03_r8,1.5635e-03_r8,1.5408e-03_r8,1.4729e-03_r8, &
     &1.3514e-03_r8,1.1730e-03_r8,6.7724e-04_r8/)
      kao(:, 2, 8, 6) = (/ &
     &1.1074e-03_r8,1.4404e-03_r8,1.5493e-03_r8,1.5864e-03_r8,1.5647e-03_r8,1.4941e-03_r8, &
     &1.3720e-03_r8,1.1894e-03_r8,6.8838e-04_r8/)
      kao(:, 3, 8, 6) = (/ &
     &1.1299e-03_r8,1.4626e-03_r8,1.5727e-03_r8,1.6115e-03_r8,1.5892e-03_r8,1.5170e-03_r8, &
     &1.3954e-03_r8,1.2114e-03_r8,7.0024e-04_r8/)
      kao(:, 4, 8, 6) = (/ &
     &1.1562e-03_r8,1.4908e-03_r8,1.6005e-03_r8,1.6404e-03_r8,1.6196e-03_r8,1.5467e-03_r8, &
     &1.4229e-03_r8,1.2388e-03_r8,7.1485e-04_r8/)
      kao(:, 5, 8, 6) = (/ &
     &1.1885e-03_r8,1.5267e-03_r8,1.6357e-03_r8,1.6752e-03_r8,1.6528e-03_r8,1.5764e-03_r8, &
     &1.4553e-03_r8,1.2696e-03_r8,7.3183e-04_r8/)
      kao(:, 1, 9, 6) = (/ &
     &4.1665e-03_r8,4.3468e-03_r8,4.1293e-03_r8,3.8165e-03_r8,3.4449e-03_r8,3.0107e-03_r8, &
     &2.4884e-03_r8,1.8186e-03_r8,7.0770e-04_r8/)
      kao(:, 2, 9, 6) = (/ &
     &4.2379e-03_r8,4.4019e-03_r8,4.1804e-03_r8,3.8702e-03_r8,3.4962e-03_r8,3.0618e-03_r8, &
     &2.5301e-03_r8,1.8480e-03_r8,7.1084e-04_r8/)
      kao(:, 3, 9, 6) = (/ &
     &4.3206e-03_r8,4.4730e-03_r8,4.2494e-03_r8,3.9358e-03_r8,3.5562e-03_r8,3.1108e-03_r8, &
     &2.5726e-03_r8,1.8787e-03_r8,7.1447e-04_r8/)
      kao(:, 4, 9, 6) = (/ &
     &4.4148e-03_r8,4.5672e-03_r8,4.3360e-03_r8,4.0233e-03_r8,3.6279e-03_r8,3.1667e-03_r8, &
     &2.6211e-03_r8,1.9152e-03_r8,7.2547e-04_r8/)
      kao(:, 5, 9, 6) = (/ &
     &4.5366e-03_r8,4.6880e-03_r8,4.4475e-03_r8,4.1247e-03_r8,3.7148e-03_r8,3.2357e-03_r8, &
     &2.6777e-03_r8,1.9564e-03_r8,7.3351e-04_r8/)
      kao(:, 1,10, 6) = (/ &
     &1.8255e-02_r8,1.7198e-02_r8,1.5391e-02_r8,1.3391e-02_r8,1.1273e-02_r8,9.0394e-03_r8, &
     &6.6601e-03_r8,4.0944e-03_r8,9.8389e-04_r8/)
      kao(:, 2,10, 6) = (/ &
     &1.8579e-02_r8,1.7439e-02_r8,1.5601e-02_r8,1.3577e-02_r8,1.1427e-02_r8,9.1759e-03_r8, &
     &6.7580e-03_r8,4.1605e-03_r8,9.8485e-04_r8/)
      kao(:, 3,10, 6) = (/ &
     &1.8934e-02_r8,1.7772e-02_r8,1.5898e-02_r8,1.3821e-02_r8,1.1616e-02_r8,9.3279e-03_r8, &
     &6.8809e-03_r8,4.2287e-03_r8,9.8296e-04_r8/)
      kao(:, 4,10, 6) = (/ &
     &1.9364e-02_r8,1.8152e-02_r8,1.6246e-02_r8,1.4125e-02_r8,1.1868e-02_r8,9.5176e-03_r8, &
     &7.0263e-03_r8,4.3137e-03_r8,9.8595e-04_r8/)
      kao(:, 5,10, 6) = (/ &
     &1.9876e-02_r8,1.8605e-02_r8,1.6643e-02_r8,1.4478e-02_r8,1.2165e-02_r8,9.7573e-03_r8, &
     &7.2015e-03_r8,4.4138e-03_r8,9.9549e-04_r8/)
      kao(:, 1,11, 6) = (/ &
     &2.7906e-02_r8,2.5779e-02_r8,2.2845e-02_r8,1.9689e-02_r8,1.6356e-02_r8,1.2926e-02_r8, &
     &9.3112e-03_r8,5.4266e-03_r8,1.1493e-03_r8/)
      kao(:, 2,11, 6) = (/ &
     &2.8474e-02_r8,2.6276e-02_r8,2.3282e-02_r8,2.0063e-02_r8,1.6649e-02_r8,1.3118e-02_r8, &
     &9.4591e-03_r8,5.5176e-03_r8,1.1605e-03_r8/)
      kao(:, 3,11, 6) = (/ &
     &2.9161e-02_r8,2.6826e-02_r8,2.3755e-02_r8,2.0435e-02_r8,1.6944e-02_r8,1.3356e-02_r8, &
     &9.6281e-03_r8,5.6370e-03_r8,1.1658e-03_r8/)
      kao(:, 4,11, 6) = (/ &
     &2.9864e-02_r8,2.7446e-02_r8,2.4305e-02_r8,2.0907e-02_r8,1.7344e-02_r8,1.3665e-02_r8, &
     &9.8501e-03_r8,5.7787e-03_r8,1.1679e-03_r8/)
      kao(:, 5,11, 6) = (/ &
     &3.0716e-02_r8,2.8218e-02_r8,2.4989e-02_r8,2.1484e-02_r8,1.7837e-02_r8,1.4047e-02_r8, &
     &1.0137e-02_r8,5.9391e-03_r8,1.1749e-03_r8/)
      kao(:, 1,12, 6) = (/ &
     &3.1456e-02_r8,2.8840e-02_r8,2.5490e-02_r8,2.1901e-02_r8,1.8104e-02_r8,1.4184e-02_r8, &
     &1.0144e-02_r8,5.8131e-03_r8,1.1656e-03_r8/)
      kao(:, 2,12, 6) = (/ &
     &3.2212e-02_r8,2.9507e-02_r8,2.6048e-02_r8,2.2347e-02_r8,1.8450e-02_r8,1.4457e-02_r8, &
     &1.0325e-02_r8,5.9330e-03_r8,1.1607e-03_r8/)
      kao(:, 3,12, 6) = (/ &
     &3.2965e-02_r8,3.0133e-02_r8,2.6613e-02_r8,2.2834e-02_r8,1.8888e-02_r8,1.4793e-02_r8, &
     &1.0553e-02_r8,6.0675e-03_r8,1.1612e-03_r8/)
      kao(:, 4,12, 6) = (/ &
     &3.3903e-02_r8,3.0999e-02_r8,2.7365e-02_r8,2.3453e-02_r8,1.9368e-02_r8,1.5160e-02_r8, &
     &1.0832e-02_r8,6.2310e-03_r8,1.1792e-03_r8/)
      kao(:, 5,12, 6) = (/ &
     &3.4986e-02_r8,3.1940e-02_r8,2.8176e-02_r8,2.4131e-02_r8,1.9947e-02_r8,1.5618e-02_r8, &
     &1.1156e-02_r8,6.4247e-03_r8,1.2061e-03_r8/)
      kao(:, 1,13, 6) = (/ &
     &2.8494e-02_r8,2.6140e-02_r8,2.3086e-02_r8,1.9829e-02_r8,1.6410e-02_r8,1.2869e-02_r8, &
     &9.1750e-03_r8,5.2477e-03_r8,1.0839e-03_r8/)
      kao(:, 2,13, 6) = (/ &
     &2.9204e-02_r8,2.6786e-02_r8,2.3660e-02_r8,2.0312e-02_r8,1.6791e-02_r8,1.3151e-02_r8, &
     &9.3741e-03_r8,5.3670e-03_r8,1.0879e-03_r8/)
      kao(:, 3,13, 6) = (/ &
     &3.0028e-02_r8,2.7500e-02_r8,2.4267e-02_r8,2.0802e-02_r8,1.7182e-02_r8,1.3458e-02_r8, &
     &9.5924e-03_r8,5.5018e-03_r8,1.1043e-03_r8/)
      kao(:, 4,13, 6) = (/ &
     &3.0958e-02_r8,2.8295e-02_r8,2.4961e-02_r8,2.1395e-02_r8,1.7690e-02_r8,1.3840e-02_r8, &
     &9.8578e-03_r8,5.6588e-03_r8,1.1197e-03_r8/)
      kao(:, 5,13, 6) = (/ &
     &3.2042e-02_r8,2.9250e-02_r8,2.5779e-02_r8,2.2082e-02_r8,1.8250e-02_r8,1.4290e-02_r8, &
     &1.0177e-02_r8,5.8420e-03_r8,1.1367e-03_r8/)
      kao(:, 1, 1, 7) = (/ &
     &4.8330e-05_r8,9.1748e-04_r8,1.6343e-03_r8,2.3037e-03_r8,2.9566e-03_r8,3.6315e-03_r8, &
     &4.4475e-03_r8,5.8406e-03_r8,5.3151e-03_r8/)
      kao(:, 2, 1, 7) = (/ &
     &4.8596e-05_r8,9.3271e-04_r8,1.6606e-03_r8,2.3393e-03_r8,3.0027e-03_r8,3.6916e-03_r8, &
     &4.5243e-03_r8,5.9244e-03_r8,5.4196e-03_r8/)
      kao(:, 3, 1, 7) = (/ &
     &4.9220e-05_r8,9.5049e-04_r8,1.6928e-03_r8,2.3820e-03_r8,3.0582e-03_r8,3.7632e-03_r8, &
     &4.6161e-03_r8,6.0368e-03_r8,5.5387e-03_r8/)
      kao(:, 4, 1, 7) = (/ &
     &4.9714e-05_r8,9.7063e-04_r8,1.7276e-03_r8,2.4311e-03_r8,3.1220e-03_r8,3.8430e-03_r8, &
     &4.7205e-03_r8,6.1613e-03_r8,5.6708e-03_r8/)
      kao(:, 5, 1, 7) = (/ &
     &5.0550e-05_r8,9.9274e-04_r8,1.7651e-03_r8,2.4850e-03_r8,3.1923e-03_r8,3.9328e-03_r8, &
     &4.8316e-03_r8,6.3027e-03_r8,5.8156e-03_r8/)
      kao(:, 1, 2, 7) = (/ &
     &6.7697e-05_r8,8.5995e-04_r8,1.5004e-03_r8,2.0933e-03_r8,2.6519e-03_r8,3.1963e-03_r8, &
     &3.7792e-03_r8,4.6863e-03_r8,4.4711e-03_r8/)
      kao(:, 2, 2, 7) = (/ &
     &6.8123e-05_r8,8.7528e-04_r8,1.5266e-03_r8,2.1301e-03_r8,2.6961e-03_r8,3.2484e-03_r8, &
     &3.8450e-03_r8,4.7682e-03_r8,4.5579e-03_r8/)
      kao(:, 3, 2, 7) = (/ &
     &6.9098e-05_r8,8.9351e-04_r8,1.5568e-03_r8,2.1723e-03_r8,2.7472e-03_r8,3.3096e-03_r8, &
     &3.9205e-03_r8,4.8697e-03_r8,4.6570e-03_r8/)
      kao(:, 4, 2, 7) = (/ &
     &7.0075e-05_r8,9.1426e-04_r8,1.5908e-03_r8,2.2183e-03_r8,2.8071e-03_r8,3.3815e-03_r8, &
     &4.0084e-03_r8,4.9811e-03_r8,4.7715e-03_r8/)
      kao(:, 5, 2, 7) = (/ &
     &7.1192e-05_r8,9.3706e-04_r8,1.6283e-03_r8,2.2693e-03_r8,2.8718e-03_r8,3.4625e-03_r8, &
     &4.1070e-03_r8,5.1037e-03_r8,4.8979e-03_r8/)
      kao(:, 1, 3, 7) = (/ &
     &1.2733e-04_r8,8.7624e-04_r8,1.4506e-03_r8,1.9805e-03_r8,2.4757e-03_r8,2.9317e-03_r8, &
     &3.3558e-03_r8,3.8170e-03_r8,3.7686e-03_r8/)
      kao(:, 2, 3, 7) = (/ &
     &1.2826e-04_r8,8.9276e-04_r8,1.4769e-03_r8,2.0153e-03_r8,2.5174e-03_r8,2.9784e-03_r8, &
     &3.4075e-03_r8,3.8801e-03_r8,3.8344e-03_r8/)
      kao(:, 3, 3, 7) = (/ &
     &1.2973e-04_r8,9.1170e-04_r8,1.5076e-03_r8,2.0539e-03_r8,2.5651e-03_r8,3.0352e-03_r8, &
     &3.4680e-03_r8,3.9525e-03_r8,3.9125e-03_r8/)
      kao(:, 4, 3, 7) = (/ &
     &1.3225e-04_r8,9.3418e-04_r8,1.5436e-03_r8,2.1000e-03_r8,2.6202e-03_r8,3.1002e-03_r8, &
     &3.5421e-03_r8,4.0383e-03_r8,4.0057e-03_r8/)
      kao(:, 5, 3, 7) = (/ &
     &1.3440e-04_r8,9.5794e-04_r8,1.5825e-03_r8,2.1509e-03_r8,2.6822e-03_r8,3.1720e-03_r8, &
     &3.6252e-03_r8,4.1370e-03_r8,4.1108e-03_r8/)
      kao(:, 1, 4, 7) = (/ &
     &2.4414e-04_r8,9.8791e-04_r8,1.4797e-03_r8,1.9337e-03_r8,2.3609e-03_r8,2.7541e-03_r8, &
     &3.0988e-03_r8,3.3862e-03_r8,3.2303e-03_r8/)
      kao(:, 2, 4, 7) = (/ &
     &2.4513e-04_r8,1.0039e-03_r8,1.5070e-03_r8,1.9692e-03_r8,2.4021e-03_r8,2.7995e-03_r8, &
     &3.1468e-03_r8,3.4333e-03_r8,3.2790e-03_r8/)
      kao(:, 3, 4, 7) = (/ &
     &2.4808e-04_r8,1.0229e-03_r8,1.5373e-03_r8,2.0098e-03_r8,2.4481e-03_r8,2.8491e-03_r8, &
     &3.2030e-03_r8,3.4903e-03_r8,3.3384e-03_r8/)
      kao(:, 4, 4, 7) = (/ &
     &2.5202e-04_r8,1.0447e-03_r8,1.5721e-03_r8,2.0572e-03_r8,2.5035e-03_r8,2.9093e-03_r8, &
     &3.2672e-03_r8,3.5611e-03_r8,3.4115e-03_r8/)
      kao(:, 5, 4, 7) = (/ &
     &2.5833e-04_r8,1.0719e-03_r8,1.6144e-03_r8,2.1102e-03_r8,2.5658e-03_r8,2.9793e-03_r8, &
     &3.3418e-03_r8,3.6423e-03_r8,3.4938e-03_r8/)
      kao(:, 1, 5, 7) = (/ &
     &4.2770e-04_r8,1.1830e-03_r8,1.6220e-03_r8,1.9840e-03_r8,2.3123e-03_r8,2.6214e-03_r8, &
     &2.8956e-03_r8,3.0934e-03_r8,2.7805e-03_r8/)
      kao(:, 2, 5, 7) = (/ &
     &4.3162e-04_r8,1.2016e-03_r8,1.6476e-03_r8,2.0183e-03_r8,2.3523e-03_r8,2.6652e-03_r8, &
     &2.9419e-03_r8,3.1389e-03_r8,2.8192e-03_r8/)
      kao(:, 3, 5, 7) = (/ &
     &4.3693e-04_r8,1.2232e-03_r8,1.6764e-03_r8,2.0550e-03_r8,2.3985e-03_r8,2.7158e-03_r8, &
     &2.9926e-03_r8,3.1918e-03_r8,2.8694e-03_r8/)
      kao(:, 4, 5, 7) = (/ &
     &4.4235e-04_r8,1.2462e-03_r8,1.7099e-03_r8,2.0981e-03_r8,2.4518e-03_r8,2.7746e-03_r8, &
     &3.0533e-03_r8,3.2519e-03_r8,2.9306e-03_r8/)
      kao(:, 5, 5, 7) = (/ &
     &4.5257e-04_r8,1.2739e-03_r8,1.7526e-03_r8,2.1524e-03_r8,2.5133e-03_r8,2.8432e-03_r8, &
     &3.1246e-03_r8,3.3219e-03_r8,2.9994e-03_r8/)
      kao(:, 1, 6, 7) = (/ &
     &6.9917e-04_r8,1.4510e-03_r8,1.8508e-03_r8,2.1612e-03_r8,2.3969e-03_r8,2.5820e-03_r8, &
     &2.7369e-03_r8,2.8411e-03_r8,2.3809e-03_r8/)
      kao(:, 2, 6, 7) = (/ &
     &7.0685e-04_r8,1.4737e-03_r8,1.8819e-03_r8,2.1948e-03_r8,2.4365e-03_r8,2.6262e-03_r8, &
     &2.7822e-03_r8,2.8845e-03_r8,2.4163e-03_r8/)
      kao(:, 3, 6, 7) = (/ &
     &7.1685e-04_r8,1.4992e-03_r8,1.9139e-03_r8,2.2300e-03_r8,2.4777e-03_r8,2.6750e-03_r8, &
     &2.8324e-03_r8,2.9331e-03_r8,2.4594e-03_r8/)
      kao(:, 4, 6, 7) = (/ &
     &7.2831e-04_r8,1.5276e-03_r8,1.9491e-03_r8,2.2715e-03_r8,2.5262e-03_r8,2.7293e-03_r8, &
     &2.8927e-03_r8,2.9913e-03_r8,2.5109e-03_r8/)
      kao(:, 5, 6, 7) = (/ &
     &7.4174e-04_r8,1.5586e-03_r8,1.9900e-03_r8,2.3214e-03_r8,2.5825e-03_r8,2.7929e-03_r8, &
     &2.9629e-03_r8,3.0587e-03_r8,2.5688e-03_r8/)
      kao(:, 1, 7, 7) = (/ &
     &1.2039e-03_r8,1.9587e-03_r8,2.2962e-03_r8,2.5331e-03_r8,2.6974e-03_r8,2.7733e-03_r8, &
     &2.7634e-03_r8,2.6777e-03_r8,2.0245e-03_r8/)
      kao(:, 2, 7, 7) = (/ &
     &1.2204e-03_r8,1.9874e-03_r8,2.3314e-03_r8,2.5722e-03_r8,2.7404e-03_r8,2.8207e-03_r8, &
     &2.8122e-03_r8,2.7221e-03_r8,2.0503e-03_r8/)
      kao(:, 3, 7, 7) = (/ &
     &1.2400e-03_r8,2.0184e-03_r8,2.3716e-03_r8,2.6156e-03_r8,2.7851e-03_r8,2.8685e-03_r8, &
     &2.8623e-03_r8,2.7709e-03_r8,2.0844e-03_r8/)
      kao(:, 4, 7, 7) = (/ &
     &1.2633e-03_r8,2.0537e-03_r8,2.4164e-03_r8,2.6645e-03_r8,2.8368e-03_r8,2.9213e-03_r8, &
     &2.9184e-03_r8,2.8302e-03_r8,2.1246e-03_r8/)
      kao(:, 5, 7, 7) = (/ &
     &1.2880e-03_r8,2.0946e-03_r8,2.4660e-03_r8,2.7241e-03_r8,2.8956e-03_r8,2.9852e-03_r8, &
     &2.9850e-03_r8,2.8977e-03_r8,2.1717e-03_r8/)
      kao(:, 1, 8, 7) = (/ &
     &2.4360e-03_r8,3.2317e-03_r8,3.4336e-03_r8,3.4928e-03_r8,3.4872e-03_r8,3.3872e-03_r8, &
     &3.1811e-03_r8,2.7989e-03_r8,1.6994e-03_r8/)
      kao(:, 2, 8, 7) = (/ &
     &2.4784e-03_r8,3.2772e-03_r8,3.4707e-03_r8,3.5477e-03_r8,3.5429e-03_r8,3.4442e-03_r8, &
     &3.2393e-03_r8,2.8503e-03_r8,1.7216e-03_r8/)
      kao(:, 3, 8, 7) = (/ &
     &2.5215e-03_r8,3.3205e-03_r8,3.5181e-03_r8,3.6097e-03_r8,3.6079e-03_r8,3.5043e-03_r8, &
     &3.2957e-03_r8,2.9015e-03_r8,1.7516e-03_r8/)
      kao(:, 4, 8, 7) = (/ &
     &2.5734e-03_r8,3.3690e-03_r8,3.5815e-03_r8,3.6774e-03_r8,3.6742e-03_r8,3.5696e-03_r8, &
     &3.3583e-03_r8,2.9597e-03_r8,1.7852e-03_r8/)
      kao(:, 5, 8, 7) = (/ &
     &2.6287e-03_r8,3.4209e-03_r8,3.6564e-03_r8,3.7526e-03_r8,3.7488e-03_r8,3.6496e-03_r8, &
     &3.4322e-03_r8,3.0257e-03_r8,1.8234e-03_r8/)
      kao(:, 1, 9, 7) = (/ &
     &9.2016e-03_r8,9.7823e-03_r8,9.4145e-03_r8,8.7411e-03_r8,7.8879e-03_r8,6.8736e-03_r8, &
     &5.6569e-03_r8,4.2025e-03_r8,1.5538e-03_r8/)
      kao(:, 2, 9, 7) = (/ &
     &9.3962e-03_r8,9.9769e-03_r8,9.5905e-03_r8,8.8876e-03_r8,8.0147e-03_r8,6.9737e-03_r8, &
     &5.7408e-03_r8,4.2797e-03_r8,1.5748e-03_r8/)
      kao(:, 3, 9, 7) = (/ &
     &9.5905e-03_r8,1.0169e-02_r8,9.7567e-03_r8,9.0284e-03_r8,8.1348e-03_r8,7.0770e-03_r8, &
     &5.8473e-03_r8,4.3619e-03_r8,1.5893e-03_r8/)
      kao(:, 4, 9, 7) = (/ &
     &9.8163e-03_r8,1.0370e-02_r8,9.9309e-03_r8,9.1820e-03_r8,8.2703e-03_r8,7.1825e-03_r8, &
     &5.9588e-03_r8,4.4477e-03_r8,1.6087e-03_r8/)
      kao(:, 5, 9, 7) = (/ &
     &1.0054e-02_r8,1.0584e-02_r8,1.0131e-02_r8,9.3626e-03_r8,8.4298e-03_r8,7.3350e-03_r8, &
     &6.0835e-03_r8,4.5437e-03_r8,1.6313e-03_r8/)
      kao(:, 1,10, 7) = (/ &
     &3.9276e-02_r8,3.6749e-02_r8,3.3301e-02_r8,2.9241e-02_r8,2.4794e-02_r8,2.0028e-02_r8, &
     &1.4912e-02_r8,9.3013e-03_r8,2.0443e-03_r8/)
      kao(:, 2,10, 7) = (/ &
     &4.0105e-02_r8,3.7556e-02_r8,3.4005e-02_r8,2.9863e-02_r8,2.5353e-02_r8,2.0438e-02_r8, &
     &1.5180e-02_r8,9.4819e-03_r8,2.0242e-03_r8/)
      kao(:, 3,10, 7) = (/ &
     &4.0916e-02_r8,3.8307e-02_r8,3.4681e-02_r8,3.0487e-02_r8,2.5876e-02_r8,2.0814e-02_r8, &
     &1.5451e-02_r8,9.6638e-03_r8,2.0047e-03_r8/)
      kao(:, 4,10, 7) = (/ &
     &4.1894e-02_r8,3.9199e-02_r8,3.5443e-02_r8,3.1118e-02_r8,2.6390e-02_r8,2.1233e-02_r8, &
     &1.5746e-02_r8,9.8447e-03_r8,2.0155e-03_r8/)
      kao(:, 5,10, 7) = (/ &
     &4.2954e-02_r8,4.0161e-02_r8,3.6290e-02_r8,3.1839e-02_r8,2.6971e-02_r8,2.1693e-02_r8, &
     &1.6115e-02_r8,1.0055e-02_r8,2.0394e-03_r8/)
      kao(:, 1,11, 7) = (/ &
     &6.0955e-02_r8,5.5737e-02_r8,4.9723e-02_r8,4.3019e-02_r8,3.5876e-02_r8,2.8379e-02_r8, &
     &2.0432e-02_r8,1.2085e-02_r8,2.3716e-03_r8/)
      kao(:, 2,11, 7) = (/ &
     &6.2198e-02_r8,5.6869e-02_r8,5.0662e-02_r8,4.3787e-02_r8,3.6565e-02_r8,2.8915e-02_r8, &
     &2.0814e-02_r8,1.2323e-02_r8,2.3542e-03_r8/)
      kao(:, 3,11, 7) = (/ &
     &6.3419e-02_r8,5.8024e-02_r8,5.1697e-02_r8,4.4702e-02_r8,3.7324e-02_r8,2.9465e-02_r8, &
     &2.1204e-02_r8,1.2555e-02_r8,2.3313e-03_r8/)
      kao(:, 4,11, 7) = (/ &
     &6.4926e-02_r8,5.9386e-02_r8,5.2869e-02_r8,4.5680e-02_r8,3.8119e-02_r8,3.0075e-02_r8, &
     &2.1667e-02_r8,1.2812e-02_r8,2.3155e-03_r8/)
      kao(:, 5,11, 7) = (/ &
     &6.6635e-02_r8,6.0864e-02_r8,5.4124e-02_r8,4.6774e-02_r8,3.9011e-02_r8,3.0829e-02_r8, &
     &2.2206e-02_r8,1.3119e-02_r8,2.3251e-03_r8/)
      kao(:, 1,12, 7) = (/ &
     &6.9869e-02_r8,6.3637e-02_r8,5.6420e-02_r8,4.8546e-02_r8,4.0307e-02_r8,3.1740e-02_r8, &
     &2.2682e-02_r8,1.3139e-02_r8,2.4428e-03_r8/)
      kao(:, 2,12, 7) = (/ &
     &7.1577e-02_r8,6.5133e-02_r8,5.7685e-02_r8,4.9634e-02_r8,4.1244e-02_r8,3.2466e-02_r8, &
     &2.3165e-02_r8,1.3402e-02_r8,2.4417e-03_r8/)
      kao(:, 3,12, 7) = (/ &
     &7.3435e-02_r8,6.6765e-02_r8,5.9111e-02_r8,5.0782e-02_r8,4.2090e-02_r8,3.3070e-02_r8, &
     &2.3631e-02_r8,1.3663e-02_r8,2.4312e-03_r8/)
      kao(:, 4,12, 7) = (/ &
     &7.5274e-02_r8,6.8406e-02_r8,6.0539e-02_r8,5.2024e-02_r8,4.3158e-02_r8,3.3897e-02_r8, &
     &2.4213e-02_r8,1.3961e-02_r8,2.4213e-03_r8/)
      kao(:, 5,12, 7) = (/ &
     &7.7518e-02_r8,7.0447e-02_r8,6.2339e-02_r8,5.3608e-02_r8,4.4457e-02_r8,3.4884e-02_r8, &
     &2.4882e-02_r8,1.4302e-02_r8,2.4144e-03_r8/)
      kao(:, 1,13, 7) = (/ &
     &6.3971e-02_r8,5.8270e-02_r8,5.1535e-02_r8,4.4263e-02_r8,3.6709e-02_r8,2.8872e-02_r8, &
     &2.0629e-02_r8,1.1917e-02_r8,2.3953e-03_r8/)
      kao(:, 2,13, 7) = (/ &
     &6.5643e-02_r8,5.9813e-02_r8,5.2890e-02_r8,4.5419e-02_r8,3.7684e-02_r8,2.9600e-02_r8, &
     &2.1119e-02_r8,1.2188e-02_r8,2.4046e-03_r8/)
      kao(:, 3,13, 7) = (/ &
     &6.7472e-02_r8,6.1457e-02_r8,5.4341e-02_r8,4.6654e-02_r8,3.8721e-02_r8,3.0402e-02_r8, &
     &2.1696e-02_r8,1.2486e-02_r8,2.3922e-03_r8/)
      kao(:, 4,13, 7) = (/ &
     &6.9579e-02_r8,6.3365e-02_r8,5.6023e-02_r8,4.8132e-02_r8,3.9923e-02_r8,3.1337e-02_r8, &
     &2.2348e-02_r8,1.2806e-02_r8,2.3768e-03_r8/)
      kao(:, 5,13, 7) = (/ &
     &7.1993e-02_r8,6.5596e-02_r8,5.7974e-02_r8,4.9776e-02_r8,4.1204e-02_r8,3.2317e-02_r8, &
     &2.3035e-02_r8,1.3183e-02_r8,2.3765e-03_r8/)
      kao(:, 1, 1, 8) = (/ &
     &1.3552e-04_r8,2.4322e-03_r8,4.1951e-03_r8,5.8754e-03_r8,7.6297e-03_r8,9.6149e-03_r8, &
     &1.1994e-02_r8,1.5380e-02_r8,1.4856e-02_r8/)
      kao(:, 2, 1, 8) = (/ &
     &1.3805e-04_r8,2.4459e-03_r8,4.2175e-03_r8,5.9121e-03_r8,7.6823e-03_r8,9.6825e-03_r8, &
     &1.2072e-02_r8,1.5469e-02_r8,1.4971e-02_r8/)
      kao(:, 3, 1, 8) = (/ &
     &1.4131e-04_r8,2.4661e-03_r8,4.2478e-03_r8,5.9602e-03_r8,7.7525e-03_r8,9.7747e-03_r8, &
     &1.2179e-02_r8,1.5577e-02_r8,1.5128e-02_r8/)
      kao(:, 4, 1, 8) = (/ &
     &1.4377e-04_r8,2.4912e-03_r8,4.2859e-03_r8,6.0170e-03_r8,7.8373e-03_r8,9.8887e-03_r8, &
     &1.2314e-02_r8,1.5728e-02_r8,1.5316e-02_r8/)
      kao(:, 5, 1, 8) = (/ &
     &1.4692e-04_r8,2.5205e-03_r8,4.3310e-03_r8,6.0836e-03_r8,7.9343e-03_r8,1.0019e-02_r8, &
     &1.2473e-02_r8,1.5904e-02_r8,1.5528e-02_r8/)
      kao(:, 1, 2, 8) = (/ &
     &1.8928e-04_r8,2.4121e-03_r8,4.0623e-03_r8,5.5541e-03_r8,6.9898e-03_r8,8.5008e-03_r8, &
     &1.0323e-02_r8,1.3028e-02_r8,1.2924e-02_r8/)
      kao(:, 2, 2, 8) = (/ &
     &1.9267e-04_r8,2.4360e-03_r8,4.0898e-03_r8,5.5901e-03_r8,7.0384e-03_r8,8.5652e-03_r8, &
     &1.0405e-02_r8,1.3116e-02_r8,1.3041e-02_r8/)
      kao(:, 3, 2, 8) = (/ &
     &1.9724e-04_r8,2.4656e-03_r8,4.1277e-03_r8,5.6355e-03_r8,7.0999e-03_r8,8.6497e-03_r8, &
     &1.0515e-02_r8,1.3234e-02_r8,1.3193e-02_r8/)
      kao(:, 4, 2, 8) = (/ &
     &2.0128e-04_r8,2.4981e-03_r8,4.1715e-03_r8,5.6919e-03_r8,7.1715e-03_r8,8.7477e-03_r8, &
     &1.0645e-02_r8,1.3388e-02_r8,1.3368e-02_r8/)
      kao(:, 5, 2, 8) = (/ &
     &2.0477e-04_r8,2.5328e-03_r8,4.2216e-03_r8,5.7557e-03_r8,7.2538e-03_r8,8.8556e-03_r8, &
     &1.0788e-02_r8,1.3565e-02_r8,1.3563e-02_r8/)
      kao(:, 1, 3, 8) = (/ &
     &3.5927e-04_r8,2.5910e-03_r8,4.2037e-03_r8,5.6032e-03_r8,6.8389e-03_r8,7.9673e-03_r8, &
     &9.0787e-03_r8,1.0659e-02_r8,1.1075e-02_r8/)
      kao(:, 2, 3, 8) = (/ &
     &3.6570e-04_r8,2.6231e-03_r8,4.2518e-03_r8,5.6510e-03_r8,6.8860e-03_r8,8.0235e-03_r8, &
     &9.1475e-03_r8,1.0746e-02_r8,1.1185e-02_r8/)
      kao(:, 3, 3, 8) = (/ &
     &3.7255e-04_r8,2.6596e-03_r8,4.3088e-03_r8,5.7121e-03_r8,6.9479e-03_r8,8.0889e-03_r8, &
     &9.2308e-03_r8,1.0860e-02_r8,1.1321e-02_r8/)
      kao(:, 4, 3, 8) = (/ &
     &3.8155e-04_r8,2.7037e-03_r8,4.3688e-03_r8,5.7837e-03_r8,7.0219e-03_r8,8.1712e-03_r8, &
     &9.3303e-03_r8,1.0993e-02_r8,1.1473e-02_r8/)
      kao(:, 5, 3, 8) = (/ &
     &3.8777e-04_r8,2.7514e-03_r8,4.4348e-03_r8,5.8612e-03_r8,7.1061e-03_r8,8.2670e-03_r8, &
     &9.4452e-03_r8,1.1141e-02_r8,1.1658e-02_r8/)
      kao(:, 1, 4, 8) = (/ &
     &6.9620e-04_r8,2.9029e-03_r8,4.4649e-03_r8,5.7896e-03_r8,6.9152e-03_r8,7.8788e-03_r8, &
     &8.6335e-03_r8,9.2668e-03_r8,9.4651e-03_r8/)
      kao(:, 2, 4, 8) = (/ &
     &7.1019e-04_r8,2.9517e-03_r8,4.5263e-03_r8,5.8664e-03_r8,6.9912e-03_r8,7.9468e-03_r8, &
     &8.6984e-03_r8,9.3401e-03_r8,9.5623e-03_r8/)
      kao(:, 3, 4, 8) = (/ &
     &7.2359e-04_r8,3.0044e-03_r8,4.5979e-03_r8,5.9489e-03_r8,7.0830e-03_r8,8.0315e-03_r8, &
     &8.7768e-03_r8,9.4291e-03_r8,9.6859e-03_r8/)
      kao(:, 4, 4, 8) = (/ &
     &7.3828e-04_r8,3.0619e-03_r8,4.6789e-03_r8,6.0379e-03_r8,7.1842e-03_r8,8.1322e-03_r8, &
     &8.8743e-03_r8,9.5317e-03_r8,9.8248e-03_r8/)
      kao(:, 5, 4, 8) = (/ &
     &7.5535e-04_r8,3.1266e-03_r8,4.7671e-03_r8,6.1369e-03_r8,7.2972e-03_r8,8.2469e-03_r8, &
     &8.9884e-03_r8,9.6595e-03_r8,9.9955e-03_r8/)
      kao(:, 1, 5, 8) = (/ &
     &1.2367e-03_r8,3.3787e-03_r8,4.7869e-03_r8,5.9863e-03_r8,7.0094e-03_r8,7.8065e-03_r8, &
     &8.3893e-03_r8,8.6393e-03_r8,8.1050e-03_r8/)
      kao(:, 2, 5, 8) = (/ &
     &1.2606e-03_r8,3.4408e-03_r8,4.8727e-03_r8,6.0829e-03_r8,7.1090e-03_r8,7.9083e-03_r8, &
     &8.4736e-03_r8,8.7084e-03_r8,8.1896e-03_r8/)
      kao(:, 3, 5, 8) = (/ &
     &1.2858e-03_r8,3.5058e-03_r8,4.9695e-03_r8,6.1896e-03_r8,7.2184e-03_r8,8.0235e-03_r8, &
     &8.5795e-03_r8,8.7948e-03_r8,8.2945e-03_r8/)
      kao(:, 4, 5, 8) = (/ &
     &1.3144e-03_r8,3.5781e-03_r8,5.0734e-03_r8,6.3066e-03_r8,7.3381e-03_r8,8.1502e-03_r8, &
     &8.7050e-03_r8,8.8972e-03_r8,8.4098e-03_r8/)
      kao(:, 5, 5, 8) = (/ &
     &1.3469e-03_r8,3.6641e-03_r8,5.1833e-03_r8,6.4362e-03_r8,7.4701e-03_r8,8.2878e-03_r8, &
     &8.8414e-03_r8,9.0166e-03_r8,8.5483e-03_r8/)
      kao(:, 1, 6, 8) = (/ &
     &2.0401e-03_r8,4.1601e-03_r8,5.3408e-03_r8,6.2948e-03_r8,7.1082e-03_r8,7.7648e-03_r8, &
     &8.1607e-03_r8,8.2016e-03_r8,6.9653e-03_r8/)
      kao(:, 2, 6, 8) = (/ &
     &2.0844e-03_r8,4.2423e-03_r8,5.4455e-03_r8,6.4160e-03_r8,7.2313e-03_r8,7.8855e-03_r8, &
     &8.2759e-03_r8,8.2810e-03_r8,7.0331e-03_r8/)
      kao(:, 3, 6, 8) = (/ &
     &2.1282e-03_r8,4.3237e-03_r8,5.5575e-03_r8,6.5512e-03_r8,7.3708e-03_r8,8.0202e-03_r8, &
     &8.4033e-03_r8,8.3806e-03_r8,7.1162e-03_r8/)
      kao(:, 4, 6, 8) = (/ &
     &2.1756e-03_r8,4.4109e-03_r8,5.6792e-03_r8,6.6960e-03_r8,7.5224e-03_r8,8.1665e-03_r8, &
     &8.5397e-03_r8,8.4981e-03_r8,7.2093e-03_r8/)
      kao(:, 5, 6, 8) = (/ &
     &2.2255e-03_r8,4.5091e-03_r8,5.8068e-03_r8,6.8485e-03_r8,7.6856e-03_r8,8.3228e-03_r8, &
     &8.6864e-03_r8,8.6279e-03_r8,7.3203e-03_r8/)
      kao(:, 1, 7, 8) = (/ &
     &3.5433e-03_r8,5.7288e-03_r8,6.6788e-03_r8,7.3197e-03_r8,7.7679e-03_r8,8.0638e-03_r8, &
     &8.2036e-03_r8,7.9558e-03_r8,6.0055e-03_r8/)
      kao(:, 2, 7, 8) = (/ &
     &3.6269e-03_r8,5.8458e-03_r8,6.8139e-03_r8,7.4674e-03_r8,7.9220e-03_r8,8.2152e-03_r8, &
     &8.3417e-03_r8,8.0664e-03_r8,6.0619e-03_r8/)
      kao(:, 3, 7, 8) = (/ &
     &3.7095e-03_r8,5.9702e-03_r8,6.9487e-03_r8,7.6264e-03_r8,8.0952e-03_r8,8.3842e-03_r8, &
     &8.4920e-03_r8,8.1889e-03_r8,6.1273e-03_r8/)
      kao(:, 4, 7, 8) = (/ &
     &3.7971e-03_r8,6.0972e-03_r8,7.0950e-03_r8,7.7981e-03_r8,8.2789e-03_r8,8.5668e-03_r8, &
     &8.6571e-03_r8,8.3173e-03_r8,6.2019e-03_r8/)
      kao(:, 5, 7, 8) = (/ &
     &3.8894e-03_r8,6.2311e-03_r8,7.2602e-03_r8,7.9756e-03_r8,8.4749e-03_r8,8.7608e-03_r8, &
     &8.8292e-03_r8,8.4586e-03_r8,6.2926e-03_r8/)
      kao(:, 1, 8, 8) = (/ &
     &7.2384e-03_r8,9.3960e-03_r8,1.0099e-02_r8,1.0331e-02_r8,1.0208e-02_r8,9.8199e-03_r8, &
     &9.1852e-03_r8,8.2577e-03_r8,5.1301e-03_r8/)
      kao(:, 2, 8, 8) = (/ &
     &7.4182e-03_r8,9.6243e-03_r8,1.0349e-02_r8,1.0556e-02_r8,1.0419e-02_r8,1.0021e-02_r8, &
     &9.3680e-03_r8,8.3968e-03_r8,5.1752e-03_r8/)
      kao(:, 3, 8, 8) = (/ &
     &7.6043e-03_r8,9.8546e-03_r8,1.0598e-02_r8,1.0777e-02_r8,1.0633e-02_r8,1.0249e-02_r8, &
     &9.5676e-03_r8,8.5508e-03_r8,5.2269e-03_r8/)
      kao(:, 4, 8, 8) = (/ &
     &7.7980e-03_r8,1.0094e-02_r8,1.0836e-02_r8,1.1012e-02_r8,1.0870e-02_r8,1.0482e-02_r8, &
     &9.7866e-03_r8,8.7162e-03_r8,5.2872e-03_r8/)
      kao(:, 5, 8, 8) = (/ &
     &8.0005e-03_r8,1.0352e-02_r8,1.1093e-02_r8,1.1272e-02_r8,1.1127e-02_r8,1.0726e-02_r8, &
     &1.0012e-02_r8,8.8875e-03_r8,5.3638e-03_r8/)
      kao(:, 1, 9, 8) = (/ &
     &2.7897e-02_r8,2.8473e-02_r8,2.7594e-02_r8,2.5806e-02_r8,2.3354e-02_r8,2.0346e-02_r8, &
     &1.6782e-02_r8,1.2341e-02_r8,4.1787e-03_r8/)
      kao(:, 2, 9, 8) = (/ &
     &2.8638e-02_r8,2.9187e-02_r8,2.8303e-02_r8,2.6475e-02_r8,2.3949e-02_r8,2.0857e-02_r8, &
     &1.7181e-02_r8,1.2602e-02_r8,4.2128e-03_r8/)
      kao(:, 3, 9, 8) = (/ &
     &2.9413e-02_r8,2.9901e-02_r8,2.8994e-02_r8,2.7143e-02_r8,2.4571e-02_r8,2.1381e-02_r8, &
     &1.7560e-02_r8,1.2888e-02_r8,4.2655e-03_r8/)
      kao(:, 4, 9, 8) = (/ &
     &3.0228e-02_r8,3.0665e-02_r8,2.9734e-02_r8,2.7828e-02_r8,2.5188e-02_r8,2.1923e-02_r8, &
     &1.7970e-02_r8,1.3183e-02_r8,4.3190e-03_r8/)
      kao(:, 5, 9, 8) = (/ &
     &3.1084e-02_r8,3.1463e-02_r8,3.0494e-02_r8,2.8550e-02_r8,2.5844e-02_r8,2.2478e-02_r8, &
     &1.8412e-02_r8,1.3496e-02_r8,4.3806e-03_r8/)
      kao(:, 1,10, 8) = (/ &
     &1.1962e-01_r8,1.0878e-01_r8,9.8349e-02_r8,8.6745e-02_r8,7.3912e-02_r8,5.9973e-02_r8, &
     &4.4839e-02_r8,2.7943e-02_r8,4.7543e-03_r8/)
      kao(:, 2,10, 8) = (/ &
     &1.2315e-01_r8,1.1182e-01_r8,1.0110e-01_r8,8.9175e-02_r8,7.5937e-02_r8,6.1630e-02_r8, &
     &4.6110e-02_r8,2.8679e-02_r8,4.8196e-03_r8/)
      kao(:, 3,10, 8) = (/ &
     &1.2693e-01_r8,1.1500e-01_r8,1.0391e-01_r8,9.1586e-02_r8,7.7974e-02_r8,6.3317e-02_r8, &
     &4.7374e-02_r8,2.9424e-02_r8,4.8761e-03_r8/)
      kao(:, 4,10, 8) = (/ &
     &1.3084e-01_r8,1.1837e-01_r8,1.0689e-01_r8,9.4192e-02_r8,8.0184e-02_r8,6.5076e-02_r8, &
     &4.8672e-02_r8,3.0173e-02_r8,4.8766e-03_r8/)
      kao(:, 5,10, 8) = (/ &
     &1.3499e-01_r8,1.2195e-01_r8,1.1004e-01_r8,9.6906e-02_r8,8.2479e-02_r8,6.6930e-02_r8, &
     &4.9998e-02_r8,3.0984e-02_r8,4.9096e-03_r8/)
      kao(:, 1,11, 8) = (/ &
     &1.7854e-01_r8,1.6015e-01_r8,1.4269e-01_r8,1.2418e-01_r8,1.0441e-01_r8,8.3289e-02_r8, &
     &6.0955e-02_r8,3.6472e-02_r8,5.4769e-03_r8/)
      kao(:, 2,11, 8) = (/ &
     &1.8442e-01_r8,1.6524e-01_r8,1.4721e-01_r8,1.2815e-01_r8,1.0771e-01_r8,8.5980e-02_r8, &
     &6.2870e-02_r8,3.7580e-02_r8,5.4728e-03_r8/)
      kao(:, 3,11, 8) = (/ &
     &1.9077e-01_r8,1.7071e-01_r8,1.5197e-01_r8,1.3224e-01_r8,1.1114e-01_r8,8.8708e-02_r8, &
     &6.4824e-02_r8,3.8654e-02_r8,5.4615e-03_r8/)
      kao(:, 4,11, 8) = (/ &
     &1.9746e-01_r8,1.7645e-01_r8,1.5699e-01_r8,1.3658e-01_r8,1.1475e-01_r8,9.1549e-02_r8, &
     &6.6833e-02_r8,3.9764e-02_r8,5.4686e-03_r8/)
      kao(:, 5,11, 8) = (/ &
     &2.0452e-01_r8,1.8255e-01_r8,1.6232e-01_r8,1.4114e-01_r8,1.1852e-01_r8,9.4452e-02_r8, &
     &6.8909e-02_r8,4.0947e-02_r8,5.4706e-03_r8/)
      kao(:, 1,12, 8) = (/ &
     &2.0120e-01_r8,1.7983e-01_r8,1.5919e-01_r8,1.3760e-01_r8,1.1465e-01_r8,9.0568e-02_r8, &
     &6.5383e-02_r8,3.8355e-02_r8,5.7670e-03_r8/)
      kao(:, 2,12, 8) = (/ &
     &2.0757e-01_r8,1.8546e-01_r8,1.6435e-01_r8,1.4209e-01_r8,1.1843e-01_r8,9.3538e-02_r8, &
     &6.7515e-02_r8,3.9583e-02_r8,5.7182e-03_r8/)
      kao(:, 3,12, 8) = (/ &
     &2.1449e-01_r8,1.9151e-01_r8,1.6961e-01_r8,1.4673e-01_r8,1.2244e-01_r8,9.6759e-02_r8, &
     &6.9782e-02_r8,4.0857e-02_r8,5.7245e-03_r8/)
      kao(:, 4,12, 8) = (/ &
     &2.2222e-01_r8,1.9817e-01_r8,1.7542e-01_r8,1.5173e-01_r8,1.2653e-01_r8,1.0003e-01_r8, &
     &7.2145e-02_r8,4.2184e-02_r8,5.7102e-03_r8/)
      kao(:, 5,12, 8) = (/ &
     &2.3023e-01_r8,2.0507e-01_r8,1.8144e-01_r8,1.5689e-01_r8,1.3087e-01_r8,1.0351e-01_r8, &
     &7.4642e-02_r8,4.3620e-02_r8,5.7450e-03_r8/)
      kao(:, 1,13, 8) = (/ &
     &1.8448e-01_r8,1.6553e-01_r8,1.4649e-01_r8,1.2620e-01_r8,1.0471e-01_r8,8.2340e-02_r8, &
     &5.9042e-02_r8,3.4367e-02_r8,5.6219e-03_r8/)
      kao(:, 2,13, 8) = (/ &
     &1.9034e-01_r8,1.7056e-01_r8,1.5103e-01_r8,1.3022e-01_r8,1.0811e-01_r8,8.5094e-02_r8, &
     &6.1006e-02_r8,3.5479e-02_r8,5.5942e-03_r8/)
      kao(:, 3,13, 8) = (/ &
     &1.9658e-01_r8,1.7595e-01_r8,1.5589e-01_r8,1.3452e-01_r8,1.1170e-01_r8,8.7865e-02_r8, &
     &6.2984e-02_r8,3.6599e-02_r8,5.6072e-03_r8/)
      kao(:, 4,13, 8) = (/ &
     &2.0338e-01_r8,1.8188e-01_r8,1.6115e-01_r8,1.3898e-01_r8,1.1533e-01_r8,9.0760e-02_r8, &
     &6.5090e-02_r8,3.7803e-02_r8,5.6436e-03_r8/)
      kao(:, 5,13, 8) = (/ &
     &2.1087e-01_r8,1.8825e-01_r8,1.6661e-01_r8,1.4369e-01_r8,1.1939e-01_r8,9.3967e-02_r8, &
     &6.7400e-02_r8,3.9148e-02_r8,5.6745e-03_r8/)
      kao(:, 1, 1, 9) = (/ &
     &9.4421e-04_r8,7.3440e-03_r8,1.3185e-02_r8,1.9434e-02_r8,2.5910e-02_r8,3.2531e-02_r8, &
     &3.9377e-02_r8,4.6620e-02_r8,5.1571e-02_r8/)
      kao(:, 2, 1, 9) = (/ &
     &9.6482e-04_r8,7.2909e-03_r8,1.3109e-02_r8,1.9331e-02_r8,2.5776e-02_r8,3.2360e-02_r8, &
     &3.9164e-02_r8,4.6323e-02_r8,5.1303e-02_r8/)
      kao(:, 3, 1, 9) = (/ &
     &9.8476e-04_r8,7.2409e-03_r8,1.3044e-02_r8,1.9248e-02_r8,2.5665e-02_r8,3.2216e-02_r8, &
     &3.8981e-02_r8,4.6102e-02_r8,5.1082e-02_r8/)
      kao(:, 4, 1, 9) = (/ &
     &1.0020e-03_r8,7.1999e-03_r8,1.3010e-02_r8,1.9215e-02_r8,2.5618e-02_r8,3.2137e-02_r8, &
     &3.8862e-02_r8,4.5932e-02_r8,5.0990e-02_r8/)
      kao(:, 5, 1, 9) = (/ &
     &1.0184e-03_r8,7.1770e-03_r8,1.3015e-02_r8,1.9243e-02_r8,2.5654e-02_r8,3.2165e-02_r8, &
     &3.8858e-02_r8,4.5863e-02_r8,5.1066e-02_r8/)
      kao(:, 1, 2, 9) = (/ &
     &1.3462e-03_r8,8.0869e-03_r8,1.3393e-02_r8,1.9013e-02_r8,2.4987e-02_r8,3.1278e-02_r8, &
     &3.7900e-02_r8,4.5296e-02_r8,4.9469e-02_r8/)
      kao(:, 2, 2, 9) = (/ &
     &1.3803e-03_r8,8.0241e-03_r8,1.3304e-02_r8,1.8903e-02_r8,2.4859e-02_r8,3.1123e-02_r8, &
     &3.7707e-02_r8,4.5049e-02_r8,4.9230e-02_r8/)
      kao(:, 3, 2, 9) = (/ &
     &1.4130e-03_r8,7.9636e-03_r8,1.3235e-02_r8,1.8828e-02_r8,2.4777e-02_r8,3.1019e-02_r8, &
     &3.7558e-02_r8,4.4839e-02_r8,4.9085e-02_r8/)
      kao(:, 4, 2, 9) = (/ &
     &1.4417e-03_r8,7.9144e-03_r8,1.3198e-02_r8,1.8807e-02_r8,2.4768e-02_r8,3.1006e-02_r8, &
     &3.7513e-02_r8,4.4699e-02_r8,4.9090e-02_r8/)
      kao(:, 5, 2, 9) = (/ &
     &1.4672e-03_r8,7.8840e-03_r8,1.3197e-02_r8,1.8844e-02_r8,2.4841e-02_r8,3.1094e-02_r8, &
     &3.7591e-02_r8,4.4701e-02_r8,4.9253e-02_r8/)
      kao(:, 1, 3, 9) = (/ &
     &2.5556e-03_r8,1.0082e-02_r8,1.5320e-02_r8,1.9920e-02_r8,2.4710e-02_r8,2.9907e-02_r8, &
     &3.5684e-02_r8,4.2430e-02_r8,4.6609e-02_r8/)
      kao(:, 2, 3, 9) = (/ &
     &2.6284e-03_r8,1.0047e-02_r8,1.5209e-02_r8,1.9796e-02_r8,2.4582e-02_r8,2.9765e-02_r8, &
     &3.5524e-02_r8,4.2220e-02_r8,4.6433e-02_r8/)
      kao(:, 3, 3, 9) = (/ &
     &2.6960e-03_r8,1.0006e-02_r8,1.5105e-02_r8,1.9696e-02_r8,2.4496e-02_r8,2.9686e-02_r8, &
     &3.5446e-02_r8,4.2085e-02_r8,4.6365e-02_r8/)
      kao(:, 4, 3, 9) = (/ &
     &2.7589e-03_r8,9.9586e-03_r8,1.5035e-02_r8,1.9644e-02_r8,2.4475e-02_r8,2.9692e-02_r8, &
     &3.5469e-02_r8,4.2071e-02_r8,4.6440e-02_r8/)
      kao(:, 5, 3, 9) = (/ &
     &2.8129e-03_r8,9.9196e-03_r8,1.4994e-02_r8,1.9639e-02_r8,2.4519e-02_r8,2.9788e-02_r8, &
     &3.5597e-02_r8,4.2188e-02_r8,4.6642e-02_r8/)
      kao(:, 1, 4, 9) = (/ &
     &4.8937e-03_r8,1.3203e-02_r8,1.8921e-02_r8,2.3296e-02_r8,2.6924e-02_r8,3.0282e-02_r8, &
     &3.4096e-02_r8,3.9071e-02_r8,4.3251e-02_r8/)
      kao(:, 2, 4, 9) = (/ &
     &5.0488e-03_r8,1.3226e-02_r8,1.8867e-02_r8,2.3170e-02_r8,2.6777e-02_r8,3.0147e-02_r8, &
     &3.3963e-02_r8,3.8948e-02_r8,4.3159e-02_r8/)
      kao(:, 3, 4, 9) = (/ &
     &5.1910e-03_r8,1.3248e-02_r8,1.8795e-02_r8,2.3060e-02_r8,2.6655e-02_r8,3.0063e-02_r8, &
     &3.3903e-02_r8,3.8899e-02_r8,4.3165e-02_r8/)
      kao(:, 4, 4, 9) = (/ &
     &5.3207e-03_r8,1.3268e-02_r8,1.8730e-02_r8,2.2981e-02_r8,2.6589e-02_r8,3.0040e-02_r8, &
     &3.3930e-02_r8,3.8970e-02_r8,4.3287e-02_r8/)
      kao(:, 5, 4, 9) = (/ &
     &5.4422e-03_r8,1.3287e-02_r8,1.8693e-02_r8,2.2945e-02_r8,2.6576e-02_r8,3.0081e-02_r8, &
     &3.4041e-02_r8,3.9135e-02_r8,4.3512e-02_r8/)
      kao(:, 1, 5, 9) = (/ &
     &8.5307e-03_r8,1.7183e-02_r8,2.3465e-02_r8,2.7970e-02_r8,3.1130e-02_r8,3.3358e-02_r8, &
     &3.4774e-02_r8,3.6613e-02_r8,3.9589e-02_r8/)
      kao(:, 2, 5, 9) = (/ &
     &8.8245e-03_r8,1.7347e-02_r8,2.3508e-02_r8,2.7937e-02_r8,3.1047e-02_r8,3.3237e-02_r8, &
     &3.4670e-02_r8,3.6530e-02_r8,3.9570e-02_r8/)
      kao(:, 3, 5, 9) = (/ &
     &9.0927e-03_r8,1.7496e-02_r8,2.3535e-02_r8,2.7881e-02_r8,3.0966e-02_r8,3.3147e-02_r8, &
     &3.4603e-02_r8,3.6513e-02_r8,3.9628e-02_r8/)
      kao(:, 4, 5, 9) = (/ &
     &9.3371e-03_r8,1.7632e-02_r8,2.3559e-02_r8,2.7829e-02_r8,3.0920e-02_r8,3.3100e-02_r8, &
     &3.4594e-02_r8,3.6581e-02_r8,3.9792e-02_r8/)
      kao(:, 5, 5, 9) = (/ &
     &9.5713e-03_r8,1.7760e-02_r8,2.3602e-02_r8,2.7816e-02_r8,3.0915e-02_r8,3.3109e-02_r8, &
     &3.4648e-02_r8,3.6731e-02_r8,4.0039e-02_r8/)
      kao(:, 1, 6, 9) = (/ &
     &1.3837e-02_r8,2.2346e-02_r8,2.8803e-02_r8,3.3403e-02_r8,3.6375e-02_r8,3.7770e-02_r8, &
     &3.7769e-02_r8,3.6158e-02_r8,3.5736e-02_r8/)
      kao(:, 2, 6, 9) = (/ &
     &1.4345e-02_r8,2.2684e-02_r8,2.9062e-02_r8,3.3523e-02_r8,3.6415e-02_r8,3.7748e-02_r8, &
     &3.7698e-02_r8,3.6127e-02_r8,3.5788e-02_r8/)
      kao(:, 3, 6, 9) = (/ &
     &1.4814e-02_r8,2.3025e-02_r8,2.9297e-02_r8,3.3616e-02_r8,3.6414e-02_r8,3.7728e-02_r8, &
     &3.7657e-02_r8,3.6132e-02_r8,3.5900e-02_r8/)
      kao(:, 4, 6, 9) = (/ &
     &1.5241e-02_r8,2.3333e-02_r8,2.9502e-02_r8,3.3707e-02_r8,3.6417e-02_r8,3.7743e-02_r8, &
     &3.7671e-02_r8,3.6177e-02_r8,3.6086e-02_r8/)
      kao(:, 5, 6, 9) = (/ &
     &1.5643e-02_r8,2.3601e-02_r8,2.9688e-02_r8,3.3808e-02_r8,3.6468e-02_r8,3.7791e-02_r8, &
     &3.7729e-02_r8,3.6273e-02_r8,3.6334e-02_r8/)
      kao(:, 1, 7, 9) = (/ &
     &2.3687e-02_r8,3.1230e-02_r8,3.7445e-02_r8,4.1636e-02_r8,4.4049e-02_r8,4.4684e-02_r8, &
     &4.3161e-02_r8,3.8835e-02_r8,3.1866e-02_r8/)
      kao(:, 2, 7, 9) = (/ &
     &2.4610e-02_r8,3.1967e-02_r8,3.8037e-02_r8,4.2097e-02_r8,4.4354e-02_r8,4.4855e-02_r8, &
     &4.3236e-02_r8,3.8850e-02_r8,3.1969e-02_r8/)
      kao(:, 3, 7, 9) = (/ &
     &2.5467e-02_r8,3.2639e-02_r8,3.8612e-02_r8,4.2519e-02_r8,4.4609e-02_r8,4.4967e-02_r8, &
     &4.3302e-02_r8,3.8885e-02_r8,3.2129e-02_r8/)
      kao(:, 4, 7, 9) = (/ &
     &2.6267e-02_r8,3.3238e-02_r8,3.9137e-02_r8,4.2894e-02_r8,4.4845e-02_r8,4.5082e-02_r8, &
     &4.3395e-02_r8,3.8965e-02_r8,3.2326e-02_r8/)
      kao(:, 5, 7, 9) = (/ &
     &2.6995e-02_r8,3.3786e-02_r8,3.9598e-02_r8,4.3239e-02_r8,4.5071e-02_r8,4.5249e-02_r8, &
     &4.3527e-02_r8,3.9067e-02_r8,3.2557e-02_r8/)
      kao(:, 1, 8, 9) = (/ &
     &4.7920e-02_r8,5.2366e-02_r8,5.6749e-02_r8,5.9168e-02_r8,5.9712e-02_r8,5.8092e-02_r8, &
     &5.3946e-02_r8,4.5783e-02_r8,2.8113e-02_r8/)
      kao(:, 2, 8, 9) = (/ &
     &4.9884e-02_r8,5.3965e-02_r8,5.8166e-02_r8,6.0347e-02_r8,6.0665e-02_r8,5.8786e-02_r8, &
     &5.4351e-02_r8,4.5985e-02_r8,2.8254e-02_r8/)
      kao(:, 3, 8, 9) = (/ &
     &5.1719e-02_r8,5.5478e-02_r8,5.9448e-02_r8,6.1483e-02_r8,6.1565e-02_r8,5.9384e-02_r8, &
     &5.4686e-02_r8,4.6159e-02_r8,2.8435e-02_r8/)
      kao(:, 4, 8, 9) = (/ &
     &5.3394e-02_r8,5.6807e-02_r8,6.0645e-02_r8,6.2509e-02_r8,6.2363e-02_r8,5.9916e-02_r8, &
     &5.4999e-02_r8,4.6361e-02_r8,2.8611e-02_r8/)
      kao(:, 5, 8, 9) = (/ &
     &5.4964e-02_r8,5.7985e-02_r8,6.1688e-02_r8,6.3442e-02_r8,6.3043e-02_r8,6.0445e-02_r8, &
     &5.5342e-02_r8,4.6592e-02_r8,2.8833e-02_r8/)
      kao(:, 1, 9, 9) = (/ &
     &1.8387e-01_r8,1.6808e-01_r8,1.5799e-01_r8,1.4671e-01_r8,1.3366e-01_r8,1.1828e-01_r8, &
     &9.9590e-02_r8,7.4670e-02_r8,2.3960e-02_r8/)
      kao(:, 2, 9, 9) = (/ &
     &1.9171e-01_r8,1.7460e-01_r8,1.6351e-01_r8,1.5144e-01_r8,1.3758e-01_r8,1.2130e-01_r8, &
     &1.0166e-01_r8,7.5740e-02_r8,2.4137e-02_r8/)
      kao(:, 3, 9, 9) = (/ &
     &1.9894e-01_r8,1.8065e-01_r8,1.6862e-01_r8,1.5587e-01_r8,1.4113e-01_r8,1.2411e-01_r8, &
     &1.0364e-01_r8,7.6719e-02_r8,2.4294e-02_r8/)
      kao(:, 4, 9, 9) = (/ &
     &2.0563e-01_r8,1.8623e-01_r8,1.7319e-01_r8,1.5976e-01_r8,1.4435e-01_r8,1.2672e-01_r8, &
     &1.0542e-01_r8,7.7598e-02_r8,2.4446e-02_r8/)
      kao(:, 5, 9, 9) = (/ &
     &2.1200e-01_r8,1.9152e-01_r8,1.7746e-01_r8,1.6330e-01_r8,1.4720e-01_r8,1.2898e-01_r8, &
     &1.0699e-01_r8,7.8411e-02_r8,2.4664e-02_r8/)
      kao(:, 1,10, 9) = (/ &
     &7.9805e-01_r8,7.0103e-01_r8,6.0984e-01_r8,5.2274e-01_r8,4.3812e-01_r8,3.5220e-01_r8, &
     &2.6270e-01_r8,1.6632e-01_r8,1.8620e-02_r8/)
      kao(:, 2,10, 9) = (/ &
     &8.3214e-01_r8,7.3068e-01_r8,6.3476e-01_r8,5.4295e-01_r8,4.5426e-01_r8,3.6461e-01_r8, &
     &2.7128e-01_r8,1.7099e-01_r8,1.8699e-02_r8/)
      kao(:, 3,10, 9) = (/ &
     &8.6405e-01_r8,7.5844e-01_r8,6.5814e-01_r8,5.6198e-01_r8,4.6922e-01_r8,3.7620e-01_r8, &
     &2.7918e-01_r8,1.7530e-01_r8,1.8761e-02_r8/)
      kao(:, 4,10, 9) = (/ &
     &8.9399e-01_r8,7.8448e-01_r8,6.8005e-01_r8,5.7978e-01_r8,4.8302e-01_r8,3.8668e-01_r8, &
     &2.8631e-01_r8,1.7930e-01_r8,1.8825e-02_r8/)
      kao(:, 5,10, 9) = (/ &
     &9.2229e-01_r8,8.0909e-01_r8,7.0076e-01_r8,5.9657e-01_r8,4.9598e-01_r8,3.9642e-01_r8, &
     &2.9286e-01_r8,1.8285e-01_r8,1.8959e-02_r8/)
      kao(:, 1,11, 9) = (/ &
     &1.2376e+00_r8,1.0851e+00_r8,9.3781e-01_r8,7.9479e-01_r8,6.5536e-01_r8,5.1636e-01_r8, &
     &3.7350e-01_r8,2.2328e-01_r8,1.9046e-02_r8/)
      kao(:, 2,11, 9) = (/ &
     &1.2888e+00_r8,1.1296e+00_r8,9.7557e-01_r8,8.2566e-01_r8,6.7951e-01_r8,5.3467e-01_r8, &
     &3.8601e-01_r8,2.3011e-01_r8,1.9117e-02_r8/)
      kao(:, 3,11, 9) = (/ &
     &1.3372e+00_r8,1.1719e+00_r8,1.0114e+00_r8,8.5500e-01_r8,7.0234e-01_r8,5.5187e-01_r8, &
     &3.9765e-01_r8,2.3639e-01_r8,1.9165e-02_r8/)
      kao(:, 4,11, 9) = (/ &
     &1.3819e+00_r8,1.2109e+00_r8,1.0444e+00_r8,8.8194e-01_r8,7.2332e-01_r8,5.6752e-01_r8, &
     &4.0827e-01_r8,2.4219e-01_r8,1.9058e-02_r8/)
      kao(:, 5,11, 9) = (/ &
     &1.4259e+00_r8,1.2494e+00_r8,1.0769e+00_r8,9.0854e-01_r8,7.4408e-01_r8,5.8286e-01_r8, &
     &4.1859e-01_r8,2.4748e-01_r8,1.9067e-02_r8/)
      kao(:, 1,12, 9) = (/ &
     &1.4243e+00_r8,1.2488e+00_r8,1.0789e+00_r8,9.1317e-01_r8,7.5092e-01_r8,5.8812e-01_r8, &
     &4.2112e-01_r8,2.4611e-01_r8,1.9872e-02_r8/)
      kao(:, 2,12, 9) = (/ &
     &1.4836e+00_r8,1.3004e+00_r8,1.1224e+00_r8,9.4876e-01_r8,7.7876e-01_r8,6.0917e-01_r8, &
     &4.3528e-01_r8,2.5376e-01_r8,2.0064e-02_r8/)
      kao(:, 3,12, 9) = (/ &
     &1.5386e+00_r8,1.3484e+00_r8,1.1631e+00_r8,9.8199e-01_r8,8.0461e-01_r8,6.2868e-01_r8, &
     &4.4843e-01_r8,2.6085e-01_r8,2.0179e-02_r8/)
      kao(:, 4,12, 9) = (/ &
     &1.5909e+00_r8,1.3940e+00_r8,1.2017e+00_r8,1.0136e+00_r8,8.2931e-01_r8,6.4713e-01_r8, &
     &4.6088e-01_r8,2.6745e-01_r8,2.0157e-02_r8/)
      kao(:, 5,12, 9) = (/ &
     &1.6423e+00_r8,1.4388e+00_r8,1.2396e+00_r8,1.0446e+00_r8,8.5343e-01_r8,6.6506e-01_r8, &
     &4.7297e-01_r8,2.7367e-01_r8,2.0135e-02_r8/)
      kao(:, 1,13, 9) = (/ &
     &1.3090e+00_r8,1.1487e+00_r8,9.9498e-01_r8,8.4529e-01_r8,6.9751e-01_r8,5.4690e-01_r8, &
     &3.9201e-01_r8,2.2831e-01_r8,1.9648e-02_r8/)
      kao(:, 2,13, 9) = (/ &
     &1.3642e+00_r8,1.1967e+00_r8,1.0354e+00_r8,8.7822e-01_r8,7.2355e-01_r8,5.6643e-01_r8, &
     &4.0528e-01_r8,2.3543e-01_r8,1.9783e-02_r8/)
      kao(:, 3,13, 9) = (/ &
     &1.4156e+00_r8,1.2415e+00_r8,1.0731e+00_r8,9.0892e-01_r8,7.4783e-01_r8,5.8491e-01_r8, &
     &4.1788e-01_r8,2.4217e-01_r8,1.9878e-02_r8/)
      kao(:, 4,13, 9) = (/ &
     &1.4652e+00_r8,1.2846e+00_r8,1.1094e+00_r8,9.3863e-01_r8,7.7135e-01_r8,6.0268e-01_r8, &
     &4.2988e-01_r8,2.4851e-01_r8,1.9864e-02_r8/)
      kao(:, 5,13, 9) = (/ &
     &1.5126e+00_r8,1.3260e+00_r8,1.1446e+00_r8,9.6741e-01_r8,7.9378e-01_r8,6.1968e-01_r8, &
     &4.4123e-01_r8,2.5440e-01_r8,1.9877e-02_r8/)
      kao(:, 1, 1,10) = (/ &
     &3.3844e-03_r8,1.5864e-02_r8,3.0967e-02_r8,4.5960e-02_r8,6.0759e-02_r8,7.5076e-02_r8, &
     &8.8299e-02_r8,9.7840e-02_r8,1.2109e-01_r8/)
      kao(:, 2, 1,10) = (/ &
     &3.3774e-03_r8,1.5840e-02_r8,3.0916e-02_r8,4.5912e-02_r8,6.0698e-02_r8,7.5010e-02_r8, &
     &8.8211e-02_r8,9.7731e-02_r8,1.2099e-01_r8/)
      kao(:, 3, 1,10) = (/ &
     &3.3575e-03_r8,1.5844e-02_r8,3.0912e-02_r8,4.5937e-02_r8,6.0728e-02_r8,7.5022e-02_r8, &
     &8.8124e-02_r8,9.7474e-02_r8,1.2106e-01_r8/)
      kao(:, 4, 1,10) = (/ &
     &3.3333e-03_r8,1.5824e-02_r8,3.0829e-02_r8,4.5838e-02_r8,6.0646e-02_r8,7.4990e-02_r8, &
     &8.8084e-02_r8,9.7173e-02_r8,1.2089e-01_r8/)
      kao(:, 5, 1,10) = (/ &
     &3.3084e-03_r8,1.5776e-02_r8,3.0693e-02_r8,4.5649e-02_r8,6.0428e-02_r8,7.4773e-02_r8, &
     &8.7909e-02_r8,9.6839e-02_r8,1.2042e-01_r8/)
      kao(:, 1, 2,10) = (/ &
     &5.1392e-03_r8,1.7464e-02_r8,3.2432e-02_r8,4.7915e-02_r8,6.3487e-02_r8,7.8847e-02_r8, &
     &9.3621e-02_r8,1.0600e-01_r8,1.2635e-01_r8/)
      kao(:, 2, 2,10) = (/ &
     &5.1325e-03_r8,1.7471e-02_r8,3.2464e-02_r8,4.7934e-02_r8,6.3521e-02_r8,7.8889e-02_r8, &
     &9.3606e-02_r8,1.0592e-01_r8,1.2642e-01_r8/)
      kao(:, 3, 2,10) = (/ &
     &5.1157e-03_r8,1.7466e-02_r8,3.2343e-02_r8,4.7787e-02_r8,6.3340e-02_r8,7.8722e-02_r8, &
     &9.3575e-02_r8,1.0588e-01_r8,1.2605e-01_r8/)
      kao(:, 4, 2,10) = (/ &
     &5.0987e-03_r8,1.7399e-02_r8,3.2075e-02_r8,4.7428e-02_r8,6.2893e-02_r8,7.8221e-02_r8, &
     &9.3145e-02_r8,1.0589e-01_r8,1.2513e-01_r8/)
      kao(:, 5, 2,10) = (/ &
     &5.0781e-03_r8,1.7287e-02_r8,3.1803e-02_r8,4.7068e-02_r8,6.2420e-02_r8,7.7655e-02_r8, &
     &9.2528e-02_r8,1.0558e-01_r8,1.2418e-01_r8/)
      kao(:, 1, 3,10) = (/ &
     &1.0449e-02_r8,2.2920e-02_r8,3.5229e-02_r8,4.9841e-02_r8,6.5300e-02_r8,8.0993e-02_r8, &
     &9.6715e-02_r8,1.1178e-01_r8,1.2900e-01_r8/)
      kao(:, 2, 3,10) = (/ &
     &1.0475e-02_r8,2.2840e-02_r8,3.5278e-02_r8,4.9881e-02_r8,6.5245e-02_r8,8.1037e-02_r8, &
     &9.6863e-02_r8,1.1212e-01_r8,1.2899e-01_r8/)
      kao(:, 3, 3,10) = (/ &
     &1.0487e-02_r8,2.2756e-02_r8,3.5213e-02_r8,4.9645e-02_r8,6.4866e-02_r8,8.0649e-02_r8, &
     &9.6451e-02_r8,1.1190e-01_r8,1.2830e-01_r8/)
      kao(:, 4, 3,10) = (/ &
     &1.0493e-02_r8,2.2711e-02_r8,3.4996e-02_r8,4.9204e-02_r8,6.4312e-02_r8,7.9994e-02_r8, &
     &9.5693e-02_r8,1.1109e-01_r8,1.2723e-01_r8/)
      kao(:, 5, 3,10) = (/ &
     &1.0487e-02_r8,2.2599e-02_r8,3.4737e-02_r8,4.8786e-02_r8,6.3856e-02_r8,7.9443e-02_r8, &
     &9.5024e-02_r8,1.1021e-01_r8,1.2638e-01_r8/)
      kao(:, 1, 4,10) = (/ &
     &2.1474e-02_r8,3.4011e-02_r8,4.5615e-02_r8,5.6742e-02_r8,6.8329e-02_r8,8.2791e-02_r8, &
     &9.7759e-02_r8,1.1367e-01_r8,1.2934e-01_r8/)
      kao(:, 2, 4,10) = (/ &
     &2.1593e-02_r8,3.3751e-02_r8,4.5521e-02_r8,5.6645e-02_r8,6.8211e-02_r8,8.2434e-02_r8, &
     &9.7517e-02_r8,1.1348e-01_r8,1.2896e-01_r8/)
      kao(:, 3, 4,10) = (/ &
     &2.1694e-02_r8,3.3429e-02_r8,4.5406e-02_r8,5.6399e-02_r8,6.7862e-02_r8,8.1741e-02_r8, &
     &9.6866e-02_r8,1.1284e-01_r8,1.2803e-01_r8/)
      kao(:, 4, 4,10) = (/ &
     &2.1761e-02_r8,3.3088e-02_r8,4.5200e-02_r8,5.5990e-02_r8,6.7313e-02_r8,8.0951e-02_r8, &
     &9.6103e-02_r8,1.1192e-01_r8,1.2712e-01_r8/)
      kao(:, 5, 4,10) = (/ &
     &2.1871e-02_r8,3.2779e-02_r8,4.4802e-02_r8,5.5607e-02_r8,6.6864e-02_r8,8.0377e-02_r8, &
     &9.5554e-02_r8,1.1124e-01_r8,1.2647e-01_r8/)
      kao(:, 1, 5,10) = (/ &
     &3.9770e-02_r8,5.1894e-02_r8,6.3327e-02_r8,7.2180e-02_r8,8.0917e-02_r8,8.8056e-02_r8, &
     &9.8598e-02_r8,1.1206e-01_r8,1.2671e-01_r8/)
      kao(:, 2, 5,10) = (/ &
     &4.0140e-02_r8,5.1409e-02_r8,6.3212e-02_r8,7.2060e-02_r8,8.0506e-02_r8,8.7647e-02_r8, &
     &9.8026e-02_r8,1.1163e-01_r8,1.2617e-01_r8/)
      kao(:, 3, 5,10) = (/ &
     &4.0492e-02_r8,5.0925e-02_r8,6.2882e-02_r8,7.1952e-02_r8,8.0008e-02_r8,8.6965e-02_r8, &
     &9.7225e-02_r8,1.1094e-01_r8,1.2542e-01_r8/)
      kao(:, 4, 5,10) = (/ &
     &4.0826e-02_r8,5.0532e-02_r8,6.2408e-02_r8,7.1612e-02_r8,7.9337e-02_r8,8.6238e-02_r8, &
     &9.6327e-02_r8,1.1019e-01_r8,1.2470e-01_r8/)
      kao(:, 5, 5,10) = (/ &
     &4.1162e-02_r8,5.0261e-02_r8,6.1890e-02_r8,7.0980e-02_r8,7.8777e-02_r8,8.5713e-02_r8, &
     &9.5778e-02_r8,1.0986e-01_r8,1.2449e-01_r8/)
      kao(:, 1, 6,10) = (/ &
     &6.7916e-02_r8,7.7649e-02_r8,8.9172e-02_r8,9.6900e-02_r8,1.0149e-01_r8,1.0503e-01_r8, &
     &1.0523e-01_r8,1.0994e-01_r8,1.2156e-01_r8/)
      kao(:, 2, 6,10) = (/ &
     &6.8757e-02_r8,7.7814e-02_r8,8.8891e-02_r8,9.7030e-02_r8,1.0144e-01_r8,1.0468e-01_r8, &
     &1.0479e-01_r8,1.0906e-01_r8,1.2102e-01_r8/)
      kao(:, 3, 6,10) = (/ &
     &6.9572e-02_r8,7.7629e-02_r8,8.8407e-02_r8,9.6716e-02_r8,1.0124e-01_r8,1.0403e-01_r8, &
     &1.0408e-01_r8,1.0810e-01_r8,1.2040e-01_r8/)
      kao(:, 4, 6,10) = (/ &
     &7.0420e-02_r8,7.7345e-02_r8,8.8011e-02_r8,9.6134e-02_r8,1.0079e-01_r8,1.0305e-01_r8, &
     &1.0321e-01_r8,1.0749e-01_r8,1.2017e-01_r8/)
      kao(:, 5, 6,10) = (/ &
     &7.1176e-02_r8,7.7213e-02_r8,8.7761e-02_r8,9.5353e-02_r8,9.9879e-02_r8,1.0215e-01_r8, &
     &1.0265e-01_r8,1.0733e-01_r8,1.2038e-01_r8/)
      kao(:, 1, 7,10) = (/ &
     &1.2127e-01_r8,1.2412e-01_r8,1.3217e-01_r8,1.3765e-01_r8,1.3951e-01_r8,1.3625e-01_r8, &
     &1.2814e-01_r8,1.1487e-01_r8,1.1426e-01_r8/)
      kao(:, 2, 7,10) = (/ &
     &1.2309e-01_r8,1.2453e-01_r8,1.3252e-01_r8,1.3798e-01_r8,1.3976e-01_r8,1.3644e-01_r8, &
     &1.2796e-01_r8,1.1426e-01_r8,1.1391e-01_r8/)
      kao(:, 3, 7,10) = (/ &
     &1.2489e-01_r8,1.2494e-01_r8,1.3228e-01_r8,1.3764e-01_r8,1.3951e-01_r8,1.3625e-01_r8, &
     &1.2756e-01_r8,1.1350e-01_r8,1.1349e-01_r8/)
      kao(:, 4, 7,10) = (/ &
     &1.2680e-01_r8,1.2557e-01_r8,1.3198e-01_r8,1.3739e-01_r8,1.3886e-01_r8,1.3552e-01_r8, &
     &1.2649e-01_r8,1.1282e-01_r8,1.1362e-01_r8/)
      kao(:, 5, 7,10) = (/ &
     &1.2852e-01_r8,1.2615e-01_r8,1.3199e-01_r8,1.3726e-01_r8,1.3802e-01_r8,1.3430e-01_r8, &
     &1.2550e-01_r8,1.1257e-01_r8,1.1419e-01_r8/)
      kao(:, 1, 8,10) = (/ &
     &2.5214e-01_r8,2.3134e-01_r8,2.3152e-01_r8,2.2506e-01_r8,2.1543e-01_r8,2.0242e-01_r8, &
     &1.8079e-01_r8,1.4566e-01_r8,1.0565e-01_r8/)
      kao(:, 2, 8,10) = (/ &
     &2.5695e-01_r8,2.3363e-01_r8,2.3275e-01_r8,2.2604e-01_r8,2.1637e-01_r8,2.0282e-01_r8, &
     &1.8105e-01_r8,1.4554e-01_r8,1.0546e-01_r8/)
      kao(:, 3, 8,10) = (/ &
     &2.6176e-01_r8,2.3588e-01_r8,2.3395e-01_r8,2.2621e-01_r8,2.1636e-01_r8,2.0257e-01_r8, &
     &1.8076e-01_r8,1.4513e-01_r8,1.0533e-01_r8/)
      kao(:, 4, 8,10) = (/ &
     &2.6651e-01_r8,2.3871e-01_r8,2.3539e-01_r8,2.2647e-01_r8,2.1633e-01_r8,2.0229e-01_r8, &
     &1.8002e-01_r8,1.4419e-01_r8,1.0597e-01_r8/)
      kao(:, 5, 8,10) = (/ &
     &2.7042e-01_r8,2.4131e-01_r8,2.3677e-01_r8,2.2700e-01_r8,2.1683e-01_r8,2.0167e-01_r8, &
     &1.7891e-01_r8,1.4342e-01_r8,1.0666e-01_r8/)
      kao(:, 1, 9,10) = (/ &
     &9.7736e-01_r8,8.5726e-01_r8,7.4530e-01_r8,6.6330e-01_r8,5.7895e-01_r8,4.8711e-01_r8, &
     &3.8944e-01_r8,2.7986e-01_r8,9.6120e-02_r8/)
      kao(:, 2, 9,10) = (/ &
     &1.0005e+00_r8,8.7740e-01_r8,7.5935e-01_r8,6.7173e-01_r8,5.8495e-01_r8,4.9078e-01_r8, &
     &3.9206e-01_r8,2.8024e-01_r8,9.6028e-02_r8/)
      kao(:, 3, 9,10) = (/ &
     &1.0238e+00_r8,8.9765e-01_r8,7.7412e-01_r8,6.7963e-01_r8,5.9056e-01_r8,4.9392e-01_r8, &
     &3.9381e-01_r8,2.7971e-01_r8,9.6387e-02_r8/)
      kao(:, 4, 9,10) = (/ &
     &1.0459e+00_r8,9.1704e-01_r8,7.8954e-01_r8,6.8917e-01_r8,5.9755e-01_r8,4.9657e-01_r8, &
     &3.9497e-01_r8,2.7927e-01_r8,9.7373e-02_r8/)
      kao(:, 5, 9,10) = (/ &
     &1.0630e+00_r8,9.3201e-01_r8,8.0170e-01_r8,6.9634e-01_r8,6.0306e-01_r8,4.9955e-01_r8, &
     &3.9651e-01_r8,2.7910e-01_r8,9.7962e-02_r8/)
      kao(:, 1,10,10) = (/ &
     &4.2057e+00_r8,3.6817e+00_r8,3.1579e+00_r8,2.6346e+00_r8,2.1198e+00_r8,1.6450e+00_r8, &
     &1.1902e+00_r8,7.0817e-01_r8,7.8303e-02_r8/)
      kao(:, 2,10,10) = (/ &
     &4.3277e+00_r8,3.7881e+00_r8,3.2491e+00_r8,2.7104e+00_r8,2.1754e+00_r8,1.6774e+00_r8, &
     &1.2094e+00_r8,7.1654e-01_r8,7.8798e-02_r8/)
      kao(:, 3,10,10) = (/ &
     &4.4500e+00_r8,3.8956e+00_r8,3.3411e+00_r8,2.7869e+00_r8,2.2338e+00_r8,1.7120e+00_r8, &
     &1.2289e+00_r8,7.2324e-01_r8,7.8857e-02_r8/)
      kao(:, 4,10,10) = (/ &
     &4.5562e+00_r8,3.9883e+00_r8,3.4205e+00_r8,2.8532e+00_r8,2.2862e+00_r8,1.7446e+00_r8, &
     &1.2492e+00_r8,7.3045e-01_r8,7.9497e-02_r8/)
      kao(:, 5,10,10) = (/ &
     &4.6429e+00_r8,4.0644e+00_r8,3.4858e+00_r8,2.9077e+00_r8,2.3298e+00_r8,1.7714e+00_r8, &
     &1.2652e+00_r8,7.3636e-01_r8,7.8315e-02_r8/)
      kao(:, 1,11,10) = (/ &
     &6.3643e+00_r8,5.5702e+00_r8,4.7761e+00_r8,3.9823e+00_r8,3.1901e+00_r8,2.4267e+00_r8, &
     &1.7139e+00_r8,9.8175e-01_r8,5.2396e-02_r8/)
      kao(:, 2,11,10) = (/ &
     &6.5707e+00_r8,5.7511e+00_r8,4.9312e+00_r8,4.1117e+00_r8,3.2928e+00_r8,2.4948e+00_r8, &
     &1.7532e+00_r8,9.9614e-01_r8,5.2761e-02_r8/)
      kao(:, 3,11,10) = (/ &
     &6.7598e+00_r8,5.9160e+00_r8,5.0729e+00_r8,4.2301e+00_r8,3.3876e+00_r8,2.5590e+00_r8, &
     &1.7914e+00_r8,1.0123e+00_r8,5.3574e-02_r8/)
      kao(:, 4,11,10) = (/ &
     &6.9211e+00_r8,6.0577e+00_r8,5.1942e+00_r8,4.3313e+00_r8,3.4687e+00_r8,2.6150e+00_r8, &
     &1.8227e+00_r8,1.0262e+00_r8,5.6608e-02_r8/)
      kao(:, 5,11,10) = (/ &
     &7.0466e+00_r8,6.1673e+00_r8,5.2885e+00_r8,4.4096e+00_r8,3.5315e+00_r8,2.6584e+00_r8, &
     &1.8463e+00_r8,1.0382e+00_r8,5.6583e-02_r8/)
      kao(:, 1,12,10) = (/ &
     &7.1591e+00_r8,6.2650e+00_r8,5.3715e+00_r8,4.4783e+00_r8,3.5872e+00_r8,2.7305e+00_r8, &
     &1.9173e+00_r8,1.0829e+00_r8,5.4364e-02_r8/)
      kao(:, 2,12,10) = (/ &
     &7.3899e+00_r8,6.4678e+00_r8,5.5455e+00_r8,4.6234e+00_r8,3.7023e+00_r8,2.8086e+00_r8, &
     &1.9670e+00_r8,1.1039e+00_r8,5.3004e-02_r8/)
      kao(:, 3,12,10) = (/ &
     &7.5932e+00_r8,6.6457e+00_r8,5.6978e+00_r8,4.7509e+00_r8,3.8044e+00_r8,2.8774e+00_r8, &
     &2.0093e+00_r8,1.1228e+00_r8,5.1959e-02_r8/)
      kao(:, 4,12,10) = (/ &
     &7.7612e+00_r8,6.7925e+00_r8,5.8241e+00_r8,4.8562e+00_r8,3.8890e+00_r8,2.9344e+00_r8, &
     &2.0429e+00_r8,1.1393e+00_r8,5.3174e-02_r8/)
      kao(:, 5,12,10) = (/ &
     &7.8969e+00_r8,6.9118e+00_r8,5.9263e+00_r8,4.9415e+00_r8,3.9571e+00_r8,2.9804e+00_r8, &
     &2.0685e+00_r8,1.1516e+00_r8,5.1704e-02_r8/)
      kao(:, 1,13,10) = (/ &
     &6.4705e+00_r8,5.6627e+00_r8,4.8551e+00_r8,4.0480e+00_r8,3.2529e+00_r8,2.5042e+00_r8, &
     &1.7607e+00_r8,9.9775e-01_r8,5.2819e-02_r8/)
      kao(:, 2,13,10) = (/ &
     &6.6649e+00_r8,5.8328e+00_r8,5.0012e+00_r8,4.1701e+00_r8,3.3469e+00_r8,2.5698e+00_r8, &
     &1.8026e+00_r8,1.0186e+00_r8,5.2318e-02_r8/)
      kao(:, 3,13,10) = (/ &
     &6.8320e+00_r8,5.9796e+00_r8,5.1272e+00_r8,4.2755e+00_r8,3.4276e+00_r8,2.6233e+00_r8, &
     &1.8383e+00_r8,1.0369e+00_r8,5.1248e-02_r8/)
      kao(:, 4,13,10) = (/ &
     &6.9674e+00_r8,6.0982e+00_r8,5.2289e+00_r8,4.3604e+00_r8,3.4933e+00_r8,2.6647e+00_r8, &
     &1.8662e+00_r8,1.0505e+00_r8,5.2356e-02_r8/)
      kao(:, 5,13,10) = (/ &
     &7.0874e+00_r8,6.2027e+00_r8,5.3188e+00_r8,4.4355e+00_r8,3.5528e+00_r8,2.7014e+00_r8, &
     &1.8899e+00_r8,1.0614e+00_r8,5.1111e-02_r8/)
      kao(:, 1, 1,11) = (/ &
     &4.6742e-03_r8,2.0279e-02_r8,3.9426e-02_r8,5.8543e-02_r8,7.7272e-02_r8,9.5241e-02_r8, &
     &1.1148e-01_r8,1.2235e-01_r8,1.5408e-01_r8/)
      kao(:, 2, 1,11) = (/ &
     &4.6073e-03_r8,2.0296e-02_r8,3.9412e-02_r8,5.8523e-02_r8,7.7232e-02_r8,9.5132e-02_r8, &
     &1.1121e-01_r8,1.2184e-01_r8,1.5399e-01_r8/)
      kao(:, 3, 1,11) = (/ &
     &4.5565e-03_r8,2.0227e-02_r8,3.9298e-02_r8,5.8356e-02_r8,7.7038e-02_r8,9.4961e-02_r8, &
     &1.1109e-01_r8,1.2151e-01_r8,1.5359e-01_r8/)
      kao(:, 4, 1,11) = (/ &
     &4.5047e-03_r8,2.0130e-02_r8,3.9180e-02_r8,5.8173e-02_r8,7.6772e-02_r8,9.4618e-02_r8, &
     &1.1074e-01_r8,1.2134e-01_r8,1.5306e-01_r8/)
      kao(:, 5, 1,11) = (/ &
     &4.4540e-03_r8,2.0027e-02_r8,3.9084e-02_r8,5.8025e-02_r8,7.6535e-02_r8,9.4251e-02_r8, &
     &1.1025e-01_r8,1.2116e-01_r8,1.5260e-01_r8/)
      kao(:, 1, 2,11) = (/ &
     &7.4064e-03_r8,2.2194e-02_r8,4.1767e-02_r8,6.1911e-02_r8,8.1938e-02_r8,1.0155e-01_r8, &
     &1.2014e-01_r8,1.3485e-01_r8,1.6319e-01_r8/)
      kao(:, 2, 2,11) = (/ &
     &7.3108e-03_r8,2.2143e-02_r8,4.1684e-02_r8,6.1877e-02_r8,8.1902e-02_r8,1.0152e-01_r8, &
     &1.2013e-01_r8,1.3472e-01_r8,1.6312e-01_r8/)
      kao(:, 3, 2,11) = (/ &
     &7.2232e-03_r8,2.2079e-02_r8,4.1677e-02_r8,6.1891e-02_r8,8.1918e-02_r8,1.0151e-01_r8, &
     &1.1999e-01_r8,1.3454e-01_r8,1.6316e-01_r8/)
      kao(:, 4, 2,11) = (/ &
     &7.1304e-03_r8,2.2033e-02_r8,4.1736e-02_r8,6.1998e-02_r8,8.2035e-02_r8,1.0158e-01_r8, &
     &1.1988e-01_r8,1.3411e-01_r8,1.6341e-01_r8/)
      kao(:, 5, 2,11) = (/ &
     &7.0357e-03_r8,2.1988e-02_r8,4.1742e-02_r8,6.2041e-02_r8,8.2077e-02_r8,1.0158e-01_r8, &
     &1.1983e-01_r8,1.3366e-01_r8,1.6350e-01_r8/)
      kao(:, 1, 3,11) = (/ &
     &1.5774e-02_r8,2.9169e-02_r8,4.5962e-02_r8,6.5827e-02_r8,8.6496e-02_r8,1.0742e-01_r8, &
     &1.2791e-01_r8,1.4653e-01_r8,1.7156e-01_r8/)
      kao(:, 2, 3,11) = (/ &
     &1.5614e-02_r8,2.8989e-02_r8,4.5846e-02_r8,6.5612e-02_r8,8.6438e-02_r8,1.0734e-01_r8, &
     &1.2776e-01_r8,1.4623e-01_r8,1.7149e-01_r8/)
      kao(:, 3, 3,11) = (/ &
     &1.5422e-02_r8,2.8825e-02_r8,4.5777e-02_r8,6.5531e-02_r8,8.6532e-02_r8,1.0747e-01_r8, &
     &1.2790e-01_r8,1.4632e-01_r8,1.7170e-01_r8/)
      kao(:, 4, 3,11) = (/ &
     &1.5220e-02_r8,2.8664e-02_r8,4.5718e-02_r8,6.5531e-02_r8,8.6682e-02_r8,1.0768e-01_r8, &
     &1.2815e-01_r8,1.4661e-01_r8,1.7201e-01_r8/)
      kao(:, 5, 3,11) = (/ &
     &1.5041e-02_r8,2.8491e-02_r8,4.5554e-02_r8,6.5387e-02_r8,8.6561e-02_r8,1.0758e-01_r8, &
     &1.2814e-01_r8,1.4679e-01_r8,1.7174e-01_r8/)
      kao(:, 1, 4,11) = (/ &
     &3.3773e-02_r8,4.4438e-02_r8,5.9281e-02_r8,7.3962e-02_r8,9.2405e-02_r8,1.1202e-01_r8, &
     &1.3347e-01_r8,1.5431e-01_r8,1.7769e-01_r8/)
      kao(:, 2, 4,11) = (/ &
     &3.3523e-02_r8,4.4307e-02_r8,5.8961e-02_r8,7.3730e-02_r8,9.2117e-02_r8,1.1213e-01_r8, &
     &1.3369e-01_r8,1.5450e-01_r8,1.7797e-01_r8/)
      kao(:, 3, 4,11) = (/ &
     &3.3236e-02_r8,4.4011e-02_r8,5.8687e-02_r8,7.3516e-02_r8,9.1754e-02_r8,1.1213e-01_r8, &
     &1.3376e-01_r8,1.5472e-01_r8,1.7805e-01_r8/)
      kao(:, 4, 4,11) = (/ &
     &3.2927e-02_r8,4.3662e-02_r8,5.8418e-02_r8,7.3212e-02_r8,9.1231e-02_r8,1.1190e-01_r8, &
     &1.3353e-01_r8,1.5459e-01_r8,1.7761e-01_r8/)
      kao(:, 5, 4,11) = (/ &
     &3.2628e-02_r8,4.3294e-02_r8,5.8201e-02_r8,7.2680e-02_r8,9.0434e-02_r8,1.1128e-01_r8, &
     &1.3281e-01_r8,1.5389e-01_r8,1.7655e-01_r8/)
      kao(:, 1, 5,11) = (/ &
     &6.5323e-02_r8,7.2628e-02_r8,8.3508e-02_r8,9.5963e-02_r8,1.0655e-01_r8,1.2020e-01_r8, &
     &1.3782e-01_r8,1.5923e-01_r8,1.8200e-01_r8/)
      kao(:, 2, 5,11) = (/ &
     &6.5064e-02_r8,7.2406e-02_r8,8.3203e-02_r8,9.5444e-02_r8,1.0632e-01_r8,1.1979e-01_r8, &
     &1.3760e-01_r8,1.5925e-01_r8,1.8207e-01_r8/)
      kao(:, 3, 5,11) = (/ &
     &6.4756e-02_r8,7.1969e-02_r8,8.2862e-02_r8,9.4908e-02_r8,1.0590e-01_r8,1.1930e-01_r8, &
     &1.3724e-01_r8,1.5904e-01_r8,1.8162e-01_r8/)
      kao(:, 4, 5,11) = (/ &
     &6.4304e-02_r8,7.1135e-02_r8,8.2400e-02_r8,9.4416e-02_r8,1.0531e-01_r8,1.1853e-01_r8, &
     &1.3656e-01_r8,1.5838e-01_r8,1.8061e-01_r8/)
      kao(:, 5, 5,11) = (/ &
     &6.3847e-02_r8,7.0072e-02_r8,8.1806e-02_r8,9.3969e-02_r8,1.0427e-01_r8,1.1735e-01_r8, &
     &1.3557e-01_r8,1.5724e-01_r8,1.7920e-01_r8/)
      kao(:, 1, 6,11) = (/ &
     &1.1614e-01_r8,1.1612e-01_r8,1.2461e-01_r8,1.3093e-01_r8,1.3774e-01_r8,1.4186e-01_r8, &
     &1.4765e-01_r8,1.6150e-01_r8,1.8364e-01_r8/)
      kao(:, 2, 6,11) = (/ &
     &1.1619e-01_r8,1.1550e-01_r8,1.2387e-01_r8,1.3036e-01_r8,1.3714e-01_r8,1.4135e-01_r8, &
     &1.4700e-01_r8,1.6131e-01_r8,1.8335e-01_r8/)
      kao(:, 3, 6,11) = (/ &
     &1.1615e-01_r8,1.1477e-01_r8,1.2280e-01_r8,1.2991e-01_r8,1.3667e-01_r8,1.4072e-01_r8, &
     &1.4596e-01_r8,1.6062e-01_r8,1.8242e-01_r8/)
      kao(:, 4, 6,11) = (/ &
     &1.1574e-01_r8,1.1387e-01_r8,1.2156e-01_r8,1.2938e-01_r8,1.3597e-01_r8,1.3977e-01_r8, &
     &1.4470e-01_r8,1.5943e-01_r8,1.8095e-01_r8/)
      kao(:, 5, 6,11) = (/ &
     &1.1520e-01_r8,1.1286e-01_r8,1.2034e-01_r8,1.2877e-01_r8,1.3515e-01_r8,1.3854e-01_r8, &
     &1.4325e-01_r8,1.5816e-01_r8,1.7948e-01_r8/)
      kao(:, 1, 7,11) = (/ &
     &2.1510e-01_r8,1.9619e-01_r8,2.0174e-01_r8,1.9935e-01_r8,1.9475e-01_r8,1.8847e-01_r8, &
     &1.8001e-01_r8,1.6816e-01_r8,1.8086e-01_r8/)
      kao(:, 2, 7,11) = (/ &
     &2.1625e-01_r8,1.9617e-01_r8,2.0091e-01_r8,1.9825e-01_r8,1.9429e-01_r8,1.8801e-01_r8, &
     &1.7902e-01_r8,1.6736e-01_r8,1.8038e-01_r8/)
      kao(:, 3, 7,11) = (/ &
     &2.1700e-01_r8,1.9569e-01_r8,1.9979e-01_r8,1.9686e-01_r8,1.9372e-01_r8,1.8767e-01_r8, &
     &1.7767e-01_r8,1.6608e-01_r8,1.7932e-01_r8/)
      kao(:, 4, 7,11) = (/ &
     &2.1676e-01_r8,1.9471e-01_r8,1.9847e-01_r8,1.9536e-01_r8,1.9293e-01_r8,1.8720e-01_r8, &
     &1.7635e-01_r8,1.6450e-01_r8,1.7799e-01_r8/)
      kao(:, 5, 7,11) = (/ &
     &2.1625e-01_r8,1.9358e-01_r8,1.9672e-01_r8,1.9373e-01_r8,1.9213e-01_r8,1.8631e-01_r8, &
     &1.7483e-01_r8,1.6262e-01_r8,1.7662e-01_r8/)
      kao(:, 1, 8,11) = (/ &
     &4.6382e-01_r8,4.0807e-01_r8,3.7899e-01_r8,3.5840e-01_r8,3.2915e-01_r8,2.9613e-01_r8, &
     &2.5854e-01_r8,2.1154e-01_r8,1.7388e-01_r8/)
      kao(:, 2, 8,11) = (/ &
     &4.6803e-01_r8,4.1204e-01_r8,3.7966e-01_r8,3.5758e-01_r8,3.2785e-01_r8,2.9605e-01_r8, &
     &2.5875e-01_r8,2.1026e-01_r8,1.7332e-01_r8/)
      kao(:, 3, 8,11) = (/ &
     &4.7076e-01_r8,4.1406e-01_r8,3.7922e-01_r8,3.5601e-01_r8,3.2603e-01_r8,2.9561e-01_r8, &
     &2.5861e-01_r8,2.0864e-01_r8,1.7242e-01_r8/)
      kao(:, 4, 8,11) = (/ &
     &4.7155e-01_r8,4.1450e-01_r8,3.7727e-01_r8,3.5413e-01_r8,3.2392e-01_r8,2.9447e-01_r8, &
     &2.5827e-01_r8,2.0694e-01_r8,1.7120e-01_r8/)
      kao(:, 5, 8,11) = (/ &
     &4.7233e-01_r8,4.1516e-01_r8,3.7581e-01_r8,3.5208e-01_r8,3.2176e-01_r8,2.9332e-01_r8, &
     &2.5728e-01_r8,2.0514e-01_r8,1.7042e-01_r8/)
      kao(:, 1, 9,11) = (/ &
     &1.8678e+00_r8,1.6362e+00_r8,1.4048e+00_r8,1.1793e+00_r8,9.9438e-01_r8,8.2136e-01_r8, &
     &6.2834e-01_r8,4.2034e-01_r8,1.6334e-01_r8/)
      kao(:, 2, 9,11) = (/ &
     &1.8906e+00_r8,1.6563e+00_r8,1.4224e+00_r8,1.1919e+00_r8,9.9937e-01_r8,8.2259e-01_r8, &
     &6.2713e-01_r8,4.2292e-01_r8,1.6311e-01_r8/)
      kao(:, 3, 9,11) = (/ &
     &1.9044e+00_r8,1.6682e+00_r8,1.4321e+00_r8,1.1983e+00_r8,1.0002e+00_r8,8.2124e-01_r8, &
     &6.2419e-01_r8,4.2359e-01_r8,1.6249e-01_r8/)
      kao(:, 4, 9,11) = (/ &
     &1.9121e+00_r8,1.6748e+00_r8,1.4376e+00_r8,1.2016e+00_r8,9.9779e-01_r8,8.1901e-01_r8, &
     &6.2159e-01_r8,4.2327e-01_r8,1.6166e-01_r8/)
      kao(:, 5, 9,11) = (/ &
     &1.9224e+00_r8,1.6839e+00_r8,1.4454e+00_r8,1.2078e+00_r8,9.9866e-01_r8,8.1827e-01_r8, &
     &6.1893e-01_r8,4.2245e-01_r8,1.6163e-01_r8/)
      kao(:, 1,10,11) = (/ &
     &8.3490e+00_r8,7.3068e+00_r8,6.2652e+00_r8,5.2233e+00_r8,4.1816e+00_r8,3.1407e+00_r8, &
     &2.1527e+00_r8,1.2369e+00_r8,1.2697e-01_r8/)
      kao(:, 2,10,11) = (/ &
     &8.4604e+00_r8,7.4045e+00_r8,6.3492e+00_r8,5.2936e+00_r8,4.2378e+00_r8,3.1825e+00_r8, &
     &2.1701e+00_r8,1.2392e+00_r8,1.2746e-01_r8/)
      kao(:, 3,10,11) = (/ &
     &8.5299e+00_r8,7.4655e+00_r8,6.4008e+00_r8,5.3364e+00_r8,4.2721e+00_r8,3.2084e+00_r8, &
     &2.1800e+00_r8,1.2385e+00_r8,1.2876e-01_r8/)
      kao(:, 4,10,11) = (/ &
     &8.6037e+00_r8,7.5302e+00_r8,6.4564e+00_r8,5.3827e+00_r8,4.3093e+00_r8,3.2362e+00_r8, &
     &2.1902e+00_r8,1.2373e+00_r8,1.3016e-01_r8/)
      kao(:, 5,10,11) = (/ &
     &8.6811e+00_r8,7.5976e+00_r8,6.5142e+00_r8,5.4315e+00_r8,4.3481e+00_r8,3.2657e+00_r8, &
     &2.2039e+00_r8,1.2408e+00_r8,1.3327e-01_r8/)
      kao(:, 1,11,11) = (/ &
     &1.2908e+01_r8,1.1296e+01_r8,9.6842e+00_r8,8.0726e+00_r8,6.4609e+00_r8,4.8491e+00_r8, &
     &3.2606e+00_r8,1.7969e+00_r8,1.0870e-01_r8/)
      kao(:, 2,11,11) = (/ &
     &1.3081e+01_r8,1.1447e+01_r8,9.8136e+00_r8,8.1796e+00_r8,6.5463e+00_r8,4.9136e+00_r8, &
     &3.2978e+00_r8,1.8090e+00_r8,1.0807e-01_r8/)
      kao(:, 3,11,11) = (/ &
     &1.3247e+01_r8,1.1593e+01_r8,9.9386e+00_r8,8.2843e+00_r8,6.6304e+00_r8,4.9764e+00_r8, &
     &3.3344e+00_r8,1.8186e+00_r8,1.0723e-01_r8/)
      kao(:, 4,11,11) = (/ &
     &1.3412e+01_r8,1.1737e+01_r8,1.0062e+01_r8,8.3876e+00_r8,6.7133e+00_r8,5.0389e+00_r8, &
     &3.3728e+00_r8,1.8302e+00_r8,1.0582e-01_r8/)
      kao(:, 5,11,11) = (/ &
     &1.3565e+01_r8,1.1871e+01_r8,1.0177e+01_r8,8.4837e+00_r8,6.7902e+00_r8,5.0972e+00_r8, &
     &3.4088e+00_r8,1.8416e+00_r8,1.0800e-01_r8/)
      kao(:, 1,12,11) = (/ &
     &1.4642e+01_r8,1.2812e+01_r8,1.0983e+01_r8,9.1554e+00_r8,7.3265e+00_r8,5.4974e+00_r8, &
     &3.7020e+00_r8,2.0284e+00_r8,8.2662e-02_r8/)
      kao(:, 2,12,11) = (/ &
     &1.4885e+01_r8,1.3026e+01_r8,1.1167e+01_r8,9.3078e+00_r8,7.4487e+00_r8,5.5898e+00_r8, &
     &3.7559e+00_r8,2.0497e+00_r8,8.1390e-02_r8/)
      kao(:, 3,12,11) = (/ &
     &1.5119e+01_r8,1.3231e+01_r8,1.1343e+01_r8,9.4543e+00_r8,7.5661e+00_r8,5.6785e+00_r8, &
     &3.8088e+00_r8,2.0698e+00_r8,8.0357e-02_r8/)
      kao(:, 4,12,11) = (/ &
     &1.5358e+01_r8,1.3440e+01_r8,1.1522e+01_r8,9.6047e+00_r8,7.6867e+00_r8,5.7694e+00_r8, &
     &3.8642e+00_r8,2.0905e+00_r8,7.9812e-02_r8/)
      kao(:, 5,12,11) = (/ &
     &1.5578e+01_r8,1.3633e+01_r8,1.1688e+01_r8,9.7428e+00_r8,7.7978e+00_r8,5.8532e+00_r8, &
     &3.9171e+00_r8,2.1122e+00_r8,8.2952e-02_r8/)
      kao(:, 1,13,11) = (/ &
     &1.3181e+01_r8,1.1536e+01_r8,9.8891e+00_r8,8.2428e+00_r8,6.5963e+00_r8,4.9547e+00_r8, &
     &3.3878e+00_r8,1.8779e+00_r8,8.5930e-02_r8/)
      kao(:, 2,13,11) = (/ &
     &1.3431e+01_r8,1.1753e+01_r8,1.0076e+01_r8,8.3993e+00_r8,6.7218e+00_r8,5.0463e+00_r8, &
     &3.4400e+00_r8,1.9003e+00_r8,8.2789e-02_r8/)
      kao(:, 3,13,11) = (/ &
     &1.3694e+01_r8,1.1985e+01_r8,1.0274e+01_r8,8.5642e+00_r8,6.8544e+00_r8,5.1452e+00_r8, &
     &3.4940e+00_r8,1.9250e+00_r8,8.1321e-02_r8/)
      kao(:, 4,13,11) = (/ &
     &1.3957e+01_r8,1.2214e+01_r8,1.0471e+01_r8,8.7279e+00_r8,6.9861e+00_r8,5.2450e+00_r8, &
     &3.5504e+00_r8,1.9524e+00_r8,7.8953e-02_r8/)
      kao(:, 5,13,11) = (/ &
     &1.4201e+01_r8,1.2428e+01_r8,1.0655e+01_r8,8.8819e+00_r8,7.1097e+00_r8,5.3381e+00_r8, &
     &3.6055e+00_r8,1.9785e+00_r8,8.1036e-02_r8/)
      kao(:, 1, 1,12) = (/ &
     &6.5787e-03_r8,2.6236e-02_r8,5.1362e-02_r8,7.6305e-02_r8,1.0073e-01_r8,1.2420e-01_r8, &
     &1.4556e-01_r8,1.6001e-01_r8,2.0088e-01_r8/)
      kao(:, 2, 1,12) = (/ &
     &6.5355e-03_r8,2.5963e-02_r8,5.1031e-02_r8,7.5853e-02_r8,1.0014e-01_r8,1.2346e-01_r8, &
     &1.4463e-01_r8,1.5894e-01_r8,1.9973e-01_r8/)
      kao(:, 3, 1,12) = (/ &
     &6.4519e-03_r8,2.5842e-02_r8,5.0885e-02_r8,7.5629e-02_r8,9.9804e-02_r8,1.2294e-01_r8, &
     &1.4394e-01_r8,1.5802e-01_r8,1.9913e-01_r8/)
      kao(:, 4, 1,12) = (/ &
     &6.3508e-03_r8,2.5827e-02_r8,5.0889e-02_r8,7.5643e-02_r8,9.9816e-02_r8,1.2289e-01_r8, &
     &1.4367e-01_r8,1.5727e-01_r8,1.9918e-01_r8/)
      kao(:, 5, 1,12) = (/ &
     &6.2468e-03_r8,2.5824e-02_r8,5.0882e-02_r8,7.5643e-02_r8,9.9840e-02_r8,1.2300e-01_r8, &
     &1.4386e-01_r8,1.5674e-01_r8,1.9923e-01_r8/)
      kao(:, 1, 2,12) = (/ &
     &1.0416e-02_r8,2.8932e-02_r8,5.5152e-02_r8,8.2023e-02_r8,1.0846e-01_r8,1.3404e-01_r8, &
     &1.5780e-01_r8,1.7629e-01_r8,2.1619e-01_r8/)
      kao(:, 2, 2,12) = (/ &
     &1.0342e-02_r8,2.8637e-02_r8,5.4892e-02_r8,8.1654e-02_r8,1.0796e-01_r8,1.3340e-01_r8, &
     &1.5695e-01_r8,1.7507e-01_r8,2.1532e-01_r8/)
      kao(:, 3, 2,12) = (/ &
     &1.0224e-02_r8,2.8457e-02_r8,5.4759e-02_r8,8.1469e-02_r8,1.0772e-01_r8,1.3310e-01_r8, &
     &1.5656e-01_r8,1.7435e-01_r8,2.1487e-01_r8/)
      kao(:, 4, 2,12) = (/ &
     &1.0091e-02_r8,2.8318e-02_r8,5.4670e-02_r8,8.1344e-02_r8,1.0759e-01_r8,1.3299e-01_r8, &
     &1.5649e-01_r8,1.7414e-01_r8,2.1459e-01_r8/)
      kao(:, 5, 2,12) = (/ &
     &9.9570e-03_r8,2.8146e-02_r8,5.4539e-02_r8,8.1138e-02_r8,1.0736e-01_r8,1.3278e-01_r8, &
     &1.5638e-01_r8,1.7422e-01_r8,2.1411e-01_r8/)
      kao(:, 1, 3,12) = (/ &
     &2.2302e-02_r8,3.7417e-02_r8,6.1097e-02_r8,8.8747e-02_r8,1.1756e-01_r8,1.4593e-01_r8, &
     &1.7314e-01_r8,1.9636e-01_r8,2.3403e-01_r8/)
      kao(:, 2, 3,12) = (/ &
     &2.2117e-02_r8,3.6950e-02_r8,6.0557e-02_r8,8.8385e-02_r8,1.1711e-01_r8,1.4537e-01_r8, &
     &1.7254e-01_r8,1.9566e-01_r8,2.3319e-01_r8/)
      kao(:, 3, 3,12) = (/ &
     &2.1903e-02_r8,3.6596e-02_r8,6.0142e-02_r8,8.8214e-02_r8,1.1684e-01_r8,1.4504e-01_r8, &
     &1.7207e-01_r8,1.9507e-01_r8,2.3270e-01_r8/)
      kao(:, 4, 3,12) = (/ &
     &2.1706e-02_r8,3.6379e-02_r8,5.9779e-02_r8,8.7937e-02_r8,1.1644e-01_r8,1.4454e-01_r8, &
     &1.7162e-01_r8,1.9475e-01_r8,2.3180e-01_r8/)
      kao(:, 5, 3,12) = (/ &
     &2.1485e-02_r8,3.6152e-02_r8,5.9419e-02_r8,8.7609e-02_r8,1.1597e-01_r8,1.4392e-01_r8, &
     &1.7083e-01_r8,1.9407e-01_r8,2.3079e-01_r8/)
      kao(:, 1, 4,12) = (/ &
     &4.8787e-02_r8,6.0363e-02_r8,7.6958e-02_r8,9.9608e-02_r8,1.2651e-01_r8,1.5698e-01_r8, &
     &1.8722e-01_r8,2.1554e-01_r8,2.5046e-01_r8/)
      kao(:, 2, 4,12) = (/ &
     &4.8476e-02_r8,5.9621e-02_r8,7.6177e-02_r8,9.8903e-02_r8,1.2601e-01_r8,1.5644e-01_r8, &
     &1.8652e-01_r8,2.1472e-01_r8,2.4963e-01_r8/)
      kao(:, 3, 4,12) = (/ &
     &4.8022e-02_r8,5.9054e-02_r8,7.5570e-02_r8,9.8295e-02_r8,1.2578e-01_r8,1.5620e-01_r8, &
     &1.8618e-01_r8,2.1420e-01_r8,2.4913e-01_r8/)
      kao(:, 4, 4,12) = (/ &
     &4.7565e-02_r8,5.8399e-02_r8,7.5073e-02_r8,9.7780e-02_r8,1.2559e-01_r8,1.5591e-01_r8, &
     &1.8579e-01_r8,2.1367e-01_r8,2.4858e-01_r8/)
      kao(:, 5, 4,12) = (/ &
     &4.7078e-02_r8,5.7702e-02_r8,7.4506e-02_r8,9.7303e-02_r8,1.2546e-01_r8,1.5568e-01_r8, &
     &1.8546e-01_r8,2.1318e-01_r8,2.4815e-01_r8/)
      kao(:, 1, 5,12) = (/ &
     &9.7499e-02_r8,9.8718e-02_r8,1.1395e-01_r8,1.2710e-01_r8,1.4448e-01_r8,1.6872e-01_r8, &
     &1.9875e-01_r8,2.3006e-01_r8,2.6441e-01_r8/)
      kao(:, 2, 5,12) = (/ &
     &9.6942e-02_r8,9.7852e-02_r8,1.1233e-01_r8,1.2606e-01_r8,1.4347e-01_r8,1.6785e-01_r8, &
     &1.9829e-01_r8,2.2956e-01_r8,2.6367e-01_r8/)
      kao(:, 3, 5,12) = (/ &
     &9.6111e-02_r8,9.7066e-02_r8,1.1087e-01_r8,1.2520e-01_r8,1.4264e-01_r8,1.6720e-01_r8, &
     &1.9804e-01_r8,2.2914e-01_r8,2.6333e-01_r8/)
      kao(:, 4, 5,12) = (/ &
     &9.5331e-02_r8,9.6285e-02_r8,1.0984e-01_r8,1.2440e-01_r8,1.4205e-01_r8,1.6680e-01_r8, &
     &1.9797e-01_r8,2.2895e-01_r8,2.6319e-01_r8/)
      kao(:, 5, 5,12) = (/ &
     &9.4443e-02_r8,9.5498e-02_r8,1.0898e-01_r8,1.2351e-01_r8,1.4175e-01_r8,1.6646e-01_r8, &
     &1.9775e-01_r8,2.2870e-01_r8,2.6275e-01_r8/)
      kao(:, 1, 6,12) = (/ &
     &1.8140e-01_r8,1.6408e-01_r8,1.7552e-01_r8,1.8196e-01_r8,1.8674e-01_r8,1.9489e-01_r8, &
     &2.1183e-01_r8,2.4078e-01_r8,2.7512e-01_r8/)
      kao(:, 2, 6,12) = (/ &
     &1.8064e-01_r8,1.6323e-01_r8,1.7439e-01_r8,1.7956e-01_r8,1.8547e-01_r8,1.9334e-01_r8, &
     &2.1068e-01_r8,2.4042e-01_r8,2.7473e-01_r8/)
      kao(:, 3, 6,12) = (/ &
     &1.7939e-01_r8,1.6216e-01_r8,1.7344e-01_r8,1.7751e-01_r8,1.8404e-01_r8,1.9207e-01_r8, &
     &2.1020e-01_r8,2.4067e-01_r8,2.7502e-01_r8/)
      kao(:, 4, 6,12) = (/ &
     &1.7796e-01_r8,1.6097e-01_r8,1.7233e-01_r8,1.7595e-01_r8,1.8277e-01_r8,1.9147e-01_r8, &
     &2.0971e-01_r8,2.4067e-01_r8,2.7492e-01_r8/)
      kao(:, 5, 6,12) = (/ &
     &1.7632e-01_r8,1.5943e-01_r8,1.7056e-01_r8,1.7456e-01_r8,1.8167e-01_r8,1.9081e-01_r8, &
     &2.0890e-01_r8,2.4019e-01_r8,2.7421e-01_r8/)
      kao(:, 1, 7,12) = (/ &
     &3.5379e-01_r8,3.1064e-01_r8,2.9565e-01_r8,2.8816e-01_r8,2.7694e-01_r8,2.6472e-01_r8, &
     &2.4939e-01_r8,2.5136e-01_r8,2.8304e-01_r8/)
      kao(:, 2, 7,12) = (/ &
     &3.5306e-01_r8,3.1059e-01_r8,2.9503e-01_r8,2.8682e-01_r8,2.7447e-01_r8,2.6248e-01_r8, &
     &2.4787e-01_r8,2.5077e-01_r8,2.8333e-01_r8/)
      kao(:, 3, 7,12) = (/ &
     &3.5170e-01_r8,3.1024e-01_r8,2.9413e-01_r8,2.8605e-01_r8,2.7226e-01_r8,2.6030e-01_r8, &
     &2.4686e-01_r8,2.5055e-01_r8,2.8358e-01_r8/)
      kao(:, 4, 7,12) = (/ &
     &3.4988e-01_r8,3.0935e-01_r8,2.9228e-01_r8,2.8440e-01_r8,2.7034e-01_r8,2.5822e-01_r8, &
     &2.4645e-01_r8,2.4996e-01_r8,2.8315e-01_r8/)
      kao(:, 5, 7,12) = (/ &
     &3.4759e-01_r8,3.0773e-01_r8,2.8986e-01_r8,2.8199e-01_r8,2.6823e-01_r8,2.5660e-01_r8, &
     &2.4547e-01_r8,2.4917e-01_r8,2.8239e-01_r8/)
      kao(:, 1, 8,12) = (/ &
     &8.0496e-01_r8,7.0527e-01_r8,6.0910e-01_r8,5.5199e-01_r8,5.0022e-01_r8,4.3776e-01_r8, &
     &3.7465e-01_r8,3.0063e-01_r8,2.8877e-01_r8/)
      kao(:, 2, 8,12) = (/ &
     &8.0672e-01_r8,7.0707e-01_r8,6.1070e-01_r8,5.5311e-01_r8,5.0061e-01_r8,4.3582e-01_r8, &
     &3.7176e-01_r8,2.9952e-01_r8,2.8902e-01_r8/)
      kao(:, 3, 8,12) = (/ &
     &8.0691e-01_r8,7.0823e-01_r8,6.1191e-01_r8,5.5364e-01_r8,5.0004e-01_r8,4.3422e-01_r8, &
     &3.6951e-01_r8,2.9892e-01_r8,2.8876e-01_r8/)
      kao(:, 4, 8,12) = (/ &
     &8.0527e-01_r8,7.0753e-01_r8,6.1153e-01_r8,5.5173e-01_r8,4.9853e-01_r8,4.3157e-01_r8, &
     &3.6699e-01_r8,2.9815e-01_r8,2.8834e-01_r8/)
      kao(:, 5, 8,12) = (/ &
     &8.0219e-01_r8,7.0523e-01_r8,6.0964e-01_r8,5.4776e-01_r8,4.9536e-01_r8,4.2816e-01_r8, &
     &3.6486e-01_r8,2.9693e-01_r8,2.8675e-01_r8/)
      kao(:, 1, 9,12) = (/ &
     &3.4182e+00_r8,2.9916e+00_r8,2.5652e+00_r8,2.1389e+00_r8,1.7153e+00_r8,1.3419e+00_r8, &
     &1.0101e+00_r8,6.4726e-01_r8,2.8926e-01_r8/)
      kao(:, 2, 9,12) = (/ &
     &3.4411e+00_r8,3.0119e+00_r8,2.5830e+00_r8,2.1544e+00_r8,1.7278e+00_r8,1.3490e+00_r8, &
     &1.0168e+00_r8,6.4570e-01_r8,2.8901e-01_r8/)
      kao(:, 3, 9,12) = (/ &
     &3.4584e+00_r8,3.0278e+00_r8,2.5976e+00_r8,2.1679e+00_r8,1.7392e+00_r8,1.3535e+00_r8, &
     &1.0208e+00_r8,6.4462e-01_r8,2.8863e-01_r8/)
      kao(:, 4, 9,12) = (/ &
     &3.4643e+00_r8,3.0337e+00_r8,2.6033e+00_r8,2.1735e+00_r8,1.7445e+00_r8,1.3538e+00_r8, &
     &1.0204e+00_r8,6.4174e-01_r8,2.8774e-01_r8/)
      kao(:, 5, 9,12) = (/ &
     &3.4625e+00_r8,3.0324e+00_r8,2.6029e+00_r8,2.1736e+00_r8,1.7453e+00_r8,1.3500e+00_r8, &
     &1.0152e+00_r8,6.3782e-01_r8,2.8595e-01_r8/)
      kao(:, 1,10,12) = (/ &
     &1.6048e+01_r8,1.4043e+01_r8,1.2038e+01_r8,1.0032e+01_r8,8.0269e+00_r8,6.0216e+00_r8, &
     &4.0164e+00_r8,2.1217e+00_r8,2.8227e-01_r8/)
      kao(:, 2,10,12) = (/ &
     &1.6256e+01_r8,1.4226e+01_r8,1.2195e+01_r8,1.0164e+01_r8,8.1333e+00_r8,6.1029e+00_r8, &
     &4.0729e+00_r8,2.1442e+00_r8,2.8170e-01_r8/)
      kao(:, 3,10,12) = (/ &
     &1.6399e+01_r8,1.4351e+01_r8,1.2303e+01_r8,1.0255e+01_r8,8.2073e+00_r8,6.1596e+00_r8, &
     &4.1123e+00_r8,2.1594e+00_r8,2.8134e-01_r8/)
      kao(:, 4,10,12) = (/ &
     &1.6465e+01_r8,1.4409e+01_r8,1.2353e+01_r8,1.0297e+01_r8,8.2414e+00_r8,6.1861e+00_r8, &
     &4.1319e+00_r8,2.1644e+00_r8,2.8049e-01_r8/)
      kao(:, 5,10,12) = (/ &
     &1.6472e+01_r8,1.4416e+01_r8,1.2359e+01_r8,1.0303e+01_r8,8.2464e+00_r8,6.1909e+00_r8, &
     &4.1366e+00_r8,2.1582e+00_r8,2.7905e-01_r8/)
      kao(:, 1,11,12) = (/ &
     &2.6190e+01_r8,2.2917e+01_r8,1.9644e+01_r8,1.6372e+01_r8,1.3098e+01_r8,9.8258e+00_r8, &
     &6.5533e+00_r8,3.3347e+00_r8,2.0130e-01_r8/)
      kao(:, 2,11,12) = (/ &
     &2.6572e+01_r8,2.3252e+01_r8,1.9932e+01_r8,1.6612e+01_r8,1.3292e+01_r8,9.9715e+00_r8, &
     &6.6522e+00_r8,3.3768e+00_r8,2.0375e-01_r8/)
      kao(:, 3,11,12) = (/ &
     &2.6794e+01_r8,2.3447e+01_r8,2.0099e+01_r8,1.6751e+01_r8,1.3404e+01_r8,1.0057e+01_r8, &
     &6.7102e+00_r8,3.4019e+00_r8,2.0648e-01_r8/)
      kao(:, 4,11,12) = (/ &
     &2.6905e+01_r8,2.3544e+01_r8,2.0183e+01_r8,1.6822e+01_r8,1.3461e+01_r8,1.0100e+01_r8, &
     &6.7401e+00_r8,3.4102e+00_r8,2.0903e-01_r8/)
      kao(:, 5,11,12) = (/ &
     &2.6968e+01_r8,2.3599e+01_r8,2.0230e+01_r8,1.6860e+01_r8,1.3492e+01_r8,1.0123e+01_r8, &
     &6.7556e+00_r8,3.4122e+00_r8,2.1045e-01_r8/)
      kao(:, 1,12,12) = (/ &
     &3.1310e+01_r8,2.7398e+01_r8,2.3484e+01_r8,1.9572e+01_r8,1.5659e+01_r8,1.1747e+01_r8, &
     &7.8342e+00_r8,3.9879e+00_r8,1.6283e-01_r8/)
      kao(:, 2,12,12) = (/ &
     &3.1751e+01_r8,2.7784e+01_r8,2.3816e+01_r8,1.9849e+01_r8,1.5882e+01_r8,1.1914e+01_r8, &
     &7.9470e+00_r8,4.0341e+00_r8,1.6415e-01_r8/)
      kao(:, 3,12,12) = (/ &
     &3.2043e+01_r8,2.8038e+01_r8,2.4036e+01_r8,2.0032e+01_r8,1.6028e+01_r8,1.2025e+01_r8, &
     &8.0217e+00_r8,4.0620e+00_r8,1.6794e-01_r8/)
      kao(:, 4,12,12) = (/ &
     &3.2220e+01_r8,2.8195e+01_r8,2.4168e+01_r8,2.0143e+01_r8,1.6116e+01_r8,1.2091e+01_r8, &
     &8.0659e+00_r8,4.0753e+00_r8,1.6850e-01_r8/)
      kao(:, 5,12,12) = (/ &
     &3.2373e+01_r8,2.8329e+01_r8,2.4283e+01_r8,2.0239e+01_r8,1.6193e+01_r8,1.2149e+01_r8, &
     &8.1043e+00_r8,4.0871e+00_r8,1.6988e-01_r8/)
      kao(:, 1,13,12) = (/ &
     &2.9544e+01_r8,2.5852e+01_r8,2.2161e+01_r8,1.8469e+01_r8,1.4777e+01_r8,1.1085e+01_r8, &
     &7.3931e+00_r8,3.8439e+00_r8,1.2880e-01_r8/)
      kao(:, 2,13,12) = (/ &
     &2.9974e+01_r8,2.6228e+01_r8,2.2483e+01_r8,1.8737e+01_r8,1.4992e+01_r8,1.1247e+01_r8, &
     &7.5021e+00_r8,3.8830e+00_r8,1.3338e-01_r8/)
      kao(:, 3,13,12) = (/ &
     &3.0254e+01_r8,2.6474e+01_r8,2.2694e+01_r8,1.8912e+01_r8,1.5132e+01_r8,1.1352e+01_r8, &
     &7.5719e+00_r8,3.9004e+00_r8,1.3721e-01_r8/)
      kao(:, 4,13,12) = (/ &
     &3.0504e+01_r8,2.6693e+01_r8,2.2881e+01_r8,1.9069e+01_r8,1.5258e+01_r8,1.1446e+01_r8, &
     &7.6348e+00_r8,3.9163e+00_r8,1.3871e-01_r8/)
      kao(:, 5,13,12) = (/ &
     &3.0781e+01_r8,2.6934e+01_r8,2.3088e+01_r8,1.9241e+01_r8,1.5395e+01_r8,1.1550e+01_r8, &
     &7.7042e+00_r8,3.9392e+00_r8,1.4036e-01_r8/)
      kao(:, 1, 1,13) = (/ &
     &9.0088e-03_r8,3.7171e-02_r8,7.3185e-02_r8,1.0841e-01_r8,1.4222e-01_r8,1.7328e-01_r8, &
     &1.9823e-01_r8,2.0424e-01_r8,2.8396e-01_r8/)
      kao(:, 2, 1,13) = (/ &
     &8.8070e-03_r8,3.7017e-02_r8,7.2761e-02_r8,1.0769e-01_r8,1.4122e-01_r8,1.7208e-01_r8, &
     &1.9703e-01_r8,2.0324e-01_r8,2.8185e-01_r8/)
      kao(:, 3, 1,13) = (/ &
     &8.6641e-03_r8,3.6729e-02_r8,7.2126e-02_r8,1.0675e-01_r8,1.4002e-01_r8,1.7072e-01_r8, &
     &1.9555e-01_r8,2.0207e-01_r8,2.7936e-01_r8/)
      kao(:, 4, 1,13) = (/ &
     &8.5351e-03_r8,3.6304e-02_r8,7.1373e-02_r8,1.0562e-01_r8,1.3853e-01_r8,1.6891e-01_r8, &
     &1.9361e-01_r8,2.0011e-01_r8,2.7631e-01_r8/)
      kao(:, 5, 1,13) = (/ &
     &8.4180e-03_r8,3.5892e-02_r8,7.0613e-02_r8,1.0456e-01_r8,1.3716e-01_r8,1.6725e-01_r8, &
     &1.9159e-01_r8,1.9822e-01_r8,2.7366e-01_r8/)
      kao(:, 1, 2,13) = (/ &
     &1.4629e-02_r8,4.1401e-02_r8,8.1344e-02_r8,1.2092e-01_r8,1.5970e-01_r8,1.9686e-01_r8, &
     &2.3007e-01_r8,2.4893e-01_r8,3.1872e-01_r8/)
      kao(:, 2, 2,13) = (/ &
     &1.4347e-02_r8,4.1149e-02_r8,8.0754e-02_r8,1.2000e-01_r8,1.5844e-01_r8,1.9525e-01_r8, &
     &2.2811e-01_r8,2.4701e-01_r8,3.1592e-01_r8/)
      kao(:, 3, 2,13) = (/ &
     &1.4116e-02_r8,4.0731e-02_r8,7.9979e-02_r8,1.1881e-01_r8,1.5685e-01_r8,1.9333e-01_r8, &
     &2.2600e-01_r8,2.4518e-01_r8,3.1267e-01_r8/)
      kao(:, 4, 2,13) = (/ &
     &1.3916e-02_r8,4.0235e-02_r8,7.9131e-02_r8,1.1757e-01_r8,1.5518e-01_r8,1.9122e-01_r8, &
     &2.2354e-01_r8,2.4260e-01_r8,3.0926e-01_r8/)
      kao(:, 5, 2,13) = (/ &
     &1.3712e-02_r8,3.9826e-02_r8,7.8358e-02_r8,1.1644e-01_r8,1.5370e-01_r8,1.8938e-01_r8, &
     &2.2131e-01_r8,2.4017e-01_r8,3.0647e-01_r8/)
      kao(:, 1, 3,13) = (/ &
     &3.2046e-02_r8,5.1387e-02_r8,8.9167e-02_r8,1.3251e-01_r8,1.7557e-01_r8,2.1798e-01_r8, &
     &2.5867e-01_r8,2.9276e-01_r8,3.4967e-01_r8/)
      kao(:, 2, 3,13) = (/ &
     &3.1484e-02_r8,5.0885e-02_r8,8.8511e-02_r8,1.3146e-01_r8,1.7409e-01_r8,2.1604e-01_r8, &
     &2.5621e-01_r8,2.8967e-01_r8,3.4641e-01_r8/)
      kao(:, 3, 3,13) = (/ &
     &3.1011e-02_r8,5.0194e-02_r8,8.7651e-02_r8,1.3011e-01_r8,1.7226e-01_r8,2.1375e-01_r8, &
     &2.5357e-01_r8,2.8697e-01_r8,3.4255e-01_r8/)
      kao(:, 4, 3,13) = (/ &
     &3.0595e-02_r8,4.9306e-02_r8,8.6747e-02_r8,1.2888e-01_r8,1.7065e-01_r8,2.1172e-01_r8, &
     &2.5094e-01_r8,2.8374e-01_r8,3.3932e-01_r8/)
      kao(:, 5, 3,13) = (/ &
     &3.0114e-02_r8,4.8480e-02_r8,8.6058e-02_r8,1.2788e-01_r8,1.6935e-01_r8,2.1010e-01_r8, &
     &2.4901e-01_r8,2.8126e-01_r8,3.3697e-01_r8/)
      kao(:, 1, 4,13) = (/ &
     &7.1437e-02_r8,7.9531e-02_r8,1.0765e-01_r8,1.4496e-01_r8,1.9060e-01_r8,2.3699e-01_r8, &
     &2.8255e-01_r8,3.2483e-01_r8,3.7856e-01_r8/)
      kao(:, 2, 4,13) = (/ &
     &7.0222e-02_r8,7.8795e-02_r8,1.0643e-01_r8,1.4338e-01_r8,1.8881e-01_r8,2.3460e-01_r8, &
     &2.7960e-01_r8,3.2131e-01_r8,3.7439e-01_r8/)
      kao(:, 3, 4,13) = (/ &
     &6.9262e-02_r8,7.7852e-02_r8,1.0486e-01_r8,1.4165e-01_r8,1.8684e-01_r8,2.3207e-01_r8, &
     &2.7650e-01_r8,3.1773e-01_r8,3.7008e-01_r8/)
      kao(:, 4, 4,13) = (/ &
     &6.8383e-02_r8,7.7009e-02_r8,1.0310e-01_r8,1.4004e-01_r8,1.8506e-01_r8,2.2994e-01_r8, &
     &2.7397e-01_r8,3.1473e-01_r8,3.6682e-01_r8/)
      kao(:, 5, 4,13) = (/ &
     &6.7482e-02_r8,7.6264e-02_r8,1.0166e-01_r8,1.3889e-01_r8,1.8370e-01_r8,2.2828e-01_r8, &
     &2.7201e-01_r8,3.1244e-01_r8,3.6430e-01_r8/)
      kao(:, 1, 5,13) = (/ &
     &1.4624e-01_r8,1.3361e-01_r8,1.5693e-01_r8,1.7752e-01_r8,2.1095e-01_r8,2.5537e-01_r8, &
     &3.0486e-01_r8,3.5270e-01_r8,4.0651e-01_r8/)
      kao(:, 2, 5,13) = (/ &
     &1.4398e-01_r8,1.3165e-01_r8,1.5512e-01_r8,1.7519e-01_r8,2.0814e-01_r8,2.5302e-01_r8, &
     &3.0184e-01_r8,3.4895e-01_r8,4.0217e-01_r8/)
      kao(:, 3, 5,13) = (/ &
     &1.4207e-01_r8,1.3000e-01_r8,1.5346e-01_r8,1.7248e-01_r8,2.0524e-01_r8,2.5056e-01_r8, &
     &2.9880e-01_r8,3.4528e-01_r8,3.9789e-01_r8/)
      kao(:, 4, 5,13) = (/ &
     &1.4038e-01_r8,1.2884e-01_r8,1.5157e-01_r8,1.6985e-01_r8,2.0246e-01_r8,2.4823e-01_r8, &
     &2.9613e-01_r8,3.4225e-01_r8,3.9462e-01_r8/)
      kao(:, 5, 5,13) = (/ &
     &1.3874e-01_r8,1.2784e-01_r8,1.4941e-01_r8,1.6780e-01_r8,2.0033e-01_r8,2.4657e-01_r8, &
     &2.9417e-01_r8,3.3986e-01_r8,3.9218e-01_r8/)
      kao(:, 1, 6,13) = (/ &
     &2.8046e-01_r8,2.4640e-01_r8,2.4558e-01_r8,2.5477e-01_r8,2.6318e-01_r8,2.8661e-01_r8, &
     &3.2769e-01_r8,3.7985e-01_r8,4.3568e-01_r8/)
      kao(:, 2, 6,13) = (/ &
     &2.7643e-01_r8,2.4318e-01_r8,2.4273e-01_r8,2.5156e-01_r8,2.5913e-01_r8,2.8275e-01_r8, &
     &3.2478e-01_r8,3.7621e-01_r8,4.3126e-01_r8/)
      kao(:, 3, 6,13) = (/ &
     &2.7290e-01_r8,2.4050e-01_r8,2.4016e-01_r8,2.4894e-01_r8,2.5526e-01_r8,2.7880e-01_r8, &
     &3.2177e-01_r8,3.7266e-01_r8,4.2706e-01_r8/)
      kao(:, 4, 6,13) = (/ &
     &2.7013e-01_r8,2.3869e-01_r8,2.3760e-01_r8,2.4573e-01_r8,2.5166e-01_r8,2.7510e-01_r8, &
     &3.1929e-01_r8,3.6982e-01_r8,4.2412e-01_r8/)
      kao(:, 5, 6,13) = (/ &
     &2.6724e-01_r8,2.3701e-01_r8,2.3563e-01_r8,2.4210e-01_r8,2.4866e-01_r8,2.7240e-01_r8, &
     &3.1774e-01_r8,3.6799e-01_r8,4.2206e-01_r8/)
      kao(:, 1, 7,13) = (/ &
     &5.6688e-01_r8,4.9674e-01_r8,4.3519e-01_r8,4.2029e-01_r8,3.9894e-01_r8,3.7594e-01_r8, &
     &3.7424e-01_r8,4.0700e-01_r8,4.6486e-01_r8/)
      kao(:, 2, 7,13) = (/ &
     &5.6062e-01_r8,4.9147e-01_r8,4.2917e-01_r8,4.1552e-01_r8,3.9325e-01_r8,3.7043e-01_r8, &
     &3.6935e-01_r8,4.0348e-01_r8,4.6044e-01_r8/)
      kao(:, 3, 7,13) = (/ &
     &5.5419e-01_r8,4.8620e-01_r8,4.2405e-01_r8,4.1052e-01_r8,3.8832e-01_r8,3.6566e-01_r8, &
     &3.6433e-01_r8,4.0051e-01_r8,4.5715e-01_r8/)
      kao(:, 4, 7,13) = (/ &
     &5.4908e-01_r8,4.8208e-01_r8,4.2069e-01_r8,4.0630e-01_r8,3.8346e-01_r8,3.6097e-01_r8, &
     &3.5952e-01_r8,3.9819e-01_r8,4.5457e-01_r8/)
      kao(:, 5, 7,13) = (/ &
     &5.4429e-01_r8,4.7829e-01_r8,4.1793e-01_r8,4.0260e-01_r8,3.7854e-01_r8,3.5674e-01_r8, &
     &3.5560e-01_r8,3.9638e-01_r8,4.5240e-01_r8/)
      kao(:, 1, 8,13) = (/ &
     &1.3466e+00_r8,1.1788e+00_r8,1.0111e+00_r8,8.5366e-01_r8,7.5173e-01_r8,6.5869e-01_r8, &
     &5.4376e-01_r8,4.6329e-01_r8,4.8785e-01_r8/)
      kao(:, 2, 8,13) = (/ &
     &1.3340e+00_r8,1.1680e+00_r8,1.0021e+00_r8,8.4354e-01_r8,7.4161e-01_r8,6.4846e-01_r8, &
     &5.3530e-01_r8,4.5751e-01_r8,4.8487e-01_r8/)
      kao(:, 3, 8,13) = (/ &
     &1.3215e+00_r8,1.1573e+00_r8,9.9337e-01_r8,8.3476e-01_r8,7.3374e-01_r8,6.3918e-01_r8, &
     &5.2901e-01_r8,4.5174e-01_r8,4.8277e-01_r8/)
      kao(:, 4, 8,13) = (/ &
     &1.3130e+00_r8,1.1502e+00_r8,9.8764e-01_r8,8.2958e-01_r8,7.2734e-01_r8,6.3251e-01_r8, &
     &5.2258e-01_r8,4.4677e-01_r8,4.8075e-01_r8/)
      kao(:, 5, 8,13) = (/ &
     &1.3037e+00_r8,1.1423e+00_r8,9.8136e-01_r8,8.2511e-01_r8,7.2245e-01_r8,6.2665e-01_r8, &
     &5.1636e-01_r8,4.4197e-01_r8,4.7928e-01_r8/)
      kao(:, 1, 9,13) = (/ &
     &6.0221e+00_r8,5.2697e+00_r8,4.5174e+00_r8,3.7653e+00_r8,3.0129e+00_r8,2.2622e+00_r8, &
     &1.5952e+00_r8,9.9726e-01_r8,5.0671e-01_r8/)
      kao(:, 2, 9,13) = (/ &
     &5.9755e+00_r8,5.2290e+00_r8,4.4828e+00_r8,3.7364e+00_r8,2.9901e+00_r8,2.2441e+00_r8, &
     &1.5732e+00_r8,9.8172e-01_r8,5.0573e-01_r8/)
      kao(:, 3, 9,13) = (/ &
     &5.9358e+00_r8,5.1947e+00_r8,4.4536e+00_r8,3.7125e+00_r8,2.9715e+00_r8,2.2305e+00_r8, &
     &1.5561e+00_r8,9.6836e-01_r8,5.0514e-01_r8/)
      kao(:, 4, 9,13) = (/ &
     &5.9085e+00_r8,5.1712e+00_r8,4.4336e+00_r8,3.6962e+00_r8,2.9588e+00_r8,2.2217e+00_r8, &
     &1.5446e+00_r8,9.5878e-01_r8,5.0373e-01_r8/)
      kao(:, 5, 9,13) = (/ &
     &5.8741e+00_r8,5.1412e+00_r8,4.4082e+00_r8,3.6753e+00_r8,2.9426e+00_r8,2.2110e+00_r8, &
     &1.5366e+00_r8,9.5070e-01_r8,5.0223e-01_r8/)
      kao(:, 1,10,13) = (/ &
     &2.9983e+01_r8,2.6236e+01_r8,2.2488e+01_r8,1.8741e+01_r8,1.4994e+01_r8,1.1246e+01_r8, &
     &7.4983e+00_r8,3.7584e+00_r8,5.2065e-01_r8/)
      kao(:, 2,10,13) = (/ &
     &2.9796e+01_r8,2.6072e+01_r8,2.2348e+01_r8,1.8624e+01_r8,1.4900e+01_r8,1.1176e+01_r8, &
     &7.4520e+00_r8,3.7308e+00_r8,5.2186e-01_r8/)
      kao(:, 3,10,13) = (/ &
     &2.9702e+01_r8,2.5989e+01_r8,2.2278e+01_r8,1.8566e+01_r8,1.4854e+01_r8,1.1142e+01_r8, &
     &7.4298e+00_r8,3.7183e+00_r8,5.2236e-01_r8/)
      kao(:, 4,10,13) = (/ &
     &2.9648e+01_r8,2.5942e+01_r8,2.2238e+01_r8,1.8533e+01_r8,1.4828e+01_r8,1.1123e+01_r8, &
     &7.4177e+00_r8,3.7128e+00_r8,5.2097e-01_r8/)
      kao(:, 5,10,13) = (/ &
     &2.9599e+01_r8,2.5901e+01_r8,2.2202e+01_r8,1.8502e+01_r8,1.4804e+01_r8,1.1105e+01_r8, &
     &7.4063e+00_r8,3.7092e+00_r8,5.1987e-01_r8/)
      kao(:, 1,11,13) = (/ &
     &5.1290e+01_r8,4.4882e+01_r8,3.8471e+01_r8,3.2058e+01_r8,2.5646e+01_r8,1.9236e+01_r8, &
     &1.2824e+01_r8,6.4141e+00_r8,5.2983e-01_r8/)
      kao(:, 2,11,13) = (/ &
     &5.1244e+01_r8,4.4838e+01_r8,3.8434e+01_r8,3.2028e+01_r8,2.5623e+01_r8,1.9219e+01_r8, &
     &1.2814e+01_r8,6.4089e+00_r8,5.3215e-01_r8/)
      kao(:, 3,11,13) = (/ &
     &5.1318e+01_r8,4.4905e+01_r8,3.8491e+01_r8,3.2076e+01_r8,2.5662e+01_r8,1.9248e+01_r8, &
     &1.2833e+01_r8,6.4196e+00_r8,5.3209e-01_r8/)
      kao(:, 4,11,13) = (/ &
     &5.1488e+01_r8,4.5053e+01_r8,3.8617e+01_r8,3.2182e+01_r8,2.5747e+01_r8,1.9312e+01_r8, &
     &1.2877e+01_r8,6.4422e+00_r8,5.3137e-01_r8/)
      kao(:, 5,11,13) = (/ &
     &5.1544e+01_r8,4.5101e+01_r8,3.8659e+01_r8,3.2218e+01_r8,2.5776e+01_r8,1.9335e+01_r8, &
     &1.2893e+01_r8,6.4519e+00_r8,5.3038e-01_r8/)
      kao(:, 1,12,13) = (/ &
     &6.4625e+01_r8,5.6547e+01_r8,4.8469e+01_r8,4.0391e+01_r8,3.2315e+01_r8,2.4238e+01_r8, &
     &1.6158e+01_r8,8.0814e+00_r8,4.6363e-01_r8/)
      kao(:, 2,12,13) = (/ &
     &6.4981e+01_r8,5.6858e+01_r8,4.8737e+01_r8,4.0614e+01_r8,3.2493e+01_r8,2.4371e+01_r8, &
     &1.6249e+01_r8,8.1265e+00_r8,4.7141e-01_r8/)
      kao(:, 3,12,13) = (/ &
     &6.5489e+01_r8,5.7301e+01_r8,4.9118e+01_r8,4.0933e+01_r8,3.2747e+01_r8,2.4562e+01_r8, &
     &1.6376e+01_r8,8.1908e+00_r8,4.7318e-01_r8/)
      kao(:, 4,12,13) = (/ &
     &6.5927e+01_r8,5.7688e+01_r8,4.9446e+01_r8,4.1208e+01_r8,3.2967e+01_r8,2.4727e+01_r8, &
     &1.6488e+01_r8,8.2475e+00_r8,4.7664e-01_r8/)
      kao(:, 5,12,13) = (/ &
     &6.6087e+01_r8,5.7823e+01_r8,4.9566e+01_r8,4.1306e+01_r8,3.3048e+01_r8,2.4787e+01_r8, &
     &1.6528e+01_r8,8.2690e+00_r8,4.7820e-01_r8/)
      kao(:, 1,13,13) = (/ &
     &6.4615e+01_r8,5.6540e+01_r8,4.8462e+01_r8,4.0385e+01_r8,3.2309e+01_r8,2.4232e+01_r8, &
     &1.6156e+01_r8,8.0805e+00_r8,4.0088e-01_r8/)
      kao(:, 2,13,13) = (/ &
     &6.5417e+01_r8,5.7241e+01_r8,4.9064e+01_r8,4.0887e+01_r8,3.2711e+01_r8,2.4534e+01_r8, &
     &1.6357e+01_r8,8.1804e+00_r8,3.9953e-01_r8/)
      kao(:, 3,13,13) = (/ &
     &6.6282e+01_r8,5.7998e+01_r8,4.9715e+01_r8,4.1430e+01_r8,3.3145e+01_r8,2.4860e+01_r8, &
     &1.6576e+01_r8,8.2909e+00_r8,4.0385e-01_r8/)
      kao(:, 4,13,13) = (/ &
     &6.6847e+01_r8,5.8491e+01_r8,5.0137e+01_r8,4.1781e+01_r8,3.3427e+01_r8,2.5072e+01_r8, &
     &1.6717e+01_r8,8.3627e+00_r8,4.1064e-01_r8/)
      kao(:, 5,13,13) = (/ &
     &6.7163e+01_r8,5.8769e+01_r8,5.0375e+01_r8,4.1983e+01_r8,3.3587e+01_r8,2.5193e+01_r8, &
     &1.6798e+01_r8,8.4033e+00_r8,4.1414e-01_r8/)
      kao(:, 1, 1,14) = (/ &
     &1.2012e-02_r8,4.7001e-02_r8,9.2646e-02_r8,1.3669e-01_r8,1.7808e-01_r8,2.1465e-01_r8, &
     &2.4110e-01_r8,2.4013e-01_r8,3.5593e-01_r8/)
      kao(:, 2, 1,14) = (/ &
     &1.1787e-02_r8,4.6471e-02_r8,9.1548e-02_r8,1.3506e-01_r8,1.7598e-01_r8,2.1215e-01_r8, &
     &2.3833e-01_r8,2.3702e-01_r8,3.5168e-01_r8/)
      kao(:, 3, 1,14) = (/ &
     &1.1552e-02_r8,4.6117e-02_r8,9.0846e-02_r8,1.3398e-01_r8,1.7452e-01_r8,2.1037e-01_r8, &
     &2.3630e-01_r8,2.3518e-01_r8,3.4867e-01_r8/)
      kao(:, 4, 1,14) = (/ &
     &1.1308e-02_r8,4.5919e-02_r8,9.0260e-02_r8,1.3312e-01_r8,1.7345e-01_r8,2.0914e-01_r8, &
     &2.3511e-01_r8,2.3456e-01_r8,3.4647e-01_r8/)
      kao(:, 5, 1,14) = (/ &
     &1.1074e-02_r8,4.5680e-02_r8,8.9686e-02_r8,1.3217e-01_r8,1.7213e-01_r8,2.0750e-01_r8, &
     &2.3330e-01_r8,2.3291e-01_r8,3.4372e-01_r8/)
      kao(:, 1, 2,14) = (/ &
     &1.9894e-02_r8,5.5751e-02_r8,1.1015e-01_r8,1.6336e-01_r8,2.1450e-01_r8,2.6180e-01_r8, &
     &3.0044e-01_r8,3.1221e-01_r8,4.2855e-01_r8/)
      kao(:, 2, 2,14) = (/ &
     &1.9495e-02_r8,5.5076e-02_r8,1.0879e-01_r8,1.6130e-01_r8,2.1180e-01_r8,2.5853e-01_r8, &
     &2.9678e-01_r8,3.0859e-01_r8,4.2309e-01_r8/)
      kao(:, 3, 2,14) = (/ &
     &1.9117e-02_r8,5.4639e-02_r8,1.0781e-01_r8,1.5983e-01_r8,2.0983e-01_r8,2.5605e-01_r8, &
     &2.9379e-01_r8,3.0533e-01_r8,4.1905e-01_r8/)
      kao(:, 4, 2,14) = (/ &
     &1.8729e-02_r8,5.4397e-02_r8,1.0705e-01_r8,1.5861e-01_r8,2.0822e-01_r8,2.5408e-01_r8, &
     &2.9159e-01_r8,3.0324e-01_r8,4.1584e-01_r8/)
      kao(:, 5, 2,14) = (/ &
     &1.8354e-02_r8,5.4135e-02_r8,1.0645e-01_r8,1.5762e-01_r8,2.0683e-01_r8,2.5235e-01_r8, &
     &2.8960e-01_r8,3.0120e-01_r8,4.1280e-01_r8/)
      kao(:, 1, 3,14) = (/ &
     &4.4808e-02_r8,6.8120e-02_r8,1.3030e-01_r8,1.9402e-01_r8,2.5661e-01_r8,3.1701e-01_r8, &
     &3.7210e-01_r8,4.0841e-01_r8,5.1219e-01_r8/)
      kao(:, 2, 3,14) = (/ &
     &4.3894e-02_r8,6.7026e-02_r8,1.2859e-01_r8,1.9144e-01_r8,2.5317e-01_r8,3.1271e-01_r8, &
     &3.6711e-01_r8,4.0328e-01_r8,5.0524e-01_r8/)
      kao(:, 3, 3,14) = (/ &
     &4.3009e-02_r8,6.6189e-02_r8,1.2745e-01_r8,1.8969e-01_r8,2.5081e-01_r8,3.0975e-01_r8, &
     &3.6348e-01_r8,3.9877e-01_r8,5.0039e-01_r8/)
      kao(:, 4, 3,14) = (/ &
     &4.2131e-02_r8,6.5604e-02_r8,1.2666e-01_r8,1.8820e-01_r8,2.4871e-01_r8,3.0709e-01_r8, &
     &3.6038e-01_r8,3.9547e-01_r8,4.9608e-01_r8/)
      kao(:, 5, 3,14) = (/ &
     &4.1300e-02_r8,6.4954e-02_r8,1.2597e-01_r8,1.8706e-01_r8,2.4708e-01_r8,3.0499e-01_r8, &
     &3.5781e-01_r8,3.9252e-01_r8,4.9231e-01_r8/)
      kao(:, 1, 4,14) = (/ &
     &1.0301e-01_r8,1.0024e-01_r8,1.5513e-01_r8,2.2660e-01_r8,3.0051e-01_r8,3.7330e-01_r8, &
     &4.4331e-01_r8,5.0277e-01_r8,5.9886e-01_r8/)
      kao(:, 2, 4,14) = (/ &
     &1.0093e-01_r8,9.7693e-02_r8,1.5244e-01_r8,2.2368e-01_r8,2.9661e-01_r8,3.6838e-01_r8, &
     &4.3740e-01_r8,4.9600e-01_r8,5.9091e-01_r8/)
      kao(:, 3, 4,14) = (/ &
     &9.8888e-02_r8,9.5814e-02_r8,1.5056e-01_r8,2.2160e-01_r8,2.9368e-01_r8,3.6475e-01_r8, &
     &4.3305e-01_r8,4.9087e-01_r8,5.8504e-01_r8/)
      kao(:, 4, 4,14) = (/ &
     &9.6900e-02_r8,9.4385e-02_r8,1.4923e-01_r8,2.1998e-01_r8,2.9118e-01_r8,3.6134e-01_r8, &
     &4.2884e-01_r8,4.8615e-01_r8,5.7910e-01_r8/)
      kao(:, 5, 4,14) = (/ &
     &9.5071e-02_r8,9.3054e-02_r8,1.4811e-01_r8,2.1854e-01_r8,2.8905e-01_r8,3.5852e-01_r8, &
     &4.2539e-01_r8,4.8206e-01_r8,5.7407e-01_r8/)
      kao(:, 1, 5,14) = (/ &
     &2.1660e-01_r8,1.9045e-01_r8,2.0807e-01_r8,2.6919e-01_r8,3.4511e-01_r8,4.2945e-01_r8, &
     &5.1231e-01_r8,5.8951e-01_r8,6.8618e-01_r8/)
      kao(:, 2, 5,14) = (/ &
     &2.1241e-01_r8,1.8672e-01_r8,2.0475e-01_r8,2.6424e-01_r8,3.4065e-01_r8,4.2384e-01_r8, &
     &5.0554e-01_r8,5.8155e-01_r8,6.7701e-01_r8/)
      kao(:, 3, 5,14) = (/ &
     &2.0837e-01_r8,1.8314e-01_r8,2.0195e-01_r8,2.6053e-01_r8,3.3744e-01_r8,4.1942e-01_r8, &
     &5.0021e-01_r8,5.7551e-01_r8,6.6986e-01_r8/)
      kao(:, 4, 5,14) = (/ &
     &2.0430e-01_r8,1.7971e-01_r8,1.9948e-01_r8,2.5756e-01_r8,3.3465e-01_r8,4.1558e-01_r8, &
     &4.9517e-01_r8,5.6937e-01_r8,6.6243e-01_r8/)
      kao(:, 5, 5,14) = (/ &
     &2.0042e-01_r8,1.7656e-01_r8,1.9774e-01_r8,2.5482e-01_r8,3.3186e-01_r8,4.1183e-01_r8, &
     &4.9052e-01_r8,5.6389e-01_r8,6.5569e-01_r8/)
      kao(:, 1, 6,14) = (/ &
     &4.2427e-01_r8,3.7203e-01_r8,3.3320e-01_r8,3.5686e-01_r8,4.1154e-01_r8,4.8492e-01_r8, &
     &5.7932e-01_r8,6.7077e-01_r8,7.7255e-01_r8/)
      kao(:, 2, 6,14) = (/ &
     &4.1690e-01_r8,3.6557e-01_r8,3.2503e-01_r8,3.5212e-01_r8,4.0345e-01_r8,4.7827e-01_r8, &
     &5.7140e-01_r8,6.6143e-01_r8,7.6181e-01_r8/)
      kao(:, 3, 6,14) = (/ &
     &4.0958e-01_r8,3.5909e-01_r8,3.1787e-01_r8,3.4706e-01_r8,3.9704e-01_r8,4.7318e-01_r8, &
     &5.6463e-01_r8,6.5338e-01_r8,7.5243e-01_r8/)
      kao(:, 4, 6,14) = (/ &
     &4.0201e-01_r8,3.5239e-01_r8,3.1191e-01_r8,3.4259e-01_r8,3.9161e-01_r8,4.6839e-01_r8, &
     &5.5839e-01_r8,6.4570e-01_r8,7.4289e-01_r8/)
      kao(:, 5, 6,14) = (/ &
     &3.9475e-01_r8,3.4591e-01_r8,3.0639e-01_r8,3.3917e-01_r8,3.8642e-01_r8,4.6363e-01_r8, &
     &5.5236e-01_r8,6.3841e-01_r8,7.3426e-01_r8/)
      kao(:, 1, 7,14) = (/ &
     &8.8029e-01_r8,7.7094e-01_r8,6.6160e-01_r8,5.8339e-01_r8,5.7398e-01_r8,5.9529e-01_r8, &
     &6.4618e-01_r8,7.4819e-01_r8,8.5701e-01_r8/)
      kao(:, 2, 7,14) = (/ &
     &8.6525e-01_r8,7.5771e-01_r8,6.5024e-01_r8,5.6937e-01_r8,5.6534e-01_r8,5.8297e-01_r8, &
     &6.3577e-01_r8,7.3677e-01_r8,8.4377e-01_r8/)
      kao(:, 3, 7,14) = (/ &
     &8.5121e-01_r8,7.4536e-01_r8,6.3948e-01_r8,5.5760e-01_r8,5.5733e-01_r8,5.7172e-01_r8, &
     &6.2728e-01_r8,7.2631e-01_r8,8.3134e-01_r8/)
      kao(:, 4, 7,14) = (/ &
     &8.3673e-01_r8,7.3261e-01_r8,6.2850e-01_r8,5.4720e-01_r8,5.4987e-01_r8,5.6219e-01_r8, &
     &6.1953e-01_r8,7.1698e-01_r8,8.1995e-01_r8/)
      kao(:, 5, 7,14) = (/ &
     &8.2233e-01_r8,7.1991e-01_r8,6.1754e-01_r8,5.3796e-01_r8,5.4354e-01_r8,5.5330e-01_r8, &
     &6.1303e-01_r8,7.0902e-01_r8,8.1040e-01_r8/)
      kao(:, 1, 8,14) = (/ &
     &2.1633e+00_r8,1.8933e+00_r8,1.6233e+00_r8,1.3534e+00_r8,1.1037e+00_r8,9.5036e-01_r8, &
     &8.5982e-01_r8,8.2829e-01_r8,9.4205e-01_r8/)
      kao(:, 2, 8,14) = (/ &
     &2.1282e+00_r8,1.8626e+00_r8,1.5970e+00_r8,1.3314e+00_r8,1.0818e+00_r8,9.3527e-01_r8, &
     &8.4498e-01_r8,8.1322e-01_r8,9.2537e-01_r8/)
      kao(:, 3, 8,14) = (/ &
     &2.0953e+00_r8,1.8337e+00_r8,1.5723e+00_r8,1.3107e+00_r8,1.0621e+00_r8,9.2114e-01_r8, &
     &8.2743e-01_r8,8.0051e-01_r8,9.1039e-01_r8/)
      kao(:, 4, 8,14) = (/ &
     &2.0607e+00_r8,1.8035e+00_r8,1.5462e+00_r8,1.2890e+00_r8,1.0433e+00_r8,9.0766e-01_r8, &
     &8.1242e-01_r8,7.8938e-01_r8,8.9703e-01_r8/)
      kao(:, 5, 8,14) = (/ &
     &2.0272e+00_r8,1.7741e+00_r8,1.5210e+00_r8,1.2680e+00_r8,1.0246e+00_r8,8.9475e-01_r8, &
     &7.9856e-01_r8,7.8051e-01_r8,8.8639e-01_r8/)
      kao(:, 1, 9,14) = (/ &
     &1.0073e+01_r8,8.8141e+00_r8,7.5553e+00_r8,6.2968e+00_r8,5.0379e+00_r8,3.7790e+00_r8, &
     &2.5252e+00_r8,1.5121e+00_r8,1.0239e+00_r8/)
      kao(:, 2, 9,14) = (/ &
     &9.9292e+00_r8,8.6881e+00_r8,7.4471e+00_r8,6.2062e+00_r8,4.9656e+00_r8,3.7249e+00_r8, &
     &2.4866e+00_r8,1.4902e+00_r8,1.0036e+00_r8/)
      kao(:, 3, 9,14) = (/ &
     &9.7859e+00_r8,8.5628e+00_r8,7.3398e+00_r8,6.1169e+00_r8,4.8940e+00_r8,3.6711e+00_r8, &
     &2.4492e+00_r8,1.4699e+00_r8,9.8554e-01_r8/)
      kao(:, 4, 9,14) = (/ &
     &9.6386e+00_r8,8.4340e+00_r8,7.2293e+00_r8,6.0249e+00_r8,4.8203e+00_r8,3.6156e+00_r8, &
     &2.4114e+00_r8,1.4506e+00_r8,9.7113e-01_r8/)
      kao(:, 5, 9,14) = (/ &
     &9.4939e+00_r8,8.3072e+00_r8,7.1206e+00_r8,5.9343e+00_r8,4.7478e+00_r8,3.5614e+00_r8, &
     &2.3752e+00_r8,1.4305e+00_r8,9.6050e-01_r8/)
      kao(:, 1,10,14) = (/ &
     &5.2612e+01_r8,4.6036e+01_r8,3.9459e+01_r8,3.2882e+01_r8,2.6307e+01_r8,1.9730e+01_r8, &
     &1.3154e+01_r8,6.5782e+00_r8,1.1007e+00_r8/)
      kao(:, 2,10,14) = (/ &
     &5.2045e+01_r8,4.5541e+01_r8,3.9035e+01_r8,3.2530e+01_r8,2.6024e+01_r8,1.9518e+01_r8, &
     &1.3013e+01_r8,6.5076e+00_r8,1.0772e+00_r8/)
      kao(:, 3,10,14) = (/ &
     &5.1396e+01_r8,4.4972e+01_r8,3.8548e+01_r8,3.2123e+01_r8,2.5700e+01_r8,1.9274e+01_r8, &
     &1.2851e+01_r8,6.4259e+00_r8,1.0576e+00_r8/)
      kao(:, 4,10,14) = (/ &
     &5.0681e+01_r8,4.4348e+01_r8,3.8014e+01_r8,3.1677e+01_r8,2.5342e+01_r8,1.9007e+01_r8, &
     &1.2671e+01_r8,6.3366e+00_r8,1.0433e+00_r8/)
      kao(:, 5,10,14) = (/ &
     &4.9909e+01_r8,4.3671e+01_r8,3.7433e+01_r8,3.1194e+01_r8,2.4957e+01_r8,1.8717e+01_r8, &
     &1.2479e+01_r8,6.2406e+00_r8,1.0315e+00_r8/)
      kao(:, 1,11,14) = (/ &
     &9.5447e+01_r8,8.3519e+01_r8,7.1586e+01_r8,5.9654e+01_r8,4.7724e+01_r8,3.5792e+01_r8, &
     &2.3862e+01_r8,1.1932e+01_r8,1.1580e+00_r8/)
      kao(:, 2,11,14) = (/ &
     &9.4633e+01_r8,8.2803e+01_r8,7.0974e+01_r8,5.9145e+01_r8,4.7317e+01_r8,3.5487e+01_r8, &
     &2.3658e+01_r8,1.1830e+01_r8,1.1359e+00_r8/)
      kao(:, 3,11,14) = (/ &
     &9.3512e+01_r8,8.1822e+01_r8,7.0137e+01_r8,5.8447e+01_r8,4.6756e+01_r8,3.5068e+01_r8, &
     &2.3379e+01_r8,1.1690e+01_r8,1.1191e+00_r8/)
      kao(:, 4,11,14) = (/ &
     &9.1943e+01_r8,8.0451e+01_r8,6.8957e+01_r8,5.7463e+01_r8,4.5972e+01_r8,3.4478e+01_r8, &
     &2.2985e+01_r8,1.1494e+01_r8,1.1048e+00_r8/)
      kao(:, 5,11,14) = (/ &
     &9.0366e+01_r8,7.9072e+01_r8,6.7775e+01_r8,5.6480e+01_r8,4.5183e+01_r8,3.3888e+01_r8, &
     &2.2593e+01_r8,1.1297e+01_r8,1.0941e+00_r8/)
      kao(:, 1,12,14) = (/ &
     &1.2829e+02_r8,1.1225e+02_r8,9.6218e+01_r8,8.0178e+01_r8,6.4148e+01_r8,4.8109e+01_r8, &
     &3.2071e+01_r8,1.6037e+01_r8,1.2082e+00_r8/)
      kao(:, 2,12,14) = (/ &
     &1.2686e+02_r8,1.1100e+02_r8,9.5144e+01_r8,7.9288e+01_r8,6.3431e+01_r8,4.7572e+01_r8, &
     &3.1716e+01_r8,1.5858e+01_r8,1.1882e+00_r8/)
      kao(:, 3,12,14) = (/ &
     &1.2492e+02_r8,1.0930e+02_r8,9.3686e+01_r8,7.8073e+01_r8,6.2461e+01_r8,4.6846e+01_r8, &
     &3.1229e+01_r8,1.5615e+01_r8,1.1735e+00_r8/)
      kao(:, 4,12,14) = (/ &
     &1.2277e+02_r8,1.0742e+02_r8,9.2079e+01_r8,7.6735e+01_r8,6.1388e+01_r8,4.6041e+01_r8, &
     &3.0695e+01_r8,1.5349e+01_r8,1.1628e+00_r8/)
      kao(:, 5,12,14) = (/ &
     &1.2083e+02_r8,1.0573e+02_r8,9.0624e+01_r8,7.5519e+01_r8,6.0418e+01_r8,4.5314e+01_r8, &
     &3.0211e+01_r8,1.5107e+01_r8,1.1538e+00_r8/)
      kao(:, 1,13,14) = (/ &
     &1.3638e+02_r8,1.1933e+02_r8,1.0229e+02_r8,8.5232e+01_r8,6.8189e+01_r8,5.1142e+01_r8, &
     &3.4096e+01_r8,1.7048e+01_r8,1.2383e+00_r8/)
      kao(:, 2,13,14) = (/ &
     &1.3472e+02_r8,1.1788e+02_r8,1.0104e+02_r8,8.4200e+01_r8,6.7359e+01_r8,5.0520e+01_r8, &
     &3.3681e+01_r8,1.6841e+01_r8,1.2326e+00_r8/)
      kao(:, 3,13,14) = (/ &
     &1.3259e+02_r8,1.1602e+02_r8,9.9447e+01_r8,8.2873e+01_r8,6.6300e+01_r8,4.9725e+01_r8, &
     &3.3151e+01_r8,1.6576e+01_r8,1.2214e+00_r8/)
      kao(:, 4,13,14) = (/ &
     &1.3062e+02_r8,1.1429e+02_r8,9.7966e+01_r8,8.1640e+01_r8,6.5311e+01_r8,4.8985e+01_r8, &
     &3.2658e+01_r8,1.6329e+01_r8,1.2124e+00_r8/)
      kao(:, 5,13,14) = (/ &
     &1.2869e+02_r8,1.1261e+02_r8,9.6524e+01_r8,8.0437e+01_r8,6.4351e+01_r8,4.8263e+01_r8, &
     &3.2178e+01_r8,1.6090e+01_r8,1.2063e+00_r8/)
      kao(:, 1, 1,15) = (/ &
     &1.6224e-02_r8,5.5981e-02_r8,1.1058e-01_r8,1.6311e-01_r8,2.1224e-01_r8,2.5534e-01_r8, &
     &2.8563e-01_r8,2.8102e-01_r8,4.2449e-01_r8/)
      kao(:, 2, 1,15) = (/ &
     &1.5819e-02_r8,5.4235e-02_r8,1.0708e-01_r8,1.5789e-01_r8,2.0538e-01_r8,2.4690e-01_r8, &
     &2.7600e-01_r8,2.7172e-01_r8,4.1075e-01_r8/)
      kao(:, 3, 1,15) = (/ &
     &1.5437e-02_r8,5.3030e-02_r8,1.0453e-01_r8,1.5410e-01_r8,2.0034e-01_r8,2.4064e-01_r8, &
     &2.6869e-01_r8,2.6394e-01_r8,4.0067e-01_r8/)
      kao(:, 4, 1,15) = (/ &
     &1.5047e-02_r8,5.2309e-02_r8,1.0294e-01_r8,1.5163e-01_r8,1.9708e-01_r8,2.3671e-01_r8, &
     &2.6420e-01_r8,2.5937e-01_r8,3.9409e-01_r8/)
      kao(:, 5, 1,15) = (/ &
     &1.4670e-02_r8,5.2264e-02_r8,1.0263e-01_r8,1.5109e-01_r8,1.9635e-01_r8,2.3592e-01_r8, &
     &2.6369e-01_r8,2.6037e-01_r8,3.9232e-01_r8/)
      kao(:, 1, 2,15) = (/ &
     &2.7874e-02_r8,6.8016e-02_r8,1.3490e-01_r8,2.0013e-01_r8,2.6255e-01_r8,3.1976e-01_r8, &
     &3.6546e-01_r8,3.7626e-01_r8,5.2506e-01_r8/)
      kao(:, 2, 2,15) = (/ &
     &2.7188e-02_r8,6.5949e-02_r8,1.3068e-01_r8,1.9379e-01_r8,2.5414e-01_r8,3.0936e-01_r8, &
     &3.5322e-01_r8,3.6307e-01_r8,5.0826e-01_r8/)
      kao(:, 3, 2,15) = (/ &
     &2.6530e-02_r8,6.4457e-02_r8,1.2748e-01_r8,1.8895e-01_r8,2.4773e-01_r8,3.0143e-01_r8, &
     &3.4397e-01_r8,3.5278e-01_r8,4.9544e-01_r8/)
      kao(:, 4, 2,15) = (/ &
     &2.5866e-02_r8,6.3478e-02_r8,1.2538e-01_r8,1.8573e-01_r8,2.4341e-01_r8,2.9608e-01_r8, &
     &3.3770e-01_r8,3.4604e-01_r8,4.8658e-01_r8/)
      kao(:, 5, 2,15) = (/ &
     &2.5184e-02_r8,6.3069e-02_r8,1.2422e-01_r8,1.8387e-01_r8,2.4089e-01_r8,2.9292e-01_r8, &
     &3.3402e-01_r8,3.4222e-01_r8,4.8125e-01_r8/)
      kao(:, 1, 3,15) = (/ &
     &6.4680e-02_r8,8.3094e-02_r8,1.6505e-01_r8,2.4624e-01_r8,3.2572e-01_r8,4.0189e-01_r8, &
     &4.7033e-01_r8,5.1238e-01_r8,6.5139e-01_r8/)
      kao(:, 2, 3,15) = (/ &
     &6.3121e-02_r8,8.0680e-02_r8,1.6005e-01_r8,2.3872e-01_r8,3.1571e-01_r8,3.8944e-01_r8, &
     &4.5551e-01_r8,4.9522e-01_r8,6.3135e-01_r8/)
      kao(:, 3, 3,15) = (/ &
     &6.1563e-02_r8,7.8867e-02_r8,1.5612e-01_r8,2.3258e-01_r8,3.0746e-01_r8,3.7914e-01_r8, &
     &4.4323e-01_r8,4.8117e-01_r8,6.1483e-01_r8/)
      kao(:, 4, 3,15) = (/ &
     &6.0025e-02_r8,7.7639e-02_r8,1.5328e-01_r8,2.2820e-01_r8,3.0153e-01_r8,3.7164e-01_r8, &
     &4.3426e-01_r8,4.7103e-01_r8,6.0254e-01_r8/)
      kao(:, 5, 3,15) = (/ &
     &5.8411e-02_r8,7.7256e-02_r8,1.5120e-01_r8,2.2490e-01_r8,2.9704e-01_r8,3.6599e-01_r8, &
     &4.2759e-01_r8,4.6376e-01_r8,5.9316e-01_r8/)
      kao(:, 1, 4,15) = (/ &
     &1.5257e-01_r8,1.3544e-01_r8,2.0077e-01_r8,3.0036e-01_r8,3.9895e-01_r8,4.9562e-01_r8, &
     &5.8758e-01_r8,6.6215e-01_r8,7.9779e-01_r8/)
      kao(:, 2, 4,15) = (/ &
     &1.4896e-01_r8,1.3204e-01_r8,1.9507e-01_r8,2.9140e-01_r8,3.8695e-01_r8,4.8067e-01_r8, &
     &5.6978e-01_r8,6.4163e-01_r8,7.7379e-01_r8/)
      kao(:, 3, 4,15) = (/ &
     &1.4526e-01_r8,1.2874e-01_r8,1.9046e-01_r8,2.8415e-01_r8,3.7702e-01_r8,4.6809e-01_r8, &
     &5.5459e-01_r8,6.2416e-01_r8,7.5329e-01_r8/)
      kao(:, 4, 4,15) = (/ &
     &1.4150e-01_r8,1.2551e-01_r8,1.8699e-01_r8,2.7869e-01_r8,3.6960e-01_r8,4.5869e-01_r8, &
     &5.4325e-01_r8,6.1092e-01_r8,7.3794e-01_r8/)
      kao(:, 5, 4,15) = (/ &
     &1.3788e-01_r8,1.2292e-01_r8,1.8424e-01_r8,2.7423e-01_r8,3.6354e-01_r8,4.5105e-01_r8, &
     &5.3408e-01_r8,6.0044e-01_r8,7.2537e-01_r8/)
      kao(:, 1, 5,15) = (/ &
     &3.2844e-01_r8,2.8856e-01_r8,2.7979e-01_r8,3.6340e-01_r8,4.8359e-01_r8,6.0259e-01_r8, &
     &7.1867e-01_r8,8.2355e-01_r8,9.6702e-01_r8/)
      kao(:, 2, 5,15) = (/ &
     &3.2063e-01_r8,2.8155e-01_r8,2.6962e-01_r8,3.5320e-01_r8,4.6960e-01_r8,5.8494e-01_r8, &
     &6.9755e-01_r8,7.9908e-01_r8,9.3875e-01_r8/)
      kao(:, 3, 5,15) = (/ &
     &3.1261e-01_r8,2.7434e-01_r8,2.6034e-01_r8,3.4461e-01_r8,4.5775e-01_r8,5.6986e-01_r8, &
     &6.7919e-01_r8,7.7764e-01_r8,9.1375e-01_r8/)
      kao(:, 4, 5,15) = (/ &
     &3.0440e-01_r8,2.6704e-01_r8,2.5252e-01_r8,3.3787e-01_r8,4.4841e-01_r8,5.5807e-01_r8, &
     &6.6481e-01_r8,7.6089e-01_r8,8.9431e-01_r8/)
      kao(:, 5, 5,15) = (/ &
     &2.9686e-01_r8,2.6035e-01_r8,2.4591e-01_r8,3.3225e-01_r8,4.4072e-01_r8,5.4821e-01_r8, &
     &6.5299e-01_r8,7.4709e-01_r8,8.7822e-01_r8/)
      kao(:, 1, 6,15) = (/ &
     &6.6195e-01_r8,5.8013e-01_r8,4.9831e-01_r8,4.9605e-01_r8,5.8178e-01_r8,7.2595e-01_r8, &
     &8.6836e-01_r8,1.0033e+00_r8,1.1633e+00_r8/)
      kao(:, 2, 6,15) = (/ &
     &6.4501e-01_r8,5.6519e-01_r8,4.8535e-01_r8,4.7586e-01_r8,5.6606e-01_r8,7.0584e-01_r8, &
     &8.4395e-01_r8,9.7492e-01_r8,1.1306e+00_r8/)
      kao(:, 3, 6,15) = (/ &
     &6.2808e-01_r8,5.5020e-01_r8,4.7240e-01_r8,4.5801e-01_r8,5.5243e-01_r8,6.8837e-01_r8, &
     &8.2269e-01_r8,9.4987e-01_r8,1.1015e+00_r8/)
      kao(:, 4, 6,15) = (/ &
     &6.1101e-01_r8,5.3520e-01_r8,4.5941e-01_r8,4.4278e-01_r8,5.4121e-01_r8,6.7408e-01_r8, &
     &8.0538e-01_r8,9.2955e-01_r8,1.0781e+00_r8/)
      kao(:, 5, 6,15) = (/ &
     &5.9524e-01_r8,5.2132e-01_r8,4.4745e-01_r8,4.2965e-01_r8,5.3187e-01_r8,6.6218e-01_r8, &
     &7.9084e-01_r8,9.1257e-01_r8,1.0584e+00_r8/)
      kao(:, 1, 7,15) = (/ &
     &1.4144e+00_r8,1.2384e+00_r8,1.0623e+00_r8,8.8626e-01_r8,8.1737e-01_r8,8.6950e-01_r8, &
     &1.0395e+00_r8,1.2069e+00_r8,1.3892e+00_r8/)
      kao(:, 2, 7,15) = (/ &
     &1.3748e+00_r8,1.2036e+00_r8,1.0323e+00_r8,8.6117e-01_r8,7.8383e-01_r8,8.4592e-01_r8, &
     &1.0122e+00_r8,1.1745e+00_r8,1.3519e+00_r8/)
      kao(:, 3, 7,15) = (/ &
     &1.3356e+00_r8,1.1692e+00_r8,1.0028e+00_r8,8.3643e-01_r8,7.5357e-01_r8,8.2575e-01_r8, &
     &9.8798e-01_r8,1.1461e+00_r8,1.3189e+00_r8/)
      kao(:, 4, 7,15) = (/ &
     &1.2972e+00_r8,1.1356e+00_r8,9.7391e-01_r8,8.1222e-01_r8,7.2715e-01_r8,8.0916e-01_r8, &
     &9.6777e-01_r8,1.1223e+00_r8,1.2914e+00_r8/)
      kao(:, 5, 7,15) = (/ &
     &1.2621e+00_r8,1.1049e+00_r8,9.4752e-01_r8,7.9014e-01_r8,7.0399e-01_r8,7.9481e-01_r8, &
     &9.5022e-01_r8,1.1017e+00_r8,1.2675e+00_r8/)
      kao(:, 1, 8,15) = (/ &
     &3.5678e+00_r8,3.1226e+00_r8,2.6774e+00_r8,2.2323e+00_r8,1.7871e+00_r8,1.4068e+00_r8, &
     &1.2751e+00_r8,1.4347e+00_r8,1.6442e+00_r8/)
      kao(:, 2, 8,15) = (/ &
     &3.4620e+00_r8,3.0298e+00_r8,2.5977e+00_r8,2.1657e+00_r8,1.7337e+00_r8,1.3525e+00_r8, &
     &1.2330e+00_r8,1.4002e+00_r8,1.6038e+00_r8/)
      kao(:, 3, 8,15) = (/ &
     &3.3581e+00_r8,2.9387e+00_r8,2.5197e+00_r8,2.1005e+00_r8,1.6813e+00_r8,1.3030e+00_r8, &
     &1.1987e+00_r8,1.3683e+00_r8,1.5668e+00_r8/)
      kao(:, 4, 8,15) = (/ &
     &3.2581e+00_r8,2.8514e+00_r8,2.4446e+00_r8,2.0378e+00_r8,1.6310e+00_r8,1.2580e+00_r8, &
     &1.1700e+00_r8,1.3407e+00_r8,1.5349e+00_r8/)
      kao(:, 5, 8,15) = (/ &
     &3.1664e+00_r8,2.7709e+00_r8,2.3756e+00_r8,1.9802e+00_r8,1.5848e+00_r8,1.2171e+00_r8, &
     &1.1461e+00_r8,1.3159e+00_r8,1.5061e+00_r8/)
      kao(:, 1, 9,15) = (/ &
     &1.6997e+01_r8,1.4874e+01_r8,1.2750e+01_r8,1.0625e+01_r8,8.5017e+00_r8,6.3777e+00_r8, &
     &4.2536e+00_r8,2.2902e+00_r8,1.9313e+00_r8/)
      kao(:, 2, 9,15) = (/ &
     &1.6471e+01_r8,1.4414e+01_r8,1.2355e+01_r8,1.0296e+01_r8,8.2389e+00_r8,6.1803e+00_r8, &
     &4.1219e+00_r8,2.1942e+00_r8,1.8874e+00_r8/)
      kao(:, 3, 9,15) = (/ &
     &1.5959e+01_r8,1.3964e+01_r8,1.1970e+01_r8,9.9759e+00_r8,7.9817e+00_r8,5.9872e+00_r8, &
     &3.9932e+00_r8,2.1070e+00_r8,1.8460e+00_r8/)
      kao(:, 4, 9,15) = (/ &
     &1.5470e+01_r8,1.3538e+01_r8,1.1604e+01_r8,9.6708e+00_r8,7.7374e+00_r8,5.8040e+00_r8, &
     &3.8707e+00_r8,2.0267e+00_r8,1.8089e+00_r8/)
      kao(:, 5, 9,15) = (/ &
     &1.5020e+01_r8,1.3143e+01_r8,1.1265e+01_r8,9.3885e+00_r8,7.5114e+00_r8,5.6345e+00_r8, &
     &3.7577e+00_r8,1.9548e+00_r8,1.7742e+00_r8/)
      kao(:, 1,10,15) = (/ &
     &9.0636e+01_r8,7.9307e+01_r8,6.7977e+01_r8,5.6649e+01_r8,4.5320e+01_r8,3.3991e+01_r8, &
     &2.2662e+01_r8,1.1334e+01_r8,2.2438e+00_r8/)
      kao(:, 2,10,15) = (/ &
     &8.7565e+01_r8,7.6621e+01_r8,6.5675e+01_r8,5.4728e+01_r8,4.3786e+01_r8,3.2842e+01_r8, &
     &2.1895e+01_r8,1.0950e+01_r8,2.1955e+00_r8/)
      kao(:, 3,10,15) = (/ &
     &8.4686e+01_r8,7.4100e+01_r8,6.3516e+01_r8,5.2929e+01_r8,4.2345e+01_r8,3.1759e+01_r8, &
     &2.1174e+01_r8,1.0590e+01_r8,2.1489e+00_r8/)
      kao(:, 4,10,15) = (/ &
     &8.2038e+01_r8,7.1783e+01_r8,6.1529e+01_r8,5.1276e+01_r8,4.1020e+01_r8,3.0766e+01_r8, &
     &2.0512e+01_r8,1.0258e+01_r8,2.1057e+00_r8/)
      kao(:, 5,10,15) = (/ &
     &7.9656e+01_r8,6.9701e+01_r8,5.9744e+01_r8,4.9787e+01_r8,3.9829e+01_r8,2.9874e+01_r8, &
     &1.9917e+01_r8,9.9593e+00_r8,2.0648e+00_r8/)
      kao(:, 1,11,15) = (/ &
     &1.6605e+02_r8,1.4529e+02_r8,1.2455e+02_r8,1.0378e+02_r8,8.3029e+01_r8,6.2280e+01_r8, &
     &4.1517e+01_r8,2.0760e+01_r8,2.5530e+00_r8/)
      kao(:, 2,11,15) = (/ &
     &1.6006e+02_r8,1.4006e+02_r8,1.2005e+02_r8,1.0004e+02_r8,8.0031e+01_r8,6.0027e+01_r8, &
     &4.0019e+01_r8,2.0011e+01_r8,2.4994e+00_r8/)
      kao(:, 3,11,15) = (/ &
     &1.5475e+02_r8,1.3539e+02_r8,1.1606e+02_r8,9.6709e+01_r8,7.7371e+01_r8,5.8029e+01_r8, &
     &3.8687e+01_r8,1.9345e+01_r8,2.4484e+00_r8/)
      kao(:, 4,11,15) = (/ &
     &1.5058e+02_r8,1.3176e+02_r8,1.1294e+02_r8,9.4118e+01_r8,7.5292e+01_r8,5.6471e+01_r8, &
     &3.7649e+01_r8,1.8825e+01_r8,2.4006e+00_r8/)
      kao(:, 5,11,15) = (/ &
     &1.4680e+02_r8,1.2845e+02_r8,1.1009e+02_r8,9.1748e+01_r8,7.3399e+01_r8,5.5050e+01_r8, &
     &3.6700e+01_r8,1.8351e+01_r8,2.3540e+00_r8/)
      kao(:, 1,12,15) = (/ &
     &2.2602e+02_r8,1.9778e+02_r8,1.6953e+02_r8,1.4127e+02_r8,1.1301e+02_r8,8.4757e+01_r8, &
     &5.6507e+01_r8,2.8257e+01_r8,2.8716e+00_r8/)
      kao(:, 2,12,15) = (/ &
     &2.1869e+02_r8,1.9135e+02_r8,1.6402e+02_r8,1.3669e+02_r8,1.0935e+02_r8,8.2013e+01_r8, &
     &5.4674e+01_r8,2.7339e+01_r8,2.8132e+00_r8/)
      kao(:, 3,12,15) = (/ &
     &2.1253e+02_r8,1.8597e+02_r8,1.5940e+02_r8,1.3282e+02_r8,1.0626e+02_r8,7.9692e+01_r8, &
     &5.3134e+01_r8,2.6567e+01_r8,2.7573e+00_r8/)
      kao(:, 4,12,15) = (/ &
     &2.0725e+02_r8,1.8134e+02_r8,1.5543e+02_r8,1.2952e+02_r8,1.0362e+02_r8,7.7720e+01_r8, &
     &5.1811e+01_r8,2.5907e+01_r8,2.7022e+00_r8/)
      kao(:, 5,12,15) = (/ &
     &2.0216e+02_r8,1.7690e+02_r8,1.5162e+02_r8,1.2635e+02_r8,1.0108e+02_r8,7.5810e+01_r8, &
     &5.0540e+01_r8,2.5271e+01_r8,2.6508e+00_r8/)
      kao(:, 1,13,15) = (/ &
     &2.4880e+02_r8,2.1770e+02_r8,1.8661e+02_r8,1.5550e+02_r8,1.2440e+02_r8,9.3305e+01_r8, &
     &6.2205e+01_r8,3.1105e+01_r8,3.1971e+00_r8/)
      kao(:, 2,13,15) = (/ &
     &2.4131e+02_r8,2.1114e+02_r8,1.8097e+02_r8,1.5081e+02_r8,1.2065e+02_r8,9.0483e+01_r8, &
     &6.0327e+01_r8,3.0165e+01_r8,3.1338e+00_r8/)
      kao(:, 3,13,15) = (/ &
     &2.3499e+02_r8,2.0562e+02_r8,1.7624e+02_r8,1.4687e+02_r8,1.1750e+02_r8,8.8123e+01_r8, &
     &5.8749e+01_r8,2.9377e+01_r8,3.0697e+00_r8/)
      kao(:, 4,13,15) = (/ &
     &2.2900e+02_r8,2.0038e+02_r8,1.7175e+02_r8,1.4313e+02_r8,1.1451e+02_r8,8.5878e+01_r8, &
     &5.7253e+01_r8,2.8627e+01_r8,3.0070e+00_r8/)
      kao(:, 5,13,15) = (/ &
     &2.2306e+02_r8,1.9518e+02_r8,1.6729e+02_r8,1.3941e+02_r8,1.1152e+02_r8,8.3649e+01_r8, &
     &5.5766e+01_r8,2.7883e+01_r8,2.9481e+00_r8/)
      kao(:, 1, 1,16) = (/ &
     &1.9445e-02_r8,6.3230e-02_r8,1.2479e-01_r8,1.8384e-01_r8,2.3882e-01_r8,2.8643e-01_r8, &
     &3.1893e-01_r8,3.1112e-01_r8,4.7763e-01_r8/)
      kao(:, 2, 1,16) = (/ &
     &1.8835e-02_r8,6.2634e-02_r8,1.2363e-01_r8,1.8213e-01_r8,2.3659e-01_r8,2.8379e-01_r8, &
     &3.1600e-01_r8,3.0828e-01_r8,4.7319e-01_r8/)
      kao(:, 3, 1,16) = (/ &
     &1.8228e-02_r8,6.1941e-02_r8,1.2224e-01_r8,1.8013e-01_r8,2.3399e-01_r8,2.8070e-01_r8, &
     &3.1257e-01_r8,3.0493e-01_r8,4.6798e-01_r8/)
      kao(:, 4, 1,16) = (/ &
     &1.7647e-02_r8,6.1170e-02_r8,1.2073e-01_r8,1.7790e-01_r8,2.3107e-01_r8,2.7723e-01_r8, &
     &3.0877e-01_r8,3.0124e-01_r8,4.6215e-01_r8/)
      kao(:, 5, 1,16) = (/ &
     &1.7079e-02_r8,6.0350e-02_r8,1.1912e-01_r8,1.7548e-01_r8,2.2801e-01_r8,2.7357e-01_r8, &
     &3.0466e-01_r8,2.9733e-01_r8,4.5602e-01_r8/)
      kao(:, 1, 2,16) = (/ &
     &3.4634e-02_r8,7.7044e-02_r8,1.5273e-01_r8,2.2632e-01_r8,2.9575e-01_r8,3.6021e-01_r8, &
     &4.0997e-01_r8,4.1812e-01_r8,5.9296e-01_r8/)
      kao(:, 2, 2,16) = (/ &
     &3.3420e-02_r8,7.6207e-02_r8,1.5110e-01_r8,2.2402e-01_r8,2.9356e-01_r8,3.5685e-01_r8, &
     &4.0638e-01_r8,4.1457e-01_r8,5.8711e-01_r8/)
      kao(:, 3, 2,16) = (/ &
     &3.2246e-02_r8,7.5373e-02_r8,1.4946e-01_r8,2.2157e-01_r8,2.9037e-01_r8,3.5299e-01_r8, &
     &4.0204e-01_r8,4.1028e-01_r8,5.8073e-01_r8/)
      kao(:, 4, 2,16) = (/ &
     &3.1106e-02_r8,7.4437e-02_r8,1.4762e-01_r8,2.1883e-01_r8,2.8679e-01_r8,3.4868e-01_r8, &
     &3.9718e-01_r8,4.0541e-01_r8,5.7357e-01_r8/)
      kao(:, 5, 2,16) = (/ &
     &3.0021e-02_r8,7.3426e-02_r8,1.4561e-01_r8,2.1587e-01_r8,2.8293e-01_r8,3.4400e-01_r8, &
     &3.9193e-01_r8,4.0015e-01_r8,5.6584e-01_r8/)
      kao(:, 1, 3,16) = (/ &
     &8.3051e-02_r8,9.4793e-02_r8,1.8876e-01_r8,2.8144e-01_r8,3.7196e-01_r8,4.5816e-01_r8, &
     &5.3450e-01_r8,5.7690e-01_r8,7.4391e-01_r8/)
      kao(:, 2, 3,16) = (/ &
     &7.9830e-02_r8,9.3082e-02_r8,1.8538e-01_r8,2.7644e-01_r8,3.6534e-01_r8,4.5017e-01_r8, &
     &5.2550e-01_r8,5.6808e-01_r8,7.3067e-01_r8/)
      kao(:, 3, 3,16) = (/ &
     &7.6737e-02_r8,9.1705e-02_r8,1.8269e-01_r8,2.7246e-01_r8,3.6014e-01_r8,4.4395e-01_r8, &
     &5.1857e-01_r8,5.6175e-01_r8,7.2028e-01_r8/)
      kao(:, 4, 3,16) = (/ &
     &7.3809e-02_r8,9.0497e-02_r8,1.8026e-01_r8,2.6888e-01_r8,3.5554e-01_r8,4.3839e-01_r8, &
     &5.1223e-01_r8,5.5508e-01_r8,7.1107e-01_r8/)
      kao(:, 5, 3,16) = (/ &
     &7.1033e-02_r8,8.9276e-02_r8,1.7779e-01_r8,2.6523e-01_r8,3.5066e-01_r8,4.3243e-01_r8, &
     &5.0536e-01_r8,5.4783e-01_r8,7.0132e-01_r8/)
      kao(:, 1, 4,16) = (/ &
     &2.0125e-01_r8,1.7779e-01_r8,2.3399e-01_r8,3.4997e-01_r8,4.6464e-01_r8,5.7674e-01_r8, &
     &6.8253e-01_r8,7.6508e-01_r8,9.2928e-01_r8/)
      kao(:, 2, 4,16) = (/ &
     &1.9265e-01_r8,1.7048e-01_r8,2.2831e-01_r8,3.4146e-01_r8,4.5338e-01_r8,5.6281e-01_r8, &
     &6.6618e-01_r8,7.4718e-01_r8,9.0679e-01_r8/)
      kao(:, 3, 4,16) = (/ &
     &1.8456e-01_r8,1.6365e-01_r8,2.2378e-01_r8,3.3476e-01_r8,4.4451e-01_r8,5.5182e-01_r8, &
     &6.5330e-01_r8,7.3313e-01_r8,8.8901e-01_r8/)
      kao(:, 4, 4,16) = (/ &
     &1.7702e-01_r8,1.5723e-01_r8,2.1978e-01_r8,3.2875e-01_r8,4.3660e-01_r8,5.4199e-01_r8, &
     &6.4188e-01_r8,7.2098e-01_r8,8.7320e-01_r8/)
      kao(:, 5, 4,16) = (/ &
     &1.6997e-01_r8,1.5116e-01_r8,2.1600e-01_r8,3.2314e-01_r8,4.2913e-01_r8,5.3288e-01_r8, &
     &6.3120e-01_r8,7.0945e-01_r8,8.5826e-01_r8/)
      kao(:, 1, 5,16) = (/ &
     &4.4228e-01_r8,3.8795e-01_r8,3.3395e-01_r8,4.3605e-01_r8,5.8013e-01_r8,7.2255e-01_r8, &
     &8.6084e-01_r8,9.8346e-01_r8,1.1603e+00_r8/)
      kao(:, 2, 5,16) = (/ &
     &4.2199e-01_r8,3.7056e-01_r8,3.1956e-01_r8,4.2215e-01_r8,5.6164e-01_r8,6.9945e-01_r8, &
     &8.3347e-01_r8,9.5217e-01_r8,1.1233e+00_r8/)
      kao(:, 3, 5,16) = (/ &
     &4.0375e-01_r8,3.5492e-01_r8,3.0638e-01_r8,4.1150e-01_r8,5.4754e-01_r8,6.8200e-01_r8, &
     &8.1260e-01_r8,9.2875e-01_r8,1.0951e+00_r8/)
      kao(:, 4, 5,16) = (/ &
     &3.8716e-01_r8,3.4051e-01_r8,2.9411e-01_r8,4.0247e-01_r8,5.3546e-01_r8,6.6706e-01_r8, &
     &7.9494e-01_r8,9.0883e-01_r8,1.0709e+00_r8/)
      kao(:, 5, 5,16) = (/ &
     &3.7160e-01_r8,3.2689e-01_r8,2.8321e-01_r8,3.9414e-01_r8,5.2444e-01_r8,6.5338e-01_r8, &
     &7.7865e-01_r8,8.9056e-01_r8,1.0489e+00_r8/)
      kao(:, 1, 6,16) = (/ &
     &9.0506e-01_r8,7.9284e-01_r8,6.8068e-01_r8,5.6916e-01_r8,7.2503e-01_r8,9.0468e-01_r8, &
     &1.0813e+00_r8,1.2473e+00_r8,1.4500e+00_r8/)
      kao(:, 2, 6,16) = (/ &
     &8.6465e-01_r8,7.5773e-01_r8,6.5086e-01_r8,5.4531e-01_r8,6.9722e-01_r8,8.6983e-01_r8, &
     &1.0397e+00_r8,1.1992e+00_r8,1.3944e+00_r8/)
      kao(:, 3, 6,16) = (/ &
     &8.2825e-01_r8,7.2598e-01_r8,6.2379e-01_r8,5.2549e-01_r8,6.7605e-01_r8,8.4340e-01_r8, &
     &1.0082e+00_r8,1.1629e+00_r8,1.3521e+00_r8/)
      kao(:, 4, 6,16) = (/ &
     &7.9420e-01_r8,6.9632e-01_r8,5.9834e-01_r8,5.1029e-01_r8,6.5811e-01_r8,8.2106e-01_r8, &
     &9.8160e-01_r8,1.1324e+00_r8,1.3162e+00_r8/)
      kao(:, 5, 6,16) = (/ &
     &7.6215e-01_r8,6.6829e-01_r8,5.7431e-01_r8,4.9359e-01_r8,6.4194e-01_r8,8.0089e-01_r8, &
     &9.5749e-01_r8,1.1049e+00_r8,1.2839e+00_r8/)
      kao(:, 1, 7,16) = (/ &
     &1.9676e+00_r8,1.7224e+00_r8,1.4775e+00_r8,1.2325e+00_r8,9.8756e-01_r8,1.1304e+00_r8, &
     &1.3539e+00_r8,1.5704e+00_r8,1.8105e+00_r8/)
      kao(:, 2, 7,16) = (/ &
     &1.8838e+00_r8,1.6493e+00_r8,1.4147e+00_r8,1.1804e+00_r8,9.4604e-01_r8,1.0806e+00_r8, &
     &1.2942e+00_r8,1.5011e+00_r8,1.7307e+00_r8/)
      kao(:, 3, 7,16) = (/ &
     &1.8058e+00_r8,1.5808e+00_r8,1.3563e+00_r8,1.1318e+00_r8,9.0772e-01_r8,1.0432e+00_r8, &
     &1.2494e+00_r8,1.4491e+00_r8,1.6707e+00_r8/)
      kao(:, 4, 7,16) = (/ &
     &1.7320e+00_r8,1.5166e+00_r8,1.3008e+00_r8,1.0854e+00_r8,8.7621e-01_r8,1.0114e+00_r8, &
     &1.2114e+00_r8,1.4051e+00_r8,1.6197e+00_r8/)
      kao(:, 5, 7,16) = (/ &
     &1.6617e+00_r8,1.4551e+00_r8,1.2484e+00_r8,1.0417e+00_r8,8.4899e-01_r8,9.8293e-01_r8, &
     &1.1773e+00_r8,1.3657e+00_r8,1.5743e+00_r8/)
      kao(:, 1, 8,16) = (/ &
     &5.0769e+00_r8,4.4432e+00_r8,3.8096e+00_r8,3.1755e+00_r8,2.5417e+00_r8,1.9082e+00_r8, &
     &1.6892e+00_r8,1.9659e+00_r8,2.2550e+00_r8/)
      kao(:, 2, 8,16) = (/ &
     &4.8681e+00_r8,4.2603e+00_r8,3.6527e+00_r8,3.0450e+00_r8,2.4373e+00_r8,1.8300e+00_r8, &
     &1.6072e+00_r8,1.8705e+00_r8,2.1455e+00_r8/)
      kao(:, 3, 8,16) = (/ &
     &4.6692e+00_r8,4.0861e+00_r8,3.5032e+00_r8,2.9205e+00_r8,2.3378e+00_r8,1.7550e+00_r8, &
     &1.5446e+00_r8,1.7976e+00_r8,2.0621e+00_r8/)
      kao(:, 4, 8,16) = (/ &
     &4.4792e+00_r8,3.9199e+00_r8,3.3609e+00_r8,2.8016e+00_r8,2.2429e+00_r8,1.6836e+00_r8, &
     &1.4923e+00_r8,1.7367e+00_r8,1.9921e+00_r8/)
      kao(:, 5, 8,16) = (/ &
     &4.2972e+00_r8,3.7609e+00_r8,3.2243e+00_r8,2.6879e+00_r8,2.1517e+00_r8,1.6153e+00_r8, &
     &1.4455e+00_r8,1.6824e+00_r8,1.9297e+00_r8/)
      kao(:, 1, 9,16) = (/ &
     &2.4893e+01_r8,2.1786e+01_r8,1.8675e+01_r8,1.5563e+01_r8,1.2450e+01_r8,9.3398e+00_r8, &
     &6.2286e+00_r8,3.1170e+00_r8,2.8014e+00_r8/)
      kao(:, 2, 9,16) = (/ &
     &2.3897e+01_r8,2.0912e+01_r8,1.7925e+01_r8,1.4937e+01_r8,1.1951e+01_r8,8.9651e+00_r8, &
     &5.9788e+00_r8,2.9923e+00_r8,2.6581e+00_r8/)
      kao(:, 3, 9,16) = (/ &
     &2.2932e+01_r8,2.0066e+01_r8,1.7201e+01_r8,1.4334e+01_r8,1.1468e+01_r8,8.6027e+00_r8, &
     &5.7371e+00_r8,2.8711e+00_r8,2.5442e+00_r8/)
      kao(:, 4, 9,16) = (/ &
     &2.1999e+01_r8,1.9250e+01_r8,1.6501e+01_r8,1.3753e+01_r8,1.1001e+01_r8,8.2533e+00_r8, &
     &5.5038e+00_r8,2.7545e+00_r8,2.4493e+00_r8/)
      kao(:, 5, 9,16) = (/ &
     &2.1105e+01_r8,1.8469e+01_r8,1.5831e+01_r8,1.3195e+01_r8,1.0556e+01_r8,7.9178e+00_r8, &
     &5.2806e+00_r8,2.6423e+00_r8,2.3650e+00_r8/)
      kao(:, 1,10,16) = (/ &
     &1.3702e+02_r8,1.1990e+02_r8,1.0277e+02_r8,8.5642e+01_r8,6.8515e+01_r8,5.1385e+01_r8, &
     &3.4262e+01_r8,1.7133e+01_r8,3.4526e+00_r8/)
      kao(:, 2,10,16) = (/ &
     &1.3162e+02_r8,1.1516e+02_r8,9.8725e+01_r8,8.2273e+01_r8,6.5802e+01_r8,4.9353e+01_r8, &
     &3.2909e+01_r8,1.6459e+01_r8,3.2683e+00_r8/)
      kao(:, 3,10,16) = (/ &
     &1.2631e+02_r8,1.1053e+02_r8,9.4741e+01_r8,7.8943e+01_r8,6.3147e+01_r8,4.7375e+01_r8, &
     &3.1582e+01_r8,1.5793e+01_r8,3.1197e+00_r8/)
      kao(:, 4,10,16) = (/ &
     &1.2113e+02_r8,1.0599e+02_r8,9.0842e+01_r8,7.5703e+01_r8,6.0562e+01_r8,4.5424e+01_r8, &
     &3.0282e+01_r8,1.5145e+01_r8,2.9946e+00_r8/)
      kao(:, 5,10,16) = (/ &
     &1.1642e+02_r8,1.0187e+02_r8,8.7320e+01_r8,7.2762e+01_r8,5.8215e+01_r8,4.3658e+01_r8, &
     &2.9108e+01_r8,1.4557e+01_r8,2.8829e+00_r8/)
      kao(:, 1,11,16) = (/ &
     &2.5880e+02_r8,2.2644e+02_r8,1.9413e+02_r8,1.6174e+02_r8,1.2941e+02_r8,9.7065e+01_r8, &
     &6.4700e+01_r8,3.2352e+01_r8,4.1212e+00_r8/)
      kao(:, 2,11,16) = (/ &
     &2.4838e+02_r8,2.1734e+02_r8,1.8628e+02_r8,1.5524e+02_r8,1.2419e+02_r8,9.3146e+01_r8, &
     &6.2097e+01_r8,3.1052e+01_r8,3.9061e+00_r8/)
      kao(:, 3,11,16) = (/ &
     &2.3869e+02_r8,2.0886e+02_r8,1.7902e+02_r8,1.4918e+02_r8,1.1935e+02_r8,8.9511e+01_r8, &
     &5.9677e+01_r8,2.9841e+01_r8,3.7301e+00_r8/)
      kao(:, 4,11,16) = (/ &
     &2.2943e+02_r8,2.0074e+02_r8,1.7207e+02_r8,1.4339e+02_r8,1.1472e+02_r8,8.6039e+01_r8, &
     &5.7356e+01_r8,2.8682e+01_r8,3.5754e+00_r8/)
      kao(:, 5,11,16) = (/ &
     &2.2131e+02_r8,1.9367e+02_r8,1.6600e+02_r8,1.3834e+02_r8,1.1067e+02_r8,8.3001e+01_r8, &
     &5.5340e+01_r8,2.7668e+01_r8,3.4351e+00_r8/)
      kao(:, 1,12,16) = (/ &
     &3.6519e+02_r8,3.1953e+02_r8,2.7390e+02_r8,2.2827e+02_r8,1.8260e+02_r8,1.3695e+02_r8, &
     &9.1294e+01_r8,4.5654e+01_r8,4.8878e+00_r8/)
      kao(:, 2,12,16) = (/ &
     &3.5163e+02_r8,3.0767e+02_r8,2.6371e+02_r8,2.1977e+02_r8,1.7580e+02_r8,1.3186e+02_r8, &
     &8.7903e+01_r8,4.3953e+01_r8,4.5957e+00_r8/)
      kao(:, 3,12,16) = (/ &
     &3.3818e+02_r8,2.9589e+02_r8,2.5364e+02_r8,2.1136e+02_r8,1.6910e+02_r8,1.2682e+02_r8, &
     &8.4547e+01_r8,4.2272e+01_r8,4.4276e+00_r8/)
      kao(:, 4,12,16) = (/ &
     &3.2523e+02_r8,2.8457e+02_r8,2.4393e+02_r8,2.0329e+02_r8,1.6262e+02_r8,1.2197e+02_r8, &
     &8.1319e+01_r8,4.0657e+01_r8,4.2352e+00_r8/)
      kao(:, 5,12,16) = (/ &
     &3.1377e+02_r8,2.7452e+02_r8,2.3534e+02_r8,1.9609e+02_r8,1.5688e+02_r8,1.1765e+02_r8, &
     &7.8446e+01_r8,3.9220e+01_r8,4.0574e+00_r8/)
      kao(:, 1,13,16) = (/ &
     &4.1560e+02_r8,3.6364e+02_r8,3.1170e+02_r8,2.5976e+02_r8,2.0781e+02_r8,1.5585e+02_r8, &
     &1.0390e+02_r8,5.1953e+01_r8,5.7636e+00_r8/)
      kao(:, 2,13,16) = (/ &
     &3.9970e+02_r8,3.4978e+02_r8,2.9980e+02_r8,2.4983e+02_r8,1.9986e+02_r8,1.4990e+02_r8, &
     &9.9932e+01_r8,4.9970e+01_r8,5.4706e+00_r8/)
      kao(:, 3,13,16) = (/ &
     &3.8378e+02_r8,3.3582e+02_r8,2.8782e+02_r8,2.3987e+02_r8,1.9190e+02_r8,1.4391e+02_r8, &
     &9.5948e+01_r8,4.7978e+01_r8,5.2080e+00_r8/)
      kao(:, 4,13,16) = (/ &
     &3.6900e+02_r8,3.2290e+02_r8,2.7675e+02_r8,2.3063e+02_r8,1.8451e+02_r8,1.3838e+02_r8, &
     &9.2254e+01_r8,4.6129e+01_r8,4.9718e+00_r8/)
      kao(:, 5,13,16) = (/ &
     &3.5587e+02_r8,3.1138e+02_r8,2.6690e+02_r8,2.2242e+02_r8,1.7795e+02_r8,1.3345e+02_r8, &
     &8.8970e+01_r8,4.4486e+01_r8,4.7553e+00_r8/)

!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

      kbo(:,13, 1) = (/ &
     &6.6242e-04_r8,6.9229e-04_r8,7.2125e-04_r8,7.5111e-04_r8,7.7882e-04_r8/)
      kbo(:,14, 1) = (/ &
     &5.7148e-04_r8,6.0011e-04_r8,6.2434e-04_r8,6.4765e-04_r8,6.6822e-04_r8/)
      kbo(:,15, 1) = (/ &
     &5.0245e-04_r8,5.2495e-04_r8,5.4519e-04_r8,5.6261e-04_r8,5.8004e-04_r8/)
      kbo(:,16, 1) = (/ &
     &4.4219e-04_r8,4.6335e-04_r8,4.7782e-04_r8,4.9293e-04_r8,5.0687e-04_r8/)
      kbo(:,17, 1) = (/ &
     &3.9452e-04_r8,4.1172e-04_r8,4.2558e-04_r8,4.3834e-04_r8,4.5031e-04_r8/)
      kbo(:,18, 1) = (/ &
     &3.5502e-04_r8,3.7021e-04_r8,3.8062e-04_r8,3.9326e-04_r8,4.0413e-04_r8/)
      kbo(:,19, 1) = (/ &
     &3.1835e-04_r8,3.3204e-04_r8,3.4438e-04_r8,3.5308e-04_r8,3.6251e-04_r8/)
      kbo(:,20, 1) = (/ &
     &2.7685e-04_r8,2.8739e-04_r8,2.9799e-04_r8,3.0565e-04_r8,3.1346e-04_r8/)
      kbo(:,21, 1) = (/ &
     &2.3803e-04_r8,2.4613e-04_r8,2.5507e-04_r8,2.6118e-04_r8,2.6805e-04_r8/)
      kbo(:,22, 1) = (/ &
     &2.0518e-04_r8,2.1064e-04_r8,2.1799e-04_r8,2.2345e-04_r8,2.2945e-04_r8/)
      kbo(:,23, 1) = (/ &
     &1.7609e-04_r8,1.8136e-04_r8,1.8691e-04_r8,1.9179e-04_r8,1.9680e-04_r8/)
      kbo(:,24, 1) = (/ &
     &1.5133e-04_r8,1.5582e-04_r8,1.6020e-04_r8,1.6517e-04_r8,1.6912e-04_r8/)
      kbo(:,25, 1) = (/ &
     &1.3023e-04_r8,1.3355e-04_r8,1.3826e-04_r8,1.4195e-04_r8,1.4464e-04_r8/)
      kbo(:,26, 1) = (/ &
     &1.1153e-04_r8,1.1437e-04_r8,1.1820e-04_r8,1.2126e-04_r8,1.2331e-04_r8/)
      kbo(:,27, 1) = (/ &
     &9.5262e-05_r8,9.8055e-05_r8,1.0080e-04_r8,1.0342e-04_r8,1.0508e-04_r8/)
      kbo(:,28, 1) = (/ &
     &8.1680e-05_r8,8.3691e-05_r8,8.6133e-05_r8,8.8128e-05_r8,8.9712e-05_r8/)
      kbo(:,29, 1) = (/ &
     &7.0309e-05_r8,7.1883e-05_r8,7.3686e-05_r8,7.5287e-05_r8,7.6689e-05_r8/)
      kbo(:,30, 1) = (/ &
     &6.0539e-05_r8,6.1910e-05_r8,6.3188e-05_r8,6.4488e-05_r8,6.6886e-05_r8/)
      kbo(:,31, 1) = (/ &
     &5.2744e-05_r8,5.3514e-05_r8,5.4453e-05_r8,5.5692e-05_r8,5.7687e-05_r8/)
      kbo(:,32, 1) = (/ &
     &4.5908e-05_r8,4.6319e-05_r8,4.7373e-05_r8,4.8133e-05_r8,4.9705e-05_r8/)
      kbo(:,33, 1) = (/ &
     &3.9867e-05_r8,4.0547e-05_r8,4.1159e-05_r8,4.1892e-05_r8,4.3045e-05_r8/)
      kbo(:,34, 1) = (/ &
     &3.4676e-05_r8,3.5573e-05_r8,3.6016e-05_r8,3.7022e-05_r8,3.7402e-05_r8/)
      kbo(:,35, 1) = (/ &
     &3.0380e-05_r8,3.1177e-05_r8,3.1680e-05_r8,3.2397e-05_r8,3.2578e-05_r8/)
      kbo(:,36, 1) = (/ &
     &2.6710e-05_r8,2.7409e-05_r8,2.7919e-05_r8,2.8397e-05_r8,2.8592e-05_r8/)
      kbo(:,37, 1) = (/ &
     &2.2468e-05_r8,2.3018e-05_r8,2.3378e-05_r8,2.3912e-05_r8,2.4011e-05_r8/)
      kbo(:,38, 1) = (/ &
     &1.8961e-05_r8,1.9311e-05_r8,1.9590e-05_r8,2.0060e-05_r8,2.0183e-05_r8/)
      kbo(:,39, 1) = (/ &
     &1.6038e-05_r8,1.6240e-05_r8,1.6497e-05_r8,1.6653e-05_r8,1.7067e-05_r8/)
      kbo(:,40, 1) = (/ &
     &1.3126e-05_r8,1.3247e-05_r8,1.3457e-05_r8,1.3586e-05_r8,1.3950e-05_r8/)
      kbo(:,41, 1) = (/ &
     &1.0642e-05_r8,1.0779e-05_r8,1.0904e-05_r8,1.1060e-05_r8,1.1348e-05_r8/)
      kbo(:,42, 1) = (/ &
     &8.5931e-06_r8,8.7256e-06_r8,8.8249e-06_r8,8.9763e-06_r8,9.1997e-06_r8/)
      kbo(:,43, 1) = (/ &
     &6.8315e-06_r8,7.0003e-06_r8,7.0825e-06_r8,7.1921e-06_r8,7.3080e-06_r8/)
      kbo(:,44, 1) = (/ &
     &5.4113e-06_r8,5.5622e-06_r8,5.6277e-06_r8,5.7357e-06_r8,5.8407e-06_r8/)
      kbo(:,45, 1) = (/ &
     &4.2868e-06_r8,4.4145e-06_r8,4.4700e-06_r8,4.5509e-06_r8,4.6597e-06_r8/)
      kbo(:,46, 1) = (/ &
     &3.3813e-06_r8,3.5001e-06_r8,3.5350e-06_r8,3.6083e-06_r8,3.6919e-06_r8/)
      kbo(:,47, 1) = (/ &
     &2.6664e-06_r8,2.7723e-06_r8,2.7972e-06_r8,2.8533e-06_r8,2.9267e-06_r8/)
      kbo(:,48, 1) = (/ &
     &2.0946e-06_r8,2.1711e-06_r8,2.2048e-06_r8,2.2465e-06_r8,2.3102e-06_r8/)
      kbo(:,49, 1) = (/ &
     &1.6333e-06_r8,1.6996e-06_r8,1.7388e-06_r8,1.7611e-06_r8,1.8115e-06_r8/)
      kbo(:,50, 1) = (/ &
     &1.2781e-06_r8,1.3328e-06_r8,1.3698e-06_r8,1.3938e-06_r8,1.4265e-06_r8/)
      kbo(:,51, 1) = (/ &
     &1.0076e-06_r8,1.0460e-06_r8,1.0807e-06_r8,1.1011e-06_r8,1.1257e-06_r8/)
      kbo(:,52, 1) = (/ &
     &7.9394e-07_r8,8.1840e-07_r8,8.4881e-07_r8,8.6654e-07_r8,8.8734e-07_r8/)
      kbo(:,53, 1) = (/ &
     &6.1785e-07_r8,6.3992e-07_r8,6.6144e-07_r8,6.7843e-07_r8,6.9618e-07_r8/)
      kbo(:,54, 1) = (/ &
     &4.8490e-07_r8,5.0506e-07_r8,5.1952e-07_r8,5.3413e-07_r8,5.4905e-07_r8/)
      kbo(:,55, 1) = (/ &
     &3.8198e-07_r8,3.9926e-07_r8,4.1207e-07_r8,4.2268e-07_r8,4.3489e-07_r8/)
      kbo(:,56, 1) = (/ &
     &3.0062e-07_r8,3.1357e-07_r8,3.2461e-07_r8,3.3313e-07_r8,3.4390e-07_r8/)
      kbo(:,57, 1) = (/ &
     &2.3579e-07_r8,2.4608e-07_r8,2.5500e-07_r8,2.6288e-07_r8,2.7145e-07_r8/)
      kbo(:,58, 1) = (/ &
     &1.8530e-07_r8,1.9293e-07_r8,2.0021e-07_r8,2.0804e-07_r8,2.1510e-07_r8/)
      kbo(:,59, 1) = (/ &
     &1.4951e-07_r8,1.5512e-07_r8,1.6259e-07_r8,1.6844e-07_r8,1.7451e-07_r8/)
      kbo(:,13, 2) = (/ &
     &2.8194e-03_r8,3.0121e-03_r8,3.1846e-03_r8,3.3490e-03_r8,3.5100e-03_r8/)
      kbo(:,14, 2) = (/ &
     &2.4827e-03_r8,2.6492e-03_r8,2.7938e-03_r8,2.9346e-03_r8,3.0538e-03_r8/)
      kbo(:,15, 2) = (/ &
     &2.2064e-03_r8,2.3375e-03_r8,2.4556e-03_r8,2.5697e-03_r8,2.6626e-03_r8/)
      kbo(:,16, 2) = (/ &
     &1.9378e-03_r8,2.0444e-03_r8,2.1458e-03_r8,2.2321e-03_r8,2.3069e-03_r8/)
      kbo(:,17, 2) = (/ &
     &1.7072e-03_r8,1.7953e-03_r8,1.8810e-03_r8,1.9513e-03_r8,2.0122e-03_r8/)
      kbo(:,18, 2) = (/ &
     &1.5182e-03_r8,1.5881e-03_r8,1.6604e-03_r8,1.7175e-03_r8,1.7691e-03_r8/)
      kbo(:,19, 2) = (/ &
     &1.3604e-03_r8,1.4237e-03_r8,1.4711e-03_r8,1.5216e-03_r8,1.5631e-03_r8/)
      kbo(:,20, 2) = (/ &
     &1.1858e-03_r8,1.2290e-03_r8,1.2712e-03_r8,1.3090e-03_r8,1.3421e-03_r8/)
      kbo(:,21, 2) = (/ &
     &1.0189e-03_r8,1.0547e-03_r8,1.0885e-03_r8,1.1186e-03_r8,1.1432e-03_r8/)
      kbo(:,22, 2) = (/ &
     &8.7055e-04_r8,9.0481e-04_r8,9.2821e-04_r8,9.5252e-04_r8,9.7075e-04_r8/)
      kbo(:,23, 2) = (/ &
     &7.4675e-04_r8,7.7099e-04_r8,7.9133e-04_r8,8.0933e-04_r8,8.2551e-04_r8/)
      kbo(:,24, 2) = (/ &
     &6.4034e-04_r8,6.5905e-04_r8,6.7517e-04_r8,6.8951e-04_r8,7.0349e-04_r8/)
      kbo(:,25, 2) = (/ &
     &5.4635e-04_r8,5.6117e-04_r8,5.7460e-04_r8,5.8668e-04_r8,5.9880e-04_r8/)
      kbo(:,26, 2) = (/ &
     &4.6328e-04_r8,4.7565e-04_r8,4.8724e-04_r8,4.9802e-04_r8,5.0785e-04_r8/)
      kbo(:,27, 2) = (/ &
     &3.9145e-04_r8,4.0138e-04_r8,4.1206e-04_r8,4.2067e-04_r8,4.2970e-04_r8/)
      kbo(:,28, 2) = (/ &
     &3.2965e-04_r8,3.3905e-04_r8,3.4755e-04_r8,3.5536e-04_r8,3.6345e-04_r8/)
      kbo(:,29, 2) = (/ &
     &2.7722e-04_r8,2.8535e-04_r8,2.9237e-04_r8,2.9947e-04_r8,3.0668e-04_r8/)
      kbo(:,30, 2) = (/ &
     &2.3378e-04_r8,2.4040e-04_r8,2.4667e-04_r8,2.5278e-04_r8,2.6270e-04_r8/)
      kbo(:,31, 2) = (/ &
     &1.9661e-04_r8,2.0207e-04_r8,2.0803e-04_r8,2.1348e-04_r8,2.2186e-04_r8/)
      kbo(:,32, 2) = (/ &
     &1.6562e-04_r8,1.7146e-04_r8,1.7695e-04_r8,1.8193e-04_r8,1.8929e-04_r8/)
      kbo(:,33, 2) = (/ &
     &1.4107e-04_r8,1.4666e-04_r8,1.5183e-04_r8,1.5594e-04_r8,1.6243e-04_r8/)
      kbo(:,34, 2) = (/ &
     &1.2158e-04_r8,1.2598e-04_r8,1.3011e-04_r8,1.3588e-04_r8,1.4023e-04_r8/)
      kbo(:,35, 2) = (/ &
     &1.0453e-04_r8,1.0824e-04_r8,1.1246e-04_r8,1.1806e-04_r8,1.2280e-04_r8/)
      kbo(:,36, 2) = (/ &
     &9.0281e-05_r8,9.3775e-05_r8,9.7901e-05_r8,1.0364e-04_r8,1.0744e-04_r8/)
      kbo(:,37, 2) = (/ &
     &7.5786e-05_r8,7.8742e-05_r8,8.2503e-05_r8,8.7040e-05_r8,8.9489e-05_r8/)
      kbo(:,38, 2) = (/ &
     &6.3149e-05_r8,6.6113e-05_r8,6.8833e-05_r8,7.2371e-05_r8,7.4496e-05_r8/)
      kbo(:,39, 2) = (/ &
     &5.2982e-05_r8,5.5381e-05_r8,5.7239e-05_r8,5.9241e-05_r8,6.1954e-05_r8/)
      kbo(:,40, 2) = (/ &
     &4.3111e-05_r8,4.5156e-05_r8,4.6617e-05_r8,4.8324e-05_r8,5.0544e-05_r8/)
      kbo(:,41, 2) = (/ &
     &3.4957e-05_r8,3.6661e-05_r8,3.7913e-05_r8,3.9243e-05_r8,4.1170e-05_r8/)
      kbo(:,42, 2) = (/ &
     &2.8335e-05_r8,2.9735e-05_r8,3.0788e-05_r8,3.1864e-05_r8,3.3563e-05_r8/)
      kbo(:,43, 2) = (/ &
     &2.2801e-05_r8,2.3962e-05_r8,2.4808e-05_r8,2.5685e-05_r8,2.6685e-05_r8/)
      kbo(:,44, 2) = (/ &
     &1.8216e-05_r8,1.9207e-05_r8,1.9940e-05_r8,2.0623e-05_r8,2.1468e-05_r8/)
      kbo(:,45, 2) = (/ &
     &1.4497e-05_r8,1.5369e-05_r8,1.6010e-05_r8,1.6560e-05_r8,1.7214e-05_r8/)
      kbo(:,46, 2) = (/ &
     &1.1546e-05_r8,1.2283e-05_r8,1.2829e-05_r8,1.3281e-05_r8,1.3789e-05_r8/)
      kbo(:,47, 2) = (/ &
     &9.1407e-06_r8,9.7102e-06_r8,1.0256e-05_r8,1.0642e-05_r8,1.1044e-05_r8/)
      kbo(:,48, 2) = (/ &
     &7.2582e-06_r8,7.7178e-06_r8,8.1771e-06_r8,8.5159e-06_r8,8.8287e-06_r8/)
      kbo(:,49, 2) = (/ &
     &5.7413e-06_r8,6.0895e-06_r8,6.4724e-06_r8,6.7948e-06_r8,7.0423e-06_r8/)
      kbo(:,50, 2) = (/ &
     &4.5645e-06_r8,4.8219e-06_r8,5.1398e-06_r8,5.4019e-06_r8,5.6251e-06_r8/)
      kbo(:,51, 2) = (/ &
     &3.6347e-06_r8,3.8345e-06_r8,4.0925e-06_r8,4.2999e-06_r8,4.4976e-06_r8/)
      kbo(:,52, 2) = (/ &
     &2.8914e-06_r8,3.0394e-06_r8,3.2506e-06_r8,3.4210e-06_r8,3.5835e-06_r8/)
      kbo(:,53, 2) = (/ &
     &2.2827e-06_r8,2.4183e-06_r8,2.5753e-06_r8,2.7165e-06_r8,2.8435e-06_r8/)
      kbo(:,54, 2) = (/ &
     &1.8109e-06_r8,1.9319e-06_r8,2.0517e-06_r8,2.1771e-06_r8,2.2825e-06_r8/)
      kbo(:,55, 2) = (/ &
     &1.4459e-06_r8,1.5442e-06_r8,1.6423e-06_r8,1.7466e-06_r8,1.8412e-06_r8/)
      kbo(:,56, 2) = (/ &
     &1.1487e-06_r8,1.2318e-06_r8,1.3168e-06_r8,1.4029e-06_r8,1.4853e-06_r8/)
      kbo(:,57, 2) = (/ &
     &9.1432e-07_r8,9.8206e-07_r8,1.0551e-06_r8,1.1262e-06_r8,1.1922e-06_r8/)
      kbo(:,58, 2) = (/ &
     &7.2392e-07_r8,7.8435e-07_r8,8.4467e-07_r8,9.0516e-07_r8,9.5596e-07_r8/)
      kbo(:,59, 2) = (/ &
     &5.9300e-07_r8,6.4245e-07_r8,6.9378e-07_r8,7.4259e-07_r8,7.8676e-07_r8/)
      kbo(:,13, 3) = (/ &
     &8.5247e-03_r8,8.9273e-03_r8,9.3494e-03_r8,9.7833e-03_r8,1.0198e-02_r8/)
      kbo(:,14, 3) = (/ &
     &7.6220e-03_r8,7.9465e-03_r8,8.3037e-03_r8,8.6680e-03_r8,9.0184e-03_r8/)
      kbo(:,15, 3) = (/ &
     &6.7313e-03_r8,7.0250e-03_r8,7.3390e-03_r8,7.6496e-03_r8,7.9523e-03_r8/)
      kbo(:,16, 3) = (/ &
     &5.8626e-03_r8,6.1324e-03_r8,6.4081e-03_r8,6.6680e-03_r8,6.9239e-03_r8/)
      kbo(:,17, 3) = (/ &
     &5.1190e-03_r8,5.3847e-03_r8,5.6114e-03_r8,5.8394e-03_r8,6.0319e-03_r8/)
      kbo(:,18, 3) = (/ &
     &4.4937e-03_r8,4.7329e-03_r8,4.9304e-03_r8,5.1178e-03_r8,5.2582e-03_r8/)
      kbo(:,19, 3) = (/ &
     &3.9714e-03_r8,4.1523e-03_r8,4.3393e-03_r8,4.4847e-03_r8,4.6081e-03_r8/)
      kbo(:,20, 3) = (/ &
     &3.4227e-03_r8,3.5888e-03_r8,3.7323e-03_r8,3.8457e-03_r8,3.9571e-03_r8/)
      kbo(:,21, 3) = (/ &
     &2.9355e-03_r8,3.0688e-03_r8,3.1813e-03_r8,3.2800e-03_r8,3.3665e-03_r8/)
      kbo(:,22, 3) = (/ &
     &2.5131e-03_r8,2.6136e-03_r8,2.7075e-03_r8,2.7888e-03_r8,2.8576e-03_r8/)
      kbo(:,23, 3) = (/ &
     &2.1439e-03_r8,2.2229e-03_r8,2.3069e-03_r8,2.3691e-03_r8,2.4314e-03_r8/)
      kbo(:,24, 3) = (/ &
     &1.8279e-03_r8,1.8995e-03_r8,1.9649e-03_r8,2.0190e-03_r8,2.0668e-03_r8/)
      kbo(:,25, 3) = (/ &
     &1.5582e-03_r8,1.6177e-03_r8,1.6674e-03_r8,1.7146e-03_r8,1.7550e-03_r8/)
      kbo(:,26, 3) = (/ &
     &1.3272e-03_r8,1.3717e-03_r8,1.4140e-03_r8,1.4536e-03_r8,1.4858e-03_r8/)
      kbo(:,27, 3) = (/ &
     &1.1230e-03_r8,1.1594e-03_r8,1.1953e-03_r8,1.2264e-03_r8,1.2540e-03_r8/)
      kbo(:,28, 3) = (/ &
     &9.4753e-04_r8,9.7763e-04_r8,1.0074e-03_r8,1.0308e-03_r8,1.0536e-03_r8/)
      kbo(:,29, 3) = (/ &
     &7.9502e-04_r8,8.1974e-04_r8,8.4372e-04_r8,8.6478e-04_r8,8.8308e-04_r8/)
      kbo(:,30, 3) = (/ &
     &6.6596e-04_r8,6.8697e-04_r8,7.0803e-04_r8,7.2439e-04_r8,7.5784e-04_r8/)
      kbo(:,31, 3) = (/ &
     &5.5745e-04_r8,5.7516e-04_r8,5.9220e-04_r8,6.0512e-04_r8,6.3289e-04_r8/)
      kbo(:,32, 3) = (/ &
     &4.6662e-04_r8,4.8150e-04_r8,4.9505e-04_r8,5.0361e-04_r8,5.2756e-04_r8/)
      kbo(:,33, 3) = (/ &
     &3.9094e-04_r8,4.0255e-04_r8,4.1211e-04_r8,4.1938e-04_r8,4.4050e-04_r8/)
      kbo(:,34, 3) = (/ &
     &3.2769e-04_r8,3.3699e-04_r8,3.4471e-04_r8,3.6275e-04_r8,3.6949e-04_r8/)
      kbo(:,35, 3) = (/ &
     &2.7475e-04_r8,2.8204e-04_r8,2.8828e-04_r8,3.0332e-04_r8,3.0836e-04_r8/)
      kbo(:,36, 3) = (/ &
     &2.2983e-04_r8,2.3568e-04_r8,2.4113e-04_r8,2.5319e-04_r8,2.5736e-04_r8/)
      kbo(:,37, 3) = (/ &
     &1.8895e-04_r8,1.9397e-04_r8,1.9807e-04_r8,2.0882e-04_r8,2.1275e-04_r8/)
      kbo(:,38, 3) = (/ &
     &1.5549e-04_r8,1.5951e-04_r8,1.6323e-04_r8,1.7252e-04_r8,1.7561e-04_r8/)
      kbo(:,39, 3) = (/ &
     &1.2765e-04_r8,1.3102e-04_r8,1.3443e-04_r8,1.3776e-04_r8,1.4478e-04_r8/)
      kbo(:,40, 3) = (/ &
     &1.0414e-04_r8,1.0697e-04_r8,1.0972e-04_r8,1.1251e-04_r8,1.1839e-04_r8/)
      kbo(:,41, 3) = (/ &
     &8.4861e-05_r8,8.7037e-05_r8,8.9345e-05_r8,9.1552e-05_r8,9.6450e-05_r8/)
      kbo(:,42, 3) = (/ &
     &6.9029e-05_r8,7.0620e-05_r8,7.2608e-05_r8,7.4362e-05_r8,7.8451e-05_r8/)
      kbo(:,43, 3) = (/ &
     &5.5731e-05_r8,5.6934e-05_r8,5.8627e-05_r8,6.0036e-05_r8,6.1419e-05_r8/)
      kbo(:,44, 3) = (/ &
     &4.4750e-05_r8,4.5795e-05_r8,4.7066e-05_r8,4.8320e-05_r8,4.9340e-05_r8/)
      kbo(:,45, 3) = (/ &
     &3.5902e-05_r8,3.6793e-05_r8,3.7710e-05_r8,3.8772e-05_r8,3.9634e-05_r8/)
      kbo(:,46, 3) = (/ &
     &2.8669e-05_r8,2.9406e-05_r8,3.0158e-05_r8,3.1055e-05_r8,3.1783e-05_r8/)
      kbo(:,47, 3) = (/ &
     &2.2957e-05_r8,2.3586e-05_r8,2.4179e-05_r8,2.4875e-05_r8,2.5463e-05_r8/)
      kbo(:,48, 3) = (/ &
     &1.8322e-05_r8,1.8764e-05_r8,1.9281e-05_r8,1.9846e-05_r8,2.0330e-05_r8/)
      kbo(:,49, 3) = (/ &
     &1.4581e-05_r8,1.4948e-05_r8,1.5326e-05_r8,1.5796e-05_r8,1.6188e-05_r8/)
      kbo(:,50, 3) = (/ &
     &1.1658e-05_r8,1.1996e-05_r8,1.2253e-05_r8,1.2626e-05_r8,1.2988e-05_r8/)
      kbo(:,51, 3) = (/ &
     &9.3098e-06_r8,9.6196e-06_r8,9.8320e-06_r8,1.0134e-05_r8,1.0431e-05_r8/)
      kbo(:,52, 3) = (/ &
     &7.3883e-06_r8,7.7108e-06_r8,7.8752e-06_r8,8.1035e-06_r8,8.3459e-06_r8/)
      kbo(:,53, 3) = (/ &
     &5.8592e-06_r8,6.1249e-06_r8,6.2920e-06_r8,6.4688e-06_r8,6.6480e-06_r8/)
      kbo(:,54, 3) = (/ &
     &4.7059e-06_r8,4.9088e-06_r8,5.0922e-06_r8,5.2219e-06_r8,5.3713e-06_r8/)
      kbo(:,55, 3) = (/ &
     &3.7899e-06_r8,3.9660e-06_r8,4.1365e-06_r8,4.2472e-06_r8,4.3644e-06_r8/)
      kbo(:,56, 3) = (/ &
     &3.0554e-06_r8,3.2100e-06_r8,3.3483e-06_r8,3.4494e-06_r8,3.5457e-06_r8/)
      kbo(:,57, 3) = (/ &
     &2.4489e-06_r8,2.5923e-06_r8,2.7014e-06_r8,2.7985e-06_r8,2.8823e-06_r8/)
      kbo(:,58, 3) = (/ &
     &1.9694e-06_r8,2.0948e-06_r8,2.1872e-06_r8,2.2740e-06_r8,2.3512e-06_r8/)
      kbo(:,59, 3) = (/ &
     &1.6303e-06_r8,1.7449e-06_r8,1.8268e-06_r8,1.9070e-06_r8,1.9708e-06_r8/)
      kbo(:,13, 4) = (/ &
     &1.8047e-02_r8,1.8718e-02_r8,1.9333e-02_r8,1.9945e-02_r8,2.0619e-02_r8/)
      kbo(:,14, 4) = (/ &
     &1.6432e-02_r8,1.7100e-02_r8,1.7741e-02_r8,1.8401e-02_r8,1.9089e-02_r8/)
      kbo(:,15, 4) = (/ &
     &1.4807e-02_r8,1.5451e-02_r8,1.6100e-02_r8,1.6750e-02_r8,1.7413e-02_r8/)
      kbo(:,16, 4) = (/ &
     &1.3139e-02_r8,1.3704e-02_r8,1.4262e-02_r8,1.4904e-02_r8,1.5552e-02_r8/)
      kbo(:,17, 4) = (/ &
     &1.1663e-02_r8,1.2130e-02_r8,1.2669e-02_r8,1.3218e-02_r8,1.3830e-02_r8/)
      kbo(:,18, 4) = (/ &
     &1.0329e-02_r8,1.0751e-02_r8,1.1271e-02_r8,1.1798e-02_r8,1.2374e-02_r8/)
      kbo(:,19, 4) = (/ &
     &9.2112e-03_r8,9.6353e-03_r8,1.0130e-02_r8,1.0649e-02_r8,1.1157e-02_r8/)
      kbo(:,20, 4) = (/ &
     &8.0574e-03_r8,8.4807e-03_r8,8.9054e-03_r8,9.3587e-03_r8,9.7992e-03_r8/)
      kbo(:,21, 4) = (/ &
     &7.0019e-03_r8,7.3853e-03_r8,7.7827e-03_r8,8.1758e-03_r8,8.5421e-03_r8/)
      kbo(:,22, 4) = (/ &
     &6.0893e-03_r8,6.4266e-03_r8,6.7752e-03_r8,7.1040e-03_r8,7.4095e-03_r8/)
      kbo(:,23, 4) = (/ &
     &5.2966e-03_r8,5.5992e-03_r8,5.8988e-03_r8,6.1748e-03_r8,6.4166e-03_r8/)
      kbo(:,24, 4) = (/ &
     &4.6174e-03_r8,4.8835e-03_r8,5.1353e-03_r8,5.3661e-03_r8,5.5632e-03_r8/)
      kbo(:,25, 4) = (/ &
     &4.0173e-03_r8,4.2433e-03_r8,4.4670e-03_r8,4.6521e-03_r8,4.8258e-03_r8/)
      kbo(:,26, 4) = (/ &
     &3.4865e-03_r8,3.6826e-03_r8,3.8670e-03_r8,4.0200e-03_r8,4.1614e-03_r8/)
      kbo(:,27, 4) = (/ &
     &3.0102e-03_r8,3.1785e-03_r8,3.3303e-03_r8,3.4548e-03_r8,3.5736e-03_r8/)
      kbo(:,28, 4) = (/ &
     &2.5902e-03_r8,2.7336e-03_r8,2.8553e-03_r8,2.9588e-03_r8,3.0603e-03_r8/)
      kbo(:,29, 4) = (/ &
     &2.2148e-03_r8,2.3314e-03_r8,2.4216e-03_r8,2.5098e-03_r8,2.5968e-03_r8/)
      kbo(:,30, 4) = (/ &
     &1.8884e-03_r8,1.9733e-03_r8,2.0479e-03_r8,2.1223e-03_r8,2.2826e-03_r8/)
      kbo(:,31, 4) = (/ &
     &1.5995e-03_r8,1.6617e-03_r8,1.7230e-03_r8,1.7883e-03_r8,1.9307e-03_r8/)
      kbo(:,32, 4) = (/ &
     &1.3496e-03_r8,1.3999e-03_r8,1.4538e-03_r8,1.5096e-03_r8,1.6319e-03_r8/)
      kbo(:,33, 4) = (/ &
     &1.1363e-03_r8,1.1813e-03_r8,1.2287e-03_r8,1.2753e-03_r8,1.3874e-03_r8/)
      kbo(:,34, 4) = (/ &
     &9.6663e-04_r8,1.0050e-03_r8,1.0440e-03_r8,1.1401e-03_r8,1.1914e-03_r8/)
      kbo(:,35, 4) = (/ &
     &8.2252e-04_r8,8.5291e-04_r8,8.9255e-04_r8,9.7906e-04_r8,1.0213e-03_r8/)
      kbo(:,36, 4) = (/ &
     &6.9843e-04_r8,7.2671e-04_r8,7.6052e-04_r8,8.3992e-04_r8,8.7893e-04_r8/)
      kbo(:,37, 4) = (/ &
     &5.7973e-04_r8,6.0624e-04_r8,6.3703e-04_r8,7.0532e-04_r8,7.4046e-04_r8/)
      kbo(:,38, 4) = (/ &
     &4.8124e-04_r8,5.0463e-04_r8,5.3059e-04_r8,5.8984e-04_r8,6.2161e-04_r8/)
      kbo(:,39, 4) = (/ &
     &3.9797e-04_r8,4.2007e-04_r8,4.4141e-04_r8,4.6508e-04_r8,5.2126e-04_r8/)
      kbo(:,40, 4) = (/ &
     &3.2587e-04_r8,3.4475e-04_r8,3.6264e-04_r8,3.8270e-04_r8,4.3106e-04_r8/)
      kbo(:,41, 4) = (/ &
     &2.6592e-04_r8,2.8134e-04_r8,2.9669e-04_r8,3.1406e-04_r8,3.5481e-04_r8/)
      kbo(:,42, 4) = (/ &
     &2.1654e-04_r8,2.2933e-04_r8,2.4233e-04_r8,2.5702e-04_r8,2.9186e-04_r8/)
      kbo(:,43, 4) = (/ &
     &1.7468e-04_r8,1.8487e-04_r8,1.9562e-04_r8,2.0857e-04_r8,2.2203e-04_r8/)
      kbo(:,44, 4) = (/ &
     &1.3990e-04_r8,1.4813e-04_r8,1.5725e-04_r8,1.6786e-04_r8,1.7935e-04_r8/)
      kbo(:,45, 4) = (/ &
     &1.1147e-04_r8,1.1816e-04_r8,1.2590e-04_r8,1.3456e-04_r8,1.4433e-04_r8/)
      kbo(:,46, 4) = (/ &
     &8.8593e-05_r8,9.4029e-05_r8,1.0037e-04_r8,1.0744e-04_r8,1.1598e-04_r8/)
      kbo(:,47, 4) = (/ &
     &7.0072e-05_r8,7.4712e-05_r8,7.9919e-05_r8,8.5900e-05_r8,9.3033e-05_r8/)
      kbo(:,48, 4) = (/ &
     &5.5180e-05_r8,5.9132e-05_r8,6.3502e-05_r8,6.8198e-05_r8,7.4266e-05_r8/)
      kbo(:,49, 4) = (/ &
     &4.3109e-05_r8,4.6388e-05_r8,5.0075e-05_r8,5.3912e-05_r8,5.8896e-05_r8/)
      kbo(:,50, 4) = (/ &
     &3.4049e-05_r8,3.6756e-05_r8,3.9830e-05_r8,4.3128e-05_r8,4.7184e-05_r8/)
      kbo(:,51, 4) = (/ &
     &2.7005e-05_r8,2.9148e-05_r8,3.1674e-05_r8,3.4539e-05_r8,3.7748e-05_r8/)
      kbo(:,52, 4) = (/ &
     &2.1299e-05_r8,2.3058e-05_r8,2.5114e-05_r8,2.7488e-05_r8,3.0113e-05_r8/)
      kbo(:,53, 4) = (/ &
     &1.6705e-05_r8,1.8140e-05_r8,1.9875e-05_r8,2.1784e-05_r8,2.3982e-05_r8/)
      kbo(:,54, 4) = (/ &
     &1.3350e-05_r8,1.4560e-05_r8,1.5930e-05_r8,1.7502e-05_r8,1.9341e-05_r8/)
      kbo(:,55, 4) = (/ &
     &1.0773e-05_r8,1.1749e-05_r8,1.2886e-05_r8,1.4153e-05_r8,1.5702e-05_r8/)
      kbo(:,56, 4) = (/ &
     &8.6460e-06_r8,9.4510e-06_r8,1.0398e-05_r8,1.1452e-05_r8,1.2706e-05_r8/)
      kbo(:,57, 4) = (/ &
     &6.9096e-06_r8,7.6015e-06_r8,8.3864e-06_r8,9.2473e-06_r8,1.0265e-05_r8/)
      kbo(:,58, 4) = (/ &
     &5.5254e-06_r8,6.1387e-06_r8,6.7789e-06_r8,7.4818e-06_r8,8.3075e-06_r8/)
      kbo(:,59, 4) = (/ &
     &4.6551e-06_r8,5.1865e-06_r8,5.7401e-06_r8,6.3194e-06_r8,7.0521e-06_r8/)
      kbo(:,13, 5) = (/ &
     &3.4718e-02_r8,3.5594e-02_r8,3.6803e-02_r8,3.8083e-02_r8,3.9520e-02_r8/)
      kbo(:,14, 5) = (/ &
     &3.2238e-02_r8,3.3220e-02_r8,3.4363e-02_r8,3.5532e-02_r8,3.6904e-02_r8/)
      kbo(:,15, 5) = (/ &
     &3.0600e-02_r8,3.1610e-02_r8,3.2771e-02_r8,3.3966e-02_r8,3.5285e-02_r8/)
      kbo(:,16, 5) = (/ &
     &2.8159e-02_r8,2.9168e-02_r8,3.0264e-02_r8,3.1396e-02_r8,3.2647e-02_r8/)
      kbo(:,17, 5) = (/ &
     &2.5788e-02_r8,2.6724e-02_r8,2.7768e-02_r8,2.8866e-02_r8,3.0013e-02_r8/)
      kbo(:,18, 5) = (/ &
     &2.3487e-02_r8,2.4520e-02_r8,2.5499e-02_r8,2.6557e-02_r8,2.7740e-02_r8/)
      kbo(:,19, 5) = (/ &
     &2.1508e-02_r8,2.2551e-02_r8,2.3562e-02_r8,2.4611e-02_r8,2.5770e-02_r8/)
      kbo(:,20, 5) = (/ &
     &1.9153e-02_r8,2.0099e-02_r8,2.1123e-02_r8,2.2234e-02_r8,2.3370e-02_r8/)
      kbo(:,21, 5) = (/ &
     &1.6910e-02_r8,1.7820e-02_r8,1.8821e-02_r8,1.9939e-02_r8,2.1019e-02_r8/)
      kbo(:,22, 5) = (/ &
     &1.4892e-02_r8,1.5824e-02_r8,1.6836e-02_r8,1.7897e-02_r8,1.8973e-02_r8/)
      kbo(:,23, 5) = (/ &
     &1.3201e-02_r8,1.4110e-02_r8,1.5066e-02_r8,1.6122e-02_r8,1.7163e-02_r8/)
      kbo(:,24, 5) = (/ &
     &1.1786e-02_r8,1.2643e-02_r8,1.3592e-02_r8,1.4574e-02_r8,1.5604e-02_r8/)
      kbo(:,25, 5) = (/ &
     &1.0551e-02_r8,1.1376e-02_r8,1.2278e-02_r8,1.3228e-02_r8,1.4135e-02_r8/)
      kbo(:,26, 5) = (/ &
     &9.4341e-03_r8,1.0259e-02_r8,1.1075e-02_r8,1.1949e-02_r8,1.2760e-02_r8/)
      kbo(:,27, 5) = (/ &
     &8.4286e-03_r8,9.1773e-03_r8,9.9233e-03_r8,1.0676e-02_r8,1.1418e-02_r8/)
      kbo(:,28, 5) = (/ &
     &7.5098e-03_r8,8.1852e-03_r8,8.8662e-03_r8,9.5190e-03_r8,1.0161e-02_r8/)
      kbo(:,29, 5) = (/ &
     &6.6339e-03_r8,7.2146e-03_r8,7.8111e-03_r8,8.3875e-03_r8,8.9339e-03_r8/)
      kbo(:,30, 5) = (/ &
     &5.8318e-03_r8,6.3504e-03_r8,6.8644e-03_r8,7.3656e-03_r8,8.2854e-03_r8/)
      kbo(:,31, 5) = (/ &
     &5.0938e-03_r8,5.5450e-03_r8,5.9883e-03_r8,6.4048e-03_r8,7.2251e-03_r8/)
      kbo(:,32, 5) = (/ &
     &4.4534e-03_r8,4.8436e-03_r8,5.2343e-03_r8,5.5836e-03_r8,6.3649e-03_r8/)
      kbo(:,33, 5) = (/ &
     &3.8952e-03_r8,4.2551e-03_r8,4.5701e-03_r8,4.9101e-03_r8,5.6667e-03_r8/)
      kbo(:,34, 5) = (/ &
     &3.4434e-03_r8,3.7546e-03_r8,4.0585e-03_r8,4.7206e-03_r8,5.1136e-03_r8/)
      kbo(:,35, 5) = (/ &
     &3.0323e-03_r8,3.3194e-03_r8,3.6005e-03_r8,4.2419e-03_r8,4.6276e-03_r8/)
      kbo(:,36, 5) = (/ &
     &2.6713e-03_r8,2.9283e-03_r8,3.2072e-03_r8,3.8119e-03_r8,4.2091e-03_r8/)
      kbo(:,37, 5) = (/ &
     &2.2748e-03_r8,2.5138e-03_r8,2.7697e-03_r8,3.3361e-03_r8,3.7192e-03_r8/)
      kbo(:,38, 5) = (/ &
     &1.9294e-03_r8,2.1456e-03_r8,2.3858e-03_r8,2.9205e-03_r8,3.2883e-03_r8/)
      kbo(:,39, 5) = (/ &
     &1.6394e-03_r8,1.8308e-03_r8,2.0616e-03_r8,2.3311e-03_r8,2.9179e-03_r8/)
      kbo(:,40, 5) = (/ &
     &1.3611e-03_r8,1.5347e-03_r8,1.7447e-03_r8,1.9909e-03_r8,2.5336e-03_r8/)
      kbo(:,41, 5) = (/ &
     &1.1258e-03_r8,1.2811e-03_r8,1.4710e-03_r8,1.6948e-03_r8,2.1957e-03_r8/)
      kbo(:,42, 5) = (/ &
     &9.3054e-04_r8,1.0685e-03_r8,1.2380e-03_r8,1.4417e-03_r8,1.8992e-03_r8/)
      kbo(:,43, 5) = (/ &
     &7.5595e-04_r8,8.7758e-04_r8,1.0267e-03_r8,1.2093e-03_r8,1.4383e-03_r8/)
      kbo(:,44, 5) = (/ &
     &6.0708e-04_r8,7.1329e-04_r8,8.4285e-04_r8,1.0050e-03_r8,1.2098e-03_r8/)
      kbo(:,45, 5) = (/ &
     &4.8565e-04_r8,5.7704e-04_r8,6.8980e-04_r8,8.3254e-04_r8,1.0112e-03_r8/)
      kbo(:,46, 5) = (/ &
     &3.8568e-04_r8,4.6292e-04_r8,5.6071e-04_r8,6.8523e-04_r8,8.4055e-04_r8/)
      kbo(:,47, 5) = (/ &
     &3.0303e-04_r8,3.6775e-04_r8,4.5081e-04_r8,5.5621e-04_r8,6.9040e-04_r8/)
      kbo(:,48, 5) = (/ &
     &2.3629e-04_r8,2.9047e-04_r8,3.6009e-04_r8,4.4971e-04_r8,5.6449e-04_r8/)
      kbo(:,49, 5) = (/ &
     &1.8277e-04_r8,2.2768e-04_r8,2.8500e-04_r8,3.5988e-04_r8,4.5780e-04_r8/)
      kbo(:,50, 5) = (/ &
     &1.4236e-04_r8,1.7948e-04_r8,2.2683e-04_r8,2.8959e-04_r8,3.7278e-04_r8/)
      kbo(:,51, 5) = (/ &
     &1.1105e-04_r8,1.4188e-04_r8,1.8087e-04_r8,2.3323e-04_r8,3.0421e-04_r8/)
      kbo(:,52, 5) = (/ &
     &8.5949e-05_r8,1.1090e-04_r8,1.4310e-04_r8,1.8669e-04_r8,2.4668e-04_r8/)
      kbo(:,53, 5) = (/ &
     &6.6010e-05_r8,8.6189e-05_r8,1.1254e-04_r8,1.4823e-04_r8,1.9832e-04_r8/)
      kbo(:,54, 5) = (/ &
     &5.1508e-05_r8,6.7802e-05_r8,8.9425e-05_r8,1.1908e-04_r8,1.6117e-04_r8/)
      kbo(:,55, 5) = (/ &
     &4.0450e-05_r8,5.3662e-05_r8,7.1436e-05_r8,9.6039e-05_r8,1.3135e-04_r8/)
      kbo(:,56, 5) = (/ &
     &3.1739e-05_r8,4.2180e-05_r8,5.6735e-05_r8,7.6991e-05_r8,1.0631e-04_r8/)
      kbo(:,57, 5) = (/ &
     &2.4823e-05_r8,3.2939e-05_r8,4.4784e-05_r8,6.1322e-05_r8,8.5682e-05_r8/)
      kbo(:,58, 5) = (/ &
     &1.9514e-05_r8,2.5849e-05_r8,3.5397e-05_r8,4.8867e-05_r8,6.9076e-05_r8/)
      kbo(:,59, 5) = (/ &
     &1.6536e-05_r8,2.1873e-05_r8,3.0188e-05_r8,4.2152e-05_r8,6.0090e-05_r8/)
      kbo(:,13, 6) = (/ &
     &7.0936e-02_r8,7.2599e-02_r8,7.4412e-02_r8,7.6631e-02_r8,7.9197e-02_r8/)
      kbo(:,14, 6) = (/ &
     &6.5108e-02_r8,6.6883e-02_r8,6.8861e-02_r8,7.1194e-02_r8,7.3890e-02_r8/)
      kbo(:,15, 6) = (/ &
     &6.1844e-02_r8,6.3875e-02_r8,6.5914e-02_r8,6.8440e-02_r8,7.1135e-02_r8/)
      kbo(:,16, 6) = (/ &
     &5.8757e-02_r8,6.1061e-02_r8,6.3588e-02_r8,6.6243e-02_r8,6.9218e-02_r8/)
      kbo(:,17, 6) = (/ &
     &5.6075e-02_r8,5.8373e-02_r8,6.0818e-02_r8,6.3696e-02_r8,6.6956e-02_r8/)
      kbo(:,18, 6) = (/ &
     &5.3195e-02_r8,5.5446e-02_r8,5.8088e-02_r8,6.0906e-02_r8,6.3907e-02_r8/)
      kbo(:,19, 6) = (/ &
     &5.0738e-02_r8,5.2979e-02_r8,5.5433e-02_r8,5.8280e-02_r8,6.1280e-02_r8/)
      kbo(:,20, 6) = (/ &
     &4.6694e-02_r8,4.8984e-02_r8,5.1371e-02_r8,5.4034e-02_r8,5.7035e-02_r8/)
      kbo(:,21, 6) = (/ &
     &4.2499e-02_r8,4.4760e-02_r8,4.7087e-02_r8,4.9709e-02_r8,5.2664e-02_r8/)
      kbo(:,22, 6) = (/ &
     &3.8535e-02_r8,4.0776e-02_r8,4.3118e-02_r8,4.5805e-02_r8,4.8711e-02_r8/)
      kbo(:,23, 6) = (/ &
     &3.4990e-02_r8,3.7200e-02_r8,3.9611e-02_r8,4.2290e-02_r8,4.5266e-02_r8/)
      kbo(:,24, 6) = (/ &
     &3.1926e-02_r8,3.4161e-02_r8,3.6618e-02_r8,3.9305e-02_r8,4.2288e-02_r8/)
      kbo(:,25, 6) = (/ &
     &2.9165e-02_r8,3.1418e-02_r8,3.3868e-02_r8,3.6528e-02_r8,3.9610e-02_r8/)
      kbo(:,26, 6) = (/ &
     &2.6632e-02_r8,2.8869e-02_r8,3.1334e-02_r8,3.4138e-02_r8,3.7332e-02_r8/)
      kbo(:,27, 6) = (/ &
     &2.4229e-02_r8,2.6481e-02_r8,2.9027e-02_r8,3.1970e-02_r8,3.5096e-02_r8/)
      kbo(:,28, 6) = (/ &
     &2.2118e-02_r8,2.4355e-02_r8,2.6986e-02_r8,2.9969e-02_r8,3.3170e-02_r8/)
      kbo(:,29, 6) = (/ &
     &2.0075e-02_r8,2.2435e-02_r8,2.5083e-02_r8,2.8074e-02_r8,3.1267e-02_r8/)
      kbo(:,30, 6) = (/ &
     &1.8356e-02_r8,2.0732e-02_r8,2.3448e-02_r8,2.6423e-02_r8,3.0839e-02_r8/)
      kbo(:,31, 6) = (/ &
     &1.6821e-02_r8,1.9252e-02_r8,2.1963e-02_r8,2.5007e-02_r8,2.9517e-02_r8/)
      kbo(:,32, 6) = (/ &
     &1.5646e-02_r8,1.8065e-02_r8,2.0807e-02_r8,2.3917e-02_r8,2.8359e-02_r8/)
      kbo(:,33, 6) = (/ &
     &1.4697e-02_r8,1.7147e-02_r8,1.9949e-02_r8,2.3040e-02_r8,2.7566e-02_r8/)
      kbo(:,34, 6) = (/ &
     &1.3988e-02_r8,1.6488e-02_r8,1.9318e-02_r8,2.3681e-02_r8,2.7159e-02_r8/)
      kbo(:,35, 6) = (/ &
     &1.3271e-02_r8,1.5781e-02_r8,1.8680e-02_r8,2.3148e-02_r8,2.6620e-02_r8/)
      kbo(:,36, 6) = (/ &
     &1.2443e-02_r8,1.5030e-02_r8,1.7973e-02_r8,2.2405e-02_r8,2.5873e-02_r8/)
      kbo(:,37, 6) = (/ &
     &1.1274e-02_r8,1.3767e-02_r8,1.6642e-02_r8,2.1024e-02_r8,2.4462e-02_r8/)
      kbo(:,38, 6) = (/ &
     &1.0206e-02_r8,1.2636e-02_r8,1.5395e-02_r8,1.9741e-02_r8,2.3148e-02_r8/)
      kbo(:,39, 6) = (/ &
     &9.2481e-03_r8,1.1600e-02_r8,1.4300e-02_r8,1.7327e-02_r8,2.1951e-02_r8/)
      kbo(:,40, 6) = (/ &
     &8.1267e-03_r8,1.0335e-02_r8,1.2898e-02_r8,1.5836e-02_r8,2.0384e-02_r8/)
      kbo(:,41, 6) = (/ &
     &7.0946e-03_r8,9.1506e-03_r8,1.1587e-02_r8,1.4430e-02_r8,1.8862e-02_r8/)
      kbo(:,42, 6) = (/ &
     &6.1743e-03_r8,8.0792e-03_r8,1.0417e-02_r8,1.3119e-02_r8,1.7424e-02_r8/)
      kbo(:,43, 6) = (/ &
     &5.2531e-03_r8,6.9901e-03_r8,9.1605e-03_r8,1.1697e-02_r8,1.4583e-02_r8/)
      kbo(:,44, 6) = (/ &
     &4.3985e-03_r8,5.9665e-03_r8,7.9494e-03_r8,1.0327e-02_r8,1.3038e-02_r8/)
      kbo(:,45, 6) = (/ &
     &3.6636e-03_r8,5.0581e-03_r8,6.8612e-03_r8,9.0504e-03_r8,1.1599e-02_r8/)
      kbo(:,46, 6) = (/ &
     &3.0066e-03_r8,4.2365e-03_r8,5.8498e-03_r8,7.8432e-03_r8,1.0214e-02_r8/)
      kbo(:,47, 6) = (/ &
     &2.4125e-03_r8,3.4783e-03_r8,4.8978e-03_r8,6.6863e-03_r8,8.8516e-03_r8/)
      kbo(:,48, 6) = (/ &
     &1.9141e-03_r8,2.8190e-03_r8,4.0533e-03_r8,5.6391e-03_r8,7.5940e-03_r8/)
      kbo(:,49, 6) = (/ &
     &1.4995e-03_r8,2.2582e-03_r8,3.3183e-03_r8,4.7078e-03_r8,6.4551e-03_r8/)
      kbo(:,50, 6) = (/ &
     &1.1787e-03_r8,1.8162e-03_r8,2.7290e-03_r8,3.9486e-03_r8,5.5105e-03_r8/)
      kbo(:,51, 6) = (/ &
     &9.2536e-04_r8,1.4546e-03_r8,2.2372e-03_r8,3.3051e-03_r8,4.6909e-03_r8/)
      kbo(:,52, 6) = (/ &
     &7.1718e-04_r8,1.1533e-03_r8,1.8133e-03_r8,2.7360e-03_r8,3.9584e-03_r8/)
      kbo(:,53, 6) = (/ &
     &5.4913e-04_r8,9.0136e-04_r8,1.4515e-03_r8,2.2390e-03_r8,3.3052e-03_r8/)
      kbo(:,54, 6) = (/ &
     &4.2639e-04_r8,7.1524e-04_r8,1.1781e-03_r8,1.8604e-03_r8,2.8043e-03_r8/)
      kbo(:,55, 6) = (/ &
     &3.3211e-04_r8,5.6986e-04_r8,9.6021e-04_r8,1.5541e-03_r8,2.3898e-03_r8/)
      kbo(:,56, 6) = (/ &
     &2.5572e-04_r8,4.4925e-04_r8,7.7580e-04_r8,1.2883e-03_r8,2.0250e-03_r8/)
      kbo(:,57, 6) = (/ &
     &1.9517e-04_r8,3.4994e-04_r8,6.2105e-04_r8,1.0576e-03_r8,1.7032e-03_r8/)
      kbo(:,58, 6) = (/ &
     &1.4935e-04_r8,2.7300e-04_r8,4.9776e-04_r8,8.6979e-04_r8,1.4384e-03_r8/)
      kbo(:,59, 6) = (/ &
     &1.2881e-04_r8,2.4100e-04_r8,4.4942e-04_r8,8.0211e-04_r8,1.3455e-03_r8/)
      kbo(:,13, 7) = (/ &
     &1.5834e-01_r8,1.6249e-01_r8,1.6718e-01_r8,1.7299e-01_r8,1.7881e-01_r8/)
      kbo(:,14, 7) = (/ &
     &1.4697e-01_r8,1.5136e-01_r8,1.5631e-01_r8,1.6088e-01_r8,1.6631e-01_r8/)
      kbo(:,15, 7) = (/ &
     &1.4037e-01_r8,1.4484e-01_r8,1.4966e-01_r8,1.5465e-01_r8,1.6040e-01_r8/)
      kbo(:,16, 7) = (/ &
     &1.3335e-01_r8,1.3799e-01_r8,1.4282e-01_r8,1.4817e-01_r8,1.5433e-01_r8/)
      kbo(:,17, 7) = (/ &
     &1.2994e-01_r8,1.3481e-01_r8,1.4043e-01_r8,1.4652e-01_r8,1.5312e-01_r8/)
      kbo(:,18, 7) = (/ &
     &1.2814e-01_r8,1.3395e-01_r8,1.4042e-01_r8,1.4789e-01_r8,1.5627e-01_r8/)
      kbo(:,19, 7) = (/ &
     &1.2710e-01_r8,1.3361e-01_r8,1.4139e-01_r8,1.4985e-01_r8,1.5917e-01_r8/)
      kbo(:,20, 7) = (/ &
     &1.2151e-01_r8,1.2844e-01_r8,1.3635e-01_r8,1.4526e-01_r8,1.5485e-01_r8/)
      kbo(:,21, 7) = (/ &
     &1.1463e-01_r8,1.2176e-01_r8,1.2980e-01_r8,1.3882e-01_r8,1.4834e-01_r8/)
      kbo(:,22, 7) = (/ &
     &1.0733e-01_r8,1.1471e-01_r8,1.2303e-01_r8,1.3189e-01_r8,1.4224e-01_r8/)
      kbo(:,23, 7) = (/ &
     &1.0056e-01_r8,1.0811e-01_r8,1.1675e-01_r8,1.2597e-01_r8,1.3621e-01_r8/)
      kbo(:,24, 7) = (/ &
     &9.4505e-02_r8,1.0259e-01_r8,1.1127e-01_r8,1.2075e-01_r8,1.3101e-01_r8/)
      kbo(:,25, 7) = (/ &
     &8.9426e-02_r8,9.7409e-02_r8,1.0620e-01_r8,1.1605e-01_r8,1.2683e-01_r8/)
      kbo(:,26, 7) = (/ &
     &8.4533e-02_r8,9.2442e-02_r8,1.0164e-01_r8,1.1173e-01_r8,1.2271e-01_r8/)
      kbo(:,27, 7) = (/ &
     &7.9749e-02_r8,8.8003e-02_r8,9.7311e-02_r8,1.0746e-01_r8,1.1871e-01_r8/)
      kbo(:,28, 7) = (/ &
     &7.5483e-02_r8,8.3936e-02_r8,9.3313e-02_r8,1.0378e-01_r8,1.1507e-01_r8/)
      kbo(:,29, 7) = (/ &
     &7.1103e-02_r8,7.9904e-02_r8,8.9739e-02_r8,1.0032e-01_r8,1.1148e-01_r8/)
      kbo(:,30, 7) = (/ &
     &6.7483e-02_r8,7.6590e-02_r8,8.6589e-02_r8,9.7210e-02_r8,1.1098e-01_r8/)
      kbo(:,31, 7) = (/ &
     &6.4404e-02_r8,7.3695e-02_r8,8.3853e-02_r8,9.4939e-02_r8,1.0916e-01_r8/)
      kbo(:,32, 7) = (/ &
     &6.2132e-02_r8,7.1593e-02_r8,8.2197e-02_r8,9.3726e-02_r8,1.0838e-01_r8/)
      kbo(:,33, 7) = (/ &
     &6.0812e-02_r8,7.0660e-02_r8,8.1722e-02_r8,9.3787e-02_r8,1.0875e-01_r8/)
      kbo(:,34, 7) = (/ &
     &6.0340e-02_r8,7.0788e-02_r8,8.2210e-02_r8,9.6618e-02_r8,1.0965e-01_r8/)
      kbo(:,35, 7) = (/ &
     &5.9655e-02_r8,7.0346e-02_r8,8.1926e-02_r8,9.6670e-02_r8,1.0999e-01_r8/)
      kbo(:,36, 7) = (/ &
     &5.8475e-02_r8,6.9222e-02_r8,8.1005e-02_r8,9.6061e-02_r8,1.0964e-01_r8/)
      kbo(:,37, 7) = (/ &
     &5.5330e-02_r8,6.5969e-02_r8,7.7716e-02_r8,9.2736e-02_r8,1.0626e-01_r8/)
      kbo(:,38, 7) = (/ &
     &5.2353e-02_r8,6.2872e-02_r8,7.4519e-02_r8,8.9400e-02_r8,1.0278e-01_r8/)
      kbo(:,39, 7) = (/ &
     &4.9669e-02_r8,5.9933e-02_r8,7.1439e-02_r8,8.4019e-02_r8,9.9553e-02_r8/)
      kbo(:,40, 7) = (/ &
     &4.5810e-02_r8,5.5845e-02_r8,6.7001e-02_r8,7.9231e-02_r8,9.4558e-02_r8/)
      kbo(:,41, 7) = (/ &
     &4.2118e-02_r8,5.1782e-02_r8,6.2542e-02_r8,7.4429e-02_r8,8.9527e-02_r8/)
      kbo(:,42, 7) = (/ &
     &3.8602e-02_r8,4.7947e-02_r8,5.8290e-02_r8,6.9790e-02_r8,8.4691e-02_r8/)
      kbo(:,43, 7) = (/ &
     &3.4683e-02_r8,4.3605e-02_r8,5.3513e-02_r8,6.4549e-02_r8,7.6612e-02_r8/)
      kbo(:,44, 7) = (/ &
     &3.0820e-02_r8,3.9228e-02_r8,4.8707e-02_r8,5.9113e-02_r8,7.0667e-02_r8/)
      kbo(:,45, 7) = (/ &
     &2.7206e-02_r8,3.5088e-02_r8,4.4017e-02_r8,5.3958e-02_r8,6.4971e-02_r8/)
      kbo(:,46, 7) = (/ &
     &2.3728e-02_r8,3.1004e-02_r8,3.9410e-02_r8,4.8844e-02_r8,5.9195e-02_r8/)
      kbo(:,47, 7) = (/ &
     &2.0318e-02_r8,2.6968e-02_r8,3.4803e-02_r8,4.3672e-02_r8,5.3514e-02_r8/)
      kbo(:,48, 7) = (/ &
     &1.7221e-02_r8,2.3270e-02_r8,3.0475e-02_r8,3.8751e-02_r8,4.8067e-02_r8/)
      kbo(:,49, 7) = (/ &
     &1.4371e-02_r8,1.9831e-02_r8,2.6371e-02_r8,3.4011e-02_r8,4.2706e-02_r8/)
      kbo(:,50, 7) = (/ &
     &1.2067e-02_r8,1.6953e-02_r8,2.2948e-02_r8,3.0025e-02_r8,3.8163e-02_r8/)
      kbo(:,51, 7) = (/ &
     &1.0081e-02_r8,1.4494e-02_r8,1.9976e-02_r8,2.6511e-02_r8,3.4117e-02_r8/)
      kbo(:,52, 7) = (/ &
     &8.3102e-03_r8,1.2227e-02_r8,1.7157e-02_r8,2.3198e-02_r8,3.0263e-02_r8/)
      kbo(:,53, 7) = (/ &
     &6.7300e-03_r8,1.0157e-02_r8,1.4580e-02_r8,2.0030e-02_r8,2.6549e-02_r8/)
      kbo(:,54, 7) = (/ &
     &5.5699e-03_r8,8.6183e-03_r8,1.2632e-02_r8,1.7641e-02_r8,2.3782e-02_r8/)
      kbo(:,55, 7) = (/ &
     &4.6424e-03_r8,7.3686e-03_r8,1.1048e-02_r8,1.5705e-02_r8,2.1480e-02_r8/)
      kbo(:,56, 7) = (/ &
     &3.8360e-03_r8,6.2508e-03_r8,9.5901e-03_r8,1.3914e-02_r8,1.9327e-02_r8/)
      kbo(:,57, 7) = (/ &
     &3.1377e-03_r8,5.2589e-03_r8,8.2647e-03_r8,1.2235e-02_r8,1.7290e-02_r8/)
      kbo(:,58, 7) = (/ &
     &2.5678e-03_r8,4.4320e-03_r8,7.1403e-03_r8,1.0793e-02_r8,1.5530e-02_r8/)
      kbo(:,59, 7) = (/ &
     &2.3969e-03_r8,4.2221e-03_r8,6.8990e-03_r8,1.0531e-02_r8,1.5294e-02_r8/)
      kbo(:,13, 8) = (/ &
     &4.5374e-01_r8,4.6892e-01_r8,4.8468e-01_r8,5.0059e-01_r8,5.1827e-01_r8/)
      kbo(:,14, 8) = (/ &
     &4.3219e-01_r8,4.4586e-01_r8,4.6019e-01_r8,4.7608e-01_r8,4.9298e-01_r8/)
      kbo(:,15, 8) = (/ &
     &4.0920e-01_r8,4.2277e-01_r8,4.3751e-01_r8,4.5370e-01_r8,4.7139e-01_r8/)
      kbo(:,16, 8) = (/ &
     &3.8774e-01_r8,3.9959e-01_r8,4.1438e-01_r8,4.3100e-01_r8,4.4920e-01_r8/)
      kbo(:,17, 8) = (/ &
     &3.7675e-01_r8,3.9034e-01_r8,4.0535e-01_r8,4.2142e-01_r8,4.3931e-01_r8/)
      kbo(:,18, 8) = (/ &
     &3.7210e-01_r8,3.8690e-01_r8,4.0196e-01_r8,4.1888e-01_r8,4.3633e-01_r8/)
      kbo(:,19, 8) = (/ &
     &3.8004e-01_r8,3.9604e-01_r8,4.1156e-01_r8,4.2942e-01_r8,4.4872e-01_r8/)
      kbo(:,20, 8) = (/ &
     &3.8032e-01_r8,3.9826e-01_r8,4.1629e-01_r8,4.3599e-01_r8,4.5653e-01_r8/)
      kbo(:,21, 8) = (/ &
     &3.7841e-01_r8,3.9929e-01_r8,4.1819e-01_r8,4.3972e-01_r8,4.6162e-01_r8/)
      kbo(:,22, 8) = (/ &
     &3.7504e-01_r8,3.9852e-01_r8,4.2087e-01_r8,4.4494e-01_r8,4.6985e-01_r8/)
      kbo(:,23, 8) = (/ &
     &3.7298e-01_r8,3.9721e-01_r8,4.2335e-01_r8,4.5127e-01_r8,4.7949e-01_r8/)
      kbo(:,24, 8) = (/ &
     &3.7096e-01_r8,3.9820e-01_r8,4.2817e-01_r8,4.5927e-01_r8,4.9128e-01_r8/)
      kbo(:,25, 8) = (/ &
     &3.6772e-01_r8,3.9818e-01_r8,4.3145e-01_r8,4.6548e-01_r8,5.0188e-01_r8/)
      kbo(:,26, 8) = (/ &
     &3.6515e-01_r8,3.9789e-01_r8,4.3248e-01_r8,4.6959e-01_r8,5.0716e-01_r8/)
      kbo(:,27, 8) = (/ &
     &3.5912e-01_r8,3.9421e-01_r8,4.3089e-01_r8,4.6934e-01_r8,5.0871e-01_r8/)
      kbo(:,28, 8) = (/ &
     &3.5260e-01_r8,3.8990e-01_r8,4.2842e-01_r8,4.6770e-01_r8,5.0872e-01_r8/)
      kbo(:,29, 8) = (/ &
     &3.4566e-01_r8,3.8302e-01_r8,4.2135e-01_r8,4.6236e-01_r8,5.0539e-01_r8/)
      kbo(:,30, 8) = (/ &
     &3.3909e-01_r8,3.7648e-01_r8,4.1601e-01_r8,4.5869e-01_r8,5.0690e-01_r8/)
      kbo(:,31, 8) = (/ &
     &3.3097e-01_r8,3.6927e-01_r8,4.1020e-01_r8,4.5248e-01_r8,5.0201e-01_r8/)
      kbo(:,32, 8) = (/ &
     &3.2677e-01_r8,3.6552e-01_r8,4.0712e-01_r8,4.4947e-01_r8,4.9828e-01_r8/)
      kbo(:,33, 8) = (/ &
     &3.2437e-01_r8,3.6324e-01_r8,4.0445e-01_r8,4.4744e-01_r8,4.9526e-01_r8/)
      kbo(:,34, 8) = (/ &
     &3.2478e-01_r8,3.6385e-01_r8,4.0433e-01_r8,4.5266e-01_r8,4.9618e-01_r8/)
      kbo(:,35, 8) = (/ &
     &3.2335e-01_r8,3.6225e-01_r8,4.0283e-01_r8,4.5093e-01_r8,4.9595e-01_r8/)
      kbo(:,36, 8) = (/ &
     &3.1952e-01_r8,3.5913e-01_r8,4.0020e-01_r8,4.4926e-01_r8,4.9354e-01_r8/)
      kbo(:,37, 8) = (/ &
     &3.0545e-01_r8,3.4531e-01_r8,3.8604e-01_r8,4.3520e-01_r8,4.7874e-01_r8/)
      kbo(:,38, 8) = (/ &
     &2.9161e-01_r8,3.3033e-01_r8,3.7111e-01_r8,4.1959e-01_r8,4.6334e-01_r8/)
      kbo(:,39, 8) = (/ &
     &2.7728e-01_r8,3.1579e-01_r8,3.5591e-01_r8,3.9884e-01_r8,4.4658e-01_r8/)
      kbo(:,40, 8) = (/ &
     &2.6059e-01_r8,2.9767e-01_r8,3.3670e-01_r8,3.7917e-01_r8,4.2621e-01_r8/)
      kbo(:,41, 8) = (/ &
     &2.4427e-01_r8,2.7974e-01_r8,3.1821e-01_r8,3.5868e-01_r8,4.0499e-01_r8/)
      kbo(:,42, 8) = (/ &
     &2.2818e-01_r8,2.6203e-01_r8,2.9920e-01_r8,3.3811e-01_r8,3.8330e-01_r8/)
      kbo(:,43, 8) = (/ &
     &2.1001e-01_r8,2.4274e-01_r8,2.7765e-01_r8,3.1477e-01_r8,3.5346e-01_r8/)
      kbo(:,44, 8) = (/ &
     &1.9124e-01_r8,2.2202e-01_r8,2.5515e-01_r8,2.8981e-01_r8,3.2699e-01_r8/)
      kbo(:,45, 8) = (/ &
     &1.7260e-01_r8,2.0229e-01_r8,2.3352e-01_r8,2.6561e-01_r8,2.9973e-01_r8/)
      kbo(:,46, 8) = (/ &
     &1.5463e-01_r8,1.8250e-01_r8,2.1175e-01_r8,2.4206e-01_r8,2.7362e-01_r8/)
      kbo(:,47, 8) = (/ &
     &1.3753e-01_r8,1.6353e-01_r8,1.9105e-01_r8,2.1973e-01_r8,2.4911e-01_r8/)
      kbo(:,48, 8) = (/ &
     &1.2102e-01_r8,1.4531e-01_r8,1.7086e-01_r8,1.9744e-01_r8,2.2473e-01_r8/)
      kbo(:,49, 8) = (/ &
     &1.0521e-01_r8,1.2719e-01_r8,1.5065e-01_r8,1.7507e-01_r8,1.9976e-01_r8/)
      kbo(:,50, 8) = (/ &
     &9.2290e-02_r8,1.1288e-01_r8,1.3468e-01_r8,1.5758e-01_r8,1.8102e-01_r8/)
      kbo(:,51, 8) = (/ &
     &8.1396e-02_r8,1.0065e-01_r8,1.2103e-01_r8,1.4278e-01_r8,1.6472e-01_r8/)
      kbo(:,52, 8) = (/ &
     &7.1108e-02_r8,8.8827e-02_r8,1.0785e-01_r8,1.2780e-01_r8,1.4857e-01_r8/)
      kbo(:,53, 8) = (/ &
     &6.0985e-02_r8,7.7296e-02_r8,9.4909e-02_r8,1.1304e-01_r8,1.3292e-01_r8/)
      kbo(:,54, 8) = (/ &
     &5.4165e-02_r8,6.9879e-02_r8,8.6686e-02_r8,1.0438e-01_r8,1.2336e-01_r8/)
      kbo(:,55, 8) = (/ &
     &4.9072e-02_r8,6.4377e-02_r8,8.0975e-02_r8,9.8517e-02_r8,1.1715e-01_r8/)
      kbo(:,56, 8) = (/ &
     &4.4131e-02_r8,5.9064e-02_r8,7.5254e-02_r8,9.2618e-02_r8,1.1083e-01_r8/)
      kbo(:,57, 8) = (/ &
     &3.9404e-02_r8,5.3744e-02_r8,6.9648e-02_r8,8.6728e-02_r8,1.0474e-01_r8/)
      kbo(:,58, 8) = (/ &
     &3.5245e-02_r8,4.9278e-02_r8,6.4917e-02_r8,8.1857e-02_r8,9.9966e-02_r8/)
      kbo(:,59, 8) = (/ &
     &3.5641e-02_r8,5.0530e-02_r8,6.7256e-02_r8,8.5600e-02_r8,1.0518e-01_r8/)
      kbo(:,13, 9) = (/ &
     &3.0582e+00_r8,3.1802e+00_r8,3.2924e+00_r8,3.3999e+00_r8,3.5039e+00_r8/)
      kbo(:,14, 9) = (/ &
     &2.7741e+00_r8,2.8902e+00_r8,2.9983e+00_r8,3.1018e+00_r8,3.1995e+00_r8/)
      kbo(:,15, 9) = (/ &
     &2.5019e+00_r8,2.6118e+00_r8,2.7174e+00_r8,2.8165e+00_r8,2.9092e+00_r8/)
      kbo(:,16, 9) = (/ &
     &2.2794e+00_r8,2.3785e+00_r8,2.4700e+00_r8,2.5601e+00_r8,2.6476e+00_r8/)
      kbo(:,17, 9) = (/ &
     &2.1431e+00_r8,2.2237e+00_r8,2.2973e+00_r8,2.3689e+00_r8,2.4470e+00_r8/)
      kbo(:,18, 9) = (/ &
     &2.1112e+00_r8,2.1931e+00_r8,2.2642e+00_r8,2.3350e+00_r8,2.3995e+00_r8/)
      kbo(:,19, 9) = (/ &
     &2.1192e+00_r8,2.1960e+00_r8,2.2679e+00_r8,2.3312e+00_r8,2.3985e+00_r8/)
      kbo(:,20, 9) = (/ &
     &2.0719e+00_r8,2.1504e+00_r8,2.2204e+00_r8,2.2883e+00_r8,2.3541e+00_r8/)
      kbo(:,21, 9) = (/ &
     &2.0023e+00_r8,2.0787e+00_r8,2.1566e+00_r8,2.2279e+00_r8,2.2981e+00_r8/)
      kbo(:,22, 9) = (/ &
     &1.9677e+00_r8,2.0354e+00_r8,2.1023e+00_r8,2.1820e+00_r8,2.2522e+00_r8/)
      kbo(:,23, 9) = (/ &
     &1.9509e+00_r8,2.0289e+00_r8,2.0929e+00_r8,2.1547e+00_r8,2.2177e+00_r8/)
      kbo(:,24, 9) = (/ &
     &1.9605e+00_r8,2.0316e+00_r8,2.0945e+00_r8,2.1537e+00_r8,2.2147e+00_r8/)
      kbo(:,25, 9) = (/ &
     &1.9774e+00_r8,2.0460e+00_r8,2.1037e+00_r8,2.1656e+00_r8,2.2237e+00_r8/)
      kbo(:,26, 9) = (/ &
     &1.9746e+00_r8,2.0494e+00_r8,2.1183e+00_r8,2.1793e+00_r8,2.2462e+00_r8/)
      kbo(:,27, 9) = (/ &
     &1.9769e+00_r8,2.0480e+00_r8,2.1184e+00_r8,2.1915e+00_r8,2.2594e+00_r8/)
      kbo(:,28, 9) = (/ &
     &1.9705e+00_r8,2.0478e+00_r8,2.1273e+00_r8,2.2021e+00_r8,2.2684e+00_r8/)
      kbo(:,29, 9) = (/ &
     &1.9428e+00_r8,2.0233e+00_r8,2.1092e+00_r8,2.1834e+00_r8,2.2523e+00_r8/)
      kbo(:,30, 9) = (/ &
     &1.9054e+00_r8,1.9928e+00_r8,2.0804e+00_r8,2.1559e+00_r8,2.2456e+00_r8/)
      kbo(:,31, 9) = (/ &
     &1.8578e+00_r8,1.9522e+00_r8,2.0363e+00_r8,2.1176e+00_r8,2.2067e+00_r8/)
      kbo(:,32, 9) = (/ &
     &1.8167e+00_r8,1.9163e+00_r8,1.9986e+00_r8,2.0826e+00_r8,2.1707e+00_r8/)
      kbo(:,33, 9) = (/ &
     &1.7835e+00_r8,1.8773e+00_r8,1.9713e+00_r8,2.0531e+00_r8,2.1415e+00_r8/)
      kbo(:,34, 9) = (/ &
     &1.7699e+00_r8,1.8654e+00_r8,1.9579e+00_r8,2.0589e+00_r8,2.1344e+00_r8/)
      kbo(:,35, 9) = (/ &
     &1.7588e+00_r8,1.8543e+00_r8,1.9464e+00_r8,2.0494e+00_r8,2.1255e+00_r8/)
      kbo(:,36, 9) = (/ &
     &1.7548e+00_r8,1.8549e+00_r8,1.9407e+00_r8,2.0440e+00_r8,2.1280e+00_r8/)
      kbo(:,37, 9) = (/ &
     &1.7109e+00_r8,1.8072e+00_r8,1.9003e+00_r8,1.9969e+00_r8,2.0787e+00_r8/)
      kbo(:,38, 9) = (/ &
     &1.6587e+00_r8,1.7570e+00_r8,1.8515e+00_r8,1.9517e+00_r8,2.0362e+00_r8/)
      kbo(:,39, 9) = (/ &
     &1.5996e+00_r8,1.6993e+00_r8,1.7940e+00_r8,1.8844e+00_r8,1.9872e+00_r8/)
      kbo(:,40, 9) = (/ &
     &1.5318e+00_r8,1.6341e+00_r8,1.7309e+00_r8,1.8212e+00_r8,1.9247e+00_r8/)
      kbo(:,41, 9) = (/ &
     &1.4675e+00_r8,1.5693e+00_r8,1.6630e+00_r8,1.7538e+00_r8,1.8608e+00_r8/)
      kbo(:,42, 9) = (/ &
     &1.4053e+00_r8,1.5014e+00_r8,1.5957e+00_r8,1.6862e+00_r8,1.7957e+00_r8/)
      kbo(:,43, 9) = (/ &
     &1.3266e+00_r8,1.4241e+00_r8,1.5193e+00_r8,1.6083e+00_r8,1.7037e+00_r8/)
      kbo(:,44, 9) = (/ &
     &1.2422e+00_r8,1.3405e+00_r8,1.4375e+00_r8,1.5296e+00_r8,1.6219e+00_r8/)
      kbo(:,45, 9) = (/ &
     &1.1571e+00_r8,1.2540e+00_r8,1.3469e+00_r8,1.4395e+00_r8,1.5427e+00_r8/)
      kbo(:,46, 9) = (/ &
     &1.0762e+00_r8,1.1688e+00_r8,1.2622e+00_r8,1.3587e+00_r8,1.4621e+00_r8/)
      kbo(:,47, 9) = (/ &
     &9.9321e-01_r8,1.0861e+00_r8,1.1791e+00_r8,1.2774e+00_r8,1.3779e+00_r8/)
      kbo(:,48, 9) = (/ &
     &9.0640e-01_r8,1.0035e+00_r8,1.0964e+00_r8,1.1955e+00_r8,1.2984e+00_r8/)
      kbo(:,49, 9) = (/ &
     &8.2476e-01_r8,9.1593e-01_r8,1.0111e+00_r8,1.1148e+00_r8,1.2202e+00_r8/)
      kbo(:,50, 9) = (/ &
     &7.5762e-01_r8,8.4984e-01_r8,9.4454e-01_r8,1.0468e+00_r8,1.1530e+00_r8/)
      kbo(:,51, 9) = (/ &
     &6.9972e-01_r8,7.8939e-01_r8,8.8551e-01_r8,9.8599e-01_r8,1.0894e+00_r8/)
      kbo(:,52, 9) = (/ &
     &6.4292e-01_r8,7.3062e-01_r8,8.2745e-01_r8,9.2620e-01_r8,1.0265e+00_r8/)
      kbo(:,53, 9) = (/ &
     &5.8631e-01_r8,6.7367e-01_r8,7.6794e-01_r8,8.6557e-01_r8,9.6191e-01_r8/)
      kbo(:,54, 9) = (/ &
     &5.4766e-01_r8,6.3312e-01_r8,7.2658e-01_r8,8.2340e-01_r8,9.1820e-01_r8/)
      kbo(:,55, 9) = (/ &
     &5.1893e-01_r8,6.0477e-01_r8,6.9346e-01_r8,7.9003e-01_r8,8.8552e-01_r8/)
      kbo(:,56, 9) = (/ &
     &4.9077e-01_r8,5.7504e-01_r8,6.6139e-01_r8,7.5822e-01_r8,8.5232e-01_r8/)
      kbo(:,57, 9) = (/ &
     &4.6294e-01_r8,5.4644e-01_r8,6.3217e-01_r8,7.2497e-01_r8,8.2095e-01_r8/)
      kbo(:,58, 9) = (/ &
     &4.3872e-01_r8,5.2209e-01_r8,6.0717e-01_r8,6.9576e-01_r8,7.9255e-01_r8/)
      kbo(:,59, 9) = (/ &
     &4.5355e-01_r8,5.4099e-01_r8,6.2851e-01_r8,7.1405e-01_r8,8.0552e-01_r8/)
      kbo(:,13,10) = (/ &
     &1.4982e+01_r8,1.5495e+01_r8,1.5954e+01_r8,1.6348e+01_r8,1.6704e+01_r8/)
      kbo(:,14,10) = (/ &
     &1.3335e+01_r8,1.3739e+01_r8,1.4075e+01_r8,1.4394e+01_r8,1.4701e+01_r8/)
      kbo(:,15,10) = (/ &
     &1.2249e+01_r8,1.2466e+01_r8,1.2680e+01_r8,1.2851e+01_r8,1.2999e+01_r8/)
      kbo(:,16,10) = (/ &
     &1.1258e+01_r8,1.1509e+01_r8,1.1735e+01_r8,1.1863e+01_r8,1.1992e+01_r8/)
      kbo(:,17,10) = (/ &
     &9.6399e+00_r8,9.9316e+00_r8,1.0198e+01_r8,1.0495e+01_r8,1.0685e+01_r8/)
      kbo(:,18,10) = (/ &
     &8.3200e+00_r8,8.3604e+00_r8,8.4791e+00_r8,8.5483e+00_r8,8.6485e+00_r8/)
      kbo(:,19,10) = (/ &
     &8.1074e+00_r8,8.1199e+00_r8,8.1734e+00_r8,8.2725e+00_r8,8.2532e+00_r8/)
      kbo(:,20,10) = (/ &
     &8.0251e+00_r8,8.0270e+00_r8,8.1639e+00_r8,8.2375e+00_r8,8.2230e+00_r8/)
      kbo(:,21,10) = (/ &
     &7.9993e+00_r8,8.0934e+00_r8,8.2060e+00_r8,8.1449e+00_r8,8.1878e+00_r8/)
      kbo(:,22,10) = (/ &
     &7.7052e+00_r8,7.8023e+00_r8,8.0192e+00_r8,8.0278e+00_r8,8.0411e+00_r8/)
      kbo(:,23,10) = (/ &
     &7.2443e+00_r8,7.3880e+00_r8,7.6036e+00_r8,7.7289e+00_r8,7.8141e+00_r8/)
      kbo(:,24,10) = (/ &
     &6.8599e+00_r8,6.9432e+00_r8,7.2334e+00_r8,7.4508e+00_r8,7.5685e+00_r8/)
      kbo(:,25,10) = (/ &
     &6.7077e+00_r8,6.7570e+00_r8,7.0253e+00_r8,7.1690e+00_r8,7.3506e+00_r8/)
      kbo(:,26,10) = (/ &
     &6.7805e+00_r8,6.7972e+00_r8,6.9739e+00_r8,6.9966e+00_r8,7.1457e+00_r8/)
      kbo(:,27,10) = (/ &
     &6.6456e+00_r8,6.8298e+00_r8,6.9537e+00_r8,6.8703e+00_r8,6.9847e+00_r8/)
      kbo(:,28,10) = (/ &
     &6.6227e+00_r8,6.7740e+00_r8,6.7717e+00_r8,6.7969e+00_r8,6.8834e+00_r8/)
      kbo(:,29,10) = (/ &
     &6.5026e+00_r8,6.7130e+00_r8,6.6983e+00_r8,6.7888e+00_r8,6.9842e+00_r8/)
      kbo(:,30,10) = (/ &
     &6.4613e+00_r8,6.7438e+00_r8,6.7406e+00_r8,6.8001e+00_r8,7.0628e+00_r8/)
      kbo(:,31,10) = (/ &
     &6.4453e+00_r8,6.5818e+00_r8,6.6914e+00_r8,6.8343e+00_r8,7.1118e+00_r8/)
      kbo(:,32,10) = (/ &
     &6.4750e+00_r8,6.5165e+00_r8,6.6931e+00_r8,6.9311e+00_r8,7.2907e+00_r8/)
      kbo(:,33,10) = (/ &
     &6.3852e+00_r8,6.5174e+00_r8,6.6687e+00_r8,7.0429e+00_r8,7.4921e+00_r8/)
      kbo(:,34,10) = (/ &
     &6.2937e+00_r8,6.5395e+00_r8,6.7522e+00_r8,7.1615e+00_r8,7.5856e+00_r8/)
      kbo(:,35,10) = (/ &
     &6.2760e+00_r8,6.5561e+00_r8,6.8772e+00_r8,7.3182e+00_r8,7.7508e+00_r8/)
      kbo(:,36,10) = (/ &
     &6.2498e+00_r8,6.5146e+00_r8,6.9721e+00_r8,7.4134e+00_r8,7.7777e+00_r8/)
      kbo(:,37,10) = (/ &
     &6.0875e+00_r8,6.4490e+00_r8,6.8813e+00_r8,7.4029e+00_r8,7.7937e+00_r8/)
      kbo(:,38,10) = (/ &
     &5.9776e+00_r8,6.3534e+00_r8,6.8337e+00_r8,7.2840e+00_r8,7.6800e+00_r8/)
      kbo(:,39,10) = (/ &
     &5.9369e+00_r8,6.2769e+00_r8,6.7228e+00_r8,7.1879e+00_r8,7.5772e+00_r8/)
      kbo(:,40,10) = (/ &
     &5.8199e+00_r8,6.1346e+00_r8,6.5569e+00_r8,7.0308e+00_r8,7.5139e+00_r8/)
      kbo(:,41,10) = (/ &
     &5.6637e+00_r8,5.9953e+00_r8,6.3928e+00_r8,6.8959e+00_r8,7.3899e+00_r8/)
      kbo(:,42,10) = (/ &
     &5.4578e+00_r8,5.8740e+00_r8,6.2837e+00_r8,6.7615e+00_r8,7.2182e+00_r8/)
      kbo(:,43,10) = (/ &
     &5.2432e+00_r8,5.6884e+00_r8,6.0915e+00_r8,6.5892e+00_r8,7.0176e+00_r8/)
      kbo(:,44,10) = (/ &
     &5.0352e+00_r8,5.5134e+00_r8,5.9765e+00_r8,6.3927e+00_r8,6.8192e+00_r8/)
      kbo(:,45,10) = (/ &
     &4.8185e+00_r8,5.3066e+00_r8,5.8216e+00_r8,6.2708e+00_r8,6.5394e+00_r8/)
      kbo(:,46,10) = (/ &
     &4.5458e+00_r8,5.0700e+00_r8,5.5601e+00_r8,5.9708e+00_r8,6.3061e+00_r8/)
      kbo(:,47,10) = (/ &
     &4.3290e+00_r8,4.8090e+00_r8,5.3177e+00_r8,5.7187e+00_r8,6.0493e+00_r8/)
      kbo(:,48,10) = (/ &
     &4.1252e+00_r8,4.6210e+00_r8,5.0031e+00_r8,5.3950e+00_r8,5.6779e+00_r8/)
      kbo(:,49,10) = (/ &
     &3.8776e+00_r8,4.3638e+00_r8,4.7491e+00_r8,5.0119e+00_r8,5.3209e+00_r8/)
      kbo(:,50,10) = (/ &
     &3.6432e+00_r8,4.1171e+00_r8,4.5036e+00_r8,4.8339e+00_r8,5.0310e+00_r8/)
      kbo(:,51,10) = (/ &
     &3.4528e+00_r8,3.8987e+00_r8,4.2685e+00_r8,4.6158e+00_r8,4.8586e+00_r8/)
      kbo(:,52,10) = (/ &
     &3.2373e+00_r8,3.6786e+00_r8,4.0057e+00_r8,4.3579e+00_r8,4.6615e+00_r8/)
      kbo(:,53,10) = (/ &
     &3.0066e+00_r8,3.4261e+00_r8,3.7660e+00_r8,4.0904e+00_r8,4.4162e+00_r8/)
      kbo(:,54,10) = (/ &
     &2.8305e+00_r8,3.2571e+00_r8,3.6215e+00_r8,3.9208e+00_r8,4.2651e+00_r8/)
      kbo(:,55,10) = (/ &
     &2.6852e+00_r8,3.0952e+00_r8,3.4961e+00_r8,3.7995e+00_r8,4.1315e+00_r8/)
      kbo(:,56,10) = (/ &
     &2.5024e+00_r8,2.9749e+00_r8,3.3840e+00_r8,3.6764e+00_r8,4.0215e+00_r8/)
      kbo(:,57,10) = (/ &
     &2.3413e+00_r8,2.8251e+00_r8,3.2333e+00_r8,3.5901e+00_r8,3.8695e+00_r8/)
      kbo(:,58,10) = (/ &
     &2.2399e+00_r8,2.6684e+00_r8,3.1055e+00_r8,3.4841e+00_r8,3.7568e+00_r8/)
      kbo(:,59,10) = (/ &
     &2.3106e+00_r8,2.6842e+00_r8,3.0911e+00_r8,3.5243e+00_r8,3.8718e+00_r8/)
      kbo(:,13,11) = (/ &
     &3.1114e+01_r8,3.1701e+01_r8,3.2323e+01_r8,3.2943e+01_r8,3.3516e+01_r8/)
      kbo(:,14,11) = (/ &
     &2.7715e+01_r8,2.8303e+01_r8,2.8933e+01_r8,2.9548e+01_r8,3.0169e+01_r8/)
      kbo(:,15,11) = (/ &
     &2.4338e+01_r8,2.4986e+01_r8,2.5617e+01_r8,2.6312e+01_r8,2.7005e+01_r8/)
      kbo(:,16,11) = (/ &
     &2.1212e+01_r8,2.1803e+01_r8,2.2432e+01_r8,2.3085e+01_r8,2.3696e+01_r8/)
      kbo(:,17,11) = (/ &
     &1.8965e+01_r8,1.9451e+01_r8,1.9925e+01_r8,2.0308e+01_r8,2.0718e+01_r8/)
      kbo(:,18,11) = (/ &
     &1.6301e+01_r8,1.6846e+01_r8,1.7358e+01_r8,1.7884e+01_r8,1.8436e+01_r8/)
      kbo(:,19,11) = (/ &
     &1.3305e+01_r8,1.3592e+01_r8,1.3869e+01_r8,1.4251e+01_r8,1.4704e+01_r8/)
      kbo(:,20,11) = (/ &
     &1.2734e+01_r8,1.2816e+01_r8,1.2643e+01_r8,1.2573e+01_r8,1.2686e+01_r8/)
      kbo(:,21,11) = (/ &
     &1.2657e+01_r8,1.2589e+01_r8,1.2354e+01_r8,1.2271e+01_r8,1.2114e+01_r8/)
      kbo(:,22,11) = (/ &
     &1.2492e+01_r8,1.2455e+01_r8,1.2170e+01_r8,1.1916e+01_r8,1.1871e+01_r8/)
      kbo(:,23,11) = (/ &
     &1.2437e+01_r8,1.2266e+01_r8,1.2152e+01_r8,1.1923e+01_r8,1.2016e+01_r8/)
      kbo(:,24,11) = (/ &
     &1.2312e+01_r8,1.2409e+01_r8,1.2179e+01_r8,1.1958e+01_r8,1.2034e+01_r8/)
      kbo(:,25,11) = (/ &
     &1.1905e+01_r8,1.2160e+01_r8,1.2010e+01_r8,1.2119e+01_r8,1.2127e+01_r8/)
      kbo(:,26,11) = (/ &
     &1.1398e+01_r8,1.1792e+01_r8,1.1851e+01_r8,1.2073e+01_r8,1.2295e+01_r8/)
      kbo(:,27,11) = (/ &
     &1.1115e+01_r8,1.1534e+01_r8,1.1738e+01_r8,1.2206e+01_r8,1.2469e+01_r8/)
      kbo(:,28,11) = (/ &
     &1.0833e+01_r8,1.1382e+01_r8,1.1757e+01_r8,1.2168e+01_r8,1.2751e+01_r8/)
      kbo(:,29,11) = (/ &
     &1.0849e+01_r8,1.1242e+01_r8,1.1765e+01_r8,1.2112e+01_r8,1.2581e+01_r8/)
      kbo(:,30,11) = (/ &
     &1.0908e+01_r8,1.1219e+01_r8,1.1698e+01_r8,1.2283e+01_r8,1.2675e+01_r8/)
      kbo(:,31,11) = (/ &
     &1.1065e+01_r8,1.1480e+01_r8,1.1755e+01_r8,1.2188e+01_r8,1.2848e+01_r8/)
      kbo(:,32,11) = (/ &
     &1.1087e+01_r8,1.1591e+01_r8,1.1912e+01_r8,1.2336e+01_r8,1.2746e+01_r8/)
      kbo(:,33,11) = (/ &
     &1.1325e+01_r8,1.1662e+01_r8,1.2022e+01_r8,1.2470e+01_r8,1.2619e+01_r8/)
      kbo(:,34,11) = (/ &
     &1.1533e+01_r8,1.1754e+01_r8,1.2155e+01_r8,1.2455e+01_r8,1.2615e+01_r8/)
      kbo(:,35,11) = (/ &
     &1.1659e+01_r8,1.1966e+01_r8,1.2184e+01_r8,1.2500e+01_r8,1.2545e+01_r8/)
      kbo(:,36,11) = (/ &
     &1.1755e+01_r8,1.2074e+01_r8,1.2225e+01_r8,1.2599e+01_r8,1.2813e+01_r8/)
      kbo(:,37,11) = (/ &
     &1.1716e+01_r8,1.1980e+01_r8,1.2067e+01_r8,1.2383e+01_r8,1.2671e+01_r8/)
      kbo(:,38,11) = (/ &
     &1.1652e+01_r8,1.1821e+01_r8,1.1815e+01_r8,1.2298e+01_r8,1.2561e+01_r8/)
      kbo(:,39,11) = (/ &
     &1.1437e+01_r8,1.1591e+01_r8,1.1776e+01_r8,1.2140e+01_r8,1.2306e+01_r8/)
      kbo(:,40,11) = (/ &
     &1.1267e+01_r8,1.1380e+01_r8,1.1567e+01_r8,1.1899e+01_r8,1.1967e+01_r8/)
      kbo(:,41,11) = (/ &
     &1.0928e+01_r8,1.1128e+01_r8,1.1355e+01_r8,1.1698e+01_r8,1.1735e+01_r8/)
      kbo(:,42,11) = (/ &
     &1.0609e+01_r8,1.0842e+01_r8,1.1168e+01_r8,1.1452e+01_r8,1.1524e+01_r8/)
      kbo(:,43,11) = (/ &
     &1.0251e+01_r8,1.0481e+01_r8,1.0835e+01_r8,1.1143e+01_r8,1.1300e+01_r8/)
      kbo(:,44,11) = (/ &
     &9.7650e+00_r8,1.0106e+01_r8,1.0340e+01_r8,1.0725e+01_r8,1.0899e+01_r8/)
      kbo(:,45,11) = (/ &
     &9.2584e+00_r8,9.6204e+00_r8,9.9580e+00_r8,1.0325e+01_r8,1.0626e+01_r8/)
      kbo(:,46,11) = (/ &
     &8.9377e+00_r8,9.1742e+00_r8,9.5458e+00_r8,9.9839e+00_r8,1.0197e+01_r8/)
      kbo(:,47,11) = (/ &
     &8.5371e+00_r8,8.7965e+00_r8,9.0763e+00_r8,9.5717e+00_r8,9.9938e+00_r8/)
      kbo(:,48,11) = (/ &
     &7.9850e+00_r8,8.3229e+00_r8,8.7471e+00_r8,9.1748e+00_r8,9.6663e+00_r8/)
      kbo(:,49,11) = (/ &
     &7.4325e+00_r8,7.8561e+00_r8,8.3257e+00_r8,8.9344e+00_r8,9.3488e+00_r8/)
      kbo(:,50,11) = (/ &
     &6.9934e+00_r8,7.5330e+00_r8,7.9938e+00_r8,8.5231e+00_r8,9.1226e+00_r8/)
      kbo(:,51,11) = (/ &
     &6.6292e+00_r8,7.1581e+00_r8,7.7030e+00_r8,8.1971e+00_r8,8.9077e+00_r8/)
      kbo(:,52,11) = (/ &
     &6.2107e+00_r8,6.7791e+00_r8,7.3981e+00_r8,7.9369e+00_r8,8.8177e+00_r8/)
      kbo(:,53,11) = (/ &
     &5.7771e+00_r8,6.3836e+00_r8,7.0431e+00_r8,7.8871e+00_r8,8.9292e+00_r8/)
      kbo(:,54,11) = (/ &
     &5.5085e+00_r8,6.1058e+00_r8,6.7091e+00_r8,7.6421e+00_r8,8.6682e+00_r8/)
      kbo(:,55,11) = (/ &
     &5.3542e+00_r8,5.9311e+00_r8,6.5099e+00_r8,7.2327e+00_r8,8.2463e+00_r8/)
      kbo(:,56,11) = (/ &
     &5.2013e+00_r8,5.6998e+00_r8,6.2622e+00_r8,6.8978e+00_r8,7.7861e+00_r8/)
      kbo(:,57,11) = (/ &
     &4.9844e+00_r8,5.4898e+00_r8,6.0972e+00_r8,6.6262e+00_r8,7.3665e+00_r8/)
      kbo(:,58,11) = (/ &
     &4.7470e+00_r8,5.3695e+00_r8,5.9047e+00_r8,6.4509e+00_r8,7.0483e+00_r8/)
      kbo(:,59,11) = (/ &
     &4.7734e+00_r8,5.4744e+00_r8,6.0332e+00_r8,6.5609e+00_r8,7.0505e+00_r8/)
      kbo(:,13,12) = (/ &
     &6.9738e+01_r8,7.0752e+01_r8,7.1414e+01_r8,7.2004e+01_r8,7.2657e+01_r8/)
      kbo(:,14,12) = (/ &
     &6.4422e+01_r8,6.5346e+01_r8,6.6191e+01_r8,6.7103e+01_r8,6.7985e+01_r8/)
      kbo(:,15,12) = (/ &
     &5.8702e+01_r8,5.9763e+01_r8,6.0895e+01_r8,6.1978e+01_r8,6.3157e+01_r8/)
      kbo(:,16,12) = (/ &
     &5.3091e+01_r8,5.4316e+01_r8,5.5558e+01_r8,5.6938e+01_r8,5.8399e+01_r8/)
      kbo(:,17,12) = (/ &
     &4.7175e+01_r8,4.8634e+01_r8,5.0234e+01_r8,5.1992e+01_r8,5.3803e+01_r8/)
      kbo(:,18,12) = (/ &
     &4.1145e+01_r8,4.2755e+01_r8,4.4548e+01_r8,4.6436e+01_r8,4.8468e+01_r8/)
      kbo(:,19,12) = (/ &
     &3.4889e+01_r8,3.6512e+01_r8,3.8406e+01_r8,4.0570e+01_r8,4.2997e+01_r8/)
      kbo(:,20,12) = (/ &
     &2.8470e+01_r8,3.0112e+01_r8,3.2281e+01_r8,3.4662e+01_r8,3.7243e+01_r8/)
      kbo(:,21,12) = (/ &
     &2.3947e+01_r8,2.5322e+01_r8,2.7206e+01_r8,2.9369e+01_r8,3.2034e+01_r8/)
      kbo(:,22,12) = (/ &
     &2.2071e+01_r8,2.2771e+01_r8,2.4136e+01_r8,2.6151e+01_r8,2.8304e+01_r8/)
      kbo(:,23,12) = (/ &
     &2.1437e+01_r8,2.2028e+01_r8,2.2789e+01_r8,2.3769e+01_r8,2.5664e+01_r8/)
      kbo(:,24,12) = (/ &
     &2.1104e+01_r8,2.1623e+01_r8,2.2496e+01_r8,2.3486e+01_r8,2.4592e+01_r8/)
      kbo(:,25,12) = (/ &
     &2.1238e+01_r8,2.1868e+01_r8,2.2645e+01_r8,2.3461e+01_r8,2.4762e+01_r8/)
      kbo(:,26,12) = (/ &
     &2.1604e+01_r8,2.2258e+01_r8,2.3294e+01_r8,2.4121e+01_r8,2.5265e+01_r8/)
      kbo(:,27,12) = (/ &
     &2.2115e+01_r8,2.2777e+01_r8,2.3909e+01_r8,2.4766e+01_r8,2.5867e+01_r8/)
      kbo(:,28,12) = (/ &
     &2.2448e+01_r8,2.3238e+01_r8,2.4298e+01_r8,2.5624e+01_r8,2.6343e+01_r8/)
      kbo(:,29,12) = (/ &
     &2.2577e+01_r8,2.3289e+01_r8,2.4323e+01_r8,2.5634e+01_r8,2.6765e+01_r8/)
      kbo(:,30,12) = (/ &
     &2.2578e+01_r8,2.3315e+01_r8,2.4386e+01_r8,2.5500e+01_r8,2.6908e+01_r8/)
      kbo(:,31,12) = (/ &
     &2.2201e+01_r8,2.3259e+01_r8,2.4131e+01_r8,2.5149e+01_r8,2.6545e+01_r8/)
      kbo(:,32,12) = (/ &
     &2.2079e+01_r8,2.2922e+01_r8,2.4111e+01_r8,2.5430e+01_r8,2.6527e+01_r8/)
      kbo(:,33,12) = (/ &
     &2.2095e+01_r8,2.2961e+01_r8,2.4279e+01_r8,2.5414e+01_r8,2.7005e+01_r8/)
      kbo(:,34,12) = (/ &
     &2.2319e+01_r8,2.3341e+01_r8,2.4447e+01_r8,2.6277e+01_r8,2.7940e+01_r8/)
      kbo(:,35,12) = (/ &
     &2.2552e+01_r8,2.3701e+01_r8,2.5211e+01_r8,2.6844e+01_r8,2.9224e+01_r8/)
      kbo(:,36,12) = (/ &
     &2.3085e+01_r8,2.4181e+01_r8,2.5665e+01_r8,2.7600e+01_r8,3.0387e+01_r8/)
      kbo(:,37,12) = (/ &
     &2.2925e+01_r8,2.4128e+01_r8,2.5553e+01_r8,2.7616e+01_r8,3.1077e+01_r8/)
      kbo(:,38,12) = (/ &
     &2.2707e+01_r8,2.3887e+01_r8,2.5581e+01_r8,2.8109e+01_r8,3.1584e+01_r8/)
      kbo(:,39,12) = (/ &
     &2.2511e+01_r8,2.3842e+01_r8,2.5754e+01_r8,2.8880e+01_r8,3.2658e+01_r8/)
      kbo(:,40,12) = (/ &
     &2.1948e+01_r8,2.3291e+01_r8,2.5416e+01_r8,2.8638e+01_r8,3.2604e+01_r8/)
      kbo(:,41,12) = (/ &
     &2.1476e+01_r8,2.2682e+01_r8,2.5024e+01_r8,2.8295e+01_r8,3.2225e+01_r8/)
      kbo(:,42,12) = (/ &
     &2.0874e+01_r8,2.2077e+01_r8,2.4841e+01_r8,2.8049e+01_r8,3.2070e+01_r8/)
      kbo(:,43,12) = (/ &
     &2.0317e+01_r8,2.1501e+01_r8,2.4302e+01_r8,2.7503e+01_r8,3.1532e+01_r8/)
      kbo(:,44,12) = (/ &
     &1.9539e+01_r8,2.0870e+01_r8,2.3855e+01_r8,2.7092e+01_r8,3.1110e+01_r8/)
      kbo(:,45,12) = (/ &
     &1.8830e+01_r8,2.0599e+01_r8,2.3570e+01_r8,2.6837e+01_r8,3.0566e+01_r8/)
      kbo(:,46,12) = (/ &
     &1.8029e+01_r8,2.0375e+01_r8,2.3363e+01_r8,2.6419e+01_r8,3.0085e+01_r8/)
      kbo(:,47,12) = (/ &
     &1.7365e+01_r8,1.9999e+01_r8,2.2921e+01_r8,2.5901e+01_r8,2.9166e+01_r8/)
      kbo(:,48,12) = (/ &
     &1.7043e+01_r8,1.9606e+01_r8,2.2433e+01_r8,2.5542e+01_r8,2.8495e+01_r8/)
      kbo(:,49,12) = (/ &
     &1.6912e+01_r8,1.9487e+01_r8,2.2139e+01_r8,2.5022e+01_r8,2.8110e+01_r8/)
      kbo(:,50,12) = (/ &
     &1.6517e+01_r8,1.8987e+01_r8,2.1585e+01_r8,2.4422e+01_r8,2.7428e+01_r8/)
      kbo(:,51,12) = (/ &
     &1.5891e+01_r8,1.8550e+01_r8,2.1056e+01_r8,2.3767e+01_r8,2.6461e+01_r8/)
      kbo(:,52,12) = (/ &
     &1.5362e+01_r8,1.8085e+01_r8,2.0538e+01_r8,2.3135e+01_r8,2.5477e+01_r8/)
      kbo(:,53,12) = (/ &
     &1.4979e+01_r8,1.7596e+01_r8,2.0169e+01_r8,2.2304e+01_r8,2.4351e+01_r8/)
      kbo(:,54,12) = (/ &
     &1.4292e+01_r8,1.6762e+01_r8,1.9386e+01_r8,2.1407e+01_r8,2.3360e+01_r8/)
      kbo(:,55,12) = (/ &
     &1.3424e+01_r8,1.5675e+01_r8,1.8295e+01_r8,2.0550e+01_r8,2.2398e+01_r8/)
      kbo(:,56,12) = (/ &
     &1.2558e+01_r8,1.4702e+01_r8,1.7198e+01_r8,1.9642e+01_r8,2.1560e+01_r8/)
      kbo(:,57,12) = (/ &
     &1.1789e+01_r8,1.3891e+01_r8,1.6101e+01_r8,1.8574e+01_r8,2.0696e+01_r8/)
      kbo(:,58,12) = (/ &
     &1.0944e+01_r8,1.2980e+01_r8,1.5007e+01_r8,1.7361e+01_r8,1.9688e+01_r8/)
      kbo(:,59,12) = (/ &
     &1.0805e+01_r8,1.1957e+01_r8,1.3692e+01_r8,1.5846e+01_r8,1.8110e+01_r8/)
      kbo(:,13,13) = (/ &
     &1.5252e+02_r8,1.5442e+02_r8,1.5646e+02_r8,1.5779e+02_r8,1.5854e+02_r8/)
      kbo(:,14,13) = (/ &
     &1.5029e+02_r8,1.5315e+02_r8,1.5552e+02_r8,1.5711e+02_r8,1.5813e+02_r8/)
      kbo(:,15,13) = (/ &
     &1.4712e+02_r8,1.5063e+02_r8,1.5294e+02_r8,1.5483e+02_r8,1.5630e+02_r8/)
      kbo(:,16,13) = (/ &
     &1.4282e+02_r8,1.4612e+02_r8,1.4898e+02_r8,1.5141e+02_r8,1.5352e+02_r8/)
      kbo(:,17,13) = (/ &
     &1.3686e+02_r8,1.4066e+02_r8,1.4417e+02_r8,1.4736e+02_r8,1.5020e+02_r8/)
      kbo(:,18,13) = (/ &
     &1.3031e+02_r8,1.3486e+02_r8,1.3910e+02_r8,1.4308e+02_r8,1.4669e+02_r8/)
      kbo(:,19,13) = (/ &
     &1.2305e+02_r8,1.2878e+02_r8,1.3410e+02_r8,1.3882e+02_r8,1.4318e+02_r8/)
      kbo(:,20,13) = (/ &
     &1.1539e+02_r8,1.2206e+02_r8,1.2838e+02_r8,1.3444e+02_r8,1.4010e+02_r8/)
      kbo(:,21,13) = (/ &
     &1.0694e+02_r8,1.1477e+02_r8,1.2233e+02_r8,1.2972e+02_r8,1.3638e+02_r8/)
      kbo(:,22,13) = (/ &
     &9.8072e+01_r8,1.0767e+02_r8,1.1673e+02_r8,1.2508e+02_r8,1.3303e+02_r8/)
      kbo(:,23,13) = (/ &
     &8.9638e+01_r8,1.0003e+02_r8,1.1035e+02_r8,1.2081e+02_r8,1.2954e+02_r8/)
      kbo(:,24,13) = (/ &
     &8.2450e+01_r8,9.3359e+01_r8,1.0421e+02_r8,1.1509e+02_r8,1.2544e+02_r8/)
      kbo(:,25,13) = (/ &
     &7.6879e+01_r8,8.7792e+01_r8,9.9290e+01_r8,1.1048e+02_r8,1.2100e+02_r8/)
      kbo(:,26,13) = (/ &
     &7.3470e+01_r8,8.4233e+01_r8,9.5225e+01_r8,1.0688e+02_r8,1.1752e+02_r8/)
      kbo(:,27,13) = (/ &
     &7.1984e+01_r8,8.2203e+01_r8,9.3044e+01_r8,1.0438e+02_r8,1.1537e+02_r8/)
      kbo(:,28,13) = (/ &
     &7.1683e+01_r8,8.1066e+01_r8,9.2180e+01_r8,1.0291e+02_r8,1.1419e+02_r8/)
      kbo(:,29,13) = (/ &
     &7.3240e+01_r8,8.2713e+01_r8,9.3261e+01_r8,1.0420e+02_r8,1.1497e+02_r8/)
      kbo(:,30,13) = (/ &
     &7.5656e+01_r8,8.5740e+01_r8,9.5155e+01_r8,1.0607e+02_r8,1.1653e+02_r8/)
      kbo(:,31,13) = (/ &
     &7.9639e+01_r8,8.9485e+01_r8,9.9623e+01_r8,1.0965e+02_r8,1.1967e+02_r8/)
      kbo(:,32,13) = (/ &
     &8.5052e+01_r8,9.4635e+01_r8,1.0433e+02_r8,1.1321e+02_r8,1.2287e+02_r8/)
      kbo(:,33,13) = (/ &
     &9.0468e+01_r8,1.0058e+02_r8,1.0969e+02_r8,1.1864e+02_r8,1.2671e+02_r8/)
      kbo(:,34,13) = (/ &
     &9.5615e+01_r8,1.0581e+02_r8,1.1476e+02_r8,1.2258e+02_r8,1.3070e+02_r8/)
      kbo(:,35,13) = (/ &
     &9.9168e+01_r8,1.0972e+02_r8,1.1933e+02_r8,1.2712e+02_r8,1.3373e+02_r8/)
      kbo(:,36,13) = (/ &
     &1.0086e+02_r8,1.1164e+02_r8,1.2168e+02_r8,1.3014e+02_r8,1.3667e+02_r8/)
      kbo(:,37,13) = (/ &
     &1.0047e+02_r8,1.1211e+02_r8,1.2253e+02_r8,1.3099e+02_r8,1.3706e+02_r8/)
      kbo(:,38,13) = (/ &
     &1.0049e+02_r8,1.1250e+02_r8,1.2313e+02_r8,1.3108e+02_r8,1.3732e+02_r8/)
      kbo(:,39,13) = (/ &
     &1.0115e+02_r8,1.1295e+02_r8,1.2350e+02_r8,1.3105e+02_r8,1.3768e+02_r8/)
      kbo(:,40,13) = (/ &
     &9.9765e+01_r8,1.1141e+02_r8,1.2196e+02_r8,1.2992e+02_r8,1.3631e+02_r8/)
      kbo(:,41,13) = (/ &
     &9.8221e+01_r8,1.1003e+02_r8,1.2037e+02_r8,1.2825e+02_r8,1.3487e+02_r8/)
      kbo(:,42,13) = (/ &
     &9.7048e+01_r8,1.0845e+02_r8,1.1823e+02_r8,1.2668e+02_r8,1.3349e+02_r8/)
      kbo(:,43,13) = (/ &
     &9.4582e+01_r8,1.0608e+02_r8,1.1575e+02_r8,1.2424e+02_r8,1.3118e+02_r8/)
      kbo(:,44,13) = (/ &
     &9.2428e+01_r8,1.0325e+02_r8,1.1298e+02_r8,1.2159e+02_r8,1.2888e+02_r8/)
      kbo(:,45,13) = (/ &
     &9.0012e+01_r8,1.0014e+02_r8,1.0975e+02_r8,1.1855e+02_r8,1.2634e+02_r8/)
      kbo(:,46,13) = (/ &
     &8.6912e+01_r8,9.6825e+01_r8,1.0618e+02_r8,1.1559e+02_r8,1.2362e+02_r8/)
      kbo(:,47,13) = (/ &
     &8.3243e+01_r8,9.2791e+01_r8,1.0216e+02_r8,1.1173e+02_r8,1.2014e+02_r8/)
      kbo(:,48,13) = (/ &
     &7.9277e+01_r8,8.8596e+01_r8,9.7998e+01_r8,1.0757e+02_r8,1.1661e+02_r8/)
      kbo(:,49,13) = (/ &
     &7.5292e+01_r8,8.4192e+01_r8,9.3715e+01_r8,1.0350e+02_r8,1.1301e+02_r8/)
      kbo(:,50,13) = (/ &
     &7.1230e+01_r8,8.0247e+01_r8,8.9698e+01_r8,9.9552e+01_r8,1.0903e+02_r8/)
      kbo(:,51,13) = (/ &
     &6.7476e+01_r8,7.6410e+01_r8,8.5492e+01_r8,9.5376e+01_r8,1.0529e+02_r8/)
      kbo(:,52,13) = (/ &
     &6.3984e+01_r8,7.2323e+01_r8,8.1379e+01_r8,9.1669e+01_r8,1.0161e+02_r8/)
      kbo(:,53,13) = (/ &
     &6.0507e+01_r8,6.8710e+01_r8,7.7291e+01_r8,8.7376e+01_r8,9.7642e+01_r8/)
      kbo(:,54,13) = (/ &
     &5.7140e+01_r8,6.5369e+01_r8,7.3636e+01_r8,8.3548e+01_r8,9.3708e+01_r8/)
      kbo(:,55,13) = (/ &
     &5.3812e+01_r8,6.2020e+01_r8,7.0040e+01_r8,7.9975e+01_r8,8.9949e+01_r8/)
      kbo(:,56,13) = (/ &
     &5.0680e+01_r8,5.8469e+01_r8,6.6837e+01_r8,7.6130e+01_r8,8.6168e+01_r8/)
      kbo(:,57,13) = (/ &
     &4.7704e+01_r8,5.5283e+01_r8,6.3212e+01_r8,7.2482e+01_r8,8.2593e+01_r8/)
      kbo(:,58,13) = (/ &
     &4.4831e+01_r8,5.2037e+01_r8,6.0082e+01_r8,6.9516e+01_r8,7.9098e+01_r8/)
      kbo(:,59,13) = (/ &
     &4.1993e+01_r8,5.0276e+01_r8,5.8426e+01_r8,6.7849e+01_r8,7.7045e+01_r8/)
      kbo(:,13,14) = (/ &
     &3.2192e+02_r8,3.1800e+02_r8,3.1299e+02_r8,3.0833e+02_r8,3.0378e+02_r8/)
      kbo(:,14,14) = (/ &
     &3.3616e+02_r8,3.3204e+02_r8,3.2756e+02_r8,3.2328e+02_r8,3.1928e+02_r8/)
      kbo(:,15,14) = (/ &
     &3.4851e+02_r8,3.4454e+02_r8,3.4128e+02_r8,3.3796e+02_r8,3.3453e+02_r8/)
      kbo(:,16,14) = (/ &
     &3.5910e+02_r8,3.5703e+02_r8,3.5472e+02_r8,3.5212e+02_r8,3.4919e+02_r8/)
      kbo(:,17,14) = (/ &
     &3.6944e+02_r8,3.6874e+02_r8,3.6739e+02_r8,3.6541e+02_r8,3.6285e+02_r8/)
      kbo(:,18,14) = (/ &
     &3.7860e+02_r8,3.7918e+02_r8,3.7877e+02_r8,3.7733e+02_r8,3.7491e+02_r8/)
      kbo(:,19,14) = (/ &
     &3.8633e+02_r8,3.8813e+02_r8,3.8858e+02_r8,3.8768e+02_r8,3.8541e+02_r8/)
      kbo(:,20,14) = (/ &
     &3.9291e+02_r8,3.9591e+02_r8,3.9708e+02_r8,3.9648e+02_r8,3.9435e+02_r8/)
      kbo(:,21,14) = (/ &
     &3.9871e+02_r8,4.0263e+02_r8,4.0428e+02_r8,4.0401e+02_r8,4.0199e+02_r8/)
      kbo(:,22,14) = (/ &
     &4.0411e+02_r8,4.0861e+02_r8,4.1054e+02_r8,4.1035e+02_r8,4.0818e+02_r8/)
      kbo(:,23,14) = (/ &
     &4.0907e+02_r8,4.1390e+02_r8,4.1591e+02_r8,4.1564e+02_r8,4.1319e+02_r8/)
      kbo(:,24,14) = (/ &
     &4.1361e+02_r8,4.1846e+02_r8,4.2039e+02_r8,4.1994e+02_r8,4.1722e+02_r8/)
      kbo(:,25,14) = (/ &
     &4.1735e+02_r8,4.2250e+02_r8,4.2427e+02_r8,4.2345e+02_r8,4.2038e+02_r8/)
      kbo(:,26,14) = (/ &
     &4.2023e+02_r8,4.2561e+02_r8,4.2741e+02_r8,4.2618e+02_r8,4.2275e+02_r8/)
      kbo(:,27,14) = (/ &
     &4.2191e+02_r8,4.2794e+02_r8,4.2966e+02_r8,4.2833e+02_r8,4.2447e+02_r8/)
      kbo(:,28,14) = (/ &
     &4.2376e+02_r8,4.3047e+02_r8,4.3157e+02_r8,4.2984e+02_r8,4.2560e+02_r8/)
      kbo(:,29,14) = (/ &
     &4.2494e+02_r8,4.3173e+02_r8,4.3312e+02_r8,4.3087e+02_r8,4.2623e+02_r8/)
      kbo(:,30,14) = (/ &
     &4.2606e+02_r8,4.3133e+02_r8,4.3417e+02_r8,4.3157e+02_r8,4.2642e+02_r8/)
      kbo(:,31,14) = (/ &
     &4.2650e+02_r8,4.3107e+02_r8,4.3305e+02_r8,4.3172e+02_r8,4.2612e+02_r8/)
      kbo(:,32,14) = (/ &
     &4.2471e+02_r8,4.2957e+02_r8,4.3084e+02_r8,4.2984e+02_r8,4.2547e+02_r8/)
      kbo(:,33,14) = (/ &
     &4.2258e+02_r8,4.2628e+02_r8,4.2740e+02_r8,4.2572e+02_r8,4.2270e+02_r8/)
      kbo(:,34,14) = (/ &
     &4.1904e+02_r8,4.2166e+02_r8,4.2281e+02_r8,4.2119e+02_r8,4.1745e+02_r8/)
      kbo(:,35,14) = (/ &
     &4.1547e+02_r8,4.1665e+02_r8,4.1587e+02_r8,4.1430e+02_r8,4.1140e+02_r8/)
      kbo(:,36,14) = (/ &
     &4.1132e+02_r8,4.1218e+02_r8,4.1072e+02_r8,4.0729e+02_r8,4.0326e+02_r8/)
      kbo(:,37,14) = (/ &
     &4.1025e+02_r8,4.1006e+02_r8,4.0857e+02_r8,4.0548e+02_r8,4.0090e+02_r8/)
      kbo(:,38,14) = (/ &
     &4.0864e+02_r8,4.0868e+02_r8,4.0686e+02_r8,4.0372e+02_r8,3.9921e+02_r8/)
      kbo(:,39,14) = (/ &
     &4.0644e+02_r8,4.0717e+02_r8,4.0510e+02_r8,4.0183e+02_r8,3.9677e+02_r8/)
      kbo(:,40,14) = (/ &
     &4.0674e+02_r8,4.0768e+02_r8,4.0593e+02_r8,4.0263e+02_r8,3.9822e+02_r8/)
      kbo(:,41,14) = (/ &
     &4.0619e+02_r8,4.0758e+02_r8,4.0668e+02_r8,4.0411e+02_r8,4.0014e+02_r8/)
      kbo(:,42,14) = (/ &
     &4.0516e+02_r8,4.0769e+02_r8,4.0744e+02_r8,4.0512e+02_r8,4.0147e+02_r8/)
      kbo(:,43,14) = (/ &
     &4.0427e+02_r8,4.0784e+02_r8,4.0882e+02_r8,4.0743e+02_r8,4.0425e+02_r8/)
      kbo(:,44,14) = (/ &
     &4.0222e+02_r8,4.0791e+02_r8,4.0985e+02_r8,4.0932e+02_r8,4.0671e+02_r8/)
      kbo(:,45,14) = (/ &
     &4.0049e+02_r8,4.0766e+02_r8,4.1090e+02_r8,4.1120e+02_r8,4.0941e+02_r8/)
      kbo(:,46,14) = (/ &
     &3.9818e+02_r8,4.0642e+02_r8,4.1148e+02_r8,4.1248e+02_r8,4.1163e+02_r8/)
      kbo(:,47,14) = (/ &
     &3.9380e+02_r8,4.0435e+02_r8,4.1138e+02_r8,4.1374e+02_r8,4.1407e+02_r8/)
      kbo(:,48,14) = (/ &
     &3.8928e+02_r8,4.0188e+02_r8,4.1084e+02_r8,4.1473e+02_r8,4.1611e+02_r8/)
      kbo(:,49,14) = (/ &
     &3.8359e+02_r8,3.9878e+02_r8,4.0957e+02_r8,4.1507e+02_r8,4.1710e+02_r8/)
      kbo(:,50,14) = (/ &
     &3.7809e+02_r8,3.9485e+02_r8,4.0769e+02_r8,4.1481e+02_r8,4.1835e+02_r8/)
      kbo(:,51,14) = (/ &
     &3.7168e+02_r8,3.9024e+02_r8,4.0538e+02_r8,4.1442e+02_r8,4.1907e+02_r8/)
      kbo(:,52,14) = (/ &
     &3.6416e+02_r8,3.8544e+02_r8,4.0242e+02_r8,4.1266e+02_r8,4.1894e+02_r8/)
      kbo(:,53,14) = (/ &
     &3.5526e+02_r8,3.7935e+02_r8,3.9858e+02_r8,4.1114e+02_r8,4.1870e+02_r8/)
      kbo(:,54,14) = (/ &
     &3.4652e+02_r8,3.7311e+02_r8,3.9451e+02_r8,4.0902e+02_r8,4.1841e+02_r8/)
      kbo(:,55,14) = (/ &
     &3.3749e+02_r8,3.6678e+02_r8,3.9033e+02_r8,4.0637e+02_r8,4.1776e+02_r8/)
      kbo(:,56,14) = (/ &
     &3.2816e+02_r8,3.6010e+02_r8,3.8512e+02_r8,4.0357e+02_r8,4.1651e+02_r8/)
      kbo(:,57,14) = (/ &
     &3.1792e+02_r8,3.5199e+02_r8,3.7987e+02_r8,4.0009e+02_r8,4.1450e+02_r8/)
      kbo(:,58,14) = (/ &
     &3.0792e+02_r8,3.4419e+02_r8,3.7396e+02_r8,3.9574e+02_r8,4.1235e+02_r8/)
      kbo(:,59,14) = (/ &
     &3.0450e+02_r8,3.4137e+02_r8,3.7215e+02_r8,3.9490e+02_r8,4.1294e+02_r8/)
      kbo(:,13,15) = (/ &
     &5.8728e+02_r8,5.6960e+02_r8,5.5469e+02_r8,5.4056e+02_r8,5.2654e+02_r8/)
      kbo(:,14,15) = (/ &
     &6.4066e+02_r8,6.2243e+02_r8,6.0593e+02_r8,5.8946e+02_r8,5.7294e+02_r8/)
      kbo(:,15,15) = (/ &
     &6.9682e+02_r8,6.7763e+02_r8,6.5849e+02_r8,6.3897e+02_r8,6.1931e+02_r8/)
      kbo(:,16,15) = (/ &
     &7.5471e+02_r8,7.3292e+02_r8,7.1026e+02_r8,6.8716e+02_r8,6.6402e+02_r8/)
      kbo(:,17,15) = (/ &
     &8.1231e+02_r8,7.8651e+02_r8,7.5977e+02_r8,7.3284e+02_r8,7.0637e+02_r8/)
      kbo(:,18,15) = (/ &
     &8.6774e+02_r8,8.3725e+02_r8,8.0641e+02_r8,7.7597e+02_r8,7.4653e+02_r8/)
      kbo(:,19,15) = (/ &
     &9.1989e+02_r8,8.8492e+02_r8,8.5007e+02_r8,8.1594e+02_r8,7.8315e+02_r8/)
      kbo(:,20,15) = (/ &
     &9.6712e+02_r8,9.2752e+02_r8,8.8885e+02_r8,8.5117e+02_r8,8.1509e+02_r8/)
      kbo(:,21,15) = (/ &
     &1.0088e+03_r8,9.6497e+02_r8,9.2264e+02_r8,8.8175e+02_r8,8.4261e+02_r8/)
      kbo(:,22,15) = (/ &
     &1.0418e+03_r8,9.9399e+02_r8,9.4844e+02_r8,9.0461e+02_r8,8.6306e+02_r8/)
      kbo(:,23,15) = (/ &
     &1.0679e+03_r8,1.0170e+03_r8,9.6858e+02_r8,9.2246e+02_r8,8.7882e+02_r8/)
      kbo(:,24,15) = (/ &
     &1.0878e+03_r8,1.0343e+03_r8,9.8346e+02_r8,9.3530e+02_r8,8.9008e+02_r8/)
      kbo(:,25,15) = (/ &
     &1.1017e+03_r8,1.0460e+03_r8,9.9332e+02_r8,9.4368e+02_r8,8.9722e+02_r8/)
      kbo(:,26,15) = (/ &
     &1.1097e+03_r8,1.0523e+03_r8,9.9837e+02_r8,9.4761e+02_r8,9.0024e+02_r8/)
      kbo(:,27,15) = (/ &
     &1.1134e+03_r8,1.0547e+03_r8,9.9983e+02_r8,9.4851e+02_r8,9.0041e+02_r8/)
      kbo(:,28,15) = (/ &
     &1.1133e+03_r8,1.0539e+03_r8,9.9848e+02_r8,9.4685e+02_r8,8.9828e+02_r8/)
      kbo(:,29,15) = (/ &
     &1.1100e+03_r8,1.0502e+03_r8,9.9454e+02_r8,9.4272e+02_r8,8.9398e+02_r8/)
      kbo(:,30,15) = (/ &
     &1.1040e+03_r8,1.0443e+03_r8,9.8865e+02_r8,9.3687e+02_r8,8.8821e+02_r8/)
      kbo(:,31,15) = (/ &
     &1.0960e+03_r8,1.0364e+03_r8,9.8114e+02_r8,9.2948e+02_r8,8.8105e+02_r8/)
      kbo(:,32,15) = (/ &
     &1.0862e+03_r8,1.0270e+03_r8,9.7213e+02_r8,9.2091e+02_r8,8.7298e+02_r8/)
      kbo(:,33,15) = (/ &
     &1.0752e+03_r8,1.0167e+03_r8,9.6230e+02_r8,9.1136e+02_r8,8.6427e+02_r8/)
      kbo(:,34,15) = (/ &
     &1.0653e+03_r8,1.0075e+03_r8,9.5353e+02_r8,9.0314e+02_r8,8.5654e+02_r8/)
      kbo(:,35,15) = (/ &
     &1.0607e+03_r8,1.0031e+03_r8,9.4921e+02_r8,8.9900e+02_r8,8.5273e+02_r8/)
      kbo(:,36,15) = (/ &
     &1.0620e+03_r8,1.0042e+03_r8,9.5018e+02_r8,8.9983e+02_r8,8.5343e+02_r8/)
      kbo(:,37,15) = (/ &
     &1.0721e+03_r8,1.0134e+03_r8,9.5885e+02_r8,9.0773e+02_r8,8.6067e+02_r8/)
      kbo(:,38,15) = (/ &
     &1.0824e+03_r8,1.0229e+03_r8,9.6769e+02_r8,9.1592e+02_r8,8.6811e+02_r8/)
      kbo(:,39,15) = (/ &
     &1.0926e+03_r8,1.0322e+03_r8,9.7633e+02_r8,9.2388e+02_r8,8.7544e+02_r8/)
      kbo(:,40,15) = (/ &
     &1.1061e+03_r8,1.0474e+03_r8,9.9047e+02_r8,9.3721e+02_r8,8.8756e+02_r8/)
      kbo(:,41,15) = (/ &
     &1.1226e+03_r8,1.0637e+03_r8,1.0055e+03_r8,9.5118e+02_r8,9.0046e+02_r8/)
      kbo(:,42,15) = (/ &
     &1.1394e+03_r8,1.0801e+03_r8,1.0206e+03_r8,9.6537e+02_r8,9.1362e+02_r8/)
      kbo(:,43,15) = (/ &
     &1.1611e+03_r8,1.1003e+03_r8,1.0393e+03_r8,9.8274e+02_r8,9.2982e+02_r8/)
      kbo(:,44,15) = (/ &
     &1.1862e+03_r8,1.1226e+03_r8,1.0598e+03_r8,1.0018e+03_r8,9.4776e+02_r8/)
      kbo(:,45,15) = (/ &
     &1.2106e+03_r8,1.1455e+03_r8,1.0808e+03_r8,1.0212e+03_r8,9.6597e+02_r8/)
      kbo(:,46,15) = (/ &
     &1.2373e+03_r8,1.1703e+03_r8,1.1039e+03_r8,1.0424e+03_r8,9.8575e+02_r8/)
      kbo(:,47,15) = (/ &
     &1.2689e+03_r8,1.1988e+03_r8,1.1303e+03_r8,1.0668e+03_r8,1.0082e+03_r8/)
      kbo(:,48,15) = (/ &
     &1.2999e+03_r8,1.2281e+03_r8,1.1575e+03_r8,1.0920e+03_r8,1.0314e+03_r8/)
      kbo(:,49,15) = (/ &
     &1.3314e+03_r8,1.2580e+03_r8,1.1855e+03_r8,1.1179e+03_r8,1.0553e+03_r8/)
      kbo(:,50,15) = (/ &
     &1.3612e+03_r8,1.2867e+03_r8,1.2124e+03_r8,1.1430e+03_r8,1.0785e+03_r8/)
      kbo(:,51,15) = (/ &
     &1.3905e+03_r8,1.3151e+03_r8,1.2392e+03_r8,1.1679e+03_r8,1.1016e+03_r8/)
      kbo(:,52,15) = (/ &
     &1.4202e+03_r8,1.3438e+03_r8,1.2667e+03_r8,1.1935e+03_r8,1.1254e+03_r8/)
      kbo(:,53,15) = (/ &
     &1.4513e+03_r8,1.3727e+03_r8,1.2946e+03_r8,1.2198e+03_r8,1.1498e+03_r8/)
      kbo(:,54,15) = (/ &
     &1.4800e+03_r8,1.3995e+03_r8,1.3206e+03_r8,1.2445e+03_r8,1.1728e+03_r8/)
      kbo(:,55,15) = (/ &
     &1.5077e+03_r8,1.4256e+03_r8,1.3457e+03_r8,1.2685e+03_r8,1.1953e+03_r8/)
      kbo(:,56,15) = (/ &
     &1.5346e+03_r8,1.4518e+03_r8,1.3711e+03_r8,1.2930e+03_r8,1.2182e+03_r8/)
      kbo(:,57,15) = (/ &
     &1.5614e+03_r8,1.4781e+03_r8,1.3967e+03_r8,1.3177e+03_r8,1.2417e+03_r8/)
      kbo(:,58,15) = (/ &
     &1.5868e+03_r8,1.5034e+03_r8,1.4212e+03_r8,1.3415e+03_r8,1.2645e+03_r8/)
      kbo(:,59,15) = (/ &
     &1.5970e+03_r8,1.5135e+03_r8,1.4312e+03_r8,1.3511e+03_r8,1.2737e+03_r8/)
      kbo(:,13,16) = (/ &
     &9.8102e+02_r8,9.4348e+02_r8,9.0592e+02_r8,8.7102e+02_r8,8.4003e+02_r8/)
      kbo(:,14,16) = (/ &
     &1.1017e+03_r8,1.0558e+03_r8,1.0119e+03_r8,9.7251e+02_r8,9.3606e+02_r8/)
      kbo(:,15,16) = (/ &
     &1.2294e+03_r8,1.1733e+03_r8,1.1221e+03_r8,1.0765e+03_r8,1.0331e+03_r8/)
      kbo(:,16,16) = (/ &
     &1.3605e+03_r8,1.2927e+03_r8,1.2335e+03_r8,1.1795e+03_r8,1.1282e+03_r8/)
      kbo(:,17,16) = (/ &
     &1.4907e+03_r8,1.4118e+03_r8,1.3426e+03_r8,1.2786e+03_r8,1.2181e+03_r8/)
      kbo(:,18,16) = (/ &
     &1.6164e+03_r8,1.5261e+03_r8,1.4460e+03_r8,1.3720e+03_r8,1.3020e+03_r8/)
      kbo(:,19,16) = (/ &
     &1.7353e+03_r8,1.6329e+03_r8,1.5412e+03_r8,1.4568e+03_r8,1.3777e+03_r8/)
      kbo(:,20,16) = (/ &
     &1.8432e+03_r8,1.7287e+03_r8,1.6256e+03_r8,1.5311e+03_r8,1.4432e+03_r8/)
      kbo(:,21,16) = (/ &
     &1.9386e+03_r8,1.8123e+03_r8,1.6986e+03_r8,1.5948e+03_r8,1.4993e+03_r8/)
      kbo(:,22,16) = (/ &
     &2.0105e+03_r8,1.8749e+03_r8,1.7520e+03_r8,1.6411e+03_r8,1.5395e+03_r8/)
      kbo(:,23,16) = (/ &
     &2.0682e+03_r8,1.9239e+03_r8,1.7938e+03_r8,1.6758e+03_r8,1.5698e+03_r8/)
      kbo(:,24,16) = (/ &
     &2.1097e+03_r8,1.9590e+03_r8,1.8231e+03_r8,1.7013e+03_r8,1.5912e+03_r8/)
      kbo(:,25,16) = (/ &
     &2.1366e+03_r8,1.9806e+03_r8,1.8412e+03_r8,1.7160e+03_r8,1.6035e+03_r8/)
      kbo(:,26,16) = (/ &
     &2.1483e+03_r8,1.9894e+03_r8,1.8477e+03_r8,1.7210e+03_r8,1.6077e+03_r8/)
      kbo(:,27,16) = (/ &
     &2.1499e+03_r8,1.9893e+03_r8,1.8466e+03_r8,1.7191e+03_r8,1.6062e+03_r8/)
      kbo(:,28,16) = (/ &
     &2.1427e+03_r8,1.9818e+03_r8,1.8393e+03_r8,1.7119e+03_r8,1.6006e+03_r8/)
      kbo(:,29,16) = (/ &
     &2.1277e+03_r8,1.9675e+03_r8,1.8260e+03_r8,1.6998e+03_r8,1.5909e+03_r8/)
      kbo(:,30,16) = (/ &
     &2.1075e+03_r8,1.9489e+03_r8,1.8089e+03_r8,1.6842e+03_r8,1.5788e+03_r8/)
      kbo(:,31,16) = (/ &
     &2.0822e+03_r8,1.9262e+03_r8,1.7881e+03_r8,1.6663e+03_r8,1.5639e+03_r8/)
      kbo(:,32,16) = (/ &
     &2.0533e+03_r8,1.9005e+03_r8,1.7649e+03_r8,1.6467e+03_r8,1.5469e+03_r8/)
      kbo(:,33,16) = (/ &
     &2.0222e+03_r8,1.8726e+03_r8,1.7400e+03_r8,1.6262e+03_r8,1.5282e+03_r8/)
      kbo(:,34,16) = (/ &
     &1.9951e+03_r8,1.8486e+03_r8,1.7187e+03_r8,1.6087e+03_r8,1.5123e+03_r8/)
      kbo(:,35,16) = (/ &
     &1.9819e+03_r8,1.8366e+03_r8,1.7081e+03_r8,1.6001e+03_r8,1.5043e+03_r8/)
      kbo(:,36,16) = (/ &
     &1.9843e+03_r8,1.8387e+03_r8,1.7099e+03_r8,1.6017e+03_r8,1.5056e+03_r8/)
      kbo(:,37,16) = (/ &
     &2.0096e+03_r8,1.8607e+03_r8,1.7293e+03_r8,1.6180e+03_r8,1.5204e+03_r8/)
      kbo(:,38,16) = (/ &
     &2.0360e+03_r8,1.8842e+03_r8,1.7495e+03_r8,1.6347e+03_r8,1.5358e+03_r8/)
      kbo(:,39,16) = (/ &
     &2.0619e+03_r8,1.9070e+03_r8,1.7697e+03_r8,1.6516e+03_r8,1.5509e+03_r8/)
      kbo(:,40,16) = (/ &
     &2.1060e+03_r8,1.9450e+03_r8,1.8033e+03_r8,1.6798e+03_r8,1.5761e+03_r8/)
      kbo(:,41,16) = (/ &
     &2.1534e+03_r8,1.9860e+03_r8,1.8395e+03_r8,1.7107e+03_r8,1.6027e+03_r8/)
      kbo(:,42,16) = (/ &
     &2.2020e+03_r8,2.0285e+03_r8,1.8771e+03_r8,1.7432e+03_r8,1.6297e+03_r8/)
      kbo(:,43,16) = (/ &
     &2.2623e+03_r8,2.0820e+03_r8,1.9234e+03_r8,1.7841e+03_r8,1.6639e+03_r8/)
      kbo(:,44,16) = (/ &
     &2.3303e+03_r8,2.1416e+03_r8,1.9758e+03_r8,1.8302e+03_r8,1.7027e+03_r8/)
      kbo(:,45,16) = (/ &
     &2.4015e+03_r8,2.2036e+03_r8,2.0305e+03_r8,1.8787e+03_r8,1.7442e+03_r8/)
      kbo(:,46,16) = (/ &
     &2.4806e+03_r8,2.2729e+03_r8,2.0910e+03_r8,1.9319e+03_r8,1.7910e+03_r8/)
      kbo(:,47,16) = (/ &
     &2.5738e+03_r8,2.3537e+03_r8,2.1621e+03_r8,1.9939e+03_r8,1.8463e+03_r8/)
      kbo(:,48,16) = (/ &
     &2.6744e+03_r8,2.4391e+03_r8,2.2368e+03_r8,2.0594e+03_r8,1.9042e+03_r8/)
      kbo(:,49,16) = (/ &
     &2.7827e+03_r8,2.5294e+03_r8,2.3154e+03_r8,2.1283e+03_r8,1.9646e+03_r8/)
      kbo(:,50,16) = (/ &
     &2.8923e+03_r8,2.6199e+03_r8,2.3931e+03_r8,2.1963e+03_r8,2.0240e+03_r8/)
      kbo(:,51,16) = (/ &
     &3.0068e+03_r8,2.7139e+03_r8,2.4725e+03_r8,2.2657e+03_r8,2.0848e+03_r8/)
      kbo(:,52,16) = (/ &
     &3.1290e+03_r8,2.8143e+03_r8,2.5557e+03_r8,2.3381e+03_r8,2.1483e+03_r8/)
      kbo(:,53,16) = (/ &
     &3.2592e+03_r8,2.9226e+03_r8,2.6451e+03_r8,2.4144e+03_r8,2.2150e+03_r8/)
      kbo(:,54,16) = (/ &
     &3.3865e+03_r8,3.0292e+03_r8,2.7322e+03_r8,2.4877e+03_r8,2.2788e+03_r8/)
      kbo(:,55,16) = (/ &
     &3.5154e+03_r8,3.1374e+03_r8,2.8210e+03_r8,2.5614e+03_r8,2.3429e+03_r8/)
      kbo(:,56,16) = (/ &
     &3.6521e+03_r8,3.2511e+03_r8,2.9159e+03_r8,2.6395e+03_r8,2.4095e+03_r8/)
      kbo(:,57,16) = (/ &
     &3.7974e+03_r8,3.3719e+03_r8,3.0171e+03_r8,2.7223e+03_r8,2.4795e+03_r8/)
      kbo(:,58,16) = (/ &
     &3.9425e+03_r8,3.4927e+03_r8,3.1186e+03_r8,2.8056e+03_r8,2.5484e+03_r8/)
      kbo(:,59,16) = (/ &
     &4.0032e+03_r8,3.5431e+03_r8,3.1604e+03_r8,2.8404e+03_r8,2.5772e+03_r8/)

!     The array FORREFO contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  The first 
!     index refers to reference temperature (296,260,224,260) and 
!     pressure (970,475,219,3 mbar) levels.  The second index 
!     runs over the g-channel (1 to 16).

      forrefo(1,:) = (/ &
     &5.1629e-06_r8,7.7578e-06_r8,1.9043e-05_r8,1.4802e-04_r8,2.2980e-04_r8,2.8057e-04_r8, &
     &3.2824e-04_r8,3.4913e-04_r8,3.6515e-04_r8,3.8271e-04_r8,3.7499e-04_r8,3.6966e-04_r8, &
     &3.7424e-04_r8,3.8884e-04_r8,3.7117e-04_r8,4.3710e-04_r8/)
      forrefo(2,:) = (/ &
     &5.0804e-06_r8,1.3466e-05_r8,7.2606e-05_r8,1.6940e-04_r8,2.1022e-04_r8,2.5900e-04_r8, &
     &2.9106e-04_r8,3.2261e-04_r8,3.2066e-04_r8,3.5421e-04_r8,3.7128e-04_r8,3.8144e-04_r8, &
     &3.7854e-04_r8,3.8347e-04_r8,3.8921e-04_r8,3.7339e-04_r8/)
      forrefo(3,:) = (/ &
     &5.4797e-05_r8,1.0026e-04_r8,1.2422e-04_r8,1.6386e-04_r8,1.8378e-04_r8,1.9616e-04_r8, &
     &2.0711e-04_r8,2.2492e-04_r8,2.5240e-04_r8,2.6187e-04_r8,2.6058e-04_r8,2.4892e-04_r8, &
     &2.6526e-04_r8,3.2105e-04_r8,3.6903e-04_r8,3.7213e-04_r8/)
      forrefo(4,:) = (/ &
     &4.2782e-05_r8,1.4775e-04_r8,1.4588e-04_r8,1.6964e-04_r8,1.6667e-04_r8,1.7192e-04_r8, &
     &1.9057e-04_r8,2.0180e-04_r8,2.1177e-04_r8,2.2326e-04_r8,2.3801e-04_r8,2.9308e-04_r8, &
     &3.1130e-04_r8,3.1829e-04_r8,3.5035e-04_r8,3.7782e-04_r8/)

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      selfrefo(:, 1) = (/ &
     & 1.27793e-03_r8, 1.05944e-03_r8, 8.78300e-04_r8, 7.28133e-04_r8, 6.03641e-04_r8, &
     & 5.00434e-04_r8, 4.14873e-04_r8, 3.43940e-04_r8, 2.85135e-04_r8, 2.36384e-04_r8/)
      selfrefo(:, 2) = (/ &
     & 1.42785e-03_r8, 1.17602e-03_r8, 9.68600e-04_r8, 7.97765e-04_r8, 6.57060e-04_r8, &
     & 5.41172e-04_r8, 4.45724e-04_r8, 3.67110e-04_r8, 3.02361e-04_r8, 2.49033e-04_r8/)
      selfrefo(:, 3) = (/ &
     & 2.94095e-03_r8, 2.27102e-03_r8, 1.75370e-03_r8, 1.35422e-03_r8, 1.04574e-03_r8, &
     & 8.07525e-04_r8, 6.23577e-04_r8, 4.81530e-04_r8, 3.71841e-04_r8, 2.87138e-04_r8/)
      selfrefo(:, 4) = (/ &
     & 3.94894e-03_r8, 3.48184e-03_r8, 3.07000e-03_r8, 2.70687e-03_r8, 2.38669e-03_r8, &
     & 2.10439e-03_r8, 1.85547e-03_r8, 1.63600e-03_r8, 1.44249e-03_r8, 1.27187e-03_r8/)
      selfrefo(:, 5) = (/ &
     & 4.19971e-03_r8, 3.86333e-03_r8, 3.55390e-03_r8, 3.26925e-03_r8, 3.00740e-03_r8, &
     & 2.76652e-03_r8, 2.54494e-03_r8, 2.34110e-03_r8, 2.15359e-03_r8, 1.98110e-03_r8/)
      selfrefo(:, 6) = (/ &
     & 4.95922e-03_r8, 4.57134e-03_r8, 4.21380e-03_r8, 3.88422e-03_r8, 3.58042e-03_r8, &
     & 3.30038e-03_r8, 3.04225e-03_r8, 2.80430e-03_r8, 2.58496e-03_r8, 2.38278e-03_r8/)
      selfrefo(:, 7) = (/ &
     & 5.27379e-03_r8, 4.91005e-03_r8, 4.57140e-03_r8, 4.25611e-03_r8, 3.96256e-03_r8, &
     & 3.68925e-03_r8, 3.43480e-03_r8, 3.19790e-03_r8, 2.97734e-03_r8, 2.77199e-03_r8/)
      selfrefo(:, 8) = (/ &
     & 5.75341e-03_r8, 5.31533e-03_r8, 4.91060e-03_r8, 4.53669e-03_r8, 4.19126e-03_r8, &
     & 3.87212e-03_r8, 3.57729e-03_r8, 3.30490e-03_r8, 3.05325e-03_r8, 2.82077e-03_r8/)
      selfrefo(:, 9) = (/ &
     & 5.49849e-03_r8, 5.14295e-03_r8, 4.81040e-03_r8, 4.49935e-03_r8, 4.20842e-03_r8, &
     & 3.93629e-03_r8, 3.68177e-03_r8, 3.44370e-03_r8, 3.22102e-03_r8, 3.01275e-03_r8/)
      selfrefo(:,10) = (/ &
     & 6.04962e-03_r8, 5.60945e-03_r8, 5.20130e-03_r8, 4.82285e-03_r8, 4.47194e-03_r8, &
     & 4.14656e-03_r8, 3.84485e-03_r8, 3.56510e-03_r8, 3.30570e-03_r8, 3.06518e-03_r8/)
      selfrefo(:,11) = (/ &
     & 6.40108e-03_r8, 5.87551e-03_r8, 5.39310e-03_r8, 4.95029e-03_r8, 4.54385e-03_r8, &
     & 4.17077e-03_r8, 3.82833e-03_r8, 3.51400e-03_r8, 3.22548e-03_r8, 2.96065e-03_r8/)
      selfrefo(:,12) = (/ &
     & 6.77938e-03_r8, 6.15713e-03_r8, 5.59200e-03_r8, 5.07874e-03_r8, 4.61259e-03_r8, &
     & 4.18922e-03_r8, 3.80472e-03_r8, 3.45550e-03_r8, 3.13834e-03_r8, 2.85029e-03_r8/)
      selfrefo(:,13) = (/ &
     & 6.90020e-03_r8, 6.26766e-03_r8, 5.69310e-03_r8, 5.17121e-03_r8, 4.69717e-03_r8, &
     & 4.26658e-03_r8, 3.87546e-03_r8, 3.52020e-03_r8, 3.19750e-03_r8, 2.90439e-03_r8/)
      selfrefo(:,14) = (/ &
     & 6.92759e-03_r8, 6.32882e-03_r8, 5.78180e-03_r8, 5.28206e-03_r8, 4.82552e-03_r8, &
     & 4.40843e-03_r8, 4.02740e-03_r8, 3.67930e-03_r8, 3.36129e-03_r8, 3.07076e-03_r8/)
      selfrefo(:,15) = (/ &
     & 7.54539e-03_r8, 6.81161e-03_r8, 6.14920e-03_r8, 5.55120e-03_r8, 5.01136e-03_r8, &
     & 4.52402e-03_r8, 4.08407e-03_r8, 3.68690e-03_r8, 3.32836e-03_r8, 3.00468e-03_r8/)
      selfrefo(:,16) = (/ &
     & 7.62039e-03_r8, 7.10834e-03_r8, 6.63070e-03_r8, 6.18515e-03_r8, 5.76955e-03_r8, &
     & 5.38186e-03_r8, 5.02023e-03_r8, 4.68290e-03_r8, 4.36823e-03_r8, 4.07471e-03_r8/)

      end subroutine lw_kgb16
