!     path:      $Source: /storm/rc1/cvsroot/rc/rrtmg_lw/src/rrtmg_lw_k_g.f90,v $
!     author:    $Author: mike $
!     revision:  $Revision: 1.2 $
!     created:   $Date: 2007/08/22 19:20:03 $
!
!  --------------------------------------------------------------------------
! |                                                                          |
! |  Copyright 2002-2007, Atmospheric & Environmental Research, Inc. (AER).  |
! |  This software may be used, copied, or redistributed as long as it is    |
! |  not sold and this copyright notice is reproduced on each copy made.     |
! |  This model is provided as is without any express or implied warranties. |
! |                       (http://www.rtweb.aer.com/)                        |
! |                                                                          |
!  --------------------------------------------------------------------------

! **************************************************************************
!      subroutine lw_kgbnn
! **************************************************************************
!  RRTM Longwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original version:   E. J. Mlawer, et al.
!  Revision for GCMs:  Michael J. Iacono; October, 2002
!
!  This file contains 16 subroutines that include the 
!  absorption coefficients and other data for each of the 16 longwave
!  spectral bands used in RRTM.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_LW_INIT to reduce
!  the total number of g-points from 256 to 140 for use in the GCM.
! **************************************************************************
! **************************************************************************
      subroutine lw_kgb14
! **************************************************************************

      use shr_kind_mod, only: r8 => shr_kind_r8

!      use parkind, only : jpim, jprb 
      use rrlw_kg14, only : fracrefao, fracrefbo, kao, kbo, selfrefo, forrefo

      implicit none
      save

! Planck fraction mapping level : P = 142.5940 mb, T = 215.70 K
      fracrefao(:) = (/ &
     &  1.9360e-01_r8, 1.7276e-01_r8, 1.4811e-01_r8, 1.2238e-01_r8, &
     &  1.0242e-01_r8, 8.6830e-02_r8, 7.1890e-02_r8, 5.4030e-02_r8, &
     &  3.5075e-02_r8, 3.8052e-03_r8, 3.1458e-03_r8, 2.4873e-03_r8, &
     &  1.8182e-03_r8, 1.1563e-03_r8, 4.3251e-04_r8, 5.7744e-05_r8/)

! Planck fraction mapping level : P = 4.758820mb, T = 250.85 K
      fracrefbo(:) = (/ &
     &  1.8599e-01_r8, 1.6646e-01_r8, 1.4264e-01_r8, 1.2231e-01_r8, &
     &  1.0603e-01_r8, 9.2014e-02_r8, 7.5287e-02_r8, 5.6758e-02_r8, &
     &  3.8386e-02_r8, 4.2139e-03_r8, 3.5399e-03_r8, 2.7381e-03_r8, &
     &  1.9202e-03_r8, 1.2083e-03_r8, 4.5395e-04_r8, 6.2699e-05_r8/)

!     The array KAO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels > ~100mb, temperatures, and ratios
!     of water vapor to CO2.  The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amount ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 
!     to that of gas2.
!     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
!     to different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this  pressure 
!     level, JT = 2 refers to the temperature
!     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the reference pressure level (e.g. JP = 1 is for a
!     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

      kao(:, 1, 1) = (/ &
     &3.5183e-01_r8,3.7165e-01_r8,3.9536e-01_r8,4.2364e-01_r8,4.5645e-01_r8/)
      kao(:, 2, 1) = (/ &
     &2.9958e-01_r8,3.1568e-01_r8,3.3580e-01_r8,3.6030e-01_r8,3.8890e-01_r8/)
      kao(:, 3, 1) = (/ &
     &2.5105e-01_r8,2.6327e-01_r8,2.7913e-01_r8,2.9918e-01_r8,3.2278e-01_r8/)
      kao(:, 4, 1) = (/ &
     &2.0894e-01_r8,2.1786e-01_r8,2.3000e-01_r8,2.4588e-01_r8,2.6517e-01_r8/)
      kao(:, 5, 1) = (/ &
     &1.7343e-01_r8,1.7993e-01_r8,1.8907e-01_r8,2.0143e-01_r8,2.1685e-01_r8/)
      kao(:, 6, 1) = (/ &
     &1.4374e-01_r8,1.4829e-01_r8,1.5503e-01_r8,1.6436e-01_r8,1.7642e-01_r8/)
      kao(:, 7, 1) = (/ &
     &1.1916e-01_r8,1.2232e-01_r8,1.2721e-01_r8,1.3426e-01_r8,1.4361e-01_r8/)
      kao(:, 8, 1) = (/ &
     &9.8898e-02_r8,1.0120e-01_r8,1.0467e-01_r8,1.0982e-01_r8,1.1705e-01_r8/)
      kao(:, 9, 1) = (/ &
     &8.2212e-02_r8,8.3740e-02_r8,8.6244e-02_r8,9.0121e-02_r8,9.5602e-02_r8/)
      kao(:,10, 1) = (/ &
     &6.8330e-02_r8,6.9351e-02_r8,7.1210e-02_r8,7.4137e-02_r8,7.8349e-02_r8/)
      kao(:,11, 1) = (/ &
     &5.6910e-02_r8,5.7856e-02_r8,5.9557e-02_r8,6.2211e-02_r8,6.6055e-02_r8/)
      kao(:,12, 1) = (/ &
     &4.7279e-02_r8,4.8187e-02_r8,4.9716e-02_r8,5.2169e-02_r8,5.5693e-02_r8/)
      kao(:,13, 1) = (/ &
     &3.9228e-02_r8,4.0055e-02_r8,4.1480e-02_r8,4.3734e-02_r8,4.6826e-02_r8/)
      kao(:, 1, 2) = (/ &
     &1.2827e+00_r8,1.3853e+00_r8,1.5108e+00_r8,1.6643e+00_r8,1.8505e+00_r8/)
      kao(:, 2, 2) = (/ &
     &1.1042e+00_r8,1.1988e+00_r8,1.3140e+00_r8,1.4542e+00_r8,1.6229e+00_r8/)
      kao(:, 3, 2) = (/ &
     &9.2790e-01_r8,1.0121e+00_r8,1.1133e+00_r8,1.2349e+00_r8,1.3807e+00_r8/)
      kao(:, 4, 2) = (/ &
     &7.7001e-01_r8,8.4339e-01_r8,9.3172e-01_r8,1.0366e+00_r8,1.1604e+00_r8/)
      kao(:, 5, 2) = (/ &
     &6.3550e-01_r8,6.9915e-01_r8,7.7552e-01_r8,8.6518e-01_r8,9.7050e-01_r8/)
      kao(:, 6, 2) = (/ &
     &5.2058e-01_r8,5.7460e-01_r8,6.3982e-01_r8,7.1578e-01_r8,8.0435e-01_r8/)
      kao(:, 7, 2) = (/ &
     &4.2451e-01_r8,4.7028e-01_r8,5.2464e-01_r8,5.8830e-01_r8,6.6179e-01_r8/)
      kao(:, 8, 2) = (/ &
     &3.4539e-01_r8,3.8222e-01_r8,4.2607e-01_r8,4.7789e-01_r8,5.3786e-01_r8/)
      kao(:, 9, 2) = (/ &
     &2.7941e-01_r8,3.0849e-01_r8,3.4320e-01_r8,3.8420e-01_r8,4.3240e-01_r8/)
      kao(:,10, 2) = (/ &
     &2.2666e-01_r8,2.5024e-01_r8,2.7777e-01_r8,3.1051e-01_r8,3.4934e-01_r8/)
      kao(:,11, 2) = (/ &
     &1.9193e-01_r8,2.1218e-01_r8,2.3589e-01_r8,2.6422e-01_r8,2.9804e-01_r8/)
      kao(:,12, 2) = (/ &
     &1.6216e-01_r8,1.7954e-01_r8,2.0015e-01_r8,2.2464e-01_r8,2.5376e-01_r8/)
      kao(:,13, 2) = (/ &
     &1.3654e-01_r8,1.5163e-01_r8,1.6956e-01_r8,1.9071e-01_r8,2.1617e-01_r8/)
      kao(:, 1, 3) = (/ &
     &5.3312e+00_r8,5.9534e+00_r8,6.6227e+00_r8,7.3398e+00_r8,8.1099e+00_r8/)
      kao(:, 2, 3) = (/ &
     &4.6807e+00_r8,5.2433e+00_r8,5.8458e+00_r8,6.4988e+00_r8,7.1971e+00_r8/)
      kao(:, 3, 3) = (/ &
     &3.9284e+00_r8,4.4200e+00_r8,4.9505e+00_r8,5.5235e+00_r8,6.1336e+00_r8/)
      kao(:, 4, 3) = (/ &
     &3.2160e+00_r8,3.6333e+00_r8,4.0896e+00_r8,4.5842e+00_r8,5.1138e+00_r8/)
      kao(:, 5, 3) = (/ &
     &2.5935e+00_r8,2.9443e+00_r8,3.3309e+00_r8,3.7529e+00_r8,4.2079e+00_r8/)
      kao(:, 6, 3) = (/ &
     &2.0555e+00_r8,2.3468e+00_r8,2.6695e+00_r8,3.0246e+00_r8,3.4114e+00_r8/)
      kao(:, 7, 3) = (/ &
     &1.6122e+00_r8,1.8522e+00_r8,2.1211e+00_r8,2.4178e+00_r8,2.7436e+00_r8/)
      kao(:, 8, 3) = (/ &
     &1.2572e+00_r8,1.4549e+00_r8,1.6787e+00_r8,1.9278e+00_r8,2.2011e+00_r8/)
      kao(:, 9, 3) = (/ &
     &9.7554e-01_r8,1.1374e+00_r8,1.3224e+00_r8,1.5307e+00_r8,1.7599e+00_r8/)
      kao(:,10, 3) = (/ &
     &7.6412e-01_r8,8.9744e-01_r8,1.0509e+00_r8,1.2253e+00_r8,1.4183e+00_r8/)
      kao(:,11, 3) = (/ &
     &6.4606e-01_r8,7.6360e-01_r8,8.9925e-01_r8,1.0524e+00_r8,1.2194e+00_r8/)
      kao(:,12, 3) = (/ &
     &5.4819e-01_r8,6.5159e-01_r8,7.6939e-01_r8,8.9987e-01_r8,1.0405e+00_r8/)
      kao(:,13, 3) = (/ &
     &4.6584e-01_r8,5.5439e-01_r8,6.5378e-01_r8,7.6270e-01_r8,8.8077e-01_r8/)
      kao(:, 1, 4) = (/ &
     &1.6140e+01_r8,1.7514e+01_r8,1.8771e+01_r8,1.9886e+01_r8,2.0829e+01_r8/)
      kao(:, 2, 4) = (/ &
     &1.4035e+01_r8,1.5167e+01_r8,1.6185e+01_r8,1.7079e+01_r8,1.7864e+01_r8/)
      kao(:, 3, 4) = (/ &
     &1.2090e+01_r8,1.3039e+01_r8,1.3889e+01_r8,1.4653e+01_r8,1.5339e+01_r8/)
      kao(:, 4, 4) = (/ &
     &1.0243e+01_r8,1.1063e+01_r8,1.1803e+01_r8,1.2472e+01_r8,1.3075e+01_r8/)
      kao(:, 5, 4) = (/ &
     &8.5658e+00_r8,9.2747e+00_r8,9.9250e+00_r8,1.0511e+01_r8,1.1040e+01_r8/)
      kao(:, 6, 4) = (/ &
     &7.0689e+00_r8,7.6839e+00_r8,8.2525e+00_r8,8.7702e+00_r8,9.2411e+00_r8/)
      kao(:, 7, 4) = (/ &
     &5.7728e+00_r8,6.3036e+00_r8,6.7993e+00_r8,7.2580e+00_r8,7.6760e+00_r8/)
      kao(:, 8, 4) = (/ &
     &4.6719e+00_r8,5.1262e+00_r8,5.5542e+00_r8,5.9566e+00_r8,6.3304e+00_r8/)
      kao(:, 9, 4) = (/ &
     &3.7449e+00_r8,4.1314e+00_r8,4.4992e+00_r8,4.8512e+00_r8,5.1834e+00_r8/)
      kao(:,10, 4) = (/ &
     &2.9983e+00_r8,3.3274e+00_r8,3.6424e+00_r8,3.9480e+00_r8,4.2418e+00_r8/)
      kao(:,11, 4) = (/ &
     &2.5136e+00_r8,2.7891e+00_r8,3.0545e+00_r8,3.3182e+00_r8,3.5747e+00_r8/)
      kao(:,12, 4) = (/ &
     &2.1004e+00_r8,2.3314e+00_r8,2.5605e+00_r8,2.7929e+00_r8,3.0174e+00_r8/)
      kao(:,13, 4) = (/ &
     &1.7524e+00_r8,1.9492e+00_r8,2.1512e+00_r8,2.3564e+00_r8,2.5478e+00_r8/)
      kao(:, 1, 5) = (/ &
     &3.4724e+01_r8,3.5203e+01_r8,3.5615e+01_r8,3.5967e+01_r8,3.6300e+01_r8/)
      kao(:, 2, 5) = (/ &
     &2.9704e+01_r8,3.0154e+01_r8,3.0541e+01_r8,3.0880e+01_r8,3.1155e+01_r8/)
      kao(:, 3, 5) = (/ &
     &2.5203e+01_r8,2.5623e+01_r8,2.5990e+01_r8,2.6275e+01_r8,2.6504e+01_r8/)
      kao(:, 4, 5) = (/ &
     &2.1552e+01_r8,2.1924e+01_r8,2.2232e+01_r8,2.2450e+01_r8,2.2639e+01_r8/)
      kao(:, 5, 5) = (/ &
     &1.8513e+01_r8,1.8836e+01_r8,1.9081e+01_r8,1.9246e+01_r8,1.9410e+01_r8/)
      kao(:, 6, 5) = (/ &
     &1.5765e+01_r8,1.6046e+01_r8,1.6242e+01_r8,1.6370e+01_r8,1.6509e+01_r8/)
      kao(:, 7, 5) = (/ &
     &1.3333e+01_r8,1.3583e+01_r8,1.3745e+01_r8,1.3853e+01_r8,1.3971e+01_r8/)
      kao(:, 8, 5) = (/ &
     &1.1230e+01_r8,1.1452e+01_r8,1.1589e+01_r8,1.1683e+01_r8,1.1782e+01_r8/)
      kao(:, 9, 5) = (/ &
     &9.4196e+00_r8,9.6109e+00_r8,9.7356e+00_r8,9.8175e+00_r8,9.8960e+00_r8/)
      kao(:,10, 5) = (/ &
     &7.8743e+00_r8,8.0366e+00_r8,8.1439e+00_r8,8.2124e+00_r8,8.2768e+00_r8/)
      kao(:,11, 5) = (/ &
     &6.6265e+00_r8,6.7386e+00_r8,6.8161e+00_r8,6.8681e+00_r8,6.9329e+00_r8/)
      kao(:,12, 5) = (/ &
     &5.5390e+00_r8,5.6241e+00_r8,5.6817e+00_r8,5.7305e+00_r8,5.8031e+00_r8/)
      kao(:,13, 5) = (/ &
     &4.6094e+00_r8,4.6772e+00_r8,4.7246e+00_r8,4.7737e+00_r8,4.8549e+00_r8/)
      kao(:, 1, 6) = (/ &
     &5.5082e+01_r8,5.5287e+01_r8,5.5714e+01_r8,5.6227e+01_r8,5.6768e+01_r8/)
      kao(:, 2, 6) = (/ &
     &4.8272e+01_r8,4.8698e+01_r8,4.9143e+01_r8,4.9607e+01_r8,5.0132e+01_r8/)
      kao(:, 3, 6) = (/ &
     &4.2021e+01_r8,4.2370e+01_r8,4.2729e+01_r8,4.3163e+01_r8,4.3674e+01_r8/)
      kao(:, 4, 6) = (/ &
     &3.6214e+01_r8,3.6443e+01_r8,3.6742e+01_r8,3.7158e+01_r8,3.7640e+01_r8/)
      kao(:, 5, 6) = (/ &
     &3.1082e+01_r8,3.1249e+01_r8,3.1507e+01_r8,3.1893e+01_r8,3.2320e+01_r8/)
      kao(:, 6, 6) = (/ &
     &2.6864e+01_r8,2.6986e+01_r8,2.7204e+01_r8,2.7526e+01_r8,2.7858e+01_r8/)
      kao(:, 7, 6) = (/ &
     &2.3146e+01_r8,2.3231e+01_r8,2.3407e+01_r8,2.3654e+01_r8,2.3926e+01_r8/)
      kao(:, 8, 6) = (/ &
     &1.9819e+01_r8,1.9868e+01_r8,1.9994e+01_r8,2.0178e+01_r8,2.0400e+01_r8/)
      kao(:, 9, 6) = (/ &
     &1.6892e+01_r8,1.6913e+01_r8,1.7001e+01_r8,1.7132e+01_r8,1.7310e+01_r8/)
      kao(:,10, 6) = (/ &
     &1.4365e+01_r8,1.4367e+01_r8,1.4429e+01_r8,1.4521e+01_r8,1.4660e+01_r8/)
      kao(:,11, 6) = (/ &
     &1.2162e+01_r8,1.2177e+01_r8,1.2223e+01_r8,1.2309e+01_r8,1.2439e+01_r8/)
      kao(:,12, 6) = (/ &
     &1.0257e+01_r8,1.0260e+01_r8,1.0295e+01_r8,1.0375e+01_r8,1.0502e+01_r8/)
      kao(:,13, 6) = (/ &
     &8.6109e+00_r8,8.6045e+00_r8,8.6391e+00_r8,8.7159e+00_r8,8.8472e+00_r8/)
      kao(:, 1, 7) = (/ &
     &9.6537e+01_r8,9.5488e+01_r8,9.4812e+01_r8,9.4687e+01_r8,9.5057e+01_r8/)
      kao(:, 2, 7) = (/ &
     &8.5306e+01_r8,8.4772e+01_r8,8.4928e+01_r8,8.5670e+01_r8,8.6805e+01_r8/)
      kao(:, 3, 7) = (/ &
     &7.4847e+01_r8,7.4994e+01_r8,7.5806e+01_r8,7.7131e+01_r8,7.8782e+01_r8/)
      kao(:, 4, 7) = (/ &
     &6.5341e+01_r8,6.6016e+01_r8,6.7305e+01_r8,6.9026e+01_r8,7.0761e+01_r8/)
      kao(:, 5, 7) = (/ &
     &5.6784e+01_r8,5.7825e+01_r8,5.9429e+01_r8,6.1058e+01_r8,6.2599e+01_r8/)
      kao(:, 6, 7) = (/ &
     &4.9097e+01_r8,5.0352e+01_r8,5.1865e+01_r8,5.3258e+01_r8,5.4642e+01_r8/)
      kao(:, 7, 7) = (/ &
     &4.2608e+01_r8,4.3857e+01_r8,4.5074e+01_r8,4.6282e+01_r8,4.7459e+01_r8/)
      kao(:, 8, 7) = (/ &
     &3.7209e+01_r8,3.8259e+01_r8,3.9241e+01_r8,4.0246e+01_r8,4.1244e+01_r8/)
      kao(:, 9, 7) = (/ &
     &3.2353e+01_r8,3.3212e+01_r8,3.4023e+01_r8,3.4877e+01_r8,3.5739e+01_r8/)
      kao(:,10, 7) = (/ &
     &2.7960e+01_r8,2.8627e+01_r8,2.9290e+01_r8,3.0022e+01_r8,3.0747e+01_r8/)
      kao(:,11, 7) = (/ &
     &2.4264e+01_r8,2.4777e+01_r8,2.5355e+01_r8,2.5965e+01_r8,2.6544e+01_r8/)
      kao(:,12, 7) = (/ &
     &2.0930e+01_r8,2.1372e+01_r8,2.1863e+01_r8,2.2353e+01_r8,2.2822e+01_r8/)
      kao(:,13, 7) = (/ &
     &1.7993e+01_r8,1.8373e+01_r8,1.8772e+01_r8,1.9157e+01_r8,1.9544e+01_r8/)
      kao(:, 1, 8) = (/ &
     &2.1856e+02_r8,2.1566e+02_r8,2.1284e+02_r8,2.0997e+02_r8,2.0718e+02_r8/)
      kao(:, 2, 8) = (/ &
     &2.0300e+02_r8,2.0022e+02_r8,1.9750e+02_r8,1.9481e+02_r8,1.9235e+02_r8/)
      kao(:, 3, 8) = (/ &
     &1.8584e+02_r8,1.8317e+02_r8,1.8063e+02_r8,1.7831e+02_r8,1.7621e+02_r8/)
      kao(:, 4, 8) = (/ &
     &1.6761e+02_r8,1.6519e+02_r8,1.6298e+02_r8,1.6101e+02_r8,1.5981e+02_r8/)
      kao(:, 5, 8) = (/ &
     &1.4928e+02_r8,1.4711e+02_r8,1.4522e+02_r8,1.4425e+02_r8,1.4420e+02_r8/)
      kao(:, 6, 8) = (/ &
     &1.3122e+02_r8,1.2933e+02_r8,1.2822e+02_r8,1.2825e+02_r8,1.2918e+02_r8/)
      kao(:, 7, 8) = (/ &
     &1.1410e+02_r8,1.1264e+02_r8,1.1239e+02_r8,1.1324e+02_r8,1.1505e+02_r8/)
      kao(:, 8, 8) = (/ &
     &9.8348e+01_r8,9.7493e+01_r8,9.7940e+01_r8,9.9442e+01_r8,1.0191e+02_r8/)
      kao(:, 9, 8) = (/ &
     &8.4647e+01_r8,8.4268e+01_r8,8.5204e+01_r8,8.7179e+01_r8,9.0023e+01_r8/)
      kao(:,10, 8) = (/ &
     &7.3021e+01_r8,7.3118e+01_r8,7.4447e+01_r8,7.6754e+01_r8,7.9414e+01_r8/)
      kao(:,11, 8) = (/ &
     &6.3300e+01_r8,6.4312e+01_r8,6.6319e+01_r8,6.8546e+01_r8,7.0686e+01_r8/)
      kao(:,12, 8) = (/ &
     &5.5501e+01_r8,5.7093e+01_r8,5.8983e+01_r8,6.0787e+01_r8,6.2564e+01_r8/)
      kao(:,13, 8) = (/ &
     &4.8706e+01_r8,5.0287e+01_r8,5.1813e+01_r8,5.3328e+01_r8,5.4791e+01_r8/)
      kao(:, 1, 9) = (/ &
     &5.5934e+02_r8,5.5574e+02_r8,5.5144e+02_r8,5.4673e+02_r8,5.4155e+02_r8/)
      kao(:, 2, 9) = (/ &
     &5.7946e+02_r8,5.7510e+02_r8,5.7015e+02_r8,5.6485e+02_r8,5.5885e+02_r8/)
      kao(:, 3, 9) = (/ &
     &5.9076e+02_r8,5.8577e+02_r8,5.8036e+02_r8,5.7428e+02_r8,5.6790e+02_r8/)
      kao(:, 4, 9) = (/ &
     &5.9122e+02_r8,5.8578e+02_r8,5.7964e+02_r8,5.7332e+02_r8,5.6635e+02_r8/)
      kao(:, 5, 9) = (/ &
     &5.8028e+02_r8,5.7411e+02_r8,5.6769e+02_r8,5.6068e+02_r8,5.5353e+02_r8/)
      kao(:, 6, 9) = (/ &
     &5.5962e+02_r8,5.5294e+02_r8,5.4600e+02_r8,5.3888e+02_r8,5.3142e+02_r8/)
      kao(:, 7, 9) = (/ &
     &5.2985e+02_r8,5.2302e+02_r8,5.1578e+02_r8,5.0845e+02_r8,5.0105e+02_r8/)
      kao(:, 8, 9) = (/ &
     &4.9277e+02_r8,4.8554e+02_r8,4.7838e+02_r8,4.7112e+02_r8,4.6381e+02_r8/)
      kao(:, 9, 9) = (/ &
     &4.5092e+02_r8,4.4373e+02_r8,4.3650e+02_r8,4.2952e+02_r8,4.2278e+02_r8/)
      kao(:,10, 9) = (/ &
     &4.0542e+02_r8,3.9841e+02_r8,3.9162e+02_r8,3.8505e+02_r8,3.7968e+02_r8/)
      kao(:,11, 9) = (/ &
     &3.5669e+02_r8,3.5010e+02_r8,3.4395e+02_r8,3.3923e+02_r8,3.3643e+02_r8/)
      kao(:,12, 9) = (/ &
     &3.0992e+02_r8,3.0411e+02_r8,2.9975e+02_r8,2.9742e+02_r8,2.9692e+02_r8/)
      kao(:,13, 9) = (/ &
     &2.6703e+02_r8,2.6279e+02_r8,2.6062e+02_r8,2.6039e+02_r8,2.6194e+02_r8/)
      kao(:, 1,10) = (/ &
     &9.5667e+02_r8,9.5651e+02_r8,9.5375e+02_r8,9.4993e+02_r8,9.4458e+02_r8/)
      kao(:, 2,10) = (/ &
     &1.0737e+03_r8,1.0712e+03_r8,1.0675e+03_r8,1.0621e+03_r8,1.0554e+03_r8/)
      kao(:, 3,10) = (/ &
     &1.1862e+03_r8,1.1837e+03_r8,1.1793e+03_r8,1.1732e+03_r8,1.1657e+03_r8/)
      kao(:, 4,10) = (/ &
     &1.2923e+03_r8,1.2885e+03_r8,1.2837e+03_r8,1.2762e+03_r8,1.2683e+03_r8/)
      kao(:, 5,10) = (/ &
     &1.3860e+03_r8,1.3831e+03_r8,1.3760e+03_r8,1.3692e+03_r8,1.3583e+03_r8/)
      kao(:, 6,10) = (/ &
     &1.4574e+03_r8,1.4515e+03_r8,1.4451e+03_r8,1.4344e+03_r8,1.4246e+03_r8/)
      kao(:, 7,10) = (/ &
     &1.5032e+03_r8,1.4948e+03_r8,1.4847e+03_r8,1.4737e+03_r8,1.4593e+03_r8/)
      kao(:, 8,10) = (/ &
     &1.5178e+03_r8,1.5093e+03_r8,1.4967e+03_r8,1.4828e+03_r8,1.4689e+03_r8/)
      kao(:, 9,10) = (/ &
     &1.5009e+03_r8,1.4874e+03_r8,1.4751e+03_r8,1.4596e+03_r8,1.4422e+03_r8/)
      kao(:,10,10) = (/ &
     &1.4526e+03_r8,1.4382e+03_r8,1.4207e+03_r8,1.4042e+03_r8,1.3871e+03_r8/)
      kao(:,11,10) = (/ &
     &1.3669e+03_r8,1.3492e+03_r8,1.3313e+03_r8,1.3144e+03_r8,1.2952e+03_r8/)
      kao(:,12,10) = (/ &
     &1.2561e+03_r8,1.2377e+03_r8,1.2201e+03_r8,1.2021e+03_r8,1.1826e+03_r8/)
      kao(:,13,10) = (/ &
     &1.1367e+03_r8,1.1187e+03_r8,1.1007e+03_r8,1.0822e+03_r8,1.0635e+03_r8/)
      kao(:, 1,11) = (/ &
     &1.0788e+03_r8,1.0784e+03_r8,1.0786e+03_r8,1.0769e+03_r8,1.0720e+03_r8/)
      kao(:, 2,11) = (/ &
     &1.2360e+03_r8,1.2387e+03_r8,1.2382e+03_r8,1.2346e+03_r8,1.2287e+03_r8/)
      kao(:, 3,11) = (/ &
     &1.4028e+03_r8,1.4050e+03_r8,1.4041e+03_r8,1.4005e+03_r8,1.3939e+03_r8/)
      kao(:, 4,11) = (/ &
     &1.5761e+03_r8,1.5770e+03_r8,1.5755e+03_r8,1.5691e+03_r8,1.5622e+03_r8/)
      kao(:, 5,11) = (/ &
     &1.7429e+03_r8,1.7443e+03_r8,1.7409e+03_r8,1.7348e+03_r8,1.7262e+03_r8/)
      kao(:, 6,11) = (/ &
     &1.9004e+03_r8,1.9007e+03_r8,1.8945e+03_r8,1.8893e+03_r8,1.8776e+03_r8/)
      kao(:, 7,11) = (/ &
     &2.0382e+03_r8,2.0344e+03_r8,2.0314e+03_r8,2.0213e+03_r8,2.0121e+03_r8/)
      kao(:, 8,11) = (/ &
     &2.1442e+03_r8,2.1390e+03_r8,2.1319e+03_r8,2.1222e+03_r8,2.1076e+03_r8/)
      kao(:, 9,11) = (/ &
     &2.2113e+03_r8,2.2063e+03_r8,2.1931e+03_r8,2.1796e+03_r8,2.1631e+03_r8/)
      kao(:,10,11) = (/ &
     &2.2360e+03_r8,2.2231e+03_r8,2.2114e+03_r8,2.1930e+03_r8,2.1737e+03_r8/)
      kao(:,11,11) = (/ &
     &2.2031e+03_r8,2.1887e+03_r8,2.1696e+03_r8,2.1476e+03_r8,2.1259e+03_r8/)
      kao(:,12,11) = (/ &
     &2.1236e+03_r8,2.1030e+03_r8,2.0791e+03_r8,2.0554e+03_r8,2.0303e+03_r8/)
      kao(:,13,11) = (/ &
     &1.9976e+03_r8,1.9732e+03_r8,1.9489e+03_r8,1.9244e+03_r8,1.8976e+03_r8/)
      kao(:, 1,12) = (/ &
     &1.1934e+03_r8,1.1955e+03_r8,1.1958e+03_r8,1.1936e+03_r8,1.1920e+03_r8/)
      kao(:, 2,12) = (/ &
     &1.3945e+03_r8,1.3970e+03_r8,1.3984e+03_r8,1.3987e+03_r8,1.3979e+03_r8/)
      kao(:, 3,12) = (/ &
     &1.6215e+03_r8,1.6249e+03_r8,1.6252e+03_r8,1.6264e+03_r8,1.6242e+03_r8/)
      kao(:, 4,12) = (/ &
     &1.8681e+03_r8,1.8729e+03_r8,1.8755e+03_r8,1.8766e+03_r8,1.8729e+03_r8/)
      kao(:, 5,12) = (/ &
     &2.1302e+03_r8,2.1346e+03_r8,2.1412e+03_r8,2.1410e+03_r8,2.1383e+03_r8/)
      kao(:, 6,12) = (/ &
     &2.4029e+03_r8,2.4115e+03_r8,2.4156e+03_r8,2.4143e+03_r8,2.4101e+03_r8/)
      kao(:, 7,12) = (/ &
     &2.6748e+03_r8,2.6869e+03_r8,2.6879e+03_r8,2.6884e+03_r8,2.6793e+03_r8/)
      kao(:, 8,12) = (/ &
     &2.9380e+03_r8,2.9477e+03_r8,2.9496e+03_r8,2.9469e+03_r8,2.9380e+03_r8/)
      kao(:, 9,12) = (/ &
     &3.1781e+03_r8,3.1822e+03_r8,3.1866e+03_r8,3.1790e+03_r8,3.1694e+03_r8/)
      kao(:,10,12) = (/ &
     &3.3770e+03_r8,3.3808e+03_r8,3.3765e+03_r8,3.3686e+03_r8,3.3530e+03_r8/)
      kao(:,11,12) = (/ &
     &3.5189e+03_r8,3.5130e+03_r8,3.5038e+03_r8,3.4874e+03_r8,3.4673e+03_r8/)
      kao(:,12,12) = (/ &
     &3.5908e+03_r8,3.5789e+03_r8,3.5609e+03_r8,3.5388e+03_r8,3.5103e+03_r8/)
      kao(:,13,12) = (/ &
     &3.5806e+03_r8,3.5582e+03_r8,3.5338e+03_r8,3.5034e+03_r8,3.4725e+03_r8/)
      kao(:, 1,13) = (/ &
     &1.2919e+03_r8,1.2953e+03_r8,1.2979e+03_r8,1.2980e+03_r8,1.2956e+03_r8/)
      kao(:, 2,13) = (/ &
     &1.5383e+03_r8,1.5420e+03_r8,1.5447e+03_r8,1.5440e+03_r8,1.5420e+03_r8/)
      kao(:, 3,13) = (/ &
     &1.8220e+03_r8,1.8287e+03_r8,1.8322e+03_r8,1.8325e+03_r8,1.8308e+03_r8/)
      kao(:, 4,13) = (/ &
     &2.1443e+03_r8,2.1550e+03_r8,2.1609e+03_r8,2.1623e+03_r8,2.1617e+03_r8/)
      kao(:, 5,13) = (/ &
     &2.5123e+03_r8,2.5251e+03_r8,2.5330e+03_r8,2.5368e+03_r8,2.5365e+03_r8/)
      kao(:, 6,13) = (/ &
     &2.9214e+03_r8,2.9360e+03_r8,2.9475e+03_r8,2.9537e+03_r8,2.9558e+03_r8/)
      kao(:, 7,13) = (/ &
     &3.3684e+03_r8,3.3871e+03_r8,3.4024e+03_r8,3.4082e+03_r8,3.4125e+03_r8/)
      kao(:, 8,13) = (/ &
     &3.8472e+03_r8,3.8701e+03_r8,3.8882e+03_r8,3.8980e+03_r8,3.9031e+03_r8/)
      kao(:, 9,13) = (/ &
     &4.3463e+03_r8,4.3744e+03_r8,4.3907e+03_r8,4.4045e+03_r8,4.4088e+03_r8/)
      kao(:,10,13) = (/ &
     &4.8548e+03_r8,4.8861e+03_r8,4.9050e+03_r8,4.9166e+03_r8,4.9195e+03_r8/)
      kao(:,11,13) = (/ &
     &5.3685e+03_r8,5.3944e+03_r8,5.4093e+03_r8,5.4165e+03_r8,5.4085e+03_r8/)
      kao(:,12,13) = (/ &
     &5.8390e+03_r8,5.8545e+03_r8,5.8642e+03_r8,5.8596e+03_r8,5.8502e+03_r8/)
      kao(:,13,13) = (/ &
     &6.2371e+03_r8,6.2518e+03_r8,6.2489e+03_r8,6.2389e+03_r8,6.2163e+03_r8/)
      kao(:, 1,14) = (/ &
     &1.3744e+03_r8,1.3784e+03_r8,1.3801e+03_r8,1.3822e+03_r8,1.3833e+03_r8/)
      kao(:, 2,14) = (/ &
     &1.6525e+03_r8,1.6579e+03_r8,1.6603e+03_r8,1.6628e+03_r8,1.6635e+03_r8/)
      kao(:, 3,14) = (/ &
     &1.9810e+03_r8,1.9908e+03_r8,1.9968e+03_r8,2.0006e+03_r8,2.0007e+03_r8/)
      kao(:, 4,14) = (/ &
     &2.3728e+03_r8,2.3844e+03_r8,2.3938e+03_r8,2.4019e+03_r8,2.4042e+03_r8/)
      kao(:, 5,14) = (/ &
     &2.8373e+03_r8,2.8532e+03_r8,2.8650e+03_r8,2.8745e+03_r8,2.8783e+03_r8/)
      kao(:, 6,14) = (/ &
     &3.3748e+03_r8,3.3991e+03_r8,3.4179e+03_r8,3.4320e+03_r8,3.4378e+03_r8/)
      kao(:, 7,14) = (/ &
     &3.9998e+03_r8,4.0298e+03_r8,4.0539e+03_r8,4.0746e+03_r8,4.0866e+03_r8/)
      kao(:, 8,14) = (/ &
     &4.7196e+03_r8,4.7615e+03_r8,4.7914e+03_r8,4.8146e+03_r8,4.8273e+03_r8/)
      kao(:, 9,14) = (/ &
     &5.5304e+03_r8,5.5847e+03_r8,5.6275e+03_r8,5.6623e+03_r8,5.6782e+03_r8/)
      kao(:,10,14) = (/ &
     &6.4513e+03_r8,6.5110e+03_r8,6.5637e+03_r8,6.6030e+03_r8,6.6279e+03_r8/)
      kao(:,11,14) = (/ &
     &7.5126e+03_r8,7.5759e+03_r8,7.6236e+03_r8,7.6577e+03_r8,7.6817e+03_r8/)
      kao(:,12,14) = (/ &
     &8.6584e+03_r8,8.7304e+03_r8,8.7796e+03_r8,8.8102e+03_r8,8.8235e+03_r8/)
      kao(:,13,14) = (/ &
     &9.8812e+03_r8,9.9499e+03_r8,9.9974e+03_r8,1.0022e+04_r8,1.0029e+04_r8/)
      kao(:, 1,15) = (/ &
     &1.4528e+03_r8,1.4581e+03_r8,1.4601e+03_r8,1.4582e+03_r8,1.4558e+03_r8/)
      kao(:, 2,15) = (/ &
     &1.7546e+03_r8,1.7631e+03_r8,1.7666e+03_r8,1.7671e+03_r8,1.7653e+03_r8/)
      kao(:, 3,15) = (/ &
     &2.1167e+03_r8,2.1275e+03_r8,2.1344e+03_r8,2.1393e+03_r8,2.1396e+03_r8/)
      kao(:, 4,15) = (/ &
     &2.5536e+03_r8,2.5679e+03_r8,2.5752e+03_r8,2.5829e+03_r8,2.5878e+03_r8/)
      kao(:, 5,15) = (/ &
     &3.0751e+03_r8,3.0964e+03_r8,3.1097e+03_r8,3.1178e+03_r8,3.1252e+03_r8/)
      kao(:, 6,15) = (/ &
     &3.6981e+03_r8,3.7293e+03_r8,3.7501e+03_r8,3.7620e+03_r8,3.7738e+03_r8/)
      kao(:, 7,15) = (/ &
     &4.4451e+03_r8,4.4852e+03_r8,4.5165e+03_r8,4.5355e+03_r8,4.5519e+03_r8/)
      kao(:, 8,15) = (/ &
     &5.3398e+03_r8,5.3890e+03_r8,5.4280e+03_r8,5.4575e+03_r8,5.4832e+03_r8/)
      kao(:, 9,15) = (/ &
     &6.4016e+03_r8,6.4666e+03_r8,6.5191e+03_r8,6.5509e+03_r8,6.5855e+03_r8/)
      kao(:,10,15) = (/ &
     &7.6539e+03_r8,7.7451e+03_r8,7.8138e+03_r8,7.8602e+03_r8,7.8961e+03_r8/)
      kao(:,11,15) = (/ &
     &9.1780e+03_r8,9.2834e+03_r8,9.3652e+03_r8,9.4242e+03_r8,9.4602e+03_r8/)
      kao(:,12,15) = (/ &
     &1.0986e+04_r8,1.1091e+04_r8,1.1175e+04_r8,1.1241e+04_r8,1.1280e+04_r8/)
      kao(:,13,15) = (/ &
     &1.3095e+04_r8,1.3203e+04_r8,1.3280e+04_r8,1.3335e+04_r8,1.3364e+04_r8/)
      kao(:, 1,16) = (/ &
     &1.4758e+03_r8,1.4811e+03_r8,1.4822e+03_r8,1.4873e+03_r8,1.4919e+03_r8/)
      kao(:, 2,16) = (/ &
     &1.7931e+03_r8,1.7988e+03_r8,1.8023e+03_r8,1.8054e+03_r8,1.8115e+03_r8/)
      kao(:, 3,16) = (/ &
     &2.1801e+03_r8,2.1858e+03_r8,2.1915e+03_r8,2.1950e+03_r8,2.1996e+03_r8/)
      kao(:, 4,16) = (/ &
     &2.6497e+03_r8,2.6575e+03_r8,2.6648e+03_r8,2.6696e+03_r8,2.6752e+03_r8/)
      kao(:, 5,16) = (/ &
     &3.2162e+03_r8,3.2298e+03_r8,3.2415e+03_r8,3.2482e+03_r8,3.2542e+03_r8/)
      kao(:, 6,16) = (/ &
     &3.8965e+03_r8,3.9207e+03_r8,3.9398e+03_r8,3.9520e+03_r8,3.9556e+03_r8/)
      kao(:, 7,16) = (/ &
     &4.7145e+03_r8,4.7502e+03_r8,4.7821e+03_r8,4.8036e+03_r8,4.8122e+03_r8/)
      kao(:, 8,16) = (/ &
     &5.7091e+03_r8,5.7519e+03_r8,5.7946e+03_r8,5.8300e+03_r8,5.8477e+03_r8/)
      kao(:, 9,16) = (/ &
     &6.9081e+03_r8,6.9691e+03_r8,7.0079e+03_r8,7.0618e+03_r8,7.0936e+03_r8/)
      kao(:,10,16) = (/ &
     &8.3531e+03_r8,8.4377e+03_r8,8.4862e+03_r8,8.5388e+03_r8,8.5857e+03_r8/)
      kao(:,11,16) = (/ &
     &1.0140e+04_r8,1.0233e+04_r8,1.0291e+04_r8,1.0344e+04_r8,1.0381e+04_r8/)
      kao(:,12,16) = (/ &
     &1.2278e+04_r8,1.2376e+04_r8,1.2452e+04_r8,1.2503e+04_r8,1.2519e+04_r8/)
      kao(:,13,16) = (/ &
     &1.4816e+04_r8,1.4930e+04_r8,1.5014e+04_r8,1.5052e+04_r8,1.5044e+04_r8/)

!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

      kbo(:,13, 1) = (/ &
     &3.9228e-02_r8,4.0055e-02_r8,4.1480e-02_r8,4.3734e-02_r8,4.6826e-02_r8/)
      kbo(:,14, 1) = (/ &
     &3.2541e-02_r8,3.3340e-02_r8,3.4715e-02_r8,3.6769e-02_r8,3.9564e-02_r8/)
      kbo(:,15, 1) = (/ &
     &2.6969e-02_r8,2.7753e-02_r8,2.9038e-02_r8,3.0896e-02_r8,3.3356e-02_r8/)
      kbo(:,16, 1) = (/ &
     &2.2342e-02_r8,2.3099e-02_r8,2.4270e-02_r8,2.5925e-02_r8,2.8078e-02_r8/)
      kbo(:,17, 1) = (/ &
     &1.8513e-02_r8,1.9222e-02_r8,2.0267e-02_r8,2.1721e-02_r8,2.3597e-02_r8/)
      kbo(:,18, 1) = (/ &
     &1.5353e-02_r8,1.5989e-02_r8,1.6916e-02_r8,1.8172e-02_r8,1.9812e-02_r8/)
      kbo(:,19, 1) = (/ &
     &1.2730e-02_r8,1.3292e-02_r8,1.4104e-02_r8,1.5198e-02_r8,1.6633e-02_r8/)
      kbo(:,20, 1) = (/ &
     &1.0558e-02_r8,1.1059e-02_r8,1.1764e-02_r8,1.2725e-02_r8,1.3995e-02_r8/)
      kbo(:,21, 1) = (/ &
     &8.7555e-03_r8,9.1943e-03_r8,9.8141e-03_r8,1.0663e-02_r8,1.1783e-02_r8/)
      kbo(:,22, 1) = (/ &
     &7.2788e-03_r8,7.6721e-03_r8,8.2312e-03_r8,8.9953e-03_r8,1.0002e-02_r8/)
      kbo(:,23, 1) = (/ &
     &6.0534e-03_r8,6.4084e-03_r8,6.9154e-03_r8,7.6052e-03_r8,8.5112e-03_r8/)
      kbo(:,24, 1) = (/ &
     &5.0381e-03_r8,5.3630e-03_r8,5.8249e-03_r8,6.4486e-03_r8,7.2625e-03_r8/)
      kbo(:,25, 1) = (/ &
     &4.2012e-03_r8,4.4994e-03_r8,4.9231e-03_r8,5.4862e-03_r8,6.2185e-03_r8/)
      kbo(:,26, 1) = (/ &
     &3.5140e-03_r8,3.7917e-03_r8,4.1803e-03_r8,4.6907e-03_r8,5.3531e-03_r8/)
      kbo(:,27, 1) = (/ &
     &2.9461e-03_r8,3.2058e-03_r8,3.5595e-03_r8,4.0238e-03_r8,4.6243e-03_r8/)
      kbo(:,28, 1) = (/ &
     &2.4782e-03_r8,2.7200e-03_r8,3.0408e-03_r8,3.4639e-03_r8,4.0087e-03_r8/)
      kbo(:,29, 1) = (/ &
     &2.0935e-03_r8,2.3161e-03_r8,2.6092e-03_r8,2.9949e-03_r8,3.4943e-03_r8/)
      kbo(:,30, 1) = (/ &
     &1.7747e-03_r8,1.9777e-03_r8,2.2475e-03_r8,2.5999e-03_r8,3.0591e-03_r8/)
      kbo(:,31, 1) = (/ &
     &1.5106e-03_r8,1.6973e-03_r8,1.9445e-03_r8,2.2691e-03_r8,2.6924e-03_r8/)
      kbo(:,32, 1) = (/ &
     &1.2905e-03_r8,1.4629e-03_r8,1.6903e-03_r8,1.9914e-03_r8,2.3817e-03_r8/)
      kbo(:,33, 1) = (/ &
     &1.1070e-03_r8,1.2664e-03_r8,1.4773e-03_r8,1.7562e-03_r8,2.1183e-03_r8/)
      kbo(:,34, 1) = (/ &
     &9.4969e-04_r8,1.0951e-03_r8,1.2897e-03_r8,1.5465e-03_r8,1.8794e-03_r8/)
      kbo(:,35, 1) = (/ &
     &8.0650e-04_r8,9.3657e-04_r8,1.1113e-03_r8,1.3423e-03_r8,1.6411e-03_r8/)
      kbo(:,36, 1) = (/ &
     &6.7527e-04_r8,7.8828e-04_r8,9.4082e-04_r8,1.1424e-03_r8,1.4040e-03_r8/)
      kbo(:,37, 1) = (/ &
     &5.5374e-04_r8,6.4781e-04_r8,7.7522e-04_r8,9.4463e-04_r8,1.1654e-03_r8/)
      kbo(:,38, 1) = (/ &
     &4.5356e-04_r8,5.3144e-04_r8,6.3765e-04_r8,7.7978e-04_r8,9.6558e-04_r8/)
      kbo(:,39, 1) = (/ &
     &3.7155e-04_r8,4.3614e-04_r8,5.2472e-04_r8,6.4387e-04_r8,8.0047e-04_r8/)
      kbo(:,40, 1) = (/ &
     &2.9980e-04_r8,3.5165e-04_r8,4.2320e-04_r8,5.2024e-04_r8,6.4874e-04_r8/)
      kbo(:,41, 1) = (/ &
     &2.4145e-04_r8,2.8281e-04_r8,3.4028e-04_r8,4.1898e-04_r8,5.2376e-04_r8/)
      kbo(:,42, 1) = (/ &
     &1.9444e-04_r8,2.2740e-04_r8,2.7348e-04_r8,3.3721e-04_r8,4.2264e-04_r8/)
      kbo(:,43, 1) = (/ &
     &1.5533e-04_r8,1.8108e-04_r8,2.1726e-04_r8,2.6787e-04_r8,3.3649e-04_r8/)
      kbo(:,44, 1) = (/ &
     &1.2372e-04_r8,1.4362e-04_r8,1.7176e-04_r8,2.1151e-04_r8,2.6597e-04_r8/)
      kbo(:,45, 1) = (/ &
     &9.8615e-05_r8,1.1395e-04_r8,1.3575e-04_r8,1.6686e-04_r8,2.0989e-04_r8/)
      kbo(:,46, 1) = (/ &
     &7.8410e-05_r8,9.0146e-05_r8,1.0684e-04_r8,1.3092e-04_r8,1.6455e-04_r8/)
      kbo(:,47, 1) = (/ &
     &6.2111e-05_r8,7.0925e-05_r8,8.3491e-05_r8,1.0171e-04_r8,1.2752e-04_r8/)
      kbo(:,48, 1) = (/ &
     &4.9292e-05_r8,5.5878e-05_r8,6.5308e-05_r8,7.9022e-05_r8,9.8758e-05_r8/)
      kbo(:,49, 1) = (/ &
     &3.9189e-05_r8,4.4083e-05_r8,5.1134e-05_r8,6.1433e-05_r8,7.6433e-05_r8/)
      kbo(:,50, 1) = (/ &
     &3.1297e-05_r8,3.4944e-05_r8,4.0262e-05_r8,4.8024e-05_r8,5.9468e-05_r8/)
      kbo(:,51, 1) = (/ &
     &2.5040e-05_r8,2.7793e-05_r8,3.1794e-05_r8,3.7665e-05_r8,4.6363e-05_r8/)
      kbo(:,52, 1) = (/ &
     &2.0024e-05_r8,2.2137e-05_r8,2.5151e-05_r8,2.9572e-05_r8,3.6157e-05_r8/)
      kbo(:,53, 1) = (/ &
     &1.5989e-05_r8,1.7662e-05_r8,1.9908e-05_r8,2.3247e-05_r8,2.8202e-05_r8/)
      kbo(:,54, 1) = (/ &
     &1.2802e-05_r8,1.4140e-05_r8,1.5857e-05_r8,1.8384e-05_r8,2.2160e-05_r8/)
      kbo(:,55, 1) = (/ &
     &1.0251e-05_r8,1.1335e-05_r8,1.2664e-05_r8,1.4589e-05_r8,1.7471e-05_r8/)
      kbo(:,56, 1) = (/ &
     &8.1863e-06_r8,9.0810e-06_r8,1.0125e-05_r8,1.1592e-05_r8,1.3791e-05_r8/)
      kbo(:,57, 1) = (/ &
     &6.5183e-06_r8,7.2717e-06_r8,8.0938e-06_r8,9.2169e-06_r8,1.0895e-05_r8/)
      kbo(:,58, 1) = (/ &
     &5.1879e-06_r8,5.8228e-06_r8,6.4835e-06_r8,7.3485e-06_r8,8.6418e-06_r8/)
      kbo(:,59, 1) = (/ &
     &4.2168e-06_r8,4.7498e-06_r8,5.3015e-06_r8,6.0144e-06_r8,7.0853e-06_r8/)
      kbo(:,13, 2) = (/ &
     &1.3654e-01_r8,1.5163e-01_r8,1.6956e-01_r8,1.9071e-01_r8,2.1617e-01_r8/)
      kbo(:,14, 2) = (/ &
     &1.1559e-01_r8,1.2885e-01_r8,1.4454e-01_r8,1.6328e-01_r8,1.8606e-01_r8/)
      kbo(:,15, 2) = (/ &
     &9.7693e-02_r8,1.0924e-01_r8,1.2296e-01_r8,1.3968e-01_r8,1.6004e-01_r8/)
      kbo(:,16, 2) = (/ &
     &8.2470e-02_r8,9.2497e-02_r8,1.0461e-01_r8,1.1951e-01_r8,1.3759e-01_r8/)
      kbo(:,17, 2) = (/ &
     &6.9485e-02_r8,7.8236e-02_r8,8.9019e-02_r8,1.0217e-01_r8,1.1819e-01_r8/)
      kbo(:,18, 2) = (/ &
     &5.8434e-02_r8,6.6177e-02_r8,7.5740e-02_r8,8.7380e-02_r8,1.0143e-01_r8/)
      kbo(:,19, 2) = (/ &
     &4.9105e-02_r8,5.5950e-02_r8,6.4367e-02_r8,7.4577e-02_r8,8.6834e-02_r8/)
      kbo(:,20, 2) = (/ &
     &4.1358e-02_r8,4.7392e-02_r8,5.4755e-02_r8,6.3671e-02_r8,7.4385e-02_r8/)
      kbo(:,21, 2) = (/ &
     &3.4862e-02_r8,4.0138e-02_r8,4.6538e-02_r8,5.4275e-02_r8,6.3577e-02_r8/)
      kbo(:,22, 2) = (/ &
     &2.9678e-02_r8,3.4317e-02_r8,3.9913e-02_r8,4.6700e-02_r8,5.4863e-02_r8/)
      kbo(:,23, 2) = (/ &
     &2.5302e-02_r8,2.9357e-02_r8,3.4270e-02_r8,4.0209e-02_r8,4.7364e-02_r8/)
      kbo(:,24, 2) = (/ &
     &2.1615e-02_r8,2.5159e-02_r8,2.9473e-02_r8,3.4693e-02_r8,4.0992e-02_r8/)
      kbo(:,25, 2) = (/ &
     &1.8506e-02_r8,2.1620e-02_r8,2.5407e-02_r8,3.0032e-02_r8,3.5645e-02_r8/)
      kbo(:,26, 2) = (/ &
     &1.5911e-02_r8,1.8663e-02_r8,2.2016e-02_r8,2.6153e-02_r8,3.1176e-02_r8/)
      kbo(:,27, 2) = (/ &
     &1.3710e-02_r8,1.6139e-02_r8,1.9144e-02_r8,2.2842e-02_r8,2.7378e-02_r8/)
      kbo(:,28, 2) = (/ &
     &1.1834e-02_r8,1.3997e-02_r8,1.6695e-02_r8,2.0027e-02_r8,2.4111e-02_r8/)
      kbo(:,29, 2) = (/ &
     &1.0249e-02_r8,1.2190e-02_r8,1.4630e-02_r8,1.7647e-02_r8,2.1313e-02_r8/)
      kbo(:,30, 2) = (/ &
     &8.9036e-03_r8,1.0661e-02_r8,1.2868e-02_r8,1.5600e-02_r8,1.8888e-02_r8/)
      kbo(:,31, 2) = (/ &
     &7.7687e-03_r8,9.3699e-03_r8,1.1378e-02_r8,1.3839e-02_r8,1.6787e-02_r8/)
      kbo(:,32, 2) = (/ &
     &6.8140e-03_r8,8.2759e-03_r8,1.0101e-02_r8,1.2319e-02_r8,1.4958e-02_r8/)
      kbo(:,33, 2) = (/ &
     &6.0058e-03_r8,7.3417e-03_r8,8.9915e-03_r8,1.0990e-02_r8,1.3357e-02_r8/)
      kbo(:,34, 2) = (/ &
     &5.2812e-03_r8,6.4864e-03_r8,7.9715e-03_r8,9.7608e-03_r8,1.1880e-02_r8/)
      kbo(:,35, 2) = (/ &
     &4.5664e-03_r8,5.6316e-03_r8,6.9402e-03_r8,8.5171e-03_r8,1.0395e-02_r8/)
      kbo(:,36, 2) = (/ &
     &3.8650e-03_r8,4.7853e-03_r8,5.9182e-03_r8,7.2844e-03_r8,8.9146e-03_r8/)
      kbo(:,37, 2) = (/ &
     &3.1698e-03_r8,3.9391e-03_r8,4.8941e-03_r8,6.0480e-03_r8,7.4275e-03_r8/)
      kbo(:,38, 2) = (/ &
     &2.5939e-03_r8,3.2378e-03_r8,4.0393e-03_r8,5.0137e-03_r8,6.1786e-03_r8/)
      kbo(:,39, 2) = (/ &
     &2.1228e-03_r8,2.6601e-03_r8,3.3343e-03_r8,4.1558e-03_r8,5.1416e-03_r8/)
      kbo(:,40, 2) = (/ &
     &1.6967e-03_r8,2.1355e-03_r8,2.6888e-03_r8,3.3677e-03_r8,4.1883e-03_r8/)
      kbo(:,41, 2) = (/ &
     &1.3505e-03_r8,1.7067e-03_r8,2.1592e-03_r8,2.7184e-03_r8,3.3988e-03_r8/)
      kbo(:,42, 2) = (/ &
     &1.0736e-03_r8,1.3626e-03_r8,1.7319e-03_r8,2.1915e-03_r8,2.7553e-03_r8/)
      kbo(:,43, 2) = (/ &
     &8.4090e-04_r8,1.0714e-03_r8,1.3684e-03_r8,1.7414e-03_r8,2.2023e-03_r8/)
      kbo(:,44, 2) = (/ &
     &6.5390e-04_r8,8.3586e-04_r8,1.0728e-03_r8,1.3727e-03_r8,1.7466e-03_r8/)
      kbo(:,45, 2) = (/ &
     &5.0782e-04_r8,6.5105e-04_r8,8.3889e-04_r8,1.0793e-03_r8,1.3823e-03_r8/)
      kbo(:,46, 2) = (/ &
     &3.9179e-04_r8,5.0302e-04_r8,6.5132e-04_r8,8.4212e-04_r8,1.0854e-03_r8/)
      kbo(:,47, 2) = (/ &
     &2.9882e-04_r8,3.8363e-04_r8,4.9873e-04_r8,6.4829e-04_r8,8.4103e-04_r8/)
      kbo(:,48, 2) = (/ &
     &2.2778e-04_r8,2.9209e-04_r8,3.8081e-04_r8,4.9759e-04_r8,6.4942e-04_r8/)
      kbo(:,49, 2) = (/ &
     &1.7348e-04_r8,2.2201e-04_r8,2.8994e-04_r8,3.8059e-04_r8,4.9968e-04_r8/)
      kbo(:,50, 2) = (/ &
     &1.3291e-04_r8,1.6970e-04_r8,2.2169e-04_r8,2.9250e-04_r8,3.8590e-04_r8/)
      kbo(:,51, 2) = (/ &
     &1.0207e-04_r8,1.2991e-04_r8,1.6972e-04_r8,2.2476e-04_r8,2.9809e-04_r8/)
      kbo(:,52, 2) = (/ &
     &7.8428e-05_r8,9.9370e-05_r8,1.2969e-04_r8,1.7236e-04_r8,2.2955e-04_r8/)
      kbo(:,53, 2) = (/ &
     &6.0320e-05_r8,7.5906e-05_r8,9.8948e-05_r8,1.3170e-04_r8,1.7631e-04_r8/)
      kbo(:,54, 2) = (/ &
     &4.6701e-05_r8,5.8457e-05_r8,7.5987e-05_r8,1.0130e-04_r8,1.3626e-04_r8/)
      kbo(:,55, 2) = (/ &
     &3.6311e-05_r8,4.5177e-05_r8,5.8536e-05_r8,7.8091e-05_r8,1.0548e-04_r8/)
      kbo(:,56, 2) = (/ &
     &2.8265e-05_r8,3.4933e-05_r8,4.5042e-05_r8,6.0092e-05_r8,8.1465e-05_r8/)
      kbo(:,57, 2) = (/ &
     &2.2041e-05_r8,2.7013e-05_r8,3.4636e-05_r8,4.6160e-05_r8,6.2788e-05_r8/)
      kbo(:,58, 2) = (/ &
     &1.7267e-05_r8,2.0998e-05_r8,2.6754e-05_r8,3.5587e-05_r8,4.8495e-05_r8/)
      kbo(:,59, 2) = (/ &
     &1.3975e-05_r8,1.7004e-05_r8,2.1693e-05_r8,2.8956e-05_r8,3.9630e-05_r8/)
      kbo(:,13, 3) = (/ &
     &4.6584e-01_r8,5.5439e-01_r8,6.5378e-01_r8,7.6270e-01_r8,8.8077e-01_r8/)
      kbo(:,14, 3) = (/ &
     &4.0124e-01_r8,4.7657e-01_r8,5.6034e-01_r8,6.5177e-01_r8,7.5174e-01_r8/)
      kbo(:,15, 3) = (/ &
     &3.4513e-01_r8,4.0912e-01_r8,4.7944e-01_r8,5.5671e-01_r8,6.4124e-01_r8/)
      kbo(:,16, 3) = (/ &
     &2.9666e-01_r8,3.5062e-01_r8,4.0982e-01_r8,4.7509e-01_r8,5.4644e-01_r8/)
      kbo(:,17, 3) = (/ &
     &2.5400e-01_r8,2.9955e-01_r8,3.4952e-01_r8,4.0464e-01_r8,4.6504e-01_r8/)
      kbo(:,18, 3) = (/ &
     &2.1648e-01_r8,2.5489e-01_r8,2.9720e-01_r8,3.4406e-01_r8,3.9550e-01_r8/)
      kbo(:,19, 3) = (/ &
     &1.8385e-01_r8,2.1623e-01_r8,2.5204e-01_r8,2.9205e-01_r8,3.3599e-01_r8/)
      kbo(:,20, 3) = (/ &
     &1.5627e-01_r8,1.8359e-01_r8,2.1416e-01_r8,2.4849e-01_r8,2.8606e-01_r8/)
      kbo(:,21, 3) = (/ &
     &1.3276e-01_r8,1.5592e-01_r8,1.8216e-01_r8,2.1168e-01_r8,2.4388e-01_r8/)
      kbo(:,22, 3) = (/ &
     &1.1395e-01_r8,1.3395e-01_r8,1.5675e-01_r8,1.8217e-01_r8,2.0967e-01_r8/)
      kbo(:,23, 3) = (/ &
     &9.7815e-02_r8,1.1526e-01_r8,1.3514e-01_r8,1.5691e-01_r8,1.8033e-01_r8/)
      kbo(:,24, 3) = (/ &
     &8.4102e-02_r8,9.9408e-02_r8,1.1660e-01_r8,1.3523e-01_r8,1.5511e-01_r8/)
      kbo(:,25, 3) = (/ &
     &7.2584e-02_r8,8.5921e-02_r8,1.0065e-01_r8,1.1653e-01_r8,1.3347e-01_r8/)
      kbo(:,26, 3) = (/ &
     &6.2935e-02_r8,7.4476e-02_r8,8.7054e-02_r8,1.0059e-01_r8,1.1498e-01_r8/)
      kbo(:,27, 3) = (/ &
     &5.4628e-02_r8,6.4547e-02_r8,7.5255e-02_r8,8.6846e-02_r8,9.9043e-02_r8/)
      kbo(:,28, 3) = (/ &
     &4.7438e-02_r8,5.5913e-02_r8,6.5081e-02_r8,7.4969e-02_r8,8.5391e-02_r8/)
      kbo(:,29, 3) = (/ &
     &4.1247e-02_r8,4.8483e-02_r8,5.6377e-02_r8,6.4788e-02_r8,7.3775e-02_r8/)
      kbo(:,30, 3) = (/ &
     &3.5874e-02_r8,4.2080e-02_r8,4.8862e-02_r8,5.6085e-02_r8,6.3787e-02_r8/)
      kbo(:,31, 3) = (/ &
     &3.1224e-02_r8,3.6582e-02_r8,4.2396e-02_r8,4.8680e-02_r8,5.5240e-02_r8/)
      kbo(:,32, 3) = (/ &
     &2.7211e-02_r8,3.1854e-02_r8,3.6880e-02_r8,4.2315e-02_r8,4.7892e-02_r8/)
      kbo(:,33, 3) = (/ &
     &2.3744e-02_r8,2.7755e-02_r8,3.2147e-02_r8,3.6823e-02_r8,4.1518e-02_r8/)
      kbo(:,34, 3) = (/ &
     &2.0626e-02_r8,2.4111e-02_r8,2.7927e-02_r8,3.1884e-02_r8,3.5825e-02_r8/)
      kbo(:,35, 3) = (/ &
     &1.7661e-02_r8,2.0671e-02_r8,2.3952e-02_r8,2.7283e-02_r8,3.0580e-02_r8/)
      kbo(:,36, 3) = (/ &
     &1.4872e-02_r8,1.7453e-02_r8,2.0237e-02_r8,2.3045e-02_r8,2.5826e-02_r8/)
      kbo(:,37, 3) = (/ &
     &1.2231e-02_r8,1.4407e-02_r8,1.6754e-02_r8,1.9119e-02_r8,2.1470e-02_r8/)
      kbo(:,38, 3) = (/ &
     &1.0046e-02_r8,1.1883e-02_r8,1.3859e-02_r8,1.5852e-02_r8,1.7844e-02_r8/)
      kbo(:,39, 3) = (/ &
     &8.2562e-03_r8,9.8067e-03_r8,1.1470e-02_r8,1.3152e-02_r8,1.4841e-02_r8/)
      kbo(:,40, 3) = (/ &
     &6.6596e-03_r8,7.9555e-03_r8,9.3542e-03_r8,1.0774e-02_r8,1.2201e-02_r8/)
      kbo(:,41, 3) = (/ &
     &5.3569e-03_r8,6.4354e-03_r8,7.6095e-03_r8,8.8054e-03_r8,1.0012e-02_r8/)
      kbo(:,42, 3) = (/ &
     &4.3009e-03_r8,5.1973e-03_r8,6.1851e-03_r8,7.1918e-03_r8,8.2134e-03_r8/)
      kbo(:,43, 3) = (/ &
     &3.4093e-03_r8,4.1490e-03_r8,4.9732e-03_r8,5.8239e-03_r8,6.6848e-03_r8/)
      kbo(:,44, 3) = (/ &
     &2.6823e-03_r8,3.2897e-03_r8,3.9739e-03_r8,4.6907e-03_r8,5.4167e-03_r8/)
      kbo(:,45, 3) = (/ &
     &2.1046e-03_r8,2.6003e-03_r8,3.1662e-03_r8,3.7704e-03_r8,4.3820e-03_r8/)
      kbo(:,46, 3) = (/ &
     &1.6388e-03_r8,2.0403e-03_r8,2.5048e-03_r8,3.0127e-03_r8,3.5286e-03_r8/)
      kbo(:,47, 3) = (/ &
     &1.2595e-03_r8,1.5807e-03_r8,1.9580e-03_r8,2.3819e-03_r8,2.8168e-03_r8/)
      kbo(:,48, 3) = (/ &
     &9.6423e-04_r8,1.2197e-03_r8,1.5249e-03_r8,1.8746e-03_r8,2.2418e-03_r8/)
      kbo(:,49, 3) = (/ &
     &7.3527e-04_r8,9.3718e-04_r8,1.1821e-03_r8,1.4684e-03_r8,1.7777e-03_r8/)
      kbo(:,50, 3) = (/ &
     &5.6217e-04_r8,7.2217e-04_r8,9.1835e-04_r8,1.1512e-03_r8,1.4112e-03_r8/)
      kbo(:,51, 3) = (/ &
     &4.2967e-04_r8,5.5583e-04_r8,7.1300e-04_r8,9.0190e-04_r8,1.1184e-03_r8/)
      kbo(:,52, 3) = (/ &
     &3.2742e-04_r8,4.2631e-04_r8,5.5137e-04_r8,7.0406e-04_r8,8.8313e-04_r8/)
      kbo(:,53, 3) = (/ &
     &2.4868e-04_r8,3.2582e-04_r8,4.2465e-04_r8,5.4760e-04_r8,6.9409e-04_r8/)
      kbo(:,54, 3) = (/ &
     &1.8974e-04_r8,2.5027e-04_r8,3.2861e-04_r8,4.2756e-04_r8,5.4716e-04_r8/)
      kbo(:,55, 3) = (/ &
     &1.4494e-04_r8,1.9239e-04_r8,2.5442e-04_r8,3.3395e-04_r8,4.3136e-04_r8/)
      kbo(:,56, 3) = (/ &
     &1.1043e-04_r8,1.4756e-04_r8,1.9639e-04_r8,2.5993e-04_r8,3.3900e-04_r8/)
      kbo(:,57, 3) = (/ &
     &8.3928e-05_r8,1.1287e-04_r8,1.5113e-04_r8,2.0155e-04_r8,2.6555e-04_r8/)
      kbo(:,58, 3) = (/ &
     &6.4018e-05_r8,8.6477e-05_r8,1.1648e-04_r8,1.5666e-04_r8,2.0830e-04_r8/)
      kbo(:,59, 3) = (/ &
     &5.1497e-05_r8,6.9896e-05_r8,9.4663e-05_r8,1.2810e-04_r8,1.7150e-04_r8/)
      kbo(:,13, 4) = (/ &
     &1.7524e+00_r8,1.9492e+00_r8,2.1512e+00_r8,2.3564e+00_r8,2.5478e+00_r8/)
      kbo(:,14, 4) = (/ &
     &1.4772e+00_r8,1.6494e+00_r8,1.8280e+00_r8,2.0044e+00_r8,2.1600e+00_r8/)
      kbo(:,15, 4) = (/ &
     &1.2495e+00_r8,1.4008e+00_r8,1.5559e+00_r8,1.6974e+00_r8,1.8203e+00_r8/)
      kbo(:,16, 4) = (/ &
     &1.0605e+00_r8,1.1902e+00_r8,1.3172e+00_r8,1.4293e+00_r8,1.5280e+00_r8/)
      kbo(:,17, 4) = (/ &
     &8.9958e-01_r8,1.0068e+00_r8,1.1092e+00_r8,1.1993e+00_r8,1.2798e+00_r8/)
      kbo(:,18, 4) = (/ &
     &7.6135e-01_r8,8.4970e-01_r8,9.3198e-01_r8,1.0052e+00_r8,1.0709e+00_r8/)
      kbo(:,19, 4) = (/ &
     &6.4340e-01_r8,7.1592e-01_r8,7.8258e-01_r8,8.4177e-01_r8,8.9530e-01_r8/)
      kbo(:,20, 4) = (/ &
     &5.4418e-01_r8,6.0357e-01_r8,6.5718e-01_r8,7.0498e-01_r8,7.4918e-01_r8/)
      kbo(:,21, 4) = (/ &
     &4.5911e-01_r8,5.0742e-01_r8,5.5063e-01_r8,5.8988e-01_r8,6.2662e-01_r8/)
      kbo(:,22, 4) = (/ &
     &3.8906e-01_r8,4.2787e-01_r8,4.6285e-01_r8,4.9521e-01_r8,5.2615e-01_r8/)
      kbo(:,23, 4) = (/ &
     &3.2912e-01_r8,3.6040e-01_r8,3.8895e-01_r8,4.1593e-01_r8,4.4229e-01_r8/)
      kbo(:,24, 4) = (/ &
     &2.7830e-01_r8,3.0371e-01_r8,3.2729e-01_r8,3.5001e-01_r8,3.7213e-01_r8/)
      kbo(:,25, 4) = (/ &
     &2.3534e-01_r8,2.5620e-01_r8,2.7595e-01_r8,2.9506e-01_r8,3.1323e-01_r8/)
      kbo(:,26, 4) = (/ &
     &1.9937e-01_r8,2.1667e-01_r8,2.3330e-01_r8,2.4915e-01_r8,2.6395e-01_r8/)
      kbo(:,27, 4) = (/ &
     &1.6896e-01_r8,1.8346e-01_r8,1.9732e-01_r8,2.1038e-01_r8,2.2245e-01_r8/)
      kbo(:,28, 4) = (/ &
     &1.4324e-01_r8,1.5539e-01_r8,1.6686e-01_r8,1.7760e-01_r8,1.8754e-01_r8/)
      kbo(:,29, 4) = (/ &
     &1.2158e-01_r8,1.3162e-01_r8,1.4109e-01_r8,1.4990e-01_r8,1.5824e-01_r8/)
      kbo(:,30, 4) = (/ &
     &1.0319e-01_r8,1.1149e-01_r8,1.1927e-01_r8,1.2651e-01_r8,1.3374e-01_r8/)
      kbo(:,31, 4) = (/ &
     &8.7596e-02_r8,9.4445e-02_r8,1.0083e-01_r8,1.0683e-01_r8,1.1324e-01_r8/)
      kbo(:,32, 4) = (/ &
     &7.4371e-02_r8,7.9986e-02_r8,8.5218e-02_r8,9.0404e-02_r8,9.6151e-02_r8/)
      kbo(:,33, 4) = (/ &
     &6.3127e-02_r8,6.7754e-02_r8,7.2100e-02_r8,7.6670e-02_r8,8.1947e-02_r8/)
      kbo(:,34, 4) = (/ &
     &5.3448e-02_r8,5.7257e-02_r8,6.0976e-02_r8,6.5117e-02_r8,6.9920e-02_r8/)
      kbo(:,35, 4) = (/ &
     &4.4958e-02_r8,4.8132e-02_r8,5.1386e-02_r8,5.5110e-02_r8,5.9396e-02_r8/)
      kbo(:,36, 4) = (/ &
     &3.7535e-02_r8,4.0225e-02_r8,4.3084e-02_r8,4.6370e-02_r8,5.0142e-02_r8/)
      kbo(:,37, 4) = (/ &
     &3.1000e-02_r8,3.3296e-02_r8,3.5751e-02_r8,3.8593e-02_r8,4.1835e-02_r8/)
      kbo(:,38, 4) = (/ &
     &2.5584e-02_r8,2.7542e-02_r8,2.9661e-02_r8,3.2102e-02_r8,3.4896e-02_r8/)
      kbo(:,39, 4) = (/ &
     &2.1117e-02_r8,2.2790e-02_r8,2.4613e-02_r8,2.6708e-02_r8,2.9115e-02_r8/)
      kbo(:,40, 4) = (/ &
     &1.7285e-02_r8,1.8708e-02_r8,2.0253e-02_r8,2.2025e-02_r8,2.4072e-02_r8/)
      kbo(:,41, 4) = (/ &
     &1.4124e-02_r8,1.5332e-02_r8,1.6640e-02_r8,1.8138e-02_r8,1.9869e-02_r8/)
      kbo(:,42, 4) = (/ &
     &1.1535e-02_r8,1.2562e-02_r8,1.3665e-02_r8,1.4929e-02_r8,1.6393e-02_r8/)
      kbo(:,43, 4) = (/ &
     &9.3628e-03_r8,1.0238e-02_r8,1.1164e-02_r8,1.2221e-02_r8,1.3452e-02_r8/)
      kbo(:,44, 4) = (/ &
     &7.5734e-03_r8,8.3195e-03_r8,9.0965e-03_r8,9.9764e-03_r8,1.1001e-02_r8/)
      kbo(:,45, 4) = (/ &
     &6.1205e-03_r8,6.7536e-03_r8,7.4083e-03_r8,8.1381e-03_r8,8.9936e-03_r8/)
      kbo(:,46, 4) = (/ &
     &4.9262e-03_r8,5.4662e-03_r8,6.0165e-03_r8,6.6206e-03_r8,7.3272e-03_r8/)
      kbo(:,47, 4) = (/ &
     &3.9391e-03_r8,4.3970e-03_r8,4.8610e-03_r8,5.3580e-03_r8,5.9369e-03_r8/)
      kbo(:,48, 4) = (/ &
     &3.1403e-03_r8,3.5287e-03_r8,3.9210e-03_r8,4.3323e-03_r8,4.8039e-03_r8/)
      kbo(:,49, 4) = (/ &
     &2.4956e-03_r8,2.8254e-03_r8,3.1568e-03_r8,3.4981e-03_r8,3.8839e-03_r8/)
      kbo(:,50, 4) = (/ &
     &1.9828e-03_r8,2.2636e-03_r8,2.5424e-03_r8,2.8288e-03_r8,3.1441e-03_r8/)
      kbo(:,51, 4) = (/ &
     &1.5714e-03_r8,1.8113e-03_r8,2.0459e-03_r8,2.2868e-03_r8,2.5462e-03_r8/)
      kbo(:,52, 4) = (/ &
     &1.2395e-03_r8,1.4453e-03_r8,1.6428e-03_r8,1.8457e-03_r8,2.0598e-03_r8/)
      kbo(:,53, 4) = (/ &
     &9.7290e-04_r8,1.1497e-03_r8,1.3161e-03_r8,1.4871e-03_r8,1.6649e-03_r8/)
      kbo(:,54, 4) = (/ &
     &7.6445e-04_r8,9.1516e-04_r8,1.0560e-03_r8,1.2000e-03_r8,1.3484e-03_r8/)
      kbo(:,55, 4) = (/ &
     &5.9991e-04_r8,7.2766e-04_r8,8.4765e-04_r8,9.6806e-04_r8,1.0927e-03_r8/)
      kbo(:,56, 4) = (/ &
     &4.6862e-04_r8,5.7638e-04_r8,6.7857e-04_r8,7.7940e-04_r8,8.8453e-04_r8/)
      kbo(:,57, 4) = (/ &
     &3.6453e-04_r8,4.5447e-04_r8,5.4199e-04_r8,6.2645e-04_r8,7.1474e-04_r8/)
      kbo(:,58, 4) = (/ &
     &2.8389e-04_r8,3.5818e-04_r8,4.3272e-04_r8,5.0377e-04_r8,5.7789e-04_r8/)
      kbo(:,59, 4) = (/ &
     &2.3060e-04_r8,2.9282e-04_r8,3.5542e-04_r8,4.1534e-04_r8,4.7810e-04_r8/)
      kbo(:,13, 5) = (/ &
     &4.6094e+00_r8,4.6772e+00_r8,4.7246e+00_r8,4.7737e+00_r8,4.8549e+00_r8/)
      kbo(:,14, 5) = (/ &
     &3.8278e+00_r8,3.8806e+00_r8,3.9251e+00_r8,3.9810e+00_r8,4.0718e+00_r8/)
      kbo(:,15, 5) = (/ &
     &3.1722e+00_r8,3.2168e+00_r8,3.2634e+00_r8,3.3308e+00_r8,3.4210e+00_r8/)
      kbo(:,16, 5) = (/ &
     &2.6249e+00_r8,2.6705e+00_r8,2.7237e+00_r8,2.7913e+00_r8,2.8656e+00_r8/)
      kbo(:,17, 5) = (/ &
     &2.1764e+00_r8,2.2249e+00_r8,2.2741e+00_r8,2.3304e+00_r8,2.3919e+00_r8/)
      kbo(:,18, 5) = (/ &
     &1.8098e+00_r8,1.8520e+00_r8,1.8935e+00_r8,1.9392e+00_r8,1.9922e+00_r8/)
      kbo(:,19, 5) = (/ &
     &1.5044e+00_r8,1.5380e+00_r8,1.5723e+00_r8,1.6122e+00_r8,1.6588e+00_r8/)
      kbo(:,20, 5) = (/ &
     &1.2493e+00_r8,1.2764e+00_r8,1.3059e+00_r8,1.3405e+00_r8,1.3817e+00_r8/)
      kbo(:,21, 5) = (/ &
     &1.0373e+00_r8,1.0597e+00_r8,1.0855e+00_r8,1.1148e+00_r8,1.1513e+00_r8/)
      kbo(:,22, 5) = (/ &
     &8.6282e-01_r8,8.8188e-01_r8,9.0343e-01_r8,9.2979e-01_r8,9.6231e-01_r8/)
      kbo(:,23, 5) = (/ &
     &7.1704e-01_r8,7.3333e-01_r8,7.5232e-01_r8,7.7633e-01_r8,8.0551e-01_r8/)
      kbo(:,24, 5) = (/ &
     &5.9518e-01_r8,6.0940e-01_r8,6.2643e-01_r8,6.4862e-01_r8,6.7508e-01_r8/)
      kbo(:,25, 5) = (/ &
     &4.9422e-01_r8,5.0656e-01_r8,5.2248e-01_r8,5.4283e-01_r8,5.6739e-01_r8/)
      kbo(:,26, 5) = (/ &
     &4.1037e-01_r8,4.2180e-01_r8,4.3687e-01_r8,4.5588e-01_r8,4.7822e-01_r8/)
      kbo(:,27, 5) = (/ &
     &3.4124e-01_r8,3.5223e-01_r8,3.6648e-01_r8,3.8368e-01_r8,4.0379e-01_r8/)
      kbo(:,28, 5) = (/ &
     &2.8464e-01_r8,2.9501e-01_r8,3.0821e-01_r8,3.2362e-01_r8,3.4157e-01_r8/)
      kbo(:,29, 5) = (/ &
     &2.3808e-01_r8,2.4801e-01_r8,2.5984e-01_r8,2.7366e-01_r8,2.8965e-01_r8/)
      kbo(:,30, 5) = (/ &
     &1.9967e-01_r8,2.0890e-01_r8,2.1955e-01_r8,2.3198e-01_r8,2.4657e-01_r8/)
      kbo(:,31, 5) = (/ &
     &1.6792e-01_r8,1.7624e-01_r8,1.8593e-01_r8,1.9729e-01_r8,2.1071e-01_r8/)
      kbo(:,32, 5) = (/ &
     &1.4147e-01_r8,1.4902e-01_r8,1.5786e-01_r8,1.6833e-01_r8,1.8092e-01_r8/)
      kbo(:,33, 5) = (/ &
     &1.1942e-01_r8,1.2630e-01_r8,1.3442e-01_r8,1.4414e-01_r8,1.5600e-01_r8/)
      kbo(:,34, 5) = (/ &
     &1.0087e-01_r8,1.0707e-01_r8,1.1451e-01_r8,1.2366e-01_r8,1.3474e-01_r8/)
      kbo(:,35, 5) = (/ &
     &8.4860e-02_r8,9.0419e-02_r8,9.7193e-02_r8,1.0562e-01_r8,1.1587e-01_r8/)
      kbo(:,36, 5) = (/ &
     &7.0999e-02_r8,7.5907e-02_r8,8.1988e-02_r8,8.9567e-02_r8,9.8842e-02_r8/)
      kbo(:,37, 5) = (/ &
     &5.8886e-02_r8,6.3102e-02_r8,6.8391e-02_r8,7.5008e-02_r8,8.3160e-02_r8/)
      kbo(:,38, 5) = (/ &
     &4.8832e-02_r8,5.2452e-02_r8,5.7040e-02_r8,6.2826e-02_r8,7.0009e-02_r8/)
      kbo(:,39, 5) = (/ &
     &4.0501e-02_r8,4.3616e-02_r8,4.7608e-02_r8,5.2697e-02_r8,5.9016e-02_r8/)
      kbo(:,40, 5) = (/ &
     &3.3361e-02_r8,3.5983e-02_r8,3.9374e-02_r8,4.3750e-02_r8,4.9196e-02_r8/)
      kbo(:,41, 5) = (/ &
     &2.7445e-02_r8,2.9649e-02_r8,3.2516e-02_r8,3.6256e-02_r8,4.0930e-02_r8/)
      kbo(:,42, 5) = (/ &
     &2.2572e-02_r8,2.4412e-02_r8,2.6829e-02_r8,3.0022e-02_r8,3.4040e-02_r8/)
      kbo(:,43, 5) = (/ &
     &1.8476e-02_r8,1.9991e-02_r8,2.1997e-02_r8,2.4673e-02_r8,2.8080e-02_r8/)
      kbo(:,44, 5) = (/ &
     &1.5092e-02_r8,1.6330e-02_r8,1.7973e-02_r8,2.0194e-02_r8,2.3058e-02_r8/)
      kbo(:,45, 5) = (/ &
     &1.2321e-02_r8,1.3334e-02_r8,1.4674e-02_r8,1.6507e-02_r8,1.8911e-02_r8/)
      kbo(:,46, 5) = (/ &
     &1.0036e-02_r8,1.0861e-02_r8,1.1940e-02_r8,1.3440e-02_r8,1.5434e-02_r8/)
      kbo(:,47, 5) = (/ &
     &8.1439e-03_r8,8.8117e-03_r8,9.6681e-03_r8,1.0871e-02_r8,1.2500e-02_r8/)
      kbo(:,48, 5) = (/ &
     &6.6059e-03_r8,7.1462e-03_r8,7.8259e-03_r8,8.7835e-03_r8,1.0106e-02_r8/)
      kbo(:,49, 5) = (/ &
     &5.3548e-03_r8,5.7913e-03_r8,6.3343e-03_r8,7.0935e-03_r8,8.1581e-03_r8/)
      kbo(:,50, 5) = (/ &
     &4.3482e-03_r8,4.7014e-03_r8,5.1411e-03_r8,5.7429e-03_r8,6.6034e-03_r8/)
      kbo(:,51, 5) = (/ &
     &3.5331e-03_r8,3.8185e-03_r8,4.1765e-03_r8,4.6543e-03_r8,5.3466e-03_r8/)
      kbo(:,52, 5) = (/ &
     &2.8695e-03_r8,3.1007e-03_r8,3.3920e-03_r8,3.7708e-03_r8,4.3257e-03_r8/)
      kbo(:,53, 5) = (/ &
     &2.3291e-03_r8,2.5165e-03_r8,2.7524e-03_r8,3.0532e-03_r8,3.4935e-03_r8/)
      kbo(:,54, 5) = (/ &
     &1.8925e-03_r8,2.0468e-03_r8,2.2382e-03_r8,2.4801e-03_r8,2.8323e-03_r8/)
      kbo(:,55, 5) = (/ &
     &1.5385e-03_r8,1.6657e-03_r8,1.8210e-03_r8,2.0171e-03_r8,2.2988e-03_r8/)
      kbo(:,56, 5) = (/ &
     &1.2499e-03_r8,1.3548e-03_r8,1.4808e-03_r8,1.6398e-03_r8,1.8634e-03_r8/)
      kbo(:,57, 5) = (/ &
     &1.0138e-03_r8,1.1010e-03_r8,1.2032e-03_r8,1.3320e-03_r8,1.5093e-03_r8/)
      kbo(:,58, 5) = (/ &
     &8.2159e-04_r8,8.9516e-04_r8,9.7844e-04_r8,1.0832e-03_r8,1.2245e-03_r8/)
      kbo(:,59, 5) = (/ &
     &6.7629e-04_r8,7.3875e-04_r8,8.0921e-04_r8,8.9812e-04_r8,1.0190e-03_r8/)
      kbo(:,13, 6) = (/ &
     &8.6109e+00_r8,8.6045e+00_r8,8.6391e+00_r8,8.7159e+00_r8,8.8472e+00_r8/)
      kbo(:,14, 6) = (/ &
     &7.2012e+00_r8,7.1992e+00_r8,7.2347e+00_r8,7.3193e+00_r8,7.4652e+00_r8/)
      kbo(:,15, 6) = (/ &
     &6.0036e+00_r8,6.0084e+00_r8,6.0525e+00_r8,6.1531e+00_r8,6.3134e+00_r8/)
      kbo(:,16, 6) = (/ &
     &4.9860e+00_r8,4.9990e+00_r8,5.0571e+00_r8,5.1776e+00_r8,5.3476e+00_r8/)
      kbo(:,17, 6) = (/ &
     &4.1286e+00_r8,4.1532e+00_r8,4.2350e+00_r8,4.3671e+00_r8,4.5277e+00_r8/)
      kbo(:,18, 6) = (/ &
     &3.4143e+00_r8,3.4596e+00_r8,3.5560e+00_r8,3.6799e+00_r8,3.8169e+00_r8/)
      kbo(:,19, 6) = (/ &
     &2.8306e+00_r8,2.8919e+00_r8,2.9820e+00_r8,3.0877e+00_r8,3.2050e+00_r8/)
      kbo(:,20, 6) = (/ &
     &2.3552e+00_r8,2.4158e+00_r8,2.4951e+00_r8,2.5846e+00_r8,2.6876e+00_r8/)
      kbo(:,21, 6) = (/ &
     &1.9600e+00_r8,2.0149e+00_r8,2.0826e+00_r8,2.1623e+00_r8,2.2526e+00_r8/)
      kbo(:,22, 6) = (/ &
     &1.6326e+00_r8,1.6825e+00_r8,1.7432e+00_r8,1.8140e+00_r8,1.8956e+00_r8/)
      kbo(:,23, 6) = (/ &
     &1.3616e+00_r8,1.4065e+00_r8,1.4611e+00_r8,1.5245e+00_r8,1.5974e+00_r8/)
      kbo(:,24, 6) = (/ &
     &1.1379e+00_r8,1.1784e+00_r8,1.2266e+00_r8,1.2828e+00_r8,1.3489e+00_r8/)
      kbo(:,25, 6) = (/ &
     &9.5263e-01_r8,9.8858e-01_r8,1.0309e+00_r8,1.0818e+00_r8,1.1428e+00_r8/)
      kbo(:,26, 6) = (/ &
     &7.9793e-01_r8,8.2975e-01_r8,8.6871e-01_r8,9.1620e-01_r8,9.7213e-01_r8/)
      kbo(:,27, 6) = (/ &
     &6.6853e-01_r8,6.9732e-01_r8,7.3341e-01_r8,7.7799e-01_r8,8.3032e-01_r8/)
      kbo(:,28, 6) = (/ &
     &5.6032e-01_r8,5.8734e-01_r8,6.2174e-01_r8,6.6339e-01_r8,7.1179e-01_r8/)
      kbo(:,29, 6) = (/ &
     &4.7080e-01_r8,4.9684e-01_r8,5.2958e-01_r8,5.6837e-01_r8,6.1280e-01_r8/)
      kbo(:,30, 6) = (/ &
     &3.9732e-01_r8,4.2229e-01_r8,4.5298e-01_r8,4.8884e-01_r8,5.2914e-01_r8/)
      kbo(:,31, 6) = (/ &
     &3.3719e-01_r8,3.6099e-01_r8,3.8930e-01_r8,4.2211e-01_r8,4.5851e-01_r8/)
      kbo(:,32, 6) = (/ &
     &2.8780e-01_r8,3.1000e-01_r8,3.3607e-01_r8,3.6581e-01_r8,3.9865e-01_r8/)
      kbo(:,33, 6) = (/ &
     &2.4698e-01_r8,2.6737e-01_r8,2.9124e-01_r8,3.1811e-01_r8,3.4839e-01_r8/)
      kbo(:,34, 6) = (/ &
     &2.1208e-01_r8,2.3079e-01_r8,2.5250e-01_r8,2.7695e-01_r8,3.0517e-01_r8/)
      kbo(:,35, 6) = (/ &
     &1.8116e-01_r8,1.9828e-01_r8,2.1775e-01_r8,2.3997e-01_r8,2.6607e-01_r8/)
      kbo(:,36, 6) = (/ &
     &1.5361e-01_r8,1.6893e-01_r8,1.8633e-01_r8,2.0647e-01_r8,2.3023e-01_r8/)
      kbo(:,37, 6) = (/ &
     &1.2853e-01_r8,1.4194e-01_r8,1.5730e-01_r8,1.7520e-01_r8,1.9644e-01_r8/)
      kbo(:,38, 6) = (/ &
     &1.0750e-01_r8,1.1924e-01_r8,1.3275e-01_r8,1.4862e-01_r8,1.6766e-01_r8/)
      kbo(:,39, 6) = (/ &
     &8.9946e-02_r8,1.0018e-01_r8,1.1208e-01_r8,1.2616e-01_r8,1.4325e-01_r8/)
      kbo(:,40, 6) = (/ &
     &7.4468e-02_r8,8.3253e-02_r8,9.3534e-02_r8,1.0578e-01_r8,1.2083e-01_r8/)
      kbo(:,41, 6) = (/ &
     &6.1560e-02_r8,6.9060e-02_r8,7.7885e-02_r8,8.8512e-02_r8,1.0168e-01_r8/)
      kbo(:,42, 6) = (/ &
     &5.0884e-02_r8,5.7270e-02_r8,6.4836e-02_r8,7.4017e-02_r8,8.5530e-02_r8/)
      kbo(:,43, 6) = (/ &
     &4.1741e-02_r8,4.7136e-02_r8,5.3555e-02_r8,6.1413e-02_r8,7.1280e-02_r8/)
      kbo(:,44, 6) = (/ &
     &3.4114e-02_r8,3.8637e-02_r8,4.4075e-02_r8,5.0720e-02_r8,5.9134e-02_r8/)
      kbo(:,45, 6) = (/ &
     &2.7843e-02_r8,3.1631e-02_r8,3.6225e-02_r8,4.1848e-02_r8,4.9013e-02_r8/)
      kbo(:,46, 6) = (/ &
     &2.2624e-02_r8,2.5773e-02_r8,2.9633e-02_r8,3.4369e-02_r8,4.0405e-02_r8/)
      kbo(:,47, 6) = (/ &
     &1.8260e-02_r8,2.0843e-02_r8,2.4043e-02_r8,2.7985e-02_r8,3.3023e-02_r8/)
      kbo(:,48, 6) = (/ &
     &1.4711e-02_r8,1.6820e-02_r8,1.9466e-02_r8,2.2727e-02_r8,2.6914e-02_r8/)
      kbo(:,49, 6) = (/ &
     &1.1827e-02_r8,1.3542e-02_r8,1.5709e-02_r8,1.8410e-02_r8,2.1875e-02_r8/)
      kbo(:,50, 6) = (/ &
     &9.5219e-03_r8,1.0923e-02_r8,1.2699e-02_r8,1.4938e-02_r8,1.7808e-02_r8/)
      kbo(:,51, 6) = (/ &
     &7.6687e-03_r8,8.8049e-03_r8,1.0259e-02_r8,1.2113e-02_r8,1.4495e-02_r8/)
      kbo(:,52, 6) = (/ &
     &6.1732e-03_r8,7.0853e-03_r8,8.2719e-03_r8,9.7966e-03_r8,1.1770e-02_r8/)
      kbo(:,53, 6) = (/ &
     &4.9698e-03_r8,5.6903e-03_r8,6.6530e-03_r8,7.9081e-03_r8,9.5294e-03_r8/)
      kbo(:,54, 6) = (/ &
     &4.0149e-03_r8,4.5833e-03_r8,5.3685e-03_r8,6.4021e-03_r8,7.7450e-03_r8/)
      kbo(:,55, 6) = (/ &
     &3.2497e-03_r8,3.6951e-03_r8,4.3359e-03_r8,5.1870e-03_r8,6.3011e-03_r8/)
      kbo(:,56, 6) = (/ &
     &2.6325e-03_r8,2.9773e-03_r8,3.4964e-03_r8,4.1937e-03_r8,5.1170e-03_r8/)
      kbo(:,57, 6) = (/ &
     &2.1354e-03_r8,2.3977e-03_r8,2.8151e-03_r8,3.3845e-03_r8,4.1468e-03_r8/)
      kbo(:,58, 6) = (/ &
     &1.7364e-03_r8,1.9358e-03_r8,2.2698e-03_r8,2.7348e-03_r8,3.3639e-03_r8/)
      kbo(:,59, 6) = (/ &
     &1.4324e-03_r8,1.6023e-03_r8,1.8879e-03_r8,2.2888e-03_r8,2.8370e-03_r8/)
      kbo(:,13, 7) = (/ &
     &1.7993e+01_r8,1.8373e+01_r8,1.8772e+01_r8,1.9157e+01_r8,1.9544e+01_r8/)
      kbo(:,14, 7) = (/ &
     &1.5395e+01_r8,1.5713e+01_r8,1.6031e+01_r8,1.6348e+01_r8,1.6675e+01_r8/)
      kbo(:,15, 7) = (/ &
     &1.3087e+01_r8,1.3328e+01_r8,1.3586e+01_r8,1.3851e+01_r8,1.4166e+01_r8/)
      kbo(:,16, 7) = (/ &
     &1.1053e+01_r8,1.1254e+01_r8,1.1469e+01_r8,1.1711e+01_r8,1.2037e+01_r8/)
      kbo(:,17, 7) = (/ &
     &9.3076e+00_r8,9.4744e+00_r8,9.6627e+00_r8,9.9088e+00_r8,1.0257e+01_r8/)
      kbo(:,18, 7) = (/ &
     &7.8193e+00_r8,7.9665e+00_r8,8.1534e+00_r8,8.4211e+00_r8,8.7715e+00_r8/)
      kbo(:,19, 7) = (/ &
     &6.5448e+00_r8,6.6861e+00_r8,6.8916e+00_r8,7.1741e+00_r8,7.4962e+00_r8/)
      kbo(:,20, 7) = (/ &
     &5.4651e+00_r8,5.6202e+00_r8,5.8422e+00_r8,6.1124e+00_r8,6.3952e+00_r8/)
      kbo(:,21, 7) = (/ &
     &4.5716e+00_r8,4.7392e+00_r8,4.9589e+00_r8,5.1951e+00_r8,5.4343e+00_r8/)
      kbo(:,22, 7) = (/ &
     &3.8421e+00_r8,4.0181e+00_r8,4.2111e+00_r8,4.4111e+00_r8,4.6135e+00_r8/)
      kbo(:,23, 7) = (/ &
     &3.2420e+00_r8,3.4014e+00_r8,3.5676e+00_r8,3.7366e+00_r8,3.9163e+00_r8/)
      kbo(:,24, 7) = (/ &
     &2.7372e+00_r8,2.8745e+00_r8,3.0185e+00_r8,3.1680e+00_r8,3.3279e+00_r8/)
      kbo(:,25, 7) = (/ &
     &2.3109e+00_r8,2.4310e+00_r8,2.5564e+00_r8,2.6909e+00_r8,2.8371e+00_r8/)
      kbo(:,26, 7) = (/ &
     &1.9553e+00_r8,2.0603e+00_r8,2.1726e+00_r8,2.2928e+00_r8,2.4305e+00_r8/)
      kbo(:,27, 7) = (/ &
     &1.6578e+00_r8,1.7514e+00_r8,1.8510e+00_r8,1.9617e+00_r8,2.0943e+00_r8/)
      kbo(:,28, 7) = (/ &
     &1.4096e+00_r8,1.4926e+00_r8,1.5811e+00_r8,1.6863e+00_r8,1.8139e+00_r8/)
      kbo(:,29, 7) = (/ &
     &1.2014e+00_r8,1.2743e+00_r8,1.3570e+00_r8,1.4576e+00_r8,1.5798e+00_r8/)
      kbo(:,30, 7) = (/ &
     &1.0255e+00_r8,1.0913e+00_r8,1.1701e+00_r8,1.2677e+00_r8,1.3837e+00_r8/)
      kbo(:,31, 7) = (/ &
     &8.7693e-01_r8,9.3909e-01_r8,1.0166e+00_r8,1.1099e+00_r8,1.2195e+00_r8/)
      kbo(:,32, 7) = (/ &
     &7.5259e-01_r8,8.1353e-01_r8,8.8887e-01_r8,9.7843e-01_r8,1.0818e+00_r8/)
      kbo(:,33, 7) = (/ &
     &6.4947e-01_r8,7.0941e-01_r8,7.8262e-01_r8,8.6809e-01_r8,9.6577e-01_r8/)
      kbo(:,34, 7) = (/ &
     &5.6287e-01_r8,6.2118e-01_r8,6.9115e-01_r8,7.7236e-01_r8,8.6471e-01_r8/)
      kbo(:,35, 7) = (/ &
     &4.8662e-01_r8,5.4191e-01_r8,6.0756e-01_r8,6.8389e-01_r8,7.7035e-01_r8/)
      kbo(:,36, 7) = (/ &
     &4.1799e-01_r8,4.6899e-01_r8,5.2971e-01_r8,6.0005e-01_r8,6.8040e-01_r8/)
      kbo(:,37, 7) = (/ &
     &3.5425e-01_r8,3.9998e-01_r8,4.5446e-01_r8,5.1797e-01_r8,5.9123e-01_r8/)
      kbo(:,38, 7) = (/ &
     &3.0041e-01_r8,3.4120e-01_r8,3.9013e-01_r8,4.4734e-01_r8,5.1414e-01_r8/)
      kbo(:,39, 7) = (/ &
     &2.5510e-01_r8,2.9152e-01_r8,3.3528e-01_r8,3.8698e-01_r8,4.4801e-01_r8/)
      kbo(:,40, 7) = (/ &
     &2.1385e-01_r8,2.4566e-01_r8,2.8431e-01_r8,3.3018e-01_r8,3.8482e-01_r8/)
      kbo(:,41, 7) = (/ &
     &1.7890e-01_r8,2.0671e-01_r8,2.4058e-01_r8,2.8118e-01_r8,3.2987e-01_r8/)
      kbo(:,42, 7) = (/ &
     &1.4939e-01_r8,1.7381e-01_r8,2.0357e-01_r8,2.3938e-01_r8,2.8282e-01_r8/)
      kbo(:,43, 7) = (/ &
     &1.2354e-01_r8,1.4458e-01_r8,1.7057e-01_r8,2.0193e-01_r8,2.4014e-01_r8/)
      kbo(:,44, 7) = (/ &
     &1.0153e-01_r8,1.1950e-01_r8,1.4202e-01_r8,1.6945e-01_r8,2.0287e-01_r8/)
      kbo(:,45, 7) = (/ &
     &8.3299e-02_r8,9.8554e-02_r8,1.1794e-01_r8,1.4189e-01_r8,1.7119e-01_r8/)
      kbo(:,46, 7) = (/ &
     &6.7950e-02_r8,8.0732e-02_r8,9.7254e-02_r8,1.1796e-01_r8,1.4359e-01_r8/)
      kbo(:,47, 7) = (/ &
     &5.4969e-02_r8,6.5444e-02_r8,7.9285e-02_r8,9.6924e-02_r8,1.1901e-01_r8/)
      kbo(:,48, 7) = (/ &
     &4.4384e-02_r8,5.2919e-02_r8,6.4422e-02_r8,7.9306e-02_r8,9.8242e-02_r8/)
      kbo(:,49, 7) = (/ &
     &3.5781e-02_r8,4.2676e-02_r8,5.2185e-02_r8,6.4673e-02_r8,8.0797e-02_r8/)
      kbo(:,50, 7) = (/ &
     &2.8901e-02_r8,3.4506e-02_r8,4.2382e-02_r8,5.2852e-02_r8,6.6579e-02_r8/)
      kbo(:,51, 7) = (/ &
     &2.3369e-02_r8,2.7878e-02_r8,3.4389e-02_r8,4.3175e-02_r8,5.4833e-02_r8/)
      kbo(:,52, 7) = (/ &
     &1.8862e-02_r8,2.2473e-02_r8,2.7804e-02_r8,3.5169e-02_r8,4.5009e-02_r8/)
      kbo(:,53, 7) = (/ &
     &1.5202e-02_r8,1.8063e-02_r8,2.2412e-02_r8,2.8532e-02_r8,3.6823e-02_r8/)
      kbo(:,54, 7) = (/ &
     &1.2294e-02_r8,1.4584e-02_r8,1.8116e-02_r8,2.3236e-02_r8,3.0266e-02_r8/)
      kbo(:,55, 7) = (/ &
     &9.9456e-03_r8,1.1792e-02_r8,1.4659e-02_r8,1.8922e-02_r8,2.4874e-02_r8/)
      kbo(:,56, 7) = (/ &
     &8.0324e-03_r8,9.5190e-03_r8,1.1834e-02_r8,1.5356e-02_r8,2.0377e-02_r8/)
      kbo(:,57, 7) = (/ &
     &6.4764e-03_r8,7.6756e-03_r8,9.5255e-03_r8,1.2420e-02_r8,1.6628e-02_r8/)
      kbo(:,58, 7) = (/ &
     &5.2278e-03_r8,6.1981e-03_r8,7.6844e-03_r8,1.0060e-02_r8,1.3591e-02_r8/)
      kbo(:,59, 7) = (/ &
     &4.3384e-03_r8,5.1762e-03_r8,6.4759e-03_r8,8.5723e-03_r8,1.1730e-02_r8/)
      kbo(:,13, 8) = (/ &
     &4.8706e+01_r8,5.0287e+01_r8,5.1813e+01_r8,5.3328e+01_r8,5.4791e+01_r8/)
      kbo(:,14, 8) = (/ &
     &4.2745e+01_r8,4.3995e+01_r8,4.5243e+01_r8,4.6475e+01_r8,4.7668e+01_r8/)
      kbo(:,15, 8) = (/ &
     &3.7251e+01_r8,3.8260e+01_r8,3.9278e+01_r8,4.0277e+01_r8,4.1241e+01_r8/)
      kbo(:,16, 8) = (/ &
     &3.2307e+01_r8,3.3121e+01_r8,3.3949e+01_r8,3.4768e+01_r8,3.5567e+01_r8/)
      kbo(:,17, 8) = (/ &
     &2.7892e+01_r8,2.8569e+01_r8,2.9248e+01_r8,2.9919e+01_r8,3.0586e+01_r8/)
      kbo(:,18, 8) = (/ &
     &2.3896e+01_r8,2.4456e+01_r8,2.5013e+01_r8,2.5581e+01_r8,2.6214e+01_r8/)
      kbo(:,19, 8) = (/ &
     &2.0345e+01_r8,2.0796e+01_r8,2.1262e+01_r8,2.1777e+01_r8,2.2440e+01_r8/)
      kbo(:,20, 8) = (/ &
     &1.7240e+01_r8,1.7611e+01_r8,1.8026e+01_r8,1.8548e+01_r8,1.9267e+01_r8/)
      kbo(:,21, 8) = (/ &
     &1.4559e+01_r8,1.4881e+01_r8,1.5281e+01_r8,1.5850e+01_r8,1.6627e+01_r8/)
      kbo(:,22, 8) = (/ &
     &1.2297e+01_r8,1.2604e+01_r8,1.3048e+01_r8,1.3680e+01_r8,1.4474e+01_r8/)
      kbo(:,23, 8) = (/ &
     &1.0392e+01_r8,1.0731e+01_r8,1.1231e+01_r8,1.1887e+01_r8,1.2635e+01_r8/)
      kbo(:,24, 8) = (/ &
     &8.8024e+00_r8,9.1906e+00_r8,9.7265e+00_r8,1.0368e+01_r8,1.1047e+01_r8/)
      kbo(:,25, 8) = (/ &
     &7.4985e+00_r8,7.9218e+00_r8,8.4606e+00_r8,9.0520e+00_r8,9.6698e+00_r8/)
      kbo(:,26, 8) = (/ &
     &6.4322e+00_r8,6.8736e+00_r8,7.3794e+00_r8,7.9154e+00_r8,8.4712e+00_r8/)
      kbo(:,27, 8) = (/ &
     &5.5575e+00_r8,5.9810e+00_r8,6.4388e+00_r8,6.9229e+00_r8,7.4216e+00_r8/)
      kbo(:,28, 8) = (/ &
     &4.8206e+00_r8,5.2066e+00_r8,5.6224e+00_r8,6.0597e+00_r8,6.5182e+00_r8/)
      kbo(:,29, 8) = (/ &
     &4.1909e+00_r8,4.5439e+00_r8,4.9224e+00_r8,5.3216e+00_r8,5.7541e+00_r8/)
      kbo(:,30, 8) = (/ &
     &3.6537e+00_r8,3.9765e+00_r8,4.3215e+00_r8,4.6952e+00_r8,5.1087e+00_r8/)
      kbo(:,31, 8) = (/ &
     &3.1984e+00_r8,3.4930e+00_r8,3.8129e+00_r8,4.1678e+00_r8,4.5716e+00_r8/)
      kbo(:,32, 8) = (/ &
     &2.8116e+00_r8,3.0829e+00_r8,3.3853e+00_r8,3.7289e+00_r8,4.1280e+00_r8/)
      kbo(:,33, 8) = (/ &
     &2.4834e+00_r8,2.7385e+00_r8,3.0281e+00_r8,3.3657e+00_r8,3.7662e+00_r8/)
      kbo(:,34, 8) = (/ &
     &2.1985e+00_r8,2.4407e+00_r8,2.7219e+00_r8,3.0561e+00_r8,3.4576e+00_r8/)
      kbo(:,35, 8) = (/ &
     &1.9383e+00_r8,2.1683e+00_r8,2.4400e+00_r8,2.7681e+00_r8,3.1668e+00_r8/)
      kbo(:,36, 8) = (/ &
     &1.6974e+00_r8,1.9136e+00_r8,2.1729e+00_r8,2.4903e+00_r8,2.8775e+00_r8/)
      kbo(:,37, 8) = (/ &
     &1.4652e+00_r8,1.6633e+00_r8,1.9048e+00_r8,2.2035e+00_r8,2.5698e+00_r8/)
      kbo(:,38, 8) = (/ &
     &1.2656e+00_r8,1.4474e+00_r8,1.6717e+00_r8,1.9523e+00_r8,2.2987e+00_r8/)
      kbo(:,39, 8) = (/ &
     &1.0950e+00_r8,1.2617e+00_r8,1.4708e+00_r8,1.7354e+00_r8,2.0626e+00_r8/)
      kbo(:,40, 8) = (/ &
     &9.3521e-01_r8,1.0851e+00_r8,1.2754e+00_r8,1.5183e+00_r8,1.8212e+00_r8/)
      kbo(:,41, 8) = (/ &
     &7.9768e-01_r8,9.3182e-01_r8,1.1039e+00_r8,1.3257e+00_r8,1.6049e+00_r8/)
      kbo(:,42, 8) = (/ &
     &6.8000e-01_r8,8.0060e-01_r8,9.5561e-01_r8,1.1575e+00_r8,1.4146e+00_r8/)
      kbo(:,43, 8) = (/ &
     &5.7402e-01_r8,6.8098e-01_r8,8.1874e-01_r8,9.9948e-01_r8,1.2325e+00_r8/)
      kbo(:,44, 8) = (/ &
     &4.8186e-01_r8,5.7592e-01_r8,6.9798e-01_r8,8.5786e-01_r8,1.0670e+00_r8/)
      kbo(:,45, 8) = (/ &
     &4.0392e-01_r8,4.8633e-01_r8,5.9393e-01_r8,7.3592e-01_r8,9.2240e-01_r8/)
      kbo(:,46, 8) = (/ &
     &3.3669e-01_r8,4.0818e-01_r8,5.0211e-01_r8,6.2723e-01_r8,7.9252e-01_r8/)
      kbo(:,47, 8) = (/ &
     &2.7781e-01_r8,3.3888e-01_r8,4.1961e-01_r8,5.2781e-01_r8,6.7290e-01_r8/)
      kbo(:,48, 8) = (/ &
     &2.2877e-01_r8,2.8059e-01_r8,3.4952e-01_r8,4.4268e-01_r8,5.6946e-01_r8/)
      kbo(:,49, 8) = (/ &
     &1.8802e-01_r8,2.3180e-01_r8,2.9026e-01_r8,3.7003e-01_r8,4.7989e-01_r8/)
      kbo(:,50, 8) = (/ &
     &1.5486e-01_r8,1.9224e-01_r8,2.4194e-01_r8,3.1045e-01_r8,4.0570e-01_r8/)
      kbo(:,51, 8) = (/ &
     &1.2726e-01_r8,1.5950e-01_r8,2.0189e-01_r8,2.6070e-01_r8,3.4311e-01_r8/)
      kbo(:,52, 8) = (/ &
     &1.0409e-01_r8,1.3185e-01_r8,1.6823e-01_r8,2.1834e-01_r8,2.8934e-01_r8/)
      kbo(:,53, 8) = (/ &
     &8.4711e-02_r8,1.0844e-01_r8,1.3980e-01_r8,1.8253e-01_r8,2.4332e-01_r8/)
      kbo(:,54, 8) = (/ &
     &6.9167e-02_r8,8.9444e-02_r8,1.1665e-01_r8,1.5372e-01_r8,2.0609e-01_r8/)
      kbo(:,55, 8) = (/ &
     &5.6448e-02_r8,7.3743e-02_r8,9.7299e-02_r8,1.2965e-01_r8,1.7511e-01_r8/)
      kbo(:,56, 8) = (/ &
     &4.5936e-02_r8,6.0554e-02_r8,8.0824e-02_r8,1.0896e-01_r8,1.4860e-01_r8/)
      kbo(:,57, 8) = (/ &
     &3.7232e-02_r8,4.9532e-02_r8,6.6834e-02_r8,9.1174e-02_r8,1.2579e-01_r8/)
      kbo(:,58, 8) = (/ &
     &3.0170e-02_r8,4.0563e-02_r8,5.5307e-02_r8,7.6347e-02_r8,1.0664e-01_r8/)
      kbo(:,59, 8) = (/ &
     &2.5677e-02_r8,3.5025e-02_r8,4.8385e-02_r8,6.7734e-02_r8,9.6011e-02_r8/)
      kbo(:,13, 9) = (/ &
     &2.6703e+02_r8,2.6279e+02_r8,2.6062e+02_r8,2.6039e+02_r8,2.6194e+02_r8/)
      kbo(:,14, 9) = (/ &
     &2.2898e+02_r8,2.2692e+02_r8,2.2683e+02_r8,2.2864e+02_r8,2.3216e+02_r8/)
      kbo(:,15, 9) = (/ &
     &1.9675e+02_r8,1.9661e+02_r8,1.9840e+02_r8,2.0200e+02_r8,2.0726e+02_r8/)
      kbo(:,16, 9) = (/ &
     &1.6984e+02_r8,1.7136e+02_r8,1.7476e+02_r8,1.7992e+02_r8,1.8656e+02_r8/)
      kbo(:,17, 9) = (/ &
     &1.4758e+02_r8,1.5050e+02_r8,1.5527e+02_r8,1.6140e+02_r8,1.6749e+02_r8/)
      kbo(:,18, 9) = (/ &
     &1.2946e+02_r8,1.3358e+02_r8,1.3896e+02_r8,1.4424e+02_r8,1.4936e+02_r8/)
      kbo(:,19, 9) = (/ &
     &1.1448e+02_r8,1.1916e+02_r8,1.2382e+02_r8,1.2832e+02_r8,1.3257e+02_r8/)
      kbo(:,20, 9) = (/ &
     &1.0147e+02_r8,1.0559e+02_r8,1.0961e+02_r8,1.1348e+02_r8,1.1720e+02_r8/)
      kbo(:,21, 9) = (/ &
     &8.9412e+01_r8,9.2958e+01_r8,9.6430e+01_r8,9.9808e+01_r8,1.0309e+02_r8/)
      kbo(:,22, 9) = (/ &
     &7.8582e+01_r8,8.1638e+01_r8,8.4651e+01_r8,8.7620e+01_r8,9.0634e+01_r8/)
      kbo(:,23, 9) = (/ &
     &6.8855e+01_r8,7.1486e+01_r8,7.4134e+01_r8,7.6820e+01_r8,7.9730e+01_r8/)
      kbo(:,24, 9) = (/ &
     &6.0268e+01_r8,6.2580e+01_r8,6.4940e+01_r8,6.7498e+01_r8,7.0383e+01_r8/)
      kbo(:,25, 9) = (/ &
     &5.2817e+01_r8,5.4857e+01_r8,5.7070e+01_r8,5.9583e+01_r8,6.2456e+01_r8/)
      kbo(:,26, 9) = (/ &
     &4.6400e+01_r8,4.8304e+01_r8,5.0443e+01_r8,5.2928e+01_r8,5.5843e+01_r8/)
      kbo(:,27, 9) = (/ &
     &4.0882e+01_r8,4.2740e+01_r8,4.4869e+01_r8,4.7387e+01_r8,5.0354e+01_r8/)
      kbo(:,28, 9) = (/ &
     &3.6127e+01_r8,3.8035e+01_r8,4.0229e+01_r8,4.2798e+01_r8,4.5828e+01_r8/)
      kbo(:,29, 9) = (/ &
     &3.2099e+01_r8,3.4067e+01_r8,3.6357e+01_r8,3.9031e+01_r8,4.2139e+01_r8/)
      kbo(:,30, 9) = (/ &
     &2.8701e+01_r8,3.0741e+01_r8,3.3127e+01_r8,3.5914e+01_r8,3.9160e+01_r8/)
      kbo(:,31, 9) = (/ &
     &2.5860e+01_r8,2.7970e+01_r8,3.0458e+01_r8,3.3377e+01_r8,3.6776e+01_r8/)
      kbo(:,32, 9) = (/ &
     &2.3508e+01_r8,2.5694e+01_r8,2.8287e+01_r8,3.1347e+01_r8,3.4892e+01_r8/)
      kbo(:,33, 9) = (/ &
     &2.1570e+01_r8,2.3849e+01_r8,2.6553e+01_r8,2.9752e+01_r8,3.3419e+01_r8/)
      kbo(:,34, 9) = (/ &
     &1.9918e+01_r8,2.2276e+01_r8,2.5098e+01_r8,2.8399e+01_r8,3.2162e+01_r8/)
      kbo(:,35, 9) = (/ &
     &1.8364e+01_r8,2.0767e+01_r8,2.3651e+01_r8,2.7001e+01_r8,3.0813e+01_r8/)
      kbo(:,36, 9) = (/ &
     &1.6826e+01_r8,1.9227e+01_r8,2.2113e+01_r8,2.5466e+01_r8,2.9284e+01_r8/)
      kbo(:,37, 9) = (/ &
     &1.5183e+01_r8,1.7515e+01_r8,2.0322e+01_r8,2.3610e+01_r8,2.7381e+01_r8/)
      kbo(:,38, 9) = (/ &
     &1.3727e+01_r8,1.5985e+01_r8,1.8713e+01_r8,2.1934e+01_r8,2.5649e+01_r8/)
      kbo(:,39, 9) = (/ &
     &1.2450e+01_r8,1.4635e+01_r8,1.7282e+01_r8,2.0444e+01_r8,2.4108e+01_r8/)
      kbo(:,40, 9) = (/ &
     &1.1136e+01_r8,1.3200e+01_r8,1.5726e+01_r8,1.8770e+01_r8,2.2337e+01_r8/)
      kbo(:,41, 9) = (/ &
     &9.9523e+00_r8,1.1888e+01_r8,1.4289e+01_r8,1.7214e+01_r8,2.0673e+01_r8/)
      kbo(:,42, 9) = (/ &
     &8.8997e+00_r8,1.0713e+01_r8,1.2995e+01_r8,1.5799e+01_r8,1.9151e+01_r8/)
      kbo(:,43, 9) = (/ &
     &7.8779e+00_r8,9.5542e+00_r8,1.1690e+01_r8,1.4348e+01_r8,1.7554e+01_r8/)
      kbo(:,44, 9) = (/ &
     &6.9290e+00_r8,8.4792e+00_r8,1.0459e+01_r8,1.2952e+01_r8,1.5997e+01_r8/)
      kbo(:,45, 9) = (/ &
     &6.0796e+00_r8,7.5168e+00_r8,9.3520e+00_r8,1.1681e+01_r8,1.4566e+01_r8/)
      kbo(:,46, 9) = (/ &
     &5.2960e+00_r8,6.6184e+00_r8,8.3160e+00_r8,1.0473e+01_r8,1.3177e+01_r8/)
      kbo(:,47, 9) = (/ &
     &4.5500e+00_r8,5.7498e+00_r8,7.3069e+00_r8,9.2819e+00_r8,1.1781e+01_r8/)
      kbo(:,48, 9) = (/ &
     &3.8931e+00_r8,4.9768e+00_r8,6.3975e+00_r8,8.2101e+00_r8,1.0505e+01_r8/)
      kbo(:,49, 9) = (/ &
     &3.3134e+00_r8,4.2874e+00_r8,5.5792e+00_r8,7.2463e+00_r8,9.3480e+00_r8/)
      kbo(:,50, 9) = (/ &
     &2.8246e+00_r8,3.7000e+00_r8,4.8781e+00_r8,6.4148e+00_r8,8.3545e+00_r8/)
      kbo(:,51, 9) = (/ &
     &2.4042e+00_r8,3.1908e+00_r8,4.2622e+00_r8,5.6755e+00_r8,7.4755e+00_r8/)
      kbo(:,52, 9) = (/ &
     &2.0363e+00_r8,2.7388e+00_r8,3.7098e+00_r8,5.0044e+00_r8,6.6735e+00_r8/)
      kbo(:,53, 9) = (/ &
     &1.7163e+00_r8,2.3398e+00_r8,3.2134e+00_r8,4.3950e+00_r8,5.9331e+00_r8/)
      kbo(:,54, 9) = (/ &
     &1.4526e+00_r8,2.0075e+00_r8,2.7999e+00_r8,3.8816e+00_r8,5.3040e+00_r8/)
      kbo(:,55, 9) = (/ &
     &1.2300e+00_r8,1.7228e+00_r8,2.4419e+00_r8,3.4323e+00_r8,4.7483e+00_r8/)
      kbo(:,56, 9) = (/ &
     &1.0375e+00_r8,1.4731e+00_r8,2.1205e+00_r8,3.0254e+00_r8,4.2381e+00_r8/)
      kbo(:,57, 9) = (/ &
     &8.7139e-01_r8,1.2530e+00_r8,1.8332e+00_r8,2.6576e+00_r8,3.7724e+00_r8/)
      kbo(:,58, 9) = (/ &
     &7.3413e-01_r8,1.0690e+00_r8,1.5879e+00_r8,2.3382e+00_r8,3.3642e+00_r8/)
      kbo(:,59, 9) = (/ &
     &6.5989e-01_r8,9.7719e-01_r8,1.4752e+00_r8,2.2003e+00_r8,3.1955e+00_r8/)
      kbo(:,13,10) = (/ &
     &1.1367e+03_r8,1.1187e+03_r8,1.1007e+03_r8,1.0822e+03_r8,1.0635e+03_r8/)
      kbo(:,14,10) = (/ &
     &1.0074e+03_r8,9.9018e+02_r8,9.7308e+02_r8,9.5574e+02_r8,9.3889e+02_r8/)
      kbo(:,15,10) = (/ &
     &8.7706e+02_r8,8.6124e+02_r8,8.4557e+02_r8,8.3018e+02_r8,8.1545e+02_r8/)
      kbo(:,16,10) = (/ &
     &7.5406e+02_r8,7.4004e+02_r8,7.2614e+02_r8,7.1298e+02_r8,7.0106e+02_r8/)
      kbo(:,17,10) = (/ &
     &6.4217e+02_r8,6.3016e+02_r8,6.1851e+02_r8,6.1057e+02_r8,6.1770e+02_r8/)
      kbo(:,18,10) = (/ &
     &5.4317e+02_r8,5.3308e+02_r8,5.2858e+02_r8,5.4063e+02_r8,5.6728e+02_r8/)
      kbo(:,19,10) = (/ &
     &4.6024e+02_r8,4.5629e+02_r8,4.6936e+02_r8,4.9569e+02_r8,5.2404e+02_r8/)
      kbo(:,20,10) = (/ &
     &3.9833e+02_r8,4.0962e+02_r8,4.3282e+02_r8,4.5686e+02_r8,4.8096e+02_r8/)
      kbo(:,21,10) = (/ &
     &3.5836e+02_r8,3.7926e+02_r8,4.0031e+02_r8,4.2094e+02_r8,4.4134e+02_r8/)
      kbo(:,22,10) = (/ &
     &3.2968e+02_r8,3.4978e+02_r8,3.6939e+02_r8,3.8833e+02_r8,4.0603e+02_r8/)
      kbo(:,23,10) = (/ &
     &3.0114e+02_r8,3.1980e+02_r8,3.3812e+02_r8,3.5559e+02_r8,3.7182e+02_r8/)
      kbo(:,24,10) = (/ &
     &2.7330e+02_r8,2.9068e+02_r8,3.0752e+02_r8,3.2347e+02_r8,3.3875e+02_r8/)
      kbo(:,25,10) = (/ &
     &2.4688e+02_r8,2.6295e+02_r8,2.7833e+02_r8,2.9325e+02_r8,3.0804e+02_r8/)
      kbo(:,26,10) = (/ &
     &2.2243e+02_r8,2.3718e+02_r8,2.5149e+02_r8,2.6591e+02_r8,2.8021e+02_r8/)
      kbo(:,27,10) = (/ &
     &2.0056e+02_r8,2.1372e+02_r8,2.2739e+02_r8,2.4128e+02_r8,2.5540e+02_r8/)
      kbo(:,28,10) = (/ &
     &1.8160e+02_r8,1.9338e+02_r8,2.0609e+02_r8,2.1959e+02_r8,2.3363e+02_r8/)
      kbo(:,29,10) = (/ &
     &1.6537e+02_r8,1.7620e+02_r8,1.8800e+02_r8,2.0075e+02_r8,2.1484e+02_r8/)
      kbo(:,30,10) = (/ &
     &1.5182e+02_r8,1.6163e+02_r8,1.7256e+02_r8,1.8487e+02_r8,1.9853e+02_r8/)
      kbo(:,31,10) = (/ &
     &1.4022e+02_r8,1.4937e+02_r8,1.5973e+02_r8,1.7160e+02_r8,1.8530e+02_r8/)
      kbo(:,32,10) = (/ &
     &1.3043e+02_r8,1.3908e+02_r8,1.4919e+02_r8,1.6089e+02_r8,1.7519e+02_r8/)
      kbo(:,33,10) = (/ &
     &1.2206e+02_r8,1.3058e+02_r8,1.4055e+02_r8,1.5267e+02_r8,1.6777e+02_r8/)
      kbo(:,34,10) = (/ &
     &1.1470e+02_r8,1.2330e+02_r8,1.3342e+02_r8,1.4627e+02_r8,1.6240e+02_r8/)
      kbo(:,35,10) = (/ &
     &1.0771e+02_r8,1.1657e+02_r8,1.2696e+02_r8,1.4044e+02_r8,1.5769e+02_r8/)
      kbo(:,36,10) = (/ &
     &1.0083e+02_r8,1.1016e+02_r8,1.2074e+02_r8,1.3465e+02_r8,1.5261e+02_r8/)
      kbo(:,37,10) = (/ &
     &9.3496e+01_r8,1.0322e+02_r8,1.1406e+02_r8,1.2781e+02_r8,1.4573e+02_r8/)
      kbo(:,38,10) = (/ &
     &8.6889e+01_r8,9.7016e+01_r8,1.0824e+02_r8,1.2185e+02_r8,1.3969e+02_r8/)
      kbo(:,39,10) = (/ &
     &8.1021e+01_r8,9.1487e+01_r8,1.0329e+02_r8,1.1682e+02_r8,1.3445e+02_r8/)
      kbo(:,40,10) = (/ &
     &7.4776e+01_r8,8.5570e+01_r8,9.7630e+01_r8,1.1098e+02_r8,1.2786e+02_r8/)
      kbo(:,41,10) = (/ &
     &6.8905e+01_r8,7.9963e+01_r8,9.2277e+01_r8,1.0563e+02_r8,1.2163e+02_r8/)
      kbo(:,42,10) = (/ &
     &6.3556e+01_r8,7.4784e+01_r8,8.7205e+01_r8,1.0072e+02_r8,1.1596e+02_r8/)
      kbo(:,43,10) = (/ &
     &5.8129e+01_r8,6.9316e+01_r8,8.1730e+01_r8,9.5263e+01_r8,1.0987e+02_r8/)
      kbo(:,44,10) = (/ &
     &5.2913e+01_r8,6.3890e+01_r8,7.6248e+01_r8,8.9686e+01_r8,1.0397e+02_r8/)
      kbo(:,45,10) = (/ &
     &4.8208e+01_r8,5.8780e+01_r8,7.0988e+01_r8,8.4262e+01_r8,9.8407e+01_r8/)
      kbo(:,46,10) = (/ &
     &4.3761e+01_r8,5.3798e+01_r8,6.5649e+01_r8,7.8725e+01_r8,9.2702e+01_r8/)
      kbo(:,47,10) = (/ &
     &3.9326e+01_r8,4.8763e+01_r8,6.0030e+01_r8,7.2829e+01_r8,8.6540e+01_r8/)
      kbo(:,48,10) = (/ &
     &3.5364e+01_r8,4.4166e+01_r8,5.4802e+01_r8,6.7118e+01_r8,8.0555e+01_r8/)
      kbo(:,49,10) = (/ &
     &3.1766e+01_r8,3.9895e+01_r8,4.9874e+01_r8,6.1599e+01_r8,7.4720e+01_r8/)
      kbo(:,50,10) = (/ &
     &2.8694e+01_r8,3.6225e+01_r8,4.5586e+01_r8,5.6696e+01_r8,6.9417e+01_r8/)
      kbo(:,51,10) = (/ &
     &2.5920e+01_r8,3.2954e+01_r8,4.1705e+01_r8,5.2192e+01_r8,6.4368e+01_r8/)
      kbo(:,52,10) = (/ &
     &2.3265e+01_r8,2.9945e+01_r8,3.8066e+01_r8,4.7953e+01_r8,5.9548e+01_r8/)
      kbo(:,53,10) = (/ &
     &2.0700e+01_r8,2.7205e+01_r8,3.4731e+01_r8,4.4004e+01_r8,5.4983e+01_r8/)
      kbo(:,54,10) = (/ &
     &1.8407e+01_r8,2.4804e+01_r8,3.1883e+01_r8,4.0571e+01_r8,5.0997e+01_r8/)
      kbo(:,55,10) = (/ &
     &1.6304e+01_r8,2.2551e+01_r8,2.9350e+01_r8,3.7469e+01_r8,4.7350e+01_r8/)
      kbo(:,56,10) = (/ &
     &1.4323e+01_r8,2.0360e+01_r8,2.7019e+01_r8,3.4608e+01_r8,4.3950e+01_r8/)
      kbo(:,57,10) = (/ &
     &1.2463e+01_r8,1.8241e+01_r8,2.4765e+01_r8,3.1934e+01_r8,4.0687e+01_r8/)
      kbo(:,58,10) = (/ &
     &1.0795e+01_r8,1.6294e+01_r8,2.2666e+01_r8,2.9555e+01_r8,3.7776e+01_r8/)
      kbo(:,59,10) = (/ &
     &1.0106e+01_r8,1.5507e+01_r8,2.1812e+01_r8,2.8629e+01_r8,3.6645e+01_r8/)
      kbo(:,13,11) = (/ &
     &1.9976e+03_r8,1.9732e+03_r8,1.9489e+03_r8,1.9244e+03_r8,1.8976e+03_r8/)
      kbo(:,14,11) = (/ &
     &1.8361e+03_r8,1.8109e+03_r8,1.7859e+03_r8,1.7607e+03_r8,1.7342e+03_r8/)
      kbo(:,15,11) = (/ &
     &1.6588e+03_r8,1.6335e+03_r8,1.6090e+03_r8,1.5838e+03_r8,1.5592e+03_r8/)
      kbo(:,16,11) = (/ &
     &1.4709e+03_r8,1.4475e+03_r8,1.4246e+03_r8,1.4016e+03_r8,1.3798e+03_r8/)
      kbo(:,17,11) = (/ &
     &1.2816e+03_r8,1.2604e+03_r8,1.2396e+03_r8,1.2204e+03_r8,1.2023e+03_r8/)
      kbo(:,18,11) = (/ &
     &1.1028e+03_r8,1.0839e+03_r8,1.0668e+03_r8,1.0513e+03_r8,1.0382e+03_r8/)
      kbo(:,19,11) = (/ &
     &9.4023e+02_r8,9.2525e+02_r8,9.1156e+02_r8,9.0352e+02_r8,9.1240e+02_r8/)
      kbo(:,20,11) = (/ &
     &7.9708e+02_r8,7.8540e+02_r8,7.8133e+02_r8,7.9678e+02_r8,8.2988e+02_r8/)
      kbo(:,21,11) = (/ &
     &6.7587e+02_r8,6.7233e+02_r8,6.8973e+02_r8,7.2606e+02_r8,7.7277e+02_r8/)
      kbo(:,22,11) = (/ &
     &5.8284e+02_r8,5.9841e+02_r8,6.3319e+02_r8,6.7525e+02_r8,7.1925e+02_r8/)
      kbo(:,23,11) = (/ &
     &5.2309e+02_r8,5.5425e+02_r8,5.9038e+02_r8,6.2826e+02_r8,6.6879e+02_r8/)
      kbo(:,24,11) = (/ &
     &4.8568e+02_r8,5.1820e+02_r8,5.5078e+02_r8,5.8566e+02_r8,6.2252e+02_r8/)
      kbo(:,25,11) = (/ &
     &4.5215e+02_r8,4.8337e+02_r8,5.1498e+02_r8,5.4697e+02_r8,5.8166e+02_r8/)
      kbo(:,26,11) = (/ &
     &4.2013e+02_r8,4.5049e+02_r8,4.8168e+02_r8,5.1282e+02_r8,5.4620e+02_r8/)
      kbo(:,27,11) = (/ &
     &3.8959e+02_r8,4.1991e+02_r8,4.5056e+02_r8,4.8229e+02_r8,5.1534e+02_r8/)
      kbo(:,28,11) = (/ &
     &3.6165e+02_r8,3.9145e+02_r8,4.2248e+02_r8,4.5510e+02_r8,4.8890e+02_r8/)
      kbo(:,29,11) = (/ &
     &3.3655e+02_r8,3.6613e+02_r8,3.9802e+02_r8,4.3186e+02_r8,4.6748e+02_r8/)
      kbo(:,30,11) = (/ &
     &3.1395e+02_r8,3.4455e+02_r8,3.7776e+02_r8,4.1303e+02_r8,4.5043e+02_r8/)
      kbo(:,31,11) = (/ &
     &2.9496e+02_r8,3.2692e+02_r8,3.6155e+02_r8,3.9895e+02_r8,4.3848e+02_r8/)
      kbo(:,32,11) = (/ &
     &2.7981e+02_r8,3.1316e+02_r8,3.4973e+02_r8,3.8935e+02_r8,4.3105e+02_r8/)
      kbo(:,33,11) = (/ &
     &2.6816e+02_r8,3.0318e+02_r8,3.4211e+02_r8,3.8404e+02_r8,4.2836e+02_r8/)
      kbo(:,34,11) = (/ &
     &2.5884e+02_r8,2.9576e+02_r8,3.3707e+02_r8,3.8116e+02_r8,4.2770e+02_r8/)
      kbo(:,35,11) = (/ &
     &2.4952e+02_r8,2.8807e+02_r8,3.3125e+02_r8,3.7732e+02_r8,4.2524e+02_r8/)
      kbo(:,36,11) = (/ &
     &2.3943e+02_r8,2.7867e+02_r8,3.2325e+02_r8,3.7058e+02_r8,4.1944e+02_r8/)
      kbo(:,37,11) = (/ &
     &2.2613e+02_r8,2.6501e+02_r8,3.0984e+02_r8,3.5803e+02_r8,4.0758e+02_r8/)
      kbo(:,38,11) = (/ &
     &2.1436e+02_r8,2.5281e+02_r8,2.9747e+02_r8,3.4610e+02_r8,3.9628e+02_r8/)
      kbo(:,39,11) = (/ &
     &2.0421e+02_r8,2.4224e+02_r8,2.8638e+02_r8,3.3523e+02_r8,3.8565e+02_r8/)
      kbo(:,40,11) = (/ &
     &1.9196e+02_r8,2.2865e+02_r8,2.7155e+02_r8,3.1991e+02_r8,3.7045e+02_r8/)
      kbo(:,41,11) = (/ &
     &1.8048e+02_r8,2.1574e+02_r8,2.5717e+02_r8,3.0447e+02_r8,3.5504e+02_r8/)
      kbo(:,42,11) = (/ &
     &1.7002e+02_r8,2.0375e+02_r8,2.4381e+02_r8,2.8960e+02_r8,3.3999e+02_r8/)
      kbo(:,43,11) = (/ &
     &1.5882e+02_r8,1.9068e+02_r8,2.2888e+02_r8,2.7297e+02_r8,3.2243e+02_r8/)
      kbo(:,44,11) = (/ &
     &1.4807e+02_r8,1.7774e+02_r8,2.1381e+02_r8,2.5595e+02_r8,3.0384e+02_r8/)
      kbo(:,45,11) = (/ &
     &1.3832e+02_r8,1.6584e+02_r8,1.9975e+02_r8,2.3997e+02_r8,2.8600e+02_r8/)
      kbo(:,46,11) = (/ &
     &1.2854e+02_r8,1.5423e+02_r8,1.8595e+02_r8,2.2400e+02_r8,2.6785e+02_r8/)
      kbo(:,47,11) = (/ &
     &1.1798e+02_r8,1.4267e+02_r8,1.7172e+02_r8,2.0717e+02_r8,2.4874e+02_r8/)
      kbo(:,48,11) = (/ &
     &1.0754e+02_r8,1.3197e+02_r8,1.5865e+02_r8,1.9157e+02_r8,2.3076e+02_r8/)
      kbo(:,49,11) = (/ &
     &9.7426e+01_r8,1.2165e+02_r8,1.4680e+02_r8,1.7709e+02_r8,2.1383e+02_r8/)
      kbo(:,50,11) = (/ &
     &8.8058e+01_r8,1.1199e+02_r8,1.3670e+02_r8,1.6456e+02_r8,1.9880e+02_r8/)
      kbo(:,51,11) = (/ &
     &7.9382e+01_r8,1.0270e+02_r8,1.2731e+02_r8,1.5331e+02_r8,1.8527e+02_r8/)
      kbo(:,52,11) = (/ &
     &7.1270e+01_r8,9.3720e+01_r8,1.1802e+02_r8,1.4309e+02_r8,1.7263e+02_r8/)
      kbo(:,53,11) = (/ &
     &6.3724e+01_r8,8.4883e+01_r8,1.0881e+02_r8,1.3358e+02_r8,1.6088e+02_r8/)
      kbo(:,54,11) = (/ &
     &5.7330e+01_r8,7.7159e+01_r8,1.0045e+02_r8,1.2510e+02_r8,1.5088e+02_r8/)
      kbo(:,55,11) = (/ &
     &5.1611e+01_r8,7.0208e+01_r8,9.2617e+01_r8,1.1701e+02_r8,1.4209e+02_r8/)
      kbo(:,56,11) = (/ &
     &4.6383e+01_r8,6.3679e+01_r8,8.4927e+01_r8,1.0898e+02_r8,1.3380e+02_r8/)
      kbo(:,57,11) = (/ &
     &4.1604e+01_r8,5.7613e+01_r8,7.7613e+01_r8,1.0100e+02_r8,1.2575e+02_r8/)
      kbo(:,58,11) = (/ &
     &3.7495e+01_r8,5.2208e+01_r8,7.1056e+01_r8,9.3655e+01_r8,1.1815e+02_r8/)
      kbo(:,59,11) = (/ &
     &3.5885e+01_r8,5.0106e+01_r8,6.8487e+01_r8,9.0651e+01_r8,1.1506e+02_r8/)
      kbo(:,13,12) = (/ &
     &3.5806e+03_r8,3.5582e+03_r8,3.5338e+03_r8,3.5034e+03_r8,3.4725e+03_r8/)
      kbo(:,14,12) = (/ &
     &3.4862e+03_r8,3.4597e+03_r8,3.4292e+03_r8,3.3949e+03_r8,3.3614e+03_r8/)
      kbo(:,15,12) = (/ &
     &3.3163e+03_r8,3.2855e+03_r8,3.2498e+03_r8,3.2159e+03_r8,3.1795e+03_r8/)
      kbo(:,16,12) = (/ &
     &3.0905e+03_r8,3.0565e+03_r8,3.0217e+03_r8,2.9883e+03_r8,2.9514e+03_r8/)
      kbo(:,17,12) = (/ &
     &2.8252e+03_r8,2.7909e+03_r8,2.7597e+03_r8,2.7275e+03_r8,2.6935e+03_r8/)
      kbo(:,18,12) = (/ &
     &2.5391e+03_r8,2.5095e+03_r8,2.4810e+03_r8,2.4508e+03_r8,2.4233e+03_r8/)
      kbo(:,19,12) = (/ &
     &2.2475e+03_r8,2.2231e+03_r8,2.1980e+03_r8,2.1744e+03_r8,2.1532e+03_r8/)
      kbo(:,20,12) = (/ &
     &1.9592e+03_r8,1.9385e+03_r8,1.9191e+03_r8,1.9031e+03_r8,1.8880e+03_r8/)
      kbo(:,21,12) = (/ &
     &1.6882e+03_r8,1.6730e+03_r8,1.6603e+03_r8,1.6503e+03_r8,1.6513e+03_r8/)
      kbo(:,22,12) = (/ &
     &1.4424e+03_r8,1.4327e+03_r8,1.4274e+03_r8,1.4386e+03_r8,1.4720e+03_r8/)
      kbo(:,23,12) = (/ &
     &1.2274e+03_r8,1.2245e+03_r8,1.2417e+03_r8,1.2835e+03_r8,1.3444e+03_r8/)
      kbo(:,24,12) = (/ &
     &1.0462e+03_r8,1.0639e+03_r8,1.1088e+03_r8,1.1752e+03_r8,1.2597e+03_r8/)
      kbo(:,25,12) = (/ &
     &9.1114e+02_r8,9.5200e+02_r8,1.0177e+03_r8,1.1057e+03_r8,1.2094e+03_r8/)
      kbo(:,26,12) = (/ &
     &8.2003e+02_r8,8.7985e+02_r8,9.6324e+02_r8,1.0645e+03_r8,1.1739e+03_r8/)
      kbo(:,27,12) = (/ &
     &7.6267e+02_r8,8.3792e+02_r8,9.2956e+02_r8,1.0323e+03_r8,1.1455e+03_r8/)
      kbo(:,28,12) = (/ &
     &7.2963e+02_r8,8.0994e+02_r8,9.0250e+02_r8,1.0075e+03_r8,1.1258e+03_r8/)
      kbo(:,29,12) = (/ &
     &7.0594e+02_r8,7.8863e+02_r8,8.8342e+02_r8,9.9282e+02_r8,1.1166e+03_r8/)
      kbo(:,30,12) = (/ &
     &6.8865e+02_r8,7.7319e+02_r8,8.7237e+02_r8,9.8744e+02_r8,1.1171e+03_r8/)
      kbo(:,31,12) = (/ &
     &6.7685e+02_r8,7.6521e+02_r8,8.7052e+02_r8,9.9144e+02_r8,1.1267e+03_r8/)
      kbo(:,32,12) = (/ &
     &6.7111e+02_r8,7.6562e+02_r8,8.7695e+02_r8,1.0037e+03_r8,1.1434e+03_r8/)
      kbo(:,33,12) = (/ &
     &6.7259e+02_r8,7.7346e+02_r8,8.9020e+02_r8,1.0220e+03_r8,1.1658e+03_r8/)
      kbo(:,34,12) = (/ &
     &6.7713e+02_r8,7.8296e+02_r8,9.0470e+02_r8,1.0405e+03_r8,1.1875e+03_r8/)
      kbo(:,35,12) = (/ &
     &6.7665e+02_r8,7.8599e+02_r8,9.1053e+02_r8,1.0483e+03_r8,1.1976e+03_r8/)
      kbo(:,36,12) = (/ &
     &6.6854e+02_r8,7.7898e+02_r8,9.0439e+02_r8,1.0428e+03_r8,1.1928e+03_r8/)
      kbo(:,37,12) = (/ &
     &6.4709e+02_r8,7.5625e+02_r8,8.8001e+02_r8,1.0171e+03_r8,1.1660e+03_r8/)
      kbo(:,38,12) = (/ &
     &6.2682e+02_r8,7.3409e+02_r8,8.5611e+02_r8,9.9182e+02_r8,1.1392e+03_r8/)
      kbo(:,39,12) = (/ &
     &6.0784e+02_r8,7.1328e+02_r8,8.3356e+02_r8,9.6784e+02_r8,1.1136e+03_r8/)
      kbo(:,40,12) = (/ &
     &5.7971e+02_r8,6.8247e+02_r8,7.9953e+02_r8,9.3053e+02_r8,1.0739e+03_r8/)
      kbo(:,41,12) = (/ &
     &5.5088e+02_r8,6.5173e+02_r8,7.6511e+02_r8,8.9294e+02_r8,1.0334e+03_r8/)
      kbo(:,42,12) = (/ &
     &5.2250e+02_r8,6.2258e+02_r8,7.3222e+02_r8,8.5651e+02_r8,9.9385e+02_r8/)
      kbo(:,43,12) = (/ &
     &4.8933e+02_r8,5.8876e+02_r8,6.9433e+02_r8,8.1420e+02_r8,9.4769e+02_r8/)
      kbo(:,44,12) = (/ &
     &4.5428e+02_r8,5.5295e+02_r8,6.5546e+02_r8,7.7054e+02_r8,8.9971e+02_r8/)
      kbo(:,45,12) = (/ &
     &4.2007e+02_r8,5.1771e+02_r8,6.1870e+02_r8,7.2869e+02_r8,8.5325e+02_r8/)
      kbo(:,46,12) = (/ &
     &3.8522e+02_r8,4.8086e+02_r8,5.8089e+02_r8,6.8626e+02_r8,8.0577e+02_r8/)
      kbo(:,47,12) = (/ &
     &3.4877e+02_r8,4.4033e+02_r8,5.3933e+02_r8,6.4157e+02_r8,7.5519e+02_r8/)
      kbo(:,48,12) = (/ &
     &3.1493e+02_r8,4.0108e+02_r8,4.9823e+02_r8,5.9910e+02_r8,7.0691e+02_r8/)
      kbo(:,49,12) = (/ &
     &2.8364e+02_r8,3.6388e+02_r8,4.5779e+02_r8,5.5756e+02_r8,6.6121e+02_r8/)
      kbo(:,50,12) = (/ &
     &2.5678e+02_r8,3.3121e+02_r8,4.2060e+02_r8,5.1905e+02_r8,6.2075e+02_r8/)
      kbo(:,51,12) = (/ &
     &2.3307e+02_r8,3.0175e+02_r8,3.8585e+02_r8,4.8220e+02_r8,5.8283e+02_r8/)
      kbo(:,52,12) = (/ &
     &2.1162e+02_r8,2.7441e+02_r8,3.5299e+02_r8,4.4577e+02_r8,5.4547e+02_r8/)
      kbo(:,53,12) = (/ &
     &1.9234e+02_r8,2.4923e+02_r8,3.2216e+02_r8,4.1019e+02_r8,5.0837e+02_r8/)
      kbo(:,54,12) = (/ &
     &1.7628e+02_r8,2.2813e+02_r8,2.9582e+02_r8,3.7887e+02_r8,4.7480e+02_r8/)
      kbo(:,55,12) = (/ &
     &1.6140e+02_r8,2.0966e+02_r8,2.7210e+02_r8,3.5029e+02_r8,4.4296e+02_r8/)
      kbo(:,56,12) = (/ &
     &1.4678e+02_r8,1.9288e+02_r8,2.5016e+02_r8,3.2346e+02_r8,4.1177e+02_r8/)
      kbo(:,57,12) = (/ &
     &1.3255e+02_r8,1.7758e+02_r8,2.2997e+02_r8,2.9828e+02_r8,3.8188e+02_r8/)
      kbo(:,58,12) = (/ &
     &1.1943e+02_r8,1.6353e+02_r8,2.1228e+02_r8,2.7566e+02_r8,3.5477e+02_r8/)
      kbo(:,59,12) = (/ &
     &1.1423e+02_r8,1.5792e+02_r8,2.0564e+02_r8,2.6702e+02_r8,3.4426e+02_r8/)
      kbo(:,13,13) = (/ &
     &6.2371e+03_r8,6.2518e+03_r8,6.2489e+03_r8,6.2389e+03_r8,6.2163e+03_r8/)
      kbo(:,14,13) = (/ &
     &6.5479e+03_r8,6.5460e+03_r8,6.5322e+03_r8,6.5131e+03_r8,6.4799e+03_r8/)
      kbo(:,15,13) = (/ &
     &6.7275e+03_r8,6.7134e+03_r8,6.6981e+03_r8,6.6679e+03_r8,6.6340e+03_r8/)
      kbo(:,16,13) = (/ &
     &6.7706e+03_r8,6.7549e+03_r8,6.7279e+03_r8,6.6968e+03_r8,6.6585e+03_r8/)
      kbo(:,17,13) = (/ &
     &6.6836e+03_r8,6.6601e+03_r8,6.6362e+03_r8,6.6043e+03_r8,6.5760e+03_r8/)
      kbo(:,18,13) = (/ &
     &6.4651e+03_r8,6.4504e+03_r8,6.4295e+03_r8,6.4100e+03_r8,6.3855e+03_r8/)
      kbo(:,19,13) = (/ &
     &6.1476e+03_r8,6.1374e+03_r8,6.1314e+03_r8,6.1247e+03_r8,6.1206e+03_r8/)
      kbo(:,20,13) = (/ &
     &5.7657e+03_r8,5.7701e+03_r8,5.7793e+03_r8,5.7885e+03_r8,5.8038e+03_r8/)
      kbo(:,21,13) = (/ &
     &5.3372e+03_r8,5.3657e+03_r8,5.3946e+03_r8,5.4291e+03_r8,5.4659e+03_r8/)
      kbo(:,22,13) = (/ &
     &4.8964e+03_r8,4.9428e+03_r8,4.9998e+03_r8,5.0621e+03_r8,5.1258e+03_r8/)
      kbo(:,23,13) = (/ &
     &4.4608e+03_r8,4.5344e+03_r8,4.6177e+03_r8,4.7044e+03_r8,4.8008e+03_r8/)
      kbo(:,24,13) = (/ &
     &4.0572e+03_r8,4.1535e+03_r8,4.2613e+03_r8,4.3798e+03_r8,4.5026e+03_r8/)
      kbo(:,25,13) = (/ &
     &3.6891e+03_r8,3.8125e+03_r8,3.9482e+03_r8,4.0905e+03_r8,4.2411e+03_r8/)
      kbo(:,26,13) = (/ &
     &3.3690e+03_r8,3.5206e+03_r8,3.6781e+03_r8,3.8529e+03_r8,4.0416e+03_r8/)
      kbo(:,27,13) = (/ &
     &3.0960e+03_r8,3.2709e+03_r8,3.4667e+03_r8,3.6805e+03_r8,3.9027e+03_r8/)
      kbo(:,28,13) = (/ &
     &2.8685e+03_r8,3.0838e+03_r8,3.3203e+03_r8,3.5644e+03_r8,3.8131e+03_r8/)
      kbo(:,29,13) = (/ &
     &2.7079e+03_r8,2.9620e+03_r8,3.2275e+03_r8,3.4951e+03_r8,3.7635e+03_r8/)
      kbo(:,30,13) = (/ &
     &2.6061e+03_r8,2.8858e+03_r8,3.1752e+03_r8,3.4611e+03_r8,3.7451e+03_r8/)
      kbo(:,31,13) = (/ &
     &2.5477e+03_r8,2.8507e+03_r8,3.1575e+03_r8,3.4577e+03_r8,3.7506e+03_r8/)
      kbo(:,32,13) = (/ &
     &2.5270e+03_r8,2.8474e+03_r8,3.1664e+03_r8,3.4757e+03_r8,3.7742e+03_r8/)
      kbo(:,33,13) = (/ &
     &2.5348e+03_r8,2.8669e+03_r8,3.1934e+03_r8,3.5095e+03_r8,3.8093e+03_r8/)
      kbo(:,34,13) = (/ &
     &2.5519e+03_r8,2.8931e+03_r8,3.2251e+03_r8,3.5432e+03_r8,3.8451e+03_r8/)
      kbo(:,35,13) = (/ &
     &2.5512e+03_r8,2.8985e+03_r8,3.2338e+03_r8,3.5558e+03_r8,3.8584e+03_r8/)
      kbo(:,36,13) = (/ &
     &2.5221e+03_r8,2.8745e+03_r8,3.2143e+03_r8,3.5395e+03_r8,3.8450e+03_r8/)
      kbo(:,37,13) = (/ &
     &2.4460e+03_r8,2.8025e+03_r8,3.1490e+03_r8,3.4791e+03_r8,3.7899e+03_r8/)
      kbo(:,38,13) = (/ &
     &2.3708e+03_r8,2.7313e+03_r8,3.0831e+03_r8,3.4179e+03_r8,3.7342e+03_r8/)
      kbo(:,39,13) = (/ &
     &2.3003e+03_r8,2.6642e+03_r8,3.0201e+03_r8,3.3586e+03_r8,3.6803e+03_r8/)
      kbo(:,40,13) = (/ &
     &2.1969e+03_r8,2.5616e+03_r8,2.9219e+03_r8,3.2671e+03_r8,3.5954e+03_r8/)
      kbo(:,41,13) = (/ &
     &2.0924e+03_r8,2.4560e+03_r8,2.8204e+03_r8,3.1716e+03_r8,3.5055e+03_r8/)
      kbo(:,42,13) = (/ &
     &1.9915e+03_r8,2.3511e+03_r8,2.7188e+03_r8,3.0759e+03_r8,3.4151e+03_r8/)
      kbo(:,43,13) = (/ &
     &1.8747e+03_r8,2.2279e+03_r8,2.5969e+03_r8,2.9589e+03_r8,3.3053e+03_r8/)
      kbo(:,44,13) = (/ &
     &1.7544e+03_r8,2.0986e+03_r8,2.4653e+03_r8,2.8326e+03_r8,3.1860e+03_r8/)
      kbo(:,45,13) = (/ &
     &1.6386e+03_r8,1.9731e+03_r8,2.3348e+03_r8,2.7048e+03_r8,3.0644e+03_r8/)
      kbo(:,46,13) = (/ &
     &1.5205e+03_r8,1.8444e+03_r8,2.1974e+03_r8,2.5688e+03_r8,2.9332e+03_r8/)
      kbo(:,47,13) = (/ &
     &1.3958e+03_r8,1.7058e+03_r8,2.0486e+03_r8,2.4160e+03_r8,2.7851e+03_r8/)
      kbo(:,48,13) = (/ &
     &1.2783e+03_r8,1.5734e+03_r8,1.9036e+03_r8,2.2627e+03_r8,2.6347e+03_r8/)
      kbo(:,49,13) = (/ &
     &1.1678e+03_r8,1.4470e+03_r8,1.7643e+03_r8,2.1130e+03_r8,2.4832e+03_r8/)
      kbo(:,50,13) = (/ &
     &1.0712e+03_r8,1.3344e+03_r8,1.6384e+03_r8,1.9762e+03_r8,2.3408e+03_r8/)
      kbo(:,51,13) = (/ &
     &9.8353e+02_r8,1.2311e+03_r8,1.5209e+03_r8,1.8472e+03_r8,2.2032e+03_r8/)
      kbo(:,52,13) = (/ &
     &9.0254e+02_r8,1.1339e+03_r8,1.4093e+03_r8,1.7232e+03_r8,2.0693e+03_r8/)
      kbo(:,53,13) = (/ &
     &8.2760e+02_r8,1.0429e+03_r8,1.3025e+03_r8,1.6032e+03_r8,1.9381e+03_r8/)
      kbo(:,54,13) = (/ &
     &7.6424e+02_r8,9.6451e+02_r8,1.2096e+03_r8,1.4971e+03_r8,1.8216e+03_r8/)
      kbo(:,55,13) = (/ &
     &7.1080e+02_r8,8.9446e+02_r8,1.1253e+03_r8,1.4000e+03_r8,1.7133e+03_r8/)
      kbo(:,56,13) = (/ &
     &6.6381e+02_r8,8.2901e+02_r8,1.0458e+03_r8,1.3069e+03_r8,1.6083e+03_r8/)
      kbo(:,57,13) = (/ &
     &6.2290e+02_r8,7.6867e+02_r8,9.7122e+02_r8,1.2178e+03_r8,1.5070e+03_r8/)
      kbo(:,58,13) = (/ &
     &5.8709e+02_r8,7.1760e+02_r8,9.0453e+02_r8,1.1378e+03_r8,1.4149e+03_r8/)
      kbo(:,59,13) = (/ &
     &5.7268e+02_r8,6.9849e+02_r8,8.7854e+02_r8,1.1067e+03_r8,1.3783e+03_r8/)
      kbo(:,13,14) = (/ &
     &9.8812e+03_r8,9.9499e+03_r8,9.9974e+03_r8,1.0022e+04_r8,1.0029e+04_r8/)
      kbo(:,14,14) = (/ &
     &1.1156e+04_r8,1.1216e+04_r8,1.1254e+04_r8,1.1270e+04_r8,1.1265e+04_r8/)
      kbo(:,15,14) = (/ &
     &1.2449e+04_r8,1.2496e+04_r8,1.2517e+04_r8,1.2519e+04_r8,1.2490e+04_r8/)
      kbo(:,16,14) = (/ &
     &1.3700e+04_r8,1.3729e+04_r8,1.3741e+04_r8,1.3718e+04_r8,1.3680e+04_r8/)
      kbo(:,17,14) = (/ &
     &1.4861e+04_r8,1.4895e+04_r8,1.4882e+04_r8,1.4853e+04_r8,1.4786e+04_r8/)
      kbo(:,18,14) = (/ &
     &1.5910e+04_r8,1.5917e+04_r8,1.5910e+04_r8,1.5867e+04_r8,1.5794e+04_r8/)
      kbo(:,19,14) = (/ &
     &1.6801e+04_r8,1.6817e+04_r8,1.6802e+04_r8,1.6758e+04_r8,1.6676e+04_r8/)
      kbo(:,20,14) = (/ &
     &1.7524e+04_r8,1.7556e+04_r8,1.7546e+04_r8,1.7509e+04_r8,1.7437e+04_r8/)
      kbo(:,21,14) = (/ &
     &1.8096e+04_r8,1.8141e+04_r8,1.8145e+04_r8,1.8122e+04_r8,1.8064e+04_r8/)
      kbo(:,22,14) = (/ &
     &1.8520e+04_r8,1.8595e+04_r8,1.8633e+04_r8,1.8624e+04_r8,1.8566e+04_r8/)
      kbo(:,23,14) = (/ &
     &1.8825e+04_r8,1.8946e+04_r8,1.9018e+04_r8,1.9030e+04_r8,1.8984e+04_r8/)
      kbo(:,24,14) = (/ &
     &1.9042e+04_r8,1.9220e+04_r8,1.9316e+04_r8,1.9349e+04_r8,1.9324e+04_r8/)
      kbo(:,25,14) = (/ &
     &1.9210e+04_r8,1.9418e+04_r8,1.9542e+04_r8,1.9606e+04_r8,1.9602e+04_r8/)
      kbo(:,26,14) = (/ &
     &1.9338e+04_r8,1.9577e+04_r8,1.9740e+04_r8,1.9821e+04_r8,1.9828e+04_r8/)
      kbo(:,27,14) = (/ &
     &1.9451e+04_r8,1.9723e+04_r8,1.9903e+04_r8,2.0002e+04_r8,2.0015e+04_r8/)
      kbo(:,28,14) = (/ &
     &1.9563e+04_r8,1.9853e+04_r8,2.0047e+04_r8,2.0156e+04_r8,2.0162e+04_r8/)
      kbo(:,29,14) = (/ &
     &1.9675e+04_r8,1.9975e+04_r8,2.0176e+04_r8,2.0280e+04_r8,2.0284e+04_r8/)
      kbo(:,30,14) = (/ &
     &1.9781e+04_r8,2.0092e+04_r8,2.0291e+04_r8,2.0384e+04_r8,2.0380e+04_r8/)
      kbo(:,31,14) = (/ &
     &1.9898e+04_r8,2.0205e+04_r8,2.0389e+04_r8,2.0467e+04_r8,2.0456e+04_r8/)
      kbo(:,32,14) = (/ &
     &2.0014e+04_r8,2.0306e+04_r8,2.0476e+04_r8,2.0543e+04_r8,2.0514e+04_r8/)
      kbo(:,33,14) = (/ &
     &2.0125e+04_r8,2.0400e+04_r8,2.0544e+04_r8,2.0600e+04_r8,2.0558e+04_r8/)
      kbo(:,34,14) = (/ &
     &2.0217e+04_r8,2.0476e+04_r8,2.0611e+04_r8,2.0645e+04_r8,2.0591e+04_r8/)
      kbo(:,35,14) = (/ &
     &2.0276e+04_r8,2.0526e+04_r8,2.0654e+04_r8,2.0682e+04_r8,2.0620e+04_r8/)
      kbo(:,36,14) = (/ &
     &2.0294e+04_r8,2.0553e+04_r8,2.0682e+04_r8,2.0712e+04_r8,2.0656e+04_r8/)
      kbo(:,37,14) = (/ &
     &2.0260e+04_r8,2.0540e+04_r8,2.0692e+04_r8,2.0741e+04_r8,2.0704e+04_r8/)
      kbo(:,38,14) = (/ &
     &2.0217e+04_r8,2.0522e+04_r8,2.0695e+04_r8,2.0763e+04_r8,2.0734e+04_r8/)
      kbo(:,39,14) = (/ &
     &2.0167e+04_r8,2.0500e+04_r8,2.0691e+04_r8,2.0777e+04_r8,2.0762e+04_r8/)
      kbo(:,40,14) = (/ &
     &2.0068e+04_r8,2.0438e+04_r8,2.0666e+04_r8,2.0778e+04_r8,2.0786e+04_r8/)
      kbo(:,41,14) = (/ &
     &1.9949e+04_r8,2.0361e+04_r8,2.0631e+04_r8,2.0768e+04_r8,2.0804e+04_r8/)
      kbo(:,42,14) = (/ &
     &1.9819e+04_r8,2.0274e+04_r8,2.0579e+04_r8,2.0750e+04_r8,2.0814e+04_r8/)
      kbo(:,43,14) = (/ &
     &1.9645e+04_r8,2.0149e+04_r8,2.0503e+04_r8,2.0721e+04_r8,2.0814e+04_r8/)
      kbo(:,44,14) = (/ &
     &1.9429e+04_r8,1.9994e+04_r8,2.0396e+04_r8,2.0663e+04_r8,2.0798e+04_r8/)
      kbo(:,45,14) = (/ &
     &1.9189e+04_r8,1.9824e+04_r8,2.0285e+04_r8,2.0595e+04_r8,2.0770e+04_r8/)
      kbo(:,46,14) = (/ &
     &1.8912e+04_r8,1.9621e+04_r8,2.0139e+04_r8,2.0501e+04_r8,2.0722e+04_r8/)
      kbo(:,47,14) = (/ &
     &1.8574e+04_r8,1.9355e+04_r8,1.9947e+04_r8,2.0373e+04_r8,2.0652e+04_r8/)
      kbo(:,48,14) = (/ &
     &1.8199e+04_r8,1.9060e+04_r8,1.9733e+04_r8,2.0223e+04_r8,2.0560e+04_r8/)
      kbo(:,49,14) = (/ &
     &1.7788e+04_r8,1.8737e+04_r8,1.9487e+04_r8,2.0042e+04_r8,2.0440e+04_r8/)
      kbo(:,50,14) = (/ &
     &1.7372e+04_r8,1.8402e+04_r8,1.9222e+04_r8,1.9853e+04_r8,2.0312e+04_r8/)
      kbo(:,51,14) = (/ &
     &1.6932e+04_r8,1.8048e+04_r8,1.8944e+04_r8,1.9653e+04_r8,2.0163e+04_r8/)
      kbo(:,52,14) = (/ &
     &1.6460e+04_r8,1.7668e+04_r8,1.8640e+04_r8,1.9416e+04_r8,1.9992e+04_r8/)
      kbo(:,53,14) = (/ &
     &1.5959e+04_r8,1.7252e+04_r8,1.8310e+04_r8,1.9147e+04_r8,1.9806e+04_r8/)
      kbo(:,54,14) = (/ &
     &1.5461e+04_r8,1.6846e+04_r8,1.7980e+04_r8,1.8888e+04_r8,1.9606e+04_r8/)
      kbo(:,55,14) = (/ &
     &1.4966e+04_r8,1.6424e+04_r8,1.7640e+04_r8,1.8623e+04_r8,1.9399e+04_r8/)
      kbo(:,56,14) = (/ &
     &1.4452e+04_r8,1.5984e+04_r8,1.7276e+04_r8,1.8327e+04_r8,1.9166e+04_r8/)
      kbo(:,57,14) = (/ &
     &1.3910e+04_r8,1.5518e+04_r8,1.6891e+04_r8,1.8015e+04_r8,1.8917e+04_r8/)
      kbo(:,58,14) = (/ &
     &1.3384e+04_r8,1.5053e+04_r8,1.6496e+04_r8,1.7699e+04_r8,1.8667e+04_r8/)
      kbo(:,59,14) = (/ &
     &1.3166e+04_r8,1.4859e+04_r8,1.6332e+04_r8,1.7567e+04_r8,1.8563e+04_r8/)
      kbo(:,13,15) = (/ &
     &1.3095e+04_r8,1.3203e+04_r8,1.3280e+04_r8,1.3335e+04_r8,1.3364e+04_r8/)
      kbo(:,14,15) = (/ &
     &1.5533e+04_r8,1.5637e+04_r8,1.5702e+04_r8,1.5732e+04_r8,1.5730e+04_r8/)
      kbo(:,15,15) = (/ &
     &1.8283e+04_r8,1.8379e+04_r8,1.8421e+04_r8,1.8416e+04_r8,1.8371e+04_r8/)
      kbo(:,16,15) = (/ &
     &2.1357e+04_r8,2.1409e+04_r8,2.1406e+04_r8,2.1356e+04_r8,2.1240e+04_r8/)
      kbo(:,17,15) = (/ &
     &2.4722e+04_r8,2.4699e+04_r8,2.4632e+04_r8,2.4482e+04_r8,2.4282e+04_r8/)
      kbo(:,18,15) = (/ &
     &2.8315e+04_r8,2.8214e+04_r8,2.8019e+04_r8,2.7755e+04_r8,2.7441e+04_r8/)
      kbo(:,19,15) = (/ &
     &3.2071e+04_r8,3.1837e+04_r8,3.1501e+04_r8,3.1092e+04_r8,3.0622e+04_r8/)
      kbo(:,20,15) = (/ &
     &3.5875e+04_r8,3.5466e+04_r8,3.4981e+04_r8,3.4394e+04_r8,3.3745e+04_r8/)
      kbo(:,21,15) = (/ &
     &3.9627e+04_r8,3.9030e+04_r8,3.8357e+04_r8,3.7580e+04_r8,3.6746e+04_r8/)
      kbo(:,22,15) = (/ &
     &4.3205e+04_r8,4.2400e+04_r8,4.1478e+04_r8,4.0494e+04_r8,3.9468e+04_r8/)
      kbo(:,23,15) = (/ &
     &4.6532e+04_r8,4.5460e+04_r8,4.4309e+04_r8,4.3126e+04_r8,4.1899e+04_r8/)
      kbo(:,24,15) = (/ &
     &4.9513e+04_r8,4.8176e+04_r8,4.6831e+04_r8,4.5435e+04_r8,4.4005e+04_r8/)
      kbo(:,25,15) = (/ &
     &5.2106e+04_r8,5.0560e+04_r8,4.9001e+04_r8,4.7400e+04_r8,4.5767e+04_r8/)
      kbo(:,26,15) = (/ &
     &5.4289e+04_r8,5.2537e+04_r8,5.0767e+04_r8,4.8979e+04_r8,4.7180e+04_r8/)
      kbo(:,27,15) = (/ &
     &5.6074e+04_r8,5.4129e+04_r8,5.2176e+04_r8,5.0219e+04_r8,4.8292e+04_r8/)
      kbo(:,28,15) = (/ &
     &5.7491e+04_r8,5.5358e+04_r8,5.3246e+04_r8,5.1171e+04_r8,4.9128e+04_r8/)
      kbo(:,29,15) = (/ &
     &5.8538e+04_r8,5.6261e+04_r8,5.4015e+04_r8,5.1836e+04_r8,4.9710e+04_r8/)
      kbo(:,30,15) = (/ &
     &5.9277e+04_r8,5.6882e+04_r8,5.4538e+04_r8,5.2280e+04_r8,5.0075e+04_r8/)
      kbo(:,31,15) = (/ &
     &5.9738e+04_r8,5.7244e+04_r8,5.4845e+04_r8,5.2509e+04_r8,5.0252e+04_r8/)
      kbo(:,32,15) = (/ &
     &5.9975e+04_r8,5.7405e+04_r8,5.4958e+04_r8,5.2573e+04_r8,5.0275e+04_r8/)
      kbo(:,33,15) = (/ &
     &6.0007e+04_r8,5.7410e+04_r8,5.4914e+04_r8,5.2499e+04_r8,5.0167e+04_r8/)
      kbo(:,34,15) = (/ &
     &5.9998e+04_r8,5.7359e+04_r8,5.4840e+04_r8,5.2398e+04_r8,5.0041e+04_r8/)
      kbo(:,35,15) = (/ &
     &6.0132e+04_r8,5.7462e+04_r8,5.4907e+04_r8,5.2438e+04_r8,5.0062e+04_r8/)
      kbo(:,36,15) = (/ &
     &6.0467e+04_r8,5.7764e+04_r8,5.5174e+04_r8,5.2679e+04_r8,5.0279e+04_r8/)
      kbo(:,37,15) = (/ &
     &6.1171e+04_r8,5.8407e+04_r8,5.5781e+04_r8,5.3245e+04_r8,5.0803e+04_r8/)
      kbo(:,38,15) = (/ &
     &6.1845e+04_r8,5.9045e+04_r8,5.6369e+04_r8,5.3796e+04_r8,5.1321e+04_r8/)
      kbo(:,39,15) = (/ &
     &6.2474e+04_r8,5.9622e+04_r8,5.6925e+04_r8,5.4319e+04_r8,5.1811e+04_r8/)
      kbo(:,40,15) = (/ &
     &6.3380e+04_r8,6.0485e+04_r8,5.7724e+04_r8,5.5082e+04_r8,5.2540e+04_r8/)
      kbo(:,41,15) = (/ &
     &6.4308e+04_r8,6.1360e+04_r8,5.8546e+04_r8,5.5868e+04_r8,5.3286e+04_r8/)
      kbo(:,42,15) = (/ &
     &6.5214e+04_r8,6.2221e+04_r8,5.9366e+04_r8,5.6643e+04_r8,5.4029e+04_r8/)
      kbo(:,43,15) = (/ &
     &6.6280e+04_r8,6.3259e+04_r8,6.0335e+04_r8,5.7567e+04_r8,5.4915e+04_r8/)
      kbo(:,44,15) = (/ &
     &6.7443e+04_r8,6.4360e+04_r8,6.1383e+04_r8,5.8557e+04_r8,5.5857e+04_r8/)
      kbo(:,45,15) = (/ &
     &6.8616e+04_r8,6.5461e+04_r8,6.2445e+04_r8,5.9557e+04_r8,5.6818e+04_r8/)
      kbo(:,46,15) = (/ &
     &6.9855e+04_r8,6.6628e+04_r8,6.3578e+04_r8,6.0631e+04_r8,5.7835e+04_r8/)
      kbo(:,47,15) = (/ &
     &7.1240e+04_r8,6.7969e+04_r8,6.4839e+04_r8,6.1843e+04_r8,5.8987e+04_r8/)
      kbo(:,48,15) = (/ &
     &7.2637e+04_r8,6.9326e+04_r8,6.6121e+04_r8,6.3073e+04_r8,6.0145e+04_r8/)
      kbo(:,49,15) = (/ &
     &7.4017e+04_r8,7.0688e+04_r8,6.7429e+04_r8,6.4324e+04_r8,6.1340e+04_r8/)
      kbo(:,50,15) = (/ &
     &7.5349e+04_r8,7.1972e+04_r8,6.8674e+04_r8,6.5502e+04_r8,6.2467e+04_r8/)
      kbo(:,51,15) = (/ &
     &7.6637e+04_r8,7.3219e+04_r8,6.9913e+04_r8,6.6663e+04_r8,6.3587e+04_r8/)
      kbo(:,52,15) = (/ &
     &7.7955e+04_r8,7.4483e+04_r8,7.1122e+04_r8,6.7846e+04_r8,6.4721e+04_r8/)
      kbo(:,53,15) = (/ &
     &7.9280e+04_r8,7.5753e+04_r8,7.2364e+04_r8,6.9053e+04_r8,6.5858e+04_r8/)
      kbo(:,54,15) = (/ &
     &8.0495e+04_r8,7.6933e+04_r8,7.3504e+04_r8,7.0171e+04_r8,6.6914e+04_r8/)
      kbo(:,55,15) = (/ &
     &8.1662e+04_r8,7.8089e+04_r8,7.4612e+04_r8,7.1233e+04_r8,6.7959e+04_r8/)
      kbo(:,56,15) = (/ &
     &8.2843e+04_r8,7.9230e+04_r8,7.5715e+04_r8,7.2316e+04_r8,6.9008e+04_r8/)
      kbo(:,57,15) = (/ &
     &8.4005e+04_r8,8.0398e+04_r8,7.6842e+04_r8,7.3404e+04_r8,7.0077e+04_r8/)
      kbo(:,58,15) = (/ &
     &8.5078e+04_r8,8.1502e+04_r8,7.7919e+04_r8,7.4439e+04_r8,7.1083e+04_r8/)
      kbo(:,59,15) = (/ &
     &8.5505e+04_r8,8.1958e+04_r8,7.8361e+04_r8,7.4870e+04_r8,7.1482e+04_r8/)
      kbo(:,13,16) = (/ &
     &1.4816e+04_r8,1.4930e+04_r8,1.5014e+04_r8,1.5052e+04_r8,1.5044e+04_r8/)
      kbo(:,14,16) = (/ &
     &1.7836e+04_r8,1.7951e+04_r8,1.8019e+04_r8,1.8017e+04_r8,1.7984e+04_r8/)
      kbo(:,15,16) = (/ &
     &2.1381e+04_r8,2.1462e+04_r8,2.1481e+04_r8,2.1430e+04_r8,2.1342e+04_r8/)
      kbo(:,16,16) = (/ &
     &2.5477e+04_r8,2.5475e+04_r8,2.5403e+04_r8,2.5275e+04_r8,2.5089e+04_r8/)
      kbo(:,17,16) = (/ &
     &3.0124e+04_r8,3.0002e+04_r8,2.9773e+04_r8,2.9519e+04_r8,2.9186e+04_r8/)
      kbo(:,18,16) = (/ &
     &3.5286e+04_r8,3.4965e+04_r8,3.4530e+04_r8,3.4092e+04_r8,3.3540e+04_r8/)
      kbo(:,19,16) = (/ &
     &4.0852e+04_r8,4.0241e+04_r8,3.9575e+04_r8,3.8871e+04_r8,3.8057e+04_r8/)
      kbo(:,20,16) = (/ &
     &4.6699e+04_r8,4.5739e+04_r8,4.4741e+04_r8,4.3700e+04_r8,4.2576e+04_r8/)
      kbo(:,21,16) = (/ &
     &5.2654e+04_r8,5.1275e+04_r8,4.9864e+04_r8,4.8428e+04_r8,4.6961e+04_r8/)
      kbo(:,22,16) = (/ &
     &5.8403e+04_r8,5.6551e+04_r8,5.4684e+04_r8,5.2822e+04_r8,5.0976e+04_r8/)
      kbo(:,23,16) = (/ &
     &6.3816e+04_r8,6.1463e+04_r8,5.9121e+04_r8,5.6821e+04_r8,5.4590e+04_r8/)
      kbo(:,24,16) = (/ &
     &6.8713e+04_r8,6.5863e+04_r8,6.3058e+04_r8,6.0345e+04_r8,5.7751e+04_r8/)
      kbo(:,25,16) = (/ &
     &7.2989e+04_r8,6.9656e+04_r8,6.6424e+04_r8,6.3329e+04_r8,6.0404e+04_r8/)
      kbo(:,26,16) = (/ &
     &7.6570e+04_r8,7.2775e+04_r8,6.9149e+04_r8,6.5716e+04_r8,6.2522e+04_r8/)
      kbo(:,27,16) = (/ &
     &7.9459e+04_r8,7.5274e+04_r8,7.1313e+04_r8,6.7589e+04_r8,6.4169e+04_r8/)
      kbo(:,28,16) = (/ &
     &8.1683e+04_r8,7.7174e+04_r8,7.2947e+04_r8,6.8995e+04_r8,6.5376e+04_r8/)
      kbo(:,29,16) = (/ &
     &8.3285e+04_r8,7.8510e+04_r8,7.4071e+04_r8,6.9957e+04_r8,6.6188e+04_r8/)
      kbo(:,30,16) = (/ &
     &8.4346e+04_r8,7.9371e+04_r8,7.4777e+04_r8,7.0557e+04_r8,6.6673e+04_r8/)
      kbo(:,31,16) = (/ &
     &8.4928e+04_r8,7.9835e+04_r8,7.5096e+04_r8,7.0806e+04_r8,6.6861e+04_r8/)
      kbo(:,32,16) = (/ &
     &8.5101e+04_r8,7.9916e+04_r8,7.5117e+04_r8,7.0792e+04_r8,6.6791e+04_r8/)
      kbo(:,33,16) = (/ &
     &8.4949e+04_r8,7.9717e+04_r8,7.4898e+04_r8,7.0557e+04_r8,6.6529e+04_r8/)
      kbo(:,34,16) = (/ &
     &8.4743e+04_r8,7.9470e+04_r8,7.4656e+04_r8,7.0309e+04_r8,6.6256e+04_r8/)
      kbo(:,35,16) = (/ &
     &8.4858e+04_r8,7.9542e+04_r8,7.4709e+04_r8,7.0325e+04_r8,6.6240e+04_r8/)
      kbo(:,36,16) = (/ &
     &8.5440e+04_r8,8.0039e+04_r8,7.5130e+04_r8,7.0697e+04_r8,6.6564e+04_r8/)
      kbo(:,37,16) = (/ &
     &8.6760e+04_r8,8.1217e+04_r8,7.6179e+04_r8,7.1644e+04_r8,6.7431e+04_r8/)
      kbo(:,38,16) = (/ &
     &8.8049e+04_r8,8.2388e+04_r8,7.7214e+04_r8,7.2579e+04_r8,6.8294e+04_r8/)
      kbo(:,39,16) = (/ &
     &8.9280e+04_r8,8.3525e+04_r8,7.8218e+04_r8,7.3474e+04_r8,6.9111e+04_r8/)
      kbo(:,40,16) = (/ &
     &9.1121e+04_r8,8.5172e+04_r8,7.9710e+04_r8,7.4807e+04_r8,7.0344e+04_r8/)
      kbo(:,41,16) = (/ &
     &9.3033e+04_r8,8.6893e+04_r8,8.1281e+04_r8,7.6203e+04_r8,7.1626e+04_r8/)
      kbo(:,42,16) = (/ &
     &9.4965e+04_r8,8.8622e+04_r8,8.0415e+04_r8,7.7606e+04_r8,7.2910e+04_r8/)
      kbo(:,43,16) = (/ &
     &9.7303e+04_r8,9.0720e+04_r8,8.4775e+04_r8,7.9330e+04_r8,7.4454e+04_r8/)
      kbo(:,44,16) = (/ &
     &9.9859e+04_r8,9.3029e+04_r8,8.6867e+04_r8,8.1230e+04_r8,7.6153e+04_r8/)
      kbo(:,45,16) = (/ &
     &1.0249e+05_r8,9.5410e+04_r8,8.8999e+04_r8,8.3177e+04_r8,7.7890e+04_r8/)
      kbo(:,46,16) = (/ &
     &1.0536e+05_r8,9.7993e+04_r8,9.1330e+04_r8,8.5316e+04_r8,7.9796e+04_r8/)
      kbo(:,47,16) = (/ &
     &1.0871e+05_r8,1.0095e+05_r8,9.4014e+04_r8,8.7743e+04_r8,8.2024e+04_r8/)
      kbo(:,48,16) = (/ &
     &1.1228e+05_r8,1.0405e+05_r8,9.6823e+04_r8,9.0264e+04_r8,8.4322e+04_r8/)
      kbo(:,49,16) = (/ &
     &1.1602e+05_r8,1.0727e+05_r8,9.9709e+04_r8,9.2873e+04_r8,8.6711e+04_r8/)
      kbo(:,50,16) = (/ &
     &1.1975e+05_r8,1.1051e+05_r8,1.0253e+05_r8,9.5425e+04_r8,8.8999e+04_r8/)
      kbo(:,51,16) = (/ &
     &1.2354e+05_r8,1.1380e+05_r8,1.0536e+05_r8,9.7987e+04_r8,9.1299e+04_r8/)
      kbo(:,52,16) = (/ &
     &1.2745e+05_r8,1.1723e+05_r8,1.0833e+05_r8,1.0062e+05_r8,9.3694e+04_r8/)
      kbo(:,53,16) = (/ &
     &1.3160e+05_r8,1.2088e+05_r8,1.1148e+05_r8,1.0337e+05_r8,9.6183e+04_r8/)
      kbo(:,54,16) = (/ &
     &1.3555e+05_r8,1.2436e+05_r8,1.1452e+05_r8,1.0598e+05_r8,9.8537e+04_r8/)
      kbo(:,55,16) = (/ &
     &1.3946e+05_r8,1.2781e+05_r8,1.1754e+05_r8,1.0859e+05_r8,1.0085e+05_r8/)
      kbo(:,56,16) = (/ &
     &1.4362e+05_r8,1.3143e+05_r8,1.2072e+05_r8,1.1136e+05_r8,1.0326e+05_r8/)
      kbo(:,57,16) = (/ &
     &1.4797e+05_r8,1.3519e+05_r8,1.2403e+05_r8,1.1423e+05_r8,1.0573e+05_r8/)
      kbo(:,58,16) = (/ &
     &1.5241e+05_r8,1.3886e+05_r8,1.2729e+05_r8,1.1707e+05_r8,1.0818e+05_r8/)
      kbo(:,59,16) = (/ &
     &1.5431e+05_r8,1.4041e+05_r8,1.2862e+05_r8,1.1825e+05_r8,1.0919e+05_r8/)

!     The array FORREFO contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  The first 
!     index refers to reference temperature (296,260,224,260) and 
!     pressure (970,475,219,3 mbar) levels.  The second index 
!     runs over the g-channel (1 to 16).

      forrefo(1,:) = (/ &
     &2.7075e-06_r8,2.2609e-06_r8,1.5633e-06_r8,8.7484e-07_r8,5.5470e-07_r8,4.8456e-07_r8, &
     &4.7463e-07_r8,4.6154e-07_r8,4.4425e-07_r8,4.2960e-07_r8,4.2626e-07_r8,4.1715e-07_r8, &
     &4.2607e-07_r8,3.6616e-07_r8,2.6366e-07_r8,2.6029e-07_r8/)
      forrefo(2,:) = (/ &
     &2.6759e-06_r8,2.2237e-06_r8,1.4466e-06_r8,9.3032e-07_r8,6.4927e-07_r8,5.4809e-07_r8, &
     &4.9504e-07_r8,4.6305e-07_r8,4.4873e-07_r8,4.2146e-07_r8,4.2176e-07_r8,4.2812e-07_r8, &
     &4.0529e-07_r8,4.0969e-07_r8,2.9442e-07_r8,2.6821e-07_r8/)
      forrefo(3,:) = (/ &
     &2.6608e-06_r8,2.1140e-06_r8,1.4838e-06_r8,9.2083e-07_r8,6.3350e-07_r8,5.7195e-07_r8, &
     &6.2253e-07_r8,5.1783e-07_r8,4.4749e-07_r8,4.3261e-07_r8,4.2553e-07_r8,4.2175e-07_r8, &
     &4.1085e-07_r8,4.0358e-07_r8,3.5340e-07_r8,2.7191e-07_r8/)
      forrefo(4,:) = (/ &
     &2.6412e-06_r8,1.9814e-06_r8,1.2672e-06_r8,8.1129e-07_r8,7.1447e-07_r8,7.5026e-07_r8, &
     &7.4386e-07_r8,7.2759e-07_r8,7.3583e-07_r8,7.6493e-07_r8,8.8959e-07_r8,7.5534e-07_r8, &
     &5.3734e-07_r8,4.5572e-07_r8,4.1676e-07_r8,3.6198e-07_r8/)

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      selfrefo(:, 1) = (/ &
     & 4.67262e-03_r8, 3.95211e-03_r8, 3.34270e-03_r8, 2.82726e-03_r8, 2.39130e-03_r8, &
     & 2.02256e-03_r8, 1.71069e-03_r8, 1.44690e-03_r8, 1.22379e-03_r8, 1.03508e-03_r8/)
      selfrefo(:, 2) = (/ &
     & 4.42593e-03_r8, 3.73338e-03_r8, 3.14920e-03_r8, 2.65643e-03_r8, 2.24076e-03_r8, &
     & 1.89014e-03_r8, 1.59438e-03_r8, 1.34490e-03_r8, 1.13446e-03_r8, 9.56943e-04_r8/)
      selfrefo(:, 3) = (/ &
     & 3.96072e-03_r8, 3.33789e-03_r8, 2.81300e-03_r8, 2.37065e-03_r8, 1.99786e-03_r8, &
     & 1.68369e-03_r8, 1.41893e-03_r8, 1.19580e-03_r8, 1.00776e-03_r8, 8.49286e-04_r8/)
      selfrefo(:, 4) = (/ &
     & 3.71833e-03_r8, 3.10030e-03_r8, 2.58500e-03_r8, 2.15535e-03_r8, 1.79711e-03_r8, &
     & 1.49841e-03_r8, 1.24936e-03_r8, 1.04170e-03_r8, 8.68558e-04_r8, 7.24195e-04_r8/)
      selfrefo(:, 5) = (/ &
     & 3.55755e-03_r8, 2.95355e-03_r8, 2.45210e-03_r8, 2.03578e-03_r8, 1.69015e-03_r8, &
     & 1.40320e-03_r8, 1.16497e-03_r8, 9.67180e-04_r8, 8.02973e-04_r8, 6.66646e-04_r8/)
      selfrefo(:, 6) = (/ &
     & 3.47601e-03_r8, 2.88628e-03_r8, 2.39660e-03_r8, 1.99000e-03_r8, 1.65238e-03_r8, &
     & 1.37204e-03_r8, 1.13927e-03_r8, 9.45980e-04_r8, 7.85487e-04_r8, 6.52224e-04_r8/)
      selfrefo(:, 7) = (/ &
     & 3.44479e-03_r8, 2.86224e-03_r8, 2.37820e-03_r8, 1.97602e-03_r8, 1.64185e-03_r8, &
     & 1.36420e-03_r8, 1.13350e-03_r8, 9.41810e-04_r8, 7.82539e-04_r8, 6.50204e-04_r8/)
      selfrefo(:, 8) = (/ &
     & 3.40154e-03_r8, 2.82953e-03_r8, 2.35370e-03_r8, 1.95789e-03_r8, 1.62864e-03_r8, &
     & 1.35476e-03_r8, 1.12694e-03_r8, 9.37430e-04_r8, 7.79788e-04_r8, 6.48655e-04_r8/)
      selfrefo(:, 9) = (/ &
     & 3.39380e-03_r8, 2.82288e-03_r8, 2.34800e-03_r8, 1.95301e-03_r8, 1.62446e-03_r8, &
     & 1.35119e-03_r8, 1.12389e-03_r8, 9.34820e-04_r8, 7.77560e-04_r8, 6.46755e-04_r8/)
      selfrefo(:,10) = (/ &
     & 3.37185e-03_r8, 2.80654e-03_r8, 2.33600e-03_r8, 1.94435e-03_r8, 1.61837e-03_r8, &
     & 1.34704e-03_r8, 1.12120e-03_r8, 9.33220e-04_r8, 7.76759e-04_r8, 6.46530e-04_r8/)
      selfrefo(:,11) = (/ &
     & 3.37924e-03_r8, 2.81172e-03_r8, 2.33950e-03_r8, 1.94659e-03_r8, 1.61967e-03_r8, &
     & 1.34765e-03_r8, 1.12132e-03_r8, 9.33000e-04_r8, 7.76306e-04_r8, 6.45930e-04_r8/)
      selfrefo(:,12) = (/ &
     & 3.39658e-03_r8, 2.82289e-03_r8, 2.34610e-03_r8, 1.94984e-03_r8, 1.62051e-03_r8, &
     & 1.34680e-03_r8, 1.11933e-03_r8, 9.30270e-04_r8, 7.73146e-04_r8, 6.42561e-04_r8/)
      selfrefo(:,13) = (/ &
     & 3.36070e-03_r8, 2.79913e-03_r8, 2.33140e-03_r8, 1.94183e-03_r8, 1.61735e-03_r8, &
     & 1.34709e-03_r8, 1.12199e-03_r8, 9.34510e-04_r8, 7.78354e-04_r8, 6.48292e-04_r8/)
      selfrefo(:,14) = (/ &
     & 3.40428e-03_r8, 2.81994e-03_r8, 2.33590e-03_r8, 1.93495e-03_r8, 1.60282e-03_r8, &
     & 1.32770e-03_r8, 1.09980e-03_r8, 9.11020e-04_r8, 7.54645e-04_r8, 6.25111e-04_r8/)
      selfrefo(:,15) = (/ &
     & 3.27075e-03_r8, 2.70783e-03_r8, 2.24180e-03_r8, 1.85597e-03_r8, 1.53655e-03_r8, &
     & 1.27210e-03_r8, 1.05317e-03_r8, 8.71910e-04_r8, 7.21849e-04_r8, 5.97615e-04_r8/)
      selfrefo(:,16) = (/ &
     & 3.23123e-03_r8, 2.67891e-03_r8, 2.22100e-03_r8, 1.84136e-03_r8, 1.52661e-03_r8, &
     & 1.26567e-03_r8, 1.04932e-03_r8, 8.69960e-04_r8, 7.21256e-04_r8, 5.97970e-04_r8/)

      end subroutine lw_kgb14

