!     path:      $Source: /storm/rc1/cvsroot/rc/rrtmg_lw/src/rrtmg_lw_k_g.f90,v $
!     author:    $Author: mike $
!     revision:  $Revision: 1.2 $
!     created:   $Date: 2007/08/22 19:20:03 $
!
!  --------------------------------------------------------------------------
! |                                                                          |
! |  Copyright 2002-2007, Atmospheric & Environmental Research, Inc. (AER).  |
! |  This software may be used, copied, or redistributed as long as it is    |
! |  not sold and this copyright notice is reproduced on each copy made.     |
! |  This model is provided as is without any express or implied warranties. |
! |                       (http://www.rtweb.aer.com/)                        |
! |                                                                          |
!  --------------------------------------------------------------------------

! **************************************************************************
!      subroutine lw_kgbnn
! **************************************************************************
!  RRTM Longwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original version:   E. J. Mlawer, et al.
!  Revision for GCMs:  Michael J. Iacono; October, 2002
!
!  This file contains 16 subroutines that include the 
!  absorption coefficients and other data for each of the 16 longwave
!  spectral bands used in RRTM.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_LW_INIT to reduce
!  the total number of g-points from 256 to 140 for use in the GCM.
! **************************************************************************
      subroutine lw_kgb13
! **************************************************************************

      use shr_kind_mod, only: r8 => shr_kind_r8

!      use parkind, only : jpim, jprb 
      use rrlw_kg13, only : fracrefao, fracrefbo, kao, kao_mco2, kao_mco, &
                            kbo_mo3, selfrefo, forrefo

      implicit none
      save

! Planck fraction mapping level : P=473.4280 mb, T = 259.83 K      
      fracrefao(:, 1) = (/ &
     &  1.7534e-01_r8,1.7394e-01_r8,1.6089e-01_r8,1.3782e-01_r8,1.0696e-01_r8,8.5853e-02_r8, &
     &  6.6548e-02_r8,4.9053e-02_r8,3.2064e-02_r8,3.4820e-03_r8,2.8763e-03_r8,2.2204e-03_r8, &
     &  1.5612e-03_r8,9.8572e-04_r8,3.6853e-04_r8,5.1612e-05_r8/)
      fracrefao(:, 2) = (/ &
     &  1.7489e-01_r8,1.7309e-01_r8,1.5981e-01_r8,1.3782e-01_r8,1.0797e-01_r8,8.6367e-02_r8, &
     &  6.7042e-02_r8,4.9257e-02_r8,3.2207e-02_r8,3.4820e-03_r8,2.8767e-03_r8,2.2203e-03_r8, &
     &  1.5613e-03_r8,9.8571e-04_r8,3.6853e-04_r8,5.1612e-05_r8/)
      fracrefao(:, 3) = (/ &
     &  1.7459e-01_r8,1.7259e-01_r8,1.5948e-01_r8,1.3694e-01_r8,1.0815e-01_r8,8.7376e-02_r8, &
     &  6.7339e-02_r8,4.9541e-02_r8,3.2333e-02_r8,3.5019e-03_r8,2.8958e-03_r8,2.2527e-03_r8, &
     &  1.6099e-03_r8,9.8574e-04_r8,3.6853e-04_r8,5.1612e-05_r8/)
      fracrefao(:, 4) = (/ &
     &  1.7391e-01_r8,1.7244e-01_r8,1.5921e-01_r8,1.3644e-01_r8,1.0787e-01_r8,8.7776e-02_r8, &
     &  6.8361e-02_r8,4.9628e-02_r8,3.2578e-02_r8,3.5117e-03_r8,2.9064e-03_r8,2.2571e-03_r8, &
     &  1.6887e-03_r8,1.0045e-03_r8,3.6853e-04_r8,5.1612e-05_r8/)
      fracrefao(:, 5) = (/ &
     &  1.7338e-01_r8,1.7157e-01_r8,1.5957e-01_r8,1.3571e-01_r8,1.0773e-01_r8,8.7966e-02_r8, &
     &  6.9000e-02_r8,5.0300e-02_r8,3.2813e-02_r8,3.5470e-03_r8,2.9425e-03_r8,2.2552e-03_r8, &
     &  1.7038e-03_r8,1.1025e-03_r8,3.6853e-04_r8,5.1612e-05_r8/)
      fracrefao(:, 6) = (/ &
     &  1.7230e-01_r8,1.7082e-01_r8,1.5917e-01_r8,1.3562e-01_r8,1.0806e-01_r8,8.7635e-02_r8, &
     &  6.9815e-02_r8,5.1155e-02_r8,3.3139e-02_r8,3.6264e-03_r8,2.9436e-03_r8,2.3417e-03_r8, &
     &  1.7731e-03_r8,1.1156e-03_r8,4.4533e-04_r8,5.1612e-05_r8/)
      fracrefao(:, 7) = (/ &
     &  1.7073e-01_r8,1.6961e-01_r8,1.5844e-01_r8,1.3594e-01_r8,1.0821e-01_r8,8.7791e-02_r8, &
     &  7.0502e-02_r8,5.1904e-02_r8,3.4107e-02_r8,3.5888e-03_r8,2.9574e-03_r8,2.5851e-03_r8, &
     &  1.9127e-03_r8,1.1537e-03_r8,4.7789e-04_r8,1.0016e-04_r8/)
      fracrefao(:, 8) = (/ &
     &  1.6700e-01_r8,1.6848e-01_r8,1.5628e-01_r8,1.3448e-01_r8,1.1011e-01_r8,8.9016e-02_r8, &
     &  7.1973e-02_r8,5.2798e-02_r8,3.5650e-02_r8,3.8534e-03_r8,3.4142e-03_r8,2.7799e-03_r8, &
     &  2.1288e-03_r8,1.3043e-03_r8,6.2858e-04_r8,1.0016e-04_r8/)
      fracrefao(:, 9) = (/ &
     &  1.6338e-01_r8,1.5565e-01_r8,1.4470e-01_r8,1.3500e-01_r8,1.1909e-01_r8,9.8312e-02_r8, &
     &  7.9023e-02_r8,5.5728e-02_r8,3.6831e-02_r8,3.6569e-03_r8,3.0552e-03_r8,2.3431e-03_r8, &
     &  1.7088e-03_r8,1.1082e-03_r8,3.6829e-04_r8,5.1612e-05_r8/)

! Planck fraction mapping level : P=4.758820 mb, T = 250.85 K
      fracrefbo(:) = (/ &
     &  1.5411e-01_r8,1.3573e-01_r8,1.2527e-01_r8,1.2698e-01_r8,1.2394e-01_r8,1.0876e-01_r8, &
     &  8.9906e-02_r8,6.9551e-02_r8,4.8240e-02_r8,5.2434e-03_r8,4.3630e-03_r8,3.4262e-03_r8, &
     &  2.5124e-03_r8,1.5479e-03_r8,3.7294e-04_r8,5.1050e-05_r8/)

!     The array KAO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels > ~100mb, temperatures, and ratios
!     of water vapor to CO2.  The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amount ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 
!     to that of gas2.
!     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
!     to different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this  pressure 
!     level, JT = 2 refers to the temperature
!     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the reference pressure level (e.g. JP = 1 is for a
!     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

      kao(:, 1, 1, 1) = (/ &
     &6.4065e-07_r8,1.0419e-05_r8,1.7041e-05_r8,2.3341e-05_r8,2.9288e-05_r8,3.6860e-05_r8, &
     &5.2289e-05_r8,7.6369e-05_r8,2.2034e-05_r8/)
      kao(:, 2, 1, 1) = (/ &
     &7.4425e-07_r8,1.2994e-05_r8,2.1634e-05_r8,2.9437e-05_r8,3.6128e-05_r8,4.4577e-05_r8, &
     &5.5507e-05_r8,7.3010e-05_r8,3.0368e-05_r8/)
      kao(:, 3, 1, 1) = (/ &
     &9.1477e-07_r8,1.6195e-05_r8,2.7037e-05_r8,3.6851e-05_r8,4.4956e-05_r8,5.3696e-05_r8, &
     &6.5423e-05_r8,7.7959e-05_r8,3.9940e-05_r8/)
      kao(:, 4, 1, 1) = (/ &
     &1.0920e-06_r8,2.0021e-05_r8,3.3475e-05_r8,4.5528e-05_r8,5.5351e-05_r8,6.4790e-05_r8, &
     &7.8460e-05_r8,9.0393e-05_r8,5.1295e-05_r8/)
      kao(:, 5, 1, 1) = (/ &
     &1.3489e-06_r8,2.4363e-05_r8,4.1025e-05_r8,5.5638e-05_r8,6.7646e-05_r8,7.8828e-05_r8, &
     &9.2175e-05_r8,1.0262e-04_r8,6.4740e-05_r8/)
      kao(:, 1, 2, 1) = (/ &
     &9.4474e-07_r8,9.5739e-06_r8,1.4537e-05_r8,1.9319e-05_r8,2.3955e-05_r8,2.8125e-05_r8, &
     &3.4867e-05_r8,5.4010e-05_r8,1.9403e-05_r8/)
      kao(:, 2, 2, 1) = (/ &
     &1.1323e-06_r8,1.1739e-05_r8,1.8325e-05_r8,2.4542e-05_r8,3.0201e-05_r8,3.5031e-05_r8, &
     &4.2528e-05_r8,5.9167e-05_r8,2.5395e-05_r8/)
      kao(:, 3, 2, 1) = (/ &
     &1.3451e-06_r8,1.4450e-05_r8,2.3075e-05_r8,3.0847e-05_r8,3.7507e-05_r8,4.3224e-05_r8, &
     &5.0526e-05_r8,6.6079e-05_r8,3.2769e-05_r8/)
      kao(:, 4, 2, 1) = (/ &
     &1.6171e-06_r8,1.7819e-05_r8,2.8678e-05_r8,3.8333e-05_r8,4.6715e-05_r8,5.3613e-05_r8, &
     &6.0668e-05_r8,7.1518e-05_r8,4.1642e-05_r8/)
      kao(:, 5, 2, 1) = (/ &
     &1.9441e-06_r8,2.1692e-05_r8,3.5243e-05_r8,4.7173e-05_r8,5.7398e-05_r8,6.5939e-05_r8, &
     &7.3567e-05_r8,8.2891e-05_r8,5.2140e-05_r8/)
      kao(:, 1, 3, 1) = (/ &
     &1.9997e-06_r8,1.0333e-05_r8,1.4351e-05_r8,1.7071e-05_r8,1.9818e-05_r8,2.2671e-05_r8, &
     &2.5587e-05_r8,3.3080e-05_r8,2.1440e-05_r8/)
      kao(:, 2, 3, 1) = (/ &
     &2.2813e-06_r8,1.2534e-05_r8,1.7541e-05_r8,2.1448e-05_r8,2.5145e-05_r8,2.8879e-05_r8, &
     &3.1889e-05_r8,3.7831e-05_r8,2.6738e-05_r8/)
      kao(:, 3, 3, 1) = (/ &
     &2.7401e-06_r8,1.5206e-05_r8,2.1444e-05_r8,2.7039e-05_r8,3.1929e-05_r8,3.6455e-05_r8, &
     &3.9620e-05_r8,4.6057e-05_r8,3.1366e-05_r8/)
      kao(:, 4, 3, 1) = (/ &
     &3.2871e-06_r8,1.8031e-05_r8,2.6416e-05_r8,3.3815e-05_r8,3.9999e-05_r8,4.5410e-05_r8, &
     &4.9342e-05_r8,5.4203e-05_r8,3.7064e-05_r8/)
      kao(:, 5, 3, 1) = (/ &
     &3.8869e-06_r8,2.1455e-05_r8,3.2368e-05_r8,4.1756e-05_r8,4.9581e-05_r8,5.6093e-05_r8, &
     &6.1027e-05_r8,6.5117e-05_r8,4.4920e-05_r8/)
      kao(:, 1, 4, 1) = (/ &
     &4.3610e-06_r8,1.3316e-05_r8,1.6242e-05_r8,1.8257e-05_r8,1.9350e-05_r8,2.0037e-05_r8, &
     &2.0833e-05_r8,2.3040e-05_r8,2.2366e-05_r8/)
      kao(:, 2, 4, 1) = (/ &
     &5.0348e-06_r8,1.5693e-05_r8,1.9649e-05_r8,2.2560e-05_r8,2.3970e-05_r8,2.5222e-05_r8, &
     &2.6081e-05_r8,2.7399e-05_r8,2.7623e-05_r8/)
      kao(:, 3, 4, 1) = (/ &
     &5.7893e-06_r8,1.8717e-05_r8,2.3542e-05_r8,2.7248e-05_r8,2.9677e-05_r8,3.1779e-05_r8, &
     &3.2973e-05_r8,3.3876e-05_r8,3.4347e-05_r8/)
      kao(:, 4, 4, 1) = (/ &
     &6.7700e-06_r8,2.2355e-05_r8,2.8015e-05_r8,3.2751e-05_r8,3.6706e-05_r8,3.9566e-05_r8, &
     &4.1488e-05_r8,4.1986e-05_r8,4.0984e-05_r8/)
      kao(:, 5, 4, 1) = (/ &
     &8.0207e-06_r8,2.6505e-05_r8,3.3421e-05_r8,3.9357e-05_r8,4.5121e-05_r8,4.9003e-05_r8, &
     &5.1776e-05_r8,5.2148e-05_r8,4.7085e-05_r8/)
      kao(:, 1, 5, 1) = (/ &
     &8.6602e-06_r8,1.8553e-05_r8,2.0839e-05_r8,2.1788e-05_r8,2.1544e-05_r8,2.1077e-05_r8, &
     &1.9473e-05_r8,1.8495e-05_r8,2.3671e-05_r8/)
      kao(:, 2, 5, 1) = (/ &
     &9.9810e-06_r8,2.2031e-05_r8,2.4930e-05_r8,2.6247e-05_r8,2.6462e-05_r8,2.6137e-05_r8, &
     &2.4415e-05_r8,2.2553e-05_r8,2.8177e-05_r8/)
      kao(:, 3, 5, 1) = (/ &
     &1.1619e-05_r8,2.6356e-05_r8,2.9247e-05_r8,3.1562e-05_r8,3.1911e-05_r8,3.1801e-05_r8, &
     &3.0166e-05_r8,2.7978e-05_r8,3.2481e-05_r8/)
      kao(:, 4, 5, 1) = (/ &
     &1.3216e-05_r8,3.1104e-05_r8,3.4868e-05_r8,3.7332e-05_r8,3.8497e-05_r8,3.8279e-05_r8, &
     &3.7615e-05_r8,3.4834e-05_r8,3.8514e-05_r8/)
      kao(:, 5, 5, 1) = (/ &
     &1.5414e-05_r8,3.5706e-05_r8,4.1155e-05_r8,4.4051e-05_r8,4.6023e-05_r8,4.6762e-05_r8, &
     &4.6430e-05_r8,4.3490e-05_r8,4.6117e-05_r8/)
      kao(:, 1, 6, 1) = (/ &
     &1.6458e-05_r8,2.5684e-05_r8,2.8012e-05_r8,2.7844e-05_r8,2.6244e-05_r8,2.4237e-05_r8, &
     &2.0656e-05_r8,1.6798e-05_r8,2.3796e-05_r8/)
      kao(:, 2, 6, 1) = (/ &
     &1.8595e-05_r8,3.0385e-05_r8,3.3443e-05_r8,3.3768e-05_r8,3.2056e-05_r8,2.9483e-05_r8, &
     &2.5851e-05_r8,2.0866e-05_r8,2.8662e-05_r8/)
      kao(:, 3, 6, 1) = (/ &
     &2.1348e-05_r8,3.6540e-05_r8,3.9601e-05_r8,3.9640e-05_r8,3.8210e-05_r8,3.5898e-05_r8, &
     &3.1968e-05_r8,2.5765e-05_r8,3.3968e-05_r8/)
      kao(:, 4, 6, 1) = (/ &
     &2.4741e-05_r8,4.2510e-05_r8,4.6979e-05_r8,4.6425e-05_r8,4.6165e-05_r8,4.2824e-05_r8, &
     &3.8814e-05_r8,3.1863e-05_r8,3.8072e-05_r8/)
      kao(:, 5, 6, 1) = (/ &
     &2.8527e-05_r8,5.0183e-05_r8,5.5064e-05_r8,5.5234e-05_r8,5.4182e-05_r8,5.0966e-05_r8, &
     &4.6758e-05_r8,3.9447e-05_r8,4.4935e-05_r8/)
      kao(:, 1, 7, 1) = (/ &
     &3.2476e-05_r8,3.8679e-05_r8,3.9032e-05_r8,3.7741e-05_r8,3.4552e-05_r8,2.9807e-05_r8, &
     &2.4164e-05_r8,1.7294e-05_r8,2.4102e-05_r8/)
      kao(:, 2, 7, 1) = (/ &
     &3.6570e-05_r8,4.6320e-05_r8,4.7537e-05_r8,4.6067e-05_r8,4.2268e-05_r8,3.6503e-05_r8, &
     &3.0476e-05_r8,2.2134e-05_r8,2.9448e-05_r8/)
      kao(:, 3, 7, 1) = (/ &
     &4.1124e-05_r8,5.4270e-05_r8,5.7210e-05_r8,5.5312e-05_r8,5.2106e-05_r8,4.5231e-05_r8, &
     &3.7737e-05_r8,2.7811e-05_r8,3.4668e-05_r8/)
      kao(:, 4, 7, 1) = (/ &
     &4.8133e-05_r8,6.4794e-05_r8,6.7628e-05_r8,6.6254e-05_r8,6.2299e-05_r8,5.4379e-05_r8, &
     &4.5931e-05_r8,3.4327e-05_r8,4.1743e-05_r8/)
      kao(:, 5, 7, 1) = (/ &
     &5.5532e-05_r8,7.7694e-05_r8,8.0423e-05_r8,7.9418e-05_r8,7.2354e-05_r8,6.4221e-05_r8, &
     &5.4806e-05_r8,4.1684e-05_r8,4.8759e-05_r8/)
      kao(:, 1, 8, 1) = (/ &
     &7.4902e-05_r8,7.7106e-05_r8,7.0826e-05_r8,6.4010e-05_r8,5.5968e-05_r8,4.6986e-05_r8, &
     &3.6409e-05_r8,2.2524e-05_r8,2.8079e-05_r8/)
      kao(:, 2, 8, 1) = (/ &
     &8.5067e-05_r8,8.8842e-05_r8,8.3769e-05_r8,7.6787e-05_r8,6.8134e-05_r8,5.7821e-05_r8, &
     &4.4557e-05_r8,2.8824e-05_r8,3.6133e-05_r8/)
      kao(:, 3, 8, 1) = (/ &
     &9.7879e-05_r8,1.0460e-04_r8,9.9884e-05_r8,9.2458e-05_r8,8.3229e-05_r8,7.0097e-05_r8, &
     &5.5355e-05_r8,3.6496e-05_r8,4.1979e-05_r8/)
      kao(:, 4, 8, 1) = (/ &
     &1.1321e-04_r8,1.2375e-04_r8,1.2003e-04_r8,1.1241e-04_r8,1.0088e-04_r8,8.6080e-05_r8, &
     &6.8531e-05_r8,4.5034e-05_r8,5.0526e-05_r8/)
      kao(:, 5, 8, 1) = (/ &
     &1.3142e-04_r8,1.5020e-04_r8,1.4626e-04_r8,1.3653e-04_r8,1.2235e-04_r8,1.0518e-04_r8, &
     &8.2469e-05_r8,5.5412e-05_r8,6.0484e-05_r8/)
      kao(:, 1, 9, 1) = (/ &
     &3.0190e-04_r8,2.8195e-04_r8,2.5208e-04_r8,2.1662e-04_r8,1.7929e-04_r8,1.4025e-04_r8, &
     &1.0049e-04_r8,5.8291e-05_r8,3.9381e-05_r8/)
      kao(:, 2, 9, 1) = (/ &
     &3.5007e-04_r8,3.2966e-04_r8,2.9418e-04_r8,2.5482e-04_r8,2.1206e-04_r8,1.6775e-04_r8, &
     &1.2208e-04_r8,7.2618e-05_r8,5.1006e-05_r8/)
      kao(:, 3, 9, 1) = (/ &
     &4.1355e-04_r8,3.9069e-04_r8,3.5043e-04_r8,3.0530e-04_r8,2.5611e-04_r8,2.0488e-04_r8, &
     &1.4964e-04_r8,8.8870e-05_r8,6.5960e-05_r8/)
      kao(:, 4, 9, 1) = (/ &
     &4.9093e-04_r8,4.6398e-04_r8,4.1726e-04_r8,3.6373e-04_r8,3.0710e-04_r8,2.4775e-04_r8, &
     &1.8258e-04_r8,1.0881e-04_r8,8.2307e-05_r8/)
      kao(:, 5, 9, 1) = (/ &
     &5.8022e-04_r8,5.5027e-04_r8,5.0137e-04_r8,4.3986e-04_r8,3.7225e-04_r8,2.9865e-04_r8, &
     &2.2079e-04_r8,1.3406e-04_r8,9.5285e-05_r8/)
      kao(:, 1,10, 1) = (/ &
     &1.2883e-03_r8,1.1451e-03_r8,9.9720e-04_r8,8.4603e-04_r8,6.8855e-04_r8,5.2856e-04_r8, &
     &3.6226e-04_r8,1.9198e-04_r8,7.4637e-05_r8/)
      kao(:, 2,10, 1) = (/ &
     &1.5104e-03_r8,1.3471e-03_r8,1.1771e-03_r8,9.9916e-04_r8,8.1528e-04_r8,6.2425e-04_r8, &
     &4.3021e-04_r8,2.3018e-04_r8,8.8724e-05_r8/)
      kao(:, 3,10, 1) = (/ &
     &1.8167e-03_r8,1.6260e-03_r8,1.4233e-03_r8,1.2086e-03_r8,9.8644e-04_r8,7.6173e-04_r8, &
     &5.2737e-04_r8,2.8610e-04_r8,1.0717e-04_r8/)
      kao(:, 4,10, 1) = (/ &
     &2.2177e-03_r8,1.9922e-03_r8,1.7424e-03_r8,1.4817e-03_r8,1.2127e-03_r8,9.3691e-04_r8, &
     &6.5292e-04_r8,3.5708e-04_r8,1.2411e-04_r8/)
      kao(:, 5,10, 1) = (/ &
     &2.7210e-03_r8,2.4399e-03_r8,2.1395e-03_r8,1.8137e-03_r8,1.4859e-03_r8,1.1551e-03_r8, &
     &8.0975e-04_r8,4.4504e-04_r8,1.4851e-04_r8/)
      kao(:, 1,11, 1) = (/ &
     &1.9516e-03_r8,1.7255e-03_r8,1.4956e-03_r8,1.2644e-03_r8,1.0251e-03_r8,7.8257e-04_r8, &
     &5.3359e-04_r8,2.7877e-04_r8,7.8095e-05_r8/)
      kao(:, 2,11, 1) = (/ &
     &2.3604e-03_r8,2.0924e-03_r8,1.8171e-03_r8,1.5363e-03_r8,1.2459e-03_r8,9.5100e-04_r8, &
     &6.5089e-04_r8,3.4345e-04_r8,9.5842e-05_r8/)
      kao(:, 3,11, 1) = (/ &
     &2.8804e-03_r8,2.5577e-03_r8,2.2239e-03_r8,1.8797e-03_r8,1.5233e-03_r8,1.1642e-03_r8, &
     &8.0020e-04_r8,4.2543e-04_r8,1.1860e-04_r8/)
      kao(:, 4,11, 1) = (/ &
     &3.5705e-03_r8,3.1731e-03_r8,2.7557e-03_r8,2.3268e-03_r8,1.8893e-03_r8,1.4468e-03_r8, &
     &9.9612e-04_r8,5.3416e-04_r8,1.4487e-04_r8/)
      kao(:, 5,11, 1) = (/ &
     &4.4488e-03_r8,3.9532e-03_r8,3.4428e-03_r8,2.9093e-03_r8,2.3658e-03_r8,1.8156e-03_r8, &
     &1.2567e-03_r8,6.7979e-04_r8,1.7247e-04_r8/)
      kao(:, 1,12, 1) = (/ &
     &2.1650e-03_r8,1.9116e-03_r8,1.6550e-03_r8,1.3963e-03_r8,1.1297e-03_r8,8.5899e-04_r8, &
     &5.8509e-04_r8,3.0490e-04_r8,7.1706e-05_r8/)
      kao(:, 2,12, 1) = (/ &
     &2.6267e-03_r8,2.3248e-03_r8,2.0167e-03_r8,1.7021e-03_r8,1.3758e-03_r8,1.0485e-03_r8, &
     &7.1504e-04_r8,3.7456e-04_r8,8.9235e-05_r8/)
      kao(:, 3,12, 1) = (/ &
     &3.2534e-03_r8,2.8836e-03_r8,2.5027e-03_r8,2.1051e-03_r8,1.7048e-03_r8,1.2988e-03_r8, &
     &8.8817e-04_r8,4.6846e-04_r8,1.1111e-04_r8/)
      kao(:, 4,12, 1) = (/ &
     &4.0663e-03_r8,3.6075e-03_r8,3.1250e-03_r8,2.6309e-03_r8,2.1307e-03_r8,1.6269e-03_r8, &
     &1.1159e-03_r8,5.9423e-04_r8,1.3807e-04_r8/)
      kao(:, 5,12, 1) = (/ &
     &5.1489e-03_r8,4.5663e-03_r8,3.9639e-03_r8,3.3363e-03_r8,2.7011e-03_r8,2.0639e-03_r8, &
     &1.4193e-03_r8,7.5878e-04_r8,1.6511e-04_r8/)
      kao(:, 1,13, 1) = (/ &
     &1.8892e-03_r8,1.6706e-03_r8,1.4468e-03_r8,1.2178e-03_r8,9.8369e-04_r8,7.4837e-04_r8, &
     &5.0829e-04_r8,2.6445e-04_r8,6.0347e-05_r8/)
      kao(:, 2,13, 1) = (/ &
     &2.3493e-03_r8,2.0800e-03_r8,1.8039e-03_r8,1.5176e-03_r8,1.2269e-03_r8,9.3478e-04_r8, &
     &6.3614e-04_r8,3.3311e-04_r8,7.4952e-05_r8/)
      kao(:, 3,13, 1) = (/ &
     &2.9367e-03_r8,2.6050e-03_r8,2.2571e-03_r8,1.8958e-03_r8,1.5337e-03_r8,1.1694e-03_r8, &
     &7.9916e-04_r8,4.2184e-04_r8,9.2442e-05_r8/)
      kao(:, 4,13, 1) = (/ &
     &3.6657e-03_r8,3.2513e-03_r8,2.8158e-03_r8,2.3704e-03_r8,1.9186e-03_r8,1.4653e-03_r8, &
     &1.0024e-03_r8,5.3341e-04_r8,1.1484e-04_r8/)
      kao(:, 5,13, 1) = (/ &
     &4.6760e-03_r8,4.1516e-03_r8,3.5983e-03_r8,3.0289e-03_r8,2.4503e-03_r8,1.8734e-03_r8, &
     &1.2888e-03_r8,6.8680e-04_r8,1.3777e-04_r8/)
      kao(:, 1, 1, 2) = (/ &
     &1.8748e-06_r8,2.5986e-05_r8,3.9140e-05_r8,5.0515e-05_r8,6.0453e-05_r8,7.0222e-05_r8, &
     &9.2153e-05_r8,1.1527e-04_r8,4.9863e-05_r8/)
      kao(:, 2, 1, 2) = (/ &
     &2.2195e-06_r8,3.2877e-05_r8,5.0201e-05_r8,6.4757e-05_r8,7.7459e-05_r8,8.9731e-05_r8, &
     &1.0523e-04_r8,1.3275e-04_r8,6.4946e-05_r8/)
      kao(:, 3, 1, 2) = (/ &
     &2.6699e-06_r8,4.0948e-05_r8,6.3539e-05_r8,8.1241e-05_r8,9.7151e-05_r8,1.1092e-04_r8, &
     &1.1761e-04_r8,1.3825e-04_r8,8.4658e-05_r8/)
      kao(:, 4, 1, 2) = (/ &
     &3.1333e-06_r8,5.0568e-05_r8,7.8106e-05_r8,9.9691e-05_r8,1.1981e-04_r8,1.3549e-04_r8, &
     &1.3924e-04_r8,1.5344e-04_r8,1.0884e-04_r8/)
      kao(:, 5, 1, 2) = (/ &
     &3.7302e-06_r8,6.1696e-05_r8,9.4521e-05_r8,1.2091e-04_r8,1.4534e-04_r8,1.6166e-04_r8, &
     &1.6745e-04_r8,1.7689e-04_r8,1.3808e-04_r8/)
      kao(:, 1, 2, 2) = (/ &
     &2.7303e-06_r8,2.4541e-05_r8,3.5763e-05_r8,4.4104e-05_r8,5.1595e-05_r8,5.8966e-05_r8, &
     &6.8130e-05_r8,1.0200e-04_r8,3.9223e-05_r8/)
      kao(:, 2, 2, 2) = (/ &
     &3.2091e-06_r8,3.1379e-05_r8,4.5745e-05_r8,5.7229e-05_r8,6.6576e-05_r8,7.4659e-05_r8, &
     &8.1615e-05_r8,9.9977e-05_r8,5.3367e-05_r8/)
      kao(:, 3, 2, 2) = (/ &
     &3.8233e-06_r8,3.9294e-05_r8,5.7741e-05_r8,7.2569e-05_r8,8.4616e-05_r8,9.4873e-05_r8, &
     &1.0240e-04_r8,1.1173e-04_r8,6.9904e-05_r8/)
      kao(:, 4, 2, 2) = (/ &
     &4.4247e-06_r8,4.8330e-05_r8,7.1550e-05_r8,9.0142e-05_r8,1.0471e-04_r8,1.1736e-04_r8, &
     &1.2542e-04_r8,1.2602e-04_r8,8.9761e-05_r8/)
      kao(:, 5, 2, 2) = (/ &
     &5.2245e-06_r8,5.9597e-05_r8,8.7482e-05_r8,1.0983e-04_r8,1.2772e-04_r8,1.4263e-04_r8, &
     &1.4957e-04_r8,1.4619e-04_r8,1.1276e-04_r8/)
      kao(:, 1, 3, 2) = (/ &
     &5.2515e-06_r8,2.5764e-05_r8,3.5421e-05_r8,4.2053e-05_r8,4.7449e-05_r8,5.0608e-05_r8, &
     &5.3790e-05_r8,6.3623e-05_r8,3.2707e-05_r8/)
      kao(:, 2, 3, 2) = (/ &
     &6.1812e-06_r8,3.3267e-05_r8,4.5617e-05_r8,5.4363e-05_r8,6.1462e-05_r8,6.5644e-05_r8, &
     &6.8603e-05_r8,7.2538e-05_r8,4.2974e-05_r8/)
      kao(:, 3, 3, 2) = (/ &
     &7.0789e-06_r8,4.1750e-05_r8,5.7967e-05_r8,6.9149e-05_r8,7.8026e-05_r8,8.4324e-05_r8, &
     &8.7723e-05_r8,8.7036e-05_r8,5.7402e-05_r8/)
      kao(:, 4, 3, 2) = (/ &
     &8.1019e-06_r8,5.2243e-05_r8,7.2254e-05_r8,8.6560e-05_r8,9.8380e-05_r8,1.0586e-04_r8, &
     &1.1006e-04_r8,1.0834e-04_r8,7.4594e-05_r8/)
      kao(:, 5, 3, 2) = (/ &
     &9.5928e-06_r8,6.4752e-05_r8,8.9095e-05_r8,1.0726e-04_r8,1.2114e-04_r8,1.3016e-04_r8, &
     &1.3551e-04_r8,1.3048e-04_r8,9.3901e-05_r8/)
      kao(:, 1, 4, 2) = (/ &
     &1.1020e-05_r8,2.8494e-05_r8,3.6932e-05_r8,4.2975e-05_r8,4.6074e-05_r8,4.6953e-05_r8, &
     &4.6313e-05_r8,4.4542e-05_r8,3.2970e-05_r8/)
      kao(:, 2, 4, 2) = (/ &
     &1.2562e-05_r8,3.7065e-05_r8,4.7812e-05_r8,5.4915e-05_r8,5.9599e-05_r8,6.1605e-05_r8, &
     &6.1355e-05_r8,5.8223e-05_r8,3.9379e-05_r8/)
      kao(:, 3, 4, 2) = (/ &
     &1.4576e-05_r8,4.7351e-05_r8,6.1614e-05_r8,7.0211e-05_r8,7.6184e-05_r8,7.9246e-05_r8, &
     &7.8840e-05_r8,7.4646e-05_r8,4.5622e-05_r8/)
      kao(:, 4, 4, 2) = (/ &
     &1.6280e-05_r8,5.8550e-05_r8,7.7244e-05_r8,8.9750e-05_r8,9.5812e-05_r8,1.0028e-04_r8, &
     &1.0042e-04_r8,9.4563e-05_r8,5.6157e-05_r8/)
      kao(:, 5, 4, 2) = (/ &
     &1.8452e-05_r8,7.1720e-05_r8,9.6110e-05_r8,1.1183e-04_r8,1.1944e-04_r8,1.2546e-04_r8, &
     &1.2521e-04_r8,1.1758e-04_r8,7.2313e-05_r8/)
      kao(:, 1, 5, 2) = (/ &
     &2.1312e-05_r8,3.6806e-05_r8,4.2862e-05_r8,4.6599e-05_r8,4.7270e-05_r8,4.6274e-05_r8, &
     &4.2916e-05_r8,3.6817e-05_r8,3.2593e-05_r8/)
      kao(:, 2, 5, 2) = (/ &
     &2.5202e-05_r8,4.5358e-05_r8,5.3413e-05_r8,5.8866e-05_r8,6.0628e-05_r8,5.9617e-05_r8, &
     &5.6530e-05_r8,4.9579e-05_r8,3.9610e-05_r8/)
      kao(:, 3, 5, 2) = (/ &
     &2.8699e-05_r8,5.5778e-05_r8,6.8120e-05_r8,7.4417e-05_r8,7.7573e-05_r8,7.6799e-05_r8, &
     &7.3323e-05_r8,6.4915e-05_r8,4.8072e-05_r8/)
      kao(:, 4, 5, 2) = (/ &
     &3.2753e-05_r8,6.7844e-05_r8,8.5625e-05_r8,9.3879e-05_r8,9.7934e-05_r8,9.8316e-05_r8, &
     &9.3375e-05_r8,8.3569e-05_r8,5.7445e-05_r8/)
      kao(:, 5, 5, 2) = (/ &
     &3.6908e-05_r8,8.3612e-05_r8,1.0490e-04_r8,1.1632e-04_r8,1.2275e-04_r8,1.2328e-04_r8, &
     &1.1667e-04_r8,1.0539e-04_r8,6.6570e-05_r8/)
      kao(:, 1, 6, 2) = (/ &
     &4.3241e-05_r8,5.7363e-05_r8,5.9383e-05_r8,5.9083e-05_r8,5.6687e-05_r8,5.1929e-05_r8, &
     &4.4854e-05_r8,3.4134e-05_r8,3.3554e-05_r8/)
      kao(:, 2, 6, 2) = (/ &
     &4.8160e-05_r8,6.6362e-05_r8,7.1460e-05_r8,7.1908e-05_r8,6.9540e-05_r8,6.3380e-05_r8, &
     &5.6957e-05_r8,4.4490e-05_r8,3.9435e-05_r8/)
      kao(:, 3, 6, 2) = (/ &
     &5.5150e-05_r8,7.8279e-05_r8,8.5897e-05_r8,8.6929e-05_r8,8.6216e-05_r8,7.9912e-05_r8, &
     &7.1634e-05_r8,5.7727e-05_r8,4.6871e-05_r8/)
      kao(:, 4, 6, 2) = (/ &
     &6.2702e-05_r8,9.3878e-05_r8,1.0189e-04_r8,1.0755e-04_r8,1.0575e-04_r8,1.0053e-04_r8, &
     &8.9365e-05_r8,7.5152e-05_r8,5.7874e-05_r8/)
      kao(:, 5, 6, 2) = (/ &
     &7.1646e-05_r8,1.0994e-04_r8,1.2283e-04_r8,1.3142e-04_r8,1.3048e-04_r8,1.2339e-04_r8, &
     &1.1339e-04_r8,9.4667e-05_r8,6.9560e-05_r8/)
      kao(:, 1, 7, 2) = (/ &
     &9.4217e-05_r8,1.0625e-04_r8,1.0297e-04_r8,9.4341e-05_r8,8.4820e-05_r8,7.4540e-05_r8, &
     &5.9573e-05_r8,4.0162e-05_r8,3.4032e-05_r8/)
      kao(:, 2, 7, 2) = (/ &
     &1.0328e-04_r8,1.1698e-04_r8,1.1273e-04_r8,1.0730e-04_r8,9.8854e-05_r8,8.8068e-05_r8, &
     &7.1680e-05_r8,5.0363e-05_r8,4.1780e-05_r8/)
      kao(:, 3, 7, 2) = (/ &
     &1.1436e-04_r8,1.3466e-04_r8,1.3293e-04_r8,1.2807e-04_r8,1.1742e-04_r8,1.0440e-04_r8, &
     &8.7142e-05_r8,6.2911e-05_r8,5.1346e-05_r8/)
      kao(:, 4, 7, 2) = (/ &
     &1.2805e-04_r8,1.5498e-04_r8,1.5579e-04_r8,1.5032e-04_r8,1.3953e-04_r8,1.2638e-04_r8, &
     &1.0638e-04_r8,7.6925e-05_r8,6.1784e-05_r8/)
      kao(:, 5, 7, 2) = (/ &
     &1.4510e-04_r8,1.7937e-04_r8,1.8186e-04_r8,1.7514e-04_r8,1.6579e-04_r8,1.5232e-04_r8, &
     &1.2822e-04_r8,9.5671e-05_r8,7.0048e-05_r8/)
      kao(:, 1, 8, 2) = (/ &
     &2.4926e-04_r8,2.4392e-04_r8,2.2297e-04_r8,1.9521e-04_r8,1.6651e-04_r8,1.3349e-04_r8, &
     &9.8669e-05_r8,6.3201e-05_r8,3.1807e-05_r8/)
      kao(:, 2, 8, 2) = (/ &
     &2.7454e-04_r8,2.7755e-04_r8,2.5558e-04_r8,2.2780e-04_r8,1.9618e-04_r8,1.5908e-04_r8, &
     &1.2121e-04_r8,7.6667e-05_r8,4.0012e-05_r8/)
      kao(:, 3, 8, 2) = (/ &
     &2.9508e-04_r8,3.0091e-04_r8,2.7929e-04_r8,2.5223e-04_r8,2.1930e-04_r8,1.8562e-04_r8, &
     &1.4312e-04_r8,9.2529e-05_r8,5.6355e-05_r8/)
      kao(:, 4, 8, 2) = (/ &
     &3.2350e-04_r8,3.3697e-04_r8,3.1656e-04_r8,2.8676e-04_r8,2.5417e-04_r8,2.1233e-04_r8, &
     &1.6702e-04_r8,1.1113e-04_r8,6.5692e-05_r8/)
      kao(:, 5, 8, 2) = (/ &
     &3.5413e-04_r8,3.7149e-04_r8,3.5724e-04_r8,3.2794e-04_r8,2.8883e-04_r8,2.4521e-04_r8, &
     &1.9502e-04_r8,1.3265e-04_r8,7.4636e-05_r8/)
      kao(:, 1, 9, 2) = (/ &
     &1.1370e-03_r8,1.0245e-03_r8,9.0233e-04_r8,7.7373e-04_r8,6.3596e-04_r8,4.9782e-04_r8, &
     &3.4706e-04_r8,1.8813e-04_r8,5.4967e-05_r8/)
      kao(:, 2, 9, 2) = (/ &
     &1.2549e-03_r8,1.1327e-03_r8,1.0081e-03_r8,8.6174e-04_r8,7.1233e-04_r8,5.5663e-04_r8, &
     &3.9054e-04_r8,2.1740e-04_r8,6.5863e-05_r8/)
      kao(:, 3, 9, 2) = (/ &
     &1.4193e-03_r8,1.2929e-03_r8,1.1501e-03_r8,9.8954e-04_r8,8.1834e-04_r8,6.4034e-04_r8, &
     &4.5590e-04_r8,2.5841e-04_r8,7.6782e-05_r8/)
      kao(:, 4, 9, 2) = (/ &
     &1.5730e-03_r8,1.4525e-03_r8,1.2939e-03_r8,1.1191e-03_r8,9.2869e-04_r8,7.2912e-04_r8, &
     &5.2003e-04_r8,2.9928e-04_r8,9.3109e-05_r8/)
      kao(:, 5, 9, 2) = (/ &
     &1.7020e-03_r8,1.5888e-03_r8,1.4187e-03_r8,1.2315e-03_r8,1.0334e-03_r8,8.2293e-04_r8, &
     &5.9761e-04_r8,3.4411e-04_r8,1.1836e-04_r8/)
      kao(:, 1,10, 2) = (/ &
     &6.1528e-03_r8,5.4056e-03_r8,4.6635e-03_r8,3.9185e-03_r8,3.1663e-03_r8,2.4050e-03_r8, &
     &1.6372e-03_r8,8.5009e-04_r8,8.0054e-05_r8/)
      kao(:, 2,10, 2) = (/ &
     &6.8550e-03_r8,6.0391e-03_r8,5.2246e-03_r8,4.3821e-03_r8,3.5514e-03_r8,2.7172e-03_r8, &
     &1.8529e-03_r8,9.7224e-04_r8,1.0130e-04_r8/)
      kao(:, 3,10, 2) = (/ &
     &7.6163e-03_r8,6.7254e-03_r8,5.8028e-03_r8,4.8844e-03_r8,3.9710e-03_r8,3.0268e-03_r8, &
     &2.0640e-03_r8,1.0804e-03_r8,1.3327e-04_r8/)
      kao(:, 4,10, 2) = (/ &
     &8.4017e-03_r8,7.4385e-03_r8,6.4324e-03_r8,5.4278e-03_r8,4.4132e-03_r8,3.3677e-03_r8, &
     &2.3075e-03_r8,1.2226e-03_r8,1.6598e-04_r8/)
      kao(:, 5,10, 2) = (/ &
     &9.3911e-03_r8,8.3333e-03_r8,7.2272e-03_r8,6.1232e-03_r8,4.9837e-03_r8,3.8167e-03_r8, &
     &2.6213e-03_r8,1.4063e-03_r8,2.0638e-04_r8/)
      kao(:, 1,11, 2) = (/ &
     &1.1762e-02_r8,1.0306e-02_r8,8.8593e-03_r8,7.4127e-03_r8,5.9627e-03_r8,4.5045e-03_r8, &
     &3.0511e-03_r8,1.5666e-03_r8,8.2025e-05_r8/)
      kao(:, 2,11, 2) = (/ &
     &1.3012e-02_r8,1.1426e-02_r8,9.8347e-03_r8,8.2336e-03_r8,6.6323e-03_r8,5.0275e-03_r8, &
     &3.4043e-03_r8,1.7550e-03_r8,1.0611e-04_r8/)
      kao(:, 3,11, 2) = (/ &
     &1.4612e-02_r8,1.2845e-02_r8,1.1070e-02_r8,9.2725e-03_r8,7.4822e-03_r8,5.6847e-03_r8, &
     &3.8534e-03_r8,1.9989e-03_r8,1.3346e-04_r8/)
      kao(:, 4,11, 2) = (/ &
     &1.6251e-02_r8,1.4313e-02_r8,1.2347e-02_r8,1.0360e-02_r8,8.3777e-03_r8,6.3716e-03_r8, &
     &4.3250e-03_r8,2.2445e-03_r8,1.6083e-04_r8/)
      kao(:, 5,11, 2) = (/ &
     &1.8150e-02_r8,1.6016e-02_r8,1.3813e-02_r8,1.1608e-02_r8,9.3833e-03_r8,7.1360e-03_r8, &
     &4.8421e-03_r8,2.5233e-03_r8,2.0030e-04_r8/)
      kao(:, 1,12, 2) = (/ &
     &1.5059e-02_r8,1.3197e-02_r8,1.1332e-02_r8,9.4687e-03_r8,7.6107e-03_r8,5.7434e-03_r8, &
     &3.8799e-03_r8,1.9799e-03_r8,8.0330e-05_r8/)
      kao(:, 2,12, 2) = (/ &
     &1.6512e-02_r8,1.4476e-02_r8,1.2442e-02_r8,1.0410e-02_r8,8.3743e-03_r8,6.3355e-03_r8, &
     &4.2771e-03_r8,2.1952e-03_r8,9.9323e-05_r8/)
      kao(:, 3,12, 2) = (/ &
     &1.8685e-02_r8,1.6400e-02_r8,1.4116e-02_r8,1.1818e-02_r8,9.5219e-03_r8,7.2188e-03_r8, &
     &4.8730e-03_r8,2.5083e-03_r8,1.2343e-04_r8/)
      kao(:, 4,12, 2) = (/ &
     &2.1153e-02_r8,1.8588e-02_r8,1.6002e-02_r8,1.3413e-02_r8,1.0821e-02_r8,8.2029e-03_r8, &
     &5.5391e-03_r8,2.8500e-03_r8,1.4931e-04_r8/)
      kao(:, 5,12, 2) = (/ &
     &2.3737e-02_r8,2.0901e-02_r8,1.7991e-02_r8,1.5090e-02_r8,1.2172e-02_r8,9.2290e-03_r8, &
     &6.2485e-03_r8,3.2234e-03_r8,1.9022e-04_r8/)
      kao(:, 1,13, 2) = (/ &
     &1.4847e-02_r8,1.3010e-02_r8,1.1175e-02_r8,9.3417e-03_r8,7.5039e-03_r8,5.6608e-03_r8, &
     &3.8195e-03_r8,1.9483e-03_r8,7.0259e-05_r8/)
      kao(:, 2,13, 2) = (/ &
     &1.6739e-02_r8,1.4679e-02_r8,1.2619e-02_r8,1.0555e-02_r8,8.4903e-03_r8,6.4217e-03_r8, &
     &4.3269e-03_r8,2.2129e-03_r8,8.5490e-05_r8/)
      kao(:, 3,13, 2) = (/ &
     &1.8825e-02_r8,1.6518e-02_r8,1.4211e-02_r8,1.1898e-02_r8,9.5859e-03_r8,7.2507e-03_r8, &
     &4.8896e-03_r8,2.5047e-03_r8,1.1226e-04_r8/)
      kao(:, 4,13, 2) = (/ &
     &2.1292e-02_r8,1.8712e-02_r8,1.6107e-02_r8,1.3496e-02_r8,1.0877e-02_r8,8.2331e-03_r8, &
     &5.5639e-03_r8,2.8510e-03_r8,1.4031e-04_r8/)
      kao(:, 5,13, 2) = (/ &
     &2.4158e-02_r8,2.1241e-02_r8,1.8299e-02_r8,1.5344e-02_r8,1.2375e-02_r8,9.3646e-03_r8, &
     &6.3197e-03_r8,3.2533e-03_r8,1.7265e-04_r8/)
      kao(:, 1, 1, 3) = (/ &
     &1.0410e-05_r8,6.1962e-05_r8,8.9498e-05_r8,1.0661e-04_r8,1.2164e-04_r8,1.3377e-04_r8, &
     &1.2941e-04_r8,1.4521e-04_r8,8.1226e-05_r8/)
      kao(:, 2, 1, 3) = (/ &
     &1.1876e-05_r8,7.8368e-05_r8,1.1198e-04_r8,1.3409e-04_r8,1.5187e-04_r8,1.6090e-04_r8, &
     &1.6481e-04_r8,1.6441e-04_r8,1.1141e-04_r8/)
      kao(:, 3, 1, 3) = (/ &
     &1.3686e-05_r8,9.7536e-05_r8,1.3724e-04_r8,1.6641e-04_r8,1.8557e-04_r8,1.9386e-04_r8, &
     &1.9539e-04_r8,1.8991e-04_r8,1.4967e-04_r8/)
      kao(:, 4, 1, 3) = (/ &
     &1.5807e-05_r8,1.1754e-04_r8,1.6722e-04_r8,2.0238e-04_r8,2.2277e-04_r8,2.3084e-04_r8, &
     &2.3103e-04_r8,2.1679e-04_r8,1.9490e-04_r8/)
      kao(:, 5, 1, 3) = (/ &
     &1.8430e-05_r8,1.4041e-04_r8,2.0063e-04_r8,2.4077e-04_r8,2.6088e-04_r8,2.7081e-04_r8, &
     &2.7088e-04_r8,2.6451e-04_r8,2.4633e-04_r8/)
      kao(:, 1, 2, 3) = (/ &
     &1.4574e-05_r8,6.1181e-05_r8,8.5219e-05_r8,1.0233e-04_r8,1.1097e-04_r8,1.1864e-04_r8, &
     &1.2443e-04_r8,1.2339e-04_r8,6.7714e-05_r8/)
      kao(:, 2, 2, 3) = (/ &
     &1.6727e-05_r8,7.7358e-05_r8,1.0881e-04_r8,1.2844e-04_r8,1.4104e-04_r8,1.5016e-04_r8, &
     &1.5142e-04_r8,1.4164e-04_r8,9.0996e-05_r8/)
      kao(:, 3, 2, 3) = (/ &
     &1.9092e-05_r8,9.6319e-05_r8,1.3467e-04_r8,1.5937e-04_r8,1.7543e-04_r8,1.8362e-04_r8, &
     &1.8038e-04_r8,1.5924e-04_r8,1.2122e-04_r8/)
      kao(:, 4, 2, 3) = (/ &
     &2.2128e-05_r8,1.1862e-04_r8,1.6445e-04_r8,1.9397e-04_r8,2.1438e-04_r8,2.2054e-04_r8, &
     &2.1448e-04_r8,2.0102e-04_r8,1.5787e-04_r8/)
      kao(:, 5, 2, 3) = (/ &
     &2.5953e-05_r8,1.4141e-04_r8,1.9710e-04_r8,2.3342e-04_r8,2.5581e-04_r8,2.5978e-04_r8, &
     &2.5390e-04_r8,2.3627e-04_r8,2.0062e-04_r8/)
      kao(:, 1, 3, 3) = (/ &
     &2.6011e-05_r8,6.9300e-05_r8,8.8885e-05_r8,1.0316e-04_r8,1.1255e-04_r8,1.1444e-04_r8, &
     &1.1119e-04_r8,1.0838e-04_r8,5.7064e-05_r8/)
      kao(:, 2, 3, 3) = (/ &
     &2.9960e-05_r8,8.6707e-05_r8,1.1415e-04_r8,1.3351e-04_r8,1.4420e-04_r8,1.4685e-04_r8, &
     &1.4419e-04_r8,1.3258e-04_r8,7.5649e-05_r8/)
      kao(:, 3, 3, 3) = (/ &
     &3.4740e-05_r8,1.0851e-04_r8,1.4450e-04_r8,1.6834e-04_r8,1.8054e-04_r8,1.8416e-04_r8, &
     &1.8038e-04_r8,1.5855e-04_r8,9.9657e-05_r8/)
      kao(:, 4, 3, 3) = (/ &
     &4.0367e-05_r8,1.3338e-04_r8,1.7889e-04_r8,2.0752e-04_r8,2.2266e-04_r8,2.2792e-04_r8, &
     &2.1975e-04_r8,1.8879e-04_r8,1.2950e-04_r8/)
      kao(:, 5, 3, 3) = (/ &
     &4.7325e-05_r8,1.6087e-04_r8,2.1635e-04_r8,2.5031e-04_r8,2.7116e-04_r8,2.7639e-04_r8, &
     &2.6032e-04_r8,2.2480e-04_r8,1.6585e-04_r8/)
      kao(:, 1, 4, 3) = (/ &
     &4.6629e-05_r8,8.8856e-05_r8,1.0307e-04_r8,1.1034e-04_r8,1.1324e-04_r8,1.1518e-04_r8, &
     &1.0941e-04_r8,9.2447e-05_r8,4.9807e-05_r8/)
      kao(:, 2, 4, 3) = (/ &
     &5.3813e-05_r8,1.0914e-04_r8,1.2953e-04_r8,1.4280e-04_r8,1.4973e-04_r8,1.5074e-04_r8, &
     &1.4150e-04_r8,1.2111e-04_r8,6.6358e-05_r8/)
      kao(:, 3, 4, 3) = (/ &
     &6.3364e-05_r8,1.3307e-04_r8,1.6255e-04_r8,1.8292e-04_r8,1.9276e-04_r8,1.9285e-04_r8, &
     &1.8002e-04_r8,1.5407e-04_r8,8.8052e-05_r8/)
      kao(:, 4, 4, 3) = (/ &
     &7.4529e-05_r8,1.6123e-04_r8,2.0145e-04_r8,2.2832e-04_r8,2.4093e-04_r8,2.3982e-04_r8, &
     &2.2562e-04_r8,1.8990e-04_r8,1.1560e-04_r8/)
      kao(:, 5, 4, 3) = (/ &
     &8.8134e-05_r8,1.9717e-04_r8,2.4798e-04_r8,2.7909e-04_r8,2.9532e-04_r8,2.9441e-04_r8, &
     &2.7564e-04_r8,2.2733e-04_r8,1.4686e-04_r8/)
      kao(:, 1, 5, 3) = (/ &
     &7.7279e-05_r8,1.1122e-04_r8,1.2109e-04_r8,1.2443e-04_r8,1.2189e-04_r8,1.1617e-04_r8, &
     &1.0613e-04_r8,8.7521e-05_r8,4.7012e-05_r8/)
      kao(:, 2, 5, 3) = (/ &
     &8.9473e-05_r8,1.3546e-04_r8,1.5195e-04_r8,1.5794e-04_r8,1.5786e-04_r8,1.5329e-04_r8, &
     &1.4127e-04_r8,1.1487e-04_r8,6.0204e-05_r8/)
      kao(:, 3, 5, 3) = (/ &
     &1.0328e-04_r8,1.6610e-04_r8,1.8961e-04_r8,1.9990e-04_r8,2.0229e-04_r8,2.0006e-04_r8, &
     &1.8432e-04_r8,1.4896e-04_r8,7.6087e-05_r8/)
      kao(:, 4, 5, 3) = (/ &
     &1.2119e-04_r8,2.0367e-04_r8,2.3155e-04_r8,2.4851e-04_r8,2.5658e-04_r8,2.5211e-04_r8, &
     &2.3296e-04_r8,1.8864e-04_r8,9.8744e-05_r8/)
      kao(:, 5, 5, 3) = (/ &
     &1.4337e-04_r8,2.4554e-04_r8,2.8278e-04_r8,3.0781e-04_r8,3.1834e-04_r8,3.1139e-04_r8, &
     &2.8860e-04_r8,2.3262e-04_r8,1.2920e-04_r8/)
      kao(:, 1, 6, 3) = (/ &
     &1.1761e-04_r8,1.4538e-04_r8,1.4284e-04_r8,1.3740e-04_r8,1.2980e-04_r8,1.1847e-04_r8, &
     &1.0232e-04_r8,8.1254e-05_r8,4.1748e-05_r8/)
      kao(:, 2, 6, 3) = (/ &
     &1.3703e-04_r8,1.7162e-04_r8,1.7382e-04_r8,1.7289e-04_r8,1.6644e-04_r8,1.5514e-04_r8, &
     &1.3666e-04_r8,1.0938e-04_r8,5.6033e-05_r8/)
      kao(:, 3, 6, 3) = (/ &
     &1.5744e-04_r8,2.0479e-04_r8,2.1458e-04_r8,2.1922e-04_r8,2.1487e-04_r8,2.0072e-04_r8, &
     &1.7976e-04_r8,1.4480e-04_r8,7.3663e-05_r8/)
      kao(:, 4, 6, 3) = (/ &
     &1.7947e-04_r8,2.4802e-04_r8,2.6658e-04_r8,2.7311e-04_r8,2.6613e-04_r8,2.5639e-04_r8, &
     &2.3337e-04_r8,1.8491e-04_r8,9.1670e-05_r8/)
      kao(:, 5, 6, 3) = (/ &
     &2.1213e-04_r8,2.9698e-04_r8,3.2800e-04_r8,3.3255e-04_r8,3.3379e-04_r8,3.2227e-04_r8, &
     &2.9213e-04_r8,2.3295e-04_r8,1.1053e-04_r8/)
      kao(:, 1, 7, 3) = (/ &
     &2.1717e-04_r8,2.2955e-04_r8,2.1661e-04_r8,1.9608e-04_r8,1.6989e-04_r8,1.4299e-04_r8, &
     &1.1566e-04_r8,8.2895e-05_r8,3.7387e-05_r8/)
      kao(:, 2, 7, 3) = (/ &
     &2.4414e-04_r8,2.6643e-04_r8,2.5638e-04_r8,2.3114e-04_r8,2.0334e-04_r8,1.7738e-04_r8, &
     &1.4895e-04_r8,1.0764e-04_r8,5.2222e-05_r8/)
      kao(:, 3, 7, 3) = (/ &
     &2.7286e-04_r8,3.0487e-04_r8,2.9526e-04_r8,2.7261e-04_r8,2.5126e-04_r8,2.2507e-04_r8, &
     &1.8734e-04_r8,1.4022e-04_r8,6.8628e-05_r8/)
      kao(:, 4, 7, 3) = (/ &
     &3.1153e-04_r8,3.5338e-04_r8,3.4554e-04_r8,3.2591e-04_r8,3.0719e-04_r8,2.7679e-04_r8, &
     &2.3565e-04_r8,1.8522e-04_r8,8.6360e-05_r8/)
      kao(:, 5, 7, 3) = (/ &
     &3.5307e-04_r8,4.0595e-04_r8,4.0654e-04_r8,3.9853e-04_r8,3.7853e-04_r8,3.4348e-04_r8, &
     &3.0049e-04_r8,2.3594e-04_r8,1.1315e-04_r8/)
      kao(:, 1, 8, 3) = (/ &
     &5.5525e-04_r8,5.3290e-04_r8,4.9219e-04_r8,4.3834e-04_r8,3.7060e-04_r8,2.9620e-04_r8, &
     &2.1670e-04_r8,1.3044e-04_r8,4.3913e-05_r8/)
      kao(:, 2, 8, 3) = (/ &
     &6.1273e-04_r8,5.9169e-04_r8,5.4415e-04_r8,4.8432e-04_r8,4.1256e-04_r8,3.3431e-04_r8, &
     &2.4554e-04_r8,1.5735e-04_r8,5.6222e-05_r8/)
      kao(:, 3, 8, 3) = (/ &
     &6.6697e-04_r8,6.5930e-04_r8,6.1229e-04_r8,5.4542e-04_r8,4.6824e-04_r8,3.7897e-04_r8, &
     &2.8714e-04_r8,1.8945e-04_r8,7.2182e-05_r8/)
      kao(:, 4, 8, 3) = (/ &
     &7.3789e-04_r8,7.3274e-04_r8,6.8030e-04_r8,6.0993e-04_r8,5.2803e-04_r8,4.3826e-04_r8, &
     &3.4177e-04_r8,2.2879e-04_r8,9.7984e-05_r8/)
      kao(:, 5, 8, 3) = (/ &
     &8.2418e-04_r8,8.2930e-04_r8,7.7540e-04_r8,7.0471e-04_r8,6.2407e-04_r8,5.2518e-04_r8, &
     &4.1114e-04_r8,2.7739e-04_r8,1.2917e-04_r8/)
      kao(:, 1, 9, 3) = (/ &
     &2.9866e-03_r8,2.6446e-03_r8,2.3122e-03_r8,1.9743e-03_r8,1.6235e-03_r8,1.2497e-03_r8, &
     &8.7401e-04_r8,4.7254e-04_r8,6.5815e-05_r8/)
      kao(:, 2, 9, 3) = (/ &
     &3.1867e-03_r8,2.8548e-03_r8,2.5070e-03_r8,2.1512e-03_r8,1.7728e-03_r8,1.3804e-03_r8, &
     &9.6416e-04_r8,5.2342e-04_r8,8.4426e-05_r8/)
      kao(:, 3, 9, 3) = (/ &
     &3.3577e-03_r8,3.0331e-03_r8,2.6681e-03_r8,2.2844e-03_r8,1.8894e-03_r8,1.4824e-03_r8, &
     &1.0437e-03_r8,5.7926e-04_r8,1.1456e-04_r8/)
      kao(:, 4, 9, 3) = (/ &
     &3.5955e-03_r8,3.2669e-03_r8,2.8865e-03_r8,2.4786e-03_r8,2.0664e-03_r8,1.6261e-03_r8, &
     &1.1591e-03_r8,6.6253e-04_r8,1.4708e-04_r8/)
      kao(:, 5, 9, 3) = (/ &
     &3.9554e-03_r8,3.6156e-03_r8,3.2186e-03_r8,2.7765e-03_r8,2.3055e-03_r8,1.8177e-03_r8, &
     &1.3061e-03_r8,7.6692e-04_r8,1.9062e-04_r8/)
      kao(:, 1,10, 3) = (/ &
     &1.6695e-02_r8,1.4628e-02_r8,1.2561e-02_r8,1.0499e-02_r8,8.4474e-03_r8,6.4042e-03_r8, &
     &4.3459e-03_r8,2.2571e-03_r8,5.1038e-05_r8/)
      kao(:, 2,10, 3) = (/ &
     &1.8223e-02_r8,1.5977e-02_r8,1.3728e-02_r8,1.1517e-02_r8,9.2932e-03_r8,7.0542e-03_r8, &
     &4.8075e-03_r8,2.4890e-03_r8,1.1555e-04_r8/)
      kao(:, 3,10, 3) = (/ &
     &2.0043e-02_r8,1.7593e-02_r8,1.5175e-02_r8,1.2748e-02_r8,1.0288e-02_r8,7.8318e-03_r8, &
     &5.3279e-03_r8,2.7782e-03_r8,1.4398e-04_r8/)
      kao(:, 4,10, 3) = (/ &
     &2.1904e-02_r8,1.9249e-02_r8,1.6643e-02_r8,1.3989e-02_r8,1.1315e-02_r8,8.6138e-03_r8, &
     &5.8652e-03_r8,3.0632e-03_r8,1.9715e-04_r8/)
      kao(:, 5,10, 3) = (/ &
     &2.3159e-02_r8,2.0410e-02_r8,1.7664e-02_r8,1.4873e-02_r8,1.2019e-02_r8,9.1728e-03_r8, &
     &6.2874e-03_r8,3.3158e-03_r8,2.7195e-04_r8/)
      kao(:, 1,11, 3) = (/ &
     &3.2603e-02_r8,2.8559e-02_r8,2.4510e-02_r8,2.0449e-02_r8,1.6397e-02_r8,1.2361e-02_r8, &
     &8.3115e-03_r8,4.2614e-03_r8,4.3561e-05_r8/)
      kao(:, 2,11, 3) = (/ &
     &3.5490e-02_r8,3.1085e-02_r8,2.6692e-02_r8,2.2303e-02_r8,1.7919e-02_r8,1.3525e-02_r8, &
     &9.1241e-03_r8,4.6814e-03_r8,1.0680e-04_r8/)
      kao(:, 3,11, 3) = (/ &
     &3.8854e-02_r8,3.4035e-02_r8,2.9244e-02_r8,2.4483e-02_r8,1.9700e-02_r8,1.4916e-02_r8, &
     &1.0095e-02_r8,5.1808e-03_r8,1.8562e-04_r8/)
      kao(:, 4,11, 3) = (/ &
     &4.2305e-02_r8,3.7086e-02_r8,3.1904e-02_r8,2.6732e-02_r8,2.1504e-02_r8,1.6276e-02_r8, &
     &1.1000e-02_r8,5.6671e-03_r8,2.4195e-04_r8/)
      kao(:, 5,11, 3) = (/ &
     &4.6003e-02_r8,4.0358e-02_r8,3.4797e-02_r8,2.9165e-02_r8,2.3531e-02_r8,1.7850e-02_r8, &
     &1.2113e-02_r8,6.2729e-03_r8,3.2815e-04_r8/)
      kao(:, 1,12, 3) = (/ &
     &4.2717e-02_r8,3.7390e-02_r8,3.2076e-02_r8,2.6766e-02_r8,2.1453e-02_r8,1.6148e-02_r8, &
     &1.0833e-02_r8,5.5285e-03_r8,5.3162e-05_r8/)
      kao(:, 2,12, 3) = (/ &
     &4.7716e-02_r8,4.1793e-02_r8,3.5854e-02_r8,2.9930e-02_r8,2.4020e-02_r8,1.8099e-02_r8, &
     &1.2166e-02_r8,6.2010e-03_r8,1.2199e-04_r8/)
      kao(:, 3,12, 3) = (/ &
     &5.2485e-02_r8,4.5967e-02_r8,3.9456e-02_r8,3.2983e-02_r8,2.6496e-02_r8,1.9981e-02_r8, &
     &1.3462e-02_r8,6.8646e-03_r8,1.9551e-04_r8/)
      kao(:, 4,12, 3) = (/ &
     &5.6971e-02_r8,4.9905e-02_r8,4.2910e-02_r8,3.5876e-02_r8,2.8829e-02_r8,2.1772e-02_r8, &
     &1.4678e-02_r8,7.4885e-03_r8,2.4038e-04_r8/)
      kao(:, 5,12, 3) = (/ &
     &6.1845e-02_r8,5.4216e-02_r8,4.6694e-02_r8,3.9065e-02_r8,3.1428e-02_r8,2.3760e-02_r8, &
     &1.6034e-02_r8,8.2201e-03_r8,3.2330e-04_r8/)
      kao(:, 1,13, 3) = (/ &
     &4.4159e-02_r8,3.8661e-02_r8,3.3159e-02_r8,2.7655e-02_r8,2.2159e-02_r8,1.6679e-02_r8, &
     &1.1182e-02_r8,5.6866e-03_r8,7.0844e-05_r8/)
      kao(:, 2,13, 3) = (/ &
     &4.9543e-02_r8,4.3376e-02_r8,3.7217e-02_r8,3.1073e-02_r8,2.4939e-02_r8,1.8777e-02_r8, &
     &1.2622e-02_r8,6.4095e-03_r8,1.2350e-04_r8/)
      kao(:, 3,13, 3) = (/ &
     &5.4720e-02_r8,4.7942e-02_r8,4.1156e-02_r8,3.4403e-02_r8,2.7607e-02_r8,2.0806e-02_r8, &
     &1.3984e-02_r8,7.1021e-03_r8,1.5128e-04_r8/)
      kao(:, 4,13, 3) = (/ &
     &5.9716e-02_r8,5.2321e-02_r8,4.4977e-02_r8,3.7585e-02_r8,3.0190e-02_r8,2.2781e-02_r8, &
     &1.5325e-02_r8,7.8087e-03_r8,2.1269e-04_r8/)
      kao(:, 5,13, 3) = (/ &
     &6.4624e-02_r8,5.6664e-02_r8,4.8723e-02_r8,4.0765e-02_r8,3.2763e-02_r8,2.4744e-02_r8, &
     &1.6652e-02_r8,8.4913e-03_r8,3.0727e-04_r8/)
      kao(:, 1, 1, 4) = (/ &
     &5.7873e-05_r8,1.6488e-04_r8,2.0580e-04_r8,2.2960e-04_r8,2.3556e-04_r8,2.2261e-04_r8, &
     &2.0972e-04_r8,1.9322e-04_r8,1.3088e-04_r8/)
      kao(:, 2, 1, 4) = (/ &
     &6.6249e-05_r8,1.9462e-04_r8,2.4549e-04_r8,2.7463e-04_r8,2.7934e-04_r8,2.6538e-04_r8, &
     &2.3743e-04_r8,2.0925e-04_r8,1.7715e-04_r8/)
      kao(:, 3, 1, 4) = (/ &
     &7.5658e-05_r8,2.2561e-04_r8,2.8843e-04_r8,3.1940e-04_r8,3.2388e-04_r8,3.1216e-04_r8, &
     &2.9036e-04_r8,2.7653e-04_r8,2.3143e-04_r8/)
      kao(:, 4, 1, 4) = (/ &
     &8.5832e-05_r8,2.6205e-04_r8,3.3188e-04_r8,3.6495e-04_r8,3.7173e-04_r8,3.6401e-04_r8, &
     &3.4696e-04_r8,3.4171e-04_r8,2.9590e-04_r8/)
      kao(:, 5, 1, 4) = (/ &
     &9.6691e-05_r8,2.9985e-04_r8,3.7678e-04_r8,4.1538e-04_r8,4.2689e-04_r8,4.2505e-04_r8, &
     &4.1168e-04_r8,4.0784e-04_r8,3.7540e-04_r8/)
      kao(:, 1, 2, 4) = (/ &
     &8.0001e-05_r8,1.7863e-04_r8,2.1664e-04_r8,2.3517e-04_r8,2.4432e-04_r8,2.3529e-04_r8, &
     &2.0358e-04_r8,1.5402e-04_r8,1.1156e-04_r8/)
      kao(:, 2, 2, 4) = (/ &
     &9.2299e-05_r8,2.0953e-04_r8,2.5648e-04_r8,2.8347e-04_r8,2.9289e-04_r8,2.8063e-04_r8, &
     &2.4649e-04_r8,1.9992e-04_r8,1.5181e-04_r8/)
      kao(:, 3, 2, 4) = (/ &
     &1.0437e-04_r8,2.4399e-04_r8,3.0364e-04_r8,3.3466e-04_r8,3.4277e-04_r8,3.2781e-04_r8, &
     &2.9451e-04_r8,2.4303e-04_r8,2.0131e-04_r8/)
      kao(:, 4, 2, 4) = (/ &
     &1.1814e-04_r8,2.8134e-04_r8,3.5342e-04_r8,3.8732e-04_r8,3.9443e-04_r8,3.8031e-04_r8, &
     &3.4829e-04_r8,2.8801e-04_r8,2.6066e-04_r8/)
      kao(:, 5, 2, 4) = (/ &
     &1.3198e-04_r8,3.2404e-04_r8,4.0415e-04_r8,4.4181e-04_r8,4.5121e-04_r8,4.4037e-04_r8, &
     &4.0877e-04_r8,3.5353e-04_r8,3.3227e-04_r8/)
      kao(:, 1, 3, 4) = (/ &
     &1.4443e-04_r8,2.3826e-04_r8,2.7329e-04_r8,2.8523e-04_r8,2.8239e-04_r8,2.6871e-04_r8, &
     &2.4140e-04_r8,1.7625e-04_r8,9.1057e-05_r8/)
      kao(:, 2, 3, 4) = (/ &
     &1.6500e-04_r8,2.7899e-04_r8,3.2197e-04_r8,3.3661e-04_r8,3.4010e-04_r8,3.2744e-04_r8, &
     &2.9069e-04_r8,2.1583e-04_r8,1.2870e-04_r8/)
      kao(:, 3, 3, 4) = (/ &
     &1.8759e-04_r8,3.2667e-04_r8,3.7258e-04_r8,3.9759e-04_r8,4.0496e-04_r8,3.8750e-04_r8, &
     &3.4189e-04_r8,2.6207e-04_r8,1.7564e-04_r8/)
      kao(:, 4, 3, 4) = (/ &
     &2.1411e-04_r8,3.7810e-04_r8,4.3373e-04_r8,4.6557e-04_r8,4.7150e-04_r8,4.5014e-04_r8, &
     &3.9858e-04_r8,3.1356e-04_r8,2.3208e-04_r8/)
      kao(:, 5, 3, 4) = (/ &
     &2.3870e-04_r8,4.2957e-04_r8,5.0123e-04_r8,5.3924e-04_r8,5.3944e-04_r8,5.1553e-04_r8, &
     &4.6343e-04_r8,3.7106e-04_r8,2.9980e-04_r8/)
      kao(:, 1, 4, 4) = (/ &
     &2.6076e-04_r8,3.4439e-04_r8,3.6366e-04_r8,3.6515e-04_r8,3.5256e-04_r8,3.2080e-04_r8, &
     &2.7636e-04_r8,2.0889e-04_r8,8.2321e-05_r8/)
      kao(:, 2, 4, 4) = (/ &
     &2.9760e-04_r8,4.0373e-04_r8,4.3154e-04_r8,4.3412e-04_r8,4.1663e-04_r8,3.8448e-04_r8, &
     &3.3798e-04_r8,2.5481e-04_r8,1.1139e-04_r8/)
      kao(:, 3, 4, 4) = (/ &
     &3.4031e-04_r8,4.7084e-04_r8,5.0815e-04_r8,5.1064e-04_r8,4.9099e-04_r8,4.5954e-04_r8, &
     &4.0644e-04_r8,3.0187e-04_r8,1.5330e-04_r8/)
      kao(:, 4, 4, 4) = (/ &
     &3.8682e-04_r8,5.4745e-04_r8,5.9070e-04_r8,5.9370e-04_r8,5.7774e-04_r8,5.4347e-04_r8, &
     &4.7190e-04_r8,3.5452e-04_r8,2.0604e-04_r8/)
      kao(:, 5, 4, 4) = (/ &
     &4.3959e-04_r8,6.2729e-04_r8,6.7728e-04_r8,6.8652e-04_r8,6.7377e-04_r8,6.2625e-04_r8, &
     &5.4307e-04_r8,4.1535e-04_r8,2.7101e-04_r8/)
      kao(:, 1, 5, 4) = (/ &
     &4.3137e-04_r8,4.9354e-04_r8,4.9901e-04_r8,4.7432e-04_r8,4.3778e-04_r8,3.8485e-04_r8, &
     &3.1938e-04_r8,2.2709e-04_r8,7.3559e-05_r8/)
      kao(:, 2, 5, 4) = (/ &
     &4.9217e-04_r8,5.7735e-04_r8,5.8525e-04_r8,5.6095e-04_r8,5.2221e-04_r8,4.6398e-04_r8, &
     &3.8313e-04_r8,2.8160e-04_r8,1.0296e-04_r8/)
      kao(:, 3, 5, 4) = (/ &
     &5.6924e-04_r8,6.7555e-04_r8,6.8298e-04_r8,6.6362e-04_r8,6.1781e-04_r8,5.4692e-04_r8, &
     &4.5981e-04_r8,3.4088e-04_r8,1.4005e-04_r8/)
      kao(:, 4, 5, 4) = (/ &
     &6.5162e-04_r8,7.8635e-04_r8,7.9830e-04_r8,7.7682e-04_r8,7.2322e-04_r8,6.4526e-04_r8, &
     &5.4580e-04_r8,4.0061e-04_r8,1.8482e-04_r8/)
      kao(:, 5, 5, 4) = (/ &
     &7.5040e-04_r8,9.0883e-04_r8,9.2599e-04_r8,8.9925e-04_r8,8.3896e-04_r8,7.5567e-04_r8, &
     &6.3867e-04_r8,4.6416e-04_r8,2.4367e-04_r8/)
      kao(:, 1, 6, 4) = (/ &
     &6.5259e-04_r8,6.7358e-04_r8,6.6023e-04_r8,6.1431e-04_r8,5.5026e-04_r8,4.6572e-04_r8, &
     &3.6933e-04_r8,2.4724e-04_r8,6.3454e-05_r8/)
      kao(:, 2, 6, 4) = (/ &
     &7.5346e-04_r8,7.9866e-04_r8,7.7727e-04_r8,7.2579e-04_r8,6.4756e-04_r8,5.5655e-04_r8, &
     &4.4395e-04_r8,3.0264e-04_r8,8.7333e-05_r8/)
      kao(:, 3, 6, 4) = (/ &
     &8.8029e-04_r8,9.4301e-04_r8,9.1678e-04_r8,8.5383e-04_r8,7.6672e-04_r8,6.6157e-04_r8, &
     &5.3248e-04_r8,3.6645e-04_r8,1.2006e-04_r8/)
      kao(:, 4, 6, 4) = (/ &
     &1.0324e-03_r8,1.1112e-03_r8,1.0784e-03_r8,1.0064e-03_r8,9.0982e-04_r8,7.8126e-04_r8, &
     &6.2832e-04_r8,4.4008e-04_r8,1.6674e-04_r8/)
      kao(:, 5, 6, 4) = (/ &
     &1.1873e-03_r8,1.2942e-03_r8,1.2623e-03_r8,1.1793e-03_r8,1.0646e-03_r8,9.2296e-04_r8, &
     &7.3952e-04_r8,5.1891e-04_r8,2.2335e-04_r8/)
      kao(:, 1, 7, 4) = (/ &
     &1.0039e-03_r8,9.6265e-04_r8,8.9986e-04_r8,8.1533e-04_r8,7.1416e-04_r8,5.9439e-04_r8, &
     &4.5276e-04_r8,2.8651e-04_r8,6.5221e-05_r8/)
      kao(:, 2, 7, 4) = (/ &
     &1.1698e-03_r8,1.1414e-03_r8,1.0686e-03_r8,9.8012e-04_r8,8.6148e-04_r8,7.1658e-04_r8, &
     &5.4576e-04_r8,3.5076e-04_r8,8.8064e-05_r8/)
      kao(:, 3, 7, 4) = (/ &
     &1.3785e-03_r8,1.3654e-03_r8,1.2898e-03_r8,1.1834e-03_r8,1.0346e-03_r8,8.5792e-04_r8, &
     &6.6115e-04_r8,4.2986e-04_r8,1.2055e-04_r8/)
      kao(:, 4, 7, 4) = (/ &
     &1.6296e-03_r8,1.6337e-03_r8,1.5460e-03_r8,1.4118e-03_r8,1.2372e-03_r8,1.0278e-03_r8, &
     &7.9671e-04_r8,5.1331e-04_r8,1.5903e-04_r8/)
      kao(:, 5, 7, 4) = (/ &
     &1.9001e-03_r8,1.9217e-03_r8,1.8220e-03_r8,1.6571e-03_r8,1.4527e-03_r8,1.2164e-03_r8, &
     &9.4433e-04_r8,6.1289e-04_r8,2.0363e-04_r8/)
      kao(:, 1, 8, 4) = (/ &
     &1.8226e-03_r8,1.6514e-03_r8,1.4839e-03_r8,1.2932e-03_r8,1.0982e-03_r8,8.8723e-04_r8, &
     &6.5582e-04_r8,3.8869e-04_r8,7.0418e-05_r8/)
      kao(:, 2, 8, 4) = (/ &
     &2.1183e-03_r8,1.9484e-03_r8,1.7717e-03_r8,1.5557e-03_r8,1.3178e-03_r8,1.0649e-03_r8, &
     &7.9415e-04_r8,4.7222e-04_r8,9.8173e-05_r8/)
      kao(:, 3, 8, 4) = (/ &
     &2.5295e-03_r8,2.3395e-03_r8,2.1347e-03_r8,1.8817e-03_r8,1.6058e-03_r8,1.3046e-03_r8, &
     &9.6185e-04_r8,5.7415e-04_r8,1.2861e-04_r8/)
      kao(:, 4, 8, 4) = (/ &
     &3.0151e-03_r8,2.8208e-03_r8,2.5722e-03_r8,2.2683e-03_r8,1.9222e-03_r8,1.5620e-03_r8, &
     &1.1535e-03_r8,7.0406e-04_r8,1.7432e-04_r8/)
      kao(:, 5, 8, 4) = (/ &
     &3.5096e-03_r8,3.3177e-03_r8,3.0150e-03_r8,2.6542e-03_r8,2.2606e-03_r8,1.8422e-03_r8, &
     &1.3738e-03_r8,8.5046e-04_r8,2.3260e-04_r8/)
      kao(:, 1, 9, 4) = (/ &
     &7.9941e-03_r8,7.0328e-03_r8,6.0711e-03_r8,5.1105e-03_r8,4.1565e-03_r8,3.2070e-03_r8, &
     &2.2152e-03_r8,1.1971e-03_r8,7.9032e-05_r8/)
      kao(:, 2, 9, 4) = (/ &
     &8.9783e-03_r8,7.9063e-03_r8,6.8488e-03_r8,5.7943e-03_r8,4.7410e-03_r8,3.6528e-03_r8, &
     &2.5467e-03_r8,1.3852e-03_r8,1.1999e-04_r8/)
      kao(:, 3, 9, 4) = (/ &
     &1.0198e-02_r8,9.0183e-03_r8,7.8510e-03_r8,6.6811e-03_r8,5.4839e-03_r8,4.2200e-03_r8, &
     &2.9428e-03_r8,1.6034e-03_r8,1.6821e-04_r8/)
      kao(:, 4, 9, 4) = (/ &
     &1.1749e-02_r8,1.0423e-02_r8,9.0948e-03_r8,7.7411e-03_r8,6.3357e-03_r8,4.8731e-03_r8, &
     &3.3881e-03_r8,1.8608e-03_r8,2.4632e-04_r8/)
      kao(:, 5, 9, 4) = (/ &
     &1.3350e-02_r8,1.1910e-02_r8,1.0410e-02_r8,8.8879e-03_r8,7.2904e-03_r8,5.6383e-03_r8, &
     &3.9275e-03_r8,2.1612e-03_r8,3.3903e-04_r8/)
      kao(:, 1,10, 4) = (/ &
     &4.5801e-02_r8,4.0109e-02_r8,3.4395e-02_r8,2.8682e-02_r8,2.2984e-02_r8,1.7267e-02_r8, &
     &1.1579e-02_r8,5.9235e-03_r8,6.3484e-05_r8/)
      kao(:, 2,10, 4) = (/ &
     &4.9659e-02_r8,4.3500e-02_r8,3.7321e-02_r8,3.1127e-02_r8,2.4948e-02_r8,1.8778e-02_r8, &
     &1.2636e-02_r8,6.5101e-03_r8,9.5466e-05_r8/)
      kao(:, 3,10, 4) = (/ &
     &5.4357e-02_r8,4.7634e-02_r8,4.0874e-02_r8,3.4140e-02_r8,2.7418e-02_r8,2.0676e-02_r8, &
     &1.3967e-02_r8,7.2134e-03_r8,2.1246e-04_r8/)
      kao(:, 4,10, 4) = (/ &
     &6.0291e-02_r8,5.2843e-02_r8,4.5373e-02_r8,3.7958e-02_r8,3.0510e-02_r8,2.3082e-02_r8, &
     &1.5672e-02_r8,8.0960e-03_r8,3.5404e-04_r8/)
      kao(:, 5,10, 4) = (/ &
     &6.7661e-02_r8,5.9365e-02_r8,5.1042e-02_r8,4.2745e-02_r8,3.4451e-02_r8,2.6105e-02_r8, &
     &1.7693e-02_r8,9.1211e-03_r8,4.7192e-04_r8/)
      kao(:, 1,11, 4) = (/ &
     &9.0702e-02_r8,7.9394e-02_r8,6.8068e-02_r8,5.6747e-02_r8,4.5417e-02_r8,3.4107e-02_r8, &
     &2.2797e-02_r8,1.1511e-02_r8,7.5853e-05_r8/)
      kao(:, 2,11, 4) = (/ &
     &9.9244e-02_r8,8.6879e-02_r8,7.4483e-02_r8,6.2100e-02_r8,4.9720e-02_r8,3.7362e-02_r8, &
     &2.5008e-02_r8,1.2672e-02_r8,1.0256e-04_r8/)
      kao(:, 3,11, 4) = (/ &
     &1.0852e-01_r8,9.5023e-02_r8,8.1487e-02_r8,6.7960e-02_r8,5.4445e-02_r8,4.0919e-02_r8, &
     &2.7423e-02_r8,1.3982e-02_r8,1.6509e-04_r8/)
      kao(:, 4,11, 4) = (/ &
     &1.1956e-01_r8,1.0470e-01_r8,8.9828e-02_r8,7.4940e-02_r8,6.0117e-02_r8,4.5252e-02_r8, &
     &3.0437e-02_r8,1.5543e-02_r8,3.1661e-04_r8/)
      kao(:, 5,11, 4) = (/ &
     &1.3039e-01_r8,1.1429e-01_r8,9.8079e-02_r8,8.1967e-02_r8,6.5782e-02_r8,4.9565e-02_r8, &
     &3.3397e-02_r8,1.7070e-02_r8,5.0645e-04_r8/)
      kao(:, 1,12, 4) = (/ &
     &1.2021e-01_r8,1.0519e-01_r8,9.0195e-02_r8,7.5171e-02_r8,6.0154e-02_r8,4.5148e-02_r8, &
     &3.0151e-02_r8,1.5167e-02_r8,6.7632e-05_r8/)
      kao(:, 2,12, 4) = (/ &
     &1.3016e-01_r8,1.1394e-01_r8,9.7701e-02_r8,8.1469e-02_r8,6.5222e-02_r8,4.8981e-02_r8, &
     &3.2777e-02_r8,1.6564e-02_r8,9.6691e-05_r8/)
      kao(:, 3,12, 4) = (/ &
     &1.4257e-01_r8,1.2479e-01_r8,1.0706e-01_r8,8.9271e-02_r8,7.1459e-02_r8,5.3715e-02_r8, &
     &3.5967e-02_r8,1.8266e-02_r8,1.8650e-04_r8/)
      kao(:, 4,12, 4) = (/ &
     &1.5648e-01_r8,1.3701e-01_r8,1.1748e-01_r8,9.8018e-02_r8,7.8554e-02_r8,5.9075e-02_r8, &
     &3.9673e-02_r8,2.0186e-02_r8,3.5387e-04_r8/)
      kao(:, 5,12, 4) = (/ &
     &1.6740e-01_r8,1.4658e-01_r8,1.2570e-01_r8,1.0496e-01_r8,8.4156e-02_r8,6.3336e-02_r8, &
     &4.2553e-02_r8,2.1604e-02_r8,5.3320e-04_r8/)
      kao(:, 1,13, 4) = (/ &
     &1.2573e-01_r8,1.1000e-01_r8,9.4314e-02_r8,7.8615e-02_r8,6.2929e-02_r8,4.7219e-02_r8, &
     &3.1536e-02_r8,1.5865e-02_r8,5.0474e-05_r8/)
      kao(:, 2,13, 4) = (/ &
     &1.3569e-01_r8,1.1873e-01_r8,1.0180e-01_r8,8.4863e-02_r8,6.7917e-02_r8,5.1000e-02_r8, &
     &3.4100e-02_r8,1.7211e-02_r8,1.0366e-04_r8/)
      kao(:, 3,13, 4) = (/ &
     &1.4578e-01_r8,1.2755e-01_r8,1.0936e-01_r8,9.1174e-02_r8,7.3030e-02_r8,5.4868e-02_r8, &
     &3.6725e-02_r8,1.8584e-02_r8,2.4417e-04_r8/)
      kao(:, 4,13, 4) = (/ &
     &1.5300e-01_r8,1.3393e-01_r8,1.1485e-01_r8,9.5797e-02_r8,7.6755e-02_r8,5.7691e-02_r8, &
     &3.8700e-02_r8,1.9588e-02_r8,3.9463e-04_r8/)
      kao(:, 5,13, 4) = (/ &
     &1.5948e-01_r8,1.3959e-01_r8,1.1975e-01_r8,9.9939e-02_r8,8.0103e-02_r8,6.0267e-02_r8, &
     &4.0442e-02_r8,2.0476e-02_r8,5.2489e-04_r8/)
      kao(:, 1, 1, 5) = (/ &
     &3.0730e-04_r8,4.0869e-04_r8,4.2558e-04_r8,4.1836e-04_r8,3.9519e-04_r8,3.6372e-04_r8, &
     &2.8694e-04_r8,2.6584e-04_r8,2.1801e-04_r8/)
      kao(:, 2, 1, 5) = (/ &
     &3.2538e-04_r8,4.3862e-04_r8,4.6062e-04_r8,4.5800e-04_r8,4.4348e-04_r8,4.2125e-04_r8, &
     &3.6505e-04_r8,3.2613e-04_r8,2.9396e-04_r8/)
      kao(:, 3, 1, 5) = (/ &
     &3.3965e-04_r8,4.6778e-04_r8,5.0124e-04_r8,5.0588e-04_r8,5.0627e-04_r8,4.8837e-04_r8, &
     &4.4591e-04_r8,3.9091e-04_r8,3.8601e-04_r8/)
      kao(:, 4, 1, 5) = (/ &
     &3.5305e-04_r8,5.0005e-04_r8,5.4810e-04_r8,5.6545e-04_r8,5.7634e-04_r8,5.6350e-04_r8, &
     &5.3398e-04_r8,4.9322e-04_r8,4.9703e-04_r8/)
      kao(:, 5, 1, 5) = (/ &
     &3.6843e-04_r8,5.3559e-04_r8,6.0074e-04_r8,6.3388e-04_r8,6.5476e-04_r8,6.5121e-04_r8, &
     &6.3615e-04_r8,6.1596e-04_r8,6.2900e-04_r8/)
      kao(:, 1, 2, 5) = (/ &
     &4.2086e-04_r8,5.1417e-04_r8,5.1972e-04_r8,4.9790e-04_r8,4.6126e-04_r8,4.1005e-04_r8, &
     &3.3841e-04_r8,2.3086e-04_r8,1.8396e-04_r8/)
      kao(:, 2, 2, 5) = (/ &
     &4.4142e-04_r8,5.4838e-04_r8,5.5918e-04_r8,5.4271e-04_r8,5.1015e-04_r8,4.6371e-04_r8, &
     &3.9686e-04_r8,2.8420e-04_r8,2.4486e-04_r8/)
      kao(:, 3, 2, 5) = (/ &
     &4.6438e-04_r8,5.8432e-04_r8,6.0102e-04_r8,5.9651e-04_r8,5.6920e-04_r8,5.3041e-04_r8, &
     &4.5976e-04_r8,3.7342e-04_r8,3.2265e-04_r8/)
      kao(:, 4, 2, 5) = (/ &
     &4.8279e-04_r8,6.2418e-04_r8,6.4960e-04_r8,6.5695e-04_r8,6.3988e-04_r8,6.0274e-04_r8, &
     &5.3017e-04_r8,4.6801e-04_r8,4.1702e-04_r8/)
      kao(:, 5, 2, 5) = (/ &
     &4.9938e-04_r8,6.6314e-04_r8,7.0911e-04_r8,7.2552e-04_r8,7.1847e-04_r8,6.8356e-04_r8, &
     &6.1801e-04_r8,5.7242e-04_r8,5.3937e-04_r8/)
      kao(:, 1, 3, 5) = (/ &
     &7.5073e-04_r8,8.1743e-04_r8,7.9414e-04_r8,7.4039e-04_r8,6.6425e-04_r8,5.6902e-04_r8, &
     &4.5211e-04_r8,2.9071e-04_r8,1.7629e-04_r8/)
      kao(:, 2, 3, 5) = (/ &
     &7.9242e-04_r8,8.7156e-04_r8,8.5005e-04_r8,8.0165e-04_r8,7.1947e-04_r8,6.2467e-04_r8, &
     &5.0816e-04_r8,3.5038e-04_r8,2.3642e-04_r8/)
      kao(:, 3, 3, 5) = (/ &
     &8.3043e-04_r8,9.2555e-04_r8,9.1453e-04_r8,8.6093e-04_r8,7.8464e-04_r8,6.9275e-04_r8, &
     &5.7807e-04_r8,4.1288e-04_r8,3.0691e-04_r8/)
      kao(:, 4, 3, 5) = (/ &
     &8.6053e-04_r8,9.7674e-04_r8,9.7765e-04_r8,9.2813e-04_r8,8.5853e-04_r8,7.7377e-04_r8, &
     &6.5702e-04_r8,4.8317e-04_r8,3.9911e-04_r8/)
      kao(:, 5, 3, 5) = (/ &
     &8.9084e-04_r8,1.0351e-03_r8,1.0435e-03_r8,1.0049e-03_r8,9.4814e-04_r8,8.6574e-04_r8, &
     &7.4637e-04_r8,5.6491e-04_r8,5.0649e-04_r8/)
      kao(:, 1, 4, 5) = (/ &
     &1.3691e-03_r8,1.3420e-03_r8,1.2789e-03_r8,1.1571e-03_r8,1.0054e-03_r8,8.3457e-04_r8, &
     &6.3859e-04_r8,4.0761e-04_r8,1.5090e-04_r8/)
      kao(:, 2, 4, 5) = (/ &
     &1.4497e-03_r8,1.4458e-03_r8,1.3693e-03_r8,1.2399e-03_r8,1.0886e-03_r8,9.0944e-04_r8, &
     &6.9922e-04_r8,4.5891e-04_r8,2.1864e-04_r8/)
      kao(:, 3, 4, 5) = (/ &
     &1.5092e-03_r8,1.5288e-03_r8,1.4492e-03_r8,1.3231e-03_r8,1.1702e-03_r8,9.8222e-04_r8, &
     &7.7013e-04_r8,5.2474e-04_r8,3.0407e-04_r8/)
      kao(:, 4, 4, 5) = (/ &
     &1.5602e-03_r8,1.6068e-03_r8,1.5312e-03_r8,1.4087e-03_r8,1.2594e-03_r8,1.0655e-03_r8, &
     &8.5735e-04_r8,5.9578e-04_r8,3.9268e-04_r8/)
      kao(:, 5, 4, 5) = (/ &
     &1.6108e-03_r8,1.6853e-03_r8,1.6164e-03_r8,1.5057e-03_r8,1.3492e-03_r8,1.1682e-03_r8, &
     &9.6058e-04_r8,6.7959e-04_r8,4.9525e-04_r8/)
      kao(:, 1, 5, 5) = (/ &
     &2.3434e-03_r8,2.1631e-03_r8,1.9859e-03_r8,1.7683e-03_r8,1.5141e-03_r8,1.2226e-03_r8, &
     &8.9923e-04_r8,5.4477e-04_r8,1.2575e-04_r8/)
      kao(:, 2, 5, 5) = (/ &
     &2.4752e-03_r8,2.3171e-03_r8,2.1360e-03_r8,1.9016e-03_r8,1.6214e-03_r8,1.3108e-03_r8, &
     &9.7831e-04_r8,5.9705e-04_r8,1.8419e-04_r8/)
      kao(:, 3, 5, 5) = (/ &
     &2.5685e-03_r8,2.4387e-03_r8,2.2507e-03_r8,2.0028e-03_r8,1.7171e-03_r8,1.4030e-03_r8, &
     &1.0542e-03_r8,6.5942e-04_r8,2.6114e-04_r8/)
      kao(:, 4, 5, 5) = (/ &
     &2.6469e-03_r8,2.5385e-03_r8,2.3599e-03_r8,2.1047e-03_r8,1.8139e-03_r8,1.4974e-03_r8, &
     &1.1404e-03_r8,7.3650e-04_r8,3.6173e-04_r8/)
      kao(:, 5, 5, 5) = (/ &
     &2.7111e-03_r8,2.6448e-03_r8,2.4645e-03_r8,2.2107e-03_r8,1.9222e-03_r8,1.6048e-03_r8, &
     &1.2367e-03_r8,8.2822e-04_r8,4.7124e-04_r8/)
      kao(:, 1, 6, 5) = (/ &
     &3.6870e-03_r8,3.3081e-03_r8,2.9535e-03_r8,2.5781e-03_r8,2.1710e-03_r8,1.7353e-03_r8, &
     &1.2527e-03_r8,7.1995e-04_r8,1.0649e-04_r8/)
      kao(:, 2, 6, 5) = (/ &
     &3.8867e-03_r8,3.5260e-03_r8,3.1721e-03_r8,2.7718e-03_r8,2.3392e-03_r8,1.8682e-03_r8, &
     &1.3468e-03_r8,7.8719e-04_r8,1.5668e-04_r8/)
      kao(:, 3, 6, 5) = (/ &
     &4.0284e-03_r8,3.6872e-03_r8,3.3334e-03_r8,2.9169e-03_r8,2.4661e-03_r8,1.9733e-03_r8, &
     &1.4372e-03_r8,8.5750e-04_r8,2.1580e-04_r8/)
      kao(:, 4, 6, 5) = (/ &
     &4.1355e-03_r8,3.8269e-03_r8,3.4723e-03_r8,3.0564e-03_r8,2.5962e-03_r8,2.0858e-03_r8, &
     &1.5388e-03_r8,9.2919e-04_r8,2.8921e-04_r8/)
      kao(:, 5, 6, 5) = (/ &
     &4.2530e-03_r8,3.9771e-03_r8,3.6076e-03_r8,3.1973e-03_r8,2.7175e-03_r8,2.1980e-03_r8, &
     &1.6503e-03_r8,1.0123e-03_r8,3.9933e-04_r8/)
      kao(:, 1, 7, 5) = (/ &
     &5.9303e-03_r8,5.2537e-03_r8,4.6038e-03_r8,3.9568e-03_r8,3.2763e-03_r8,2.5699e-03_r8, &
     &1.8266e-03_r8,1.0238e-03_r8,9.0759e-05_r8/)
      kao(:, 2, 7, 5) = (/ &
     &6.2719e-03_r8,5.5854e-03_r8,4.9264e-03_r8,4.2403e-03_r8,3.5196e-03_r8,2.7643e-03_r8, &
     &1.9714e-03_r8,1.1058e-03_r8,1.3173e-04_r8/)
      kao(:, 3, 7, 5) = (/ &
     &6.5193e-03_r8,5.8407e-03_r8,5.1576e-03_r8,4.4431e-03_r8,3.6909e-03_r8,2.9114e-03_r8, &
     &2.0825e-03_r8,1.1806e-03_r8,1.8536e-04_r8/)
      kao(:, 4, 7, 5) = (/ &
     &6.6989e-03_r8,6.0314e-03_r8,5.3552e-03_r8,4.6281e-03_r8,3.8605e-03_r8,3.0624e-03_r8, &
     &2.1992e-03_r8,1.2697e-03_r8,2.6787e-04_r8/)
      kao(:, 5, 7, 5) = (/ &
     &6.9450e-03_r8,6.3008e-03_r8,5.6152e-03_r8,4.8622e-03_r8,4.0675e-03_r8,3.2291e-03_r8, &
     &2.3204e-03_r8,1.3675e-03_r8,3.5672e-04_r8/)
      kao(:, 1, 8, 5) = (/ &
     &1.1078e-02_r8,9.7294e-03_r8,8.3981e-03_r8,7.0957e-03_r8,5.7917e-03_r8,4.4718e-03_r8, &
     &3.1091e-03_r8,1.6886e-03_r8,1.1294e-04_r8/)
      kao(:, 2, 8, 5) = (/ &
     &1.1717e-02_r8,1.0310e-02_r8,8.9257e-03_r8,7.5752e-03_r8,6.2113e-03_r8,4.8050e-03_r8, &
     &3.3497e-03_r8,1.8274e-03_r8,1.4724e-04_r8/)
      kao(:, 3, 8, 5) = (/ &
     &1.2207e-02_r8,1.0778e-02_r8,9.3683e-03_r8,7.9668e-03_r8,6.5278e-03_r8,5.0484e-03_r8, &
     &3.5310e-03_r8,1.9391e-03_r8,2.0653e-04_r8/)
      kao(:, 4, 8, 5) = (/ &
     &1.2674e-02_r8,1.1230e-02_r8,9.8021e-03_r8,8.3609e-03_r8,6.8807e-03_r8,5.3359e-03_r8, &
     &3.7364e-03_r8,2.0615e-03_r8,2.8343e-04_r8/)
      kao(:, 5, 8, 5) = (/ &
     &1.3265e-02_r8,1.1790e-02_r8,1.0322e-02_r8,8.8148e-03_r8,7.2381e-03_r8,5.6108e-03_r8, &
     &3.9433e-03_r8,2.1912e-03_r8,3.7254e-04_r8/)
      kao(:, 1, 9, 5) = (/ &
     &3.7052e-02_r8,3.2437e-02_r8,2.7835e-02_r8,2.3250e-02_r8,1.8658e-02_r8,1.4080e-02_r8, &
     &9.5558e-03_r8,4.9966e-03_r8,1.9423e-04_r8/)
      kao(:, 2, 9, 5) = (/ &
     &3.9539e-02_r8,3.4640e-02_r8,2.9744e-02_r8,2.4857e-02_r8,1.9981e-02_r8,1.5146e-02_r8, &
     &1.0322e-02_r8,5.4117e-03_r8,2.4661e-04_r8/)
      kao(:, 3, 9, 5) = (/ &
     &4.1918e-02_r8,3.6737e-02_r8,3.1561e-02_r8,2.6402e-02_r8,2.1269e-02_r8,1.6195e-02_r8, &
     &1.1056e-02_r8,5.7963e-03_r8,3.2011e-04_r8/)
      kao(:, 4, 9, 5) = (/ &
     &4.4100e-02_r8,3.8673e-02_r8,3.3273e-02_r8,2.7895e-02_r8,2.2554e-02_r8,1.7214e-02_r8, &
     &1.1779e-02_r8,6.1756e-03_r8,4.1260e-04_r8/)
      kao(:, 5, 9, 5) = (/ &
     &4.6405e-02_r8,4.0709e-02_r8,3.5073e-02_r8,2.9453e-02_r8,2.3852e-02_r8,1.8195e-02_r8, &
     &1.2445e-02_r8,6.5667e-03_r8,5.2938e-04_r8/)
      kao(:, 1,10, 5) = (/ &
     &1.5260e-01_r8,1.3356e-01_r8,1.1452e-01_r8,9.5486e-02_r8,7.6440e-02_r8,5.7459e-02_r8, &
     &3.8411e-02_r8,1.9334e-02_r8,1.8781e-04_r8/)
      kao(:, 2,10, 5) = (/ &
     &1.6192e-01_r8,1.4171e-01_r8,1.2154e-01_r8,1.0139e-01_r8,8.1225e-02_r8,6.1032e-02_r8, &
     &4.0817e-02_r8,2.0639e-02_r8,3.0020e-04_r8/)
      kao(:, 3,10, 5) = (/ &
     &1.6952e-01_r8,1.4839e-01_r8,1.2731e-01_r8,1.0623e-01_r8,8.5090e-02_r8,6.3990e-02_r8, &
     &4.2882e-02_r8,2.1810e-02_r8,3.7223e-04_r8/)
      kao(:, 4,10, 5) = (/ &
     &1.7675e-01_r8,1.5478e-01_r8,1.3285e-01_r8,1.1085e-01_r8,8.8843e-02_r8,6.6852e-02_r8, &
     &4.4829e-02_r8,2.2833e-02_r8,4.6711e-04_r8/)
      kao(:, 5,10, 5) = (/ &
     &1.8239e-01_r8,1.5968e-01_r8,1.3704e-01_r8,1.1434e-01_r8,9.1701e-02_r8,6.9058e-02_r8, &
     &4.6429e-02_r8,2.3733e-02_r8,6.6086e-04_r8/)
      kao(:, 1,11, 5) = (/ &
     &2.7058e-01_r8,2.3683e-01_r8,2.0302e-01_r8,1.6928e-01_r8,1.3552e-01_r8,1.0170e-01_r8, &
     &6.7859e-02_r8,3.4017e-02_r8,1.5001e-04_r8/)
      kao(:, 2,11, 5) = (/ &
     &2.7834e-01_r8,2.4359e-01_r8,2.0889e-01_r8,1.7416e-01_r8,1.3942e-01_r8,1.0462e-01_r8, &
     &6.9857e-02_r8,3.5072e-02_r8,2.9190e-04_r8/)
      kao(:, 3,11, 5) = (/ &
     &2.8582e-01_r8,2.5022e-01_r8,2.1462e-01_r8,1.7895e-01_r8,1.4327e-01_r8,1.0754e-01_r8, &
     &7.1838e-02_r8,3.6157e-02_r8,3.9721e-04_r8/)
      kao(:, 4,11, 5) = (/ &
     &2.8898e-01_r8,2.5301e-01_r8,2.1700e-01_r8,1.8097e-01_r8,1.4487e-01_r8,1.0884e-01_r8, &
     &7.2766e-02_r8,3.6699e-02_r8,5.3597e-04_r8/)
      kao(:, 5,11, 5) = (/ &
     &2.9536e-01_r8,2.5857e-01_r8,2.2177e-01_r8,1.8491e-01_r8,1.4809e-01_r8,1.1136e-01_r8, &
     &7.4481e-02_r8,3.7679e-02_r8,7.1552e-04_r8/)
      kao(:, 1,12, 5) = (/ &
     &3.2683e-01_r8,2.8605e-01_r8,2.4525e-01_r8,2.0441e-01_r8,1.6361e-01_r8,1.2282e-01_r8, &
     &8.1893e-02_r8,4.1016e-02_r8,1.4076e-04_r8/)
      kao(:, 2,12, 5) = (/ &
     &3.3106e-01_r8,2.8971e-01_r8,2.4839e-01_r8,2.0704e-01_r8,1.6570e-01_r8,1.2434e-01_r8, &
     &8.2938e-02_r8,4.1600e-02_r8,2.8033e-04_r8/)
      kao(:, 3,12, 5) = (/ &
     &3.3746e-01_r8,2.9539e-01_r8,2.5326e-01_r8,2.1111e-01_r8,1.6904e-01_r8,1.2682e-01_r8, &
     &8.4697e-02_r8,4.2481e-02_r8,3.8254e-04_r8/)
      kao(:, 4,12, 5) = (/ &
     &3.4047e-01_r8,2.9813e-01_r8,2.5560e-01_r8,2.1310e-01_r8,1.7062e-01_r8,1.2812e-01_r8, &
     &8.5526e-02_r8,4.3047e-02_r8,5.1612e-04_r8/)
      kao(:, 5,12, 5) = (/ &
     &3.4523e-01_r8,3.0226e-01_r8,2.5919e-01_r8,2.1613e-01_r8,1.7310e-01_r8,1.3003e-01_r8, &
     &8.6933e-02_r8,4.3928e-02_r8,7.3625e-04_r8/)
      kao(:, 1,13, 5) = (/ &
     &2.9792e-01_r8,2.6068e-01_r8,2.2349e-01_r8,1.8628e-01_r8,1.4905e-01_r8,1.1181e-01_r8, &
     &7.4561e-02_r8,3.7329e-02_r8,1.5388e-04_r8/)
      kao(:, 2,13, 5) = (/ &
     &3.0081e-01_r8,2.6326e-01_r8,2.2566e-01_r8,1.8811e-01_r8,1.5050e-01_r8,1.1291e-01_r8, &
     &7.5310e-02_r8,3.7768e-02_r8,2.8934e-04_r8/)
      kao(:, 3,13, 5) = (/ &
     &3.0121e-01_r8,2.6362e-01_r8,2.2602e-01_r8,1.8840e-01_r8,1.5077e-01_r8,1.1318e-01_r8, &
     &7.5585e-02_r8,3.7991e-02_r8,3.3166e-04_r8/)
      kao(:, 4,13, 5) = (/ &
     &3.0495e-01_r8,2.6698e-01_r8,2.2888e-01_r8,1.9082e-01_r8,1.5277e-01_r8,1.1476e-01_r8, &
     &7.6636e-02_r8,3.8673e-02_r8,4.6400e-04_r8/)
      kao(:, 5,13, 5) = (/ &
     &3.1093e-01_r8,2.7226e-01_r8,2.3342e-01_r8,1.9467e-01_r8,1.5596e-01_r8,1.1716e-01_r8, &
     &7.8384e-02_r8,3.9602e-02_r8,6.9078e-04_r8/)
      kao(:, 1, 1, 6) = (/ &
     &6.7719e-04_r8,7.1472e-04_r8,7.1797e-04_r8,6.8628e-04_r8,6.3509e-04_r8,5.7059e-04_r8, &
     &5.0987e-04_r8,3.4938e-04_r8,4.0895e-04_r8/)
      kao(:, 2, 1, 6) = (/ &
     &6.7482e-04_r8,7.4520e-04_r8,7.5758e-04_r8,7.4570e-04_r8,7.0620e-04_r8,6.5805e-04_r8, &
     &6.1645e-04_r8,4.7281e-04_r8,5.4801e-04_r8/)
      kao(:, 3, 1, 6) = (/ &
     &6.7924e-04_r8,7.8313e-04_r8,8.0713e-04_r8,8.1739e-04_r8,7.9231e-04_r8,7.6723e-04_r8, &
     &7.3523e-04_r8,6.1861e-04_r8,7.0683e-04_r8/)
      kao(:, 4, 1, 6) = (/ &
     &6.8649e-04_r8,8.2657e-04_r8,8.7129e-04_r8,9.0685e-04_r8,8.9681e-04_r8,8.9801e-04_r8, &
     &8.6860e-04_r8,7.7360e-04_r8,8.9309e-04_r8/)
      kao(:, 5, 1, 6) = (/ &
     &6.9142e-04_r8,8.7359e-04_r8,9.5301e-04_r8,1.0075e-03_r8,1.0203e-03_r8,1.0461e-03_r8, &
     &1.0218e-03_r8,9.5114e-04_r8,1.0965e-03_r8/)
      kao(:, 1, 2, 6) = (/ &
     &9.6029e-04_r8,9.5330e-04_r8,9.1502e-04_r8,8.4442e-04_r8,7.4240e-04_r8,6.3131e-04_r8, &
     &5.2007e-04_r8,3.7829e-04_r8,3.5691e-04_r8/)
      kao(:, 2, 2, 6) = (/ &
     &9.5985e-04_r8,9.8942e-04_r8,9.6445e-04_r8,8.9433e-04_r8,8.0300e-04_r8,7.0134e-04_r8, &
     &6.1315e-04_r8,5.0159e-04_r8,4.8663e-04_r8/)
      kao(:, 3, 2, 6) = (/ &
     &9.6320e-04_r8,1.0310e-03_r8,1.0191e-03_r8,9.5205e-04_r8,8.7761e-04_r8,7.9453e-04_r8, &
     &7.3253e-04_r8,6.2365e-04_r8,6.4547e-04_r8/)
      kao(:, 4, 2, 6) = (/ &
     &9.7399e-04_r8,1.0755e-03_r8,1.0817e-03_r8,1.0333e-03_r8,9.7218e-04_r8,9.1068e-04_r8, &
     &8.7686e-04_r8,7.5862e-04_r8,8.3212e-04_r8/)
      kao(:, 5, 2, 6) = (/ &
     &9.8138e-04_r8,1.1324e-03_r8,1.1507e-03_r8,1.1333e-03_r8,1.0937e-03_r8,1.0509e-03_r8, &
     &1.0310e-03_r8,9.0559e-04_r8,1.0246e-03_r8/)
      kao(:, 1, 3, 6) = (/ &
     &1.8119e-03_r8,1.6817e-03_r8,1.5499e-03_r8,1.3740e-03_r8,1.1743e-03_r8,9.5554e-04_r8, &
     &7.1656e-04_r8,4.7034e-04_r8,2.9777e-04_r8/)
      kao(:, 2, 3, 6) = (/ &
     &1.8107e-03_r8,1.7310e-03_r8,1.6189e-03_r8,1.4391e-03_r8,1.2510e-03_r8,1.0204e-03_r8, &
     &7.8709e-04_r8,5.5271e-04_r8,4.0666e-04_r8/)
      kao(:, 3, 3, 6) = (/ &
     &1.8217e-03_r8,1.7823e-03_r8,1.6795e-03_r8,1.5235e-03_r8,1.3331e-03_r8,1.1033e-03_r8, &
     &8.7727e-04_r8,6.6343e-04_r8,5.5347e-04_r8/)
      kao(:, 4, 3, 6) = (/ &
     &1.8325e-03_r8,1.8451e-03_r8,1.7507e-03_r8,1.6178e-03_r8,1.4289e-03_r8,1.2102e-03_r8, &
     &9.9121e-04_r8,7.9875e-04_r8,7.2923e-04_r8/)
      kao(:, 5, 3, 6) = (/ &
     &1.8499e-03_r8,1.9065e-03_r8,1.8500e-03_r8,1.7218e-03_r8,1.5483e-03_r8,1.3411e-03_r8, &
     &1.1326e-03_r8,9.4539e-04_r8,9.3725e-04_r8/)
      kao(:, 1, 4, 6) = (/ &
     &3.4114e-03_r8,3.0491e-03_r8,2.7140e-03_r8,2.3662e-03_r8,1.9783e-03_r8,1.5658e-03_r8, &
     &1.1300e-03_r8,6.5946e-04_r8,2.6201e-04_r8/)
      kao(:, 2, 4, 6) = (/ &
     &3.4376e-03_r8,3.0989e-03_r8,2.7962e-03_r8,2.4537e-03_r8,2.0666e-03_r8,1.6491e-03_r8, &
     &1.2098e-03_r8,7.2995e-04_r8,3.5441e-04_r8/)
      kao(:, 3, 4, 6) = (/ &
     &3.4485e-03_r8,3.1733e-03_r8,2.8848e-03_r8,2.5421e-03_r8,2.1715e-03_r8,1.7580e-03_r8, &
     &1.3056e-03_r8,8.1745e-04_r8,4.7057e-04_r8/)
      kao(:, 4, 4, 6) = (/ &
     &3.4770e-03_r8,3.2632e-03_r8,3.0027e-03_r8,2.6508e-03_r8,2.2906e-03_r8,1.8839e-03_r8, &
     &1.4242e-03_r8,9.3156e-04_r8,6.1906e-04_r8/)
      kao(:, 5, 4, 6) = (/ &
     &3.5195e-03_r8,3.3661e-03_r8,3.1261e-03_r8,2.7792e-03_r8,2.4277e-03_r8,2.0261e-03_r8, &
     &1.5634e-03_r8,1.0703e-03_r8,8.1465e-04_r8/)
      kao(:, 1, 5, 6) = (/ &
     &5.7502e-03_r8,5.0807e-03_r8,4.4217e-03_r8,3.7897e-03_r8,3.1287e-03_r8,2.4547e-03_r8, &
     &1.7341e-03_r8,9.6239e-04_r8,2.4204e-04_r8/)
      kao(:, 2, 5, 6) = (/ &
     &5.7894e-03_r8,5.1466e-03_r8,4.5231e-03_r8,3.9026e-03_r8,3.2431e-03_r8,2.5561e-03_r8, &
     &1.8209e-03_r8,1.0387e-03_r8,3.3073e-04_r8/)
      kao(:, 3, 5, 6) = (/ &
     &5.8510e-03_r8,5.2408e-03_r8,4.6666e-03_r8,4.0479e-03_r8,3.3863e-03_r8,2.6690e-03_r8, &
     &1.9231e-03_r8,1.1318e-03_r8,4.4023e-04_r8/)
      kao(:, 4, 5, 6) = (/ &
     &5.9488e-03_r8,5.3756e-03_r8,4.8127e-03_r8,4.2175e-03_r8,3.5437e-03_r8,2.8108e-03_r8, &
     &2.0541e-03_r8,1.2413e-03_r8,5.7017e-04_r8/)
      kao(:, 5, 5, 6) = (/ &
     &6.0632e-03_r8,5.5286e-03_r8,4.9850e-03_r8,4.3894e-03_r8,3.7125e-03_r8,2.9737e-03_r8, &
     &2.2202e-03_r8,1.3784e-03_r8,7.3804e-04_r8/)
      kao(:, 1, 6, 6) = (/ &
     &9.0144e-03_r8,7.9241e-03_r8,6.8389e-03_r8,5.7807e-03_r8,4.7224e-03_r8,3.6386e-03_r8, &
     &2.5487e-03_r8,1.3755e-03_r8,2.0268e-04_r8/)
      kao(:, 2, 6, 6) = (/ &
     &9.0405e-03_r8,7.9650e-03_r8,6.9105e-03_r8,5.8762e-03_r8,4.8286e-03_r8,3.7488e-03_r8, &
     &2.6372e-03_r8,1.4443e-03_r8,2.8152e-04_r8/)
      kao(:, 3, 6, 6) = (/ &
     &9.2000e-03_r8,8.1570e-03_r8,7.1089e-03_r8,6.0851e-03_r8,5.0081e-03_r8,3.9064e-03_r8, &
     &2.7603e-03_r8,1.5330e-03_r8,3.9833e-04_r8/)
      kao(:, 4, 6, 6) = (/ &
     &9.3676e-03_r8,8.3397e-03_r8,7.3293e-03_r8,6.2884e-03_r8,5.2172e-03_r8,4.0838e-03_r8, &
     &2.8967e-03_r8,1.6576e-03_r8,5.5504e-04_r8/)
      kao(:, 5, 6, 6) = (/ &
     &9.5404e-03_r8,8.5459e-03_r8,7.5717e-03_r8,6.5076e-03_r8,5.4312e-03_r8,4.2828e-03_r8, &
     &3.0616e-03_r8,1.8170e-03_r8,7.2861e-04_r8/)
      kao(:, 1, 7, 6) = (/ &
     &1.4907e-02_r8,1.3059e-02_r8,1.1219e-02_r8,9.3912e-03_r8,7.6074e-03_r8,5.8006e-03_r8, &
     &3.9637e-03_r8,2.0976e-03_r8,1.8870e-04_r8/)
      kao(:, 2, 7, 6) = (/ &
     &1.4960e-02_r8,1.3123e-02_r8,1.1304e-02_r8,9.5034e-03_r8,7.7189e-03_r8,5.9029e-03_r8, &
     &4.0714e-03_r8,2.1752e-03_r8,2.5278e-04_r8/)
      kao(:, 3, 7, 6) = (/ &
     &1.5077e-02_r8,1.3255e-02_r8,1.1479e-02_r8,9.6943e-03_r8,7.9204e-03_r8,6.0871e-03_r8, &
     &4.2229e-03_r8,2.2784e-03_r8,3.4866e-04_r8/)
      kao(:, 4, 7, 6) = (/ &
     &1.5413e-02_r8,1.3606e-02_r8,1.1805e-02_r8,1.0016e-02_r8,8.1764e-03_r8,6.3063e-03_r8, &
     &4.3884e-03_r8,2.3906e-03_r8,4.7884e-04_r8/)
      kao(:, 5, 7, 6) = (/ &
     &1.5640e-02_r8,1.3874e-02_r8,1.2089e-02_r8,1.0323e-02_r8,8.4660e-03_r8,6.5392e-03_r8, &
     &4.5932e-03_r8,2.5421e-03_r8,6.8588e-04_r8/)
      kao(:, 1, 8, 6) = (/ &
     &2.8559e-02_r8,2.4997e-02_r8,2.1448e-02_r8,1.7898e-02_r8,1.4352e-02_r8,1.0840e-02_r8, &
     &7.3538e-03_r8,3.7976e-03_r8,1.9487e-04_r8/)
      kao(:, 2, 8, 6) = (/ &
     &2.8738e-02_r8,2.5172e-02_r8,2.1609e-02_r8,1.8050e-02_r8,1.4521e-02_r8,1.1028e-02_r8, &
     &7.4791e-03_r8,3.8937e-03_r8,2.5597e-04_r8/)
      kao(:, 3, 8, 6) = (/ &
     &2.9088e-02_r8,2.5505e-02_r8,2.1920e-02_r8,1.8369e-02_r8,1.4844e-02_r8,1.1305e-02_r8, &
     &7.7085e-03_r8,4.0334e-03_r8,3.3647e-04_r8/)
      kao(:, 4, 8, 6) = (/ &
     &2.9471e-02_r8,2.5866e-02_r8,2.2282e-02_r8,1.8723e-02_r8,1.5191e-02_r8,1.1604e-02_r8, &
     &7.9478e-03_r8,4.2092e-03_r8,4.5107e-04_r8/)
      kao(:, 5, 8, 6) = (/ &
     &2.9965e-02_r8,2.6334e-02_r8,2.2760e-02_r8,1.9185e-02_r8,1.5605e-02_r8,1.1940e-02_r8, &
     &8.2260e-03_r8,4.4031e-03_r8,6.3668e-04_r8/)
      kao(:, 1, 9, 6) = (/ &
     &1.0333e-01_r8,9.0409e-02_r8,7.7506e-02_r8,6.4597e-02_r8,5.1717e-02_r8,3.8817e-02_r8, &
     &2.5905e-02_r8,1.3064e-02_r8,2.4712e-04_r8/)
      kao(:, 2, 9, 6) = (/ &
     &1.0373e-01_r8,9.0771e-02_r8,7.7825e-02_r8,6.4896e-02_r8,5.1961e-02_r8,3.9016e-02_r8, &
     &2.6085e-02_r8,1.3262e-02_r8,3.3832e-04_r8/)
      kao(:, 3, 9, 6) = (/ &
     &1.0493e-01_r8,9.1818e-02_r8,7.8786e-02_r8,6.5718e-02_r8,5.2648e-02_r8,3.9574e-02_r8, &
     &2.6569e-02_r8,1.3576e-02_r8,4.4601e-04_r8/)
      kao(:, 4, 9, 6) = (/ &
     &1.0587e-01_r8,9.2691e-02_r8,7.9566e-02_r8,6.6407e-02_r8,5.3246e-02_r8,4.0117e-02_r8, &
     &2.7043e-02_r8,1.3891e-02_r8,5.4826e-04_r8/)
      kao(:, 5, 9, 6) = (/ &
     &1.0759e-01_r8,9.4255e-02_r8,8.0925e-02_r8,6.7610e-02_r8,5.4300e-02_r8,4.1036e-02_r8, &
     &2.7792e-02_r8,1.4265e-02_r8,6.4886e-04_r8/)
      kao(:, 1,10, 6) = (/ &
     &3.9062e-01_r8,3.4177e-01_r8,2.9293e-01_r8,2.4412e-01_r8,1.9530e-01_r8,1.4643e-01_r8, &
     &9.7639e-02_r8,4.8848e-02_r8,1.4547e-04_r8/)
      kao(:, 2,10, 6) = (/ &
     &3.9313e-01_r8,3.4397e-01_r8,2.9486e-01_r8,2.4569e-01_r8,1.9653e-01_r8,1.4745e-01_r8, &
     &9.8352e-02_r8,4.9236e-02_r8,2.6944e-04_r8/)
      kao(:, 3,10, 6) = (/ &
     &3.9636e-01_r8,3.4679e-01_r8,2.9726e-01_r8,2.4770e-01_r8,1.9822e-01_r8,1.4872e-01_r8, &
     &9.9231e-02_r8,4.9728e-02_r8,4.9543e-04_r8/)
      kao(:, 4,10, 6) = (/ &
     &4.0190e-01_r8,3.5169e-01_r8,3.0137e-01_r8,2.5124e-01_r8,2.0112e-01_r8,1.5095e-01_r8, &
     &1.0079e-01_r8,5.0721e-02_r8,7.4715e-04_r8/)
      kao(:, 5,10, 6) = (/ &
     &4.1118e-01_r8,3.5981e-01_r8,3.0844e-01_r8,2.5722e-01_r8,2.0591e-01_r8,1.5462e-01_r8, &
     &1.0334e-01_r8,5.2226e-02_r8,1.0737e-03_r8/)
      kao(:, 1,11, 6) = (/ &
     &5.2843e-01_r8,4.6229e-01_r8,3.9627e-01_r8,3.3017e-01_r8,2.6411e-01_r8,1.9813e-01_r8, &
     &1.3214e-01_r8,6.6158e-02_r8,1.5345e-04_r8/)
      kao(:, 2,11, 6) = (/ &
     &5.2350e-01_r8,4.5807e-01_r8,3.9260e-01_r8,3.2718e-01_r8,2.6177e-01_r8,1.9641e-01_r8, &
     &1.3106e-01_r8,6.5668e-02_r8,2.3814e-04_r8/)
      kao(:, 3,11, 6) = (/ &
     &5.2048e-01_r8,4.5536e-01_r8,3.9029e-01_r8,3.2525e-01_r8,2.6032e-01_r8,1.9539e-01_r8, &
     &1.3041e-01_r8,6.5403e-02_r8,4.8642e-04_r8/)
      kao(:, 4,11, 6) = (/ &
     &5.2442e-01_r8,4.5878e-01_r8,3.9329e-01_r8,3.2791e-01_r8,2.6245e-01_r8,1.9699e-01_r8, &
     &1.3158e-01_r8,6.6140e-02_r8,7.7713e-04_r8/)
      kao(:, 5,11, 6) = (/ &
     &5.3645e-01_r8,4.6936e-01_r8,4.0243e-01_r8,3.3557e-01_r8,2.6862e-01_r8,2.0159e-01_r8, &
     &1.3470e-01_r8,6.7828e-02_r8,1.0827e-03_r8/)
      kao(:, 1,12, 6) = (/ &
     &5.9047e-01_r8,5.1664e-01_r8,4.4278e-01_r8,3.6903e-01_r8,2.9521e-01_r8,2.2135e-01_r8, &
     &1.4776e-01_r8,7.3993e-02_r8,1.4236e-04_r8/)
      kao(:, 2,12, 6) = (/ &
     &5.8585e-01_r8,5.1270e-01_r8,4.3944e-01_r8,3.6623e-01_r8,2.9300e-01_r8,2.1996e-01_r8, &
     &1.4676e-01_r8,7.3476e-02_r8,2.2023e-04_r8/)
      kao(:, 3,12, 6) = (/ &
     &5.7367e-01_r8,5.0194e-01_r8,4.3031e-01_r8,3.5876e-01_r8,2.8718e-01_r8,2.1559e-01_r8, &
     &1.4380e-01_r8,7.2153e-02_r8,4.4743e-04_r8/)
      kao(:, 4,12, 6) = (/ &
     &5.7511e-01_r8,5.0312e-01_r8,4.3146e-01_r8,3.5985e-01_r8,2.8795e-01_r8,2.1609e-01_r8, &
     &1.4436e-01_r8,7.2515e-02_r8,8.0036e-04_r8/)
      kao(:, 5,12, 6) = (/ &
     &5.8792e-01_r8,5.1441e-01_r8,4.4120e-01_r8,3.6789e-01_r8,2.9440e-01_r8,2.2104e-01_r8, &
     &1.4769e-01_r8,7.4288e-02_r8,1.0818e-03_r8/)
      kao(:, 1,13, 6) = (/ &
     &5.2587e-01_r8,4.6012e-01_r8,3.9434e-01_r8,3.2864e-01_r8,2.6295e-01_r8,1.9729e-01_r8, &
     &1.3161e-01_r8,6.5880e-02_r8,1.1855e-04_r8/)
      kao(:, 2,13, 6) = (/ &
     &5.1655e-01_r8,4.5203e-01_r8,3.8739e-01_r8,3.2291e-01_r8,2.5848e-01_r8,1.9395e-01_r8, &
     &1.2940e-01_r8,6.4811e-02_r8,1.8738e-04_r8/)
      kao(:, 3,13, 6) = (/ &
     &5.1454e-01_r8,4.5033e-01_r8,3.8607e-01_r8,3.2190e-01_r8,2.5767e-01_r8,1.9330e-01_r8, &
     &1.2903e-01_r8,6.4719e-02_r8,4.6442e-04_r8/)
      kao(:, 4,13, 6) = (/ &
     &5.2306e-01_r8,4.5763e-01_r8,3.9250e-01_r8,3.2722e-01_r8,2.6190e-01_r8,1.9661e-01_r8, &
     &1.3127e-01_r8,6.5873e-02_r8,7.3146e-04_r8/)
      kao(:, 5,13, 6) = (/ &
     &5.3732e-01_r8,4.7035e-01_r8,4.0337e-01_r8,3.3620e-01_r8,2.6904e-01_r8,2.0206e-01_r8, &
     &1.3501e-01_r8,6.8074e-02_r8,1.0136e-03_r8/)
      kao(:, 1, 1, 7) = (/ &
     &1.2103e-03_r8,1.2175e-03_r8,1.1935e-03_r8,1.1549e-03_r8,1.0791e-03_r8,9.5598e-04_r8, &
     &8.1255e-04_r8,6.1193e-04_r8,6.2180e-04_r8/)
      kao(:, 2, 1, 7) = (/ &
     &1.2178e-03_r8,1.2781e-03_r8,1.2880e-03_r8,1.2578e-03_r8,1.2013e-03_r8,1.0898e-03_r8, &
     &9.4696e-04_r8,8.3333e-04_r8,8.1545e-04_r8/)
      kao(:, 3, 1, 7) = (/ &
     &1.2282e-03_r8,1.3405e-03_r8,1.3881e-03_r8,1.3716e-03_r8,1.3394e-03_r8,1.2381e-03_r8, &
     &1.1125e-03_r8,1.0711e-03_r8,1.0876e-03_r8/)
      kao(:, 4, 1, 7) = (/ &
     &1.2403e-03_r8,1.4084e-03_r8,1.4922e-03_r8,1.5029e-03_r8,1.4913e-03_r8,1.4226e-03_r8, &
     &1.3116e-03_r8,1.3637e-03_r8,1.4095e-03_r8/)
      kao(:, 5, 1, 7) = (/ &
     &1.2587e-03_r8,1.4782e-03_r8,1.5894e-03_r8,1.6533e-03_r8,1.6739e-03_r8,1.6196e-03_r8, &
     &1.5433e-03_r8,1.7053e-03_r8,1.8020e-03_r8/)
      kao(:, 1, 2, 7) = (/ &
     &1.5958e-03_r8,1.5396e-03_r8,1.4781e-03_r8,1.3976e-03_r8,1.2942e-03_r8,1.1273e-03_r8, &
     &9.3307e-04_r8,7.0021e-04_r8,6.0904e-04_r8/)
      kao(:, 2, 2, 7) = (/ &
     &1.6176e-03_r8,1.6176e-03_r8,1.5750e-03_r8,1.5193e-03_r8,1.4296e-03_r8,1.2725e-03_r8, &
     &1.0674e-03_r8,8.4851e-04_r8,7.7411e-04_r8/)
      kao(:, 3, 2, 7) = (/ &
     &1.6471e-03_r8,1.6851e-03_r8,1.6807e-03_r8,1.6583e-03_r8,1.5791e-03_r8,1.4314e-03_r8, &
     &1.2293e-03_r8,1.0317e-03_r8,9.9584e-04_r8/)
      kao(:, 4, 2, 7) = (/ &
     &1.6650e-03_r8,1.7627e-03_r8,1.7970e-03_r8,1.8046e-03_r8,1.7334e-03_r8,1.6113e-03_r8, &
     &1.4228e-03_r8,1.2451e-03_r8,1.2394e-03_r8/)
      kao(:, 5, 2, 7) = (/ &
     &1.7122e-03_r8,1.8558e-03_r8,1.9287e-03_r8,1.9533e-03_r8,1.9037e-03_r8,1.8293e-03_r8, &
     &1.6473e-03_r8,1.5087e-03_r8,1.5795e-03_r8/)
      kao(:, 1, 3, 7) = (/ &
     &2.9351e-03_r8,2.6534e-03_r8,2.4324e-03_r8,2.1954e-03_r8,1.9158e-03_r8,1.6076e-03_r8, &
     &1.2520e-03_r8,8.5789e-04_r8,6.1375e-04_r8/)
      kao(:, 2, 3, 7) = (/ &
     &2.9633e-03_r8,2.7281e-03_r8,2.5348e-03_r8,2.3132e-03_r8,2.0567e-03_r8,1.7614e-03_r8, &
     &1.4143e-03_r8,9.9890e-04_r8,7.9742e-04_r8/)
      kao(:, 3, 3, 7) = (/ &
     &3.0018e-03_r8,2.8266e-03_r8,2.6658e-03_r8,2.4521e-03_r8,2.2182e-03_r8,1.9505e-03_r8, &
     &1.5883e-03_r8,1.1664e-03_r8,9.9661e-04_r8/)
      kao(:, 4, 3, 7) = (/ &
     &3.0730e-03_r8,2.9520e-03_r8,2.8043e-03_r8,2.6204e-03_r8,2.4182e-03_r8,2.1521e-03_r8, &
     &1.7967e-03_r8,1.3650e-03_r8,1.2315e-03_r8/)
      kao(:, 5, 3, 7) = (/ &
     &3.1816e-03_r8,3.1107e-03_r8,2.9552e-03_r8,2.8080e-03_r8,2.6346e-03_r8,2.3544e-03_r8, &
     &2.0373e-03_r8,1.6039e-03_r8,1.5090e-03_r8/)
      kao(:, 1, 4, 7) = (/ &
     &5.7269e-03_r8,5.0918e-03_r8,4.4466e-03_r8,3.8641e-03_r8,3.2580e-03_r8,2.6083e-03_r8, &
     &1.8965e-03_r8,1.1416e-03_r8,5.7204e-04_r8/)
      kao(:, 2, 4, 7) = (/ &
     &5.7492e-03_r8,5.1587e-03_r8,4.5741e-03_r8,4.0239e-03_r8,3.4230e-03_r8,2.7638e-03_r8, &
     &2.0485e-03_r8,1.2804e-03_r8,7.6092e-04_r8/)
      kao(:, 3, 4, 7) = (/ &
     &5.8525e-03_r8,5.2748e-03_r8,4.7562e-03_r8,4.2073e-03_r8,3.6092e-03_r8,2.9384e-03_r8, &
     &2.2265e-03_r8,1.4580e-03_r8,9.9771e-04_r8/)
      kao(:, 4, 4, 7) = (/ &
     &5.9797e-03_r8,5.4326e-03_r8,4.9495e-03_r8,4.4248e-03_r8,3.8014e-03_r8,3.1433e-03_r8, &
     &2.4307e-03_r8,1.6612e-03_r8,1.3149e-03_r8/)
      kao(:, 5, 4, 7) = (/ &
     &6.1647e-03_r8,5.6540e-03_r8,5.1948e-03_r8,4.6848e-03_r8,4.0444e-03_r8,3.3860e-03_r8, &
     &2.6695e-03_r8,1.9106e-03_r8,1.6620e-03_r8/)
      kao(:, 1, 5, 7) = (/ &
     &1.0220e-02_r8,9.0008e-03_r8,7.7868e-03_r8,6.5817e-03_r8,5.4248e-03_r8,4.2290e-03_r8, &
     &3.0009e-03_r8,1.6787e-03_r8,5.3957e-04_r8/)
      kao(:, 2, 5, 7) = (/ &
     &1.0367e-02_r8,9.1668e-03_r8,7.9693e-03_r8,6.7850e-03_r8,5.6408e-03_r8,4.4280e-03_r8, &
     &3.1863e-03_r8,1.8183e-03_r8,7.0339e-04_r8/)
      kao(:, 3, 5, 7) = (/ &
     &1.0581e-02_r8,9.4102e-03_r8,8.2049e-03_r8,7.0786e-03_r8,5.9001e-03_r8,4.6839e-03_r8, &
     &3.3914e-03_r8,1.9878e-03_r8,9.2591e-04_r8/)
      kao(:, 4, 5, 7) = (/ &
     &1.0809e-02_r8,9.6775e-03_r8,8.5132e-03_r8,7.3701e-03_r8,6.2042e-03_r8,4.9938e-03_r8, &
     &3.6238e-03_r8,2.1871e-03_r8,1.1943e-03_r8/)
      kao(:, 5, 5, 7) = (/ &
     &1.1112e-02_r8,1.0026e-02_r8,8.9250e-03_r8,7.7808e-03_r8,6.5932e-03_r8,5.3151e-03_r8, &
     &3.9019e-03_r8,2.4156e-03_r8,1.5529e-03_r8/)
      kao(:, 1, 6, 7) = (/ &
     &1.6720e-02_r8,1.4665e-02_r8,1.2615e-02_r8,1.0575e-02_r8,8.5627e-03_r8,6.5744e-03_r8, &
     &4.5286e-03_r8,2.4830e-03_r8,5.6458e-04_r8/)
      kao(:, 2, 6, 7) = (/ &
     &1.7104e-02_r8,1.5034e-02_r8,1.2975e-02_r8,1.0925e-02_r8,8.9009e-03_r8,6.8822e-03_r8, &
     &4.7999e-03_r8,2.6619e-03_r8,7.2679e-04_r8/)
      kao(:, 3, 6, 7) = (/ &
     &1.7534e-02_r8,1.5438e-02_r8,1.3395e-02_r8,1.1323e-02_r8,9.3166e-03_r8,7.2349e-03_r8, &
     &5.0972e-03_r8,2.8734e-03_r8,9.0147e-04_r8/)
      kao(:, 4, 6, 7) = (/ &
     &1.8091e-02_r8,1.6011e-02_r8,1.3940e-02_r8,1.1869e-02_r8,9.7728e-03_r8,7.6440e-03_r8, &
     &5.4515e-03_r8,3.0818e-03_r8,1.1288e-03_r8/)
      kao(:, 5, 6, 7) = (/ &
     &1.8583e-02_r8,1.6530e-02_r8,1.4432e-02_r8,1.2438e-02_r8,1.0309e-02_r8,8.1409e-03_r8, &
     &5.8462e-03_r8,3.3346e-03_r8,1.4293e-03_r8/)
      kao(:, 1, 7, 7) = (/ &
     &2.7982e-02_r8,2.4501e-02_r8,2.1043e-02_r8,1.7577e-02_r8,1.4110e-02_r8,1.0697e-02_r8, &
     &7.3114e-03_r8,3.8393e-03_r8,5.1721e-04_r8/)
      kao(:, 2, 7, 7) = (/ &
     &2.8730e-02_r8,2.5189e-02_r8,2.1653e-02_r8,1.8120e-02_r8,1.4619e-02_r8,1.1160e-02_r8, &
     &7.6475e-03_r8,4.0900e-03_r8,6.8268e-04_r8/)
      kao(:, 3, 7, 7) = (/ &
     &2.9602e-02_r8,2.5984e-02_r8,2.2367e-02_r8,1.8790e-02_r8,1.5226e-02_r8,1.1688e-02_r8, &
     &8.0684e-03_r8,4.3672e-03_r8,8.7865e-04_r8/)
      kao(:, 4, 7, 7) = (/ &
     &3.0383e-02_r8,2.6722e-02_r8,2.3100e-02_r8,1.9474e-02_r8,1.5890e-02_r8,1.2270e-02_r8, &
     &8.5486e-03_r8,4.6828e-03_r8,1.1058e-03_r8/)
      kao(:, 5, 7, 7) = (/ &
     &3.1027e-02_r8,2.7319e-02_r8,2.3722e-02_r8,2.0052e-02_r8,1.6464e-02_r8,1.2803e-02_r8, &
     &9.0257e-03_r8,5.0413e-03_r8,1.3701e-03_r8/)
      kao(:, 1, 8, 7) = (/ &
     &5.4825e-02_r8,4.7970e-02_r8,4.1147e-02_r8,3.4322e-02_r8,2.7487e-02_r8,2.0656e-02_r8, &
     &1.3854e-02_r8,7.1281e-03_r8,4.3340e-04_r8/)
      kao(:, 2, 8, 7) = (/ &
     &5.6231e-02_r8,4.9217e-02_r8,4.2253e-02_r8,3.5263e-02_r8,2.8269e-02_r8,2.1292e-02_r8, &
     &1.4434e-02_r8,7.4660e-03_r8,6.0870e-04_r8/)
      kao(:, 3, 8, 7) = (/ &
     &5.7926e-02_r8,5.0738e-02_r8,4.3579e-02_r8,3.6411e-02_r8,2.9254e-02_r8,2.2161e-02_r8, &
     &1.5102e-02_r8,7.9134e-03_r8,8.5563e-04_r8/)
      kao(:, 4, 8, 7) = (/ &
     &5.9329e-02_r8,5.2017e-02_r8,4.4709e-02_r8,3.7445e-02_r8,3.0174e-02_r8,2.2939e-02_r8, &
     &1.5732e-02_r8,8.3409e-03_r8,1.1069e-03_r8/)
      kao(:, 5, 8, 7) = (/ &
     &6.0706e-02_r8,5.3284e-02_r8,4.5885e-02_r8,3.8526e-02_r8,3.1172e-02_r8,2.3870e-02_r8, &
     &1.6429e-02_r8,8.7694e-03_r8,1.3835e-03_r8/)
      kao(:, 1, 9, 7) = (/ &
     &2.0429e-01_r8,1.7875e-01_r8,1.5322e-01_r8,1.2768e-01_r8,1.0216e-01_r8,7.6684e-02_r8, &
     &5.1143e-02_r8,2.5629e-02_r8,2.9263e-04_r8/)
      kao(:, 2, 9, 7) = (/ &
     &2.0990e-01_r8,1.8367e-01_r8,1.5743e-01_r8,1.3122e-01_r8,1.0506e-01_r8,7.8849e-02_r8, &
     &5.2652e-02_r8,2.6459e-02_r8,5.6921e-04_r8/)
      kao(:, 3, 9, 7) = (/ &
     &2.1338e-01_r8,1.8672e-01_r8,1.6006e-01_r8,1.3349e-01_r8,1.0689e-01_r8,8.0285e-02_r8, &
     &5.3664e-02_r8,2.7200e-02_r8,9.3758e-04_r8/)
      kao(:, 4, 9, 7) = (/ &
     &2.2002e-01_r8,1.9252e-01_r8,1.6512e-01_r8,1.3776e-01_r8,1.1035e-01_r8,8.2930e-02_r8, &
     &5.5562e-02_r8,2.8342e-02_r8,1.3055e-03_r8/)
      kao(:, 5, 9, 7) = (/ &
     &2.2506e-01_r8,1.9692e-01_r8,1.6901e-01_r8,1.4099e-01_r8,1.1303e-01_r8,8.5078e-02_r8, &
     &5.7190e-02_r8,2.9461e-02_r8,1.8874e-03_r8/)
      kao(:, 1,10, 7) = (/ &
     &8.3776e-01_r8,7.3310e-01_r8,6.2841e-01_r8,5.2361e-01_r8,4.1890e-01_r8,3.1415e-01_r8, &
     &2.0945e-01_r8,1.0479e-01_r8,1.9258e-04_r8/)
      kao(:, 2,10, 7) = (/ &
     &8.5667e-01_r8,7.4964e-01_r8,6.4250e-01_r8,5.3547e-01_r8,4.2837e-01_r8,3.2129e-01_r8, &
     &2.1421e-01_r8,1.0723e-01_r8,3.0052e-04_r8/)
      kao(:, 3,10, 7) = (/ &
     &8.7378e-01_r8,7.6452e-01_r8,6.5535e-01_r8,5.4608e-01_r8,4.3691e-01_r8,3.2776e-01_r8, &
     &2.1870e-01_r8,1.0952e-01_r8,5.4766e-04_r8/)
      kao(:, 4,10, 7) = (/ &
     &8.9911e-01_r8,7.8666e-01_r8,6.7423e-01_r8,5.6186e-01_r8,4.4961e-01_r8,3.3744e-01_r8, &
     &2.2515e-01_r8,1.1291e-01_r8,1.0571e-03_r8/)
      kao(:, 5,10, 7) = (/ &
     &9.2543e-01_r8,8.0983e-01_r8,6.9418e-01_r8,5.7864e-01_r8,4.6314e-01_r8,3.4767e-01_r8, &
     &2.3212e-01_r8,1.1658e-01_r8,1.4779e-03_r8/)
      kao(:, 1,11, 7) = (/ &
     &1.1170e+00_r8,9.7735e-01_r8,8.3780e-01_r8,6.9827e-01_r8,5.5860e-01_r8,4.1894e-01_r8, &
     &2.7927e-01_r8,1.3969e-01_r8,1.8784e-04_r8/)
      kao(:, 2,11, 7) = (/ &
     &1.1469e+00_r8,1.0035e+00_r8,8.6021e-01_r8,7.1681e-01_r8,5.7347e-01_r8,4.3009e-01_r8, &
     &2.8675e-01_r8,1.4352e-01_r8,2.9142e-04_r8/)
      kao(:, 3,11, 7) = (/ &
     &1.1926e+00_r8,1.0436e+00_r8,8.9439e-01_r8,7.4544e-01_r8,5.9622e-01_r8,4.4725e-01_r8, &
     &2.9836e-01_r8,1.4934e-01_r8,4.5203e-04_r8/)
      kao(:, 4,11, 7) = (/ &
     &1.2362e+00_r8,1.0816e+00_r8,9.2703e-01_r8,7.7246e-01_r8,6.1814e-01_r8,4.6378e-01_r8, &
     &3.0936e-01_r8,1.5503e-01_r8,7.8924e-04_r8/)
      kao(:, 5,11, 7) = (/ &
     &1.2847e+00_r8,1.1241e+00_r8,9.6352e-01_r8,8.0300e-01_r8,6.4259e-01_r8,4.8242e-01_r8, &
     &3.2196e-01_r8,1.6156e-01_r8,1.3839e-03_r8/)
      kao(:, 1,12, 7) = (/ &
     &1.0784e+00_r8,9.4374e-01_r8,8.0896e-01_r8,6.7399e-01_r8,5.3931e-01_r8,4.0450e-01_r8, &
     &2.6958e-01_r8,1.3485e-01_r8,1.8250e-04_r8/)
      kao(:, 2,12, 7) = (/ &
     &1.1016e+00_r8,9.6383e-01_r8,8.2624e-01_r8,6.8848e-01_r8,5.5081e-01_r8,4.1305e-01_r8, &
     &2.7543e-01_r8,1.3793e-01_r8,2.7118e-04_r8/)
      kao(:, 3,12, 7) = (/ &
     &1.1494e+00_r8,1.0057e+00_r8,8.6213e-01_r8,7.1839e-01_r8,5.7458e-01_r8,4.3099e-01_r8, &
     &2.8756e-01_r8,1.4395e-01_r8,4.0903e-04_r8/)
      kao(:, 4,12, 7) = (/ &
     &1.1966e+00_r8,1.0468e+00_r8,8.9727e-01_r8,7.4760e-01_r8,5.9830e-01_r8,4.4892e-01_r8, &
     &2.9949e-01_r8,1.5008e-01_r8,6.0710e-04_r8/)
      kao(:, 5,12, 7) = (/ &
     &1.2391e+00_r8,1.0842e+00_r8,9.2930e-01_r8,7.7450e-01_r8,6.1988e-01_r8,4.6531e-01_r8, &
     &3.1051e-01_r8,1.5585e-01_r8,1.1075e-03_r8/)
      kao(:, 1,13, 7) = (/ &
     &9.1609e-01_r8,8.0170e-01_r8,6.8730e-01_r8,5.7285e-01_r8,4.5825e-01_r8,3.4365e-01_r8, &
     &2.2921e-01_r8,1.1478e-01_r8,1.8534e-04_r8/)
      kao(:, 2,13, 7) = (/ &
     &9.2338e-01_r8,8.0782e-01_r8,6.9263e-01_r8,5.7718e-01_r8,4.6175e-01_r8,3.4635e-01_r8, &
     &2.3110e-01_r8,1.1575e-01_r8,2.6985e-04_r8/)
      kao(:, 3,13, 7) = (/ &
     &9.4678e-01_r8,8.2823e-01_r8,7.0984e-01_r8,5.9160e-01_r8,4.7336e-01_r8,3.5526e-01_r8, &
     &2.3691e-01_r8,1.1874e-01_r8,3.9189e-04_r8/)
      kao(:, 4,13, 7) = (/ &
     &9.5798e-01_r8,8.3839e-01_r8,7.1856e-01_r8,5.9888e-01_r8,4.7933e-01_r8,3.5969e-01_r8, &
     &2.4009e-01_r8,1.2046e-01_r8,6.8070e-04_r8/)
      kao(:, 5,13, 7) = (/ &
     &9.7420e-01_r8,8.5221e-01_r8,7.3072e-01_r8,6.0920e-01_r8,4.8778e-01_r8,3.6616e-01_r8, &
     &2.4455e-01_r8,1.2274e-01_r8,1.2004e-03_r8/)
      kao(:, 1, 1, 8) = (/ &
     &2.2086e-03_r8,2.0999e-03_r8,2.0159e-03_r8,1.8719e-03_r8,1.7233e-03_r8,1.5637e-03_r8, &
     &1.3735e-03_r8,1.3147e-03_r8,1.3769e-03_r8/)
      kao(:, 2, 1, 8) = (/ &
     &2.2485e-03_r8,2.2158e-03_r8,2.1547e-03_r8,2.0369e-03_r8,1.8898e-03_r8,1.7374e-03_r8, &
     &1.6006e-03_r8,1.7014e-03_r8,1.7807e-03_r8/)
      kao(:, 3, 1, 8) = (/ &
     &2.2803e-03_r8,2.3414e-03_r8,2.2949e-03_r8,2.2265e-03_r8,2.0601e-03_r8,1.9356e-03_r8, &
     &1.8992e-03_r8,2.1518e-03_r8,2.2509e-03_r8/)
      kao(:, 4, 1, 8) = (/ &
     &2.3178e-03_r8,2.4462e-03_r8,2.4702e-03_r8,2.4013e-03_r8,2.2630e-03_r8,2.1680e-03_r8, &
     &2.2995e-03_r8,2.6824e-03_r8,2.8243e-03_r8/)
      kao(:, 5, 1, 8) = (/ &
     &2.3355e-03_r8,2.5902e-03_r8,2.6514e-03_r8,2.5825e-03_r8,2.4802e-03_r8,2.5028e-03_r8, &
     &2.7971e-03_r8,3.2930e-03_r8,3.4957e-03_r8/)
      kao(:, 1, 2, 8) = (/ &
     &3.2554e-03_r8,3.0029e-03_r8,2.8238e-03_r8,2.5475e-03_r8,2.2552e-03_r8,1.9853e-03_r8, &
     &1.6584e-03_r8,1.2784e-03_r8,1.0936e-03_r8/)
      kao(:, 2, 2, 8) = (/ &
     &3.3021e-03_r8,3.1146e-03_r8,2.9858e-03_r8,2.7302e-03_r8,2.4455e-03_r8,2.1856e-03_r8, &
     &1.8782e-03_r8,1.5376e-03_r8,1.5050e-03_r8/)
      kao(:, 3, 2, 8) = (/ &
     &3.3434e-03_r8,3.2633e-03_r8,3.1581e-03_r8,2.9235e-03_r8,2.6724e-03_r8,2.4236e-03_r8, &
     &2.1164e-03_r8,1.8700e-03_r8,1.9615e-03_r8/)
      kao(:, 4, 2, 8) = (/ &
     &3.3924e-03_r8,3.4464e-03_r8,3.3467e-03_r8,3.1420e-03_r8,2.9417e-03_r8,2.6854e-03_r8, &
     &2.3908e-03_r8,2.2943e-03_r8,2.5456e-03_r8/)
      kao(:, 5, 2, 8) = (/ &
     &3.4124e-03_r8,3.5941e-03_r8,3.5577e-03_r8,3.4139e-03_r8,3.2366e-03_r8,2.9618e-03_r8, &
     &2.7452e-03_r8,2.8336e-03_r8,3.1731e-03_r8/)
      kao(:, 1, 3, 8) = (/ &
     &6.2310e-03_r8,5.6159e-03_r8,4.9769e-03_r8,4.4245e-03_r8,3.8289e-03_r8,3.1465e-03_r8, &
     &2.4651e-03_r8,1.6762e-03_r8,1.0171e-03_r8/)
      kao(:, 2, 3, 8) = (/ &
     &6.3558e-03_r8,5.7885e-03_r8,5.2143e-03_r8,4.7067e-03_r8,4.0833e-03_r8,3.4041e-03_r8, &
     &2.6899e-03_r8,1.9219e-03_r8,1.2943e-03_r8/)
      kao(:, 3, 3, 8) = (/ &
     &6.4584e-03_r8,5.9604e-03_r8,5.4819e-03_r8,4.9958e-03_r8,4.3577e-03_r8,3.6662e-03_r8, &
     &2.9872e-03_r8,2.1872e-03_r8,1.6861e-03_r8/)
      kao(:, 4, 3, 8) = (/ &
     &6.6103e-03_r8,6.1684e-03_r8,5.8142e-03_r8,5.2903e-03_r8,4.6437e-03_r8,3.9929e-03_r8, &
     &3.3051e-03_r8,2.4974e-03_r8,2.2070e-03_r8/)
      kao(:, 5, 3, 8) = (/ &
     &6.6588e-03_r8,6.3708e-03_r8,6.1123e-03_r8,5.6154e-03_r8,4.9949e-03_r8,4.3617e-03_r8, &
     &3.6895e-03_r8,2.8582e-03_r8,2.8798e-03_r8/)
      kao(:, 1, 4, 8) = (/ &
     &1.1807e-02_r8,1.0450e-02_r8,9.1344e-03_r8,7.7844e-03_r8,6.5100e-03_r8,5.2593e-03_r8, &
     &3.9218e-03_r8,2.4635e-03_r8,1.1324e-03_r8/)
      kao(:, 2, 4, 8) = (/ &
     &1.2088e-02_r8,1.0775e-02_r8,9.4615e-03_r8,8.1147e-03_r8,6.9001e-03_r8,5.6187e-03_r8, &
     &4.2536e-03_r8,2.7131e-03_r8,1.3848e-03_r8/)
      kao(:, 3, 4, 8) = (/ &
     &1.2276e-02_r8,1.1057e-02_r8,9.7542e-03_r8,8.5429e-03_r8,7.3199e-03_r8,6.0294e-03_r8, &
     &4.5931e-03_r8,3.0093e-03_r8,1.7357e-03_r8/)
      kao(:, 4, 4, 8) = (/ &
     &1.2505e-02_r8,1.1360e-02_r8,1.0130e-02_r8,9.0368e-03_r8,7.7990e-03_r8,6.4476e-03_r8, &
     &5.0000e-03_r8,3.3597e-03_r8,2.0753e-03_r8/)
      kao(:, 5, 4, 8) = (/ &
     &1.2694e-02_r8,1.1662e-02_r8,1.0517e-02_r8,9.4548e-03_r8,8.2827e-03_r8,6.9233e-03_r8, &
     &5.4172e-03_r8,3.7628e-03_r8,2.5678e-03_r8/)
      kao(:, 1, 5, 8) = (/ &
     &2.0656e-02_r8,1.8160e-02_r8,1.5700e-02_r8,1.3242e-02_r8,1.0772e-02_r8,8.3779e-03_r8, &
     &6.0246e-03_r8,3.5524e-03_r8,1.1630e-03_r8/)
      kao(:, 2, 5, 8) = (/ &
     &2.0910e-02_r8,1.8437e-02_r8,1.6005e-02_r8,1.3585e-02_r8,1.1145e-02_r8,8.8221e-03_r8, &
     &6.4062e-03_r8,3.8753e-03_r8,1.4990e-03_r8/)
      kao(:, 3, 5, 8) = (/ &
     &2.1222e-02_r8,1.8787e-02_r8,1.6416e-02_r8,1.3970e-02_r8,1.1606e-02_r8,9.3057e-03_r8, &
     &6.8725e-03_r8,4.2169e-03_r8,1.9100e-03_r8/)
      kao(:, 4, 5, 8) = (/ &
     &2.1675e-02_r8,1.9271e-02_r8,1.6942e-02_r8,1.4504e-02_r8,1.2206e-02_r8,9.8161e-03_r8, &
     &7.3695e-03_r8,4.6216e-03_r8,2.4296e-03_r8/)
      kao(:, 5, 5, 8) = (/ &
     &2.2102e-02_r8,1.9781e-02_r8,1.7441e-02_r8,1.5076e-02_r8,1.2804e-02_r8,1.0400e-02_r8, &
     &7.9027e-03_r8,5.0748e-03_r8,2.9846e-03_r8/)
      kao(:, 1, 6, 8) = (/ &
     &3.4516e-02_r8,3.0236e-02_r8,2.6032e-02_r8,2.1800e-02_r8,1.7574e-02_r8,1.3389e-02_r8, &
     &9.2847e-03_r8,5.1122e-03_r8,1.0508e-03_r8/)
      kao(:, 2, 6, 8) = (/ &
     &3.4800e-02_r8,3.0544e-02_r8,2.6323e-02_r8,2.2117e-02_r8,1.7921e-02_r8,1.3756e-02_r8, &
     &9.6631e-03_r8,5.4342e-03_r8,1.4451e-03_r8/)
      kao(:, 3, 6, 8) = (/ &
     &3.5127e-02_r8,3.0902e-02_r8,2.6702e-02_r8,2.2553e-02_r8,1.8369e-02_r8,1.4212e-02_r8, &
     &1.0118e-02_r8,5.8263e-03_r8,1.8818e-03_r8/)
      kao(:, 4, 6, 8) = (/ &
     &3.5628e-02_r8,3.1400e-02_r8,2.7233e-02_r8,2.3087e-02_r8,1.8895e-02_r8,1.4840e-02_r8, &
     &1.0658e-02_r8,6.2966e-03_r8,2.4028e-03_r8/)
      kao(:, 5, 6, 8) = (/ &
     &3.6414e-02_r8,3.2167e-02_r8,2.8039e-02_r8,2.3770e-02_r8,1.9619e-02_r8,1.5526e-02_r8, &
     &1.1248e-02_r8,6.8040e-03_r8,2.9828e-03_r8/)
      kao(:, 1, 7, 8) = (/ &
     &6.0465e-02_r8,5.2915e-02_r8,4.5423e-02_r8,3.7947e-02_r8,3.0446e-02_r8,2.2948e-02_r8, &
     &1.5515e-02_r8,8.2239e-03_r8,1.0379e-03_r8/)
      kao(:, 2, 7, 8) = (/ &
     &6.0755e-02_r8,5.3175e-02_r8,4.5748e-02_r8,3.8231e-02_r8,3.0723e-02_r8,2.3271e-02_r8, &
     &1.5903e-02_r8,8.5285e-03_r8,1.3797e-03_r8/)
      kao(:, 3, 7, 8) = (/ &
     &6.1398e-02_r8,5.3805e-02_r8,4.6318e-02_r8,3.8793e-02_r8,3.1274e-02_r8,2.3804e-02_r8, &
     &1.6410e-02_r8,8.9355e-03_r8,1.8226e-03_r8/)
      kao(:, 4, 7, 8) = (/ &
     &6.2566e-02_r8,5.4915e-02_r8,4.7291e-02_r8,3.9712e-02_r8,3.2135e-02_r8,2.4531e-02_r8, &
     &1.7075e-02_r8,9.4211e-03_r8,2.3895e-03_r8/)
      kao(:, 5, 7, 8) = (/ &
     &6.4353e-02_r8,5.6526e-02_r8,4.8732e-02_r8,4.1035e-02_r8,3.3303e-02_r8,2.5613e-02_r8, &
     &1.7950e-02_r8,9.9840e-03_r8,2.9275e-03_r8/)
      kao(:, 1, 8, 8) = (/ &
     &1.2368e-01_r8,1.0822e-01_r8,9.2766e-02_r8,7.7347e-02_r8,6.2005e-02_r8,4.6603e-02_r8, &
     &3.1194e-02_r8,1.5883e-02_r8,8.5274e-04_r8/)
      kao(:, 2, 8, 8) = (/ &
     &1.2468e-01_r8,1.0911e-01_r8,9.3546e-02_r8,7.8108e-02_r8,6.2629e-02_r8,4.7130e-02_r8, &
     &3.1595e-02_r8,1.6348e-02_r8,1.3444e-03_r8/)
      kao(:, 3, 8, 8) = (/ &
     &1.2638e-01_r8,1.1058e-01_r8,9.4937e-02_r8,7.9293e-02_r8,6.3607e-02_r8,4.7918e-02_r8, &
     &3.2304e-02_r8,1.6902e-02_r8,1.7616e-03_r8/)
      kao(:, 4, 8, 8) = (/ &
     &1.2969e-01_r8,1.1353e-01_r8,9.7623e-02_r8,8.1508e-02_r8,6.5432e-02_r8,4.9461e-02_r8, &
     &3.3527e-02_r8,1.7620e-02_r8,2.4617e-03_r8/)
      kao(:, 5, 8, 8) = (/ &
     &1.3392e-01_r8,1.1729e-01_r8,1.0082e-01_r8,8.4317e-02_r8,6.7894e-02_r8,5.1430e-02_r8, &
     &3.4991e-02_r8,1.8580e-02_r8,3.1642e-03_r8/)
      kao(:, 1, 9, 8) = (/ &
     &4.6846e-01_r8,4.0990e-01_r8,3.5136e-01_r8,2.9284e-01_r8,2.3423e-01_r8,1.7564e-01_r8, &
     &1.1723e-01_r8,5.8786e-02_r8,4.0030e-04_r8/)
      kao(:, 2, 9, 8) = (/ &
     &4.7406e-01_r8,4.1475e-01_r8,3.5556e-01_r8,2.9624e-01_r8,2.3703e-01_r8,1.7789e-01_r8, &
     &1.1882e-01_r8,5.9622e-02_r8,6.8004e-04_r8/)
      kao(:, 3, 9, 8) = (/ &
     &4.8684e-01_r8,4.2603e-01_r8,3.6514e-01_r8,3.0430e-01_r8,2.4358e-01_r8,1.8292e-01_r8, &
     &1.2220e-01_r8,6.1402e-02_r8,1.0402e-03_r8/)
      kao(:, 4, 9, 8) = (/ &
     &5.0043e-01_r8,4.3778e-01_r8,3.7520e-01_r8,3.1290e-01_r8,2.5060e-01_r8,1.8834e-01_r8, &
     &1.2594e-01_r8,6.3564e-02_r8,1.7944e-03_r8/)
      kao(:, 5, 9, 8) = (/ &
     &5.2090e-01_r8,4.5588e-01_r8,3.9070e-01_r8,3.2594e-01_r8,2.6129e-01_r8,1.9629e-01_r8, &
     &1.3136e-01_r8,6.6645e-02_r8,2.5620e-03_r8/)
      kao(:, 1,10, 8) = (/ &
     &1.9599e+00_r8,1.7147e+00_r8,1.4700e+00_r8,1.2249e+00_r8,9.7999e-01_r8,7.3502e-01_r8, &
     &4.8995e-01_r8,2.4496e-01_r8,4.5019e-04_r8/)
      kao(:, 2,10, 8) = (/ &
     &2.0004e+00_r8,1.7503e+00_r8,1.5003e+00_r8,1.2502e+00_r8,1.0002e+00_r8,7.5004e-01_r8, &
     &5.0013e-01_r8,2.5017e-01_r8,7.7160e-04_r8/)
      kao(:, 3,10, 8) = (/ &
     &2.0706e+00_r8,1.8118e+00_r8,1.5527e+00_r8,1.2941e+00_r8,1.0353e+00_r8,7.7648e-01_r8, &
     &5.1774e-01_r8,2.5926e-01_r8,1.2278e-03_r8/)
      kao(:, 4,10, 8) = (/ &
     &2.1488e+00_r8,1.8803e+00_r8,1.6119e+00_r8,1.3430e+00_r8,1.0744e+00_r8,8.0582e-01_r8, &
     &5.3747e-01_r8,2.6934e-01_r8,1.1252e-03_r8/)
      kao(:, 5,10, 8) = (/ &
     &2.2415e+00_r8,1.9614e+00_r8,1.6811e+00_r8,1.4008e+00_r8,1.1207e+00_r8,8.4068e-01_r8, &
     &5.6107e-01_r8,2.8130e-01_r8,1.6850e-03_r8/)
      kao(:, 1,11, 8) = (/ &
     &2.8911e+00_r8,2.5300e+00_r8,2.1683e+00_r8,1.8069e+00_r8,1.4455e+00_r8,1.0841e+00_r8, &
     &7.2274e-01_r8,3.6133e-01_r8,4.4874e-04_r8/)
      kao(:, 2,11, 8) = (/ &
     &2.9950e+00_r8,2.6205e+00_r8,2.2462e+00_r8,1.8718e+00_r8,1.4974e+00_r8,1.1232e+00_r8, &
     &7.4873e-01_r8,3.7448e-01_r8,7.8243e-04_r8/)
      kao(:, 3,11, 8) = (/ &
     &3.1150e+00_r8,2.7257e+00_r8,2.3363e+00_r8,1.9467e+00_r8,1.5577e+00_r8,1.1681e+00_r8, &
     &7.7884e-01_r8,3.8967e-01_r8,1.2703e-03_r8/)
      kao(:, 4,11, 8) = (/ &
     &3.2669e+00_r8,2.8585e+00_r8,2.4505e+00_r8,2.0417e+00_r8,1.6337e+00_r8,1.2254e+00_r8, &
     &8.1715e-01_r8,4.0914e-01_r8,1.7634e-03_r8/)
      kao(:, 5,11, 8) = (/ &
     &3.4234e+00_r8,2.9957e+00_r8,2.5672e+00_r8,2.1393e+00_r8,1.7114e+00_r8,1.2836e+00_r8, &
     &8.5639e-01_r8,4.2894e-01_r8,1.6787e-03_r8/)
      kao(:, 1,12, 8) = (/ &
     &3.0768e+00_r8,2.6917e+00_r8,2.3070e+00_r8,1.9231e+00_r8,1.5383e+00_r8,1.1537e+00_r8, &
     &7.6915e-01_r8,3.8462e-01_r8,4.7094e-04_r8/)
      kao(:, 2,12, 8) = (/ &
     &3.2435e+00_r8,2.8382e+00_r8,2.4330e+00_r8,2.0274e+00_r8,1.6219e+00_r8,1.2164e+00_r8, &
     &8.1089e-01_r8,4.0548e-01_r8,8.2872e-04_r8/)
      kao(:, 3,12, 8) = (/ &
     &3.4231e+00_r8,2.9954e+00_r8,2.5672e+00_r8,2.1393e+00_r8,1.7115e+00_r8,1.2835e+00_r8, &
     &8.5578e-01_r8,4.2826e-01_r8,1.3467e-03_r8/)
      kao(:, 4,12, 8) = (/ &
     &3.5915e+00_r8,3.1425e+00_r8,2.6940e+00_r8,2.2448e+00_r8,1.7959e+00_r8,1.3469e+00_r8, &
     &8.9804e-01_r8,4.4980e-01_r8,2.0869e-03_r8/)
      kao(:, 5,12, 8) = (/ &
     &3.8078e+00_r8,3.3318e+00_r8,2.8557e+00_r8,2.3795e+00_r8,1.9039e+00_r8,1.4280e+00_r8, &
     &9.5252e-01_r8,4.7712e-01_r8,1.8673e-03_r8/)
      kao(:, 1,13, 8) = (/ &
     &2.3608e+00_r8,2.0656e+00_r8,1.7703e+00_r8,1.4752e+00_r8,1.1801e+00_r8,8.8512e-01_r8, &
     &5.9005e-01_r8,2.9502e-01_r8,4.6667e-04_r8/)
      kao(:, 2,13, 8) = (/ &
     &2.5500e+00_r8,2.2311e+00_r8,1.9119e+00_r8,1.5932e+00_r8,1.2746e+00_r8,9.5617e-01_r8, &
     &6.3722e-01_r8,3.1884e-01_r8,8.1387e-04_r8/)
      kao(:, 3,13, 8) = (/ &
     &2.7068e+00_r8,2.3688e+00_r8,2.0306e+00_r8,1.6919e+00_r8,1.3534e+00_r8,1.0151e+00_r8, &
     &6.7709e-01_r8,3.3887e-01_r8,1.3055e-03_r8/)
      kao(:, 4,13, 8) = (/ &
     &2.8840e+00_r8,2.5234e+00_r8,2.1627e+00_r8,1.8025e+00_r8,1.4417e+00_r8,1.0815e+00_r8, &
     &7.2137e-01_r8,3.6139e-01_r8,1.9116e-03_r8/)
      kao(:, 5,13, 8) = (/ &
     &3.0939e+00_r8,2.7071e+00_r8,2.3203e+00_r8,1.9334e+00_r8,1.5471e+00_r8,1.1606e+00_r8, &
     &7.7438e-01_r8,3.8815e-01_r8,1.4651e-03_r8/)
      kao(:, 1, 1, 9) = (/ &
     &3.8342e-03_r8,3.6037e-03_r8,3.3390e-03_r8,3.1415e-03_r8,3.0062e-03_r8,3.0639e-03_r8, &
     &3.3790e-03_r8,3.9710e-03_r8,4.6693e-03_r8/)
      kao(:, 2, 1, 9) = (/ &
     &3.8099e-03_r8,3.5245e-03_r8,3.4236e-03_r8,3.3696e-03_r8,3.4435e-03_r8,3.7521e-03_r8, &
     &4.3079e-03_r8,5.1949e-03_r8,5.9521e-03_r8/)
      kao(:, 3, 1, 9) = (/ &
     &3.6846e-03_r8,3.4976e-03_r8,3.5740e-03_r8,3.6729e-03_r8,4.0680e-03_r8,4.6302e-03_r8, &
     &5.4360e-03_r8,6.6553e-03_r8,7.4735e-03_r8/)
      kao(:, 4, 1, 9) = (/ &
     &3.5274e-03_r8,3.5376e-03_r8,3.7030e-03_r8,4.1336e-03_r8,4.8513e-03_r8,5.7165e-03_r8, &
     &6.7340e-03_r8,8.3554e-03_r8,9.2181e-03_r8/)
      kao(:, 5, 1, 9) = (/ &
     &3.3692e-03_r8,3.5348e-03_r8,3.9656e-03_r8,4.7179e-03_r8,5.7827e-03_r8,6.9797e-03_r8, &
     &8.2404e-03_r8,1.0337e-02_r8,1.1151e-02_r8/)
      kao(:, 1, 2, 9) = (/ &
     &6.4244e-03_r8,5.9003e-03_r8,5.2917e-03_r8,4.8738e-03_r8,4.2886e-03_r8,3.6979e-03_r8, &
     &3.3432e-03_r8,3.4356e-03_r8,4.2740e-03_r8/)
      kao(:, 2, 2, 9) = (/ &
     &6.4294e-03_r8,5.9365e-03_r8,5.4378e-03_r8,5.0910e-03_r8,4.5359e-03_r8,4.1466e-03_r8, &
     &4.0476e-03_r8,4.4354e-03_r8,5.4215e-03_r8/)
      kao(:, 3, 2, 9) = (/ &
     &6.3847e-03_r8,6.0135e-03_r8,5.5846e-03_r8,5.2573e-03_r8,4.8954e-03_r8,4.7657e-03_r8, &
     &4.9765e-03_r8,5.6368e-03_r8,6.8419e-03_r8/)
      kao(:, 4, 2, 9) = (/ &
     &6.3412e-03_r8,5.9177e-03_r8,5.7222e-03_r8,5.4979e-03_r8,5.4021e-03_r8,5.5794e-03_r8, &
     &6.1113e-03_r8,7.0879e-03_r8,8.4995e-03_r8/)
      kao(:, 5, 2, 9) = (/ &
     &6.1488e-03_r8,5.8853e-03_r8,5.8235e-03_r8,5.8427e-03_r8,6.0130e-03_r8,6.6088e-03_r8, &
     &7.4819e-03_r8,8.8092e-03_r8,1.0289e-02_r8/)
      kao(:, 1, 3, 9) = (/ &
     &1.4195e-02_r8,1.2643e-02_r8,1.1125e-02_r8,9.5338e-03_r8,8.0743e-03_r8,6.7413e-03_r8, &
     &5.1394e-03_r8,3.4808e-03_r8,3.6417e-03_r8/)
      kao(:, 2, 3, 9) = (/ &
     &1.4156e-02_r8,1.2714e-02_r8,1.1322e-02_r8,9.8573e-03_r8,8.5639e-03_r8,7.1930e-03_r8, &
     &5.4628e-03_r8,4.1430e-03_r8,4.8796e-03_r8/)
      kao(:, 3, 3, 9) = (/ &
     &1.4281e-02_r8,1.3014e-02_r8,1.1636e-02_r8,1.0282e-02_r8,9.0638e-03_r8,7.5306e-03_r8, &
     &5.9490e-03_r8,5.0136e-03_r8,6.2613e-03_r8/)
      kao(:, 4, 3, 9) = (/ &
     &1.4318e-02_r8,1.3194e-02_r8,1.1832e-02_r8,1.0698e-02_r8,9.4111e-03_r8,7.9426e-03_r8, &
     &6.6489e-03_r8,6.1359e-03_r8,7.8675e-03_r8/)
      kao(:, 5, 3, 9) = (/ &
     &1.4241e-02_r8,1.3300e-02_r8,1.2028e-02_r8,1.0934e-02_r8,9.7284e-03_r8,8.5621e-03_r8, &
     &7.5356e-03_r8,7.5232e-03_r8,9.7190e-03_r8/)
      kao(:, 1, 4, 9) = (/ &
     &3.1371e-02_r8,2.7594e-02_r8,2.3918e-02_r8,2.0236e-02_r8,1.6538e-02_r8,1.2862e-02_r8, &
     &9.3415e-03_r8,5.6206e-03_r8,3.0136e-03_r8/)
      kao(:, 2, 4, 9) = (/ &
     &3.1367e-02_r8,2.7706e-02_r8,2.4150e-02_r8,2.0624e-02_r8,1.6974e-02_r8,1.3427e-02_r8, &
     &9.9709e-03_r8,6.1282e-03_r8,4.2995e-03_r8/)
      kao(:, 3, 4, 9) = (/ &
     &3.1583e-02_r8,2.8007e-02_r8,2.4625e-02_r8,2.1088e-02_r8,1.7481e-02_r8,1.4076e-02_r8, &
     &1.0648e-02_r8,6.6037e-03_r8,5.6873e-03_r8/)
      kao(:, 4, 4, 9) = (/ &
     &3.1875e-02_r8,2.8446e-02_r8,2.5140e-02_r8,2.1570e-02_r8,1.8204e-02_r8,1.5013e-02_r8, &
     &1.1353e-02_r8,7.2455e-03_r8,7.5289e-03_r8/)
      kao(:, 5, 4, 9) = (/ &
     &3.2159e-02_r8,2.8870e-02_r8,2.5760e-02_r8,2.2306e-02_r8,1.9019e-02_r8,1.5749e-02_r8, &
     &1.1959e-02_r8,8.0455e-03_r8,9.2604e-03_r8/)
      kao(:, 1, 5, 9) = (/ &
     &6.1996e-02_r8,5.4276e-02_r8,4.6766e-02_r8,3.9233e-02_r8,3.1722e-02_r8,2.4192e-02_r8, &
     &1.6676e-02_r8,9.3526e-03_r8,2.3723e-03_r8/)
      kao(:, 2, 5, 9) = (/ &
     &6.2786e-02_r8,5.5036e-02_r8,4.7544e-02_r8,4.0014e-02_r8,3.2500e-02_r8,2.4919e-02_r8, &
     &1.7414e-02_r8,9.9958e-03_r8,3.1775e-03_r8/)
      kao(:, 3, 5, 9) = (/ &
     &6.3408e-02_r8,5.5719e-02_r8,4.8263e-02_r8,4.0805e-02_r8,3.3340e-02_r8,2.5705e-02_r8, &
     &1.8217e-02_r8,1.0807e-02_r8,4.4457e-03_r8/)
      kao(:, 4, 5, 9) = (/ &
     &6.3958e-02_r8,5.6455e-02_r8,4.8967e-02_r8,4.1701e-02_r8,3.4289e-02_r8,2.6801e-02_r8, &
     &1.9500e-02_r8,1.1614e-02_r8,6.0592e-03_r8/)
      kao(:, 5, 5, 9) = (/ &
     &6.4544e-02_r8,5.7091e-02_r8,4.9896e-02_r8,4.2837e-02_r8,3.5365e-02_r8,2.7903e-02_r8, &
     &2.0589e-02_r8,1.2558e-02_r8,7.7840e-03_r8/)
      kao(:, 1, 6, 9) = (/ &
     &1.1420e-01_r8,9.9928e-02_r8,8.5730e-02_r8,7.1669e-02_r8,5.7641e-02_r8,4.3533e-02_r8, &
     &2.9463e-02_r8,1.5596e-02_r8,1.8870e-03_r8/)
      kao(:, 2, 6, 9) = (/ &
     &1.1463e-01_r8,1.0031e-01_r8,8.6249e-02_r8,7.2249e-02_r8,5.8195e-02_r8,4.4132e-02_r8, &
     &3.0125e-02_r8,1.6255e-02_r8,2.7185e-03_r8/)
      kao(:, 3, 6, 9) = (/ &
     &1.1505e-01_r8,1.0074e-01_r8,8.6836e-02_r8,7.2850e-02_r8,5.8886e-02_r8,4.5056e-02_r8, &
     &3.1103e-02_r8,1.7221e-02_r8,3.7627e-03_r8/)
      kao(:, 4, 6, 9) = (/ &
     &1.1693e-01_r8,1.0252e-01_r8,8.8568e-02_r8,7.4567e-02_r8,6.0606e-02_r8,4.6540e-02_r8, &
     &3.2424e-02_r8,1.8275e-02_r8,5.0267e-03_r8/)
      kao(:, 5, 6, 9) = (/ &
     &1.1806e-01_r8,1.0371e-01_r8,8.9817e-02_r8,7.5865e-02_r8,6.1963e-02_r8,4.7866e-02_r8, &
     &3.3695e-02_r8,1.9500e-02_r8,6.8317e-03_r8/)
      kao(:, 1, 7, 9) = (/ &
     &2.1427e-01_r8,1.8749e-01_r8,1.6070e-01_r8,1.3399e-01_r8,1.0738e-01_r8,8.0867e-02_r8, &
     &5.4264e-02_r8,2.7682e-02_r8,1.2395e-03_r8/)
      kao(:, 2, 7, 9) = (/ &
     &2.1459e-01_r8,1.8775e-01_r8,1.6094e-01_r8,1.3438e-01_r8,1.0794e-01_r8,8.1406e-02_r8, &
     &5.4844e-02_r8,2.8427e-02_r8,2.0965e-03_r8/)
      kao(:, 3, 7, 9) = (/ &
     &2.1615e-01_r8,1.8914e-01_r8,1.6231e-01_r8,1.3573e-01_r8,1.0921e-01_r8,8.2571e-02_r8, &
     &5.5952e-02_r8,2.9582e-02_r8,3.1925e-03_r8/)
      kao(:, 4, 7, 9) = (/ &
     &2.1891e-01_r8,1.9155e-01_r8,1.6470e-01_r8,1.3802e-01_r8,1.1113e-01_r8,8.4390e-02_r8, &
     &5.7587e-02_r8,3.0908e-02_r8,4.5715e-03_r8/)
      kao(:, 5, 7, 9) = (/ &
     &2.2155e-01_r8,1.9400e-01_r8,1.6713e-01_r8,1.4027e-01_r8,1.1333e-01_r8,8.6454e-02_r8, &
     &5.9526e-02_r8,3.2445e-02_r8,6.5617e-03_r8/)
      kao(:, 1, 8, 9) = (/ &
     &4.6547e-01_r8,4.0732e-01_r8,3.4911e-01_r8,2.9100e-01_r8,2.3277e-01_r8,1.7470e-01_r8, &
     &1.1672e-01_r8,5.8764e-02_r8,8.5250e-04_r8/)
      kao(:, 2, 8, 9) = (/ &
     &4.6469e-01_r8,4.0659e-01_r8,3.4854e-01_r8,2.9045e-01_r8,2.3244e-01_r8,1.7466e-01_r8, &
     &1.1705e-01_r8,5.9152e-02_r8,1.3360e-03_r8/)
      kao(:, 3, 8, 9) = (/ &
     &4.6927e-01_r8,4.1062e-01_r8,3.5196e-01_r8,2.9346e-01_r8,2.3515e-01_r8,1.7702e-01_r8, &
     &1.1874e-01_r8,6.0462e-02_r8,2.4435e-03_r8/)
      kao(:, 4, 8, 9) = (/ &
     &4.7393e-01_r8,4.1463e-01_r8,3.5541e-01_r8,2.9668e-01_r8,2.3809e-01_r8,1.7953e-01_r8, &
     &1.2082e-01_r8,6.2242e-02_r8,3.3995e-03_r8/)
      kao(:, 5, 8, 9) = (/ &
     &4.8023e-01_r8,4.2020e-01_r8,3.6048e-01_r8,3.0117e-01_r8,2.4212e-01_r8,1.8271e-01_r8, &
     &1.2350e-01_r8,6.4451e-02_r8,5.1655e-03_r8/)
      kao(:, 1, 9, 9) = (/ &
     &1.9039e+00_r8,1.6660e+00_r8,1.4281e+00_r8,1.1899e+00_r8,9.5193e-01_r8,7.1405e-01_r8, &
     &4.7606e-01_r8,2.3807e-01_r8,5.1784e-04_r8/)
      kao(:, 2, 9, 9) = (/ &
     &1.8960e+00_r8,1.6589e+00_r8,1.4220e+00_r8,1.1850e+00_r8,9.4792e-01_r8,7.1098e-01_r8, &
     &4.7399e-01_r8,2.3745e-01_r8,1.0379e-03_r8/)
      kao(:, 3, 9, 9) = (/ &
     &1.8985e+00_r8,1.6610e+00_r8,1.4239e+00_r8,1.1866e+00_r8,9.4922e-01_r8,7.1187e-01_r8, &
     &4.7501e-01_r8,2.3850e-01_r8,1.9956e-03_r8/)
      kao(:, 4, 9, 9) = (/ &
     &1.9331e+00_r8,1.6922e+00_r8,1.4503e+00_r8,1.2084e+00_r8,9.6666e-01_r8,7.2514e-01_r8, &
     &4.8432e-01_r8,2.4379e-01_r8,3.3200e-03_r8/)
      kao(:, 5, 9, 9) = (/ &
     &1.9563e+00_r8,1.7116e+00_r8,1.4675e+00_r8,1.2227e+00_r8,9.7814e-01_r8,7.3426e-01_r8, &
     &4.9112e-01_r8,2.4753e-01_r8,5.3379e-03_r8/)
      kao(:, 1,10, 9) = (/ &
     &8.5901e+00_r8,7.5167e+00_r8,6.4427e+00_r8,5.3701e+00_r8,4.2955e+00_r8,3.2213e+00_r8, &
     &2.1478e+00_r8,1.0738e+00_r8,2.8232e-05_r8/)
      kao(:, 2,10, 9) = (/ &
     &8.5325e+00_r8,7.4671e+00_r8,6.4018e+00_r8,5.3343e+00_r8,4.2664e+00_r8,3.2001e+00_r8, &
     &2.1333e+00_r8,1.0667e+00_r8,3.4266e-05_r8/)
      kao(:, 3,10, 9) = (/ &
     &8.5180e+00_r8,7.4539e+00_r8,6.3892e+00_r8,5.3241e+00_r8,4.2587e+00_r8,3.1944e+00_r8, &
     &2.1293e+00_r8,1.0648e+00_r8,4.9015e-05_r8/)
      kao(:, 4,10, 9) = (/ &
     &8.6373e+00_r8,7.5561e+00_r8,6.4798e+00_r8,5.3988e+00_r8,4.3190e+00_r8,3.2393e+00_r8, &
     &2.1596e+00_r8,1.0801e+00_r8,1.1052e-03_r8/)
      kao(:, 5,10, 9) = (/ &
     &8.7651e+00_r8,7.6691e+00_r8,6.5729e+00_r8,5.4773e+00_r8,4.3830e+00_r8,3.2869e+00_r8, &
     &2.1915e+00_r8,1.0965e+00_r8,2.0612e-03_r8/)
      kao(:, 1,11, 9) = (/ &
     &1.3293e+01_r8,1.1631e+01_r8,9.9694e+00_r8,8.3080e+00_r8,6.6463e+00_r8,4.9848e+00_r8, &
     &3.3235e+00_r8,1.6616e+00_r8,8.6041e-05_r8/)
      kao(:, 2,11, 9) = (/ &
     &1.3175e+01_r8,1.1527e+01_r8,9.8819e+00_r8,8.2359e+00_r8,6.5871e+00_r8,4.9407e+00_r8, &
     &3.2935e+00_r8,1.6469e+00_r8,8.8405e-05_r8/)
      kao(:, 3,11, 9) = (/ &
     &1.3260e+01_r8,1.1601e+01_r8,9.9453e+00_r8,8.2878e+00_r8,6.6300e+00_r8,4.9725e+00_r8, &
     &3.3155e+00_r8,1.6576e+00_r8,7.6661e-05_r8/)
      kao(:, 4,11, 9) = (/ &
     &1.3414e+01_r8,1.1737e+01_r8,1.0061e+01_r8,8.3841e+00_r8,6.7068e+00_r8,5.0294e+00_r8, &
     &3.3528e+00_r8,1.6766e+00_r8,3.1506e-04_r8/)
      kao(:, 5,11, 9) = (/ &
     &1.3624e+01_r8,1.1922e+01_r8,1.0219e+01_r8,8.5160e+00_r8,6.8128e+00_r8,5.1095e+00_r8, &
     &3.4058e+00_r8,1.7038e+00_r8,1.6944e-03_r8/)
      kao(:, 1,12, 9) = (/ &
     &1.4782e+01_r8,1.2935e+01_r8,1.1089e+01_r8,9.2388e+00_r8,7.3920e+00_r8,5.5445e+00_r8, &
     &3.6962e+00_r8,1.8480e+00_r8,1.3867e-04_r8/)
      kao(:, 2,12, 9) = (/ &
     &1.4730e+01_r8,1.2889e+01_r8,1.1047e+01_r8,9.2076e+00_r8,7.3659e+00_r8,5.5246e+00_r8, &
     &3.6830e+00_r8,1.8415e+00_r8,1.5061e-04_r8/)
      kao(:, 3,12, 9) = (/ &
     &1.4865e+01_r8,1.3005e+01_r8,1.1148e+01_r8,9.2913e+00_r8,7.4319e+00_r8,5.5733e+00_r8, &
     &3.7153e+00_r8,1.8580e+00_r8,1.4666e-04_r8/)
      kao(:, 4,12, 9) = (/ &
     &1.5163e+01_r8,1.3269e+01_r8,1.1374e+01_r8,9.4785e+00_r8,7.5816e+00_r8,5.6866e+00_r8, &
     &3.7915e+00_r8,1.8957e+00_r8,1.4926e-04_r8/)
      kao(:, 5,12, 9) = (/ &
     &1.5423e+01_r8,1.3495e+01_r8,1.1567e+01_r8,9.6394e+00_r8,7.7115e+00_r8,5.7838e+00_r8, &
     &3.8558e+00_r8,1.9287e+00_r8,1.8983e-03_r8/)
      kao(:, 1,13, 9) = (/ &
     &1.2526e+01_r8,1.0960e+01_r8,9.3953e+00_r8,7.8295e+00_r8,6.2636e+00_r8,4.6971e+00_r8, &
     &3.1319e+00_r8,1.5656e+00_r8,2.2960e-04_r8/)
      kao(:, 2,13, 9) = (/ &
     &1.2594e+01_r8,1.1020e+01_r8,9.4466e+00_r8,7.8734e+00_r8,6.2977e+00_r8,4.7229e+00_r8, &
     &3.1489e+00_r8,1.5743e+00_r8,3.0250e-04_r8/)
      kao(:, 3,13, 9) = (/ &
     &1.2808e+01_r8,1.1205e+01_r8,9.6060e+00_r8,8.0068e+00_r8,6.4043e+00_r8,4.8030e+00_r8, &
     &3.2030e+00_r8,1.6008e+00_r8,4.1712e-04_r8/)
      kao(:, 4,13, 9) = (/ &
     &1.3107e+01_r8,1.1466e+01_r8,9.8274e+00_r8,8.1873e+00_r8,6.5536e+00_r8,4.9140e+00_r8, &
     &3.2751e+00_r8,1.6381e+00_r8,6.5679e-04_r8/)
      kao(:, 5,13, 9) = (/ &
     &1.3444e+01_r8,1.1761e+01_r8,1.0081e+01_r8,8.4011e+00_r8,6.7204e+00_r8,5.0404e+00_r8, &
     &3.3592e+00_r8,1.6815e+00_r8,2.8416e-03_r8/)
      kao(:, 1, 1,10) = (/ &
     &4.6973e-03_r8,3.3679e-03_r8,3.0810e-03_r8,4.4179e-03_r8,5.3922e-03_r8,6.8127e-03_r8, &
     &7.5300e-03_r8,9.6520e-03_r8,1.0742e-02_r8/)
      kao(:, 2, 1,10) = (/ &
     &3.3940e-03_r8,3.6347e-03_r8,3.8181e-03_r8,5.7069e-03_r8,7.1993e-03_r8,9.1516e-03_r8, &
     &1.0242e-02_r8,1.2914e-02_r8,1.4284e-02_r8/)
      kao(:, 3, 1,10) = (/ &
     &2.9328e-03_r8,3.5249e-03_r8,5.0061e-03_r8,7.3569e-03_r8,8.9474e-03_r8,1.1546e-02_r8, &
     &1.2963e-02_r8,1.7115e-02_r8,1.7551e-02_r8/)
      kao(:, 4, 1,10) = (/ &
     &2.4964e-03_r8,3.6551e-03_r8,6.6228e-03_r8,8.9461e-03_r8,1.0774e-02_r8,1.3965e-02_r8, &
     &1.7435e-02_r8,2.2332e-02_r8,2.1398e-02_r8/)
      kao(:, 5, 1,10) = (/ &
     &2.1304e-03_r8,4.5161e-03_r8,8.4664e-03_r8,1.0811e-02_r8,1.3640e-02_r8,1.7099e-02_r8, &
     &2.2735e-02_r8,2.8461e-02_r8,2.7259e-02_r8/)
      kao(:, 1, 2,10) = (/ &
     &9.4205e-03_r8,8.2881e-03_r8,6.8055e-03_r8,5.1998e-03_r8,6.0003e-03_r8,6.4194e-03_r8, &
     &7.3653e-03_r8,8.1269e-03_r8,1.1868e-02_r8/)
      kao(:, 2, 2,10) = (/ &
     &8.5761e-03_r8,7.3303e-03_r8,5.6742e-03_r8,5.4200e-03_r8,7.5061e-03_r8,8.7164e-03_r8, &
     &9.8614e-03_r8,1.1132e-02_r8,1.4929e-02_r8/)
      kao(:, 3, 2,10) = (/ &
     &7.2342e-03_r8,5.9377e-03_r8,5.5335e-03_r8,7.0973e-03_r8,9.3181e-03_r8,1.1104e-02_r8, &
     &1.2752e-02_r8,1.5333e-02_r8,1.8200e-02_r8/)
      kao(:, 4, 2,10) = (/ &
     &5.3015e-03_r8,5.6105e-03_r8,6.0212e-03_r8,9.3735e-03_r8,1.1344e-02_r8,1.3845e-02_r8, &
     &1.6350e-02_r8,2.0205e-02_r8,2.2040e-02_r8/)
      kao(:, 5, 2,10) = (/ &
     &4.6868e-03_r8,5.1363e-03_r8,7.4969e-03_r8,1.0079e-02_r8,1.4155e-02_r8,1.6850e-02_r8, &
     &1.9756e-02_r8,2.5412e-02_r8,2.7831e-02_r8/)
      kao(:, 1, 3,10) = (/ &
     &2.2659e-02_r8,2.0083e-02_r8,1.7749e-02_r8,1.5132e-02_r8,1.2304e-02_r8,9.8131e-03_r8, &
     &6.5475e-03_r8,7.6061e-03_r8,9.2024e-03_r8/)
      kao(:, 2, 3,10) = (/ &
     &2.3012e-02_r8,2.0379e-02_r8,1.7548e-02_r8,1.4904e-02_r8,1.1694e-02_r8,9.3796e-03_r8, &
     &9.2412e-03_r8,1.0030e-02_r8,1.2744e-02_r8/)
      kao(:, 3, 3,10) = (/ &
     &2.1396e-02_r8,1.8727e-02_r8,1.6107e-02_r8,1.2456e-02_r8,1.0255e-02_r8,1.0536e-02_r8, &
     &1.1966e-02_r8,1.3095e-02_r8,1.7259e-02_r8/)
      kao(:, 4, 3,10) = (/ &
     &1.9331e-02_r8,1.6488e-02_r8,1.2963e-02_r8,1.0270e-02_r8,1.1515e-02_r8,1.2315e-02_r8, &
     &1.5198e-02_r8,1.6672e-02_r8,2.2500e-02_r8/)
      kao(:, 5, 3,10) = (/ &
     &1.6551e-02_r8,1.3344e-02_r8,1.1001e-02_r8,1.0385e-02_r8,1.2450e-02_r8,1.4894e-02_r8, &
     &1.8912e-02_r8,2.0849e-02_r8,2.4782e-02_r8/)
      kao(:, 1, 4,10) = (/ &
     &5.3443e-02_r8,4.6752e-02_r8,4.0212e-02_r8,3.3727e-02_r8,2.6764e-02_r8,2.0366e-02_r8, &
     &1.4100e-02_r8,8.5626e-03_r8,5.0179e-03_r8/)
      kao(:, 2, 4,10) = (/ &
     &5.5520e-02_r8,4.8788e-02_r8,4.2227e-02_r8,3.5776e-02_r8,2.9164e-02_r8,2.2326e-02_r8, &
     &1.5452e-02_r8,9.1701e-03_r8,6.6031e-03_r8/)
      kao(:, 3, 4,10) = (/ &
     &5.3841e-02_r8,4.7471e-02_r8,4.1338e-02_r8,3.5633e-02_r8,2.9297e-02_r8,2.2785e-02_r8, &
     &1.5793e-02_r8,1.1481e-02_r8,9.9885e-03_r8/)
      kao(:, 4, 4,10) = (/ &
     &5.4923e-02_r8,4.8665e-02_r8,4.2046e-02_r8,3.5458e-02_r8,2.8786e-02_r8,2.1135e-02_r8, &
     &1.3946e-02_r8,1.4729e-02_r8,1.3190e-02_r8/)
      kao(:, 5, 4,10) = (/ &
     &5.1650e-02_r8,4.6045e-02_r8,4.0319e-02_r8,3.3252e-02_r8,2.5245e-02_r8,1.9132e-02_r8, &
     &1.5667e-02_r8,1.8634e-02_r8,1.9277e-02_r8/)
      kao(:, 1, 5,10) = (/ &
     &1.1780e-01_r8,1.0308e-01_r8,8.8391e-02_r8,7.4152e-02_r8,5.9704e-02_r8,4.5204e-02_r8, &
     &3.0807e-02_r8,1.6385e-02_r8,4.0089e-03_r8/)
      kao(:, 2, 5,10) = (/ &
     &1.1261e-01_r8,9.8543e-02_r8,8.5059e-02_r8,7.1216e-02_r8,5.7505e-02_r8,4.3649e-02_r8, &
     &3.0528e-02_r8,1.7529e-02_r8,9.3093e-03_r8/)
      kao(:, 3, 5,10) = (/ &
     &1.1400e-01_r8,9.9742e-02_r8,8.6449e-02_r8,7.3042e-02_r8,5.9615e-02_r8,4.6638e-02_r8, &
     &3.2532e-02_r8,1.8567e-02_r8,1.1184e-02_r8/)
      kao(:, 4, 5,10) = (/ &
     &1.1613e-01_r8,1.0163e-01_r8,8.9121e-02_r8,7.4876e-02_r8,6.0453e-02_r8,4.6196e-02_r8, &
     &3.1216e-02_r8,1.9048e-02_r8,1.2339e-02_r8/)
      kao(:, 5, 5,10) = (/ &
     &1.2016e-01_r8,1.0608e-01_r8,9.2375e-02_r8,7.6465e-02_r8,6.2248e-02_r8,4.8476e-02_r8, &
     &3.3522e-02_r8,1.7446e-02_r8,1.7040e-02_r8/)
      kao(:, 1, 6,10) = (/ &
     &2.3387e-01_r8,2.0464e-01_r8,1.7541e-01_r8,1.4624e-01_r8,1.1769e-01_r8,8.8692e-02_r8, &
     &5.9747e-02_r8,3.0756e-02_r8,2.5605e-03_r8/)
      kao(:, 2, 6,10) = (/ &
     &2.3730e-01_r8,2.0756e-01_r8,1.7772e-01_r8,1.4892e-01_r8,1.1985e-01_r8,9.0758e-02_r8, &
     &6.1778e-02_r8,3.2933e-02_r8,4.6893e-03_r8/)
      kao(:, 3, 6,10) = (/ &
     &2.4203e-01_r8,2.1158e-01_r8,1.8155e-01_r8,1.5250e-01_r8,1.2284e-01_r8,9.2705e-02_r8, &
     &6.3067e-02_r8,3.2776e-02_r8,9.7345e-03_r8/)
      kao(:, 4, 6,10) = (/ &
     &2.3049e-01_r8,2.0160e-01_r8,1.7416e-01_r8,1.4569e-01_r8,1.1768e-01_r8,8.9784e-02_r8, &
     &6.1642e-02_r8,3.4682e-02_r8,1.6936e-02_r8/)
      kao(:, 5, 6,10) = (/ &
     &2.3636e-01_r8,2.0679e-01_r8,1.7932e-01_r8,1.5154e-01_r8,1.2337e-01_r8,9.4475e-02_r8, &
     &6.5584e-02_r8,3.6305e-02_r8,2.2069e-02_r8/)
      kao(:, 1, 7,10) = (/ &
     &4.9443e-01_r8,4.3211e-01_r8,3.7050e-01_r8,3.0887e-01_r8,2.4699e-01_r8,1.8540e-01_r8, &
     &1.2438e-01_r8,6.2986e-02_r8,2.0096e-03_r8/)
      kao(:, 2, 7,10) = (/ &
     &4.9639e-01_r8,4.3473e-01_r8,3.7266e-01_r8,3.1039e-01_r8,2.4852e-01_r8,1.8749e-01_r8, &
     &1.2568e-01_r8,6.4131e-02_r8,3.0764e-03_r8/)
      kao(:, 3, 7,10) = (/ &
     &4.9265e-01_r8,4.3128e-01_r8,3.6987e-01_r8,3.0823e-01_r8,2.4792e-01_r8,1.8671e-01_r8, &
     &1.2562e-01_r8,6.4213e-02_r8,5.4655e-03_r8/)
      kao(:, 4, 7,10) = (/ &
     &4.7703e-01_r8,4.1742e-01_r8,3.5749e-01_r8,2.9850e-01_r8,2.4081e-01_r8,1.8239e-01_r8, &
     &1.2380e-01_r8,6.5802e-02_r8,1.0925e-02_r8/)
      kao(:, 5, 7,10) = (/ &
     &4.8180e-01_r8,4.2216e-01_r8,3.6195e-01_r8,3.0277e-01_r8,2.4364e-01_r8,1.8402e-01_r8, &
     &1.2523e-01_r8,6.7909e-02_r8,1.4296e-02_r8/)
      kao(:, 1, 8,10) = (/ &
     &1.1962e+00_r8,1.0464e+00_r8,8.9717e-01_r8,7.4708e-01_r8,5.9764e-01_r8,4.4825e-01_r8, &
     &2.9884e-01_r8,1.5061e-01_r8,3.8986e-03_r8/)
      kao(:, 2, 8,10) = (/ &
     &1.2041e+00_r8,1.0536e+00_r8,9.0306e-01_r8,7.5220e-01_r8,6.0244e-01_r8,4.5171e-01_r8, &
     &3.0103e-01_r8,1.5197e-01_r8,3.3573e-03_r8/)
      kao(:, 3, 8,10) = (/ &
     &1.1525e+00_r8,1.0084e+00_r8,8.6433e-01_r8,7.2027e-01_r8,5.7631e-01_r8,4.3217e-01_r8, &
     &2.8996e-01_r8,1.4673e-01_r8,3.4045e-03_r8/)
      kao(:, 4, 8,10) = (/ &
     &1.1627e+00_r8,1.0178e+00_r8,8.7243e-01_r8,7.2665e-01_r8,5.8167e-01_r8,4.3823e-01_r8, &
     &2.9244e-01_r8,1.4815e-01_r8,8.5595e-03_r8/)
      kao(:, 5, 8,10) = (/ &
     &1.1683e+00_r8,1.0228e+00_r8,8.7612e-01_r8,7.3014e-01_r8,5.8445e-01_r8,4.4237e-01_r8, &
     &2.9748e-01_r8,1.5239e-01_r8,1.0748e-02_r8/)
      kao(:, 1, 9,10) = (/ &
     &5.3473e+00_r8,4.6810e+00_r8,4.0088e+00_r8,3.3420e+00_r8,2.6745e+00_r8,2.0052e+00_r8, &
     &1.3357e+00_r8,6.6899e-01_r8,9.0646e-06_r8/)
      kao(:, 2, 9,10) = (/ &
     &5.3849e+00_r8,4.7131e+00_r8,4.0386e+00_r8,3.3668e+00_r8,2.6936e+00_r8,2.0203e+00_r8, &
     &1.3467e+00_r8,6.7337e-01_r8,1.6160e-05_r8/)
      kao(:, 3, 9,10) = (/ &
     &5.2604e+00_r8,4.6046e+00_r8,3.9456e+00_r8,3.2881e+00_r8,2.6303e+00_r8,1.9734e+00_r8, &
     &1.3151e+00_r8,6.5758e-01_r8,2.7795e-05_r8/)
      kao(:, 4, 9,10) = (/ &
     &4.9950e+00_r8,4.3651e+00_r8,3.7432e+00_r8,3.1211e+00_r8,2.4979e+00_r8,1.8723e+00_r8, &
     &1.2477e+00_r8,6.2561e-01_r8,4.1978e-05_r8/)
      kao(:, 5, 9,10) = (/ &
     &5.1108e+00_r8,4.4671e+00_r8,3.8297e+00_r8,3.1913e+00_r8,2.5537e+00_r8,1.9170e+00_r8, &
     &1.2756e+00_r8,6.4540e-01_r8,6.6209e-05_r8/)
      kao(:, 1,10,10) = (/ &
     &2.6042e+01_r8,2.2785e+01_r8,1.9540e+01_r8,1.6264e+01_r8,1.3016e+01_r8,9.7654e+00_r8, &
     &6.5078e+00_r8,3.2552e+00_r8,5.7707e-06_r8/)
      kao(:, 2,10,10) = (/ &
     &2.6479e+01_r8,2.3167e+01_r8,1.9837e+01_r8,1.6530e+01_r8,1.3239e+01_r8,9.9265e+00_r8, &
     &6.6195e+00_r8,3.3086e+00_r8,1.0081e-05_r8/)
      kao(:, 3,10,10) = (/ &
     &2.6009e+01_r8,2.2746e+01_r8,1.9506e+01_r8,1.6255e+01_r8,1.3009e+01_r8,9.7479e+00_r8, &
     &6.5045e+00_r8,3.2511e+00_r8,1.6976e-05_r8/)
      kao(:, 4,10,10) = (/ &
     &2.4905e+01_r8,2.1818e+01_r8,1.8660e+01_r8,1.5572e+01_r8,1.2451e+01_r8,9.3433e+00_r8, &
     &6.2220e+00_r8,3.1125e+00_r8,2.8117e-05_r8/)
      kao(:, 5,10,10) = (/ &
     &2.5169e+01_r8,2.2024e+01_r8,1.8885e+01_r8,1.5746e+01_r8,1.2587e+01_r8,9.4388e+00_r8, &
     &6.2934e+00_r8,3.1427e+00_r8,4.4861e-05_r8/)
      kao(:, 1,11,10) = (/ &
     &4.3366e+01_r8,3.7949e+01_r8,3.2540e+01_r8,2.7105e+01_r8,2.1683e+01_r8,1.6263e+01_r8, &
     &1.0837e+01_r8,5.4210e+00_r8,4.9323e-06_r8/)
      kao(:, 2,11,10) = (/ &
     &4.4481e+01_r8,3.8935e+01_r8,3.3362e+01_r8,2.7791e+01_r8,2.2247e+01_r8,1.6680e+01_r8, &
     &1.1125e+01_r8,5.5599e+00_r8,8.9387e-06_r8/)
      kao(:, 3,11,10) = (/ &
     &4.2759e+01_r8,3.7428e+01_r8,3.2070e+01_r8,2.6725e+01_r8,2.1369e+01_r8,1.6026e+01_r8, &
     &1.0686e+01_r8,5.3424e+00_r8,1.3904e-05_r8/)
      kao(:, 4,11,10) = (/ &
     &4.2776e+01_r8,3.7387e+01_r8,3.2051e+01_r8,2.6735e+01_r8,2.1399e+01_r8,1.6039e+01_r8, &
     &1.0699e+01_r8,5.3492e+00_r8,2.3732e-05_r8/)
      kao(:, 5,11,10) = (/ &
     &4.2881e+01_r8,3.7499e+01_r8,3.2160e+01_r8,2.6814e+01_r8,2.1427e+01_r8,1.6080e+01_r8, &
     &1.0724e+01_r8,5.3602e+00_r8,3.9053e-05_r8/)
      kao(:, 1,12,10) = (/ &
     &5.2035e+01_r8,4.5530e+01_r8,3.8991e+01_r8,3.2521e+01_r8,2.6007e+01_r8,1.9502e+01_r8, &
     &1.3003e+01_r8,6.5017e+00_r8,4.1086e-06_r8/)
      kao(:, 2,12,10) = (/ &
     &5.2620e+01_r8,4.6040e+01_r8,3.9465e+01_r8,3.2876e+01_r8,2.6300e+01_r8,1.9726e+01_r8, &
     &1.3150e+01_r8,6.5751e+00_r8,7.6006e-06_r8/)
      kao(:, 3,12,10) = (/ &
     &5.1699e+01_r8,4.5233e+01_r8,3.8772e+01_r8,3.2297e+01_r8,2.5847e+01_r8,1.9404e+01_r8, &
     &1.2928e+01_r8,6.4618e+00_r8,1.3155e-05_r8/)
      kao(:, 4,12,10) = (/ &
     &5.1530e+01_r8,4.5092e+01_r8,3.8615e+01_r8,3.2196e+01_r8,2.5751e+01_r8,1.9320e+01_r8, &
     &1.2877e+01_r8,6.4388e+00_r8,2.2125e-05_r8/)
      kao(:, 5,12,10) = (/ &
     &5.2358e+01_r8,4.5788e+01_r8,3.9246e+01_r8,3.2725e+01_r8,2.6162e+01_r8,1.9634e+01_r8, &
     &1.3083e+01_r8,6.5448e+00_r8,3.4034e-05_r8/)
      kao(:, 1,13,10) = (/ &
     &4.8070e+01_r8,4.2058e+01_r8,3.6028e+01_r8,3.0041e+01_r8,2.4032e+01_r8,1.8020e+01_r8, &
     &1.2016e+01_r8,6.0067e+00_r8,1.1683e-05_r8/)
      kao(:, 2,13,10) = (/ &
     &4.7586e+01_r8,4.1613e+01_r8,3.5689e+01_r8,2.9748e+01_r8,2.3780e+01_r8,1.7835e+01_r8, &
     &1.1890e+01_r8,5.9450e+00_r8,6.6906e-06_r8/)
      kao(:, 3,13,10) = (/ &
     &4.7760e+01_r8,4.1804e+01_r8,3.5818e+01_r8,2.9821e+01_r8,2.3863e+01_r8,1.7898e+01_r8, &
     &1.1923e+01_r8,5.9715e+00_r8,1.1688e-05_r8/)
      kao(:, 4,13,10) = (/ &
     &4.7976e+01_r8,4.1998e+01_r8,3.6011e+01_r8,3.0021e+01_r8,2.3989e+01_r8,1.7987e+01_r8, &
     &1.2008e+01_r8,6.0018e+00_r8,2.0801e-05_r8/)
      kao(:, 5,13,10) = (/ &
     &4.8185e+01_r8,4.2179e+01_r8,3.6131e+01_r8,3.0110e+01_r8,2.4087e+01_r8,1.8066e+01_r8, &
     &1.2054e+01_r8,6.0193e+00_r8,3.3629e-05_r8/)
      kao(:, 1, 1,11) = (/ &
     &2.3144e-03_r8,3.0235e-03_r8,4.2030e-03_r8,4.5486e-03_r8,6.9673e-03_r8,8.5656e-03_r8, &
     &1.0150e-02_r8,1.3548e-02_r8,1.3475e-02_r8/)
      kao(:, 2, 1,11) = (/ &
     &2.0416e-03_r8,3.1999e-03_r8,4.6569e-03_r8,6.4031e-03_r8,9.8267e-03_r8,1.1395e-02_r8, &
     &1.5022e-02_r8,1.8877e-02_r8,1.8904e-02_r8/)
      kao(:, 3, 1,11) = (/ &
     &1.8509e-03_r8,4.2185e-03_r8,5.5775e-03_r8,9.1095e-03_r8,1.2979e-02_r8,1.4639e-02_r8, &
     &2.1829e-02_r8,2.5577e-02_r8,2.5272e-02_r8/)
      kao(:, 4, 1,11) = (/ &
     &1.7995e-03_r8,5.2396e-03_r8,7.4739e-03_r8,1.1646e-02_r8,1.7153e-02_r8,1.9747e-02_r8, &
     &2.8712e-02_r8,3.3739e-02_r8,3.3147e-02_r8/)
      kao(:, 5, 1,11) = (/ &
     &1.8412e-03_r8,6.1417e-03_r8,9.5119e-03_r8,1.5457e-02_r8,2.1034e-02_r8,2.5800e-02_r8, &
     &3.6795e-02_r8,4.3339e-02_r8,4.2100e-02_r8/)
      kao(:, 1, 2,11) = (/ &
     &7.4427e-03_r8,5.5490e-03_r8,4.6664e-03_r8,4.6380e-03_r8,5.2610e-03_r8,8.4068e-03_r8, &
     &1.0505e-02_r8,1.1967e-02_r8,1.0119e-02_r8/)
      kao(:, 2, 2,11) = (/ &
     &5.3180e-03_r8,5.4523e-03_r8,5.6480e-03_r8,5.7960e-03_r8,8.0504e-03_r8,1.1015e-02_r8, &
     &1.3308e-02_r8,1.6901e-02_r8,1.5834e-02_r8/)
      kao(:, 3, 2,11) = (/ &
     &4.1509e-03_r8,5.0420e-03_r8,5.9494e-03_r8,7.8778e-03_r8,1.1077e-02_r8,1.4709e-02_r8, &
     &1.7403e-02_r8,2.2592e-02_r8,2.1710e-02_r8/)
      kao(:, 4, 2,11) = (/ &
     &3.7251e-03_r8,5.8604e-03_r8,7.1881e-03_r8,1.0249e-02_r8,1.4831e-02_r8,1.9015e-02_r8, &
     &2.1299e-02_r8,2.9770e-02_r8,2.9198e-02_r8/)
      kao(:, 5, 2,11) = (/ &
     &3.3170e-03_r8,7.3759e-03_r8,9.2312e-03_r8,1.4285e-02_r8,1.9035e-02_r8,2.3096e-02_r8, &
     &2.6856e-02_r8,3.8325e-02_r8,3.7190e-02_r8/)
      kao(:, 1, 3,11) = (/ &
     &2.3930e-02_r8,2.1175e-02_r8,1.8068e-02_r8,1.3752e-02_r8,9.3232e-03_r8,6.3033e-03_r8, &
     &9.0890e-03_r8,1.0309e-02_r8,9.2920e-03_r8/)
      kao(:, 2, 3,11) = (/ &
     &2.1364e-02_r8,1.8346e-02_r8,1.4408e-02_r8,1.0567e-02_r8,7.3487e-03_r8,8.3255e-03_r8, &
     &1.2320e-02_r8,1.3559e-02_r8,1.1942e-02_r8/)
      kao(:, 3, 3,11) = (/ &
     &1.6897e-02_r8,1.4069e-02_r8,1.1090e-02_r8,9.4072e-03_r8,9.0158e-03_r8,1.2182e-02_r8, &
     &1.6529e-02_r8,1.8032e-02_r8,1.6702e-02_r8/)
      kao(:, 4, 3,11) = (/ &
     &1.1735e-02_r8,1.1062e-02_r8,1.1919e-02_r8,1.0177e-02_r8,1.1885e-02_r8,1.6740e-02_r8, &
     &2.0422e-02_r8,2.2761e-02_r8,2.2381e-02_r8/)
      kao(:, 5, 3,11) = (/ &
     &9.3268e-03_r8,1.0886e-02_r8,1.2245e-02_r8,1.2355e-02_r8,1.5695e-02_r8,2.1667e-02_r8, &
     &2.4460e-02_r8,2.7729e-02_r8,3.0274e-02_r8/)
      kao(:, 1, 4,11) = (/ &
     &5.8030e-02_r8,5.0790e-02_r8,4.4332e-02_r8,3.7503e-02_r8,3.1337e-02_r8,2.3862e-02_r8, &
     &1.5919e-02_r8,8.9924e-03_r8,1.0517e-02_r8/)
      kao(:, 2, 4,11) = (/ &
     &5.8203e-02_r8,5.1238e-02_r8,4.3852e-02_r8,3.6687e-02_r8,2.8842e-02_r8,2.1050e-02_r8, &
     &1.3525e-02_r8,1.1884e-02_r8,1.5506e-02_r8/)
      kao(:, 3, 4,11) = (/ &
     &6.0219e-02_r8,5.3113e-02_r8,4.5845e-02_r8,3.6288e-02_r8,2.6852e-02_r8,1.6648e-02_r8, &
     &1.3537e-02_r8,1.6277e-02_r8,1.8129e-02_r8/)
      kao(:, 4, 4,11) = (/ &
     &4.9871e-02_r8,4.2283e-02_r8,3.5849e-02_r8,2.8922e-02_r8,1.9343e-02_r8,1.4341e-02_r8, &
     &1.8188e-02_r8,2.0990e-02_r8,2.0822e-02_r8/)
      kao(:, 5, 4,11) = (/ &
     &3.8385e-02_r8,3.4058e-02_r8,2.7365e-02_r8,2.1994e-02_r8,1.7140e-02_r8,1.6164e-02_r8, &
     &2.3472e-02_r8,2.6305e-02_r8,2.6373e-02_r8/)
      kao(:, 1, 5,11) = (/ &
     &1.3556e-01_r8,1.1844e-01_r8,1.0158e-01_r8,8.5252e-02_r8,6.8440e-02_r8,5.1875e-02_r8, &
     &3.5448e-02_r8,1.8978e-02_r8,8.8762e-03_r8/)
      kao(:, 2, 5,11) = (/ &
     &1.3807e-01_r8,1.2082e-01_r8,1.0421e-01_r8,8.7432e-02_r8,7.0858e-02_r8,5.4903e-02_r8, &
     &3.7824e-02_r8,2.0068e-02_r8,1.1692e-02_r8/)
      kao(:, 3, 5,11) = (/ &
     &1.3721e-01_r8,1.2013e-01_r8,1.0360e-01_r8,8.7259e-02_r8,7.0575e-02_r8,5.3560e-02_r8, &
     &3.5670e-02_r8,1.8870e-02_r8,1.8216e-02_r8/)
      kao(:, 4, 5,11) = (/ &
     &1.2962e-01_r8,1.1333e-01_r8,9.6679e-02_r8,8.1723e-02_r8,6.6334e-02_r8,5.1939e-02_r8, &
     &3.3737e-02_r8,2.0192e-02_r8,2.7154e-02_r8/)
      kao(:, 5, 5,11) = (/ &
     &1.2340e-01_r8,1.0852e-01_r8,9.2540e-02_r8,7.8313e-02_r8,6.2622e-02_r8,4.1413e-02_r8, &
     &2.5923e-02_r8,2.4326e-02_r8,3.4052e-02_r8/)
      kao(:, 1, 6,11) = (/ &
     &2.8825e-01_r8,2.5222e-01_r8,2.1620e-01_r8,1.8017e-01_r8,1.4417e-01_r8,1.0893e-01_r8, &
     &7.3359e-02_r8,3.7509e-02_r8,5.6670e-03_r8/)
      kao(:, 2, 6,11) = (/ &
     &2.8768e-01_r8,2.5188e-01_r8,2.1600e-01_r8,1.7993e-01_r8,1.4497e-01_r8,1.0976e-01_r8, &
     &7.3838e-02_r8,3.8599e-02_r8,8.8428e-03_r8/)
      kao(:, 3, 6,11) = (/ &
     &2.8241e-01_r8,2.4722e-01_r8,2.1181e-01_r8,1.7724e-01_r8,1.4248e-01_r8,1.0766e-01_r8, &
     &7.3624e-02_r8,3.9950e-02_r8,1.3973e-02_r8/)
      kao(:, 4, 6,11) = (/ &
     &2.8627e-01_r8,2.5067e-01_r8,2.1487e-01_r8,1.8056e-01_r8,1.4619e-01_r8,1.1172e-01_r8, &
     &7.8306e-02_r8,4.0986e-02_r8,2.0403e-02_r8/)
      kao(:, 5, 6,11) = (/ &
     &2.7874e-01_r8,2.4399e-01_r8,2.0989e-01_r8,1.7645e-01_r8,1.4231e-01_r8,1.0969e-01_r8, &
     &7.6704e-02_r8,4.0995e-02_r8,2.4450e-02_r8/)
      kao(:, 1, 7,11) = (/ &
     &6.1169e-01_r8,5.3575e-01_r8,4.5923e-01_r8,3.8252e-01_r8,3.0616e-01_r8,2.2929e-01_r8, &
     &1.5383e-01_r8,7.7531e-02_r8,2.8956e-03_r8/)
      kao(:, 2, 7,11) = (/ &
     &6.1159e-01_r8,5.3511e-01_r8,4.5848e-01_r8,3.8242e-01_r8,3.0567e-01_r8,2.3004e-01_r8, &
     &1.5345e-01_r8,7.7731e-02_r8,6.2629e-03_r8/)
      kao(:, 3, 7,11) = (/ &
     &6.0642e-01_r8,5.3036e-01_r8,4.5410e-01_r8,3.7880e-01_r8,3.0308e-01_r8,2.2893e-01_r8, &
     &1.5450e-01_r8,7.9546e-02_r8,1.1879e-02_r8/)
      kao(:, 4, 7,11) = (/ &
     &6.2322e-01_r8,5.4531e-01_r8,4.6718e-01_r8,3.8974e-01_r8,3.1356e-01_r8,2.3563e-01_r8, &
     &1.5873e-01_r8,8.1521e-02_r8,1.3030e-02_r8/)
      kao(:, 5, 7,11) = (/ &
     &6.1773e-01_r8,5.4019e-01_r8,4.6283e-01_r8,3.8859e-01_r8,3.1161e-01_r8,2.3601e-01_r8, &
     &1.5998e-01_r8,8.3125e-02_r8,1.9458e-02_r8/)
      kao(:, 1, 8,11) = (/ &
     &1.4932e+00_r8,1.3065e+00_r8,1.1199e+00_r8,9.3315e-01_r8,7.4665e-01_r8,5.5991e-01_r8, &
     &3.7327e-01_r8,1.8697e-01_r8,1.1999e-05_r8/)
      kao(:, 2, 8,11) = (/ &
     &1.5196e+00_r8,1.3312e+00_r8,1.1397e+00_r8,9.5010e-01_r8,7.6026e-01_r8,5.7020e-01_r8, &
     &3.8013e-01_r8,1.9174e-01_r8,7.7042e-03_r8/)
      kao(:, 3, 8,11) = (/ &
     &1.5505e+00_r8,1.3567e+00_r8,1.1629e+00_r8,9.6902e-01_r8,7.7525e-01_r8,5.8146e-01_r8, &
     &3.8981e-01_r8,1.9691e-01_r8,1.2006e-02_r8/)
      kao(:, 4, 8,11) = (/ &
     &1.4878e+00_r8,1.3018e+00_r8,1.1160e+00_r8,9.2984e-01_r8,7.4341e-01_r8,5.5771e-01_r8, &
     &3.7622e-01_r8,1.9146e-01_r8,1.2696e-02_r8/)
      kao(:, 5, 8,11) = (/ &
     &1.4729e+00_r8,1.2883e+00_r8,1.1049e+00_r8,9.2129e-01_r8,7.3618e-01_r8,5.5599e-01_r8, &
     &3.7163e-01_r8,1.8805e-01_r8,1.8722e-02_r8/)
      kao(:, 1, 9,11) = (/ &
     &6.8904e+00_r8,6.0266e+00_r8,5.1680e+00_r8,4.3068e+00_r8,3.4452e+00_r8,2.5839e+00_r8, &
     &1.7234e+00_r8,8.6092e-01_r8,6.7224e-06_r8/)
      kao(:, 2, 9,11) = (/ &
     &7.0980e+00_r8,6.2107e+00_r8,5.3294e+00_r8,4.4415e+00_r8,3.5510e+00_r8,2.6633e+00_r8, &
     &1.7755e+00_r8,8.8723e-01_r8,1.2025e-05_r8/)
      kao(:, 3, 9,11) = (/ &
     &7.2688e+00_r8,6.3564e+00_r8,5.4482e+00_r8,4.5401e+00_r8,3.6343e+00_r8,2.7243e+00_r8, &
     &1.8161e+00_r8,9.0754e-01_r8,1.9985e-05_r8/)
      kao(:, 4, 9,11) = (/ &
     &7.1740e+00_r8,6.2782e+00_r8,5.3807e+00_r8,4.4818e+00_r8,3.5855e+00_r8,2.6901e+00_r8, &
     &1.7938e+00_r8,8.9646e-01_r8,3.0947e-05_r8/)
      kao(:, 5, 9,11) = (/ &
     &6.7468e+00_r8,5.9097e+00_r8,5.0601e+00_r8,4.2188e+00_r8,3.3754e+00_r8,2.5313e+00_r8, &
     &1.6873e+00_r8,8.4597e-01_r8,4.6476e-05_r8/)
      kao(:, 1,10,11) = (/ &
     &3.5457e+01_r8,3.1027e+01_r8,2.6582e+01_r8,2.2175e+01_r8,1.7740e+01_r8,1.3297e+01_r8, &
     &8.8648e+00_r8,4.4349e+00_r8,3.8551e-06_r8/)
      kao(:, 2,10,11) = (/ &
     &3.5857e+01_r8,3.1366e+01_r8,2.6891e+01_r8,2.2421e+01_r8,1.7929e+01_r8,1.3446e+01_r8, &
     &8.9645e+00_r8,4.4822e+00_r8,7.1785e-06_r8/)
      kao(:, 3,10,11) = (/ &
     &3.7065e+01_r8,3.2447e+01_r8,2.7799e+01_r8,2.3166e+01_r8,1.8532e+01_r8,1.3906e+01_r8, &
     &9.2664e+00_r8,4.6331e+00_r8,1.2630e-05_r8/)
      kao(:, 4,10,11) = (/ &
     &3.6718e+01_r8,3.2113e+01_r8,2.7539e+01_r8,2.2938e+01_r8,1.8366e+01_r8,1.3764e+01_r8, &
     &9.1841e+00_r8,4.5916e+00_r8,2.1179e-05_r8/)
      kao(:, 5,10,11) = (/ &
     &3.5010e+01_r8,3.0613e+01_r8,2.6257e+01_r8,2.1870e+01_r8,1.7497e+01_r8,1.3129e+01_r8, &
     &8.7481e+00_r8,4.3808e+00_r8,3.3504e-05_r8/)
      kao(:, 1,11,11) = (/ &
     &6.2218e+01_r8,5.4427e+01_r8,4.6646e+01_r8,3.8874e+01_r8,3.1110e+01_r8,2.3334e+01_r8, &
     &1.5561e+01_r8,7.7776e+00_r8,3.5875e-06_r8/)
      kao(:, 2,11,11) = (/ &
     &6.2105e+01_r8,5.4407e+01_r8,4.6579e+01_r8,3.8839e+01_r8,3.1033e+01_r8,2.3318e+01_r8, &
     &1.5536e+01_r8,7.7679e+00_r8,5.9066e-06_r8/)
      kao(:, 3,11,11) = (/ &
     &6.4816e+01_r8,5.6715e+01_r8,4.8615e+01_r8,4.0513e+01_r8,3.2442e+01_r8,2.4317e+01_r8, &
     &1.6205e+01_r8,8.1056e+00_r8,1.0776e-05_r8/)
      kao(:, 4,11,11) = (/ &
     &6.2787e+01_r8,5.4987e+01_r8,4.7112e+01_r8,3.9241e+01_r8,3.1378e+01_r8,2.3555e+01_r8, &
     &1.5697e+01_r8,7.8485e+00_r8,1.7304e-05_r8/)
      kao(:, 5,11,11) = (/ &
     &6.1876e+01_r8,5.4130e+01_r8,4.6407e+01_r8,3.8627e+01_r8,3.0933e+01_r8,2.3204e+01_r8, &
     &1.5469e+01_r8,7.7346e+00_r8,2.7512e-05_r8/)
      kao(:, 1,12,11) = (/ &
     &8.0103e+01_r8,7.0095e+01_r8,6.0103e+01_r8,5.0066e+01_r8,4.0052e+01_r8,3.0040e+01_r8, &
     &2.0026e+01_r8,1.0013e+01_r8,3.2505e-06_r8/)
      kao(:, 2,12,11) = (/ &
     &7.9090e+01_r8,6.9204e+01_r8,5.9318e+01_r8,4.9432e+01_r8,3.9544e+01_r8,2.9659e+01_r8, &
     &1.9773e+01_r8,9.8860e+00_r8,5.5034e-06_r8/)
      kao(:, 3,12,11) = (/ &
     &7.9848e+01_r8,6.9859e+01_r8,5.9882e+01_r8,4.9902e+01_r8,3.9894e+01_r8,2.9946e+01_r8, &
     &1.9960e+01_r8,9.9805e+00_r8,8.6063e-06_r8/)
      kao(:, 4,12,11) = (/ &
     &7.8661e+01_r8,6.8779e+01_r8,5.8977e+01_r8,4.9159e+01_r8,3.9293e+01_r8,2.9497e+01_r8, &
     &1.9663e+01_r8,9.8183e+00_r8,1.4131e-05_r8/)
      kao(:, 5,12,11) = (/ &
     &7.8792e+01_r8,6.8975e+01_r8,5.9124e+01_r8,4.9246e+01_r8,3.9445e+01_r8,2.9569e+01_r8, &
     &1.9707e+01_r8,9.8563e+00_r8,2.3305e-05_r8/)
      kao(:, 1,13,11) = (/ &
     &7.5314e+01_r8,6.5898e+01_r8,5.6507e+01_r8,4.7072e+01_r8,3.7657e+01_r8,2.8254e+01_r8, &
     &1.8828e+01_r8,9.4159e+00_r8,2.7819e-06_r8/)
      kao(:, 2,13,11) = (/ &
     &7.4029e+01_r8,6.4852e+01_r8,5.5523e+01_r8,4.6247e+01_r8,3.7031e+01_r8,2.7774e+01_r8, &
     &1.8528e+01_r8,9.2576e+00_r8,5.0908e-06_r8/)
      kao(:, 3,13,11) = (/ &
     &7.3797e+01_r8,6.4573e+01_r8,5.5347e+01_r8,4.6143e+01_r8,3.6917e+01_r8,2.7689e+01_r8, &
     &1.8458e+01_r8,9.2250e+00_r8,8.2936e-06_r8/)
      kao(:, 4,13,11) = (/ &
     &7.5507e+01_r8,6.6112e+01_r8,5.6628e+01_r8,4.7225e+01_r8,3.7779e+01_r8,2.8348e+01_r8, &
     &1.8877e+01_r8,9.4449e+00_r8,1.2487e-05_r8/)
      kao(:, 5,13,11) = (/ &
     &7.6962e+01_r8,6.7290e+01_r8,5.7729e+01_r8,4.8107e+01_r8,3.8486e+01_r8,2.8863e+01_r8, &
     &1.9221e+01_r8,9.6284e+00_r8,1.8751e-05_r8/)
      kao(:, 1, 1,12) = (/ &
     &1.1046e-03_r8,3.3707e-03_r8,5.0558e-03_r8,8.2647e-03_r8,9.1015e-03_r8,1.0694e-02_r8, &
     &1.8807e-02_r8,2.2647e-02_r8,1.8110e-02_r8/)
      kao(:, 2, 1,12) = (/ &
     &1.0969e-03_r8,4.7708e-03_r8,7.6740e-03_r8,1.0546e-02_r8,1.0900e-02_r8,1.6801e-02_r8, &
     &2.5799e-02_r8,3.1294e-02_r8,2.2312e-02_r8/)
      kao(:, 3, 1,12) = (/ &
     &1.0873e-03_r8,6.1594e-03_r8,1.0535e-02_r8,1.2275e-02_r8,1.5399e-02_r8,2.5780e-02_r8, &
     &3.4278e-02_r8,4.1551e-02_r8,3.1702e-02_r8/)
      kao(:, 4, 1,12) = (/ &
     &1.0681e-03_r8,6.7407e-03_r8,1.3124e-02_r8,1.6579e-02_r8,1.9835e-02_r8,3.5596e-02_r8, &
     &4.4369e-02_r8,5.3472e-02_r8,4.1109e-02_r8/)
      kao(:, 5, 1,12) = (/ &
     &1.0270e-03_r8,8.1418e-03_r8,1.5112e-02_r8,2.0848e-02_r8,2.8658e-02_r8,4.6490e-02_r8, &
     &5.6118e-02_r8,6.7233e-02_r8,5.7448e-02_r8/)
      kao(:, 1, 2,12) = (/ &
     &1.5646e-03_r8,3.6954e-03_r8,5.8279e-03_r8,7.1796e-03_r8,9.8217e-03_r8,9.7524e-03_r8, &
     &1.1081e-02_r8,1.8489e-02_r8,1.8167e-02_r8/)
      kao(:, 2, 2,12) = (/ &
     &1.5547e-03_r8,3.8903e-03_r8,7.0691e-03_r8,1.0316e-02_r8,1.1952e-02_r8,1.3642e-02_r8, &
     &1.6631e-02_r8,2.5775e-02_r8,2.2105e-02_r8/)
      kao(:, 3, 2,12) = (/ &
     &1.5005e-03_r8,5.8120e-03_r8,1.0164e-02_r8,1.2828e-02_r8,1.5616e-02_r8,1.8084e-02_r8, &
     &2.4815e-02_r8,3.4836e-02_r8,2.8922e-02_r8/)
      kao(:, 4, 2,12) = (/ &
     &1.4224e-03_r8,7.6958e-03_r8,1.3586e-02_r8,1.5505e-02_r8,1.9916e-02_r8,2.3661e-02_r8, &
     &3.6496e-02_r8,4.5732e-02_r8,3.8152e-02_r8/)
      kao(:, 5, 2,12) = (/ &
     &1.3736e-03_r8,9.1086e-03_r8,1.6016e-02_r8,2.0127e-02_r8,2.5470e-02_r8,3.1020e-02_r8, &
     &5.0141e-02_r8,5.8654e-02_r8,5.1074e-02_r8/)
      kao(:, 1, 3,12) = (/ &
     &1.0482e-02_r8,8.9646e-03_r8,6.8350e-03_r8,8.2815e-03_r8,8.8992e-03_r8,1.0605e-02_r8, &
     &1.0328e-02_r8,1.1583e-02_r8,1.6044e-02_r8/)
      kao(:, 2, 3,12) = (/ &
     &5.7078e-03_r8,6.1160e-03_r8,7.6830e-03_r8,9.7377e-03_r8,1.2964e-02_r8,1.2587e-02_r8, &
     &1.4124e-02_r8,1.6978e-02_r8,2.4120e-02_r8/)
      kao(:, 3, 3,12) = (/ &
     &3.9502e-03_r8,6.0459e-03_r8,1.0569e-02_r8,1.4120e-02_r8,1.6811e-02_r8,1.6440e-02_r8, &
     &1.9141e-02_r8,2.2713e-02_r8,3.1566e-02_r8/)
      kao(:, 4, 3,12) = (/ &
     &3.2701e-03_r8,7.5815e-03_r8,1.2592e-02_r8,1.9220e-02_r8,1.9128e-02_r8,2.1966e-02_r8, &
     &2.6084e-02_r8,3.3096e-02_r8,3.6118e-02_r8/)
      kao(:, 5, 3,12) = (/ &
     &2.7401e-03_r8,7.8080e-03_r8,1.5492e-02_r8,2.3290e-02_r8,2.4892e-02_r8,2.8848e-02_r8, &
     &3.4321e-02_r8,4.6873e-02_r8,4.7340e-02_r8/)
      kao(:, 1, 4,12) = (/ &
     &6.0672e-02_r8,5.3090e-02_r8,4.4556e-02_r8,3.6202e-02_r8,2.6483e-02_r8,1.8181e-02_r8, &
     &1.2199e-02_r8,1.0993e-02_r8,1.4969e-02_r8/)
      kao(:, 2, 4,12) = (/ &
     &4.3589e-02_r8,3.8144e-02_r8,3.0755e-02_r8,2.3593e-02_r8,1.9730e-02_r8,1.5624e-02_r8, &
     &1.3490e-02_r8,1.5542e-02_r8,2.0057e-02_r8/)
      kao(:, 3, 4,12) = (/ &
     &2.4695e-02_r8,2.2865e-02_r8,1.7074e-02_r8,1.5816e-02_r8,1.6661e-02_r8,2.0463e-02_r8, &
     &1.7348e-02_r8,2.1210e-02_r8,2.8829e-02_r8/)
      kao(:, 4, 4,12) = (/ &
     &1.4306e-02_r8,1.8283e-02_r8,1.4453e-02_r8,1.9081e-02_r8,2.2731e-02_r8,2.4085e-02_r8, &
     &2.3223e-02_r8,2.7809e-02_r8,4.1362e-02_r8/)
      kao(:, 5, 4,12) = (/ &
     &1.0713e-02_r8,1.1979e-02_r8,1.4158e-02_r8,2.2119e-02_r8,2.9428e-02_r8,2.9426e-02_r8, &
     &3.0795e-02_r8,3.5958e-02_r8,5.4444e-02_r8/)
      kao(:, 1, 5,12) = (/ &
     &1.5652e-01_r8,1.3723e-01_r8,1.1755e-01_r8,9.8247e-02_r8,7.8467e-02_r8,5.9349e-02_r8, &
     &3.9820e-02_r8,1.8398e-02_r8,1.1394e-02_r8/)
      kao(:, 2, 5,12) = (/ &
     &1.5350e-01_r8,1.3431e-01_r8,1.1514e-01_r8,9.6381e-02_r8,7.7667e-02_r8,5.6368e-02_r8, &
     &3.3743e-02_r8,1.4780e-02_r8,1.5913e-02_r8/)
      kao(:, 3, 5,12) = (/ &
     &1.3349e-01_r8,1.1672e-01_r8,9.9565e-02_r8,8.1852e-02_r8,6.1169e-02_r8,4.3464e-02_r8, &
     &2.9522e-02_r8,1.7569e-02_r8,2.3571e-02_r8/)
      kao(:, 4, 5,12) = (/ &
     &1.0423e-01_r8,9.1271e-02_r8,7.7253e-02_r8,6.0811e-02_r8,4.8046e-02_r8,3.4464e-02_r8, &
     &2.5349e-02_r8,2.3626e-02_r8,3.4271e-02_r8/)
      kao(:, 5, 5,12) = (/ &
     &6.1168e-02_r8,5.3666e-02_r8,4.5385e-02_r8,3.6131e-02_r8,3.2187e-02_r8,3.6873e-02_r8, &
     &3.0883e-02_r8,3.2443e-02_r8,4.3030e-02_r8/)
      kao(:, 1, 6,12) = (/ &
     &3.3296e-01_r8,2.9114e-01_r8,2.4975e-01_r8,2.0812e-01_r8,1.6650e-01_r8,1.2577e-01_r8, &
     &8.4465e-02_r8,4.3210e-02_r8,7.5744e-03_r8/)
      kao(:, 2, 6,12) = (/ &
     &3.2661e-01_r8,2.8604e-01_r8,2.4502e-01_r8,2.0429e-01_r8,1.6474e-01_r8,1.2400e-01_r8, &
     &8.4046e-02_r8,4.3324e-02_r8,1.2737e-02_r8/)
      kao(:, 3, 6,12) = (/ &
     &3.3274e-01_r8,2.9155e-01_r8,2.4958e-01_r8,2.1022e-01_r8,1.6841e-01_r8,1.2817e-01_r8, &
     &8.5832e-02_r8,4.1156e-02_r8,1.9272e-02_r8/)
      kao(:, 4, 6,12) = (/ &
     &3.2428e-01_r8,2.8378e-01_r8,2.4307e-01_r8,2.0420e-01_r8,1.6451e-01_r8,1.2138e-01_r8, &
     &7.6212e-02_r8,3.3602e-02_r8,2.1893e-02_r8/)
      kao(:, 5, 6,12) = (/ &
     &2.8830e-01_r8,2.5208e-01_r8,2.1788e-01_r8,1.7562e-01_r8,1.3634e-01_r8,9.6797e-02_r8, &
     &6.1659e-02_r8,2.8996e-02_r8,3.3943e-02_r8/)
      kao(:, 1, 7,12) = (/ &
     &7.1633e-01_r8,6.2687e-01_r8,5.3652e-01_r8,4.4712e-01_r8,3.5797e-01_r8,2.6845e-01_r8, &
     &1.7938e-01_r8,9.0924e-02_r8,9.7506e-03_r8/)
      kao(:, 2, 7,12) = (/ &
     &7.4602e-01_r8,6.5233e-01_r8,5.5949e-01_r8,4.6595e-01_r8,3.7278e-01_r8,2.7940e-01_r8, &
     &1.8898e-01_r8,9.6146e-02_r8,1.9089e-02_r8/)
      kao(:, 3, 7,12) = (/ &
     &7.5756e-01_r8,6.6287e-01_r8,5.6888e-01_r8,4.7384e-01_r8,3.7881e-01_r8,2.8626e-01_r8, &
     &1.9222e-01_r8,9.8080e-02_r8,1.5850e-02_r8/)
      kao(:, 4, 7,12) = (/ &
     &7.2210e-01_r8,6.3187e-01_r8,5.4195e-01_r8,4.5134e-01_r8,3.6428e-01_r8,2.7503e-01_r8, &
     &1.8532e-01_r8,9.5998e-02_r8,2.2744e-02_r8/)
      kao(:, 5, 7,12) = (/ &
     &7.1833e-01_r8,6.2908e-01_r8,5.3886e-01_r8,4.4907e-01_r8,3.6079e-01_r8,2.7147e-01_r8, &
     &1.8148e-01_r8,9.1961e-02_r8,3.2788e-02_r8/)
      kao(:, 1, 8,12) = (/ &
     &1.8651e+00_r8,1.6319e+00_r8,1.3988e+00_r8,1.1656e+00_r8,9.3248e-01_r8,6.9936e-01_r8, &
     &4.6627e-01_r8,2.3315e-01_r8,7.1174e-06_r8/)
      kao(:, 2, 8,12) = (/ &
     &1.9142e+00_r8,1.6730e+00_r8,1.4347e+00_r8,1.1964e+00_r8,9.5588e-01_r8,7.1697e-01_r8, &
     &4.7797e-01_r8,2.4089e-01_r8,1.3089e-05_r8/)
      kao(:, 3, 8,12) = (/ &
     &1.9338e+00_r8,1.6922e+00_r8,1.4504e+00_r8,1.2080e+00_r8,9.6694e-01_r8,7.2522e-01_r8, &
     &4.8350e-01_r8,2.4403e-01_r8,6.4382e-03_r8/)
      kao(:, 4, 8,12) = (/ &
     &1.9257e+00_r8,1.6851e+00_r8,1.4444e+00_r8,1.2027e+00_r8,9.6352e-01_r8,7.2222e-01_r8, &
     &4.8580e-01_r8,2.4642e-01_r8,2.0202e-02_r8/)
      kao(:, 5, 8,12) = (/ &
     &1.8578e+00_r8,1.6228e+00_r8,1.3921e+00_r8,1.1585e+00_r8,9.2745e-01_r8,6.9620e-01_r8, &
     &4.7147e-01_r8,2.4294e-01_r8,3.5578e-02_r8/)
      kao(:, 1, 9,12) = (/ &
     &8.9732e+00_r8,7.8574e+00_r8,6.7348e+00_r8,5.6085e+00_r8,4.4901e+00_r8,3.3675e+00_r8, &
     &2.2449e+00_r8,1.1217e+00_r8,5.5128e-06_r8/)
      kao(:, 2, 9,12) = (/ &
     &9.0176e+00_r8,7.8899e+00_r8,6.7555e+00_r8,5.6293e+00_r8,4.5061e+00_r8,3.3798e+00_r8, &
     &2.2531e+00_r8,1.1272e+00_r8,1.0749e-05_r8/)
      kao(:, 3, 9,12) = (/ &
     &9.1462e+00_r8,8.0080e+00_r8,6.8640e+00_r8,5.7226e+00_r8,4.5733e+00_r8,3.4343e+00_r8, &
     &2.2880e+00_r8,1.1452e+00_r8,1.7030e-05_r8/)
      kao(:, 4, 9,12) = (/ &
     &9.3997e+00_r8,8.2308e+00_r8,7.0500e+00_r8,5.8749e+00_r8,4.7035e+00_r8,3.5295e+00_r8, &
     &2.3500e+00_r8,1.1750e+00_r8,2.7289e-05_r8/)
      kao(:, 5, 9,12) = (/ &
     &9.4496e+00_r8,8.2622e+00_r8,7.0818e+00_r8,5.9018e+00_r8,4.7215e+00_r8,3.5410e+00_r8, &
     &2.3622e+00_r8,1.1804e+00_r8,4.0208e-05_r8/)
      kao(:, 1,10,12) = (/ &
     &4.7340e+01_r8,4.1390e+01_r8,3.5503e+01_r8,2.9570e+01_r8,2.3638e+01_r8,1.7753e+01_r8, &
     &1.1835e+01_r8,5.9140e+00_r8,4.0857e-06_r8/)
      kao(:, 2,10,12) = (/ &
     &4.7468e+01_r8,4.1532e+01_r8,3.5600e+01_r8,2.9666e+01_r8,2.3733e+01_r8,1.7801e+01_r8, &
     &1.1867e+01_r8,5.9335e+00_r8,7.3318e-06_r8/)
      kao(:, 3,10,12) = (/ &
     &4.7779e+01_r8,4.1808e+01_r8,3.5836e+01_r8,2.9862e+01_r8,2.3890e+01_r8,1.7931e+01_r8, &
     &1.1954e+01_r8,5.9724e+00_r8,1.2287e-05_r8/)
      kao(:, 4,10,12) = (/ &
     &5.0181e+01_r8,4.3911e+01_r8,3.7609e+01_r8,3.1364e+01_r8,2.5077e+01_r8,1.8819e+01_r8, &
     &1.2546e+01_r8,6.2708e+00_r8,2.0136e-05_r8/)
      kao(:, 5,10,12) = (/ &
     &5.0358e+01_r8,4.4054e+01_r8,3.7768e+01_r8,3.1474e+01_r8,2.5199e+01_r8,1.8885e+01_r8, &
     &1.2590e+01_r8,6.2949e+00_r8,3.0786e-05_r8/)
      kao(:, 1,11,12) = (/ &
     &8.8012e+01_r8,7.7091e+01_r8,6.6061e+01_r8,5.5064e+01_r8,4.4041e+01_r8,3.3007e+01_r8, &
     &2.2019e+01_r8,1.1017e+01_r8,3.6494e-06_r8/)
      kao(:, 2,11,12) = (/ &
     &8.9290e+01_r8,7.8045e+01_r8,6.6917e+01_r8,5.5778e+01_r8,4.4669e+01_r8,3.3448e+01_r8, &
     &2.2295e+01_r8,1.1156e+01_r8,6.7273e-06_r8/)
      kao(:, 3,11,12) = (/ &
     &8.6982e+01_r8,7.6115e+01_r8,6.5187e+01_r8,5.4368e+01_r8,4.3469e+01_r8,3.2619e+01_r8, &
     &2.1748e+01_r8,1.0873e+01_r8,1.1236e-05_r8/)
      kao(:, 4,11,12) = (/ &
     &8.9808e+01_r8,7.8580e+01_r8,6.7351e+01_r8,5.6127e+01_r8,4.4937e+01_r8,3.3677e+01_r8, &
     &2.2469e+01_r8,1.1226e+01_r8,1.9240e-05_r8/)
      kao(:, 5,11,12) = (/ &
     &9.0868e+01_r8,7.9552e+01_r8,6.8146e+01_r8,5.6871e+01_r8,4.5498e+01_r8,3.4074e+01_r8, &
     &2.2716e+01_r8,1.1367e+01_r8,2.9192e-05_r8/)
      kao(:, 1,12,12) = (/ &
     &1.1586e+02_r8,1.0129e+02_r8,8.6824e+01_r8,7.2354e+01_r8,5.7931e+01_r8,4.3416e+01_r8, &
     &2.8943e+01_r8,1.4471e+01_r8,2.9778e-06_r8/)
      kao(:, 2,12,12) = (/ &
     &1.1852e+02_r8,1.0370e+02_r8,8.8887e+01_r8,7.4073e+01_r8,5.9259e+01_r8,4.4444e+01_r8, &
     &2.9629e+01_r8,1.4815e+01_r8,6.0415e-06_r8/)
      kao(:, 3,12,12) = (/ &
     &1.1782e+02_r8,1.0310e+02_r8,8.8376e+01_r8,7.3644e+01_r8,5.8951e+01_r8,4.4160e+01_r8, &
     &2.9459e+01_r8,1.4728e+01_r8,1.0435e-05_r8/)
      kao(:, 4,12,12) = (/ &
     &1.1710e+02_r8,1.0244e+02_r8,8.7885e+01_r8,7.3194e+01_r8,5.8621e+01_r8,4.3876e+01_r8, &
     &2.9251e+01_r8,1.4654e+01_r8,1.8188e-05_r8/)
      kao(:, 5,12,12) = (/ &
     &1.1577e+02_r8,1.0131e+02_r8,8.6825e+01_r8,7.2359e+01_r8,5.7901e+01_r8,4.3424e+01_r8, &
     &2.8943e+01_r8,1.4462e+01_r8,2.8178e-05_r8/)
      kao(:, 1,13,12) = (/ &
     &1.1625e+02_r8,1.0180e+02_r8,8.7251e+01_r8,7.2708e+01_r8,5.8118e+01_r8,4.3593e+01_r8, &
     &2.9061e+01_r8,1.4533e+01_r8,2.6097e-06_r8/)
      kao(:, 2,13,12) = (/ &
     &1.1986e+02_r8,1.0483e+02_r8,8.9927e+01_r8,7.4912e+01_r8,5.9931e+01_r8,4.4948e+01_r8, &
     &2.9950e+01_r8,1.4982e+01_r8,4.5705e-06_r8/)
      kao(:, 3,13,12) = (/ &
     &1.1859e+02_r8,1.0377e+02_r8,8.8940e+01_r8,7.4121e+01_r8,5.9293e+01_r8,4.4471e+01_r8, &
     &2.9646e+01_r8,1.4823e+01_r8,9.6333e-06_r8/)
      kao(:, 4,13,12) = (/ &
     &1.1553e+02_r8,1.0103e+02_r8,8.6643e+01_r8,7.2158e+01_r8,5.7729e+01_r8,4.3335e+01_r8, &
     &2.8881e+01_r8,1.4445e+01_r8,1.6615e-05_r8/)
      kao(:, 5,13,12) = (/ &
     &1.1521e+02_r8,1.0087e+02_r8,8.6350e+01_r8,7.1959e+01_r8,5.7620e+01_r8,4.3214e+01_r8, &
     &2.8812e+01_r8,1.4383e+01_r8,2.5689e-05_r8/)
      kao(:, 1, 1,13) = (/ &
     &1.2352e-03_r8,5.0775e-03_r8,9.0568e-03_r8,9.6608e-03_r8,1.7051e-02_r8,2.9171e-02_r8, &
     &3.4997e-02_r8,4.0847e-02_r8,3.4367e-02_r8/)
      kao(:, 2, 1,13) = (/ &
     &1.2435e-03_r8,6.8803e-03_r8,1.1829e-02_r8,1.3668e-02_r8,2.8015e-02_r8,4.0318e-02_r8, &
     &4.8254e-02_r8,5.5929e-02_r8,5.6166e-02_r8/)
      kao(:, 3, 1,13) = (/ &
     &1.2378e-03_r8,7.6901e-03_r8,1.3370e-02_r8,2.0872e-02_r8,4.0011e-02_r8,5.3853e-02_r8, &
     &6.4341e-02_r8,7.4163e-02_r8,8.0135e-02_r8/)
      kao(:, 4, 1,13) = (/ &
     &1.2280e-03_r8,1.0734e-02_r8,1.6343e-02_r8,3.0629e-02_r8,5.6049e-02_r8,6.9850e-02_r8, &
     &8.3340e-02_r8,9.5619e-02_r8,1.1209e-01_r8/)
      kao(:, 5, 1,13) = (/ &
     &1.2088e-03_r8,1.3761e-02_r8,2.1254e-02_r8,4.2402e-02_r8,7.0900e-02_r8,8.8313e-02_r8, &
     &1.0523e-01_r8,1.2032e-01_r8,1.4179e-01_r8/)
      kao(:, 1, 2,13) = (/ &
     &1.7062e-03_r8,5.0744e-03_r8,8.6767e-03_r8,1.3080e-02_r8,1.1607e-02_r8,1.7056e-02_r8, &
     &2.8742e-02_r8,3.5357e-02_r8,2.3747e-02_r8/)
      kao(:, 2, 2,13) = (/ &
     &1.7222e-03_r8,6.7515e-03_r8,1.2374e-02_r8,1.5331e-02_r8,1.8393e-02_r8,2.7370e-02_r8, &
     &4.2648e-02_r8,4.9678e-02_r8,3.7912e-02_r8/)
      kao(:, 3, 2,13) = (/ &
     &1.7299e-03_r8,8.6001e-03_r8,1.6797e-02_r8,2.0526e-02_r8,2.6294e-02_r8,4.1034e-02_r8, &
     &5.7948e-02_r8,6.7295e-02_r8,5.4721e-02_r8/)
      kao(:, 4, 2,13) = (/ &
     &1.7668e-03_r8,1.0879e-02_r8,2.0064e-02_r8,2.7385e-02_r8,3.4476e-02_r8,5.8386e-02_r8, &
     &7.6246e-02_r8,8.8358e-02_r8,7.0573e-02_r8/)
      kao(:, 5, 2,13) = (/ &
     &1.7596e-03_r8,1.1860e-02_r8,2.3664e-02_r8,3.3939e-02_r8,4.8492e-02_r8,7.9884e-02_r8, &
     &9.7519e-02_r8,1.1290e-01_r8,9.7083e-02_r8/)
      kao(:, 1, 3,13) = (/ &
     &3.1651e-03_r8,5.2961e-03_r8,8.5469e-03_r8,1.1513e-02_r8,1.5558e-02_r8,1.4881e-02_r8, &
     &1.6424e-02_r8,2.5024e-02_r8,2.8147e-02_r8/)
      kao(:, 2, 3,13) = (/ &
     &3.3189e-03_r8,8.3809e-03_r8,1.1489e-02_r8,1.6299e-02_r8,2.2221e-02_r8,2.2841e-02_r8, &
     &2.5024e-02_r8,3.8200e-02_r8,3.8233e-02_r8/)
      kao(:, 3, 3,13) = (/ &
     &3.3701e-03_r8,1.1923e-02_r8,1.5036e-02_r8,2.2373e-02_r8,2.6383e-02_r8,3.1900e-02_r8, &
     &3.2997e-02_r8,5.6522e-02_r8,4.6578e-02_r8/)
      kao(:, 4, 3,13) = (/ &
     &3.3871e-03_r8,1.2781e-02_r8,1.7799e-02_r8,2.9758e-02_r8,3.5615e-02_r8,4.1357e-02_r8, &
     &4.8578e-02_r8,7.5987e-02_r8,6.6261e-02_r8/)
      kao(:, 5, 3,13) = (/ &
     &3.3797e-03_r8,1.4220e-02_r8,2.3964e-02_r8,3.5644e-02_r8,4.5626e-02_r8,4.9180e-02_r8, &
     &6.9386e-02_r8,9.9109e-02_r8,8.8310e-02_r8/)
      kao(:, 1, 4,13) = (/ &
     &1.0343e-02_r8,9.0620e-03_r8,1.2015e-02_r8,1.1324e-02_r8,1.3382e-02_r8,1.5654e-02_r8, &
     &1.8625e-02_r8,1.7070e-02_r8,2.1331e-02_r8/)
      kao(:, 2, 4,13) = (/ &
     &6.4226e-03_r8,5.6266e-03_r8,1.6045e-02_r8,1.6336e-02_r8,1.7909e-02_r8,2.2857e-02_r8, &
     &2.5406e-02_r8,2.4740e-02_r8,3.1419e-02_r8/)
      kao(:, 3, 4,13) = (/ &
     &6.5549e-03_r8,5.7385e-03_r8,1.8741e-02_r8,2.0901e-02_r8,2.5444e-02_r8,3.1318e-02_r8, &
     &3.5488e-02_r8,3.2476e-02_r8,4.5848e-02_r8/)
      kao(:, 4, 4,13) = (/ &
     &6.6407e-03_r8,5.8164e-03_r8,2.0962e-02_r8,2.6844e-02_r8,3.4892e-02_r8,4.1403e-02_r8, &
     &4.7653e-02_r8,4.2426e-02_r8,6.5116e-02_r8/)
      kao(:, 5, 4,13) = (/ &
     &6.8300e-03_r8,1.2571e-02_r8,2.5118e-02_r8,3.2793e-02_r8,4.7122e-02_r8,5.5638e-02_r8, &
     &5.7712e-02_r8,6.2270e-02_r8,8.9700e-02_r8/)
      kao(:, 1, 5,13) = (/ &
     &9.0149e-02_r8,7.8756e-02_r8,6.7503e-02_r8,5.7299e-02_r8,4.6607e-02_r8,3.2042e-02_r8, &
     &2.0392e-02_r8,1.6128e-02_r8,1.9894e-02_r8/)
      kao(:, 2, 5,13) = (/ &
     &4.8191e-02_r8,4.2297e-02_r8,3.6135e-02_r8,3.5890e-02_r8,2.5466e-02_r8,2.2998e-02_r8, &
     &2.3063e-02_r8,2.5066e-02_r8,2.8493e-02_r8/)
      kao(:, 3, 5,13) = (/ &
     &2.0878e-02_r8,1.8444e-02_r8,2.0162e-02_r8,2.6175e-02_r8,2.5330e-02_r8,2.8034e-02_r8, &
     &3.3888e-02_r8,3.5693e-02_r8,3.9583e-02_r8/)
      kao(:, 4, 5,13) = (/ &
     &1.2467e-02_r8,1.0910e-02_r8,2.2261e-02_r8,3.0489e-02_r8,3.2389e-02_r8,3.6918e-02_r8, &
     &4.6126e-02_r8,4.7452e-02_r8,5.4222e-02_r8/)
      kao(:, 5, 5,13) = (/ &
     &1.2730e-02_r8,1.1204e-02_r8,2.9691e-02_r8,3.6357e-02_r8,4.1593e-02_r8,4.9722e-02_r8, &
     &6.1593e-02_r8,5.8372e-02_r8,7.2216e-02_r8/)
      kao(:, 1, 6,13) = (/ &
     &3.3772e-01_r8,2.9577e-01_r8,2.5329e-01_r8,2.1108e-01_r8,1.6887e-01_r8,1.2604e-01_r8, &
     &7.8045e-02_r8,3.5455e-02_r8,1.6952e-02_r8/)
      kao(:, 2, 6,13) = (/ &
     &2.6913e-01_r8,2.3492e-01_r8,2.0161e-01_r8,1.6802e-01_r8,1.3597e-01_r8,9.6507e-02_r8, &
     &6.1842e-02_r8,3.0282e-02_r8,3.2161e-02_r8/)
      kao(:, 3, 6,13) = (/ &
     &1.8198e-01_r8,1.5897e-01_r8,1.3649e-01_r8,1.1355e-01_r8,1.0014e-01_r8,6.6575e-02_r8, &
     &4.2969e-02_r8,3.1778e-02_r8,5.1438e-02_r8/)
      kao(:, 4, 6,13) = (/ &
     &9.5916e-02_r8,8.3628e-02_r8,7.1947e-02_r8,6.5931e-02_r8,5.4714e-02_r8,4.3955e-02_r8, &
     &3.9042e-02_r8,4.5021e-02_r8,5.3865e-02_r8/)
      kao(:, 5, 6,13) = (/ &
     &3.8338e-02_r8,3.3822e-02_r8,2.8989e-02_r8,4.7523e-02_r8,4.4391e-02_r8,4.9375e-02_r8, &
     &5.3458e-02_r8,6.4090e-02_r8,6.5458e-02_r8/)
      kao(:, 1, 7,13) = (/ &
     &8.4065e-01_r8,7.3491e-01_r8,6.3155e-01_r8,5.2581e-01_r8,4.2110e-01_r8,3.1579e-01_r8, &
     &2.1053e-01_r8,1.0597e-01_r8,2.9312e-06_r8/)
      kao(:, 2, 7,13) = (/ &
     &8.3906e-01_r8,7.3475e-01_r8,6.2926e-01_r8,5.2485e-01_r8,4.1990e-01_r8,3.1520e-01_r8, &
     &2.1013e-01_r8,9.8180e-02_r8,5.1556e-06_r8/)
      kao(:, 3, 7,13) = (/ &
     &7.1003e-01_r8,6.2128e-01_r8,5.3203e-01_r8,4.4338e-01_r8,3.5504e-01_r8,2.6905e-01_r8, &
     &1.6926e-01_r8,7.8231e-02_r8,2.0966e-02_r8/)
      kao(:, 4, 7,13) = (/ &
     &5.6430e-01_r8,4.9377e-01_r8,4.2325e-01_r8,3.5272e-01_r8,2.8217e-01_r8,2.1549e-01_r8, &
     &1.3644e-01_r8,6.7355e-02_r8,4.1095e-02_r8/)
      kao(:, 5, 7,13) = (/ &
     &3.6362e-01_r8,3.1751e-01_r8,2.7269e-01_r8,2.2725e-01_r8,1.9431e-01_r8,1.4468e-01_r8, &
     &9.9409e-02_r8,6.2076e-02_r8,6.3795e-02_r8/)
      kao(:, 1, 8,13) = (/ &
     &2.2236e+00_r8,1.9437e+00_r8,1.6676e+00_r8,1.3884e+00_r8,1.1107e+00_r8,8.3381e-01_r8, &
     &5.5588e-01_r8,2.7795e-01_r8,1.5745e-06_r8/)
      kao(:, 2, 8,13) = (/ &
     &2.2078e+00_r8,1.9318e+00_r8,1.6572e+00_r8,1.3798e+00_r8,1.1048e+00_r8,8.2853e-01_r8, &
     &5.5239e-01_r8,2.7779e-01_r8,2.9445e-06_r8/)
      kao(:, 3, 8,13) = (/ &
     &2.2271e+00_r8,1.9469e+00_r8,1.6686e+00_r8,1.3901e+00_r8,1.1125e+00_r8,8.3518e-01_r8, &
     &5.5623e-01_r8,2.8153e-01_r8,5.1096e-06_r8/)
      kao(:, 4, 8,13) = (/ &
     &2.1637e+00_r8,1.8932e+00_r8,1.6227e+00_r8,1.3534e+00_r8,1.0818e+00_r8,8.1139e-01_r8, &
     &5.4287e-01_r8,2.5697e-01_r8,9.9333e-06_r8/)
      kao(:, 5, 8,13) = (/ &
     &1.8021e+00_r8,1.5805e+00_r8,1.3532e+00_r8,1.1288e+00_r8,9.0270e-01_r8,6.7733e-01_r8, &
     &4.5729e-01_r8,2.1399e-01_r8,3.0555e-05_r8/)
      kao(:, 1, 9,13) = (/ &
     &1.0795e+01_r8,9.4461e+00_r8,8.0967e+00_r8,6.7526e+00_r8,5.3928e+00_r8,4.0485e+00_r8, &
     &2.6990e+00_r8,1.3503e+00_r8,8.4365e-07_r8/)
      kao(:, 2, 9,13) = (/ &
     &1.1064e+01_r8,9.6811e+00_r8,8.2980e+00_r8,6.9149e+00_r8,5.5320e+00_r8,4.1492e+00_r8, &
     &2.7660e+00_r8,1.3844e+00_r8,1.6130e-06_r8/)
      kao(:, 3, 9,13) = (/ &
     &1.1399e+01_r8,9.9733e+00_r8,8.5488e+00_r8,7.1204e+00_r8,5.6991e+00_r8,4.2710e+00_r8, &
     &2.8497e+00_r8,1.4241e+00_r8,6.0805e-06_r8/)
      kao(:, 4, 9,13) = (/ &
     &1.1508e+01_r8,1.0061e+01_r8,8.6395e+00_r8,7.1995e+00_r8,5.7491e+00_r8,4.3120e+00_r8, &
     &2.8800e+00_r8,1.4386e+00_r8,1.4128e-05_r8/)
      kao(:, 5, 9,13) = (/ &
     &1.1400e+01_r8,9.9831e+00_r8,8.5576e+00_r8,7.1312e+00_r8,5.7049e+00_r8,4.2787e+00_r8, &
     &2.8526e+00_r8,1.4263e+00_r8,2.6902e-05_r8/)
      kao(:, 1,10,13) = (/ &
     &6.0229e+01_r8,5.2742e+01_r8,4.5172e+01_r8,3.7644e+01_r8,3.0138e+01_r8,2.2585e+01_r8, &
     &1.5057e+01_r8,7.5286e+00_r8,7.1488e-07_r8/)
      kao(:, 2,10,13) = (/ &
     &6.2236e+01_r8,5.4452e+01_r8,4.6675e+01_r8,3.8896e+01_r8,3.1118e+01_r8,2.3338e+01_r8, &
     &1.5559e+01_r8,7.7794e+00_r8,2.2353e-06_r8/)
      kao(:, 3,10,13) = (/ &
     &6.3127e+01_r8,5.5205e+01_r8,4.7321e+01_r8,3.9431e+01_r8,3.1516e+01_r8,2.3656e+01_r8, &
     &1.5745e+01_r8,7.8865e+00_r8,5.3891e-06_r8/)
      kao(:, 4,10,13) = (/ &
     &6.1110e+01_r8,5.3475e+01_r8,4.5823e+01_r8,3.8155e+01_r8,3.0566e+01_r8,2.2893e+01_r8, &
     &1.5262e+01_r8,7.6312e+00_r8,1.1169e-05_r8/)
      kao(:, 5,10,13) = (/ &
     &6.4796e+01_r8,5.6740e+01_r8,4.8597e+01_r8,4.0457e+01_r8,3.2404e+01_r8,2.4299e+01_r8, &
     &1.6199e+01_r8,8.1078e+00_r8,2.0550e-05_r8/)
      kao(:, 1,11,13) = (/ &
     &1.1504e+02_r8,1.0058e+02_r8,8.6129e+01_r8,7.1842e+01_r8,5.7476e+01_r8,4.3140e+01_r8, &
     &2.8738e+01_r8,1.4357e+01_r8,9.3132e-07_r8/)
      kao(:, 2,11,13) = (/ &
     &1.1792e+02_r8,1.0317e+02_r8,8.8507e+01_r8,7.3697e+01_r8,5.8960e+01_r8,4.4221e+01_r8, &
     &2.9502e+01_r8,1.4740e+01_r8,2.4724e-06_r8/)
      kao(:, 3,11,13) = (/ &
     &1.2218e+02_r8,1.0691e+02_r8,9.1705e+01_r8,7.6362e+01_r8,6.1091e+01_r8,4.5817e+01_r8, &
     &3.0544e+01_r8,1.5272e+01_r8,5.4659e-06_r8/)
      kao(:, 4,11,13) = (/ &
     &1.2095e+02_r8,1.0583e+02_r8,9.0715e+01_r8,7.5596e+01_r8,6.0430e+01_r8,4.5404e+01_r8, &
     &3.0213e+01_r8,1.5120e+01_r8,1.0930e-05_r8/)
      kao(:, 5,11,13) = (/ &
     &1.1751e+02_r8,1.0271e+02_r8,8.8136e+01_r8,7.3302e+01_r8,5.8706e+01_r8,4.4021e+01_r8, &
     &2.9378e+01_r8,1.4677e+01_r8,1.9680e-05_r8/)
      kao(:, 1,12,13) = (/ &
     &1.6045e+02_r8,1.4037e+02_r8,1.2031e+02_r8,1.0025e+02_r8,8.0142e+01_r8,6.0153e+01_r8, &
     &4.0104e+01_r8,2.0052e+01_r8,1.7476e-06_r8/)
      kao(:, 2,12,13) = (/ &
     &1.6342e+02_r8,1.4301e+02_r8,1.2246e+02_r8,1.0215e+02_r8,8.1640e+01_r8,6.1227e+01_r8, &
     &4.0821e+01_r8,2.0431e+01_r8,2.4757e-06_r8/)
      kao(:, 3,12,13) = (/ &
     &1.6723e+02_r8,1.4633e+02_r8,1.2542e+02_r8,1.0452e+02_r8,8.3616e+01_r8,6.2709e+01_r8, &
     &4.1810e+01_r8,2.0904e+01_r8,5.2593e-06_r8/)
      kao(:, 4,12,13) = (/ &
     &1.7014e+02_r8,1.4884e+02_r8,1.2747e+02_r8,1.0623e+02_r8,8.4980e+01_r8,6.3783e+01_r8, &
     &4.2524e+01_r8,2.1245e+01_r8,9.8363e-06_r8/)
      kao(:, 5,12,13) = (/ &
     &1.6634e+02_r8,1.4563e+02_r8,1.2476e+02_r8,1.0397e+02_r8,8.3150e+01_r8,6.2327e+01_r8, &
     &4.1610e+01_r8,2.0792e+01_r8,1.5825e-05_r8/)
      kao(:, 1,13,13) = (/ &
     &1.7420e+02_r8,1.5232e+02_r8,1.3056e+02_r8,1.0880e+02_r8,8.7095e+01_r8,6.5324e+01_r8, &
     &4.3550e+01_r8,2.1773e+01_r8,2.0359e-06_r8/)
      kao(:, 2,13,13) = (/ &
     &1.7505e+02_r8,1.5318e+02_r8,1.3125e+02_r8,1.0942e+02_r8,8.7528e+01_r8,6.5649e+01_r8, &
     &4.3765e+01_r8,2.1882e+01_r8,3.6885e-06_r8/)
      kao(:, 3,13,13) = (/ &
     &1.7705e+02_r8,1.5491e+02_r8,1.3279e+02_r8,1.1065e+02_r8,8.8524e+01_r8,6.6391e+01_r8, &
     &4.4262e+01_r8,2.2130e+01_r8,4.3611e-06_r8/)
      kao(:, 4,13,13) = (/ &
     &1.7817e+02_r8,1.5590e+02_r8,1.3363e+02_r8,1.1135e+02_r8,8.9083e+01_r8,6.6758e+01_r8, &
     &4.4540e+01_r8,2.2253e+01_r8,7.0150e-06_r8/)
      kao(:, 5,13,13) = (/ &
     &1.7584e+02_r8,1.5385e+02_r8,1.3199e+02_r8,1.0999e+02_r8,8.7917e+01_r8,6.5939e+01_r8, &
     &4.3996e+01_r8,2.1972e+01_r8,1.1356e-05_r8/)
      kao(:, 1, 1,14) = (/ &
     &1.3576e-03_r8,5.9355e-03_r8,1.2070e-02_r8,3.4616e-02_r8,5.3142e-02_r8,6.5578e-02_r8, &
     &7.6852e-02_r8,8.4718e-02_r8,1.0628e-01_r8/)
      kao(:, 2, 1,14) = (/ &
     &1.4884e-03_r8,6.6850e-03_r8,2.0385e-02_r8,5.2397e-02_r8,7.2846e-02_r8,8.9954e-02_r8, &
     &1.0527e-01_r8,1.1545e-01_r8,1.4569e-01_r8/)
      kao(:, 3, 1,14) = (/ &
     &1.6038e-03_r8,1.0153e-02_r8,3.3679e-02_r8,7.2611e-02_r8,9.6223e-02_r8,1.1901e-01_r8, &
     &1.3945e-01_r8,1.5228e-01_r8,1.9245e-01_r8/)
      kao(:, 4, 1,14) = (/ &
     &1.7044e-03_r8,1.3918e-02_r8,4.9229e-02_r8,9.2925e-02_r8,1.2323e-01_r8,1.5253e-01_r8, &
     &1.7914e-01_r8,1.9539e-01_r8,2.4647e-01_r8/)
      kao(:, 5, 1,14) = (/ &
     &1.8000e-03_r8,1.6377e-02_r8,6.7350e-02_r8,1.1593e-01_r8,1.5369e-01_r8,1.9039e-01_r8, &
     &2.2401e-01_r8,2.4471e-01_r8,3.0739e-01_r8/)
      kao(:, 1, 2,14) = (/ &
     &2.3036e-03_r8,8.1410e-03_r8,1.1112e-02_r8,1.5744e-02_r8,3.9389e-02_r8,5.9885e-02_r8, &
     &7.1149e-02_r8,8.0027e-02_r8,7.8847e-02_r8/)
      kao(:, 2, 2,14) = (/ &
     &2.5134e-03_r8,1.3270e-02_r8,1.6290e-02_r8,2.9767e-02_r8,5.8863e-02_r8,8.3096e-02_r8, &
     &9.8866e-02_r8,1.1160e-01_r8,1.1776e-01_r8/)
      kao(:, 3, 2,14) = (/ &
     &2.6930e-03_r8,1.4292e-02_r8,1.9903e-02_r8,4.6191e-02_r8,8.3472e-02_r8,1.1096e-01_r8, &
     &1.3216e-01_r8,1.4974e-01_r8,1.6719e-01_r8/)
      kao(:, 4, 2,14) = (/ &
     &2.7875e-03_r8,1.4114e-02_r8,2.4277e-02_r8,6.6428e-02_r8,1.1553e-01_r8,1.4377e-01_r8, &
     &1.7103e-01_r8,1.9428e-01_r8,2.3106e-01_r8/)
      kao(:, 5, 2,14) = (/ &
     &2.8719e-03_r8,1.9476e-02_r8,3.5900e-02_r8,9.2156e-02_r8,1.4592e-01_r8,1.8154e-01_r8, &
     &2.1576e-01_r8,2.4502e-01_r8,2.9183e-01_r8/)
      kao(:, 1, 3,14) = (/ &
     &5.1130e-03_r8,4.4754e-03_r8,1.7095e-02_r8,1.4542e-02_r8,2.0610e-02_r8,2.6947e-02_r8, &
     &5.0520e-02_r8,6.8277e-02_r8,4.1188e-02_r8/)
      kao(:, 2, 3,14) = (/ &
     &5.4209e-03_r8,4.7463e-03_r8,2.5747e-02_r8,2.2058e-02_r8,2.5589e-02_r8,4.5664e-02_r8, &
     &7.6140e-02_r8,9.7102e-02_r8,5.5959e-02_r8/)
      kao(:, 3, 3,14) = (/ &
     &5.7296e-03_r8,5.0218e-03_r8,2.3801e-02_r8,3.0343e-02_r8,3.8012e-02_r8,6.9885e-02_r8, &
     &1.1346e-01_r8,1.3263e-01_r8,8.0840e-02_r8/)
      kao(:, 4, 3,14) = (/ &
     &5.9993e-03_r8,9.9078e-03_r8,3.1169e-02_r8,3.4849e-02_r8,5.4434e-02_r8,1.0180e-01_r8, &
     &1.5168e-01_r8,1.7523e-01_r8,1.1385e-01_r8/)
      kao(:, 5, 3,14) = (/ &
     &6.2420e-03_r8,1.8221e-02_r8,3.8314e-02_r8,4.8056e-02_r8,8.0195e-02_r8,1.4525e-01_r8, &
     &1.9539e-01_r8,2.2499e-01_r8,1.6255e-01_r8/)
      kao(:, 1, 4,14) = (/ &
     &1.0992e-02_r8,9.6146e-03_r8,8.2555e-03_r8,1.9598e-02_r8,2.6210e-02_r8,2.3069e-02_r8, &
     &2.4334e-02_r8,4.0918e-02_r8,4.3847e-02_r8/)
      kao(:, 2, 4,14) = (/ &
     &1.1861e-02_r8,1.0380e-02_r8,8.8997e-03_r8,3.1372e-02_r8,3.1071e-02_r8,3.3427e-02_r8, &
     &3.7533e-02_r8,6.6384e-02_r8,5.4303e-02_r8/)
      kao(:, 3, 4,14) = (/ &
     &1.2630e-02_r8,1.1058e-02_r8,1.5158e-02_r8,4.6362e-02_r8,4.1015e-02_r8,4.0980e-02_r8, &
     &5.2909e-02_r8,1.0322e-01_r8,7.5185e-02_r8/)
      kao(:, 4, 4,14) = (/ &
     &1.3324e-02_r8,1.1665e-02_r8,2.8664e-02_r8,4.2673e-02_r8,5.2993e-02_r8,5.8606e-02_r8, &
     &7.8441e-02_r8,1.5172e-01_r8,9.8036e-02_r8/)
      kao(:, 5, 4,14) = (/ &
     &1.3148e-02_r8,1.1477e-02_r8,4.1837e-02_r8,5.5479e-02_r8,6.7238e-02_r8,7.8671e-02_r8, &
     &1.1999e-01_r8,1.9993e-01_r8,1.2716e-01_r8/)
      kao(:, 1, 5,14) = (/ &
     &2.2062e-02_r8,1.9303e-02_r8,1.6547e-02_r8,1.3790e-02_r8,1.9210e-02_r8,3.4370e-02_r8, &
     &2.6360e-02_r8,2.4628e-02_r8,2.1281e-02_r8/)
      kao(:, 2, 5,14) = (/ &
     &2.4016e-02_r8,2.1018e-02_r8,1.8036e-02_r8,1.5017e-02_r8,3.4207e-02_r8,3.8549e-02_r8, &
     &3.6828e-02_r8,3.7924e-02_r8,4.8887e-02_r8/)
      kao(:, 3, 5,14) = (/ &
     &2.4307e-02_r8,2.1199e-02_r8,1.8170e-02_r8,2.0814e-02_r8,5.1440e-02_r8,4.8654e-02_r8, &
     &5.0226e-02_r8,5.5730e-02_r8,8.3554e-02_r8/)
      kao(:, 4, 5,14) = (/ &
     &2.3589e-02_r8,2.0645e-02_r8,1.7700e-02_r8,3.6957e-02_r8,7.2673e-02_r8,6.2587e-02_r8, &
     &6.6284e-02_r8,7.5553e-02_r8,1.2501e-01_r8/)
      kao(:, 5, 5,14) = (/ &
     &2.3359e-02_r8,2.0344e-02_r8,1.7524e-02_r8,5.3828e-02_r8,7.8003e-02_r8,7.9260e-02_r8, &
     &8.5892e-02_r8,1.2047e-01_r8,1.2633e-01_r8/)
      kao(:, 1, 6,14) = (/ &
     &4.0073e-02_r8,3.4956e-02_r8,2.9962e-02_r8,2.4964e-02_r8,1.9975e-02_r8,1.9358e-02_r8, &
     &3.3916e-02_r8,2.3741e-02_r8,4.4372e-06_r8/)
      kao(:, 2, 6,14) = (/ &
     &4.0377e-02_r8,3.5184e-02_r8,3.0162e-02_r8,2.5240e-02_r8,2.0191e-02_r8,3.6273e-02_r8, &
     &4.6417e-02_r8,3.4541e-02_r8,7.2649e-06_r8/)
      kao(:, 3, 6,14) = (/ &
     &4.0665e-02_r8,3.5540e-02_r8,3.0502e-02_r8,2.5425e-02_r8,2.0338e-02_r8,5.3239e-02_r8, &
     &5.4545e-02_r8,5.0382e-02_r8,1.1617e-05_r8/)
      kao(:, 4, 6,14) = (/ &
     &4.0830e-02_r8,3.5726e-02_r8,3.0620e-02_r8,2.5522e-02_r8,4.1685e-02_r8,7.6060e-02_r8, &
     &6.8633e-02_r8,6.7501e-02_r8,4.8322e-02_r8/)
      kao(:, 5, 6,14) = (/ &
     &4.0974e-02_r8,3.5852e-02_r8,3.0742e-02_r8,2.5614e-02_r8,6.3799e-02_r8,1.0670e-01_r8, &
     &8.5712e-02_r8,8.9786e-02_r8,9.4019e-02_r8/)
      kao(:, 1, 7,14) = (/ &
     &3.5883e-01_r8,3.1506e-01_r8,2.6911e-01_r8,2.2518e-01_r8,1.7880e-01_r8,1.3456e-01_r8, &
     &8.9710e-02_r8,5.4606e-02_r8,2.4375e-06_r8/)
      kao(:, 2, 7,14) = (/ &
     &1.1133e-01_r8,9.7402e-02_r8,8.3516e-02_r8,6.9576e-02_r8,5.5665e-02_r8,4.1750e-02_r8, &
     &3.4893e-02_r8,3.9977e-02_r8,4.2861e-06_r8/)
      kao(:, 3, 7,14) = (/ &
     &7.4556e-02_r8,6.5240e-02_r8,5.5921e-02_r8,4.6603e-02_r8,3.7275e-02_r8,2.7967e-02_r8, &
     &5.4564e-02_r8,5.0979e-02_r8,7.1669e-06_r8/)
      kao(:, 4, 7,14) = (/ &
     &7.6453e-02_r8,6.6897e-02_r8,5.7506e-02_r8,4.7791e-02_r8,3.8237e-02_r8,4.2981e-02_r8, &
     &7.9842e-02_r8,6.6791e-02_r8,1.1410e-05_r8/)
      kao(:, 5, 7,14) = (/ &
     &7.6151e-02_r8,6.6633e-02_r8,5.7121e-02_r8,4.7606e-02_r8,3.8095e-02_r8,6.8563e-02_r8, &
     &1.1205e-01_r8,9.1020e-02_r8,1.8778e-05_r8/)
      kao(:, 1, 8,14) = (/ &
     &1.6212e+00_r8,1.4215e+00_r8,1.2160e+00_r8,1.0153e+00_r8,8.1222e-01_r8,6.0796e-01_r8, &
     &4.0531e-01_r8,2.0267e-01_r8,1.3659e-06_r8/)
      kao(:, 2, 8,14) = (/ &
     &1.0949e+00_r8,9.5809e-01_r8,8.2118e-01_r8,6.8434e-01_r8,5.4744e-01_r8,4.1058e-01_r8, &
     &2.7374e-01_r8,1.3687e-01_r8,2.5240e-06_r8/)
      kao(:, 3, 8,14) = (/ &
     &5.4276e-01_r8,4.7782e-01_r8,4.0969e-01_r8,3.4354e-01_r8,2.7305e-01_r8,2.0349e-01_r8, &
     &1.3658e-01_r8,8.0855e-02_r8,4.4900e-06_r8/)
      kao(:, 4, 8,14) = (/ &
     &1.6665e-01_r8,1.4583e-01_r8,1.2498e-01_r8,1.0416e-01_r8,8.3314e-02_r8,6.2486e-02_r8, &
     &4.1670e-02_r8,8.3057e-02_r8,7.7801e-06_r8/)
      kao(:, 5, 8,14) = (/ &
     &1.6956e-01_r8,1.4835e-01_r8,1.2718e-01_r8,1.0598e-01_r8,8.5407e-02_r8,6.3592e-02_r8, &
     &5.5348e-02_r8,1.2090e-01_r8,1.2725e-05_r8/)
      kao(:, 1, 9,14) = (/ &
     &1.1544e+01_r8,1.0088e+01_r8,8.6483e+00_r8,7.2069e+00_r8,5.7730e+00_r8,4.3233e+00_r8, &
     &2.8823e+00_r8,1.4419e+00_r8,7.6692e-07_r8/)
      kao(:, 2, 9,14) = (/ &
     &9.0308e+00_r8,7.9019e+00_r8,6.7729e+00_r8,5.6441e+00_r8,4.5156e+00_r8,3.3865e+00_r8, &
     &2.2577e+00_r8,1.1268e+00_r8,1.4786e-06_r8/)
      kao(:, 3, 9,14) = (/ &
     &6.2830e+00_r8,5.4975e+00_r8,4.7120e+00_r8,3.9269e+00_r8,3.1414e+00_r8,2.3561e+00_r8, &
     &1.5707e+00_r8,7.8536e-01_r8,2.7689e-06_r8/)
      kao(:, 4, 9,14) = (/ &
     &3.6304e+00_r8,3.1764e+00_r8,2.7089e+00_r8,2.2550e+00_r8,1.8152e+00_r8,1.3614e+00_r8, &
     &9.0300e-01_r8,4.5381e-01_r8,4.9167e-06_r8/)
      kao(:, 5, 9,14) = (/ &
     &1.4890e+00_r8,1.3035e+00_r8,1.1168e+00_r8,9.3072e-01_r8,7.4457e-01_r8,5.5869e-01_r8, &
     &3.7227e-01_r8,1.8616e-01_r8,8.2396e-06_r8/)
      kao(:, 1,10,14) = (/ &
     &7.2198e+01_r8,6.3175e+01_r8,5.4150e+01_r8,4.5125e+01_r8,3.6100e+01_r8,2.7075e+01_r8, &
     &1.8050e+01_r8,9.0251e+00_r8,4.5184e-07_r8/)
      kao(:, 2,10,14) = (/ &
     &6.4999e+01_r8,5.6876e+01_r8,4.8750e+01_r8,4.0625e+01_r8,3.2499e+01_r8,2.4375e+01_r8, &
     &1.6250e+01_r8,8.1250e+00_r8,9.0060e-07_r8/)
      kao(:, 3,10,14) = (/ &
     &5.3041e+01_r8,4.6463e+01_r8,3.9827e+01_r8,3.3188e+01_r8,2.6599e+01_r8,1.9891e+01_r8, &
     &1.3300e+01_r8,6.6377e+00_r8,1.7393e-06_r8/)
      kao(:, 4,10,14) = (/ &
     &4.2448e+01_r8,3.7144e+01_r8,3.1913e+01_r8,2.6594e+01_r8,2.1225e+01_r8,1.5957e+01_r8, &
     &1.0638e+01_r8,5.3187e+00_r8,3.1449e-06_r8/)
      kao(:, 5,10,14) = (/ &
     &2.5727e+01_r8,2.2511e+01_r8,1.9295e+01_r8,1.6144e+01_r8,1.2810e+01_r8,9.6477e+00_r8, &
     &6.4321e+00_r8,3.2028e+00_r8,5.3500e-06_r8/)
      kao(:, 1,11,14) = (/ &
     &1.4503e+02_r8,1.2691e+02_r8,1.0890e+02_r8,9.0641e+01_r8,7.2517e+01_r8,5.4390e+01_r8, &
     &3.6259e+01_r8,1.8129e+01_r8,3.6866e-07_r8/)
      kao(:, 2,11,14) = (/ &
     &1.4340e+02_r8,1.2547e+02_r8,1.0755e+02_r8,8.9629e+01_r8,7.1700e+01_r8,5.3764e+01_r8, &
     &3.5851e+01_r8,1.7926e+01_r8,7.4257e-07_r8/)
      kao(:, 3,11,14) = (/ &
     &1.2279e+02_r8,1.0744e+02_r8,9.2097e+01_r8,7.6747e+01_r8,6.1397e+01_r8,4.6046e+01_r8, &
     &3.0699e+01_r8,1.5350e+01_r8,1.4132e-06_r8/)
      kao(:, 4,11,14) = (/ &
     &1.0332e+02_r8,9.0407e+01_r8,7.7495e+01_r8,6.4577e+01_r8,5.1661e+01_r8,3.8673e+01_r8, &
     &2.5832e+01_r8,1.2916e+01_r8,2.5660e-06_r8/)
      kao(:, 5,11,14) = (/ &
     &8.4752e+01_r8,7.4338e+01_r8,6.3562e+01_r8,5.3097e+01_r8,4.2377e+01_r8,3.1859e+01_r8, &
     &2.1189e+01_r8,1.0594e+01_r8,4.3954e-06_r8/)
      kao(:, 1,12,14) = (/ &
     &2.1206e+02_r8,1.8578e+02_r8,1.5923e+02_r8,1.3269e+02_r8,1.0615e+02_r8,7.9613e+01_r8, &
     &5.3076e+01_r8,2.6538e+01_r8,2.9519e-07_r8/)
      kao(:, 2,12,14) = (/ &
     &2.1371e+02_r8,1.8696e+02_r8,1.6019e+02_r8,1.3354e+02_r8,1.0696e+02_r8,8.0220e+01_r8, &
     &5.3478e+01_r8,2.6706e+01_r8,5.9412e-07_r8/)
      kao(:, 3,12,14) = (/ &
     &1.9963e+02_r8,1.7467e+02_r8,1.4971e+02_r8,1.2476e+02_r8,9.9809e+01_r8,7.4861e+01_r8, &
     &4.9906e+01_r8,2.4953e+01_r8,1.1512e-06_r8/)
      kao(:, 4,12,14) = (/ &
     &1.7291e+02_r8,1.5155e+02_r8,1.2989e+02_r8,1.0824e+02_r8,8.6596e+01_r8,6.4945e+01_r8, &
     &4.3297e+01_r8,2.1649e+01_r8,2.0935e-06_r8/)
      kao(:, 5,12,14) = (/ &
     &1.4993e+02_r8,1.3106e+02_r8,1.1245e+02_r8,9.3704e+01_r8,7.4891e+01_r8,5.6224e+01_r8, &
     &3.7445e+01_r8,1.8742e+01_r8,5.3426e-06_r8/)
      kao(:, 1,13,14) = (/ &
     &2.3337e+02_r8,2.0357e+02_r8,1.7476e+02_r8,1.4563e+02_r8,1.1651e+02_r8,8.7377e+01_r8, &
     &5.8250e+01_r8,2.9126e+01_r8,2.3044e-07_r8/)
      kao(:, 2,13,14) = (/ &
     &2.3770e+02_r8,2.0799e+02_r8,1.7827e+02_r8,1.4856e+02_r8,1.1885e+02_r8,8.9136e+01_r8, &
     &5.9426e+01_r8,2.9711e+01_r8,4.7533e-07_r8/)
      kao(:, 3,13,14) = (/ &
     &2.3937e+02_r8,2.0945e+02_r8,1.7953e+02_r8,1.4961e+02_r8,1.1968e+02_r8,8.9763e+01_r8, &
     &5.9841e+01_r8,2.9920e+01_r8,1.2740e-06_r8/)
      kao(:, 4,13,14) = (/ &
     &2.1343e+02_r8,1.8675e+02_r8,1.6007e+02_r8,1.3339e+02_r8,1.0671e+02_r8,8.0033e+01_r8, &
     &5.3356e+01_r8,2.6677e+01_r8,3.7441e-06_r8/)
      kao(:, 5,13,14) = (/ &
     &1.8434e+02_r8,1.6130e+02_r8,1.3825e+02_r8,1.1521e+02_r8,9.2167e+01_r8,6.9126e+01_r8, &
     &4.6084e+01_r8,2.3083e+01_r8,8.0408e-06_r8/)
      kao(:, 1, 1,15) = (/ &
     &4.3757e-04_r8,1.7661e-02_r8,6.5219e-02_r8,9.6736e-02_r8,1.2696e-01_r8,1.5472e-01_r8, &
     &1.7677e-01_r8,1.8124e-01_r8,2.5391e-01_r8/)
      kao(:, 2, 1,15) = (/ &
     &4.7244e-04_r8,2.2315e-02_r8,8.7744e-02_r8,1.3008e-01_r8,1.7055e-01_r8,2.0764e-01_r8, &
     &2.3757e-01_r8,2.4446e-01_r8,3.4110e-01_r8/)
      kao(:, 3, 1,15) = (/ &
     &4.9936e-04_r8,3.5467e-02_r8,1.1452e-01_r8,1.6964e-01_r8,2.2220e-01_r8,2.7019e-01_r8, &
     &3.0873e-01_r8,3.1867e-01_r8,4.4441e-01_r8/)
      kao(:, 4, 1,15) = (/ &
     &5.2088e-04_r8,5.0547e-02_r8,1.4538e-01_r8,2.1535e-01_r8,2.8212e-01_r8,3.4264e-01_r8, &
     &3.9053e-01_r8,4.0360e-01_r8,5.6424e-01_r8/)
      kao(:, 5, 1,15) = (/ &
     &5.3484e-04_r8,7.2405e-02_r8,1.8030e-01_r8,2.6712e-01_r8,3.4967e-01_r8,4.2472e-01_r8, &
     &4.8331e-01_r8,4.9868e-01_r8,6.9933e-01_r8/)
      kao(:, 1, 2,15) = (/ &
     &5.8930e-04_r8,5.2056e-04_r8,3.8823e-02_r8,9.4547e-02_r8,1.2473e-01_r8,1.5329e-01_r8, &
     &1.7814e-01_r8,1.9186e-01_r8,2.4946e-01_r8/)
      kao(:, 2, 2,15) = (/ &
     &6.3170e-04_r8,5.6011e-04_r8,6.0488e-02_r8,1.2953e-01_r8,1.7093e-01_r8,2.0982e-01_r8, &
     &2.4359e-01_r8,2.6142e-01_r8,3.4185e-01_r8/)
      kao(:, 3, 2,15) = (/ &
     &6.6396e-04_r8,1.3947e-02_r8,9.3321e-02_r8,1.7148e-01_r8,2.2617e-01_r8,2.7768e-01_r8, &
     &3.2205e-01_r8,3.4444e-01_r8,4.5233e-01_r8/)
      kao(:, 4, 2,15) = (/ &
     &6.8779e-04_r8,3.2900e-02_r8,1.4029e-01_r8,2.2027e-01_r8,2.9047e-01_r8,3.5662e-01_r8, &
     &4.1356e-01_r8,4.4128e-01_r8,5.8094e-01_r8/)
      kao(:, 5, 2,15) = (/ &
     &7.0403e-04_r8,3.1909e-02_r8,1.8526e-01_r8,2.7582e-01_r8,3.6375e-01_r8,4.4666e-01_r8, &
     &5.1781e-01_r8,5.5205e-01_r8,7.2748e-01_r8/)
      kao(:, 1, 3,15) = (/ &
     &1.0314e-03_r8,9.3537e-04_r8,7.8009e-04_r8,3.5190e-02_r8,7.8660e-02_r8,1.3993e-01_r8, &
     &1.6539e-01_r8,1.8481e-01_r8,1.5700e-01_r8/)
      kao(:, 2, 3,15) = (/ &
     &1.1044e-03_r8,9.7099e-04_r8,3.0472e-03_r8,6.2470e-02_r8,1.3066e-01_r8,1.9656e-01_r8, &
     &2.3229e-01_r8,2.5938e-01_r8,2.6190e-01_r8/)
      kao(:, 3, 3,15) = (/ &
     &1.1610e-03_r8,1.0227e-03_r8,3.8685e-02_r8,9.5707e-02_r8,2.0189e-01_r8,2.6560e-01_r8, &
     &3.1379e-01_r8,3.5039e-01_r8,4.0559e-01_r8/)
      kao(:, 4, 3,15) = (/ &
     &1.1999e-03_r8,1.0620e-03_r8,6.9192e-02_r8,1.4962e-01_r8,2.7976e-01_r8,3.4701e-01_r8, &
     &4.1016e-01_r8,4.5806e-01_r8,5.5953e-01_r8/)
      kao(:, 5, 3,15) = (/ &
     &1.2331e-03_r8,1.0899e-03_r8,6.4034e-02_r8,2.1379e-01_r8,3.5531e-01_r8,4.4075e-01_r8, &
     &5.2094e-01_r8,5.8205e-01_r8,7.1061e-01_r8/)
      kao(:, 1, 4,15) = (/ &
     &1.8101e-03_r8,1.5857e-03_r8,1.3614e-03_r8,1.1362e-03_r8,2.5114e-02_r8,5.7242e-02_r8, &
     &1.1151e-01_r8,1.6445e-01_r8,5.0940e-02_r8/)
      kao(:, 2, 4,15) = (/ &
     &1.9417e-03_r8,1.7009e-03_r8,1.4618e-03_r8,1.2222e-03_r8,6.6639e-02_r8,9.6622e-02_r8, &
     &1.8463e-01_r8,2.3787e-01_r8,1.3472e-01_r8/)
      kao(:, 3, 4,15) = (/ &
     &2.0504e-03_r8,1.7934e-03_r8,1.5465e-03_r8,1.2907e-03_r8,6.6457e-02_r8,1.6526e-01_r8, &
     &2.8062e-01_r8,3.2903e-01_r8,1.3147e-01_r8/)
      kao(:, 4, 4,15) = (/ &
     &2.1280e-03_r8,1.8660e-03_r8,1.6076e-03_r8,5.7880e-02_r8,1.0798e-01_r8,2.4822e-01_r8, &
     &3.8266e-01_r8,4.3856e-01_r8,2.1657e-01_r8/)
      kao(:, 5, 4,15) = (/ &
     &3.4223e-03_r8,3.1028e-03_r8,2.6690e-03_r8,1.0905e-01_r8,1.5760e-01_r8,3.4585e-01_r8, &
     &4.9399e-01_r8,5.6645e-01_r8,3.1389e-01_r8/)
      kao(:, 1, 5,15) = (/ &
     &2.8907e-03_r8,2.5398e-03_r8,2.1780e-03_r8,1.8164e-03_r8,1.4541e-03_r8,1.0940e-03_r8, &
     &7.0483e-02_r8,1.0515e-01_r8,9.1867e-06_r8/)
      kao(:, 2, 5,15) = (/ &
     &3.1254e-03_r8,2.7393e-03_r8,2.3477e-03_r8,1.9606e-03_r8,1.5698e-03_r8,3.9518e-02_r8, &
     &7.4031e-02_r8,1.7523e-01_r8,1.5406e-05_r8/)
      kao(:, 3, 5,15) = (/ &
     &6.7235e-03_r8,5.8882e-03_r8,5.0497e-03_r8,4.2126e-03_r8,3.3747e-03_r8,9.4974e-02_r8, &
     &1.2240e-01_r8,2.6835e-01_r8,2.4302e-05_r8/)
      kao(:, 4, 5,15) = (/ &
     &1.0699e-02_r8,9.3645e-03_r8,8.0383e-03_r8,6.6993e-03_r8,5.3674e-03_r8,1.6163e-01_r8, &
     &2.1236e-01_r8,3.9941e-01_r8,3.6217e-05_r8/)
      kao(:, 5, 5,15) = (/ &
     &1.3717e-02_r8,1.2003e-02_r8,1.0303e-02_r8,8.5901e-03_r8,7.6360e-02_r8,1.2908e-01_r8, &
     &3.1926e-01_r8,5.2644e-01_r8,1.7649e-01_r8/)
      kao(:, 1, 6,15) = (/ &
     &8.1592e-03_r8,7.4369e-03_r8,6.3758e-03_r8,5.3146e-03_r8,4.2520e-03_r8,3.1909e-03_r8, &
     &2.1298e-03_r8,5.0122e-02_r8,5.2510e-06_r8/)
      kao(:, 2, 6,15) = (/ &
     &1.6119e-02_r8,1.4482e-02_r8,1.2421e-02_r8,1.0082e-02_r8,8.0668e-03_r8,6.0513e-03_r8, &
     &2.1472e-02_r8,7.5343e-02_r8,9.3553e-06_r8/)
      kao(:, 3, 6,15) = (/ &
     &2.2594e-02_r8,1.9767e-02_r8,1.6948e-02_r8,1.4132e-02_r8,1.1307e-02_r8,8.4832e-03_r8, &
     &8.7408e-02_r8,1.3678e-01_r8,1.5081e-05_r8/)
      kao(:, 4, 6,15) = (/ &
     &2.8287e-02_r8,2.4765e-02_r8,2.1227e-02_r8,1.7693e-02_r8,1.4154e-02_r8,1.0619e-02_r8, &
     &1.5774e-01_r8,2.2631e-01_r8,2.2824e-05_r8/)
      kao(:, 5, 6,15) = (/ &
     &3.3007e-02_r8,2.8867e-02_r8,2.4778e-02_r8,2.0634e-02_r8,1.6523e-02_r8,1.2392e-02_r8, &
     &2.0991e-01_r8,3.3594e-01_r8,3.3161e-05_r8/)
      kao(:, 1, 7,15) = (/ &
     &3.2923e-02_r8,2.8801e-02_r8,2.4671e-02_r8,2.0232e-02_r8,1.6462e-02_r8,1.2339e-02_r8, &
     &8.2302e-03_r8,4.1175e-03_r8,2.9069e-06_r8/)
      kao(:, 2, 7,15) = (/ &
     &4.4354e-02_r8,3.8819e-02_r8,3.3267e-02_r8,2.7723e-02_r8,2.2187e-02_r8,1.6641e-02_r8, &
     &1.1094e-02_r8,4.4470e-02_r8,5.3667e-06_r8/)
      kao(:, 3, 7,15) = (/ &
     &5.4986e-02_r8,4.8115e-02_r8,4.1243e-02_r8,3.4364e-02_r8,2.7498e-02_r8,2.0642e-02_r8, &
     &1.3901e-02_r8,1.0510e-01_r8,9.1519e-06_r8/)
      kao(:, 4, 7,15) = (/ &
     &6.4798e-02_r8,5.6696e-02_r8,4.8186e-02_r8,4.0508e-02_r8,3.2405e-02_r8,2.4095e-02_r8, &
     &1.6208e-02_r8,1.7836e-01_r8,1.4620e-05_r8/)
      kao(:, 5, 7,15) = (/ &
     &7.2855e-02_r8,6.3755e-02_r8,5.4641e-02_r8,4.5546e-02_r8,3.6442e-02_r8,2.7544e-02_r8, &
     &1.8370e-02_r8,1.8524e-01_r8,2.2125e-05_r8/)
      kao(:, 1, 8,15) = (/ &
     &9.4104e-02_r8,8.2337e-02_r8,7.0574e-02_r8,5.8796e-02_r8,4.7043e-02_r8,3.5284e-02_r8, &
     &2.3531e-02_r8,1.1762e-02_r8,1.5730e-06_r8/)
      kao(:, 2, 8,15) = (/ &
     &1.1684e-01_r8,1.0226e-01_r8,8.7581e-02_r8,7.3021e-02_r8,5.8384e-02_r8,4.3796e-02_r8, &
     &2.9205e-02_r8,1.4602e-02_r8,3.1057e-06_r8/)
      kao(:, 3, 8,15) = (/ &
     &1.3899e-01_r8,1.2165e-01_r8,1.0424e-01_r8,8.6874e-02_r8,6.9512e-02_r8,5.2129e-02_r8, &
     &3.4755e-02_r8,1.7377e-02_r8,5.5778e-06_r8/)
      kao(:, 4, 8,15) = (/ &
     &1.6026e-01_r8,1.4023e-01_r8,1.2021e-01_r8,1.0019e-01_r8,8.0158e-02_r8,6.0094e-02_r8, &
     &4.0057e-02_r8,2.0043e-02_r8,9.3711e-06_r8/)
      kao(:, 5, 8,15) = (/ &
     &1.7464e-01_r8,1.5283e-01_r8,1.3102e-01_r8,1.0918e-01_r8,8.7353e-02_r8,6.5505e-02_r8, &
     &4.3670e-02_r8,2.1848e-02_r8,1.4780e-05_r8/)
      kao(:, 1, 9,15) = (/ &
     &4.3914e-01_r8,3.8426e-01_r8,3.2523e-01_r8,2.7101e-01_r8,2.1679e-01_r8,1.6466e-01_r8, &
     &1.0980e-01_r8,5.4190e-02_r8,8.3394e-07_r8/)
      kao(:, 2, 9,15) = (/ &
     &5.3157e-01_r8,4.6496e-01_r8,3.9866e-01_r8,3.3222e-01_r8,2.6580e-01_r8,1.9932e-01_r8, &
     &1.3289e-01_r8,6.6437e-02_r8,1.7793e-06_r8/)
      kao(:, 3, 9,15) = (/ &
     &6.2792e-01_r8,5.4930e-01_r8,4.7092e-01_r8,3.9242e-01_r8,3.1384e-01_r8,2.3543e-01_r8, &
     &1.5698e-01_r8,7.8487e-02_r8,3.4095e-06_r8/)
      kao(:, 4, 9,15) = (/ &
     &6.9612e-01_r8,6.0916e-01_r8,5.2207e-01_r8,4.4160e-01_r8,3.4808e-01_r8,2.6107e-01_r8, &
     &1.7405e-01_r8,8.7030e-02_r8,6.0449e-06_r8/)
      kao(:, 5, 9,15) = (/ &
     &7.1518e-01_r8,6.2568e-01_r8,5.3633e-01_r8,4.4688e-01_r8,3.5754e-01_r8,2.6806e-01_r8, &
     &1.7876e-01_r8,8.9378e-02_r8,9.9175e-06_r8/)
      kao(:, 1,10,15) = (/ &
     &1.3796e+01_r8,1.2071e+01_r8,1.0346e+01_r8,8.6223e+00_r8,6.8983e+00_r8,5.1733e+00_r8, &
     &3.4490e+00_r8,1.7245e+00_r8,4.7027e-07_r8/)
      kao(:, 2,10,15) = (/ &
     &2.6233e+00_r8,2.2954e+00_r8,1.9673e+00_r8,1.6395e+00_r8,1.3116e+00_r8,9.8356e-01_r8, &
     &6.5573e-01_r8,3.2783e-01_r8,1.0735e-06_r8/)
      kao(:, 3,10,15) = (/ &
     &2.9028e+00_r8,2.5398e+00_r8,2.1774e+00_r8,1.8145e+00_r8,1.4515e+00_r8,1.0885e+00_r8, &
     &7.2570e-01_r8,3.6294e-01_r8,2.1946e-06_r8/)
      kao(:, 4,10,15) = (/ &
     &2.9628e+00_r8,2.5919e+00_r8,2.2220e+00_r8,1.8518e+00_r8,1.4813e+00_r8,1.1109e+00_r8, &
     &7.4065e-01_r8,3.7038e-01_r8,4.0439e-06_r8/)
      kao(:, 5,10,15) = (/ &
     &3.0421e+00_r8,2.6615e+00_r8,2.2818e+00_r8,1.9012e+00_r8,1.5210e+00_r8,1.1408e+00_r8, &
     &7.6043e-01_r8,3.8023e-01_r8,6.8742e-06_r8/)
      kao(:, 1,11,15) = (/ &
     &5.1563e+01_r8,4.5117e+01_r8,3.8674e+01_r8,3.2227e+01_r8,2.5782e+01_r8,1.9336e+01_r8, &
     &1.2891e+01_r8,6.4453e+00_r8,4.0707e-07_r8/)
      kao(:, 2,11,15) = (/ &
     &4.0297e+00_r8,3.5262e+00_r8,3.0227e+00_r8,2.5187e+00_r8,2.0150e+00_r8,1.5474e+00_r8, &
     &1.0073e+00_r8,5.0377e-01_r8,9.5505e-07_r8/)
      kao(:, 3,11,15) = (/ &
     &4.2638e+00_r8,3.7317e+00_r8,3.1981e+00_r8,2.6654e+00_r8,2.1321e+00_r8,1.5993e+00_r8, &
     &1.0662e+00_r8,5.3312e-01_r8,1.9370e-06_r8/)
      kao(:, 4,11,15) = (/ &
     &4.5225e+00_r8,3.9566e+00_r8,3.3892e+00_r8,2.8266e+00_r8,2.2603e+00_r8,1.6955e+00_r8, &
     &1.1303e+00_r8,5.6504e-01_r8,3.5823e-06_r8/)
      kao(:, 5,11,15) = (/ &
     &4.7336e+00_r8,4.1418e+00_r8,3.5502e+00_r8,2.9582e+00_r8,2.3669e+00_r8,1.7755e+00_r8, &
     &1.1834e+00_r8,5.9176e-01_r8,6.1298e-06_r8/)
      kao(:, 1,12,15) = (/ &
     &1.0350e+02_r8,9.0564e+01_r8,7.7625e+01_r8,6.4688e+01_r8,5.1750e+01_r8,3.8814e+01_r8, &
     &2.5874e+01_r8,1.2937e+01_r8,3.8485e-07_r8/)
      kao(:, 2,12,15) = (/ &
     &3.5400e+01_r8,3.0974e+01_r8,2.7218e+01_r8,2.2126e+01_r8,1.7700e+01_r8,1.3275e+01_r8, &
     &8.8500e+00_r8,4.4247e+00_r8,8.6295e-07_r8/)
      kao(:, 3,12,15) = (/ &
     &4.7917e+00_r8,4.1902e+00_r8,3.5927e+00_r8,2.9945e+00_r8,2.3939e+00_r8,1.7963e+00_r8, &
     &1.1970e+00_r8,5.9908e-01_r8,1.7414e-06_r8/)
      kao(:, 4,12,15) = (/ &
     &4.7749e+00_r8,4.1779e+00_r8,3.5811e+00_r8,2.9844e+00_r8,2.3876e+00_r8,1.7905e+00_r8, &
     &1.1938e+00_r8,5.9689e-01_r8,3.1576e-06_r8/)
      kao(:, 5,12,15) = (/ &
     &4.7755e+00_r8,4.1774e+00_r8,3.5815e+00_r8,2.9845e+00_r8,2.3876e+00_r8,1.7910e+00_r8, &
     &1.1938e+00_r8,5.9711e-01_r8,5.4455e-06_r8/)
      kao(:, 1,13,15) = (/ &
     &1.3564e+02_r8,1.2035e+02_r8,1.0244e+02_r8,8.5373e+01_r8,6.8293e+01_r8,5.1221e+01_r8, &
     &3.4147e+01_r8,1.7074e+01_r8,3.5301e-07_r8/)
      kao(:, 2,13,15) = (/ &
     &6.6923e+01_r8,5.8556e+01_r8,5.0190e+01_r8,4.1824e+01_r8,3.3458e+01_r8,2.5094e+01_r8, &
     &1.6730e+01_r8,8.3652e+00_r8,7.8175e-07_r8/)
      kao(:, 3,13,15) = (/ &
     &3.7003e+00_r8,3.2381e+00_r8,2.7755e+00_r8,2.3126e+00_r8,1.8500e+00_r8,1.3876e+00_r8, &
     &9.2513e-01_r8,4.6258e-01_r8,1.5659e-06_r8/)
      kao(:, 4,13,15) = (/ &
     &3.7328e+00_r8,3.2655e+00_r8,2.7985e+00_r8,2.3334e+00_r8,1.8661e+00_r8,1.3995e+00_r8, &
     &9.3310e-01_r8,4.6647e-01_r8,2.9454e-06_r8/)
      kao(:, 5,13,15) = (/ &
     &3.7209e+00_r8,3.2581e+00_r8,2.7929e+00_r8,2.3278e+00_r8,1.8618e+00_r8,1.3966e+00_r8, &
     &9.3071e-01_r8,4.6580e-01_r8,5.0591e-06_r8/)
      kao(:, 1, 1,16) = (/ &
     &3.4803e-04_r8,3.1375e-04_r8,9.0029e-02_r8,1.3230e-01_r8,1.7123e-01_r8,2.0432e-01_r8, &
     &2.2540e-01_r8,2.1561e-01_r8,3.4246e-01_r8/)
      kao(:, 2, 1,16) = (/ &
     &3.6711e-04_r8,6.2185e-02_r8,1.2251e-01_r8,1.8007e-01_r8,2.3310e-01_r8,2.7812e-01_r8, &
     &3.0698e-01_r8,2.9374e-01_r8,4.6619e-01_r8/)
      kao(:, 3, 1,16) = (/ &
     &3.8231e-04_r8,8.1789e-02_r8,1.6116e-01_r8,2.3685e-01_r8,3.0661e-01_r8,3.6587e-01_r8, &
     &4.0384e-01_r8,3.8690e-01_r8,6.1322e-01_r8/)
      kao(:, 4, 1,16) = (/ &
     &3.9398e-04_r8,1.0451e-01_r8,2.0587e-01_r8,3.0259e-01_r8,3.9179e-01_r8,4.6767e-01_r8, &
     &5.1634e-01_r8,4.9462e-01_r8,7.8358e-01_r8/)
      kao(:, 5, 1,16) = (/ &
     &4.0251e-04_r8,1.3022e-01_r8,2.5663e-01_r8,3.7711e-01_r8,4.8832e-01_r8,5.8296e-01_r8, &
     &6.4377e-01_r8,6.1717e-01_r8,9.7664e-01_r8/)
      kao(:, 1, 2,16) = (/ &
     &4.4386e-04_r8,3.9528e-04_r8,9.5606e-02_r8,1.4144e-01_r8,1.8490e-01_r8,2.2388e-01_r8, &
     &2.5317e-01_r8,2.5424e-01_r8,3.6979e-01_r8/)
      kao(:, 2, 2,16) = (/ &
     &4.6963e-04_r8,4.2143e-04_r8,1.3208e-01_r8,1.9543e-01_r8,2.5549e-01_r8,3.0939e-01_r8, &
     &3.5000e-01_r8,3.5157e-01_r8,5.1097e-01_r8/)
      kao(:, 3, 2,16) = (/ &
     &4.9052e-04_r8,4.4450e-04_r8,1.7597e-01_r8,2.6040e-01_r8,3.4044e-01_r8,4.1226e-01_r8, &
     &4.6651e-01_r8,4.6873e-01_r8,6.8087e-01_r8/)
      kao(:, 4, 2,16) = (/ &
     &5.0548e-04_r8,4.6448e-04_r8,2.2723e-01_r8,3.3632e-01_r8,4.3972e-01_r8,5.3255e-01_r8, &
     &6.0266e-01_r8,6.0594e-01_r8,8.7943e-01_r8/)
      kao(:, 5, 2,16) = (/ &
     &5.1704e-04_r8,1.4434e-01_r8,2.8579e-01_r8,4.2309e-01_r8,5.5324e-01_r8,6.7011e-01_r8, &
     &7.5842e-01_r8,7.6291e-01_r8,1.1065e+00_r8/)
      kao(:, 1, 3,16) = (/ &
     &7.4514e-04_r8,6.5703e-04_r8,5.6805e-04_r8,1.3986e-01_r8,1.8472e-01_r8,2.2721e-01_r8, &
     &2.6439e-01_r8,2.8334e-01_r8,3.6943e-01_r8/)
      kao(:, 2, 3,16) = (/ &
     &7.9344e-04_r8,7.0163e-04_r8,6.1002e-04_r8,1.9810e-01_r8,2.6159e-01_r8,3.2183e-01_r8, &
     &3.7436e-01_r8,4.0145e-01_r8,5.2319e-01_r8/)
      kao(:, 3, 3,16) = (/ &
     &8.3288e-04_r8,7.4056e-04_r8,6.4608e-04_r8,2.6931e-01_r8,3.5570e-01_r8,4.3753e-01_r8, &
     &5.0928e-01_r8,5.4624e-01_r8,7.1140e-01_r8/)
      kao(:, 4, 3,16) = (/ &
     &8.6418e-04_r8,7.7079e-04_r8,1.2130e-02_r8,3.5401e-01_r8,4.6743e-01_r8,5.7518e-01_r8, &
     &6.6923e-01_r8,7.1819e-01_r8,9.3487e-01_r8/)
      kao(:, 5, 3,16) = (/ &
     &8.8628e-04_r8,7.9797e-04_r8,3.0313e-01_r8,4.5187e-01_r8,5.9661e-01_r8,7.3417e-01_r8, &
     &8.5463e-01_r8,9.1729e-01_r8,1.1932e+00_r8/)
      kao(:, 1, 4,16) = (/ &
     &1.2636e-03_r8,1.1057e-03_r8,9.5136e-04_r8,7.9620e-04_r8,6.4188e-04_r8,2.1791e-01_r8, &
     &2.5758e-01_r8,2.8791e-01_r8,2.3364e-05_r8/)
      kao(:, 2, 4,16) = (/ &
     &1.3610e-03_r8,1.1957e-03_r8,1.0270e-03_r8,8.6413e-04_r8,7.0025e-04_r8,3.1776e-01_r8, &
     &3.7570e-01_r8,4.1991e-01_r8,3.8771e-05_r8/)
      kao(:, 3, 4,16) = (/ &
     &1.4417e-03_r8,1.2662e-03_r8,1.0946e-03_r8,9.2411e-04_r8,3.5694e-01_r8,4.4267e-01_r8, &
     &5.2346e-01_r8,5.8520e-01_r8,7.1388e-01_r8/)
      kao(:, 4, 4,16) = (/ &
     &1.5012e-03_r8,1.3268e-03_r8,1.1484e-03_r8,9.7089e-04_r8,4.7866e-01_r8,5.9391e-01_r8, &
     &7.0229e-01_r8,7.8545e-01_r8,9.5731e-01_r8/)
      kao(:, 5, 4,16) = (/ &
     &1.5493e-03_r8,1.3712e-03_r8,1.1941e-03_r8,1.0165e-03_r8,6.2163e-01_r8,7.7110e-01_r8, &
     &9.1212e-01_r8,1.0202e+00_r8,1.2432e+00_r8/)
      kao(:, 1, 5,16) = (/ &
     &1.9563e-03_r8,1.7130e-03_r8,1.4716e-03_r8,1.2286e-03_r8,9.8449e-04_r8,7.4210e-04_r8, &
     &5.0011e-04_r8,2.7578e-01_r8,1.4521e-05_r8/)
      kao(:, 2, 5,16) = (/ &
     &2.1251e-03_r8,1.8616e-03_r8,1.5991e-03_r8,1.3382e-03_r8,1.0747e-03_r8,8.1191e-04_r8, &
     &3.6392e-01_r8,4.1523e-01_r8,2.5317e-05_r8/)
      kao(:, 3, 5,16) = (/ &
     &2.2685e-03_r8,1.9902e-03_r8,1.7118e-03_r8,1.4319e-03_r8,1.1550e-03_r8,8.7607e-04_r8, &
     &5.2057e-01_r8,5.9412e-01_r8,4.1189e-05_r8/)
      kao(:, 4, 5,16) = (/ &
     &2.3834e-03_r8,2.0939e-03_r8,1.8039e-03_r8,1.5145e-03_r8,1.2237e-03_r8,9.3428e-04_r8, &
     &7.1378e-01_r8,8.1462e-01_r8,6.3394e-05_r8/)
      kao(:, 5, 5,16) = (/ &
     &2.4764e-03_r8,2.1786e-03_r8,1.8819e-03_r8,1.5832e-03_r8,1.2860e-03_r8,7.9256e-01_r8, &
     &9.4410e-01_r8,1.0778e+00_r8,9.2980e-05_r8/)
      kao(:, 1, 6,16) = (/ &
     &2.8061e-03_r8,2.4583e-03_r8,2.1085e-03_r8,1.7622e-03_r8,1.4067e-03_r8,1.0576e-03_r8, &
     &7.0829e-04_r8,1.6992e-01_r8,8.6758e-06_r8/)
      kao(:, 2, 6,16) = (/ &
     &3.0921e-03_r8,2.7056e-03_r8,2.3212e-03_r8,1.9356e-03_r8,1.5529e-03_r8,1.1677e-03_r8, &
     &7.8418e-04_r8,3.9086e-01_r8,1.5977e-05_r8/)
      kao(:, 3, 6,16) = (/ &
     &3.3322e-03_r8,2.9180e-03_r8,2.5057e-03_r8,2.0938e-03_r8,1.6795e-03_r8,1.2657e-03_r8, &
     &8.5374e-04_r8,5.7620e-01_r8,2.7234e-05_r8/)
      kao(:, 4, 6,16) = (/ &
     &3.5394e-03_r8,3.0979e-03_r8,2.6608e-03_r8,2.2263e-03_r8,1.7897e-03_r8,1.3517e-03_r8, &
     &9.1571e-04_r8,8.0997e-01_r8,4.3592e-05_r8/)
      kao(:, 5, 6,16) = (/ &
     &3.6973e-03_r8,3.2450e-03_r8,2.7879e-03_r8,2.3342e-03_r8,1.8813e-03_r8,1.4280e-03_r8, &
     &2.3591e-01_r8,1.0936e+00_r8,6.6108e-05_r8/)
      kao(:, 1, 7,16) = (/ &
     &4.1566e-03_r8,3.6382e-03_r8,3.1187e-03_r8,2.5984e-03_r8,2.0809e-03_r8,1.5620e-03_r8, &
     &1.0430e-03_r8,5.2415e-04_r8,5.0515e-06_r8/)
      kao(:, 2, 7,16) = (/ &
     &4.6397e-03_r8,4.0602e-03_r8,3.4821e-03_r8,2.9026e-03_r8,2.3244e-03_r8,1.7452e-03_r8, &
     &1.1674e-03_r8,5.8830e-04_r8,9.8982e-06_r8/)
      kao(:, 3, 7,16) = (/ &
     &5.0641e-03_r8,4.4282e-03_r8,3.8004e-03_r8,3.1687e-03_r8,2.5412e-03_r8,1.9080e-03_r8, &
     &1.2777e-03_r8,6.4842e-04_r8,1.7758e-05_r8/)
      kao(:, 4, 7,16) = (/ &
     &5.4224e-03_r8,4.7462e-03_r8,4.0771e-03_r8,3.3992e-03_r8,2.7272e-03_r8,2.0505e-03_r8, &
     &1.3779e-03_r8,7.0354e-04_r8,2.9670e-05_r8/)
      kao(:, 5, 7,16) = (/ &
     &5.7229e-03_r8,5.0101e-03_r8,4.3011e-03_r8,3.5983e-03_r8,2.8833e-03_r8,2.1757e-03_r8, &
     &1.4658e-03_r8,6.1847e-01_r8,4.6639e-05_r8/)
      kao(:, 1, 8,16) = (/ &
     &7.1654e-03_r8,6.2688e-03_r8,5.3745e-03_r8,4.4778e-03_r8,3.5800e-03_r8,2.6883e-03_r8, &
     &1.7931e-03_r8,8.9706e-04_r8,2.8888e-06_r8/)
      kao(:, 2, 8,16) = (/ &
     &8.1399e-03_r8,7.1118e-03_r8,6.0997e-03_r8,5.0831e-03_r8,4.0665e-03_r8,3.0517e-03_r8, &
     &2.0386e-03_r8,1.0214e-03_r8,6.0412e-06_r8/)
      kao(:, 3, 8,16) = (/ &
     &8.9800e-03_r8,7.8609e-03_r8,6.7393e-03_r8,5.6216e-03_r8,4.4978e-03_r8,3.3745e-03_r8, &
     &2.2551e-03_r8,1.1328e-03_r8,1.1454e-05_r8/)
      kao(:, 4, 8,16) = (/ &
     &9.7139e-03_r8,8.5067e-03_r8,7.2942e-03_r8,6.0777e-03_r8,4.8682e-03_r8,3.6593e-03_r8, &
     &2.4437e-03_r8,1.2326e-03_r8,2.0029e-05_r8/)
      kao(:, 5, 8,16) = (/ &
     &1.0337e-02_r8,9.0473e-03_r8,7.7560e-03_r8,6.4703e-03_r8,5.1860e-03_r8,3.8948e-03_r8, &
     &2.6072e-03_r8,1.3207e-03_r8,3.2759e-05_r8/)
      kao(:, 1, 9,16) = (/ &
     &2.3247e-02_r8,2.0336e-02_r8,1.7429e-02_r8,1.4524e-02_r8,1.1625e-02_r8,8.7188e-03_r8, &
     &5.8147e-03_r8,2.9059e-03_r8,1.6015e-06_r8/)
      kao(:, 2, 9,16) = (/ &
     &2.6840e-02_r8,2.3482e-02_r8,2.0132e-02_r8,1.6770e-02_r8,1.3422e-02_r8,1.0063e-02_r8, &
     &6.7117e-03_r8,3.3577e-03_r8,3.6050e-06_r8/)
      kao(:, 3, 9,16) = (/ &
     &3.0078e-02_r8,2.6329e-02_r8,2.2553e-02_r8,1.8793e-02_r8,1.5044e-02_r8,1.1280e-02_r8, &
     &7.5240e-03_r8,3.7656e-03_r8,7.2546e-06_r8/)
      kao(:, 4, 9,16) = (/ &
     &3.2925e-02_r8,2.8810e-02_r8,2.4697e-02_r8,2.0586e-02_r8,3.0583e-02_r8,1.2361e-02_r8, &
     &8.2421e-03_r8,4.1354e-03_r8,1.3329e-05_r8/)
      kao(:, 5, 9,16) = (/ &
     &3.5342e-02_r8,3.0934e-02_r8,2.6503e-02_r8,2.2104e-02_r8,1.7684e-02_r8,1.3262e-02_r8, &
     &8.8536e-03_r8,4.4397e-03_r8,2.2693e-05_r8/)
      kao(:, 1,10,16) = (/ &
     &8.4703e-02_r8,7.4117e-02_r8,6.3535e-02_r8,5.2927e-02_r8,4.2343e-02_r8,3.1773e-02_r8, &
     &2.1175e-02_r8,1.0588e-02_r8,9.2688e-07_r8/)
      kao(:, 2,10,16) = (/ &
     &9.9410e-02_r8,8.7009e-02_r8,7.4556e-02_r8,6.2160e-02_r8,4.9698e-02_r8,3.7265e-02_r8, &
     &2.4850e-02_r8,1.2429e-02_r8,2.2335e-06_r8/)
      kao(:, 3,10,16) = (/ &
     &1.1291e-01_r8,9.8729e-02_r8,8.4692e-02_r8,7.0598e-02_r8,5.6422e-02_r8,4.2355e-02_r8, &
     &2.8232e-02_r8,1.4106e-02_r8,4.7476e-06_r8/)
      kao(:, 4,10,16) = (/ &
     &1.2498e-01_r8,1.0930e-01_r8,9.3695e-02_r8,7.8057e-02_r8,6.2479e-02_r8,4.6859e-02_r8, &
     &3.1244e-02_r8,1.5627e-02_r8,9.1259e-06_r8/)
      kao(:, 5,10,16) = (/ &
     &1.3523e-01_r8,1.1838e-01_r8,1.0149e-01_r8,8.4512e-02_r8,6.7619e-02_r8,5.0737e-02_r8, &
     &3.3842e-02_r8,1.6917e-02_r8,1.6155e-05_r8/)
      kao(:, 1,11,16) = (/ &
     &1.1702e-01_r8,1.0242e-01_r8,8.7781e-02_r8,7.3100e-02_r8,5.8528e-02_r8,4.3847e-02_r8, &
     &2.9250e-02_r8,1.4631e-02_r8,8.3202e-07_r8/)
      kao(:, 2,11,16) = (/ &
     &1.3733e-01_r8,1.2017e-01_r8,1.0300e-01_r8,8.5853e-02_r8,6.8653e-02_r8,5.1492e-02_r8, &
     &3.4322e-02_r8,1.7153e-02_r8,2.0128e-06_r8/)
      kao(:, 3,11,16) = (/ &
     &1.5584e-01_r8,1.3638e-01_r8,1.1685e-01_r8,9.7461e-02_r8,7.7843e-02_r8,5.8372e-02_r8, &
     &3.8976e-02_r8,1.9510e-02_r8,4.3129e-06_r8/)
      kao(:, 4,11,16) = (/ &
     &1.7239e-01_r8,1.5086e-01_r8,1.2928e-01_r8,1.0779e-01_r8,8.6176e-02_r8,6.4725e-02_r8, &
     &4.3097e-02_r8,2.1516e-02_r8,8.3117e-06_r8/)
      kao(:, 5,11,16) = (/ &
     &1.8654e-01_r8,1.6325e-01_r8,1.3989e-01_r8,1.1667e-01_r8,9.3408e-02_r8,7.0060e-02_r8, &
     &4.6775e-02_r8,2.3342e-02_r8,1.4729e-05_r8/)
      kao(:, 1,12,16) = (/ &
     &1.1854e-01_r8,1.0376e-01_r8,8.8946e-02_r8,7.4074e-02_r8,5.9255e-02_r8,4.4504e-02_r8, &
     &2.9679e-02_r8,1.4800e-02_r8,7.4749e-07_r8/)
      kao(:, 2,12,16) = (/ &
     &1.3943e-01_r8,1.2204e-01_r8,1.0463e-01_r8,8.7342e-02_r8,6.9856e-02_r8,5.2356e-02_r8, &
     &3.4894e-02_r8,1.7410e-02_r8,1.8161e-06_r8/)
      kao(:, 3,12,16) = (/ &
     &1.5836e-01_r8,1.3868e-01_r8,1.1885e-01_r8,9.9001e-02_r8,7.9338e-02_r8,5.9413e-02_r8, &
     &3.9707e-02_r8,1.9806e-02_r8,3.8901e-06_r8/)
      kao(:, 4,12,16) = (/ &
     &1.7966e-01_r8,1.5728e-01_r8,1.3478e-01_r8,1.1217e-01_r8,8.9784e-02_r8,6.7270e-02_r8, &
     &4.4900e-02_r8,2.2432e-02_r8,7.2752e-06_r8/)
      kao(:, 5,12,16) = (/ &
     &2.0635e-01_r8,1.8060e-01_r8,1.5479e-01_r8,1.2891e-01_r8,1.0321e-01_r8,7.7324e-02_r8, &
     &5.1591e-02_r8,2.5791e-02_r8,1.2040e-05_r8/)
      kao(:, 1,13,16) = (/ &
     &2.1930e-01_r8,8.1271e-02_r8,6.9650e-02_r8,5.7973e-02_r8,4.6358e-02_r8,3.4782e-02_r8, &
     &2.3204e-02_r8,1.1588e-02_r8,6.6806e-07_r8/)
      kao(:, 2,13,16) = (/ &
     &1.1205e-01_r8,9.8083e-02_r8,8.4056e-02_r8,7.0107e-02_r8,5.6050e-02_r8,4.2050e-02_r8, &
     &2.7998e-02_r8,1.4011e-02_r8,1.5755e-06_r8/)
      kao(:, 3,13,16) = (/ &
     &1.3646e-01_r8,1.1932e-01_r8,1.0236e-01_r8,8.5263e-02_r8,6.8236e-02_r8,5.1131e-02_r8, &
     &3.4091e-02_r8,1.7065e-02_r8,3.1454e-06_r8/)
      kao(:, 4,13,16) = (/ &
     &1.5976e-01_r8,1.3979e-01_r8,1.1981e-01_r8,9.9935e-02_r8,7.9931e-02_r8,5.9857e-02_r8, &
     &3.9898e-02_r8,1.9961e-02_r8,5.5256e-06_r8/)
      kao(:, 5,13,16) = (/ &
     &1.7769e-01_r8,1.5548e-01_r8,1.3326e-01_r8,1.1109e-01_r8,8.8840e-02_r8,6.6629e-02_r8, &
     &4.4447e-02_r8,2.2232e-02_r8,9.1943e-06_r8/)

!     The array KAO_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level below 100~ mb.   The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amount ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 
!     to that of gas2.  The second index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The third index 
!     runs over the g-channel (1 to 16).

      kao_mco2( 1, :, 1) = (/ &
     & 1.09539e-04_r8, 1.17067e-04_r8, 1.25113e-04_r8, 1.33712e-04_r8, 1.42902e-04_r8, &
     & 1.52724e-04_r8, 1.63221e-04_r8, 1.74439e-04_r8, 1.86428e-04_r8, 1.99241e-04_r8, &
     & 2.12934e-04_r8, 2.27569e-04_r8, 2.43210e-04_r8, 2.59926e-04_r8, 2.77790e-04_r8, &
     & 2.96883e-04_r8, 3.17287e-04_r8, 3.39094e-04_r8, 3.62400e-04_r8/)
      kao_mco2( 2, :, 1) = (/ &
     & 1.25202e-04_r8, 1.34718e-04_r8, 1.44957e-04_r8, 1.55974e-04_r8, 1.67829e-04_r8, &
     & 1.80585e-04_r8, 1.94311e-04_r8, 2.09079e-04_r8, 2.24971e-04_r8, 2.42069e-04_r8, &
     & 2.60468e-04_r8, 2.80265e-04_r8, 3.01567e-04_r8, 3.24488e-04_r8, 3.49150e-04_r8, &
     & 3.75688e-04_r8, 4.04242e-04_r8, 4.34966e-04_r8, 4.68026e-04_r8/)
      kao_mco2( 3, :, 1) = (/ &
     & 1.12112e-04_r8, 1.21090e-04_r8, 1.30786e-04_r8, 1.41259e-04_r8, 1.52571e-04_r8, &
     & 1.64788e-04_r8, 1.77984e-04_r8, 1.92237e-04_r8, 2.07631e-04_r8, 2.24257e-04_r8, &
     & 2.42215e-04_r8, 2.61611e-04_r8, 2.82560e-04_r8, 3.05187e-04_r8, 3.29625e-04_r8, &
     & 3.56021e-04_r8, 3.84530e-04_r8, 4.15322e-04_r8, 4.48580e-04_r8/)
      kao_mco2( 4, :, 1) = (/ &
     & 9.74130e-05_r8, 1.05372e-04_r8, 1.13982e-04_r8, 1.23295e-04_r8, 1.33369e-04_r8, &
     & 1.44265e-04_r8, 1.56053e-04_r8, 1.68803e-04_r8, 1.82595e-04_r8, 1.97514e-04_r8, &
     & 2.13652e-04_r8, 2.31109e-04_r8, 2.49992e-04_r8, 2.70418e-04_r8, 2.92512e-04_r8, &
     & 3.16412e-04_r8, 3.42265e-04_r8, 3.70230e-04_r8, 4.00479e-04_r8/)
      kao_mco2( 5, :, 1) = (/ &
     & 8.71018e-05_r8, 9.40759e-05_r8, 1.01608e-04_r8, 1.09744e-04_r8, 1.18531e-04_r8, &
     & 1.28022e-04_r8, 1.38272e-04_r8, 1.49343e-04_r8, 1.61301e-04_r8, 1.74216e-04_r8, &
     & 1.88166e-04_r8, 2.03232e-04_r8, 2.19504e-04_r8, 2.37079e-04_r8, 2.56062e-04_r8, &
     & 2.76565e-04_r8, 2.98709e-04_r8, 3.22626e-04_r8, 3.48458e-04_r8/)
      kao_mco2( 6, :, 1) = (/ &
     & 7.55256e-05_r8, 8.17414e-05_r8, 8.84688e-05_r8, 9.57500e-05_r8, 1.03630e-04_r8, &
     & 1.12159e-04_r8, 1.21390e-04_r8, 1.31381e-04_r8, 1.42193e-04_r8, 1.53896e-04_r8, &
     & 1.66562e-04_r8, 1.80270e-04_r8, 1.95107e-04_r8, 2.11164e-04_r8, 2.28543e-04_r8, &
     & 2.47353e-04_r8, 2.67710e-04_r8, 2.89743e-04_r8, 3.13589e-04_r8/)
      kao_mco2( 7, :, 1) = (/ &
     & 5.31515e-05_r8, 6.06869e-05_r8, 6.92907e-05_r8, 7.91143e-05_r8, 9.03306e-05_r8, &
     & 1.03137e-04_r8, 1.17759e-04_r8, 1.34454e-04_r8, 1.53516e-04_r8, 1.75281e-04_r8, &
     & 2.00131e-04_r8, 2.28504e-04_r8, 2.60900e-04_r8, 2.97888e-04_r8, 3.40121e-04_r8, &
     & 3.88341e-04_r8, 4.43397e-04_r8, 5.06259e-04_r8, 5.78033e-04_r8/)
      kao_mco2( 8, :, 1) = (/ &
     & 2.52471e-04_r8, 2.96005e-04_r8, 3.47045e-04_r8, 4.06886e-04_r8, 4.77045e-04_r8, &
     & 5.59302e-04_r8, 6.55742e-04_r8, 7.68811e-04_r8, 9.01377e-04_r8, 1.05680e-03_r8, &
     & 1.23902e-03_r8, 1.45267e-03_r8, 1.70315e-03_r8, 1.99683e-03_r8, 2.34114e-03_r8, &
     & 2.74482e-03_r8, 3.21811e-03_r8, 3.77300e-03_r8, 4.42358e-03_r8/)
      kao_mco2( 9, :, 1) = (/ &
     & 4.06711e-05_r8, 4.53161e-05_r8, 5.04917e-05_r8, 5.62583e-05_r8, 6.26836e-05_r8, &
     & 6.98427e-05_r8, 7.78194e-05_r8, 8.67071e-05_r8, 9.66100e-05_r8, 1.07644e-04_r8, &
     & 1.19938e-04_r8, 1.33636e-04_r8, 1.48898e-04_r8, 1.65904e-04_r8, 1.84852e-04_r8, &
     & 2.05964e-04_r8, 2.29487e-04_r8, 2.55697e-04_r8, 2.84900e-04_r8/)
      kao_mco2( 1, :, 2) = (/ &
     & 2.01759e-04_r8, 2.15641e-04_r8, 2.30478e-04_r8, 2.46336e-04_r8, 2.63285e-04_r8, &
     & 2.81400e-04_r8, 3.00761e-04_r8, 3.21455e-04_r8, 3.43573e-04_r8, 3.67212e-04_r8, &
     & 3.92477e-04_r8, 4.19482e-04_r8, 4.48344e-04_r8, 4.79192e-04_r8, 5.12162e-04_r8, &
     & 5.47401e-04_r8, 5.85064e-04_r8, 6.25319e-04_r8, 6.68343e-04_r8/)
      kao_mco2( 2, :, 2) = (/ &
     & 2.53461e-04_r8, 2.70916e-04_r8, 2.89574e-04_r8, 3.09516e-04_r8, 3.30832e-04_r8, &
     & 3.53616e-04_r8, 3.77969e-04_r8, 4.03999e-04_r8, 4.31822e-04_r8, 4.61561e-04_r8, &
     & 4.93348e-04_r8, 5.27324e-04_r8, 5.63640e-04_r8, 6.02457e-04_r8, 6.43948e-04_r8, &
     & 6.88295e-04_r8, 7.35697e-04_r8, 7.86364e-04_r8, 8.40519e-04_r8/)
      kao_mco2( 3, :, 2) = (/ &
     & 2.58821e-04_r8, 2.76943e-04_r8, 2.96334e-04_r8, 3.17082e-04_r8, 3.39283e-04_r8, &
     & 3.63038e-04_r8, 3.88457e-04_r8, 4.15655e-04_r8, 4.44758e-04_r8, 4.75899e-04_r8, &
     & 5.09220e-04_r8, 5.44874e-04_r8, 5.83024e-04_r8, 6.23845e-04_r8, 6.67525e-04_r8, &
     & 7.14263e-04_r8, 7.64273e-04_r8, 8.17785e-04_r8, 8.75043e-04_r8/)
      kao_mco2( 4, :, 2) = (/ &
     & 2.46588e-04_r8, 2.64630e-04_r8, 2.83993e-04_r8, 3.04771e-04_r8, 3.27071e-04_r8, &
     & 3.51001e-04_r8, 3.76683e-04_r8, 4.04244e-04_r8, 4.33821e-04_r8, 4.65563e-04_r8, &
     & 4.99627e-04_r8, 5.36183e-04_r8, 5.75414e-04_r8, 6.17515e-04_r8, 6.62697e-04_r8, &
     & 7.11185e-04_r8, 7.63220e-04_r8, 8.19063e-04_r8, 8.78991e-04_r8/)
      kao_mco2( 5, :, 2) = (/ &
     & 2.19140e-04_r8, 2.36464e-04_r8, 2.55158e-04_r8, 2.75330e-04_r8, 2.97097e-04_r8, &
     & 3.20585e-04_r8, 3.45929e-04_r8, 3.73277e-04_r8, 4.02787e-04_r8, 4.34630e-04_r8, &
     & 4.68991e-04_r8, 5.06068e-04_r8, 5.46076e-04_r8, 5.89247e-04_r8, 6.35831e-04_r8, &
     & 6.86097e-04_r8, 7.40338e-04_r8, 7.98867e-04_r8, 8.62022e-04_r8/)
      kao_mco2( 6, :, 2) = (/ &
     & 1.74073e-04_r8, 1.92221e-04_r8, 2.12260e-04_r8, 2.34388e-04_r8, 2.58824e-04_r8, &
     & 2.85807e-04_r8, 3.15603e-04_r8, 3.48505e-04_r8, 3.84837e-04_r8, 4.24957e-04_r8, &
     & 4.69260e-04_r8, 5.18181e-04_r8, 5.72202e-04_r8, 6.31855e-04_r8, 6.97727e-04_r8, &
     & 7.70466e-04_r8, 8.50789e-04_r8, 9.39485e-04_r8, 1.03743e-03_r8/)
      kao_mco2( 7, :, 2) = (/ &
     & 1.74359e-04_r8, 1.99276e-04_r8, 2.27753e-04_r8, 2.60299e-04_r8, 2.97497e-04_r8, &
     & 3.40010e-04_r8, 3.88599e-04_r8, 4.44130e-04_r8, 5.07598e-04_r8, 5.80135e-04_r8, &
     & 6.63039e-04_r8, 7.57789e-04_r8, 8.66079e-04_r8, 9.89845e-04_r8, 1.13130e-03_r8, &
     & 1.29296e-03_r8, 1.47773e-03_r8, 1.68890e-03_r8, 1.93025e-03_r8/)
      kao_mco2( 8, :, 2) = (/ &
     & 1.08215e-03_r8, 1.20760e-03_r8, 1.34759e-03_r8, 1.50382e-03_r8, 1.67815e-03_r8, &
     & 1.87270e-03_r8, 2.08980e-03_r8, 2.33206e-03_r8, 2.60242e-03_r8, 2.90411e-03_r8, &
     & 3.24078e-03_r8, 3.61648e-03_r8, 4.03573e-03_r8, 4.50359e-03_r8, 5.02568e-03_r8, &
     & 5.60830e-03_r8, 6.25846e-03_r8, 6.98399e-03_r8, 7.79363e-03_r8/)
      kao_mco2( 9, :, 2) = (/ &
     & 1.04969e-04_r8, 1.20766e-04_r8, 1.38939e-04_r8, 1.59848e-04_r8, 1.83903e-04_r8, &
     & 2.11578e-04_r8, 2.43418e-04_r8, 2.80049e-04_r8, 3.22193e-04_r8, 3.70678e-04_r8, &
     & 4.26461e-04_r8, 4.90638e-04_r8, 5.64472e-04_r8, 6.49418e-04_r8, 7.47147e-04_r8, &
     & 8.59583e-04_r8, 9.88940e-04_r8, 1.13776e-03_r8, 1.30898e-03_r8/)
      kao_mco2( 1, :, 3) = (/ &
     & 3.72106e-04_r8, 3.96252e-04_r8, 4.21966e-04_r8, 4.49347e-04_r8, 4.78506e-04_r8, &
     & 5.09557e-04_r8, 5.42623e-04_r8, 5.77834e-04_r8, 6.15330e-04_r8, 6.55260e-04_r8, &
     & 6.97781e-04_r8, 7.43060e-04_r8, 7.91278e-04_r8, 8.42626e-04_r8, 8.97304e-04_r8, &
     & 9.55532e-04_r8, 1.01754e-03_r8, 1.08357e-03_r8, 1.15388e-03_r8/)
      kao_mco2( 2, :, 3) = (/ &
     & 4.20563e-04_r8, 4.46162e-04_r8, 4.73319e-04_r8, 5.02130e-04_r8, 5.32693e-04_r8, &
     & 5.65118e-04_r8, 5.99516e-04_r8, 6.36007e-04_r8, 6.74720e-04_r8, 7.15789e-04_r8, &
     & 7.59358e-04_r8, 8.05579e-04_r8, 8.54613e-04_r8, 9.06632e-04_r8, 9.61817e-04_r8, &
     & 1.02036e-03_r8, 1.08247e-03_r8, 1.14836e-03_r8, 1.21826e-03_r8/)
      kao_mco2( 3, :, 3) = (/ &
     & 4.89664e-04_r8, 5.18321e-04_r8, 5.48654e-04_r8, 5.80764e-04_r8, 6.14752e-04_r8, &
     & 6.50729e-04_r8, 6.88812e-04_r8, 7.29124e-04_r8, 7.71795e-04_r8, 8.16963e-04_r8, &
     & 8.64774e-04_r8, 9.15384e-04_r8, 9.68955e-04_r8, 1.02566e-03_r8, 1.08569e-03_r8, &
     & 1.14922e-03_r8, 1.21648e-03_r8, 1.28767e-03_r8, 1.36303e-03_r8/)
      kao_mco2( 4, :, 3) = (/ &
     & 4.61143e-04_r8, 4.92198e-04_r8, 5.25343e-04_r8, 5.60720e-04_r8, 5.98480e-04_r8, &
     & 6.38783e-04_r8, 6.81799e-04_r8, 7.27713e-04_r8, 7.76718e-04_r8, 8.29023e-04_r8, &
     & 8.84851e-04_r8, 9.44438e-04_r8, 1.00804e-03_r8, 1.07592e-03_r8, 1.14837e-03_r8, &
     & 1.22571e-03_r8, 1.30825e-03_r8, 1.39635e-03_r8, 1.49038e-03_r8/)
      kao_mco2( 5, :, 3) = (/ &
     & 4.01988e-04_r8, 4.36672e-04_r8, 4.74349e-04_r8, 5.15278e-04_r8, 5.59737e-04_r8, &
     & 6.08032e-04_r8, 6.60495e-04_r8, 7.17484e-04_r8, 7.79390e-04_r8, 8.46638e-04_r8, &
     & 9.19688e-04_r8, 9.99041e-04_r8, 1.08524e-03_r8, 1.17888e-03_r8, 1.28059e-03_r8, &
     & 1.39109e-03_r8, 1.51111e-03_r8, 1.64149e-03_r8, 1.78313e-03_r8/)
      kao_mco2( 6, :, 3) = (/ &
     & 3.35536e-04_r8, 3.74371e-04_r8, 4.17700e-04_r8, 4.66045e-04_r8, 5.19985e-04_r8, &
     & 5.80169e-04_r8, 6.47318e-04_r8, 7.22238e-04_r8, 8.05831e-04_r8, 8.99098e-04_r8, &
     & 1.00316e-03_r8, 1.11927e-03_r8, 1.24881e-03_r8, 1.39335e-03_r8, 1.55461e-03_r8, &
     & 1.73455e-03_r8, 1.93530e-03_r8, 2.15930e-03_r8, 2.40921e-03_r8/)
      kao_mco2( 7, :, 3) = (/ &
     & 3.24677e-04_r8, 3.75160e-04_r8, 4.33491e-04_r8, 5.00893e-04_r8, 5.78774e-04_r8, &
     & 6.68765e-04_r8, 7.72749e-04_r8, 8.92900e-04_r8, 1.03173e-03_r8, 1.19215e-03_r8, &
     & 1.37751e-03_r8, 1.59170e-03_r8, 1.83918e-03_r8, 2.12515e-03_r8, 2.45558e-03_r8, &
     & 2.83738e-03_r8, 3.27856e-03_r8, 3.78832e-03_r8, 4.37735e-03_r8/)
      kao_mco2( 8, :, 3) = (/ &
     & 2.24656e-03_r8, 2.45550e-03_r8, 2.68386e-03_r8, 2.93347e-03_r8, 3.20629e-03_r8, &
     & 3.50448e-03_r8, 3.83041e-03_r8, 4.18665e-03_r8, 4.57602e-03_r8, 5.00160e-03_r8, &
     & 5.46677e-03_r8, 5.97519e-03_r8, 6.53090e-03_r8, 7.13829e-03_r8, 7.80217e-03_r8, &
     & 8.52780e-03_r8, 9.32091e-03_r8, 1.01878e-02_r8, 1.11353e-02_r8/)
      kao_mco2( 9, :, 3) = (/ &
     & 2.07746e-04_r8, 2.38909e-04_r8, 2.74746e-04_r8, 3.15959e-04_r8, 3.63355e-04_r8, &
     & 4.17860e-04_r8, 4.80541e-04_r8, 5.52625e-04_r8, 6.35521e-04_r8, 7.30852e-04_r8, &
     & 8.40484e-04_r8, 9.66561e-04_r8, 1.11155e-03_r8, 1.27829e-03_r8, 1.47004e-03_r8, &
     & 1.69055e-03_r8, 1.94414e-03_r8, 2.23577e-03_r8, 2.57115e-03_r8/)
      kao_mco2( 1, :, 4) = (/ &
     & 7.26052e-04_r8, 7.62476e-04_r8, 8.00726e-04_r8, 8.40896e-04_r8, 8.83081e-04_r8, &
     & 9.27382e-04_r8, 9.73905e-04_r8, 1.02276e-03_r8, 1.07407e-03_r8, 1.12795e-03_r8, &
     & 1.18454e-03_r8, 1.24396e-03_r8, 1.30637e-03_r8, 1.37190e-03_r8, 1.44073e-03_r8, &
     & 1.51300e-03_r8, 1.58890e-03_r8, 1.66861e-03_r8, 1.75232e-03_r8/)
      kao_mco2( 2, :, 4) = (/ &
     & 4.65815e-04_r8, 5.01167e-04_r8, 5.39203e-04_r8, 5.80126e-04_r8, 6.24154e-04_r8, &
     & 6.71524e-04_r8, 7.22489e-04_r8, 7.77322e-04_r8, 8.36316e-04_r8, 8.99788e-04_r8, &
     & 9.68077e-04_r8, 1.04155e-03_r8, 1.12060e-03_r8, 1.20564e-03_r8, 1.29714e-03_r8, &
     & 1.39559e-03_r8, 1.50151e-03_r8, 1.61546e-03_r8, 1.73807e-03_r8/)
      kao_mco2( 3, :, 4) = (/ &
     & 3.56225e-04_r8, 3.93073e-04_r8, 4.33732e-04_r8, 4.78598e-04_r8, 5.28105e-04_r8, &
     & 5.82732e-04_r8, 6.43010e-04_r8, 7.09524e-04_r8, 7.82918e-04_r8, 8.63903e-04_r8, &
     & 9.53266e-04_r8, 1.05187e-03_r8, 1.16068e-03_r8, 1.28074e-03_r8, 1.41322e-03_r8, &
     & 1.55941e-03_r8, 1.72071e-03_r8, 1.89870e-03_r8, 2.09511e-03_r8/)
      kao_mco2( 4, :, 4) = (/ &
     & 3.37845e-04_r8, 3.79675e-04_r8, 4.26684e-04_r8, 4.79514e-04_r8, 5.38884e-04_r8, &
     & 6.05606e-04_r8, 6.80589e-04_r8, 7.64855e-04_r8, 8.59555e-04_r8, 9.65980e-04_r8, &
     & 1.08558e-03_r8, 1.21999e-03_r8, 1.37105e-03_r8, 1.54080e-03_r8, 1.73157e-03_r8, &
     & 1.94597e-03_r8, 2.18691e-03_r8, 2.45767e-03_r8, 2.76197e-03_r8/)
      kao_mco2( 5, :, 4) = (/ &
     & 3.52456e-04_r8, 4.02782e-04_r8, 4.60294e-04_r8, 5.26017e-04_r8, 6.01126e-04_r8, &
     & 6.86958e-04_r8, 7.85046e-04_r8, 8.97140e-04_r8, 1.02524e-03_r8, 1.17163e-03_r8, &
     & 1.33892e-03_r8, 1.53010e-03_r8, 1.74858e-03_r8, 1.99825e-03_r8, 2.28358e-03_r8, &
     & 2.60964e-03_r8, 2.98226e-03_r8, 3.40809e-03_r8, 3.89471e-03_r8/)
      kao_mco2( 6, :, 4) = (/ &
     & 4.42884e-04_r8, 5.08187e-04_r8, 5.83119e-04_r8, 6.69100e-04_r8, 7.67758e-04_r8, &
     & 8.80963e-04_r8, 1.01086e-03_r8, 1.15991e-03_r8, 1.33094e-03_r8, 1.52718e-03_r8, &
     & 1.75237e-03_r8, 2.01075e-03_r8, 2.30724e-03_r8, 2.64744e-03_r8, 3.03780e-03_r8, &
     & 3.48572e-03_r8, 3.99969e-03_r8, 4.58944e-03_r8, 5.26614e-03_r8/)
      kao_mco2( 7, :, 4) = (/ &
     & 8.09850e-04_r8, 9.09940e-04_r8, 1.02240e-03_r8, 1.14876e-03_r8, 1.29074e-03_r8, &
     & 1.45026e-03_r8, 1.62950e-03_r8, 1.83089e-03_r8, 2.05718e-03_r8, 2.31143e-03_r8, &
     & 2.59710e-03_r8, 2.91808e-03_r8, 3.27873e-03_r8, 3.68395e-03_r8, 4.13926e-03_r8, &
     & 4.65083e-03_r8, 5.22564e-03_r8, 5.87148e-03_r8, 6.59715e-03_r8/)
      kao_mco2( 8, :, 4) = (/ &
     & 3.13265e-03_r8, 3.42454e-03_r8, 3.74362e-03_r8, 4.09243e-03_r8, 4.47375e-03_r8, &
     & 4.89059e-03_r8, 5.34627e-03_r8, 5.84441e-03_r8, 6.38897e-03_r8, 6.98426e-03_r8, &
     & 7.63502e-03_r8, 8.34642e-03_r8, 9.12409e-03_r8, 9.97423e-03_r8, 1.09036e-02_r8, &
     & 1.19195e-02_r8, 1.30301e-02_r8, 1.42442e-02_r8, 1.55714e-02_r8/)
      kao_mco2( 9, :, 4) = (/ &
     & 5.71287e-04_r8, 6.51252e-04_r8, 7.42411e-04_r8, 8.46330e-04_r8, 9.64794e-04_r8, &
     & 1.09984e-03_r8, 1.25379e-03_r8, 1.42929e-03_r8, 1.62935e-03_r8, 1.85742e-03_r8, &
     & 2.11741e-03_r8, 2.41380e-03_r8, 2.75167e-03_r8, 3.13683e-03_r8, 3.57591e-03_r8, &
     & 4.07645e-03_r8, 4.64705e-03_r8, 5.29751e-03_r8, 6.03903e-03_r8/)
      kao_mco2( 1, :, 5) = (/ &
     & 2.92395e-04_r8, 3.32719e-04_r8, 3.78604e-04_r8, 4.30818e-04_r8, 4.90232e-04_r8, &
     & 5.57839e-04_r8, 6.34771e-04_r8, 7.22312e-04_r8, 8.21927e-04_r8, 9.35278e-04_r8, &
     & 1.06426e-03_r8, 1.21104e-03_r8, 1.37805e-03_r8, 1.56810e-03_r8, 1.78435e-03_r8, &
     & 2.03043e-03_r8, 2.31045e-03_r8, 2.62908e-03_r8, 2.99166e-03_r8/)
      kao_mco2( 2, :, 5) = (/ &
     & 3.13069e-04_r8, 3.61343e-04_r8, 4.17061e-04_r8, 4.81371e-04_r8, 5.55597e-04_r8, &
     & 6.41269e-04_r8, 7.40151e-04_r8, 8.54280e-04_r8, 9.86008e-04_r8, 1.13805e-03_r8, &
     & 1.31353e-03_r8, 1.51608e-03_r8, 1.74985e-03_r8, 2.01967e-03_r8, 2.33110e-03_r8, &
     & 2.69055e-03_r8, 3.10543e-03_r8, 3.58427e-03_r8, 4.13696e-03_r8/)
      kao_mco2( 3, :, 5) = (/ &
     & 3.06937e-04_r8, 3.57841e-04_r8, 4.17187e-04_r8, 4.86375e-04_r8, 5.67038e-04_r8, &
     & 6.61078e-04_r8, 7.70714e-04_r8, 8.98532e-04_r8, 1.04755e-03_r8, 1.22128e-03_r8, &
     & 1.42382e-03_r8, 1.65996e-03_r8, 1.93525e-03_r8, 2.25620e-03_r8, 2.63038e-03_r8, &
     & 3.06661e-03_r8, 3.57519e-03_r8, 4.16812e-03_r8, 4.85937e-03_r8/)
      kao_mco2( 4, :, 5) = (/ &
     & 4.06428e-04_r8, 4.72379e-04_r8, 5.49033e-04_r8, 6.38125e-04_r8, 7.41674e-04_r8, &
     & 8.62026e-04_r8, 1.00191e-03_r8, 1.16449e-03_r8, 1.35345e-03_r8, 1.57308e-03_r8, &
     & 1.82834e-03_r8, 2.12503e-03_r8, 2.46986e-03_r8, 2.87064e-03_r8, 3.33647e-03_r8, &
     & 3.87788e-03_r8, 4.50715e-03_r8, 5.23852e-03_r8, 6.08858e-03_r8/)
      kao_mco2( 5, :, 5) = (/ &
     & 6.01967e-04_r8, 6.90414e-04_r8, 7.91856e-04_r8, 9.08204e-04_r8, 1.04165e-03_r8, &
     & 1.19470e-03_r8, 1.37023e-03_r8, 1.57156e-03_r8, 1.80247e-03_r8, 2.06731e-03_r8, &
     & 2.37106e-03_r8, 2.71944e-03_r8, 3.11901e-03_r8, 3.57729e-03_r8, 4.10290e-03_r8, &
     & 4.70574e-03_r8, 5.39716e-03_r8, 6.19017e-03_r8, 7.09969e-03_r8/)
      kao_mco2( 6, :, 5) = (/ &
     & 1.11622e-03_r8, 1.25799e-03_r8, 1.41776e-03_r8, 1.59783e-03_r8, 1.80077e-03_r8, &
     & 2.02947e-03_r8, 2.28723e-03_r8, 2.57773e-03_r8, 2.90512e-03_r8, 3.27408e-03_r8, &
     & 3.68992e-03_r8, 4.15856e-03_r8, 4.68673e-03_r8, 5.28197e-03_r8, 5.95282e-03_r8, &
     & 6.70887e-03_r8, 7.56094e-03_r8, 8.52123e-03_r8, 9.60348e-03_r8/)
      kao_mco2( 7, :, 5) = (/ &
     & 3.63860e-03_r8, 3.96164e-03_r8, 4.31337e-03_r8, 4.69632e-03_r8, 5.11327e-03_r8, &
     & 5.56724e-03_r8, 6.06151e-03_r8, 6.59967e-03_r8, 7.18561e-03_r8, 7.82356e-03_r8, &
     & 8.51816e-03_r8, 9.27443e-03_r8, 1.00978e-02_r8, 1.09943e-02_r8, 1.19705e-02_r8, &
     & 1.30332e-02_r8, 1.41904e-02_r8, 1.54502e-02_r8, 1.68219e-02_r8/)
      kao_mco2( 8, :, 5) = (/ &
     & 5.96957e-03_r8, 6.53049e-03_r8, 7.14412e-03_r8, 7.81541e-03_r8, 8.54977e-03_r8, &
     & 9.35314e-03_r8, 1.02320e-02_r8, 1.11934e-02_r8, 1.22452e-02_r8, 1.33958e-02_r8, &
     & 1.46545e-02_r8, 1.60315e-02_r8, 1.75379e-02_r8, 1.91858e-02_r8, 2.09886e-02_r8, &
     & 2.29608e-02_r8, 2.51182e-02_r8, 2.74784e-02_r8, 3.00604e-02_r8/)
      kao_mco2( 9, :, 5) = (/ &
     & 1.19381e-03_r8, 1.33882e-03_r8, 1.50143e-03_r8, 1.68379e-03_r8, 1.88831e-03_r8, &
     & 2.11767e-03_r8, 2.37488e-03_r8, 2.66333e-03_r8, 2.98683e-03_r8, 3.34961e-03_r8, &
     & 3.75646e-03_r8, 4.21272e-03_r8, 4.72440e-03_r8, 5.29823e-03_r8, 5.94176e-03_r8, &
     & 6.66345e-03_r8, 7.47280e-03_r8, 8.38045e-03_r8, 9.39835e-03_r8/)
      kao_mco2( 1, :, 6) = (/ &
     & 4.12429e-04_r8, 4.84830e-04_r8, 5.69942e-04_r8, 6.69995e-04_r8, 7.87613e-04_r8, &
     & 9.25878e-04_r8, 1.08842e-03_r8, 1.27949e-03_r8, 1.50410e-03_r8, 1.76814e-03_r8, &
     & 2.07854e-03_r8, 2.44343e-03_r8, 2.87237e-03_r8, 3.37662e-03_r8, 3.96938e-03_r8, &
     & 4.66621e-03_r8, 5.48536e-03_r8, 6.44831e-03_r8, 7.58031e-03_r8/)
      kao_mco2( 2, :, 6) = (/ &
     & 6.43498e-04_r8, 7.46132e-04_r8, 8.65134e-04_r8, 1.00312e-03_r8, 1.16311e-03_r8, &
     & 1.34861e-03_r8, 1.56371e-03_r8, 1.81310e-03_r8, 2.10228e-03_r8, 2.43758e-03_r8, &
     & 2.82635e-03_r8, 3.27714e-03_r8, 3.79981e-03_r8, 4.40586e-03_r8, 5.10855e-03_r8, &
     & 5.92333e-03_r8, 6.86806e-03_r8, 7.96346e-03_r8, 9.23357e-03_r8/)
      kao_mco2( 3, :, 6) = (/ &
     & 1.11336e-03_r8, 1.26910e-03_r8, 1.44662e-03_r8, 1.64897e-03_r8, 1.87962e-03_r8, &
     & 2.14254e-03_r8, 2.44224e-03_r8, 2.78385e-03_r8, 3.17325e-03_r8, 3.61712e-03_r8, &
     & 4.12308e-03_r8, 4.69981e-03_r8, 5.35720e-03_r8, 6.10656e-03_r8, 6.96073e-03_r8, &
     & 7.93439e-03_r8, 9.04424e-03_r8, 1.03093e-02_r8, 1.17514e-02_r8/)
      kao_mco2( 4, :, 6) = (/ &
     & 1.87991e-03_r8, 2.10276e-03_r8, 2.35202e-03_r8, 2.63082e-03_r8, 2.94268e-03_r8, &
     & 3.29150e-03_r8, 3.68168e-03_r8, 4.11810e-03_r8, 4.60626e-03_r8, 5.15228e-03_r8, &
     & 5.76303e-03_r8, 6.44617e-03_r8, 7.21030e-03_r8, 8.06500e-03_r8, 9.02102e-03_r8, &
     & 1.00904e-02_r8, 1.12865e-02_r8, 1.26244e-02_r8, 1.41208e-02_r8/)
      kao_mco2( 5, :, 6) = (/ &
     & 3.65848e-03_r8, 4.01372e-03_r8, 4.40346e-03_r8, 4.83104e-03_r8, 5.30015e-03_r8, &
     & 5.81480e-03_r8, 6.37943e-03_r8, 6.99888e-03_r8, 7.67849e-03_r8, 8.42408e-03_r8, &
     & 9.24208e-03_r8, 1.01395e-02_r8, 1.11241e-02_r8, 1.22042e-02_r8, 1.33893e-02_r8, &
     & 1.46894e-02_r8, 1.61158e-02_r8, 1.76806e-02_r8, 1.93975e-02_r8/)
      kao_mco2( 6, :, 6) = (/ &
     & 5.38476e-03_r8, 5.85088e-03_r8, 6.35735e-03_r8, 6.90765e-03_r8, 7.50560e-03_r8, &
     & 8.15530e-03_r8, 8.86124e-03_r8, 9.62829e-03_r8, 1.04617e-02_r8, 1.13673e-02_r8, &
     & 1.23513e-02_r8, 1.34205e-02_r8, 1.45822e-02_r8, 1.58445e-02_r8, 1.72160e-02_r8, &
     & 1.87062e-02_r8, 2.03255e-02_r8, 2.20849e-02_r8, 2.39966e-02_r8/)
      kao_mco2( 7, :, 6) = (/ &
     & 6.27017e-03_r8, 6.84772e-03_r8, 7.47846e-03_r8, 8.16731e-03_r8, 8.91960e-03_r8, &
     & 9.74118e-03_r8, 1.06384e-02_r8, 1.16183e-02_r8, 1.26885e-02_r8, 1.38573e-02_r8, &
     & 1.51336e-02_r8, 1.65276e-02_r8, 1.80500e-02_r8, 1.97125e-02_r8, 2.15283e-02_r8, &
     & 2.35112e-02_r8, 2.56769e-02_r8, 2.80420e-02_r8, 3.06249e-02_r8/)
      kao_mco2( 8, :, 6) = (/ &
     & 9.61932e-03_r8, 1.04802e-02_r8, 1.14182e-02_r8, 1.24401e-02_r8, 1.35534e-02_r8, &
     & 1.47664e-02_r8, 1.60880e-02_r8, 1.75278e-02_r8, 1.90965e-02_r8, 2.08056e-02_r8, &
     & 2.26677e-02_r8, 2.46964e-02_r8, 2.69066e-02_r8, 2.93147e-02_r8, 3.19383e-02_r8, &
     & 3.47967e-02_r8, 3.79110e-02_r8, 4.13039e-02_r8, 4.50005e-02_r8/)
      kao_mco2( 9, :, 6) = (/ &
     & 2.37921e-03_r8, 2.64556e-03_r8, 2.94173e-03_r8, 3.27105e-03_r8, 3.63724e-03_r8, &
     & 4.04442e-03_r8, 4.49718e-03_r8, 5.00064e-03_r8, 5.56045e-03_r8, 6.18293e-03_r8, &
     & 6.87510e-03_r8, 7.64475e-03_r8, 8.50057e-03_r8, 9.45219e-03_r8, 1.05103e-02_r8, &
     & 1.16870e-02_r8, 1.29953e-02_r8, 1.44501e-02_r8, 1.60677e-02_r8/)
      kao_mco2( 1, :, 7) = (/ &
     & 4.64970e-03_r8, 5.13188e-03_r8, 5.66406e-03_r8, 6.25144e-03_r8, 6.89972e-03_r8, &
     & 7.61523e-03_r8, 8.40493e-03_r8, 9.27654e-03_r8, 1.02385e-02_r8, 1.13003e-02_r8, &
     & 1.24721e-02_r8, 1.37655e-02_r8, 1.51930e-02_r8, 1.67685e-02_r8, 1.85075e-02_r8, &
     & 2.04267e-02_r8, 2.25450e-02_r8, 2.48829e-02_r8, 2.74633e-02_r8/)
      kao_mco2( 2, :, 7) = (/ &
     & 6.37148e-03_r8, 6.96805e-03_r8, 7.62046e-03_r8, 8.33397e-03_r8, 9.11428e-03_r8, &
     & 9.96765e-03_r8, 1.09009e-02_r8, 1.19216e-02_r8, 1.30378e-02_r8, 1.42585e-02_r8, &
     & 1.55935e-02_r8, 1.70536e-02_r8, 1.86503e-02_r8, 2.03965e-02_r8, 2.23062e-02_r8, &
     & 2.43948e-02_r8, 2.66789e-02_r8, 2.91768e-02_r8, 3.19086e-02_r8/)
      kao_mco2( 3, :, 7) = (/ &
     & 7.79364e-03_r8, 8.48097e-03_r8, 9.22892e-03_r8, 1.00428e-02_r8, 1.09285e-02_r8, &
     & 1.18923e-02_r8, 1.29411e-02_r8, 1.40825e-02_r8, 1.53244e-02_r8, 1.66759e-02_r8, &
     & 1.81466e-02_r8, 1.97470e-02_r8, 2.14885e-02_r8, 2.33836e-02_r8, 2.54458e-02_r8, &
     & 2.76899e-02_r8, 3.01320e-02_r8, 3.27893e-02_r8, 3.56811e-02_r8/)
      kao_mco2( 4, :, 7) = (/ &
     & 8.70586e-03_r8, 9.48737e-03_r8, 1.03390e-02_r8, 1.12672e-02_r8, 1.22786e-02_r8, &
     & 1.33808e-02_r8, 1.45820e-02_r8, 1.58910e-02_r8, 1.73175e-02_r8, 1.88721e-02_r8, &
     & 2.05662e-02_r8, 2.24124e-02_r8, 2.44243e-02_r8, 2.66169e-02_r8, 2.90062e-02_r8, &
     & 3.16101e-02_r8, 3.44477e-02_r8, 3.75400e-02_r8, 4.09099e-02_r8/)
      kao_mco2( 5, :, 7) = (/ &
     & 9.24510e-03_r8, 1.00865e-02_r8, 1.10045e-02_r8, 1.20061e-02_r8, 1.30988e-02_r8, &
     & 1.42910e-02_r8, 1.55916e-02_r8, 1.70106e-02_r8, 1.85588e-02_r8, 2.02479e-02_r8, &
     & 2.20908e-02_r8, 2.41013e-02_r8, 2.62948e-02_r8, 2.86880e-02_r8, 3.12990e-02_r8, &
     & 3.41476e-02_r8, 3.72555e-02_r8, 4.06462e-02_r8, 4.43455e-02_r8/)
      kao_mco2( 6, :, 7) = (/ &
     & 1.09559e-02_r8, 1.19933e-02_r8, 1.31290e-02_r8, 1.43722e-02_r8, 1.57331e-02_r8, &
     & 1.72229e-02_r8, 1.88537e-02_r8, 2.06390e-02_r8, 2.25933e-02_r8, 2.47327e-02_r8, &
     & 2.70747e-02_r8, 2.96384e-02_r8, 3.24449e-02_r8, 3.55171e-02_r8, 3.88802e-02_r8, &
     & 4.25619e-02_r8, 4.65921e-02_r8, 5.10039e-02_r8, 5.58335e-02_r8/)
      kao_mco2( 7, :, 7) = (/ &
     & 1.36116e-02_r8, 1.48659e-02_r8, 1.62357e-02_r8, 1.77318e-02_r8, 1.93657e-02_r8, &
     & 2.11502e-02_r8, 2.30991e-02_r8, 2.52276e-02_r8, 2.75522e-02_r8, 3.00910e-02_r8, &
     & 3.28638e-02_r8, 3.58921e-02_r8, 3.91995e-02_r8, 4.28116e-02_r8, 4.67565e-02_r8, &
     & 5.10650e-02_r8, 5.57704e-02_r8, 6.09095e-02_r8, 6.65221e-02_r8/)
      kao_mco2( 8, :, 7) = (/ &
     & 1.51783e-02_r8, 1.64551e-02_r8, 1.78392e-02_r8, 1.93399e-02_r8, 2.09667e-02_r8, &
     & 2.27304e-02_r8, 2.46424e-02_r8, 2.67153e-02_r8, 2.89626e-02_r8, 3.13988e-02_r8, &
     & 3.40401e-02_r8, 3.69035e-02_r8, 4.00077e-02_r8, 4.33731e-02_r8, 4.70216e-02_r8, &
     & 5.09770e-02_r8, 5.52651e-02_r8, 5.99139e-02_r8, 6.49538e-02_r8/)
      kao_mco2( 9, :, 7) = (/ &
     & 1.00072e-02_r8, 1.08638e-02_r8, 1.17937e-02_r8, 1.28032e-02_r8, 1.38991e-02_r8, &
     & 1.50888e-02_r8, 1.63803e-02_r8, 1.77824e-02_r8, 1.93045e-02_r8, 2.09568e-02_r8, &
     & 2.27507e-02_r8, 2.46980e-02_r8, 2.68120e-02_r8, 2.91070e-02_r8, 3.15984e-02_r8, &
     & 3.43031e-02_r8, 3.72393e-02_r8, 4.04268e-02_r8, 4.38872e-02_r8/)
      kao_mco2( 1, :, 8) = (/ &
     & 1.59610e-02_r8, 1.74387e-02_r8, 1.90532e-02_r8, 2.08171e-02_r8, 2.27444e-02_r8, &
     & 2.48501e-02_r8, 2.71508e-02_r8, 2.96645e-02_r8, 3.24109e-02_r8, 3.54115e-02_r8, &
     & 3.86900e-02_r8, 4.22720e-02_r8, 4.61856e-02_r8, 5.04616e-02_r8, 5.51334e-02_r8, &
     & 6.02378e-02_r8, 6.58147e-02_r8, 7.19079e-02_r8, 7.85653e-02_r8/)
      kao_mco2( 2, :, 8) = (/ &
     & 1.61961e-02_r8, 1.76986e-02_r8, 1.93405e-02_r8, 2.11348e-02_r8, 2.30955e-02_r8, &
     & 2.52381e-02_r8, 2.75794e-02_r8, 3.01380e-02_r8, 3.29340e-02_r8, 3.59893e-02_r8, &
     & 3.93280e-02_r8, 4.29766e-02_r8, 4.69636e-02_r8, 5.13204e-02_r8, 5.60815e-02_r8, &
     & 6.12843e-02_r8, 6.69697e-02_r8, 7.31826e-02_r8, 7.99718e-02_r8/)
      kao_mco2( 3, :, 8) = (/ &
     & 1.72034e-02_r8, 1.88241e-02_r8, 2.05974e-02_r8, 2.25377e-02_r8, 2.46609e-02_r8, &
     & 2.69841e-02_r8, 2.95261e-02_r8, 3.23076e-02_r8, 3.53511e-02_r8, 3.86813e-02_r8, &
     & 4.23253e-02_r8, 4.63126e-02_r8, 5.06754e-02_r8, 5.54493e-02_r8, 6.06728e-02_r8, &
     & 6.63885e-02_r8, 7.26426e-02_r8, 7.94859e-02_r8, 8.69738e-02_r8/)
      kao_mco2( 4, :, 8) = (/ &
     & 1.79777e-02_r8, 1.96517e-02_r8, 2.14815e-02_r8, 2.34817e-02_r8, 2.56682e-02_r8, &
     & 2.80583e-02_r8, 3.06709e-02_r8, 3.35268e-02_r8, 3.66486e-02_r8, 4.00611e-02_r8, &
     & 4.37914e-02_r8, 4.78690e-02_r8, 5.23262e-02_r8, 5.71985e-02_r8, 6.25245e-02_r8, &
     & 6.83464e-02_r8, 7.47104e-02_r8, 8.16670e-02_r8, 8.92713e-02_r8/)
      kao_mco2( 5, :, 8) = (/ &
     & 2.02540e-02_r8, 2.21214e-02_r8, 2.41610e-02_r8, 2.63887e-02_r8, 2.88218e-02_r8, &
     & 3.14792e-02_r8, 3.43816e-02_r8, 3.75516e-02_r8, 4.10139e-02_r8, 4.47954e-02_r8, &
     & 4.89256e-02_r8, 5.34366e-02_r8, 5.83635e-02_r8, 6.37447e-02_r8, 6.96220e-02_r8, &
     & 7.60413e-02_r8, 8.30523e-02_r8, 9.07098e-02_r8, 9.90734e-02_r8/)
      kao_mco2( 6, :, 8) = (/ &
     & 2.19009e-02_r8, 2.38517e-02_r8, 2.59762e-02_r8, 2.82899e-02_r8, 3.08097e-02_r8, &
     & 3.35540e-02_r8, 3.65427e-02_r8, 3.97976e-02_r8, 4.33424e-02_r8, 4.72030e-02_r8, &
     & 5.14074e-02_r8, 5.59863e-02_r8, 6.09731e-02_r8, 6.64040e-02_r8, 7.23187e-02_r8, &
     & 7.87603e-02_r8, 8.57755e-02_r8, 9.34157e-02_r8, 1.01736e-01_r8/)
      kao_mco2( 7, :, 8) = (/ &
     & 2.52383e-02_r8, 2.73978e-02_r8, 2.97421e-02_r8, 3.22869e-02_r8, 3.50496e-02_r8, &
     & 3.80486e-02_r8, 4.13042e-02_r8, 4.48383e-02_r8, 4.86749e-02_r8, 5.28397e-02_r8, &
     & 5.73610e-02_r8, 6.22690e-02_r8, 6.75970e-02_r8, 7.33810e-02_r8, 7.96598e-02_r8, &
     & 8.64758e-02_r8, 9.38751e-02_r8, 1.01907e-01_r8, 1.10627e-01_r8/)
      kao_mco2( 8, :, 8) = (/ &
     & 3.36506e-02_r8, 3.59288e-02_r8, 3.83613e-02_r8, 4.09584e-02_r8, 4.37313e-02_r8, &
     & 4.66920e-02_r8, 4.98531e-02_r8, 5.32283e-02_r8, 5.68319e-02_r8, 6.06795e-02_r8, &
     & 6.47876e-02_r8, 6.91739e-02_r8, 7.38570e-02_r8, 7.88573e-02_r8, 8.41960e-02_r8, &
     & 8.98962e-02_r8, 9.59824e-02_r8, 1.02481e-01_r8, 1.09419e-01_r8/)
      kao_mco2( 9, :, 8) = (/ &
     & 2.15151e-02_r8, 2.34420e-02_r8, 2.55415e-02_r8, 2.78291e-02_r8, 3.03215e-02_r8, &
     & 3.30372e-02_r8, 3.59961e-02_r8, 3.92200e-02_r8, 4.27326e-02_r8, 4.65598e-02_r8, &
     & 5.07299e-02_r8, 5.52734e-02_r8, 6.02238e-02_r8, 6.56176e-02_r8, 7.14944e-02_r8, &
     & 7.78977e-02_r8, 8.48744e-02_r8, 9.24759e-02_r8, 1.00758e-01_r8/)
      kao_mco2( 1, :, 9) = (/ &
     & 3.34296e-02_r8, 3.64437e-02_r8, 3.97294e-02_r8, 4.33114e-02_r8, 4.72164e-02_r8, &
     & 5.14734e-02_r8, 5.61143e-02_r8, 6.11735e-02_r8, 6.66890e-02_r8, 7.27016e-02_r8, &
     & 7.92564e-02_r8, 8.64022e-02_r8, 9.41922e-02_r8, 1.02685e-01_r8, 1.11943e-01_r8, &
     & 1.22035e-01_r8, 1.33038e-01_r8, 1.45033e-01_r8, 1.58109e-01_r8/)
      kao_mco2( 2, :, 9) = (/ &
     & 3.73946e-02_r8, 4.07543e-02_r8, 4.44160e-02_r8, 4.84066e-02_r8, 5.27558e-02_r8, &
     & 5.74958e-02_r8, 6.26616e-02_r8, 6.82915e-02_r8, 7.44273e-02_r8, 8.11144e-02_r8, &
     & 8.84023e-02_r8, 9.63449e-02_r8, 1.05001e-01_r8, 1.14435e-01_r8, 1.24717e-01_r8, &
     & 1.35922e-01_r8, 1.48135e-01_r8, 1.61444e-01_r8, 1.75949e-01_r8/)
      kao_mco2( 3, :, 9) = (/ &
     & 4.24539e-02_r8, 4.61192e-02_r8, 5.01010e-02_r8, 5.44265e-02_r8, 5.91255e-02_r8, &
     & 6.42302e-02_r8, 6.97756e-02_r8, 7.57998e-02_r8, 8.23442e-02_r8, 8.94535e-02_r8, &
     & 9.71766e-02_r8, 1.05566e-01_r8, 1.14681e-01_r8, 1.24582e-01_r8, 1.35338e-01_r8, &
     & 1.47022e-01_r8, 1.59716e-01_r8, 1.73505e-01_r8, 1.88485e-01_r8/)
      kao_mco2( 4, :, 9) = (/ &
     & 5.30296e-02_r8, 5.73416e-02_r8, 6.20043e-02_r8, 6.70462e-02_r8, 7.24980e-02_r8, &
     & 7.83931e-02_r8, 8.47676e-02_r8, 9.16604e-02_r8, 9.91137e-02_r8, 1.07173e-01_r8, &
     & 1.15888e-01_r8, 1.25311e-01_r8, 1.35501e-01_r8, 1.46519e-01_r8, 1.58433e-01_r8, &
     & 1.71316e-01_r8, 1.85246e-01_r8, 2.00309e-01_r8, 2.16597e-01_r8/)
      kao_mco2( 5, :, 9) = (/ &
     & 6.26111e-02_r8, 6.74018e-02_r8, 7.25591e-02_r8, 7.81111e-02_r8, 8.40878e-02_r8, &
     & 9.05218e-02_r8, 9.74482e-02_r8, 1.04904e-01_r8, 1.12931e-01_r8, 1.21572e-01_r8, &
     & 1.30875e-01_r8, 1.40889e-01_r8, 1.51669e-01_r8, 1.63274e-01_r8, 1.75767e-01_r8, &
     & 1.89216e-01_r8, 2.03694e-01_r8, 2.19279e-01_r8, 2.36058e-01_r8/)
      kao_mco2( 6, :, 9) = (/ &
     & 7.59080e-02_r8, 8.13446e-02_r8, 8.71706e-02_r8, 9.34139e-02_r8, 1.00104e-01_r8, &
     & 1.07274e-01_r8, 1.14957e-01_r8, 1.23190e-01_r8, 1.32013e-01_r8, 1.41468e-01_r8, &
     & 1.51600e-01_r8, 1.62458e-01_r8, 1.74094e-01_r8, 1.86562e-01_r8, 1.99924e-01_r8, &
     & 2.14243e-01_r8, 2.29587e-01_r8, 2.46031e-01_r8, 2.63652e-01_r8/)
      kao_mco2( 7, :, 9) = (/ &
     & 8.81942e-02_r8, 9.39942e-02_r8, 1.00176e-01_r8, 1.06763e-01_r8, 1.13784e-01_r8, &
     & 1.21267e-01_r8, 1.29242e-01_r8, 1.37742e-01_r8, 1.46800e-01_r8, 1.56454e-01_r8, &
     & 1.66743e-01_r8, 1.77708e-01_r8, 1.89395e-01_r8, 2.01850e-01_r8, 2.15124e-01_r8, &
     & 2.29272e-01_r8, 2.44349e-01_r8, 2.60418e-01_r8, 2.77544e-01_r8/)
      kao_mco2( 8, :, 9) = (/ &
     & 6.28535e-02_r8, 6.69314e-02_r8, 7.12740e-02_r8, 7.58982e-02_r8, 8.08225e-02_r8, &
     & 8.60662e-02_r8, 9.16502e-02_r8, 9.75965e-02_r8, 1.03929e-01_r8, 1.10671e-01_r8, &
     & 1.17852e-01_r8, 1.25498e-01_r8, 1.33640e-01_r8, 1.42311e-01_r8, 1.51544e-01_r8, &
     & 1.61376e-01_r8, 1.71846e-01_r8, 1.82996e-01_r8, 1.94868e-01_r8/)
      kao_mco2( 9, :, 9) = (/ &
     & 6.39196e-02_r8, 6.86702e-02_r8, 7.37738e-02_r8, 7.92568e-02_r8, 8.51473e-02_r8, &
     & 9.14756e-02_r8, 9.82742e-02_r8, 1.05578e-01_r8, 1.13425e-01_r8, 1.21855e-01_r8, &
     & 1.30911e-01_r8, 1.40641e-01_r8, 1.51093e-01_r8, 1.62323e-01_r8, 1.74387e-01_r8, &
     & 1.87348e-01_r8, 2.01272e-01_r8, 2.16231e-01_r8, 2.32301e-01_r8/)
      kao_mco2( 1, :,10) = (/ &
     & 9.44086e-02_r8, 1.02788e-01_r8, 1.11911e-01_r8, 1.21844e-01_r8, 1.32659e-01_r8, &
     & 1.44434e-01_r8, 1.57253e-01_r8, 1.71211e-01_r8, 1.86407e-01_r8, 2.02952e-01_r8, &
     & 2.20966e-01_r8, 2.40578e-01_r8, 2.61932e-01_r8, 2.85180e-01_r8, 3.10492e-01_r8, &
     & 3.38051e-01_r8, 3.68056e-01_r8, 4.00723e-01_r8, 4.36291e-01_r8/)
      kao_mco2( 2, :,10) = (/ &
     & 1.29528e-01_r8, 1.39646e-01_r8, 1.50554e-01_r8, 1.62315e-01_r8, 1.74994e-01_r8, &
     & 1.88664e-01_r8, 2.03401e-01_r8, 2.19290e-01_r8, 2.36419e-01_r8, 2.54887e-01_r8, &
     & 2.74798e-01_r8, 2.96263e-01_r8, 3.19406e-01_r8, 3.44356e-01_r8, 3.71255e-01_r8, &
     & 4.00256e-01_r8, 4.31522e-01_r8, 4.65230e-01_r8, 5.01571e-01_r8/)
      kao_mco2( 3, :,10) = (/ &
     & 1.52325e-01_r8, 1.62991e-01_r8, 1.74404e-01_r8, 1.86616e-01_r8, 1.99684e-01_r8, &
     & 2.13666e-01_r8, 2.28628e-01_r8, 2.44637e-01_r8, 2.61767e-01_r8, 2.80096e-01_r8, &
     & 2.99710e-01_r8, 3.20696e-01_r8, 3.43152e-01_r8, 3.67181e-01_r8, 3.92892e-01_r8, &
     & 4.20403e-01_r8, 4.49841e-01_r8, 4.81340e-01_r8, 5.15045e-01_r8/)
      kao_mco2( 4, :,10) = (/ &
     & 1.59763e-01_r8, 1.70378e-01_r8, 1.81698e-01_r8, 1.93770e-01_r8, 2.06644e-01_r8, &
     & 2.20373e-01_r8, 2.35015e-01_r8, 2.50629e-01_r8, 2.67281e-01_r8, 2.85039e-01_r8, &
     & 3.03977e-01_r8, 3.24174e-01_r8, 3.45712e-01_r8, 3.68681e-01_r8, 3.93176e-01_r8, &
     & 4.19299e-01_r8, 4.47157e-01_r8, 4.76866e-01_r8, 5.08549e-01_r8/)
      kao_mco2( 5, :,10) = (/ &
     & 1.79202e-01_r8, 1.91125e-01_r8, 2.03840e-01_r8, 2.17402e-01_r8, 2.31866e-01_r8, &
     & 2.47292e-01_r8, 2.63744e-01_r8, 2.81291e-01_r8, 3.00005e-01_r8, 3.19964e-01_r8, &
     & 3.41251e-01_r8, 3.63955e-01_r8, 3.88169e-01_r8, 4.13994e-01_r8, 4.41537e-01_r8, &
     & 4.70912e-01_r8, 5.02242e-01_r8, 5.35656e-01_r8, 5.71293e-01_r8/)
      kao_mco2( 6, :,10) = (/ &
     & 1.66628e-01_r8, 1.76984e-01_r8, 1.87984e-01_r8, 1.99668e-01_r8, 2.12078e-01_r8, &
     & 2.25259e-01_r8, 2.39259e-01_r8, 2.54129e-01_r8, 2.69924e-01_r8, 2.86700e-01_r8, &
     & 3.04519e-01_r8, 3.23446e-01_r8, 3.43549e-01_r8, 3.64901e-01_r8, 3.87580e-01_r8, &
     & 4.11669e-01_r8, 4.37255e-01_r8, 4.64431e-01_r8, 4.93297e-01_r8/)
      kao_mco2( 7, :,10) = (/ &
     & 2.03980e-01_r8, 2.17141e-01_r8, 2.31152e-01_r8, 2.46067e-01_r8, 2.61945e-01_r8, &
     & 2.78847e-01_r8, 2.96839e-01_r8, 3.15993e-01_r8, 3.36382e-01_r8, 3.58087e-01_r8, &
     & 3.81193e-01_r8, 4.05789e-01_r8, 4.31972e-01_r8, 4.59845e-01_r8, 4.89517e-01_r8, &
     & 5.21103e-01_r8, 5.54727e-01_r8, 5.90520e-01_r8, 6.28623e-01_r8/)
      kao_mco2( 8, :,10) = (/ &
     & 1.96161e-04_r8, 2.07177e-04_r8, 2.18812e-04_r8, 2.31101e-04_r8, 2.44079e-04_r8, &
     & 2.57787e-04_r8, 2.72264e-04_r8, 2.87554e-04_r8, 3.03703e-04_r8, 3.20758e-04_r8, &
     & 3.38772e-04_r8, 3.57797e-04_r8, 3.77891e-04_r8, 3.99113e-04_r8, 4.21527e-04_r8, &
     & 4.45200e-04_r8, 4.70202e-04_r8, 4.96608e-04_r8, 5.24498e-04_r8/)
      kao_mco2( 9, :,10) = (/ &
     & 1.76275e-01_r8, 1.88091e-01_r8, 2.00699e-01_r8, 2.14152e-01_r8, 2.28507e-01_r8, &
     & 2.43824e-01_r8, 2.60168e-01_r8, 2.77607e-01_r8, 2.96216e-01_r8, 3.16071e-01_r8, &
     & 3.37258e-01_r8, 3.59865e-01_r8, 3.83987e-01_r8, 4.09726e-01_r8, 4.37190e-01_r8, &
     & 4.66495e-01_r8, 4.97765e-01_r8, 5.31131e-01_r8, 5.66733e-01_r8/)
      kao_mco2( 1, :,11) = (/ &
     & 1.99797e-01_r8, 2.14154e-01_r8, 2.29543e-01_r8, 2.46038e-01_r8, 2.63718e-01_r8, &
     & 2.82669e-01_r8, 3.02981e-01_r8, 3.24753e-01_r8, 3.48090e-01_r8, 3.73104e-01_r8, &
     & 3.99915e-01_r8, 4.28652e-01_r8, 4.59455e-01_r8, 4.92471e-01_r8, 5.27859e-01_r8, &
     & 5.65791e-01_r8, 6.06448e-01_r8, 6.50027e-01_r8, 6.96738e-01_r8/)
      kao_mco2( 2, :,11) = (/ &
     & 2.20638e-01_r8, 2.35685e-01_r8, 2.51759e-01_r8, 2.68929e-01_r8, 2.87271e-01_r8, &
     & 3.06863e-01_r8, 3.27791e-01_r8, 3.50146e-01_r8, 3.74026e-01_r8, 3.99535e-01_r8, &
     & 4.26784e-01_r8, 4.55891e-01_r8, 4.86983e-01_r8, 5.20195e-01_r8, 5.55673e-01_r8, &
     & 5.93570e-01_r8, 6.34052e-01_r8, 6.77294e-01_r8, 7.23486e-01_r8/)
      kao_mco2( 3, :,11) = (/ &
     & 2.62988e-01_r8, 2.80924e-01_r8, 3.00085e-01_r8, 3.20552e-01_r8, 3.42414e-01_r8, &
     & 3.65768e-01_r8, 3.90715e-01_r8, 4.17363e-01_r8, 4.45829e-01_r8, 4.76237e-01_r8, &
     & 5.08718e-01_r8, 5.43414e-01_r8, 5.80477e-01_r8, 6.20068e-01_r8, 6.62359e-01_r8, &
     & 7.07535e-01_r8, 7.55791e-01_r8, 8.07339e-01_r8, 8.62403e-01_r8/)
      kao_mco2( 4, :,11) = (/ &
     & 2.43674e-01_r8, 2.59946e-01_r8, 2.77304e-01_r8, 2.95821e-01_r8, 3.15575e-01_r8, &
     & 3.36647e-01_r8, 3.59127e-01_r8, 3.83108e-01_r8, 4.08691e-01_r8, 4.35981e-01_r8, &
     & 4.65094e-01_r8, 4.96152e-01_r8, 5.29282e-01_r8, 5.64626e-01_r8, 6.02329e-01_r8, &
     & 6.42550e-01_r8, 6.85457e-01_r8, 7.31229e-01_r8, 7.80057e-01_r8/)
      kao_mco2( 5, :,11) = (/ &
     & 2.23323e-01_r8, 2.37553e-01_r8, 2.52689e-01_r8, 2.68791e-01_r8, 2.85918e-01_r8, &
     & 3.04136e-01_r8, 3.23515e-01_r8, 3.44129e-01_r8, 3.66057e-01_r8, 3.89381e-01_r8, &
     & 4.14192e-01_r8, 4.40584e-01_r8, 4.68657e-01_r8, 4.98520e-01_r8, 5.30285e-01_r8, &
     & 5.64074e-01_r8, 6.00016e-01_r8, 6.38248e-01_r8, 6.78917e-01_r8/)
      kao_mco2( 6, :,11) = (/ &
     & 2.83716e-01_r8, 3.02622e-01_r8, 3.22788e-01_r8, 3.44298e-01_r8, 3.67241e-01_r8, &
     & 3.91713e-01_r8, 4.17816e-01_r8, 4.45658e-01_r8, 4.75356e-01_r8, 5.07033e-01_r8, &
     & 5.40820e-01_r8, 5.76859e-01_r8, 6.15300e-01_r8, 6.56302e-01_r8, 7.00037e-01_r8, &
     & 7.46686e-01_r8, 7.96443e-01_r8, 8.49516e-01_r8, 9.06126e-01_r8/)
      kao_mco2( 7, :,11) = (/ &
     & 1.00497e-03_r8, 1.06500e-03_r8, 1.12863e-03_r8, 1.19606e-03_r8, 1.26751e-03_r8, &
     & 1.34323e-03_r8, 1.42348e-03_r8, 1.50852e-03_r8, 1.59864e-03_r8, 1.69414e-03_r8, &
     & 1.79535e-03_r8, 1.90261e-03_r8, 2.01628e-03_r8, 2.13673e-03_r8, 2.26438e-03_r8, &
     & 2.39966e-03_r8, 2.54302e-03_r8, 2.69494e-03_r8, 2.85594e-03_r8/)
      kao_mco2( 8, :,11) = (/ &
     & 3.22623e-04_r8, 3.39937e-04_r8, 3.58181e-04_r8, 3.77404e-04_r8, 3.97658e-04_r8, &
     & 4.19000e-04_r8, 4.41487e-04_r8, 4.65180e-04_r8, 4.90146e-04_r8, 5.16451e-04_r8, &
     & 5.44167e-04_r8, 5.73372e-04_r8, 6.04143e-04_r8, 6.36567e-04_r8, 6.70730e-04_r8, &
     & 7.06726e-04_r8, 7.44655e-04_r8, 7.84619e-04_r8, 8.26727e-04_r8/)
      kao_mco2( 9, :,11) = (/ &
     & 2.23872e-01_r8, 2.38360e-01_r8, 2.53786e-01_r8, 2.70210e-01_r8, 2.87697e-01_r8, &
     & 3.06316e-01_r8, 3.26140e-01_r8, 3.47247e-01_r8, 3.69720e-01_r8, 3.93647e-01_r8, &
     & 4.19122e-01_r8, 4.46246e-01_r8, 4.75126e-01_r8, 5.05874e-01_r8, 5.38613e-01_r8, &
     & 5.73470e-01_r8, 6.10583e-01_r8, 6.50098e-01_r8, 6.92170e-01_r8/)
      kao_mco2( 1, :,12) = (/ &
     & 3.52418e-01_r8, 3.76085e-01_r8, 4.01341e-01_r8, 4.28293e-01_r8, 4.57055e-01_r8, &
     & 4.87749e-01_r8, 5.20504e-01_r8, 5.55458e-01_r8, 5.92760e-01_r8, 6.32567e-01_r8, &
     & 6.75047e-01_r8, 7.20380e-01_r8, 7.68757e-01_r8, 8.20383e-01_r8, 8.75476e-01_r8, &
     & 9.34268e-01_r8, 9.97009e-01_r8, 1.06396e+00_r8, 1.13541e+00_r8/)
      kao_mco2( 2, :,12) = (/ &
     & 3.38812e-01_r8, 3.61001e-01_r8, 3.84645e-01_r8, 4.09836e-01_r8, 4.36678e-01_r8, &
     & 4.65278e-01_r8, 4.95750e-01_r8, 5.28219e-01_r8, 5.62814e-01_r8, 5.99674e-01_r8, &
     & 6.38949e-01_r8, 6.80796e-01_r8, 7.25384e-01_r8, 7.72892e-01_r8, 8.23511e-01_r8, &
     & 8.77446e-01_r8, 9.34913e-01_r8, 9.96144e-01_r8, 1.06138e+00_r8/)
      kao_mco2( 3, :,12) = (/ &
     & 3.44644e-01_r8, 3.66671e-01_r8, 3.90105e-01_r8, 4.15038e-01_r8, 4.41564e-01_r8, &
     & 4.69785e-01_r8, 4.99810e-01_r8, 5.31754e-01_r8, 5.65740e-01_r8, 6.01897e-01_r8, &
     & 6.40366e-01_r8, 6.81293e-01_r8, 7.24836e-01_r8, 7.71162e-01_r8, 8.20448e-01_r8, &
     & 8.72885e-01_r8, 9.28673e-01_r8, 9.88027e-01_r8, 1.05117e+00_r8/)
      kao_mco2( 4, :,12) = (/ &
     & 4.20358e-01_r8, 4.47809e-01_r8, 4.77053e-01_r8, 5.08207e-01_r8, 5.41395e-01_r8, &
     & 5.76750e-01_r8, 6.14414e-01_r8, 6.54538e-01_r8, 6.97282e-01_r8, 7.42818e-01_r8, &
     & 7.91327e-01_r8, 8.43004e-01_r8, 8.98056e-01_r8, 9.56703e-01_r8, 1.01918e+00_r8, &
     & 1.08574e+00_r8, 1.15664e+00_r8, 1.23217e+00_r8, 1.31264e+00_r8/)
      kao_mco2( 5, :,12) = (/ &
     & 4.42756e-01_r8, 4.72000e-01_r8, 5.03174e-01_r8, 5.36408e-01_r8, 5.71837e-01_r8, &
     & 6.09606e-01_r8, 6.49870e-01_r8, 6.92793e-01_r8, 7.38551e-01_r8, 7.87331e-01_r8, &
     & 8.39333e-01_r8, 8.94770e-01_r8, 9.53868e-01_r8, 1.01687e+00_r8, 1.08403e+00_r8, &
     & 1.15563e+00_r8, 1.23196e+00_r8, 1.31333e+00_r8, 1.40007e+00_r8/)
      kao_mco2( 6, :,12) = (/ &
     & 1.53662e-01_r8, 1.63104e-01_r8, 1.73126e-01_r8, 1.83764e-01_r8, 1.95055e-01_r8, &
     & 2.07040e-01_r8, 2.19762e-01_r8, 2.33265e-01_r8, 2.47598e-01_r8, 2.62811e-01_r8, &
     & 2.78960e-01_r8, 2.96100e-01_r8, 3.14294e-01_r8, 3.33606e-01_r8, 3.54104e-01_r8, &
     & 3.75862e-01_r8, 3.98956e-01_r8, 4.23470e-01_r8, 4.49490e-01_r8/)
      kao_mco2( 7, :,12) = (/ &
     & 5.41472e-04_r8, 5.65116e-04_r8, 5.89793e-04_r8, 6.15547e-04_r8, 6.42426e-04_r8, &
     & 6.70479e-04_r8, 6.99757e-04_r8, 7.30313e-04_r8, 7.62203e-04_r8, 7.95486e-04_r8, &
     & 8.30223e-04_r8, 8.66476e-04_r8, 9.04312e-04_r8, 9.43801e-04_r8, 9.85013e-04_r8, &
     & 1.02803e-03_r8, 1.07292e-03_r8, 1.11977e-03_r8, 1.16866e-03_r8/)
      kao_mco2( 8, :,12) = (/ &
     & 5.94251e-04_r8, 6.17650e-04_r8, 6.41969e-04_r8, 6.67246e-04_r8, 6.93518e-04_r8, &
     & 7.20824e-04_r8, 7.49206e-04_r8, 7.78705e-04_r8, 8.09366e-04_r8, 8.41234e-04_r8, &
     & 8.74356e-04_r8, 9.08783e-04_r8, 9.44566e-04_r8, 9.81757e-04_r8, 1.02041e-03_r8, &
     & 1.06059e-03_r8, 1.10235e-03_r8, 1.14575e-03_r8, 1.19087e-03_r8/)
      kao_mco2( 9, :,12) = (/ &
     & 4.21683e-01_r8, 4.49025e-01_r8, 4.78140e-01_r8, 5.09142e-01_r8, 5.42155e-01_r8, &
     & 5.77309e-01_r8, 6.14741e-01_r8, 6.54601e-01_r8, 6.97046e-01_r8, 7.42242e-01_r8, &
     & 7.90369e-01_r8, 8.41617e-01_r8, 8.96188e-01_r8, 9.54297e-01_r8, 1.01617e+00_r8, &
     & 1.08206e+00_r8, 1.15222e+00_r8, 1.22693e+00_r8, 1.30649e+00_r8/)
      kao_mco2( 1, :,13) = (/ &
     & 5.61805e-01_r8, 5.98988e-01_r8, 6.38631e-01_r8, 6.80898e-01_r8, 7.25962e-01_r8, &
     & 7.74009e-01_r8, 8.25236e-01_r8, 8.79853e-01_r8, 9.38085e-01_r8, 1.00017e+00_r8, &
     & 1.06637e+00_r8, 1.13694e+00_r8, 1.21219e+00_r8, 1.29242e+00_r8, 1.37795e+00_r8, &
     & 1.46915e+00_r8, 1.56638e+00_r8, 1.67005e+00_r8, 1.78058e+00_r8/)
      kao_mco2( 2, :,13) = (/ &
     & 5.55938e-01_r8, 5.91800e-01_r8, 6.29976e-01_r8, 6.70615e-01_r8, 7.13876e-01_r8, &
     & 7.59927e-01_r8, 8.08949e-01_r8, 8.61133e-01_r8, 9.16683e-01_r8, 9.75817e-01_r8, &
     & 1.03877e+00_r8, 1.10577e+00_r8, 1.17711e+00_r8, 1.25304e+00_r8, 1.33387e+00_r8, &
     & 1.41992e+00_r8, 1.51152e+00_r8, 1.60902e+00_r8, 1.71282e+00_r8/)
      kao_mco2( 3, :,13) = (/ &
     & 5.94615e-01_r8, 6.33277e-01_r8, 6.74453e-01_r8, 7.18307e-01_r8, 7.65012e-01_r8, &
     & 8.14753e-01_r8, 8.67729e-01_r8, 9.24149e-01_r8, 9.84238e-01_r8, 1.04823e+00_r8, &
     & 1.11639e+00_r8, 1.18898e+00_r8, 1.26629e+00_r8, 1.34862e+00_r8, 1.43631e+00_r8, &
     & 1.52970e+00_r8, 1.62916e+00_r8, 1.73509e+00_r8, 1.84791e+00_r8/)
      kao_mco2( 4, :,13) = (/ &
     & 5.48973e-01_r8, 5.84145e-01_r8, 6.21570e-01_r8, 6.61394e-01_r8, 7.03768e-01_r8, &
     & 7.48858e-01_r8, 7.96836e-01_r8, 8.47889e-01_r8, 9.02212e-01_r8, 9.60015e-01_r8, &
     & 1.02152e+00_r8, 1.08697e+00_r8, 1.15661e+00_r8, 1.23071e+00_r8, 1.30956e+00_r8, &
     & 1.39347e+00_r8, 1.48274e+00_r8, 1.57774e+00_r8, 1.67883e+00_r8/)
      kao_mco2( 5, :,13) = (/ &
     & 1.49742e-01_r8, 1.59049e-01_r8, 1.68934e-01_r8, 1.79434e-01_r8, 1.90586e-01_r8, &
     & 2.02432e-01_r8, 2.15013e-01_r8, 2.28377e-01_r8, 2.42571e-01_r8, 2.57648e-01_r8, &
     & 2.73661e-01_r8, 2.90670e-01_r8, 3.08736e-01_r8, 3.27925e-01_r8, 3.48307e-01_r8, &
     & 3.69955e-01_r8, 3.92949e-01_r8, 4.17372e-01_r8, 4.43312e-01_r8/)
      kao_mco2( 6, :,13) = (/ &
     & 8.81777e-04_r8, 9.16690e-04_r8, 9.52985e-04_r8, 9.90718e-04_r8, 1.02994e-03_r8, &
     & 1.07072e-03_r8, 1.11312e-03_r8, 1.15719e-03_r8, 1.20301e-03_r8, 1.25064e-03_r8, &
     & 1.30016e-03_r8, 1.35163e-03_r8, 1.40515e-03_r8, 1.46079e-03_r8, 1.51862e-03_r8, &
     & 1.57875e-03_r8, 1.64126e-03_r8, 1.70624e-03_r8, 1.77380e-03_r8/)
      kao_mco2( 7, :,13) = (/ &
     & 8.84366e-04_r8, 9.20446e-04_r8, 9.57999e-04_r8, 9.97083e-04_r8, 1.03776e-03_r8, &
     & 1.08010e-03_r8, 1.12417e-03_r8, 1.17003e-03_r8, 1.21777e-03_r8, 1.26745e-03_r8, &
     & 1.31916e-03_r8, 1.37298e-03_r8, 1.42899e-03_r8, 1.48729e-03_r8, 1.54797e-03_r8, &
     & 1.61113e-03_r8, 1.67686e-03_r8, 1.74527e-03_r8, 1.81647e-03_r8/)
      kao_mco2( 8, :,13) = (/ &
     & 8.92597e-04_r8, 9.33069e-04_r8, 9.75377e-04_r8, 1.01960e-03_r8, 1.06583e-03_r8, &
     & 1.11416e-03_r8, 1.16468e-03_r8, 1.21749e-03_r8, 1.27269e-03_r8, 1.33040e-03_r8, &
     & 1.39073e-03_r8, 1.45378e-03_r8, 1.51970e-03_r8, 1.58861e-03_r8, 1.66064e-03_r8, &
     & 1.73594e-03_r8, 1.81465e-03_r8, 1.89693e-03_r8, 1.98294e-03_r8/)
      kao_mco2( 9, :,13) = (/ &
     & 1.46280e-01_r8, 1.55378e-01_r8, 1.65043e-01_r8, 1.75308e-01_r8, 1.86212e-01_r8, &
     & 1.97794e-01_r8, 2.10097e-01_r8, 2.23164e-01_r8, 2.37045e-01_r8, 2.51788e-01_r8, &
     & 2.67449e-01_r8, 2.84084e-01_r8, 3.01754e-01_r8, 3.20522e-01_r8, 3.40458e-01_r8, &
     & 3.61634e-01_r8, 3.84127e-01_r8, 4.08020e-01_r8, 4.33398e-01_r8/)
      kao_mco2( 1, :,14) = (/ &
     & 9.20236e-01_r8, 9.80010e-01_r8, 1.04367e+00_r8, 1.11146e+00_r8, 1.18366e+00_r8, &
     & 1.26054e+00_r8, 1.34242e+00_r8, 1.42962e+00_r8, 1.52248e+00_r8, 1.62137e+00_r8, &
     & 1.72669e+00_r8, 1.83885e+00_r8, 1.95829e+00_r8, 2.08549e+00_r8, 2.22096e+00_r8, &
     & 2.36522e+00_r8, 2.51886e+00_r8, 2.68247e+00_r8, 2.85671e+00_r8/)
      kao_mco2( 2, :,14) = (/ &
     & 8.39823e-01_r8, 8.95471e-01_r8, 9.54806e-01_r8, 1.01807e+00_r8, 1.08553e+00_r8, &
     & 1.15746e+00_r8, 1.23416e+00_r8, 1.31593e+00_r8, 1.40313e+00_r8, 1.49610e+00_r8, &
     & 1.59523e+00_r8, 1.70094e+00_r8, 1.81364e+00_r8, 1.93382e+00_r8, 2.06195e+00_r8, &
     & 2.19858e+00_r8, 2.34426e+00_r8, 2.49960e+00_r8, 2.66522e+00_r8/)
      kao_mco2( 3, :,14) = (/ &
     & 5.39252e-01_r8, 5.73971e-01_r8, 6.10925e-01_r8, 6.50259e-01_r8, 6.92125e-01_r8, &
     & 7.36686e-01_r8, 7.84117e-01_r8, 8.34601e-01_r8, 8.88336e-01_r8, 9.45530e-01_r8, &
     & 1.00641e+00_r8, 1.07120e+00_r8, 1.14017e+00_r8, 1.21358e+00_r8, 1.29171e+00_r8, &
     & 1.37488e+00_r8, 1.46340e+00_r8, 1.55762e+00_r8, 1.65790e+00_r8/)
      kao_mco2( 4, :,14) = (/ &
     & 1.14837e-03_r8, 1.19701e-03_r8, 1.24770e-03_r8, 1.30055e-03_r8, 1.35563e-03_r8, &
     & 1.41305e-03_r8, 1.47289e-03_r8, 1.53528e-03_r8, 1.60030e-03_r8, 1.66808e-03_r8, &
     & 1.73873e-03_r8, 1.81237e-03_r8, 1.88913e-03_r8, 1.96914e-03_r8, 2.05254e-03_r8, &
     & 2.13947e-03_r8, 2.23009e-03_r8, 2.32454e-03_r8, 2.42299e-03_r8/)
      kao_mco2( 5, :,14) = (/ &
     & 1.14611e-03_r8, 1.19424e-03_r8, 1.24440e-03_r8, 1.29666e-03_r8, 1.35111e-03_r8, &
     & 1.40786e-03_r8, 1.46698e-03_r8, 1.52859e-03_r8, 1.59279e-03_r8, 1.65968e-03_r8, &
     & 1.72938e-03_r8, 1.80201e-03_r8, 1.87769e-03_r8, 1.95655e-03_r8, 2.03872e-03_r8, &
     & 2.12434e-03_r8, 2.21355e-03_r8, 2.30651e-03_r8, 2.40338e-03_r8/)
      kao_mco2( 6, :,14) = (/ &
     & 1.14203e-03_r8, 1.18930e-03_r8, 1.23852e-03_r8, 1.28979e-03_r8, 1.34317e-03_r8, &
     & 1.39877e-03_r8, 1.45666e-03_r8, 1.51695e-03_r8, 1.57974e-03_r8, 1.64513e-03_r8, &
     & 1.71322e-03_r8, 1.78413e-03_r8, 1.85798e-03_r8, 1.93488e-03_r8, 2.01497e-03_r8, &
     & 2.09837e-03_r8, 2.18522e-03_r8, 2.27567e-03_r8, 2.36986e-03_r8/)
      kao_mco2( 7, :,14) = (/ &
     & 1.11217e-03_r8, 1.15727e-03_r8, 1.20421e-03_r8, 1.25305e-03_r8, 1.30386e-03_r8, &
     & 1.35674e-03_r8, 1.41177e-03_r8, 1.46902e-03_r8, 1.52860e-03_r8, 1.59059e-03_r8, &
     & 1.65510e-03_r8, 1.72222e-03_r8, 1.79207e-03_r8, 1.86475e-03_r8, 1.94037e-03_r8, &
     & 2.01907e-03_r8, 2.10095e-03_r8, 2.18616e-03_r8, 2.27482e-03_r8/)
      kao_mco2( 8, :,14) = (/ &
     & 1.21596e-03_r8, 1.25817e-03_r8, 1.30183e-03_r8, 1.34702e-03_r8, 1.39377e-03_r8, &
     & 1.44214e-03_r8, 1.49219e-03_r8, 1.54398e-03_r8, 1.59757e-03_r8, 1.65302e-03_r8, &
     & 1.71039e-03_r8, 1.76975e-03_r8, 1.83117e-03_r8, 1.89473e-03_r8, 1.96049e-03_r8, &
     & 2.02853e-03_r8, 2.09893e-03_r8, 2.17178e-03_r8, 2.24716e-03_r8/)
      kao_mco2( 9, :,14) = (/ &
     & 1.14611e-03_r8, 1.19424e-03_r8, 1.24440e-03_r8, 1.29666e-03_r8, 1.35111e-03_r8, &
     & 1.40786e-03_r8, 1.46698e-03_r8, 1.52859e-03_r8, 1.59279e-03_r8, 1.65968e-03_r8, &
     & 1.72938e-03_r8, 1.80201e-03_r8, 1.87769e-03_r8, 1.95655e-03_r8, 2.03872e-03_r8, &
     & 2.12434e-03_r8, 2.21355e-03_r8, 2.30651e-03_r8, 2.40338e-03_r8/)
      kao_mco2( 1, :,15) = (/ &
     & 1.29470e+00_r8, 1.37848e+00_r8, 1.46768e+00_r8, 1.56266e+00_r8, 1.66378e+00_r8, &
     & 1.77145e+00_r8, 1.88609e+00_r8, 2.00814e+00_r8, 2.13809e+00_r8, 2.27645e+00_r8, &
     & 2.42376e+00_r8, 2.58061e+00_r8, 2.74761e+00_r8, 2.92541e+00_r8, 3.11472e+00_r8, &
     & 3.31628e+00_r8, 3.53088e+00_r8, 3.75938e+00_r8, 4.00265e+00_r8/)
      kao_mco2( 2, :,15) = (/ &
     & 7.23701e-01_r8, 7.68508e-01_r8, 8.16089e-01_r8, 8.66616e-01_r8, 9.20272e-01_r8, &
     & 9.77250e-01_r8, 1.03775e+00_r8, 1.10201e+00_r8, 1.17024e+00_r8, 1.24269e+00_r8, &
     & 1.31963e+00_r8, 1.40133e+00_r8, 1.48809e+00_r8, 1.58023e+00_r8, 1.67807e+00_r8, &
     & 1.78196e+00_r8, 1.89229e+00_r8, 2.00945e+00_r8, 2.13386e+00_r8/)
      kao_mco2( 3, :,15) = (/ &
     & 1.81684e-03_r8, 1.85424e-03_r8, 1.89241e-03_r8, 1.93137e-03_r8, 1.97114e-03_r8, &
     & 2.01172e-03_r8, 2.05313e-03_r8, 2.09540e-03_r8, 2.13854e-03_r8, 2.18257e-03_r8, &
     & 2.22750e-03_r8, 2.27336e-03_r8, 2.32016e-03_r8, 2.36793e-03_r8, 2.41668e-03_r8, &
     & 2.46643e-03_r8, 2.51721e-03_r8, 2.56903e-03_r8, 2.62192e-03_r8/)
      kao_mco2( 4, :,15) = (/ &
     & 1.84644e-03_r8, 1.88437e-03_r8, 1.92309e-03_r8, 1.96260e-03_r8, 2.00293e-03_r8, &
     & 2.04408e-03_r8, 2.08608e-03_r8, 2.12894e-03_r8, 2.17268e-03_r8, 2.21732e-03_r8, &
     & 2.26288e-03_r8, 2.30938e-03_r8, 2.35683e-03_r8, 2.40525e-03_r8, 2.45467e-03_r8, &
     & 2.50510e-03_r8, 2.55658e-03_r8, 2.60910e-03_r8, 2.66271e-03_r8/)
      kao_mco2( 5, :,15) = (/ &
     & 1.88579e-03_r8, 1.92454e-03_r8, 1.96408e-03_r8, 2.00443e-03_r8, 2.04561e-03_r8, &
     & 2.08764e-03_r8, 2.13054e-03_r8, 2.17431e-03_r8, 2.21898e-03_r8, 2.26457e-03_r8, &
     & 2.31110e-03_r8, 2.35858e-03_r8, 2.40704e-03_r8, 2.45650e-03_r8, 2.50697e-03_r8, &
     & 2.55848e-03_r8, 2.61104e-03_r8, 2.66469e-03_r8, 2.71943e-03_r8/)
      kao_mco2( 6, :,15) = (/ &
     & 1.95322e-03_r8, 1.99316e-03_r8, 2.03391e-03_r8, 2.07549e-03_r8, 2.11793e-03_r8, &
     & 2.16123e-03_r8, 2.20542e-03_r8, 2.25051e-03_r8, 2.29652e-03_r8, 2.34347e-03_r8, &
     & 2.39139e-03_r8, 2.44028e-03_r8, 2.49017e-03_r8, 2.54109e-03_r8, 2.59304e-03_r8, &
     & 2.64605e-03_r8, 2.70015e-03_r8, 2.75536e-03_r8, 2.81169e-03_r8/)
      kao_mco2( 7, :,15) = (/ &
     & 2.13640e-03_r8, 2.17976e-03_r8, 2.22400e-03_r8, 2.26914e-03_r8, 2.31520e-03_r8, &
     & 2.36219e-03_r8, 2.41013e-03_r8, 2.45905e-03_r8, 2.50896e-03_r8, 2.55988e-03_r8, &
     & 2.61184e-03_r8, 2.66485e-03_r8, 2.71893e-03_r8, 2.77412e-03_r8, 2.83042e-03_r8, &
     & 2.88787e-03_r8, 2.94648e-03_r8, 3.00629e-03_r8, 3.06730e-03_r8/)
      kao_mco2( 8, :,15) = (/ &
     & 2.17014e-03_r8, 2.21411e-03_r8, 2.25897e-03_r8, 2.30474e-03_r8, 2.35143e-03_r8, &
     & 2.39908e-03_r8, 2.44769e-03_r8, 2.49728e-03_r8, 2.54788e-03_r8, 2.59950e-03_r8, &
     & 2.65217e-03_r8, 2.70591e-03_r8, 2.76073e-03_r8, 2.81667e-03_r8, 2.87374e-03_r8, &
     & 2.93197e-03_r8, 2.99137e-03_r8, 3.05198e-03_r8, 3.11382e-03_r8/)
      kao_mco2( 9, :,15) = (/ &
     & 1.88579e-03_r8, 1.92454e-03_r8, 1.96408e-03_r8, 2.00443e-03_r8, 2.04561e-03_r8, &
     & 2.08764e-03_r8, 2.13054e-03_r8, 2.17431e-03_r8, 2.21898e-03_r8, 2.26457e-03_r8, &
     & 2.31110e-03_r8, 2.35858e-03_r8, 2.40704e-03_r8, 2.45650e-03_r8, 2.50697e-03_r8, &
     & 2.55848e-03_r8, 2.61104e-03_r8, 2.66469e-03_r8, 2.71943e-03_r8/)
      kao_mco2( 1, :,16) = (/ &
     & 1.48989e+00_r8, 1.58377e+00_r8, 1.68356e+00_r8, 1.78964e+00_r8, 1.90241e+00_r8, &
     & 2.02228e+00_r8, 2.14971e+00_r8, 2.28516e+00_r8, 2.42915e+00_r8, 2.58221e+00_r8, &
     & 2.74492e+00_r8, 2.91788e+00_r8, 3.10174e+00_r8, 3.29718e+00_r8, 3.50494e+00_r8, &
     & 3.72578e+00_r8, 3.96055e+00_r8, 4.21010e+00_r8, 4.47538e+00_r8/)
      kao_mco2( 2, :,16) = (/ &
     & 2.10609e-03_r8, 2.14759e-03_r8, 2.18992e-03_r8, 2.23307e-03_r8, 2.27708e-03_r8, &
     & 2.32196e-03_r8, 2.36771e-03_r8, 2.41438e-03_r8, 2.46196e-03_r8, 2.51047e-03_r8, &
     & 2.55995e-03_r8, 2.61040e-03_r8, 2.66184e-03_r8, 2.71430e-03_r8, 2.76779e-03_r8, &
     & 2.82234e-03_r8, 2.87796e-03_r8, 2.93467e-03_r8, 2.99251e-03_r8/)
      kao_mco2( 3, :,16) = (/ &
     & 2.10609e-03_r8, 2.14759e-03_r8, 2.18992e-03_r8, 2.23307e-03_r8, 2.27708e-03_r8, &
     & 2.32196e-03_r8, 2.36771e-03_r8, 2.41438e-03_r8, 2.46196e-03_r8, 2.51047e-03_r8, &
     & 2.55995e-03_r8, 2.61040e-03_r8, 2.66184e-03_r8, 2.71430e-03_r8, 2.76779e-03_r8, &
     & 2.82234e-03_r8, 2.87796e-03_r8, 2.93467e-03_r8, 2.99251e-03_r8/)
      kao_mco2( 4, :,16) = (/ &
     & 2.10609e-03_r8, 2.14759e-03_r8, 2.18992e-03_r8, 2.23307e-03_r8, 2.27708e-03_r8, &
     & 2.32196e-03_r8, 2.36771e-03_r8, 2.41438e-03_r8, 2.46196e-03_r8, 2.51047e-03_r8, &
     & 2.55995e-03_r8, 2.61040e-03_r8, 2.66184e-03_r8, 2.71430e-03_r8, 2.76779e-03_r8, &
     & 2.82234e-03_r8, 2.87796e-03_r8, 2.93467e-03_r8, 2.99251e-03_r8/)
      kao_mco2( 5, :,16) = (/ &
     & 2.10609e-03_r8, 2.14759e-03_r8, 2.18992e-03_r8, 2.23307e-03_r8, 2.27708e-03_r8, &
     & 2.32196e-03_r8, 2.36771e-03_r8, 2.41438e-03_r8, 2.46196e-03_r8, 2.51047e-03_r8, &
     & 2.55995e-03_r8, 2.61040e-03_r8, 2.66184e-03_r8, 2.71430e-03_r8, 2.76779e-03_r8, &
     & 2.82234e-03_r8, 2.87796e-03_r8, 2.93467e-03_r8, 2.99251e-03_r8/)
      kao_mco2( 6, :,16) = (/ &
     & 2.10609e-03_r8, 2.14759e-03_r8, 2.18992e-03_r8, 2.23307e-03_r8, 2.27708e-03_r8, &
     & 2.32196e-03_r8, 2.36771e-03_r8, 2.41438e-03_r8, 2.46196e-03_r8, 2.51047e-03_r8, &
     & 2.55995e-03_r8, 2.61040e-03_r8, 2.66184e-03_r8, 2.71430e-03_r8, 2.76779e-03_r8, &
     & 2.82234e-03_r8, 2.87796e-03_r8, 2.93467e-03_r8, 2.99251e-03_r8/)
      kao_mco2( 7, :,16) = (/ &
     & 2.09970e-03_r8, 2.14101e-03_r8, 2.18312e-03_r8, 2.22606e-03_r8, 2.26985e-03_r8, &
     & 2.31450e-03_r8, 2.36003e-03_r8, 2.40645e-03_r8, 2.45379e-03_r8, 2.50205e-03_r8, &
     & 2.55127e-03_r8, 2.60146e-03_r8, 2.65263e-03_r8, 2.70481e-03_r8, 2.75801e-03_r8, &
     & 2.81226e-03_r8, 2.86758e-03_r8, 2.92399e-03_r8, 2.98150e-03_r8/)
      kao_mco2( 8, :,16) = (/ &
     & 2.09970e-03_r8, 2.14101e-03_r8, 2.18312e-03_r8, 2.22606e-03_r8, 2.26985e-03_r8, &
     & 2.31450e-03_r8, 2.36003e-03_r8, 2.40645e-03_r8, 2.45379e-03_r8, 2.50205e-03_r8, &
     & 2.55127e-03_r8, 2.60146e-03_r8, 2.65263e-03_r8, 2.70481e-03_r8, 2.75801e-03_r8, &
     & 2.81226e-03_r8, 2.86758e-03_r8, 2.92399e-03_r8, 2.98150e-03_r8/)
      kao_mco2( 9, :,16) = (/ &
     & 2.10609e-03_r8, 2.14759e-03_r8, 2.18992e-03_r8, 2.23307e-03_r8, 2.27708e-03_r8, &
     & 2.32196e-03_r8, 2.36771e-03_r8, 2.41438e-03_r8, 2.46196e-03_r8, 2.51047e-03_r8, &
     & 2.55995e-03_r8, 2.61040e-03_r8, 2.66184e-03_r8, 2.71430e-03_r8, 2.76779e-03_r8, &
     & 2.82234e-03_r8, 2.87796e-03_r8, 2.93467e-03_r8, 2.99251e-03_r8/)

      kao_mco( 1, :, 1) = (/ &
     & 4.58355e-01_r8, 4.47074e-01_r8, 4.36070e-01_r8, 4.25337e-01_r8, 4.14868e-01_r8, &
     & 4.04657e-01_r8, 3.94697e-01_r8, 3.84982e-01_r8, 3.75506e-01_r8, 3.66264e-01_r8, &
     & 3.57249e-01_r8, 3.48456e-01_r8, 3.39879e-01_r8, 3.31514e-01_r8, 3.23354e-01_r8, &
     & 3.15395e-01_r8, 3.07632e-01_r8, 3.00061e-01_r8, 2.92675e-01_r8/)
      kao_mco( 2, :, 1) = (/ &
     & 7.03080e-01_r8, 6.84132e-01_r8, 6.65696e-01_r8, 6.47756e-01_r8, 6.30300e-01_r8, &
     & 6.13314e-01_r8, 5.96786e-01_r8, 5.80703e-01_r8, 5.65053e-01_r8, 5.49826e-01_r8, &
     & 5.35009e-01_r8, 5.20591e-01_r8, 5.06561e-01_r8, 4.92910e-01_r8, 4.79627e-01_r8, &
     & 4.66701e-01_r8, 4.54124e-01_r8, 4.41886e-01_r8, 4.29978e-01_r8/)
      kao_mco( 3, :, 1) = (/ &
     & 8.53018e-01_r8, 8.29537e-01_r8, 8.06703e-01_r8, 7.84497e-01_r8, 7.62903e-01_r8, &
     & 7.41903e-01_r8, 7.21481e-01_r8, 7.01621e-01_r8, 6.82307e-01_r8, 6.63526e-01_r8, &
     & 6.45261e-01_r8, 6.27499e-01_r8, 6.10226e-01_r8, 5.93429e-01_r8, 5.77094e-01_r8, &
     & 5.61208e-01_r8, 5.45760e-01_r8, 5.30737e-01_r8, 5.16128e-01_r8/)
      kao_mco( 4, :, 1) = (/ &
     & 9.58866e-01_r8, 9.31881e-01_r8, 9.05654e-01_r8, 8.80166e-01_r8, 8.55395e-01_r8, &
     & 8.31321e-01_r8, 8.07925e-01_r8, 7.85187e-01_r8, 7.63089e-01_r8, 7.41613e-01_r8, &
     & 7.20742e-01_r8, 7.00457e-01_r8, 6.80744e-01_r8, 6.61586e-01_r8, 6.42966e-01_r8, &
     & 6.24871e-01_r8, 6.07285e-01_r8, 5.90194e-01_r8, 5.73584e-01_r8/)
      kao_mco( 5, :, 1) = (/ &
     & 1.07140e+00_r8, 1.04056e+00_r8, 1.01061e+00_r8, 9.81521e-01_r8, 9.53269e-01_r8, &
     & 9.25829e-01_r8, 8.99180e-01_r8, 8.73297e-01_r8, 8.48160e-01_r8, 8.23746e-01_r8, &
     & 8.00035e-01_r8, 7.77006e-01_r8, 7.54641e-01_r8, 7.32919e-01_r8, 7.11822e-01_r8, &
     & 6.91333e-01_r8, 6.71433e-01_r8, 6.52106e-01_r8, 6.33336e-01_r8/)
      kao_mco( 6, :, 1) = (/ &
     & 1.21046e+00_r8, 1.17478e+00_r8, 1.14015e+00_r8, 1.10655e+00_r8, 1.07393e+00_r8, &
     & 1.04228e+00_r8, 1.01156e+00_r8, 9.81740e-01_r8, 9.52803e-01_r8, 9.24720e-01_r8, &
     & 8.97463e-01_r8, 8.71011e-01_r8, 8.45338e-01_r8, 8.20422e-01_r8, 7.96240e-01_r8, &
     & 7.72771e-01_r8, 7.49993e-01_r8, 7.27887e-01_r8, 7.06433e-01_r8/)
      kao_mco( 7, :, 1) = (/ &
     & 1.57730e+00_r8, 1.52919e+00_r8, 1.48255e+00_r8, 1.43733e+00_r8, 1.39349e+00_r8, &
     & 1.35099e+00_r8, 1.30978e+00_r8, 1.26983e+00_r8, 1.23110e+00_r8, 1.19355e+00_r8, &
     & 1.15715e+00_r8, 1.12186e+00_r8, 1.08764e+00_r8, 1.05446e+00_r8, 1.02230e+00_r8, &
     & 9.91121e-01_r8, 9.60890e-01_r8, 9.31583e-01_r8, 9.03169e-01_r8/)
      kao_mco( 8, :, 1) = (/ &
     & 2.43678e+00_r8, 2.36595e+00_r8, 2.29719e+00_r8, 2.23042e+00_r8, 2.16560e+00_r8, &
     & 2.10266e+00_r8, 2.04154e+00_r8, 1.98221e+00_r8, 1.92460e+00_r8, 1.86866e+00_r8, &
     & 1.81435e+00_r8, 1.76162e+00_r8, 1.71042e+00_r8, 1.66070e+00_r8, 1.61244e+00_r8, &
     & 1.56557e+00_r8, 1.52007e+00_r8, 1.47589e+00_r8, 1.43300e+00_r8/)
      kao_mco( 9, :, 1) = (/ &
     & 9.66296e-01_r8, 9.39903e-01_r8, 9.14232e-01_r8, 8.89262e-01_r8, 8.64973e-01_r8, &
     & 8.41348e-01_r8, 8.18369e-01_r8, 7.96017e-01_r8, 7.74275e-01_r8, 7.53128e-01_r8, &
     & 7.32558e-01_r8, 7.12549e-01_r8, 6.93088e-01_r8, 6.74157e-01_r8, 6.55744e-01_r8, &
     & 6.37834e-01_r8, 6.20413e-01_r8, 6.03468e-01_r8, 5.86985e-01_r8/)
      kao_mco( 1, :, 2) = (/ &
     & 1.15047e+00_r8, 1.12127e+00_r8, 1.09281e+00_r8, 1.06507e+00_r8, 1.03804e+00_r8, &
     & 1.01169e+00_r8, 9.86010e-01_r8, 9.60983e-01_r8, 9.36591e-01_r8, 9.12818e-01_r8, &
     & 8.89649e-01_r8, 8.67067e-01_r8, 8.45059e-01_r8, 8.23610e-01_r8, 8.02705e-01_r8, &
     & 7.82330e-01_r8, 7.62473e-01_r8, 7.43119e-01_r8, 7.24257e-01_r8/)
      kao_mco( 2, :, 2) = (/ &
     & 1.43243e+00_r8, 1.39430e+00_r8, 1.35719e+00_r8, 1.32106e+00_r8, 1.28590e+00_r8, &
     & 1.25167e+00_r8, 1.21836e+00_r8, 1.18593e+00_r8, 1.15436e+00_r8, 1.12364e+00_r8, &
     & 1.09373e+00_r8, 1.06462e+00_r8, 1.03628e+00_r8, 1.00870e+00_r8, 9.81848e-01_r8, &
     & 9.55714e-01_r8, 9.30275e-01_r8, 9.05514e-01_r8, 8.81412e-01_r8/)
      kao_mco( 3, :, 2) = (/ &
     & 1.61389e+00_r8, 1.56911e+00_r8, 1.52556e+00_r8, 1.48323e+00_r8, 1.44207e+00_r8, &
     & 1.40205e+00_r8, 1.36314e+00_r8, 1.32531e+00_r8, 1.28854e+00_r8, 1.25278e+00_r8, &
     & 1.21801e+00_r8, 1.18421e+00_r8, 1.15135e+00_r8, 1.11940e+00_r8, 1.08834e+00_r8, &
     & 1.05814e+00_r8, 1.02877e+00_r8, 1.00022e+00_r8, 9.72466e-01_r8/)
      kao_mco( 4, :, 2) = (/ &
     & 1.78458e+00_r8, 1.73440e+00_r8, 1.68564e+00_r8, 1.63825e+00_r8, 1.59219e+00_r8, &
     & 1.54742e+00_r8, 1.50391e+00_r8, 1.46163e+00_r8, 1.42053e+00_r8, 1.38059e+00_r8, &
     & 1.34178e+00_r8, 1.30405e+00_r8, 1.26739e+00_r8, 1.23175e+00_r8, 1.19712e+00_r8, &
     & 1.16346e+00_r8, 1.13075e+00_r8, 1.09896e+00_r8, 1.06806e+00_r8/)
      kao_mco( 5, :, 2) = (/ &
     & 1.92622e+00_r8, 1.87172e+00_r8, 1.81876e+00_r8, 1.76730e+00_r8, 1.71730e+00_r8, &
     & 1.66871e+00_r8, 1.62150e+00_r8, 1.57562e+00_r8, 1.53104e+00_r8, 1.48772e+00_r8, &
     & 1.44563e+00_r8, 1.40473e+00_r8, 1.36498e+00_r8, 1.32636e+00_r8, 1.28883e+00_r8, &
     & 1.25237e+00_r8, 1.21693e+00_r8, 1.18250e+00_r8, 1.14905e+00_r8/)
      kao_mco( 6, :, 2) = (/ &
     & 2.23194e+00_r8, 2.16782e+00_r8, 2.10554e+00_r8, 2.04505e+00_r8, 1.98630e+00_r8, &
     & 1.92924e+00_r8, 1.87381e+00_r8, 1.81998e+00_r8, 1.76770e+00_r8, 1.71691e+00_r8, &
     & 1.66759e+00_r8, 1.61968e+00_r8, 1.57315e+00_r8, 1.52796e+00_r8, 1.48406e+00_r8, &
     & 1.44143e+00_r8, 1.40002e+00_r8, 1.35980e+00_r8, 1.32073e+00_r8/)
      kao_mco( 7, :, 2) = (/ &
     & 2.64692e+00_r8, 2.57290e+00_r8, 2.50096e+00_r8, 2.43103e+00_r8, 2.36305e+00_r8, &
     & 2.29697e+00_r8, 2.23275e+00_r8, 2.17031e+00_r8, 2.10963e+00_r8, 2.05064e+00_r8, &
     & 1.99330e+00_r8, 1.93756e+00_r8, 1.88338e+00_r8, 1.83072e+00_r8, 1.77953e+00_r8, &
     & 1.72977e+00_r8, 1.68140e+00_r8, 1.63438e+00_r8, 1.58868e+00_r8/)
      kao_mco( 8, :, 2) = (/ &
     & 2.86812e+00_r8, 2.80121e+00_r8, 2.73586e+00_r8, 2.67204e+00_r8, 2.60970e+00_r8, &
     & 2.54882e+00_r8, 2.48936e+00_r8, 2.43129e+00_r8, 2.37457e+00_r8, 2.31917e+00_r8, &
     & 2.26507e+00_r8, 2.21223e+00_r8, 2.16062e+00_r8, 2.11022e+00_r8, 2.06099e+00_r8, &
     & 2.01291e+00_r8, 1.96595e+00_r8, 1.92009e+00_r8, 1.87529e+00_r8/)
      kao_mco( 9, :, 2) = (/ &
     & 1.25243e+00_r8, 1.22790e+00_r8, 1.20385e+00_r8, 1.18027e+00_r8, 1.15716e+00_r8, &
     & 1.13449e+00_r8, 1.11227e+00_r8, 1.09049e+00_r8, 1.06913e+00_r8, 1.04819e+00_r8, &
     & 1.02766e+00_r8, 1.00754e+00_r8, 9.87804e-01_r8, 9.68457e-01_r8, 9.49490e-01_r8, &
     & 9.30894e-01_r8, 9.12662e-01_r8, 8.94787e-01_r8, 8.77263e-01_r8/)
      kao_mco( 1, :, 3) = (/ &
     & 2.55598e+00_r8, 2.48729e+00_r8, 2.42045e+00_r8, 2.35541e+00_r8, 2.29211e+00_r8, &
     & 2.23052e+00_r8, 2.17058e+00_r8, 2.11225e+00_r8, 2.05549e+00_r8, 2.00025e+00_r8, &
     & 1.94650e+00_r8, 1.89419e+00_r8, 1.84329e+00_r8, 1.79376e+00_r8, 1.74555e+00_r8, &
     & 1.69865e+00_r8, 1.65300e+00_r8, 1.60858e+00_r8, 1.56535e+00_r8/)
      kao_mco( 2, :, 3) = (/ &
     & 2.93113e+00_r8, 2.85257e+00_r8, 2.77612e+00_r8, 2.70172e+00_r8, 2.62932e+00_r8, &
     & 2.55885e+00_r8, 2.49028e+00_r8, 2.42354e+00_r8, 2.35859e+00_r8, 2.29538e+00_r8, &
     & 2.23386e+00_r8, 2.17400e+00_r8, 2.11573e+00_r8, 2.05903e+00_r8, 2.00385e+00_r8, &
     & 1.95015e+00_r8, 1.89788e+00_r8, 1.84702e+00_r8, 1.79752e+00_r8/)
      kao_mco( 3, :, 3) = (/ &
     & 3.26626e+00_r8, 3.18025e+00_r8, 3.09651e+00_r8, 3.01497e+00_r8, 2.93558e+00_r8, &
     & 2.85828e+00_r8, 2.78302e+00_r8, 2.70973e+00_r8, 2.63838e+00_r8, 2.56891e+00_r8, &
     & 2.50126e+00_r8, 2.43540e+00_r8, 2.37127e+00_r8, 2.30883e+00_r8, 2.24803e+00_r8, &
     & 2.18883e+00_r8, 2.13120e+00_r8, 2.07508e+00_r8, 2.02044e+00_r8/)
      kao_mco( 4, :, 3) = (/ &
     & 3.65895e+00_r8, 3.56418e+00_r8, 3.47187e+00_r8, 3.38194e+00_r8, 3.29435e+00_r8, &
     & 3.20903e+00_r8, 3.12591e+00_r8, 3.04495e+00_r8, 2.96608e+00_r8, 2.88926e+00_r8, &
     & 2.81443e+00_r8, 2.74153e+00_r8, 2.67053e+00_r8, 2.60136e+00_r8, 2.53398e+00_r8, &
     & 2.46835e+00_r8, 2.40442e+00_r8, 2.34214e+00_r8, 2.28148e+00_r8/)
      kao_mco( 5, :, 3) = (/ &
     & 4.13692e+00_r8, 4.03459e+00_r8, 3.93479e+00_r8, 3.83746e+00_r8, 3.74254e+00_r8, &
     & 3.64997e+00_r8, 3.55968e+00_r8, 3.47163e+00_r8, 3.38576e+00_r8, 3.30201e+00_r8, &
     & 3.22034e+00_r8, 3.14068e+00_r8, 3.06299e+00_r8, 2.98723e+00_r8, 2.91334e+00_r8, &
     & 2.84128e+00_r8, 2.77100e+00_r8, 2.70246e+00_r8, 2.63561e+00_r8/)
      kao_mco( 6, :, 3) = (/ &
     & 4.42856e+00_r8, 4.32480e+00_r8, 4.22348e+00_r8, 4.12453e+00_r8, 4.02790e+00_r8, &
     & 3.93353e+00_r8, 3.84137e+00_r8, 3.75137e+00_r8, 3.66348e+00_r8, 3.57765e+00_r8, &
     & 3.49383e+00_r8, 3.41198e+00_r8, 3.33204e+00_r8, 3.25397e+00_r8, 3.17774e+00_r8, &
     & 3.10329e+00_r8, 3.03058e+00_r8, 2.95958e+00_r8, 2.89024e+00_r8/)
      kao_mco( 7, :, 3) = (/ &
     & 4.31306e+00_r8, 4.21750e+00_r8, 4.12406e+00_r8, 4.03268e+00_r8, 3.94333e+00_r8, &
     & 3.85596e+00_r8, 3.77053e+00_r8, 3.68699e+00_r8, 3.60530e+00_r8, 3.52542e+00_r8, &
     & 3.44731e+00_r8, 3.37093e+00_r8, 3.29624e+00_r8, 3.22321e+00_r8, 3.15179e+00_r8, &
     & 3.08196e+00_r8, 3.01368e+00_r8, 2.94691e+00_r8, 2.88161e+00_r8/)
      kao_mco( 8, :, 3) = (/ &
     & 4.38922e+00_r8, 4.32180e+00_r8, 4.25543e+00_r8, 4.19007e+00_r8, 4.12571e+00_r8, &
     & 4.06234e+00_r8, 3.99995e+00_r8, 3.93851e+00_r8, 3.87802e+00_r8, 3.81846e+00_r8, &
     & 3.75981e+00_r8, 3.70206e+00_r8, 3.64520e+00_r8, 3.58922e+00_r8, 3.53409e+00_r8, &
     & 3.47981e+00_r8, 3.42636e+00_r8, 3.37374e+00_r8, 3.32192e+00_r8/)
      kao_mco( 9, :, 3) = (/ &
     & 1.56810e+00_r8, 1.54211e+00_r8, 1.51654e+00_r8, 1.49139e+00_r8, 1.46667e+00_r8, &
     & 1.44235e+00_r8, 1.41844e+00_r8, 1.39492e+00_r8, 1.37179e+00_r8, 1.34905e+00_r8, &
     & 1.32668e+00_r8, 1.30469e+00_r8, 1.28306e+00_r8, 1.26178e+00_r8, 1.24086e+00_r8, &
     & 1.22029e+00_r8, 1.20006e+00_r8, 1.18016e+00_r8, 1.16059e+00_r8/)
      kao_mco( 1, :, 4) = (/ &
     & 6.58275e+00_r8, 6.43026e+00_r8, 6.28130e+00_r8, 6.13579e+00_r8, 5.99365e+00_r8, &
     & 5.85481e+00_r8, 5.71918e+00_r8, 5.58669e+00_r8, 5.45727e+00_r8, 5.33085e+00_r8, &
     & 5.20736e+00_r8, 5.08673e+00_r8, 4.96889e+00_r8, 4.85379e+00_r8, 4.74135e+00_r8, &
     & 4.63151e+00_r8, 4.52422e+00_r8, 4.41942e+00_r8, 4.31704e+00_r8/)
      kao_mco( 2, :, 4) = (/ &
     & 6.59883e+00_r8, 6.45139e+00_r8, 6.30725e+00_r8, 6.16633e+00_r8, 6.02855e+00_r8, &
     & 5.89386e+00_r8, 5.76217e+00_r8, 5.63342e+00_r8, 5.50756e+00_r8, 5.38450e+00_r8, &
     & 5.26419e+00_r8, 5.14657e+00_r8, 5.03158e+00_r8, 4.91916e+00_r8, 4.80925e+00_r8, &
     & 4.70180e+00_r8, 4.59675e+00_r8, 4.49404e+00_r8, 4.39363e+00_r8/)
      kao_mco( 3, :, 4) = (/ &
     & 6.58521e+00_r8, 6.44452e+00_r8, 6.30683e+00_r8, 6.17209e+00_r8, 6.04023e+00_r8, &
     & 5.91118e+00_r8, 5.78489e+00_r8, 5.66130e+00_r8, 5.54034e+00_r8, 5.42198e+00_r8, &
     & 5.30614e+00_r8, 5.19277e+00_r8, 5.08183e+00_r8, 4.97326e+00_r8, 4.86701e+00_r8, &
     & 4.76303e+00_r8, 4.66127e+00_r8, 4.56168e+00_r8, 4.46422e+00_r8/)
      kao_mco( 4, :, 4) = (/ &
     & 6.33742e+00_r8, 6.20870e+00_r8, 6.08260e+00_r8, 5.95905e+00_r8, 5.83802e+00_r8, &
     & 5.71945e+00_r8, 5.60328e+00_r8, 5.48947e+00_r8, 5.37798e+00_r8, 5.26875e+00_r8, &
     & 5.16174e+00_r8, 5.05690e+00_r8, 4.95419e+00_r8, 4.85357e+00_r8, 4.75499e+00_r8, &
     & 4.65841e+00_r8, 4.56379e+00_r8, 4.47110e+00_r8, 4.38029e+00_r8/)
      kao_mco( 5, :, 4) = (/ &
     & 5.99732e+00_r8, 5.88459e+00_r8, 5.77398e+00_r8, 5.66545e+00_r8, 5.55896e+00_r8, &
     & 5.45447e+00_r8, 5.35194e+00_r8, 5.25134e+00_r8, 5.15263e+00_r8, 5.05578e+00_r8, &
     & 4.96075e+00_r8, 4.86750e+00_r8, 4.77601e+00_r8, 4.68623e+00_r8, 4.59815e+00_r8, &
     & 4.51171e+00_r8, 4.42691e+00_r8, 4.34370e+00_r8, 4.26205e+00_r8/)
      kao_mco( 6, :, 4) = (/ &
     & 5.74529e+00_r8, 5.65249e+00_r8, 5.56119e+00_r8, 5.47136e+00_r8, 5.38299e+00_r8, &
     & 5.29604e+00_r8, 5.21049e+00_r8, 5.12633e+00_r8, 5.04353e+00_r8, 4.96206e+00_r8, &
     & 4.88191e+00_r8, 4.80306e+00_r8, 4.72547e+00_r8, 4.64915e+00_r8, 4.57405e+00_r8, &
     & 4.50017e+00_r8, 4.42748e+00_r8, 4.35596e+00_r8, 4.28560e+00_r8/)
      kao_mco( 7, :, 4) = (/ &
     & 5.87251e+00_r8, 5.79956e+00_r8, 5.72753e+00_r8, 5.65638e+00_r8, 5.58613e+00_r8, &
     & 5.51674e+00_r8, 5.44822e+00_r8, 5.38054e+00_r8, 5.31371e+00_r8, 5.24771e+00_r8, &
     & 5.18253e+00_r8, 5.11815e+00_r8, 5.05458e+00_r8, 4.99180e+00_r8, 4.92979e+00_r8, &
     & 4.86856e+00_r8, 4.80809e+00_r8, 4.74837e+00_r8, 4.68939e+00_r8/)
      kao_mco( 8, :, 4) = (/ &
     & 5.68503e+00_r8, 5.62827e+00_r8, 5.57207e+00_r8, 5.51644e+00_r8, 5.46136e+00_r8, &
     & 5.40684e+00_r8, 5.35285e+00_r8, 5.29941e+00_r8, 5.24650e+00_r8, 5.19412e+00_r8, &
     & 5.14226e+00_r8, 5.09092e+00_r8, 5.04009e+00_r8, 4.98977e+00_r8, 4.93995e+00_r8, &
     & 4.89063e+00_r8, 4.84180e+00_r8, 4.79346e+00_r8, 4.74560e+00_r8/)
      kao_mco( 9, :, 4) = (/ &
     & 2.69278e+00_r8, 2.65058e+00_r8, 2.60903e+00_r8, 2.56814e+00_r8, 2.52789e+00_r8, &
     & 2.48827e+00_r8, 2.44927e+00_r8, 2.41088e+00_r8, 2.37310e+00_r8, 2.33590e+00_r8, &
     & 2.29929e+00_r8, 2.26325e+00_r8, 2.22778e+00_r8, 2.19286e+00_r8, 2.15849e+00_r8, &
     & 2.12466e+00_r8, 2.09136e+00_r8, 2.05859e+00_r8, 2.02632e+00_r8/)
      kao_mco( 1, :, 5) = (/ &
     & 9.12231e+00_r8, 9.00052e+00_r8, 8.88036e+00_r8, 8.76180e+00_r8, 8.64482e+00_r8, &
     & 8.52941e+00_r8, 8.41553e+00_r8, 8.30318e+00_r8, 8.19233e+00_r8, 8.08295e+00_r8, &
     & 7.97504e+00_r8, 7.86857e+00_r8, 7.76352e+00_r8, 7.65987e+00_r8, 7.55760e+00_r8, &
     & 7.45671e+00_r8, 7.35715e+00_r8, 7.25893e+00_r8, 7.16202e+00_r8/)
      kao_mco( 2, :, 5) = (/ &
     & 8.37315e+00_r8, 8.27808e+00_r8, 8.18410e+00_r8, 8.09118e+00_r8, 7.99931e+00_r8, &
     & 7.90849e+00_r8, 7.81871e+00_r8, 7.72994e+00_r8, 7.64217e+00_r8, 7.55541e+00_r8, &
     & 7.46963e+00_r8, 7.38482e+00_r8, 7.30098e+00_r8, 7.21809e+00_r8, 7.13614e+00_r8, &
     & 7.05512e+00_r8, 6.97502e+00_r8, 6.89582e+00_r8, 6.81753e+00_r8/)
      kao_mco( 3, :, 5) = (/ &
     & 8.14557e+00_r8, 8.06533e+00_r8, 7.98587e+00_r8, 7.90720e+00_r8, 7.82930e+00_r8, &
     & 7.75217e+00_r8, 7.67580e+00_r8, 7.60018e+00_r8, 7.52530e+00_r8, 7.45117e+00_r8, &
     & 7.37776e+00_r8, 7.30508e+00_r8, 7.23311e+00_r8, 7.16186e+00_r8, 7.09130e+00_r8, &
     & 7.02144e+00_r8, 6.95227e+00_r8, 6.88378e+00_r8, 6.81596e+00_r8/)
      kao_mco( 4, :, 5) = (/ &
     & 8.18046e+00_r8, 8.11056e+00_r8, 8.04126e+00_r8, 7.97256e+00_r8, 7.90444e+00_r8, &
     & 7.83690e+00_r8, 7.76994e+00_r8, 7.70355e+00_r8, 7.63773e+00_r8, 7.57247e+00_r8, &
     & 7.50777e+00_r8, 7.44362e+00_r8, 7.38002e+00_r8, 7.31697e+00_r8, 7.25445e+00_r8, &
     & 7.19247e+00_r8, 7.13101e+00_r8, 7.07008e+00_r8, 7.00968e+00_r8/)
      kao_mco( 5, :, 5) = (/ &
     & 8.30092e+00_r8, 8.23529e+00_r8, 8.17019e+00_r8, 8.10559e+00_r8, 8.04151e+00_r8, &
     & 7.97794e+00_r8, 7.91487e+00_r8, 7.85230e+00_r8, 7.79022e+00_r8, 7.72863e+00_r8, &
     & 7.66753e+00_r8, 7.60691e+00_r8, 7.54678e+00_r8, 7.48711e+00_r8, 7.42792e+00_r8, &
     & 7.36920e+00_r8, 7.31094e+00_r8, 7.25314e+00_r8, 7.19580e+00_r8/)
      kao_mco( 6, :, 5) = (/ &
     & 8.30014e+00_r8, 8.24466e+00_r8, 8.18955e+00_r8, 8.13481e+00_r8, 8.08044e+00_r8, &
     & 8.02642e+00_r8, 7.97277e+00_r8, 7.91948e+00_r8, 7.86655e+00_r8, 7.81396e+00_r8, &
     & 7.76173e+00_r8, 7.70985e+00_r8, 7.65832e+00_r8, 7.60713e+00_r8, 7.55628e+00_r8, &
     & 7.50577e+00_r8, 7.45560e+00_r8, 7.40577e+00_r8, 7.35627e+00_r8/)
      kao_mco( 7, :, 5) = (/ &
     & 7.95931e+00_r8, 7.93958e+00_r8, 7.91989e+00_r8, 7.90025e+00_r8, 7.88066e+00_r8, &
     & 7.86112e+00_r8, 7.84163e+00_r8, 7.82219e+00_r8, 7.80279e+00_r8, 7.78344e+00_r8, &
     & 7.76414e+00_r8, 7.74489e+00_r8, 7.72568e+00_r8, 7.70653e+00_r8, 7.68742e+00_r8, &
     & 7.66836e+00_r8, 7.64934e+00_r8, 7.63038e+00_r8, 7.61146e+00_r8/)
      kao_mco( 8, :, 5) = (/ &
     & 9.32576e+00_r8, 9.31747e+00_r8, 9.30919e+00_r8, 9.30092e+00_r8, 9.29265e+00_r8, &
     & 9.28439e+00_r8, 9.27613e+00_r8, 9.26789e+00_r8, 9.25965e+00_r8, 9.25142e+00_r8, &
     & 9.24320e+00_r8, 9.23498e+00_r8, 9.22677e+00_r8, 9.21857e+00_r8, 9.21038e+00_r8, &
     & 9.20219e+00_r8, 9.19401e+00_r8, 9.18584e+00_r8, 9.17767e+00_r8/)
      kao_mco( 9, :, 5) = (/ &
     & 4.13116e+00_r8, 4.08426e+00_r8, 4.03788e+00_r8, 3.99204e+00_r8, 3.94671e+00_r8, &
     & 3.90190e+00_r8, 3.85760e+00_r8, 3.81380e+00_r8, 3.77049e+00_r8, 3.72768e+00_r8, &
     & 3.68536e+00_r8, 3.64351e+00_r8, 3.60214e+00_r8, 3.56124e+00_r8, 3.52081e+00_r8, &
     & 3.48083e+00_r8, 3.44131e+00_r8, 3.40224e+00_r8, 3.36361e+00_r8/)
      kao_mco( 1, :, 6) = (/ &
     & 1.21200e+01_r8, 1.21580e+01_r8, 1.21961e+01_r8, 1.22344e+01_r8, 1.22728e+01_r8, &
     & 1.23113e+01_r8, 1.23499e+01_r8, 1.23886e+01_r8, 1.24275e+01_r8, 1.24664e+01_r8, &
     & 1.25056e+01_r8, 1.25448e+01_r8, 1.25841e+01_r8, 1.26236e+01_r8, 1.26632e+01_r8, &
     & 1.27029e+01_r8, 1.27428e+01_r8, 1.27827e+01_r8, 1.28228e+01_r8/)
      kao_mco( 2, :, 6) = (/ &
     & 1.25231e+01_r8, 1.25625e+01_r8, 1.26020e+01_r8, 1.26417e+01_r8, 1.26815e+01_r8, &
     & 1.27214e+01_r8, 1.27614e+01_r8, 1.28015e+01_r8, 1.28418e+01_r8, 1.28822e+01_r8, &
     & 1.29228e+01_r8, 1.29634e+01_r8, 1.30042e+01_r8, 1.30451e+01_r8, 1.30862e+01_r8, &
     & 1.31274e+01_r8, 1.31687e+01_r8, 1.32101e+01_r8, 1.32517e+01_r8/)
      kao_mco( 3, :, 6) = (/ &
     & 1.27566e+01_r8, 1.27983e+01_r8, 1.28401e+01_r8, 1.28820e+01_r8, 1.29241e+01_r8, &
     & 1.29663e+01_r8, 1.30087e+01_r8, 1.30512e+01_r8, 1.30938e+01_r8, 1.31366e+01_r8, &
     & 1.31795e+01_r8, 1.32225e+01_r8, 1.32657e+01_r8, 1.33090e+01_r8, 1.33525e+01_r8, &
     & 1.33961e+01_r8, 1.34399e+01_r8, 1.34838e+01_r8, 1.35278e+01_r8/)
      kao_mco( 4, :, 6) = (/ &
     & 1.27132e+01_r8, 1.27454e+01_r8, 1.27777e+01_r8, 1.28101e+01_r8, 1.28425e+01_r8, &
     & 1.28750e+01_r8, 1.29077e+01_r8, 1.29403e+01_r8, 1.29731e+01_r8, 1.30060e+01_r8, &
     & 1.30389e+01_r8, 1.30720e+01_r8, 1.31051e+01_r8, 1.31383e+01_r8, 1.31716e+01_r8, &
     & 1.32049e+01_r8, 1.32384e+01_r8, 1.32719e+01_r8, 1.33055e+01_r8/)
      kao_mco( 5, :, 6) = (/ &
     & 1.33151e+01_r8, 1.33523e+01_r8, 1.33896e+01_r8, 1.34271e+01_r8, 1.34646e+01_r8, &
     & 1.35022e+01_r8, 1.35400e+01_r8, 1.35779e+01_r8, 1.36158e+01_r8, 1.36539e+01_r8, &
     & 1.36921e+01_r8, 1.37303e+01_r8, 1.37687e+01_r8, 1.38072e+01_r8, 1.38458e+01_r8, &
     & 1.38846e+01_r8, 1.39234e+01_r8, 1.39623e+01_r8, 1.40013e+01_r8/)
      kao_mco( 6, :, 6) = (/ &
     & 1.41448e+01_r8, 1.41902e+01_r8, 1.42357e+01_r8, 1.42814e+01_r8, 1.43272e+01_r8, &
     & 1.43732e+01_r8, 1.44194e+01_r8, 1.44656e+01_r8, 1.45121e+01_r8, 1.45586e+01_r8, &
     & 1.46054e+01_r8, 1.46522e+01_r8, 1.46993e+01_r8, 1.47464e+01_r8, 1.47938e+01_r8, &
     & 1.48413e+01_r8, 1.48889e+01_r8, 1.49367e+01_r8, 1.49846e+01_r8/)
      kao_mco( 7, :, 6) = (/ &
     & 1.56578e+01_r8, 1.56938e+01_r8, 1.57299e+01_r8, 1.57661e+01_r8, 1.58024e+01_r8, &
     & 1.58388e+01_r8, 1.58752e+01_r8, 1.59117e+01_r8, 1.59484e+01_r8, 1.59851e+01_r8, &
     & 1.60218e+01_r8, 1.60587e+01_r8, 1.60957e+01_r8, 1.61327e+01_r8, 1.61698e+01_r8, &
     & 1.62070e+01_r8, 1.62443e+01_r8, 1.62817e+01_r8, 1.63192e+01_r8/)
      kao_mco( 8, :, 6) = (/ &
     & 1.73627e+01_r8, 1.74761e+01_r8, 1.75903e+01_r8, 1.77052e+01_r8, 1.78208e+01_r8, &
     & 1.79373e+01_r8, 1.80544e+01_r8, 1.81724e+01_r8, 1.82911e+01_r8, 1.84106e+01_r8, &
     & 1.85309e+01_r8, 1.86519e+01_r8, 1.87738e+01_r8, 1.88964e+01_r8, 1.90198e+01_r8, &
     & 1.91441e+01_r8, 1.92692e+01_r8, 1.93950e+01_r8, 1.95217e+01_r8/)
      kao_mco( 9, :, 6) = (/ &
     & 7.16326e+00_r8, 7.12921e+00_r8, 7.09531e+00_r8, 7.06158e+00_r8, 7.02800e+00_r8, &
     & 6.99459e+00_r8, 6.96133e+00_r8, 6.92824e+00_r8, 6.89530e+00_r8, 6.86252e+00_r8, &
     & 6.82989e+00_r8, 6.79742e+00_r8, 6.76510e+00_r8, 6.73293e+00_r8, 6.70092e+00_r8, &
     & 6.66906e+00_r8, 6.63736e+00_r8, 6.60580e+00_r8, 6.57439e+00_r8/)
      kao_mco( 1, :, 7) = (/ &
     & 2.09288e+01_r8, 2.10487e+01_r8, 2.11692e+01_r8, 2.12904e+01_r8, 2.14124e+01_r8, &
     & 2.15350e+01_r8, 2.16583e+01_r8, 2.17823e+01_r8, 2.19070e+01_r8, 2.20325e+01_r8, &
     & 2.21587e+01_r8, 2.22855e+01_r8, 2.24132e+01_r8, 2.25415e+01_r8, 2.26706e+01_r8, &
     & 2.28004e+01_r8, 2.29310e+01_r8, 2.30623e+01_r8, 2.31943e+01_r8/)
      kao_mco( 2, :, 7) = (/ &
     & 2.08159e+01_r8, 2.09509e+01_r8, 2.10867e+01_r8, 2.12234e+01_r8, 2.13610e+01_r8, &
     & 2.14994e+01_r8, 2.16388e+01_r8, 2.17791e+01_r8, 2.19202e+01_r8, 2.20623e+01_r8, &
     & 2.22053e+01_r8, 2.23493e+01_r8, 2.24942e+01_r8, 2.26400e+01_r8, 2.27867e+01_r8, &
     & 2.29345e+01_r8, 2.30831e+01_r8, 2.32328e+01_r8, 2.33834e+01_r8/)
      kao_mco( 3, :, 7) = (/ &
     & 2.10827e+01_r8, 2.12409e+01_r8, 2.14002e+01_r8, 2.15608e+01_r8, 2.17225e+01_r8, &
     & 2.18855e+01_r8, 2.20497e+01_r8, 2.22151e+01_r8, 2.23818e+01_r8, 2.25497e+01_r8, &
     & 2.27189e+01_r8, 2.28893e+01_r8, 2.30611e+01_r8, 2.32341e+01_r8, 2.34084e+01_r8, &
     & 2.35840e+01_r8, 2.37609e+01_r8, 2.39392e+01_r8, 2.41188e+01_r8/)
      kao_mco( 4, :, 7) = (/ &
     & 2.13866e+01_r8, 2.15772e+01_r8, 2.17694e+01_r8, 2.19634e+01_r8, 2.21590e+01_r8, &
     & 2.23565e+01_r8, 2.25556e+01_r8, 2.27566e+01_r8, 2.29594e+01_r8, 2.31639e+01_r8, &
     & 2.33703e+01_r8, 2.35785e+01_r8, 2.37886e+01_r8, 2.40005e+01_r8, 2.42144e+01_r8, &
     & 2.44301e+01_r8, 2.46477e+01_r8, 2.48673e+01_r8, 2.50889e+01_r8/)
      kao_mco( 5, :, 7) = (/ &
     & 1.93714e+01_r8, 1.95595e+01_r8, 1.97493e+01_r8, 1.99410e+01_r8, 2.01345e+01_r8, &
     & 2.03300e+01_r8, 2.05273e+01_r8, 2.07265e+01_r8, 2.09277e+01_r8, 2.11308e+01_r8, &
     & 2.13359e+01_r8, 2.15430e+01_r8, 2.17521e+01_r8, 2.19632e+01_r8, 2.21764e+01_r8, &
     & 2.23917e+01_r8, 2.26090e+01_r8, 2.28284e+01_r8, 2.30500e+01_r8/)
      kao_mco( 6, :, 7) = (/ &
     & 1.70418e+01_r8, 1.72109e+01_r8, 1.73817e+01_r8, 1.75541e+01_r8, 1.77283e+01_r8, &
     & 1.79041e+01_r8, 1.80818e+01_r8, 1.82612e+01_r8, 1.84423e+01_r8, 1.86253e+01_r8, &
     & 1.88101e+01_r8, 1.89967e+01_r8, 1.91852e+01_r8, 1.93755e+01_r8, 1.95678e+01_r8, &
     & 1.97619e+01_r8, 1.99580e+01_r8, 2.01560e+01_r8, 2.03560e+01_r8/)
      kao_mco( 7, :, 7) = (/ &
     & 1.31735e+01_r8, 1.32921e+01_r8, 1.34118e+01_r8, 1.35326e+01_r8, 1.36545e+01_r8, &
     & 1.37775e+01_r8, 1.39015e+01_r8, 1.40267e+01_r8, 1.41531e+01_r8, 1.42805e+01_r8, &
     & 1.44091e+01_r8, 1.45389e+01_r8, 1.46698e+01_r8, 1.48019e+01_r8, 1.49353e+01_r8, &
     & 1.50698e+01_r8, 1.52055e+01_r8, 1.53424e+01_r8, 1.54806e+01_r8/)
      kao_mco( 8, :, 7) = (/ &
     & 4.97361e+00_r8, 4.96550e+00_r8, 4.95740e+00_r8, 4.94931e+00_r8, 4.94124e+00_r8, &
     & 4.93318e+00_r8, 4.92513e+00_r8, 4.91709e+00_r8, 4.90907e+00_r8, 4.90106e+00_r8, &
     & 4.89307e+00_r8, 4.88509e+00_r8, 4.87712e+00_r8, 4.86916e+00_r8, 4.86122e+00_r8, &
     & 4.85329e+00_r8, 4.84537e+00_r8, 4.83747e+00_r8, 4.82958e+00_r8/)
      kao_mco( 9, :, 7) = (/ &
     & 1.76121e+01_r8, 1.75887e+01_r8, 1.75653e+01_r8, 1.75420e+01_r8, 1.75187e+01_r8, &
     & 1.74955e+01_r8, 1.74722e+01_r8, 1.74490e+01_r8, 1.74259e+01_r8, 1.74027e+01_r8, &
     & 1.73796e+01_r8, 1.73566e+01_r8, 1.73335e+01_r8, 1.73105e+01_r8, 1.72875e+01_r8, &
     & 1.72646e+01_r8, 1.72416e+01_r8, 1.72188e+01_r8, 1.71959e+01_r8/)
      kao_mco( 1, :, 8) = (/ &
     & 5.99126e+00_r8, 6.08386e+00_r8, 6.17790e+00_r8, 6.27339e+00_r8, 6.37035e+00_r8, &
     & 6.46881e+00_r8, 6.56880e+00_r8, 6.67033e+00_r8, 6.77343e+00_r8, 6.87812e+00_r8, &
     & 6.98443e+00_r8, 7.09238e+00_r8, 7.20201e+00_r8, 7.31332e+00_r8, 7.42636e+00_r8, &
     & 7.54115e+00_r8, 7.65771e+00_r8, 7.77607e+00_r8, 7.89626e+00_r8/)
      kao_mco( 2, :, 8) = (/ &
     & 4.71621e+00_r8, 4.78830e+00_r8, 4.86149e+00_r8, 4.93580e+00_r8, 5.01124e+00_r8, &
     & 5.08784e+00_r8, 5.16561e+00_r8, 5.24456e+00_r8, 5.32473e+00_r8, 5.40612e+00_r8, &
     & 5.48875e+00_r8, 5.57264e+00_r8, 5.65782e+00_r8, 5.74430e+00_r8, 5.83211e+00_r8, &
     & 5.92125e+00_r8, 6.01176e+00_r8, 6.10365e+00_r8, 6.19694e+00_r8/)
      kao_mco( 3, :, 8) = (/ &
     & 2.77067e+00_r8, 2.81437e+00_r8, 2.85876e+00_r8, 2.90385e+00_r8, 2.94965e+00_r8, &
     & 2.99617e+00_r8, 3.04343e+00_r8, 3.09143e+00_r8, 3.14019e+00_r8, 3.18972e+00_r8, &
     & 3.24003e+00_r8, 3.29114e+00_r8, 3.34305e+00_r8, 3.39578e+00_r8, 3.44934e+00_r8, &
     & 3.50374e+00_r8, 3.55901e+00_r8, 3.61514e+00_r8, 3.67216e+00_r8/)
      kao_mco( 4, :, 8) = (/ &
     & 1.22388e+00_r8, 1.24248e+00_r8, 1.26136e+00_r8, 1.28053e+00_r8, 1.29999e+00_r8, &
     & 1.31974e+00_r8, 1.33979e+00_r8, 1.36015e+00_r8, 1.38082e+00_r8, 1.40181e+00_r8, &
     & 1.42311e+00_r8, 1.44473e+00_r8, 1.46669e+00_r8, 1.48897e+00_r8, 1.51160e+00_r8, &
     & 1.53457e+00_r8, 1.55789e+00_r8, 1.58156e+00_r8, 1.60559e+00_r8/)
      kao_mco( 5, :, 8) = (/ &
     & 1.41479e+00_r8, 1.43540e+00_r8, 1.45631e+00_r8, 1.47752e+00_r8, 1.49904e+00_r8, &
     & 1.52088e+00_r8, 1.54303e+00_r8, 1.56550e+00_r8, 1.58831e+00_r8, 1.61144e+00_r8, &
     & 1.63491e+00_r8, 1.65872e+00_r8, 1.68288e+00_r8, 1.70740e+00_r8, 1.73227e+00_r8, &
     & 1.75750e+00_r8, 1.78310e+00_r8, 1.80907e+00_r8, 1.83542e+00_r8/)
      kao_mco( 6, :, 8) = (/ &
     & 1.43154e+00_r8, 1.46074e+00_r8, 1.49053e+00_r8, 1.52093e+00_r8, 1.55196e+00_r8, &
     & 1.58361e+00_r8, 1.61591e+00_r8, 1.64887e+00_r8, 1.68250e+00_r8, 1.71682e+00_r8, &
     & 1.75184e+00_r8, 1.78757e+00_r8, 1.82403e+00_r8, 1.86123e+00_r8, 1.89920e+00_r8, &
     & 1.93793e+00_r8, 1.97746e+00_r8, 2.01779e+00_r8, 2.05895e+00_r8/)
      kao_mco( 7, :, 8) = (/ &
     & 2.49358e+00_r8, 2.56028e+00_r8, 2.62875e+00_r8, 2.69906e+00_r8, 2.77124e+00_r8, &
     & 2.84536e+00_r8, 2.92146e+00_r8, 2.99960e+00_r8, 3.07982e+00_r8, 3.16219e+00_r8, &
     & 3.24677e+00_r8, 3.33360e+00_r8, 3.42276e+00_r8, 3.51430e+00_r8, 3.60829e+00_r8, &
     & 3.70480e+00_r8, 3.80388e+00_r8, 3.90562e+00_r8, 4.01007e+00_r8/)
      kao_mco( 8, :, 8) = (/ &
     & 4.32513e+00_r8, 4.39903e+00_r8, 4.47420e+00_r8, 4.55065e+00_r8, 4.62841e+00_r8, &
     & 4.70750e+00_r8, 4.78794e+00_r8, 4.86975e+00_r8, 4.95296e+00_r8, 5.03759e+00_r8, &
     & 5.12367e+00_r8, 5.21122e+00_r8, 5.30027e+00_r8, 5.39084e+00_r8, 5.48295e+00_r8, &
     & 5.57664e+00_r8, 5.67193e+00_r8, 5.76885e+00_r8, 5.86743e+00_r8/)
      kao_mco( 9, :, 8) = (/ &
     & 3.35160e+01_r8, 3.36789e+01_r8, 3.38425e+01_r8, 3.40069e+01_r8, 3.41722e+01_r8, &
     & 3.43382e+01_r8, 3.45050e+01_r8, 3.46727e+01_r8, 3.48412e+01_r8, 3.50105e+01_r8, &
     & 3.51806e+01_r8, 3.53515e+01_r8, 3.55233e+01_r8, 3.56959e+01_r8, 3.58693e+01_r8, &
     & 3.60436e+01_r8, 3.62187e+01_r8, 3.63947e+01_r8, 3.65715e+01_r8/)
      kao_mco( 1, :, 9) = (/ &
     & 8.68159e-01_r8, 9.13680e-01_r8, 9.61587e-01_r8, 1.01201e+00_r8, 1.06507e+00_r8, &
     & 1.12091e+00_r8, 1.17969e+00_r8, 1.24154e+00_r8, 1.30664e+00_r8, 1.37515e+00_r8, &
     & 1.44726e+00_r8, 1.52314e+00_r8, 1.60300e+00_r8, 1.68705e+00_r8, 1.77551e+00_r8, &
     & 1.86861e+00_r8, 1.96658e+00_r8, 2.06970e+00_r8, 2.17822e+00_r8/)
      kao_mco( 2, :, 9) = (/ &
     & 9.04391e-01_r8, 9.49669e-01_r8, 9.97214e-01_r8, 1.04714e+00_r8, 1.09956e+00_r8, &
     & 1.15461e+00_r8, 1.21242e+00_r8, 1.27312e+00_r8, 1.33685e+00_r8, 1.40378e+00_r8, &
     & 1.47406e+00_r8, 1.54786e+00_r8, 1.62535e+00_r8, 1.70673e+00_r8, 1.79217e+00_r8, &
     & 1.88190e+00_r8, 1.97611e+00_r8, 2.07505e+00_r8, 2.17893e+00_r8/)
      kao_mco( 3, :, 9) = (/ &
     & 9.67479e-01_r8, 1.01312e+00_r8, 1.06092e+00_r8, 1.11098e+00_r8, 1.16339e+00_r8, &
     & 1.21828e+00_r8, 1.27576e+00_r8, 1.33595e+00_r8, 1.39898e+00_r8, 1.46499e+00_r8, &
     & 1.53411e+00_r8, 1.60649e+00_r8, 1.68228e+00_r8, 1.76165e+00_r8, 1.84476e+00_r8, &
     & 1.93180e+00_r8, 2.02294e+00_r8, 2.11839e+00_r8, 2.21833e+00_r8/)
      kao_mco( 4, :, 9) = (/ &
     & 1.05240e+00_r8, 1.09817e+00_r8, 1.14592e+00_r8, 1.19576e+00_r8, 1.24776e+00_r8, &
     & 1.30202e+00_r8, 1.35864e+00_r8, 1.41772e+00_r8, 1.47937e+00_r8, 1.54371e+00_r8, &
     & 1.61084e+00_r8, 1.68089e+00_r8, 1.75398e+00_r8, 1.83026e+00_r8, 1.90985e+00_r8, &
     & 1.99290e+00_r8, 2.07957e+00_r8, 2.17000e+00_r8, 2.26437e+00_r8/)
      kao_mco( 5, :, 9) = (/ &
     & 1.25800e+00_r8, 1.30557e+00_r8, 1.35494e+00_r8, 1.40618e+00_r8, 1.45935e+00_r8, &
     & 1.51454e+00_r8, 1.57181e+00_r8, 1.63125e+00_r8, 1.69293e+00_r8, 1.75695e+00_r8, &
     & 1.82339e+00_r8, 1.89234e+00_r8, 1.96389e+00_r8, 2.03816e+00_r8, 2.11523e+00_r8, &
     & 2.19522e+00_r8, 2.27823e+00_r8, 2.36438e+00_r8, 2.45378e+00_r8/)
      kao_mco( 6, :, 9) = (/ &
     & 1.76509e+00_r8, 1.80550e+00_r8, 1.84683e+00_r8, 1.88911e+00_r8, 1.93235e+00_r8, &
     & 1.97658e+00_r8, 2.02183e+00_r8, 2.06811e+00_r8, 2.11546e+00_r8, 2.16388e+00_r8, &
     & 2.21342e+00_r8, 2.26408e+00_r8, 2.31591e+00_r8, 2.36893e+00_r8, 2.42315e+00_r8, &
     & 2.47862e+00_r8, 2.53536e+00_r8, 2.59340e+00_r8, 2.65277e+00_r8/)
      kao_mco( 7, :, 9) = (/ &
     & 2.03543e+00_r8, 2.05285e+00_r8, 2.07042e+00_r8, 2.08815e+00_r8, 2.10602e+00_r8, &
     & 2.12405e+00_r8, 2.14223e+00_r8, 2.16057e+00_r8, 2.17907e+00_r8, 2.19772e+00_r8, &
     & 2.21654e+00_r8, 2.23551e+00_r8, 2.25465e+00_r8, 2.27395e+00_r8, 2.29342e+00_r8, &
     & 2.31305e+00_r8, 2.33285e+00_r8, 2.35282e+00_r8, 2.37296e+00_r8/)
      kao_mco( 8, :, 9) = (/ &
     & 3.18883e+00_r8, 3.20538e+00_r8, 3.22200e+00_r8, 3.23872e+00_r8, 3.25552e+00_r8, &
     & 3.27241e+00_r8, 3.28939e+00_r8, 3.30645e+00_r8, 3.32360e+00_r8, 3.34085e+00_r8, &
     & 3.35818e+00_r8, 3.37560e+00_r8, 3.39311e+00_r8, 3.41071e+00_r8, 3.42841e+00_r8, &
     & 3.44619e+00_r8, 3.46407e+00_r8, 3.48204e+00_r8, 3.50011e+00_r8/)
      kao_mco( 9, :, 9) = (/ &
     & 3.97585e+00_r8, 3.96333e+00_r8, 3.95084e+00_r8, 3.93839e+00_r8, 3.92598e+00_r8, &
     & 3.91361e+00_r8, 3.90128e+00_r8, 3.88899e+00_r8, 3.87674e+00_r8, 3.86452e+00_r8, &
     & 3.85235e+00_r8, 3.84021e+00_r8, 3.82811e+00_r8, 3.81605e+00_r8, 3.80402e+00_r8, &
     & 3.79204e+00_r8, 3.78009e+00_r8, 3.76818e+00_r8, 3.75631e+00_r8/)
      kao_mco( 1, :,10) = (/ &
     & 8.62646e-01_r8, 9.35164e-01_r8, 1.01378e+00_r8, 1.09900e+00_r8, 1.19139e+00_r8, &
     & 1.29154e+00_r8, 1.40011e+00_r8, 1.51781e+00_r8, 1.64541e+00_r8, 1.78373e+00_r8, &
     & 1.93367e+00_r8, 2.09623e+00_r8, 2.27245e+00_r8, 2.46348e+00_r8, 2.67057e+00_r8, &
     & 2.89507e+00_r8, 3.13844e+00_r8, 3.40227e+00_r8, 3.68828e+00_r8/)
      kao_mco( 2, :,10) = (/ &
     & 8.04693e-01_r8, 8.72167e-01_r8, 9.45298e-01_r8, 1.02456e+00_r8, 1.11047e+00_r8, &
     & 1.20358e+00_r8, 1.30450e+00_r8, 1.41389e+00_r8, 1.53244e+00_r8, 1.66094e+00_r8, &
     & 1.80021e+00_r8, 1.95115e+00_r8, 2.11476e+00_r8, 2.29208e+00_r8, 2.48427e+00_r8, &
     & 2.69258e+00_r8, 2.91835e+00_r8, 3.16305e+00_r8, 3.42827e+00_r8/)
      kao_mco( 3, :,10) = (/ &
     & 7.66566e-01_r8, 8.24651e-01_r8, 8.87137e-01_r8, 9.54358e-01_r8, 1.02667e+00_r8, &
     & 1.10447e+00_r8, 1.18815e+00_r8, 1.27818e+00_r8, 1.37503e+00_r8, 1.47922e+00_r8, &
     & 1.59131e+00_r8, 1.71189e+00_r8, 1.84160e+00_r8, 1.98114e+00_r8, 2.13126e+00_r8, &
     & 2.29275e+00_r8, 2.46648e+00_r8, 2.65337e+00_r8, 2.85442e+00_r8/)
      kao_mco( 4, :,10) = (/ &
     & 5.40305e-01_r8, 5.77106e-01_r8, 6.16414e-01_r8, 6.58400e-01_r8, 7.03245e-01_r8, &
     & 7.51145e-01_r8, 8.02307e-01_r8, 8.56954e-01_r8, 9.15323e-01_r8, 9.77668e-01_r8, &
     & 1.04426e+00_r8, 1.11539e+00_r8, 1.19136e+00_r8, 1.27250e+00_r8, 1.35918e+00_r8, &
     & 1.45175e+00_r8, 1.55064e+00_r8, 1.65625e+00_r8, 1.76906e+00_r8/)
      kao_mco( 5, :,10) = (/ &
     & 8.22474e-01_r8, 8.02911e-01_r8, 7.83814e-01_r8, 7.65171e-01_r8, 7.46971e-01_r8, &
     & 7.29204e-01_r8, 7.11860e-01_r8, 6.94928e-01_r8, 6.78399e-01_r8, 6.62263e-01_r8, &
     & 6.46511e-01_r8, 6.31133e-01_r8, 6.16122e-01_r8, 6.01467e-01_r8, 5.87161e-01_r8, &
     & 5.73195e-01_r8, 5.59562e-01_r8, 5.46252e-01_r8, 5.33260e-01_r8/)
      kao_mco( 6, :,10) = (/ &
     & 1.28162e+00_r8, 1.25110e+00_r8, 1.22131e+00_r8, 1.19223e+00_r8, 1.16384e+00_r8, &
     & 1.13613e+00_r8, 1.10908e+00_r8, 1.08267e+00_r8, 1.05689e+00_r8, 1.03173e+00_r8, &
     & 1.00716e+00_r8, 9.83184e-01_r8, 9.59774e-01_r8, 9.36921e-01_r8, 9.14613e-01_r8, &
     & 8.92836e-01_r8, 8.71577e-01_r8, 8.50825e-01_r8, 8.30567e-01_r8/)
      kao_mco( 7, :,10) = (/ &
     & 1.92679e+00_r8, 1.90551e+00_r8, 1.88446e+00_r8, 1.86365e+00_r8, 1.84307e+00_r8, &
     & 1.82271e+00_r8, 1.80258e+00_r8, 1.78267e+00_r8, 1.76298e+00_r8, 1.74351e+00_r8, &
     & 1.72425e+00_r8, 1.70520e+00_r8, 1.68637e+00_r8, 1.66774e+00_r8, 1.64932e+00_r8, &
     & 1.63111e+00_r8, 1.61309e+00_r8, 1.59527e+00_r8, 1.57765e+00_r8/)
      kao_mco( 8, :,10) = (/ &
     & 4.66485e+00_r8, 4.60869e+00_r8, 4.55320e+00_r8, 4.49838e+00_r8, 4.44423e+00_r8, &
     & 4.39072e+00_r8, 4.33786e+00_r8, 4.28563e+00_r8, 4.23404e+00_r8, 4.18306e+00_r8, &
     & 4.13270e+00_r8, 4.08295e+00_r8, 4.03379e+00_r8, 3.98523e+00_r8, 3.93725e+00_r8, &
     & 3.88985e+00_r8, 3.84301e+00_r8, 3.79675e+00_r8, 3.75104e+00_r8/)
      kao_mco( 9, :,10) = (/ &
     & 1.41505e+00_r8, 1.37820e+00_r8, 1.34232e+00_r8, 1.30736e+00_r8, 1.27332e+00_r8, &
     & 1.24016e+00_r8, 1.20786e+00_r8, 1.17641e+00_r8, 1.14578e+00_r8, 1.11594e+00_r8, &
     & 1.08688e+00_r8, 1.05858e+00_r8, 1.03101e+00_r8, 1.00416e+00_r8, 9.78015e-01_r8, &
     & 9.52547e-01_r8, 9.27742e-01_r8, 9.03583e-01_r8, 8.80053e-01_r8/)
      kao_mco( 1, :,11) = (/ &
     & 3.40468e-03_r8, 4.05994e-03_r8, 4.84130e-03_r8, 5.77305e-03_r8, 6.88412e-03_r8, &
     & 8.20902e-03_r8, 9.78890e-03_r8, 1.16728e-02_r8, 1.39194e-02_r8, 1.65983e-02_r8, &
     & 1.97927e-02_r8, 2.36020e-02_r8, 2.81444e-02_r8, 3.35610e-02_r8, 4.00200e-02_r8, &
     & 4.77222e-02_r8, 5.69067e-02_r8, 6.78588e-02_r8, 8.09187e-02_r8/)
      kao_mco( 2, :,11) = (/ &
     & 3.85021e-02_r8, 4.02208e-02_r8, 4.20162e-02_r8, 4.38918e-02_r8, 4.58512e-02_r8, &
     & 4.78980e-02_r8, 5.00361e-02_r8, 5.22697e-02_r8, 5.46031e-02_r8, 5.70405e-02_r8, &
     & 5.95868e-02_r8, 6.22468e-02_r8, 6.50254e-02_r8, 6.79282e-02_r8, 7.09605e-02_r8, &
     & 7.41282e-02_r8, 7.74372e-02_r8, 8.08940e-02_r8, 8.45051e-02_r8/)
      kao_mco( 3, :,11) = (/ &
     & 5.24852e-01_r8, 5.10480e-01_r8, 4.96501e-01_r8, 4.82905e-01_r8, 4.69681e-01_r8, &
     & 4.56820e-01_r8, 4.44310e-01_r8, 4.32143e-01_r8, 4.20310e-01_r8, 4.08800e-01_r8, &
     & 3.97606e-01_r8, 3.86718e-01_r8, 3.76128e-01_r8, 3.65828e-01_r8, 3.55810e-01_r8, &
     & 3.46067e-01_r8, 3.36590e-01_r8, 3.27373e-01_r8, 3.18409e-01_r8/)
      kao_mco( 4, :,11) = (/ &
     & 5.86290e-01_r8, 5.70241e-01_r8, 5.54632e-01_r8, 5.39450e-01_r8, 5.24683e-01_r8, &
     & 5.10321e-01_r8, 4.96352e-01_r8, 4.82765e-01_r8, 4.69550e-01_r8, 4.56697e-01_r8, &
     & 4.44196e-01_r8, 4.32036e-01_r8, 4.20210e-01_r8, 4.08708e-01_r8, 3.97520e-01_r8, &
     & 3.86638e-01_r8, 3.76055e-01_r8, 3.65761e-01_r8, 3.55749e-01_r8/)
      kao_mco( 5, :,11) = (/ &
     & 1.66977e+00_r8, 1.61807e+00_r8, 1.56798e+00_r8, 1.51943e+00_r8, 1.47239e+00_r8, &
     & 1.42681e+00_r8, 1.38264e+00_r8, 1.33983e+00_r8, 1.29835e+00_r8, 1.25815e+00_r8, &
     & 1.21920e+00_r8, 1.18146e+00_r8, 1.14488e+00_r8, 1.10943e+00_r8, 1.07509e+00_r8, &
     & 1.04180e+00_r8, 1.00955e+00_r8, 9.78295e-01_r8, 9.48008e-01_r8/)
      kao_mco( 6, :,11) = (/ &
     & 1.96627e+00_r8, 1.90948e+00_r8, 1.85432e+00_r8, 1.80076e+00_r8, 1.74875e+00_r8, &
     & 1.69823e+00_r8, 1.64918e+00_r8, 1.60155e+00_r8, 1.55529e+00_r8, 1.51036e+00_r8, &
     & 1.46674e+00_r8, 1.42437e+00_r8, 1.38323e+00_r8, 1.34328e+00_r8, 1.30448e+00_r8, &
     & 1.26680e+00_r8, 1.23021e+00_r8, 1.19467e+00_r8, 1.16016e+00_r8/)
      kao_mco( 7, :,11) = (/ &
     & 1.67574e+00_r8, 1.63510e+00_r8, 1.59544e+00_r8, 1.55674e+00_r8, 1.51898e+00_r8, &
     & 1.48213e+00_r8, 1.44618e+00_r8, 1.41111e+00_r8, 1.37688e+00_r8, 1.34348e+00_r8, &
     & 1.31090e+00_r8, 1.27910e+00_r8, 1.24808e+00_r8, 1.21780e+00_r8, 1.18826e+00_r8, &
     & 1.15944e+00_r8, 1.13132e+00_r8, 1.10388e+00_r8, 1.07710e+00_r8/)
      kao_mco( 8, :,11) = (/ &
     & 2.00764e+00_r8, 1.96233e+00_r8, 1.91803e+00_r8, 1.87474e+00_r8, 1.83242e+00_r8, &
     & 1.79106e+00_r8, 1.75063e+00_r8, 1.71111e+00_r8, 1.67249e+00_r8, 1.63474e+00_r8, &
     & 1.59784e+00_r8, 1.56177e+00_r8, 1.52652e+00_r8, 1.49206e+00_r8, 1.45838e+00_r8, &
     & 1.42546e+00_r8, 1.39329e+00_r8, 1.36184e+00_r8, 1.33110e+00_r8/)
      kao_mco( 9, :,11) = (/ &
     & 1.83026e+00_r8, 1.77349e+00_r8, 1.71849e+00_r8, 1.66519e+00_r8, 1.61355e+00_r8, &
     & 1.56350e+00_r8, 1.51501e+00_r8, 1.46803e+00_r8, 1.42250e+00_r8, 1.37838e+00_r8, &
     & 1.33563e+00_r8, 1.29421e+00_r8, 1.25407e+00_r8, 1.21517e+00_r8, 1.17749e+00_r8, &
     & 1.14097e+00_r8, 1.10558e+00_r8, 1.07129e+00_r8, 1.03807e+00_r8/)
      kao_mco( 1, :,12) = (/ &
     & 3.90309e-04_r8, 4.81310e-04_r8, 5.93528e-04_r8, 7.31909e-04_r8, 9.02554e-04_r8, &
     & 1.11299e-03_r8, 1.37248e-03_r8, 1.69247e-03_r8, 2.08708e-03_r8, 2.57368e-03_r8, &
     & 3.17374e-03_r8, 3.91370e-03_r8, 4.82617e-03_r8, 5.95140e-03_r8, 7.33897e-03_r8, &
     & 9.05007e-03_r8, 1.11601e-02_r8, 1.37621e-02_r8, 1.69707e-02_r8/)
      kao_mco( 2, :,12) = (/ &
     & 9.80585e-02_r8, 9.77457e-02_r8, 9.74339e-02_r8, 9.71231e-02_r8, 9.68132e-02_r8, &
     & 9.65044e-02_r8, 9.61965e-02_r8, 9.58897e-02_r8, 9.55838e-02_r8, 9.52789e-02_r8, &
     & 9.49749e-02_r8, 9.46719e-02_r8, 9.43699e-02_r8, 9.40689e-02_r8, 9.37688e-02_r8, &
     & 9.34697e-02_r8, 9.31715e-02_r8, 9.28743e-02_r8, 9.25780e-02_r8/)
      kao_mco( 3, :,12) = (/ &
     & 3.15258e-01_r8, 3.09936e-01_r8, 3.04704e-01_r8, 2.99560e-01_r8, 2.94503e-01_r8, &
     & 2.89532e-01_r8, 2.84645e-01_r8, 2.79840e-01_r8, 2.75116e-01_r8, 2.70472e-01_r8, &
     & 2.65906e-01_r8, 2.61417e-01_r8, 2.57004e-01_r8, 2.52666e-01_r8, 2.48401e-01_r8, &
     & 2.44207e-01_r8, 2.40085e-01_r8, 2.36032e-01_r8, 2.32048e-01_r8/)
      kao_mco( 4, :,12) = (/ &
     & 9.74407e-01_r8, 9.46900e-01_r8, 9.20170e-01_r8, 8.94195e-01_r8, 8.68952e-01_r8, &
     & 8.44422e-01_r8, 8.20585e-01_r8, 7.97421e-01_r8, 7.74910e-01_r8, 7.53035e-01_r8, &
     & 7.31777e-01_r8, 7.11120e-01_r8, 6.91046e-01_r8, 6.71538e-01_r8, 6.52581e-01_r8, &
     & 6.34159e-01_r8, 6.16257e-01_r8, 5.98861e-01_r8, 5.81956e-01_r8/)
      kao_mco( 5, :,12) = (/ &
     & 1.04234e+00_r8, 1.01364e+00_r8, 9.85726e-01_r8, 9.58581e-01_r8, 9.32184e-01_r8, &
     & 9.06514e-01_r8, 8.81551e-01_r8, 8.57275e-01_r8, 8.33668e-01_r8, 8.10710e-01_r8, &
     & 7.88385e-01_r8, 7.66675e-01_r8, 7.45563e-01_r8, 7.25032e-01_r8, 7.05066e-01_r8, &
     & 6.85650e-01_r8, 6.66769e-01_r8, 6.48408e-01_r8, 6.30552e-01_r8/)
      kao_mco( 6, :,12) = (/ &
     & 1.79052e+00_r8, 1.73725e+00_r8, 1.68557e+00_r8, 1.63543e+00_r8, 1.58678e+00_r8, &
     & 1.53957e+00_r8, 1.49377e+00_r8, 1.44933e+00_r8, 1.40622e+00_r8, 1.36439e+00_r8, &
     & 1.32380e+00_r8, 1.28442e+00_r8, 1.24621e+00_r8, 1.20913e+00_r8, 1.17316e+00_r8, &
     & 1.13826e+00_r8, 1.10440e+00_r8, 1.07155e+00_r8, 1.03967e+00_r8/)
      kao_mco( 7, :,12) = (/ &
     & 2.99551e+00_r8, 2.90366e+00_r8, 2.81462e+00_r8, 2.72831e+00_r8, 2.64464e+00_r8, &
     & 2.56355e+00_r8, 2.48494e+00_r8, 2.40874e+00_r8, 2.33487e+00_r8, 2.26328e+00_r8, &
     & 2.19387e+00_r8, 2.12660e+00_r8, 2.06139e+00_r8, 1.99818e+00_r8, 1.93690e+00_r8, &
     & 1.87751e+00_r8, 1.81993e+00_r8, 1.76413e+00_r8, 1.71003e+00_r8/)
      kao_mco( 8, :,12) = (/ &
     & 2.89665e+00_r8, 2.81184e+00_r8, 2.72951e+00_r8, 2.64960e+00_r8, 2.57202e+00_r8, &
     & 2.49672e+00_r8, 2.42362e+00_r8, 2.35266e+00_r8, 2.28378e+00_r8, 2.21692e+00_r8, &
     & 2.15201e+00_r8, 2.08900e+00_r8, 2.02784e+00_r8, 1.96847e+00_r8, 1.91084e+00_r8, &
     & 1.85489e+00_r8, 1.80059e+00_r8, 1.74787e+00_r8, 1.69669e+00_r8/)
      kao_mco( 9, :,12) = (/ &
     & 1.03145e+00_r8, 1.00335e+00_r8, 9.76014e-01_r8, 9.49426e-01_r8, 9.23561e-01_r8, &
     & 8.98402e-01_r8, 8.73927e-01_r8, 8.50120e-01_r8, 8.26961e-01_r8, 8.04433e-01_r8, &
     & 7.82518e-01_r8, 7.61201e-01_r8, 7.40464e-01_r8, 7.20293e-01_r8, 7.00670e-01_r8, &
     & 6.81583e-01_r8, 6.63015e-01_r8, 6.44953e-01_r8, 6.27383e-01_r8/)
      kao_mco( 1, :,13) = (/ &
     & 5.27769e-04_r8, 6.65449e-04_r8, 8.39047e-04_r8, 1.05793e-03_r8, 1.33392e-03_r8, &
     & 1.68190e-03_r8, 2.12066e-03_r8, 2.67388e-03_r8, 3.37143e-03_r8, 4.25094e-03_r8, &
     & 5.35990e-03_r8, 6.75816e-03_r8, 8.52117e-03_r8, 1.07441e-02_r8, 1.35470e-02_r8, &
     & 1.70810e-02_r8, 2.15370e-02_r8, 2.71554e-02_r8, 3.42395e-02_r8/)
      kao_mco( 2, :,13) = (/ &
     & 1.08329e-01_r8, 1.10179e-01_r8, 1.12060e-01_r8, 1.13974e-01_r8, 1.15920e-01_r8, &
     & 1.17899e-01_r8, 1.19913e-01_r8, 1.21960e-01_r8, 1.24043e-01_r8, 1.26161e-01_r8, &
     & 1.28316e-01_r8, 1.30507e-01_r8, 1.32735e-01_r8, 1.35002e-01_r8, 1.37307e-01_r8, &
     & 1.39652e-01_r8, 1.42037e-01_r8, 1.44462e-01_r8, 1.46929e-01_r8/)
      kao_mco( 3, :,13) = (/ &
     & 1.95992e-01_r8, 1.94515e-01_r8, 1.93049e-01_r8, 1.91594e-01_r8, 1.90150e-01_r8, &
     & 1.88717e-01_r8, 1.87294e-01_r8, 1.85882e-01_r8, 1.84481e-01_r8, 1.83091e-01_r8, &
     & 1.81711e-01_r8, 1.80341e-01_r8, 1.78982e-01_r8, 1.77633e-01_r8, 1.76294e-01_r8, &
     & 1.74965e-01_r8, 1.73646e-01_r8, 1.72337e-01_r8, 1.71038e-01_r8/)
      kao_mco( 4, :,13) = (/ &
     & 4.49766e-01_r8, 4.42749e-01_r8, 4.35841e-01_r8, 4.29042e-01_r8, 4.22348e-01_r8, &
     & 4.15759e-01_r8, 4.09272e-01_r8, 4.02887e-01_r8, 3.96601e-01_r8, 3.90414e-01_r8, &
     & 3.84323e-01_r8, 3.78327e-01_r8, 3.72424e-01_r8, 3.66614e-01_r8, 3.60894e-01_r8, &
     & 3.55264e-01_r8, 3.49721e-01_r8, 3.44265e-01_r8, 3.38894e-01_r8/)
      kao_mco( 5, :,13) = (/ &
     & 1.07498e+00_r8, 1.04736e+00_r8, 1.02045e+00_r8, 9.94232e-01_r8, 9.68686e-01_r8, &
     & 9.43797e-01_r8, 9.19547e-01_r8, 8.95920e-01_r8, 8.72900e-01_r8, 8.50471e-01_r8, &
     & 8.28619e-01_r8, 8.07329e-01_r8, 7.86585e-01_r8, 7.66374e-01_r8, 7.46683e-01_r8, &
     & 7.27498e-01_r8, 7.08805e-01_r8, 6.90593e-01_r8, 6.72849e-01_r8/)
      kao_mco( 6, :,13) = (/ &
     & 1.66569e+00_r8, 1.61740e+00_r8, 1.57052e+00_r8, 1.52500e+00_r8, 1.48080e+00_r8, &
     & 1.43787e+00_r8, 1.39620e+00_r8, 1.35573e+00_r8, 1.31643e+00_r8, 1.27827e+00_r8, &
     & 1.24122e+00_r8, 1.20524e+00_r8, 1.17031e+00_r8, 1.13638e+00_r8, 1.10344e+00_r8, &
     & 1.07146e+00_r8, 1.04040e+00_r8, 1.01025e+00_r8, 9.80963e-01_r8/)
      kao_mco( 7, :,13) = (/ &
     & 1.52948e+00_r8, 1.48763e+00_r8, 1.44693e+00_r8, 1.40735e+00_r8, 1.36884e+00_r8, &
     & 1.33139e+00_r8, 1.29497e+00_r8, 1.25954e+00_r8, 1.22508e+00_r8, 1.19156e+00_r8, &
     & 1.15896e+00_r8, 1.12725e+00_r8, 1.09641e+00_r8, 1.06641e+00_r8, 1.03724e+00_r8, &
     & 1.00886e+00_r8, 9.81259e-01_r8, 9.54412e-01_r8, 9.28301e-01_r8/)
      kao_mco( 8, :,13) = (/ &
     & 3.81027e+00_r8, 3.69422e+00_r8, 3.58170e+00_r8, 3.47261e+00_r8, 3.36684e+00_r8, &
     & 3.26429e+00_r8, 3.16486e+00_r8, 3.06847e+00_r8, 2.97501e+00_r8, 2.88439e+00_r8, &
     & 2.79654e+00_r8, 2.71136e+00_r8, 2.62878e+00_r8, 2.54871e+00_r8, 2.47108e+00_r8, &
     & 2.39581e+00_r8, 2.32284e+00_r8, 2.25209e+00_r8, 2.18350e+00_r8/)
      kao_mco( 9, :,13) = (/ &
     & 1.12516e+00_r8, 1.09531e+00_r8, 1.06625e+00_r8, 1.03796e+00_r8, 1.01042e+00_r8, &
     & 9.83616e-01_r8, 9.57520e-01_r8, 9.32117e-01_r8, 9.07387e-01_r8, 8.83314e-01_r8, &
     & 8.59880e-01_r8, 8.37067e-01_r8, 8.14859e-01_r8, 7.93241e-01_r8, 7.72196e-01_r8, &
     & 7.51709e-01_r8, 7.31766e-01_r8, 7.12352e-01_r8, 6.93454e-01_r8/)
      kao_mco( 1, :,14) = (/ &
     & 4.79165e-04_r8, 6.26966e-04_r8, 8.20356e-04_r8, 1.07340e-03_r8, 1.40450e-03_r8, &
     & 1.83772e-03_r8, 2.40457e-03_r8, 3.14628e-03_r8, 4.11676e-03_r8, 5.38660e-03_r8, &
     & 7.04813e-03_r8, 9.22216e-03_r8, 1.20668e-02_r8, 1.57889e-02_r8, 2.06590e-02_r8, &
     & 2.70314e-02_r8, 3.53694e-02_r8, 4.62792e-02_r8, 6.05542e-02_r8/)
      kao_mco( 2, :,14) = (/ &
     & 4.75367e-04_r8, 6.21987e-04_r8, 8.13830e-04_r8, 1.06484e-03_r8, 1.39328e-03_r8, &
     & 1.82302e-03_r8, 2.38530e-03_r8, 3.12101e-03_r8, 4.08365e-03_r8, 5.34318e-03_r8, &
     & 6.99121e-03_r8, 9.14756e-03_r8, 1.19690e-02_r8, 1.56607e-02_r8, 2.04909e-02_r8, &
     & 2.68111e-02_r8, 3.50806e-02_r8, 4.59007e-02_r8, 6.00580e-02_r8/)
      kao_mco( 3, :,14) = (/ &
     & 1.39594e-01_r8, 1.42407e-01_r8, 1.45276e-01_r8, 1.48202e-01_r8, 1.51188e-01_r8, &
     & 1.54234e-01_r8, 1.57342e-01_r8, 1.60512e-01_r8, 1.63745e-01_r8, 1.67044e-01_r8, &
     & 1.70410e-01_r8, 1.73843e-01_r8, 1.77345e-01_r8, 1.80918e-01_r8, 1.84563e-01_r8, &
     & 1.88282e-01_r8, 1.92075e-01_r8, 1.95945e-01_r8, 1.99892e-01_r8/)
      kao_mco( 4, :,14) = (/ &
     & 2.73418e-01_r8, 2.71322e-01_r8, 2.69242e-01_r8, 2.67177e-01_r8, 2.65129e-01_r8, &
     & 2.63096e-01_r8, 2.61079e-01_r8, 2.59077e-01_r8, 2.57091e-01_r8, 2.55120e-01_r8, &
     & 2.53164e-01_r8, 2.51223e-01_r8, 2.49297e-01_r8, 2.47386e-01_r8, 2.45489e-01_r8, &
     & 2.43607e-01_r8, 2.41739e-01_r8, 2.39886e-01_r8, 2.38047e-01_r8/)
      kao_mco( 5, :,14) = (/ &
     & 5.01880e-01_r8, 4.95066e-01_r8, 4.88344e-01_r8, 4.81713e-01_r8, 4.75173e-01_r8, &
     & 4.68721e-01_r8, 4.62357e-01_r8, 4.56079e-01_r8, 4.49887e-01_r8, 4.43778e-01_r8, &
     & 4.37753e-01_r8, 4.31809e-01_r8, 4.25946e-01_r8, 4.20163e-01_r8, 4.14458e-01_r8, &
     & 4.08830e-01_r8, 4.03279e-01_r8, 3.97804e-01_r8, 3.92403e-01_r8/)
      kao_mco( 6, :,14) = (/ &
     & 9.46125e-01_r8, 9.29642e-01_r8, 9.13447e-01_r8, 8.97533e-01_r8, 8.81897e-01_r8, &
     & 8.66533e-01_r8, 8.51437e-01_r8, 8.36603e-01_r8, 8.22029e-01_r8, 8.07708e-01_r8, &
     & 7.93636e-01_r8, 7.79810e-01_r8, 7.66225e-01_r8, 7.52876e-01_r8, 7.39760e-01_r8, &
     & 7.26872e-01_r8, 7.14209e-01_r8, 7.01766e-01_r8, 6.89540e-01_r8/)
      kao_mco( 7, :,14) = (/ &
     & 2.47697e+00_r8, 2.41183e+00_r8, 2.34840e+00_r8, 2.28664e+00_r8, 2.22650e+00_r8, &
     & 2.16795e+00_r8, 2.11093e+00_r8, 2.05541e+00_r8, 2.00136e+00_r8, 1.94872e+00_r8, &
     & 1.89747e+00_r8, 1.84757e+00_r8, 1.79898e+00_r8, 1.75167e+00_r8, 1.70560e+00_r8, &
     & 1.66074e+00_r8, 1.61707e+00_r8, 1.57454e+00_r8, 1.53313e+00_r8/)
      kao_mco( 8, :,14) = (/ &
     & 2.19323e+00_r8, 2.13926e+00_r8, 2.08662e+00_r8, 2.03528e+00_r8, 1.98519e+00_r8, &
     & 1.93635e+00_r8, 1.88870e+00_r8, 1.84222e+00_r8, 1.79689e+00_r8, 1.75268e+00_r8, &
     & 1.70955e+00_r8, 1.66748e+00_r8, 1.62645e+00_r8, 1.58643e+00_r8, 1.54739e+00_r8, &
     & 1.50932e+00_r8, 1.47218e+00_r8, 1.43595e+00_r8, 1.40062e+00_r8/)
      kao_mco( 9, :,14) = (/ &
     & 5.68351e-01_r8, 5.60360e-01_r8, 5.52481e-01_r8, 5.44712e-01_r8, 5.37053e-01_r8, &
     & 5.29502e-01_r8, 5.22057e-01_r8, 5.14716e-01_r8, 5.07479e-01_r8, 5.00343e-01_r8, &
     & 4.93308e-01_r8, 4.86372e-01_r8, 4.79533e-01_r8, 4.72790e-01_r8, 4.66142e-01_r8, &
     & 4.59588e-01_r8, 4.53126e-01_r8, 4.46754e-01_r8, 4.40473e-01_r8/)
      kao_mco( 1, :,15) = (/ &
     & 7.87937e-04_r8, 1.01733e-03_r8, 1.31351e-03_r8, 1.69591e-03_r8, 2.18964e-03_r8, &
     & 2.82712e-03_r8, 3.65018e-03_r8, 4.71286e-03_r8, 6.08493e-03_r8, 7.85644e-03_r8, &
     & 1.01437e-02_r8, 1.30969e-02_r8, 1.69098e-02_r8, 2.18327e-02_r8, 2.81889e-02_r8, &
     & 3.63956e-02_r8, 4.69915e-02_r8, 6.06722e-02_r8, 7.83357e-02_r8/)
      kao_mco( 2, :,15) = (/ &
     & 7.87937e-04_r8, 1.01733e-03_r8, 1.31351e-03_r8, 1.69591e-03_r8, 2.18964e-03_r8, &
     & 2.82712e-03_r8, 3.65018e-03_r8, 4.71286e-03_r8, 6.08493e-03_r8, 7.85644e-03_r8, &
     & 1.01437e-02_r8, 1.30969e-02_r8, 1.69098e-02_r8, 2.18327e-02_r8, 2.81889e-02_r8, &
     & 3.63956e-02_r8, 4.69915e-02_r8, 6.06722e-02_r8, 7.83357e-02_r8/)
      kao_mco( 3, :,15) = (/ &
     & 1.97281e-01_r8, 2.00714e-01_r8, 2.04206e-01_r8, 2.07760e-01_r8, 2.11375e-01_r8, &
     & 2.15053e-01_r8, 2.18795e-01_r8, 2.22603e-01_r8, 2.26476e-01_r8, 2.30417e-01_r8, &
     & 2.34426e-01_r8, 2.38506e-01_r8, 2.42656e-01_r8, 2.46878e-01_r8, 2.51174e-01_r8, &
     & 2.55545e-01_r8, 2.59992e-01_r8, 2.64516e-01_r8, 2.69119e-01_r8/)
      kao_mco( 4, :,15) = (/ &
     & 4.47509e-01_r8, 4.52222e-01_r8, 4.56985e-01_r8, 4.61799e-01_r8, 4.66663e-01_r8, &
     & 4.71578e-01_r8, 4.76545e-01_r8, 4.81565e-01_r8, 4.86637e-01_r8, 4.91763e-01_r8, &
     & 4.96942e-01_r8, 5.02177e-01_r8, 5.07466e-01_r8, 5.12811e-01_r8, 5.18213e-01_r8, &
     & 5.23671e-01_r8, 5.29187e-01_r8, 5.34761e-01_r8, 5.40393e-01_r8/)
      kao_mco( 5, :,15) = (/ &
     & 1.02732e+00_r8, 1.02091e+00_r8, 1.01453e+00_r8, 1.00820e+00_r8, 1.00191e+00_r8, &
     & 9.95660e-01_r8, 9.89447e-01_r8, 9.83273e-01_r8, 9.77137e-01_r8, 9.71039e-01_r8, &
     & 9.64980e-01_r8, 9.58958e-01_r8, 9.52974e-01_r8, 9.47027e-01_r8, 9.41118e-01_r8, &
     & 9.35245e-01_r8, 9.29409e-01_r8, 9.23609e-01_r8, 9.17846e-01_r8/)
      kao_mco( 6, :,15) = (/ &
     & 1.13766e+00_r8, 1.12944e+00_r8, 1.12128e+00_r8, 1.11318e+00_r8, 1.10514e+00_r8, &
     & 1.09715e+00_r8, 1.08923e+00_r8, 1.08136e+00_r8, 1.07355e+00_r8, 1.06579e+00_r8, &
     & 1.05809e+00_r8, 1.05045e+00_r8, 1.04286e+00_r8, 1.03532e+00_r8, 1.02784e+00_r8, &
     & 1.02042e+00_r8, 1.01305e+00_r8, 1.00573e+00_r8, 9.98462e-01_r8/)
      kao_mco( 7, :,15) = (/ &
     & 1.13268e+00_r8, 1.12496e+00_r8, 1.11730e+00_r8, 1.10969e+00_r8, 1.10213e+00_r8, &
     & 1.09462e+00_r8, 1.08717e+00_r8, 1.07976e+00_r8, 1.07241e+00_r8, 1.06510e+00_r8, &
     & 1.05785e+00_r8, 1.05064e+00_r8, 1.04349e+00_r8, 1.03638e+00_r8, 1.02932e+00_r8, &
     & 1.02231e+00_r8, 1.01535e+00_r8, 1.00843e+00_r8, 1.00156e+00_r8/)
      kao_mco( 8, :,15) = (/ &
     & 1.11982e+00_r8, 1.11343e+00_r8, 1.10707e+00_r8, 1.10075e+00_r8, 1.09447e+00_r8, &
     & 1.08822e+00_r8, 1.08201e+00_r8, 1.07583e+00_r8, 1.06969e+00_r8, 1.06358e+00_r8, &
     & 1.05751e+00_r8, 1.05147e+00_r8, 1.04547e+00_r8, 1.03950e+00_r8, 1.03356e+00_r8, &
     & 1.02766e+00_r8, 1.02180e+00_r8, 1.01596e+00_r8, 1.01016e+00_r8/)
      kao_mco( 9, :,15) = (/ &
     & 1.03561e+00_r8, 1.02902e+00_r8, 1.02246e+00_r8, 1.01595e+00_r8, 1.00948e+00_r8, &
     & 1.00305e+00_r8, 9.96667e-01_r8, 9.90320e-01_r8, 9.84013e-01_r8, 9.77747e-01_r8, &
     & 9.71520e-01_r8, 9.65334e-01_r8, 9.59186e-01_r8, 9.53078e-01_r8, 9.47008e-01_r8, &
     & 9.40978e-01_r8, 9.34985e-01_r8, 9.29031e-01_r8, 9.23115e-01_r8/)
      kao_mco( 1, :,16) = (/ &
     & 1.22217e-03_r8, 1.56836e-03_r8, 2.01261e-03_r8, 2.58271e-03_r8, 3.31429e-03_r8, &
     & 4.25310e-03_r8, 5.45784e-03_r8, 7.00383e-03_r8, 8.98775e-03_r8, 1.15336e-02_r8, &
     & 1.48007e-02_r8, 1.89931e-02_r8, 2.43731e-02_r8, 3.12771e-02_r8, 4.01367e-02_r8, &
     & 5.15059e-02_r8, 6.60956e-02_r8, 8.48179e-02_r8, 1.08843e-01_r8/)
      kao_mco( 2, :,16) = (/ &
     & 1.22217e-03_r8, 1.56836e-03_r8, 2.01261e-03_r8, 2.58271e-03_r8, 3.31429e-03_r8, &
     & 4.25310e-03_r8, 5.45784e-03_r8, 7.00383e-03_r8, 8.98775e-03_r8, 1.15336e-02_r8, &
     & 1.48007e-02_r8, 1.89931e-02_r8, 2.43731e-02_r8, 3.12771e-02_r8, 4.01367e-02_r8, &
     & 5.15059e-02_r8, 6.60956e-02_r8, 8.48179e-02_r8, 1.08843e-01_r8/)
      kao_mco( 3, :,16) = (/ &
     & 1.22217e-03_r8, 1.56836e-03_r8, 2.01261e-03_r8, 2.58271e-03_r8, 3.31429e-03_r8, &
     & 4.25310e-03_r8, 5.45784e-03_r8, 7.00383e-03_r8, 8.98775e-03_r8, 1.15336e-02_r8, &
     & 1.48007e-02_r8, 1.89931e-02_r8, 2.43731e-02_r8, 3.12771e-02_r8, 4.01367e-02_r8, &
     & 5.15059e-02_r8, 6.60956e-02_r8, 8.48179e-02_r8, 1.08843e-01_r8/)
      kao_mco( 4, :,16) = (/ &
     & 1.01221e+00_r8, 1.01660e+00_r8, 1.02101e+00_r8, 1.02544e+00_r8, 1.02989e+00_r8, &
     & 1.03436e+00_r8, 1.03884e+00_r8, 1.04335e+00_r8, 1.04788e+00_r8, 1.05243e+00_r8, &
     & 1.05699e+00_r8, 1.06158e+00_r8, 1.06619e+00_r8, 1.07081e+00_r8, 1.07546e+00_r8, &
     & 1.08012e+00_r8, 1.08481e+00_r8, 1.08952e+00_r8, 1.09425e+00_r8/)
      kao_mco( 5, :,16) = (/ &
     & 1.01221e+00_r8, 1.01660e+00_r8, 1.02101e+00_r8, 1.02544e+00_r8, 1.02989e+00_r8, &
     & 1.03436e+00_r8, 1.03884e+00_r8, 1.04335e+00_r8, 1.04788e+00_r8, 1.05243e+00_r8, &
     & 1.05699e+00_r8, 1.06158e+00_r8, 1.06619e+00_r8, 1.07081e+00_r8, 1.07546e+00_r8, &
     & 1.08012e+00_r8, 1.08481e+00_r8, 1.08952e+00_r8, 1.09425e+00_r8/)
      kao_mco( 6, :,16) = (/ &
     & 1.01221e+00_r8, 1.01660e+00_r8, 1.02101e+00_r8, 1.02544e+00_r8, 1.02989e+00_r8, &
     & 1.03436e+00_r8, 1.03884e+00_r8, 1.04335e+00_r8, 1.04788e+00_r8, 1.05243e+00_r8, &
     & 1.05699e+00_r8, 1.06158e+00_r8, 1.06619e+00_r8, 1.07081e+00_r8, 1.07546e+00_r8, &
     & 1.08012e+00_r8, 1.08481e+00_r8, 1.08952e+00_r8, 1.09425e+00_r8/)
      kao_mco( 7, :,16) = (/ &
     & 1.01221e+00_r8, 1.01660e+00_r8, 1.02101e+00_r8, 1.02544e+00_r8, 1.02989e+00_r8, &
     & 1.03436e+00_r8, 1.03884e+00_r8, 1.04335e+00_r8, 1.04788e+00_r8, 1.05243e+00_r8, &
     & 1.05699e+00_r8, 1.06158e+00_r8, 1.06619e+00_r8, 1.07081e+00_r8, 1.07546e+00_r8, &
     & 1.08012e+00_r8, 1.08481e+00_r8, 1.08952e+00_r8, 1.09425e+00_r8/)
      kao_mco( 8, :,16) = (/ &
     & 1.01221e+00_r8, 1.01660e+00_r8, 1.02101e+00_r8, 1.02544e+00_r8, 1.02989e+00_r8, &
     & 1.03436e+00_r8, 1.03884e+00_r8, 1.04335e+00_r8, 1.04788e+00_r8, 1.05243e+00_r8, &
     & 1.05699e+00_r8, 1.06158e+00_r8, 1.06619e+00_r8, 1.07081e+00_r8, 1.07546e+00_r8, &
     & 1.08012e+00_r8, 1.08481e+00_r8, 1.08952e+00_r8, 1.09425e+00_r8/)
      kao_mco( 9, :,16) = (/ &
     & 1.01221e+00_r8, 1.01660e+00_r8, 1.02101e+00_r8, 1.02544e+00_r8, 1.02989e+00_r8, &
     & 1.03436e+00_r8, 1.03884e+00_r8, 1.04335e+00_r8, 1.04788e+00_r8, 1.05243e+00_r8, &
     & 1.05699e+00_r8, 1.06158e+00_r8, 1.06619e+00_r8, 1.07081e+00_r8, 1.07546e+00_r8, &
     & 1.08012e+00_r8, 1.08481e+00_r8, 1.08952e+00_r8, 1.09425e+00_r8/)

!     The array KBO_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level above 100~ mb.   The first index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The second index 
!     runs over the g-channel (1 to 16).

      kbo_mo3(:, 1) = (/ &
     & 1.07596e-02_r8, 1.12146e-02_r8, 1.16887e-02_r8, 1.21830e-02_r8, 1.26981e-02_r8, &
     & 1.32350e-02_r8, 1.37946e-02_r8, 1.43779e-02_r8, 1.49858e-02_r8, 1.56194e-02_r8, &
     & 1.62799e-02_r8, 1.69682e-02_r8, 1.76857e-02_r8, 1.84334e-02_r8, 1.92129e-02_r8, &
     & 2.00252e-02_r8, 2.08719e-02_r8, 2.17544e-02_r8, 2.26743e-02_r8/)
      kbo_mo3(:, 2) = (/ &
     & 9.48276e-02_r8, 9.66591e-02_r8, 9.85260e-02_r8, 1.00429e-01_r8, 1.02369e-01_r8, &
     & 1.04346e-01_r8, 1.06361e-01_r8, 1.08416e-01_r8, 1.10510e-01_r8, 1.12644e-01_r8, &
     & 1.14820e-01_r8, 1.17037e-01_r8, 1.19298e-01_r8, 1.21602e-01_r8, 1.23951e-01_r8, &
     & 1.26345e-01_r8, 1.28785e-01_r8, 1.31273e-01_r8, 1.33808e-01_r8/)
      kbo_mo3(:, 3) = (/ &
     & 3.54721e-01_r8, 3.55779e-01_r8, 3.56841e-01_r8, 3.57906e-01_r8, 3.58973e-01_r8, &
     & 3.60044e-01_r8, 3.61119e-01_r8, 3.62196e-01_r8, 3.63277e-01_r8, 3.64360e-01_r8, &
     & 3.65448e-01_r8, 3.66538e-01_r8, 3.67631e-01_r8, 3.68728e-01_r8, 3.69828e-01_r8, &
     & 3.70932e-01_r8, 3.72038e-01_r8, 3.73148e-01_r8, 3.74262e-01_r8/)
      kbo_mo3(:, 4) = (/ &
     & 6.46454e-01_r8, 6.43823e-01_r8, 6.41202e-01_r8, 6.38593e-01_r8, 6.35994e-01_r8, &
     & 6.33405e-01_r8, 6.30827e-01_r8, 6.28260e-01_r8, 6.25703e-01_r8, 6.23156e-01_r8, &
     & 6.20620e-01_r8, 6.18094e-01_r8, 6.15578e-01_r8, 6.13073e-01_r8, 6.10578e-01_r8, &
     & 6.08093e-01_r8, 6.05618e-01_r8, 6.03153e-01_r8, 6.00698e-01_r8/)
      kbo_mo3(:, 5) = (/ &
     & 9.29832e-01_r8, 9.22877e-01_r8, 9.15975e-01_r8, 9.09124e-01_r8, 9.02324e-01_r8, &
     & 8.95576e-01_r8, 8.88877e-01_r8, 8.82229e-01_r8, 8.75631e-01_r8, 8.69082e-01_r8, &
     & 8.62582e-01_r8, 8.56130e-01_r8, 8.49727e-01_r8, 8.43372e-01_r8, 8.37064e-01_r8, &
     & 8.30803e-01_r8, 8.24589e-01_r8, 8.18422e-01_r8, 8.12301e-01_r8/)
      kbo_mo3(:, 6) = (/ &
     & 1.43531e+00_r8, 1.42616e+00_r8, 1.41706e+00_r8, 1.40802e+00_r8, 1.39903e+00_r8, &
     & 1.39010e+00_r8, 1.38124e+00_r8, 1.37242e+00_r8, 1.36367e+00_r8, 1.35496e+00_r8, &
     & 1.34632e+00_r8, 1.33773e+00_r8, 1.32919e+00_r8, 1.32071e+00_r8, 1.31229e+00_r8, &
     & 1.30391e+00_r8, 1.29559e+00_r8, 1.28733e+00_r8, 1.27911e+00_r8/)
      kbo_mo3(:, 7) = (/ &
     & 2.68664e+00_r8, 2.67196e+00_r8, 2.65736e+00_r8, 2.64284e+00_r8, 2.62840e+00_r8, &
     & 2.61404e+00_r8, 2.59975e+00_r8, 2.58555e+00_r8, 2.57142e+00_r8, 2.55737e+00_r8, &
     & 2.54340e+00_r8, 2.52950e+00_r8, 2.51568e+00_r8, 2.50193e+00_r8, 2.48826e+00_r8, &
     & 2.47466e+00_r8, 2.46114e+00_r8, 2.44769e+00_r8, 2.43432e+00_r8/)
      kbo_mo3(:, 8) = (/ &
     & 2.45343e+00_r8, 2.43442e+00_r8, 2.41556e+00_r8, 2.39684e+00_r8, 2.37827e+00_r8, &
     & 2.35984e+00_r8, 2.34156e+00_r8, 2.32342e+00_r8, 2.30541e+00_r8, 2.28755e+00_r8, &
     & 2.26983e+00_r8, 2.25224e+00_r8, 2.23479e+00_r8, 2.21747e+00_r8, 2.20029e+00_r8, &
     & 2.18324e+00_r8, 2.16633e+00_r8, 2.14954e+00_r8, 2.13289e+00_r8/)
      kbo_mo3(:, 9) = (/ &
     & 1.55879e-01_r8, 1.55998e-01_r8, 1.56118e-01_r8, 1.56238e-01_r8, 1.56358e-01_r8, &
     & 1.56478e-01_r8, 1.56599e-01_r8, 1.56719e-01_r8, 1.56840e-01_r8, 1.56960e-01_r8, &
     & 1.57081e-01_r8, 1.57201e-01_r8, 1.57322e-01_r8, 1.57443e-01_r8, 1.57564e-01_r8, &
     & 1.57685e-01_r8, 1.57806e-01_r8, 1.57928e-01_r8, 1.58049e-01_r8/)
      kbo_mo3(:,10) = (/ &
     & 8.75149e-03_r8, 8.88794e-03_r8, 9.02651e-03_r8, 9.16725e-03_r8, 9.31018e-03_r8, &
     & 9.45534e-03_r8, 9.60276e-03_r8, 9.75248e-03_r8, 9.90454e-03_r8, 1.00590e-02_r8, &
     & 1.02158e-02_r8, 1.03751e-02_r8, 1.05368e-02_r8, 1.07011e-02_r8, 1.08680e-02_r8, &
     & 1.10374e-02_r8, 1.12095e-02_r8, 1.13843e-02_r8, 1.15618e-02_r8/)
      kbo_mo3(:,11) = (/ &
     & 8.83874e-03_r8, 8.97926e-03_r8, 9.12201e-03_r8, 9.26703e-03_r8, 9.41436e-03_r8, &
     & 9.56403e-03_r8, 9.71608e-03_r8, 9.87055e-03_r8, 1.00275e-02_r8, 1.01869e-02_r8, &
     & 1.03488e-02_r8, 1.05134e-02_r8, 1.06805e-02_r8, 1.08503e-02_r8, 1.10228e-02_r8, &
     & 1.11980e-02_r8, 1.13761e-02_r8, 1.15569e-02_r8, 1.17407e-02_r8/)
      kbo_mo3(:,12) = (/ &
     & 9.59461e-03_r8, 9.70417e-03_r8, 9.81498e-03_r8, 9.92705e-03_r8, 1.00404e-02_r8, &
     & 1.01550e-02_r8, 1.02710e-02_r8, 1.03883e-02_r8, 1.05069e-02_r8, 1.06269e-02_r8, &
     & 1.07482e-02_r8, 1.08709e-02_r8, 1.09951e-02_r8, 1.11206e-02_r8, 1.12476e-02_r8, &
     & 1.13760e-02_r8, 1.15059e-02_r8, 1.16373e-02_r8, 1.17702e-02_r8/)
      kbo_mo3(:,13) = (/ &
     & 1.13077e-02_r8, 1.14079e-02_r8, 1.15089e-02_r8, 1.16109e-02_r8, 1.17138e-02_r8, &
     & 1.18176e-02_r8, 1.19223e-02_r8, 1.20279e-02_r8, 1.21344e-02_r8, 1.22419e-02_r8, &
     & 1.23504e-02_r8, 1.24598e-02_r8, 1.25702e-02_r8, 1.26816e-02_r8, 1.27939e-02_r8, &
     & 1.29073e-02_r8, 1.30216e-02_r8, 1.31370e-02_r8, 1.32534e-02_r8/)
      kbo_mo3(:,14) = (/ &
     & 6.74844e-03_r8, 6.82637e-03_r8, 6.90519e-03_r8, 6.98493e-03_r8, 7.06558e-03_r8, &
     & 7.14717e-03_r8, 7.22970e-03_r8, 7.31318e-03_r8, 7.39762e-03_r8, 7.48304e-03_r8, &
     & 7.56945e-03_r8, 7.65686e-03_r8, 7.74527e-03_r8, 7.83470e-03_r8, 7.92517e-03_r8, &
     & 8.01668e-03_r8, 8.10925e-03_r8, 8.20289e-03_r8, 8.29761e-03_r8/)
      kbo_mo3(:,15) = (/ &
     & 7.94595e-03_r8, 8.00015e-03_r8, 8.05472e-03_r8, 8.10966e-03_r8, 8.16497e-03_r8, &
     & 8.22067e-03_r8, 8.27674e-03_r8, 8.33320e-03_r8, 8.39004e-03_r8, 8.44727e-03_r8, &
     & 8.50489e-03_r8, 8.56290e-03_r8, 8.62130e-03_r8, 8.68011e-03_r8, 8.73932e-03_r8, &
     & 8.79893e-03_r8, 8.85895e-03_r8, 8.91937e-03_r8, 8.98021e-03_r8/)
      kbo_mo3(:,16) = (/ &
     & 1.85967e-03_r8, 1.86082e-03_r8, 1.86197e-03_r8, 1.86312e-03_r8, 1.86428e-03_r8, &
     & 1.86543e-03_r8, 1.86658e-03_r8, 1.86774e-03_r8, 1.86889e-03_r8, 1.87005e-03_r8, &
     & 1.87121e-03_r8, 1.87236e-03_r8, 1.87352e-03_r8, 1.87468e-03_r8, 1.87584e-03_r8, &
     & 1.87700e-03_r8, 1.87816e-03_r8, 1.87932e-03_r8, 1.88049e-03_r8/)

!     The array FORREFO contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  The first 
!     index refers to reference temperature (296,260,224,260) and 
!     pressure (970,475,219,3 mbar) levels.  The second index 
!     runs over the g-channel (1 to 16).

      forrefo(1,:) = (/ &
     &1.6586e-05_r8,1.9995e-05_r8,1.8582e-05_r8,1.3988e-05_r8,1.3650e-05_r8,1.1079e-05_r8, &
     &9.5855e-06_r8,8.4062e-06_r8,1.3558e-05_r8,1.8620e-05_r8,2.2652e-05_r8,1.7883e-05_r8, &
     &2.6241e-05_r8,3.1171e-05_r8,3.9386e-05_r8,4.4415e-05_r8/)
      forrefo(2,:) = (/ &
     &2.0730e-05_r8,2.3258e-05_r8,2.1543e-05_r8,1.5660e-05_r8,9.7872e-06_r8,8.1078e-06_r8, &
     &7.0246e-06_r8,6.0428e-06_r8,4.8793e-06_r8,4.4937e-06_r8,4.7078e-06_r8,4.6898e-06_r8, &
     &6.9481e-06_r8,8.6269e-06_r8,3.1761e-06_r8,3.1440e-06_r8/)
      forrefo(3,:) = (/ &
     &1.5737e-05_r8,2.2501e-05_r8,2.3520e-05_r8,2.0288e-05_r8,1.2083e-05_r8,6.8256e-06_r8, &
     &6.0637e-06_r8,5.5434e-06_r8,4.3888e-06_r8,3.8435e-06_r8,3.8477e-06_r8,3.8314e-06_r8, &
     &3.8251e-06_r8,3.3637e-06_r8,3.1950e-06_r8,3.1440e-06_r8/)
      forrefo(4,:) = (/ &
     &1.1400e-05_r8,7.9751e-06_r8,8.8659e-06_r8,1.5884e-05_r8,1.9118e-05_r8,1.9429e-05_r8, &
     &2.0532e-05_r8,2.2155e-05_r8,2.3894e-05_r8,2.2984e-05_r8,2.3731e-05_r8,2.4538e-05_r8, &
     &2.6697e-05_r8,1.9329e-05_r8,3.3306e-06_r8,3.2018e-06_r8/)

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      selfrefo(:, 1) = (/ &
     & 9.62275e-03_r8, 8.29909e-03_r8, 7.15750e-03_r8, 6.17294e-03_r8, 5.32382e-03_r8, &
     & 4.59150e-03_r8, 3.95991e-03_r8, 3.41520e-03_r8, 2.94542e-03_r8, 2.54026e-03_r8/)
      selfrefo(:, 2) = (/ &
     & 9.76664e-03_r8, 8.47783e-03_r8, 7.35910e-03_r8, 6.38799e-03_r8, 5.54504e-03_r8, &
     & 4.81331e-03_r8, 4.17815e-03_r8, 3.62680e-03_r8, 3.14821e-03_r8, 2.73277e-03_r8/)
      selfrefo(:, 3) = (/ &
     & 9.53856e-03_r8, 8.23750e-03_r8, 7.11390e-03_r8, 6.14356e-03_r8, 5.30558e-03_r8, &
     & 4.58190e-03_r8, 3.95693e-03_r8, 3.41720e-03_r8, 2.95109e-03_r8, 2.54856e-03_r8/)
      selfrefo(:, 4) = (/ &
     & 8.47621e-03_r8, 7.29518e-03_r8, 6.27870e-03_r8, 5.40385e-03_r8, 4.65091e-03_r8, &
     & 4.00287e-03_r8, 3.44513e-03_r8, 2.96510e-03_r8, 2.55196e-03_r8, 2.19638e-03_r8/)
      selfrefo(:, 5) = (/ &
     & 6.71258e-03_r8, 5.95346e-03_r8, 5.28020e-03_r8, 4.68307e-03_r8, 4.15348e-03_r8, &
     & 3.68377e-03_r8, 3.26718e-03_r8, 2.89770e-03_r8, 2.57000e-03_r8, 2.27937e-03_r8/)
      selfrefo(:, 6) = (/ &
     & 6.29140e-03_r8, 5.55557e-03_r8, 4.90580e-03_r8, 4.33203e-03_r8, 3.82536e-03_r8, &
     & 3.37795e-03_r8, 2.98287e-03_r8, 2.63400e-03_r8, 2.32593e-03_r8, 2.05389e-03_r8/)
      selfrefo(:, 7) = (/ &
     & 6.00229e-03_r8, 5.28180e-03_r8, 4.64780e-03_r8, 4.08990e-03_r8, 3.59897e-03_r8, &
     & 3.16696e-03_r8, 2.78682e-03_r8, 2.45230e-03_r8, 2.15794e-03_r8, 1.89891e-03_r8/)
      selfrefo(:, 8) = (/ &
     & 5.78892e-03_r8, 5.07191e-03_r8, 4.44370e-03_r8, 3.89330e-03_r8, 3.41108e-03_r8, &
     & 2.98858e-03_r8, 2.61842e-03_r8, 2.29410e-03_r8, 2.00995e-03_r8, 1.76100e-03_r8/)
      selfrefo(:, 9) = (/ &
     & 4.96186e-03_r8, 4.56767e-03_r8, 4.20480e-03_r8, 3.87076e-03_r8, 3.56325e-03_r8, &
     & 3.28017e-03_r8, 3.01959e-03_r8, 2.77970e-03_r8, 2.55887e-03_r8, 2.35559e-03_r8/)
      selfrefo(:,10) = (/ &
     & 4.56849e-03_r8, 4.35527e-03_r8, 4.15200e-03_r8, 3.95822e-03_r8, 3.77348e-03_r8, &
     & 3.59736e-03_r8, 3.42946e-03_r8, 3.26940e-03_r8, 3.11681e-03_r8, 2.97134e-03_r8/)
      selfrefo(:,11) = (/ &
     & 4.47310e-03_r8, 4.32453e-03_r8, 4.18090e-03_r8, 4.04204e-03_r8, 3.90779e-03_r8, &
     & 3.77799e-03_r8, 3.65251e-03_r8, 3.53120e-03_r8, 3.41392e-03_r8, 3.30053e-03_r8/)
      selfrefo(:,12) = (/ &
     & 4.46459e-03_r8, 4.24031e-03_r8, 4.02730e-03_r8, 3.82499e-03_r8, 3.63284e-03_r8, &
     & 3.45035e-03_r8, 3.27702e-03_r8, 3.11240e-03_r8, 2.95605e-03_r8, 2.80755e-03_r8/)
      selfrefo(:,13) = (/ &
     & 4.43961e-03_r8, 4.35658e-03_r8, 4.27510e-03_r8, 4.19514e-03_r8, 4.11669e-03_r8, &
     & 4.03969e-03_r8, 3.96414e-03_r8, 3.89000e-03_r8, 3.81725e-03_r8, 3.74585e-03_r8/)
      selfrefo(:,14) = (/ &
     & 4.40512e-03_r8, 4.41515e-03_r8, 4.42520e-03_r8, 4.43527e-03_r8, 4.44537e-03_r8, &
     & 4.45549e-03_r8, 4.46563e-03_r8, 4.47580e-03_r8, 4.48599e-03_r8, 4.49620e-03_r8/)
      selfrefo(:,15) = (/ &
     & 3.21965e-03_r8, 3.42479e-03_r8, 3.64300e-03_r8, 3.87512e-03_r8, 4.12202e-03_r8, &
     & 4.38466e-03_r8, 4.66403e-03_r8, 4.96120e-03_r8, 5.27731e-03_r8, 5.61355e-03_r8/)
      selfrefo(:,16) = (/ &
     & 3.11402e-03_r8, 3.35870e-03_r8, 3.62260e-03_r8, 3.90724e-03_r8, 4.21424e-03_r8, &
     & 4.54536e-03_r8, 4.90250e-03_r8, 5.28770e-03_r8, 5.70317e-03_r8, 6.15128e-03_r8/)

      end subroutine lw_kgb13

! **************************************************************************
