!     path:      $Source: /storm/rc1/cvsroot/rc/rrtmg_lw/src/rrtmg_lw_k_g.f90,v $
!     author:    $Author: mike $
!     revision:  $Revision: 1.2 $
!     created:   $Date: 2007/08/22 19:20:03 $
!
!  --------------------------------------------------------------------------
! |                                                                          |
! |  Copyright 2002-2007, Atmospheric & Environmental Research, Inc. (AER).  |
! |  This software may be used, copied, or redistributed as long as it is    |
! |  not sold and this copyright notice is reproduced on each copy made.     |
! |  This model is provided as is without any express or implied warranties. |
! |                       (http://www.rtweb.aer.com/)                        |
! |                                                                          |
!  --------------------------------------------------------------------------

! **************************************************************************
!      subroutine lw_kgbnn
! **************************************************************************
!  RRTM Longwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original version:   E. J. Mlawer, et al.
!  Revision for GCMs:  Michael J. Iacono; October, 2002
!
!  This file contains 16 subroutines that include the 
!  absorption coefficients and other data for each of the 16 longwave
!  spectral bands used in RRTM.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_LW_INIT to reduce
!  the total number of g-points from 256 to 140 for use in the GCM.
! **************************************************************************
! **************************************************************************
      subroutine lw_kgb07
! **************************************************************************

      use shr_kind_mod, only: r8 => shr_kind_r8

!      use parkind, only : jpim, jprb 
      use rrlw_kg07, only : fracrefao, fracrefbo, kao, kbo, kao_mco2, &
                            kbo_mco2, selfrefo, forrefo

      implicit none
      save

! Planck fraction mapping level : P = 706.27 mb, T = 278.94 K
      fracrefao(:, 1) = (/ &
        1.6312e-01_r8,1.4949e-01_r8,1.4305e-01_r8,1.3161e-01_r8,1.1684e-01_r8,9.9900e-02_r8, &
        8.0912e-02_r8,6.0203e-02_r8,4.0149e-02_r8,4.3365e-03_r8,3.5844e-03_r8,2.8019e-03_r8, &
        2.0756e-03_r8,1.3449e-03_r8,5.0492e-04_r8,7.1194e-05_r8/)
      fracrefao(:, 2) = (/ &
        1.6329e-01_r8,1.4989e-01_r8,1.4328e-01_r8,1.3101e-01_r8,1.1691e-01_r8,9.9754e-02_r8, &
        8.0956e-02_r8,5.9912e-02_r8,4.0271e-02_r8,4.3298e-03_r8,3.5626e-03_r8,2.8421e-03_r8, &
        2.1031e-03_r8,1.3360e-03_r8,4.8965e-04_r8,6.8900e-05_r8/)
      fracrefao(:, 3) = (/ &
        1.6236e-01_r8,1.5081e-01_r8,1.4341e-01_r8,1.3083e-01_r8,1.1684e-01_r8,9.9701e-02_r8, &
        8.0956e-02_r8,5.9884e-02_r8,4.0245e-02_r8,4.3837e-03_r8,3.6683e-03_r8,2.9250e-03_r8, &
        2.0969e-03_r8,1.3320e-03_r8,4.8965e-04_r8,6.8900e-05_r8/)
      fracrefao(:, 4) = (/ &
        1.6096e-01_r8,1.5183e-01_r8,1.4354e-01_r8,1.3081e-01_r8,1.1687e-01_r8,9.9619e-02_r8, &
        8.0947e-02_r8,5.9899e-02_r8,4.0416e-02_r8,4.4389e-03_r8,3.7280e-03_r8,2.9548e-03_r8, &
        2.0977e-03_r8,1.3305e-03_r8,4.8965e-04_r8,6.8900e-05_r8/)
      fracrefao(:, 5) = (/ &
        1.5661e-01_r8,1.5478e-01_r8,1.4414e-01_r8,1.3097e-01_r8,1.1695e-01_r8,9.9823e-02_r8, &
        8.0750e-02_r8,6.0100e-02_r8,4.0741e-02_r8,4.4598e-03_r8,3.7366e-03_r8,2.9521e-03_r8, &
        2.0980e-03_r8,1.3297e-03_r8,4.8965e-04_r8,6.8900e-05_r8/)
      fracrefao(:, 6) = (/ &
        1.4879e-01_r8,1.5853e-01_r8,1.4586e-01_r8,1.3162e-01_r8,1.1729e-01_r8,1.0031e-01_r8, &
        8.0908e-02_r8,6.0460e-02_r8,4.1100e-02_r8,4.4578e-03_r8,3.7388e-03_r8,2.9508e-03_r8, &
        2.0986e-03_r8,1.3288e-03_r8,4.8965e-04_r8,6.8900e-05_r8/)
      fracrefao(:, 7) = (/ &
        1.4117e-01_r8,1.4838e-01_r8,1.4807e-01_r8,1.3759e-01_r8,1.2218e-01_r8,1.0228e-01_r8, &
        8.2130e-02_r8,6.1546e-02_r8,4.1522e-02_r8,4.4577e-03_r8,3.7428e-03_r8,2.9475e-03_r8, &
        2.0997e-03_r8,1.3277e-03_r8,4.8965e-04_r8,6.8900e-05_r8/)
      fracrefao(:, 8) = (/ &
        1.4018e-01_r8,1.4207e-01_r8,1.3919e-01_r8,1.3332e-01_r8,1.2325e-01_r8,1.0915e-01_r8, &
        9.0280e-02_r8,6.5554e-02_r8,4.1852e-02_r8,4.4707e-03_r8,3.7572e-03_r8,2.9364e-03_r8, &
        2.1023e-03_r8,1.3249e-03_r8,4.8965e-04_r8,6.8900e-05_r8/)
      fracrefao(:, 9) = (/ &
        1.4863e-01_r8,1.4926e-01_r8,1.4740e-01_r8,1.3558e-01_r8,1.1999e-01_r8,1.0044e-01_r8, &
        8.1927e-02_r8,6.0989e-02_r8,4.0665e-02_r8,4.4481e-03_r8,3.7369e-03_r8,2.9482e-03_r8, &
        2.0976e-03_r8,1.3281e-03_r8,4.8965e-04_r8,6.8900e-05_r8/)

! Planck fraction mapping level : P=95.58 mbar, T= 215.70 K
      fracrefbo(:) = (/ &
        1.5872e-01_r8,1.5443e-01_r8,1.4413e-01_r8,1.3147e-01_r8,1.1634e-01_r8,9.8914e-02_r8, &
        8.0236e-02_r8,6.0197e-02_r8,4.0624e-02_r8,4.4225e-03_r8,3.6688e-03_r8,2.9074e-03_r8, &
        2.0862e-03_r8,1.3039e-03_r8,4.8561e-04_r8,6.8854e-05_r8/)

!     The array KAO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels > ~100mb, temperatures, and ratios
!     of water vapor to CO2.  The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amount ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 
!     to that of gas2.
!     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
!     to different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this  pressure 
!     level, JT = 2 refers to the temperature
!     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the reference pressure level (e.g. JP = 1 is for a
!     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

      kao(:, 1, 1, 1) = (/ &
     &2.0715e-06_r8,2.0394e-06_r8,5.0240e-06_r8,1.0614e-05_r8,1.1983e-05_r8,1.5554e-05_r8, &
     &1.7831e-05_r8,2.6227e-05_r8,1.2374e-05_r8/)
      kao(:, 2, 1, 1) = (/ &
     &2.6968e-06_r8,2.7207e-06_r8,3.6723e-06_r8,1.1698e-05_r8,1.3601e-05_r8,1.5350e-05_r8, &
     &2.0818e-05_r8,2.8393e-05_r8,1.1509e-05_r8/)
      kao(:, 3, 1, 1) = (/ &
     &3.4058e-06_r8,3.5757e-06_r8,3.8081e-06_r8,7.3554e-06_r8,1.4372e-05_r8,1.6368e-05_r8, &
     &1.9019e-05_r8,3.0058e-05_r8,1.1256e-05_r8/)
      kao(:, 4, 1, 1) = (/ &
     &4.2245e-06_r8,4.8570e-06_r8,4.7347e-06_r8,6.0087e-06_r8,1.4347e-05_r8,1.6902e-05_r8, &
     &1.9725e-05_r8,2.9609e-05_r8,1.0323e-05_r8/)
      kao(:, 5, 1, 1) = (/ &
     &5.1348e-06_r8,6.1189e-06_r8,5.9979e-06_r8,6.4031e-06_r8,9.6268e-06_r8,1.7276e-05_r8, &
     &1.9533e-05_r8,2.5577e-05_r8,1.1200e-05_r8/)
      kao(:, 1, 2, 1) = (/ &
     &2.7400e-06_r8,2.6398e-06_r8,3.5715e-06_r8,8.9653e-06_r8,1.1704e-05_r8,1.2732e-05_r8, &
     &1.5109e-05_r8,1.8326e-05_r8,7.6584e-06_r8/)
      kao(:, 2, 2, 1) = (/ &
     &3.7023e-06_r8,3.5996e-06_r8,3.5466e-06_r8,6.4138e-06_r8,1.4301e-05_r8,1.4484e-05_r8, &
     &1.7298e-05_r8,2.1003e-05_r8,7.8450e-06_r8/)
      kao(:, 3, 2, 1) = (/ &
     &4.8529e-06_r8,4.7902e-06_r8,4.4795e-06_r8,5.2052e-06_r8,1.0079e-05_r8,1.6425e-05_r8, &
     &1.7110e-05_r8,2.3533e-05_r8,8.0830e-06_r8/)
      kao(:, 4, 2, 1) = (/ &
     &6.0952e-06_r8,6.1266e-06_r8,5.7794e-06_r8,5.6603e-06_r8,7.5131e-06_r8,1.6775e-05_r8, &
     &1.7862e-05_r8,2.1237e-05_r8,6.9720e-06_r8/)
      kao(:, 5, 2, 1) = (/ &
     &7.4621e-06_r8,7.9816e-06_r8,7.3755e-06_r8,7.0507e-06_r8,7.2782e-06_r8,1.2172e-05_r8, &
     &1.8558e-05_r8,2.1490e-05_r8,7.0903e-06_r8/)
      kao(:, 1, 3, 1) = (/ &
     &4.8603e-06_r8,4.7726e-06_r8,4.1802e-06_r8,5.2554e-06_r8,9.0303e-06_r8,1.4041e-05_r8, &
     &1.3465e-05_r8,1.4273e-05_r8,4.5115e-06_r8/)
      kao(:, 2, 3, 1) = (/ &
     &6.5045e-06_r8,6.5033e-06_r8,5.8343e-06_r8,5.3408e-06_r8,7.3167e-06_r8,1.4520e-05_r8, &
     &1.5602e-05_r8,1.7982e-05_r8,4.5301e-06_r8/)
      kao(:, 3, 3, 1) = (/ &
     &8.5550e-06_r8,8.5301e-06_r8,7.7170e-06_r8,6.8750e-06_r8,6.6921e-06_r8,1.0610e-05_r8, &
     &1.8653e-05_r8,1.7976e-05_r8,3.9894e-06_r8/)
      kao(:, 4, 3, 1) = (/ &
     &1.0940e-05_r8,1.0943e-05_r8,9.9861e-06_r8,8.8481e-06_r8,7.8291e-06_r8,8.3918e-06_r8, &
     &1.7829e-05_r8,1.8992e-05_r8,3.8512e-06_r8/)
      kao(:, 5, 3, 1) = (/ &
     &1.3936e-05_r8,1.3811e-05_r8,1.2489e-05_r8,1.1153e-05_r8,9.8326e-06_r8,8.7685e-06_r8, &
     &1.2193e-05_r8,1.9703e-05_r8,4.2059e-06_r8/)
      kao(:, 1, 4, 1) = (/ &
     &8.9960e-06_r8,8.6210e-06_r8,7.6632e-06_r8,6.4630e-06_r8,6.4239e-06_r8,9.4367e-06_r8, &
     &1.6258e-05_r8,1.3756e-05_r8,2.4163e-06_r8/)
      kao(:, 2, 4, 1) = (/ &
     &1.2134e-05_r8,1.1807e-05_r8,1.0673e-05_r8,9.1029e-06_r8,7.7016e-06_r8,8.4861e-06_r8, &
     &1.4567e-05_r8,1.5036e-05_r8,2.1658e-06_r8/)
      kao(:, 3, 4, 1) = (/ &
     &1.6015e-05_r8,1.5688e-05_r8,1.4339e-05_r8,1.2455e-05_r8,1.0313e-05_r8,8.5777e-06_r8, &
     &1.1331e-05_r8,1.8116e-05_r8,2.2633e-06_r8/)
      kao(:, 4, 4, 1) = (/ &
     &2.0597e-05_r8,2.0155e-05_r8,1.8480e-05_r8,1.6165e-05_r8,1.3589e-05_r8,1.0837e-05_r8, &
     &9.4849e-06_r8,2.1131e-05_r8,2.4289e-06_r8/)
      kao(:, 5, 4, 1) = (/ &
     &2.5729e-05_r8,2.5473e-05_r8,2.3255e-05_r8,2.0429e-05_r8,1.7213e-05_r8,1.3828e-05_r8, &
     &1.0618e-05_r8,1.5874e-05_r8,3.2874e-06_r8/)
      kao(:, 1, 5, 1) = (/ &
     &1.6376e-05_r8,1.4981e-05_r8,1.3148e-05_r8,1.1171e-05_r8,9.2339e-06_r8,7.8648e-06_r8, &
     &1.1215e-05_r8,1.5160e-05_r8,1.0907e-06_r8/)
      kao(:, 2, 5, 1) = (/ &
     &2.2074e-05_r8,2.0407e-05_r8,1.8083e-05_r8,1.5475e-05_r8,1.2746e-05_r8,1.0050e-05_r8, &
     &1.0049e-05_r8,1.8902e-05_r8,1.3007e-06_r8/)
      kao(:, 3, 5, 1) = (/ &
     &2.9048e-05_r8,2.7094e-05_r8,2.4278e-05_r8,2.1033e-05_r8,1.7417e-05_r8,1.3618e-05_r8, &
     &1.0309e-05_r8,1.5056e-05_r8,1.4150e-06_r8/)
      kao(:, 4, 5, 1) = (/ &
     &3.7623e-05_r8,3.5233e-05_r8,3.1800e-05_r8,2.7623e-05_r8,2.3164e-05_r8,1.8269e-05_r8, &
     &1.3014e-05_r8,1.1951e-05_r8,2.0520e-06_r8/)
      kao(:, 5, 5, 1) = (/ &
     &4.7365e-05_r8,4.4556e-05_r8,4.0255e-05_r8,3.5279e-05_r8,2.9803e-05_r8,2.3695e-05_r8, &
     &1.6824e-05_r8,1.0864e-05_r8,3.0931e-06_r8/)
      kao(:, 1, 6, 1) = (/ &
     &2.9059e-05_r8,2.6117e-05_r8,2.2727e-05_r8,1.9184e-05_r8,1.5516e-05_r8,1.1998e-05_r8, &
     &9.5851e-06_r8,1.6016e-05_r8,6.6366e-07_r8/)
      kao(:, 2, 6, 1) = (/ &
     &3.9281e-05_r8,3.5568e-05_r8,3.1182e-05_r8,2.6432e-05_r8,2.1505e-05_r8,1.6402e-05_r8, &
     &1.1717e-05_r8,1.2828e-05_r8,7.2868e-07_r8/)
      kao(:, 3, 6, 1) = (/ &
     &5.2094e-05_r8,4.7264e-05_r8,4.1432e-05_r8,3.5398e-05_r8,2.9041e-05_r8,2.2416e-05_r8, &
     &1.5568e-05_r8,1.1439e-05_r8,1.0703e-06_r8/)
      kao(:, 4, 6, 1) = (/ &
     &6.7466e-05_r8,6.1301e-05_r8,5.3945e-05_r8,4.6275e-05_r8,3.8268e-05_r8,2.9782e-05_r8, &
     &2.0926e-05_r8,1.2149e-05_r8,1.6636e-06_r8/)
      kao(:, 5, 6, 1) = (/ &
     &8.5711e-05_r8,7.8253e-05_r8,6.9113e-05_r8,5.9588e-05_r8,4.9429e-05_r8,3.8720e-05_r8, &
     &2.7357e-05_r8,1.5302e-05_r8,2.4859e-06_r8/)
      kao(:, 1, 7, 1) = (/ &
     &5.4651e-05_r8,4.8396e-05_r8,4.1917e-05_r8,3.5300e-05_r8,2.8526e-05_r8,2.1678e-05_r8, &
     &1.5027e-05_r8,1.1124e-05_r8,3.7210e-07_r8/)
      kao(:, 2, 7, 1) = (/ &
     &7.4826e-05_r8,6.6392e-05_r8,5.7621e-05_r8,4.8629e-05_r8,3.9371e-05_r8,2.9959e-05_r8, &
     &2.0404e-05_r8,1.1926e-05_r8,4.6517e-07_r8/)
      kao(:, 3, 7, 1) = (/ &
     &9.9886e-05_r8,8.9008e-05_r8,7.7375e-05_r8,6.5427e-05_r8,5.3175e-05_r8,4.0667e-05_r8, &
     &2.7777e-05_r8,1.4838e-05_r8,7.6733e-07_r8/)
      kao(:, 4, 7, 1) = (/ &
     &1.3028e-04_r8,1.1642e-04_r8,1.0145e-04_r8,8.5974e-05_r8,7.0058e-05_r8,5.3698e-05_r8, &
     &3.6993e-05_r8,1.9660e-05_r8,1.2756e-06_r8/)
      kao(:, 5, 7, 1) = (/ &
     &1.6675e-04_r8,1.4925e-04_r8,1.3030e-04_r8,1.1056e-04_r8,9.0256e-05_r8,6.9412e-05_r8, &
     &4.8077e-05_r8,2.5971e-05_r8,2.0598e-06_r8/)
      kao(:, 1, 8, 1) = (/ &
     &1.3360e-04_r8,1.1739e-04_r8,1.0102e-04_r8,8.4552e-05_r8,6.8007e-05_r8,5.1398e-05_r8, &
     &3.4619e-05_r8,1.8035e-05_r8,1.9024e-07_r8/)
      kao(:, 2, 8, 1) = (/ &
     &1.8185e-04_r8,1.6006e-04_r8,1.3792e-04_r8,1.1564e-04_r8,9.3245e-05_r8,7.0615e-05_r8, &
     &4.7676e-05_r8,2.4529e-05_r8,3.0949e-07_r8/)
      kao(:, 3, 8, 1) = (/ &
     &2.4405e-04_r8,2.1504e-04_r8,1.8547e-04_r8,1.5570e-04_r8,1.2559e-04_r8,9.5220e-05_r8, &
     &6.4517e-05_r8,3.3270e-05_r8,5.6654e-07_r8/)
      kao(:, 4, 8, 1) = (/ &
     &3.2056e-04_r8,2.8296e-04_r8,2.4441e-04_r8,2.0538e-04_r8,1.6592e-04_r8,1.2607e-04_r8, &
     &8.5723e-05_r8,4.4370e-05_r8,1.0126e-06_r8/)
      kao(:, 5, 8, 1) = (/ &
     &4.1126e-04_r8,3.6352e-04_r8,3.1426e-04_r8,2.6419e-04_r8,2.1364e-04_r8,1.6265e-04_r8, &
     &1.1079e-04_r8,5.7674e-05_r8,1.7042e-06_r8/)
      kao(:, 1, 9, 1) = (/ &
     &6.2463e-04_r8,5.4698e-04_r8,4.6923e-04_r8,3.9140e-04_r8,3.1352e-04_r8,2.3558e-04_r8, &
     &1.5756e-04_r8,7.9405e-05_r8,1.4148e-07_r8/)
      kao(:, 2, 9, 1) = (/ &
     &8.5834e-04_r8,7.5200e-04_r8,6.4533e-04_r8,5.3850e-04_r8,4.3155e-04_r8,3.2449e-04_r8, &
     &2.1732e-04_r8,1.0986e-04_r8,2.9809e-07_r8/)
      kao(:, 3, 9, 1) = (/ &
     &1.1576e-03_r8,1.0147e-03_r8,8.7098e-04_r8,7.2712e-04_r8,5.8298e-04_r8,4.3871e-04_r8, &
     &2.9418e-04_r8,1.4894e-04_r8,5.9602e-07_r8/)
      kao(:, 4, 9, 1) = (/ &
     &1.5307e-03_r8,1.3423e-03_r8,1.1527e-03_r8,9.6254e-04_r8,7.7214e-04_r8,5.8148e-04_r8, &
     &3.9028e-04_r8,1.9773e-04_r8,1.1255e-06_r8/)
      kao(:, 5, 9, 1) = (/ &
     &1.9847e-03_r8,1.7410e-03_r8,1.4953e-03_r8,1.2490e-03_r8,1.0025e-03_r8,7.5537e-04_r8, &
     &5.0679e-04_r8,2.5732e-04_r8,1.9162e-06_r8/)
      kao(:, 1,10, 1) = (/ &
     &3.6169e-03_r8,3.1652e-03_r8,2.7133e-03_r8,2.2615e-03_r8,1.8097e-03_r8,1.3577e-03_r8, &
     &9.0574e-04_r8,4.5358e-04_r8,1.4845e-07_r8/)
      kao(:, 2,10, 1) = (/ &
     &4.9699e-03_r8,4.3495e-03_r8,3.7290e-03_r8,3.1084e-03_r8,2.4876e-03_r8,1.8667e-03_r8, &
     &1.2456e-03_r8,6.2420e-04_r8,3.2434e-07_r8/)
      kao(:, 3,10, 1) = (/ &
     &6.7347e-03_r8,5.8945e-03_r8,5.0543e-03_r8,4.2138e-03_r8,3.3728e-03_r8,2.5314e-03_r8, &
     &1.6895e-03_r8,8.4729e-04_r8,6.8830e-07_r8/)
      kao(:, 4,10, 1) = (/ &
     &8.9371e-03_r8,7.8231e-03_r8,6.7088e-03_r8,5.5938e-03_r8,4.4779e-03_r8,3.3612e-03_r8, &
     &2.2441e-03_r8,1.1262e-03_r8,1.3449e-06_r8/)
      kao(:, 5,10, 1) = (/ &
     &1.1613e-02_r8,1.0166e-02_r8,8.7190e-03_r8,7.2700e-03_r8,5.8199e-03_r8,4.3690e-03_r8, &
     &2.9176e-03_r8,1.4653e-03_r8,2.4729e-06_r8/)
      kao(:, 1,11, 1) = (/ &
     &8.2249e-03_r8,7.1970e-03_r8,6.1693e-03_r8,5.1415e-03_r8,4.1138e-03_r8,3.0859e-03_r8, &
     &2.0579e-03_r8,1.0298e-03_r8,1.4864e-07_r8/)
      kao(:, 2,11, 1) = (/ &
     &1.1270e-02_r8,9.8625e-03_r8,8.4545e-03_r8,7.0466e-03_r8,5.6386e-03_r8,4.2301e-03_r8, &
     &2.8215e-03_r8,1.4124e-03_r8,3.4574e-07_r8/)
      kao(:, 3,11, 1) = (/ &
     &1.5223e-02_r8,1.3322e-02_r8,1.1421e-02_r8,9.5200e-03_r8,7.6187e-03_r8,5.7167e-03_r8, &
     &3.8140e-03_r8,1.9100e-03_r8,7.2590e-07_r8/)
      kao(:, 4,11, 1) = (/ &
     &2.0093e-02_r8,1.7585e-02_r8,1.5077e-02_r8,1.2568e-02_r8,1.0059e-02_r8,7.5477e-03_r8, &
     &5.0358e-03_r8,2.5228e-03_r8,1.4168e-06_r8/)
      kao(:, 5,11, 1) = (/ &
     &2.5957e-02_r8,2.2717e-02_r8,1.9478e-02_r8,1.6238e-02_r8,1.2998e-02_r8,9.7533e-03_r8, &
     &6.5080e-03_r8,3.2606e-03_r8,2.6860e-06_r8/)
      kao(:, 1,12, 1) = (/ &
     &1.1827e-02_r8,1.0349e-02_r8,8.8708e-03_r8,7.3929e-03_r8,5.9148e-03_r8,4.4367e-03_r8, &
     &2.9587e-03_r8,1.4802e-03_r8,1.3931e-07_r8/)
      kao(:, 2,12, 1) = (/ &
     &1.6211e-02_r8,1.4185e-02_r8,1.2160e-02_r8,1.0134e-02_r8,8.1087e-03_r8,6.0831e-03_r8, &
     &4.0569e-03_r8,2.0301e-03_r8,3.2171e-07_r8/)
      kao(:, 3,12, 1) = (/ &
     &2.1828e-02_r8,1.9101e-02_r8,1.6374e-02_r8,1.3648e-02_r8,1.0921e-02_r8,8.1937e-03_r8, &
     &5.4651e-03_r8,2.7355e-03_r8,6.8081e-07_r8/)
      kao(:, 4,12, 1) = (/ &
     &2.8730e-02_r8,2.5142e-02_r8,2.1554e-02_r8,1.7967e-02_r8,1.4379e-02_r8,1.0788e-02_r8, &
     &7.1961e-03_r8,3.6027e-03_r8,1.3459e-06_r8/)
      kao(:, 5,12, 1) = (/ &
     &3.6999e-02_r8,3.2380e-02_r8,2.7760e-02_r8,2.3140e-02_r8,1.8520e-02_r8,1.3896e-02_r8, &
     &9.2700e-03_r8,4.6424e-03_r8,2.5690e-06_r8/)
      kao(:, 1,13, 1) = (/ &
     &1.3632e-02_r8,1.1928e-02_r8,1.0225e-02_r8,8.5212e-03_r8,6.8176e-03_r8,5.1139e-03_r8, &
     &3.4100e-03_r8,1.7059e-03_r8,1.1695e-07_r8/)
      kao(:, 2,13, 1) = (/ &
     &1.8706e-02_r8,1.6369e-02_r8,1.4031e-02_r8,1.1694e-02_r8,9.3569e-03_r8,7.0195e-03_r8, &
     &4.6811e-03_r8,2.3422e-03_r8,2.7119e-07_r8/)
      kao(:, 3,13, 1) = (/ &
     &2.5132e-02_r8,2.1993e-02_r8,1.8852e-02_r8,1.5713e-02_r8,1.2573e-02_r8,9.4331e-03_r8, &
     &6.2911e-03_r8,3.1482e-03_r8,5.7144e-07_r8/)
      kao(:, 4,13, 1) = (/ &
     &3.3041e-02_r8,2.8914e-02_r8,2.4787e-02_r8,2.0660e-02_r8,1.6533e-02_r8,1.2406e-02_r8, &
     &8.2739e-03_r8,4.1414e-03_r8,1.1335e-06_r8/)
      kao(:, 5,13, 1) = (/ &
     &4.2440e-02_r8,3.7140e-02_r8,3.1841e-02_r8,2.6541e-02_r8,2.1241e-02_r8,1.5937e-02_r8, &
     &1.0630e-02_r8,5.3218e-03_r8,2.1676e-06_r8/)
      kao(:, 1, 1, 2) = (/ &
     &4.1413e-06_r8,5.7568e-06_r8,5.6875e-06_r8,2.2265e-05_r8,2.6421e-05_r8,2.7053e-05_r8, &
     &2.9360e-05_r8,4.0970e-05_r8,1.4958e-05_r8/)
      kao(:, 2, 1, 2) = (/ &
     &5.1991e-06_r8,7.4465e-06_r8,7.4944e-06_r8,1.1514e-05_r8,2.6560e-05_r8,2.7448e-05_r8, &
     &2.9314e-05_r8,3.8310e-05_r8,1.7668e-05_r8/)
      kao(:, 3, 1, 2) = (/ &
     &6.3145e-06_r8,9.3150e-06_r8,9.9659e-06_r8,1.0415e-05_r8,2.4448e-05_r8,2.8503e-05_r8, &
     &3.1282e-05_r8,4.1769e-05_r8,1.5395e-05_r8/)
      kao(:, 4, 1, 2) = (/ &
     &7.5825e-06_r8,1.1197e-05_r8,1.2631e-05_r8,1.2849e-05_r8,1.2505e-05_r8,2.7705e-05_r8, &
     &3.1429e-05_r8,4.1459e-05_r8,1.9577e-05_r8/)
      kao(:, 5, 1, 2) = (/ &
     &9.0691e-06_r8,1.3548e-05_r8,1.5444e-05_r8,1.5939e-05_r8,1.4634e-05_r8,2.1478e-05_r8, &
     &3.0373e-05_r8,4.6504e-05_r8,1.5074e-05_r8/)
      kao(:, 1, 2, 2) = (/ &
     &6.1165e-06_r8,7.4934e-06_r8,6.8625e-06_r8,7.6121e-06_r8,3.0817e-05_r8,3.2183e-05_r8, &
     &3.0483e-05_r8,3.3496e-05_r8,1.0690e-05_r8/)
      kao(:, 2, 2, 2) = (/ &
     &7.6538e-06_r8,9.6280e-06_r8,9.7301e-06_r8,8.1097e-06_r8,1.6826e-05_r8,3.2430e-05_r8, &
     &3.0532e-05_r8,3.1851e-05_r8,9.7120e-06_r8/)
      kao(:, 3, 2, 2) = (/ &
     &9.2709e-06_r8,1.2057e-05_r8,1.2568e-05_r8,1.1762e-05_r8,1.2621e-05_r8,3.1032e-05_r8, &
     &3.2269e-05_r8,3.2750e-05_r8,1.1309e-05_r8/)
      kao(:, 4, 2, 2) = (/ &
     &1.1033e-05_r8,1.5040e-05_r8,1.5728e-05_r8,1.5466e-05_r8,1.4259e-05_r8,1.7169e-05_r8, &
     &3.1754e-05_r8,3.4497e-05_r8,1.2084e-05_r8/)
      kao(:, 5, 2, 2) = (/ &
     &1.2896e-05_r8,1.7847e-05_r8,1.9251e-05_r8,1.9193e-05_r8,1.8160e-05_r8,1.5443e-05_r8, &
     &2.9856e-05_r8,3.4316e-05_r8,1.0107e-05_r8/)
      kao(:, 1, 3, 2) = (/ &
     &1.2491e-05_r8,1.2769e-05_r8,1.2392e-05_r8,1.0198e-05_r8,9.0495e-06_r8,2.4479e-05_r8, &
     &4.2929e-05_r8,3.4687e-05_r8,5.7323e-06_r8/)
      kao(:, 2, 3, 2) = (/ &
     &1.5715e-05_r8,1.6378e-05_r8,1.5890e-05_r8,1.4699e-05_r8,1.1686e-05_r8,1.2801e-05_r8, &
     &4.3476e-05_r8,3.5317e-05_r8,5.8828e-06_r8/)
      kao(:, 3, 3, 2) = (/ &
     &1.9226e-05_r8,2.0527e-05_r8,2.0237e-05_r8,1.8901e-05_r8,1.6806e-05_r8,1.2767e-05_r8, &
     &3.2801e-05_r8,3.5650e-05_r8,7.0460e-06_r8/)
      kao(:, 4, 3, 2) = (/ &
     &2.3182e-05_r8,2.5284e-05_r8,2.5183e-05_r8,2.3943e-05_r8,2.1697e-05_r8,1.8156e-05_r8, &
     &1.6231e-05_r8,3.6132e-05_r8,6.5848e-06_r8/)
      kao(:, 5, 3, 2) = (/ &
     &2.7146e-05_r8,3.0591e-05_r8,3.0801e-05_r8,2.9528e-05_r8,2.6930e-05_r8,2.3450e-05_r8, &
     &1.7771e-05_r8,3.6010e-05_r8,8.7258e-06_r8/)
      kao(:, 1, 4, 2) = (/ &
     &2.6397e-05_r8,2.4798e-05_r8,2.2448e-05_r8,1.9931e-05_r8,1.6167e-05_r8,1.1187e-05_r8, &
     &1.9967e-05_r8,5.0094e-05_r8,2.6889e-06_r8/)
      kao(:, 2, 4, 2) = (/ &
     &3.3110e-05_r8,3.1403e-05_r8,2.8621e-05_r8,2.5685e-05_r8,2.2077e-05_r8,1.6320e-05_r8, &
     &1.2528e-05_r8,5.0766e-05_r8,3.5011e-06_r8/)
      kao(:, 3, 4, 2) = (/ &
     &4.1079e-05_r8,3.9262e-05_r8,3.5800e-05_r8,3.2065e-05_r8,2.7986e-05_r8,2.3135e-05_r8, &
     &1.5357e-05_r8,4.2293e-05_r8,3.6570e-06_r8/)
      kao(:, 4, 4, 2) = (/ &
     &4.9814e-05_r8,4.8178e-05_r8,4.4142e-05_r8,4.0008e-05_r8,3.5086e-05_r8,2.9575e-05_r8, &
     &2.2305e-05_r8,2.4338e-05_r8,5.5271e-06_r8/)
      kao(:, 5, 4, 2) = (/ &
     &5.8999e-05_r8,5.7911e-05_r8,5.3941e-05_r8,4.9131e-05_r8,4.3508e-05_r8,3.6745e-05_r8, &
     &2.8595e-05_r8,1.7749e-05_r8,7.9465e-06_r8/)
      kao(:, 1, 5, 2) = (/ &
     &5.2146e-05_r8,4.7415e-05_r8,4.1895e-05_r8,3.6100e-05_r8,2.9831e-05_r8,2.2853e-05_r8, &
     &1.2797e-05_r8,3.5615e-05_r8,1.8756e-06_r8/)
      kao(:, 2, 5, 2) = (/ &
     &6.6386e-05_r8,6.0667e-05_r8,5.3871e-05_r8,4.6587e-05_r8,3.8801e-05_r8,3.0645e-05_r8, &
     &1.9749e-05_r8,1.7747e-05_r8,1.8651e-06_r8/)
      kao(:, 3, 5, 2) = (/ &
     &8.2249e-05_r8,7.5613e-05_r8,6.7372e-05_r8,5.8338e-05_r8,4.8872e-05_r8,3.9037e-05_r8, &
     &2.7917e-05_r8,1.3785e-05_r8,2.9415e-06_r8/)
      kao(:, 4, 5, 2) = (/ &
     &1.0042e-04_r8,9.2832e-05_r8,8.2527e-05_r8,7.1569e-05_r8,6.0116e-05_r8,4.8290e-05_r8, &
     &3.5743e-05_r8,1.9373e-05_r8,4.5717e-06_r8/)
      kao(:, 5, 5, 2) = (/ &
     &1.2062e-04_r8,1.1245e-04_r8,1.0036e-04_r8,8.7051e-05_r8,7.3237e-05_r8,5.8949e-05_r8, &
     &4.4093e-05_r8,2.6901e-05_r8,6.6085e-06_r8/)
      kao(:, 1, 6, 2) = (/ &
     &9.7868e-05_r8,8.7352e-05_r8,7.6231e-05_r8,6.4624e-05_r8,5.2909e-05_r8,4.0689e-05_r8, &
     &2.7103e-05_r8,1.2458e-05_r8,1.0529e-06_r8/)
      kao(:, 2, 6, 2) = (/ &
     &1.2683e-04_r8,1.1378e-04_r8,9.9028e-05_r8,8.4157e-05_r8,6.8945e-05_r8,5.3462e-05_r8, &
     &3.6917e-05_r8,1.5991e-05_r8,1.3630e-06_r8/)
      kao(:, 3, 6, 2) = (/ &
     &1.5959e-04_r8,1.4323e-04_r8,1.2528e-04_r8,1.0669e-04_r8,8.7707e-05_r8,6.8030e-05_r8, &
     &4.7823e-05_r8,2.4263e-05_r8,2.3097e-06_r8/)
      kao(:, 4, 6, 2) = (/ &
     &1.9648e-04_r8,1.7730e-04_r8,1.5536e-04_r8,1.3239e-04_r8,1.0876e-04_r8,8.4595e-05_r8, &
     &5.9848e-05_r8,3.3068e-05_r8,3.7113e-06_r8/)
      kao(:, 5, 6, 2) = (/ &
     &2.3620e-04_r8,2.1365e-04_r8,1.8738e-04_r8,1.5973e-04_r8,1.3145e-04_r8,1.0268e-04_r8, &
     &7.2957e-05_r8,4.1703e-05_r8,5.6387e-06_r8/)
      kao(:, 1, 7, 2) = (/ &
     &1.9683e-04_r8,1.7373e-04_r8,1.5000e-04_r8,1.2604e-04_r8,1.0197e-04_r8,7.7797e-05_r8, &
     &5.2829e-05_r8,2.4870e-05_r8,6.2713e-07_r8/)
      kao(:, 2, 7, 2) = (/ &
     &2.5760e-04_r8,2.2793e-04_r8,1.9707e-04_r8,1.6593e-04_r8,1.3495e-04_r8,1.0291e-04_r8, &
     &7.0455e-05_r8,3.6046e-05_r8,1.0898e-06_r8/)
      kao(:, 3, 7, 2) = (/ &
     &3.2772e-04_r8,2.9045e-04_r8,2.5191e-04_r8,2.1251e-04_r8,1.7232e-04_r8,1.3160e-04_r8, &
     &9.0425e-05_r8,4.7870e-05_r8,1.9368e-06_r8/)
      kao(:, 4, 7, 2) = (/ &
     &4.0755e-04_r8,3.6253e-04_r8,3.1479e-04_r8,2.6553e-04_r8,2.1537e-04_r8,1.6486e-04_r8, &
     &1.1337e-04_r8,6.0602e-05_r8,3.1700e-06_r8/)
      kao(:, 5, 7, 2) = (/ &
     &4.9614e-04_r8,4.4343e-04_r8,3.8479e-04_r8,3.2448e-04_r8,2.6368e-04_r8,2.0203e-04_r8, &
     &1.3939e-04_r8,7.4791e-05_r8,4.9446e-06_r8/)
      kao(:, 1, 8, 2) = (/ &
     &5.0097e-04_r8,4.3939e-04_r8,3.7796e-04_r8,3.1605e-04_r8,2.5384e-04_r8,1.9144e-04_r8, &
     &1.2886e-04_r8,6.5770e-05_r8,4.5473e-07_r8/)
      kao(:, 2, 8, 2) = (/ &
     &6.6297e-04_r8,5.8193e-04_r8,5.0094e-04_r8,4.1901e-04_r8,3.3675e-04_r8,2.5431e-04_r8, &
     &1.7173e-04_r8,8.8413e-05_r8,9.2809e-07_r8/)
      kao(:, 3, 8, 2) = (/ &
     &8.5051e-04_r8,7.4751e-04_r8,6.4368e-04_r8,5.3885e-04_r8,4.3363e-04_r8,3.2808e-04_r8, &
     &2.2228e-04_r8,1.1512e-04_r8,1.7364e-06_r8/)
      kao(:, 4, 8, 2) = (/ &
     &1.0693e-03_r8,9.4111e-04_r8,8.1096e-04_r8,6.7960e-04_r8,5.4760e-04_r8,4.1579e-04_r8, &
     &2.8187e-04_r8,1.4563e-04_r8,2.9681e-06_r8/)
      kao(:, 5, 8, 2) = (/ &
     &1.3123e-03_r8,1.1563e-03_r8,9.9722e-04_r8,8.3695e-04_r8,6.7599e-04_r8,5.1257e-04_r8, &
     &3.4753e-04_r8,1.7994e-04_r8,4.7447e-06_r8/)
      kao(:, 1, 9, 2) = (/ &
     &2.4740e-03_r8,2.1654e-03_r8,1.8568e-03_r8,1.5484e-03_r8,1.2400e-03_r8,9.3161e-04_r8, &
     &6.2283e-04_r8,3.1298e-04_r8,4.6685e-07_r8/)
      kao(:, 2, 9, 2) = (/ &
     &3.2850e-03_r8,2.8753e-03_r8,2.4661e-03_r8,2.0570e-03_r8,1.6482e-03_r8,1.2389e-03_r8, &
     &8.2844e-04_r8,4.1698e-04_r8,9.7197e-07_r8/)
      kao(:, 3, 9, 2) = (/ &
     &4.2422e-03_r8,3.7138e-03_r8,3.1860e-03_r8,2.6588e-03_r8,2.1312e-03_r8,1.6022e-03_r8, &
     &1.0719e-03_r8,5.4052e-04_r8,1.8767e-06_r8/)
      kao(:, 4, 9, 2) = (/ &
     &5.3553e-03_r8,4.6891e-03_r8,4.0243e-03_r8,3.3598e-03_r8,2.6939e-03_r8,2.0261e-03_r8, &
     &1.3568e-03_r8,6.8626e-04_r8,3.3456e-06_r8/)
      kao(:, 5, 9, 2) = (/ &
     &6.6220e-03_r8,5.7995e-03_r8,4.9792e-03_r8,4.1587e-03_r8,3.3345e-03_r8,2.5085e-03_r8, &
     &1.6821e-03_r8,8.5317e-04_r8,5.6245e-06_r8/)
      kao(:, 1,10, 2) = (/ &
     &1.5050e-02_r8,1.3169e-02_r8,1.1289e-02_r8,9.4076e-03_r8,7.5270e-03_r8,5.6463e-03_r8, &
     &3.7658e-03_r8,1.8853e-03_r8,4.7266e-07_r8/)
      kao(:, 2,10, 2) = (/ &
     &1.9971e-02_r8,1.7476e-02_r8,1.4981e-02_r8,1.2485e-02_r8,9.9900e-03_r8,7.4947e-03_r8, &
     &4.9999e-03_r8,2.5053e-03_r8,1.0606e-06_r8/)
      kao(:, 3,10, 2) = (/ &
     &2.5996e-02_r8,2.2748e-02_r8,1.9499e-02_r8,1.6252e-02_r8,1.3005e-02_r8,9.7575e-03_r8, &
     &6.5102e-03_r8,3.2633e-03_r8,2.1957e-06_r8/)
      kao(:, 4,10, 2) = (/ &
     &3.3067e-02_r8,2.8935e-02_r8,2.4804e-02_r8,2.0673e-02_r8,1.6543e-02_r8,1.2414e-02_r8, &
     &8.2853e-03_r8,4.1549e-03_r8,4.2322e-06_r8/)
      kao(:, 5,10, 2) = (/ &
     &4.1113e-02_r8,3.5978e-02_r8,3.0842e-02_r8,2.5708e-02_r8,2.0575e-02_r8,1.5443e-02_r8, &
     &1.0311e-02_r8,5.1716e-03_r8,7.6651e-06_r8/)
      kao(:, 1,11, 2) = (/ &
     &3.5447e-02_r8,3.1017e-02_r8,2.6586e-02_r8,2.2156e-02_r8,1.7726e-02_r8,1.3295e-02_r8, &
     &8.8649e-03_r8,4.4348e-03_r8,5.0606e-07_r8/)
      kao(:, 2,11, 2) = (/ &
     &4.6742e-02_r8,4.0900e-02_r8,3.5058e-02_r8,2.9216e-02_r8,2.3374e-02_r8,1.7532e-02_r8, &
     &1.1691e-02_r8,5.8504e-03_r8,1.1095e-06_r8/)
      kao(:, 3,11, 2) = (/ &
     &6.0406e-02_r8,5.2857e-02_r8,4.5306e-02_r8,3.7757e-02_r8,3.0208e-02_r8,2.2660e-02_r8, &
     &1.5111e-02_r8,7.5645e-03_r8,2.3165e-06_r8/)
      kao(:, 4,11, 2) = (/ &
     &7.6519e-02_r8,6.6955e-02_r8,5.7393e-02_r8,4.7830e-02_r8,3.8268e-02_r8,2.8708e-02_r8, &
     &1.9148e-02_r8,9.5895e-03_r8,4.5048e-06_r8/)
      kao(:, 5,11, 2) = (/ &
     &9.5074e-02_r8,8.3196e-02_r8,7.1315e-02_r8,5.9435e-02_r8,4.7553e-02_r8,3.5677e-02_r8, &
     &2.3800e-02_r8,1.1926e-02_r8,8.0597e-06_r8/)
      kao(:, 1,12, 2) = (/ &
     &5.2692e-02_r8,4.6104e-02_r8,3.9518e-02_r8,3.2933e-02_r8,2.6346e-02_r8,1.9761e-02_r8, &
     &1.3176e-02_r8,6.5900e-03_r8,4.7314e-07_r8/)
      kao(:, 2,12, 2) = (/ &
     &6.9235e-02_r8,6.0581e-02_r8,5.1926e-02_r8,4.3273e-02_r8,3.4620e-02_r8,2.5967e-02_r8, &
     &1.7314e-02_r8,8.6616e-03_r8,1.0517e-06_r8/)
      kao(:, 3,12, 2) = (/ &
     &8.9222e-02_r8,7.8070e-02_r8,6.6918e-02_r8,5.5767e-02_r8,4.4616e-02_r8,3.3465e-02_r8, &
     &2.2315e-02_r8,1.1167e-02_r8,2.1820e-06_r8/)
      kao(:, 4,12, 2) = (/ &
     &1.1266e-01_r8,9.8579e-02_r8,8.4496e-02_r8,7.0418e-02_r8,5.6336e-02_r8,4.2258e-02_r8, &
     &2.8182e-02_r8,1.4107e-02_r8,4.2014e-06_r8/)
      kao(:, 5,12, 2) = (/ &
     &1.3942e-01_r8,1.2199e-01_r8,1.0457e-01_r8,8.7148e-02_r8,6.9722e-02_r8,5.2304e-02_r8, &
     &3.4887e-02_r8,1.7469e-02_r8,7.4819e-06_r8/)
      kao(:, 1,13, 2) = (/ &
     &6.2876e-02_r8,5.5018e-02_r8,4.7159e-02_r8,3.9299e-02_r8,3.1440e-02_r8,2.3581e-02_r8, &
     &1.5722e-02_r8,7.8632e-03_r8,4.0954e-07_r8/)
      kao(:, 2,13, 2) = (/ &
     &8.2400e-02_r8,7.2100e-02_r8,6.1801e-02_r8,5.1502e-02_r8,4.1203e-02_r8,3.0903e-02_r8, &
     &2.0605e-02_r8,1.0307e-02_r8,9.1322e-07_r8/)
      kao(:, 3,13, 2) = (/ &
     &1.0586e-01_r8,9.2633e-02_r8,7.9402e-02_r8,6.6169e-02_r8,5.2938e-02_r8,3.9706e-02_r8, &
     &2.6476e-02_r8,1.3248e-02_r8,1.8983e-06_r8/)
      kao(:, 4,13, 2) = (/ &
     &1.3330e-01_r8,1.1664e-01_r8,9.9979e-02_r8,8.3320e-02_r8,6.6657e-02_r8,4.9998e-02_r8, &
     &3.3342e-02_r8,1.6688e-02_r8,3.6054e-06_r8/)
      kao(:, 5,13, 2) = (/ &
     &1.6451e-01_r8,1.4395e-01_r8,1.2339e-01_r8,1.0283e-01_r8,8.2267e-02_r8,6.1710e-02_r8, &
     &4.1158e-02_r8,2.0605e-02_r8,6.1726e-06_r8/)
      kao(:, 1, 1, 3) = (/ &
     &1.0158e-05_r8,1.3198e-05_r8,1.2933e-05_r8,1.7710e-05_r8,3.0455e-05_r8,3.0829e-05_r8, &
     &3.6460e-05_r8,4.7058e-05_r8,1.7479e-05_r8/)
      kao(:, 2, 1, 3) = (/ &
     &1.1438e-05_r8,1.5570e-05_r8,1.6943e-05_r8,1.4755e-05_r8,2.6165e-05_r8,3.0134e-05_r8, &
     &3.4781e-05_r8,5.6113e-05_r8,2.1722e-05_r8/)
      kao(:, 3, 1, 3) = (/ &
     &1.2956e-05_r8,1.8129e-05_r8,1.9971e-05_r8,1.8485e-05_r8,1.6628e-05_r8,3.1264e-05_r8, &
     &3.4010e-05_r8,5.1158e-05_r8,2.4518e-05_r8/)
      kao(:, 4, 1, 3) = (/ &
     &1.4615e-05_r8,2.0830e-05_r8,2.2660e-05_r8,2.2625e-05_r8,1.9967e-05_r8,2.4812e-05_r8, &
     &3.9103e-05_r8,5.0423e-05_r8,1.7758e-05_r8/)
      kao(:, 5, 1, 3) = (/ &
     &1.6017e-05_r8,2.3480e-05_r8,2.5498e-05_r8,2.6186e-05_r8,2.5773e-05_r8,1.9360e-05_r8, &
     &3.6373e-05_r8,5.8002e-05_r8,2.1777e-05_r8/)
      kao(:, 1, 2, 3) = (/ &
     &1.6325e-05_r8,1.8415e-05_r8,1.8317e-05_r8,1.4470e-05_r8,2.4482e-05_r8,3.9161e-05_r8, &
     &3.6427e-05_r8,3.6776e-05_r8,1.2226e-05_r8/)
      kao(:, 2, 2, 3) = (/ &
     &1.8436e-05_r8,2.1492e-05_r8,2.2101e-05_r8,2.0928e-05_r8,1.7486e-05_r8,3.4569e-05_r8, &
     &3.4173e-05_r8,4.1432e-05_r8,1.6945e-05_r8/)
      kao(:, 3, 2, 3) = (/ &
     &2.0725e-05_r8,2.4812e-05_r8,2.5608e-05_r8,2.5315e-05_r8,2.0861e-05_r8,2.2865e-05_r8, &
     &3.3858e-05_r8,3.7106e-05_r8,1.4100e-05_r8/)
      kao(:, 4, 2, 3) = (/ &
     &2.3257e-05_r8,2.7888e-05_r8,2.9222e-05_r8,2.9285e-05_r8,2.7055e-05_r8,2.2581e-05_r8, &
     &3.3589e-05_r8,3.8281e-05_r8,1.2084e-05_r8/)
      kao(:, 5, 2, 3) = (/ &
     &2.5809e-05_r8,3.1443e-05_r8,3.3009e-05_r8,3.2988e-05_r8,3.1499e-05_r8,2.8005e-05_r8, &
     &2.1824e-05_r8,4.6522e-05_r8,1.8788e-05_r8/)
      kao(:, 1, 3, 3) = (/ &
     &3.6153e-05_r8,3.6160e-05_r8,3.3889e-05_r8,3.0515e-05_r8,2.3824e-05_r8,2.0510e-05_r8, &
     &5.5046e-05_r8,4.3679e-05_r8,8.4874e-06_r8/)
      kao(:, 2, 3, 3) = (/ &
     &4.1441e-05_r8,4.2015e-05_r8,3.9744e-05_r8,3.6451e-05_r8,3.1872e-05_r8,2.2157e-05_r8, &
     &3.7036e-05_r8,4.0290e-05_r8,7.7192e-06_r8/)
      kao(:, 3, 3, 3) = (/ &
     &4.6667e-05_r8,4.8191e-05_r8,4.5785e-05_r8,4.2457e-05_r8,3.7818e-05_r8,3.1272e-05_r8, &
     &2.3354e-05_r8,3.9936e-05_r8,6.8348e-06_r8/)
      kao(:, 4, 3, 3) = (/ &
     &5.1877e-05_r8,5.4060e-05_r8,5.1719e-05_r8,4.8126e-05_r8,4.3652e-05_r8,3.8051e-05_r8, &
     &2.7576e-05_r8,4.1113e-05_r8,1.0881e-05_r8/)
      kao(:, 5, 3, 3) = (/ &
     &5.7673e-05_r8,6.0087e-05_r8,5.7843e-05_r8,5.4035e-05_r8,4.9732e-05_r8,4.3859e-05_r8, &
     &3.4661e-05_r8,3.3926e-05_r8,1.5564e-05_r8/)
      kao(:, 1, 4, 3) = (/ &
     &8.1569e-05_r8,7.6506e-05_r8,6.9052e-05_r8,6.0598e-05_r8,5.1130e-05_r8,3.9208e-05_r8, &
     &2.1647e-05_r8,7.1331e-05_r8,4.7464e-06_r8/)
      kao(:, 2, 4, 3) = (/ &
     &9.5409e-05_r8,8.9513e-05_r8,8.1016e-05_r8,7.1228e-05_r8,6.0322e-05_r8,4.8270e-05_r8, &
     &3.1172e-05_r8,4.9123e-05_r8,3.8536e-06_r8/)
      kao(:, 3, 4, 3) = (/ &
     &1.0835e-04_r8,1.0286e-04_r8,9.3383e-05_r8,8.2438e-05_r8,7.0089e-05_r8,5.7019e-05_r8, &
     &4.1480e-05_r8,3.2272e-05_r8,5.8347e-06_r8/)
      kao(:, 4, 4, 3) = (/ &
     &1.2088e-04_r8,1.1587e-04_r8,1.0589e-04_r8,9.3297e-05_r8,7.9862e-05_r8,6.5329e-05_r8, &
     &4.9231e-05_r8,2.5421e-05_r8,9.1036e-06_r8/)
      kao(:, 5, 4, 3) = (/ &
     &1.3349e-04_r8,1.2852e-04_r8,1.1738e-04_r8,1.0384e-04_r8,8.9286e-05_r8,7.3614e-05_r8, &
     &5.6906e-05_r8,3.4260e-05_r8,1.3290e-05_r8/)
      kao(:, 1, 5, 3) = (/ &
     &1.7345e-04_r8,1.5727e-04_r8,1.3841e-04_r8,1.1872e-04_r8,9.8241e-05_r8,7.6833e-05_r8, &
     &5.2762e-05_r8,2.6555e-05_r8,1.9880e-06_r8/)
      kao(:, 2, 5, 3) = (/ &
     &2.0342e-04_r8,1.8508e-04_r8,1.6349e-04_r8,1.4064e-04_r8,1.1678e-04_r8,9.1597e-05_r8, &
     &6.4678e-05_r8,2.5634e-05_r8,3.0971e-06_r8/)
      kao(:, 3, 5, 3) = (/ &
     &2.3455e-04_r8,2.1397e-04_r8,1.8954e-04_r8,1.6295e-04_r8,1.3528e-04_r8,1.0632e-04_r8, &
     &7.5971e-05_r8,4.0302e-05_r8,5.0300e-06_r8/)
      kao(:, 4, 5, 3) = (/ &
     &2.6426e-04_r8,2.4201e-04_r8,2.1476e-04_r8,1.8503e-04_r8,1.5431e-04_r8,1.2132e-04_r8, &
     &8.7057e-05_r8,4.9691e-05_r8,7.6275e-06_r8/)
      kao(:, 5, 5, 3) = (/ &
     &2.9276e-04_r8,2.6878e-04_r8,2.3851e-04_r8,2.0652e-04_r8,1.7242e-04_r8,1.3630e-04_r8, &
     &9.8498e-05_r8,5.7853e-05_r8,1.1134e-05_r8/)
      kao(:, 1, 6, 3) = (/ &
     &3.5315e-04_r8,3.1458e-04_r8,2.7325e-04_r8,2.3096e-04_r8,1.8808e-04_r8,1.4453e-04_r8, &
     &9.9918e-05_r8,4.6331e-05_r8,1.2347e-06_r8/)
      kao(:, 2, 6, 3) = (/ &
     &4.1518e-04_r8,3.7021e-04_r8,3.2222e-04_r8,2.7318e-04_r8,2.2345e-04_r8,1.7257e-04_r8, &
     &1.2006e-04_r8,6.3507e-05_r8,2.6453e-06_r8/)
      kao(:, 3, 6, 3) = (/ &
     &4.8020e-04_r8,4.2942e-04_r8,3.7435e-04_r8,3.1847e-04_r8,2.6105e-04_r8,2.0180e-04_r8, &
     &1.4068e-04_r8,7.6253e-05_r8,4.2798e-06_r8/)
      kao(:, 4, 6, 3) = (/ &
     &5.4571e-04_r8,4.8797e-04_r8,4.2639e-04_r8,3.6432e-04_r8,2.9826e-04_r8,2.3028e-04_r8, &
     &1.6074e-04_r8,8.8155e-05_r8,6.6580e-06_r8/)
      kao(:, 5, 6, 3) = (/ &
     &6.1051e-04_r8,5.4685e-04_r8,4.8080e-04_r8,4.0919e-04_r8,3.3486e-04_r8,2.5913e-04_r8, &
     &1.8080e-04_r8,9.9384e-05_r8,9.9722e-06_r8/)
      kao(:, 1, 7, 3) = (/ &
     &7.5693e-04_r8,6.6624e-04_r8,5.7513e-04_r8,4.8344e-04_r8,3.9061e-04_r8,2.9600e-04_r8, &
     &2.0095e-04_r8,1.0427e-04_r8,1.0591e-06_r8/)
      kao(:, 2, 7, 3) = (/ &
     &8.9608e-04_r8,7.8973e-04_r8,6.8311e-04_r8,5.7440e-04_r8,4.6329e-04_r8,3.5236e-04_r8, &
     &2.4053e-04_r8,1.2653e-04_r8,2.0677e-06_r8/)
      kao(:, 3, 7, 3) = (/ &
     &1.0434e-03_r8,9.2160e-04_r8,7.9776e-04_r8,6.7036e-04_r8,5.4238e-04_r8,4.1393e-04_r8, &
     &2.8414e-04_r8,1.5011e-04_r8,3.4509e-06_r8/)
      kao(:, 4, 7, 3) = (/ &
     &1.1912e-03_r8,1.0536e-03_r8,9.1065e-04_r8,7.6644e-04_r8,6.2208e-04_r8,4.7601e-04_r8, &
     &3.2680e-04_r8,1.7285e-04_r8,5.5547e-06_r8/)
      kao(:, 5, 7, 3) = (/ &
     &1.3354e-03_r8,1.1809e-03_r8,1.0220e-03_r8,8.6241e-04_r8,7.0147e-04_r8,5.3735e-04_r8, &
     &3.6893e-04_r8,1.9541e-04_r8,8.3477e-06_r8/)
      kao(:, 1, 8, 3) = (/ &
     &2.0322e-03_r8,1.7810e-03_r8,1.5293e-03_r8,1.2777e-03_r8,1.0262e-03_r8,7.7431e-04_r8, &
     &5.2105e-04_r8,2.6538e-04_r8,9.6103e-07_r8/)
      kao(:, 2, 8, 3) = (/ &
     &2.4399e-03_r8,2.1393e-03_r8,1.8380e-03_r8,1.5373e-03_r8,1.2364e-03_r8,9.3375e-04_r8, &
     &6.2913e-04_r8,3.2110e-04_r8,1.7921e-06_r8/)
      kao(:, 3, 8, 3) = (/ &
     &2.8537e-03_r8,2.5030e-03_r8,2.1528e-03_r8,1.8027e-03_r8,1.4507e-03_r8,1.0966e-03_r8, &
     &7.3847e-04_r8,3.7883e-04_r8,3.0446e-06_r8/)
      kao(:, 4, 8, 3) = (/ &
     &3.2833e-03_r8,2.8808e-03_r8,2.4800e-03_r8,2.0779e-03_r8,1.6729e-03_r8,1.2622e-03_r8, &
     &8.5179e-04_r8,4.3974e-04_r8,4.8671e-06_r8/)
      kao(:, 5, 8, 3) = (/ &
     &3.6992e-03_r8,3.2483e-03_r8,2.7990e-03_r8,2.3454e-03_r8,1.8857e-03_r8,1.4259e-03_r8, &
     &9.6561e-04_r8,4.9917e-04_r8,7.5866e-06_r8/)
      kao(:, 1, 9, 3) = (/ &
     &1.0280e-02_r8,8.9965e-03_r8,7.7134e-03_r8,6.4300e-03_r8,5.1466e-03_r8,3.8628e-03_r8, &
     &2.5792e-03_r8,1.2964e-03_r8,9.2162e-07_r8/)
      kao(:, 2, 9, 3) = (/ &
     &1.2564e-02_r8,1.0997e-02_r8,9.4289e-03_r8,7.8609e-03_r8,6.2929e-03_r8,4.7248e-03_r8, &
     &3.1577e-03_r8,1.5902e-03_r8,1.8412e-06_r8/)
      kao(:, 3, 9, 3) = (/ &
     &1.4876e-02_r8,1.3021e-02_r8,1.1166e-02_r8,9.3099e-03_r8,7.4544e-03_r8,5.6000e-03_r8, &
     &3.7464e-03_r8,1.8890e-03_r8,3.6551e-06_r8/)
      kao(:, 4, 9, 3) = (/ &
     &1.7233e-02_r8,1.5085e-02_r8,1.2936e-02_r8,1.0788e-02_r8,8.6402e-03_r8,6.4946e-03_r8, &
     &4.3480e-03_r8,2.1937e-03_r8,6.4505e-06_r8/)
      kao(:, 5, 9, 3) = (/ &
     &1.9529e-02_r8,1.7097e-02_r8,1.4665e-02_r8,1.2232e-02_r8,9.8022e-03_r8,7.3739e-03_r8, &
     &4.9380e-03_r8,2.4934e-03_r8,1.0329e-05_r8/)
      kao(:, 1,10, 3) = (/ &
     &6.2934e-02_r8,5.5068e-02_r8,4.7203e-02_r8,3.9337e-02_r8,3.1472e-02_r8,2.3606e-02_r8, &
     &1.5740e-02_r8,7.8743e-03_r8,1.2141e-06_r8/)
      kao(:, 2,10, 3) = (/ &
     &7.7985e-02_r8,6.8239e-02_r8,5.8492e-02_r8,4.8746e-02_r8,3.8999e-02_r8,2.9252e-02_r8, &
     &1.9507e-02_r8,9.7597e-03_r8,2.5517e-06_r8/)
      kao(:, 3,10, 3) = (/ &
     &9.3312e-02_r8,8.1650e-02_r8,6.9991e-02_r8,5.8328e-02_r8,4.6667e-02_r8,3.5007e-02_r8, &
     &2.3345e-02_r8,1.1684e-02_r8,4.6909e-06_r8/)
      kao(:, 4,10, 3) = (/ &
     &1.0852e-01_r8,9.4962e-02_r8,8.1401e-02_r8,6.7840e-02_r8,5.4279e-02_r8,4.0718e-02_r8, &
     &2.7157e-02_r8,1.3598e-02_r8,7.7426e-06_r8/)
      kao(:, 5,10, 3) = (/ &
     &1.2387e-01_r8,1.0840e-01_r8,9.2920e-02_r8,7.7443e-02_r8,6.1965e-02_r8,4.6488e-02_r8, &
     &3.1009e-02_r8,1.5537e-02_r8,1.2033e-05_r8/)
      kao(:, 1,11, 3) = (/ &
     &1.4431e-01_r8,1.2627e-01_r8,1.0823e-01_r8,9.0195e-02_r8,7.2157e-02_r8,5.4120e-02_r8, &
     &3.6082e-02_r8,1.8045e-02_r8,1.2885e-06_r8/)
      kao(:, 2,11, 3) = (/ &
     &1.7767e-01_r8,1.5546e-01_r8,1.3326e-01_r8,1.1105e-01_r8,8.8842e-02_r8,6.6637e-02_r8, &
     &4.4429e-02_r8,2.2220e-02_r8,2.6746e-06_r8/)
      kao(:, 3,11, 3) = (/ &
     &2.1192e-01_r8,1.8543e-01_r8,1.5895e-01_r8,1.3246e-01_r8,1.0597e-01_r8,7.9483e-02_r8, &
     &5.2995e-02_r8,2.6507e-02_r8,4.8840e-06_r8/)
      kao(:, 4,11, 3) = (/ &
     &2.4571e-01_r8,2.1501e-01_r8,1.8430e-01_r8,1.5358e-01_r8,1.2287e-01_r8,9.2163e-02_r8, &
     &6.1452e-02_r8,3.0740e-02_r8,7.9723e-06_r8/)
      kao(:, 5,11, 3) = (/ &
     &2.7981e-01_r8,2.4483e-01_r8,2.0987e-01_r8,1.7490e-01_r8,1.3993e-01_r8,1.0496e-01_r8, &
     &6.9988e-02_r8,3.5019e-02_r8,1.2223e-05_r8/)
      kao(:, 1,12, 3) = (/ &
     &2.0829e-01_r8,1.8226e-01_r8,1.5622e-01_r8,1.3018e-01_r8,1.0415e-01_r8,7.8112e-02_r8, &
     &5.2077e-02_r8,2.6041e-02_r8,1.2025e-06_r8/)
      kao(:, 2,12, 3) = (/ &
     &2.5587e-01_r8,2.2388e-01_r8,1.9190e-01_r8,1.5992e-01_r8,1.2794e-01_r8,9.5954e-02_r8, &
     &6.3973e-02_r8,3.1992e-02_r8,2.4634e-06_r8/)
      kao(:, 3,12, 3) = (/ &
     &3.0401e-01_r8,2.6600e-01_r8,2.2801e-01_r8,1.9001e-01_r8,1.5201e-01_r8,1.1401e-01_r8, &
     &7.6014e-02_r8,3.8015e-02_r8,4.4929e-06_r8/)
      kao(:, 4,12, 3) = (/ &
     &3.5185e-01_r8,3.0787e-01_r8,2.6390e-01_r8,2.1992e-01_r8,1.7594e-01_r8,1.3196e-01_r8, &
     &8.7984e-02_r8,4.4005e-02_r8,7.2358e-06_r8/)
      kao(:, 5,12, 3) = (/ &
     &3.9955e-01_r8,3.4961e-01_r8,2.9967e-01_r8,2.4973e-01_r8,1.9980e-01_r8,1.4985e-01_r8, &
     &9.9920e-02_r8,4.9982e-02_r8,1.1171e-05_r8/)
      kao(:, 1,13, 3) = (/ &
     &2.4192e-01_r8,2.1167e-01_r8,1.8143e-01_r8,1.5120e-01_r8,1.2096e-01_r8,9.0718e-02_r8, &
     &6.0481e-02_r8,3.0243e-02_r8,1.0138e-06_r8/)
      kao(:, 2,13, 3) = (/ &
     &2.9636e-01_r8,2.5932e-01_r8,2.2227e-01_r8,1.8523e-01_r8,1.4819e-01_r8,1.1114e-01_r8, &
     &7.4096e-02_r8,3.7053e-02_r8,2.0810e-06_r8/)
      kao(:, 3,13, 3) = (/ &
     &3.5109e-01_r8,3.0721e-01_r8,2.6332e-01_r8,2.1944e-01_r8,1.7555e-01_r8,1.3167e-01_r8, &
     &8.7782e-02_r8,4.3898e-02_r8,3.6752e-06_r8/)
      kao(:, 4,13, 3) = (/ &
     &4.0523e-01_r8,3.5457e-01_r8,3.0393e-01_r8,2.5327e-01_r8,2.0263e-01_r8,1.5197e-01_r8, &
     &1.0132e-01_r8,5.0676e-02_r8,6.1123e-06_r8/)
      kao(:, 5,13, 3) = (/ &
     &4.5914e-01_r8,4.0175e-01_r8,3.4437e-01_r8,2.8698e-01_r8,2.2959e-01_r8,1.7221e-01_r8, &
     &1.1482e-01_r8,5.7432e-02_r8,9.7404e-06_r8/)
      kao(:, 1, 1, 4) = (/ &
     &2.1350e-05_r8,2.4552e-05_r8,2.3723e-05_r8,1.5777e-05_r8,2.7169e-05_r8,3.2921e-05_r8, &
     &3.9368e-05_r8,6.8629e-05_r8,2.6626e-05_r8/)
      kao(:, 2, 1, 4) = (/ &
     &2.2878e-05_r8,2.6833e-05_r8,2.6737e-05_r8,2.0377e-05_r8,2.2142e-05_r8,3.1966e-05_r8, &
     &4.1566e-05_r8,6.1320e-05_r8,2.3858e-05_r8/)
      kao(:, 3, 1, 4) = (/ &
     &2.3851e-05_r8,2.8963e-05_r8,2.9322e-05_r8,2.7907e-05_r8,1.9726e-05_r8,2.5598e-05_r8, &
     &4.2650e-05_r8,6.7498e-05_r8,2.1250e-05_r8/)
      kao(:, 4, 1, 4) = (/ &
     &2.4297e-05_r8,3.1053e-05_r8,3.2431e-05_r8,3.1771e-05_r8,2.7799e-05_r8,2.0892e-05_r8, &
     &3.7144e-05_r8,7.1944e-05_r8,2.3747e-05_r8/)
      kao(:, 5, 1, 4) = (/ &
     &2.4515e-05_r8,3.3133e-05_r8,3.5554e-05_r8,3.5376e-05_r8,3.4171e-05_r8,2.9240e-05_r8, &
     &2.7955e-05_r8,6.5059e-05_r8,3.8779e-05_r8/)
      kao(:, 1, 2, 4) = (/ &
     &3.5233e-05_r8,3.6967e-05_r8,3.5192e-05_r8,3.0346e-05_r8,1.9517e-05_r8,3.6227e-05_r8, &
     &3.6486e-05_r8,4.4755e-05_r8,1.7210e-05_r8/)
      kao(:, 2, 2, 4) = (/ &
     &3.7659e-05_r8,4.0104e-05_r8,3.8633e-05_r8,3.5461e-05_r8,2.4007e-05_r8,2.9205e-05_r8, &
     &3.6839e-05_r8,4.4274e-05_r8,1.6582e-05_r8/)
      kao(:, 3, 2, 4) = (/ &
     &3.9567e-05_r8,4.2994e-05_r8,4.2107e-05_r8,3.9324e-05_r8,3.3808e-05_r8,2.0621e-05_r8, &
     &3.2387e-05_r8,5.0199e-05_r8,1.2696e-05_r8/)
      kao(:, 4, 2, 4) = (/ &
     &4.0697e-05_r8,4.5929e-05_r8,4.5740e-05_r8,4.2992e-05_r8,3.9709e-05_r8,2.8967e-05_r8, &
     &2.4180e-05_r8,4.8120e-05_r8,2.0582e-05_r8/)
      kao(:, 5, 2, 4) = (/ &
     &4.1514e-05_r8,4.8565e-05_r8,4.9023e-05_r8,4.7662e-05_r8,4.4382e-05_r8,3.8389e-05_r8, &
     &2.5686e-05_r8,4.1842e-05_r8,3.1906e-05_r8/)
      kao(:, 1, 3, 4) = (/ &
     &8.1562e-05_r8,7.8380e-05_r8,7.1455e-05_r8,6.3207e-05_r8,5.2782e-05_r8,3.3109e-05_r8, &
     &4.1621e-05_r8,4.2434e-05_r8,8.8242e-06_r8/)
      kao(:, 2, 3, 4) = (/ &
     &8.6593e-05_r8,8.4470e-05_r8,7.7554e-05_r8,6.8896e-05_r8,5.8997e-05_r8,4.4824e-05_r8, &
     &3.0840e-05_r8,4.1510e-05_r8,8.5693e-06_r8/)
      kao(:, 3, 3, 4) = (/ &
     &9.1353e-05_r8,8.9996e-05_r8,8.3114e-05_r8,7.4541e-05_r8,6.4935e-05_r8,5.3159e-05_r8, &
     &2.8537e-05_r8,3.9838e-05_r8,1.1226e-05_r8/)
      kao(:, 4, 3, 4) = (/ &
     &9.5365e-05_r8,9.5648e-05_r8,8.9016e-05_r8,8.0719e-05_r8,7.0818e-05_r8,5.8632e-05_r8, &
     &4.0977e-05_r8,3.3245e-05_r8,1.8214e-05_r8/)
      kao(:, 5, 3, 4) = (/ &
     &9.7542e-05_r8,1.0001e-04_r8,9.4766e-05_r8,8.7247e-05_r8,7.6489e-05_r8,6.4569e-05_r8, &
     &5.1322e-05_r8,2.4346e-05_r8,2.6190e-05_r8/)
      kao(:, 1, 4, 4) = (/ &
     &1.9526e-04_r8,1.7866e-04_r8,1.5808e-04_r8,1.3593e-04_r8,1.1271e-04_r8,8.7918e-05_r8, &
     &5.1266e-05_r8,5.4774e-05_r8,4.6025e-06_r8/)
      kao(:, 2, 4, 4) = (/ &
     &2.0650e-04_r8,1.9062e-04_r8,1.6960e-04_r8,1.4698e-04_r8,1.2286e-04_r8,9.7273e-05_r8, &
     &6.7543e-05_r8,4.4150e-05_r8,5.6277e-06_r8/)
      kao(:, 3, 4, 4) = (/ &
     &2.1739e-04_r8,2.0276e-04_r8,1.8135e-04_r8,1.5734e-04_r8,1.3233e-04_r8,1.0548e-04_r8, &
     &7.6274e-05_r8,3.0228e-05_r8,9.8992e-06_r8/)
      kao(:, 4, 4, 4) = (/ &
     &2.2749e-04_r8,2.1410e-04_r8,1.9235e-04_r8,1.6801e-04_r8,1.4178e-04_r8,1.1383e-04_r8, &
     &8.3889e-05_r8,3.8831e-05_r8,1.4832e-05_r8/)
      kao(:, 5, 4, 4) = (/ &
     &2.3672e-04_r8,2.2535e-04_r8,2.0298e-04_r8,1.7817e-04_r8,1.5157e-04_r8,1.2285e-04_r8, &
     &9.1248e-05_r8,5.4055e-05_r8,2.0953e-05_r8/)
      kao(:, 1, 5, 4) = (/ &
     &4.3901e-04_r8,3.9096e-04_r8,3.4083e-04_r8,2.8855e-04_r8,2.3566e-04_r8,1.8135e-04_r8, &
     &1.2520e-04_r8,3.9791e-05_r8,2.8698e-06_r8/)
      kao(:, 2, 5, 4) = (/ &
     &4.6450e-04_r8,4.1602e-04_r8,3.6285e-04_r8,3.0879e-04_r8,2.5330e-04_r8,1.9642e-04_r8, &
     &1.3685e-04_r8,6.9096e-05_r8,4.7432e-06_r8/)
      kao(:, 3, 5, 4) = (/ &
     &4.8882e-04_r8,4.4052e-04_r8,3.8581e-04_r8,3.3048e-04_r8,2.7253e-04_r8,2.1160e-04_r8, &
     &1.4899e-04_r8,8.1167e-05_r8,8.1879e-06_r8/)
      kao(:, 4, 5, 4) = (/ &
     &5.1005e-04_r8,4.6303e-04_r8,4.0950e-04_r8,3.5246e-04_r8,2.9060e-04_r8,2.2675e-04_r8, &
     &1.6042e-04_r8,8.9994e-05_r8,1.2389e-05_r8/)
      kao(:, 5, 5, 4) = (/ &
     &5.2999e-04_r8,4.8642e-04_r8,4.3340e-04_r8,3.7157e-04_r8,3.0721e-04_r8,2.4050e-04_r8, &
     &1.7156e-04_r8,9.8341e-05_r8,1.7831e-05_r8/)
      kao(:, 1, 6, 4) = (/ &
     &9.3945e-04_r8,8.2623e-04_r8,7.1331e-04_r8,5.9949e-04_r8,4.8483e-04_r8,3.6836e-04_r8, &
     &2.5086e-04_r8,1.2938e-04_r8,2.1494e-06_r8/)
      kao(:, 2, 6, 4) = (/ &
     &1.0016e-03_r8,8.8499e-04_r8,7.6750e-04_r8,6.4657e-04_r8,5.2304e-04_r8,3.9902e-04_r8, &
     &2.7391e-04_r8,1.4413e-04_r8,3.8318e-06_r8/)
      kao(:, 3, 6, 4) = (/ &
     &1.0547e-03_r8,9.3464e-04_r8,8.1142e-04_r8,6.8349e-04_r8,5.5479e-04_r8,4.2609e-04_r8, &
     &2.9394e-04_r8,1.5646e-04_r8,6.4475e-06_r8/)
      kao(:, 4, 6, 4) = (/ &
     &1.1032e-03_r8,9.8345e-04_r8,8.5527e-04_r8,7.2211e-04_r8,5.9000e-04_r8,4.5529e-04_r8, &
     &3.1446e-04_r8,1.6904e-04_r8,9.9612e-06_r8/)
      kao(:, 5, 6, 4) = (/ &
     &1.1467e-03_r8,1.0269e-03_r8,8.9466e-04_r8,7.6180e-04_r8,6.2654e-04_r8,4.8317e-04_r8, &
     &3.3526e-04_r8,1.8155e-04_r8,1.4635e-05_r8/)
      kao(:, 1, 7, 4) = (/ &
     &2.0968e-03_r8,1.8382e-03_r8,1.5799e-03_r8,1.3200e-03_r8,1.0602e-03_r8,8.0055e-04_r8, &
     &5.3931e-04_r8,2.7613e-04_r8,1.7495e-06_r8/)
      kao(:, 2, 7, 4) = (/ &
     &2.2692e-03_r8,1.9926e-03_r8,1.7142e-03_r8,1.4356e-03_r8,1.1561e-03_r8,8.7560e-04_r8, &
     &5.9192e-04_r8,3.0494e-04_r8,3.2823e-06_r8/)
      kao(:, 3, 7, 4) = (/ &
     &2.3957e-03_r8,2.1065e-03_r8,1.8155e-03_r8,1.5242e-03_r8,1.2302e-03_r8,9.3213e-04_r8, &
     &6.3098e-04_r8,3.2845e-04_r8,5.4452e-06_r8/)
      kao(:, 4, 7, 4) = (/ &
     &2.5154e-03_r8,2.2153e-03_r8,1.9155e-03_r8,1.6120e-03_r8,1.3009e-03_r8,9.8717e-04_r8, &
     &6.7313e-04_r8,3.5215e-04_r8,8.4591e-06_r8/)
      kao(:, 5, 7, 4) = (/ &
     &2.6221e-03_r8,2.3149e-03_r8,2.0078e-03_r8,1.6896e-03_r8,1.3663e-03_r8,1.0418e-03_r8, &
     &7.1380e-04_r8,3.7558e-04_r8,1.3208e-05_r8/)
      kao(:, 1, 8, 4) = (/ &
     &5.9687e-03_r8,5.2249e-03_r8,4.4818e-03_r8,3.7390e-03_r8,2.9959e-03_r8,2.2513e-03_r8, &
     &1.5068e-03_r8,7.6107e-04_r8,1.5072e-06_r8/)
      kao(:, 2, 8, 4) = (/ &
     &6.4060e-03_r8,5.6103e-03_r8,4.8155e-03_r8,4.0184e-03_r8,3.2203e-03_r8,2.4232e-03_r8, &
     &1.6246e-03_r8,8.2361e-04_r8,2.9177e-06_r8/)
      kao(:, 3, 8, 4) = (/ &
     &6.8363e-03_r8,5.9919e-03_r8,5.1443e-03_r8,4.2950e-03_r8,3.4467e-03_r8,2.5980e-03_r8, &
     &1.7471e-03_r8,8.8934e-04_r8,5.0920e-06_r8/)
      kao(:, 4, 8, 4) = (/ &
     &7.1796e-03_r8,6.2954e-03_r8,5.4063e-03_r8,4.5177e-03_r8,3.6307e-03_r8,2.7430e-03_r8, &
     &1.8488e-03_r8,9.4284e-04_r8,8.3290e-06_r8/)
      kao(:, 5, 8, 4) = (/ &
     &7.5276e-03_r8,6.6017e-03_r8,5.6732e-03_r8,4.7473e-03_r8,3.8229e-03_r8,2.8925e-03_r8, &
     &1.9515e-03_r8,1.0013e-03_r8,1.2816e-05_r8/)
      kao(:, 1, 9, 4) = (/ &
     &3.2487e-02_r8,2.8428e-02_r8,2.4369e-02_r8,2.0309e-02_r8,1.6251e-02_r8,1.2192e-02_r8, &
     &8.1342e-03_r8,4.0755e-03_r8,1.9489e-06_r8/)
      kao(:, 2, 9, 4) = (/ &
     &3.4271e-02_r8,2.9992e-02_r8,2.5712e-02_r8,2.1432e-02_r8,1.7152e-02_r8,1.2873e-02_r8, &
     &8.5913e-03_r8,4.3059e-03_r8,3.6526e-06_r8/)
      kao(:, 3, 9, 4) = (/ &
     &3.6903e-02_r8,3.2297e-02_r8,2.7692e-02_r8,2.3087e-02_r8,1.8480e-02_r8,1.3870e-02_r8, &
     &9.2583e-03_r8,4.6485e-03_r8,5.8762e-06_r8/)
      kao(:, 4, 9, 4) = (/ &
     &3.8979e-02_r8,3.4119e-02_r8,2.9257e-02_r8,2.4392e-02_r8,1.9526e-02_r8,1.4659e-02_r8, &
     &9.7912e-03_r8,4.9264e-03_r8,9.0883e-06_r8/)
      kao(:, 5, 9, 4) = (/ &
     &4.0909e-02_r8,3.5808e-02_r8,3.0705e-02_r8,2.5602e-02_r8,2.0497e-02_r8,1.5392e-02_r8, &
     &1.0293e-02_r8,5.1880e-03_r8,1.4132e-05_r8/)
      kao(:, 1,10, 4) = (/ &
     &2.1003e-01_r8,1.8378e-01_r8,1.5753e-01_r8,1.3127e-01_r8,1.0502e-01_r8,7.8770e-02_r8, &
     &5.2516e-02_r8,2.6264e-02_r8,2.2708e-06_r8/)
      kao(:, 2,10, 4) = (/ &
     &2.2303e-01_r8,1.9515e-01_r8,1.6728e-01_r8,1.3940e-01_r8,1.1153e-01_r8,8.3651e-02_r8, &
     &5.5777e-02_r8,2.7901e-02_r8,4.3388e-06_r8/)
      kao(:, 3,10, 4) = (/ &
     &2.3715e-01_r8,2.0752e-01_r8,1.7788e-01_r8,1.4824e-01_r8,1.1861e-01_r8,8.8964e-02_r8, &
     &5.9326e-02_r8,2.9681e-02_r8,8.0389e-06_r8/)
      kao(:, 4,10, 4) = (/ &
     &2.5270e-01_r8,2.2113e-01_r8,1.8955e-01_r8,1.5796e-01_r8,1.2638e-01_r8,9.4802e-02_r8, &
     &6.3220e-02_r8,3.1633e-02_r8,1.4122e-05_r8/)
      kao(:, 5,10, 4) = (/ &
     &2.6544e-01_r8,2.3227e-01_r8,1.9911e-01_r8,1.6593e-01_r8,1.3276e-01_r8,9.9586e-02_r8, &
     &6.6411e-02_r8,3.3237e-02_r8,2.0958e-05_r8/)
      kao(:, 1,11, 4) = (/ &
     &4.6663e-01_r8,4.0831e-01_r8,3.4998e-01_r8,2.9165e-01_r8,2.3332e-01_r8,1.7500e-01_r8, &
     &1.1667e-01_r8,5.8341e-02_r8,2.3420e-06_r8/)
      kao(:, 2,11, 4) = (/ &
     &4.9719e-01_r8,4.3506e-01_r8,3.7290e-01_r8,3.1076e-01_r8,2.4862e-01_r8,1.8647e-01_r8, &
     &1.2432e-01_r8,6.2174e-02_r8,4.5807e-06_r8/)
      kao(:, 3,11, 4) = (/ &
     &5.2774e-01_r8,4.6176e-01_r8,3.9581e-01_r8,3.2984e-01_r8,2.6389e-01_r8,1.9793e-01_r8, &
     &1.3196e-01_r8,6.5997e-02_r8,8.8811e-06_r8/)
      kao(:, 4,11, 4) = (/ &
     &5.6221e-01_r8,4.9195e-01_r8,4.2167e-01_r8,3.5141e-01_r8,2.8114e-01_r8,2.1086e-01_r8, &
     &1.4059e-01_r8,7.0317e-02_r8,1.5538e-05_r8/)
      kao(:, 5,11, 4) = (/ &
     &5.9121e-01_r8,5.1732e-01_r8,4.4343e-01_r8,3.6953e-01_r8,2.9564e-01_r8,2.2174e-01_r8, &
     &1.4785e-01_r8,7.3949e-02_r8,2.4433e-05_r8/)
      kao(:, 1,12, 4) = (/ &
     &6.5249e-01_r8,5.7093e-01_r8,4.8937e-01_r8,4.0781e-01_r8,3.2625e-01_r8,2.4469e-01_r8, &
     &1.6313e-01_r8,8.1572e-02_r8,2.2330e-06_r8/)
      kao(:, 2,12, 4) = (/ &
     &6.9534e-01_r8,6.0842e-01_r8,5.2151e-01_r8,4.3459e-01_r8,3.4768e-01_r8,2.6076e-01_r8, &
     &1.7385e-01_r8,8.6935e-02_r8,4.3967e-06_r8/)
      kao(:, 3,12, 4) = (/ &
     &7.4143e-01_r8,6.4875e-01_r8,5.5607e-01_r8,4.6339e-01_r8,3.7072e-01_r8,2.7805e-01_r8, &
     &1.8537e-01_r8,9.2701e-02_r8,8.3925e-06_r8/)
      kao(:, 4,12, 4) = (/ &
     &7.8904e-01_r8,6.9042e-01_r8,5.9179e-01_r8,4.9316e-01_r8,3.9453e-01_r8,2.9591e-01_r8, &
     &1.9728e-01_r8,9.8661e-02_r8,1.5232e-05_r8/)
      kao(:, 5,12, 4) = (/ &
     &8.3131e-01_r8,7.2741e-01_r8,6.2350e-01_r8,5.1959e-01_r8,4.1567e-01_r8,3.1177e-01_r8, &
     &2.0786e-01_r8,1.0395e-01_r8,2.3060e-05_r8/)
      kao(:, 1,13, 4) = (/ &
     &7.3322e-01_r8,6.4157e-01_r8,5.4992e-01_r8,4.5827e-01_r8,3.6662e-01_r8,2.7497e-01_r8, &
     &1.8332e-01_r8,9.1663e-02_r8,1.8044e-06_r8/)
      kao(:, 2,13, 4) = (/ &
     &7.8224e-01_r8,6.8446e-01_r8,5.8668e-01_r8,4.8890e-01_r8,3.9113e-01_r8,2.9335e-01_r8, &
     &1.9557e-01_r8,9.7794e-02_r8,3.6622e-06_r8/)
      kao(:, 3,13, 4) = (/ &
     &8.3769e-01_r8,7.3298e-01_r8,6.2826e-01_r8,5.2356e-01_r8,4.1885e-01_r8,3.1414e-01_r8, &
     &2.0944e-01_r8,1.0473e-01_r8,6.8549e-06_r8/)
      kao(:, 4,13, 4) = (/ &
     &8.9145e-01_r8,7.8000e-01_r8,6.6858e-01_r8,5.5715e-01_r8,4.4572e-01_r8,3.3430e-01_r8, &
     &2.2288e-01_r8,1.1145e-01_r8,1.1699e-05_r8/)
      kao(:, 5,13, 4) = (/ &
     &9.4256e-01_r8,8.2475e-01_r8,7.0694e-01_r8,5.8912e-01_r8,4.7129e-01_r8,3.5348e-01_r8, &
     &2.3566e-01_r8,1.1785e-01_r8,1.9250e-05_r8/)
      kao(:, 1, 1, 5) = (/ &
     &3.1890e-05_r8,3.3428e-05_r8,3.1339e-05_r8,1.9062e-05_r8,2.1359e-05_r8,2.6190e-05_r8, &
     &4.2364e-05_r8,7.2281e-05_r8,2.8801e-05_r8/)
      kao(:, 2, 1, 5) = (/ &
     &3.2241e-05_r8,3.5034e-05_r8,3.4311e-05_r8,2.9337e-05_r8,1.6956e-05_r8,2.7153e-05_r8, &
     &4.1595e-05_r8,7.5807e-05_r8,2.1642e-05_r8/)
      kao(:, 3, 1, 5) = (/ &
     &3.2685e-05_r8,3.7104e-05_r8,3.7239e-05_r8,3.5440e-05_r8,2.4683e-05_r8,2.0584e-05_r8, &
     &3.9467e-05_r8,7.0498e-05_r8,2.5433e-05_r8/)
      kao(:, 4, 1, 5) = (/ &
     &3.3108e-05_r8,3.9233e-05_r8,3.9843e-05_r8,4.0632e-05_r8,3.9351e-05_r8,2.7492e-05_r8, &
     &2.7372e-05_r8,6.6136e-05_r8,4.2940e-05_r8/)
      kao(:, 5, 1, 5) = (/ &
     &3.3102e-05_r8,4.1126e-05_r8,4.3706e-05_r8,4.7600e-05_r8,5.0514e-05_r8,4.9463e-05_r8, &
     &3.6482e-05_r8,4.9147e-05_r8,6.6970e-05_r8/)
      kao(:, 1, 2, 5) = (/ &
     &5.3936e-05_r8,5.3705e-05_r8,4.9534e-05_r8,4.3483e-05_r8,2.4468e-05_r8,2.7314e-05_r8, &
     &3.0874e-05_r8,5.5614e-05_r8,1.6658e-05_r8/)
      kao(:, 2, 2, 5) = (/ &
     &5.4860e-05_r8,5.5845e-05_r8,5.2280e-05_r8,4.7572e-05_r8,3.6459e-05_r8,1.9946e-05_r8, &
     &3.1643e-05_r8,4.8991e-05_r8,1.3490e-05_r8/)
      kao(:, 3, 2, 5) = (/ &
     &5.5709e-05_r8,5.8014e-05_r8,5.5306e-05_r8,5.1404e-05_r8,4.5520e-05_r8,2.7920e-05_r8, &
     &2.4697e-05_r8,4.8298e-05_r8,2.2442e-05_r8/)
      kao(:, 4, 2, 5) = (/ &
     &5.6594e-05_r8,6.0421e-05_r8,5.8710e-05_r8,5.5553e-05_r8,5.0533e-05_r8,4.1849e-05_r8, &
     &2.3926e-05_r8,4.4332e-05_r8,3.8077e-05_r8/)
      kao(:, 5, 2, 5) = (/ &
     &5.6989e-05_r8,6.3301e-05_r8,6.2702e-05_r8,5.9556e-05_r8,5.7075e-05_r8,5.4328e-05_r8, &
     &4.2106e-05_r8,3.0435e-05_r8,5.5304e-05_r8/)
      kao(:, 1, 3, 5) = (/ &
     &1.3054e-04_r8,1.2243e-04_r8,1.0960e-04_r8,9.5396e-05_r8,7.9466e-05_r8,5.1293e-05_r8, &
     &3.9755e-05_r8,3.4475e-05_r8,8.0698e-06_r8/)
      kao(:, 2, 3, 5) = (/ &
     &1.3254e-04_r8,1.2631e-04_r8,1.1422e-04_r8,1.0017e-04_r8,8.4724e-05_r8,6.6970e-05_r8, &
     &3.1985e-05_r8,3.1748e-05_r8,1.1668e-05_r8/)
      kao(:, 3, 3, 5) = (/ &
     &1.3451e-04_r8,1.3069e-04_r8,1.1849e-04_r8,1.0449e-04_r8,8.9441e-05_r8,7.3066e-05_r8, &
     &4.0433e-05_r8,3.2069e-05_r8,2.1119e-05_r8/)
      kao(:, 4, 3, 5) = (/ &
     &1.3620e-04_r8,1.3418e-04_r8,1.2287e-04_r8,1.0958e-04_r8,9.5020e-05_r8,7.9300e-05_r8, &
     &5.8519e-05_r8,2.5240e-05_r8,3.2095e-05_r8/)
      kao(:, 5, 3, 5) = (/ &
     &1.3805e-04_r8,1.3888e-04_r8,1.2760e-04_r8,1.1481e-04_r8,1.0157e-04_r8,8.6256e-05_r8, &
     &6.7417e-05_r8,3.0660e-05_r8,4.5147e-05_r8/)
      kao(:, 1, 4, 5) = (/ &
     &3.2379e-04_r8,2.9036e-04_r8,2.5461e-04_r8,2.1829e-04_r8,1.8055e-04_r8,1.4064e-04_r8, &
     &9.6199e-05_r8,5.2600e-05_r8,5.3338e-06_r8/)
      kao(:, 2, 4, 5) = (/ &
     &3.2979e-04_r8,2.9999e-04_r8,2.6566e-04_r8,2.2924e-04_r8,1.9018e-04_r8,1.4831e-04_r8, &
     &1.0429e-04_r8,3.7208e-05_r8,1.1382e-05_r8/)
      kao(:, 3, 4, 5) = (/ &
     &3.3647e-04_r8,3.0773e-04_r8,2.7537e-04_r8,2.3841e-04_r8,1.9818e-04_r8,1.5534e-04_r8, &
     &1.1107e-04_r8,4.2940e-05_r8,1.8774e-05_r8/)
      kao(:, 4, 4, 5) = (/ &
     &3.4222e-04_r8,3.1790e-04_r8,2.8515e-04_r8,2.4672e-04_r8,2.0544e-04_r8,1.6267e-04_r8, &
     &1.1806e-04_r8,6.5823e-05_r8,2.7569e-05_r8/)
      kao(:, 5, 4, 5) = (/ &
     &3.4598e-04_r8,3.2526e-04_r8,2.9297e-04_r8,2.5514e-04_r8,2.1384e-04_r8,1.7093e-04_r8, &
     &1.2620e-04_r8,7.6156e-05_r8,3.8829e-05_r8/)
      kao(:, 1, 5, 5) = (/ &
     &7.4853e-04_r8,6.5989e-04_r8,5.7237e-04_r8,4.8339e-04_r8,3.9258e-04_r8,3.0112e-04_r8, &
     &2.0775e-04_r8,1.0511e-04_r8,4.9046e-06_r8/)
      kao(:, 2, 5, 5) = (/ &
     &7.7296e-04_r8,6.8526e-04_r8,5.9860e-04_r8,5.0629e-04_r8,4.1334e-04_r8,3.1913e-04_r8, &
     &2.2288e-04_r8,1.1662e-04_r8,9.7426e-06_r8/)
      kao(:, 3, 5, 5) = (/ &
     &7.8512e-04_r8,7.0191e-04_r8,6.1328e-04_r8,5.2156e-04_r8,4.2917e-04_r8,3.3432e-04_r8, &
     &2.3232e-04_r8,1.2535e-04_r8,1.4908e-05_r8/)
      kao(:, 4, 5, 5) = (/ &
     &8.0065e-04_r8,7.1779e-04_r8,6.2814e-04_r8,5.3808e-04_r8,4.4471e-04_r8,3.4601e-04_r8, &
     &2.4241e-04_r8,1.3326e-04_r8,2.1852e-05_r8/)
      kao(:, 5, 5, 5) = (/ &
     &8.1368e-04_r8,7.3211e-04_r8,6.4458e-04_r8,5.5662e-04_r8,4.6149e-04_r8,3.6022e-04_r8, &
     &2.5323e-04_r8,1.4142e-04_r8,3.1532e-05_r8/)
      kao(:, 1, 6, 5) = (/ &
     &1.6528e-03_r8,1.4497e-03_r8,1.2477e-03_r8,1.0459e-03_r8,8.4296e-04_r8,6.4013e-04_r8, &
     &4.3541e-04_r8,2.2882e-04_r8,4.1025e-06_r8/)
      kao(:, 2, 6, 5) = (/ &
     &1.7167e-03_r8,1.5070e-03_r8,1.2980e-03_r8,1.0901e-03_r8,8.8256e-04_r8,6.7196e-04_r8, &
     &4.5785e-04_r8,2.4158e-04_r8,7.1575e-06_r8/)
      kao(:, 3, 6, 5) = (/ &
     &1.7542e-03_r8,1.5443e-03_r8,1.3374e-03_r8,1.1305e-03_r8,9.1589e-04_r8,6.9839e-04_r8, &
     &4.8070e-04_r8,2.5576e-04_r8,1.1170e-05_r8/)
      kao(:, 4, 6, 5) = (/ &
     &1.7835e-03_r8,1.5745e-03_r8,1.3686e-03_r8,1.1552e-03_r8,9.3898e-04_r8,7.2100e-04_r8, &
     &4.9974e-04_r8,2.6756e-04_r8,1.6778e-05_r8/)
      kao(:, 5, 6, 5) = (/ &
     &1.8173e-03_r8,1.6109e-03_r8,1.3997e-03_r8,1.1836e-03_r8,9.6533e-04_r8,7.4477e-04_r8, &
     &5.1869e-04_r8,2.7889e-04_r8,2.4339e-05_r8/)
      kao(:, 1, 7, 5) = (/ &
     &3.9726e-03_r8,3.4772e-03_r8,2.9832e-03_r8,2.4912e-03_r8,1.9978e-03_r8,1.5048e-03_r8, &
     &1.0114e-03_r8,5.1606e-04_r8,3.0815e-06_r8/)
      kao(:, 2, 7, 5) = (/ &
     &3.9885e-03_r8,3.4924e-03_r8,2.9992e-03_r8,2.5047e-03_r8,2.0117e-03_r8,1.5168e-03_r8, &
     &1.0225e-03_r8,5.2471e-04_r8,5.4224e-06_r8/)
      kao(:, 3, 7, 5) = (/ &
     &4.1133e-03_r8,3.6053e-03_r8,3.0965e-03_r8,2.5896e-03_r8,2.0823e-03_r8,1.5758e-03_r8, &
     &1.0680e-03_r8,5.5159e-04_r8,9.0931e-06_r8/)
      kao(:, 4, 7, 5) = (/ &
     &4.1858e-03_r8,3.6723e-03_r8,3.1582e-03_r8,2.6449e-03_r8,2.1343e-03_r8,1.6217e-03_r8, &
     &1.1005e-03_r8,5.7513e-04_r8,1.3973e-05_r8/)
      kao(:, 5, 7, 5) = (/ &
     &4.2673e-03_r8,3.7471e-03_r8,3.2256e-03_r8,2.7082e-03_r8,2.1908e-03_r8,1.6652e-03_r8, &
     &1.1349e-03_r8,5.9686e-04_r8,1.9907e-05_r8/)
      kao(:, 1, 8, 5) = (/ &
     &1.1789e-02_r8,1.0316e-02_r8,8.8432e-03_r8,7.3701e-03_r8,5.8982e-03_r8,4.4284e-03_r8, &
     &2.9575e-03_r8,1.4868e-03_r8,2.6362e-06_r8/)
      kao(:, 2, 8, 5) = (/ &
     &1.1815e-02_r8,1.0339e-02_r8,8.8633e-03_r8,7.3911e-03_r8,5.9198e-03_r8,4.4454e-03_r8, &
     &2.9722e-03_r8,1.4993e-03_r8,4.7391e-06_r8/)
      kao(:, 3, 8, 5) = (/ &
     &1.2063e-02_r8,1.0556e-02_r8,9.0547e-03_r8,7.5533e-03_r8,6.0485e-03_r8,4.5441e-03_r8, &
     &3.0419e-03_r8,1.5395e-03_r8,7.9686e-06_r8/)
      kao(:, 4, 8, 5) = (/ &
     &1.2374e-02_r8,1.0835e-02_r8,9.2985e-03_r8,7.7571e-03_r8,6.2150e-03_r8,4.6751e-03_r8, &
     &3.1349e-03_r8,1.5981e-03_r8,1.2907e-05_r8/)
      kao(:, 5, 8, 5) = (/ &
     &1.2586e-02_r8,1.1028e-02_r8,9.4648e-03_r8,7.8998e-03_r8,6.3362e-03_r8,4.7714e-03_r8, &
     &3.2105e-03_r8,1.6437e-03_r8,1.9633e-05_r8/)
      kao(:, 1, 9, 5) = (/ &
     &6.5443e-02_r8,5.7264e-02_r8,4.9084e-02_r8,4.0904e-02_r8,3.2723e-02_r8,2.4543e-02_r8, &
     &1.6364e-02_r8,8.1848e-03_r8,3.1432e-06_r8/)
      kao(:, 2, 9, 5) = (/ &
     &6.6880e-02_r8,5.8521e-02_r8,5.0162e-02_r8,4.1802e-02_r8,3.3443e-02_r8,2.5083e-02_r8, &
     &1.6728e-02_r8,8.3763e-03_r8,5.7297e-06_r8/)
      kao(:, 3, 9, 5) = (/ &
     &6.6965e-02_r8,5.8596e-02_r8,5.0227e-02_r8,4.1857e-02_r8,3.3491e-02_r8,2.5128e-02_r8, &
     &1.6767e-02_r8,8.3954e-03_r8,1.0132e-05_r8/)
      kao(:, 4, 9, 5) = (/ &
     &6.9095e-02_r8,6.0459e-02_r8,5.1827e-02_r8,4.3201e-02_r8,3.4575e-02_r8,2.5948e-02_r8, &
     &1.7311e-02_r8,8.6749e-03_r8,1.6592e-05_r8/)
      kao(:, 5, 9, 5) = (/ &
     &7.0723e-02_r8,6.1894e-02_r8,5.3070e-02_r8,4.4247e-02_r8,3.5417e-02_r8,2.6580e-02_r8, &
     &1.7739e-02_r8,8.9030e-03_r8,2.5109e-05_r8/)
      kao(:, 1,10, 5) = (/ &
     &4.3117e-01_r8,3.7727e-01_r8,3.2338e-01_r8,2.6948e-01_r8,2.1559e-01_r8,1.6169e-01_r8, &
     &1.0779e-01_r8,5.3898e-02_r8,3.8321e-06_r8/)
      kao(:, 2,10, 5) = (/ &
     &4.4275e-01_r8,3.8740e-01_r8,3.3206e-01_r8,2.7672e-01_r8,2.2138e-01_r8,1.6603e-01_r8, &
     &1.1069e-01_r8,5.5347e-02_r8,7.9189e-06_r8/)
      kao(:, 3,10, 5) = (/ &
     &4.5038e-01_r8,3.9409e-01_r8,3.3779e-01_r8,2.8149e-01_r8,2.2519e-01_r8,1.6890e-01_r8, &
     &1.1260e-01_r8,5.6313e-02_r8,1.3890e-05_r8/)
      kao(:, 4,10, 5) = (/ &
     &4.5731e-01_r8,4.0015e-01_r8,3.4299e-01_r8,2.8583e-01_r8,2.2868e-01_r8,1.7152e-01_r8, &
     &1.1436e-01_r8,5.7212e-02_r8,2.2042e-05_r8/)
      kao(:, 5,10, 5) = (/ &
     &4.7192e-01_r8,4.1294e-01_r8,3.5396e-01_r8,2.9499e-01_r8,2.3600e-01_r8,1.7703e-01_r8, &
     &1.1805e-01_r8,5.9063e-02_r8,3.5819e-05_r8/)
      kao(:, 1,11, 5) = (/ &
     &9.6082e-01_r8,8.4073e-01_r8,7.2062e-01_r8,6.0052e-01_r8,4.8042e-01_r8,3.6032e-01_r8, &
     &2.4021e-01_r8,1.2011e-01_r8,4.1252e-06_r8/)
      kao(:, 2,11, 5) = (/ &
     &9.8883e-01_r8,8.6524e-01_r8,7.4164e-01_r8,6.1802e-01_r8,4.9442e-01_r8,3.7082e-01_r8, &
     &2.4722e-01_r8,1.2361e-01_r8,8.2890e-06_r8/)
      kao(:, 3,11, 5) = (/ &
     &1.0099e+00_r8,8.8371e-01_r8,7.5745e-01_r8,6.3122e-01_r8,5.0498e-01_r8,3.7874e-01_r8, &
     &2.5251e-01_r8,1.2627e-01_r8,1.3752e-05_r8/)
      kao(:, 4,11, 5) = (/ &
     &1.0275e+00_r8,8.9904e-01_r8,7.7063e-01_r8,6.4220e-01_r8,5.1377e-01_r8,3.8534e-01_r8, &
     &2.5691e-01_r8,1.2849e-01_r8,2.1878e-05_r8/)
      kao(:, 5,11, 5) = (/ &
     &1.0619e+00_r8,9.2921e-01_r8,7.9651e-01_r8,6.6374e-01_r8,5.3103e-01_r8,3.9829e-01_r8, &
     &2.6556e-01_r8,1.3282e-01_r8,3.3798e-05_r8/)
      kao(:, 1,12, 5) = (/ &
     &1.3448e+00_r8,1.1767e+00_r8,1.0086e+00_r8,8.4049e-01_r8,6.7240e-01_r8,5.0429e-01_r8, &
     &3.3620e-01_r8,1.6810e-01_r8,3.8444e-06_r8/)
      kao(:, 2,12, 5) = (/ &
     &1.3870e+00_r8,1.2136e+00_r8,1.0403e+00_r8,8.6689e-01_r8,6.9351e-01_r8,5.2014e-01_r8, &
     &3.4675e-01_r8,1.7338e-01_r8,8.1656e-06_r8/)
      kao(:, 3,12, 5) = (/ &
     &1.4199e+00_r8,1.2424e+00_r8,1.0649e+00_r8,8.8747e-01_r8,7.0998e-01_r8,5.3249e-01_r8, &
     &3.5500e-01_r8,1.7752e-01_r8,1.3518e-05_r8/)
      kao(:, 4,12, 5) = (/ &
     &1.4553e+00_r8,1.2734e+00_r8,1.0915e+00_r8,9.0958e-01_r8,7.2769e-01_r8,5.4578e-01_r8, &
     &3.6386e-01_r8,1.8196e-01_r8,2.0674e-05_r8/)
      kao(:, 5,12, 5) = (/ &
     &1.5049e+00_r8,1.3168e+00_r8,1.1287e+00_r8,9.4058e-01_r8,7.5249e-01_r8,5.6439e-01_r8, &
     &3.7628e-01_r8,1.8817e-01_r8,3.3221e-05_r8/)
      kao(:, 1,13, 5) = (/ &
     &1.5112e+00_r8,1.3223e+00_r8,1.1334e+00_r8,9.4452e-01_r8,7.5561e-01_r8,5.6670e-01_r8, &
     &3.7781e-01_r8,1.8891e-01_r8,3.4136e-06_r8/)
      kao(:, 2,13, 5) = (/ &
     &1.5630e+00_r8,1.3677e+00_r8,1.1723e+00_r8,9.7690e-01_r8,7.8153e-01_r8,5.8614e-01_r8, &
     &3.9077e-01_r8,1.9539e-01_r8,7.2314e-06_r8/)
      kao(:, 3,13, 5) = (/ &
     &1.6029e+00_r8,1.4025e+00_r8,1.2022e+00_r8,1.0018e+00_r8,8.0146e-01_r8,6.0110e-01_r8, &
     &4.0074e-01_r8,2.0039e-01_r8,1.2933e-05_r8/)
      kao(:, 4,13, 5) = (/ &
     &1.6548e+00_r8,1.4480e+00_r8,1.2411e+00_r8,1.0343e+00_r8,8.2742e-01_r8,6.2059e-01_r8, &
     &4.1374e-01_r8,2.0689e-01_r8,2.1420e-05_r8/)
      kao(:, 5,13, 5) = (/ &
     &1.7129e+00_r8,1.4988e+00_r8,1.2846e+00_r8,1.0706e+00_r8,8.5645e-01_r8,6.4235e-01_r8, &
     &4.2827e-01_r8,2.1415e-01_r8,3.1482e-05_r8/)
      kao(:, 1, 1, 6) = (/ &
     &4.0608e-05_r8,4.2185e-05_r8,3.9730e-05_r8,2.6630e-05_r8,1.5870e-05_r8,2.1720e-05_r8, &
     &4.0183e-05_r8,5.7933e-05_r8,1.9230e-05_r8/)
      kao(:, 2, 1, 6) = (/ &
     &4.0560e-05_r8,4.3924e-05_r8,4.2843e-05_r8,4.0587e-05_r8,1.9599e-05_r8,1.9434e-05_r8, &
     &2.9187e-05_r8,8.1729e-05_r8,2.4180e-05_r8/)
      kao(:, 3, 1, 6) = (/ &
     &4.0596e-05_r8,4.5223e-05_r8,4.7233e-05_r8,4.8206e-05_r8,4.1815e-05_r8,2.4282e-05_r8, &
     &2.7535e-05_r8,5.3025e-05_r8,4.5769e-05_r8/)
      kao(:, 4, 1, 6) = (/ &
     &4.0424e-05_r8,4.7527e-05_r8,5.3798e-05_r8,5.7119e-05_r8,5.7658e-05_r8,5.2268e-05_r8, &
     &3.6355e-05_r8,4.4941e-05_r8,8.6910e-05_r8/)
      kao(:, 5, 1, 6) = (/ &
     &4.0234e-05_r8,5.1685e-05_r8,6.0703e-05_r8,6.7173e-05_r8,7.3473e-05_r8,7.8264e-05_r8, &
     &7.7542e-05_r8,6.1561e-05_r8,1.1878e-04_r8/)
      kao(:, 1, 2, 6) = (/ &
     &7.1743e-05_r8,6.9776e-05_r8,6.4069e-05_r8,5.6253e-05_r8,3.2492e-05_r8,1.5299e-05_r8, &
     &2.5979e-05_r8,5.8422e-05_r8,1.3265e-05_r8/)
      kao(:, 2, 2, 6) = (/ &
     &7.1061e-05_r8,7.2097e-05_r8,6.7274e-05_r8,6.0734e-05_r8,5.1280e-05_r8,2.1520e-05_r8, &
     &1.9911e-05_r8,4.4529e-05_r8,1.9523e-05_r8/)
      kao(:, 3, 2, 6) = (/ &
     &7.0841e-05_r8,7.4370e-05_r8,7.0760e-05_r8,6.5655e-05_r8,6.0306e-05_r8,4.1020e-05_r8, &
     &2.4466e-05_r8,3.0981e-05_r8,4.7368e-05_r8/)
      kao(:, 4, 2, 6) = (/ &
     &7.0995e-05_r8,7.6358e-05_r8,7.4085e-05_r8,7.2263e-05_r8,6.9627e-05_r8,6.3412e-05_r8, &
     &3.9010e-05_r8,3.3220e-05_r8,7.3941e-05_r8/)
      kao(:, 5, 2, 6) = (/ &
     &7.1418e-05_r8,7.8720e-05_r8,7.9350e-05_r8,8.0487e-05_r8,8.0635e-05_r8,7.8967e-05_r8, &
     &7.4070e-05_r8,4.7509e-05_r8,9.9451e-05_r8/)
      kao(:, 1, 3, 6) = (/ &
     &1.7804e-04_r8,1.6309e-04_r8,1.4603e-04_r8,1.2640e-04_r8,1.0532e-04_r8,7.7851e-05_r8, &
     &3.0401e-05_r8,3.2808e-05_r8,1.0278e-05_r8/)
      kao(:, 2, 3, 6) = (/ &
     &1.7807e-04_r8,1.6656e-04_r8,1.5059e-04_r8,1.3159e-04_r8,1.1024e-04_r8,8.6966e-05_r8, &
     &3.8390e-05_r8,2.7178e-05_r8,2.3712e-05_r8/)
      kao(:, 3, 3, 6) = (/ &
     &1.7838e-04_r8,1.6972e-04_r8,1.5616e-04_r8,1.3747e-04_r8,1.1728e-04_r8,9.5070e-05_r8, &
     &6.7563e-05_r8,2.2396e-05_r8,4.2459e-05_r8/)
      kao(:, 4, 3, 6) = (/ &
     &1.7857e-04_r8,1.7475e-04_r8,1.6100e-04_r8,1.4311e-04_r8,1.2411e-04_r8,1.0321e-04_r8, &
     &8.1061e-05_r8,2.7084e-05_r8,5.9922e-05_r8/)
      kao(:, 5, 3, 6) = (/ &
     &1.7913e-04_r8,1.7932e-04_r8,1.6663e-04_r8,1.4905e-04_r8,1.3079e-04_r8,1.1234e-04_r8, &
     &9.4176e-05_r8,5.9304e-05_r8,8.0703e-05_r8/)
      kao(:, 1, 4, 6) = (/ &
     &4.5849e-04_r8,4.0719e-04_r8,3.5630e-04_r8,3.0212e-04_r8,2.4723e-04_r8,1.9208e-04_r8, &
     &1.3224e-04_r8,4.0670e-05_r8,1.0786e-05_r8/)
      kao(:, 2, 4, 6) = (/ &
     &4.6326e-04_r8,4.1501e-04_r8,3.6371e-04_r8,3.1046e-04_r8,2.5726e-04_r8,2.0145e-04_r8, &
     &1.4032e-04_r8,4.2661e-05_r8,2.2724e-05_r8/)
      kao(:, 3, 4, 6) = (/ &
     &4.5999e-04_r8,4.1805e-04_r8,3.6892e-04_r8,3.1975e-04_r8,2.6673e-04_r8,2.0947e-04_r8, &
     &1.4924e-04_r8,6.8954e-05_r8,3.3787e-05_r8/)
      kao(:, 4, 4, 6) = (/ &
     &4.6003e-04_r8,4.1972e-04_r8,3.7753e-04_r8,3.3032e-04_r8,2.7779e-04_r8,2.1909e-04_r8, &
     &1.5785e-04_r8,9.1573e-05_r8,4.7343e-05_r8/)
      kao(:, 5, 4, 6) = (/ &
     &4.6253e-04_r8,4.2854e-04_r8,3.8917e-04_r8,3.4007e-04_r8,2.8599e-04_r8,2.2760e-04_r8, &
     &1.6713e-04_r8,1.0392e-04_r8,6.4507e-05_r8/)
      kao(:, 1, 5, 6) = (/ &
     &1.1046e-03_r8,9.7210e-04_r8,8.3818e-04_r8,7.0474e-04_r8,5.7182e-04_r8,4.3731e-04_r8, &
     &3.0078e-04_r8,1.5849e-04_r8,1.0669e-05_r8/)
      kao(:, 2, 5, 6) = (/ &
     &1.1184e-03_r8,9.8522e-04_r8,8.5052e-04_r8,7.1956e-04_r8,5.8448e-04_r8,4.4708e-04_r8, &
     &3.0943e-04_r8,1.6582e-04_r8,1.7856e-05_r8/)
      kao(:, 3, 5, 6) = (/ &
     &1.1214e-03_r8,9.8952e-04_r8,8.6298e-04_r8,7.3058e-04_r8,5.9526e-04_r8,4.5967e-04_r8, &
     &3.2343e-04_r8,1.7504e-04_r8,2.7384e-05_r8/)
      kao(:, 4, 5, 6) = (/ &
     &1.1214e-03_r8,9.9887e-04_r8,8.7233e-04_r8,7.4058e-04_r8,6.1074e-04_r8,4.7706e-04_r8, &
     &3.3627e-04_r8,1.8500e-04_r8,4.0071e-05_r8/)
      kao(:, 5, 5, 6) = (/ &
     &1.1239e-03_r8,1.0058e-03_r8,8.8047e-04_r8,7.5602e-04_r8,6.2667e-04_r8,4.9193e-04_r8, &
     &3.4864e-04_r8,1.9526e-04_r8,5.6262e-05_r8/)
      kao(:, 1, 6, 6) = (/ &
     &2.6585e-03_r8,2.3289e-03_r8,2.0017e-03_r8,1.6725e-03_r8,1.3436e-03_r8,1.0134e-03_r8, &
     &6.8348e-04_r8,3.5116e-04_r8,8.2810e-06_r8/)
      kao(:, 2, 6, 6) = (/ &
     &2.5863e-03_r8,2.2683e-03_r8,1.9501e-03_r8,1.6316e-03_r8,1.3110e-03_r8,9.9174e-04_r8, &
     &6.7274e-04_r8,3.5111e-04_r8,1.4039e-05_r8/)
      kao(:, 3, 6, 6) = (/ &
     &2.6176e-03_r8,2.2991e-03_r8,1.9771e-03_r8,1.6537e-03_r8,1.3367e-03_r8,1.0179e-03_r8, &
     &6.9352e-04_r8,3.6693e-04_r8,2.2683e-05_r8/)
      kao(:, 4, 6, 6) = (/ &
     &2.6217e-03_r8,2.3046e-03_r8,1.9871e-03_r8,1.6757e-03_r8,1.3567e-03_r8,1.0347e-03_r8, &
     &7.1195e-04_r8,3.8176e-04_r8,3.4748e-05_r8/)
      kao(:, 5, 6, 6) = (/ &
     &2.6329e-03_r8,2.3195e-03_r8,2.0094e-03_r8,1.6960e-03_r8,1.3768e-03_r8,1.0589e-03_r8, &
     &7.3230e-04_r8,3.9783e-04_r8,4.9695e-05_r8/)
      kao(:, 1, 7, 6) = (/ &
     &6.5036e-03_r8,5.6927e-03_r8,4.8817e-03_r8,4.0715e-03_r8,3.2636e-03_r8,2.4531e-03_r8, &
     &1.6426e-03_r8,8.2916e-04_r8,6.2936e-06_r8/)
      kao(:, 2, 7, 6) = (/ &
     &6.4462e-03_r8,5.6438e-03_r8,4.8427e-03_r8,4.0443e-03_r8,3.2425e-03_r8,2.4409e-03_r8, &
     &1.6364e-03_r8,8.3288e-04_r8,1.1136e-05_r8/)
      kao(:, 3, 7, 6) = (/ &
     &6.4103e-03_r8,5.6141e-03_r8,4.8233e-03_r8,4.0268e-03_r8,3.2317e-03_r8,2.4336e-03_r8, &
     &1.6355e-03_r8,8.3675e-04_r8,1.7991e-05_r8/)
      kao(:, 4, 7, 6) = (/ &
     &6.4801e-03_r8,5.6797e-03_r8,4.8784e-03_r8,4.0772e-03_r8,3.2734e-03_r8,2.4699e-03_r8, &
     &1.6705e-03_r8,8.6234e-04_r8,2.8124e-05_r8/)
      kao(:, 5, 7, 6) = (/ &
     &6.4899e-03_r8,5.6954e-03_r8,4.8999e-03_r8,4.1019e-03_r8,3.3007e-03_r8,2.5022e-03_r8, &
     &1.6963e-03_r8,8.8568e-04_r8,4.2294e-05_r8/)
      kao(:, 1, 8, 6) = (/ &
     &1.9938e-02_r8,1.7447e-02_r8,1.4956e-02_r8,1.2465e-02_r8,9.9746e-03_r8,7.4836e-03_r8, &
     &4.9963e-03_r8,2.5067e-03_r8,5.1161e-06_r8/)
      kao(:, 2, 8, 6) = (/ &
     &2.0028e-02_r8,1.7527e-02_r8,1.5026e-02_r8,1.2525e-02_r8,1.0025e-02_r8,7.5295e-03_r8, &
     &5.0298e-03_r8,2.5282e-03_r8,9.0850e-06_r8/)
      kao(:, 3, 8, 6) = (/ &
     &1.9800e-02_r8,1.7330e-02_r8,1.4859e-02_r8,1.2391e-02_r8,9.9275e-03_r8,7.4581e-03_r8, &
     &4.9868e-03_r8,2.5105e-03_r8,1.5352e-05_r8/)
      kao(:, 4, 8, 6) = (/ &
     &1.9943e-02_r8,1.7456e-02_r8,1.4973e-02_r8,1.2495e-02_r8,1.0008e-02_r8,7.5213e-03_r8, &
     &5.0327e-03_r8,2.5396e-03_r8,2.4408e-05_r8/)
      kao(:, 5, 8, 6) = (/ &
     &2.0100e-02_r8,1.7597e-02_r8,1.5105e-02_r8,1.2604e-02_r8,1.0099e-02_r8,7.5963e-03_r8, &
     &5.0871e-03_r8,2.5804e-03_r8,3.7067e-05_r8/)
      kao(:, 1, 9, 6) = (/ &
     &1.1579e-01_r8,1.0132e-01_r8,8.6843e-02_r8,7.2372e-02_r8,5.7899e-02_r8,4.3426e-02_r8, &
     &2.8954e-02_r8,1.4481e-02_r8,4.8758e-06_r8/)
      kao(:, 2, 9, 6) = (/ &
     &1.1661e-01_r8,1.0203e-01_r8,8.7460e-02_r8,7.2886e-02_r8,5.8311e-02_r8,4.3737e-02_r8, &
     &2.9163e-02_r8,1.4591e-02_r8,1.0307e-05_r8/)
      kao(:, 3, 9, 6) = (/ &
     &1.1709e-01_r8,1.0246e-01_r8,8.7825e-02_r8,7.3192e-02_r8,5.8559e-02_r8,4.3925e-02_r8, &
     &2.9293e-02_r8,1.4674e-02_r8,1.8955e-05_r8/)
      kao(:, 4, 9, 6) = (/ &
     &1.1566e-01_r8,1.0121e-01_r8,8.6757e-02_r8,7.2304e-02_r8,5.7852e-02_r8,4.3402e-02_r8, &
     &2.8967e-02_r8,1.4512e-02_r8,3.1114e-05_r8/)
      kao(:, 5, 9, 6) = (/ &
     &1.1720e-01_r8,1.0255e-01_r8,8.7909e-02_r8,7.3266e-02_r8,5.8634e-02_r8,4.4011e-02_r8, &
     &2.9372e-02_r8,1.4720e-02_r8,4.7731e-05_r8/)
      kao(:, 1,10, 6) = (/ &
     &7.9704e-01_r8,6.9741e-01_r8,5.9778e-01_r8,4.9815e-01_r8,3.9852e-01_r8,2.9889e-01_r8, &
     &1.9926e-01_r8,9.9635e-02_r8,6.0881e-06_r8/)
      kao(:, 2,10, 6) = (/ &
     &8.0524e-01_r8,7.0458e-01_r8,6.0393e-01_r8,5.0328e-01_r8,4.0263e-01_r8,3.0197e-01_r8, &
     &2.0132e-01_r8,1.0067e-01_r8,9.9592e-06_r8/)
      kao(:, 3,10, 6) = (/ &
     &8.0944e-01_r8,7.0827e-01_r8,6.0708e-01_r8,5.0591e-01_r8,4.0473e-01_r8,3.0356e-01_r8, &
     &2.0238e-01_r8,1.0120e-01_r8,1.7097e-05_r8/)
      kao(:, 4,10, 6) = (/ &
     &8.0782e-01_r8,7.0685e-01_r8,6.0589e-01_r8,5.0491e-01_r8,4.0393e-01_r8,3.0295e-01_r8, &
     &2.0198e-01_r8,1.0100e-01_r8,2.9862e-05_r8/)
      kao(:, 5,10, 6) = (/ &
     &8.0293e-01_r8,7.0255e-01_r8,6.0220e-01_r8,5.0184e-01_r8,4.0149e-01_r8,3.0112e-01_r8, &
     &2.0077e-01_r8,1.0043e-01_r8,4.8674e-05_r8/)
      kao(:, 1,11, 6) = (/ &
     &1.8320e+00_r8,1.6031e+00_r8,1.3740e+00_r8,1.1450e+00_r8,9.1602e-01_r8,6.8703e-01_r8, &
     &4.5802e-01_r8,2.2901e-01_r8,6.4794e-06_r8/)
      kao(:, 2,11, 6) = (/ &
     &1.8510e+00_r8,1.6196e+00_r8,1.3883e+00_r8,1.1569e+00_r8,9.2553e-01_r8,6.9415e-01_r8, &
     &4.6277e-01_r8,2.3139e-01_r8,1.1218e-05_r8/)
      kao(:, 3,11, 6) = (/ &
     &1.8631e+00_r8,1.6303e+00_r8,1.3974e+00_r8,1.1645e+00_r8,9.3160e-01_r8,6.9871e-01_r8, &
     &4.6580e-01_r8,2.3291e-01_r8,1.9228e-05_r8/)
      kao(:, 4,11, 6) = (/ &
     &1.8640e+00_r8,1.6310e+00_r8,1.3980e+00_r8,1.1650e+00_r8,9.3201e-01_r8,6.9904e-01_r8, &
     &4.6603e-01_r8,2.3304e-01_r8,3.3633e-05_r8/)
      kao(:, 5,11, 6) = (/ &
     &1.8480e+00_r8,1.6170e+00_r8,1.3860e+00_r8,1.1550e+00_r8,9.2402e-01_r8,6.9305e-01_r8, &
     &4.6206e-01_r8,2.3108e-01_r8,5.6086e-05_r8/)
      kao(:, 1,12, 6) = (/ &
     &2.6276e+00_r8,2.2991e+00_r8,1.9707e+00_r8,1.6422e+00_r8,1.3138e+00_r8,9.8536e-01_r8, &
     &6.5690e-01_r8,3.2845e-01_r8,6.1969e-06_r8/)
      kao(:, 2,12, 6) = (/ &
     &2.6587e+00_r8,2.3264e+00_r8,1.9940e+00_r8,1.6617e+00_r8,1.3293e+00_r8,9.9701e-01_r8, &
     &6.6468e-01_r8,3.3234e-01_r8,9.9191e-06_r8/)
      kao(:, 3,12, 6) = (/ &
     &2.6771e+00_r8,2.3425e+00_r8,2.0078e+00_r8,1.6732e+00_r8,1.3386e+00_r8,1.0039e+00_r8, &
     &6.6929e-01_r8,3.3465e-01_r8,1.7326e-05_r8/)
      kao(:, 4,12, 6) = (/ &
     &2.6786e+00_r8,2.3438e+00_r8,2.0090e+00_r8,1.6742e+00_r8,1.3393e+00_r8,1.0045e+00_r8, &
     &6.6968e-01_r8,3.3487e-01_r8,3.0600e-05_r8/)
      kao(:, 5,12, 6) = (/ &
     &2.6738e+00_r8,2.3396e+00_r8,2.0054e+00_r8,1.6711e+00_r8,1.3369e+00_r8,1.0027e+00_r8, &
     &6.6852e-01_r8,3.3432e-01_r8,4.9574e-05_r8/)
      kao(:, 1,13, 6) = (/ &
     &3.0141e+00_r8,2.6373e+00_r8,2.2606e+00_r8,1.8838e+00_r8,1.5070e+00_r8,1.1303e+00_r8, &
     &7.5353e-01_r8,3.7676e-01_r8,5.4676e-06_r8/)
      kao(:, 2,13, 6) = (/ &
     &3.0533e+00_r8,2.6716e+00_r8,2.2900e+00_r8,1.9083e+00_r8,1.5266e+00_r8,1.1450e+00_r8, &
     &7.6332e-01_r8,3.8166e-01_r8,9.0049e-06_r8/)
      kao(:, 3,13, 6) = (/ &
     &3.0797e+00_r8,2.6947e+00_r8,2.3097e+00_r8,1.9248e+00_r8,1.5398e+00_r8,1.1549e+00_r8, &
     &7.6993e-01_r8,3.8499e-01_r8,1.5493e-05_r8/)
      kao(:, 4,13, 6) = (/ &
     &3.0841e+00_r8,2.6986e+00_r8,2.3131e+00_r8,1.9276e+00_r8,1.5421e+00_r8,1.1566e+00_r8, &
     &7.7107e-01_r8,3.8557e-01_r8,2.5494e-05_r8/)
      kao(:, 5,13, 6) = (/ &
     &3.0968e+00_r8,2.7097e+00_r8,2.3226e+00_r8,1.9355e+00_r8,1.5484e+00_r8,1.1613e+00_r8, &
     &7.7428e-01_r8,3.8723e-01_r8,4.2043e-05_r8/)
      kao(:, 1, 1, 7) = (/ &
     &4.9351e-05_r8,5.1634e-05_r8,5.0550e-05_r8,4.1436e-05_r8,1.6376e-05_r8,2.1065e-05_r8, &
     &3.5627e-05_r8,5.1301e-05_r8,2.4192e-05_r8/)
      kao(:, 2, 1, 7) = (/ &
     &4.8474e-05_r8,5.5540e-05_r8,5.6343e-05_r8,5.4221e-05_r8,4.2170e-05_r8,2.4823e-05_r8, &
     &3.1731e-05_r8,5.9201e-05_r8,4.8733e-05_r8/)
      kao(:, 3, 1, 7) = (/ &
     &4.7492e-05_r8,6.0199e-05_r8,6.3032e-05_r8,6.6317e-05_r8,6.8647e-05_r8,6.4541e-05_r8, &
     &4.0308e-05_r8,5.5421e-05_r8,1.0385e-04_r8/)
      kao(:, 4, 1, 7) = (/ &
     &4.5731e-05_r8,6.4480e-05_r8,7.0656e-05_r8,8.0927e-05_r8,9.1209e-05_r8,1.0812e-04_r8, &
     &1.1177e-04_r8,6.7578e-05_r8,1.5053e-04_r8/)
      kao(:, 5, 1, 7) = (/ &
     &4.5536e-05_r8,6.8791e-05_r8,8.4361e-05_r8,1.0008e-04_r8,1.1558e-04_r8,1.4310e-04_r8, &
     &1.8138e-04_r8,1.7860e-04_r8,2.0339e-04_r8/)
      kao(:, 1, 2, 7) = (/ &
     &8.7853e-05_r8,8.5975e-05_r8,8.0217e-05_r8,7.2158e-05_r8,5.1923e-05_r8,1.7714e-05_r8, &
     &2.3551e-05_r8,3.4001e-05_r8,1.8843e-05_r8/)
      kao(:, 2, 2, 7) = (/ &
     &8.7406e-05_r8,8.8950e-05_r8,8.5976e-05_r8,7.9247e-05_r8,6.9532e-05_r8,3.6395e-05_r8, &
     &2.2706e-05_r8,4.1033e-05_r8,5.5544e-05_r8/)
      kao(:, 3, 2, 7) = (/ &
     &8.7368e-05_r8,9.3020e-05_r8,9.1442e-05_r8,8.8073e-05_r8,8.2295e-05_r8,7.2901e-05_r8, &
     &4.3354e-05_r8,4.6618e-05_r8,9.4748e-05_r8/)
      kao(:, 4, 2, 7) = (/ &
     &8.6439e-05_r8,9.8041e-05_r8,9.9373e-05_r8,9.8643e-05_r8,9.7447e-05_r8,9.7462e-05_r8, &
     &9.8905e-05_r8,6.1372e-05_r8,1.3473e-04_r8/)
      kao(:, 5, 2, 7) = (/ &
     &8.4149e-05_r8,1.0269e-04_r8,1.0851e-04_r8,1.1232e-04_r8,1.1694e-04_r8,1.2384e-04_r8, &
     &1.3615e-04_r8,1.5254e-04_r8,1.8188e-04_r8/)
      kao(:, 1, 3, 7) = (/ &
     &2.2417e-04_r8,2.0404e-04_r8,1.8235e-04_r8,1.5974e-04_r8,1.3536e-04_r8,1.0733e-04_r8, &
     &2.8889e-05_r8,2.3292e-05_r8,2.7610e-05_r8/)
      kao(:, 2, 3, 7) = (/ &
     &2.2507e-04_r8,2.0905e-04_r8,1.8945e-04_r8,1.6889e-04_r8,1.4442e-04_r8,1.1619e-04_r8, &
     &5.9496e-05_r8,2.4524e-05_r8,5.6641e-05_r8/)
      kao(:, 3, 3, 7) = (/ &
     &2.2338e-04_r8,2.1298e-04_r8,1.9588e-04_r8,1.7647e-04_r8,1.5321e-04_r8,1.2706e-04_r8, &
     &9.4765e-05_r8,2.7601e-05_r8,8.4458e-05_r8/)
      kao(:, 4, 3, 7) = (/ &
     &2.2342e-04_r8,2.1728e-04_r8,2.0413e-04_r8,1.8620e-04_r8,1.6349e-04_r8,1.4113e-04_r8, &
     &1.1467e-04_r8,6.7006e-05_r8,1.1844e-04_r8/)
      kao(:, 5, 3, 7) = (/ &
     &2.2238e-04_r8,2.2192e-04_r8,2.1227e-04_r8,1.9647e-04_r8,1.7779e-04_r8,1.5802e-04_r8, &
     &1.3658e-04_r8,1.1946e-04_r8,1.6048e-04_r8/)
      kao(:, 1, 4, 7) = (/ &
     &5.9406e-04_r8,5.2735e-04_r8,4.5854e-04_r8,3.9146e-04_r8,3.2173e-04_r8,2.5115e-04_r8, &
     &1.8204e-04_r8,3.3380e-05_r8,2.9857e-05_r8/)
      kao(:, 2, 4, 7) = (/ &
     &6.0105e-04_r8,5.3531e-04_r8,4.6978e-04_r8,4.0022e-04_r8,3.3097e-04_r8,2.6221e-04_r8, &
     &1.8773e-04_r8,5.6092e-05_r8,4.7642e-05_r8/)
      kao(:, 3, 4, 7) = (/ &
     &5.9920e-04_r8,5.3954e-04_r8,4.7635e-04_r8,4.1122e-04_r8,3.4497e-04_r8,2.7525e-04_r8, &
     &1.9878e-04_r8,1.0920e-04_r8,7.1351e-05_r8/)
      kao(:, 4, 4, 7) = (/ &
     &5.9595e-04_r8,5.4459e-04_r8,4.8204e-04_r8,4.2190e-04_r8,3.5656e-04_r8,2.8691e-04_r8, &
     &2.1194e-04_r8,1.2834e-04_r8,1.0247e-04_r8/)
      kao(:, 5, 4, 7) = (/ &
     &5.9682e-04_r8,5.4845e-04_r8,4.9542e-04_r8,4.3507e-04_r8,3.7084e-04_r8,3.0256e-04_r8, &
     &2.2629e-04_r8,1.4673e-04_r8,1.4061e-04_r8/)
      kao(:, 1, 5, 7) = (/ &
     &1.5636e-03_r8,1.3738e-03_r8,1.1854e-03_r8,9.9627e-04_r8,8.0358e-04_r8,6.1134e-04_r8, &
     &4.1794e-04_r8,2.1940e-04_r8,2.4302e-05_r8/)
      kao(:, 2, 5, 7) = (/ &
     &1.5046e-03_r8,1.3266e-03_r8,1.1472e-03_r8,9.6320e-04_r8,7.8248e-04_r8,5.9833e-04_r8, &
     &4.1211e-04_r8,2.2595e-04_r8,3.8463e-05_r8/)
      kao(:, 3, 5, 7) = (/ &
     &1.5168e-03_r8,1.3431e-03_r8,1.1615e-03_r8,9.8412e-04_r8,8.0210e-04_r8,6.1684e-04_r8, &
     &4.2935e-04_r8,2.3832e-04_r8,5.7958e-05_r8/)
      kao(:, 4, 5, 7) = (/ &
     &1.5026e-03_r8,1.3336e-03_r8,1.1649e-03_r8,9.9050e-04_r8,8.0890e-04_r8,6.2936e-04_r8, &
     &4.4480e-04_r8,2.5053e-04_r8,8.4195e-05_r8/)
      kao(:, 5, 5, 7) = (/ &
     &1.4982e-03_r8,1.3418e-03_r8,1.1752e-03_r8,9.9791e-04_r8,8.2403e-04_r8,6.4480e-04_r8, &
     &4.6309e-04_r8,2.6575e-04_r8,1.1855e-04_r8/)
      kao(:, 1, 6, 7) = (/ &
     &3.8022e-03_r8,3.3297e-03_r8,2.8587e-03_r8,2.3909e-03_r8,1.9206e-03_r8,1.4508e-03_r8, &
     &9.7686e-04_r8,5.0103e-04_r8,1.8374e-05_r8/)
      kao(:, 2, 6, 7) = (/ &
     &3.7188e-03_r8,3.2606e-03_r8,2.8078e-03_r8,2.3509e-03_r8,1.8941e-03_r8,1.4317e-03_r8, &
     &9.6949e-04_r8,5.0170e-04_r8,2.9781e-05_r8/)
      kao(:, 3, 6, 7) = (/ &
     &3.6568e-03_r8,3.2124e-03_r8,2.7660e-03_r8,2.3181e-03_r8,1.8667e-03_r8,1.4148e-03_r8, &
     &9.6121e-04_r8,5.0473e-04_r8,4.5442e-05_r8/)
      kao(:, 4, 6, 7) = (/ &
     &3.6655e-03_r8,3.2274e-03_r8,2.7830e-03_r8,2.3318e-03_r8,1.8859e-03_r8,1.4380e-03_r8, &
     &9.8239e-04_r8,5.2260e-04_r8,6.7780e-05_r8/)
      kao(:, 5, 6, 7) = (/ &
     &3.6236e-03_r8,3.1965e-03_r8,2.7643e-03_r8,2.3328e-03_r8,1.8928e-03_r8,1.4444e-03_r8, &
     &9.9870e-04_r8,5.3910e-04_r8,9.8293e-05_r8/)
      kao(:, 1, 7, 7) = (/ &
     &9.7756e-03_r8,8.5557e-03_r8,7.3357e-03_r8,6.1160e-03_r8,4.8978e-03_r8,3.6826e-03_r8, &
     &2.4642e-03_r8,1.2466e-03_r8,1.4263e-05_r8/)
      kao(:, 2, 7, 7) = (/ &
     &9.5966e-03_r8,8.4005e-03_r8,7.2050e-03_r8,6.0128e-03_r8,4.8216e-03_r8,3.6274e-03_r8, &
     &2.4345e-03_r8,1.2337e-03_r8,2.4094e-05_r8/)
      kao(:, 3, 7, 7) = (/ &
     &9.2939e-03_r8,8.1388e-03_r8,6.9869e-03_r8,5.8375e-03_r8,4.6843e-03_r8,3.5321e-03_r8, &
     &2.3720e-03_r8,1.2113e-03_r8,3.8518e-05_r8/)
      kao(:, 4, 7, 7) = (/ &
     &9.3185e-03_r8,8.1650e-03_r8,7.0200e-03_r8,5.8680e-03_r8,4.7180e-03_r8,3.5579e-03_r8, &
     &2.3933e-03_r8,1.2260e-03_r8,6.0065e-05_r8/)
      kao(:, 5, 7, 7) = (/ &
     &9.2942e-03_r8,8.1544e-03_r8,7.0105e-03_r8,5.8689e-03_r8,4.7186e-03_r8,3.5646e-03_r8, &
     &2.4113e-03_r8,1.2505e-03_r8,8.8114e-05_r8/)
      kao(:, 1, 8, 7) = (/ &
     &3.1428e-02_r8,2.7501e-02_r8,2.3574e-02_r8,1.9646e-02_r8,1.5719e-02_r8,1.1792e-02_r8, &
     &7.8652e-03_r8,3.9445e-03_r8,1.1179e-05_r8/)
      kao(:, 2, 8, 7) = (/ &
     &3.0933e-02_r8,2.7068e-02_r8,2.3204e-02_r8,1.9341e-02_r8,1.5477e-02_r8,1.1614e-02_r8, &
     &7.7579e-03_r8,3.8961e-03_r8,2.0761e-05_r8/)
      kao(:, 3, 8, 7) = (/ &
     &3.0367e-02_r8,2.6575e-02_r8,2.2784e-02_r8,1.8992e-02_r8,1.5203e-02_r8,1.1421e-02_r8, &
     &7.6337e-03_r8,3.8475e-03_r8,3.6107e-05_r8/)
      kao(:, 4, 8, 7) = (/ &
     &2.9365e-02_r8,2.5702e-02_r8,2.2039e-02_r8,1.8381e-02_r8,1.4731e-02_r8,1.1072e-02_r8, &
     &7.4163e-03_r8,3.7447e-03_r8,5.6666e-05_r8/)
      kao(:, 5, 8, 7) = (/ &
     &2.9621e-02_r8,2.5930e-02_r8,2.2243e-02_r8,1.8569e-02_r8,1.4884e-02_r8,1.1199e-02_r8, &
     &7.5061e-03_r8,3.7957e-03_r8,8.4702e-05_r8/)
      kao(:, 1, 9, 7) = (/ &
     &1.9031e-01_r8,1.6652e-01_r8,1.4273e-01_r8,1.1894e-01_r8,9.5159e-02_r8,7.1370e-02_r8, &
     &4.7583e-02_r8,2.3794e-02_r8,1.1825e-05_r8/)
      kao(:, 2, 9, 7) = (/ &
     &1.8790e-01_r8,1.6442e-01_r8,1.4093e-01_r8,1.1744e-01_r8,9.3958e-02_r8,7.0471e-02_r8, &
     &4.6985e-02_r8,2.3500e-02_r8,2.0873e-05_r8/)
      kao(:, 3, 9, 7) = (/ &
     &1.8549e-01_r8,1.6231e-01_r8,1.3912e-01_r8,1.1594e-01_r8,9.2757e-02_r8,6.9574e-02_r8, &
     &4.6391e-02_r8,2.3213e-02_r8,3.5554e-05_r8/)
      kao(:, 4, 9, 7) = (/ &
     &1.8255e-01_r8,1.5974e-01_r8,1.3693e-01_r8,1.1411e-01_r8,9.1298e-02_r8,6.8486e-02_r8, &
     &4.5672e-02_r8,2.2886e-02_r8,5.8671e-05_r8/)
      kao(:, 5, 9, 7) = (/ &
     &1.7785e-01_r8,1.5563e-01_r8,1.3341e-01_r8,1.1118e-01_r8,8.8960e-02_r8,6.6737e-02_r8, &
     &4.4547e-02_r8,2.2336e-02_r8,9.5234e-05_r8/)
      kao(:, 1,10, 7) = (/ &
     &1.3607e+00_r8,1.1905e+00_r8,1.0205e+00_r8,8.5040e-01_r8,6.8031e-01_r8,5.1024e-01_r8, &
     &3.4016e-01_r8,1.7008e-01_r8,8.4759e-06_r8/)
      kao(:, 2,10, 7) = (/ &
     &1.3482e+00_r8,1.1796e+00_r8,1.0111e+00_r8,8.4260e-01_r8,6.7408e-01_r8,5.0556e-01_r8, &
     &3.3705e-01_r8,1.6853e-01_r8,1.7938e-05_r8/)
      kao(:, 3,10, 7) = (/ &
     &1.3360e+00_r8,1.1690e+00_r8,1.0020e+00_r8,8.3498e-01_r8,6.6798e-01_r8,5.0099e-01_r8, &
     &3.3400e-01_r8,1.6701e-01_r8,3.3302e-05_r8/)
      kao(:, 4,10, 7) = (/ &
     &1.3243e+00_r8,1.1588e+00_r8,9.9325e-01_r8,8.2771e-01_r8,6.6217e-01_r8,4.9664e-01_r8, &
     &3.3111e-01_r8,1.6557e-01_r8,5.5097e-05_r8/)
      kao(:, 5,10, 7) = (/ &
     &1.3047e+00_r8,1.1416e+00_r8,9.7851e-01_r8,8.1543e-01_r8,6.5236e-01_r8,4.8929e-01_r8, &
     &3.2621e-01_r8,1.6314e-01_r8,9.0393e-05_r8/)
      kao(:, 1,11, 7) = (/ &
     &3.2276e+00_r8,2.8242e+00_r8,2.4208e+00_r8,2.0173e+00_r8,1.6138e+00_r8,1.2104e+00_r8, &
     &8.0693e-01_r8,4.0346e-01_r8,7.3681e-06_r8/)
      kao(:, 2,11, 7) = (/ &
     &3.2117e+00_r8,2.8103e+00_r8,2.4088e+00_r8,2.0073e+00_r8,1.6059e+00_r8,1.2044e+00_r8, &
     &8.0294e-01_r8,4.0147e-01_r8,1.5281e-05_r8/)
      kao(:, 3,11, 7) = (/ &
     &3.1949e+00_r8,2.7955e+00_r8,2.3962e+00_r8,1.9968e+00_r8,1.5975e+00_r8,1.1981e+00_r8, &
     &7.9874e-01_r8,3.9938e-01_r8,2.9166e-05_r8/)
      kao(:, 4,11, 7) = (/ &
     &3.1739e+00_r8,2.7771e+00_r8,2.3804e+00_r8,1.9837e+00_r8,1.5870e+00_r8,1.1902e+00_r8, &
     &7.9350e-01_r8,3.9677e-01_r8,4.9026e-05_r8/)
      kao(:, 5,11, 7) = (/ &
     &3.1466e+00_r8,2.7532e+00_r8,2.3599e+00_r8,1.9666e+00_r8,1.5733e+00_r8,1.1800e+00_r8, &
     &7.8668e-01_r8,3.9338e-01_r8,8.3128e-05_r8/)
      kao(:, 1,12, 7) = (/ &
     &4.8071e+00_r8,4.2062e+00_r8,3.6053e+00_r8,3.0044e+00_r8,2.4035e+00_r8,1.8027e+00_r8, &
     &1.2018e+00_r8,6.0089e-01_r8,7.8311e-06_r8/)
      kao(:, 2,12, 7) = (/ &
     &4.7982e+00_r8,4.1985e+00_r8,3.5987e+00_r8,2.9989e+00_r8,2.3991e+00_r8,1.7993e+00_r8, &
     &1.1996e+00_r8,5.9978e-01_r8,1.6500e-05_r8/)
      kao(:, 3,12, 7) = (/ &
     &4.7853e+00_r8,4.1872e+00_r8,3.5890e+00_r8,2.9909e+00_r8,2.3927e+00_r8,1.7945e+00_r8, &
     &1.1963e+00_r8,5.9818e-01_r8,3.1398e-05_r8/)
      kao(:, 4,12, 7) = (/ &
     &4.7636e+00_r8,4.1682e+00_r8,3.5727e+00_r8,2.9773e+00_r8,2.3818e+00_r8,1.7864e+00_r8, &
     &1.1909e+00_r8,5.9548e-01_r8,5.6315e-05_r8/)
      kao(:, 5,12, 7) = (/ &
     &4.7234e+00_r8,4.1330e+00_r8,3.5426e+00_r8,2.9521e+00_r8,2.3618e+00_r8,1.7713e+00_r8, &
     &1.1809e+00_r8,5.9047e-01_r8,9.4104e-05_r8/)
      kao(:, 1,13, 7) = (/ &
     &5.7320e+00_r8,5.0155e+00_r8,4.2989e+00_r8,3.5824e+00_r8,2.8660e+00_r8,2.1495e+00_r8, &
     &1.4330e+00_r8,7.1649e-01_r8,9.5542e-06_r8/)
      kao(:, 2,13, 7) = (/ &
     &5.7353e+00_r8,5.0184e+00_r8,4.3015e+00_r8,3.5845e+00_r8,2.8676e+00_r8,2.1507e+00_r8, &
     &1.4338e+00_r8,7.1691e-01_r8,1.9109e-05_r8/)
      kao(:, 3,13, 7) = (/ &
     &5.7278e+00_r8,5.0119e+00_r8,4.2959e+00_r8,3.5799e+00_r8,2.8639e+00_r8,2.1479e+00_r8, &
     &1.4320e+00_r8,7.1599e-01_r8,3.6436e-05_r8/)
      kao(:, 4,13, 7) = (/ &
     &5.7108e+00_r8,4.9969e+00_r8,4.2830e+00_r8,3.5692e+00_r8,2.8554e+00_r8,2.1415e+00_r8, &
     &1.4277e+00_r8,7.1386e-01_r8,6.4763e-05_r8/)
      kao(:, 5,13, 7) = (/ &
     &5.6635e+00_r8,4.9556e+00_r8,4.2476e+00_r8,3.5397e+00_r8,2.8317e+00_r8,2.1238e+00_r8, &
     &1.4159e+00_r8,7.0796e-01_r8,1.0153e-04_r8/)
      kao(:, 1, 1, 8) = (/ &
     &5.6440e-05_r8,6.3815e-05_r8,6.7040e-05_r8,7.2656e-05_r8,5.7075e-05_r8,3.5497e-05_r8, &
     &4.7197e-05_r8,3.9064e-05_r8,8.4705e-05_r8/)
      kao(:, 2, 1, 8) = (/ &
     &5.6956e-05_r8,6.9440e-05_r8,7.5002e-05_r8,9.1724e-05_r8,1.1786e-04_r8,1.1581e-04_r8, &
     &7.2124e-05_r8,6.3862e-05_r8,2.0332e-04_r8/)
      kao(:, 3, 1, 8) = (/ &
     &5.4856e-05_r8,7.4835e-05_r8,8.9381e-05_r8,1.1688e-04_r8,1.6480e-04_r8,2.0403e-04_r8, &
     &2.1723e-04_r8,1.2068e-04_r8,2.9982e-04_r8/)
      kao(:, 4, 1, 8) = (/ &
     &5.2749e-05_r8,8.4849e-05_r8,1.1205e-04_r8,1.5064e-04_r8,2.1741e-04_r8,2.8178e-04_r8, &
     &3.3958e-04_r8,3.6475e-04_r8,4.0572e-04_r8/)
      kao(:, 5, 1, 8) = (/ &
     &4.5645e-05_r8,1.0085e-04_r8,1.3954e-04_r8,1.9411e-04_r8,2.8393e-04_r8,3.7289e-04_r8, &
     &4.5784e-04_r8,5.5744e-04_r8,5.3928e-04_r8/)
      kao(:, 1, 2, 8) = (/ &
     &1.0540e-04_r8,1.0513e-04_r8,1.0042e-04_r8,9.6258e-05_r8,8.8970e-05_r8,4.3184e-05_r8, &
     &2.9692e-05_r8,3.3913e-05_r8,8.0284e-05_r8/)
      kao(:, 2, 2, 8) = (/ &
     &1.0559e-04_r8,1.0940e-04_r8,1.0770e-04_r8,1.0381e-04_r8,1.0664e-04_r8,1.1502e-04_r8, &
     &8.1785e-05_r8,5.3525e-05_r8,1.4202e-04_r8/)
      kao(:, 3, 2, 8) = (/ &
     &1.0218e-04_r8,1.1568e-04_r8,1.1773e-04_r8,1.2016e-04_r8,1.3039e-04_r8,1.6512e-04_r8, &
     &1.8884e-04_r8,1.2031e-04_r8,2.0363e-04_r8/)
      kao(:, 4, 2, 8) = (/ &
     &9.8487e-05_r8,1.1922e-04_r8,1.3281e-04_r8,1.4606e-04_r8,1.6549e-04_r8,2.1784e-04_r8, &
     &2.7427e-04_r8,3.0595e-04_r8,2.8029e-04_r8/)
      kao(:, 5, 2, 8) = (/ &
     &9.4987e-05_r8,1.2846e-04_r8,1.5591e-04_r8,1.8268e-04_r8,2.1442e-04_r8,2.8547e-04_r8, &
     &3.6877e-04_r8,4.4657e-04_r8,3.7746e-04_r8/)
      kao(:, 1, 3, 8) = (/ &
     &2.7647e-04_r8,2.5246e-04_r8,2.2770e-04_r8,2.0041e-04_r8,1.7472e-04_r8,1.4681e-04_r8, &
     &4.5677e-05_r8,2.9185e-05_r8,7.9704e-05_r8/)
      kao(:, 2, 3, 8) = (/ &
     &2.7846e-04_r8,2.6060e-04_r8,2.3622e-04_r8,2.0968e-04_r8,1.8322e-04_r8,1.5414e-04_r8, &
     &1.2348e-04_r8,3.8961e-05_r8,1.2336e-04_r8/)
      kao(:, 3, 3, 8) = (/ &
     &2.7763e-04_r8,2.6427e-04_r8,2.4553e-04_r8,2.2406e-04_r8,1.9856e-04_r8,1.7101e-04_r8, &
     &1.5714e-04_r8,1.3645e-04_r8,1.7764e-04_r8/)
      kao(:, 4, 3, 8) = (/ &
     &2.7073e-04_r8,2.6684e-04_r8,2.5482e-04_r8,2.3763e-04_r8,2.1876e-04_r8,2.0158e-04_r8, &
     &1.9981e-04_r8,2.4173e-04_r8,2.4735e-04_r8/)
      kao(:, 5, 3, 8) = (/ &
     &2.6027e-04_r8,2.7336e-04_r8,2.6560e-04_r8,2.5755e-04_r8,2.5236e-04_r8,2.4811e-04_r8, &
     &2.5900e-04_r8,3.3153e-04_r8,3.3717e-04_r8/)
      kao(:, 1, 4, 8) = (/ &
     &7.9130e-04_r8,7.0063e-04_r8,6.1298e-04_r8,5.1987e-04_r8,4.2755e-04_r8,3.3326e-04_r8, &
     &2.3363e-04_r8,3.7051e-05_r8,7.4199e-05_r8/)
      kao(:, 2, 4, 8) = (/ &
     &7.5980e-04_r8,6.7845e-04_r8,5.9445e-04_r8,5.1095e-04_r8,4.1981e-04_r8,3.2923e-04_r8, &
     &2.4168e-04_r8,1.3135e-04_r8,1.1471e-04_r8/)
      kao(:, 3, 4, 8) = (/ &
     &7.6644e-04_r8,6.8984e-04_r8,6.0948e-04_r8,5.2391e-04_r8,4.3682e-04_r8,3.5056e-04_r8, &
     &2.5756e-04_r8,1.6433e-04_r8,1.6687e-04_r8/)
      kao(:, 4, 4, 8) = (/ &
     &7.5595e-04_r8,6.9178e-04_r8,6.1629e-04_r8,5.3601e-04_r8,4.5434e-04_r8,3.7215e-04_r8, &
     &2.8231e-04_r8,1.9566e-04_r8,2.3395e-04_r8/)
      kao(:, 5, 4, 8) = (/ &
     &7.4067e-04_r8,6.8825e-04_r8,6.1664e-04_r8,5.5301e-04_r8,4.7442e-04_r8,3.9621e-04_r8, &
     &3.1512e-04_r8,2.4572e-04_r8,3.2210e-04_r8/)
      kao(:, 1, 5, 8) = (/ &
     &2.0703e-03_r8,1.8139e-03_r8,1.5621e-03_r8,1.3106e-03_r8,1.0600e-03_r8,8.0652e-04_r8, &
     &5.5133e-04_r8,2.9069e-04_r8,6.3670e-05_r8/)
      kao(:, 2, 5, 8) = (/ &
     &1.9818e-03_r8,1.7441e-03_r8,1.5082e-03_r8,1.2728e-03_r8,1.0326e-03_r8,7.9434e-04_r8, &
     &5.4918e-04_r8,2.9978e-04_r8,1.0147e-04_r8/)
      kao(:, 3, 5, 8) = (/ &
     &1.9776e-03_r8,1.7438e-03_r8,1.5149e-03_r8,1.2743e-03_r8,1.0380e-03_r8,7.9656e-04_r8, &
     &5.5670e-04_r8,3.0633e-04_r8,1.5212e-04_r8/)
      kao(:, 4, 5, 8) = (/ &
     &1.9765e-03_r8,1.7561e-03_r8,1.5287e-03_r8,1.2973e-03_r8,1.0616e-03_r8,8.2154e-04_r8, &
     &5.8167e-04_r8,3.3115e-04_r8,2.1510e-04_r8/)
      kao(:, 5, 5, 8) = (/ &
     &1.9526e-03_r8,1.7391e-03_r8,1.5270e-03_r8,1.3031e-03_r8,1.0804e-03_r8,8.4755e-04_r8, &
     &6.0189e-04_r8,3.6102e-04_r8,2.9241e-04_r8/)
      kao(:, 1, 6, 8) = (/ &
     &5.2193e-03_r8,4.5684e-03_r8,3.9176e-03_r8,3.2705e-03_r8,2.6232e-03_r8,1.9766e-03_r8, &
     &1.3309e-03_r8,6.8212e-04_r8,5.1398e-05_r8/)
      kao(:, 2, 6, 8) = (/ &
     &5.0808e-03_r8,4.4486e-03_r8,3.8217e-03_r8,3.1970e-03_r8,2.5720e-03_r8,1.9485e-03_r8, &
     &1.3187e-03_r8,6.8335e-04_r8,8.5267e-05_r8/)
      kao(:, 3, 6, 8) = (/ &
     &4.8228e-03_r8,4.2284e-03_r8,3.6430e-03_r8,3.0578e-03_r8,2.4711e-03_r8,1.8742e-03_r8, &
     &1.2774e-03_r8,6.7264e-04_r8,1.3245e-04_r8/)
      kao(:, 4, 6, 8) = (/ &
     &4.8943e-03_r8,4.3003e-03_r8,3.7080e-03_r8,3.1199e-03_r8,2.5213e-03_r8,1.9154e-03_r8, &
     &1.3062e-03_r8,6.9055e-04_r8,1.9661e-04_r8/)
      kao(:, 5, 6, 8) = (/ &
     &4.8824e-03_r8,4.3025e-03_r8,3.7232e-03_r8,3.1333e-03_r8,2.5429e-03_r8,1.9512e-03_r8, &
     &1.3415e-03_r8,7.2251e-04_r8,2.7802e-04_r8/)
      kao(:, 1, 7, 8) = (/ &
     &1.3875e-02_r8,1.2141e-02_r8,1.0408e-02_r8,8.6749e-03_r8,6.9418e-03_r8,5.2118e-03_r8, &
     &3.4839e-03_r8,1.7560e-03_r8,4.0537e-05_r8/)
      kao(:, 2, 7, 8) = (/ &
     &1.3633e-02_r8,1.1931e-02_r8,1.0229e-02_r8,8.5279e-03_r8,6.8346e-03_r8,5.1400e-03_r8, &
     &3.4444e-03_r8,1.7477e-03_r8,6.8687e-05_r8/)
      kao(:, 3, 7, 8) = (/ &
     &1.3328e-02_r8,1.1666e-02_r8,1.0007e-02_r8,8.3587e-03_r8,6.7074e-03_r8,5.0533e-03_r8, &
     &3.4014e-03_r8,1.7372e-03_r8,1.1189e-04_r8/)
      kao(:, 4, 7, 8) = (/ &
     &1.2636e-02_r8,1.1066e-02_r8,9.5081e-03_r8,7.9486e-03_r8,6.3850e-03_r8,4.8258e-03_r8, &
     &3.2564e-03_r8,1.6750e-03_r8,1.7143e-04_r8/)
      kao(:, 5, 7, 8) = (/ &
     &1.2752e-02_r8,1.1174e-02_r8,9.6135e-03_r8,8.0399e-03_r8,6.4759e-03_r8,4.9028e-03_r8, &
     &3.3183e-03_r8,1.7153e-03_r8,2.5158e-04_r8/)
      kao(:, 1, 8, 8) = (/ &
     &4.6547e-02_r8,4.0730e-02_r8,3.4913e-02_r8,2.9095e-02_r8,2.3277e-02_r8,1.7460e-02_r8, &
     &1.1642e-02_r8,5.8282e-03_r8,3.2784e-05_r8/)
      kao(:, 2, 8, 8) = (/ &
     &4.5721e-02_r8,4.0008e-02_r8,3.4294e-02_r8,2.8581e-02_r8,2.2868e-02_r8,1.7154e-02_r8, &
     &1.1445e-02_r8,5.7448e-03_r8,5.6960e-05_r8/)
      kao(:, 3, 8, 8) = (/ &
     &4.4866e-02_r8,3.9261e-02_r8,3.3657e-02_r8,2.8053e-02_r8,2.2449e-02_r8,1.6850e-02_r8, &
     &1.1263e-02_r8,5.6659e-03_r8,9.3969e-05_r8/)
      kao(:, 4, 8, 8) = (/ &
     &4.3949e-02_r8,3.8462e-02_r8,3.2975e-02_r8,2.7489e-02_r8,2.2013e-02_r8,1.6548e-02_r8, &
     &1.1065e-02_r8,5.5874e-03_r8,1.4907e-04_r8/)
      kao(:, 5, 8, 8) = (/ &
     &4.1860e-02_r8,3.6641e-02_r8,3.1420e-02_r8,2.6211e-02_r8,2.1011e-02_r8,1.5788e-02_r8, &
     &1.0584e-02_r8,5.3726e-03_r8,2.2697e-04_r8/)
      kao(:, 1, 9, 8) = (/ &
     &2.9682e-01_r8,2.5971e-01_r8,2.2262e-01_r8,1.8551e-01_r8,1.4841e-01_r8,1.1131e-01_r8, &
     &7.4208e-02_r8,3.7107e-02_r8,2.8713e-05_r8/)
      kao(:, 2, 9, 8) = (/ &
     &2.9173e-01_r8,2.5526e-01_r8,2.1881e-01_r8,1.8234e-01_r8,1.4587e-01_r8,1.0941e-01_r8, &
     &7.2941e-02_r8,3.6477e-02_r8,5.3026e-05_r8/)
      kao(:, 3, 9, 8) = (/ &
     &2.8647e-01_r8,2.5066e-01_r8,2.1486e-01_r8,1.7905e-01_r8,1.4325e-01_r8,1.0744e-01_r8, &
     &7.1634e-02_r8,3.5829e-02_r8,9.1273e-05_r8/)
      kao(:, 4, 9, 8) = (/ &
     &2.8100e-01_r8,2.4588e-01_r8,2.1076e-01_r8,1.7564e-01_r8,1.4052e-01_r8,1.0540e-01_r8, &
     &7.0282e-02_r8,3.5177e-02_r8,1.4937e-04_r8/)
      kao(:, 5, 9, 8) = (/ &
     &2.7385e-01_r8,2.3963e-01_r8,2.0540e-01_r8,1.7118e-01_r8,1.3696e-01_r8,1.0274e-01_r8, &
     &6.8516e-02_r8,3.4350e-02_r8,2.3011e-04_r8/)
      kao(:, 1,10, 8) = (/ &
     &2.2461e+00_r8,1.9654e+00_r8,1.6846e+00_r8,1.4038e+00_r8,1.1231e+00_r8,8.4230e-01_r8, &
     &5.6154e-01_r8,2.8077e-01_r8,2.2240e-05_r8/)
      kao(:, 2,10, 8) = (/ &
     &2.2106e+00_r8,1.9343e+00_r8,1.6579e+00_r8,1.3816e+00_r8,1.1053e+00_r8,8.2897e-01_r8, &
     &5.5265e-01_r8,2.7633e-01_r8,4.4575e-05_r8/)
      kao(:, 3,10, 8) = (/ &
     &2.1737e+00_r8,1.9020e+00_r8,1.6303e+00_r8,1.3586e+00_r8,1.0869e+00_r8,8.1516e-01_r8, &
     &5.4345e-01_r8,2.7173e-01_r8,8.8587e-05_r8/)
      kao(:, 4,10, 8) = (/ &
     &2.1348e+00_r8,1.8680e+00_r8,1.6011e+00_r8,1.3342e+00_r8,1.0674e+00_r8,8.0056e-01_r8, &
     &5.3373e-01_r8,2.6688e-01_r8,1.5800e-04_r8/)
      kao(:, 5,10, 8) = (/ &
     &2.0952e+00_r8,1.8333e+00_r8,1.5714e+00_r8,1.3095e+00_r8,1.0476e+00_r8,7.8572e-01_r8, &
     &5.2383e-01_r8,2.6194e-01_r8,2.5854e-04_r8/)
      kao(:, 1,11, 8) = (/ &
     &5.6263e+00_r8,4.9230e+00_r8,4.2197e+00_r8,3.5164e+00_r8,2.8132e+00_r8,2.1099e+00_r8, &
     &1.4066e+00_r8,7.0330e-01_r8,2.4215e-05_r8/)
      kao(:, 2,11, 8) = (/ &
     &5.5442e+00_r8,4.8512e+00_r8,4.1582e+00_r8,3.4652e+00_r8,2.7721e+00_r8,2.0791e+00_r8, &
     &1.3861e+00_r8,6.9304e-01_r8,5.0673e-05_r8/)
      kao(:, 3,11, 8) = (/ &
     &5.4573e+00_r8,4.7752e+00_r8,4.0930e+00_r8,3.4108e+00_r8,2.7286e+00_r8,2.0465e+00_r8, &
     &1.3643e+00_r8,6.8218e-01_r8,9.6231e-05_r8/)
      kao(:, 4,11, 8) = (/ &
     &5.3719e+00_r8,4.7004e+00_r8,4.0290e+00_r8,3.3575e+00_r8,2.6860e+00_r8,2.0145e+00_r8, &
     &1.3430e+00_r8,6.7153e-01_r8,1.7007e-04_r8/)
      kao(:, 5,11, 8) = (/ &
     &5.2804e+00_r8,4.6204e+00_r8,3.9603e+00_r8,3.3002e+00_r8,2.6402e+00_r8,1.9802e+00_r8, &
     &1.3201e+00_r8,6.6009e-01_r8,2.7665e-04_r8/)
      kao(:, 1,12, 8) = (/ &
     &8.8343e+00_r8,7.7300e+00_r8,6.6256e+00_r8,5.5214e+00_r8,4.4171e+00_r8,3.3128e+00_r8, &
     &2.2085e+00_r8,1.1043e+00_r8,2.5372e-05_r8/)
      kao(:, 2,12, 8) = (/ &
     &8.7174e+00_r8,7.6278e+00_r8,6.5381e+00_r8,5.4484e+00_r8,4.3587e+00_r8,3.2690e+00_r8, &
     &2.1794e+00_r8,1.0897e+00_r8,5.2642e-05_r8/)
      kao(:, 3,12, 8) = (/ &
     &8.5962e+00_r8,7.5216e+00_r8,6.4471e+00_r8,5.3726e+00_r8,4.2981e+00_r8,3.2236e+00_r8, &
     &2.1490e+00_r8,1.0745e+00_r8,9.9934e-05_r8/)
      kao(:, 4,12, 8) = (/ &
     &8.4730e+00_r8,7.4139e+00_r8,6.3547e+00_r8,5.2956e+00_r8,4.2365e+00_r8,3.1774e+00_r8, &
     &2.1183e+00_r8,1.0591e+00_r8,1.7486e-04_r8/)
      kao(:, 5,12, 8) = (/ &
     &8.3427e+00_r8,7.2999e+00_r8,6.2571e+00_r8,5.2142e+00_r8,4.1714e+00_r8,3.1285e+00_r8, &
     &2.0857e+00_r8,1.0429e+00_r8,2.8225e-04_r8/)
      kao(:, 1,13, 8) = (/ &
     &1.1088e+01_r8,9.7019e+00_r8,8.3159e+00_r8,6.9299e+00_r8,5.5439e+00_r8,4.1579e+00_r8, &
     &2.7720e+00_r8,1.3860e+00_r8,2.2843e-05_r8/)
      kao(:, 2,13, 8) = (/ &
     &1.0963e+01_r8,9.5924e+00_r8,8.2220e+00_r8,6.8518e+00_r8,5.4814e+00_r8,4.1110e+00_r8, &
     &2.7407e+00_r8,1.3703e+00_r8,4.7912e-05_r8/)
      kao(:, 3,13, 8) = (/ &
     &1.0836e+01_r8,9.4815e+00_r8,8.1269e+00_r8,6.7725e+00_r8,5.4179e+00_r8,4.0635e+00_r8, &
     &2.7090e+00_r8,1.3545e+00_r8,9.1850e-05_r8/)
      kao(:, 4,13, 8) = (/ &
     &1.0705e+01_r8,9.3666e+00_r8,8.0284e+00_r8,6.6904e+00_r8,5.3523e+00_r8,4.0142e+00_r8, &
     &2.6761e+00_r8,1.3381e+00_r8,1.6522e-04_r8/)
      kao(:, 5,13, 8) = (/ &
     &1.0568e+01_r8,9.2475e+00_r8,7.9263e+00_r8,6.6053e+00_r8,5.2842e+00_r8,3.9632e+00_r8, &
     &2.6421e+00_r8,1.3211e+00_r8,2.8269e-04_r8/)
      kao(:, 1, 1, 9) = (/ &
     &6.2917e-05_r8,8.4558e-05_r8,1.3686e-04_r8,1.9740e-04_r8,2.4967e-04_r8,2.7515e-04_r8, &
     &1.6338e-04_r8,4.8223e-05_r8,4.6728e-04_r8/)
      kao(:, 2, 1, 9) = (/ &
     &5.3089e-05_r8,9.0420e-05_r8,1.8251e-04_r8,2.7670e-04_r8,3.5886e-04_r8,4.3834e-04_r8, &
     &4.9477e-04_r8,2.3929e-04_r8,6.8730e-04_r8/)
      kao(:, 3, 1, 9) = (/ &
     &4.3039e-05_r8,1.0946e-04_r8,2.4429e-04_r8,3.7961e-04_r8,4.9689e-04_r8,6.1288e-04_r8, &
     &7.2274e-04_r8,7.7240e-04_r8,9.6431e-04_r8/)
      kao(:, 4, 1, 9) = (/ &
     &3.4069e-05_r8,1.3830e-04_r8,3.2177e-04_r8,5.0878e-04_r8,6.6994e-04_r8,8.2945e-04_r8, &
     &9.8413e-04_r8,1.1125e-03_r8,1.3109e-03_r8/)
      kao(:, 5, 1, 9) = (/ &
     &3.0399e-05_r8,1.7548e-04_r8,4.1760e-04_r8,6.6731e-04_r8,8.8167e-04_r8,1.0941e-03_r8, &
     &1.3015e-03_r8,1.4854e-03_r8,1.7348e-03_r8/)
      kao(:, 1, 2, 9) = (/ &
     &1.1900e-04_r8,1.2836e-04_r8,1.4231e-04_r8,1.8014e-04_r8,2.2526e-04_r8,2.6329e-04_r8, &
     &2.2981e-04_r8,4.7447e-05_r8,3.9923e-04_r8/)
      kao(:, 2, 2, 9) = (/ &
     &1.1384e-04_r8,1.2703e-04_r8,1.6170e-04_r8,2.3947e-04_r8,3.1945e-04_r8,3.8888e-04_r8, &
     &4.4936e-04_r8,3.6063e-04_r8,5.9020e-04_r8/)
      kao(:, 3, 2, 9) = (/ &
     &9.6344e-05_r8,1.3540e-04_r8,2.0202e-04_r8,3.2063e-04_r8,4.4367e-04_r8,5.4566e-04_r8, &
     &6.4489e-04_r8,7.2550e-04_r8,8.3580e-04_r8/)
      kao(:, 4, 2, 9) = (/ &
     &7.7835e-05_r8,1.6099e-04_r8,2.5994e-04_r8,4.2610e-04_r8,6.0189e-04_r8,7.4414e-04_r8, &
     &8.8531e-04_r8,1.0210e-03_r8,1.1481e-03_r8/)
      kao(:, 5, 2, 9) = (/ &
     &6.0959e-05_r8,1.9625e-04_r8,3.3515e-04_r8,5.6029e-04_r8,7.9618e-04_r8,9.9092e-04_r8, &
     &1.1822e-03_r8,1.3661e-03_r8,1.5393e-03_r8/)
      kao(:, 1, 3, 9) = (/ &
     &3.4384e-04_r8,3.1901e-04_r8,2.9656e-04_r8,2.7161e-04_r8,2.4956e-04_r8,2.4575e-04_r8, &
     &2.4892e-04_r8,1.2874e-04_r8,2.5500e-04_r8/)
      kao(:, 2, 3, 9) = (/ &
     &3.2651e-04_r8,2.9987e-04_r8,2.8407e-04_r8,2.6822e-04_r8,2.8382e-04_r8,3.2698e-04_r8, &
     &3.7690e-04_r8,3.8984e-04_r8,3.8097e-04_r8/)
      kao(:, 3, 3, 9) = (/ &
     &3.1133e-04_r8,2.9825e-04_r8,2.8892e-04_r8,2.8983e-04_r8,3.4857e-04_r8,4.4151e-04_r8, &
     &5.3596e-04_r8,6.0662e-04_r8,5.5422e-04_r8/)
      kao(:, 4, 3, 9) = (/ &
     &2.6650e-04_r8,2.9032e-04_r8,3.1626e-04_r8,3.4521e-04_r8,4.5449e-04_r8,5.9386e-04_r8, &
     &7.4052e-04_r8,8.5104e-04_r8,7.8265e-04_r8/)
      kao(:, 5, 3, 9) = (/ &
     &2.2412e-04_r8,2.9039e-04_r8,3.7283e-04_r8,4.3223e-04_r8,5.9364e-04_r8,7.9041e-04_r8, &
     &9.9696e-04_r8,1.1553e-03_r8,1.0705e-03_r8/)
      kao(:, 1, 4, 9) = (/ &
     &1.0105e-03_r8,8.9198e-04_r8,7.7732e-04_r8,6.6567e-04_r8,5.5452e-04_r8,4.4086e-04_r8, &
     &3.2869e-04_r8,1.9418e-04_r8,1.7212e-04_r8/)
      kao(:, 2, 4, 9) = (/ &
     &9.2169e-04_r8,8.2421e-04_r8,7.2924e-04_r8,6.3857e-04_r8,5.4763e-04_r8,4.5198e-04_r8, &
     &3.7244e-04_r8,3.3779e-04_r8,2.7365e-04_r8/)
      kao(:, 3, 4, 9) = (/ &
     &9.1340e-04_r8,8.1831e-04_r8,7.2882e-04_r8,6.3523e-04_r8,5.3088e-04_r8,4.5658e-04_r8, &
     &4.4489e-04_r8,4.8577e-04_r8,4.2302e-04_r8/)
      kao(:, 4, 4, 9) = (/ &
     &8.9251e-04_r8,8.0269e-04_r8,7.3471e-04_r8,6.4402e-04_r8,5.5905e-04_r8,5.1386e-04_r8, &
     &5.6577e-04_r8,6.8086e-04_r8,6.2344e-04_r8/)
      kao(:, 5, 4, 9) = (/ &
     &7.9475e-04_r8,7.3797e-04_r8,7.1362e-04_r8,6.7001e-04_r8,6.3957e-04_r8,6.1730e-04_r8, &
     &7.4587e-04_r8,9.2826e-04_r8,8.7756e-04_r8/)
      kao(:, 1, 5, 9) = (/ &
     &2.6935e-03_r8,2.3593e-03_r8,2.0323e-03_r8,1.7047e-03_r8,1.3798e-03_r8,1.0522e-03_r8, &
     &7.2780e-04_r8,3.9954e-04_r8,1.6653e-04_r8/)
      kao(:, 2, 5, 9) = (/ &
     &2.6191e-03_r8,2.2983e-03_r8,1.9871e-03_r8,1.6780e-03_r8,1.3636e-03_r8,1.0535e-03_r8, &
     &7.4346e-04_r8,4.3038e-04_r8,2.6682e-04_r8/)
      kao(:, 3, 5, 9) = (/ &
     &2.3650e-03_r8,2.0866e-03_r8,1.8132e-03_r8,1.5443e-03_r8,1.2810e-03_r8,1.0093e-03_r8, &
     &7.2606e-04_r8,4.8378e-04_r8,4.1282e-04_r8/)
      kao(:, 4, 5, 9) = (/ &
     &2.4014e-03_r8,2.1168e-03_r8,1.8401e-03_r8,1.5793e-03_r8,1.3157e-03_r8,1.0190e-03_r8, &
     &7.3809e-04_r8,5.7085e-04_r8,6.1502e-04_r8/)
      kao(:, 5, 5, 9) = (/ &
     &2.3689e-03_r8,2.1027e-03_r8,1.8524e-03_r8,1.6218e-03_r8,1.3262e-03_r8,1.0531e-03_r8, &
     &8.0904e-04_r8,7.1684e-04_r8,8.8985e-04_r8/)
      kao(:, 1, 6, 9) = (/ &
     &6.9308e-03_r8,6.0665e-03_r8,5.2022e-03_r8,4.3390e-03_r8,3.4845e-03_r8,2.6255e-03_r8, &
     &1.7705e-03_r8,9.1297e-04_r8,1.4507e-04_r8/)
      kao(:, 2, 6, 9) = (/ &
     &6.7707e-03_r8,5.9271e-03_r8,5.0849e-03_r8,4.2542e-03_r8,3.4202e-03_r8,2.5899e-03_r8, &
     &1.7563e-03_r8,9.2722e-04_r8,2.4197e-04_r8/)
      kao(:, 3, 6, 9) = (/ &
     &6.6111e-03_r8,5.7877e-03_r8,4.9821e-03_r8,4.1734e-03_r8,3.3664e-03_r8,2.5641e-03_r8, &
     &1.7626e-03_r8,9.4198e-04_r8,3.8026e-04_r8/)
      kao(:, 4, 6, 9) = (/ &
     &6.0438e-03_r8,5.3003e-03_r8,4.5745e-03_r8,3.8441e-03_r8,3.1111e-03_r8,2.3922e-03_r8, &
     &1.6672e-03_r8,9.3430e-04_r8,5.5692e-04_r8/)
      kao(:, 5, 6, 9) = (/ &
     &6.1335e-03_r8,5.3879e-03_r8,4.6501e-03_r8,3.9141e-03_r8,3.1883e-03_r8,2.4602e-03_r8, &
     &1.7143e-03_r8,9.6080e-04_r8,7.9260e-04_r8/)
      kao(:, 1, 7, 9) = (/ &
     &1.9047e-02_r8,1.6668e-02_r8,1.4288e-02_r8,1.1909e-02_r8,9.5299e-03_r8,7.1507e-03_r8, &
     &4.7825e-03_r8,2.4097e-03_r8,1.1330e-04_r8/)
      kao(:, 2, 7, 9) = (/ &
     &1.8614e-02_r8,1.6290e-02_r8,1.3965e-02_r8,1.1641e-02_r8,9.3171e-03_r8,7.0086e-03_r8, &
     &4.6932e-03_r8,2.3827e-03_r8,1.9275e-04_r8/)
      kao(:, 3, 7, 9) = (/ &
     &1.8191e-02_r8,1.5921e-02_r8,1.3650e-02_r8,1.1382e-02_r8,9.1322e-03_r8,6.8769e-03_r8, &
     &4.6246e-03_r8,2.3704e-03_r8,3.0881e-04_r8/)
      kao(:, 4, 7, 9) = (/ &
     &1.7657e-02_r8,1.5455e-02_r8,1.3252e-02_r8,1.1078e-02_r8,8.8961e-03_r8,6.7169e-03_r8, &
     &4.5330e-03_r8,2.3676e-03_r8,4.7256e-04_r8/)
      kao(:, 5, 7, 9) = (/ &
     &1.6605e-02_r8,1.4537e-02_r8,1.2495e-02_r8,1.0448e-02_r8,8.3949e-03_r8,6.3348e-03_r8, &
     &4.3112e-03_r8,2.2623e-03_r8,7.0061e-04_r8/)
      kao(:, 1, 8, 9) = (/ &
     &6.6522e-02_r8,5.8208e-02_r8,4.9894e-02_r8,4.1580e-02_r8,3.3266e-02_r8,2.4952e-02_r8, &
     &1.6638e-02_r8,8.3237e-03_r8,8.8556e-05_r8/)
      kao(:, 2, 8, 9) = (/ &
     &6.5331e-02_r8,5.7166e-02_r8,4.9002e-02_r8,4.0837e-02_r8,3.2672e-02_r8,2.4508e-02_r8, &
     &1.6344e-02_r8,8.1975e-03_r8,1.5988e-04_r8/)
      kao(:, 3, 8, 9) = (/ &
     &6.4113e-02_r8,5.6102e-02_r8,4.8090e-02_r8,4.0078e-02_r8,3.2067e-02_r8,2.4056e-02_r8, &
     &1.6062e-02_r8,8.0735e-03_r8,2.6393e-04_r8/)
      kao(:, 4, 8, 9) = (/ &
     &6.2675e-02_r8,5.4844e-02_r8,4.7014e-02_r8,3.9184e-02_r8,3.1353e-02_r8,2.3542e-02_r8, &
     &1.5747e-02_r8,7.9493e-03_r8,4.0578e-04_r8/)
      kao(:, 5, 8, 9) = (/ &
     &6.0829e-02_r8,5.3229e-02_r8,4.5632e-02_r8,3.8033e-02_r8,3.0464e-02_r8,2.2925e-02_r8, &
     &1.5354e-02_r8,7.7739e-03_r8,6.0582e-04_r8/)
      kao(:, 1, 9, 9) = (/ &
     &4.4562e-01_r8,3.8992e-01_r8,3.3422e-01_r8,2.7852e-01_r8,2.2281e-01_r8,1.6711e-01_r8, &
     &1.1141e-01_r8,5.5708e-02_r8,6.4708e-05_r8/)
      kao(:, 2, 9, 9) = (/ &
     &4.3840e-01_r8,3.8360e-01_r8,3.2881e-01_r8,2.7401e-01_r8,2.1921e-01_r8,1.6441e-01_r8, &
     &1.0961e-01_r8,5.4811e-02_r8,1.2246e-04_r8/)
      kao(:, 3, 9, 9) = (/ &
     &4.3101e-01_r8,3.7714e-01_r8,3.2326e-01_r8,2.6939e-01_r8,2.1551e-01_r8,1.6164e-01_r8, &
     &1.0777e-01_r8,5.3892e-02_r8,2.1404e-04_r8/)
      kao(:, 4, 9, 9) = (/ &
     &4.2341e-01_r8,3.7048e-01_r8,3.1756e-01_r8,2.6464e-01_r8,2.1171e-01_r8,1.5879e-01_r8, &
     &1.0587e-01_r8,5.2950e-02_r8,3.4919e-04_r8/)
      kao(:, 5, 9, 9) = (/ &
     &4.1490e-01_r8,3.6305e-01_r8,3.1119e-01_r8,2.5933e-01_r8,2.0748e-01_r8,1.5561e-01_r8, &
     &1.0376e-01_r8,5.1933e-02_r8,5.3978e-04_r8/)
      kao(:, 1,10, 9) = (/ &
     &3.5739e+00_r8,3.1272e+00_r8,2.6804e+00_r8,2.2337e+00_r8,1.7870e+00_r8,1.3402e+00_r8, &
     &8.9349e-01_r8,4.4675e-01_r8,3.6923e-05_r8/)
      kao(:, 2,10, 9) = (/ &
     &3.5173e+00_r8,3.0777e+00_r8,2.6381e+00_r8,2.1983e+00_r8,1.7587e+00_r8,1.3190e+00_r8, &
     &8.7936e-01_r8,4.3968e-01_r8,7.4734e-05_r8/)
      kao(:, 3,10, 9) = (/ &
     &3.4601e+00_r8,3.0276e+00_r8,2.5951e+00_r8,2.1626e+00_r8,1.7301e+00_r8,1.2976e+00_r8, &
     &8.6506e-01_r8,4.3253e-01_r8,1.2645e-04_r8/)
      kao(:, 4,10, 9) = (/ &
     &3.4013e+00_r8,2.9762e+00_r8,2.5510e+00_r8,2.1258e+00_r8,1.7007e+00_r8,1.2755e+00_r8, &
     &8.5034e-01_r8,4.2518e-01_r8,2.0434e-04_r8/)
      kao(:, 5,10, 9) = (/ &
     &3.3408e+00_r8,2.9231e+00_r8,2.5056e+00_r8,2.0880e+00_r8,1.6704e+00_r8,1.2528e+00_r8, &
     &8.3521e-01_r8,4.1763e-01_r8,3.0930e-04_r8/)
      kao(:, 1,11, 9) = (/ &
     &9.5423e+00_r8,8.3495e+00_r8,7.1567e+00_r8,5.9639e+00_r8,4.7712e+00_r8,3.5784e+00_r8, &
     &2.3856e+00_r8,1.1928e+00_r8,3.3494e-05_r8/)
      kao(:, 2,11, 9) = (/ &
     &9.3929e+00_r8,8.2188e+00_r8,7.0447e+00_r8,5.8706e+00_r8,4.6965e+00_r8,3.5224e+00_r8, &
     &2.3483e+00_r8,1.1741e+00_r8,6.4875e-05_r8/)
      kao(:, 3,11, 9) = (/ &
     &9.2404e+00_r8,8.0853e+00_r8,6.9303e+00_r8,5.7752e+00_r8,4.6202e+00_r8,3.4651e+00_r8, &
     &2.3101e+00_r8,1.1551e+00_r8,1.1378e-04_r8/)
      kao(:, 4,11, 9) = (/ &
     &9.0863e+00_r8,7.9506e+00_r8,6.8148e+00_r8,5.6790e+00_r8,4.5432e+00_r8,3.4074e+00_r8, &
     &2.2716e+00_r8,1.1358e+00_r8,1.8195e-04_r8/)
      kao(:, 5,11, 9) = (/ &
     &8.9334e+00_r8,7.8167e+00_r8,6.7001e+00_r8,5.5834e+00_r8,4.4668e+00_r8,3.3501e+00_r8, &
     &2.2334e+00_r8,1.1167e+00_r8,2.6874e-04_r8/)
      kao(:, 1,12, 9) = (/ &
     &1.6018e+01_r8,1.4016e+01_r8,1.2013e+01_r8,1.0011e+01_r8,8.0089e+00_r8,6.0065e+00_r8, &
     &4.0043e+00_r8,2.0022e+00_r8,3.3227e-05_r8/)
      kao(:, 2,12, 9) = (/ &
     &1.5778e+01_r8,1.3806e+01_r8,1.1834e+01_r8,9.8614e+00_r8,7.8892e+00_r8,5.9169e+00_r8, &
     &3.9446e+00_r8,1.9723e+00_r8,6.4843e-05_r8/)
      kao(:, 3,12, 9) = (/ &
     &1.5536e+01_r8,1.3594e+01_r8,1.1652e+01_r8,9.7100e+00_r8,7.7679e+00_r8,5.8260e+00_r8, &
     &3.8840e+00_r8,1.9420e+00_r8,1.1290e-04_r8/)
      kao(:, 4,12, 9) = (/ &
     &1.5292e+01_r8,1.3380e+01_r8,1.1469e+01_r8,9.5575e+00_r8,7.6460e+00_r8,5.7344e+00_r8, &
     &3.8230e+00_r8,1.9115e+00_r8,1.7636e-04_r8/)
      kao(:, 5,12, 9) = (/ &
     &1.5044e+01_r8,1.3163e+01_r8,1.1283e+01_r8,9.4022e+00_r8,7.5218e+00_r8,5.6414e+00_r8, &
     &3.7609e+00_r8,1.8805e+00_r8,2.6723e-04_r8/)
      kao(:, 1,13, 9) = (/ &
     &2.1597e+01_r8,1.8897e+01_r8,1.6197e+01_r8,1.3498e+01_r8,1.0798e+01_r8,8.0986e+00_r8, &
     &5.3991e+00_r8,2.6995e+00_r8,3.8904e-05_r8/)
      kao(:, 2,13, 9) = (/ &
     &2.1295e+01_r8,1.8633e+01_r8,1.5971e+01_r8,1.3309e+01_r8,1.0647e+01_r8,7.9855e+00_r8, &
     &5.3237e+00_r8,2.6618e+00_r8,7.5857e-05_r8/)
      kao(:, 3,13, 9) = (/ &
     &2.0989e+01_r8,1.8366e+01_r8,1.5742e+01_r8,1.3118e+01_r8,1.0494e+01_r8,7.8710e+00_r8, &
     &5.2472e+00_r8,2.6236e+00_r8,1.3015e-04_r8/)
      kao(:, 4,13, 9) = (/ &
     &2.0668e+01_r8,1.8085e+01_r8,1.5501e+01_r8,1.2918e+01_r8,1.0334e+01_r8,7.7506e+00_r8, &
     &5.1670e+00_r8,2.5835e+00_r8,2.0228e-04_r8/)
      kao(:, 5,13, 9) = (/ &
     &2.0333e+01_r8,1.7791e+01_r8,1.5249e+01_r8,1.2708e+01_r8,1.0166e+01_r8,7.6247e+00_r8, &
     &5.0831e+00_r8,2.5416e+00_r8,2.9840e-04_r8/)
      kao(:, 1, 1,10) = (/ &
     &5.6592e-05_r8,1.3380e-04_r8,2.8259e-04_r8,4.0725e-04_r8,5.2722e-04_r8,6.3771e-04_r8, &
     &7.3618e-04_r8,6.8809e-05_r8,1.0230e-03_r8/)
      kao(:, 2, 1,10) = (/ &
     &3.4000e-05_r8,1.7762e-04_r8,3.9282e-04_r8,5.7189e-04_r8,7.4744e-04_r8,9.1578e-04_r8, &
     &1.0739e-03_r8,1.1530e-03_r8,1.4652e-03_r8/)
      kao(:, 3, 1,10) = (/ &
     &3.1822e-05_r8,2.4313e-04_r8,5.2738e-04_r8,7.7595e-04_r8,1.0231e-03_r8,1.2640e-03_r8, &
     &1.5000e-03_r8,1.6967e-03_r8,2.0181e-03_r8/)
      kao(:, 4, 1,10) = (/ &
     &3.1887e-05_r8,3.1730e-04_r8,7.0142e-04_r8,1.0376e-03_r8,1.3716e-03_r8,1.7032e-03_r8, &
     &2.0256e-03_r8,2.3355e-03_r8,2.7159e-03_r8/)
      kao(:, 5, 1,10) = (/ &
     &3.2974e-05_r8,4.0500e-04_r8,9.2096e-04_r8,1.3701e-03_r8,1.8162e-03_r8,2.2594e-03_r8, &
     &2.6867e-03_r8,3.0973e-03_r8,3.6043e-03_r8/)
      kao(:, 1, 2,10) = (/ &
     &1.2846e-04_r8,1.5522e-04_r8,2.7655e-04_r8,3.8379e-04_r8,4.9079e-04_r8,5.9529e-04_r8, &
     &6.9141e-04_r8,5.6796e-04_r8,9.2767e-04_r8/)
      kao(:, 2, 2,10) = (/ &
     &6.5990e-05_r8,1.6552e-04_r8,3.7419e-04_r8,5.3648e-04_r8,6.9689e-04_r8,8.5375e-04_r8, &
     &1.0031e-03_r8,1.1095e-03_r8,1.3393e-03_r8/)
      kao(:, 3, 2,10) = (/ &
     &5.6435e-05_r8,1.5534e-04_r8,5.0363e-04_r8,7.3034e-04_r8,9.5369e-04_r8,1.1711e-03_r8, &
     &1.3827e-03_r8,1.5608e-03_r8,1.8461e-03_r8/)
      kao(:, 4, 2,10) = (/ &
     &5.4174e-05_r8,1.7810e-04_r8,6.6905e-04_r8,9.7686e-04_r8,1.2783e-03_r8,1.5737e-03_r8, &
     &1.8611e-03_r8,2.1178e-03_r8,2.4942e-03_r8/)
      kao(:, 5, 2,10) = (/ &
     &5.2370e-05_r8,1.9597e-04_r8,8.6044e-04_r8,1.2706e-03_r8,1.6729e-03_r8,2.0703e-03_r8, &
     &2.4603e-03_r8,2.8342e-03_r8,3.2918e-03_r8/)
      kao(:, 1, 3,10) = (/ &
     &4.4469e-04_r8,4.0346e-04_r8,3.7124e-04_r8,3.9072e-04_r8,4.6265e-04_r8,5.3518e-04_r8, &
     &6.0670e-04_r8,6.5723e-04_r8,7.6901e-04_r8/)
      kao(:, 2, 3,10) = (/ &
     &2.7821e-04_r8,2.8769e-04_r8,3.4636e-04_r8,4.5772e-04_r8,6.3733e-04_r8,7.5575e-04_r8, &
     &8.7290e-04_r8,9.7779e-04_r8,1.1248e-03_r8/)
      kao(:, 3, 3,10) = (/ &
     &1.6712e-04_r8,2.0135e-04_r8,3.1664e-04_r8,6.0259e-04_r8,8.6177e-04_r8,1.0373e-03_r8, &
     &1.2106e-03_r8,1.3752e-03_r8,1.5723e-03_r8/)
      kao(:, 4, 3,10) = (/ &
     &1.5303e-04_r8,2.3452e-04_r8,3.6629e-04_r8,7.9270e-04_r8,1.1535e-03_r8,1.4036e-03_r8, &
     &1.6498e-03_r8,1.8820e-03_r8,2.1596e-03_r8/)
      kao(:, 5, 3,10) = (/ &
     &1.4546e-04_r8,2.9515e-04_r8,4.4927e-04_r8,1.0579e-03_r8,1.5163e-03_r8,1.8612e-03_r8, &
     &2.1985e-03_r8,2.5140e-03_r8,2.9016e-03_r8/)
      kao(:, 1, 4,10) = (/ &
     &1.2138e-03_r8,1.0643e-03_r8,9.4070e-04_r8,8.1504e-04_r8,7.0358e-04_r8,5.9316e-04_r8, &
     &5.5104e-04_r8,5.6438e-04_r8,3.2078e-04_r8/)
      kao(:, 2, 4,10) = (/ &
     &1.1514e-03_r8,1.0125e-03_r8,9.4071e-04_r8,8.3600e-04_r8,7.4220e-04_r8,6.5907e-04_r8, &
     &7.7143e-04_r8,8.3267e-04_r8,4.7891e-04_r8/)
      kao(:, 3, 4,10) = (/ &
     &8.3276e-04_r8,7.0376e-04_r8,7.1208e-04_r8,6.8052e-04_r8,7.6194e-04_r8,8.9019e-04_r8, &
     &1.0682e-03_r8,1.1778e-03_r8,6.1825e-04_r8/)
      kao(:, 4, 4,10) = (/ &
     &6.2678e-04_r8,5.3178e-04_r8,5.1712e-04_r8,6.2090e-04_r8,7.5690e-04_r8,1.1872e-03_r8, &
     &1.4563e-03_r8,1.6302e-03_r8,8.5537e-04_r8/)
      kao(:, 5, 4,10) = (/ &
     &4.2987e-04_r8,5.2033e-04_r8,6.3756e-04_r8,7.6564e-04_r8,7.8218e-04_r8,1.6224e-03_r8, &
     &1.9482e-03_r8,2.2056e-03_r8,1.2455e-03_r8/)
      kao(:, 1, 5,10) = (/ &
     &3.3420e-03_r8,2.9247e-03_r8,2.5126e-03_r8,2.0946e-03_r8,1.6924e-03_r8,1.3030e-03_r8, &
     &9.3410e-04_r8,5.8986e-04_r8,3.1969e-04_r8/)
      kao(:, 2, 5,10) = (/ &
     &3.1398e-03_r8,2.7488e-03_r8,2.3818e-03_r8,2.0259e-03_r8,1.6962e-03_r8,1.3524e-03_r8, &
     &9.7217e-04_r8,7.2894e-04_r8,5.2320e-04_r8/)
      kao(:, 3, 5,10) = (/ &
     &3.0330e-03_r8,2.6759e-03_r8,2.3370e-03_r8,2.0014e-03_r8,1.6490e-03_r8,1.4032e-03_r8, &
     &1.0593e-03_r8,1.0067e-03_r8,7.5418e-04_r8/)
      kao(:, 4, 5,10) = (/ &
     &2.5775e-03_r8,2.3167e-03_r8,2.0477e-03_r8,1.6916e-03_r8,1.3663e-03_r8,1.1599e-03_r8, &
     &1.0841e-03_r8,1.3957e-03_r8,9.6520e-04_r8/)
      kao(:, 5, 5,10) = (/ &
     &2.1866e-03_r8,2.0017e-03_r8,1.5507e-03_r8,1.2425e-03_r8,1.2248e-03_r8,1.1086e-03_r8, &
     &1.2483e-03_r8,1.9173e-03_r8,1.1788e-03_r8/)
      kao(:, 1, 6,10) = (/ &
     &8.8838e-03_r8,7.7745e-03_r8,6.6646e-03_r8,5.5555e-03_r8,4.4614e-03_r8,3.3623e-03_r8, &
     &2.2796e-03_r8,1.1799e-03_r8,1.7827e-04_r8/)
      kao(:, 2, 6,10) = (/ &
     &8.6572e-03_r8,7.5770e-03_r8,6.4955e-03_r8,5.4321e-03_r8,4.3605e-03_r8,3.3104e-03_r8, &
     &2.2427e-03_r8,1.2382e-03_r8,2.5800e-04_r8/)
      kao(:, 3, 6,10) = (/ &
     &8.3335e-03_r8,7.2931e-03_r8,6.2759e-03_r8,5.2475e-03_r8,4.2339e-03_r8,3.2059e-03_r8, &
     &2.2047e-03_r8,1.3240e-03_r8,4.2156e-04_r8/)
      kao(:, 4, 6,10) = (/ &
     &7.5549e-03_r8,6.6060e-03_r8,5.7369e-03_r8,4.8380e-03_r8,4.0096e-03_r8,3.1204e-03_r8, &
     &2.3001e-03_r8,1.3603e-03_r8,7.8178e-04_r8/)
      kao(:, 5, 6,10) = (/ &
     &6.8684e-03_r8,6.0886e-03_r8,5.1989e-03_r8,4.4067e-03_r8,3.6681e-03_r8,2.8099e-03_r8, &
     &1.8970e-03_r8,1.4204e-03_r8,1.3480e-03_r8/)
      kao(:, 1, 7,10) = (/ &
     &2.4586e-02_r8,2.1513e-02_r8,1.8440e-02_r8,1.5369e-02_r8,1.2296e-02_r8,9.2230e-03_r8, &
     &6.1633e-03_r8,3.1137e-03_r8,1.3933e-04_r8/)
      kao(:, 2, 7,10) = (/ &
     &2.4170e-02_r8,2.1150e-02_r8,1.8129e-02_r8,1.5109e-02_r8,1.2088e-02_r8,9.0886e-03_r8, &
     &6.0878e-03_r8,3.1114e-03_r8,2.3190e-04_r8/)
      kao(:, 3, 7,10) = (/ &
     &2.3662e-02_r8,2.0705e-02_r8,1.7748e-02_r8,1.4791e-02_r8,1.1861e-02_r8,8.9271e-03_r8, &
     &6.0215e-03_r8,3.0844e-03_r8,3.6298e-04_r8/)
      kao(:, 4, 7,10) = (/ &
     &2.2469e-02_r8,1.9660e-02_r8,1.6853e-02_r8,1.4086e-02_r8,1.1306e-02_r8,8.5420e-03_r8, &
     &5.7631e-03_r8,3.0626e-03_r8,5.4029e-04_r8/)
      kao(:, 5, 7,10) = (/ &
     &1.9809e-02_r8,1.7349e-02_r8,1.4886e-02_r8,1.2460e-02_r8,1.0092e-02_r8,7.8522e-03_r8, &
     &5.3378e-03_r8,3.0999e-03_r8,7.7423e-04_r8/)
      kao(:, 1, 8,10) = (/ &
     &8.6508e-02_r8,7.5696e-02_r8,6.4882e-02_r8,5.4068e-02_r8,4.3255e-02_r8,3.2443e-02_r8, &
     &2.1630e-02_r8,1.0817e-02_r8,1.6191e-04_r8/)
      kao(:, 2, 8,10) = (/ &
     &8.4528e-02_r8,7.3960e-02_r8,6.3397e-02_r8,5.2832e-02_r8,4.2266e-02_r8,3.1701e-02_r8, &
     &2.1136e-02_r8,1.0597e-02_r8,3.0221e-04_r8/)
      kao(:, 3, 8,10) = (/ &
     &8.2999e-02_r8,7.2627e-02_r8,6.2253e-02_r8,5.1878e-02_r8,4.1506e-02_r8,3.1132e-02_r8, &
     &2.0757e-02_r8,1.0444e-02_r8,5.5391e-04_r8/)
      kao(:, 4, 8,10) = (/ &
     &8.1486e-02_r8,7.1301e-02_r8,6.1120e-02_r8,5.0928e-02_r8,4.0746e-02_r8,3.0564e-02_r8, &
     &2.0452e-02_r8,1.0346e-02_r8,1.0152e-03_r8/)
      kao(:, 5, 8,10) = (/ &
     &7.7129e-02_r8,6.7490e-02_r8,5.7855e-02_r8,4.8214e-02_r8,3.8581e-02_r8,2.9014e-02_r8, &
     &1.9443e-02_r8,9.9515e-03_r8,1.5121e-03_r8/)
      kao(:, 1, 9,10) = (/ &
     &5.8674e-01_r8,5.1340e-01_r8,4.4007e-01_r8,3.6671e-01_r8,2.9337e-01_r8,2.2003e-01_r8, &
     &1.4669e-01_r8,7.3347e-02_r8,1.3954e-04_r8/)
      kao(:, 2, 9,10) = (/ &
     &5.7350e-01_r8,5.0184e-01_r8,4.3015e-01_r8,3.5845e-01_r8,2.8676e-01_r8,2.1507e-01_r8, &
     &1.4339e-01_r8,7.1694e-02_r8,3.0044e-04_r8/)
      kao(:, 3, 9,10) = (/ &
     &5.6021e-01_r8,4.9017e-01_r8,4.2014e-01_r8,3.5012e-01_r8,2.8010e-01_r8,2.1008e-01_r8, &
     &1.4005e-01_r8,7.0031e-02_r8,5.5636e-04_r8/)
      kao(:, 4, 9,10) = (/ &
     &5.4802e-01_r8,4.7953e-01_r8,4.1105e-01_r8,3.4251e-01_r8,2.7403e-01_r8,2.0552e-01_r8, &
     &1.3702e-01_r8,6.8512e-02_r8,9.3561e-04_r8/)
      kao(:, 5, 9,10) = (/ &
     &5.3709e-01_r8,4.6991e-01_r8,4.0280e-01_r8,3.3568e-01_r8,2.6852e-01_r8,2.0142e-01_r8, &
     &1.3428e-01_r8,6.7143e-02_r8,1.4485e-03_r8/)
      kao(:, 1,10,10) = (/ &
     &4.7861e+00_r8,4.1878e+00_r8,3.5896e+00_r8,2.9913e+00_r8,2.3930e+00_r8,1.7948e+00_r8, &
     &1.1965e+00_r8,5.9827e-01_r8,3.2704e-06_r8/)
      kao(:, 2,10,10) = (/ &
     &4.6903e+00_r8,4.1040e+00_r8,3.5178e+00_r8,2.9315e+00_r8,2.3452e+00_r8,1.7589e+00_r8, &
     &1.1726e+00_r8,5.8632e-01_r8,5.9185e-06_r8/)
      kao(:, 3,10,10) = (/ &
     &4.5984e+00_r8,4.0237e+00_r8,3.4487e+00_r8,2.8740e+00_r8,2.2992e+00_r8,1.7244e+00_r8, &
     &1.1496e+00_r8,5.7479e-01_r8,9.9252e-06_r8/)
      kao(:, 4,10,10) = (/ &
     &4.5067e+00_r8,3.9434e+00_r8,3.3802e+00_r8,2.8168e+00_r8,2.2535e+00_r8,1.6901e+00_r8, &
     &1.1267e+00_r8,5.6337e-01_r8,1.5639e-05_r8/)
      kao(:, 5,10,10) = (/ &
     &4.4320e+00_r8,3.8780e+00_r8,3.3239e+00_r8,2.7699e+00_r8,2.2160e+00_r8,1.6620e+00_r8, &
     &1.1080e+00_r8,5.5401e-01_r8,2.3260e-05_r8/)
      kao(:, 1,11,10) = (/ &
     &1.3118e+01_r8,1.1478e+01_r8,9.8381e+00_r8,8.1983e+00_r8,6.5588e+00_r8,4.9192e+00_r8, &
     &3.2794e+00_r8,1.6397e+00_r8,2.2734e-06_r8/)
      kao(:, 2,11,10) = (/ &
     &1.2878e+01_r8,1.1268e+01_r8,9.6587e+00_r8,8.0488e+00_r8,6.4391e+00_r8,4.8293e+00_r8, &
     &3.2196e+00_r8,1.6098e+00_r8,4.2460e-06_r8/)
      kao(:, 3,11,10) = (/ &
     &1.2677e+01_r8,1.1092e+01_r8,9.5076e+00_r8,7.9230e+00_r8,6.3383e+00_r8,4.7539e+00_r8, &
     &3.1692e+00_r8,1.5846e+00_r8,7.1509e-06_r8/)
      kao(:, 4,11,10) = (/ &
     &1.2452e+01_r8,1.0896e+01_r8,9.3395e+00_r8,7.7831e+00_r8,6.2263e+00_r8,4.6699e+00_r8, &
     &3.1133e+00_r8,1.5566e+00_r8,1.2244e-05_r8/)
      kao(:, 5,11,10) = (/ &
     &1.2241e+01_r8,1.0711e+01_r8,9.1810e+00_r8,7.6509e+00_r8,6.1207e+00_r8,4.5903e+00_r8, &
     &3.0604e+00_r8,1.5302e+00_r8,2.0967e-05_r8/)
      kao(:, 1,12,10) = (/ &
     &2.2864e+01_r8,2.0005e+01_r8,1.7148e+01_r8,1.4290e+01_r8,1.1432e+01_r8,8.5738e+00_r8, &
     &5.7157e+00_r8,2.8580e+00_r8,1.8184e-06_r8/)
      kao(:, 2,12,10) = (/ &
     &2.2487e+01_r8,1.9676e+01_r8,1.6864e+01_r8,1.4054e+01_r8,1.1243e+01_r8,8.4321e+00_r8, &
     &5.6215e+00_r8,2.8107e+00_r8,3.3852e-06_r8/)
      kao(:, 3,12,10) = (/ &
     &2.2126e+01_r8,1.9360e+01_r8,1.6594e+01_r8,1.3829e+01_r8,1.1063e+01_r8,8.2969e+00_r8, &
     &5.5315e+00_r8,2.7657e+00_r8,6.4086e-06_r8/)
      kao(:, 4,12,10) = (/ &
     &2.1772e+01_r8,1.9050e+01_r8,1.6328e+01_r8,1.3607e+01_r8,1.0886e+01_r8,8.1644e+00_r8, &
     &5.4429e+00_r8,2.7215e+00_r8,1.1402e-05_r8/)
      kao(:, 5,12,10) = (/ &
     &2.1416e+01_r8,1.8740e+01_r8,1.6063e+01_r8,1.3386e+01_r8,1.0708e+01_r8,8.0313e+00_r8, &
     &5.3540e+00_r8,2.6771e+00_r8,1.6645e-05_r8/)
      kao(:, 1,13,10) = (/ &
     &3.2272e+01_r8,2.8237e+01_r8,2.4203e+01_r8,2.0170e+01_r8,1.6136e+01_r8,1.2101e+01_r8, &
     &8.0677e+00_r8,4.0338e+00_r8,1.4317e-06_r8/)
      kao(:, 2,13,10) = (/ &
     &3.1783e+01_r8,2.7810e+01_r8,2.3837e+01_r8,1.9864e+01_r8,1.5891e+01_r8,1.1919e+01_r8, &
     &7.9455e+00_r8,3.9728e+00_r8,3.0046e-06_r8/)
      kao(:, 3,13,10) = (/ &
     &3.1267e+01_r8,2.7359e+01_r8,2.3450e+01_r8,1.9542e+01_r8,1.5633e+01_r8,1.1725e+01_r8, &
     &7.8169e+00_r8,3.9083e+00_r8,5.7473e-06_r8/)
      kao(:, 4,13,10) = (/ &
     &3.0805e+01_r8,2.6955e+01_r8,2.3103e+01_r8,1.9253e+01_r8,1.5402e+01_r8,1.1552e+01_r8, &
     &7.7014e+00_r8,3.8506e+00_r8,8.5901e-06_r8/)
      kao(:, 5,13,10) = (/ &
     &3.0347e+01_r8,2.6554e+01_r8,2.2760e+01_r8,1.8967e+01_r8,1.5174e+01_r8,1.1380e+01_r8, &
     &7.5867e+00_r8,3.7933e+00_r8,1.2367e-05_r8/)
      kao(:, 1, 1,11) = (/ &
     &4.7098e-05_r8,1.8036e-04_r8,3.4819e-04_r8,5.0638e-04_r8,6.6181e-04_r8,8.1065e-04_r8, &
     &9.3902e-04_r8,7.7167e-04_r8,1.3022e-03_r8/)
      kao(:, 2, 1,11) = (/ &
     &3.0033e-05_r8,2.6523e-04_r8,5.0795e-04_r8,7.4803e-04_r8,9.8321e-04_r8,1.2080e-03_r8, &
     &1.4174e-03_r8,1.6176e-03_r8,1.9428e-03_r8/)
      kao(:, 3, 1,11) = (/ &
     &3.0544e-05_r8,3.7128e-04_r8,7.2058e-04_r8,1.0671e-03_r8,1.4084e-03_r8,1.7391e-03_r8, &
     &2.0379e-03_r8,2.3032e-03_r8,2.7938e-03_r8/)
      kao(:, 4, 1,11) = (/ &
     &3.0472e-05_r8,4.9757e-04_r8,9.8168e-04_r8,1.4606e-03_r8,1.9374e-03_r8,2.4057e-03_r8, &
     &2.8449e-03_r8,3.1636e-03_r8,3.8517e-03_r8/)
      kao(:, 5, 1,11) = (/ &
     &2.4091e-05_r8,6.5444e-04_r8,1.2934e-03_r8,1.9295e-03_r8,2.5676e-03_r8,3.2003e-03_r8, &
     &3.8144e-03_r8,4.2439e-03_r8,5.1123e-03_r8/)
      kao(:, 1, 2,11) = (/ &
     &1.3816e-04_r8,1.6153e-04_r8,3.3849e-04_r8,4.7695e-04_r8,6.1250e-04_r8,7.4207e-04_r8, &
     &8.5768e-04_r8,9.1861e-04_r8,1.1708e-03_r8/)
      kao(:, 2, 2,11) = (/ &
     &6.1066e-05_r8,1.7974e-04_r8,4.7651e-04_r8,6.8520e-04_r8,8.9139e-04_r8,1.0930e-03_r8, &
     &1.2848e-03_r8,1.4278e-03_r8,1.7346e-03_r8/)
      kao(:, 3, 2,11) = (/ &
     &5.7831e-05_r8,2.0028e-04_r8,6.5612e-04_r8,9.5859e-04_r8,1.2605e-03_r8,1.5625e-03_r8, &
     &1.8554e-03_r8,2.0988e-03_r8,2.4798e-03_r8/)
      kao(:, 4, 2,11) = (/ &
     &5.4516e-05_r8,2.3064e-04_r8,8.8062e-04_r8,1.3017e-03_r8,1.7223e-03_r8,2.1436e-03_r8, &
     &2.5645e-03_r8,2.9565e-03_r8,3.4038e-03_r8/)
      kao(:, 5, 2,11) = (/ &
     &5.5309e-05_r8,3.0448e-04_r8,1.1705e-03_r8,1.7340e-03_r8,2.2966e-03_r8,2.8601e-03_r8, &
     &3.4280e-03_r8,3.9900e-03_r8,4.5458e-03_r8/)
      kao(:, 1, 3,11) = (/ &
     &4.5525e-04_r8,4.1659e-04_r8,4.0041e-04_r8,4.3594e-04_r8,5.6841e-04_r8,6.6824e-04_r8, &
     &7.6559e-04_r8,8.3275e-04_r8,9.8673e-04_r8/)
      kao(:, 2, 3,11) = (/ &
     &2.7564e-04_r8,3.1143e-04_r8,4.0133e-04_r8,6.4539e-04_r8,8.1010e-04_r8,9.7483e-04_r8, &
     &1.1326e-03_r8,1.2606e-03_r8,1.4783e-03_r8/)
      kao(:, 3, 3,11) = (/ &
     &1.5755e-04_r8,2.0262e-04_r8,4.4233e-04_r8,8.8058e-04_r8,1.1240e-03_r8,1.3655e-03_r8, &
     &1.6023e-03_r8,1.8183e-03_r8,2.1060e-03_r8/)
      kao(:, 4, 3,11) = (/ &
     &1.5225e-04_r8,2.1360e-04_r8,4.5750e-04_r8,1.1722e-03_r8,1.5129e-03_r8,1.8525e-03_r8, &
     &2.1885e-03_r8,2.5141e-03_r8,2.8848e-03_r8/)
      kao(:, 5, 3,11) = (/ &
     &1.4157e-04_r8,2.5829e-04_r8,4.6589e-04_r8,1.5429e-03_r8,2.0085e-03_r8,2.4737e-03_r8, &
     &2.9344e-03_r8,3.3883e-03_r8,3.8756e-03_r8/)
      kao(:, 1, 4,11) = (/ &
     &1.2968e-03_r8,1.1627e-03_r8,1.0295e-03_r8,8.8852e-04_r8,7.5100e-04_r8,6.8878e-04_r8, &
     &7.0217e-04_r8,7.2855e-04_r8,6.6909e-04_r8/)
      kao(:, 2, 4,11) = (/ &
     &1.2901e-03_r8,1.1618e-03_r8,9.9278e-04_r8,8.6686e-04_r8,8.2710e-04_r8,9.1628e-04_r8, &
     &1.0053e-03_r8,1.0921e-03_r8,9.3719e-04_r8/)
      kao(:, 3, 4,11) = (/ &
     &8.4696e-04_r8,8.0992e-04_r8,6.6835e-04_r8,7.5797e-04_r8,8.8170e-04_r8,1.2538e-03_r8, &
     &1.4194e-03_r8,1.5777e-03_r8,1.2930e-03_r8/)
      kao(:, 4, 4,11) = (/ &
     &4.0946e-04_r8,5.3575e-04_r8,5.3156e-04_r8,6.5607e-04_r8,1.0924e-03_r8,1.6886e-03_r8, &
     &1.9410e-03_r8,2.1799e-03_r8,1.6795e-03_r8/)
      kao(:, 5, 4,11) = (/ &
     &4.1161e-04_r8,5.7102e-04_r8,5.8841e-04_r8,6.9122e-04_r8,1.4036e-03_r8,2.2467e-03_r8, &
     &2.6025e-03_r8,2.9419e-03_r8,2.1668e-03_r8/)
      kao(:, 1, 5,11) = (/ &
     &3.5249e-03_r8,3.0877e-03_r8,2.6707e-03_r8,2.2562e-03_r8,1.8574e-03_r8,1.4440e-03_r8, &
     &1.0135e-03_r8,7.0090e-04_r8,2.4879e-04_r8/)
      kao(:, 2, 5,11) = (/ &
     &3.4987e-03_r8,3.0660e-03_r8,2.6585e-03_r8,2.2616e-03_r8,1.8230e-03_r8,1.3947e-03_r8, &
     &1.1338e-03_r8,9.8875e-04_r8,4.4035e-04_r8/)
      kao(:, 3, 5,11) = (/ &
     &3.2338e-03_r8,2.8640e-03_r8,2.5128e-03_r8,2.2224e-03_r8,1.8369e-03_r8,1.4590e-03_r8, &
     &1.3054e-03_r8,1.4040e-03_r8,6.0764e-04_r8/)
      kao(:, 4, 5,11) = (/ &
     &2.1959e-03_r8,1.9312e-03_r8,1.7650e-03_r8,1.5181e-03_r8,1.3319e-03_r8,1.3218e-03_r8, &
     &1.7587e-03_r8,1.9394e-03_r8,9.4777e-04_r8/)
      kao(:, 5, 5,11) = (/ &
     &1.2468e-03_r8,1.0861e-03_r8,1.1609e-03_r8,1.1515e-03_r8,1.2470e-03_r8,1.3220e-03_r8, &
     &2.3659e-03_r8,2.6308e-03_r8,1.2356e-03_r8/)
      kao(:, 1, 6,11) = (/ &
     &9.5223e-03_r8,8.3335e-03_r8,7.1442e-03_r8,5.9544e-03_r8,4.7779e-03_r8,3.5984e-03_r8, &
     &2.4247e-03_r8,1.2737e-03_r8,1.4692e-04_r8/)
      kao(:, 2, 6,11) = (/ &
     &9.2485e-03_r8,8.0943e-03_r8,6.9406e-03_r8,5.8161e-03_r8,4.6851e-03_r8,3.5677e-03_r8, &
     &2.4748e-03_r8,1.3469e-03_r8,2.5178e-04_r8/)
      kao(:, 3, 6,11) = (/ &
     &8.7789e-03_r8,7.6827e-03_r8,6.6150e-03_r8,5.5437e-03_r8,4.4673e-03_r8,3.4787e-03_r8, &
     &2.4528e-03_r8,1.4847e-03_r8,3.7920e-04_r8/)
      kao(:, 4, 6,11) = (/ &
     &8.2164e-03_r8,7.2018e-03_r8,6.2465e-03_r8,5.3375e-03_r8,4.3691e-03_r8,3.4064e-03_r8, &
     &2.4151e-03_r8,1.7544e-03_r8,5.7438e-04_r8/)
      kao(:, 5, 6,11) = (/ &
     &6.8576e-03_r8,6.0356e-03_r8,5.1755e-03_r8,4.2553e-03_r8,3.2890e-03_r8,2.6043e-03_r8, &
     &1.9585e-03_r8,2.3328e-03_r8,8.0859e-04_r8/)
      kao(:, 1, 7,11) = (/ &
     &2.6634e-02_r8,2.3306e-02_r8,1.9979e-02_r8,1.6651e-02_r8,1.3321e-02_r8,9.9924e-03_r8, &
     &6.6684e-03_r8,3.3709e-03_r8,1.8920e-04_r8/)
      kao(:, 2, 7,11) = (/ &
     &2.5938e-02_r8,2.2696e-02_r8,1.9456e-02_r8,1.6215e-02_r8,1.2974e-02_r8,9.7488e-03_r8, &
     &6.5437e-03_r8,3.3574e-03_r8,3.7520e-04_r8/)
      kao(:, 3, 7,11) = (/ &
     &2.5453e-02_r8,2.2274e-02_r8,1.9096e-02_r8,1.5918e-02_r8,1.2777e-02_r8,9.6455e-03_r8, &
     &6.5081e-03_r8,3.3802e-03_r8,5.3158e-04_r8/)
      kao(:, 4, 7,11) = (/ &
     &2.4271e-02_r8,2.1241e-02_r8,1.8214e-02_r8,1.5233e-02_r8,1.2290e-02_r8,9.3599e-03_r8, &
     &6.4912e-03_r8,3.4387e-03_r8,8.0667e-04_r8/)
      kao(:, 5, 7,11) = (/ &
     &2.2422e-02_r8,1.9613e-02_r8,1.6806e-02_r8,1.4145e-02_r8,1.1493e-02_r8,8.8108e-03_r8, &
     &6.0692e-03_r8,3.4048e-03_r8,1.1367e-03_r8/)
      kao(:, 1, 8,11) = (/ &
     &9.5097e-02_r8,8.3206e-02_r8,7.1322e-02_r8,5.9437e-02_r8,4.7550e-02_r8,3.5664e-02_r8, &
     &2.3777e-02_r8,1.1891e-02_r8,8.8895e-05_r8/)
      kao(:, 2, 8,11) = (/ &
     &9.2657e-02_r8,8.1078e-02_r8,6.9498e-02_r8,5.7915e-02_r8,4.6333e-02_r8,3.4754e-02_r8, &
     &2.3172e-02_r8,1.1611e-02_r8,1.6093e-04_r8/)
      kao(:, 3, 8,11) = (/ &
     &8.9553e-02_r8,7.8360e-02_r8,6.7165e-02_r8,5.5974e-02_r8,4.4782e-02_r8,3.3592e-02_r8, &
     &2.2399e-02_r8,1.1297e-02_r8,2.7559e-04_r8/)
      kao(:, 4, 8,11) = (/ &
     &8.7450e-02_r8,7.6527e-02_r8,6.5593e-02_r8,5.4667e-02_r8,4.3739e-02_r8,3.2808e-02_r8, &
     &2.1983e-02_r8,1.1121e-02_r8,4.3678e-04_r8/)
      kao(:, 5, 8,11) = (/ &
     &8.6068e-02_r8,7.5315e-02_r8,6.4565e-02_r8,5.3811e-02_r8,4.3053e-02_r8,3.2463e-02_r8, &
     &2.1814e-02_r8,1.1203e-02_r8,7.8846e-04_r8/)
      kao(:, 1, 9,11) = (/ &
     &6.4279e-01_r8,5.6245e-01_r8,4.8207e-01_r8,4.0173e-01_r8,3.2138e-01_r8,2.4105e-01_r8, &
     &1.6070e-01_r8,8.0350e-02_r8,1.4861e-06_r8/)
      kao(:, 2, 9,11) = (/ &
     &6.2663e-01_r8,5.4828e-01_r8,4.6997e-01_r8,3.9164e-01_r8,3.1331e-01_r8,2.3498e-01_r8, &
     &1.5666e-01_r8,7.8331e-02_r8,2.7002e-06_r8/)
      kao(:, 3, 9,11) = (/ &
     &6.1151e-01_r8,5.3505e-01_r8,4.5861e-01_r8,3.8220e-01_r8,3.0575e-01_r8,2.2931e-01_r8, &
     &1.5288e-01_r8,7.6443e-02_r8,4.4491e-06_r8/)
      kao(:, 4, 9,11) = (/ &
     &5.9675e-01_r8,5.2214e-01_r8,4.4753e-01_r8,3.7296e-01_r8,2.9837e-01_r8,2.2379e-01_r8, &
     &1.4920e-01_r8,7.4612e-02_r8,6.8192e-06_r8/)
      kao(:, 5, 9,11) = (/ &
     &5.8474e-01_r8,5.1167e-01_r8,4.3855e-01_r8,3.6547e-01_r8,2.9239e-01_r8,2.1930e-01_r8, &
     &1.4621e-01_r8,7.3117e-02_r8,1.0152e-05_r8/)
      kao(:, 1,10,11) = (/ &
     &5.2427e+00_r8,4.5875e+00_r8,3.9320e+00_r8,3.2767e+00_r8,2.6214e+00_r8,1.9660e+00_r8, &
     &1.3107e+00_r8,6.5538e-01_r8,3.2405e-06_r8/)
      kao(:, 2,10,11) = (/ &
     &5.1308e+00_r8,4.4894e+00_r8,3.8480e+00_r8,3.2067e+00_r8,2.5654e+00_r8,1.9241e+00_r8, &
     &1.2827e+00_r8,6.4136e-01_r8,6.0207e-06_r8/)
      kao(:, 3,10,11) = (/ &
     &5.0278e+00_r8,4.3993e+00_r8,3.7708e+00_r8,3.1424e+00_r8,2.5139e+00_r8,1.8854e+00_r8, &
     &1.2569e+00_r8,6.2847e-01_r8,1.0181e-05_r8/)
      kao(:, 4,10,11) = (/ &
     &4.9276e+00_r8,4.3117e+00_r8,3.6956e+00_r8,3.0798e+00_r8,2.4638e+00_r8,1.8478e+00_r8, &
     &1.2319e+00_r8,6.1596e-01_r8,1.5690e-05_r8/)
      kao(:, 5,10,11) = (/ &
     &4.8175e+00_r8,4.2154e+00_r8,3.6129e+00_r8,3.0109e+00_r8,2.4088e+00_r8,1.8066e+00_r8, &
     &1.2044e+00_r8,6.0226e-01_r8,2.2851e-05_r8/)
      kao(:, 1,11,11) = (/ &
     &1.4444e+01_r8,1.2639e+01_r8,1.0833e+01_r8,9.0277e+00_r8,7.2223e+00_r8,5.4167e+00_r8, &
     &3.6111e+00_r8,1.8056e+00_r8,3.3928e-06_r8/)
      kao(:, 2,11,11) = (/ &
     &1.4191e+01_r8,1.2417e+01_r8,1.0643e+01_r8,8.8695e+00_r8,7.0956e+00_r8,5.3217e+00_r8, &
     &3.5476e+00_r8,1.7739e+00_r8,6.3163e-06_r8/)
      kao(:, 3,11,11) = (/ &
     &1.3919e+01_r8,1.2179e+01_r8,1.0439e+01_r8,8.6994e+00_r8,6.9594e+00_r8,5.2197e+00_r8, &
     &3.4797e+00_r8,1.7399e+00_r8,1.0603e-05_r8/)
      kao(:, 4,11,11) = (/ &
     &1.3652e+01_r8,1.1946e+01_r8,1.0239e+01_r8,8.5326e+00_r8,6.8259e+00_r8,5.1193e+00_r8, &
     &3.4129e+00_r8,1.7065e+00_r8,1.6659e-05_r8/)
      kao(:, 5,11,11) = (/ &
     &1.3348e+01_r8,1.1680e+01_r8,1.0011e+01_r8,8.3424e+00_r8,6.6742e+00_r8,5.0056e+00_r8, &
     &3.3371e+00_r8,1.6685e+00_r8,2.4500e-05_r8/)
      kao(:, 1,12,11) = (/ &
     &2.5285e+01_r8,2.2125e+01_r8,1.8964e+01_r8,1.5803e+01_r8,1.2642e+01_r8,9.4819e+00_r8, &
     &6.3210e+00_r8,3.1605e+00_r8,2.1167e-06_r8/)
      kao(:, 2,12,11) = (/ &
     &2.4880e+01_r8,2.1769e+01_r8,1.8659e+01_r8,1.5550e+01_r8,1.2440e+01_r8,9.3299e+00_r8, &
     &6.2198e+00_r8,3.1099e+00_r8,3.8897e-06_r8/)
      kao(:, 3,12,11) = (/ &
     &2.4433e+01_r8,2.1379e+01_r8,1.8325e+01_r8,1.5271e+01_r8,1.2217e+01_r8,9.1622e+00_r8, &
     &6.1081e+00_r8,3.0541e+00_r8,6.6786e-06_r8/)
      kao(:, 4,12,11) = (/ &
     &2.3948e+01_r8,2.0955e+01_r8,1.7960e+01_r8,1.4967e+01_r8,1.1974e+01_r8,8.9803e+00_r8, &
     &5.9870e+00_r8,2.9934e+00_r8,1.0649e-05_r8/)
      kao(:, 5,12,11) = (/ &
     &2.3474e+01_r8,2.0540e+01_r8,1.7606e+01_r8,1.4671e+01_r8,1.1737e+01_r8,8.8029e+00_r8, &
     &5.8685e+00_r8,2.9342e+00_r8,1.7444e-05_r8/)
      kao(:, 1,13,11) = (/ &
     &3.6004e+01_r8,3.1505e+01_r8,2.7003e+01_r8,2.2503e+01_r8,1.8003e+01_r8,1.3502e+01_r8, &
     &9.0009e+00_r8,4.5004e+00_r8,1.4918e-06_r8/)
      kao(:, 2,13,11) = (/ &
     &3.5389e+01_r8,3.0965e+01_r8,2.6541e+01_r8,2.2118e+01_r8,1.7694e+01_r8,1.3271e+01_r8, &
     &8.8469e+00_r8,4.4235e+00_r8,2.8535e-06_r8/)
      kao(:, 3,13,11) = (/ &
     &3.4779e+01_r8,3.0432e+01_r8,2.6084e+01_r8,2.1737e+01_r8,1.7389e+01_r8,1.3042e+01_r8, &
     &8.6948e+00_r8,4.3474e+00_r8,4.8793e-06_r8/)
      kao(:, 4,13,11) = (/ &
     &3.4139e+01_r8,2.9872e+01_r8,2.5605e+01_r8,2.1337e+01_r8,1.7070e+01_r8,1.2802e+01_r8, &
     &8.5348e+00_r8,4.2675e+00_r8,8.8607e-06_r8/)
      kao(:, 5,13,11) = (/ &
     &3.3563e+01_r8,2.9368e+01_r8,2.5171e+01_r8,2.0976e+01_r8,1.6781e+01_r8,1.2586e+01_r8, &
     &8.3906e+00_r8,4.1953e+00_r8,1.4420e-05_r8/)
      kao(:, 1, 1,12) = (/ &
     &6.4900e-05_r8,2.8719e-04_r8,5.6307e-04_r8,8.4351e-04_r8,1.1291e-03_r8,1.4211e-03_r8, &
     &1.7201e-03_r8,1.9852e-03_r8,2.2469e-03_r8/)
      kao(:, 2, 1,12) = (/ &
     &3.4635e-05_r8,4.0542e-04_r8,7.9731e-04_r8,1.1929e-03_r8,1.5968e-03_r8,2.0148e-03_r8, &
     &2.4518e-03_r8,2.8750e-03_r8,3.1817e-03_r8/)
      kao(:, 3, 1,12) = (/ &
     &3.0386e-05_r8,5.5544e-04_r8,1.0947e-03_r8,1.6361e-03_r8,2.1835e-03_r8,2.7444e-03_r8, &
     &3.3456e-03_r8,3.9572e-03_r8,4.3509e-03_r8/)
      kao(:, 4, 1,12) = (/ &
     &2.1896e-05_r8,7.4746e-04_r8,1.4741e-03_r8,2.1992e-03_r8,2.9238e-03_r8,3.6527e-03_r8, &
     &4.4093e-03_r8,5.2454e-03_r8,5.8288e-03_r8/)
      kao(:, 5, 1,12) = (/ &
     &2.2978e-05_r8,9.8728e-04_r8,1.9484e-03_r8,2.9034e-03_r8,3.8494e-03_r8,4.7859e-03_r8, &
     &5.7216e-03_r8,6.7414e-03_r8,7.6777e-03_r8/)
      kao(:, 1, 2,12) = (/ &
     &1.5749e-04_r8,2.0866e-04_r8,4.6787e-04_r8,6.8742e-04_r8,9.1071e-04_r8,1.1382e-03_r8, &
     &1.3780e-03_r8,1.6236e-03_r8,1.7971e-03_r8/)
      kao(:, 2, 2,12) = (/ &
     &6.4613e-05_r8,2.9516e-04_r8,6.7832e-04_r8,1.0033e-03_r8,1.3310e-03_r8,1.6630e-03_r8, &
     &2.0071e-03_r8,2.4028e-03_r8,2.6327e-03_r8/)
      kao(:, 3, 2,12) = (/ &
     &5.7078e-05_r8,4.5933e-04_r8,9.6118e-04_r8,1.4236e-03_r8,1.8857e-03_r8,2.3486e-03_r8, &
     &2.8168e-03_r8,3.3472e-03_r8,3.7377e-03_r8/)
      kao(:, 4, 2,12) = (/ &
     &4.9262e-05_r8,6.5877e-04_r8,1.3301e-03_r8,1.9726e-03_r8,2.6111e-03_r8,3.2436e-03_r8, &
     &3.8662e-03_r8,4.5052e-03_r8,5.1847e-03_r8/)
      kao(:, 5, 2,12) = (/ &
     &4.0132e-05_r8,8.9682e-04_r8,1.7993e-03_r8,2.6705e-03_r8,3.5334e-03_r8,4.3806e-03_r8, &
     &5.1960e-03_r8,5.9592e-03_r8,7.0262e-03_r8/)
      kao(:, 1, 3,12) = (/ &
     &4.4536e-04_r8,4.2140e-04_r8,4.1326e-04_r8,5.8784e-04_r8,7.3376e-04_r8,8.8410e-04_r8, &
     &1.0353e-03_r8,1.1868e-03_r8,1.3506e-03_r8/)
      kao(:, 2, 3,12) = (/ &
     &3.6360e-04_r8,3.5667e-04_r8,4.9101e-04_r8,8.4210e-04_r8,1.0791e-03_r8,1.3181e-03_r8, &
     &1.5590e-03_r8,1.8085e-03_r8,2.0516e-03_r8/)
      kao(:, 3, 3,12) = (/ &
     &1.5077e-04_r8,2.9297e-04_r8,7.2917e-04_r8,1.2081e-03_r8,1.5723e-03_r8,1.9339e-03_r8, &
     &2.2902e-03_r8,2.6377e-03_r8,3.0400e-03_r8/)
      kao(:, 4, 3,12) = (/ &
     &1.4163e-04_r8,2.2426e-04_r8,1.0557e-03_r8,1.7084e-03_r8,2.2382e-03_r8,2.7621e-03_r8, &
     &3.2708e-03_r8,3.7457e-03_r8,4.3687e-03_r8/)
      kao(:, 5, 3,12) = (/ &
     &1.3019e-04_r8,2.3338e-04_r8,1.4920e-03_r8,2.3388e-03_r8,3.0800e-03_r8,3.8155e-03_r8, &
     &4.5352e-03_r8,5.1815e-03_r8,6.0536e-03_r8/)
      kao(:, 1, 4,12) = (/ &
     &1.4099e-03_r8,1.2519e-03_r8,1.0992e-03_r8,9.6157e-04_r8,8.5060e-04_r8,8.2135e-04_r8, &
     &8.8574e-04_r8,9.4943e-04_r8,1.0571e-03_r8/)
      kao(:, 2, 4,12) = (/ &
     &1.2160e-03_r8,1.0633e-03_r8,1.0308e-03_r8,9.5807e-04_r8,9.2808e-04_r8,1.1772e-03_r8, &
     &1.3218e-03_r8,1.4545e-03_r8,1.6420e-03_r8/)
      kao(:, 3, 4,12) = (/ &
     &7.7631e-04_r8,7.4153e-04_r8,7.5882e-04_r8,8.7236e-04_r8,1.3771e-03_r8,1.6770e-03_r8, &
     &1.9300e-03_r8,2.1670e-03_r8,2.4676e-03_r8/)
      kao(:, 4, 4,12) = (/ &
     &4.5228e-04_r8,5.1764e-04_r8,4.9825e-04_r8,1.0410e-03_r8,1.9642e-03_r8,2.3602e-03_r8, &
     &2.7572e-03_r8,3.1444e-03_r8,3.5784e-03_r8/)
      kao(:, 5, 4,12) = (/ &
     &3.7162e-04_r8,5.4517e-04_r8,4.7653e-04_r8,1.0804e-03_r8,2.6516e-03_r8,3.2347e-03_r8, &
     &3.8223e-03_r8,4.4076e-03_r8,4.9248e-03_r8/)
      kao(:, 1, 5,12) = (/ &
     &3.8990e-03_r8,3.4146e-03_r8,2.9418e-03_r8,2.4792e-03_r8,1.9894e-03_r8,1.5917e-03_r8, &
     &1.1813e-03_r8,8.6801e-04_r8,2.1028e-04_r8/)
      kao(:, 2, 5,12) = (/ &
     &3.6199e-03_r8,3.1680e-03_r8,2.6938e-03_r8,2.3090e-03_r8,1.9956e-03_r8,1.6463e-03_r8, &
     &1.2997e-03_r8,1.3006e-03_r8,2.4494e-04_r8/)
      kao(:, 3, 5,12) = (/ &
     &3.4415e-03_r8,3.0220e-03_r8,2.5761e-03_r8,2.2036e-03_r8,1.8689e-03_r8,1.5859e-03_r8, &
     &1.7898e-03_r8,1.9074e-03_r8,5.0679e-04_r8/)
      kao(:, 4, 5,12) = (/ &
     &2.1716e-03_r8,1.9079e-03_r8,1.6133e-03_r8,1.3356e-03_r8,1.5050e-03_r8,1.8145e-03_r8, &
     &2.4880e-03_r8,2.7223e-03_r8,8.8637e-04_r8/)
      kao(:, 5, 5,12) = (/ &
     &1.3077e-03_r8,1.2440e-03_r8,1.1158e-03_r8,9.0020e-04_r8,1.2713e-03_r8,2.3698e-03_r8, &
     &3.3646e-03_r8,3.7560e-03_r8,1.3375e-03_r8/)
      kao(:, 1, 6,12) = (/ &
     &1.0196e-02_r8,8.9244e-03_r8,7.6531e-03_r8,6.3818e-03_r8,5.1267e-03_r8,3.9081e-03_r8, &
     &2.6537e-03_r8,1.4661e-03_r8,1.6889e-04_r8/)
      kao(:, 2, 6,12) = (/ &
     &1.0111e-02_r8,8.8532e-03_r8,7.5941e-03_r8,6.3593e-03_r8,5.1154e-03_r8,3.8577e-03_r8, &
     &2.6627e-03_r8,1.5273e-03_r8,2.6786e-04_r8/)
      kao(:, 3, 6,12) = (/ &
     &9.5574e-03_r8,8.3745e-03_r8,7.2096e-03_r8,6.0967e-03_r8,4.9927e-03_r8,3.8753e-03_r8, &
     &2.6940e-03_r8,1.7929e-03_r8,4.4721e-04_r8/)
      kao(:, 4, 6,12) = (/ &
     &9.1448e-03_r8,8.0065e-03_r8,6.8180e-03_r8,5.6454e-03_r8,4.5888e-03_r8,3.5047e-03_r8, &
     &2.6334e-03_r8,2.4842e-03_r8,6.5846e-04_r8/)
      kao(:, 5, 6,12) = (/ &
     &5.7075e-03_r8,5.0049e-03_r8,4.5271e-03_r8,4.0365e-03_r8,3.0612e-03_r8,2.5106e-03_r8, &
     &2.5238e-03_r8,3.3792e-03_r8,9.8239e-04_r8/)
      kao(:, 1, 7,12) = (/ &
     &2.9179e-02_r8,2.5534e-02_r8,2.1889e-02_r8,1.8245e-02_r8,1.4599e-02_r8,1.0955e-02_r8, &
     &7.3101e-03_r8,3.7189e-03_r8,1.6629e-04_r8/)
      kao(:, 2, 7,12) = (/ &
     &2.8331e-02_r8,2.4795e-02_r8,2.1258e-02_r8,1.7722e-02_r8,1.4184e-02_r8,1.0647e-02_r8, &
     &7.1746e-03_r8,3.6882e-03_r8,3.2759e-04_r8/)
      kao(:, 3, 7,12) = (/ &
     &2.7584e-02_r8,2.4141e-02_r8,2.0699e-02_r8,1.7251e-02_r8,1.3817e-02_r8,1.0419e-02_r8, &
     &6.9883e-03_r8,3.6331e-03_r8,7.5693e-04_r8/)
      kao(:, 4, 7,12) = (/ &
     &2.7092e-02_r8,2.3710e-02_r8,2.0332e-02_r8,1.6950e-02_r8,1.3669e-02_r8,1.0331e-02_r8, &
     &6.9978e-03_r8,3.6886e-03_r8,1.3272e-03_r8/)
      kao(:, 5, 7,12) = (/ &
     &2.4668e-02_r8,2.1578e-02_r8,1.8509e-02_r8,1.5691e-02_r8,1.2680e-02_r8,9.7141e-03_r8, &
     &6.7022e-03_r8,3.7141e-03_r8,1.7778e-03_r8/)
      kao(:, 1, 8,12) = (/ &
     &1.0361e-01_r8,9.0667e-02_r8,7.7713e-02_r8,6.4765e-02_r8,5.1815e-02_r8,3.8864e-02_r8, &
     &2.5914e-02_r8,1.2965e-02_r8,1.1677e-04_r8/)
      kao(:, 2, 8,12) = (/ &
     &1.0115e-01_r8,8.8507e-02_r8,7.5864e-02_r8,6.3225e-02_r8,5.0584e-02_r8,3.7943e-02_r8, &
     &2.5302e-02_r8,1.2662e-02_r8,2.2624e-04_r8/)
      kao(:, 3, 8,12) = (/ &
     &9.8784e-02_r8,8.6438e-02_r8,7.4094e-02_r8,6.1749e-02_r8,4.9403e-02_r8,3.7059e-02_r8, &
     &2.4715e-02_r8,1.2461e-02_r8,3.7810e-04_r8/)
      kao(:, 4, 8,12) = (/ &
     &9.5779e-02_r8,8.3802e-02_r8,7.1837e-02_r8,5.9866e-02_r8,4.7899e-02_r8,3.5935e-02_r8, &
     &2.4068e-02_r8,1.2158e-02_r8,6.1406e-04_r8/)
      kao(:, 5, 8,12) = (/ &
     &9.3500e-02_r8,8.1816e-02_r8,7.0121e-02_r8,5.8448e-02_r8,4.6756e-02_r8,3.5152e-02_r8, &
     &2.3515e-02_r8,1.2003e-02_r8,9.1223e-04_r8/)
      kao(:, 1, 9,12) = (/ &
     &7.0616e-01_r8,6.1791e-01_r8,5.2965e-01_r8,4.4136e-01_r8,3.5309e-01_r8,2.6483e-01_r8, &
     &1.7655e-01_r8,8.8282e-02_r8,1.5290e-06_r8/)
      kao(:, 2, 9,12) = (/ &
     &6.9151e-01_r8,6.0507e-01_r8,5.1861e-01_r8,4.3218e-01_r8,3.4576e-01_r8,2.5930e-01_r8, &
     &1.7288e-01_r8,8.6445e-02_r8,2.6717e-06_r8/)
      kao(:, 3, 9,12) = (/ &
     &6.7650e-01_r8,5.9194e-01_r8,5.0740e-01_r8,4.2284e-01_r8,3.3827e-01_r8,2.5371e-01_r8, &
     &1.6914e-01_r8,8.4579e-02_r8,4.4922e-06_r8/)
      kao(:, 4, 9,12) = (/ &
     &6.5888e-01_r8,5.7654e-01_r8,4.9417e-01_r8,4.1183e-01_r8,3.2946e-01_r8,2.4710e-01_r8, &
     &1.6473e-01_r8,8.2371e-02_r8,7.3887e-06_r8/)
      kao(:, 5, 9,12) = (/ &
     &6.4040e-01_r8,5.6034e-01_r8,4.8031e-01_r8,4.0028e-01_r8,3.2019e-01_r8,2.4016e-01_r8, &
     &1.6010e-01_r8,8.0057e-02_r8,1.1597e-05_r8/)
      kao(:, 1,10,12) = (/ &
     &5.7734e+00_r8,5.0518e+00_r8,4.3301e+00_r8,3.6085e+00_r8,2.8866e+00_r8,2.1651e+00_r8, &
     &1.4434e+00_r8,7.2167e-01_r8,9.1748e-07_r8/)
      kao(:, 2,10,12) = (/ &
     &5.6550e+00_r8,4.9481e+00_r8,4.2414e+00_r8,3.5344e+00_r8,2.8275e+00_r8,2.1206e+00_r8, &
     &1.4138e+00_r8,7.0688e-01_r8,1.6728e-06_r8/)
      kao(:, 3,10,12) = (/ &
     &5.5293e+00_r8,4.8379e+00_r8,4.1470e+00_r8,3.4558e+00_r8,2.7646e+00_r8,2.0735e+00_r8, &
     &1.3823e+00_r8,6.9113e-01_r8,2.9526e-06_r8/)
      kao(:, 4,10,12) = (/ &
     &5.4054e+00_r8,4.7297e+00_r8,4.0540e+00_r8,3.3783e+00_r8,2.7027e+00_r8,2.0270e+00_r8, &
     &1.3514e+00_r8,6.7568e-01_r8,4.8767e-06_r8/)
      kao(:, 5,10,12) = (/ &
     &5.2733e+00_r8,4.6145e+00_r8,3.9550e+00_r8,3.2959e+00_r8,2.6366e+00_r8,1.9775e+00_r8, &
     &1.3184e+00_r8,6.5919e-01_r8,7.7655e-06_r8/)
      kao(:, 1,11,12) = (/ &
     &1.5785e+01_r8,1.3812e+01_r8,1.1839e+01_r8,9.8659e+00_r8,7.8925e+00_r8,5.9194e+00_r8, &
     &3.9463e+00_r8,1.9732e+00_r8,7.4549e-07_r8/)
      kao(:, 2,11,12) = (/ &
     &1.5479e+01_r8,1.3544e+01_r8,1.1609e+01_r8,9.6738e+00_r8,7.7393e+00_r8,5.8045e+00_r8, &
     &3.8695e+00_r8,1.9348e+00_r8,1.4083e-06_r8/)
      kao(:, 3,11,12) = (/ &
     &1.5180e+01_r8,1.3283e+01_r8,1.1385e+01_r8,9.4881e+00_r8,7.5902e+00_r8,5.6927e+00_r8, &
     &3.7951e+00_r8,1.8975e+00_r8,2.4492e-06_r8/)
      kao(:, 4,11,12) = (/ &
     &1.4875e+01_r8,1.3016e+01_r8,1.1157e+01_r8,9.2972e+00_r8,7.4378e+00_r8,5.5784e+00_r8, &
     &3.7189e+00_r8,1.8594e+00_r8,4.0481e-06_r8/)
      kao(:, 5,11,12) = (/ &
     &1.4584e+01_r8,1.2761e+01_r8,1.0938e+01_r8,9.1150e+00_r8,7.2921e+00_r8,5.4689e+00_r8, &
     &3.6460e+00_r8,1.8230e+00_r8,6.1324e-06_r8/)
      kao(:, 1,12,12) = (/ &
     &2.7851e+01_r8,2.4369e+01_r8,2.0888e+01_r8,1.7407e+01_r8,1.3925e+01_r8,1.0444e+01_r8, &
     &6.9625e+00_r8,3.4813e+00_r8,1.7967e-06_r8/)
      kao(:, 2,12,12) = (/ &
     &2.7381e+01_r8,2.3958e+01_r8,2.0536e+01_r8,1.7113e+01_r8,1.3691e+01_r8,1.0268e+01_r8, &
     &6.8453e+00_r8,3.4226e+00_r8,3.3551e-06_r8/)
      kao(:, 3,12,12) = (/ &
     &2.6898e+01_r8,2.3535e+01_r8,2.0173e+01_r8,1.6811e+01_r8,1.3449e+01_r8,1.0086e+01_r8, &
     &6.7243e+00_r8,3.3621e+00_r8,5.7999e-06_r8/)
      kao(:, 4,12,12) = (/ &
     &2.6422e+01_r8,2.3120e+01_r8,1.9816e+01_r8,1.6513e+01_r8,1.3211e+01_r8,9.9083e+00_r8, &
     &6.6055e+00_r8,3.3027e+00_r8,8.8648e-06_r8/)
      kao(:, 5,12,12) = (/ &
     &2.5893e+01_r8,2.2657e+01_r8,1.9420e+01_r8,1.6183e+01_r8,1.2946e+01_r8,9.7098e+00_r8, &
     &6.4732e+00_r8,3.2366e+00_r8,1.3030e-05_r8/)
      kao(:, 1,13,12) = (/ &
     &4.0056e+01_r8,3.5049e+01_r8,3.0042e+01_r8,2.5035e+01_r8,2.0028e+01_r8,1.5021e+01_r8, &
     &1.0014e+01_r8,5.0068e+00_r8,1.9339e-06_r8/)
      kao(:, 2,13,12) = (/ &
     &3.9543e+01_r8,3.4599e+01_r8,2.9657e+01_r8,2.4713e+01_r8,1.9771e+01_r8,1.4828e+01_r8, &
     &9.8854e+00_r8,4.9428e+00_r8,3.6424e-06_r8/)
      kao(:, 3,13,12) = (/ &
     &3.8932e+01_r8,3.4065e+01_r8,2.9198e+01_r8,2.4333e+01_r8,1.9465e+01_r8,1.4599e+01_r8, &
     &9.7330e+00_r8,4.8663e+00_r8,6.0957e-06_r8/)
      kao(:, 4,13,12) = (/ &
     &3.8278e+01_r8,3.3493e+01_r8,2.8708e+01_r8,2.3923e+01_r8,1.9139e+01_r8,1.4354e+01_r8, &
     &9.5693e+00_r8,4.7847e+00_r8,9.5853e-06_r8/)
      kao(:, 5,13,12) = (/ &
     &3.7502e+01_r8,3.2815e+01_r8,2.8127e+01_r8,2.3438e+01_r8,1.8751e+01_r8,1.4063e+01_r8, &
     &9.3751e+00_r8,4.6877e+00_r8,1.4124e-05_r8/)
      kao(:, 1, 1,13) = (/ &
     &7.4486e-05_r8,5.1116e-04_r8,1.0025e-03_r8,1.4842e-03_r8,1.9493e-03_r8,2.3797e-03_r8, &
     &2.7258e-03_r8,2.8231e-03_r8,3.8853e-03_r8/)
      kao(:, 2, 1,13) = (/ &
     &6.5327e-05_r8,7.3706e-04_r8,1.4529e-03_r8,2.1556e-03_r8,2.8349e-03_r8,3.4671e-03_r8, &
     &3.9764e-03_r8,4.1729e-03_r8,5.6550e-03_r8/)
      kao(:, 3, 1,13) = (/ &
     &2.8267e-05_r8,1.0173e-03_r8,2.0120e-03_r8,2.9905e-03_r8,3.9385e-03_r8,4.8257e-03_r8, &
     &5.5630e-03_r8,5.8315e-03_r8,7.8638e-03_r8/)
      kao(:, 4, 1,13) = (/ &
     &2.3738e-05_r8,1.3547e-03_r8,2.6849e-03_r8,3.9940e-03_r8,5.2660e-03_r8,6.4652e-03_r8, &
     &7.4857e-03_r8,7.8673e-03_r8,1.0519e-02_r8/)
      kao(:, 5, 1,13) = (/ &
     &2.6320e-05_r8,1.7490e-03_r8,3.4713e-03_r8,5.1691e-03_r8,6.8225e-03_r8,8.3917e-03_r8, &
     &9.7490e-03_r8,1.0316e-02_r8,1.3632e-02_r8/)
      kao(:, 1, 2,13) = (/ &
     &1.3584e-04_r8,4.6683e-04_r8,9.0905e-04_r8,1.3477e-03_r8,1.7804e-03_r8,2.1997e-03_r8, &
     &2.5843e-03_r8,2.8459e-03_r8,3.5348e-03_r8/)
      kao(:, 2, 2,13) = (/ &
     &1.2342e-04_r8,6.7608e-04_r8,1.3278e-03_r8,1.9757e-03_r8,2.6172e-03_r8,3.2432e-03_r8, &
     &3.8268e-03_r8,4.2250e-03_r8,5.2098e-03_r8/)
      kao(:, 3, 2,13) = (/ &
     &5.7073e-05_r8,9.3916e-04_r8,1.8537e-03_r8,2.7640e-03_r8,3.6667e-03_r8,4.5531e-03_r8, &
     &5.3892e-03_r8,5.9774e-03_r8,7.3088e-03_r8/)
      kao(:, 4, 2,13) = (/ &
     &4.3007e-05_r8,1.2575e-03_r8,2.4910e-03_r8,3.7207e-03_r8,4.9408e-03_r8,6.1442e-03_r8, &
     &7.2881e-03_r8,8.1201e-03_r8,9.8567e-03_r8/)
      kao(:, 5, 2,13) = (/ &
     &4.4050e-05_r8,1.6325e-03_r8,3.2411e-03_r8,4.8448e-03_r8,6.4428e-03_r8,8.0196e-03_r8, &
     &9.5284e-03_r8,1.0661e-02_r8,1.2860e-02_r8/)
      kao(:, 1, 3,13) = (/ &
     &4.8847e-04_r8,4.8646e-04_r8,7.2624e-04_r8,1.0874e-03_r8,1.4317e-03_r8,1.7747e-03_r8, &
     &2.1141e-03_r8,2.4304e-03_r8,2.8058e-03_r8/)
      kao(:, 2, 3,13) = (/ &
     &3.4302e-04_r8,4.5845e-04_r8,1.0966e-03_r8,1.6182e-03_r8,2.1396e-03_r8,2.6609e-03_r8, &
     &3.1797e-03_r8,3.6788e-03_r8,4.2203e-03_r8/)
      kao(:, 3, 3,13) = (/ &
     &2.3118e-04_r8,5.8673e-04_r8,1.5488e-03_r8,2.2966e-03_r8,3.0451e-03_r8,3.7949e-03_r8, &
     &4.5473e-03_r8,5.2834e-03_r8,6.0295e-03_r8/)
      kao(:, 4, 3,13) = (/ &
     &1.2745e-04_r8,7.5679e-04_r8,2.1131e-03_r8,3.1366e-03_r8,4.1628e-03_r8,5.1929e-03_r8, &
     &6.2318e-03_r8,7.2646e-03_r8,8.2577e-03_r8/)
      kao(:, 5, 3,13) = (/ &
     &1.0163e-04_r8,9.0005e-04_r8,2.8013e-03_r8,4.1651e-03_r8,5.5261e-03_r8,6.8877e-03_r8, &
     &8.2517e-03_r8,9.6360e-03_r8,1.0972e-02_r8/)
      kao(:, 1, 4,13) = (/ &
     &1.4481e-03_r8,1.2897e-03_r8,1.1542e-03_r8,1.0925e-03_r8,1.1503e-03_r8,1.3566e-03_r8, &
     &1.5821e-03_r8,1.8266e-03_r8,2.0462e-03_r8/)
      kao(:, 2, 4,13) = (/ &
     &1.3895e-03_r8,1.2964e-03_r8,1.0801e-03_r8,1.1824e-03_r8,1.6797e-03_r8,2.0441e-03_r8, &
     &2.4259e-03_r8,2.8265e-03_r8,3.1666e-03_r8/)
      kao(:, 3, 4,13) = (/ &
     &8.4970e-04_r8,9.1322e-04_r8,9.4827e-04_r8,1.6805e-03_r8,2.4256e-03_r8,2.9871e-03_r8, &
     &3.5538e-03_r8,4.1410e-03_r8,4.6574e-03_r8/)
      kao(:, 4, 4,13) = (/ &
     &4.1870e-04_r8,6.5230e-04_r8,1.1618e-03_r8,2.4565e-03_r8,3.3994e-03_r8,4.2007e-03_r8, &
     &5.0069e-03_r8,5.8294e-03_r8,6.5858e-03_r8/)
      kao(:, 5, 4,13) = (/ &
     &3.3416e-04_r8,5.3110e-04_r8,1.2880e-03_r8,3.5329e-03_r8,4.6400e-03_r8,5.7434e-03_r8, &
     &6.8465e-03_r8,7.9498e-03_r8,9.0475e-03_r8/)
      kao(:, 1, 5,13) = (/ &
     &4.2095e-03_r8,3.6897e-03_r8,3.1731e-03_r8,2.7426e-03_r8,2.2812e-03_r8,1.8053e-03_r8, &
     &1.3867e-03_r8,1.3663e-03_r8,1.0788e-03_r8/)
      kao(:, 2, 5,13) = (/ &
     &4.0034e-03_r8,3.5161e-03_r8,3.1982e-03_r8,2.7135e-03_r8,2.2188e-03_r8,1.8636e-03_r8, &
     &1.9269e-03_r8,2.1141e-03_r8,1.6636e-03_r8/)
      kao(:, 3, 5,13) = (/ &
     &3.5828e-03_r8,3.2123e-03_r8,2.7997e-03_r8,2.3571e-03_r8,1.9942e-03_r8,2.3633e-03_r8, &
     &2.8135e-03_r8,3.1780e-03_r8,2.3977e-03_r8/)
      kao(:, 4, 5,13) = (/ &
     &2.0578e-03_r8,1.9948e-03_r8,1.9739e-03_r8,1.8494e-03_r8,2.1664e-03_r8,3.4722e-03_r8, &
     &4.0379e-03_r8,4.6191e-03_r8,3.3853e-03_r8/)
      kao(:, 5, 5,13) = (/ &
     &8.8300e-04_r8,9.5901e-04_r8,1.3118e-03_r8,1.4619e-03_r8,2.8921e-03_r8,4.8304e-03_r8, &
     &5.6699e-03_r8,6.5165e-03_r8,5.0451e-03_r8/)
      kao(:, 1, 6,13) = (/ &
     &1.1518e-02_r8,1.0082e-02_r8,8.6450e-03_r8,7.2094e-03_r8,5.7738e-03_r8,4.4142e-03_r8, &
     &2.9967e-03_r8,1.6414e-03_r8,2.3528e-04_r8/)
      kao(:, 2, 6,13) = (/ &
     &1.0779e-02_r8,9.4346e-03_r8,8.0897e-03_r8,6.7606e-03_r8,5.5435e-03_r8,4.2583e-03_r8, &
     &3.0675e-03_r8,1.8475e-03_r8,3.7683e-04_r8/)
      kao(:, 3, 6,13) = (/ &
     &1.0564e-02_r8,9.2493e-03_r8,7.9306e-03_r8,6.7005e-03_r8,5.4724e-03_r8,4.2002e-03_r8, &
     &3.0432e-03_r8,2.5995e-03_r8,5.6137e-04_r8/)
      kao(:, 4, 6,13) = (/ &
     &8.9592e-03_r8,7.8426e-03_r8,6.9339e-03_r8,5.9610e-03_r8,4.9577e-03_r8,4.0115e-03_r8, &
     &3.3973e-03_r8,3.7509e-03_r8,7.8787e-04_r8/)
      kao(:, 5, 6,13) = (/ &
     &5.6084e-03_r8,4.9031e-03_r8,4.1060e-03_r8,3.7154e-03_r8,3.3523e-03_r8,3.1522e-03_r8, &
     &4.6655e-03_r8,5.3564e-03_r8,1.1263e-03_r8/)
      kao(:, 1, 7,13) = (/ &
     &3.2240e-02_r8,2.8212e-02_r8,2.4183e-02_r8,2.0155e-02_r8,1.6127e-02_r8,1.2099e-02_r8, &
     &8.0718e-03_r8,4.1324e-03_r8,2.8875e-04_r8/)
      kao(:, 2, 7,13) = (/ &
     &3.1311e-02_r8,2.7399e-02_r8,2.3486e-02_r8,1.9574e-02_r8,1.5661e-02_r8,1.1749e-02_r8, &
     &7.9670e-03_r8,4.1256e-03_r8,4.9392e-04_r8/)
      kao(:, 3, 7,13) = (/ &
     &2.9762e-02_r8,2.6043e-02_r8,2.2324e-02_r8,1.8611e-02_r8,1.4888e-02_r8,1.1369e-02_r8, &
     &7.7126e-03_r8,4.2395e-03_r8,7.8171e-04_r8/)
      kao(:, 4, 7,13) = (/ &
     &2.8871e-02_r8,2.5265e-02_r8,2.1655e-02_r8,1.8050e-02_r8,1.4581e-02_r8,1.1027e-02_r8, &
     &7.5640e-03_r8,4.2437e-03_r8,1.1828e-03_r8/)
      kao(:, 5, 7,13) = (/ &
     &2.6386e-02_r8,2.3095e-02_r8,1.9798e-02_r8,1.6677e-02_r8,1.3324e-02_r8,1.0191e-02_r8, &
     &7.1310e-03_r8,4.8298e-03_r8,2.2511e-03_r8/)
      kao(:, 1, 8,13) = (/ &
     &1.1497e-01_r8,1.0060e-01_r8,8.6231e-02_r8,7.1859e-02_r8,5.7486e-02_r8,4.3117e-02_r8, &
     &2.8748e-02_r8,1.4377e-02_r8,1.6465e-04_r8/)
      kao(:, 2, 8,13) = (/ &
     &1.1189e-01_r8,9.7901e-02_r8,8.3916e-02_r8,6.9933e-02_r8,5.5946e-02_r8,4.1961e-02_r8, &
     &2.7977e-02_r8,1.3991e-02_r8,2.9555e-04_r8/)
      kao(:, 3, 8,13) = (/ &
     &1.0913e-01_r8,9.5494e-02_r8,8.1850e-02_r8,6.8211e-02_r8,5.4570e-02_r8,4.0928e-02_r8, &
     &2.7290e-02_r8,1.3843e-02_r8,5.2136e-04_r8/)
      kao(:, 4, 8,13) = (/ &
     &1.0534e-01_r8,9.2180e-02_r8,7.9010e-02_r8,6.5847e-02_r8,5.2678e-02_r8,3.9513e-02_r8, &
     &2.6523e-02_r8,1.3514e-02_r8,8.6919e-04_r8/)
      kao(:, 5, 8,13) = (/ &
     &1.0155e-01_r8,8.8866e-02_r8,7.6173e-02_r8,6.3476e-02_r8,5.0785e-02_r8,3.8190e-02_r8, &
     &2.5826e-02_r8,1.3344e-02_r8,1.3651e-03_r8/)
      kao(:, 1, 9,13) = (/ &
     &7.8551e-01_r8,6.8732e-01_r8,5.8909e-01_r8,4.9092e-01_r8,3.9275e-01_r8,2.9457e-01_r8, &
     &1.9638e-01_r8,9.8187e-02_r8,1.8629e-06_r8/)
      kao(:, 2, 9,13) = (/ &
     &7.6466e-01_r8,6.6906e-01_r8,5.7351e-01_r8,4.7791e-01_r8,3.8233e-01_r8,2.8675e-01_r8, &
     &1.9117e-01_r8,9.5586e-02_r8,3.1593e-06_r8/)
      kao(:, 3, 9,13) = (/ &
     &7.4558e-01_r8,6.5237e-01_r8,5.5922e-01_r8,4.6601e-01_r8,3.7282e-01_r8,2.7960e-01_r8, &
     &1.8640e-01_r8,9.3207e-02_r8,5.1342e-06_r8/)
      kao(:, 4, 9,13) = (/ &
     &7.2909e-01_r8,6.3798e-01_r8,5.4684e-01_r8,4.5571e-01_r8,3.6456e-01_r8,2.7343e-01_r8, &
     &1.8229e-01_r8,9.1144e-02_r8,7.8192e-06_r8/)
      kao(:, 5, 9,13) = (/ &
     &7.0726e-01_r8,6.1887e-01_r8,5.3047e-01_r8,4.4203e-01_r8,3.5366e-01_r8,2.6523e-01_r8, &
     &1.7683e-01_r8,8.8423e-02_r8,1.1206e-05_r8/)
      kao(:, 1,10,13) = (/ &
     &6.4269e+00_r8,5.6236e+00_r8,4.8204e+00_r8,4.0168e+00_r8,3.2134e+00_r8,2.4100e+00_r8, &
     &1.6066e+00_r8,8.0335e-01_r8,1.1293e-06_r8/)
      kao(:, 2,10,13) = (/ &
     &6.2640e+00_r8,5.4811e+00_r8,4.6981e+00_r8,3.9150e+00_r8,3.1320e+00_r8,2.3491e+00_r8, &
     &1.5660e+00_r8,7.8302e-01_r8,2.0871e-06_r8/)
      kao(:, 3,10,13) = (/ &
     &6.1220e+00_r8,5.3567e+00_r8,4.5912e+00_r8,3.8262e+00_r8,3.0609e+00_r8,2.2959e+00_r8, &
     &1.5304e+00_r8,7.6518e-01_r8,3.5513e-06_r8/)
      kao(:, 4,10,13) = (/ &
     &5.9998e+00_r8,5.2499e+00_r8,4.4998e+00_r8,3.7498e+00_r8,2.9997e+00_r8,2.2499e+00_r8, &
     &1.5000e+00_r8,7.4994e-01_r8,5.6768e-06_r8/)
      kao(:, 5,10,13) = (/ &
     &5.8812e+00_r8,5.1459e+00_r8,4.4109e+00_r8,3.6757e+00_r8,2.9406e+00_r8,2.2054e+00_r8, &
     &1.4703e+00_r8,7.3514e-01_r8,8.5300e-06_r8/)
      kao(:, 1,11,13) = (/ &
     &1.7678e+01_r8,1.5468e+01_r8,1.3258e+01_r8,1.1049e+01_r8,8.8386e+00_r8,6.6292e+00_r8, &
     &4.4195e+00_r8,2.2097e+00_r8,9.5807e-07_r8/)
      kao(:, 2,11,13) = (/ &
     &1.7256e+01_r8,1.5100e+01_r8,1.2942e+01_r8,1.0785e+01_r8,8.6284e+00_r8,6.4710e+00_r8, &
     &4.3143e+00_r8,2.1571e+00_r8,1.8271e-06_r8/)
      kao(:, 3,11,13) = (/ &
     &1.6917e+01_r8,1.4802e+01_r8,1.2687e+01_r8,1.0572e+01_r8,8.4580e+00_r8,6.3436e+00_r8, &
     &4.2290e+00_r8,2.1146e+00_r8,3.1322e-06_r8/)
      kao(:, 4,11,13) = (/ &
     &1.6624e+01_r8,1.4546e+01_r8,1.2468e+01_r8,1.0390e+01_r8,8.3118e+00_r8,6.2340e+00_r8, &
     &4.1559e+00_r8,2.0780e+00_r8,4.9941e-06_r8/)
      kao(:, 5,11,13) = (/ &
     &1.6312e+01_r8,1.4273e+01_r8,1.2234e+01_r8,1.0195e+01_r8,8.1562e+00_r8,6.1169e+00_r8, &
     &4.0780e+00_r8,2.0391e+00_r8,7.8208e-06_r8/)
      kao(:, 1,12,13) = (/ &
     &3.1083e+01_r8,2.7197e+01_r8,2.3312e+01_r8,1.9426e+01_r8,1.5541e+01_r8,1.1655e+01_r8, &
     &7.7704e+00_r8,3.8852e+00_r8,7.4323e-07_r8/)
      kao(:, 2,12,13) = (/ &
     &3.0431e+01_r8,2.6627e+01_r8,2.2823e+01_r8,1.9019e+01_r8,1.5215e+01_r8,1.1411e+01_r8, &
     &7.6077e+00_r8,3.8037e+00_r8,1.4468e-06_r8/)
      kao(:, 3,12,13) = (/ &
     &2.9924e+01_r8,2.6183e+01_r8,2.2443e+01_r8,1.8702e+01_r8,1.4961e+01_r8,1.1221e+01_r8, &
     &7.4808e+00_r8,3.7405e+00_r8,2.6259e-06_r8/)
      kao(:, 4,12,13) = (/ &
     &2.9439e+01_r8,2.5759e+01_r8,2.2079e+01_r8,1.8399e+01_r8,1.4719e+01_r8,1.1040e+01_r8, &
     &7.3599e+00_r8,3.6798e+00_r8,4.5448e-06_r8/)
      kao(:, 5,12,13) = (/ &
     &2.8940e+01_r8,2.5323e+01_r8,2.1705e+01_r8,1.8088e+01_r8,1.4470e+01_r8,1.0853e+01_r8, &
     &7.2348e+00_r8,3.6174e+00_r8,7.3875e-06_r8/)
      kao(:, 1,13,13) = (/ &
     &4.5024e+01_r8,3.9395e+01_r8,3.3766e+01_r8,2.8140e+01_r8,2.2511e+01_r8,1.6883e+01_r8, &
     &1.1256e+01_r8,5.6279e+00_r8,6.0376e-07_r8/)
      kao(:, 2,13,13) = (/ &
     &4.4143e+01_r8,3.8625e+01_r8,3.3107e+01_r8,2.7589e+01_r8,2.2071e+01_r8,1.6554e+01_r8, &
     &1.1035e+01_r8,5.5177e+00_r8,1.1756e-06_r8/)
      kao(:, 3,13,13) = (/ &
     &4.3457e+01_r8,3.8026e+01_r8,3.2594e+01_r8,2.7161e+01_r8,2.1728e+01_r8,1.6297e+01_r8, &
     &1.0864e+01_r8,5.4320e+00_r8,2.1118e-06_r8/)
      kao(:, 4,13,13) = (/ &
     &4.2787e+01_r8,3.7437e+01_r8,3.2089e+01_r8,2.6742e+01_r8,2.1393e+01_r8,1.6044e+01_r8, &
     &1.0696e+01_r8,5.3482e+00_r8,3.5390e-06_r8/)
      kao(:, 5,13,13) = (/ &
     &4.2071e+01_r8,3.6811e+01_r8,3.1552e+01_r8,2.6294e+01_r8,2.1034e+01_r8,1.5776e+01_r8, &
     &1.0517e+01_r8,5.2587e+00_r8,5.6752e-06_r8/)
      kao(:, 1, 1,14) = (/ &
     &8.0615e-05_r8,9.4684e-04_r8,1.8810e-03_r8,2.8058e-03_r8,3.7171e-03_r8,4.6066e-03_r8, &
     &5.4471e-03_r8,6.0480e-03_r8,7.4265e-03_r8/)
      kao(:, 2, 1,14) = (/ &
     &7.2907e-05_r8,1.3385e-03_r8,2.6578e-03_r8,3.9621e-03_r8,5.2462e-03_r8,6.4943e-03_r8, &
     &7.6854e-03_r8,8.5660e-03_r8,1.0483e-02_r8/)
      kao(:, 3, 1,14) = (/ &
     &6.3747e-05_r8,1.8288e-03_r8,3.6296e-03_r8,5.4086e-03_r8,7.1575e-03_r8,8.8508e-03_r8, &
     &1.0431e-02_r8,1.1658e-02_r8,1.4300e-02_r8/)
      kao(:, 4, 1,14) = (/ &
     &3.9260e-05_r8,2.4240e-03_r8,4.8114e-03_r8,7.1688e-03_r8,9.4794e-03_r8,1.1704e-02_r8, &
     &1.3748e-02_r8,1.5334e-02_r8,1.8941e-02_r8/)
      kao(:, 5, 1,14) = (/ &
     &2.4568e-05_r8,3.1272e-03_r8,6.2078e-03_r8,9.2494e-03_r8,1.2223e-02_r8,1.5067e-02_r8, &
     &1.7657e-02_r8,1.9583e-02_r8,2.4427e-02_r8/)
      kao(:, 1, 2,14) = (/ &
     &1.5596e-04_r8,8.5463e-04_r8,1.6898e-03_r8,2.5200e-03_r8,3.3406e-03_r8,4.1439e-03_r8, &
     &4.9117e-03_r8,5.5191e-03_r8,6.6708e-03_r8/)
      kao(:, 2, 2,14) = (/ &
     &1.3504e-04_r8,1.2362e-03_r8,2.4448e-03_r8,3.6435e-03_r8,4.8236e-03_r8,5.9777e-03_r8, &
     &7.0641e-03_r8,7.9635e-03_r8,9.6287e-03_r8/)
      kao(:, 3, 2,14) = (/ &
     &1.1284e-04_r8,1.7193e-03_r8,3.4047e-03_r8,5.0732e-03_r8,6.7143e-03_r8,8.3092e-03_r8, &
     &9.8022e-03_r8,1.1012e-02_r8,1.3405e-02_r8/)
      kao(:, 4, 2,14) = (/ &
     &7.1068e-05_r8,2.3136e-03_r8,4.5842e-03_r8,6.8306e-03_r8,9.0376e-03_r8,1.1180e-02_r8, &
     &1.3169e-02_r8,1.4761e-02_r8,1.8047e-02_r8/)
      kao(:, 5, 2,14) = (/ &
     &4.9683e-05_r8,3.0234e-03_r8,5.9956e-03_r8,8.9376e-03_r8,1.1824e-02_r8,1.4613e-02_r8, &
     &1.7201e-02_r8,1.9221e-02_r8,2.3615e-02_r8/)
      kao(:, 1, 3,14) = (/ &
     &4.8559e-04_r8,6.3562e-04_r8,1.4148e-03_r8,2.0956e-03_r8,2.7735e-03_r8,3.4411e-03_r8, &
     &4.0892e-03_r8,4.6631e-03_r8,5.5086e-03_r8/)
      kao(:, 2, 3,14) = (/ &
     &3.9874e-04_r8,1.0860e-03_r8,2.1105e-03_r8,3.1322e-03_r8,4.1464e-03_r8,5.1442e-03_r8, &
     &6.1073e-03_r8,6.9472e-03_r8,8.2419e-03_r8/)
      kao(:, 3, 3,14) = (/ &
     &3.0553e-04_r8,1.5424e-03_r8,3.0141e-03_r8,4.4802e-03_r8,5.9320e-03_r8,7.3631e-03_r8, &
     &8.7355e-03_r8,9.9159e-03_r8,1.1803e-02_r8/)
      kao(:, 4, 3,14) = (/ &
     &2.0300e-04_r8,2.1134e-03_r8,4.1489e-03_r8,6.1729e-03_r8,8.1791e-03_r8,1.0152e-02_r8, &
     &1.2037e-02_r8,1.3637e-02_r8,1.6288e-02_r8/)
      kao(:, 5, 3,14) = (/ &
     &1.2261e-04_r8,2.8083e-03_r8,5.5298e-03_r8,8.2360e-03_r8,1.0915e-02_r8,1.3546e-02_r8, &
     &1.6061e-02_r8,1.8163e-02_r8,2.1753e-02_r8/)
      kao(:, 1, 4,14) = (/ &
     &1.6340e-03_r8,1.4799e-03_r8,1.3812e-03_r8,1.7164e-03_r8,2.2393e-03_r8,2.7610e-03_r8, &
     &3.2750e-03_r8,3.7562e-03_r8,4.3569e-03_r8/)
      kao(:, 2, 4,14) = (/ &
     &1.3493e-03_r8,1.1314e-03_r8,1.6943e-03_r8,2.6409e-03_r8,3.4636e-03_r8,4.2822e-03_r8, &
     &5.0857e-03_r8,5.8323e-03_r8,6.7806e-03_r8/)
      kao(:, 3, 4,14) = (/ &
     &9.9538e-04_r8,9.6503e-04_r8,2.6483e-03_r8,3.8772e-03_r8,5.1039e-03_r8,6.3200e-03_r8, &
     &7.5138e-03_r8,8.6138e-03_r8,1.0038e-02_r8/)
      kao(:, 4, 4,14) = (/ &
     &7.1686e-04_r8,9.6594e-04_r8,3.7129e-03_r8,5.4649e-03_r8,7.2111e-03_r8,8.9436e-03_r8, &
     &1.0638e-02_r8,1.2197e-02_r8,1.4232e-02_r8/)
      kao(:, 5, 4,14) = (/ &
     &3.7667e-04_r8,1.0457e-03_r8,5.0357e-03_r8,7.4391e-03_r8,9.8310e-03_r8,1.2205e-02_r8, &
     &1.4525e-02_r8,1.6653e-02_r8,1.9453e-02_r8/)
      kao(:, 1, 5,14) = (/ &
     &4.8186e-03_r8,4.2167e-03_r8,3.6150e-03_r8,3.0747e-03_r8,2.5291e-03_r8,2.2936e-03_r8, &
     &2.5986e-03_r8,2.9578e-03_r8,3.3675e-03_r8/)
      kao(:, 2, 5,14) = (/ &
     &4.3147e-03_r8,3.7763e-03_r8,3.3322e-03_r8,2.8723e-03_r8,2.9945e-03_r8,3.5591e-03_r8, &
     &4.1803e-03_r8,4.7800e-03_r8,5.4630e-03_r8/)
      kao(:, 3, 5,14) = (/ &
     &3.5596e-03_r8,3.1147e-03_r8,2.7981e-03_r8,3.1802e-03_r8,4.4145e-03_r8,5.3933e-03_r8, &
     &6.3651e-03_r8,7.3014e-03_r8,8.3701e-03_r8/)
      kao(:, 4, 5,14) = (/ &
     &2.3785e-03_r8,2.2217e-03_r8,2.2338e-03_r8,4.4885e-03_r8,6.3608e-03_r8,7.8120e-03_r8, &
     &9.2509e-03_r8,1.0634e-02_r8,1.2219e-02_r8/)
      kao(:, 5, 5,14) = (/ &
     &1.3285e-03_r8,1.6004e-03_r8,2.5745e-03_r8,6.3438e-03_r8,8.8283e-03_r8,1.0885e-02_r8, &
     &1.2921e-02_r8,1.4873e-02_r8,1.7112e-02_r8/)
      kao(:, 1, 6,14) = (/ &
     &1.2819e-02_r8,1.1217e-02_r8,9.6163e-03_r8,8.0152e-03_r8,6.4138e-03_r8,4.8948e-03_r8, &
     &3.3434e-03_r8,2.3020e-03_r8,2.0077e-03_r8/)
      kao(:, 2, 6,14) = (/ &
     &1.2485e-02_r8,1.0926e-02_r8,9.3667e-03_r8,7.8075e-03_r8,6.3840e-03_r8,4.8805e-03_r8, &
     &3.7061e-03_r8,3.8075e-03_r8,3.4020e-03_r8/)
      kao(:, 3, 6,14) = (/ &
     &1.1272e-02_r8,9.8625e-03_r8,8.4554e-03_r8,7.3206e-03_r8,6.0114e-03_r8,5.1792e-03_r8, &
     &5.3340e-03_r8,6.0074e-03_r8,5.3316e-03_r8/)
      kao(:, 4, 6,14) = (/ &
     &1.0208e-02_r8,8.9332e-03_r8,7.9437e-03_r8,6.6798e-03_r8,5.8609e-03_r8,6.4855e-03_r8, &
     &7.9228e-03_r8,9.0010e-03_r8,7.9567e-03_r8/)
      kao(:, 5, 6,14) = (/ &
     &6.0521e-03_r8,5.2891e-03_r8,4.8269e-03_r8,4.6206e-03_r8,6.6176e-03_r8,9.3039e-03_r8, &
     &1.1293e-02_r8,1.2903e-02_r8,1.1196e-02_r8/)
      kao(:, 1, 7,14) = (/ &
     &3.6443e-02_r8,3.1891e-02_r8,2.7336e-02_r8,2.2781e-02_r8,1.8226e-02_r8,1.3673e-02_r8, &
     &9.1182e-03_r8,4.6764e-03_r8,1.4855e-04_r8/)
      kao(:, 2, 7,14) = (/ &
     &3.5471e-02_r8,3.1039e-02_r8,2.6606e-02_r8,2.2173e-02_r8,1.7742e-02_r8,1.3309e-02_r8, &
     &9.0490e-03_r8,4.6704e-03_r8,2.5095e-04_r8/)
      kao(:, 3, 7,14) = (/ &
     &3.4456e-02_r8,3.0149e-02_r8,2.5845e-02_r8,2.1540e-02_r8,1.7235e-02_r8,1.3185e-02_r8, &
     &8.9735e-03_r8,5.4794e-03_r8,4.0737e-04_r8/)
      kao(:, 4, 7,14) = (/ &
     &3.1652e-02_r8,2.7700e-02_r8,2.3744e-02_r8,1.9792e-02_r8,1.6225e-02_r8,1.2450e-02_r8, &
     &9.1363e-03_r8,7.6445e-03_r8,6.2917e-04_r8/)
      kao(:, 5, 7,14) = (/ &
     &2.9864e-02_r8,2.6135e-02_r8,2.2399e-02_r8,1.8923e-02_r8,1.5530e-02_r8,1.2143e-02_r8, &
     &1.0151e-02_r8,1.1058e-02_r8,9.1130e-04_r8/)
      kao(:, 1, 8,14) = (/ &
     &1.3223e-01_r8,1.1571e-01_r8,9.9174e-02_r8,8.2651e-02_r8,6.6122e-02_r8,4.9592e-02_r8, &
     &3.3063e-02_r8,1.6534e-02_r8,2.3921e-04_r8/)
      kao(:, 2, 8,14) = (/ &
     &1.2869e-01_r8,1.1260e-01_r8,9.6519e-02_r8,8.0434e-02_r8,6.4349e-02_r8,4.8263e-02_r8, &
     &3.2179e-02_r8,1.6093e-02_r8,4.2965e-04_r8/)
      kao(:, 3, 8,14) = (/ &
     &1.2518e-01_r8,1.0953e-01_r8,9.3886e-02_r8,7.8243e-02_r8,6.2597e-02_r8,4.6952e-02_r8, &
     &3.1306e-02_r8,1.5992e-02_r8,7.4452e-04_r8/)
      kao(:, 4, 8,14) = (/ &
     &1.2188e-01_r8,1.0664e-01_r8,9.1414e-02_r8,7.6180e-02_r8,6.0947e-02_r8,4.5714e-02_r8, &
     &3.0548e-02_r8,1.5885e-02_r8,1.1502e-03_r8/)
      kao(:, 5, 8,14) = (/ &
     &1.1492e-01_r8,1.0055e-01_r8,8.6192e-02_r8,7.1832e-02_r8,5.7467e-02_r8,4.3105e-02_r8, &
     &2.9610e-02_r8,1.5934e-02_r8,1.8646e-03_r8/)
      kao(:, 1, 9,14) = (/ &
     &9.2387e-01_r8,8.0839e-01_r8,6.9293e-01_r8,5.7740e-01_r8,4.6193e-01_r8,3.4646e-01_r8, &
     &2.3098e-01_r8,1.1549e-01_r8,2.2371e-06_r8/)
      kao(:, 2, 9,14) = (/ &
     &9.0122e-01_r8,7.8856e-01_r8,6.7591e-01_r8,5.6327e-01_r8,4.5061e-01_r8,3.3795e-01_r8, &
     &2.2531e-01_r8,1.1266e-01_r8,3.5853e-06_r8/)
      kao(:, 3, 9,14) = (/ &
     &8.7866e-01_r8,7.6881e-01_r8,6.5900e-01_r8,5.4913e-01_r8,4.3933e-01_r8,3.2948e-01_r8, &
     &2.1967e-01_r8,1.0984e-01_r8,5.0567e-06_r8/)
      kao(:, 4, 9,14) = (/ &
     &8.5611e-01_r8,7.4910e-01_r8,6.4207e-01_r8,5.3506e-01_r8,4.2806e-01_r8,3.2105e-01_r8, &
     &2.1404e-01_r8,1.0702e-01_r8,6.9838e-06_r8/)
      kao(:, 5, 9,14) = (/ &
     &8.3494e-01_r8,7.3059e-01_r8,6.2623e-01_r8,5.2185e-01_r8,4.1749e-01_r8,3.1312e-01_r8, &
     &2.0874e-01_r8,1.0439e-01_r8,9.6651e-06_r8/)
      kao(:, 1,10,14) = (/ &
     &7.7336e+00_r8,6.7669e+00_r8,5.8002e+00_r8,4.8337e+00_r8,3.8667e+00_r8,2.9002e+00_r8, &
     &1.9334e+00_r8,9.6674e-01_r8,1.4759e-06_r8/)
      kao(:, 2,10,14) = (/ &
     &7.5671e+00_r8,6.6210e+00_r8,5.6751e+00_r8,4.7295e+00_r8,3.7835e+00_r8,2.8377e+00_r8, &
     &1.8919e+00_r8,9.4588e-01_r8,2.4483e-06_r8/)
      kao(:, 3,10,14) = (/ &
     &7.3934e+00_r8,6.4694e+00_r8,5.5449e+00_r8,4.6209e+00_r8,3.6964e+00_r8,2.7725e+00_r8, &
     &1.8483e+00_r8,9.2413e-01_r8,3.6428e-06_r8/)
      kao(:, 4,10,14) = (/ &
     &7.2085e+00_r8,6.3072e+00_r8,5.4063e+00_r8,4.5053e+00_r8,3.6041e+00_r8,2.7031e+00_r8, &
     &1.8022e+00_r8,9.0111e-01_r8,5.1643e-06_r8/)
      kao(:, 5,10,14) = (/ &
     &7.0344e+00_r8,6.1551e+00_r8,5.2759e+00_r8,4.3968e+00_r8,3.5172e+00_r8,2.6378e+00_r8, &
     &1.7586e+00_r8,8.7933e-01_r8,7.2619e-06_r8/)
      kao(:, 1,11,14) = (/ &
     &2.1626e+01_r8,1.8923e+01_r8,1.6220e+01_r8,1.3516e+01_r8,1.0813e+01_r8,8.1097e+00_r8, &
     &5.4065e+00_r8,2.7033e+00_r8,1.2148e-06_r8/)
      kao(:, 2,11,14) = (/ &
     &2.1170e+01_r8,1.8523e+01_r8,1.5877e+01_r8,1.3231e+01_r8,1.0585e+01_r8,7.9391e+00_r8, &
     &5.2925e+00_r8,2.6462e+00_r8,1.9377e-06_r8/)
      kao(:, 3,11,14) = (/ &
     &2.0665e+01_r8,1.8082e+01_r8,1.5499e+01_r8,1.2916e+01_r8,1.0333e+01_r8,7.7495e+00_r8, &
     &5.1662e+00_r8,2.5832e+00_r8,2.9701e-06_r8/)
      kao(:, 4,11,14) = (/ &
     &2.0140e+01_r8,1.7623e+01_r8,1.5106e+01_r8,1.2588e+01_r8,1.0071e+01_r8,7.5528e+00_r8, &
     &5.0352e+00_r8,2.5176e+00_r8,4.4558e-06_r8/)
      kao(:, 5,11,14) = (/ &
     &1.9664e+01_r8,1.7206e+01_r8,1.4748e+01_r8,1.2290e+01_r8,9.8317e+00_r8,7.3738e+00_r8, &
     &4.9159e+00_r8,2.4579e+00_r8,6.2661e-06_r8/)
      kao(:, 1,12,14) = (/ &
     &3.8270e+01_r8,3.3486e+01_r8,2.8703e+01_r8,2.3919e+01_r8,1.9135e+01_r8,1.4352e+01_r8, &
     &9.5673e+00_r8,4.7836e+00_r8,1.1282e-06_r8/)
      kao(:, 2,12,14) = (/ &
     &3.7417e+01_r8,3.2741e+01_r8,2.8063e+01_r8,2.3387e+01_r8,1.8709e+01_r8,1.4031e+01_r8, &
     &9.3545e+00_r8,4.6770e+00_r8,1.8527e-06_r8/)
      kao(:, 3,12,14) = (/ &
     &3.6489e+01_r8,3.1928e+01_r8,2.7367e+01_r8,2.2805e+01_r8,1.8244e+01_r8,1.3683e+01_r8, &
     &9.1218e+00_r8,4.5610e+00_r8,2.7902e-06_r8/)
      kao(:, 4,12,14) = (/ &
     &3.5556e+01_r8,3.1112e+01_r8,2.6666e+01_r8,2.2223e+01_r8,1.7778e+01_r8,1.3333e+01_r8, &
     &8.8890e+00_r8,4.4446e+00_r8,3.8795e-06_r8/)
      kao(:, 5,12,14) = (/ &
     &3.4682e+01_r8,3.0344e+01_r8,2.6011e+01_r8,2.1676e+01_r8,1.7341e+01_r8,1.3005e+01_r8, &
     &8.6702e+00_r8,4.3349e+00_r8,5.0987e-06_r8/)
      kao(:, 1,13,14) = (/ &
     &5.4806e+01_r8,4.7955e+01_r8,4.1104e+01_r8,3.4254e+01_r8,2.7403e+01_r8,2.0551e+01_r8, &
     &1.3701e+01_r8,6.8507e+00_r8,9.3782e-07_r8/)
      kao(:, 2,13,14) = (/ &
     &5.3507e+01_r8,4.6818e+01_r8,4.0130e+01_r8,3.3442e+01_r8,2.6753e+01_r8,2.0066e+01_r8, &
     &1.3376e+01_r8,6.6886e+00_r8,1.6696e-06_r8/)
      kao(:, 3,13,14) = (/ &
     &5.2032e+01_r8,4.5528e+01_r8,3.9023e+01_r8,3.2519e+01_r8,2.6015e+01_r8,1.9512e+01_r8, &
     &1.3008e+01_r8,6.5038e+00_r8,2.8850e-06_r8/)
      kao(:, 4,13,14) = (/ &
     &5.0622e+01_r8,4.4293e+01_r8,3.7966e+01_r8,3.1638e+01_r8,2.5310e+01_r8,1.8983e+01_r8, &
     &1.2655e+01_r8,6.3275e+00_r8,4.3456e-06_r8/)
      kao(:, 5,13,14) = (/ &
     &4.9341e+01_r8,4.3174e+01_r8,3.7007e+01_r8,3.0838e+01_r8,2.4670e+01_r8,1.8503e+01_r8, &
     &1.2335e+01_r8,6.1672e+00_r8,6.2672e-06_r8/)
      kao(:, 1, 1,15) = (/ &
     &9.0368e-05_r8,1.7587e-03_r8,3.4692e-03_r8,5.1215e-03_r8,6.6729e-03_r8,8.0447e-03_r8, &
     &9.0360e-03_r8,8.9574e-03_r8,1.3337e-02_r8/)
      kao(:, 2, 1,15) = (/ &
     &8.5673e-05_r8,2.5288e-03_r8,4.9923e-03_r8,7.3709e-03_r8,9.6068e-03_r8,1.1588e-02_r8, &
     &1.3021e-02_r8,1.2915e-02_r8,1.9203e-02_r8/)
      kao(:, 3, 1,15) = (/ &
     &7.5800e-05_r8,3.4920e-03_r8,6.8957e-03_r8,1.0184e-02_r8,1.3280e-02_r8,1.6021e-02_r8, &
     &1.8010e-02_r8,1.7888e-02_r8,2.6548e-02_r8/)
      kao(:, 4, 1,15) = (/ &
     &6.6885e-05_r8,4.6582e-03_r8,9.2038e-03_r8,1.3596e-02_r8,1.7729e-02_r8,2.1393e-02_r8, &
     &2.4064e-02_r8,2.3923e-02_r8,3.5446e-02_r8/)
      kao(:, 5, 1,15) = (/ &
     &2.9277e-05_r8,6.0336e-03_r8,1.1922e-02_r8,1.7611e-02_r8,2.2979e-02_r8,2.7733e-02_r8, &
     &3.1220e-02_r8,3.1058e-02_r8,4.5944e-02_r8/)
      kao(:, 1, 2,15) = (/ &
     &1.6162e-04_r8,1.7658e-03_r8,3.4927e-03_r8,5.1816e-03_r8,6.8087e-03_r8,8.3146e-03_r8, &
     &9.5542e-03_r8,9.9349e-03_r8,1.3602e-02_r8/)
      kao(:, 2, 2,15) = (/ &
     &1.4940e-04_r8,2.5810e-03_r8,5.1093e-03_r8,7.5846e-03_r8,9.9670e-03_r8,1.2178e-02_r8, &
     &1.4000e-02_r8,1.4578e-02_r8,1.9917e-02_r8/)
      kao(:, 3, 2,15) = (/ &
     &1.4212e-04_r8,3.6142e-03_r8,7.1589e-03_r8,1.0631e-02_r8,1.3977e-02_r8,1.7085e-02_r8, &
     &1.9645e-02_r8,2.0472e-02_r8,2.7934e-02_r8/)
      kao(:, 4, 2,15) = (/ &
     &1.2057e-04_r8,4.8773e-03_r8,9.6676e-03_r8,1.4359e-02_r8,1.8882e-02_r8,2.3081e-02_r8, &
     &2.6561e-02_r8,2.7724e-02_r8,3.7741e-02_r8/)
      kao(:, 5, 2,15) = (/ &
     &6.0191e-05_r8,6.3788e-03_r8,1.2648e-02_r8,1.8790e-02_r8,2.4713e-02_r8,3.0224e-02_r8, &
     &3.4797e-02_r8,3.6354e-02_r8,4.9402e-02_r8/)
      kao(:, 1, 3,15) = (/ &
     &4.4246e-04_r8,1.6142e-03_r8,3.1839e-03_r8,4.7378e-03_r8,6.2661e-03_r8,7.7441e-03_r8, &
     &9.0975e-03_r8,1.0015e-02_r8,1.2497e-02_r8/)
      kao(:, 2, 3,15) = (/ &
     &3.8619e-04_r8,2.4195e-03_r8,4.7839e-03_r8,7.1249e-03_r8,9.4281e-03_r8,1.1657e-02_r8, &
     &1.3699e-02_r8,1.5096e-02_r8,1.8815e-02_r8/)
      kao(:, 3, 3,15) = (/ &
     &3.7186e-04_r8,3.4615e-03_r8,6.8531e-03_r8,1.0215e-02_r8,1.3514e-02_r8,1.6722e-02_r8, &
     &1.9664e-02_r8,2.1688e-02_r8,2.6981e-02_r8/)
      kao(:, 4, 3,15) = (/ &
     &3.4136e-04_r8,4.7556e-03_r8,9.4307e-03_r8,1.4062e-02_r8,1.8619e-02_r8,2.3030e-02_r8, &
     &2.7098e-02_r8,2.9910e-02_r8,3.7185e-02_r8/)
      kao(:, 5, 3,15) = (/ &
     &2.7238e-04_r8,6.3154e-03_r8,1.2533e-02_r8,1.8695e-02_r8,2.4762e-02_r8,3.0640e-02_r8, &
     &3.6060e-02_r8,3.9831e-02_r8,4.9464e-02_r8/)
      kao(:, 1, 4,15) = (/ &
     &1.8439e-03_r8,1.6255e-03_r8,2.7662e-03_r8,4.1011e-03_r8,5.4250e-03_r8,6.7307e-03_r8, &
     &7.9903e-03_r8,9.0701e-03_r8,1.0766e-02_r8/)
      kao(:, 2, 4,15) = (/ &
     &1.2780e-03_r8,2.0382e-03_r8,4.2819e-03_r8,6.3618e-03_r8,8.4274e-03_r8,1.0464e-02_r8, &
     &1.2431e-02_r8,1.4123e-02_r8,1.6753e-02_r8/)
      kao(:, 3, 4,15) = (/ &
     &1.0129e-03_r8,3.1935e-03_r8,6.2902e-03_r8,9.3615e-03_r8,1.2411e-02_r8,1.5417e-02_r8, &
     &1.8325e-02_r8,2.0828e-02_r8,2.4703e-02_r8/)
      kao(:, 4, 4,15) = (/ &
     &9.5662e-04_r8,4.4942e-03_r8,8.8414e-03_r8,1.3166e-02_r8,1.7466e-02_r8,2.1716e-02_r8, &
     &2.5826e-02_r8,2.9379e-02_r8,3.4795e-02_r8/)
      kao(:, 5, 4,15) = (/ &
     &7.9817e-04_r8,6.0664e-03_r8,1.1965e-02_r8,1.7841e-02_r8,2.3679e-02_r8,2.9437e-02_r8, &
     &3.5012e-02_r8,3.9861e-02_r8,4.7202e-02_r8/)
      kao(:, 1, 5,15) = (/ &
     &5.1399e-03_r8,4.4963e-03_r8,3.8550e-03_r8,3.7300e-03_r8,4.5601e-03_r8,5.6445e-03_r8, &
     &6.7084e-03_r8,7.7027e-03_r8,8.9288e-03_r8/)
      kao(:, 2, 5,15) = (/ &
     &4.9517e-03_r8,4.3316e-03_r8,4.1416e-03_r8,5.5566e-03_r8,7.3222e-03_r8,9.0762e-03_r8, &
     &1.0805e-02_r8,1.2425e-02_r8,1.4409e-02_r8/)
      kao(:, 3, 5,15) = (/ &
     &3.6157e-03_r8,3.1633e-03_r8,5.3630e-03_r8,8.3885e-03_r8,1.1080e-02_r8,1.3756e-02_r8, &
     &1.6391e-02_r8,1.8868e-02_r8,2.1878e-02_r8/)
      kao(:, 4, 5,15) = (/ &
     &2.5485e-03_r8,3.2448e-03_r8,8.0168e-03_r8,1.2065e-02_r8,1.5959e-02_r8,1.9835e-02_r8, &
     &2.3656e-02_r8,2.7245e-02_r8,3.1588e-02_r8/)
      kao(:, 5, 5,15) = (/ &
     &2.2002e-03_r8,3.7004e-03_r8,1.1229e-02_r8,1.6648e-02_r8,2.2051e-02_r8,2.7414e-02_r8, &
     &3.2714e-02_r8,3.7713e-02_r8,4.3725e-02_r8/)
      kao(:, 1, 6,15) = (/ &
     &1.3785e-02_r8,1.2061e-02_r8,1.0339e-02_r8,8.6158e-03_r8,6.8942e-03_r8,5.5266e-03_r8, &
     &5.3843e-03_r8,6.1361e-03_r8,7.0081e-03_r8/)
      kao(:, 2, 6,15) = (/ &
     &1.3401e-02_r8,1.1726e-02_r8,1.0052e-02_r8,8.3774e-03_r8,7.3256e-03_r8,7.6626e-03_r8, &
     &8.9483e-03_r8,1.0302e-02_r8,1.1787e-02_r8/)
      kao(:, 3, 6,15) = (/ &
     &1.3001e-02_r8,1.1375e-02_r8,9.7516e-03_r8,8.8385e-03_r8,9.7753e-03_r8,1.1803e-02_r8, &
     &1.4015e-02_r8,1.6165e-02_r8,1.8521e-02_r8/)
      kao(:, 4, 6,15) = (/ &
     &1.0311e-02_r8,9.0242e-03_r8,7.7593e-03_r8,9.8758e-03_r8,1.4142e-02_r8,1.7458e-02_r8, &
     &2.0764e-02_r8,2.3987e-02_r8,2.7500e-02_r8/)
      kao(:, 5, 6,15) = (/ &
     &6.1007e-03_r8,5.3334e-03_r8,8.4379e-03_r8,1.3947e-02_r8,1.9967e-02_r8,2.4665e-02_r8, &
     &2.9359e-02_r8,3.3960e-02_r8,3.8947e-02_r8/)
      kao(:, 1, 7,15) = (/ &
     &3.9607e-02_r8,3.4655e-02_r8,2.9704e-02_r8,2.4754e-02_r8,1.9804e-02_r8,1.4853e-02_r8, &
     &9.9024e-03_r8,5.6087e-03_r8,4.7437e-03_r8/)
      kao(:, 2, 7,15) = (/ &
     &3.8786e-02_r8,3.3939e-02_r8,2.9089e-02_r8,2.4244e-02_r8,1.9395e-02_r8,1.4546e-02_r8, &
     &1.0087e-02_r8,8.3483e-03_r8,8.1480e-03_r8/)
      kao(:, 3, 7,15) = (/ &
     &3.7941e-02_r8,3.3203e-02_r8,2.8458e-02_r8,2.3715e-02_r8,1.8973e-02_r8,1.4624e-02_r8, &
     &1.2669e-02_r8,1.3455e-02_r8,1.2971e-02_r8/)
      kao(:, 4, 7,15) = (/ &
     &3.7052e-02_r8,3.2423e-02_r8,2.7792e-02_r8,2.3160e-02_r8,1.8933e-02_r8,1.7157e-02_r8, &
     &1.8083e-02_r8,2.0593e-02_r8,1.9406e-02_r8/)
      kao(:, 5, 7,15) = (/ &
     &3.1592e-02_r8,2.7646e-02_r8,2.3693e-02_r8,2.0299e-02_r8,1.8491e-02_r8,2.1228e-02_r8, &
     &2.6244e-02_r8,2.9985e-02_r8,2.7520e-02_r8/)
      kao(:, 1, 8,15) = (/ &
     &1.4580e-01_r8,1.2758e-01_r8,1.0936e-01_r8,9.1128e-02_r8,7.2910e-02_r8,5.4675e-02_r8, &
     &3.6454e-02_r8,1.8228e-02_r8,7.5823e-04_r8/)
      kao(:, 2, 8,15) = (/ &
     &1.4341e-01_r8,1.2548e-01_r8,1.0755e-01_r8,8.9631e-02_r8,7.1703e-02_r8,5.3780e-02_r8, &
     &3.5854e-02_r8,1.7928e-02_r8,1.3701e-03_r8/)
      kao(:, 3, 8,15) = (/ &
     &1.4083e-01_r8,1.2323e-01_r8,1.0562e-01_r8,8.8019e-02_r8,7.0413e-02_r8,5.2809e-02_r8, &
     &3.5210e-02_r8,1.8039e-02_r8,2.2984e-03_r8/)
      kao(:, 4, 8,15) = (/ &
     &1.3806e-01_r8,1.2080e-01_r8,1.0354e-01_r8,8.6290e-02_r8,6.9028e-02_r8,5.1771e-02_r8, &
     &3.4515e-02_r8,2.0878e-02_r8,3.6182e-03_r8/)
      kao(:, 5, 8,15) = (/ &
     &1.3508e-01_r8,1.1820e-01_r8,1.0132e-01_r8,8.4431e-02_r8,6.7546e-02_r8,5.0657e-02_r8, &
     &3.5330e-02_r8,2.7298e-02_r8,5.3909e-03_r8/)
      kao(:, 1, 9,15) = (/ &
     &1.0374e+00_r8,9.0767e-01_r8,7.7802e-01_r8,6.4832e-01_r8,5.1864e-01_r8,3.8900e-01_r8, &
     &2.5933e-01_r8,1.2966e-01_r8,2.1397e-06_r8/)
      kao(:, 2, 9,15) = (/ &
     &1.0197e+00_r8,8.9224e-01_r8,7.6478e-01_r8,6.3733e-01_r8,5.0988e-01_r8,3.8239e-01_r8, &
     &2.5493e-01_r8,1.2747e-01_r8,3.4826e-06_r8/)
      kao(:, 3, 9,15) = (/ &
     &1.0031e+00_r8,8.7777e-01_r8,7.5240e-01_r8,6.2700e-01_r8,5.0158e-01_r8,3.7619e-01_r8, &
     &2.5081e-01_r8,1.2540e-01_r8,5.6811e-06_r8/)
      kao(:, 4, 9,15) = (/ &
     &9.8558e-01_r8,8.6233e-01_r8,7.3918e-01_r8,6.1597e-01_r8,4.9277e-01_r8,3.6960e-01_r8, &
     &2.4641e-01_r8,1.2320e-01_r8,9.7907e-06_r8/)
      kao(:, 5, 9,15) = (/ &
     &9.6612e-01_r8,8.4542e-01_r8,7.2465e-01_r8,6.0387e-01_r8,4.8310e-01_r8,3.6231e-01_r8, &
     &2.4155e-01_r8,1.2077e-01_r8,1.4737e-05_r8/)
      kao(:, 1,10,15) = (/ &
     &8.9111e+00_r8,7.7969e+00_r8,6.6836e+00_r8,5.5691e+00_r8,4.4554e+00_r8,3.3414e+00_r8, &
     &2.2275e+00_r8,1.1138e+00_r8,1.1507e-06_r8/)
      kao(:, 2,10,15) = (/ &
     &8.7649e+00_r8,7.6684e+00_r8,6.5728e+00_r8,5.4777e+00_r8,4.3822e+00_r8,3.2866e+00_r8, &
     &2.1910e+00_r8,1.0955e+00_r8,1.9584e-06_r8/)
      kao(:, 3,10,15) = (/ &
     &8.6133e+00_r8,7.5361e+00_r8,6.4598e+00_r8,5.3829e+00_r8,4.3064e+00_r8,3.2299e+00_r8, &
     &2.1532e+00_r8,1.0766e+00_r8,3.2367e-06_r8/)
      kao(:, 4,10,15) = (/ &
     &8.4534e+00_r8,7.3969e+00_r8,6.3406e+00_r8,5.2836e+00_r8,4.2270e+00_r8,3.1701e+00_r8, &
     &2.1135e+00_r8,1.0568e+00_r8,5.5316e-06_r8/)
      kao(:, 5,10,15) = (/ &
     &8.2801e+00_r8,7.2444e+00_r8,6.2095e+00_r8,5.1748e+00_r8,4.1398e+00_r8,3.1049e+00_r8, &
     &2.0699e+00_r8,1.0350e+00_r8,8.6177e-06_r8/)
      kao(:, 1,11,15) = (/ &
     &2.5435e+01_r8,2.2258e+01_r8,1.9079e+01_r8,1.5898e+01_r8,1.2719e+01_r8,9.5392e+00_r8, &
     &6.3596e+00_r8,3.1798e+00_r8,8.0677e-07_r8/)
      kao(:, 2,11,15) = (/ &
     &2.5109e+01_r8,2.1970e+01_r8,1.8832e+01_r8,1.5693e+01_r8,1.2554e+01_r8,9.4153e+00_r8, &
     &6.2771e+00_r8,3.1385e+00_r8,1.4119e-06_r8/)
      kao(:, 3,11,15) = (/ &
     &2.4708e+01_r8,2.1620e+01_r8,1.8532e+01_r8,1.5442e+01_r8,1.2355e+01_r8,9.2660e+00_r8, &
     &6.1771e+00_r8,3.0885e+00_r8,2.4283e-06_r8/)
      kao(:, 4,11,15) = (/ &
     &2.4206e+01_r8,2.1181e+01_r8,1.8155e+01_r8,1.5130e+01_r8,1.2103e+01_r8,9.0784e+00_r8, &
     &6.0520e+00_r8,3.0256e+00_r8,3.8467e-06_r8/)
      kao(:, 5,11,15) = (/ &
     &2.3645e+01_r8,2.0690e+01_r8,1.7735e+01_r8,1.4778e+01_r8,1.1822e+01_r8,8.8671e+00_r8, &
     &5.9114e+00_r8,2.9557e+00_r8,6.2945e-06_r8/)
      kao(:, 1,12,15) = (/ &
     &4.5821e+01_r8,4.0093e+01_r8,3.4365e+01_r8,2.8640e+01_r8,2.2910e+01_r8,1.7183e+01_r8, &
     &1.1455e+01_r8,5.7277e+00_r8,5.6905e-07_r8/)
      kao(:, 2,12,15) = (/ &
     &4.5215e+01_r8,3.9561e+01_r8,3.3912e+01_r8,2.8260e+01_r8,2.2608e+01_r8,1.6955e+01_r8, &
     &1.1304e+01_r8,5.6520e+00_r8,1.0466e-06_r8/)
      kao(:, 3,12,15) = (/ &
     &4.4441e+01_r8,3.8886e+01_r8,3.3332e+01_r8,2.7776e+01_r8,2.2220e+01_r8,1.6665e+01_r8, &
     &1.1110e+01_r8,5.5552e+00_r8,1.8066e-06_r8/)
      kao(:, 4,12,15) = (/ &
     &4.3598e+01_r8,3.8150e+01_r8,3.2698e+01_r8,2.7250e+01_r8,2.1798e+01_r8,1.6350e+01_r8, &
     &1.0900e+01_r8,5.4499e+00_r8,2.8751e-06_r8/)
      kao(:, 5,12,15) = (/ &
     &4.2666e+01_r8,3.7332e+01_r8,3.2000e+01_r8,2.6665e+01_r8,2.1333e+01_r8,1.6001e+01_r8, &
     &1.0666e+01_r8,5.3333e+00_r8,4.5303e-06_r8/)
      kao(:, 1,13,15) = (/ &
     &6.6305e+01_r8,5.8017e+01_r8,4.9731e+01_r8,4.1443e+01_r8,3.3153e+01_r8,2.4866e+01_r8, &
     &1.6576e+01_r8,8.2888e+00_r8,6.5868e-07_r8/)
      kao(:, 2,13,15) = (/ &
     &6.5425e+01_r8,5.7245e+01_r8,4.9068e+01_r8,4.0889e+01_r8,3.2711e+01_r8,2.4534e+01_r8, &
     &1.6356e+01_r8,8.1783e+00_r8,1.0770e-06_r8/)
      kao(:, 3,13,15) = (/ &
     &6.4452e+01_r8,5.6397e+01_r8,4.8336e+01_r8,4.0283e+01_r8,3.2227e+01_r8,2.4169e+01_r8, &
     &1.6113e+01_r8,8.0564e+00_r8,1.3521e-06_r8/)
      kao(:, 4,13,15) = (/ &
     &6.3313e+01_r8,5.5397e+01_r8,4.7486e+01_r8,3.9571e+01_r8,3.1655e+01_r8,2.3741e+01_r8, &
     &1.5828e+01_r8,7.9140e+00_r8,2.2152e-06_r8/)
      kao(:, 5,13,15) = (/ &
     &6.1963e+01_r8,5.4219e+01_r8,4.6473e+01_r8,3.8726e+01_r8,3.0982e+01_r8,2.3236e+01_r8, &
     &1.5490e+01_r8,7.7450e+00_r8,3.4066e-06_r8/)
      kao(:, 1, 1,16) = (/ &
     &8.8773e-05_r8,1.9140e-03_r8,3.7690e-03_r8,5.5469e-03_r8,7.2016e-03_r8,8.6351e-03_r8, &
     &9.6093e-03_r8,9.3558e-03_r8,1.4394e-02_r8/)
      kao(:, 2, 1,16) = (/ &
     &8.4216e-05_r8,2.7660e-03_r8,5.4492e-03_r8,8.0218e-03_r8,1.0416e-02_r8,1.2486e-02_r8, &
     &1.3893e-02_r8,1.3527e-02_r8,2.0822e-02_r8/)
      kao(:, 3, 1,16) = (/ &
     &8.0290e-05_r8,3.8383e-03_r8,7.5630e-03_r8,1.1136e-02_r8,1.4457e-02_r8,1.7334e-02_r8, &
     &1.9290e-02_r8,1.8781e-02_r8,2.8902e-02_r8/)
      kao(:, 4, 1,16) = (/ &
     &7.6611e-05_r8,5.1452e-03_r8,1.0139e-02_r8,1.4930e-02_r8,1.9392e-02_r8,2.3248e-02_r8, &
     &2.5870e-02_r8,2.5185e-02_r8,3.8771e-02_r8/)
      kao(:, 5, 1,16) = (/ &
     &7.3163e-05_r8,6.6935e-03_r8,1.3197e-02_r8,1.9435e-02_r8,2.5235e-02_r8,3.0263e-02_r8, &
     &3.3675e-02_r8,3.2771e-02_r8,5.0455e-02_r8/)
      kao(:, 1, 2,16) = (/ &
     &1.5679e-04_r8,1.9888e-03_r8,3.9277e-03_r8,5.8149e-03_r8,7.6126e-03_r8,9.2475e-03_r8, &
     &1.0521e-02_r8,1.0714e-02_r8,1.5210e-02_r8/)
      kao(:, 2, 2,16) = (/ &
     &1.4773e-04_r8,2.9274e-03_r8,5.7862e-03_r8,8.5677e-03_r8,1.1217e-02_r8,1.3627e-02_r8, &
     &1.5504e-02_r8,1.5787e-02_r8,2.2417e-02_r8/)
      kao(:, 3, 2,16) = (/ &
     &1.4025e-04_r8,4.1262e-03_r8,8.1606e-03_r8,1.2085e-02_r8,1.5823e-02_r8,1.9223e-02_r8, &
     &2.1876e-02_r8,2.2273e-02_r8,3.1626e-02_r8/)
      kao(:, 4, 2,16) = (/ &
     &1.3354e-04_r8,5.6053e-03_r8,1.1089e-02_r8,1.6429e-02_r8,2.1516e-02_r8,2.6138e-02_r8, &
     &2.9742e-02_r8,3.0283e-02_r8,4.3010e-02_r8/)
      kao(:, 5, 2,16) = (/ &
     &1.2725e-04_r8,7.3793e-03_r8,1.4605e-02_r8,2.1632e-02_r8,2.8334e-02_r8,3.4423e-02_r8, &
     &3.9175e-02_r8,3.9879e-02_r8,5.6642e-02_r8/)
      kao(:, 1, 3,16) = (/ &
     &4.1725e-04_r8,1.8982e-03_r8,3.7447e-03_r8,5.5658e-03_r8,7.3458e-03_r8,9.0433e-03_r8, &
     &1.0548e-02_r8,1.1397e-02_r8,1.4655e-02_r8/)
      kao(:, 2, 3,16) = (/ &
     &3.9098e-04_r8,2.8734e-03_r8,5.6787e-03_r8,8.4482e-03_r8,1.1153e-02_r8,1.3733e-02_r8, &
     &1.6021e-02_r8,1.7312e-02_r8,2.2262e-02_r8/)
      kao(:, 3, 3,16) = (/ &
     &3.4851e-04_r8,4.1474e-03_r8,8.2100e-03_r8,1.2218e-02_r8,1.6131e-02_r8,1.9869e-02_r8, &
     &2.3184e-02_r8,2.5055e-02_r8,3.2211e-02_r8/)
      kao(:, 4, 3,16) = (/ &
     &3.3110e-04_r8,5.7507e-03_r8,1.1396e-02_r8,1.6965e-02_r8,2.2409e-02_r8,2.7601e-02_r8, &
     &3.2208e-02_r8,3.4575e-02_r8,4.4760e-02_r8/)
      kao(:, 5, 3,16) = (/ &
     &3.1495e-04_r8,7.7054e-03_r8,1.5281e-02_r8,2.2758e-02_r8,3.0062e-02_r8,3.7025e-02_r8, &
     &4.3208e-02_r8,4.6704e-02_r8,6.0059e-02_r8/)
      kao(:, 1, 4,16) = (/ &
     &1.7281e-03_r8,1.7667e-03_r8,3.4371e-03_r8,5.0959e-03_r8,6.7367e-03_r8,8.3430e-03_r8, &
     &9.8600e-03_r8,1.1050e-02_r8,1.3383e-02_r8/)
      kao(:, 2, 4,16) = (/ &
     &1.1628e-03_r8,2.7537e-03_r8,5.3881e-03_r8,8.0069e-03_r8,1.0596e-02_r8,1.3125e-02_r8, &
     &1.5518e-02_r8,1.7399e-02_r8,2.1083e-02_r8/)
      kao(:, 3, 4,16) = (/ &
     &1.1124e-03_r8,4.0786e-03_r8,8.0137e-03_r8,1.1921e-02_r8,1.5788e-02_r8,1.9566e-02_r8, &
     &2.3141e-02_r8,2.5952e-02_r8,3.1447e-02_r8/)
      kao(:, 4, 4,16) = (/ &
     &1.0810e-03_r8,5.7837e-03_r8,1.1394e-02_r8,1.6970e-02_r8,2.2483e-02_r8,2.7876e-02_r8, &
     &3.2974e-02_r8,3.6985e-02_r8,4.4815e-02_r8/)
      kao(:, 5, 4,16) = (/ &
     &9.9376e-04_r8,7.9012e-03_r8,1.5599e-02_r8,2.3249e-02_r8,3.0813e-02_r8,3.8207e-02_r8, &
     &4.5202e-02_r8,5.0705e-02_r8,6.1455e-02_r8/)
      kao(:, 1, 5,16) = (/ &
     &5.4114e-03_r8,4.7354e-03_r8,4.0587e-03_r8,4.6142e-03_r8,6.0695e-03_r8,7.5080e-03_r8, &
     &8.9059e-03_r8,1.0147e-02_r8,1.1928e-02_r8/)
      kao(:, 2, 5,16) = (/ &
     &5.1867e-03_r8,4.5542e-03_r8,5.0981e-03_r8,7.5059e-03_r8,9.9017e-03_r8,1.2267e-02_r8, &
     &1.4567e-02_r8,1.6610e-02_r8,1.9542e-02_r8/)
      kao(:, 3, 5,16) = (/ &
     &3.0269e-03_r8,2.6488e-03_r8,7.7938e-03_r8,1.1517e-02_r8,1.5221e-02_r8,1.8876e-02_r8, &
     &2.2431e-02_r8,2.5594e-02_r8,3.0125e-02_r8/)
      kao(:, 4, 5,16) = (/ &
     &2.9184e-03_r8,2.5534e-03_r8,1.1353e-02_r8,1.6816e-02_r8,2.2248e-02_r8,2.7623e-02_r8, &
     &3.2847e-02_r8,3.7486e-02_r8,4.4122e-02_r8/)
      kao(:, 5, 5,16) = (/ &
     &2.8186e-03_r8,8.1567e-03_r8,1.5865e-02_r8,2.3545e-02_r8,3.1185e-02_r8,3.8732e-02_r8, &
     &4.6076e-02_r8,5.2599e-02_r8,6.1936e-02_r8/)
      kao(:, 1, 6,16) = (/ &
     &1.4590e-02_r8,1.2765e-02_r8,1.0941e-02_r8,9.1186e-03_r8,7.2947e-03_r8,6.5373e-03_r8, &
     &7.7212e-03_r8,8.8306e-03_r8,1.0195e-02_r8/)
      kao(:, 2, 6,16) = (/ &
     &1.4301e-02_r8,1.2513e-02_r8,1.0724e-02_r8,8.9392e-03_r8,9.0428e-03_r8,1.1132e-02_r8, &
     &1.3188e-02_r8,1.5117e-02_r8,1.7482e-02_r8/)
      kao(:, 3, 6,16) = (/ &
     &1.3976e-02_r8,1.2228e-02_r8,1.0485e-02_r8,1.0970e-02_r8,1.4363e-02_r8,1.7735e-02_r8, &
     &2.1052e-02_r8,2.4167e-02_r8,2.7980e-02_r8/)
      kao(:, 4, 6,16) = (/ &
     &7.5839e-03_r8,6.6346e-03_r8,9.3364e-03_r8,1.6444e-02_r8,2.1598e-02_r8,2.6720e-02_r8, &
     &3.1771e-02_r8,3.6510e-02_r8,4.2297e-02_r8/)
      kao(:, 5, 6,16) = (/ &
     &7.3499e-03_r8,6.4297e-03_r8,1.6063e-02_r8,2.3546e-02_r8,3.1010e-02_r8,3.8427e-02_r8, &
     &4.5729e-02_r8,5.2589e-02_r8,6.0961e-02_r8/)
      kao(:, 1, 7,16) = (/ &
     &4.2002e-02_r8,3.6747e-02_r8,3.1501e-02_r8,2.6251e-02_r8,2.1002e-02_r8,1.5754e-02_r8, &
     &1.0500e-02_r8,7.5058e-03_r8,8.4905e-03_r8/)
      kao(:, 2, 7,16) = (/ &
     &4.1348e-02_r8,3.6182e-02_r8,3.1017e-02_r8,2.5842e-02_r8,2.0675e-02_r8,1.5509e-02_r8, &
     &1.1819e-02_r8,1.3466e-02_r8,1.5310e-02_r8/)
      kao(:, 3, 7,16) = (/ &
     &4.0563e-02_r8,3.5489e-02_r8,3.0424e-02_r8,2.5351e-02_r8,2.0286e-02_r8,1.6643e-02_r8, &
     &1.9563e-02_r8,2.2386e-02_r8,2.5539e-02_r8/)
      kao(:, 4, 7,16) = (/ &
     &3.9401e-02_r8,3.4717e-02_r8,2.9752e-02_r8,2.4793e-02_r8,2.1115e-02_r8,2.5798e-02_r8, &
     &3.0449e-02_r8,3.4941e-02_r8,3.9945e-02_r8/)
      kao(:, 5, 7,16) = (/ &
     &2.0373e-02_r8,1.7827e-02_r8,1.5278e-02_r8,1.2733e-02_r8,3.0987e-02_r8,3.8017e-02_r8, &
     &4.4987e-02_r8,5.1736e-02_r8,5.9242e-02_r8/)
      kao(:, 1, 8,16) = (/ &
     &1.5400e-01_r8,1.3474e-01_r8,1.1553e-01_r8,9.6239e-02_r8,7.7005e-02_r8,5.7761e-02_r8, &
     &3.8504e-02_r8,1.9252e-02_r8,6.9298e-03_r8/)
      kao(:, 2, 8,16) = (/ &
     &1.5231e-01_r8,1.3330e-01_r8,1.1425e-01_r8,9.5219e-02_r8,7.6158e-02_r8,5.7117e-02_r8, &
     &3.8082e-02_r8,1.9041e-02_r8,1.3109e-02_r8/)
      kao(:, 3, 8,16) = (/ &
     &1.4996e-01_r8,1.3122e-01_r8,1.1247e-01_r8,9.3714e-02_r8,7.4984e-02_r8,5.6235e-02_r8, &
     &3.7492e-02_r8,2.0794e-02_r8,2.1673e-02_r8/)
      kao(:, 4, 8,16) = (/ &
     &1.4710e-01_r8,1.2871e-01_r8,1.1034e-01_r8,9.1947e-02_r8,7.3562e-02_r8,5.5161e-02_r8, &
     &3.6783e-02_r8,3.3457e-02_r8,3.2749e-02_r8/)
      kao(:, 5, 8,16) = (/ &
     &1.4389e-01_r8,1.2590e-01_r8,1.0792e-01_r8,8.9927e-02_r8,7.1955e-02_r8,5.3965e-02_r8, &
     &4.4963e-02_r8,5.0849e-02_r8,4.4095e-02_r8/)
      kao(:, 1, 9,16) = (/ &
     &1.0859e+00_r8,9.5014e-01_r8,8.1454e-01_r8,6.7879e-01_r8,5.4303e-01_r8,4.0724e-01_r8, &
     &2.7149e-01_r8,1.3574e-01_r8,5.1220e-06_r8/)
      kao(:, 2, 9,16) = (/ &
     &1.0768e+00_r8,9.4216e-01_r8,8.0759e-01_r8,6.7299e-01_r8,5.3840e-01_r8,4.0381e-01_r8, &
     &2.6917e-01_r8,1.3460e-01_r8,1.2021e-05_r8/)
      kao(:, 3, 9,16) = (/ &
     &1.0636e+00_r8,9.3068e-01_r8,7.9788e-01_r8,6.6477e-01_r8,5.3197e-01_r8,3.9888e-01_r8, &
     &2.6599e-01_r8,1.3299e-01_r8,2.0747e-05_r8/)
      kao(:, 4, 9,16) = (/ &
     &1.0462e+00_r8,9.1536e-01_r8,7.8477e-01_r8,6.5394e-01_r8,5.2317e-01_r8,3.9241e-01_r8, &
     &2.6164e-01_r8,1.3081e-01_r8,2.6757e-05_r8/)
      kao(:, 5, 9,16) = (/ &
     &1.0256e+00_r8,8.9712e-01_r8,7.6891e-01_r8,6.4089e-01_r8,5.1277e-01_r8,3.8454e-01_r8, &
     &2.5635e-01_r8,1.2820e-01_r8,3.3237e-05_r8/)
      kao(:, 1,10,16) = (/ &
     &9.2943e+00_r8,8.1330e+00_r8,6.9713e+00_r8,5.8089e+00_r8,4.6478e+00_r8,3.4621e+00_r8, &
     &2.3237e+00_r8,1.1620e+00_r8,2.5199e-06_r8/)
      kao(:, 2,10,16) = (/ &
     &9.1327e+00_r8,7.9905e+00_r8,6.8491e+00_r8,5.7077e+00_r8,4.5656e+00_r8,3.4245e+00_r8, &
     &2.2832e+00_r8,1.1416e+00_r8,6.1820e-06_r8/)
      kao(:, 3,10,16) = (/ &
     &9.0419e+00_r8,7.9114e+00_r8,6.7812e+00_r8,5.6501e+00_r8,4.5208e+00_r8,3.3897e+00_r8, &
     &2.2603e+00_r8,1.1303e+00_r8,1.2253e-05_r8/)
      kao(:, 4,10,16) = (/ &
     &8.9128e+00_r8,7.7986e+00_r8,6.6845e+00_r8,5.5708e+00_r8,4.4561e+00_r8,3.3428e+00_r8, &
     &2.2285e+00_r8,1.1142e+00_r8,1.7974e-05_r8/)
      kao(:, 5,10,16) = (/ &
     &8.7796e+00_r8,7.6831e+00_r8,6.5851e+00_r8,5.4876e+00_r8,4.3892e+00_r8,3.2921e+00_r8, &
     &2.1948e+00_r8,1.0975e+00_r8,2.4232e-05_r8/)
      kao(:, 1,11,16) = (/ &
     &2.7588e+01_r8,2.4141e+01_r8,2.0693e+01_r8,1.7244e+01_r8,1.3795e+01_r8,1.0345e+01_r8, &
     &6.8978e+00_r8,3.4484e+00_r8,2.0595e-06_r8/)
      kao(:, 2,11,16) = (/ &
     &2.6657e+01_r8,2.3323e+01_r8,1.9991e+01_r8,1.6660e+01_r8,1.3327e+01_r8,9.9952e+00_r8, &
     &6.6638e+00_r8,3.3322e+00_r8,4.7312e-06_r8/)
      kao(:, 3,11,16) = (/ &
     &2.5989e+01_r8,2.2740e+01_r8,1.9493e+01_r8,1.6242e+01_r8,1.2994e+01_r8,9.7462e+00_r8, &
     &6.4977e+00_r8,3.2488e+00_r8,8.7718e-06_r8/)
      kao(:, 4,11,16) = (/ &
     &2.5704e+01_r8,2.2492e+01_r8,1.9279e+01_r8,1.6066e+01_r8,1.2854e+01_r8,9.6403e+00_r8, &
     &6.4266e+00_r8,3.2130e+00_r8,1.4050e-05_r8/)
      kao(:, 5,11,16) = (/ &
     &2.5636e+01_r8,2.2431e+01_r8,1.9229e+01_r8,1.6023e+01_r8,1.2819e+01_r8,9.6138e+00_r8, &
     &6.4100e+00_r8,3.2046e+00_r8,1.9441e-05_r8/)
      kao(:, 1,12,16) = (/ &
     &5.2064e+01_r8,4.5551e+01_r8,3.9046e+01_r8,3.2542e+01_r8,2.6032e+01_r8,1.9524e+01_r8, &
     &1.3016e+01_r8,6.5078e+00_r8,1.7091e-06_r8/)
      kao(:, 2,12,16) = (/ &
     &5.0183e+01_r8,4.3912e+01_r8,3.7638e+01_r8,3.1363e+01_r8,2.5091e+01_r8,1.8819e+01_r8, &
     &1.2545e+01_r8,6.2729e+00_r8,3.7298e-06_r8/)
      kao(:, 3,12,16) = (/ &
     &4.8961e+01_r8,4.2840e+01_r8,3.6719e+01_r8,3.0598e+01_r8,2.4478e+01_r8,1.8358e+01_r8, &
     &1.2239e+01_r8,6.1197e+00_r8,6.4267e-06_r8/)
      kao(:, 4,12,16) = (/ &
     &4.8192e+01_r8,4.2165e+01_r8,3.6143e+01_r8,3.0118e+01_r8,2.4096e+01_r8,1.8071e+01_r8, &
     &1.2047e+01_r8,6.0236e+00_r8,1.0438e-05_r8/)
      kao(:, 5,12,16) = (/ &
     &4.7950e+01_r8,4.1951e+01_r8,3.5955e+01_r8,2.9964e+01_r8,2.3968e+01_r8,1.7977e+01_r8, &
     &1.1985e+01_r8,5.9924e+00_r8,1.5532e-05_r8/)
      kao(:, 1,13,16) = (/ &
     &7.9237e+01_r8,6.9320e+01_r8,5.9418e+01_r8,4.9515e+01_r8,3.9615e+01_r8,2.9712e+01_r8, &
     &1.9806e+01_r8,9.9046e+00_r8,1.3997e-06_r8/)
      kao(:, 2,13,16) = (/ &
     &7.6481e+01_r8,6.6913e+01_r8,5.7358e+01_r8,4.7795e+01_r8,3.8238e+01_r8,2.8679e+01_r8, &
     &1.9119e+01_r8,9.5593e+00_r8,2.8864e-06_r8/)
      kao(:, 3,13,16) = (/ &
     &7.4663e+01_r8,6.5336e+01_r8,5.5998e+01_r8,4.6664e+01_r8,3.7331e+01_r8,2.7999e+01_r8, &
     &1.8666e+01_r8,9.3324e+00_r8,4.8512e-06_r8/)
      kao(:, 4,13,16) = (/ &
     &7.3334e+01_r8,6.4170e+01_r8,5.5002e+01_r8,4.5830e+01_r8,3.6668e+01_r8,2.7499e+01_r8, &
     &1.8332e+01_r8,9.1667e+00_r8,7.8505e-06_r8/)
      kao(:, 5,13,16) = (/ &
     &7.2543e+01_r8,6.3471e+01_r8,5.4398e+01_r8,4.5335e+01_r8,3.6267e+01_r8,2.7201e+01_r8, &
     &1.8133e+01_r8,9.0671e+00_r8,1.1235e-05_r8/)

!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

      kbo(:,13, 1) = (/ &
     &6.2747e-02_r8,8.6102e-02_r8,1.1568e-01_r8,1.5208e-01_r8,1.9535e-01_r8/)
      kbo(:,14, 1) = (/ &
     &5.7861e-02_r8,7.9151e-02_r8,1.0594e-01_r8,1.3846e-01_r8,1.7643e-01_r8/)
      kbo(:,15, 1) = (/ &
     &5.3092e-02_r8,7.2482e-02_r8,9.6781e-02_r8,1.2588e-01_r8,1.5918e-01_r8/)
      kbo(:,16, 1) = (/ &
     &4.8457e-02_r8,6.6047e-02_r8,8.7760e-02_r8,1.1351e-01_r8,1.4288e-01_r8/)
      kbo(:,17, 1) = (/ &
     &4.3912e-02_r8,5.9676e-02_r8,7.8923e-02_r8,1.0151e-01_r8,1.2709e-01_r8/)
      kbo(:,18, 1) = (/ &
     &3.9426e-02_r8,5.3365e-02_r8,7.0341e-02_r8,8.9953e-02_r8,1.1230e-01_r8/)
      kbo(:,19, 1) = (/ &
     &3.5046e-02_r8,4.7312e-02_r8,6.2046e-02_r8,7.9063e-02_r8,9.8334e-02_r8/)
      kbo(:,20, 1) = (/ &
     &3.1115e-02_r8,4.1839e-02_r8,5.4636e-02_r8,6.9407e-02_r8,8.5975e-02_r8/)
      kbo(:,21, 1) = (/ &
     &2.7465e-02_r8,3.6785e-02_r8,4.7830e-02_r8,6.0600e-02_r8,7.4770e-02_r8/)
      kbo(:,22, 1) = (/ &
     &2.4593e-02_r8,3.2747e-02_r8,4.2384e-02_r8,5.3412e-02_r8,6.5545e-02_r8/)
      kbo(:,23, 1) = (/ &
     &2.1937e-02_r8,2.9046e-02_r8,3.7411e-02_r8,4.6873e-02_r8,5.7167e-02_r8/)
      kbo(:,24, 1) = (/ &
     &1.9516e-02_r8,2.5711e-02_r8,3.2910e-02_r8,4.0910e-02_r8,4.9576e-02_r8/)
      kbo(:,25, 1) = (/ &
     &1.7347e-02_r8,2.2706e-02_r8,2.8823e-02_r8,3.5568e-02_r8,4.2803e-02_r8/)
      kbo(:,26, 1) = (/ &
     &1.5431e-02_r8,2.0022e-02_r8,2.5209e-02_r8,3.0861e-02_r8,3.6863e-02_r8/)
      kbo(:,27, 1) = (/ &
     &1.3676e-02_r8,1.7588e-02_r8,2.1954e-02_r8,2.6656e-02_r8,3.1628e-02_r8/)
      kbo(:,28, 1) = (/ &
     &1.2072e-02_r8,1.5389e-02_r8,1.9040e-02_r8,2.2944e-02_r8,2.7092e-02_r8/)
      kbo(:,29, 1) = (/ &
     &1.0638e-02_r8,1.3440e-02_r8,1.6483e-02_r8,1.9764e-02_r8,2.3215e-02_r8/)
      kbo(:,30, 1) = (/ &
     &9.3452e-03_r8,1.1695e-02_r8,1.4256e-02_r8,1.7011e-02_r8,1.9889e-02_r8/)
      kbo(:,31, 1) = (/ &
     &8.1958e-03_r8,1.0179e-02_r8,1.2343e-02_r8,1.4653e-02_r8,1.7063e-02_r8/)
      kbo(:,32, 1) = (/ &
     &7.1787e-03_r8,8.8627e-03_r8,1.0685e-02_r8,1.2626e-02_r8,1.4630e-02_r8/)
      kbo(:,33, 1) = (/ &
     &6.2851e-03_r8,7.7078e-03_r8,9.2476e-03_r8,1.0876e-02_r8,1.2551e-02_r8/)
      kbo(:,34, 1) = (/ &
     &5.4503e-03_r8,6.6513e-03_r8,7.9437e-03_r8,9.3044e-03_r8,1.0718e-02_r8/)
      kbo(:,35, 1) = (/ &
     &4.6286e-03_r8,5.6362e-03_r8,6.7164e-03_r8,7.8605e-03_r8,9.0307e-03_r8/)
      kbo(:,36, 1) = (/ &
     &3.8439e-03_r8,4.6777e-03_r8,5.5784e-03_r8,6.5325e-03_r8,7.4907e-03_r8/)
      kbo(:,37, 1) = (/ &
     &3.0907e-03_r8,3.7733e-03_r8,4.5151e-03_r8,5.2952e-03_r8,6.0875e-03_r8/)
      kbo(:,38, 1) = (/ &
     &2.4803e-03_r8,3.0385e-03_r8,3.6485e-03_r8,4.2895e-03_r8,4.9493e-03_r8/)
      kbo(:,39, 1) = (/ &
     &1.9914e-03_r8,2.4489e-03_r8,2.9506e-03_r8,3.4809e-03_r8,4.0250e-03_r8/)
      kbo(:,40, 1) = (/ &
     &1.5591e-03_r8,1.9289e-03_r8,2.3368e-03_r8,2.7699e-03_r8,3.2181e-03_r8/)
      kbo(:,41, 1) = (/ &
     &1.2156e-03_r8,1.5132e-03_r8,1.8431e-03_r8,2.1975e-03_r8,2.5662e-03_r8/)
      kbo(:,42, 1) = (/ &
     &9.4642e-04_r8,1.1860e-03_r8,1.4531e-03_r8,1.7422e-03_r8,2.0436e-03_r8/)
      kbo(:,43, 1) = (/ &
     &7.2576e-04_r8,9.1670e-04_r8,1.1319e-03_r8,1.3659e-03_r8,1.6136e-03_r8/)
      kbo(:,44, 1) = (/ &
     &5.5191e-04_r8,7.0339e-04_r8,8.7651e-04_r8,1.0654e-03_r8,1.2677e-03_r8/)
      kbo(:,45, 1) = (/ &
     &4.1864e-04_r8,5.3928e-04_r8,6.7793e-04_r8,8.3043e-04_r8,9.9568e-04_r8/)
      kbo(:,46, 1) = (/ &
     &3.1490e-04_r8,4.0992e-04_r8,5.2032e-04_r8,6.4322e-04_r8,7.7812e-04_r8/)
      kbo(:,47, 1) = (/ &
     &2.3273e-04_r8,3.0659e-04_r8,3.9375e-04_r8,4.9208e-04_r8,6.0088e-04_r8/)
      kbo(:,48, 1) = (/ &
     &1.7128e-04_r8,2.2854e-04_r8,2.9725e-04_r8,3.7557e-04_r8,4.6327e-04_r8/)
      kbo(:,49, 1) = (/ &
     &1.2553e-04_r8,1.6987e-04_r8,2.2375e-04_r8,2.8623e-04_r8,3.5677e-04_r8/)
      kbo(:,50, 1) = (/ &
     &9.2117e-05_r8,1.2634e-04_r8,1.6842e-04_r8,2.1802e-04_r8,2.7404e-04_r8/)
      kbo(:,51, 1) = (/ &
     &6.7482e-05_r8,9.3783e-05_r8,1.2646e-04_r8,1.6541e-04_r8,2.1004e-04_r8/)
      kbo(:,52, 1) = (/ &
     &4.9294e-05_r8,6.9377e-05_r8,9.4622e-05_r8,1.2516e-04_r8,1.6083e-04_r8/)
      kbo(:,53, 1) = (/ &
     &3.5898e-05_r8,5.1131e-05_r8,7.0555e-05_r8,9.4518e-05_r8,1.2315e-04_r8/)
      kbo(:,54, 1) = (/ &
     &2.6237e-05_r8,3.7710e-05_r8,5.2593e-05_r8,7.1209e-05_r8,9.3663e-05_r8/)
      kbo(:,55, 1) = (/ &
     &1.9162e-05_r8,2.7753e-05_r8,3.9112e-05_r8,5.3467e-05_r8,7.0840e-05_r8/)
      kbo(:,56, 1) = (/ &
     &1.3954e-05_r8,2.0386e-05_r8,2.8986e-05_r8,3.9982e-05_r8,5.3468e-05_r8/)
      kbo(:,57, 1) = (/ &
     &1.0137e-05_r8,1.4950e-05_r8,2.1433e-05_r8,2.9844e-05_r8,4.0285e-05_r8/)
      kbo(:,58, 1) = (/ &
     &7.3955e-06_r8,1.0988e-05_r8,1.5849e-05_r8,2.2304e-05_r8,3.0355e-05_r8/)
      kbo(:,59, 1) = (/ &
     &5.7756e-06_r8,8.5841e-06_r8,1.2417e-05_r8,1.7454e-05_r8,2.3825e-05_r8/)
      kbo(:,13, 2) = (/ &
     &2.8941e-01_r8,3.7928e-01_r8,4.8728e-01_r8,6.1356e-01_r8,7.5720e-01_r8/)
      kbo(:,14, 2) = (/ &
     &2.7482e-01_r8,3.5907e-01_r8,4.5923e-01_r8,5.7444e-01_r8,7.0479e-01_r8/)
      kbo(:,15, 2) = (/ &
     &2.6012e-01_r8,3.3844e-01_r8,4.3050e-01_r8,5.3565e-01_r8,6.5360e-01_r8/)
      kbo(:,16, 2) = (/ &
     &2.4469e-01_r8,3.1749e-01_r8,4.0174e-01_r8,4.9749e-01_r8,6.0352e-01_r8/)
      kbo(:,17, 2) = (/ &
     &2.2805e-01_r8,2.9482e-01_r8,3.7163e-01_r8,4.5800e-01_r8,5.5300e-01_r8/)
      kbo(:,18, 2) = (/ &
     &2.1066e-01_r8,2.7121e-01_r8,3.4050e-01_r8,4.1816e-01_r8,5.0173e-01_r8/)
      kbo(:,19, 2) = (/ &
     &1.9258e-01_r8,2.4696e-01_r8,3.0899e-01_r8,3.7763e-01_r8,4.5019e-01_r8/)
      kbo(:,20, 2) = (/ &
     &1.7535e-01_r8,2.2386e-01_r8,2.7870e-01_r8,3.3833e-01_r8,4.0121e-01_r8/)
      kbo(:,21, 2) = (/ &
     &1.5823e-01_r8,2.0117e-01_r8,2.4903e-01_r8,3.0059e-01_r8,3.5459e-01_r8/)
      kbo(:,22, 2) = (/ &
     &1.4393e-01_r8,1.8176e-01_r8,2.2349e-01_r8,2.6801e-01_r8,3.1434e-01_r8/)
      kbo(:,23, 2) = (/ &
     &1.2993e-01_r8,1.6307e-01_r8,1.9923e-01_r8,2.3752e-01_r8,2.7733e-01_r8/)
      kbo(:,24, 2) = (/ &
     &1.1668e-01_r8,1.4559e-01_r8,1.7680e-01_r8,2.0966e-01_r8,2.4384e-01_r8/)
      kbo(:,25, 2) = (/ &
     &1.0441e-01_r8,1.2946e-01_r8,1.5637e-01_r8,1.8462e-01_r8,2.1368e-01_r8/)
      kbo(:,26, 2) = (/ &
     &9.3354e-02_r8,1.1505e-01_r8,1.3816e-01_r8,1.6244e-01_r8,1.8706e-01_r8/)
      kbo(:,27, 2) = (/ &
     &8.3171e-02_r8,1.0190e-01_r8,1.2182e-01_r8,1.4246e-01_r8,1.6301e-01_r8/)
      kbo(:,28, 2) = (/ &
     &7.3897e-02_r8,9.0049e-02_r8,1.0712e-01_r8,1.2442e-01_r8,1.4130e-01_r8/)
      kbo(:,29, 2) = (/ &
     &6.5628e-02_r8,7.9501e-02_r8,9.3908e-02_r8,1.0826e-01_r8,1.2190e-01_r8/)
      kbo(:,30, 2) = (/ &
     &5.8144e-02_r8,6.9960e-02_r8,8.1950e-02_r8,9.3660e-02_r8,1.0454e-01_r8/)
      kbo(:,31, 2) = (/ &
     &5.1413e-02_r8,6.1336e-02_r8,7.1221e-02_r8,8.0615e-02_r8,8.9347e-02_r8/)
      kbo(:,32, 2) = (/ &
     &4.5308e-02_r8,5.3538e-02_r8,6.1586e-02_r8,6.9140e-02_r8,7.6180e-02_r8/)
      kbo(:,33, 2) = (/ &
     &3.9776e-02_r8,4.6552e-02_r8,5.3085e-02_r8,5.9155e-02_r8,6.4885e-02_r8/)
      kbo(:,34, 2) = (/ &
     &3.4566e-02_r8,4.0142e-02_r8,4.5387e-02_r8,5.0362e-02_r8,5.5085e-02_r8/)
      kbo(:,35, 2) = (/ &
     &2.9501e-02_r8,3.4063e-02_r8,3.8371e-02_r8,4.2482e-02_r8,4.6355e-02_r8/)
      kbo(:,36, 2) = (/ &
     &2.4731e-02_r8,2.8480e-02_r8,3.2042e-02_r8,3.5445e-02_r8,3.8685e-02_r8/)
      kbo(:,37, 2) = (/ &
     &2.0227e-02_r8,2.3337e-02_r8,2.6311e-02_r8,2.9150e-02_r8,3.1875e-02_r8/)
      kbo(:,38, 2) = (/ &
     &1.6522e-02_r8,1.9118e-02_r8,2.1594e-02_r8,2.3970e-02_r8,2.6280e-02_r8/)
      kbo(:,39, 2) = (/ &
     &1.3506e-02_r8,1.5663e-02_r8,1.7734e-02_r8,1.9723e-02_r8,2.1666e-02_r8/)
      kbo(:,40, 2) = (/ &
     &1.0839e-02_r8,1.2642e-02_r8,1.4374e-02_r8,1.6039e-02_r8,1.7665e-02_r8/)
      kbo(:,41, 2) = (/ &
     &8.6687e-03_r8,1.0169e-02_r8,1.1614e-02_r8,1.3014e-02_r8,1.4376e-02_r8/)
      kbo(:,42, 2) = (/ &
     &6.9249e-03_r8,8.1709e-03_r8,9.3824e-03_r8,1.0556e-02_r8,1.1694e-02_r8/)
      kbo(:,43, 2) = (/ &
     &5.4677e-03_r8,6.5006e-03_r8,7.5154e-03_r8,8.4985e-03_r8,9.4530e-03_r8/)
      kbo(:,44, 2) = (/ &
     &4.2855e-03_r8,5.1437e-03_r8,5.9926e-03_r8,6.8145e-03_r8,7.6201e-03_r8/)
      kbo(:,45, 2) = (/ &
     &3.3515e-03_r8,4.0607e-03_r8,4.7699e-03_r8,5.4599e-03_r8,6.1332e-03_r8/)
      kbo(:,46, 2) = (/ &
     &2.6019e-03_r8,3.1870e-03_r8,3.7777e-03_r8,4.3556e-03_r8,4.9205e-03_r8/)
      kbo(:,47, 2) = (/ &
     &1.9902e-03_r8,2.4722e-03_r8,2.9627e-03_r8,3.4486e-03_r8,3.9210e-03_r8/)
      kbo(:,48, 2) = (/ &
     &1.5153e-03_r8,1.9102e-03_r8,2.3171e-03_r8,2.7244e-03_r8,3.1206e-03_r8/)
      kbo(:,49, 2) = (/ &
     &1.1469e-03_r8,1.4720e-03_r8,1.8085e-03_r8,2.1494e-03_r8,2.4830e-03_r8/)
      kbo(:,50, 2) = (/ &
     &8.6648e-04_r8,1.1333e-03_r8,1.4108e-03_r8,1.6953e-03_r8,1.9769e-03_r8/)
      kbo(:,51, 2) = (/ &
     &6.5125e-04_r8,8.6980e-04_r8,1.0984e-03_r8,1.3342e-03_r8,1.5715e-03_r8/)
      kbo(:,52, 2) = (/ &
     &4.8660e-04_r8,6.6498e-04_r8,8.5250e-04_r8,1.0475e-03_r8,1.2461e-03_r8/)
      kbo(:,53, 2) = (/ &
     &3.6091e-04_r8,5.0560e-04_r8,6.5947e-04_r8,8.2040e-04_r8,9.8603e-04_r8/)
      kbo(:,54, 2) = (/ &
     &2.6798e-04_r8,3.8317e-04_r8,5.0899e-04_r8,6.4130e-04_r8,7.7856e-04_r8/)
      kbo(:,55, 2) = (/ &
     &1.9837e-04_r8,2.8906e-04_r8,3.9148e-04_r8,4.9955e-04_r8,6.1247e-04_r8/)
      kbo(:,56, 2) = (/ &
     &1.4613e-04_r8,2.1685e-04_r8,3.0004e-04_r8,3.8773e-04_r8,4.8096e-04_r8/)
      kbo(:,57, 2) = (/ &
     &1.0691e-04_r8,1.6173e-04_r8,2.2873e-04_r8,3.0001e-04_r8,3.7637e-04_r8/)
      kbo(:,58, 2) = (/ &
     &7.8236e-05_r8,1.2069e-04_r8,1.7421e-04_r8,2.3200e-04_r8,2.9412e-04_r8/)
      kbo(:,59, 2) = (/ &
     &6.1826e-05_r8,9.5990e-05_r8,1.3927e-04_r8,1.8625e-04_r8,2.3654e-04_r8/)
      kbo(:,13, 3) = (/ &
     &1.1135e+00_r8,1.3641e+00_r8,1.6160e+00_r8,1.8652e+00_r8,2.1134e+00_r8/)
      kbo(:,14, 3) = (/ &
     &1.0304e+00_r8,1.2521e+00_r8,1.4746e+00_r8,1.6946e+00_r8,1.9141e+00_r8/)
      kbo(:,15, 3) = (/ &
     &9.5384e-01_r8,1.1492e+00_r8,1.3443e+00_r8,1.5379e+00_r8,1.7345e+00_r8/)
      kbo(:,16, 3) = (/ &
     &8.8007e-01_r8,1.0512e+00_r8,1.2220e+00_r8,1.3952e+00_r8,1.5691e+00_r8/)
      kbo(:,17, 3) = (/ &
     &8.0715e-01_r8,9.5537e-01_r8,1.1063e+00_r8,1.2596e+00_r8,1.4122e+00_r8/)
      kbo(:,18, 3) = (/ &
     &7.3500e-01_r8,8.6436e-01_r8,9.9708e-01_r8,1.1308e+00_r8,1.2638e+00_r8/)
      kbo(:,19, 3) = (/ &
     &6.6442e-01_r8,7.7800e-01_r8,8.9341e-01_r8,1.0094e+00_r8,1.1240e+00_r8/)
      kbo(:,20, 3) = (/ &
     &5.9870e-01_r8,6.9782e-01_r8,7.9815e-01_r8,8.9858e-01_r8,9.9720e-01_r8/)
      kbo(:,21, 3) = (/ &
     &5.3577e-01_r8,6.2165e-01_r8,7.0893e-01_r8,7.9562e-01_r8,8.8013e-01_r8/)
      kbo(:,22, 3) = (/ &
     &4.8056e-01_r8,5.5531e-01_r8,6.3060e-01_r8,7.0436e-01_r8,7.7687e-01_r8/)
      kbo(:,23, 3) = (/ &
     &4.2855e-01_r8,4.9296e-01_r8,5.5690e-01_r8,6.1984e-01_r8,6.8212e-01_r8/)
      kbo(:,24, 3) = (/ &
     &3.8024e-01_r8,4.3497e-01_r8,4.8911e-01_r8,5.4325e-01_r8,5.9676e-01_r8/)
      kbo(:,25, 3) = (/ &
     &3.3570e-01_r8,3.8197e-01_r8,4.2813e-01_r8,4.7450e-01_r8,5.2085e-01_r8/)
      kbo(:,26, 3) = (/ &
     &2.9535e-01_r8,3.3462e-01_r8,3.7428e-01_r8,4.1425e-01_r8,4.5431e-01_r8/)
      kbo(:,27, 3) = (/ &
     &2.5873e-01_r8,2.9239e-01_r8,3.2655e-01_r8,3.6110e-01_r8,3.9601e-01_r8/)
      kbo(:,28, 3) = (/ &
     &2.2605e-01_r8,2.5498e-01_r8,2.8445e-01_r8,3.1460e-01_r8,3.4506e-01_r8/)
      kbo(:,29, 3) = (/ &
     &1.9728e-01_r8,2.2221e-01_r8,2.4794e-01_r8,2.7429e-01_r8,3.0081e-01_r8/)
      kbo(:,30, 3) = (/ &
     &1.7195e-01_r8,1.9369e-01_r8,2.1631e-01_r8,2.3929e-01_r8,2.6198e-01_r8/)
      kbo(:,31, 3) = (/ &
     &1.5004e-01_r8,1.6915e-01_r8,1.8896e-01_r8,2.0886e-01_r8,2.2799e-01_r8/)
      kbo(:,32, 3) = (/ &
     &1.3116e-01_r8,1.4802e-01_r8,1.6521e-01_r8,1.8200e-01_r8,1.9806e-01_r8/)
      kbo(:,33, 3) = (/ &
     &1.1493e-01_r8,1.2958e-01_r8,1.4418e-01_r8,1.5826e-01_r8,1.7170e-01_r8/)
      kbo(:,34, 3) = (/ &
     &1.0026e-01_r8,1.1281e-01_r8,1.2510e-01_r8,1.3692e-01_r8,1.4804e-01_r8/)
      kbo(:,35, 3) = (/ &
     &8.6407e-02_r8,9.7015e-02_r8,1.0743e-01_r8,1.1729e-01_r8,1.2663e-01_r8/)
      kbo(:,36, 3) = (/ &
     &7.3396e-02_r8,8.2443e-02_r8,9.1165e-02_r8,9.9519e-02_r8,1.0753e-01_r8/)
      kbo(:,37, 3) = (/ &
     &6.1173e-02_r8,6.8860e-02_r8,7.6255e-02_r8,8.3361e-02_r8,9.0284e-02_r8/)
      kbo(:,38, 3) = (/ &
     &5.0910e-02_r8,5.7435e-02_r8,6.3715e-02_r8,6.9817e-02_r8,7.5733e-02_r8/)
      kbo(:,39, 3) = (/ &
     &4.2376e-02_r8,4.7913e-02_r8,5.3247e-02_r8,5.8502e-02_r8,6.3619e-02_r8/)
      kbo(:,40, 3) = (/ &
     &3.4748e-02_r8,3.9459e-02_r8,4.3993e-02_r8,4.8510e-02_r8,5.2956e-02_r8/)
      kbo(:,41, 3) = (/ &
     &2.8418e-02_r8,3.2417e-02_r8,3.6282e-02_r8,4.0161e-02_r8,4.3993e-02_r8/)
      kbo(:,42, 3) = (/ &
     &2.3210e-02_r8,2.6614e-02_r8,2.9916e-02_r8,3.3242e-02_r8,3.6540e-02_r8/)
      kbo(:,43, 3) = (/ &
     &1.8779e-02_r8,2.1673e-02_r8,2.4493e-02_r8,2.7336e-02_r8,3.0182e-02_r8/)
      kbo(:,44, 3) = (/ &
     &1.5102e-02_r8,1.7567e-02_r8,1.9972e-02_r8,2.2410e-02_r8,2.4858e-02_r8/)
      kbo(:,45, 3) = (/ &
     &1.2119e-02_r8,1.4212e-02_r8,1.6271e-02_r8,1.8344e-02_r8,2.0451e-02_r8/)
      kbo(:,46, 3) = (/ &
     &9.6639e-03_r8,1.1430e-02_r8,1.3190e-02_r8,1.4958e-02_r8,1.6759e-02_r8/)
      kbo(:,47, 3) = (/ &
     &7.6185e-03_r8,9.1001e-03_r8,1.0599e-02_r8,1.2098e-02_r8,1.3639e-02_r8/)
      kbo(:,48, 3) = (/ &
     &5.9842e-03_r8,7.2206e-03_r8,8.5005e-03_r8,9.7716e-03_r8,1.1086e-02_r8/)
      kbo(:,49, 3) = (/ &
     &4.6860e-03_r8,5.7121e-03_r8,6.7999e-03_r8,7.8773e-03_r8,8.9943e-03_r8/)
      kbo(:,50, 3) = (/ &
     &3.6738e-03_r8,4.5201e-03_r8,5.4386e-03_r8,6.3525e-03_r8,7.2951e-03_r8/)
      kbo(:,51, 3) = (/ &
     &2.8749e-03_r8,3.5695e-03_r8,4.3389e-03_r8,5.1158e-03_r8,5.9116e-03_r8/)
      kbo(:,52, 3) = (/ &
     &2.2412e-03_r8,2.8111e-03_r8,3.4548e-03_r8,4.1149e-03_r8,4.7853e-03_r8/)
      kbo(:,53, 3) = (/ &
     &1.7396e-03_r8,2.2062e-03_r8,2.7406e-03_r8,3.3024e-03_r8,3.8694e-03_r8/)
      kbo(:,54, 3) = (/ &
     &1.3505e-03_r8,1.7325e-03_r8,2.1715e-03_r8,2.6457e-03_r8,3.1233e-03_r8/)
      kbo(:,55, 3) = (/ &
     &1.0458e-03_r8,1.3574e-03_r8,1.7165e-03_r8,2.1138e-03_r8,2.5149e-03_r8/)
      kbo(:,56, 3) = (/ &
     &8.0583e-04_r8,1.0599e-03_r8,1.3530e-03_r8,1.6840e-03_r8,2.0192e-03_r8/)
      kbo(:,57, 3) = (/ &
     &6.1766e-04_r8,8.2479e-04_r8,1.0628e-03_r8,1.3371e-03_r8,1.6185e-03_r8/)
      kbo(:,58, 3) = (/ &
     &4.7327e-04_r8,6.4160e-04_r8,8.3562e-04_r8,1.0608e-03_r8,1.2972e-03_r8/)
      kbo(:,59, 3) = (/ &
     &3.8292e-04_r8,5.2222e-04_r8,6.8284e-04_r8,8.6897e-04_r8,1.0664e-03_r8/)
      kbo(:,13, 4) = (/ &
     &3.3749e+00_r8,3.6005e+00_r8,3.8557e+00_r8,4.1032e+00_r8,4.3385e+00_r8/)
      kbo(:,14, 4) = (/ &
     &2.9858e+00_r8,3.1916e+00_r8,3.4148e+00_r8,3.6458e+00_r8,3.8704e+00_r8/)
      kbo(:,15, 4) = (/ &
     &2.6360e+00_r8,2.8231e+00_r8,3.0273e+00_r8,3.2443e+00_r8,3.4520e+00_r8/)
      kbo(:,16, 4) = (/ &
     &2.3243e+00_r8,2.4974e+00_r8,2.6921e+00_r8,2.8866e+00_r8,3.0804e+00_r8/)
      kbo(:,17, 4) = (/ &
     &2.0501e+00_r8,2.2124e+00_r8,2.3895e+00_r8,2.5647e+00_r8,2.7458e+00_r8/)
      kbo(:,18, 4) = (/ &
     &1.8079e+00_r8,1.9578e+00_r8,2.1149e+00_r8,2.2757e+00_r8,2.4444e+00_r8/)
      kbo(:,19, 4) = (/ &
     &1.5916e+00_r8,1.7262e+00_r8,1.8683e+00_r8,2.0160e+00_r8,2.1705e+00_r8/)
      kbo(:,20, 4) = (/ &
     &1.3988e+00_r8,1.5220e+00_r8,1.6508e+00_r8,1.7854e+00_r8,1.9234e+00_r8/)
      kbo(:,21, 4) = (/ &
     &1.2283e+00_r8,1.3399e+00_r8,1.4559e+00_r8,1.5766e+00_r8,1.6985e+00_r8/)
      kbo(:,22, 4) = (/ &
     &1.0842e+00_r8,1.1844e+00_r8,1.2884e+00_r8,1.3958e+00_r8,1.5035e+00_r8/)
      kbo(:,23, 4) = (/ &
     &9.5535e-01_r8,1.0448e+00_r8,1.1388e+00_r8,1.2338e+00_r8,1.3273e+00_r8/)
      kbo(:,24, 4) = (/ &
     &8.3937e-01_r8,9.2038e-01_r8,1.0041e+00_r8,1.0871e+00_r8,1.1675e+00_r8/)
      kbo(:,25, 4) = (/ &
     &7.3697e-01_r8,8.0962e-01_r8,8.8296e-01_r8,9.5450e-01_r8,1.0251e+00_r8/)
      kbo(:,26, 4) = (/ &
     &6.4730e-01_r8,7.1109e-01_r8,7.7450e-01_r8,8.3674e-01_r8,9.0032e-01_r8/)
      kbo(:,27, 4) = (/ &
     &5.6756e-01_r8,6.2293e-01_r8,6.7780e-01_r8,7.3355e-01_r8,7.9083e-01_r8/)
      kbo(:,28, 4) = (/ &
     &4.9666e-01_r8,5.4463e-01_r8,5.9308e-01_r8,6.4333e-01_r8,6.9525e-01_r8/)
      kbo(:,29, 4) = (/ &
     &4.3427e-01_r8,4.7629e-01_r8,5.1987e-01_r8,5.6530e-01_r8,6.1288e-01_r8/)
      kbo(:,30, 4) = (/ &
     &3.7957e-01_r8,4.1709e-01_r8,4.5651e-01_r8,4.9797e-01_r8,5.4181e-01_r8/)
      kbo(:,31, 4) = (/ &
     &3.3226e-01_r8,3.6617e-01_r8,4.0201e-01_r8,4.4025e-01_r8,4.8083e-01_r8/)
      kbo(:,32, 4) = (/ &
     &2.9152e-01_r8,3.2232e-01_r8,3.5534e-01_r8,3.9102e-01_r8,4.2785e-01_r8/)
      kbo(:,33, 4) = (/ &
     &2.5658e-01_r8,2.8478e-01_r8,3.1566e-01_r8,3.4846e-01_r8,3.8205e-01_r8/)
      kbo(:,34, 4) = (/ &
     &2.2568e-01_r8,2.5200e-01_r8,2.8059e-01_r8,3.1045e-01_r8,3.4133e-01_r8/)
      kbo(:,35, 4) = (/ &
     &1.9721e-01_r8,2.2158e-01_r8,2.4755e-01_r8,2.7492e-01_r8,3.0313e-01_r8/)
      kbo(:,36, 4) = (/ &
     &1.7069e-01_r8,1.9278e-01_r8,2.1640e-01_r8,2.4134e-01_r8,2.6698e-01_r8/)
      kbo(:,37, 4) = (/ &
     &1.4514e-01_r8,1.6486e-01_r8,1.8617e-01_r8,2.0876e-01_r8,2.3216e-01_r8/)
      kbo(:,38, 4) = (/ &
     &1.2328e-01_r8,1.4085e-01_r8,1.6011e-01_r8,1.8057e-01_r8,2.0182e-01_r8/)
      kbo(:,39, 4) = (/ &
     &1.0472e-01_r8,1.2042e-01_r8,1.3775e-01_r8,1.5631e-01_r8,1.7570e-01_r8/)
      kbo(:,40, 4) = (/ &
     &8.7593e-02_r8,1.0140e-01_r8,1.1682e-01_r8,1.3356e-01_r8,1.5106e-01_r8/)
      kbo(:,41, 4) = (/ &
     &7.2991e-02_r8,8.5111e-02_r8,9.8743e-02_r8,1.1375e-01_r8,1.2963e-01_r8/)
      kbo(:,42, 4) = (/ &
     &6.0719e-02_r8,7.1311e-02_r8,8.3382e-02_r8,9.6810e-02_r8,1.1115e-01_r8/)
      kbo(:,43, 4) = (/ &
     &4.9944e-02_r8,5.9103e-02_r8,6.9670e-02_r8,8.1603e-02_r8,9.4469e-02_r8/)
      kbo(:,44, 4) = (/ &
     &4.0785e-02_r8,4.8637e-02_r8,5.7853e-02_r8,6.8379e-02_r8,7.9912e-02_r8/)
      kbo(:,45, 4) = (/ &
     &3.3215e-02_r8,3.9939e-02_r8,4.7926e-02_r8,5.7208e-02_r8,6.7537e-02_r8/)
      kbo(:,46, 4) = (/ &
     &2.6843e-02_r8,3.2560e-02_r8,3.9436e-02_r8,4.7558e-02_r8,5.6745e-02_r8/)
      kbo(:,47, 4) = (/ &
     &2.1428e-02_r8,2.6226e-02_r8,3.2052e-02_r8,3.9057e-02_r8,4.7184e-02_r8/)
      kbo(:,48, 4) = (/ &
     &1.7029e-02_r8,2.1031e-02_r8,2.5943e-02_r8,3.1986e-02_r8,3.9099e-02_r8/)
      kbo(:,49, 4) = (/ &
     &1.3477e-02_r8,1.6802e-02_r8,2.0926e-02_r8,2.6109e-02_r8,3.2294e-02_r8/)
      kbo(:,50, 4) = (/ &
     &1.0673e-02_r8,1.3423e-02_r8,1.6872e-02_r8,2.1279e-02_r8,2.6629e-02_r8/)
      kbo(:,51, 4) = (/ &
     &8.4370e-03_r8,1.0700e-02_r8,1.3568e-02_r8,1.7289e-02_r8,2.1889e-02_r8/)
      kbo(:,52, 4) = (/ &
     &6.6453e-03_r8,8.4949e-03_r8,1.0870e-02_r8,1.3987e-02_r8,1.7931e-02_r8/)
      kbo(:,53, 4) = (/ &
     &5.2146e-03_r8,6.7176e-03_r8,8.6804e-03_r8,1.1275e-02_r8,1.4637e-02_r8/)
      kbo(:,54, 4) = (/ &
     &4.1029e-03_r8,5.3246e-03_r8,6.9354e-03_r8,9.0873e-03_r8,1.1925e-02_r8/)
      kbo(:,55, 4) = (/ &
     &3.2267e-03_r8,4.2135e-03_r8,5.5289e-03_r8,7.2992e-03_r8,9.6811e-03_r8/)
      kbo(:,56, 4) = (/ &
     &2.5269e-03_r8,3.3219e-03_r8,4.3912e-03_r8,5.8434e-03_r8,7.8299e-03_r8/)
      kbo(:,57, 4) = (/ &
     &1.9715e-03_r8,2.6095e-03_r8,3.4757e-03_r8,4.6583e-03_r8,6.3020e-03_r8/)
      kbo(:,58, 4) = (/ &
     &1.5393e-03_r8,2.0522e-03_r8,2.7523e-03_r8,3.7145e-03_r8,5.0709e-03_r8/)
      kbo(:,59, 4) = (/ &
     &1.2601e-03_r8,1.6926e-03_r8,2.2864e-03_r8,3.1046e-03_r8,4.2734e-03_r8/)
      kbo(:,13, 5) = (/ &
     &6.9559e+00_r8,7.1944e+00_r8,7.3778e+00_r8,7.6168e+00_r8,7.8840e+00_r8/)
      kbo(:,14, 5) = (/ &
     &6.1197e+00_r8,6.3419e+00_r8,6.5357e+00_r8,6.7535e+00_r8,7.0053e+00_r8/)
      kbo(:,15, 5) = (/ &
     &5.3579e+00_r8,5.5744e+00_r8,5.7766e+00_r8,5.9767e+00_r8,6.2167e+00_r8/)
      kbo(:,16, 5) = (/ &
     &4.6816e+00_r8,4.8936e+00_r8,5.0862e+00_r8,5.2967e+00_r8,5.5327e+00_r8/)
      kbo(:,17, 5) = (/ &
     &4.0899e+00_r8,4.2917e+00_r8,4.4812e+00_r8,4.7025e+00_r8,4.9201e+00_r8/)
      kbo(:,18, 5) = (/ &
     &3.5771e+00_r8,3.7678e+00_r8,3.9593e+00_r8,4.1715e+00_r8,4.3722e+00_r8/)
      kbo(:,19, 5) = (/ &
     &3.1364e+00_r8,3.3176e+00_r8,3.5013e+00_r8,3.6935e+00_r8,3.8830e+00_r8/)
      kbo(:,20, 5) = (/ &
     &2.7593e+00_r8,2.9230e+00_r8,3.0933e+00_r8,3.2687e+00_r8,3.4499e+00_r8/)
      kbo(:,21, 5) = (/ &
     &2.4256e+00_r8,2.5724e+00_r8,2.7298e+00_r8,2.8928e+00_r8,3.0638e+00_r8/)
      kbo(:,22, 5) = (/ &
     &2.1368e+00_r8,2.2729e+00_r8,2.4183e+00_r8,2.5689e+00_r8,2.7252e+00_r8/)
      kbo(:,23, 5) = (/ &
     &1.8817e+00_r8,2.0092e+00_r8,2.1410e+00_r8,2.2786e+00_r8,2.4217e+00_r8/)
      kbo(:,24, 5) = (/ &
     &1.6588e+00_r8,1.7749e+00_r8,1.8947e+00_r8,2.0208e+00_r8,2.1527e+00_r8/)
      kbo(:,25, 5) = (/ &
     &1.4616e+00_r8,1.5668e+00_r8,1.6777e+00_r8,1.7944e+00_r8,1.9128e+00_r8/)
      kbo(:,26, 5) = (/ &
     &1.2875e+00_r8,1.3850e+00_r8,1.4881e+00_r8,1.5943e+00_r8,1.7005e+00_r8/)
      kbo(:,27, 5) = (/ &
     &1.1342e+00_r8,1.2250e+00_r8,1.3195e+00_r8,1.4155e+00_r8,1.5121e+00_r8/)
      kbo(:,28, 5) = (/ &
     &1.0000e+00_r8,1.0834e+00_r8,1.1694e+00_r8,1.2569e+00_r8,1.3467e+00_r8/)
      kbo(:,29, 5) = (/ &
     &8.8272e-01_r8,9.5878e-01_r8,1.0375e+00_r8,1.1189e+00_r8,1.2039e+00_r8/)
      kbo(:,30, 5) = (/ &
     &7.8028e-01_r8,8.4986e-01_r8,9.2253e-01_r8,9.9927e-01_r8,1.0809e+00_r8/)
      kbo(:,31, 5) = (/ &
     &6.9115e-01_r8,7.5536e-01_r8,8.2388e-01_r8,8.9787e-01_r8,9.7590e-01_r8/)
      kbo(:,32, 5) = (/ &
     &6.1412e-01_r8,6.7446e-01_r8,7.4048e-01_r8,8.1095e-01_r8,8.8670e-01_r8/)
      kbo(:,33, 5) = (/ &
     &5.4810e-01_r8,6.0636e-01_r8,6.6911e-01_r8,7.3734e-01_r8,8.1091e-01_r8/)
      kbo(:,34, 5) = (/ &
     &4.9071e-01_r8,5.4601e-01_r8,6.0648e-01_r8,6.7271e-01_r8,7.4441e-01_r8/)
      kbo(:,35, 5) = (/ &
     &4.3693e-01_r8,4.8943e-01_r8,5.4769e-01_r8,6.1149e-01_r8,6.8198e-01_r8/)
      kbo(:,36, 5) = (/ &
     &3.8551e-01_r8,4.3547e-01_r8,4.9121e-01_r8,5.5301e-01_r8,6.2109e-01_r8/)
      kbo(:,37, 5) = (/ &
     &3.3480e-01_r8,3.8150e-01_r8,4.3408e-01_r8,4.9278e-01_r8,5.5808e-01_r8/)
      kbo(:,38, 5) = (/ &
     &2.9081e-01_r8,3.3450e-01_r8,3.8398e-01_r8,4.3987e-01_r8,5.0248e-01_r8/)
      kbo(:,39, 5) = (/ &
     &2.5305e-01_r8,2.9380e-01_r8,3.4050e-01_r8,3.9390e-01_r8,4.5364e-01_r8/)
      kbo(:,40, 5) = (/ &
     &2.1671e-01_r8,2.5418e-01_r8,2.9763e-01_r8,3.4779e-01_r8,4.0458e-01_r8/)
      kbo(:,41, 5) = (/ &
     &1.8493e-01_r8,2.1926e-01_r8,2.5954e-01_r8,3.0662e-01_r8,3.6037e-01_r8/)
      kbo(:,42, 5) = (/ &
     &1.5752e-01_r8,1.8888e-01_r8,2.2625e-01_r8,2.7031e-01_r8,3.2124e-01_r8/)
      kbo(:,43, 5) = (/ &
     &1.3255e-01_r8,1.6078e-01_r8,1.9491e-01_r8,2.3576e-01_r8,2.8350e-01_r8/)
      kbo(:,44, 5) = (/ &
     &1.1061e-01_r8,1.3578e-01_r8,1.6666e-01_r8,2.0425e-01_r8,2.4865e-01_r8/)
      kbo(:,45, 5) = (/ &
     &9.1951e-02_r8,1.1424e-01_r8,1.4202e-01_r8,1.7639e-01_r8,2.1757e-01_r8/)
      kbo(:,46, 5) = (/ &
     &7.5781e-02_r8,9.5221e-02_r8,1.1993e-01_r8,1.5099e-01_r8,1.8901e-01_r8/)
      kbo(:,47, 5) = (/ &
     &6.1487e-02_r8,7.8164e-02_r8,9.9731e-02_r8,1.2737e-01_r8,1.6179e-01_r8/)
      kbo(:,48, 5) = (/ &
     &4.9580e-02_r8,6.3770e-02_r8,8.2434e-02_r8,1.0684e-01_r8,1.3786e-01_r8/)
      kbo(:,49, 5) = (/ &
     &3.9738e-02_r8,5.1709e-02_r8,6.7733e-02_r8,8.9073e-02_r8,1.1686e-01_r8/)
      kbo(:,50, 5) = (/ &
     &3.1862e-02_r8,4.1943e-02_r8,5.5637e-02_r8,7.4270e-02_r8,9.9031e-02_r8/)
      kbo(:,51, 5) = (/ &
     &2.5469e-02_r8,3.3911e-02_r8,4.5561e-02_r8,6.1725e-02_r8,8.3692e-02_r8/)
      kbo(:,52, 5) = (/ &
     &2.0254e-02_r8,2.7266e-02_r8,3.7097e-02_r8,5.1018e-02_r8,7.0332e-02_r8/)
      kbo(:,53, 5) = (/ &
     &1.6008e-02_r8,2.1779e-02_r8,3.0012e-02_r8,4.1907e-02_r8,5.8779e-02_r8/)
      kbo(:,54, 5) = (/ &
     &1.2684e-02_r8,1.7422e-02_r8,2.4313e-02_r8,3.4417e-02_r8,4.9062e-02_r8/)
      kbo(:,55, 5) = (/ &
     &1.0038e-02_r8,1.3916e-02_r8,1.9644e-02_r8,2.8164e-02_r8,4.0795e-02_r8/)
      kbo(:,56, 5) = (/ &
     &7.9079e-03_r8,1.1053e-02_r8,1.5781e-02_r8,2.2925e-02_r8,3.3750e-02_r8/)
      kbo(:,57, 5) = (/ &
     &6.2010e-03_r8,8.7295e-03_r8,1.2598e-02_r8,1.8552e-02_r8,2.7742e-02_r8/)
      kbo(:,58, 5) = (/ &
     &4.8646e-03_r8,6.8966e-03_r8,1.0058e-02_r8,1.5005e-02_r8,2.2774e-02_r8/)
      kbo(:,59, 5) = (/ &
     &4.0331e-03_r8,5.7872e-03_r8,8.5542e-03_r8,1.2975e-02_r8,2.0014e-02_r8/)
      kbo(:,13, 6) = (/ &
     &1.3874e+01_r8,1.4054e+01_r8,1.4175e+01_r8,1.4196e+01_r8,1.4254e+01_r8/)
      kbo(:,14, 6) = (/ &
     &1.2387e+01_r8,1.2564e+01_r8,1.2698e+01_r8,1.2762e+01_r8,1.2781e+01_r8/)
      kbo(:,15, 6) = (/ &
     &1.0973e+01_r8,1.1145e+01_r8,1.1274e+01_r8,1.1365e+01_r8,1.1424e+01_r8/)
      kbo(:,16, 6) = (/ &
     &9.6521e+00_r8,9.8053e+00_r8,9.9370e+00_r8,1.0047e+01_r8,1.0150e+01_r8/)
      kbo(:,17, 6) = (/ &
     &8.4222e+00_r8,8.5719e+00_r8,8.7195e+00_r8,8.8488e+00_r8,9.0159e+00_r8/)
      kbo(:,18, 6) = (/ &
     &7.3090e+00_r8,7.4668e+00_r8,7.6322e+00_r8,7.7932e+00_r8,8.0086e+00_r8/)
      kbo(:,19, 6) = (/ &
     &6.3279e+00_r8,6.4985e+00_r8,6.6813e+00_r8,6.8756e+00_r8,7.1176e+00_r8/)
      kbo(:,20, 6) = (/ &
     &5.4862e+00_r8,5.6719e+00_r8,5.8682e+00_r8,6.0850e+00_r8,6.3337e+00_r8/)
      kbo(:,21, 6) = (/ &
     &4.7753e+00_r8,4.9682e+00_r8,5.1665e+00_r8,5.3943e+00_r8,5.6406e+00_r8/)
      kbo(:,22, 6) = (/ &
     &4.1854e+00_r8,4.3703e+00_r8,4.5713e+00_r8,4.7990e+00_r8,5.0439e+00_r8/)
      kbo(:,23, 6) = (/ &
     &3.6767e+00_r8,3.8508e+00_r8,4.0542e+00_r8,4.2776e+00_r8,4.5191e+00_r8/)
      kbo(:,24, 6) = (/ &
     &3.2355e+00_r8,3.4077e+00_r8,3.6072e+00_r8,3.8245e+00_r8,4.0534e+00_r8/)
      kbo(:,25, 6) = (/ &
     &2.8580e+00_r8,3.0303e+00_r8,3.2220e+00_r8,3.4257e+00_r8,3.6444e+00_r8/)
      kbo(:,26, 6) = (/ &
     &2.5405e+00_r8,2.7078e+00_r8,2.8872e+00_r8,3.0816e+00_r8,3.2880e+00_r8/)
      kbo(:,27, 6) = (/ &
     &2.2677e+00_r8,2.4258e+00_r8,2.5973e+00_r8,2.7818e+00_r8,2.9766e+00_r8/)
      kbo(:,28, 6) = (/ &
     &2.0273e+00_r8,2.1803e+00_r8,2.3462e+00_r8,2.5211e+00_r8,2.7040e+00_r8/)
      kbo(:,29, 6) = (/ &
     &1.8190e+00_r8,1.9689e+00_r8,2.1279e+00_r8,2.2941e+00_r8,2.4662e+00_r8/)
      kbo(:,30, 6) = (/ &
     &1.6397e+00_r8,1.7844e+00_r8,1.9371e+00_r8,2.0958e+00_r8,2.2590e+00_r8/)
      kbo(:,31, 6) = (/ &
     &1.4852e+00_r8,1.6249e+00_r8,1.7714e+00_r8,1.9226e+00_r8,2.0813e+00_r8/)
      kbo(:,32, 6) = (/ &
     &1.3517e+00_r8,1.4862e+00_r8,1.6264e+00_r8,1.7745e+00_r8,1.9335e+00_r8/)
      kbo(:,33, 6) = (/ &
     &1.2364e+00_r8,1.3651e+00_r8,1.5027e+00_r8,1.6513e+00_r8,1.8098e+00_r8/)
      kbo(:,34, 6) = (/ &
     &1.1317e+00_r8,1.2571e+00_r8,1.3947e+00_r8,1.5426e+00_r8,1.7001e+00_r8/)
      kbo(:,35, 6) = (/ &
     &1.0305e+00_r8,1.1540e+00_r8,1.2902e+00_r8,1.4368e+00_r8,1.5937e+00_r8/)
      kbo(:,36, 6) = (/ &
     &9.3137e-01_r8,1.0526e+00_r8,1.1856e+00_r8,1.3299e+00_r8,1.4860e+00_r8/)
      kbo(:,37, 6) = (/ &
     &8.2931e-01_r8,9.4564e-01_r8,1.0739e+00_r8,1.2152e+00_r8,1.3682e+00_r8/)
      kbo(:,38, 6) = (/ &
     &7.3906e-01_r8,8.5034e-01_r8,9.7478e-01_r8,1.1125e+00_r8,1.2627e+00_r8/)
      kbo(:,39, 6) = (/ &
     &6.6006e-01_r8,7.6663e-01_r8,8.8732e-01_r8,1.0214e+00_r8,1.1704e+00_r8/)
      kbo(:,40, 6) = (/ &
     &5.8074e-01_r8,6.8151e-01_r8,7.9698e-01_r8,9.2673e-01_r8,1.0719e+00_r8/)
      kbo(:,41, 6) = (/ &
     &5.0970e-01_r8,6.0467e-01_r8,7.1469e-01_r8,8.3962e-01_r8,9.8097e-01_r8/)
      kbo(:,42, 6) = (/ &
     &4.4691e-01_r8,5.3653e-01_r8,6.4112e-01_r8,7.6136e-01_r8,8.9846e-01_r8/)
      kbo(:,43, 6) = (/ &
     &3.8720e-01_r8,4.7067e-01_r8,5.6921e-01_r8,6.8346e-01_r8,8.1541e-01_r8/)
      kbo(:,44, 6) = (/ &
     &3.3270e-01_r8,4.0984e-01_r8,5.0209e-01_r8,6.1017e-01_r8,7.3637e-01_r8/)
      kbo(:,45, 6) = (/ &
     &2.8475e-01_r8,3.5595e-01_r8,4.4190e-01_r8,5.4378e-01_r8,6.6410e-01_r8/)
      kbo(:,46, 6) = (/ &
     &2.4137e-01_r8,3.0640e-01_r8,3.8581e-01_r8,4.8130e-01_r8,5.9507e-01_r8/)
      kbo(:,47, 6) = (/ &
     &2.0121e-01_r8,2.5952e-01_r8,3.3199e-01_r8,4.2038e-01_r8,5.2702e-01_r8/)
      kbo(:,48, 6) = (/ &
     &1.6644e-01_r8,2.1836e-01_r8,2.8412e-01_r8,3.6558e-01_r8,4.6520e-01_r8/)
      kbo(:,49, 6) = (/ &
     &1.3664e-01_r8,1.8247e-01_r8,2.4166e-01_r8,3.1637e-01_r8,4.0912e-01_r8/)
      kbo(:,50, 6) = (/ &
     &1.1203e-01_r8,1.5228e-01_r8,2.0551e-01_r8,2.7399e-01_r8,3.6023e-01_r8/)
      kbo(:,51, 6) = (/ &
     &9.1424e-02_r8,1.2652e-01_r8,1.7413e-01_r8,2.3648e-01_r8,3.1642e-01_r8/)
      kbo(:,52, 6) = (/ &
     &7.4033e-02_r8,1.0433e-01_r8,1.4653e-01_r8,2.0289e-01_r8,2.7670e-01_r8/)
      kbo(:,53, 6) = (/ &
     &5.9468e-02_r8,8.5397e-02_r8,1.2237e-01_r8,1.7301e-01_r8,2.4059e-01_r8/)
      kbo(:,54, 6) = (/ &
     &4.7831e-02_r8,6.9932e-02_r8,1.0222e-01_r8,1.4759e-01_r8,2.0954e-01_r8/)
      kbo(:,55, 6) = (/ &
     &3.8375e-02_r8,5.7032e-02_r8,8.5062e-02_r8,1.2546e-01_r8,1.8204e-01_r8/)
      kbo(:,56, 6) = (/ &
     &3.0600e-02_r8,4.6150e-02_r8,7.0262e-02_r8,1.0594e-01_r8,1.5707e-01_r8/)
      kbo(:,57, 6) = (/ &
     &2.4221e-02_r8,3.7043e-02_r8,5.7569e-02_r8,8.8786e-02_r8,1.3465e-01_r8/)
      kbo(:,58, 6) = (/ &
     &1.9170e-02_r8,2.9713e-02_r8,4.7101e-02_r8,7.4302e-02_r8,1.1534e-01_r8/)
      kbo(:,59, 6) = (/ &
     &1.6314e-02_r8,2.5760e-02_r8,4.1528e-02_r8,6.6912e-02_r8,1.0596e-01_r8/)
      kbo(:,13, 7) = (/ &
     &2.6383e+01_r8,2.6399e+01_r8,2.6364e+01_r8,2.6286e+01_r8,2.6068e+01_r8/)
      kbo(:,14, 7) = (/ &
     &2.4391e+01_r8,2.4435e+01_r8,2.4445e+01_r8,2.4411e+01_r8,2.4344e+01_r8/)
      kbo(:,15, 7) = (/ &
     &2.2267e+01_r8,2.2343e+01_r8,2.2391e+01_r8,2.2420e+01_r8,2.2406e+01_r8/)
      kbo(:,16, 7) = (/ &
     &2.0101e+01_r8,2.0222e+01_r8,2.0311e+01_r8,2.0370e+01_r8,2.0373e+01_r8/)
      kbo(:,17, 7) = (/ &
     &1.7987e+01_r8,1.8130e+01_r8,1.8242e+01_r8,1.8316e+01_r8,1.8338e+01_r8/)
      kbo(:,18, 7) = (/ &
     &1.5956e+01_r8,1.6114e+01_r8,1.6238e+01_r8,1.6337e+01_r8,1.6400e+01_r8/)
      kbo(:,19, 7) = (/ &
     &1.4050e+01_r8,1.4210e+01_r8,1.4354e+01_r8,1.4495e+01_r8,1.4623e+01_r8/)
      kbo(:,20, 7) = (/ &
     &1.2287e+01_r8,1.2462e+01_r8,1.2644e+01_r8,1.2837e+01_r8,1.3036e+01_r8/)
      kbo(:,21, 7) = (/ &
     &1.0697e+01_r8,1.0904e+01_r8,1.1136e+01_r8,1.1376e+01_r8,1.1647e+01_r8/)
      kbo(:,22, 7) = (/ &
     &9.3216e+00_r8,9.5704e+00_r8,9.8418e+00_r8,1.0134e+01_r8,1.0464e+01_r8/)
      kbo(:,23, 7) = (/ &
     &8.1552e+00_r8,8.4381e+00_r8,8.7358e+00_r8,9.0546e+00_r8,9.4274e+00_r8/)
      kbo(:,24, 7) = (/ &
     &7.1742e+00_r8,7.4714e+00_r8,7.7800e+00_r8,8.1293e+00_r8,8.5227e+00_r8/)
      kbo(:,25, 7) = (/ &
     &6.3453e+00_r8,6.6371e+00_r8,6.9572e+00_r8,7.3300e+00_r8,7.7371e+00_r8/)
      kbo(:,26, 7) = (/ &
     &5.6325e+00_r8,5.9213e+00_r8,6.2619e+00_r8,6.6436e+00_r8,7.0622e+00_r8/)
      kbo(:,27, 7) = (/ &
     &5.0177e+00_r8,5.3180e+00_r8,5.6685e+00_r8,6.0556e+00_r8,6.4791e+00_r8/)
      kbo(:,28, 7) = (/ &
     &4.5006e+00_r8,4.8114e+00_r8,5.1630e+00_r8,5.5512e+00_r8,5.9725e+00_r8/)
      kbo(:,29, 7) = (/ &
     &4.0763e+00_r8,4.3869e+00_r8,4.7357e+00_r8,5.1215e+00_r8,5.5415e+00_r8/)
      kbo(:,30, 7) = (/ &
     &3.7197e+00_r8,4.0279e+00_r8,4.3734e+00_r8,4.7560e+00_r8,5.1758e+00_r8/)
      kbo(:,31, 7) = (/ &
     &3.4217e+00_r8,3.7276e+00_r8,4.0700e+00_r8,4.4513e+00_r8,4.8709e+00_r8/)
      kbo(:,32, 7) = (/ &
     &3.1725e+00_r8,3.4760e+00_r8,3.8179e+00_r8,4.1999e+00_r8,4.6169e+00_r8/)
      kbo(:,33, 7) = (/ &
     &2.9640e+00_r8,3.2682e+00_r8,3.6118e+00_r8,3.9912e+00_r8,4.4110e+00_r8/)
      kbo(:,34, 7) = (/ &
     &2.7815e+00_r8,3.0881e+00_r8,3.4286e+00_r8,3.8090e+00_r8,4.2366e+00_r8/)
      kbo(:,35, 7) = (/ &
     &2.6027e+00_r8,2.9073e+00_r8,3.2445e+00_r8,3.6269e+00_r8,4.0627e+00_r8/)
      kbo(:,36, 7) = (/ &
     &2.4195e+00_r8,2.7195e+00_r8,3.0535e+00_r8,3.4362e+00_r8,3.8766e+00_r8/)
      kbo(:,37, 7) = (/ &
     &2.2155e+00_r8,2.5099e+00_r8,2.8373e+00_r8,3.2150e+00_r8,3.6504e+00_r8/)
      kbo(:,38, 7) = (/ &
     &2.0317e+00_r8,2.3214e+00_r8,2.6457e+00_r8,3.0187e+00_r8,3.4497e+00_r8/)
      kbo(:,39, 7) = (/ &
     &1.8675e+00_r8,2.1535e+00_r8,2.4775e+00_r8,2.8467e+00_r8,3.2732e+00_r8/)
      kbo(:,40, 7) = (/ &
     &1.6933e+00_r8,1.9726e+00_r8,2.2917e+00_r8,2.6527e+00_r8,3.0690e+00_r8/)
      kbo(:,41, 7) = (/ &
     &1.5321e+00_r8,1.8045e+00_r8,2.1184e+00_r8,2.4731e+00_r8,2.8788e+00_r8/)
      kbo(:,42, 7) = (/ &
     &1.3858e+00_r8,1.6512e+00_r8,1.9598e+00_r8,2.3096e+00_r8,2.7061e+00_r8/)
      kbo(:,43, 7) = (/ &
     &1.2395e+00_r8,1.4953e+00_r8,1.7959e+00_r8,2.1389e+00_r8,2.5250e+00_r8/)
      kbo(:,44, 7) = (/ &
     &1.1006e+00_r8,1.3456e+00_r8,1.6365e+00_r8,1.9712e+00_r8,2.3479e+00_r8/)
      kbo(:,45, 7) = (/ &
     &9.7411e-01_r8,1.2078e+00_r8,1.4892e+00_r8,1.8150e+00_r8,2.1832e+00_r8/)
      kbo(:,46, 7) = (/ &
     &8.5489e-01_r8,1.0759e+00_r8,1.3456e+00_r8,1.6612e+00_r8,2.0197e+00_r8/)
      kbo(:,47, 7) = (/ &
     &7.3930e-01_r8,9.4494e-01_r8,1.2000e+00_r8,1.5026e+00_r8,1.8496e+00_r8/)
      kbo(:,48, 7) = (/ &
     &6.3547e-01_r8,8.2535e-01_r8,1.0653e+00_r8,1.3544e+00_r8,1.6889e+00_r8/)
      kbo(:,49, 7) = (/ &
     &5.4241e-01_r8,7.1674e-01_r8,9.4139e-01_r8,1.2160e+00_r8,1.5375e+00_r8/)
      kbo(:,50, 7) = (/ &
     &4.6304e-01_r8,6.2300e-01_r8,8.3217e-01_r8,1.0925e+00_r8,1.4012e+00_r8/)
      kbo(:,51, 7) = (/ &
     &3.9371e-01_r8,5.3995e-01_r8,7.3373e-01_r8,9.7980e-01_r8,1.2748e+00_r8/)
      kbo(:,52, 7) = (/ &
     &3.3220e-01_r8,4.6493e-01_r8,6.4396e-01_r8,8.7508e-01_r8,1.1558e+00_r8/)
      kbo(:,53, 7) = (/ &
     &2.7778e-01_r8,3.9741e-01_r8,5.6181e-01_r8,7.7785e-01_r8,1.0434e+00_r8/)
      kbo(:,54, 7) = (/ &
     &2.3274e-01_r8,3.4050e-01_r8,4.9090e-01_r8,6.9261e-01_r8,9.4387e-01_r8/)
      kbo(:,55, 7) = (/ &
     &1.9435e-01_r8,2.9105e-01_r8,4.2805e-01_r8,6.1562e-01_r8,8.5235e-01_r8/)
      kbo(:,56, 7) = (/ &
     &1.6083e-01_r8,2.4693e-01_r8,3.7158e-01_r8,5.4415e-01_r8,7.6669e-01_r8/)
      kbo(:,57, 7) = (/ &
     &1.3183e-01_r8,2.0770e-01_r8,3.2034e-01_r8,4.7818e-01_r8,6.8649e-01_r8/)
      kbo(:,58, 7) = (/ &
     &1.0786e-01_r8,1.7445e-01_r8,2.7618e-01_r8,4.2058e-01_r8,6.1481e-01_r8/)
      kbo(:,59, 7) = (/ &
     &9.5778e-02_r8,1.5879e-01_r8,2.5699e-01_r8,3.9684e-01_r8,5.8283e-01_r8/)
      kbo(:,13, 8) = (/ &
     &5.1036e+01_r8,5.0460e+01_r8,4.9876e+01_r8,4.9272e+01_r8,4.8645e+01_r8/)
      kbo(:,14, 8) = (/ &
     &4.9659e+01_r8,4.9240e+01_r8,4.8789e+01_r8,4.8317e+01_r8,4.7813e+01_r8/)
      kbo(:,15, 8) = (/ &
     &4.7836e+01_r8,4.7533e+01_r8,4.7179e+01_r8,4.6807e+01_r8,4.6408e+01_r8/)
      kbo(:,16, 8) = (/ &
     &4.5523e+01_r8,4.5307e+01_r8,4.5074e+01_r8,4.4798e+01_r8,4.4497e+01_r8/)
      kbo(:,17, 8) = (/ &
     &4.2751e+01_r8,4.2659e+01_r8,4.2523e+01_r8,4.2351e+01_r8,4.2128e+01_r8/)
      kbo(:,18, 8) = (/ &
     &3.9675e+01_r8,3.9678e+01_r8,3.9613e+01_r8,3.9512e+01_r8,3.9377e+01_r8/)
      kbo(:,19, 8) = (/ &
     &3.6385e+01_r8,3.6442e+01_r8,3.6467e+01_r8,3.6453e+01_r8,3.6385e+01_r8/)
      kbo(:,20, 8) = (/ &
     &3.2988e+01_r8,3.3119e+01_r8,3.3207e+01_r8,3.3253e+01_r8,3.3266e+01_r8/)
      kbo(:,21, 8) = (/ &
     &2.9629e+01_r8,2.9807e+01_r8,2.9950e+01_r8,3.0074e+01_r8,3.0195e+01_r8/)
      kbo(:,22, 8) = (/ &
     &2.6389e+01_r8,2.6615e+01_r8,2.6833e+01_r8,2.7054e+01_r8,2.7281e+01_r8/)
      kbo(:,23, 8) = (/ &
     &2.3355e+01_r8,2.3644e+01_r8,2.3948e+01_r8,2.4296e+01_r8,2.4660e+01_r8/)
      kbo(:,24, 8) = (/ &
     &2.0595e+01_r8,2.0963e+01_r8,2.1391e+01_r8,2.1861e+01_r8,2.2380e+01_r8/)
      kbo(:,25, 8) = (/ &
     &1.8159e+01_r8,1.8637e+01_r8,1.9183e+01_r8,1.9778e+01_r8,2.0439e+01_r8/)
      kbo(:,26, 8) = (/ &
     &1.6089e+01_r8,1.6677e+01_r8,1.7319e+01_r8,1.8032e+01_r8,1.8814e+01_r8/)
      kbo(:,27, 8) = (/ &
     &1.4363e+01_r8,1.5028e+01_r8,1.5757e+01_r8,1.6564e+01_r8,1.7443e+01_r8/)
      kbo(:,28, 8) = (/ &
     &1.2926e+01_r8,1.3648e+01_r8,1.4446e+01_r8,1.5323e+01_r8,1.6326e+01_r8/)
      kbo(:,29, 8) = (/ &
     &1.1723e+01_r8,1.2493e+01_r8,1.3349e+01_r8,1.4336e+01_r8,1.5419e+01_r8/)
      kbo(:,30, 8) = (/ &
     &1.0720e+01_r8,1.1535e+01_r8,1.2485e+01_r8,1.3543e+01_r8,1.4696e+01_r8/)
      kbo(:,31, 8) = (/ &
     &9.8953e+00_r8,1.0794e+01_r8,1.1807e+01_r8,1.2928e+01_r8,1.4151e+01_r8/)
      kbo(:,32, 8) = (/ &
     &9.2630e+00_r8,1.0213e+01_r8,1.1281e+01_r8,1.2468e+01_r8,1.3783e+01_r8/)
      kbo(:,33, 8) = (/ &
     &8.7693e+00_r8,9.7682e+00_r8,1.0900e+01_r8,1.2171e+01_r8,1.3564e+01_r8/)
      kbo(:,34, 8) = (/ &
     &8.3550e+00_r8,9.4057e+00_r8,1.0612e+01_r8,1.1954e+01_r8,1.3416e+01_r8/)
      kbo(:,35, 8) = (/ &
     &7.9503e+00_r8,9.0506e+00_r8,1.0311e+01_r8,1.1711e+01_r8,1.3230e+01_r8/)
      kbo(:,36, 8) = (/ &
     &7.5260e+00_r8,8.6513e+00_r8,9.9500e+00_r8,1.1393e+01_r8,1.2954e+01_r8/)
      kbo(:,37, 8) = (/ &
     &7.0166e+00_r8,8.1408e+00_r8,9.4476e+00_r8,1.0907e+01_r8,1.2489e+01_r8/)
      kbo(:,38, 8) = (/ &
     &6.5631e+00_r8,7.6815e+00_r8,8.9895e+00_r8,1.0461e+01_r8,1.2064e+01_r8/)
      kbo(:,39, 8) = (/ &
     &6.1678e+00_r8,7.2805e+00_r8,8.5861e+00_r8,1.0065e+01_r8,1.1676e+01_r8/)
      kbo(:,40, 8) = (/ &
     &5.7155e+00_r8,6.7987e+00_r8,8.0775e+00_r8,9.5392e+00_r8,1.1142e+01_r8/)
      kbo(:,41, 8) = (/ &
     &5.2949e+00_r8,6.3470e+00_r8,7.5914e+00_r8,9.0258e+00_r8,1.0614e+01_r8/)
      kbo(:,42, 8) = (/ &
     &4.9139e+00_r8,5.9322e+00_r8,7.1403e+00_r8,8.5407e+00_r8,1.0110e+01_r8/)
      kbo(:,43, 8) = (/ &
     &4.5194e+00_r8,5.4902e+00_r8,6.6498e+00_r8,8.0033e+00_r8,9.5351e+00_r8/)
      kbo(:,44, 8) = (/ &
     &4.1399e+00_r8,5.0576e+00_r8,6.1633e+00_r8,7.4614e+00_r8,8.9447e+00_r8/)
      kbo(:,45, 8) = (/ &
     &3.7947e+00_r8,4.6596e+00_r8,5.7095e+00_r8,6.9501e+00_r8,8.3804e+00_r8/)
      kbo(:,46, 8) = (/ &
     &3.4645e+00_r8,4.2731e+00_r8,5.2631e+00_r8,6.4408e+00_r8,7.8107e+00_r8/)
      kbo(:,47, 8) = (/ &
     &3.1333e+00_r8,3.8817e+00_r8,4.8032e+00_r8,5.9109e+00_r8,7.2077e+00_r8/)
      kbo(:,48, 8) = (/ &
     &2.8272e+00_r8,3.5252e+00_r8,4.3790e+00_r8,5.4161e+00_r8,6.6403e+00_r8/)
      kbo(:,49, 8) = (/ &
     &2.5419e+00_r8,3.2000e+00_r8,3.9894e+00_r8,4.9550e+00_r8,6.1077e+00_r8/)
      kbo(:,50, 8) = (/ &
     &2.2876e+00_r8,2.9151e+00_r8,3.6507e+00_r8,4.5513e+00_r8,5.6358e+00_r8/)
      kbo(:,51, 8) = (/ &
     &2.0539e+00_r8,2.6537e+00_r8,3.3480e+00_r8,4.1860e+00_r8,5.2042e+00_r8/)
      kbo(:,52, 8) = (/ &
     &1.8359e+00_r8,2.4075e+00_r8,3.0676e+00_r8,3.8482e+00_r8,4.8005e+00_r8/)
      kbo(:,53, 8) = (/ &
     &1.6315e+00_r8,2.1744e+00_r8,2.8043e+00_r8,3.5342e+00_r8,4.4242e+00_r8/)
      kbo(:,54, 8) = (/ &
     &1.4536e+00_r8,1.9689e+00_r8,2.5734e+00_r8,3.2651e+00_r8,4.0977e+00_r8/)
      kbo(:,55, 8) = (/ &
     &1.2924e+00_r8,1.7818e+00_r8,2.3616e+00_r8,3.0234e+00_r8,3.8040e+00_r8/)
      kbo(:,56, 8) = (/ &
     &1.1428e+00_r8,1.6042e+00_r8,2.1584e+00_r8,2.7950e+00_r8,3.5303e+00_r8/)
      kbo(:,57, 8) = (/ &
     &1.0034e+00_r8,1.4376e+00_r8,1.9645e+00_r8,2.5766e+00_r8,3.2746e+00_r8/)
      kbo(:,58, 8) = (/ &
     &8.7989e-01_r8,1.2882e+00_r8,1.7895e+00_r8,2.3775e+00_r8,3.0470e+00_r8/)
      kbo(:,59, 8) = (/ &
     &8.2607e-01_r8,1.2253e+00_r8,1.7145e+00_r8,2.2929e+00_r8,2.9546e+00_r8/)
      kbo(:,13, 9) = (/ &
     &9.9406e+01_r8,9.8017e+01_r8,9.6610e+01_r8,9.5133e+01_r8,9.3589e+01_r8/)
      kbo(:,14, 9) = (/ &
     &1.0426e+02_r8,1.0289e+02_r8,1.0145e+02_r8,9.9955e+01_r8,9.8418e+01_r8/)
      kbo(:,15, 9) = (/ &
     &1.0831e+02_r8,1.0700e+02_r8,1.0565e+02_r8,1.0422e+02_r8,1.0271e+02_r8/)
      kbo(:,16, 9) = (/ &
     &1.1144e+02_r8,1.1027e+02_r8,1.0899e+02_r8,1.0766e+02_r8,1.0626e+02_r8/)
      kbo(:,17, 9) = (/ &
     &1.1357e+02_r8,1.1252e+02_r8,1.1140e+02_r8,1.1022e+02_r8,1.0897e+02_r8/)
      kbo(:,18, 9) = (/ &
     &1.1451e+02_r8,1.1366e+02_r8,1.1275e+02_r8,1.1172e+02_r8,1.1059e+02_r8/)
      kbo(:,19, 9) = (/ &
     &1.1419e+02_r8,1.1358e+02_r8,1.1283e+02_r8,1.1199e+02_r8,1.1108e+02_r8/)
      kbo(:,20, 9) = (/ &
     &1.1253e+02_r8,1.1217e+02_r8,1.1170e+02_r8,1.1113e+02_r8,1.1043e+02_r8/)
      kbo(:,21, 9) = (/ &
     &1.0964e+02_r8,1.0959e+02_r8,1.0941e+02_r8,1.0911e+02_r8,1.0868e+02_r8/)
      kbo(:,22, 9) = (/ &
     &1.0576e+02_r8,1.0601e+02_r8,1.0614e+02_r8,1.0616e+02_r8,1.0606e+02_r8/)
      kbo(:,23, 9) = (/ &
     &1.0113e+02_r8,1.0172e+02_r8,1.0220e+02_r8,1.0257e+02_r8,1.0280e+02_r8/)
      kbo(:,24, 9) = (/ &
     &9.6005e+01_r8,9.6976e+01_r8,9.7826e+01_r8,9.8561e+01_r8,9.9182e+01_r8/)
      kbo(:,25, 9) = (/ &
     &9.0658e+01_r8,9.2026e+01_r8,9.3302e+01_r8,9.4462e+01_r8,9.5504e+01_r8/)
      kbo(:,26, 9) = (/ &
     &8.5398e+01_r8,8.7188e+01_r8,8.8895e+01_r8,9.0506e+01_r8,9.1994e+01_r8/)
      kbo(:,27, 9) = (/ &
     &8.0425e+01_r8,8.2648e+01_r8,8.4817e+01_r8,8.6900e+01_r8,8.8861e+01_r8/)
      kbo(:,28, 9) = (/ &
     &7.5902e+01_r8,7.8597e+01_r8,8.1250e+01_r8,8.3817e+01_r8,8.6189e+01_r8/)
      kbo(:,29, 9) = (/ &
     &7.2021e+01_r8,7.5193e+01_r8,7.8323e+01_r8,8.1284e+01_r8,8.4079e+01_r8/)
      kbo(:,30, 9) = (/ &
     &6.8846e+01_r8,7.2476e+01_r8,7.5986e+01_r8,7.9352e+01_r8,8.2517e+01_r8/)
      kbo(:,31, 9) = (/ &
     &6.6391e+01_r8,7.0389e+01_r8,7.4280e+01_r8,7.7994e+01_r8,8.1462e+01_r8/)
      kbo(:,32, 9) = (/ &
     &6.4577e+01_r8,6.8942e+01_r8,7.3166e+01_r8,7.7157e+01_r8,8.0829e+01_r8/)
      kbo(:,33, 9) = (/ &
     &6.3392e+01_r8,6.8071e+01_r8,7.2548e+01_r8,7.6730e+01_r8,8.0569e+01_r8/)
      kbo(:,34, 9) = (/ &
     &6.2591e+01_r8,6.7517e+01_r8,7.2182e+01_r8,7.6523e+01_r8,8.0479e+01_r8/)
      kbo(:,35, 9) = (/ &
     &6.1727e+01_r8,6.6854e+01_r8,7.1692e+01_r8,7.6175e+01_r8,8.0232e+01_r8/)
      kbo(:,36, 9) = (/ &
     &6.0594e+01_r8,6.5914e+01_r8,7.0919e+01_r8,7.5536e+01_r8,7.9714e+01_r8/)
      kbo(:,37, 9) = (/ &
     &5.8846e+01_r8,6.4364e+01_r8,6.9558e+01_r8,7.4349e+01_r8,7.8713e+01_r8/)
      kbo(:,38, 9) = (/ &
     &5.7194e+01_r8,6.2887e+01_r8,6.8247e+01_r8,7.3195e+01_r8,7.8049e+01_r8/)
      kbo(:,39, 9) = (/ &
     &5.5665e+01_r8,6.1507e+01_r8,6.7008e+01_r8,7.2147e+01_r8,7.7547e+01_r8/)
      kbo(:,40, 9) = (/ &
     &5.3621e+01_r8,5.9617e+01_r8,6.5286e+01_r8,7.0695e+01_r8,7.6340e+01_r8/)
      kbo(:,41, 9) = (/ &
     &5.1554e+01_r8,5.7685e+01_r8,6.3510e+01_r8,6.9201e+01_r8,7.4982e+01_r8/)
      kbo(:,42, 9) = (/ &
     &4.9528e+01_r8,5.5776e+01_r8,6.1743e+01_r8,6.7740e+01_r8,7.3659e+01_r8/)
      kbo(:,43, 9) = (/ &
     &4.7178e+01_r8,5.3540e+01_r8,5.9647e+01_r8,6.5886e+01_r8,7.2015e+01_r8/)
      kbo(:,44, 9) = (/ &
     &4.4688e+01_r8,5.1145e+01_r8,5.7387e+01_r8,6.3891e+01_r8,7.0203e+01_r8/)
      kbo(:,45, 9) = (/ &
     &4.2221e+01_r8,4.8754e+01_r8,5.5108e+01_r8,6.1908e+01_r8,6.8361e+01_r8/)
      kbo(:,46, 9) = (/ &
     &3.9637e+01_r8,4.6220e+01_r8,5.2693e+01_r8,5.9708e+01_r8,6.6363e+01_r8/)
      kbo(:,47, 9) = (/ &
     &3.6803e+01_r8,4.3409e+01_r8,4.9987e+01_r8,5.7153e+01_r8,6.3987e+01_r8/)
      kbo(:,48, 9) = (/ &
     &3.4015e+01_r8,4.0603e+01_r8,4.7276e+01_r8,5.4594e+01_r8,6.1608e+01_r8/)
      kbo(:,49, 9) = (/ &
     &3.1288e+01_r8,3.7812e+01_r8,4.4636e+01_r8,5.2065e+01_r8,5.9201e+01_r8/)
      kbo(:,50, 9) = (/ &
     &2.8795e+01_r8,3.5220e+01_r8,4.2061e+01_r8,4.9552e+01_r8,5.6813e+01_r8/)
      kbo(:,51, 9) = (/ &
     &2.6450e+01_r8,3.2748e+01_r8,3.9528e+01_r8,4.7065e+01_r8,5.4424e+01_r8/)
      kbo(:,52, 9) = (/ &
     &2.4182e+01_r8,3.0329e+01_r8,3.7052e+01_r8,4.4584e+01_r8,5.2041e+01_r8/)
      kbo(:,53, 9) = (/ &
     &2.1996e+01_r8,2.7965e+01_r8,3.4636e+01_r8,4.2155e+01_r8,4.9659e+01_r8/)
      kbo(:,54, 9) = (/ &
     &2.0069e+01_r8,2.5858e+01_r8,3.2251e+01_r8,3.9700e+01_r8,4.7245e+01_r8/)
      kbo(:,55, 9) = (/ &
     &1.8302e+01_r8,2.3898e+01_r8,3.0045e+01_r8,3.7230e+01_r8,4.4781e+01_r8/)
      kbo(:,56, 9) = (/ &
     &1.6618e+01_r8,2.2006e+01_r8,2.7997e+01_r8,3.4787e+01_r8,4.2319e+01_r8/)
      kbo(:,57, 9) = (/ &
     &1.5017e+01_r8,2.0180e+01_r8,2.5997e+01_r8,3.2401e+01_r8,3.9855e+01_r8/)
      kbo(:,58, 9) = (/ &
     &1.3581e+01_r8,1.8514e+01_r8,2.4151e+01_r8,3.0332e+01_r8,3.7487e+01_r8/)
      kbo(:,59, 9) = (/ &
     &1.3022e+01_r8,1.7859e+01_r8,2.3425e+01_r8,2.9551e+01_r8,3.6092e+01_r8/)
      kbo(:,13,10) = (/ &
     &1.4854e+02_r8,1.4629e+02_r8,1.4392e+02_r8,1.4179e+02_r8,1.3968e+02_r8/)
      kbo(:,14,10) = (/ &
     &1.6449e+02_r8,1.6201e+02_r8,1.5966e+02_r8,1.5740e+02_r8,1.5475e+02_r8/)
      kbo(:,15,10) = (/ &
     &1.8113e+02_r8,1.7883e+02_r8,1.7633e+02_r8,1.7356e+02_r8,1.7082e+02_r8/)
      kbo(:,16,10) = (/ &
     &1.9869e+02_r8,1.9617e+02_r8,1.9337e+02_r8,1.9057e+02_r8,1.8767e+02_r8/)
      kbo(:,17,10) = (/ &
     &2.1579e+02_r8,2.1310e+02_r8,2.1009e+02_r8,2.0678e+02_r8,2.0344e+02_r8/)
      kbo(:,18,10) = (/ &
     &2.3175e+02_r8,2.2862e+02_r8,2.2543e+02_r8,2.2232e+02_r8,2.1916e+02_r8/)
      kbo(:,19,10) = (/ &
     &2.4595e+02_r8,2.4325e+02_r8,2.4040e+02_r8,2.3730e+02_r8,2.3384e+02_r8/)
      kbo(:,20,10) = (/ &
     &2.5917e+02_r8,2.5646e+02_r8,2.5347e+02_r8,2.5026e+02_r8,2.4697e+02_r8/)
      kbo(:,21,10) = (/ &
     &2.7002e+02_r8,2.6751e+02_r8,2.6472e+02_r8,2.6184e+02_r8,2.5881e+02_r8/)
      kbo(:,22,10) = (/ &
     &2.7788e+02_r8,2.7617e+02_r8,2.7411e+02_r8,2.7166e+02_r8,2.6869e+02_r8/)
      kbo(:,23,10) = (/ &
     &2.8310e+02_r8,2.8234e+02_r8,2.8114e+02_r8,2.7929e+02_r8,2.7687e+02_r8/)
      kbo(:,24,10) = (/ &
     &2.8635e+02_r8,2.8652e+02_r8,2.8615e+02_r8,2.8511e+02_r8,2.8345e+02_r8/)
      kbo(:,25,10) = (/ &
     &2.8819e+02_r8,2.8935e+02_r8,2.8976e+02_r8,2.8954e+02_r8,2.8857e+02_r8/)
      kbo(:,26,10) = (/ &
     &2.8894e+02_r8,2.9109e+02_r8,2.9250e+02_r8,2.9307e+02_r8,2.9272e+02_r8/)
      kbo(:,27,10) = (/ &
     &2.8895e+02_r8,2.9239e+02_r8,2.9473e+02_r8,2.9595e+02_r8,2.9616e+02_r8/)
      kbo(:,28,10) = (/ &
     &2.8893e+02_r8,2.9347e+02_r8,2.9660e+02_r8,2.9845e+02_r8,2.9908e+02_r8/)
      kbo(:,29,10) = (/ &
     &2.8896e+02_r8,2.9449e+02_r8,2.9830e+02_r8,3.0067e+02_r8,3.0167e+02_r8/)
      kbo(:,30,10) = (/ &
     &2.8928e+02_r8,2.9562e+02_r8,2.9995e+02_r8,3.0268e+02_r8,3.0395e+02_r8/)
      kbo(:,31,10) = (/ &
     &2.9009e+02_r8,2.9691e+02_r8,3.0163e+02_r8,3.0456e+02_r8,3.0602e+02_r8/)
      kbo(:,32,10) = (/ &
     &2.9131e+02_r8,2.9842e+02_r8,3.0331e+02_r8,3.0639e+02_r8,3.0785e+02_r8/)
      kbo(:,33,10) = (/ &
     &2.9285e+02_r8,3.0006e+02_r8,3.0500e+02_r8,3.0808e+02_r8,3.0942e+02_r8/)
      kbo(:,34,10) = (/ &
     &2.9430e+02_r8,3.0156e+02_r8,3.0650e+02_r8,3.0954e+02_r8,3.1081e+02_r8/)
      kbo(:,35,10) = (/ &
     &2.9506e+02_r8,3.0251e+02_r8,3.0756e+02_r8,3.1064e+02_r8,3.1189e+02_r8/)
      kbo(:,36,10) = (/ &
     &2.9495e+02_r8,3.0278e+02_r8,3.0811e+02_r8,3.1136e+02_r8,3.1273e+02_r8/)
      kbo(:,37,10) = (/ &
     &2.9340e+02_r8,3.0194e+02_r8,3.0787e+02_r8,3.1159e+02_r8,3.1314e+02_r8/)
      kbo(:,38,10) = (/ &
     &2.9167e+02_r8,3.0090e+02_r8,3.0743e+02_r8,3.1157e+02_r8,3.1035e+02_r8/)
      kbo(:,39,10) = (/ &
     &2.8984e+02_r8,2.9975e+02_r8,3.0683e+02_r8,3.1096e+02_r8,3.0638e+02_r8/)
      kbo(:,40,10) = (/ &
     &2.8667e+02_r8,2.9751e+02_r8,3.0546e+02_r8,3.0937e+02_r8,3.0473e+02_r8/)
      kbo(:,41,10) = (/ &
     &2.8308e+02_r8,2.9489e+02_r8,3.0373e+02_r8,3.0736e+02_r8,3.0363e+02_r8/)
      kbo(:,42,10) = (/ &
     &2.7921e+02_r8,2.9200e+02_r8,3.0174e+02_r8,3.0479e+02_r8,3.0187e+02_r8/)
      kbo(:,43,10) = (/ &
     &2.7420e+02_r8,2.8820e+02_r8,2.9899e+02_r8,3.0230e+02_r8,2.9999e+02_r8/)
      kbo(:,44,10) = (/ &
     &2.6840e+02_r8,2.8368e+02_r8,2.9562e+02_r8,2.9904e+02_r8,2.9872e+02_r8/)
      kbo(:,45,10) = (/ &
     &2.6218e+02_r8,2.7870e+02_r8,2.9185e+02_r8,2.9503e+02_r8,2.9798e+02_r8/)
      kbo(:,46,10) = (/ &
     &2.5505e+02_r8,2.7298e+02_r8,2.8727e+02_r8,2.9090e+02_r8,2.9720e+02_r8/)
      kbo(:,47,10) = (/ &
     &2.4654e+02_r8,2.6603e+02_r8,2.8160e+02_r8,2.8645e+02_r8,2.9469e+02_r8/)
      kbo(:,48,10) = (/ &
     &2.3740e+02_r8,2.5847e+02_r8,2.7519e+02_r8,2.8106e+02_r8,2.9248e+02_r8/)
      kbo(:,49,10) = (/ &
     &2.2763e+02_r8,2.5025e+02_r8,2.6743e+02_r8,2.7456e+02_r8,2.9049e+02_r8/)
      kbo(:,50,10) = (/ &
     &2.1791e+02_r8,2.4202e+02_r8,2.6048e+02_r8,2.6898e+02_r8,2.8731e+02_r8/)
      kbo(:,51,10) = (/ &
     &2.0797e+02_r8,2.3350e+02_r8,2.5355e+02_r8,2.6334e+02_r8,2.8310e+02_r8/)
      kbo(:,52,10) = (/ &
     &1.9757e+02_r8,2.2449e+02_r8,2.4576e+02_r8,2.5715e+02_r8,2.7915e+02_r8/)
      kbo(:,53,10) = (/ &
     &1.8669e+02_r8,2.1495e+02_r8,2.3714e+02_r8,2.5067e+02_r8,2.7496e+02_r8/)
      kbo(:,54,10) = (/ &
     &1.7638e+02_r8,2.0577e+02_r8,2.3068e+02_r8,2.4491e+02_r8,2.6874e+02_r8/)
      kbo(:,55,10) = (/ &
     &1.6621e+02_r8,1.9659e+02_r8,2.2369e+02_r8,2.4095e+02_r8,2.6031e+02_r8/)
      kbo(:,56,10) = (/ &
     &1.5581e+02_r8,1.8709e+02_r8,2.1533e+02_r8,2.3658e+02_r8,2.5187e+02_r8/)
      kbo(:,57,10) = (/ &
     &1.4523e+02_r8,1.7728e+02_r8,2.0662e+02_r8,2.3157e+02_r8,2.4581e+02_r8/)
      kbo(:,58,10) = (/ &
     &1.3508e+02_r8,1.6774e+02_r8,1.9802e+02_r8,2.2497e+02_r8,2.4252e+02_r8/)
      kbo(:,59,10) = (/ &
     &1.3094e+02_r8,1.6382e+02_r8,1.9446e+02_r8,2.2185e+02_r8,2.4525e+02_r8/)
      kbo(:,13,11) = (/ &
     &1.6572e+02_r8,1.6289e+02_r8,1.6008e+02_r8,1.5714e+02_r8,1.5448e+02_r8/)
      kbo(:,14,11) = (/ &
     &1.8540e+02_r8,1.8266e+02_r8,1.7967e+02_r8,1.7665e+02_r8,1.7387e+02_r8/)
      kbo(:,15,11) = (/ &
     &2.0814e+02_r8,2.0518e+02_r8,2.0210e+02_r8,1.9898e+02_r8,1.9569e+02_r8/)
      kbo(:,16,11) = (/ &
     &2.3282e+02_r8,2.2978e+02_r8,2.2643e+02_r8,2.2243e+02_r8,2.1800e+02_r8/)
      kbo(:,17,11) = (/ &
     &2.5856e+02_r8,2.5501e+02_r8,2.5085e+02_r8,2.4632e+02_r8,2.4166e+02_r8/)
      kbo(:,18,11) = (/ &
     &2.8422e+02_r8,2.8031e+02_r8,2.7577e+02_r8,2.7086e+02_r8,2.6564e+02_r8/)
      kbo(:,19,11) = (/ &
     &3.0919e+02_r8,3.0467e+02_r8,2.9960e+02_r8,2.9432e+02_r8,2.8897e+02_r8/)
      kbo(:,20,11) = (/ &
     &3.3207e+02_r8,3.2741e+02_r8,3.2245e+02_r8,3.1728e+02_r8,3.1181e+02_r8/)
      kbo(:,21,11) = (/ &
     &3.5360e+02_r8,3.4929e+02_r8,3.4457e+02_r8,3.3936e+02_r8,3.3368e+02_r8/)
      kbo(:,22,11) = (/ &
     &3.7366e+02_r8,3.6938e+02_r8,3.6457e+02_r8,3.5924e+02_r8,3.5347e+02_r8/)
      kbo(:,23,11) = (/ &
     &3.9151e+02_r8,3.8745e+02_r8,3.8282e+02_r8,3.7760e+02_r8,3.7188e+02_r8/)
      kbo(:,24,11) = (/ &
     &4.0699e+02_r8,4.0355e+02_r8,3.9930e+02_r8,3.9428e+02_r8,3.8859e+02_r8/)
      kbo(:,25,11) = (/ &
     &4.2010e+02_r8,4.1762e+02_r8,4.1382e+02_r8,4.0900e+02_r8,4.0333e+02_r8/)
      kbo(:,26,11) = (/ &
     &4.3097e+02_r8,4.2949e+02_r8,4.2634e+02_r8,4.2177e+02_r8,4.1610e+02_r8/)
      kbo(:,27,11) = (/ &
     &4.4020e+02_r8,4.3958e+02_r8,4.3704e+02_r8,4.3277e+02_r8,4.2718e+02_r8/)
      kbo(:,28,11) = (/ &
     &4.4818e+02_r8,4.4821e+02_r8,4.4611e+02_r8,4.4212e+02_r8,4.3652e+02_r8/)
      kbo(:,29,11) = (/ &
     &4.5504e+02_r8,4.5548e+02_r8,4.5376e+02_r8,4.4984e+02_r8,4.4415e+02_r8/)
      kbo(:,30,11) = (/ &
     &4.6091e+02_r8,4.6162e+02_r8,4.6010e+02_r8,4.5616e+02_r8,4.5025e+02_r8/)
      kbo(:,31,11) = (/ &
     &4.6598e+02_r8,4.6680e+02_r8,4.6528e+02_r8,4.6118e+02_r8,4.5498e+02_r8/)
      kbo(:,32,11) = (/ &
     &4.7040e+02_r8,4.7120e+02_r8,4.6944e+02_r8,4.6509e+02_r8,4.5862e+02_r8/)
      kbo(:,33,11) = (/ &
     &4.7430e+02_r8,4.7493e+02_r8,4.7283e+02_r8,4.6810e+02_r8,4.6122e+02_r8/)
      kbo(:,34,11) = (/ &
     &4.7770e+02_r8,4.7802e+02_r8,4.7557e+02_r8,4.7044e+02_r8,4.6319e+02_r8/)
      kbo(:,35,11) = (/ &
     &4.8041e+02_r8,4.8064e+02_r8,4.7804e+02_r8,4.7275e+02_r8,4.6531e+02_r8/)
      kbo(:,36,11) = (/ &
     &4.8253e+02_r8,4.8296e+02_r8,4.8047e+02_r8,4.7521e+02_r8,4.6778e+02_r8/)
      kbo(:,37,11) = (/ &
     &4.8393e+02_r8,4.8502e+02_r8,4.8301e+02_r8,4.7821e+02_r8,4.7102e+02_r8/)
      kbo(:,38,11) = (/ &
     &4.8486e+02_r8,4.8663e+02_r8,4.8514e+02_r8,4.8082e+02_r8,4.7394e+02_r8/)
      kbo(:,39,11) = (/ &
     &4.8541e+02_r8,4.8785e+02_r8,4.8691e+02_r8,4.8302e+02_r8,4.7647e+02_r8/)
      kbo(:,40,11) = (/ &
     &4.8510e+02_r8,4.8864e+02_r8,4.8854e+02_r8,4.8540e+02_r8,4.7945e+02_r8/)
      kbo(:,41,11) = (/ &
     &4.8418e+02_r8,4.8891e+02_r8,4.8975e+02_r8,4.8740e+02_r8,4.8219e+02_r8/)
      kbo(:,42,11) = (/ &
     &4.8279e+02_r8,4.8873e+02_r8,4.9057e+02_r8,4.8904e+02_r8,4.8458e+02_r8/)
      kbo(:,43,11) = (/ &
     &4.8041e+02_r8,4.8782e+02_r8,4.9100e+02_r8,4.9049e+02_r8,4.8682e+02_r8/)
      kbo(:,44,11) = (/ &
     &4.7714e+02_r8,4.8618e+02_r8,4.9081e+02_r8,4.9150e+02_r8,4.8756e+02_r8/)
      kbo(:,45,11) = (/ &
     &4.7308e+02_r8,4.8395e+02_r8,4.9007e+02_r8,4.9204e+02_r8,4.8671e+02_r8/)
      kbo(:,46,11) = (/ &
     &4.6783e+02_r8,4.8086e+02_r8,4.8862e+02_r8,4.9205e+02_r8,4.8480e+02_r8/)
      kbo(:,47,11) = (/ &
     &4.6080e+02_r8,4.7644e+02_r8,4.8623e+02_r8,4.9139e+02_r8,4.8469e+02_r8/)
      kbo(:,48,11) = (/ &
     &4.5259e+02_r8,4.7102e+02_r8,4.8306e+02_r8,4.9003e+02_r8,4.8230e+02_r8/)
      kbo(:,49,11) = (/ &
     &4.4320e+02_r8,4.6445e+02_r8,4.7901e+02_r8,4.8786e+02_r8,4.7807e+02_r8/)
      kbo(:,50,11) = (/ &
     &4.3321e+02_r8,4.5728e+02_r8,4.7435e+02_r8,4.8518e+02_r8,4.7550e+02_r8/)
      kbo(:,51,11) = (/ &
     &4.2248e+02_r8,4.4931e+02_r8,4.6891e+02_r8,4.8193e+02_r8,4.7366e+02_r8/)
      kbo(:,52,11) = (/ &
     &4.1065e+02_r8,4.4034e+02_r8,4.6257e+02_r8,4.7793e+02_r8,4.7004e+02_r8/)
      kbo(:,53,11) = (/ &
     &3.9765e+02_r8,4.3037e+02_r8,4.5526e+02_r8,4.7213e+02_r8,4.6510e+02_r8/)
      kbo(:,54,11) = (/ &
     &3.8467e+02_r8,4.2027e+02_r8,4.4777e+02_r8,4.6790e+02_r8,4.6484e+02_r8/)
      kbo(:,55,11) = (/ &
     &3.7132e+02_r8,4.0974e+02_r8,4.3973e+02_r8,4.6220e+02_r8,4.6820e+02_r8/)
      kbo(:,56,11) = (/ &
     &3.5710e+02_r8,3.9837e+02_r8,4.3097e+02_r8,4.5580e+02_r8,4.7038e+02_r8/)
      kbo(:,57,11) = (/ &
     &3.4209e+02_r8,3.8602e+02_r8,4.2139e+02_r8,4.4866e+02_r8,4.6860e+02_r8/)
      kbo(:,58,11) = (/ &
     &3.2702e+02_r8,3.7354e+02_r8,4.1153e+02_r8,4.4115e+02_r8,4.6327e+02_r8/)
      kbo(:,59,11) = (/ &
     &3.2074e+02_r8,3.6827e+02_r8,4.0735e+02_r8,4.3797e+02_r8,4.6099e+02_r8/)
      kbo(:,13,12) = (/ &
     &1.8437e+02_r8,1.8201e+02_r8,1.7920e+02_r8,1.7619e+02_r8,1.7262e+02_r8/)
      kbo(:,14,12) = (/ &
     &2.0920e+02_r8,2.0655e+02_r8,2.0368e+02_r8,2.0039e+02_r8,1.9660e+02_r8/)
      kbo(:,15,12) = (/ &
     &2.3807e+02_r8,2.3483e+02_r8,2.3126e+02_r8,2.2723e+02_r8,2.2261e+02_r8/)
      kbo(:,16,12) = (/ &
     &2.7050e+02_r8,2.6622e+02_r8,2.6148e+02_r8,2.5668e+02_r8,2.5203e+02_r8/)
      kbo(:,17,12) = (/ &
     &3.0550e+02_r8,3.0047e+02_r8,2.9528e+02_r8,2.8984e+02_r8,2.8414e+02_r8/)
      kbo(:,18,12) = (/ &
     &3.4308e+02_r8,3.3718e+02_r8,3.3104e+02_r8,3.2458e+02_r8,3.1787e+02_r8/)
      kbo(:,19,12) = (/ &
     &3.8177e+02_r8,3.7532e+02_r8,3.6857e+02_r8,3.6127e+02_r8,3.5363e+02_r8/)
      kbo(:,20,12) = (/ &
     &4.2186e+02_r8,4.1506e+02_r8,4.0728e+02_r8,3.9905e+02_r8,3.9052e+02_r8/)
      kbo(:,21,12) = (/ &
     &4.6246e+02_r8,4.5454e+02_r8,4.4606e+02_r8,4.3704e+02_r8,4.2747e+02_r8/)
      kbo(:,22,12) = (/ &
     &5.0135e+02_r8,4.9292e+02_r8,4.8363e+02_r8,4.7369e+02_r8,4.6338e+02_r8/)
      kbo(:,23,12) = (/ &
     &5.3861e+02_r8,5.2961e+02_r8,5.1962e+02_r8,5.0894e+02_r8,4.9767e+02_r8/)
      kbo(:,24,12) = (/ &
     &5.7338e+02_r8,5.6389e+02_r8,5.5338e+02_r8,5.4189e+02_r8,5.2932e+02_r8/)
      kbo(:,25,12) = (/ &
     &6.0539e+02_r8,5.9528e+02_r8,5.8404e+02_r8,5.7158e+02_r8,5.5798e+02_r8/)
      kbo(:,26,12) = (/ &
     &6.3403e+02_r8,6.2334e+02_r8,6.1112e+02_r8,5.9770e+02_r8,5.8310e+02_r8/)
      kbo(:,27,12) = (/ &
     &6.5936e+02_r8,6.4795e+02_r8,6.3483e+02_r8,6.2036e+02_r8,6.0455e+02_r8/)
      kbo(:,28,12) = (/ &
     &6.8125e+02_r8,6.6919e+02_r8,6.5513e+02_r8,6.3951e+02_r8,6.2260e+02_r8/)
      kbo(:,29,12) = (/ &
     &6.9998e+02_r8,6.8712e+02_r8,6.7207e+02_r8,6.5530e+02_r8,6.3734e+02_r8/)
      kbo(:,30,12) = (/ &
     &7.1583e+02_r8,7.0209e+02_r8,6.8590e+02_r8,6.6805e+02_r8,6.4904e+02_r8/)
      kbo(:,31,12) = (/ &
     &7.2876e+02_r8,7.1404e+02_r8,6.9677e+02_r8,6.7790e+02_r8,6.5793e+02_r8/)
      kbo(:,32,12) = (/ &
     &7.3900e+02_r8,7.2324e+02_r8,7.0493e+02_r8,6.8513e+02_r8,6.6427e+02_r8/)
      kbo(:,33,12) = (/ &
     &7.4681e+02_r8,7.2991e+02_r8,7.1072e+02_r8,6.9001e+02_r8,6.6847e+02_r8/)
      kbo(:,34,12) = (/ &
     &7.5291e+02_r8,7.3522e+02_r8,7.1519e+02_r8,6.9374e+02_r8,6.7158e+02_r8/)
      kbo(:,35,12) = (/ &
     &7.5888e+02_r8,7.4060e+02_r8,7.1995e+02_r8,6.9804e+02_r8,6.7534e+02_r8/)
      kbo(:,36,12) = (/ &
     &7.6530e+02_r8,7.4674e+02_r8,7.2578e+02_r8,7.0348e+02_r8,6.8047e+02_r8/)
      kbo(:,37,12) = (/ &
     &7.7324e+02_r8,7.5477e+02_r8,7.3385e+02_r8,7.1142e+02_r8,6.8821e+02_r8/)
      kbo(:,38,12) = (/ &
     &7.8031e+02_r8,7.6209e+02_r8,7.4126e+02_r8,7.1874e+02_r8,6.9540e+02_r8/)
      kbo(:,39,12) = (/ &
     &7.8648e+02_r8,7.6857e+02_r8,7.4796e+02_r8,7.2542e+02_r8,7.0198e+02_r8/)
      kbo(:,40,12) = (/ &
     &7.9353e+02_r8,7.7637e+02_r8,7.5617e+02_r8,7.3391e+02_r8,7.1045e+02_r8/)
      kbo(:,41,12) = (/ &
     &7.9989e+02_r8,7.8377e+02_r8,7.6410e+02_r8,7.4214e+02_r8,7.1879e+02_r8/)
      kbo(:,42,12) = (/ &
     &8.0558e+02_r8,7.9048e+02_r8,7.7152e+02_r8,7.4994e+02_r8,7.2677e+02_r8/)
      kbo(:,43,12) = (/ &
     &8.1116e+02_r8,7.9747e+02_r8,7.7955e+02_r8,7.5862e+02_r8,7.3574e+02_r8/)
      kbo(:,44,12) = (/ &
     &8.1607e+02_r8,8.0410e+02_r8,7.8744e+02_r8,7.6731e+02_r8,7.4497e+02_r8/)
      kbo(:,45,12) = (/ &
     &8.1994e+02_r8,8.0997e+02_r8,7.9477e+02_r8,7.7561e+02_r8,7.5385e+02_r8/)
      kbo(:,46,12) = (/ &
     &8.2292e+02_r8,8.1527e+02_r8,8.0168e+02_r8,7.8384e+02_r8,7.6285e+02_r8/)
      kbo(:,47,12) = (/ &
     &8.2480e+02_r8,8.1993e+02_r8,8.0858e+02_r8,7.9229e+02_r8,7.7235e+02_r8/)
      kbo(:,48,12) = (/ &
     &8.2522e+02_r8,8.2345e+02_r8,8.1455e+02_r8,8.0002e+02_r8,7.8135e+02_r8/)
      kbo(:,49,12) = (/ &
     &8.2404e+02_r8,8.2558e+02_r8,8.1941e+02_r8,8.0697e+02_r8,7.8982e+02_r8/)
      kbo(:,50,12) = (/ &
     &8.2131e+02_r8,8.2647e+02_r8,8.2301e+02_r8,8.1277e+02_r8,7.9722e+02_r8/)
      kbo(:,51,12) = (/ &
     &8.1699e+02_r8,8.2604e+02_r8,8.2550e+02_r8,8.1759e+02_r8,8.0380e+02_r8/)
      kbo(:,52,12) = (/ &
     &8.1118e+02_r8,8.2427e+02_r8,8.2691e+02_r8,8.2151e+02_r8,8.0969e+02_r8/)
      kbo(:,53,12) = (/ &
     &8.0369e+02_r8,8.2099e+02_r8,8.2725e+02_r8,8.2455e+02_r8,8.1493e+02_r8/)
      kbo(:,54,12) = (/ &
     &7.9519e+02_r8,8.1662e+02_r8,8.2647e+02_r8,8.2649e+02_r8,8.1904e+02_r8/)
      kbo(:,55,12) = (/ &
     &7.8525e+02_r8,8.1122e+02_r8,8.2466e+02_r8,8.2753e+02_r8,8.2231e+02_r8/)
      kbo(:,56,12) = (/ &
     &7.7348e+02_r8,8.0460e+02_r8,8.2163e+02_r8,8.2776e+02_r8,8.2487e+02_r8/)
      kbo(:,57,12) = (/ &
     &7.5991e+02_r8,7.9652e+02_r8,8.1752e+02_r8,8.2701e+02_r8,8.2675e+02_r8/)
      kbo(:,58,12) = (/ &
     &7.4511e+02_r8,7.8730e+02_r8,8.1251e+02_r8,8.2536e+02_r8,8.2776e+02_r8/)
      kbo(:,59,12) = (/ &
     &7.3866e+02_r8,7.8320e+02_r8,8.1026e+02_r8,8.2449e+02_r8,8.2800e+02_r8/)
      kbo(:,13,13) = (/ &
     &2.0724e+02_r8,2.0318e+02_r8,2.0003e+02_r8,1.9694e+02_r8,1.9365e+02_r8/)
      kbo(:,14,13) = (/ &
     &2.3785e+02_r8,2.3358e+02_r8,2.2976e+02_r8,2.2561e+02_r8,2.2123e+02_r8/)
      kbo(:,15,13) = (/ &
     &2.7371e+02_r8,2.6880e+02_r8,2.6365e+02_r8,2.5854e+02_r8,2.5349e+02_r8/)
      kbo(:,16,13) = (/ &
     &3.1341e+02_r8,3.0766e+02_r8,3.0218e+02_r8,2.9651e+02_r8,2.9050e+02_r8/)
      kbo(:,17,13) = (/ &
     &3.5823e+02_r8,3.5167e+02_r8,3.4512e+02_r8,3.3848e+02_r8,3.3144e+02_r8/)
      kbo(:,18,13) = (/ &
     &4.0795e+02_r8,4.0075e+02_r8,3.9354e+02_r8,3.8585e+02_r8,3.7775e+02_r8/)
      kbo(:,19,13) = (/ &
     &4.6454e+02_r8,4.5636e+02_r8,4.4761e+02_r8,4.3852e+02_r8,4.2883e+02_r8/)
      kbo(:,20,13) = (/ &
     &5.2670e+02_r8,5.1674e+02_r8,5.0627e+02_r8,4.9500e+02_r8,4.8317e+02_r8/)
      kbo(:,21,13) = (/ &
     &5.9234e+02_r8,5.8071e+02_r8,5.6797e+02_r8,5.5430e+02_r8,5.3997e+02_r8/)
      kbo(:,22,13) = (/ &
     &6.5952e+02_r8,6.4514e+02_r8,6.2980e+02_r8,6.1347e+02_r8,5.9629e+02_r8/)
      kbo(:,23,13) = (/ &
     &7.2668e+02_r8,7.0946e+02_r8,6.9096e+02_r8,6.7135e+02_r8,6.5090e+02_r8/)
      kbo(:,24,13) = (/ &
     &7.9179e+02_r8,7.7144e+02_r8,7.4939e+02_r8,7.2625e+02_r8,7.0273e+02_r8/)
      kbo(:,25,13) = (/ &
     &8.5340e+02_r8,8.2954e+02_r8,8.0385e+02_r8,7.7737e+02_r8,7.5044e+02_r8/)
      kbo(:,26,13) = (/ &
     &9.1011e+02_r8,8.8231e+02_r8,8.5326e+02_r8,8.2331e+02_r8,7.9319e+02_r8/)
      kbo(:,27,13) = (/ &
     &9.6106e+02_r8,9.2973e+02_r8,8.9712e+02_r8,8.6391e+02_r8,8.3062e+02_r8/)
      kbo(:,28,13) = (/ &
     &1.0059e+03_r8,9.7091e+02_r8,9.3507e+02_r8,8.9869e+02_r8,8.6233e+02_r8/)
      kbo(:,29,13) = (/ &
     &1.0437e+03_r8,1.0055e+03_r8,9.6641e+02_r8,9.2715e+02_r8,8.8802e+02_r8/)
      kbo(:,30,13) = (/ &
     &1.0747e+03_r8,1.0334e+03_r8,9.9156e+02_r8,9.4965e+02_r8,9.0810e+02_r8/)
      kbo(:,31,13) = (/ &
     &1.0990e+03_r8,1.0548e+03_r8,1.0106e+03_r8,9.6642e+02_r8,9.2291e+02_r8/)
      kbo(:,32,13) = (/ &
     &1.1170e+03_r8,1.0705e+03_r8,1.0242e+03_r8,9.7810e+02_r8,9.3290e+02_r8/)
      kbo(:,33,13) = (/ &
     &1.1295e+03_r8,1.0810e+03_r8,1.0329e+03_r8,9.8524e+02_r8,9.3872e+02_r8/)
      kbo(:,34,13) = (/ &
     &1.1390e+03_r8,1.0889e+03_r8,1.0392e+03_r8,9.9037e+02_r8,9.4276e+02_r8/)
      kbo(:,35,13) = (/ &
     &1.1495e+03_r8,1.0980e+03_r8,1.0471e+03_r8,9.9723e+02_r8,9.4859e+02_r8/)
      kbo(:,36,13) = (/ &
     &1.1627e+03_r8,1.1100e+03_r8,1.0580e+03_r8,1.0071e+03_r8,9.5754e+02_r8/)
      kbo(:,37,13) = (/ &
     &1.1817e+03_r8,1.1279e+03_r8,1.0749e+03_r8,1.0229e+03_r8,9.7232e+02_r8/)
      kbo(:,38,13) = (/ &
     &1.1995e+03_r8,1.1446e+03_r8,1.0907e+03_r8,1.0378e+03_r8,9.8626e+02_r8/)
      kbo(:,39,13) = (/ &
     &1.2156e+03_r8,1.1601e+03_r8,1.1053e+03_r8,1.0516e+03_r8,9.9926e+02_r8/)
      kbo(:,40,13) = (/ &
     &1.2364e+03_r8,1.1800e+03_r8,1.1244e+03_r8,1.0699e+03_r8,1.0167e+03_r8/)
      kbo(:,41,13) = (/ &
     &1.2568e+03_r8,1.1999e+03_r8,1.1435e+03_r8,1.0883e+03_r8,1.0343e+03_r8/)
      kbo(:,42,13) = (/ &
     &1.2764e+03_r8,1.2191e+03_r8,1.1621e+03_r8,1.1062e+03_r8,1.0515e+03_r8/)
      kbo(:,43,13) = (/ &
     &1.2983e+03_r8,1.2411e+03_r8,1.1834e+03_r8,1.1268e+03_r8,1.0715e+03_r8/)
      kbo(:,44,13) = (/ &
     &1.3210e+03_r8,1.2639e+03_r8,1.2059e+03_r8,1.1485e+03_r8,1.0925e+03_r8/)
      kbo(:,45,13) = (/ &
     &1.3430e+03_r8,1.2862e+03_r8,1.2280e+03_r8,1.1702e+03_r8,1.1134e+03_r8/)
      kbo(:,46,13) = (/ &
     &1.3658e+03_r8,1.3092e+03_r8,1.2511e+03_r8,1.1929e+03_r8,1.1355e+03_r8/)
      kbo(:,47,13) = (/ &
     &1.3902e+03_r8,1.3342e+03_r8,1.2766e+03_r8,1.2180e+03_r8,1.1600e+03_r8/)
      kbo(:,48,13) = (/ &
     &1.4137e+03_r8,1.3587e+03_r8,1.3015e+03_r8,1.2430e+03_r8,1.1845e+03_r8/)
      kbo(:,49,13) = (/ &
     &1.4360e+03_r8,1.3827e+03_r8,1.3260e+03_r8,1.2679e+03_r8,1.2090e+03_r8/)
      kbo(:,50,13) = (/ &
     &1.4561e+03_r8,1.4046e+03_r8,1.3487e+03_r8,1.2910e+03_r8,1.2321e+03_r8/)
      kbo(:,51,13) = (/ &
     &1.4745e+03_r8,1.4251e+03_r8,1.3704e+03_r8,1.3131e+03_r8,1.2546e+03_r8/)
      kbo(:,52,13) = (/ &
     &1.4914e+03_r8,1.4448e+03_r8,1.3917e+03_r8,1.3349e+03_r8,1.2767e+03_r8/)
      kbo(:,53,13) = (/ &
     &1.5066e+03_r8,1.4635e+03_r8,1.4124e+03_r8,1.3565e+03_r8,1.2987e+03_r8/)
      kbo(:,54,13) = (/ &
     &1.5189e+03_r8,1.4798e+03_r8,1.4307e+03_r8,1.3761e+03_r8,1.3187e+03_r8/)
      kbo(:,55,13) = (/ &
     &1.5296e+03_r8,1.4942e+03_r8,1.4476e+03_r8,1.3946e+03_r8,1.3376e+03_r8/)
      kbo(:,56,13) = (/ &
     &1.5385e+03_r8,1.5073e+03_r8,1.4637e+03_r8,1.4124e+03_r8,1.3564e+03_r8/)
      kbo(:,57,13) = (/ &
     &1.5454e+03_r8,1.5190e+03_r8,1.4793e+03_r8,1.4298e+03_r8,1.3750e+03_r8/)
      kbo(:,58,13) = (/ &
     &1.5501e+03_r8,1.5291e+03_r8,1.4929e+03_r8,1.4457e+03_r8,1.3924e+03_r8/)
      kbo(:,59,13) = (/ &
     &1.5515e+03_r8,1.5328e+03_r8,1.4982e+03_r8,1.4521e+03_r8,1.3993e+03_r8/)
      kbo(:,13,14) = (/ &
     &2.5226e+02_r8,2.4628e+02_r8,2.3949e+02_r8,2.3300e+02_r8,2.2711e+02_r8/)
      kbo(:,14,14) = (/ &
     &2.8391e+02_r8,2.7613e+02_r8,2.6825e+02_r8,2.6100e+02_r8,2.5461e+02_r8/)
      kbo(:,15,14) = (/ &
     &3.2054e+02_r8,3.1155e+02_r8,3.0330e+02_r8,2.9588e+02_r8,2.8901e+02_r8/)
      kbo(:,16,14) = (/ &
     &3.6563e+02_r8,3.5616e+02_r8,3.4734e+02_r8,3.3914e+02_r8,3.3106e+02_r8/)
      kbo(:,17,14) = (/ &
     &4.2096e+02_r8,4.1081e+02_r8,4.0125e+02_r8,3.9214e+02_r8,3.8323e+02_r8/)
      kbo(:,18,14) = (/ &
     &4.8740e+02_r8,4.7626e+02_r8,4.6528e+02_r8,4.5466e+02_r8,4.4412e+02_r8/)
      kbo(:,19,14) = (/ &
     &5.6419e+02_r8,5.5097e+02_r8,5.3827e+02_r8,5.2557e+02_r8,5.1276e+02_r8/)
      kbo(:,20,14) = (/ &
     &6.5011e+02_r8,6.3415e+02_r8,6.1868e+02_r8,6.0321e+02_r8,5.8733e+02_r8/)
      kbo(:,21,14) = (/ &
     &7.4435e+02_r8,7.2484e+02_r8,7.0550e+02_r8,6.8621e+02_r8,6.6643e+02_r8/)
      kbo(:,22,14) = (/ &
     &8.4421e+02_r8,8.2013e+02_r8,7.9603e+02_r8,7.7185e+02_r8,7.4730e+02_r8/)
      kbo(:,23,14) = (/ &
     &9.4857e+02_r8,9.1895e+02_r8,8.8918e+02_r8,8.5916e+02_r8,8.2913e+02_r8/)
      kbo(:,24,14) = (/ &
     &1.0549e+03_r8,1.0183e+03_r8,9.8186e+02_r8,9.4534e+02_r8,9.0882e+02_r8/)
      kbo(:,25,14) = (/ &
     &1.1590e+03_r8,1.1145e+03_r8,1.0708e+03_r8,1.0270e+03_r8,9.8371e+02_r8/)
      kbo(:,26,14) = (/ &
     &1.2562e+03_r8,1.2038e+03_r8,1.1521e+03_r8,1.1010e+03_r8,1.0508e+03_r8/)
      kbo(:,27,14) = (/ &
     &1.3447e+03_r8,1.2836e+03_r8,1.2238e+03_r8,1.1655e+03_r8,1.1088e+03_r8/)
      kbo(:,28,14) = (/ &
     &1.4217e+03_r8,1.3523e+03_r8,1.2847e+03_r8,1.2199e+03_r8,1.1573e+03_r8/)
      kbo(:,29,14) = (/ &
     &1.4859e+03_r8,1.4088e+03_r8,1.3346e+03_r8,1.2639e+03_r8,1.1961e+03_r8/)
      kbo(:,30,14) = (/ &
     &1.5380e+03_r8,1.4539e+03_r8,1.3740e+03_r8,1.2981e+03_r8,1.2259e+03_r8/)
      kbo(:,31,14) = (/ &
     &1.5776e+03_r8,1.4880e+03_r8,1.4031e+03_r8,1.3231e+03_r8,1.2472e+03_r8/)
      kbo(:,32,14) = (/ &
     &1.6062e+03_r8,1.5119e+03_r8,1.4231e+03_r8,1.3398e+03_r8,1.2610e+03_r8/)
      kbo(:,33,14) = (/ &
     &1.6248e+03_r8,1.5270e+03_r8,1.4353e+03_r8,1.3494e+03_r8,1.2686e+03_r8/)
      kbo(:,34,14) = (/ &
     &1.6386e+03_r8,1.5378e+03_r8,1.4439e+03_r8,1.3560e+03_r8,1.2737e+03_r8/)
      kbo(:,35,14) = (/ &
     &1.6557e+03_r8,1.5522e+03_r8,1.4559e+03_r8,1.3661e+03_r8,1.2821e+03_r8/)
      kbo(:,36,14) = (/ &
     &1.6790e+03_r8,1.5727e+03_r8,1.4740e+03_r8,1.3819e+03_r8,1.2962e+03_r8/)
      kbo(:,37,14) = (/ &
     &1.7154e+03_r8,1.6055e+03_r8,1.5035e+03_r8,1.4086e+03_r8,1.3204e+03_r8/)
      kbo(:,38,14) = (/ &
     &1.7499e+03_r8,1.6367e+03_r8,1.5316e+03_r8,1.4342e+03_r8,1.3436e+03_r8/)
      kbo(:,39,14) = (/ &
     &1.7821e+03_r8,1.6659e+03_r8,1.5579e+03_r8,1.4580e+03_r8,1.3653e+03_r8/)
      kbo(:,40,14) = (/ &
     &1.8250e+03_r8,1.7051e+03_r8,1.5937e+03_r8,1.4906e+03_r8,1.3951e+03_r8/)
      kbo(:,41,14) = (/ &
     &1.8687e+03_r8,1.7449e+03_r8,1.6302e+03_r8,1.5239e+03_r8,1.4257e+03_r8/)
      kbo(:,42,14) = (/ &
     &1.9118e+03_r8,1.7843e+03_r8,1.6662e+03_r8,1.5570e+03_r8,1.4560e+03_r8/)
      kbo(:,43,14) = (/ &
     &1.9625e+03_r8,1.8305e+03_r8,1.7087e+03_r8,1.5959e+03_r8,1.4917e+03_r8/)
      kbo(:,44,14) = (/ &
     &2.0169e+03_r8,1.8802e+03_r8,1.7544e+03_r8,1.6379e+03_r8,1.5302e+03_r8/)
      kbo(:,45,14) = (/ &
     &2.0719e+03_r8,1.9306e+03_r8,1.8005e+03_r8,1.6804e+03_r8,1.5693e+03_r8/)
      kbo(:,46,14) = (/ &
     &2.1310e+03_r8,1.9850e+03_r8,1.8502e+03_r8,1.7262e+03_r8,1.6114e+03_r8/)
      kbo(:,47,14) = (/ &
     &2.1977e+03_r8,2.0465e+03_r8,1.9066e+03_r8,1.7781e+03_r8,1.6592e+03_r8/)
      kbo(:,48,14) = (/ &
     &2.2663e+03_r8,2.1096e+03_r8,1.9646e+03_r8,1.8312e+03_r8,1.7082e+03_r8/)
      kbo(:,49,14) = (/ &
     &2.3369e+03_r8,2.1743e+03_r8,2.0243e+03_r8,1.8859e+03_r8,1.7586e+03_r8/)
      kbo(:,50,14) = (/ &
     &2.4050e+03_r8,2.2366e+03_r8,2.0818e+03_r8,1.9387e+03_r8,1.8071e+03_r8/)
      kbo(:,51,14) = (/ &
     &2.4725e+03_r8,2.2988e+03_r8,2.1390e+03_r8,1.9914e+03_r8,1.8554e+03_r8/)
      kbo(:,52,14) = (/ &
     &2.5415e+03_r8,2.3629e+03_r8,2.1974e+03_r8,2.0453e+03_r8,1.9050e+03_r8/)
      kbo(:,53,14) = (/ &
     &2.6121e+03_r8,2.4283e+03_r8,2.2576e+03_r8,2.1009e+03_r8,1.9561e+03_r8/)
      kbo(:,54,14) = (/ &
     &2.6782e+03_r8,2.4899e+03_r8,2.3146e+03_r8,2.1531e+03_r8,2.0043e+03_r8/)
      kbo(:,55,14) = (/ &
     &2.7428e+03_r8,2.5502e+03_r8,2.3706e+03_r8,2.2044e+03_r8,2.0516e+03_r8/)
      kbo(:,56,14) = (/ &
     &2.8087e+03_r8,2.6116e+03_r8,2.4275e+03_r8,2.2567e+03_r8,2.0999e+03_r8/)
      kbo(:,57,14) = (/ &
     &2.8759e+03_r8,2.6742e+03_r8,2.4859e+03_r8,2.3106e+03_r8,2.1494e+03_r8/)
      kbo(:,58,14) = (/ &
     &2.9406e+03_r8,2.7347e+03_r8,2.5423e+03_r8,2.3630e+03_r8,2.1974e+03_r8/)
      kbo(:,59,14) = (/ &
     &2.9672e+03_r8,2.7595e+03_r8,2.5656e+03_r8,2.3846e+03_r8,2.2171e+03_r8/)
      kbo(:,13,15) = (/ &
     &3.0519e+02_r8,3.0114e+02_r8,2.9666e+02_r8,2.9142e+02_r8,2.8521e+02_r8/)
      kbo(:,14,15) = (/ &
     &3.4479e+02_r8,3.4114e+02_r8,3.3631e+02_r8,3.3085e+02_r8,3.2433e+02_r8/)
      kbo(:,15,15) = (/ &
     &3.8993e+02_r8,3.8674e+02_r8,3.8200e+02_r8,3.7573e+02_r8,3.6825e+02_r8/)
      kbo(:,16,15) = (/ &
     &4.4412e+02_r8,4.3994e+02_r8,4.3428e+02_r8,4.2699e+02_r8,4.1897e+02_r8/)
      kbo(:,17,15) = (/ &
     &5.0918e+02_r8,5.0358e+02_r8,4.9594e+02_r8,4.8667e+02_r8,4.7654e+02_r8/)
      kbo(:,18,15) = (/ &
     &5.8800e+02_r8,5.7963e+02_r8,5.6899e+02_r8,5.5650e+02_r8,5.4319e+02_r8/)
      kbo(:,19,15) = (/ &
     &6.8137e+02_r8,6.6869e+02_r8,6.5385e+02_r8,6.3714e+02_r8,6.1975e+02_r8/)
      kbo(:,20,15) = (/ &
     &7.8942e+02_r8,7.7129e+02_r8,7.5076e+02_r8,7.2873e+02_r8,7.0666e+02_r8/)
      kbo(:,21,15) = (/ &
     &9.1222e+02_r8,8.8683e+02_r8,8.5955e+02_r8,8.3129e+02_r8,8.0321e+02_r8/)
      kbo(:,22,15) = (/ &
     &1.0462e+03_r8,1.0122e+03_r8,9.7665e+02_r8,9.4080e+02_r8,9.0511e+02_r8/)
      kbo(:,23,15) = (/ &
     &1.1896e+03_r8,1.1445e+03_r8,1.0990e+03_r8,1.0540e+03_r8,1.0094e+03_r8/)
      kbo(:,24,15) = (/ &
     &1.3365e+03_r8,1.2790e+03_r8,1.2222e+03_r8,1.1664e+03_r8,1.1117e+03_r8/)
      kbo(:,25,15) = (/ &
     &1.4807e+03_r8,1.4091e+03_r8,1.3391e+03_r8,1.2717e+03_r8,1.2073e+03_r8/)
      kbo(:,26,15) = (/ &
     &1.6156e+03_r8,1.5289e+03_r8,1.4461e+03_r8,1.3673e+03_r8,1.2929e+03_r8/)
      kbo(:,27,15) = (/ &
     &1.7387e+03_r8,1.6377e+03_r8,1.5427e+03_r8,1.4535e+03_r8,1.3699e+03_r8/)
      kbo(:,28,15) = (/ &
     &1.8481e+03_r8,1.7337e+03_r8,1.6274e+03_r8,1.5282e+03_r8,1.4358e+03_r8/)
      kbo(:,29,15) = (/ &
     &1.9406e+03_r8,1.8143e+03_r8,1.6975e+03_r8,1.5890e+03_r8,1.4891e+03_r8/)
      kbo(:,30,15) = (/ &
     &2.0157e+03_r8,1.8789e+03_r8,1.7529e+03_r8,1.6367e+03_r8,1.5303e+03_r8/)
      kbo(:,31,15) = (/ &
     &2.0726e+03_r8,1.9271e+03_r8,1.7935e+03_r8,1.6714e+03_r8,1.5596e+03_r8/)
      kbo(:,32,15) = (/ &
     &2.1128e+03_r8,1.9603e+03_r8,1.8210e+03_r8,1.6943e+03_r8,1.5785e+03_r8/)
      kbo(:,33,15) = (/ &
     &2.1379e+03_r8,1.9802e+03_r8,1.8368e+03_r8,1.7069e+03_r8,1.5884e+03_r8/)
      kbo(:,34,15) = (/ &
     &2.1559e+03_r8,1.9943e+03_r8,1.8478e+03_r8,1.7154e+03_r8,1.5948e+03_r8/)
      kbo(:,35,15) = (/ &
     &2.1801e+03_r8,2.0143e+03_r8,1.8645e+03_r8,1.7293e+03_r8,1.6063e+03_r8/)
      kbo(:,36,15) = (/ &
     &2.2153e+03_r8,2.0448e+03_r8,1.8906e+03_r8,1.7519e+03_r8,1.6260e+03_r8/)
      kbo(:,37,15) = (/ &
     &2.2726e+03_r8,2.0949e+03_r8,1.9348e+03_r8,1.7908e+03_r8,1.6606e+03_r8/)
      kbo(:,38,15) = (/ &
     &2.3276e+03_r8,2.1431e+03_r8,1.9773e+03_r8,1.8285e+03_r8,1.6940e+03_r8/)
      kbo(:,39,15) = (/ &
     &2.3794e+03_r8,2.1884e+03_r8,2.0174e+03_r8,1.8638e+03_r8,1.7255e+03_r8/)
      kbo(:,40,15) = (/ &
     &2.4500e+03_r8,2.2506e+03_r8,2.0727e+03_r8,1.9128e+03_r8,1.7693e+03_r8/)
      kbo(:,41,15) = (/ &
     &2.5230e+03_r8,2.3148e+03_r8,2.1296e+03_r8,1.9633e+03_r8,1.8145e+03_r8/)
      kbo(:,42,15) = (/ &
     &2.5961e+03_r8,2.3790e+03_r8,2.1863e+03_r8,2.0139e+03_r8,1.8595e+03_r8/)
      kbo(:,43,15) = (/ &
     &2.6832e+03_r8,2.4556e+03_r8,2.2539e+03_r8,2.0744e+03_r8,1.9133e+03_r8/)
      kbo(:,44,15) = (/ &
     &2.7787e+03_r8,2.5394e+03_r8,2.3280e+03_r8,2.1403e+03_r8,1.9719e+03_r8/)
      kbo(:,45,15) = (/ &
     &2.8773e+03_r8,2.6257e+03_r8,2.4039e+03_r8,2.2077e+03_r8,2.0320e+03_r8/)
      kbo(:,46,15) = (/ &
     &2.9856e+03_r8,2.7201e+03_r8,2.4871e+03_r8,2.2811e+03_r8,2.0978e+03_r8/)
      kbo(:,47,15) = (/ &
     &3.1115e+03_r8,2.8292e+03_r8,2.5830e+03_r8,2.3659e+03_r8,2.1733e+03_r8/)
      kbo(:,48,15) = (/ &
     &3.2432e+03_r8,2.9440e+03_r8,2.6832e+03_r8,2.4542e+03_r8,2.2517e+03_r8/)
      kbo(:,49,15) = (/ &
     &3.3819e+03_r8,3.0648e+03_r8,2.7882e+03_r8,2.5466e+03_r8,2.3333e+03_r8/)
      kbo(:,50,15) = (/ &
     &3.5188e+03_r8,3.1840e+03_r8,2.8918e+03_r8,2.6374e+03_r8,2.4134e+03_r8/)
      kbo(:,51,15) = (/ &
     &3.6589e+03_r8,3.3051e+03_r8,2.9974e+03_r8,2.7291e+03_r8,2.4943e+03_r8/)
      kbo(:,52,15) = (/ &
     &3.8062e+03_r8,3.4317e+03_r8,3.1077e+03_r8,2.8252e+03_r8,2.5787e+03_r8/)
      kbo(:,53,15) = (/ &
     &3.9623e+03_r8,3.5652e+03_r8,3.2237e+03_r8,2.9261e+03_r8,2.6671e+03_r8/)
      kbo(:,54,15) = (/ &
     &4.1133e+03_r8,3.6940e+03_r8,3.3349e+03_r8,3.0230e+03_r8,2.7515e+03_r8/)
      kbo(:,55,15) = (/ &
     &4.2651e+03_r8,3.8236e+03_r8,3.4464e+03_r8,3.1202e+03_r8,2.8359e+03_r8/)
      kbo(:,56,15) = (/ &
     &4.4246e+03_r8,3.9598e+03_r8,3.5625e+03_r8,3.2212e+03_r8,2.9236e+03_r8/)
      kbo(:,57,15) = (/ &
     &4.5926e+03_r8,4.1026e+03_r8,3.6846e+03_r8,3.3264e+03_r8,3.0154e+03_r8/)
      kbo(:,58,15) = (/ &
     &4.7612e+03_r8,4.2446e+03_r8,3.8056e+03_r8,3.4306e+03_r8,3.1063e+03_r8/)
      kbo(:,59,15) = (/ &
     &4.8322e+03_r8,4.3040e+03_r8,3.8565e+03_r8,3.4742e+03_r8,3.1440e+03_r8/)
      kbo(:,13,16) = (/ &
     &3.6471e+02_r8,3.5203e+02_r8,3.4366e+02_r8,3.3754e+02_r8,3.3391e+02_r8/)
      kbo(:,14,16) = (/ &
     &4.3205e+02_r8,4.1910e+02_r8,4.0949e+02_r8,4.0181e+02_r8,3.9611e+02_r8/)
      kbo(:,15,16) = (/ &
     &5.1076e+02_r8,4.9691e+02_r8,4.8535e+02_r8,4.7583e+02_r8,4.6772e+02_r8/)
      kbo(:,16,16) = (/ &
     &6.0124e+02_r8,5.8532e+02_r8,5.7134e+02_r8,5.5921e+02_r8,5.4786e+02_r8/)
      kbo(:,17,16) = (/ &
     &7.0293e+02_r8,6.8353e+02_r8,6.6658e+02_r8,6.5132e+02_r8,6.3843e+02_r8/)
      kbo(:,18,16) = (/ &
     &8.1350e+02_r8,7.9054e+02_r8,7.7108e+02_r8,7.5418e+02_r8,7.3825e+02_r8/)
      kbo(:,19,16) = (/ &
     &9.3232e+02_r8,9.0753e+02_r8,8.8580e+02_r8,8.6501e+02_r8,8.4456e+02_r8/)
      kbo(:,20,16) = (/ &
     &1.0608e+03_r8,1.0329e+03_r8,1.0063e+03_r8,9.8009e+02_r8,9.5395e+02_r8/)
      kbo(:,21,16) = (/ &
     &1.1958e+03_r8,1.1622e+03_r8,1.1292e+03_r8,1.0962e+03_r8,1.0633e+03_r8/)
      kbo(:,22,16) = (/ &
     &1.3311e+03_r8,1.2897e+03_r8,1.2482e+03_r8,1.2072e+03_r8,1.1676e+03_r8/)
      kbo(:,23,16) = (/ &
     &1.4683e+03_r8,1.4174e+03_r8,1.3670e+03_r8,1.3170e+03_r8,1.2708e+03_r8/)
      kbo(:,24,16) = (/ &
     &1.6081e+03_r8,1.5439e+03_r8,1.4829e+03_r8,1.4263e+03_r8,1.3726e+03_r8/)
      kbo(:,25,16) = (/ &
     &1.7506e+03_r8,1.6769e+03_r8,1.6089e+03_r8,1.5421e+03_r8,1.4771e+03_r8/)
      kbo(:,26,16) = (/ &
     &1.9057e+03_r8,1.8182e+03_r8,1.7345e+03_r8,1.6548e+03_r8,1.5773e+03_r8/)
      kbo(:,27,16) = (/ &
     &2.0569e+03_r8,1.9520e+03_r8,1.8523e+03_r8,1.7577e+03_r8,1.6669e+03_r8/)
      kbo(:,28,16) = (/ &
     &2.1937e+03_r8,2.0714e+03_r8,1.9558e+03_r8,1.8469e+03_r8,1.7437e+03_r8/)
      kbo(:,29,16) = (/ &
     &2.3109e+03_r8,2.1712e+03_r8,2.0410e+03_r8,1.9197e+03_r8,1.8067e+03_r8/)
      kbo(:,30,16) = (/ &
     &2.4059e+03_r8,2.2511e+03_r8,2.1086e+03_r8,1.9768e+03_r8,1.8554e+03_r8/)
      kbo(:,31,16) = (/ &
     &2.4785e+03_r8,2.3110e+03_r8,2.1586e+03_r8,2.0181e+03_r8,1.8908e+03_r8/)
      kbo(:,32,16) = (/ &
     &2.5298e+03_r8,2.3528e+03_r8,2.1923e+03_r8,2.0454e+03_r8,1.9136e+03_r8/)
      kbo(:,33,16) = (/ &
     &2.5622e+03_r8,2.3783e+03_r8,2.2119e+03_r8,2.0610e+03_r8,1.9258e+03_r8/)
      kbo(:,34,16) = (/ &
     &2.5858e+03_r8,2.3964e+03_r8,2.2256e+03_r8,2.0716e+03_r8,1.9341e+03_r8/)
      kbo(:,35,16) = (/ &
     &2.6161e+03_r8,2.4209e+03_r8,2.2454e+03_r8,2.0882e+03_r8,1.9479e+03_r8/)
      kbo(:,36,16) = (/ &
     &2.6591e+03_r8,2.4573e+03_r8,2.2765e+03_r8,2.1149e+03_r8,1.9709e+03_r8/)
      kbo(:,37,16) = (/ &
     &2.7282e+03_r8,2.5168e+03_r8,2.3287e+03_r8,2.1606e+03_r8,2.0108e+03_r8/)
      kbo(:,38,16) = (/ &
     &2.7948e+03_r8,2.5745e+03_r8,2.3791e+03_r8,2.2045e+03_r8,2.0494e+03_r8/)
      kbo(:,39,16) = (/ &
     &2.8577e+03_r8,2.6290e+03_r8,2.4266e+03_r8,2.2455e+03_r8,2.0858e+03_r8/)
      kbo(:,40,16) = (/ &
     &2.9439e+03_r8,2.7038e+03_r8,2.4920e+03_r8,2.3032e+03_r8,2.1363e+03_r8/)
      kbo(:,41,16) = (/ &
     &3.0330e+03_r8,2.7810e+03_r8,2.5596e+03_r8,2.3632e+03_r8,2.1888e+03_r8/)
      kbo(:,42,16) = (/ &
     &3.1221e+03_r8,2.8586e+03_r8,2.6274e+03_r8,2.4230e+03_r8,2.2411e+03_r8/)
      kbo(:,43,16) = (/ &
     &3.2294e+03_r8,2.9518e+03_r8,2.6848e+03_r8,2.4944e+03_r8,2.3041e+03_r8/)
      kbo(:,44,16) = (/ &
     &3.3475e+03_r8,3.0539e+03_r8,2.7976e+03_r8,2.5728e+03_r8,2.3737e+03_r8/)
      kbo(:,45,16) = (/ &
     &3.4703e+03_r8,3.1592e+03_r8,2.8896e+03_r8,2.6532e+03_r8,2.4448e+03_r8/)
      kbo(:,46,16) = (/ &
     &3.6062e+03_r8,3.2757e+03_r8,2.9905e+03_r8,2.7415e+03_r8,2.5226e+03_r8/)
      kbo(:,47,16) = (/ &
     &3.7659e+03_r8,3.4109e+03_r8,3.1077e+03_r8,2.8434e+03_r8,2.6124e+03_r8/)
      kbo(:,48,16) = (/ &
     &3.9357e+03_r8,3.5542e+03_r8,3.2307e+03_r8,2.9507e+03_r8,2.7060e+03_r8/)
      kbo(:,49,16) = (/ &
     &4.1183e+03_r8,3.7067e+03_r8,3.3602e+03_r8,3.0634e+03_r8,2.8046e+03_r8/)
      kbo(:,50,16) = (/ &
     &4.3018e+03_r8,3.8593e+03_r8,3.4893e+03_r8,3.1743e+03_r8,2.9010e+03_r8/)
      kbo(:,51,16) = (/ &
     &4.4921e+03_r8,4.0168e+03_r8,3.6208e+03_r8,3.2876e+03_r8,3.0000e+03_r8/)
      kbo(:,52,16) = (/ &
     &4.6953e+03_r8,4.1848e+03_r8,3.7620e+03_r8,3.4065e+03_r8,3.1029e+03_r8/)
      kbo(:,53,16) = (/ &
     &4.9149e+03_r8,4.3644e+03_r8,3.9107e+03_r8,3.5325e+03_r8,3.2110e+03_r8/)
      kbo(:,54,16) = (/ &
     &5.1330e+03_r8,4.5400e+03_r8,4.0560e+03_r8,3.6544e+03_r8,3.3151e+03_r8/)
      kbo(:,55,16) = (/ &
     &5.3615e+03_r8,4.7192e+03_r8,4.2041e+03_r8,3.7779e+03_r8,3.4198e+03_r8/)
      kbo(:,56,16) = (/ &
     &5.6061e+03_r8,4.9107e+03_r8,4.3608e+03_r8,3.9074e+03_r8,3.5296e+03_r8/)
      kbo(:,57,16) = (/ &
     &5.8683e+03_r8,5.1170e+03_r8,4.5267e+03_r8,4.0448e+03_r8,3.6452e+03_r8/)
      kbo(:,58,16) = (/ &
     &6.1353e+03_r8,5.3291e+03_r8,4.6942e+03_r8,4.1832e+03_r8,3.7603e+03_r8/)
      kbo(:,59,16) = (/ &
     &6.2495e+03_r8,5.4200e+03_r8,4.7647e+03_r8,4.2413e+03_r8,3.8086e+03_r8/)

!     The array KAO_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level below 100~ mb.   The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amount ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 
!     to that of gas2.  The second index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The third index 
!     runs over the g-channel (1 to 16).

      kao_mco2( 1, :, 1) = (/ &
     & 7.38630e-06_r8, 8.97432e-06_r8, 1.09037e-05_r8, 1.32480e-05_r8, 1.60963e-05_r8, &
     & 1.95569e-05_r8, 2.37615e-05_r8, 2.88701e-05_r8, 3.50770e-05_r8, 4.26184e-05_r8, &
     & 5.17811e-05_r8, 6.29138e-05_r8, 7.64400e-05_r8, 9.28742e-05_r8, 1.12842e-04_r8, &
     & 1.37102e-04_r8, 1.66578e-04_r8, 2.02392e-04_r8, 2.45905e-04_r8/)
      kao_mco2( 2, :, 1) = (/ &
     & 7.03916e-06_r8, 8.58785e-06_r8, 1.04773e-05_r8, 1.27824e-05_r8, 1.55947e-05_r8, &
     & 1.90257e-05_r8, 2.32115e-05_r8, 2.83183e-05_r8, 3.45487e-05_r8, 4.21498e-05_r8, &
     & 5.14233e-05_r8, 6.27370e-05_r8, 7.65398e-05_r8, 9.33794e-05_r8, 1.13924e-04_r8, &
     & 1.38989e-04_r8, 1.69568e-04_r8, 2.06874e-04_r8, 2.52389e-04_r8/)
      kao_mco2( 3, :, 1) = (/ &
     & 7.80015e-06_r8, 9.48520e-06_r8, 1.15343e-05_r8, 1.40260e-05_r8, 1.70560e-05_r8, &
     & 2.07405e-05_r8, 2.52211e-05_r8, 3.06695e-05_r8, 3.72950e-05_r8, 4.53517e-05_r8, &
     & 5.51489e-05_r8, 6.70626e-05_r8, 8.15499e-05_r8, 9.91670e-05_r8, 1.20590e-04_r8, &
     & 1.46640e-04_r8, 1.78319e-04_r8, 2.16841e-04_r8, 2.63684e-04_r8/)
      kao_mco2( 4, :, 1) = (/ &
     & 9.24267e-06_r8, 1.11747e-05_r8, 1.35105e-05_r8, 1.63346e-05_r8, 1.97490e-05_r8, &
     & 2.38771e-05_r8, 2.88682e-05_r8, 3.49025e-05_r8, 4.21981e-05_r8, 5.10188e-05_r8, &
     & 6.16832e-05_r8, 7.45768e-05_r8, 9.01656e-05_r8, 1.09013e-04_r8, 1.31800e-04_r8, &
     & 1.59350e-04_r8, 1.92659e-04_r8, 2.32930e-04_r8, 2.81619e-04_r8/)
      kao_mco2( 5, :, 1) = (/ &
     & 1.59506e-05_r8, 1.90078e-05_r8, 2.26509e-05_r8, 2.69923e-05_r8, 3.21658e-05_r8, &
     & 3.83309e-05_r8, 4.56777e-05_r8, 5.44325e-05_r8, 6.48654e-05_r8, 7.72978e-05_r8, &
     & 9.21132e-05_r8, 1.09768e-04_r8, 1.30807e-04_r8, 1.55878e-04_r8, 1.85755e-04_r8, &
     & 2.21357e-04_r8, 2.63784e-04_r8, 3.14342e-04_r8, 3.74591e-04_r8/)
      kao_mco2( 6, :, 1) = (/ &
     & 3.53189e-05_r8, 4.14789e-05_r8, 4.87131e-05_r8, 5.72092e-05_r8, 6.71870e-05_r8, &
     & 7.89050e-05_r8, 9.26667e-05_r8, 1.08829e-04_r8, 1.27809e-04_r8, 1.50100e-04_r8, &
     & 1.76279e-04_r8, 2.07024e-04_r8, 2.43131e-04_r8, 2.85535e-04_r8, 3.35335e-04_r8, &
     & 3.93821e-04_r8, 4.62507e-04_r8, 5.43172e-04_r8, 6.37906e-04_r8/)
      kao_mco2( 7, :, 1) = (/ &
     & 6.63273e-05_r8, 7.76356e-05_r8, 9.08718e-05_r8, 1.06365e-04_r8, 1.24499e-04_r8, &
     & 1.45725e-04_r8, 1.70570e-04_r8, 1.99651e-04_r8, 2.33689e-04_r8, 2.73531e-04_r8, &
     & 3.20166e-04_r8, 3.74752e-04_r8, 4.38644e-04_r8, 5.13429e-04_r8, 6.00964e-04_r8, &
     & 7.03424e-04_r8, 8.23352e-04_r8, 9.63726e-04_r8, 1.12803e-03_r8/)
      kao_mco2( 8, :, 1) = (/ &
     & 9.01134e-05_r8, 1.05517e-04_r8, 1.23553e-04_r8, 1.44673e-04_r8, 1.69402e-04_r8, &
     & 1.98359e-04_r8, 2.32265e-04_r8, 2.71967e-04_r8, 3.18456e-04_r8, 3.72890e-04_r8, &
     & 4.36630e-04_r8, 5.11265e-04_r8, 5.98657e-04_r8, 7.00989e-04_r8, 8.20811e-04_r8, &
     & 9.61116e-04_r8, 1.12540e-03_r8, 1.31777e-03_r8, 1.54302e-03_r8/)
      kao_mco2( 9, :, 1) = (/ &
     & 1.14205e-05_r8, 1.36364e-05_r8, 1.62823e-05_r8, 1.94416e-05_r8, 2.32139e-05_r8, &
     & 2.77181e-05_r8, 3.30963e-05_r8, 3.95181e-05_r8, 4.71858e-05_r8, 5.63414e-05_r8, &
     & 6.72734e-05_r8, 8.03266e-05_r8, 9.59124e-05_r8, 1.14523e-04_r8, 1.36743e-04_r8, &
     & 1.63276e-04_r8, 1.94957e-04_r8, 2.32784e-04_r8, 2.77952e-04_r8/)
      kao_mco2( 1, :, 2) = (/ &
     & 2.01754e-05_r8, 2.40506e-05_r8, 2.86701e-05_r8, 3.41769e-05_r8, 4.07414e-05_r8, &
     & 4.85668e-05_r8, 5.78953e-05_r8, 6.90155e-05_r8, 8.22717e-05_r8, 9.80739e-05_r8, &
     & 1.16912e-04_r8, 1.39367e-04_r8, 1.66136e-04_r8, 1.98047e-04_r8, 2.36087e-04_r8, &
     & 2.81433e-04_r8, 3.35489e-04_r8, 3.99928e-04_r8, 4.76744e-04_r8/)
      kao_mco2( 2, :, 2) = (/ &
     & 2.08613e-05_r8, 2.48759e-05_r8, 2.96631e-05_r8, 3.53716e-05_r8, 4.21786e-05_r8, &
     & 5.02955e-05_r8, 5.99746e-05_r8, 7.15163e-05_r8, 8.52791e-05_r8, 1.01690e-04_r8, &
     & 1.21260e-04_r8, 1.44596e-04_r8, 1.72422e-04_r8, 2.05604e-04_r8, 2.45171e-04_r8, &
     & 2.92352e-04_r8, 3.48613e-04_r8, 4.15702e-04_r8, 4.95700e-04_r8/)
      kao_mco2( 3, :, 2) = (/ &
     & 2.06879e-05_r8, 2.47009e-05_r8, 2.94924e-05_r8, 3.52133e-05_r8, 4.20439e-05_r8, &
     & 5.01995e-05_r8, 5.99372e-05_r8, 7.15637e-05_r8, 8.54456e-05_r8, 1.02020e-04_r8, &
     & 1.21810e-04_r8, 1.45439e-04_r8, 1.73651e-04_r8, 2.07335e-04_r8, 2.47554e-04_r8, &
     & 2.95574e-04_r8, 3.52909e-04_r8, 4.21366e-04_r8, 5.03102e-04_r8/)
      kao_mco2( 4, :, 2) = (/ &
     & 2.12700e-05_r8, 2.54064e-05_r8, 3.03472e-05_r8, 3.62490e-05_r8, 4.32984e-05_r8, &
     & 5.17188e-05_r8, 6.17767e-05_r8, 7.37906e-05_r8, 8.81410e-05_r8, 1.05282e-04_r8, &
     & 1.25757e-04_r8, 1.50213e-04_r8, 1.79425e-04_r8, 2.14319e-04_r8, 2.55998e-04_r8, &
     & 3.05782e-04_r8, 3.65249e-04_r8, 4.36280e-04_r8, 5.21125e-04_r8/)
      kao_mco2( 5, :, 2) = (/ &
     & 1.88144e-05_r8, 2.25220e-05_r8, 2.69602e-05_r8, 3.22730e-05_r8, 3.86328e-05_r8, &
     & 4.62458e-05_r8, 5.53591e-05_r8, 6.62682e-05_r8, 7.93271e-05_r8, 9.49594e-05_r8, &
     & 1.13672e-04_r8, 1.36073e-04_r8, 1.62887e-04_r8, 1.94986e-04_r8, 2.33410e-04_r8, &
     & 2.79406e-04_r8, 3.34467e-04_r8, 4.00377e-04_r8, 4.79275e-04_r8/)
      kao_mco2( 6, :, 2) = (/ &
     & 1.20964e-05_r8, 1.46021e-05_r8, 1.76268e-05_r8, 2.12780e-05_r8, 2.56856e-05_r8, &
     & 3.10062e-05_r8, 3.74289e-05_r8, 4.51820e-05_r8, 5.45411e-05_r8, 6.58388e-05_r8, &
     & 7.94769e-05_r8, 9.59399e-05_r8, 1.15813e-04_r8, 1.39803e-04_r8, 1.68762e-04_r8, &
     & 2.03720e-04_r8, 2.45919e-04_r8, 2.96859e-04_r8, 3.58350e-04_r8/)
      kao_mco2( 7, :, 2) = (/ &
     & 3.07117e-05_r8, 3.64441e-05_r8, 4.32465e-05_r8, 5.13186e-05_r8, 6.08974e-05_r8, &
     & 7.22642e-05_r8, 8.57525e-05_r8, 1.01758e-04_r8, 1.20752e-04_r8, 1.43291e-04_r8, &
     & 1.70037e-04_r8, 2.01775e-04_r8, 2.39436e-04_r8, 2.84128e-04_r8, 3.37161e-04_r8, &
     & 4.00094e-04_r8, 4.74773e-04_r8, 5.63391e-04_r8, 6.68549e-04_r8/)
      kao_mco2( 8, :, 2) = (/ &
     & 9.34077e-05_r8, 1.10481e-04_r8, 1.30675e-04_r8, 1.54559e-04_r8, 1.82810e-04_r8, &
     & 2.16224e-04_r8, 2.55745e-04_r8, 3.02491e-04_r8, 3.57780e-04_r8, 4.23175e-04_r8, &
     & 5.00523e-04_r8, 5.92009e-04_r8, 7.00217e-04_r8, 8.28203e-04_r8, 9.79582e-04_r8, &
     & 1.15863e-03_r8, 1.37041e-03_r8, 1.62089e-03_r8, 1.91716e-03_r8/)
      kao_mco2( 9, :, 2) = (/ &
     & 1.15325e-05_r8, 1.37935e-05_r8, 1.64978e-05_r8, 1.97322e-05_r8, 2.36007e-05_r8, &
     & 2.82277e-05_r8, 3.37618e-05_r8, 4.03808e-05_r8, 4.82976e-05_r8, 5.77664e-05_r8, &
     & 6.90916e-05_r8, 8.26372e-05_r8, 9.88384e-05_r8, 1.18216e-04_r8, 1.41392e-04_r8, &
     & 1.69113e-04_r8, 2.02267e-04_r8, 2.41922e-04_r8, 2.89352e-04_r8/)
      kao_mco2( 1, :, 3) = (/ &
     & 2.56142e-05_r8, 3.05385e-05_r8, 3.64096e-05_r8, 4.34093e-05_r8, 5.17547e-05_r8, &
     & 6.17045e-05_r8, 7.35672e-05_r8, 8.77104e-05_r8, 1.04573e-04_r8, 1.24677e-04_r8, &
     & 1.48646e-04_r8, 1.77223e-04_r8, 2.11294e-04_r8, 2.51915e-04_r8, 3.00346e-04_r8, &
     & 3.58087e-04_r8, 4.26929e-04_r8, 5.09006e-04_r8, 6.06862e-04_r8/)
      kao_mco2( 2, :, 3) = (/ &
     & 2.49802e-05_r8, 2.98040e-05_r8, 3.55593e-05_r8, 4.24259e-05_r8, 5.06186e-05_r8, &
     & 6.03932e-05_r8, 7.20554e-05_r8, 8.59696e-05_r8, 1.02571e-04_r8, 1.22377e-04_r8, &
     & 1.46009e-04_r8, 1.74204e-04_r8, 2.07844e-04_r8, 2.47979e-04_r8, 2.95865e-04_r8, &
     & 3.52998e-04_r8, 4.21163e-04_r8, 5.02491e-04_r8, 5.99524e-04_r8/)
      kao_mco2( 3, :, 3) = (/ &
     & 2.54644e-05_r8, 3.03959e-05_r8, 3.62825e-05_r8, 4.33091e-05_r8, 5.16965e-05_r8, &
     & 6.17083e-05_r8, 7.36589e-05_r8, 8.79240e-05_r8, 1.04952e-04_r8, 1.25277e-04_r8, &
     & 1.49539e-04_r8, 1.78499e-04_r8, 2.13068e-04_r8, 2.54331e-04_r8, 3.03586e-04_r8, &
     & 3.62380e-04_r8, 4.32560e-04_r8, 5.16331e-04_r8, 6.16326e-04_r8/)
      kao_mco2( 4, :, 3) = (/ &
     & 2.55054e-05_r8, 3.04699e-05_r8, 3.64007e-05_r8, 4.34859e-05_r8, 5.19501e-05_r8, &
     & 6.20619e-05_r8, 7.41418e-05_r8, 8.85731e-05_r8, 1.05813e-04_r8, 1.26409e-04_r8, &
     & 1.51014e-04_r8, 1.80408e-04_r8, 2.15523e-04_r8, 2.57474e-04_r8, 3.07589e-04_r8, &
     & 3.67459e-04_r8, 4.38983e-04_r8, 5.24428e-04_r8, 6.26505e-04_r8/)
      kao_mco2( 5, :, 3) = (/ &
     & 2.48615e-05_r8, 2.97398e-05_r8, 3.55754e-05_r8, 4.25560e-05_r8, 5.09064e-05_r8, &
     & 6.08952e-05_r8, 7.28441e-05_r8, 8.71375e-05_r8, 1.04236e-04_r8, 1.24689e-04_r8, &
     & 1.49155e-04_r8, 1.78423e-04_r8, 2.13433e-04_r8, 2.55313e-04_r8, 3.05410e-04_r8, &
     & 3.65338e-04_r8, 4.37024e-04_r8, 5.22777e-04_r8, 6.25356e-04_r8/)
      kao_mco2( 6, :, 3) = (/ &
     & 2.09074e-05_r8, 2.50891e-05_r8, 3.01072e-05_r8, 3.61290e-05_r8, 4.33553e-05_r8, &
     & 5.20269e-05_r8, 6.24329e-05_r8, 7.49202e-05_r8, 8.99051e-05_r8, 1.07887e-04_r8, &
     & 1.29466e-04_r8, 1.55361e-04_r8, 1.86435e-04_r8, 2.23724e-04_r8, 2.68471e-04_r8, &
     & 3.22169e-04_r8, 3.86607e-04_r8, 4.63933e-04_r8, 5.56725e-04_r8/)
      kao_mco2( 7, :, 3) = (/ &
     & 1.25163e-05_r8, 1.51688e-05_r8, 1.83835e-05_r8, 2.22795e-05_r8, 2.70011e-05_r8, &
     & 3.27234e-05_r8, 3.96583e-05_r8, 4.80630e-05_r8, 5.82488e-05_r8, 7.05933e-05_r8, &
     & 8.55539e-05_r8, 1.03685e-04_r8, 1.25659e-04_r8, 1.52289e-04_r8, 1.84563e-04_r8, &
     & 2.23677e-04_r8, 2.71081e-04_r8, 3.28530e-04_r8, 3.98154e-04_r8/)
      kao_mco2( 8, :, 3) = (/ &
     & 1.00408e-04_r8, 1.20081e-04_r8, 1.43608e-04_r8, 1.71745e-04_r8, 2.05395e-04_r8, &
     & 2.45637e-04_r8, 2.93765e-04_r8, 3.51322e-04_r8, 4.20156e-04_r8, 5.02476e-04_r8, &
     & 6.00926e-04_r8, 7.18665e-04_r8, 8.59472e-04_r8, 1.02787e-03_r8, 1.22926e-03_r8, &
     & 1.47010e-03_r8, 1.75814e-03_r8, 2.10261e-03_r8, 2.51457e-03_r8/)
      kao_mco2( 9, :, 3) = (/ &
     & 8.50402e-06_r8, 1.02737e-05_r8, 1.24116e-05_r8, 1.49945e-05_r8, 1.81148e-05_r8, &
     & 2.18844e-05_r8, 2.64385e-05_r8, 3.19403e-05_r8, 3.85871e-05_r8, 4.66169e-05_r8, &
     & 5.63178e-05_r8, 6.80375e-05_r8, 8.21959e-05_r8, 9.93008e-05_r8, 1.19965e-04_r8, &
     & 1.44930e-04_r8, 1.75089e-04_r8, 2.11525e-04_r8, 2.55543e-04_r8/)
      kao_mco2( 1, :, 4) = (/ &
     & 2.68659e-05_r8, 3.20986e-05_r8, 3.83506e-05_r8, 4.58203e-05_r8, 5.47450e-05_r8, &
     & 6.54078e-05_r8, 7.81476e-05_r8, 9.33687e-05_r8, 1.11555e-04_r8, 1.33282e-04_r8, &
     & 1.59242e-04_r8, 1.90259e-04_r8, 2.27316e-04_r8, 2.71592e-04_r8, 3.24490e-04_r8, &
     & 3.87693e-04_r8, 4.63206e-04_r8, 5.53426e-04_r8, 6.61218e-04_r8/)
      kao_mco2( 2, :, 4) = (/ &
     & 2.74827e-05_r8, 3.28460e-05_r8, 3.92560e-05_r8, 4.69169e-05_r8, 5.60728e-05_r8, &
     & 6.70155e-05_r8, 8.00937e-05_r8, 9.57241e-05_r8, 1.14405e-04_r8, 1.36731e-04_r8, &
     & 1.63415e-04_r8, 1.95305e-04_r8, 2.33419e-04_r8, 2.78972e-04_r8, 3.33413e-04_r8, &
     & 3.98480e-04_r8, 4.76244e-04_r8, 5.69184e-04_r8, 6.80261e-04_r8/)
      kao_mco2( 3, :, 4) = (/ &
     & 2.84702e-05_r8, 3.40189e-05_r8, 4.06490e-05_r8, 4.85713e-05_r8, 5.80375e-05_r8, &
     & 6.93487e-05_r8, 8.28644e-05_r8, 9.90142e-05_r8, 1.18312e-04_r8, 1.41370e-04_r8, &
     & 1.68922e-04_r8, 2.01844e-04_r8, 2.41182e-04_r8, 2.88188e-04_r8, 3.44354e-04_r8, &
     & 4.11466e-04_r8, 4.91659e-04_r8, 5.87481e-04_r8, 7.01977e-04_r8/)
      kao_mco2( 4, :, 4) = (/ &
     & 2.92293e-05_r8, 3.49243e-05_r8, 4.17289e-05_r8, 4.98593e-05_r8, 5.95738e-05_r8, &
     & 7.11810e-05_r8, 8.50498e-05_r8, 1.01621e-04_r8, 1.21420e-04_r8, 1.45078e-04_r8, &
     & 1.73344e-04_r8, 2.07119e-04_r8, 2.47473e-04_r8, 2.95690e-04_r8, 3.53302e-04_r8, &
     & 4.22139e-04_r8, 5.04388e-04_r8, 6.02662e-04_r8, 7.20083e-04_r8/)
      kao_mco2( 5, :, 4) = (/ &
     & 2.88531e-05_r8, 3.45646e-05_r8, 4.14067e-05_r8, 4.96033e-05_r8, 5.94224e-05_r8, &
     & 7.11851e-05_r8, 8.52764e-05_r8, 1.02157e-04_r8, 1.22379e-04_r8, 1.46604e-04_r8, &
     & 1.75625e-04_r8, 2.10391e-04_r8, 2.52038e-04_r8, 3.01929e-04_r8, 3.61697e-04_r8, &
     & 4.33295e-04_r8, 5.19067e-04_r8, 6.21818e-04_r8, 7.44908e-04_r8/)
      kao_mco2( 6, :, 4) = (/ &
     & 2.79869e-05_r8, 3.36885e-05_r8, 4.05516e-05_r8, 4.88130e-05_r8, 5.87574e-05_r8, &
     & 7.07278e-05_r8, 8.51368e-05_r8, 1.02481e-04_r8, 1.23359e-04_r8, 1.48490e-04_r8, &
     & 1.78742e-04_r8, 2.15156e-04_r8, 2.58988e-04_r8, 3.11751e-04_r8, 3.75262e-04_r8, &
     & 4.51712e-04_r8, 5.43737e-04_r8, 6.54510e-04_r8, 7.87849e-04_r8/)
      kao_mco2( 7, :, 4) = (/ &
     & 1.45797e-05_r8, 1.78204e-05_r8, 2.17815e-05_r8, 2.66230e-05_r8, 3.25407e-05_r8, &
     & 3.97737e-05_r8, 4.86145e-05_r8, 5.94203e-05_r8, 7.26281e-05_r8, 8.87715e-05_r8, &
     & 1.08503e-04_r8, 1.32621e-04_r8, 1.62100e-04_r8, 1.98130e-04_r8, 2.42170e-04_r8, &
     & 2.95999e-04_r8, 3.61792e-04_r8, 4.42210e-04_r8, 5.40503e-04_r8/)
      kao_mco2( 8, :, 4) = (/ &
     & 6.32607e-05_r8, 7.63420e-05_r8, 9.21282e-05_r8, 1.11179e-04_r8, 1.34169e-04_r8, &
     & 1.61913e-04_r8, 1.95393e-04_r8, 2.35797e-04_r8, 2.84557e-04_r8, 3.43398e-04_r8, &
     & 4.14407e-04_r8, 5.00100e-04_r8, 6.03512e-04_r8, 7.28308e-04_r8, 8.78909e-04_r8, &
     & 1.06065e-03_r8, 1.27998e-03_r8, 1.54466e-03_r8, 1.86407e-03_r8/)
      kao_mco2( 9, :, 4) = (/ &
     & 1.52296e-05_r8, 1.84301e-05_r8, 2.23032e-05_r8, 2.69902e-05_r8, 3.26622e-05_r8, &
     & 3.95261e-05_r8, 4.78324e-05_r8, 5.78844e-05_r8, 7.00487e-05_r8, 8.47694e-05_r8, &
     & 1.02584e-04_r8, 1.24142e-04_r8, 1.50230e-04_r8, 1.81800e-04_r8, 2.20005e-04_r8, &
     & 2.66239e-04_r8, 3.22190e-04_r8, 3.89897e-04_r8, 4.71833e-04_r8/)
      kao_mco2( 1, :, 5) = (/ &
     & 3.43213e-05_r8, 4.11301e-05_r8, 4.92896e-05_r8, 5.90679e-05_r8, 7.07860e-05_r8, &
     & 8.48288e-05_r8, 1.01657e-04_r8, 1.21825e-04_r8, 1.45993e-04_r8, 1.74955e-04_r8, &
     & 2.09663e-04_r8, 2.51257e-04_r8, 3.01103e-04_r8, 3.60837e-04_r8, 4.32421e-04_r8, &
     & 5.18206e-04_r8, 6.21010e-04_r8, 7.44208e-04_r8, 8.91846e-04_r8/)
      kao_mco2( 2, :, 5) = (/ &
     & 3.14792e-05_r8, 3.79075e-05_r8, 4.56485e-05_r8, 5.49703e-05_r8, 6.61956e-05_r8, &
     & 7.97133e-05_r8, 9.59914e-05_r8, 1.15594e-04_r8, 1.39199e-04_r8, 1.67624e-04_r8, &
     & 2.01854e-04_r8, 2.43075e-04_r8, 2.92712e-04_r8, 3.52487e-04_r8, 4.24467e-04_r8, &
     & 5.11147e-04_r8, 6.15527e-04_r8, 7.41222e-04_r8, 8.92585e-04_r8/)
      kao_mco2( 3, :, 5) = (/ &
     & 3.21655e-05_r8, 3.87990e-05_r8, 4.68006e-05_r8, 5.64523e-05_r8, 6.80945e-05_r8, &
     & 8.21377e-05_r8, 9.90770e-05_r8, 1.19510e-04_r8, 1.44156e-04_r8, 1.73886e-04_r8, &
     & 2.09746e-04_r8, 2.53002e-04_r8, 3.05179e-04_r8, 3.68117e-04_r8, 4.44033e-04_r8, &
     & 5.35607e-04_r8, 6.46066e-04_r8, 7.79304e-04_r8, 9.40020e-04_r8/)
      kao_mco2( 4, :, 5) = (/ &
     & 3.22870e-05_r8, 3.89864e-05_r8, 4.70759e-05_r8, 5.68439e-05_r8, 6.86388e-05_r8, &
     & 8.28810e-05_r8, 1.00078e-04_r8, 1.20844e-04_r8, 1.45919e-04_r8, 1.76196e-04_r8, &
     & 2.12756e-04_r8, 2.56902e-04_r8, 3.10207e-04_r8, 3.74574e-04_r8, 4.52296e-04_r8, &
     & 5.46146e-04_r8, 6.59468e-04_r8, 7.96304e-04_r8, 9.61533e-04_r8/)
      kao_mco2( 5, :, 5) = (/ &
     & 3.31190e-05_r8, 3.99528e-05_r8, 4.81967e-05_r8, 5.81417e-05_r8, 7.01387e-05_r8, &
     & 8.46111e-05_r8, 1.02070e-04_r8, 1.23131e-04_r8, 1.48538e-04_r8, 1.79187e-04_r8, &
     & 2.16161e-04_r8, 2.60764e-04_r8, 3.14570e-04_r8, 3.79479e-04_r8, 4.57781e-04_r8, &
     & 5.52240e-04_r8, 6.66190e-04_r8, 8.03652e-04_r8, 9.69477e-04_r8/)
      kao_mco2( 6, :, 5) = (/ &
     & 3.31287e-05_r8, 3.99772e-05_r8, 4.82413e-05_r8, 5.82139e-05_r8, 7.02480e-05_r8, &
     & 8.47698e-05_r8, 1.02294e-04_r8, 1.23440e-04_r8, 1.48958e-04_r8, 1.79750e-04_r8, &
     & 2.16909e-04_r8, 2.61749e-04_r8, 3.15858e-04_r8, 3.81153e-04_r8, 4.59945e-04_r8, &
     & 5.55026e-04_r8, 6.69762e-04_r8, 8.08216e-04_r8, 9.75292e-04_r8/)
      kao_mco2( 7, :, 5) = (/ &
     & 3.35235e-05_r8, 4.02832e-05_r8, 4.84061e-05_r8, 5.81668e-05_r8, 6.98958e-05_r8, &
     & 8.39898e-05_r8, 1.00926e-04_r8, 1.21277e-04_r8, 1.45731e-04_r8, 1.75117e-04_r8, &
     & 2.10428e-04_r8, 2.52860e-04_r8, 3.03847e-04_r8, 3.65116e-04_r8, 4.38739e-04_r8, &
     & 5.27208e-04_r8, 6.33516e-04_r8, 7.61260e-04_r8, 9.14762e-04_r8/)
      kao_mco2( 8, :, 5) = (/ &
     & 3.57666e-05_r8, 4.27511e-05_r8, 5.10995e-05_r8, 6.10783e-05_r8, 7.30057e-05_r8, &
     & 8.72622e-05_r8, 1.04303e-04_r8, 1.24671e-04_r8, 1.49017e-04_r8, 1.78117e-04_r8, &
     & 2.12900e-04_r8, 2.54475e-04_r8, 3.04169e-04_r8, 3.63567e-04_r8, 4.34565e-04_r8, &
     & 5.19427e-04_r8, 6.20861e-04_r8, 7.42103e-04_r8, 8.87020e-04_r8/)
      kao_mco2( 9, :, 5) = (/ &
     & 2.96349e-05_r8, 3.55202e-05_r8, 4.25743e-05_r8, 5.10292e-05_r8, 6.11633e-05_r8, &
     & 7.33099e-05_r8, 8.78687e-05_r8, 1.05319e-04_r8, 1.26234e-04_r8, 1.51304e-04_r8, &
     & 1.81352e-04_r8, 2.17367e-04_r8, 2.60534e-04_r8, 3.12275e-04_r8, 3.74290e-04_r8, &
     & 4.48622e-04_r8, 5.37715e-04_r8, 6.44502e-04_r8, 7.72495e-04_r8/)
      kao_mco2( 1, :, 6) = (/ &
     & 4.14659e-05_r8, 4.98693e-05_r8, 5.99757e-05_r8, 7.21302e-05_r8, 8.67479e-05_r8, &
     & 1.04328e-04_r8, 1.25471e-04_r8, 1.50899e-04_r8, 1.81479e-04_r8, 2.18257e-04_r8, &
     & 2.62489e-04_r8, 3.15685e-04_r8, 3.79660e-04_r8, 4.56601e-04_r8, 5.49135e-04_r8, &
     & 6.60422e-04_r8, 7.94261e-04_r8, 9.55224e-04_r8, 1.14881e-03_r8/)
      kao_mco2( 2, :, 6) = (/ &
     & 4.25940e-05_r8, 5.11162e-05_r8, 6.13434e-05_r8, 7.36168e-05_r8, 8.83459e-05_r8, &
     & 1.06022e-04_r8, 1.27235e-04_r8, 1.52691e-04_r8, 1.83241e-04_r8, 2.19904e-04_r8, &
     & 2.63902e-04_r8, 3.16703e-04_r8, 3.80068e-04_r8, 4.56111e-04_r8, 5.47368e-04_r8, &
     & 6.56885e-04_r8, 7.88313e-04_r8, 9.46036e-04_r8, 1.13532e-03_r8/)
      kao_mco2( 3, :, 6) = (/ &
     & 4.44940e-05_r8, 5.32922e-05_r8, 6.38303e-05_r8, 7.64522e-05_r8, 9.15700e-05_r8, &
     & 1.09677e-04_r8, 1.31365e-04_r8, 1.57341e-04_r8, 1.88454e-04_r8, 2.25719e-04_r8, &
     & 2.70353e-04_r8, 3.23813e-04_r8, 3.87844e-04_r8, 4.64537e-04_r8, 5.56395e-04_r8, &
     & 6.66418e-04_r8, 7.98196e-04_r8, 9.56032e-04_r8, 1.14508e-03_r8/)
      kao_mco2( 4, :, 6) = (/ &
     & 4.83402e-05_r8, 5.78065e-05_r8, 6.91265e-05_r8, 8.26633e-05_r8, 9.88510e-05_r8, &
     & 1.18209e-04_r8, 1.41357e-04_r8, 1.69038e-04_r8, 2.02140e-04_r8, 2.41725e-04_r8, &
     & 2.89061e-04_r8, 3.45667e-04_r8, 4.13357e-04_r8, 4.94303e-04_r8, 5.91101e-04_r8, &
     & 7.06854e-04_r8, 8.45275e-04_r8, 1.01080e-03_r8, 1.20874e-03_r8/)
      kao_mco2( 5, :, 6) = (/ &
     & 5.14797e-05_r8, 6.15328e-05_r8, 7.35491e-05_r8, 8.79120e-05_r8, 1.05080e-04_r8, &
     & 1.25600e-04_r8, 1.50128e-04_r8, 1.79445e-04_r8, 2.14487e-04_r8, 2.56373e-04_r8, &
     & 3.06438e-04_r8, 3.66281e-04_r8, 4.37809e-04_r8, 5.23305e-04_r8, 6.25498e-04_r8, &
     & 7.47647e-04_r8, 8.93650e-04_r8, 1.06816e-03_r8, 1.27676e-03_r8/)
      kao_mco2( 6, :, 6) = (/ &
     & 5.71481e-05_r8, 6.83156e-05_r8, 8.16652e-05_r8, 9.76237e-05_r8, 1.16701e-04_r8, &
     & 1.39505e-04_r8, 1.66766e-04_r8, 1.99354e-04_r8, 2.38311e-04_r8, 2.84879e-04_r8, &
     & 3.40548e-04_r8, 4.07096e-04_r8, 4.86647e-04_r8, 5.81744e-04_r8, 6.95424e-04_r8, &
     & 8.31318e-04_r8, 9.93769e-04_r8, 1.18796e-03_r8, 1.42010e-03_r8/)
      kao_mco2( 7, :, 6) = (/ &
     & 5.69513e-05_r8, 6.84420e-05_r8, 8.22512e-05_r8, 9.88466e-05_r8, 1.18790e-04_r8, &
     & 1.42758e-04_r8, 1.71562e-04_r8, 2.06177e-04_r8, 2.47776e-04_r8, 2.97768e-04_r8, &
     & 3.57848e-04_r8, 4.30049e-04_r8, 5.16817e-04_r8, 6.21093e-04_r8, 7.46407e-04_r8, &
     & 8.97006e-04_r8, 1.07799e-03_r8, 1.29549e-03_r8, 1.55687e-03_r8/)
      kao_mco2( 8, :, 6) = (/ &
     & 4.39361e-06_r8, 5.50076e-06_r8, 6.88690e-06_r8, 8.62235e-06_r8, 1.07951e-05_r8, &
     & 1.35154e-05_r8, 1.69212e-05_r8, 2.11851e-05_r8, 2.65236e-05_r8, 3.32074e-05_r8, &
     & 4.15754e-05_r8, 5.20520e-05_r8, 6.51687e-05_r8, 8.15907e-05_r8, 1.02151e-04_r8, &
     & 1.27892e-04_r8, 1.60120e-04_r8, 2.00469e-04_r8, 2.50985e-04_r8/)
      kao_mco2( 9, :, 6) = (/ &
     & 5.75515e-05_r8, 6.86850e-05_r8, 8.19722e-05_r8, 9.78298e-05_r8, 1.16755e-04_r8, &
     & 1.39342e-04_r8, 1.66297e-04_r8, 1.98468e-04_r8, 2.36862e-04_r8, 2.82683e-04_r8, &
     & 3.37369e-04_r8, 4.02633e-04_r8, 4.80523e-04_r8, 5.73481e-04_r8, 6.84422e-04_r8, &
     & 8.16824e-04_r8, 9.74841e-04_r8, 1.16342e-03_r8, 1.38849e-03_r8/)
      kao_mco2( 1, :, 7) = (/ &
     & 6.84544e-05_r8, 8.16461e-05_r8, 9.73799e-05_r8, 1.16146e-04_r8, 1.38528e-04_r8, &
     & 1.65223e-04_r8, 1.97063e-04_r8, 2.35039e-04_r8, 2.80333e-04_r8, 3.34355e-04_r8, &
     & 3.98788e-04_r8, 4.75637e-04_r8, 5.67296e-04_r8, 6.76618e-04_r8, 8.07008e-04_r8, &
     & 9.62525e-04_r8, 1.14801e-03_r8, 1.36924e-03_r8, 1.63310e-03_r8/)
      kao_mco2( 2, :, 7) = (/ &
     & 6.88332e-05_r8, 8.21719e-05_r8, 9.80955e-05_r8, 1.17105e-04_r8, 1.39798e-04_r8, &
     & 1.66888e-04_r8, 1.99229e-04_r8, 2.37836e-04_r8, 2.83925e-04_r8, 3.38944e-04_r8, &
     & 4.04627e-04_r8, 4.83037e-04_r8, 5.76641e-04_r8, 6.88385e-04_r8, 8.21782e-04_r8, &
     & 9.81031e-04_r8, 1.17114e-03_r8, 1.39809e-03_r8, 1.66901e-03_r8/)
      kao_mco2( 3, :, 7) = (/ &
     & 7.49899e-05_r8, 8.94606e-05_r8, 1.06724e-04_r8, 1.27318e-04_r8, 1.51887e-04_r8, &
     & 1.81196e-04_r8, 2.16161e-04_r8, 2.57873e-04_r8, 3.07635e-04_r8, 3.66999e-04_r8, &
     & 4.37818e-04_r8, 5.22304e-04_r8, 6.23092e-04_r8, 7.43330e-04_r8, 8.86769e-04_r8, &
     & 1.05789e-03_r8, 1.26203e-03_r8, 1.50556e-03_r8, 1.79608e-03_r8/)
      kao_mco2( 4, :, 7) = (/ &
     & 8.26801e-05_r8, 9.85802e-05_r8, 1.17538e-04_r8, 1.40141e-04_r8, 1.67092e-04_r8, &
     & 1.99225e-04_r8, 2.37537e-04_r8, 2.83217e-04_r8, 3.37682e-04_r8, 4.02621e-04_r8, &
     & 4.80048e-04_r8, 5.72365e-04_r8, 6.82435e-04_r8, 8.13673e-04_r8, 9.70148e-04_r8, &
     & 1.15671e-03_r8, 1.37916e-03_r8, 1.64438e-03_r8, 1.96061e-03_r8/)
      kao_mco2( 5, :, 7) = (/ &
     & 9.29561e-05_r8, 1.10845e-04_r8, 1.32176e-04_r8, 1.57612e-04_r8, 1.87944e-04_r8, &
     & 2.24112e-04_r8, 2.67241e-04_r8, 3.18669e-04_r8, 3.79995e-04_r8, 4.53121e-04_r8, &
     & 5.40321e-04_r8, 6.44302e-04_r8, 7.68293e-04_r8, 9.16146e-04_r8, 1.09245e-03_r8, &
     & 1.30268e-03_r8, 1.55338e-03_r8, 1.85231e-03_r8, 2.20877e-03_r8/)
      kao_mco2( 6, :, 7) = (/ &
     & 1.09700e-04_r8, 1.30879e-04_r8, 1.56148e-04_r8, 1.86294e-04_r8, 2.22261e-04_r8, &
     & 2.65172e-04_r8, 3.16367e-04_r8, 3.77446e-04_r8, 4.50317e-04_r8, 5.37257e-04_r8, &
     & 6.40983e-04_r8, 7.64734e-04_r8, 9.12376e-04_r8, 1.08852e-03_r8, 1.29868e-03_r8, &
     & 1.54941e-03_r8, 1.84854e-03_r8, 2.20543e-03_r8, 2.63122e-03_r8/)
      kao_mco2( 7, :, 7) = (/ &
     & 1.43457e-04_r8, 1.71554e-04_r8, 2.05153e-04_r8, 2.45332e-04_r8, 2.93381e-04_r8, &
     & 3.50840e-04_r8, 4.19552e-04_r8, 5.01722e-04_r8, 5.99985e-04_r8, 7.17492e-04_r8, &
     & 8.58014e-04_r8, 1.02606e-03_r8, 1.22701e-03_r8, 1.46732e-03_r8, 1.75470e-03_r8, &
     & 2.09836e-03_r8, 2.50933e-03_r8, 3.00078e-03_r8, 3.58849e-03_r8/)
      kao_mco2( 8, :, 7) = (/ &
     & 1.52152e-05_r8, 1.89421e-05_r8, 2.35819e-05_r8, 2.93582e-05_r8, 3.65494e-05_r8, &
     & 4.55021e-05_r8, 5.66476e-05_r8, 7.05233e-05_r8, 8.77978e-05_r8, 1.09304e-04_r8, &
     & 1.36077e-04_r8, 1.69409e-04_r8, 2.10905e-04_r8, 2.62565e-04_r8, 3.26880e-04_r8, &
     & 4.06948e-04_r8, 5.06629e-04_r8, 6.30726e-04_r8, 7.85219e-04_r8/)
      kao_mco2( 9, :, 7) = (/ &
     & 1.15683e-04_r8, 1.37544e-04_r8, 1.63535e-04_r8, 1.94438e-04_r8, 2.31180e-04_r8, &
     & 2.74866e-04_r8, 3.26807e-04_r8, 3.88563e-04_r8, 4.61989e-04_r8, 5.49289e-04_r8, &
     & 6.53088e-04_r8, 7.76501e-04_r8, 9.23234e-04_r8, 1.09770e-03_r8, 1.30512e-03_r8, &
     & 1.55175e-03_r8, 1.84498e-03_r8, 2.19362e-03_r8, 2.60815e-03_r8/)
      kao_mco2( 1, :, 8) = (/ &
     & 1.18154e-04_r8, 1.40516e-04_r8, 1.67111e-04_r8, 1.98739e-04_r8, 2.36353e-04_r8, &
     & 2.81086e-04_r8, 3.34285e-04_r8, 3.97553e-04_r8, 4.72796e-04_r8, 5.62278e-04_r8, &
     & 6.68697e-04_r8, 7.95257e-04_r8, 9.45770e-04_r8, 1.12477e-03_r8, 1.33765e-03_r8, &
     & 1.59081e-03_r8, 1.89190e-03_r8, 2.24996e-03_r8, 2.67580e-03_r8/)
      kao_mco2( 2, :, 8) = (/ &
     & 1.40874e-04_r8, 1.67009e-04_r8, 1.97993e-04_r8, 2.34726e-04_r8, 2.78273e-04_r8, &
     & 3.29899e-04_r8, 3.91102e-04_r8, 4.63661e-04_r8, 5.49680e-04_r8, 6.51659e-04_r8, &
     & 7.72556e-04_r8, 9.15884e-04_r8, 1.08580e-03_r8, 1.28724e-03_r8, 1.52605e-03_r8, &
     & 1.80917e-03_r8, 2.14482e-03_r8, 2.54273e-03_r8, 3.01446e-03_r8/)
      kao_mco2( 3, :, 8) = (/ &
     & 1.55092e-04_r8, 1.84132e-04_r8, 2.18609e-04_r8, 2.59542e-04_r8, 3.08140e-04_r8, &
     & 3.65837e-04_r8, 4.34337e-04_r8, 5.15664e-04_r8, 6.12219e-04_r8, 7.26853e-04_r8, &
     & 8.62952e-04_r8, 1.02453e-03_r8, 1.21637e-03_r8, 1.44413e-03_r8, 1.71453e-03_r8, &
     & 2.03557e-03_r8, 2.41671e-03_r8, 2.86923e-03_r8, 3.40647e-03_r8/)
      kao_mco2( 4, :, 8) = (/ &
     & 1.80666e-04_r8, 2.14521e-04_r8, 2.54721e-04_r8, 3.02454e-04_r8, 3.59131e-04_r8, &
     & 4.26429e-04_r8, 5.06339e-04_r8, 6.01223e-04_r8, 7.13887e-04_r8, 8.47663e-04_r8, &
     & 1.00651e-03_r8, 1.19512e-03_r8, 1.41908e-03_r8, 1.68500e-03_r8, 2.00076e-03_r8, &
     & 2.37568e-03_r8, 2.82087e-03_r8, 3.34947e-03_r8, 3.97714e-03_r8/)
      kao_mco2( 5, :, 8) = (/ &
     & 2.21554e-04_r8, 2.63265e-04_r8, 3.12829e-04_r8, 3.71724e-04_r8, 4.41707e-04_r8, &
     & 5.24865e-04_r8, 6.23679e-04_r8, 7.41096e-04_r8, 8.80619e-04_r8, 1.04641e-03_r8, &
     & 1.24341e-03_r8, 1.47750e-03_r8, 1.75567e-03_r8, 2.08620e-03_r8, 2.47896e-03_r8, &
     & 2.94566e-03_r8, 3.50023e-03_r8, 4.15920e-03_r8, 4.94224e-03_r8/)
      kao_mco2( 6, :, 8) = (/ &
     & 2.78997e-04_r8, 3.32548e-04_r8, 3.96378e-04_r8, 4.72460e-04_r8, 5.63146e-04_r8, &
     & 6.71238e-04_r8, 8.00077e-04_r8, 9.53647e-04_r8, 1.13669e-03_r8, 1.35487e-03_r8, &
     & 1.61493e-03_r8, 1.92491e-03_r8, 2.29438e-03_r8, 2.73477e-03_r8, 3.25969e-03_r8, &
     & 3.88537e-03_r8, 4.63114e-03_r8, 5.52005e-03_r8, 6.57958e-03_r8/)
      kao_mco2( 7, :, 8) = (/ &
     & 2.84939e-04_r8, 3.40606e-04_r8, 4.07149e-04_r8, 4.86691e-04_r8, 5.81774e-04_r8, &
     & 6.95432e-04_r8, 8.31295e-04_r8, 9.93700e-04_r8, 1.18783e-03_r8, 1.41989e-03_r8, &
     & 1.69729e-03_r8, 2.02888e-03_r8, 2.42526e-03_r8, 2.89907e-03_r8, 3.46544e-03_r8, &
     & 4.14246e-03_r8, 4.95176e-03_r8, 5.91915e-03_r8, 7.07554e-03_r8/)
      kao_mco2( 8, :, 8) = (/ &
     & 5.30764e-05_r8, 6.47812e-05_r8, 7.90673e-05_r8, 9.65039e-05_r8, 1.17786e-04_r8, &
     & 1.43761e-04_r8, 1.75464e-04_r8, 2.14159e-04_r8, 2.61387e-04_r8, 3.19030e-04_r8, &
     & 3.89385e-04_r8, 4.75255e-04_r8, 5.80062e-04_r8, 7.07982e-04_r8, 8.64111e-04_r8, &
     & 1.05467e-03_r8, 1.28726e-03_r8, 1.57113e-03_r8, 1.91761e-03_r8/)
      kao_mco2( 9, :, 8) = (/ &
     & 2.76806e-04_r8, 3.29639e-04_r8, 3.92556e-04_r8, 4.67481e-04_r8, 5.56708e-04_r8, &
     & 6.62964e-04_r8, 7.89501e-04_r8, 9.40190e-04_r8, 1.11964e-03_r8, 1.33334e-03_r8, &
     & 1.58783e-03_r8, 1.89089e-03_r8, 2.25180e-03_r8, 2.68159e-03_r8, 3.19341e-03_r8, &
     & 3.80293e-03_r8, 4.52878e-03_r8, 5.39316e-03_r8, 6.42253e-03_r8/)
      kao_mco2( 1, :, 9) = (/ &
     & 3.30614e-04_r8, 3.93289e-04_r8, 4.67844e-04_r8, 5.56534e-04_r8, 6.62036e-04_r8, &
     & 7.87539e-04_r8, 9.36833e-04_r8, 1.11443e-03_r8, 1.32569e-03_r8, 1.57700e-03_r8, &
     & 1.87596e-03_r8, 2.23158e-03_r8, 2.65463e-03_r8, 3.15787e-03_r8, 3.75650e-03_r8, &
     & 4.46862e-03_r8, 5.31575e-03_r8, 6.32345e-03_r8, 7.52219e-03_r8/)
      kao_mco2( 2, :, 9) = (/ &
     & 3.78453e-04_r8, 4.50735e-04_r8, 5.36824e-04_r8, 6.39355e-04_r8, 7.61469e-04_r8, &
     & 9.06906e-04_r8, 1.08012e-03_r8, 1.28642e-03_r8, 1.53212e-03_r8, 1.82475e-03_r8, &
     & 2.17326e-03_r8, 2.58835e-03_r8, 3.08271e-03_r8, 3.67149e-03_r8, 4.37273e-03_r8, &
     & 5.20790e-03_r8, 6.20259e-03_r8, 7.38725e-03_r8, 8.79818e-03_r8/)
      kao_mco2( 3, :, 9) = (/ &
     & 4.57576e-04_r8, 5.45512e-04_r8, 6.50348e-04_r8, 7.75330e-04_r8, 9.24332e-04_r8, &
     & 1.10197e-03_r8, 1.31374e-03_r8, 1.56621e-03_r8, 1.86721e-03_r8, 2.22604e-03_r8, &
     & 2.65384e-03_r8, 3.16385e-03_r8, 3.77187e-03_r8, 4.49675e-03_r8, 5.36092e-03_r8, &
     & 6.39117e-03_r8, 7.61942e-03_r8, 9.08370e-03_r8, 1.08294e-02_r8/)
      kao_mco2( 4, :, 9) = (/ &
     & 5.18277e-04_r8, 6.18764e-04_r8, 7.38735e-04_r8, 8.81967e-04_r8, 1.05297e-03_r8, &
     & 1.25713e-03_r8, 1.50087e-03_r8, 1.79187e-03_r8, 2.13929e-03_r8, 2.55407e-03_r8, &
     & 3.04928e-03_r8, 3.64050e-03_r8, 4.34635e-03_r8, 5.18905e-03_r8, 6.19514e-03_r8, &
     & 7.39631e-03_r8, 8.83036e-03_r8, 1.05425e-02_r8, 1.25865e-02_r8/)
      kao_mco2( 5, :, 9) = (/ &
     & 4.45365e-04_r8, 5.32106e-04_r8, 6.35742e-04_r8, 7.59563e-04_r8, 9.07500e-04_r8, &
     & 1.08425e-03_r8, 1.29542e-03_r8, 1.54773e-03_r8, 1.84917e-03_r8, 2.20933e-03_r8, &
     & 2.63963e-03_r8, 3.15374e-03_r8, 3.76797e-03_r8, 4.50184e-03_r8, 5.37865e-03_r8, &
     & 6.42622e-03_r8, 7.67783e-03_r8, 9.17320e-03_r8, 1.09598e-02_r8/)
      kao_mco2( 6, :, 9) = (/ &
     & 2.87301e-04_r8, 3.43009e-04_r8, 4.09519e-04_r8, 4.88926e-04_r8, 5.83730e-04_r8, &
     & 6.96916e-04_r8, 8.32050e-04_r8, 9.93386e-04_r8, 1.18601e-03_r8, 1.41597e-03_r8, &
     & 1.69053e-03_r8, 2.01833e-03_r8, 2.40969e-03_r8, 2.87693e-03_r8, 3.43478e-03_r8, &
     & 4.10079e-03_r8, 4.89594e-03_r8, 5.84527e-03_r8, 6.97867e-03_r8/)
      kao_mco2( 7, :, 9) = (/ &
     & 1.10743e-04_r8, 1.32286e-04_r8, 1.58020e-04_r8, 1.88760e-04_r8, 2.25480e-04_r8, &
     & 2.69342e-04_r8, 3.21738e-04_r8, 3.84326e-04_r8, 4.59090e-04_r8, 5.48397e-04_r8, &
     & 6.55078e-04_r8, 7.82511e-04_r8, 9.34734e-04_r8, 1.11657e-03_r8, 1.33378e-03_r8, &
     & 1.59324e-03_r8, 1.90318e-03_r8, 2.27340e-03_r8, 2.71565e-03_r8/)
      kao_mco2( 8, :, 9) = (/ &
     & 8.63177e-05_r8, 1.03067e-04_r8, 1.23066e-04_r8, 1.46946e-04_r8, 1.75459e-04_r8, &
     & 2.09505e-04_r8, 2.50158e-04_r8, 2.98698e-04_r8, 3.56658e-04_r8, 4.25864e-04_r8, &
     & 5.08498e-04_r8, 6.07168e-04_r8, 7.24982e-04_r8, 8.65658e-04_r8, 1.03363e-03_r8, &
     & 1.23420e-03_r8, 1.47368e-03_r8, 1.75963e-03_r8, 2.10107e-03_r8/)
      kao_mco2( 9, :, 9) = (/ &
     & 4.52715e-04_r8, 5.41540e-04_r8, 6.47792e-04_r8, 7.74892e-04_r8, 9.26929e-04_r8, &
     & 1.10880e-03_r8, 1.32635e-03_r8, 1.58658e-03_r8, 1.89787e-03_r8, 2.27024e-03_r8, &
     & 2.71568e-03_r8, 3.24850e-03_r8, 3.88587e-03_r8, 4.64830e-03_r8, 5.56031e-03_r8, &
     & 6.65127e-03_r8, 7.95627e-03_r8, 9.51732e-03_r8, 1.13847e-02_r8/)
      kao_mco2( 1, :,10) = (/ &
     & 9.10418e-04_r8, 1.08631e-03_r8, 1.29619e-03_r8, 1.54662e-03_r8, 1.84543e-03_r8, &
     & 2.20198e-03_r8, 2.62741e-03_r8, 3.13503e-03_r8, 3.74073e-03_r8, 4.46344e-03_r8, &
     & 5.32580e-03_r8, 6.35476e-03_r8, 7.58251e-03_r8, 9.04748e-03_r8, 1.07955e-02_r8, &
     & 1.28812e-02_r8, 1.53699e-02_r8, 1.83394e-02_r8, 2.18826e-02_r8/)
      kao_mco2( 2, :,10) = (/ &
     & 9.06680e-04_r8, 1.08622e-03_r8, 1.30130e-03_r8, 1.55898e-03_r8, 1.86768e-03_r8, &
     & 2.23750e-03_r8, 2.68056e-03_r8, 3.21135e-03_r8, 3.84724e-03_r8, 4.60905e-03_r8, &
     & 5.52171e-03_r8, 6.61508e-03_r8, 7.92496e-03_r8, 9.49421e-03_r8, 1.13742e-02_r8, &
     & 1.36265e-02_r8, 1.63247e-02_r8, 1.95572e-02_r8, 2.34298e-02_r8/)
      kao_mco2( 3, :,10) = (/ &
     & 8.17976e-04_r8, 9.79458e-04_r8, 1.17282e-03_r8, 1.40435e-03_r8, 1.68160e-03_r8, &
     & 2.01357e-03_r8, 2.41108e-03_r8, 2.88707e-03_r8, 3.45703e-03_r8, 4.13950e-03_r8, &
     & 4.95671e-03_r8, 5.93525e-03_r8, 7.10696e-03_r8, 8.51000e-03_r8, 1.01900e-02_r8, &
     & 1.22017e-02_r8, 1.46105e-02_r8, 1.74949e-02_r8, 2.09486e-02_r8/)
      kao_mco2( 4, :,10) = (/ &
     & 3.70314e-04_r8, 4.41440e-04_r8, 5.26226e-04_r8, 6.27298e-04_r8, 7.47782e-04_r8, &
     & 8.91407e-04_r8, 1.06262e-03_r8, 1.26671e-03_r8, 1.51001e-03_r8, 1.80003e-03_r8, &
     & 2.14576e-03_r8, 2.55789e-03_r8, 3.04918e-03_r8, 3.63483e-03_r8, 4.33297e-03_r8, &
     & 5.16520e-03_r8, 6.15727e-03_r8, 7.33988e-03_r8, 8.74963e-03_r8/)
      kao_mco2( 5, :,10) = (/ &
     & 1.00859e-04_r8, 1.19692e-04_r8, 1.42041e-04_r8, 1.68563e-04_r8, 2.00038e-04_r8, &
     & 2.37389e-04_r8, 2.81715e-04_r8, 3.34318e-04_r8, 3.96742e-04_r8, 4.70823e-04_r8, &
     & 5.58736e-04_r8, 6.63065e-04_r8, 7.86874e-04_r8, 9.33801e-04_r8, 1.10816e-03_r8, &
     & 1.31508e-03_r8, 1.56064e-03_r8, 1.85204e-03_r8, 2.19786e-03_r8/)
      kao_mco2( 6, :,10) = (/ &
     & 9.24477e-05_r8, 1.09659e-04_r8, 1.30074e-04_r8, 1.54290e-04_r8, 1.83015e-04_r8, &
     & 2.17087e-04_r8, 2.57503e-04_r8, 3.05442e-04_r8, 3.62307e-04_r8, 4.29759e-04_r8, &
     & 5.09768e-04_r8, 6.04672e-04_r8, 7.17245e-04_r8, 8.50776e-04_r8, 1.00917e-03_r8, &
     & 1.19704e-03_r8, 1.41990e-03_r8, 1.68425e-03_r8, 1.99780e-03_r8/)
      kao_mco2( 7, :,10) = (/ &
     & 8.42943e-05_r8, 1.00044e-04_r8, 1.18735e-04_r8, 1.40919e-04_r8, 1.67248e-04_r8, &
     & 1.98496e-04_r8, 2.35582e-04_r8, 2.79597e-04_r8, 3.31836e-04_r8, 3.93835e-04_r8, &
     & 4.67418e-04_r8, 5.54748e-04_r8, 6.58395e-04_r8, 7.81407e-04_r8, 9.27402e-04_r8, &
     & 1.10067e-03_r8, 1.30632e-03_r8, 1.55039e-03_r8, 1.84005e-03_r8/)
      kao_mco2( 8, :,10) = (/ &
     & 6.86464e-05_r8, 8.18163e-05_r8, 9.75129e-05_r8, 1.16221e-04_r8, 1.38518e-04_r8, &
     & 1.65093e-04_r8, 1.96767e-04_r8, 2.34517e-04_r8, 2.79509e-04_r8, 3.33133e-04_r8, &
     & 3.97046e-04_r8, 4.73220e-04_r8, 5.64008e-04_r8, 6.72214e-04_r8, 8.01179e-04_r8, &
     & 9.54887e-04_r8, 1.13808e-03_r8, 1.35643e-03_r8, 1.61666e-03_r8/)
      kao_mco2( 9, :,10) = (/ &
     & 1.03095e-04_r8, 1.21985e-04_r8, 1.44335e-04_r8, 1.70781e-04_r8, 2.02072e-04_r8, &
     & 2.39096e-04_r8, 2.82904e-04_r8, 3.34739e-04_r8, 3.96070e-04_r8, 4.68639e-04_r8, &
     & 5.54505e-04_r8, 6.56103e-04_r8, 7.76316e-04_r8, 9.18556e-04_r8, 1.08686e-03_r8, &
     & 1.28599e-03_r8, 1.52162e-03_r8, 1.80041e-03_r8, 2.13029e-03_r8/)
      kao_mco2( 1, :,11) = (/ &
     & 1.01275e-03_r8, 1.21433e-03_r8, 1.45605e-03_r8, 1.74587e-03_r8, 2.09339e-03_r8, &
     & 2.51007e-03_r8, 3.00970e-03_r8, 3.60878e-03_r8, 4.32711e-03_r8, 5.18842e-03_r8, &
     & 6.22117e-03_r8, 7.45950e-03_r8, 8.94430e-03_r8, 1.07247e-02_r8, 1.28594e-02_r8, &
     & 1.54191e-02_r8, 1.84882e-02_r8, 2.21683e-02_r8, 2.65809e-02_r8/)
      kao_mco2( 2, :,11) = (/ &
     & 1.06856e-03_r8, 1.27885e-03_r8, 1.53052e-03_r8, 1.83171e-03_r8, 2.19218e-03_r8, &
     & 2.62359e-03_r8, 3.13990e-03_r8, 3.75781e-03_r8, 4.49732e-03_r8, 5.38236e-03_r8, &
     & 6.44158e-03_r8, 7.70924e-03_r8, 9.22637e-03_r8, 1.10421e-02_r8, 1.32151e-02_r8, &
     & 1.58157e-02_r8, 1.89281e-02_r8, 2.26531e-02_r8, 2.71110e-02_r8/)
      kao_mco2( 3, :,11) = (/ &
     & 7.34896e-04_r8, 8.77863e-04_r8, 1.04864e-03_r8, 1.25265e-03_r8, 1.49634e-03_r8, &
     & 1.78744e-03_r8, 2.13516e-03_r8, 2.55054e-03_r8, 3.04672e-03_r8, 3.63943e-03_r8, &
     & 4.34745e-03_r8, 5.19321e-03_r8, 6.20349e-03_r8, 7.41032e-03_r8, 8.85192e-03_r8, &
     & 1.05740e-02_r8, 1.26311e-02_r8, 1.50883e-02_r8, 1.80236e-02_r8/)
      kao_mco2( 4, :,11) = (/ &
     & 5.89491e-05_r8, 7.12560e-05_r8, 8.61322e-05_r8, 1.04114e-04_r8, 1.25850e-04_r8, &
     & 1.52124e-04_r8, 1.83883e-04_r8, 2.22272e-04_r8, 2.68676e-04_r8, 3.24768e-04_r8, &
     & 3.92571e-04_r8, 4.74528e-04_r8, 5.73595e-04_r8, 6.93346e-04_r8, 8.38096e-04_r8, &
     & 1.01307e-03_r8, 1.22457e-03_r8, 1.48022e-03_r8, 1.78924e-03_r8/)
      kao_mco2( 5, :,11) = (/ &
     & 5.32400e-05_r8, 6.45465e-05_r8, 7.82542e-05_r8, 9.48731e-05_r8, 1.15021e-04_r8, &
     & 1.39448e-04_r8, 1.69063e-04_r8, 2.04966e-04_r8, 2.48495e-04_r8, 3.01268e-04_r8, &
     & 3.65248e-04_r8, 4.42816e-04_r8, 5.36856e-04_r8, 6.50868e-04_r8, 7.89092e-04_r8, &
     & 9.56672e-04_r8, 1.15984e-03_r8, 1.40615e-03_r8, 1.70478e-03_r8/)
      kao_mco2( 6, :,11) = (/ &
     & 5.31408e-05_r8, 6.42409e-05_r8, 7.76597e-05_r8, 9.38814e-05_r8, 1.13491e-04_r8, &
     & 1.37198e-04_r8, 1.65856e-04_r8, 2.00500e-04_r8, 2.42381e-04_r8, 2.93010e-04_r8, &
     & 3.54214e-04_r8, 4.28203e-04_r8, 5.17647e-04_r8, 6.25774e-04_r8, 7.56486e-04_r8, &
     & 9.14503e-04_r8, 1.10553e-03_r8, 1.33645e-03_r8, 1.61561e-03_r8/)
      kao_mco2( 7, :,11) = (/ &
     & 5.24517e-05_r8, 6.32485e-05_r8, 7.62676e-05_r8, 9.19667e-05_r8, 1.10897e-04_r8, &
     & 1.33725e-04_r8, 1.61251e-04_r8, 1.94443e-04_r8, 2.34467e-04_r8, 2.82730e-04_r8, &
     & 3.40928e-04_r8, 4.11106e-04_r8, 4.95728e-04_r8, 5.97770e-04_r8, 7.20816e-04_r8, &
     & 8.69190e-04_r8, 1.04811e-03_r8, 1.26385e-03_r8, 1.52400e-03_r8/)
      kao_mco2( 8, :,11) = (/ &
     & 5.01768e-05_r8, 6.02217e-05_r8, 7.22774e-05_r8, 8.67466e-05_r8, 1.04112e-04_r8, &
     & 1.24955e-04_r8, 1.49969e-04_r8, 1.79991e-04_r8, 2.16024e-04_r8, 2.59270e-04_r8, &
     & 3.11173e-04_r8, 3.73467e-04_r8, 4.48231e-04_r8, 5.37962e-04_r8, 6.45656e-04_r8, &
     & 7.74910e-04_r8, 9.30039e-04_r8, 1.11622e-03_r8, 1.33968e-03_r8/)
      kao_mco2( 9, :,11) = (/ &
     & 5.46391e-05_r8, 6.58765e-05_r8, 7.94252e-05_r8, 9.57603e-05_r8, 1.15455e-04_r8, &
     & 1.39200e-04_r8, 1.67829e-04_r8, 2.02346e-04_r8, 2.43962e-04_r8, 2.94137e-04_r8, &
     & 3.54632e-04_r8, 4.27568e-04_r8, 5.15504e-04_r8, 6.21526e-04_r8, 7.49353e-04_r8, &
     & 9.03471e-04_r8, 1.08929e-03_r8, 1.31331e-03_r8, 1.58342e-03_r8/)
      kao_mco2( 1, :,12) = (/ &
     & 1.18469e-03_r8, 1.41755e-03_r8, 1.69619e-03_r8, 2.02959e-03_r8, 2.42854e-03_r8, &
     & 2.90589e-03_r8, 3.47708e-03_r8, 4.16055e-03_r8, 4.97836e-03_r8, 5.95691e-03_r8, &
     & 7.12782e-03_r8, 8.52889e-03_r8, 1.02053e-02_r8, 1.22113e-02_r8, 1.46116e-02_r8, &
     & 1.74837e-02_r8, 2.09204e-02_r8, 2.50325e-02_r8, 2.99530e-02_r8/)
      kao_mco2( 2, :,12) = (/ &
     & 1.09092e-03_r8, 1.30288e-03_r8, 1.55602e-03_r8, 1.85834e-03_r8, 2.21940e-03_r8, &
     & 2.65061e-03_r8, 3.16560e-03_r8, 3.78064e-03_r8, 4.51519e-03_r8, 5.39245e-03_r8, &
     & 6.44016e-03_r8, 7.69143e-03_r8, 9.18580e-03_r8, 1.09705e-02_r8, 1.31020e-02_r8, &
     & 1.56476e-02_r8, 1.86878e-02_r8, 2.23187e-02_r8, 2.66550e-02_r8/)
      kao_mco2( 3, :,12) = (/ &
     & 3.97521e-04_r8, 4.74103e-04_r8, 5.65438e-04_r8, 6.74369e-04_r8, 8.04285e-04_r8, &
     & 9.59228e-04_r8, 1.14402e-03_r8, 1.36442e-03_r8, 1.62727e-03_r8, 1.94076e-03_r8, &
     & 2.31464e-03_r8, 2.76055e-03_r8, 3.29237e-03_r8, 3.92663e-03_r8, 4.68309e-03_r8, &
     & 5.58528e-03_r8, 6.66128e-03_r8, 7.94456e-03_r8, 9.47505e-03_r8/)
      kao_mco2( 4, :,12) = (/ &
     & 7.18557e-05_r8, 8.56230e-05_r8, 1.02028e-04_r8, 1.21576e-04_r8, 1.44870e-04_r8, &
     & 1.72626e-04_r8, 2.05701e-04_r8, 2.45112e-04_r8, 2.92075e-04_r8, 3.48035e-04_r8, &
     & 4.14718e-04_r8, 4.94176e-04_r8, 5.88858e-04_r8, 7.01682e-04_r8, 8.36121e-04_r8, &
     & 9.96319e-04_r8, 1.18721e-03_r8, 1.41467e-03_r8, 1.68572e-03_r8/)
      kao_mco2( 5, :,12) = (/ &
     & 7.33026e-05_r8, 8.69077e-05_r8, 1.03038e-04_r8, 1.22162e-04_r8, 1.44836e-04_r8, &
     & 1.71717e-04_r8, 2.03588e-04_r8, 2.41375e-04_r8, 2.86175e-04_r8, 3.39289e-04_r8, &
     & 4.02262e-04_r8, 4.76923e-04_r8, 5.65440e-04_r8, 6.70387e-04_r8, 7.94812e-04_r8, &
     & 9.42331e-04_r8, 1.11723e-03_r8, 1.32459e-03_r8, 1.57044e-03_r8/)
      kao_mco2( 6, :,12) = (/ &
     & 7.44053e-05_r8, 8.82167e-05_r8, 1.04592e-04_r8, 1.24007e-04_r8, 1.47025e-04_r8, &
     & 1.74317e-04_r8, 2.06674e-04_r8, 2.45038e-04_r8, 2.90523e-04_r8, 3.44451e-04_r8, &
     & 4.08389e-04_r8, 4.84196e-04_r8, 5.74074e-04_r8, 6.80637e-04_r8, 8.06979e-04_r8, &
     & 9.56774e-04_r8, 1.13437e-03_r8, 1.34494e-03_r8, 1.59459e-03_r8/)
      kao_mco2( 7, :,12) = (/ &
     & 7.68762e-05_r8, 9.11305e-05_r8, 1.08028e-04_r8, 1.28058e-04_r8, 1.51802e-04_r8, &
     & 1.79949e-04_r8, 2.13315e-04_r8, 2.52868e-04_r8, 2.99754e-04_r8, 3.55334e-04_r8, &
     & 4.21220e-04_r8, 4.99322e-04_r8, 5.91905e-04_r8, 7.01656e-04_r8, 8.31756e-04_r8, &
     & 9.85979e-04_r8, 1.16880e-03_r8, 1.38551e-03_r8, 1.64241e-03_r8/)
      kao_mco2( 8, :,12) = (/ &
     & 8.45996e-05_r8, 1.00214e-04_r8, 1.18711e-04_r8, 1.40622e-04_r8, 1.66577e-04_r8, &
     & 1.97323e-04_r8, 2.33743e-04_r8, 2.76885e-04_r8, 3.27991e-04_r8, 3.88529e-04_r8, &
     & 4.60241e-04_r8, 5.45189e-04_r8, 6.45816e-04_r8, 7.65016e-04_r8, 9.06216e-04_r8, &
     & 1.07348e-03_r8, 1.27161e-03_r8, 1.50632e-03_r8, 1.78434e-03_r8/)
      kao_mco2( 9, :,12) = (/ &
     & 7.73583e-05_r8, 9.16767e-05_r8, 1.08645e-04_r8, 1.28755e-04_r8, 1.52586e-04_r8, &
     & 1.80829e-04_r8, 2.14299e-04_r8, 2.53964e-04_r8, 3.00970e-04_r8, 3.56678e-04_r8, &
     & 4.22696e-04_r8, 5.00934e-04_r8, 5.93652e-04_r8, 7.03533e-04_r8, 8.33751e-04_r8, &
     & 9.88072e-04_r8, 1.17096e-03_r8, 1.38769e-03_r8, 1.64454e-03_r8/)
      kao_mco2( 1, :,13) = (/ &
     & 1.20952e-03_r8, 1.44504e-03_r8, 1.72642e-03_r8, 2.06260e-03_r8, 2.46423e-03_r8, &
     & 2.94407e-03_r8, 3.51735e-03_r8, 4.20226e-03_r8, 5.02053e-03_r8, 5.99814e-03_r8, &
     & 7.16612e-03_r8, 8.56153e-03_r8, 1.02287e-02_r8, 1.22204e-02_r8, 1.46000e-02_r8, &
     & 1.74430e-02_r8, 2.08395e-02_r8, 2.48974e-02_r8, 2.97455e-02_r8/)
      kao_mco2( 2, :,13) = (/ &
     & 8.47667e-04_r8, 1.01027e-03_r8, 1.20407e-03_r8, 1.43505e-03_r8, 1.71034e-03_r8, &
     & 2.03843e-03_r8, 2.42946e-03_r8, 2.89550e-03_r8, 3.45094e-03_r8, 4.11293e-03_r8, &
     & 4.90192e-03_r8, 5.84225e-03_r8, 6.96296e-03_r8, 8.29866e-03_r8, 9.89058e-03_r8, &
     & 1.17879e-02_r8, 1.40492e-02_r8, 1.67442e-02_r8, 1.99562e-02_r8/)
      kao_mco2( 3, :,13) = (/ &
     & 1.45612e-04_r8, 1.71739e-04_r8, 2.02554e-04_r8, 2.38897e-04_r8, 2.81762e-04_r8, &
     & 3.32318e-04_r8, 3.91945e-04_r8, 4.62271e-04_r8, 5.45215e-04_r8, 6.43041e-04_r8, &
     & 7.58421e-04_r8, 8.94503e-04_r8, 1.05500e-03_r8, 1.24430e-03_r8, 1.46756e-03_r8, &
     & 1.73088e-03_r8, 2.04145e-03_r8, 2.40774e-03_r8, 2.83975e-03_r8/)
      kao_mco2( 4, :,13) = (/ &
     & 1.40167e-04_r8, 1.65266e-04_r8, 1.94858e-04_r8, 2.29750e-04_r8, 2.70889e-04_r8, &
     & 3.19394e-04_r8, 3.76585e-04_r8, 4.44016e-04_r8, 5.23522e-04_r8, 6.17264e-04_r8, &
     & 7.27791e-04_r8, 8.58110e-04_r8, 1.01176e-03_r8, 1.19293e-03_r8, 1.40654e-03_r8, &
     & 1.65839e-03_r8, 1.95534e-03_r8, 2.30547e-03_r8, 2.71828e-03_r8/)
      kao_mco2( 5, :,13) = (/ &
     & 1.37406e-04_r8, 1.61990e-04_r8, 1.90973e-04_r8, 2.25141e-04_r8, 2.65423e-04_r8, &
     & 3.12911e-04_r8, 3.68896e-04_r8, 4.34898e-04_r8, 5.12709e-04_r8, 6.04442e-04_r8, &
     & 7.12587e-04_r8, 8.40082e-04_r8, 9.90387e-04_r8, 1.16758e-03_r8, 1.37648e-03_r8, &
     & 1.62276e-03_r8, 1.91310e-03_r8, 2.25539e-03_r8, 2.65892e-03_r8/)
      kao_mco2( 6, :,13) = (/ &
     & 1.35356e-04_r8, 1.59577e-04_r8, 1.88132e-04_r8, 2.21797e-04_r8, 2.61485e-04_r8, &
     & 3.08276e-04_r8, 3.63440e-04_r8, 4.28475e-04_r8, 5.05147e-04_r8, 5.95539e-04_r8, &
     & 7.02106e-04_r8, 8.27743e-04_r8, 9.75861e-04_r8, 1.15048e-03_r8, 1.35635e-03_r8, &
     & 1.59906e-03_r8, 1.88520e-03_r8, 2.22255e-03_r8, 2.62025e-03_r8/)
      kao_mco2( 7, :,13) = (/ &
     & 1.33359e-04_r8, 1.57252e-04_r8, 1.85424e-04_r8, 2.18645e-04_r8, 2.57817e-04_r8, &
     & 3.04007e-04_r8, 3.58472e-04_r8, 4.22695e-04_r8, 4.98425e-04_r8, 5.87722e-04_r8, &
     & 6.93017e-04_r8, 8.17177e-04_r8, 9.63581e-04_r8, 1.13621e-03_r8, 1.33978e-03_r8, &
     & 1.57981e-03_r8, 1.86284e-03_r8, 2.19659e-03_r8, 2.59012e-03_r8/)
      kao_mco2( 8, :,13) = (/ &
     & 1.29667e-04_r8, 1.53001e-04_r8, 1.80534e-04_r8, 2.13022e-04_r8, 2.51356e-04_r8, &
     & 2.96589e-04_r8, 3.49961e-04_r8, 4.12938e-04_r8, 4.87249e-04_r8, 5.74931e-04_r8, &
     & 6.78393e-04_r8, 8.00473e-04_r8, 9.44521e-04_r8, 1.11449e-03_r8, 1.31505e-03_r8, &
     & 1.55170e-03_r8, 1.83094e-03_r8, 2.16042e-03_r8, 2.54920e-03_r8/)
      kao_mco2( 9, :,13) = (/ &
     & 1.37892e-04_r8, 1.62557e-04_r8, 1.91635e-04_r8, 2.25914e-04_r8, 2.66324e-04_r8, &
     & 3.13963e-04_r8, 3.70124e-04_r8, 4.36330e-04_r8, 5.14379e-04_r8, 6.06389e-04_r8, &
     & 7.14858e-04_r8, 8.42730e-04_r8, 9.93473e-04_r8, 1.17118e-03_r8, 1.38068e-03_r8, &
     & 1.62765e-03_r8, 1.91880e-03_r8, 2.26202e-03_r8, 2.66665e-03_r8/)
      kao_mco2( 1, :,14) = (/ &
     & 1.28098e-03_r8, 1.52939e-03_r8, 1.82597e-03_r8, 2.18007e-03_r8, 2.60284e-03_r8, &
     & 3.10759e-03_r8, 3.71022e-03_r8, 4.42972e-03_r8, 5.28874e-03_r8, 6.31435e-03_r8, &
     & 7.53885e-03_r8, 9.00081e-03_r8, 1.07463e-02_r8, 1.28302e-02_r8, 1.53183e-02_r8, &
     & 1.82889e-02_r8, 2.18355e-02_r8, 2.60699e-02_r8, 3.11255e-02_r8/)
      kao_mco2( 2, :,14) = (/ &
     & 1.27275e-04_r8, 1.48842e-04_r8, 1.74064e-04_r8, 2.03561e-04_r8, 2.38055e-04_r8, &
     & 2.78395e-04_r8, 3.25570e-04_r8, 3.80740e-04_r8, 4.45259e-04_r8, 5.20710e-04_r8, &
     & 6.08947e-04_r8, 7.12137e-04_r8, 8.32812e-04_r8, 9.73937e-04_r8, 1.13898e-03_r8, &
     & 1.33198e-03_r8, 1.55769e-03_r8, 1.82165e-03_r8, 2.13034e-03_r8/)
      kao_mco2( 3, :,14) = (/ &
     & 1.27744e-04_r8, 1.49255e-04_r8, 1.74389e-04_r8, 2.03755e-04_r8, 2.38066e-04_r8, &
     & 2.78155e-04_r8, 3.24995e-04_r8, 3.79722e-04_r8, 4.43666e-04_r8, 5.18376e-04_r8, &
     & 6.05668e-04_r8, 7.07660e-04_r8, 8.26826e-04_r8, 9.66059e-04_r8, 1.12874e-03_r8, &
     & 1.31881e-03_r8, 1.54089e-03_r8, 1.80037e-03_r8, 2.10354e-03_r8/)
      kao_mco2( 4, :,14) = (/ &
     & 1.28543e-04_r8, 1.50136e-04_r8, 1.75357e-04_r8, 2.04814e-04_r8, 2.39219e-04_r8, &
     & 2.79404e-04_r8, 3.26339e-04_r8, 3.81159e-04_r8, 4.45188e-04_r8, 5.19972e-04_r8, &
     & 6.07319e-04_r8, 7.09339e-04_r8, 8.28496e-04_r8, 9.67670e-04_r8, 1.13022e-03_r8, &
     & 1.32008e-03_r8, 1.54184e-03_r8, 1.80084e-03_r8, 2.10335e-03_r8/)
      kao_mco2( 5, :,14) = (/ &
     & 1.29218e-04_r8, 1.50897e-04_r8, 1.76214e-04_r8, 2.05778e-04_r8, 2.40302e-04_r8, &
     & 2.80618e-04_r8, 3.27698e-04_r8, 3.82678e-04_r8, 4.46881e-04_r8, 5.21855e-04_r8, &
     & 6.09409e-04_r8, 7.11652e-04_r8, 8.31048e-04_r8, 9.70475e-04_r8, 1.13330e-03_r8, &
     & 1.32343e-03_r8, 1.54547e-03_r8, 1.80476e-03_r8, 2.10755e-03_r8/)
      kao_mco2( 6, :,14) = (/ &
     & 1.30502e-04_r8, 1.52368e-04_r8, 1.77898e-04_r8, 2.07706e-04_r8, 2.42508e-04_r8, &
     & 2.83141e-04_r8, 3.30583e-04_r8, 3.85974e-04_r8, 4.50646e-04_r8, 5.26153e-04_r8, &
     & 6.14313e-04_r8, 7.17244e-04_r8, 8.37422e-04_r8, 9.77736e-04_r8, 1.14156e-03_r8, &
     & 1.33283e-03_r8, 1.55616e-03_r8, 1.81690e-03_r8, 2.12133e-03_r8/)
      kao_mco2( 7, :,14) = (/ &
     & 1.32820e-04_r8, 1.55041e-04_r8, 1.80980e-04_r8, 2.11259e-04_r8, 2.46604e-04_r8, &
     & 2.87862e-04_r8, 3.36022e-04_r8, 3.92240e-04_r8, 4.57864e-04_r8, 5.34467e-04_r8, &
     & 6.23886e-04_r8, 7.28265e-04_r8, 8.50107e-04_r8, 9.92334e-04_r8, 1.15836e-03_r8, &
     & 1.35215e-03_r8, 1.57838e-03_r8, 1.84244e-03_r8, 2.15069e-03_r8/)
      kao_mco2( 8, :,14) = (/ &
     & 1.40203e-04_r8, 1.63590e-04_r8, 1.90879e-04_r8, 2.22720e-04_r8, 2.59872e-04_r8, &
     & 3.03221e-04_r8, 3.53801e-04_r8, 4.12819e-04_r8, 4.81681e-04_r8, 5.62031e-04_r8, &
     & 6.55783e-04_r8, 7.65175e-04_r8, 8.92814e-04_r8, 1.04174e-03_r8, 1.21552e-03_r8, &
     & 1.41828e-03_r8, 1.65486e-03_r8, 1.93091e-03_r8, 2.25301e-03_r8/)
      kao_mco2( 9, :,14) = (/ &
     & 1.30642e-04_r8, 1.52513e-04_r8, 1.78046e-04_r8, 2.07853e-04_r8, 2.42651e-04_r8, &
     & 2.83275e-04_r8, 3.30699e-04_r8, 3.86063e-04_r8, 4.50696e-04_r8, 5.26149e-04_r8, &
     & 6.14234e-04_r8, 7.17066e-04_r8, 8.37113e-04_r8, 9.77259e-04_r8, 1.14087e-03_r8, &
     & 1.33186e-03_r8, 1.55484e-03_r8, 1.81514e-03_r8, 2.11902e-03_r8/)
      kao_mco2( 1, :,15) = (/ &
     & 1.37603e-03_r8, 1.64035e-03_r8, 1.95543e-03_r8, 2.33105e-03_r8, 2.77881e-03_r8, &
     & 3.31257e-03_r8, 3.94887e-03_r8, 4.70739e-03_r8, 5.61162e-03_r8, 6.68952e-03_r8, &
     & 7.97449e-03_r8, 9.50627e-03_r8, 1.13323e-02_r8, 1.35091e-02_r8, 1.61039e-02_r8, &
     & 1.91973e-02_r8, 2.28848e-02_r8, 2.72806e-02_r8, 3.25208e-02_r8/)
      kao_mco2( 2, :,15) = (/ &
     & 1.67843e-04_r8, 1.93707e-04_r8, 2.23557e-04_r8, 2.58007e-04_r8, 2.97765e-04_r8, &
     & 3.43650e-04_r8, 3.96606e-04_r8, 4.57722e-04_r8, 5.28256e-04_r8, 6.09659e-04_r8, &
     & 7.03606e-04_r8, 8.12031e-04_r8, 9.37163e-04_r8, 1.08158e-03_r8, 1.24825e-03_r8, &
     & 1.44060e-03_r8, 1.66259e-03_r8, 1.91880e-03_r8, 2.21448e-03_r8/)
      kao_mco2( 3, :,15) = (/ &
     & 1.67595e-04_r8, 1.93410e-04_r8, 2.23200e-04_r8, 2.57579e-04_r8, 2.97253e-04_r8, &
     & 3.43039e-04_r8, 3.95876e-04_r8, 4.56852e-04_r8, 5.27220e-04_r8, 6.08426e-04_r8, &
     & 7.02141e-04_r8, 8.10291e-04_r8, 9.35098e-04_r8, 1.07913e-03_r8, 1.24534e-03_r8, &
     & 1.43716e-03_r8, 1.65853e-03_r8, 1.91398e-03_r8, 2.20879e-03_r8/)
      kao_mco2( 4, :,15) = (/ &
     & 1.67354e-04_r8, 1.93130e-04_r8, 2.22877e-04_r8, 2.57206e-04_r8, 2.96823e-04_r8, &
     & 3.42541e-04_r8, 3.95301e-04_r8, 4.56187e-04_r8, 5.26452e-04_r8, 6.07539e-04_r8, &
     & 7.01116e-04_r8, 8.09106e-04_r8, 9.33728e-04_r8, 1.07755e-03_r8, 1.24352e-03_r8, &
     & 1.43505e-03_r8, 1.65608e-03_r8, 1.91116e-03_r8, 2.20553e-03_r8/)
      kao_mco2( 5, :,15) = (/ &
     & 1.67437e-04_r8, 1.93232e-04_r8, 2.23002e-04_r8, 2.57358e-04_r8, 2.97006e-04_r8, &
     & 3.42763e-04_r8, 3.95570e-04_r8, 4.56511e-04_r8, 5.26842e-04_r8, 6.08007e-04_r8, &
     & 7.01677e-04_r8, 8.09778e-04_r8, 9.34533e-04_r8, 1.07851e-03_r8, 1.24466e-03_r8, &
     & 1.43642e-03_r8, 1.65771e-03_r8, 1.91310e-03_r8, 2.20783e-03_r8/)
      kao_mco2( 6, :,15) = (/ &
     & 1.67267e-04_r8, 1.93027e-04_r8, 2.22753e-04_r8, 2.57057e-04_r8, 2.96645e-04_r8, &
     & 3.42328e-04_r8, 3.95047e-04_r8, 4.55885e-04_r8, 5.26092e-04_r8, 6.07110e-04_r8, &
     & 7.00606e-04_r8, 8.08500e-04_r8, 9.33010e-04_r8, 1.07669e-03_r8, 1.24251e-03_r8, &
     & 1.43385e-03_r8, 1.65467e-03_r8, 1.90949e-03_r8, 2.20355e-03_r8/)
      kao_mco2( 7, :,15) = (/ &
     & 1.67354e-04_r8, 1.93130e-04_r8, 2.22877e-04_r8, 2.57206e-04_r8, 2.96823e-04_r8, &
     & 3.42541e-04_r8, 3.95301e-04_r8, 4.56187e-04_r8, 5.26452e-04_r8, 6.07539e-04_r8, &
     & 7.01116e-04_r8, 8.09106e-04_r8, 9.33728e-04_r8, 1.07755e-03_r8, 1.24352e-03_r8, &
     & 1.43505e-03_r8, 1.65608e-03_r8, 1.91116e-03_r8, 2.20553e-03_r8/)
      kao_mco2( 8, :,15) = (/ &
     & 1.67276e-04_r8, 1.93038e-04_r8, 2.22769e-04_r8, 2.57079e-04_r8, 2.96673e-04_r8, &
     & 3.42365e-04_r8, 3.95094e-04_r8, 4.55944e-04_r8, 5.26166e-04_r8, 6.07203e-04_r8, &
     & 7.00722e-04_r8, 8.08643e-04_r8, 9.33186e-04_r8, 1.07691e-03_r8, 1.24277e-03_r8, &
     & 1.43417e-03_r8, 1.65506e-03_r8, 1.90996e-03_r8, 2.20412e-03_r8/)
      kao_mco2( 9, :,15) = (/ &
     & 1.67437e-04_r8, 1.93232e-04_r8, 2.23002e-04_r8, 2.57358e-04_r8, 2.97006e-04_r8, &
     & 3.42763e-04_r8, 3.95570e-04_r8, 4.56511e-04_r8, 5.26842e-04_r8, 6.08007e-04_r8, &
     & 7.01677e-04_r8, 8.09778e-04_r8, 9.34533e-04_r8, 1.07851e-03_r8, 1.24466e-03_r8, &
     & 1.43642e-03_r8, 1.65771e-03_r8, 1.91310e-03_r8, 2.20783e-03_r8/)
      kao_mco2( 1, :,16) = (/ &
     & 1.42104e-03_r8, 1.69791e-03_r8, 2.02872e-03_r8, 2.42399e-03_r8, 2.89626e-03_r8, &
     & 3.46055e-03_r8, 4.13478e-03_r8, 4.94038e-03_r8, 5.90294e-03_r8, 7.05303e-03_r8, &
     & 8.42720e-03_r8, 1.00691e-02_r8, 1.20309e-02_r8, 1.43749e-02_r8, 1.71757e-02_r8, &
     & 2.05221e-02_r8, 2.45205e-02_r8, 2.92979e-02_r8, 3.50061e-02_r8/)
      kao_mco2( 2, :,16) = (/ &
     & 1.63777e-04_r8, 1.88736e-04_r8, 2.17498e-04_r8, 2.50643e-04_r8, 2.88839e-04_r8, &
     & 3.32857e-04_r8, 3.83582e-04_r8, 4.42037e-04_r8, 5.09401e-04_r8, 5.87030e-04_r8, &
     & 6.76490e-04_r8, 7.79583e-04_r8, 8.98386e-04_r8, 1.03530e-03_r8, 1.19307e-03_r8, &
     & 1.37488e-03_r8, 1.58441e-03_r8, 1.82586e-03_r8, 2.10411e-03_r8/)
      kao_mco2( 3, :,16) = (/ &
     & 1.63679e-04_r8, 1.88621e-04_r8, 2.17365e-04_r8, 2.50489e-04_r8, 2.88661e-04_r8, &
     & 3.32650e-04_r8, 3.83342e-04_r8, 4.41759e-04_r8, 5.09079e-04_r8, 5.86657e-04_r8, &
     & 6.76057e-04_r8, 7.79080e-04_r8, 8.97804e-04_r8, 1.03462e-03_r8, 1.19228e-03_r8, &
     & 1.37397e-03_r8, 1.58335e-03_r8, 1.82464e-03_r8, 2.10269e-03_r8/)
      kao_mco2( 4, :,16) = (/ &
     & 1.63679e-04_r8, 1.88621e-04_r8, 2.17365e-04_r8, 2.50489e-04_r8, 2.88661e-04_r8, &
     & 3.32650e-04_r8, 3.83342e-04_r8, 4.41759e-04_r8, 5.09079e-04_r8, 5.86657e-04_r8, &
     & 6.76057e-04_r8, 7.79080e-04_r8, 8.97804e-04_r8, 1.03462e-03_r8, 1.19228e-03_r8, &
     & 1.37397e-03_r8, 1.58335e-03_r8, 1.82464e-03_r8, 2.10269e-03_r8/)
      kao_mco2( 5, :,16) = (/ &
     & 1.63586e-04_r8, 1.88513e-04_r8, 2.17239e-04_r8, 2.50343e-04_r8, 2.88490e-04_r8, &
     & 3.32451e-04_r8, 3.83111e-04_r8, 4.41490e-04_r8, 5.08766e-04_r8, 5.86292e-04_r8, &
     & 6.75633e-04_r8, 7.78588e-04_r8, 8.97231e-04_r8, 1.03395e-03_r8, 1.19151e-03_r8, &
     & 1.37307e-03_r8, 1.58231e-03_r8, 1.82342e-03_r8, 2.10128e-03_r8/)
      kao_mco2( 6, :,16) = (/ &
     & 1.63679e-04_r8, 1.88621e-04_r8, 2.17365e-04_r8, 2.50489e-04_r8, 2.88661e-04_r8, &
     & 3.32650e-04_r8, 3.83342e-04_r8, 4.41759e-04_r8, 5.09079e-04_r8, 5.86657e-04_r8, &
     & 6.76057e-04_r8, 7.79080e-04_r8, 8.97804e-04_r8, 1.03462e-03_r8, 1.19228e-03_r8, &
     & 1.37397e-03_r8, 1.58335e-03_r8, 1.82464e-03_r8, 2.10269e-03_r8/)
      kao_mco2( 7, :,16) = (/ &
     & 1.63679e-04_r8, 1.88621e-04_r8, 2.17365e-04_r8, 2.50489e-04_r8, 2.88661e-04_r8, &
     & 3.32650e-04_r8, 3.83342e-04_r8, 4.41759e-04_r8, 5.09079e-04_r8, 5.86657e-04_r8, &
     & 6.76057e-04_r8, 7.79080e-04_r8, 8.97804e-04_r8, 1.03462e-03_r8, 1.19228e-03_r8, &
     & 1.37397e-03_r8, 1.58335e-03_r8, 1.82464e-03_r8, 2.10269e-03_r8/)
      kao_mco2( 8, :,16) = (/ &
     & 1.63479e-04_r8, 1.88391e-04_r8, 2.17098e-04_r8, 2.50180e-04_r8, 2.88303e-04_r8, &
     & 3.32236e-04_r8, 3.82863e-04_r8, 4.41205e-04_r8, 5.08437e-04_r8, 5.85914e-04_r8, &
     & 6.75198e-04_r8, 7.78087e-04_r8, 8.96654e-04_r8, 1.03329e-03_r8, 1.19074e-03_r8, &
     & 1.37219e-03_r8, 1.58129e-03_r8, 1.82226e-03_r8, 2.09994e-03_r8/)
      kao_mco2( 9, :,16) = (/ &
     & 1.63586e-04_r8, 1.88513e-04_r8, 2.17239e-04_r8, 2.50343e-04_r8, 2.88490e-04_r8, &
     & 3.32451e-04_r8, 3.83111e-04_r8, 4.41490e-04_r8, 5.08766e-04_r8, 5.86292e-04_r8, &
     & 6.75633e-04_r8, 7.78588e-04_r8, 8.97231e-04_r8, 1.03395e-03_r8, 1.19151e-03_r8, &
     & 1.37307e-03_r8, 1.58231e-03_r8, 1.82342e-03_r8, 2.10128e-03_r8/)

!     The array KBO_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level above 100~ mb.   The first index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The second index 
!     runs over the g-channel (1 to 16).

      kbo_mco2(:, 1) = (/ &
     & 3.72069e-06_r8, 4.81866e-06_r8, 6.24064e-06_r8, 8.08226e-06_r8, 1.04673e-05_r8, &
     & 1.35562e-05_r8, 1.75567e-05_r8, 2.27376e-05_r8, 2.94475e-05_r8, 3.81375e-05_r8, &
     & 4.93918e-05_r8, 6.39674e-05_r8, 8.28441e-05_r8, 1.07291e-04_r8, 1.38953e-04_r8, &
     & 1.79958e-04_r8, 2.33064e-04_r8, 3.01840e-04_r8, 3.90913e-04_r8/)
      kbo_mco2(:, 2) = (/ &
     & 8.14357e-06_r8, 1.06031e-05_r8, 1.38056e-05_r8, 1.79752e-05_r8, 2.34041e-05_r8, &
     & 3.04728e-05_r8, 3.96763e-05_r8, 5.16596e-05_r8, 6.72622e-05_r8, 8.75770e-05_r8, &
     & 1.14027e-04_r8, 1.48467e-04_r8, 1.93307e-04_r8, 2.51691e-04_r8, 3.27708e-04_r8, &
     & 4.26685e-04_r8, 5.55555e-04_r8, 7.23346e-04_r8, 9.41814e-04_r8/)
      kbo_mco2(:, 3) = (/ &
     & 1.09367e-05_r8, 1.42063e-05_r8, 1.84533e-05_r8, 2.39701e-05_r8, 3.11362e-05_r8, &
     & 4.04446e-05_r8, 5.25358e-05_r8, 6.82417e-05_r8, 8.86432e-05_r8, 1.15144e-04_r8, &
     & 1.49567e-04_r8, 1.94281e-04_r8, 2.52363e-04_r8, 3.27809e-04_r8, 4.25810e-04_r8, &
     & 5.53109e-04_r8, 7.18466e-04_r8, 9.33256e-04_r8, 1.21226e-03_r8/)
      kbo_mco2(:, 4) = (/ &
     & 1.76192e-05_r8, 2.27752e-05_r8, 2.94401e-05_r8, 3.80553e-05_r8, 4.91916e-05_r8, &
     & 6.35867e-05_r8, 8.21944e-05_r8, 1.06247e-04_r8, 1.37339e-04_r8, 1.77529e-04_r8, &
     & 2.29480e-04_r8, 2.96635e-04_r8, 3.83440e-04_r8, 4.95648e-04_r8, 6.40691e-04_r8, &
     & 8.28180e-04_r8, 1.07054e-03_r8, 1.38381e-03_r8, 1.78876e-03_r8/)
      kbo_mco2(:, 5) = (/ &
     & 3.72142e-05_r8, 4.78603e-05_r8, 6.15520e-05_r8, 7.91605e-05_r8, 1.01806e-04_r8, &
     & 1.30931e-04_r8, 1.68387e-04_r8, 2.16558e-04_r8, 2.78510e-04_r8, 3.58185e-04_r8, &
     & 4.60653e-04_r8, 5.92435e-04_r8, 7.61915e-04_r8, 9.79881e-04_r8, 1.26020e-03_r8, &
     & 1.62071e-03_r8, 2.08436e-03_r8, 2.68064e-03_r8, 3.44751e-03_r8/)
      kbo_mco2(:, 6) = (/ &
     & 7.74131e-05_r8, 9.98876e-05_r8, 1.28887e-04_r8, 1.66305e-04_r8, 2.14587e-04_r8, &
     & 2.76886e-04_r8, 3.57272e-04_r8, 4.60994e-04_r8, 5.94831e-04_r8, 7.67521e-04_r8, &
     & 9.90348e-04_r8, 1.27787e-03_r8, 1.64886e-03_r8, 2.12755e-03_r8, 2.74522e-03_r8, &
     & 3.54221e-03_r8, 4.57059e-03_r8, 5.89752e-03_r8, 7.60968e-03_r8/)
      kbo_mco2(:, 7) = (/ &
     & 1.32294e-04_r8, 1.70977e-04_r8, 2.20973e-04_r8, 2.85587e-04_r8, 3.69095e-04_r8, &
     & 4.77022e-04_r8, 6.16507e-04_r8, 7.96779e-04_r8, 1.02976e-03_r8, 1.33088e-03_r8, &
     & 1.72004e-03_r8, 2.22299e-03_r8, 2.87301e-03_r8, 3.71310e-03_r8, 4.79884e-03_r8, &
     & 6.20207e-03_r8, 8.01561e-03_r8, 1.03594e-02_r8, 1.33886e-02_r8/)
      kbo_mco2(:, 8) = (/ &
     & 3.59868e-05_r8, 4.63611e-05_r8, 5.97261e-05_r8, 7.69439e-05_r8, 9.91253e-05_r8, &
     & 1.27701e-04_r8, 1.64515e-04_r8, 2.11941e-04_r8, 2.73040e-04_r8, 3.51752e-04_r8, &
     & 4.53155e-04_r8, 5.83790e-04_r8, 7.52085e-04_r8, 9.68897e-04_r8, 1.24821e-03_r8, &
     & 1.60804e-03_r8, 2.07161e-03_r8, 2.66882e-03_r8, 3.43818e-03_r8/)
      kbo_mco2(:, 9) = (/ &
     & 5.09543e-05_r8, 6.60510e-05_r8, 8.56205e-05_r8, 1.10988e-04_r8, 1.43872e-04_r8, &
     & 1.86498e-04_r8, 2.41753e-04_r8, 3.13380e-04_r8, 4.06228e-04_r8, 5.26585e-04_r8, &
     & 6.82601e-04_r8, 8.84842e-04_r8, 1.14700e-03_r8, 1.48684e-03_r8, 1.92735e-03_r8, &
     & 2.49839e-03_r8, 3.23861e-03_r8, 4.19814e-03_r8, 5.44196e-03_r8/)
      kbo_mco2(:,10) = (/ &
     & 2.08253e-05_r8, 2.64900e-05_r8, 3.36954e-05_r8, 4.28609e-05_r8, 5.45194e-05_r8, &
     & 6.93491e-05_r8, 8.82125e-05_r8, 1.12207e-04_r8, 1.42728e-04_r8, 1.81551e-04_r8, &
     & 2.30935e-04_r8, 2.93751e-04_r8, 3.73653e-04_r8, 4.75290e-04_r8, 6.04572e-04_r8, &
     & 7.69021e-04_r8, 9.78201e-04_r8, 1.24428e-03_r8, 1.58273e-03_r8/)
      kbo_mco2(:,11) = (/ &
     & 2.08953e-05_r8, 2.65543e-05_r8, 3.37459e-05_r8, 4.28852e-05_r8, 5.44996e-05_r8, &
     & 6.92595e-05_r8, 8.80169e-05_r8, 1.11854e-04_r8, 1.42147e-04_r8, 1.80644e-04_r8, &
     & 2.29568e-04_r8, 2.91741e-04_r8, 3.70752e-04_r8, 4.71161e-04_r8, 5.98764e-04_r8, &
     & 7.60925e-04_r8, 9.67005e-04_r8, 1.22889e-03_r8, 1.56171e-03_r8/)
      kbo_mco2(:,12) = (/ &
     & 2.65295e-05_r8, 3.36318e-05_r8, 4.26356e-05_r8, 5.40498e-05_r8, 6.85198e-05_r8, &
     & 8.68636e-05_r8, 1.10118e-04_r8, 1.39599e-04_r8, 1.76972e-04_r8, 2.24350e-04_r8, &
     & 2.84412e-04_r8, 3.60553e-04_r8, 4.57079e-04_r8, 5.79446e-04_r8, 7.34572e-04_r8, &
     & 9.31230e-04_r8, 1.18053e-03_r8, 1.49658e-03_r8, 1.89724e-03_r8/)
      kbo_mco2(:,13) = (/ &
     & 3.45358e-05_r8, 4.36743e-05_r8, 5.52309e-05_r8, 6.98455e-05_r8, 8.83273e-05_r8, &
     & 1.11700e-04_r8, 1.41256e-04_r8, 1.78634e-04_r8, 2.25902e-04_r8, 2.85678e-04_r8, &
     & 3.61271e-04_r8, 4.56867e-04_r8, 5.77758e-04_r8, 7.30639e-04_r8, 9.23973e-04_r8, &
     & 1.16847e-03_r8, 1.47765e-03_r8, 1.86865e-03_r8, 2.36311e-03_r8/)
      kbo_mco2(:,14) = (/ &
     & 3.99721e-05_r8, 5.12343e-05_r8, 6.56698e-05_r8, 8.41725e-05_r8, 1.07888e-04_r8, &
     & 1.38286e-04_r8, 1.77249e-04_r8, 2.27190e-04_r8, 2.91201e-04_r8, 3.73248e-04_r8, &
     & 4.78412e-04_r8, 6.13207e-04_r8, 7.85980e-04_r8, 1.00743e-03_r8, 1.29128e-03_r8, &
     & 1.65510e-03_r8, 2.12144e-03_r8, 2.71916e-03_r8, 3.48529e-03_r8/)
      kbo_mco2(:,15) = (/ &
     & 8.51533e-06_r8, 1.23021e-05_r8, 1.77730e-05_r8, 2.56767e-05_r8, 3.70953e-05_r8, &
     & 5.35918e-05_r8, 7.74243e-05_r8, 1.11855e-04_r8, 1.61598e-04_r8, 2.33461e-04_r8, &
     & 3.37283e-04_r8, 4.87275e-04_r8, 7.03968e-04_r8, 1.01703e-03_r8, 1.46930e-03_r8, &
     & 2.12271e-03_r8, 3.06670e-03_r8, 4.43047e-03_r8, 6.40072e-03_r8/)
      kbo_mco2(:,16) = (/ &
     & 2.93050e-06_r8, 3.65298e-06_r8, 4.55358e-06_r8, 5.67622e-06_r8, 7.07564e-06_r8, &
     & 8.82006e-06_r8, 1.09945e-05_r8, 1.37051e-05_r8, 1.70840e-05_r8, 2.12959e-05_r8, &
     & 2.65461e-05_r8, 3.30908e-05_r8, 4.12490e-05_r8, 5.14185e-05_r8, 6.40952e-05_r8, &
     & 7.98972e-05_r8, 9.95951e-05_r8, 1.24149e-04_r8, 1.54757e-04_r8/)

!     The array FORREFO contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  The first 
!     index refers to reference temperature (296_r8,260_r8,224,260) and 
!     pressure (970,475,219,3 mbar) levels.  The second index 
!     runs over the g-channel (1 to 16).

      forrefo(1,:) = (/ &
     &2.0677e-07_r8,2.0363e-07_r8,2.0583e-07_r8,2.0547e-07_r8,2.0267e-07_r8,2.0154e-07_r8, &
     &2.0190e-07_r8,2.0103e-07_r8,1.9869e-07_r8,1.9663e-07_r8,1.9701e-07_r8,2.0103e-07_r8, &
     &2.0527e-07_r8,2.0206e-07_r8,2.0364e-07_r8,2.0364e-07_r8/)
      forrefo(2,:) = (/ &
     &2.2427e-07_r8,2.1489e-07_r8,2.0453e-07_r8,1.9710e-07_r8,1.9650e-07_r8,1.9738e-07_r8, &
     &1.9767e-07_r8,1.9769e-07_r8,1.9940e-07_r8,1.9846e-07_r8,1.9898e-07_r8,1.9853e-07_r8, &
     &2.0000e-07_r8,2.0517e-07_r8,2.0482e-07_r8,2.0482e-07_r8/)
      forrefo(3,:) = (/ &
     &2.2672e-07_r8,2.1706e-07_r8,2.0571e-07_r8,1.9747e-07_r8,1.9706e-07_r8,1.9698e-07_r8, &
     &1.9781e-07_r8,1.9774e-07_r8,1.9724e-07_r8,1.9714e-07_r8,1.9751e-07_r8,1.9758e-07_r8, &
     &1.9840e-07_r8,1.9968e-07_r8,1.9931e-07_r8,1.9880e-07_r8/)
      forrefo(4,:) = (/ &
     &2.2191e-07_r8,2.0899e-07_r8,2.0265e-07_r8,2.0101e-07_r8,2.0034e-07_r8,2.0021e-07_r8, &
     &1.9987e-07_r8,1.9978e-07_r8,1.9902e-07_r8,1.9742e-07_r8,1.9672e-07_r8,1.9615e-07_r8, &
     &1.9576e-07_r8,1.9540e-07_r8,1.9588e-07_r8,1.9590e-07_r8/)

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      selfrefo(:, 1) = (/ &
     & 5.18832e-02_r8, 4.28690e-02_r8, 3.54210e-02_r8, 2.92670e-02_r8, 2.41822e-02_r8, &
     & 1.99808e-02_r8, 1.65093e-02_r8, 1.36410e-02_r8, 1.12710e-02_r8, 9.31280e-03_r8/)
      selfrefo(:, 2) = (/ &
     & 4.36030e-02_r8, 3.78379e-02_r8, 3.28350e-02_r8, 2.84936e-02_r8, 2.47262e-02_r8, &
     & 2.14569e-02_r8, 1.86199e-02_r8, 1.61580e-02_r8, 1.40216e-02_r8, 1.21677e-02_r8/)
      selfrefo(:, 3) = (/ &
     & 4.26492e-02_r8, 3.71443e-02_r8, 3.23500e-02_r8, 2.81745e-02_r8, 2.45379e-02_r8, &
     & 2.13707e-02_r8, 1.86124e-02_r8, 1.62100e-02_r8, 1.41177e-02_r8, 1.22955e-02_r8/)
      selfrefo(:, 4) = (/ &
     & 4.03591e-02_r8, 3.54614e-02_r8, 3.11580e-02_r8, 2.73769e-02_r8, 2.40546e-02_r8, &
     & 2.11355e-02_r8, 1.85706e-02_r8, 1.63170e-02_r8, 1.43369e-02_r8, 1.25970e-02_r8/)
      selfrefo(:, 5) = (/ &
     & 3.94512e-02_r8, 3.46232e-02_r8, 3.03860e-02_r8, 2.66674e-02_r8, 2.34038e-02_r8, &
     & 2.05397e-02_r8, 1.80260e-02_r8, 1.58200e-02_r8, 1.38839e-02_r8, 1.21848e-02_r8/)
      selfrefo(:, 6) = (/ &
     & 3.90567e-02_r8, 3.40694e-02_r8, 2.97190e-02_r8, 2.59241e-02_r8, 2.26138e-02_r8, &
     & 1.97261e-02_r8, 1.72072e-02_r8, 1.50100e-02_r8, 1.30933e-02_r8, 1.14214e-02_r8/)
      selfrefo(:, 7) = (/ &
     & 3.85397e-02_r8, 3.36462e-02_r8, 2.93740e-02_r8, 2.56443e-02_r8, 2.23881e-02_r8, &
     & 1.95454e-02_r8, 1.70636e-02_r8, 1.48970e-02_r8, 1.30055e-02_r8, 1.13541e-02_r8/)
      selfrefo(:, 8) = (/ &
     & 3.79692e-02_r8, 3.31360e-02_r8, 2.89180e-02_r8, 2.52369e-02_r8, 2.20245e-02_r8, &
     & 1.92209e-02_r8, 1.67742e-02_r8, 1.46390e-02_r8, 1.27756e-02_r8, 1.11493e-02_r8/)
      selfrefo(:, 9) = (/ &
     & 3.68819e-02_r8, 3.22827e-02_r8, 2.82570e-02_r8, 2.47333e-02_r8, 2.16490e-02_r8, &
     & 1.89494e-02_r8, 1.65863e-02_r8, 1.45180e-02_r8, 1.27076e-02_r8, 1.11229e-02_r8/)
      selfrefo(:,10) = (/ &
     & 3.65157e-02_r8, 3.20121e-02_r8, 2.80640e-02_r8, 2.46028e-02_r8, 2.15685e-02_r8, &
     & 1.89084e-02_r8, 1.65764e-02_r8, 1.45320e-02_r8, 1.27397e-02_r8, 1.11685e-02_r8/)
      selfrefo(:,11) = (/ &
     & 3.59917e-02_r8, 3.16727e-02_r8, 2.78720e-02_r8, 2.45274e-02_r8, 2.15841e-02_r8, &
     & 1.89940e-02_r8, 1.67148e-02_r8, 1.47090e-02_r8, 1.29439e-02_r8, 1.13907e-02_r8/)
      selfrefo(:,12) = (/ &
     & 3.66963e-02_r8, 3.20483e-02_r8, 2.79890e-02_r8, 2.44439e-02_r8, 2.13478e-02_r8, &
     & 1.86438e-02_r8, 1.62824e-02_r8, 1.42200e-02_r8, 1.24189e-02_r8, 1.08459e-02_r8/)
      selfrefo(:,13) = (/ &
     & 3.66422e-02_r8, 3.19026e-02_r8, 2.77760e-02_r8, 2.41832e-02_r8, 2.10551e-02_r8, &
     & 1.83317e-02_r8, 1.59605e-02_r8, 1.38960e-02_r8, 1.20986e-02_r8, 1.05336e-02_r8/)
      selfrefo(:,14) = (/ &
     & 3.81260e-02_r8, 3.29322e-02_r8, 2.84460e-02_r8, 2.45709e-02_r8, 2.12237e-02_r8, &
     & 1.83325e-02_r8, 1.58352e-02_r8, 1.36780e-02_r8, 1.18147e-02_r8, 1.02052e-02_r8/)
      selfrefo(:,15) = (/ &
     & 3.51264e-02_r8, 3.05081e-02_r8, 2.64970e-02_r8, 2.30133e-02_r8, 1.99876e-02_r8, &
     & 1.73597e-02_r8, 1.50773e-02_r8, 1.30950e-02_r8, 1.13733e-02_r8, 9.87800e-03_r8/)
      selfrefo(:,16) = (/ &
     & 3.51264e-02_r8, 3.05081e-02_r8, 2.64970e-02_r8, 2.30133e-02_r8, 1.99876e-02_r8, &
     & 1.73597e-02_r8, 1.50773e-02_r8, 1.30950e-02_r8, 1.13733e-02_r8, 9.87800e-03_r8/)

      end subroutine lw_kgb07

! **************************************************************************
