!     path:      $Source: /storm/rc1/cvsroot/rc/rrtmg_lw/src/rrtmg_lw_k_g.f90,v $
!     author:    $Author: mike $
!     revision:  $Revision: 1.2 $
!     created:   $Date: 2007/08/22 19:20:03 $
!
!  --------------------------------------------------------------------------
! |                                                                          |
! |  Copyright 2002-2007, Atmospheric & Environmental Research, Inc. (AER).  |
! |  This software may be used, copied, or redistributed as long as it is    |
! |  not sold and this copyright notice is reproduced on each copy made.     |
! |  This model is provided as is without any express or implied warranties. |
! |                       (http://www.rtweb.aer.com/)                        |
! |                                                                          |
!  --------------------------------------------------------------------------

! **************************************************************************
!      subroutine lw_kgbnn
! **************************************************************************
!  RRTM Longwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original version:   E. J. Mlawer, et al.
!  Revision for GCMs:  Michael J. Iacono; October, 2002
!
!  This file contains 16 subroutines that include the 
!  absorption coefficients and other data for each of the 16 longwave
!  spectral bands used in RRTM.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_LW_INIT to reduce
!  the total number of g-points from 256 to 140 for use in the GCM.
! **************************************************************************
      subroutine lw_kgb05
! **************************************************************************

      use shr_kind_mod, only: r8 => shr_kind_r8

!      use parkind, only : jpim, jprb 
      use rrlw_kg05, only : fracrefao, fracrefbo, kao, kbo, kao_mo3, &
                            selfrefo, forrefo, ccl4o

      implicit none
      save

! Planck fraction mapping level : P = 473.42 mb, T = 259.83
      fracrefao(:, 1) = (/ &
        1.4111e-01_r8,1.4222e-01_r8,1.3802e-01_r8,1.3101e-01_r8,1.2244e-01_r8,1.0691e-01_r8, &
        8.8703e-02_r8,6.7130e-02_r8,4.5509e-02_r8,4.9866e-03_r8,4.1214e-03_r8,3.2557e-03_r8, &
        2.3805e-03_r8,1.5450e-03_r8,5.8423e-04_r8,8.2275e-05_r8/)
      fracrefao(:, 2) = (/ &
        1.4152e-01_r8,1.4271e-01_r8,1.3784e-01_r8,1.3075e-01_r8,1.2215e-01_r8,1.0674e-01_r8, &
        8.8686e-02_r8,6.7135e-02_r8,4.5508e-02_r8,4.9866e-03_r8,4.1214e-03_r8,3.2558e-03_r8, &
        2.3805e-03_r8,1.5450e-03_r8,5.8423e-04_r8,8.2275e-05_r8/)
      fracrefao(:, 3) = (/ &
        1.4159e-01_r8,1.4300e-01_r8,1.3781e-01_r8,1.3094e-01_r8,1.2192e-01_r8,1.0661e-01_r8, &
        8.8529e-02_r8,6.7127e-02_r8,4.5511e-02_r8,4.9877e-03_r8,4.1214e-03_r8,3.2558e-03_r8, &
        2.3805e-03_r8,1.5450e-03_r8,5.8423e-04_r8,8.2275e-05_r8/)
      fracrefao(:, 4) = (/ &
        1.4162e-01_r8,1.4337e-01_r8,1.3774e-01_r8,1.3122e-01_r8,1.2172e-01_r8,1.0641e-01_r8, &
        8.8384e-02_r8,6.7056e-02_r8,4.5514e-02_r8,4.9880e-03_r8,4.1214e-03_r8,3.2557e-03_r8, &
        2.3805e-03_r8,1.5450e-03_r8,5.8423e-04_r8,8.2275e-05_r8/)
      fracrefao(:, 5) = (/ &
        1.4161e-01_r8,1.4370e-01_r8,1.3770e-01_r8,1.3143e-01_r8,1.2173e-01_r8,1.0613e-01_r8, &
        8.8357e-02_r8,6.6874e-02_r8,4.5509e-02_r8,4.9883e-03_r8,4.1214e-03_r8,3.2558e-03_r8, &
        2.3804e-03_r8,1.5450e-03_r8,5.8423e-04_r8,8.2275e-05_r8/)
      fracrefao(:, 6) = (/ &
        1.4154e-01_r8,1.4405e-01_r8,1.3771e-01_r8,1.3169e-01_r8,1.2166e-01_r8,1.0603e-01_r8, &
        8.8193e-02_r8,6.6705e-02_r8,4.5469e-02_r8,4.9902e-03_r8,4.1214e-03_r8,3.2558e-03_r8, &
        2.3804e-03_r8,1.5450e-03_r8,5.8423e-04_r8,8.2275e-05_r8/)
      fracrefao(:, 7) = (/ &
        1.4126e-01_r8,1.4440e-01_r8,1.3790e-01_r8,1.3214e-01_r8,1.2153e-01_r8,1.0603e-01_r8, &
        8.7908e-02_r8,6.6612e-02_r8,4.5269e-02_r8,4.9900e-03_r8,4.1256e-03_r8,3.2558e-03_r8, &
        2.3804e-03_r8,1.5451e-03_r8,5.8423e-04_r8,8.2275e-05_r8/)
      fracrefao(:, 8) = (/ &
        1.4076e-01_r8,1.4415e-01_r8,1.3885e-01_r8,1.3286e-01_r8,1.2147e-01_r8,1.0612e-01_r8, &
        8.7579e-02_r8,6.6280e-02_r8,4.4977e-02_r8,4.9782e-03_r8,4.1200e-03_r8,3.2620e-03_r8, &
        2.3820e-03_r8,1.5452e-03_r8,5.8423e-04_r8,8.2275e-05_r8/)
      fracrefao(:, 9) = (/ &
        1.4205e-01_r8,1.4496e-01_r8,1.4337e-01_r8,1.3504e-01_r8,1.2260e-01_r8,1.0428e-01_r8, &
        8.4946e-02_r8,6.3625e-02_r8,4.2951e-02_r8,4.7313e-03_r8,3.9157e-03_r8,3.0879e-03_r8, &
        2.2666e-03_r8,1.5193e-03_r8,5.7469e-04_r8,8.1674e-05_r8/)

! Planck fraction mapping level : P = 0.2369280 mbar, T = 253.60 K
      fracrefbo(:, 1) = (/ &
        1.4075e-01_r8,1.4196e-01_r8,1.3833e-01_r8,1.3345e-01_r8,1.2234e-01_r8,1.0718e-01_r8, &
        8.8004e-02_r8,6.6308e-02_r8,4.5028e-02_r8,4.9029e-03_r8,4.0377e-03_r8,3.1870e-03_r8, &
        2.3503e-03_r8,1.5146e-03_r8,5.7165e-04_r8,8.2371e-05_r8/)
      fracrefbo(:, 2) = (/ &
        1.4081e-01_r8,1.4225e-01_r8,1.3890e-01_r8,1.3410e-01_r8,1.2254e-01_r8,1.0680e-01_r8, &
        8.7391e-02_r8,6.5819e-02_r8,4.4725e-02_r8,4.9121e-03_r8,4.0420e-03_r8,3.1869e-03_r8, &
        2.3504e-03_r8,1.5146e-03_r8,5.7165e-04_r8,8.2371e-05_r8/)
      fracrefbo(:, 3) = (/ &
        1.4087e-01_r8,1.4227e-01_r8,1.3920e-01_r8,1.3395e-01_r8,1.2270e-01_r8,1.0694e-01_r8, &
        8.7229e-02_r8,6.5653e-02_r8,4.4554e-02_r8,4.8797e-03_r8,4.0460e-03_r8,3.1939e-03_r8, &
        2.3505e-03_r8,1.5146e-03_r8,5.7165e-04_r8,8.1910e-05_r8/)
      fracrefbo(:, 4) = (/ &
        1.4089e-01_r8,1.4238e-01_r8,1.3956e-01_r8,1.3379e-01_r8,1.2284e-01_r8,1.0688e-01_r8, &
        8.7192e-02_r8,6.5490e-02_r8,4.4390e-02_r8,4.8395e-03_r8,4.0173e-03_r8,3.2070e-03_r8, &
        2.3559e-03_r8,1.5146e-03_r8,5.7165e-04_r8,8.2371e-05_r8/)
      fracrefbo(:, 5) = (/ &
        1.4091e-01_r8,1.4417e-01_r8,1.4194e-01_r8,1.3457e-01_r8,1.2167e-01_r8,1.0551e-01_r8, &
        8.6450e-02_r8,6.4889e-02_r8,4.3584e-02_r8,4.7551e-03_r8,3.9509e-03_r8,3.1374e-03_r8, &
        2.3226e-03_r8,1.4942e-03_r8,5.7545e-04_r8,8.0887e-05_r8/)

! Minor gas mapping level :
!     lower - o3, p = 317.34 mbar, t = 240.77 k
!     lower - ccl4

      ccl4o(:) = (/ &
        26.1407_r8, 53.9776_r8, 63.8085_r8, 36.1701_r8, 15.4099_r8, 10.23116_r8, &
        4.82948_r8, 5.03836_r8, 1.75558_r8, 0._r8,      0._r8,      0._r8,       &
        0._r8,      0._r8,      0._r8,      0._r8/)

!     The array KAO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels > ~100mb, temperatures, and ratios
!     of water vapor to CO2.  The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amount ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 
!     to that of gas2.
!     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
!     to different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this  pressure 
!     level, JT = 2 refers to the temperature
!     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the reference pressure level (e.g. JP = 1 is for a
!     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

      kao(:, 1, 1, 1) = (/ &
     &2.0627e-06_r8,7.6619e-06_r8,1.2821e-05_r8,1.8547e-05_r8,2.5694e-05_r8,3.6833e-05_r8, &
     &6.0675e-05_r8,1.0691e-04_r8,4.5186e-05_r8/)
      kao(:, 2, 1, 1) = (/ &
     &2.7702e-06_r8,1.0260e-05_r8,1.6067e-05_r8,2.2990e-05_r8,3.0808e-05_r8,4.1244e-05_r8, &
     &5.9411e-05_r8,1.1066e-04_r8,5.2628e-05_r8/)
      kao(:, 3, 1, 1) = (/ &
     &3.6863e-06_r8,1.3689e-05_r8,2.0068e-05_r8,2.8133e-05_r8,3.7359e-05_r8,4.8756e-05_r8, &
     &6.5660e-05_r8,1.0750e-04_r8,6.3147e-05_r8/)
      kao(:, 4, 1, 1) = (/ &
     &4.8209e-06_r8,1.8184e-05_r8,2.5811e-05_r8,3.2670e-05_r8,4.2393e-05_r8,5.7509e-05_r8, &
     &7.7672e-05_r8,1.1739e-04_r8,6.0614e-05_r8/)
      kao(:, 5, 1, 1) = (/ &
     &6.2011e-06_r8,2.3679e-05_r8,3.3185e-05_r8,4.1098e-05_r8,4.8872e-05_r8,6.0199e-05_r8, &
     &8.6830e-05_r8,1.3320e-04_r8,5.7959e-05_r8/)
      kao(:, 1, 2, 1) = (/ &
     &2.3538e-06_r8,6.7359e-06_r8,1.0280e-05_r8,1.4331e-05_r8,1.9304e-05_r8,2.5963e-05_r8, &
     &4.0842e-05_r8,7.0297e-05_r8,3.0786e-05_r8/)
      kao(:, 2, 2, 1) = (/ &
     &3.1800e-06_r8,9.2776e-06_r8,1.3401e-05_r8,1.8014e-05_r8,2.3501e-05_r8,3.0468e-05_r8, &
     &4.1030e-05_r8,7.2758e-05_r8,3.6807e-05_r8/)
      kao(:, 3, 2, 1) = (/ &
     &4.2644e-06_r8,1.2589e-05_r8,1.7414e-05_r8,2.2365e-05_r8,2.8924e-05_r8,3.6996e-05_r8, &
     &4.7459e-05_r8,7.1458e-05_r8,4.4453e-05_r8/)
      kao(:, 4, 2, 1) = (/ &
     &5.6334e-06_r8,1.6843e-05_r8,2.2937e-05_r8,2.8083e-05_r8,3.3609e-05_r8,4.3642e-05_r8, &
     &5.6794e-05_r8,7.9540e-05_r8,3.7769e-05_r8/)
      kao(:, 5, 2, 1) = (/ &
     &7.3165e-06_r8,2.2208e-05_r8,2.9987e-05_r8,3.5834e-05_r8,4.1117e-05_r8,4.7236e-05_r8, &
     &6.4507e-05_r8,9.1784e-05_r8,4.0356e-05_r8/)
      kao(:, 1, 3, 1) = (/ &
     &3.4149e-06_r8,6.8426e-06_r8,8.9161e-06_r8,1.1292e-05_r8,1.3987e-05_r8,1.7689e-05_r8, &
     &2.4623e-05_r8,4.0560e-05_r8,1.8741e-05_r8/)
      kao(:, 2, 3, 1) = (/ &
     &4.6295e-06_r8,9.5910e-06_r8,1.2218e-05_r8,1.4773e-05_r8,1.7906e-05_r8,2.1627e-05_r8, &
     &2.7175e-05_r8,4.1902e-05_r8,2.3338e-05_r8/)
      kao(:, 3, 3, 1) = (/ &
     &6.2620e-06_r8,1.3265e-05_r8,1.6740e-05_r8,1.9517e-05_r8,2.2851e-05_r8,2.6791e-05_r8, &
     &3.2311e-05_r8,4.3092e-05_r8,2.7303e-05_r8/)
      kao(:, 4, 3, 1) = (/ &
     &8.3825e-06_r8,1.8025e-05_r8,2.2633e-05_r8,2.5988e-05_r8,2.8756e-05_r8,3.2402e-05_r8, &
     &3.9084e-05_r8,5.0182e-05_r8,2.3119e-05_r8/)
      kao(:, 5, 3, 1) = (/ &
     &1.1030e-05_r8,2.4184e-05_r8,3.0218e-05_r8,3.4428e-05_r8,3.7379e-05_r8,3.9667e-05_r8, &
     &4.3975e-05_r8,5.8391e-05_r8,2.6206e-05_r8/)
      kao(:, 1, 4, 1) = (/ &
     &5.0171e-06_r8,7.6880e-06_r8,8.7791e-06_r8,9.8121e-06_r8,1.1212e-05_r8,1.2838e-05_r8, &
     &1.6066e-05_r8,2.4377e-05_r8,1.1689e-05_r8/)
      kao(:, 2, 4, 1) = (/ &
     &6.7946e-06_r8,1.0789e-05_r8,1.2297e-05_r8,1.3454e-05_r8,1.4738e-05_r8,1.6388e-05_r8, &
     &1.8978e-05_r8,2.5098e-05_r8,1.5123e-05_r8/)
      kao(:, 3, 4, 1) = (/ &
     &9.2346e-06_r8,1.5122e-05_r8,1.7217e-05_r8,1.8715e-05_r8,1.9870e-05_r8,2.1284e-05_r8, &
     &2.3541e-05_r8,2.8475e-05_r8,1.5817e-05_r8/)
      kao(:, 4, 4, 1) = (/ &
     &1.2485e-05_r8,2.0883e-05_r8,2.3764e-05_r8,2.5687e-05_r8,2.6834e-05_r8,2.7524e-05_r8, &
     &2.9511e-05_r8,3.4495e-05_r8,1.5461e-05_r8/)
      kao(:, 5, 4, 1) = (/ &
     &1.6688e-05_r8,2.8377e-05_r8,3.2282e-05_r8,3.4761e-05_r8,3.6075e-05_r8,3.6212e-05_r8, &
     &3.5832e-05_r8,4.0812e-05_r8,1.7475e-05_r8/)
      kao(:, 1, 5, 1) = (/ &
     &6.8849e-06_r8,8.9001e-06_r8,9.3032e-06_r8,9.4606e-06_r8,9.6746e-06_r8,1.0252e-05_r8, &
     &1.1422e-05_r8,1.5315e-05_r8,7.4550e-06_r8/)
      kao(:, 2, 5, 1) = (/ &
     &9.2829e-06_r8,1.2355e-05_r8,1.3006e-05_r8,1.3223e-05_r8,1.3294e-05_r8,1.3454e-05_r8, &
     &1.4383e-05_r8,1.6505e-05_r8,9.6725e-06_r8/)
      kao(:, 3, 5, 1) = (/ &
     &1.2628e-05_r8,1.7354e-05_r8,1.8341e-05_r8,1.8646e-05_r8,1.8560e-05_r8,1.8269e-05_r8, &
     &1.8381e-05_r8,1.9847e-05_r8,1.0746e-05_r8/)
      kao(:, 4, 5, 1) = (/ &
     &1.7178e-05_r8,2.4178e-05_r8,2.5699e-05_r8,2.6093e-05_r8,2.5857e-05_r8,2.5047e-05_r8, &
     &2.4039e-05_r8,2.4517e-05_r8,1.1239e-05_r8/)
      kao(:, 5, 5, 1) = (/ &
     &2.3232e-05_r8,3.3207e-05_r8,3.5417e-05_r8,3.5933e-05_r8,3.5521e-05_r8,3.4179e-05_r8, &
     &3.1639e-05_r8,3.0107e-05_r8,1.3413e-05_r8/)
      kao(:, 1, 6, 1) = (/ &
     &8.9763e-06_r8,1.0310e-05_r8,1.0152e-05_r8,9.7112e-06_r8,9.1573e-06_r8,8.7286e-06_r8, &
     &8.7100e-06_r8,1.0151e-05_r8,5.0468e-06_r8/)
      kao(:, 2, 6, 1) = (/ &
     &1.1944e-05_r8,1.4094e-05_r8,1.4098e-05_r8,1.3570e-05_r8,1.2771e-05_r8,1.1934e-05_r8, &
     &1.1288e-05_r8,1.1804e-05_r8,6.4542e-06_r8/)
      kao(:, 3, 6, 1) = (/ &
     &1.6264e-05_r8,1.9621e-05_r8,1.9778e-05_r8,1.9110e-05_r8,1.7995e-05_r8,1.6619e-05_r8, &
     &1.5210e-05_r8,1.4762e-05_r8,7.7867e-06_r8/)
      kao(:, 4, 6, 1) = (/ &
     &2.2127e-05_r8,2.7394e-05_r8,2.7774e-05_r8,2.6897e-05_r8,2.5333e-05_r8,2.3366e-05_r8, &
     &2.0855e-05_r8,1.8805e-05_r8,9.1527e-06_r8/)
      kao(:, 5, 6, 1) = (/ &
     &3.0031e-05_r8,3.7976e-05_r8,3.8538e-05_r8,3.7483e-05_r8,3.5390e-05_r8,3.2530e-05_r8, &
     &2.8729e-05_r8,2.4137e-05_r8,1.0787e-05_r8/)
      kao(:, 1, 7, 1) = (/ &
     &1.2661e-05_r8,1.3255e-05_r8,1.2476e-05_r8,1.1360e-05_r8,1.0126e-05_r8,8.8167e-06_r8, &
     &7.6811e-06_r8,7.2819e-06_r8,3.4701e-06_r8/)
      kao(:, 2, 7, 1) = (/ &
     &1.6507e-05_r8,1.7720e-05_r8,1.6880e-05_r8,1.5585e-05_r8,1.3986e-05_r8,1.2151e-05_r8, &
     &1.0259e-05_r8,8.9670e-06_r8,4.6214e-06_r8/)
      kao(:, 3, 7, 1) = (/ &
     &2.2311e-05_r8,2.4431e-05_r8,2.3459e-05_r8,2.1822e-05_r8,1.9662e-05_r8,1.7085e-05_r8, &
     &1.4272e-05_r8,1.1641e-05_r8,5.9077e-06_r8/)
      kao(:, 4, 7, 1) = (/ &
     &3.0470e-05_r8,3.3907e-05_r8,3.2735e-05_r8,3.0550e-05_r8,2.7736e-05_r8,2.4159e-05_r8, &
     &2.0093e-05_r8,1.5711e-05_r8,7.6152e-06_r8/)
      kao(:, 5, 7, 1) = (/ &
     &4.1581e-05_r8,4.6778e-05_r8,4.5634e-05_r8,4.2827e-05_r8,3.9000e-05_r8,3.4010e-05_r8, &
     &2.8185e-05_r8,2.1414e-05_r8,9.5151e-06_r8/)
      kao(:, 1, 8, 1) = (/ &
     &2.2110e-05_r8,2.1516e-05_r8,1.9520e-05_r8,1.7197e-05_r8,1.4610e-05_r8,1.1834e-05_r8, &
     &8.9776e-06_r8,6.4038e-06_r8,2.9294e-06_r8/)
      kao(:, 2, 8, 1) = (/ &
     &2.8119e-05_r8,2.7833e-05_r8,2.5591e-05_r8,2.2815e-05_r8,1.9548e-05_r8,1.6035e-05_r8, &
     &1.2291e-05_r8,8.4633e-06_r8,3.7469e-06_r8/)
      kao(:, 3, 8, 1) = (/ &
     &3.7519e-05_r8,3.7575e-05_r8,3.4963e-05_r8,3.1329e-05_r8,2.6989e-05_r8,2.2379e-05_r8, &
     &1.7209e-05_r8,1.1658e-05_r8,5.1343e-06_r8/)
      kao(:, 4, 8, 1) = (/ &
     &5.1233e-05_r8,5.1900e-05_r8,4.8534e-05_r8,4.3661e-05_r8,3.7852e-05_r8,3.1455e-05_r8, &
     &2.4380e-05_r8,1.6303e-05_r8,6.8677e-06_r8/)
      kao(:, 5, 8, 1) = (/ &
     &7.0275e-05_r8,7.1610e-05_r8,6.7129e-05_r8,6.0809e-05_r8,5.2885e-05_r8,4.4177e-05_r8, &
     &3.4435e-05_r8,2.2981e-05_r8,8.8724e-06_r8/)
      kao(:, 1, 9, 1) = (/ &
     &7.5307e-05_r8,6.8982e-05_r8,6.0564e-05_r8,5.1649e-05_r8,4.2335e-05_r8,3.2789e-05_r8, &
     &2.3004e-05_r8,1.2766e-05_r8,4.1976e-06_r8/)
      kao(:, 2, 9, 1) = (/ &
     &9.3306e-05_r8,8.6322e-05_r8,7.6065e-05_r8,6.5167e-05_r8,5.3786e-05_r8,4.2095e-05_r8, &
     &2.9960e-05_r8,1.6892e-05_r8,6.0950e-06_r8/)
      kao(:, 3, 9, 1) = (/ &
     &1.2202e-04_r8,1.1392e-04_r8,1.0068e-04_r8,8.6696e-05_r8,7.2080e-05_r8,5.6739e-05_r8, &
     &4.0820e-05_r8,2.3292e-05_r8,8.3200e-06_r8/)
      kao(:, 4, 9, 1) = (/ &
     &1.6580e-04_r8,1.5570e-04_r8,1.3769e-04_r8,1.1869e-04_r8,9.9119e-05_r8,7.8735e-05_r8, &
     &5.6759e-05_r8,3.2860e-05_r8,1.0538e-05_r8/)
      kao(:, 5, 9, 1) = (/ &
     &2.2845e-04_r8,2.1403e-04_r8,1.8995e-04_r8,1.6428e-04_r8,1.3747e-04_r8,1.0943e-04_r8, &
     &7.9478e-05_r8,4.6333e-05_r8,1.2645e-05_r8/)
      kao(:, 1,10, 1) = (/ &
     &2.9742e-04_r8,2.6515e-04_r8,2.2972e-04_r8,1.9315e-04_r8,1.5610e-04_r8,1.1880e-04_r8, &
     &8.1117e-05_r8,4.2319e-05_r8,6.3944e-06_r8/)
      kao(:, 2,10, 1) = (/ &
     &3.6180e-04_r8,3.2444e-04_r8,2.8214e-04_r8,2.3809e-04_r8,1.9281e-04_r8,1.4714e-04_r8, &
     &1.0099e-04_r8,5.3082e-05_r8,9.7791e-06_r8/)
      kao(:, 3,10, 1) = (/ &
     &4.6752e-04_r8,4.2137e-04_r8,3.6703e-04_r8,3.1031e-04_r8,2.5194e-04_r8,1.9278e-04_r8, &
     &1.3274e-04_r8,7.0692e-05_r8,1.3731e-05_r8/)
      kao(:, 4,10, 1) = (/ &
     &6.3024e-04_r8,5.6976e-04_r8,4.9706e-04_r8,4.2128e-04_r8,3.4229e-04_r8,2.6250e-04_r8, &
     &1.8103e-04_r8,9.7478e-05_r8,1.8873e-05_r8/)
      kao(:, 5,10, 1) = (/ &
     &8.6816e-04_r8,7.8510e-04_r8,6.8602e-04_r8,5.8224e-04_r8,4.7468e-04_r8,3.6394e-04_r8, &
     &2.5185e-04_r8,1.3590e-04_r8,2.4864e-05_r8/)
      kao(:, 1,11, 1) = (/ &
     &4.4215e-04_r8,3.9273e-04_r8,3.3972e-04_r8,2.8576e-04_r8,2.3079e-04_r8,1.7475e-04_r8, &
     &1.1858e-04_r8,6.1576e-05_r8,6.9970e-06_r8/)
      kao(:, 2,11, 1) = (/ &
     &5.4524e-04_r8,4.8624e-04_r8,4.2158e-04_r8,3.5507e-04_r8,2.8728e-04_r8,2.1797e-04_r8, &
     &1.4849e-04_r8,7.7710e-05_r8,1.0796e-05_r8/)
      kao(:, 3,11, 1) = (/ &
     &7.1212e-04_r8,6.3874e-04_r8,5.5491e-04_r8,4.6791e-04_r8,3.7968e-04_r8,2.8946e-04_r8, &
     &1.9751e-04_r8,1.0405e-04_r8,1.6156e-05_r8/)
      kao(:, 4,11, 1) = (/ &
     &9.7112e-04_r8,8.7198e-04_r8,7.5717e-04_r8,6.3918e-04_r8,5.1919e-04_r8,3.9650e-04_r8, &
     &2.7055e-04_r8,1.4272e-04_r8,2.2761e-05_r8/)
      kao(:, 5,11, 1) = (/ &
     &1.3431e-03_r8,1.2076e-03_r8,1.0484e-03_r8,8.8503e-04_r8,7.1868e-04_r8,5.4992e-04_r8, &
     &3.7609e-04_r8,1.9954e-04_r8,2.9940e-05_r8/)
      kao(:, 1,12, 1) = (/ &
     &4.8443e-04_r8,4.2968e-04_r8,3.7109e-04_r8,3.1171e-04_r8,2.5157e-04_r8,1.9045e-04_r8, &
     &1.2868e-04_r8,6.6606e-05_r8,6.8294e-06_r8/)
      kao(:, 2,12, 1) = (/ &
     &6.0269e-04_r8,5.3630e-04_r8,4.6453e-04_r8,3.9092e-04_r8,3.1605e-04_r8,2.4000e-04_r8, &
     &1.6259e-04_r8,8.4751e-05_r8,1.0182e-05_r8/)
      kao(:, 3,12, 1) = (/ &
     &7.9706e-04_r8,7.1250e-04_r8,6.1805e-04_r8,5.2087e-04_r8,4.2192e-04_r8,3.2125e-04_r8, &
     &2.1834e-04_r8,1.1445e-04_r8,1.5140e-05_r8/)
      kao(:, 4,12, 1) = (/ &
     &1.0910e-03_r8,9.7656e-04_r8,8.4711e-04_r8,7.1442e-04_r8,5.7891e-04_r8,4.4221e-04_r8, &
     &3.0181e-04_r8,1.5855e-04_r8,2.1388e-05_r8/)
      kao(:, 5,12, 1) = (/ &
     &1.5134e-03_r8,1.3551e-03_r8,1.1752e-03_r8,9.9093e-04_r8,8.0388e-04_r8,6.1444e-04_r8, &
     &4.2020e-04_r8,2.2117e-04_r8,2.9059e-05_r8/)
      kao(:, 1,13, 1) = (/ &
     &4.2625e-04_r8,3.7812e-04_r8,3.2711e-04_r8,2.7465e-04_r8,2.2177e-04_r8,1.6800e-04_r8, &
     &1.1342e-04_r8,5.8678e-05_r8,7.1193e-06_r8/)
      kao(:, 2,13, 1) = (/ &
     &5.3759e-04_r8,4.7832e-04_r8,4.1433e-04_r8,3.4844e-04_r8,2.8188e-04_r8,2.1423e-04_r8, &
     &1.4519e-04_r8,7.5588e-05_r8,1.0317e-05_r8/)
      kao(:, 3,13, 1) = (/ &
     &7.2018e-04_r8,6.4309e-04_r8,5.5764e-04_r8,4.6948e-04_r8,3.8030e-04_r8,2.8938e-04_r8, &
     &1.9678e-04_r8,1.0285e-04_r8,1.4041e-05_r8/)
      kao(:, 4,13, 1) = (/ &
     &9.8953e-04_r8,8.8546e-04_r8,7.6800e-04_r8,6.4711e-04_r8,5.2450e-04_r8,3.9956e-04_r8, &
     &2.7312e-04_r8,1.4349e-04_r8,1.9954e-05_r8/)
      kao(:, 5,13, 1) = (/ &
     &1.3790e-03_r8,1.2366e-03_r8,1.0731e-03_r8,9.0477e-04_r8,7.3377e-04_r8,5.6037e-04_r8, &
     &3.8365e-04_r8,2.0147e-04_r8,2.6871e-05_r8/)
      kao(:, 1, 1, 2) = (/ &
     &6.2300e-06_r8,2.3124e-05_r8,2.9698e-05_r8,3.9591e-05_r8,5.8380e-05_r8,9.5125e-05_r8, &
     &1.3537e-04_r8,2.8288e-04_r8,9.7543e-05_r8/)
      kao(:, 2, 1, 2) = (/ &
     &9.0246e-06_r8,3.3229e-05_r8,4.2160e-05_r8,4.9478e-05_r8,6.0779e-05_r8,8.5533e-05_r8, &
     &1.5267e-04_r8,2.3904e-04_r8,8.0422e-05_r8/)
      kao(:, 3, 1, 2) = (/ &
     &1.2807e-05_r8,4.6362e-05_r8,5.9074e-05_r8,6.7253e-05_r8,7.5131e-05_r8,8.9889e-05_r8, &
     &1.2494e-04_r8,2.6418e-04_r8,7.9145e-05_r8/)
      kao(:, 4, 1, 2) = (/ &
     &1.7786e-05_r8,6.3031e-05_r8,8.0225e-05_r8,9.3521e-05_r8,1.0301e-04_r8,1.0987e-04_r8, &
     &1.2899e-04_r8,2.0499e-04_r8,1.0830e-04_r8/)
      kao(:, 5, 1, 2) = (/ &
     &2.4116e-05_r8,8.3783e-05_r8,1.0646e-04_r8,1.2431e-04_r8,1.3944e-04_r8,1.5277e-04_r8, &
     &1.5881e-04_r8,2.0933e-04_r8,1.4344e-04_r8/)
      kao(:, 1, 2, 2) = (/ &
     &7.1421e-06_r8,2.2132e-05_r8,2.7590e-05_r8,3.3376e-05_r8,4.3482e-05_r8,6.6128e-05_r8, &
     &9.2521e-05_r8,1.8166e-04_r8,6.3119e-05_r8/)
      kao(:, 2, 2, 2) = (/ &
     &1.0480e-05_r8,3.2273e-05_r8,3.9804e-05_r8,4.4484e-05_r8,4.9766e-05_r8,6.2224e-05_r8, &
     &1.0181e-04_r8,1.6062e-04_r8,5.5112e-05_r8/)
      kao(:, 3, 2, 2) = (/ &
     &1.5069e-05_r8,4.5805e-05_r8,5.6454e-05_r8,6.2730e-05_r8,6.6262e-05_r8,7.1655e-05_r8, &
     &8.8554e-05_r8,1.7608e-04_r8,5.4833e-05_r8/)
      kao(:, 4, 2, 2) = (/ &
     &2.1158e-05_r8,6.3205e-05_r8,7.7534e-05_r8,8.6669e-05_r8,9.2743e-05_r8,9.3710e-05_r8, &
     &9.8368e-05_r8,1.4175e-04_r8,8.3989e-05_r8/)
      kao(:, 5, 2, 2) = (/ &
     &2.9018e-05_r8,8.5014e-05_r8,1.0387e-04_r8,1.1638e-04_r8,1.2535e-04_r8,1.3160e-04_r8, &
     &1.2952e-04_r8,1.4715e-04_r8,1.0168e-04_r8/)
      kao(:, 1, 3, 2) = (/ &
     &1.0134e-05_r8,2.3698e-05_r8,2.8098e-05_r8,3.0832e-05_r8,3.4559e-05_r8,4.2739e-05_r8, &
     &5.8413e-05_r8,1.0086e-04_r8,3.2546e-05_r8/)
      kao(:, 2, 3, 2) = (/ &
     &1.5067e-05_r8,3.5478e-05_r8,4.1782e-05_r8,4.4927e-05_r8,4.6304e-05_r8,4.9338e-05_r8, &
     &6.0952e-05_r8,9.7126e-05_r8,3.2271e-05_r8/)
      kao(:, 3, 3, 2) = (/ &
     &2.2020e-05_r8,5.1526e-05_r8,6.0415e-05_r8,6.4785e-05_r8,6.5815e-05_r8,6.4970e-05_r8, &
     &6.6401e-05_r8,9.8577e-05_r8,3.7377e-05_r8/)
      kao(:, 4, 3, 2) = (/ &
     &3.1402e-05_r8,7.2606e-05_r8,8.4750e-05_r8,9.0680e-05_r8,9.2879e-05_r8,9.1127e-05_r8, &
     &8.5666e-05_r8,9.2372e-05_r8,5.9881e-05_r8/)
      kao(:, 5, 3, 2) = (/ &
     &4.3798e-05_r8,9.9375e-05_r8,1.1577e-04_r8,1.2361e-04_r8,1.2645e-04_r8,1.2543e-04_r8, &
     &1.1954e-04_r8,1.0799e-04_r8,6.6216e-05_r8/)
      kao(:, 1, 4, 2) = (/ &
     &1.4395e-05_r8,2.6113e-05_r8,2.9242e-05_r8,3.0501e-05_r8,3.0825e-05_r8,3.2335e-05_r8, &
     &3.9824e-05_r8,5.5770e-05_r8,1.8987e-05_r8/)
      kao(:, 2, 4, 2) = (/ &
     &2.1448e-05_r8,3.9639e-05_r8,4.4560e-05_r8,4.6391e-05_r8,4.5970e-05_r8,4.4537e-05_r8, &
     &4.5440e-05_r8,6.3416e-05_r8,1.9764e-05_r8/)
      kao(:, 3, 4, 2) = (/ &
     &3.1834e-05_r8,5.8680e-05_r8,6.6149e-05_r8,6.8528e-05_r8,6.7668e-05_r8,6.3937e-05_r8, &
     &5.8285e-05_r8,6.2232e-05_r8,2.7306e-05_r8/)
      kao(:, 4, 4, 2) = (/ &
     &4.6271e-05_r8,8.4438e-05_r8,9.5181e-05_r8,9.8206e-05_r8,9.6873e-05_r8,9.1747e-05_r8, &
     &8.1681e-05_r8,6.9834e-05_r8,3.9615e-05_r8/)
      kao(:, 5, 4, 2) = (/ &
     &6.5671e-05_r8,1.1809e-04_r8,1.3274e-04_r8,1.3673e-04_r8,1.3457e-04_r8,1.2744e-04_r8, &
     &1.1523e-04_r8,9.3255e-05_r8,4.5946e-05_r8/)
      kao(:, 1, 5, 2) = (/ &
     &1.8932e-05_r8,2.8174e-05_r8,3.0127e-05_r8,3.0189e-05_r8,2.9303e-05_r8,2.7710e-05_r8, &
     &2.8724e-05_r8,3.6981e-05_r8,1.2871e-05_r8/)
      kao(:, 2, 5, 2) = (/ &
     &2.8193e-05_r8,4.3103e-05_r8,4.6483e-05_r8,4.6716e-05_r8,4.5184e-05_r8,4.1972e-05_r8, &
     &3.7796e-05_r8,4.2113e-05_r8,1.5002e-05_r8/)
      kao(:, 3, 5, 2) = (/ &
     &4.2171e-05_r8,6.4890e-05_r8,7.0138e-05_r8,7.0754e-05_r8,6.8197e-05_r8,6.2875e-05_r8, &
     &5.4545e-05_r8,4.7871e-05_r8,1.9971e-05_r8/)
      kao(:, 4, 5, 2) = (/ &
     &6.2206e-05_r8,9.5463e-05_r8,1.0284e-04_r8,1.0393e-04_r8,9.9869e-05_r8,9.1904e-05_r8, &
     &7.9592e-05_r8,6.1772e-05_r8,2.7676e-05_r8/)
      kao(:, 5, 5, 2) = (/ &
     &8.9897e-05_r8,1.3643e-04_r8,1.4635e-04_r8,1.4773e-04_r8,1.4191e-04_r8,1.3018e-04_r8, &
     &1.1303e-04_r8,8.6827e-05_r8,3.3409e-05_r8/)
      kao(:, 1, 6, 2) = (/ &
     &2.3688e-05_r8,3.0481e-05_r8,3.1060e-05_r8,3.0054e-05_r8,2.7961e-05_r8,2.5367e-05_r8, &
     &2.2999e-05_r8,2.6629e-05_r8,1.0275e-05_r8/)
      kao(:, 2, 6, 2) = (/ &
     &3.4582e-05_r8,4.5983e-05_r8,4.7133e-05_r8,4.6002e-05_r8,4.3141e-05_r8,3.8854e-05_r8, &
     &3.3303e-05_r8,2.9897e-05_r8,1.2224e-05_r8/)
      kao(:, 3, 6, 2) = (/ &
     &5.1699e-05_r8,6.9356e-05_r8,7.1684e-05_r8,7.0505e-05_r8,6.6405e-05_r8,5.9819e-05_r8, &
     &5.0541e-05_r8,3.9074e-05_r8,1.6179e-05_r8/)
      kao(:, 4, 6, 2) = (/ &
     &7.7368e-05_r8,1.0342e-04_r8,1.0714e-04_r8,1.0541e-04_r8,9.9595e-05_r8,8.9603e-05_r8, &
     &7.5459e-05_r8,5.5384e-05_r8,2.1206e-05_r8/)
      kao(:, 5, 6, 2) = (/ &
     &1.1347e-04_r8,1.5064e-04_r8,1.5637e-04_r8,1.5316e-04_r8,1.4449e-04_r8,1.2985e-04_r8, &
     &1.0910e-04_r8,8.0324e-05_r8,2.6862e-05_r8/)
      kao(:, 1, 7, 2) = (/ &
     &3.2355e-05_r8,3.6612e-05_r8,3.5642e-05_r8,3.3581e-05_r8,3.0393e-05_r8,2.6088e-05_r8, &
     &2.1415e-05_r8,1.9368e-05_r8,9.5314e-06_r8/)
      kao(:, 2, 7, 2) = (/ &
     &4.6022e-05_r8,5.3816e-05_r8,5.2843e-05_r8,4.9963e-05_r8,4.5493e-05_r8,3.9581e-05_r8, &
     &3.2262e-05_r8,2.4294e-05_r8,1.1772e-05_r8/)
      kao(:, 3, 7, 2) = (/ &
     &6.7685e-05_r8,8.0405e-05_r8,7.9935e-05_r8,7.5649e-05_r8,6.9218e-05_r8,6.0527e-05_r8, &
     &4.9342e-05_r8,3.5155e-05_r8,1.4463e-05_r8/)
      kao(:, 4, 7, 2) = (/ &
     &1.0120e-04_r8,1.2036e-04_r8,1.2034e-04_r8,1.1418e-04_r8,1.0434e-04_r8,9.1774e-05_r8, &
     &7.5257e-05_r8,5.2793e-05_r8,1.8375e-05_r8/)
      kao(:, 5, 7, 2) = (/ &
     &1.5071e-04_r8,1.7822e-04_r8,1.7733e-04_r8,1.6840e-04_r8,1.5410e-04_r8,1.3584e-04_r8, &
     &1.1141e-04_r8,7.8080e-05_r8,2.3868e-05_r8/)
      kao(:, 1, 8, 2) = (/ &
     &5.5226e-05_r8,5.6106e-05_r8,5.2275e-05_r8,4.7400e-05_r8,4.1299e-05_r8,3.4449e-05_r8, &
     &2.6593e-05_r8,1.7838e-05_r8,1.0224e-05_r8/)
      kao(:, 2, 8, 2) = (/ &
     &7.6682e-05_r8,7.9501e-05_r8,7.4950e-05_r8,6.8270e-05_r8,5.9838e-05_r8,5.0360e-05_r8, &
     &3.9211e-05_r8,2.5644e-05_r8,1.3679e-05_r8/)
      kao(:, 3, 8, 2) = (/ &
     &1.1162e-04_r8,1.1744e-04_r8,1.1105e-04_r8,1.0166e-04_r8,8.9544e-05_r8,7.5446e-05_r8, &
     &5.9105e-05_r8,3.8912e-05_r8,1.6924e-05_r8/)
      kao(:, 4, 8, 2) = (/ &
     &1.6426e-04_r8,1.7413e-04_r8,1.6536e-04_r8,1.5206e-04_r8,1.3480e-04_r8,1.1398e-04_r8, &
     &8.9434e-05_r8,5.9125e-05_r8,2.1439e-05_r8/)
      kao(:, 5, 8, 2) = (/ &
     &2.4317e-04_r8,2.5868e-04_r8,2.4524e-04_r8,2.2533e-04_r8,2.0048e-04_r8,1.6943e-04_r8, &
     &1.3297e-04_r8,8.8280e-05_r8,2.6395e-05_r8/)
      kao(:, 1, 9, 2) = (/ &
     &1.8480e-04_r8,1.7106e-04_r8,1.5192e-04_r8,1.3086e-04_r8,1.0905e-04_r8,8.6158e-05_r8, &
     &6.2340e-05_r8,3.6177e-05_r8,1.4903e-05_r8/)
      kao(:, 2, 9, 2) = (/ &
     &2.4641e-04_r8,2.3135e-04_r8,2.0759e-04_r8,1.8017e-04_r8,1.5122e-04_r8,1.2054e-04_r8, &
     &8.8111e-05_r8,5.2211e-05_r8,2.0425e-05_r8/)
      kao(:, 3, 9, 2) = (/ &
     &3.5294e-04_r8,3.3406e-04_r8,3.0047e-04_r8,2.6193e-04_r8,2.2100e-04_r8,1.7727e-04_r8, &
     &1.3000e-04_r8,7.7386e-05_r8,2.5956e-05_r8/)
      kao(:, 4, 9, 2) = (/ &
     &5.2033e-04_r8,4.9504e-04_r8,4.4640e-04_r8,3.9034e-04_r8,3.2978e-04_r8,2.6409e-04_r8, &
     &1.9434e-04_r8,1.1587e-04_r8,3.4101e-05_r8/)
      kao(:, 5, 9, 2) = (/ &
     &7.6495e-04_r8,7.3083e-04_r8,6.5854e-04_r8,5.7617e-04_r8,4.8713e-04_r8,3.9080e-04_r8, &
     &2.8811e-04_r8,1.7251e-04_r8,4.3686e-05_r8/)
      kao(:, 1,10, 2) = (/ &
     &7.1951e-04_r8,6.4170e-04_r8,5.5848e-04_r8,4.7254e-04_r8,3.8543e-04_r8,2.9616e-04_r8, &
     &2.0442e-04_r8,1.0914e-04_r8,2.8683e-05_r8/)
      kao(:, 2,10, 2) = (/ &
     &9.5077e-04_r8,8.5141e-04_r8,7.4327e-04_r8,6.3053e-04_r8,5.1626e-04_r8,3.9828e-04_r8, &
     &2.7613e-04_r8,1.4913e-04_r8,3.8199e-05_r8/)
      kao(:, 3,10, 2) = (/ &
     &1.3355e-03_r8,1.2001e-03_r8,1.0504e-03_r8,8.9360e-04_r8,7.3324e-04_r8,5.6715e-04_r8, &
     &3.9425e-04_r8,2.1480e-04_r8,4.7134e-05_r8/)
      kao(:, 4,10, 2) = (/ &
     &1.9553e-03_r8,1.7643e-03_r8,1.5470e-03_r8,1.3173e-03_r8,1.0803e-03_r8,8.3446e-04_r8, &
     &5.8166e-04_r8,3.1871e-04_r8,5.8212e-05_r8/)
      kao(:, 5,10, 2) = (/ &
     &2.8783e-03_r8,2.5953e-03_r8,2.2770e-03_r8,1.9407e-03_r8,1.5909e-03_r8,1.2316e-03_r8, &
     &8.6003e-04_r8,4.7307e-04_r8,7.1136e-05_r8/)
      kao(:, 1,11, 2) = (/ &
     &1.1139e-03_r8,9.8774e-04_r8,8.5580e-04_r8,7.2091e-04_r8,5.8416e-04_r8,4.4688e-04_r8, &
     &3.0678e-04_r8,1.6222e-04_r8,3.9161e-05_r8/)
      kao(:, 2,11, 2) = (/ &
     &1.5083e-03_r8,1.3423e-03_r8,1.1649e-03_r8,9.8455e-04_r8,8.0047e-04_r8,6.1397e-04_r8, &
     &4.2291e-04_r8,2.2482e-04_r8,5.4701e-05_r8/)
      kao(:, 3,11, 2) = (/ &
     &2.1559e-03_r8,1.9181e-03_r8,1.6686e-03_r8,1.4112e-03_r8,1.1484e-03_r8,8.7957e-04_r8, &
     &6.0584e-04_r8,3.2346e-04_r8,6.6564e-05_r8/)
      kao(:, 4,11, 2) = (/ &
     &3.1472e-03_r8,2.8085e-03_r8,2.4474e-03_r8,2.0740e-03_r8,1.6883e-03_r8,1.2953e-03_r8, &
     &8.9345e-04_r8,4.7890e-04_r8,8.3118e-05_r8/)
      kao(:, 5,11, 2) = (/ &
     &4.6362e-03_r8,4.1388e-03_r8,3.6072e-03_r8,3.0601e-03_r8,2.4938e-03_r8,1.9129e-03_r8, &
     &1.3182e-03_r8,7.0366e-04_r8,1.0053e-04_r8/)
      kao(:, 1,12, 2) = (/ &
     &1.2746e-03_r8,1.1293e-03_r8,9.7744e-04_r8,8.2280e-04_r8,6.6509e-04_r8,5.0694e-04_r8, &
     &3.4671e-04_r8,1.8255e-04_r8,4.0437e-05_r8/)
      kao(:, 2,12, 2) = (/ &
     &1.7556e-03_r8,1.5589e-03_r8,1.3508e-03_r8,1.1390e-03_r8,9.2389e-04_r8,7.0640e-04_r8, &
     &4.8477e-04_r8,2.5611e-04_r8,5.8338e-05_r8/)
      kao(:, 3,12, 2) = (/ &
     &2.5208e-03_r8,2.2390e-03_r8,1.9427e-03_r8,1.6407e-03_r8,1.3325e-03_r8,1.0177e-03_r8, &
     &6.9952e-04_r8,3.6990e-04_r8,7.2977e-05_r8/)
      kao(:, 4,12, 2) = (/ &
     &3.7199e-03_r8,3.3065e-03_r8,2.8736e-03_r8,2.4286e-03_r8,1.9715e-03_r8,1.5043e-03_r8, &
     &1.0308e-03_r8,5.4613e-04_r8,9.0596e-05_r8/)
      kao(:, 5,12, 2) = (/ &
     &5.4892e-03_r8,4.8847e-03_r8,4.2441e-03_r8,3.5888e-03_r8,2.9119e-03_r8,2.2221e-03_r8, &
     &1.5249e-03_r8,8.0704e-04_r8,1.1205e-04_r8/)
      kao(:, 1,13, 2) = (/ &
     &1.1670e-03_r8,1.0343e-03_r8,8.9403e-04_r8,7.5206e-04_r8,6.0815e-04_r8,4.6361e-04_r8, &
     &3.1684e-04_r8,1.6665e-04_r8,3.8297e-05_r8/)
      kao(:, 2,13, 2) = (/ &
     &1.6263e-03_r8,1.4448e-03_r8,1.2518e-03_r8,1.0548e-03_r8,8.5537e-04_r8,6.5308e-04_r8, &
     &4.4734e-04_r8,2.3634e-04_r8,5.4012e-05_r8/)
      kao(:, 3,13, 2) = (/ &
     &2.3576e-03_r8,2.0975e-03_r8,1.8201e-03_r8,1.5368e-03_r8,1.2479e-03_r8,9.5295e-04_r8, &
     &6.5303e-04_r8,3.4532e-04_r8,6.8858e-05_r8/)
      kao(:, 4,13, 2) = (/ &
     &3.5158e-03_r8,3.1277e-03_r8,2.7158e-03_r8,2.2939e-03_r8,1.8617e-03_r8,1.4210e-03_r8, &
     &9.7237e-04_r8,5.1302e-04_r8,8.6284e-05_r8/)
      kao(:, 5,13, 2) = (/ &
     &5.1868e-03_r8,4.6126e-03_r8,4.0043e-03_r8,3.3796e-03_r8,2.7407e-03_r8,2.0921e-03_r8, &
     &1.4302e-03_r8,7.5554e-04_r8,1.0703e-04_r8/)
      kao(:, 1, 1, 3) = (/ &
     &2.1967e-05_r8,7.0847e-05_r8,9.8056e-05_r8,1.1683e-04_r8,1.2672e-04_r8,1.3386e-04_r8, &
     &1.7335e-04_r8,3.0889e-04_r8,1.4104e-04_r8/)
      kao(:, 2, 1, 3) = (/ &
     &3.2805e-05_r8,1.0021e-04_r8,1.3719e-04_r8,1.6469e-04_r8,1.8755e-04_r8,2.0275e-04_r8, &
     &1.9715e-04_r8,2.9590e-04_r8,1.6430e-04_r8/)
      kao(:, 3, 1, 3) = (/ &
     &4.7330e-05_r8,1.3749e-04_r8,1.8575e-04_r8,2.2309e-04_r8,2.5257e-04_r8,2.7701e-04_r8, &
     &3.0293e-04_r8,3.2277e-04_r8,1.5833e-04_r8/)
      kao(:, 4, 1, 3) = (/ &
     &6.6184e-05_r8,1.8358e-04_r8,2.4505e-04_r8,2.9115e-04_r8,3.2275e-04_r8,3.3970e-04_r8, &
     &3.6327e-04_r8,4.7032e-04_r8,1.5296e-04_r8/)
      kao(:, 5, 1, 3) = (/ &
     &8.9953e-05_r8,2.3845e-04_r8,3.1568e-04_r8,3.7021e-04_r8,4.0111e-04_r8,4.1250e-04_r8, &
     &4.1712e-04_r8,4.9013e-04_r8,1.7116e-04_r8/)
      kao(:, 1, 2, 3) = (/ &
     &2.6480e-05_r8,6.7795e-05_r8,8.8273e-05_r8,1.0239e-04_r8,1.1087e-04_r8,1.1252e-04_r8, &
     &1.2626e-04_r8,1.7765e-04_r8,1.0235e-04_r8/)
      kao(:, 2, 2, 3) = (/ &
     &4.0229e-05_r8,9.8115e-05_r8,1.2639e-04_r8,1.4693e-04_r8,1.6171e-04_r8,1.7149e-04_r8, &
     &1.6078e-04_r8,2.0296e-04_r8,1.0513e-04_r8/)
      kao(:, 3, 2, 3) = (/ &
     &5.9019e-05_r8,1.3751e-04_r8,1.7468e-04_r8,2.0166e-04_r8,2.2223e-04_r8,2.3730e-04_r8, &
     &2.4647e-04_r8,2.3569e-04_r8,1.0639e-04_r8/)
      kao(:, 4, 2, 3) = (/ &
     &8.3741e-05_r8,1.8682e-04_r8,2.3419e-04_r8,2.6910e-04_r8,2.9309e-04_r8,3.0629e-04_r8, &
     &3.1256e-04_r8,3.4516e-04_r8,1.0584e-04_r8/)
      kao(:, 5, 2, 3) = (/ &
     &1.1534e-04_r8,2.4682e-04_r8,3.0598e-04_r8,3.4903e-04_r8,3.7559e-04_r8,3.8169e-04_r8, &
     &3.7221e-04_r8,3.8365e-04_r8,1.2786e-04_r8/)
      kao(:, 1, 3, 3) = (/ &
     &3.8574e-05_r8,7.5157e-05_r8,8.9382e-05_r8,9.8254e-05_r8,1.0233e-04_r8,1.0063e-04_r8, &
     &1.0056e-04_r8,1.0870e-04_r8,6.8446e-05_r8/)
      kao(:, 2, 3, 3) = (/ &
     &6.0142e-05_r8,1.1264e-04_r8,1.3244e-04_r8,1.4504e-04_r8,1.5242e-04_r8,1.5259e-04_r8, &
     &1.4806e-04_r8,1.3730e-04_r8,6.4347e-05_r8/)
      kao(:, 3, 3, 3) = (/ &
     &9.0381e-05_r8,1.6247e-04_r8,1.8926e-04_r8,2.0538e-04_r8,2.1407e-04_r8,2.1609e-04_r8, &
     &2.1113e-04_r8,1.9332e-04_r8,6.7739e-05_r8/)
      kao(:, 4, 3, 3) = (/ &
     &1.3106e-04_r8,2.2712e-04_r8,2.6180e-04_r8,2.8099e-04_r8,2.9092e-04_r8,2.9292e-04_r8, &
     &2.8375e-04_r8,2.7092e-04_r8,6.8866e-05_r8/)
      kao(:, 5, 3, 3) = (/ &
     &1.8403e-04_r8,3.0884e-04_r8,3.5100e-04_r8,3.7380e-04_r8,3.8510e-04_r8,3.8362e-04_r8, &
     &3.6289e-04_r8,3.2300e-04_r8,9.2758e-05_r8/)
      kao(:, 1, 4, 3) = (/ &
     &5.4705e-05_r8,8.6072e-05_r8,9.6209e-05_r8,1.0034e-04_r8,9.9953e-05_r8,9.5189e-05_r8, &
     &8.3161e-05_r8,7.9207e-05_r8,3.9423e-05_r8/)
      kao(:, 2, 4, 3) = (/ &
     &8.7751e-05_r8,1.3347e-04_r8,1.4769e-04_r8,1.5271e-04_r8,1.5230e-04_r8,1.4652e-04_r8, &
     &1.3316e-04_r8,1.0796e-04_r8,4.2482e-05_r8/)
      kao(:, 3, 4, 3) = (/ &
     &1.3536e-04_r8,1.9949e-04_r8,2.1780e-04_r8,2.2400e-04_r8,2.2194e-04_r8,2.1254e-04_r8, &
     &1.9475e-04_r8,1.6332e-04_r8,4.5138e-05_r8/)
      kao(:, 4, 4, 3) = (/ &
     &2.0116e-04_r8,2.8783e-04_r8,3.1041e-04_r8,3.1735e-04_r8,3.1196e-04_r8,2.9572e-04_r8, &
     &2.7052e-04_r8,2.3211e-04_r8,5.0851e-05_r8/)
      kao(:, 5, 4, 3) = (/ &
     &2.8895e-04_r8,4.0188e-04_r8,4.2924e-04_r8,4.3500e-04_r8,4.2412e-04_r8,3.9959e-04_r8, &
     &3.6227e-04_r8,3.0072e-04_r8,6.6760e-05_r8/)
      kao(:, 1, 5, 3) = (/ &
     &7.0137e-05_r8,9.4755e-05_r8,1.0063e-04_r8,1.0127e-04_r8,9.8061e-05_r8,9.0698e-05_r8, &
     &7.7439e-05_r8,5.9138e-05_r8,2.6683e-05_r8/)
      kao(:, 2, 5, 3) = (/ &
     &1.1533e-04_r8,1.5194e-04_r8,1.5997e-04_r8,1.5979e-04_r8,1.5340e-04_r8,1.4208e-04_r8, &
     &1.2486e-04_r8,9.3241e-05_r8,2.9592e-05_r8/)
      kao(:, 3, 5, 3) = (/ &
     &1.8276e-04_r8,2.3503e-04_r8,2.4432e-04_r8,2.4189e-04_r8,2.3109e-04_r8,2.1296e-04_r8, &
     &1.8693e-04_r8,1.4538e-04_r8,3.2790e-05_r8/)
      kao(:, 4, 5, 3) = (/ &
     &2.7903e-04_r8,3.5030e-04_r8,3.5953e-04_r8,3.5303e-04_r8,3.3542e-04_r8,3.0702e-04_r8, &
     &2.6606e-04_r8,2.0930e-04_r8,3.9551e-05_r8/)
      kao(:, 5, 5, 3) = (/ &
     &4.1070e-04_r8,5.0357e-04_r8,5.1208e-04_r8,4.9861e-04_r8,4.7008e-04_r8,4.2683e-04_r8, &
     &3.6701e-04_r8,2.8592e-04_r8,5.1146e-05_r8/)
      kao(:, 1, 6, 3) = (/ &
     &8.1368e-05_r8,9.8431e-05_r8,1.0007e-04_r8,9.7542e-05_r8,9.2017e-05_r8,8.3169e-05_r8, &
     &7.0090e-05_r8,4.8919e-05_r8,2.1156e-05_r8/)
      kao(:, 2, 6, 3) = (/ &
     &1.3706e-04_r8,1.6300e-04_r8,1.6503e-04_r8,1.5990e-04_r8,1.4992e-04_r8,1.3472e-04_r8, &
     &1.1399e-04_r8,8.3619e-05_r8,2.5058e-05_r8/)
      kao(:, 3, 6, 3) = (/ &
     &2.2338e-04_r8,2.6147e-04_r8,2.6146e-04_r8,2.5118e-04_r8,2.3339e-04_r8,2.0831e-04_r8, &
     &1.7568e-04_r8,1.3135e-04_r8,2.8387e-05_r8/)
      kao(:, 4, 6, 3) = (/ &
     &3.5127e-04_r8,4.0389e-04_r8,3.9905e-04_r8,3.7918e-04_r8,3.4971e-04_r8,3.1035e-04_r8, &
     &2.5984e-04_r8,1.9266e-04_r8,3.2799e-05_r8/)
      kao(:, 5, 6, 3) = (/ &
     &5.3129e-04_r8,6.0001e-04_r8,5.8622e-04_r8,5.5309e-04_r8,5.0577e-04_r8,4.4569e-04_r8, &
     &3.6955e-04_r8,2.7080e-04_r8,4.1496e-05_r8/)
      kao(:, 1, 7, 3) = (/ &
     &1.0007e-04_r8,1.0969e-04_r8,1.0696e-04_r8,1.0012e-04_r8,9.0860e-05_r8,7.9591e-05_r8, &
     &6.5272e-05_r8,4.4404e-05_r8,1.8023e-05_r8/)
      kao(:, 2, 7, 3) = (/ &
     &1.6864e-04_r8,1.8414e-04_r8,1.7903e-04_r8,1.6759e-04_r8,1.5212e-04_r8,1.3294e-04_r8, &
     &1.0932e-04_r8,7.7110e-05_r8,2.3161e-05_r8/)
      kao(:, 3, 7, 3) = (/ &
     &2.8238e-04_r8,3.0439e-04_r8,2.9352e-04_r8,2.7330e-04_r8,2.4706e-04_r8,2.1459e-04_r8, &
     &1.7451e-04_r8,1.2351e-04_r8,2.8855e-05_r8/)
      kao(:, 4, 7, 3) = (/ &
     &4.5659e-04_r8,4.8716e-04_r8,4.6539e-04_r8,4.2996e-04_r8,3.8506e-04_r8,3.3112e-04_r8, &
     &2.6671e-04_r8,1.8725e-04_r8,3.4923e-05_r8/)
      kao(:, 5, 7, 3) = (/ &
     &7.1027e-04_r8,7.4800e-04_r8,7.1021e-04_r8,6.5078e-04_r8,5.7777e-04_r8,4.9194e-04_r8, &
     &3.9297e-04_r8,2.7155e-04_r8,4.1495e-05_r8/)
      kao(:, 1, 8, 3) = (/ &
     &1.5946e-04_r8,1.5842e-04_r8,1.4746e-04_r8,1.3211e-04_r8,1.1546e-04_r8,9.6168e-05_r8, &
     &7.4324e-05_r8,4.8395e-05_r8,1.7989e-05_r8/)
      kao(:, 2, 8, 3) = (/ &
     &2.5770e-04_r8,2.5704e-04_r8,2.3941e-04_r8,2.1551e-04_r8,1.8837e-04_r8,1.5713e-04_r8, &
     &1.2214e-04_r8,8.1368e-05_r8,2.3968e-05_r8/)
      kao(:, 3, 8, 3) = (/ &
     &4.2472e-04_r8,4.2443e-04_r8,3.9713e-04_r8,3.5763e-04_r8,3.1122e-04_r8,2.5901e-04_r8, &
     &2.0043e-04_r8,1.3331e-04_r8,3.2118e-05_r8/)
      kao(:, 4, 8, 3) = (/ &
     &7.0597e-04_r8,6.9998e-04_r8,6.4911e-04_r8,5.8037e-04_r8,5.0147e-04_r8,4.1570e-04_r8, &
     &3.1990e-04_r8,2.0974e-04_r8,3.9608e-05_r8/)
      kao(:, 5, 8, 3) = (/ &
     &1.1264e-03_r8,1.1057e-03_r8,1.0236e-03_r8,9.1299e-04_r8,7.8475e-04_r8,6.4516e-04_r8, &
     &4.9155e-04_r8,3.1715e-04_r8,4.8541e-05_r8/)
      kao(:, 1, 9, 3) = (/ &
     &5.0227e-04_r8,4.5998e-04_r8,4.0915e-04_r8,3.5429e-04_r8,2.9541e-04_r8,2.3264e-04_r8, &
     &1.6588e-04_r8,9.6165e-05_r8,2.6165e-05_r8/)
      kao(:, 2, 9, 3) = (/ &
     &7.8676e-04_r8,7.2202e-04_r8,6.4423e-04_r8,5.5868e-04_r8,4.6624e-04_r8,3.6840e-04_r8, &
     &2.6387e-04_r8,1.5409e-04_r8,3.5446e-05_r8/)
      kao(:, 3, 9, 3) = (/ &
     &1.2789e-03_r8,1.1712e-03_r8,1.0462e-03_r8,9.0711e-04_r8,7.5900e-04_r8,5.9930e-04_r8, &
     &4.3043e-04_r8,2.5008e-04_r8,4.6358e-05_r8/)
      kao(:, 4, 9, 3) = (/ &
     &2.0840e-03_r8,1.9016e-03_r8,1.6924e-03_r8,1.4648e-03_r8,1.2215e-03_r8,9.6366e-04_r8, &
     &6.9084e-04_r8,4.0072e-04_r8,6.1001e-05_r8/)
      kao(:, 5, 9, 3) = (/ &
     &3.3367e-03_r8,3.0441e-03_r8,2.7105e-03_r8,2.3462e-03_r8,1.9558e-03_r8,1.5435e-03_r8, &
     &1.1056e-03_r8,6.3552e-04_r8,7.9035e-05_r8/)
      kao(:, 1,10, 3) = (/ &
     &1.9385e-03_r8,1.7157e-03_r8,1.4863e-03_r8,1.2534e-03_r8,1.0193e-03_r8,7.7905e-04_r8, &
     &5.3570e-04_r8,2.8621e-04_r8,4.8614e-05_r8/)
      kao(:, 2,10, 3) = (/ &
     &2.9395e-03_r8,2.6008e-03_r8,2.2566e-03_r8,1.9073e-03_r8,1.5534e-03_r8,1.1938e-03_r8, &
     &8.2332e-04_r8,4.4169e-04_r8,7.1291e-05_r8/)
      kao(:, 3,10, 3) = (/ &
     &4.6962e-03_r8,4.1509e-03_r8,3.6037e-03_r8,3.0461e-03_r8,2.4817e-03_r8,1.9064e-03_r8, &
     &1.3190e-03_r8,7.0872e-04_r8,9.5825e-05_r8/)
      kao(:, 4,10, 3) = (/ &
     &7.5852e-03_r8,6.6994e-03_r8,5.8186e-03_r8,4.9195e-03_r8,4.0087e-03_r8,3.0812e-03_r8, &
     &2.1247e-03_r8,1.1368e-03_r8,1.1801e-04_r8/)
      kao(:, 5,10, 3) = (/ &
     &1.2000e-02_r8,1.0601e-02_r8,9.2089e-03_r8,7.7807e-03_r8,6.3408e-03_r8,4.8692e-03_r8, &
     &3.3607e-03_r8,1.8001e-03_r8,1.5301e-04_r8/)
      kao(:, 1,11, 3) = (/ &
     &3.1614e-03_r8,2.7883e-03_r8,2.4150e-03_r8,2.0359e-03_r8,1.6451e-03_r8,1.2526e-03_r8, &
     &8.5416e-04_r8,4.4797e-04_r8,5.8064e-05_r8/)
      kao(:, 2,11, 3) = (/ &
     &4.7730e-03_r8,4.2097e-03_r8,3.6498e-03_r8,3.0671e-03_r8,2.4809e-03_r8,1.8948e-03_r8, &
     &1.2977e-03_r8,6.8686e-04_r8,8.3754e-05_r8/)
      kao(:, 3,11, 3) = (/ &
     &7.6614e-03_r8,6.7521e-03_r8,5.8435e-03_r8,4.9093e-03_r8,3.9758e-03_r8,3.0351e-03_r8, &
     &2.0807e-03_r8,1.0948e-03_r8,1.2253e-04_r8/)
      kao(:, 4,11, 3) = (/ &
     &1.2246e-02_r8,1.0785e-02_r8,9.3301e-03_r8,7.8482e-03_r8,6.3562e-03_r8,4.8536e-03_r8, &
     &3.3260e-03_r8,1.7481e-03_r8,1.5741e-04_r8/)
      kao(:, 5,11, 3) = (/ &
     &1.9021e-02_r8,1.6750e-02_r8,1.4500e-02_r8,1.2206e-02_r8,9.8921e-03_r8,7.5567e-03_r8, &
     &5.1767e-03_r8,2.7251e-03_r8,2.0052e-04_r8/)
      kao(:, 1,12, 3) = (/ &
     &3.8826e-03_r8,3.4185e-03_r8,2.9574e-03_r8,2.4900e-03_r8,2.0123e-03_r8,1.5298e-03_r8, &
     &1.0368e-03_r8,5.3904e-04_r8,6.3688e-05_r8/)
      kao(:, 2,12, 3) = (/ &
     &5.8362e-03_r8,5.1381e-03_r8,4.4457e-03_r8,3.7372e-03_r8,3.0206e-03_r8,2.2947e-03_r8, &
     &1.5681e-03_r8,8.2298e-04_r8,8.9290e-05_r8/)
      kao(:, 3,12, 3) = (/ &
     &9.2251e-03_r8,8.1210e-03_r8,7.0237e-03_r8,5.8967e-03_r8,4.7688e-03_r8,3.6322e-03_r8, &
     &2.4807e-03_r8,1.3032e-03_r8,1.3416e-04_r8/)
      kao(:, 4,12, 3) = (/ &
     &1.4709e-02_r8,1.2946e-02_r8,1.1191e-02_r8,9.4045e-03_r8,7.5956e-03_r8,5.7870e-03_r8, &
     &3.9575e-03_r8,2.0727e-03_r8,1.8001e-04_r8/)
      kao(:, 5,12, 3) = (/ &
     &2.2619e-02_r8,1.9908e-02_r8,1.7216e-02_r8,1.4475e-02_r8,1.1703e-02_r8,8.9157e-03_r8, &
     &6.0792e-03_r8,3.1754e-03_r8,2.2086e-04_r8/)
      kao(:, 1,13, 3) = (/ &
     &3.8309e-03_r8,3.3731e-03_r8,2.9187e-03_r8,2.4542e-03_r8,1.9844e-03_r8,1.5107e-03_r8, &
     &1.0279e-03_r8,5.3642e-04_r8,6.4942e-05_r8/)
      kao(:, 2,13, 3) = (/ &
     &5.8347e-03_r8,5.1376e-03_r8,4.4461e-03_r8,3.7352e-03_r8,3.0197e-03_r8,2.2950e-03_r8, &
     &1.5588e-03_r8,8.1629e-04_r8,9.2767e-05_r8/)
      kao(:, 3,13, 3) = (/ &
     &9.2194e-03_r8,8.1162e-03_r8,7.0173e-03_r8,5.8930e-03_r8,4.7598e-03_r8,3.6175e-03_r8, &
     &2.4591e-03_r8,1.2857e-03_r8,1.3288e-04_r8/)
      kao(:, 4,13, 3) = (/ &
     &1.4386e-02_r8,1.2666e-02_r8,1.0949e-02_r8,9.1979e-03_r8,7.4294e-03_r8,5.6460e-03_r8, &
     &3.8493e-03_r8,2.0075e-03_r8,1.7458e-04_r8/)
      kao(:, 5,13, 3) = (/ &
     &2.1887e-02_r8,1.9271e-02_r8,1.6664e-02_r8,1.4007e-02_r8,1.1332e-02_r8,8.6132e-03_r8, &
     &5.8543e-03_r8,3.0399e-03_r8,2.1866e-04_r8/)
      kao(:, 1, 1, 4) = (/ &
     &1.2767e-04_r8,2.6436e-04_r8,3.0512e-04_r8,3.1799e-04_r8,3.1958e-04_r8,3.3191e-04_r8, &
     &3.9104e-04_r8,5.0710e-04_r8,1.7855e-04_r8/)
      kao(:, 2, 1, 4) = (/ &
     &1.7738e-04_r8,3.5053e-04_r8,3.9839e-04_r8,4.1229e-04_r8,4.0492e-04_r8,3.8983e-04_r8, &
     &4.1500e-04_r8,5.9614e-04_r8,1.6036e-04_r8/)
      kao(:, 3, 1, 4) = (/ &
     &2.3686e-04_r8,4.4965e-04_r8,5.0544e-04_r8,5.1877e-04_r8,5.0600e-04_r8,4.7740e-04_r8, &
     &4.5052e-04_r8,5.7236e-04_r8,1.8787e-04_r8/)
      kao(:, 4, 1, 4) = (/ &
     &3.0650e-04_r8,5.6569e-04_r8,6.3165e-04_r8,6.4530e-04_r8,6.3512e-04_r8,6.1237e-04_r8, &
     &5.6656e-04_r8,5.2891e-04_r8,2.7469e-04_r8/)
      kao(:, 5, 1, 4) = (/ &
     &3.8512e-04_r8,6.9752e-04_r8,7.7525e-04_r8,7.9245e-04_r8,7.8883e-04_r8,7.7085e-04_r8, &
     &7.4060e-04_r8,6.7719e-04_r8,3.6282e-04_r8/)
      kao(:, 1, 2, 4) = (/ &
     &1.5390e-04_r8,2.7494e-04_r8,3.1261e-04_r8,3.2023e-04_r8,3.1151e-04_r8,2.9547e-04_r8, &
     &3.1497e-04_r8,3.9039e-04_r8,1.0989e-04_r8/)
      kao(:, 2, 2, 4) = (/ &
     &2.1714e-04_r8,3.7453e-04_r8,4.1638e-04_r8,4.2413e-04_r8,4.1007e-04_r8,3.7857e-04_r8, &
     &3.5354e-04_r8,4.2401e-04_r8,1.1763e-04_r8/)
      kao(:, 3, 2, 4) = (/ &
     &2.9352e-04_r8,4.8938e-04_r8,5.3784e-04_r8,5.4431e-04_r8,5.2257e-04_r8,4.7749e-04_r8, &
     &4.2355e-04_r8,4.2211e-04_r8,1.4157e-04_r8/)
      kao(:, 4, 2, 4) = (/ &
     &3.8348e-04_r8,6.2214e-04_r8,6.8003e-04_r8,6.8421e-04_r8,6.5590e-04_r8,6.0605e-04_r8, &
     &5.3467e-04_r8,4.5064e-04_r8,2.0612e-04_r8/)
      kao(:, 5, 2, 4) = (/ &
     &4.8704e-04_r8,7.7618e-04_r8,8.4540e-04_r8,8.4784e-04_r8,8.1484e-04_r8,7.6245e-04_r8, &
     &6.8894e-04_r8,5.8453e-04_r8,2.7190e-04_r8/)
      kao(:, 1, 3, 4) = (/ &
     &2.3071e-04_r8,3.3499e-04_r8,3.6845e-04_r8,3.7270e-04_r8,3.5547e-04_r8,3.2203e-04_r8, &
     &2.7656e-04_r8,2.6506e-04_r8,6.2779e-05_r8/)
      kao(:, 2, 3, 4) = (/ &
     &3.3368e-04_r8,4.7302e-04_r8,5.1131e-04_r8,5.0923e-04_r8,4.8101e-04_r8,4.3420e-04_r8, &
     &3.6192e-04_r8,3.1963e-04_r8,7.8022e-05_r8/)
      kao(:, 3, 3, 4) = (/ &
     &4.6167e-04_r8,6.3817e-04_r8,6.7863e-04_r8,6.7148e-04_r8,6.3202e-04_r8,5.6610e-04_r8, &
     &4.7208e-04_r8,3.5841e-04_r8,1.0032e-04_r8/)
      kao(:, 4, 3, 4) = (/ &
     &6.1421e-04_r8,8.2728e-04_r8,8.7092e-04_r8,8.6012e-04_r8,8.0666e-04_r8,7.1818e-04_r8, &
     &5.9937e-04_r8,4.3811e-04_r8,1.4466e-04_r8/)
      kao(:, 5, 3, 4) = (/ &
     &7.9318e-04_r8,1.0499e-03_r8,1.1001e-03_r8,1.0825e-03_r8,1.0111e-03_r8,9.0157e-04_r8, &
     &7.5964e-04_r8,5.7512e-04_r8,1.9432e-04_r8/)
      kao(:, 1, 4, 4) = (/ &
     &3.4200e-04_r8,4.1990e-04_r8,4.4259e-04_r8,4.3661e-04_r8,4.1163e-04_r8,3.6760e-04_r8, &
     &3.0371e-04_r8,2.3149e-04_r8,4.6307e-05_r8/)
      kao(:, 2, 4, 4) = (/ &
     &5.0920e-04_r8,6.1539e-04_r8,6.3721e-04_r8,6.1994e-04_r8,5.7603e-04_r8,5.0827e-04_r8, &
     &4.1402e-04_r8,2.9065e-04_r8,5.1907e-05_r8/)
      kao(:, 3, 4, 4) = (/ &
     &7.2424e-04_r8,8.6063e-04_r8,8.7699e-04_r8,8.4266e-04_r8,7.7721e-04_r8,6.8304e-04_r8, &
     &5.5495e-04_r8,3.8326e-04_r8,6.9160e-05_r8/)
      kao(:, 4, 4, 4) = (/ &
     &9.8776e-04_r8,1.1516e-03_r8,1.1582e-03_r8,1.1044e-03_r8,1.0138e-03_r8,8.8821e-04_r8, &
     &7.1753e-04_r8,4.9169e-04_r8,9.8233e-05_r8/)
      kao(:, 5, 4, 4) = (/ &
     &1.2975e-03_r8,1.4918e-03_r8,1.4869e-03_r8,1.4114e-03_r8,1.2930e-03_r8,1.1277e-03_r8, &
     &9.0840e-04_r8,6.3197e-04_r8,1.3450e-04_r8/)
      kao(:, 1, 5, 4) = (/ &
     &4.6076e-04_r8,5.0474e-04_r8,5.1144e-04_r8,4.9140e-04_r8,4.5232e-04_r8,3.9779e-04_r8, &
     &3.2321e-04_r8,2.2336e-04_r8,3.4201e-05_r8/)
      kao(:, 2, 5, 4) = (/ &
     &7.0989e-04_r8,7.6999e-04_r8,7.6963e-04_r8,7.2952e-04_r8,6.6336e-04_r8,5.7413e-04_r8, &
     &4.5930e-04_r8,3.0843e-04_r8,4.2292e-05_r8/)
      kao(:, 3, 5, 4) = (/ &
     &1.0386e-03_r8,1.1133e-03_r8,1.0985e-03_r8,1.0276e-03_r8,9.2270e-04_r8,7.9078e-04_r8, &
     &6.2825e-04_r8,4.1898e-04_r8,5.3586e-05_r8/)
      kao(:, 4, 5, 4) = (/ &
     &1.4541e-03_r8,1.5404e-03_r8,1.4988e-03_r8,1.3877e-03_r8,1.2375e-03_r8,1.0544e-03_r8, &
     &8.3469e-04_r8,5.5179e-04_r8,6.8395e-05_r8/)
      kao(:, 5, 5, 4) = (/ &
     &1.9528e-03_r8,2.0463e-03_r8,1.9719e-03_r8,1.8145e-03_r8,1.6102e-03_r8,1.3677e-03_r8, &
     &1.0776e-03_r8,7.0877e-04_r8,9.0444e-05_r8/)
      kao(:, 1, 6, 4) = (/ &
     &5.6492e-04_r8,5.7565e-04_r8,5.5931e-04_r8,5.2434e-04_r8,4.7320e-04_r8,4.0777e-04_r8, &
     &3.2512e-04_r8,2.1641e-04_r8,2.6966e-05_r8/)
      kao(:, 2, 6, 4) = (/ &
     &9.0441e-04_r8,9.1447e-04_r8,8.8349e-04_r8,8.2170e-04_r8,7.3208e-04_r8,6.2190e-04_r8, &
     &4.8768e-04_r8,3.1817e-04_r8,3.4982e-05_r8/)
      kao(:, 3, 6, 4) = (/ &
     &1.3664e-03_r8,1.3688e-03_r8,1.3074e-03_r8,1.2015e-03_r8,1.0584e-03_r8,8.8601e-04_r8, &
     &6.8532e-04_r8,4.4190e-04_r8,4.5831e-05_r8/)
      kao(:, 4, 6, 4) = (/ &
     &1.9708e-03_r8,1.9570e-03_r8,1.8529e-03_r8,1.6859e-03_r8,1.4692e-03_r8,1.2199e-03_r8, &
     &9.3583e-04_r8,6.0020e-04_r8,5.8072e-05_r8/)
      kao(:, 5, 6, 4) = (/ &
     &2.7158e-03_r8,2.6789e-03_r8,2.5132e-03_r8,2.2684e-03_r8,1.9663e-03_r8,1.6232e-03_r8, &
     &1.2393e-03_r8,7.8815e-04_r8,7.1453e-05_r8/)
      kao(:, 1, 7, 4) = (/ &
     &7.1612e-04_r8,6.9080e-04_r8,6.4557e-04_r8,5.8741e-04_r8,5.1690e-04_r8,4.3484e-04_r8, &
     &3.3811e-04_r8,2.1958e-04_r8,2.5385e-05_r8/)
      kao(:, 2, 7, 4) = (/ &
     &1.1940e-03_r8,1.1449e-03_r8,1.0668e-03_r8,9.6669e-04_r8,8.4588e-04_r8,7.0528e-04_r8, &
     &5.3962e-04_r8,3.4196e-04_r8,3.2650e-05_r8/)
      kao(:, 3, 7, 4) = (/ &
     &1.8743e-03_r8,1.7868e-03_r8,1.6562e-03_r8,1.4906e-03_r8,1.2906e-03_r8,1.0612e-03_r8, &
     &7.9912e-04_r8,4.9523e-04_r8,4.3298e-05_r8/)
      kao(:, 4, 7, 4) = (/ &
     &2.7760e-03_r8,2.6274e-03_r8,2.4197e-03_r8,2.1609e-03_r8,1.8570e-03_r8,1.5098e-03_r8, &
     &1.1229e-03_r8,6.8654e-04_r8,5.4268e-05_r8/)
      kao(:, 5, 7, 4) = (/ &
     &3.9210e-03_r8,3.6980e-03_r8,3.3854e-03_r8,3.0037e-03_r8,2.5627e-03_r8,2.0710e-03_r8, &
     &1.5295e-03_r8,9.2840e-04_r8,6.7940e-05_r8/)
      kao(:, 1, 8, 4) = (/ &
     &1.0670e-03_r8,9.8692e-04_r8,8.9134e-04_r8,7.8593e-04_r8,6.7073e-04_r8,5.4467e-04_r8, &
     &4.0756e-04_r8,2.5210e-04_r8,2.8359e-05_r8/)
      kao(:, 2, 8, 4) = (/ &
     &1.8582e-03_r8,1.7102e-03_r8,1.5414e-03_r8,1.3557e-03_r8,1.1545e-03_r8,9.3501e-04_r8, &
     &6.9502e-04_r8,4.2320e-04_r8,3.7233e-05_r8/)
      kao(:, 3, 8, 4) = (/ &
     &3.0392e-03_r8,2.7815e-03_r8,2.4987e-03_r8,2.1910e-03_r8,1.8592e-03_r8,1.4974e-03_r8, &
     &1.1016e-03_r8,6.5354e-04_r8,4.6926e-05_r8/)
      kao(:, 4, 8, 4) = (/ &
     &4.6351e-03_r8,4.2251e-03_r8,3.7893e-03_r8,3.3101e-03_r8,2.7928e-03_r8,2.2311e-03_r8, &
     &1.6189e-03_r8,9.4084e-04_r8,6.1285e-05_r8/)
      kao(:, 5, 8, 4) = (/ &
     &6.7053e-03_r8,6.1011e-03_r8,5.4490e-03_r8,4.7367e-03_r8,3.9743e-03_r8,3.1531e-03_r8, &
     &2.2726e-03_r8,1.3072e-03_r8,7.4486e-05_r8/)
      kao(:, 1, 9, 4) = (/ &
     &3.0079e-03_r8,2.6671e-03_r8,2.3362e-03_r8,1.9921e-03_r8,1.6375e-03_r8,1.2739e-03_r8, &
     &8.9947e-04_r8,5.0478e-04_r8,4.8310e-05_r8/)
      kao(:, 2, 9, 4) = (/ &
     &5.3604e-03_r8,4.7462e-03_r8,4.1492e-03_r8,3.5341e-03_r8,2.9054e-03_r8,2.2583e-03_r8, &
     &1.5943e-03_r8,8.9078e-04_r8,6.1843e-05_r8/)
      kao(:, 3, 9, 4) = (/ &
     &9.0324e-03_r8,7.9882e-03_r8,6.9714e-03_r8,5.9320e-03_r8,4.8700e-03_r8,3.7864e-03_r8, &
     &2.6693e-03_r8,1.4872e-03_r8,8.4369e-05_r8/)
      kao(:, 4, 9, 4) = (/ &
     &1.4329e-02_r8,1.2658e-02_r8,1.1032e-02_r8,9.3748e-03_r8,7.6880e-03_r8,5.9624e-03_r8, &
     &4.1846e-03_r8,2.3075e-03_r8,1.0247e-04_r8/)
      kao(:, 5, 9, 4) = (/ &
     &2.1261e-02_r8,1.8755e-02_r8,1.6325e-02_r8,1.3858e-02_r8,1.1339e-02_r8,8.7669e-03_r8, &
     &6.1142e-03_r8,3.3320e-03_r8,1.2163e-04_r8/)
      kao(:, 1,10, 4) = (/ &
     &1.0911e-02_r8,9.5635e-03_r8,8.2330e-03_r8,6.9092e-03_r8,5.5802e-03_r8,4.2396e-03_r8, &
     &2.8819e-03_r8,1.5069e-03_r8,1.0164e-04_r8/)
      kao(:, 2,10, 4) = (/ &
     &1.8579e-02_r8,1.6289e-02_r8,1.4021e-02_r8,1.1757e-02_r8,9.4958e-03_r8,7.2115e-03_r8, &
     &4.9034e-03_r8,2.5692e-03_r8,1.2765e-04_r8/)
      kao(:, 3,10, 4) = (/ &
     &3.1018e-02_r8,2.7193e-02_r8,2.3385e-02_r8,1.9601e-02_r8,1.5823e-02_r8,1.2032e-02_r8, &
     &8.1956e-03_r8,4.3045e-03_r8,1.7856e-04_r8/)
      kao(:, 4,10, 4) = (/ &
     &5.0111e-02_r8,4.3919e-02_r8,3.7756e-02_r8,3.1628e-02_r8,2.5516e-02_r8,1.9374e-02_r8, &
     &1.3194e-02_r8,6.9219e-03_r8,2.2724e-04_r8/)
      kao(:, 5,10, 4) = (/ &
     &7.6376e-02_r8,6.6924e-02_r8,5.7507e-02_r8,4.8151e-02_r8,3.8816e-02_r8,2.9439e-02_r8, &
     &2.0003e-02_r8,1.0433e-02_r8,2.6085e-04_r8/)
      kao(:, 1,11, 4) = (/ &
     &1.8971e-02_r8,1.6611e-02_r8,1.4262e-02_r8,1.1923e-02_r8,9.5992e-03_r8,7.2680e-03_r8, &
     &4.9113e-03_r8,2.5257e-03_r8,1.6715e-04_r8/)
      kao(:, 2,11, 4) = (/ &
     &3.0950e-02_r8,2.7103e-02_r8,2.3271e-02_r8,1.9463e-02_r8,1.5664e-02_r8,1.1847e-02_r8, &
     &7.9981e-03_r8,4.1199e-03_r8,2.1489e-04_r8/)
      kao(:, 3,11, 4) = (/ &
     &4.9685e-02_r8,4.3517e-02_r8,3.7369e-02_r8,3.1256e-02_r8,2.5144e-02_r8,1.9021e-02_r8, &
     &1.2853e-02_r8,6.6396e-03_r8,2.5990e-04_r8/)
      kao(:, 4,11, 4) = (/ &
     &7.7374e-02_r8,6.7750e-02_r8,5.8163e-02_r8,4.8608e-02_r8,3.9067e-02_r8,2.9542e-02_r8, &
     &1.9962e-02_r8,1.0311e-02_r8,3.2116e-04_r8/)
      kao(:, 5,11, 4) = (/ &
     &1.1501e-01_r8,1.0072e-01_r8,8.6431e-02_r8,7.2217e-02_r8,5.8056e-02_r8,4.3898e-02_r8, &
     &2.9647e-02_r8,1.5264e-02_r8,3.7485e-04_r8/)
      kao(:, 1,12, 4) = (/ &
     &2.3401e-02_r8,2.0486e-02_r8,1.7582e-02_r8,1.4686e-02_r8,1.1806e-02_r8,8.9258e-03_r8, &
     &6.0297e-03_r8,3.0936e-03_r8,1.8693e-04_r8/)
      kao(:, 2,12, 4) = (/ &
     &3.8133e-02_r8,3.3387e-02_r8,2.8657e-02_r8,2.3944e-02_r8,1.9250e-02_r8,1.4544e-02_r8, &
     &9.8021e-03_r8,5.0235e-03_r8,2.4530e-04_r8/)
      kao(:, 3,12, 4) = (/ &
     &6.0110e-02_r8,5.2620e-02_r8,4.5149e-02_r8,3.7710e-02_r8,3.0268e-02_r8,2.2852e-02_r8, &
     &1.5390e-02_r8,7.8945e-03_r8,2.8864e-04_r8/)
      kao(:, 4,12, 4) = (/ &
     &9.0890e-02_r8,7.9571e-02_r8,6.8303e-02_r8,5.7049e-02_r8,4.5842e-02_r8,3.4594e-02_r8, &
     &2.3289e-02_r8,1.1923e-02_r8,3.6228e-04_r8/)
      kao(:, 5,12, 4) = (/ &
     &1.3100e-01_r8,1.1462e-01_r8,9.8322e-02_r8,8.2088e-02_r8,6.5959e-02_r8,4.9780e-02_r8, &
     &3.3534e-02_r8,1.7184e-02_r8,4.3158e-04_r8/)
      kao(:, 1,13, 4) = (/ &
     &2.4303e-02_r8,2.1262e-02_r8,1.8230e-02_r8,1.5211e-02_r8,1.2213e-02_r8,9.2155e-03_r8, &
     &6.2046e-03_r8,3.1714e-03_r8,1.9233e-04_r8/)
      kao(:, 2,13, 4) = (/ &
     &3.8296e-02_r8,3.3521e-02_r8,2.8762e-02_r8,2.4031e-02_r8,1.9310e-02_r8,1.4568e-02_r8, &
     &9.8072e-03_r8,5.0047e-03_r8,2.4842e-04_r8/)
      kao(:, 3,13, 4) = (/ &
     &5.8379e-02_r8,5.1065e-02_r8,4.3832e-02_r8,3.6631e-02_r8,2.9434e-02_r8,2.2205e-02_r8, &
     &1.4940e-02_r8,7.6384e-03_r8,2.8734e-04_r8/)
      kao(:, 4,13, 4) = (/ &
     &8.5558e-02_r8,7.4841e-02_r8,6.4227e-02_r8,5.3638e-02_r8,4.3082e-02_r8,3.2499e-02_r8, &
     &2.1863e-02_r8,1.1189e-02_r8,3.6167e-04_r8/)
      kao(:, 5,13, 4) = (/ &
     &1.2105e-01_r8,1.0601e-01_r8,9.0943e-02_r8,7.5945e-02_r8,6.0995e-02_r8,4.5990e-02_r8, &
     &3.0953e-02_r8,1.5858e-02_r8,4.3014e-04_r8/)
      kao(:, 1, 1, 5) = (/ &
     &5.2897e-04_r8,6.3863e-04_r8,6.7716e-04_r8,6.8592e-04_r8,6.6781e-04_r8,6.0937e-04_r8, &
     &5.2069e-04_r8,5.5022e-04_r8,1.8160e-04_r8/)
      kao(:, 2, 1, 5) = (/ &
     &6.5371e-04_r8,8.0837e-04_r8,8.6369e-04_r8,8.8295e-04_r8,8.7230e-04_r8,8.3067e-04_r8, &
     &7.4453e-04_r8,6.6477e-04_r8,2.9044e-04_r8/)
      kao(:, 3, 1, 5) = (/ &
     &7.9309e-04_r8,1.0041e-03_r8,1.0806e-03_r8,1.1131e-03_r8,1.1135e-03_r8,1.0810e-03_r8, &
     &1.0060e-03_r8,8.6363e-04_r8,4.3507e-04_r8/)
      kao(:, 4, 1, 5) = (/ &
     &9.5515e-04_r8,1.2330e-03_r8,1.3320e-03_r8,1.3798e-03_r8,1.3866e-03_r8,1.3599e-03_r8, &
     &1.2978e-03_r8,1.1703e-03_r8,5.4823e-04_r8/)
      kao(:, 5, 1, 5) = (/ &
     &1.1370e-03_r8,1.4922e-03_r8,1.6168e-03_r8,1.6809e-03_r8,1.6969e-03_r8,1.6741e-03_r8, &
     &1.6142e-03_r8,1.5306e-03_r8,7.1233e-04_r8/)
      kao(:, 1, 2, 5) = (/ &
     &6.4530e-04_r8,7.2673e-04_r8,7.3348e-04_r8,7.1463e-04_r8,6.7564e-04_r8,6.1110e-04_r8, &
     &5.0123e-04_r8,4.4222e-04_r8,1.3962e-04_r8/)
      kao(:, 2, 2, 5) = (/ &
     &8.0957e-04_r8,9.2607e-04_r8,9.4414e-04_r8,9.2480e-04_r8,8.8433e-04_r8,8.1497e-04_r8, &
     &7.0697e-04_r8,5.2414e-04_r8,2.1889e-04_r8/)
      kao(:, 3, 2, 5) = (/ &
     &9.9558e-04_r8,1.1596e-03_r8,1.1892e-03_r8,1.1731e-03_r8,1.1295e-03_r8,1.0550e-03_r8, &
     &9.3776e-04_r8,7.6366e-04_r8,3.1779e-04_r8/)
      kao(:, 4, 2, 5) = (/ &
     &1.2093e-03_r8,1.4336e-03_r8,1.4751e-03_r8,1.4631e-03_r8,1.4149e-03_r8,1.3281e-03_r8, &
     &1.2039e-03_r8,1.0264e-03_r8,4.0743e-04_r8/)
      kao(:, 5, 2, 5) = (/ &
     &1.4548e-03_r8,1.7501e-03_r8,1.8041e-03_r8,1.7977e-03_r8,1.7416e-03_r8,1.6424e-03_r8, &
     &1.5037e-03_r8,1.3244e-03_r8,5.3155e-04_r8/)
      kao(:, 1, 3, 5) = (/ &
     &1.0073e-03_r8,1.0305e-03_r8,9.9170e-04_r8,9.1685e-04_r8,8.2334e-04_r8,7.1279e-04_r8, &
     &5.7365e-04_r8,3.9412e-04_r8,1.0025e-04_r8/)
      kao(:, 2, 3, 5) = (/ &
     &1.2880e-03_r8,1.3316e-03_r8,1.2867e-03_r8,1.1967e-03_r8,1.0809e-03_r8,9.4443e-04_r8, &
     &7.8179e-04_r8,5.3700e-04_r8,1.5384e-04_r8/)
      kao(:, 3, 3, 5) = (/ &
     &1.6107e-03_r8,1.6903e-03_r8,1.6390e-03_r8,1.5300e-03_r8,1.3886e-03_r8,1.2242e-03_r8, &
     &1.0235e-03_r8,7.5425e-04_r8,2.1640e-04_r8/)
      kao(:, 4, 3, 5) = (/ &
     &1.9797e-03_r8,2.1107e-03_r8,2.0529e-03_r8,1.9209e-03_r8,1.7527e-03_r8,1.5541e-03_r8, &
     &1.3094e-03_r8,9.9288e-04_r8,2.8803e-04_r8/)
      kao(:, 5, 3, 5) = (/ &
     &2.4113e-03_r8,2.6021e-03_r8,2.5366e-03_r8,2.3815e-03_r8,2.1822e-03_r8,1.9385e-03_r8, &
     &1.6375e-03_r8,1.2689e-03_r8,3.7641e-04_r8/)
      kao(:, 1, 4, 5) = (/ &
     &1.5851e-03_r8,1.5181e-03_r8,1.4032e-03_r8,1.2606e-03_r8,1.0883e-03_r8,8.9739e-04_r8, &
     &6.8560e-04_r8,4.2854e-04_r8,6.6391e-05_r8/)
      kao(:, 2, 4, 5) = (/ &
     &2.0501e-03_r8,1.9754e-03_r8,1.8387e-03_r8,1.6565e-03_r8,1.4386e-03_r8,1.1914e-03_r8, &
     &9.2359e-04_r8,6.1319e-04_r8,1.0381e-04_r8/)
      kao(:, 3, 4, 5) = (/ &
     &2.6137e-03_r8,2.5384e-03_r8,2.3763e-03_r8,2.1489e-03_r8,1.8706e-03_r8,1.5557e-03_r8, &
     &1.2160e-03_r8,8.2392e-04_r8,1.4611e-04_r8/)
      kao(:, 4, 4, 5) = (/ &
     &3.2665e-03_r8,3.2074e-03_r8,3.0134e-03_r8,2.7316e-03_r8,2.3866e-03_r8,1.9939e-03_r8, &
     &1.5682e-03_r8,1.0781e-03_r8,1.9821e-04_r8/)
      kao(:, 5, 4, 5) = (/ &
     &4.0137e-03_r8,3.9873e-03_r8,3.7629e-03_r8,3.4158e-03_r8,2.9921e-03_r8,2.5128e-03_r8, &
     &1.9870e-03_r8,1.3733e-03_r8,2.6370e-04_r8/)
      kao(:, 1, 5, 5) = (/ &
     &2.2692e-03_r8,2.1006e-03_r8,1.8869e-03_r8,1.6579e-03_r8,1.4070e-03_r8,1.1280e-03_r8, &
     &8.2786e-04_r8,4.9332e-04_r8,4.7300e-05_r8/)
      kao(:, 2, 5, 5) = (/ &
     &2.9951e-03_r8,2.7795e-03_r8,2.5097e-03_r8,2.2151e-03_r8,1.8839e-03_r8,1.5178e-03_r8, &
     &1.1209e-03_r8,6.8743e-04_r8,6.4441e-05_r8/)
      kao(:, 3, 5, 5) = (/ &
     &3.8783e-03_r8,3.6150e-03_r8,3.2821e-03_r8,2.9041e-03_r8,2.4789e-03_r8,2.0050e-03_r8, &
     &1.4894e-03_r8,9.2698e-04_r8,9.4008e-05_r8/)
      kao(:, 4, 5, 5) = (/ &
     &4.9258e-03_r8,4.6186e-03_r8,4.2220e-03_r8,3.7446e-03_r8,3.2015e-03_r8,2.5968e-03_r8, &
     &1.9395e-03_r8,1.2217e-03_r8,1.3185e-04_r8/)
      kao(:, 5, 5, 5) = (/ &
     &6.1149e-03_r8,5.7761e-03_r8,5.3147e-03_r8,4.7312e-03_r8,4.0567e-03_r8,3.3012e-03_r8, &
     &2.4775e-03_r8,1.5747e-03_r8,1.8186e-04_r8/)
      kao(:, 1, 6, 5) = (/ &
     &2.9777e-03_r8,2.7020e-03_r8,2.3926e-03_r8,2.0653e-03_r8,1.7240e-03_r8,1.3628e-03_r8, &
     &9.7585e-04_r8,5.5769e-04_r8,3.7018e-05_r8/)
      kao(:, 2, 6, 5) = (/ &
     &4.0405e-03_r8,3.6698e-03_r8,3.2527e-03_r8,2.8150e-03_r8,2.3582e-03_r8,1.8689e-03_r8, &
     &1.3459e-03_r8,7.7825e-04_r8,5.0931e-05_r8/)
      kao(:, 3, 6, 5) = (/ &
     &5.2985e-03_r8,4.8259e-03_r8,4.2980e-03_r8,3.7351e-03_r8,3.1354e-03_r8,2.4956e-03_r8, &
     &1.8046e-03_r8,1.0570e-03_r8,6.8165e-05_r8/)
      kao(:, 4, 6, 5) = (/ &
     &6.8330e-03_r8,6.2458e-03_r8,5.5922e-03_r8,4.8800e-03_r8,4.1117e-03_r8,3.2799e-03_r8, &
     &2.3798e-03_r8,1.4059e-03_r8,8.9401e-05_r8/)
      kao(:, 5, 6, 5) = (/ &
     &8.6003e-03_r8,7.8905e-03_r8,7.1103e-03_r8,6.2229e-03_r8,5.2575e-03_r8,4.2076e-03_r8, &
     &3.0687e-03_r8,1.8306e-03_r8,1.2028e-04_r8/)
      kao(:, 1, 7, 5) = (/ &
     &4.0427e-03_r8,3.6171e-03_r8,3.1732e-03_r8,2.7085e-03_r8,2.2305e-03_r8,1.7374e-03_r8, &
     &1.2245e-03_r8,6.7631e-04_r8,3.7016e-05_r8/)
      kao(:, 2, 7, 5) = (/ &
     &5.6556e-03_r8,5.0622e-03_r8,4.4391e-03_r8,3.7915e-03_r8,3.1262e-03_r8,2.4381e-03_r8, &
     &1.7215e-03_r8,9.5894e-04_r8,4.8862e-05_r8/)
      kao(:, 3, 7, 5) = (/ &
     &7.5823e-03_r8,6.7945e-03_r8,5.9706e-03_r8,5.1108e-03_r8,4.2263e-03_r8,3.3055e-03_r8, &
     &2.3437e-03_r8,1.3169e-03_r8,6.1466e-05_r8/)
      kao(:, 4, 7, 5) = (/ &
     &9.8701e-03_r8,8.8589e-03_r8,7.8113e-03_r8,6.7131e-03_r8,5.5681e-03_r8,4.3736e-03_r8, &
     &3.1150e-03_r8,1.7640e-03_r8,7.9784e-05_r8/)
      kao(:, 5, 7, 5) = (/ &
     &1.2627e-02_r8,1.1349e-02_r8,1.0044e-02_r8,8.6633e-03_r8,7.2033e-03_r8,5.6735e-03_r8, &
     &4.0519e-03_r8,2.3093e-03_r8,9.9338e-05_r8/)
      kao(:, 1, 8, 5) = (/ &
     &6.5162e-03_r8,5.7610e-03_r8,5.0100e-03_r8,4.2382e-03_r8,3.4497e-03_r8,2.6520e-03_r8, &
     &1.8357e-03_r8,9.8841e-04_r8,5.0893e-05_r8/)
      kao(:, 2, 8, 5) = (/ &
     &9.3894e-03_r8,8.3047e-03_r8,7.2233e-03_r8,6.1097e-03_r8,4.9767e-03_r8,3.8267e-03_r8, &
     &2.6500e-03_r8,1.4278e-03_r8,6.6360e-05_r8/)
      kao(:, 3, 8, 5) = (/ &
     &1.2886e-02_r8,1.1402e-02_r8,9.9227e-03_r8,8.3986e-03_r8,6.8476e-03_r8,5.2715e-03_r8, &
     &3.6563e-03_r8,1.9797e-03_r8,8.1964e-05_r8/)
      kao(:, 4, 8, 5) = (/ &
     &1.7029e-02_r8,1.5075e-02_r8,1.3132e-02_r8,1.1136e-02_r8,9.1030e-03_r8,7.0269e-03_r8, &
     &4.8948e-03_r8,2.6694e-03_r8,1.0083e-04_r8/)
      kao(:, 5, 8, 5) = (/ &
     &2.2131e-02_r8,1.9595e-02_r8,1.7101e-02_r8,1.4537e-02_r8,1.1918e-02_r8,9.2249e-03_r8, &
     &6.4389e-03_r8,3.5237e-03_r8,1.2644e-04_r8/)
      kao(:, 1, 9, 5) = (/ &
     &1.9574e-02_r8,1.7171e-02_r8,1.4767e-02_r8,1.2373e-02_r8,9.9784e-03_r8,7.5698e-03_r8, &
     &5.1323e-03_r8,2.6624e-03_r8,7.9787e-05_r8/)
      kao(:, 2, 9, 5) = (/ &
     &2.9063e-02_r8,2.5494e-02_r8,2.1931e-02_r8,1.8384e-02_r8,1.4827e-02_r8,1.1241e-02_r8, &
     &7.6171e-03_r8,3.9520e-03_r8,1.0489e-04_r8/)
      kao(:, 3, 9, 5) = (/ &
     &4.0973e-02_r8,3.5943e-02_r8,3.0923e-02_r8,2.5930e-02_r8,2.0911e-02_r8,1.5846e-02_r8, &
     &1.0739e-02_r8,5.5789e-03_r8,1.2330e-04_r8/)
      kao(:, 4, 9, 5) = (/ &
     &5.5333e-02_r8,4.8546e-02_r8,4.1776e-02_r8,3.5034e-02_r8,2.8259e-02_r8,2.1435e-02_r8, &
     &1.4550e-02_r8,7.5751e-03_r8,1.5097e-04_r8/)
      kao(:, 5, 9, 5) = (/ &
     &7.2795e-02_r8,6.3880e-02_r8,5.4976e-02_r8,4.6114e-02_r8,3.7235e-02_r8,2.8276e-02_r8, &
     &1.9247e-02_r8,1.0060e-02_r8,1.9444e-04_r8/)
      kao(:, 1,10, 5) = (/ &
     &6.7876e-02_r8,5.9426e-02_r8,5.0975e-02_r8,4.2524e-02_r8,3.4085e-02_r8,2.5643e-02_r8, &
     &1.7219e-02_r8,8.7441e-03_r8,2.1379e-04_r8/)
      kao(:, 2,10, 5) = (/ &
     &1.0363e-01_r8,9.0726e-02_r8,7.7824e-02_r8,6.4925e-02_r8,5.2032e-02_r8,3.9153e-02_r8, &
     &2.6288e-02_r8,1.3336e-02_r8,2.7530e-04_r8/)
      kao(:, 3,10, 5) = (/ &
     &1.4868e-01_r8,1.3017e-01_r8,1.1167e-01_r8,9.3161e-02_r8,7.4667e-02_r8,5.6180e-02_r8, &
     &3.7706e-02_r8,1.9125e-02_r8,3.1198e-04_r8/)
      kao(:, 4,10, 5) = (/ &
     &2.0441e-01_r8,1.7897e-01_r8,1.5353e-01_r8,1.2809e-01_r8,1.0267e-01_r8,7.7285e-02_r8, &
     &5.1877e-02_r8,2.6327e-02_r8,3.7361e-04_r8/)
      kao(:, 5,10, 5) = (/ &
     &2.7248e-01_r8,2.3857e-01_r8,2.0467e-01_r8,1.7078e-01_r8,1.3689e-01_r8,1.0307e-01_r8, &
     &6.9236e-02_r8,3.5215e-02_r8,4.4890e-04_r8/)
      kao(:, 1,11, 5) = (/ &
     &1.0259e-01_r8,8.9796e-02_r8,7.7004e-02_r8,6.4217e-02_r8,5.1425e-02_r8,3.8649e-02_r8, &
     &2.5882e-02_r8,1.3106e-02_r8,2.9325e-04_r8/)
      kao(:, 2,11, 5) = (/ &
     &1.5400e-01_r8,1.3480e-01_r8,1.1559e-01_r8,9.6403e-02_r8,7.7200e-02_r8,5.8036e-02_r8, &
     &3.8878e-02_r8,1.9667e-02_r8,3.5327e-04_r8/)
      kao(:, 3,11, 5) = (/ &
     &2.2118e-01_r8,1.9361e-01_r8,1.6603e-01_r8,1.3846e-01_r8,1.1090e-01_r8,8.3368e-02_r8, &
     &5.5861e-02_r8,2.8242e-02_r8,4.6202e-04_r8/)
      kao(:, 4,11, 5) = (/ &
     &3.0353e-01_r8,2.6571e-01_r8,2.2790e-01_r8,1.9008e-01_r8,1.5227e-01_r8,1.1447e-01_r8, &
     &7.6708e-02_r8,3.8764e-02_r8,5.6335e-04_r8/)
      kao(:, 5,11, 5) = (/ &
     &4.0552e-01_r8,3.5495e-01_r8,3.0446e-01_r8,2.5391e-01_r8,2.0338e-01_r8,1.5287e-01_r8, &
     &1.0246e-01_r8,5.1876e-02_r8,6.9233e-04_r8/)
      kao(:, 1,12, 5) = (/ &
     &1.1805e-01_r8,1.0334e-01_r8,8.8617e-02_r8,7.3889e-02_r8,5.9170e-02_r8,4.4431e-02_r8, &
     &2.9722e-02_r8,1.5007e-02_r8,3.3712e-04_r8/)
      kao(:, 2,12, 5) = (/ &
     &1.7261e-01_r8,1.5108e-01_r8,1.2954e-01_r8,1.0804e-01_r8,8.6508e-02_r8,6.5013e-02_r8, &
     &4.3529e-02_r8,2.1984e-02_r8,3.8771e-04_r8/)
      kao(:, 3,12, 5) = (/ &
     &2.4519e-01_r8,2.1462e-01_r8,1.8406e-01_r8,1.5350e-01_r8,1.2297e-01_r8,9.2422e-02_r8, &
     &6.1905e-02_r8,3.1241e-02_r8,5.1427e-04_r8/)
      kao(:, 4,12, 5) = (/ &
     &3.3550e-01_r8,2.9369e-01_r8,2.5183e-01_r8,2.1003e-01_r8,1.6821e-01_r8,1.2645e-01_r8, &
     &8.4714e-02_r8,4.2803e-02_r8,6.2818e-04_r8/)
      kao(:, 5,12, 5) = (/ &
     &4.4900e-01_r8,3.9309e-01_r8,3.3714e-01_r8,2.8120e-01_r8,2.2522e-01_r8,1.6927e-01_r8, &
     &1.1341e-01_r8,5.7326e-02_r8,7.6692e-04_r8/)
      kao(:, 1,13, 5) = (/ &
     &1.0921e-01_r8,9.5613e-02_r8,8.2016e-02_r8,6.8423e-02_r8,5.4814e-02_r8,4.1207e-02_r8, &
     &2.7589e-02_r8,1.3915e-02_r8,3.0996e-04_r8/)
      kao(:, 2,13, 5) = (/ &
     &1.5908e-01_r8,1.3927e-01_r8,1.1945e-01_r8,9.9633e-02_r8,7.9786e-02_r8,5.9973e-02_r8, &
     &4.0176e-02_r8,2.0276e-02_r8,3.7414e-04_r8/)
      kao(:, 3,13, 5) = (/ &
     &2.2086e-01_r8,1.9339e-01_r8,1.6582e-01_r8,1.3829e-01_r8,1.1077e-01_r8,8.3306e-02_r8, &
     &5.5823e-02_r8,2.8176e-02_r8,4.9992e-04_r8/)
      kao(:, 4,13, 5) = (/ &
     &3.0195e-01_r8,2.6439e-01_r8,2.2676e-01_r8,1.8917e-01_r8,1.5156e-01_r8,1.1401e-01_r8, &
     &7.6395e-02_r8,3.8587e-02_r8,6.2293e-04_r8/)
      kao(:, 5,13, 5) = (/ &
     &4.0305e-01_r8,3.5276e-01_r8,3.0259e-01_r8,2.5241e-01_r8,2.0221e-01_r8,1.5209e-01_r8, &
     &1.0190e-01_r8,5.1477e-02_r8,7.6835e-04_r8/)
      kao(:, 1, 1, 6) = (/ &
     &1.3028e-03_r8,1.4792e-03_r8,1.5640e-03_r8,1.5783e-03_r8,1.5338e-03_r8,1.4263e-03_r8, &
     &1.2426e-03_r8,1.0270e-03_r8,3.8769e-04_r8/)
      kao(:, 2, 1, 6) = (/ &
     &1.5941e-03_r8,1.8539e-03_r8,1.9924e-03_r8,2.0205e-03_r8,1.9782e-03_r8,1.8703e-03_r8, &
     &1.6672e-03_r8,1.3063e-03_r8,5.8906e-04_r8/)
      kao(:, 3, 1, 6) = (/ &
     &1.9170e-03_r8,2.2892e-03_r8,2.4874e-03_r8,2.5352e-03_r8,2.4910e-03_r8,2.3785e-03_r8, &
     &2.1678e-03_r8,1.7982e-03_r8,8.4228e-04_r8/)
      kao(:, 4, 1, 6) = (/ &
     &2.2745e-03_r8,2.7857e-03_r8,3.0496e-03_r8,3.1195e-03_r8,3.0784e-03_r8,2.9487e-03_r8, &
     &2.7123e-03_r8,2.3729e-03_r8,1.1599e-03_r8/)
      kao(:, 5, 1, 6) = (/ &
     &2.6664e-03_r8,3.3396e-03_r8,3.6796e-03_r8,3.7742e-03_r8,3.7339e-03_r8,3.5735e-03_r8, &
     &3.3124e-03_r8,2.9540e-03_r8,1.5049e-03_r8/)
      kao(:, 1, 2, 6) = (/ &
     &1.6105e-03_r8,1.7112e-03_r8,1.7440e-03_r8,1.7104e-03_r8,1.6159e-03_r8,1.4650e-03_r8, &
     &1.2347e-03_r8,8.8371e-04_r8,2.8335e-04_r8/)
      kao(:, 2, 2, 6) = (/ &
     &1.9953e-03_r8,2.1575e-03_r8,2.2293e-03_r8,2.1981e-03_r8,2.0893e-03_r8,1.9131e-03_r8, &
     &1.6649e-03_r8,1.2817e-03_r8,4.3740e-04_r8/)
      kao(:, 3, 2, 6) = (/ &
     &2.4284e-03_r8,2.6728e-03_r8,2.7960e-03_r8,2.7642e-03_r8,2.6394e-03_r8,2.4361e-03_r8, &
     &2.1522e-03_r8,1.6930e-03_r8,6.3499e-04_r8/)
      kao(:, 4, 2, 6) = (/ &
     &2.9107e-03_r8,3.2657e-03_r8,3.4379e-03_r8,3.4084e-03_r8,3.2638e-03_r8,3.0336e-03_r8, &
     &2.6919e-03_r8,2.1920e-03_r8,8.6677e-04_r8/)
      kao(:, 5, 2, 6) = (/ &
     &3.4457e-03_r8,3.9315e-03_r8,4.1602e-03_r8,4.1311e-03_r8,3.9674e-03_r8,3.6982e-03_r8, &
     &3.2905e-03_r8,2.7416e-03_r8,1.1277e-03_r8/)
      kao(:, 1, 3, 6) = (/ &
     &2.5362e-03_r8,2.4734e-03_r8,2.3740e-03_r8,2.2299e-03_r8,2.0298e-03_r8,1.7661e-03_r8, &
     &1.4316e-03_r8,9.7765e-04_r8,1.9718e-04_r8/)
      kao(:, 2, 3, 6) = (/ &
     &3.1979e-03_r8,3.1448e-03_r8,3.0502e-03_r8,2.8893e-03_r8,2.6412e-03_r8,2.3120e-03_r8, &
     &1.8934e-03_r8,1.3566e-03_r8,3.0943e-04_r8/)
      kao(:, 3, 3, 6) = (/ &
     &3.9564e-03_r8,3.9245e-03_r8,3.8464e-03_r8,3.6625e-03_r8,3.3542e-03_r8,2.9452e-03_r8, &
     &2.4362e-03_r8,1.8025e-03_r8,4.5105e-04_r8/)
      kao(:, 4, 3, 6) = (/ &
     &4.8099e-03_r8,4.8142e-03_r8,4.7669e-03_r8,4.5499e-03_r8,4.1705e-03_r8,3.6723e-03_r8, &
     &3.0586e-03_r8,2.2944e-03_r8,6.1219e-04_r8/)
      kao(:, 5, 3, 6) = (/ &
     &5.7692e-03_r8,5.8286e-03_r8,5.8075e-03_r8,5.5468e-03_r8,5.0930e-03_r8,4.4966e-03_r8, &
     &3.7644e-03_r8,2.8408e-03_r8,8.0331e-04_r8/)
      kao(:, 1, 4, 6) = (/ &
     &3.9832e-03_r8,3.6741e-03_r8,3.3865e-03_r8,3.0403e-03_r8,2.6684e-03_r8,2.2429e-03_r8, &
     &1.7419e-03_r8,1.1291e-03_r8,1.3015e-04_r8/)
      kao(:, 2, 4, 6) = (/ &
     &5.1171e-03_r8,4.7408e-03_r8,4.3919e-03_r8,3.9718e-03_r8,3.5069e-03_r8,2.9654e-03_r8, &
     &2.3168e-03_r8,1.5306e-03_r8,2.0974e-04_r8/)
      kao(:, 3, 4, 6) = (/ &
     &6.4449e-03_r8,5.9980e-03_r8,5.5858e-03_r8,5.0842e-03_r8,4.5074e-03_r8,3.8196e-03_r8, &
     &2.9911e-03_r8,2.0056e-03_r8,3.1006e-04_r8/)
      kao(:, 4, 4, 6) = (/ &
     &7.9648e-03_r8,7.4434e-03_r8,6.9731e-03_r8,6.3878e-03_r8,5.6676e-03_r8,4.8062e-03_r8, &
     &3.7737e-03_r8,2.5549e-03_r8,4.2568e-04_r8/)
      kao(:, 5, 4, 6) = (/ &
     &9.7092e-03_r8,9.1026e-03_r8,8.5703e-03_r8,7.8734e-03_r8,6.9867e-03_r8,5.9261e-03_r8, &
     &4.6651e-03_r8,3.1844e-03_r8,5.6406e-04_r8/)
      kao(:, 1, 5, 6) = (/ &
     &5.7027e-03_r8,5.1210e-03_r8,4.6077e-03_r8,4.0275e-03_r8,3.4179e-03_r8,2.7812e-03_r8, &
     &2.0863e-03_r8,1.2862e-03_r8,7.8383e-05_r8/)
      kao(:, 2, 5, 6) = (/ &
     &7.4791e-03_r8,6.7335e-03_r8,6.0729e-03_r8,5.3256e-03_r8,4.5457e-03_r8,3.7228e-03_r8, &
     &2.8115e-03_r8,1.7506e-03_r8,1.3561e-04_r8/)
      kao(:, 3, 5, 6) = (/ &
     &9.5940e-03_r8,8.6573e-03_r8,7.8294e-03_r8,6.8962e-03_r8,5.9152e-03_r8,4.8604e-03_r8, &
     &3.6801e-03_r8,2.2991e-03_r8,2.0565e-04_r8/)
      kao(:, 4, 5, 6) = (/ &
     &1.2079e-02_r8,1.0922e-02_r8,9.8984e-03_r8,8.7543e-03_r8,7.5389e-03_r8,6.1967e-03_r8, &
     &4.6995e-03_r8,2.9469e-03_r8,2.9267e-04_r8/)
      kao(:, 5, 5, 6) = (/ &
     &1.4994e-02_r8,1.3590e-02_r8,1.2330e-02_r8,1.0933e-02_r8,9.4206e-03_r8,7.7402e-03_r8, &
     &5.8678e-03_r8,3.6936e-03_r8,3.9433e-04_r8/)
      kao(:, 1, 6, 6) = (/ &
     &7.5110e-03_r8,6.6602e-03_r8,5.8889e-03_r8,5.0761e-03_r8,4.2229e-03_r8,3.3438e-03_r8, &
     &2.4265e-03_r8,1.4290e-03_r8,6.0800e-05_r8/)
      kao(:, 2, 6, 6) = (/ &
     &1.0081e-02_r8,8.9573e-03_r8,7.9340e-03_r8,6.8466e-03_r8,5.7108e-03_r8,4.5453e-03_r8, &
     &3.3197e-03_r8,1.9723e-03_r8,8.3721e-05_r8/)
      kao(:, 3, 6, 6) = (/ &
     &1.3198e-02_r8,1.1747e-02_r8,1.0417e-02_r8,9.0067e-03_r8,7.5375e-03_r8,6.0255e-03_r8, &
     &4.4194e-03_r8,2.6335e-03_r8,1.2422e-04_r8/)
      kao(:, 4, 6, 6) = (/ &
     &1.6984e-02_r8,1.5135e-02_r8,1.3426e-02_r8,1.1628e-02_r8,9.7560e-03_r8,7.8119e-03_r8, &
     &5.7333e-03_r8,3.4188e-03_r8,1.8443e-04_r8/)
      kao(:, 5, 6, 6) = (/ &
     &2.1488e-02_r8,1.9171e-02_r8,1.7013e-02_r8,1.4755e-02_r8,1.2406e-02_r8,9.9290e-03_r8, &
     &7.2811e-03_r8,4.3367e-03_r8,2.5906e-04_r8/)
      kao(:, 1, 7, 6) = (/ &
     &1.0317e-02_r8,9.0822e-03_r8,7.9160e-03_r8,6.7515e-03_r8,5.5440e-03_r8,4.3074e-03_r8, &
     &3.0340e-03_r8,1.7035e-03_r8,6.0426e-05_r8/)
      kao(:, 2, 7, 6) = (/ &
     &1.4191e-02_r8,1.2505e-02_r8,1.0919e-02_r8,9.3201e-03_r8,7.6597e-03_r8,5.9649e-03_r8, &
     &4.2263e-03_r8,2.3919e-03_r8,8.0608e-05_r8/)
      kao(:, 3, 7, 6) = (/ &
     &1.9028e-02_r8,1.6789e-02_r8,1.4664e-02_r8,1.2525e-02_r8,1.0306e-02_r8,8.0458e-03_r8, &
     &5.7261e-03_r8,3.2535e-03_r8,1.0671e-04_r8/)
      kao(:, 4, 7, 6) = (/ &
     &2.5018e-02_r8,2.2107e-02_r8,1.9309e-02_r8,1.6498e-02_r8,1.3592e-02_r8,1.0633e-02_r8, &
     &7.5736e-03_r8,4.3041e-03_r8,1.3667e-04_r8/)
      kao(:, 5, 7, 6) = (/ &
     &3.2278e-02_r8,2.8550e-02_r8,2.4932e-02_r8,2.1309e-02_r8,1.7576e-02_r8,1.3764e-02_r8, &
     &9.7979e-03_r8,5.5674e-03_r8,1.7569e-04_r8/)
      kao(:, 1, 8, 6) = (/ &
     &1.6908e-02_r8,1.4827e-02_r8,1.2781e-02_r8,1.0775e-02_r8,8.7653e-03_r8,6.7156e-03_r8, &
     &4.6263e-03_r8,2.4796e-03_r8,7.2095e-05_r8/)
      kao(:, 2, 8, 6) = (/ &
     &2.3895e-02_r8,2.0964e-02_r8,1.8085e-02_r8,1.5267e-02_r8,1.2424e-02_r8,9.5170e-03_r8, &
     &6.5710e-03_r8,3.5441e-03_r8,9.6806e-05_r8/)
      kao(:, 3, 8, 6) = (/ &
     &3.2855e-02_r8,2.8841e-02_r8,2.4900e-02_r8,2.1032e-02_r8,1.7114e-02_r8,1.3120e-02_r8, &
     &9.0780e-03_r8,4.9231e-03_r8,1.2768e-04_r8/)
      kao(:, 4, 8, 6) = (/ &
     &4.4127e-02_r8,3.8763e-02_r8,3.3492e-02_r8,2.8282e-02_r8,2.3023e-02_r8,1.7668e-02_r8, &
     &1.2245e-02_r8,6.6502e-03_r8,1.6091e-04_r8/)
      kao(:, 5, 8, 6) = (/ &
     &5.7992e-02_r8,5.0977e-02_r8,4.4047e-02_r8,3.7189e-02_r8,3.0275e-02_r8,2.3248e-02_r8, &
     &1.6136e-02_r8,8.7683e-03_r8,1.9428e-04_r8/)
      kao(:, 1, 9, 6) = (/ &
     &5.1709e-02_r8,4.5263e-02_r8,3.8825e-02_r8,3.2404e-02_r8,2.6001e-02_r8,1.9630e-02_r8, &
     &1.3270e-02_r8,6.8433e-03_r8,1.6819e-04_r8/)
      kao(:, 2, 9, 6) = (/ &
     &7.5377e-02_r8,6.5994e-02_r8,5.6614e-02_r8,4.7250e-02_r8,3.7927e-02_r8,2.8667e-02_r8, &
     &1.9405e-02_r8,1.0007e-02_r8,2.0150e-04_r8/)
      kao(:, 3, 9, 6) = (/ &
     &1.0637e-01_r8,9.3142e-02_r8,7.9913e-02_r8,6.6713e-02_r8,5.3579e-02_r8,4.0525e-02_r8, &
     &2.7438e-02_r8,1.4159e-02_r8,2.5395e-04_r8/)
      kao(:, 4, 9, 6) = (/ &
     &1.4601e-01_r8,1.2787e-01_r8,1.0973e-01_r8,9.1640e-02_r8,7.3643e-02_r8,5.5707e-02_r8, &
     &3.7721e-02_r8,1.9493e-02_r8,2.9114e-04_r8/)
      kao(:, 5, 9, 6) = (/ &
     &1.9540e-01_r8,1.7114e-01_r8,1.4689e-01_r8,1.2270e-01_r8,9.8611e-02_r8,7.4576e-02_r8, &
     &5.0506e-02_r8,2.6131e-02_r8,3.2502e-04_r8/)
      kao(:, 1,10, 6) = (/ &
     &1.7908e-01_r8,1.5672e-01_r8,1.3434e-01_r8,1.1197e-01_r8,8.9592e-02_r8,6.7243e-02_r8, &
     &4.4903e-02_r8,2.2650e-02_r8,3.5407e-04_r8/)
      kao(:, 2,10, 6) = (/ &
     &2.6809e-01_r8,2.3461e-01_r8,2.0111e-01_r8,1.6763e-01_r8,1.3416e-01_r8,1.0070e-01_r8, &
     &6.7289e-02_r8,3.4001e-02_r8,4.2267e-04_r8/)
      kao(:, 3,10, 6) = (/ &
     &3.8962e-01_r8,3.4094e-01_r8,2.9228e-01_r8,2.4365e-01_r8,1.9501e-01_r8,1.4639e-01_r8, &
     &9.7852e-02_r8,4.9496e-02_r8,5.5217e-04_r8/)
      kao(:, 4,10, 6) = (/ &
     &5.4709e-01_r8,4.7880e-01_r8,4.1047e-01_r8,3.4221e-01_r8,2.7390e-01_r8,2.0562e-01_r8, &
     &1.3748e-01_r8,6.9566e-02_r8,6.7800e-04_r8/)
      kao(:, 5,10, 6) = (/ &
     &7.4383e-01_r8,6.5097e-01_r8,5.5813e-01_r8,4.6528e-01_r8,3.7246e-01_r8,2.7966e-01_r8, &
     &1.8702e-01_r8,9.4633e-02_r8,7.9930e-04_r8/)
      kao(:, 1,11, 6) = (/ &
     &2.6405e-01_r8,2.3107e-01_r8,1.9807e-01_r8,1.6508e-01_r8,1.3209e-01_r8,9.9087e-02_r8, &
     &6.6140e-02_r8,3.3239e-02_r8,4.6661e-04_r8/)
      kao(:, 2,11, 6) = (/ &
     &3.9885e-01_r8,3.4898e-01_r8,2.9917e-01_r8,2.4935e-01_r8,1.9952e-01_r8,1.4970e-01_r8, &
     &9.9938e-02_r8,5.0287e-02_r8,6.6831e-04_r8/)
      kao(:, 3,11, 6) = (/ &
     &5.8178e-01_r8,5.0910e-01_r8,4.3644e-01_r8,3.6379e-01_r8,2.9110e-01_r8,2.1843e-01_r8, &
     &1.4582e-01_r8,7.3440e-02_r8,7.3058e-04_r8/)
      kao(:, 4,11, 6) = (/ &
     &8.2081e-01_r8,7.1832e-01_r8,6.1577e-01_r8,5.1330e-01_r8,4.1077e-01_r8,3.0826e-01_r8, &
     &2.0583e-01_r8,1.0374e-01_r8,9.0801e-04_r8/)
      kao(:, 5,11, 6) = (/ &
     &1.1196e+00_r8,9.7976e-01_r8,8.3991e-01_r8,7.0013e-01_r8,5.6034e-01_r8,4.2058e-01_r8, &
     &2.8087e-01_r8,1.4156e-01_r8,1.1083e-03_r8/)
      kao(:, 1,12, 6) = (/ &
     &2.9667e-01_r8,2.5960e-01_r8,2.2251e-01_r8,1.8545e-01_r8,1.4837e-01_r8,1.1135e-01_r8, &
     &7.4300e-02_r8,3.7344e-02_r8,4.3166e-04_r8/)
      kao(:, 2,12, 6) = (/ &
     &4.4544e-01_r8,3.8980e-01_r8,3.3414e-01_r8,2.7849e-01_r8,2.2283e-01_r8,1.6719e-01_r8, &
     &1.1158e-01_r8,5.6122e-02_r8,7.5682e-04_r8/)
      kao(:, 3,12, 6) = (/ &
     &6.4877e-01_r8,5.6770e-01_r8,4.8669e-01_r8,4.0564e-01_r8,3.2461e-01_r8,2.4355e-01_r8, &
     &1.6257e-01_r8,8.1850e-02_r8,7.9167e-04_r8/)
      kao(:, 4,12, 6) = (/ &
     &9.1198e-01_r8,7.9809e-01_r8,6.8416e-01_r8,5.7025e-01_r8,4.5635e-01_r8,3.4245e-01_r8, &
     &2.2863e-01_r8,1.1515e-01_r8,9.9906e-04_r8/)
      kao(:, 5,12, 6) = (/ &
     &1.2467e+00_r8,1.0910e+00_r8,9.3529e-01_r8,7.7959e-01_r8,6.2391e-01_r8,4.6827e-01_r8, &
     &3.1271e-01_r8,1.5753e-01_r8,1.2003e-03_r8/)
      kao(:, 1,13, 6) = (/ &
     &2.7690e-01_r8,2.4228e-01_r8,2.0769e-01_r8,1.7308e-01_r8,1.3848e-01_r8,1.0389e-01_r8, &
     &6.9340e-02_r8,3.4888e-02_r8,4.3050e-04_r8/)
      kao(:, 2,13, 6) = (/ &
     &4.0226e-01_r8,3.5198e-01_r8,3.0172e-01_r8,2.5145e-01_r8,2.0123e-01_r8,1.5101e-01_r8, &
     &1.0081e-01_r8,5.0783e-02_r8,7.1649e-04_r8/)
      kao(:, 3,13, 6) = (/ &
     &5.7863e-01_r8,5.0634e-01_r8,4.3410e-01_r8,3.6182e-01_r8,2.8956e-01_r8,2.1728e-01_r8, &
     &1.4512e-01_r8,7.3148e-02_r8,7.7482e-04_r8/)
      kao(:, 4,13, 6) = (/ &
     &8.1324e-01_r8,7.1165e-01_r8,6.1013e-01_r8,5.0851e-01_r8,4.0696e-01_r8,3.0541e-01_r8, &
     &2.0404e-01_r8,1.0287e-01_r8,9.9392e-04_r8/)
      kao(:, 5,13, 6) = (/ &
     &1.1104e+00_r8,9.7179e-01_r8,8.3315e-01_r8,6.9450e-01_r8,5.5586e-01_r8,4.1728e-01_r8, &
     &2.7889e-01_r8,1.4068e-01_r8,1.1816e-03_r8/)
      kao(:, 1, 1, 7) = (/ &
     &3.5054e-03_r8,3.5055e-03_r8,3.5120e-03_r8,3.3810e-03_r8,3.1730e-03_r8,2.8811e-03_r8, &
     &2.4850e-03_r8,1.7479e-03_r8,1.1652e-03_r8/)
      kao(:, 2, 1, 7) = (/ &
     &4.3050e-03_r8,4.3583e-03_r8,4.3910e-03_r8,4.2644e-03_r8,4.0306e-03_r8,3.6880e-03_r8, &
     &3.2528e-03_r8,2.5892e-03_r8,1.6752e-03_r8/)
      kao(:, 3, 1, 7) = (/ &
     &5.1735e-03_r8,5.2976e-03_r8,5.3803e-03_r8,5.2761e-03_r8,5.0137e-03_r8,4.6183e-03_r8, &
     &4.1353e-03_r8,3.5068e-03_r8,2.2495e-03_r8/)
      kao(:, 4, 1, 7) = (/ &
     &6.1057e-03_r8,6.3115e-03_r8,6.4786e-03_r8,6.4038e-03_r8,6.1210e-03_r8,5.6909e-03_r8, &
     &5.1278e-03_r8,4.5615e-03_r8,2.9063e-03_r8/)
      kao(:, 5, 1, 7) = (/ &
     &7.0959e-03_r8,7.4049e-03_r8,7.6778e-03_r8,7.6470e-03_r8,7.3706e-03_r8,6.8965e-03_r8, &
     &6.2418e-03_r8,5.7511e-03_r8,3.6720e-03_r8/)
      kao(:, 1, 2, 7) = (/ &
     &4.4522e-03_r8,4.2827e-03_r8,4.1712e-03_r8,3.9058e-03_r8,3.5730e-03_r8,3.1581e-03_r8, &
     &2.6434e-03_r8,1.9182e-03_r8,8.6485e-04_r8/)
      kao(:, 2, 2, 7) = (/ &
     &5.5183e-03_r8,5.3551e-03_r8,5.2393e-03_r8,4.9436e-03_r8,4.5529e-03_r8,4.0469e-03_r8, &
     &3.4309e-03_r8,2.6479e-03_r8,1.2370e-03_r8/)
      kao(:, 3, 2, 7) = (/ &
     &6.6858e-03_r8,6.5555e-03_r8,6.4351e-03_r8,6.1353e-03_r8,5.6849e-03_r8,5.0737e-03_r8, &
     &4.3365e-03_r8,3.4457e-03_r8,1.6663e-03_r8/)
      kao(:, 4, 2, 7) = (/ &
     &7.9566e-03_r8,7.8606e-03_r8,7.7697e-03_r8,7.4702e-03_r8,6.9634e-03_r8,6.2571e-03_r8, &
     &5.3849e-03_r8,4.3375e-03_r8,2.1739e-03_r8/)
      kao(:, 5, 2, 7) = (/ &
     &9.3107e-03_r8,9.2749e-03_r8,9.2506e-03_r8,8.9459e-03_r8,8.3896e-03_r8,7.5840e-03_r8, &
     &6.5605e-03_r8,5.3408e-03_r8,2.7747e-03_r8/)
      kao(:, 1, 3, 7) = (/ &
     &7.1663e-03_r8,6.5385e-03_r8,6.0832e-03_r8,5.5176e-03_r8,4.8422e-03_r8,4.1012e-03_r8, &
     &3.2557e-03_r8,2.2244e-03_r8,5.9815e-04_r8/)
      kao(:, 2, 3, 7) = (/ &
     &9.0118e-03_r8,8.2694e-03_r8,7.7301e-03_r8,7.0328e-03_r8,6.2053e-03_r8,5.2869e-03_r8, &
     &4.2235e-03_r8,2.9652e-03_r8,8.5322e-04_r8/)
      kao(:, 3, 3, 7) = (/ &
     &1.1073e-02_r8,1.0215e-02_r8,9.5832e-03_r8,8.7498e-03_r8,7.7844e-03_r8,6.6733e-03_r8, &
     &5.3588e-03_r8,3.8104e-03_r8,1.1597e-03_r8/)
      kao(:, 4, 3, 7) = (/ &
     &1.3336e-02_r8,1.2373e-02_r8,1.1642e-02_r8,1.0696e-02_r8,9.5807e-03_r8,8.2482e-03_r8, &
     &6.6726e-03_r8,4.7891e-03_r8,1.5317e-03_r8/)
      kao(:, 5, 3, 7) = (/ &
     &1.5766e-02_r8,1.4727e-02_r8,1.3917e-02_r8,1.2876e-02_r8,1.1585e-02_r8,1.0016e-02_r8, &
     &8.1535e-03_r8,5.8982e-03_r8,1.9785e-03_r8/)
      kao(:, 1, 4, 7) = (/ &
     &1.1443e-02_r8,1.0194e-02_r8,9.0847e-03_r8,8.0229e-03_r8,6.8443e-03_r8,5.5702e-03_r8, &
     &4.2183e-03_r8,2.6813e-03_r8,4.0030e-04_r8/)
      kao(:, 2, 4, 7) = (/ &
     &1.4659e-02_r8,1.3095e-02_r8,1.1714e-02_r8,1.0375e-02_r8,8.8664e-03_r8,7.2483e-03_r8, &
     &5.5253e-03_r8,3.5568e-03_r8,5.7754e-04_r8/)
      kao(:, 3, 4, 7) = (/ &
     &1.8306e-02_r8,1.6401e-02_r8,1.4719e-02_r8,1.3058e-02_r8,1.1190e-02_r8,9.2063e-03_r8, &
     &7.0626e-03_r8,4.5942e-03_r8,7.9824e-04_r8/)
      kao(:, 4, 4, 7) = (/ &
     &2.2363e-02_r8,2.0101e-02_r8,1.8107e-02_r8,1.6087e-02_r8,1.3850e-02_r8,1.1470e-02_r8, &
     &8.8334e-03_r8,5.7997e-03_r8,1.0688e-03_r8/)
      kao(:, 5, 4, 7) = (/ &
     &2.6741e-02_r8,2.4136e-02_r8,2.1831e-02_r8,1.9473e-02_r8,1.6867e-02_r8,1.4029e-02_r8, &
     &1.0846e-02_r8,7.1614e-03_r8,1.3988e-03_r8/)
      kao(:, 1, 5, 7) = (/ &
     &1.6600e-02_r8,1.4668e-02_r8,1.2778e-02_r8,1.1029e-02_r8,9.2361e-03_r8,7.3333e-03_r8, &
     &5.3444e-03_r8,3.2124e-03_r8,2.6040e-04_r8/)
      kao(:, 2, 5, 7) = (/ &
     &2.1709e-02_r8,1.9200e-02_r8,1.6777e-02_r8,1.4511e-02_r8,1.2172e-02_r8,9.6744e-03_r8, &
     &7.0766e-03_r8,4.2987e-03_r8,3.8620e-04_r8/)
      kao(:, 3, 5, 7) = (/ &
     &2.7589e-02_r8,2.4430e-02_r8,2.1405e-02_r8,1.8550e-02_r8,1.5579e-02_r8,1.2414e-02_r8, &
     &9.1361e-03_r8,5.5941e-03_r8,5.4726e-04_r8/)
      kao(:, 4, 5, 7) = (/ &
     &3.4183e-02_r8,3.0324e-02_r8,2.6641e-02_r8,2.3153e-02_r8,1.9480e-02_r8,1.5601e-02_r8, &
     &1.1542e-02_r8,7.1098e-03_r8,7.4652e-04_r8/)
      kao(:, 5, 5, 7) = (/ &
     &4.1421e-02_r8,3.6823e-02_r8,3.2447e-02_r8,2.8275e-02_r8,2.3873e-02_r8,1.9232e-02_r8, &
     &1.4297e-02_r8,8.8472e-03_r8,9.9177e-04_r8/)
      kao(:, 1, 6, 7) = (/ &
     &2.2041e-02_r8,1.9394e-02_r8,1.6757e-02_r8,1.4215e-02_r8,1.1736e-02_r8,9.1749e-03_r8, &
     &6.5141e-03_r8,3.7310e-03_r8,1.4404e-04_r8/)
      kao(:, 2, 6, 7) = (/ &
     &2.9498e-02_r8,2.5961e-02_r8,2.2459e-02_r8,1.9104e-02_r8,1.5796e-02_r8,1.2359e-02_r8, &
     &8.7857e-03_r8,5.0673e-03_r8,2.3466e-04_r8/)
      kao(:, 3, 6, 7) = (/ &
     &3.8260e-02_r8,3.3683e-02_r8,2.9196e-02_r8,2.4887e-02_r8,2.0608e-02_r8,1.6142e-02_r8, &
     &1.1503e-02_r8,6.6775e-03_r8,3.4879e-04_r8/)
      kao(:, 4, 6, 7) = (/ &
     &4.8196e-02_r8,4.2468e-02_r8,3.6884e-02_r8,3.1502e-02_r8,2.6137e-02_r8,2.0520e-02_r8, &
     &1.4704e-02_r8,8.5847e-03_r8,4.9990e-04_r8/)
      kao(:, 5, 6, 7) = (/ &
     &5.9282e-02_r8,5.2285e-02_r8,4.5513e-02_r8,3.8965e-02_r8,3.2393e-02_r8,2.5526e-02_r8, &
     &1.8401e-02_r8,1.0794e-02_r8,6.8674e-04_r8/)
      kao(:, 1, 7, 7) = (/ &
     &3.0340e-02_r8,2.6632e-02_r8,2.2911e-02_r8,1.9238e-02_r8,1.5651e-02_r8,1.2078e-02_r8, &
     &8.4116e-03_r8,4.6225e-03_r8,1.1044e-04_r8/)
      kao(:, 2, 7, 7) = (/ &
     &4.1630e-02_r8,3.6541e-02_r8,3.1448e-02_r8,2.6441e-02_r8,2.1565e-02_r8,1.6662e-02_r8, &
     &1.1608e-02_r8,6.3979e-03_r8,1.5103e-04_r8/)
      kao(:, 3, 7, 7) = (/ &
     &5.5141e-02_r8,4.8404e-02_r8,4.1697e-02_r8,3.5120e-02_r8,2.8696e-02_r8,2.2204e-02_r8, &
     &1.5482e-02_r8,8.5690e-03_r8,2.0480e-04_r8/)
      kao(:, 4, 7, 7) = (/ &
     &7.0797e-02_r8,6.2144e-02_r8,5.3596e-02_r8,4.5212e-02_r8,3.6995e-02_r8,2.8664e-02_r8, &
     &2.0039e-02_r8,1.1163e-02_r8,2.9866e-04_r8/)
      kao(:, 5, 7, 7) = (/ &
     &8.8459e-02_r8,7.7674e-02_r8,6.7088e-02_r8,5.6677e-02_r8,4.6470e-02_r8,3.6087e-02_r8, &
     &2.5332e-02_r8,1.4195e-02_r8,4.2372e-04_r8/)
      kao(:, 1, 8, 7) = (/ &
     &4.9601e-02_r8,4.3472e-02_r8,3.7321e-02_r8,3.1177e-02_r8,2.5072e-02_r8,1.9045e-02_r8, &
     &1.3035e-02_r8,6.9120e-03_r8,1.2554e-04_r8/)
      kao(:, 2, 8, 7) = (/ &
     &6.9873e-02_r8,6.1229e-02_r8,5.2577e-02_r8,4.3926e-02_r8,3.5352e-02_r8,2.6911e-02_r8, &
     &1.8460e-02_r8,9.7927e-03_r8,1.5143e-04_r8/)
      kao(:, 3, 8, 7) = (/ &
     &9.4645e-02_r8,8.2931e-02_r8,7.1217e-02_r8,5.9530e-02_r8,4.7979e-02_r8,3.6597e-02_r8, &
     &2.5135e-02_r8,1.3350e-02_r8,1.8982e-04_r8/)
      kao(:, 4, 8, 7) = (/ &
     &1.2398e-01_r8,1.0863e-01_r8,9.3295e-02_r8,7.8049e-02_r8,6.2983e-02_r8,4.8099e-02_r8, &
     &3.3072e-02_r8,1.7624e-02_r8,2.4338e-04_r8/)
      kao(:, 5, 8, 7) = (/ &
     &1.5756e-01_r8,1.3808e-01_r8,1.1863e-01_r8,9.9354e-02_r8,8.0265e-02_r8,6.1390e-02_r8, &
     &4.2297e-02_r8,2.2655e-02_r8,3.0934e-04_r8/)
      kao(:, 1, 9, 7) = (/ &
     &1.5112e-01_r8,1.3227e-01_r8,1.1344e-01_r8,9.4596e-02_r8,7.5748e-02_r8,5.6892e-02_r8, &
     &3.8080e-02_r8,1.9401e-02_r8,2.5169e-04_r8/)
      kao(:, 2, 9, 7) = (/ &
     &2.1904e-01_r8,1.9173e-01_r8,1.6442e-01_r8,1.3710e-01_r8,1.0978e-01_r8,8.2457e-02_r8, &
     &5.5213e-02_r8,2.8220e-02_r8,3.2207e-04_r8/)
      kao(:, 3, 9, 7) = (/ &
     &3.0409e-01_r8,2.6618e-01_r8,2.2825e-01_r8,1.9033e-01_r8,1.5240e-01_r8,1.1448e-01_r8, &
     &7.6724e-02_r8,3.9326e-02_r8,3.9043e-04_r8/)
      kao(:, 4, 9, 7) = (/ &
     &4.0691e-01_r8,3.5618e-01_r8,3.0544e-01_r8,2.5467e-01_r8,2.0393e-01_r8,1.5326e-01_r8, &
     &1.0281e-01_r8,5.2796e-02_r8,4.7191e-04_r8/)
      kao(:, 5, 9, 7) = (/ &
     &5.2694e-01_r8,4.6123e-01_r8,3.9556e-01_r8,3.2985e-01_r8,2.6417e-01_r8,1.9865e-01_r8, &
     &1.3342e-01_r8,6.8629e-02_r8,5.3966e-04_r8/)
      kao(:, 1,10, 7) = (/ &
     &5.2400e-01_r8,4.5853e-01_r8,3.9306e-01_r8,3.2760e-01_r8,2.6216e-01_r8,1.9669e-01_r8, &
     &1.3123e-01_r8,6.5752e-02_r8,5.0343e-04_r8/)
      kao(:, 2,10, 7) = (/ &
     &7.8161e-01_r8,6.8400e-01_r8,5.8634e-01_r8,4.8867e-01_r8,3.9103e-01_r8,2.9337e-01_r8, &
     &1.9570e-01_r8,9.8059e-02_r8,7.7212e-04_r8/)
      kao(:, 3,10, 7) = (/ &
     &1.1108e+00_r8,9.7208e-01_r8,8.3335e-01_r8,6.9453e-01_r8,5.5575e-01_r8,4.1693e-01_r8, &
     &2.7814e-01_r8,1.3935e-01_r8,8.3303e-04_r8/)
      kao(:, 4,10, 7) = (/ &
     &1.5159e+00_r8,1.3265e+00_r8,1.1372e+00_r8,9.4781e-01_r8,7.5840e-01_r8,5.6900e-01_r8, &
     &3.7960e-01_r8,1.9025e-01_r8,1.0516e-03_r8/)
      kao(:, 5,10, 7) = (/ &
     &2.0008e+00_r8,1.7509e+00_r8,1.5009e+00_r8,1.2510e+00_r8,1.0010e+00_r8,7.5106e-01_r8, &
     &5.0105e-01_r8,2.5132e-01_r8,1.2795e-03_r8/)
      kao(:, 1,11, 7) = (/ &
     &7.6934e-01_r8,6.7322e-01_r8,5.7711e-01_r8,4.8095e-01_r8,3.8483e-01_r8,2.8868e-01_r8, &
     &1.9254e-01_r8,9.6383e-02_r8,4.1213e-04_r8/)
      kao(:, 2,11, 7) = (/ &
     &1.1531e+00_r8,1.0090e+00_r8,8.6492e-01_r8,7.2086e-01_r8,5.7680e-01_r8,4.3268e-01_r8, &
     &2.8857e-01_r8,1.4445e-01_r8,7.8643e-04_r8/)
      kao(:, 3,11, 7) = (/ &
     &1.6479e+00_r8,1.4420e+00_r8,1.2361e+00_r8,1.0302e+00_r8,8.2427e-01_r8,6.1836e-01_r8, &
     &4.1243e-01_r8,2.0646e-01_r8,1.3424e-03_r8/)
      kao(:, 4,11, 7) = (/ &
     &2.2624e+00_r8,1.9796e+00_r8,1.6970e+00_r8,1.4143e+00_r8,1.1316e+00_r8,8.4892e-01_r8, &
     &5.6619e-01_r8,2.8348e-01_r8,1.4044e-03_r8/)
      kao(:, 5,11, 7) = (/ &
     &3.0074e+00_r8,2.6315e+00_r8,2.2558e+00_r8,1.8800e+00_r8,1.5042e+00_r8,1.1285e+00_r8, &
     &7.5266e-01_r8,3.7695e-01_r8,1.6947e-03_r8/)
      kao(:, 1,12, 7) = (/ &
     &8.4478e-01_r8,7.3926e-01_r8,6.3371e-01_r8,5.2813e-01_r8,4.2255e-01_r8,3.1696e-01_r8, &
     &2.1141e-01_r8,1.0578e-01_r8,4.0897e-04_r8/)
      kao(:, 2,12, 7) = (/ &
     &1.2687e+00_r8,1.1101e+00_r8,9.5161e-01_r8,7.9307e-01_r8,6.3449e-01_r8,4.7596e-01_r8, &
     &3.1742e-01_r8,1.5884e-01_r8,7.3572e-04_r8/)
      kao(:, 3,12, 7) = (/ &
     &1.8247e+00_r8,1.5966e+00_r8,1.3686e+00_r8,1.1406e+00_r8,9.1261e-01_r8,6.8459e-01_r8, &
     &4.5656e-01_r8,2.2852e-01_r8,1.3876e-03_r8/)
      kao(:, 4,12, 7) = (/ &
     &2.5294e+00_r8,2.2134e+00_r8,1.8973e+00_r8,1.5812e+00_r8,1.2652e+00_r8,9.4906e-01_r8, &
     &6.3294e-01_r8,3.1685e-01_r8,1.6774e-03_r8/)
      kao(:, 5,12, 7) = (/ &
     &3.3840e+00_r8,2.9611e+00_r8,2.5383e+00_r8,2.1154e+00_r8,1.6926e+00_r8,1.2697e+00_r8, &
     &8.4679e-01_r8,4.2403e-01_r8,1.9227e-03_r8/)
      kao(:, 1,13, 7) = (/ &
     &7.4992e-01_r8,6.5626e-01_r8,5.6252e-01_r8,4.6882e-01_r8,3.7512e-01_r8,2.8140e-01_r8, &
     &1.8768e-01_r8,9.3938e-02_r8,4.2556e-04_r8/)
      kao(:, 2,13, 7) = (/ &
     &1.1304e+00_r8,9.8913e-01_r8,8.4793e-01_r8,7.0671e-01_r8,5.6541e-01_r8,4.2417e-01_r8, &
     &2.8288e-01_r8,1.4159e-01_r8,7.8986e-04_r8/)
      kao(:, 3,13, 7) = (/ &
     &1.6343e+00_r8,1.4300e+00_r8,1.2259e+00_r8,1.0217e+00_r8,8.1745e-01_r8,6.1321e-01_r8, &
     &4.0897e-01_r8,2.0475e-01_r8,1.4019e-03_r8/)
      kao(:, 4,13, 7) = (/ &
     &2.2667e+00_r8,1.9834e+00_r8,1.7002e+00_r8,1.4170e+00_r8,1.1337e+00_r8,8.5047e-01_r8, &
     &5.6722e-01_r8,2.8408e-01_r8,1.6857e-03_r8/)
      kao(:, 5,13, 7) = (/ &
     &3.0450e+00_r8,2.6646e+00_r8,2.2841e+00_r8,1.9036e+00_r8,1.5231e+00_r8,1.1426e+00_r8, &
     &7.6204e-01_r8,3.8179e-01_r8,1.9578e-03_r8/)
      kao(:, 1, 1, 8) = (/ &
     &7.5530e-03_r8,7.1946e-03_r8,6.9309e-03_r8,6.6476e-03_r8,6.1286e-03_r8,5.5188e-03_r8, &
     &4.8784e-03_r8,4.0369e-03_r8,3.2329e-03_r8/)
      kao(:, 2, 1, 8) = (/ &
     &9.1868e-03_r8,8.8285e-03_r8,8.6011e-03_r8,8.3060e-03_r8,7.7227e-03_r8,7.0815e-03_r8, &
     &6.4738e-03_r8,5.8694e-03_r8,4.4599e-03_r8/)
      kao(:, 3, 1, 8) = (/ &
     &1.0993e-02_r8,1.0661e-02_r8,1.0487e-02_r8,1.0178e-02_r8,9.5750e-03_r8,8.9143e-03_r8, &
     &8.3359e-03_r8,7.9019e-03_r8,5.9682e-03_r8/)
      kao(:, 4, 1, 8) = (/ &
     &1.2929e-02_r8,1.2692e-02_r8,1.2580e-02_r8,1.2285e-02_r8,1.1693e-02_r8,1.1035e-02_r8, &
     &1.0548e-02_r8,1.0225e-02_r8,7.8210e-03_r8/)
      kao(:, 5, 1, 8) = (/ &
     &1.4992e-02_r8,1.4924e-02_r8,1.4888e-02_r8,1.4659e-02_r8,1.4068e-02_r8,1.3474e-02_r8, &
     &1.3107e-02_r8,1.2867e-02_r8,1.0020e-02_r8/)
      kao(:, 1, 2, 8) = (/ &
     &1.0207e-02_r8,9.4797e-03_r8,8.8085e-03_r8,8.2309e-03_r8,7.4348e-03_r8,6.4679e-03_r8, &
     &5.3282e-03_r8,4.0056e-03_r8,2.5229e-03_r8/)
      kao(:, 2, 2, 8) = (/ &
     &1.2558e-02_r8,1.1748e-02_r8,1.1002e-02_r8,1.0338e-02_r8,9.3997e-03_r8,8.2648e-03_r8, &
     &6.9317e-03_r8,5.5570e-03_r8,3.5029e-03_r8/)
      kao(:, 3, 2, 8) = (/ &
     &1.5167e-02_r8,1.4277e-02_r8,1.3509e-02_r8,1.2727e-02_r8,1.1653e-02_r8,1.0352e-02_r8, &
     &8.8205e-03_r8,7.4037e-03_r8,4.7140e-03_r8/)
      kao(:, 4, 2, 8) = (/ &
     &1.7986e-02_r8,1.7073e-02_r8,1.6287e-02_r8,1.5417e-02_r8,1.4234e-02_r8,1.2722e-02_r8, &
     &1.1029e-02_r8,9.5450e-03_r8,6.1941e-03_r8/)
      kao(:, 5, 2, 8) = (/ &
     &2.1016e-02_r8,2.0104e-02_r8,1.9317e-02_r8,1.8415e-02_r8,1.7125e-02_r8,1.5397e-02_r8, &
     &1.3573e-02_r8,1.2029e-02_r8,7.9674e-03_r8/)
      kao(:, 1, 3, 8) = (/ &
     &1.7495e-02_r8,1.5793e-02_r8,1.4039e-02_r8,1.2465e-02_r8,1.0907e-02_r8,9.1072e-03_r8, &
     &7.1058e-03_r8,4.8343e-03_r8,1.7832e-03_r8/)
      kao(:, 2, 3, 8) = (/ &
     &2.1893e-02_r8,1.9841e-02_r8,1.7709e-02_r8,1.5801e-02_r8,1.3894e-02_r8,1.1662e-02_r8, &
     &9.2038e-03_r8,6.3817e-03_r8,2.5128e-03_r8/)
      kao(:, 3, 3, 8) = (/ &
     &2.6790e-02_r8,2.4372e-02_r8,2.1871e-02_r8,1.9635e-02_r8,1.7311e-02_r8,1.4624e-02_r8, &
     &1.1658e-02_r8,8.2109e-03_r8,3.4348e-03_r8/)
      kao(:, 4, 3, 8) = (/ &
     &3.2142e-02_r8,2.9358e-02_r8,2.6490e-02_r8,2.3921e-02_r8,2.1182e-02_r8,1.8026e-02_r8, &
     &1.4487e-02_r8,1.0373e-02_r8,4.5646e-03_r8/)
      kao(:, 5, 3, 8) = (/ &
     &3.7933e-02_r8,3.4749e-02_r8,3.1541e-02_r8,2.8628e-02_r8,2.5501e-02_r8,2.1864e-02_r8, &
     &1.7709e-02_r8,1.2883e-02_r8,5.9131e-03_r8/)
      kao(:, 1, 4, 8) = (/ &
     &2.9550e-02_r8,2.6227e-02_r8,2.2910e-02_r8,1.9604e-02_r8,1.6469e-02_r8,1.3339e-02_r8, &
     &9.9415e-03_r8,6.2262e-03_r8,1.2135e-03_r8/)
      kao(:, 2, 4, 8) = (/ &
     &3.7687e-02_r8,3.3528e-02_r8,2.9343e-02_r8,2.5186e-02_r8,2.1249e-02_r8,1.7292e-02_r8, &
     &1.2959e-02_r8,8.2307e-03_r8,1.7374e-03_r8/)
      kao(:, 3, 4, 8) = (/ &
     &4.6817e-02_r8,4.1770e-02_r8,3.6634e-02_r8,3.1558e-02_r8,2.6759e-02_r8,2.1861e-02_r8, &
     &1.6492e-02_r8,1.0607e-02_r8,2.4118e-03_r8/)
      kao(:, 4, 4, 8) = (/ &
     &5.6963e-02_r8,5.0934e-02_r8,4.4739e-02_r8,3.8692e-02_r8,3.2979e-02_r8,2.7058e-02_r8, &
     &2.0566e-02_r8,1.3387e-02_r8,3.2525e-03_r8/)
      kao(:, 5, 4, 8) = (/ &
     &6.8137e-02_r8,6.0987e-02_r8,5.3660e-02_r8,4.6589e-02_r8,3.9864e-02_r8,3.2872e-02_r8, &
     &2.5218e-02_r8,1.6596e-02_r8,4.2777e-03_r8/)
      kao(:, 1, 5, 8) = (/ &
     &4.4958e-02_r8,3.9602e-02_r8,3.4298e-02_r8,2.8957e-02_r8,2.3691e-02_r8,1.8601e-02_r8, &
     &1.3441e-02_r8,7.9068e-03_r8,8.1517e-04_r8/)
      kao(:, 2, 5, 8) = (/ &
     &5.8476e-02_r8,5.1578e-02_r8,4.4743e-02_r8,3.7815e-02_r8,3.1045e-02_r8,2.4482e-02_r8, &
     &1.7770e-02_r8,1.0541e-02_r8,1.1885e-03_r8/)
      kao(:, 3, 5, 8) = (/ &
     &7.3906e-02_r8,6.5268e-02_r8,5.6679e-02_r8,4.8013e-02_r8,3.9537e-02_r8,3.1318e-02_r8, &
     &2.2852e-02_r8,1.3697e-02_r8,1.6746e-03_r8/)
      kao(:, 4, 5, 8) = (/ &
     &9.1296e-02_r8,8.0739e-02_r8,7.0175e-02_r8,5.9533e-02_r8,4.9168e-02_r8,3.9100e-02_r8, &
     &2.8676e-02_r8,1.7397e-02_r8,2.2909e-03_r8/)
      kao(:, 5, 5, 8) = (/ &
     &1.1069e-01_r8,9.7986e-02_r8,8.5202e-02_r8,7.2388e-02_r8,5.9975e-02_r8,4.7864e-02_r8, &
     &3.5291e-02_r8,2.1668e-02_r8,3.0530e-03_r8/)
      kao(:, 1, 6, 8) = (/ &
     &6.2124e-02_r8,5.4544e-02_r8,4.6999e-02_r8,3.9470e-02_r8,3.1923e-02_r8,2.4497e-02_r8, &
     &1.7234e-02_r8,9.7062e-03_r8,5.1266e-04_r8/)
      kao(:, 2, 6, 8) = (/ &
     &8.2639e-02_r8,7.2604e-02_r8,6.2611e-02_r8,5.2626e-02_r8,4.2613e-02_r8,3.2833e-02_r8, &
     &2.3213e-02_r8,1.3144e-02_r8,7.8429e-04_r8/)
      kao(:, 3, 6, 8) = (/ &
     &1.0657e-01_r8,9.3700e-02_r8,8.0879e-02_r8,6.8013e-02_r8,5.5195e-02_r8,4.2665e-02_r8, &
     &3.0306e-02_r8,1.7290e-02_r8,1.1388e-03_r8/)
      kao(:, 4, 6, 8) = (/ &
     &1.3398e-01_r8,1.1789e-01_r8,1.0183e-01_r8,8.5694e-02_r8,6.9665e-02_r8,5.3995e-02_r8, &
     &3.8486e-02_r8,2.2145e-02_r8,1.5829e-03_r8/)
      kao(:, 5, 6, 8) = (/ &
     &1.6490e-01_r8,1.4520e-01_r8,1.2544e-01_r8,1.0568e-01_r8,8.6025e-02_r8,6.6861e-02_r8, &
     &4.7818e-02_r8,2.7758e-02_r8,2.1408e-03_r8/)
      kao(:, 1, 7, 8) = (/ &
     &8.8474e-02_r8,7.7539e-02_r8,6.6627e-02_r8,5.5731e-02_r8,4.4842e-02_r8,3.3990e-02_r8, &
     &2.3276e-02_r8,1.2620e-02_r8,2.5937e-04_r8/)
      kao(:, 2, 7, 8) = (/ &
     &1.2057e-01_r8,1.0571e-01_r8,9.0876e-02_r8,7.6061e-02_r8,6.1253e-02_r8,4.6466e-02_r8, &
     &3.1963e-02_r8,1.7441e-02_r8,4.2731e-04_r8/)
      kao(:, 3, 7, 8) = (/ &
     &1.5880e-01_r8,1.3927e-01_r8,1.1980e-01_r8,1.0034e-01_r8,8.0808e-02_r8,6.1423e-02_r8, &
     &4.2427e-02_r8,2.3279e-02_r8,6.8413e-04_r8/)
      kao(:, 4, 7, 8) = (/ &
     &2.0345e-01_r8,1.7853e-01_r8,1.5363e-01_r8,1.2871e-01_r8,1.0372e-01_r8,7.9011e-02_r8, &
     &5.4743e-02_r8,3.0170e-02_r8,1.0214e-03_r8/)
      kao(:, 5, 7, 8) = (/ &
     &2.5461e-01_r8,2.2346e-01_r8,1.9234e-01_r8,1.6117e-01_r8,1.3002e-01_r8,9.9184e-02_r8, &
     &6.8901e-02_r8,3.8181e-02_r8,1.4552e-03_r8/)
      kao(:, 1, 8, 8) = (/ &
     &1.4868e-01_r8,1.3017e-01_r8,1.1167e-01_r8,9.3201e-02_r8,7.4739e-02_r8,5.6278e-02_r8, &
     &3.7905e-02_r8,1.9693e-02_r8,2.2804e-04_r8/)
      kao(:, 2, 8, 8) = (/ &
     &2.0798e-01_r8,1.8213e-01_r8,1.5630e-01_r8,1.3048e-01_r8,1.0468e-01_r8,7.8891e-02_r8, &
     &5.3152e-02_r8,2.7778e-02_r8,2.9739e-04_r8/)
      kao(:, 3, 8, 8) = (/ &
     &2.8017e-01_r8,2.4539e-01_r8,2.1065e-01_r8,1.7590e-01_r8,1.4119e-01_r8,1.0644e-01_r8, &
     &7.1779e-02_r8,3.7725e-02_r8,3.8946e-04_r8/)
      kao(:, 4, 8, 8) = (/ &
     &3.6604e-01_r8,3.2068e-01_r8,2.7532e-01_r8,2.2999e-01_r8,1.8464e-01_r8,1.3919e-01_r8, &
     &9.4095e-02_r8,4.9659e-02_r8,5.6194e-04_r8/)
      kao(:, 5, 8, 8) = (/ &
     &4.6634e-01_r8,4.0858e-01_r8,3.5083e-01_r8,2.9310e-01_r8,2.3536e-01_r8,1.7756e-01_r8, &
     &1.2024e-01_r8,6.3667e-02_r8,8.0698e-04_r8/)
      kao(:, 1, 9, 8) = (/ &
     &4.6269e-01_r8,4.0493e-01_r8,3.4715e-01_r8,2.8935e-01_r8,2.3157e-01_r8,1.7382e-01_r8, &
     &1.1609e-01_r8,5.8382e-02_r8,3.9623e-04_r8/)
      kao(:, 2, 9, 8) = (/ &
     &6.6628e-01_r8,5.8309e-01_r8,4.9991e-01_r8,4.1673e-01_r8,3.3358e-01_r8,2.5043e-01_r8, &
     &1.6730e-01_r8,8.4243e-02_r8,5.2033e-04_r8/)
      kao(:, 3, 9, 8) = (/ &
     &9.1981e-01_r8,8.0501e-01_r8,6.9024e-01_r8,5.7543e-01_r8,4.6067e-01_r8,3.4594e-01_r8, &
     &2.3120e-01_r8,1.1646e-01_r8,6.1848e-04_r8/)
      kao(:, 4, 9, 8) = (/ &
     &1.2275e+00_r8,1.0743e+00_r8,9.2117e-01_r8,7.6798e-01_r8,6.1489e-01_r8,4.6180e-01_r8, &
     &3.0869e-01_r8,1.5554e-01_r8,7.6432e-04_r8/)
      kao(:, 5, 9, 8) = (/ &
     &1.5931e+00_r8,1.3944e+00_r8,1.1956e+00_r8,9.9699e-01_r8,7.9825e-01_r8,5.9958e-01_r8, &
     &4.0095e-01_r8,2.0227e-01_r8,9.3678e-04_r8/)
      kao(:, 1,10, 8) = (/ &
     &1.6306e+00_r8,1.4267e+00_r8,1.2230e+00_r8,1.0192e+00_r8,8.1547e-01_r8,6.1164e-01_r8, &
     &4.0787e-01_r8,2.0413e-01_r8,4.5853e-04_r8/)
      kao(:, 2,10, 8) = (/ &
     &2.4126e+00_r8,2.1111e+00_r8,1.8096e+00_r8,1.5081e+00_r8,1.2066e+00_r8,9.0513e-01_r8, &
     &6.0364e-01_r8,3.0217e-01_r8,8.3201e-04_r8/)
      kao(:, 3,10, 8) = (/ &
     &3.4093e+00_r8,2.9833e+00_r8,2.5573e+00_r8,2.1313e+00_r8,1.7053e+00_r8,1.2792e+00_r8, &
     &8.5320e-01_r8,4.2724e-01_r8,1.5974e-03_r8/)
      kao(:, 4,10, 8) = (/ &
     &4.6433e+00_r8,4.0630e+00_r8,3.4826e+00_r8,2.9025e+00_r8,2.3226e+00_r8,1.7423e+00_r8, &
     &1.1621e+00_r8,5.8201e-01_r8,1.5962e-03_r8/)
      kao(:, 5,10, 8) = (/ &
     &6.1277e+00_r8,5.3619e+00_r8,4.5964e+00_r8,3.8308e+00_r8,3.0651e+00_r8,2.2994e+00_r8, &
     &1.5338e+00_r8,7.6843e-01_r8,2.0260e-03_r8/)
      kao(:, 1,11, 8) = (/ &
     &2.4162e+00_r8,2.1143e+00_r8,1.8124e+00_r8,1.5103e+00_r8,1.2083e+00_r8,9.0631e-01_r8, &
     &6.0429e-01_r8,3.0233e-01_r8,6.1607e-04_r8/)
      kao(:, 2,11, 8) = (/ &
     &3.5951e+00_r8,3.1458e+00_r8,2.6963e+00_r8,2.2470e+00_r8,1.7978e+00_r8,1.3484e+00_r8, &
     &8.9917e-01_r8,4.4993e-01_r8,6.5176e-04_r8/)
      kao(:, 3,11, 8) = (/ &
     &5.1060e+00_r8,4.4678e+00_r8,3.8297e+00_r8,3.1915e+00_r8,2.5535e+00_r8,1.9153e+00_r8, &
     &1.2772e+00_r8,6.3920e-01_r8,1.2930e-03_r8/)
      kao(:, 4,11, 8) = (/ &
     &6.9828e+00_r8,6.1098e+00_r8,5.2373e+00_r8,4.3645e+00_r8,3.4923e+00_r8,2.6195e+00_r8, &
     &1.7469e+00_r8,8.7439e-01_r8,2.6451e-03_r8/)
      kao(:, 5,11, 8) = (/ &
     &9.2372e+00_r8,8.0825e+00_r8,6.9284e+00_r8,5.7745e+00_r8,4.6202e+00_r8,3.4655e+00_r8, &
     &2.3113e+00_r8,1.1571e+00_r8,3.2091e-03_r8/)
      kao(:, 1,12, 8) = (/ &
     &2.6551e+00_r8,2.3231e+00_r8,1.9913e+00_r8,1.6595e+00_r8,1.3276e+00_r8,9.9570e-01_r8, &
     &6.6396e-01_r8,3.3215e-01_r8,5.7595e-04_r8/)
      kao(:, 2,12, 8) = (/ &
     &3.9875e+00_r8,3.4892e+00_r8,2.9906e+00_r8,2.4922e+00_r8,1.9940e+00_r8,1.4956e+00_r8, &
     &9.9727e-01_r8,4.9897e-01_r8,7.2773e-04_r8/)
      kao(:, 3,12, 8) = (/ &
     &5.6951e+00_r8,4.9832e+00_r8,4.2714e+00_r8,3.5598e+00_r8,2.8480e+00_r8,2.1362e+00_r8, &
     &1.4245e+00_r8,7.1282e-01_r8,1.1732e-03_r8/)
      kao(:, 4,12, 8) = (/ &
     &7.8078e+00_r8,6.8322e+00_r8,5.8562e+00_r8,4.8804e+00_r8,3.9048e+00_r8,2.9289e+00_r8, &
     &1.9532e+00_r8,9.7758e-01_r8,2.5629e-03_r8/)
      kao(:, 5,12, 8) = (/ &
     &1.0362e+01_r8,9.0671e+00_r8,7.7724e+00_r8,6.4775e+00_r8,5.1823e+00_r8,3.8873e+00_r8, &
     &2.5926e+00_r8,1.2977e+00_r8,3.8105e-03_r8/)
      kao(:, 1,13, 8) = (/ &
     &2.3258e+00_r8,2.0350e+00_r8,1.7444e+00_r8,1.4537e+00_r8,1.1630e+00_r8,8.7226e-01_r8, &
     &5.8161e-01_r8,2.9098e-01_r8,5.9908e-04_r8/)
      kao(:, 2,13, 8) = (/ &
     &3.5360e+00_r8,3.0938e+00_r8,2.6520e+00_r8,2.2101e+00_r8,1.7681e+00_r8,1.3262e+00_r8, &
     &8.8435e-01_r8,4.4250e-01_r8,8.1555e-04_r8/)
      kao(:, 3,13, 8) = (/ &
     &5.0896e+00_r8,4.4536e+00_r8,3.8175e+00_r8,3.1814e+00_r8,2.5452e+00_r8,1.9091e+00_r8, &
     &1.2732e+00_r8,6.3712e-01_r8,1.2640e-03_r8/)
      kao(:, 4,13, 8) = (/ &
     &7.0210e+00_r8,6.1435e+00_r8,5.2660e+00_r8,4.3886e+00_r8,3.5112e+00_r8,2.6338e+00_r8, &
     &1.7565e+00_r8,8.7919e-01_r8,2.6701e-03_r8/)
      kao(:, 5,13, 8) = (/ &
     &9.3671e+00_r8,8.1963e+00_r8,7.0260e+00_r8,5.8554e+00_r8,4.6849e+00_r8,3.5142e+00_r8, &
     &2.3437e+00_r8,1.1734e+00_r8,3.9606e-03_r8/)
      kao(:, 1, 1, 9) = (/ &
     &1.7557e-02_r8,1.6098e-02_r8,1.5252e-02_r8,1.4591e-02_r8,1.4194e-02_r8,1.3841e-02_r8, &
     &1.3213e-02_r8,1.1760e-02_r8,1.0941e-02_r8/)
      kao(:, 2, 1, 9) = (/ &
     &2.1322e-02_r8,1.9727e-02_r8,1.8932e-02_r8,1.8315e-02_r8,1.8048e-02_r8,1.7757e-02_r8, &
     &1.7105e-02_r8,1.5377e-02_r8,1.4897e-02_r8/)
      kao(:, 3, 1, 9) = (/ &
     &2.5364e-02_r8,2.3730e-02_r8,2.3058e-02_r8,2.2569e-02_r8,2.2483e-02_r8,2.2337e-02_r8, &
     &2.1647e-02_r8,1.9659e-02_r8,1.9740e-02_r8/)
      kao(:, 4, 1, 9) = (/ &
     &2.9651e-02_r8,2.8091e-02_r8,2.7567e-02_r8,2.7373e-02_r8,2.7544e-02_r8,2.7572e-02_r8, &
     &2.6885e-02_r8,2.4698e-02_r8,2.5506e-02_r8/)
      kao(:, 5, 1, 9) = (/ &
     &3.4147e-02_r8,3.2801e-02_r8,3.2509e-02_r8,3.2696e-02_r8,3.3242e-02_r8,3.3466e-02_r8, &
     &3.2763e-02_r8,3.0530e-02_r8,3.2414e-02_r8/)
      kao(:, 1, 2, 9) = (/ &
     &2.4912e-02_r8,2.2331e-02_r8,2.0288e-02_r8,1.8446e-02_r8,1.6840e-02_r8,1.5437e-02_r8, &
     &1.4050e-02_r8,1.2105e-02_r8,9.2979e-03_r8/)
      kao(:, 2, 2, 9) = (/ &
     &3.0564e-02_r8,2.7515e-02_r8,2.5261e-02_r8,2.3219e-02_r8,2.1400e-02_r8,1.9828e-02_r8, &
     &1.8282e-02_r8,1.5938e-02_r8,1.2847e-02_r8/)
      kao(:, 3, 2, 9) = (/ &
     &3.6716e-02_r8,3.3250e-02_r8,3.0813e-02_r8,2.8576e-02_r8,2.6652e-02_r8,2.4969e-02_r8, &
     &2.3242e-02_r8,2.0434e-02_r8,1.7255e-02_r8/)
      kao(:, 4, 2, 9) = (/ &
     &4.3274e-02_r8,3.9470e-02_r8,3.6945e-02_r8,3.4546e-02_r8,3.2567e-02_r8,3.0902e-02_r8, &
     &2.8990e-02_r8,2.5608e-02_r8,2.2622e-02_r8/)
      kao(:, 5, 2, 9) = (/ &
     &5.0151e-02_r8,4.6154e-02_r8,4.3548e-02_r8,4.1147e-02_r8,3.9208e-02_r8,3.7617e-02_r8, &
     &3.5476e-02_r8,3.1506e-02_r8,2.9070e-02_r8/)
      kao(:, 1, 3, 9) = (/ &
     &4.5824e-02_r8,4.0428e-02_r8,3.5360e-02_r8,3.0531e-02_r8,2.5873e-02_r8,2.1515e-02_r8, &
     &1.7437e-02_r8,1.3182e-02_r8,7.2135e-03_r8/)
      kao(:, 2, 3, 9) = (/ &
     &5.7122e-02_r8,5.0441e-02_r8,4.4296e-02_r8,3.8535e-02_r8,3.2887e-02_r8,2.7626e-02_r8, &
     &2.2637e-02_r8,1.7470e-02_r8,1.0156e-02_r8/)
      kao(:, 3, 3, 9) = (/ &
     &6.9514e-02_r8,6.1484e-02_r8,5.4267e-02_r8,4.7520e-02_r8,4.0893e-02_r8,3.4647e-02_r8, &
     &2.8731e-02_r8,2.2576e-02_r8,1.3878e-02_r8/)
      kao(:, 4, 3, 9) = (/ &
     &8.2919e-02_r8,7.3512e-02_r8,6.5273e-02_r8,5.7524e-02_r8,4.9783e-02_r8,4.2603e-02_r8, &
     &3.5784e-02_r8,2.8563e-02_r8,1.8502e-02_r8/)
      kao(:, 5, 3, 9) = (/ &
     &9.7170e-02_r8,8.6431e-02_r8,7.7261e-02_r8,6.8346e-02_r8,5.9584e-02_r8,5.1514e-02_r8, &
     &4.3768e-02_r8,3.5379e-02_r8,2.4141e-02_r8/)
      kao(:, 1, 4, 9) = (/ &
     &8.5028e-02_r8,7.4675e-02_r8,6.4408e-02_r8,5.4349e-02_r8,4.4385e-02_r8,3.4667e-02_r8, &
     &2.5298e-02_r8,1.6347e-02_r8,5.3723e-03_r8/)
      kao(:, 2, 4, 9) = (/ &
     &1.0799e-01_r8,9.4832e-02_r8,8.1887e-02_r8,6.9265e-02_r8,5.6849e-02_r8,4.4649e-02_r8, &
     &3.2963e-02_r8,2.1613e-02_r8,7.7235e-03_r8/)
      kao(:, 3, 4, 9) = (/ &
     &1.3350e-01_r8,1.1723e-01_r8,1.0141e-01_r8,8.6053e-02_r8,7.1006e-02_r8,5.6113e-02_r8, &
     &4.1792e-02_r8,2.7868e-02_r8,1.0747e-02_r8/)
      kao(:, 4, 4, 9) = (/ &
     &1.6142e-01_r8,1.4180e-01_r8,1.2297e-01_r8,1.0476e-01_r8,8.6810e-02_r8,6.8956e-02_r8, &
     &5.1841e-02_r8,3.5143e-02_r8,1.4564e-02_r8/)
      kao(:, 5, 4, 9) = (/ &
     &1.9126e-01_r8,1.6822e-01_r8,1.4629e-01_r8,1.2515e-01_r8,1.0422e-01_r8,8.3176e-02_r8, &
     &6.3089e-02_r8,4.3500e-02_r8,1.9267e-02_r8/)
      kao(:, 1, 5, 9) = (/ &
     &1.4488e-01_r8,1.2702e-01_r8,1.0917e-01_r8,9.1352e-02_r8,7.3672e-02_r8,5.6082e-02_r8, &
     &3.8867e-02_r8,2.2212e-02_r8,3.9357e-03_r8/)
      kao(:, 2, 5, 9) = (/ &
     &1.8767e-01_r8,1.6453e-01_r8,1.4140e-01_r8,1.1846e-01_r8,9.5672e-02_r8,7.3107e-02_r8, &
     &5.0961e-02_r8,2.9559e-02_r8,5.7686e-03_r8/)
      kao(:, 3, 5, 9) = (/ &
     &2.3604e-01_r8,2.0693e-01_r8,1.7791e-01_r8,1.4922e-01_r8,1.2079e-01_r8,9.2713e-02_r8, &
     &6.4987e-02_r8,3.8154e-02_r8,8.1725e-03_r8/)
      kao(:, 4, 5, 9) = (/ &
     &2.8921e-01_r8,2.5355e-01_r8,2.1818e-01_r8,1.8330e-01_r8,1.4882e-01_r8,1.1469e-01_r8, &
     &8.0893e-02_r8,4.8061e-02_r8,1.1257e-02_r8/)
      kao(:, 5, 5, 9) = (/ &
     &3.4679e-01_r8,3.0409e-01_r8,2.6204e-01_r8,2.2057e-01_r8,1.7963e-01_r8,1.3899e-01_r8, &
     &9.8558e-02_r8,5.9364e-02_r8,1.5113e-02_r8/)
      kao(:, 1, 6, 9) = (/ &
     &2.2687e-01_r8,1.9870e-01_r8,1.7053e-01_r8,1.4235e-01_r8,1.1424e-01_r8,8.6261e-02_r8, &
     &5.8407e-02_r8,3.1198e-02_r8,2.7719e-03_r8/)
      kao(:, 2, 6, 9) = (/ &
     &3.0049e-01_r8,2.6318e-01_r8,2.2586e-01_r8,1.8856e-01_r8,1.5147e-01_r8,1.1450e-01_r8, &
     &7.7818e-02_r8,4.1952e-02_r8,4.1659e-03_r8/)
      kao(:, 3, 6, 9) = (/ &
     &3.8494e-01_r8,3.3714e-01_r8,2.8934e-01_r8,2.4170e-01_r8,1.9431e-01_r8,1.4714e-01_r8, &
     &1.0048e-01_r8,5.4667e-02_r8,6.0249e-03_r8/)
      kao(:, 4, 6, 9) = (/ &
     &4.7888e-01_r8,4.1941e-01_r8,3.6000e-01_r8,3.0097e-01_r8,2.4222e-01_r8,1.8390e-01_r8, &
     &1.2612e-01_r8,6.9245e-02_r8,8.4412e-03_r8/)
      kao(:, 5, 6, 9) = (/ &
     &5.8181e-01_r8,5.0960e-01_r8,4.3765e-01_r8,3.6614e-01_r8,2.9513e-01_r8,2.2467e-01_r8, &
     &1.5478e-01_r8,8.5677e-02_r8,1.1500e-02_r8/)
      kao(:, 1, 7, 9) = (/ &
     &3.6399e-01_r8,3.1864e-01_r8,2.7330e-01_r8,2.2796e-01_r8,1.8261e-01_r8,1.3731e-01_r8, &
     &9.2161e-02_r8,4.7386e-02_r8,1.8335e-03_r8/)
      kao(:, 2, 7, 9) = (/ &
     &4.9404e-01_r8,4.3249e-01_r8,3.7094e-01_r8,3.0937e-01_r8,2.4784e-01_r8,1.8651e-01_r8, &
     &1.2531e-01_r8,6.4814e-02_r8,2.9040e-03_r8/)
      kao(:, 3, 7, 9) = (/ &
     &6.4560e-01_r8,5.6518e-01_r8,4.8472e-01_r8,4.0430e-01_r8,3.2403e-01_r8,2.4402e-01_r8, &
     &1.6421e-01_r8,8.5452e-02_r8,4.3365e-03_r8/)
      kao(:, 4, 7, 9) = (/ &
     &8.1690e-01_r8,7.1513e-01_r8,6.1336e-01_r8,5.1171e-01_r8,4.1038e-01_r8,3.0928e-01_r8, &
     &2.0863e-01_r8,1.0932e-01_r8,6.1934e-03_r8/)
      kao(:, 5, 7, 9) = (/ &
     &1.0068e+00_r8,8.8147e-01_r8,7.5616e-01_r8,6.3106e-01_r8,5.0635e-01_r8,3.8205e-01_r8, &
     &2.5843e-01_r8,1.3634e-01_r8,8.5588e-03_r8/)
      kao(:, 1, 8, 9) = (/ &
     &6.8384e-01_r8,5.9848e-01_r8,5.1310e-01_r8,4.2775e-01_r8,3.4242e-01_r8,2.5705e-01_r8, &
     &1.7171e-01_r8,8.6607e-02_r8,8.9761e-04_r8/)
      kao(:, 2, 8, 9) = (/ &
     &9.5272e-01_r8,8.3382e-01_r8,7.1490e-01_r8,5.9597e-01_r8,4.7702e-01_r8,3.5811e-01_r8, &
     &2.3935e-01_r8,1.2088e-01_r8,1.5768e-03_r8/)
      kao(:, 3, 8, 9) = (/ &
     &1.2716e+00_r8,1.1128e+00_r8,9.5409e-01_r8,7.9538e-01_r8,6.3666e-01_r8,4.7804e-01_r8, &
     &3.1975e-01_r8,1.6179e-01_r8,2.6889e-03_r8/)
      kao(:, 4, 8, 9) = (/ &
     &1.6381e+00_r8,1.4337e+00_r8,1.2291e+00_r8,1.0247e+00_r8,8.2031e-01_r8,6.1622e-01_r8, &
     &4.1239e-01_r8,2.0929e-01_r8,4.1353e-03_r8/)
      kao(:, 5, 8, 9) = (/ &
     &2.0497e+00_r8,1.7940e+00_r8,1.5381e+00_r8,1.2824e+00_r8,1.0268e+00_r8,7.7156e-01_r8, &
     &5.1676e-01_r8,2.6319e-01_r8,6.0327e-03_r8/)
      kao(:, 1, 9, 9) = (/ &
     &2.3562e+00_r8,2.0618e+00_r8,1.7675e+00_r8,1.4730e+00_r8,1.1786e+00_r8,8.8409e-01_r8, &
     &5.8968e-01_r8,2.9523e-01_r8,7.8820e-04_r8/)
      kao(:, 2, 9, 9) = (/ &
     &3.3780e+00_r8,2.9558e+00_r8,2.5337e+00_r8,2.1117e+00_r8,1.6896e+00_r8,1.2675e+00_r8, &
     &8.4537e-01_r8,4.2322e-01_r8,1.1025e-03_r8/)
      kao(:, 3, 9, 9) = (/ &
     &4.6138e+00_r8,4.0373e+00_r8,3.4607e+00_r8,2.8840e+00_r8,2.3076e+00_r8,1.7311e+00_r8, &
     &1.1546e+00_r8,5.7817e-01_r8,1.6643e-03_r8/)
      kao(:, 4, 9, 9) = (/ &
     &6.0608e+00_r8,5.3032e+00_r8,4.5462e+00_r8,3.7886e+00_r8,3.0313e+00_r8,2.2740e+00_r8, &
     &1.5168e+00_r8,7.6000e-01_r8,2.3974e-03_r8/)
      kao(:, 5, 9, 9) = (/ &
     &7.7085e+00_r8,6.7454e+00_r8,5.7823e+00_r8,4.8189e+00_r8,3.8558e+00_r8,2.8925e+00_r8, &
     &1.9295e+00_r8,9.6718e-01_r8,3.2535e-03_r8/)
      kao(:, 1,10, 9) = (/ &
     &9.1055e+00_r8,7.9675e+00_r8,6.8292e+00_r8,5.6913e+00_r8,4.5531e+00_r8,3.4149e+00_r8, &
     &2.2769e+00_r8,1.1388e+00_r8,5.8809e-04_r8/)
      kao(:, 2,10, 9) = (/ &
     &1.3404e+01_r8,1.1729e+01_r8,1.0053e+01_r8,8.3780e+00_r8,6.7024e+00_r8,5.0271e+00_r8, &
     &3.3517e+00_r8,1.6763e+00_r8,9.0563e-04_r8/)
      kao(:, 3,10, 9) = (/ &
     &1.8696e+01_r8,1.6359e+01_r8,1.4022e+01_r8,1.1685e+01_r8,9.3484e+00_r8,7.0117e+00_r8, &
     &4.6747e+00_r8,2.3381e+00_r8,1.7881e-03_r8/)
      kao(:, 4,10, 9) = (/ &
     &2.4995e+01_r8,2.1869e+01_r8,1.8747e+01_r8,1.5622e+01_r8,1.2498e+01_r8,9.3741e+00_r8, &
     &6.2500e+00_r8,3.1259e+00_r8,3.1813e-03_r8/)
      kao(:, 5,10, 9) = (/ &
     &3.2273e+01_r8,2.8239e+01_r8,2.4206e+01_r8,2.0172e+01_r8,1.6138e+01_r8,1.2104e+01_r8, &
     &8.0701e+00_r8,4.0364e+00_r8,3.7345e-03_r8/)
      kao(:, 1,11, 9) = (/ &
     &1.4610e+01_r8,1.2784e+01_r8,1.0958e+01_r8,9.1318e+00_r8,7.3053e+00_r8,5.4792e+00_r8, &
     &3.6529e+00_r8,1.8269e+00_r8,9.3673e-05_r8/)
      kao(:, 2,11, 9) = (/ &
     &2.1482e+01_r8,1.8797e+01_r8,1.6112e+01_r8,1.3427e+01_r8,1.0742e+01_r8,8.0564e+00_r8, &
     &5.3711e+00_r8,2.6860e+00_r8,1.0848e-03_r8/)
      kao(:, 3,11, 9) = (/ &
     &2.9982e+01_r8,2.6234e+01_r8,2.2487e+01_r8,1.8739e+01_r8,1.4992e+01_r8,1.1244e+01_r8, &
     &7.4965e+00_r8,3.7489e+00_r8,1.4593e-03_r8/)
      kao(:, 4,11, 9) = (/ &
     &4.0102e+01_r8,3.5090e+01_r8,3.0079e+01_r8,2.5065e+01_r8,2.0053e+01_r8,1.5039e+01_r8, &
     &1.0027e+01_r8,5.0144e+00_r8,2.0582e-03_r8/)
      kao(:, 5,11, 9) = (/ &
     &5.1873e+01_r8,4.5387e+01_r8,3.8905e+01_r8,3.2421e+01_r8,2.5937e+01_r8,1.9453e+01_r8, &
     &1.2970e+01_r8,6.4862e+00_r8,4.4703e-03_r8/)
      kao(:, 1,12, 9) = (/ &
     &1.7189e+01_r8,1.5041e+01_r8,1.2892e+01_r8,1.0744e+01_r8,8.5949e+00_r8,6.4462e+00_r8, &
     &4.2976e+00_r8,2.1491e+00_r8,3.9266e-05_r8/)
      kao(:, 2,12, 9) = (/ &
     &2.5282e+01_r8,2.2121e+01_r8,1.8962e+01_r8,1.5801e+01_r8,1.2641e+01_r8,9.4811e+00_r8, &
     &6.3210e+00_r8,3.1609e+00_r8,6.4444e-04_r8/)
      kao(:, 3,12, 9) = (/ &
     &3.5289e+01_r8,3.0879e+01_r8,2.6468e+01_r8,2.2056e+01_r8,1.7646e+01_r8,1.3235e+01_r8, &
     &8.8231e+00_r8,4.4124e+00_r8,1.8228e-03_r8/)
      kao(:, 4,12, 9) = (/ &
     &4.7291e+01_r8,4.1381e+01_r8,3.5468e+01_r8,2.9558e+01_r8,2.3647e+01_r8,1.7735e+01_r8, &
     &1.1825e+01_r8,5.9130e+00_r8,2.3757e-03_r8/)
      kao(:, 5,12, 9) = (/ &
     &6.1297e+01_r8,5.3636e+01_r8,4.5972e+01_r8,3.8311e+01_r8,3.0649e+01_r8,2.2988e+01_r8, &
     &1.5326e+01_r8,7.6642e+00_r8,3.9341e-03_r8/)
      kao(:, 1,13, 9) = (/ &
     &1.6000e+01_r8,1.4000e+01_r8,1.2000e+01_r8,9.9998e+00_r8,8.0002e+00_r8,6.0002e+00_r8, &
     &4.0003e+00_r8,2.0005e+00_r8,3.8486e-05_r8/)
      kao(:, 2,13, 9) = (/ &
     &2.3551e+01_r8,2.0607e+01_r8,1.7663e+01_r8,1.4719e+01_r8,1.1776e+01_r8,8.8325e+00_r8, &
     &5.8883e+00_r8,2.9447e+00_r8,5.3945e-04_r8/)
      kao(:, 3,13, 9) = (/ &
     &3.2950e+01_r8,2.8830e+01_r8,2.4711e+01_r8,2.0594e+01_r8,1.6475e+01_r8,1.2356e+01_r8, &
     &8.2382e+00_r8,4.1197e+00_r8,1.7722e-03_r8/)
      kao(:, 4,13, 9) = (/ &
     &4.4263e+01_r8,3.8730e+01_r8,3.3198e+01_r8,2.7666e+01_r8,2.2132e+01_r8,1.6600e+01_r8, &
     &1.1067e+01_r8,5.5345e+00_r8,2.5081e-03_r8/)
      kao(:, 5,13, 9) = (/ &
     &5.7461e+01_r8,5.0277e+01_r8,4.3096e+01_r8,3.5913e+01_r8,2.8731e+01_r8,2.1549e+01_r8, &
     &1.4366e+01_r8,7.1843e+00_r8,4.3602e-03_r8/)
      kao(:, 1, 1,10) = (/ &
     &4.8312e-02_r8,4.2395e-02_r8,3.7029e-02_r8,3.4268e-02_r8,3.1631e-02_r8,2.8012e-02_r8, &
     &2.4227e-02_r8,1.9340e-02_r8,2.3819e-02_r8/)
      kao(:, 2, 1,10) = (/ &
     &5.7978e-02_r8,5.0880e-02_r8,4.5259e-02_r8,4.2684e-02_r8,3.9233e-02_r8,3.5182e-02_r8, &
     &3.0643e-02_r8,2.5810e-02_r8,3.1295e-02_r8/)
      kao(:, 3, 1,10) = (/ &
     &6.8091e-02_r8,5.9773e-02_r8,5.4735e-02_r8,5.1517e-02_r8,4.7810e-02_r8,4.2960e-02_r8, &
     &3.8310e-02_r8,3.3678e-02_r8,4.0832e-02_r8/)
      kao(:, 4, 1,10) = (/ &
     &7.8444e-02_r8,6.8870e-02_r8,6.5474e-02_r8,6.0764e-02_r8,5.6861e-02_r8,5.2020e-02_r8, &
     &4.6525e-02_r8,4.3019e-02_r8,5.3025e-02_r8/)
      kao(:, 5, 1,10) = (/ &
     &8.8955e-02_r8,7.8190e-02_r8,7.6227e-02_r8,7.0877e-02_r8,6.6771e-02_r8,6.2214e-02_r8, &
     &5.5680e-02_r8,5.4857e-02_r8,6.6965e-02_r8/)
      kao(:, 1, 2,10) = (/ &
     &6.8494e-02_r8,6.0019e-02_r8,5.1535e-02_r8,4.5753e-02_r8,4.0717e-02_r8,3.4636e-02_r8, &
     &2.8735e-02_r8,2.2359e-02_r8,2.2396e-02_r8/)
      kao(:, 2, 2,10) = (/ &
     &8.3057e-02_r8,7.2786e-02_r8,6.2703e-02_r8,5.6353e-02_r8,5.0990e-02_r8,4.3733e-02_r8, &
     &3.6309e-02_r8,2.8660e-02_r8,2.9863e-02_r8/)
      kao(:, 3, 2,10) = (/ &
     &9.8445e-02_r8,8.6268e-02_r8,7.5172e-02_r8,6.9101e-02_r8,6.1861e-02_r8,5.3608e-02_r8, &
     &4.5462e-02_r8,3.5628e-02_r8,3.9584e-02_r8/)
      kao(:, 4, 2,10) = (/ &
     &1.1465e-01_r8,1.0047e-01_r8,8.9322e-02_r8,8.2399e-02_r8,7.3847e-02_r8,6.4459e-02_r8, &
     &5.5729e-02_r8,4.5259e-02_r8,5.1011e-02_r8/)
      kao(:, 5, 2,10) = (/ &
     &1.3121e-01_r8,1.1499e-01_r8,1.0547e-01_r8,9.5942e-02_r8,8.6700e-02_r8,7.6912e-02_r8, &
     &6.7683e-02_r8,5.7087e-02_r8,6.4331e-02_r8/)
      kao(:, 1, 3,10) = (/ &
     &1.2396e-01_r8,1.0851e-01_r8,9.3078e-02_r8,7.7936e-02_r8,6.5430e-02_r8,5.3555e-02_r8, &
     &4.0149e-02_r8,2.8165e-02_r8,1.9103e-02_r8/)
      kao(:, 2, 3,10) = (/ &
     &1.5308e-01_r8,1.3401e-01_r8,1.1495e-01_r8,9.6317e-02_r8,8.2061e-02_r8,6.7720e-02_r8, &
     &5.1563e-02_r8,3.6346e-02_r8,2.6147e-02_r8/)
      kao(:, 3, 3,10) = (/ &
     &1.8438e-01_r8,1.6143e-01_r8,1.3846e-01_r8,1.1685e-01_r8,1.0065e-01_r8,8.3573e-02_r8, &
     &6.4169e-02_r8,4.6273e-02_r8,3.5249e-02_r8/)
      kao(:, 4, 3,10) = (/ &
     &2.1730e-01_r8,1.9024e-01_r8,1.6317e-01_r8,1.3937e-01_r8,1.2182e-01_r8,1.0076e-01_r8, &
     &7.7802e-02_r8,5.7458e-02_r8,4.6106e-02_r8/)
      kao(:, 5, 3,10) = (/ &
     &2.5114e-01_r8,2.1989e-01_r8,1.8862e-01_r8,1.6558e-01_r8,1.4330e-01_r8,1.1936e-01_r8, &
     &9.3594e-02_r8,7.0438e-02_r8,5.9048e-02_r8/)
      kao(:, 1, 4,10) = (/ &
     &2.2307e-01_r8,1.9520e-01_r8,1.6737e-01_r8,1.3960e-01_r8,1.1281e-01_r8,8.7662e-02_r8, &
     &6.3355e-02_r8,3.7440e-02_r8,1.5143e-02_r8/)
      kao(:, 2, 4,10) = (/ &
     &2.8121e-01_r8,2.4610e-01_r8,2.1101e-01_r8,1.7601e-01_r8,1.4219e-01_r8,1.1180e-01_r8, &
     &8.0961e-02_r8,4.9348e-02_r8,2.1248e-02_r8/)
      kao(:, 3, 4,10) = (/ &
     &3.4426e-01_r8,3.0128e-01_r8,2.5831e-01_r8,2.1545e-01_r8,1.7407e-01_r8,1.3850e-01_r8, &
     &1.0170e-01_r8,6.2450e-02_r8,2.9486e-02_r8/)
      kao(:, 4, 4,10) = (/ &
     &4.1162e-01_r8,3.6021e-01_r8,3.0885e-01_r8,2.5755e-01_r8,2.0938e-01_r8,1.6873e-01_r8, &
     &1.2428e-01_r8,7.7637e-02_r8,3.9623e-02_r8/)
      kao(:, 5, 4,10) = (/ &
     &4.8400e-01_r8,4.2357e-01_r8,3.6318e-01_r8,3.0275e-01_r8,2.4837e-01_r8,2.0175e-01_r8, &
     &1.4904e-01_r8,9.5123e-02_r8,5.2032e-02_r8/)
      kao(:, 1, 5,10) = (/ &
     &3.6240e-01_r8,3.1713e-01_r8,2.7189e-01_r8,2.2715e-01_r8,1.8287e-01_r8,1.3915e-01_r8, &
     &9.6038e-02_r8,5.3151e-02_r8,1.1469e-02_r8/)
      kao(:, 2, 5,10) = (/ &
     &4.6684e-01_r8,4.0853e-01_r8,3.5029e-01_r8,2.9260e-01_r8,2.3543e-01_r8,1.7892e-01_r8, &
     &1.2501e-01_r8,6.9710e-02_r8,1.6590e-02_r8/)
      kao(:, 3, 5,10) = (/ &
     &5.8305e-01_r8,5.1017e-01_r8,4.3746e-01_r8,3.6540e-01_r8,2.9385e-01_r8,2.2314e-01_r8, &
     &1.5770e-01_r8,8.9552e-02_r8,2.3682e-02_r8/)
      kao(:, 4, 5,10) = (/ &
     &7.1039e-01_r8,6.2164e-01_r8,5.3285e-01_r8,4.4486e-01_r8,3.5759e-01_r8,2.7242e-01_r8, &
     &1.9452e-01_r8,1.1176e-01_r8,3.2616e-02_r8/)
      kao(:, 5, 5,10) = (/ &
     &8.4585e-01_r8,7.4016e-01_r8,6.3454e-01_r8,5.2965e-01_r8,4.2558e-01_r8,3.2651e-01_r8, &
     &2.3601e-01_r8,1.3577e-01_r8,4.3721e-02_r8/)
      kao(:, 1, 6,10) = (/ &
     &5.4565e-01_r8,4.7774e-01_r8,4.0998e-01_r8,3.4242e-01_r8,2.7503e-01_r8,2.0802e-01_r8, &
     &1.4092e-01_r8,7.4294e-02_r8,8.5994e-03_r8/)
      kao(:, 2, 6,10) = (/ &
     &7.2281e-01_r8,6.3285e-01_r8,5.4312e-01_r8,4.5353e-01_r8,3.6423e-01_r8,2.7526e-01_r8, &
     &1.8607e-01_r8,9.8990e-02_r8,1.2620e-02_r8/)
      kao(:, 3, 6,10) = (/ &
     &9.2293e-01_r8,8.0812e-01_r8,6.9347e-01_r8,5.7897e-01_r8,4.6479e-01_r8,3.5103e-01_r8, &
     &2.3728e-01_r8,1.2747e-01_r8,1.8407e-02_r8/)
      kao(:, 4, 6,10) = (/ &
     &1.1448e+00_r8,1.0023e+00_r8,8.6003e-01_r8,7.1795e-01_r8,5.7619e-01_r8,4.3493e-01_r8, &
     &2.9519e-01_r8,1.6083e-01_r8,2.5918e-02_r8/)
      kao(:, 5, 6,10) = (/ &
     &1.3870e+00_r8,1.2144e+00_r8,1.0419e+00_r8,8.6977e-01_r8,6.9789e-01_r8,5.2651e-01_r8, &
     &3.5987e-01_r8,1.9795e-01_r8,3.5516e-02_r8/)
      kao(:, 1, 7,10) = (/ &
     &9.0563e-01_r8,7.9294e-01_r8,6.8033e-01_r8,5.6775e-01_r8,4.5526e-01_r8,3.4288e-01_r8, &
     &2.2993e-01_r8,1.1636e-01_r8,6.3281e-03_r8/)
      kao(:, 2, 7,10) = (/ &
     &1.2304e+00_r8,1.0774e+00_r8,9.2435e-01_r8,7.7129e-01_r8,6.1846e-01_r8,4.6574e-01_r8, &
     &3.1230e-01_r8,1.5802e-01_r8,9.6345e-03_r8/)
      kao(:, 3, 7,10) = (/ &
     &1.6067e+00_r8,1.4068e+00_r8,1.2068e+00_r8,1.0069e+00_r8,8.0717e-01_r8,6.0759e-01_r8, &
     &4.0707e-01_r8,2.0698e-01_r8,1.4230e-02_r8/)
      kao(:, 4, 7,10) = (/ &
     &2.0379e+00_r8,1.7842e+00_r8,1.5305e+00_r8,1.2770e+00_r8,1.0235e+00_r8,7.6992e-01_r8, &
     &5.1539e-01_r8,2.6359e-01_r8,2.0362e-02_r8/)
      kao(:, 5, 7,10) = (/ &
     &2.5042e+00_r8,2.1925e+00_r8,1.8806e+00_r8,1.5690e+00_r8,1.2574e+00_r8,9.4558e-01_r8, &
     &6.3281e-01_r8,3.2569e-01_r8,2.8537e-02_r8/)
      kao(:, 1, 8,10) = (/ &
     &1.8551e+00_r8,1.6239e+00_r8,1.3926e+00_r8,1.1613e+00_r8,9.2995e-01_r8,6.9848e-01_r8, &
     &4.6667e-01_r8,2.3461e-01_r8,3.7282e-03_r8/)
      kao(:, 2, 8,10) = (/ &
     &2.5887e+00_r8,2.2659e+00_r8,1.9430e+00_r8,1.6201e+00_r8,1.2969e+00_r8,9.7383e-01_r8, &
     &6.5051e-01_r8,3.2684e-01_r8,7.1685e-03_r8/)
      kao(:, 3, 8,10) = (/ &
     &3.4601e+00_r8,3.0282e+00_r8,2.5964e+00_r8,2.1645e+00_r8,1.7327e+00_r8,1.3007e+00_r8, &
     &8.6869e-01_r8,4.3618e-01_r8,1.0869e-02_r8/)
      kao(:, 4, 8,10) = (/ &
     &4.4635e+00_r8,3.9062e+00_r8,3.3492e+00_r8,2.7923e+00_r8,2.2350e+00_r8,1.6778e+00_r8, &
     &1.1202e+00_r8,5.6241e-01_r8,1.5855e-02_r8/)
      kao(:, 5, 8,10) = (/ &
     &5.5614e+00_r8,4.8670e+00_r8,4.1730e+00_r8,3.4788e+00_r8,2.7845e+00_r8,2.0899e+00_r8, &
     &1.3954e+00_r8,7.0042e-01_r8,2.2369e-02_r8/)
      kao(:, 1, 9,10) = (/ &
     &7.0057e+00_r8,6.1306e+00_r8,5.2555e+00_r8,4.3802e+00_r8,3.5047e+00_r8,2.6291e+00_r8, &
     &1.7537e+00_r8,8.7821e-01_r8,2.6651e-03_r8/)
      kao(:, 2, 9,10) = (/ &
     &1.0071e+01_r8,8.8120e+00_r8,7.5539e+00_r8,6.2955e+00_r8,5.0368e+00_r8,3.7786e+00_r8, &
     &2.5204e+00_r8,1.2618e+00_r8,3.6187e-03_r8/)
      kao(:, 3, 9,10) = (/ &
     &1.3793e+01_r8,1.2069e+01_r8,1.0345e+01_r8,8.6215e+00_r8,6.8979e+00_r8,5.1747e+00_r8, &
     &3.4512e+00_r8,1.7274e+00_r8,5.0886e-03_r8/)
      kao(:, 4, 9,10) = (/ &
     &1.8095e+01_r8,1.5834e+01_r8,1.3574e+01_r8,1.1311e+01_r8,9.0505e+00_r8,6.7893e+00_r8, &
     &4.5277e+00_r8,2.2659e+00_r8,6.6445e-03_r8/)
      kao(:, 5, 9,10) = (/ &
     &2.2909e+01_r8,2.0046e+01_r8,1.7183e+01_r8,1.4320e+01_r8,1.1458e+01_r8,8.5941e+00_r8, &
     &5.7315e+00_r8,2.8684e+00_r8,1.0715e-02_r8/)
      kao(:, 1,10,10) = (/ &
     &2.9637e+01_r8,2.5932e+01_r8,2.2227e+01_r8,1.8524e+01_r8,1.4818e+01_r8,1.1115e+01_r8, &
     &7.4105e+00_r8,3.7062e+00_r8,1.7663e-03_r8/)
      kao(:, 2,10,10) = (/ &
     &4.3734e+01_r8,3.8266e+01_r8,3.2801e+01_r8,2.7334e+01_r8,2.1867e+01_r8,1.6402e+01_r8, &
     &1.0936e+01_r8,5.4691e+00_r8,2.0817e-03_r8/)
      kao(:, 3,10,10) = (/ &
     &6.1232e+01_r8,5.3576e+01_r8,4.5921e+01_r8,3.8272e+01_r8,3.0616e+01_r8,2.2963e+01_r8, &
     &1.5310e+01_r8,7.6576e+00_r8,1.7504e-03_r8/)
      kao(:, 4,10,10) = (/ &
     &8.1674e+01_r8,7.1459e+01_r8,6.1256e+01_r8,5.1048e+01_r8,4.0839e+01_r8,3.0631e+01_r8, &
     &2.0421e+01_r8,1.0211e+01_r8,7.5551e-03_r8/)
      kao(:, 5,10,10) = (/ &
     &1.0484e+02_r8,9.1726e+01_r8,7.8618e+01_r8,6.5522e+01_r8,5.2414e+01_r8,3.9315e+01_r8, &
     &2.6210e+01_r8,1.3108e+01_r8,1.2092e-02_r8/)
      kao(:, 1,11,10) = (/ &
     &5.2035e+01_r8,4.5533e+01_r8,3.9026e+01_r8,3.2522e+01_r8,2.6019e+01_r8,1.9514e+01_r8, &
     &1.3010e+01_r8,6.5060e+00_r8,2.3377e-05_r8/)
      kao(:, 2,11,10) = (/ &
     &7.6878e+01_r8,6.7270e+01_r8,5.7660e+01_r8,4.8051e+01_r8,3.8444e+01_r8,2.8832e+01_r8, &
     &1.9221e+01_r8,9.6129e+00_r8,3.4131e-05_r8/)
      kao(:, 3,11,10) = (/ &
     &1.0695e+02_r8,9.3584e+01_r8,8.0221e+01_r8,6.6851e+01_r8,5.3480e+01_r8,4.0109e+01_r8, &
     &2.6742e+01_r8,1.3372e+01_r8,6.5532e-03_r8/)
      kao(:, 4,11,10) = (/ &
     &1.4204e+02_r8,1.2428e+02_r8,1.0653e+02_r8,8.8779e+01_r8,7.1025e+01_r8,5.3267e+01_r8, &
     &3.5513e+01_r8,1.7760e+01_r8,3.6230e-03_r8/)
      kao(:, 5,11,10) = (/ &
     &1.8146e+02_r8,1.5877e+02_r8,1.3608e+02_r8,1.1341e+02_r8,9.0723e+01_r8,6.8041e+01_r8, &
     &4.5364e+01_r8,2.2685e+01_r8,5.3060e-03_r8/)
      kao(:, 1,12,10) = (/ &
     &6.6709e+01_r8,5.8372e+01_r8,5.0033e+01_r8,4.1695e+01_r8,3.3357e+01_r8,2.5018e+01_r8, &
     &1.6679e+01_r8,8.3409e+00_r8,1.6896e-05_r8/)
      kao(:, 2,12,10) = (/ &
     &9.8021e+01_r8,8.5767e+01_r8,7.3510e+01_r8,6.1263e+01_r8,4.9006e+01_r8,3.6758e+01_r8, &
     &2.4506e+01_r8,1.2254e+01_r8,2.4443e-05_r8/)
      kao(:, 3,12,10) = (/ &
     &1.3575e+02_r8,1.1880e+02_r8,1.0183e+02_r8,8.4855e+01_r8,6.7883e+01_r8,5.0907e+01_r8, &
     &3.3942e+01_r8,1.6972e+01_r8,3.9041e-05_r8/)
      kao(:, 4,12,10) = (/ &
     &1.7930e+02_r8,1.5689e+02_r8,1.3447e+02_r8,1.1206e+02_r8,8.9651e+01_r8,6.7236e+01_r8, &
     &4.4831e+01_r8,2.2414e+01_r8,2.5406e-03_r8/)
      kao(:, 5,12,10) = (/ &
     &2.2752e+02_r8,1.9909e+02_r8,1.7067e+02_r8,1.4220e+02_r8,1.1376e+02_r8,8.5325e+01_r8, &
     &5.6889e+01_r8,2.8448e+01_r8,5.4913e-03_r8/)
      kao(:, 1,13,10) = (/ &
     &6.7103e+01_r8,5.8720e+01_r8,5.0329e+01_r8,4.1943e+01_r8,3.3555e+01_r8,2.5165e+01_r8, &
     &1.6777e+01_r8,8.3902e+00_r8,1.5511e-05_r8/)
      kao(:, 2,13,10) = (/ &
     &9.7787e+01_r8,8.5564e+01_r8,7.3344e+01_r8,6.1125e+01_r8,4.8896e+01_r8,3.6672e+01_r8, &
     &2.4451e+01_r8,1.2226e+01_r8,2.1977e-05_r8/)
      kao(:, 3,13,10) = (/ &
     &1.3463e+02_r8,1.1780e+02_r8,1.0097e+02_r8,8.4145e+01_r8,6.7313e+01_r8,5.0486e+01_r8, &
     &3.3658e+01_r8,1.6832e+01_r8,3.2342e-05_r8/)
      kao(:, 4,13,10) = (/ &
     &1.7688e+02_r8,1.5477e+02_r8,1.3267e+02_r8,1.1056e+02_r8,8.8438e+01_r8,6.6334e+01_r8, &
     &4.4220e+01_r8,2.2113e+01_r8,5.6189e-03_r8/)
      kao(:, 5,13,10) = (/ &
     &2.2476e+02_r8,1.9667e+02_r8,1.6857e+02_r8,1.4047e+02_r8,1.1238e+02_r8,8.4289e+01_r8, &
     &5.6195e+01_r8,2.8100e+01_r8,6.0459e-03_r8/)
      kao(:, 1, 1,11) = (/ &
     &6.9001e-02_r8,6.0529e-02_r8,5.2064e-02_r8,4.5590e-02_r8,4.0628e-02_r8,3.5945e-02_r8, &
     &2.9389e-02_r8,2.3144e-02_r8,2.9176e-02_r8/)
      kao(:, 2, 1,11) = (/ &
     &8.2103e-02_r8,7.2020e-02_r8,6.1937e-02_r8,5.5694e-02_r8,5.0508e-02_r8,4.4515e-02_r8, &
     &3.6553e-02_r8,3.0757e-02_r8,3.9695e-02_r8/)
      kao(:, 3, 1,11) = (/ &
     &9.5630e-02_r8,8.3878e-02_r8,7.2481e-02_r8,6.7965e-02_r8,6.0680e-02_r8,5.4180e-02_r8, &
     &4.4143e-02_r8,4.0422e-02_r8,5.1968e-02_r8/)
      kao(:, 4, 1,11) = (/ &
     &1.0928e-01_r8,9.5880e-02_r8,8.4382e-02_r8,8.0469e-02_r8,7.1798e-02_r8,6.4108e-02_r8, &
     &5.3608e-02_r8,5.2409e-02_r8,6.6870e-02_r8/)
      kao(:, 5, 1,11) = (/ &
     &1.2299e-01_r8,1.0790e-01_r8,9.8888e-02_r8,9.2808e-02_r8,8.4009e-02_r8,7.5069e-02_r8, &
     &6.6004e-02_r8,6.6900e-02_r8,8.4455e-02_r8/)
      kao(:, 1, 2,11) = (/ &
     &1.0031e-01_r8,8.7857e-02_r8,7.5407e-02_r8,6.3060e-02_r8,5.4499e-02_r8,4.6504e-02_r8, &
     &3.6770e-02_r8,2.6380e-02_r8,2.8413e-02_r8/)
      kao(:, 2, 2,11) = (/ &
     &1.2053e-01_r8,1.0559e-01_r8,9.0627e-02_r8,7.6829e-02_r8,6.7033e-02_r8,5.8104e-02_r8, &
     &4.6509e-02_r8,3.3638e-02_r8,3.8310e-02_r8/)
      kao(:, 3, 2,11) = (/ &
     &1.4155e-01_r8,1.2398e-01_r8,1.0644e-01_r8,9.2248e-02_r8,8.1983e-02_r8,7.0441e-02_r8, &
     &5.6590e-02_r8,4.3821e-02_r8,5.0130e-02_r8/)
      kao(:, 4, 2,11) = (/ &
     &1.6305e-01_r8,1.4282e-01_r8,1.2262e-01_r8,1.1049e-01_r8,9.7062e-02_r8,8.3848e-02_r8, &
     &6.7975e-02_r8,5.5529e-02_r8,6.5378e-02_r8/)
      kao(:, 5, 2,11) = (/ &
     &1.8507e-01_r8,1.6212e-01_r8,1.3962e-01_r8,1.2935e-01_r8,1.1281e-01_r8,9.7726e-02_r8, &
     &8.0117e-02_r8,6.9954e-02_r8,8.3371e-02_r8/)
      kao(:, 1, 3,11) = (/ &
     &1.8667e-01_r8,1.6338e-01_r8,1.4010e-01_r8,1.1682e-01_r8,9.3557e-02_r8,7.4325e-02_r8, &
     &5.5984e-02_r8,3.5878e-02_r8,2.5531e-02_r8/)
      kao(:, 2, 3,11) = (/ &
     &2.2795e-01_r8,1.9954e-01_r8,1.7113e-01_r8,1.4270e-01_r8,1.1480e-01_r8,9.2509e-02_r8, &
     &7.0623e-02_r8,4.6178e-02_r8,3.4917e-02_r8/)
      kao(:, 3, 3,11) = (/ &
     &2.7211e-01_r8,2.3816e-01_r8,2.0423e-01_r8,1.7032e-01_r8,1.3866e-01_r8,1.1338e-01_r8, &
     &8.6877e-02_r8,5.7191e-02_r8,4.6054e-02_r8/)
      kao(:, 4, 3,11) = (/ &
     &3.1770e-01_r8,2.7809e-01_r8,2.3849e-01_r8,1.9887e-01_r8,1.6548e-01_r8,1.3614e-01_r8, &
     &1.0464e-01_r8,7.0039e-02_r8,6.0217e-02_r8/)
      kao(:, 5, 3,11) = (/ &
     &3.6403e-01_r8,3.1863e-01_r8,2.7328e-01_r8,2.2795e-01_r8,1.9641e-01_r8,1.5908e-01_r8, &
     &1.2312e-01_r8,8.3529e-02_r8,7.7572e-02_r8/)
      kao(:, 1, 4,11) = (/ &
     &3.4588e-01_r8,3.0268e-01_r8,2.5948e-01_r8,2.1629e-01_r8,1.7307e-01_r8,1.2990e-01_r8, &
     &9.1217e-02_r8,5.3135e-02_r8,2.1767e-02_r8/)
      kao(:, 2, 4,11) = (/ &
     &4.3145e-01_r8,3.7755e-01_r8,3.2366e-01_r8,2.6977e-01_r8,2.1589e-01_r8,1.6201e-01_r8, &
     &1.1572e-01_r8,6.8208e-02_r8,3.0409e-02_r8/)
      kao(:, 3, 4,11) = (/ &
     &5.2311e-01_r8,4.5776e-01_r8,3.9244e-01_r8,3.2707e-01_r8,2.6176e-01_r8,1.9718e-01_r8, &
     &1.4225e-01_r8,8.5649e-02_r8,4.0906e-02_r8/)
      kao(:, 4, 4,11) = (/ &
     &6.1949e-01_r8,5.4214e-01_r8,4.6476e-01_r8,3.8737e-01_r8,3.1001e-01_r8,2.3606e-01_r8, &
     &1.7310e-01_r8,1.0459e-01_r8,5.4382e-02_r8/)
      kao(:, 5, 4,11) = (/ &
     &7.1941e-01_r8,6.2950e-01_r8,5.3975e-01_r8,4.4985e-01_r8,3.6002e-01_r8,2.8013e-01_r8, &
     &2.0492e-01_r8,1.2467e-01_r8,7.0400e-02_r8/)
      kao(:, 1, 5,11) = (/ &
     &5.8048e-01_r8,5.0796e-01_r8,4.3542e-01_r8,3.6286e-01_r8,2.9032e-01_r8,2.1780e-01_r8, &
     &1.4642e-01_r8,8.0688e-02_r8,1.7624e-02_r8/)
      kao(:, 2, 5,11) = (/ &
     &7.4078e-01_r8,6.4817e-01_r8,5.5562e-01_r8,4.6305e-01_r8,3.7047e-01_r8,2.7793e-01_r8, &
     &1.8667e-01_r8,1.0393e-01_r8,2.5321e-02_r8/)
      kao(:, 3, 5,11) = (/ &
     &9.1562e-01_r8,8.0121e-01_r8,6.8680e-01_r8,5.7241e-01_r8,4.5798e-01_r8,3.4354e-01_r8, &
     &2.3145e-01_r8,1.3051e-01_r8,3.5008e-02_r8/)
      kao(:, 4, 5,11) = (/ &
     &1.1041e+00_r8,9.6607e-01_r8,8.2810e-01_r8,6.9018e-01_r8,5.5220e-01_r8,4.1422e-01_r8, &
     &2.8137e-01_r8,1.6106e-01_r8,4.7504e-02_r8/)
      kao(:, 5, 5,11) = (/ &
     &1.3000e+00_r8,1.1374e+00_r8,9.7498e-01_r8,8.1255e-01_r8,6.5013e-01_r8,4.8767e-01_r8, &
     &3.3622e-01_r8,1.9350e-01_r8,6.2782e-02_r8/)
      kao(:, 1, 6,11) = (/ &
     &8.9158e-01_r8,7.8014e-01_r8,6.6870e-01_r8,5.5724e-01_r8,4.4582e-01_r8,3.3441e-01_r8, &
     &2.2372e-01_r8,1.1615e-01_r8,1.3452e-02_r8/)
      kao(:, 2, 6,11) = (/ &
     &1.1678e+00_r8,1.0218e+00_r8,8.7586e-01_r8,7.2991e-01_r8,5.8393e-01_r8,4.3799e-01_r8, &
     &2.9305e-01_r8,1.5296e-01_r8,1.9872e-02_r8/)
      kao(:, 3, 6,11) = (/ &
     &1.4777e+00_r8,1.2930e+00_r8,1.1083e+00_r8,9.2359e-01_r8,7.3888e-01_r8,5.5427e-01_r8, &
     &3.7059e-01_r8,1.9566e-01_r8,2.8227e-02_r8/)
      kao(:, 4, 6,11) = (/ &
     &1.8119e+00_r8,1.5855e+00_r8,1.3592e+00_r8,1.1325e+00_r8,9.0614e-01_r8,6.7964e-01_r8, &
     &4.5430e-01_r8,2.4269e-01_r8,3.9342e-02_r8/)
      kao(:, 5, 6,11) = (/ &
     &2.1657e+00_r8,1.8951e+00_r8,1.6242e+00_r8,1.3536e+00_r8,1.0830e+00_r8,8.1233e-01_r8, &
     &5.4303e-01_r8,2.9520e-01_r8,5.3415e-02_r8/)
      kao(:, 1, 7,11) = (/ &
     &1.4142e+00_r8,1.2374e+00_r8,1.0606e+00_r8,8.8396e-01_r8,7.0710e-01_r8,5.3041e-01_r8, &
     &3.5484e-01_r8,1.8101e-01_r8,1.0092e-02_r8/)
      kao(:, 2, 7,11) = (/ &
     &1.9068e+00_r8,1.6686e+00_r8,1.4303e+00_r8,1.1919e+00_r8,9.5353e-01_r8,7.1519e-01_r8, &
     &4.7813e-01_r8,2.4337e-01_r8,1.5041e-02_r8/)
      kao(:, 3, 7,11) = (/ &
     &2.4672e+00_r8,2.1587e+00_r8,1.8505e+00_r8,1.5421e+00_r8,1.2336e+00_r8,9.2548e-01_r8, &
     &6.1872e-01_r8,3.1448e-01_r8,2.1900e-02_r8/)
      kao(:, 4, 7,11) = (/ &
     &3.0809e+00_r8,2.6959e+00_r8,2.3109e+00_r8,1.9258e+00_r8,1.5405e+00_r8,1.1559e+00_r8, &
     &7.7290e-01_r8,3.9302e-01_r8,3.1410e-02_r8/)
      kao(:, 5, 7,11) = (/ &
     &3.7474e+00_r8,3.2787e+00_r8,2.8103e+00_r8,2.3419e+00_r8,1.8737e+00_r8,1.4060e+00_r8, &
     &9.3991e-01_r8,4.7981e-01_r8,4.3693e-02_r8/)
      kao(:, 1, 8,11) = (/ &
     &2.6683e+00_r8,2.3349e+00_r8,2.0012e+00_r8,1.6677e+00_r8,1.3344e+00_r8,1.0014e+00_r8, &
     &6.6874e-01_r8,3.3701e-01_r8,7.4648e-03_r8/)
      kao(:, 2, 8,11) = (/ &
     &3.7060e+00_r8,3.2430e+00_r8,2.7797e+00_r8,2.3168e+00_r8,1.8539e+00_r8,1.3914e+00_r8, &
     &9.2912e-01_r8,4.6800e-01_r8,1.1435e-02_r8/)
      kao(:, 3, 8,11) = (/ &
     &4.9130e+00_r8,4.2993e+00_r8,3.6854e+00_r8,3.0718e+00_r8,2.4583e+00_r8,1.8451e+00_r8, &
     &1.2322e+00_r8,6.2028e-01_r8,1.6885e-02_r8/)
      kao(:, 4, 8,11) = (/ &
     &6.2797e+00_r8,5.4950e+00_r8,4.7108e+00_r8,3.9265e+00_r8,3.1420e+00_r8,2.3582e+00_r8, &
     &1.5746e+00_r8,7.9222e-01_r8,2.4688e-02_r8/)
      kao(:, 5, 8,11) = (/ &
     &7.7638e+00_r8,6.7943e+00_r8,5.8243e+00_r8,4.8546e+00_r8,3.8850e+00_r8,2.9154e+00_r8, &
     &1.9466e+00_r8,9.7896e-01_r8,3.5101e-02_r8/)
      kao(:, 1, 9,11) = (/ &
     &9.7135e+00_r8,8.4998e+00_r8,7.2860e+00_r8,6.0723e+00_r8,4.8583e+00_r8,3.6448e+00_r8, &
     &2.4304e+00_r8,1.2171e+00_r8,3.5233e-03_r8/)
      kao(:, 2, 9,11) = (/ &
     &1.3929e+01_r8,1.2189e+01_r8,1.0449e+01_r8,8.7078e+00_r8,6.9673e+00_r8,5.2263e+00_r8, &
     &3.4856e+00_r8,1.7453e+00_r8,4.1308e-03_r8/)
      kao(:, 3, 9,11) = (/ &
     &1.8989e+01_r8,1.6615e+01_r8,1.4243e+01_r8,1.1869e+01_r8,9.4966e+00_r8,7.1244e+00_r8, &
     &4.7516e+00_r8,2.3792e+00_r8,6.6319e-03_r8/)
      kao(:, 4, 9,11) = (/ &
     &2.4785e+01_r8,2.1688e+01_r8,1.8591e+01_r8,1.5493e+01_r8,1.2396e+01_r8,9.2991e+00_r8, &
     &6.2019e+00_r8,3.1051e+00_r8,1.1490e-02_r8/)
      kao(:, 5, 9,11) = (/ &
     &3.1283e+01_r8,2.7373e+01_r8,2.3465e+01_r8,1.9556e+01_r8,1.5646e+01_r8,1.1737e+01_r8, &
     &7.8279e+00_r8,3.9188e+00_r8,2.1019e-02_r8/)
      kao(:, 1,10,11) = (/ &
     &4.1666e+01_r8,3.6458e+01_r8,3.1251e+01_r8,2.6043e+01_r8,2.0835e+01_r8,1.5628e+01_r8, &
     &1.0419e+01_r8,5.2119e+00_r8,1.6494e-03_r8/)
      kao(:, 2,10,11) = (/ &
     &6.1694e+01_r8,5.3987e+01_r8,4.6271e+01_r8,3.8561e+01_r8,3.0850e+01_r8,2.3139e+01_r8, &
     &1.5428e+01_r8,7.7161e+00_r8,4.8320e-03_r8/)
      kao(:, 3,10,11) = (/ &
     &8.6109e+01_r8,7.5347e+01_r8,6.4581e+01_r8,5.3821e+01_r8,4.3056e+01_r8,3.2294e+01_r8, &
     &2.1533e+01_r8,1.0770e+01_r8,3.2818e-03_r8/)
      kao(:, 4,10,11) = (/ &
     &1.1458e+02_r8,1.0025e+02_r8,8.5946e+01_r8,7.1620e+01_r8,5.7298e+01_r8,4.2975e+01_r8, &
     &2.8651e+01_r8,1.4330e+01_r8,1.0923e-02_r8/)
      kao(:, 5,10,11) = (/ &
     &1.4689e+02_r8,1.2853e+02_r8,1.1017e+02_r8,9.1808e+01_r8,7.3452e+01_r8,5.5088e+01_r8, &
     &3.6731e+01_r8,1.8371e+01_r8,1.7421e-02_r8/)
      kao(:, 1,11,11) = (/ &
     &7.6402e+01_r8,6.6855e+01_r8,5.7300e+01_r8,4.7753e+01_r8,3.8204e+01_r8,2.8655e+01_r8, &
     &1.9105e+01_r8,9.5538e+00_r8,4.1075e-05_r8/)
      kao(:, 2,11,11) = (/ &
     &1.1253e+02_r8,9.8463e+01_r8,8.4399e+01_r8,7.0331e+01_r8,5.6269e+01_r8,4.2202e+01_r8, &
     &2.8136e+01_r8,1.4070e+01_r8,5.7635e-05_r8/)
      kao(:, 3,11,11) = (/ &
     &1.5636e+02_r8,1.3680e+02_r8,1.1725e+02_r8,9.7724e+01_r8,7.8173e+01_r8,5.8632e+01_r8, &
     &3.9090e+01_r8,1.9548e+01_r8,8.0706e-05_r8/)
      kao(:, 4,11,11) = (/ &
     &2.0774e+02_r8,1.8177e+02_r8,1.5580e+02_r8,1.2984e+02_r8,1.0387e+02_r8,7.7908e+01_r8, &
     &5.1937e+01_r8,2.5972e+01_r8,1.1256e-02_r8/)
      kao(:, 5,11,11) = (/ &
     &2.6504e+02_r8,2.3192e+02_r8,1.9880e+02_r8,1.6566e+02_r8,1.3254e+02_r8,9.9402e+01_r8, &
     &6.6269e+01_r8,3.3138e+01_r8,8.3317e-03_r8/)
      kao(:, 1,12,11) = (/ &
     &1.0209e+02_r8,8.9323e+01_r8,7.6564e+01_r8,6.3800e+01_r8,5.1042e+01_r8,3.8285e+01_r8, &
     &2.5522e+01_r8,1.2763e+01_r8,2.5628e-05_r8/)
      kao(:, 2,12,11) = (/ &
     &1.4952e+02_r8,1.3083e+02_r8,1.1214e+02_r8,9.3447e+01_r8,7.4760e+01_r8,5.6068e+01_r8, &
     &3.7381e+01_r8,1.8692e+01_r8,3.7727e-05_r8/)
      kao(:, 3,12,11) = (/ &
     &2.0709e+02_r8,1.8121e+02_r8,1.5533e+02_r8,1.2944e+02_r8,1.0355e+02_r8,7.7656e+01_r8, &
     &5.1777e+01_r8,2.5887e+01_r8,4.7198e-05_r8/)
      kao(:, 4,12,11) = (/ &
     &2.7380e+02_r8,2.3961e+02_r8,2.0536e+02_r8,1.7114e+02_r8,1.3691e+02_r8,1.0268e+02_r8, &
     &6.8461e+01_r8,3.4230e+01_r8,7.7074e-03_r8/)
      kao(:, 5,12,11) = (/ &
     &3.4895e+02_r8,3.0533e+02_r8,2.6172e+02_r8,2.1811e+02_r8,1.7449e+02_r8,1.3086e+02_r8, &
     &8.7241e+01_r8,4.3626e+01_r8,8.7565e-03_r8/)
      kao(:, 1,13,11) = (/ &
     &1.0675e+02_r8,9.3411e+01_r8,8.0067e+01_r8,6.6725e+01_r8,5.3379e+01_r8,4.0032e+01_r8, &
     &2.6688e+01_r8,1.3347e+01_r8,1.6230e-05_r8/)
      kao(:, 2,13,11) = (/ &
     &1.5608e+02_r8,1.3657e+02_r8,1.1706e+02_r8,9.7552e+01_r8,7.8046e+01_r8,5.8531e+01_r8, &
     &3.9024e+01_r8,1.9513e+01_r8,2.2466e-05_r8/)
      kao(:, 3,13,11) = (/ &
     &2.1549e+02_r8,1.8855e+02_r8,1.6162e+02_r8,1.3468e+02_r8,1.0774e+02_r8,8.0803e+01_r8, &
     &5.3874e+01_r8,2.6939e+01_r8,3.0542e-05_r8/)
      kao(:, 4,13,11) = (/ &
     &2.8371e+02_r8,2.4826e+02_r8,2.1280e+02_r8,1.7733e+02_r8,1.4186e+02_r8,1.0640e+02_r8, &
     &7.0935e+01_r8,3.5470e+01_r8,1.3758e-03_r8/)
      kao(:, 5,13,11) = (/ &
     &3.5962e+02_r8,3.1467e+02_r8,2.6973e+02_r8,2.2478e+02_r8,1.7981e+02_r8,1.3487e+02_r8, &
     &8.9910e+01_r8,4.4960e+01_r8,3.9903e-03_r8/)
      kao(:, 1, 1,12) = (/ &
     &9.6318e-02_r8,8.4306e-02_r8,7.2320e-02_r8,6.0347e-02_r8,5.2079e-02_r8,4.4235e-02_r8, &
     &3.5296e-02_r8,3.0172e-02_r8,3.8372e-02_r8/)
      kao(:, 2, 1,12) = (/ &
     &1.1333e-01_r8,9.9268e-02_r8,8.5214e-02_r8,7.2014e-02_r8,6.3588e-02_r8,5.4323e-02_r8, &
     &4.4306e-02_r8,4.1727e-02_r8,5.1292e-02_r8/)
      kao(:, 3, 1,12) = (/ &
     &1.3065e-01_r8,1.1448e-01_r8,9.8324e-02_r8,8.5358e-02_r8,7.7141e-02_r8,6.4277e-02_r8, &
     &5.5750e-02_r8,5.5415e-02_r8,6.7933e-02_r8/)
      kao(:, 4, 1,12) = (/ &
     &1.4795e-01_r8,1.2969e-01_r8,1.1146e-01_r8,1.0185e-01_r8,9.0045e-02_r8,7.5178e-02_r8, &
     &6.8885e-02_r8,7.0700e-02_r8,8.8138e-02_r8/)
      kao(:, 5, 1,12) = (/ &
     &1.6491e-01_r8,1.4461e-01_r8,1.2472e-01_r8,1.1761e-01_r8,1.0268e-01_r8,8.7802e-02_r8, &
     &8.5057e-02_r8,9.0208e-02_r8,1.1284e-01_r8/)
      kao(:, 1, 2,12) = (/ &
     &1.4316e-01_r8,1.2534e-01_r8,1.0752e-01_r8,8.9701e-02_r8,7.2577e-02_r8,5.9608e-02_r8, &
     &4.6628e-02_r8,3.2233e-02_r8,3.6922e-02_r8/)
      kao(:, 2, 2,12) = (/ &
     &1.7023e-01_r8,1.4907e-01_r8,1.2790e-01_r8,1.0674e-01_r8,8.8738e-02_r8,7.3250e-02_r8, &
     &5.7353e-02_r8,4.3254e-02_r8,4.9659e-02_r8/)
      kao(:, 3, 2,12) = (/ &
     &1.9792e-01_r8,1.7332e-01_r8,1.4875e-01_r8,1.2418e-01_r8,1.0651e-01_r8,8.8601e-02_r8, &
     &6.9038e-02_r8,5.5574e-02_r8,6.6062e-02_r8/)
      kao(:, 4, 2,12) = (/ &
     &2.2567e-01_r8,1.9768e-01_r8,1.6971e-01_r8,1.4278e-01_r8,1.2696e-01_r8,1.0366e-01_r8, &
     &8.1948e-02_r8,7.1191e-02_r8,8.6127e-02_r8/)
      kao(:, 5, 2,12) = (/ &
     &2.5314e-01_r8,2.2175e-01_r8,1.9032e-01_r8,1.6565e-01_r8,1.4606e-01_r8,1.1970e-01_r8, &
     &9.8165e-02_r8,9.0526e-02_r8,1.1061e-01_r8/)
      kao(:, 1, 3,12) = (/ &
     &2.7385e-01_r8,2.3971e-01_r8,2.0552e-01_r8,1.7136e-01_r8,1.3716e-01_r8,1.0300e-01_r8, &
     &7.5178e-02_r8,4.5691e-02_r8,3.3533e-02_r8/)
      kao(:, 2, 3,12) = (/ &
     &3.3090e-01_r8,2.8961e-01_r8,2.4836e-01_r8,2.0707e-01_r8,1.6581e-01_r8,1.2597e-01_r8, &
     &9.2542e-02_r8,5.7168e-02_r8,4.5647e-02_r8/)
      kao(:, 3, 3,12) = (/ &
     &3.8960e-01_r8,3.4098e-01_r8,2.9239e-01_r8,2.4379e-01_r8,1.9517e-01_r8,1.5181e-01_r8, &
     &1.1308e-01_r8,7.0212e-02_r8,6.1610e-02_r8/)
      kao(:, 4, 3,12) = (/ &
     &4.4888e-01_r8,3.9285e-01_r8,3.3686e-01_r8,2.8085e-01_r8,2.2487e-01_r8,1.8074e-01_r8, &
     &1.3367e-01_r8,8.4795e-02_r8,8.0803e-02_r8/)
      kao(:, 5, 3,12) = (/ &
     &5.0777e-01_r8,4.4444e-01_r8,3.8104e-01_r8,3.1773e-01_r8,2.5631e-01_r8,2.1146e-01_r8, &
     &1.5502e-01_r8,1.0449e-01_r8,1.0410e-01_r8/)
      kao(:, 1, 4,12) = (/ &
     &5.2233e-01_r8,4.5708e-01_r8,3.9182e-01_r8,3.2654e-01_r8,2.6131e-01_r8,1.9604e-01_r8, &
     &1.3079e-01_r8,7.4640e-02_r8,2.9498e-02_r8/)
      kao(:, 2, 4,12) = (/ &
     &6.4217e-01_r8,5.6200e-01_r8,4.8174e-01_r8,4.0151e-01_r8,3.2131e-01_r8,2.4104e-01_r8, &
     &1.6124e-01_r8,9.3279e-02_r8,4.1076e-02_r8/)
      kao(:, 3, 4,12) = (/ &
     &7.6818e-01_r8,6.7216e-01_r8,5.7628e-01_r8,4.8026e-01_r8,3.8431e-01_r8,2.8834e-01_r8, &
     &1.9584e-01_r8,1.1499e-01_r8,5.5764e-02_r8/)
      kao(:, 4, 4,12) = (/ &
     &8.9714e-01_r8,7.8510e-01_r8,6.7304e-01_r8,5.6095e-01_r8,4.4882e-01_r8,3.3677e-01_r8, &
     &2.3398e-01_r8,1.3732e-01_r8,7.3695e-02_r8/)
      kao(:, 5, 4,12) = (/ &
     &1.0267e+00_r8,8.9838e-01_r8,7.7018e-01_r8,6.4193e-01_r8,5.1368e-01_r8,3.8545e-01_r8, &
     &2.7687e-01_r8,1.6073e-01_r8,9.6046e-02_r8/)
      kao(:, 1, 5,12) = (/ &
     &9.0551e-01_r8,7.9235e-01_r8,6.7918e-01_r8,5.6601e-01_r8,4.5286e-01_r8,3.3967e-01_r8, &
     &2.2649e-01_r8,1.1543e-01_r8,2.5575e-02_r8/)
      kao(:, 2, 5,12) = (/ &
     &1.1369e+00_r8,9.9490e-01_r8,8.5273e-01_r8,7.1065e-01_r8,5.6855e-01_r8,4.2647e-01_r8, &
     &2.8441e-01_r8,1.4706e-01_r8,3.6472e-02_r8/)
      kao(:, 3, 5,12) = (/ &
     &1.3835e+00_r8,1.2106e+00_r8,1.0376e+00_r8,8.6468e-01_r8,6.9181e-01_r8,5.1896e-01_r8, &
     &3.4607e-01_r8,1.8250e-01_r8,5.0201e-02_r8/)
      kao(:, 4, 5,12) = (/ &
     &1.6400e+00_r8,1.4350e+00_r8,1.2302e+00_r8,1.0252e+00_r8,8.2021e-01_r8,6.1526e-01_r8, &
     &4.1028e-01_r8,2.2034e-01_r8,6.6839e-02_r8/)
      kao(:, 5, 5,12) = (/ &
     &1.9010e+00_r8,1.6635e+00_r8,1.4259e+00_r8,1.1884e+00_r8,9.5076e-01_r8,7.1323e-01_r8, &
     &4.7563e-01_r8,2.6201e-01_r8,8.7568e-02_r8/)
      kao(:, 1, 6,12) = (/ &
     &1.4399e+00_r8,1.2599e+00_r8,1.0800e+00_r8,9.0001e-01_r8,7.2000e-01_r8,5.4003e-01_r8, &
     &3.6008e-01_r8,1.8026e-01_r8,2.1293e-02_r8/)
      kao(:, 2, 6,12) = (/ &
     &1.8513e+00_r8,1.6198e+00_r8,1.3886e+00_r8,1.1570e+00_r8,9.2575e-01_r8,6.9429e-01_r8, &
     &4.6294e-01_r8,2.3182e-01_r8,3.1128e-02_r8/)
      kao(:, 3, 6,12) = (/ &
     &2.3002e+00_r8,2.0128e+00_r8,1.7253e+00_r8,1.4377e+00_r8,1.1502e+00_r8,8.6271e-01_r8, &
     &5.7522e-01_r8,2.8786e-01_r8,4.3673e-02_r8/)
      kao(:, 4, 6,12) = (/ &
     &2.7724e+00_r8,2.4259e+00_r8,2.0792e+00_r8,1.7327e+00_r8,1.3862e+00_r8,1.0398e+00_r8, &
     &6.9321e-01_r8,3.4832e-01_r8,5.9465e-02_r8/)
      kao(:, 5, 6,12) = (/ &
     &3.2575e+00_r8,2.8504e+00_r8,2.4432e+00_r8,2.0359e+00_r8,1.6288e+00_r8,1.2216e+00_r8, &
     &8.1457e-01_r8,4.1431e-01_r8,7.8852e-02_r8/)
      kao(:, 1, 7,12) = (/ &
     &2.3706e+00_r8,2.0741e+00_r8,1.7778e+00_r8,1.4816e+00_r8,1.1852e+00_r8,8.8892e-01_r8, &
     &5.9261e-01_r8,2.9636e-01_r8,1.6814e-02_r8/)
      kao(:, 2, 7,12) = (/ &
     &3.1315e+00_r8,2.7398e+00_r8,2.3484e+00_r8,1.9572e+00_r8,1.5657e+00_r8,1.1742e+00_r8, &
     &7.8297e-01_r8,3.9150e-01_r8,2.5425e-02_r8/)
      kao(:, 3, 7,12) = (/ &
     &3.9698e+00_r8,3.4734e+00_r8,2.9772e+00_r8,2.4811e+00_r8,1.9850e+00_r8,1.4887e+00_r8, &
     &9.9245e-01_r8,4.9628e-01_r8,3.6698e-02_r8/)
      kao(:, 4, 7,12) = (/ &
     &4.8729e+00_r8,4.2639e+00_r8,3.6548e+00_r8,3.0457e+00_r8,2.4366e+00_r8,1.8275e+00_r8, &
     &1.2184e+00_r8,6.0927e-01_r8,5.1098e-02_r8/)
      kao(:, 5, 7,12) = (/ &
     &5.8302e+00_r8,5.1015e+00_r8,4.3726e+00_r8,3.6438e+00_r8,2.9154e+00_r8,2.1865e+00_r8, &
     &1.4578e+00_r8,7.2896e-01_r8,6.9201e-02_r8/)
      kao(:, 1, 8,12) = (/ &
     &4.6083e+00_r8,4.0328e+00_r8,3.4566e+00_r8,2.8804e+00_r8,2.3046e+00_r8,1.7283e+00_r8, &
     &1.1523e+00_r8,5.7615e-01_r8,1.2896e-02_r8/)
      kao(:, 2, 8,12) = (/ &
     &6.2568e+00_r8,5.4739e+00_r8,4.6922e+00_r8,3.9099e+00_r8,3.1281e+00_r8,2.3461e+00_r8, &
     &1.5641e+00_r8,7.8209e-01_r8,1.9880e-02_r8/)
      kao(:, 3, 8,12) = (/ &
     &8.1358e+00_r8,7.1187e+00_r8,6.1015e+00_r8,5.0849e+00_r8,4.0679e+00_r8,3.0509e+00_r8, &
     &2.0338e+00_r8,1.0170e+00_r8,2.9497e-02_r8/)
      kao(:, 4, 8,12) = (/ &
     &1.0204e+01_r8,8.9284e+00_r8,7.6531e+00_r8,6.3773e+00_r8,5.1020e+00_r8,3.8269e+00_r8, &
     &2.5510e+00_r8,1.2755e+00_r8,4.2115e-02_r8/)
      kao(:, 5, 8,12) = (/ &
     &1.2434e+01_r8,1.0880e+01_r8,9.3260e+00_r8,7.7708e+00_r8,6.2169e+00_r8,4.6632e+00_r8, &
     &3.1088e+00_r8,1.5543e+00_r8,5.8665e-02_r8/)
      kao(:, 1, 9,12) = (/ &
     &1.6573e+01_r8,1.4502e+01_r8,1.2430e+01_r8,1.0358e+01_r8,8.2865e+00_r8,6.2149e+00_r8, &
     &4.1429e+00_r8,2.0717e+00_r8,3.2506e-03_r8/)
      kao(:, 2, 9,12) = (/ &
     &2.3241e+01_r8,2.0336e+01_r8,1.7432e+01_r8,1.4525e+01_r8,1.1622e+01_r8,8.7162e+00_r8, &
     &5.8106e+00_r8,2.9051e+00_r8,8.0054e-03_r8/)
      kao(:, 3, 9,12) = (/ &
     &3.1035e+01_r8,2.7156e+01_r8,2.3277e+01_r8,1.9396e+01_r8,1.5516e+01_r8,1.1638e+01_r8, &
     &7.7589e+00_r8,3.8795e+00_r8,1.2478e-02_r8/)
      kao(:, 4, 9,12) = (/ &
     &3.9794e+01_r8,3.4820e+01_r8,2.9846e+01_r8,2.4871e+01_r8,1.9897e+01_r8,1.4923e+01_r8, &
     &9.9485e+00_r8,4.9745e+00_r8,2.7934e-02_r8/)
      kao(:, 5, 9,12) = (/ &
     &4.9259e+01_r8,4.3099e+01_r8,3.6943e+01_r8,3.0785e+01_r8,2.4628e+01_r8,1.8472e+01_r8, &
     &1.2315e+01_r8,6.1576e+00_r8,4.7661e-02_r8/)
      kao(:, 1,10,12) = (/ &
     &6.7160e+01_r8,5.8765e+01_r8,5.0369e+01_r8,4.1974e+01_r8,3.3581e+01_r8,2.5186e+01_r8, &
     &1.6790e+01_r8,8.3953e+00_r8,3.7061e-05_r8/)
      kao(:, 2,10,12) = (/ &
     &9.7116e+01_r8,8.4979e+01_r8,7.2826e+01_r8,6.0693e+01_r8,4.8559e+01_r8,3.6416e+01_r8, &
     &2.4277e+01_r8,1.2139e+01_r8,5.3890e-03_r8/)
      kao(:, 3,10,12) = (/ &
     &1.3274e+02_r8,1.1614e+02_r8,9.9552e+01_r8,8.2959e+01_r8,6.6370e+01_r8,4.9775e+01_r8, &
     &3.3183e+01_r8,1.6592e+01_r8,5.5995e-03_r8/)
      kao(:, 4,10,12) = (/ &
     &1.7342e+02_r8,1.5174e+02_r8,1.3008e+02_r8,1.0839e+02_r8,8.6716e+01_r8,6.5036e+01_r8, &
     &4.3354e+01_r8,2.1678e+01_r8,7.3568e-03_r8/)
      kao(:, 5,10,12) = (/ &
     &2.1869e+02_r8,1.9137e+02_r8,1.6402e+02_r8,1.3669e+02_r8,1.0934e+02_r8,8.2010e+01_r8, &
     &5.4674e+01_r8,2.7339e+01_r8,1.9171e-02_r8/)
      kao(:, 1,11,12) = (/ &
     &1.1512e+02_r8,1.0073e+02_r8,8.6335e+01_r8,7.1940e+01_r8,5.7559e+01_r8,4.3164e+01_r8, &
     &2.8776e+01_r8,1.4390e+01_r8,3.3905e-05_r8/)
      kao(:, 2,11,12) = (/ &
     &1.6697e+02_r8,1.4609e+02_r8,1.2523e+02_r8,1.0436e+02_r8,8.3482e+01_r8,6.2612e+01_r8, &
     &4.1744e+01_r8,2.0873e+01_r8,5.9590e-05_r8/)
      kao(:, 3,11,12) = (/ &
     &2.2930e+02_r8,2.0064e+02_r8,1.7196e+02_r8,1.4331e+02_r8,1.1466e+02_r8,8.5994e+01_r8, &
     &5.7327e+01_r8,2.8668e+01_r8,8.9833e-05_r8/)
      kao(:, 4,11,12) = (/ &
     &3.0132e+02_r8,2.6364e+02_r8,2.2598e+02_r8,1.8835e+02_r8,1.5066e+02_r8,1.1300e+02_r8, &
     &7.5334e+01_r8,3.7671e+01_r8,8.4167e-03_r8/)
      kao(:, 5,11,12) = (/ &
     &3.8162e+02_r8,3.3392e+02_r8,2.8622e+02_r8,2.3853e+02_r8,1.9083e+02_r8,1.4312e+02_r8, &
     &9.5410e+01_r8,4.7709e+01_r8,1.8161e-02_r8/)
      kao(:, 1,12,12) = (/ &
     &1.5129e+02_r8,1.3238e+02_r8,1.1347e+02_r8,9.4558e+01_r8,7.5645e+01_r8,5.6733e+01_r8, &
     &3.7823e+01_r8,1.8915e+01_r8,3.6770e-05_r8/)
      kao(:, 2,12,12) = (/ &
     &2.2053e+02_r8,1.9297e+02_r8,1.6541e+02_r8,1.3784e+02_r8,1.1026e+02_r8,8.2702e+01_r8, &
     &5.5137e+01_r8,2.7573e+01_r8,5.2389e-05_r8/)
      kao(:, 3,12,12) = (/ &
     &3.0464e+02_r8,2.6657e+02_r8,2.2849e+02_r8,1.9040e+02_r8,1.5233e+02_r8,1.1424e+02_r8, &
     &7.6159e+01_r8,3.8090e+01_r8,7.1306e-05_r8/)
      kao(:, 4,12,12) = (/ &
     &4.0144e+02_r8,3.5128e+02_r8,3.0110e+02_r8,2.5092e+02_r8,2.0072e+02_r8,1.5055e+02_r8, &
     &1.0037e+02_r8,5.0190e+01_r8,9.4766e-05_r8/)
      kao(:, 5,12,12) = (/ &
     &5.1041e+02_r8,4.4660e+02_r8,3.8281e+02_r8,3.1900e+02_r8,2.5521e+02_r8,1.9140e+02_r8, &
     &1.2761e+02_r8,6.3809e+01_r8,8.9549e-03_r8/)
      kao(:, 1,13,12) = (/ &
     &1.6406e+02_r8,1.4356e+02_r8,1.2306e+02_r8,1.0255e+02_r8,8.2037e+01_r8,6.1534e+01_r8, &
     &4.1023e+01_r8,2.0513e+01_r8,2.9105e-05_r8/)
      kao(:, 2,13,12) = (/ &
     &2.3966e+02_r8,2.0971e+02_r8,1.7976e+02_r8,1.4978e+02_r8,1.1983e+02_r8,8.9879e+01_r8, &
     &5.9920e+01_r8,2.9966e+01_r8,3.6736e-05_r8/)
      kao(:, 3,13,12) = (/ &
     &3.3040e+02_r8,2.8909e+02_r8,2.4781e+02_r8,2.0651e+02_r8,1.6521e+02_r8,1.2390e+02_r8, &
     &8.2608e+01_r8,4.1307e+01_r8,4.7139e-05_r8/)
      kao(:, 4,13,12) = (/ &
     &4.3608e+02_r8,3.8160e+02_r8,3.2708e+02_r8,2.7256e+02_r8,2.1804e+02_r8,1.6354e+02_r8, &
     &1.0903e+02_r8,5.4517e+01_r8,5.9953e-05_r8/)
      kao(:, 5,13,12) = (/ &
     &5.5401e+02_r8,4.8478e+02_r8,4.1553e+02_r8,3.4627e+02_r8,2.7701e+02_r8,2.0776e+02_r8, &
     &1.3851e+02_r8,6.9261e+01_r8,1.3826e-02_r8/)
      kao(:, 1, 1,13) = (/ &
     &1.2490e-01_r8,1.0932e-01_r8,9.3720e-02_r8,7.8121e-02_r8,6.3794e-02_r8,5.1600e-02_r8, &
     &4.4680e-02_r8,4.2635e-02_r8,5.5634e-02_r8/)
      kao(:, 2, 1,13) = (/ &
     &1.4548e-01_r8,1.2733e-01_r8,1.0918e-01_r8,9.1021e-02_r8,7.6620e-02_r8,6.3500e-02_r8, &
     &5.7581e-02_r8,5.7524e-02_r8,7.4793e-02_r8/)
      kao(:, 3, 1,13) = (/ &
     &1.6600e-01_r8,1.4529e-01_r8,1.2460e-01_r8,1.0392e-01_r8,9.0379e-02_r8,7.8694e-02_r8, &
     &7.4384e-02_r8,7.8232e-02_r8,9.9775e-02_r8/)
      kao(:, 4, 1,13) = (/ &
     &1.8636e-01_r8,1.6314e-01_r8,1.3994e-01_r8,1.1863e-01_r8,1.0661e-01_r8,9.7110e-02_r8, &
     &9.8012e-02_r8,1.0654e-01_r8,1.3265e-01_r8/)
      kao(:, 5, 1,13) = (/ &
     &2.0606e-01_r8,1.8040e-01_r8,1.5476e-01_r8,1.3669e-01_r8,1.2405e-01_r8,1.1873e-01_r8, &
     &1.2869e-01_r8,1.4070e-01_r8,1.7529e-01_r8/)
      kao(:, 1, 2,13) = (/ &
     &1.8895e-01_r8,1.6535e-01_r8,1.4175e-01_r8,1.1814e-01_r8,9.4551e-02_r8,7.3809e-02_r8, &
     &5.5615e-02_r8,4.4637e-02_r8,5.3030e-02_r8/)
      kao(:, 2, 2,13) = (/ &
     &2.2250e-01_r8,1.9470e-01_r8,1.6692e-01_r8,1.3914e-01_r8,1.1136e-01_r8,8.8262e-02_r8, &
     &7.0022e-02_r8,6.0363e-02_r8,7.3472e-02_r8/)
      kao(:, 3, 2,13) = (/ &
     &2.5567e-01_r8,2.2376e-01_r8,1.9185e-01_r8,1.5991e-01_r8,1.3005e-01_r8,1.0599e-01_r8, &
     &8.7655e-02_r8,7.9726e-02_r8,9.6994e-02_r8/)
      kao(:, 4, 2,13) = (/ &
     &2.8747e-01_r8,2.5157e-01_r8,2.1569e-01_r8,1.7980e-01_r8,1.5083e-01_r8,1.2699e-01_r8, &
     &1.0917e-01_r8,1.0493e-01_r8,1.2703e-01_r8/)
      kao(:, 5, 2,13) = (/ &
     &3.1781e-01_r8,2.7817e-01_r8,2.3857e-01_r8,1.9898e-01_r8,1.7411e-01_r8,1.5016e-01_r8, &
     &1.3454e-01_r8,1.3707e-01_r8,1.6656e-01_r8/)
      kao(:, 1, 3,13) = (/ &
     &3.6978e-01_r8,3.2357e-01_r8,2.7737e-01_r8,2.3116e-01_r8,1.8494e-01_r8,1.3872e-01_r8, &
     &9.4432e-02_r8,5.7465e-02_r8,4.7026e-02_r8/)
      kao(:, 2, 3,13) = (/ &
     &4.3903e-01_r8,3.8415e-01_r8,3.2929e-01_r8,2.7445e-01_r8,2.1956e-01_r8,1.6470e-01_r8, &
     &1.1482e-01_r8,7.4394e-02_r8,6.6138e-02_r8/)
      kao(:, 3, 3,13) = (/ &
     &5.0855e-01_r8,4.4506e-01_r8,3.8154e-01_r8,3.1805e-01_r8,2.5451e-01_r8,1.9102e-01_r8, &
     &1.3670e-01_r8,9.4825e-02_r8,8.9406e-02_r8/)
      kao(:, 4, 3,13) = (/ &
     &5.7817e-01_r8,5.0599e-01_r8,4.3381e-01_r8,3.6166e-01_r8,2.8948e-01_r8,2.2042e-01_r8, &
     &1.6420e-01_r8,1.1827e-01_r8,1.1730e-01_r8/)
      kao(:, 5, 3,13) = (/ &
     &6.4715e-01_r8,5.6638e-01_r8,4.8566e-01_r8,4.0494e-01_r8,3.2419e-01_r8,2.5446e-01_r8, &
     &1.9367e-01_r8,1.4612e-01_r8,1.5219e-01_r8/)
      kao(:, 1, 4,13) = (/ &
     &7.1857e-01_r8,6.2877e-01_r8,5.3894e-01_r8,4.4919e-01_r8,3.5935e-01_r8,2.6957e-01_r8, &
     &1.7976e-01_r8,9.3998e-02_r8,4.1187e-02_r8/)
      kao(:, 2, 4,13) = (/ &
     &8.6835e-01_r8,7.5986e-01_r8,6.5131e-01_r8,5.4283e-01_r8,4.3435e-01_r8,3.2583e-01_r8, &
     &2.1731e-01_r8,1.1522e-01_r8,5.8302e-02_r8/)
      kao(:, 3, 4,13) = (/ &
     &1.0243e+00_r8,8.9626e-01_r8,7.6836e-01_r8,6.4035e-01_r8,5.1240e-01_r8,3.8438e-01_r8, &
     &2.5643e-01_r8,1.3949e-01_r8,7.9878e-02_r8/)
      kao(:, 4, 4,13) = (/ &
     &1.1800e+00_r8,1.0326e+00_r8,8.8512e-01_r8,7.3767e-01_r8,5.9020e-01_r8,4.4282e-01_r8, &
     &2.9609e-01_r8,1.6997e-01_r8,1.0651e-01_r8/)
      kao(:, 5, 4,13) = (/ &
     &1.3277e+00_r8,1.1619e+00_r8,9.9598e-01_r8,8.3009e-01_r8,6.6410e-01_r8,4.9823e-01_r8, &
     &3.3917e-01_r8,2.0392e-01_r8,1.3923e-01_r8/)
      kao(:, 1, 5,13) = (/ &
     &1.2769e+00_r8,1.1173e+00_r8,9.5773e-01_r8,7.9808e-01_r8,6.3854e-01_r8,4.7892e-01_r8, &
     &3.1932e-01_r8,1.5974e-01_r8,3.6366e-02_r8/)
      kao(:, 2, 5,13) = (/ &
     &1.5754e+00_r8,1.3783e+00_r8,1.1815e+00_r8,9.8457e-01_r8,7.8769e-01_r8,5.9081e-01_r8, &
     &3.9400e-01_r8,1.9711e-01_r8,5.2068e-02_r8/)
      kao(:, 3, 5,13) = (/ &
     &1.8818e+00_r8,1.6466e+00_r8,1.4114e+00_r8,1.1761e+00_r8,9.4096e-01_r8,7.0577e-01_r8, &
     &4.7057e-01_r8,2.3659e-01_r8,7.1428e-02_r8/)
      kao(:, 4, 5,13) = (/ &
     &2.1862e+00_r8,1.9130e+00_r8,1.6397e+00_r8,1.3666e+00_r8,1.0933e+00_r8,8.2000e-01_r8, &
     &5.4672e-01_r8,2.8019e-01_r8,9.6282e-02_r8/)
      kao(:, 5, 5,13) = (/ &
     &2.4918e+00_r8,2.1806e+00_r8,1.8691e+00_r8,1.5576e+00_r8,1.2460e+00_r8,9.3474e-01_r8, &
     &6.2322e-01_r8,3.2775e-01_r8,1.2758e-01_r8/)
      kao(:, 1, 6,13) = (/ &
     &2.0873e+00_r8,1.8265e+00_r8,1.5654e+00_r8,1.3046e+00_r8,1.0437e+00_r8,7.8276e-01_r8, &
     &5.2187e-01_r8,2.6100e-01_r8,3.1022e-02_r8/)
      kao(:, 2, 6,13) = (/ &
     &2.6230e+00_r8,2.2953e+00_r8,1.9673e+00_r8,1.6394e+00_r8,1.3116e+00_r8,9.8380e-01_r8, &
     &6.5587e-01_r8,3.2796e-01_r8,4.5564e-02_r8/)
      kao(:, 3, 6,13) = (/ &
     &3.1789e+00_r8,2.7816e+00_r8,2.3843e+00_r8,1.9870e+00_r8,1.5894e+00_r8,1.1921e+00_r8, &
     &7.9481e-01_r8,3.9748e-01_r8,6.4081e-02_r8/)
      kao(:, 4, 6,13) = (/ &
     &3.7665e+00_r8,3.2952e+00_r8,2.8247e+00_r8,2.3538e+00_r8,1.8832e+00_r8,1.4124e+00_r8, &
     &9.4165e-01_r8,4.7095e-01_r8,8.7003e-02_r8/)
      kao(:, 5, 6,13) = (/ &
     &4.3632e+00_r8,3.8180e+00_r8,3.2726e+00_r8,2.7273e+00_r8,2.1819e+00_r8,1.6363e+00_r8, &
     &1.0910e+00_r8,5.4560e-01_r8,1.1609e-01_r8/)
      kao(:, 1, 7,13) = (/ &
     &3.5237e+00_r8,3.0834e+00_r8,2.6428e+00_r8,2.2023e+00_r8,1.7619e+00_r8,1.3214e+00_r8, &
     &8.8102e-01_r8,4.4047e-01_r8,2.5898e-02_r8/)
      kao(:, 2, 7,13) = (/ &
     &4.5331e+00_r8,3.9665e+00_r8,3.3999e+00_r8,2.8333e+00_r8,2.2667e+00_r8,1.6999e+00_r8, &
     &1.1334e+00_r8,5.6671e-01_r8,3.9066e-02_r8/)
      kao(:, 3, 7,13) = (/ &
     &5.6378e+00_r8,4.9326e+00_r8,4.2280e+00_r8,3.5234e+00_r8,2.8189e+00_r8,2.1142e+00_r8, &
     &1.4094e+00_r8,7.0475e-01_r8,5.6679e-02_r8/)
      kao(:, 4, 7,13) = (/ &
     &6.8044e+00_r8,5.9541e+00_r8,5.1033e+00_r8,4.2525e+00_r8,3.4021e+00_r8,2.5518e+00_r8, &
     &1.7012e+00_r8,8.5062e-01_r8,7.8214e-02_r8/)
      kao(:, 5, 7,13) = (/ &
     &7.9748e+00_r8,6.9785e+00_r8,5.9814e+00_r8,4.9841e+00_r8,3.9872e+00_r8,2.9906e+00_r8, &
     &1.9939e+00_r8,9.9695e-01_r8,1.0573e-01_r8/)
      kao(:, 1, 8,13) = (/ &
     &7.0539e+00_r8,6.1726e+00_r8,5.2906e+00_r8,4.4088e+00_r8,3.5267e+00_r8,2.6453e+00_r8, &
     &1.7634e+00_r8,8.8179e-01_r8,2.1249e-02_r8/)
      kao(:, 2, 8,13) = (/ &
     &9.3702e+00_r8,8.1985e+00_r8,7.0273e+00_r8,5.8560e+00_r8,4.6849e+00_r8,3.5137e+00_r8, &
     &2.3424e+00_r8,1.1713e+00_r8,3.3095e-02_r8/)
      kao(:, 3, 8,13) = (/ &
     &1.1943e+01_r8,1.0450e+01_r8,8.9569e+00_r8,7.4646e+00_r8,5.9714e+00_r8,4.4785e+00_r8, &
     &2.9858e+00_r8,1.4929e+00_r8,4.9465e-02_r8/)
      kao(:, 4, 8,13) = (/ &
     &1.4646e+01_r8,1.2815e+01_r8,1.0984e+01_r8,9.1536e+00_r8,7.3228e+00_r8,5.4925e+00_r8, &
     &3.6616e+00_r8,1.8307e+00_r8,7.0099e-02_r8/)
      kao(:, 5, 8,13) = (/ &
     &1.7489e+01_r8,1.5303e+01_r8,1.3117e+01_r8,1.0930e+01_r8,8.7446e+00_r8,6.5589e+00_r8, &
     &4.3724e+00_r8,2.1863e+00_r8,9.5981e-02_r8/)
      kao(:, 1, 9,13) = (/ &
     &2.6371e+01_r8,2.3078e+01_r8,1.9780e+01_r8,1.6484e+01_r8,1.3187e+01_r8,9.8900e+00_r8, &
     &6.5930e+00_r8,3.2967e+00_r8,6.8943e-03_r8/)
      kao(:, 2, 9,13) = (/ &
     &3.6211e+01_r8,3.1684e+01_r8,2.7158e+01_r8,2.2631e+01_r8,1.8105e+01_r8,1.3579e+01_r8, &
     &9.0530e+00_r8,4.5262e+00_r8,1.7485e-02_r8/)
      kao(:, 3, 9,13) = (/ &
     &4.7281e+01_r8,4.1374e+01_r8,3.5462e+01_r8,2.9549e+01_r8,2.3642e+01_r8,1.7731e+01_r8, &
     &1.1820e+01_r8,5.9103e+00_r8,4.0011e-02_r8/)
      kao(:, 4, 9,13) = (/ &
     &5.9381e+01_r8,5.1957e+01_r8,4.4537e+01_r8,3.7114e+01_r8,2.9690e+01_r8,2.2267e+01_r8, &
     &1.4846e+01_r8,7.4229e+00_r8,6.1300e-02_r8/)
      kao(:, 5, 9,13) = (/ &
     &7.2474e+01_r8,6.3419e+01_r8,5.4356e+01_r8,4.5296e+01_r8,3.6239e+01_r8,2.7178e+01_r8, &
     &1.8119e+01_r8,9.0595e+00_r8,8.5682e-02_r8/)
      kao(:, 1,10,13) = (/ &
     &1.1184e+02_r8,9.7849e+01_r8,8.3875e+01_r8,6.9894e+01_r8,5.5915e+01_r8,4.1936e+01_r8, &
     &2.7957e+01_r8,1.3979e+01_r8,1.8093e-05_r8/)
      kao(:, 2,10,13) = (/ &
     &1.5816e+02_r8,1.3839e+02_r8,1.1862e+02_r8,9.8846e+01_r8,7.9081e+01_r8,5.9311e+01_r8, &
     &3.9538e+01_r8,1.9769e+01_r8,2.0368e-03_r8/)
      kao(:, 3,10,13) = (/ &
     &2.1176e+02_r8,1.8530e+02_r8,1.5882e+02_r8,1.3236e+02_r8,1.0588e+02_r8,7.9412e+01_r8, &
     &5.2940e+01_r8,2.6470e+01_r8,1.0379e-02_r8/)
      kao(:, 4,10,13) = (/ &
     &2.7234e+02_r8,2.3829e+02_r8,2.0425e+02_r8,1.7021e+02_r8,1.3616e+02_r8,1.0213e+02_r8, &
     &6.8082e+01_r8,3.4042e+01_r8,8.3550e-03_r8/)
      kao(:, 5,10,13) = (/ &
     &3.3838e+02_r8,2.9608e+02_r8,2.5378e+02_r8,2.1148e+02_r8,1.6919e+02_r8,1.2688e+02_r8, &
     &8.4588e+01_r8,4.2296e+01_r8,2.4237e-02_r8/)
      kao(:, 1,11,13) = (/ &
     &1.9607e+02_r8,1.7156e+02_r8,1.4706e+02_r8,1.2254e+02_r8,9.8035e+01_r8,7.3528e+01_r8, &
     &4.9019e+01_r8,2.4510e+01_r8,1.9563e-05_r8/)
      kao(:, 2,11,13) = (/ &
     &2.7783e+02_r8,2.4308e+02_r8,2.0836e+02_r8,1.7363e+02_r8,1.3891e+02_r8,1.0418e+02_r8, &
     &6.9451e+01_r8,3.4727e+01_r8,2.1737e-05_r8/)
      kao(:, 3,11,13) = (/ &
     &3.7392e+02_r8,3.2720e+02_r8,2.8047e+02_r8,2.3371e+02_r8,1.8697e+02_r8,1.4023e+02_r8, &
     &9.3485e+01_r8,4.6744e+01_r8,2.8098e-05_r8/)
      kao(:, 4,11,13) = (/ &
     &4.8258e+02_r8,4.2223e+02_r8,3.6194e+02_r8,3.0162e+02_r8,2.4128e+02_r8,1.8096e+02_r8, &
     &1.2064e+02_r8,6.0325e+01_r8,6.2823e-03_r8/)
      kao(:, 5,11,13) = (/ &
     &6.0149e+02_r8,5.2626e+02_r8,4.5111e+02_r8,3.7591e+02_r8,3.0076e+02_r8,2.2554e+02_r8, &
     &1.5037e+02_r8,7.5184e+01_r8,1.4409e-02_r8/)
      kao(:, 1,12,13) = (/ &
     &2.5475e+02_r8,2.2289e+02_r8,1.9106e+02_r8,1.5923e+02_r8,1.2737e+02_r8,9.5526e+01_r8, &
     &6.3684e+01_r8,3.1843e+01_r8,2.0642e-05_r8/)
      kao(:, 2,12,13) = (/ &
     &3.6233e+02_r8,3.1704e+02_r8,2.7175e+02_r8,2.2647e+02_r8,1.8117e+02_r8,1.3587e+02_r8, &
     &9.0584e+01_r8,4.5292e+01_r8,3.1983e-05_r8/)
      kao(:, 3,12,13) = (/ &
     &4.8916e+02_r8,4.2803e+02_r8,3.6684e+02_r8,3.0571e+02_r8,2.4456e+02_r8,1.8343e+02_r8, &
     &1.2228e+02_r8,6.1143e+01_r8,4.9821e-05_r8/)
      kao(:, 4,12,13) = (/ &
     &6.3314e+02_r8,5.5397e+02_r8,4.7487e+02_r8,3.9571e+02_r8,3.1654e+02_r8,2.3742e+02_r8, &
     &1.5828e+02_r8,7.9139e+01_r8,7.0156e-05_r8/)
      kao(:, 5,12,13) = (/ &
     &7.9128e+02_r8,6.9231e+02_r8,5.9347e+02_r8,4.9456e+02_r8,3.9565e+02_r8,2.9675e+02_r8, &
     &1.9782e+02_r8,9.8911e+01_r8,2.0440e-02_r8/)
      kao(:, 1,13,13) = (/ &
     &2.6423e+02_r8,2.3120e+02_r8,1.9817e+02_r8,1.6514e+02_r8,1.3211e+02_r8,9.9077e+01_r8, &
     &6.6055e+01_r8,3.3026e+01_r8,2.0316e-05_r8/)
      kao(:, 2,13,13) = (/ &
     &3.7762e+02_r8,3.3041e+02_r8,2.8322e+02_r8,2.3600e+02_r8,1.8882e+02_r8,1.4161e+02_r8, &
     &9.4405e+01_r8,4.7199e+01_r8,3.9220e-05_r8/)
      kao(:, 3,13,13) = (/ &
     &5.1221e+02_r8,4.4817e+02_r8,3.8414e+02_r8,3.2014e+02_r8,2.5611e+02_r8,1.9208e+02_r8, &
     &1.2806e+02_r8,6.4027e+01_r8,5.9611e-05_r8/)
      kao(:, 4,13,13) = (/ &
     &6.6615e+02_r8,5.8290e+02_r8,4.9961e+02_r8,4.1636e+02_r8,3.3309e+02_r8,2.4982e+02_r8, &
     &1.6655e+02_r8,8.3275e+01_r8,8.3600e-05_r8/)
      kao(:, 5,13,13) = (/ &
     &8.3847e+02_r8,7.3367e+02_r8,6.2884e+02_r8,5.2405e+02_r8,4.1925e+02_r8,3.1441e+02_r8, &
     &2.0962e+02_r8,1.0481e+02_r8,8.6814e-03_r8/)
      kao(:, 1, 1,14) = (/ &
     &1.4546e-01_r8,1.2729e-01_r8,1.0913e-01_r8,9.0969e-02_r8,7.2816e-02_r8,6.3783e-02_r8, &
     &5.7732e-02_r8,5.8710e-02_r8,8.0301e-02_r8/)
      kao(:, 2, 1,14) = (/ &
     &1.6927e-01_r8,1.4814e-01_r8,1.2702e-01_r8,1.0589e-01_r8,8.6710e-02_r8,8.1091e-02_r8, &
     &8.1369e-02_r8,8.2706e-02_r8,1.1649e-01_r8/)
      kao(:, 3, 1,14) = (/ &
     &1.9294e-01_r8,1.6889e-01_r8,1.4479e-01_r8,1.2072e-01_r8,1.0647e-01_r8,1.0625e-01_r8, &
     &1.1521e-01_r8,1.1490e-01_r8,1.6620e-01_r8/)
      kao(:, 4, 1,14) = (/ &
     &2.1639e-01_r8,1.8940e-01_r8,1.6240e-01_r8,1.3541e-01_r8,1.3447e-01_r8,1.4239e-01_r8, &
     &1.5920e-01_r8,1.5808e-01_r8,2.2919e-01_r8/)
      kao(:, 5, 1,14) = (/ &
     &2.3882e-01_r8,2.0905e-01_r8,1.7929e-01_r8,1.5673e-01_r8,1.6730e-01_r8,1.8853e-01_r8, &
     &2.1227e-01_r8,2.1249e-01_r8,3.0359e-01_r8/)
      kao(:, 1, 2,14) = (/ &
     &2.2939e-01_r8,2.0073e-01_r8,1.7206e-01_r8,1.4339e-01_r8,1.1475e-01_r8,8.6951e-02_r8, &
     &7.2184e-02_r8,6.3155e-02_r8,8.0463e-02_r8/)
      kao(:, 2, 2,14) = (/ &
     &2.6931e-01_r8,2.3569e-01_r8,2.0200e-01_r8,1.6840e-01_r8,1.3475e-01_r8,1.0880e-01_r8, &
     &9.2729e-02_r8,8.6720e-02_r8,1.1351e-01_r8/)
      kao(:, 3, 2,14) = (/ &
     &3.0958e-01_r8,2.7100e-01_r8,2.3236e-01_r8,1.9370e-01_r8,1.5506e-01_r8,1.3547e-01_r8, &
     &1.2355e-01_r8,1.2394e-01_r8,1.6330e-01_r8/)
      kao(:, 4, 2,14) = (/ &
     &3.5073e-01_r8,3.0694e-01_r8,2.6319e-01_r8,2.1943e-01_r8,1.7928e-01_r8,1.7126e-01_r8, &
     &1.6643e-01_r8,1.7360e-01_r8,2.2783e-01_r8/)
      kao(:, 5, 2,14) = (/ &
     &3.9134e-01_r8,3.4248e-01_r8,2.9368e-01_r8,2.4496e-01_r8,2.1593e-01_r8,2.1367e-01_r8, &
     &2.2253e-01_r8,2.3537e-01_r8,3.0544e-01_r8/)
      kao(:, 1, 3,14) = (/ &
     &4.7010e-01_r8,4.1135e-01_r8,3.5261e-01_r8,2.9387e-01_r8,2.3512e-01_r8,1.7638e-01_r8, &
     &1.1764e-01_r8,7.8616e-02_r8,7.6241e-02_r8/)
      kao(:, 2, 3,14) = (/ &
     &5.6247e-01_r8,4.9221e-01_r8,4.2195e-01_r8,3.5165e-01_r8,2.8136e-01_r8,2.1111e-01_r8, &
     &1.4480e-01_r8,1.0039e-01_r8,1.0523e-01_r8/)
      kao(:, 3, 3,14) = (/ &
     &6.5749e-01_r8,5.7537e-01_r8,4.9319e-01_r8,4.1105e-01_r8,3.2895e-01_r8,2.4684e-01_r8, &
     &1.7889e-01_r8,1.3157e-01_r8,1.4752e-01_r8/)
      kao(:, 4, 3,14) = (/ &
     &7.5292e-01_r8,6.5895e-01_r8,5.6476e-01_r8,4.7081e-01_r8,3.7678e-01_r8,2.8272e-01_r8, &
     &2.2206e-01_r8,1.7756e-01_r8,2.0769e-01_r8/)
      kao(:, 5, 3,14) = (/ &
     &8.4721e-01_r8,7.4147e-01_r8,6.3570e-01_r8,5.2989e-01_r8,4.2402e-01_r8,3.2414e-01_r8, &
     &2.7831e-01_r8,2.3784e-01_r8,2.8406e-01_r8/)
      kao(:, 1, 4,14) = (/ &
     &9.7171e-01_r8,8.5020e-01_r8,7.2877e-01_r8,6.0734e-01_r8,4.8590e-01_r8,3.6445e-01_r8, &
     &2.4301e-01_r8,1.2213e-01_r8,6.9724e-02_r8/)
      kao(:, 2, 4,14) = (/ &
     &1.1819e+00_r8,1.0342e+00_r8,8.8647e-01_r8,7.3863e-01_r8,5.9101e-01_r8,4.4338e-01_r8, &
     &2.9560e-01_r8,1.5522e-01_r8,9.6103e-02_r8/)
      kao(:, 3, 4,14) = (/ &
     &1.3997e+00_r8,1.2249e+00_r8,1.0500e+00_r8,8.7515e-01_r8,7.0004e-01_r8,5.2502e-01_r8, &
     &3.5022e-01_r8,1.9543e-01_r8,1.3302e-01_r8/)
      kao(:, 4, 4,14) = (/ &
     &1.6223e+00_r8,1.4197e+00_r8,1.2167e+00_r8,1.0141e+00_r8,8.1148e-01_r8,6.0893e-01_r8, &
     &4.0620e-01_r8,2.4484e-01_r8,1.8472e-01_r8/)
      kao(:, 5, 4,14) = (/ &
     &1.8526e+00_r8,1.6213e+00_r8,1.3899e+00_r8,1.1585e+00_r8,9.2711e-01_r8,6.9563e-01_r8, &
     &4.6462e-01_r8,3.0719e-01_r8,2.5304e-01_r8/)
      kao(:, 1, 5,14) = (/ &
     &1.8192e+00_r8,1.5916e+00_r8,1.3645e+00_r8,1.1369e+00_r8,9.0965e-01_r8,6.8222e-01_r8, &
     &4.5478e-01_r8,2.2743e-01_r8,6.1385e-02_r8/)
      kao(:, 2, 5,14) = (/ &
     &2.2491e+00_r8,1.9677e+00_r8,1.6869e+00_r8,1.4056e+00_r8,1.1246e+00_r8,8.4332e-01_r8, &
     &5.6233e-01_r8,2.8119e-01_r8,8.6006e-02_r8/)
      kao(:, 3, 5,14) = (/ &
     &2.7102e+00_r8,2.3722e+00_r8,2.0328e+00_r8,1.6939e+00_r8,1.3553e+00_r8,1.0165e+00_r8, &
     &6.7791e-01_r8,3.3919e-01_r8,1.2062e-01_r8/)
      kao(:, 4, 5,14) = (/ &
     &3.1976e+00_r8,2.7982e+00_r8,2.3984e+00_r8,1.9988e+00_r8,1.5996e+00_r8,1.1997e+00_r8, &
     &8.0003e-01_r8,4.0180e-01_r8,1.6649e-01_r8/)
      kao(:, 5, 5,14) = (/ &
     &3.6973e+00_r8,3.2349e+00_r8,2.7730e+00_r8,2.3110e+00_r8,1.8489e+00_r8,1.3873e+00_r8, &
     &9.2506e-01_r8,4.7326e-01_r8,2.2654e-01_r8/)
      kao(:, 1, 6,14) = (/ &
     &3.1019e+00_r8,2.7140e+00_r8,2.3265e+00_r8,1.9387e+00_r8,1.5510e+00_r8,1.1633e+00_r8, &
     &7.7552e-01_r8,3.8777e-01_r8,5.2928e-02_r8/)
      kao(:, 2, 6,14) = (/ &
     &3.9302e+00_r8,3.4386e+00_r8,2.9473e+00_r8,2.4561e+00_r8,1.9652e+00_r8,1.4738e+00_r8, &
     &9.8267e-01_r8,4.9148e-01_r8,7.5058e-02_r8/)
      kao(:, 3, 6,14) = (/ &
     &4.8343e+00_r8,4.2298e+00_r8,3.6258e+00_r8,3.0217e+00_r8,2.4174e+00_r8,1.8133e+00_r8, &
     &1.2090e+00_r8,6.0467e-01_r8,1.0698e-01_r8/)
      kao(:, 4, 6,14) = (/ &
     &5.7912e+00_r8,5.0677e+00_r8,4.3433e+00_r8,3.6195e+00_r8,2.8961e+00_r8,2.1723e+00_r8, &
     &1.4483e+00_r8,7.2440e-01_r8,1.4901e-01_r8/)
      kao(:, 5, 6,14) = (/ &
     &6.7811e+00_r8,5.9338e+00_r8,5.0864e+00_r8,4.2388e+00_r8,3.3910e+00_r8,2.5430e+00_r8, &
     &1.6957e+00_r8,8.4831e-01_r8,2.0161e-01_r8/)
      kao(:, 1, 7,14) = (/ &
     &5.4638e+00_r8,4.7799e+00_r8,4.0972e+00_r8,3.4147e+00_r8,2.7314e+00_r8,2.0488e+00_r8, &
     &1.3659e+00_r8,6.8294e-01_r8,4.5673e-02_r8/)
      kao(:, 2, 7,14) = (/ &
     &7.1063e+00_r8,6.2177e+00_r8,5.3292e+00_r8,4.4410e+00_r8,3.5530e+00_r8,2.6647e+00_r8, &
     &1.7765e+00_r8,8.8835e-01_r8,6.5608e-02_r8/)
      kao(:, 3, 7,14) = (/ &
     &8.9165e+00_r8,7.8008e+00_r8,6.6867e+00_r8,5.5727e+00_r8,4.4582e+00_r8,3.3435e+00_r8, &
     &2.2293e+00_r8,1.1147e+00_r8,9.3558e-02_r8/)
      kao(:, 4, 7,14) = (/ &
     &1.0858e+01_r8,9.5015e+00_r8,8.1441e+00_r8,6.7868e+00_r8,5.4291e+00_r8,4.0729e+00_r8, &
     &2.7150e+00_r8,1.3577e+00_r8,1.3310e-01_r8/)
      kao(:, 5, 7,14) = (/ &
     &1.2930e+01_r8,1.1317e+01_r8,9.6983e+00_r8,8.0819e+00_r8,6.4667e+00_r8,4.8496e+00_r8, &
     &3.2333e+00_r8,1.6168e+00_r8,1.8236e-01_r8/)
      kao(:, 1, 8,14) = (/ &
     &1.1346e+01_r8,9.9283e+00_r8,8.5084e+00_r8,7.0912e+00_r8,5.6732e+00_r8,4.2544e+00_r8, &
     &2.8362e+00_r8,1.4181e+00_r8,3.9157e-02_r8/)
      kao(:, 2, 8,14) = (/ &
     &1.5150e+01_r8,1.3257e+01_r8,1.1363e+01_r8,9.4692e+00_r8,7.5753e+00_r8,5.6816e+00_r8, &
     &3.7878e+00_r8,1.8940e+00_r8,5.7302e-02_r8/)
      kao(:, 3, 8,14) = (/ &
     &1.9415e+01_r8,1.6989e+01_r8,1.4562e+01_r8,1.2134e+01_r8,9.7069e+00_r8,7.2806e+00_r8, &
     &4.8539e+00_r8,2.4270e+00_r8,8.2333e-02_r8/)
      kao(:, 4, 8,14) = (/ &
     &2.4092e+01_r8,2.1079e+01_r8,1.8070e+01_r8,1.5059e+01_r8,1.2046e+01_r8,9.0355e+00_r8, &
     &6.0239e+00_r8,3.0117e+00_r8,1.1787e-01_r8/)
      kao(:, 5, 8,14) = (/ &
     &2.9062e+01_r8,2.5429e+01_r8,2.1796e+01_r8,1.8164e+01_r8,1.4531e+01_r8,1.0899e+01_r8, &
     &7.2663e+00_r8,3.6329e+00_r8,1.6482e-01_r8/)
      kao(:, 1, 9,14) = (/ &
     &4.3556e+01_r8,3.8120e+01_r8,3.2674e+01_r8,2.7224e+01_r8,2.1783e+01_r8,1.6334e+01_r8, &
     &1.0888e+01_r8,5.4440e+00_r8,2.2652e-02_r8/)
      kao(:, 2, 9,14) = (/ &
     &5.9826e+01_r8,5.2350e+01_r8,4.4870e+01_r8,3.7394e+01_r8,2.9916e+01_r8,2.2436e+01_r8, &
     &1.4957e+01_r8,7.4785e+00_r8,4.6893e-02_r8/)
      kao(:, 3, 9,14) = (/ &
     &7.8381e+01_r8,6.8585e+01_r8,5.8789e+01_r8,4.8993e+01_r8,3.9194e+01_r8,2.9396e+01_r8, &
     &1.9597e+01_r8,9.7990e+00_r8,7.2210e-02_r8/)
      kao(:, 4, 9,14) = (/ &
     &9.9048e+01_r8,8.6676e+01_r8,7.4294e+01_r8,6.1915e+01_r8,4.9526e+01_r8,3.7147e+01_r8, &
     &2.4767e+01_r8,1.2383e+01_r8,1.0452e-01_r8/)
      kao(:, 5, 9,14) = (/ &
     &1.2130e+02_r8,1.0614e+02_r8,9.0980e+01_r8,7.5818e+01_r8,6.0656e+01_r8,4.5493e+01_r8, &
     &3.0327e+01_r8,1.5163e+01_r8,1.4798e-01_r8/)
      kao(:, 1,10,14) = (/ &
     &1.8821e+02_r8,1.6469e+02_r8,1.4116e+02_r8,1.1763e+02_r8,9.4105e+01_r8,7.0580e+01_r8, &
     &4.7054e+01_r8,2.3527e+01_r8,9.8284e-06_r8/)
      kao(:, 2,10,14) = (/ &
     &2.6476e+02_r8,2.3166e+02_r8,1.9858e+02_r8,1.6548e+02_r8,1.3239e+02_r8,9.9294e+01_r8, &
     &6.6189e+01_r8,3.3094e+01_r8,1.2967e-05_r8/)
      kao(:, 3,10,14) = (/ &
     &3.5496e+02_r8,3.1059e+02_r8,2.6621e+02_r8,2.2185e+02_r8,1.7748e+02_r8,1.3310e+02_r8, &
     &8.8736e+01_r8,4.4370e+01_r8,2.4344e-02_r8/)
      kao(:, 4,10,14) = (/ &
     &4.5706e+02_r8,3.9992e+02_r8,3.4280e+02_r8,2.8566e+02_r8,2.2852e+02_r8,1.7137e+02_r8, &
     &1.1427e+02_r8,5.7136e+01_r8,2.2864e-02_r8/)
      kao(:, 5,10,14) = (/ &
     &5.6918e+02_r8,4.9801e+02_r8,4.2687e+02_r8,3.5573e+02_r8,2.8459e+02_r8,2.1346e+02_r8, &
     &1.4231e+02_r8,7.1148e+01_r8,3.1037e-02_r8/)
      kao(:, 1,11,14) = (/ &
     &3.3285e+02_r8,2.9123e+02_r8,2.4962e+02_r8,2.0803e+02_r8,1.6643e+02_r8,1.2482e+02_r8, &
     &8.3209e+01_r8,4.1605e+01_r8,7.6787e-06_r8/)
      kao(:, 2,11,14) = (/ &
     &4.7091e+02_r8,4.1207e+02_r8,3.5320e+02_r8,2.9434e+02_r8,2.3549e+02_r8,1.7660e+02_r8, &
     &1.1774e+02_r8,5.8871e+01_r8,1.2053e-05_r8/)
      kao(:, 3,11,14) = (/ &
     &6.3434e+02_r8,5.5505e+02_r8,4.7579e+02_r8,3.9648e+02_r8,3.1719e+02_r8,2.3787e+02_r8, &
     &1.5859e+02_r8,7.9298e+01_r8,1.7979e-05_r8/)
      kao(:, 4,11,14) = (/ &
     &8.2080e+02_r8,7.1819e+02_r8,6.1562e+02_r8,5.1300e+02_r8,4.1039e+02_r8,3.0781e+02_r8, &
     &2.0518e+02_r8,1.0261e+02_r8,2.6043e-05_r8/)
      kao(:, 5,11,14) = (/ &
     &1.0279e+03_r8,8.9936e+02_r8,7.7089e+02_r8,6.4243e+02_r8,5.1399e+02_r8,3.8545e+02_r8, &
     &2.5700e+02_r8,1.2849e+02_r8,3.6811e-02_r8/)
      kao(:, 1,12,14) = (/ &
     &4.4072e+02_r8,3.8565e+02_r8,3.3056e+02_r8,2.7546e+02_r8,2.2036e+02_r8,1.6527e+02_r8, &
     &1.1018e+02_r8,5.5100e+01_r8,6.3836e-06_r8/)
      kao(:, 2,12,14) = (/ &
     &6.2804e+02_r8,5.4949e+02_r8,4.7103e+02_r8,3.9252e+02_r8,3.1400e+02_r8,2.3550e+02_r8, &
     &1.5700e+02_r8,7.8501e+01_r8,1.0354e-05_r8/)
      kao(:, 3,12,14) = (/ &
     &8.4964e+02_r8,7.4346e+02_r8,6.3726e+02_r8,5.3106e+02_r8,4.2484e+02_r8,3.1862e+02_r8, &
     &2.1241e+02_r8,1.0621e+02_r8,1.6673e-05_r8/)
      kao(:, 4,12,14) = (/ &
     &1.1033e+03_r8,9.6532e+02_r8,8.2745e+02_r8,6.8953e+02_r8,5.5162e+02_r8,4.1376e+02_r8, &
     &2.7582e+02_r8,1.3790e+02_r8,2.5500e-05_r8/)
      kao(:, 5,12,14) = (/ &
     &1.3847e+03_r8,1.2117e+03_r8,1.0386e+03_r8,8.6544e+02_r8,6.9241e+02_r8,5.1925e+02_r8, &
     &3.4620e+02_r8,1.7310e+02_r8,3.8579e-05_r8/)
      kao(:, 1,13,14) = (/ &
     &4.7310e+02_r8,4.1397e+02_r8,3.5483e+02_r8,2.9569e+02_r8,2.3655e+02_r8,1.7741e+02_r8, &
     &1.1827e+02_r8,5.9135e+01_r8,7.3062e-06_r8/)
      kao(:, 2,13,14) = (/ &
     &6.7569e+02_r8,5.9130e+02_r8,5.0679e+02_r8,4.2232e+02_r8,3.3786e+02_r8,2.5340e+02_r8, &
     &1.6892e+02_r8,8.4465e+01_r8,8.6740e-06_r8/)
      kao(:, 3,13,14) = (/ &
     &9.1788e+02_r8,8.0315e+02_r8,6.8841e+02_r8,5.7369e+02_r8,4.5893e+02_r8,3.4424e+02_r8, &
     &2.2946e+02_r8,1.1474e+02_r8,1.3663e-05_r8/)
      kao(:, 4,13,14) = (/ &
     &1.1975e+03_r8,1.0479e+03_r8,8.9816e+02_r8,7.4843e+02_r8,5.9874e+02_r8,4.4905e+02_r8, &
     &2.9938e+02_r8,1.4969e+02_r8,2.1412e-05_r8/)
      kao(:, 5,13,14) = (/ &
     &1.5101e+03_r8,1.3214e+03_r8,1.1326e+03_r8,9.4376e+02_r8,7.5504e+02_r8,5.6626e+02_r8, &
     &3.7752e+02_r8,1.8876e+02_r8,3.3615e-05_r8/)
      kao(:, 1, 1,15) = (/ &
     &1.9051e-01_r8,1.6674e-01_r8,1.4292e-01_r8,1.1918e-01_r8,9.5396e-02_r8,7.5613e-02_r8, &
     &8.0457e-02_r8,7.8890e-02_r8,1.1694e-01_r8/)
      kao(:, 2, 1,15) = (/ &
     &2.2168e-01_r8,1.9400e-01_r8,1.6634e-01_r8,1.3865e-01_r8,1.1100e-01_r8,1.0009e-01_r8, &
     &1.1113e-01_r8,1.0913e-01_r8,1.6166e-01_r8/)
      kao(:, 3, 1,15) = (/ &
     &2.5284e-01_r8,2.2130e-01_r8,1.8975e-01_r8,1.5816e-01_r8,1.2778e-01_r8,1.3319e-01_r8, &
     &1.4805e-01_r8,1.4559e-01_r8,2.1625e-01_r8/)
      kao(:, 4, 1,15) = (/ &
     &2.8343e-01_r8,2.4807e-01_r8,2.1270e-01_r8,1.7731e-01_r8,1.5213e-01_r8,1.7480e-01_r8, &
     &1.9314e-01_r8,1.8830e-01_r8,2.8691e-01_r8/)
      kao(:, 5, 1,15) = (/ &
     &3.1350e-01_r8,2.7439e-01_r8,2.3527e-01_r8,1.9622e-01_r8,1.9594e-01_r8,2.3135e-01_r8, &
     &2.5307e-01_r8,2.4156e-01_r8,3.8082e-01_r8/)
      kao(:, 1, 2,15) = (/ &
     &3.2111e-01_r8,2.8102e-01_r8,2.4090e-01_r8,2.0079e-01_r8,1.6069e-01_r8,1.2054e-01_r8, &
     &9.0034e-02_r8,8.9831e-02_r8,1.2243e-01_r8/)
      kao(:, 2, 2,15) = (/ &
     &3.7636e-01_r8,3.2926e-01_r8,2.8226e-01_r8,2.3534e-01_r8,1.8831e-01_r8,1.4126e-01_r8, &
     &1.2281e-01_r8,1.2620e-01_r8,1.7187e-01_r8/)
      kao(:, 3, 2,15) = (/ &
     &4.3275e-01_r8,3.7860e-01_r8,3.2463e-01_r8,2.7055e-01_r8,2.1650e-01_r8,1.6706e-01_r8, &
     &1.6578e-01_r8,1.7060e-01_r8,2.3384e-01_r8/)
      kao(:, 4, 2,15) = (/ &
     &4.8952e-01_r8,4.2824e-01_r8,3.6725e-01_r8,3.0597e-01_r8,2.4488e-01_r8,2.0300e-01_r8, &
     &2.2012e-01_r8,2.2396e-01_r8,3.1375e-01_r8/)
      kao(:, 5, 2,15) = (/ &
     &5.4581e-01_r8,4.7748e-01_r8,4.0943e-01_r8,3.4119e-01_r8,2.7312e-01_r8,2.6005e-01_r8, &
     &2.9166e-01_r8,2.9212e-01_r8,4.1866e-01_r8/)
      kao(:, 1, 3,15) = (/ &
     &6.9979e-01_r8,6.1213e-01_r8,5.2483e-01_r8,4.3719e-01_r8,3.4984e-01_r8,2.6243e-01_r8, &
     &1.7501e-01_r8,9.9676e-02_r8,1.1688e-01_r8/)
      kao(:, 2, 3,15) = (/ &
     &8.3387e-01_r8,7.2959e-01_r8,6.2545e-01_r8,5.2112e-01_r8,4.1694e-01_r8,3.1278e-01_r8, &
     &2.0862e-01_r8,1.3660e-01_r8,1.6827e-01_r8/)
      kao(:, 3, 3,15) = (/ &
     &9.7266e-01_r8,8.5098e-01_r8,7.2958e-01_r8,6.0802e-01_r8,4.8655e-01_r8,3.6492e-01_r8, &
     &2.4335e-01_r8,1.8790e-01_r8,2.3450e-01_r8/)
      kao(:, 4, 3,15) = (/ &
     &1.1134e+00_r8,9.7421e-01_r8,8.3530e-01_r8,6.9606e-01_r8,5.5697e-01_r8,4.1779e-01_r8, &
     &2.8251e-01_r8,2.5378e-01_r8,3.2011e-01_r8/)
      kao(:, 5, 3,15) = (/ &
     &1.2541e+00_r8,1.0974e+00_r8,9.4084e-01_r8,7.8396e-01_r8,6.2738e-01_r8,4.7061e-01_r8, &
     &3.3812e-01_r8,3.3805e-01_r8,4.3341e-01_r8/)
      kao(:, 1, 4,15) = (/ &
     &1.5338e+00_r8,1.3422e+00_r8,1.1503e+00_r8,9.5870e-01_r8,7.6686e-01_r8,5.7527e-01_r8, &
     &3.8351e-01_r8,1.9180e-01_r8,1.0723e-01_r8/)
      kao(:, 2, 4,15) = (/ &
     &1.8631e+00_r8,1.6302e+00_r8,1.3974e+00_r8,1.1644e+00_r8,9.3180e-01_r8,6.9872e-01_r8, &
     &4.6589e-01_r8,2.3301e-01_r8,1.5610e-01_r8/)
      kao(:, 3, 4,15) = (/ &
     &2.2077e+00_r8,1.9315e+00_r8,1.6557e+00_r8,1.3803e+00_r8,1.1039e+00_r8,8.2801e-01_r8, &
     &5.5191e-01_r8,2.7612e-01_r8,2.2377e-01_r8/)
      kao(:, 4, 4,15) = (/ &
     &2.5609e+00_r8,2.2407e+00_r8,1.9209e+00_r8,1.6005e+00_r8,1.2804e+00_r8,9.6050e-01_r8, &
     &6.4039e-01_r8,3.2615e-01_r8,3.1195e-01_r8/)
      kao(:, 5, 4,15) = (/ &
     &2.9154e+00_r8,2.5514e+00_r8,2.1867e+00_r8,1.8223e+00_r8,1.4581e+00_r8,1.0937e+00_r8, &
     &7.2913e-01_r8,3.9607e-01_r8,4.2846e-01_r8/)
      kao(:, 1, 5,15) = (/ &
     &3.0736e+00_r8,2.6896e+00_r8,2.3057e+00_r8,1.9212e+00_r8,1.5370e+00_r8,1.1527e+00_r8, &
     &7.6854e-01_r8,3.8431e-01_r8,1.0147e-01_r8/)
      kao(:, 2, 5,15) = (/ &
     &3.8075e+00_r8,3.3314e+00_r8,2.8555e+00_r8,2.3797e+00_r8,1.9037e+00_r8,1.4279e+00_r8, &
     &9.5192e-01_r8,4.7599e-01_r8,1.4471e-01_r8/)
      kao(:, 3, 5,15) = (/ &
     &4.5849e+00_r8,4.0117e+00_r8,3.4370e+00_r8,2.8652e+00_r8,2.2919e+00_r8,1.7190e+00_r8, &
     &1.1462e+00_r8,5.7315e-01_r8,2.0749e-01_r8/)
      kao(:, 4, 5,15) = (/ &
     &5.3872e+00_r8,4.7143e+00_r8,4.0418e+00_r8,3.3672e+00_r8,2.6939e+00_r8,2.0205e+00_r8, &
     &1.3469e+00_r8,6.7361e-01_r8,2.9614e-01_r8/)
      kao(:, 5, 5,15) = (/ &
     &6.2028e+00_r8,5.4263e+00_r8,4.6517e+00_r8,3.8766e+00_r8,3.1014e+00_r8,2.3260e+00_r8, &
     &1.5507e+00_r8,7.7527e-01_r8,4.1447e-01_r8/)
      kao(:, 1, 6,15) = (/ &
     &5.6666e+00_r8,4.9583e+00_r8,4.2496e+00_r8,3.5417e+00_r8,2.8332e+00_r8,2.1246e+00_r8, &
     &1.4165e+00_r8,7.0837e-01_r8,9.5689e-02_r8/)
      kao(:, 2, 6,15) = (/ &
     &7.1702e+00_r8,6.2735e+00_r8,5.3788e+00_r8,4.4810e+00_r8,3.5859e+00_r8,2.6888e+00_r8, &
     &1.7925e+00_r8,8.9634e-01_r8,1.3582e-01_r8/)
      kao(:, 3, 6,15) = (/ &
     &8.7850e+00_r8,7.6873e+00_r8,6.5880e+00_r8,5.4902e+00_r8,4.3923e+00_r8,3.2943e+00_r8, &
     &2.1960e+00_r8,1.0981e+00_r8,1.9014e-01_r8/)
      kao(:, 4, 6,15) = (/ &
     &1.0471e+01_r8,9.1623e+00_r8,7.8537e+00_r8,6.5443e+00_r8,5.2362e+00_r8,3.9265e+00_r8, &
     &2.6173e+00_r8,1.3091e+00_r8,2.7084e-01_r8/)
      kao(:, 5, 6,15) = (/ &
     &1.2195e+01_r8,1.0670e+01_r8,9.1465e+00_r8,7.6219e+00_r8,6.0976e+00_r8,4.5729e+00_r8, &
     &3.0483e+00_r8,1.5247e+00_r8,3.8788e-01_r8/)
      kao(:, 1, 7,15) = (/ &
     &1.0821e+01_r8,9.4694e+00_r8,8.1159e+00_r8,6.7641e+00_r8,5.4109e+00_r8,4.0578e+00_r8, &
     &2.7049e+00_r8,1.3527e+00_r8,8.8090e-02_r8/)
      kao(:, 2, 7,15) = (/ &
     &1.4005e+01_r8,1.2256e+01_r8,1.0505e+01_r8,8.7544e+00_r8,7.0039e+00_r8,5.2527e+00_r8, &
     &3.5019e+00_r8,1.7510e+00_r8,1.2836e-01_r8/)
      kao(:, 3, 7,15) = (/ &
     &1.7472e+01_r8,1.5288e+01_r8,1.3104e+01_r8,1.0920e+01_r8,8.7370e+00_r8,6.5526e+00_r8, &
     &4.3682e+00_r8,2.1842e+00_r8,1.7912e-01_r8/)
      kao(:, 4, 7,15) = (/ &
     &2.1133e+01_r8,1.8491e+01_r8,1.5850e+01_r8,1.3209e+01_r8,1.0568e+01_r8,7.9265e+00_r8, &
     &5.2835e+00_r8,2.6416e+00_r8,2.4968e-01_r8/)
      kao(:, 5, 7,15) = (/ &
     &2.4946e+01_r8,2.1829e+01_r8,1.8712e+01_r8,1.5594e+01_r8,1.2475e+01_r8,9.3563e+00_r8, &
     &6.2369e+00_r8,3.1183e+00_r8,3.5418e-01_r8/)
      kao(:, 1, 8,15) = (/ &
     &2.4402e+01_r8,2.1362e+01_r8,1.8302e+01_r8,1.5253e+01_r8,1.2203e+01_r8,9.1488e+00_r8, &
     &6.1012e+00_r8,3.0503e+00_r8,8.0172e-02_r8/)
      kao(:, 2, 8,15) = (/ &
     &3.2338e+01_r8,2.8299e+01_r8,2.4254e+01_r8,2.0211e+01_r8,1.6168e+01_r8,1.2127e+01_r8, &
     &8.0850e+00_r8,4.0423e+00_r8,1.1917e-01_r8/)
      kao(:, 3, 8,15) = (/ &
     &4.1117e+01_r8,3.5977e+01_r8,3.0837e+01_r8,2.5703e+01_r8,2.0563e+01_r8,1.5418e+01_r8, &
     &1.0280e+01_r8,5.1397e+00_r8,1.6937e-01_r8/)
      kao(:, 4, 8,15) = (/ &
     &5.0705e+01_r8,4.4368e+01_r8,3.8026e+01_r8,3.1698e+01_r8,2.5350e+01_r8,1.9014e+01_r8, &
     &1.2673e+01_r8,6.3384e+00_r8,2.3470e-01_r8/)
      kao(:, 5, 8,15) = (/ &
     &6.0900e+01_r8,5.3282e+01_r8,4.5673e+01_r8,3.8064e+01_r8,3.0449e+01_r8,2.2835e+01_r8, &
     &1.5224e+01_r8,7.6126e+00_r8,3.2704e-01_r8/)
      kao(:, 1, 9,15) = (/ &
     &1.0170e+02_r8,8.8996e+01_r8,7.6286e+01_r8,6.3569e+01_r8,5.0854e+01_r8,3.8145e+01_r8, &
     &2.5429e+01_r8,1.2713e+01_r8,7.1359e-02_r8/)
      kao(:, 2, 9,15) = (/ &
     &1.3845e+02_r8,1.2114e+02_r8,1.0384e+02_r8,8.6532e+01_r8,6.9224e+01_r8,5.1921e+01_r8, &
     &3.4611e+01_r8,1.7307e+01_r8,1.0767e-01_r8/)
      kao(:, 3, 9,15) = (/ &
     &1.8073e+02_r8,1.5810e+02_r8,1.3551e+02_r8,1.1293e+02_r8,9.0345e+01_r8,6.7755e+01_r8, &
     &4.5176e+01_r8,2.2583e+01_r8,1.5849e-01_r8/)
      kao(:, 4, 9,15) = (/ &
     &2.2745e+02_r8,1.9903e+02_r8,1.7061e+02_r8,1.4217e+02_r8,1.1373e+02_r8,8.5301e+01_r8, &
     &5.6875e+01_r8,2.8433e+01_r8,2.2030e-01_r8/)
      kao(:, 5, 9,15) = (/ &
     &2.7773e+02_r8,2.4298e+02_r8,2.0829e+02_r8,1.7358e+02_r8,1.3886e+02_r8,1.0414e+02_r8, &
     &6.9430e+01_r8,3.4715e+01_r8,3.0575e-01_r8/)
      kao(:, 1,10,15) = (/ &
     &4.7674e+02_r8,4.1715e+02_r8,3.5753e+02_r8,2.9794e+02_r8,2.3835e+02_r8,1.7878e+02_r8, &
     &1.1918e+02_r8,5.9592e+01_r8,7.9888e-06_r8/)
      kao(:, 2,10,15) = (/ &
     &6.6856e+02_r8,5.8521e+02_r8,5.0164e+02_r8,4.1786e+02_r8,3.3435e+02_r8,2.5071e+02_r8, &
     &1.6719e+02_r8,8.3597e+01_r8,1.0572e-05_r8/)
      kao(:, 3,10,15) = (/ &
     &8.9281e+02_r8,7.8118e+02_r8,6.6956e+02_r8,5.5797e+02_r8,4.4639e+02_r8,3.3479e+02_r8, &
     &2.2318e+02_r8,1.1160e+02_r8,1.3235e-05_r8/)
      kao(:, 4,10,15) = (/ &
     &1.1439e+03_r8,1.0009e+03_r8,8.5793e+02_r8,7.1497e+02_r8,5.7192e+02_r8,4.2885e+02_r8, &
     &2.8596e+02_r8,1.4299e+02_r8,7.9928e-02_r8/)
      kao(:, 5,10,15) = (/ &
     &1.4160e+03_r8,1.2390e+03_r8,1.0620e+03_r8,8.8492e+02_r8,7.0798e+02_r8,5.3098e+02_r8, &
     &3.5397e+02_r8,1.7699e+02_r8,2.0557e-01_r8/)
      kao(:, 1,11,15) = (/ &
     &9.1777e+02_r8,8.0296e+02_r8,6.8835e+02_r8,5.7354e+02_r8,4.5882e+02_r8,3.4414e+02_r8, &
     &2.2941e+02_r8,1.1472e+02_r8,9.0079e-06_r8/)
      kao(:, 2,11,15) = (/ &
     &1.2897e+03_r8,1.1284e+03_r8,9.6718e+02_r8,8.0605e+02_r8,6.4484e+02_r8,4.8368e+02_r8, &
     &3.2242e+02_r8,1.6120e+02_r8,1.0534e-05_r8/)
      kao(:, 3,11,15) = (/ &
     &1.7217e+03_r8,1.5064e+03_r8,1.2912e+03_r8,1.0761e+03_r8,8.6072e+02_r8,6.4564e+02_r8, &
     &4.3042e+02_r8,2.1520e+02_r8,1.2890e-05_r8/)
      kao(:, 4,11,15) = (/ &
     &2.2030e+03_r8,1.9276e+03_r8,1.6522e+03_r8,1.3769e+03_r8,1.1015e+03_r8,8.2614e+02_r8, &
     &5.5075e+02_r8,2.7537e+02_r8,1.8773e-05_r8/)
      kao(:, 5,11,15) = (/ &
     &2.7288e+03_r8,2.3877e+03_r8,2.0468e+03_r8,1.7056e+03_r8,1.3645e+03_r8,1.0232e+03_r8, &
     &6.8218e+02_r8,3.4109e+02_r8,2.8192e-05_r8/)
      kao(:, 1,12,15) = (/ &
     &1.3049e+03_r8,1.1418e+03_r8,9.7855e+02_r8,8.1546e+02_r8,6.5249e+02_r8,4.8934e+02_r8, &
     &3.2625e+02_r8,1.6311e+02_r8,7.4201e-06_r8/)
      kao(:, 2,12,15) = (/ &
     &1.8314e+03_r8,1.6024e+03_r8,1.3735e+03_r8,1.1446e+03_r8,9.1569e+02_r8,6.8677e+02_r8, &
     &4.5789e+02_r8,2.2893e+02_r8,9.0712e-06_r8/)
      kao(:, 3,12,15) = (/ &
     &2.4447e+03_r8,2.1390e+03_r8,1.8335e+03_r8,1.5279e+03_r8,1.2222e+03_r8,9.1674e+02_r8, &
     &6.1121e+02_r8,3.0557e+02_r8,9.2932e-06_r8/)
      kao(:, 4,12,15) = (/ &
     &3.1395e+03_r8,2.7470e+03_r8,2.3545e+03_r8,1.9622e+03_r8,1.5697e+03_r8,1.1774e+03_r8, &
     &7.8488e+02_r8,3.9241e+02_r8,1.2651e-05_r8/)
      kao(:, 5,12,15) = (/ &
     &3.8988e+03_r8,3.4115e+03_r8,2.9243e+03_r8,2.4367e+03_r8,1.9495e+03_r8,1.4621e+03_r8, &
     &9.7464e+02_r8,4.8737e+02_r8,2.0431e-05_r8/)
      kao(:, 1,13,15) = (/ &
     &1.4703e+03_r8,1.2867e+03_r8,1.1028e+03_r8,9.1904e+02_r8,7.3532e+02_r8,5.5150e+02_r8, &
     &3.6759e+02_r8,1.8380e+02_r8,5.1458e-06_r8/)
      kao(:, 2,13,15) = (/ &
     &2.0704e+03_r8,1.8115e+03_r8,1.5528e+03_r8,1.2939e+03_r8,1.0351e+03_r8,7.7638e+02_r8, &
     &5.1765e+02_r8,2.5875e+02_r8,6.1867e-06_r8/)
      kao(:, 3,13,15) = (/ &
     &2.7739e+03_r8,2.4272e+03_r8,2.0805e+03_r8,1.7336e+03_r8,1.3869e+03_r8,1.0403e+03_r8, &
     &6.9356e+02_r8,3.4674e+02_r8,7.7061e-06_r8/)
      kao(:, 4,13,15) = (/ &
     &3.5658e+03_r8,3.1198e+03_r8,2.6740e+03_r8,2.2287e+03_r8,1.7830e+03_r8,1.3371e+03_r8, &
     &8.9142e+02_r8,4.4572e+02_r8,1.1573e-05_r8/)
      kao(:, 5,13,15) = (/ &
     &4.4270e+03_r8,3.8738e+03_r8,3.3205e+03_r8,2.7670e+03_r8,2.2135e+03_r8,1.6602e+03_r8, &
     &1.1068e+03_r8,5.5337e+02_r8,1.8919e-05_r8/)
      kao(:, 1, 1,16) = (/ &
     &2.0584e-01_r8,1.8014e-01_r8,1.5444e-01_r8,1.2874e-01_r8,1.0304e-01_r8,7.7345e-02_r8, &
     &8.4273e-02_r8,8.1561e-02_r8,1.2397e-01_r8/)
      kao(:, 2, 1,16) = (/ &
     &2.4103e-01_r8,2.1093e-01_r8,1.8085e-01_r8,1.5075e-01_r8,1.2067e-01_r8,1.0583e-01_r8, &
     &1.1670e-01_r8,1.1303e-01_r8,1.7190e-01_r8/)
      kao(:, 3, 1,16) = (/ &
     &2.7664e-01_r8,2.4213e-01_r8,2.0759e-01_r8,1.7305e-01_r8,1.3852e-01_r8,1.4127e-01_r8, &
     &1.5588e-01_r8,1.5105e-01_r8,2.2980e-01_r8/)
      kao(:, 4, 1,16) = (/ &
     &3.1217e-01_r8,2.7321e-01_r8,2.3426e-01_r8,1.9529e-01_r8,1.5635e-01_r8,1.8285e-01_r8, &
     &2.0187e-01_r8,1.9571e-01_r8,2.9781e-01_r8/)
      kao(:, 5, 1,16) = (/ &
     &3.4704e-01_r8,3.0374e-01_r8,2.6044e-01_r8,2.1712e-01_r8,2.0704e-01_r8,2.4179e-01_r8, &
     &2.6249e-01_r8,2.4688e-01_r8,4.0744e-01_r8/)
      kao(:, 1, 2,16) = (/ &
     &3.5775e-01_r8,3.1302e-01_r8,2.6832e-01_r8,2.2363e-01_r8,1.7894e-01_r8,1.3423e-01_r8, &
     &9.4199e-02_r8,9.5152e-02_r8,1.3347e-01_r8/)
      kao(:, 2, 2,16) = (/ &
     &4.2272e-01_r8,3.6993e-01_r8,3.1710e-01_r8,2.6431e-01_r8,2.1146e-01_r8,1.5866e-01_r8, &
     &1.3268e-01_r8,1.3412e-01_r8,1.8823e-01_r8/)
      kao(:, 3, 2,16) = (/ &
     &4.8911e-01_r8,4.2798e-01_r8,3.6687e-01_r8,3.0577e-01_r8,2.4466e-01_r8,1.8360e-01_r8, &
     &1.7978e-01_r8,1.8185e-01_r8,2.5529e-01_r8/)
      kao(:, 4, 2,16) = (/ &
     &5.5559e-01_r8,4.8623e-01_r8,4.1679e-01_r8,3.4735e-01_r8,2.7796e-01_r8,2.0932e-01_r8, &
     &2.3570e-01_r8,2.3853e-01_r8,3.3493e-01_r8/)
      kao(:, 5, 2,16) = (/ &
     &6.2130e-01_r8,5.4374e-01_r8,4.6609e-01_r8,3.8845e-01_r8,3.1090e-01_r8,2.6998e-01_r8, &
     &3.0230e-01_r8,3.0412e-01_r8,4.4787e-01_r8/)
      kao(:, 1, 3,16) = (/ &
     &8.0759e-01_r8,7.0655e-01_r8,6.0564e-01_r8,5.0473e-01_r8,4.0382e-01_r8,3.0291e-01_r8, &
     &2.0195e-01_r8,1.0457e-01_r8,1.3240e-01_r8/)
      kao(:, 2, 3,16) = (/ &
     &9.6833e-01_r8,8.4737e-01_r8,7.2636e-01_r8,6.0527e-01_r8,4.8421e-01_r8,3.6321e-01_r8, &
     &2.4220e-01_r8,1.5138e-01_r8,1.9184e-01_r8/)
      kao(:, 3, 3,16) = (/ &
     &1.1342e+00_r8,9.9245e-01_r8,8.5072e-01_r8,7.0903e-01_r8,5.6727e-01_r8,4.2548e-01_r8, &
     &2.8373e-01_r8,2.0993e-01_r8,2.6621e-01_r8/)
      kao(:, 4, 3,16) = (/ &
     &1.3024e+00_r8,1.1395e+00_r8,9.7685e-01_r8,8.1409e-01_r8,6.5126e-01_r8,4.8855e-01_r8, &
     &3.2575e-01_r8,2.8072e-01_r8,3.5605e-01_r8/)
      kao(:, 5, 3,16) = (/ &
     &1.4698e+00_r8,1.2860e+00_r8,1.1024e+00_r8,9.1880e-01_r8,7.3505e-01_r8,5.5132e-01_r8, &
     &3.6767e-01_r8,3.6382e-01_r8,4.6256e-01_r8/)
      kao(:, 1, 4,16) = (/ &
     &1.8354e+00_r8,1.6059e+00_r8,1.3766e+00_r8,1.1471e+00_r8,9.1770e-01_r8,6.8825e-01_r8, &
     &4.5887e-01_r8,2.2948e-01_r8,1.2512e-01_r8/)
      kao(:, 2, 4,16) = (/ &
     &2.2391e+00_r8,1.9593e+00_r8,1.6796e+00_r8,1.3998e+00_r8,1.1197e+00_r8,8.3982e-01_r8, &
     &5.5988e-01_r8,2.7997e-01_r8,1.8724e-01_r8/)
      kao(:, 3, 4,16) = (/ &
     &2.6616e+00_r8,2.3290e+00_r8,1.9963e+00_r8,1.6635e+00_r8,1.3310e+00_r8,9.9835e-01_r8, &
     &6.6551e-01_r8,3.3282e-01_r8,2.6695e-01_r8/)
      kao(:, 4, 4,16) = (/ &
     &3.0942e+00_r8,2.7077e+00_r8,2.3212e+00_r8,1.9341e+00_r8,1.5474e+00_r8,1.1605e+00_r8, &
     &7.7373e-01_r8,3.8698e-01_r8,3.6534e-01_r8/)
      kao(:, 5, 4,16) = (/ &
     &3.5299e+00_r8,3.0886e+00_r8,2.6475e+00_r8,2.2065e+00_r8,1.7650e+00_r8,1.3239e+00_r8, &
     &8.8260e-01_r8,4.4141e-01_r8,4.8300e-01_r8/)
      kao(:, 1, 5,16) = (/ &
     &3.8226e+00_r8,3.3446e+00_r8,2.8509e+00_r8,2.3892e+00_r8,1.9114e+00_r8,1.4335e+00_r8, &
     &9.5565e-01_r8,4.7787e-01_r8,1.1560e-01_r8/)
      kao(:, 2, 5,16) = (/ &
     &4.7529e+00_r8,4.1589e+00_r8,3.5644e+00_r8,2.9706e+00_r8,2.3763e+00_r8,1.7823e+00_r8, &
     &1.1883e+00_r8,5.9413e-01_r8,1.7922e-01_r8/)
      kao(:, 3, 5,16) = (/ &
     &5.7385e+00_r8,5.0213e+00_r8,4.3040e+00_r8,3.5869e+00_r8,2.8697e+00_r8,2.1522e+00_r8, &
     &1.4347e+00_r8,7.1742e-01_r8,2.6311e-01_r8/)
      kao(:, 4, 5,16) = (/ &
     &6.7615e+00_r8,5.9164e+00_r8,5.0713e+00_r8,4.2261e+00_r8,3.3806e+00_r8,2.5357e+00_r8, &
     &1.6905e+00_r8,8.4524e-01_r8,3.6914e-01_r8/)
      kao(:, 5, 5,16) = (/ &
     &7.8020e+00_r8,6.8269e+00_r8,5.8507e+00_r8,4.8765e+00_r8,3.9008e+00_r8,2.9261e+00_r8, &
     &1.9507e+00_r8,9.7534e-01_r8,4.9832e-01_r8/)
      kao(:, 1, 6,16) = (/ &
     &7.3571e+00_r8,6.4369e+00_r8,5.5172e+00_r8,4.5985e+00_r8,3.6783e+00_r8,2.7589e+00_r8, &
     &1.8291e+00_r8,9.1965e-01_r8,1.0645e-01_r8/)
      kao(:, 2, 6,16) = (/ &
     &9.3468e+00_r8,8.1778e+00_r8,7.0095e+00_r8,5.8414e+00_r8,4.6732e+00_r8,3.5051e+00_r8, &
     &2.3366e+00_r8,1.1682e+00_r8,1.6617e-01_r8/)
      kao(:, 3, 6,16) = (/ &
     &1.1491e+01_r8,1.0055e+01_r8,8.6175e+00_r8,7.1820e+00_r8,5.7127e+00_r8,4.3090e+00_r8, &
     &2.8724e+00_r8,1.4282e+00_r8,2.5233e-01_r8/)
      kao(:, 4, 6,16) = (/ &
     &1.3744e+01_r8,1.2025e+01_r8,1.0308e+01_r8,8.5898e+00_r8,6.8725e+00_r8,5.1546e+00_r8, &
     &3.4361e+00_r8,1.7180e+00_r8,3.6410e-01_r8/)
      kao(:, 5, 6,16) = (/ &
     &1.6063e+01_r8,1.4056e+01_r8,1.2048e+01_r8,1.0040e+01_r8,8.0325e+00_r8,6.0238e+00_r8, &
     &4.0162e+00_r8,2.0081e+00_r8,5.0340e-01_r8/)
      kao(:, 1, 7,16) = (/ &
     &1.4766e+01_r8,1.2923e+01_r8,1.1075e+01_r8,9.2294e+00_r8,7.3836e+00_r8,5.5378e+00_r8, &
     &3.6915e+00_r8,1.8460e+00_r8,1.0988e-01_r8/)
      kao(:, 2, 7,16) = (/ &
     &1.9210e+01_r8,1.6809e+01_r8,1.4406e+01_r8,1.2004e+01_r8,9.6049e+00_r8,7.2040e+00_r8, &
     &4.8023e+00_r8,2.4010e+00_r8,1.5119e-01_r8/)
      kao(:, 3, 7,16) = (/ &
     &2.4080e+01_r8,2.1071e+01_r8,1.8060e+01_r8,1.5050e+01_r8,1.2042e+01_r8,9.0305e+00_r8, &
     &6.0199e+00_r8,2.9934e+00_r8,2.3822e-01_r8/)
      kao(:, 4, 7,16) = (/ &
     &2.9278e+01_r8,2.5619e+01_r8,2.1957e+01_r8,1.8300e+01_r8,1.4640e+01_r8,1.0980e+01_r8, &
     &7.3208e+00_r8,3.6596e+00_r8,3.5444e-01_r8/)
      kao(:, 5, 7,16) = (/ &
     &3.4690e+01_r8,3.0352e+01_r8,2.6017e+01_r8,2.1683e+01_r8,1.7349e+01_r8,1.3009e+01_r8, &
     &8.6734e+00_r8,4.3366e+00_r8,5.0281e-01_r8/)
      kao(:, 1, 8,16) = (/ &
     &3.5305e+01_r8,3.0898e+01_r8,2.6479e+01_r8,2.2066e+01_r8,1.7653e+01_r8,1.3237e+01_r8, &
     &8.8267e+00_r8,4.4136e+00_r8,1.1225e-01_r8/)
      kao(:, 2, 8,16) = (/ &
     &4.7105e+01_r8,4.1217e+01_r8,3.5327e+01_r8,2.9443e+01_r8,2.3551e+01_r8,1.7664e+01_r8, &
     &1.1776e+01_r8,5.8880e+00_r8,1.4909e-01_r8/)
      kao(:, 3, 8,16) = (/ &
     &6.0289e+01_r8,5.2760e+01_r8,4.5222e+01_r8,3.7680e+01_r8,3.0141e+01_r8,2.2609e+01_r8, &
     &1.5075e+01_r8,7.5364e+00_r8,2.2235e-01_r8/)
      kao(:, 4, 8,16) = (/ &
     &7.4572e+01_r8,6.4882e+01_r8,5.5930e+01_r8,4.6614e+01_r8,3.7287e+01_r8,2.7965e+01_r8, &
     &1.8642e+01_r8,9.3209e+00_r8,3.4182e-01_r8/)
      kao(:, 5, 8,16) = (/ &
     &8.9645e+01_r8,7.8444e+01_r8,6.7227e+01_r8,5.6021e+01_r8,4.4815e+01_r8,3.3612e+01_r8, &
     &2.2408e+01_r8,1.1205e+01_r8,4.9824e-01_r8/)
      kao(:, 1, 9,16) = (/ &
     &1.5759e+02_r8,1.3788e+02_r8,1.1817e+02_r8,9.8475e+01_r8,7.8796e+01_r8,5.9083e+01_r8, &
     &3.9390e+01_r8,1.9699e+01_r8,1.1304e-01_r8/)
      kao(:, 2, 9,16) = (/ &
     &2.1616e+02_r8,1.8914e+02_r8,1.6212e+02_r8,1.3510e+02_r8,1.0808e+02_r8,8.1068e+01_r8, &
     &5.4043e+01_r8,2.7021e+01_r8,1.5445e-01_r8/)
      kao(:, 3, 9,16) = (/ &
     &2.8258e+02_r8,2.4760e+02_r8,2.1223e+02_r8,1.7686e+02_r8,1.4149e+02_r8,1.0611e+02_r8, &
     &7.0744e+01_r8,3.5373e+01_r8,2.0441e-01_r8/)
      kao(:, 4, 9,16) = (/ &
     &3.5653e+02_r8,3.1192e+02_r8,2.6735e+02_r8,2.2280e+02_r8,1.7825e+02_r8,1.3369e+02_r8, &
     &8.9123e+01_r8,4.4565e+01_r8,3.2503e-01_r8/)
      kao(:, 5, 9,16) = (/ &
     &4.3513e+02_r8,3.8075e+02_r8,3.2632e+02_r8,2.7197e+02_r8,2.1754e+02_r8,1.6316e+02_r8, &
     &1.0877e+02_r8,5.4390e+01_r8,4.8785e-01_r8/)
      kao(:, 1,10,16) = (/ &
     &7.9828e+02_r8,6.9859e+02_r8,5.9871e+02_r8,4.9899e+02_r8,3.9914e+02_r8,2.9935e+02_r8, &
     &1.9957e+02_r8,9.9786e+01_r8,1.4112e-06_r8/)
      kao(:, 2,10,16) = (/ &
     &1.1235e+03_r8,9.8329e+02_r8,8.4282e+02_r8,7.0236e+02_r8,5.6188e+02_r8,4.2131e+02_r8, &
     &2.8094e+02_r8,1.4047e+02_r8,1.8812e-06_r8/)
      kao(:, 3,10,16) = (/ &
     &1.5014e+03_r8,1.3138e+03_r8,1.1261e+03_r8,9.3840e+02_r8,7.5072e+02_r8,5.6311e+02_r8, &
     &3.7536e+02_r8,1.8771e+02_r8,2.5472e-06_r8/)
      kao(:, 4,10,16) = (/ &
     &1.9233e+03_r8,1.6832e+03_r8,1.4427e+03_r8,1.2020e+03_r8,9.6160e+02_r8,7.2135e+02_r8, &
     &4.8081e+02_r8,2.4039e+02_r8,3.1592e-01_r8/)
      kao(:, 5,10,16) = (/ &
     &2.3793e+03_r8,2.0824e+03_r8,1.7849e+03_r8,1.4876e+03_r8,1.1900e+03_r8,8.9243e+02_r8, &
     &5.9503e+02_r8,2.9747e+02_r8,4.8703e-01_r8/)
      kao(:, 1,11,16) = (/ &
     &1.6695e+03_r8,1.4608e+03_r8,1.2521e+03_r8,1.0434e+03_r8,8.3472e+02_r8,6.2605e+02_r8, &
     &4.1737e+02_r8,2.0867e+02_r8,1.1529e-06_r8/)
      kao(:, 2,11,16) = (/ &
     &2.3476e+03_r8,2.0540e+03_r8,1.7608e+03_r8,1.4673e+03_r8,1.1739e+03_r8,8.8029e+02_r8, &
     &5.8691e+02_r8,2.9349e+02_r8,1.5382e-06_r8/)
      kao(:, 3,11,16) = (/ &
     &3.1326e+03_r8,2.7416e+03_r8,2.3500e+03_r8,1.9579e+03_r8,1.5664e+03_r8,1.1749e+03_r8, &
     &7.8334e+02_r8,3.9162e+02_r8,2.0823e-06_r8/)
      kao(:, 4,11,16) = (/ &
     &4.0087e+03_r8,3.5076e+03_r8,3.0065e+03_r8,2.5054e+03_r8,2.0043e+03_r8,1.5033e+03_r8, &
     &1.0022e+03_r8,5.0110e+02_r8,2.4008e-06_r8/)
      kao(:, 5,11,16) = (/ &
     &4.9540e+03_r8,4.3346e+03_r8,3.7151e+03_r8,3.0963e+03_r8,2.4766e+03_r8,1.8577e+03_r8, &
     &1.2385e+03_r8,6.1917e+02_r8,1.3302e-05_r8/)
      kao(:, 1,12,16) = (/ &
     &2.5940e+03_r8,2.2689e+03_r8,1.9455e+03_r8,1.6210e+03_r8,1.2970e+03_r8,9.7271e+02_r8, &
     &6.4849e+02_r8,3.2418e+02_r8,9.4397e-07_r8/)
      kao(:, 2,12,16) = (/ &
     &3.6401e+03_r8,3.1850e+03_r8,2.7301e+03_r8,2.2751e+03_r8,1.8200e+03_r8,1.3650e+03_r8, &
     &9.1001e+02_r8,4.5497e+02_r8,1.2594e-06_r8/)
      kao(:, 3,12,16) = (/ &
     &4.8482e+03_r8,4.2436e+03_r8,3.6368e+03_r8,3.0301e+03_r8,2.4250e+03_r8,1.8187e+03_r8, &
     &1.2120e+03_r8,6.0606e+02_r8,1.2513e-05_r8/)
      kao(:, 4,12,16) = (/ &
     &6.1914e+03_r8,5.4187e+03_r8,4.6435e+03_r8,3.8696e+03_r8,3.0964e+03_r8,2.3220e+03_r8, &
     &1.5479e+03_r8,7.7403e+02_r8,2.0845e-05_r8/)
      kao(:, 5,12,16) = (/ &
     &7.6366e+03_r8,6.6419e+03_r8,5.7257e+03_r8,4.7728e+03_r8,3.8188e+03_r8,2.8637e+03_r8, &
     &1.9092e+03_r8,9.4962e+02_r8,2.1463e-05_r8/)
      kao(:, 1,13,16) = (/ &
     &3.2192e+03_r8,2.8160e+03_r8,2.4141e+03_r8,2.0117e+03_r8,1.6091e+03_r8,1.2070e+03_r8, &
     &8.0460e+02_r8,4.0235e+02_r8,2.5866e-06_r8/)
      kao(:, 2,13,16) = (/ &
     &4.5059e+03_r8,3.9428e+03_r8,3.3791e+03_r8,2.8160e+03_r8,2.2531e+03_r8,1.6897e+03_r8, &
     &1.1264e+03_r8,5.6328e+02_r8,9.4719e-06_r8/)
      kao(:, 3,13,16) = (/ &
     &5.9881e+03_r8,5.2388e+03_r8,4.4907e+03_r8,3.7423e+03_r8,2.9935e+03_r8,2.2450e+03_r8, &
     &1.4968e+03_r8,7.4841e+02_r8,1.6561e-05_r8/)
      kao(:, 4,13,16) = (/ &
     &7.6265e+03_r8,6.6729e+03_r8,5.7200e+03_r8,4.7671e+03_r8,3.8133e+03_r8,2.8600e+03_r8, &
     &1.9066e+03_r8,9.4757e+02_r8,2.1537e-05_r8/)
      kao(:, 5,13,16) = (/ &
     &9.3827e+03_r8,8.2086e+03_r8,7.0366e+03_r8,5.8639e+03_r8,4.6917e+03_r8,3.5181e+03_r8, &
     &2.3456e+03_r8,1.1729e+03_r8,2.1283e-05_r8/)

!     The array KBO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels  < ~100mb, temperatures, and ratios
!     of H2O to CO2.  The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amount ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 
!     to that of gas2.  The second index, JT, which
!     runs from 1 to 5, corresponds to different temperatures.  More 
!     specifically, JT = 3 means that the data are for the corresponding 
!     reference temperature TREF for this  pressure level, JT = 2 refers 
!     to the TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and
!     JT = 5 is for TREF+30.  The third index, JP, runs from 13 to 59 and
!     refers to the corresponding pressure level in PREF (e.g. JP = 13 is
!     for a pressure of 95.5835 mb).  The fourth index, IG, goes from 1 to
!     16, and tells us which g-interval the absorption coefficients are for.

      kbo(:, 1,13, 1) = (/ &
     &1.5731e-03_r8,1.8696e-03_r8,1.8486e-03_r8,1.7186e-03_r8,1.3898e-03_r8/)
      kbo(:, 2,13, 1) = (/ &
     &1.8623e-03_r8,2.3963e-03_r8,2.4362e-03_r8,2.2990e-03_r8,1.8223e-03_r8/)
      kbo(:, 3,13, 1) = (/ &
     &2.3718e-03_r8,3.1878e-03_r8,3.2540e-03_r8,3.0430e-03_r8,2.2915e-03_r8/)
      kbo(:, 4,13, 1) = (/ &
     &3.1921e-03_r8,4.3104e-03_r8,4.3590e-03_r8,3.9821e-03_r8,2.7709e-03_r8/)
      kbo(:, 5,13, 1) = (/ &
     &4.4313e-03_r8,5.8691e-03_r8,5.8118e-03_r8,5.1528e-03_r8,3.2426e-03_r8/)
      kbo(:, 1,14, 1) = (/ &
     &8.1496e-04_r8,1.1449e-03_r8,1.2521e-03_r8,1.2864e-03_r8,1.1830e-03_r8/)
      kbo(:, 2,14, 1) = (/ &
     &9.7291e-04_r8,1.4990e-03_r8,1.6700e-03_r8,1.7215e-03_r8,1.5434e-03_r8/)
      kbo(:, 3,14, 1) = (/ &
     &1.2487e-03_r8,2.0089e-03_r8,2.2296e-03_r8,2.2624e-03_r8,1.9289e-03_r8/)
      kbo(:, 4,14, 1) = (/ &
     &1.6881e-03_r8,2.7166e-03_r8,2.9639e-03_r8,2.9248e-03_r8,2.3207e-03_r8/)
      kbo(:, 5,14, 1) = (/ &
     &2.3524e-03_r8,3.6802e-03_r8,3.9082e-03_r8,3.7262e-03_r8,2.7008e-03_r8/)
      kbo(:, 1,15, 1) = (/ &
     &4.3177e-04_r8,7.4258e-04_r8,8.9651e-04_r8,1.0013e-03_r8,1.0098e-03_r8/)
      kbo(:, 2,15, 1) = (/ &
     &5.2028e-04_r8,9.8643e-04_r8,1.2013e-03_r8,1.3351e-03_r8,1.3087e-03_r8/)
      kbo(:, 3,15, 1) = (/ &
     &6.7289e-04_r8,1.3258e-03_r8,1.5978e-03_r8,1.7375e-03_r8,1.6233e-03_r8/)
      kbo(:, 4,15, 1) = (/ &
     &9.1389e-04_r8,1.7863e-03_r8,2.1013e-03_r8,2.2138e-03_r8,1.9402e-03_r8/)
      kbo(:, 5,15, 1) = (/ &
     &1.2783e-03_r8,2.4005e-03_r8,2.7322e-03_r8,2.7722e-03_r8,2.2422e-03_r8/)
      kbo(:, 1,16, 1) = (/ &
     &2.7315e-04_r8,5.4830e-04_r8,7.0218e-04_r8,8.1997e-04_r8,8.6240e-04_r8/)
      kbo(:, 2,16, 1) = (/ &
     &3.3240e-04_r8,7.3351e-04_r8,9.4112e-04_r8,1.0872e-03_r8,1.1098e-03_r8/)
      kbo(:, 3,16, 1) = (/ &
     &4.3314e-04_r8,9.8584e-04_r8,1.2457e-03_r8,1.4034e-03_r8,1.3664e-03_r8/)
      kbo(:, 4,16, 1) = (/ &
     &5.9092e-04_r8,1.3229e-03_r8,1.6223e-03_r8,1.7684e-03_r8,1.6211e-03_r8/)
      kbo(:, 5,16, 1) = (/ &
     &8.2878e-04_r8,1.7642e-03_r8,2.0878e-03_r8,2.1890e-03_r8,1.8647e-03_r8/)
      kbo(:, 1,17, 1) = (/ &
     &1.7965e-04_r8,4.1801e-04_r8,5.6155e-04_r8,6.7756e-04_r8,7.3362e-04_r8/)
      kbo(:, 2,17, 1) = (/ &
     &2.2058e-04_r8,5.6121e-04_r8,7.5064e-04_r8,8.9254e-04_r8,9.3681e-04_r8/)
      kbo(:, 3,17, 1) = (/ &
     &2.8939e-04_r8,7.5257e-04_r8,9.8597e-04_r8,1.1419e-03_r8,1.1452e-03_r8/)
      kbo(:, 4,17, 1) = (/ &
     &3.9639e-04_r8,1.0037e-03_r8,1.2718e-03_r8,1.4256e-03_r8,1.3514e-03_r8/)
      kbo(:, 5,17, 1) = (/ &
     &5.5678e-04_r8,1.3263e-03_r8,1.6209e-03_r8,1.7480e-03_r8,1.5479e-03_r8/)
      kbo(:, 1,18, 1) = (/ &
     &1.2144e-04_r8,3.2556e-04_r8,4.5465e-04_r8,5.6224e-04_r8,6.2157e-04_r8/)
      kbo(:, 2,18, 1) = (/ &
     &1.5036e-04_r8,4.3710e-04_r8,6.0499e-04_r8,7.3530e-04_r8,7.8763e-04_r8/)
      kbo(:, 3,18, 1) = (/ &
     &1.9855e-04_r8,5.8365e-04_r8,7.8791e-04_r8,9.3325e-04_r8,9.5745e-04_r8/)
      kbo(:, 4,18, 1) = (/ &
     &2.7288e-04_r8,7.7253e-04_r8,1.0079e-03_r8,1.1563e-03_r8,1.1247e-03_r8/)
      kbo(:, 5,18, 1) = (/ &
     &3.8348e-04_r8,1.0128e-03_r8,1.2724e-03_r8,1.4068e-03_r8,1.2838e-03_r8/)
      kbo(:, 1,19, 1) = (/ &
     &8.0908e-05_r8,2.5355e-04_r8,3.6780e-04_r8,4.6534e-04_r8,5.2420e-04_r8/)
      kbo(:, 2,19, 1) = (/ &
     &1.0097e-04_r8,3.3963e-04_r8,4.8637e-04_r8,6.0408e-04_r8,6.5997e-04_r8/)
      kbo(:, 3,19, 1) = (/ &
     &1.3403e-04_r8,4.5064e-04_r8,6.2806e-04_r8,7.6126e-04_r8,7.9854e-04_r8/)
      kbo(:, 4,19, 1) = (/ &
     &1.8471e-04_r8,5.9188e-04_r8,7.9637e-04_r8,9.3587e-04_r8,9.3436e-04_r8/)
      kbo(:, 5,19, 1) = (/ &
     &2.5970e-04_r8,7.6935e-04_r8,9.9605e-04_r8,1.1301e-03_r8,1.0631e-03_r8/)
      kbo(:, 1,20, 1) = (/ &
     &5.8651e-05_r8,2.0533e-04_r8,3.0468e-04_r8,3.8991e-04_r8,4.4299e-04_r8/)
      kbo(:, 2,20, 1) = (/ &
     &7.3858e-05_r8,2.7425e-04_r8,4.0056e-04_r8,5.0325e-04_r8,5.5439e-04_r8/)
      kbo(:, 3,20, 1) = (/ &
     &9.8558e-05_r8,3.6201e-04_r8,5.1389e-04_r8,6.3043e-04_r8,6.6745e-04_r8/)
      kbo(:, 4,20, 1) = (/ &
     &1.3624e-04_r8,4.7289e-04_r8,6.4732e-04_r8,7.7044e-04_r8,7.7770e-04_r8/)
      kbo(:, 5,20, 1) = (/ &
     &1.9168e-04_r8,6.1111e-04_r8,8.0443e-04_r8,9.2550e-04_r8,8.8213e-04_r8/)
      kbo(:, 1,21, 1) = (/ &
     &4.3969e-05_r8,1.6839e-04_r8,2.5404e-04_r8,3.2750e-04_r8,3.7386e-04_r8/)
      kbo(:, 2,21, 1) = (/ &
     &5.5807e-05_r8,2.2425e-04_r8,3.3214e-04_r8,4.2065e-04_r8,4.6519e-04_r8/)
      kbo(:, 3,21, 1) = (/ &
     &7.4871e-05_r8,2.9470e-04_r8,4.2375e-04_r8,5.2400e-04_r8,5.5744e-04_r8/)
      kbo(:, 4,21, 1) = (/ &
     &1.0381e-04_r8,3.8330e-04_r8,5.3089e-04_r8,6.3750e-04_r8,6.4727e-04_r8/)
      kbo(:, 5,21, 1) = (/ &
     &1.4611e-04_r8,4.9243e-04_r8,6.5637e-04_r8,7.6218e-04_r8,7.3199e-04_r8/)
      kbo(:, 1,22, 1) = (/ &
     &3.4337e-05_r8,1.4203e-04_r8,2.1658e-04_r8,2.8040e-04_r8,3.2005e-04_r8/)
      kbo(:, 2,22, 1) = (/ &
     &4.4095e-05_r8,1.8845e-04_r8,2.8132e-04_r8,3.5774e-04_r8,3.9514e-04_r8/)
      kbo(:, 3,22, 1) = (/ &
     &5.9627e-05_r8,2.4659e-04_r8,3.5661e-04_r8,4.4266e-04_r8,4.7049e-04_r8/)
      kbo(:, 4,22, 1) = (/ &
     &8.3001e-05_r8,3.1905e-04_r8,4.4430e-04_r8,5.3537e-04_r8,5.4306e-04_r8/)
      kbo(:, 5,22, 1) = (/ &
     &1.1688e-04_r8,4.0732e-04_r8,5.4669e-04_r8,6.3703e-04_r8,6.1162e-04_r8/)
      kbo(:, 1,23, 1) = (/ &
     &2.7088e-05_r8,1.2024e-04_r8,1.8486e-04_r8,2.4028e-04_r8,2.7381e-04_r8/)
      kbo(:, 2,23, 1) = (/ &
     &3.5182e-05_r8,1.5885e-04_r8,2.3849e-04_r8,3.0423e-04_r8,3.3547e-04_r8/)
      kbo(:, 3,23, 1) = (/ &
     &4.7910e-05_r8,2.0687e-04_r8,3.0043e-04_r8,3.7399e-04_r8,3.9686e-04_r8/)
      kbo(:, 4,23, 1) = (/ &
     &6.6975e-05_r8,2.6613e-04_r8,3.7259e-04_r8,4.4994e-04_r8,4.5570e-04_r8/)
      kbo(:, 5,23, 1) = (/ &
     &9.4305e-05_r8,3.3770e-04_r8,4.5596e-04_r8,5.3292e-04_r8,5.1097e-04_r8/)
      kbo(:, 1,24, 1) = (/ &
     &2.1382e-05_r8,1.0191e-04_r8,1.5778e-04_r8,2.0583e-04_r8,2.3424e-04_r8/)
      kbo(:, 2,24, 1) = (/ &
     &2.8085e-05_r8,1.3391e-04_r8,2.0214e-04_r8,2.5863e-04_r8,2.8484e-04_r8/)
      kbo(:, 3,24, 1) = (/ &
     &3.8505e-05_r8,1.7343e-04_r8,2.5313e-04_r8,3.1592e-04_r8,3.3477e-04_r8/)
      kbo(:, 4,24, 1) = (/ &
     &5.3997e-05_r8,2.2171e-04_r8,3.1228e-04_r8,3.7804e-04_r8,3.8231e-04_r8/)
      kbo(:, 5,24, 1) = (/ &
     &7.5953e-05_r8,2.7966e-04_r8,3.7978e-04_r8,4.4568e-04_r8,4.2681e-04_r8/)
      kbo(:, 1,25, 1) = (/ &
     &1.7217e-05_r8,8.6935e-05_r8,1.3520e-04_r8,1.7667e-04_r8,2.0051e-04_r8/)
      kbo(:, 2,25, 1) = (/ &
     &2.2860e-05_r8,1.1361e-04_r8,1.7201e-04_r8,2.2028e-04_r8,2.4198e-04_r8/)
      kbo(:, 3,25, 1) = (/ &
     &3.1540e-05_r8,1.4632e-04_r8,2.1426e-04_r8,2.6745e-04_r8,2.8247e-04_r8/)
      kbo(:, 4,25, 1) = (/ &
     &4.4330e-05_r8,1.8594e-04_r8,2.6272e-04_r8,3.1846e-04_r8,3.2089e-04_r8/)
      kbo(:, 5,25, 1) = (/ &
     &6.2260e-05_r8,2.3327e-04_r8,3.1770e-04_r8,3.7373e-04_r8,3.5666e-04_r8/)
      kbo(:, 1,26, 1) = (/ &
     &1.4222e-05_r8,7.4853e-05_r8,1.1659e-04_r8,1.5229e-04_r8,1.7205e-04_r8/)
      kbo(:, 2,26, 1) = (/ &
     &1.9097e-05_r8,9.7290e-05_r8,1.4733e-04_r8,1.8840e-04_r8,2.0595e-04_r8/)
      kbo(:, 3,26, 1) = (/ &
     &2.6498e-05_r8,1.2462e-04_r8,1.8247e-04_r8,2.2740e-04_r8,2.3871e-04_r8/)
      kbo(:, 4,26, 1) = (/ &
     &3.7304e-05_r8,1.5749e-04_r8,2.2244e-04_r8,2.6950e-04_r8,2.6966e-04_r8/)
      kbo(:, 5,26, 1) = (/ &
     &5.2263e-05_r8,1.9669e-04_r8,2.6764e-04_r8,3.1472e-04_r8,2.9848e-04_r8/)
      kbo(:, 1,27, 1) = (/ &
     &1.2263e-05_r8,6.5144e-05_r8,1.0108e-04_r8,1.3156e-04_r8,1.4744e-04_r8/)
      kbo(:, 2,27, 1) = (/ &
     &1.6644e-05_r8,8.4290e-05_r8,1.2696e-04_r8,1.6163e-04_r8,1.7509e-04_r8/)
      kbo(:, 3,27, 1) = (/ &
     &2.3202e-05_r8,1.0755e-04_r8,1.5651e-04_r8,1.9419e-04_r8,2.0159e-04_r8/)
      kbo(:, 4,27, 1) = (/ &
     &3.2669e-05_r8,1.3540e-04_r8,1.9003e-04_r8,2.2917e-04_r8,2.2657e-04_r8/)
      kbo(:, 5,27, 1) = (/ &
     &4.5636e-05_r8,1.6849e-04_r8,2.2778e-04_r8,2.6648e-04_r8,2.4966e-04_r8/)
      kbo(:, 1,28, 1) = (/ &
     &1.0907e-05_r8,5.7118e-05_r8,8.7946e-05_r8,1.1378e-04_r8,1.2622e-04_r8/)
      kbo(:, 2,28, 1) = (/ &
     &1.4925e-05_r8,7.3661e-05_r8,1.0996e-04_r8,1.3907e-04_r8,1.4872e-04_r8/)
      kbo(:, 3,28, 1) = (/ &
     &2.0909e-05_r8,9.3671e-05_r8,1.3497e-04_r8,1.6629e-04_r8,1.7014e-04_r8/)
      kbo(:, 4,28, 1) = (/ &
     &2.9425e-05_r8,1.1761e-04_r8,1.6330e-04_r8,1.9540e-04_r8,1.9022e-04_r8/)
      kbo(:, 5,28, 1) = (/ &
     &4.0966e-05_r8,1.4604e-04_r8,1.9535e-04_r8,2.2654e-04_r8,2.0877e-04_r8/)
      kbo(:, 1,29, 1) = (/ &
     &1.0363e-05_r8,5.1128e-05_r8,7.7457e-05_r8,9.9099e-05_r8,1.0807e-04_r8/)
      kbo(:, 2,29, 1) = (/ &
     &1.4287e-05_r8,6.5810e-05_r8,9.6485e-05_r8,1.2056e-04_r8,1.2631e-04_r8/)
      kbo(:, 3,29, 1) = (/ &
     &2.0078e-05_r8,8.3622e-05_r8,1.1822e-04_r8,1.4364e-04_r8,1.4366e-04_r8/)
      kbo(:, 4,29, 1) = (/ &
     &2.8213e-05_r8,1.0495e-04_r8,1.4288e-04_r8,1.6839e-04_r8,1.5982e-04_r8/)
      kbo(:, 5,29, 1) = (/ &
     &3.9150e-05_r8,1.3025e-04_r8,1.7086e-04_r8,1.9491e-04_r8,1.7468e-04_r8/)
      kbo(:, 1,30, 1) = (/ &
     &1.0130e-05_r8,4.6183e-05_r8,6.8547e-05_r8,8.6516e-05_r8,9.2360e-05_r8/)
      kbo(:, 2,30, 1) = (/ &
     &1.4060e-05_r8,5.9445e-05_r8,8.5241e-05_r8,1.0481e-04_r8,1.0719e-04_r8/)
      kbo(:, 3,30, 1) = (/ &
     &1.9789e-05_r8,7.5542e-05_r8,1.0433e-04_r8,1.2454e-04_r8,1.2117e-04_r8/)
      kbo(:, 4,30, 1) = (/ &
     &2.7737e-05_r8,9.4871e-05_r8,1.2613e-04_r8,1.4578e-04_r8,1.3421e-04_r8/)
      kbo(:, 5,30, 1) = (/ &
     &3.8345e-05_r8,1.1778e-04_r8,1.5088e-04_r8,1.6869e-04_r8,1.4612e-04_r8/)
      kbo(:, 1,31, 1) = (/ &
     &1.0468e-05_r8,4.2679e-05_r8,6.1533e-05_r8,7.6101e-05_r8,7.8936e-05_r8/)
      kbo(:, 2,31, 1) = (/ &
     &1.4602e-05_r8,5.5015e-05_r8,7.6472e-05_r8,9.1912e-05_r8,9.0925e-05_r8/)
      kbo(:, 3,31, 1) = (/ &
     &2.0565e-05_r8,7.0045e-05_r8,9.3754e-05_r8,1.0914e-04_r8,1.0226e-04_r8/)
      kbo(:, 4,31, 1) = (/ &
     &2.8741e-05_r8,8.8177e-05_r8,1.1361e-04_r8,1.2783e-04_r8,1.1277e-04_r8/)
      kbo(:, 5,31, 1) = (/ &
     &3.9551e-05_r8,1.0965e-04_r8,1.3625e-04_r8,1.4816e-04_r8,1.2240e-04_r8/)
      kbo(:, 1,32, 1) = (/ &
     &1.0980e-05_r8,3.9860e-05_r8,5.5596e-05_r8,6.7154e-05_r8,6.7396e-05_r8/)
      kbo(:, 2,32, 1) = (/ &
     &1.5378e-05_r8,5.1481e-05_r8,6.9207e-05_r8,8.1024e-05_r8,7.7105e-05_r8/)
      kbo(:, 3,32, 1) = (/ &
     &2.1641e-05_r8,6.5723e-05_r8,8.5005e-05_r8,9.6172e-05_r8,8.6258e-05_r8/)
      kbo(:, 4,32, 1) = (/ &
     &3.0131e-05_r8,8.2891e-05_r8,1.0329e-04_r8,1.1283e-04_r8,9.4767e-05_r8/)
      kbo(:, 5,32, 1) = (/ &
     &4.1276e-05_r8,1.0326e-04_r8,1.2427e-04_r8,1.3104e-04_r8,1.0241e-04_r8/)
      kbo(:, 1,33, 1) = (/ &
     &1.1748e-05_r8,3.7749e-05_r8,5.0777e-05_r8,5.9616e-05_r8,5.7446e-05_r8/)
      kbo(:, 2,33, 1) = (/ &
     &1.6501e-05_r8,4.8915e-05_r8,6.3363e-05_r8,7.1901e-05_r8,6.5353e-05_r8/)
      kbo(:, 3,33, 1) = (/ &
     &2.3188e-05_r8,6.2624e-05_r8,7.8070e-05_r8,8.5481e-05_r8,7.2776e-05_r8/)
      kbo(:, 4,33, 1) = (/ &
     &3.2156e-05_r8,7.9179e-05_r8,9.5194e-05_r8,1.0052e-04_r8,7.9571e-05_r8/)
      kbo(:, 5,33, 1) = (/ &
     &4.3815e-05_r8,9.8786e-05_r8,1.1493e-04_r8,1.1713e-04_r8,8.5692e-05_r8/)
      kbo(:, 1,34, 1) = (/ &
     &1.2122e-05_r8,3.5250e-05_r8,4.5906e-05_r8,5.2480e-05_r8,4.8658e-05_r8/)
      kbo(:, 2,34, 1) = (/ &
     &1.7058e-05_r8,4.5800e-05_r8,5.7395e-05_r8,6.3326e-05_r8,5.5101e-05_r8/)
      kbo(:, 3,34, 1) = (/ &
     &2.3918e-05_r8,5.8762e-05_r8,7.0946e-05_r8,7.5460e-05_r8,6.1101e-05_r8/)
      kbo(:, 4,34, 1) = (/ &
     &3.3054e-05_r8,7.4431e-05_r8,8.6803e-05_r8,8.8957e-05_r8,6.6540e-05_r8/)
      kbo(:, 5,34, 1) = (/ &
     &4.4827e-05_r8,9.2907e-05_r8,1.0510e-04_r8,1.0393e-04_r8,7.1470e-05_r8/)
      kbo(:, 1,35, 1) = (/ &
     &1.2136e-05_r8,3.2274e-05_r8,4.0784e-05_r8,4.5493e-05_r8,4.0671e-05_r8/)
      kbo(:, 2,35, 1) = (/ &
     &1.7085e-05_r8,4.2082e-05_r8,5.1198e-05_r8,5.5056e-05_r8,4.5918e-05_r8/)
      kbo(:, 3,35, 1) = (/ &
     &2.3916e-05_r8,5.4183e-05_r8,6.3553e-05_r8,6.5795e-05_r8,5.0794e-05_r8/)
      kbo(:, 4,35, 1) = (/ &
     &3.2983e-05_r8,6.8784e-05_r8,7.8061e-05_r8,7.7848e-05_r8,5.5215e-05_r8/)
      kbo(:, 5,35, 1) = (/ &
     &4.4608e-05_r8,8.5962e-05_r8,9.4799e-05_r8,9.1316e-05_r8,5.9185e-05_r8/)
      kbo(:, 1,36, 1) = (/ &
     &1.1639e-05_r8,2.8710e-05_r8,3.5389e-05_r8,3.8647e-05_r8,3.3496e-05_r8/)
      kbo(:, 2,36, 1) = (/ &
     &1.6387e-05_r8,3.7611e-05_r8,4.4660e-05_r8,4.6982e-05_r8,3.7819e-05_r8/)
      kbo(:, 3,36, 1) = (/ &
     &2.2931e-05_r8,4.8613e-05_r8,5.5727e-05_r8,5.6405e-05_r8,4.1793e-05_r8/)
      kbo(:, 4,36, 1) = (/ &
     &3.1614e-05_r8,6.1937e-05_r8,6.8745e-05_r8,6.7054e-05_r8,4.5416e-05_r8/)
      kbo(:, 5,36, 1) = (/ &
     &4.2736e-05_r8,7.7667e-05_r8,8.3834e-05_r8,7.9002e-05_r8,4.8700e-05_r8/)
      kbo(:, 1,37, 1) = (/ &
     &1.0334e-05_r8,2.4228e-05_r8,2.9412e-05_r8,3.1719e-05_r8,2.7018e-05_r8/)
      kbo(:, 2,37, 1) = (/ &
     &1.4545e-05_r8,3.1907e-05_r8,3.7329e-05_r8,3.8760e-05_r8,3.0586e-05_r8/)
      kbo(:, 3,37, 1) = (/ &
     &2.0385e-05_r8,4.1462e-05_r8,4.6849e-05_r8,4.6806e-05_r8,3.3891e-05_r8/)
      kbo(:, 4,37, 1) = (/ &
     &2.8167e-05_r8,5.3075e-05_r8,5.8122e-05_r8,5.5962e-05_r8,3.6915e-05_r8/)
      kbo(:, 5,37, 1) = (/ &
     &3.8188e-05_r8,6.6903e-05_r8,7.1250e-05_r8,6.6274e-05_r8,3.9679e-05_r8/)
      kbo(:, 1,38, 1) = (/ &
     &9.2873e-06_r8,2.0587e-05_r8,2.4545e-05_r8,2.6080e-05_r8,2.1759e-05_r8/)
      kbo(:, 2,38, 1) = (/ &
     &1.3062e-05_r8,2.7262e-05_r8,3.1359e-05_r8,3.2085e-05_r8,2.4714e-05_r8/)
      kbo(:, 3,38, 1) = (/ &
     &1.8340e-05_r8,3.5628e-05_r8,3.9617e-05_r8,3.8992e-05_r8,2.7465e-05_r8/)
      kbo(:, 4,38, 1) = (/ &
     &2.5394e-05_r8,4.5875e-05_r8,4.9461e-05_r8,4.6884e-05_r8,2.9998e-05_r8/)
      kbo(:, 5,38, 1) = (/ &
     &3.4528e-05_r8,5.8131e-05_r8,6.0967e-05_r8,5.5861e-05_r8,3.2334e-05_r8/)
      kbo(:, 1,39, 1) = (/ &
     &8.5453e-06_r8,1.7761e-05_r8,2.0713e-05_r8,2.1598e-05_r8,1.7527e-05_r8/)
      kbo(:, 2,39, 1) = (/ &
     &1.2008e-05_r8,2.3655e-05_r8,2.6655e-05_r8,2.6765e-05_r8,1.9983e-05_r8/)
      kbo(:, 3,39, 1) = (/ &
     &1.6881e-05_r8,3.1100e-05_r8,3.3909e-05_r8,3.2745e-05_r8,2.2276e-05_r8/)
      kbo(:, 4,39, 1) = (/ &
     &2.3421e-05_r8,4.0278e-05_r8,4.2620e-05_r8,3.9657e-05_r8,2.4422e-05_r8/)
      kbo(:, 5,39, 1) = (/ &
     &3.1935e-05_r8,5.1364e-05_r8,5.2889e-05_r8,4.7569e-05_r8,2.6373e-05_r8/)
      kbo(:, 1,40, 1) = (/ &
     &7.1461e-06_r8,1.4361e-05_r8,1.6604e-05_r8,1.7207e-05_r8,1.3880e-05_r8/)
      kbo(:, 2,40, 1) = (/ &
     &1.0009e-05_r8,1.9228e-05_r8,2.1496e-05_r8,2.1462e-05_r8,1.5923e-05_r8/)
      kbo(:, 3,40, 1) = (/ &
     &1.4089e-05_r8,2.5420e-05_r8,2.7521e-05_r8,2.6424e-05_r8,1.7845e-05_r8/)
      kbo(:, 4,40, 1) = (/ &
     &1.9620e-05_r8,3.3119e-05_r8,3.4800e-05_r8,3.2193e-05_r8,1.9645e-05_r8/)
      kbo(:, 5,40, 1) = (/ &
     &2.6885e-05_r8,4.2499e-05_r8,4.3444e-05_r8,3.8836e-05_r8,2.1269e-05_r8/)
      kbo(:, 1,41, 1) = (/ &
     &5.9442e-06_r8,1.1549e-05_r8,1.3242e-05_r8,1.3641e-05_r8,1.0951e-05_r8/)
      kbo(:, 2,41, 1) = (/ &
     &8.2890e-06_r8,1.5538e-05_r8,1.7245e-05_r8,1.7129e-05_r8,1.2647e-05_r8/)
      kbo(:, 3,41, 1) = (/ &
     &1.1675e-05_r8,2.0658e-05_r8,2.2220e-05_r8,2.1226e-05_r8,1.4267e-05_r8/)
      kbo(:, 4,41, 1) = (/ &
     &1.6317e-05_r8,2.7083e-05_r8,2.8276e-05_r8,2.6013e-05_r8,1.5751e-05_r8/)
      kbo(:, 5,41, 1) = (/ &
     &2.2462e-05_r8,3.4966e-05_r8,3.5519e-05_r8,3.1566e-05_r8,1.7118e-05_r8/)
      kbo(:, 1,42, 1) = (/ &
     &5.0039e-06_r8,9.3487e-06_r8,1.0601e-05_r8,1.0831e-05_r8,8.6234e-06_r8/)
      kbo(:, 2,42, 1) = (/ &
     &6.9419e-06_r8,1.2631e-05_r8,1.3888e-05_r8,1.3698e-05_r8,1.0034e-05_r8/)
      kbo(:, 3,42, 1) = (/ &
     &9.7739e-06_r8,1.6890e-05_r8,1.8015e-05_r8,1.7096e-05_r8,1.1383e-05_r8/)
      kbo(:, 4,42, 1) = (/ &
     &1.3702e-05_r8,2.2284e-05_r8,2.3078e-05_r8,2.1084e-05_r8,1.2617e-05_r8/)
      kbo(:, 5,42, 1) = (/ &
     &1.8946e-05_r8,2.8958e-05_r8,2.9188e-05_r8,2.5746e-05_r8,1.3767e-05_r8/)
      kbo(:, 1,43, 1) = (/ &
     &4.1873e-06_r8,7.4795e-06_r8,8.3830e-06_r8,8.4906e-06_r8,6.7096e-06_r8/)
      kbo(:, 2,43, 1) = (/ &
     &5.7609e-06_r8,1.0144e-05_r8,1.1051e-05_r8,1.0826e-05_r8,7.8872e-06_r8/)
      kbo(:, 3,43, 1) = (/ &
     &8.0947e-06_r8,1.3657e-05_r8,1.4441e-05_r8,1.3617e-05_r8,9.0007e-06_r8/)
      kbo(:, 4,43, 1) = (/ &
     &1.1379e-05_r8,1.8143e-05_r8,1.8645e-05_r8,1.6928e-05_r8,1.0041e-05_r8/)
      kbo(:, 5,43, 1) = (/ &
     &1.5813e-05_r8,2.3749e-05_r8,2.3760e-05_r8,2.0820e-05_r8,1.1010e-05_r8/)
      kbo(:, 1,44, 1) = (/ &
     &3.5435e-06_r8,5.9971e-06_r8,6.6151e-06_r8,6.6257e-06_r8,5.1813e-06_r8/)
      kbo(:, 2,44, 1) = (/ &
     &4.8184e-06_r8,8.1565e-06_r8,8.7802e-06_r8,8.5231e-06_r8,6.1554e-06_r8/)
      kbo(:, 3,44, 1) = (/ &
     &6.7381e-06_r8,1.1044e-05_r8,1.1560e-05_r8,1.0814e-05_r8,7.0815e-06_r8/)
      kbo(:, 4,44, 1) = (/ &
     &9.4910e-06_r8,1.4784e-05_r8,1.5050e-05_r8,1.3555e-05_r8,7.9532e-06_r8/)
      kbo(:, 5,44, 1) = (/ &
     &1.3248e-05_r8,1.9506e-05_r8,1.9344e-05_r8,1.6815e-05_r8,8.7723e-06_r8/)
      kbo(:, 1,45, 1) = (/ &
     &3.0781e-06_r8,4.8864e-06_r8,5.2730e-06_r8,5.1910e-06_r8,3.9885e-06_r8/)
      kbo(:, 2,45, 1) = (/ &
     &4.1281e-06_r8,6.6470e-06_r8,7.0382e-06_r8,6.7401e-06_r8,4.7888e-06_r8/)
      kbo(:, 3,45, 1) = (/ &
     &5.7272e-06_r8,9.0419e-06_r8,9.3373e-06_r8,8.6331e-06_r8,5.5575e-06_r8/)
      kbo(:, 4,45, 1) = (/ &
     &8.0675e-06_r8,1.2195e-05_r8,1.2269e-05_r8,1.0924e-05_r8,6.2888e-06_r8/)
      kbo(:, 5,45, 1) = (/ &
     &1.1304e-05_r8,1.6230e-05_r8,1.5911e-05_r8,1.3670e-05_r8,6.9809e-06_r8/)
      kbo(:, 1,46, 1) = (/ &
     &2.7031e-06_r8,4.0051e-06_r8,4.2052e-06_r8,4.0513e-06_r8,3.0391e-06_r8/)
      kbo(:, 2,46, 1) = (/ &
     &3.5629e-06_r8,5.4291e-06_r8,5.6384e-06_r8,5.3109e-06_r8,3.6957e-06_r8/)
      kbo(:, 3,46, 1) = (/ &
     &4.8917e-06_r8,7.4052e-06_r8,7.5318e-06_r8,6.8686e-06_r8,4.3368e-06_r8/)
      kbo(:, 4,46, 1) = (/ &
     &6.8735e-06_r8,1.0056e-05_r8,9.9863e-06_r8,8.7795e-06_r8,4.9486e-06_r8/)
      kbo(:, 5,46, 1) = (/ &
     &9.6601e-06_r8,1.3493e-05_r8,1.3073e-05_r8,1.1090e-05_r8,5.5328e-06_r8/)
      kbo(:, 1,47, 1) = (/ &
     &2.3513e-06_r8,3.2459e-06_r8,3.3109e-06_r8,3.1126e-06_r8,2.2809e-06_r8/)
      kbo(:, 2,47, 1) = (/ &
     &3.0285e-06_r8,4.3632e-06_r8,4.4435e-06_r8,4.1169e-06_r8,2.8160e-06_r8/)
      kbo(:, 3,47, 1) = (/ &
     &4.0963e-06_r8,5.9519e-06_r8,5.9675e-06_r8,5.3774e-06_r8,3.3494e-06_r8/)
      kbo(:, 4,47, 1) = (/ &
     &5.7200e-06_r8,8.1250e-06_r8,7.9789e-06_r8,6.9425e-06_r8,3.8611e-06_r8/)
      kbo(:, 5,47, 1) = (/ &
     &8.0548e-06_r8,1.0990e-05_r8,1.0545e-05_r8,8.8570e-06_r8,4.3522e-06_r8/)
      kbo(:, 1,48, 1) = (/ &
     &2.1277e-06_r8,2.7115e-06_r8,2.6627e-06_r8,2.4165e-06_r8,1.7021e-06_r8/)
      kbo(:, 2,48, 1) = (/ &
     &2.6703e-06_r8,3.5982e-06_r8,3.5641e-06_r8,3.2218e-06_r8,2.1347e-06_r8/)
      kbo(:, 3,48, 1) = (/ &
     &3.5476e-06_r8,4.8904e-06_r8,4.8030e-06_r8,4.2482e-06_r8,2.5746e-06_r8/)
      kbo(:, 4,48, 1) = (/ &
     &4.9045e-06_r8,6.6952e-06_r8,6.4687e-06_r8,5.5412e-06_r8,3.0044e-06_r8/)
      kbo(:, 5,48, 1) = (/ &
     &6.9032e-06_r8,9.1233e-06_r8,8.6345e-06_r8,7.1468e-06_r8,3.4162e-06_r8/)
      kbo(:, 1,49, 1) = (/ &
     &2.0328e-06_r8,2.3718e-06_r8,2.2199e-06_r8,1.9157e-06_r8,1.2610e-06_r8/)
      kbo(:, 2,49, 1) = (/ &
     &2.4767e-06_r8,3.0887e-06_r8,2.9459e-06_r8,2.5646e-06_r8,1.6091e-06_r8/)
      kbo(:, 3,49, 1) = (/ &
     &3.2245e-06_r8,4.1594e-06_r8,3.9687e-06_r8,3.4109e-06_r8,1.9688e-06_r8/)
      kbo(:, 4,49, 1) = (/ &
     &4.3950e-06_r8,5.6964e-06_r8,5.3766e-06_r8,4.4963e-06_r8,2.3270e-06_r8/)
      kbo(:, 5,49, 1) = (/ &
     &6.1628e-06_r8,7.8088e-06_r8,7.2467e-06_r8,5.8704e-06_r8,2.6722e-06_r8/)
      kbo(:, 1,50, 1) = (/ &
     &1.8800e-06_r8,2.0468e-06_r8,1.8384e-06_r8,1.5142e-06_r8,9.3123e-07_r8/)
      kbo(:, 2,50, 1) = (/ &
     &2.2261e-06_r8,2.6068e-06_r8,2.4062e-06_r8,2.0250e-06_r8,1.2100e-06_r8/)
      kbo(:, 3,50, 1) = (/ &
     &2.8323e-06_r8,3.4659e-06_r8,3.2264e-06_r8,2.7071e-06_r8,1.5035e-06_r8/)
      kbo(:, 4,50, 1) = (/ &
     &3.7999e-06_r8,4.7249e-06_r8,4.3788e-06_r8,3.5953e-06_r8,1.7997e-06_r8/)
      kbo(:, 5,50, 1) = (/ &
     &5.2884e-06_r8,6.4943e-06_r8,5.9393e-06_r8,4.7367e-06_r8,2.0882e-06_r8/)
      kbo(:, 1,51, 1) = (/ &
     &1.7210e-06_r8,1.7678e-06_r8,1.5277e-06_r8,1.2003e-06_r8,6.8440e-07_r8/)
      kbo(:, 2,51, 1) = (/ &
     &1.9818e-06_r8,2.1939e-06_r8,1.9638e-06_r8,1.5963e-06_r8,9.0698e-07_r8/)
      kbo(:, 3,51, 1) = (/ &
     &2.4588e-06_r8,2.8718e-06_r8,2.6104e-06_r8,2.1370e-06_r8,1.1441e-06_r8/)
      kbo(:, 4,51, 1) = (/ &
     &3.2428e-06_r8,3.8817e-06_r8,3.5358e-06_r8,2.8541e-06_r8,1.3878e-06_r8/)
      kbo(:, 5,51, 1) = (/ &
     &4.4645e-06_r8,5.3335e-06_r8,4.8140e-06_r8,3.7885e-06_r8,1.6275e-06_r8/)
      kbo(:, 1,52, 1) = (/ &
     &1.6367e-06_r8,1.5882e-06_r8,1.3178e-06_r8,9.7791e-07_r8,4.9920e-07_r8/)
      kbo(:, 2,52, 1) = (/ &
     &1.8355e-06_r8,1.9143e-06_r8,1.6527e-06_r8,1.2853e-06_r8,6.7537e-07_r8/)
      kbo(:, 3,52, 1) = (/ &
     &2.2162e-06_r8,2.4540e-06_r8,2.1676e-06_r8,1.7156e-06_r8,8.6642e-07_r8/)
      kbo(:, 4,52, 1) = (/ &
     &2.8651e-06_r8,3.2774e-06_r8,2.9188e-06_r8,2.2996e-06_r8,1.0660e-06_r8/)
      kbo(:, 5,52, 1) = (/ &
     &3.8903e-06_r8,4.4871e-06_r8,3.9803e-06_r8,3.0728e-06_r8,1.2649e-06_r8/)
      kbo(:, 1,53, 1) = (/ &
     &1.6359e-06_r8,1.5065e-06_r8,1.1971e-06_r8,8.3215e-07_r8,3.6108e-07_r8/)
      kbo(:, 2,53, 1) = (/ &
     &1.7884e-06_r8,1.7570e-06_r8,1.4552e-06_r8,1.0704e-06_r8,4.9954e-07_r8/)
      kbo(:, 3,53, 1) = (/ &
     &2.1010e-06_r8,2.1926e-06_r8,1.8706e-06_r8,1.4156e-06_r8,6.5257e-07_r8/)
      kbo(:, 4,53, 1) = (/ &
     &2.6543e-06_r8,2.8821e-06_r8,2.4935e-06_r8,1.8975e-06_r8,8.1519e-07_r8/)
      kbo(:, 5,53, 1) = (/ &
     &3.5462e-06_r8,3.9143e-06_r8,3.3945e-06_r8,2.5503e-06_r8,9.8011e-07_r8/)
      kbo(:, 1,54, 1) = (/ &
     &1.4300e-06_r8,1.2802e-06_r8,9.9257e-07_r8,6.6497e-07_r8,2.6129e-07_r8/)
      kbo(:, 2,54, 1) = (/ &
     &1.5262e-06_r8,1.4508e-06_r8,1.1768e-06_r8,8.3958e-07_r8,3.6958e-07_r8/)
      kbo(:, 3,54, 1) = (/ &
     &1.7484e-06_r8,1.7685e-06_r8,1.4827e-06_r8,1.0992e-06_r8,4.9169e-07_r8/)
      kbo(:, 4,54, 1) = (/ &
     &2.1569e-06_r8,2.2883e-06_r8,1.9539e-06_r8,1.4679e-06_r8,6.2244e-07_r8/)
      kbo(:, 5,54, 1) = (/ &
     &2.8354e-06_r8,3.0764e-06_r8,2.6455e-06_r8,1.9748e-06_r8,7.5773e-07_r8/)
      kbo(:, 1,55, 1) = (/ &
     &1.1496e-06_r8,1.0107e-06_r8,7.7300e-07_r8,5.0639e-07_r8,1.8790e-07_r8/)
      kbo(:, 2,55, 1) = (/ &
     &1.1995e-06_r8,1.1187e-06_r8,8.9719e-07_r8,6.3009e-07_r8,2.7269e-07_r8/)
      kbo(:, 3,55, 1) = (/ &
     &1.3422e-06_r8,1.3346e-06_r8,1.1096e-06_r8,8.1740e-07_r8,3.6933e-07_r8/)
      kbo(:, 4,55, 1) = (/ &
     &1.6169e-06_r8,1.6973e-06_r8,1.4454e-06_r8,1.0866e-06_r8,4.7429e-07_r8/)
      kbo(:, 5,55, 1) = (/ &
     &2.0871e-06_r8,2.2587e-06_r8,1.9432e-06_r8,1.4592e-06_r8,5.8406e-07_r8/)
      kbo(:, 1,56, 1) = (/ &
     &9.3098e-07_r8,8.0374e-07_r8,6.0662e-07_r8,3.8780e-07_r8,1.3395e-07_r8/)
      kbo(:, 2,56, 1) = (/ &
     &9.4853e-07_r8,8.6979e-07_r8,6.8824e-07_r8,4.7493e-07_r8,1.9978e-07_r8/)
      kbo(:, 3,56, 1) = (/ &
     &1.0383e-06_r8,1.0136e-06_r8,8.3527e-07_r8,6.0949e-07_r8,2.7592e-07_r8/)
      kbo(:, 4,56, 1) = (/ &
     &1.2210e-06_r8,1.2652e-06_r8,1.0730e-06_r8,8.0519e-07_r8,3.6001e-07_r8/)
      kbo(:, 5,56, 1) = (/ &
     &1.5443e-06_r8,1.6630e-06_r8,1.4302e-06_r8,1.0789e-06_r8,4.4877e-07_r8/)
      kbo(:, 1,57, 1) = (/ &
     &7.5869e-07_r8,6.4433e-07_r8,4.7913e-07_r8,2.9908e-07_r8,9.4559e-08_r8/)
      kbo(:, 2,57, 1) = (/ &
     &7.5680e-07_r8,6.8154e-07_r8,5.3140e-07_r8,3.5955e-07_r8,1.4504e-07_r8/)
      kbo(:, 3,57, 1) = (/ &
     &8.0958e-07_r8,7.7512e-07_r8,6.3252e-07_r8,4.5567e-07_r8,2.0501e-07_r8/)
      kbo(:, 4,57, 1) = (/ &
     &9.2953e-07_r8,9.4815e-07_r8,7.9932e-07_r8,5.9759e-07_r8,2.7208e-07_r8/)
      kbo(:, 5,57, 1) = (/ &
     &1.1491e-06_r8,1.2288e-06_r8,1.0552e-06_r8,7.9844e-07_r8,3.4355e-07_r8/)
      kbo(:, 1,58, 1) = (/ &
     &1.6388e-07_r8,1.6804e-07_r8,1.5881e-07_r8,1.3627e-07_r8,6.6479e-08_r8/)
      kbo(:, 2,58, 1) = (/ &
     &1.6042e-07_r8,1.7409e-07_r8,1.7274e-07_r8,1.6106e-07_r8,1.0511e-07_r8/)
      kbo(:, 3,58, 1) = (/ &
     &1.6792e-07_r8,1.9377e-07_r8,2.0193e-07_r8,2.0193e-07_r8,1.5191e-07_r8/)
      kbo(:, 4,58, 1) = (/ &
     &1.8861e-07_r8,2.3235e-07_r8,2.5117e-07_r8,2.6306e-07_r8,2.0537e-07_r8/)
      kbo(:, 5,58, 1) = (/ &
     &2.2793e-07_r8,2.9684e-07_r8,3.2824e-07_r8,3.5018e-07_r8,2.6292e-07_r8/)
      kbo(:, 1,59, 1) = (/ &
     &1.5765e-07_r8,1.5618e-07_r8,1.3958e-07_r8,1.1007e-07_r8,5.0739e-08_r8/)
      kbo(:, 2,59, 1) = (/ &
     &1.5325e-07_r8,1.6219e-07_r8,1.5348e-07_r8,1.3308e-07_r8,8.1077e-08_r8/)
      kbo(:, 3,59, 1) = (/ &
     &1.5900e-07_r8,1.8099e-07_r8,1.8121e-07_r8,1.6979e-07_r8,1.1831e-07_r8/)
      kbo(:, 4,59, 1) = (/ &
     &1.7701e-07_r8,2.1714e-07_r8,2.2693e-07_r8,2.2335e-07_r8,1.6137e-07_r8/)
      kbo(:, 5,59, 1) = (/ &
     &2.1198e-07_r8,2.7749e-07_r8,2.9703e-07_r8,2.9803e-07_r8,2.0840e-07_r8/)
      kbo(:, 1,13, 2) = (/ &
     &3.6279e-03_r8,6.1760e-03_r8,7.4137e-03_r8,8.1756e-03_r8,7.6678e-03_r8/)
      kbo(:, 2,13, 2) = (/ &
     &4.7275e-03_r8,8.3099e-03_r8,9.8779e-03_r8,1.0590e-02_r8,9.2190e-03_r8/)
      kbo(:, 3,13, 2) = (/ &
     &6.7817e-03_r8,1.1546e-02_r8,1.3324e-02_r8,1.3748e-02_r8,1.0778e-02_r8/)
      kbo(:, 4,13, 2) = (/ &
     &1.0391e-02_r8,1.6290e-02_r8,1.8048e-02_r8,1.7786e-02_r8,1.2299e-02_r8/)
      kbo(:, 5,13, 2) = (/ &
     &1.6231e-02_r8,2.2973e-02_r8,2.4369e-02_r8,2.2866e-02_r8,1.3775e-02_r8/)
      kbo(:, 1,14, 2) = (/ &
     &1.9069e-03_r8,4.2185e-03_r8,5.5573e-03_r8,6.5712e-03_r8,6.6234e-03_r8/)
      kbo(:, 2,14, 2) = (/ &
     &2.5180e-03_r8,5.7108e-03_r8,7.3682e-03_r8,8.4311e-03_r8,7.9352e-03_r8/)
      kbo(:, 3,14, 2) = (/ &
     &3.6614e-03_r8,7.8938e-03_r8,9.8216e-03_r8,1.0792e-02_r8,9.2480e-03_r8/)
      kbo(:, 4,14, 2) = (/ &
     &5.6530e-03_r8,1.1002e-02_r8,1.3072e-02_r8,1.3740e-02_r8,1.0517e-02_r8/)
      kbo(:, 5,14, 2) = (/ &
     &8.8619e-03_r8,1.5292e-02_r8,1.7338e-02_r8,1.7343e-02_r8,1.1731e-02_r8/)
      kbo(:, 1,15, 2) = (/ &
     &1.0269e-03_r8,3.0313e-03_r8,4.3258e-03_r8,5.3827e-03_r8,5.7089e-03_r8/)
      kbo(:, 2,15, 2) = (/ &
     &1.3765e-03_r8,4.1045e-03_r8,5.6876e-03_r8,6.8515e-03_r8,6.8087e-03_r8/)
      kbo(:, 3,15, 2) = (/ &
     &2.0273e-03_r8,5.6227e-03_r8,7.4759e-03_r8,8.6449e-03_r8,7.9051e-03_r8/)
      kbo(:, 4,15, 2) = (/ &
     &3.1553e-03_r8,7.7214e-03_r8,9.7810e-03_r8,1.0828e-02_r8,8.9583e-03_r8/)
      kbo(:, 5,15, 2) = (/ &
     &4.9678e-03_r8,1.0557e-02_r8,1.2725e-02_r8,1.3447e-02_r8,9.9499e-03_r8/)
      kbo(:, 1,16, 2) = (/ &
     &6.6110e-04_r8,2.3925e-03_r8,3.5607e-03_r8,4.5272e-03_r8,4.9025e-03_r8/)
      kbo(:, 2,16, 2) = (/ &
     &8.9912e-04_r8,3.2391e-03_r8,4.6534e-03_r8,5.7377e-03_r8,5.8262e-03_r8/)
      kbo(:, 3,16, 2) = (/ &
     &1.3419e-03_r8,4.4091e-03_r8,6.0651e-03_r8,7.1821e-03_r8,6.7308e-03_r8/)
      kbo(:, 4,16, 2) = (/ &
     &2.1065e-03_r8,5.9970e-03_r8,7.8566e-03_r8,8.9138e-03_r8,7.5936e-03_r8/)
      kbo(:, 5,16, 2) = (/ &
     &3.3254e-03_r8,8.1145e-03_r8,1.0111e-02_r8,1.0963e-02_r8,8.4021e-03_r8/)
      kbo(:, 1,17, 2) = (/ &
     &4.4242e-04_r8,1.9273e-03_r8,2.9584e-03_r8,3.8169e-03_r8,4.1910e-03_r8/)
      kbo(:, 2,17, 2) = (/ &
     &6.0993e-04_r8,2.6019e-03_r8,3.8415e-03_r8,4.8112e-03_r8,4.9579e-03_r8/)
      kbo(:, 3,17, 2) = (/ &
     &9.2221e-04_r8,3.5184e-03_r8,4.9669e-03_r8,5.9811e-03_r8,5.6981e-03_r8/)
      kbo(:, 4,17, 2) = (/ &
     &1.4572e-03_r8,4.7461e-03_r8,6.3751e-03_r8,7.3581e-03_r8,6.3963e-03_r8/)
      kbo(:, 5,17, 2) = (/ &
     &2.3036e-03_r8,6.3581e-03_r8,8.1281e-03_r8,8.9737e-03_r8,7.0378e-03_r8/)
      kbo(:, 1,18, 2) = (/ &
     &3.0388e-04_r8,1.5707e-03_r8,2.4656e-03_r8,3.2158e-03_r8,3.5652e-03_r8/)
      kbo(:, 2,18, 2) = (/ &
     &4.2513e-04_r8,2.1109e-03_r8,3.1840e-03_r8,4.0302e-03_r8,4.1950e-03_r8/)
      kbo(:, 3,18, 2) = (/ &
     &6.4993e-04_r8,2.8372e-03_r8,4.0815e-03_r8,4.9772e-03_r8,4.7960e-03_r8/)
      kbo(:, 4,18, 2) = (/ &
     &1.0315e-03_r8,3.7953e-03_r8,5.1949e-03_r8,6.0778e-03_r8,5.3518e-03_r8/)
      kbo(:, 5,18, 2) = (/ &
     &1.6331e-03_r8,5.0371e-03_r8,6.5707e-03_r8,7.3465e-03_r8,5.8586e-03_r8/)
      kbo(:, 1,19, 2) = (/ &
     &2.0547e-04_r8,1.2763e-03_r8,2.0458e-03_r8,2.6959e-03_r8,3.0176e-03_r8/)
      kbo(:, 2,19, 2) = (/ &
     &2.9169e-04_r8,1.7044e-03_r8,2.6231e-03_r8,3.3550e-03_r8,3.5313e-03_r8/)
      kbo(:, 3,19, 2) = (/ &
     &4.4987e-04_r8,2.2721e-03_r8,3.3322e-03_r8,4.1113e-03_r8,4.0121e-03_r8/)
      kbo(:, 4,19, 2) = (/ &
     &7.1653e-04_r8,3.0090e-03_r8,4.2013e-03_r8,4.9750e-03_r8,4.4532e-03_r8/)
      kbo(:, 5,19, 2) = (/ &
     &1.1358e-03_r8,3.9520e-03_r8,5.2567e-03_r8,5.9542e-03_r8,4.8572e-03_r8/)
      kbo(:, 1,20, 2) = (/ &
     &1.5174e-04_r8,1.0642e-03_r8,1.7200e-03_r8,2.2761e-03_r8,2.5514e-03_r8/)
      kbo(:, 2,20, 2) = (/ &
     &2.1846e-04_r8,1.4153e-03_r8,2.1942e-03_r8,2.8165e-03_r8,2.9650e-03_r8/)
      kbo(:, 3,20, 2) = (/ &
     &3.3982e-04_r8,1.8745e-03_r8,2.7705e-03_r8,3.4277e-03_r8,3.3482e-03_r8/)
      kbo(:, 4,20, 2) = (/ &
     &5.4313e-04_r8,2.4649e-03_r8,3.4676e-03_r8,4.1183e-03_r8,3.7008e-03_r8/)
      kbo(:, 5,20, 2) = (/ &
     &8.6061e-04_r8,3.2127e-03_r8,4.3062e-03_r8,4.9014e-03_r8,4.0252e-03_r8/)
      kbo(:, 1,21, 2) = (/ &
     &1.1592e-04_r8,8.9297e-04_r8,1.4493e-03_r8,1.9202e-03_r8,2.1482e-03_r8/)
      kbo(:, 2,21, 2) = (/ &
     &1.6918e-04_r8,1.1825e-03_r8,1.8389e-03_r8,2.3614e-03_r8,2.4794e-03_r8/)
      kbo(:, 3,21, 2) = (/ &
     &2.6522e-04_r8,1.5570e-03_r8,2.3088e-03_r8,2.8574e-03_r8,2.7868e-03_r8/)
      kbo(:, 4,21, 2) = (/ &
     &4.2461e-04_r8,2.0332e-03_r8,2.8744e-03_r8,3.4170e-03_r8,3.0702e-03_r8/)
      kbo(:, 5,21, 2) = (/ &
     &6.7177e-04_r8,2.6322e-03_r8,3.5494e-03_r8,4.0519e-03_r8,3.3309e-03_r8/)
      kbo(:, 1,22, 2) = (/ &
     &9.3055e-05_r8,7.6606e-04_r8,1.2409e-03_r8,1.6398e-03_r8,1.8197e-03_r8/)
      kbo(:, 2,22, 2) = (/ &
     &1.3841e-04_r8,1.0092e-03_r8,1.5660e-03_r8,2.0038e-03_r8,2.0843e-03_r8/)
      kbo(:, 3,22, 2) = (/ &
     &2.1899e-04_r8,1.3206e-03_r8,1.9566e-03_r8,2.4125e-03_r8,2.3311e-03_r8/)
      kbo(:, 4,22, 2) = (/ &
     &3.5071e-04_r8,1.7145e-03_r8,2.4240e-03_r8,2.8744e-03_r8,2.5586e-03_r8/)
      kbo(:, 5,22, 2) = (/ &
     &5.5216e-04_r8,2.2067e-03_r8,2.9792e-03_r8,3.3952e-03_r8,2.7680e-03_r8/)
      kbo(:, 1,23, 2) = (/ &
     &7.5659e-05_r8,6.5668e-04_r8,1.0605e-03_r8,1.3970e-03_r8,1.5365e-03_r8/)
      kbo(:, 2,23, 2) = (/ &
     &1.1449e-04_r8,8.6018e-04_r8,1.3327e-03_r8,1.6978e-03_r8,1.7494e-03_r8/)
      kbo(:, 3,23, 2) = (/ &
     &1.8237e-04_r8,1.1195e-03_r8,1.6581e-03_r8,2.0367e-03_r8,1.9476e-03_r8/)
      kbo(:, 4,23, 2) = (/ &
     &2.9157e-04_r8,1.4455e-03_r8,2.0441e-03_r8,2.4187e-03_r8,2.1305e-03_r8/)
      kbo(:, 5,23, 2) = (/ &
     &4.5638e-04_r8,1.8506e-03_r8,2.4994e-03_r8,2.8459e-03_r8,2.2986e-03_r8/)
      kbo(:, 1,24, 2) = (/ &
     &6.1686e-05_r8,5.6133e-04_r8,9.0530e-04_r8,1.1887e-03_r8,1.2959e-03_r8/)
      kbo(:, 2,24, 2) = (/ &
     &9.4868e-05_r8,7.3156e-04_r8,1.1327e-03_r8,1.4379e-03_r8,1.4672e-03_r8/)
      kbo(:, 3,24, 2) = (/ &
     &1.5170e-04_r8,9.4694e-04_r8,1.4023e-03_r8,1.7186e-03_r8,1.6265e-03_r8/)
      kbo(:, 4,24, 2) = (/ &
     &2.4184e-04_r8,1.2160e-03_r8,1.7202e-03_r8,2.0324e-03_r8,1.7732e-03_r8/)
      kbo(:, 5,24, 2) = (/ &
     &3.7584e-04_r8,1.5479e-03_r8,2.0924e-03_r8,2.3822e-03_r8,1.9076e-03_r8/)
      kbo(:, 1,25, 2) = (/ &
     &5.1420e-05_r8,4.8151e-04_r8,7.7480e-04_r8,1.0127e-03_r8,1.0925e-03_r8/)
      kbo(:, 2,25, 2) = (/ &
     &8.0205e-05_r8,6.2472e-04_r8,9.6537e-04_r8,1.2206e-03_r8,1.2305e-03_r8/)
      kbo(:, 3,25, 2) = (/ &
     &1.2852e-04_r8,8.0481e-04_r8,1.1895e-03_r8,1.4535e-03_r8,1.3583e-03_r8/)
      kbo(:, 4,25, 2) = (/ &
     &2.0384e-04_r8,1.0284e-03_r8,1.4523e-03_r8,1.7128e-03_r8,1.4762e-03_r8/)
      kbo(:, 5,25, 2) = (/ &
     &3.1446e-04_r8,1.3022e-03_r8,1.7587e-03_r8,1.9996e-03_r8,1.5839e-03_r8/)
      kbo(:, 1,26, 2) = (/ &
     &4.4173e-05_r8,4.1605e-04_r8,6.6653e-04_r8,8.6651e-04_r8,9.2186e-04_r8/)
      kbo(:, 2,26, 2) = (/ &
     &6.9706e-05_r8,5.3779e-04_r8,8.2701e-04_r8,1.0408e-03_r8,1.0329e-03_r8/)
      kbo(:, 3,26, 2) = (/ &
     &1.1164e-04_r8,6.8982e-04_r8,1.0147e-03_r8,1.2348e-03_r8,1.1353e-03_r8/)
      kbo(:, 4,26, 2) = (/ &
     &1.7590e-04_r8,8.7786e-04_r8,1.2337e-03_r8,1.4499e-03_r8,1.2294e-03_r8/)
      kbo(:, 5,26, 2) = (/ &
     &2.6942e-04_r8,1.1054e-03_r8,1.4885e-03_r8,1.6863e-03_r8,1.3161e-03_r8/)
      kbo(:, 1,27, 2) = (/ &
     &3.9675e-05_r8,3.6275e-04_r8,5.7658e-04_r8,7.4423e-04_r8,7.7727e-04_r8/)
      kbo(:, 2,27, 2) = (/ &
     &6.3079e-05_r8,4.6769e-04_r8,7.1304e-04_r8,8.9128e-04_r8,8.6622e-04_r8/)
      kbo(:, 3,27, 2) = (/ &
     &1.0080e-04_r8,5.9857e-04_r8,8.7226e-04_r8,1.0546e-03_r8,9.4873e-04_r8/)
      kbo(:, 4,27, 2) = (/ &
     &1.5784e-04_r8,7.5914e-04_r8,1.0582e-03_r8,1.2346e-03_r8,1.0243e-03_r8/)
      kbo(:, 5,27, 2) = (/ &
     &2.3988e-04_r8,9.5199e-04_r8,1.2727e-03_r8,1.4326e-03_r8,1.0935e-03_r8/)
      kbo(:, 1,28, 2) = (/ &
     &3.6787e-05_r8,3.1827e-04_r8,5.0054e-04_r8,6.4070e-04_r8,6.5436e-04_r8/)
      kbo(:, 2,28, 2) = (/ &
     &5.8744e-05_r8,4.0999e-04_r8,6.1769e-04_r8,7.6553e-04_r8,7.2608e-04_r8/)
      kbo(:, 3,28, 2) = (/ &
     &9.3496e-05_r8,5.2404e-04_r8,7.5434e-04_r8,9.0364e-04_r8,7.9234e-04_r8/)
      kbo(:, 4,28, 2) = (/ &
     &1.4539e-04_r8,6.6291e-04_r8,9.1412e-04_r8,1.0560e-03_r8,8.5294e-04_r8/)
      kbo(:, 5,28, 2) = (/ &
     &2.1931e-04_r8,8.2828e-04_r8,1.0967e-03_r8,1.2236e-03_r8,9.0840e-04_r8/)
      kbo(:, 1,29, 2) = (/ &
     &3.6448e-05_r8,2.8470e-04_r8,4.4017e-04_r8,5.5630e-04_r8,5.5097e-04_r8/)
      kbo(:, 2,29, 2) = (/ &
     &5.8278e-05_r8,3.6727e-04_r8,5.4285e-04_r8,6.6380e-04_r8,6.0864e-04_r8/)
      kbo(:, 3,29, 2) = (/ &
     &9.2358e-05_r8,4.6962e-04_r8,6.6368e-04_r8,7.8295e-04_r8,6.6201e-04_r8/)
      kbo(:, 4,29, 2) = (/ &
     &1.4253e-04_r8,5.9354e-04_r8,8.0405e-04_r8,9.1518e-04_r8,7.1060e-04_r8/)
      kbo(:, 5,29, 2) = (/ &
     &2.1329e-04_r8,7.4124e-04_r8,9.6341e-04_r8,1.0599e-03_r8,7.5499e-04_r8/)
      kbo(:, 1,30, 2) = (/ &
     &3.7091e-05_r8,2.5711e-04_r8,3.8922e-04_r8,4.8469e-04_r8,4.6359e-04_r8/)
      kbo(:, 2,30, 2) = (/ &
     &5.9310e-05_r8,3.3239e-04_r8,4.8070e-04_r8,5.7820e-04_r8,5.1002e-04_r8/)
      kbo(:, 3,30, 2) = (/ &
     &9.3453e-05_r8,4.2556e-04_r8,5.8851e-04_r8,6.8238e-04_r8,5.5293e-04_r8/)
      kbo(:, 4,30, 2) = (/ &
     &1.4319e-04_r8,5.3792e-04_r8,7.1341e-04_r8,7.9807e-04_r8,5.9204e-04_r8/)
      kbo(:, 5,30, 2) = (/ &
     &2.1251e-04_r8,6.7254e-04_r8,8.5446e-04_r8,9.2424e-04_r8,6.2785e-04_r8/)
      kbo(:, 1,31, 2) = (/ &
     &3.9864e-05_r8,2.3712e-04_r8,3.4911e-04_r8,4.2654e-04_r8,3.8998e-04_r8/)
      kbo(:, 2,31, 2) = (/ &
     &6.3592e-05_r8,3.0797e-04_r8,4.3283e-04_r8,5.0926e-04_r8,4.2741e-04_r8/)
      kbo(:, 3,31, 2) = (/ &
     &9.9603e-05_r8,3.9506e-04_r8,5.3137e-04_r8,6.0258e-04_r8,4.6195e-04_r8/)
      kbo(:, 4,31, 2) = (/ &
     &1.5142e-04_r8,5.0071e-04_r8,6.4518e-04_r8,7.0554e-04_r8,4.9395e-04_r8/)
      kbo(:, 5,31, 2) = (/ &
     &2.2297e-04_r8,6.2830e-04_r8,7.7442e-04_r8,8.1724e-04_r8,5.2260e-04_r8/)
      kbo(:, 1,32, 2) = (/ &
     &4.3430e-05_r8,2.2111e-04_r8,3.1573e-04_r8,3.7714e-04_r8,3.2795e-04_r8/)
      kbo(:, 2,32, 2) = (/ &
     &6.9083e-05_r8,2.8816e-04_r8,3.9276e-04_r8,4.5160e-04_r8,3.5813e-04_r8/)
      kbo(:, 3,32, 2) = (/ &
     &1.0740e-04_r8,3.7075e-04_r8,4.8372e-04_r8,5.3513e-04_r8,3.8620e-04_r8/)
      kbo(:, 4,32, 2) = (/ &
     &1.6196e-04_r8,4.7193e-04_r8,5.8843e-04_r8,6.2745e-04_r8,4.1195e-04_r8/)
      kbo(:, 5,32, 2) = (/ &
     &2.3647e-04_r8,5.9479e-04_r8,7.0866e-04_r8,7.2794e-04_r8,4.3506e-04_r8/)
      kbo(:, 1,33, 2) = (/ &
     &4.8220e-05_r8,2.0906e-04_r8,2.8832e-04_r8,3.3596e-04_r8,2.7570e-04_r8/)
      kbo(:, 2,33, 2) = (/ &
     &7.6368e-05_r8,2.7329e-04_r8,3.6023e-04_r8,4.0330e-04_r8,3.0019e-04_r8/)
      kbo(:, 3,33, 2) = (/ &
     &1.1780e-04_r8,3.5332e-04_r8,4.4506e-04_r8,4.7900e-04_r8,3.2295e-04_r8/)
      kbo(:, 4,33, 2) = (/ &
     &1.7613e-04_r8,4.5198e-04_r8,5.4349e-04_r8,5.6284e-04_r8,3.4357e-04_r8/)
      kbo(:, 5,33, 2) = (/ &
     &2.5515e-04_r8,5.7259e-04_r8,6.5773e-04_r8,6.5473e-04_r8,3.6197e-04_r8/)
      kbo(:, 1,34, 2) = (/ &
     &5.1326e-05_r8,1.9484e-04_r8,2.6083e-04_r8,2.9705e-04_r8,2.3085e-04_r8/)
      kbo(:, 2,34, 2) = (/ &
     &8.0913e-05_r8,2.5559e-04_r8,3.2688e-04_r8,3.5738e-04_r8,2.5079e-04_r8/)
      kbo(:, 3,34, 2) = (/ &
     &1.2390e-04_r8,3.3190e-04_r8,4.0497e-04_r8,4.2508e-04_r8,2.6902e-04_r8/)
      kbo(:, 4,34, 2) = (/ &
     &1.8386e-04_r8,4.2648e-04_r8,4.9662e-04_r8,5.0061e-04_r8,2.8571e-04_r8/)
      kbo(:, 5,34, 2) = (/ &
     &2.6467e-04_r8,5.4249e-04_r8,6.0361e-04_r8,5.8398e-04_r8,3.0059e-04_r8/)
      kbo(:, 1,35, 2) = (/ &
     &5.2281e-05_r8,1.7754e-04_r8,2.3171e-04_r8,2.5859e-04_r8,1.9168e-04_r8/)
      kbo(:, 2,35, 2) = (/ &
     &8.2157e-05_r8,2.3435e-04_r8,2.9174e-04_r8,3.1208e-04_r8,2.0781e-04_r8/)
      kbo(:, 3,35, 2) = (/ &
     &1.2528e-04_r8,3.0602e-04_r8,3.6300e-04_r8,3.7259e-04_r8,2.2270e-04_r8/)
      kbo(:, 4,35, 2) = (/ &
     &1.8516e-04_r8,3.9534e-04_r8,4.4759e-04_r8,4.4038e-04_r8,2.3630e-04_r8/)
      kbo(:, 5,35, 2) = (/ &
     &2.6552e-04_r8,5.0554e-04_r8,5.4703e-04_r8,5.1605e-04_r8,2.4840e-04_r8/)
      kbo(:, 1,36, 2) = (/ &
     &5.0331e-05_r8,1.5710e-04_r8,2.0093e-04_r8,2.2058e-04_r8,1.5759e-04_r8/)
      kbo(:, 2,36, 2) = (/ &
     &7.9043e-05_r8,2.0874e-04_r8,2.5435e-04_r8,2.6739e-04_r8,1.7077e-04_r8/)
      kbo(:, 3,36, 2) = (/ &
     &1.2045e-04_r8,2.7440e-04_r8,3.1834e-04_r8,3.2085e-04_r8,1.8310e-04_r8/)
      kbo(:, 4,36, 2) = (/ &
     &1.7786e-04_r8,3.5687e-04_r8,3.9494e-04_r8,3.8113e-04_r8,1.9431e-04_r8/)
      kbo(:, 5,36, 2) = (/ &
     &2.5490e-04_r8,4.5880e-04_r8,4.8570e-04_r8,4.4889e-04_r8,2.0416e-04_r8/)
      kbo(:, 1,37, 2) = (/ &
     &4.4029e-05_r8,1.3168e-04_r8,1.6668e-04_r8,1.8164e-04_r8,1.2776e-04_r8/)
      kbo(:, 2,37, 2) = (/ &
     &6.9369e-05_r8,1.7622e-04_r8,2.1241e-04_r8,2.2140e-04_r8,1.3874e-04_r8/)
      kbo(:, 3,37, 2) = (/ &
     &1.0612e-04_r8,2.3332e-04_r8,2.6770e-04_r8,2.6723e-04_r8,1.4898e-04_r8/)
      kbo(:, 4,37, 2) = (/ &
     &1.5731e-04_r8,3.0549e-04_r8,3.3418e-04_r8,3.1918e-04_r8,1.5836e-04_r8/)
      kbo(:, 5,37, 2) = (/ &
     &2.2631e-04_r8,3.9537e-04_r8,4.1350e-04_r8,3.7792e-04_r8,1.6663e-04_r8/)
      kbo(:, 1,38, 2) = (/ &
     &3.8922e-05_r8,1.1094e-04_r8,1.3878e-04_r8,1.4984e-04_r8,1.0348e-04_r8/)
      kbo(:, 2,38, 2) = (/ &
     &6.1507e-05_r8,1.4964e-04_r8,1.7814e-04_r8,1.8378e-04_r8,1.1264e-04_r8/)
      kbo(:, 3,38, 2) = (/ &
     &9.4510e-05_r8,1.9970e-04_r8,2.2619e-04_r8,2.2325e-04_r8,1.2117e-04_r8/)
      kbo(:, 4,38, 2) = (/ &
     &1.4072e-04_r8,2.6356e-04_r8,2.8447e-04_r8,2.6849e-04_r8,1.2897e-04_r8/)
      kbo(:, 5,38, 2) = (/ &
     &2.0319e-04_r8,3.4350e-04_r8,3.5441e-04_r8,3.1981e-04_r8,1.3588e-04_r8/)
      kbo(:, 1,39, 2) = (/ &
     &3.5197e-05_r8,9.4645e-05_r8,1.1658e-04_r8,1.2439e-04_r8,8.3852e-05_r8/)
      kbo(:, 2,39, 2) = (/ &
     &5.5773e-05_r8,1.2882e-04_r8,1.5091e-04_r8,1.5369e-04_r8,9.1477e-05_r8/)
      kbo(:, 3,39, 2) = (/ &
     &8.6079e-05_r8,1.7350e-04_r8,1.9331e-04_r8,1.8814e-04_r8,9.8545e-05_r8/)
      kbo(:, 4,39, 2) = (/ &
     &1.2878e-04_r8,2.3093e-04_r8,2.4509e-04_r8,2.2784e-04_r8,1.0505e-04_r8/)
      kbo(:, 5,39, 2) = (/ &
     &1.8672e-04_r8,3.0343e-04_r8,3.0781e-04_r8,2.7347e-04_r8,1.1084e-04_r8/)
      kbo(:, 1,40, 2) = (/ &
     &2.8482e-05_r8,7.5721e-05_r8,9.3100e-05_r8,9.9288e-05_r8,6.7184e-05_r8/)
      kbo(:, 2,40, 2) = (/ &
     &4.5322e-05_r8,1.0379e-04_r8,1.2136e-04_r8,1.2342e-04_r8,7.3552e-05_r8/)
      kbo(:, 3,40, 2) = (/ &
     &7.0466e-05_r8,1.4083e-04_r8,1.5650e-04_r8,1.5207e-04_r8,7.9463e-05_r8/)
      kbo(:, 4,40, 2) = (/ &
     &1.0624e-04_r8,1.8883e-04_r8,1.9975e-04_r8,1.8533e-04_r8,8.4957e-05_r8/)
      kbo(:, 5,40, 2) = (/ &
     &1.5520e-04_r8,2.4983e-04_r8,2.5250e-04_r8,2.2369e-04_r8,8.9879e-05_r8/)
      kbo(:, 1,41, 2) = (/ &
     &2.2852e-05_r8,6.0191e-05_r8,7.3911e-05_r8,7.8847e-05_r8,5.3707e-05_r8/)
      kbo(:, 2,41, 2) = (/ &
     &3.6477e-05_r8,8.3074e-05_r8,9.7030e-05_r8,9.8640e-05_r8,5.9019e-05_r8/)
      kbo(:, 3,41, 2) = (/ &
     &5.7117e-05_r8,1.1353e-04_r8,1.2598e-04_r8,1.2230e-04_r8,6.3954e-05_r8/)
      kbo(:, 4,41, 2) = (/ &
     &8.6797e-05_r8,1.5338e-04_r8,1.6193e-04_r8,1.5005e-04_r8,6.8580e-05_r8/)
      kbo(:, 5,41, 2) = (/ &
     &1.2784e-04_r8,2.0441e-04_r8,2.0604e-04_r8,1.8219e-04_r8,7.2757e-05_r8/)
      kbo(:, 1,42, 2) = (/ &
     &1.8532e-05_r8,4.8021e-05_r8,5.8809e-05_r8,6.2677e-05_r8,4.2889e-05_r8/)
      kbo(:, 2,42, 2) = (/ &
     &2.9639e-05_r8,6.6772e-05_r8,7.7781e-05_r8,7.8945e-05_r8,4.7319e-05_r8/)
      kbo(:, 3,42, 2) = (/ &
     &4.6699e-05_r8,9.1970e-05_r8,1.0173e-04_r8,9.8516e-05_r8,5.1447e-05_r8/)
      kbo(:, 4,42, 2) = (/ &
     &7.1536e-05_r8,1.2527e-04_r8,1.3174e-04_r8,1.2174e-04_r8,5.5341e-05_r8/)
      kbo(:, 5,42, 2) = (/ &
     &1.0622e-04_r8,1.6829e-04_r8,1.6888e-04_r8,1.4882e-04_r8,5.8857e-05_r8/)
      kbo(:, 1,43, 2) = (/ &
     &1.4784e-05_r8,3.7715e-05_r8,4.6105e-05_r8,4.9162e-05_r8,3.3989e-05_r8/)
      kbo(:, 2,43, 2) = (/ &
     &2.3635e-05_r8,5.2843e-05_r8,6.1488e-05_r8,6.2402e-05_r8,3.7696e-05_r8/)
      kbo(:, 3,43, 2) = (/ &
     &3.7482e-05_r8,7.3434e-05_r8,8.1121e-05_r8,7.8491e-05_r8,4.1167e-05_r8/)
      kbo(:, 4,43, 2) = (/ &
     &5.7957e-05_r8,1.0094e-04_r8,1.0596e-04_r8,9.7736e-05_r8,4.4450e-05_r8/)
      kbo(:, 5,43, 2) = (/ &
     &8.6918e-05_r8,1.3688e-04_r8,1.3695e-04_r8,1.2041e-04_r8,4.7444e-05_r8/)
      kbo(:, 1,44, 2) = (/ &
     &1.1851e-05_r8,2.9526e-05_r8,3.5985e-05_r8,3.8353e-05_r8,2.6802e-05_r8/)
      kbo(:, 2,44, 2) = (/ &
     &1.8865e-05_r8,4.1676e-05_r8,4.8402e-05_r8,4.9101e-05_r8,2.9917e-05_r8/)
      kbo(:, 3,44, 2) = (/ &
     &3.0080e-05_r8,5.8471e-05_r8,6.4462e-05_r8,6.2284e-05_r8,3.2834e-05_r8/)
      kbo(:, 4,44, 2) = (/ &
     &4.6945e-05_r8,8.1180e-05_r8,8.5021e-05_r8,7.8278e-05_r8,3.5598e-05_r8/)
      kbo(:, 5,44, 2) = (/ &
     &7.1168e-05_r8,1.1121e-04_r8,1.1093e-04_r8,9.7235e-05_r8,3.8149e-05_r8/)
      kbo(:, 1,45, 2) = (/ &
     &9.7426e-06_r8,2.3333e-05_r8,2.8230e-05_r8,2.9988e-05_r8,2.1086e-05_r8/)
      kbo(:, 2,45, 2) = (/ &
     &1.5361e-05_r8,3.3173e-05_r8,3.8317e-05_r8,3.8748e-05_r8,2.3700e-05_r8/)
      kbo(:, 3,45, 2) = (/ &
     &2.4573e-05_r8,4.7011e-05_r8,5.1561e-05_r8,4.9622e-05_r8,2.6158e-05_r8/)
      kbo(:, 4,45, 2) = (/ &
     &3.8674e-05_r8,6.5958e-05_r8,6.8724e-05_r8,6.2989e-05_r8,2.8488e-05_r8/)
      kbo(:, 5,45, 2) = (/ &
     &5.9269e-05_r8,9.1392e-05_r8,9.0638e-05_r8,7.9041e-05_r8,3.0648e-05_r8/)
      kbo(:, 1,46, 2) = (/ &
     &8.0813e-06_r8,1.8394e-05_r8,2.2048e-05_r8,2.3302e-05_r8,1.6499e-05_r8/)
      kbo(:, 2,46, 2) = (/ &
     &1.2533e-05_r8,2.6309e-05_r8,3.0179e-05_r8,3.0408e-05_r8,1.8696e-05_r8/)
      kbo(:, 3,46, 2) = (/ &
     &2.0044e-05_r8,3.7660e-05_r8,4.1056e-05_r8,3.9350e-05_r8,2.0768e-05_r8/)
      kbo(:, 4,46, 2) = (/ &
     &3.1770e-05_r8,5.3410e-05_r8,5.5319e-05_r8,5.0478e-05_r8,2.2728e-05_r8/)
      kbo(:, 5,46, 2) = (/ &
     &4.9215e-05_r8,7.4898e-05_r8,7.3800e-05_r8,6.4019e-05_r8,2.4552e-05_r8/)
      kbo(:, 1,47, 2) = (/ &
     &6.6192e-06_r8,1.4238e-05_r8,1.6907e-05_r8,1.7806e-05_r8,1.2778e-05_r8/)
      kbo(:, 2,47, 2) = (/ &
     &9.9788e-06_r8,2.0419e-05_r8,2.3301e-05_r8,2.3456e-05_r8,1.4630e-05_r8/)
      kbo(:, 3,47, 2) = (/ &
     &1.5864e-05_r8,2.9439e-05_r8,3.2011e-05_r8,3.0659e-05_r8,1.6375e-05_r8/)
      kbo(:, 4,47, 2) = (/ &
     &2.5298e-05_r8,4.2209e-05_r8,4.3617e-05_r8,3.9755e-05_r8,1.8027e-05_r8/)
      kbo(:, 5,47, 2) = (/ &
     &3.9602e-05_r8,5.9887e-05_r8,5.8840e-05_r8,5.0962e-05_r8,1.9570e-05_r8/)
      kbo(:, 1,48, 2) = (/ &
     &5.6786e-06_r8,1.1254e-05_r8,1.3112e-05_r8,1.3664e-05_r8,9.8559e-06_r8/)
      kbo(:, 2,48, 2) = (/ &
     &8.2415e-06_r8,1.6109e-05_r8,1.8176e-05_r8,1.8172e-05_r8,1.1406e-05_r8/)
      kbo(:, 3,48, 2) = (/ &
     &1.2920e-05_r8,2.3359e-05_r8,2.5209e-05_r8,2.4020e-05_r8,1.2882e-05_r8/)
      kbo(:, 4,48, 2) = (/ &
     &2.0668e-05_r8,3.3871e-05_r8,3.4762e-05_r8,3.1514e-05_r8,1.4268e-05_r8/)
      kbo(:, 5,48, 2) = (/ &
     &3.2629e-05_r8,4.8666e-05_r8,4.7495e-05_r8,4.0906e-05_r8,1.5578e-05_r8/)
      kbo(:, 1,49, 2) = (/ &
     &5.1748e-06_r8,9.2021e-06_r8,1.0379e-05_r8,1.0585e-05_r8,7.5665e-06_r8/)
      kbo(:, 2,49, 2) = (/ &
     &7.1867e-06_r8,1.3062e-05_r8,1.4427e-05_r8,1.4215e-05_r8,8.8627e-06_r8/)
      kbo(:, 3,49, 2) = (/ &
     &1.1001e-05_r8,1.9012e-05_r8,2.0206e-05_r8,1.9017e-05_r8,1.0112e-05_r8/)
      kbo(:, 4,49, 2) = (/ &
     &1.7557e-05_r8,2.7865e-05_r8,2.8224e-05_r8,2.5298e-05_r8,1.1279e-05_r8/)
      kbo(:, 5,49, 2) = (/ &
     &2.7899e-05_r8,4.0582e-05_r8,3.9130e-05_r8,3.3306e-05_r8,1.2389e-05_r8/)
      kbo(:, 1,50, 2) = (/ &
     &4.6020e-06_r8,7.4638e-06_r8,8.1645e-06_r8,8.1559e-06_r8,5.7980e-06_r8/)
      kbo(:, 2,50, 2) = (/ &
     &6.1191e-06_r8,1.0436e-05_r8,1.1320e-05_r8,1.1020e-05_r8,6.8814e-06_r8/)
      kbo(:, 3,50, 2) = (/ &
     &9.0820e-06_r8,1.5149e-05_r8,1.5926e-05_r8,1.4870e-05_r8,7.9274e-06_r8/)
      kbo(:, 4,50, 2) = (/ &
     &1.4367e-05_r8,2.2331e-05_r8,2.2448e-05_r8,1.9990e-05_r8,8.9091e-06_r8/)
      kbo(:, 5,50, 2) = (/ &
     &2.2930e-05_r8,3.2870e-05_r8,3.1485e-05_r8,2.6634e-05_r8,9.8428e-06_r8/)
      kbo(:, 1,51, 2) = (/ &
     &4.0738e-06_r8,6.0767e-06_r8,6.4322e-06_r8,6.2775e-06_r8,4.4265e-06_r8/)
      kbo(:, 2,51, 2) = (/ &
     &5.2028e-06_r8,8.3182e-06_r8,8.8519e-06_r8,8.5040e-06_r8,5.3268e-06_r8/)
      kbo(:, 3,51, 2) = (/ &
     &7.4386e-06_r8,1.1969e-05_r8,1.2454e-05_r8,1.1549e-05_r8,6.2015e-06_r8/)
      kbo(:, 4,51, 2) = (/ &
     &1.1580e-05_r8,1.7676e-05_r8,1.7666e-05_r8,1.5659e-05_r8,7.0249e-06_r8/)
      kbo(:, 5,51, 2) = (/ &
     &1.8500e-05_r8,2.6231e-05_r8,2.5018e-05_r8,2.1082e-05_r8,7.8088e-06_r8/)
      kbo(:, 1,52, 2) = (/ &
     &3.7602e-06_r8,5.1251e-06_r8,5.1954e-06_r8,4.8922e-06_r8,3.3637e-06_r8/)
      kbo(:, 2,52, 2) = (/ &
     &4.6219e-06_r8,6.8269e-06_r8,7.0581e-06_r8,6.6280e-06_r8,4.1074e-06_r8/)
      kbo(:, 3,52, 2) = (/ &
     &6.3416e-06_r8,9.6823e-06_r8,9.8934e-06_r8,9.0485e-06_r8,4.8363e-06_r8/)
      kbo(:, 4,52, 2) = (/ &
     &9.6360e-06_r8,1.4271e-05_r8,1.4108e-05_r8,1.2374e-05_r8,5.5264e-06_r8/)
      kbo(:, 5,52, 2) = (/ &
     &1.5337e-05_r8,2.1320e-05_r8,2.0165e-05_r8,1.6846e-05_r8,6.1865e-06_r8/)
      kbo(:, 1,53, 2) = (/ &
     &3.6702e-06_r8,4.5390e-06_r8,4.3659e-06_r8,3.9002e-06_r8,2.5423e-06_r8/)
      kbo(:, 2,53, 2) = (/ &
     &4.3437e-06_r8,5.8533e-06_r8,5.8072e-06_r8,5.2588e-06_r8,3.1537e-06_r8/)
      kbo(:, 3,53, 2) = (/ &
     &5.7127e-06_r8,8.1219e-06_r8,8.0674e-06_r8,7.2006e-06_r8,3.7613e-06_r8/)
      kbo(:, 4,53, 2) = (/ &
     &8.4068e-06_r8,1.1886e-05_r8,1.1528e-05_r8,9.9298e-06_r8,4.3399e-06_r8/)
      kbo(:, 5,53, 2) = (/ &
     &1.3242e-05_r8,1.7846e-05_r8,1.6632e-05_r8,1.3680e-05_r8,4.8970e-06_r8/)
      kbo(:, 1,54, 2) = (/ &
     &3.1403e-06_r8,3.6924e-06_r8,3.4557e-06_r8,2.9996e-06_r8,1.9177e-06_r8/)
      kbo(:, 2,54, 2) = (/ &
     &3.5986e-06_r8,4.6301e-06_r8,4.4986e-06_r8,4.0115e-06_r8,2.4155e-06_r8/)
      kbo(:, 3,54, 2) = (/ &
     &4.5617e-06_r8,6.2669e-06_r8,6.1686e-06_r8,5.4741e-06_r8,2.9175e-06_r8/)
      kbo(:, 4,54, 2) = (/ &
     &6.4783e-06_r8,9.0433e-06_r8,8.7626e-06_r8,7.5562e-06_r8,3.4007e-06_r8/)
      kbo(:, 5,54, 2) = (/ &
     &1.0042e-05_r8,1.3533e-05_r8,1.2655e-05_r8,1.0455e-05_r8,3.8639e-06_r8/)
      kbo(:, 1,55, 2) = (/ &
     &2.4739e-06_r8,2.8343e-06_r8,2.6165e-06_r8,2.2420e-06_r8,1.4427e-06_r8/)
      kbo(:, 2,55, 2) = (/ &
     &2.7553e-06_r8,3.4672e-06_r8,3.3435e-06_r8,2.9758e-06_r8,1.8442e-06_r8/)
      kbo(:, 3,55, 2) = (/ &
     &3.3782e-06_r8,4.5817e-06_r8,4.5186e-06_r8,4.0371e-06_r8,2.2544e-06_r8/)
      kbo(:, 4,55, 2) = (/ &
     &4.6246e-06_r8,6.4927e-06_r8,6.3529e-06_r8,5.5548e-06_r8,2.6558e-06_r8/)
      kbo(:, 5,55, 2) = (/ &
     &7.0125e-06_r8,9.6319e-06_r8,9.1393e-06_r8,7.6813e-06_r8,3.0372e-06_r8/)
      kbo(:, 1,56, 2) = (/ &
     &1.9604e-06_r8,2.1929e-06_r8,1.9920e-06_r8,1.6797e-06_r8,1.0797e-06_r8/)
      kbo(:, 2,56, 2) = (/ &
     &2.1351e-06_r8,2.6170e-06_r8,2.4998e-06_r8,2.2137e-06_r8,1.4022e-06_r8/)
      kbo(:, 3,56, 2) = (/ &
     &2.5317e-06_r8,3.3754e-06_r8,3.3236e-06_r8,2.9840e-06_r8,1.7372e-06_r8/)
      kbo(:, 4,56, 2) = (/ &
     &3.3387e-06_r8,4.6862e-06_r8,4.6202e-06_r8,4.0882e-06_r8,2.0679e-06_r8/)
      kbo(:, 5,56, 2) = (/ &
     &4.9234e-06_r8,6.8724e-06_r8,6.6108e-06_r8,5.6459e-06_r8,2.3854e-06_r8/)
      kbo(:, 1,57, 2) = (/ &
     &1.5649e-06_r8,1.7047e-06_r8,1.5250e-06_r8,1.2613e-06_r8,8.0294e-07_r8/)
      kbo(:, 2,57, 2) = (/ &
     &1.6685e-06_r8,1.9908e-06_r8,1.8801e-06_r8,1.6502e-06_r8,1.0613e-06_r8/)
      kbo(:, 3,57, 2) = (/ &
     &1.9178e-06_r8,2.5066e-06_r8,2.4556e-06_r8,2.2101e-06_r8,1.3329e-06_r8/)
      kbo(:, 4,57, 2) = (/ &
     &2.4407e-06_r8,3.4025e-06_r8,3.3722e-06_r8,3.0127e-06_r8,1.6045e-06_r8/)
      kbo(:, 5,57, 2) = (/ &
     &3.4802e-06_r8,4.9175e-06_r8,4.7870e-06_r8,4.1514e-06_r8,1.8688e-06_r8/)
      kbo(:, 1,58, 2) = (/ &
     &3.3188e-07_r8,4.3313e-07_r8,4.9294e-07_r8,5.6291e-07_r8,5.9615e-07_r8/)
      kbo(:, 2,58, 2) = (/ &
     &3.4670e-07_r8,4.9696e-07_r8,5.9930e-07_r8,7.3314e-07_r8,8.0253e-07_r8/)
      kbo(:, 3,58, 2) = (/ &
     &3.8806e-07_r8,6.1237e-07_r8,7.7019e-07_r8,9.7654e-07_r8,1.0216e-06_r8/)
      kbo(:, 4,58, 2) = (/ &
     &4.7831e-07_r8,8.1333e-07_r8,1.0442e-06_r8,1.3240e-06_r8,1.2449e-06_r8/)
      kbo(:, 5,58, 2) = (/ &
     &6.5898e-07_r8,1.1558e-06_r8,1.4682e-06_r8,1.8176e-06_r8,1.4615e-06_r8/)
      kbo(:, 1,59, 2) = (/ &
     &3.1712e-07_r8,4.1538e-07_r8,4.5873e-07_r8,4.9478e-07_r8,4.6737e-07_r8/)
      kbo(:, 2,59, 2) = (/ &
     &3.2863e-07_r8,4.7977e-07_r8,5.6611e-07_r8,6.5498e-07_r8,6.3397e-07_r8/)
      kbo(:, 3,59, 2) = (/ &
     &3.6418e-07_r8,5.9318e-07_r8,7.3191e-07_r8,8.7648e-07_r8,8.1119e-07_r8/)
      kbo(:, 4,59, 2) = (/ &
     &4.4347e-07_r8,7.8664e-07_r8,9.8989e-07_r8,1.1827e-06_r8,9.9218e-07_r8/)
      kbo(:, 5,59, 2) = (/ &
     &6.0215e-07_r8,1.1090e-06_r8,1.3813e-06_r8,1.6064e-06_r8,1.1684e-06_r8/)
      kbo(:, 1,13, 3) = (/ &
     &9.1540e-03_r8,2.0983e-02_r8,2.7409e-02_r8,3.0450e-02_r8,2.3144e-02_r8/)
      kbo(:, 2,13, 3) = (/ &
     &1.5150e-02_r8,2.9836e-02_r8,3.7088e-02_r8,3.9562e-02_r8,2.6157e-02_r8/)
      kbo(:, 3,13, 3) = (/ &
     &2.6705e-02_r8,4.3495e-02_r8,5.0489e-02_r8,5.0868e-02_r8,2.9169e-02_r8/)
      kbo(:, 4,13, 3) = (/ &
     &4.6501e-02_r8,6.3525e-02_r8,6.8930e-02_r8,6.5213e-02_r8,3.2207e-02_r8/)
      kbo(:, 5,13, 3) = (/ &
     &7.7883e-02_r8,9.1957e-02_r8,9.3471e-02_r8,8.3394e-02_r8,3.5205e-02_r8/)
      kbo(:, 1,14, 3) = (/ &
     &4.9769e-03_r8,1.5542e-02_r8,2.1404e-02_r8,2.4888e-02_r8,2.0102e-02_r8/)
      kbo(:, 2,14, 3) = (/ &
     &8.3891e-03_r8,2.1811e-02_r8,2.8513e-02_r8,3.1898e-02_r8,2.2689e-02_r8/)
      kbo(:, 3,14, 3) = (/ &
     &1.4857e-02_r8,3.0975e-02_r8,3.8046e-02_r8,4.0288e-02_r8,2.5289e-02_r8/)
      kbo(:, 4,14, 3) = (/ &
     &2.5874e-02_r8,4.3884e-02_r8,5.0681e-02_r8,5.0529e-02_r8,2.7965e-02_r8/)
      kbo(:, 5,14, 3) = (/ &
     &4.3258e-02_r8,6.1604e-02_r8,6.6800e-02_r8,6.3228e-02_r8,3.0564e-02_r8/)
      kbo(:, 1,15, 3) = (/ &
     &2.7780e-03_r8,1.1828e-02_r8,1.7073e-02_r8,2.0490e-02_r8,1.7377e-02_r8/)
      kbo(:, 2,15, 3) = (/ &
     &4.7591e-03_r8,1.6367e-02_r8,2.2382e-02_r8,2.5900e-02_r8,1.9610e-02_r8/)
      kbo(:, 3,15, 3) = (/ &
     &8.4707e-03_r8,2.2715e-02_r8,2.9226e-02_r8,3.2287e-02_r8,2.1849e-02_r8/)
      kbo(:, 4,15, 3) = (/ &
     &1.4726e-02_r8,3.1294e-02_r8,3.8074e-02_r8,3.9870e-02_r8,2.4127e-02_r8/)
      kbo(:, 5,15, 3) = (/ &
     &2.4582e-02_r8,4.2700e-02_r8,4.9087e-02_r8,4.8962e-02_r8,2.6357e-02_r8/)
      kbo(:, 1,16, 3) = (/ &
     &1.8575e-03_r8,9.6428e-03_r8,1.4258e-02_r8,1.7308e-02_r8,1.4967e-02_r8/)
      kbo(:, 2,16, 3) = (/ &
     &3.2295e-03_r8,1.3222e-02_r8,1.8534e-02_r8,2.1716e-02_r8,1.6894e-02_r8/)
      kbo(:, 3,16, 3) = (/ &
     &5.7622e-03_r8,1.8134e-02_r8,2.3952e-02_r8,2.6895e-02_r8,1.8844e-02_r8/)
      kbo(:, 4,16, 3) = (/ &
     &1.0014e-02_r8,2.4628e-02_r8,3.0790e-02_r8,3.2975e-02_r8,2.0792e-02_r8/)
      kbo(:, 5,16, 3) = (/ &
     &1.6651e-02_r8,3.3072e-02_r8,3.9202e-02_r8,4.0100e-02_r8,2.2651e-02_r8/)
      kbo(:, 1,17, 3) = (/ &
     &1.2913e-03_r8,7.9469e-03_r8,1.1927e-02_r8,1.4612e-02_r8,1.2832e-02_r8/)
      kbo(:, 2,17, 3) = (/ &
     &2.2741e-03_r8,1.0816e-02_r8,1.5424e-02_r8,1.8211e-02_r8,1.4484e-02_r8/)
      kbo(:, 3,17, 3) = (/ &
     &4.0659e-03_r8,1.4661e-02_r8,1.9799e-02_r8,2.2441e-02_r8,1.6158e-02_r8/)
      kbo(:, 4,17, 3) = (/ &
     &7.0575e-03_r8,1.9668e-02_r8,2.5205e-02_r8,2.7372e-02_r8,1.7784e-02_r8/)
      kbo(:, 5,17, 3) = (/ &
     &1.1701e-02_r8,2.6124e-02_r8,3.1755e-02_r8,3.3025e-02_r8,1.9312e-02_r8/)
      kbo(:, 1,18, 3) = (/ &
     &9.2490e-04_r8,6.5924e-03_r8,1.0000e-02_r8,1.2327e-02_r8,1.0954e-02_r8/)
      kbo(:, 2,18, 3) = (/ &
     &1.6450e-03_r8,8.9024e-03_r8,1.2876e-02_r8,1.5279e-02_r8,1.2362e-02_r8/)
      kbo(:, 3,18, 3) = (/ &
     &2.9476e-03_r8,1.1938e-02_r8,1.6432e-02_r8,1.8727e-02_r8,1.3771e-02_r8/)
      kbo(:, 4,18, 3) = (/ &
     &5.1050e-03_r8,1.5852e-02_r8,2.0747e-02_r8,2.2702e-02_r8,1.5108e-02_r8/)
      kbo(:, 5,18, 3) = (/ &
     &8.4407e-03_r8,2.0877e-02_r8,2.5905e-02_r8,2.7220e-02_r8,1.6353e-02_r8/)
      kbo(:, 1,19, 3) = (/ &
     &6.5306e-04_r8,5.4276e-03_r8,8.3228e-03_r8,1.0321e-02_r8,9.3064e-03_r8/)
      kbo(:, 2,19, 3) = (/ &
     &1.1720e-03_r8,7.2659e-03_r8,1.0659e-02_r8,1.2719e-02_r8,1.0490e-02_r8/)
      kbo(:, 3,19, 3) = (/ &
     &2.1010e-03_r8,9.6452e-03_r8,1.3501e-02_r8,1.5485e-02_r8,1.1656e-02_r8/)
      kbo(:, 4,19, 3) = (/ &
     &3.6298e-03_r8,1.2682e-02_r8,1.6890e-02_r8,1.8630e-02_r8,1.2744e-02_r8/)
      kbo(:, 5,19, 3) = (/ &
     &5.9733e-03_r8,1.6533e-02_r8,2.0894e-02_r8,2.2160e-02_r8,1.3725e-02_r8/)
      kbo(:, 1,20, 3) = (/ &
     &5.0525e-04_r8,4.5786e-03_r8,7.0416e-03_r8,8.7290e-03_r8,7.8885e-03_r8/)
      kbo(:, 2,20, 3) = (/ &
     &9.1391e-04_r8,6.1018e-03_r8,8.9804e-03_r8,1.0717e-02_r8,8.8768e-03_r8/)
      kbo(:, 3,20, 3) = (/ &
     &1.6371e-03_r8,8.0525e-03_r8,1.1310e-02_r8,1.2976e-02_r8,9.8259e-03_r8/)
      kbo(:, 4,20, 3) = (/ &
     &2.8150e-03_r8,1.0522e-02_r8,1.4057e-02_r8,1.5517e-02_r8,1.0692e-02_r8/)
      kbo(:, 5,20, 3) = (/ &
     &4.6066e-03_r8,1.3646e-02_r8,1.7296e-02_r8,1.8359e-02_r8,1.1448e-02_r8/)
      kbo(:, 1,21, 3) = (/ &
     &4.0425e-04_r8,3.8829e-03_r8,5.9693e-03_r8,7.3863e-03_r8,6.6651e-03_r8/)
      kbo(:, 2,21, 3) = (/ &
     &7.3484e-04_r8,5.1547e-03_r8,7.5787e-03_r8,9.0292e-03_r8,7.4787e-03_r8/)
      kbo(:, 3,21, 3) = (/ &
     &1.3153e-03_r8,6.7705e-03_r8,9.4934e-03_r8,1.0877e-02_r8,8.2368e-03_r8/)
      kbo(:, 4,21, 3) = (/ &
     &2.2503e-03_r8,8.8142e-03_r8,1.1739e-02_r8,1.2939e-02_r8,8.9114e-03_r8/)
      kbo(:, 5,21, 3) = (/ &
     &3.6575e-03_r8,1.1380e-02_r8,1.4377e-02_r8,1.5231e-02_r8,9.5025e-03_r8/)
      kbo(:, 1,22, 3) = (/ &
     &3.4523e-04_r8,3.3635e-03_r8,5.1429e-03_r8,6.3294e-03_r8,5.6535e-03_r8/)
      kbo(:, 2,22, 3) = (/ &
     &6.2993e-04_r8,4.4492e-03_r8,6.4923e-03_r8,7.6957e-03_r8,6.3107e-03_r8/)
      kbo(:, 3,22, 3) = (/ &
     &1.1206e-03_r8,5.8192e-03_r8,8.0871e-03_r8,9.2166e-03_r8,6.9018e-03_r8/)
      kbo(:, 4,22, 3) = (/ &
     &1.8990e-03_r8,7.5458e-03_r8,9.9517e-03_r8,1.0900e-02_r8,7.4316e-03_r8/)
      kbo(:, 5,22, 3) = (/ &
     &3.0583e-03_r8,9.7051e-03_r8,1.2139e-02_r8,1.2766e-02_r8,7.8941e-03_r8/)
      kbo(:, 1,23, 3) = (/ &
     &2.9783e-04_r8,2.9108e-03_r8,4.4177e-03_r8,5.4056e-03_r8,4.7807e-03_r8/)
      kbo(:, 2,23, 3) = (/ &
     &5.4387e-04_r8,3.8320e-03_r8,5.5435e-03_r8,6.5345e-03_r8,5.2974e-03_r8/)
      kbo(:, 3,23, 3) = (/ &
     &9.5952e-04_r8,4.9950e-03_r8,6.8655e-03_r8,7.7757e-03_r8,5.7630e-03_r8/)
      kbo(:, 4,23, 3) = (/ &
     &1.6092e-03_r8,6.4496e-03_r8,8.4095e-03_r8,9.1440e-03_r8,6.1817e-03_r8/)
      kbo(:, 5,23, 3) = (/ &
     &2.5684e-03_r8,8.2494e-03_r8,1.0215e-02_r8,1.0668e-02_r8,6.5447e-03_r8/)
      kbo(:, 1,24, 3) = (/ &
     &2.5715e-04_r8,2.5095e-03_r8,3.7777e-03_r8,4.5997e-03_r8,4.0260e-03_r8/)
      kbo(:, 2,24, 3) = (/ &
     &4.6827e-04_r8,3.2888e-03_r8,4.7107e-03_r8,5.5207e-03_r8,4.4325e-03_r8/)
      kbo(:, 3,24, 3) = (/ &
     &8.1828e-04_r8,4.2677e-03_r8,5.8000e-03_r8,6.5285e-03_r8,4.8028e-03_r8/)
      kbo(:, 4,24, 3) = (/ &
     &1.3581e-03_r8,5.4776e-03_r8,7.0696e-03_r8,7.6441e-03_r8,5.1338e-03_r8/)
      kbo(:, 5,24, 3) = (/ &
     &2.1494e-03_r8,6.9550e-03_r8,8.5500e-03_r8,8.8910e-03_r8,5.4193e-03_r8/)
      kbo(:, 1,25, 3) = (/ &
     &2.2632e-04_r8,2.1696e-03_r8,3.2330e-03_r8,3.9113e-03_r8,3.3801e-03_r8/)
      kbo(:, 2,25, 3) = (/ &
     &4.0936e-04_r8,2.8320e-03_r8,4.0052e-03_r8,4.6615e-03_r8,3.7035e-03_r8/)
      kbo(:, 3,25, 3) = (/ &
     &7.0836e-04_r8,3.6547e-03_r8,4.9096e-03_r8,5.4885e-03_r8,3.9989e-03_r8/)
      kbo(:, 4,25, 3) = (/ &
     &1.1642e-03_r8,4.6613e-03_r8,5.9642e-03_r8,6.4094e-03_r8,4.2600e-03_r8/)
      kbo(:, 5,25, 3) = (/ &
     &1.8243e-03_r8,5.8764e-03_r8,7.1830e-03_r8,7.4369e-03_r8,4.4844e-03_r8/)
      kbo(:, 1,26, 3) = (/ &
     &2.0471e-04_r8,1.8893e-03_r8,2.7768e-03_r8,3.3315e-03_r8,2.8361e-03_r8/)
      kbo(:, 2,26, 3) = (/ &
     &3.6709e-04_r8,2.4543e-03_r8,3.4258e-03_r8,3.9516e-03_r8,3.0939e-03_r8/)
      kbo(:, 3,26, 3) = (/ &
     &6.2789e-04_r8,3.1504e-03_r8,4.1849e-03_r8,4.6387e-03_r8,3.3286e-03_r8/)
      kbo(:, 4,26, 3) = (/ &
     &1.0213e-03_r8,3.9950e-03_r8,5.0687e-03_r8,5.4088e-03_r8,3.5346e-03_r8/)
      kbo(:, 5,26, 3) = (/ &
     &1.5815e-03_r8,5.0074e-03_r8,6.0787e-03_r8,6.2593e-03_r8,3.7107e-03_r8/)
      kbo(:, 1,27, 3) = (/ &
     &1.9251e-04_r8,1.6617e-03_r8,2.4029e-03_r8,2.8514e-03_r8,2.3762e-03_r8/)
      kbo(:, 2,27, 3) = (/ &
     &3.4185e-04_r8,2.1525e-03_r8,2.9600e-03_r8,3.3730e-03_r8,2.5825e-03_r8/)
      kbo(:, 3,27, 3) = (/ &
     &5.7778e-04_r8,2.7512e-03_r8,3.6092e-03_r8,3.9563e-03_r8,2.7684e-03_r8/)
      kbo(:, 4,27, 3) = (/ &
     &9.2854e-04_r8,3.4753e-03_r8,4.3621e-03_r8,4.6091e-03_r8,2.9308e-03_r8/)
      kbo(:, 5,27, 3) = (/ &
     &1.4199e-03_r8,4.3436e-03_r8,5.2156e-03_r8,5.3258e-03_r8,3.0691e-03_r8/)
      kbo(:, 1,28, 3) = (/ &
     &1.8568e-04_r8,1.4731e-03_r8,2.0943e-03_r8,2.4502e-03_r8,1.9883e-03_r8/)
      kbo(:, 2,28, 3) = (/ &
     &3.2639e-04_r8,1.9038e-03_r8,2.5783e-03_r8,2.8978e-03_r8,2.1535e-03_r8/)
      kbo(:, 3,28, 3) = (/ &
     &5.4487e-04_r8,2.4257e-03_r8,3.1398e-03_r8,3.3991e-03_r8,2.3010e-03_r8/)
      kbo(:, 4,28, 3) = (/ &
     &8.6497e-04_r8,3.0580e-03_r8,3.7865e-03_r8,3.9564e-03_r8,2.4290e-03_r8/)
      kbo(:, 5,28, 3) = (/ &
     &1.3039e-03_r8,3.8186e-03_r8,4.5211e-03_r8,4.5655e-03_r8,2.5382e-03_r8/)
      kbo(:, 1,29, 3) = (/ &
     &1.9062e-04_r8,1.3364e-03_r8,1.8603e-03_r8,2.1354e-03_r8,1.6643e-03_r8/)
      kbo(:, 2,29, 3) = (/ &
     &3.3121e-04_r8,1.7267e-03_r8,2.2927e-03_r8,2.5300e-03_r8,1.7960e-03_r8/)
      kbo(:, 3,29, 3) = (/ &
     &5.4570e-04_r8,2.2011e-03_r8,2.7931e-03_r8,2.9723e-03_r8,1.9129e-03_r8/)
      kbo(:, 4,29, 3) = (/ &
     &8.5435e-04_r8,2.7794e-03_r8,3.3678e-03_r8,3.4607e-03_r8,2.0139e-03_r8/)
      kbo(:, 5,29, 3) = (/ &
     &1.2701e-03_r8,3.4715e-03_r8,4.0279e-03_r8,3.9937e-03_r8,2.1000e-03_r8/)
      kbo(:, 1,30, 3) = (/ &
     &2.0043e-04_r8,1.2258e-03_r8,1.6689e-03_r8,1.8766e-03_r8,1.3916e-03_r8/)
      kbo(:, 2,30, 3) = (/ &
     &3.4350e-04_r8,1.5850e-03_r8,2.0586e-03_r8,2.2288e-03_r8,1.4967e-03_r8/)
      kbo(:, 3,30, 3) = (/ &
     &5.5868e-04_r8,2.0253e-03_r8,2.5096e-03_r8,2.6211e-03_r8,1.5893e-03_r8/)
      kbo(:, 4,30, 3) = (/ &
     &8.6173e-04_r8,2.5636e-03_r8,3.0320e-03_r8,3.0532e-03_r8,1.6692e-03_r8/)
      kbo(:, 5,30, 3) = (/ &
     &1.2648e-03_r8,3.2006e-03_r8,3.6329e-03_r8,3.5289e-03_r8,1.7373e-03_r8/)
      kbo(:, 1,31, 3) = (/ &
     &2.2172e-04_r8,1.1517e-03_r8,1.5273e-03_r8,1.6764e-03_r8,1.1637e-03_r8/)
      kbo(:, 2,31, 3) = (/ &
     &3.7478e-04_r8,1.4949e-03_r8,1.8875e-03_r8,1.9960e-03_r8,1.2474e-03_r8/)
      kbo(:, 3,31, 3) = (/ &
     &6.0019e-04_r8,1.9228e-03_r8,2.3094e-03_r8,2.3523e-03_r8,1.3210e-03_r8/)
      kbo(:, 4,31, 3) = (/ &
     &9.1186e-04_r8,2.4398e-03_r8,2.8016e-03_r8,2.7471e-03_r8,1.3843e-03_r8/)
      kbo(:, 5,31, 3) = (/ &
     &1.3231e-03_r8,3.0462e-03_r8,3.3613e-03_r8,3.1855e-03_r8,1.4373e-03_r8/)
      kbo(:, 1,32, 3) = (/ &
     &2.4768e-04_r8,1.0937e-03_r8,1.4089e-03_r8,1.5091e-03_r8,9.7256e-04_r8/)
      kbo(:, 2,32, 3) = (/ &
     &4.1248e-04_r8,1.4292e-03_r8,1.7477e-03_r8,1.8006e-03_r8,1.0394e-03_r8/)
      kbo(:, 3,32, 3) = (/ &
     &6.5047e-04_r8,1.8467e-03_r8,2.1484e-03_r8,2.1275e-03_r8,1.0979e-03_r8/)
      kbo(:, 4,32, 3) = (/ &
     &9.7457e-04_r8,2.3473e-03_r8,2.6140e-03_r8,2.4947e-03_r8,1.1482e-03_r8/)
      kbo(:, 5,32, 3) = (/ &
     &1.3990e-03_r8,2.9324e-03_r8,3.1399e-03_r8,2.8984e-03_r8,1.1898e-03_r8/)
      kbo(:, 1,33, 3) = (/ &
     &2.8078e-04_r8,1.0552e-03_r8,1.3156e-03_r8,1.3710e-03_r8,8.1280e-04_r8/)
      kbo(:, 2,33, 3) = (/ &
     &4.6027e-04_r8,1.3891e-03_r8,1.6405e-03_r8,1.6404e-03_r8,8.6605e-04_r8/)
      kbo(:, 3,33, 3) = (/ &
     &7.1527e-04_r8,1.8015e-03_r8,2.0264e-03_r8,1.9473e-03_r8,9.1257e-04_r8/)
      kbo(:, 4,33, 3) = (/ &
     &1.0579e-03_r8,2.2936e-03_r8,2.4711e-03_r8,2.2904e-03_r8,9.5249e-04_r8/)
      kbo(:, 5,33, 3) = (/ &
     &1.5037e-03_r8,2.8717e-03_r8,2.9734e-03_r8,2.6646e-03_r8,9.8557e-04_r8/)
      kbo(:, 1,34, 3) = (/ &
     &3.0359e-04_r8,1.0038e-03_r8,1.2140e-03_r8,1.2334e-03_r8,6.7695e-04_r8/)
      kbo(:, 2,34, 3) = (/ &
     &4.9090e-04_r8,1.3275e-03_r8,1.5216e-03_r8,1.4814e-03_r8,7.1957e-04_r8/)
      kbo(:, 3,34, 3) = (/ &
     &7.5358e-04_r8,1.7240e-03_r8,1.8846e-03_r8,1.7651e-03_r8,7.5712e-04_r8/)
      kbo(:, 4,34, 3) = (/ &
     &1.1033e-03_r8,2.1975e-03_r8,2.2999e-03_r8,2.0785e-03_r8,7.8887e-04_r8/)
      kbo(:, 5,34, 3) = (/ &
     &1.5542e-03_r8,2.7592e-03_r8,2.7749e-03_r8,2.4194e-03_r8,8.1541e-04_r8/)
      kbo(:, 1,35, 3) = (/ &
     &3.1210e-04_r8,9.3394e-04_r8,1.1014e-03_r8,1.0942e-03_r8,5.6016e-04_r8/)
      kbo(:, 2,35, 3) = (/ &
     &5.0058e-04_r8,1.2412e-03_r8,1.3879e-03_r8,1.3212e-03_r8,5.9529e-04_r8/)
      kbo(:, 3,35, 3) = (/ &
     &7.6299e-04_r8,1.6182e-03_r8,1.7248e-03_r8,1.5791e-03_r8,6.2556e-04_r8/)
      kbo(:, 4,35, 3) = (/ &
     &1.1110e-03_r8,2.0696e-03_r8,2.1107e-03_r8,1.8624e-03_r8,6.5155e-04_r8/)
      kbo(:, 5,35, 3) = (/ &
     &1.5579e-03_r8,2.6064e-03_r8,2.5562e-03_r8,2.1725e-03_r8,6.7276e-04_r8/)
      kbo(:, 1,36, 3) = (/ &
     &3.0156e-04_r8,8.4185e-04_r8,9.7484e-04_r8,9.5194e-04_r8,4.6045e-04_r8/)
      kbo(:, 2,36, 3) = (/ &
     &4.8313e-04_r8,1.1258e-03_r8,1.2357e-03_r8,1.1559e-03_r8,4.8953e-04_r8/)
      kbo(:, 3,36, 3) = (/ &
     &7.3505e-04_r8,1.4756e-03_r8,1.5422e-03_r8,1.3864e-03_r8,5.1450e-04_r8/)
      kbo(:, 4,36, 3) = (/ &
     &1.0692e-03_r8,1.8983e-03_r8,1.8970e-03_r8,1.6403e-03_r8,5.3594e-04_r8/)
      kbo(:, 5,36, 3) = (/ &
     &1.4983e-03_r8,2.4025e-03_r8,2.3079e-03_r8,1.9210e-03_r8,5.5373e-04_r8/)
      kbo(:, 1,37, 3) = (/ &
     &2.6336e-04_r8,7.1618e-04_r8,8.2306e-04_r8,7.9778e-04_r8,3.7474e-04_r8/)
      kbo(:, 2,37, 3) = (/ &
     &4.2453e-04_r8,9.6471e-04_r8,1.0505e-03_r8,9.7428e-04_r8,3.9893e-04_r8/)
      kbo(:, 3,37, 3) = (/ &
     &6.5002e-04_r8,1.2743e-03_r8,1.3189e-03_r8,1.1741e-03_r8,4.2011e-04_r8/)
      kbo(:, 4,37, 3) = (/ &
     &9.5041e-04_r8,1.6515e-03_r8,1.6323e-03_r8,1.3957e-03_r8,4.3822e-04_r8/)
      kbo(:, 5,37, 3) = (/ &
     &1.3379e-03_r8,2.1029e-03_r8,1.9967e-03_r8,1.6424e-03_r8,4.5330e-04_r8/)
      kbo(:, 1,38, 3) = (/ &
     &2.3216e-04_r8,6.1241e-04_r8,6.9804e-04_r8,6.7090e-04_r8,3.0479e-04_r8/)
      kbo(:, 2,38, 3) = (/ &
     &3.7692e-04_r8,8.3215e-04_r8,8.9807e-04_r8,8.2465e-04_r8,3.2506e-04_r8/)
      kbo(:, 3,38, 3) = (/ &
     &5.8109e-04_r8,1.1090e-03_r8,1.1350e-03_r8,9.9936e-04_r8,3.4289e-04_r8/)
      kbo(:, 4,38, 3) = (/ &
     &8.5435e-04_r8,1.4493e-03_r8,1.4148e-03_r8,1.1944e-03_r8,3.5825e-04_r8/)
      kbo(:, 5,38, 3) = (/ &
     &1.2083e-03_r8,1.8590e-03_r8,1.7421e-03_r8,1.4132e-03_r8,3.7105e-04_r8/)
      kbo(:, 1,39, 3) = (/ &
     &2.0931e-04_r8,5.3070e-04_r8,5.9845e-04_r8,5.6903e-04_r8,2.4791e-04_r8/)
      kbo(:, 2,39, 3) = (/ &
     &3.4220e-04_r8,7.2810e-04_r8,7.7651e-04_r8,7.0438e-04_r8,2.6488e-04_r8/)
      kbo(:, 3,39, 3) = (/ &
     &5.3115e-04_r8,9.8088e-04_r8,9.9044e-04_r8,8.5969e-04_r8,2.7995e-04_r8/)
      kbo(:, 4,39, 3) = (/ &
     &7.8539e-04_r8,1.2946e-03_r8,1.2451e-03_r8,1.0342e-03_r8,2.9299e-04_r8/)
      kbo(:, 5,39, 3) = (/ &
     &1.1164e-03_r8,1.6738e-03_r8,1.5453e-03_r8,1.2315e-03_r8,3.0388e-04_r8/)
      kbo(:, 1,40, 3) = (/ &
     &1.6775e-04_r8,4.2853e-04_r8,4.8421e-04_r8,4.6094e-04_r8,1.9976e-04_r8/)
      kbo(:, 2,40, 3) = (/ &
     &2.7762e-04_r8,5.9348e-04_r8,6.3343e-04_r8,5.7451e-04_r8,2.1416e-04_r8/)
      kbo(:, 3,40, 3) = (/ &
     &4.3621e-04_r8,8.0667e-04_r8,8.1437e-04_r8,7.0551e-04_r8,2.2701e-04_r8/)
      kbo(:, 4,40, 3) = (/ &
     &6.5215e-04_r8,1.0751e-03_r8,1.0317e-03_r8,8.5401e-04_r8,2.3821e-04_r8/)
      kbo(:, 5,40, 3) = (/ &
     &9.3504e-04_r8,1.4004e-03_r8,1.2886e-03_r8,1.0222e-03_r8,2.4759e-04_r8/)
      kbo(:, 1,41, 3) = (/ &
     &1.3280e-04_r8,3.4319e-04_r8,3.8888e-04_r8,3.7131e-04_r8,1.6067e-04_r8/)
      kbo(:, 2,41, 3) = (/ &
     &2.2274e-04_r8,4.8016e-04_r8,5.1341e-04_r8,4.6640e-04_r8,1.7291e-04_r8/)
      kbo(:, 3,41, 3) = (/ &
     &3.5456e-04_r8,6.5866e-04_r8,6.6545e-04_r8,5.7628e-04_r8,1.8383e-04_r8/)
      kbo(:, 4,41, 3) = (/ &
     &5.3629e-04_r8,8.8588e-04_r8,8.4970e-04_r8,7.0181e-04_r8,1.9338e-04_r8/)
      kbo(:, 5,41, 3) = (/ &
     &7.7683e-04_r8,1.1654e-03_r8,1.0693e-03_r8,8.4547e-04_r8,2.0151e-04_r8/)
      kbo(:, 1,42, 3) = (/ &
     &1.0593e-04_r8,2.7588e-04_r8,3.1299e-04_r8,2.9948e-04_r8,1.2916e-04_r8/)
      kbo(:, 2,42, 3) = (/ &
     &1.8005e-04_r8,3.9002e-04_r8,4.1742e-04_r8,3.7944e-04_r8,1.3949e-04_r8/)
      kbo(:, 3,42, 3) = (/ &
     &2.9034e-04_r8,5.4056e-04_r8,5.4599e-04_r8,4.7208e-04_r8,1.4879e-04_r8/)
      kbo(:, 4,42, 3) = (/ &
     &4.4476e-04_r8,7.3427e-04_r8,7.0341e-04_r8,5.7900e-04_r8,1.5686e-04_r8/)
      kbo(:, 5,42, 3) = (/ &
     &6.5058e-04_r8,9.7580e-04_r8,8.9207e-04_r8,7.0236e-04_r8,1.6390e-04_r8/)
      kbo(:, 1,43, 3) = (/ &
     &8.2227e-05_r8,2.1779e-04_r8,2.4797e-04_r8,2.3838e-04_r8,1.0321e-04_r8/)
      kbo(:, 2,43, 3) = (/ &
     &1.4211e-04_r8,3.1159e-04_r8,3.3460e-04_r8,3.0498e-04_r8,1.1196e-04_r8/)
      kbo(:, 3,43, 3) = (/ &
     &2.3284e-04_r8,4.3690e-04_r8,4.4252e-04_r8,3.8287e-04_r8,1.1989e-04_r8/)
      kbo(:, 4,43, 3) = (/ &
     &3.6233e-04_r8,6.0081e-04_r8,5.7601e-04_r8,4.7373e-04_r8,1.2682e-04_r8/)
      kbo(:, 5,43, 3) = (/ &
     &5.3702e-04_r8,8.0864e-04_r8,7.3797e-04_r8,5.7931e-04_r8,1.3294e-04_r8/)
      kbo(:, 1,44, 3) = (/ &
     &6.3384e-05_r8,1.7094e-04_r8,1.9525e-04_r8,1.8879e-04_r8,8.2201e-05_r8/)
      kbo(:, 2,44, 3) = (/ &
     &1.1160e-04_r8,2.4797e-04_r8,2.6713e-04_r8,2.4425e-04_r8,8.9566e-05_r8/)
      kbo(:, 3,44, 3) = (/ &
     &1.8608e-04_r8,3.5211e-04_r8,3.5750e-04_r8,3.0979e-04_r8,9.6374e-05_r8/)
      kbo(:, 4,44, 3) = (/ &
     &2.9467e-04_r8,4.9085e-04_r8,4.7122e-04_r8,3.8724e-04_r8,1.0229e-04_r8/)
      kbo(:, 5,44, 3) = (/ &
     &4.4331e-04_r8,6.6909e-04_r8,6.1037e-04_r8,4.7753e-04_r8,1.0759e-04_r8/)
      kbo(:, 1,45, 3) = (/ &
     &4.9661e-05_r8,1.3506e-04_r8,1.5438e-04_r8,1.4993e-04_r8,6.5369e-05_r8/)
      kbo(:, 2,45, 3) = (/ &
     &8.8927e-05_r8,1.9883e-04_r8,2.1432e-04_r8,1.9642e-04_r8,7.1593e-05_r8/)
      kbo(:, 3,45, 3) = (/ &
     &1.5097e-04_r8,2.8657e-04_r8,2.9095e-04_r8,2.5226e-04_r8,7.7369e-05_r8/)
      kbo(:, 4,45, 3) = (/ &
     &2.4324e-04_r8,4.0505e-04_r8,3.8855e-04_r8,3.1866e-04_r8,8.2473e-05_r8/)
      kbo(:, 5,45, 3) = (/ &
     &3.7189e-04_r8,5.6030e-04_r8,5.1022e-04_r8,3.9740e-04_r8,8.7038e-05_r8/)
      kbo(:, 1,46, 3) = (/ &
     &3.8628e-05_r8,1.0586e-04_r8,1.2112e-04_r8,1.1814e-04_r8,5.1792e-05_r8/)
      kbo(:, 2,46, 3) = (/ &
     &7.0302e-05_r8,1.5840e-04_r8,1.7081e-04_r8,1.5701e-04_r8,5.7032e-05_r8/)
      kbo(:, 3,46, 3) = (/ &
     &1.2164e-04_r8,2.3200e-04_r8,2.3559e-04_r8,2.0456e-04_r8,6.1939e-05_r8/)
      kbo(:, 4,46, 3) = (/ &
     &1.9963e-04_r8,3.3271e-04_r8,3.1891e-04_r8,2.6146e-04_r8,6.6327e-05_r8/)
      kbo(:, 5,46, 3) = (/ &
     &3.1076e-04_r8,4.6749e-04_r8,4.2492e-04_r8,3.2997e-04_r8,7.0248e-05_r8/)
      kbo(:, 1,47, 3) = (/ &
     &2.8886e-05_r8,8.0656e-05_r8,9.2760e-05_r8,9.1121e-05_r8,4.0766e-05_r8/)
      kbo(:, 2,47, 3) = (/ &
     &5.3342e-05_r8,1.2263e-04_r8,1.3276e-04_r8,1.2283e-04_r8,4.5144e-05_r8/)
      kbo(:, 3,47, 3) = (/ &
     &9.4301e-05_r8,1.8266e-04_r8,1.8617e-04_r8,1.6258e-04_r8,4.9298e-05_r8/)
      kbo(:, 4,47, 3) = (/ &
     &1.5800e-04_r8,2.6616e-04_r8,2.5579e-04_r8,2.1061e-04_r8,5.3068e-05_r8/)
      kbo(:, 5,47, 3) = (/ &
     &2.5109e-04_r8,3.7981e-04_r8,3.4582e-04_r8,2.6887e-04_r8,5.6458e-05_r8/)
      kbo(:, 1,48, 3) = (/ &
     &2.2227e-05_r8,6.2023e-05_r8,7.1458e-05_r8,7.0462e-05_r8,3.1996e-05_r8/)
      kbo(:, 2,48, 3) = (/ &
     &4.1346e-05_r8,9.5908e-05_r8,1.0391e-04_r8,9.6415e-05_r8,3.5660e-05_r8/)
      kbo(:, 3,48, 3) = (/ &
     &7.4574e-05_r8,1.4557e-04_r8,1.4830e-04_r8,1.2990e-04_r8,3.9158e-05_r8/)
      kbo(:, 4,48, 3) = (/ &
     &1.2768e-04_r8,2.1605e-04_r8,2.0753e-04_r8,1.7110e-04_r8,4.2391e-05_r8/)
      kbo(:, 5,48, 3) = (/ &
     &2.0727e-04_r8,3.1336e-04_r8,2.8498e-04_r8,2.2145e-04_r8,4.5305e-05_r8/)
      kbo(:, 1,49, 3) = (/ &
     &1.7958e-05_r8,4.8535e-05_r8,5.5723e-05_r8,5.4851e-05_r8,2.5055e-05_r8/)
      kbo(:, 2,49, 3) = (/ &
     &3.3224e-05_r8,7.6396e-05_r8,8.2450e-05_r8,7.6323e-05_r8,2.8114e-05_r8/)
      kbo(:, 3,49, 3) = (/ &
     &6.0934e-05_r8,1.1837e-04_r8,1.1999e-04_r8,1.0483e-04_r8,3.1052e-05_r8/)
      kbo(:, 4,49, 3) = (/ &
     &1.0660e-04_r8,1.7943e-04_r8,1.7133e-04_r8,1.4083e-04_r8,3.3806e-05_r8/)
      kbo(:, 5,49, 3) = (/ &
     &1.7683e-04_r8,2.6555e-04_r8,2.4004e-04_r8,1.8562e-04_r8,3.6333e-05_r8/)
      kbo(:, 1,50, 3) = (/ &
     &1.4221e-05_r8,3.7289e-05_r8,4.2772e-05_r8,4.2112e-05_r8,1.9622e-05_r8/)
      kbo(:, 2,50, 3) = (/ &
     &2.5770e-05_r8,5.9303e-05_r8,6.4074e-05_r8,5.9411e-05_r8,2.2155e-05_r8/)
      kbo(:, 3,50, 3) = (/ &
     &4.7760e-05_r8,9.3560e-05_r8,9.4851e-05_r8,8.2933e-05_r8,2.4619e-05_r8/)
      kbo(:, 4,50, 3) = (/ &
     &8.5239e-05_r8,1.4440e-04_r8,1.3769e-04_r8,1.1329e-04_r8,2.6943e-05_r8/)
      kbo(:, 5,50, 3) = (/ &
     &1.4427e-04_r8,2.1753e-04_r8,1.9626e-04_r8,1.5178e-04_r8,2.9098e-05_r8/)
      kbo(:, 1,51, 3) = (/ &
     &1.1317e-05_r8,2.8454e-05_r8,3.2589e-05_r8,3.2092e-05_r8,1.5353e-05_r8/)
      kbo(:, 2,51, 3) = (/ &
     &1.9742e-05_r8,4.5457e-05_r8,4.9229e-05_r8,4.5791e-05_r8,1.7432e-05_r8/)
      kbo(:, 3,51, 3) = (/ &
     &3.6711e-05_r8,7.2714e-05_r8,7.3963e-05_r8,6.4841e-05_r8,1.9496e-05_r8/)
      kbo(:, 4,51, 3) = (/ &
     &6.6639e-05_r8,1.1416e-04_r8,1.0901e-04_r8,8.9977e-05_r8,2.1439e-05_r8/)
      kbo(:, 5,51, 3) = (/ &
     &1.1501e-04_r8,1.7496e-04_r8,1.5780e-04_r8,1.2232e-04_r8,2.3266e-05_r8/)
      kbo(:, 1,52, 3) = (/ &
     &9.5193e-06_r8,2.2151e-05_r8,2.5124e-05_r8,2.4603e-05_r8,1.1980e-05_r8/)
      kbo(:, 2,52, 3) = (/ &
     &1.5692e-05_r8,3.5362e-05_r8,3.8197e-05_r8,3.5510e-05_r8,1.3701e-05_r8/)
      kbo(:, 3,52, 3) = (/ &
     &2.8933e-05_r8,5.7282e-05_r8,5.8273e-05_r8,5.1019e-05_r8,1.5415e-05_r8/)
      kbo(:, 4,52, 3) = (/ &
     &5.3248e-05_r8,9.1604e-05_r8,8.7350e-05_r8,7.2017e-05_r8,1.7048e-05_r8/)
      kbo(:, 5,52, 3) = (/ &
     &9.3646e-05_r8,1.4304e-04_r8,1.2865e-04_r8,9.9576e-05_r8,1.8583e-05_r8/)
      kbo(:, 1,53, 3) = (/ &
     &8.6013e-06_r8,1.7806e-05_r8,1.9756e-05_r8,1.9080e-05_r8,9.3222e-06_r8/)
      kbo(:, 2,53, 3) = (/ &
     &1.3174e-05_r8,2.8179e-05_r8,3.0144e-05_r8,2.7850e-05_r8,1.0743e-05_r8/)
      kbo(:, 3,53, 3) = (/ &
     &2.3711e-05_r8,4.6162e-05_r8,4.6700e-05_r8,4.0629e-05_r8,1.2161e-05_r8/)
      kbo(:, 4,53, 3) = (/ &
     &4.4006e-05_r8,7.5218e-05_r8,7.1366e-05_r8,5.8426e-05_r8,1.3528e-05_r8/)
      kbo(:, 5,53, 3) = (/ &
     &7.8885e-05_r8,1.1994e-04_r8,1.0719e-04_r8,8.2389e-05_r8,1.4819e-05_r8/)
      kbo(:, 1,54, 3) = (/ &
     &6.9789e-06_r8,1.3437e-05_r8,1.4771e-05_r8,1.4238e-05_r8,7.2546e-06_r8/)
      kbo(:, 2,54, 3) = (/ &
     &9.9119e-06_r8,2.0811e-05_r8,2.2371e-05_r8,2.0824e-05_r8,8.4185e-06_r8/)
      kbo(:, 3,54, 3) = (/ &
     &1.7167e-05_r8,3.4065e-05_r8,3.4800e-05_r8,3.0574e-05_r8,9.5808e-06_r8/)
      kbo(:, 4,54, 3) = (/ &
     &3.1909e-05_r8,5.5956e-05_r8,5.3708e-05_r8,4.4436e-05_r8,1.0721e-05_r8/)
      kbo(:, 5,54, 3) = (/ &
     &5.8081e-05_r8,9.0422e-05_r8,8.1544e-05_r8,6.3307e-05_r8,1.1799e-05_r8/)
      kbo(:, 1,55, 3) = (/ &
     &5.3128e-06_r8,9.7390e-06_r8,1.0688e-05_r8,1.0358e-05_r8,5.6367e-06_r8/)
      kbo(:, 2,55, 3) = (/ &
     &6.9987e-06_r8,1.4672e-05_r8,1.5984e-05_r8,1.5113e-05_r8,6.5876e-06_r8/)
      kbo(:, 3,55, 3) = (/ &
     &1.1522e-05_r8,2.3785e-05_r8,2.4757e-05_r8,2.2203e-05_r8,7.5366e-06_r8/)
      kbo(:, 4,55, 3) = (/ &
     &2.1231e-05_r8,3.9099e-05_r8,3.8355e-05_r8,3.2404e-05_r8,8.4801e-06_r8/)
      kbo(:, 5,55, 3) = (/ &
     &3.9115e-05_r8,6.3594e-05_r8,5.8504e-05_r8,4.6398e-05_r8,9.3778e-06_r8/)
      kbo(:, 1,56, 3) = (/ &
     &4.1255e-06_r8,7.1364e-06_r8,7.7808e-06_r8,7.5482e-06_r8,4.3681e-06_r8/)
      kbo(:, 2,56, 3) = (/ &
     &5.0603e-06_r8,1.0419e-05_r8,1.1462e-05_r8,1.0974e-05_r8,5.1464e-06_r8/)
      kbo(:, 3,56, 3) = (/ &
     &7.8194e-06_r8,1.6631e-05_r8,1.7619e-05_r8,1.6112e-05_r8,5.9174e-06_r8/)
      kbo(:, 4,56, 3) = (/ &
     &1.4119e-05_r8,2.7308e-05_r8,2.7375e-05_r8,2.3608e-05_r8,6.6946e-06_r8/)
      kbo(:, 5,56, 3) = (/ &
     &2.6208e-05_r8,4.4637e-05_r8,4.1923e-05_r8,3.3985e-05_r8,7.4429e-06_r8/)
      kbo(:, 1,57, 3) = (/ &
     &3.2493e-06_r8,5.2971e-06_r8,5.6993e-06_r8,5.5117e-06_r8,3.3724e-06_r8/)
      kbo(:, 2,57, 3) = (/ &
     &3.7488e-06_r8,7.4571e-06_r8,8.2480e-06_r8,7.9737e-06_r8,4.0105e-06_r8/)
      kbo(:, 3,57, 3) = (/ &
     &5.3914e-06_r8,1.1658e-05_r8,1.2555e-05_r8,1.1685e-05_r8,4.6429e-06_r8/)
      kbo(:, 4,57, 3) = (/ &
     &9.4028e-06_r8,1.9067e-05_r8,1.9516e-05_r8,1.7175e-05_r8,5.2749e-06_r8/)
      kbo(:, 5,57, 3) = (/ &
     &1.7491e-05_r8,3.1266e-05_r8,3.0002e-05_r8,2.4856e-05_r8,5.8965e-06_r8/)
      kbo(:, 1,58, 3) = (/ &
     &6.8210e-07_r8,1.3006e-06_r8,1.7801e-06_r8,2.4088e-06_r8,2.6011e-06_r8/)
      kbo(:, 2,58, 3) = (/ &
     &7.5233e-07_r8,1.7695e-06_r8,2.5293e-06_r8,3.4612e-06_r8,3.1260e-06_r8/)
      kbo(:, 3,58, 3) = (/ &
     &1.0077e-06_r8,2.6981e-06_r8,3.8040e-06_r8,5.0545e-06_r8,3.6427e-06_r8/)
      kbo(:, 4,58, 3) = (/ &
     &1.6789e-06_r8,4.3767e-06_r8,5.8928e-06_r8,7.4329e-06_r8,4.1541e-06_r8/)
      kbo(:, 5,58, 3) = (/ &
     &3.1035e-06_r8,7.1707e-06_r8,9.0733e-06_r8,1.0789e-05_r8,4.6675e-06_r8/)
      kbo(:, 1,59, 3) = (/ &
     &6.5007e-07_r8,1.2934e-06_r8,1.7266e-06_r8,2.1835e-06_r8,2.0738e-06_r8/)
      kbo(:, 2,59, 3) = (/ &
     &7.0640e-07_r8,1.7649e-06_r8,2.4593e-06_r8,3.1227e-06_r8,2.5027e-06_r8/)
      kbo(:, 3,59, 3) = (/ &
     &9.2077e-07_r8,2.6612e-06_r8,3.6625e-06_r8,4.5103e-06_r8,2.9231e-06_r8/)
      kbo(:, 4,59, 3) = (/ &
     &1.5013e-06_r8,4.2541e-06_r8,5.5816e-06_r8,6.5373e-06_r8,3.3365e-06_r8/)
      kbo(:, 5,59, 3) = (/ &
     &2.7629e-06_r8,6.8551e-06_r8,8.4568e-06_r8,9.3583e-06_r8,3.7483e-06_r8/)
      kbo(:, 1,13, 4) = (/ &
     &6.7049e-02_r8,1.0578e-01_r8,1.2049e-01_r8,1.1447e-01_r8,5.3996e-02_r8/)
      kbo(:, 2,13, 4) = (/ &
     &1.2378e-01_r8,1.5839e-01_r8,1.6716e-01_r8,1.4967e-01_r8,5.8724e-02_r8/)
      kbo(:, 3,13, 4) = (/ &
     &2.1508e-01_r8,2.3357e-01_r8,2.2807e-01_r8,1.9256e-01_r8,6.3468e-02_r8/)
      kbo(:, 4,13, 4) = (/ &
     &3.4658e-01_r8,3.3547e-01_r8,3.0532e-01_r8,2.4368e-01_r8,6.7895e-02_r8/)
      kbo(:, 5,13, 4) = (/ &
     &5.1918e-01_r8,4.6542e-01_r8,4.0071e-01_r8,3.0351e-01_r8,7.2180e-02_r8/)
      kbo(:, 1,14, 4) = (/ &
     &3.7591e-02_r8,7.5935e-02_r8,8.9834e-02_r8,8.8154e-02_r8,4.7370e-02_r8/)
      kbo(:, 2,14, 4) = (/ &
     &6.9282e-02_r8,1.0939e-01_r8,1.2082e-01_r8,1.1264e-01_r8,5.1597e-02_r8/)
      kbo(:, 3,14, 4) = (/ &
     &1.1973e-01_r8,1.5456e-01_r8,1.5973e-01_r8,1.4179e-01_r8,5.5698e-02_r8/)
      kbo(:, 4,14, 4) = (/ &
     &1.9141e-01_r8,2.1319e-01_r8,2.0757e-01_r8,1.7567e-01_r8,5.9503e-02_r8/)
      kbo(:, 5,14, 4) = (/ &
     &2.8419e-01_r8,2.8689e-01_r8,2.6537e-01_r8,2.1426e-01_r8,6.3167e-02_r8/)
      kbo(:, 1,15, 4) = (/ &
     &2.1562e-02_r8,5.5383e-02_r8,6.7683e-02_r8,6.8583e-02_r8,4.1403e-02_r8/)
      kbo(:, 2,15, 4) = (/ &
     &3.9720e-02_r8,7.6977e-02_r8,8.8827e-02_r8,8.5804e-02_r8,4.5107e-02_r8/)
      kbo(:, 3,15, 4) = (/ &
     &6.8049e-02_r8,1.0522e-01_r8,1.1458e-01_r8,1.0592e-01_r8,4.8636e-02_r8/)
      kbo(:, 4,15, 4) = (/ &
     &1.0779e-01_r8,1.4096e-01_r8,1.4532e-01_r8,1.2906e-01_r8,5.1972e-02_r8/)
      kbo(:, 5,15, 4) = (/ &
     &1.5865e-01_r8,1.8497e-01_r8,1.8175e-01_r8,1.5501e-01_r8,5.5102e-02_r8/)
      kbo(:, 1,16, 4) = (/ &
     &1.4772e-02_r8,4.3932e-02_r8,5.4513e-02_r8,5.6391e-02_r8,3.6009e-02_r8/)
      kbo(:, 2,16, 4) = (/ &
     &2.7132e-02_r8,5.9972e-02_r8,7.0550e-02_r8,6.9709e-02_r8,3.9169e-02_r8/)
      kbo(:, 3,16, 4) = (/ &
     &4.6049e-02_r8,8.0444e-02_r8,8.9769e-02_r8,8.5125e-02_r8,4.2209e-02_r8/)
      kbo(:, 4,16, 4) = (/ &
     &7.2213e-02_r8,1.0588e-01_r8,1.1245e-01_r8,1.0271e-01_r8,4.5097e-02_r8/)
      kbo(:, 5,16, 4) = (/ &
     &1.0534e-01_r8,1.3693e-01_r8,1.3910e-01_r8,1.2239e-01_r8,4.7833e-02_r8/)
      kbo(:, 1,17, 4) = (/ &
     &1.0505e-02_r8,3.5195e-02_r8,4.4278e-02_r8,4.6677e-02_r8,3.1091e-02_r8/)
      kbo(:, 2,17, 4) = (/ &
     &1.9166e-02_r8,4.7335e-02_r8,5.6632e-02_r8,5.7162e-02_r8,3.3802e-02_r8/)
      kbo(:, 3,17, 4) = (/ &
     &3.2242e-02_r8,6.2594e-02_r8,7.1319e-02_r8,6.9208e-02_r8,3.6407e-02_r8/)
      kbo(:, 4,17, 4) = (/ &
     &4.9961e-02_r8,8.1341e-02_r8,8.8470e-02_r8,8.2810e-02_r8,3.8893e-02_r8/)
      kbo(:, 5,17, 4) = (/ &
     &7.2404e-02_r8,1.0400e-01_r8,1.0862e-01_r8,9.8084e-02_r8,4.1273e-02_r8/)
      kbo(:, 1,18, 4) = (/ &
     &7.6562e-03_r8,2.8333e-02_r8,3.6121e-02_r8,3.8835e-02_r8,2.6686e-02_r8/)
      kbo(:, 2,18, 4) = (/ &
     &1.3867e-02_r8,3.7676e-02_r8,4.5765e-02_r8,4.7147e-02_r8,2.9013e-02_r8/)
      kbo(:, 3,18, 4) = (/ &
     &2.3086e-02_r8,4.9274e-02_r8,5.7143e-02_r8,5.6661e-02_r8,3.1231e-02_r8/)
      kbo(:, 4,18, 4) = (/ &
     &3.5350e-02_r8,6.3412e-02_r8,7.0379e-02_r8,6.7363e-02_r8,3.3367e-02_r8/)
      kbo(:, 5,18, 4) = (/ &
     &5.0974e-02_r8,8.0253e-02_r8,8.5775e-02_r8,7.9284e-02_r8,3.5380e-02_r8/)
      kbo(:, 1,19, 4) = (/ &
     &5.4803e-03_r8,2.2514e-02_r8,2.9208e-02_r8,3.2099e-02_r8,2.2789e-02_r8/)
      kbo(:, 2,19, 4) = (/ &
     &9.8317e-03_r8,2.9614e-02_r8,3.6650e-02_r8,3.8632e-02_r8,2.4757e-02_r8/)
      kbo(:, 3,19, 4) = (/ &
     &1.6184e-02_r8,3.8312e-02_r8,4.5365e-02_r8,4.6081e-02_r8,2.6634e-02_r8/)
      kbo(:, 4,19, 4) = (/ &
     &2.4529e-02_r8,4.8776e-02_r8,5.5440e-02_r8,5.4451e-02_r8,2.8434e-02_r8/)
      kbo(:, 5,19, 4) = (/ &
     &3.5233e-02_r8,6.1231e-02_r8,6.7107e-02_r8,6.3779e-02_r8,3.0105e-02_r8/)
      kbo(:, 1,20, 4) = (/ &
     &4.2828e-03_r8,1.8555e-02_r8,2.4277e-02_r8,2.6995e-02_r8,1.9406e-02_r8/)
      kbo(:, 2,20, 4) = (/ &
     &7.5931e-03_r8,2.4236e-02_r8,3.0290e-02_r8,3.2347e-02_r8,2.1050e-02_r8/)
      kbo(:, 3,20, 4) = (/ &
     &1.2330e-02_r8,3.1123e-02_r8,3.7288e-02_r8,3.8414e-02_r8,2.2621e-02_r8/)
      kbo(:, 4,20, 4) = (/ &
     &1.8510e-02_r8,3.9358e-02_r8,4.5374e-02_r8,4.5224e-02_r8,2.4107e-02_r8/)
      kbo(:, 5,20, 4) = (/ &
     &2.6546e-02_r8,4.9149e-02_r8,5.4720e-02_r8,5.2789e-02_r8,2.5443e-02_r8/)
      kbo(:, 1,21, 4) = (/ &
     &3.4446e-03_r8,1.5454e-02_r8,2.0322e-02_r8,2.2766e-02_r8,1.6445e-02_r8/)
      kbo(:, 2,21, 4) = (/ &
     &6.0284e-03_r8,2.0063e-02_r8,2.5258e-02_r8,2.7191e-02_r8,1.7819e-02_r8/)
      kbo(:, 3,21, 4) = (/ &
     &9.6698e-03_r8,2.5633e-02_r8,3.0993e-02_r8,3.2202e-02_r8,1.9116e-02_r8/)
      kbo(:, 4,21, 4) = (/ &
     &1.4416e-02_r8,3.2230e-02_r8,3.7573e-02_r8,3.7789e-02_r8,2.0305e-02_r8/)
      kbo(:, 5,21, 4) = (/ &
     &2.0653e-02_r8,4.0104e-02_r8,4.5153e-02_r8,4.3956e-02_r8,2.1322e-02_r8/)
      kbo(:, 1,22, 4) = (/ &
     &2.9417e-03_r8,1.3191e-02_r8,1.7364e-02_r8,1.9451e-02_r8,1.3960e-02_r8/)
      kbo(:, 2,22, 4) = (/ &
     &5.0614e-03_r8,1.7031e-02_r8,2.1496e-02_r8,2.3163e-02_r8,1.5084e-02_r8/)
      kbo(:, 3,22, 4) = (/ &
     &7.9857e-03_r8,2.1643e-02_r8,2.6269e-02_r8,2.7349e-02_r8,1.6128e-02_r8/)
      kbo(:, 4,22, 4) = (/ &
     &1.1815e-02_r8,2.7096e-02_r8,3.1716e-02_r8,3.1974e-02_r8,1.7035e-02_r8/)
      kbo(:, 5,22, 4) = (/ &
     &1.6874e-02_r8,3.3630e-02_r8,3.8023e-02_r8,3.7066e-02_r8,1.7780e-02_r8/)
      kbo(:, 1,23, 4) = (/ &
     &2.5270e-03_r8,1.1266e-02_r8,1.4840e-02_r8,1.6589e-02_r8,1.1804e-02_r8/)
      kbo(:, 2,23, 4) = (/ &
     &4.2729e-03_r8,1.4464e-02_r8,1.8293e-02_r8,1.9688e-02_r8,1.2713e-02_r8/)
      kbo(:, 3,23, 4) = (/ &
     &6.6524e-03_r8,1.8294e-02_r8,2.2254e-02_r8,2.3162e-02_r8,1.3520e-02_r8/)
      kbo(:, 4,23, 4) = (/ &
     &9.7631e-03_r8,2.2820e-02_r8,2.6759e-02_r8,2.6972e-02_r8,1.4190e-02_r8/)
      kbo(:, 5,23, 4) = (/ &
     &1.3880e-02_r8,2.8296e-02_r8,3.2015e-02_r8,3.1138e-02_r8,1.4756e-02_r8/)
      kbo(:, 1,24, 4) = (/ &
     &2.1649e-03_r8,9.5893e-03_r8,1.2641e-02_r8,1.4093e-02_r8,9.9437e-03_r8/)
      kbo(:, 2,24, 4) = (/ &
     &3.5984e-03_r8,1.2238e-02_r8,1.5497e-02_r8,1.6660e-02_r8,1.0660e-02_r8/)
      kbo(:, 3,24, 4) = (/ &
     &5.5343e-03_r8,1.5407e-02_r8,1.8761e-02_r8,1.9506e-02_r8,1.1265e-02_r8/)
      kbo(:, 4,24, 4) = (/ &
     &8.0630e-03_r8,1.9178e-02_r8,2.2493e-02_r8,2.2596e-02_r8,1.1775e-02_r8/)
      kbo(:, 5,24, 4) = (/ &
     &1.1384e-02_r8,2.3746e-02_r8,2.6831e-02_r8,2.5965e-02_r8,1.2211e-02_r8/)
      kbo(:, 1,25, 4) = (/ &
     &1.8852e-03_r8,8.1978e-03_r8,1.0793e-02_r8,1.1983e-02_r8,8.3500e-03_r8/)
      kbo(:, 2,25, 4) = (/ &
     &3.0822e-03_r8,1.0410e-02_r8,1.3161e-02_r8,1.4105e-02_r8,8.8930e-03_r8/)
      kbo(:, 3,25, 4) = (/ &
     &4.6788e-03_r8,1.3060e-02_r8,1.5866e-02_r8,1.6423e-02_r8,9.3555e-03_r8/)
      kbo(:, 4,25, 4) = (/ &
     &6.7672e-03_r8,1.6246e-02_r8,1.8965e-02_r8,1.8919e-02_r8,9.7508e-03_r8/)
      kbo(:, 5,25, 4) = (/ &
     &9.4703e-03_r8,2.0069e-02_r8,2.2560e-02_r8,2.1660e-02_r8,1.0087e-02_r8/)
      kbo(:, 1,26, 4) = (/ &
     &1.6838e-03_r8,7.0691e-03_r8,9.2649e-03_r8,1.0222e-02_r8,6.9856e-03_r8/)
      kbo(:, 2,26, 4) = (/ &
     &2.7021e-03_r8,8.9432e-03_r8,1.1240e-02_r8,1.1970e-02_r8,7.4013e-03_r8/)
      kbo(:, 3,26, 4) = (/ &
     &4.0452e-03_r8,1.1195e-02_r8,1.3497e-02_r8,1.3851e-02_r8,7.7588e-03_r8/)
      kbo(:, 4,26, 4) = (/ &
     &5.8017e-03_r8,1.3912e-02_r8,1.6094e-02_r8,1.5906e-02_r8,8.0669e-03_r8/)
      kbo(:, 5,26, 4) = (/ &
     &8.0448e-03_r8,1.7140e-02_r8,1.9095e-02_r8,1.8175e-02_r8,8.3263e-03_r8/)
      kbo(:, 1,27, 4) = (/ &
     &1.5607e-03_r8,6.1890e-03_r8,8.0258e-03_r8,8.7683e-03_r8,5.8228e-03_r8/)
      kbo(:, 2,27, 4) = (/ &
     &2.4561e-03_r8,7.8183e-03_r8,9.7010e-03_r8,1.0217e-02_r8,6.1459e-03_r8/)
      kbo(:, 3,27, 4) = (/ &
     &3.6253e-03_r8,9.7806e-03_r8,1.1625e-02_r8,1.1787e-02_r8,6.4270e-03_r8/)
      kbo(:, 4,27, 4) = (/ &
     &5.1578e-03_r8,1.2146e-02_r8,1.3856e-02_r8,1.3525e-02_r8,6.6670e-03_r8/)
      kbo(:, 5,27, 4) = (/ &
     &7.0917e-03_r8,1.4929e-02_r8,1.6419e-02_r8,1.5452e-02_r8,6.8676e-03_r8/)
      kbo(:, 1,28, 4) = (/ &
     &1.4790e-03_r8,5.4823e-03_r8,6.9976e-03_r8,7.5478e-03_r8,4.8444e-03_r8/)
      kbo(:, 2,28, 4) = (/ &
     &2.2841e-03_r8,6.9262e-03_r8,8.4418e-03_r8,8.7670e-03_r8,5.0989e-03_r8/)
      kbo(:, 3,28, 4) = (/ &
     &3.3280e-03_r8,8.6594e-03_r8,1.0117e-02_r8,1.0108e-02_r8,5.3174e-03_r8/)
      kbo(:, 4,28, 4) = (/ &
     &4.7002e-03_r8,1.0747e-02_r8,1.2065e-02_r8,1.1610e-02_r8,5.5053e-03_r8/)
      kbo(:, 5,28, 4) = (/ &
     &6.4216e-03_r8,1.3181e-02_r8,1.4294e-02_r8,1.3272e-02_r8,5.6597e-03_r8/)
      kbo(:, 1,29, 4) = (/ &
     &1.4846e-03_r8,5.0115e-03_r8,6.2330e-03_r8,6.5969e-03_r8,4.0271e-03_r8/)
      kbo(:, 2,29, 4) = (/ &
     &2.2530e-03_r8,6.3449e-03_r8,7.5362e-03_r8,7.6648e-03_r8,4.2267e-03_r8/)
      kbo(:, 3,29, 4) = (/ &
     &3.2510e-03_r8,7.9458e-03_r8,9.0603e-03_r8,8.8629e-03_r8,4.3989e-03_r8/)
      kbo(:, 4,29, 4) = (/ &
     &4.5516e-03_r8,9.8569e-03_r8,1.0828e-02_r8,1.0206e-02_r8,4.5467e-03_r8/)
      kbo(:, 5,29, 4) = (/ &
     &6.1805e-03_r8,1.2091e-02_r8,1.2839e-02_r8,1.1688e-02_r8,4.6649e-03_r8/)
      kbo(:, 1,30, 4) = (/ &
     &1.5199e-03_r8,4.6536e-03_r8,5.6184e-03_r8,5.8111e-03_r8,3.3446e-03_r8/)
      kbo(:, 2,30, 4) = (/ &
     &2.2691e-03_r8,5.9027e-03_r8,6.8239e-03_r8,6.7733e-03_r8,3.5018e-03_r8/)
      kbo(:, 3,30, 4) = (/ &
     &3.2488e-03_r8,7.4072e-03_r8,8.2321e-03_r8,7.8632e-03_r8,3.6376e-03_r8/)
      kbo(:, 4,30, 4) = (/ &
     &4.5119e-03_r8,9.1886e-03_r8,9.8595e-03_r8,9.0823e-03_r8,3.7530e-03_r8/)
      kbo(:, 5,30, 4) = (/ &
     &6.0862e-03_r8,1.1295e-02_r8,1.1709e-02_r8,1.0421e-02_r8,3.8437e-03_r8/)
      kbo(:, 1,31, 4) = (/ &
     &1.6311e-03_r8,4.4648e-03_r8,5.2027e-03_r8,5.2222e-03_r8,2.7768e-03_r8/)
      kbo(:, 2,31, 4) = (/ &
     &2.3988e-03_r8,5.6776e-03_r8,6.3545e-03_r8,6.1217e-03_r8,2.9011e-03_r8/)
      kbo(:, 3,31, 4) = (/ &
     &3.4145e-03_r8,7.1414e-03_r8,7.7030e-03_r8,7.1444e-03_r8,3.0093e-03_r8/)
      kbo(:, 4,31, 4) = (/ &
     &4.7033e-03_r8,8.8852e-03_r8,9.2526e-03_r8,8.2855e-03_r8,3.0977e-03_r8/)
      kbo(:, 5,31, 4) = (/ &
     &6.2907e-03_r8,1.0964e-02_r8,1.1034e-02_r8,9.5381e-03_r8,3.1698e-03_r8/)
      kbo(:, 1,32, 4) = (/ &
     &1.7646e-03_r8,4.3392e-03_r8,4.8857e-03_r8,4.7446e-03_r8,2.3054e-03_r8/)
      kbo(:, 2,32, 4) = (/ &
     &2.5651e-03_r8,5.5295e-03_r8,5.9929e-03_r8,5.5951e-03_r8,2.4036e-03_r8/)
      kbo(:, 3,32, 4) = (/ &
     &3.6260e-03_r8,6.9759e-03_r8,7.2903e-03_r8,6.5646e-03_r8,2.4876e-03_r8/)
      kbo(:, 4,32, 4) = (/ &
     &4.9515e-03_r8,8.7151e-03_r8,8.7927e-03_r8,7.6385e-03_r8,2.5574e-03_r8/)
      kbo(:, 5,32, 4) = (/ &
     &6.5598e-03_r8,1.0782e-02_r8,1.0540e-02_r8,8.8332e-03_r8,2.6142e-03_r8/)
      kbo(:, 1,33, 4) = (/ &
     &1.9374e-03_r8,4.2874e-03_r8,4.6591e-03_r8,4.3717e-03_r8,1.9130e-03_r8/)
      kbo(:, 2,33, 4) = (/ &
     &2.7949e-03_r8,5.4803e-03_r8,5.7408e-03_r8,5.1902e-03_r8,1.9904e-03_r8/)
      kbo(:, 3,33, 4) = (/ &
     &3.9103e-03_r8,6.9411e-03_r8,7.0122e-03_r8,6.1134e-03_r8,2.0570e-03_r8/)
      kbo(:, 4,33, 4) = (/ &
     &5.2898e-03_r8,8.7072e-03_r8,8.5064e-03_r8,7.1438e-03_r8,2.1115e-03_r8/)
      kbo(:, 5,33, 4) = (/ &
     &6.9527e-03_r8,1.0788e-02_r8,1.0239e-02_r8,8.3069e-03_r8,2.1568e-03_r8/)
      kbo(:, 1,34, 4) = (/ &
     &2.0406e-03_r8,4.1540e-03_r8,4.3826e-03_r8,3.9946e-03_r8,1.5845e-03_r8/)
      kbo(:, 2,34, 4) = (/ &
     &2.9261e-03_r8,5.3300e-03_r8,5.4194e-03_r8,4.7632e-03_r8,1.6461e-03_r8/)
      kbo(:, 3,34, 4) = (/ &
     &4.0546e-03_r8,6.7773e-03_r8,6.6513e-03_r8,5.6287e-03_r8,1.6983e-03_r8/)
      kbo(:, 4,34, 4) = (/ &
     &5.4348e-03_r8,8.5143e-03_r8,8.1040e-03_r8,6.6107e-03_r8,1.7421e-03_r8/)
      kbo(:, 5,34, 4) = (/ &
     &7.1060e-03_r8,1.0544e-02_r8,9.7699e-03_r8,7.7212e-03_r8,1.7780e-03_r8/)
      kbo(:, 1,35, 4) = (/ &
     &2.0728e-03_r8,3.9485e-03_r8,4.0574e-03_r8,3.6081e-03_r8,1.3068e-03_r8/)
      kbo(:, 2,35, 4) = (/ &
     &2.9602e-03_r8,5.0932e-03_r8,5.0438e-03_r8,4.3192e-03_r8,1.3565e-03_r8/)
      kbo(:, 3,35, 4) = (/ &
     &4.0769e-03_r8,6.5016e-03_r8,6.2270e-03_r8,5.1307e-03_r8,1.3990e-03_r8/)
      kbo(:, 4,35, 4) = (/ &
     &5.4354e-03_r8,8.1764e-03_r8,7.6137e-03_r8,6.0597e-03_r8,1.4343e-03_r8/)
      kbo(:, 5,35, 4) = (/ &
     &7.0821e-03_r8,1.0134e-02_r8,9.1905e-03_r8,7.1011e-03_r8,1.4630e-03_r8/)
      kbo(:, 1,36, 4) = (/ &
     &2.0103e-03_r8,3.6479e-03_r8,3.6691e-03_r8,3.1952e-03_r8,1.0729e-03_r8/)
      kbo(:, 2,36, 4) = (/ &
     &2.8662e-03_r8,4.7338e-03_r8,4.5904e-03_r8,3.8448e-03_r8,1.1132e-03_r8/)
      kbo(:, 3,36, 4) = (/ &
     &3.9368e-03_r8,6.0663e-03_r8,5.7008e-03_r8,4.5973e-03_r8,1.1487e-03_r8/)
      kbo(:, 4,36, 4) = (/ &
     &5.2410e-03_r8,7.6444e-03_r8,6.9919e-03_r8,5.4585e-03_r8,1.1779e-03_r8/)
      kbo(:, 5,36, 4) = (/ &
     &6.8204e-03_r8,9.5005e-03_r8,8.4610e-03_r8,6.4164e-03_r8,1.2022e-03_r8/)
      kbo(:, 1,37, 4) = (/ &
     &1.7959e-03_r8,3.1864e-03_r8,3.1663e-03_r8,2.7239e-03_r8,8.7469e-04_r8/)
      kbo(:, 2,37, 4) = (/ &
     &2.5697e-03_r8,4.1617e-03_r8,3.9876e-03_r8,3.2966e-03_r8,9.0931e-04_r8/)
      kbo(:, 3,37, 4) = (/ &
     &3.5391e-03_r8,5.3610e-03_r8,4.9818e-03_r8,3.9676e-03_r8,9.3897e-04_r8/)
      kbo(:, 4,37, 4) = (/ &
     &4.7240e-03_r8,6.7847e-03_r8,6.1364e-03_r8,4.7358e-03_r8,9.6399e-04_r8/)
      kbo(:, 5,37, 4) = (/ &
     &6.1586e-03_r8,8.4655e-03_r8,7.4564e-03_r8,5.5875e-03_r8,9.8533e-04_r8/)
      kbo(:, 1,38, 4) = (/ &
     &1.6221e-03_r8,2.8081e-03_r8,2.7522e-03_r8,2.3347e-03_r8,7.1314e-04_r8/)
      kbo(:, 2,38, 4) = (/ &
     &2.3291e-03_r8,3.6929e-03_r8,3.4899e-03_r8,2.8446e-03_r8,7.4249e-04_r8/)
      kbo(:, 3,38, 4) = (/ &
     &3.2190e-03_r8,4.7846e-03_r8,4.3892e-03_r8,3.4480e-03_r8,7.6765e-04_r8/)
      kbo(:, 4,38, 4) = (/ &
     &4.3100e-03_r8,6.0843e-03_r8,5.4322e-03_r8,4.1379e-03_r8,7.8970e-04_r8/)
      kbo(:, 5,38, 4) = (/ &
     &5.6295e-03_r8,7.6227e-03_r8,6.6325e-03_r8,4.9024e-03_r8,8.0762e-04_r8/)
      kbo(:, 1,39, 4) = (/ &
     &1.4985e-03_r8,2.5181e-03_r8,2.4272e-03_r8,2.0247e-03_r8,5.8188e-04_r8/)
      kbo(:, 2,39, 4) = (/ &
     &2.1580e-03_r8,3.3353e-03_r8,3.1025e-03_r8,2.4863e-03_r8,6.0647e-04_r8/)
      kbo(:, 3,39, 4) = (/ &
     &2.9946e-03_r8,4.3491e-03_r8,3.9298e-03_r8,3.0357e-03_r8,6.2817e-04_r8/)
      kbo(:, 4,39, 4) = (/ &
     &4.0211e-03_r8,5.5590e-03_r8,4.8918e-03_r8,3.6649e-03_r8,6.4668e-04_r8/)
      kbo(:, 5,39, 4) = (/ &
     &5.2642e-03_r8,6.9995e-03_r8,6.0040e-03_r8,4.3661e-03_r8,6.6239e-04_r8/)
      kbo(:, 1,40, 4) = (/ &
     &1.2480e-03_r8,2.0953e-03_r8,2.0102e-03_r8,1.6690e-03_r8,4.7210e-04_r8/)
      kbo(:, 2,40, 4) = (/ &
     &1.8115e-03_r8,2.7936e-03_r8,2.5861e-03_r8,2.0625e-03_r8,4.9296e-04_r8/)
      kbo(:, 3,40, 4) = (/ &
     &2.5332e-03_r8,3.6693e-03_r8,3.2977e-03_r8,2.5337e-03_r8,5.1142e-04_r8/)
      kbo(:, 4,40, 4) = (/ &
     &3.4226e-03_r8,4.7175e-03_r8,4.1297e-03_r8,3.0758e-03_r8,5.2719e-04_r8/)
      kbo(:, 5,40, 4) = (/ &
     &4.4988e-03_r8,5.9686e-03_r8,5.0929e-03_r8,3.6827e-03_r8,5.4108e-04_r8/)
      kbo(:, 1,41, 4) = (/ &
     &1.0279e-03_r8,1.7303e-03_r8,1.6546e-03_r8,1.3684e-03_r8,3.8259e-04_r8/)
      kbo(:, 2,41, 4) = (/ &
     &1.5100e-03_r8,2.3260e-03_r8,2.1442e-03_r8,1.7025e-03_r8,4.0029e-04_r8/)
      kbo(:, 3,41, 4) = (/ &
     &2.1257e-03_r8,3.0759e-03_r8,2.7514e-03_r8,2.1044e-03_r8,4.1598e-04_r8/)
      kbo(:, 4,41, 4) = (/ &
     &2.8920e-03_r8,3.9799e-03_r8,3.4670e-03_r8,2.5693e-03_r8,4.2980e-04_r8/)
      kbo(:, 5,41, 4) = (/ &
     &3.8245e-03_r8,5.0645e-03_r8,4.3009e-03_r8,3.0935e-03_r8,4.4154e-04_r8/)
      kbo(:, 1,42, 4) = (/ &
     &8.5248e-04_r8,1.4366e-03_r8,1.3681e-03_r8,1.1259e-03_r8,3.0986e-04_r8/)
      kbo(:, 2,42, 4) = (/ &
     &1.2693e-03_r8,1.9496e-03_r8,1.7879e-03_r8,1.4116e-03_r8,3.2494e-04_r8/)
      kbo(:, 3,42, 4) = (/ &
     &1.7992e-03_r8,2.5962e-03_r8,2.3093e-03_r8,1.7561e-03_r8,3.3826e-04_r8/)
      kbo(:, 4,42, 4) = (/ &
     &2.4657e-03_r8,3.3829e-03_r8,2.9302e-03_r8,2.1577e-03_r8,3.5033e-04_r8/)
      kbo(:, 5,42, 4) = (/ &
     &3.2835e-03_r8,4.3314e-03_r8,3.6581e-03_r8,2.6128e-03_r8,3.6051e-04_r8/)
      kbo(:, 1,43, 4) = (/ &
     &6.9299e-04_r8,1.1756e-03_r8,1.1172e-03_r8,9.1666e-04_r8,2.5008e-04_r8/)
      kbo(:, 2,43, 4) = (/ &
     &1.0504e-03_r8,1.6147e-03_r8,1.4746e-03_r8,1.1591e-03_r8,2.6296e-04_r8/)
      kbo(:, 3,43, 4) = (/ &
     &1.5042e-03_r8,2.1683e-03_r8,1.9190e-03_r8,1.4524e-03_r8,2.7439e-04_r8/)
      kbo(:, 4,43, 4) = (/ &
     &2.0819e-03_r8,2.8510e-03_r8,2.4566e-03_r8,1.7990e-03_r8,2.8482e-04_r8/)
      kbo(:, 5,43, 4) = (/ &
     &2.7959e-03_r8,3.6773e-03_r8,3.0899e-03_r8,2.1936e-03_r8,2.9376e-04_r8/)
      kbo(:, 1,44, 4) = (/ &
     &5.6092e-04_r8,9.5981e-04_r8,9.1038e-04_r8,7.4434e-04_r8,2.0138e-04_r8/)
      kbo(:, 2,44, 4) = (/ &
     &8.6869e-04_r8,1.3365e-03_r8,1.2153e-03_r8,9.5085e-04_r8,2.1240e-04_r8/)
      kbo(:, 3,44, 4) = (/ &
     &1.2605e-03_r8,1.8133e-03_r8,1.5968e-03_r8,1.2017e-03_r8,2.2220e-04_r8/)
      kbo(:, 4,44, 4) = (/ &
     &1.7639e-03_r8,2.4086e-03_r8,2.0630e-03_r8,1.5011e-03_r8,2.3130e-04_r8/)
      kbo(:, 5,44, 4) = (/ &
     &2.3892e-03_r8,3.1325e-03_r8,2.6172e-03_r8,1.8457e-03_r8,2.3904e-04_r8/)
      kbo(:, 1,45, 4) = (/ &
     &4.5956e-04_r8,7.9161e-04_r8,7.4840e-04_r8,6.0859e-04_r8,1.6203e-04_r8/)
      kbo(:, 2,45, 4) = (/ &
     &7.2822e-04_r8,1.1187e-03_r8,1.0117e-03_r8,7.8592e-04_r8,1.7142e-04_r8/)
      kbo(:, 3,45, 4) = (/ &
     &1.0767e-03_r8,1.5389e-03_r8,1.3458e-03_r8,1.0038e-03_r8,1.7986e-04_r8/)
      kbo(:, 4,45, 4) = (/ &
     &1.5195e-03_r8,2.0634e-03_r8,1.7544e-03_r8,1.2651e-03_r8,1.8773e-04_r8/)
      kbo(:, 5,45, 4) = (/ &
     &2.0790e-03_r8,2.7102e-03_r8,2.2473e-03_r8,1.5700e-03_r8,1.9451e-04_r8/)
      kbo(:, 1,46, 4) = (/ &
     &3.7292e-04_r8,6.4911e-04_r8,6.1209e-04_r8,4.9545e-04_r8,1.3008e-04_r8/)
      kbo(:, 2,46, 4) = (/ &
     &6.0673e-04_r8,9.3287e-04_r8,8.3976e-04_r8,6.4802e-04_r8,1.3811e-04_r8/)
      kbo(:, 3,46, 4) = (/ &
     &9.1635e-04_r8,1.3033e-03_r8,1.1323e-03_r8,8.3718e-04_r8,1.4541e-04_r8/)
      kbo(:, 4,46, 4) = (/ &
     &1.3083e-03_r8,1.7659e-03_r8,1.4916e-03_r8,1.0659e-03_r8,1.5214e-04_r8/)
      kbo(:, 5,46, 4) = (/ &
     &1.8099e-03_r8,2.3458e-03_r8,1.9309e-03_r8,1.3365e-03_r8,1.5810e-04_r8/)
      kbo(:, 1,47, 4) = (/ &
     &2.8950e-04_r8,5.1677e-04_r8,4.8802e-04_r8,3.9502e-04_r8,1.0398e-04_r8/)
      kbo(:, 2,47, 4) = (/ &
     &4.8670e-04_r8,7.5660e-04_r8,6.8049e-04_r8,5.2378e-04_r8,1.1085e-04_r8/)
      kbo(:, 3,47, 4) = (/ &
     &7.5525e-04_r8,1.0762e-03_r8,9.3123e-04_r8,6.8496e-04_r8,1.1715e-04_r8/)
      kbo(:, 4,47, 4) = (/ &
     &1.0969e-03_r8,1.4777e-03_r8,1.2426e-03_r8,8.8223e-04_r8,1.2295e-04_r8/)
      kbo(:, 5,47, 4) = (/ &
     &1.5354e-03_r8,1.9852e-03_r8,1.6256e-03_r8,1.1178e-03_r8,1.2805e-04_r8/)
      kbo(:, 1,48, 4) = (/ &
     &2.2732e-04_r8,4.1628e-04_r8,3.9316e-04_r8,3.1737e-04_r8,8.2969e-05_r8/)
      kbo(:, 2,48, 4) = (/ &
     &3.9696e-04_r8,6.2251e-04_r8,5.5852e-04_r8,4.2777e-04_r8,8.8908e-05_r8/)
      kbo(:, 3,48, 4) = (/ &
     &6.3462e-04_r8,9.0305e-04_r8,7.7729e-04_r8,5.6732e-04_r8,9.4308e-05_r8/)
      kbo(:, 4,48, 4) = (/ &
     &9.4204e-04_r8,1.2622e-03_r8,1.0539e-03_r8,7.4093e-04_r8,9.9236e-05_r8/)
      kbo(:, 5,48, 4) = (/ &
     &1.3331e-03_r8,1.7143e-03_r8,1.3938e-03_r8,9.4935e-04_r8,1.0368e-04_r8/)
      kbo(:, 1,49, 4) = (/ &
     &1.8300e-04_r8,3.4217e-04_r8,3.2264e-04_r8,2.5877e-04_r8,6.6118e-05_r8/)
      kbo(:, 2,49, 4) = (/ &
     &3.3312e-04_r8,5.2483e-04_r8,4.6829e-04_r8,3.5552e-04_r8,7.1194e-05_r8/)
      kbo(:, 3,49, 4) = (/ &
     &5.4973e-04_r8,7.7839e-04_r8,6.6473e-04_r8,4.7940e-04_r8,7.5813e-05_r8/)
      kbo(:, 4,49, 4) = (/ &
     &8.3663e-04_r8,1.1105e-03_r8,9.1800e-04_r8,6.3658e-04_r8,8.0100e-05_r8/)
      kbo(:, 5,49, 4) = (/ &
     &1.2004e-03_r8,1.5281e-03_r8,1.2307e-03_r8,8.2653e-04_r8,8.3935e-05_r8/)
      kbo(:, 1,50, 4) = (/ &
     &1.4039e-04_r8,2.7151e-04_r8,2.5713e-04_r8,2.0628e-04_r8,5.2648e-05_r8/)
      kbo(:, 2,50, 4) = (/ &
     &2.6610e-04_r8,4.2689e-04_r8,3.8091e-04_r8,2.8831e-04_r8,5.6961e-05_r8/)
      kbo(:, 3,50, 4) = (/ &
     &4.5427e-04_r8,6.4624e-04_r8,5.5025e-04_r8,3.9479e-04_r8,6.0907e-05_r8/)
      kbo(:, 4,50, 4) = (/ &
     &7.0950e-04_r8,9.4070e-04_r8,7.7361e-04_r8,5.3217e-04_r8,6.4571e-05_r8/)
      kbo(:, 5,50, 4) = (/ &
     &1.0374e-03_r8,1.3149e-03_r8,1.0530e-03_r8,7.0038e-04_r8,6.7890e-05_r8/)
      kbo(:, 1,51, 4) = (/ &
     &1.0489e-04_r8,2.1109e-04_r8,2.0141e-04_r8,1.6218e-04_r8,4.1878e-05_r8/)
      kbo(:, 2,51, 4) = (/ &
     &2.0633e-04_r8,3.4016e-04_r8,3.0444e-04_r8,2.3054e-04_r8,4.5538e-05_r8/)
      kbo(:, 3,51, 4) = (/ &
     &3.6536e-04_r8,5.2580e-04_r8,4.4746e-04_r8,3.2051e-04_r8,4.8874e-05_r8/)
      kbo(:, 4,51, 4) = (/ &
     &5.8696e-04_r8,7.8085e-04_r8,6.4023e-04_r8,4.3829e-04_r8,5.1997e-05_r8/)
      kbo(:, 5,51, 4) = (/ &
     &8.7556e-04_r8,1.1091e-03_r8,8.8460e-04_r8,5.8473e-04_r8,5.4858e-05_r8/)
      kbo(:, 1,52, 4) = (/ &
     &7.9793e-05_r8,1.6601e-04_r8,1.5918e-04_r8,1.2853e-04_r8,3.3276e-05_r8/)
      kbo(:, 2,52, 4) = (/ &
     &1.6247e-04_r8,2.7468e-04_r8,2.4631e-04_r8,1.8617e-04_r8,3.6357e-05_r8/)
      kbo(:, 3,52, 4) = (/ &
     &2.9905e-04_r8,4.3474e-04_r8,3.6924e-04_r8,2.6353e-04_r8,3.9196e-05_r8/)
      kbo(:, 4,52, 4) = (/ &
     &4.9530e-04_r8,6.5976e-04_r8,5.3847e-04_r8,3.6618e-04_r8,4.1839e-05_r8/)
      kbo(:, 5,52, 4) = (/ &
     &7.5546e-04_r8,9.5475e-04_r8,7.5721e-04_r8,4.9627e-04_r8,4.4317e-05_r8/)
      kbo(:, 1,53, 4) = (/ &
     &6.2729e-05_r8,1.3307e-04_r8,1.2792e-04_r8,1.0321e-04_r8,2.6401e-05_r8/)
      kbo(:, 2,53, 4) = (/ &
     &1.3138e-04_r8,2.2658e-04_r8,2.0324e-04_r8,1.5289e-04_r8,2.9006e-05_r8/)
      kbo(:, 3,53, 4) = (/ &
     &2.5160e-04_r8,3.6877e-04_r8,3.1205e-04_r8,2.2094e-04_r8,3.1410e-05_r8/)
      kbo(:, 4,53, 4) = (/ &
     &4.3128e-04_r8,5.7326e-04_r8,4.6479e-04_r8,3.1290e-04_r8,3.3663e-05_r8/)
      kbo(:, 5,53, 4) = (/ &
     &6.7436e-04_r8,8.4743e-04_r8,6.6688e-04_r8,4.3200e-04_r8,3.5790e-05_r8/)
      kbo(:, 1,54, 4) = (/ &
     &4.3536e-05_r8,9.6993e-05_r8,9.4650e-05_r8,7.7465e-05_r8,2.0921e-05_r8/)
      kbo(:, 2,54, 4) = (/ &
     &9.2752e-05_r8,1.6814e-04_r8,1.5268e-04_r8,1.1626e-04_r8,2.3103e-05_r8/)
      kbo(:, 3,54, 4) = (/ &
     &1.8378e-04_r8,2.7919e-04_r8,2.3835e-04_r8,1.7016e-04_r8,2.5121e-05_r8/)
      kbo(:, 4,54, 4) = (/ &
     &3.2645e-04_r8,4.4256e-04_r8,3.6033e-04_r8,2.4382e-04_r8,2.7012e-05_r8/)
      kbo(:, 5,54, 4) = (/ &
     &5.2349e-04_r8,6.6571e-04_r8,5.2497e-04_r8,3.4104e-04_r8,2.8788e-05_r8/)
      kbo(:, 1,55, 4) = (/ &
     &2.7968e-05_r8,6.6619e-05_r8,6.6506e-05_r8,5.5712e-05_r8,1.6550e-05_r8/)
      kbo(:, 2,55, 4) = (/ &
     &5.9858e-05_r8,1.1651e-04_r8,1.0803e-04_r8,8.4126e-05_r8,1.8363e-05_r8/)
      kbo(:, 3,55, 4) = (/ &
     &1.2216e-04_r8,1.9620e-04_r8,1.7047e-04_r8,1.2407e-04_r8,2.0057e-05_r8/)
      kbo(:, 4,55, 4) = (/ &
     &2.2490e-04_r8,3.1581e-04_r8,2.6032e-04_r8,1.7892e-04_r8,2.1634e-05_r8/)
      kbo(:, 5,55, 4) = (/ &
     &3.7032e-04_r8,4.8266e-04_r8,3.8398e-04_r8,2.5251e-04_r8,2.3108e-05_r8/)
      kbo(:, 1,56, 4) = (/ &
     &1.8187e-05_r8,4.5780e-05_r8,4.6700e-05_r8,4.0035e-05_r8,1.3073e-05_r8/)
      kbo(:, 2,56, 4) = (/ &
     &3.8391e-05_r8,8.0472e-05_r8,7.6243e-05_r8,6.0757e-05_r8,1.4582e-05_r8/)
      kbo(:, 3,56, 4) = (/ &
     &8.0424e-05_r8,1.3728e-04_r8,1.2154e-04_r8,9.0284e-05_r8,1.6006e-05_r8/)
      kbo(:, 4,56, 4) = (/ &
     &1.5350e-04_r8,2.2433e-04_r8,1.8750e-04_r8,1.3109e-04_r8,1.7305e-05_r8/)
      kbo(:, 5,56, 4) = (/ &
     &2.6031e-04_r8,3.4853e-04_r8,2.7994e-04_r8,1.8653e-04_r8,1.8526e-05_r8/)
      kbo(:, 1,57, 4) = (/ &
     &1.2069e-05_r8,3.1511e-05_r8,3.2815e-05_r8,2.8783e-05_r8,1.0310e-05_r8/)
      kbo(:, 2,57, 4) = (/ &
     &2.4551e-05_r8,5.5416e-05_r8,5.3688e-05_r8,4.3795e-05_r8,1.1563e-05_r8/)
      kbo(:, 3,57, 4) = (/ &
     &5.2372e-05_r8,9.5634e-05_r8,8.6379e-05_r8,6.5547e-05_r8,1.2748e-05_r8/)
      kbo(:, 4,57, 4) = (/ &
     &1.0355e-04_r8,1.5851e-04_r8,1.3458e-04_r8,9.5855e-05_r8,1.3838e-05_r8/)
      kbo(:, 5,57, 4) = (/ &
     &1.8156e-04_r8,2.5040e-04_r8,2.0330e-04_r8,1.3740e-04_r8,1.4854e-05_r8/)
      kbo(:, 1,58, 4) = (/ &
     &2.1923e-06_r8,7.1667e-06_r8,9.7990e-06_r8,1.2334e-05_r8,8.1331e-06_r8/)
      kbo(:, 2,58, 4) = (/ &
     &4.2014e-06_r8,1.2514e-05_r8,1.5980e-05_r8,1.8735e-05_r8,9.1661e-06_r8/)
      kbo(:, 3,58, 4) = (/ &
     &9.0349e-06_r8,2.1751e-05_r8,2.5847e-05_r8,2.8162e-05_r8,1.0154e-05_r8/)
      kbo(:, 4,58, 4) = (/ &
     &1.8408e-05_r8,3.6461e-05_r8,4.0575e-05_r8,4.1376e-05_r8,1.1069e-05_r8/)
      kbo(:, 5,58, 4) = (/ &
     &3.3398e-05_r8,5.8421e-05_r8,6.1871e-05_r8,5.9629e-05_r8,1.1910e-05_r8/)
      kbo(:, 1,59, 4) = (/ &
     &1.9895e-06_r8,7.0146e-06_r8,9.2666e-06_r8,1.0819e-05_r8,6.5530e-06_r8/)
      kbo(:, 2,59, 4) = (/ &
     &3.7103e-06_r8,1.1985e-05_r8,1.4798e-05_r8,1.6119e-05_r8,7.3922e-06_r8/)
      kbo(:, 3,59, 4) = (/ &
     &7.9795e-06_r8,2.0481e-05_r8,2.3504e-05_r8,2.3808e-05_r8,8.1931e-06_r8/)
      kbo(:, 4,59, 4) = (/ &
     &1.6446e-05_r8,3.3891e-05_r8,3.6329e-05_r8,3.4426e-05_r8,8.9453e-06_r8/)
      kbo(:, 5,59, 4) = (/ &
     &3.0202e-05_r8,5.3874e-05_r8,5.4799e-05_r8,4.8960e-05_r8,9.6374e-06_r8/)
      kbo(:, 1,13, 5) = (/ &
     &4.3236e-01_r8,4.3213e-01_r8,3.9701e-01_r8,3.2546e-01_r8,1.1197e-01_r8/)
      kbo(:, 2,13, 5) = (/ &
     &6.6372e-01_r8,6.1379e-01_r8,5.3578e-01_r8,4.1378e-01_r8,1.1749e-01_r8/)
      kbo(:, 3,13, 5) = (/ &
     &9.6012e-01_r8,8.4543e-01_r8,7.0690e-01_r8,5.2039e-01_r8,1.2229e-01_r8/)
      kbo(:, 4,13, 5) = (/ &
     &1.3340e+00_r8,1.1343e+00_r8,9.1491e-01_r8,6.4651e-01_r8,1.2717e-01_r8/)
      kbo(:, 5,13, 5) = (/ &
     &1.8059e+00_r8,1.4945e+00_r8,1.1687e+00_r8,7.9501e-01_r8,1.3200e-01_r8/)
      kbo(:, 1,14, 5) = (/ &
     &2.3576e-01_r8,2.7360e-01_r8,2.7141e-01_r8,2.4039e-01_r8,9.8792e-02_r8/)
      kbo(:, 2,14, 5) = (/ &
     &3.5903e-01_r8,3.7743e-01_r8,3.5638e-01_r8,2.9754e-01_r8,1.0359e-01_r8/)
      kbo(:, 3,14, 5) = (/ &
     &5.1761e-01_r8,5.0746e-01_r8,4.5981e-01_r8,3.6575e-01_r8,1.0816e-01_r8/)
      kbo(:, 4,14, 5) = (/ &
     &7.1963e-01_r8,6.6997e-01_r8,5.8434e-01_r8,4.4555e-01_r8,1.1272e-01_r8/)
      kbo(:, 5,14, 5) = (/ &
     &9.7673e-01_r8,8.7084e-01_r8,7.3356e-01_r8,5.3881e-01_r8,1.1732e-01_r8/)
      kbo(:, 1,15, 5) = (/ &
     &1.3110e-01_r8,1.8103e-01_r8,1.9281e-01_r8,1.8264e-01_r8,8.6582e-02_r8/)
      kbo(:, 2,15, 5) = (/ &
     &1.9817e-01_r8,2.4413e-01_r8,2.4684e-01_r8,2.2172e-01_r8,9.0925e-02_r8/)
      kbo(:, 3,15, 5) = (/ &
     &2.8519e-01_r8,3.2198e-01_r8,3.1178e-01_r8,2.6742e-01_r8,9.5231e-02_r8/)
      kbo(:, 4,15, 5) = (/ &
     &3.9693e-01_r8,4.1797e-01_r8,3.8987e-01_r8,3.1982e-01_r8,9.9470e-02_r8/)
      kbo(:, 5,15, 5) = (/ &
     &5.3979e-01_r8,5.3546e-01_r8,4.8283e-01_r8,3.8058e-01_r8,1.0367e-01_r8/)
      kbo(:, 1,16, 5) = (/ &
     &8.6780e-02_r8,1.3641e-01_r8,1.5186e-01_r8,1.4818e-01_r8,7.5514e-02_r8/)
      kbo(:, 2,16, 5) = (/ &
     &1.3047e-01_r8,1.8113e-01_r8,1.9135e-01_r8,1.7835e-01_r8,7.9533e-02_r8/)
      kbo(:, 3,16, 5) = (/ &
     &1.8753e-01_r8,2.3639e-01_r8,2.3875e-01_r8,2.1304e-01_r8,8.3481e-02_r8/)
      kbo(:, 4,16, 5) = (/ &
     &2.6140e-01_r8,3.0428e-01_r8,2.9551e-01_r8,2.5256e-01_r8,8.7293e-02_r8/)
      kbo(:, 5,16, 5) = (/ &
     &3.5574e-01_r8,3.8652e-01_r8,3.6267e-01_r8,2.9793e-01_r8,9.1094e-02_r8/)
      kbo(:, 1,17, 5) = (/ &
     &5.9400e-02_r8,1.0544e-01_r8,1.2175e-01_r8,1.2140e-01_r8,6.5571e-02_r8/)
      kbo(:, 2,17, 5) = (/ &
     &8.8982e-02_r8,1.3824e-01_r8,1.5175e-01_r8,1.4491e-01_r8,6.9197e-02_r8/)
      kbo(:, 3,17, 5) = (/ &
     &1.2788e-01_r8,1.7890e-01_r8,1.8755e-01_r8,1.7185e-01_r8,7.2708e-02_r8/)
      kbo(:, 4,17, 5) = (/ &
     &1.7835e-01_r8,2.2856e-01_r8,2.3024e-01_r8,2.0241e-01_r8,7.6161e-02_r8/)
      kbo(:, 5,17, 5) = (/ &
     &2.4297e-01_r8,2.8834e-01_r8,2.8043e-01_r8,2.3722e-01_r8,7.9603e-02_r8/)
      kbo(:, 1,18, 5) = (/ &
     &4.1651e-02_r8,8.2911e-02_r8,9.8455e-02_r8,9.9593e-02_r8,5.6662e-02_r8/)
      kbo(:, 2,18, 5) = (/ &
     &6.2251e-02_r8,1.0765e-01_r8,1.2173e-01_r8,1.1843e-01_r8,5.9831e-02_r8/)
      kbo(:, 3,18, 5) = (/ &
     &8.9419e-02_r8,1.3828e-01_r8,1.4944e-01_r8,1.3970e-01_r8,6.2923e-02_r8/)
      kbo(:, 4,18, 5) = (/ &
     &1.2470e-01_r8,1.7541e-01_r8,1.8216e-01_r8,1.6372e-01_r8,6.6077e-02_r8/)
      kbo(:, 5,18, 5) = (/ &
     &1.6992e-01_r8,2.1986e-01_r8,2.2047e-01_r8,1.9095e-01_r8,6.9212e-02_r8/)
      kbo(:, 1,19, 5) = (/ &
     &2.8717e-02_r8,6.4742e-02_r8,7.8819e-02_r8,8.0895e-02_r8,4.8664e-02_r8/)
      kbo(:, 2,19, 5) = (/ &
     &4.2849e-02_r8,8.3244e-02_r8,9.6815e-02_r8,9.5751e-02_r8,5.1433e-02_r8/)
      kbo(:, 3,19, 5) = (/ &
     &6.1454e-02_r8,1.0605e-01_r8,1.1801e-01_r8,1.1248e-01_r8,5.4215e-02_r8/)
      kbo(:, 4,19, 5) = (/ &
     &8.5699e-02_r8,1.3356e-01_r8,1.4292e-01_r8,1.3115e-01_r8,5.7031e-02_r8/)
      kbo(:, 5,19, 5) = (/ &
     &1.1681e-01_r8,1.6622e-01_r8,1.7182e-01_r8,1.5204e-01_r8,5.9790e-02_r8/)
      kbo(:, 1,20, 5) = (/ &
     &2.1632e-02_r8,5.2943e-02_r8,6.5235e-02_r8,6.7363e-02_r8,4.1610e-02_r8/)
      kbo(:, 2,20, 5) = (/ &
     &3.2163e-02_r8,6.7696e-02_r8,7.9852e-02_r8,7.9447e-02_r8,4.4062e-02_r8/)
      kbo(:, 3,20, 5) = (/ &
     &4.6057e-02_r8,8.5815e-02_r8,9.6980e-02_r8,9.3049e-02_r8,4.6553e-02_r8/)
      kbo(:, 4,20, 5) = (/ &
     &6.4136e-02_r8,1.0754e-01_r8,1.1694e-01_r8,1.0820e-01_r8,4.9013e-02_r8/)
      kbo(:, 5,20, 5) = (/ &
     &8.7379e-02_r8,1.3322e-01_r8,1.3995e-01_r8,1.2502e-01_r8,5.1455e-02_r8/)
      kbo(:, 1,21, 5) = (/ &
     &1.6823e-02_r8,4.3877e-02_r8,5.4527e-02_r8,5.6402e-02_r8,3.5455e-02_r8/)
      kbo(:, 2,21, 5) = (/ &
     &2.4936e-02_r8,5.5953e-02_r8,6.6511e-02_r8,6.6307e-02_r8,3.7602e-02_r8/)
      kbo(:, 3,21, 5) = (/ &
     &3.5634e-02_r8,7.0642e-02_r8,8.0513e-02_r8,7.7454e-02_r8,3.9786e-02_r8/)
      kbo(:, 4,21, 5) = (/ &
     &4.9531e-02_r8,8.8177e-02_r8,9.6745e-02_r8,8.9935e-02_r8,4.1920e-02_r8/)
      kbo(:, 5,21, 5) = (/ &
     &6.7455e-02_r8,1.0884e-01_r8,1.1539e-01_r8,1.0375e-01_r8,4.4030e-02_r8/)
      kbo(:, 1,22, 5) = (/ &
     &1.3789e-02_r8,3.7331e-02_r8,4.6413e-02_r8,4.7878e-02_r8,3.0220e-02_r8/)
      kbo(:, 2,22, 5) = (/ &
     &2.0294e-02_r8,4.7459e-02_r8,5.6444e-02_r8,5.6212e-02_r8,3.2091e-02_r8/)
      kbo(:, 3,22, 5) = (/ &
     &2.8887e-02_r8,5.9685e-02_r8,6.8142e-02_r8,6.5522e-02_r8,3.3949e-02_r8/)
      kbo(:, 4,22, 5) = (/ &
     &4.0024e-02_r8,7.4193e-02_r8,8.1621e-02_r8,7.5940e-02_r8,3.5793e-02_r8/)
      kbo(:, 5,22, 5) = (/ &
     &5.4487e-02_r8,9.1298e-02_r8,9.7079e-02_r8,8.7446e-02_r8,3.7515e-02_r8/)
      kbo(:, 1,23, 5) = (/ &
     &1.1373e-02_r8,3.1797e-02_r8,3.9445e-02_r8,4.0631e-02_r8,2.5676e-02_r8/)
      kbo(:, 2,23, 5) = (/ &
     &1.6630e-02_r8,4.0276e-02_r8,4.7874e-02_r8,4.7621e-02_r8,2.7276e-02_r8/)
      kbo(:, 3,23, 5) = (/ &
     &2.3572e-02_r8,5.0445e-02_r8,5.7632e-02_r8,5.5405e-02_r8,2.8857e-02_r8/)
      kbo(:, 4,23, 5) = (/ &
     &3.2590e-02_r8,6.2506e-02_r8,6.8883e-02_r8,6.4105e-02_r8,3.0360e-02_r8/)
      kbo(:, 5,23, 5) = (/ &
     &4.4383e-02_r8,7.6716e-02_r8,8.1703e-02_r8,7.3646e-02_r8,3.1632e-02_r8/)
      kbo(:, 1,24, 5) = (/ &
     &9.3521e-03_r8,2.6988e-02_r8,3.3405e-02_r8,3.4382e-02_r8,2.1758e-02_r8/)
      kbo(:, 2,24, 5) = (/ &
     &1.3592e-02_r8,3.4040e-02_r8,4.0452e-02_r8,4.0217e-02_r8,2.3106e-02_r8/)
      kbo(:, 3,24, 5) = (/ &
     &1.9190e-02_r8,4.2486e-02_r8,4.8570e-02_r8,4.6701e-02_r8,2.4399e-02_r8/)
      kbo(:, 4,24, 5) = (/ &
     &2.6527e-02_r8,5.2454e-02_r8,5.7886e-02_r8,5.3878e-02_r8,2.5528e-02_r8/)
      kbo(:, 5,24, 5) = (/ &
     &3.6127e-02_r8,6.4240e-02_r8,6.8480e-02_r8,6.1740e-02_r8,2.6418e-02_r8/)
      kbo(:, 1,25, 5) = (/ &
     &7.8143e-03_r8,2.3046e-02_r8,2.8423e-02_r8,2.9180e-02_r8,1.8391e-02_r8/)
      kbo(:, 2,25, 5) = (/ &
     &1.1292e-02_r8,2.8965e-02_r8,3.4350e-02_r8,3.4059e-02_r8,1.9498e-02_r8/)
      kbo(:, 3,25, 5) = (/ &
     &1.5906e-02_r8,3.6033e-02_r8,4.1158e-02_r8,3.9460e-02_r8,2.0484e-02_r8/)
      kbo(:, 4,25, 5) = (/ &
     &2.2015e-02_r8,4.4387e-02_r8,4.8915e-02_r8,4.5425e-02_r8,2.1291e-02_r8/)
      kbo(:, 5,25, 5) = (/ &
     &2.9929e-02_r8,5.4292e-02_r8,5.7748e-02_r8,5.1892e-02_r8,2.1939e-02_r8/)
      kbo(:, 1,26, 5) = (/ &
     &6.6841e-03_r8,1.9882e-02_r8,2.4386e-02_r8,2.4902e-02_r8,1.5507e-02_r8/)
      kbo(:, 2,26, 5) = (/ &
     &9.6187e-03_r8,2.4917e-02_r8,2.9404e-02_r8,2.8998e-02_r8,1.6368e-02_r8/)
      kbo(:, 3,26, 5) = (/ &
     &1.3541e-02_r8,3.0916e-02_r8,3.5147e-02_r8,3.3522e-02_r8,1.7088e-02_r8/)
      kbo(:, 4,26, 5) = (/ &
     &1.8734e-02_r8,3.8045e-02_r8,4.1676e-02_r8,3.8461e-02_r8,1.7679e-02_r8/)
      kbo(:, 5,26, 5) = (/ &
     &2.5382e-02_r8,4.6534e-02_r8,4.9183e-02_r8,4.3795e-02_r8,1.8164e-02_r8/)
      kbo(:, 1,27, 5) = (/ &
     &5.9464e-03_r8,1.7461e-02_r8,2.1207e-02_r8,2.1457e-02_r8,1.3019e-02_r8/)
      kbo(:, 2,27, 5) = (/ &
     &8.5411e-03_r8,2.1855e-02_r8,2.5534e-02_r8,2.4945e-02_r8,1.3658e-02_r8/)
      kbo(:, 3,27, 5) = (/ &
     &1.2012e-02_r8,2.7098e-02_r8,3.0472e-02_r8,2.8773e-02_r8,1.4192e-02_r8/)
      kbo(:, 4,27, 5) = (/ &
     &1.6580e-02_r8,3.3382e-02_r8,3.6146e-02_r8,3.2904e-02_r8,1.4638e-02_r8/)
      kbo(:, 5,27, 5) = (/ &
     &2.2392e-02_r8,4.0890e-02_r8,4.2671e-02_r8,3.7399e-02_r8,1.5005e-02_r8/)
      kbo(:, 1,28, 5) = (/ &
     &5.4489e-03_r8,1.5531e-02_r8,1.8614e-02_r8,1.8613e-02_r8,1.0873e-02_r8/)
      kbo(:, 2,28, 5) = (/ &
     &7.8148e-03_r8,1.9440e-02_r8,2.2401e-02_r8,2.1604e-02_r8,1.1349e-02_r8/)
      kbo(:, 3,28, 5) = (/ &
     &1.0969e-02_r8,2.4138e-02_r8,2.6729e-02_r8,2.4848e-02_r8,1.1757e-02_r8/)
      kbo(:, 4,28, 5) = (/ &
     &1.5087e-02_r8,2.9815e-02_r8,3.1728e-02_r8,2.8368e-02_r8,1.2101e-02_r8/)
      kbo(:, 5,28, 5) = (/ &
     &2.0299e-02_r8,3.6555e-02_r8,3.7502e-02_r8,3.2280e-02_r8,1.2378e-02_r8/)
      kbo(:, 1,29, 5) = (/ &
     &5.3270e-03_r8,1.4285e-02_r8,1.6775e-02_r8,1.6453e-02_r8,9.0474e-03_r8/)
      kbo(:, 2,29, 5) = (/ &
     &7.6276e-03_r8,1.7927e-02_r8,2.0207e-02_r8,1.9083e-02_r8,9.4132e-03_r8/)
      kbo(:, 3,29, 5) = (/ &
     &1.0673e-02_r8,2.2373e-02_r8,2.4172e-02_r8,2.1940e-02_r8,9.7284e-03_r8/)
      kbo(:, 4,29, 5) = (/ &
     &1.4614e-02_r8,2.7730e-02_r8,2.8795e-02_r8,2.5116e-02_r8,9.9926e-03_r8/)
      kbo(:, 5,29, 5) = (/ &
     &1.9579e-02_r8,3.4081e-02_r8,3.4110e-02_r8,2.8684e-02_r8,1.0207e-02_r8/)
      kbo(:, 1,30, 5) = (/ &
     &5.3535e-03_r8,1.3353e-02_r8,1.5300e-02_r8,1.4666e-02_r8,7.5129e-03_r8/)
      kbo(:, 2,30, 5) = (/ &
     &7.6380e-03_r8,1.6853e-02_r8,1.8473e-02_r8,1.7010e-02_r8,7.7968e-03_r8/)
      kbo(:, 3,30, 5) = (/ &
     &1.0647e-02_r8,2.1132e-02_r8,2.2202e-02_r8,1.9612e-02_r8,8.0434e-03_r8/)
      kbo(:, 4,30, 5) = (/ &
     &1.4510e-02_r8,2.6289e-02_r8,2.6550e-02_r8,2.2553e-02_r8,8.2450e-03_r8/)
      kbo(:, 5,30, 5) = (/ &
     &1.9367e-02_r8,3.2371e-02_r8,3.1546e-02_r8,2.5868e-02_r8,8.4082e-03_r8/)
      kbo(:, 1,31, 5) = (/ &
     &5.6746e-03_r8,1.2936e-02_r8,1.4343e-02_r8,1.3343e-02_r8,6.2303e-03_r8/)
      kbo(:, 2,31, 5) = (/ &
     &8.0577e-03_r8,1.6447e-02_r8,1.7425e-02_r8,1.5532e-02_r8,6.4556e-03_r8/)
      kbo(:, 3,31, 5) = (/ &
     &1.1174e-02_r8,2.0739e-02_r8,2.1078e-02_r8,1.8020e-02_r8,6.6441e-03_r8/)
      kbo(:, 4,31, 5) = (/ &
     &1.5165e-02_r8,2.5916e-02_r8,2.5346e-02_r8,2.0861e-02_r8,6.8034e-03_r8/)
      kbo(:, 5,31, 5) = (/ &
     &2.0188e-02_r8,3.1999e-02_r8,3.0259e-02_r8,2.4055e-02_r8,6.9268e-03_r8/)
      kbo(:, 1,32, 5) = (/ &
     &6.0895e-03_r8,1.2732e-02_r8,1.3622e-02_r8,1.2258e-02_r8,5.1656e-03_r8/)
      kbo(:, 2,32, 5) = (/ &
     &8.5996e-03_r8,1.6298e-02_r8,1.6681e-02_r8,1.4366e-02_r8,5.3392e-03_r8/)
      kbo(:, 3,32, 5) = (/ &
     &1.1871e-02_r8,2.0666e-02_r8,2.0302e-02_r8,1.6787e-02_r8,5.4899e-03_r8/)
      kbo(:, 4,32, 5) = (/ &
     &1.6059e-02_r8,2.5901e-02_r8,2.4547e-02_r8,1.9547e-02_r8,5.6119e-03_r8/)
      kbo(:, 5,32, 5) = (/ &
     &2.1313e-02_r8,3.2082e-02_r8,2.9454e-02_r8,2.2664e-02_r8,5.7070e-03_r8/)
      kbo(:, 1,33, 5) = (/ &
     &6.6515e-03_r8,1.2796e-02_r8,1.3188e-02_r8,1.1442e-02_r8,4.2781e-03_r8/)
      kbo(:, 2,33, 5) = (/ &
     &9.3384e-03_r8,1.6485e-02_r8,1.6266e-02_r8,1.3517e-02_r8,4.4167e-03_r8/)
      kbo(:, 3,33, 5) = (/ &
     &1.2846e-02_r8,2.0999e-02_r8,1.9943e-02_r8,1.5910e-02_r8,4.5341e-03_r8/)
      kbo(:, 4,33, 5) = (/ &
     &1.7327e-02_r8,2.6399e-02_r8,2.4247e-02_r8,1.8651e-02_r8,4.6303e-03_r8/)
      kbo(:, 5,33, 5) = (/ &
     &2.2895e-02_r8,3.2829e-02_r8,2.9267e-02_r8,2.1750e-02_r8,4.7019e-03_r8/)
      kbo(:, 1,34, 5) = (/ &
     &6.9862e-03_r8,1.2631e-02_r8,1.2600e-02_r8,1.0591e-02_r8,3.5376e-03_r8/)
      kbo(:, 2,34, 5) = (/ &
     &9.7726e-03_r8,1.6353e-02_r8,1.5653e-02_r8,1.2600e-02_r8,3.6473e-03_r8/)
      kbo(:, 3,34, 5) = (/ &
     &1.3409e-02_r8,2.0887e-02_r8,1.9295e-02_r8,1.4929e-02_r8,3.7406e-03_r8/)
      kbo(:, 4,34, 5) = (/ &
     &1.8037e-02_r8,2.6346e-02_r8,2.3581e-02_r8,1.7591e-02_r8,3.8148e-03_r8/)
      kbo(:, 5,34, 5) = (/ &
     &2.3704e-02_r8,3.2885e-02_r8,2.8616e-02_r8,2.0638e-02_r8,3.8707e-03_r8/)
      kbo(:, 1,35, 5) = (/ &
     &7.0977e-03_r8,1.2235e-02_r8,1.1878e-02_r8,9.7122e-03_r8,2.9156e-03_r8/)
      kbo(:, 2,35, 5) = (/ &
     &9.9249e-03_r8,1.5915e-02_r8,1.4862e-02_r8,1.1642e-02_r8,3.0042e-03_r8/)
      kbo(:, 3,35, 5) = (/ &
     &1.3615e-02_r8,2.0413e-02_r8,1.8425e-02_r8,1.3882e-02_r8,3.0791e-03_r8/)
      kbo(:, 4,35, 5) = (/ &
     &1.8271e-02_r8,2.5881e-02_r8,2.2655e-02_r8,1.6461e-02_r8,3.1387e-03_r8/)
      kbo(:, 5,35, 5) = (/ &
     &2.3900e-02_r8,3.2414e-02_r8,2.7651e-02_r8,1.9450e-02_r8,3.1837e-03_r8/)
      kbo(:, 1,36, 5) = (/ &
     &6.9060e-03_r8,1.1498e-02_r8,1.0932e-02_r8,8.7493e-03_r8,2.3952e-03_r8/)
      kbo(:, 2,36, 5) = (/ &
     &9.6735e-03_r8,1.5042e-02_r8,1.3779e-02_r8,1.0573e-02_r8,2.4672e-03_r8/)
      kbo(:, 3,36, 5) = (/ &
     &1.3291e-02_r8,1.9415e-02_r8,1.7205e-02_r8,1.2691e-02_r8,2.5290e-03_r8/)
      kbo(:, 4,36, 5) = (/ &
     &1.7820e-02_r8,2.4753e-02_r8,2.1299e-02_r8,1.5151e-02_r8,2.5791e-03_r8/)
      kbo(:, 5,36, 5) = (/ &
     &2.3253e-02_r8,3.1113e-02_r8,2.6141e-02_r8,1.8030e-02_r8,2.6175e-03_r8/)
      kbo(:, 1,37, 5) = (/ &
     &6.2139e-03_r8,1.0192e-02_r8,9.5802e-03_r8,7.5798e-03_r8,1.9567e-03_r8/)
      kbo(:, 2,37, 5) = (/ &
     &8.7456e-03_r8,1.3428e-02_r8,1.2164e-02_r8,9.2244e-03_r8,2.0181e-03_r8/)
      kbo(:, 3,37, 5) = (/ &
     &1.2068e-02_r8,1.7456e-02_r8,1.5302e-02_r8,1.1147e-02_r8,2.0706e-03_r8/)
      kbo(:, 4,37, 5) = (/ &
     &1.6229e-02_r8,2.2411e-02_r8,1.9089e-02_r8,1.3408e-02_r8,2.1134e-03_r8/)
      kbo(:, 5,37, 5) = (/ &
     &2.1208e-02_r8,2.8314e-02_r8,2.3560e-02_r8,1.6063e-02_r8,2.1467e-03_r8/)
      kbo(:, 1,38, 5) = (/ &
     &5.6546e-03_r8,9.1081e-03_r8,8.4597e-03_r8,6.6101e-03_r8,1.5995e-03_r8/)
      kbo(:, 2,38, 5) = (/ &
     &7.9966e-03_r8,1.2093e-02_r8,1.0832e-02_r8,8.1085e-03_r8,1.6506e-03_r8/)
      kbo(:, 3,38, 5) = (/ &
     &1.1084e-02_r8,1.5851e-02_r8,1.3740e-02_r8,9.8767e-03_r8,1.6948e-03_r8/)
      kbo(:, 4,38, 5) = (/ &
     &1.4944e-02_r8,2.0494e-02_r8,1.7272e-02_r8,1.1975e-02_r8,1.7322e-03_r8/)
      kbo(:, 5,38, 5) = (/ &
     &1.9571e-02_r8,2.6031e-02_r8,2.1445e-02_r8,1.4447e-02_r8,1.7614e-03_r8/)
      kbo(:, 1,39, 5) = (/ &
     &5.2606e-03_r8,8.2861e-03_r8,7.5918e-03_r8,5.8448e-03_r8,1.3077e-03_r8/)
      kbo(:, 2,39, 5) = (/ &
     &7.4758e-03_r8,1.1098e-02_r8,9.8108e-03_r8,7.2343e-03_r8,1.3505e-03_r8/)
      kbo(:, 3,39, 5) = (/ &
     &1.0407e-02_r8,1.4668e-02_r8,1.2553e-02_r8,8.8880e-03_r8,1.3888e-03_r8/)
      kbo(:, 4,39, 5) = (/ &
     &1.4072e-02_r8,1.9102e-02_r8,1.5911e-02_r8,1.0872e-02_r8,1.4211e-03_r8/)
      kbo(:, 5,39, 5) = (/ &
     &1.8472e-02_r8,2.4391e-02_r8,1.9883e-02_r8,1.3211e-02_r8,1.4470e-03_r8/)
      kbo(:, 1,40, 5) = (/ &
     &4.4239e-03_r8,6.9683e-03_r8,6.3619e-03_r8,4.8825e-03_r8,1.0643e-03_r8/)
      kbo(:, 2,40, 5) = (/ &
     &6.3289e-03_r8,9.4143e-03_r8,8.2870e-03_r8,6.0882e-03_r8,1.1007e-03_r8/)
      kbo(:, 3,40, 5) = (/ &
     &8.8723e-03_r8,1.2550e-02_r8,1.0689e-02_r8,7.5344e-03_r8,1.1340e-03_r8/)
      kbo(:, 4,40, 5) = (/ &
     &1.2075e-02_r8,1.6469e-02_r8,1.3655e-02_r8,9.2842e-03_r8,1.1620e-03_r8/)
      kbo(:, 5,40, 5) = (/ &
     &1.5933e-02_r8,2.1174e-02_r8,1.7180e-02_r8,1.1354e-02_r8,1.1848e-03_r8/)
      kbo(:, 1,41, 5) = (/ &
     &3.6867e-03_r8,5.8128e-03_r8,5.2949e-03_r8,4.0553e-03_r8,8.6561e-04_r8/)
      kbo(:, 2,41, 5) = (/ &
     &5.3143e-03_r8,7.9271e-03_r8,6.9551e-03_r8,5.0947e-03_r8,8.9710e-04_r8/)
      kbo(:, 3,41, 5) = (/ &
     &7.5044e-03_r8,1.0658e-02_r8,9.0449e-03_r8,6.3522e-03_r8,9.2517e-04_r8/)
      kbo(:, 4,41, 5) = (/ &
     &1.0281e-02_r8,1.4099e-02_r8,1.1643e-02_r8,7.8856e-03_r8,9.4938e-04_r8/)
      kbo(:, 5,41, 5) = (/ &
     &1.3649e-02_r8,1.8248e-02_r8,1.4748e-02_r8,9.7057e-03_r8,9.6963e-04_r8/)
      kbo(:, 1,42, 5) = (/ &
     &3.0985e-03_r8,4.8781e-03_r8,4.4299e-03_r8,3.3820e-03_r8,7.0400e-04_r8/)
      kbo(:, 2,42, 5) = (/ &
     &4.5009e-03_r8,6.7165e-03_r8,5.8698e-03_r8,4.2829e-03_r8,7.3071e-04_r8/)
      kbo(:, 3,42, 5) = (/ &
     &6.4001e-03_r8,9.1103e-03_r8,7.7007e-03_r8,5.3843e-03_r8,7.5479e-04_r8/)
      kbo(:, 4,42, 5) = (/ &
     &8.8324e-03_r8,1.2154e-02_r8,9.9941e-03_r8,6.7362e-03_r8,7.7572e-04_r8/)
      kbo(:, 5,42, 5) = (/ &
     &1.1799e-02_r8,1.5850e-02_r8,1.2750e-02_r8,8.3487e-03_r8,7.9315e-04_r8/)
      kbo(:, 1,43, 5) = (/ &
     &2.5629e-03_r8,4.0329e-03_r8,3.6588e-03_r8,2.7901e-03_r8,5.7114e-04_r8/)
      kbo(:, 2,43, 5) = (/ &
     &3.7578e-03_r8,5.6142e-03_r8,4.8977e-03_r8,3.5662e-03_r8,5.9379e-04_r8/)
      kbo(:, 3,43, 5) = (/ &
     &5.3881e-03_r8,7.6915e-03_r8,6.4844e-03_r8,4.5229e-03_r8,6.1455e-04_r8/)
      kbo(:, 4,43, 5) = (/ &
     &7.5091e-03_r8,1.0367e-02_r8,8.4990e-03_r8,5.7086e-03_r8,6.3259e-04_r8/)
      kbo(:, 5,43, 5) = (/ &
     &1.0110e-02_r8,1.3645e-02_r8,1.0937e-02_r8,7.1314e-03_r8,6.4809e-04_r8/)
      kbo(:, 1,44, 5) = (/ &
     &2.1195e-03_r8,3.3263e-03_r8,3.0153e-03_r8,2.2974e-03_r8,4.6259e-04_r8/)
      kbo(:, 2,44, 5) = (/ &
     &3.1405e-03_r8,4.6890e-03_r8,4.0834e-03_r8,2.9671e-03_r8,4.8211e-04_r8/)
      kbo(:, 3,44, 5) = (/ &
     &4.5449e-03_r8,6.4956e-03_r8,5.4625e-03_r8,3.8015e-03_r8,4.9986e-04_r8/)
      kbo(:, 4,44, 5) = (/ &
     &6.4001e-03_r8,8.8502e-03_r8,7.2321e-03_r8,4.8421e-03_r8,5.1551e-04_r8/)
      kbo(:, 5,44, 5) = (/ &
     &8.6977e-03_r8,1.1779e-02_r8,9.4064e-03_r8,6.1062e-03_r8,5.2910e-04_r8/)
      kbo(:, 1,45, 5) = (/ &
     &1.7814e-03_r8,2.7759e-03_r8,2.5092e-03_r8,1.9068e-03_r8,3.7475e-04_r8/)
      kbo(:, 2,45, 5) = (/ &
     &2.6678e-03_r8,3.9635e-03_r8,3.4407e-03_r8,2.4906e-03_r8,3.9120e-04_r8/)
      kbo(:, 3,45, 5) = (/ &
     &3.8999e-03_r8,5.5595e-03_r8,4.6558e-03_r8,3.2267e-03_r8,4.0640e-04_r8/)
      kbo(:, 4,45, 5) = (/ &
     &5.5475e-03_r8,7.6646e-03_r8,6.2331e-03_r8,4.1536e-03_r8,4.1988e-04_r8/)
      kbo(:, 5,45, 5) = (/ &
     &7.6146e-03_r8,1.0314e-02_r8,8.1967e-03_r8,5.2910e-03_r8,4.3189e-04_r8/)
      kbo(:, 1,46, 5) = (/ &
     &1.4913e-03_r8,2.3049e-03_r8,2.0781e-03_r8,1.5752e-03_r8,3.0303e-04_r8/)
      kbo(:, 2,46, 5) = (/ &
     &2.2619e-03_r8,3.3394e-03_r8,2.8896e-03_r8,2.0839e-03_r8,3.1705e-04_r8/)
      kbo(:, 3,46, 5) = (/ &
     &3.3424e-03_r8,4.7455e-03_r8,3.9592e-03_r8,2.7324e-03_r8,3.2997e-04_r8/)
      kbo(:, 4,46, 5) = (/ &
     &4.8041e-03_r8,6.6271e-03_r8,5.3667e-03_r8,3.5579e-03_r8,3.4174e-04_r8/)
      kbo(:, 5,46, 5) = (/ &
     &6.6700e-03_r8,9.0306e-03_r8,7.1468e-03_r8,4.5847e-03_r8,3.5220e-04_r8/)
      kbo(:, 1,47, 5) = (/ &
     &1.2089e-03_r8,1.8595e-03_r8,1.6774e-03_r8,1.2733e-03_r8,2.4435e-04_r8/)
      kbo(:, 2,47, 5) = (/ &
     &1.8589e-03_r8,2.7359e-03_r8,2.3669e-03_r8,1.7064e-03_r8,2.5622e-04_r8/)
      kbo(:, 3,47, 5) = (/ &
     &2.7805e-03_r8,3.9417e-03_r8,3.2867e-03_r8,2.2649e-03_r8,2.6731e-04_r8/)
      kbo(:, 4,47, 5) = (/ &
     &4.0468e-03_r8,5.5810e-03_r8,4.5086e-03_r8,2.9823e-03_r8,2.7740e-04_r8/)
      kbo(:, 5,47, 5) = (/ &
     &5.6890e-03_r8,7.7116e-03_r8,6.0862e-03_r8,3.8914e-03_r8,2.8663e-04_r8/)
      kbo(:, 1,48, 5) = (/ &
     &1.0010e-03_r8,1.5219e-03_r8,1.3705e-03_r8,1.0399e-03_r8,1.9690e-04_r8/)
      kbo(:, 2,48, 5) = (/ &
     &1.5623e-03_r8,2.2781e-03_r8,1.9661e-03_r8,1.4139e-03_r8,2.0690e-04_r8/)
      kbo(:, 3,48, 5) = (/ &
     &2.3663e-03_r8,3.3328e-03_r8,2.7724e-03_r8,1.9027e-03_r8,2.1643e-04_r8/)
      kbo(:, 4,48, 5) = (/ &
     &3.4895e-03_r8,4.7876e-03_r8,3.8543e-03_r8,2.5388e-03_r8,2.2513e-04_r8/)
      kbo(:, 5,48, 5) = (/ &
     &4.9716e-03_r8,6.7160e-03_r8,5.2797e-03_r8,3.3578e-03_r8,2.3320e-04_r8/)
      kbo(:, 1,49, 5) = (/ &
     &8.5765e-04_r8,1.2765e-03_r8,1.1434e-03_r8,8.6362e-04_r8,1.5857e-04_r8/)
      kbo(:, 2,49, 5) = (/ &
     &1.3602e-03_r8,1.9488e-03_r8,1.6723e-03_r8,1.1956e-03_r8,1.6712e-04_r8/)
      kbo(:, 3,49, 5) = (/ &
     &2.0873e-03_r8,2.8996e-03_r8,2.4000e-03_r8,1.6350e-03_r8,1.7515e-04_r8/)
      kbo(:, 4,49, 5) = (/ &
     &3.1195e-03_r8,4.2309e-03_r8,3.3880e-03_r8,2.2146e-03_r8,1.8269e-04_r8/)
      kbo(:, 5,49, 5) = (/ &
     &4.5042e-03_r8,6.0317e-03_r8,4.7143e-03_r8,2.9742e-03_r8,1.8971e-04_r8/)
      kbo(:, 1,50, 5) = (/ &
     &7.0327e-04_r8,1.0357e-03_r8,9.2617e-04_r8,6.9913e-04_r8,1.2768e-04_r8/)
      kbo(:, 2,50, 5) = (/ &
     &1.1341e-03_r8,1.6088e-03_r8,1.3773e-03_r8,9.8362e-04_r8,1.3488e-04_r8/)
      kbo(:, 3,50, 5) = (/ &
     &1.7633e-03_r8,2.4334e-03_r8,2.0087e-03_r8,1.3647e-03_r8,1.4174e-04_r8/)
      kbo(:, 4,50, 5) = (/ &
     &2.6686e-03_r8,3.6011e-03_r8,2.8760e-03_r8,1.8731e-03_r8,1.4819e-04_r8/)
      kbo(:, 5,50, 5) = (/ &
     &3.9042e-03_r8,5.2110e-03_r8,4.0582e-03_r8,2.5499e-03_r8,1.5417e-04_r8/)
      kbo(:, 1,51, 5) = (/ &
     &5.6283e-04_r8,8.2479e-04_r8,7.3777e-04_r8,5.5772e-04_r8,1.0280e-04_r8/)
      kbo(:, 2,51, 5) = (/ &
     &9.2490e-04_r8,1.3030e-03_r8,1.1149e-03_r8,7.9673e-04_r8,1.0882e-04_r8/)
      kbo(:, 3,51, 5) = (/ &
     &1.4569e-03_r8,2.0026e-03_r8,1.6508e-03_r8,1.1213e-03_r8,1.1463e-04_r8/)
      kbo(:, 4,51, 5) = (/ &
     &2.2322e-03_r8,3.0043e-03_r8,2.3967e-03_r8,1.5580e-03_r8,1.2010e-04_r8/)
      kbo(:, 5,51, 5) = (/ &
     &3.3090e-03_r8,4.4133e-03_r8,3.4281e-03_r8,2.1477e-03_r8,1.2516e-04_r8/)
      kbo(:, 1,52, 5) = (/ &
     &4.5964e-04_r8,6.6706e-04_r8,5.9570e-04_r8,4.4969e-04_r8,8.2695e-05_r8/)
      kbo(:, 2,52, 5) = (/ &
     &7.7113e-04_r8,1.0739e-03_r8,9.1646e-04_r8,6.5362e-04_r8,8.7774e-05_r8/)
      kbo(:, 3,52, 5) = (/ &
     &1.2329e-03_r8,1.6791e-03_r8,1.3796e-03_r8,9.3460e-04_r8,9.2675e-05_r8/)
      kbo(:, 4,52, 5) = (/ &
     &1.9124e-03_r8,2.5569e-03_r8,2.0345e-03_r8,1.3172e-03_r8,9.7314e-05_r8/)
      kbo(:, 5,52, 5) = (/ &
     &2.8744e-03_r8,3.8139e-03_r8,2.9526e-03_r8,1.8404e-03_r8,1.0157e-04_r8/)
      kbo(:, 1,53, 5) = (/ &
     &3.8730e-04_r8,5.5282e-04_r8,4.9108e-04_r8,3.6874e-04_r8,6.6480e-05_r8/)
      kbo(:, 2,53, 5) = (/ &
     &6.6529e-04_r8,9.0913e-04_r8,7.7130e-04_r8,5.4660e-04_r8,7.0743e-05_r8/)
      kbo(:, 3,53, 5) = (/ &
     &1.0811e-03_r8,1.4483e-03_r8,1.1832e-03_r8,7.9661e-04_r8,7.4902e-05_r8/)
      kbo(:, 4,53, 5) = (/ &
     &1.6977e-03_r8,2.2425e-03_r8,1.7750e-03_r8,1.1419e-03_r8,7.8801e-05_r8/)
      kbo(:, 5,53, 5) = (/ &
     &2.5875e-03_r8,3.3978e-03_r8,2.6180e-03_r8,1.6189e-03_r8,8.2434e-05_r8/)
      kbo(:, 1,54, 5) = (/ &
     &2.8438e-04_r8,4.1240e-04_r8,3.6923e-04_r8,2.8032e-04_r8,5.3391e-05_r8/)
      kbo(:, 2,54, 5) = (/ &
     &5.0038e-04_r8,6.8881e-04_r8,5.8764e-04_r8,4.1957e-04_r8,5.6986e-05_r8/)
      kbo(:, 3,54, 5) = (/ &
     &8.2710e-04_r8,1.1130e-03_r8,9.1323e-04_r8,6.1896e-04_r8,6.0464e-05_r8/)
      kbo(:, 4,54, 5) = (/ &
     &1.3140e-03_r8,1.7467e-03_r8,1.3863e-03_r8,8.9674e-04_r8,6.3698e-05_r8/)
      kbo(:, 5,54, 5) = (/ &
     &2.0289e-03_r8,2.6791e-03_r8,2.0677e-03_r8,1.2826e-03_r8,6.6754e-05_r8/)
      kbo(:, 1,55, 5) = (/ &
     &1.9032e-04_r8,2.8714e-04_r8,2.6164e-04_r8,2.0312e-04_r8,4.2857e-05_r8/)
      kbo(:, 2,55, 5) = (/ &
     &3.4354e-04_r8,4.8514e-04_r8,4.1940e-04_r8,3.0487e-04_r8,4.5872e-05_r8/)
      kbo(:, 3,55, 5) = (/ &
     &5.7798e-04_r8,7.9314e-04_r8,6.5789e-04_r8,4.5289e-04_r8,4.8737e-05_r8/)
      kbo(:, 4,55, 5) = (/ &
     &9.2977e-04_r8,1.2582e-03_r8,1.0072e-03_r8,6.6019e-04_r8,5.1425e-05_r8/)
      kbo(:, 5,55, 5) = (/ &
     &1.4533e-03_r8,1.9484e-03_r8,1.5135e-03_r8,9.4927e-04_r8,5.3965e-05_r8/)
      kbo(:, 1,56, 5) = (/ &
     &1.2624e-04_r8,1.9945e-04_r8,1.8526e-04_r8,1.4713e-04_r8,3.4367e-05_r8/)
      kbo(:, 2,56, 5) = (/ &
     &2.3425e-04_r8,3.4034e-04_r8,2.9855e-04_r8,2.2108e-04_r8,3.6885e-05_r8/)
      kbo(:, 3,56, 5) = (/ &
     &4.0201e-04_r8,5.6312e-04_r8,4.7257e-04_r8,3.3069e-04_r8,3.9253e-05_r8/)
      kbo(:, 4,56, 5) = (/ &
     &6.5545e-04_r8,9.0280e-04_r8,7.2955e-04_r8,4.8511e-04_r8,4.1521e-05_r8/)
      kbo(:, 5,56, 5) = (/ &
     &1.0372e-03_r8,1.4120e-03_r8,1.1051e-03_r8,7.0135e-04_r8,4.3631e-05_r8/)
      kbo(:, 1,57, 5) = (/ &
     &8.2825e-05_r8,1.3826e-04_r8,1.3105e-04_r8,1.0648e-04_r8,2.7541e-05_r8/)
      kbo(:, 2,57, 5) = (/ &
     &1.5848e-04_r8,2.3765e-04_r8,2.1180e-04_r8,1.6006e-04_r8,2.9646e-05_r8/)
      kbo(:, 3,57, 5) = (/ &
     &2.7802e-04_r8,3.9802e-04_r8,3.3815e-04_r8,2.4085e-04_r8,3.1604e-05_r8/)
      kbo(:, 4,57, 5) = (/ &
     &4.6014e-04_r8,6.4521e-04_r8,5.2696e-04_r8,3.5556e-04_r8,3.3502e-05_r8/)
      kbo(:, 5,57, 5) = (/ &
     &7.3676e-04_r8,1.0192e-03_r8,8.0418e-04_r8,5.1690e-04_r8,3.5248e-05_r8/)
      kbo(:, 1,58, 5) = (/ &
     &1.4413e-05_r8,3.1415e-05_r8,3.9206e-05_r8,4.5793e-05_r8,2.2070e-05_r8/)
      kbo(:, 2,58, 5) = (/ &
     &2.8319e-05_r8,5.4166e-05_r8,6.3295e-05_r8,6.8680e-05_r8,2.3823e-05_r8/)
      kbo(:, 3,58, 5) = (/ &
     &5.0851e-05_r8,9.1643e-05_r8,1.0172e-04_r8,1.0358e-04_r8,2.5450e-05_r8/)
      kbo(:, 4,58, 5) = (/ &
     &8.5536e-05_r8,1.4999e-04_r8,1.5967e-04_r8,1.5367e-04_r8,2.7016e-05_r8/)
      kbo(:, 5,58, 5) = (/ &
     &1.3845e-04_r8,2.3895e-04_r8,2.4509e-04_r8,2.2418e-04_r8,2.8488e-05_r8/)
      kbo(:, 1,59, 5) = (/ &
     &1.2766e-05_r8,2.9930e-05_r8,3.6342e-05_r8,3.9546e-05_r8,1.7924e-05_r8/)
      kbo(:, 2,59, 5) = (/ &
     &2.5308e-05_r8,5.0886e-05_r8,5.7559e-05_r8,5.8137e-05_r8,1.9351e-05_r8/)
      kbo(:, 3,59, 5) = (/ &
     &4.5886e-05_r8,8.5371e-05_r8,9.1314e-05_r8,8.6129e-05_r8,2.0681e-05_r8/)
      kbo(:, 4,59, 5) = (/ &
     &7.7783e-05_r8,1.3897e-04_r8,1.4192e-04_r8,1.2608e-04_r8,2.1937e-05_r8/)
      kbo(:, 5,59, 5) = (/ &
     &1.2671e-04_r8,2.2060e-04_r8,2.1586e-04_r8,1.8160e-04_r8,2.3122e-05_r8/)
      kbo(:, 1,13, 6) = (/ &
     &1.2091e+00_r8,1.0925e+00_r8,9.7132e-01_r8,7.6832e-01_r8,2.2429e-01_r8/)
      kbo(:, 2,13, 6) = (/ &
     &1.8464e+00_r8,1.5640e+00_r8,1.2977e+00_r8,9.6738e-01_r8,2.2945e-01_r8/)
      kbo(:, 3,13, 6) = (/ &
     &2.7006e+00_r8,2.1933e+00_r8,1.7174e+00_r8,1.2089e+00_r8,2.3586e-01_r8/)
      kbo(:, 4,13, 6) = (/ &
     &3.8041e+00_r8,3.0098e+00_r8,2.2534e+00_r8,1.4966e+00_r8,2.4148e-01_r8/)
      kbo(:, 5,13, 6) = (/ &
     &5.1874e+00_r8,4.0404e+00_r8,2.9277e+00_r8,1.8384e+00_r8,2.4717e-01_r8/)
      kbo(:, 1,14, 6) = (/ &
     &6.6672e-01_r8,6.8855e-01_r8,6.6353e-01_r8,5.5608e-01_r8,2.0092e-01_r8/)
      kbo(:, 2,14, 6) = (/ &
     &1.0160e+00_r8,9.4963e-01_r8,8.6392e-01_r8,6.8590e-01_r8,2.0621e-01_r8/)
      kbo(:, 3,14, 6) = (/ &
     &1.4836e+00_r8,1.2937e+00_r8,1.1112e+00_r8,8.3934e-01_r8,2.1228e-01_r8/)
      kbo(:, 4,14, 6) = (/ &
     &2.0856e+00_r8,1.7366e+00_r8,1.4142e+00_r8,1.0186e+00_r8,2.1791e-01_r8/)
      kbo(:, 5,14, 6) = (/ &
     &2.8402e+00_r8,2.2928e+00_r8,1.7814e+00_r8,1.2275e+00_r8,2.2338e-01_r8/)
      kbo(:, 1,15, 6) = (/ &
     &3.7534e-01_r8,4.5732e-01_r8,4.6750e-01_r8,4.0917e-01_r8,1.7874e-01_r8/)
      kbo(:, 2,15, 6) = (/ &
     &5.7029e-01_r8,6.1390e-01_r8,5.9540e-01_r8,4.9734e-01_r8,1.8407e-01_r8/)
      kbo(:, 3,15, 6) = (/ &
     &8.2994e-01_r8,8.1258e-01_r8,7.5038e-01_r8,5.9870e-01_r8,1.8982e-01_r8/)
      kbo(:, 4,15, 6) = (/ &
     &1.1635e+00_r8,1.0593e+00_r8,9.3529e-01_r8,7.1512e-01_r8,1.9538e-01_r8/)
      kbo(:, 5,15, 6) = (/ &
     &1.5834e+00_r8,1.3649e+00_r8,1.1537e+00_r8,8.4763e-01_r8,2.0092e-01_r8/)
      kbo(:, 1,16, 6) = (/ &
     &2.5139e-01_r8,3.4640e-01_r8,3.6560e-01_r8,3.2723e-01_r8,1.5796e-01_r8/)
      kbo(:, 2,16, 6) = (/ &
     &3.8033e-01_r8,4.5844e-01_r8,4.5962e-01_r8,3.9345e-01_r8,1.6322e-01_r8/)
      kbo(:, 3,16, 6) = (/ &
     &5.5135e-01_r8,5.9731e-01_r8,5.7234e-01_r8,4.6896e-01_r8,1.6890e-01_r8/)
      kbo(:, 4,16, 6) = (/ &
     &7.7178e-01_r8,7.6699e-01_r8,7.0504e-01_r8,5.5557e-01_r8,1.7446e-01_r8/)
      kbo(:, 5,16, 6) = (/ &
     &1.0505e+00_r8,9.7332e-01_r8,8.6035e-01_r8,6.5296e-01_r8,1.7998e-01_r8/)
      kbo(:, 1,17, 6) = (/ &
     &1.7391e-01_r8,2.6830e-01_r8,2.8935e-01_r8,2.6535e-01_r8,1.3871e-01_r8/)
      kbo(:, 2,17, 6) = (/ &
     &2.6196e-01_r8,3.5091e-01_r8,3.6089e-01_r8,3.1647e-01_r8,1.4388e-01_r8/)
      kbo(:, 3,17, 6) = (/ &
     &3.7888e-01_r8,4.5188e-01_r8,4.4522e-01_r8,3.7420e-01_r8,1.4950e-01_r8/)
      kbo(:, 4,17, 6) = (/ &
     &5.3041e-01_r8,5.7470e-01_r8,5.4379e-01_r8,4.3949e-01_r8,1.5497e-01_r8/)
      kbo(:, 5,17, 6) = (/ &
     &7.2254e-01_r8,7.2344e-01_r8,6.5849e-01_r8,5.1285e-01_r8,1.6018e-01_r8/)
      kbo(:, 1,18, 6) = (/ &
     &1.2310e-01_r8,2.1053e-01_r8,2.3152e-01_r8,2.1713e-01_r8,1.2112e-01_r8/)
      kbo(:, 2,18, 6) = (/ &
     &1.8497e-01_r8,2.7232e-01_r8,2.8648e-01_r8,2.5684e-01_r8,1.2635e-01_r8/)
      kbo(:, 3,18, 6) = (/ &
     &2.6727e-01_r8,3.4798e-01_r8,3.5045e-01_r8,3.0154e-01_r8,1.3167e-01_r8/)
      kbo(:, 4,18, 6) = (/ &
     &3.7442e-01_r8,4.3958e-01_r8,4.2522e-01_r8,3.5185e-01_r8,1.3670e-01_r8/)
      kbo(:, 5,18, 6) = (/ &
     &5.0994e-01_r8,5.4989e-01_r8,5.1174e-01_r8,4.0832e-01_r8,1.4125e-01_r8/)
      kbo(:, 1,19, 6) = (/ &
     &8.5532e-02_r8,1.6314e-01_r8,1.8367e-01_r8,1.7636e-01_r8,1.0532e-01_r8/)
      kbo(:, 2,19, 6) = (/ &
     &1.2828e-01_r8,2.0893e-01_r8,2.2484e-01_r8,2.0705e-01_r8,1.1032e-01_r8/)
      kbo(:, 3,19, 6) = (/ &
     &1.8543e-01_r8,2.6474e-01_r8,2.7268e-01_r8,2.4148e-01_r8,1.1512e-01_r8/)
      kbo(:, 4,19, 6) = (/ &
     &2.5984e-01_r8,3.3238e-01_r8,3.2852e-01_r8,2.8001e-01_r8,1.1952e-01_r8/)
      kbo(:, 5,19, 6) = (/ &
     &3.5320e-01_r8,4.1295e-01_r8,3.9317e-01_r8,3.2333e-01_r8,1.2366e-01_r8/)
      kbo(:, 1,20, 6) = (/ &
     &6.4796e-02_r8,1.3254e-01_r8,1.5120e-01_r8,1.4730e-01_r8,9.1341e-02_r8/)
      kbo(:, 2,20, 6) = (/ &
     &9.6990e-02_r8,1.6885e-01_r8,1.8400e-01_r8,1.7239e-01_r8,9.5796e-02_r8/)
      kbo(:, 3,20, 6) = (/ &
     &1.4017e-01_r8,2.1315e-01_r8,2.2212e-01_r8,2.0058e-01_r8,9.9929e-02_r8/)
      kbo(:, 4,20, 6) = (/ &
     &1.9600e-01_r8,2.6649e-01_r8,2.6658e-01_r8,2.3206e-01_r8,1.0386e-01_r8/)
      kbo(:, 5,20, 6) = (/ &
     &2.6559e-01_r8,3.2963e-01_r8,3.1802e-01_r8,2.6726e-01_r8,1.0762e-01_r8/)
      kbo(:, 1,21, 6) = (/ &
     &5.0649e-02_r8,1.0928e-01_r8,1.2583e-01_r8,1.2405e-01_r8,7.8779e-02_r8/)
      kbo(:, 2,21, 6) = (/ &
     &7.5738e-02_r8,1.3875e-01_r8,1.5264e-01_r8,1.4489e-01_r8,8.2609e-02_r8/)
      kbo(:, 3,21, 6) = (/ &
     &1.0925e-01_r8,1.7464e-01_r8,1.8399e-01_r8,1.6832e-01_r8,8.6258e-02_r8/)
      kbo(:, 4,21, 6) = (/ &
     &1.5216e-01_r8,2.1765e-01_r8,2.2035e-01_r8,1.9451e-01_r8,8.9821e-02_r8/)
      kbo(:, 5,21, 6) = (/ &
     &2.0550e-01_r8,2.6822e-01_r8,2.6230e-01_r8,2.2354e-01_r8,9.3160e-02_r8/)
      kbo(:, 1,22, 6) = (/ &
     &4.1767e-02_r8,9.2608e-02_r8,1.0699e-01_r8,1.0611e-01_r8,6.7766e-02_r8/)
      kbo(:, 2,22, 6) = (/ &
     &6.2192e-02_r8,1.1726e-01_r8,1.2959e-01_r8,1.2363e-01_r8,7.1096e-02_r8/)
      kbo(:, 3,22, 6) = (/ &
     &8.9136e-02_r8,1.4711e-01_r8,1.5605e-01_r8,1.4343e-01_r8,7.4363e-02_r8/)
      kbo(:, 4,22, 6) = (/ &
     &1.2346e-01_r8,1.8283e-01_r8,1.8672e-01_r8,1.6558e-01_r8,7.7494e-02_r8/)
      kbo(:, 5,22, 6) = (/ &
     &1.6595e-01_r8,2.2428e-01_r8,2.2184e-01_r8,1.9008e-01_r8,8.0478e-02_r8/)
      kbo(:, 1,23, 6) = (/ &
     &3.4739e-02_r8,7.8664e-02_r8,9.1136e-02_r8,9.0610e-02_r8,5.8065e-02_r8/)
      kbo(:, 2,23, 6) = (/ &
     &5.1379e-02_r8,9.9376e-02_r8,1.1032e-01_r8,1.0537e-01_r8,6.0980e-02_r8/)
      kbo(:, 3,23, 6) = (/ &
     &7.3154e-02_r8,1.2441e-01_r8,1.3261e-01_r8,1.2218e-01_r8,6.3866e-02_r8/)
      kbo(:, 4,23, 6) = (/ &
     &1.0075e-01_r8,1.5392e-01_r8,1.5845e-01_r8,1.4087e-01_r8,6.6610e-02_r8/)
      kbo(:, 5,23, 6) = (/ &
     &1.3481e-01_r8,1.8817e-01_r8,1.8784e-01_r8,1.6172e-01_r8,6.9269e-02_r8/)
      kbo(:, 1,24, 6) = (/ &
     &2.8818e-02_r8,6.6682e-02_r8,7.7471e-02_r8,7.7057e-02_r8,4.9574e-02_r8/)
      kbo(:, 2,24, 6) = (/ &
     &4.2313e-02_r8,8.4062e-02_r8,9.3582e-02_r8,8.9537e-02_r8,5.2146e-02_r8/)
      kbo(:, 3,24, 6) = (/ &
     &5.9843e-02_r8,1.0485e-01_r8,1.1232e-01_r8,1.0372e-01_r8,5.4645e-02_r8/)
      kbo(:, 4,24, 6) = (/ &
     &8.1952e-02_r8,1.2924e-01_r8,1.3388e-01_r8,1.1954e-01_r8,5.7051e-02_r8/)
      kbo(:, 5,24, 6) = (/ &
     &1.0925e-01_r8,1.5756e-01_r8,1.5837e-01_r8,1.3710e-01_r8,5.9328e-02_r8/)
      kbo(:, 1,25, 6) = (/ &
     &2.4289e-02_r8,5.7018e-02_r8,6.6182e-02_r8,6.5743e-02_r8,4.2224e-02_r8/)
      kbo(:, 2,25, 6) = (/ &
     &3.5371e-02_r8,7.1685e-02_r8,7.9860e-02_r8,7.6400e-02_r8,4.4451e-02_r8/)
      kbo(:, 3,25, 6) = (/ &
     &4.9695e-02_r8,8.9091e-02_r8,9.5704e-02_r8,8.8452e-02_r8,4.6603e-02_r8/)
      kbo(:, 4,25, 6) = (/ &
     &6.7687e-02_r8,1.0953e-01_r8,1.1385e-01_r8,1.0188e-01_r8,4.8655e-02_r8/)
      kbo(:, 5,25, 6) = (/ &
     &9.0080e-02_r8,1.3324e-01_r8,1.3448e-01_r8,1.1679e-01_r8,5.0366e-02_r8/)
      kbo(:, 1,26, 6) = (/ &
     &2.0940e-02_r8,4.9340e-02_r8,5.7029e-02_r8,5.6467e-02_r8,3.5910e-02_r8/)
      kbo(:, 2,26, 6) = (/ &
     &3.0229e-02_r8,6.1848e-02_r8,6.8786e-02_r8,6.5644e-02_r8,3.7816e-02_r8/)
      kbo(:, 3,26, 6) = (/ &
     &4.2173e-02_r8,7.6666e-02_r8,8.2327e-02_r8,7.6015e-02_r8,3.9629e-02_r8/)
      kbo(:, 4,26, 6) = (/ &
     &5.7238e-02_r8,9.4072e-02_r8,9.7854e-02_r8,8.7548e-02_r8,4.1173e-02_r8/)
      kbo(:, 5,26, 6) = (/ &
     &7.6058e-02_r8,1.1436e-01_r8,1.1545e-01_r8,1.0034e-01_r8,4.2300e-02_r8/)
      kbo(:, 1,27, 6) = (/ &
     &1.8730e-02_r8,4.3572e-02_r8,4.9937e-02_r8,4.9064e-02_r8,3.0474e-02_r8/)
      kbo(:, 2,27, 6) = (/ &
     &2.6831e-02_r8,5.4541e-02_r8,6.0259e-02_r8,5.7134e-02_r8,3.2064e-02_r8/)
      kbo(:, 3,27, 6) = (/ &
     &3.7216e-02_r8,6.7578e-02_r8,7.2151e-02_r8,6.6197e-02_r8,3.3458e-02_r8/)
      kbo(:, 4,27, 6) = (/ &
     &5.0417e-02_r8,8.2889e-02_r8,8.5762e-02_r8,7.6299e-02_r8,3.4507e-02_r8/)
      kbo(:, 5,27, 6) = (/ &
     &6.6884e-02_r8,1.0088e-01_r8,1.0129e-01_r8,8.7542e-02_r8,3.5247e-02_r8/)
      kbo(:, 1,28, 6) = (/ &
     &1.7190e-02_r8,3.9051e-02_r8,4.4263e-02_r8,4.3005e-02_r8,2.5796e-02_r8/)
      kbo(:, 2,28, 6) = (/ &
     &2.4452e-02_r8,4.8897e-02_r8,5.3477e-02_r8,5.0169e-02_r8,2.7044e-02_r8/)
      kbo(:, 3,28, 6) = (/ &
     &3.3807e-02_r8,6.0596e-02_r8,6.4111e-02_r8,5.8195e-02_r8,2.8015e-02_r8/)
      kbo(:, 4,28, 6) = (/ &
     &4.5722e-02_r8,7.4408e-02_r8,7.6314e-02_r8,6.7197e-02_r8,2.8722e-02_r8/)
      kbo(:, 5,28, 6) = (/ &
     &6.0503e-02_r8,9.0881e-02_r8,9.0351e-02_r8,7.7127e-02_r8,2.9243e-02_r8/)
      kbo(:, 1,29, 6) = (/ &
     &1.6778e-02_r8,3.6309e-02_r8,4.0421e-02_r8,3.8540e-02_r8,2.1757e-02_r8/)
      kbo(:, 2,29, 6) = (/ &
     &2.3732e-02_r8,4.5567e-02_r8,4.8987e-02_r8,4.5076e-02_r8,2.2654e-02_r8/)
      kbo(:, 3,29, 6) = (/ &
     &3.2754e-02_r8,5.6621e-02_r8,5.8900e-02_r8,5.2465e-02_r8,2.3325e-02_r8/)
      kbo(:, 4,29, 6) = (/ &
     &4.4197e-02_r8,6.9861e-02_r8,7.0379e-02_r8,6.0698e-02_r8,2.3826e-02_r8/)
      kbo(:, 5,29, 6) = (/ &
     &5.8243e-02_r8,8.5699e-02_r8,8.3806e-02_r8,6.9875e-02_r8,2.4188e-02_r8/)
      kbo(:, 1,30, 6) = (/ &
     &1.6788e-02_r8,3.4359e-02_r8,3.7447e-02_r8,3.4898e-02_r8,1.8241e-02_r8/)
      kbo(:, 2,30, 6) = (/ &
     &2.3674e-02_r8,4.3260e-02_r8,4.5554e-02_r8,4.0970e-02_r8,1.8874e-02_r8/)
      kbo(:, 3,30, 6) = (/ &
     &3.2611e-02_r8,5.3991e-02_r8,5.4995e-02_r8,4.7819e-02_r8,1.9352e-02_r8/)
      kbo(:, 4,30, 6) = (/ &
     &4.3823e-02_r8,6.7000e-02_r8,6.6123e-02_r8,5.5495e-02_r8,1.9717e-02_r8/)
      kbo(:, 5,30, 6) = (/ &
     &5.7496e-02_r8,8.2562e-02_r8,7.9216e-02_r8,6.4205e-02_r8,1.9974e-02_r8/)
      kbo(:, 1,31, 6) = (/ &
     &1.7729e-02_r8,3.3726e-02_r8,3.5756e-02_r8,3.2351e-02_r8,1.5217e-02_r8/)
      kbo(:, 2,31, 6) = (/ &
     &2.4948e-02_r8,4.2686e-02_r8,4.3734e-02_r8,3.8162e-02_r8,1.5670e-02_r8/)
      kbo(:, 3,31, 6) = (/ &
     &3.4225e-02_r8,5.3676e-02_r8,5.3194e-02_r8,4.4735e-02_r8,1.6031e-02_r8/)
      kbo(:, 4,31, 6) = (/ &
     &4.5784e-02_r8,6.7038e-02_r8,6.4468e-02_r8,5.2256e-02_r8,1.6295e-02_r8/)
      kbo(:, 5,31, 6) = (/ &
     &5.9817e-02_r8,8.2952e-02_r8,7.7737e-02_r8,6.0918e-02_r8,1.6485e-02_r8/)
      kbo(:, 1,32, 6) = (/ &
     &1.9003e-02_r8,3.3583e-02_r8,3.4583e-02_r8,3.0306e-02_r8,1.2654e-02_r8/)
      kbo(:, 2,32, 6) = (/ &
     &2.6663e-02_r8,4.2837e-02_r8,4.2596e-02_r8,3.5915e-02_r8,1.2998e-02_r8/)
      kbo(:, 3,32, 6) = (/ &
     &3.6385e-02_r8,5.4256e-02_r8,5.2269e-02_r8,4.2382e-02_r8,1.3260e-02_r8/)
      kbo(:, 4,32, 6) = (/ &
     &4.8425e-02_r8,6.8084e-02_r8,6.3837e-02_r8,4.9934e-02_r8,1.3455e-02_r8/)
      kbo(:, 5,32, 6) = (/ &
     &6.3023e-02_r8,8.4608e-02_r8,7.7399e-02_r8,5.8694e-02_r8,1.3589e-02_r8/)
      kbo(:, 1,33, 6) = (/ &
     &2.0794e-02_r8,3.4164e-02_r8,3.4049e-02_r8,2.8789e-02_r8,1.0506e-02_r8/)
      kbo(:, 2,33, 6) = (/ &
     &2.9020e-02_r8,4.3934e-02_r8,4.2358e-02_r8,3.4361e-02_r8,1.0761e-02_r8/)
      kbo(:, 3,33, 6) = (/ &
     &3.9409e-02_r8,5.5981e-02_r8,5.2449e-02_r8,4.0931e-02_r8,1.0954e-02_r8/)
      kbo(:, 4,33, 6) = (/ &
     &5.2184e-02_r8,7.0595e-02_r8,6.4456e-02_r8,4.8674e-02_r8,1.1100e-02_r8/)
      kbo(:, 5,33, 6) = (/ &
     &6.7723e-02_r8,8.8066e-02_r8,7.8614e-02_r8,5.7672e-02_r8,1.1201e-02_r8/)
      kbo(:, 1,34, 6) = (/ &
     &2.1935e-02_r8,3.4165e-02_r8,3.3105e-02_r8,2.7057e-02_r8,8.7014e-03_r8/)
      kbo(:, 2,34, 6) = (/ &
     &3.0477e-02_r8,4.4226e-02_r8,4.1562e-02_r8,3.2560e-02_r8,8.8925e-03_r8/)
      kbo(:, 3,34, 6) = (/ &
     &4.1199e-02_r8,5.6620e-02_r8,5.1809e-02_r8,3.9153e-02_r8,9.0424e-03_r8/)
      kbo(:, 4,34, 6) = (/ &
     &5.4372e-02_r8,7.1709e-02_r8,6.4039e-02_r8,4.6915e-02_r8,9.1557e-03_r8/)
      kbo(:, 5,34, 6) = (/ &
     &7.0476e-02_r8,8.9710e-02_r8,7.8542e-02_r8,5.5979e-02_r8,9.2318e-03_r8/)
      kbo(:, 1,35, 6) = (/ &
     &2.2432e-02_r8,3.3575e-02_r8,3.1770e-02_r8,2.5159e-02_r8,7.1825e-03_r8/)
      kbo(:, 2,35, 6) = (/ &
     &3.1101e-02_r8,4.3743e-02_r8,4.0231e-02_r8,3.0588e-02_r8,7.3372e-03_r8/)
      kbo(:, 3,35, 6) = (/ &
     &4.1959e-02_r8,5.6323e-02_r8,5.0491e-02_r8,3.7114e-02_r8,7.4571e-03_r8/)
      kbo(:, 4,35, 6) = (/ &
     &5.5361e-02_r8,7.1664e-02_r8,6.2827e-02_r8,4.4829e-02_r8,7.5457e-03_r8/)
      kbo(:, 5,35, 6) = (/ &
     &7.1841e-02_r8,8.9995e-02_r8,7.7538e-02_r8,5.3898e-02_r8,7.6098e-03_r8/)
      kbo(:, 1,36, 6) = (/ &
     &2.1971e-02_r8,3.2052e-02_r8,2.9773e-02_r8,2.2980e-02_r8,5.9169e-03_r8/)
      kbo(:, 2,36, 6) = (/ &
     &3.0496e-02_r8,4.2068e-02_r8,3.8012e-02_r8,2.8228e-02_r8,6.0417e-03_r8/)
      kbo(:, 3,36, 6) = (/ &
     &4.1195e-02_r8,5.4532e-02_r8,4.8068e-02_r8,3.4542e-02_r8,6.1403e-03_r8/)
      kbo(:, 4,36, 6) = (/ &
     &5.4471e-02_r8,6.9759e-02_r8,6.0254e-02_r8,4.2072e-02_r8,6.2148e-03_r8/)
      kbo(:, 5,36, 6) = (/ &
     &7.0911e-02_r8,8.8088e-02_r8,7.4912e-02_r8,5.0992e-02_r8,6.2662e-03_r8/)
      kbo(:, 1,37, 6) = (/ &
     &1.9922e-02_r8,2.8852e-02_r8,2.6493e-02_r8,2.0135e-02_r8,4.8546e-03_r8/)
      kbo(:, 2,37, 6) = (/ &
     &2.7802e-02_r8,3.8202e-02_r8,3.4133e-02_r8,2.4969e-02_r8,4.9597e-03_r8/)
      kbo(:, 3,37, 6) = (/ &
     &3.7750e-02_r8,4.9930e-02_r8,4.3532e-02_r8,3.0816e-02_r8,5.0441e-03_r8/)
      kbo(:, 4,37, 6) = (/ &
     &5.0184e-02_r8,6.4346e-02_r8,5.5012e-02_r8,3.7855e-02_r8,5.1082e-03_r8/)
      kbo(:, 5,37, 6) = (/ &
     &6.5650e-02_r8,8.1819e-02_r8,6.8970e-02_r8,4.6262e-02_r8,5.1546e-03_r8/)
      kbo(:, 1,38, 6) = (/ &
     &1.8261e-02_r8,2.6220e-02_r8,2.3783e-02_r8,1.7789e-02_r8,3.9817e-03_r8/)
      kbo(:, 2,38, 6) = (/ &
     &2.5634e-02_r8,3.5047e-02_r8,3.0941e-02_r8,2.2280e-02_r8,4.0729e-03_r8/)
      kbo(:, 3,38, 6) = (/ &
     &3.5007e-02_r8,4.6188e-02_r8,3.9826e-02_r8,2.7761e-02_r8,4.1447e-03_r8/)
      kbo(:, 4,38, 6) = (/ &
     &4.6818e-02_r8,5.9985e-02_r8,5.0782e-02_r8,3.4412e-02_r8,4.1996e-03_r8/)
      kbo(:, 5,38, 6) = (/ &
     &6.1549e-02_r8,7.6851e-02_r8,6.4240e-02_r8,4.2442e-02_r8,4.2409e-03_r8/)
      kbo(:, 1,39, 6) = (/ &
     &1.7120e-02_r8,2.4268e-02_r8,2.1723e-02_r8,1.5967e-02_r8,3.2683e-03_r8/)
      kbo(:, 2,39, 6) = (/ &
     &2.4172e-02_r8,3.2753e-02_r8,2.8567e-02_r8,2.0215e-02_r8,3.3454e-03_r8/)
      kbo(:, 3,39, 6) = (/ &
     &3.3206e-02_r8,4.3552e-02_r8,3.7135e-02_r8,2.5455e-02_r8,3.4062e-03_r8/)
      kbo(:, 4,39, 6) = (/ &
     &4.4652e-02_r8,5.7021e-02_r8,4.7802e-02_r8,3.1863e-02_r8,3.4542e-03_r8/)
      kbo(:, 5,39, 6) = (/ &
     &5.8989e-02_r8,7.3628e-02_r8,6.1045e-02_r8,3.9701e-02_r8,3.4927e-03_r8/)
      kbo(:, 1,40, 6) = (/ &
     &1.4508e-02_r8,2.0729e-02_r8,1.8466e-02_r8,1.3481e-02_r8,2.6735e-03_r8/)
      kbo(:, 2,40, 6) = (/ &
     &2.0675e-02_r8,2.8264e-02_r8,2.4526e-02_r8,1.7230e-02_r8,2.7394e-03_r8/)
      kbo(:, 3,40, 6) = (/ &
     &2.8640e-02_r8,3.7952e-02_r8,3.2186e-02_r8,2.1896e-02_r8,2.7930e-03_r8/)
      kbo(:, 4,40, 6) = (/ &
     &3.8810e-02_r8,5.0166e-02_r8,4.1826e-02_r8,2.7660e-02_r8,2.8356e-03_r8/)
      kbo(:, 5,40, 6) = (/ &
     &5.1624e-02_r8,6.5327e-02_r8,5.3925e-02_r8,3.4781e-02_r8,2.8708e-03_r8/)
      kbo(:, 1,41, 6) = (/ &
     &1.2173e-02_r8,1.7558e-02_r8,1.5577e-02_r8,1.1317e-02_r8,2.1860e-03_r8/)
      kbo(:, 2,41, 6) = (/ &
     &1.7521e-02_r8,2.4204e-02_r8,2.0905e-02_r8,1.4606e-02_r8,2.2431e-03_r8/)
      kbo(:, 3,41, 6) = (/ &
     &2.4494e-02_r8,3.2840e-02_r8,2.7710e-02_r8,1.8738e-02_r8,2.2897e-03_r8/)
      kbo(:, 4,41, 6) = (/ &
     &3.3465e-02_r8,4.3838e-02_r8,3.6359e-02_r8,2.3890e-02_r8,2.3273e-03_r8/)
      kbo(:, 5,41, 6) = (/ &
     &4.4815e-02_r8,5.7614e-02_r8,4.7337e-02_r8,3.0319e-02_r8,2.3593e-03_r8/)
      kbo(:, 1,42, 6) = (/ &
     &1.0295e-02_r8,1.4955e-02_r8,1.3204e-02_r8,9.5463e-03_r8,1.7869e-03_r8/)
      kbo(:, 2,42, 6) = (/ &
     &1.4969e-02_r8,2.0854e-02_r8,1.7923e-02_r8,1.2449e-02_r8,1.8368e-03_r8/)
      kbo(:, 3,42, 6) = (/ &
     &2.1120e-02_r8,2.8597e-02_r8,2.4004e-02_r8,1.6130e-02_r8,1.8766e-03_r8/)
      kbo(:, 4,42, 6) = (/ &
     &2.9097e-02_r8,3.8565e-02_r8,3.1822e-02_r8,2.0764e-02_r8,1.9105e-03_r8/)
      kbo(:, 5,42, 6) = (/ &
     &3.9250e-02_r8,5.1179e-02_r8,4.1851e-02_r8,2.6620e-02_r8,1.9390e-03_r8/)
      kbo(:, 1,43, 6) = (/ &
     &8.5600e-03_r8,1.2537e-02_r8,1.1032e-02_r8,7.9541e-03_r8,1.4581e-03_r8/)
      kbo(:, 2,43, 6) = (/ &
     &1.2604e-02_r8,1.7710e-02_r8,1.5163e-02_r8,1.0490e-02_r8,1.5008e-03_r8/)
      kbo(:, 3,43, 6) = (/ &
     &1.7986e-02_r8,2.4578e-02_r8,2.0552e-02_r8,1.3738e-02_r8,1.5357e-03_r8/)
      kbo(:, 4,43, 6) = (/ &
     &2.5016e-02_r8,3.3532e-02_r8,2.7550e-02_r8,1.7878e-02_r8,1.5671e-03_r8/)
      kbo(:, 5,43, 6) = (/ &
     &3.4031e-02_r8,4.4978e-02_r8,3.6624e-02_r8,2.3164e-02_r8,1.5928e-03_r8/)
      kbo(:, 1,44, 6) = (/ &
     &7.1102e-03_r8,1.0482e-02_r8,9.1923e-03_r8,6.6123e-03_r8,1.1883e-03_r8/)
      kbo(:, 2,44, 6) = (/ &
     &1.0618e-02_r8,1.5014e-02_r8,1.2809e-02_r8,8.8284e-03_r8,1.2254e-03_r8/)
      kbo(:, 3,44, 6) = (/ &
     &1.5336e-02_r8,2.1109e-02_r8,1.7587e-02_r8,1.1700e-02_r8,1.2566e-03_r8/)
      kbo(:, 4,44, 6) = (/ &
     &2.1558e-02_r8,2.9159e-02_r8,2.3862e-02_r8,1.5404e-02_r8,1.2849e-03_r8/)
      kbo(:, 5,44, 6) = (/ &
     &2.9601e-02_r8,3.9572e-02_r8,3.2092e-02_r8,2.0188e-02_r8,1.3081e-03_r8/)
      kbo(:, 1,45, 6) = (/ &
     &5.9959e-03_r8,8.8564e-03_r8,7.7363e-03_r8,5.5453e-03_r8,9.6825e-04_r8/)
      kbo(:, 2,45, 6) = (/ &
     &9.0798e-03_r8,1.2878e-02_r8,1.0936e-02_r8,7.5039e-03_r8,1.0003e-03_r8/)
      kbo(:, 3,45, 6) = (/ &
     &1.3290e-02_r8,1.8346e-02_r8,1.5227e-02_r8,1.0074e-02_r8,1.0284e-03_r8/)
      kbo(:, 4,45, 6) = (/ &
     &1.8884e-02_r8,2.5678e-02_r8,2.0927e-02_r8,1.3427e-02_r8,1.0535e-03_r8/)
      kbo(:, 5,45, 6) = (/ &
     &2.6185e-02_r8,3.5270e-02_r8,2.8485e-02_r8,1.7812e-02_r8,1.0746e-03_r8/)
      kbo(:, 1,46, 6) = (/ &
     &5.0299e-03_r8,7.4350e-03_r8,6.4749e-03_r8,4.6277e-03_r8,7.8776e-04_r8/)
      kbo(:, 2,46, 6) = (/ &
     &7.7400e-03_r8,1.0992e-02_r8,9.2918e-03_r8,6.3536e-03_r8,8.1609e-04_r8/)
      kbo(:, 3,46, 6) = (/ &
     &1.1482e-02_r8,1.5887e-02_r8,1.3136e-02_r8,8.6493e-03_r8,8.4114e-04_r8/)
      kbo(:, 4,46, 6) = (/ &
     &1.6521e-02_r8,2.2547e-02_r8,1.8306e-02_r8,1.1680e-02_r8,8.6343e-04_r8/)
      kbo(:, 5,46, 6) = (/ &
     &2.3160e-02_r8,3.1365e-02_r8,2.5232e-02_r8,1.5694e-02_r8,8.8222e-04_r8/)
      kbo(:, 1,47, 6) = (/ &
     &4.0735e-03_r8,6.0481e-03_r8,5.2664e-03_r8,3.7670e-03_r8,6.3966e-04_r8/)
      kbo(:, 2,47, 6) = (/ &
     &6.3819e-03_r8,9.1048e-03_r8,7.6804e-03_r8,5.2485e-03_r8,6.6459e-04_r8/)
      kbo(:, 3,47, 6) = (/ &
     &9.6180e-03_r8,1.3376e-02_r8,1.1030e-02_r8,7.2481e-03_r8,6.8646e-04_r8/)
      kbo(:, 4,47, 6) = (/ &
     &1.4038e-02_r8,1.9266e-02_r8,1.5600e-02_r8,9.9209e-03_r8,7.0632e-04_r8/)
      kbo(:, 5,47, 6) = (/ &
     &1.9923e-02_r8,2.7168e-02_r8,2.1786e-02_r8,1.3500e-02_r8,7.2294e-04_r8/)
      kbo(:, 1,48, 6) = (/ &
     &3.3654e-03_r8,4.9911e-03_r8,4.3393e-03_r8,3.1001e-03_r8,5.1894e-04_r8/)
      kbo(:, 2,48, 6) = (/ &
     &5.3738e-03_r8,7.6583e-03_r8,6.4413e-03_r8,4.3896e-03_r8,5.4055e-04_r8/)
      kbo(:, 3,48, 6) = (/ &
     &8.2348e-03_r8,1.1452e-02_r8,9.4090e-03_r8,6.1594e-03_r8,5.5982e-04_r8/)
      kbo(:, 4,48, 6) = (/ &
     &1.2194e-02_r8,1.6751e-02_r8,1.3518e-02_r8,8.5585e-03_r8,5.7759e-04_r8/)
      kbo(:, 5,48, 6) = (/ &
     &1.7535e-02_r8,2.3969e-02_r8,1.9153e-02_r8,1.1809e-02_r8,5.9223e-04_r8/)
      kbo(:, 1,49, 6) = (/ &
     &2.8714e-03_r8,4.2192e-03_r8,3.6533e-03_r8,2.6003e-03_r8,4.2066e-04_r8/)
      kbo(:, 2,49, 6) = (/ &
     &4.6796e-03_r8,6.6096e-03_r8,5.5332e-03_r8,3.7482e-03_r8,4.3948e-04_r8/)
      kbo(:, 3,49, 6) = (/ &
     &7.3002e-03_r8,1.0080e-02_r8,8.2347e-03_r8,5.3596e-03_r8,4.5652e-04_r8/)
      kbo(:, 4,49, 6) = (/ &
     &1.0971e-02_r8,1.4981e-02_r8,1.2046e-02_r8,7.5739e-03_r8,4.7234e-04_r8/)
      kbo(:, 5,49, 6) = (/ &
     &1.5995e-02_r8,2.1767e-02_r8,1.7330e-02_r8,1.0614e-02_r8,4.8568e-04_r8/)
      kbo(:, 1,50, 6) = (/ &
     &2.3434e-03_r8,3.4410e-03_r8,2.9786e-03_r8,2.1205e-03_r8,3.4069e-04_r8/)
      kbo(:, 2,50, 6) = (/ &
     &3.8971e-03_r8,5.4992e-03_r8,4.5940e-03_r8,3.1036e-03_r8,3.5714e-04_r8/)
      kbo(:, 3,50, 6) = (/ &
     &6.1900e-03_r8,8.5460e-03_r8,6.9553e-03_r8,4.5152e-03_r8,3.7212e-04_r8/)
      kbo(:, 4,50, 6) = (/ &
     &9.4451e-03_r8,1.2909e-02_r8,1.0349e-02_r8,6.4854e-03_r8,3.8582e-04_r8/)
      kbo(:, 5,50, 6) = (/ &
     &1.3954e-02_r8,1.9042e-02_r8,1.5119e-02_r8,9.2171e-03_r8,3.9788e-04_r8/)
      kbo(:, 1,51, 6) = (/ &
     &1.8670e-03_r8,2.7492e-03_r8,2.3841e-03_r8,1.7021e-03_r8,2.7578e-04_r8/)
      kbo(:, 2,51, 6) = (/ &
     &3.1678e-03_r8,4.4826e-03_r8,3.7408e-03_r8,2.5267e-03_r8,2.9005e-04_r8/)
      kbo(:, 3,51, 6) = (/ &
     &5.1260e-03_r8,7.0985e-03_r8,5.7656e-03_r8,3.7383e-03_r8,3.0300e-04_r8/)
      kbo(:, 4,51, 6) = (/ &
     &7.9439e-03_r8,1.0904e-02_r8,8.7196e-03_r8,5.4539e-03_r8,3.1487e-04_r8/)
      kbo(:, 5,51, 6) = (/ &
     &1.1900e-02_r8,1.6326e-02_r8,1.2929e-02_r8,7.8597e-03_r8,3.2578e-04_r8/)
      kbo(:, 1,52, 6) = (/ &
     &1.5181e-03_r8,2.2298e-03_r8,1.9337e-03_r8,1.3821e-03_r8,2.2294e-04_r8/)
      kbo(:, 2,52, 6) = (/ &
     &2.6323e-03_r8,3.7113e-03_r8,3.0904e-03_r8,2.0844e-03_r8,2.3535e-04_r8/)
      kbo(:, 3,52, 6) = (/ &
     &4.3389e-03_r8,5.9943e-03_r8,4.8574e-03_r8,3.1382e-03_r8,2.4655e-04_r8/)
      kbo(:, 4,52, 6) = (/ &
     &6.8363e-03_r8,9.3770e-03_r8,7.4736e-03_r8,4.6599e-03_r8,2.5711e-04_r8/)
      kbo(:, 5,52, 6) = (/ &
     &1.0389e-02_r8,1.4256e-02_r8,1.1263e-02_r8,6.8242e-03_r8,2.6665e-04_r8/)
      kbo(:, 1,53, 6) = (/ &
     &1.2752e-03_r8,1.8531e-03_r8,1.6024e-03_r8,1.1428e-03_r8,1.8014e-04_r8/)
      kbo(:, 2,53, 6) = (/ &
     &2.2594e-03_r8,3.1508e-03_r8,2.6140e-03_r8,1.7561e-03_r8,1.9085e-04_r8/)
      kbo(:, 3,53, 6) = (/ &
     &3.7990e-03_r8,5.2013e-03_r8,4.1982e-03_r8,2.6961e-03_r8,2.0067e-04_r8/)
      kbo(:, 4,53, 6) = (/ &
     &6.0922e-03_r8,8.2959e-03_r8,6.5816e-03_r8,4.0835e-03_r8,2.0982e-04_r8/)
      kbo(:, 5,53, 6) = (/ &
     &9.3947e-03_r8,1.2809e-02_r8,1.0095e-02_r8,6.0875e-03_r8,2.1819e-04_r8/)
      kbo(:, 1,54, 6) = (/ &
     &9.3663e-04_r8,1.3820e-03_r8,1.2040e-03_r8,8.6807e-04_r8,1.4544e-04_r8/)
      kbo(:, 2,54, 6) = (/ &
     &1.6914e-03_r8,2.3887e-03_r8,1.9911e-03_r8,1.3482e-03_r8,1.5460e-04_r8/)
      kbo(:, 3,54, 6) = (/ &
     &2.8997e-03_r8,4.0201e-03_r8,3.2494e-03_r8,2.0953e-03_r8,1.6297e-04_r8/)
      kbo(:, 4,54, 6) = (/ &
     &4.7306e-03_r8,6.5273e-03_r8,5.1758e-03_r8,3.2189e-03_r8,1.7075e-04_r8/)
      kbo(:, 5,54, 6) = (/ &
     &7.3984e-03_r8,1.0238e-02_r8,8.0539e-03_r8,4.8622e-03_r8,1.7797e-04_r8/)
      kbo(:, 1,55, 6) = (/ &
     &6.2935e-04_r8,9.5969e-04_r8,8.4900e-04_r8,6.2465e-04_r8,1.1738e-04_r8/)
      kbo(:, 2,55, 6) = (/ &
     &1.1558e-03_r8,1.6799e-03_r8,1.4161e-03_r8,9.7472e-04_r8,1.2508e-04_r8/)
      kbo(:, 3,55, 6) = (/ &
     &2.0209e-03_r8,2.8749e-03_r8,2.3378e-03_r8,1.5244e-03_r8,1.3211e-04_r8/)
      kbo(:, 4,55, 6) = (/ &
     &3.3522e-03_r8,4.7482e-03_r8,3.7736e-03_r8,2.3654e-03_r8,1.3870e-04_r8/)
      kbo(:, 5,55, 6) = (/ &
     &5.3187e-03_r8,7.5686e-03_r8,5.9480e-03_r8,3.6106e-03_r8,1.4478e-04_r8/)
      kbo(:, 1,56, 6) = (/ &
     &4.2101e-04_r8,6.6332e-04_r8,5.9672e-04_r8,4.4860e-04_r8,9.4587e-05_r8/)
      kbo(:, 2,56, 6) = (/ &
     &7.8466e-04_r8,1.1752e-03_r8,1.0029e-03_r8,7.0318e-04_r8,1.0112e-04_r8/)
      kbo(:, 3,56, 6) = (/ &
     &1.3999e-03_r8,2.0432e-03_r8,1.6739e-03_r8,1.1053e-03_r8,1.0709e-04_r8/)
      kbo(:, 4,56, 6) = (/ &
     &2.3635e-03_r8,3.4329e-03_r8,2.7372e-03_r8,1.7318e-03_r8,1.1258e-04_r8/)
      kbo(:, 5,56, 6) = (/ &
     &3.8069e-03_r8,5.5637e-03_r8,4.3696e-03_r8,2.6702e-03_r8,1.1773e-04_r8/)
      kbo(:, 1,57, 6) = (/ &
     &2.8076e-04_r8,4.5641e-04_r8,4.1815e-04_r8,3.2142e-04_r8,7.6115e-05_r8/)
      kbo(:, 2,57, 6) = (/ &
     &5.2895e-04_r8,8.1778e-04_r8,7.0771e-04_r8,5.0616e-04_r8,8.1716e-05_r8/)
      kbo(:, 3,57, 6) = (/ &
     &9.6334e-04_r8,1.4422e-03_r8,1.1917e-03_r8,7.9834e-04_r8,8.6757e-05_r8/)
      kbo(:, 4,57, 6) = (/ &
     &1.6571e-03_r8,2.4651e-03_r8,1.9746e-03_r8,1.2622e-03_r8,9.1332e-05_r8/)
      kbo(:, 5,57, 6) = (/ &
     &2.7119e-03_r8,4.0628e-03_r8,3.1926e-03_r8,1.9661e-03_r8,9.5684e-05_r8/)
      kbo(:, 1,58, 6) = (/ &
     &4.9720e-05_r8,1.0269e-04_r8,1.2366e-04_r8,1.3663e-04_r8,6.1273e-05_r8/)
      kbo(:, 2,58, 6) = (/ &
     &9.4473e-05_r8,1.8553e-04_r8,2.1007e-04_r8,2.1548e-04_r8,6.5992e-05_r8/)
      kbo(:, 3,58, 6) = (/ &
     &1.7530e-04_r8,3.3103e-04_r8,3.5575e-04_r8,3.4010e-04_r8,7.0239e-05_r8/)
      kbo(:, 4,58, 6) = (/ &
     &3.0720e-04_r8,5.7469e-04_r8,5.9600e-04_r8,5.4082e-04_r8,7.4141e-05_r8/)
      kbo(:, 5,58, 6) = (/ &
     &5.1103e-04_r8,9.6242e-04_r8,9.7487e-04_r8,8.4973e-04_r8,7.7747e-05_r8/)
      kbo(:, 1,59, 6) = (/ &
     &4.4314e-05_r8,9.6972e-05_r8,1.1293e-04_r8,1.1582e-04_r8,4.9949e-05_r8/)
      kbo(:, 2,59, 6) = (/ &
     &8.4700e-05_r8,1.7358e-04_r8,1.8881e-04_r8,1.7917e-04_r8,5.3859e-05_r8/)
      kbo(:, 3,59, 6) = (/ &
     &1.5856e-04_r8,3.0848e-04_r8,3.1562e-04_r8,2.7815e-04_r8,5.7310e-05_r8/)
      kbo(:, 4,59, 6) = (/ &
     &2.8032e-04_r8,5.3615e-04_r8,5.2587e-04_r8,4.3688e-04_r8,6.0507e-05_r8/)
      kbo(:, 5,59, 6) = (/ &
     &4.7008e-04_r8,9.0261e-04_r8,8.5908e-04_r8,6.8167e-04_r8,6.3447e-05_r8/)
      kbo(:, 1,13, 7) = (/ &
     &3.5002e+00_r8,2.8426e+00_r8,2.2229e+00_r8,1.5940e+00_r8,4.6284e-01_r8/)
      kbo(:, 2,13, 7) = (/ &
     &5.2764e+00_r8,4.1532e+00_r8,3.0774e+00_r8,2.0245e+00_r8,4.6449e-01_r8/)
      kbo(:, 3,13, 7) = (/ &
     &7.6096e+00_r8,5.8846e+00_r8,4.2048e+00_r8,2.5664e+00_r8,4.6564e-01_r8/)
      kbo(:, 4,13, 7) = (/ &
     &1.0545e+01_r8,8.0718e+00_r8,5.6353e+00_r8,3.2573e+00_r8,4.6805e-01_r8/)
      kbo(:, 5,13, 7) = (/ &
     &1.4101e+01_r8,1.0726e+01_r8,7.3776e+00_r8,4.1071e+00_r8,4.6959e-01_r8/)
      kbo(:, 1,14, 7) = (/ &
     &1.9332e+00_r8,1.6833e+00_r8,1.4584e+00_r8,1.1419e+00_r8,4.2549e-01_r8/)
      kbo(:, 2,14, 7) = (/ &
     &2.9208e+00_r8,2.4028e+00_r8,1.9264e+00_r8,1.4148e+00_r8,4.2845e-01_r8/)
      kbo(:, 3,14, 7) = (/ &
     &4.2111e+00_r8,3.3491e+00_r8,2.5401e+00_r8,1.7447e+00_r8,4.2997e-01_r8/)
      kbo(:, 4,14, 7) = (/ &
     &5.8219e+00_r8,4.5369e+00_r8,3.3137e+00_r8,2.1374e+00_r8,4.3233e-01_r8/)
      kbo(:, 5,14, 7) = (/ &
     &7.7805e+00_r8,5.9890e+00_r8,4.2588e+00_r8,2.5955e+00_r8,4.3475e-01_r8/)
      kbo(:, 1,15, 7) = (/ &
     &1.0958e+00_r8,1.0674e+00_r8,1.0130e+00_r8,8.4961e-01_r8,3.8730e-01_r8/)
      kbo(:, 2,15, 7) = (/ &
     &1.6536e+00_r8,1.4690e+00_r8,1.3041e+00_r8,1.0292e+00_r8,3.9101e-01_r8/)
      kbo(:, 3,15, 7) = (/ &
     &2.3745e+00_r8,1.9914e+00_r8,1.6603e+00_r8,1.2452e+00_r8,3.9344e-01_r8/)
      kbo(:, 4,15, 7) = (/ &
     &3.2750e+00_r8,2.6468e+00_r8,2.0887e+00_r8,1.4951e+00_r8,3.9613e-01_r8/)
      kbo(:, 5,15, 7) = (/ &
     &4.3749e+00_r8,3.4526e+00_r8,2.6092e+00_r8,1.7780e+00_r8,3.9900e-01_r8/)
      kbo(:, 1,16, 7) = (/ &
     &7.4165e-01_r8,8.0405e-01_r8,7.9283e-01_r8,6.9114e-01_r8,3.4911e-01_r8/)
      kbo(:, 2,16, 7) = (/ &
     &1.1136e+00_r8,1.0786e+00_r8,1.0091e+00_r8,8.2862e-01_r8,3.5314e-01_r8/)
      kbo(:, 3,16, 7) = (/ &
     &1.5923e+00_r8,1.4242e+00_r8,1.2681e+00_r8,9.9143e-01_r8,3.5636e-01_r8/)
      kbo(:, 4,16, 7) = (/ &
     &2.1926e+00_r8,1.8566e+00_r8,1.5712e+00_r8,1.1771e+00_r8,3.6013e-01_r8/)
      kbo(:, 5,16, 7) = (/ &
     &2.9285e+00_r8,2.3901e+00_r8,1.9279e+00_r8,1.3859e+00_r8,3.6399e-01_r8/)
      kbo(:, 1,17, 7) = (/ &
     &5.1887e-01_r8,6.2476e-01_r8,6.3724e-01_r8,5.7083e-01_r8,3.1167e-01_r8/)
      kbo(:, 2,17, 7) = (/ &
     &7.7486e-01_r8,8.2693e-01_r8,8.0143e-01_r8,6.7854e-01_r8,3.1621e-01_r8/)
      kbo(:, 3,17, 7) = (/ &
     &1.1045e+00_r8,1.0746e+00_r8,9.9649e-01_r8,8.0449e-01_r8,3.2014e-01_r8/)
      kbo(:, 4,17, 7) = (/ &
     &1.5180e+00_r8,1.3742e+00_r8,1.2231e+00_r8,9.4686e-01_r8,3.2461e-01_r8/)
      kbo(:, 5,17, 7) = (/ &
     &2.0257e+00_r8,1.7386e+00_r8,1.4858e+00_r8,1.1069e+00_r8,3.2955e-01_r8/)
      kbo(:, 1,18, 7) = (/ &
     &3.7097e-01_r8,4.9432e-01_r8,5.1840e-01_r8,4.7504e-01_r8,2.7614e-01_r8/)
      kbo(:, 2,18, 7) = (/ &
     &5.5115e-01_r8,6.4712e-01_r8,6.4514e-01_r8,5.6072e-01_r8,2.8084e-01_r8/)
      kbo(:, 3,18, 7) = (/ &
     &7.8296e-01_r8,8.3225e-01_r8,7.9447e-01_r8,6.5954e-01_r8,2.8571e-01_r8/)
      kbo(:, 4,18, 7) = (/ &
     &1.0738e+00_r8,1.0535e+00_r8,9.6779e-01_r8,7.7088e-01_r8,2.9112e-01_r8/)
      kbo(:, 5,18, 7) = (/ &
     &1.4335e+00_r8,1.3170e+00_r8,1.1664e+00_r8,8.9595e-01_r8,2.9703e-01_r8/)
      kbo(:, 1,19, 7) = (/ &
     &2.5985e-01_r8,3.8651e-01_r8,4.1602e-01_r8,3.9308e-01_r8,2.4307e-01_r8/)
      kbo(:, 2,19, 7) = (/ &
     &3.8422e-01_r8,5.0067e-01_r8,5.1275e-01_r8,4.5968e-01_r8,2.4809e-01_r8/)
      kbo(:, 3,19, 7) = (/ &
     &5.4420e-01_r8,6.3764e-01_r8,6.2617e-01_r8,5.3586e-01_r8,2.5358e-01_r8/)
      kbo(:, 4,19, 7) = (/ &
     &7.4603e-01_r8,7.9981e-01_r8,7.5671e-01_r8,6.2198e-01_r8,2.5998e-01_r8/)
      kbo(:, 5,19, 7) = (/ &
     &9.9708e-01_r8,9.9236e-01_r8,9.0617e-01_r8,7.1829e-01_r8,2.6615e-01_r8/)
      kbo(:, 1,20, 7) = (/ &
     &1.9760e-01_r8,3.1836e-01_r8,3.4770e-01_r8,3.3477e-01_r8,2.1277e-01_r8/)
      kbo(:, 2,20, 7) = (/ &
     &2.9095e-01_r8,4.0925e-01_r8,4.2592e-01_r8,3.8937e-01_r8,2.1827e-01_r8/)
      kbo(:, 3,20, 7) = (/ &
     &4.1127e-01_r8,5.1768e-01_r8,5.1739e-01_r8,4.5140e-01_r8,2.2458e-01_r8/)
      kbo(:, 4,20, 7) = (/ &
     &5.6427e-01_r8,6.4625e-01_r8,6.2247e-01_r8,5.2174e-01_r8,2.3101e-01_r8/)
      kbo(:, 5,20, 7) = (/ &
     &7.5526e-01_r8,7.9836e-01_r8,7.4304e-01_r8,6.0027e-01_r8,2.3711e-01_r8/)
      kbo(:, 1,21, 7) = (/ &
     &1.5484e-01_r8,2.6582e-01_r8,2.9382e-01_r8,2.8708e-01_r8,1.8550e-01_r8/)
      kbo(:, 2,21, 7) = (/ &
     &2.2722e-01_r8,3.3963e-01_r8,3.5832e-01_r8,3.3257e-01_r8,1.9141e-01_r8/)
      kbo(:, 3,21, 7) = (/ &
     &3.2108e-01_r8,4.2782e-01_r8,4.3333e-01_r8,3.8435e-01_r8,1.9782e-01_r8/)
      kbo(:, 4,21, 7) = (/ &
     &4.4098e-01_r8,5.3304e-01_r8,5.1997e-01_r8,4.4275e-01_r8,2.0379e-01_r8/)
      kbo(:, 5,21, 7) = (/ &
     &5.9030e-01_r8,6.5709e-01_r8,6.1970e-01_r8,5.0864e-01_r8,2.0956e-01_r8/)
      kbo(:, 1,22, 7) = (/ &
     &1.2753e-01_r8,2.2781e-01_r8,2.5360e-01_r8,2.4962e-01_r8,1.6164e-01_r8/)
      kbo(:, 2,22, 7) = (/ &
     &1.8637e-01_r8,2.8970e-01_r8,3.0789e-01_r8,2.8854e-01_r8,1.6761e-01_r8/)
      kbo(:, 3,22, 7) = (/ &
     &2.6299e-01_r8,3.6404e-01_r8,3.7114e-01_r8,3.3280e-01_r8,1.7333e-01_r8/)
      kbo(:, 4,22, 7) = (/ &
     &3.6059e-01_r8,4.5267e-01_r8,4.4472e-01_r8,3.8285e-01_r8,1.7883e-01_r8/)
      kbo(:, 5,22, 7) = (/ &
     &4.8104e-01_r8,5.5702e-01_r8,5.2923e-01_r8,4.3976e-01_r8,1.8428e-01_r8/)
      kbo(:, 1,23, 7) = (/ &
     &1.0589e-01_r8,1.9529e-01_r8,2.1876e-01_r8,2.1679e-01_r8,1.4037e-01_r8/)
      kbo(:, 2,23, 7) = (/ &
     &1.5420e-01_r8,2.4758e-01_r8,2.6461e-01_r8,2.5042e-01_r8,1.4579e-01_r8/)
      kbo(:, 3,23, 7) = (/ &
     &2.1702e-01_r8,3.1068e-01_r8,3.1854e-01_r8,2.8852e-01_r8,1.5094e-01_r8/)
      kbo(:, 4,23, 7) = (/ &
     &2.9661e-01_r8,3.8564e-01_r8,3.8128e-01_r8,3.3195e-01_r8,1.5614e-01_r8/)
      kbo(:, 5,23, 7) = (/ &
     &3.9397e-01_r8,4.7355e-01_r8,4.5341e-01_r8,3.8121e-01_r8,1.6132e-01_r8/)
      kbo(:, 1,24, 7) = (/ &
     &8.7788e-02_r8,1.6668e-01_r8,1.8799e-01_r8,1.8780e-01_r8,1.2140e-01_r8/)
      kbo(:, 2,24, 7) = (/ &
     &1.2734e-01_r8,2.1083e-01_r8,2.2703e-01_r8,2.1652e-01_r8,1.2618e-01_r8/)
      kbo(:, 3,24, 7) = (/ &
     &1.7857e-01_r8,2.6413e-01_r8,2.7303e-01_r8,2.4936e-01_r8,1.3098e-01_r8/)
      kbo(:, 4,24, 7) = (/ &
     &2.4296e-01_r8,3.2721e-01_r8,3.2661e-01_r8,2.8698e-01_r8,1.3586e-01_r8/)
      kbo(:, 5,24, 7) = (/ &
     &3.2098e-01_r8,4.0055e-01_r8,3.8785e-01_r8,3.2936e-01_r8,1.4075e-01_r8/)
      kbo(:, 1,25, 7) = (/ &
     &7.4114e-02_r8,1.4357e-01_r8,1.6268e-01_r8,1.6299e-01_r8,1.0454e-01_r8/)
      kbo(:, 2,25, 7) = (/ &
     &1.0696e-01_r8,1.8148e-01_r8,1.9639e-01_r8,1.8781e-01_r8,1.0890e-01_r8/)
      kbo(:, 3,25, 7) = (/ &
     &1.4921e-01_r8,2.2686e-01_r8,2.3627e-01_r8,2.1648e-01_r8,1.1337e-01_r8/)
      kbo(:, 4,25, 7) = (/ &
     &2.0169e-01_r8,2.8030e-01_r8,2.8233e-01_r8,2.4913e-01_r8,1.1793e-01_r8/)
      kbo(:, 5,25, 7) = (/ &
     &2.6511e-01_r8,3.4240e-01_r8,3.3494e-01_r8,2.8598e-01_r8,1.2261e-01_r8/)
      kbo(:, 1,26, 7) = (/ &
     &6.4102e-02_r8,1.2562e-01_r8,1.4220e-01_r8,1.4209e-01_r8,8.9836e-02_r8/)
      kbo(:, 2,26, 7) = (/ &
     &9.1903e-02_r8,1.5853e-01_r8,1.7179e-01_r8,1.6391e-01_r8,9.3830e-02_r8/)
      kbo(:, 3,26, 7) = (/ &
     &1.2732e-01_r8,1.9782e-01_r8,2.0670e-01_r8,1.8917e-01_r8,9.8002e-02_r8/)
      kbo(:, 4,26, 7) = (/ &
     &1.7095e-01_r8,2.4388e-01_r8,2.4691e-01_r8,2.1801e-01_r8,1.0234e-01_r8/)
      kbo(:, 5,26, 7) = (/ &
     &2.2376e-01_r8,2.9731e-01_r8,2.9277e-01_r8,2.5044e-01_r8,1.0674e-01_r8/)
      kbo(:, 1,27, 7) = (/ &
     &5.7622e-02_r8,1.1249e-01_r8,1.2636e-01_r8,1.2511e-01_r8,7.7055e-02_r8/)
      kbo(:, 2,27, 7) = (/ &
     &8.1983e-02_r8,1.4196e-01_r8,1.5312e-01_r8,1.4485e-01_r8,8.0791e-02_r8/)
      kbo(:, 3,27, 7) = (/ &
     &1.1275e-01_r8,1.7697e-01_r8,1.8437e-01_r8,1.6781e-01_r8,8.4713e-02_r8/)
      kbo(:, 4,27, 7) = (/ &
     &1.5055e-01_r8,2.1794e-01_r8,2.2039e-01_r8,1.9390e-01_r8,8.8731e-02_r8/)
      kbo(:, 5,27, 7) = (/ &
     &1.9638e-01_r8,2.6555e-01_r8,2.6132e-01_r8,2.2312e-01_r8,9.2655e-02_r8/)
      kbo(:, 1,28, 7) = (/ &
     &5.3140e-02_r8,1.0241e-01_r8,1.1379e-01_r8,1.1112e-01_r8,6.6059e-02_r8/)
      kbo(:, 2,28, 7) = (/ &
     &7.5045e-02_r8,1.2928e-01_r8,1.3817e-01_r8,1.2935e-01_r8,6.9529e-02_r8/)
      kbo(:, 3,28, 7) = (/ &
     &1.0252e-01_r8,1.6119e-01_r8,1.6672e-01_r8,1.5050e-01_r8,7.3142e-02_r8/)
      kbo(:, 4,28, 7) = (/ &
     &1.3625e-01_r8,1.9862e-01_r8,1.9953e-01_r8,1.7444e-01_r8,7.6746e-02_r8/)
      kbo(:, 5,28, 7) = (/ &
     &1.7752e-01_r8,2.4214e-01_r8,2.3714e-01_r8,2.0133e-01_r8,7.9941e-02_r8/)
      kbo(:, 1,29, 7) = (/ &
     &5.2099e-02_r8,9.6941e-02_r8,1.0563e-01_r8,1.0097e-01_r8,5.6668e-02_r8/)
      kbo(:, 2,29, 7) = (/ &
     &7.3009e-02_r8,1.2266e-01_r8,1.2890e-01_r8,1.1850e-01_r8,5.9859e-02_r8/)
      kbo(:, 3,29, 7) = (/ &
     &9.9110e-02_r8,1.5322e-01_r8,1.5608e-01_r8,1.3860e-01_r8,6.3089e-02_r8/)
      kbo(:, 4,29, 7) = (/ &
     &1.3136e-01_r8,1.8918e-01_r8,1.8750e-01_r8,1.6146e-01_r8,6.6000e-02_r8/)
      kbo(:, 5,29, 7) = (/ &
     &1.7133e-01_r8,2.3120e-01_r8,2.2375e-01_r8,1.8721e-01_r8,6.8384e-02_r8/)
      kbo(:, 1,30, 7) = (/ &
     &5.2298e-02_r8,9.3477e-02_r8,9.9631e-02_r8,9.3041e-02_r8,4.8653e-02_r8/)
      kbo(:, 2,30, 7) = (/ &
     &7.2744e-02_r8,1.1854e-01_r8,1.2224e-01_r8,1.0996e-01_r8,5.1507e-02_r8/)
      kbo(:, 3,30, 7) = (/ &
     &9.8307e-02_r8,1.4854e-01_r8,1.4866e-01_r8,1.2943e-01_r8,5.4141e-02_r8/)
      kbo(:, 4,30, 7) = (/ &
     &1.3030e-01_r8,1.8393e-01_r8,1.7946e-01_r8,1.5167e-01_r8,5.6316e-02_r8/)
      kbo(:, 5,30, 7) = (/ &
     &1.7017e-01_r8,2.2583e-01_r8,2.1516e-01_r8,1.7690e-01_r8,5.8003e-02_r8/)
      kbo(:, 1,31, 7) = (/ &
     &5.5237e-02_r8,9.3530e-02_r8,9.7080e-02_r8,8.7885e-02_r8,4.1801e-02_r8/)
      kbo(:, 2,31, 7) = (/ &
     &7.6342e-02_r8,1.1917e-01_r8,1.1987e-01_r8,1.0485e-01_r8,4.4162e-02_r8/)
      kbo(:, 3,31, 7) = (/ &
     &1.0297e-01_r8,1.4987e-01_r8,1.4665e-01_r8,1.2435e-01_r8,4.6139e-02_r8/)
      kbo(:, 4,31, 7) = (/ &
     &1.3657e-01_r8,1.8654e-01_r8,1.7810e-01_r8,1.4680e-01_r8,4.7704e-02_r8/)
      kbo(:, 5,31, 7) = (/ &
     &1.7842e-01_r8,2.3057e-01_r8,2.1509e-01_r8,1.7253e-01_r8,4.8947e-02_r8/)
      kbo(:, 1,32, 7) = (/ &
     &5.9027e-02_r8,9.4969e-02_r8,9.5943e-02_r8,8.4194e-02_r8,3.5812e-02_r8/)
      kbo(:, 2,32, 7) = (/ &
     &8.1201e-02_r8,1.2151e-01_r8,1.1922e-01_r8,1.0130e-01_r8,3.7617e-02_r8/)
      kbo(:, 3,32, 7) = (/ &
     &1.0955e-01_r8,1.5358e-01_r8,1.4681e-01_r8,1.2117e-01_r8,3.9058e-02_r8/)
      kbo(:, 4,32, 7) = (/ &
     &1.4540e-01_r8,1.9256e-01_r8,1.7966e-01_r8,1.4421e-01_r8,4.0236e-02_r8/)
      kbo(:, 5,32, 7) = (/ &
     &1.8982e-01_r8,2.3938e-01_r8,2.1889e-01_r8,1.7084e-01_r8,4.1181e-02_r8/)
      kbo(:, 1,33, 7) = (/ &
     &6.4219e-02_r8,9.8255e-02_r8,9.6625e-02_r8,8.2099e-02_r8,3.0519e-02_r8/)
      kbo(:, 2,33, 7) = (/ &
     &8.8246e-02_r8,1.2633e-01_r8,1.2088e-01_r8,9.9705e-02_r8,3.1855e-02_r8/)
      kbo(:, 3,33, 7) = (/ &
     &1.1912e-01_r8,1.6083e-01_r8,1.5001e-01_r8,1.2028e-01_r8,3.2953e-02_r8/)
      kbo(:, 4,33, 7) = (/ &
     &1.5802e-01_r8,2.0300e-01_r8,1.8528e-01_r8,1.4442e-01_r8,3.3850e-02_r8/)
      kbo(:, 5,33, 7) = (/ &
     &2.0596e-01_r8,2.5392e-01_r8,2.2791e-01_r8,1.7303e-01_r8,3.4585e-02_r8/)
      kbo(:, 1,34, 7) = (/ &
     &6.7485e-02_r8,9.9620e-02_r8,9.5868e-02_r8,7.9332e-02_r8,2.5830e-02_r8/)
      kbo(:, 2,34, 7) = (/ &
     &9.2815e-02_r8,1.2890e-01_r8,1.2075e-01_r8,9.7213e-02_r8,2.6848e-02_r8/)
      kbo(:, 3,34, 7) = (/ &
     &1.2537e-01_r8,1.6529e-01_r8,1.5122e-01_r8,1.1822e-01_r8,2.7699e-02_r8/)
      kbo(:, 4,34, 7) = (/ &
     &1.6617e-01_r8,2.0989e-01_r8,1.8860e-01_r8,1.4346e-01_r8,2.8411e-02_r8/)
      kbo(:, 5,34, 7) = (/ &
     &2.1641e-01_r8,2.6338e-01_r8,2.3365e-01_r8,1.7367e-01_r8,2.9006e-02_r8/)
      kbo(:, 1,35, 7) = (/ &
     &6.9002e-02_r8,9.9168e-02_r8,9.3611e-02_r8,7.5846e-02_r8,2.1704e-02_r8/)
      kbo(:, 2,35, 7) = (/ &
     &9.5177e-02_r8,1.2935e-01_r8,1.1903e-01_r8,9.3690e-02_r8,2.2517e-02_r8/)
      kbo(:, 3,35, 7) = (/ &
     &1.2872e-01_r8,1.6713e-01_r8,1.5066e-01_r8,1.1518e-01_r8,2.3202e-02_r8/)
      kbo(:, 4,35, 7) = (/ &
     &1.7076e-01_r8,2.1347e-01_r8,1.8964e-01_r8,1.4135e-01_r8,2.3785e-02_r8/)
      kbo(:, 5,35, 7) = (/ &
     &2.2264e-01_r8,2.6908e-01_r8,2.3665e-01_r8,1.7298e-01_r8,2.4252e-02_r8/)
      kbo(:, 1,36, 7) = (/ &
     &6.7865e-02_r8,9.5879e-02_r8,8.9211e-02_r8,7.0981e-02_r8,1.8133e-02_r8/)
      kbo(:, 2,36, 7) = (/ &
     &9.4007e-02_r8,1.2625e-01_r8,1.1466e-01_r8,8.8573e-02_r8,1.8797e-02_r8/)
      kbo(:, 3,36, 7) = (/ &
     &1.2751e-01_r8,1.6450e-01_r8,1.4669e-01_r8,1.1023e-01_r8,1.9364e-02_r8/)
      kbo(:, 4,36, 7) = (/ &
     &1.6969e-01_r8,2.1129e-01_r8,1.8634e-01_r8,1.3684e-01_r8,1.9848e-02_r8/)
      kbo(:, 5,36, 7) = (/ &
     &2.2199e-01_r8,2.6776e-01_r8,2.3416e-01_r8,1.6920e-01_r8,2.0253e-02_r8/)
      kbo(:, 1,37, 7) = (/ &
     &6.1910e-02_r8,8.7392e-02_r8,8.0722e-02_r8,6.3503e-02_r8,1.5050e-02_r8/)
      kbo(:, 2,37, 7) = (/ &
     &8.6402e-02_r8,1.1634e-01_r8,1.0496e-01_r8,8.0172e-02_r8,1.5605e-02_r8/)
      kbo(:, 3,37, 7) = (/ &
     &1.1792e-01_r8,1.5301e-01_r8,1.3575e-01_r8,1.0102e-01_r8,1.6089e-02_r8/)
      kbo(:, 4,37, 7) = (/ &
     &1.5786e-01_r8,1.9811e-01_r8,1.7416e-01_r8,1.2688e-01_r8,1.6504e-02_r8/)
      kbo(:, 5,37, 7) = (/ &
     &2.0776e-01_r8,2.5283e-01_r8,2.2073e-01_r8,1.5856e-01_r8,1.6861e-02_r8/)
      kbo(:, 1,38, 7) = (/ &
     &5.7180e-02_r8,8.0434e-02_r8,7.3641e-02_r8,5.7228e-02_r8,1.2479e-02_r8/)
      kbo(:, 2,38, 7) = (/ &
     &8.0361e-02_r8,1.0828e-01_r8,9.6955e-02_r8,7.3200e-02_r8,1.2947e-02_r8/)
      kbo(:, 3,38, 7) = (/ &
     &1.1043e-01_r8,1.4379e-01_r8,1.2688e-01_r8,9.3375e-02_r8,1.3365e-02_r8/)
      kbo(:, 4,38, 7) = (/ &
     &1.4883e-01_r8,1.8786e-01_r8,1.6450e-01_r8,1.1879e-01_r8,1.3732e-02_r8/)
      kbo(:, 5,38, 7) = (/ &
     &1.9707e-01_r8,2.4129e-01_r8,2.1013e-01_r8,1.4998e-01_r8,1.4049e-02_r8/)
      kbo(:, 1,39, 7) = (/ &
     &5.4044e-02_r8,7.5469e-02_r8,6.8324e-02_r8,5.2315e-02_r8,1.0342e-02_r8/)
      kbo(:, 2,39, 7) = (/ &
     &7.6525e-02_r8,1.0279e-01_r8,9.1154e-02_r8,6.7832e-02_r8,1.0747e-02_r8/)
      kbo(:, 3,39, 7) = (/ &
     &1.0591e-01_r8,1.3783e-01_r8,1.2080e-01_r8,8.7775e-02_r8,1.1116e-02_r8/)
      kbo(:, 4,39, 7) = (/ &
     &1.4369e-01_r8,1.8148e-01_r8,1.5809e-01_r8,1.1309e-01_r8,1.1438e-02_r8/)
      kbo(:, 5,39, 7) = (/ &
     &1.9144e-01_r8,2.3501e-01_r8,2.0393e-01_r8,1.4445e-01_r8,1.1716e-02_r8/)
      kbo(:, 1,40, 7) = (/ &
     &4.6217e-02_r8,6.5370e-02_r8,5.9012e-02_r8,4.4989e-02_r8,8.5358e-03_r8/)
      kbo(:, 2,40, 7) = (/ &
     &6.6114e-02_r8,9.0173e-02_r8,7.9777e-02_r8,5.9045e-02_r8,8.8901e-03_r8/)
      kbo(:, 3,40, 7) = (/ &
     &9.2339e-02_r8,1.2222e-01_r8,1.0699e-01_r8,7.7378e-02_r8,9.2084e-03_r8/)
      kbo(:, 4,40, 7) = (/ &
     &1.2639e-01_r8,1.6256e-01_r8,1.4164e-01_r8,1.0101e-01_r8,9.4930e-03_r8/)
      kbo(:, 5,40, 7) = (/ &
     &1.6986e-01_r8,2.1255e-01_r8,1.8467e-01_r8,1.3055e-01_r8,9.7467e-03_r8/)
      kbo(:, 1,41, 7) = (/ &
     &3.9155e-02_r8,5.6183e-02_r8,5.0596e-02_r8,3.8424e-02_r8,7.0383e-03_r8/)
      kbo(:, 2,41, 7) = (/ &
     &5.6659e-02_r8,7.8503e-02_r8,6.9340e-02_r8,5.1085e-02_r8,7.3470e-03_r8/)
      kbo(:, 3,41, 7) = (/ &
     &7.9928e-02_r8,1.0766e-01_r8,9.4225e-02_r8,6.7858e-02_r8,7.6230e-03_r8/)
      kbo(:, 4,41, 7) = (/ &
     &1.1042e-01_r8,1.4475e-01_r8,1.2626e-01_r8,8.9781e-02_r8,7.8762e-03_r8/)
      kbo(:, 5,41, 7) = (/ &
     &1.4975e-01_r8,1.9111e-01_r8,1.6637e-01_r8,1.1739e-01_r8,8.1039e-03_r8/)
      kbo(:, 1,42, 7) = (/ &
     &3.3442e-02_r8,4.8574e-02_r8,4.3613e-02_r8,3.2930e-02_r8,5.8050e-03_r8/)
      kbo(:, 2,42, 7) = (/ &
     &4.8965e-02_r8,6.8792e-02_r8,6.0620e-02_r8,4.4408e-02_r8,6.0682e-03_r8/)
      kbo(:, 3,42, 7) = (/ &
     &6.9803e-02_r8,9.5533e-02_r8,8.3532e-02_r8,5.9826e-02_r8,6.3116e-03_r8/)
      kbo(:, 4,42, 7) = (/ &
     &9.7360e-02_r8,1.2988e-01_r8,1.1328e-01_r8,8.0240e-02_r8,6.5330e-03_r8/)
      kbo(:, 5,42, 7) = (/ &
     &1.3333e-01_r8,1.7321e-01_r8,1.5102e-01_r8,1.0628e-01_r8,6.7345e-03_r8/)
      kbo(:, 1,43, 7) = (/ &
     &2.8074e-02_r8,4.1293e-02_r8,3.7000e-02_r8,2.7812e-02_r8,4.7712e-03_r8/)
      kbo(:, 2,43, 7) = (/ &
     &4.1661e-02_r8,5.9380e-02_r8,5.2205e-02_r8,3.8045e-02_r8,4.9985e-03_r8/)
      kbo(:, 3,43, 7) = (/ &
     &6.0156e-02_r8,8.3670e-02_r8,7.3060e-02_r8,5.2075e-02_r8,5.2119e-03_r8/)
      kbo(:, 4,43, 7) = (/ &
     &8.4838e-02_r8,1.1520e-01_r8,1.0043e-01_r8,7.0829e-02_r8,5.4068e-03_r8/)
      kbo(:, 5,43, 7) = (/ &
     &1.1748e-01_r8,1.5547e-01_r8,1.3568e-01_r8,9.5209e-02_r8,5.5907e-03_r8/)
      kbo(:, 1,44, 7) = (/ &
     &2.3517e-02_r8,3.4984e-02_r8,3.1261e-02_r8,2.3397e-02_r8,3.9133e-03_r8/)
      kbo(:, 2,44, 7) = (/ &
     &3.5440e-02_r8,5.1145e-02_r8,4.4838e-02_r8,3.2508e-02_r8,4.1113e-03_r8/)
      kbo(:, 3,44, 7) = (/ &
     &5.1856e-02_r8,7.3218e-02_r8,6.3748e-02_r8,4.5187e-02_r8,4.2980e-03_r8/)
      kbo(:, 4,44, 7) = (/ &
     &7.4068e-02_r8,1.0225e-01_r8,8.9058e-02_r8,6.2496e-02_r8,4.4682e-03_r8/)
      kbo(:, 5,44, 7) = (/ &
     &1.0378e-01_r8,1.3965e-01_r8,1.2187e-01_r8,8.5218e-02_r8,4.6319e-03_r8/)
      kbo(:, 1,45, 7) = (/ &
     &1.9987e-02_r8,2.9948e-02_r8,2.6638e-02_r8,1.9815e-02_r8,3.2076e-03_r8/)
      kbo(:, 2,45, 7) = (/ &
     &3.0595e-02_r8,4.4514e-02_r8,3.8859e-02_r8,2.7978e-02_r8,3.3798e-03_r8/)
      kbo(:, 3,45, 7) = (/ &
     &4.5403e-02_r8,6.4811e-02_r8,5.6194e-02_r8,3.9557e-02_r8,3.5406e-03_r8/)
      kbo(:, 4,45, 7) = (/ &
     &6.5696e-02_r8,9.1866e-02_r8,7.9797e-02_r8,5.5645e-02_r8,3.6912e-03_r8/)
      kbo(:, 5,45, 7) = (/ &
     &9.3194e-02_r8,1.2710e-01_r8,1.1078e-01_r8,7.7097e-02_r8,3.8387e-03_r8/)
      kbo(:, 1,46, 7) = (/ &
     &1.6883e-02_r8,2.5455e-02_r8,2.2540e-02_r8,1.6677e-02_r8,2.6234e-03_r8/)
      kbo(:, 2,46, 7) = (/ &
     &2.6297e-02_r8,3.8534e-02_r8,3.3486e-02_r8,2.3954e-02_r8,2.7725e-03_r8/)
      kbo(:, 3,46, 7) = (/ &
     &3.9636e-02_r8,5.7120e-02_r8,4.9278e-02_r8,3.4454e-02_r8,2.9133e-03_r8/)
      kbo(:, 4,46, 7) = (/ &
     &5.8158e-02_r8,8.2259e-02_r8,7.1230e-02_r8,4.9351e-02_r8,3.0483e-03_r8/)
      kbo(:, 5,46, 7) = (/ &
     &8.3561e-02_r8,1.1543e-01_r8,1.0042e-01_r8,6.9545e-02_r8,3.1794e-03_r8/)
      kbo(:, 1,47, 7) = (/ &
     &1.3750e-02_r8,2.0931e-02_r8,1.8489e-02_r8,1.3652e-02_r8,2.1369e-03_r8/)
      kbo(:, 2,47, 7) = (/ &
     &2.1838e-02_r8,3.2305e-02_r8,2.7989e-02_r8,1.9957e-02_r8,2.2678e-03_r8/)
      kbo(:, 3,47, 7) = (/ &
     &3.3497e-02_r8,4.8835e-02_r8,4.1985e-02_r8,2.9214e-02_r8,2.3899e-03_r8/)
      kbo(:, 4,47, 7) = (/ &
     &4.9929e-02_r8,7.1624e-02_r8,6.1836e-02_r8,4.2605e-02_r8,2.5094e-03_r8/)
      kbo(:, 5,47, 7) = (/ &
     &7.2757e-02_r8,1.0217e-01_r8,8.8738e-02_r8,6.1180e-02_r8,2.6247e-03_r8/)
      kbo(:, 1,48, 7) = (/ &
     &1.1414e-02_r8,1.7437e-02_r8,1.5334e-02_r8,1.1272e-02_r8,1.7386e-03_r8/)
      kbo(:, 2,48, 7) = (/ &
     &1.8495e-02_r8,2.7458e-02_r8,2.3694e-02_r8,1.6798e-02_r8,1.8526e-03_r8/)
      kbo(:, 3,48, 7) = (/ &
     &2.8896e-02_r8,4.2355e-02_r8,3.6253e-02_r8,2.5061e-02_r8,1.9592e-03_r8/)
      kbo(:, 4,48, 7) = (/ &
     &4.3780e-02_r8,6.3320e-02_r8,5.4439e-02_r8,3.7255e-02_r8,2.0628e-03_r8/)
      kbo(:, 5,48, 7) = (/ &
     &6.4736e-02_r8,9.1889e-02_r8,7.9609e-02_r8,5.4563e-02_r8,2.1644e-03_r8/)
      kbo(:, 1,49, 7) = (/ &
     &9.7792e-03_r8,1.4862e-02_r8,1.2975e-02_r8,9.4608e-03_r8,1.4121e-03_r8/)
      kbo(:, 2,49, 7) = (/ &
     &1.6175e-02_r8,2.3898e-02_r8,2.0488e-02_r8,1.4406e-02_r8,1.5117e-03_r8/)
      kbo(:, 3,49, 7) = (/ &
     &2.5763e-02_r8,3.7620e-02_r8,3.1995e-02_r8,2.1936e-02_r8,1.6039e-03_r8/)
      kbo(:, 4,49, 7) = (/ &
     &3.9714e-02_r8,5.7411e-02_r8,4.9041e-02_r8,3.3299e-02_r8,1.6946e-03_r8/)
      kbo(:, 5,49, 7) = (/ &
     &5.9638e-02_r8,8.4793e-02_r8,7.3080e-02_r8,4.9749e-02_r8,1.7852e-03_r8/)
      kbo(:, 1,50, 7) = (/ &
     &8.0131e-03_r8,1.2216e-02_r8,1.0631e-02_r8,7.7241e-03_r8,1.1467e-03_r8/)
      kbo(:, 2,50, 7) = (/ &
     &1.3522e-02_r8,2.0069e-02_r8,1.7141e-02_r8,1.2008e-02_r8,1.2327e-03_r8/)
      kbo(:, 3,50, 7) = (/ &
     &2.1961e-02_r8,3.2239e-02_r8,2.7314e-02_r8,1.8640e-02_r8,1.3124e-03_r8/)
      kbo(:, 4,50, 7) = (/ &
     &3.4440e-02_r8,5.0209e-02_r8,4.2737e-02_r8,2.8885e-02_r8,1.3920e-03_r8/)
      kbo(:, 5,50, 7) = (/ &
     &5.2495e-02_r8,7.5521e-02_r8,6.4947e-02_r8,4.4030e-02_r8,1.4733e-03_r8/)
      kbo(:, 1,51, 7) = (/ &
     &6.4036e-03_r8,9.8290e-03_r8,8.5406e-03_r8,6.2032e-03_r8,9.3043e-04_r8/)
      kbo(:, 2,51, 7) = (/ &
     &1.1026e-02_r8,1.6501e-02_r8,1.4064e-02_r8,9.8397e-03_r8,1.0045e-03_r8/)
      kbo(:, 3,51, 7) = (/ &
     &1.8273e-02_r8,2.7056e-02_r8,2.2864e-02_r8,1.5565e-02_r8,1.0742e-03_r8/)
      kbo(:, 4,51, 7) = (/ &
     &2.9163e-02_r8,4.3028e-02_r8,3.6523e-02_r8,2.4601e-02_r8,1.1437e-03_r8/)
      kbo(:, 5,51, 7) = (/ &
     &4.5145e-02_r8,6.5958e-02_r8,5.6628e-02_r8,3.8264e-02_r8,1.2140e-03_r8/)
      kbo(:, 1,52, 7) = (/ &
     &5.2190e-03_r8,8.0088e-03_r8,6.9367e-03_r8,5.0245e-03_r8,7.5434e-04_r8/)
      kbo(:, 2,52, 7) = (/ &
     &9.1694e-03_r8,1.3764e-02_r8,1.1684e-02_r8,8.1486e-03_r8,8.1834e-04_r8/)
      kbo(:, 3,52, 7) = (/ &
     &1.5524e-02_r8,2.3049e-02_r8,1.9394e-02_r8,1.3151e-02_r8,8.7913e-04_r8/)
      kbo(:, 4,52, 7) = (/ &
     &2.5232e-02_r8,3.7442e-02_r8,3.1647e-02_r8,2.1215e-02_r8,9.3902e-04_r8/)
      kbo(:, 5,52, 7) = (/ &
     &3.9698e-02_r8,5.8529e-02_r8,5.0101e-02_r8,3.3714e-02_r8,1.0010e-03_r8/)
      kbo(:, 1,53, 7) = (/ &
     &4.3882e-03_r8,6.6717e-03_r8,5.7454e-03_r8,4.1343e-03_r8,6.1055e-04_r8/)
      kbo(:, 2,53, 7) = (/ &
     &7.8762e-03_r8,1.1762e-02_r8,9.9163e-03_r8,6.8660e-03_r8,6.6611e-04_r8/)
      kbo(:, 3,53, 7) = (/ &
     &1.3621e-02_r8,2.0115e-02_r8,1.6825e-02_r8,1.1330e-02_r8,7.1874e-04_r8/)
      kbo(:, 4,53, 7) = (/ &
     &2.2577e-02_r8,3.3386e-02_r8,2.8049e-02_r8,1.8668e-02_r8,7.7087e-04_r8/)
      kbo(:, 5,53, 7) = (/ &
     &3.6135e-02_r8,5.3261e-02_r8,4.5341e-02_r8,3.0337e-02_r8,8.2493e-04_r8/)
      kbo(:, 1,54, 7) = (/ &
     &3.2171e-03_r8,4.9791e-03_r8,4.3152e-03_r8,3.1327e-03_r8,4.9375e-04_r8/)
      kbo(:, 2,54, 7) = (/ &
     &5.9006e-03_r8,8.9891e-03_r8,7.6027e-03_r8,5.2931e-03_r8,5.4126e-04_r8/)
      kbo(:, 3,54, 7) = (/ &
     &1.0411e-02_r8,1.5699e-02_r8,1.3153e-02_r8,8.8893e-03_r8,5.8635e-04_r8/)
      kbo(:, 4,54, 7) = (/ &
     &1.7599e-02_r8,2.6636e-02_r8,2.2397e-02_r8,1.4923e-02_r8,6.3108e-04_r8/)
      kbo(:, 5,54, 7) = (/ &
     &2.8648e-02_r8,4.3428e-02_r8,3.7016e-02_r8,2.4766e-02_r8,6.7747e-04_r8/)
      kbo(:, 1,55, 7) = (/ &
     &2.1501e-03_r8,3.4516e-03_r8,3.0360e-03_r8,2.2475e-03_r8,3.9872e-04_r8/)
      kbo(:, 2,55, 7) = (/ &
     &4.0344e-03_r8,6.3713e-03_r8,5.4431e-03_r8,3.8454e-03_r8,4.3910e-04_r8/)
      kbo(:, 3,55, 7) = (/ &
     &7.2610e-03_r8,1.1366e-02_r8,9.5883e-03_r8,6.5518e-03_r8,4.7768e-04_r8/)
      kbo(:, 4,55, 7) = (/ &
     &1.2517e-02_r8,1.9714e-02_r8,1.6657e-02_r8,1.1171e-02_r8,5.1535e-04_r8/)
      kbo(:, 5,55, 7) = (/ &
     &2.0727e-02_r8,3.2905e-02_r8,2.8181e-02_r8,1.8908e-02_r8,5.5486e-04_r8/)
      kbo(:, 1,56, 7) = (/ &
     &1.4245e-03_r8,2.3749e-03_r8,2.1236e-03_r8,1.6049e-03_r8,3.2130e-04_r8/)
      kbo(:, 2,56, 7) = (/ &
     &2.7381e-03_r8,4.4799e-03_r8,3.8718e-03_r8,2.7798e-03_r8,3.5587e-04_r8/)
      kbo(:, 3,56, 7) = (/ &
     &5.0259e-03_r8,8.1674e-03_r8,6.9450e-03_r8,4.8004e-03_r8,3.8862e-04_r8/)
      kbo(:, 4,56, 7) = (/ &
     &8.8432e-03_r8,1.4489e-02_r8,1.2307e-02_r8,8.3071e-03_r8,4.2064e-04_r8/)
      kbo(:, 5,56, 7) = (/ &
     &1.4910e-02_r8,2.4779e-02_r8,2.1310e-02_r8,1.4337e-02_r8,4.5360e-04_r8/)
      kbo(:, 1,57, 7) = (/ &
     &9.3471e-04_r8,1.6209e-03_r8,1.4751e-03_r8,1.1411e-03_r8,2.5838e-04_r8/)
      kbo(:, 2,57, 7) = (/ &
     &1.8436e-03_r8,3.1233e-03_r8,2.7344e-03_r8,1.9986e-03_r8,2.8780e-04_r8/)
      kbo(:, 3,57, 7) = (/ &
     &3.4502e-03_r8,5.8213e-03_r8,4.9934e-03_r8,3.4957e-03_r8,3.1565e-04_r8/)
      kbo(:, 4,57, 7) = (/ &
     &6.2020e-03_r8,1.0562e-02_r8,9.0212e-03_r8,6.1326e-03_r8,3.4283e-04_r8/)
      kbo(:, 5,57, 7) = (/ &
     &1.0656e-02_r8,1.8525e-02_r8,1.5995e-02_r8,1.0788e-02_r8,3.7043e-04_r8/)
      kbo(:, 1,58, 7) = (/ &
     &1.6224e-04_r8,3.6080e-04_r8,4.3166e-04_r8,4.8123e-04_r8,2.0767e-04_r8/)
      kbo(:, 2,58, 7) = (/ &
     &3.2835e-04_r8,7.0851e-04_r8,8.1160e-04_r8,8.4893e-04_r8,2.3260e-04_r8/)
      kbo(:, 3,58, 7) = (/ &
     &6.2650e-04_r8,1.3493e-03_r8,1.5057e-03_r8,1.4999e-03_r8,2.5617e-04_r8/)
      kbo(:, 4,58, 7) = (/ &
     &1.1500e-03_r8,2.5038e-03_r8,2.7715e-03_r8,2.6635e-03_r8,2.7921e-04_r8/)
      kbo(:, 5,58, 7) = (/ &
     &2.0128e-03_r8,4.5008e-03_r8,5.0240e-03_r8,4.7643e-03_r8,3.0249e-04_r8/)
      kbo(:, 1,59, 7) = (/ &
     &1.4374e-04_r8,3.4167e-04_r8,3.9743e-04_r8,4.1474e-04_r8,1.7016e-04_r8/)
      kbo(:, 2,59, 7) = (/ &
     &2.9460e-04_r8,6.7320e-04_r8,7.4449e-04_r8,7.2184e-04_r8,1.9072e-04_r8/)
      kbo(:, 3,59, 7) = (/ &
     &5.6936e-04_r8,1.2962e-03_r8,1.3859e-03_r8,1.2659e-03_r8,2.1044e-04_r8/)
      kbo(:, 4,59, 7) = (/ &
     &1.0579e-03_r8,2.4467e-03_r8,2.5761e-03_r8,2.2456e-03_r8,2.2959e-04_r8/)
      kbo(:, 5,59, 7) = (/ &
     &1.8733e-03_r8,4.4959e-03_r8,4.7523e-03_r8,4.0463e-03_r8,2.4889e-04_r8/)
      kbo(:, 1,13, 8) = (/ &
     &1.0984e+01_r8,8.3644e+00_r8,5.8323e+00_r8,3.5207e+00_r8,9.5573e-01_r8/)
      kbo(:, 2,13, 8) = (/ &
     &1.6457e+01_r8,1.2460e+01_r8,8.5024e+00_r8,4.7543e+00_r8,9.4898e-01_r8/)
      kbo(:, 3,13, 8) = (/ &
     &2.3514e+01_r8,1.7749e+01_r8,1.1998e+01_r8,6.4125e+00_r8,9.3955e-01_r8/)
      kbo(:, 4,13, 8) = (/ &
     &3.2333e+01_r8,2.4359e+01_r8,1.6389e+01_r8,8.5253e+00_r8,9.2689e-01_r8/)
      kbo(:, 5,13, 8) = (/ &
     &4.3124e+01_r8,3.2448e+01_r8,2.1775e+01_r8,1.1152e+01_r8,9.1779e-01_r8/)
      kbo(:, 1,14, 8) = (/ &
     &6.1000e+00_r8,4.7207e+00_r8,3.5104e+00_r8,2.4718e+00_r8,9.1734e-01_r8/)
      kbo(:, 2,14, 8) = (/ &
     &9.1253e+00_r8,6.9681e+00_r8,4.9378e+00_r8,3.1340e+00_r8,9.1181e-01_r8/)
      kbo(:, 3,14, 8) = (/ &
     &1.3035e+01_r8,9.8900e+00_r8,6.8208e+00_r8,3.9957e+00_r8,9.0546e-01_r8/)
      kbo(:, 4,14, 8) = (/ &
     &1.7969e+01_r8,1.3584e+01_r8,9.2328e+00_r8,5.1032e+00_r8,8.9760e-01_r8/)
      kbo(:, 5,14, 8) = (/ &
     &2.4021e+01_r8,1.8119e+01_r8,1.2229e+01_r8,6.5133e+00_r8,8.8920e-01_r8/)
      kbo(:, 1,15, 8) = (/ &
     &3.4743e+00_r8,2.8067e+00_r8,2.3437e+00_r8,1.8996e+00_r8,8.7156e-01_r8/)
      kbo(:, 2,15, 8) = (/ &
     &5.1884e+00_r8,4.0500e+00_r8,3.1125e+00_r8,2.2977e+00_r8,8.6786e-01_r8/)
      kbo(:, 3,15, 8) = (/ &
     &7.4263e+00_r8,5.6964e+00_r8,4.1330e+00_r8,2.7795e+00_r8,8.6394e-01_r8/)
      kbo(:, 4,15, 8) = (/ &
     &1.0261e+01_r8,7.8059e+00_r8,5.4699e+00_r8,3.3858e+00_r8,8.5908e-01_r8/)
      kbo(:, 5,15, 8) = (/ &
     &1.3736e+01_r8,1.0405e+01_r8,7.1459e+00_r8,4.1475e+00_r8,8.5337e-01_r8/)
      kbo(:, 1,16, 8) = (/ &
     &2.3668e+00_r8,2.0348e+00_r8,1.8716e+00_r8,1.6135e+00_r8,8.1894e-01_r8/)
      kbo(:, 2,16, 8) = (/ &
     &3.5375e+00_r8,2.8566e+00_r8,2.3918e+00_r8,1.9179e+00_r8,8.1793e-01_r8/)
      kbo(:, 3,16, 8) = (/ &
     &5.0738e+00_r8,3.9641e+00_r8,3.0738e+00_r8,2.2799e+00_r8,8.1574e-01_r8/)
      kbo(:, 4,16, 8) = (/ &
     &7.0147e+00_r8,5.3888e+00_r8,3.9564e+00_r8,2.7115e+00_r8,8.1291e-01_r8/)
      kbo(:, 5,16, 8) = (/ &
     &9.3829e+00_r8,7.1458e+00_r8,5.0571e+00_r8,3.2258e+00_r8,8.0943e-01_r8/)
      kbo(:, 1,17, 8) = (/ &
     &1.6738e+00_r8,1.5709e+00_r8,1.5512e+00_r8,1.3915e+00_r8,7.6163e-01_r8/)
      kbo(:, 2,17, 8) = (/ &
     &2.5071e+00_r8,2.1423e+00_r8,1.9466e+00_r8,1.6331e+00_r8,7.6194e-01_r8/)
      kbo(:, 3,17, 8) = (/ &
     &3.5973e+00_r8,2.9044e+00_r8,2.4376e+00_r8,1.9200e+00_r8,7.6176e-01_r8/)
      kbo(:, 4,17, 8) = (/ &
     &4.9653e+00_r8,3.8871e+00_r8,3.0499e+00_r8,2.2591e+00_r8,7.6112e-01_r8/)
      kbo(:, 5,17, 8) = (/ &
     &6.6200e+00_r8,5.0972e+00_r8,3.7961e+00_r8,2.6511e+00_r8,7.6001e-01_r8/)
      kbo(:, 1,18, 8) = (/ &
     &1.2159e+00_r8,1.2682e+00_r8,1.3055e+00_r8,1.2114e+00_r8,6.9972e-01_r8/)
      kbo(:, 2,18, 8) = (/ &
     &1.8215e+00_r8,1.6846e+00_r8,1.6207e+00_r8,1.4074e+00_r8,7.0172e-01_r8/)
      kbo(:, 3,18, 8) = (/ &
     &2.6063e+00_r8,2.2250e+00_r8,2.0059e+00_r8,1.6407e+00_r8,7.0349e-01_r8/)
      kbo(:, 4,18, 8) = (/ &
     &3.5864e+00_r8,2.9083e+00_r8,2.4603e+00_r8,1.9137e+00_r8,7.0440e-01_r8/)
      kbo(:, 5,18, 8) = (/ &
     &4.7701e+00_r8,3.7503e+00_r8,2.9936e+00_r8,2.2226e+00_r8,7.0559e-01_r8/)
      kbo(:, 1,19, 8) = (/ &
     &8.6896e-01_r8,1.0218e+00_r8,1.0917e+00_r8,1.0431e+00_r8,6.3571e-01_r8/)
      kbo(:, 2,19, 8) = (/ &
     &1.2971e+00_r8,1.3348e+00_r8,1.3390e+00_r8,1.2022e+00_r8,6.3915e-01_r8/)
      kbo(:, 3,19, 8) = (/ &
     &1.8500e+00_r8,1.7190e+00_r8,1.6367e+00_r8,1.3904e+00_r8,6.4265e-01_r8/)
      kbo(:, 4,19, 8) = (/ &
     &2.5377e+00_r8,2.1918e+00_r8,1.9845e+00_r8,1.6067e+00_r8,6.4523e-01_r8/)
      kbo(:, 5,19, 8) = (/ &
     &3.3694e+00_r8,2.7695e+00_r8,2.3848e+00_r8,1.8478e+00_r8,6.4962e-01_r8/)
      kbo(:, 1,20, 8) = (/ &
     &6.7593e-01_r8,8.7052e-01_r8,9.5066e-01_r8,9.1950e-01_r8,5.7154e-01_r8/)
      kbo(:, 2,20, 8) = (/ &
     &1.0037e+00_r8,1.1265e+00_r8,1.1588e+00_r8,1.0572e+00_r8,5.7670e-01_r8/)
      kbo(:, 3,20, 8) = (/ &
     &1.4256e+00_r8,1.4357e+00_r8,1.4052e+00_r8,1.2186e+00_r8,5.8150e-01_r8/)
      kbo(:, 4,20, 8) = (/ &
     &1.9488e+00_r8,1.8041e+00_r8,1.6911e+00_r8,1.4006e+00_r8,5.8703e-01_r8/)
      kbo(:, 5,20, 8) = (/ &
     &2.5835e+00_r8,2.2440e+00_r8,2.0193e+00_r8,1.6034e+00_r8,5.9399e-01_r8/)
      kbo(:, 1,21, 8) = (/ &
     &5.4036e-01_r8,7.5420e-01_r8,8.3572e-01_r8,8.1199e-01_r8,5.0987e-01_r8/)
      kbo(:, 2,21, 8) = (/ &
     &7.9845e-01_r8,9.6809e-01_r8,1.0141e+00_r8,9.3456e-01_r8,5.1627e-01_r8/)
      kbo(:, 3,21, 8) = (/ &
     &1.1289e+00_r8,1.2252e+00_r8,1.2225e+00_r8,1.0751e+00_r8,5.2292e-01_r8/)
      kbo(:, 4,21, 8) = (/ &
     &1.5394e+00_r8,1.5293e+00_r8,1.4635e+00_r8,1.2321e+00_r8,5.3121e-01_r8/)
      kbo(:, 5,21, 8) = (/ &
     &2.0388e+00_r8,1.8858e+00_r8,1.7395e+00_r8,1.4066e+00_r8,5.4074e-01_r8/)
      kbo(:, 1,22, 8) = (/ &
     &4.5347e-01_r8,6.7088e-01_r8,7.4705e-01_r8,7.2463e-01_r8,4.5233e-01_r8/)
      kbo(:, 2,22, 8) = (/ &
     &6.6420e-01_r8,8.5466e-01_r8,9.0352e-01_r8,8.3532e-01_r8,4.6020e-01_r8/)
      kbo(:, 3,22, 8) = (/ &
     &9.3312e-01_r8,1.0751e+00_r8,1.0854e+00_r8,9.5995e-01_r8,4.6942e-01_r8/)
      kbo(:, 4,22, 8) = (/ &
     &1.2674e+00_r8,1.3357e+00_r8,1.2944e+00_r8,1.0988e+00_r8,4.8015e-01_r8/)
      kbo(:, 5,22, 8) = (/ &
     &1.6769e+00_r8,1.6408e+00_r8,1.5338e+00_r8,1.2527e+00_r8,4.9182e-01_r8/)
      kbo(:, 1,23, 8) = (/ &
     &3.8192e-01_r8,5.9551e-01_r8,6.6526e-01_r8,6.4489e-01_r8,3.9997e-01_r8/)
      kbo(:, 2,23, 8) = (/ &
     &5.5484e-01_r8,7.5433e-01_r8,8.0227e-01_r8,7.4370e-01_r8,4.0956e-01_r8/)
      kbo(:, 3,23, 8) = (/ &
     &7.7517e-01_r8,9.4347e-01_r8,9.6125e-01_r8,8.5431e-01_r8,4.2064e-01_r8/)
      kbo(:, 4,23, 8) = (/ &
     &1.0504e+00_r8,1.1678e+00_r8,1.1437e+00_r8,9.7728e-01_r8,4.3319e-01_r8/)
      kbo(:, 5,23, 8) = (/ &
     &1.3891e+00_r8,1.4314e+00_r8,1.3533e+00_r8,1.1142e+00_r8,4.4599e-01_r8/)
      kbo(:, 1,24, 8) = (/ &
     &3.1980e-01_r8,5.2485e-01_r8,5.8816e-01_r8,5.7121e-01_r8,3.5303e-01_r8/)
      kbo(:, 2,24, 8) = (/ &
     &4.6136e-01_r8,6.6155e-01_r8,7.0757e-01_r8,6.5873e-01_r8,3.6427e-01_r8/)
      kbo(:, 3,24, 8) = (/ &
     &6.4223e-01_r8,8.2371e-01_r8,8.4561e-01_r8,7.5649e-01_r8,3.7674e-01_r8/)
      kbo(:, 4,24, 8) = (/ &
     &8.6939e-01_r8,1.0172e+00_r8,1.0047e+00_r8,8.6558e-01_r8,3.8981e-01_r8/)
      kbo(:, 5,24, 8) = (/ &
     &1.1484e+00_r8,1.2449e+00_r8,1.1880e+00_r8,9.8717e-01_r8,4.0255e-01_r8/)
      kbo(:, 1,25, 8) = (/ &
     &2.7156e-01_r8,4.6457e-01_r8,5.2127e-01_r8,5.0714e-01_r8,3.1176e-01_r8/)
      kbo(:, 2,25, 8) = (/ &
     &3.8962e-01_r8,5.8326e-01_r8,6.2605e-01_r8,5.8521e-01_r8,3.2376e-01_r8/)
      kbo(:, 3,25, 8) = (/ &
     &5.4140e-01_r8,7.2573e-01_r8,7.4721e-01_r8,6.7267e-01_r8,3.3654e-01_r8/)
      kbo(:, 4,25, 8) = (/ &
     &7.3158e-01_r8,8.9514e-01_r8,8.8800e-01_r8,7.7033e-01_r8,3.4916e-01_r8/)
      kbo(:, 5,25, 8) = (/ &
     &9.6557e-01_r8,1.0940e+00_r8,1.0510e+00_r8,8.7991e-01_r8,3.6188e-01_r8/)
      kbo(:, 1,26, 8) = (/ &
     &2.3603e-01_r8,4.1514e-01_r8,4.6570e-01_r8,4.5317e-01_r8,2.7528e-01_r8/)
      kbo(:, 2,26, 8) = (/ &
     &3.3729e-01_r8,5.2062e-01_r8,5.5904e-01_r8,5.2356e-01_r8,2.8722e-01_r8/)
      kbo(:, 3,26, 8) = (/ &
     &4.6762e-01_r8,6.4812e-01_r8,6.6791e-01_r8,6.0289e-01_r8,2.9963e-01_r8/)
      kbo(:, 4,26, 8) = (/ &
     &6.3043e-01_r8,7.9949e-01_r8,7.9540e-01_r8,6.9207e-01_r8,3.1197e-01_r8/)
      kbo(:, 5,26, 8) = (/ &
     &8.2894e-01_r8,9.7604e-01_r8,9.4222e-01_r8,7.9275e-01_r8,3.2460e-01_r8/)
      kbo(:, 1,27, 8) = (/ &
     &2.1329e-01_r8,3.7886e-01_r8,4.2295e-01_r8,4.0982e-01_r8,2.4262e-01_r8/)
      kbo(:, 2,27, 8) = (/ &
     &3.0405e-01_r8,4.7609e-01_r8,5.0881e-01_r8,4.7490e-01_r8,2.5434e-01_r8/)
      kbo(:, 3,27, 8) = (/ &
     &4.2047e-01_r8,5.9404e-01_r8,6.1027e-01_r8,5.4870e-01_r8,2.6611e-01_r8/)
      kbo(:, 4,27, 8) = (/ &
     &5.6493e-01_r8,7.3338e-01_r8,7.2904e-01_r8,6.3251e-01_r8,2.7831e-01_r8/)
      kbo(:, 5,27, 8) = (/ &
     &7.3961e-01_r8,8.9452e-01_r8,8.6490e-01_r8,7.2735e-01_r8,2.9101e-01_r8/)
      kbo(:, 1,28, 8) = (/ &
     &1.9857e-01_r8,3.5152e-01_r8,3.8897e-01_r8,3.7421e-01_r8,2.1366e-01_r8/)
      kbo(:, 2,28, 8) = (/ &
     &2.8199e-01_r8,4.4350e-01_r8,4.7029e-01_r8,4.3552e-01_r8,2.2475e-01_r8/)
      kbo(:, 3,28, 8) = (/ &
     &3.8828e-01_r8,5.5465e-01_r8,5.6697e-01_r8,5.0558e-01_r8,2.3636e-01_r8/)
      kbo(:, 4,28, 8) = (/ &
     &5.1944e-01_r8,6.8554e-01_r8,6.7950e-01_r8,5.8599e-01_r8,2.4843e-01_r8/)
      kbo(:, 5,28, 8) = (/ &
     &6.7804e-01_r8,8.3583e-01_r8,8.0789e-01_r8,6.7686e-01_r8,2.6132e-01_r8/)
      kbo(:, 1,29, 8) = (/ &
     &1.9699e-01_r8,3.4001e-01_r8,3.6948e-01_r8,3.4985e-01_r8,1.8812e-01_r8/)
      kbo(:, 2,29, 8) = (/ &
     &2.7846e-01_r8,4.3155e-01_r8,4.5041e-01_r8,4.0987e-01_r8,1.9891e-01_r8/)
      kbo(:, 3,29, 8) = (/ &
     &3.8140e-01_r8,5.4168e-01_r8,5.4658e-01_r8,4.7968e-01_r8,2.1027e-01_r8/)
      kbo(:, 4,29, 8) = (/ &
     &5.0817e-01_r8,6.7028e-01_r8,6.5795e-01_r8,5.5982e-01_r8,2.2267e-01_r8/)
      kbo(:, 5,29, 8) = (/ &
     &6.6092e-01_r8,8.1811e-01_r8,7.8466e-01_r8,6.5003e-01_r8,2.3569e-01_r8/)
      kbo(:, 1,30, 8) = (/ &
     &2.0038e-01_r8,3.3558e-01_r8,3.5744e-01_r8,3.3111e-01_r8,1.6586e-01_r8/)
      kbo(:, 2,30, 8) = (/ &
     &2.8170e-01_r8,4.2849e-01_r8,4.3945e-01_r8,3.9159e-01_r8,1.7645e-01_r8/)
      kbo(:, 3,30, 8) = (/ &
     &3.8386e-01_r8,5.3939e-01_r8,5.3663e-01_r8,4.6240e-01_r8,1.8797e-01_r8/)
      kbo(:, 4,30, 8) = (/ &
     &5.0944e-01_r8,6.6904e-01_r8,6.4909e-01_r8,5.4342e-01_r8,2.0032e-01_r8/)
      kbo(:, 5,30, 8) = (/ &
     &6.6110e-01_r8,8.1719e-01_r8,7.7645e-01_r8,6.3464e-01_r8,2.1343e-01_r8/)
      kbo(:, 1,31, 8) = (/ &
     &2.1457e-01_r8,3.4491e-01_r8,3.5799e-01_r8,3.2199e-01_r8,1.4677e-01_r8/)
      kbo(:, 2,31, 8) = (/ &
     &3.0025e-01_r8,4.4295e-01_r8,4.4440e-01_r8,3.8528e-01_r8,1.5733e-01_r8/)
      kbo(:, 3,31, 8) = (/ &
     &4.0706e-01_r8,5.5909e-01_r8,5.4635e-01_r8,4.5932e-01_r8,1.6888e-01_r8/)
      kbo(:, 4,31, 8) = (/ &
     &5.3865e-01_r8,6.9458e-01_r8,6.6400e-01_r8,5.4394e-01_r8,1.8129e-01_r8/)
      kbo(:, 5,31, 8) = (/ &
     &6.9836e-01_r8,8.4979e-01_r8,7.9754e-01_r8,6.3956e-01_r8,1.9424e-01_r8/)
      kbo(:, 1,32, 8) = (/ &
     &2.3301e-01_r8,3.6002e-01_r8,3.6447e-01_r8,3.1806e-01_r8,1.3061e-01_r8/)
      kbo(:, 2,32, 8) = (/ &
     &3.2391e-01_r8,4.6378e-01_r8,4.5628e-01_r8,3.8494e-01_r8,1.4116e-01_r8/)
      kbo(:, 3,32, 8) = (/ &
     &4.3762e-01_r8,5.8716e-01_r8,5.6420e-01_r8,4.6300e-01_r8,1.5266e-01_r8/)
      kbo(:, 4,32, 8) = (/ &
     &5.7844e-01_r8,7.3058e-01_r8,6.8894e-01_r8,5.5249e-01_r8,1.6489e-01_r8/)
      kbo(:, 5,32, 8) = (/ &
     &7.5012e-01_r8,8.9521e-01_r8,8.3056e-01_r8,6.5369e-01_r8,1.7758e-01_r8/)
      kbo(:, 1,33, 8) = (/ &
     &2.5790e-01_r8,3.8312e-01_r8,3.7883e-01_r8,3.2071e-01_r8,1.1691e-01_r8/)
      kbo(:, 2,33, 8) = (/ &
     &3.5669e-01_r8,4.9524e-01_r8,4.7746e-01_r8,3.9236e-01_r8,1.2744e-01_r8/)
      kbo(:, 3,33, 8) = (/ &
     &4.8068e-01_r8,6.2777e-01_r8,5.9359e-01_r8,4.7601e-01_r8,1.3874e-01_r8/)
      kbo(:, 4,33, 8) = (/ &
     &6.3465e-01_r8,7.8244e-01_r8,7.2784e-01_r8,5.7215e-01_r8,1.5065e-01_r8/)
      kbo(:, 5,33, 8) = (/ &
     &8.2463e-01_r8,9.6158e-01_r8,8.8094e-01_r8,6.8112e-01_r8,1.6290e-01_r8/)
      kbo(:, 1,34, 8) = (/ &
     &2.7501e-01_r8,3.9928e-01_r8,3.8789e-01_r8,3.2093e-01_r8,1.0495e-01_r8/)
      kbo(:, 2,34, 8) = (/ &
     &3.7955e-01_r8,5.1722e-01_r8,4.9202e-01_r8,3.9633e-01_r8,1.1524e-01_r8/)
      kbo(:, 3,34, 8) = (/ &
     &5.1074e-01_r8,6.5671e-01_r8,6.1416e-01_r8,4.8473e-01_r8,1.2623e-01_r8/)
      kbo(:, 4,34, 8) = (/ &
     &6.7545e-01_r8,8.2065e-01_r8,7.5592e-01_r8,5.8631e-01_r8,1.3772e-01_r8/)
      kbo(:, 5,34, 8) = (/ &
     &8.8010e-01_r8,1.0115e+00_r8,9.1893e-01_r8,7.0176e-01_r8,1.4967e-01_r8/)
      kbo(:, 1,35, 8) = (/ &
     &2.8491e-01_r8,4.0792e-01_r8,3.9124e-01_r8,3.1768e-01_r8,9.3815e-02_r8/)
      kbo(:, 2,35, 8) = (/ &
     &3.9304e-01_r8,5.3008e-01_r8,4.9917e-01_r8,3.9612e-01_r8,1.0372e-01_r8/)
      kbo(:, 3,35, 8) = (/ &
     &5.3059e-01_r8,6.7569e-01_r8,6.2665e-01_r8,4.8824e-01_r8,1.1431e-01_r8/)
      kbo(:, 4,35, 8) = (/ &
     &7.0463e-01_r8,8.4744e-01_r8,7.7517e-01_r8,5.9483e-01_r8,1.2547e-01_r8/)
      kbo(:, 5,35, 8) = (/ &
     &9.2289e-01_r8,1.0490e+00_r8,9.4773e-01_r8,7.1638e-01_r8,1.3729e-01_r8/)
      kbo(:, 1,36, 8) = (/ &
     &2.8335e-01_r8,4.0444e-01_r8,3.8444e-01_r8,3.0785e-01_r8,8.3181e-02_r8/)
      kbo(:, 2,36, 8) = (/ &
     &3.9231e-01_r8,5.2837e-01_r8,4.9425e-01_r8,3.8787e-01_r8,9.2674e-02_r8/)
      kbo(:, 3,36, 8) = (/ &
     &5.3277e-01_r8,6.7716e-01_r8,6.2485e-01_r8,4.8257e-01_r8,1.0284e-01_r8/)
      kbo(:, 4,36, 8) = (/ &
     &7.1164e-01_r8,8.5400e-01_r8,7.7825e-01_r8,5.9239e-01_r8,1.1370e-01_r8/)
      kbo(:, 5,36, 8) = (/ &
     &9.3841e-01_r8,1.0634e+00_r8,9.5733e-01_r8,7.1881e-01_r8,1.2521e-01_r8/)
      kbo(:, 1,37, 8) = (/ &
     &2.6099e-01_r8,3.7794e-01_r8,3.5839e-01_r8,2.8510e-01_r8,7.2608e-02_r8/)
      kbo(:, 2,37, 8) = (/ &
     &3.6453e-01_r8,4.9803e-01_r8,4.6544e-01_r8,3.6354e-01_r8,8.1599e-02_r8/)
      kbo(:, 3,37, 8) = (/ &
     &4.9925e-01_r8,6.4313e-01_r8,5.9376e-01_r8,4.5692e-01_r8,9.1324e-02_r8/)
      kbo(:, 4,37, 8) = (/ &
     &6.7318e-01_r8,8.1735e-01_r8,7.4579e-01_r8,5.6616e-01_r8,1.0177e-01_r8/)
      kbo(:, 5,37, 8) = (/ &
     &8.9497e-01_r8,1.0258e+00_r8,9.2402e-01_r8,6.9303e-01_r8,1.1300e-01_r8/)
      kbo(:, 1,38, 8) = (/ &
     &2.4331e-01_r8,3.5651e-01_r8,3.3705e-01_r8,2.6611e-01_r8,6.3364e-02_r8/)
      kbo(:, 2,38, 8) = (/ &
     &3.4315e-01_r8,4.7401e-01_r8,4.4240e-01_r8,3.4349e-01_r8,7.1841e-02_r8/)
      kbo(:, 3,38, 8) = (/ &
     &4.7415e-01_r8,6.1710e-01_r8,5.6959e-01_r8,4.3645e-01_r8,8.1122e-02_r8/)
      kbo(:, 4,38, 8) = (/ &
     &6.4535e-01_r8,7.9084e-01_r8,7.2136e-01_r8,5.4612e-01_r8,9.1255e-02_r8/)
      kbo(:, 5,38, 8) = (/ &
     &8.6575e-01_r8,1.0005e+00_r8,9.0147e-01_r8,6.7461e-01_r8,1.0216e-01_r8/)
      kbo(:, 1,39, 8) = (/ &
     &2.3205e-01_r8,3.4217e-01_r8,3.2219e-01_r8,2.5204e-01_r8,5.5366e-02_r8/)
      kbo(:, 2,39, 8) = (/ &
     &3.3051e-01_r8,4.5923e-01_r8,4.2752e-01_r8,3.2956e-01_r8,6.3325e-02_r8/)
      kbo(:, 3,39, 8) = (/ &
     &4.6126e-01_r8,6.0310e-01_r8,5.5564e-01_r8,4.2338e-01_r8,7.2166e-02_r8/)
      kbo(:, 4,39, 8) = (/ &
     &6.3405e-01_r8,7.7976e-01_r8,7.0985e-01_r8,5.3501e-01_r8,8.2008e-02_r8/)
      kbo(:, 5,39, 8) = (/ &
     &8.5903e-01_r8,9.9488e-01_r8,8.9458e-01_r8,6.6726e-01_r8,9.2704e-02_r8/)
      kbo(:, 1,40, 8) = (/ &
     &2.0024e-01_r8,3.0416e-01_r8,2.8720e-01_r8,2.2448e-01_r8,4.7646e-02_r8/)
      kbo(:, 2,40, 8) = (/ &
     &2.8846e-01_r8,4.1256e-01_r8,3.8572e-01_r8,2.9759e-01_r8,5.5021e-02_r8/)
      kbo(:, 3,40, 8) = (/ &
     &4.0740e-01_r8,5.4726e-01_r8,5.0694e-01_r8,3.8698e-01_r8,6.3373e-02_r8/)
      kbo(:, 4,40, 8) = (/ &
     &5.6679e-01_r8,7.1454e-01_r8,6.5407e-01_r8,4.9457e-01_r8,7.2804e-02_r8/)
      kbo(:, 5,40, 8) = (/ &
     &7.7703e-01_r8,9.2066e-01_r8,8.3239e-01_r8,6.2266e-01_r8,8.3210e-02_r8/)
      kbo(:, 1,41, 8) = (/ &
     &1.7113e-01_r8,2.6826e-01_r8,2.5417e-01_r8,1.9867e-01_r8,4.0876e-02_r8/)
      kbo(:, 2,41, 8) = (/ &
     &2.4978e-01_r8,3.6831e-01_r8,3.4599e-01_r8,2.6723e-01_r8,4.7680e-02_r8/)
      kbo(:, 3,41, 8) = (/ &
     &3.5705e-01_r8,4.9395e-01_r8,4.5991e-01_r8,3.5185e-01_r8,5.5528e-02_r8/)
      kbo(:, 4,41, 8) = (/ &
     &5.0326e-01_r8,6.5160e-01_r8,5.9993e-01_r8,4.5499e-01_r8,6.4535e-02_r8/)
      kbo(:, 5,41, 8) = (/ &
     &6.9778e-01_r8,8.4752e-01_r8,7.7088e-01_r8,5.7861e-01_r8,7.4659e-02_r8/)
      kbo(:, 1,42, 8) = (/ &
     &1.4736e-01_r8,2.3782e-01_r8,2.2594e-01_r8,1.7650e-01_r8,3.4992e-02_r8/)
      kbo(:, 2,42, 8) = (/ &
     &2.1817e-01_r8,3.3087e-01_r8,3.1198e-01_r8,2.4105e-01_r8,4.1263e-02_r8/)
      kbo(:, 3,42, 8) = (/ &
     &3.1590e-01_r8,4.4893e-01_r8,4.1987e-01_r8,3.2183e-01_r8,4.8631e-02_r8/)
      kbo(:, 4,42, 8) = (/ &
     &4.5063e-01_r8,5.9836e-01_r8,5.5343e-01_r8,4.2092e-01_r8,5.7226e-02_r8/)
      kbo(:, 5,42, 8) = (/ &
     &6.3264e-01_r8,7.8621e-01_r8,7.1837e-01_r8,5.4085e-01_r8,6.7074e-02_r8/)
      kbo(:, 1,43, 8) = (/ &
     &1.2471e-01_r8,2.0767e-01_r8,1.9765e-01_r8,1.5433e-01_r8,2.9617e-02_r8/)
      kbo(:, 2,43, 8) = (/ &
     &1.8736e-01_r8,2.9309e-01_r8,2.7736e-01_r8,2.1438e-01_r8,3.5333e-02_r8/)
      kbo(:, 3,43, 8) = (/ &
     &2.7561e-01_r8,4.0307e-01_r8,3.7854e-01_r8,2.9057e-01_r8,4.2142e-02_r8/)
      kbo(:, 4,43, 8) = (/ &
     &3.9834e-01_r8,5.4356e-01_r8,5.0521e-01_r8,3.8507e-01_r8,5.0246e-02_r8/)
      kbo(:, 5,43, 8) = (/ &
     &5.6689e-01_r8,7.2237e-01_r8,6.6289e-01_r8,5.0065e-01_r8,5.9725e-02_r8/)
      kbo(:, 1,44, 8) = (/ &
     &1.0535e-01_r8,1.8057e-01_r8,1.7198e-01_r8,1.3418e-01_r8,2.4874e-02_r8/)
      kbo(:, 2,44, 8) = (/ &
     &1.6101e-01_r8,2.5912e-01_r8,2.4579e-01_r8,1.8994e-01_r8,3.0018e-02_r8/)
      kbo(:, 3,44, 8) = (/ &
     &2.4038e-01_r8,3.6143e-01_r8,3.4064e-01_r8,2.6166e-01_r8,3.6275e-02_r8/)
      kbo(:, 4,44, 8) = (/ &
     &3.5302e-01_r8,4.9391e-01_r8,4.6079e-01_r8,3.5170e-01_r8,4.3858e-02_r8/)
      kbo(:, 5,44, 8) = (/ &
     &5.0915e-01_r8,6.6446e-01_r8,6.1193e-01_r8,4.6316e-01_r8,5.2911e-02_r8/)
      kbo(:, 1,45, 8) = (/ &
     &9.0316e-02_r8,1.5846e-01_r8,1.5081e-01_r8,1.1736e-01_r8,2.0815e-02_r8/)
      kbo(:, 2,45, 8) = (/ &
     &1.4022e-01_r8,2.3128e-01_r8,2.1952e-01_r8,1.6935e-01_r8,2.5419e-02_r8/)
      kbo(:, 3,45, 8) = (/ &
     &2.1290e-01_r8,3.2756e-01_r8,3.0923e-01_r8,2.3736e-01_r8,3.1129e-02_r8/)
      kbo(:, 4,45, 8) = (/ &
     &3.1767e-01_r8,4.5386e-01_r8,4.2443e-01_r8,3.2399e-01_r8,3.8187e-02_r8/)
      kbo(:, 5,45, 8) = (/ &
     &4.6514e-01_r8,6.1840e-01_r8,5.7081e-01_r8,4.3233e-01_r8,4.6782e-02_r8/)
      kbo(:, 1,46, 8) = (/ &
     &7.6970e-02_r8,1.3789e-01_r8,1.3114e-01_r8,1.0166e-01_r8,1.7264e-02_r8/)
      kbo(:, 2,46, 8) = (/ &
     &1.2176e-01_r8,2.0534e-01_r8,1.9482e-01_r8,1.4994e-01_r8,2.1346e-02_r8/)
      kbo(:, 3,46, 8) = (/ &
     &1.8790e-01_r8,2.9566e-01_r8,2.7941e-01_r8,2.1415e-01_r8,2.6490e-02_r8/)
      kbo(:, 4,46, 8) = (/ &
     &2.8511e-01_r8,4.1574e-01_r8,3.8936e-01_r8,2.9707e-01_r8,3.3007e-02_r8/)
      kbo(:, 5,46, 8) = (/ &
     &4.2418e-01_r8,5.7427e-01_r8,5.3095e-01_r8,4.0219e-01_r8,4.1080e-02_r8/)
      kbo(:, 1,47, 8) = (/ &
     &6.3210e-02_r8,1.1622e-01_r8,1.1043e-01_r8,8.5380e-02_r8,1.4119e-02_r8/)
      kbo(:, 2,47, 8) = (/ &
     &1.0215e-01_r8,1.7705e-01_r8,1.6808e-01_r8,1.2908e-01_r8,1.7662e-02_r8/)
      kbo(:, 3,47, 8) = (/ &
     &1.6053e-01_r8,2.5968e-01_r8,2.4579e-01_r8,1.8828e-01_r8,2.2222e-02_r8/)
      kbo(:, 4,47, 8) = (/ &
     &2.4774e-01_r8,3.7111e-01_r8,3.4851e-01_r8,2.6604e-01_r8,2.8126e-02_r8/)
      kbo(:, 5,47, 8) = (/ &
     &3.7525e-01_r8,5.2022e-01_r8,4.8241e-01_r8,3.6582e-01_r8,3.5589e-02_r8/)
      kbo(:, 1,48, 8) = (/ &
     &5.2856e-02_r8,9.8941e-02_r8,9.3700e-02_r8,7.2138e-02_r8,1.1481e-02_r8/)
      kbo(:, 2,48, 8) = (/ &
     &8.7380e-02_r8,1.5439e-01_r8,1.4631e-01_r8,1.1192e-01_r8,1.4532e-02_r8/)
      kbo(:, 3,48, 8) = (/ &
     &1.4008e-01_r8,2.3111e-01_r8,2.1862e-01_r8,1.6701e-01_r8,1.8538e-02_r8/)
      kbo(:, 4,48, 8) = (/ &
     &2.2000e-01_r8,3.3600e-01_r8,3.1573e-01_r8,2.4065e-01_r8,2.3829e-02_r8/)
      kbo(:, 5,48, 8) = (/ &
     &3.3939e-01_r8,4.7860e-01_r8,4.4403e-01_r8,3.3641e-01_r8,3.0679e-02_r8/)
      kbo(:, 1,49, 8) = (/ &
     &4.5594e-02_r8,8.5787e-02_r8,8.0733e-02_r8,6.1668e-02_r8,9.2832e-03_r8/)
      kbo(:, 2,49, 8) = (/ &
     &7.7236e-02_r8,1.3755e-01_r8,1.2964e-01_r8,9.8500e-02_r8,1.1885e-02_r8/)
      kbo(:, 3,49, 8) = (/ &
     &1.2646e-01_r8,2.1033e-01_r8,1.9831e-01_r8,1.5059e-01_r8,1.5367e-02_r8/)
      kbo(:, 4,49, 8) = (/ &
     &2.0223e-01_r8,3.1150e-01_r8,2.9194e-01_r8,2.2146e-01_r8,2.0076e-02_r8/)
      kbo(:, 5,49, 8) = (/ &
     &3.1773e-01_r8,4.5116e-01_r8,4.1757e-01_r8,3.1527e-01_r8,2.6302e-02_r8/)
      kbo(:, 1,50, 8) = (/ &
     &3.7552e-02_r8,7.1895e-02_r8,6.7424e-02_r8,5.1302e-02_r8,7.5009e-03_r8/)
      kbo(:, 2,50, 8) = (/ &
     &6.5207e-02_r8,1.1840e-01_r8,1.1139e-01_r8,8.4335e-02_r8,9.7205e-03_r8/)
      kbo(:, 3,50, 8) = (/ &
     &1.0908e-01_r8,1.8529e-01_r8,1.7464e-01_r8,1.3230e-01_r8,1.2741e-02_r8/)
      kbo(:, 4,50, 8) = (/ &
     &1.7795e-01_r8,2.7969e-01_r8,2.6224e-01_r8,1.9866e-01_r8,1.6912e-02_r8/)
      kbo(:, 5,50, 8) = (/ &
     &2.8480e-01_r8,4.1182e-01_r8,3.8156e-01_r8,2.8786e-01_r8,2.2557e-02_r8/)
      kbo(:, 1,51, 8) = (/ &
     &3.0119e-02_r8,5.9038e-02_r8,5.5227e-02_r8,4.1909e-02_r8,6.0436e-03_r8/)
      kbo(:, 2,51, 8) = (/ &
     &5.3723e-02_r8,1.0012e-01_r8,9.4083e-02_r8,7.1011e-02_r8,7.9244e-03_r8/)
      kbo(:, 3,51, 8) = (/ &
     &9.1816e-02_r8,1.6026e-01_r8,1.5113e-01_r8,1.1438e-01_r8,1.0530e-02_r8/)
      kbo(:, 4,51, 8) = (/ &
     &1.5289e-01_r8,2.4665e-01_r8,2.3169e-01_r8,1.7549e-01_r8,1.4198e-02_r8/)
      kbo(:, 5,51, 8) = (/ &
     &2.4923e-01_r8,3.6941e-01_r8,3.4309e-01_r8,2.5907e-01_r8,1.9285e-02_r8/)
      kbo(:, 1,52, 8) = (/ &
     &2.4575e-02_r8,4.8862e-02_r8,4.5516e-02_r8,3.4388e-02_r8,4.8448e-03_r8/)
      kbo(:, 2,52, 8) = (/ &
     &4.5073e-02_r8,8.5520e-02_r8,8.0105e-02_r8,6.0149e-02_r8,6.4237e-03_r8/)
      kbo(:, 3,52, 8) = (/ &
     &7.8951e-02_r8,1.4049e-01_r8,1.3220e-01_r8,9.9732e-02_r8,8.6480e-03_r8/)
      kbo(:, 4,52, 8) = (/ &
     &1.3416e-01_r8,2.2067e-01_r8,2.0720e-01_r8,1.5657e-01_r8,1.1852e-02_r8/)
      kbo(:, 5,52, 8) = (/ &
     &2.2319e-01_r8,3.3661e-01_r8,3.1253e-01_r8,2.3574e-01_r8,1.6412e-02_r8/)
      kbo(:, 1,53, 8) = (/ &
     &2.0612e-02_r8,4.1138e-02_r8,3.8068e-02_r8,2.8547e-02_r8,3.8662e-03_r8/)
      kbo(:, 2,53, 8) = (/ &
     &3.9008e-02_r8,7.4441e-02_r8,6.9299e-02_r8,5.1635e-02_r8,5.1786e-03_r8/)
      kbo(:, 3,53, 8) = (/ &
     &7.0078e-02_r8,1.2575e-01_r8,1.1775e-01_r8,8.8269e-02_r8,7.0623e-03_r8/)
      kbo(:, 4,53, 8) = (/ &
     &1.2164e-01_r8,2.0192e-01_r8,1.8894e-01_r8,1.4209e-01_r8,9.8285e-03_r8/)
      kbo(:, 5,53, 8) = (/ &
     &2.0657e-01_r8,3.1414e-01_r8,2.9077e-01_r8,2.1839e-01_r8,1.3889e-02_r8/)
      kbo(:, 1,54, 8) = (/ &
     &1.5065e-02_r8,3.1280e-02_r8,2.9021e-02_r8,2.1865e-02_r8,3.0881e-03_r8/)
      kbo(:, 2,54, 8) = (/ &
     &2.9415e-02_r8,5.8678e-02_r8,5.4740e-02_r8,4.0841e-02_r8,4.1803e-03_r8/)
      kbo(:, 3,54, 8) = (/ &
     &5.4186e-02_r8,1.0195e-01_r8,9.5873e-02_r8,7.1991e-02_r8,5.7700e-03_r8/)
      kbo(:, 4,54, 8) = (/ &
     &9.6215e-02_r8,1.6747e-01_r8,1.5763e-01_r8,1.1902e-01_r8,8.1641e-03_r8/)
      kbo(:, 5,54, 8) = (/ &
     &1.6671e-01_r8,2.6518e-01_r8,2.4733e-01_r8,1.8663e-01_r8,1.1760e-02_r8/)
      kbo(:, 1,55, 8) = (/ &
     &1.0025e-02_r8,2.2183e-02_r8,2.0776e-02_r8,1.5843e-02_r8,2.4606e-03_r8/)
      kbo(:, 2,55, 8) = (/ &
     &2.0216e-02_r8,4.3248e-02_r8,4.0605e-02_r8,3.0502e-02_r8,3.3650e-03_r8/)
      kbo(:, 3,55, 8) = (/ &
     &3.8225e-02_r8,7.7452e-02_r8,7.3454e-02_r8,5.5488e-02_r8,4.7010e-03_r8/)
      kbo(:, 4,55, 8) = (/ &
     &6.9405e-02_r8,1.3019e-01_r8,1.2386e-01_r8,9.4370e-02_r8,6.7604e-03_r8/)
      kbo(:, 5,55, 8) = (/ &
     &1.2275e-01_r8,2.0976e-01_r8,1.9836e-01_r8,1.5118e-01_r8,9.9237e-03_r8/)
      kbo(:, 1,56, 8) = (/ &
     &6.5953e-03_r8,1.5532e-02_r8,1.4697e-02_r8,1.1369e-02_r8,1.9523e-03_r8/)
      kbo(:, 2,56, 8) = (/ &
     &1.3758e-02_r8,3.1499e-02_r8,2.9770e-02_r8,2.2525e-02_r8,2.6931e-03_r8/)
      kbo(:, 3,56, 8) = (/ &
     &2.6733e-02_r8,5.8400e-02_r8,5.5794e-02_r8,4.2378e-02_r8,3.8077e-03_r8/)
      kbo(:, 4,56, 8) = (/ &
     &4.9676e-02_r8,1.0081e-01_r8,9.6783e-02_r8,7.4327e-02_r8,5.5587e-03_r8/)
      kbo(:, 5,56, 8) = (/ &
     &8.9711e-02_r8,1.6544e-01_r8,1.5844e-01_r8,1.2195e-01_r8,8.3185e-03_r8/)
      kbo(:, 1,57, 8) = (/ &
     &4.2820e-03_r8,1.0722e-02_r8,1.0258e-02_r8,8.0796e-03_r8,1.5428e-03_r8/)
      kbo(:, 2,57, 8) = (/ &
     &9.2544e-03_r8,2.2704e-02_r8,2.1598e-02_r8,1.6468e-02_r8,2.1441e-03_r8/)
      kbo(:, 3,57, 8) = (/ &
     &1.8521e-02_r8,4.3686e-02_r8,4.1983e-02_r8,3.2044e-02_r8,3.0664e-03_r8/)
      kbo(:, 4,57, 8) = (/ &
     &3.5250e-02_r8,7.7586e-02_r8,7.5143e-02_r8,5.8070e-02_r8,4.5371e-03_r8/)
      kbo(:, 5,57, 8) = (/ &
     &6.5084e-02_r8,1.3004e-01_r8,1.2594e-01_r8,9.7902e-02_r8,6.9329e-03_r8/)
      kbo(:, 1,58, 8) = (/ &
     &7.3360e-04_r8,2.4101e-03_r8,3.0107e-03_r8,3.3982e-03_r8,1.2193e-03_r8/)
      kbo(:, 2,58, 8) = (/ &
     &1.6434e-03_r8,5.3110e-03_r8,6.5569e-03_r8,7.0857e-03_r8,1.7049e-03_r8/)
      kbo(:, 3,58, 8) = (/ &
     &3.3887e-03_r8,1.0643e-02_r8,1.3244e-02_r8,1.4263e-02_r8,2.4670e-03_r8/)
      kbo(:, 4,58, 8) = (/ &
     &6.6116e-03_r8,1.9492e-02_r8,2.4519e-02_r8,2.6730e-02_r8,3.7032e-03_r8/)
      kbo(:, 5,58, 8) = (/ &
     &1.2475e-02_r8,3.3432e-02_r8,4.2135e-02_r8,4.6396e-02_r8,5.7742e-03_r8/)
      kbo(:, 1,59, 8) = (/ &
     &6.5322e-04_r8,2.3892e-03_r8,2.8729e-03_r8,2.9916e-03_r8,1.0154e-03_r8/)
      kbo(:, 2,59, 8) = (/ &
     &1.4925e-03_r8,5.3944e-03_r8,6.3528e-03_r8,6.2709e-03_r8,1.4376e-03_r8/)
      kbo(:, 3,59, 8) = (/ &
     &3.1352e-03_r8,1.1095e-02_r8,1.3136e-02_r8,1.2884e-02_r8,2.1132e-03_r8/)
      kbo(:, 4,59, 8) = (/ &
     &6.2265e-03_r8,2.0748e-02_r8,2.4885e-02_r8,2.4670e-02_r8,3.2435e-03_r8/)
      kbo(:, 5,59, 8) = (/ &
     &1.1971e-02_r8,3.6140e-02_r8,4.3523e-02_r8,4.3765e-02_r8,5.1685e-03_r8/)
      kbo(:, 1,13, 9) = (/ &
     &7.3666e+01_r8,5.5396e+01_r8,3.7129e+01_r8,1.8928e+01_r8,2.0240e+00_r8/)
      kbo(:, 2,13, 9) = (/ &
     &1.0840e+02_r8,8.1447e+01_r8,5.4490e+01_r8,2.7556e+01_r8,1.9929e+00_r8/)
      kbo(:, 3,13, 9) = (/ &
     &1.5167e+02_r8,1.1389e+02_r8,7.6113e+01_r8,3.8343e+01_r8,1.9601e+00_r8/)
      kbo(:, 4,13, 9) = (/ &
     &2.0374e+02_r8,1.5294e+02_r8,1.0214e+02_r8,5.1349e+01_r8,1.9301e+00_r8/)
      kbo(:, 5,13, 9) = (/ &
     &2.6449e+02_r8,1.9850e+02_r8,1.3251e+02_r8,6.6525e+01_r8,1.8945e+00_r8/)
      kbo(:, 1,14, 9) = (/ &
     &4.2021e+01_r8,3.1664e+01_r8,2.1327e+01_r8,1.1250e+01_r8,2.1001e+00_r8/)
      kbo(:, 2,14, 9) = (/ &
     &6.1662e+01_r8,4.6390e+01_r8,3.1123e+01_r8,1.5991e+01_r8,2.0721e+00_r8/)
      kbo(:, 3,14, 9) = (/ &
     &8.6125e+01_r8,6.4733e+01_r8,4.3345e+01_r8,2.2004e+01_r8,2.0419e+00_r8/)
      kbo(:, 4,14, 9) = (/ &
     &1.1550e+02_r8,8.6758e+01_r8,5.8024e+01_r8,2.9304e+01_r8,2.0094e+00_r8/)
      kbo(:, 5,14, 9) = (/ &
     &1.4971e+02_r8,1.1242e+02_r8,7.5125e+01_r8,3.7838e+01_r8,1.9780e+00_r8/)
      kbo(:, 1,15, 9) = (/ &
     &2.4325e+01_r8,1.8394e+01_r8,1.2572e+01_r8,7.1971e+00_r8,2.1558e+00_r8/)
      kbo(:, 2,15, 9) = (/ &
     &3.5582e+01_r8,2.6831e+01_r8,1.8117e+01_r8,9.7575e+00_r8,2.1305e+00_r8/)
      kbo(:, 3,15, 9) = (/ &
     &4.9567e+01_r8,3.7318e+01_r8,2.5078e+01_r8,1.3071e+01_r8,2.1029e+00_r8/)
      kbo(:, 4,15, 9) = (/ &
     &6.6327e+01_r8,4.9885e+01_r8,3.3445e+01_r8,1.7135e+01_r8,2.0733e+00_r8/)
      kbo(:, 5,15, 9) = (/ &
     &8.5909e+01_r8,6.4569e+01_r8,4.3231e+01_r8,2.1949e+01_r8,2.0415e+00_r8/)
      kbo(:, 1,16, 9) = (/ &
     &1.6702e+01_r8,1.2688e+01_r8,8.9156e+00_r8,5.6745e+00_r8,2.1884e+00_r8/)
      kbo(:, 2,16, 9) = (/ &
     &2.4341e+01_r8,1.8405e+01_r8,1.2602e+01_r8,7.2943e+00_r8,2.1658e+00_r8/)
      kbo(:, 3,16, 9) = (/ &
     &3.3812e+01_r8,2.5504e+01_r8,1.7253e+01_r8,9.4143e+00_r8,2.1418e+00_r8/)
      kbo(:, 4,16, 9) = (/ &
     &4.5185e+01_r8,3.4031e+01_r8,2.2894e+01_r8,1.2063e+01_r8,2.1149e+00_r8/)
      kbo(:, 5,16, 9) = (/ &
     &5.8502e+01_r8,4.4016e+01_r8,2.9536e+01_r8,1.5253e+01_r8,2.0863e+00_r8/)
      kbo(:, 1,17, 9) = (/ &
     &1.1824e+01_r8,9.0729e+00_r8,6.6968e+00_r8,4.8304e+00_r8,2.1968e+00_r8/)
      kbo(:, 2,17, 9) = (/ &
     &1.7172e+01_r8,1.3045e+01_r8,9.1828e+00_r8,5.8938e+00_r8,2.1784e+00_r8/)
      kbo(:, 3,17, 9) = (/ &
     &2.3815e+01_r8,1.8013e+01_r8,1.2370e+01_r8,7.2830e+00_r8,2.1580e+00_r8/)
      kbo(:, 4,17, 9) = (/ &
     &3.1829e+01_r8,2.4018e+01_r8,1.6287e+01_r8,9.0400e+00_r8,2.1352e+00_r8/)
      kbo(:, 5,17, 9) = (/ &
     &4.1298e+01_r8,3.1117e+01_r8,2.0970e+01_r8,1.1193e+01_r8,2.1100e+00_r8/)
      kbo(:, 1,18, 9) = (/ &
     &8.5582e+00_r8,6.6960e+00_r8,5.3232e+00_r8,4.2870e+00_r8,2.1819e+00_r8/)
      kbo(:, 2,18, 9) = (/ &
     &1.2402e+01_r8,9.5125e+00_r8,7.0290e+00_r8,5.0519e+00_r8,2.1680e+00_r8/)
      kbo(:, 3,18, 9) = (/ &
     &1.7200e+01_r8,1.3071e+01_r8,9.2389e+00_r8,6.0101e+00_r8,2.1517e+00_r8/)
      kbo(:, 4,18, 9) = (/ &
     &2.3032e+01_r8,1.7428e+01_r8,1.2014e+01_r8,7.2086e+00_r8,2.1334e+00_r8/)
      kbo(:, 5,18, 9) = (/ &
     &2.9959e+01_r8,2.2618e+01_r8,1.5385e+01_r8,8.6965e+00_r8,2.1122e+00_r8/)
      kbo(:, 1,19, 9) = (/ &
     &6.0876e+00_r8,4.9589e+00_r8,4.3617e+00_r8,3.8537e+00_r8,2.1426e+00_r8/)
      kbo(:, 2,19, 9) = (/ &
     &8.8178e+00_r8,6.9019e+00_r8,5.5120e+00_r8,4.4148e+00_r8,2.1341e+00_r8/)
      kbo(:, 3,19, 9) = (/ &
     &1.2247e+01_r8,9.4065e+00_r8,7.0194e+00_r8,5.0977e+00_r8,2.1226e+00_r8/)
      kbo(:, 4,19, 9) = (/ &
     &1.6435e+01_r8,1.2508e+01_r8,8.9285e+00_r8,5.9346e+00_r8,2.1084e+00_r8/)
      kbo(:, 5,19, 9) = (/ &
     &2.1395e+01_r8,1.6206e+01_r8,1.1260e+01_r8,6.9507e+00_r8,2.0906e+00_r8/)
      kbo(:, 1,20, 9) = (/ &
     &4.7338e+00_r8,4.0618e+00_r8,3.8673e+00_r8,3.5847e+00_r8,2.0812e+00_r8/)
      kbo(:, 2,20, 9) = (/ &
     &6.8571e+00_r8,5.5334e+00_r8,4.7582e+00_r8,4.0685e+00_r8,2.0765e+00_r8/)
      kbo(:, 3,20, 9) = (/ &
     &9.5336e+00_r8,7.4447e+00_r8,5.9012e+00_r8,4.6250e+00_r8,2.0694e+00_r8/)
      kbo(:, 4,20, 9) = (/ &
     &1.2791e+01_r8,9.8219e+00_r8,7.3358e+00_r8,5.2854e+00_r8,2.0598e+00_r8/)
      kbo(:, 5,20, 9) = (/ &
     &1.6650e+01_r8,1.2677e+01_r8,9.0899e+00_r8,6.0678e+00_r8,2.0475e+00_r8/)
      kbo(:, 1,21, 9) = (/ &
     &3.8172e+00_r8,3.4906e+00_r8,3.5314e+00_r8,3.3393e+00_r8,1.9987e+00_r8/)
      kbo(:, 2,21, 9) = (/ &
     &5.5293e+00_r8,4.6505e+00_r8,4.2636e+00_r8,3.7764e+00_r8,1.9988e+00_r8/)
      kbo(:, 3,21, 9) = (/ &
     &7.6789e+00_r8,6.1523e+00_r8,5.1831e+00_r8,4.2770e+00_r8,1.9964e+00_r8/)
      kbo(:, 4,21, 9) = (/ &
     &1.0301e+01_r8,8.0282e+00_r8,6.3179e+00_r8,4.8454e+00_r8,1.9916e+00_r8/)
      kbo(:, 5,21, 9) = (/ &
     &1.3413e+01_r8,1.0296e+01_r8,7.6922e+00_r8,5.4909e+00_r8,1.9849e+00_r8/)
      kbo(:, 1,22, 9) = (/ &
     &3.2538e+00_r8,3.1636e+00_r8,3.3083e+00_r8,3.1336e+00_r8,1.8994e+00_r8/)
      kbo(:, 2,22, 9) = (/ &
     &4.6904e+00_r8,4.1275e+00_r8,3.9601e+00_r8,3.5392e+00_r8,1.9038e+00_r8/)
      kbo(:, 3,22, 9) = (/ &
     &6.4936e+00_r8,5.3647e+00_r8,4.7415e+00_r8,4.0033e+00_r8,1.9062e+00_r8/)
      kbo(:, 4,22, 9) = (/ &
     &8.6858e+00_r8,6.9049e+00_r8,5.6919e+00_r8,4.5273e+00_r8,1.9068e+00_r8/)
      kbo(:, 5,22, 9) = (/ &
     &1.1287e+01_r8,8.7705e+00_r8,6.8305e+00_r8,5.1089e+00_r8,1.9070e+00_r8/)
      kbo(:, 1,23, 9) = (/ &
     &2.7990e+00_r8,2.9004e+00_r8,3.0888e+00_r8,2.9221e+00_r8,1.7866e+00_r8/)
      kbo(:, 2,23, 9) = (/ &
     &4.0164e+00_r8,3.7193e+00_r8,3.6884e+00_r8,3.3009e+00_r8,1.7963e+00_r8/)
      kbo(:, 3,23, 9) = (/ &
     &5.5385e+00_r8,4.7530e+00_r8,4.3835e+00_r8,3.7336e+00_r8,1.8046e+00_r8/)
      kbo(:, 4,23, 9) = (/ &
     &7.3874e+00_r8,6.0323e+00_r8,5.1957e+00_r8,4.2187e+00_r8,1.8111e+00_r8/)
      kbo(:, 5,23, 9) = (/ &
     &9.5697e+00_r8,7.5707e+00_r8,6.1486e+00_r8,4.7536e+00_r8,1.8191e+00_r8/)
      kbo(:, 1,24, 9) = (/ &
     &2.4093e+00_r8,2.6666e+00_r8,2.8613e+00_r8,2.7031e+00_r8,1.6662e+00_r8/)
      kbo(:, 2,24, 9) = (/ &
     &3.4388e+00_r8,3.3672e+00_r8,3.4097e+00_r8,3.0567e+00_r8,1.6812e+00_r8/)
      kbo(:, 3,24, 9) = (/ &
     &4.7196e+00_r8,4.2384e+00_r8,4.0418e+00_r8,3.4577e+00_r8,1.6956e+00_r8/)
      kbo(:, 4,24, 9) = (/ &
     &6.2610e+00_r8,5.2923e+00_r8,4.7542e+00_r8,3.9053e+00_r8,1.7103e+00_r8/)
      kbo(:, 5,24, 9) = (/ &
     &8.0725e+00_r8,6.5459e+00_r8,5.5528e+00_r8,4.3943e+00_r8,1.7280e+00_r8/)
      kbo(:, 1,25, 9) = (/ &
     &2.1093e+00_r8,2.4777e+00_r8,2.6576e+00_r8,2.5025e+00_r8,1.5428e+00_r8/)
      kbo(:, 2,25, 9) = (/ &
     &2.9902e+00_r8,3.0964e+00_r8,3.1653e+00_r8,2.8347e+00_r8,1.5643e+00_r8/)
      kbo(:, 3,25, 9) = (/ &
     &4.0768e+00_r8,3.8394e+00_r8,3.7463e+00_r8,3.2106e+00_r8,1.5865e+00_r8/)
      kbo(:, 4,25, 9) = (/ &
     &5.3785e+00_r8,4.7237e+00_r8,4.3881e+00_r8,3.6281e+00_r8,1.6115e+00_r8/)
      kbo(:, 5,25, 9) = (/ &
     &6.9128e+00_r8,5.7727e+00_r8,5.0863e+00_r8,4.0788e+00_r8,1.6376e+00_r8/)
      kbo(:, 1,26, 9) = (/ &
     &1.8856e+00_r8,2.3262e+00_r8,2.4875e+00_r8,2.3287e+00_r8,1.4224e+00_r8/)
      kbo(:, 2,26, 9) = (/ &
     &2.6493e+00_r8,2.8890e+00_r8,2.9641e+00_r8,2.6458e+00_r8,1.4515e+00_r8/)
      kbo(:, 3,26, 9) = (/ &
     &3.5871e+00_r8,3.5368e+00_r8,3.5013e+00_r8,3.0021e+00_r8,1.4824e+00_r8/)
      kbo(:, 4,26, 9) = (/ &
     &4.7140e+00_r8,4.3024e+00_r8,4.0862e+00_r8,3.3950e+00_r8,1.5166e+00_r8/)
      kbo(:, 5,26, 9) = (/ &
     &6.0446e+00_r8,5.2045e+00_r8,4.7238e+00_r8,3.8145e+00_r8,1.5518e+00_r8/)
      kbo(:, 1,27, 9) = (/ &
     &1.7455e+00_r8,2.2279e+00_r8,2.3691e+00_r8,2.1938e+00_r8,1.3093e+00_r8/)
      kbo(:, 2,27, 9) = (/ &
     &2.4331e+00_r8,2.7544e+00_r8,2.8270e+00_r8,2.5043e+00_r8,1.3459e+00_r8/)
      kbo(:, 3,27, 9) = (/ &
     &3.2766e+00_r8,3.3516e+00_r8,3.3333e+00_r8,2.8520e+00_r8,1.3862e+00_r8/)
      kbo(:, 4,27, 9) = (/ &
     &4.2923e+00_r8,4.0432e+00_r8,3.8852e+00_r8,3.2303e+00_r8,1.4289e+00_r8/)
      kbo(:, 5,27, 9) = (/ &
     &5.4942e+00_r8,4.8565e+00_r8,4.4878e+00_r8,3.6320e+00_r8,1.4726e+00_r8/)
      kbo(:, 1,28, 9) = (/ &
     &1.6557e+00_r8,2.1623e+00_r8,2.2857e+00_r8,2.0892e+00_r8,1.2058e+00_r8/)
      kbo(:, 2,28, 9) = (/ &
     &2.2924e+00_r8,2.6651e+00_r8,2.7290e+00_r8,2.3996e+00_r8,1.2506e+00_r8/)
      kbo(:, 3,28, 9) = (/ &
     &3.0749e+00_r8,3.2332e+00_r8,3.2167e+00_r8,2.7436e+00_r8,1.2996e+00_r8/)
      kbo(:, 4,28, 9) = (/ &
     &4.0186e+00_r8,3.8816e+00_r8,3.7505e+00_r8,3.1131e+00_r8,1.3503e+00_r8/)
      kbo(:, 5,28, 9) = (/ &
     &5.1433e+00_r8,4.6442e+00_r8,4.3346e+00_r8,3.5087e+00_r8,1.4023e+00_r8/)
      kbo(:, 1,29, 9) = (/ &
     &1.6682e+00_r8,2.1786e+00_r8,2.2786e+00_r8,2.0447e+00_r8,1.1144e+00_r8/)
      kbo(:, 2,29, 9) = (/ &
     &2.2981e+00_r8,2.6823e+00_r8,2.7239e+00_r8,2.3673e+00_r8,1.1675e+00_r8/)
      kbo(:, 3,29, 9) = (/ &
     &3.0738e+00_r8,3.2536e+00_r8,3.2170e+00_r8,2.7185e+00_r8,1.2244e+00_r8/)
      kbo(:, 4,29, 9) = (/ &
     &4.0119e+00_r8,3.9041e+00_r8,3.7595e+00_r8,3.0962e+00_r8,1.2824e+00_r8/)
      kbo(:, 5,29, 9) = (/ &
     &5.1340e+00_r8,4.6678e+00_r8,4.3550e+00_r8,3.5038e+00_r8,1.3425e+00_r8/)
      kbo(:, 1,30, 9) = (/ &
     &1.7221e+00_r8,2.2297e+00_r8,2.3038e+00_r8,2.0342e+00_r8,1.0364e+00_r8/)
      kbo(:, 2,30, 9) = (/ &
     &2.3632e+00_r8,2.7462e+00_r8,2.7611e+00_r8,2.3703e+00_r8,1.0967e+00_r8/)
      kbo(:, 3,30, 9) = (/ &
     &3.1545e+00_r8,3.3332e+00_r8,3.2697e+00_r8,2.7338e+00_r8,1.1597e+00_r8/)
      kbo(:, 4,30, 9) = (/ &
     &4.1176e+00_r8,4.0031e+00_r8,3.8327e+00_r8,3.1282e+00_r8,1.2250e+00_r8/)
      kbo(:, 5,30, 9) = (/ &
     &5.2710e+00_r8,4.7910e+00_r8,4.4538e+00_r8,3.5548e+00_r8,1.2942e+00_r8/)
      kbo(:, 1,31, 9) = (/ &
     &1.8733e+00_r8,2.3643e+00_r8,2.4037e+00_r8,2.0831e+00_r8,9.7071e-01_r8/)
      kbo(:, 2,31, 9) = (/ &
     &2.5621e+00_r8,2.9163e+00_r8,2.8917e+00_r8,2.4413e+00_r8,1.0371e+00_r8/)
      kbo(:, 3,31, 9) = (/ &
     &3.4185e+00_r8,3.5458e+00_r8,3.4392e+00_r8,2.8321e+00_r8,1.1068e+00_r8/)
      kbo(:, 4,31, 9) = (/ &
     &4.4630e+00_r8,4.2725e+00_r8,4.0472e+00_r8,3.2583e+00_r8,1.1813e+00_r8/)
      kbo(:, 5,31, 9) = (/ &
     &5.7201e+00_r8,5.1339e+00_r8,4.7206e+00_r8,3.7217e+00_r8,1.2572e+00_r8/)
      kbo(:, 1,32, 9) = (/ &
     &2.0653e+00_r8,2.5337e+00_r8,2.5386e+00_r8,2.1600e+00_r8,9.1680e-01_r8/)
      kbo(:, 2,32, 9) = (/ &
     &2.8216e+00_r8,3.1306e+00_r8,3.0669e+00_r8,2.5463e+00_r8,9.8936e-01_r8/)
      kbo(:, 3,32, 9) = (/ &
     &3.7648e+00_r8,3.8151e+00_r8,3.6619e+00_r8,2.9702e+00_r8,1.0685e+00_r8/)
      kbo(:, 4,32, 9) = (/ &
     &4.9201e+00_r8,4.6180e+00_r8,4.3259e+00_r8,3.4358e+00_r8,1.1502e+00_r8/)
      kbo(:, 5,32, 9) = (/ &
     &6.3088e+00_r8,5.5739e+00_r8,5.0619e+00_r8,3.9444e+00_r8,1.2333e+00_r8/)
      kbo(:, 1,33, 9) = (/ &
     &2.3272e+00_r8,2.7583e+00_r8,2.7254e+00_r8,2.2760e+00_r8,8.7514e-01_r8/)
      kbo(:, 2,33, 9) = (/ &
     &3.1779e+00_r8,3.4161e+00_r8,3.3066e+00_r8,2.6982e+00_r8,9.5639e-01_r8/)
      kbo(:, 3,33, 9) = (/ &
     &4.2411e+00_r8,4.1786e+00_r8,3.9626e+00_r8,3.1651e+00_r8,1.0431e+00_r8/)
      kbo(:, 4,33, 9) = (/ &
     &5.5462e+00_r8,5.0836e+00_r8,4.6978e+00_r8,3.6805e+00_r8,1.1309e+00_r8/)
      kbo(:, 5,33, 9) = (/ &
     &7.1174e+00_r8,6.1675e+00_r8,5.5124e+00_r8,4.2455e+00_r8,1.2216e+00_r8/)
      kbo(:, 1,34, 9) = (/ &
     &2.5377e+00_r8,2.9389e+00_r8,2.8782e+00_r8,2.3730e+00_r8,8.4364e-01_r8/)
      kbo(:, 2,34, 9) = (/ &
     &3.4681e+00_r8,3.6495e+00_r8,3.5041e+00_r8,2.8278e+00_r8,9.3211e-01_r8/)
      kbo(:, 3,34, 9) = (/ &
     &4.6355e+00_r8,4.4791e+00_r8,4.2141e+00_r8,3.3332e+00_r8,1.0240e+00_r8/)
      kbo(:, 4,34, 9) = (/ &
     &6.0678e+00_r8,5.4727e+00_r8,5.0128e+00_r8,3.8930e+00_r8,1.1193e+00_r8/)
      kbo(:, 5,34, 9) = (/ &
     &7.8056e+00_r8,6.6744e+00_r8,5.8925e+00_r8,4.5074e+00_r8,1.2154e+00_r8/)
      kbo(:, 1,35, 9) = (/ &
     &2.6973e+00_r8,3.0775e+00_r8,2.9953e+00_r8,2.4483e+00_r8,8.1381e-01_r8/)
      kbo(:, 2,35, 9) = (/ &
     &3.6991e+00_r8,3.8360e+00_r8,3.6636e+00_r8,2.9345e+00_r8,9.0760e-01_r8/)
      kbo(:, 3,35, 9) = (/ &
     &4.9601e+00_r8,4.7300e+00_r8,4.4278e+00_r8,3.4777e+00_r8,1.0051e+00_r8/)
      kbo(:, 4,35, 9) = (/ &
     &6.5186e+00_r8,5.8127e+00_r8,5.2832e+00_r8,4.0814e+00_r8,1.1048e+00_r8/)
      kbo(:, 5,35, 9) = (/ &
     &8.4126e+00_r8,7.1259e+00_r8,6.2273e+00_r8,4.7423e+00_r8,1.2066e+00_r8/)
      kbo(:, 1,36, 9) = (/ &
     &2.7598e+00_r8,3.1389e+00_r8,3.0464e+00_r8,2.4794e+00_r8,7.8185e-01_r8/)
      kbo(:, 2,36, 9) = (/ &
     &3.8096e+00_r8,3.9341e+00_r8,3.7503e+00_r8,2.9909e+00_r8,8.7896e-01_r8/)
      kbo(:, 3,36, 9) = (/ &
     &5.1379e+00_r8,4.8766e+00_r8,4.5549e+00_r8,3.5652e+00_r8,9.8107e-01_r8/)
      kbo(:, 4,36, 9) = (/ &
     &6.7937e+00_r8,6.0302e+00_r8,5.4578e+00_r8,4.2069e+00_r8,1.0852e+00_r8/)
      kbo(:, 5,36, 9) = (/ &
     &8.8141e+00_r8,7.4326e+00_r8,6.4589e+00_r8,4.9083e+00_r8,1.1912e+00_r8/)
      kbo(:, 1,37, 9) = (/ &
     &2.6230e+00_r8,3.0408e+00_r8,2.9596e+00_r8,2.4124e+00_r8,7.3962e-01_r8/)
      kbo(:, 2,37, 9) = (/ &
     &3.6580e+00_r8,3.8393e+00_r8,3.6702e+00_r8,2.9331e+00_r8,8.3992e-01_r8/)
      kbo(:, 3,37, 9) = (/ &
     &4.9824e+00_r8,4.7866e+00_r8,4.4878e+00_r8,3.5210e+00_r8,9.4491e-01_r8/)
      kbo(:, 4,37, 9) = (/ &
     &6.6454e+00_r8,5.9484e+00_r8,5.4110e+00_r8,4.1812e+00_r8,1.0538e+00_r8/)
      kbo(:, 5,37, 9) = (/ &
     &8.6934e+00_r8,7.3704e+00_r8,6.4379e+00_r8,4.9067e+00_r8,1.1625e+00_r8/)
      kbo(:, 1,38, 9) = (/ &
     &2.5251e+00_r8,2.9721e+00_r8,2.8975e+00_r8,2.3630e+00_r8,7.0093e-01_r8/)
      kbo(:, 2,38, 9) = (/ &
     &3.5600e+00_r8,3.7826e+00_r8,3.6219e+00_r8,2.8967e+00_r8,8.0383e-01_r8/)
      kbo(:, 3,38, 9) = (/ &
     &4.9004e+00_r8,4.7489e+00_r8,4.4611e+00_r8,3.5032e+00_r8,9.1176e-01_r8/)
      kbo(:, 4,38, 9) = (/ &
     &6.5939e+00_r8,5.9343e+00_r8,5.4149e+00_r8,4.1893e+00_r8,1.0245e+00_r8/)
      kbo(:, 5,38, 9) = (/ &
     &8.7067e+00_r8,7.4030e+00_r8,6.4798e+00_r8,4.9449e+00_r8,1.1358e+00_r8/)
      kbo(:, 1,39, 9) = (/ &
     &2.4904e+00_r8,2.9537e+00_r8,2.8793e+00_r8,2.3443e+00_r8,6.6673e-01_r8/)
      kbo(:, 2,39, 9) = (/ &
     &3.5509e+00_r8,3.7917e+00_r8,3.6298e+00_r8,2.8981e+00_r8,7.7181e-01_r8/)
      kbo(:, 3,39, 9) = (/ &
     &4.9392e+00_r8,4.7973e+00_r8,4.5055e+00_r8,3.5337e+00_r8,8.8209e-01_r8/)
      kbo(:, 4,39, 9) = (/ &
     &6.7119e+00_r8,6.0406e+00_r8,5.5079e+00_r8,4.2551e+00_r8,9.9828e-01_r8/)
      kbo(:, 5,39, 9) = (/ &
     &8.9447e+00_r8,7.5957e+00_r8,6.6321e+00_r8,5.0544e+00_r8,1.1121e+00_r8/)
      kbo(:, 1,40, 9) = (/ &
     &2.2209e+00_r8,2.7364e+00_r8,2.6885e+00_r8,2.2038e+00_r8,6.2428e-01_r8/)
      kbo(:, 2,40, 9) = (/ &
     &3.2135e+00_r8,3.5469e+00_r8,3.4206e+00_r8,2.7501e+00_r8,7.3025e-01_r8/)
      kbo(:, 3,40, 9) = (/ &
     &4.5302e+00_r8,4.5210e+00_r8,4.2832e+00_r8,3.3810e+00_r8,8.4222e-01_r8/)
      kbo(:, 4,40, 9) = (/ &
     &6.2335e+00_r8,5.7214e+00_r8,5.2769e+00_r8,4.1014e+00_r8,9.6000e-01_r8/)
      kbo(:, 5,40, 9) = (/ &
     &8.4037e+00_r8,7.2349e+00_r8,6.3985e+00_r8,4.9070e+00_r8,1.0766e+00_r8/)
      kbo(:, 1,41, 9) = (/ &
     &1.9647e+00_r8,2.5201e+00_r8,2.4974e+00_r8,2.0614e+00_r8,5.8325e-01_r8/)
      kbo(:, 2,41, 9) = (/ &
     &2.8852e+00_r8,3.2999e+00_r8,3.2081e+00_r8,2.5978e+00_r8,6.8959e-01_r8/)
      kbo(:, 3,41, 9) = (/ &
     &4.1243e+00_r8,4.2421e+00_r8,4.0540e+00_r8,3.2221e+00_r8,8.0263e-01_r8/)
      kbo(:, 4,41, 9) = (/ &
     &5.7517e+00_r8,5.3978e+00_r8,5.0364e+00_r8,3.9392e+00_r8,9.2181e-01_r8/)
      kbo(:, 5,41, 9) = (/ &
     &7.8523e+00_r8,6.8657e+00_r8,6.1521e+00_r8,4.7480e+00_r8,1.0405e+00_r8/)
      kbo(:, 1,42, 9) = (/ &
     &1.7512e+00_r8,2.3349e+00_r8,2.3318e+00_r8,1.9366e+00_r8,5.4463e-01_r8/)
      kbo(:, 2,42, 9) = (/ &
     &2.6144e+00_r8,3.0905e+00_r8,3.0258e+00_r8,2.4663e+00_r8,6.5106e-01_r8/)
      kbo(:, 3,42, 9) = (/ &
     &3.7920e+00_r8,4.0117e+00_r8,3.8605e+00_r8,3.0859e+00_r8,7.6489e-01_r8/)
      kbo(:, 4,42, 9) = (/ &
     &5.3603e+00_r8,5.1368e+00_r8,4.8392e+00_r8,3.8039e+00_r8,8.8471e-01_r8/)
      kbo(:, 5,42, 9) = (/ &
     &7.4143e+00_r8,6.5758e+00_r8,5.9582e+00_r8,4.6208e+00_r8,1.0054e+00_r8/)
      kbo(:, 1,43, 9) = (/ &
     &1.5310e+00_r8,2.1360e+00_r8,2.1508e+00_r8,1.7978e+00_r8,5.0265e-01_r8/)
      kbo(:, 2,43, 9) = (/ &
     &2.3335e+00_r8,2.8636e+00_r8,2.8240e+00_r8,2.3172e+00_r8,6.0791e-01_r8/)
      kbo(:, 3,43, 9) = (/ &
     &3.4398e+00_r8,3.7600e+00_r8,3.6428e+00_r8,2.9301e+00_r8,7.2170e-01_r8/)
      kbo(:, 4,43, 9) = (/ &
     &4.9392e+00_r8,4.8535e+00_r8,4.6142e+00_r8,3.6458e+00_r8,8.4218e-01_r8/)
      kbo(:, 5,43, 9) = (/ &
     &6.9338e+00_r8,6.2557e+00_r8,5.7358e+00_r8,4.4687e+00_r8,9.6366e-01_r8/)
      kbo(:, 1,44, 9) = (/ &
     &1.3351e+00_r8,1.9503e+00_r8,1.9789e+00_r8,1.6632e+00_r8,4.6023e-01_r8/)
      kbo(:, 2,44, 9) = (/ &
     &2.0772e+00_r8,2.6507e+00_r8,2.6321e+00_r8,2.1724e+00_r8,5.6381e-01_r8/)
      kbo(:, 3,44, 9) = (/ &
     &3.1248e+00_r8,3.5269e+00_r8,3.4366e+00_r8,2.7797e+00_r8,6.7693e-01_r8/)
      kbo(:, 4,44, 9) = (/ &
     &4.5611e+00_r8,4.5989e+00_r8,4.4033e+00_r8,3.4949e+00_r8,7.9737e-01_r8/)
      kbo(:, 5,44, 9) = (/ &
     &6.5042e+00_r8,5.9719e+00_r8,5.5317e+00_r8,4.3254e+00_r8,9.1937e-01_r8/)
      kbo(:, 1,45, 9) = (/ &
     &1.1794e+00_r8,1.7969e+00_r8,1.8343e+00_r8,1.5476e+00_r8,4.2007e-01_r8/)
      kbo(:, 2,45, 9) = (/ &
     &1.8762e+00_r8,2.4795e+00_r8,2.4742e+00_r8,2.0501e+00_r8,5.2163e-01_r8/)
      kbo(:, 3,45, 9) = (/ &
     &2.8809e+00_r8,3.3442e+00_r8,3.2721e+00_r8,2.6566e+00_r8,6.3409e-01_r8/)
      kbo(:, 4,45, 9) = (/ &
     &4.2825e+00_r8,4.4131e+00_r8,4.2443e+00_r8,3.3788e+00_r8,7.5354e-01_r8/)
      kbo(:, 5,45, 9) = (/ &
     &6.2077e+00_r8,5.7830e+00_r8,5.3934e+00_r8,4.2249e+00_r8,8.7651e-01_r8/)
      kbo(:, 1,46, 9) = (/ &
     &1.0327e+00_r8,1.6453e+00_r8,1.6900e+00_r8,1.4307e+00_r8,3.8001e-01_r8/)
      kbo(:, 2,46, 9) = (/ &
     &1.6840e+00_r8,2.3071e+00_r8,2.3154e+00_r8,1.9251e+00_r8,4.7892e-01_r8/)
      kbo(:, 3,46, 9) = (/ &
     &2.6449e+00_r8,3.1623e+00_r8,3.1054e+00_r8,2.5294e+00_r8,5.8968e-01_r8/)
      kbo(:, 4,46, 9) = (/ &
     &4.0149e+00_r8,4.2299e+00_r8,4.0828e+00_r8,3.2577e+00_r8,7.0805e-01_r8/)
      kbo(:, 5,46, 9) = (/ &
     &5.9211e+00_r8,5.5984e+00_r8,5.2528e+00_r8,4.1223e+00_r8,8.3110e-01_r8/)
      kbo(:, 1,47, 9) = (/ &
     &8.6791e-01_r8,1.4650e+00_r8,1.5175e+00_r8,1.2909e+00_r8,3.3829e-01_r8/)
      kbo(:, 2,47, 9) = (/ &
     &1.4548e+00_r8,2.0919e+00_r8,2.1155e+00_r8,1.7684e+00_r8,4.3374e-01_r8/)
      kbo(:, 3,47, 9) = (/ &
     &2.3437e+00_r8,2.9171e+00_r8,2.8820e+00_r8,2.3592e+00_r8,5.4146e-01_r8/)
      kbo(:, 4,47, 9) = (/ &
     &3.6410e+00_r8,3.9658e+00_r8,3.8455e+00_r8,3.0807e+00_r8,6.5808e-01_r8/)
      kbo(:, 5,47, 9) = (/ &
     &5.4757e+00_r8,5.2982e+00_r8,5.0168e+00_r8,3.9488e+00_r8,7.8042e-01_r8/)
      kbo(:, 1,48, 9) = (/ &
     &7.4197e-01_r8,1.3175e+00_r8,1.3727e+00_r8,1.1710e+00_r8,2.9912e-01_r8/)
      kbo(:, 2,48, 9) = (/ &
     &1.2795e+00_r8,1.9175e+00_r8,1.9504e+00_r8,1.6359e+00_r8,3.9088e-01_r8/)
      kbo(:, 3,48, 9) = (/ &
     &2.1163e+00_r8,2.7243e+00_r8,2.7026e+00_r8,2.2191e+00_r8,4.9535e-01_r8/)
      kbo(:, 4,48, 9) = (/ &
     &3.3685e+00_r8,3.7692e+00_r8,3.6648e+00_r8,2.9415e+00_r8,6.0991e-01_r8/)
      kbo(:, 5,48, 9) = (/ &
     &5.1784e+00_r8,5.1043e+00_r8,4.8553e+00_r8,3.8227e+00_r8,7.3131e-01_r8/)
      kbo(:, 1,49, 9) = (/ &
     &6.5229e-01_r8,1.2051e+00_r8,1.2591e+00_r8,1.0738e+00_r8,2.6269e-01_r8/)
      kbo(:, 2,49, 9) = (/ &
     &1.1591e+00_r8,1.7908e+00_r8,1.8269e+00_r8,1.5329e+00_r8,3.5032e-01_r8/)
      kbo(:, 3,49, 9) = (/ &
     &1.9719e+00_r8,2.5959e+00_r8,2.5784e+00_r8,2.1177e+00_r8,4.5127e-01_r8/)
      kbo(:, 4,49, 9) = (/ &
     &3.2176e+00_r8,3.6617e+00_r8,3.5592e+00_r8,2.8538e+00_r8,5.6309e-01_r8/)
      kbo(:, 5,49, 9) = (/ &
     &5.0660e+00_r8,5.0444e+00_r8,4.7964e+00_r8,3.7669e+00_r8,6.8298e-01_r8/)
      kbo(:, 1,50, 9) = (/ &
     &5.4718e-01_r8,1.0700e+00_r8,1.1242e+00_r8,9.6269e-01_r8,2.3041e-01_r8/)
      kbo(:, 2,50, 9) = (/ &
     &1.0029e+00_r8,1.6230e+00_r8,1.6660e+00_r8,1.4048e+00_r8,3.1350e-01_r8/)
      kbo(:, 3,50, 9) = (/ &
     &1.7557e+00_r8,2.3977e+00_r8,2.3952e+00_r8,1.9754e+00_r8,4.1052e-01_r8/)
      kbo(:, 4,50, 9) = (/ &
     &2.9398e+00_r8,3.4467e+00_r8,3.3608e+00_r8,2.7053e+00_r8,5.1916e-01_r8/)
      kbo(:, 5,50, 9) = (/ &
     &4.7374e+00_r8,4.8217e+00_r8,4.6033e+00_r8,3.6228e+00_r8,6.3755e-01_r8/)
      kbo(:, 1,51, 9) = (/ &
     &4.4659e-01_r8,9.3305e-01_r8,9.8713e-01_r8,8.5042e-01_r8,2.0131e-01_r8/)
      kbo(:, 2,51, 9) = (/ &
     &8.4503e-01_r8,1.4458e+00_r8,1.4962e+00_r8,1.2698e+00_r8,2.7950e-01_r8/)
      kbo(:, 3,51, 9) = (/ &
     &1.5227e+00_r8,2.1776e+00_r8,2.1908e+00_r8,1.8185e+00_r8,3.7211e-01_r8/)
      kbo(:, 4,51, 9) = (/ &
     &2.6197e+00_r8,3.1878e+00_r8,3.1271e+00_r8,2.5305e+00_r8,4.7775e-01_r8/)
      kbo(:, 5,51, 9) = (/ &
     &4.3246e+00_r8,4.5333e+00_r8,4.3504e+00_r8,3.4392e+00_r8,5.9331e-01_r8/)
      kbo(:, 1,52, 9) = (/ &
     &3.7000e-01_r8,8.2088e-01_r8,8.7232e-01_r8,7.5398e-01_r8,1.7473e-01_r8/)
      kbo(:, 2,52, 9) = (/ &
     &7.2411e-01_r8,1.3013e+00_r8,1.3548e+00_r8,1.1545e+00_r8,2.4775e-01_r8/)
      kbo(:, 3,52, 9) = (/ &
     &1.3455e+00_r8,2.0001e+00_r8,2.0236e+00_r8,1.6871e+00_r8,3.3555e-01_r8/)
      kbo(:, 4,52, 9) = (/ &
     &2.3815e+00_r8,2.9886e+00_r8,2.9408e+00_r8,2.3888e+00_r8,4.3798e-01_r8/)
      kbo(:, 5,52, 9) = (/ &
     &4.0315e+00_r8,4.3264e+00_r8,4.1654e+00_r8,3.2990e+00_r8,5.5079e-01_r8/)
      kbo(:, 1,53, 9) = (/ &
     &3.1522e-01_r8,7.3236e-01_r8,7.7935e-01_r8,6.7369e-01_r8,1.5034e-01_r8/)
      kbo(:, 2,53, 9) = (/ &
     &6.3787e-01_r8,1.1908e+00_r8,1.2433e+00_r8,1.0610e+00_r8,2.1835e-01_r8/)
      kbo(:, 3,53, 9) = (/ &
     &1.2250e+00_r8,1.8717e+00_r8,1.8985e+00_r8,1.5852e+00_r8,3.0124e-01_r8/)
      kbo(:, 4,53, 9) = (/ &
     &2.2328e+00_r8,2.8593e+00_r8,2.8149e+00_r8,2.2876e+00_r8,3.9993e-01_r8/)
      kbo(:, 5,53, 9) = (/ &
     &3.8806e+00_r8,4.2255e+00_r8,4.0654e+00_r8,3.2164e+00_r8,5.0965e-01_r8/)
      kbo(:, 1,54, 9) = (/ &
     &2.3422e-01_r8,6.0076e-01_r8,6.4671e-01_r8,5.6503e-01_r8,1.2928e-01_r8/)
      kbo(:, 2,54, 9) = (/ &
     &4.9005e-01_r8,1.0010e+00_r8,1.0587e+00_r8,9.1460e-01_r8,1.9217e-01_r8/)
      kbo(:, 3,54, 9) = (/ &
     &9.7166e-01_r8,1.6014e+00_r8,1.6473e+00_r8,1.3943e+00_r8,2.7068e-01_r8/)
      kbo(:, 4,54, 9) = (/ &
     &1.8237e+00_r8,2.4909e+00_r8,2.4828e+00_r8,2.0443e+00_r8,3.6438e-01_r8/)
      kbo(:, 5,54, 9) = (/ &
     &3.2575e+00_r8,3.7456e+00_r8,3.6419e+00_r8,2.9148e+00_r8,4.7112e-01_r8/)
      kbo(:, 1,55, 9) = (/ &
     &1.5838e-01_r8,4.6639e-01_r8,5.1049e-01_r8,4.5411e-01_r8,1.1083e-01_r8/)
      kbo(:, 2,55, 9) = (/ &
     &3.4306e-01_r8,7.9590e-01_r8,8.5878e-01_r8,7.5589e-01_r8,1.6856e-01_r8/)
      kbo(:, 3,55, 9) = (/ &
     &7.0266e-01_r8,1.2949e+00_r8,1.3605e+00_r8,1.1760e+00_r8,2.4233e-01_r8/)
      kbo(:, 4,55, 9) = (/ &
     &1.3593e+00_r8,2.0439e+00_r8,2.0790e+00_r8,1.7490e+00_r8,3.3108e-01_r8/)
      kbo(:, 5,55, 9) = (/ &
     &2.4959e+00_r8,3.1221e+00_r8,3.0894e+00_r8,2.5235e+00_r8,4.3367e-01_r8/)
      kbo(:, 1,56, 9) = (/ &
     &1.0564e-01_r8,3.5968e-01_r8,4.0062e-01_r8,3.6250e-01_r8,9.4093e-02_r8/)
      kbo(:, 2,56, 9) = (/ &
     &2.3778e-01_r8,6.3076e-01_r8,6.9353e-01_r8,6.2192e-01_r8,1.4691e-01_r8/)
      kbo(:, 3,56, 9) = (/ &
     &5.0289e-01_r8,1.0440e+00_r8,1.1212e+00_r8,9.8957e-01_r8,2.1564e-01_r8/)
      kbo(:, 4,56, 9) = (/ &
     &1.0047e+00_r8,1.6731e+00_r8,1.7388e+00_r8,1.4948e+00_r8,2.9947e-01_r8/)
      kbo(:, 5,56, 9) = (/ &
     &1.8976e+00_r8,2.5969e+00_r8,2.6179e+00_r8,2.1832e+00_r8,3.9803e-01_r8/)
      kbo(:, 1,57, 9) = (/ &
     &6.9404e-02_r8,2.7490e-01_r8,3.1190e-01_r8,2.8693e-01_r8,7.9174e-02_r8/)
      kbo(:, 2,57, 9) = (/ &
     &1.6275e-01_r8,4.9714e-01_r8,5.5717e-01_r8,5.0875e-01_r8,1.2713e-01_r8/)
      kbo(:, 3,57, 9) = (/ &
     &3.5620e-01_r8,8.3998e-01_r8,9.2115e-01_r8,8.2990e-01_r8,1.9063e-01_r8/)
      kbo(:, 4,57, 9) = (/ &
     &7.3515e-01_r8,1.3656e+00_r8,1.4515e+00_r8,1.2750e+00_r8,2.6981e-01_r8/)
      kbo(:, 5,57, 9) = (/ &
     &1.4305e+00_r8,2.1547e+00_r8,2.2152e+00_r8,1.8869e+00_r8,3.6361e-01_r8/)
      kbo(:, 1,58, 9) = (/ &
     &1.2018e-02_r8,6.8819e-02_r8,1.0253e-01_r8,1.3454e-01_r8,6.6409e-02_r8/)
      kbo(:, 2,58, 9) = (/ &
     &2.9376e-02_r8,1.2869e-01_r8,1.8932e-01_r8,2.4688e-01_r8,1.0988e-01_r8/)
      kbo(:, 3,58, 9) = (/ &
     &6.6678e-02_r8,2.2200e-01_r8,3.2071e-01_r8,4.1332e-01_r8,1.6852e-01_r8/)
      kbo(:, 4,58, 9) = (/ &
     &1.4218e-01_r8,3.6629e-01_r8,5.1309e-01_r8,6.4691e-01_r8,2.4300e-01_r8/)
      kbo(:, 5,58, 9) = (/ &
     &2.8506e-01_r8,5.8551e-01_r8,7.9229e-01_r8,9.6816e-01_r8,3.3198e-01_r8/)
      kbo(:, 1,59, 9) = (/ &
     &1.0974e-02_r8,7.7674e-02_r8,1.1174e-01_r8,1.3484e-01_r8,6.0877e-02_r8/)
      kbo(:, 2,59, 9) = (/ &
     &2.7572e-02_r8,1.4726e-01_r8,2.0947e-01_r8,2.5117e-01_r8,1.0237e-01_r8/)
      kbo(:, 3,59, 9) = (/ &
     &6.4218e-02_r8,2.5542e-01_r8,3.5789e-01_r8,4.2487e-01_r8,1.5885e-01_r8/)
      kbo(:, 4,59, 9) = (/ &
     &1.3998e-01_r8,4.2159e-01_r8,5.7382e-01_r8,6.6846e-01_r8,2.3069e-01_r8/)
      kbo(:, 5,59, 9) = (/ &
     &2.8653e-01_r8,6.7350e-01_r8,8.8507e-01_r8,9.9974e-01_r8,3.1701e-01_r8/)
      kbo(:, 1,13,10) = (/ &
     &3.0887e+02_r8,2.3182e+02_r8,1.5477e+02_r8,7.7734e+01_r8,3.2340e+00_r8/)
      kbo(:, 2,13,10) = (/ &
     &4.5010e+02_r8,3.3773e+02_r8,2.2537e+02_r8,1.1301e+02_r8,3.1679e+00_r8/)
      kbo(:, 3,13,10) = (/ &
     &6.1970e+02_r8,4.6492e+02_r8,3.1014e+02_r8,1.5536e+02_r8,3.1118e+00_r8/)
      kbo(:, 4,13,10) = (/ &
     &8.1413e+02_r8,6.1074e+02_r8,4.0734e+02_r8,2.0395e+02_r8,3.0351e+00_r8/)
      kbo(:, 5,13,10) = (/ &
     &1.0345e+03_r8,7.7604e+02_r8,5.1753e+02_r8,2.5903e+02_r8,2.9847e+00_r8/)
      kbo(:, 1,14,10) = (/ &
     &1.8722e+02_r8,1.4057e+02_r8,9.3932e+01_r8,4.7308e+01_r8,3.5502e+00_r8/)
      kbo(:, 2,14,10) = (/ &
     &2.7007e+02_r8,2.0269e+02_r8,1.3533e+02_r8,6.7970e+01_r8,3.4874e+00_r8/)
      kbo(:, 3,14,10) = (/ &
     &3.6889e+02_r8,2.7681e+02_r8,1.8473e+02_r8,9.2654e+01_r8,3.4323e+00_r8/)
      kbo(:, 4,14,10) = (/ &
     &4.8380e+02_r8,3.6298e+02_r8,2.4217e+02_r8,1.2136e+02_r8,3.3766e+00_r8/)
      kbo(:, 5,14,10) = (/ &
     &6.1384e+02_r8,4.6051e+02_r8,3.0717e+02_r8,1.5385e+02_r8,3.3022e+00_r8/)
      kbo(:, 1,15,10) = (/ &
     &1.1327e+02_r8,8.5100e+01_r8,5.6942e+01_r8,2.8827e+01_r8,3.8722e+00_r8/)
      kbo(:, 2,15,10) = (/ &
     &1.6194e+02_r8,1.2160e+02_r8,8.1262e+01_r8,4.0948e+01_r8,3.8151e+00_r8/)
      kbo(:, 3,15,10) = (/ &
     &2.2047e+02_r8,1.6549e+02_r8,1.1051e+02_r8,5.5552e+01_r8,3.7597e+00_r8/)
      kbo(:, 4,15,10) = (/ &
     &2.8853e+02_r8,2.1653e+02_r8,1.4453e+02_r8,7.2538e+01_r8,3.6967e+00_r8/)
      kbo(:, 5,15,10) = (/ &
     &3.6531e+02_r8,2.7411e+02_r8,1.8291e+02_r8,9.1708e+01_r8,3.6313e+00_r8/)
      kbo(:, 1,16,10) = (/ &
     &8.0065e+01_r8,6.0189e+01_r8,4.0328e+01_r8,2.0552e+01_r8,4.2109e+00_r8/)
      kbo(:, 2,16,10) = (/ &
     &1.1401e+02_r8,8.5639e+01_r8,5.7279e+01_r8,2.8971e+01_r8,4.1507e+00_r8/)
      kbo(:, 3,16,10) = (/ &
     &1.5472e+02_r8,1.1617e+02_r8,7.7619e+01_r8,3.9099e+01_r8,4.0906e+00_r8/)
      kbo(:, 4,16,10) = (/ &
     &2.0197e+02_r8,1.5160e+02_r8,1.0123e+02_r8,5.0878e+01_r8,4.0252e+00_r8/)
      kbo(:, 5,16,10) = (/ &
     &2.5492e+02_r8,1.9130e+02_r8,1.2769e+02_r8,6.4095e+01_r8,3.9532e+00_r8/)
      kbo(:, 1,17,10) = (/ &
     &5.7968e+01_r8,4.3609e+01_r8,2.9277e+01_r8,1.5223e+01_r8,4.5287e+00_r8/)
      kbo(:, 2,17,10) = (/ &
     &8.2190e+01_r8,6.1765e+01_r8,4.1354e+01_r8,2.1049e+01_r8,4.4713e+00_r8/)
      kbo(:, 3,17,10) = (/ &
     &1.1116e+02_r8,8.3481e+01_r8,5.5816e+01_r8,2.8216e+01_r8,4.4079e+00_r8/)
      kbo(:, 4,17,10) = (/ &
     &1.4447e+02_r8,1.0846e+02_r8,7.2459e+01_r8,3.6495e+01_r8,4.3339e+00_r8/)
      kbo(:, 5,17,10) = (/ &
     &1.8168e+02_r8,1.3637e+02_r8,9.1060e+01_r8,4.5781e+01_r8,4.2592e+00_r8/)
      kbo(:, 1,18,10) = (/ &
     &4.2612e+01_r8,3.2081e+01_r8,2.1612e+01_r8,1.2271e+01_r8,4.8071e+00_r8/)
      kbo(:, 2,18,10) = (/ &
     &6.0147e+01_r8,4.5223e+01_r8,3.0329e+01_r8,1.5934e+01_r8,4.7499e+00_r8/)
      kbo(:, 3,18,10) = (/ &
     &8.0941e+01_r8,6.0812e+01_r8,4.0702e+01_r8,2.0761e+01_r8,4.6797e+00_r8/)
      kbo(:, 4,18,10) = (/ &
     &1.0473e+02_r8,7.8652e+01_r8,5.2586e+01_r8,2.6600e+01_r8,4.6080e+00_r8/)
      kbo(:, 5,18,10) = (/ &
     &1.3143e+02_r8,9.8677e+01_r8,6.5930e+01_r8,3.3232e+01_r8,4.5353e+00_r8/)
      kbo(:, 1,19,10) = (/ &
     &3.0448e+01_r8,2.2951e+01_r8,1.5620e+01_r8,1.0168e+01_r8,5.0350e+00_r8/)
      kbo(:, 2,19,10) = (/ &
     &4.2741e+01_r8,3.2162e+01_r8,2.1658e+01_r8,1.2576e+01_r8,4.9712e+00_r8/)
      kbo(:, 3,19,10) = (/ &
     &5.7239e+01_r8,4.3029e+01_r8,2.8857e+01_r8,1.5561e+01_r8,4.9060e+00_r8/)
      kbo(:, 4,19,10) = (/ &
     &7.3990e+01_r8,5.5595e+01_r8,3.7227e+01_r8,1.9263e+01_r8,4.8462e+00_r8/)
      kbo(:, 5,19,10) = (/ &
     &9.3283e+01_r8,7.0062e+01_r8,4.6859e+01_r8,2.3820e+01_r8,4.7826e+00_r8/)
      kbo(:, 1,20,10) = (/ &
     &2.3494e+01_r8,1.7742e+01_r8,1.2645e+01_r8,9.3657e+00_r8,5.1974e+00_r8/)
      kbo(:, 2,20,10) = (/ &
     &3.2767e+01_r8,2.4679e+01_r8,1.6836e+01_r8,1.0930e+01_r8,5.1468e+00_r8/)
      kbo(:, 3,20,10) = (/ &
     &4.3805e+01_r8,3.2955e+01_r8,2.2186e+01_r8,1.3029e+01_r8,5.0951e+00_r8/)
      kbo(:, 4,20,10) = (/ &
     &5.6900e+01_r8,4.2771e+01_r8,2.8686e+01_r8,1.5712e+01_r8,5.0360e+00_r8/)
      kbo(:, 5,20,10) = (/ &
     &7.2009e+01_r8,5.4098e+01_r8,3.6220e+01_r8,1.9012e+01_r8,4.9716e+00_r8/)
      kbo(:, 1,21,10) = (/ &
     &1.8574e+01_r8,1.4067e+01_r8,1.0798e+01_r8,9.1144e+00_r8,5.2989e+00_r8/)
      kbo(:, 2,21,10) = (/ &
     &2.5833e+01_r8,1.9488e+01_r8,1.3882e+01_r8,1.0250e+01_r8,5.2602e+00_r8/)
      kbo(:, 3,21,10) = (/ &
     &3.4706e+01_r8,2.6128e+01_r8,1.7872e+01_r8,1.1627e+01_r8,5.2166e+00_r8/)
      kbo(:, 4,21,10) = (/ &
     &4.5183e+01_r8,3.3979e+01_r8,2.2895e+01_r8,1.3514e+01_r8,5.1658e+00_r8/)
      kbo(:, 5,21,10) = (/ &
     &5.7162e+01_r8,4.2958e+01_r8,2.8816e+01_r8,1.5946e+01_r8,5.1078e+00_r8/)
      kbo(:, 1,22,10) = (/ &
     &1.5385e+01_r8,1.1760e+01_r8,9.8072e+00_r8,8.9715e+00_r8,5.3316e+00_r8/)
      kbo(:, 2,22,10) = (/ &
     &2.1421e+01_r8,1.6187e+01_r8,1.2154e+01_r8,1.0019e+01_r8,5.3065e+00_r8/)
      kbo(:, 3,22,10) = (/ &
     &2.8763e+01_r8,2.1675e+01_r8,1.5363e+01_r8,1.1158e+01_r8,5.2767e+00_r8/)
      kbo(:, 4,22,10) = (/ &
     &3.7378e+01_r8,2.8123e+01_r8,1.9262e+01_r8,1.2474e+01_r8,5.2393e+00_r8/)
      kbo(:, 5,22,10) = (/ &
     &4.7335e+01_r8,3.5583e+01_r8,2.3996e+01_r8,1.4183e+01_r8,5.1848e+00_r8/)
      kbo(:, 1,23,10) = (/ &
     &1.2958e+01_r8,1.0148e+01_r8,9.3026e+00_r8,8.7646e+00_r8,5.3174e+00_r8/)
      kbo(:, 2,23,10) = (/ &
     &1.8016e+01_r8,1.3712e+01_r8,1.1027e+01_r8,9.7388e+00_r8,5.3065e+00_r8/)
      kbo(:, 3,23,10) = (/ &
     &2.4116e+01_r8,1.8203e+01_r8,1.3458e+01_r8,1.0800e+01_r8,5.2863e+00_r8/)
      kbo(:, 4,23,10) = (/ &
     &3.1331e+01_r8,2.3589e+01_r8,1.6625e+01_r8,1.1918e+01_r8,5.2605e+00_r8/)
      kbo(:, 5,23,10) = (/ &
     &3.9751e+01_r8,2.9901e+01_r8,2.0473e+01_r8,1.3180e+01_r8,5.2164e+00_r8/)
      kbo(:, 1,24,10) = (/ &
     &1.0965e+01_r8,8.9178e+00_r8,8.8968e+00_r8,8.4756e+00_r8,5.2609e+00_r8/)
      kbo(:, 2,24,10) = (/ &
     &1.5180e+01_r8,1.1787e+01_r8,1.0354e+01_r8,9.3845e+00_r8,5.2622e+00_r8/)
      kbo(:, 3,24,10) = (/ &
     &2.0304e+01_r8,1.5418e+01_r8,1.2131e+01_r8,1.0371e+01_r8,5.2552e+00_r8/)
      kbo(:, 4,24,10) = (/ &
     &2.6453e+01_r8,1.9955e+01_r8,1.4586e+01_r8,1.1412e+01_r8,5.2428e+00_r8/)
      kbo(:, 5,24,10) = (/ &
     &3.3727e+01_r8,2.5409e+01_r8,1.7807e+01_r8,1.2537e+01_r8,5.2080e+00_r8/)
      kbo(:, 1,25,10) = (/ &
     &9.4802e+00_r8,8.0678e+00_r8,8.5346e+00_r8,8.1689e+00_r8,5.1602e+00_r8/)
      kbo(:, 2,25,10) = (/ &
     &1.3091e+01_r8,1.0412e+01_r8,9.8804e+00_r8,9.0420e+00_r8,5.1798e+00_r8/)
      kbo(:, 3,25,10) = (/ &
     &1.7556e+01_r8,1.3502e+01_r8,1.1390e+01_r8,9.9740e+00_r8,5.1919e+00_r8/)
      kbo(:, 4,25,10) = (/ &
     &2.2937e+01_r8,1.7389e+01_r8,1.3318e+01_r8,1.0956e+01_r8,5.1855e+00_r8/)
      kbo(:, 5,25,10) = (/ &
     &2.9162e+01_r8,2.2007e+01_r8,1.5910e+01_r8,1.2043e+01_r8,5.1753e+00_r8/)
      kbo(:, 1,26,10) = (/ &
     &8.4883e+00_r8,7.6029e+00_r8,8.2305e+00_r8,7.8781e+00_r8,5.0300e+00_r8/)
      kbo(:, 2,26,10) = (/ &
     &1.1732e+01_r8,9.5611e+00_r8,9.4929e+00_r8,8.7340e+00_r8,5.0703e+00_r8/)
      kbo(:, 3,26,10) = (/ &
     &1.5710e+01_r8,1.2274e+01_r8,1.0941e+01_r8,9.6483e+00_r8,5.1008e+00_r8/)
      kbo(:, 4,26,10) = (/ &
     &2.0377e+01_r8,1.5577e+01_r8,1.2626e+01_r8,1.0617e+01_r8,5.1143e+00_r8/)
      kbo(:, 5,26,10) = (/ &
     &2.5762e+01_r8,1.9497e+01_r8,1.4646e+01_r8,1.1691e+01_r8,5.1337e+00_r8/)
      kbo(:, 1,27,10) = (/ &
     &7.9831e+00_r8,7.4657e+00_r8,8.0386e+00_r8,7.6712e+00_r8,4.8762e+00_r8/)
      kbo(:, 2,27,10) = (/ &
     &1.1007e+01_r8,9.2258e+00_r8,9.2928e+00_r8,8.5396e+00_r8,4.9402e+00_r8/)
      kbo(:, 3,27,10) = (/ &
     &1.4621e+01_r8,1.1594e+01_r8,1.0757e+01_r8,9.4652e+00_r8,4.9915e+00_r8/)
      kbo(:, 4,27,10) = (/ &
     &1.8847e+01_r8,1.4547e+01_r8,1.2326e+01_r8,1.0475e+01_r8,5.0304e+00_r8/)
      kbo(:, 5,27,10) = (/ &
     &2.3744e+01_r8,1.8045e+01_r8,1.4056e+01_r8,1.1545e+01_r8,5.0808e+00_r8/)
      kbo(:, 1,28,10) = (/ &
     &7.7237e+00_r8,7.4713e+00_r8,7.9486e+00_r8,7.5349e+00_r8,4.7172e+00_r8/)
      kbo(:, 2,28,10) = (/ &
     &1.0564e+01_r8,9.1113e+00_r8,9.2602e+00_r8,8.4182e+00_r8,4.8066e+00_r8/)
      kbo(:, 3,28,10) = (/ &
     &1.3950e+01_r8,1.1225e+01_r8,1.0715e+01_r8,9.3795e+00_r8,4.8773e+00_r8/)
      kbo(:, 4,28,10) = (/ &
     &1.7938e+01_r8,1.3957e+01_r8,1.2227e+01_r8,1.0437e+01_r8,4.9557e+00_r8/)
      kbo(:, 5,28,10) = (/ &
     &2.2520e+01_r8,1.7201e+01_r8,1.3827e+01_r8,1.1495e+01_r8,5.0256e+00_r8/)
      kbo(:, 1,29,10) = (/ &
     &7.9252e+00_r8,7.7575e+00_r8,8.1492e+00_r8,7.5791e+00_r8,4.5608e+00_r8/)
      kbo(:, 2,29,10) = (/ &
     &1.0756e+01_r8,9.3871e+00_r8,9.5612e+00_r8,8.5083e+00_r8,4.6721e+00_r8/)
      kbo(:, 3,29,10) = (/ &
     &1.4151e+01_r8,1.1455e+01_r8,1.1026e+01_r8,9.5615e+00_r8,4.7742e+00_r8/)
      kbo(:, 4,29,10) = (/ &
     &1.8135e+01_r8,1.4153e+01_r8,1.2557e+01_r8,1.0665e+01_r8,4.8851e+00_r8/)
      kbo(:, 5,29,10) = (/ &
     &2.2757e+01_r8,1.7409e+01_r8,1.4161e+01_r8,1.1730e+01_r8,4.9738e+00_r8/)
      kbo(:, 1,30,10) = (/ &
     &8.3260e+00_r8,8.1445e+00_r8,8.5115e+00_r8,7.7075e+00_r8,4.4112e+00_r8/)
      kbo(:, 2,30,10) = (/ &
     &1.1239e+01_r8,9.8059e+00_r8,9.9796e+00_r8,8.7369e+00_r8,4.5506e+00_r8/)
      kbo(:, 3,30,10) = (/ &
     &1.4731e+01_r8,1.1916e+01_r8,1.1495e+01_r8,9.8748e+00_r8,4.7011e+00_r8/)
      kbo(:, 4,30,10) = (/ &
     &1.8856e+01_r8,1.4710e+01_r8,1.3064e+01_r8,1.1008e+01_r8,4.8328e+00_r8/)
      kbo(:, 5,30,10) = (/ &
     &2.3705e+01_r8,1.8124e+01_r8,1.4716e+01_r8,1.2119e+01_r8,4.9257e+00_r8/)
      kbo(:, 1,31,10) = (/ &
     &9.2196e+00_r8,8.8116e+00_r8,9.1465e+00_r8,8.0622e+00_r8,4.2873e+00_r8/)
      kbo(:, 2,31,10) = (/ &
     &1.2392e+01_r8,1.0607e+01_r8,1.0704e+01_r8,9.2367e+00_r8,4.4733e+00_r8/)
      kbo(:, 3,31,10) = (/ &
     &1.6211e+01_r8,1.2983e+01_r8,1.2309e+01_r8,1.0449e+01_r8,4.6511e+00_r8/)
      kbo(:, 4,31,10) = (/ &
     &2.0762e+01_r8,1.6100e+01_r8,1.3996e+01_r8,1.1659e+01_r8,4.7878e+00_r8/)
      kbo(:, 5,31,10) = (/ &
     &2.6150e+01_r8,1.9908e+01_r8,1.5819e+01_r8,1.2859e+01_r8,4.9198e+00_r8/)
      kbo(:, 1,32,10) = (/ &
     &1.0359e+01_r8,9.6137e+00_r8,9.8752e+00_r8,8.5830e+00_r8,4.2174e+00_r8/)
      kbo(:, 2,32,10) = (/ &
     &1.3877e+01_r8,1.1631e+01_r8,1.1538e+01_r8,9.8576e+00_r8,4.4285e+00_r8/)
      kbo(:, 3,32,10) = (/ &
     &1.8140e+01_r8,1.4380e+01_r8,1.3269e+01_r8,1.1160e+01_r8,4.5970e+00_r8/)
      kbo(:, 4,32,10) = (/ &
     &2.3264e+01_r8,1.7927e+01_r8,1.5118e+01_r8,1.2461e+01_r8,4.7493e+00_r8/)
      kbo(:, 5,32,10) = (/ &
     &2.9418e+01_r8,2.2303e+01_r8,1.7227e+01_r8,1.3746e+01_r8,4.9087e+00_r8/)
      kbo(:, 1,33,10) = (/ &
     &1.1859e+01_r8,1.0640e+01_r8,1.0773e+01_r8,9.2560e+00_r8,4.1651e+00_r8/)
      kbo(:, 2,33,10) = (/ &
     &1.5884e+01_r8,1.3011e+01_r8,1.2572e+01_r8,1.0635e+01_r8,4.3715e+00_r8/)
      kbo(:, 3,33,10) = (/ &
     &2.0782e+01_r8,1.6260e+01_r8,1.4502e+01_r8,1.2047e+01_r8,4.5449e+00_r8/)
      kbo(:, 4,33,10) = (/ &
     &2.6731e+01_r8,2.0436e+01_r8,1.6585e+01_r8,1.3454e+01_r8,4.7445e+00_r8/)
      kbo(:, 5,33,10) = (/ &
     &3.3983e+01_r8,2.5659e+01_r8,1.9186e+01_r8,1.4880e+01_r8,4.8947e+00_r8/)
      kbo(:, 1,34,10) = (/ &
     &1.3139e+01_r8,1.1513e+01_r8,1.1537e+01_r8,9.8375e+00_r8,4.1077e+00_r8/)
      kbo(:, 2,34,10) = (/ &
     &1.7636e+01_r8,1.4225e+01_r8,1.3489e+01_r8,1.1311e+01_r8,4.3160e+00_r8/)
      kbo(:, 3,34,10) = (/ &
     &2.3141e+01_r8,1.7962e+01_r8,1.5594e+01_r8,1.2810e+01_r8,4.5443e+00_r8/)
      kbo(:, 4,34,10) = (/ &
     &2.9960e+01_r8,2.2778e+01_r8,1.7924e+01_r8,1.4335e+01_r8,4.7397e+00_r8/)
      kbo(:, 5,34,10) = (/ &
     &3.8261e+01_r8,2.8825e+01_r8,2.1079e+01_r8,1.5921e+01_r8,4.9149e+00_r8/)
      kbo(:, 1,35,10) = (/ &
     &1.4201e+01_r8,1.2261e+01_r8,1.2213e+01_r8,1.0330e+01_r8,4.0399e+00_r8/)
      kbo(:, 2,35,10) = (/ &
     &1.9135e+01_r8,1.5305e+01_r8,1.4323e+01_r8,1.1895e+01_r8,4.2894e+00_r8/)
      kbo(:, 3,35,10) = (/ &
     &2.5318e+01_r8,1.9545e+01_r8,1.6589e+01_r8,1.3508e+01_r8,4.5397e+00_r8/)
      kbo(:, 4,35,10) = (/ &
     &3.3021e+01_r8,2.5025e+01_r8,1.9285e+01_r8,1.5170e+01_r8,4.7565e+00_r8/)
      kbo(:, 5,35,10) = (/ &
     &4.2461e+01_r8,3.1954e+01_r8,2.3012e+01_r8,1.6958e+01_r8,4.9332e+00_r8/)
      kbo(:, 1,36,10) = (/ &
     &1.4798e+01_r8,1.2717e+01_r8,1.2670e+01_r8,1.0657e+01_r8,3.9724e+00_r8/)
      kbo(:, 2,36,10) = (/ &
     &2.0092e+01_r8,1.6016e+01_r8,1.4899e+01_r8,1.2316e+01_r8,4.2681e+00_r8/)
      kbo(:, 3,36,10) = (/ &
     &2.6852e+01_r8,2.0677e+01_r8,1.7358e+01_r8,1.4052e+01_r8,4.5368e+00_r8/)
      kbo(:, 4,36,10) = (/ &
     &3.5362e+01_r8,2.6747e+01_r8,2.0391e+01_r8,1.5864e+01_r8,4.7528e+00_r8/)
      kbo(:, 5,36,10) = (/ &
     &4.5869e+01_r8,3.4503e+01_r8,2.4644e+01_r8,1.7859e+01_r8,4.9480e+00_r8/)
      kbo(:, 1,37,10) = (/ &
     &1.4369e+01_r8,1.2549e+01_r8,1.2615e+01_r8,1.0629e+01_r8,3.8875e+00_r8/)
      kbo(:, 2,37,10) = (/ &
     &1.9757e+01_r8,1.5840e+01_r8,1.4922e+01_r8,1.2359e+01_r8,4.2086e+00_r8/)
      kbo(:, 3,37,10) = (/ &
     &2.6704e+01_r8,2.0605e+01_r8,1.7493e+01_r8,1.4185e+01_r8,4.4864e+00_r8/)
      kbo(:, 4,37,10) = (/ &
     &3.5588e+01_r8,2.6935e+01_r8,2.0650e+01_r8,1.6109e+01_r8,4.7274e+00_r8/)
      kbo(:, 5,37,10) = (/ &
     &4.6659e+01_r8,3.5099e+01_r8,2.5115e+01_r8,1.8232e+01_r8,4.9396e+00_r8/)
      kbo(:, 1,38,10) = (/ &
     &1.4144e+01_r8,1.2516e+01_r8,1.2646e+01_r8,1.0674e+01_r8,3.8121e+00_r8/)
      kbo(:, 2,38,10) = (/ &
     &1.9692e+01_r8,1.5869e+01_r8,1.5055e+01_r8,1.2490e+01_r8,4.1526e+00_r8/)
      kbo(:, 3,38,10) = (/ &
     &2.6928e+01_r8,2.0800e+01_r8,1.7766e+01_r8,1.4428e+01_r8,4.4461e+00_r8/)
      kbo(:, 4,38,10) = (/ &
     &3.6364e+01_r8,2.7528e+01_r8,2.1122e+01_r8,1.6470e+01_r8,4.6931e+00_r8/)
      kbo(:, 5,38,10) = (/ &
     &4.8190e+01_r8,3.6248e+01_r8,2.5894e+01_r8,1.8774e+01_r8,4.9281e+00_r8/)
      kbo(:, 1,39,10) = (/ &
     &1.4265e+01_r8,1.2699e+01_r8,1.2840e+01_r8,1.0848e+01_r8,3.7413e+00_r8/)
      kbo(:, 2,39,10) = (/ &
     &2.0117e+01_r8,1.6218e+01_r8,1.5387e+01_r8,1.2783e+01_r8,4.1060e+00_r8/)
      kbo(:, 3,39,10) = (/ &
     &2.7852e+01_r8,2.1494e+01_r8,1.8320e+01_r8,1.4851e+01_r8,4.4149e+00_r8/)
      kbo(:, 4,39,10) = (/ &
     &3.8047e+01_r8,2.8782e+01_r8,2.1981e+01_r8,1.7084e+01_r8,4.6584e+00_r8/)
      kbo(:, 5,39,10) = (/ &
     &5.1036e+01_r8,3.8378e+01_r8,2.7311e+01_r8,1.9599e+01_r8,4.9209e+00_r8/)
      kbo(:, 1,40,10) = (/ &
     &1.3045e+01_r8,1.2072e+01_r8,1.2332e+01_r8,1.0515e+01_r8,3.6349e+00_r8/)
      kbo(:, 2,40,10) = (/ &
     &1.8669e+01_r8,1.5342e+01_r8,1.4892e+01_r8,1.2474e+01_r8,4.0124e+00_r8/)
      kbo(:, 3,40,10) = (/ &
     &2.6244e+01_r8,2.0390e+01_r8,1.7841e+01_r8,1.4589e+01_r8,4.3337e+00_r8/)
      kbo(:, 4,40,10) = (/ &
     &3.6291e+01_r8,2.7528e+01_r8,2.1453e+01_r8,1.6896e+01_r8,4.5936e+00_r8/)
      kbo(:, 5,40,10) = (/ &
     &4.9350e+01_r8,3.7123e+01_r8,2.6680e+01_r8,1.9495e+01_r8,4.8667e+00_r8/)
      kbo(:, 1,41,10) = (/ &
     &1.1803e+01_r8,1.1439e+01_r8,1.1786e+01_r8,1.0149e+01_r8,3.5171e+00_r8/)
      kbo(:, 2,41,10) = (/ &
     &1.7194e+01_r8,1.4495e+01_r8,1.4344e+01_r8,1.2127e+01_r8,3.9113e+00_r8/)
      kbo(:, 3,41,10) = (/ &
     &2.4539e+01_r8,1.9243e+01_r8,1.7307e+01_r8,1.4275e+01_r8,4.2454e+00_r8/)
      kbo(:, 4,41,10) = (/ &
     &3.4381e+01_r8,2.6175e+01_r8,2.0871e+01_r8,1.6646e+01_r8,4.5236e+00_r8/)
      kbo(:, 5,41,10) = (/ &
     &4.7387e+01_r8,3.5674e+01_r8,2.5938e+01_r8,1.9314e+01_r8,4.8021e+00_r8/)
      kbo(:, 1,42,10) = (/ &
     &1.0775e+01_r8,1.0903e+01_r8,1.1326e+01_r8,9.8291e+00_r8,3.4027e+00_r8/)
      kbo(:, 2,42,10) = (/ &
     &1.5966e+01_r8,1.3847e+01_r8,1.3900e+01_r8,1.1829e+01_r8,3.8068e+00_r8/)
      kbo(:, 3,42,10) = (/ &
     &2.3163e+01_r8,1.8350e+01_r8,1.6888e+01_r8,1.4033e+01_r8,4.1524e+00_r8/)
      kbo(:, 4,42,10) = (/ &
     &3.2905e+01_r8,2.5146e+01_r8,2.0462e+01_r8,1.6474e+01_r8,4.4507e+00_r8/)
      kbo(:, 5,42,10) = (/ &
     &4.5959e+01_r8,3.4632e+01_r8,2.5458e+01_r8,1.9233e+01_r8,4.7372e+00_r8/)
      kbo(:, 1,43,10) = (/ &
     &9.6785e+00_r8,1.0293e+01_r8,1.0788e+01_r8,9.4380e+00_r8,3.2651e+00_r8/)
      kbo(:, 2,43,10) = (/ &
     &1.4578e+01_r8,1.3133e+01_r8,1.3380e+01_r8,1.1460e+01_r8,3.6820e+00_r8/)
      kbo(:, 3,43,10) = (/ &
     &2.1568e+01_r8,1.7343e+01_r8,1.6367e+01_r8,1.3704e+01_r8,4.0432e+00_r8/)
      kbo(:, 4,43,10) = (/ &
     &3.1160e+01_r8,2.3941e+01_r8,1.9961e+01_r8,1.6215e+01_r8,4.3540e+00_r8/)
      kbo(:, 5,43,10) = (/ &
     &4.4112e+01_r8,3.3295e+01_r8,2.4834e+01_r8,1.9063e+01_r8,4.6487e+00_r8/)
      kbo(:, 1,44,10) = (/ &
     &8.6703e+00_r8,9.7103e+00_r8,1.0263e+01_r8,9.0428e+00_r8,3.1167e+00_r8/)
      kbo(:, 2,44,10) = (/ &
     &1.3323e+01_r8,1.2507e+01_r8,1.2872e+01_r8,1.1099e+01_r8,3.5429e+00_r8/)
      kbo(:, 3,44,10) = (/ &
     &2.0055e+01_r8,1.6451e+01_r8,1.5900e+01_r8,1.3381e+01_r8,3.9213e+00_r8/)
      kbo(:, 4,44,10) = (/ &
     &2.9535e+01_r8,2.2835e+01_r8,1.9530e+01_r8,1.5970e+01_r8,4.2481e+00_r8/)
      kbo(:, 5,44,10) = (/ &
     &4.2449e+01_r8,3.2099e+01_r8,2.4329e+01_r8,1.8926e+01_r8,4.5571e+00_r8/)
      kbo(:, 1,45,10) = (/ &
     &7.8818e+00_r8,9.2454e+00_r8,9.8403e+00_r8,8.7130e+00_r8,2.9638e+00_r8/)
      kbo(:, 2,45,10) = (/ &
     &1.2355e+01_r8,1.2035e+01_r8,1.2482e+01_r8,1.0822e+01_r8,3.4038e+00_r8/)
      kbo(:, 3,45,10) = (/ &
     &1.8948e+01_r8,1.5842e+01_r8,1.5587e+01_r8,1.3162e+01_r8,3.7919e+00_r8/)
      kbo(:, 4,45,10) = (/ &
     &2.8443e+01_r8,2.2122e+01_r8,1.9322e+01_r8,1.5846e+01_r8,4.1405e+00_r8/)
      kbo(:, 5,45,10) = (/ &
     &4.1558e+01_r8,3.1475e+01_r8,2.4163e+01_r8,1.8949e+01_r8,4.4650e+00_r8/)
      kbo(:, 1,46,10) = (/ &
     &7.1089e+00_r8,8.7733e+00_r8,9.3941e+00_r8,8.3547e+00_r8,2.8054e+00_r8/)
      kbo(:, 2,46,10) = (/ &
     &1.1401e+01_r8,1.1562e+01_r8,1.2067e+01_r8,1.0520e+01_r8,3.2536e+00_r8/)
      kbo(:, 3,46,10) = (/ &
     &1.7834e+01_r8,1.5248e+01_r8,1.5247e+01_r8,1.2927e+01_r8,3.6528e+00_r8/)
      kbo(:, 4,46,10) = (/ &
     &2.7249e+01_r8,2.1375e+01_r8,1.9093e+01_r8,1.5705e+01_r8,4.0192e+00_r8/)
      kbo(:, 5,46,10) = (/ &
     &4.0651e+01_r8,3.0866e+01_r8,2.4015e+01_r8,1.8943e+01_r8,4.3574e+00_r8/)
      kbo(:, 1,47,10) = (/ &
     &6.1649e+00_r8,8.1403e+00_r8,8.7798e+00_r8,7.8562e+00_r8,2.6253e+00_r8/)
      kbo(:, 2,47,10) = (/ &
     &1.0138e+01_r8,1.0874e+01_r8,1.1437e+01_r8,1.0055e+01_r8,3.0768e+00_r8/)
      kbo(:, 3,47,10) = (/ &
     &1.6220e+01_r8,1.4389e+01_r8,1.4631e+01_r8,1.2502e+01_r8,3.4927e+00_r8/)
      kbo(:, 4,47,10) = (/ &
     &2.5292e+01_r8,2.0083e+01_r8,1.8506e+01_r8,1.5334e+01_r8,3.8713e+00_r8/)
      kbo(:, 5,47,10) = (/ &
     &3.8579e+01_r8,2.9419e+01_r8,2.3431e+01_r8,1.8659e+01_r8,4.2295e+00_r8/)
      kbo(:, 1,48,10) = (/ &
     &5.4216e+00_r8,7.6284e+00_r8,8.2781e+00_r8,7.4282e+00_r8,2.4448e+00_r8/)
      kbo(:, 2,48,10) = (/ &
     &9.1674e+00_r8,1.0353e+01_r8,1.0955e+01_r8,9.6794e+00_r8,2.8941e+00_r8/)
      kbo(:, 3,48,10) = (/ &
     &1.5043e+01_r8,1.3839e+01_r8,1.4203e+01_r8,1.2197e+01_r8,3.3245e+00_r8/)
      kbo(:, 4,48,10) = (/ &
     &2.3974e+01_r8,1.9288e+01_r8,1.8167e+01_r8,1.5125e+01_r8,3.7165e+00_r8/)
      kbo(:, 5,48,10) = (/ &
     &3.7305e+01_r8,2.8554e+01_r8,2.3217e+01_r8,1.8594e+01_r8,4.0932e+00_r8/)
      kbo(:, 1,49,10) = (/ &
     &4.8939e+00_r8,7.2548e+00_r8,7.9080e+00_r8,7.0906e+00_r8,2.2660e+00_r8/)
      kbo(:, 2,49,10) = (/ &
     &8.5415e+00_r8,1.0039e+01_r8,1.0662e+01_r8,9.4308e+00_r8,2.7166e+00_r8/)
      kbo(:, 3,49,10) = (/ &
     &1.4366e+01_r8,1.3618e+01_r8,1.4041e+01_r8,1.2074e+01_r8,3.1539e+00_r8/)
      kbo(:, 4,49,10) = (/ &
     &2.3519e+01_r8,1.9097e+01_r8,1.8194e+01_r8,1.5161e+01_r8,3.5625e+00_r8/)
      kbo(:, 5,49,10) = (/ &
     &3.7354e+01_r8,2.8637e+01_r8,2.3540e+01_r8,1.8862e+01_r8,3.9655e+00_r8/)
      kbo(:, 1,50,10) = (/ &
     &4.2089e+00_r8,6.7050e+00_r8,7.3787e+00_r8,6.6334e+00_r8,2.0951e+00_r8/)
      kbo(:, 2,50,10) = (/ &
     &7.5781e+00_r8,9.4477e+00_r8,1.0132e+01_r8,8.9977e+00_r8,2.5467e+00_r8/)
      kbo(:, 3,50,10) = (/ &
     &1.3098e+01_r8,1.3002e+01_r8,1.3521e+01_r8,1.1708e+01_r8,2.9888e+00_r8/)
      kbo(:, 4,50,10) = (/ &
     &2.2021e+01_r8,1.8246e+01_r8,1.7755e+01_r8,1.4869e+01_r8,3.4160e+00_r8/)
      kbo(:, 5,50,10) = (/ &
     &3.5802e+01_r8,2.7586e+01_r8,2.3214e+01_r8,1.8702e+01_r8,3.8321e+00_r8/)
      kbo(:, 1,51,10) = (/ &
     &3.5246e+00_r8,6.0952e+00_r8,6.7836e+00_r8,6.1221e+00_r8,1.9285e+00_r8/)
      kbo(:, 2,51,10) = (/ &
     &6.5392e+00_r8,8.7579e+00_r8,9.5007e+00_r8,8.4899e+00_r8,2.3790e+00_r8/)
      kbo(:, 3,51,10) = (/ &
     &1.1662e+01_r8,1.2207e+01_r8,1.2854e+01_r8,1.1229e+01_r8,2.8289e+00_r8/)
      kbo(:, 4,51,10) = (/ &
     &2.0094e+01_r8,1.7146e+01_r8,1.7077e+01_r8,1.4419e+01_r8,3.2637e+00_r8/)
      kbo(:, 5,51,10) = (/ &
     &3.3544e+01_r8,2.6031e+01_r8,2.2586e+01_r8,1.8311e+01_r8,3.6955e+00_r8/)
      kbo(:, 1,52,10) = (/ &
     &2.9972e+00_r8,5.5809e+00_r8,6.2670e+00_r8,5.6729e+00_r8,1.7637e+00_r8/)
      kbo(:, 2,52,10) = (/ &
     &5.7401e+00_r8,8.2025e+00_r8,8.9834e+00_r8,8.0597e+00_r8,2.2115e+00_r8/)
      kbo(:, 3,52,10) = (/ &
     &1.0553e+01_r8,1.1618e+01_r8,1.2357e+01_r8,1.0861e+01_r8,2.6710e+00_r8/)
      kbo(:, 4,52,10) = (/ &
     &1.8666e+01_r8,1.6392e+01_r8,1.6645e+01_r8,1.4126e+01_r8,3.1091e+00_r8/)
      kbo(:, 5,52,10) = (/ &
     &3.2058e+01_r8,2.5069e+01_r8,2.2259e+01_r8,1.8128e+01_r8,3.5578e+00_r8/)
      kbo(:, 1,53,10) = (/ &
     &2.6079e+00_r8,5.1734e+00_r8,5.8449e+00_r8,5.2987e+00_r8,1.6026e+00_r8/)
      kbo(:, 2,53,10) = (/ &
     &5.1862e+00_r8,7.8030e+00_r8,8.6055e+00_r8,7.7246e+00_r8,2.0456e+00_r8/)
      kbo(:, 3,53,10) = (/ &
     &9.8254e+00_r8,1.1267e+01_r8,1.2065e+01_r8,1.0633e+01_r8,2.5075e+00_r8/)
      kbo(:, 4,53,10) = (/ &
     &1.7902e+01_r8,1.6069e+01_r8,1.6506e+01_r8,1.4053e+01_r8,2.9528e+00_r8/)
      kbo(:, 5,53,10) = (/ &
     &3.1626e+01_r8,2.4842e+01_r8,2.2382e+01_r8,1.8272e+01_r8,3.4166e+00_r8/)
      kbo(:, 1,54,10) = (/ &
     &1.9692e+00_r8,4.4492e+00_r8,5.0971e+00_r8,4.6730e+00_r8,1.4560e+00_r8/)
      kbo(:, 2,54,10) = (/ &
     &4.0777e+00_r8,6.8483e+00_r8,7.6942e+00_r8,6.9748e+00_r8,1.8918e+00_r8/)
      kbo(:, 3,54,10) = (/ &
     &7.9636e+00_r8,1.0044e+01_r8,1.0960e+01_r8,9.7978e+00_r8,2.3486e+00_r8/)
      kbo(:, 4,54,10) = (/ &
     &1.4982e+01_r8,1.4434e+01_r8,1.5164e+01_r8,1.3125e+01_r8,2.8028e+00_r8/)
      kbo(:, 5,54,10) = (/ &
     &2.7158e+01_r8,2.1902e+01_r8,2.0733e+01_r8,1.7211e+01_r8,3.2543e+00_r8/)
      kbo(:, 1,55,10) = (/ &
     &1.3507e+00_r8,3.6433e+00_r8,4.2566e+00_r8,3.9661e+00_r8,1.3130e+00_r8/)
      kbo(:, 2,55,10) = (/ &
     &2.9154e+00_r8,5.7215e+00_r8,6.5830e+00_r8,6.0536e+00_r8,1.7424e+00_r8/)
      kbo(:, 3,55,10) = (/ &
     &5.8789e+00_r8,8.5105e+00_r8,9.5339e+00_r8,8.6749e+00_r8,2.1951e+00_r8/)
      kbo(:, 4,55,10) = (/ &
     &1.1400e+01_r8,1.2318e+01_r8,1.3311e+01_r8,1.1788e+01_r8,2.6530e+00_r8/)
      kbo(:, 5,55,10) = (/ &
     &2.1258e+01_r8,1.8155e+01_r8,1.8294e+01_r8,1.5532e+01_r8,3.0990e+00_r8/)
      kbo(:, 1,56,10) = (/ &
     &9.1417e-01_r8,2.9676e+00_r8,3.5310e+00_r8,3.3437e+00_r8,1.1797e+00_r8/)
      kbo(:, 2,56,10) = (/ &
     &2.0541e+00_r8,4.7744e+00_r8,5.6130e+00_r8,5.2303e+00_r8,1.5997e+00_r8/)
      kbo(:, 3,56,10) = (/ &
     &4.2988e+00_r8,7.2236e+00_r8,8.2994e+00_r8,7.6574e+00_r8,2.0435e+00_r8/)
      kbo(:, 4,56,10) = (/ &
     &8.5903e+00_r8,1.0539e+01_r8,1.1687e+01_r8,1.0572e+01_r8,2.5005e+00_r8/)
      kbo(:, 5,56,10) = (/ &
     &1.6506e+01_r8,1.5331e+01_r8,1.6174e+01_r8,1.4030e+01_r8,2.9531e+00_r8/)
      kbo(:, 1,57,10) = (/ &
     &6.0887e-01_r8,2.4030e+00_r8,2.9065e+00_r8,2.7971e+00_r8,1.0495e+00_r8/)
      kbo(:, 2,57,10) = (/ &
     &1.4281e+00_r8,3.9782e+00_r8,4.7656e+00_r8,4.4965e+00_r8,1.4561e+00_r8/)
      kbo(:, 3,57,10) = (/ &
     &3.1054e+00_r8,6.1238e+00_r8,7.2122e+00_r8,6.7209e+00_r8,1.8934e+00_r8/)
      kbo(:, 4,57,10) = (/ &
     &6.4056e+00_r8,9.0325e+00_r8,1.0294e+01_r8,9.4596e+00_r8,2.3523e+00_r8/)
      kbo(:, 5,57,10) = (/ &
     &1.2719e+01_r8,1.3167e+01_r8,1.4312e+01_r8,1.2682e+01_r8,2.8029e+00_r8/)
      kbo(:, 1,58,10) = (/ &
     &1.0707e-01_r8,6.3953e-01_r8,1.0127e+00_r8,1.3896e+00_r8,9.3114e-01_r8/)
      kbo(:, 2,58,10) = (/ &
     &2.6195e-01_r8,1.0902e+00_r8,1.7100e+00_r8,2.2949e+00_r8,1.3241e+00_r8/)
      kbo(:, 3,58,10) = (/ &
     &5.9147e-01_r8,1.7109e+00_r8,2.6503e+00_r8,3.5010e+00_r8,1.7544e+00_r8/)
      kbo(:, 4,58,10) = (/ &
     &1.2606e+00_r8,2.5523e+00_r8,3.8433e+00_r8,5.0138e+00_r8,2.2018e+00_r8/)
      kbo(:, 5,58,10) = (/ &
     &2.5874e+00_r8,3.7372e+00_r8,5.3689e+00_r8,6.8137e+00_r8,2.6612e+00_r8/)
      kbo(:, 1,59,10) = (/ &
     &9.9298e-02_r8,7.6667e-01_r8,1.1645e+00_r8,1.4612e+00_r8,8.8547e-01_r8/)
      kbo(:, 2,59,10) = (/ &
     &2.4968e-01_r8,1.3224e+00_r8,1.9807e+00_r8,2.4248e+00_r8,1.2655e+00_r8/)
      kbo(:, 3,59,10) = (/ &
     &5.7897e-01_r8,2.0921e+00_r8,3.0941e+00_r8,3.7073e+00_r8,1.6878e+00_r8/)
      kbo(:, 4,59,10) = (/ &
     &1.2660e+00_r8,3.1094e+00_r8,4.5051e+00_r8,5.3308e+00_r8,2.1316e+00_r8/)
      kbo(:, 5,59,10) = (/ &
     &2.6665e+00_r8,4.5101e+00_r8,6.2520e+00_r8,7.2627e+00_r8,2.5824e+00_r8/)
      kbo(:, 1,13,11) = (/ &
     &4.9137e+02_r8,3.6866e+02_r8,2.4595e+02_r8,1.2325e+02_r8,3.7154e+00_r8/)
      kbo(:, 2,13,11) = (/ &
     &7.1842e+02_r8,5.3894e+02_r8,3.5946e+02_r8,1.7998e+02_r8,3.6255e+00_r8/)
      kbo(:, 3,13,11) = (/ &
     &9.9186e+02_r8,7.4402e+02_r8,4.9618e+02_r8,2.4833e+02_r8,3.5452e+00_r8/)
      kbo(:, 4,13,11) = (/ &
     &1.3059e+03_r8,9.7954e+02_r8,6.5319e+02_r8,3.2683e+02_r8,3.4736e+00_r8/)
      kbo(:, 5,13,11) = (/ &
     &1.6553e+03_r8,1.2416e+03_r8,8.2787e+02_r8,4.1417e+02_r8,3.4158e+00_r8/)
      kbo(:, 1,14,11) = (/ &
     &3.1242e+02_r8,2.3443e+02_r8,1.5644e+02_r8,7.8454e+01_r8,4.0956e+00_r8/)
      kbo(:, 2,14,11) = (/ &
     &4.5149e+02_r8,3.3873e+02_r8,2.2597e+02_r8,1.1322e+02_r8,4.0089e+00_r8/)
      kbo(:, 3,14,11) = (/ &
     &6.1672e+02_r8,4.6265e+02_r8,3.0858e+02_r8,1.5452e+02_r8,3.9350e+00_r8/)
      kbo(:, 4,14,11) = (/ &
     &8.0574e+02_r8,6.0442e+02_r8,4.0309e+02_r8,2.0177e+02_r8,3.8665e+00_r8/)
      kbo(:, 5,14,11) = (/ &
     &1.0145e+03_r8,7.6099e+02_r8,5.0748e+02_r8,2.5397e+02_r8,3.7755e+00_r8/)
      kbo(:, 1,15,11) = (/ &
     &1.9759e+02_r8,1.4830e+02_r8,9.9018e+01_r8,4.9739e+01_r8,4.5712e+00_r8/)
      kbo(:, 2,15,11) = (/ &
     &2.8230e+02_r8,2.1184e+02_r8,1.4137e+02_r8,7.0907e+01_r8,4.4810e+00_r8/)
      kbo(:, 3,15,11) = (/ &
     &3.8219e+02_r8,2.8675e+02_r8,1.9132e+02_r8,9.5881e+01_r8,4.3973e+00_r8/)
      kbo(:, 4,15,11) = (/ &
     &4.9586e+02_r8,3.7201e+02_r8,2.4816e+02_r8,1.2430e+02_r8,4.3207e+00_r8/)
      kbo(:, 5,15,11) = (/ &
     &6.2301e+02_r8,4.6738e+02_r8,3.1174e+02_r8,1.5610e+02_r8,4.2419e+00_r8/)
      kbo(:, 1,16,11) = (/ &
     &1.4534e+02_r8,1.0912e+02_r8,7.2899e+01_r8,3.6687e+01_r8,5.0599e+00_r8/)
      kbo(:, 2,16,11) = (/ &
     &2.0548e+02_r8,1.5423e+02_r8,1.0297e+02_r8,5.1715e+01_r8,4.9736e+00_r8/)
      kbo(:, 3,16,11) = (/ &
     &2.7637e+02_r8,2.0739e+02_r8,1.3841e+02_r8,6.9439e+01_r8,4.8882e+00_r8/)
      kbo(:, 4,16,11) = (/ &
     &3.5789e+02_r8,2.6854e+02_r8,1.7918e+02_r8,8.9827e+01_r8,4.8052e+00_r8/)
      kbo(:, 5,16,11) = (/ &
     &4.4907e+02_r8,3.3692e+02_r8,2.2477e+02_r8,1.1262e+02_r8,4.7153e+00_r8/)
      kbo(:, 1,17,11) = (/ &
     &1.0823e+02_r8,8.1288e+01_r8,5.4344e+01_r8,2.7412e+01_r8,5.5645e+00_r8/)
      kbo(:, 2,17,11) = (/ &
     &1.5200e+02_r8,1.1412e+02_r8,7.6233e+01_r8,3.8355e+01_r8,5.4748e+00_r8/)
      kbo(:, 3,17,11) = (/ &
     &2.0403e+02_r8,1.5314e+02_r8,1.0225e+02_r8,5.1364e+01_r8,5.3859e+00_r8/)
      kbo(:, 4,17,11) = (/ &
     &2.6361e+02_r8,1.9782e+02_r8,1.3204e+02_r8,6.6255e+01_r8,5.2931e+00_r8/)
      kbo(:, 5,17,11) = (/ &
     &3.3009e+02_r8,2.4768e+02_r8,1.6528e+02_r8,8.2867e+01_r8,5.1961e+00_r8/)
      kbo(:, 1,18,11) = (/ &
     &8.1232e+01_r8,6.1036e+01_r8,4.0843e+01_r8,2.0768e+01_r8,6.0688e+00_r8/)
      kbo(:, 2,18,11) = (/ &
     &1.1380e+02_r8,8.5466e+01_r8,5.7129e+01_r8,2.8802e+01_r8,5.9719e+00_r8/)
      kbo(:, 3,18,11) = (/ &
     &1.5225e+02_r8,1.1430e+02_r8,7.6349e+01_r8,3.8404e+01_r8,5.8780e+00_r8/)
      kbo(:, 4,18,11) = (/ &
     &1.9624e+02_r8,1.4729e+02_r8,9.8340e+01_r8,4.9394e+01_r8,5.7787e+00_r8/)
      kbo(:, 5,18,11) = (/ &
     &2.4493e+02_r8,1.8381e+02_r8,1.2268e+02_r8,6.1561e+01_r8,5.6709e+00_r8/)
      kbo(:, 1,19,11) = (/ &
     &5.9301e+01_r8,4.4585e+01_r8,2.9875e+01_r8,1.6238e+01_r8,6.5385e+00_r8/)
      kbo(:, 2,19,11) = (/ &
     &8.2717e+01_r8,6.2145e+01_r8,4.1575e+01_r8,2.1335e+01_r8,6.4509e+00_r8/)
      kbo(:, 3,19,11) = (/ &
     &1.1031e+02_r8,8.2837e+01_r8,5.5366e+01_r8,2.7948e+01_r8,6.3522e+00_r8/)
      kbo(:, 4,19,11) = (/ &
     &1.4167e+02_r8,1.0635e+02_r8,7.1041e+01_r8,3.5737e+01_r8,6.2392e+00_r8/)
      kbo(:, 5,19,11) = (/ &
     &1.7630e+02_r8,1.3232e+02_r8,8.8349e+01_r8,4.4378e+01_r8,6.1191e+00_r8/)
      kbo(:, 1,20,11) = (/ &
     &4.6675e+01_r8,3.5111e+01_r8,2.3575e+01_r8,1.4266e+01_r8,6.9620e+00_r8/)
      kbo(:, 2,20,11) = (/ &
     &6.4787e+01_r8,4.8692e+01_r8,3.2603e+01_r8,1.7833e+01_r8,6.8738e+00_r8/)
      kbo(:, 3,20,11) = (/ &
     &8.5965e+01_r8,6.4574e+01_r8,4.3185e+01_r8,2.2381e+01_r8,6.7710e+00_r8/)
      kbo(:, 4,20,11) = (/ &
     &1.0993e+02_r8,8.2545e+01_r8,5.5164e+01_r8,2.7968e+01_r8,6.6598e+00_r8/)
      kbo(:, 5,20,11) = (/ &
     &1.3666e+02_r8,1.0259e+02_r8,6.8531e+01_r8,3.4499e+01_r8,6.5455e+00_r8/)
      kbo(:, 1,21,11) = (/ &
     &3.7501e+01_r8,2.8227e+01_r8,1.9281e+01_r8,1.3115e+01_r8,7.3104e+00_r8/)
      kbo(:, 2,21,11) = (/ &
     &5.1743e+01_r8,3.8905e+01_r8,2.6108e+01_r8,1.5684e+01_r8,7.2251e+00_r8/)
      kbo(:, 3,21,11) = (/ &
     &6.8349e+01_r8,5.1361e+01_r8,3.4375e+01_r8,1.9019e+01_r8,7.1334e+00_r8/)
      kbo(:, 4,21,11) = (/ &
     &8.7361e+01_r8,6.5620e+01_r8,4.3882e+01_r8,2.3034e+01_r8,7.0346e+00_r8/)
      kbo(:, 5,21,11) = (/ &
     &1.0904e+02_r8,8.1880e+01_r8,5.4724e+01_r8,2.7964e+01_r8,6.9286e+00_r8/)
      kbo(:, 1,22,11) = (/ &
     &3.1289e+01_r8,2.3566e+01_r8,1.6825e+01_r8,1.2828e+01_r8,7.5760e+00_r8/)
      kbo(:, 2,22,11) = (/ &
     &4.2825e+01_r8,3.2216e+01_r8,2.1971e+01_r8,1.4588e+01_r8,7.5079e+00_r8/)
      kbo(:, 3,22,11) = (/ &
     &5.6403e+01_r8,4.2401e+01_r8,2.8462e+01_r8,1.6984e+01_r8,7.4270e+00_r8/)
      kbo(:, 4,22,11) = (/ &
     &7.2294e+01_r8,5.4320e+01_r8,3.6353e+01_r8,2.0165e+01_r8,7.3380e+00_r8/)
      kbo(:, 5,22,11) = (/ &
     &9.0391e+01_r8,6.7890e+01_r8,4.5398e+01_r8,2.4037e+01_r8,7.2398e+00_r8/)
      kbo(:, 1,23,11) = (/ &
     &2.6113e+01_r8,1.9694e+01_r8,1.4984e+01_r8,1.2807e+01_r8,7.7662e+00_r8/)
      kbo(:, 2,23,11) = (/ &
     &3.5611e+01_r8,2.6805e+01_r8,1.8996e+01_r8,1.4145e+01_r8,7.7141e+00_r8/)
      kbo(:, 3,23,11) = (/ &
     &4.7007e+01_r8,3.5353e+01_r8,2.4112e+01_r8,1.5803e+01_r8,7.6529e+00_r8/)
      kbo(:, 4,23,11) = (/ &
     &6.0260e+01_r8,4.5296e+01_r8,3.0446e+01_r8,1.8119e+01_r8,7.5779e+00_r8/)
      kbo(:, 5,23,11) = (/ &
     &7.5402e+01_r8,5.6642e+01_r8,3.7917e+01_r8,2.1118e+01_r8,7.4889e+00_r8/)
      kbo(:, 1,24,11) = (/ &
     &2.1744e+01_r8,1.6531e+01_r8,1.3667e+01_r8,1.2705e+01_r8,7.8734e+00_r8/)
      kbo(:, 2,24,11) = (/ &
     &2.9665e+01_r8,2.2353e+01_r8,1.6710e+01_r8,1.3918e+01_r8,7.8466e+00_r8/)
      kbo(:, 3,24,11) = (/ &
     &3.9143e+01_r8,2.9459e+01_r8,2.0787e+01_r8,1.5226e+01_r8,7.8065e+00_r8/)
      kbo(:, 4,24,11) = (/ &
     &5.0222e+01_r8,3.7761e+01_r8,2.5773e+01_r8,1.6824e+01_r8,7.7511e+00_r8/)
      kbo(:, 5,24,11) = (/ &
     &6.2928e+01_r8,4.7282e+01_r8,3.1824e+01_r8,1.8958e+01_r8,7.6816e+00_r8/)
      kbo(:, 1,25,11) = (/ &
     &1.8556e+01_r8,1.4391e+01_r8,1.2986e+01_r8,1.2542e+01_r8,7.9223e+00_r8/)
      kbo(:, 2,25,11) = (/ &
     &2.5288e+01_r8,1.9166e+01_r8,1.5272e+01_r8,1.3696e+01_r8,7.9207e+00_r8/)
      kbo(:, 3,25,11) = (/ &
     &3.3328e+01_r8,2.5101e+01_r8,1.8448e+01_r8,1.4913e+01_r8,7.9039e+00_r8/)
      kbo(:, 4,25,11) = (/ &
     &4.2799e+01_r8,3.2187e+01_r8,2.2557e+01_r8,1.6216e+01_r8,7.8725e+00_r8/)
      kbo(:, 5,25,11) = (/ &
     &5.3844e+01_r8,4.0473e+01_r8,2.7585e+01_r8,1.7777e+01_r8,7.8216e+00_r8/)
      kbo(:, 1,26,11) = (/ &
     &1.6321e+01_r8,1.3012e+01_r8,1.2671e+01_r8,1.2389e+01_r8,7.9293e+00_r8/)
      kbo(:, 2,26,11) = (/ &
     &2.2176e+01_r8,1.7013e+01_r8,1.4541e+01_r8,1.3492e+01_r8,7.9549e+00_r8/)
      kbo(:, 3,26,11) = (/ &
     &2.9236e+01_r8,2.2092e+01_r8,1.7014e+01_r8,1.4647e+01_r8,7.9628e+00_r8/)
      kbo(:, 4,26,11) = (/ &
     &3.7703e+01_r8,2.8378e+01_r8,2.0439e+01_r8,1.5868e+01_r8,7.9537e+00_r8/)
      kbo(:, 5,26,11) = (/ &
     &4.7623e+01_r8,3.5826e+01_r8,2.4857e+01_r8,1.7188e+01_r8,7.9177e+00_r8/)
      kbo(:, 1,27,11) = (/ &
     &1.5028e+01_r8,1.2264e+01_r8,1.2582e+01_r8,1.2313e+01_r8,7.9116e+00_r8/)
      kbo(:, 2,27,11) = (/ &
     &2.0393e+01_r8,1.5855e+01_r8,1.4339e+01_r8,1.3407e+01_r8,7.9620e+00_r8/)
      kbo(:, 3,27,11) = (/ &
     &2.6998e+01_r8,2.0503e+01_r8,1.6441e+01_r8,1.4550e+01_r8,7.9958e+00_r8/)
      kbo(:, 4,27,11) = (/ &
     &3.4948e+01_r8,2.6342e+01_r8,1.9460e+01_r8,1.5757e+01_r8,8.0119e+00_r8/)
      kbo(:, 5,27,11) = (/ &
     &4.4164e+01_r8,3.3250e+01_r8,2.3464e+01_r8,1.7068e+01_r8,7.9872e+00_r8/)
      kbo(:, 1,28,11) = (/ &
     &1.4343e+01_r8,1.1935e+01_r8,1.2606e+01_r8,1.2286e+01_r8,7.8708e+00_r8/)
      kbo(:, 2,28,11) = (/ &
     &1.9534e+01_r8,1.5338e+01_r8,1.4333e+01_r8,1.3405e+01_r8,7.9546e+00_r8/)
      kbo(:, 3,28,11) = (/ &
     &2.5909e+01_r8,1.9792e+01_r8,1.6354e+01_r8,1.4575e+01_r8,8.0164e+00_r8/)
      kbo(:, 4,28,11) = (/ &
     &3.3450e+01_r8,2.5271e+01_r8,1.9104e+01_r8,1.5810e+01_r8,8.0394e+00_r8/)
      kbo(:, 5,28,11) = (/ &
     &4.2201e+01_r8,3.1789e+01_r8,2.2776e+01_r8,1.7191e+01_r8,8.0384e+00_r8/)
      kbo(:, 1,29,11) = (/ &
     &1.4799e+01_r8,1.2334e+01_r8,1.2951e+01_r8,1.2470e+01_r8,7.8248e+00_r8/)
      kbo(:, 2,29,11) = (/ &
     &2.0134e+01_r8,1.5845e+01_r8,1.4778e+01_r8,1.3682e+01_r8,7.9390e+00_r8/)
      kbo(:, 3,29,11) = (/ &
     &2.6563e+01_r8,2.0336e+01_r8,1.6926e+01_r8,1.4933e+01_r8,8.0194e+00_r8/)
      kbo(:, 4,29,11) = (/ &
     &3.4143e+01_r8,2.5818e+01_r8,1.9648e+01_r8,1.6307e+01_r8,8.0590e+00_r8/)
      kbo(:, 5,29,11) = (/ &
     &4.2969e+01_r8,3.2368e+01_r8,2.3282e+01_r8,1.7794e+01_r8,8.0931e+00_r8/)
      kbo(:, 1,30,11) = (/ &
     &1.5772e+01_r8,1.3097e+01_r8,1.3464e+01_r8,1.2783e+01_r8,7.7812e+00_r8/)
      kbo(:, 2,30,11) = (/ &
     &2.1344e+01_r8,1.6785e+01_r8,1.5505e+01_r8,1.4108e+01_r8,7.9232e+00_r8/)
      kbo(:, 3,30,11) = (/ &
     &2.7999e+01_r8,2.1429e+01_r8,1.7759e+01_r8,1.5492e+01_r8,8.0114e+00_r8/)
      kbo(:, 4,30,11) = (/ &
     &3.5848e+01_r8,2.7096e+01_r8,2.0562e+01_r8,1.7031e+01_r8,8.0836e+00_r8/)
      kbo(:, 5,30,11) = (/ &
     &4.5004e+01_r8,3.3889e+01_r8,2.4347e+01_r8,1.8589e+01_r8,8.1429e+00_r8/)
      kbo(:, 1,31,11) = (/ &
     &1.7716e+01_r8,1.4511e+01_r8,1.4478e+01_r8,1.3396e+01_r8,7.7478e+00_r8/)
      kbo(:, 2,31,11) = (/ &
     &2.3853e+01_r8,1.8632e+01_r8,1.6766e+01_r8,1.4874e+01_r8,7.8974e+00_r8/)
      kbo(:, 3,31,11) = (/ &
     &3.1182e+01_r8,2.3768e+01_r8,1.9223e+01_r8,1.6499e+01_r8,8.0055e+00_r8/)
      kbo(:, 4,31,11) = (/ &
     &3.9834e+01_r8,3.0054e+01_r8,2.2404e+01_r8,1.8165e+01_r8,8.1138e+00_r8/)
      kbo(:, 5,31,11) = (/ &
     &4.9938e+01_r8,3.7588e+01_r8,2.6690e+01_r8,1.9788e+01_r8,8.1481e+00_r8/)
      kbo(:, 1,32,11) = (/ &
     &2.0151e+01_r8,1.6250e+01_r8,1.5786e+01_r8,1.4153e+01_r8,7.7024e+00_r8/)
      kbo(:, 2,32,11) = (/ &
     &2.7022e+01_r8,2.0930e+01_r8,1.8243e+01_r8,1.5874e+01_r8,7.8766e+00_r8/)
      kbo(:, 3,32,11) = (/ &
     &3.5292e+01_r8,2.6776e+01_r8,2.1045e+01_r8,1.7666e+01_r8,8.0370e+00_r8/)
      kbo(:, 4,32,11) = (/ &
     &4.5050e+01_r8,3.3940e+01_r8,2.4811e+01_r8,1.9434e+01_r8,8.1312e+00_r8/)
      kbo(:, 5,32,11) = (/ &
     &5.6497e+01_r8,4.2506e+01_r8,2.9790e+01_r8,2.1188e+01_r8,8.1409e+00_r8/)
      kbo(:, 1,33,11) = (/ &
     &2.3401e+01_r8,1.8533e+01_r8,1.7371e+01_r8,1.5193e+01_r8,7.6839e+00_r8/)
      kbo(:, 2,33,11) = (/ &
     &3.1308e+01_r8,2.4009e+01_r8,2.0094e+01_r8,1.7155e+01_r8,7.9059e+00_r8/)
      kbo(:, 3,33,11) = (/ &
     &4.0829e+01_r8,3.0856e+01_r8,2.3455e+01_r8,1.9076e+01_r8,8.0587e+00_r8/)
      kbo(:, 4,33,11) = (/ &
     &5.2189e+01_r8,3.9272e+01_r8,2.8099e+01_r8,2.1008e+01_r8,8.1274e+00_r8/)
      kbo(:, 5,33,11) = (/ &
     &6.5586e+01_r8,4.9320e+01_r8,3.4075e+01_r8,2.2993e+01_r8,8.2027e+00_r8/)
      kbo(:, 1,34,11) = (/ &
     &2.6313e+01_r8,2.0607e+01_r8,1.8746e+01_r8,1.6201e+01_r8,7.7021e+00_r8/)
      kbo(:, 2,34,11) = (/ &
     &3.5155e+01_r8,2.6805e+01_r8,2.1758e+01_r8,1.8283e+01_r8,7.9397e+00_r8/)
      kbo(:, 3,34,11) = (/ &
     &4.5927e+01_r8,3.4632e+01_r8,2.5705e+01_r8,2.0353e+01_r8,8.0605e+00_r8/)
      kbo(:, 4,34,11) = (/ &
     &5.8835e+01_r8,4.4252e+01_r8,3.1197e+01_r8,2.2458e+01_r8,8.1311e+00_r8/)
      kbo(:, 5,34,11) = (/ &
     &7.4250e+01_r8,5.5815e+01_r8,3.8184e+01_r8,2.4701e+01_r8,8.2150e+00_r8/)
      kbo(:, 1,35,11) = (/ &
     &2.8876e+01_r8,2.2455e+01_r8,1.9946e+01_r8,1.7124e+01_r8,7.7224e+00_r8/)
      kbo(:, 2,35,11) = (/ &
     &3.8715e+01_r8,2.9405e+01_r8,2.3284e+01_r8,1.9326e+01_r8,7.9252e+00_r8/)
      kbo(:, 3,35,11) = (/ &
     &5.0778e+01_r8,3.8237e+01_r8,2.7902e+01_r8,2.1577e+01_r8,8.0258e+00_r8/)
      kbo(:, 4,35,11) = (/ &
     &6.5355e+01_r8,4.9140e+01_r8,3.4259e+01_r8,2.3860e+01_r8,8.1543e+00_r8/)
      kbo(:, 5,35,11) = (/ &
     &8.3003e+01_r8,6.2372e+01_r8,4.2365e+01_r8,2.6463e+01_r8,8.1938e+00_r8/)
      kbo(:, 1,36,11) = (/ &
     &3.0603e+01_r8,2.3731e+01_r8,2.0817e+01_r8,1.7816e+01_r8,7.6876e+00_r8/)
      kbo(:, 2,36,11) = (/ &
     &4.1304e+01_r8,3.1313e+01_r8,2.4462e+01_r8,2.0172e+01_r8,7.8715e+00_r8/)
      kbo(:, 3,36,11) = (/ &
     &5.4533e+01_r8,4.1035e+01_r8,2.9662e+01_r8,2.2576e+01_r8,7.9878e+00_r8/)
      kbo(:, 4,36,11) = (/ &
     &7.0736e+01_r8,5.3175e+01_r8,3.6832e+01_r8,2.5052e+01_r8,8.1404e+00_r8/)
      kbo(:, 5,36,11) = (/ &
     &9.0535e+01_r8,6.8017e+01_r8,4.6007e+01_r8,2.8044e+01_r8,8.2152e+00_r8/)
      kbo(:, 1,37,11) = (/ &
     &3.0255e+01_r8,2.3559e+01_r8,2.0925e+01_r8,1.7969e+01_r8,7.6093e+00_r8/)
      kbo(:, 2,37,11) = (/ &
     &4.1246e+01_r8,3.1319e+01_r8,2.4672e+01_r8,2.0442e+01_r8,7.8000e+00_r8/)
      kbo(:, 3,37,11) = (/ &
     &5.5008e+01_r8,4.1404e+01_r8,3.0029e+01_r8,2.2965e+01_r8,7.9652e+00_r8/)
      kbo(:, 4,37,11) = (/ &
     &7.2100e+01_r8,5.4198e+01_r8,3.7564e+01_r8,2.5602e+01_r8,8.1174e+00_r8/)
      kbo(:, 5,37,11) = (/ &
     &9.3252e+01_r8,7.0052e+01_r8,4.7363e+01_r8,2.8813e+01_r8,8.2379e+00_r8/)
      kbo(:, 1,38,11) = (/ &
     &3.0319e+01_r8,2.3676e+01_r8,2.1203e+01_r8,1.8223e+01_r8,7.5198e+00_r8/)
      kbo(:, 2,38,11) = (/ &
     &4.1784e+01_r8,3.1741e+01_r8,2.5125e+01_r8,2.0837e+01_r8,7.7243e+00_r8/)
      kbo(:, 3,38,11) = (/ &
     &5.6316e+01_r8,4.2385e+01_r8,3.0775e+01_r8,2.3517e+01_r8,7.9363e+00_r8/)
      kbo(:, 4,38,11) = (/ &
     &7.4582e+01_r8,5.6053e+01_r8,3.8823e+01_r8,2.6361e+01_r8,8.1242e+00_r8/)
      kbo(:, 5,38,11) = (/ &
     &9.7510e+01_r8,7.3243e+01_r8,4.9498e+01_r8,2.9889e+01_r8,8.2559e+00_r8/)
      kbo(:, 1,39,11) = (/ &
     &3.1111e+01_r8,2.4293e+01_r8,2.1786e+01_r8,1.8666e+01_r8,7.4239e+00_r8/)
      kbo(:, 2,39,11) = (/ &
     &4.3408e+01_r8,3.2962e+01_r8,2.6016e+01_r8,2.1461e+01_r8,7.6345e+00_r8/)
      kbo(:, 3,39,11) = (/ &
     &5.9150e+01_r8,4.4506e+01_r8,3.2172e+01_r8,2.4357e+01_r8,7.9192e+00_r8/)
      kbo(:, 4,39,11) = (/ &
     &7.9245e+01_r8,5.9549e+01_r8,4.1085e+01_r8,2.7494e+01_r8,8.1496e+00_r8/)
      kbo(:, 5,39,11) = (/ &
     &1.0467e+02_r8,7.8610e+01_r8,5.2990e+01_r8,3.1523e+01_r8,8.2789e+00_r8/)
      kbo(:, 1,40,11) = (/ &
     &2.8917e+01_r8,2.2849e+01_r8,2.1212e+01_r8,1.8303e+01_r8,7.3082e+00_r8/)
      kbo(:, 2,40,11) = (/ &
     &4.0995e+01_r8,3.1270e+01_r8,2.5375e+01_r8,2.1193e+01_r8,7.5582e+00_r8/)
      kbo(:, 3,40,11) = (/ &
     &5.6673e+01_r8,4.2684e+01_r8,3.1298e+01_r8,2.4183e+01_r8,7.8695e+00_r8/)
      kbo(:, 4,40,11) = (/ &
     &7.6946e+01_r8,5.7826e+01_r8,4.0125e+01_r8,2.7426e+01_r8,8.1312e+00_r8/)
      kbo(:, 5,40,11) = (/ &
     &1.0293e+02_r8,7.7305e+01_r8,5.2205e+01_r8,3.1496e+01_r8,8.2689e+00_r8/)
      kbo(:, 1,41,11) = (/ &
     &2.6634e+01_r8,2.1385e+01_r8,2.0561e+01_r8,1.7885e+01_r8,7.1901e+00_r8/)
      kbo(:, 2,41,11) = (/ &
     &3.8375e+01_r8,2.9451e+01_r8,2.4682e+01_r8,2.0867e+01_r8,7.4740e+00_r8/)
      kbo(:, 3,41,11) = (/ &
     &5.3928e+01_r8,4.0671e+01_r8,3.0356e+01_r8,2.3955e+01_r8,7.8182e+00_r8/)
      kbo(:, 4,41,11) = (/ &
     &7.4310e+01_r8,5.5850e+01_r8,3.9033e+01_r8,2.7309e+01_r8,8.0950e+00_r8/)
      kbo(:, 5,41,11) = (/ &
     &1.0067e+02_r8,7.5610e+01_r8,5.1206e+01_r8,3.1414e+01_r8,8.2644e+00_r8/)
      kbo(:, 1,42,11) = (/ &
     &2.4738e+01_r8,2.0233e+01_r8,2.0020e+01_r8,1.7547e+01_r8,7.0619e+00_r8/)
      kbo(:, 2,42,11) = (/ &
     &3.6234e+01_r8,2.7982e+01_r8,2.4175e+01_r8,2.0637e+01_r8,7.4025e+00_r8/)
      kbo(:, 3,42,11) = (/ &
     &5.1779e+01_r8,3.9115e+01_r8,2.9714e+01_r8,2.3853e+01_r8,7.7568e+00_r8/)
      kbo(:, 4,42,11) = (/ &
     &7.2527e+01_r8,5.4511e+01_r8,3.8357e+01_r8,2.7357e+01_r8,8.0593e+00_r8/)
      kbo(:, 5,42,11) = (/ &
     &9.9602e+01_r8,7.4807e+01_r8,5.0774e+01_r8,3.1579e+01_r8,8.2618e+00_r8/)
      kbo(:, 1,43,11) = (/ &
     &2.2598e+01_r8,1.8979e+01_r8,1.9339e+01_r8,1.7092e+01_r8,6.9063e+00_r8/)
      kbo(:, 2,43,11) = (/ &
     &3.3721e+01_r8,2.6289e+01_r8,2.3541e+01_r8,2.0300e+01_r8,7.2922e+00_r8/)
      kbo(:, 3,43,11) = (/ &
     &4.9059e+01_r8,3.7168e+01_r8,2.8920e+01_r8,2.3665e+01_r8,7.6599e+00_r8/)
      kbo(:, 4,43,11) = (/ &
     &6.9947e+01_r8,5.2582e+01_r8,3.7401e+01_r8,2.7324e+01_r8,7.9953e+00_r8/)
      kbo(:, 5,43,11) = (/ &
     &9.7637e+01_r8,7.3334e+01_r8,4.9954e+01_r8,3.1634e+01_r8,8.2449e+00_r8/)
      kbo(:, 1,44,11) = (/ &
     &2.0598e+01_r8,1.7877e+01_r8,1.8670e+01_r8,1.6634e+01_r8,6.7349e+00_r8/)
      kbo(:, 2,44,11) = (/ &
     &3.1385e+01_r8,2.4755e+01_r8,2.2973e+01_r8,1.9973e+01_r8,7.1646e+00_r8/)
      kbo(:, 3,44,11) = (/ &
     &4.6533e+01_r8,3.5381e+01_r8,2.8231e+01_r8,2.3518e+01_r8,7.5534e+00_r8/)
      kbo(:, 4,44,11) = (/ &
     &6.7572e+01_r8,5.0818e+01_r8,3.6582e+01_r8,2.7361e+01_r8,7.9184e+00_r8/)
      kbo(:, 5,44,11) = (/ &
     &9.6116e+01_r8,7.2195e+01_r8,4.9367e+01_r8,3.1819e+01_r8,8.2107e+00_r8/)
      kbo(:, 1,45,11) = (/ &
     &1.9103e+01_r8,1.7116e+01_r8,1.8163e+01_r8,1.6283e+01_r8,6.5605e+00_r8/)
      kbo(:, 2,45,11) = (/ &
     &2.9658e+01_r8,2.3682e+01_r8,2.2618e+01_r8,1.9789e+01_r8,7.0239e+00_r8/)
      kbo(:, 3,45,11) = (/ &
     &4.4853e+01_r8,3.4227e+01_r8,2.7909e+01_r8,2.3555e+01_r8,7.4383e+00_r8/)
      kbo(:, 4,45,11) = (/ &
     &6.6390e+01_r8,4.9954e+01_r8,3.6314e+01_r8,2.7640e+01_r8,7.8580e+00_r8/)
      kbo(:, 5,45,11) = (/ &
     &9.6230e+01_r8,7.2282e+01_r8,4.9573e+01_r8,3.2349e+01_r8,8.1505e+00_r8/)
      kbo(:, 1,46,11) = (/ &
     &1.7603e+01_r8,1.6408e+01_r8,1.7601e+01_r8,1.5877e+01_r8,6.3549e+00_r8/)
      kbo(:, 2,46,11) = (/ &
     &2.7890e+01_r8,2.2645e+01_r8,2.2217e+01_r8,1.9546e+01_r8,6.8535e+00_r8/)
      kbo(:, 3,46,11) = (/ &
     &4.3095e+01_r8,3.3035e+01_r8,2.7597e+01_r8,2.3556e+01_r8,7.2985e+00_r8/)
      kbo(:, 4,46,11) = (/ &
     &6.5080e+01_r8,4.9001e+01_r8,3.6011e+01_r8,2.7911e+01_r8,7.7668e+00_r8/)
      kbo(:, 5,46,11) = (/ &
     &9.6111e+01_r8,7.2194e+01_r8,4.9702e+01_r8,3.2895e+01_r8,8.0887e+00_r8/)
      kbo(:, 1,47,11) = (/ &
     &1.5582e+01_r8,1.5416e+01_r8,1.6712e+01_r8,1.5202e+01_r8,6.1058e+00_r8/)
      kbo(:, 2,47,11) = (/ &
     &2.5371e+01_r8,2.1144e+01_r8,2.1438e+01_r8,1.8984e+01_r8,6.6529e+00_r8/)
      kbo(:, 3,47,11) = (/ &
     &4.0058e+01_r8,3.0957e+01_r8,2.6834e+01_r8,2.3189e+01_r8,7.1345e+00_r8/)
      kbo(:, 4,47,11) = (/ &
     &6.1807e+01_r8,4.6615e+01_r8,3.4933e+01_r8,2.7758e+01_r8,7.6397e+00_r8/)
      kbo(:, 5,47,11) = (/ &
     &9.3127e+01_r8,6.9962e+01_r8,4.8499e+01_r8,3.2952e+01_r8,7.9851e+00_r8/)
      kbo(:, 1,48,11) = (/ &
     &1.4034e+01_r8,1.4681e+01_r8,1.5989e+01_r8,1.4629e+01_r8,5.8421e+00_r8/)
      kbo(:, 2,48,11) = (/ &
     &2.3558e+01_r8,2.0186e+01_r8,2.0890e+01_r8,1.8564e+01_r8,6.4412e+00_r8/)
      kbo(:, 3,48,11) = (/ &
     &3.8004e+01_r8,2.9609e+01_r8,2.6472e+01_r8,2.3010e+01_r8,6.9605e+00_r8/)
      kbo(:, 4,48,11) = (/ &
     &5.9949e+01_r8,4.5296e+01_r8,3.4518e+01_r8,2.7885e+01_r8,7.5000e+00_r8/)
      kbo(:, 5,48,11) = (/ &
     &9.2277e+01_r8,6.9322e+01_r8,4.8288e+01_r8,3.3402e+01_r8,7.8874e+00_r8/)
      kbo(:, 1,49,11) = (/ &
     &1.3020e+01_r8,1.4223e+01_r8,1.5508e+01_r8,1.4222e+01_r8,5.5629e+00_r8/)
      kbo(:, 2,49,11) = (/ &
     &2.2531e+01_r8,1.9765e+01_r8,2.0674e+01_r8,1.8360e+01_r8,6.2033e+00_r8/)
      kbo(:, 3,49,11) = (/ &
     &3.7326e+01_r8,2.9255e+01_r8,2.6622e+01_r8,2.3133e+01_r8,6.7696e+00_r8/)
      kbo(:, 4,49,11) = (/ &
     &6.0141e+01_r8,4.5507e+01_r8,3.5009e+01_r8,2.8438e+01_r8,7.3484e+00_r8/)
      kbo(:, 5,49,11) = (/ &
     &9.4669e+01_r8,7.1125e+01_r8,4.9613e+01_r8,3.4451e+01_r8,7.7676e+00_r8/)
      kbo(:, 1,50,11) = (/ &
     &1.1528e+01_r8,1.3385e+01_r8,1.4676e+01_r8,1.3553e+01_r8,5.2886e+00_r8/)
      kbo(:, 2,50,11) = (/ &
     &2.0590e+01_r8,1.8779e+01_r8,1.9954e+01_r8,1.7785e+01_r8,5.9683e+00_r8/)
      kbo(:, 3,50,11) = (/ &
     &3.5112e+01_r8,2.7878e+01_r8,2.6128e+01_r8,2.2750e+01_r8,6.5812e+00_r8/)
      kbo(:, 4,50,11) = (/ &
     &5.7821e+01_r8,4.3871e+01_r8,3.4428e+01_r8,2.8358e+01_r8,7.1800e+00_r8/)
      kbo(:, 5,50,11) = (/ &
     &9.2920e+01_r8,6.9817e+01_r8,4.9041e+01_r8,3.4691e+01_r8,7.6346e+00_r8/)
      kbo(:, 1,51,11) = (/ &
     &9.9087e+00_r8,1.2389e+01_r8,1.3702e+01_r8,1.2771e+01_r8,5.0110e+00_r8/)
      kbo(:, 2,51,11) = (/ &
     &1.8347e+01_r8,1.7625e+01_r8,1.8991e+01_r8,1.7018e+01_r8,5.7321e+00_r8/)
      kbo(:, 3,51,11) = (/ &
     &3.2210e+01_r8,2.6119e+01_r8,2.5308e+01_r8,2.2105e+01_r8,6.3824e+00_r8/)
      kbo(:, 4,51,11) = (/ &
     &5.4374e+01_r8,4.1438e+01_r8,3.3397e+01_r8,2.7944e+01_r8,7.0038e+00_r8/)
      kbo(:, 5,51,11) = (/ &
     &8.9118e+01_r8,6.6984e+01_r8,4.7570e+01_r8,3.4540e+01_r8,7.4941e+00_r8/)
      kbo(:, 1,52,11) = (/ &
     &8.6167e+00_r8,1.1576e+01_r8,1.2899e+01_r8,1.2089e+01_r8,4.7245e+00_r8/)
      kbo(:, 2,52,11) = (/ &
     &1.6651e+01_r8,1.6818e+01_r8,1.8231e+01_r8,1.6395e+01_r8,5.4842e+00_r8/)
      kbo(:, 3,52,11) = (/ &
     &3.0138e+01_r8,2.4957e+01_r8,2.4762e+01_r8,2.1646e+01_r8,6.1679e+00_r8/)
      kbo(:, 4,52,11) = (/ &
     &5.2273e+01_r8,4.0011e+01_r8,3.2952e+01_r8,2.7789e+01_r8,6.8199e+00_r8/)
      kbo(:, 5,52,11) = (/ &
     &8.7481e+01_r8,6.5781e+01_r8,4.7111e+01_r8,3.4770e+01_r8,7.3415e+00_r8/)
      kbo(:, 1,53,11) = (/ &
     &7.6702e+00_r8,1.0979e+01_r8,1.2289e+01_r8,1.1530e+01_r8,4.4295e+00_r8/)
      kbo(:, 2,53,11) = (/ &
     &1.5508e+01_r8,1.6366e+01_r8,1.7771e+01_r8,1.5970e+01_r8,5.2253e+00_r8/)
      kbo(:, 3,53,11) = (/ &
     &2.9086e+01_r8,2.4490e+01_r8,2.4633e+01_r8,2.1484e+01_r8,5.9485e+00_r8/)
      kbo(:, 4,53,11) = (/ &
     &5.1881e+01_r8,3.9852e+01_r8,3.3235e+01_r8,2.8055e+01_r8,6.6238e+00_r8/)
      kbo(:, 5,53,11) = (/ &
     &8.8988e+01_r8,6.6930e+01_r8,4.8082e+01_r8,3.5589e+01_r8,7.1849e+00_r8/)
      kbo(:, 1,54,11) = (/ &
     &5.9450e+00_r8,9.6177e+00_r8,1.0972e+01_r8,1.0431e+01_r8,4.1455e+00_r8/)
      kbo(:, 2,54,11) = (/ &
     &1.2556e+01_r8,1.4668e+01_r8,1.6126e+01_r8,1.4708e+01_r8,4.9524e+00_r8/)
      kbo(:, 3,54,11) = (/ &
     &2.4491e+01_r8,2.1770e+01_r8,2.2780e+01_r8,2.0031e+01_r8,5.7134e+00_r8/)
      kbo(:, 4,54,11) = (/ &
     &4.4954e+01_r8,3.5031e+01_r8,3.0908e+01_r8,2.6515e+01_r8,6.4122e+00_r8/)
      kbo(:, 5,54,11) = (/ &
     &7.9027e+01_r8,5.9569e+01_r8,4.4065e+01_r8,3.4001e+01_r8,7.0090e+00_r8/)
      kbo(:, 1,55,11) = (/ &
     &4.1710e+00_r8,8.0225e+00_r8,9.3978e+00_r8,9.1226e+00_r8,3.8682e+00_r8/)
      kbo(:, 2,55,11) = (/ &
     &9.2293e+00_r8,1.2486e+01_r8,1.4001e+01_r8,1.3070e+01_r8,4.6969e+00_r8/)
      kbo(:, 3,55,11) = (/ &
     &1.8778e+01_r8,1.8456e+01_r8,2.0084e+01_r8,1.7971e+01_r8,5.4658e+00_r8/)
      kbo(:, 4,55,11) = (/ &
     &3.5574e+01_r8,2.8777e+01_r8,2.7568e+01_r8,2.4021e+01_r8,6.1617e+00_r8/)
      kbo(:, 5,55,11) = (/ &
     &6.4114e+01_r8,4.8674e+01_r8,3.8113e+01_r8,3.1115e+01_r8,6.8236e+00_r8/)
      kbo(:, 1,56,11) = (/ &
     &2.8728e+00_r8,6.6889e+00_r8,8.0328e+00_r8,7.9557e+00_r8,3.5989e+00_r8/)
      kbo(:, 2,56,11) = (/ &
     &6.6874e+00_r8,1.0605e+01_r8,1.2156e+01_r8,1.1597e+01_r8,4.4247e+00_r8/)
      kbo(:, 3,56,11) = (/ &
     &1.4226e+01_r8,1.5908e+01_r8,1.7667e+01_r8,1.6104e+01_r8,5.2042e+00_r8/)
      kbo(:, 4,56,11) = (/ &
     &2.7945e+01_r8,2.3989e+01_r8,2.4626e+01_r8,2.1735e+01_r8,5.9393e+00_r8/)
      kbo(:, 5,56,11) = (/ &
     &5.1707e+01_r8,3.9775e+01_r8,3.3431e+01_r8,2.8442e+01_r8,6.5979e+00_r8/)
      kbo(:, 1,57,11) = (/ &
     &1.9429e+00_r8,5.5686e+00_r8,6.8405e+00_r8,6.9151e+00_r8,3.3226e+00_r8/)
      kbo(:, 2,57,11) = (/ &
     &4.7724e+00_r8,8.9791e+00_r8,1.0545e+01_r8,1.0240e+01_r8,4.1527e+00_r8/)
      kbo(:, 3,57,11) = (/ &
     &1.0641e+01_r8,1.3735e+01_r8,1.5504e+01_r8,1.4420e+01_r8,4.9657e+00_r8/)
      kbo(:, 4,57,11) = (/ &
     &2.1776e+01_r8,2.0320e+01_r8,2.1929e+01_r8,1.9615e+01_r8,5.6966e+00_r8/)
      kbo(:, 5,57,11) = (/ &
     &4.1383e+01_r8,3.2617e+01_r8,2.9771e+01_r8,2.5932e+01_r8,6.3597e+00_r8/)
      kbo(:, 1,58,11) = (/ &
     &3.4498e-01_r8,1.5267e+00_r8,2.4690e+00_r8,3.5849e+00_r8,3.0713e+00_r8/)
      kbo(:, 2,58,11) = (/ &
     &8.9647e-01_r8,2.5018e+00_r8,3.8790e+00_r8,5.3697e+00_r8,3.9024e+00_r8/)
      kbo(:, 3,58,11) = (/ &
     &2.0963e+00_r8,3.8966e+00_r8,5.7628e+00_r8,7.6647e+00_r8,4.7137e+00_r8/)
      kbo(:, 4,58,11) = (/ &
     &4.4774e+00_r8,5.7497e+00_r8,8.2495e+00_r8,1.0504e+01_r8,5.4718e+00_r8/)
      kbo(:, 5,58,11) = (/ &
     &8.7673e+00_r8,8.8663e+00_r8,1.1318e+01_r8,1.3996e+01_r8,6.1538e+00_r8/)
      kbo(:, 1,59,11) = (/ &
     &3.2685e-01_r8,1.8752e+00_r8,2.9232e+00_r8,3.9328e+00_r8,2.9672e+00_r8/)
      kbo(:, 2,59,11) = (/ &
     &8.8018e-01_r8,3.0635e+00_r8,4.5809e+00_r8,5.8034e+00_r8,3.8049e+00_r8/)
      kbo(:, 3,59,11) = (/ &
     &2.1278e+00_r8,4.7401e+00_r8,6.7591e+00_r8,8.2573e+00_r8,4.6076e+00_r8/)
      kbo(:, 4,59,11) = (/ &
     &4.6712e+00_r8,6.9756e+00_r8,9.6079e+00_r8,1.1224e+01_r8,5.3733e+00_r8/)
      kbo(:, 5,59,11) = (/ &
     &9.3271e+00_r8,1.0056e+01_r8,1.3155e+01_r8,1.4840e+01_r8,6.0503e+00_r8/)
      kbo(:, 1,13,12) = (/ &
     &7.5516e+02_r8,5.6651e+02_r8,3.7786e+02_r8,1.8921e+02_r8,4.6057e+00_r8/)
      kbo(:, 2,13,12) = (/ &
     &1.1031e+03_r8,8.2746e+02_r8,5.5183e+02_r8,2.7620e+02_r8,4.4752e+00_r8/)
      kbo(:, 3,13,12) = (/ &
     &1.5208e+03_r8,1.1407e+03_r8,7.6067e+02_r8,3.8062e+02_r8,4.3357e+00_r8/)
      kbo(:, 4,13,12) = (/ &
     &2.0072e+03_r8,1.5056e+03_r8,1.0039e+03_r8,5.0221e+02_r8,4.1960e+00_r8/)
      kbo(:, 5,13,12) = (/ &
     &2.5500e+03_r8,1.9126e+03_r8,1.2753e+03_r8,6.3790e+02_r8,4.0223e+00_r8/)
      kbo(:, 1,14,12) = (/ &
     &5.0313e+02_r8,3.7749e+02_r8,2.5185e+02_r8,1.2621e+02_r8,5.0046e+00_r8/)
      kbo(:, 2,14,12) = (/ &
     &7.2897e+02_r8,5.4687e+02_r8,3.6476e+02_r8,1.8266e+02_r8,4.8590e+00_r8/)
      kbo(:, 3,14,12) = (/ &
     &9.9893e+02_r8,7.4933e+02_r8,4.9972e+02_r8,2.5013e+02_r8,4.7095e+00_r8/)
      kbo(:, 4,14,12) = (/ &
     &1.3102e+03_r8,9.8276e+02_r8,6.5533e+02_r8,3.2791e+02_r8,4.5769e+00_r8/)
      kbo(:, 5,14,12) = (/ &
     &1.6551e+03_r8,1.2414e+03_r8,8.2775e+02_r8,4.1411e+02_r8,4.4631e+00_r8/)
      kbo(:, 1,15,12) = (/ &
     &3.3639e+02_r8,2.5243e+02_r8,1.6847e+02_r8,8.4507e+01_r8,5.4523e+00_r8/)
      kbo(:, 2,15,12) = (/ &
     &4.8280e+02_r8,3.6223e+02_r8,2.4166e+02_r8,1.2109e+02_r8,5.3133e+00_r8/)
      kbo(:, 3,15,12) = (/ &
     &6.5719e+02_r8,4.9302e+02_r8,3.2884e+02_r8,1.6466e+02_r8,5.1834e+00_r8/)
      kbo(:, 4,15,12) = (/ &
     &8.5550e+02_r8,6.4175e+02_r8,4.2799e+02_r8,2.1423e+02_r8,5.0660e+00_r8/)
      kbo(:, 5,15,12) = (/ &
     &1.0728e+03_r8,8.0472e+02_r8,5.3663e+02_r8,2.6854e+02_r8,4.9623e+00_r8/)
      kbo(:, 1,16,12) = (/ &
     &2.6229e+02_r8,1.9684e+02_r8,1.3139e+02_r8,6.5935e+01_r8,6.0512e+00_r8/)
      kbo(:, 2,16,12) = (/ &
     &3.7303e+02_r8,2.7989e+02_r8,1.8674e+02_r8,9.3604e+01_r8,5.9120e+00_r8/)
      kbo(:, 3,16,12) = (/ &
     &5.0297e+02_r8,3.7733e+02_r8,2.5170e+02_r8,1.2607e+02_r8,5.7872e+00_r8/)
      kbo(:, 4,16,12) = (/ &
     &6.4911e+02_r8,4.8694e+02_r8,3.2477e+02_r8,1.6260e+02_r8,5.6679e+00_r8/)
      kbo(:, 5,16,12) = (/ &
     &8.0986e+02_r8,6.0750e+02_r8,4.0515e+02_r8,2.0279e+02_r8,5.5547e+00_r8/)
      kbo(:, 1,17,12) = (/ &
     &2.0705e+02_r8,1.5540e+02_r8,1.0375e+02_r8,5.2106e+01_r8,6.7730e+00_r8/)
      kbo(:, 2,17,12) = (/ &
     &2.9135e+02_r8,2.1862e+02_r8,1.4589e+02_r8,7.3163e+01_r8,6.6333e+00_r8/)
      kbo(:, 3,17,12) = (/ &
     &3.8916e+02_r8,2.9197e+02_r8,1.9479e+02_r8,9.7603e+01_r8,6.4989e+00_r8/)
      kbo(:, 4,17,12) = (/ &
     &4.9976e+02_r8,3.7492e+02_r8,2.5009e+02_r8,1.2525e+02_r8,6.3687e+00_r8/)
      kbo(:, 5,17,12) = (/ &
     &6.2230e+02_r8,4.6683e+02_r8,3.1136e+02_r8,1.5589e+02_r8,6.2358e+00_r8/)
      kbo(:, 1,18,12) = (/ &
     &1.6333e+02_r8,1.2261e+02_r8,8.1888e+01_r8,4.1178e+01_r8,7.5424e+00_r8/)
      kbo(:, 2,18,12) = (/ &
     &2.2759e+02_r8,1.7080e+02_r8,1.1401e+02_r8,5.7226e+01_r8,7.4084e+00_r8/)
      kbo(:, 3,18,12) = (/ &
     &3.0244e+02_r8,2.2693e+02_r8,1.5143e+02_r8,7.5931e+01_r8,7.2669e+00_r8/)
      kbo(:, 4,18,12) = (/ &
     &3.8758e+02_r8,2.9079e+02_r8,1.9400e+02_r8,9.7216e+01_r8,7.1208e+00_r8/)
      kbo(:, 5,18,12) = (/ &
     &4.8269e+02_r8,3.6212e+02_r8,2.4155e+02_r8,1.2098e+02_r8,6.9720e+00_r8/)
      kbo(:, 1,19,12) = (/ &
     &1.2382e+02_r8,9.2977e+01_r8,6.2136e+01_r8,3.1325e+01_r8,8.3597e+00_r8/)
      kbo(:, 2,19,12) = (/ &
     &1.7154e+02_r8,1.2877e+02_r8,8.5994e+01_r8,4.3233e+01_r8,8.2061e+00_r8/)
      kbo(:, 3,19,12) = (/ &
     &2.2748e+02_r8,1.7072e+02_r8,1.1396e+02_r8,5.7206e+01_r8,8.0513e+00_r8/)
      kbo(:, 4,19,12) = (/ &
     &2.9138e+02_r8,2.1864e+02_r8,1.4590e+02_r8,7.3167e+01_r8,7.8994e+00_r8/)
      kbo(:, 5,19,12) = (/ &
     &3.6253e+02_r8,2.7200e+02_r8,1.8147e+02_r8,9.0939e+01_r8,7.7452e+00_r8/)
      kbo(:, 1,20,12) = (/ &
     &1.0042e+02_r8,7.5430e+01_r8,5.0444e+01_r8,2.5891e+01_r8,9.1675e+00_r8/)
      kbo(:, 2,20,12) = (/ &
     &1.3861e+02_r8,1.0407e+02_r8,6.9532e+01_r8,3.5031e+01_r8,9.0030e+00_r8/)
      kbo(:, 3,20,12) = (/ &
     &1.8351e+02_r8,1.3774e+02_r8,9.1975e+01_r8,4.6211e+01_r8,8.8390e+00_r8/)
      kbo(:, 4,20,12) = (/ &
     &2.3463e+02_r8,1.7607e+02_r8,1.1752e+02_r8,5.8971e+01_r8,8.6735e+00_r8/)
      kbo(:, 5,20,12) = (/ &
     &2.9128e+02_r8,2.1856e+02_r8,1.4583e+02_r8,7.3117e+01_r8,8.5016e+00_r8/)
      kbo(:, 1,21,12) = (/ &
     &8.3057e+01_r8,6.2407e+01_r8,4.1762e+01_r8,2.2683e+01_r8,9.9550e+00_r8/)
      kbo(:, 2,21,12) = (/ &
     &1.1435e+02_r8,8.5868e+01_r8,5.7394e+01_r8,2.9474e+01_r8,9.7863e+00_r8/)
      kbo(:, 3,21,12) = (/ &
     &1.5096e+02_r8,1.1332e+02_r8,7.5686e+01_r8,3.8128e+01_r8,9.6108e+00_r8/)
      kbo(:, 4,21,12) = (/ &
     &1.9244e+02_r8,1.4443e+02_r8,9.6415e+01_r8,4.8410e+01_r8,9.4311e+00_r8/)
      kbo(:, 5,21,12) = (/ &
     &2.3840e+02_r8,1.7889e+02_r8,1.1939e+02_r8,5.9885e+01_r8,9.2417e+00_r8/)
      kbo(:, 1,22,12) = (/ &
     &7.1250e+01_r8,5.3549e+01_r8,3.5853e+01_r8,2.1126e+01_r8,1.0685e+01_r8/)
      kbo(:, 2,22,12) = (/ &
     &9.7414e+01_r8,7.3164e+01_r8,4.8918e+01_r8,2.6307e+01_r8,1.0512e+01_r8/)
      kbo(:, 3,22,12) = (/ &
     &1.2780e+02_r8,9.5945e+01_r8,6.4097e+01_r8,3.2967e+01_r8,1.0335e+01_r8/)
      kbo(:, 4,22,12) = (/ &
     &1.6218e+02_r8,1.2173e+02_r8,8.1281e+01_r8,4.1038e+01_r8,1.0145e+01_r8/)
      kbo(:, 5,22,12) = (/ &
     &2.0041e+02_r8,1.5040e+02_r8,1.0039e+02_r8,5.0398e+01_r8,9.9454e+00_r8/)
      kbo(:, 1,23,12) = (/ &
     &6.0942e+01_r8,4.5813e+01_r8,3.0934e+01_r8,2.0012e+01_r8,1.1340e+01_r8/)
      kbo(:, 2,23,12) = (/ &
     &8.2640e+01_r8,6.2081e+01_r8,4.1527e+01_r8,2.4053e+01_r8,1.1180e+01_r8/)
      kbo(:, 3,23,12) = (/ &
     &1.0785e+02_r8,8.0983e+01_r8,5.4124e+01_r8,2.9110e+01_r8,1.1001e+01_r8/)
      kbo(:, 4,23,12) = (/ &
     &1.3652e+02_r8,1.0249e+02_r8,6.8454e+01_r8,3.5343e+01_r8,1.0812e+01_r8/)
      kbo(:, 5,23,12) = (/ &
     &1.6894e+02_r8,1.2680e+02_r8,8.4663e+01_r8,4.2880e+01_r8,1.0609e+01_r8/)
      kbo(:, 1,24,12) = (/ &
     &5.1406e+01_r8,3.8659e+01_r8,2.6835e+01_r8,1.9368e+01_r8,1.1917e+01_r8/)
      kbo(:, 2,24,12) = (/ &
     &6.9266e+01_r8,5.2052e+01_r8,3.5118e+01_r8,2.2283e+01_r8,1.1770e+01_r8/)
      kbo(:, 3,24,12) = (/ &
     &9.0127e+01_r8,6.7693e+01_r8,4.5282e+01_r8,2.6104e+01_r8,1.1607e+01_r8/)
      kbo(:, 4,24,12) = (/ &
     &1.1424e+02_r8,8.5780e+01_r8,5.7328e+01_r8,3.0937e+01_r8,1.1421e+01_r8/)
      kbo(:, 5,24,12) = (/ &
     &1.4182e+02_r8,1.0646e+02_r8,7.1109e+01_r8,3.6894e+01_r8,1.1218e+01_r8/)
      kbo(:, 1,25,12) = (/ &
     &4.3762e+01_r8,3.2928e+01_r8,2.3974e+01_r8,1.9297e+01_r8,1.2406e+01_r8/)
      kbo(:, 2,25,12) = (/ &
     &5.8726e+01_r8,4.4147e+01_r8,3.0453e+01_r8,2.1379e+01_r8,1.2284e+01_r8/)
      kbo(:, 3,25,12) = (/ &
     &7.6463e+01_r8,5.7453e+01_r8,3.8735e+01_r8,2.4187e+01_r8,1.2134e+01_r8/)
      kbo(:, 4,25,12) = (/ &
     &9.7222e+01_r8,7.3021e+01_r8,4.8859e+01_r8,2.7987e+01_r8,1.1961e+01_r8/)
      kbo(:, 5,25,12) = (/ &
     &1.2098e+02_r8,9.0828e+01_r8,6.0694e+01_r8,3.2765e+01_r8,1.1759e+01_r8/)
      kbo(:, 1,26,12) = (/ &
     &3.8022e+01_r8,2.8659e+01_r8,2.2105e+01_r8,1.9516e+01_r8,1.2805e+01_r8/)
      kbo(:, 2,26,12) = (/ &
     &5.0994e+01_r8,3.8356e+01_r8,2.7362e+01_r8,2.1131e+01_r8,1.2709e+01_r8/)
      kbo(:, 3,26,12) = (/ &
     &6.6538e+01_r8,5.0014e+01_r8,3.4258e+01_r8,2.3250e+01_r8,1.2582e+01_r8/)
      kbo(:, 4,26,12) = (/ &
     &8.4702e+01_r8,6.3631e+01_r8,4.2833e+01_r8,2.6169e+01_r8,1.2418e+01_r8/)
      kbo(:, 5,26,12) = (/ &
     &1.0565e+02_r8,7.9327e+01_r8,5.3062e+01_r8,3.0028e+01_r8,1.2216e+01_r8/)
      kbo(:, 1,27,12) = (/ &
     &3.4489e+01_r8,2.6132e+01_r8,2.1235e+01_r8,1.9878e+01_r8,1.3122e+01_r8/)
      kbo(:, 2,27,12) = (/ &
     &4.6305e+01_r8,3.4844e+01_r8,2.5714e+01_r8,2.1342e+01_r8,1.3062e+01_r8/)
      kbo(:, 3,27,12) = (/ &
     &6.0441e+01_r8,4.5443e+01_r8,3.1734e+01_r8,2.3085e+01_r8,1.2955e+01_r8/)
      kbo(:, 4,27,12) = (/ &
     &7.7109e+01_r8,5.7931e+01_r8,3.9347e+01_r8,2.5409e+01_r8,1.2800e+01_r8/)
      kbo(:, 5,27,12) = (/ &
     &9.6578e+01_r8,7.2521e+01_r8,4.8662e+01_r8,2.8654e+01_r8,1.2602e+01_r8/)
      kbo(:, 1,28,12) = (/ &
     &3.2427e+01_r8,2.4737e+01_r8,2.0948e+01_r8,2.0280e+01_r8,1.3386e+01_r8/)
      kbo(:, 2,28,12) = (/ &
     &4.3501e+01_r8,3.2787e+01_r8,2.4919e+01_r8,2.1714e+01_r8,1.3352e+01_r8/)
      kbo(:, 3,28,12) = (/ &
     &5.6891e+01_r8,4.2776e+01_r8,3.0416e+01_r8,2.3252e+01_r8,1.3262e+01_r8/)
      kbo(:, 4,28,12) = (/ &
     &7.2922e+01_r8,5.4789e+01_r8,3.7531e+01_r8,2.5273e+01_r8,1.3118e+01_r8/)
      kbo(:, 5,28,12) = (/ &
     &9.1872e+01_r8,6.8992e+01_r8,4.6457e+01_r8,2.8166e+01_r8,1.2926e+01_r8/)
      kbo(:, 1,29,12) = (/ &
     &3.2667e+01_r8,2.5018e+01_r8,2.1498e+01_r8,2.0955e+01_r8,1.3603e+01_r8/)
      kbo(:, 2,29,12) = (/ &
     &4.3912e+01_r8,3.3123e+01_r8,2.5431e+01_r8,2.2422e+01_r8,1.3591e+01_r8/)
      kbo(:, 3,29,12) = (/ &
     &5.7701e+01_r8,4.3385e+01_r8,3.1008e+01_r8,2.3974e+01_r8,1.3517e+01_r8/)
      kbo(:, 4,29,12) = (/ &
     &7.4275e+01_r8,5.5806e+01_r8,3.8313e+01_r8,2.6005e+01_r8,1.3383e+01_r8/)
      kbo(:, 5,29,12) = (/ &
     &9.3871e+01_r8,7.0500e+01_r8,4.7521e+01_r8,2.8930e+01_r8,1.3178e+01_r8/)
      kbo(:, 1,30,12) = (/ &
     &3.4156e+01_r8,2.6153e+01_r8,2.2429e+01_r8,2.1713e+01_r8,1.3788e+01_r8/)
      kbo(:, 2,30,12) = (/ &
     &4.6027e+01_r8,3.4711e+01_r8,2.6560e+01_r8,2.3234e+01_r8,1.3795e+01_r8/)
      kbo(:, 3,30,12) = (/ &
     &6.0622e+01_r8,4.5582e+01_r8,3.2488e+01_r8,2.4921e+01_r8,1.3734e+01_r8/)
      kbo(:, 4,30,12) = (/ &
     &7.8321e+01_r8,5.8857e+01_r8,4.0368e+01_r8,2.7080e+01_r8,1.3599e+01_r8/)
      kbo(:, 5,30,12) = (/ &
     &9.9301e+01_r8,7.4592e+01_r8,5.0256e+01_r8,3.0286e+01_r8,1.3384e+01_r8/)
      kbo(:, 1,31,12) = (/ &
     &3.8076e+01_r8,2.9005e+01_r8,2.4159e+01_r8,2.2772e+01_r8,1.3950e+01_r8/)
      kbo(:, 2,31,12) = (/ &
     &5.1386e+01_r8,3.8696e+01_r8,2.8953e+01_r8,2.4505e+01_r8,1.3973e+01_r8/)
      kbo(:, 3,31,12) = (/ &
     &6.7843e+01_r8,5.1009e+01_r8,3.5918e+01_r8,2.6433e+01_r8,1.3920e+01_r8/)
      kbo(:, 4,31,12) = (/ &
     &8.7812e+01_r8,6.5990e+01_r8,4.4995e+01_r8,2.9071e+01_r8,1.3753e+01_r8/)
      kbo(:, 5,31,12) = (/ &
     &1.1160e+02_r8,8.3824e+01_r8,5.6340e+01_r8,3.3050e+01_r8,1.3573e+01_r8/)
      kbo(:, 1,32,12) = (/ &
     &4.3422e+01_r8,3.2909e+01_r8,2.6354e+01_r8,2.4011e+01_r8,1.4101e+01_r8/)
      kbo(:, 2,32,12) = (/ &
     &5.8749e+01_r8,4.4202e+01_r8,3.2268e+01_r8,2.6008e+01_r8,1.4129e+01_r8/)
      kbo(:, 3,32,12) = (/ &
     &7.7682e+01_r8,5.8398e+01_r8,4.0569e+01_r8,2.8355e+01_r8,1.4037e+01_r8/)
      kbo(:, 4,32,12) = (/ &
     &1.0053e+02_r8,7.5534e+01_r8,5.1158e+01_r8,3.1768e+01_r8,1.3909e+01_r8/)
      kbo(:, 5,32,12) = (/ &
     &1.2780e+02_r8,9.5988e+01_r8,6.4344e+01_r8,3.6705e+01_r8,1.3757e+01_r8/)
      kbo(:, 1,33,12) = (/ &
     &5.0972e+01_r8,3.8474e+01_r8,2.9509e+01_r8,2.5608e+01_r8,1.4236e+01_r8/)
      kbo(:, 2,33,12) = (/ &
     &6.8978e+01_r8,5.1873e+01_r8,3.6983e+01_r8,2.7940e+01_r8,1.4225e+01_r8/)
      kbo(:, 3,33,12) = (/ &
     &9.1196e+01_r8,6.8536e+01_r8,4.6964e+01_r8,3.1045e+01_r8,1.4156e+01_r8/)
      kbo(:, 4,33,12) = (/ &
     &1.1806e+02_r8,8.8684e+01_r8,5.9688e+01_r8,3.5479e+01_r8,1.4053e+01_r8/)
      kbo(:, 5,33,12) = (/ &
     &1.5026e+02_r8,1.1283e+02_r8,7.5476e+01_r8,4.1722e+01_r8,1.3797e+01_r8/)
      kbo(:, 1,34,12) = (/ &
     &5.8196e+01_r8,4.3842e+01_r8,3.2696e+01_r8,2.7075e+01_r8,1.4322e+01_r8/)
      kbo(:, 2,34,12) = (/ &
     &7.8717e+01_r8,5.9180e+01_r8,4.1505e+01_r8,2.9899e+01_r8,1.4304e+01_r8/)
      kbo(:, 3,34,12) = (/ &
     &1.0408e+02_r8,7.8203e+01_r8,5.3150e+01_r8,3.3676e+01_r8,1.4279e+01_r8/)
      kbo(:, 4,34,12) = (/ &
     &1.3497e+02_r8,1.0137e+02_r8,6.8004e+01_r8,3.9142e+01_r8,1.4130e+01_r8/)
      kbo(:, 5,34,12) = (/ &
     &1.7215e+02_r8,1.2926e+02_r8,8.6400e+01_r8,4.6696e+01_r8,1.3817e+01_r8/)
      kbo(:, 1,35,12) = (/ &
     &6.4953e+01_r8,4.8885e+01_r8,3.5777e+01_r8,2.8513e+01_r8,1.4376e+01_r8/)
      kbo(:, 2,35,12) = (/ &
     &8.7973e+01_r8,6.6128e+01_r8,4.5876e+01_r8,3.1844e+01_r8,1.4423e+01_r8/)
      kbo(:, 3,35,12) = (/ &
     &1.1659e+02_r8,8.7588e+01_r8,5.9213e+01_r8,3.6344e+01_r8,1.4380e+01_r8/)
      kbo(:, 4,35,12) = (/ &
     &1.5177e+02_r8,1.1397e+02_r8,7.6316e+01_r8,4.2891e+01_r8,1.4142e+01_r8/)
      kbo(:, 5,35,12) = (/ &
     &1.9438e+02_r8,1.4593e+02_r8,9.7521e+01_r8,5.1793e+01_r8,1.3951e+01_r8/)
      kbo(:, 1,36,12) = (/ &
     &7.0028e+01_r8,5.2692e+01_r8,3.8196e+01_r8,2.9764e+01_r8,1.4429e+01_r8/)
      kbo(:, 2,36,12) = (/ &
     &9.5230e+01_r8,7.1580e+01_r8,4.9388e+01_r8,3.3491e+01_r8,1.4515e+01_r8/)
      kbo(:, 3,36,12) = (/ &
     &1.2679e+02_r8,9.5251e+01_r8,6.4219e+01_r8,3.8654e+01_r8,1.4447e+01_r8/)
      kbo(:, 4,36,12) = (/ &
     &1.6604e+02_r8,1.2468e+02_r8,8.3408e+01_r8,4.6199e+01_r8,1.4226e+01_r8/)
      kbo(:, 5,36,12) = (/ &
     &2.1406e+02_r8,1.6070e+02_r8,1.0737e+02_r8,5.6401e+01_r8,1.4079e+01_r8/)
      kbo(:, 1,37,12) = (/ &
     &7.0336e+01_r8,5.2944e+01_r8,3.8605e+01_r8,3.0262e+01_r8,1.4492e+01_r8/)
      kbo(:, 2,37,12) = (/ &
     &9.6465e+01_r8,7.2514e+01_r8,5.0131e+01_r8,3.4164e+01_r8,1.4585e+01_r8/)
      kbo(:, 3,37,12) = (/ &
     &1.2955e+02_r8,9.7324e+01_r8,6.5642e+01_r8,3.9574e+01_r8,1.4537e+01_r8/)
      kbo(:, 4,37,12) = (/ &
     &1.7114e+02_r8,1.2851e+02_r8,8.5971e+01_r8,4.7570e+01_r8,1.4312e+01_r8/)
      kbo(:, 5,37,12) = (/ &
     &2.2257e+02_r8,1.6708e+02_r8,1.1162e+02_r8,5.8523e+01_r8,1.4157e+01_r8/)
      kbo(:, 1,38,12) = (/ &
     &7.1653e+01_r8,5.3935e+01_r8,3.9443e+01_r8,3.0956e+01_r8,1.4537e+01_r8/)
      kbo(:, 2,38,12) = (/ &
     &9.9371e+01_r8,7.4697e+01_r8,5.1646e+01_r8,3.5117e+01_r8,1.4670e+01_r8/)
      kbo(:, 3,38,12) = (/ &
     &1.3467e+02_r8,1.0116e+02_r8,6.8199e+01_r8,4.0938e+01_r8,1.4595e+01_r8/)
      kbo(:, 4,38,12) = (/ &
     &1.7944e+02_r8,1.3474e+02_r8,9.0110e+01_r8,4.9614e+01_r8,1.4367e+01_r8/)
      kbo(:, 5,38,12) = (/ &
     &2.3537e+02_r8,1.7668e+02_r8,1.1802e+02_r8,6.1608e+01_r8,1.4213e+01_r8/)
      kbo(:, 1,39,12) = (/ &
     &7.4953e+01_r8,5.6404e+01_r8,4.1108e+01_r8,3.2048e+01_r8,1.4593e+01_r8/)
      kbo(:, 2,39,12) = (/ &
     &1.0508e+02_r8,7.8982e+01_r8,5.4463e+01_r8,3.6606e+01_r8,1.4737e+01_r8/)
      kbo(:, 3,39,12) = (/ &
     &1.4387e+02_r8,1.0807e+02_r8,7.2745e+01_r8,4.3123e+01_r8,1.4593e+01_r8/)
      kbo(:, 4,39,12) = (/ &
     &1.9336e+02_r8,1.4518e+02_r8,9.7046e+01_r8,5.2882e+01_r8,1.4422e+01_r8/)
      kbo(:, 5,39,12) = (/ &
     &2.5579e+02_r8,1.9200e+02_r8,1.2823e+02_r8,6.6478e+01_r8,1.4241e+01_r8/)
      kbo(:, 1,40,12) = (/ &
     &7.1125e+01_r8,5.3576e+01_r8,3.9744e+01_r8,3.1845e+01_r8,1.4584e+01_r8/)
      kbo(:, 2,40,12) = (/ &
     &1.0123e+02_r8,7.6093e+01_r8,5.2813e+01_r8,3.6464e+01_r8,1.4753e+01_r8/)
      kbo(:, 3,40,12) = (/ &
     &1.4047e+02_r8,1.0551e+02_r8,7.1189e+01_r8,4.2876e+01_r8,1.4635e+01_r8/)
      kbo(:, 4,40,12) = (/ &
     &1.9075e+02_r8,1.4322e+02_r8,9.5759e+01_r8,5.2592e+01_r8,1.4461e+01_r8/)
      kbo(:, 5,40,12) = (/ &
     &2.5487e+02_r8,1.9131e+02_r8,1.2777e+02_r8,6.6443e+01_r8,1.4311e+01_r8/)
      kbo(:, 1,41,12) = (/ &
     &6.6999e+01_r8,5.0553e+01_r8,3.8328e+01_r8,3.1540e+01_r8,1.4557e+01_r8/)
      kbo(:, 2,41,12) = (/ &
     &9.6989e+01_r8,7.2904e+01_r8,5.1038e+01_r8,3.6239e+01_r8,1.4754e+01_r8/)
      kbo(:, 3,41,12) = (/ &
     &1.3645e+02_r8,1.0250e+02_r8,6.9354e+01_r8,4.2559e+01_r8,1.4660e+01_r8/)
      kbo(:, 4,41,12) = (/ &
     &1.8750e+02_r8,1.4078e+02_r8,9.4178e+01_r8,5.2196e+01_r8,1.4491e+01_r8/)
      kbo(:, 5,41,12) = (/ &
     &2.5297e+02_r8,1.8988e+02_r8,1.2682e+02_r8,6.6184e+01_r8,1.4389e+01_r8/)
      kbo(:, 1,42,12) = (/ &
     &6.3698e+01_r8,4.8173e+01_r8,3.7314e+01_r8,3.1356e+01_r8,1.4515e+01_r8/)
      kbo(:, 2,42,12) = (/ &
     &9.3921e+01_r8,7.0600e+01_r8,4.9842e+01_r8,3.6216e+01_r8,1.4716e+01_r8/)
      kbo(:, 3,42,12) = (/ &
     &1.3407e+02_r8,1.0072e+02_r8,6.8313e+01_r8,4.2558e+01_r8,1.4673e+01_r8/)
      kbo(:, 4,42,12) = (/ &
     &1.8663e+02_r8,1.4013e+02_r8,9.3782e+01_r8,5.2338e+01_r8,1.4521e+01_r8/)
      kbo(:, 5,42,12) = (/ &
     &2.5424e+02_r8,1.9084e+02_r8,1.2745e+02_r8,6.6667e+01_r8,1.4444e+01_r8/)
      kbo(:, 1,43,12) = (/ &
     &5.9556e+01_r8,4.5221e+01_r8,3.6039e+01_r8,3.0985e+01_r8,1.4424e+01_r8/)
      kbo(:, 2,43,12) = (/ &
     &8.9715e+01_r8,6.7448e+01_r8,4.8196e+01_r8,3.6053e+01_r8,1.4672e+01_r8/)
      kbo(:, 3,43,12) = (/ &
     &1.3041e+02_r8,9.7958e+01_r8,6.6682e+01_r8,4.2356e+01_r8,1.4685e+01_r8/)
      kbo(:, 4,43,12) = (/ &
     &1.8413e+02_r8,1.3825e+02_r8,9.2592e+01_r8,5.2204e+01_r8,1.4530e+01_r8/)
      kbo(:, 5,43,12) = (/ &
     &2.5372e+02_r8,1.9044e+02_r8,1.2719e+02_r8,6.6793e+01_r8,1.4531e+01_r8/)
      kbo(:, 1,44,12) = (/ &
     &5.5617e+01_r8,4.2462e+01_r8,3.4926e+01_r8,3.0616e+01_r8,1.4301e+01_r8/)
      kbo(:, 2,44,12) = (/ &
     &8.5711e+01_r8,6.4467e+01_r8,4.6726e+01_r8,3.5948e+01_r8,1.4602e+01_r8/)
      kbo(:, 3,44,12) = (/ &
     &1.2713e+02_r8,9.5499e+01_r8,6.5283e+01_r8,4.2294e+01_r8,1.4674e+01_r8/)
      kbo(:, 4,44,12) = (/ &
     &1.8238e+02_r8,1.3694e+02_r8,9.1783e+01_r8,5.2246e+01_r8,1.4528e+01_r8/)
      kbo(:, 5,44,12) = (/ &
     &2.5466e+02_r8,1.9115e+02_r8,1.2766e+02_r8,6.7294e+01_r8,1.4570e+01_r8/)
      kbo(:, 1,45,12) = (/ &
     &5.2685e+01_r8,4.0486e+01_r8,3.4264e+01_r8,3.0427e+01_r8,1.4151e+01_r8/)
      kbo(:, 2,45,12) = (/ &
     &8.3179e+01_r8,6.2605e+01_r8,4.5965e+01_r8,3.6072e+01_r8,1.4507e+01_r8/)
      kbo(:, 3,45,12) = (/ &
     &1.2601e+02_r8,9.4652e+01_r8,6.4923e+01_r8,4.2669e+01_r8,1.4643e+01_r8/)
      kbo(:, 4,45,12) = (/ &
     &1.8401e+02_r8,1.3816e+02_r8,9.2634e+01_r8,5.3005e+01_r8,1.4503e+01_r8/)
      kbo(:, 5,45,12) = (/ &
     &2.6050e+02_r8,1.9553e+02_r8,1.3058e+02_r8,6.8905e+01_r8,1.4618e+01_r8/)
      kbo(:, 1,46,12) = (/ &
     &4.9550e+01_r8,3.8366e+01_r8,3.3605e+01_r8,3.0155e+01_r8,1.3963e+01_r8/)
      kbo(:, 2,46,12) = (/ &
     &8.0337e+01_r8,6.0538e+01_r8,4.5156e+01_r8,3.6142e+01_r8,1.4400e+01_r8/)
      kbo(:, 3,46,12) = (/ &
     &1.2453e+02_r8,9.3545e+01_r8,6.4429e+01_r8,4.3023e+01_r8,1.4594e+01_r8/)
      kbo(:, 4,46,12) = (/ &
     &1.8550e+02_r8,1.3927e+02_r8,9.3438e+01_r8,5.3784e+01_r8,1.4498e+01_r8/)
      kbo(:, 5,46,12) = (/ &
     &2.6666e+02_r8,2.0015e+02_r8,1.3366e+02_r8,7.0579e+01_r8,1.4676e+01_r8/)
      kbo(:, 1,47,12) = (/ &
     &4.4761e+01_r8,3.5144e+01_r8,3.2385e+01_r8,2.9408e+01_r8,1.3714e+01_r8/)
      kbo(:, 2,47,12) = (/ &
     &7.4836e+01_r8,5.6569e+01_r8,4.3337e+01_r8,3.5671e+01_r8,1.4241e+01_r8/)
      kbo(:, 3,47,12) = (/ &
     &1.1904e+02_r8,8.9427e+01_r8,6.2124e+01_r8,4.2720e+01_r8,1.4513e+01_r8/)
      kbo(:, 4,47,12) = (/ &
     &1.8135e+02_r8,1.3615e+02_r8,9.1529e+01_r8,5.3518e+01_r8,1.4491e+01_r8/)
      kbo(:, 5,47,12) = (/ &
     &2.6557e+02_r8,1.9933e+02_r8,1.3311e+02_r8,7.0671e+01_r8,1.4708e+01_r8/)
      kbo(:, 1,48,12) = (/ &
     &4.1069e+01_r8,3.2801e+01_r8,3.1586e+01_r8,2.8865e+01_r8,1.3457e+01_r8/)
      kbo(:, 2,48,12) = (/ &
     &7.0975e+01_r8,5.3819e+01_r8,4.2302e+01_r8,3.5478e+01_r8,1.4056e+01_r8/)
      kbo(:, 3,48,12) = (/ &
     &1.1614e+02_r8,8.7254e+01_r8,6.1078e+01_r8,4.2908e+01_r8,1.4399e+01_r8/)
      kbo(:, 4,48,12) = (/ &
     &1.8113e+02_r8,1.3599e+02_r8,9.1560e+01_r8,5.4099e+01_r8,1.4482e+01_r8/)
      kbo(:, 5,48,12) = (/ &
     &2.7078e+02_r8,2.0323e+02_r8,1.3570e+02_r8,7.2222e+01_r8,1.4704e+01_r8/)
      kbo(:, 1,49,12) = (/ &
     &3.8731e+01_r8,3.1486e+01_r8,3.1265e+01_r8,2.8628e+01_r8,1.3159e+01_r8/)
      kbo(:, 2,49,12) = (/ &
     &6.9397e+01_r8,5.2759e+01_r8,4.2223e+01_r8,3.5759e+01_r8,1.3841e+01_r8/)
      kbo(:, 3,49,12) = (/ &
     &1.1709e+02_r8,8.7966e+01_r8,6.1851e+01_r8,4.3836e+01_r8,1.4254e+01_r8/)
      kbo(:, 4,49,12) = (/ &
     &1.8714e+02_r8,1.4049e+02_r8,9.4623e+01_r8,5.5973e+01_r8,1.4472e+01_r8/)
      kbo(:, 5,49,12) = (/ &
     &2.8581e+02_r8,2.1450e+02_r8,1.4321e+02_r8,7.6013e+01_r8,1.4713e+01_r8/)
      kbo(:, 1,50,12) = (/ &
     &3.4845e+01_r8,2.9222e+01_r8,3.0219e+01_r8,2.7841e+01_r8,1.2848e+01_r8/)
      kbo(:, 2,50,12) = (/ &
     &6.4780e+01_r8,4.9517e+01_r8,4.0909e+01_r8,3.5306e+01_r8,1.3605e+01_r8/)
      kbo(:, 3,50,12) = (/ &
     &1.1280e+02_r8,8.4759e+01_r8,6.0286e+01_r8,4.3805e+01_r8,1.4114e+01_r8/)
      kbo(:, 4,50,12) = (/ &
     &1.8491e+02_r8,1.3882e+02_r8,9.3723e+01_r8,5.6179e+01_r8,1.4404e+01_r8/)
      kbo(:, 5,50,12) = (/ &
     &2.8849e+02_r8,2.1650e+02_r8,1.4455e+02_r8,7.7018e+01_r8,1.4673e+01_r8/)
      kbo(:, 1,51,12) = (/ &
     &3.0519e+01_r8,2.6754e+01_r8,2.8814e+01_r8,2.6775e+01_r8,1.2516e+01_r8/)
      kbo(:, 2,51,12) = (/ &
     &5.8895e+01_r8,4.5411e+01_r8,3.9106e+01_r8,3.4462e+01_r8,1.3344e+01_r8/)
      kbo(:, 3,51,12) = (/ &
     &1.0594e+02_r8,7.9673e+01_r8,5.7668e+01_r8,4.3297e+01_r8,1.3940e+01_r8/)
      kbo(:, 4,51,12) = (/ &
     &1.7846e+02_r8,1.3399e+02_r8,9.0800e+01_r8,5.5546e+01_r8,1.4316e+01_r8/)
      kbo(:, 5,51,12) = (/ &
     &2.8452e+02_r8,2.1353e+02_r8,1.4260e+02_r8,7.6552e+01_r8,1.4603e+01_r8/)
      kbo(:, 1,52,12) = (/ &
     &2.7172e+01_r8,2.4938e+01_r8,2.7638e+01_r8,2.5911e+01_r8,1.2154e+01_r8/)
      kbo(:, 2,52,12) = (/ &
     &5.4443e+01_r8,4.2404e+01_r8,3.7930e+01_r8,3.3867e+01_r8,1.3047e+01_r8/)
      kbo(:, 3,52,12) = (/ &
     &1.0140e+02_r8,7.6335e+01_r8,5.6140e+01_r8,4.3191e+01_r8,1.3744e+01_r8/)
      kbo(:, 4,52,12) = (/ &
     &1.7597e+02_r8,1.3212e+02_r8,8.9791e+01_r8,5.5744e+01_r8,1.4204e+01_r8/)
      kbo(:, 5,52,12) = (/ &
     &2.8690e+02_r8,2.1531e+02_r8,1.4382e+02_r8,7.7564e+01_r8,1.4539e+01_r8/)
      kbo(:, 1,53,12) = (/ &
     &2.4852e+01_r8,2.3783e+01_r8,2.6797e+01_r8,2.5306e+01_r8,1.1753e+01_r8/)
      kbo(:, 2,53,12) = (/ &
     &5.1806e+01_r8,4.0721e+01_r8,3.7447e+01_r8,3.3656e+01_r8,1.2720e+01_r8/)
      kbo(:, 3,53,12) = (/ &
     &1.0002e+02_r8,7.5369e+01_r8,5.6019e+01_r8,4.3667e+01_r8,1.3525e+01_r8/)
      kbo(:, 4,53,12) = (/ &
     &1.7916e+02_r8,1.3451e+02_r8,9.1517e+01_r8,5.7134e+01_r8,1.4067e+01_r8/)
      kbo(:, 5,53,12) = (/ &
     &2.9931e+02_r8,2.2462e+02_r8,1.5004e+02_r8,8.0825e+01_r8,1.4479e+01_r8/)
      kbo(:, 1,54,12) = (/ &
     &1.9814e+01_r8,2.1046e+01_r8,2.4392e+01_r8,2.3477e+01_r8,1.1367e+01_r8/)
      kbo(:, 2,54,12) = (/ &
     &4.3028e+01_r8,3.5019e+01_r8,3.4545e+01_r8,3.1504e+01_r8,1.2419e+01_r8/)
      kbo(:, 3,54,12) = (/ &
     &8.5988e+01_r8,6.5126e+01_r8,5.0588e+01_r8,4.1403e+01_r8,1.3282e+01_r8/)
      kbo(:, 4,54,12) = (/ &
     &1.5878e+02_r8,1.1923e+02_r8,8.2044e+01_r8,5.3856e+01_r8,1.3889e+01_r8/)
      kbo(:, 5,54,12) = (/ &
     &2.7225e+02_r8,2.0433e+02_r8,1.3669e+02_r8,7.5460e+01_r8,1.4357e+01_r8/)
      kbo(:, 1,55,12) = (/ &
     &1.4388e+01_r8,1.7950e+01_r8,2.1372e+01_r8,2.1168e+01_r8,1.0974e+01_r8/)
      kbo(:, 2,55,12) = (/ &
     &3.2596e+01_r8,2.8570e+01_r8,3.0630e+01_r8,2.8429e+01_r8,1.2112e+01_r8/)
      kbo(:, 3,55,12) = (/ &
     &6.7426e+01_r8,5.1747e+01_r8,4.3446e+01_r8,3.7705e+01_r8,1.3016e+01_r8/)
      kbo(:, 4,55,12) = (/ &
     &1.2839e+02_r8,9.6452e+01_r8,6.8218e+01_r8,4.8732e+01_r8,1.3748e+01_r8/)
      kbo(:, 5,55,12) = (/ &
     &2.2612e+02_r8,1.6973e+02_r8,1.1415e+02_r8,6.6296e+01_r8,1.4200e+01_r8/)
      kbo(:, 1,56,12) = (/ &
     &1.0289e+01_r8,1.5296e+01_r8,1.8729e+01_r8,1.9182e+01_r8,1.0528e+01_r8/)
      kbo(:, 2,56,12) = (/ &
     &2.4440e+01_r8,2.3761e+01_r8,2.7083e+01_r8,2.5668e+01_r8,1.1786e+01_r8/)
      kbo(:, 3,56,12) = (/ &
     &5.2397e+01_r8,4.1238e+01_r8,3.7979e+01_r8,3.4254e+01_r8,1.2753e+01_r8/)
      kbo(:, 4,56,12) = (/ &
     &1.0299e+02_r8,7.7598e+01_r8,5.7468e+01_r8,4.4519e+01_r8,1.3526e+01_r8/)
      kbo(:, 5,56,12) = (/ &
     &1.8650e+02_r8,1.4002e+02_r8,9.5113e+01_r8,5.8818e+01_r8,1.4062e+01_r8/)
      kbo(:, 1,57,12) = (/ &
     &7.2296e+00_r8,1.3018e+01_r8,1.6426e+01_r8,1.7434e+01_r8,1.0060e+01_r8/)
      kbo(:, 2,57,12) = (/ &
     &1.8079e+01_r8,2.0222e+01_r8,2.3856e+01_r8,2.3179e+01_r8,1.1422e+01_r8/)
      kbo(:, 3,57,12) = (/ &
     &4.0328e+01_r8,3.3389e+01_r8,3.3719e+01_r8,3.1042e+01_r8,1.2469e+01_r8/)
      kbo(:, 4,57,12) = (/ &
     &8.1861e+01_r8,6.2161e+01_r8,4.9031e+01_r8,4.0727e+01_r8,1.3313e+01_r8/)
      kbo(:, 5,57,12) = (/ &
     &1.5269e+02_r8,1.1466e+02_r8,7.9200e+01_r8,5.2806e+01_r8,1.3923e+01_r8/)
      kbo(:, 1,58,12) = (/ &
     &1.3378e+00_r8,3.6524e+00_r8,6.1661e+00_r8,9.4777e+00_r8,9.5880e+00_r8/)
      kbo(:, 2,58,12) = (/ &
     &3.5257e+00_r8,5.7408e+00_r8,8.9221e+00_r8,1.2503e+01_r8,1.1030e+01_r8/)
      kbo(:, 3,58,12) = (/ &
     &8.2101e+00_r8,9.0368e+00_r8,1.2733e+01_r8,1.6723e+01_r8,1.2197e+01_r8/)
      kbo(:, 4,58,12) = (/ &
     &1.7210e+01_r8,1.6233e+01_r8,1.7913e+01_r8,2.2101e+01_r8,1.3072e+01_r8/)
      kbo(:, 5,58,12) = (/ &
     &3.3035e+01_r8,3.0353e+01_r8,2.7850e+01_r8,2.8452e+01_r8,1.3763e+01_r8/)
      kbo(:, 1,59,12) = (/ &
     &1.3260e+00_r8,4.5998e+00_r8,7.5889e+00_r8,1.0717e+01_r8,9.4033e+00_r8/)
      kbo(:, 2,59,12) = (/ &
     &3.6097e+00_r8,7.0919e+00_r8,1.0659e+01_r8,1.3898e+01_r8,1.0849e+01_r8/)
      kbo(:, 3,59,12) = (/ &
     &8.5987e+00_r8,1.0607e+01_r8,1.5006e+01_r8,1.8102e+01_r8,1.2070e+01_r8/)
      kbo(:, 4,59,12) = (/ &
     &1.8312e+01_r8,1.7368e+01_r8,2.0492e+01_r8,2.3593e+01_r8,1.3009e+01_r8/)
      kbo(:, 5,59,12) = (/ &
     &3.5634e+01_r8,3.1449e+01_r8,2.9305e+01_r8,3.0122e+01_r8,1.3723e+01_r8/)
      kbo(:, 1,13,13) = (/ &
     &1.2162e+03_r8,9.1228e+02_r8,6.0835e+02_r8,3.0442e+02_r8,5.7609e+00_r8/)
      kbo(:, 2,13,13) = (/ &
     &1.7381e+03_r8,1.3037e+03_r8,8.6931e+02_r8,4.3490e+02_r8,5.6432e+00_r8/)
      kbo(:, 3,13,13) = (/ &
     &2.3576e+03_r8,1.7683e+03_r8,1.1791e+03_r8,5.8977e+02_r8,5.5255e+00_r8/)
      kbo(:, 4,13,13) = (/ &
     &3.0662e+03_r8,2.2998e+03_r8,1.5334e+03_r8,7.6694e+02_r8,5.4044e+00_r8/)
      kbo(:, 5,13,13) = (/ &
     &3.8594e+03_r8,2.8947e+03_r8,1.9299e+03_r8,9.6523e+02_r8,5.2355e+00_r8/)
      kbo(:, 1,14,13) = (/ &
     &7.9362e+02_r8,5.9533e+02_r8,3.9705e+02_r8,1.9877e+02_r8,6.3709e+00_r8/)
      kbo(:, 2,14,13) = (/ &
     &1.1345e+03_r8,8.5102e+02_r8,5.6751e+02_r8,2.8400e+02_r8,6.2388e+00_r8/)
      kbo(:, 3,14,13) = (/ &
     &1.5436e+03_r8,1.1578e+03_r8,7.7203e+02_r8,3.8627e+02_r8,6.0986e+00_r8/)
      kbo(:, 4,14,13) = (/ &
     &2.0139e+03_r8,1.5105e+03_r8,1.0072e+03_r8,5.0384e+02_r8,5.9465e+00_r8/)
      kbo(:, 5,14,13) = (/ &
     &2.5413e+03_r8,1.9061e+03_r8,1.2709e+03_r8,6.3569e+02_r8,5.7898e+00_r8/)
      kbo(:, 1,15,13) = (/ &
     &5.3943e+02_r8,4.0470e+02_r8,2.6997e+02_r8,1.3524e+02_r8,7.0503e+00_r8/)
      kbo(:, 2,15,13) = (/ &
     &7.7270e+02_r8,5.7965e+02_r8,3.8660e+02_r8,1.9355e+02_r8,6.8771e+00_r8/)
      kbo(:, 3,15,13) = (/ &
     &1.0520e+03_r8,7.8913e+02_r8,5.2626e+02_r8,2.6338e+02_r8,6.6997e+00_r8/)
      kbo(:, 4,15,13) = (/ &
     &1.3743e+03_r8,1.0308e+03_r8,6.8738e+02_r8,3.4394e+02_r8,6.5201e+00_r8/)
      kbo(:, 5,15,13) = (/ &
     &1.7371e+03_r8,1.3030e+03_r8,8.6881e+02_r8,4.3464e+02_r8,6.3410e+00_r8/)
      kbo(:, 1,16,13) = (/ &
     &4.4449e+02_r8,3.3349e+02_r8,2.2249e+02_r8,1.1150e+02_r8,7.7448e+00_r8/)
      kbo(:, 2,16,13) = (/ &
     &6.3512e+02_r8,4.7646e+02_r8,3.1780e+02_r8,1.5915e+02_r8,7.5481e+00_r8/)
      kbo(:, 3,16,13) = (/ &
     &8.6257e+02_r8,6.4705e+02_r8,4.3152e+02_r8,2.1600e+02_r8,7.3457e+00_r8/)
      kbo(:, 4,16,13) = (/ &
     &1.1249e+03_r8,8.4376e+02_r8,5.6265e+02_r8,2.8155e+02_r8,7.1472e+00_r8/)
      kbo(:, 5,16,13) = (/ &
     &1.4185e+03_r8,1.0640e+03_r8,7.0946e+02_r8,3.5494e+02_r8,6.9622e+00_r8/)
      kbo(:, 1,17,13) = (/ &
     &3.7725e+02_r8,2.8305e+02_r8,1.8886e+02_r8,9.4667e+01_r8,8.5153e+00_r8/)
      kbo(:, 2,17,13) = (/ &
     &5.3579e+02_r8,4.0195e+02_r8,2.6812e+02_r8,1.3428e+02_r8,8.2959e+00_r8/)
      kbo(:, 3,17,13) = (/ &
     &7.2432e+02_r8,5.4334e+02_r8,3.6237e+02_r8,1.8140e+02_r8,8.0790e+00_r8/)
      kbo(:, 4,17,13) = (/ &
     &9.4095e+02_r8,7.0582e+02_r8,4.7068e+02_r8,2.3555e+02_r8,7.8782e+00_r8/)
      kbo(:, 5,17,13) = (/ &
     &1.1800e+03_r8,8.8510e+02_r8,5.9020e+02_r8,2.9531e+02_r8,7.6889e+00_r8/)
      kbo(:, 1,18,13) = (/ &
     &3.2277e+02_r8,2.4218e+02_r8,1.6159e+02_r8,8.1002e+01_r8,9.4611e+00_r8/)
      kbo(:, 2,18,13) = (/ &
     &4.5535e+02_r8,3.4161e+02_r8,2.2787e+02_r8,1.1413e+02_r8,9.2187e+00_r8/)
      kbo(:, 3,18,13) = (/ &
     &6.1248e+02_r8,4.5945e+02_r8,3.0643e+02_r8,1.5340e+02_r8,8.9925e+00_r8/)
      kbo(:, 4,18,13) = (/ &
     &7.9039e+02_r8,5.9288e+02_r8,3.9538e+02_r8,1.9787e+02_r8,8.7824e+00_r8/)
      kbo(:, 5,18,13) = (/ &
     &9.8664e+02_r8,7.4007e+02_r8,4.9351e+02_r8,2.4694e+02_r8,8.5832e+00_r8/)
      kbo(:, 1,19,13) = (/ &
     &2.6617e+02_r8,1.9972e+02_r8,1.3326e+02_r8,6.6812e+01_r8,1.0581e+01_r8/)
      kbo(:, 2,19,13) = (/ &
     &3.7316e+02_r8,2.7996e+02_r8,1.8675e+02_r8,9.3549e+01_r8,1.0334e+01_r8/)
      kbo(:, 3,19,13) = (/ &
     &4.9811e+02_r8,3.7366e+02_r8,2.4922e+02_r8,1.2478e+02_r8,1.0097e+01_r8/)
      kbo(:, 4,19,13) = (/ &
     &6.3941e+02_r8,4.7964e+02_r8,3.1987e+02_r8,1.6011e+02_r8,9.8657e+00_r8/)
      kbo(:, 5,19,13) = (/ &
     &7.9554e+02_r8,5.9674e+02_r8,3.9794e+02_r8,1.9915e+02_r8,9.6319e+00_r8/)
      kbo(:, 1,20,13) = (/ &
     &2.3446e+02_r8,1.7592e+02_r8,1.1738e+02_r8,5.8849e+01_r8,1.1882e+01_r8/)
      kbo(:, 2,20,13) = (/ &
     &3.2565e+02_r8,2.4431e+02_r8,1.6298e+02_r8,8.1640e+01_r8,1.1619e+01_r8/)
      kbo(:, 3,20,13) = (/ &
     &4.3162e+02_r8,3.2380e+02_r8,2.1597e+02_r8,1.0814e+02_r8,1.1360e+01_r8/)
      kbo(:, 4,20,13) = (/ &
     &5.5163e+02_r8,4.1380e+02_r8,2.7598e+02_r8,1.3815e+02_r8,1.1092e+01_r8/)
      kbo(:, 5,20,13) = (/ &
     &6.8433e+02_r8,5.1333e+02_r8,3.4234e+02_r8,1.7134e+02_r8,1.0817e+01_r8/)
      kbo(:, 1,21,13) = (/ &
     &2.0791e+02_r8,1.5600e+02_r8,1.0410e+02_r8,5.2196e+01_r8,1.3299e+01_r8/)
      kbo(:, 2,21,13) = (/ &
     &2.8639e+02_r8,2.1487e+02_r8,1.4335e+02_r8,7.1825e+01_r8,1.3019e+01_r8/)
      kbo(:, 3,21,13) = (/ &
     &3.7808e+02_r8,2.8364e+02_r8,1.8920e+02_r8,9.4762e+01_r8,1.2725e+01_r8/)
      kbo(:, 4,21,13) = (/ &
     &4.8188e+02_r8,3.6150e+02_r8,2.4111e+02_r8,1.2072e+02_r8,1.2414e+01_r8/)
      kbo(:, 5,21,13) = (/ &
     &5.9751e+02_r8,4.4821e+02_r8,2.9892e+02_r8,1.4963e+02_r8,1.2098e+01_r8/)
      kbo(:, 1,22,13) = (/ &
     &1.8905e+02_r8,1.4186e+02_r8,9.4669e+01_r8,4.7658e+01_r8,1.4760e+01_r8/)
      kbo(:, 2,22,13) = (/ &
     &2.5846e+02_r8,1.9392e+02_r8,1.2939e+02_r8,6.4852e+01_r8,1.4444e+01_r8/)
      kbo(:, 3,22,13) = (/ &
     &3.3936e+02_r8,2.5460e+02_r8,1.6984e+02_r8,8.5086e+01_r8,1.4104e+01_r8/)
      kbo(:, 4,22,13) = (/ &
     &4.3137e+02_r8,3.2361e+02_r8,2.1585e+02_r8,1.0809e+02_r8,1.3746e+01_r8/)
      kbo(:, 5,22,13) = (/ &
     &5.3388e+02_r8,4.0049e+02_r8,2.6710e+02_r8,1.3372e+02_r8,1.3378e+01_r8/)
      kbo(:, 1,23,13) = (/ &
     &1.7012e+02_r8,1.2766e+02_r8,8.5209e+01_r8,4.3736e+01_r8,1.6211e+01_r8/)
      kbo(:, 2,23,13) = (/ &
     &2.3107e+02_r8,1.7338e+02_r8,1.1569e+02_r8,5.8148e+01_r8,1.5847e+01_r8/)
      kbo(:, 3,23,13) = (/ &
     &3.0241e+02_r8,2.2689e+02_r8,1.5137e+02_r8,7.5851e+01_r8,1.5467e+01_r8/)
      kbo(:, 4,23,13) = (/ &
     &3.8349e+02_r8,2.8770e+02_r8,1.9191e+02_r8,9.6125e+01_r8,1.5066e+01_r8/)
      kbo(:, 5,23,13) = (/ &
     &4.7369e+02_r8,3.5535e+02_r8,2.3701e+02_r8,1.1867e+02_r8,1.4651e+01_r8/)
      kbo(:, 1,24,13) = (/ &
     &1.5057e+02_r8,1.1300e+02_r8,7.5436e+01_r8,4.0246e+01_r8,1.7609e+01_r8/)
      kbo(:, 2,24,13) = (/ &
     &2.0367e+02_r8,1.5283e+02_r8,1.0199e+02_r8,5.2083e+01_r8,1.7203e+01_r8/)
      kbo(:, 3,24,13) = (/ &
     &2.6558e+02_r8,1.9927e+02_r8,1.3295e+02_r8,6.6835e+01_r8,1.6770e+01_r8/)
      kbo(:, 4,24,13) = (/ &
     &3.3594e+02_r8,2.5203e+02_r8,1.6813e+02_r8,8.4226e+01_r8,1.6325e+01_r8/)
      kbo(:, 5,24,13) = (/ &
     &4.1379e+02_r8,3.1042e+02_r8,2.0705e+02_r8,1.0369e+02_r8,1.5864e+01_r8/)
      kbo(:, 1,25,13) = (/ &
     &1.3420e+02_r8,1.0073e+02_r8,6.7255e+01_r8,3.7941e+01_r8,1.8922e+01_r8/)
      kbo(:, 2,25,13) = (/ &
     &1.8061e+02_r8,1.3554e+02_r8,9.0464e+01_r8,4.7603e+01_r8,1.8471e+01_r8/)
      kbo(:, 3,25,13) = (/ &
     &2.3464e+02_r8,1.7606e+02_r8,1.1747e+02_r8,5.9840e+01_r8,1.7998e+01_r8/)
      kbo(:, 4,25,13) = (/ &
     &2.9580e+02_r8,2.2193e+02_r8,1.4806e+02_r8,7.4446e+01_r8,1.7506e+01_r8/)
      kbo(:, 5,25,13) = (/ &
     &3.6422e+02_r8,2.7325e+02_r8,1.8228e+02_r8,9.1309e+01_r8,1.6997e+01_r8/)
      kbo(:, 1,26,13) = (/ &
     &1.2114e+02_r8,9.0934e+01_r8,6.0946e+01_r8,3.6699e+01_r8,2.0129e+01_r8/)
      kbo(:, 2,26,13) = (/ &
     &1.6224e+02_r8,1.2175e+02_r8,8.1268e+01_r8,4.4540e+01_r8,1.9645e+01_r8/)
      kbo(:, 3,26,13) = (/ &
     &2.0993e+02_r8,1.5753e+02_r8,1.0512e+02_r8,5.4768e+01_r8,1.9134e+01_r8/)
      kbo(:, 4,26,13) = (/ &
     &2.6457e+02_r8,1.9850e+02_r8,1.3244e+02_r8,6.7280e+01_r8,1.8599e+01_r8/)
      kbo(:, 5,26,13) = (/ &
     &3.2617e+02_r8,2.4471e+02_r8,1.6326e+02_r8,8.2064e+01_r8,1.8043e+01_r8/)
      kbo(:, 1,27,13) = (/ &
     &1.1288e+02_r8,8.4731e+01_r8,5.7258e+01_r8,3.6591e+01_r8,2.1235e+01_r8/)
      kbo(:, 2,27,13) = (/ &
     &1.5040e+02_r8,1.1288e+02_r8,7.5447e+01_r8,4.3146e+01_r8,2.0722e+01_r8/)
      kbo(:, 3,27,13) = (/ &
     &1.9447e+02_r8,1.4593e+02_r8,9.7397e+01_r8,5.2019e+01_r8,2.0175e+01_r8/)
      kbo(:, 4,27,13) = (/ &
     &2.4522e+02_r8,1.8400e+02_r8,1.2279e+02_r8,6.3250e+01_r8,1.9596e+01_r8/)
      kbo(:, 5,27,13) = (/ &
     &3.0305e+02_r8,2.2738e+02_r8,1.5172e+02_r8,7.6751e+01_r8,1.8997e+01_r8/)
      kbo(:, 1,28,13) = (/ &
     &1.0746e+02_r8,8.0667e+01_r8,5.5081e+01_r8,3.7035e+01_r8,2.2229e+01_r8/)
      kbo(:, 2,28,13) = (/ &
     &1.4298e+02_r8,1.0731e+02_r8,7.1965e+01_r8,4.2784e+01_r8,2.1691e+01_r8/)
      kbo(:, 3,28,13) = (/ &
     &1.8493e+02_r8,1.3878e+02_r8,9.2649e+01_r8,5.0725e+01_r8,2.1105e+01_r8/)
      kbo(:, 4,28,13) = (/ &
     &2.3378e+02_r8,1.7543e+02_r8,1.1708e+02_r8,6.1166e+01_r8,2.0486e+01_r8/)
      kbo(:, 5,28,13) = (/ &
     &2.9002e+02_r8,2.1761e+02_r8,1.4521e+02_r8,7.3973e+01_r8,1.9841e+01_r8/)
      kbo(:, 1,29,13) = (/ &
     &1.0862e+02_r8,8.1537e+01_r8,5.6008e+01_r8,3.8525e+01_r8,2.3108e+01_r8/)
      kbo(:, 2,29,13) = (/ &
     &1.4451e+02_r8,1.0847e+02_r8,7.2927e+01_r8,4.4121e+01_r8,2.2541e+01_r8/)
      kbo(:, 3,29,13) = (/ &
     &1.8742e+02_r8,1.4066e+02_r8,9.3939e+01_r8,5.2003e+01_r8,2.1917e+01_r8/)
      kbo(:, 4,29,13) = (/ &
     &2.3814e+02_r8,1.7870e+02_r8,1.1927e+02_r8,6.2626e+01_r8,2.1254e+01_r8/)
      kbo(:, 5,29,13) = (/ &
     &2.9712e+02_r8,2.2294e+02_r8,1.4877e+02_r8,7.5955e+01_r8,2.0559e+01_r8/)
      kbo(:, 1,30,13) = (/ &
     &1.1263e+02_r8,8.4559e+01_r8,5.8240e+01_r8,4.0363e+01_r8,2.3867e+01_r8/)
      kbo(:, 2,30,13) = (/ &
     &1.5031e+02_r8,1.1283e+02_r8,7.5908e+01_r8,4.6135e+01_r8,2.3263e+01_r8/)
      kbo(:, 3,30,13) = (/ &
     &1.9606e+02_r8,1.4715e+02_r8,9.8280e+01_r8,5.4419e+01_r8,2.2598e+01_r8/)
      kbo(:, 4,30,13) = (/ &
     &2.5065e+02_r8,1.8809e+02_r8,1.2553e+02_r8,6.5875e+01_r8,2.1889e+01_r8/)
      kbo(:, 5,30,13) = (/ &
     &3.1497e+02_r8,2.3633e+02_r8,1.5769e+02_r8,8.0462e+01_r8,2.1149e+01_r8/)
      kbo(:, 1,31,13) = (/ &
     &1.2378e+02_r8,9.2930e+01_r8,6.3680e+01_r8,4.3209e+01_r8,2.4494e+01_r8/)
      kbo(:, 2,31,13) = (/ &
     &1.6598e+02_r8,1.2458e+02_r8,8.3650e+01_r8,4.9789e+01_r8,2.3857e+01_r8/)
      kbo(:, 3,31,13) = (/ &
     &2.1788e+02_r8,1.6351e+02_r8,1.0916e+02_r8,5.9548e+01_r8,2.3152e+01_r8/)
      kbo(:, 4,31,13) = (/ &
     &2.8056e+02_r8,2.1051e+02_r8,1.4048e+02_r8,7.3069e+01_r8,2.2400e+01_r8/)
      kbo(:, 5,31,13) = (/ &
     &3.5485e+02_r8,2.6624e+02_r8,1.7763e+02_r8,9.0172e+01_r8,2.1588e+01_r8/)
      kbo(:, 1,32,13) = (/ &
     &1.3906e+02_r8,1.0439e+02_r8,7.1039e+01_r8,4.6595e+01_r8,2.5004e+01_r8/)
      kbo(:, 2,32,13) = (/ &
     &1.8760e+02_r8,1.4080e+02_r8,9.4311e+01_r8,5.4496e+01_r8,2.4327e+01_r8/)
      kbo(:, 3,32,13) = (/ &
     &2.4774e+02_r8,1.8590e+02_r8,1.2408e+02_r8,6.6467e+01_r8,2.3584e+01_r8/)
      kbo(:, 4,32,13) = (/ &
     &3.2109e+02_r8,2.4091e+02_r8,1.6074e+02_r8,8.2698e+01_r8,2.2768e+01_r8/)
      kbo(:, 5,32,13) = (/ &
     &4.0872e+02_r8,3.0664e+02_r8,2.0456e+02_r8,1.0327e+02_r8,2.1879e+01_r8/)
      kbo(:, 1,33,13) = (/ &
     &1.6104e+02_r8,1.2087e+02_r8,8.1641e+01_r8,5.1002e+01_r8,2.5402e+01_r8/)
      kbo(:, 2,33,13) = (/ &
     &2.1845e+02_r8,1.6394e+02_r8,1.0954e+02_r8,6.1146e+01_r8,2.4688e+01_r8/)
      kbo(:, 3,33,13) = (/ &
     &2.9039e+02_r8,2.1789e+02_r8,1.4539e+02_r8,7.6233e+01_r8,2.3897e+01_r8/)
      kbo(:, 4,33,13) = (/ &
     &3.7885e+02_r8,2.8424e+02_r8,1.8963e+02_r8,9.6481e+01_r8,2.2987e+01_r8/)
      kbo(:, 5,33,13) = (/ &
     &4.8539e+02_r8,3.6414e+02_r8,2.4290e+02_r8,1.2206e+02_r8,2.2183e+01_r8/)
      kbo(:, 1,34,13) = (/ &
     &1.8189e+02_r8,1.3651e+02_r8,9.1768e+01_r8,5.5207e+01_r8,2.5729e+01_r8/)
      kbo(:, 2,34,13) = (/ &
     &2.4868e+02_r8,1.8660e+02_r8,1.2456e+02_r8,6.7745e+01_r8,2.4984e+01_r8/)
      kbo(:, 3,34,13) = (/ &
     &3.3298e+02_r8,2.4983e+02_r8,1.6669e+02_r8,8.6174e+01_r8,2.4083e+01_r8/)
      kbo(:, 4,34,13) = (/ &
     &4.3751e+02_r8,3.2823e+02_r8,2.1895e+02_r8,1.1064e+02_r8,2.3253e+01_r8/)
      kbo(:, 5,34,13) = (/ &
     &5.6416e+02_r8,4.2322e+02_r8,2.8227e+02_r8,1.4151e+02_r8,2.2432e+01_r8/)
      kbo(:, 1,35,13) = (/ &
     &2.0192e+02_r8,1.5153e+02_r8,1.0158e+02_r8,5.9346e+01_r8,2.6044e+01_r8/)
      kbo(:, 2,35,13) = (/ &
     &2.7880e+02_r8,2.0919e+02_r8,1.3960e+02_r8,7.4527e+01_r8,2.5204e+01_r8/)
      kbo(:, 3,35,13) = (/ &
     &3.7683e+02_r8,2.8271e+02_r8,1.8860e+02_r8,9.6532e+01_r8,2.4315e+01_r8/)
      kbo(:, 4,35,13) = (/ &
     &4.9906e+02_r8,3.7439e+02_r8,2.4972e+02_r8,1.2566e+02_r8,2.3549e+01_r8/)
      kbo(:, 5,35,13) = (/ &
     &6.4817e+02_r8,4.8622e+02_r8,3.2427e+02_r8,1.6242e+02_r8,2.2556e+01_r8/)
      kbo(:, 1,36,13) = (/ &
     &2.1718e+02_r8,1.6298e+02_r8,1.0911e+02_r8,6.2682e+01_r8,2.6372e+01_r8/)
      kbo(:, 2,36,13) = (/ &
     &3.0353e+02_r8,2.2773e+02_r8,1.5196e+02_r8,8.0255e+01_r8,2.5484e+01_r8/)
      kbo(:, 3,36,13) = (/ &
     &4.1487e+02_r8,3.1124e+02_r8,2.0762e+02_r8,1.0565e+02_r8,2.4690e+01_r8/)
      kbo(:, 4,36,13) = (/ &
     &5.5465e+02_r8,4.1607e+02_r8,2.7750e+02_r8,1.3934e+02_r8,2.3815e+01_r8/)
      kbo(:, 5,36,13) = (/ &
     &7.2608e+02_r8,5.4465e+02_r8,3.6322e+02_r8,1.8189e+02_r8,2.2654e+01_r8/)
      kbo(:, 1,37,13) = (/ &
     &2.1788e+02_r8,1.6349e+02_r8,1.0950e+02_r8,6.3289e+01_r8,2.6719e+01_r8/)
      kbo(:, 2,37,13) = (/ &
     &3.0912e+02_r8,2.3193e+02_r8,1.5476e+02_r8,8.1797e+01_r8,2.5860e+01_r8/)
      kbo(:, 3,37,13) = (/ &
     &4.2846e+02_r8,3.2142e+02_r8,2.1440e+02_r8,1.0906e+02_r8,2.5054e+01_r8/)
      kbo(:, 4,37,13) = (/ &
     &5.7982e+02_r8,4.3495e+02_r8,2.9008e+02_r8,1.4561e+02_r8,2.4158e+01_r8/)
      kbo(:, 5,37,13) = (/ &
     &7.6717e+02_r8,5.7546e+02_r8,3.8377e+02_r8,1.9217e+02_r8,2.2948e+01_r8/)
      kbo(:, 1,38,13) = (/ &
     &2.2254e+02_r8,1.6699e+02_r8,1.1184e+02_r8,6.4633e+01_r8,2.7030e+01_r8/)
      kbo(:, 2,38,13) = (/ &
     &3.2031e+02_r8,2.4031e+02_r8,1.6035e+02_r8,8.4610e+01_r8,2.6154e+01_r8/)
      kbo(:, 3,38,13) = (/ &
     &4.5000e+02_r8,3.3758e+02_r8,2.2517e+02_r8,1.1439e+02_r8,2.5377e+01_r8/)
      kbo(:, 4,38,13) = (/ &
     &6.1626e+02_r8,4.6228e+02_r8,3.0831e+02_r8,1.5466e+02_r8,2.4449e+01_r8/)
      kbo(:, 5,38,13) = (/ &
     &8.2391e+02_r8,6.1802e+02_r8,4.1215e+02_r8,2.0635e+02_r8,2.3228e+01_r8/)
      kbo(:, 1,39,13) = (/ &
     &2.3401e+02_r8,1.7560e+02_r8,1.1754e+02_r8,6.7259e+01_r8,2.7265e+01_r8/)
      kbo(:, 2,39,13) = (/ &
     &3.4141e+02_r8,2.5613e+02_r8,1.7089e+02_r8,8.9638e+01_r8,2.6464e+01_r8/)
      kbo(:, 3,39,13) = (/ &
     &4.8579e+02_r8,3.6442e+02_r8,2.4308e+02_r8,1.2315e+02_r8,2.5687e+01_r8/)
      kbo(:, 4,39,13) = (/ &
     &6.7297e+02_r8,5.0482e+02_r8,3.3668e+02_r8,1.6875e+02_r8,2.4654e+01_r8/)
      kbo(:, 5,39,13) = (/ &
     &9.0884e+02_r8,6.8173e+02_r8,4.5462e+02_r8,2.2758e+02_r8,2.3620e+01_r8/)
      kbo(:, 1,40,13) = (/ &
     &2.2310e+02_r8,1.6742e+02_r8,1.1224e+02_r8,6.5625e+01_r8,2.7589e+01_r8/)
      kbo(:, 2,40,13) = (/ &
     &3.3051e+02_r8,2.4796e+02_r8,1.6546e+02_r8,8.7436e+01_r8,2.6816e+01_r8/)
      kbo(:, 3,40,13) = (/ &
     &4.7705e+02_r8,3.5787e+02_r8,2.3871e+02_r8,1.2127e+02_r8,2.6052e+01_r8/)
      kbo(:, 4,40,13) = (/ &
     &6.7033e+02_r8,5.0284e+02_r8,3.3536e+02_r8,1.6816e+02_r8,2.5038e+01_r8/)
      kbo(:, 5,40,13) = (/ &
     &9.1616e+02_r8,6.8722e+02_r8,4.5828e+02_r8,2.2941e+02_r8,2.4007e+01_r8/)
      kbo(:, 1,41,13) = (/ &
     &2.1165e+02_r8,1.5884e+02_r8,1.0674e+02_r8,6.4017e+01_r8,2.7888e+01_r8/)
      kbo(:, 2,41,13) = (/ &
     &3.1819e+02_r8,2.3873e+02_r8,1.5932e+02_r8,8.5003e+01_r8,2.7118e+01_r8/)
      kbo(:, 3,41,13) = (/ &
     &4.6591e+02_r8,3.4951e+02_r8,2.3314e+02_r8,1.1880e+02_r8,2.6396e+01_r8/)
      kbo(:, 4,41,13) = (/ &
     &6.6349e+02_r8,4.9771e+02_r8,3.3195e+02_r8,1.6656e+02_r8,2.5465e+01_r8/)
      kbo(:, 5,41,13) = (/ &
     &9.1847e+02_r8,6.8895e+02_r8,4.5944e+02_r8,2.3000e+02_r8,2.4337e+01_r8/)
      kbo(:, 1,42,13) = (/ &
     &2.0335e+02_r8,1.5260e+02_r8,1.0282e+02_r8,6.3023e+01_r8,2.8153e+01_r8/)
      kbo(:, 2,42,13) = (/ &
     &3.1003e+02_r8,2.3260e+02_r8,1.5524e+02_r8,8.3539e+01_r8,2.7395e+01_r8/)
      kbo(:, 3,42,13) = (/ &
     &4.6024e+02_r8,3.4526e+02_r8,2.3031e+02_r8,1.1765e+02_r8,2.6718e+01_r8/)
      kbo(:, 4,42,13) = (/ &
     &6.6381e+02_r8,4.9795e+02_r8,3.3210e+02_r8,1.6673e+02_r8,2.5846e+01_r8/)
      kbo(:, 5,42,13) = (/ &
     &9.3041e+02_r8,6.9790e+02_r8,4.6540e+02_r8,2.3298e+02_r8,2.4647e+01_r8/)
      kbo(:, 1,43,13) = (/ &
     &1.9244e+02_r8,1.4443e+02_r8,9.7744e+01_r8,6.1682e+01_r8,2.8431e+01_r8/)
      kbo(:, 2,43,13) = (/ &
     &2.9785e+02_r8,2.2347e+02_r8,1.4920e+02_r8,8.1276e+01_r8,2.7711e+01_r8/)
      kbo(:, 3,43,13) = (/ &
     &4.4872e+02_r8,3.3663e+02_r8,2.2458e+02_r8,1.1517e+02_r8,2.7073e+01_r8/)
      kbo(:, 4,43,13) = (/ &
     &6.5646e+02_r8,4.9243e+02_r8,3.2842e+02_r8,1.6500e+02_r8,2.6290e+01_r8/)
      kbo(:, 5,43,13) = (/ &
     &9.3268e+02_r8,6.9961e+02_r8,4.6654e+02_r8,2.3355e+02_r8,2.5000e+01_r8/)
      kbo(:, 1,44,13) = (/ &
     &1.8195e+02_r8,1.3656e+02_r8,9.2955e+01_r8,6.0559e+01_r8,2.8683e+01_r8/)
      kbo(:, 2,44,13) = (/ &
     &2.8673e+02_r8,2.1514e+02_r8,1.4371e+02_r8,7.9343e+01_r8,2.8022e+01_r8/)
      kbo(:, 3,44,13) = (/ &
     &4.3845e+02_r8,3.2893e+02_r8,2.1944e+02_r8,1.1299e+02_r8,2.7430e+01_r8/)
      kbo(:, 4,44,13) = (/ &
     &6.5082e+02_r8,4.8820e+02_r8,3.2560e+02_r8,1.6371e+02_r8,2.6724e+01_r8/)
      kbo(:, 5,44,13) = (/ &
     &9.3739e+02_r8,7.0313e+02_r8,4.6889e+02_r8,2.3472e+02_r8,2.5409e+01_r8/)
      kbo(:, 1,45,13) = (/ &
     &1.7490e+02_r8,1.3128e+02_r8,8.9889e+01_r8,6.0087e+01_r8,2.8892e+01_r8/)
      kbo(:, 2,45,13) = (/ &
     &2.8115e+02_r8,2.1096e+02_r8,1.4101e+02_r8,7.8697e+01_r8,2.8297e+01_r8/)
      kbo(:, 3,45,13) = (/ &
     &4.3612e+02_r8,3.2718e+02_r8,2.1828e+02_r8,1.1266e+02_r8,2.7806e+01_r8/)
      kbo(:, 4,45,13) = (/ &
     &6.5668e+02_r8,4.9260e+02_r8,3.2854e+02_r8,1.6526e+02_r8,2.7097e+01_r8/)
      kbo(:, 5,45,13) = (/ &
     &9.5876e+02_r8,7.1917e+02_r8,4.7958e+02_r8,2.4006e+02_r8,2.5776e+01_r8/)
      kbo(:, 1,46,13) = (/ &
     &1.6728e+02_r8,1.2556e+02_r8,8.6592e+01_r8,5.9568e+01_r8,2.9082e+01_r8/)
      kbo(:, 2,46,13) = (/ &
     &2.7457e+02_r8,2.0602e+02_r8,1.3784e+02_r8,7.7967e+01_r8,2.8545e+01_r8/)
      kbo(:, 3,46,13) = (/ &
     &4.3313e+02_r8,3.2494e+02_r8,2.1678e+02_r8,1.1222e+02_r8,2.8139e+01_r8/)
      kbo(:, 4,46,13) = (/ &
     &6.6163e+02_r8,4.9632e+02_r8,3.3103e+02_r8,1.6658e+02_r8,2.7449e+01_r8/)
      kbo(:, 5,46,13) = (/ &
     &9.8004e+02_r8,7.3512e+02_r8,4.9021e+02_r8,2.4539e+02_r8,2.6122e+01_r8/)
      kbo(:, 1,47,13) = (/ &
     &1.5431e+02_r8,1.1585e+02_r8,8.0931e+01_r8,5.8232e+01_r8,2.9262e+01_r8/)
      kbo(:, 2,47,13) = (/ &
     &2.5885e+02_r8,1.9423e+02_r8,1.3026e+02_r8,7.5643e+01_r8,2.8798e+01_r8/)
      kbo(:, 3,47,13) = (/ &
     &4.1682e+02_r8,3.1271e+02_r8,2.0862e+02_r8,1.0877e+02_r8,2.8446e+01_r8/)
      kbo(:, 4,47,13) = (/ &
     &6.4684e+02_r8,4.8523e+02_r8,3.2363e+02_r8,1.6308e+02_r8,2.7814e+01_r8/)
      kbo(:, 5,47,13) = (/ &
     &9.7279e+02_r8,7.2968e+02_r8,4.8659e+02_r8,2.4359e+02_r8,2.6548e+01_r8/)
      kbo(:, 1,48,13) = (/ &
     &1.4538e+02_r8,1.0915e+02_r8,7.7289e+01_r8,5.7662e+01_r8,2.9351e+01_r8/)
      kbo(:, 2,48,13) = (/ &
     &2.4931e+02_r8,1.8708e+02_r8,1.2577e+02_r8,7.4691e+01_r8,2.8998e+01_r8/)
      kbo(:, 3,48,13) = (/ &
     &4.1014e+02_r8,3.0770e+02_r8,2.0528e+02_r8,1.0766e+02_r8,2.8726e+01_r8/)
      kbo(:, 4,48,13) = (/ &
     &6.4756e+02_r8,4.8577e+02_r8,3.2399e+02_r8,1.6338e+02_r8,2.8115e+01_r8/)
      kbo(:, 5,48,13) = (/ &
     &9.8831e+02_r8,7.4133e+02_r8,4.9436e+02_r8,2.4748e+02_r8,2.6944e+01_r8/)
      kbo(:, 1,49,13) = (/ &
     &1.4120e+02_r8,1.0604e+02_r8,7.5941e+01_r8,5.8065e+01_r8,2.9380e+01_r8/)
      kbo(:, 2,49,13) = (/ &
     &2.4862e+02_r8,1.8657e+02_r8,1.2564e+02_r8,7.5519e+01_r8,2.9233e+01_r8/)
      kbo(:, 3,49,13) = (/ &
     &4.1758e+02_r8,3.1328e+02_r8,2.0900e+02_r8,1.0986e+02_r8,2.8989e+01_r8/)
      kbo(:, 4,49,13) = (/ &
     &6.7203e+02_r8,5.0412e+02_r8,3.3622e+02_r8,1.6950e+02_r8,2.8333e+01_r8/)
      kbo(:, 5,49,13) = (/ &
     &1.0415e+03_r8,7.8124e+02_r8,5.2096e+02_r8,2.6077e+02_r8,2.7256e+01_r8/)
      kbo(:, 1,50,13) = (/ &
     &1.3115e+02_r8,9.8605e+01_r8,7.2172e+01_r8,5.7503e+01_r8,2.9363e+01_r8/)
      kbo(:, 2,50,13) = (/ &
     &2.3790e+02_r8,1.7854e+02_r8,1.2070e+02_r8,7.4407e+01_r8,2.9364e+01_r8/)
      kbo(:, 3,50,13) = (/ &
     &4.0744e+02_r8,3.0568e+02_r8,2.0394e+02_r8,1.0804e+02_r8,2.9149e+01_r8/)
      kbo(:, 4,50,13) = (/ &
     &6.6872e+02_r8,5.0163e+02_r8,3.3456e+02_r8,1.6889e+02_r8,2.8599e+01_r8/)
      kbo(:, 5,50,13) = (/ &
     &1.0519e+03_r8,7.8905e+02_r8,5.2618e+02_r8,2.6337e+02_r8,2.7606e+01_r8/)
      kbo(:, 1,51,13) = (/ &
     &1.1865e+02_r8,8.9445e+01_r8,6.7680e+01_r8,5.6587e+01_r8,2.9290e+01_r8/)
      kbo(:, 2,51,13) = (/ &
     &2.2216e+02_r8,1.6674e+02_r8,1.1346e+02_r8,7.2415e+01_r8,2.9435e+01_r8/)
      kbo(:, 3,51,13) = (/ &
     &3.8895e+02_r8,2.9182e+02_r8,1.9472e+02_r8,1.0439e+02_r8,2.9207e+01_r8/)
      kbo(:, 4,51,13) = (/ &
     &6.5048e+02_r8,4.8795e+02_r8,3.2544e+02_r8,1.6473e+02_r8,2.8819e+01_r8/)
      kbo(:, 5,51,13) = (/ &
     &1.0401e+03_r8,7.8020e+02_r8,5.2027e+02_r8,2.6042e+02_r8,2.7943e+01_r8/)
      kbo(:, 1,52,13) = (/ &
     &1.0900e+02_r8,8.2517e+01_r8,6.4683e+01_r8,5.6184e+01_r8,2.9159e+01_r8/)
      kbo(:, 2,52,13) = (/ &
     &2.1154e+02_r8,1.5879e+02_r8,1.0876e+02_r8,7.1453e+01_r8,2.9466e+01_r8/)
      kbo(:, 3,52,13) = (/ &
     &3.8014e+02_r8,2.8522e+02_r8,1.9038e+02_r8,1.0306e+02_r8,2.9320e+01_r8/)
      kbo(:, 4,52,13) = (/ &
     &6.4723e+02_r8,4.8552e+02_r8,3.2381e+02_r8,1.6425e+02_r8,2.8993e+01_r8/)
      kbo(:, 5,52,13) = (/ &
     &1.0537e+03_r8,7.9041e+02_r8,5.2708e+02_r8,2.6382e+02_r8,2.8208e+01_r8/)
      kbo(:, 1,53,13) = (/ &
     &1.0283e+02_r8,7.8224e+01_r8,6.3272e+01_r8,5.6425e+01_r8,2.8966e+01_r8/)
      kbo(:, 2,53,13) = (/ &
     &2.0760e+02_r8,1.5584e+02_r8,1.0728e+02_r8,7.1858e+01_r8,2.9467e+01_r8/)
      kbo(:, 3,53,13) = (/ &
     &3.8429e+02_r8,2.8834e+02_r8,1.9251e+02_r8,1.0470e+02_r8,2.9381e+01_r8/)
      kbo(:, 4,53,13) = (/ &
     &6.6697e+02_r8,5.0033e+02_r8,3.3369e+02_r8,1.6926e+02_r8,2.9144e+01_r8/)
      kbo(:, 5,53,13) = (/ &
     &1.1061e+03_r8,8.2971e+02_r8,5.5328e+02_r8,2.7691e+02_r8,2.8402e+01_r8/)
      kbo(:, 1,54,13) = (/ &
     &8.4612e+01_r8,6.5337e+01_r8,5.7223e+01_r8,5.4259e+01_r8,2.8744e+01_r8/)
      kbo(:, 2,54,13) = (/ &
     &1.7755e+02_r8,1.3329e+02_r8,9.3740e+01_r8,6.7487e+01_r8,2.9376e+01_r8/)
      kbo(:, 3,54,13) = (/ &
     &3.3886e+02_r8,2.5427e+02_r8,1.7017e+02_r8,9.5886e+01_r8,2.9463e+01_r8/)
      kbo(:, 4,54,13) = (/ &
     &6.0067e+02_r8,4.5060e+02_r8,3.0055e+02_r8,1.5369e+02_r8,2.9315e+01_r8/)
      kbo(:, 5,54,13) = (/ &
     &1.0127e+03_r8,7.5962e+02_r8,5.0655e+02_r8,2.5368e+02_r8,2.8705e+01_r8/)
      kbo(:, 1,55,13) = (/ &
     &6.3387e+01_r8,5.0935e+01_r8,5.0168e+01_r8,5.0996e+01_r8,2.8487e+01_r8/)
      kbo(:, 2,55,13) = (/ &
     &1.3831e+02_r8,1.0410e+02_r8,7.7011e+01_r8,6.1667e+01_r8,2.9169e+01_r8/)
      kbo(:, 3,55,13) = (/ &
     &2.7282e+02_r8,2.0475e+02_r8,1.3822e+02_r8,8.3541e+01_r8,2.9521e+01_r8/)
      kbo(:, 4,55,13) = (/ &
     &4.9509e+02_r8,3.7143e+02_r8,2.4779e+02_r8,1.2925e+02_r8,2.9355e+01_r8/)
      kbo(:, 5,55,13) = (/ &
     &8.4764e+02_r8,6.3583e+02_r8,4.2402e+02_r8,2.1299e+02_r8,2.9013e+01_r8/)
      kbo(:, 1,56,13) = (/ &
     &4.6914e+01_r8,4.0782e+01_r8,4.5015e+01_r8,4.7952e+01_r8,2.8186e+01_r8/)
      kbo(:, 2,56,13) = (/ &
     &1.0661e+02_r8,8.1027e+01_r8,6.4934e+01_r8,5.7313e+01_r8,2.9008e+01_r8/)
      kbo(:, 3,56,13) = (/ &
     &2.1790e+02_r8,1.6356e+02_r8,1.1223e+02_r8,7.3951e+01_r8,2.9460e+01_r8/)
      kbo(:, 4,56,13) = (/ &
     &4.0585e+02_r8,3.0451e+02_r8,2.0325e+02_r8,1.0953e+02_r8,2.9455e+01_r8/)
      kbo(:, 5,56,13) = (/ &
     &7.0659e+02_r8,5.3004e+02_r8,3.5349e+02_r8,1.7883e+02_r8,2.9213e+01_r8/)
      kbo(:, 1,57,13) = (/ &
     &3.4230e+01_r8,3.3758e+01_r8,4.1164e+01_r8,4.5068e+01_r8,2.7829e+01_r8/)
      kbo(:, 2,57,13) = (/ &
     &8.1249e+01_r8,6.3007e+01_r8,5.6061e+01_r8,5.3761e+01_r8,2.8811e+01_r8/)
      kbo(:, 3,57,13) = (/ &
     &1.7223e+02_r8,1.2931e+02_r8,9.1411e+01_r8,6.6606e+01_r8,2.9335e+01_r8/)
      kbo(:, 4,57,13) = (/ &
     &3.3026e+02_r8,2.4783e+02_r8,1.6598e+02_r8,9.4193e+01_r8,2.9500e+01_r8/)
      kbo(:, 5,57,13) = (/ &
     &5.8636e+02_r8,4.3987e+02_r8,2.9340e+02_r8,1.5031e+02_r8,2.9335e+01_r8/)
      kbo(:, 1,58,13) = (/ &
     &6.5933e+00_r8,9.4893e+00_r8,1.6089e+01_r8,2.5300e+01_r8,2.7425e+01_r8/)
      kbo(:, 2,58,13) = (/ &
     &1.6360e+01_r8,1.6224e+01_r8,2.0957e+01_r8,3.0182e+01_r8,2.8583e+01_r8/)
      kbo(:, 3,58,13) = (/ &
     &3.5957e+01_r8,3.3123e+01_r8,3.1853e+01_r8,3.6291e+01_r8,2.9233e+01_r8/)
      kbo(:, 4,58,13) = (/ &
     &7.1076e+01_r8,6.5212e+01_r8,5.6746e+01_r8,4.8699e+01_r8,2.9472e+01_r8/)
      kbo(:, 5,58,13) = (/ &
     &1.2897e+02_r8,1.1828e+02_r8,1.0149e+02_r8,7.4519e+01_r8,2.9400e+01_r8/)
      kbo(:, 1,59,13) = (/ &
     &6.7458e+00_r8,1.2021e+01_r8,2.0178e+01_r8,2.9391e+01_r8,2.7237e+01_r8/)
      kbo(:, 2,59,13) = (/ &
     &1.7109e+01_r8,1.8183e+01_r8,2.5274e+01_r8,3.4440e+01_r8,2.8519e+01_r8/)
      kbo(:, 3,59,13) = (/ &
     &3.8233e+01_r8,3.4158e+01_r8,3.4619e+01_r8,4.0204e+01_r8,2.9240e+01_r8/)
      kbo(:, 4,59,13) = (/ &
     &7.6647e+01_r8,6.6998e+01_r8,5.6073e+01_r8,4.9489e+01_r8,2.9509e+01_r8/)
      kbo(:, 5,59,13) = (/ &
     &1.4043e+02_r8,1.2268e+02_r8,9.8230e+01_r8,6.8889e+01_r8,2.9402e+01_r8/)
      kbo(:, 1,13,14) = (/ &
     &2.1776e+03_r8,1.6333e+03_r8,1.0891e+03_r8,5.4478e+02_r8,7.3262e+00_r8/)
      kbo(:, 2,13,14) = (/ &
     &3.1101e+03_r8,2.3327e+03_r8,1.5553e+03_r8,7.7788e+02_r8,7.3124e+00_r8/)
      kbo(:, 3,13,14) = (/ &
     &4.2249e+03_r8,3.1687e+03_r8,2.1126e+03_r8,1.0565e+03_r8,7.2480e+00_r8/)
      kbo(:, 4,13,14) = (/ &
     &5.5118e+03_r8,4.1339e+03_r8,2.7561e+03_r8,1.3783e+03_r8,7.1568e+00_r8/)
      kbo(:, 5,13,14) = (/ &
     &6.9506e+03_r8,5.2131e+03_r8,3.4755e+03_r8,1.7380e+03_r8,7.0367e+00_r8/)
      kbo(:, 1,14,14) = (/ &
     &1.4496e+03_r8,1.0873e+03_r8,7.2501e+02_r8,3.6272e+02_r8,8.3339e+00_r8/)
      kbo(:, 2,14,14) = (/ &
     &2.0734e+03_r8,1.5551e+03_r8,1.0369e+03_r8,5.1863e+02_r8,8.2705e+00_r8/)
      kbo(:, 3,14,14) = (/ &
     &2.8238e+03_r8,2.1179e+03_r8,1.4121e+03_r8,7.0623e+02_r8,8.1703e+00_r8/)
      kbo(:, 4,14,14) = (/ &
     &3.6841e+03_r8,2.7632e+03_r8,1.8422e+03_r8,9.2131e+02_r8,8.0387e+00_r8/)
      kbo(:, 5,14,14) = (/ &
     &4.6457e+03_r8,3.4843e+03_r8,2.3230e+03_r8,1.1617e+03_r8,7.8896e+00_r8/)
      kbo(:, 1,15,14) = (/ &
     &9.9772e+02_r8,7.4839e+02_r8,4.9906e+02_r8,2.4972e+02_r8,9.4242e+00_r8/)
      kbo(:, 2,15,14) = (/ &
     &1.4271e+03_r8,1.0704e+03_r8,7.1374e+02_r8,3.5707e+02_r8,9.3124e+00_r8/)
      kbo(:, 3,15,14) = (/ &
     &1.9364e+03_r8,1.4524e+03_r8,9.6841e+02_r8,4.8440e+02_r8,9.1590e+00_r8/)
      kbo(:, 4,15,14) = (/ &
     &2.5268e+03_r8,1.8952e+03_r8,1.2636e+03_r8,6.3198e+02_r8,8.9837e+00_r8/)
      kbo(:, 5,15,14) = (/ &
     &3.1888e+03_r8,2.3917e+03_r8,1.5946e+03_r8,7.9748e+02_r8,8.7913e+00_r8/)
      kbo(:, 1,16,14) = (/ &
     &8.2535e+02_r8,6.1910e+02_r8,4.1286e+02_r8,2.0662e+02_r8,1.0617e+01_r8/)
      kbo(:, 2,16,14) = (/ &
     &1.1765e+03_r8,8.8250e+02_r8,5.8845e+02_r8,2.9441e+02_r8,1.0441e+01_r8/)
      kbo(:, 3,16,14) = (/ &
     &1.5988e+03_r8,1.1992e+03_r8,7.9956e+02_r8,3.9995e+02_r8,1.0240e+01_r8/)
      kbo(:, 4,16,14) = (/ &
     &2.0853e+03_r8,1.5640e+03_r8,1.0428e+03_r8,5.2160e+02_r8,1.0022e+01_r8/)
      kbo(:, 5,16,14) = (/ &
     &2.6260e+03_r8,1.9696e+03_r8,1.3132e+03_r8,6.5679e+02_r8,9.7853e+00_r8/)
      kbo(:, 1,17,14) = (/ &
     &7.1446e+02_r8,5.3593e+02_r8,3.5740e+02_r8,1.7888e+02_r8,1.1902e+01_r8/)
      kbo(:, 2,17,14) = (/ &
     &1.0170e+03_r8,7.6281e+02_r8,5.0866e+02_r8,2.5450e+02_r8,1.1678e+01_r8/)
      kbo(:, 3,17,14) = (/ &
     &1.3782e+03_r8,1.0338e+03_r8,6.8929e+02_r8,3.4482e+02_r8,1.1434e+01_r8/)
      kbo(:, 4,17,14) = (/ &
     &1.7913e+03_r8,1.3436e+03_r8,8.9585e+02_r8,4.4810e+02_r8,1.1160e+01_r8/)
      kbo(:, 5,17,14) = (/ &
     &2.2531e+03_r8,1.6899e+03_r8,1.1267e+03_r8,5.6354e+02_r8,1.0872e+01_r8/)
      kbo(:, 1,18,14) = (/ &
     &6.3627e+02_r8,4.7728e+02_r8,3.1830e+02_r8,1.5932e+02_r8,1.3306e+01_r8/)
      kbo(:, 2,18,14) = (/ &
     &9.0279e+02_r8,6.7718e+02_r8,4.5157e+02_r8,2.2596e+02_r8,1.3021e+01_r8/)
      kbo(:, 3,18,14) = (/ &
     &1.2176e+03_r8,9.1326e+02_r8,6.0896e+02_r8,3.0466e+02_r8,1.2705e+01_r8/)
      kbo(:, 4,18,14) = (/ &
     &1.5793e+03_r8,1.1846e+03_r8,7.8983e+02_r8,3.9509e+02_r8,1.2374e+01_r8/)
      kbo(:, 5,18,14) = (/ &
     &1.9821e+03_r8,1.4867e+03_r8,9.9125e+02_r8,4.9580e+02_r8,1.2038e+01_r8/)
      kbo(:, 1,19,14) = (/ &
     &5.5701e+02_r8,4.1784e+02_r8,2.7868e+02_r8,1.3951e+02_r8,1.4835e+01_r8/)
      kbo(:, 2,19,14) = (/ &
     &7.8555e+02_r8,5.8924e+02_r8,3.9294e+02_r8,1.9665e+02_r8,1.4471e+01_r8/)
      kbo(:, 3,19,14) = (/ &
     &1.0565e+03_r8,7.9246e+02_r8,5.2842e+02_r8,2.6438e+02_r8,1.4088e+01_r8/)
      kbo(:, 4,19,14) = (/ &
     &1.3666e+03_r8,1.0251e+03_r8,6.8348e+02_r8,3.4191e+02_r8,1.3700e+01_r8/)
      kbo(:, 5,19,14) = (/ &
     &1.7097e+03_r8,1.2824e+03_r8,8.5504e+02_r8,4.2769e+02_r8,1.3330e+01_r8/)
      kbo(:, 1,20,14) = (/ &
     &5.2902e+02_r8,3.9685e+02_r8,2.6468e+02_r8,1.3251e+02_r8,1.6461e+01_r8/)
      kbo(:, 2,20,14) = (/ &
     &7.4221e+02_r8,5.5674e+02_r8,3.7128e+02_r8,1.8581e+02_r8,1.6028e+01_r8/)
      kbo(:, 3,20,14) = (/ &
     &9.9413e+02_r8,7.4568e+02_r8,4.9723e+02_r8,2.4879e+02_r8,1.5588e+01_r8/)
      kbo(:, 4,20,14) = (/ &
     &1.2802e+03_r8,9.6022e+02_r8,6.4026e+02_r8,3.2030e+02_r8,1.5170e+01_r8/)
      kbo(:, 5,20,14) = (/ &
     &1.5959e+03_r8,1.1970e+03_r8,7.9814e+02_r8,3.9924e+02_r8,1.4766e+01_r8/)
      kbo(:, 1,21,14) = (/ &
     &5.1643e+02_r8,3.8740e+02_r8,2.5838e+02_r8,1.2935e+02_r8,1.8266e+01_r8/)
      kbo(:, 2,21,14) = (/ &
     &7.2079e+02_r8,5.4067e+02_r8,3.6056e+02_r8,1.8045e+02_r8,1.7763e+01_r8/)
      kbo(:, 3,21,14) = (/ &
     &9.5965e+02_r8,7.1982e+02_r8,4.7999e+02_r8,2.4017e+02_r8,1.7272e+01_r8/)
      kbo(:, 4,21,14) = (/ &
     &1.2302e+03_r8,9.2274e+02_r8,6.1527e+02_r8,3.0781e+02_r8,1.6803e+01_r8/)
      kbo(:, 5,21,14) = (/ &
     &1.5280e+03_r8,1.1461e+03_r8,7.6416e+02_r8,3.8225e+02_r8,1.6348e+01_r8/)
      kbo(:, 1,22,14) = (/ &
     &5.2623e+02_r8,3.9475e+02_r8,2.6327e+02_r8,1.3179e+02_r8,2.0243e+01_r8/)
      kbo(:, 2,22,14) = (/ &
     &7.2644e+02_r8,5.4491e+02_r8,3.6339e+02_r8,1.8186e+02_r8,1.9664e+01_r8/)
      kbo(:, 3,22,14) = (/ &
     &9.5925e+02_r8,7.1952e+02_r8,4.7979e+02_r8,2.4006e+02_r8,1.9116e+01_r8/)
      kbo(:, 4,22,14) = (/ &
     &1.2211e+03_r8,9.1590e+02_r8,6.1071e+02_r8,3.0553e+02_r8,1.8593e+01_r8/)
      kbo(:, 5,22,14) = (/ &
     &1.5078e+03_r8,1.1310e+03_r8,7.5409e+02_r8,3.7722e+02_r8,1.8080e+01_r8/)
      kbo(:, 1,23,14) = (/ &
     &5.3158e+02_r8,3.9876e+02_r8,2.6595e+02_r8,1.3313e+02_r8,2.2446e+01_r8/)
      kbo(:, 2,23,14) = (/ &
     &7.2667e+02_r8,5.4508e+02_r8,3.6349e+02_r8,1.8191e+02_r8,2.1789e+01_r8/)
      kbo(:, 3,23,14) = (/ &
     &9.5159e+02_r8,7.1378e+02_r8,4.7596e+02_r8,2.3814e+02_r8,2.1156e+01_r8/)
      kbo(:, 4,23,14) = (/ &
     &1.2042e+03_r8,9.0323e+02_r8,6.0227e+02_r8,3.0131e+02_r8,2.0541e+01_r8/)
      kbo(:, 5,23,14) = (/ &
     &1.4791e+03_r8,1.1094e+03_r8,7.3972e+02_r8,3.7004e+02_r8,1.9936e+01_r8/)
      kbo(:, 1,24,14) = (/ &
     &5.2674e+02_r8,3.9513e+02_r8,2.6351e+02_r8,1.3189e+02_r8,2.4861e+01_r8/)
      kbo(:, 2,24,14) = (/ &
     &7.1320e+02_r8,5.3497e+02_r8,3.5675e+02_r8,1.7852e+02_r8,2.4105e+01_r8/)
      kbo(:, 3,24,14) = (/ &
     &9.2799e+02_r8,6.9608e+02_r8,4.6416e+02_r8,2.3224e+02_r8,2.3357e+01_r8/)
      kbo(:, 4,24,14) = (/ &
     &1.1676e+03_r8,8.7581e+02_r8,5.8399e+02_r8,2.9218e+02_r8,2.2617e+01_r8/)
      kbo(:, 5,24,14) = (/ &
     &1.4298e+03_r8,1.0724e+03_r8,7.1508e+02_r8,3.5774e+02_r8,2.1888e+01_r8/)
      kbo(:, 1,25,14) = (/ &
     &5.2185e+02_r8,3.9145e+02_r8,2.6105e+02_r8,1.3066e+02_r8,2.7396e+01_r8/)
      kbo(:, 2,25,14) = (/ &
     &7.0140e+02_r8,5.2612e+02_r8,3.5084e+02_r8,1.7556e+02_r8,2.6509e+01_r8/)
      kbo(:, 3,25,14) = (/ &
     &9.0713e+02_r8,6.8043e+02_r8,4.5373e+02_r8,2.2703e+02_r8,2.5618e+01_r8/)
      kbo(:, 4,25,14) = (/ &
     &1.1371e+03_r8,8.5288e+02_r8,5.6870e+02_r8,2.8453e+02_r8,2.4730e+01_r8/)
      kbo(:, 5,25,14) = (/ &
     &1.3891e+03_r8,1.0419e+03_r8,6.9474e+02_r8,3.4757e+02_r8,2.3860e+01_r8/)
      kbo(:, 1,26,14) = (/ &
     &5.2251e+02_r8,3.9195e+02_r8,2.6138e+02_r8,1.3085e+02_r8,2.9927e+01_r8/)
      kbo(:, 2,26,14) = (/ &
     &6.9730e+02_r8,5.2305e+02_r8,3.4880e+02_r8,1.7455e+02_r8,2.8877e+01_r8/)
      kbo(:, 3,26,14) = (/ &
     &8.9735e+02_r8,6.7309e+02_r8,4.4884e+02_r8,2.2459e+02_r8,2.7820e+01_r8/)
      kbo(:, 4,26,14) = (/ &
     &1.1213e+03_r8,8.4105e+02_r8,5.6081e+02_r8,2.8058e+02_r8,2.6772e+01_r8/)
      kbo(:, 5,26,14) = (/ &
     &1.3665e+03_r8,1.0250e+03_r8,6.8346e+02_r8,3.4192e+02_r8,2.5741e+01_r8/)
      kbo(:, 1,27,14) = (/ &
     &5.3834e+02_r8,4.0383e+02_r8,2.6931e+02_r8,1.3510e+02_r8,3.2357e+01_r8/)
      kbo(:, 2,27,14) = (/ &
     &7.1439e+02_r8,5.3587e+02_r8,3.5735e+02_r8,1.7883e+02_r8,3.1116e+01_r8/)
      kbo(:, 3,27,14) = (/ &
     &9.1626e+02_r8,6.8728e+02_r8,4.5830e+02_r8,2.2932e+02_r8,2.9881e+01_r8/)
      kbo(:, 4,27,14) = (/ &
     &1.1424e+03_r8,8.5692e+02_r8,5.7140e+02_r8,2.8587e+02_r8,2.8666e+01_r8/)
      kbo(:, 5,27,14) = (/ &
     &1.3901e+03_r8,1.0427e+03_r8,6.9525e+02_r8,3.4781e+02_r8,2.7467e+01_r8/)
      kbo(:, 1,28,14) = (/ &
     &5.6592e+02_r8,4.2451e+02_r8,2.8310e+02_r8,1.4237e+02_r8,3.4583e+01_r8/)
      kbo(:, 2,28,14) = (/ &
     &7.4785e+02_r8,5.6096e+02_r8,3.7408e+02_r8,1.8720e+02_r8,3.3140e+01_r8/)
      kbo(:, 3,28,14) = (/ &
     &9.5690e+02_r8,7.1776e+02_r8,4.7862e+02_r8,2.3947e+02_r8,3.1724e+01_r8/)
      kbo(:, 4,28,14) = (/ &
     &1.1915e+03_r8,8.9371e+02_r8,5.9592e+02_r8,2.9814e+02_r8,3.0340e+01_r8/)
      kbo(:, 5,28,14) = (/ &
     &1.4480e+03_r8,1.0861e+03_r8,7.2421e+02_r8,3.6229e+02_r8,2.8988e+01_r8/)
      kbo(:, 1,29,14) = (/ &
     &6.3031e+02_r8,4.7280e+02_r8,3.1529e+02_r8,1.5867e+02_r8,3.6546e+01_r8/)
      kbo(:, 2,29,14) = (/ &
     &8.3056e+02_r8,6.2300e+02_r8,4.1543e+02_r8,2.0788e+02_r8,3.4912e+01_r8/)
      kbo(:, 3,29,14) = (/ &
     &1.0608e+03_r8,7.9566e+02_r8,5.3055e+02_r8,2.6544e+02_r8,3.3320e+01_r8/)
      kbo(:, 4,29,14) = (/ &
     &1.3185e+03_r8,9.8899e+02_r8,6.5945e+02_r8,3.2990e+02_r8,3.1769e+01_r8/)
      kbo(:, 5,29,14) = (/ &
     &1.6020e+03_r8,1.2016e+03_r8,8.0116e+02_r8,4.0076e+02_r8,3.0274e+01_r8/)
      kbo(:, 1,30,14) = (/ &
     &7.1878e+02_r8,5.3916e+02_r8,3.5953e+02_r8,1.8082e+02_r8,3.8231e+01_r8/)
      kbo(:, 2,30,14) = (/ &
     &9.4502e+02_r8,7.0884e+02_r8,4.7266e+02_r8,2.3650e+02_r8,3.6421e+01_r8/)
      kbo(:, 3,30,14) = (/ &
     &1.2048e+03_r8,9.0370e+02_r8,6.0258e+02_r8,3.0145e+02_r8,3.4660e+01_r8/)
      kbo(:, 4,30,14) = (/ &
     &1.4966e+03_r8,1.1225e+03_r8,7.4846e+02_r8,3.7440e+02_r8,3.2964e+01_r8/)
      kbo(:, 5,30,14) = (/ &
     &1.8180e+03_r8,1.3636e+03_r8,9.0918e+02_r8,4.5477e+02_r8,3.1338e+01_r8/)
      kbo(:, 1,31,14) = (/ &
     &8.6352e+02_r8,6.4770e+02_r8,4.3189e+02_r8,2.1681e+02_r8,3.9626e+01_r8/)
      kbo(:, 2,31,14) = (/ &
     &1.1338e+03_r8,8.5039e+02_r8,5.6702e+02_r8,2.8366e+02_r8,3.7649e+01_r8/)
      kbo(:, 3,31,14) = (/ &
     &1.4436e+03_r8,1.0827e+03_r8,7.2193e+02_r8,3.6112e+02_r8,3.5738e+01_r8/)
      kbo(:, 4,31,14) = (/ &
     &1.7919e+03_r8,1.3440e+03_r8,8.9611e+02_r8,4.4823e+02_r8,3.3911e+01_r8/)
      kbo(:, 5,31,14) = (/ &
     &2.1766e+03_r8,1.6325e+03_r8,1.0885e+03_r8,5.4442e+02_r8,3.2168e+01_r8/)
      kbo(:, 1,32,14) = (/ &
     &1.0534e+03_r8,7.9009e+02_r8,5.2682e+02_r8,2.6397e+02_r8,4.0725e+01_r8/)
      kbo(:, 2,32,14) = (/ &
     &1.3802e+03_r8,1.0352e+03_r8,6.9024e+02_r8,3.4527e+02_r8,3.8603e+01_r8/)
      kbo(:, 3,32,14) = (/ &
     &1.7557e+03_r8,1.3169e+03_r8,8.7802e+02_r8,4.3918e+02_r8,3.6565e+01_r8/)
      kbo(:, 4,32,14) = (/ &
     &2.1789e+03_r8,1.6342e+03_r8,1.0896e+03_r8,5.4499e+02_r8,3.4625e+01_r8/)
      kbo(:, 5,32,14) = (/ &
     &2.6446e+03_r8,1.9836e+03_r8,1.3225e+03_r8,6.6145e+02_r8,3.2784e+01_r8/)
      kbo(:, 1,33,14) = (/ &
     &1.3124e+03_r8,9.8436e+02_r8,6.5633e+02_r8,3.2843e+02_r8,4.1548e+01_r8/)
      kbo(:, 2,33,14) = (/ &
     &1.7177e+03_r8,1.2883e+03_r8,8.5900e+02_r8,4.2966e+02_r8,3.9303e+01_r8/)
      kbo(:, 3,33,14) = (/ &
     &2.1832e+03_r8,1.6375e+03_r8,1.0918e+03_r8,5.4605e+02_r8,3.7160e+01_r8/)
      kbo(:, 4,33,14) = (/ &
     &2.7063e+03_r8,2.0298e+03_r8,1.3533e+03_r8,6.7686e+02_r8,3.5130e+01_r8/)
      kbo(:, 5,33,14) = (/ &
     &3.2806e+03_r8,2.4606e+03_r8,1.6405e+03_r8,8.2046e+02_r8,3.3063e+01_r8/)
      kbo(:, 1,34,14) = (/ &
     &1.5860e+03_r8,1.1896e+03_r8,7.9315e+02_r8,3.9672e+02_r8,4.2202e+01_r8/)
      kbo(:, 2,34,14) = (/ &
     &2.0745e+03_r8,1.5559e+03_r8,1.0374e+03_r8,5.1886e+02_r8,3.9853e+01_r8/)
      kbo(:, 3,34,14) = (/ &
     &2.6355e+03_r8,1.9767e+03_r8,1.3179e+03_r8,6.5913e+02_r8,3.7623e+01_r8/)
      kbo(:, 4,34,14) = (/ &
     &3.2644e+03_r8,2.4484e+03_r8,1.6324e+03_r8,8.1637e+02_r8,3.5405e+01_r8/)
      kbo(:, 5,34,14) = (/ &
     &3.9520e+03_r8,2.9641e+03_r8,1.9762e+03_r8,9.8832e+02_r8,3.3276e+01_r8/)
      kbo(:, 1,35,14) = (/ &
     &1.8756e+03_r8,1.4068e+03_r8,9.3797e+02_r8,4.6914e+02_r8,4.2878e+01_r8/)
      kbo(:, 2,35,14) = (/ &
     &2.4578e+03_r8,1.8434e+03_r8,1.2290e+03_r8,6.1469e+02_r8,4.0440e+01_r8/)
      kbo(:, 3,35,14) = (/ &
     &3.1268e+03_r8,2.3452e+03_r8,1.5636e+03_r8,7.8197e+02_r8,3.8129e+01_r8/)
      kbo(:, 4,35,14) = (/ &
     &3.8751e+03_r8,2.9064e+03_r8,1.9378e+03_r8,9.6909e+02_r8,3.5715e+01_r8/)
      kbo(:, 5,35,14) = (/ &
     &4.6936e+03_r8,3.5203e+03_r8,2.3471e+03_r8,1.1738e+03_r8,3.3797e+01_r8/)
      kbo(:, 1,36,14) = (/ &
     &2.1453e+03_r8,1.6090e+03_r8,1.0728e+03_r8,5.3655e+02_r8,4.3664e+01_r8/)
      kbo(:, 2,36,14) = (/ &
     &2.8245e+03_r8,2.1184e+03_r8,1.4124e+03_r8,7.0636e+02_r8,4.1138e+01_r8/)
      kbo(:, 3,36,14) = (/ &
     &3.6063e+03_r8,2.7048e+03_r8,1.8033e+03_r8,9.0186e+02_r8,3.8589e+01_r8/)
      kbo(:, 4,36,14) = (/ &
     &4.4821e+03_r8,3.3616e+03_r8,2.2412e+03_r8,1.1208e+03_r8,3.6195e+01_r8/)
      kbo(:, 5,36,14) = (/ &
     &5.4418e+03_r8,4.0814e+03_r8,2.7211e+03_r8,1.3608e+03_r8,3.4367e+01_r8/)
      kbo(:, 1,37,14) = (/ &
     &2.2940e+03_r8,1.7205e+03_r8,1.1471e+03_r8,5.7372e+02_r8,4.4724e+01_r8/)
      kbo(:, 2,37,14) = (/ &
     &3.0476e+03_r8,2.2858e+03_r8,1.5240e+03_r8,7.6217e+02_r8,4.2103e+01_r8/)
      kbo(:, 3,37,14) = (/ &
     &3.9216e+03_r8,2.9413e+03_r8,1.9610e+03_r8,9.8070e+02_r8,3.9415e+01_r8/)
      kbo(:, 4,37,14) = (/ &
     &4.9050e+03_r8,3.6789e+03_r8,2.4527e+03_r8,1.2266e+03_r8,3.7136e+01_r8/)
      kbo(:, 5,37,14) = (/ &
     &5.9876e+03_r8,4.4908e+03_r8,2.9940e+03_r8,1.4972e+03_r8,3.5121e+01_r8/)
      kbo(:, 1,38,14) = (/ &
     &2.4855e+03_r8,1.8642e+03_r8,1.2429e+03_r8,6.2161e+02_r8,4.5721e+01_r8/)
      kbo(:, 2,38,14) = (/ &
     &3.3318e+03_r8,2.4989e+03_r8,1.6661e+03_r8,8.3322e+02_r8,4.3010e+01_r8/)
      kbo(:, 3,38,14) = (/ &
     &4.3213e+03_r8,3.2410e+03_r8,2.1608e+03_r8,1.0806e+03_r8,4.0195e+01_r8/)
      kbo(:, 4,38,14) = (/ &
     &5.4403e+03_r8,4.0803e+03_r8,2.7203e+03_r8,1.3604e+03_r8,3.7939e+01_r8/)
      kbo(:, 5,38,14) = (/ &
     &6.6754e+03_r8,5.0066e+03_r8,3.3379e+03_r8,1.6692e+03_r8,3.5824e+01_r8/)
      kbo(:, 1,39,14) = (/ &
     &2.7579e+03_r8,2.0685e+03_r8,1.3791e+03_r8,6.8973e+02_r8,4.6636e+01_r8/)
      kbo(:, 2,39,14) = (/ &
     &3.7311e+03_r8,2.7984e+03_r8,1.8657e+03_r8,9.3308e+02_r8,4.3764e+01_r8/)
      kbo(:, 3,39,14) = (/ &
     &4.8740e+03_r8,3.6556e+03_r8,2.4372e+03_r8,1.2188e+03_r8,4.0901e+01_r8/)
      kbo(:, 4,39,14) = (/ &
     &6.1755e+03_r8,4.6318e+03_r8,3.0880e+03_r8,1.5442e+03_r8,3.8692e+01_r8/)
      kbo(:, 5,39,14) = (/ &
     &7.6168e+03_r8,5.7128e+03_r8,3.8087e+03_r8,1.9046e+03_r8,3.6244e+01_r8/)
      kbo(:, 1,40,14) = (/ &
     &2.7806e+03_r8,2.0855e+03_r8,1.3905e+03_r8,6.9541e+02_r8,4.7781e+01_r8/)
      kbo(:, 2,40,14) = (/ &
     &3.8105e+03_r8,2.8580e+03_r8,1.9054e+03_r8,9.5291e+02_r8,4.4820e+01_r8/)
      kbo(:, 3,40,14) = (/ &
     &5.0317e+03_r8,3.7739e+03_r8,2.5160e+03_r8,1.2582e+03_r8,4.1870e+01_r8/)
      kbo(:, 4,40,14) = (/ &
     &6.4348e+03_r8,4.8262e+03_r8,3.2176e+03_r8,1.6090e+03_r8,3.9597e+01_r8/)
      kbo(:, 5,40,14) = (/ &
     &7.9965e+03_r8,5.9975e+03_r8,3.9985e+03_r8,1.9995e+03_r8,3.7061e+01_r8/)
      kbo(:, 1,41,14) = (/ &
     &2.7787e+03_r8,2.0841e+03_r8,1.3895e+03_r8,6.9500e+02_r8,4.8925e+01_r8/)
      kbo(:, 2,41,14) = (/ &
     &3.8614e+03_r8,2.8961e+03_r8,1.9309e+03_r8,9.6566e+02_r8,4.5922e+01_r8/)
      kbo(:, 3,41,14) = (/ &
     &5.1574e+03_r8,3.8681e+03_r8,2.5789e+03_r8,1.2897e+03_r8,4.2853e+01_r8/)
      kbo(:, 4,41,14) = (/ &
     &6.6587e+03_r8,4.9941e+03_r8,3.3296e+03_r8,1.6650e+03_r8,4.0428e+01_r8/)
      kbo(:, 5,41,14) = (/ &
     &8.3439e+03_r8,6.2581e+03_r8,4.1723e+03_r8,2.0864e+03_r8,3.7900e+01_r8/)
      kbo(:, 1,42,14) = (/ &
     &2.7998e+03_r8,2.0999e+03_r8,1.4001e+03_r8,7.0041e+02_r8,5.0031e+01_r8/)
      kbo(:, 2,42,14) = (/ &
     &3.9460e+03_r8,2.9596e+03_r8,1.9732e+03_r8,9.8680e+02_r8,4.6998e+01_r8/)
      kbo(:, 3,42,14) = (/ &
     &5.3323e+03_r8,3.9993e+03_r8,2.6663e+03_r8,1.3334e+03_r8,4.3819e+01_r8/)
      kbo(:, 4,42,14) = (/ &
     &6.9531e+03_r8,5.2149e+03_r8,3.4767e+03_r8,1.7386e+03_r8,4.1253e+01_r8/)
      kbo(:, 5,42,14) = (/ &
     &8.7873e+03_r8,6.5906e+03_r8,4.3939e+03_r8,2.1972e+03_r8,3.8745e+01_r8/)
      kbo(:, 1,43,14) = (/ &
     &2.7784e+03_r8,2.0839e+03_r8,1.3894e+03_r8,6.9544e+02_r8,5.1292e+01_r8/)
      kbo(:, 2,43,14) = (/ &
     &3.9830e+03_r8,2.9874e+03_r8,1.9917e+03_r8,9.9606e+02_r8,4.8177e+01_r8/)
      kbo(:, 3,43,14) = (/ &
     &5.4603e+03_r8,4.0953e+03_r8,2.7304e+03_r8,1.3654e+03_r8,4.4925e+01_r8/)
      kbo(:, 4,43,14) = (/ &
     &7.2065e+03_r8,5.4050e+03_r8,3.6035e+03_r8,1.8020e+03_r8,4.2242e+01_r8/)
      kbo(:, 5,43,14) = (/ &
     &9.2025e+03_r8,6.9020e+03_r8,4.6015e+03_r8,2.3010e+03_r8,3.9649e+01_r8/)
      kbo(:, 1,44,14) = (/ &
     &2.7542e+03_r8,2.0657e+03_r8,1.3772e+03_r8,6.8977e+02_r8,5.2617e+01_r8/)
      kbo(:, 2,44,14) = (/ &
     &4.0230e+03_r8,3.0173e+03_r8,2.0117e+03_r8,1.0060e+03_r8,4.9427e+01_r8/)
      kbo(:, 3,44,14) = (/ &
     &5.6050e+03_r8,4.2038e+03_r8,2.8027e+03_r8,1.4015e+03_r8,4.6077e+01_r8/)
      kbo(:, 4,44,14) = (/ &
     &7.4959e+03_r8,5.6220e+03_r8,3.7481e+03_r8,1.8743e+03_r8,4.3276e+01_r8/)
      kbo(:, 5,44,14) = (/ &
     &9.6875e+03_r8,7.2657e+03_r8,4.8439e+03_r8,2.4222e+03_r8,4.0647e+01_r8/)
      kbo(:, 1,45,14) = (/ &
     &2.7680e+03_r8,2.0761e+03_r8,1.3842e+03_r8,6.9371e+02_r8,5.3927e+01_r8/)
      kbo(:, 2,45,14) = (/ &
     &4.1247e+03_r8,3.0936e+03_r8,2.0625e+03_r8,1.0314e+03_r8,5.0672e+01_r8/)
      kbo(:, 3,45,14) = (/ &
     &5.8448e+03_r8,4.3837e+03_r8,2.9226e+03_r8,1.4615e+03_r8,4.7150e+01_r8/)
      kbo(:, 4,45,14) = (/ &
     &7.9284e+03_r8,5.9463e+03_r8,3.9644e+03_r8,1.9824e+03_r8,4.4329e+01_r8/)
      kbo(:, 5,45,14) = (/ &
     &1.0369e+04_r8,7.7768e+03_r8,5.1847e+03_r8,2.5926e+03_r8,4.1634e+01_r8/)
      kbo(:, 1,46,14) = (/ &
     &2.7642e+03_r8,2.0732e+03_r8,1.3822e+03_r8,6.9344e+02_r8,5.5299e+01_r8/)
      kbo(:, 2,46,14) = (/ &
     &4.2127e+03_r8,3.1596e+03_r8,2.1065e+03_r8,1.0534e+03_r8,5.1989e+01_r8/)
      kbo(:, 3,46,14) = (/ &
     &6.0817e+03_r8,4.5614e+03_r8,3.0411e+03_r8,1.5207e+03_r8,4.8362e+01_r8/)
      kbo(:, 4,46,14) = (/ &
     &8.3835e+03_r8,6.2877e+03_r8,4.1920e+03_r8,2.0962e+03_r8,4.5451e+01_r8/)
      kbo(:, 5,46,14) = (/ &
     &1.1109e+04_r8,8.3315e+03_r8,5.5545e+03_r8,2.7775e+03_r8,4.2710e+01_r8/)
      kbo(:, 1,47,14) = (/ &
     &2.6579e+03_r8,1.9935e+03_r8,1.3291e+03_r8,6.6810e+02_r8,5.6805e+01_r8/)
      kbo(:, 2,47,14) = (/ &
     &4.1618e+03_r8,3.1214e+03_r8,2.0811e+03_r8,1.0407e+03_r8,5.3447e+01_r8/)
      kbo(:, 3,47,14) = (/ &
     &6.1402e+03_r8,4.6053e+03_r8,3.0703e+03_r8,1.5354e+03_r8,4.9761e+01_r8/)
      kbo(:, 4,47,14) = (/ &
     &8.6262e+03_r8,6.4697e+03_r8,4.3133e+03_r8,2.1569e+03_r8,4.6695e+01_r8/)
      kbo(:, 5,47,14) = (/ &
     &1.1609e+04_r8,8.7071e+03_r8,5.8049e+03_r8,2.9027e+03_r8,4.4026e+01_r8/)
      kbo(:, 1,48,14) = (/ &
     &2.5983e+03_r8,1.9488e+03_r8,1.2993e+03_r8,6.5451e+02_r8,5.8316e+01_r8/)
      kbo(:, 2,48,14) = (/ &
     &4.1890e+03_r8,3.1418e+03_r8,2.0947e+03_r8,1.0476e+03_r8,5.4906e+01_r8/)
      kbo(:, 3,48,14) = (/ &
     &6.3280e+03_r8,4.7461e+03_r8,3.1642e+03_r8,1.5823e+03_r8,5.1153e+01_r8/)
      kbo(:, 4,48,14) = (/ &
     &9.0666e+03_r8,6.8001e+03_r8,4.5335e+03_r8,2.2670e+03_r8,4.7961e+01_r8/)
      kbo(:, 5,48,14) = (/ &
     &1.2413e+04_r8,9.3096e+03_r8,6.2066e+03_r8,3.1035e+03_r8,4.5348e+01_r8/)
      kbo(:, 1,49,14) = (/ &
     &2.6146e+03_r8,1.9610e+03_r8,1.3074e+03_r8,6.5952e+02_r8,5.9823e+01_r8/)
      kbo(:, 2,49,14) = (/ &
     &4.3479e+03_r8,3.2610e+03_r8,2.1741e+03_r8,1.0874e+03_r8,5.6229e+01_r8/)
      kbo(:, 3,49,14) = (/ &
     &6.7401e+03_r8,5.0552e+03_r8,3.3702e+03_r8,1.6853e+03_r8,5.2522e+01_r8/)
      kbo(:, 4,49,14) = (/ &
     &9.8602e+03_r8,7.3953e+03_r8,4.9303e+03_r8,2.4653e+03_r8,4.9326e+01_r8/)
      kbo(:, 5,49,14) = (/ &
     &1.3745e+04_r8,1.0309e+04_r8,6.8727e+03_r8,3.4366e+03_r8,4.6702e+01_r8/)
      kbo(:, 1,50,14) = (/ &
     &2.5099e+03_r8,1.8825e+03_r8,1.2551e+03_r8,6.3476e+02_r8,6.1230e+01_r8/)
      kbo(:, 2,50,14) = (/ &
     &4.3054e+03_r8,3.2291e+03_r8,2.1528e+03_r8,1.0772e+03_r8,5.7584e+01_r8/)
      kbo(:, 3,50,14) = (/ &
     &6.8503e+03_r8,5.1378e+03_r8,3.4253e+03_r8,1.7128e+03_r8,5.3876e+01_r8/)
      kbo(:, 4,50,14) = (/ &
     &1.0235e+04_r8,7.6760e+03_r8,5.1175e+03_r8,2.5589e+03_r8,5.0609e+01_r8/)
      kbo(:, 5,50,14) = (/ &
     &1.4527e+04_r8,1.0895e+04_r8,7.2636e+03_r8,3.6320e+03_r8,4.7904e+01_r8/)
      kbo(:, 1,51,14) = (/ &
     &2.3421e+03_r8,1.7566e+03_r8,1.1712e+03_r8,5.9456e+02_r8,6.2588e+01_r8/)
      kbo(:, 2,51,14) = (/ &
     &4.1517e+03_r8,3.1138e+03_r8,2.0760e+03_r8,1.0393e+03_r8,5.8927e+01_r8/)
      kbo(:, 3,51,14) = (/ &
     &6.7861e+03_r8,5.0897e+03_r8,3.3932e+03_r8,1.6968e+03_r8,5.5331e+01_r8/)
      kbo(:, 4,51,14) = (/ &
     &1.0366e+04_r8,7.7746e+03_r8,5.1832e+03_r8,2.5918e+03_r8,5.1728e+01_r8/)
      kbo(:, 5,51,14) = (/ &
     &1.4983e+04_r8,1.1238e+04_r8,7.4919e+03_r8,3.7462e+03_r8,4.9071e+01_r8/)
      kbo(:, 1,52,14) = (/ &
     &2.2192e+03_r8,1.6645e+03_r8,1.1098e+03_r8,5.6550e+02_r8,6.3929e+01_r8/)
      kbo(:, 2,52,14) = (/ &
     &4.0774e+03_r8,3.0581e+03_r8,2.0388e+03_r8,1.0215e+03_r8,6.0266e+01_r8/)
      kbo(:, 3,52,14) = (/ &
     &6.8574e+03_r8,5.1432e+03_r8,3.4289e+03_r8,1.7146e+03_r8,5.6630e+01_r8/)
      kbo(:, 4,52,14) = (/ &
     &1.0728e+04_r8,8.0459e+03_r8,5.3641e+03_r8,2.6822e+03_r8,5.3054e+01_r8/)
      kbo(:, 5,52,14) = (/ &
     &1.5806e+04_r8,1.1855e+04_r8,7.9035e+03_r8,3.9520e+03_r8,5.0321e+01_r8/)
      kbo(:, 1,53,14) = (/ &
     &2.1588e+03_r8,1.6192e+03_r8,1.0797e+03_r8,5.5175e+02_r8,6.5259e+01_r8/)
      kbo(:, 2,53,14) = (/ &
     &4.1225e+03_r8,3.0919e+03_r8,2.0614e+03_r8,1.0332e+03_r8,6.1546e+01_r8/)
      kbo(:, 3,53,14) = (/ &
     &7.1492e+03_r8,5.3620e+03_r8,3.5747e+03_r8,1.7875e+03_r8,5.7918e+01_r8/)
      kbo(:, 4,53,14) = (/ &
     &1.1475e+04_r8,8.6063e+03_r8,5.7376e+03_r8,2.8690e+03_r8,5.4409e+01_r8/)
      kbo(:, 5,53,14) = (/ &
     &1.7262e+04_r8,1.2946e+04_r8,8.6311e+03_r8,4.3158e+03_r8,5.1571e+01_r8/)
      kbo(:, 1,54,14) = (/ &
     &1.8282e+03_r8,1.3713e+03_r8,9.1520e+02_r8,4.7290e+02_r8,6.6448e+01_r8/)
      kbo(:, 2,54,14) = (/ &
     &3.6279e+03_r8,2.7210e+03_r8,1.8141e+03_r8,9.1135e+02_r8,6.2844e+01_r8/)
      kbo(:, 3,54,14) = (/ &
     &6.4841e+03_r8,4.8631e+03_r8,3.2422e+03_r8,1.6212e+03_r8,5.9155e+01_r8/)
      kbo(:, 4,54,14) = (/ &
     &1.0670e+04_r8,8.0025e+03_r8,5.3351e+03_r8,2.6677e+03_r8,5.5552e+01_r8/)
      kbo(:, 5,54,14) = (/ &
     &1.6384e+04_r8,1.2288e+04_r8,8.1922e+03_r8,4.0963e+03_r8,5.2636e+01_r8/)
      kbo(:, 1,55,14) = (/ &
     &1.4067e+03_r8,1.0551e+03_r8,7.0638e+02_r8,3.7354e+02_r8,6.7558e+01_r8/)
      kbo(:, 2,55,14) = (/ &
     &2.9041e+03_r8,2.1781e+03_r8,1.4522e+03_r8,7.3353e+02_r8,6.4148e+01_r8/)
      kbo(:, 3,55,14) = (/ &
     &5.3593e+03_r8,4.0195e+03_r8,2.6797e+03_r8,1.3404e+03_r8,6.0390e+01_r8/)
      kbo(:, 4,55,14) = (/ &
     &9.0439e+03_r8,6.7830e+03_r8,4.5221e+03_r8,2.2612e+03_r8,5.6702e+01_r8/)
      kbo(:, 5,55,14) = (/ &
     &1.4184e+04_r8,1.0638e+04_r8,7.0920e+03_r8,3.5462e+03_r8,5.3319e+01_r8/)
      kbo(:, 1,56,14) = (/ &
     &1.0676e+03_r8,8.0078e+02_r8,5.3961e+02_r8,2.9566e+02_r8,6.8630e+01_r8/)
      kbo(:, 2,56,14) = (/ &
     &2.3009e+03_r8,1.7258e+03_r8,1.1507e+03_r8,5.8655e+02_r8,6.5294e+01_r8/)
      kbo(:, 3,56,14) = (/ &
     &4.3913e+03_r8,3.2935e+03_r8,2.1958e+03_r8,1.1000e+03_r8,6.1700e+01_r8/)
      kbo(:, 4,56,14) = (/ &
     &7.6108e+03_r8,5.7081e+03_r8,3.8055e+03_r8,1.9028e+03_r8,5.7982e+01_r8/)
      kbo(:, 5,56,14) = (/ &
     &1.2207e+04_r8,9.1554e+03_r8,6.1037e+03_r8,3.0520e+03_r8,5.4269e+01_r8/)
      kbo(:, 1,57,14) = (/ &
     &7.9773e+02_r8,5.9861e+02_r8,4.0826e+02_r8,2.3574e+02_r8,6.9656e+01_r8/)
      kbo(:, 2,57,14) = (/ &
     &1.8005e+03_r8,1.3505e+03_r8,9.0146e+02_r8,4.6638e+02_r8,6.6420e+01_r8/)
      kbo(:, 3,57,14) = (/ &
     &3.5629e+03_r8,2.6722e+03_r8,1.7816e+03_r8,8.9534e+02_r8,6.2948e+01_r8/)
      kbo(:, 4,57,14) = (/ &
     &6.3553e+03_r8,4.7665e+03_r8,3.1777e+03_r8,1.5890e+03_r8,5.9228e+01_r8/)
      kbo(:, 5,57,14) = (/ &
     &1.0437e+04_r8,7.8281e+03_r8,5.2188e+03_r8,2.6095e+03_r8,5.5502e+01_r8/)
      kbo(:, 1,58,14) = (/ &
     &1.5691e+02_r8,1.4430e+02_r8,1.2945e+02_r8,1.1296e+02_r8,7.0583e+01_r8/)
      kbo(:, 2,58,14) = (/ &
     &3.7146e+02_r8,3.4061e+02_r8,2.9343e+02_r8,2.1801e+02_r8,6.7460e+01_r8/)
      kbo(:, 3,58,14) = (/ &
     &7.6282e+02_r8,6.9942e+02_r8,5.9974e+02_r8,4.2478e+02_r8,6.4030e+01_r8/)
      kbo(:, 4,58,14) = (/ &
     &1.4014e+03_r8,1.2849e+03_r8,1.1017e+03_r8,7.7206e+02_r8,6.0507e+01_r8/)
      kbo(:, 5,58,14) = (/ &
     &2.3564e+03_r8,2.1605e+03_r8,1.8525e+03_r8,1.2975e+03_r8,5.6760e+01_r8/)
      kbo(:, 1,59,14) = (/ &
     &1.6269e+02_r8,1.4372e+02_r8,1.2601e+02_r8,1.1040e+02_r8,7.0952e+01_r8/)
      kbo(:, 2,59,14) = (/ &
     &3.9338e+02_r8,3.4354e+02_r8,2.7833e+02_r8,1.9401e+02_r8,6.7878e+01_r8/)
      kbo(:, 3,59,14) = (/ &
     &8.2073e+02_r8,7.1668e+02_r8,5.7208e+02_r8,3.6616e+02_r8,6.4473e+01_r8/)
      kbo(:, 4,59,14) = (/ &
     &1.5267e+03_r8,1.3331e+03_r8,1.0634e+03_r8,6.6456e+02_r8,6.0953e+01_r8/)
      kbo(:, 5,59,14) = (/ &
     &2.5924e+03_r8,2.2637e+03_r8,1.8057e+03_r8,1.1237e+03_r8,5.7434e+01_r8/)
      kbo(:, 1,13,15) = (/ &
     &6.7676e+03_r8,5.0758e+03_r8,3.3840e+03_r8,1.6922e+03_r8,9.0910e+00_r8/)
      kbo(:, 2,13,15) = (/ &
     &9.5300e+03_r8,7.1475e+03_r8,4.7651e+03_r8,2.3827e+03_r8,8.9593e+00_r8/)
      kbo(:, 3,13,15) = (/ &
     &1.2768e+04_r8,9.5761e+03_r8,6.3842e+03_r8,3.1923e+03_r8,8.8860e+00_r8/)
      kbo(:, 4,13,15) = (/ &
     &1.6413e+04_r8,1.2310e+04_r8,8.2067e+03_r8,4.1035e+03_r8,8.8094e+00_r8/)
      kbo(:, 5,13,15) = (/ &
     &2.0377e+04_r8,1.5283e+04_r8,1.0189e+04_r8,5.0946e+03_r8,8.7010e+00_r8/)
      kbo(:, 1,14,15) = (/ &
     &4.6855e+03_r8,3.5142e+03_r8,2.3429e+03_r8,1.1716e+03_r8,1.0351e+01_r8/)
      kbo(:, 2,14,15) = (/ &
     &6.5777e+03_r8,4.9333e+03_r8,3.2890e+03_r8,1.6447e+03_r8,1.0245e+01_r8/)
      kbo(:, 3,14,15) = (/ &
     &8.7780e+03_r8,6.5835e+03_r8,4.3891e+03_r8,2.1947e+03_r8,1.0189e+01_r8/)
      kbo(:, 4,14,15) = (/ &
     &1.1257e+04_r8,8.4428e+03_r8,5.6286e+03_r8,2.8145e+03_r8,1.0105e+01_r8/)
      kbo(:, 5,14,15) = (/ &
     &1.3964e+04_r8,1.0473e+04_r8,6.9821e+03_r8,3.4912e+03_r8,9.9926e+00_r8/)
      kbo(:, 1,15,15) = (/ &
     &3.2854e+03_r8,2.4642e+03_r8,1.6429e+03_r8,8.2169e+02_r8,1.1907e+01_r8/)
      kbo(:, 2,15,15) = (/ &
     &4.5889e+03_r8,3.4418e+03_r8,2.2947e+03_r8,1.1475e+03_r8,1.1847e+01_r8/)
      kbo(:, 3,15,15) = (/ &
     &6.1056e+03_r8,4.5793e+03_r8,3.0530e+03_r8,1.5267e+03_r8,1.1796e+01_r8/)
      kbo(:, 4,15,15) = (/ &
     &7.8011e+03_r8,5.8510e+03_r8,3.9008e+03_r8,1.9506e+03_r8,1.1682e+01_r8/)
      kbo(:, 5,15,15) = (/ &
     &9.6352e+03_r8,7.2265e+03_r8,4.8178e+03_r8,2.4091e+03_r8,1.1548e+01_r8/)
      kbo(:, 1,16,15) = (/ &
     &2.7156e+03_r8,2.0368e+03_r8,1.3580e+03_r8,6.7918e+02_r8,1.3833e+01_r8/)
      kbo(:, 2,16,15) = (/ &
     &3.7730e+03_r8,2.8298e+03_r8,1.8867e+03_r8,9.4350e+02_r8,1.3786e+01_r8/)
      kbo(:, 3,16,15) = (/ &
     &4.9942e+03_r8,3.7457e+03_r8,2.4973e+03_r8,1.2488e+03_r8,1.3682e+01_r8/)
      kbo(:, 4,16,15) = (/ &
     &6.3607e+03_r8,4.7706e+03_r8,3.1805e+03_r8,1.5904e+03_r8,1.3533e+01_r8/)
      kbo(:, 5,16,15) = (/ &
     &7.8514e+03_r8,5.8886e+03_r8,3.9259e+03_r8,1.9631e+03_r8,1.3377e+01_r8/)
      kbo(:, 1,17,15) = (/ &
     &2.3075e+03_r8,1.7307e+03_r8,1.1539e+03_r8,5.7711e+02_r8,1.6126e+01_r8/)
      kbo(:, 2,17,15) = (/ &
     &3.1956e+03_r8,2.3967e+03_r8,1.5979e+03_r8,7.9911e+02_r8,1.6029e+01_r8/)
      kbo(:, 3,17,15) = (/ &
     &4.2241e+03_r8,3.1681e+03_r8,2.1122e+03_r8,1.0562e+03_r8,1.5863e+01_r8/)
      kbo(:, 4,17,15) = (/ &
     &5.3821e+03_r8,4.0366e+03_r8,2.6912e+03_r8,1.3457e+03_r8,1.5685e+01_r8/)
      kbo(:, 5,17,15) = (/ &
     &6.6465e+03_r8,4.9850e+03_r8,3.3234e+03_r8,1.6618e+03_r8,1.5496e+01_r8/)
      kbo(:, 1,18,15) = (/ &
     &2.0119e+03_r8,1.5090e+03_r8,1.0061e+03_r8,5.0318e+02_r8,1.8668e+01_r8/)
      kbo(:, 2,18,15) = (/ &
     &2.7815e+03_r8,2.0862e+03_r8,1.3909e+03_r8,6.9557e+02_r8,1.8505e+01_r8/)
      kbo(:, 3,18,15) = (/ &
     &3.6794e+03_r8,2.7596e+03_r8,1.8398e+03_r8,9.2005e+02_r8,1.8343e+01_r8/)
      kbo(:, 4,18,15) = (/ &
     &4.6884e+03_r8,3.5164e+03_r8,2.3443e+03_r8,1.1723e+03_r8,1.8140e+01_r8/)
      kbo(:, 5,18,15) = (/ &
     &5.7908e+03_r8,4.3432e+03_r8,2.8955e+03_r8,1.4479e+03_r8,1.7901e+01_r8/)
      kbo(:, 1,19,15) = (/ &
     &1.7281e+03_r8,1.2962e+03_r8,8.6418e+02_r8,4.3222e+02_r8,2.1496e+01_r8/)
      kbo(:, 2,19,15) = (/ &
     &2.3903e+03_r8,1.7928e+03_r8,1.1953e+03_r8,5.9777e+02_r8,2.1311e+01_r8/)
      kbo(:, 3,19,15) = (/ &
     &3.1615e+03_r8,2.3712e+03_r8,1.5809e+03_r8,7.9055e+02_r8,2.1106e+01_r8/)
      kbo(:, 4,19,15) = (/ &
     &4.0222e+03_r8,3.0167e+03_r8,2.0112e+03_r8,1.0057e+03_r8,2.0849e+01_r8/)
      kbo(:, 5,19,15) = (/ &
     &4.9621e+03_r8,3.7216e+03_r8,2.4811e+03_r8,1.2407e+03_r8,2.0531e+01_r8/)
      kbo(:, 1,20,15) = (/ &
     &1.6235e+03_r8,1.2177e+03_r8,8.1188e+02_r8,4.0606e+02_r8,2.4735e+01_r8/)
      kbo(:, 2,20,15) = (/ &
     &2.2387e+03_r8,1.6791e+03_r8,1.1195e+03_r8,5.5984e+02_r8,2.4475e+01_r8/)
      kbo(:, 3,20,15) = (/ &
     &2.9488e+03_r8,2.2116e+03_r8,1.4745e+03_r8,7.3737e+02_r8,2.4178e+01_r8/)
      kbo(:, 4,20,15) = (/ &
     &3.7459e+03_r8,2.8095e+03_r8,1.8731e+03_r8,9.3665e+02_r8,2.3818e+01_r8/)
      kbo(:, 5,20,15) = (/ &
     &4.6161e+03_r8,3.4621e+03_r8,2.3081e+03_r8,1.1542e+03_r8,2.3401e+01_r8/)
      kbo(:, 1,21,15) = (/ &
     &1.5705e+03_r8,1.1779e+03_r8,7.8536e+02_r8,3.9279e+02_r8,2.8368e+01_r8/)
      kbo(:, 2,21,15) = (/ &
     &2.1555e+03_r8,1.6166e+03_r8,1.0778e+03_r8,5.3903e+02_r8,2.7972e+01_r8/)
      kbo(:, 3,21,15) = (/ &
     &2.8340e+03_r8,2.1256e+03_r8,1.4171e+03_r8,7.0866e+02_r8,2.7543e+01_r8/)
      kbo(:, 4,21,15) = (/ &
     &3.5949e+03_r8,2.6962e+03_r8,1.7975e+03_r8,8.9888e+02_r8,2.7047e+01_r8/)
      kbo(:, 5,21,15) = (/ &
     &4.4249e+03_r8,3.3187e+03_r8,2.2126e+03_r8,1.1064e+03_r8,2.6508e+01_r8/)
      kbo(:, 1,22,15) = (/ &
     &1.5869e+03_r8,1.1902e+03_r8,7.9356e+02_r8,3.9688e+02_r8,3.2318e+01_r8/)
      kbo(:, 2,22,15) = (/ &
     &2.1673e+03_r8,1.6255e+03_r8,1.0838e+03_r8,5.4198e+02_r8,3.1767e+01_r8/)
      kbo(:, 3,22,15) = (/ &
     &2.8378e+03_r8,2.1284e+03_r8,1.4190e+03_r8,7.0961e+02_r8,3.1126e+01_r8/)
      kbo(:, 4,22,15) = (/ &
     &3.5877e+03_r8,2.6908e+03_r8,1.7940e+03_r8,8.9709e+02_r8,3.0424e+01_r8/)
      kbo(:, 5,22,15) = (/ &
     &4.4005e+03_r8,3.3004e+03_r8,2.2004e+03_r8,1.1003e+03_r8,2.9694e+01_r8/)
      kbo(:, 1,23,15) = (/ &
     &1.6232e+03_r8,1.2174e+03_r8,8.1169e+02_r8,4.0594e+02_r8,3.6426e+01_r8/)
      kbo(:, 2,23,15) = (/ &
     &2.2045e+03_r8,1.6534e+03_r8,1.1023e+03_r8,5.5127e+02_r8,3.5632e+01_r8/)
      kbo(:, 3,23,15) = (/ &
     &2.8697e+03_r8,2.1523e+03_r8,1.4350e+03_r8,7.1760e+02_r8,3.4766e+01_r8/)
      kbo(:, 4,23,15) = (/ &
     &3.6072e+03_r8,2.7054e+03_r8,1.8037e+03_r8,9.0197e+02_r8,3.3867e+01_r8/)
      kbo(:, 5,23,15) = (/ &
     &4.4070e+03_r8,3.3053e+03_r8,2.2036e+03_r8,1.1019e+03_r8,3.2942e+01_r8/)
      kbo(:, 1,24,15) = (/ &
     &1.6638e+03_r8,1.2479e+03_r8,8.3204e+02_r8,4.1615e+02_r8,4.0555e+01_r8/)
      kbo(:, 2,24,15) = (/ &
     &2.2399e+03_r8,1.6800e+03_r8,1.1201e+03_r8,5.6017e+02_r8,3.9512e+01_r8/)
      kbo(:, 3,24,15) = (/ &
     &2.8950e+03_r8,2.1713e+03_r8,1.4476e+03_r8,7.2392e+02_r8,3.8430e+01_r8/)
      kbo(:, 4,24,15) = (/ &
     &3.6214e+03_r8,2.7161e+03_r8,1.8108e+03_r8,9.0552e+02_r8,3.7312e+01_r8/)
      kbo(:, 5,24,15) = (/ &
     &4.4048e+03_r8,3.3036e+03_r8,2.2025e+03_r8,1.1014e+03_r8,3.6172e+01_r8/)
      kbo(:, 1,25,15) = (/ &
     &1.7332e+03_r8,1.2999e+03_r8,8.6673e+02_r8,4.3352e+02_r8,4.4719e+01_r8/)
      kbo(:, 2,25,15) = (/ &
     &2.3131e+03_r8,1.7349e+03_r8,1.1567e+03_r8,5.7851e+02_r8,4.3381e+01_r8/)
      kbo(:, 3,25,15) = (/ &
     &2.9711e+03_r8,2.2284e+03_r8,1.4857e+03_r8,7.4302e+02_r8,4.2032e+01_r8/)
      kbo(:, 4,25,15) = (/ &
     &3.6954e+03_r8,2.7716e+03_r8,1.8478e+03_r8,9.2407e+02_r8,4.0668e+01_r8/)
      kbo(:, 5,25,15) = (/ &
     &4.4711e+03_r8,3.3534e+03_r8,2.2357e+03_r8,1.1180e+03_r8,3.9312e+01_r8/)
      kbo(:, 1,26,15) = (/ &
     &1.8457e+03_r8,1.3843e+03_r8,9.2300e+02_r8,4.6166e+02_r8,4.8798e+01_r8/)
      kbo(:, 2,26,15) = (/ &
     &2.4421e+03_r8,1.8317e+03_r8,1.2212e+03_r8,6.1078e+02_r8,4.7150e+01_r8/)
      kbo(:, 3,26,15) = (/ &
     &3.1127e+03_r8,2.3346e+03_r8,1.5565e+03_r8,7.7843e+02_r8,4.5507e+01_r8/)
      kbo(:, 4,26,15) = (/ &
     &3.8432e+03_r8,2.8825e+03_r8,1.9217e+03_r8,9.6104e+02_r8,4.3884e+01_r8/)
      kbo(:, 5,26,15) = (/ &
     &4.6197e+03_r8,3.4648e+03_r8,2.3100e+03_r8,1.1552e+03_r8,4.2296e+01_r8/)
      kbo(:, 1,27,15) = (/ &
     &2.0401e+03_r8,1.5302e+03_r8,1.0202e+03_r8,5.1030e+02_r8,5.2748e+01_r8/)
      kbo(:, 2,27,15) = (/ &
     &2.6727e+03_r8,2.0046e+03_r8,1.3365e+03_r8,6.6845e+02_r8,5.0763e+01_r8/)
      kbo(:, 3,27,15) = (/ &
     &3.3765e+03_r8,2.5325e+03_r8,1.6885e+03_r8,8.4441e+02_r8,4.8815e+01_r8/)
      kbo(:, 4,27,15) = (/ &
     &4.1373e+03_r8,3.1031e+03_r8,2.0688e+03_r8,1.0346e+03_r8,4.6912e+01_r8/)
      kbo(:, 5,27,15) = (/ &
     &4.9426e+03_r8,3.7071e+03_r8,2.4715e+03_r8,1.2359e+03_r8,4.5084e+01_r8/)
      kbo(:, 1,28,15) = (/ &
     &2.3062e+03_r8,1.7297e+03_r8,1.1533e+03_r8,5.7684e+02_r8,5.6494e+01_r8/)
      kbo(:, 2,28,15) = (/ &
     &2.9911e+03_r8,2.2434e+03_r8,1.4957e+03_r8,7.4806e+02_r8,5.4164e+01_r8/)
      kbo(:, 3,28,15) = (/ &
     &3.7467e+03_r8,2.8101e+03_r8,1.8736e+03_r8,9.3698e+02_r8,5.1914e+01_r8/)
      kbo(:, 4,28,15) = (/ &
     &4.5581e+03_r8,3.4187e+03_r8,2.2792e+03_r8,1.1398e+03_r8,4.9734e+01_r8/)
      kbo(:, 5,28,15) = (/ &
     &5.4121e+03_r8,4.0592e+03_r8,2.7063e+03_r8,1.3533e+03_r8,4.7639e+01_r8/)
      kbo(:, 1,29,15) = (/ &
     &2.7587e+03_r8,2.0691e+03_r8,1.3796e+03_r8,6.8998e+02_r8,5.9883e+01_r8/)
      kbo(:, 2,29,15) = (/ &
     &3.5427e+03_r8,2.6571e+03_r8,1.7716e+03_r8,8.8598e+02_r8,5.7214e+01_r8/)
      kbo(:, 3,29,15) = (/ &
     &4.3997e+03_r8,3.2998e+03_r8,2.2000e+03_r8,1.1002e+03_r8,5.4658e+01_r8/)
      kbo(:, 4,29,15) = (/ &
     &5.3158e+03_r8,3.9869e+03_r8,2.6581e+03_r8,1.3292e+03_r8,5.2215e+01_r8/)
      kbo(:, 5,29,15) = (/ &
     &6.2710e+03_r8,4.7033e+03_r8,3.1357e+03_r8,1.5680e+03_r8,4.9872e+01_r8/)
      kbo(:, 1,30,15) = (/ &
     &3.3645e+03_r8,2.5235e+03_r8,1.6825e+03_r8,8.4145e+02_r8,6.2847e+01_r8/)
      kbo(:, 2,30,15) = (/ &
     &4.2782e+03_r8,3.2088e+03_r8,2.1393e+03_r8,1.0699e+03_r8,5.9850e+01_r8/)
      kbo(:, 3,30,15) = (/ &
     &5.2706e+03_r8,3.9531e+03_r8,2.6355e+03_r8,1.3180e+03_r8,5.7012e+01_r8/)
      kbo(:, 4,30,15) = (/ &
     &6.3236e+03_r8,4.7428e+03_r8,3.1620e+03_r8,1.5812e+03_r8,5.4322e+01_r8/)
      kbo(:, 5,30,15) = (/ &
     &7.4122e+03_r8,5.5592e+03_r8,3.7063e+03_r8,1.8534e+03_r8,5.1754e+01_r8/)
      kbo(:, 1,31,15) = (/ &
     &4.2971e+03_r8,3.2230e+03_r8,2.1488e+03_r8,1.0746e+03_r8,6.5331e+01_r8/)
      kbo(:, 2,31,15) = (/ &
     &5.4121e+03_r8,4.0592e+03_r8,2.7063e+03_r8,1.3534e+03_r8,6.2034e+01_r8/)
      kbo(:, 3,31,15) = (/ &
     &6.6141e+03_r8,4.9607e+03_r8,3.3073e+03_r8,1.6539e+03_r8,5.8947e+01_r8/)
      kbo(:, 4,31,15) = (/ &
     &7.8758e+03_r8,5.9069e+03_r8,3.9381e+03_r8,1.9693e+03_r8,5.6027e+01_r8/)
      kbo(:, 5,31,15) = (/ &
     &9.1717e+03_r8,6.8788e+03_r8,4.5860e+03_r8,2.2932e+03_r8,5.3266e+01_r8/)
      kbo(:, 1,32,15) = (/ &
     &5.5229e+03_r8,4.1423e+03_r8,2.7617e+03_r8,1.3811e+03_r8,6.7311e+01_r8/)
      kbo(:, 2,32,15) = (/ &
     &6.8909e+03_r8,5.1683e+03_r8,3.4457e+03_r8,1.7231e+03_r8,6.3759e+01_r8/)
      kbo(:, 3,32,15) = (/ &
     &8.3530e+03_r8,6.2649e+03_r8,4.1768e+03_r8,2.0886e+03_r8,6.0452e+01_r8/)
      kbo(:, 4,32,15) = (/ &
     &9.8746e+03_r8,7.4061e+03_r8,4.9375e+03_r8,2.4690e+03_r8,5.7340e+01_r8/)
      kbo(:, 5,32,15) = (/ &
     &1.1429e+04_r8,8.5717e+03_r8,5.7146e+03_r8,2.8575e+03_r8,5.4420e+01_r8/)
      kbo(:, 1,33,15) = (/ &
     &7.1868e+03_r8,5.3902e+03_r8,3.5936e+03_r8,1.7971e+03_r8,6.8810e+01_r8/)
      kbo(:, 2,33,15) = (/ &
     &8.8853e+03_r8,6.6641e+03_r8,4.4429e+03_r8,2.2217e+03_r8,6.5053e+01_r8/)
      kbo(:, 3,33,15) = (/ &
     &1.0684e+04_r8,8.0128e+03_r8,5.3420e+03_r8,2.6713e+03_r8,6.1559e+01_r8/)
      kbo(:, 4,33,15) = (/ &
     &1.2545e+04_r8,9.4087e+03_r8,6.2726e+03_r8,3.1365e+03_r8,5.8295e+01_r8/)
      kbo(:, 5,33,15) = (/ &
     &1.4437e+04_r8,1.0828e+04_r8,7.2187e+03_r8,3.6096e+03_r8,5.5243e+01_r8/)
      kbo(:, 1,34,15) = (/ &
     &8.9946e+03_r8,6.7461e+03_r8,4.4975e+03_r8,2.2490e+03_r8,7.0022e+01_r8/)
      kbo(:, 2,34,15) = (/ &
     &1.1036e+04_r8,8.2772e+03_r8,5.5183e+03_r8,2.7594e+03_r8,6.6087e+01_r8/)
      kbo(:, 3,34,15) = (/ &
     &1.3184e+04_r8,9.8877e+03_r8,6.5920e+03_r8,3.2962e+03_r8,6.2443e+01_r8/)
      kbo(:, 4,34,15) = (/ &
     &1.5394e+04_r8,1.1546e+04_r8,7.6972e+03_r8,3.8488e+03_r8,5.9052e+01_r8/)
      kbo(:, 5,34,15) = (/ &
     &1.7632e+04_r8,1.3224e+04_r8,8.8161e+03_r8,4.4083e+03_r8,5.5884e+01_r8/)
      kbo(:, 1,35,15) = (/ &
     &1.0993e+04_r8,8.2446e+03_r8,5.4966e+03_r8,2.7485e+03_r8,7.1272e+01_r8/)
      kbo(:, 2,35,15) = (/ &
     &1.3428e+04_r8,1.0071e+04_r8,6.7141e+03_r8,3.3573e+03_r8,6.7165e+01_r8/)
      kbo(:, 3,35,15) = (/ &
     &1.5977e+04_r8,1.1983e+04_r8,7.9889e+03_r8,3.9949e+03_r8,6.3376e+01_r8/)
      kbo(:, 4,35,15) = (/ &
     &1.8595e+04_r8,1.3946e+04_r8,9.2975e+03_r8,4.6490e+03_r8,5.9869e+01_r8/)
      kbo(:, 5,35,15) = (/ &
     &2.1231e+04_r8,1.5923e+04_r8,1.0616e+04_r8,5.3081e+03_r8,5.6025e+01_r8/)
      kbo(:, 1,36,15) = (/ &
     &1.3006e+04_r8,9.7547e+03_r8,6.5033e+03_r8,3.2519e+03_r8,7.2705e+01_r8/)
      kbo(:, 2,36,15) = (/ &
     &1.5874e+04_r8,1.1905e+04_r8,7.9370e+03_r8,3.9687e+03_r8,6.8413e+01_r8/)
      kbo(:, 3,36,15) = (/ &
     &1.8861e+04_r8,1.4146e+04_r8,9.4305e+03_r8,4.7155e+03_r8,6.4479e+01_r8/)
      kbo(:, 4,36,15) = (/ &
     &2.1927e+04_r8,1.6445e+04_r8,1.0964e+04_r8,5.4821e+03_r8,6.0843e+01_r8/)
      kbo(:, 5,36,15) = (/ &
     &2.5014e+04_r8,1.8760e+04_r8,1.2507e+04_r8,6.2537e+03_r8,5.6544e+01_r8/)
      kbo(:, 1,37,15) = (/ &
     &1.4489e+04_r8,1.0867e+04_r8,7.2447e+03_r8,3.6226e+03_r8,7.4617e+01_r8/)
      kbo(:, 2,37,15) = (/ &
     &1.7744e+04_r8,1.3308e+04_r8,8.8720e+03_r8,4.4362e+03_r8,7.0104e+01_r8/)
      kbo(:, 3,37,15) = (/ &
     &2.1142e+04_r8,1.5857e+04_r8,1.0571e+04_r8,5.2858e+03_r8,6.5985e+01_r8/)
      kbo(:, 4,37,15) = (/ &
     &2.4633e+04_r8,1.8475e+04_r8,1.2317e+04_r8,6.1586e+03_r8,6.1723e+01_r8/)
      kbo(:, 5,37,15) = (/ &
     &2.8152e+04_r8,2.1114e+04_r8,1.4076e+04_r8,7.0383e+03_r8,5.7616e+01_r8/)
      kbo(:, 1,38,15) = (/ &
     &1.6314e+04_r8,1.2236e+04_r8,8.1572e+03_r8,4.0788e+03_r8,7.6413e+01_r8/)
      kbo(:, 2,38,15) = (/ &
     &2.0055e+04_r8,1.5041e+04_r8,1.0028e+04_r8,5.0140e+03_r8,7.1696e+01_r8/)
      kbo(:, 3,38,15) = (/ &
     &2.3973e+04_r8,1.7980e+04_r8,1.1987e+04_r8,5.9936e+03_r8,6.7406e+01_r8/)
      kbo(:, 4,38,15) = (/ &
     &2.8001e+04_r8,2.1001e+04_r8,1.4001e+04_r8,7.0006e+03_r8,6.2768e+01_r8/)
      kbo(:, 5,38,15) = (/ &
     &3.2071e+04_r8,2.4053e+04_r8,1.6036e+04_r8,8.0180e+03_r8,5.8602e+01_r8/)
      kbo(:, 1,39,15) = (/ &
     &1.8759e+04_r8,1.4069e+04_r8,9.3797e+03_r8,4.6901e+03_r8,7.8086e+01_r8/)
      kbo(:, 2,39,15) = (/ &
     &2.3153e+04_r8,1.7365e+04_r8,1.1577e+04_r8,5.7886e+03_r8,7.3162e+01_r8/)
      kbo(:, 3,39,15) = (/ &
     &2.7770e+04_r8,2.0828e+04_r8,1.3886e+04_r8,6.9431e+03_r8,6.8719e+01_r8/)
      kbo(:, 4,39,15) = (/ &
     &3.2517e+04_r8,2.4388e+04_r8,1.6259e+04_r8,8.1299e+03_r8,6.3661e+01_r8/)
      kbo(:, 5,39,15) = (/ &
     &3.7323e+04_r8,2.7992e+04_r8,1.8662e+04_r8,9.3312e+03_r8,5.9468e+01_r8/)
      kbo(:, 1,40,15) = (/ &
     &1.9750e+04_r8,1.4812e+04_r8,9.8751e+03_r8,4.9378e+03_r8,8.0192e+01_r8/)
      kbo(:, 2,40,15) = (/ &
     &2.4562e+04_r8,1.8422e+04_r8,1.2281e+04_r8,6.1409e+03_r8,7.5032e+01_r8/)
      kbo(:, 3,40,15) = (/ &
     &2.9646e+04_r8,2.2235e+04_r8,1.4823e+04_r8,7.4118e+03_r8,7.0393e+01_r8/)
      kbo(:, 4,40,15) = (/ &
     &3.4890e+04_r8,2.6167e+04_r8,1.7445e+04_r8,8.7227e+03_r8,6.5151e+01_r8/)
      kbo(:, 5,40,15) = (/ &
     &4.0218e+04_r8,3.0164e+04_r8,2.0109e+04_r8,1.0055e+04_r8,6.0809e+01_r8/)
      kbo(:, 1,41,15) = (/ &
     &2.0620e+04_r8,1.5465e+04_r8,1.0310e+04_r8,5.1555e+03_r8,8.2333e+01_r8/)
      kbo(:, 2,41,15) = (/ &
     &2.5862e+04_r8,1.9396e+04_r8,1.2931e+04_r8,6.4659e+03_r8,7.6930e+01_r8/)
      kbo(:, 3,41,15) = (/ &
     &3.1429e+04_r8,2.3571e+04_r8,1.5714e+04_r8,7.8575e+03_r8,7.2080e+01_r8/)
      kbo(:, 4,41,15) = (/ &
     &3.7207e+04_r8,2.7905e+04_r8,1.8604e+04_r8,9.3022e+03_r8,6.6689e+01_r8/)
      kbo(:, 5,41,15) = (/ &
     &4.3090e+04_r8,3.2318e+04_r8,2.1545e+04_r8,1.0773e+04_r8,6.2194e+01_r8/)
      kbo(:, 1,42,15) = (/ &
     &2.1691e+04_r8,1.6268e+04_r8,1.0846e+04_r8,5.4231e+03_r8,8.4448e+01_r8/)
      kbo(:, 2,42,15) = (/ &
     &2.7444e+04_r8,2.0583e+04_r8,1.3722e+04_r8,6.8623e+03_r8,7.8791e+01_r8/)
      kbo(:, 3,42,15) = (/ &
     &3.3603e+04_r8,2.5202e+04_r8,1.6802e+04_r8,8.4010e+03_r8,7.3737e+01_r8/)
      kbo(:, 4,42,15) = (/ &
     &4.0024e+04_r8,3.0018e+04_r8,2.0012e+04_r8,1.0006e+04_r8,6.8167e+01_r8/)
      kbo(:, 5,42,15) = (/ &
     &4.6588e+04_r8,3.4941e+04_r8,2.3294e+04_r8,1.1647e+04_r8,6.3488e+01_r8/)
      kbo(:, 1,43,15) = (/ &
     &2.2603e+04_r8,1.6952e+04_r8,1.1302e+04_r8,5.6511e+03_r8,8.6896e+01_r8/)
      kbo(:, 2,43,15) = (/ &
     &2.8935e+04_r8,2.1702e+04_r8,1.4468e+04_r8,7.2343e+03_r8,8.0969e+01_r8/)
      kbo(:, 3,43,15) = (/ &
     &3.5766e+04_r8,2.6825e+04_r8,1.7883e+04_r8,8.9419e+03_r8,7.5666e+01_r8/)
      kbo(:, 4,43,15) = (/ &
     &4.2940e+04_r8,3.2205e+04_r8,2.1471e+04_r8,1.0736e+04_r8,6.9870e+01_r8/)
      kbo(:, 5,43,15) = (/ &
     &5.0307e+04_r8,3.7731e+04_r8,2.5154e+04_r8,1.2577e+04_r8,6.5095e+01_r8/)
      kbo(:, 1,44,15) = (/ &
     &2.3606e+04_r8,1.7705e+04_r8,1.1803e+04_r8,5.9018e+03_r8,8.9540e+01_r8/)
      kbo(:, 2,44,15) = (/ &
     &3.0627e+04_r8,2.2970e+04_r8,1.5314e+04_r8,7.6570e+03_r8,8.3300e+01_r8/)
      kbo(:, 3,44,15) = (/ &
     &3.8272e+04_r8,2.8704e+04_r8,1.9136e+04_r8,9.5682e+03_r8,7.7742e+01_r8/)
      kbo(:, 4,44,15) = (/ &
     &4.6369e+04_r8,3.4777e+04_r8,2.3185e+04_r8,1.1593e+04_r8,7.1787e+01_r8/)
      kbo(:, 5,44,15) = (/ &
     &5.4746e+04_r8,4.1060e+04_r8,2.7373e+04_r8,1.3687e+04_r8,6.6743e+01_r8/)
      kbo(:, 1,45,15) = (/ &
     &2.5020e+04_r8,1.8765e+04_r8,1.2510e+04_r8,6.2554e+03_r8,9.2249e+01_r8/)
      kbo(:, 2,45,15) = (/ &
     &3.2921e+04_r8,2.4691e+04_r8,1.6461e+04_r8,8.2305e+03_r8,8.5687e+01_r8/)
      kbo(:, 3,45,15) = (/ &
     &4.1630e+04_r8,3.1222e+04_r8,2.0815e+04_r8,1.0408e+04_r8,7.9854e+01_r8/)
      kbo(:, 4,45,15) = (/ &
     &5.0934e+04_r8,3.8200e+04_r8,2.5467e+04_r8,1.2734e+04_r8,7.3688e+01_r8/)
      kbo(:, 5,45,15) = (/ &
     &6.0623e+04_r8,4.5467e+04_r8,3.0312e+04_r8,1.5156e+04_r8,6.8450e+01_r8/)
      kbo(:, 1,46,15) = (/ &
     &2.6462e+04_r8,1.9847e+04_r8,1.3231e+04_r8,6.6159e+03_r8,9.5173e+01_r8/)
      kbo(:, 2,46,15) = (/ &
     &3.5388e+04_r8,2.6541e+04_r8,1.7694e+04_r8,8.8474e+03_r8,8.8256e+01_r8/)
      kbo(:, 3,46,15) = (/ &
     &4.5343e+04_r8,3.4008e+04_r8,2.2672e+04_r8,1.1336e+04_r8,8.2143e+01_r8/)
      kbo(:, 4,46,15) = (/ &
     &5.6094e+04_r8,4.2071e+04_r8,2.8047e+04_r8,1.4024e+04_r8,7.5728e+01_r8/)
      kbo(:, 5,46,15) = (/ &
     &6.7389e+04_r8,5.0542e+04_r8,3.3695e+04_r8,1.6848e+04_r8,7.0196e+01_r8/)
      kbo(:, 1,47,15) = (/ &
     &2.7156e+04_r8,2.0367e+04_r8,1.3578e+04_r8,6.7894e+03_r8,9.8564e+01_r8/)
      kbo(:, 2,47,15) = (/ &
     &3.7028e+04_r8,2.7771e+04_r8,1.8514e+04_r8,9.2574e+03_r8,9.1210e+01_r8/)
      kbo(:, 3,47,15) = (/ &
     &4.8225e+04_r8,3.6169e+04_r8,2.4113e+04_r8,1.2057e+04_r8,8.4753e+01_r8/)
      kbo(:, 4,47,15) = (/ &
     &6.0453e+04_r8,4.5340e+04_r8,3.0227e+04_r8,1.5114e+04_r8,7.8168e+01_r8/)
      kbo(:, 5,47,15) = (/ &
     &7.3441e+04_r8,5.5081e+04_r8,3.6721e+04_r8,1.8361e+04_r8,7.1964e+01_r8/)
      kbo(:, 1,48,15) = (/ &
     &2.8408e+04_r8,2.1306e+04_r8,1.4204e+04_r8,7.1024e+03_r8,1.0210e+02_r8/)
      kbo(:, 2,48,15) = (/ &
     &3.9561e+04_r8,2.9671e+04_r8,1.9781e+04_r8,9.8907e+03_r8,9.4282e+01_r8/)
      kbo(:, 3,48,15) = (/ &
     &5.2433e+04_r8,3.9325e+04_r8,2.6217e+04_r8,1.3109e+04_r8,8.7454e+01_r8/)
      kbo(:, 4,48,15) = (/ &
     &6.6685e+04_r8,5.0014e+04_r8,3.3343e+04_r8,1.6672e+04_r8,8.0648e+01_r8/)
      kbo(:, 5,48,15) = (/ &
     &8.1969e+04_r8,6.1477e+04_r8,4.0985e+04_r8,2.0493e+04_r8,7.3773e+01_r8/)
      kbo(:, 1,49,15) = (/ &
     &3.0665e+04_r8,2.2999e+04_r8,1.5333e+04_r8,7.6665e+03_r8,1.0579e+02_r8/)
      kbo(:, 2,49,15) = (/ &
     &4.3701e+04_r8,3.2776e+04_r8,2.1851e+04_r8,1.0926e+04_r8,9.7512e+01_r8/)
      kbo(:, 3,49,15) = (/ &
     &5.9013e+04_r8,4.4260e+04_r8,2.9506e+04_r8,1.4753e+04_r8,9.0273e+01_r8/)
      kbo(:, 4,49,15) = (/ &
     &7.6235e+04_r8,5.7177e+04_r8,3.8118e+04_r8,1.9059e+04_r8,8.3012e+01_r8/)
      kbo(:, 5,49,15) = (/ &
     &9.4928e+04_r8,7.1196e+04_r8,4.7464e+04_r8,2.3732e+04_r8,7.5643e+01_r8/)
      kbo(:, 1,50,15) = (/ &
     &3.1512e+04_r8,2.3634e+04_r8,1.5756e+04_r8,7.8783e+03_r8,1.0944e+02_r8/)
      kbo(:, 2,50,15) = (/ &
     &4.5989e+04_r8,3.4492e+04_r8,2.2995e+04_r8,1.1498e+04_r8,1.0069e+02_r8/)
      kbo(:, 3,50,15) = (/ &
     &6.3288e+04_r8,4.7466e+04_r8,3.1644e+04_r8,1.5822e+04_r8,9.3050e+01_r8/)
      kbo(:, 4,50,15) = (/ &
     &8.3061e+04_r8,6.2296e+04_r8,4.1531e+04_r8,2.0766e+04_r8,8.5379e+01_r8/)
      kbo(:, 5,50,15) = (/ &
     &1.0477e+05_r8,7.8579e+04_r8,5.2386e+04_r8,2.6193e+04_r8,7.7745e+01_r8/)
      kbo(:, 1,51,15) = (/ &
     &3.1512e+04_r8,2.3634e+04_r8,1.5756e+04_r8,7.8783e+03_r8,1.1317e+02_r8/)
      kbo(:, 2,51,15) = (/ &
     &4.7162e+04_r8,3.5373e+04_r8,2.3581e+04_r8,1.1791e+04_r8,1.0391e+02_r8/)
      kbo(:, 3,51,15) = (/ &
     &6.6209e+04_r8,4.9657e+04_r8,3.3105e+04_r8,1.6553e+04_r8,9.5852e+01_r8/)
      kbo(:, 4,51,15) = (/ &
     &8.8316e+04_r8,6.6238e+04_r8,4.4164e+04_r8,2.2080e+04_r8,8.8232e+01_r8/)
      kbo(:, 5,51,15) = (/ &
     &1.1292e+05_r8,8.4693e+04_r8,5.6462e+04_r8,2.8231e+04_r8,8.0003e+01_r8/)
      kbo(:, 1,52,15) = (/ &
     &3.2076e+04_r8,2.4057e+04_r8,1.6038e+04_r8,8.0198e+03_r8,1.1706e+02_r8/)
      kbo(:, 2,52,15) = (/ &
     &4.9342e+04_r8,3.7006e+04_r8,2.4671e+04_r8,1.2336e+04_r8,1.0727e+02_r8/)
      kbo(:, 3,52,15) = (/ &
     &7.0777e+04_r8,5.3083e+04_r8,3.5389e+04_r8,1.7695e+04_r8,9.8793e+01_r8/)
      kbo(:, 4,52,15) = (/ &
     &9.6072e+04_r8,7.2054e+04_r8,4.8037e+04_r8,2.4019e+04_r8,9.0662e+01_r8/)
      kbo(:, 5,52,15) = (/ &
     &1.2464e+05_r8,9.3484e+04_r8,6.2323e+04_r8,3.1162e+04_r8,8.2138e+01_r8/)
      kbo(:, 1,53,15) = (/ &
     &3.3608e+04_r8,2.5207e+04_r8,1.6805e+04_r8,8.4025e+03_r8,1.2114e+02_r8/)
      kbo(:, 2,53,15) = (/ &
     &5.3290e+04_r8,3.9968e+04_r8,2.6645e+04_r8,1.3323e+04_r8,1.1081e+02_r8/)
      kbo(:, 3,53,15) = (/ &
     &7.8269e+04_r8,5.8702e+04_r8,3.9135e+04_r8,1.9568e+04_r8,1.0185e+02_r8/)
      kbo(:, 4,53,15) = (/ &
     &1.0824e+05_r8,8.1183e+04_r8,5.4123e+04_r8,2.7062e+04_r8,9.3093e+01_r8/)
      kbo(:, 5,53,15) = (/ &
     &1.4266e+05_r8,1.0700e+05_r8,7.1333e+04_r8,3.5667e+04_r8,8.4356e+01_r8/)
      kbo(:, 1,54,15) = (/ &
     &3.0554e+04_r8,2.2916e+04_r8,1.5277e+04_r8,7.6389e+03_r8,1.2510e+02_r8/)
      kbo(:, 2,54,15) = (/ &
     &4.9936e+04_r8,3.7452e+04_r8,2.4968e+04_r8,1.2484e+04_r8,1.1423e+02_r8/)
      kbo(:, 3,54,15) = (/ &
     &7.5079e+04_r8,5.6309e+04_r8,3.7540e+04_r8,1.8770e+04_r8,1.0480e+02_r8/)
      kbo(:, 4,54,15) = (/ &
     &1.0578e+05_r8,7.9333e+04_r8,5.2889e+04_r8,2.6445e+04_r8,9.5981e+01_r8/)
      kbo(:, 5,54,15) = (/ &
     &1.4151e+05_r8,1.0613e+05_r8,7.0756e+04_r8,3.5378e+04_r8,8.6958e+01_r8/)
      kbo(:, 1,55,15) = (/ &
     &2.5242e+04_r8,1.8932e+04_r8,1.2621e+04_r8,6.3108e+03_r8,1.2910e+02_r8/)
      kbo(:, 2,55,15) = (/ &
     &4.2561e+04_r8,3.1921e+04_r8,2.1281e+04_r8,1.0641e+04_r8,1.1763e+02_r8/)
      kbo(:, 3,55,15) = (/ &
     &6.5579e+04_r8,4.9184e+04_r8,3.2790e+04_r8,1.6395e+04_r8,1.0775e+02_r8/)
      kbo(:, 4,55,15) = (/ &
     &9.4190e+04_r8,7.0643e+04_r8,4.7095e+04_r8,2.3548e+04_r8,9.9196e+01_r8/)
      kbo(:, 5,55,15) = (/ &
     &1.2798e+05_r8,9.5983e+04_r8,6.3989e+04_r8,3.1995e+04_r8,9.0570e+01_r8/)
      kbo(:, 1,56,15) = (/ &
     &2.0611e+04_r8,1.5459e+04_r8,1.0306e+04_r8,5.1530e+03_r8,1.3327e+02_r8/)
      kbo(:, 2,56,15) = (/ &
     &3.5961e+04_r8,2.6970e+04_r8,1.7980e+04_r8,8.9902e+03_r8,1.2118e+02_r8/)
      kbo(:, 3,56,15) = (/ &
     &5.6902e+04_r8,4.2676e+04_r8,2.8451e+04_r8,1.4227e+04_r8,1.1083e+02_r8/)
      kbo(:, 4,56,15) = (/ &
     &8.3426e+04_r8,6.2569e+04_r8,4.1713e+04_r8,2.0856e+04_r8,1.0187e+02_r8/)
      kbo(:, 5,56,15) = (/ &
     &1.1523e+05_r8,8.6424e+04_r8,5.7616e+04_r8,2.8808e+04_r8,9.3771e+01_r8/)
      kbo(:, 1,57,15) = (/ &
     &1.6610e+04_r8,1.2457e+04_r8,8.3049e+03_r8,4.1526e+03_r8,1.3769e+02_r8/)
      kbo(:, 2,57,15) = (/ &
     &3.0089e+04_r8,2.2567e+04_r8,1.5044e+04_r8,7.5226e+03_r8,1.2490e+02_r8/)
      kbo(:, 3,57,15) = (/ &
     &4.8979e+04_r8,3.6734e+04_r8,2.4489e+04_r8,1.2245e+04_r8,1.1405e+02_r8/)
      kbo(:, 4,57,15) = (/ &
     &7.3462e+04_r8,5.5096e+04_r8,3.6731e+04_r8,1.8365e+04_r8,1.0465e+02_r8/)
      kbo(:, 5,57,15) = (/ &
     &1.0326e+05_r8,7.7443e+04_r8,5.1628e+04_r8,2.5814e+04_r8,9.6480e+01_r8/)
      kbo(:, 1,58,15) = (/ &
     &3.5201e+03_r8,3.2274e+03_r8,2.7672e+03_r8,1.9382e+03_r8,1.4211e+02_r8/)
      kbo(:, 2,58,15) = (/ &
     &6.6315e+03_r8,6.0801e+03_r8,5.2132e+03_r8,3.6514e+03_r8,1.2863e+02_r8/)
      kbo(:, 3,58,15) = (/ &
     &1.1117e+04_r8,1.0193e+04_r8,8.7395e+03_r8,6.1212e+03_r8,1.1722e+02_r8/)
      kbo(:, 4,58,15) = (/ &
     &1.7057e+04_r8,1.5638e+04_r8,1.3409e+04_r8,9.3914e+03_r8,1.0740e+02_r8/)
      kbo(:, 5,58,15) = (/ &
     &2.4410e+04_r8,2.2380e+04_r8,1.9189e+04_r8,1.3440e+04_r8,9.8884e+01_r8/)
      kbo(:, 1,59,15) = (/ &
     &3.7699e+03_r8,3.2918e+03_r8,2.6257e+03_r8,1.6340e+03_r8,1.4398e+02_r8/)
      kbo(:, 2,59,15) = (/ &
     &7.2215e+03_r8,6.3055e+03_r8,5.0297e+03_r8,3.1299e+03_r8,1.3019e+02_r8/)
      kbo(:, 3,59,15) = (/ &
     &1.2258e+04_r8,1.0703e+04_r8,8.5377e+03_r8,5.3128e+03_r8,1.1856e+02_r8/)
      kbo(:, 4,59,15) = (/ &
     &1.8986e+04_r8,1.6578e+04_r8,1.3224e+04_r8,8.2288e+03_r8,1.0855e+02_r8/)
      kbo(:, 5,59,15) = (/ &
     &2.7379e+04_r8,2.3906e+04_r8,1.9069e+04_r8,1.1866e+04_r8,9.9884e+01_r8/)
      kbo(:, 1,13,16) = (/ &
     &1.4818e+04_r8,1.1113e+04_r8,7.4089e+03_r8,3.7045e+03_r8,1.1371e+01_r8/)
      kbo(:, 2,13,16) = (/ &
     &2.0739e+04_r8,1.5555e+04_r8,1.0370e+04_r8,5.1851e+03_r8,1.0985e+01_r8/)
      kbo(:, 3,13,16) = (/ &
     &2.7562e+04_r8,2.0672e+04_r8,1.3781e+04_r8,6.8906e+03_r8,1.0720e+01_r8/)
      kbo(:, 4,13,16) = (/ &
     &3.5104e+04_r8,2.6328e+04_r8,1.7552e+04_r8,8.7760e+03_r8,1.0594e+01_r8/)
      kbo(:, 5,13,16) = (/ &
     &4.3187e+04_r8,3.2390e+04_r8,2.1594e+04_r8,1.0797e+04_r8,1.0676e+01_r8/)
      kbo(:, 1,14,16) = (/ &
     &1.1265e+04_r8,8.4488e+03_r8,5.6325e+03_r8,2.8163e+03_r8,1.3004e+01_r8/)
      kbo(:, 2,14,16) = (/ &
     &1.5638e+04_r8,1.1729e+04_r8,7.8191e+03_r8,3.9096e+03_r8,1.2745e+01_r8/)
      kbo(:, 3,14,16) = (/ &
     &2.0632e+04_r8,1.5474e+04_r8,1.0316e+04_r8,5.1580e+03_r8,1.2511e+01_r8/)
      kbo(:, 4,14,16) = (/ &
     &2.6158e+04_r8,1.9619e+04_r8,1.3079e+04_r8,6.5395e+03_r8,1.2514e+01_r8/)
      kbo(:, 5,14,16) = (/ &
     &3.2161e+04_r8,2.4120e+04_r8,1.6080e+04_r8,8.0400e+03_r8,1.2574e+01_r8/)
      kbo(:, 1,15,16) = (/ &
     &8.6626e+03_r8,6.4970e+03_r8,4.3314e+03_r8,2.1657e+03_r8,1.5047e+01_r8/)
      kbo(:, 2,15,16) = (/ &
     &1.1944e+04_r8,8.8995e+03_r8,5.9720e+03_r8,2.9860e+03_r8,1.4804e+01_r8/)
      kbo(:, 3,15,16) = (/ &
     &1.5730e+04_r8,1.1798e+04_r8,7.8651e+03_r8,3.9326e+03_r8,1.4621e+01_r8/)
      kbo(:, 4,15,16) = (/ &
     &1.9953e+04_r8,1.4965e+04_r8,9.9768e+03_r8,4.9885e+03_r8,1.4704e+01_r8/)
      kbo(:, 5,15,16) = (/ &
     &2.4510e+04_r8,1.8382e+04_r8,1.2255e+04_r8,6.1276e+03_r8,1.4738e+01_r8/)
      kbo(:, 1,16,16) = (/ &
     &7.9177e+03_r8,5.9383e+03_r8,3.9589e+03_r8,1.9795e+03_r8,1.7379e+01_r8/)
      kbo(:, 2,16,16) = (/ &
     &1.0905e+04_r8,8.1790e+03_r8,5.4527e+03_r8,2.7264e+03_r8,1.7087e+01_r8/)
      kbo(:, 3,16,16) = (/ &
     &1.4336e+04_r8,1.0752e+04_r8,7.1680e+03_r8,3.5840e+03_r8,1.7079e+01_r8/)
      kbo(:, 4,16,16) = (/ &
     &1.8134e+04_r8,1.3600e+04_r8,9.0670e+03_r8,4.5335e+03_r8,1.7162e+01_r8/)
      kbo(:, 5,16,16) = (/ &
     &2.2206e+04_r8,1.6655e+04_r8,1.1103e+04_r8,5.5517e+03_r8,1.7193e+01_r8/)
      kbo(:, 1,17,16) = (/ &
     &7.5178e+03_r8,5.6384e+03_r8,3.7589e+03_r8,1.8795e+03_r8,1.9948e+01_r8/)
      kbo(:, 2,17,16) = (/ &
     &1.0311e+04_r8,7.7335e+03_r8,5.1557e+03_r8,2.5779e+03_r8,1.9796e+01_r8/)
      kbo(:, 3,17,16) = (/ &
     &1.3498e+04_r8,1.0124e+04_r8,6.7488e+03_r8,3.3746e+03_r8,1.9858e+01_r8/)
      kbo(:, 4,17,16) = (/ &
     &1.6996e+04_r8,1.2747e+04_r8,8.4978e+03_r8,4.2489e+03_r8,1.9944e+01_r8/)
      kbo(:, 5,17,16) = (/ &
     &2.0726e+04_r8,1.5544e+04_r8,1.0363e+04_r8,5.1815e+03_r8,1.9956e+01_r8/)
      kbo(:, 1,18,16) = (/ &
     &7.2889e+03_r8,5.4667e+03_r8,3.6445e+03_r8,1.8223e+03_r8,2.3259e+01_r8/)
      kbo(:, 2,18,16) = (/ &
     &9.9353e+03_r8,7.4515e+03_r8,4.9677e+03_r8,2.4839e+03_r8,2.3214e+01_r8/)
      kbo(:, 3,18,16) = (/ &
     &1.2928e+04_r8,9.6956e+03_r8,6.4638e+03_r8,3.2319e+03_r8,2.3116e+01_r8/)
      kbo(:, 4,18,16) = (/ &
     &1.6189e+04_r8,1.2142e+04_r8,8.0944e+03_r8,4.0472e+03_r8,2.3106e+01_r8/)
      kbo(:, 5,18,16) = (/ &
     &1.9640e+04_r8,1.4730e+04_r8,9.8201e+03_r8,4.9101e+03_r8,2.3045e+01_r8/)
      kbo(:, 1,19,16) = (/ &
     &6.8892e+03_r8,5.1669e+03_r8,3.4446e+03_r8,1.7223e+03_r8,2.7312e+01_r8/)
      kbo(:, 2,19,16) = (/ &
     &9.3210e+03_r8,6.9908e+03_r8,4.6605e+03_r8,2.3303e+03_r8,2.7199e+01_r8/)
      kbo(:, 3,19,16) = (/ &
     &1.2050e+04_r8,9.0375e+03_r8,6.0250e+03_r8,3.0125e+03_r8,2.6980e+01_r8/)
      kbo(:, 4,19,16) = (/ &
     &1.5046e+04_r8,1.1284e+04_r8,7.5228e+03_r8,3.7614e+03_r8,2.6786e+01_r8/)
      kbo(:, 5,19,16) = (/ &
     &1.8241e+04_r8,1.3681e+04_r8,9.1205e+03_r8,4.5603e+03_r8,2.6595e+01_r8/)
      kbo(:, 1,20,16) = (/ &
     &7.0094e+03_r8,5.2570e+03_r8,3.5047e+03_r8,1.7524e+03_r8,3.2009e+01_r8/)
      kbo(:, 2,20,16) = (/ &
     &9.4364e+03_r8,7.0773e+03_r8,4.7182e+03_r8,2.3591e+03_r8,3.1788e+01_r8/)
      kbo(:, 3,20,16) = (/ &
     &1.2173e+04_r8,9.1297e+03_r8,6.0865e+03_r8,3.0433e+03_r8,3.1450e+01_r8/)
      kbo(:, 4,20,16) = (/ &
     &1.5155e+04_r8,1.1367e+04_r8,7.5778e+03_r8,3.7889e+03_r8,3.1059e+01_r8/)
      kbo(:, 5,20,16) = (/ &
     &1.8307e+04_r8,1.3730e+04_r8,9.1534e+03_r8,4.5767e+03_r8,3.0674e+01_r8/)
      kbo(:, 1,21,16) = (/ &
     &7.3306e+03_r8,5.4980e+03_r8,3.6654e+03_r8,1.8327e+03_r8,3.7355e+01_r8/)
      kbo(:, 2,21,16) = (/ &
     &9.8238e+03_r8,7.3679e+03_r8,4.9119e+03_r8,2.4560e+03_r8,3.6998e+01_r8/)
      kbo(:, 3,21,16) = (/ &
     &1.2609e+04_r8,9.4571e+03_r8,6.3047e+03_r8,3.1524e+03_r8,3.6493e+01_r8/)
      kbo(:, 4,21,16) = (/ &
     &1.5617e+04_r8,1.1713e+04_r8,7.8084e+03_r8,3.9042e+03_r8,3.5962e+01_r8/)
      kbo(:, 5,21,16) = (/ &
     &1.8773e+04_r8,1.4079e+04_r8,9.3863e+03_r8,4.6932e+03_r8,3.5346e+01_r8/)
      kbo(:, 1,22,16) = (/ &
     &7.9668e+03_r8,5.9751e+03_r8,3.9834e+03_r8,1.9917e+03_r8,4.3325e+01_r8/)
      kbo(:, 2,22,16) = (/ &
     &1.0571e+04_r8,7.9286e+03_r8,5.2858e+03_r8,2.6429e+03_r8,4.2793e+01_r8/)
      kbo(:, 3,22,16) = (/ &
     &1.3449e+04_r8,1.0087e+04_r8,6.7244e+03_r8,3.3622e+03_r8,4.2221e+01_r8/)
      kbo(:, 4,22,16) = (/ &
     &1.6524e+04_r8,1.2393e+04_r8,8.2619e+03_r8,4.1310e+03_r8,4.1607e+01_r8/)
      kbo(:, 5,22,16) = (/ &
     &1.9754e+04_r8,1.4816e+04_r8,9.8771e+03_r8,4.9386e+03_r8,4.0888e+01_r8/)
      kbo(:, 1,23,16) = (/ &
     &8.6210e+03_r8,6.4658e+03_r8,4.3105e+03_r8,2.1553e+03_r8,5.0428e+01_r8/)
      kbo(:, 2,23,16) = (/ &
     &1.1316e+04_r8,8.4866e+03_r8,5.6578e+03_r8,2.8289e+03_r8,4.9764e+01_r8/)
      kbo(:, 3,23,16) = (/ &
     &1.4291e+04_r8,1.0718e+04_r8,7.1454e+03_r8,3.5727e+03_r8,4.9049e+01_r8/)
      kbo(:, 4,23,16) = (/ &
     &1.7469e+04_r8,1.3102e+04_r8,8.7344e+03_r8,4.3672e+03_r8,4.8146e+01_r8/)
      kbo(:, 5,23,16) = (/ &
     &2.0774e+04_r8,1.5580e+04_r8,1.0387e+04_r8,5.1935e+03_r8,4.7113e+01_r8/)
      kbo(:, 1,24,16) = (/ &
     &9.2015e+03_r8,6.9011e+03_r8,4.6008e+03_r8,2.3004e+03_r8,5.8527e+01_r8/)
      kbo(:, 2,24,16) = (/ &
     &1.1985e+04_r8,8.9232e+03_r8,5.9928e+03_r8,2.9964e+03_r8,5.7489e+01_r8/)
      kbo(:, 3,24,16) = (/ &
     &1.5026e+04_r8,1.1269e+04_r8,7.5129e+03_r8,3.7565e+03_r8,5.6333e+01_r8/)
      kbo(:, 4,24,16) = (/ &
     &1.8238e+04_r8,1.3679e+04_r8,9.1191e+03_r8,4.5596e+03_r8,5.5030e+01_r8/)
      kbo(:, 5,24,16) = (/ &
     &2.1539e+04_r8,1.6154e+04_r8,1.0769e+04_r8,5.3848e+03_r8,5.3599e+01_r8/)
      kbo(:, 1,25,16) = (/ &
     &9.9033e+03_r8,7.4275e+03_r8,4.9517e+03_r8,2.4759e+03_r8,6.7091e+01_r8/)
      kbo(:, 2,25,16) = (/ &
     &1.2768e+04_r8,9.5762e+03_r8,6.3841e+03_r8,3.1921e+03_r8,6.5542e+01_r8/)
      kbo(:, 3,25,16) = (/ &
     &1.5871e+04_r8,1.1903e+04_r8,7.9355e+03_r8,3.9678e+03_r8,6.3831e+01_r8/)
      kbo(:, 4,25,16) = (/ &
     &1.9110e+04_r8,1.4333e+04_r8,9.5551e+03_r8,4.7776e+03_r8,6.2029e+01_r8/)
      kbo(:, 5,25,16) = (/ &
     &2.2417e+04_r8,1.6813e+04_r8,1.1208e+04_r8,5.6043e+03_r8,6.0136e+01_r8/)
      kbo(:, 1,26,16) = (/ &
     &1.0777e+04_r8,8.0825e+03_r8,5.3884e+03_r8,2.6942e+03_r8,7.5807e+01_r8/)
      kbo(:, 2,26,16) = (/ &
     &1.3749e+04_r8,1.0312e+04_r8,6.8746e+03_r8,3.4373e+03_r8,7.3586e+01_r8/)
      kbo(:, 3,26,16) = (/ &
     &1.6921e+04_r8,1.2690e+04_r8,8.4603e+03_r8,4.2302e+03_r8,7.1246e+01_r8/)
      kbo(:, 4,26,16) = (/ &
     &2.0227e+04_r8,1.5170e+04_r8,1.0114e+04_r8,5.0568e+03_r8,6.8870e+01_r8/)
      kbo(:, 5,26,16) = (/ &
     &2.3585e+04_r8,1.7688e+04_r8,1.1792e+04_r8,5.8962e+03_r8,6.6424e+01_r8/)
      kbo(:, 1,27,16) = (/ &
     &1.2052e+04_r8,9.0388e+03_r8,6.0259e+03_r8,3.0130e+03_r8,8.4316e+01_r8/)
      kbo(:, 2,27,16) = (/ &
     &1.5222e+04_r8,1.1417e+04_r8,7.6111e+03_r8,3.8056e+03_r8,8.1386e+01_r8/)
      kbo(:, 3,27,16) = (/ &
     &1.8590e+04_r8,1.3942e+04_r8,9.2948e+03_r8,4.6474e+03_r8,7.8348e+01_r8/)
      kbo(:, 4,27,16) = (/ &
     &2.2058e+04_r8,1.6543e+04_r8,1.1029e+04_r8,5.5145e+03_r8,7.5340e+01_r8/)
      kbo(:, 5,27,16) = (/ &
     &2.5550e+04_r8,1.9162e+04_r8,1.2775e+04_r8,6.3875e+03_r8,7.2329e+01_r8/)
      kbo(:, 1,28,16) = (/ &
     &1.3724e+04_r8,1.0293e+04_r8,6.8620e+03_r8,3.4310e+03_r8,9.2351e+01_r8/)
      kbo(:, 2,28,16) = (/ &
     &1.7171e+04_r8,1.2878e+04_r8,8.5855e+03_r8,4.2928e+03_r8,8.8670e+01_r8/)
      kbo(:, 3,28,16) = (/ &
     &2.0788e+04_r8,1.5591e+04_r8,1.0394e+04_r8,5.1970e+03_r8,8.4928e+01_r8/)
      kbo(:, 4,28,16) = (/ &
     &2.4487e+04_r8,1.8365e+04_r8,1.2244e+04_r8,6.1218e+03_r8,8.1255e+01_r8/)
      kbo(:, 5,28,16) = (/ &
     &2.8173e+04_r8,2.1130e+04_r8,1.4087e+04_r8,7.0433e+03_r8,7.7666e+01_r8/)
      kbo(:, 1,29,16) = (/ &
     &1.6469e+04_r8,1.2352e+04_r8,8.2344e+03_r8,4.1172e+03_r8,9.9675e+01_r8/)
      kbo(:, 2,29,16) = (/ &
     &2.0402e+04_r8,1.5302e+04_r8,1.0201e+04_r8,5.1006e+03_r8,9.5182e+01_r8/)
      kbo(:, 3,29,16) = (/ &
     &2.4499e+04_r8,1.8374e+04_r8,1.2249e+04_r8,6.1246e+03_r8,9.0759e+01_r8/)
      kbo(:, 4,29,16) = (/ &
     &2.8632e+04_r8,2.1474e+04_r8,1.4316e+04_r8,7.1579e+03_r8,8.6444e+01_r8/)
      kbo(:, 5,29,16) = (/ &
     &3.2723e+04_r8,2.4542e+04_r8,1.6361e+04_r8,8.1807e+03_r8,8.2287e+01_r8/)
      kbo(:, 1,30,16) = (/ &
     &2.0078e+04_r8,1.5058e+04_r8,1.0039e+04_r8,5.0195e+03_r8,1.0609e+02_r8/)
      kbo(:, 2,30,16) = (/ &
     &2.4638e+04_r8,1.8479e+04_r8,1.2319e+04_r8,6.1595e+03_r8,1.0084e+02_r8/)
      kbo(:, 3,30,16) = (/ &
     &2.9329e+04_r8,2.1997e+04_r8,1.4664e+04_r8,7.3322e+03_r8,9.5740e+01_r8/)
      kbo(:, 4,30,16) = (/ &
     &3.4034e+04_r8,2.5525e+04_r8,1.7017e+04_r8,8.5085e+03_r8,9.0849e+01_r8/)
      kbo(:, 5,30,16) = (/ &
     &3.8657e+04_r8,2.8993e+04_r8,1.9329e+04_r8,9.6643e+03_r8,8.6169e+01_r8/)
      kbo(:, 1,31,16) = (/ &
     &2.5548e+04_r8,1.9161e+04_r8,1.2774e+04_r8,6.3870e+03_r8,1.1146e+02_r8/)
      kbo(:, 2,31,16) = (/ &
     &3.1052e+04_r8,2.3289e+04_r8,1.5526e+04_r8,7.7630e+03_r8,1.0555e+02_r8/)
      kbo(:, 3,31,16) = (/ &
     &3.6674e+04_r8,2.7505e+04_r8,1.8172e+04_r8,9.1684e+03_r8,9.9833e+01_r8/)
      kbo(:, 4,31,16) = (/ &
     &4.2278e+04_r8,3.1708e+04_r8,2.1139e+04_r8,1.0569e+04_r8,9.4413e+01_r8/)
      kbo(:, 5,31,16) = (/ &
     &4.7725e+04_r8,3.5794e+04_r8,2.3863e+04_r8,1.1931e+04_r8,8.9289e+01_r8/)
      kbo(:, 1,32,16) = (/ &
     &3.2648e+04_r8,2.4486e+04_r8,1.6324e+04_r8,8.1620e+03_r8,1.1579e+02_r8/)
      kbo(:, 2,32,16) = (/ &
     &3.9333e+04_r8,2.9500e+04_r8,1.9666e+04_r8,9.8333e+03_r8,1.0928e+02_r8/)
      kbo(:, 3,32,16) = (/ &
     &4.6114e+04_r8,3.4586e+04_r8,2.3057e+04_r8,1.1529e+04_r8,1.0305e+02_r8/)
      kbo(:, 4,32,16) = (/ &
     &5.2809e+04_r8,3.9607e+04_r8,2.6404e+04_r8,1.3202e+04_r8,9.7184e+01_r8/)
      kbo(:, 5,32,16) = (/ &
     &5.9284e+04_r8,4.4463e+04_r8,2.9311e+04_r8,1.4821e+04_r8,9.1687e+01_r8/)
      kbo(:, 1,33,16) = (/ &
     &4.2212e+04_r8,3.1659e+04_r8,2.1106e+04_r8,1.0553e+04_r8,1.1913e+02_r8/)
      kbo(:, 2,33,16) = (/ &
     &5.0427e+04_r8,3.7820e+04_r8,2.5214e+04_r8,1.2607e+04_r8,1.1210e+02_r8/)
      kbo(:, 3,33,16) = (/ &
     &5.8684e+04_r8,4.4013e+04_r8,2.9342e+04_r8,1.4671e+04_r8,1.0546e+02_r8/)
      kbo(:, 4,33,16) = (/ &
     &6.6793e+04_r8,5.0095e+04_r8,3.3396e+04_r8,1.6698e+04_r8,9.9210e+01_r8/)
      kbo(:, 5,33,16) = (/ &
     &7.4575e+04_r8,5.5932e+04_r8,3.7288e+04_r8,1.8644e+04_r8,9.3412e+01_r8/)
      kbo(:, 1,34,16) = (/ &
     &5.2540e+04_r8,3.9405e+04_r8,2.6270e+04_r8,1.3135e+04_r8,1.2180e+02_r8/)
      kbo(:, 2,34,16) = (/ &
     &6.2330e+04_r8,4.6748e+04_r8,3.1165e+04_r8,1.5582e+04_r8,1.1436e+02_r8/)
      kbo(:, 3,34,16) = (/ &
     &7.2093e+04_r8,5.4070e+04_r8,3.6046e+04_r8,1.8023e+04_r8,1.0734e+02_r8/)
      kbo(:, 4,34,16) = (/ &
     &8.1593e+04_r8,6.1194e+04_r8,4.0796e+04_r8,2.0398e+04_r8,1.0080e+02_r8/)
      kbo(:, 5,34,16) = (/ &
     &9.0697e+04_r8,6.8023e+04_r8,4.5349e+04_r8,2.2674e+04_r8,9.4753e+01_r8/)
      kbo(:, 1,35,16) = (/ &
     &6.4051e+04_r8,4.8038e+04_r8,3.2026e+04_r8,1.6013e+04_r8,1.2446e+02_r8/)
      kbo(:, 2,35,16) = (/ &
     &7.5644e+04_r8,5.6733e+04_r8,3.7822e+04_r8,1.8911e+04_r8,1.1662e+02_r8/)
      kbo(:, 3,35,16) = (/ &
     &8.7172e+04_r8,6.5379e+04_r8,4.3586e+04_r8,2.1792e+04_r8,1.0929e+02_r8/)
      kbo(:, 4,35,16) = (/ &
     &9.8380e+04_r8,7.3786e+04_r8,4.9191e+04_r8,2.4595e+04_r8,1.0249e+02_r8/)
      kbo(:, 5,35,16) = (/ &
     &1.0903e+05_r8,8.1776e+04_r8,5.4517e+04_r8,2.7259e+04_r8,9.6197e+01_r8/)
      kbo(:, 1,36,16) = (/ &
     &7.5878e+04_r8,5.6908e+04_r8,3.7939e+04_r8,1.8969e+04_r8,1.2742e+02_r8/)
      kbo(:, 2,36,16) = (/ &
     &8.9471e+04_r8,6.7103e+04_r8,4.4735e+04_r8,2.2368e+04_r8,1.1920e+02_r8/)
      kbo(:, 3,36,16) = (/ &
     &1.0302e+05_r8,7.7263e+04_r8,5.1509e+04_r8,2.5436e+04_r8,1.1154e+02_r8/)
      kbo(:, 4,36,16) = (/ &
     &1.1614e+05_r8,8.7108e+04_r8,5.8072e+04_r8,2.9036e+04_r8,1.0445e+02_r8/)
      kbo(:, 5,36,16) = (/ &
     &1.2862e+05_r8,9.6465e+04_r8,6.4310e+04_r8,3.2155e+04_r8,9.7922e+01_r8/)
      kbo(:, 1,37,16) = (/ &
     &8.5083e+04_r8,6.3812e+04_r8,4.2541e+04_r8,2.1271e+04_r8,1.3125e+02_r8/)
      kbo(:, 2,37,16) = (/ &
     &1.0058e+05_r8,7.5436e+04_r8,5.0291e+04_r8,2.5145e+04_r8,1.2185e+02_r8/)
      kbo(:, 3,37,16) = (/ &
     &1.1610e+05_r8,8.7073e+04_r8,5.8049e+04_r8,2.9024e+04_r8,1.1457e+02_r8/)
      kbo(:, 4,37,16) = (/ &
     &1.3117e+05_r8,9.8374e+04_r8,6.5582e+04_r8,3.2791e+04_r8,1.0715e+02_r8/)
      kbo(:, 5,37,16) = (/ &
     &1.4551e+05_r8,1.0913e+05_r8,7.2757e+04_r8,3.6378e+04_r8,1.0034e+02_r8/)
      kbo(:, 1,38,16) = (/ &
     &9.5077e+04_r8,7.2333e+04_r8,4.8222e+04_r8,2.4111e+04_r8,1.3486e+02_r8/)
      kbo(:, 2,38,16) = (/ &
     &1.1439e+05_r8,8.5793e+04_r8,5.7195e+04_r8,2.8598e+04_r8,1.2580e+02_r8/)
      kbo(:, 3,38,16) = (/ &
     &1.3231e+05_r8,9.9236e+04_r8,6.6157e+04_r8,3.3078e+04_r8,1.1743e+02_r8/)
      kbo(:, 4,38,16) = (/ &
     &1.4989e+05_r8,1.1242e+05_r8,7.4945e+04_r8,3.7472e+04_r8,1.0969e+02_r8/)
      kbo(:, 5,38,16) = (/ &
     &1.6664e+05_r8,1.2498e+05_r8,8.3321e+04_r8,4.1660e+04_r8,1.0261e+02_r8/)
      kbo(:, 1,39,16) = (/ &
     &1.1158e+05_r8,8.3685e+04_r8,5.5790e+04_r8,2.7895e+04_r8,1.3820e+02_r8/)
      kbo(:, 2,39,16) = (/ &
     &1.3280e+05_r8,9.9602e+04_r8,6.6401e+04_r8,3.3201e+04_r8,1.2875e+02_r8/)
      kbo(:, 3,39,16) = (/ &
     &1.5408e+05_r8,1.1556e+05_r8,7.7040e+04_r8,3.8520e+04_r8,1.2007e+02_r8/)
      kbo(:, 4,39,16) = (/ &
     &1.7495e+05_r8,1.3121e+05_r8,8.7476e+04_r8,4.3738e+04_r8,1.1204e+02_r8/)
      kbo(:, 5,39,16) = (/ &
     &1.9488e+05_r8,1.4616e+05_r8,9.7443e+04_r8,4.8722e+04_r8,1.0472e+02_r8/)
      kbo(:, 1,40,16) = (/ &
     &1.1876e+05_r8,8.9071e+04_r8,5.9380e+04_r8,2.9690e+04_r8,1.4235e+02_r8/)
      kbo(:, 2,40,16) = (/ &
     &1.4221e+05_r8,1.0666e+05_r8,7.1106e+04_r8,3.5553e+04_r8,1.3244e+02_r8/)
      kbo(:, 3,40,16) = (/ &
     &1.6587e+05_r8,1.2440e+05_r8,8.2934e+04_r8,4.1467e+04_r8,1.2341e+02_r8/)
      kbo(:, 4,40,16) = (/ &
     &1.8920e+05_r8,1.4190e+05_r8,9.4601e+04_r8,4.7300e+04_r8,1.1506e+02_r8/)
      kbo(:, 5,40,16) = (/ &
     &2.1165e+05_r8,1.5874e+05_r8,1.0583e+05_r8,5.2913e+04_r8,1.0743e+02_r8/)
      kbo(:, 1,41,16) = (/ &
     &1.2546e+05_r8,9.4099e+04_r8,6.2733e+04_r8,3.1367e+04_r8,1.4657e+02_r8/)
      kbo(:, 2,41,16) = (/ &
     &1.5125e+05_r8,1.1344e+05_r8,7.5625e+04_r8,3.7812e+04_r8,1.3531e+02_r8/)
      kbo(:, 3,41,16) = (/ &
     &1.7744e+05_r8,1.3308e+05_r8,8.8723e+04_r8,4.4362e+04_r8,1.2676e+02_r8/)
      kbo(:, 4,41,16) = (/ &
     &2.0341e+05_r8,1.5256e+05_r8,1.0171e+05_r8,5.0854e+04_r8,1.1810e+02_r8/)
      kbo(:, 5,41,16) = (/ &
     &2.2858e+05_r8,1.7144e+05_r8,1.1429e+05_r8,5.7146e+04_r8,1.1015e+02_r8/)
      kbo(:, 1,42,16) = (/ &
     &1.3356e+05_r8,1.0017e+05_r8,6.6777e+04_r8,3.3389e+04_r8,1.5077e+02_r8/)
      kbo(:, 2,42,16) = (/ &
     &1.6221e+05_r8,1.2166e+05_r8,8.1105e+04_r8,4.0545e+04_r8,1.3986e+02_r8/)
      kbo(:, 3,42,16) = (/ &
     &1.9146e+05_r8,1.4359e+05_r8,9.5729e+04_r8,4.7864e+04_r8,1.3005e+02_r8/)
      kbo(:, 4,42,16) = (/ &
     &2.1781e+05_r8,1.6546e+05_r8,1.1031e+05_r8,5.5153e+04_r8,1.2109e+02_r8/)
      kbo(:, 5,42,16) = (/ &
     &2.4912e+05_r8,1.8684e+05_r8,1.2456e+05_r8,6.2279e+04_r8,1.1284e+02_r8/)
      kbo(:, 1,43,16) = (/ &
     &1.4126e+05_r8,1.0594e+05_r8,7.0630e+04_r8,3.5315e+04_r8,1.5567e+02_r8/)
      kbo(:, 2,43,16) = (/ &
     &1.7322e+05_r8,1.2992e+05_r8,8.6612e+04_r8,4.3306e+04_r8,1.4408e+02_r8/)
      kbo(:, 3,43,16) = (/ &
     &2.0611e+05_r8,1.5458e+05_r8,1.0200e+05_r8,5.1528e+04_r8,1.3385e+02_r8/)
      kbo(:, 4,43,16) = (/ &
     &2.3919e+05_r8,1.7940e+05_r8,1.1960e+05_r8,5.9799e+04_r8,1.2454e+02_r8/)
      kbo(:, 5,43,16) = (/ &
     &2.7160e+05_r8,2.0370e+05_r8,1.3580e+05_r8,6.7900e+04_r8,1.1596e+02_r8/)
      kbo(:, 1,44,16) = (/ &
     &1.5000e+05_r8,1.1250e+05_r8,7.5001e+04_r8,3.7500e+04_r8,1.6094e+02_r8/)
      kbo(:, 2,44,16) = (/ &
     &1.8602e+05_r8,1.3952e+05_r8,9.3011e+04_r8,4.6505e+04_r8,1.4866e+02_r8/)
      kbo(:, 3,44,16) = (/ &
     &2.2342e+05_r8,1.6756e+05_r8,1.1171e+05_r8,5.5854e+04_r8,1.3792e+02_r8/)
      kbo(:, 4,44,16) = (/ &
     &2.6122e+05_r8,1.9592e+05_r8,1.3061e+05_r8,6.5304e+04_r8,1.2823e+02_r8/)
      kbo(:, 5,44,16) = (/ &
     &2.9874e+05_r8,2.2406e+05_r8,1.4937e+05_r8,7.4685e+04_r8,1.1932e+02_r8/)
      kbo(:, 1,45,16) = (/ &
     &1.6171e+05_r8,1.2128e+05_r8,8.0854e+04_r8,4.0427e+04_r8,1.6635e+02_r8/)
      kbo(:, 2,45,16) = (/ &
     &2.0304e+05_r8,1.5228e+05_r8,1.0152e+05_r8,5.0760e+04_r8,1.5336e+02_r8/)
      kbo(:, 3,45,16) = (/ &
     &2.4630e+05_r8,1.8473e+05_r8,1.2315e+05_r8,6.1576e+04_r8,1.4204e+02_r8/)
      kbo(:, 4,45,16) = (/ &
     &2.9041e+05_r8,2.1781e+05_r8,1.4520e+05_r8,7.2602e+04_r8,1.3193e+02_r8/)
      kbo(:, 5,45,16) = (/ &
     &3.3433e+05_r8,2.5074e+05_r8,1.6716e+05_r8,8.3581e+04_r8,1.2271e+02_r8/)
      kbo(:, 1,46,16) = (/ &
     &1.7432e+05_r8,1.3074e+05_r8,8.7162e+04_r8,4.3581e+04_r8,1.7227e+02_r8/)
      kbo(:, 2,46,16) = (/ &
     &2.2186e+05_r8,1.6640e+05_r8,1.1093e+05_r8,5.5465e+04_r8,1.5849e+02_r8/)
      kbo(:, 3,46,16) = (/ &
     &2.7221e+05_r8,2.0416e+05_r8,1.3611e+05_r8,6.8053e+04_r8,1.4648e+02_r8/)
      kbo(:, 4,46,16) = (/ &
     &3.2411e+05_r8,2.4308e+05_r8,1.6205e+05_r8,8.1026e+04_r8,1.3593e+02_r8/)
      kbo(:, 5,46,16) = (/ &
     &3.7610e+05_r8,2.8208e+05_r8,1.8805e+05_r8,9.4025e+04_r8,1.2634e+02_r8/)
      kbo(:, 1,47,16) = (/ &
     &1.8289e+05_r8,1.3717e+05_r8,9.1447e+04_r8,4.5723e+04_r8,1.7909e+02_r8/)
      kbo(:, 2,47,16) = (/ &
     &2.3679e+05_r8,1.7759e+05_r8,1.1839e+05_r8,5.9198e+04_r8,1.6436e+02_r8/)
      kbo(:, 3,47,16) = (/ &
     &2.9447e+05_r8,2.2085e+05_r8,1.4724e+05_r8,7.3618e+04_r8,1.5159e+02_r8/)
      kbo(:, 4,47,16) = (/ &
     &3.5454e+05_r8,2.6590e+05_r8,1.7727e+05_r8,8.8635e+04_r8,1.4045e+02_r8/)
      kbo(:, 5,47,16) = (/ &
     &4.1548e+05_r8,3.1161e+05_r8,2.0774e+05_r8,1.0387e+05_r8,1.3046e+02_r8/)
      kbo(:, 1,48,16) = (/ &
     &1.9579e+05_r8,1.4684e+05_r8,9.7896e+04_r8,4.8948e+04_r8,1.8623e+02_r8/)
      kbo(:, 2,48,16) = (/ &
     &2.5824e+05_r8,1.9368e+05_r8,1.2912e+05_r8,6.4559e+04_r8,1.7055e+02_r8/)
      kbo(:, 3,48,16) = (/ &
     &3.2608e+05_r8,2.4456e+05_r8,1.6304e+05_r8,8.0315e+04_r8,1.5696e+02_r8/)
      kbo(:, 4,48,16) = (/ &
     &3.9734e+05_r8,2.9801e+05_r8,1.9867e+05_r8,9.9336e+04_r8,1.4512e+02_r8/)
      kbo(:, 5,48,16) = (/ &
     &4.7039e+05_r8,3.5279e+05_r8,2.3519e+05_r8,1.1760e+05_r8,1.3467e+02_r8/)
      kbo(:, 1,49,16) = (/ &
     &2.1650e+05_r8,1.6238e+05_r8,1.0825e+05_r8,5.4125e+04_r8,1.9381e+02_r8/)
      kbo(:, 2,49,16) = (/ &
     &2.9149e+05_r8,2.1861e+05_r8,1.4574e+05_r8,7.2871e+04_r8,1.7704e+02_r8/)
      kbo(:, 3,49,16) = (/ &
     &3.7402e+05_r8,2.8052e+05_r8,1.8701e+05_r8,9.3505e+04_r8,1.6258e+02_r8/)
      kbo(:, 4,49,16) = (/ &
     &4.6192e+05_r8,3.4644e+05_r8,2.3096e+05_r8,1.1548e+05_r8,1.4999e+02_r8/)
      kbo(:, 5,49,16) = (/ &
     &5.5289e+05_r8,4.1467e+05_r8,2.7644e+05_r8,1.3822e+05_r8,1.3901e+02_r8/)
      kbo(:, 1,50,16) = (/ &
     &2.2791e+05_r8,1.7093e+05_r8,1.1395e+05_r8,5.6977e+04_r8,2.0134e+02_r8/)
      kbo(:, 2,50,16) = (/ &
     &3.1325e+05_r8,2.3494e+05_r8,1.5662e+05_r8,7.8312e+04_r8,1.8345e+02_r8/)
      kbo(:, 3,50,16) = (/ &
     &4.0878e+05_r8,3.0659e+05_r8,2.0439e+05_r8,1.0220e+05_r8,1.6811e+02_r8/)
      kbo(:, 4,50,16) = (/ &
     &5.1152e+05_r8,3.8364e+05_r8,2.5576e+05_r8,1.2788e+05_r8,1.5482e+02_r8/)
      kbo(:, 5,50,16) = (/ &
     &6.1913e+05_r8,4.6434e+05_r8,3.0956e+05_r8,1.5478e+05_r8,1.4323e+02_r8/)
      kbo(:, 1,51,16) = (/ &
     &2.3351e+05_r8,1.7513e+05_r8,1.1675e+05_r8,5.8377e+04_r8,2.0909e+02_r8/)
      kbo(:, 2,51,16) = (/ &
     &3.2811e+05_r8,2.4608e+05_r8,1.6406e+05_r8,8.2029e+04_r8,1.9001e+02_r8/)
      kbo(:, 3,51,16) = (/ &
     &4.3579e+05_r8,3.2684e+05_r8,2.1790e+05_r8,1.0895e+05_r8,1.7377e+02_r8/)
      kbo(:, 4,51,16) = (/ &
     &5.5314e+05_r8,4.1486e+05_r8,2.7653e+05_r8,1.3829e+05_r8,1.5970e+02_r8/)
      kbo(:, 5,51,16) = (/ &
     &6.7717e+05_r8,5.0788e+05_r8,3.3859e+05_r8,1.6929e+05_r8,1.4750e+02_r8/)
      kbo(:, 1,52,16) = (/ &
     &2.4395e+05_r8,1.8296e+05_r8,1.2197e+05_r8,6.0984e+04_r8,2.1739e+02_r8/)
      kbo(:, 2,52,16) = (/ &
     &3.5104e+05_r8,2.6328e+05_r8,1.7552e+05_r8,8.7761e+04_r8,1.9693e+02_r8/)
      kbo(:, 3,52,16) = (/ &
     &4.7523e+05_r8,3.5643e+05_r8,2.3762e+05_r8,1.1881e+05_r8,1.7968e+02_r8/)
      kbo(:, 4,52,16) = (/ &
     &6.1247e+05_r8,4.5936e+05_r8,3.0624e+05_r8,1.5312e+05_r8,1.6481e+02_r8/)
      kbo(:, 5,52,16) = (/ &
     &7.5898e+05_r8,5.6924e+05_r8,3.7949e+05_r8,1.8975e+05_r8,1.5192e+02_r8/)
      kbo(:, 1,53,16) = (/ &
     &2.6284e+05_r8,1.9713e+05_r8,1.3142e+05_r8,6.5712e+04_r8,2.2625e+02_r8/)
      kbo(:, 2,53,16) = (/ &
     &3.8810e+05_r8,2.9108e+05_r8,1.9405e+05_r8,9.7027e+04_r8,2.0424e+02_r8/)
      kbo(:, 3,53,16) = (/ &
     &5.3641e+05_r8,4.0231e+05_r8,2.6821e+05_r8,1.3410e+05_r8,1.8589e+02_r8/)
      kbo(:, 4,53,16) = (/ &
     &7.0283e+05_r8,5.2713e+05_r8,3.5142e+05_r8,1.7571e+05_r8,1.7018e+02_r8/)
      kbo(:, 5,53,16) = (/ &
     &8.8260e+05_r8,6.6195e+05_r8,4.4130e+05_r8,2.2065e+05_r8,1.5658e+02_r8/)
      kbo(:, 1,54,16) = (/ &
     &2.4532e+05_r8,1.8399e+05_r8,1.2266e+05_r8,6.1332e+04_r8,2.3489e+02_r8/)
      kbo(:, 2,54,16) = (/ &
     &3.7212e+05_r8,2.7909e+05_r8,1.8606e+05_r8,9.3031e+04_r8,2.1139e+02_r8/)
      kbo(:, 3,54,16) = (/ &
     &5.1860e+05_r8,3.9351e+05_r8,2.6234e+05_r8,1.3117e+05_r8,1.9188e+02_r8/)
      kbo(:, 4,54,16) = (/ &
     &6.9903e+05_r8,5.2427e+05_r8,3.4952e+05_r8,1.7476e+05_r8,1.7536e+02_r8/)
      kbo(:, 5,54,16) = (/ &
     &8.8946e+05_r8,6.6416e+05_r8,4.4474e+05_r8,2.2237e+05_r8,1.6106e+02_r8/)
      kbo(:, 1,55,16) = (/ &
     &2.0815e+05_r8,1.5612e+05_r8,1.0408e+05_r8,5.2039e+04_r8,2.4370e+02_r8/)
      kbo(:, 2,55,16) = (/ &
     &3.2440e+05_r8,2.4330e+05_r8,1.6220e+05_r8,8.1100e+04_r8,2.1865e+02_r8/)
      kbo(:, 3,55,16) = (/ &
     &4.6741e+05_r8,3.5056e+05_r8,2.3371e+05_r8,1.1685e+05_r8,1.9795e+02_r8/)
      kbo(:, 4,55,16) = (/ &
     &6.3338e+05_r8,4.7504e+05_r8,3.1669e+05_r8,1.5835e+05_r8,1.8053e+02_r8/)
      kbo(:, 5,55,16) = (/ &
     &8.1696e+05_r8,6.1272e+05_r8,4.0848e+05_r8,2.0424e+05_r8,1.6554e+02_r8/)
      kbo(:, 1,56,16) = (/ &
     &1.7485e+05_r8,1.3114e+05_r8,8.7424e+04_r8,4.3712e+04_r8,2.5296e+02_r8/)
      kbo(:, 2,56,16) = (/ &
     &2.8084e+05_r8,2.1063e+05_r8,1.4042e+05_r8,7.0208e+04_r8,2.2634e+02_r8/)
      kbo(:, 3,56,16) = (/ &
     &4.1394e+05_r8,3.1046e+05_r8,2.0697e+05_r8,1.0347e+05_r8,2.0431e+02_r8/)
      kbo(:, 4,56,16) = (/ &
     &5.7118e+05_r8,4.2838e+05_r8,2.8559e+05_r8,1.4279e+05_r8,1.8592e+02_r8/)
      kbo(:, 5,56,16) = (/ &
     &7.4759e+05_r8,5.6069e+05_r8,3.7379e+05_r8,1.8690e+05_r8,1.7020e+02_r8/)
      kbo(:, 1,57,16) = (/ &
     &1.4522e+05_r8,1.0891e+05_r8,7.2607e+04_r8,3.6303e+04_r8,2.6280e+02_r8/)
      kbo(:, 2,57,16) = (/ &
     &2.4098e+05_r8,1.8073e+05_r8,1.2049e+05_r8,6.0242e+04_r8,2.3450e+02_r8/)
      kbo(:, 3,57,16) = (/ &
     &3.6414e+05_r8,2.7311e+05_r8,1.8207e+05_r8,9.1034e+04_r8,2.1103e+02_r8/)
      kbo(:, 4,57,16) = (/ &
     &5.1231e+05_r8,3.8423e+05_r8,2.5615e+05_r8,1.2807e+05_r8,1.9160e+02_r8/)
      kbo(:, 5,57,16) = (/ &
     &6.8106e+05_r8,5.1079e+05_r8,3.4053e+05_r8,1.7026e+05_r8,1.7509e+02_r8/)
      kbo(:, 1,58,16) = (/ &
     &3.1730e+04_r8,2.9092e+04_r8,2.4944e+04_r8,1.7470e+04_r8,2.7269e+02_r8/)
      kbo(:, 2,58,16) = (/ &
     &5.4453e+04_r8,4.9925e+04_r8,4.2806e+04_r8,2.9981e+04_r8,2.4268e+02_r8/)
      kbo(:, 3,58,16) = (/ &
     &8.4447e+04_r8,7.7425e+04_r8,6.6385e+04_r8,4.6495e+04_r8,2.1781e+02_r8/)
      kbo(:, 4,58,16) = (/ &
     &1.2116e+05_r8,1.1108e+05_r8,9.5242e+04_r8,6.6707e+04_r8,1.9723e+02_r8/)
      kbo(:, 5,58,16) = (/ &
     &1.6365e+05_r8,1.5004e+05_r8,1.2865e+05_r8,9.0103e+04_r8,1.7991e+02_r8/)
      kbo(:, 1,59,16) = (/ &
     &3.4421e+04_r8,3.0055e+04_r8,2.3973e+04_r8,1.4918e+04_r8,2.7694e+02_r8/)
      kbo(:, 2,59,16) = (/ &
     &5.9930e+04_r8,5.2328e+04_r8,4.1740e+04_r8,2.5973e+04_r8,2.4614e+02_r8/)
      kbo(:, 3,59,16) = (/ &
     &9.3934e+04_r8,8.2019e+04_r8,6.5423e+04_r8,4.0711e+04_r8,2.2066e+02_r8/)
      kbo(:, 4,59,16) = (/ &
     &1.3595e+05_r8,1.1871e+05_r8,9.4687e+04_r8,5.8920e+04_r8,1.9962e+02_r8/)
      kbo(:, 5,59,16) = (/ &
     &1.8479e+05_r8,1.6135e+05_r8,1.2650e+05_r8,8.0089e+04_r8,1.8195e+02_r8/)

!     The array KAO_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level below 100~ mb.   The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amount ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 
!     to that of gas2.  The second index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The third index 
!     runs over the g-channel (1 to 16).

      kao_mo3( 1, :, 1) = (/ &
     & 9.31040e-03_r8, 1.01286e-02_r8, 1.10186e-02_r8, 1.19869e-02_r8, 1.30403e-02_r8, &
     & 1.41862e-02_r8, 1.54328e-02_r8, 1.67890e-02_r8, 1.82644e-02_r8, 1.98694e-02_r8, &
     & 2.16154e-02_r8, 2.35149e-02_r8, 2.55813e-02_r8, 2.78293e-02_r8, 3.02749e-02_r8, &
     & 3.29353e-02_r8, 3.58295e-02_r8, 3.89781e-02_r8, 4.24034e-02_r8/)
      kao_mo3( 2, :, 1) = (/ &
     & 1.11200e-02_r8, 1.20461e-02_r8, 1.30493e-02_r8, 1.41360e-02_r8, 1.53133e-02_r8, &
     & 1.65886e-02_r8, 1.79701e-02_r8, 1.94666e-02_r8, 2.10878e-02_r8, 2.28440e-02_r8, &
     & 2.47465e-02_r8, 2.68074e-02_r8, 2.90399e-02_r8, 3.14583e-02_r8, 3.40782e-02_r8, &
     & 3.69162e-02_r8, 3.99907e-02_r8, 4.33211e-02_r8, 4.69289e-02_r8/)
      kao_mo3( 3, :, 1) = (/ &
     & 1.21630e-02_r8, 1.31401e-02_r8, 1.41956e-02_r8, 1.53359e-02_r8, 1.65679e-02_r8, &
     & 1.78988e-02_r8, 1.93366e-02_r8, 2.08899e-02_r8, 2.25680e-02_r8, 2.43808e-02_r8, &
     & 2.63394e-02_r8, 2.84552e-02_r8, 3.07410e-02_r8, 3.32104e-02_r8, 3.58782e-02_r8, &
     & 3.87603e-02_r8, 4.18739e-02_r8, 4.52377e-02_r8, 4.88716e-02_r8/)
      kao_mo3( 4, :, 1) = (/ &
     & 1.26231e-02_r8, 1.36243e-02_r8, 1.47049e-02_r8, 1.58713e-02_r8, 1.71301e-02_r8, &
     & 1.84888e-02_r8, 1.99553e-02_r8, 2.15380e-02_r8, 2.32463e-02_r8, 2.50901e-02_r8, &
     & 2.70801e-02_r8, 2.92280e-02_r8, 3.15463e-02_r8, 3.40484e-02_r8, 3.67489e-02_r8, &
     & 3.96637e-02_r8, 4.28097e-02_r8, 4.62051e-02_r8, 4.98699e-02_r8/)
      kao_mo3( 5, :, 1) = (/ &
     & 1.33345e-02_r8, 1.43736e-02_r8, 1.54938e-02_r8, 1.67012e-02_r8, 1.80027e-02_r8, &
     & 1.94057e-02_r8, 2.09180e-02_r8, 2.25481e-02_r8, 2.43053e-02_r8, 2.61994e-02_r8, &
     & 2.82411e-02_r8, 3.04419e-02_r8, 3.28142e-02_r8, 3.53714e-02_r8, 3.81279e-02_r8, &
     & 4.10992e-02_r8, 4.43021e-02_r8, 4.77545e-02_r8, 5.14760e-02_r8/)
      kao_mo3( 6, :, 1) = (/ &
     & 1.43294e-02_r8, 1.54133e-02_r8, 1.65791e-02_r8, 1.78331e-02_r8, 1.91819e-02_r8, &
     & 2.06328e-02_r8, 2.21935e-02_r8, 2.38721e-02_r8, 2.56778e-02_r8, 2.76200e-02_r8, &
     & 2.97091e-02_r8, 3.19562e-02_r8, 3.43733e-02_r8, 3.69732e-02_r8, 3.97698e-02_r8, &
     & 4.27779e-02_r8, 4.60136e-02_r8, 4.94939e-02_r8, 5.32375e-02_r8/)
      kao_mo3( 7, :, 1) = (/ &
     & 1.48298e-02_r8, 1.59503e-02_r8, 1.71554e-02_r8, 1.84517e-02_r8, 1.98458e-02_r8, &
     & 2.13453e-02_r8, 2.29581e-02_r8, 2.46928e-02_r8, 2.65585e-02_r8, 2.85652e-02_r8, &
     & 3.07235e-02_r8, 3.30449e-02_r8, 3.55417e-02_r8, 3.82272e-02_r8, 4.11155e-02_r8, &
     & 4.42221e-02_r8, 4.75634e-02_r8, 5.11572e-02_r8, 5.50225e-02_r8/)
      kao_mo3( 8, :, 1) = (/ &
     & 1.41792e-02_r8, 1.53141e-02_r8, 1.65398e-02_r8, 1.78637e-02_r8, 1.92935e-02_r8, &
     & 2.08378e-02_r8, 2.25057e-02_r8, 2.43071e-02_r8, 2.62526e-02_r8, 2.83539e-02_r8, &
     & 3.06234e-02_r8, 3.30745e-02_r8, 3.57218e-02_r8, 3.85810e-02_r8, 4.16690e-02_r8, &
     & 4.50042e-02_r8, 4.86064e-02_r8, 5.24969e-02_r8, 5.66988e-02_r8/)
      kao_mo3( 9, :, 1) = (/ &
     & 8.82784e-03_r8, 9.48321e-03_r8, 1.01872e-02_r8, 1.09435e-02_r8, 1.17560e-02_r8, &
     & 1.26287e-02_r8, 1.35662e-02_r8, 1.45734e-02_r8, 1.56553e-02_r8, 1.68175e-02_r8, &
     & 1.80660e-02_r8, 1.94072e-02_r8, 2.08480e-02_r8, 2.23958e-02_r8, 2.40584e-02_r8, &
     & 2.58445e-02_r8, 2.77631e-02_r8, 2.98242e-02_r8, 3.20383e-02_r8/)
      kao_mo3( 1, :, 2) = (/ &
     & 4.28238e-02_r8, 4.51015e-02_r8, 4.75003e-02_r8, 5.00266e-02_r8, 5.26873e-02_r8, &
     & 5.54896e-02_r8, 5.84409e-02_r8, 6.15491e-02_r8, 6.48227e-02_r8, 6.82704e-02_r8, &
     & 7.19014e-02_r8, 7.57256e-02_r8, 7.97532e-02_r8, 8.39949e-02_r8, 8.84623e-02_r8, &
     & 9.31673e-02_r8, 9.81225e-02_r8, 1.03341e-01_r8, 1.08838e-01_r8/)
      kao_mo3( 2, :, 2) = (/ &
     & 4.83672e-02_r8, 5.07219e-02_r8, 5.31911e-02_r8, 5.57806e-02_r8, 5.84962e-02_r8, &
     & 6.13440e-02_r8, 6.43303e-02_r8, 6.74621e-02_r8, 7.07464e-02_r8, 7.41905e-02_r8, &
     & 7.78023e-02_r8, 8.15899e-02_r8, 8.55619e-02_r8, 8.97273e-02_r8, 9.40955e-02_r8, &
     & 9.86763e-02_r8, 1.03480e-01_r8, 1.08518e-01_r8, 1.13801e-01_r8/)
      kao_mo3( 3, :, 2) = (/ &
     & 5.24315e-02_r8, 5.48650e-02_r8, 5.74115e-02_r8, 6.00762e-02_r8, 6.28645e-02_r8, &
     & 6.57822e-02_r8, 6.88354e-02_r8, 7.20302e-02_r8, 7.53734e-02_r8, 7.88717e-02_r8, &
     & 8.25324e-02_r8, 8.63630e-02_r8, 9.03714e-02_r8, 9.45658e-02_r8, 9.89549e-02_r8, &
     & 1.03548e-01_r8, 1.08354e-01_r8, 1.13383e-01_r8, 1.18645e-01_r8/)
      kao_mo3( 4, :, 2) = (/ &
     & 5.65191e-02_r8, 5.90383e-02_r8, 6.16699e-02_r8, 6.44187e-02_r8, 6.72901e-02_r8, &
     & 7.02894e-02_r8, 7.34224e-02_r8, 7.66951e-02_r8, 8.01137e-02_r8, 8.36846e-02_r8, &
     & 8.74147e-02_r8, 9.13111e-02_r8, 9.53812e-02_r8, 9.96326e-02_r8, 1.04074e-01_r8, &
     & 1.08712e-01_r8, 1.13558e-01_r8, 1.18620e-01_r8, 1.23907e-01_r8/)
      kao_mo3( 5, :, 2) = (/ &
     & 6.03171e-02_r8, 6.29114e-02_r8, 6.56172e-02_r8, 6.84394e-02_r8, 7.13830e-02_r8, &
     & 7.44532e-02_r8, 7.76555e-02_r8, 8.09955e-02_r8, 8.44791e-02_r8, 8.81125e-02_r8, &
     & 9.19023e-02_r8, 9.58550e-02_r8, 9.99778e-02_r8, 1.04278e-01_r8, 1.08763e-01_r8, &
     & 1.13441e-01_r8, 1.18320e-01_r8, 1.23409e-01_r8, 1.28717e-01_r8/)
      kao_mo3( 6, :, 2) = (/ &
     & 6.51092e-02_r8, 6.77827e-02_r8, 7.05660e-02_r8, 7.34635e-02_r8, 7.64801e-02_r8, &
     & 7.96204e-02_r8, 8.28898e-02_r8, 8.62934e-02_r8, 8.98367e-02_r8, 9.35255e-02_r8, &
     & 9.73658e-02_r8, 1.01364e-01_r8, 1.05526e-01_r8, 1.09859e-01_r8, 1.14370e-01_r8, &
     & 1.19066e-01_r8, 1.23955e-01_r8, 1.29045e-01_r8, 1.34344e-01_r8/)
      kao_mo3( 7, :, 2) = (/ &
     & 7.09653e-02_r8, 7.37378e-02_r8, 7.66187e-02_r8, 7.96121e-02_r8, 8.27225e-02_r8, &
     & 8.59543e-02_r8, 8.93125e-02_r8, 9.28018e-02_r8, 9.64275e-02_r8, 1.00195e-01_r8, &
     & 1.04109e-01_r8, 1.08177e-01_r8, 1.12403e-01_r8, 1.16795e-01_r8, 1.21358e-01_r8, &
     & 1.26099e-01_r8, 1.31026e-01_r8, 1.36145e-01_r8, 1.41464e-01_r8/)
      kao_mo3( 8, :, 2) = (/ &
     & 7.69193e-02_r8, 7.97926e-02_r8, 8.27733e-02_r8, 8.58653e-02_r8, 8.90728e-02_r8, &
     & 9.24002e-02_r8, 9.58518e-02_r8, 9.94324e-02_r8, 1.03147e-01_r8, 1.07000e-01_r8, &
     & 1.10997e-01_r8, 1.15143e-01_r8, 1.19444e-01_r8, 1.23906e-01_r8, 1.28535e-01_r8, &
     & 1.33336e-01_r8, 1.38317e-01_r8, 1.43484e-01_r8, 1.48844e-01_r8/)
      kao_mo3( 9, :, 2) = (/ &
     & 4.57962e-02_r8, 4.76027e-02_r8, 4.94805e-02_r8, 5.14323e-02_r8, 5.34611e-02_r8, &
     & 5.55700e-02_r8, 5.77620e-02_r8, 6.00405e-02_r8, 6.24089e-02_r8, 6.48707e-02_r8, &
     & 6.74296e-02_r8, 7.00895e-02_r8, 7.28542e-02_r8, 7.57281e-02_r8, 7.87153e-02_r8, &
     & 8.18203e-02_r8, 8.50478e-02_r8, 8.84027e-02_r8, 9.18898e-02_r8/)
      kao_mo3( 1, :, 3) = (/ &
     & 1.12607e-01_r8, 1.16047e-01_r8, 1.19591e-01_r8, 1.23244e-01_r8, 1.27009e-01_r8, &
     & 1.30888e-01_r8, 1.34886e-01_r8, 1.39006e-01_r8, 1.43252e-01_r8, 1.47628e-01_r8, &
     & 1.52137e-01_r8, 1.56785e-01_r8, 1.61574e-01_r8, 1.66509e-01_r8, 1.71595e-01_r8, &
     & 1.76836e-01_r8, 1.82238e-01_r8, 1.87804e-01_r8, 1.93541e-01_r8/)
      kao_mo3( 2, :, 3) = (/ &
     & 1.14531e-01_r8, 1.17850e-01_r8, 1.21266e-01_r8, 1.24781e-01_r8, 1.28397e-01_r8, &
     & 1.32119e-01_r8, 1.35948e-01_r8, 1.39888e-01_r8, 1.43943e-01_r8, 1.48115e-01_r8, &
     & 1.52407e-01_r8, 1.56825e-01_r8, 1.61370e-01_r8, 1.66047e-01_r8, 1.70860e-01_r8, &
     & 1.75812e-01_r8, 1.80907e-01_r8, 1.86150e-01_r8, 1.91546e-01_r8/)
      kao_mo3( 3, :, 3) = (/ &
     & 1.13986e-01_r8, 1.17222e-01_r8, 1.20551e-01_r8, 1.23974e-01_r8, 1.27494e-01_r8, &
     & 1.31114e-01_r8, 1.34837e-01_r8, 1.38666e-01_r8, 1.42604e-01_r8, 1.46653e-01_r8, &
     & 1.50817e-01_r8, 1.55099e-01_r8, 1.59503e-01_r8, 1.64032e-01_r8, 1.68690e-01_r8, &
     & 1.73480e-01_r8, 1.78406e-01_r8, 1.83472e-01_r8, 1.88682e-01_r8/)
      kao_mo3( 4, :, 3) = (/ &
     & 1.13713e-01_r8, 1.16892e-01_r8, 1.20160e-01_r8, 1.23519e-01_r8, 1.26972e-01_r8, &
     & 1.30522e-01_r8, 1.34171e-01_r8, 1.37922e-01_r8, 1.41778e-01_r8, 1.45742e-01_r8, &
     & 1.49817e-01_r8, 1.54005e-01_r8, 1.58311e-01_r8, 1.62737e-01_r8, 1.67287e-01_r8, &
     & 1.71964e-01_r8, 1.76771e-01_r8, 1.81714e-01_r8, 1.86794e-01_r8/)
      kao_mo3( 5, :, 3) = (/ &
     & 1.12321e-01_r8, 1.15413e-01_r8, 1.18591e-01_r8, 1.21856e-01_r8, 1.25211e-01_r8, &
     & 1.28658e-01_r8, 1.32200e-01_r8, 1.35840e-01_r8, 1.39580e-01_r8, 1.43423e-01_r8, &
     & 1.47372e-01_r8, 1.51429e-01_r8, 1.55599e-01_r8, 1.59883e-01_r8, 1.64284e-01_r8, &
     & 1.68808e-01_r8, 1.73455e-01_r8, 1.78231e-01_r8, 1.83138e-01_r8/)
      kao_mo3( 6, :, 3) = (/ &
     & 1.14158e-01_r8, 1.17218e-01_r8, 1.20360e-01_r8, 1.23586e-01_r8, 1.26899e-01_r8, &
     & 1.30300e-01_r8, 1.33793e-01_r8, 1.37379e-01_r8, 1.41061e-01_r8, 1.44842e-01_r8, &
     & 1.48724e-01_r8, 1.52711e-01_r8, 1.56804e-01_r8, 1.61007e-01_r8, 1.65322e-01_r8, &
     & 1.69754e-01_r8, 1.74304e-01_r8, 1.78976e-01_r8, 1.83773e-01_r8/)
      kao_mo3( 7, :, 3) = (/ &
     & 1.21015e-01_r8, 1.23989e-01_r8, 1.27036e-01_r8, 1.30157e-01_r8, 1.33355e-01_r8, &
     & 1.36632e-01_r8, 1.39990e-01_r8, 1.43429e-01_r8, 1.46954e-01_r8, 1.50565e-01_r8, &
     & 1.54264e-01_r8, 1.58055e-01_r8, 1.61939e-01_r8, 1.65918e-01_r8, 1.69995e-01_r8, &
     & 1.74172e-01_r8, 1.78452e-01_r8, 1.82836e-01_r8, 1.87329e-01_r8/)
      kao_mo3( 8, :, 3) = (/ &
     & 1.33952e-01_r8, 1.36939e-01_r8, 1.39992e-01_r8, 1.43114e-01_r8, 1.46305e-01_r8, &
     & 1.49567e-01_r8, 1.52902e-01_r8, 1.56311e-01_r8, 1.59797e-01_r8, 1.63360e-01_r8, &
     & 1.67002e-01_r8, 1.70726e-01_r8, 1.74533e-01_r8, 1.78424e-01_r8, 1.82403e-01_r8, &
     & 1.86470e-01_r8, 1.90627e-01_r8, 1.94878e-01_r8, 1.99223e-01_r8/)
      kao_mo3( 9, :, 3) = (/ &
     & 1.01003e-01_r8, 1.03713e-01_r8, 1.06495e-01_r8, 1.09352e-01_r8, 1.12285e-01_r8, &
     & 1.15297e-01_r8, 1.18390e-01_r8, 1.21566e-01_r8, 1.24827e-01_r8, 1.28176e-01_r8, &
     & 1.31614e-01_r8, 1.35145e-01_r8, 1.38770e-01_r8, 1.42493e-01_r8, 1.46315e-01_r8, &
     & 1.50240e-01_r8, 1.54271e-01_r8, 1.58409e-01_r8, 1.62659e-01_r8/)
      kao_mo3( 1, :, 4) = (/ &
     & 2.35597e-01_r8, 2.37975e-01_r8, 2.40376e-01_r8, 2.42802e-01_r8, 2.45253e-01_r8, &
     & 2.47728e-01_r8, 2.50228e-01_r8, 2.52753e-01_r8, 2.55304e-01_r8, 2.57881e-01_r8, &
     & 2.60483e-01_r8, 2.63112e-01_r8, 2.65767e-01_r8, 2.68450e-01_r8, 2.71159e-01_r8, &
     & 2.73895e-01_r8, 2.76660e-01_r8, 2.79452e-01_r8, 2.82272e-01_r8/)
      kao_mo3( 2, :, 4) = (/ &
     & 2.27965e-01_r8, 2.30334e-01_r8, 2.32728e-01_r8, 2.35146e-01_r8, 2.37590e-01_r8, &
     & 2.40059e-01_r8, 2.42554e-01_r8, 2.45075e-01_r8, 2.47621e-01_r8, 2.50195e-01_r8, &
     & 2.52795e-01_r8, 2.55422e-01_r8, 2.58077e-01_r8, 2.60759e-01_r8, 2.63468e-01_r8, &
     & 2.66206e-01_r8, 2.68973e-01_r8, 2.71768e-01_r8, 2.74593e-01_r8/)
      kao_mo3( 3, :, 4) = (/ &
     & 2.25956e-01_r8, 2.28277e-01_r8, 2.30622e-01_r8, 2.32991e-01_r8, 2.35384e-01_r8, &
     & 2.37802e-01_r8, 2.40244e-01_r8, 2.42712e-01_r8, 2.45205e-01_r8, 2.47724e-01_r8, &
     & 2.50268e-01_r8, 2.52839e-01_r8, 2.55436e-01_r8, 2.58060e-01_r8, 2.60711e-01_r8, &
     & 2.63389e-01_r8, 2.66094e-01_r8, 2.68827e-01_r8, 2.71589e-01_r8/)
      kao_mo3( 4, :, 4) = (/ &
     & 2.28371e-01_r8, 2.30595e-01_r8, 2.32840e-01_r8, 2.35107e-01_r8, 2.37397e-01_r8, &
     & 2.39708e-01_r8, 2.42042e-01_r8, 2.44399e-01_r8, 2.46779e-01_r8, 2.49182e-01_r8, &
     & 2.51608e-01_r8, 2.54058e-01_r8, 2.56532e-01_r8, 2.59030e-01_r8, 2.61552e-01_r8, &
     & 2.64099e-01_r8, 2.66671e-01_r8, 2.69267e-01_r8, 2.71889e-01_r8/)
      kao_mo3( 5, :, 4) = (/ &
     & 2.42563e-01_r8, 2.44620e-01_r8, 2.46695e-01_r8, 2.48787e-01_r8, 2.50897e-01_r8, &
     & 2.53024e-01_r8, 2.55170e-01_r8, 2.57334e-01_r8, 2.59516e-01_r8, 2.61717e-01_r8, &
     & 2.63936e-01_r8, 2.66174e-01_r8, 2.68431e-01_r8, 2.70708e-01_r8, 2.73003e-01_r8, &
     & 2.75318e-01_r8, 2.77653e-01_r8, 2.80008e-01_r8, 2.82382e-01_r8/)
      kao_mo3( 6, :, 4) = (/ &
     & 2.54052e-01_r8, 2.56017e-01_r8, 2.57997e-01_r8, 2.59992e-01_r8, 2.62003e-01_r8, &
     & 2.64029e-01_r8, 2.66071e-01_r8, 2.68129e-01_r8, 2.70203e-01_r8, 2.72293e-01_r8, &
     & 2.74398e-01_r8, 2.76521e-01_r8, 2.78659e-01_r8, 2.80814e-01_r8, 2.82986e-01_r8, &
     & 2.85175e-01_r8, 2.87380e-01_r8, 2.89603e-01_r8, 2.91842e-01_r8/)
      kao_mo3( 7, :, 4) = (/ &
     & 2.54061e-01_r8, 2.55982e-01_r8, 2.57917e-01_r8, 2.59867e-01_r8, 2.61832e-01_r8, &
     & 2.63811e-01_r8, 2.65806e-01_r8, 2.67815e-01_r8, 2.69840e-01_r8, 2.71880e-01_r8, &
     & 2.73936e-01_r8, 2.76007e-01_r8, 2.78093e-01_r8, 2.80196e-01_r8, 2.82314e-01_r8, &
     & 2.84449e-01_r8, 2.86599e-01_r8, 2.88766e-01_r8, 2.90949e-01_r8/)
      kao_mo3( 8, :, 4) = (/ &
     & 2.72482e-01_r8, 2.73916e-01_r8, 2.75358e-01_r8, 2.76807e-01_r8, 2.78264e-01_r8, &
     & 2.79729e-01_r8, 2.81201e-01_r8, 2.82681e-01_r8, 2.84169e-01_r8, 2.85665e-01_r8, &
     & 2.87168e-01_r8, 2.88680e-01_r8, 2.90199e-01_r8, 2.91726e-01_r8, 2.93262e-01_r8, &
     & 2.94805e-01_r8, 2.96357e-01_r8, 2.97917e-01_r8, 2.99485e-01_r8/)
      kao_mo3( 9, :, 4) = (/ &
     & 1.93414e-01_r8, 1.95498e-01_r8, 1.97605e-01_r8, 1.99734e-01_r8, 2.01886e-01_r8, &
     & 2.04062e-01_r8, 2.06261e-01_r8, 2.08483e-01_r8, 2.10730e-01_r8, 2.13001e-01_r8, &
     & 2.15296e-01_r8, 2.17616e-01_r8, 2.19961e-01_r8, 2.22331e-01_r8, 2.24727e-01_r8, &
     & 2.27148e-01_r8, 2.29596e-01_r8, 2.32070e-01_r8, 2.34571e-01_r8/)
      kao_mo3( 1, :, 5) = (/ &
     & 5.30785e-01_r8, 5.30477e-01_r8, 5.30169e-01_r8, 5.29861e-01_r8, 5.29553e-01_r8, &
     & 5.29246e-01_r8, 5.28938e-01_r8, 5.28631e-01_r8, 5.28324e-01_r8, 5.28017e-01_r8, &
     & 5.27711e-01_r8, 5.27404e-01_r8, 5.27098e-01_r8, 5.26792e-01_r8, 5.26486e-01_r8, &
     & 5.26180e-01_r8, 5.25875e-01_r8, 5.25569e-01_r8, 5.25264e-01_r8/)
      kao_mo3( 2, :, 5) = (/ &
     & 5.33406e-01_r8, 5.32997e-01_r8, 5.32587e-01_r8, 5.32178e-01_r8, 5.31769e-01_r8, &
     & 5.31360e-01_r8, 5.30952e-01_r8, 5.30544e-01_r8, 5.30137e-01_r8, 5.29729e-01_r8, &
     & 5.29322e-01_r8, 5.28916e-01_r8, 5.28509e-01_r8, 5.28103e-01_r8, 5.27697e-01_r8, &
     & 5.27292e-01_r8, 5.26887e-01_r8, 5.26482e-01_r8, 5.26077e-01_r8/)
      kao_mo3( 3, :, 5) = (/ &
     & 5.39814e-01_r8, 5.39234e-01_r8, 5.38655e-01_r8, 5.38077e-01_r8, 5.37499e-01_r8, &
     & 5.36922e-01_r8, 5.36345e-01_r8, 5.35769e-01_r8, 5.35194e-01_r8, 5.34620e-01_r8, &
     & 5.34045e-01_r8, 5.33472e-01_r8, 5.32899e-01_r8, 5.32327e-01_r8, 5.31756e-01_r8, &
     & 5.31185e-01_r8, 5.30614e-01_r8, 5.30045e-01_r8, 5.29475e-01_r8/)
      kao_mo3( 4, :, 5) = (/ &
     & 5.39054e-01_r8, 5.38348e-01_r8, 5.37643e-01_r8, 5.36938e-01_r8, 5.36235e-01_r8, &
     & 5.35532e-01_r8, 5.34831e-01_r8, 5.34130e-01_r8, 5.33431e-01_r8, 5.32732e-01_r8, &
     & 5.32034e-01_r8, 5.31337e-01_r8, 5.30641e-01_r8, 5.29946e-01_r8, 5.29252e-01_r8, &
     & 5.28559e-01_r8, 5.27866e-01_r8, 5.27175e-01_r8, 5.26484e-01_r8/)
      kao_mo3( 5, :, 5) = (/ &
     & 5.29240e-01_r8, 5.28475e-01_r8, 5.27711e-01_r8, 5.26949e-01_r8, 5.26187e-01_r8, &
     & 5.25427e-01_r8, 5.24668e-01_r8, 5.23909e-01_r8, 5.23152e-01_r8, 5.22396e-01_r8, &
     & 5.21641e-01_r8, 5.20888e-01_r8, 5.20135e-01_r8, 5.19383e-01_r8, 5.18633e-01_r8, &
     & 5.17883e-01_r8, 5.17135e-01_r8, 5.16388e-01_r8, 5.15642e-01_r8/)
      kao_mo3( 6, :, 5) = (/ &
     & 5.21746e-01_r8, 5.20815e-01_r8, 5.19886e-01_r8, 5.18958e-01_r8, 5.18032e-01_r8, &
     & 5.17107e-01_r8, 5.16184e-01_r8, 5.15263e-01_r8, 5.14343e-01_r8, 5.13425e-01_r8, &
     & 5.12509e-01_r8, 5.11594e-01_r8, 5.10681e-01_r8, 5.09770e-01_r8, 5.08860e-01_r8, &
     & 5.07952e-01_r8, 5.07045e-01_r8, 5.06140e-01_r8, 5.05237e-01_r8/)
      kao_mo3( 7, :, 5) = (/ &
     & 5.26752e-01_r8, 5.25550e-01_r8, 5.24352e-01_r8, 5.23156e-01_r8, 5.21963e-01_r8, &
     & 5.20772e-01_r8, 5.19584e-01_r8, 5.18399e-01_r8, 5.17217e-01_r8, 5.16038e-01_r8, &
     & 5.14861e-01_r8, 5.13686e-01_r8, 5.12515e-01_r8, 5.11346e-01_r8, 5.10180e-01_r8, &
     & 5.09016e-01_r8, 5.07855e-01_r8, 5.06697e-01_r8, 5.05541e-01_r8/)
      kao_mo3( 8, :, 5) = (/ &
     & 5.23581e-01_r8, 5.22513e-01_r8, 5.21446e-01_r8, 5.20382e-01_r8, 5.19320e-01_r8, &
     & 5.18260e-01_r8, 5.17203e-01_r8, 5.16147e-01_r8, 5.15094e-01_r8, 5.14042e-01_r8, &
     & 5.12993e-01_r8, 5.11946e-01_r8, 5.10901e-01_r8, 5.09859e-01_r8, 5.08818e-01_r8, &
     & 5.07780e-01_r8, 5.06743e-01_r8, 5.05709e-01_r8, 5.04677e-01_r8/)
      kao_mo3( 9, :, 5) = (/ &
     & 3.80393e-01_r8, 3.80680e-01_r8, 3.80967e-01_r8, 3.81254e-01_r8, 3.81542e-01_r8, &
     & 3.81829e-01_r8, 3.82117e-01_r8, 3.82405e-01_r8, 3.82693e-01_r8, 3.82982e-01_r8, &
     & 3.83271e-01_r8, 3.83559e-01_r8, 3.83849e-01_r8, 3.84138e-01_r8, 3.84428e-01_r8, &
     & 3.84717e-01_r8, 3.85007e-01_r8, 3.85298e-01_r8, 3.85588e-01_r8/)
      kao_mo3( 1, :, 6) = (/ &
     & 6.14818e-01_r8, 6.10664e-01_r8, 6.06539e-01_r8, 6.02441e-01_r8, 5.98372e-01_r8, &
     & 5.94330e-01_r8, 5.90315e-01_r8, 5.86327e-01_r8, 5.82366e-01_r8, 5.78432e-01_r8, &
     & 5.74524e-01_r8, 5.70643e-01_r8, 5.66788e-01_r8, 5.62959e-01_r8, 5.59156e-01_r8, &
     & 5.55379e-01_r8, 5.51627e-01_r8, 5.47901e-01_r8, 5.44199e-01_r8/)
      kao_mo3( 2, :, 6) = (/ &
     & 6.10199e-01_r8, 6.06143e-01_r8, 6.02114e-01_r8, 5.98112e-01_r8, 5.94136e-01_r8, &
     & 5.90187e-01_r8, 5.86264e-01_r8, 5.82367e-01_r8, 5.78496e-01_r8, 5.74651e-01_r8, &
     & 5.70831e-01_r8, 5.67037e-01_r8, 5.63268e-01_r8, 5.59524e-01_r8, 5.55805e-01_r8, &
     & 5.52110e-01_r8, 5.48440e-01_r8, 5.44795e-01_r8, 5.41174e-01_r8/)
      kao_mo3( 3, :, 6) = (/ &
     & 6.02949e-01_r8, 5.99057e-01_r8, 5.95190e-01_r8, 5.91348e-01_r8, 5.87531e-01_r8, &
     & 5.83739e-01_r8, 5.79971e-01_r8, 5.76227e-01_r8, 5.72508e-01_r8, 5.68812e-01_r8, &
     & 5.65140e-01_r8, 5.61493e-01_r8, 5.57868e-01_r8, 5.54267e-01_r8, 5.50690e-01_r8, &
     & 5.47135e-01_r8, 5.43603e-01_r8, 5.40094e-01_r8, 5.36608e-01_r8/)
      kao_mo3( 4, :, 6) = (/ &
     & 6.05047e-01_r8, 6.01155e-01_r8, 5.97289e-01_r8, 5.93448e-01_r8, 5.89631e-01_r8, &
     & 5.85838e-01_r8, 5.82071e-01_r8, 5.78327e-01_r8, 5.74607e-01_r8, 5.70912e-01_r8, &
     & 5.67240e-01_r8, 5.63592e-01_r8, 5.59967e-01_r8, 5.56365e-01_r8, 5.52787e-01_r8, &
     & 5.49232e-01_r8, 5.45699e-01_r8, 5.42190e-01_r8, 5.38703e-01_r8/)
      kao_mo3( 5, :, 6) = (/ &
     & 6.03593e-01_r8, 5.99867e-01_r8, 5.96164e-01_r8, 5.92483e-01_r8, 5.88825e-01_r8, &
     & 5.85190e-01_r8, 5.81577e-01_r8, 5.77987e-01_r8, 5.74419e-01_r8, 5.70872e-01_r8, &
     & 5.67348e-01_r8, 5.63846e-01_r8, 5.60365e-01_r8, 5.56905e-01_r8, 5.53467e-01_r8, &
     & 5.50050e-01_r8, 5.46654e-01_r8, 5.43279e-01_r8, 5.39926e-01_r8/)
      kao_mo3( 6, :, 6) = (/ &
     & 6.03940e-01_r8, 6.00224e-01_r8, 5.96531e-01_r8, 5.92861e-01_r8, 5.89213e-01_r8, &
     & 5.85588e-01_r8, 5.81985e-01_r8, 5.78404e-01_r8, 5.74845e-01_r8, 5.71308e-01_r8, &
     & 5.67793e-01_r8, 5.64299e-01_r8, 5.60827e-01_r8, 5.57377e-01_r8, 5.53947e-01_r8, &
     & 5.50539e-01_r8, 5.47151e-01_r8, 5.43785e-01_r8, 5.40439e-01_r8/)
      kao_mo3( 7, :, 6) = (/ &
     & 6.06242e-01_r8, 6.02257e-01_r8, 5.98299e-01_r8, 5.94367e-01_r8, 5.90461e-01_r8, &
     & 5.86580e-01_r8, 5.82725e-01_r8, 5.78895e-01_r8, 5.75090e-01_r8, 5.71311e-01_r8, &
     & 5.67556e-01_r8, 5.63826e-01_r8, 5.60120e-01_r8, 5.56439e-01_r8, 5.52782e-01_r8, &
     & 5.49149e-01_r8, 5.45540e-01_r8, 5.41954e-01_r8, 5.38393e-01_r8/)
      kao_mo3( 8, :, 6) = (/ &
     & 6.11929e-01_r8, 6.07173e-01_r8, 6.02454e-01_r8, 5.97773e-01_r8, 5.93127e-01_r8, &
     & 5.88518e-01_r8, 5.83944e-01_r8, 5.79406e-01_r8, 5.74903e-01_r8, 5.70436e-01_r8, &
     & 5.66002e-01_r8, 5.61604e-01_r8, 5.57239e-01_r8, 5.52909e-01_r8, 5.48612e-01_r8, &
     & 5.44349e-01_r8, 5.40118e-01_r8, 5.35921e-01_r8, 5.31756e-01_r8/)
      kao_mo3( 9, :, 6) = (/ &
     & 6.21189e-01_r8, 6.17338e-01_r8, 6.13511e-01_r8, 6.09707e-01_r8, 6.05927e-01_r8, &
     & 6.02170e-01_r8, 5.98437e-01_r8, 5.94726e-01_r8, 5.91039e-01_r8, 5.87375e-01_r8, &
     & 5.83733e-01_r8, 5.80114e-01_r8, 5.76517e-01_r8, 5.72943e-01_r8, 5.69390e-01_r8, &
     & 5.65860e-01_r8, 5.62352e-01_r8, 5.58865e-01_r8, 5.55400e-01_r8/)
      kao_mo3( 1, :, 7) = (/ &
     & 7.41310e-01_r8, 7.30108e-01_r8, 7.19075e-01_r8, 7.08209e-01_r8, 6.97507e-01_r8, &
     & 6.86967e-01_r8, 6.76586e-01_r8, 6.66362e-01_r8, 6.56292e-01_r8, 6.46374e-01_r8, &
     & 6.36607e-01_r8, 6.26987e-01_r8, 6.17512e-01_r8, 6.08181e-01_r8, 5.98990e-01_r8, &
     & 5.89939e-01_r8, 5.81024e-01_r8, 5.72244e-01_r8, 5.63597e-01_r8/)
      kao_mo3( 2, :, 7) = (/ &
     & 7.38780e-01_r8, 7.27631e-01_r8, 7.16651e-01_r8, 7.05836e-01_r8, 6.95185e-01_r8, &
     & 6.84695e-01_r8, 6.74362e-01_r8, 6.64186e-01_r8, 6.54163e-01_r8, 6.44292e-01_r8, &
     & 6.34569e-01_r8, 6.24993e-01_r8, 6.15562e-01_r8, 6.06273e-01_r8, 5.97124e-01_r8, &
     & 5.88113e-01_r8, 5.79238e-01_r8, 5.70498e-01_r8, 5.61889e-01_r8/)
      kao_mo3( 3, :, 7) = (/ &
     & 7.33846e-01_r8, 7.22799e-01_r8, 7.11919e-01_r8, 7.01203e-01_r8, 6.90648e-01_r8, &
     & 6.80252e-01_r8, 6.70012e-01_r8, 6.59927e-01_r8, 6.49993e-01_r8, 6.40209e-01_r8, &
     & 6.30572e-01_r8, 6.21080e-01_r8, 6.11731e-01_r8, 6.02523e-01_r8, 5.93453e-01_r8, &
     & 5.84520e-01_r8, 5.75721e-01_r8, 5.67055e-01_r8, 5.58519e-01_r8/)
      kao_mo3( 4, :, 7) = (/ &
     & 7.21218e-01_r8, 7.10492e-01_r8, 6.99926e-01_r8, 6.89517e-01_r8, 6.79262e-01_r8, &
     & 6.69160e-01_r8, 6.59209e-01_r8, 6.49405e-01_r8, 6.39747e-01_r8, 6.30233e-01_r8, &
     & 6.20860e-01_r8, 6.11627e-01_r8, 6.02531e-01_r8, 5.93570e-01_r8, 5.84743e-01_r8, &
     & 5.76047e-01_r8, 5.67480e-01_r8, 5.59040e-01_r8, 5.50726e-01_r8/)
      kao_mo3( 5, :, 7) = (/ &
     & 7.10588e-01_r8, 7.00014e-01_r8, 6.89596e-01_r8, 6.79334e-01_r8, 6.69225e-01_r8, &
     & 6.59266e-01_r8, 6.49455e-01_r8, 6.39790e-01_r8, 6.30269e-01_r8, 6.20889e-01_r8, &
     & 6.11650e-01_r8, 6.02547e-01_r8, 5.93581e-01_r8, 5.84747e-01_r8, 5.76045e-01_r8, &
     & 5.67473e-01_r8, 5.59028e-01_r8, 5.50709e-01_r8, 5.42513e-01_r8/)
      kao_mo3( 6, :, 7) = (/ &
     & 6.98166e-01_r8, 6.87706e-01_r8, 6.77402e-01_r8, 6.67253e-01_r8, 6.57256e-01_r8, &
     & 6.47408e-01_r8, 6.37708e-01_r8, 6.28154e-01_r8, 6.18742e-01_r8, 6.09472e-01_r8, &
     & 6.00340e-01_r8, 5.91346e-01_r8, 5.82486e-01_r8, 5.73758e-01_r8, 5.65162e-01_r8, &
     & 5.56694e-01_r8, 5.48353e-01_r8, 5.40138e-01_r8, 5.32045e-01_r8/)
      kao_mo3( 7, :, 7) = (/ &
     & 6.76974e-01_r8, 6.67034e-01_r8, 6.57240e-01_r8, 6.47590e-01_r8, 6.38081e-01_r8, &
     & 6.28712e-01_r8, 6.19481e-01_r8, 6.10385e-01_r8, 6.01422e-01_r8, 5.92592e-01_r8, &
     & 5.83891e-01_r8, 5.75317e-01_r8, 5.66870e-01_r8, 5.58547e-01_r8, 5.50345e-01_r8, &
     & 5.42265e-01_r8, 5.34303e-01_r8, 5.26457e-01_r8, 5.18727e-01_r8/)
      kao_mo3( 8, :, 7) = (/ &
     & 6.30061e-01_r8, 6.21017e-01_r8, 6.12102e-01_r8, 6.03316e-01_r8, 5.94656e-01_r8, &
     & 5.86120e-01_r8, 5.77706e-01_r8, 5.69414e-01_r8, 5.61240e-01_r8, 5.53184e-01_r8, &
     & 5.45243e-01_r8, 5.37416e-01_r8, 5.29702e-01_r8, 5.22098e-01_r8, 5.14604e-01_r8, &
     & 5.07217e-01_r8, 4.99936e-01_r8, 4.92760e-01_r8, 4.85687e-01_r8/)
      kao_mo3( 9, :, 7) = (/ &
     & 8.97633e-01_r8, 8.87307e-01_r8, 8.77100e-01_r8, 8.67010e-01_r8, 8.57036e-01_r8, &
     & 8.47176e-01_r8, 8.37431e-01_r8, 8.27797e-01_r8, 8.18274e-01_r8, 8.08861e-01_r8, &
     & 7.99555e-01_r8, 7.90357e-01_r8, 7.81265e-01_r8, 7.72278e-01_r8, 7.63393e-01_r8, &
     & 7.54611e-01_r8, 7.45930e-01_r8, 7.37349e-01_r8, 7.28867e-01_r8/)
      kao_mo3( 1, :, 8) = (/ &
     & 4.87356e-01_r8, 4.80743e-01_r8, 4.74220e-01_r8, 4.67785e-01_r8, 4.61437e-01_r8, &
     & 4.55176e-01_r8, 4.49000e-01_r8, 4.42907e-01_r8, 4.36897e-01_r8, 4.30969e-01_r8, &
     & 4.25121e-01_r8, 4.19353e-01_r8, 4.13663e-01_r8, 4.08049e-01_r8, 4.02513e-01_r8, &
     & 3.97051e-01_r8, 3.91663e-01_r8, 3.86349e-01_r8, 3.81106e-01_r8/)
      kao_mo3( 2, :, 8) = (/ &
     & 4.86776e-01_r8, 4.80157e-01_r8, 4.73627e-01_r8, 4.67187e-01_r8, 4.60834e-01_r8, &
     & 4.54567e-01_r8, 4.48386e-01_r8, 4.42289e-01_r8, 4.36274e-01_r8, 4.30342e-01_r8, &
     & 4.24490e-01_r8, 4.18718e-01_r8, 4.13024e-01_r8, 4.07407e-01_r8, 4.01867e-01_r8, &
     & 3.96403e-01_r8, 3.91012e-01_r8, 3.85695e-01_r8, 3.80450e-01_r8/)
      kao_mo3( 3, :, 8) = (/ &
     & 4.86111e-01_r8, 4.79496e-01_r8, 4.72972e-01_r8, 4.66536e-01_r8, 4.60188e-01_r8, &
     & 4.53926e-01_r8, 4.47750e-01_r8, 4.41657e-01_r8, 4.35648e-01_r8, 4.29720e-01_r8, &
     & 4.23873e-01_r8, 4.18105e-01_r8, 4.12416e-01_r8, 4.06804e-01_r8, 4.01269e-01_r8, &
     & 3.95809e-01_r8, 3.90423e-01_r8, 3.85111e-01_r8, 3.79871e-01_r8/)
      kao_mo3( 4, :, 8) = (/ &
     & 4.85501e-01_r8, 4.78880e-01_r8, 4.72350e-01_r8, 4.65908e-01_r8, 4.59554e-01_r8, &
     & 4.53288e-01_r8, 4.47106e-01_r8, 4.41009e-01_r8, 4.34995e-01_r8, 4.29063e-01_r8, &
     & 4.23211e-01_r8, 4.17440e-01_r8, 4.11747e-01_r8, 4.06132e-01_r8, 4.00594e-01_r8, &
     & 3.95131e-01_r8, 3.89743e-01_r8, 3.84428e-01_r8, 3.79185e-01_r8/)
      kao_mo3( 5, :, 8) = (/ &
     & 4.83679e-01_r8, 4.77140e-01_r8, 4.70691e-01_r8, 4.64328e-01_r8, 4.58051e-01_r8, &
     & 4.51859e-01_r8, 4.45751e-01_r8, 4.39726e-01_r8, 4.33781e-01_r8, 4.27918e-01_r8, &
     & 4.22133e-01_r8, 4.16427e-01_r8, 4.10798e-01_r8, 4.05245e-01_r8, 3.99767e-01_r8, &
     & 3.94363e-01_r8, 3.89032e-01_r8, 3.83773e-01_r8, 3.78585e-01_r8/)
      kao_mo3( 6, :, 8) = (/ &
     & 4.72120e-01_r8, 4.65834e-01_r8, 4.59630e-01_r8, 4.53510e-01_r8, 4.47471e-01_r8, &
     & 4.41513e-01_r8, 4.35633e-01_r8, 4.29833e-01_r8, 4.24109e-01_r8, 4.18461e-01_r8, &
     & 4.12889e-01_r8, 4.07391e-01_r8, 4.01966e-01_r8, 3.96614e-01_r8, 3.91332e-01_r8, &
     & 3.86122e-01_r8, 3.80980e-01_r8, 3.75907e-01_r8, 3.70901e-01_r8/)
      kao_mo3( 7, :, 8) = (/ &
     & 4.58683e-01_r8, 4.52758e-01_r8, 4.46909e-01_r8, 4.41135e-01_r8, 4.35437e-01_r8, &
     & 4.29812e-01_r8, 4.24259e-01_r8, 4.18779e-01_r8, 4.13369e-01_r8, 4.08029e-01_r8, &
     & 4.02758e-01_r8, 3.97555e-01_r8, 3.92419e-01_r8, 3.87350e-01_r8, 3.82346e-01_r8, &
     & 3.77406e-01_r8, 3.72531e-01_r8, 3.67719e-01_r8, 3.62968e-01_r8/)
      kao_mo3( 8, :, 8) = (/ &
     & 4.56091e-01_r8, 4.50481e-01_r8, 4.44940e-01_r8, 4.39467e-01_r8, 4.34062e-01_r8, &
     & 4.28722e-01_r8, 4.23449e-01_r8, 4.18240e-01_r8, 4.13096e-01_r8, 4.08015e-01_r8, &
     & 4.02996e-01_r8, 3.98039e-01_r8, 3.93143e-01_r8, 3.88307e-01_r8, 3.83531e-01_r8, &
     & 3.78813e-01_r8, 3.74154e-01_r8, 3.69552e-01_r8, 3.65006e-01_r8/)
      kao_mo3( 9, :, 8) = (/ &
     & 9.11213e-01_r8, 9.03270e-01_r8, 8.95396e-01_r8, 8.87591e-01_r8, 8.79855e-01_r8, &
     & 8.72185e-01_r8, 8.64583e-01_r8, 8.57046e-01_r8, 8.49576e-01_r8, 8.42170e-01_r8, &
     & 8.34829e-01_r8, 8.27552e-01_r8, 8.20339e-01_r8, 8.13188e-01_r8, 8.06100e-01_r8, &
     & 7.99073e-01_r8, 7.92108e-01_r8, 7.85204e-01_r8, 7.78359e-01_r8/)
      kao_mo3( 1, :, 9) = (/ &
     & 5.56194e-01_r8, 5.48595e-01_r8, 5.41100e-01_r8, 5.33707e-01_r8, 5.26415e-01_r8, &
     & 5.19223e-01_r8, 5.12129e-01_r8, 5.05132e-01_r8, 4.98231e-01_r8, 4.91424e-01_r8, &
     & 4.84710e-01_r8, 4.78087e-01_r8, 4.71556e-01_r8, 4.65113e-01_r8, 4.58758e-01_r8, &
     & 4.52491e-01_r8, 4.46309e-01_r8, 4.40211e-01_r8, 4.34197e-01_r8/)
      kao_mo3( 2, :, 9) = (/ &
     & 5.56174e-01_r8, 5.48575e-01_r8, 5.41079e-01_r8, 5.33687e-01_r8, 5.26395e-01_r8, &
     & 5.19203e-01_r8, 5.12109e-01_r8, 5.05112e-01_r8, 4.98211e-01_r8, 4.91404e-01_r8, &
     & 4.84690e-01_r8, 4.78068e-01_r8, 4.71536e-01_r8, 4.65093e-01_r8, 4.58739e-01_r8, &
     & 4.52471e-01_r8, 4.46289e-01_r8, 4.40191e-01_r8, 4.34177e-01_r8/)
      kao_mo3( 3, :, 9) = (/ &
     & 5.55996e-01_r8, 5.48403e-01_r8, 5.40913e-01_r8, 5.33526e-01_r8, 5.26239e-01_r8, &
     & 5.19052e-01_r8, 5.11963e-01_r8, 5.04971e-01_r8, 4.98074e-01_r8, 4.91272e-01_r8, &
     & 4.84562e-01_r8, 4.77944e-01_r8, 4.71417e-01_r8, 4.64978e-01_r8, 4.58628e-01_r8, &
     & 4.52364e-01_r8, 4.46186e-01_r8, 4.40092e-01_r8, 4.34081e-01_r8/)
      kao_mo3( 4, :, 9) = (/ &
     & 5.55859e-01_r8, 5.48271e-01_r8, 5.40786e-01_r8, 5.33404e-01_r8, 5.26123e-01_r8, &
     & 5.18941e-01_r8, 5.11856e-01_r8, 5.04869e-01_r8, 4.97977e-01_r8, 4.91179e-01_r8, &
     & 4.84474e-01_r8, 4.77861e-01_r8, 4.71337e-01_r8, 4.64903e-01_r8, 4.58557e-01_r8, &
     & 4.52297e-01_r8, 4.46123e-01_r8, 4.40033e-01_r8, 4.34026e-01_r8/)
      kao_mo3( 5, :, 9) = (/ &
     & 5.54550e-01_r8, 5.46921e-01_r8, 5.39397e-01_r8, 5.31976e-01_r8, 5.24657e-01_r8, &
     & 5.17439e-01_r8, 5.10320e-01_r8, 5.03300e-01_r8, 4.96376e-01_r8, 4.89547e-01_r8, &
     & 4.82812e-01_r8, 4.76170e-01_r8, 4.69619e-01_r8, 4.63158e-01_r8, 4.56786e-01_r8, &
     & 4.50502e-01_r8, 4.44304e-01_r8, 4.38192e-01_r8, 4.32163e-01_r8/)
      kao_mo3( 6, :, 9) = (/ &
     & 5.53514e-01_r8, 5.45883e-01_r8, 5.38358e-01_r8, 5.30937e-01_r8, 5.23618e-01_r8, &
     & 5.16399e-01_r8, 5.09280e-01_r8, 5.02260e-01_r8, 4.95336e-01_r8, 4.88507e-01_r8, &
     & 4.81773e-01_r8, 4.75132e-01_r8, 4.68582e-01_r8, 4.62122e-01_r8, 4.55752e-01_r8, &
     & 4.49469e-01_r8, 4.43273e-01_r8, 4.37162e-01_r8, 4.31136e-01_r8/)
      kao_mo3( 7, :, 9) = (/ &
     & 5.49865e-01_r8, 5.42303e-01_r8, 5.34846e-01_r8, 5.27491e-01_r8, 5.20237e-01_r8, &
     & 5.13084e-01_r8, 5.06028e-01_r8, 4.99070e-01_r8, 4.92207e-01_r8, 4.85438e-01_r8, &
     & 4.78763e-01_r8, 4.72179e-01_r8, 4.65686e-01_r8, 4.59282e-01_r8, 4.52967e-01_r8, &
     & 4.46738e-01_r8, 4.40595e-01_r8, 4.34536e-01_r8, 4.28561e-01_r8/)
      kao_mo3( 8, :, 9) = (/ &
     & 5.25435e-01_r8, 5.18437e-01_r8, 5.11533e-01_r8, 5.04721e-01_r8, 4.97999e-01_r8, &
     & 4.91367e-01_r8, 4.84823e-01_r8, 4.78366e-01_r8, 4.71996e-01_r8, 4.65710e-01_r8, &
     & 4.59508e-01_r8, 4.53388e-01_r8, 4.47350e-01_r8, 4.41393e-01_r8, 4.35515e-01_r8, &
     & 4.29715e-01_r8, 4.23992e-01_r8, 4.18345e-01_r8, 4.12774e-01_r8/)
      kao_mo3( 9, :, 9) = (/ &
     & 3.48228e-01_r8, 3.45949e-01_r8, 3.43686e-01_r8, 3.41437e-01_r8, 3.39203e-01_r8, &
     & 3.36983e-01_r8, 3.34778e-01_r8, 3.32588e-01_r8, 3.30412e-01_r8, 3.28250e-01_r8, &
     & 3.26102e-01_r8, 3.23968e-01_r8, 3.21848e-01_r8, 3.19742e-01_r8, 3.17650e-01_r8, &
     & 3.15572e-01_r8, 3.13507e-01_r8, 3.11456e-01_r8, 3.09418e-01_r8/)
      kao_mo3( 1, :,10) = (/ &
     & 8.34107e-01_r8, 8.27276e-01_r8, 8.20501e-01_r8, 8.13781e-01_r8, 8.07117e-01_r8, &
     & 8.00507e-01_r8, 7.93951e-01_r8, 7.87449e-01_r8, 7.81000e-01_r8, 7.74604e-01_r8, &
     & 7.68260e-01_r8, 7.61968e-01_r8, 7.55728e-01_r8, 7.49539e-01_r8, 7.43400e-01_r8, &
     & 7.37312e-01_r8, 7.31274e-01_r8, 7.25285e-01_r8, 7.19345e-01_r8/)
      kao_mo3( 2, :,10) = (/ &
     & 8.32838e-01_r8, 8.26022e-01_r8, 8.19263e-01_r8, 8.12558e-01_r8, 8.05908e-01_r8, &
     & 7.99313e-01_r8, 7.92772e-01_r8, 7.86284e-01_r8, 7.79849e-01_r8, 7.73467e-01_r8, &
     & 7.67137e-01_r8, 7.60859e-01_r8, 7.54633e-01_r8, 7.48457e-01_r8, 7.42332e-01_r8, &
     & 7.36257e-01_r8, 7.30232e-01_r8, 7.24256e-01_r8, 7.18329e-01_r8/)
      kao_mo3( 3, :,10) = (/ &
     & 8.31167e-01_r8, 8.24361e-01_r8, 8.17611e-01_r8, 8.10916e-01_r8, 8.04276e-01_r8, &
     & 7.97691e-01_r8, 7.91159e-01_r8, 7.84681e-01_r8, 7.78256e-01_r8, 7.71883e-01_r8, &
     & 7.65563e-01_r8, 7.59294e-01_r8, 7.53077e-01_r8, 7.46910e-01_r8, 7.40795e-01_r8, &
     & 7.34729e-01_r8, 7.28713e-01_r8, 7.22746e-01_r8, 7.16828e-01_r8/)
      kao_mo3( 4, :,10) = (/ &
     & 8.29026e-01_r8, 8.22246e-01_r8, 8.15521e-01_r8, 8.08851e-01_r8, 8.02236e-01_r8, &
     & 7.95675e-01_r8, 7.89167e-01_r8, 7.82713e-01_r8, 7.76312e-01_r8, 7.69962e-01_r8, &
     & 7.63665e-01_r8, 7.57419e-01_r8, 7.51225e-01_r8, 7.45081e-01_r8, 7.38987e-01_r8, &
     & 7.32943e-01_r8, 7.26949e-01_r8, 7.21003e-01_r8, 7.15107e-01_r8/)
      kao_mo3( 5, :,10) = (/ &
     & 8.26226e-01_r8, 8.19471e-01_r8, 8.12771e-01_r8, 8.06126e-01_r8, 7.99536e-01_r8, &
     & 7.92999e-01_r8, 7.86515e-01_r8, 7.80085e-01_r8, 7.73707e-01_r8, 7.67382e-01_r8, &
     & 7.61108e-01_r8, 7.54885e-01_r8, 7.48714e-01_r8, 7.42592e-01_r8, 7.36521e-01_r8, &
     & 7.30500e-01_r8, 7.24527e-01_r8, 7.18604e-01_r8, 7.12729e-01_r8/)
      kao_mo3( 6, :,10) = (/ &
     & 8.33246e-01_r8, 8.26510e-01_r8, 8.19828e-01_r8, 8.13200e-01_r8, 8.06626e-01_r8, &
     & 8.00105e-01_r8, 7.93637e-01_r8, 7.87221e-01_r8, 7.80856e-01_r8, 7.74544e-01_r8, &
     & 7.68282e-01_r8, 7.62071e-01_r8, 7.55910e-01_r8, 7.49799e-01_r8, 7.43737e-01_r8, &
     & 7.37725e-01_r8, 7.31760e-01_r8, 7.25845e-01_r8, 7.19977e-01_r8/)
      kao_mo3( 7, :,10) = (/ &
     & 8.45693e-01_r8, 8.38967e-01_r8, 8.32295e-01_r8, 8.25675e-01_r8, 8.19108e-01_r8, &
     & 8.12594e-01_r8, 8.06131e-01_r8, 7.99719e-01_r8, 7.93359e-01_r8, 7.87049e-01_r8, &
     & 7.80789e-01_r8, 7.74579e-01_r8, 7.68419e-01_r8, 7.62307e-01_r8, 7.56244e-01_r8, &
     & 7.50230e-01_r8, 7.44263e-01_r8, 7.38343e-01_r8, 7.32471e-01_r8/)
      kao_mo3( 8, :,10) = (/ &
     & 8.32139e-01_r8, 8.25565e-01_r8, 8.19044e-01_r8, 8.12574e-01_r8, 8.06156e-01_r8, &
     & 7.99788e-01_r8, 7.93470e-01_r8, 7.87202e-01_r8, 7.80984e-01_r8, 7.74815e-01_r8, &
     & 7.68694e-01_r8, 7.62622e-01_r8, 7.56598e-01_r8, 7.50622e-01_r8, 7.44692e-01_r8, &
     & 7.38810e-01_r8, 7.32974e-01_r8, 7.27184e-01_r8, 7.21440e-01_r8/)
      kao_mo3( 9, :,10) = (/ &
     & 2.34258e-01_r8, 2.35247e-01_r8, 2.36239e-01_r8, 2.37236e-01_r8, 2.38237e-01_r8, &
     & 2.39242e-01_r8, 2.40252e-01_r8, 2.41265e-01_r8, 2.42283e-01_r8, 2.43306e-01_r8, &
     & 2.44332e-01_r8, 2.45363e-01_r8, 2.46398e-01_r8, 2.47438e-01_r8, 2.48482e-01_r8, &
     & 2.49531e-01_r8, 2.50583e-01_r8, 2.51641e-01_r8, 2.52702e-01_r8/)
      kao_mo3( 1, :,11) = (/ &
     & 8.31308e-01_r8, 8.22153e-01_r8, 8.13098e-01_r8, 8.04143e-01_r8, 7.95287e-01_r8, &
     & 7.86528e-01_r8, 7.77866e-01_r8, 7.69299e-01_r8, 7.60827e-01_r8, 7.52448e-01_r8, &
     & 7.44161e-01_r8, 7.35965e-01_r8, 7.27860e-01_r8, 7.19844e-01_r8, 7.11916e-01_r8, &
     & 7.04075e-01_r8, 6.96321e-01_r8, 6.88652e-01_r8, 6.81068e-01_r8/)
      kao_mo3( 2, :,11) = (/ &
     & 8.31577e-01_r8, 8.22400e-01_r8, 8.13324e-01_r8, 8.04349e-01_r8, 7.95472e-01_r8, &
     & 7.86693e-01_r8, 7.78011e-01_r8, 7.69425e-01_r8, 7.60934e-01_r8, 7.52537e-01_r8, &
     & 7.44232e-01_r8, 7.36019e-01_r8, 7.27896e-01_r8, 7.19863e-01_r8, 7.11919e-01_r8, &
     & 7.04062e-01_r8, 6.96292e-01_r8, 6.88608e-01_r8, 6.81009e-01_r8/)
      kao_mo3( 3, :,11) = (/ &
     & 8.31578e-01_r8, 8.22422e-01_r8, 8.13368e-01_r8, 8.04413e-01_r8, 7.95557e-01_r8, &
     & 7.86798e-01_r8, 7.78136e-01_r8, 7.69569e-01_r8, 7.61097e-01_r8, 7.52717e-01_r8, &
     & 7.44430e-01_r8, 7.36235e-01_r8, 7.28129e-01_r8, 7.20113e-01_r8, 7.12185e-01_r8, &
     & 7.04344e-01_r8, 6.96589e-01_r8, 6.88920e-01_r8, 6.81336e-01_r8/)
      kao_mo3( 4, :,11) = (/ &
     & 8.31261e-01_r8, 8.22111e-01_r8, 8.13062e-01_r8, 8.04112e-01_r8, 7.95261e-01_r8, &
     & 7.86507e-01_r8, 7.77850e-01_r8, 7.69288e-01_r8, 7.60820e-01_r8, 7.52445e-01_r8, &
     & 7.44163e-01_r8, 7.35971e-01_r8, 7.27870e-01_r8, 7.19858e-01_r8, 7.11935e-01_r8, &
     & 7.04098e-01_r8, 6.96348e-01_r8, 6.88683e-01_r8, 6.81102e-01_r8/)
      kao_mo3( 5, :,11) = (/ &
     & 8.31565e-01_r8, 8.22404e-01_r8, 8.13344e-01_r8, 8.04384e-01_r8, 7.95523e-01_r8, &
     & 7.86760e-01_r8, 7.78092e-01_r8, 7.69521e-01_r8, 7.61044e-01_r8, 7.52660e-01_r8, &
     & 7.44368e-01_r8, 7.36168e-01_r8, 7.28058e-01_r8, 7.20038e-01_r8, 7.12106e-01_r8, &
     & 7.04261e-01_r8, 6.96503e-01_r8, 6.88830e-01_r8, 6.81242e-01_r8/)
      kao_mo3( 6, :,11) = (/ &
     & 8.17636e-01_r8, 8.08497e-01_r8, 7.99461e-01_r8, 7.90525e-01_r8, 7.81690e-01_r8, &
     & 7.72953e-01_r8, 7.64314e-01_r8, 7.55771e-01_r8, 7.47324e-01_r8, 7.38971e-01_r8, &
     & 7.30712e-01_r8, 7.22545e-01_r8, 7.14469e-01_r8, 7.06483e-01_r8, 6.98587e-01_r8, &
     & 6.90779e-01_r8, 6.83058e-01_r8, 6.75424e-01_r8, 6.67875e-01_r8/)
      kao_mo3( 7, :,11) = (/ &
     & 7.95247e-01_r8, 7.86140e-01_r8, 7.77137e-01_r8, 7.68238e-01_r8, 7.59440e-01_r8, &
     & 7.50743e-01_r8, 7.42145e-01_r8, 7.33646e-01_r8, 7.25245e-01_r8, 7.16939e-01_r8, &
     & 7.08729e-01_r8, 7.00612e-01_r8, 6.92589e-01_r8, 6.84658e-01_r8, 6.76817e-01_r8, &
     & 6.69066e-01_r8, 6.61404e-01_r8, 6.53830e-01_r8, 6.46342e-01_r8/)
      kao_mo3( 8, :,11) = (/ &
     & 7.63069e-01_r8, 7.54006e-01_r8, 7.45051e-01_r8, 7.36202e-01_r8, 7.27458e-01_r8, &
     & 7.18818e-01_r8, 7.10281e-01_r8, 7.01845e-01_r8, 6.93509e-01_r8, 6.85272e-01_r8, &
     & 6.77133e-01_r8, 6.69091e-01_r8, 6.61144e-01_r8, 6.53292e-01_r8, 6.45533e-01_r8, &
     & 6.37866e-01_r8, 6.30290e-01_r8, 6.22804e-01_r8, 6.15407e-01_r8/)
      kao_mo3( 9, :,11) = (/ &
     & 2.03255e-01_r8, 2.03004e-01_r8, 2.02753e-01_r8, 2.02502e-01_r8, 2.02252e-01_r8, &
     & 2.02001e-01_r8, 2.01752e-01_r8, 2.01502e-01_r8, 2.01253e-01_r8, 2.01004e-01_r8, &
     & 2.00755e-01_r8, 2.00507e-01_r8, 2.00259e-01_r8, 2.00011e-01_r8, 1.99764e-01_r8, &
     & 1.99517e-01_r8, 1.99270e-01_r8, 1.99024e-01_r8, 1.98777e-01_r8/)
      kao_mo3( 1, :,12) = (/ &
     & 4.13201e-01_r8, 4.05258e-01_r8, 3.97468e-01_r8, 3.89828e-01_r8, 3.82334e-01_r8, &
     & 3.74985e-01_r8, 3.67777e-01_r8, 3.60707e-01_r8, 3.53774e-01_r8, 3.46973e-01_r8, &
     & 3.40303e-01_r8, 3.33762e-01_r8, 3.27346e-01_r8, 3.21054e-01_r8, 3.14882e-01_r8, &
     & 3.08829e-01_r8, 3.02893e-01_r8, 2.97071e-01_r8, 2.91360e-01_r8/)
      kao_mo3( 2, :,12) = (/ &
     & 4.12835e-01_r8, 4.04897e-01_r8, 3.97112e-01_r8, 3.89477e-01_r8, 3.81988e-01_r8, &
     & 3.74644e-01_r8, 3.67440e-01_r8, 3.60376e-01_r8, 3.53447e-01_r8, 3.46651e-01_r8, &
     & 3.39986e-01_r8, 3.33449e-01_r8, 3.27038e-01_r8, 3.20750e-01_r8, 3.14582e-01_r8, &
     & 3.08534e-01_r8, 3.02602e-01_r8, 2.96784e-01_r8, 2.91077e-01_r8/)
      kao_mo3( 3, :,12) = (/ &
     & 4.13023e-01_r8, 4.05079e-01_r8, 3.97289e-01_r8, 3.89648e-01_r8, 3.82155e-01_r8, &
     & 3.74805e-01_r8, 3.67597e-01_r8, 3.60527e-01_r8, 3.53594e-01_r8, 3.46793e-01_r8, &
     & 3.40124e-01_r8, 3.33583e-01_r8, 3.27167e-01_r8, 3.20875e-01_r8, 3.14704e-01_r8, &
     & 3.08652e-01_r8, 3.02716e-01_r8, 2.96894e-01_r8, 2.91184e-01_r8/)
      kao_mo3( 4, :,12) = (/ &
     & 4.13397e-01_r8, 4.05437e-01_r8, 3.97630e-01_r8, 3.89973e-01_r8, 3.82463e-01_r8, &
     & 3.75099e-01_r8, 3.67876e-01_r8, 3.60792e-01_r8, 3.53844e-01_r8, 3.47031e-01_r8, &
     & 3.40348e-01_r8, 3.33794e-01_r8, 3.27367e-01_r8, 3.21063e-01_r8, 3.14880e-01_r8, &
     & 3.08817e-01_r8, 3.02870e-01_r8, 2.97038e-01_r8, 2.91318e-01_r8/)
      kao_mo3( 5, :,12) = (/ &
     & 4.13043e-01_r8, 4.05106e-01_r8, 3.97321e-01_r8, 3.89686e-01_r8, 3.82198e-01_r8, &
     & 3.74854e-01_r8, 3.67651e-01_r8, 3.60586e-01_r8, 3.53657e-01_r8, 3.46861e-01_r8, &
     & 3.40195e-01_r8, 3.33658e-01_r8, 3.27246e-01_r8, 3.20958e-01_r8, 3.14790e-01_r8, &
     & 3.08741e-01_r8, 3.02808e-01_r8, 2.96990e-01_r8, 2.91283e-01_r8/)
      kao_mo3( 6, :,12) = (/ &
     & 4.13151e-01_r8, 4.05202e-01_r8, 3.97406e-01_r8, 3.89760e-01_r8, 3.82261e-01_r8, &
     & 3.74906e-01_r8, 3.67693e-01_r8, 3.60619e-01_r8, 3.53680e-01_r8, 3.46876e-01_r8, &
     & 3.40202e-01_r8, 3.33656e-01_r8, 3.27237e-01_r8, 3.20941e-01_r8, 3.14766e-01_r8, &
     & 3.08710e-01_r8, 3.02770e-01_r8, 2.96945e-01_r8, 2.91232e-01_r8/)
      kao_mo3( 7, :,12) = (/ &
     & 4.13052e-01_r8, 4.05109e-01_r8, 3.97319e-01_r8, 3.89678e-01_r8, 3.82185e-01_r8, &
     & 3.74835e-01_r8, 3.67627e-01_r8, 3.60557e-01_r8, 3.53624e-01_r8, 3.46823e-01_r8, &
     & 3.40154e-01_r8, 3.33612e-01_r8, 3.27197e-01_r8, 3.20905e-01_r8, 3.14734e-01_r8, &
     & 3.08681e-01_r8, 3.02745e-01_r8, 2.96923e-01_r8, 2.91213e-01_r8/)
      kao_mo3( 8, :,12) = (/ &
     & 4.13152e-01_r8, 4.05209e-01_r8, 3.97418e-01_r8, 3.89778e-01_r8, 3.82284e-01_r8, &
     & 3.74935e-01_r8, 3.67727e-01_r8, 3.60657e-01_r8, 3.53723e-01_r8, 3.46923e-01_r8, &
     & 3.40253e-01_r8, 3.33712e-01_r8, 3.27296e-01_r8, 3.21004e-01_r8, 3.14833e-01_r8, &
     & 3.08780e-01_r8, 3.02844e-01_r8, 2.97021e-01_r8, 2.91311e-01_r8/)
      kao_mo3( 9, :,12) = (/ &
     & 1.31008e-01_r8, 1.30607e-01_r8, 1.30208e-01_r8, 1.29810e-01_r8, 1.29413e-01_r8, &
     & 1.29017e-01_r8, 1.28623e-01_r8, 1.28229e-01_r8, 1.27837e-01_r8, 1.27446e-01_r8, &
     & 1.27056e-01_r8, 1.26668e-01_r8, 1.26280e-01_r8, 1.25894e-01_r8, 1.25509e-01_r8, &
     & 1.25125e-01_r8, 1.24743e-01_r8, 1.24361e-01_r8, 1.23981e-01_r8/)
      kao_mo3( 1, :,13) = (/ &
     & 4.66826e-01_r8, 4.71437e-01_r8, 4.76094e-01_r8, 4.80798e-01_r8, 4.85547e-01_r8, &
     & 4.90344e-01_r8, 4.95187e-01_r8, 5.00079e-01_r8, 5.05019e-01_r8, 5.10008e-01_r8, &
     & 5.15046e-01_r8, 5.20134e-01_r8, 5.25272e-01_r8, 5.30461e-01_r8, 5.35701e-01_r8, &
     & 5.40993e-01_r8, 5.46338e-01_r8, 5.51735e-01_r8, 5.57185e-01_r8/)
      kao_mo3( 2, :,13) = (/ &
     & 4.66579e-01_r8, 4.71199e-01_r8, 4.75865e-01_r8, 4.80577e-01_r8, 4.85336e-01_r8, &
     & 4.90141e-01_r8, 4.94995e-01_r8, 4.99896e-01_r8, 5.04846e-01_r8, 5.09845e-01_r8, &
     & 5.14893e-01_r8, 5.19992e-01_r8, 5.25141e-01_r8, 5.30340e-01_r8, 5.35592e-01_r8, &
     & 5.40895e-01_r8, 5.46251e-01_r8, 5.51660e-01_r8, 5.57122e-01_r8/)
      kao_mo3( 3, :,13) = (/ &
     & 4.66956e-01_r8, 4.71567e-01_r8, 4.76224e-01_r8, 4.80927e-01_r8, 4.85677e-01_r8, &
     & 4.90474e-01_r8, 4.95318e-01_r8, 5.00209e-01_r8, 5.05149e-01_r8, 5.10138e-01_r8, &
     & 5.15176e-01_r8, 5.20264e-01_r8, 5.25402e-01_r8, 5.30591e-01_r8, 5.35831e-01_r8, &
     & 5.41123e-01_r8, 5.46467e-01_r8, 5.51864e-01_r8, 5.57314e-01_r8/)
      kao_mo3( 4, :,13) = (/ &
     & 4.66456e-01_r8, 4.71080e-01_r8, 4.75750e-01_r8, 4.80467e-01_r8, 4.85230e-01_r8, &
     & 4.90040e-01_r8, 4.94898e-01_r8, 4.99804e-01_r8, 5.04759e-01_r8, 5.09763e-01_r8, &
     & 5.14817e-01_r8, 5.19920e-01_r8, 5.25075e-01_r8, 5.30280e-01_r8, 5.35537e-01_r8, &
     & 5.40846e-01_r8, 5.46208e-01_r8, 5.51622e-01_r8, 5.57091e-01_r8/)
      kao_mo3( 5, :,13) = (/ &
     & 4.66853e-01_r8, 4.71456e-01_r8, 4.76104e-01_r8, 4.80798e-01_r8, 4.85539e-01_r8, &
     & 4.90326e-01_r8, 4.95160e-01_r8, 5.00042e-01_r8, 5.04973e-01_r8, 5.09952e-01_r8, &
     & 5.14979e-01_r8, 5.20057e-01_r8, 5.25185e-01_r8, 5.30363e-01_r8, 5.35592e-01_r8, &
     & 5.40873e-01_r8, 5.46205e-01_r8, 5.51591e-01_r8, 5.57029e-01_r8/)
      kao_mo3( 6, :,13) = (/ &
     & 4.66832e-01_r8, 4.71448e-01_r8, 4.76110e-01_r8, 4.80817e-01_r8, 4.85571e-01_r8, &
     & 4.90372e-01_r8, 4.95221e-01_r8, 5.00118e-01_r8, 5.05063e-01_r8, 5.10056e-01_r8, &
     & 5.15100e-01_r8, 5.20193e-01_r8, 5.25336e-01_r8, 5.30531e-01_r8, 5.35776e-01_r8, &
     & 5.41074e-01_r8, 5.46424e-01_r8, 5.51826e-01_r8, 5.57283e-01_r8/)
      kao_mo3( 7, :,13) = (/ &
     & 4.66679e-01_r8, 4.71299e-01_r8, 4.75965e-01_r8, 4.80677e-01_r8, 4.85436e-01_r8, &
     & 4.90241e-01_r8, 4.95095e-01_r8, 4.99996e-01_r8, 5.04946e-01_r8, 5.09945e-01_r8, &
     & 5.14993e-01_r8, 5.20092e-01_r8, 5.25240e-01_r8, 5.30440e-01_r8, 5.35692e-01_r8, &
     & 5.40995e-01_r8, 5.46351e-01_r8, 5.51759e-01_r8, 5.57222e-01_r8/)
      kao_mo3( 8, :,13) = (/ &
     & 4.66982e-01_r8, 4.71598e-01_r8, 4.76260e-01_r8, 4.80967e-01_r8, 4.85721e-01_r8, &
     & 4.90522e-01_r8, 4.95371e-01_r8, 5.00268e-01_r8, 5.05213e-01_r8, 5.10206e-01_r8, &
     & 5.15250e-01_r8, 5.20343e-01_r8, 5.25486e-01_r8, 5.30680e-01_r8, 5.35926e-01_r8, &
     & 5.41223e-01_r8, 5.46573e-01_r8, 5.51976e-01_r8, 5.57432e-01_r8/)
      kao_mo3( 9, :,13) = (/ &
     & 1.13709e-01_r8, 1.13141e-01_r8, 1.12576e-01_r8, 1.12013e-01_r8, 1.11453e-01_r8, &
     & 1.10897e-01_r8, 1.10342e-01_r8, 1.09791e-01_r8, 1.09242e-01_r8, 1.08696e-01_r8, &
     & 1.08153e-01_r8, 1.07613e-01_r8, 1.07075e-01_r8, 1.06540e-01_r8, 1.06007e-01_r8, &
     & 1.05478e-01_r8, 1.04951e-01_r8, 1.04426e-01_r8, 1.03904e-01_r8/)
      kao_mo3( 1, :,14) = (/ &
     & 5.67608e-01_r8, 5.55796e-01_r8, 5.44230e-01_r8, 5.32904e-01_r8, 5.21814e-01_r8, &
     & 5.10955e-01_r8, 5.00322e-01_r8, 4.89910e-01_r8, 4.79714e-01_r8, 4.69731e-01_r8, &
     & 4.59956e-01_r8, 4.50384e-01_r8, 4.41011e-01_r8, 4.31834e-01_r8, 4.22847e-01_r8, &
     & 4.14048e-01_r8, 4.05431e-01_r8, 3.96994e-01_r8, 3.88732e-01_r8/)
      kao_mo3( 2, :,14) = (/ &
     & 5.67766e-01_r8, 5.55948e-01_r8, 5.44376e-01_r8, 5.33045e-01_r8, 5.21950e-01_r8, &
     & 5.11086e-01_r8, 5.00448e-01_r8, 4.90031e-01_r8, 4.79831e-01_r8, 4.69844e-01_r8, &
     & 4.60064e-01_r8, 4.50488e-01_r8, 4.41111e-01_r8, 4.31930e-01_r8, 4.22939e-01_r8, &
     & 4.14136e-01_r8, 4.05516e-01_r8, 3.97075e-01_r8, 3.88810e-01_r8/)
      kao_mo3( 3, :,14) = (/ &
     & 5.67460e-01_r8, 5.55647e-01_r8, 5.44080e-01_r8, 5.32754e-01_r8, 5.21664e-01_r8, &
     & 5.10805e-01_r8, 5.00172e-01_r8, 4.89760e-01_r8, 4.79564e-01_r8, 4.69582e-01_r8, &
     & 4.59806e-01_r8, 4.50235e-01_r8, 4.40862e-01_r8, 4.31685e-01_r8, 4.22699e-01_r8, &
     & 4.13900e-01_r8, 4.05284e-01_r8, 3.96847e-01_r8, 3.88586e-01_r8/)
      kao_mo3( 4, :,14) = (/ &
     & 5.67925e-01_r8, 5.56107e-01_r8, 5.44536e-01_r8, 5.33205e-01_r8, 5.22110e-01_r8, &
     & 5.11246e-01_r8, 5.00608e-01_r8, 4.90191e-01_r8, 4.79991e-01_r8, 4.70004e-01_r8, &
     & 4.60224e-01_r8, 4.50647e-01_r8, 4.41270e-01_r8, 4.32088e-01_r8, 4.23097e-01_r8, &
     & 4.14293e-01_r8, 4.05673e-01_r8, 3.97231e-01_r8, 3.88966e-01_r8/)
      kao_mo3( 5, :,14) = (/ &
     & 5.67520e-01_r8, 5.55733e-01_r8, 5.44190e-01_r8, 5.32887e-01_r8, 5.21818e-01_r8, &
     & 5.10980e-01_r8, 5.00366e-01_r8, 4.89974e-01_r8, 4.79797e-01_r8, 4.69831e-01_r8, &
     & 4.60072e-01_r8, 4.50516e-01_r8, 4.41159e-01_r8, 4.31996e-01_r8, 4.23023e-01_r8, &
     & 4.14236e-01_r8, 4.05633e-01_r8, 3.97207e-01_r8, 3.88957e-01_r8/)
      kao_mo3( 6, :,14) = (/ &
     & 5.67549e-01_r8, 5.55749e-01_r8, 5.44195e-01_r8, 5.32880e-01_r8, 5.21801e-01_r8, &
     & 5.10952e-01_r8, 5.00329e-01_r8, 4.89927e-01_r8, 4.79740e-01_r8, 4.69766e-01_r8, &
     & 4.59999e-01_r8, 4.50435e-01_r8, 4.41070e-01_r8, 4.31900e-01_r8, 4.22920e-01_r8, &
     & 4.14127e-01_r8, 4.05517e-01_r8, 3.97086e-01_r8, 3.88830e-01_r8/)
      kao_mo3( 7, :,14) = (/ &
     & 5.67727e-01_r8, 5.55909e-01_r8, 5.44337e-01_r8, 5.33005e-01_r8, 5.21910e-01_r8, &
     & 5.11046e-01_r8, 5.00408e-01_r8, 4.89991e-01_r8, 4.79791e-01_r8, 4.69804e-01_r8, &
     & 4.60024e-01_r8, 4.50448e-01_r8, 4.41071e-01_r8, 4.31890e-01_r8, 4.22900e-01_r8, &
     & 4.14096e-01_r8, 4.05476e-01_r8, 3.97036e-01_r8, 3.88771e-01_r8/)
      kao_mo3( 8, :,14) = (/ &
     & 5.67795e-01_r8, 5.55965e-01_r8, 5.44381e-01_r8, 5.33039e-01_r8, 5.21933e-01_r8, &
     & 5.11058e-01_r8, 5.00410e-01_r8, 4.89984e-01_r8, 4.79775e-01_r8, 4.69779e-01_r8, &
     & 4.59991e-01_r8, 4.50407e-01_r8, 4.41023e-01_r8, 4.31834e-01_r8, 4.22836e-01_r8, &
     & 4.14026e-01_r8, 4.05400e-01_r8, 3.96953e-01_r8, 3.88683e-01_r8/)
      kao_mo3( 9, :,14) = (/ &
     & 1.32957e-01_r8, 1.31737e-01_r8, 1.30528e-01_r8, 1.29330e-01_r8, 1.28143e-01_r8, &
     & 1.26967e-01_r8, 1.25802e-01_r8, 1.24648e-01_r8, 1.23504e-01_r8, 1.22370e-01_r8, &
     & 1.21247e-01_r8, 1.20135e-01_r8, 1.19032e-01_r8, 1.17940e-01_r8, 1.16857e-01_r8, &
     & 1.15785e-01_r8, 1.14722e-01_r8, 1.13669e-01_r8, 1.12626e-01_r8/)
      kao_mo3( 1, :,15) = (/ &
     & 1.51281e-01_r8, 1.53439e-01_r8, 1.55628e-01_r8, 1.57848e-01_r8, 1.60100e-01_r8, &
     & 1.62384e-01_r8, 1.64700e-01_r8, 1.67049e-01_r8, 1.69432e-01_r8, 1.71849e-01_r8, &
     & 1.74301e-01_r8, 1.76787e-01_r8, 1.79309e-01_r8, 1.81866e-01_r8, 1.84461e-01_r8, &
     & 1.87092e-01_r8, 1.89761e-01_r8, 1.92468e-01_r8, 1.95213e-01_r8/)
      kao_mo3( 2, :,15) = (/ &
     & 1.51431e-01_r8, 1.53589e-01_r8, 1.55778e-01_r8, 1.57998e-01_r8, 1.60250e-01_r8, &
     & 1.62534e-01_r8, 1.64850e-01_r8, 1.67199e-01_r8, 1.69582e-01_r8, 1.71999e-01_r8, &
     & 1.74450e-01_r8, 1.76937e-01_r8, 1.79458e-01_r8, 1.82016e-01_r8, 1.84610e-01_r8, &
     & 1.87241e-01_r8, 1.89909e-01_r8, 1.92616e-01_r8, 1.95361e-01_r8/)
      kao_mo3( 3, :,15) = (/ &
     & 1.51299e-01_r8, 1.53461e-01_r8, 1.55654e-01_r8, 1.57878e-01_r8, 1.60134e-01_r8, &
     & 1.62422e-01_r8, 1.64744e-01_r8, 1.67098e-01_r8, 1.69486e-01_r8, 1.71908e-01_r8, &
     & 1.74364e-01_r8, 1.76856e-01_r8, 1.79383e-01_r8, 1.81947e-01_r8, 1.84547e-01_r8, &
     & 1.87184e-01_r8, 1.89859e-01_r8, 1.92572e-01_r8, 1.95324e-01_r8/)
      kao_mo3( 4, :,15) = (/ &
     & 1.51281e-01_r8, 1.53439e-01_r8, 1.55628e-01_r8, 1.57848e-01_r8, 1.60100e-01_r8, &
     & 1.62384e-01_r8, 1.64700e-01_r8, 1.67049e-01_r8, 1.69432e-01_r8, 1.71849e-01_r8, &
     & 1.74301e-01_r8, 1.76787e-01_r8, 1.79309e-01_r8, 1.81866e-01_r8, 1.84461e-01_r8, &
     & 1.87092e-01_r8, 1.89761e-01_r8, 1.92468e-01_r8, 1.95213e-01_r8/)
      kao_mo3( 5, :,15) = (/ &
     & 1.51281e-01_r8, 1.53439e-01_r8, 1.55628e-01_r8, 1.57848e-01_r8, 1.60100e-01_r8, &
     & 1.62384e-01_r8, 1.64700e-01_r8, 1.67049e-01_r8, 1.69432e-01_r8, 1.71849e-01_r8, &
     & 1.74301e-01_r8, 1.76787e-01_r8, 1.79309e-01_r8, 1.81866e-01_r8, 1.84461e-01_r8, &
     & 1.87092e-01_r8, 1.89761e-01_r8, 1.92468e-01_r8, 1.95213e-01_r8/)
      kao_mo3( 6, :,15) = (/ &
     & 1.51299e-01_r8, 1.53461e-01_r8, 1.55654e-01_r8, 1.57878e-01_r8, 1.60134e-01_r8, &
     & 1.62422e-01_r8, 1.64744e-01_r8, 1.67098e-01_r8, 1.69486e-01_r8, 1.71908e-01_r8, &
     & 1.74364e-01_r8, 1.76856e-01_r8, 1.79383e-01_r8, 1.81947e-01_r8, 1.84547e-01_r8, &
     & 1.87184e-01_r8, 1.89859e-01_r8, 1.92572e-01_r8, 1.95324e-01_r8/)
      kao_mo3( 7, :,15) = (/ &
     & 1.51299e-01_r8, 1.53461e-01_r8, 1.55654e-01_r8, 1.57878e-01_r8, 1.60134e-01_r8, &
     & 1.62422e-01_r8, 1.64744e-01_r8, 1.67098e-01_r8, 1.69486e-01_r8, 1.71908e-01_r8, &
     & 1.74364e-01_r8, 1.76856e-01_r8, 1.79383e-01_r8, 1.81947e-01_r8, 1.84547e-01_r8, &
     & 1.87184e-01_r8, 1.89859e-01_r8, 1.92572e-01_r8, 1.95324e-01_r8/)
      kao_mo3( 8, :,15) = (/ &
     & 1.51281e-01_r8, 1.53439e-01_r8, 1.55628e-01_r8, 1.57848e-01_r8, 1.60100e-01_r8, &
     & 1.62384e-01_r8, 1.64700e-01_r8, 1.67049e-01_r8, 1.69432e-01_r8, 1.71849e-01_r8, &
     & 1.74301e-01_r8, 1.76787e-01_r8, 1.79309e-01_r8, 1.81866e-01_r8, 1.84461e-01_r8, &
     & 1.87092e-01_r8, 1.89761e-01_r8, 1.92468e-01_r8, 1.95213e-01_r8/)
      kao_mo3( 9, :,15) = (/ &
     & 2.44180e-01_r8, 2.35686e-01_r8, 2.27487e-01_r8, 2.19574e-01_r8, 2.11935e-01_r8, &
     & 2.04563e-01_r8, 1.97447e-01_r8, 1.90578e-01_r8, 1.83949e-01_r8, 1.77550e-01_r8, &
     & 1.71373e-01_r8, 1.65412e-01_r8, 1.59658e-01_r8, 1.54104e-01_r8, 1.48743e-01_r8, &
     & 1.43569e-01_r8, 1.38574e-01_r8, 1.33754e-01_r8, 1.29101e-01_r8/)
      kao_mo3( 1, :,16) = (/ &
     & 1.02934e-01_r8, 1.04369e-01_r8, 1.05825e-01_r8, 1.07300e-01_r8, 1.08797e-01_r8, &
     & 1.10314e-01_r8, 1.11852e-01_r8, 1.13412e-01_r8, 1.14993e-01_r8, 1.16597e-01_r8, &
     & 1.18223e-01_r8, 1.19871e-01_r8, 1.21543e-01_r8, 1.23238e-01_r8, 1.24956e-01_r8, &
     & 1.26699e-01_r8, 1.28466e-01_r8, 1.30257e-01_r8, 1.32073e-01_r8/)
      kao_mo3( 2, :,16) = (/ &
     & 1.02934e-01_r8, 1.04369e-01_r8, 1.05825e-01_r8, 1.07300e-01_r8, 1.08797e-01_r8, &
     & 1.10314e-01_r8, 1.11852e-01_r8, 1.13412e-01_r8, 1.14993e-01_r8, 1.16597e-01_r8, &
     & 1.18223e-01_r8, 1.19871e-01_r8, 1.21543e-01_r8, 1.23238e-01_r8, 1.24956e-01_r8, &
     & 1.26699e-01_r8, 1.28466e-01_r8, 1.30257e-01_r8, 1.32073e-01_r8/)
      kao_mo3( 3, :,16) = (/ &
     & 1.02934e-01_r8, 1.04369e-01_r8, 1.05825e-01_r8, 1.07300e-01_r8, 1.08797e-01_r8, &
     & 1.10314e-01_r8, 1.11852e-01_r8, 1.13412e-01_r8, 1.14993e-01_r8, 1.16597e-01_r8, &
     & 1.18223e-01_r8, 1.19871e-01_r8, 1.21543e-01_r8, 1.23238e-01_r8, 1.24956e-01_r8, &
     & 1.26699e-01_r8, 1.28466e-01_r8, 1.30257e-01_r8, 1.32073e-01_r8/)
      kao_mo3( 4, :,16) = (/ &
     & 1.02934e-01_r8, 1.04369e-01_r8, 1.05825e-01_r8, 1.07300e-01_r8, 1.08797e-01_r8, &
     & 1.10314e-01_r8, 1.11852e-01_r8, 1.13412e-01_r8, 1.14993e-01_r8, 1.16597e-01_r8, &
     & 1.18223e-01_r8, 1.19871e-01_r8, 1.21543e-01_r8, 1.23238e-01_r8, 1.24956e-01_r8, &
     & 1.26699e-01_r8, 1.28466e-01_r8, 1.30257e-01_r8, 1.32073e-01_r8/)
      kao_mo3( 5, :,16) = (/ &
     & 1.02934e-01_r8, 1.04369e-01_r8, 1.05825e-01_r8, 1.07300e-01_r8, 1.08797e-01_r8, &
     & 1.10314e-01_r8, 1.11852e-01_r8, 1.13412e-01_r8, 1.14993e-01_r8, 1.16597e-01_r8, &
     & 1.18223e-01_r8, 1.19871e-01_r8, 1.21543e-01_r8, 1.23238e-01_r8, 1.24956e-01_r8, &
     & 1.26699e-01_r8, 1.28466e-01_r8, 1.30257e-01_r8, 1.32073e-01_r8/)
      kao_mo3( 6, :,16) = (/ &
     & 1.02934e-01_r8, 1.04369e-01_r8, 1.05825e-01_r8, 1.07300e-01_r8, 1.08797e-01_r8, &
     & 1.10314e-01_r8, 1.11852e-01_r8, 1.13412e-01_r8, 1.14993e-01_r8, 1.16597e-01_r8, &
     & 1.18223e-01_r8, 1.19871e-01_r8, 1.21543e-01_r8, 1.23238e-01_r8, 1.24956e-01_r8, &
     & 1.26699e-01_r8, 1.28466e-01_r8, 1.30257e-01_r8, 1.32073e-01_r8/)
      kao_mo3( 7, :,16) = (/ &
     & 1.02934e-01_r8, 1.04369e-01_r8, 1.05825e-01_r8, 1.07300e-01_r8, 1.08797e-01_r8, &
     & 1.10314e-01_r8, 1.11852e-01_r8, 1.13412e-01_r8, 1.14993e-01_r8, 1.16597e-01_r8, &
     & 1.18223e-01_r8, 1.19871e-01_r8, 1.21543e-01_r8, 1.23238e-01_r8, 1.24956e-01_r8, &
     & 1.26699e-01_r8, 1.28466e-01_r8, 1.30257e-01_r8, 1.32073e-01_r8/)
      kao_mo3( 8, :,16) = (/ &
     & 1.02934e-01_r8, 1.04369e-01_r8, 1.05825e-01_r8, 1.07300e-01_r8, 1.08797e-01_r8, &
     & 1.10314e-01_r8, 1.11852e-01_r8, 1.13412e-01_r8, 1.14993e-01_r8, 1.16597e-01_r8, &
     & 1.18223e-01_r8, 1.19871e-01_r8, 1.21543e-01_r8, 1.23238e-01_r8, 1.24956e-01_r8, &
     & 1.26699e-01_r8, 1.28466e-01_r8, 1.30257e-01_r8, 1.32073e-01_r8/)
      kao_mo3( 9, :,16) = (/ &
     & 3.91531e-01_r8, 3.78978e-01_r8, 3.66827e-01_r8, 3.55067e-01_r8, 3.43683e-01_r8, &
     & 3.32664e-01_r8, 3.21999e-01_r8, 3.11675e-01_r8, 3.01683e-01_r8, 2.92011e-01_r8, &
     & 2.82648e-01_r8, 2.73586e-01_r8, 2.64815e-01_r8, 2.56325e-01_r8, 2.48107e-01_r8, &
     & 2.40152e-01_r8, 2.32453e-01_r8, 2.25000e-01_r8, 2.17787e-01_r8/)

!     The array FORREFO contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  The first 
!     index refers to reference temperature (296,260,224,260) and 
!     pressure (970,475,219,3 mbar) levels.  The second index 
!     runs over the g-channel (1 to 16).

      forrefo(1,:) = (/ &
     &1.0689e-05_r8,1.6987e-05_r8,1.8993e-05_r8,3.4470e-05_r8,4.0873e-05_r8,4.8275e-05_r8, &
     &6.1178e-05_r8,6.4035e-05_r8,6.6253e-05_r8,7.8914e-05_r8,8.1640e-05_r8,7.9738e-05_r8, &
     &7.8492e-05_r8,9.1565e-05_r8,1.0262e-04_r8,1.0368e-04_r8/)
      forrefo(2,:) = (/ &
     &1.1194e-05_r8,1.6128e-05_r8,1.7213e-05_r8,2.6845e-05_r8,4.1361e-05_r8,5.1508e-05_r8, &
     &6.8245e-05_r8,7.4063e-05_r8,7.6273e-05_r8,8.4061e-05_r8,8.2492e-05_r8,8.1720e-05_r8, &
     &7.7626e-05_r8,1.0096e-04_r8,1.0519e-04_r8,1.0631e-04_r8/)
      forrefo(3,:) = (/ &
     &1.0891e-05_r8,1.4933e-05_r8,1.7964e-05_r8,2.2577e-05_r8,4.4290e-05_r8,5.4675e-05_r8, &
     &7.2494e-05_r8,7.8410e-05_r8,7.6948e-05_r8,7.5742e-05_r8,7.7654e-05_r8,8.2760e-05_r8, &
     &7.8443e-05_r8,9.8384e-05_r8,1.0634e-04_r8,1.0838e-04_r8/)
      forrefo(4,:) = (/ &
     &1.1316e-05_r8,1.5470e-05_r8,2.1246e-05_r8,3.3349e-05_r8,4.8704e-05_r8,5.6424e-05_r8, &
     &5.8569e-05_r8,5.8780e-05_r8,6.0358e-05_r8,6.1586e-05_r8,6.4281e-05_r8,6.9333e-05_r8, &
     &7.2763e-05_r8,7.2675e-05_r8,7.3754e-05_r8,1.0131e-04_r8/)

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      selfrefo(:, 1) = (/ &
     & 1.27686e-01_r8, 1.09347e-01_r8, 9.36410e-02_r8, 8.01912e-02_r8, 6.86732e-02_r8, &
     & 5.88096e-02_r8, 5.03627e-02_r8, 4.31290e-02_r8, 3.69343e-02_r8, 3.16294e-02_r8/)
      selfrefo(:, 2) = (/ &
     & 1.40051e-01_r8, 1.20785e-01_r8, 1.04170e-01_r8, 8.98402e-02_r8, 7.74816e-02_r8, &
     & 6.68231e-02_r8, 5.76308e-02_r8, 4.97030e-02_r8, 4.28658e-02_r8, 3.69691e-02_r8/)
      selfrefo(:, 3) = (/ &
     & 1.42322e-01_r8, 1.22872e-01_r8, 1.06080e-01_r8, 9.15829e-02_r8, 7.90671e-02_r8, &
     & 6.82616e-02_r8, 5.89329e-02_r8, 5.08790e-02_r8, 4.39258e-02_r8, 3.79228e-02_r8/)
      selfrefo(:, 4) = (/ &
     & 1.53244e-01_r8, 1.33057e-01_r8, 1.15530e-01_r8, 1.00311e-01_r8, 8.70977e-02_r8, &
     & 7.56244e-02_r8, 6.56626e-02_r8, 5.70130e-02_r8, 4.95028e-02_r8, 4.29819e-02_r8/)
      selfrefo(:, 5) = (/ &
     & 1.71011e-01_r8, 1.46680e-01_r8, 1.25810e-01_r8, 1.07910e-01_r8, 9.25563e-02_r8, &
     & 7.93874e-02_r8, 6.80922e-02_r8, 5.84040e-02_r8, 5.00943e-02_r8, 4.29669e-02_r8/)
      selfrefo(:, 6) = (/ &
     & 1.76012e-01_r8, 1.51010e-01_r8, 1.29560e-01_r8, 1.11157e-01_r8, 9.53672e-02_r8, &
     & 8.18207e-02_r8, 7.01984e-02_r8, 6.02270e-02_r8, 5.16720e-02_r8, 4.43322e-02_r8/)
      selfrefo(:, 7) = (/ &
     & 1.85600e-01_r8, 1.59051e-01_r8, 1.36300e-01_r8, 1.16803e-01_r8, 1.00095e-01_r8, &
     & 8.57776e-02_r8, 7.35077e-02_r8, 6.29930e-02_r8, 5.39823e-02_r8, 4.62606e-02_r8/)
      selfrefo(:, 8) = (/ &
     & 1.88931e-01_r8, 1.61727e-01_r8, 1.38440e-01_r8, 1.18506e-01_r8, 1.01442e-01_r8, &
     & 8.68356e-02_r8, 7.43321e-02_r8, 6.36290e-02_r8, 5.44670e-02_r8, 4.66243e-02_r8/)
      selfrefo(:, 9) = (/ &
     & 1.91122e-01_r8, 1.63407e-01_r8, 1.39710e-01_r8, 1.19450e-01_r8, 1.02128e-01_r8, &
     & 8.73176e-02_r8, 7.46552e-02_r8, 6.38290e-02_r8, 5.45728e-02_r8, 4.66589e-02_r8/)
      selfrefo(:,10) = (/ &
     & 1.91334e-01_r8, 1.64872e-01_r8, 1.42070e-01_r8, 1.22421e-01_r8, 1.05490e-01_r8, &
     & 9.09008e-02_r8, 7.83291e-02_r8, 6.74960e-02_r8, 5.81612e-02_r8, 5.01174e-02_r8/)
      selfrefo(:,11) = (/ &
     & 1.89858e-01_r8, 1.63934e-01_r8, 1.41550e-01_r8, 1.22222e-01_r8, 1.05534e-01_r8, &
     & 9.11237e-02_r8, 7.86814e-02_r8, 6.79380e-02_r8, 5.86615e-02_r8, 5.06517e-02_r8/)
      selfrefo(:,12) = (/ &
     & 1.89783e-01_r8, 1.63757e-01_r8, 1.41300e-01_r8, 1.21923e-01_r8, 1.05203e-01_r8, &
     & 9.07760e-02_r8, 7.83274e-02_r8, 6.75860e-02_r8, 5.83176e-02_r8, 5.03202e-02_r8/)
      selfrefo(:,13) = (/ &
     & 1.87534e-01_r8, 1.62016e-01_r8, 1.39970e-01_r8, 1.20924e-01_r8, 1.04470e-01_r8, &
     & 9.02541e-02_r8, 7.79730e-02_r8, 6.73630e-02_r8, 5.81967e-02_r8, 5.02778e-02_r8/)
      selfrefo(:,14) = (/ &
     & 1.99128e-01_r8, 1.71410e-01_r8, 1.47550e-01_r8, 1.27011e-01_r8, 1.09332e-01_r8, &
     & 9.41131e-02_r8, 8.10128e-02_r8, 6.97360e-02_r8, 6.00289e-02_r8, 5.16731e-02_r8/)
      selfrefo(:,15) = (/ &
     & 1.99460e-01_r8, 1.72342e-01_r8, 1.48910e-01_r8, 1.28664e-01_r8, 1.11171e-01_r8, &
     & 9.60560e-02_r8, 8.29962e-02_r8, 7.17120e-02_r8, 6.19620e-02_r8, 5.35376e-02_r8/)
      selfrefo(:,16) = (/ &
     & 1.99906e-01_r8, 1.72737e-01_r8, 1.49260e-01_r8, 1.28974e-01_r8, 1.11445e-01_r8, &
     & 9.62982e-02_r8, 8.32102e-02_r8, 7.19010e-02_r8, 6.21288e-02_r8, 5.36848e-02_r8/)

      end subroutine lw_kgb05

