!     path:      $Source: /storm/rc1/cvsroot/rc/rrtmg_lw/src/rrtmg_lw_k_g.f90,v $
!     author:    $Author: mike $
!     revision:  $Revision: 1.2 $
!     created:   $Date: 2007/08/22 19:20:03 $
!
!  --------------------------------------------------------------------------
! |                                                                          |
! |  Copyright 2002-2007, Atmospheric & Environmental Research, Inc. (AER).  |
! |  This software may be used, copied, or redistributed as long as it is    |
! |  not sold and this copyright notice is reproduced on each copy made.     |
! |  This model is provided as is without any express or implied warranties. |
! |                       (http://www.rtweb.aer.com/)                        |
! |                                                                          |
!  --------------------------------------------------------------------------

! **************************************************************************
!      subroutine lw_kgbnn
! **************************************************************************
!  RRTM Longwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original version:   E. J. Mlawer, et al.
!  Revision for GCMs:  Michael J. Iacono; October, 2002
!
!  This file contains 16 subroutines that include the 
!  absorption coefficients and other data for each of the 16 longwave
!  spectral bands used in RRTM.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_LW_INIT to reduce
!  the total number of g-points from 256 to 140 for use in the GCM.
! **************************************************************************
! **************************************************************************
      subroutine lw_kgb04
! **************************************************************************

      use shr_kind_mod, only: r8 => shr_kind_r8

!      use parkind, only : jpim, jprb 
      use rrlw_kg04, only : fracrefao, fracrefbo, kao, kbo, selfrefo, forrefo

      implicit none
      save

! Planck fraction mapping level : P = 142.5940 mbar, T = 215.70 K
      fracrefao(:, 1) = (/ &
     &   1.5572e-01_r8,1.4925e-01_r8,1.4107e-01_r8,1.3126e-01_r8,1.1791e-01_r8,1.0173e-01_r8, &
     &   8.2949e-02_r8,6.2393e-02_r8,4.2146e-02_r8,4.5907e-03_r8,3.7965e-03_r8,2.9744e-03_r8, &
     &   2.2074e-03_r8,1.4063e-03_r8,5.3012e-04_r8,7.4595e-05_r8/)
      fracrefao(:, 2) = (/ &
     &   1.5572e-01_r8,1.4925e-01_r8,1.4107e-01_r8,1.3126e-01_r8,1.1791e-01_r8,1.0173e-01_r8, &
     &   8.2949e-02_r8,6.2392e-02_r8,4.2146e-02_r8,4.5906e-03_r8,3.7965e-03_r8,2.9745e-03_r8, &
     &   2.2074e-03_r8,1.4063e-03_r8,5.3012e-04_r8,7.4595e-05_r8/)
      fracrefao(:, 3) = (/ &
     &   1.5572e-01_r8,1.4925e-01_r8,1.4107e-01_r8,1.3126e-01_r8,1.1791e-01_r8,1.0173e-01_r8, &
     &   8.2949e-02_r8,6.2393e-02_r8,4.2146e-02_r8,4.5907e-03_r8,3.7965e-03_r8,2.9745e-03_r8, &
     &   2.2074e-03_r8,1.4063e-03_r8,5.3012e-04_r8,7.4595e-05_r8/)
      fracrefao(:, 4) = (/ &
     &   1.5572e-01_r8,1.4925e-01_r8,1.4107e-01_r8,1.3126e-01_r8,1.1791e-01_r8,1.0173e-01_r8, &
     &   8.2949e-02_r8,6.2393e-02_r8,4.2146e-02_r8,4.5907e-03_r8,3.7964e-03_r8,2.9744e-03_r8, &
     &   2.2074e-03_r8,1.4063e-03_r8,5.3012e-04_r8,7.4595e-05_r8/)
      fracrefao(:, 5) = (/ &
     &   1.5572e-01_r8,1.4925e-01_r8,1.4107e-01_r8,1.3126e-01_r8,1.1791e-01_r8,1.0173e-01_r8, &
     &   8.2949e-02_r8,6.2393e-02_r8,4.2146e-02_r8,4.5907e-03_r8,3.7965e-03_r8,2.9744e-03_r8, &
     &   2.2074e-03_r8,1.4063e-03_r8,5.3012e-04_r8,7.4595e-05_r8/)
      fracrefao(:, 6) = (/ &
     &   1.5572e-01_r8,1.4925e-01_r8,1.4107e-01_r8,1.3126e-01_r8,1.1791e-01_r8,1.0173e-01_r8, &
     &   8.2949e-02_r8,6.2393e-02_r8,4.2146e-02_r8,4.5907e-03_r8,3.7965e-03_r8,2.9744e-03_r8, &
     &   2.2074e-03_r8,1.4063e-03_r8,5.3012e-04_r8,7.4595e-05_r8/)
      fracrefao(:, 7) = (/ &
     &   1.5572e-01_r8,1.4926e-01_r8,1.4107e-01_r8,1.3126e-01_r8,1.1791e-01_r8,1.0173e-01_r8, &
     &   8.2949e-02_r8,6.2393e-02_r8,4.2146e-02_r8,4.5908e-03_r8,3.7964e-03_r8,2.9745e-03_r8, &
     &   2.2074e-03_r8,1.4063e-03_r8,5.3012e-04_r8,7.4595e-05_r8/)
      fracrefao(:, 8) = (/ &
     &   1.5571e-01_r8,1.4926e-01_r8,1.4107e-01_r8,1.3125e-01_r8,1.1791e-01_r8,1.0173e-01_r8, &
     &   8.2949e-02_r8,6.2393e-02_r8,4.2146e-02_r8,4.5907e-03_r8,3.7964e-03_r8,2.9744e-03_r8, &
     &   2.2074e-03_r8,1.4063e-03_r8,5.3012e-04_r8,7.4595e-05_r8/)
      fracrefao(:, 9) = (/ &
     &   1.5952e-01_r8,1.5155e-01_r8,1.4217e-01_r8,1.3077e-01_r8,1.1667e-01_r8,1.0048e-01_r8, &
     &   8.1511e-02_r8,6.1076e-02_r8,4.1111e-02_r8,4.4432e-03_r8,3.6910e-03_r8,2.9076e-03_r8, &
     &   2.1329e-03_r8,1.3566e-03_r8,5.2235e-04_r8,7.9935e-05_r8/)

! Planck fraction mapping level : P = 95.58350 mb, T = 215.70 K
      fracrefbo(:, 1) = (/ &
     &   1.5558e-01_r8,1.4931e-01_r8,1.4104e-01_r8,1.3124e-01_r8,1.1793e-01_r8,1.0160e-01_r8, &
     &   8.3142e-02_r8,6.2403e-02_r8,4.2170e-02_r8,4.5935e-03_r8,3.7976e-03_r8,2.9986e-03_r8, &
     &   2.1890e-03_r8,1.4061e-03_r8,5.3005e-04_r8,7.4587e-05_r8/)
      fracrefbo(:, 2) = (/ &
     &   1.5558e-01_r8,1.4932e-01_r8,1.4104e-01_r8,1.3124e-01_r8,1.1792e-01_r8,1.0159e-01_r8, &
     &   8.3142e-02_r8,6.2403e-02_r8,4.2170e-02_r8,4.5935e-03_r8,3.7976e-03_r8,2.9986e-03_r8, &
     &   2.1890e-03_r8,1.4061e-03_r8,5.3005e-04_r8,7.4587e-05_r8/)
      fracrefbo(:, 3) = (/ &
     &   1.5558e-01_r8,1.4933e-01_r8,1.4103e-01_r8,1.3124e-01_r8,1.1792e-01_r8,1.0159e-01_r8, &
     &   8.3142e-02_r8,6.2403e-02_r8,4.2170e-02_r8,4.5935e-03_r8,3.7976e-03_r8,2.9986e-03_r8, &
     &   2.1890e-03_r8,1.4061e-03_r8,5.3005e-04_r8,7.4587e-05_r8/)
      fracrefbo(:, 4) = (/ &
     &   1.5569e-01_r8,1.4926e-01_r8,1.4102e-01_r8,1.3122e-01_r8,1.1791e-01_r8,1.0159e-01_r8, &
     &   8.3141e-02_r8,6.2403e-02_r8,4.2170e-02_r8,4.5935e-03_r8,3.7976e-03_r8,2.9986e-03_r8, &
     &   2.1890e-03_r8,1.4061e-03_r8,5.3005e-04_r8,7.4587e-05_r8/)
      fracrefbo(:, 5) = (/ &
     &   1.5947e-01_r8,1.5132e-01_r8,1.4195e-01_r8,1.3061e-01_r8,1.1680e-01_r8,1.0054e-01_r8, &
     &   8.1785e-02_r8,6.1212e-02_r8,4.1276e-02_r8,4.4424e-03_r8,3.6628e-03_r8,2.8943e-03_r8, &
     &   2.1134e-03_r8,1.3457e-03_r8,5.1024e-04_r8,7.3998e-05_r8/)

!     The array KAO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels > ~100mb, temperatures, and ratios
!     of water vapor to CO2.  The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amount ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 
!     to that of gas2.
!     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
!     to different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this  pressure 
!     level, JT = 2 refers to the temperature
!     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the reference pressure level (e.g. JP = 1 is for a
!     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

      kao(:, 1, 1, 1) = (/ &
     &1.0697e-02_r8,1.0151e-02_r8,9.2549e-03_r8,8.2645e-03_r8,7.2061e-03_r8,6.0662e-03_r8, &
     &4.9816e-03_r8,4.8867e-03_r8,2.0269e-04_r8/)
      kao(:, 2, 1, 1) = (/ &
     &1.1677e-02_r8,1.1138e-02_r8,1.0216e-02_r8,9.1909e-03_r8,8.0553e-03_r8,6.8223e-03_r8, &
     &5.5408e-03_r8,4.6854e-03_r8,2.3825e-04_r8/)
      kao(:, 3, 1, 1) = (/ &
     &1.2605e-02_r8,1.2092e-02_r8,1.1179e-02_r8,1.0121e-02_r8,8.9159e-03_r8,7.6027e-03_r8, &
     &6.0392e-03_r8,4.3498e-03_r8,2.8245e-04_r8/)
      kao(:, 4, 1, 1) = (/ &
     &1.3484e-02_r8,1.3046e-02_r8,1.2153e-02_r8,1.1041e-02_r8,9.7806e-03_r8,8.2921e-03_r8, &
     &6.5023e-03_r8,4.3023e-03_r8,3.0318e-04_r8/)
      kao(:, 5, 1, 1) = (/ &
     &1.4330e-02_r8,1.3997e-02_r8,1.3114e-02_r8,1.1943e-02_r8,1.0557e-02_r8,8.8567e-03_r8, &
     &6.8709e-03_r8,4.3577e-03_r8,3.2751e-04_r8/)
      kao(:, 1, 2, 1) = (/ &
     &1.3833e-02_r8,1.2806e-02_r8,1.1465e-02_r8,1.0025e-02_r8,8.5208e-03_r8,6.9589e-03_r8, &
     &5.3336e-03_r8,4.2294e-03_r8,1.4419e-04_r8/)
      kao(:, 2, 2, 1) = (/ &
     &1.5144e-02_r8,1.4068e-02_r8,1.2644e-02_r8,1.1119e-02_r8,9.5204e-03_r8,7.8236e-03_r8, &
     &6.0220e-03_r8,4.4086e-03_r8,1.7355e-04_r8/)
      kao(:, 3, 2, 1) = (/ &
     &1.6397e-02_r8,1.5299e-02_r8,1.3819e-02_r8,1.2230e-02_r8,1.0525e-02_r8,8.6894e-03_r8, &
     &6.7322e-03_r8,4.5883e-03_r8,2.1022e-04_r8/)
      kao(:, 4, 2, 1) = (/ &
     &1.7608e-02_r8,1.6518e-02_r8,1.5010e-02_r8,1.3349e-02_r8,1.1524e-02_r8,9.5665e-03_r8, &
     &7.3586e-03_r8,4.7702e-03_r8,2.1845e-04_r8/)
      kao(:, 5, 2, 1) = (/ &
     &1.8795e-02_r8,1.7739e-02_r8,1.6211e-02_r8,1.4458e-02_r8,1.2504e-02_r8,1.0367e-02_r8, &
     &7.8746e-03_r8,4.9505e-03_r8,2.4452e-04_r8/)
      kao(:, 1, 3, 1) = (/ &
     &2.3349e-02_r8,2.1073e-02_r8,1.8534e-02_r8,1.5886e-02_r8,1.3154e-02_r8,1.0346e-02_r8, &
     &7.4749e-03_r8,4.5440e-03_r8,9.5522e-05_r8/)
      kao(:, 2, 3, 1) = (/ &
     &2.5718e-02_r8,2.3272e-02_r8,2.0503e-02_r8,1.7622e-02_r8,1.4648e-02_r8,1.1596e-02_r8, &
     &8.4531e-03_r8,5.1652e-03_r8,1.1957e-04_r8/)
      kao(:, 3, 3, 1) = (/ &
     &2.8025e-02_r8,2.5421e-02_r8,2.2452e-02_r8,1.9353e-02_r8,1.6163e-02_r8,1.2876e-02_r8, &
     &9.4440e-03_r8,5.8151e-03_r8,1.4638e-04_r8/)
      kao(:, 4, 3, 1) = (/ &
     &3.0273e-02_r8,2.7542e-02_r8,2.4400e-02_r8,2.1110e-02_r8,1.7713e-02_r8,1.4169e-02_r8, &
     &1.0445e-02_r8,6.4078e-03_r8,1.5375e-04_r8/)
      kao(:, 5, 3, 1) = (/ &
     &3.2488e-02_r8,2.9668e-02_r8,2.6366e-02_r8,2.2912e-02_r8,1.9285e-02_r8,1.5463e-02_r8, &
     &1.1411e-02_r8,6.9035e-03_r8,1.7414e-04_r8/)
      kao(:, 1, 4, 1) = (/ &
     &3.9680e-02_r8,3.5246e-02_r8,3.0687e-02_r8,2.5989e-02_r8,2.1199e-02_r8,1.6340e-02_r8, &
     &1.1394e-02_r8,6.3232e-03_r8,6.3142e-05_r8/)
      kao(:, 2, 4, 1) = (/ &
     &4.4067e-02_r8,3.9245e-02_r8,3.4186e-02_r8,2.8983e-02_r8,2.3690e-02_r8,1.8315e-02_r8, &
     &1.2835e-02_r8,7.2156e-03_r8,8.2154e-05_r8/)
      kao(:, 3, 4, 1) = (/ &
     &4.8382e-02_r8,4.3189e-02_r8,3.7634e-02_r8,3.1955e-02_r8,2.6184e-02_r8,2.0317e-02_r8, &
     &1.4329e-02_r8,8.1343e-03_r8,1.0015e-04_r8/)
      kao(:, 4, 4, 1) = (/ &
     &5.2631e-02_r8,4.7051e-02_r8,4.1069e-02_r8,3.4945e-02_r8,2.8716e-02_r8,2.2361e-02_r8, &
     &1.5856e-02_r8,9.0735e-03_r8,1.0763e-04_r8/)
      kao(:, 5, 4, 1) = (/ &
     &5.6812e-02_r8,5.0879e-02_r8,4.4486e-02_r8,3.7949e-02_r8,3.1266e-02_r8,2.4439e-02_r8, &
     &1.7397e-02_r8,9.9865e-03_r8,1.2433e-04_r8/)
      kao(:, 1, 5, 1) = (/ &
     &6.1659e-02_r8,5.4360e-02_r8,4.7000e-02_r8,3.9571e-02_r8,3.2046e-02_r8,2.4431e-02_r8, &
     &1.6731e-02_r8,8.9002e-03_r8,4.4135e-05_r8/)
      kao(:, 2, 5, 1) = (/ &
     &6.9177e-02_r8,6.1077e-02_r8,5.2885e-02_r8,4.4540e-02_r8,3.6083e-02_r8,2.7553e-02_r8, &
     &1.8920e-02_r8,1.0138e-02_r8,5.7278e-05_r8/)
      kao(:, 3, 5, 1) = (/ &
     &7.6561e-02_r8,6.7721e-02_r8,5.8676e-02_r8,4.9436e-02_r8,4.0109e-02_r8,3.0675e-02_r8, &
     &2.1149e-02_r8,1.1429e-02_r8,6.8177e-05_r8/)
      kao(:, 4, 5, 1) = (/ &
     &8.3855e-02_r8,7.4287e-02_r8,6.4398e-02_r8,5.4317e-02_r8,4.4139e-02_r8,3.3855e-02_r8, &
     &2.3434e-02_r8,1.2758e-02_r8,7.5655e-05_r8/)
      kao(:, 5, 5, 1) = (/ &
     &9.1112e-02_r8,8.0836e-02_r8,7.0093e-02_r8,5.9205e-02_r8,4.8195e-02_r8,3.7076e-02_r8, &
     &2.5757e-02_r8,1.4110e-02_r8,8.9921e-05_r8/)
      kao(:, 1, 6, 1) = (/ &
     &8.8882e-02_r8,7.8094e-02_r8,6.7257e-02_r8,5.6376e-02_r8,4.5468e-02_r8,3.4471e-02_r8, &
     &2.3372e-02_r8,1.2141e-02_r8,3.4008e-05_r8/)
      kao(:, 2, 6, 1) = (/ &
     &1.0088e-01_r8,8.8690e-02_r8,7.6454e-02_r8,6.4166e-02_r8,5.1764e-02_r8,3.9256e-02_r8, &
     &2.6651e-02_r8,1.3906e-02_r8,4.1496e-05_r8/)
      kao(:, 3, 6, 1) = (/ &
     &1.1268e-01_r8,9.9170e-02_r8,8.5584e-02_r8,7.1867e-02_r8,5.7997e-02_r8,4.4019e-02_r8, &
     &2.9951e-02_r8,1.5714e-02_r8,4.7587e-05_r8/)
      kao(:, 4, 6, 1) = (/ &
     &1.2443e-01_r8,1.0961e-01_r8,9.4686e-02_r8,7.9524e-02_r8,6.4216e-02_r8,4.8825e-02_r8, &
     &3.3307e-02_r8,1.7586e-02_r8,5.4734e-05_r8/)
      kao(:, 5, 6, 1) = (/ &
     &1.3608e-01_r8,1.2003e-01_r8,1.0372e-01_r8,8.7155e-02_r8,7.0466e-02_r8,5.3660e-02_r8, &
     &3.6716e-02_r8,1.9490e-02_r8,6.4532e-05_r8/)
      kao(:, 1, 7, 1) = (/ &
     &1.3393e-01_r8,1.1743e-01_r8,1.0091e-01_r8,8.4366e-02_r8,6.7796e-02_r8,5.1191e-02_r8, &
     &3.4487e-02_r8,1.7647e-02_r8,2.6258e-05_r8/)
      kao(:, 2, 7, 1) = (/ &
     &1.5385e-01_r8,1.3496e-01_r8,1.1603e-01_r8,9.7081e-02_r8,7.8079e-02_r8,5.8981e-02_r8, &
     &3.9763e-02_r8,2.0387e-02_r8,3.2089e-05_r8/)
      kao(:, 3, 7, 1) = (/ &
     &1.7362e-01_r8,1.5237e-01_r8,1.3107e-01_r8,1.0975e-01_r8,8.8299e-02_r8,6.6730e-02_r8, &
     &4.5023e-02_r8,2.3161e-02_r8,4.0067e-05_r8/)
      kao(:, 4, 7, 1) = (/ &
     &1.9325e-01_r8,1.6971e-01_r8,1.4609e-01_r8,1.2238e-01_r8,9.8509e-02_r8,7.4481e-02_r8, &
     &5.0334e-02_r8,2.5995e-02_r8,4.6630e-05_r8/)
      kao(:, 5, 7, 1) = (/ &
     &2.1303e-01_r8,1.8717e-01_r8,1.6126e-01_r8,1.3511e-01_r8,1.0879e-01_r8,8.2319e-02_r8, &
     &5.5720e-02_r8,2.8900e-02_r8,5.5874e-05_r8/)
      kao(:, 1, 8, 1) = (/ &
     &2.4085e-01_r8,2.1093e-01_r8,1.8102e-01_r8,1.5107e-01_r8,1.2112e-01_r8,9.1137e-02_r8, &
     &6.1112e-02_r8,3.0964e-02_r8,2.6704e-05_r8/)
      kao(:, 2, 8, 1) = (/ &
     &2.8040e-01_r8,2.4563e-01_r8,2.1082e-01_r8,1.7598e-01_r8,1.4114e-01_r8,1.0627e-01_r8, &
     &7.1313e-02_r8,3.6159e-02_r8,3.4463e-05_r8/)
      kao(:, 3, 8, 1) = (/ &
     &3.1986e-01_r8,2.8024e-01_r8,2.4058e-01_r8,2.0091e-01_r8,1.6119e-01_r8,1.2143e-01_r8, &
     &8.1504e-02_r8,4.1377e-02_r8,4.2885e-05_r8/)
      kao(:, 4, 8, 1) = (/ &
     &3.5910e-01_r8,3.1468e-01_r8,2.7026e-01_r8,2.2578e-01_r8,1.8126e-01_r8,1.3658e-01_r8, &
     &9.1734e-02_r8,4.6641e-02_r8,5.1508e-05_r8/)
      kao(:, 5, 8, 1) = (/ &
     &3.9881e-01_r8,3.4958e-01_r8,3.0035e-01_r8,2.5107e-01_r8,2.0163e-01_r8,1.5198e-01_r8, &
     &1.0212e-01_r8,5.2034e-02_r8,5.9872e-05_r8/)
      kao(:, 1, 9, 1) = (/ &
     &8.1251e-01_r8,7.1113e-01_r8,6.0978e-01_r8,5.0834e-01_r8,4.0692e-01_r8,3.0549e-01_r8, &
     &2.0401e-01_r8,1.0247e-01_r8,4.2060e-05_r8/)
      kao(:, 2, 9, 1) = (/ &
     &9.6024e-01_r8,8.4039e-01_r8,7.2060e-01_r8,6.0079e-01_r8,4.8095e-01_r8,3.6106e-01_r8, &
     &2.4120e-01_r8,1.2123e-01_r8,5.7363e-05_r8/)
      kao(:, 3, 9, 1) = (/ &
     &1.1088e+00_r8,9.7056e-01_r8,8.3222e-01_r8,6.9393e-01_r8,5.5555e-01_r8,4.1720e-01_r8, &
     &2.7875e-01_r8,1.4021e-01_r8,7.4113e-05_r8/)
      kao(:, 4, 9, 1) = (/ &
     &1.2568e+00_r8,1.1001e+00_r8,9.4342e-01_r8,7.8665e-01_r8,6.2985e-01_r8,4.7311e-01_r8, &
     &3.1630e-01_r8,1.5915e-01_r8,9.2862e-05_r8/)
      kao(:, 5, 9, 1) = (/ &
     &1.4062e+00_r8,1.2309e+00_r8,1.0557e+00_r8,8.8039e-01_r8,7.0513e-01_r8,5.2977e-01_r8, &
     &3.5432e-01_r8,1.7839e-01_r8,1.0954e-04_r8/)
      kao(:, 1,10, 1) = (/ &
     &3.0868e+00_r8,2.7010e+00_r8,2.3154e+00_r8,1.9296e+00_r8,1.5440e+00_r8,1.1583e+00_r8, &
     &7.7257e-01_r8,3.8682e-01_r8,7.9650e-05_r8/)
      kao(:, 2,10, 1) = (/ &
     &3.6992e+00_r8,3.2371e+00_r8,2.7749e+00_r8,2.3126e+00_r8,1.8504e+00_r8,1.3883e+00_r8, &
     &9.2595e-01_r8,4.6361e-01_r8,1.1315e-04_r8/)
      kao(:, 3,10, 1) = (/ &
     &4.3239e+00_r8,3.7838e+00_r8,3.2436e+00_r8,2.7034e+00_r8,2.1630e+00_r8,1.6228e+00_r8, &
     &1.0824e+00_r8,5.4204e-01_r8,1.4419e-04_r8/)
      kao(:, 4,10, 1) = (/ &
     &4.9483e+00_r8,4.3302e+00_r8,3.7121e+00_r8,3.0937e+00_r8,2.4754e+00_r8,1.8572e+00_r8, &
     &1.2389e+00_r8,6.2062e-01_r8,1.7752e-04_r8/)
      kao(:, 5,10, 1) = (/ &
     &5.5745e+00_r8,4.8780e+00_r8,4.1816e+00_r8,3.4855e+00_r8,2.7890e+00_r8,2.0926e+00_r8, &
     &1.3962e+00_r8,6.9963e-01_r8,2.1449e-04_r8/)
      kao(:, 1,11, 1) = (/ &
     &4.4731e+00_r8,3.9138e+00_r8,3.3549e+00_r8,2.7960e+00_r8,2.2371e+00_r8,1.6781e+00_r8, &
     &1.1191e+00_r8,5.6013e-01_r8,1.1739e-04_r8/)
      kao(:, 2,11, 1) = (/ &
     &5.3673e+00_r8,4.6967e+00_r8,4.0260e+00_r8,3.3552e+00_r8,2.6847e+00_r8,2.0138e+00_r8, &
     &1.3431e+00_r8,6.7224e-01_r8,1.4272e-04_r8/)
      kao(:, 3,11, 1) = (/ &
     &6.2805e+00_r8,5.4954e+00_r8,4.7109e+00_r8,3.9260e+00_r8,3.1412e+00_r8,2.3563e+00_r8, &
     &1.5716e+00_r8,7.8663e-01_r8,1.8731e-04_r8/)
      kao(:, 4,11, 1) = (/ &
     &7.1941e+00_r8,6.2951e+00_r8,5.3963e+00_r8,4.4973e+00_r8,3.5984e+00_r8,2.6993e+00_r8, &
     &1.8005e+00_r8,9.0138e-01_r8,2.2429e-04_r8/)
      kao(:, 5,11, 1) = (/ &
     &8.1084e+00_r8,7.0952e+00_r8,6.0822e+00_r8,5.0692e+00_r8,4.0560e+00_r8,3.0428e+00_r8, &
     &2.0297e+00_r8,1.0163e+00_r8,2.6588e-04_r8/)
      kao(:, 1,12, 1) = (/ &
     &4.8324e+00_r8,4.2285e+00_r8,3.6244e+00_r8,3.0205e+00_r8,2.4167e+00_r8,1.8130e+00_r8, &
     &1.2091e+00_r8,6.0509e-01_r8,1.2228e-04_r8/)
      kao(:, 2,12, 1) = (/ &
     &5.8007e+00_r8,5.0761e+00_r8,4.3512e+00_r8,3.6264e+00_r8,2.9012e+00_r8,2.1763e+00_r8, &
     &1.4515e+00_r8,7.2651e-01_r8,1.6183e-04_r8/)
      kao(:, 3,12, 1) = (/ &
     &6.7955e+00_r8,5.9463e+00_r8,5.0972e+00_r8,4.2481e+00_r8,3.3989e+00_r8,2.5498e+00_r8, &
     &1.7005e+00_r8,8.5109e-01_r8,1.9622e-04_r8/)
      kao(:, 4,12, 1) = (/ &
     &7.7871e+00_r8,6.8141e+00_r8,5.8412e+00_r8,4.8680e+00_r8,3.8949e+00_r8,2.9218e+00_r8, &
     &1.9487e+00_r8,9.7554e-01_r8,2.4527e-04_r8/)
      kao(:, 5,12, 1) = (/ &
     &8.7731e+00_r8,7.6770e+00_r8,6.5805e+00_r8,5.4843e+00_r8,4.3883e+00_r8,3.2921e+00_r8, &
     &2.1959e+00_r8,1.0994e+00_r8,2.9421e-04_r8/)
      kao(:, 1,13, 1) = (/ &
     &4.1936e+00_r8,3.6695e+00_r8,3.1456e+00_r8,2.6217e+00_r8,2.0976e+00_r8,1.5735e+00_r8, &
     &1.0495e+00_r8,5.2527e-01_r8,1.1808e-04_r8/)
      kao(:, 2,13, 1) = (/ &
     &5.0398e+00_r8,4.4101e+00_r8,3.7804e+00_r8,3.1506e+00_r8,2.5209e+00_r8,1.8912e+00_r8, &
     &1.2614e+00_r8,6.3136e-01_r8,1.5519e-04_r8/)
      kao(:, 3,13, 1) = (/ &
     &5.9030e+00_r8,5.1655e+00_r8,4.4278e+00_r8,3.6903e+00_r8,2.9527e+00_r8,2.2152e+00_r8, &
     &1.4774e+00_r8,7.3950e-01_r8,1.9283e-04_r8/)
      kao(:, 4,13, 1) = (/ &
     &6.7598e+00_r8,5.9151e+00_r8,5.0706e+00_r8,4.2260e+00_r8,3.3815e+00_r8,2.5368e+00_r8, &
     &1.6919e+00_r8,8.4706e-01_r8,2.3479e-04_r8/)
      kao(:, 5,13, 1) = (/ &
     &7.6160e+00_r8,6.6645e+00_r8,5.7130e+00_r8,4.7615e+00_r8,3.8100e+00_r8,2.8583e+00_r8, &
     &1.9066e+00_r8,9.5472e-01_r8,2.9034e-04_r8/)
      kao(:, 1, 1, 2) = (/ &
     &2.4501e-02_r8,2.2546e-02_r8,2.0206e-02_r8,1.7580e-02_r8,1.4733e-02_r8,1.1757e-02_r8, &
     &8.5871e-03_r8,4.9715e-03_r8,4.1358e-04_r8/)
      kao(:, 2, 1, 2) = (/ &
     &2.5392e-02_r8,2.3504e-02_r8,2.1061e-02_r8,1.8282e-02_r8,1.5340e-02_r8,1.2238e-02_r8, &
     &8.8921e-03_r8,5.1114e-03_r8,3.8966e-04_r8/)
      kao(:, 3, 1, 2) = (/ &
     &2.6027e-02_r8,2.4221e-02_r8,2.1673e-02_r8,1.8830e-02_r8,1.5807e-02_r8,1.2525e-02_r8, &
     &9.1668e-03_r8,5.5997e-03_r8,3.7711e-04_r8/)
      kao(:, 4, 1, 2) = (/ &
     &2.6673e-02_r8,2.4919e-02_r8,2.2282e-02_r8,1.9349e-02_r8,1.6139e-02_r8,1.2835e-02_r8, &
     &9.4247e-03_r8,5.9143e-03_r8,4.3807e-04_r8/)
      kao(:, 5, 1, 2) = (/ &
     &2.7193e-02_r8,2.5447e-02_r8,2.2733e-02_r8,1.9712e-02_r8,1.6469e-02_r8,1.3190e-02_r8, &
     &9.7078e-03_r8,6.2746e-03_r8,5.1500e-04_r8/)
      kao(:, 1, 2, 2) = (/ &
     &3.1935e-02_r8,2.8971e-02_r8,2.5689e-02_r8,2.2139e-02_r8,1.8357e-02_r8,1.4398e-02_r8, &
     &1.0314e-02_r8,5.7860e-03_r8,2.7704e-04_r8/)
      kao(:, 2, 2, 2) = (/ &
     &3.3322e-02_r8,3.0388e-02_r8,2.6935e-02_r8,2.3180e-02_r8,1.9196e-02_r8,1.5076e-02_r8, &
     &1.0778e-02_r8,6.0195e-03_r8,2.7933e-04_r8/)
      kao(:, 3, 2, 2) = (/ &
     &3.4372e-02_r8,3.1484e-02_r8,2.7888e-02_r8,2.3966e-02_r8,1.9860e-02_r8,1.5585e-02_r8, &
     &1.1079e-02_r8,6.3448e-03_r8,2.7118e-04_r8/)
      kao(:, 4, 2, 2) = (/ &
     &3.5247e-02_r8,3.2382e-02_r8,2.8654e-02_r8,2.4627e-02_r8,2.0404e-02_r8,1.5949e-02_r8, &
     &1.1392e-02_r8,6.6539e-03_r8,3.3360e-04_r8/)
      kao(:, 5, 2, 2) = (/ &
     &3.6022e-02_r8,3.3132e-02_r8,2.9304e-02_r8,2.5200e-02_r8,2.0861e-02_r8,1.6331e-02_r8, &
     &1.1785e-02_r8,6.9927e-03_r8,3.9477e-04_r8/)
      kao(:, 1, 3, 2) = (/ &
     &5.5981e-02_r8,4.9895e-02_r8,4.3680e-02_r8,3.7190e-02_r8,3.0485e-02_r8,2.3562e-02_r8, &
     &1.6425e-02_r8,9.0449e-03_r8,1.7015e-04_r8/)
      kao(:, 2, 3, 2) = (/ &
     &5.8799e-02_r8,5.2631e-02_r8,4.6091e-02_r8,3.9226e-02_r8,3.2137e-02_r8,2.4836e-02_r8, &
     &1.7301e-02_r8,9.5109e-03_r8,1.8305e-04_r8/)
      kao(:, 3, 3, 2) = (/ &
     &6.0996e-02_r8,5.4813e-02_r8,4.8006e-02_r8,4.0820e-02_r8,3.3414e-02_r8,2.5787e-02_r8, &
     &1.7985e-02_r8,9.8187e-03_r8,1.8905e-04_r8/)
      kao(:, 4, 3, 2) = (/ &
     &6.2707e-02_r8,5.6481e-02_r8,4.9388e-02_r8,4.1983e-02_r8,3.4344e-02_r8,2.6526e-02_r8, &
     &1.8461e-02_r8,1.0117e-02_r8,2.4096e-04_r8/)
      kao(:, 5, 3, 2) = (/ &
     &6.4195e-02_r8,5.7890e-02_r8,5.0593e-02_r8,4.2977e-02_r8,3.5166e-02_r8,2.7170e-02_r8, &
     &1.8910e-02_r8,1.0511e-02_r8,2.9172e-04_r8/)
      kao(:, 1, 4, 2) = (/ &
     &1.0046e-01_r8,8.8696e-02_r8,7.6950e-02_r8,6.5010e-02_r8,5.2854e-02_r8,4.0445e-02_r8, &
     &2.7753e-02_r8,1.4715e-02_r8,1.1527e-04_r8/)
      kao(:, 2, 4, 2) = (/ &
     &1.0584e-01_r8,9.3644e-02_r8,8.1343e-02_r8,6.8725e-02_r8,5.5817e-02_r8,4.2663e-02_r8, &
     &2.9258e-02_r8,1.5519e-02_r8,1.2102e-04_r8/)
      kao(:, 3, 4, 2) = (/ &
     &1.1041e-01_r8,9.7926e-02_r8,8.5123e-02_r8,7.1882e-02_r8,5.8341e-02_r8,4.4558e-02_r8, &
     &3.0554e-02_r8,1.6224e-02_r8,1.3450e-04_r8/)
      kao(:, 4, 4, 2) = (/ &
     &1.1403e-01_r8,1.0136e-01_r8,8.8078e-02_r8,7.4319e-02_r8,6.0266e-02_r8,4.6028e-02_r8, &
     &3.1549e-02_r8,1.6730e-02_r8,1.7483e-04_r8/)
      kao(:, 5, 4, 2) = (/ &
     &1.1675e-01_r8,1.0391e-01_r8,9.0226e-02_r8,7.6062e-02_r8,6.1699e-02_r8,4.7119e-02_r8, &
     &3.2315e-02_r8,1.7160e-02_r8,2.1415e-04_r8/)
      kao(:, 1, 5, 2) = (/ &
     &1.6440e-01_r8,1.4448e-01_r8,1.2464e-01_r8,1.0475e-01_r8,8.4706e-02_r8,6.4458e-02_r8, &
     &4.3883e-02_r8,2.2824e-02_r8,7.5213e-05_r8/)
      kao(:, 2, 5, 2) = (/ &
     &1.7418e-01_r8,1.5330e-01_r8,1.3243e-01_r8,1.1140e-01_r8,9.0109e-02_r8,6.8519e-02_r8, &
     &4.6576e-02_r8,2.4202e-02_r8,8.0510e-05_r8/)
      kao(:, 3, 5, 2) = (/ &
     &1.8254e-01_r8,1.6088e-01_r8,1.3912e-01_r8,1.1702e-01_r8,9.4586e-02_r8,7.1837e-02_r8, &
     &4.8767e-02_r8,2.5350e-02_r8,9.6196e-05_r8/)
      kao(:, 4, 5, 2) = (/ &
     &1.8937e-01_r8,1.6713e-01_r8,1.4454e-01_r8,1.2155e-01_r8,9.8195e-02_r8,7.4514e-02_r8, &
     &5.0569e-02_r8,2.6308e-02_r8,1.2696e-04_r8/)
      kao(:, 5, 5, 2) = (/ &
     &1.9452e-01_r8,1.7183e-01_r8,1.4864e-01_r8,1.2495e-01_r8,1.0086e-01_r8,7.6520e-02_r8, &
     &5.1964e-02_r8,2.7040e-02_r8,1.5611e-04_r8/)
      kao(:, 1, 6, 2) = (/ &
     &2.4921e-01_r8,2.1859e-01_r8,1.8798e-01_r8,1.5740e-01_r8,1.2679e-01_r8,9.6030e-02_r8, &
     &6.5011e-02_r8,3.3513e-02_r8,4.7816e-05_r8/)
      kao(:, 2, 6, 2) = (/ &
     &2.6657e-01_r8,2.3398e-01_r8,2.0147e-01_r8,1.6890e-01_r8,1.3619e-01_r8,1.0322e-01_r8, &
     &6.9866e-02_r8,3.5915e-02_r8,5.5771e-05_r8/)
      kao(:, 3, 6, 2) = (/ &
     &2.8078e-01_r8,2.4667e-01_r8,2.1258e-01_r8,1.7831e-01_r8,1.4376e-01_r8,1.0887e-01_r8, &
     &7.3553e-02_r8,3.7752e-02_r8,7.2324e-05_r8/)
      kao(:, 4, 6, 2) = (/ &
     &2.9281e-01_r8,2.5752e-01_r8,2.2202e-01_r8,1.8622e-01_r8,1.5008e-01_r8,1.1356e-01_r8, &
     &7.6693e-02_r8,3.9339e-02_r8,9.1831e-05_r8/)
      kao(:, 5, 6, 2) = (/ &
     &3.0221e-01_r8,2.6598e-01_r8,2.2929e-01_r8,1.9231e-01_r8,1.5490e-01_r8,1.1717e-01_r8, &
     &7.9072e-02_r8,4.0614e-02_r8,1.1670e-04_r8/)
      kao(:, 1, 7, 2) = (/ &
     &3.9471e-01_r8,3.4576e-01_r8,2.9687e-01_r8,2.4797e-01_r8,1.9909e-01_r8,1.5016e-01_r8, &
     &1.0112e-01_r8,5.1719e-02_r8,4.5280e-05_r8/)
      kao(:, 2, 7, 2) = (/ &
     &4.2660e-01_r8,3.7391e-01_r8,3.2118e-01_r8,2.6853e-01_r8,2.1577e-01_r8,1.6297e-01_r8, &
     &1.0986e-01_r8,5.6145e-02_r8,5.4459e-05_r8/)
      kao(:, 3, 7, 2) = (/ &
     &4.5301e-01_r8,3.9723e-01_r8,3.4149e-01_r8,2.8568e-01_r8,2.2975e-01_r8,1.7359e-01_r8, &
     &1.1695e-01_r8,5.9583e-02_r8,6.4819e-05_r8/)
      kao(:, 4, 7, 2) = (/ &
     &4.7467e-01_r8,4.1649e-01_r8,3.5820e-01_r8,2.9973e-01_r8,2.4109e-01_r8,1.8208e-01_r8, &
     &1.2251e-01_r8,6.2380e-02_r8,7.8660e-05_r8/)
      kao(:, 5, 7, 2) = (/ &
     &4.9199e-01_r8,4.3192e-01_r8,3.7144e-01_r8,3.1090e-01_r8,2.5000e-01_r8,1.8865e-01_r8, &
     &1.2686e-01_r8,6.4563e-02_r8,9.4184e-05_r8/)
      kao(:, 1, 8, 2) = (/ &
     &7.4598e-01_r8,6.5300e-01_r8,5.6009e-01_r8,4.6718e-01_r8,3.7433e-01_r8,2.8142e-01_r8, &
     &1.8848e-01_r8,9.5403e-02_r8,4.9176e-05_r8/)
      kao(:, 2, 8, 2) = (/ &
     &8.1434e-01_r8,7.1301e-01_r8,6.1173e-01_r8,5.1044e-01_r8,4.0917e-01_r8,3.0788e-01_r8, &
     &2.0653e-01_r8,1.0477e-01_r8,6.1468e-05_r8/)
      kao(:, 3, 8, 2) = (/ &
     &8.7268e-01_r8,7.6440e-01_r8,6.5604e-01_r8,5.4759e-01_r8,4.3920e-01_r8,3.3065e-01_r8, &
     &2.2200e-01_r8,1.1269e-01_r8,7.5902e-05_r8/)
      kao(:, 4, 8, 2) = (/ &
     &9.2025e-01_r8,8.0619e-01_r8,6.9208e-01_r8,5.7794e-01_r8,4.6363e-01_r8,3.4928e-01_r8, &
     &2.3455e-01_r8,1.1876e-01_r8,9.2466e-05_r8/)
      kao(:, 5, 8, 2) = (/ &
     &9.5892e-01_r8,8.4025e-01_r8,7.2136e-01_r8,6.0245e-01_r8,4.8344e-01_r8,3.6420e-01_r8, &
     &2.4431e-01_r8,1.2353e-01_r8,1.1186e-04_r8/)
      kao(:, 1, 9, 2) = (/ &
     &2.6457e+00_r8,2.3152e+00_r8,1.9846e+00_r8,1.6541e+00_r8,1.3236e+00_r8,9.9317e-01_r8, &
     &6.6276e-01_r8,3.3240e-01_r8,8.9892e-05_r8/)
      kao(:, 2, 9, 2) = (/ &
     &2.9186e+00_r8,2.5541e+00_r8,2.1896e+00_r8,1.8252e+00_r8,1.4607e+00_r8,1.0963e+00_r8, &
     &7.3190e-01_r8,3.6751e-01_r8,1.0914e-04_r8/)
      kao(:, 3, 9, 2) = (/ &
     &3.1587e+00_r8,2.7643e+00_r8,2.3700e+00_r8,1.9759e+00_r8,1.5816e+00_r8,1.1873e+00_r8, &
     &7.9301e-01_r8,3.9869e-01_r8,1.2624e-04_r8/)
      kao(:, 4, 9, 2) = (/ &
     &3.3556e+00_r8,2.9370e+00_r8,2.5183e+00_r8,2.0996e+00_r8,1.6808e+00_r8,1.2622e+00_r8, &
     &8.4339e-01_r8,4.2436e-01_r8,1.5596e-04_r8/)
      kao(:, 5, 9, 2) = (/ &
     &3.5177e+00_r8,3.0788e+00_r8,2.6401e+00_r8,2.2013e+00_r8,1.7625e+00_r8,1.3234e+00_r8, &
     &8.8445e-01_r8,4.4528e-01_r8,1.9369e-04_r8/)
      kao(:, 1,10, 2) = (/ &
     &1.0501e+01_r8,9.1884e+00_r8,7.8763e+00_r8,6.5637e+00_r8,5.2509e+00_r8,3.9387e+00_r8, &
     &2.6260e+00_r8,1.3137e+00_r8,1.7951e-04_r8/)
      kao(:, 2,10, 2) = (/ &
     &1.1694e+01_r8,1.0233e+01_r8,8.7714e+00_r8,7.3095e+00_r8,5.8477e+00_r8,4.3863e+00_r8, &
     &2.9249e+00_r8,1.4636e+00_r8,2.1880e-04_r8/)
      kao(:, 3,10, 2) = (/ &
     &1.2771e+01_r8,1.1175e+01_r8,9.5787e+00_r8,7.9832e+00_r8,6.3867e+00_r8,4.7910e+00_r8, &
     &3.1952e+00_r8,1.5993e+00_r8,2.5504e-04_r8/)
      kao(:, 4,10, 2) = (/ &
     &1.3661e+01_r8,1.1954e+01_r8,1.0247e+01_r8,8.5403e+00_r8,6.8331e+00_r8,5.1260e+00_r8, &
     &3.4191e+00_r8,1.7121e+00_r8,3.1556e-04_r8/)
      kao(:, 5,10, 2) = (/ &
     &1.4403e+01_r8,1.2603e+01_r8,1.0804e+01_r8,9.0041e+00_r8,7.2046e+00_r8,5.4047e+00_r8, &
     &3.6050e+00_r8,1.8055e+00_r8,3.5095e-04_r8/)
      kao(:, 1,11, 2) = (/ &
     &1.5305e+01_r8,1.3391e+01_r8,1.1479e+01_r8,9.5654e+00_r8,7.6527e+00_r8,5.7399e+00_r8, &
     &3.8269e+00_r8,1.9139e+00_r8,2.5263e-04_r8/)
      kao(:, 2,11, 2) = (/ &
     &1.7053e+01_r8,1.4921e+01_r8,1.2790e+01_r8,1.0658e+01_r8,8.5272e+00_r8,6.3954e+00_r8, &
     &4.2646e+00_r8,2.1334e+00_r8,3.2671e-04_r8/)
      kao(:, 3,11, 2) = (/ &
     &1.8597e+01_r8,1.6273e+01_r8,1.3949e+01_r8,1.1625e+01_r8,9.3007e+00_r8,6.9759e+00_r8, &
     &4.6520e+00_r8,2.3277e+00_r8,3.9618e-04_r8/)
      kao(:, 4,11, 2) = (/ &
     &1.9894e+01_r8,1.7409e+01_r8,1.4922e+01_r8,1.2436e+01_r8,9.9497e+00_r8,7.4632e+00_r8, &
     &4.9771e+00_r8,2.4907e+00_r8,4.6029e-04_r8/)
      kao(:, 5,11, 2) = (/ &
     &2.0957e+01_r8,1.8337e+01_r8,1.5718e+01_r8,1.3099e+01_r8,1.0480e+01_r8,7.8611e+00_r8, &
     &5.2427e+00_r8,2.6238e+00_r8,5.1000e-04_r8/)
      kao(:, 1,12, 2) = (/ &
     &1.6595e+01_r8,1.4521e+01_r8,1.2446e+01_r8,1.0372e+01_r8,8.2975e+00_r8,6.2234e+00_r8, &
     &4.1492e+00_r8,2.0749e+00_r8,2.8721e-04_r8/)
      kao(:, 2,12, 2) = (/ &
     &1.8487e+01_r8,1.6178e+01_r8,1.3866e+01_r8,1.1556e+01_r8,9.2444e+00_r8,6.9339e+00_r8, &
     &4.6231e+00_r8,2.3126e+00_r8,3.5210e-04_r8/)
      kao(:, 3,12, 2) = (/ &
     &2.0157e+01_r8,1.7638e+01_r8,1.5119e+01_r8,1.2600e+01_r8,1.0080e+01_r8,7.5607e+00_r8, &
     &5.0414e+00_r8,2.5223e+00_r8,4.4248e-04_r8/)
      kao(:, 4,12, 2) = (/ &
     &2.1568e+01_r8,1.8872e+01_r8,1.6176e+01_r8,1.3480e+01_r8,1.0785e+01_r8,8.0897e+00_r8, &
     &5.3945e+00_r8,2.6993e+00_r8,5.0244e-04_r8/)
      kao(:, 5,12, 2) = (/ &
     &2.2671e+01_r8,1.9838e+01_r8,1.7004e+01_r8,1.4170e+01_r8,1.1337e+01_r8,8.5042e+00_r8, &
     &5.6711e+00_r8,2.8381e+00_r8,5.5567e-04_r8/)
      kao(:, 1,13, 2) = (/ &
     &1.4451e+01_r8,1.2644e+01_r8,1.0838e+01_r8,9.0321e+00_r8,7.2259e+00_r8,5.4197e+00_r8, &
     &3.6133e+00_r8,1.8070e+00_r8,2.7932e-04_r8/)
      kao(:, 2,13, 2) = (/ &
     &1.6097e+01_r8,1.4085e+01_r8,1.2073e+01_r8,1.0061e+01_r8,8.0489e+00_r8,6.0372e+00_r8, &
     &4.0253e+00_r8,2.0137e+00_r8,3.2799e-04_r8/)
      kao(:, 3,13, 2) = (/ &
     &1.7564e+01_r8,1.5369e+01_r8,1.3173e+01_r8,1.0978e+01_r8,8.7826e+00_r8,6.5876e+00_r8, &
     &4.3925e+00_r8,2.1975e+00_r8,4.0780e-04_r8/)
      kao(:, 4,13, 2) = (/ &
     &1.8771e+01_r8,1.6426e+01_r8,1.4079e+01_r8,1.1733e+01_r8,9.3868e+00_r8,7.0409e+00_r8, &
     &4.6954e+00_r8,2.3495e+00_r8,5.0230e-04_r8/)
      kao(:, 5,13, 2) = (/ &
     &1.9694e+01_r8,1.7232e+01_r8,1.4771e+01_r8,1.2310e+01_r8,9.8489e+00_r8,7.3875e+00_r8, &
     &4.9264e+00_r8,2.4656e+00_r8,5.5102e-04_r8/)
      kao(:, 1, 1, 3) = (/ &
     &3.7564e-02_r8,3.3492e-02_r8,2.9385e-02_r8,2.5064e-02_r8,2.0679e-02_r8,1.6159e-02_r8, &
     &1.1502e-02_r8,6.5367e-03_r8,3.9794e-04_r8/)
      kao(:, 2, 1, 3) = (/ &
     &3.6916e-02_r8,3.3151e-02_r8,2.9160e-02_r8,2.5018e-02_r8,2.0751e-02_r8,1.6389e-02_r8, &
     &1.1901e-02_r8,7.2678e-03_r8,5.4686e-04_r8/)
      kao(:, 3, 1, 3) = (/ &
     &3.6399e-02_r8,3.2903e-02_r8,2.9031e-02_r8,2.5012e-02_r8,2.0900e-02_r8,1.6718e-02_r8, &
     &1.2389e-02_r8,8.0801e-03_r8,7.4220e-04_r8/)
      kao(:, 4, 1, 3) = (/ &
     &3.6126e-02_r8,3.2782e-02_r8,2.9047e-02_r8,2.5198e-02_r8,2.1279e-02_r8,1.7152e-02_r8, &
     &1.3045e-02_r8,8.9482e-03_r8,8.9478e-04_r8/)
      kao(:, 5, 1, 3) = (/ &
     &3.5996e-02_r8,3.2833e-02_r8,2.9270e-02_r8,2.5593e-02_r8,2.1712e-02_r8,1.7723e-02_r8, &
     &1.3812e-02_r8,9.7243e-03_r8,1.0975e-03_r8/)
      kao(:, 1, 2, 3) = (/ &
     &4.9545e-02_r8,4.3840e-02_r8,3.8273e-02_r8,3.2472e-02_r8,2.6558e-02_r8,2.0510e-02_r8, &
     &1.4332e-02_r8,7.7992e-03_r8,3.0769e-04_r8/)
      kao(:, 2, 2, 3) = (/ &
     &4.8709e-02_r8,4.3359e-02_r8,3.7969e-02_r8,3.2304e-02_r8,2.6513e-02_r8,2.0603e-02_r8, &
     &1.4626e-02_r8,8.4051e-03_r8,4.1476e-04_r8/)
      kao(:, 3, 2, 3) = (/ &
     &4.8165e-02_r8,4.3120e-02_r8,3.7795e-02_r8,3.2248e-02_r8,2.6570e-02_r8,2.0838e-02_r8, &
     &1.4977e-02_r8,8.9685e-03_r8,5.6832e-04_r8/)
      kao(:, 4, 2, 3) = (/ &
     &4.7962e-02_r8,4.3077e-02_r8,3.7844e-02_r8,3.2393e-02_r8,2.6873e-02_r8,2.1238e-02_r8, &
     &1.5407e-02_r8,9.6431e-03_r8,6.7745e-04_r8/)
      kao(:, 5, 2, 3) = (/ &
     &4.8025e-02_r8,4.3378e-02_r8,3.8202e-02_r8,3.2847e-02_r8,2.7374e-02_r8,2.1742e-02_r8, &
     &1.5999e-02_r8,1.0391e-02_r8,8.3539e-04_r8/)
      kao(:, 1, 3, 3) = (/ &
     &8.8120e-02_r8,7.7386e-02_r8,6.6977e-02_r8,5.6500e-02_r8,4.5838e-02_r8,3.5027e-02_r8, &
     &2.3995e-02_r8,1.2704e-02_r8,2.2676e-04_r8/)
      kao(:, 2, 3, 3) = (/ &
     &8.6799e-02_r8,7.6419e-02_r8,6.6419e-02_r8,5.6119e-02_r8,4.5623e-02_r8,3.4916e-02_r8, &
     &2.4025e-02_r8,1.3004e-02_r8,3.0168e-04_r8/)
      kao(:, 3, 3, 3) = (/ &
     &8.6001e-02_r8,7.6005e-02_r8,6.6184e-02_r8,5.6008e-02_r8,4.5591e-02_r8,3.4990e-02_r8, &
     &2.4263e-02_r8,1.3424e-02_r8,3.9676e-04_r8/)
      kao(:, 4, 3, 3) = (/ &
     &8.5691e-02_r8,7.5994e-02_r8,6.6270e-02_r8,5.6158e-02_r8,4.5788e-02_r8,3.5296e-02_r8, &
     &2.4707e-02_r8,1.3830e-02_r8,4.9186e-04_r8/)
      kao(:, 5, 3, 3) = (/ &
     &8.6172e-02_r8,7.6716e-02_r8,6.6965e-02_r8,5.6820e-02_r8,4.6489e-02_r8,3.5977e-02_r8, &
     &2.5332e-02_r8,1.4387e-02_r8,6.1173e-04_r8/)
      kao(:, 1, 4, 3) = (/ &
     &1.6100e-01_r8,1.4106e-01_r8,1.2117e-01_r8,1.0160e-01_r8,8.1953e-02_r8,6.2189e-02_r8, &
     &4.2184e-02_r8,2.1860e-02_r8,1.5920e-04_r8/)
      kao(:, 2, 4, 3) = (/ &
     &1.5854e-01_r8,1.3897e-01_r8,1.1977e-01_r8,1.0067e-01_r8,8.1408e-02_r8,6.1866e-02_r8, &
     &4.2083e-02_r8,2.1896e-02_r8,2.1901e-04_r8/)
      kao(:, 3, 4, 3) = (/ &
     &1.5713e-01_r8,1.3793e-01_r8,1.1924e-01_r8,1.0046e-01_r8,8.1310e-02_r8,6.1926e-02_r8, &
     &4.2176e-02_r8,2.2134e-02_r8,2.8281e-04_r8/)
      kao(:, 4, 4, 3) = (/ &
     &1.5680e-01_r8,1.3795e-01_r8,1.1956e-01_r8,1.0071e-01_r8,8.1588e-02_r8,6.2136e-02_r8, &
     &4.2469e-02_r8,2.2574e-02_r8,3.5509e-04_r8/)
      kao(:, 5, 4, 3) = (/ &
     &1.5807e-01_r8,1.3940e-01_r8,1.2093e-01_r8,1.0191e-01_r8,8.2580e-02_r8,6.3036e-02_r8, &
     &4.3252e-02_r8,2.3169e-02_r8,4.4437e-04_r8/)
      kao(:, 1, 5, 3) = (/ &
     &2.7295e-01_r8,2.3896e-01_r8,2.0497e-01_r8,1.7107e-01_r8,1.3742e-01_r8,1.0372e-01_r8, &
     &6.9897e-02_r8,3.5756e-02_r8,1.1345e-04_r8/)
      kao(:, 2, 5, 3) = (/ &
     &2.6909e-01_r8,2.3567e-01_r8,2.0228e-01_r8,1.6922e-01_r8,1.3618e-01_r8,1.0303e-01_r8, &
     &6.9598e-02_r8,3.5741e-02_r8,1.5887e-04_r8/)
      kao(:, 3, 5, 3) = (/ &
     &2.6654e-01_r8,2.3348e-01_r8,2.0077e-01_r8,1.6833e-01_r8,1.3583e-01_r8,1.0288e-01_r8, &
     &6.9627e-02_r8,3.5834e-02_r8,2.0432e-04_r8/)
      kao(:, 4, 5, 3) = (/ &
     &2.6633e-01_r8,2.3346e-01_r8,2.0125e-01_r8,1.6903e-01_r8,1.3632e-01_r8,1.0334e-01_r8, &
     &6.9968e-02_r8,3.6152e-02_r8,2.5784e-04_r8/)
      kao(:, 5, 5, 3) = (/ &
     &2.6868e-01_r8,2.3592e-01_r8,2.0366e-01_r8,1.7109e-01_r8,1.3803e-01_r8,1.0467e-01_r8, &
     &7.0932e-02_r8,3.6877e-02_r8,3.2436e-04_r8/)
      kao(:, 1, 6, 3) = (/ &
     &4.3357e-01_r8,3.7951e-01_r8,3.2542e-01_r8,2.7129e-01_r8,2.1728e-01_r8,1.6346e-01_r8, &
     &1.0964e-01_r8,5.5662e-02_r8,8.3325e-05_r8/)
      kao(:, 2, 6, 3) = (/ &
     &4.2794e-01_r8,3.7459e-01_r8,3.2123e-01_r8,2.6798e-01_r8,2.1494e-01_r8,1.6197e-01_r8, &
     &1.0894e-01_r8,5.5488e-02_r8,1.1433e-04_r8/)
      kao(:, 3, 6, 3) = (/ &
     &4.2362e-01_r8,3.7090e-01_r8,3.1822e-01_r8,2.6585e-01_r8,2.1359e-01_r8,1.6133e-01_r8, &
     &1.0870e-01_r8,5.5444e-02_r8,1.4294e-04_r8/)
      kao(:, 4, 6, 3) = (/ &
     &4.2356e-01_r8,3.7092e-01_r8,3.1860e-01_r8,2.6656e-01_r8,2.1457e-01_r8,1.6217e-01_r8, &
     &1.0928e-01_r8,5.5858e-02_r8,1.8487e-04_r8/)
      kao(:, 5, 6, 3) = (/ &
     &4.2732e-01_r8,3.7444e-01_r8,3.2213e-01_r8,2.6992e-01_r8,2.1742e-01_r8,1.6433e-01_r8, &
     &1.1084e-01_r8,5.6756e-02_r8,2.3367e-04_r8/)
      kao(:, 1, 7, 3) = (/ &
     &7.2201e-01_r8,6.3185e-01_r8,5.4168e-01_r8,4.5148e-01_r8,3.6131e-01_r8,2.7123e-01_r8, &
     &1.8131e-01_r8,9.1347e-02_r8,6.1051e-05_r8/)
      kao(:, 2, 7, 3) = (/ &
     &7.1295e-01_r8,6.2391e-01_r8,5.3487e-01_r8,4.4585e-01_r8,3.5694e-01_r8,2.6824e-01_r8, &
     &1.7961e-01_r8,9.0876e-02_r8,8.2662e-05_r8/)
      kao(:, 3, 7, 3) = (/ &
     &7.0704e-01_r8,6.1882e-01_r8,5.3061e-01_r8,4.4252e-01_r8,3.5463e-01_r8,2.6681e-01_r8, &
     &1.7908e-01_r8,9.0926e-02_r8,1.0796e-04_r8/)
      kao(:, 4, 7, 3) = (/ &
     &7.0657e-01_r8,6.1841e-01_r8,5.3039e-01_r8,4.4278e-01_r8,3.5513e-01_r8,2.6769e-01_r8, &
     &1.7995e-01_r8,9.1305e-02_r8,1.3920e-04_r8/)
      kao(:, 5, 7, 3) = (/ &
     &7.1310e-01_r8,6.2430e-01_r8,5.3600e-01_r8,4.4782e-01_r8,3.5976e-01_r8,2.7158e-01_r8, &
     &1.8261e-01_r8,9.2814e-02_r8,1.7572e-04_r8/)
      kao(:, 1, 8, 3) = (/ &
     &1.4344e+00_r8,1.2551e+00_r8,1.0759e+00_r8,8.9667e-01_r8,7.1735e-01_r8,5.3821e-01_r8, &
     &3.5899e-01_r8,1.8011e-01_r8,7.5748e-05_r8/)
      kao(:, 2, 8, 3) = (/ &
     &1.4191e+00_r8,1.2419e+00_r8,1.0645e+00_r8,8.8713e-01_r8,7.0979e-01_r8,5.3268e-01_r8, &
     &3.5557e-01_r8,1.7867e-01_r8,9.9921e-05_r8/)
      kao(:, 3, 8, 3) = (/ &
     &1.4086e+00_r8,1.2327e+00_r8,1.0566e+00_r8,8.8065e-01_r8,7.0478e-01_r8,5.2920e-01_r8, &
     &3.5364e-01_r8,1.7813e-01_r8,1.2236e-04_r8/)
      kao(:, 4, 8, 3) = (/ &
     &1.4087e+00_r8,1.2327e+00_r8,1.0568e+00_r8,8.8106e-01_r8,7.0553e-01_r8,5.2998e-01_r8, &
     &3.5460e-01_r8,1.7919e-01_r8,1.5414e-04_r8/)
      kao(:, 5, 8, 3) = (/ &
     &1.4217e+00_r8,1.2444e+00_r8,1.0672e+00_r8,8.9025e-01_r8,7.1327e-01_r8,5.3627e-01_r8, &
     &3.5965e-01_r8,1.8202e-01_r8,1.9115e-04_r8/)
      kao(:, 1, 9, 3) = (/ &
     &5.3656e+00_r8,4.6949e+00_r8,4.0244e+00_r8,3.3536e+00_r8,2.6829e+00_r8,2.0124e+00_r8, &
     &1.3418e+00_r8,6.7121e-01_r8,1.2938e-04_r8/)
      kao(:, 2, 9, 3) = (/ &
     &5.3249e+00_r8,4.6593e+00_r8,3.9938e+00_r8,3.3284e+00_r8,2.6628e+00_r8,1.9972e+00_r8, &
     &1.3317e+00_r8,6.6623e-01_r8,1.6248e-04_r8/)
      kao(:, 3, 9, 3) = (/ &
     &5.2842e+00_r8,4.6238e+00_r8,3.9633e+00_r8,3.3029e+00_r8,2.6426e+00_r8,1.9822e+00_r8, &
     &1.3219e+00_r8,6.6174e-01_r8,2.1505e-04_r8/)
      kao(:, 4, 9, 3) = (/ &
     &5.2909e+00_r8,4.6297e+00_r8,3.9685e+00_r8,3.3074e+00_r8,2.6461e+00_r8,1.9850e+00_r8, &
     &1.3243e+00_r8,6.6344e-01_r8,2.5323e-04_r8/)
      kao(:, 5, 9, 3) = (/ &
     &5.3328e+00_r8,4.6665e+00_r8,4.0003e+00_r8,3.3342e+00_r8,2.6682e+00_r8,2.0021e+00_r8, &
     &1.3361e+00_r8,6.6998e-01_r8,2.8724e-04_r8/)
      kao(:, 1,10, 3) = (/ &
     &2.2338e+01_r8,1.9545e+01_r8,1.6753e+01_r8,1.3961e+01_r8,1.1170e+01_r8,8.3767e+00_r8, &
     &5.5849e+00_r8,2.7925e+00_r8,2.7123e-04_r8/)
      kao(:, 2,10, 3) = (/ &
     &2.2247e+01_r8,1.9467e+01_r8,1.6686e+01_r8,1.3905e+01_r8,1.1124e+01_r8,8.3431e+00_r8, &
     &5.5623e+00_r8,2.7817e+00_r8,3.3076e-04_r8/)
      kao(:, 3,10, 3) = (/ &
     &2.2079e+01_r8,1.9319e+01_r8,1.6560e+01_r8,1.3800e+01_r8,1.1040e+01_r8,8.2801e+00_r8, &
     &5.5205e+00_r8,2.7607e+00_r8,4.2235e-04_r8/)
      kao(:, 4,10, 3) = (/ &
     &2.2133e+01_r8,1.9366e+01_r8,1.6600e+01_r8,1.3833e+01_r8,1.1067e+01_r8,8.3005e+00_r8, &
     &5.5343e+00_r8,2.7680e+00_r8,4.8628e-04_r8/)
      kao(:, 5,10, 3) = (/ &
     &2.2337e+01_r8,1.9545e+01_r8,1.6754e+01_r8,1.3962e+01_r8,1.1171e+01_r8,8.3788e+00_r8, &
     &5.5873e+00_r8,2.7956e+00_r8,6.0636e-04_r8/)
      kao(:, 1,11, 3) = (/ &
     &3.2372e+01_r8,2.8324e+01_r8,2.4279e+01_r8,2.0232e+01_r8,1.6186e+01_r8,1.2140e+01_r8, &
     &8.0929e+00_r8,4.0469e+00_r8,3.8659e-04_r8/)
      kao(:, 2,11, 3) = (/ &
     &3.2225e+01_r8,2.8197e+01_r8,2.4169e+01_r8,2.0141e+01_r8,1.6113e+01_r8,1.2085e+01_r8, &
     &8.0568e+00_r8,4.0284e+00_r8,4.6837e-04_r8/)
      kao(:, 3,11, 3) = (/ &
     &3.2089e+01_r8,2.8078e+01_r8,2.4068e+01_r8,2.0057e+01_r8,1.6046e+01_r8,1.2035e+01_r8, &
     &8.0232e+00_r8,4.0121e+00_r8,5.6676e-04_r8/)
      kao(:, 4,11, 3) = (/ &
     &3.2281e+01_r8,2.8246e+01_r8,2.4212e+01_r8,2.0176e+01_r8,1.6141e+01_r8,1.2106e+01_r8, &
     &8.0716e+00_r8,4.0370e+00_r8,7.3031e-04_r8/)
      kao(:, 5,11, 3) = (/ &
     &3.2736e+01_r8,2.8646e+01_r8,2.4553e+01_r8,2.0462e+01_r8,1.6370e+01_r8,1.2278e+01_r8, &
     &8.1864e+00_r8,4.0949e+00_r8,8.3516e-04_r8/)
      kao(:, 1,12, 3) = (/ &
     &3.4882e+01_r8,3.0522e+01_r8,2.6162e+01_r8,2.1802e+01_r8,1.7441e+01_r8,1.3081e+01_r8, &
     &8.7208e+00_r8,4.3607e+00_r8,4.1853e-04_r8/)
      kao(:, 2,12, 3) = (/ &
     &3.4744e+01_r8,3.0400e+01_r8,2.6058e+01_r8,2.1715e+01_r8,1.7372e+01_r8,1.3029e+01_r8, &
     &8.6862e+00_r8,4.3435e+00_r8,5.1635e-04_r8/)
      kao(:, 3,12, 3) = (/ &
     &3.4694e+01_r8,3.0356e+01_r8,2.6020e+01_r8,2.1683e+01_r8,1.7347e+01_r8,1.3010e+01_r8, &
     &8.6737e+00_r8,4.3374e+00_r8,5.8258e-04_r8/)
      kao(:, 4,12, 3) = (/ &
     &3.4999e+01_r8,3.0625e+01_r8,2.6249e+01_r8,2.1876e+01_r8,1.7501e+01_r8,1.3126e+01_r8, &
     &8.7513e+00_r8,4.3768e+00_r8,7.2545e-04_r8/)
      kao(:, 5,12, 3) = (/ &
     &3.5658e+01_r8,3.1201e+01_r8,2.6744e+01_r8,2.2288e+01_r8,1.7831e+01_r8,1.3374e+01_r8, &
     &8.9165e+00_r8,4.4593e+00_r8,9.3950e-04_r8/)
      kao(:, 1,13, 3) = (/ &
     &3.0168e+01_r8,2.6399e+01_r8,2.2627e+01_r8,1.8855e+01_r8,1.5085e+01_r8,1.1314e+01_r8, &
     &7.5425e+00_r8,3.7715e+00_r8,4.1524e-04_r8/)
      kao(:, 2,13, 3) = (/ &
     &3.0082e+01_r8,2.6321e+01_r8,2.2562e+01_r8,1.8800e+01_r8,1.5040e+01_r8,1.1280e+01_r8, &
     &7.5203e+00_r8,3.7604e+00_r8,5.1897e-04_r8/)
      kao(:, 3,13, 3) = (/ &
     &3.0098e+01_r8,2.6336e+01_r8,2.2574e+01_r8,1.8812e+01_r8,1.5049e+01_r8,1.1287e+01_r8, &
     &7.5253e+00_r8,3.7634e+00_r8,6.3490e-04_r8/)
      kao(:, 4,13, 3) = (/ &
     &3.0488e+01_r8,2.6677e+01_r8,2.2867e+01_r8,1.9056e+01_r8,1.5245e+01_r8,1.1434e+01_r8, &
     &7.6233e+00_r8,3.8122e+00_r8,7.3304e-04_r8/)
      kao(:, 5,13, 3) = (/ &
     &3.1139e+01_r8,2.7247e+01_r8,2.3355e+01_r8,1.9463e+01_r8,1.5570e+01_r8,1.1678e+01_r8, &
     &7.7859e+00_r8,3.8940e+00_r8,8.6573e-04_r8/)
      kao(:, 1, 1, 4) = (/ &
     &5.2057e-02_r8,4.6191e-02_r8,4.0791e-02_r8,3.5264e-02_r8,2.9386e-02_r8,2.3311e-02_r8, &
     &1.6933e-02_r8,9.9741e-03_r8,9.4742e-04_r8/)
      kao(:, 2, 1, 4) = (/ &
     &5.1799e-02_r8,4.6370e-02_r8,4.1424e-02_r8,3.5942e-02_r8,3.0151e-02_r8,2.4090e-02_r8, &
     &1.7827e-02_r8,1.1138e-02_r8,1.1643e-03_r8/)
      kao(:, 3, 1, 4) = (/ &
     &5.1774e-02_r8,4.6875e-02_r8,4.2240e-02_r8,3.6825e-02_r8,3.1105e-02_r8,2.5101e-02_r8, &
     &1.8967e-02_r8,1.2189e-02_r8,1.4467e-03_r8/)
      kao(:, 4, 1, 4) = (/ &
     &5.2049e-02_r8,4.7822e-02_r8,4.3286e-02_r8,3.7962e-02_r8,3.2336e-02_r8,2.6505e-02_r8, &
     &2.0163e-02_r8,1.3176e-02_r8,1.8457e-03_r8/)
      kao(:, 5, 1, 4) = (/ &
     &5.2435e-02_r8,4.8877e-02_r8,4.4449e-02_r8,3.9288e-02_r8,3.3894e-02_r8,2.7971e-02_r8, &
     &2.1357e-02_r8,1.4142e-02_r8,2.2765e-03_r8/)
      kao(:, 1, 2, 4) = (/ &
     &6.9283e-02_r8,6.1124e-02_r8,5.3312e-02_r8,4.5637e-02_r8,3.7639e-02_r8,2.9444e-02_r8, &
     &2.0926e-02_r8,1.1987e-02_r8,6.7708e-04_r8/)
      kao(:, 2, 2, 4) = (/ &
     &6.9230e-02_r8,6.1365e-02_r8,5.4052e-02_r8,4.6528e-02_r8,3.8569e-02_r8,3.0382e-02_r8, &
     &2.1758e-02_r8,1.2938e-02_r8,8.4618e-04_r8/)
      kao(:, 3, 2, 4) = (/ &
     &6.9474e-02_r8,6.2065e-02_r8,5.5235e-02_r8,4.7695e-02_r8,3.9803e-02_r8,3.1502e-02_r8, &
     &2.2924e-02_r8,1.3989e-02_r8,1.0726e-03_r8/)
      kao(:, 4, 2, 4) = (/ &
     &7.0041e-02_r8,6.3262e-02_r8,5.6631e-02_r8,4.9140e-02_r8,4.1246e-02_r8,3.2954e-02_r8, &
     &2.4393e-02_r8,1.5061e-02_r8,1.3926e-03_r8/)
      kao(:, 5, 2, 4) = (/ &
     &7.0798e-02_r8,6.4648e-02_r8,5.8174e-02_r8,5.0781e-02_r8,4.2976e-02_r8,3.4744e-02_r8, &
     &2.5864e-02_r8,1.6092e-02_r8,1.7223e-03_r8/)
      kao(:, 1, 3, 4) = (/ &
     &1.2468e-01_r8,1.0948e-01_r8,9.4277e-02_r8,7.9471e-02_r8,6.4703e-02_r8,4.9713e-02_r8, &
     &3.4483e-02_r8,1.8729e-02_r8,4.6220e-04_r8/)
      kao(:, 2, 3, 4) = (/ &
     &1.2473e-01_r8,1.0972e-01_r8,9.4939e-02_r8,8.0505e-02_r8,6.5924e-02_r8,5.0895e-02_r8, &
     &3.5571e-02_r8,1.9546e-02_r8,5.8785e-04_r8/)
      kao(:, 3, 3, 4) = (/ &
     &1.2557e-01_r8,1.1074e-01_r8,9.6443e-02_r8,8.2330e-02_r8,6.7617e-02_r8,5.2547e-02_r8, &
     &3.6938e-02_r8,2.0666e-02_r8,7.7467e-04_r8/)
      kao(:, 4, 3, 4) = (/ &
     &1.2675e-01_r8,1.1231e-01_r8,9.8604e-02_r8,8.4502e-02_r8,6.9700e-02_r8,5.4472e-02_r8, &
     &3.8553e-02_r8,2.2075e-02_r8,9.9922e-04_r8/)
      kao(:, 5, 3, 4) = (/ &
     &1.2846e-01_r8,1.1449e-01_r8,1.0119e-01_r8,8.7016e-02_r8,7.2084e-02_r8,5.6669e-02_r8, &
     &4.0555e-02_r8,2.3518e-02_r8,1.2453e-03_r8/)
      kao(:, 1, 4, 4) = (/ &
     &2.3029e-01_r8,2.0185e-01_r8,1.7335e-01_r8,1.4485e-01_r8,1.1669e-01_r8,8.8611e-02_r8, &
     &6.0409e-02_r8,3.1699e-02_r8,3.0371e-04_r8/)
      kao(:, 2, 4, 4) = (/ &
     &2.2988e-01_r8,2.0158e-01_r8,1.7329e-01_r8,1.4525e-01_r8,1.1751e-01_r8,8.9738e-02_r8, &
     &6.1449e-02_r8,3.2569e-02_r8,4.0236e-04_r8/)
      kao(:, 3, 4, 4) = (/ &
     &2.3229e-01_r8,2.0393e-01_r8,1.7566e-01_r8,1.4780e-01_r8,1.2020e-01_r8,9.2062e-02_r8, &
     &6.3397e-02_r8,3.3957e-02_r8,5.4454e-04_r8/)
      kao(:, 4, 4, 4) = (/ &
     &2.3507e-01_r8,2.0665e-01_r8,1.7868e-01_r8,1.5121e-01_r8,1.2350e-01_r8,9.4964e-02_r8, &
     &6.5854e-02_r8,3.5604e-02_r8,7.0998e-04_r8/)
      kao(:, 5, 4, 4) = (/ &
     &2.3825e-01_r8,2.0990e-01_r8,1.8240e-01_r8,1.5515e-01_r8,1.2704e-01_r8,9.8075e-02_r8, &
     &6.8384e-02_r8,3.7494e-02_r8,8.9536e-04_r8/)
      kao(:, 1, 5, 4) = (/ &
     &3.8945e-01_r8,3.4103e-01_r8,2.9259e-01_r8,2.4415e-01_r8,1.9571e-01_r8,1.4754e-01_r8, &
     &9.9565e-02_r8,5.1352e-02_r8,2.0409e-04_r8/)
      kao(:, 2, 5, 4) = (/ &
     &3.8981e-01_r8,3.4147e-01_r8,2.9305e-01_r8,2.4466e-01_r8,1.9659e-01_r8,1.4875e-01_r8, &
     &1.0088e-01_r8,5.2387e-02_r8,2.7339e-04_r8/)
      kao(:, 3, 5, 4) = (/ &
     &3.9497e-01_r8,3.4612e-01_r8,2.9724e-01_r8,2.4861e-01_r8,2.0028e-01_r8,1.5226e-01_r8, &
     &1.0369e-01_r8,5.4177e-02_r8,3.7984e-04_r8/)
      kao(:, 4, 5, 4) = (/ &
     &4.0149e-01_r8,3.5204e-01_r8,3.0270e-01_r8,2.5382e-01_r8,2.0546e-01_r8,1.5684e-01_r8, &
     &1.0724e-01_r8,5.6458e-02_r8,5.0160e-04_r8/)
      kao(:, 5, 5, 4) = (/ &
     &4.0773e-01_r8,3.5786e-01_r8,3.0839e-01_r8,2.5956e-01_r8,2.1090e-01_r8,1.6141e-01_r8, &
     &1.1086e-01_r8,5.8838e-02_r8,6.4384e-04_r8/)
      kao(:, 1, 6, 4) = (/ &
     &6.2109e-01_r8,5.4370e-01_r8,4.6619e-01_r8,3.8877e-01_r8,3.1132e-01_r8,2.3383e-01_r8, &
     &1.5671e-01_r8,7.9602e-02_r8,1.3341e-04_r8/)
      kao(:, 2, 6, 4) = (/ &
     &6.2314e-01_r8,5.4556e-01_r8,4.6793e-01_r8,3.9037e-01_r8,3.1270e-01_r8,2.3534e-01_r8, &
     &1.5827e-01_r8,8.0992e-02_r8,1.8152e-04_r8/)
      kao(:, 3, 6, 4) = (/ &
     &6.2957e-01_r8,5.5136e-01_r8,4.7308e-01_r8,3.9475e-01_r8,3.1676e-01_r8,2.3906e-01_r8, &
     &1.6147e-01_r8,8.3225e-02_r8,2.5970e-04_r8/)
      kao(:, 4, 6, 4) = (/ &
     &6.4091e-01_r8,5.6147e-01_r8,4.8196e-01_r8,4.0265e-01_r8,3.2370e-01_r8,2.4515e-01_r8, &
     &1.6638e-01_r8,8.6255e-02_r8,3.5139e-04_r8/)
      kao(:, 5, 6, 4) = (/ &
     &6.5388e-01_r8,5.7307e-01_r8,4.9223e-01_r8,4.1191e-01_r8,3.3205e-01_r8,2.5237e-01_r8, &
     &1.7171e-01_r8,8.9448e-02_r8,4.5531e-04_r8/)
      kao(:, 1, 7, 4) = (/ &
     &1.0457e+00_r8,9.1519e-01_r8,7.8460e-01_r8,6.5401e-01_r8,5.2349e-01_r8,3.9292e-01_r8, &
     &2.6230e-01_r8,1.3220e-01_r8,1.0032e-04_r8/)
      kao(:, 2, 7, 4) = (/ &
     &1.0500e+00_r8,9.1906e-01_r8,7.8807e-01_r8,6.5699e-01_r8,5.2599e-01_r8,3.9492e-01_r8, &
     &2.6410e-01_r8,1.3358e-01_r8,1.3899e-04_r8/)
      kao(:, 3, 7, 4) = (/ &
     &1.0598e+00_r8,9.2774e-01_r8,7.9565e-01_r8,6.6349e-01_r8,5.3130e-01_r8,3.9936e-01_r8, &
     &2.6782e-01_r8,1.3620e-01_r8,1.8444e-04_r8/)
      kao(:, 4, 7, 4) = (/ &
     &1.0743e+00_r8,9.4059e-01_r8,8.0685e-01_r8,6.7311e-01_r8,5.3945e-01_r8,4.0621e-01_r8, &
     &2.7331e-01_r8,1.3995e-01_r8,2.4657e-04_r8/)
      kao(:, 5, 7, 4) = (/ &
     &1.0996e+00_r8,9.6289e-01_r8,8.2608e-01_r8,6.8953e-01_r8,5.5342e-01_r8,4.1738e-01_r8, &
     &2.8182e-01_r8,1.4485e-01_r8,3.2431e-04_r8/)
      kao(:, 1, 8, 4) = (/ &
     &2.1071e+00_r8,1.8438e+00_r8,1.5804e+00_r8,1.3173e+00_r8,1.0540e+00_r8,7.9071e-01_r8, &
     &5.2749e-01_r8,2.6416e-01_r8,1.1085e-04_r8/)
      kao(:, 2, 8, 4) = (/ &
     &2.1142e+00_r8,1.8501e+00_r8,1.5861e+00_r8,1.3219e+00_r8,1.0578e+00_r8,7.9379e-01_r8, &
     &5.2971e-01_r8,2.6585e-01_r8,1.4810e-04_r8/)
      kao(:, 3, 8, 4) = (/ &
     &2.1318e+00_r8,1.8656e+00_r8,1.5995e+00_r8,1.3333e+00_r8,1.0671e+00_r8,8.0094e-01_r8, &
     &5.3475e-01_r8,2.6918e-01_r8,1.9501e-04_r8/)
      kao(:, 4, 8, 4) = (/ &
     &2.1555e+00_r8,1.8865e+00_r8,1.6175e+00_r8,1.3486e+00_r8,1.0795e+00_r8,8.1059e-01_r8, &
     &5.4205e-01_r8,2.7386e-01_r8,2.4224e-04_r8/)
      kao(:, 5, 8, 4) = (/ &
     &2.2062e+00_r8,1.9311e+00_r8,1.6560e+00_r8,1.3807e+00_r8,1.1056e+00_r8,8.3087e-01_r8, &
     &5.5626e-01_r8,2.8214e-01_r8,2.8558e-04_r8/)
      kao(:, 1, 9, 4) = (/ &
     &7.9972e+00_r8,6.9979e+00_r8,5.9979e+00_r8,4.9986e+00_r8,3.9987e+00_r8,2.9994e+00_r8, &
     &1.9999e+00_r8,1.0002e+00_r8,1.8668e-04_r8/)
      kao(:, 2, 9, 4) = (/ &
     &8.0128e+00_r8,7.0114e+00_r8,6.0097e+00_r8,5.0085e+00_r8,4.0070e+00_r8,3.0056e+00_r8, &
     &2.0042e+00_r8,1.0027e+00_r8,2.5150e-04_r8/)
      kao(:, 3, 9, 4) = (/ &
     &8.0805e+00_r8,7.0702e+00_r8,6.0607e+00_r8,5.0509e+00_r8,4.0412e+00_r8,3.0319e+00_r8, &
     &2.0219e+00_r8,1.0119e+00_r8,3.0396e-04_r8/)
      kao(:, 4, 9, 4) = (/ &
     &8.1743e+00_r8,7.1533e+00_r8,6.1315e+00_r8,5.1108e+00_r8,4.0892e+00_r8,3.0678e+00_r8, &
     &2.0462e+00_r8,1.0247e+00_r8,3.5321e-04_r8/)
      kao(:, 5, 9, 4) = (/ &
     &8.3409e+00_r8,7.2988e+00_r8,6.2567e+00_r8,5.2146e+00_r8,4.1728e+00_r8,3.1306e+00_r8, &
     &2.0885e+00_r8,1.0471e+00_r8,4.4198e-04_r8/)
      kao(:, 1,10, 4) = (/ &
     &3.3771e+01_r8,2.9548e+01_r8,2.5328e+01_r8,2.1105e+01_r8,1.6886e+01_r8,1.2665e+01_r8, &
     &8.4427e+00_r8,4.2216e+00_r8,4.3200e-04_r8/)
      kao(:, 2,10, 4) = (/ &
     &3.3810e+01_r8,2.9587e+01_r8,2.5358e+01_r8,2.1131e+01_r8,1.6905e+01_r8,1.2680e+01_r8, &
     &8.4534e+00_r8,4.2274e+00_r8,5.4393e-04_r8/)
      kao(:, 3,10, 4) = (/ &
     &3.4144e+01_r8,2.9876e+01_r8,2.5609e+01_r8,2.1340e+01_r8,1.7073e+01_r8,1.2805e+01_r8, &
     &8.5375e+00_r8,4.2697e+00_r8,6.4726e-04_r8/)
      kao(:, 4,10, 4) = (/ &
     &3.4577e+01_r8,3.0255e+01_r8,2.5934e+01_r8,2.1613e+01_r8,1.7291e+01_r8,1.2969e+01_r8, &
     &8.6471e+00_r8,4.3251e+00_r8,7.9967e-04_r8/)
      kao(:, 5,10, 4) = (/ &
     &3.5279e+01_r8,3.0869e+01_r8,2.6459e+01_r8,2.2050e+01_r8,1.7642e+01_r8,1.3232e+01_r8, &
     &8.8233e+00_r8,4.4139e+00_r8,8.8613e-04_r8/)
      kao(:, 1,11, 4) = (/ &
     &4.9379e+01_r8,4.3210e+01_r8,3.7035e+01_r8,3.0865e+01_r8,2.4692e+01_r8,1.8519e+01_r8, &
     &1.2346e+01_r8,6.1734e+00_r8,5.9531e-04_r8/)
      kao(:, 2,11, 4) = (/ &
     &4.9664e+01_r8,4.3455e+01_r8,3.7247e+01_r8,3.1040e+01_r8,2.4833e+01_r8,1.8625e+01_r8, &
     &1.2417e+01_r8,6.2092e+00_r8,7.3911e-04_r8/)
      kao(:, 3,11, 4) = (/ &
     &5.0351e+01_r8,4.4056e+01_r8,3.7762e+01_r8,3.1470e+01_r8,2.5175e+01_r8,1.8882e+01_r8, &
     &1.2589e+01_r8,6.2954e+00_r8,9.0535e-04_r8/)
      kao(:, 4,11, 4) = (/ &
     &5.1310e+01_r8,4.4899e+01_r8,3.8484e+01_r8,3.2071e+01_r8,2.5657e+01_r8,1.9244e+01_r8, &
     &1.2831e+01_r8,6.4171e+00_r8,1.0300e-03_r8/)
      kao(:, 5,11, 4) = (/ &
     &5.2691e+01_r8,4.6105e+01_r8,3.9519e+01_r8,3.2933e+01_r8,2.6348e+01_r8,1.9763e+01_r8, &
     &1.3176e+01_r8,6.5918e+00_r8,1.3056e-03_r8/)
      kao(:, 1,12, 4) = (/ &
     &5.3682e+01_r8,4.6971e+01_r8,4.0260e+01_r8,3.3552e+01_r8,2.6842e+01_r8,2.0131e+01_r8, &
     &1.3420e+01_r8,6.7107e+00_r8,5.9618e-04_r8/)
      kao(:, 2,12, 4) = (/ &
     &5.4209e+01_r8,4.7433e+01_r8,4.0657e+01_r8,3.3879e+01_r8,2.7104e+01_r8,2.0329e+01_r8, &
     &1.3553e+01_r8,6.7772e+00_r8,7.6649e-04_r8/)
      kao(:, 3,12, 4) = (/ &
     &5.5191e+01_r8,4.8293e+01_r8,4.1395e+01_r8,3.4495e+01_r8,2.7597e+01_r8,2.0697e+01_r8, &
     &1.3799e+01_r8,6.9009e+00_r8,9.6570e-04_r8/)
      kao(:, 4,12, 4) = (/ &
     &5.6606e+01_r8,4.9530e+01_r8,4.2455e+01_r8,3.5382e+01_r8,2.8306e+01_r8,2.1230e+01_r8, &
     &1.4154e+01_r8,7.0794e+00_r8,1.1503e-03_r8/)
      kao(:, 5,12, 4) = (/ &
     &5.8604e+01_r8,5.1279e+01_r8,4.3956e+01_r8,3.6631e+01_r8,2.9306e+01_r8,2.1982e+01_r8, &
     &1.4657e+01_r8,7.3321e+00_r8,1.3037e-03_r8/)
      kao(:, 1,13, 4) = (/ &
     &4.6897e+01_r8,4.1036e+01_r8,3.5173e+01_r8,2.9311e+01_r8,2.3449e+01_r8,1.7586e+01_r8, &
     &1.1724e+01_r8,5.8626e+00_r8,5.3404e-04_r8/)
      kao(:, 2,13, 4) = (/ &
     &4.7510e+01_r8,4.1569e+01_r8,3.5631e+01_r8,2.9695e+01_r8,2.3756e+01_r8,1.7817e+01_r8, &
     &1.1878e+01_r8,5.9396e+00_r8,7.0585e-04_r8/)
      kao(:, 3,13, 4) = (/ &
     &4.8599e+01_r8,4.2525e+01_r8,3.6450e+01_r8,3.0375e+01_r8,2.4299e+01_r8,1.8226e+01_r8, &
     &1.2152e+01_r8,6.0774e+00_r8,8.6599e-04_r8/)
      kao(:, 4,13, 4) = (/ &
     &5.0122e+01_r8,4.3856e+01_r8,3.7591e+01_r8,3.1328e+01_r8,2.5063e+01_r8,1.8798e+01_r8, &
     &1.2534e+01_r8,6.2697e+00_r8,1.0053e-03_r8/)
      kao(:, 5,13, 4) = (/ &
     &5.2215e+01_r8,4.5689e+01_r8,3.9164e+01_r8,3.2638e+01_r8,2.6111e+01_r8,1.9586e+01_r8, &
     &1.3060e+01_r8,6.5334e+00_r8,1.2313e-03_r8/)
      kao(:, 1, 1, 5) = (/ &
     &8.2901e-02_r8,7.3924e-02_r8,6.4657e-02_r8,5.5597e-02_r8,4.6472e-02_r8,3.6796e-02_r8, &
     &2.6709e-02_r8,1.5948e-02_r8,1.7802e-03_r8/)
      kao(:, 2, 1, 5) = (/ &
     &8.3370e-02_r8,7.4618e-02_r8,6.5698e-02_r8,5.7019e-02_r8,4.7812e-02_r8,3.7978e-02_r8, &
     &2.7855e-02_r8,1.7146e-02_r8,2.3935e-03_r8/)
      kao(:, 3, 1, 5) = (/ &
     &8.4235e-02_r8,7.5730e-02_r8,6.7257e-02_r8,5.8667e-02_r8,4.9229e-02_r8,3.9298e-02_r8, &
     &2.8966e-02_r8,1.8334e-02_r8,3.0382e-03_r8/)
      kao(:, 4, 1, 5) = (/ &
     &8.5176e-02_r8,7.7019e-02_r8,6.8972e-02_r8,6.0287e-02_r8,5.0680e-02_r8,4.0612e-02_r8, &
     &3.0271e-02_r8,1.9679e-02_r8,3.7478e-03_r8/)
      kao(:, 5, 1, 5) = (/ &
     &8.6230e-02_r8,7.8450e-02_r8,7.0705e-02_r8,6.1832e-02_r8,5.2066e-02_r8,4.2065e-02_r8, &
     &3.1638e-02_r8,2.1127e-02_r8,4.5344e-03_r8/)
      kao(:, 1, 2, 5) = (/ &
     &1.1319e-01_r8,1.0032e-01_r8,8.7141e-02_r8,7.4086e-02_r8,6.1196e-02_r8,4.7903e-02_r8, &
     &3.4053e-02_r8,1.9479e-02_r8,1.3324e-03_r8/)
      kao(:, 2, 2, 5) = (/ &
     &1.1444e-01_r8,1.0174e-01_r8,8.8783e-02_r8,7.6019e-02_r8,6.3135e-02_r8,4.9508e-02_r8, &
     &3.5403e-02_r8,2.0488e-02_r8,1.7827e-03_r8/)
      kao(:, 3, 2, 5) = (/ &
     &1.1608e-01_r8,1.0349e-01_r8,9.0802e-02_r8,7.8322e-02_r8,6.5118e-02_r8,5.1198e-02_r8, &
     &3.6801e-02_r8,2.1623e-02_r8,2.2789e-03_r8/)
      kao(:, 4, 2, 5) = (/ &
     &1.1786e-01_r8,1.0545e-01_r8,9.3147e-02_r8,8.0587e-02_r8,6.7042e-02_r8,5.2943e-02_r8, &
     &3.8201e-02_r8,2.2798e-02_r8,2.8272e-03_r8/)
      kao(:, 5, 2, 5) = (/ &
     &1.1969e-01_r8,1.0757e-01_r8,9.5567e-02_r8,8.2763e-02_r8,6.8961e-02_r8,5.4626e-02_r8, &
     &3.9785e-02_r8,2.4020e-02_r8,3.4454e-03_r8/)
      kao(:, 1, 3, 5) = (/ &
     &2.0690e-01_r8,1.8215e-01_r8,1.5725e-01_r8,1.3219e-01_r8,1.0725e-01_r8,8.2467e-02_r8, &
     &5.7330e-02_r8,3.1338e-02_r8,9.1573e-04_r8/)
      kao(:, 2, 3, 5) = (/ &
     &2.1013e-01_r8,1.8537e-01_r8,1.6026e-01_r8,1.3517e-01_r8,1.1017e-01_r8,8.5255e-02_r8, &
     &5.9448e-02_r8,3.2689e-02_r8,1.2507e-03_r8/)
      kao(:, 3, 3, 5) = (/ &
     &2.1385e-01_r8,1.8904e-01_r8,1.6379e-01_r8,1.3865e-01_r8,1.1374e-01_r8,8.8133e-02_r8, &
     &6.1604e-02_r8,3.4070e-02_r8,1.6182e-03_r8/)
      kao(:, 4, 3, 5) = (/ &
     &2.1772e-01_r8,1.9276e-01_r8,1.6753e-01_r8,1.4253e-01_r8,1.1723e-01_r8,9.0813e-02_r8, &
     &6.3766e-02_r8,3.5513e-02_r8,2.0311e-03_r8/)
      kao(:, 5, 3, 5) = (/ &
     &2.2143e-01_r8,1.9638e-01_r8,1.7123e-01_r8,1.4633e-01_r8,1.2052e-01_r8,9.3556e-02_r8, &
     &6.5944e-02_r8,3.7115e-02_r8,2.5088e-03_r8/)
      kao(:, 1, 4, 5) = (/ &
     &3.8507e-01_r8,3.3780e-01_r8,2.9048e-01_r8,2.4314e-01_r8,1.9570e-01_r8,1.4827e-01_r8, &
     &1.0100e-01_r8,5.3296e-02_r8,6.2147e-04_r8/)
      kao(:, 2, 4, 5) = (/ &
     &3.9146e-01_r8,3.4379e-01_r8,2.9605e-01_r8,2.4819e-01_r8,2.0018e-01_r8,1.5228e-01_r8, &
     &1.0449e-01_r8,5.5540e-02_r8,8.6088e-04_r8/)
      kao(:, 3, 4, 5) = (/ &
     &3.9930e-01_r8,3.5111e-01_r8,3.0278e-01_r8,2.5411e-01_r8,2.0550e-01_r8,1.5718e-01_r8, &
     &1.0825e-01_r8,5.7768e-02_r8,1.1308e-03_r8/)
      kao(:, 4, 4, 5) = (/ &
     &4.0750e-01_r8,3.5883e-01_r8,3.0957e-01_r8,2.6026e-01_r8,2.1112e-01_r8,1.6215e-01_r8, &
     &1.1175e-01_r8,5.9905e-02_r8,1.4435e-03_r8/)
      kao(:, 5, 4, 5) = (/ &
     &4.1540e-01_r8,3.6624e-01_r8,3.1618e-01_r8,2.6641e-01_r8,2.1709e-01_r8,1.6699e-01_r8, &
     &1.1521e-01_r8,6.2079e-02_r8,1.8081e-03_r8/)
      kao(:, 1, 5, 5) = (/ &
     &6.6039e-01_r8,5.7849e-01_r8,4.9659e-01_r8,4.1465e-01_r8,3.3268e-01_r8,2.5068e-01_r8, &
     &1.6878e-01_r8,8.6906e-02_r8,4.1392e-04_r8/)
      kao(:, 2, 5, 5) = (/ &
     &6.7138e-01_r8,5.8843e-01_r8,5.0538e-01_r8,4.2238e-01_r8,3.3940e-01_r8,2.5633e-01_r8, &
     &1.7334e-01_r8,9.0010e-02_r8,5.9039e-04_r8/)
      kao(:, 3, 5, 5) = (/ &
     &6.8434e-01_r8,6.0014e-01_r8,5.1596e-01_r8,4.3167e-01_r8,3.4721e-01_r8,2.6273e-01_r8, &
     &1.7850e-01_r8,9.3277e-02_r8,7.8856e-04_r8/)
      kao(:, 4, 5, 5) = (/ &
     &6.9935e-01_r8,6.1381e-01_r8,5.2821e-01_r8,4.4224e-01_r8,3.5606e-01_r8,2.7005e-01_r8, &
     &1.8435e-01_r8,9.6630e-02_r8,1.0256e-03_r8/)
      kao(:, 5, 5, 5) = (/ &
     &7.1524e-01_r8,6.2827e-01_r8,5.4104e-01_r8,4.5319e-01_r8,3.6550e-01_r8,2.7828e-01_r8, &
     &1.9025e-01_r8,9.9988e-02_r8,1.3023e-03_r8/)
      kao(:, 1, 6, 5) = (/ &
     &1.0605e+00_r8,9.2835e-01_r8,7.9638e-01_r8,6.6416e-01_r8,5.3204e-01_r8,3.9988e-01_r8, &
     &2.6772e-01_r8,1.3599e-01_r8,2.6665e-04_r8/)
      kao(:, 2, 6, 5) = (/ &
     &1.0793e+00_r8,9.4508e-01_r8,8.1097e-01_r8,6.7669e-01_r8,5.4239e-01_r8,4.0816e-01_r8, &
     &2.7396e-01_r8,1.4011e-01_r8,3.9578e-04_r8/)
      kao(:, 3, 6, 5) = (/ &
     &1.0996e+00_r8,9.6312e-01_r8,8.2674e-01_r8,6.9026e-01_r8,5.5385e-01_r8,4.1734e-01_r8, &
     &2.8093e-01_r8,1.4437e-01_r8,5.4281e-04_r8/)
      kao(:, 4, 6, 5) = (/ &
     &1.1270e+00_r8,9.8758e-01_r8,8.4814e-01_r8,7.0877e-01_r8,5.6910e-01_r8,4.2937e-01_r8, &
     &2.8968e-01_r8,1.4948e-01_r8,7.1692e-04_r8/)
      kao(:, 5, 6, 5) = (/ &
     &1.1549e+00_r8,1.0125e+00_r8,8.7022e-01_r8,7.2764e-01_r8,5.8478e-01_r8,4.4170e-01_r8, &
     &2.9907e-01_r8,1.5477e-01_r8,9.2735e-04_r8/)
      kao(:, 1, 7, 5) = (/ &
     &1.7902e+00_r8,1.5666e+00_r8,1.3432e+00_r8,1.1198e+00_r8,8.9630e-01_r8,6.7291e-01_r8, &
     &4.4939e-01_r8,2.2594e-01_r8,1.7788e-04_r8/)
      kao(:, 2, 7, 5) = (/ &
     &1.8253e+00_r8,1.5977e+00_r8,1.3701e+00_r8,1.1424e+00_r8,9.1476e-01_r8,6.8709e-01_r8, &
     &4.5936e-01_r8,2.3207e-01_r8,2.6007e-04_r8/)
      kao(:, 3, 7, 5) = (/ &
     &1.8661e+00_r8,1.6335e+00_r8,1.4010e+00_r8,1.1685e+00_r8,9.3601e-01_r8,7.0359e-01_r8, &
     &4.7118e-01_r8,2.3911e-01_r8,3.6579e-04_r8/)
      kao(:, 4, 7, 5) = (/ &
     &1.9131e+00_r8,1.6751e+00_r8,1.4368e+00_r8,1.1989e+00_r8,9.6095e-01_r8,7.2299e-01_r8, &
     &4.8503e-01_r8,2.4706e-01_r8,4.9009e-04_r8/)
      kao(:, 5, 7, 5) = (/ &
     &1.9618e+00_r8,1.7182e+00_r8,1.4745e+00_r8,1.2310e+00_r8,9.8739e-01_r8,7.4364e-01_r8, &
     &4.9951e-01_r8,2.5543e-01_r8,6.4417e-04_r8/)
      kao(:, 1, 8, 5) = (/ &
     &3.6222e+00_r8,3.1697e+00_r8,2.7175e+00_r8,2.2647e+00_r8,1.8122e+00_r8,1.3595e+00_r8, &
     &9.0703e-01_r8,4.5436e-01_r8,1.7700e-04_r8/)
      kao(:, 2, 8, 5) = (/ &
     &3.6989e+00_r8,3.2367e+00_r8,2.7747e+00_r8,2.3129e+00_r8,1.8509e+00_r8,1.3888e+00_r8, &
     &9.2689e-01_r8,4.6487e-01_r8,2.2396e-04_r8/)
      kao(:, 3, 8, 5) = (/ &
     &3.7900e+00_r8,3.3168e+00_r8,2.8434e+00_r8,2.3702e+00_r8,1.8972e+00_r8,1.4240e+00_r8, &
     &9.5085e-01_r8,4.7797e-01_r8,2.7417e-04_r8/)
      kao(:, 4, 8, 5) = (/ &
     &3.8908e+00_r8,3.4054e+00_r8,2.9198e+00_r8,2.4343e+00_r8,1.9488e+00_r8,1.4634e+00_r8, &
     &9.7805e-01_r8,4.9296e-01_r8,3.4875e-04_r8/)
      kao(:, 5, 8, 5) = (/ &
     &3.9856e+00_r8,3.4886e+00_r8,2.9916e+00_r8,2.4947e+00_r8,1.9978e+00_r8,1.5012e+00_r8, &
     &1.0044e+00_r8,5.0758e-01_r8,4.5934e-04_r8/)
      kao(:, 1, 9, 5) = (/ &
     &1.3794e+01_r8,1.2070e+01_r8,1.0346e+01_r8,8.6224e+00_r8,6.8983e+00_r8,5.1738e+00_r8, &
     &3.4497e+00_r8,1.7256e+00_r8,2.3317e-04_r8/)
      kao(:, 2, 9, 5) = (/ &
     &1.4093e+01_r8,1.2332e+01_r8,1.0571e+01_r8,8.8090e+00_r8,7.0478e+00_r8,5.2864e+00_r8, &
     &3.5250e+00_r8,1.7636e+00_r8,2.9550e-04_r8/)
      kao(:, 3, 9, 5) = (/ &
     &1.4464e+01_r8,1.2658e+01_r8,1.0848e+01_r8,9.0415e+00_r8,7.2337e+00_r8,5.4264e+00_r8, &
     &3.6184e+00_r8,1.8107e+00_r8,3.8639e-04_r8/)
      kao(:, 4, 9, 5) = (/ &
     &1.4855e+01_r8,1.2999e+01_r8,1.1143e+01_r8,9.2862e+00_r8,7.4306e+00_r8,5.5737e+00_r8, &
     &3.7173e+00_r8,1.8614e+00_r8,5.0786e-04_r8/)
      kao(:, 5, 9, 5) = (/ &
     &1.5210e+01_r8,1.3311e+01_r8,1.1410e+01_r8,9.5097e+00_r8,7.6091e+00_r8,5.7087e+00_r8, &
     &3.8087e+00_r8,1.9087e+00_r8,5.8982e-04_r8/)
      kao(:, 1,10, 5) = (/ &
     &5.8496e+01_r8,5.1180e+01_r8,4.3867e+01_r8,3.6556e+01_r8,2.9247e+01_r8,2.1935e+01_r8, &
     &1.4623e+01_r8,7.3123e+00_r8,5.6403e-04_r8/)
      kao(:, 2,10, 5) = (/ &
     &5.9786e+01_r8,5.2317e+01_r8,4.4840e+01_r8,3.7369e+01_r8,2.9895e+01_r8,2.2423e+01_r8, &
     &1.4947e+01_r8,7.4749e+00_r8,6.9685e-04_r8/)
      kao(:, 3,10, 5) = (/ &
     &6.1366e+01_r8,5.3692e+01_r8,4.6022e+01_r8,3.8353e+01_r8,3.0682e+01_r8,2.3012e+01_r8, &
     &1.5344e+01_r8,7.6729e+00_r8,8.6661e-04_r8/)
      kao(:, 4,10, 5) = (/ &
     &6.3002e+01_r8,5.5128e+01_r8,4.7254e+01_r8,3.9377e+01_r8,3.1505e+01_r8,2.3630e+01_r8, &
     &1.5753e+01_r8,7.8780e+00_r8,1.0403e-03_r8/)
      kao(:, 5,10, 5) = (/ &
     &6.4493e+01_r8,5.6436e+01_r8,4.8374e+01_r8,4.0310e+01_r8,3.2253e+01_r8,2.4189e+01_r8, &
     &1.6127e+01_r8,8.0668e+00_r8,1.2361e-03_r8/)
      kao(:, 1,11, 5) = (/ &
     &8.7182e+01_r8,7.6287e+01_r8,6.5394e+01_r8,5.4493e+01_r8,4.3594e+01_r8,3.2696e+01_r8, &
     &2.1798e+01_r8,1.0900e+01_r8,7.4362e-04_r8/)
      kao(:, 2,11, 5) = (/ &
     &8.9336e+01_r8,7.8172e+01_r8,6.7002e+01_r8,5.5836e+01_r8,4.4668e+01_r8,3.3502e+01_r8, &
     &2.2335e+01_r8,1.1168e+01_r8,9.0702e-04_r8/)
      kao(:, 3,11, 5) = (/ &
     &9.1581e+01_r8,8.0131e+01_r8,6.8688e+01_r8,5.7237e+01_r8,4.5792e+01_r8,3.4345e+01_r8, &
     &2.2896e+01_r8,1.1449e+01_r8,1.0809e-03_r8/)
      kao(:, 4,11, 5) = (/ &
     &9.3839e+01_r8,8.2107e+01_r8,7.0383e+01_r8,5.8658e+01_r8,4.6921e+01_r8,3.5193e+01_r8, &
     &2.3462e+01_r8,1.1732e+01_r8,1.3235e-03_r8/)
      kao(:, 5,11, 5) = (/ &
     &9.5958e+01_r8,8.3967e+01_r8,7.1970e+01_r8,5.9973e+01_r8,4.7982e+01_r8,3.5987e+01_r8, &
     &2.3994e+01_r8,1.1998e+01_r8,1.5458e-03_r8/)
      kao(:, 1,12, 5) = (/ &
     &9.6680e+01_r8,8.4597e+01_r8,7.2516e+01_r8,6.0430e+01_r8,4.8347e+01_r8,3.6257e+01_r8, &
     &2.4172e+01_r8,1.2087e+01_r8,8.8792e-04_r8/)
      kao(:, 2,12, 5) = (/ &
     &9.9039e+01_r8,8.6662e+01_r8,7.4284e+01_r8,6.1903e+01_r8,4.9522e+01_r8,3.7144e+01_r8, &
     &2.4762e+01_r8,1.2382e+01_r8,1.0348e-03_r8/)
      kao(:, 3,12, 5) = (/ &
     &1.0152e+02_r8,8.8834e+01_r8,7.6150e+01_r8,6.3450e+01_r8,5.0765e+01_r8,3.8071e+01_r8, &
     &2.5383e+01_r8,1.2692e+01_r8,1.2734e-03_r8/)
      kao(:, 4,12, 5) = (/ &
     &1.0389e+02_r8,9.0902e+01_r8,7.7912e+01_r8,6.4935e+01_r8,5.1946e+01_r8,3.8960e+01_r8, &
     &2.5973e+01_r8,1.2989e+01_r8,1.5461e-03_r8/)
      kao(:, 5,12, 5) = (/ &
     &1.0614e+02_r8,9.2872e+01_r8,7.9616e+01_r8,6.6343e+01_r8,5.3076e+01_r8,3.9807e+01_r8, &
     &2.6538e+01_r8,1.3271e+01_r8,1.7863e-03_r8/)
      kao(:, 1,13, 5) = (/ &
     &8.5924e+01_r8,7.5190e+01_r8,6.4446e+01_r8,5.3705e+01_r8,4.2964e+01_r8,3.2222e+01_r8, &
     &2.1482e+01_r8,1.0742e+01_r8,9.3650e-04_r8/)
      kao(:, 2,13, 5) = (/ &
     &8.8011e+01_r8,7.7009e+01_r8,6.6010e+01_r8,5.5012e+01_r8,4.4009e+01_r8,3.3008e+01_r8, &
     &2.2004e+01_r8,1.1003e+01_r8,1.0453e-03_r8/)
      kao(:, 3,13, 5) = (/ &
     &9.0165e+01_r8,7.8893e+01_r8,6.7623e+01_r8,5.6350e+01_r8,4.5080e+01_r8,3.3811e+01_r8, &
     &2.2542e+01_r8,1.1273e+01_r8,1.2632e-03_r8/)
      kao(:, 4,13, 5) = (/ &
     &9.2294e+01_r8,8.0759e+01_r8,6.9218e+01_r8,5.7683e+01_r8,4.6146e+01_r8,3.4609e+01_r8, &
     &2.3075e+01_r8,1.1539e+01_r8,1.5901e-03_r8/)
      kao(:, 5,13, 5) = (/ &
     &9.4515e+01_r8,8.2699e+01_r8,7.0891e+01_r8,5.9075e+01_r8,4.7260e+01_r8,3.5445e+01_r8, &
     &2.3631e+01_r8,1.1818e+01_r8,1.9283e-03_r8/)
      kao(:, 1, 1, 6) = (/ &
     &1.3664e-01_r8,1.2142e-01_r8,1.0604e-01_r8,9.0673e-02_r8,7.5307e-02_r8,5.9951e-02_r8, &
     &4.4049e-02_r8,2.7037e-02_r8,3.4200e-03_r8/)
      kao(:, 2, 1, 6) = (/ &
     &1.3479e-01_r8,1.2041e-01_r8,1.0581e-01_r8,9.1114e-02_r8,7.6669e-02_r8,6.1851e-02_r8, &
     &4.6009e-02_r8,2.9151e-02_r8,4.4244e-03_r8/)
      kao(:, 3, 1, 6) = (/ &
     &1.3313e-01_r8,1.1956e-01_r8,1.0561e-01_r8,9.1887e-02_r8,7.8237e-02_r8,6.3771e-02_r8, &
     &4.8109e-02_r8,3.1604e-02_r8,5.5644e-03_r8/)
      kao(:, 4, 1, 6) = (/ &
     &1.3195e-01_r8,1.1904e-01_r8,1.0583e-01_r8,9.3212e-02_r8,7.9889e-02_r8,6.5652e-02_r8, &
     &5.0318e-02_r8,3.4334e-02_r8,6.8097e-03_r8/)
      kao(:, 5, 1, 6) = (/ &
     &1.3100e-01_r8,1.1871e-01_r8,1.0645e-01_r8,9.4491e-02_r8,8.1510e-02_r8,6.7455e-02_r8, &
     &5.2648e-02_r8,3.7142e-02_r8,8.1798e-03_r8/)
      kao(:, 1, 2, 6) = (/ &
     &1.8948e-01_r8,1.6745e-01_r8,1.4512e-01_r8,1.2300e-01_r8,1.0098e-01_r8,7.9021e-02_r8, &
     &5.6595e-02_r8,3.3068e-02_r8,2.5064e-03_r8/)
      kao(:, 2, 2, 6) = (/ &
     &1.8719e-01_r8,1.6582e-01_r8,1.4439e-01_r8,1.2310e-01_r8,1.0186e-01_r8,8.0667e-02_r8, &
     &5.8428e-02_r8,3.4918e-02_r8,3.2805e-03_r8/)
      kao(:, 3, 2, 6) = (/ &
     &1.8550e-01_r8,1.6475e-01_r8,1.4416e-01_r8,1.2351e-01_r8,1.0330e-01_r8,8.2465e-02_r8, &
     &6.0314e-02_r8,3.6962e-02_r8,4.1499e-03_r8/)
      kao(:, 4, 2, 6) = (/ &
     &1.8451e-01_r8,1.6460e-01_r8,1.4454e-01_r8,1.2487e-01_r8,1.0515e-01_r8,8.4419e-02_r8, &
     &6.2353e-02_r8,3.9320e-02_r8,5.1265e-03_r8/)
      kao(:, 5, 2, 6) = (/ &
     &1.8423e-01_r8,1.6501e-01_r8,1.4553e-01_r8,1.2672e-01_r8,1.0715e-01_r8,8.6338e-02_r8, &
     &6.4353e-02_r8,4.1893e-02_r8,6.2102e-03_r8/)
      kao(:, 1, 3, 6) = (/ &
     &3.5249e-01_r8,3.0976e-01_r8,2.6683e-01_r8,2.2378e-01_r8,1.8098e-01_r8,1.3846e-01_r8, &
     &9.6219e-02_r8,5.2862e-02_r8,1.7476e-03_r8/)
      kao(:, 2, 3, 6) = (/ &
     &3.4945e-01_r8,3.0729e-01_r8,2.6503e-01_r8,2.2304e-01_r8,1.8135e-01_r8,1.3971e-01_r8, &
     &9.8147e-02_r8,5.4704e-02_r8,2.3082e-03_r8/)
      kao(:, 3, 3, 6) = (/ &
     &3.4786e-01_r8,3.0616e-01_r8,2.6475e-01_r8,2.2367e-01_r8,1.8257e-01_r8,1.4178e-01_r8, &
     &1.0043e-01_r8,5.6633e-02_r8,2.9556e-03_r8/)
      kao(:, 4, 3, 6) = (/ &
     &3.4805e-01_r8,3.0690e-01_r8,2.6623e-01_r8,2.2552e-01_r8,1.8508e-01_r8,1.4480e-01_r8, &
     &1.0306e-01_r8,5.8846e-02_r8,3.6970e-03_r8/)
      kao(:, 5, 3, 6) = (/ &
     &3.5013e-01_r8,3.0948e-01_r8,2.6918e-01_r8,2.2850e-01_r8,1.8865e-01_r8,1.4799e-01_r8, &
     &1.0568e-01_r8,6.1131e-02_r8,4.5281e-03_r8/)
      kao(:, 1, 4, 6) = (/ &
     &6.6623e-01_r8,5.8386e-01_r8,5.0153e-01_r8,4.1899e-01_r8,3.3640e-01_r8,2.5407e-01_r8, &
     &1.7225e-01_r8,9.1058e-02_r8,1.1958e-03_r8/)
      kao(:, 2, 4, 6) = (/ &
     &6.6340e-01_r8,5.8167e-01_r8,4.9974e-01_r8,4.1776e-01_r8,3.3619e-01_r8,2.5503e-01_r8, &
     &1.7423e-01_r8,9.3289e-02_r8,1.6080e-03_r8/)
      kao(:, 3, 4, 6) = (/ &
     &6.6480e-01_r8,5.8306e-01_r8,5.0121e-01_r8,4.1990e-01_r8,3.3893e-01_r8,2.5818e-01_r8, &
     &1.7768e-01_r8,9.5987e-02_r8,2.0929e-03_r8/)
      kao(:, 4, 4, 6) = (/ &
     &6.7003e-01_r8,5.8789e-01_r8,5.0627e-01_r8,4.2518e-01_r8,3.4417e-01_r8,2.6306e-01_r8, &
     &1.8230e-01_r8,9.9134e-02_r8,2.6527e-03_r8/)
      kao(:, 5, 4, 6) = (/ &
     &6.7815e-01_r8,5.9566e-01_r8,5.1416e-01_r8,4.3281e-01_r8,3.5098e-01_r8,2.6952e-01_r8, &
     &1.8764e-01_r8,1.0249e-01_r8,3.2896e-03_r8/)
      kao(:, 1, 5, 6) = (/ &
     &1.1550e+00_r8,1.0112e+00_r8,8.6772e-01_r8,7.2399e-01_r8,5.8018e-01_r8,4.3620e-01_r8, &
     &2.9244e-01_r8,1.4976e-01_r8,8.1069e-04_r8/)
      kao(:, 2, 5, 6) = (/ &
     &1.1564e+00_r8,1.0128e+00_r8,8.6891e-01_r8,7.2534e-01_r8,5.8147e-01_r8,4.3781e-01_r8, &
     &2.9477e-01_r8,1.5282e-01_r8,1.1157e-03_r8/)
      kao(:, 3, 5, 6) = (/ &
     &1.1669e+00_r8,1.0223e+00_r8,8.7752e-01_r8,7.3265e-01_r8,5.8799e-01_r8,4.4399e-01_r8, &
     &3.0054e-01_r8,1.5735e-01_r8,1.4779e-03_r8/)
      kao(:, 4, 5, 6) = (/ &
     &1.1830e+00_r8,1.0368e+00_r8,8.9030e-01_r8,7.4407e-01_r8,5.9861e-01_r8,4.5354e-01_r8, &
     &3.0826e-01_r8,1.6275e-01_r8,1.9001e-03_r8/)
      kao(:, 5, 5, 6) = (/ &
     &1.2016e+00_r8,1.0534e+00_r8,9.0529e-01_r8,7.5813e-01_r8,6.1140e-01_r8,4.6432e-01_r8, &
     &3.1746e-01_r8,1.6866e-01_r8,2.3885e-03_r8/)
      kao(:, 1, 6, 6) = (/ &
     &1.8728e+00_r8,1.6394e+00_r8,1.4057e+00_r8,1.1724e+00_r8,9.3873e-01_r8,7.0502e-01_r8, &
     &4.7119e-01_r8,2.3746e-01_r8,5.3401e-04_r8/)
      kao(:, 2, 6, 6) = (/ &
     &1.8855e+00_r8,1.6506e+00_r8,1.4159e+00_r8,1.1808e+00_r8,9.4575e-01_r8,7.1049e-01_r8, &
     &4.7534e-01_r8,2.4122e-01_r8,7.5510e-04_r8/)
      kao(:, 3, 6, 6) = (/ &
     &1.9127e+00_r8,1.6747e+00_r8,1.4367e+00_r8,1.1985e+00_r8,9.6017e-01_r8,7.2202e-01_r8, &
     &4.8438e-01_r8,2.4807e-01_r8,1.0228e-03_r8/)
      kao(:, 4, 6, 6) = (/ &
     &1.9458e+00_r8,1.7041e+00_r8,1.4622e+00_r8,1.2202e+00_r8,9.7826e-01_r8,7.3694e-01_r8, &
     &4.9644e-01_r8,2.5634e-01_r8,1.3413e-03_r8/)
      kao(:, 5, 6, 6) = (/ &
     &1.9819e+00_r8,1.7360e+00_r8,1.4899e+00_r8,1.2440e+00_r8,9.9883e-01_r8,7.5442e-01_r8, &
     &5.0981e-01_r8,2.6524e-01_r8,1.7130e-03_r8/)
      kao(:, 1, 7, 6) = (/ &
     &3.1956e+00_r8,2.7964e+00_r8,2.3973e+00_r8,1.9983e+00_r8,1.5994e+00_r8,1.2005e+00_r8, &
     &8.0140e-01_r8,4.0204e-01_r8,3.4739e-04_r8/)
      kao(:, 2, 7, 6) = (/ &
     &3.2319e+00_r8,2.8287e+00_r8,2.4254e+00_r8,2.0219e+00_r8,1.6186e+00_r8,1.2150e+00_r8, &
     &8.1138e-01_r8,4.0767e-01_r8,4.9767e-04_r8/)
      kao(:, 3, 7, 6) = (/ &
     &3.2870e+00_r8,2.8773e+00_r8,2.4673e+00_r8,2.0573e+00_r8,1.6471e+00_r8,1.2367e+00_r8, &
     &8.2648e-01_r8,4.1699e-01_r8,6.8883e-04_r8/)
      kao(:, 4, 7, 6) = (/ &
     &3.3536e+00_r8,2.9357e+00_r8,2.5178e+00_r8,2.0997e+00_r8,1.6816e+00_r8,1.2633e+00_r8, &
     &8.4550e-01_r8,4.2915e-01_r8,9.2075e-04_r8/)
      kao(:, 5, 7, 6) = (/ &
     &3.4247e+00_r8,2.9983e+00_r8,2.5718e+00_r8,2.1451e+00_r8,1.7185e+00_r8,1.2924e+00_r8, &
     &8.6745e-01_r8,4.4266e-01_r8,1.1994e-03_r8/)
      kao(:, 1, 8, 6) = (/ &
     &6.5522e+00_r8,5.7333e+00_r8,4.9154e+00_r8,4.0958e+00_r8,3.2773e+00_r8,2.4586e+00_r8, &
     &1.6399e+00_r8,8.2128e-01_r8,2.5000e-04_r8/)
      kao(:, 2, 8, 6) = (/ &
     &6.6534e+00_r8,5.8224e+00_r8,4.9909e+00_r8,4.1598e+00_r8,3.3284e+00_r8,2.4975e+00_r8, &
     &1.6667e+00_r8,8.3486e-01_r8,3.5933e-04_r8/)
      kao(:, 3, 8, 6) = (/ &
     &6.7871e+00_r8,5.9396e+00_r8,5.0919e+00_r8,4.2443e+00_r8,3.3968e+00_r8,2.5492e+00_r8, &
     &1.7012e+00_r8,8.5283e-01_r8,4.9387e-04_r8/)
      kao(:, 4, 8, 6) = (/ &
     &6.9317e+00_r8,6.0662e+00_r8,5.2009e+00_r8,4.3357e+00_r8,3.4705e+00_r8,2.6048e+00_r8, &
     &1.7389e+00_r8,8.7334e-01_r8,6.4756e-04_r8/)
      kao(:, 5, 8, 6) = (/ &
     &7.0935e+00_r8,6.2081e+00_r8,5.3230e+00_r8,4.4380e+00_r8,3.5524e+00_r8,2.6671e+00_r8, &
     &1.7815e+00_r8,8.9762e-01_r8,8.2195e-04_r8/)
      kao(:, 1, 9, 6) = (/ &
     &2.5444e+01_r8,2.2265e+01_r8,1.9084e+01_r8,1.5904e+01_r8,1.2723e+01_r8,9.5428e+00_r8, &
     &6.3622e+00_r8,3.1820e+00_r8,4.0178e-04_r8/)
      kao(:, 2, 9, 6) = (/ &
     &2.5907e+01_r8,2.2668e+01_r8,1.9432e+01_r8,1.6194e+01_r8,1.2956e+01_r8,9.7177e+00_r8, &
     &6.4794e+00_r8,3.2416e+00_r8,4.9820e-04_r8/)
      kao(:, 3, 9, 6) = (/ &
     &2.6491e+01_r8,2.3181e+01_r8,1.9870e+01_r8,1.6559e+01_r8,1.3249e+01_r8,9.9392e+00_r8, &
     &6.6274e+00_r8,3.3163e+00_r8,5.8675e-04_r8/)
      kao(:, 4, 9, 6) = (/ &
     &2.7100e+01_r8,2.3714e+01_r8,2.0326e+01_r8,1.6941e+01_r8,1.3555e+01_r8,1.0168e+01_r8, &
     &6.7813e+00_r8,3.3943e+00_r8,7.0841e-04_r8/)
      kao(:, 5, 9, 6) = (/ &
     &2.7765e+01_r8,2.4297e+01_r8,2.0827e+01_r8,1.7358e+01_r8,1.3889e+01_r8,1.0420e+01_r8, &
     &6.9499e+00_r8,3.4794e+00_r8,8.5424e-04_r8/)
      kao(:, 1,10, 6) = (/ &
     &1.1023e+02_r8,9.6432e+01_r8,8.2664e+01_r8,6.8898e+01_r8,5.5114e+01_r8,4.1339e+01_r8, &
     &2.7555e+01_r8,1.3778e+01_r8,8.1537e-04_r8/)
      kao(:, 2,10, 6) = (/ &
     &1.1247e+02_r8,9.8427e+01_r8,8.4346e+01_r8,7.0300e+01_r8,5.6236e+01_r8,4.2180e+01_r8, &
     &2.8118e+01_r8,1.4061e+01_r8,9.9310e-04_r8/)
      kao(:, 3,10, 6) = (/ &
     &1.1514e+02_r8,1.0076e+02_r8,8.6358e+01_r8,7.1971e+01_r8,5.7576e+01_r8,4.3183e+01_r8, &
     &2.8789e+01_r8,1.4396e+01_r8,1.1831e-03_r8/)
      kao(:, 4,10, 6) = (/ &
     &1.1802e+02_r8,1.0327e+02_r8,8.8510e+01_r8,7.3765e+01_r8,5.9016e+01_r8,4.4263e+01_r8, &
     &2.9511e+01_r8,1.4759e+01_r8,1.3868e-03_r8/)
      kao(:, 5,10, 6) = (/ &
     &1.2130e+02_r8,1.0614e+02_r8,9.0978e+01_r8,7.5815e+01_r8,6.0657e+01_r8,4.5493e+01_r8, &
     &3.0333e+01_r8,1.5172e+01_r8,1.7070e-03_r8/)
      kao(:, 1,11, 6) = (/ &
     &1.6690e+02_r8,1.4603e+02_r8,1.2516e+02_r8,1.0431e+02_r8,8.3442e+01_r8,6.2583e+01_r8, &
     &4.1722e+01_r8,2.0862e+01_r8,1.5727e-03_r8/)
      kao(:, 2,11, 6) = (/ &
     &1.7086e+02_r8,1.4949e+02_r8,1.2814e+02_r8,1.0678e+02_r8,8.5424e+01_r8,6.4067e+01_r8, &
     &4.2718e+01_r8,2.1360e+01_r8,1.6234e-03_r8/)
      kao(:, 3,11, 6) = (/ &
     &1.7519e+02_r8,1.5329e+02_r8,1.3139e+02_r8,1.0949e+02_r8,8.7589e+01_r8,6.5698e+01_r8, &
     &4.3799e+01_r8,2.1903e+01_r8,1.7884e-03_r8/)
      kao(:, 4,11, 6) = (/ &
     &1.8016e+02_r8,1.5762e+02_r8,1.3510e+02_r8,1.1259e+02_r8,9.0076e+01_r8,6.7557e+01_r8, &
     &4.5039e+01_r8,2.2524e+01_r8,2.1215e-03_r8/)
      kao(:, 5,11, 6) = (/ &
     &1.8518e+02_r8,1.6203e+02_r8,1.3888e+02_r8,1.1573e+02_r8,9.2591e+01_r8,6.9449e+01_r8, &
     &4.6302e+01_r8,2.3157e+01_r8,2.4813e-03_r8/)
      kao(:, 1,12, 6) = (/ &
     &1.8707e+02_r8,1.6368e+02_r8,1.4030e+02_r8,1.1692e+02_r8,9.3541e+01_r8,7.0153e+01_r8, &
     &4.6766e+01_r8,2.3384e+01_r8,1.9770e-03_r8/)
      kao(:, 2,12, 6) = (/ &
     &1.9183e+02_r8,1.6788e+02_r8,1.4389e+02_r8,1.1990e+02_r8,9.5932e+01_r8,7.1949e+01_r8, &
     &4.7966e+01_r8,2.3985e+01_r8,2.1043e-03_r8/)
      kao(:, 3,12, 6) = (/ &
     &1.9710e+02_r8,1.7246e+02_r8,1.4784e+02_r8,1.2320e+02_r8,9.8552e+01_r8,7.3917e+01_r8, &
     &4.9278e+01_r8,2.4644e+01_r8,2.2289e-03_r8/)
      kao(:, 4,12, 6) = (/ &
     &2.0265e+02_r8,1.7731e+02_r8,1.5198e+02_r8,1.2666e+02_r8,1.0133e+02_r8,7.5997e+01_r8, &
     &5.0665e+01_r8,2.5338e+01_r8,2.5070e-03_r8/)
      kao(:, 5,12, 6) = (/ &
     &2.0830e+02_r8,1.8227e+02_r8,1.5623e+02_r8,1.3019e+02_r8,1.0416e+02_r8,7.8120e+01_r8, &
     &5.2086e+01_r8,2.6047e+01_r8,2.9426e-03_r8/)
      kao(:, 1,13, 6) = (/ &
     &1.6768e+02_r8,1.4672e+02_r8,1.2576e+02_r8,1.0480e+02_r8,8.3836e+01_r8,6.2874e+01_r8, &
     &4.1918e+01_r8,2.0960e+01_r8,1.9900e-03_r8/)
      kao(:, 2,13, 6) = (/ &
     &1.7225e+02_r8,1.5072e+02_r8,1.2919e+02_r8,1.0767e+02_r8,8.6132e+01_r8,6.4601e+01_r8, &
     &4.3064e+01_r8,2.1534e+01_r8,2.2115e-03_r8/)
      kao(:, 3,13, 6) = (/ &
     &1.7710e+02_r8,1.5497e+02_r8,1.3283e+02_r8,1.1069e+02_r8,8.8549e+01_r8,6.6413e+01_r8, &
     &4.4281e+01_r8,2.2144e+01_r8,2.4087e-03_r8/)
      kao(:, 4,13, 6) = (/ &
     &1.8201e+02_r8,1.5926e+02_r8,1.3651e+02_r8,1.1376e+02_r8,9.1007e+01_r8,6.8257e+01_r8, &
     &4.5512e+01_r8,2.2758e+01_r8,2.6872e-03_r8/)
      kao(:, 5,13, 6) = (/ &
     &1.8703e+02_r8,1.6366e+02_r8,1.4029e+02_r8,1.1690e+02_r8,9.3529e+01_r8,7.0144e+01_r8, &
     &4.6769e+01_r8,2.3390e+01_r8,2.9430e-03_r8/)
      kao(:, 1, 1, 7) = (/ &
     &2.6412e-01_r8,2.3209e-01_r8,2.0136e-01_r8,1.7041e-01_r8,1.3987e-01_r8,1.0997e-01_r8, &
     &7.9977e-02_r8,4.8294e-02_r8,7.1406e-03_r8/)
      kao(:, 2, 1, 7) = (/ &
     &2.6114e-01_r8,2.3041e-01_r8,2.0084e-01_r8,1.7141e-01_r8,1.4253e-01_r8,1.1370e-01_r8, &
     &8.4426e-02_r8,5.2292e-02_r8,9.2339e-03_r8/)
      kao(:, 3, 1, 7) = (/ &
     &2.5746e-01_r8,2.2846e-01_r8,2.0043e-01_r8,1.7294e-01_r8,1.4558e-01_r8,1.1774e-01_r8, &
     &8.8686e-02_r8,5.6161e-02_r8,1.1607e-02_r8/)
      kao(:, 4, 1, 7) = (/ &
     &2.5329e-01_r8,2.2641e-01_r8,2.0046e-01_r8,1.7465e-01_r8,1.4868e-01_r8,1.2202e-01_r8, &
     &9.2933e-02_r8,6.0129e-02_r8,1.4258e-02_r8/)
      kao(:, 5, 1, 7) = (/ &
     &2.4914e-01_r8,2.2449e-01_r8,2.0080e-01_r8,1.7670e-01_r8,1.5234e-01_r8,1.2632e-01_r8, &
     &9.7469e-02_r8,6.4803e-02_r8,1.7193e-02_r8/)
      kao(:, 1, 2, 7) = (/ &
     &3.8226e-01_r8,3.3530e-01_r8,2.8943e-01_r8,2.4384e-01_r8,1.9786e-01_r8,1.5259e-01_r8, &
     &1.0817e-01_r8,6.3161e-02_r8,5.4372e-03_r8/)
      kao(:, 2, 2, 7) = (/ &
     &3.7769e-01_r8,3.3226e-01_r8,2.8798e-01_r8,2.4326e-01_r8,1.9923e-01_r8,1.5589e-01_r8, &
     &1.1262e-01_r8,6.7329e-02_r8,7.0870e-03_r8/)
      kao(:, 3, 2, 7) = (/ &
     &3.7182e-01_r8,3.2842e-01_r8,2.8559e-01_r8,2.4304e-01_r8,2.0123e-01_r8,1.5952e-01_r8, &
     &1.1734e-01_r8,7.1516e-02_r8,8.9693e-03_r8/)
      kao(:, 4, 2, 7) = (/ &
     &3.6545e-01_r8,3.2421e-01_r8,2.8324e-01_r8,2.4318e-01_r8,2.0343e-01_r8,1.6337e-01_r8, &
     &1.2179e-01_r8,7.5704e-02_r8,1.1062e-02_r8/)
      kao(:, 5, 2, 7) = (/ &
     &3.5934e-01_r8,3.2018e-01_r8,2.8184e-01_r8,2.4404e-01_r8,2.0628e-01_r8,1.6781e-01_r8, &
     &1.2654e-01_r8,8.0391e-02_r8,1.3382e-02_r8/)
      kao(:, 1, 3, 7) = (/ &
     &7.3419e-01_r8,6.4302e-01_r8,5.5249e-01_r8,4.6249e-01_r8,3.7279e-01_r8,2.8244e-01_r8, &
     &1.9254e-01_r8,1.0461e-01_r8,3.8320e-03_r8/)
      kao(:, 2, 3, 7) = (/ &
     &7.2438e-01_r8,6.3531e-01_r8,5.4697e-01_r8,4.5910e-01_r8,3.7055e-01_r8,2.8234e-01_r8, &
     &1.9553e-01_r8,1.0953e-01_r8,5.0607e-03_r8/)
      kao(:, 3, 3, 7) = (/ &
     &7.1308e-01_r8,6.2644e-01_r8,5.4060e-01_r8,4.5437e-01_r8,3.6826e-01_r8,2.8333e-01_r8, &
     &1.9916e-01_r8,1.1441e-01_r8,6.4784e-03_r8/)
      kao(:, 4, 3, 7) = (/ &
     &7.0097e-01_r8,6.1696e-01_r8,5.3353e-01_r8,4.4963e-01_r8,3.6700e-01_r8,2.8530e-01_r8, &
     &2.0351e-01_r8,1.1914e-01_r8,8.0908e-03_r8/)
      kao(:, 5, 3, 7) = (/ &
     &6.8962e-01_r8,6.0838e-01_r8,5.2688e-01_r8,4.4648e-01_r8,3.6708e-01_r8,2.8814e-01_r8, &
     &2.0859e-01_r8,1.2387e-01_r8,9.8988e-03_r8/)
      kao(:, 1, 4, 7) = (/ &
     &1.4238e+00_r8,1.2465e+00_r8,1.0693e+00_r8,8.9242e-01_r8,7.1591e-01_r8,5.3976e-01_r8, &
     &3.6322e-01_r8,1.8668e-01_r8,2.6351e-03_r8/)
      kao(:, 2, 4, 7) = (/ &
     &1.4051e+00_r8,1.2306e+00_r8,1.0566e+00_r8,8.8285e-01_r8,7.0951e-01_r8,5.3582e-01_r8, &
     &3.6165e-01_r8,1.8980e-01_r8,3.5337e-03_r8/)
      kao(:, 3, 4, 7) = (/ &
     &1.3826e+00_r8,1.2117e+00_r8,1.0413e+00_r8,8.7137e-01_r8,7.0120e-01_r8,5.3024e-01_r8, &
     &3.6085e-01_r8,1.9367e-01_r8,4.5912e-03_r8/)
      kao(:, 4, 4, 7) = (/ &
     &1.3609e+00_r8,1.1937e+00_r8,1.0271e+00_r8,8.6049e-01_r8,6.9280e-01_r8,5.2650e-01_r8, &
     &3.6231e-01_r8,1.9848e-01_r8,5.8142e-03_r8/)
      kao(:, 5, 4, 7) = (/ &
     &1.3409e+00_r8,1.1773e+00_r8,1.0140e+00_r8,8.4932e-01_r8,6.8606e-01_r8,5.2486e-01_r8, &
     &3.6482e-01_r8,2.0369e-01_r8,7.2048e-03_r8/)
      kao(:, 1, 5, 7) = (/ &
     &2.5206e+00_r8,2.2062e+00_r8,1.8917e+00_r8,1.5773e+00_r8,1.2631e+00_r8,9.4923e-01_r8, &
     &6.3588e-01_r8,3.2194e-01_r8,1.8039e-03_r8/)
      kao(:, 2, 5, 7) = (/ &
     &2.4864e+00_r8,2.1765e+00_r8,1.8669e+00_r8,1.5575e+00_r8,1.2483e+00_r8,9.3953e-01_r8, &
     &6.3051e-01_r8,3.2080e-01_r8,2.4598e-03_r8/)
      kao(:, 3, 5, 7) = (/ &
     &2.4502e+00_r8,2.1455e+00_r8,1.8410e+00_r8,1.5370e+00_r8,1.2333e+00_r8,9.2942e-01_r8, &
     &6.2403e-01_r8,3.2160e-01_r8,3.2471e-03_r8/)
      kao(:, 4, 5, 7) = (/ &
     &2.4176e+00_r8,2.1177e+00_r8,1.8181e+00_r8,1.5189e+00_r8,1.2193e+00_r8,9.1845e-01_r8, &
     &6.1937e-01_r8,3.2415e-01_r8,4.1727e-03_r8/)
      kao(:, 5, 5, 7) = (/ &
     &2.3943e+00_r8,2.0977e+00_r8,1.8015e+00_r8,1.5055e+00_r8,1.2082e+00_r8,9.1210e-01_r8, &
     &6.1892e-01_r8,3.2856e-01_r8,5.2383e-03_r8/)
      kao(:, 1, 6, 7) = (/ &
     &4.1535e+00_r8,3.6349e+00_r8,3.1163e+00_r8,2.5976e+00_r8,2.0789e+00_r8,1.5604e+00_r8, &
     &1.0424e+00_r8,5.2499e-01_r8,1.2119e-03_r8/)
      kao(:, 2, 6, 7) = (/ &
     &4.0999e+00_r8,3.5882e+00_r8,3.0765e+00_r8,2.5650e+00_r8,2.0536e+00_r8,1.5426e+00_r8, &
     &1.0319e+00_r8,5.2076e-01_r8,1.6878e-03_r8/)
      kao(:, 3, 6, 7) = (/ &
     &4.0501e+00_r8,3.5452e+00_r8,3.0400e+00_r8,2.5354e+00_r8,2.0310e+00_r8,1.5269e+00_r8, &
     &1.0226e+00_r8,5.1681e-01_r8,2.2703e-03_r8/)
      kao(:, 4, 6, 7) = (/ &
     &4.0172e+00_r8,3.5170e+00_r8,3.0163e+00_r8,2.5163e+00_r8,2.0166e+00_r8,1.5168e+00_r8, &
     &1.0153e+00_r8,5.1695e-01_r8,2.9634e-03_r8/)
      kao(:, 5, 6, 7) = (/ &
     &4.0047e+00_r8,3.5059e+00_r8,3.0081e+00_r8,2.5099e+00_r8,2.0120e+00_r8,1.5128e+00_r8, &
     &1.0149e+00_r8,5.2194e-01_r8,3.7748e-03_r8/)
      kao(:, 1, 7, 7) = (/ &
     &7.1454e+00_r8,6.2526e+00_r8,5.3597e+00_r8,4.4669e+00_r8,3.5744e+00_r8,2.6816e+00_r8, &
     &1.7891e+00_r8,8.9724e-01_r8,7.5005e-04_r8/)
      kao(:, 2, 7, 7) = (/ &
     &7.0662e+00_r8,6.1833e+00_r8,5.3006e+00_r8,4.4177e+00_r8,3.5356e+00_r8,2.6534e+00_r8, &
     &1.7715e+00_r8,8.9007e-01_r8,1.0984e-03_r8/)
      kao(:, 3, 7, 7) = (/ &
     &7.0091e+00_r8,6.1337e+00_r8,5.2586e+00_r8,4.3836e+00_r8,3.5085e+00_r8,2.6339e+00_r8, &
     &1.7596e+00_r8,8.8470e-01_r8,1.5427e-03_r8/)
      kao(:, 4, 7, 7) = (/ &
     &6.9967e+00_r8,6.1229e+00_r8,5.2499e+00_r8,4.3767e+00_r8,3.5037e+00_r8,2.6314e+00_r8, &
     &1.7589e+00_r8,8.8464e-01_r8,2.0814e-03_r8/)
      kao(:, 5, 7, 7) = (/ &
     &7.0262e+00_r8,6.1495e+00_r8,5.2733e+00_r8,4.3969e+00_r8,3.5208e+00_r8,2.6451e+00_r8, &
     &1.7672e+00_r8,8.9234e-01_r8,2.7067e-03_r8/)
      kao(:, 1, 8, 7) = (/ &
     &1.4691e+01_r8,1.2856e+01_r8,1.1019e+01_r8,9.1832e+00_r8,7.3472e+00_r8,5.5112e+00_r8, &
     &3.6752e+00_r8,1.8392e+00_r8,5.0466e-04_r8/)
      kao(:, 2, 8, 7) = (/ &
     &1.4561e+01_r8,1.2741e+01_r8,1.0922e+01_r8,9.1018e+00_r8,7.2824e+00_r8,5.4631e+00_r8, &
     &3.6434e+00_r8,1.8247e+00_r8,7.0108e-04_r8/)
      kao(:, 3, 8, 7) = (/ &
     &1.4517e+01_r8,1.2702e+01_r8,1.0889e+01_r8,9.0751e+00_r8,7.2609e+00_r8,5.4474e+00_r8, &
     &3.6338e+00_r8,1.8215e+00_r8,9.5134e-04_r8/)
      kao(:, 4, 8, 7) = (/ &
     &1.4592e+01_r8,1.2768e+01_r8,1.0945e+01_r8,9.1223e+00_r8,7.2994e+00_r8,5.4774e+00_r8, &
     &3.6552e+00_r8,1.8334e+00_r8,1.2923e-03_r8/)
      kao(:, 5, 8, 7) = (/ &
     &1.4780e+01_r8,1.2933e+01_r8,1.1086e+01_r8,9.2409e+00_r8,7.3952e+00_r8,5.5498e+00_r8, &
     &3.7048e+00_r8,1.8578e+00_r8,1.7359e-03_r8/)
      kao(:, 1, 9, 7) = (/ &
     &5.6885e+01_r8,4.9776e+01_r8,4.2665e+01_r8,3.5554e+01_r8,2.8444e+01_r8,2.1332e+01_r8, &
     &1.4224e+01_r8,7.1126e+00_r8,6.2609e-04_r8/)
      kao(:, 2, 9, 7) = (/ &
     &5.6580e+01_r8,4.9509e+01_r8,4.2436e+01_r8,3.5363e+01_r8,2.8291e+01_r8,2.1219e+01_r8, &
     &1.4147e+01_r8,7.0751e+00_r8,8.0177e-04_r8/)
      kao(:, 3, 9, 7) = (/ &
     &5.6732e+01_r8,4.9637e+01_r8,4.2548e+01_r8,3.5458e+01_r8,2.8366e+01_r8,2.1276e+01_r8, &
     &1.4184e+01_r8,7.0949e+00_r8,1.0220e-03_r8/)
      kao(:, 4, 9, 7) = (/ &
     &5.7468e+01_r8,5.0286e+01_r8,4.3101e+01_r8,3.5920e+01_r8,2.8736e+01_r8,2.1553e+01_r8, &
     &1.4371e+01_r8,7.1892e+00_r8,1.2387e-03_r8/)
      kao(:, 5, 9, 7) = (/ &
     &5.8635e+01_r8,5.1306e+01_r8,4.3977e+01_r8,3.6648e+01_r8,2.9321e+01_r8,2.1992e+01_r8, &
     &1.4665e+01_r8,7.3378e+00_r8,1.5501e-03_r8/)
      kao(:, 1,10, 7) = (/ &
     &2.4487e+02_r8,2.1424e+02_r8,1.8364e+02_r8,1.5304e+02_r8,1.2243e+02_r8,9.1825e+01_r8, &
     &6.1214e+01_r8,3.0606e+01_r8,1.7354e-03_r8/)
      kao(:, 2,10, 7) = (/ &
     &2.4490e+02_r8,2.1431e+02_r8,1.8369e+02_r8,1.5309e+02_r8,1.2247e+02_r8,9.1851e+01_r8, &
     &6.1230e+01_r8,3.0619e+01_r8,1.7748e-03_r8/)
      kao(:, 3,10, 7) = (/ &
     &2.4755e+02_r8,2.1661e+02_r8,1.8568e+02_r8,1.5472e+02_r8,1.2378e+02_r8,9.2834e+01_r8, &
     &6.1889e+01_r8,3.0945e+01_r8,1.9607e-03_r8/)
      kao(:, 4,10, 7) = (/ &
     &2.5293e+02_r8,2.2132e+02_r8,1.8970e+02_r8,1.5807e+02_r8,1.2647e+02_r8,9.4852e+01_r8, &
     &6.3238e+01_r8,3.1620e+01_r8,2.3523e-03_r8/)
      kao(:, 5,10, 7) = (/ &
     &2.5940e+02_r8,2.2699e+02_r8,1.9456e+02_r8,1.6213e+02_r8,1.2971e+02_r8,9.7282e+01_r8, &
     &6.4856e+01_r8,3.2431e+01_r8,2.7354e-03_r8/)
      kao(:, 1,11, 7) = (/ &
     &3.6899e+02_r8,3.2288e+02_r8,2.7677e+02_r8,2.3063e+02_r8,1.8452e+02_r8,1.3837e+02_r8, &
     &9.2255e+01_r8,4.6125e+01_r8,2.1265e-03_r8/)
      kao(:, 2,11, 7) = (/ &
     &3.7335e+02_r8,3.2670e+02_r8,2.8002e+02_r8,2.3334e+02_r8,1.8669e+02_r8,1.4002e+02_r8, &
     &9.3341e+01_r8,4.6674e+01_r8,3.2080e-03_r8/)
      kao(:, 3,11, 7) = (/ &
     &3.8233e+02_r8,3.3453e+02_r8,2.8674e+02_r8,2.3896e+02_r8,1.9116e+02_r8,1.4337e+02_r8, &
     &9.5577e+01_r8,4.7794e+01_r8,3.4910e-03_r8/)
      kao(:, 4,11, 7) = (/ &
     &3.9299e+02_r8,3.4383e+02_r8,2.9472e+02_r8,2.4561e+02_r8,1.9648e+02_r8,1.4736e+02_r8, &
     &9.8242e+01_r8,4.9120e+01_r8,3.8208e-03_r8/)
      kao(:, 5,11, 7) = (/ &
     &4.0483e+02_r8,3.5423e+02_r8,3.0363e+02_r8,2.5301e+02_r8,2.0242e+02_r8,1.5182e+02_r8, &
     &1.0121e+02_r8,5.0609e+01_r8,4.2123e-03_r8/)
      kao(:, 1,12, 7) = (/ &
     &4.1937e+02_r8,3.6695e+02_r8,3.1452e+02_r8,2.6211e+02_r8,2.0969e+02_r8,1.5726e+02_r8, &
     &1.0485e+02_r8,5.2423e+01_r8,2.2784e-03_r8/)
      kao(:, 2,12, 7) = (/ &
     &4.2956e+02_r8,3.7586e+02_r8,3.2216e+02_r8,2.6848e+02_r8,2.1478e+02_r8,1.6108e+02_r8, &
     &1.0739e+02_r8,5.3697e+01_r8,3.5938e-03_r8/)
      kao(:, 3,12, 7) = (/ &
     &4.4222e+02_r8,3.8693e+02_r8,3.3164e+02_r8,2.7638e+02_r8,2.2109e+02_r8,1.6582e+02_r8, &
     &1.1055e+02_r8,5.5277e+01_r8,4.4037e-03_r8/)
      kao(:, 4,12, 7) = (/ &
     &4.5624e+02_r8,3.9921e+02_r8,3.4220e+02_r8,2.8517e+02_r8,2.2812e+02_r8,1.7109e+02_r8, &
     &1.1406e+02_r8,5.7035e+01_r8,4.5266e-03_r8/)
      kao(:, 5,12, 7) = (/ &
     &4.7013e+02_r8,4.1136e+02_r8,3.5259e+02_r8,2.9384e+02_r8,2.3506e+02_r8,1.7630e+02_r8, &
     &1.1754e+02_r8,5.8765e+01_r8,5.1545e-03_r8/)
      kao(:, 1,13, 7) = (/ &
     &3.8573e+02_r8,3.3753e+02_r8,2.8932e+02_r8,2.4110e+02_r8,1.9287e+02_r8,1.4465e+02_r8, &
     &9.6435e+01_r8,4.8220e+01_r8,2.4127e-03_r8/)
      kao(:, 2,13, 7) = (/ &
     &3.9713e+02_r8,3.4748e+02_r8,2.9784e+02_r8,2.4821e+02_r8,1.9856e+02_r8,1.4893e+02_r8, &
     &9.9282e+01_r8,4.9641e+01_r8,3.8706e-03_r8/)
      kao(:, 3,13, 7) = (/ &
     &4.1029e+02_r8,3.5900e+02_r8,3.0771e+02_r8,2.5644e+02_r8,2.0514e+02_r8,1.5386e+02_r8, &
     &1.0257e+02_r8,5.1288e+01_r8,4.7695e-03_r8/)
      kao(:, 4,13, 7) = (/ &
     &4.2344e+02_r8,3.7050e+02_r8,3.1756e+02_r8,2.6463e+02_r8,2.1170e+02_r8,1.5878e+02_r8, &
     &1.0586e+02_r8,5.2932e+01_r8,4.9706e-03_r8/)
      kao(:, 5,13, 7) = (/ &
     &4.3615e+02_r8,3.8165e+02_r8,3.2713e+02_r8,2.7260e+02_r8,2.1808e+02_r8,1.6356e+02_r8, &
     &1.0904e+02_r8,5.4523e+01_r8,5.6617e-03_r8/)
      kao(:, 1, 1, 8) = (/ &
     &5.2022e-01_r8,4.5635e-01_r8,3.9252e-01_r8,3.3010e-01_r8,2.6823e-01_r8,2.0567e-01_r8, &
     &1.4452e-01_r8,8.4865e-02_r8,1.8396e-02_r8/)
      kao(:, 2, 1, 8) = (/ &
     &5.2177e-01_r8,4.5789e-01_r8,3.9474e-01_r8,3.3342e-01_r8,2.7114e-01_r8,2.1031e-01_r8, &
     &1.5104e-01_r8,9.2174e-02_r8,2.3774e-02_r8/)
      kao(:, 3, 1, 8) = (/ &
     &5.2246e-01_r8,4.5863e-01_r8,3.9708e-01_r8,3.3604e-01_r8,2.7541e-01_r8,2.1692e-01_r8, &
     &1.5876e-01_r8,9.9961e-02_r8,3.0156e-02_r8/)
      kao(:, 4, 1, 8) = (/ &
     &5.2222e-01_r8,4.5904e-01_r8,3.9936e-01_r8,3.3918e-01_r8,2.8145e-01_r8,2.2396e-01_r8, &
     &1.6789e-01_r8,1.0815e-01_r8,3.7634e-02_r8/)
      kao(:, 5, 1, 8) = (/ &
     &5.2130e-01_r8,4.5967e-01_r8,4.0135e-01_r8,3.4393e-01_r8,2.8807e-01_r8,2.3225e-01_r8, &
     &1.7760e-01_r8,1.1669e-01_r8,4.6345e-02_r8/)
      kao(:, 1, 2, 8) = (/ &
     &8.1852e-01_r8,7.1745e-01_r8,6.1633e-01_r8,5.1564e-01_r8,4.1643e-01_r8,3.1732e-01_r8, &
     &2.1786e-01_r8,1.2067e-01_r8,1.4675e-02_r8/)
      kao(:, 2, 2, 8) = (/ &
     &8.1998e-01_r8,7.1886e-01_r8,6.1787e-01_r8,5.1883e-01_r8,4.2047e-01_r8,3.2108e-01_r8, &
     &2.2369e-01_r8,1.2867e-01_r8,1.9122e-02_r8/)
      kao(:, 3, 2, 8) = (/ &
     &8.2161e-01_r8,7.2051e-01_r8,6.2063e-01_r8,5.2305e-01_r8,4.2413e-01_r8,3.2660e-01_r8, &
     &2.3145e-01_r8,1.3782e-01_r8,2.4473e-02_r8/)
      kao(:, 4, 2, 8) = (/ &
     &8.2149e-01_r8,7.2071e-01_r8,6.2301e-01_r8,5.2587e-01_r8,4.2865e-01_r8,3.3407e-01_r8, &
     &2.4032e-01_r8,1.4761e-01_r8,3.0869e-02_r8/)
      kao(:, 5, 2, 8) = (/ &
     &8.1957e-01_r8,7.1986e-01_r8,6.2436e-01_r8,5.2838e-01_r8,4.3462e-01_r8,3.4210e-01_r8, &
     &2.5070e-01_r8,1.5726e-01_r8,3.8311e-02_r8/)
      kao(:, 1, 3, 8) = (/ &
     &1.7050e+00_r8,1.4932e+00_r8,1.2814e+00_r8,1.0695e+00_r8,8.5775e-01_r8,6.4751e-01_r8, &
     &4.3833e-01_r8,2.2806e-01_r8,1.0910e-02_r8/)
      kao(:, 2, 3, 8) = (/ &
     &1.7093e+00_r8,1.4971e+00_r8,1.2848e+00_r8,1.0726e+00_r8,8.6216e-01_r8,6.5288e-01_r8, &
     &4.4261e-01_r8,2.3435e-01_r8,1.4370e-02_r8/)
      kao(:, 3, 3, 8) = (/ &
     &1.7123e+00_r8,1.5000e+00_r8,1.2874e+00_r8,1.0764e+00_r8,8.6711e-01_r8,6.5794e-01_r8, &
     &4.4842e-01_r8,2.4360e-01_r8,1.8590e-02_r8/)
      kao(:, 4, 3, 8) = (/ &
     &1.7121e+00_r8,1.4998e+00_r8,1.2880e+00_r8,1.0792e+00_r8,8.7145e-01_r8,6.6223e-01_r8, &
     &4.5614e-01_r8,2.5394e-01_r8,2.3699e-02_r8/)
      kao(:, 5, 3, 8) = (/ &
     &1.7072e+00_r8,1.4957e+00_r8,1.2869e+00_r8,1.0807e+00_r8,8.7401e-01_r8,6.6818e-01_r8, &
     &4.6582e-01_r8,2.6619e-01_r8,2.9551e-02_r8/)
      kao(:, 1, 4, 8) = (/ &
     &3.5671e+00_r8,3.1226e+00_r8,2.6780e+00_r8,2.2334e+00_r8,1.7887e+00_r8,1.3439e+00_r8, &
     &9.0030e-01_r8,4.5879e-01_r8,7.8646e-03_r8/)
      kao(:, 2, 4, 8) = (/ &
     &3.5784e+00_r8,3.1324e+00_r8,2.6867e+00_r8,2.2405e+00_r8,1.7945e+00_r8,1.3495e+00_r8, &
     &9.0658e-01_r8,4.6395e-01_r8,1.0548e-02_r8/)
      kao(:, 3, 4, 8) = (/ &
     &3.5832e+00_r8,3.1369e+00_r8,2.6902e+00_r8,2.2437e+00_r8,1.7981e+00_r8,1.3549e+00_r8, &
     &9.1305e-01_r8,4.7036e-01_r8,1.3834e-02_r8/)
      kao(:, 4, 4, 8) = (/ &
     &3.5802e+00_r8,3.1343e+00_r8,2.6882e+00_r8,2.2430e+00_r8,1.8006e+00_r8,1.3596e+00_r8, &
     &9.1785e-01_r8,4.7927e-01_r8,1.7787e-02_r8/)
      kao(:, 5, 4, 8) = (/ &
     &3.5714e+00_r8,3.1267e+00_r8,2.6827e+00_r8,2.2417e+00_r8,1.8022e+00_r8,1.3635e+00_r8, &
     &9.2392e-01_r8,4.9076e-01_r8,2.2306e-02_r8/)
      kao(:, 1, 5, 8) = (/ &
     &6.7418e+00_r8,5.9003e+00_r8,5.0587e+00_r8,4.2171e+00_r8,3.3754e+00_r8,2.5338e+00_r8, &
     &1.6921e+00_r8,8.5173e-01_r8,5.5269e-03_r8/)
      kao(:, 2, 5, 8) = (/ &
     &6.7656e+00_r8,5.9212e+00_r8,5.0765e+00_r8,4.2319e+00_r8,3.3873e+00_r8,2.5428e+00_r8, &
     &1.6990e+00_r8,8.5857e-01_r8,7.5732e-03_r8/)
      kao(:, 3, 5, 8) = (/ &
     &6.7746e+00_r8,5.9289e+00_r8,5.0835e+00_r8,4.2380e+00_r8,3.3924e+00_r8,2.5474e+00_r8, &
     &1.7057e+00_r8,8.6548e-01_r8,1.0137e-02_r8/)
      kao(:, 4, 5, 8) = (/ &
     &6.7641e+00_r8,5.9200e+00_r8,5.0759e+00_r8,4.2320e+00_r8,3.3891e+00_r8,2.5487e+00_r8, &
     &1.7099e+00_r8,8.7100e-01_r8,1.3219e-02_r8/)
      kao(:, 5, 5, 8) = (/ &
     &6.7413e+00_r8,5.9008e+00_r8,5.0606e+00_r8,4.2207e+00_r8,3.3833e+00_r8,2.5475e+00_r8, &
     &1.7128e+00_r8,8.7813e-01_r8,1.6736e-02_r8/)
      kao(:, 1, 6, 8) = (/ &
     &1.1755e+01_r8,1.0287e+01_r8,8.8182e+00_r8,7.3494e+00_r8,5.8812e+00_r8,4.4127e+00_r8, &
     &2.9442e+00_r8,1.4757e+00_r8,3.7670e-03_r8/)
      kao(:, 2, 6, 8) = (/ &
     &1.1790e+01_r8,1.0318e+01_r8,8.8444e+00_r8,7.3718e+00_r8,5.8990e+00_r8,4.4261e+00_r8, &
     &2.9535e+00_r8,1.4824e+00_r8,5.2756e-03_r8/)
      kao(:, 3, 6, 8) = (/ &
     &1.1802e+01_r8,1.0328e+01_r8,8.8538e+00_r8,7.3796e+00_r8,5.9055e+00_r8,4.4312e+00_r8, &
     &2.9580e+00_r8,1.4892e+00_r8,7.2031e-03_r8/)
      kao(:, 4, 6, 8) = (/ &
     &1.1771e+01_r8,1.0301e+01_r8,8.8310e+00_r8,7.3612e+00_r8,5.8917e+00_r8,4.4224e+00_r8, &
     &2.9568e+00_r8,1.4927e+00_r8,9.5398e-03_r8/)
      kao(:, 5, 6, 8) = (/ &
     &1.1717e+01_r8,1.0254e+01_r8,8.7912e+00_r8,7.3292e+00_r8,5.8672e+00_r8,4.4080e+00_r8, &
     &2.9504e+00_r8,1.4942e+00_r8,1.2264e-02_r8/)
      kao(:, 1, 7, 8) = (/ &
     &2.1201e+01_r8,1.8552e+01_r8,1.5902e+01_r8,1.3253e+01_r8,1.0604e+01_r8,7.9546e+00_r8, &
     &5.3049e+00_r8,2.6554e+00_r8,2.5163e-03_r8/)
      kao(:, 2, 7, 8) = (/ &
     &2.1258e+01_r8,1.8602e+01_r8,1.5945e+01_r8,1.3288e+01_r8,1.0632e+01_r8,7.9754e+00_r8, &
     &5.3196e+00_r8,2.6631e+00_r8,3.6166e-03_r8/)
      kao(:, 3, 7, 8) = (/ &
     &2.1271e+01_r8,1.8614e+01_r8,1.5957e+01_r8,1.3298e+01_r8,1.0640e+01_r8,7.9825e+00_r8, &
     &5.3244e+00_r8,2.6683e+00_r8,5.0339e-03_r8/)
      kao(:, 4, 7, 8) = (/ &
     &2.1213e+01_r8,1.8564e+01_r8,1.5913e+01_r8,1.3262e+01_r8,1.0612e+01_r8,7.9619e+00_r8, &
     &5.3122e+00_r8,2.6672e+00_r8,6.7768e-03_r8/)
      kao(:, 5, 7, 8) = (/ &
     &2.1089e+01_r8,1.8455e+01_r8,1.5820e+01_r8,1.3186e+01_r8,1.0552e+01_r8,7.9178e+00_r8, &
     &5.2873e+00_r8,2.6593e+00_r8,8.8413e-03_r8/)
      kao(:, 1, 8, 8) = (/ &
     &4.5180e+01_r8,3.9535e+01_r8,3.3887e+01_r8,2.8239e+01_r8,2.2591e+01_r8,1.6944e+01_r8, &
     &1.1298e+01_r8,5.6517e+00_r8,1.3715e-03_r8/)
      kao(:, 2, 8, 8) = (/ &
     &4.5290e+01_r8,3.9627e+01_r8,3.3969e+01_r8,2.8308e+01_r8,2.2647e+01_r8,1.6987e+01_r8, &
     &1.1327e+01_r8,5.6660e+00_r8,2.0845e-03_r8/)
      kao(:, 3, 8, 8) = (/ &
     &4.5261e+01_r8,3.9605e+01_r8,3.3948e+01_r8,2.8290e+01_r8,2.2633e+01_r8,1.6977e+01_r8, &
     &1.1320e+01_r8,5.6637e+00_r8,3.2057e-03_r8/)
      kao(:, 4, 8, 8) = (/ &
     &4.5126e+01_r8,3.9486e+01_r8,3.3848e+01_r8,2.8205e+01_r8,2.2567e+01_r8,1.6928e+01_r8, &
     &1.1288e+01_r8,5.6493e+00_r8,4.5853e-03_r8/)
      kao(:, 5, 8, 8) = (/ &
     &4.4865e+01_r8,3.9259e+01_r8,3.3651e+01_r8,2.8046e+01_r8,2.2438e+01_r8,1.6832e+01_r8, &
     &1.1226e+01_r8,5.6233e+00_r8,6.2243e-03_r8/)
      kao(:, 1, 9, 8) = (/ &
     &1.7982e+02_r8,1.5734e+02_r8,1.3487e+02_r8,1.1239e+02_r8,8.9912e+01_r8,6.7434e+01_r8, &
     &4.4957e+01_r8,2.2481e+01_r8,1.3106e-03_r8/)
      kao(:, 2, 9, 8) = (/ &
     &1.7996e+02_r8,1.5746e+02_r8,1.3497e+02_r8,1.1247e+02_r8,8.9976e+01_r8,6.7488e+01_r8, &
     &4.4992e+01_r8,2.2498e+01_r8,1.6404e-03_r8/)
      kao(:, 3, 9, 8) = (/ &
     &1.7965e+02_r8,1.5719e+02_r8,1.3473e+02_r8,1.1228e+02_r8,8.9821e+01_r8,6.7370e+01_r8, &
     &4.4914e+01_r8,2.2461e+01_r8,2.0268e-03_r8/)
      kao(:, 4, 9, 8) = (/ &
     &1.7888e+02_r8,1.5653e+02_r8,1.3416e+02_r8,1.1181e+02_r8,8.9443e+01_r8,6.7088e+01_r8, &
     &4.4727e+01_r8,2.2367e+01_r8,2.6824e-03_r8/)
      kao(:, 5, 9, 8) = (/ &
     &1.7801e+02_r8,1.5576e+02_r8,1.3351e+02_r8,1.1126e+02_r8,8.9014e+01_r8,6.6762e+01_r8, &
     &4.4512e+01_r8,2.2261e+01_r8,3.2961e-03_r8/)
      kao(:, 1,10, 8) = (/ &
     &7.9186e+02_r8,6.9285e+02_r8,5.9387e+02_r8,4.9485e+02_r8,3.9587e+02_r8,2.9692e+02_r8, &
     &1.9795e+02_r8,9.8980e+01_r8,2.6434e-03_r8/)
      kao(:, 2,10, 8) = (/ &
     &7.9156e+02_r8,6.9260e+02_r8,5.9370e+02_r8,4.9476e+02_r8,3.9580e+02_r8,2.9685e+02_r8, &
     &1.9789e+02_r8,9.8956e+01_r8,3.6689e-03_r8/)
      kao(:, 3,10, 8) = (/ &
     &7.8897e+02_r8,6.9037e+02_r8,5.9173e+02_r8,4.9309e+02_r8,3.9450e+02_r8,2.9589e+02_r8, &
     &1.9725e+02_r8,9.8635e+01_r8,4.1214e-03_r8/)
      kao(:, 4,10, 8) = (/ &
     &7.8518e+02_r8,6.8703e+02_r8,5.8889e+02_r8,4.9073e+02_r8,3.9258e+02_r8,2.9444e+02_r8, &
     &1.9631e+02_r8,9.8149e+01_r8,4.6533e-03_r8/)
      kao(:, 5,10, 8) = (/ &
     &7.8271e+02_r8,6.8490e+02_r8,5.8707e+02_r8,4.8922e+02_r8,3.9137e+02_r8,2.9354e+02_r8, &
     &1.9568e+02_r8,9.7851e+01_r8,5.3114e-03_r8/)
      kao(:, 1,11, 8) = (/ &
     &1.2023e+03_r8,1.0521e+03_r8,9.0173e+02_r8,7.5144e+02_r8,6.0116e+02_r8,4.5091e+02_r8, &
     &3.0058e+02_r8,1.5029e+02_r8,2.8585e-03_r8/)
      kao(:, 2,11, 8) = (/ &
     &1.1987e+03_r8,1.0489e+03_r8,8.9906e+02_r8,7.4919e+02_r8,5.9938e+02_r8,4.4951e+02_r8, &
     &2.9969e+02_r8,1.4984e+02_r8,4.2381e-03_r8/)
      kao(:, 3,11, 8) = (/ &
     &1.1938e+03_r8,1.0446e+03_r8,8.9539e+02_r8,7.4611e+02_r8,5.9694e+02_r8,4.4768e+02_r8, &
     &2.9847e+02_r8,1.4923e+02_r8,6.1776e-03_r8/)
      kao(:, 4,11, 8) = (/ &
     &1.1919e+03_r8,1.0429e+03_r8,8.9396e+02_r8,7.4498e+02_r8,5.9597e+02_r8,4.4698e+02_r8, &
     &2.9797e+02_r8,1.4900e+02_r8,6.8124e-03_r8/)
      kao(:, 5,11, 8) = (/ &
     &1.1943e+03_r8,1.0450e+03_r8,8.9567e+02_r8,7.4646e+02_r8,5.9716e+02_r8,4.4786e+02_r8, &
     &2.9857e+02_r8,1.4929e+02_r8,7.2330e-03_r8/)
      kao(:, 1,12, 8) = (/ &
     &1.3468e+03_r8,1.1784e+03_r8,1.0101e+03_r8,8.4170e+02_r8,6.7334e+02_r8,5.0503e+02_r8, &
     &3.3668e+02_r8,1.6834e+02_r8,3.2180e-03_r8/)
      kao(:, 2,12, 8) = (/ &
     &1.3417e+03_r8,1.1740e+03_r8,1.0062e+03_r8,8.3855e+02_r8,6.7082e+02_r8,5.0314e+02_r8, &
     &3.3541e+02_r8,1.6772e+02_r8,4.6846e-03_r8/)
      kao(:, 3,12, 8) = (/ &
     &1.3409e+03_r8,1.1734e+03_r8,1.0058e+03_r8,8.3814e+02_r8,6.7048e+02_r8,5.0287e+02_r8, &
     &3.3524e+02_r8,1.6763e+02_r8,6.5606e-03_r8/)
      kao(:, 4,12, 8) = (/ &
     &1.3471e+03_r8,1.1787e+03_r8,1.0103e+03_r8,8.4192e+02_r8,6.7354e+02_r8,5.0515e+02_r8, &
     &3.3677e+02_r8,1.6839e+02_r8,8.6936e-03_r8/)
      kao(:, 5,12, 8) = (/ &
     &1.3615e+03_r8,1.1913e+03_r8,1.0211e+03_r8,8.5093e+02_r8,6.8072e+02_r8,5.1056e+02_r8, &
     &3.4035e+02_r8,1.7018e+02_r8,9.2918e-03_r8/)
      kao(:, 1,13, 8) = (/ &
     &1.2096e+03_r8,1.0584e+03_r8,9.0717e+02_r8,7.5599e+02_r8,6.0478e+02_r8,4.5359e+02_r8, &
     &3.0240e+02_r8,1.5119e+02_r8,3.1447e-03_r8/)
      kao(:, 2,13, 8) = (/ &
     &1.2095e+03_r8,1.0583e+03_r8,9.0711e+02_r8,7.5597e+02_r8,6.0474e+02_r8,4.5355e+02_r8, &
     &3.0238e+02_r8,1.5119e+02_r8,4.9163e-03_r8/)
      kao(:, 3,13, 8) = (/ &
     &1.2161e+03_r8,1.0641e+03_r8,9.1208e+02_r8,7.6006e+02_r8,6.0804e+02_r8,4.5603e+02_r8, &
     &3.0401e+02_r8,1.5201e+02_r8,6.8865e-03_r8/)
      kao(:, 4,13, 8) = (/ &
     &1.2328e+03_r8,1.0787e+03_r8,9.2458e+02_r8,7.7050e+02_r8,6.1637e+02_r8,4.6230e+02_r8, &
     &3.0819e+02_r8,1.5410e+02_r8,9.4613e-03_r8/)
      kao(:, 5,13, 8) = (/ &
     &1.2601e+03_r8,1.1026e+03_r8,9.4505e+02_r8,7.8755e+02_r8,6.3004e+02_r8,4.7254e+02_r8, &
     &3.1501e+02_r8,1.5751e+02_r8,1.0283e-02_r8/)
      kao(:, 1, 1, 9) = (/ &
     &1.0370e+00_r8,9.0857e-01_r8,7.8023e-01_r8,6.5192e-01_r8,5.2457e-01_r8,4.0025e-01_r8, &
     &2.7828e-01_r8,1.5804e-01_r8,5.8897e-02_r8/)
      kao(:, 2, 1, 9) = (/ &
     &1.0492e+00_r8,9.1962e-01_r8,7.9014e-01_r8,6.6101e-01_r8,5.3535e-01_r8,4.1219e-01_r8, &
     &2.9064e-01_r8,1.7381e-01_r8,7.6414e-02_r8/)
      kao(:, 3, 1, 9) = (/ &
     &1.0617e+00_r8,9.3102e-01_r8,8.0032e-01_r8,6.7200e-01_r8,5.4761e-01_r8,4.2620e-01_r8, &
     &3.0674e-01_r8,1.9538e-01_r8,9.6701e-02_r8/)
      kao(:, 4, 1, 9) = (/ &
     &1.0715e+00_r8,9.3980e-01_r8,8.0850e-01_r8,6.8264e-01_r8,5.6043e-01_r8,4.4205e-01_r8, &
     &3.2592e-01_r8,2.2229e-01_r8,1.1943e-01_r8/)
      kao(:, 5, 1, 9) = (/ &
     &1.0801e+00_r8,9.4751e-01_r8,8.1733e-01_r8,6.9368e-01_r8,5.7613e-01_r8,4.6079e-01_r8, &
     &3.5014e-01_r8,2.5319e-01_r8,1.4487e-01_r8/)
      kao(:, 1, 2, 9) = (/ &
     &1.7442e+00_r8,1.5272e+00_r8,1.3102e+00_r8,1.0933e+00_r8,8.7649e-01_r8,6.6091e-01_r8, &
     &4.4902e-01_r8,2.3891e-01_r8,5.2362e-02_r8/)
      kao(:, 2, 2, 9) = (/ &
     &1.7617e+00_r8,1.5427e+00_r8,1.3238e+00_r8,1.1049e+00_r8,8.8687e-01_r8,6.7276e-01_r8, &
     &4.6180e-01_r8,2.5188e-01_r8,6.8691e-02_r8/)
      kao(:, 3, 2, 9) = (/ &
     &1.7768e+00_r8,1.5563e+00_r8,1.3359e+00_r8,1.1155e+00_r8,8.9933e-01_r8,6.8666e-01_r8, &
     &4.7568e-01_r8,2.6925e-01_r8,8.7599e-02_r8/)
      kao(:, 4, 2, 9) = (/ &
     &1.7902e+00_r8,1.5683e+00_r8,1.3467e+00_r8,1.1272e+00_r8,9.1292e-01_r8,7.0212e-01_r8, &
     &4.9313e-01_r8,2.9218e-01_r8,1.0892e-01_r8/)
      kao(:, 5, 2, 9) = (/ &
     &1.8007e+00_r8,1.5781e+00_r8,1.3558e+00_r8,1.1390e+00_r8,9.2668e-01_r8,7.1895e-01_r8, &
     &5.1345e-01_r8,3.2009e-01_r8,1.3290e-01_r8/)
      kao(:, 1, 3, 9) = (/ &
     &3.9769e+00_r8,3.4805e+00_r8,2.9839e+00_r8,2.4875e+00_r8,1.9912e+00_r8,1.4948e+00_r8, &
     &9.9892e-01_r8,5.0928e-01_r8,4.2777e-02_r8/)
      kao(:, 2, 3, 9) = (/ &
     &4.0084e+00_r8,3.5082e+00_r8,3.0084e+00_r8,2.5082e+00_r8,2.0082e+00_r8,1.5084e+00_r8, &
     &1.0123e+00_r8,5.2189e-01_r8,5.7041e-02_r8/)
      kao(:, 3, 3, 9) = (/ &
     &4.0345e+00_r8,3.5316e+00_r8,3.0286e+00_r8,2.5259e+00_r8,2.0232e+00_r8,1.5223e+00_r8, &
     &1.0275e+00_r8,5.3508e-01_r8,7.3780e-02_r8/)
      kao(:, 4, 3, 9) = (/ &
     &4.0588e+00_r8,3.5535e+00_r8,3.0482e+00_r8,2.5430e+00_r8,2.0380e+00_r8,1.5389e+00_r8, &
     &1.0447e+00_r8,5.5284e-01_r8,9.2939e-02_r8/)
      kao(:, 5, 3, 9) = (/ &
     &4.0766e+00_r8,3.5694e+00_r8,3.0624e+00_r8,2.5553e+00_r8,2.0517e+00_r8,1.5545e+00_r8, &
     &1.0614e+00_r8,5.7409e-01_r8,1.1487e-01_r8/)
      kao(:, 1, 4, 9) = (/ &
     &9.2347e+00_r8,8.0808e+00_r8,6.9267e+00_r8,5.7730e+00_r8,4.6191e+00_r8,3.4653e+00_r8, &
     &2.3115e+00_r8,1.1586e+00_r8,3.3639e-02_r8/)
      kao(:, 2, 4, 9) = (/ &
     &9.3231e+00_r8,8.1587e+00_r8,6.9942e+00_r8,5.8295e+00_r8,4.6650e+00_r8,3.5006e+00_r8, &
     &2.3364e+00_r8,1.1757e+00_r8,4.5584e-02_r8/)
      kao(:, 3, 4, 9) = (/ &
     &9.3883e+00_r8,8.2160e+00_r8,7.0435e+00_r8,5.8714e+00_r8,4.6992e+00_r8,3.5271e+00_r8, &
     &2.3555e+00_r8,1.1930e+00_r8,5.9759e-02_r8/)
      kao(:, 4, 4, 9) = (/ &
     &9.4383e+00_r8,8.2599e+00_r8,7.0821e+00_r8,5.9042e+00_r8,4.7261e+00_r8,3.5482e+00_r8, &
     &2.3742e+00_r8,1.2110e+00_r8,7.6294e-02_r8/)
      kao(:, 5, 4, 9) = (/ &
     &9.4750e+00_r8,8.2926e+00_r8,7.1106e+00_r8,5.9283e+00_r8,4.7463e+00_r8,3.5648e+00_r8, &
     &2.3926e+00_r8,1.2283e+00_r8,9.5542e-02_r8/)
      kao(:, 1, 5, 9) = (/ &
     &1.9585e+01_r8,1.7137e+01_r8,1.4689e+01_r8,1.2242e+01_r8,9.7941e+00_r8,7.3465e+00_r8, &
     &4.8988e+00_r8,2.4515e+00_r8,2.6102e-02_r8/)
      kao(:, 2, 5, 9) = (/ &
     &1.9780e+01_r8,1.7309e+01_r8,1.4837e+01_r8,1.2365e+01_r8,9.8932e+00_r8,7.4216e+00_r8, &
     &4.9500e+00_r8,2.4789e+00_r8,3.5859e-02_r8/)
      kao(:, 3, 5, 9) = (/ &
     &1.9935e+01_r8,1.7444e+01_r8,1.4954e+01_r8,1.2463e+01_r8,9.9721e+00_r8,7.4814e+00_r8, &
     &4.9911e+00_r8,2.5017e+00_r8,4.7575e-02_r8/)
      kao(:, 4, 5, 9) = (/ &
     &2.0051e+01_r8,1.7546e+01_r8,1.5041e+01_r8,1.2537e+01_r8,1.0032e+01_r8,7.5273e+00_r8, &
     &5.0227e+00_r8,2.5239e+00_r8,6.1484e-02_r8/)
      kao(:, 5, 5, 9) = (/ &
     &2.0135e+01_r8,1.7620e+01_r8,1.5106e+01_r8,1.2591e+01_r8,1.0076e+01_r8,7.5609e+00_r8, &
     &5.0463e+00_r8,2.5450e+00_r8,7.7952e-02_r8/)
      kao(:, 1, 6, 9) = (/ &
     &3.8631e+01_r8,3.3801e+01_r8,2.8974e+01_r8,2.4144e+01_r8,1.9316e+01_r8,1.4488e+01_r8, &
     &9.6597e+00_r8,4.8315e+00_r8,1.9604e-02_r8/)
      kao(:, 2, 6, 9) = (/ &
     &3.9022e+01_r8,3.4145e+01_r8,2.9268e+01_r8,2.4390e+01_r8,1.9513e+01_r8,1.4636e+01_r8, &
     &9.7595e+00_r8,4.8831e+00_r8,2.7435e-02_r8/)
      kao(:, 3, 6, 9) = (/ &
     &3.9348e+01_r8,3.4431e+01_r8,2.9514e+01_r8,2.4596e+01_r8,1.9679e+01_r8,1.4761e+01_r8, &
     &9.8442e+00_r8,4.9267e+00_r8,3.6949e-02_r8/)
      kao(:, 4, 6, 9) = (/ &
     &3.9594e+01_r8,3.4646e+01_r8,2.9698e+01_r8,2.4751e+01_r8,1.9803e+01_r8,1.4855e+01_r8, &
     &9.9079e+00_r8,4.9603e+00_r8,4.8442e-02_r8/)
      kao(:, 5, 6, 9) = (/ &
     &3.9770e+01_r8,3.4801e+01_r8,2.9832e+01_r8,2.4862e+01_r8,1.9893e+01_r8,1.4924e+01_r8, &
     &9.9544e+00_r8,4.9871e+00_r8,6.2169e-02_r8/)
      kao(:, 1, 7, 9) = (/ &
     &7.9230e+01_r8,6.9326e+01_r8,5.9424e+01_r8,4.9520e+01_r8,3.9617e+01_r8,2.9713e+01_r8, &
     &1.9810e+01_r8,9.9063e+00_r8,1.4333e-02_r8/)
      kao(:, 2, 7, 9) = (/ &
     &8.0053e+01_r8,7.0047e+01_r8,6.0041e+01_r8,5.0034e+01_r8,4.0029e+01_r8,3.0023e+01_r8, &
     &2.0018e+01_r8,1.0011e+01_r8,2.0474e-02_r8/)
      kao(:, 3, 7, 9) = (/ &
     &8.0747e+01_r8,7.0654e+01_r8,6.0562e+01_r8,5.0470e+01_r8,4.0378e+01_r8,3.0286e+01_r8, &
     &2.0193e+01_r8,1.0101e+01_r8,2.8098e-02_r8/)
      kao(:, 4, 7, 9) = (/ &
     &8.1303e+01_r8,7.1142e+01_r8,6.0980e+01_r8,5.0819e+01_r8,4.0658e+01_r8,3.0496e+01_r8, &
     &2.0334e+01_r8,1.0173e+01_r8,3.7439e-02_r8/)
      kao(:, 5, 7, 9) = (/ &
     &8.1680e+01_r8,7.1472e+01_r8,6.1265e+01_r8,5.1057e+01_r8,4.0847e+01_r8,3.0638e+01_r8, &
     &2.0431e+01_r8,1.0223e+01_r8,4.8718e-02_r8/)
      kao(:, 1, 8, 9) = (/ &
     &1.9140e+02_r8,1.6747e+02_r8,1.4355e+02_r8,1.1962e+02_r8,9.5701e+01_r8,7.1775e+01_r8, &
     &4.7850e+01_r8,2.3927e+01_r8,1.0137e-02_r8/)
      kao(:, 2, 8, 9) = (/ &
     &1.9353e+02_r8,1.6934e+02_r8,1.4515e+02_r8,1.2096e+02_r8,9.6769e+01_r8,7.2577e+01_r8, &
     &4.8385e+01_r8,2.4195e+01_r8,1.4960e-02_r8/)
      kao(:, 3, 8, 9) = (/ &
     &1.9528e+02_r8,1.7086e+02_r8,1.4646e+02_r8,1.2205e+02_r8,9.7642e+01_r8,7.3231e+01_r8, &
     &4.8824e+01_r8,2.4416e+01_r8,2.0883e-02_r8/)
      kao(:, 4, 8, 9) = (/ &
     &1.9672e+02_r8,1.7213e+02_r8,1.4754e+02_r8,1.2295e+02_r8,9.8361e+01_r8,7.3773e+01_r8, &
     &4.9186e+01_r8,2.4598e+01_r8,2.8267e-02_r8/)
      kao(:, 5, 8, 9) = (/ &
     &1.9763e+02_r8,1.7293e+02_r8,1.4824e+02_r8,1.2352e+02_r8,9.8820e+01_r8,7.4120e+01_r8, &
     &4.9417e+01_r8,2.4716e+01_r8,3.7324e-02_r8/)
      kao(:, 1, 9, 9) = (/ &
     &8.5696e+02_r8,7.4986e+02_r8,6.4272e+02_r8,5.3561e+02_r8,4.2849e+02_r8,3.2137e+02_r8, &
     &2.1425e+02_r8,1.0712e+02_r8,4.9710e-03_r8/)
      kao(:, 2, 9, 9) = (/ &
     &8.6661e+02_r8,7.5827e+02_r8,6.4996e+02_r8,5.4164e+02_r8,4.3331e+02_r8,3.2498e+02_r8, &
     &2.1666e+02_r8,1.0833e+02_r8,7.7324e-03_r8/)
      kao(:, 3, 9, 9) = (/ &
     &8.7472e+02_r8,7.6537e+02_r8,6.5602e+02_r8,5.4669e+02_r8,4.3735e+02_r8,3.2801e+02_r8, &
     &2.1868e+02_r8,1.0935e+02_r8,1.2302e-02_r8/)
      kao(:, 4, 9, 9) = (/ &
     &8.8128e+02_r8,7.7113e+02_r8,6.6095e+02_r8,5.5081e+02_r8,4.4064e+02_r8,3.3048e+02_r8, &
     &2.2033e+02_r8,1.1017e+02_r8,1.8205e-02_r8/)
      kao(:, 5, 9, 9) = (/ &
     &8.8594e+02_r8,7.7518e+02_r8,6.6448e+02_r8,5.5372e+02_r8,4.4298e+02_r8,3.3223e+02_r8, &
     &2.2150e+02_r8,1.1076e+02_r8,2.5853e-02_r8/)
      kao(:, 1,10, 9) = (/ &
     &4.2110e+03_r8,3.6847e+03_r8,3.1582e+03_r8,2.6319e+03_r8,2.1055e+03_r8,1.5792e+03_r8, &
     &1.0527e+03_r8,5.2637e+02_r8,5.0235e-03_r8/)
      kao(:, 2,10, 9) = (/ &
     &4.2578e+03_r8,3.7256e+03_r8,3.1934e+03_r8,2.6613e+03_r8,2.1289e+03_r8,1.5967e+03_r8, &
     &1.0645e+03_r8,5.3224e+02_r8,7.3952e-03_r8/)
      kao(:, 3,10, 9) = (/ &
     &4.2976e+03_r8,3.7604e+03_r8,3.2232e+03_r8,2.6860e+03_r8,2.1488e+03_r8,1.6116e+03_r8, &
     &1.0744e+03_r8,5.3720e+02_r8,1.0255e-02_r8/)
      kao(:, 4,10, 9) = (/ &
     &4.3279e+03_r8,3.7869e+03_r8,3.2460e+03_r8,2.7049e+03_r8,2.1640e+03_r8,1.6230e+03_r8, &
     &1.0820e+03_r8,5.4099e+02_r8,1.2154e-02_r8/)
      kao(:, 5,10, 9) = (/ &
     &4.3496e+03_r8,3.8060e+03_r8,3.2622e+03_r8,2.7186e+03_r8,2.1748e+03_r8,1.6311e+03_r8, &
     &1.0874e+03_r8,5.4372e+02_r8,1.4719e-02_r8/)
      kao(:, 1,11, 9) = (/ &
     &7.1173e+03_r8,6.2277e+03_r8,5.3380e+03_r8,4.4482e+03_r8,3.5586e+03_r8,2.6690e+03_r8, &
     &1.7793e+03_r8,8.8967e+02_r8,4.7950e-03_r8/)
      kao(:, 2,11, 9) = (/ &
     &7.1866e+03_r8,6.2881e+03_r8,5.3900e+03_r8,4.4917e+03_r8,3.5933e+03_r8,2.6950e+03_r8, &
     &1.7967e+03_r8,8.9836e+02_r8,1.0381e-02_r8/)
      kao(:, 3,11, 9) = (/ &
     &7.2420e+03_r8,6.3363e+03_r8,5.4313e+03_r8,4.5262e+03_r8,3.6209e+03_r8,2.7156e+03_r8, &
     &1.8104e+03_r8,9.0520e+02_r8,1.1192e-02_r8/)
      kao(:, 4,11, 9) = (/ &
     &7.2818e+03_r8,6.3715e+03_r8,5.4613e+03_r8,4.5511e+03_r8,3.6409e+03_r8,2.7307e+03_r8, &
     &1.8205e+03_r8,9.1025e+02_r8,1.5145e-02_r8/)
      kao(:, 5,11, 9) = (/ &
     &7.3078e+03_r8,6.3944e+03_r8,5.4808e+03_r8,4.5675e+03_r8,3.6540e+03_r8,2.7404e+03_r8, &
     &1.8270e+03_r8,9.1351e+02_r8,1.9391e-02_r8/)
      kao(:, 1,12, 9) = (/ &
     &8.7768e+03_r8,7.6797e+03_r8,6.5826e+03_r8,5.4853e+03_r8,4.3884e+03_r8,3.2912e+03_r8, &
     &2.1942e+03_r8,1.0970e+03_r8,4.5625e-03_r8/)
      kao(:, 2,12, 9) = (/ &
     &8.8507e+03_r8,7.7442e+03_r8,6.6378e+03_r8,5.5316e+03_r8,4.4251e+03_r8,3.3189e+03_r8, &
     &2.2126e+03_r8,1.1063e+03_r8,8.7877e-03_r8/)
      kao(:, 3,12, 9) = (/ &
     &8.9020e+03_r8,7.7891e+03_r8,6.6765e+03_r8,5.5638e+03_r8,4.4512e+03_r8,3.3383e+03_r8, &
     &2.2256e+03_r8,1.1128e+03_r8,1.5209e-02_r8/)
      kao(:, 4,12, 9) = (/ &
     &8.9305e+03_r8,7.8144e+03_r8,6.6981e+03_r8,5.5817e+03_r8,4.4653e+03_r8,3.3489e+03_r8, &
     &2.2326e+03_r8,1.1163e+03_r8,1.7795e-02_r8/)
      kao(:, 5,12, 9) = (/ &
     &8.9442e+03_r8,7.8262e+03_r8,6.7079e+03_r8,5.5901e+03_r8,4.4720e+03_r8,3.3539e+03_r8, &
     &2.2360e+03_r8,1.1180e+03_r8,2.1474e-02_r8/)
      kao(:, 1,13, 9) = (/ &
     &8.5284e+03_r8,7.4622e+03_r8,6.3962e+03_r8,5.3302e+03_r8,4.2643e+03_r8,3.1981e+03_r8, &
     &2.1321e+03_r8,1.0660e+03_r8,6.4304e-03_r8/)
      kao(:, 2,13, 9) = (/ &
     &8.5795e+03_r8,7.5072e+03_r8,6.4348e+03_r8,5.3623e+03_r8,4.2900e+03_r8,3.2173e+03_r8, &
     &2.1449e+03_r8,1.0725e+03_r8,8.8022e-03_r8/)
      kao(:, 3,13, 9) = (/ &
     &8.6101e+03_r8,7.5338e+03_r8,6.4575e+03_r8,5.3813e+03_r8,4.3050e+03_r8,3.2288e+03_r8, &
     &2.1525e+03_r8,1.0763e+03_r8,1.7025e-02_r8/)
      kao(:, 4,13, 9) = (/ &
     &8.6267e+03_r8,7.5481e+03_r8,6.4701e+03_r8,5.3916e+03_r8,4.3132e+03_r8,3.2351e+03_r8, &
     &2.1567e+03_r8,1.0783e+03_r8,2.0223e-02_r8/)
      kao(:, 5,13, 9) = (/ &
     &8.6229e+03_r8,7.5451e+03_r8,6.4669e+03_r8,5.3892e+03_r8,4.3114e+03_r8,3.2335e+03_r8, &
     &2.1558e+03_r8,1.0779e+03_r8,2.3841e-02_r8/)
      kao(:, 1, 1,10) = (/ &
     &3.0277e+00_r8,2.6495e+00_r8,2.2716e+00_r8,1.8933e+00_r8,1.5153e+00_r8,1.1372e+00_r8, &
     &7.5951e-01_r8,4.2431e-01_r8,1.1653e-01_r8/)
      kao(:, 2, 1,10) = (/ &
     &3.0877e+00_r8,2.7021e+00_r8,2.3167e+00_r8,1.9311e+00_r8,1.5454e+00_r8,1.1599e+00_r8, &
     &7.9480e-01_r8,4.6158e-01_r8,1.5133e-01_r8/)
      kao(:, 3, 1,10) = (/ &
     &3.1443e+00_r8,2.7514e+00_r8,2.3589e+00_r8,1.9665e+00_r8,1.5738e+00_r8,1.1839e+00_r8, &
     &8.4936e-01_r8,4.8883e-01_r8,1.8963e-01_r8/)
      kao(:, 4, 1,10) = (/ &
     &3.1902e+00_r8,2.7921e+00_r8,2.3935e+00_r8,1.9952e+00_r8,1.5971e+00_r8,1.2268e+00_r8, &
     &8.9927e-01_r8,5.1426e-01_r8,2.3885e-01_r8/)
      kao(:, 5, 1,10) = (/ &
     &3.2311e+00_r8,2.8275e+00_r8,2.4242e+00_r8,2.0206e+00_r8,1.6182e+00_r8,1.2846e+00_r8, &
     &9.3468e-01_r8,5.5470e-01_r8,2.9337e-01_r8/)
      kao(:, 1, 2,10) = (/ &
     &4.5362e+00_r8,3.9696e+00_r8,3.4027e+00_r8,2.8358e+00_r8,2.2692e+00_r8,1.7025e+00_r8, &
     &1.1358e+00_r8,5.9446e-01_r8,1.1450e-01_r8/)
      kao(:, 2, 2,10) = (/ &
     &4.6490e+00_r8,4.0681e+00_r8,3.4874e+00_r8,2.9068e+00_r8,2.3258e+00_r8,1.7450e+00_r8, &
     &1.1656e+00_r8,6.4847e-01_r8,1.4911e-01_r8/)
      kao(:, 3, 2,10) = (/ &
     &4.7559e+00_r8,4.1617e+00_r8,3.5676e+00_r8,2.9735e+00_r8,2.3793e+00_r8,1.7851e+00_r8, &
     &1.2174e+00_r8,6.9018e-01_r8,1.9066e-01_r8/)
      kao(:, 4, 2,10) = (/ &
     &4.8499e+00_r8,4.2438e+00_r8,3.6378e+00_r8,3.0322e+00_r8,2.4263e+00_r8,1.8213e+00_r8, &
     &1.2864e+00_r8,7.2155e-01_r8,2.3838e-01_r8/)
      kao(:, 5, 2,10) = (/ &
     &4.9283e+00_r8,4.3130e+00_r8,3.6972e+00_r8,3.0815e+00_r8,2.4657e+00_r8,1.8737e+00_r8, &
     &1.3480e+00_r8,7.6180e-01_r8,2.9224e-01_r8/)
      kao(:, 1, 3,10) = (/ &
     &9.1512e+00_r8,8.0077e+00_r8,6.8647e+00_r8,5.7202e+00_r8,4.5764e+00_r8,3.4330e+00_r8, &
     &2.2893e+00_r8,1.1456e+00_r8,1.0238e-01_r8/)
      kao(:, 2, 3,10) = (/ &
     &9.4295e+00_r8,8.2512e+00_r8,7.0726e+00_r8,5.8941e+00_r8,4.7160e+00_r8,3.5376e+00_r8, &
     &2.3591e+00_r8,1.1894e+00_r8,1.3683e-01_r8/)
      kao(:, 3, 3,10) = (/ &
     &9.6929e+00_r8,8.4812e+00_r8,7.2704e+00_r8,6.0594e+00_r8,4.8479e+00_r8,3.6364e+00_r8, &
     &2.4250e+00_r8,1.2581e+00_r8,1.7750e-01_r8/)
      kao(:, 4, 3,10) = (/ &
     &9.9289e+00_r8,8.6885e+00_r8,7.4477e+00_r8,6.2066e+00_r8,4.9652e+00_r8,3.7251e+00_r8, &
     &2.4842e+00_r8,1.3376e+00_r8,2.2412e-01_r8/)
      kao(:, 5, 3,10) = (/ &
     &1.0116e+01_r8,8.8511e+00_r8,7.5880e+00_r8,6.3233e+00_r8,5.0592e+00_r8,3.7951e+00_r8, &
     &2.5511e+00_r8,1.3941e+00_r8,2.7545e-01_r8/)
      kao(:, 1, 4,10) = (/ &
     &1.9425e+01_r8,1.6997e+01_r8,1.4568e+01_r8,1.2141e+01_r8,9.7127e+00_r8,7.2856e+00_r8, &
     &4.8569e+00_r8,2.4292e+00_r8,8.5208e-02_r8/)
      kao(:, 2, 4,10) = (/ &
     &1.9954e+01_r8,1.7460e+01_r8,1.4965e+01_r8,1.2471e+01_r8,9.9767e+00_r8,7.4831e+00_r8, &
     &4.9893e+00_r8,2.4954e+00_r8,1.1708e-01_r8/)
      kao(:, 3, 4,10) = (/ &
     &2.0423e+01_r8,1.7870e+01_r8,1.5318e+01_r8,1.2764e+01_r8,1.0212e+01_r8,7.6596e+00_r8, &
     &5.1068e+00_r8,2.5544e+00_r8,1.5673e-01_r8/)
      kao(:, 4, 4,10) = (/ &
     &2.0864e+01_r8,1.8257e+01_r8,1.5649e+01_r8,1.3042e+01_r8,1.0433e+01_r8,7.8250e+00_r8, &
     &5.2173e+00_r8,2.6098e+00_r8,2.0293e-01_r8/)
      kao(:, 5, 4,10) = (/ &
     &2.1248e+01_r8,1.8592e+01_r8,1.5938e+01_r8,1.3281e+01_r8,1.0624e+01_r8,7.9692e+00_r8, &
     &5.3131e+00_r8,2.6931e+00_r8,2.5421e-01_r8/)
      kao(:, 1, 5,10) = (/ &
     &4.0147e+01_r8,3.5130e+01_r8,3.0111e+01_r8,2.5093e+01_r8,2.0073e+01_r8,1.5056e+01_r8, &
     &1.0038e+01_r8,5.0189e+00_r8,6.8359e-02_r8/)
      kao(:, 2, 5,10) = (/ &
     &4.0924e+01_r8,3.5810e+01_r8,3.0692e+01_r8,2.5576e+01_r8,2.0461e+01_r8,1.5346e+01_r8, &
     &1.0232e+01_r8,5.1160e+00_r8,9.6926e-02_r8/)
      kao(:, 3, 5,10) = (/ &
     &4.1536e+01_r8,3.6343e+01_r8,3.1153e+01_r8,2.5962e+01_r8,2.0769e+01_r8,1.5577e+01_r8, &
     &1.0385e+01_r8,5.1928e+00_r8,1.3304e-01_r8/)
      kao(:, 4, 5,10) = (/ &
     &4.2166e+01_r8,3.6896e+01_r8,3.1624e+01_r8,2.6353e+01_r8,2.1083e+01_r8,1.5813e+01_r8, &
     &1.0542e+01_r8,5.2715e+00_r8,1.7579e-01_r8/)
      kao(:, 5, 5,10) = (/ &
     &4.2771e+01_r8,3.7425e+01_r8,3.2079e+01_r8,2.6732e+01_r8,2.1385e+01_r8,1.6040e+01_r8, &
     &1.0693e+01_r8,5.3473e+00_r8,2.2393e-01_r8/)
      kao(:, 1, 6,10) = (/ &
     &8.0027e+01_r8,7.0022e+01_r8,6.0023e+01_r8,5.0019e+01_r8,4.0013e+01_r8,3.0011e+01_r8, &
     &2.0007e+01_r8,1.0004e+01_r8,5.3924e-02_r8/)
      kao(:, 2, 6,10) = (/ &
     &8.1173e+01_r8,7.1024e+01_r8,6.0878e+01_r8,5.0731e+01_r8,4.0584e+01_r8,3.0439e+01_r8, &
     &2.0293e+01_r8,1.0147e+01_r8,7.8165e-02_r8/)
      kao(:, 3, 6,10) = (/ &
     &8.2280e+01_r8,7.1996e+01_r8,6.1710e+01_r8,5.1425e+01_r8,4.1141e+01_r8,3.0855e+01_r8, &
     &2.0570e+01_r8,1.0285e+01_r8,1.0934e-01_r8/)
      kao(:, 4, 6,10) = (/ &
     &8.3115e+01_r8,7.2722e+01_r8,6.2336e+01_r8,5.1947e+01_r8,4.1558e+01_r8,3.1167e+01_r8, &
     &2.0778e+01_r8,1.0390e+01_r8,1.4595e-01_r8/)
      kao(:, 5, 6,10) = (/ &
     &8.3819e+01_r8,7.3349e+01_r8,6.2867e+01_r8,5.2391e+01_r8,4.1913e+01_r8,3.1434e+01_r8, &
     &2.0957e+01_r8,1.0479e+01_r8,1.8806e-01_r8/)
      kao(:, 1, 7,10) = (/ &
     &1.6996e+02_r8,1.4871e+02_r8,1.2747e+02_r8,1.0622e+02_r8,8.4977e+01_r8,6.3734e+01_r8, &
     &4.2490e+01_r8,2.1246e+01_r8,4.2588e-02_r8/)
      kao(:, 2, 7,10) = (/ &
     &1.7243e+02_r8,1.5088e+02_r8,1.2932e+02_r8,1.0776e+02_r8,8.6211e+01_r8,6.4660e+01_r8, &
     &4.3106e+01_r8,2.1553e+01_r8,6.2851e-02_r8/)
      kao(:, 3, 7,10) = (/ &
     &1.7457e+02_r8,1.5274e+02_r8,1.3092e+02_r8,1.0910e+02_r8,8.7283e+01_r8,6.5459e+01_r8, &
     &4.3641e+01_r8,2.1821e+01_r8,8.8704e-02_r8/)
      kao(:, 4, 7,10) = (/ &
     &1.7636e+02_r8,1.5432e+02_r8,1.3227e+02_r8,1.1023e+02_r8,8.8183e+01_r8,6.6138e+01_r8, &
     &4.4090e+01_r8,2.2046e+01_r8,1.1966e-01_r8/)
      kao(:, 5, 7,10) = (/ &
     &1.7764e+02_r8,1.5544e+02_r8,1.3323e+02_r8,1.1102e+02_r8,8.8816e+01_r8,6.6613e+01_r8, &
     &4.4410e+01_r8,2.2206e+01_r8,1.5600e-01_r8/)
      kao(:, 1, 8,10) = (/ &
     &4.3531e+02_r8,3.8090e+02_r8,3.2647e+02_r8,2.7207e+02_r8,2.1766e+02_r8,1.6325e+02_r8, &
     &1.0883e+02_r8,5.4412e+01_r8,3.2634e-02_r8/)
      kao(:, 2, 8,10) = (/ &
     &4.4098e+02_r8,3.8585e+02_r8,3.3074e+02_r8,2.7562e+02_r8,2.2050e+02_r8,1.6536e+02_r8, &
     &1.1025e+02_r8,5.5123e+01_r8,4.9788e-02_r8/)
      kao(:, 3, 8,10) = (/ &
     &4.4650e+02_r8,3.9069e+02_r8,3.3490e+02_r8,2.7906e+02_r8,2.2325e+02_r8,1.6744e+02_r8, &
     &1.1162e+02_r8,5.5816e+01_r8,7.2094e-02_r8/)
      kao(:, 4, 8,10) = (/ &
     &4.5108e+02_r8,3.9470e+02_r8,3.3831e+02_r8,2.8194e+02_r8,2.2555e+02_r8,1.6915e+02_r8, &
     &1.1277e+02_r8,5.6387e+01_r8,9.8901e-02_r8/)
      kao(:, 5, 8,10) = (/ &
     &4.5442e+02_r8,3.9761e+02_r8,3.4081e+02_r8,2.8400e+02_r8,2.2721e+02_r8,1.7040e+02_r8, &
     &1.1360e+02_r8,5.6798e+01_r8,1.3038e-01_r8/)
      kao(:, 1, 9,10) = (/ &
     &2.1147e+03_r8,1.8504e+03_r8,1.5860e+03_r8,1.3217e+03_r8,1.0574e+03_r8,7.9304e+02_r8, &
     &5.2867e+02_r8,2.6435e+02_r8,1.9424e-02_r8/)
      kao(:, 2, 9,10) = (/ &
     &2.1442e+03_r8,1.8762e+03_r8,1.6082e+03_r8,1.3401e+03_r8,1.0721e+03_r8,8.0408e+02_r8, &
     &5.3608e+02_r8,2.6803e+02_r8,3.6865e-02_r8/)
      kao(:, 3, 9,10) = (/ &
     &2.1685e+03_r8,1.8976e+03_r8,1.6264e+03_r8,1.3553e+03_r8,1.0842e+03_r8,8.1317e+02_r8, &
     &5.4213e+02_r8,2.7107e+02_r8,5.5684e-02_r8/)
      kao(:, 4, 9,10) = (/ &
     &2.1886e+03_r8,1.9151e+03_r8,1.6415e+03_r8,1.3680e+03_r8,1.0943e+03_r8,8.2077e+02_r8, &
     &5.4720e+02_r8,2.7360e+02_r8,7.8135e-02_r8/)
      kao(:, 5, 9,10) = (/ &
     &2.2035e+03_r8,1.9281e+03_r8,1.6526e+03_r8,1.3772e+03_r8,1.1018e+03_r8,8.2634e+02_r8, &
     &5.5093e+02_r8,2.7546e+02_r8,1.0558e-01_r8/)
      kao(:, 1,10,10) = (/ &
     &1.1340e+04_r8,9.9225e+03_r8,8.5053e+03_r8,7.0882e+03_r8,5.6700e+03_r8,4.2524e+03_r8, &
     &2.8350e+03_r8,1.4175e+03_r8,1.1591e-02_r8/)
      kao(:, 2,10,10) = (/ &
     &1.1483e+04_r8,1.0048e+04_r8,8.6127e+03_r8,7.1771e+03_r8,5.7419e+03_r8,4.3066e+03_r8, &
     &2.8709e+03_r8,1.4354e+03_r8,1.2588e-02_r8/)
      kao(:, 3,10,10) = (/ &
     &1.1610e+04_r8,1.0159e+04_r8,8.7071e+03_r8,7.2559e+03_r8,5.8048e+03_r8,4.3532e+03_r8, &
     &2.9023e+03_r8,1.4511e+03_r8,2.5538e-02_r8/)
      kao(:, 4,10,10) = (/ &
     &1.1702e+04_r8,1.0239e+04_r8,8.7766e+03_r8,7.3135e+03_r8,5.8511e+03_r8,4.3884e+03_r8, &
     &2.9255e+03_r8,1.4628e+03_r8,4.5275e-02_r8/)
      kao(:, 5,10,10) = (/ &
     &1.1737e+04_r8,1.0270e+04_r8,8.8031e+03_r8,7.3358e+03_r8,5.8688e+03_r8,4.4014e+03_r8, &
     &2.9344e+03_r8,1.4670e+03_r8,5.8192e-02_r8/)
      kao(:, 1,11,10) = (/ &
     &2.0903e+04_r8,1.8291e+04_r8,1.5678e+04_r8,1.3065e+04_r8,1.0451e+04_r8,7.8389e+03_r8, &
     &5.2261e+03_r8,2.6129e+03_r8,7.1886e-03_r8/)
      kao(:, 2,11,10) = (/ &
     &2.1095e+04_r8,1.8459e+04_r8,1.5821e+04_r8,1.3184e+04_r8,1.0548e+04_r8,7.9109e+03_r8, &
     &5.2736e+03_r8,2.6368e+03_r8,6.0460e-03_r8/)
      kao(:, 3,11,10) = (/ &
     &2.1210e+04_r8,1.8559e+04_r8,1.5908e+04_r8,1.3256e+04_r8,1.0605e+04_r8,7.9536e+03_r8, &
     &5.3027e+03_r8,2.6511e+03_r8,2.6262e-02_r8/)
      kao(:, 4,11,10) = (/ &
     &2.1260e+04_r8,1.8603e+04_r8,1.5945e+04_r8,1.3287e+04_r8,1.0630e+04_r8,7.9726e+03_r8, &
     &5.3149e+03_r8,2.6575e+03_r8,3.1824e-02_r8/)
      kao(:, 5,11,10) = (/ &
     &2.1221e+04_r8,1.8569e+04_r8,1.5915e+04_r8,1.3263e+04_r8,1.0611e+04_r8,7.9580e+03_r8, &
     &5.3053e+03_r8,2.6525e+03_r8,4.2831e-02_r8/)
      kao(:, 1,12,10) = (/ &
     &2.8005e+04_r8,2.4506e+04_r8,2.1003e+04_r8,1.7504e+04_r8,1.4003e+04_r8,1.0502e+04_r8, &
     &7.0018e+03_r8,3.5007e+03_r8,1.9282e-02_r8/)
      kao(:, 2,12,10) = (/ &
     &2.8178e+04_r8,2.4656e+04_r8,2.1135e+04_r8,1.7611e+04_r8,1.4090e+04_r8,1.0567e+04_r8, &
     &7.0445e+03_r8,3.5221e+03_r8,8.6382e-03_r8/)
      kao(:, 3,12,10) = (/ &
     &2.8205e+04_r8,2.4680e+04_r8,2.1153e+04_r8,1.7628e+04_r8,1.4103e+04_r8,1.0577e+04_r8, &
     &7.0512e+03_r8,3.5256e+03_r8,2.9773e-02_r8/)
      kao(:, 4,12,10) = (/ &
     &2.8170e+04_r8,2.4648e+04_r8,2.1126e+04_r8,1.7606e+04_r8,1.4084e+04_r8,1.0563e+04_r8, &
     &7.0421e+03_r8,3.5211e+03_r8,3.9720e-02_r8/)
      kao(:, 5,12,10) = (/ &
     &2.8047e+04_r8,2.4540e+04_r8,2.1034e+04_r8,1.7529e+04_r8,1.4023e+04_r8,1.0517e+04_r8, &
     &7.0115e+03_r8,3.5058e+03_r8,4.1794e-02_r8/)
      kao(:, 1,13,10) = (/ &
     &2.9533e+04_r8,2.5841e+04_r8,2.2150e+04_r8,1.8457e+04_r8,1.4766e+04_r8,1.1075e+04_r8, &
     &7.3833e+03_r8,3.6917e+03_r8,1.5098e-03_r8/)
      kao(:, 2,13,10) = (/ &
     &2.9558e+04_r8,2.5865e+04_r8,2.2169e+04_r8,1.8475e+04_r8,1.4779e+04_r8,1.1085e+04_r8, &
     &7.3900e+03_r8,3.6949e+03_r8,1.2533e-02_r8/)
      kao(:, 3,13,10) = (/ &
     &2.9540e+04_r8,2.5844e+04_r8,2.2155e+04_r8,1.8463e+04_r8,1.4769e+04_r8,1.1077e+04_r8, &
     &7.3851e+03_r8,3.6924e+03_r8,1.7410e-02_r8/)
      kao(:, 4,13,10) = (/ &
     &2.9338e+04_r8,2.5670e+04_r8,2.2004e+04_r8,1.8336e+04_r8,1.4669e+04_r8,1.1002e+04_r8, &
     &7.3346e+03_r8,3.6671e+03_r8,4.5009e-02_r8/)
      kao(:, 5,13,10) = (/ &
     &2.9073e+04_r8,2.5440e+04_r8,2.1806e+04_r8,1.8171e+04_r8,1.4537e+04_r8,1.0903e+04_r8, &
     &7.2684e+03_r8,3.6344e+03_r8,5.0725e-02_r8/)
      kao(:, 1, 1,11) = (/ &
     &5.0284e+00_r8,4.3997e+00_r8,3.7713e+00_r8,3.1433e+00_r8,2.5148e+00_r8,1.8867e+00_r8, &
     &1.2585e+00_r8,6.3034e-01_r8,1.3324e-01_r8/)
      kao(:, 2, 1,11) = (/ &
     &5.0428e+00_r8,4.4122e+00_r8,3.7822e+00_r8,3.1521e+00_r8,2.5223e+00_r8,1.8921e+00_r8, &
     &1.2620e+00_r8,6.6040e-01_r8,1.7160e-01_r8/)
      kao(:, 3, 1,11) = (/ &
     &5.0450e+00_r8,4.4148e+00_r8,3.7841e+00_r8,3.1540e+00_r8,2.5234e+00_r8,1.8930e+00_r8, &
     &1.2629e+00_r8,7.0553e-01_r8,2.2033e-01_r8/)
      kao(:, 4, 1,11) = (/ &
     &5.0314e+00_r8,4.4027e+00_r8,3.7741e+00_r8,3.1454e+00_r8,2.5166e+00_r8,1.8879e+00_r8, &
     &1.2828e+00_r8,7.2981e-01_r8,2.7819e-01_r8/)
      kao(:, 5, 1,11) = (/ &
     &5.0061e+00_r8,4.3808e+00_r8,3.7550e+00_r8,3.1298e+00_r8,2.5041e+00_r8,1.8785e+00_r8, &
     &1.3311e+00_r8,7.4514e-01_r8,3.4945e-01_r8/)
      kao(:, 1, 2,11) = (/ &
     &7.7109e+00_r8,6.7474e+00_r8,5.7839e+00_r8,4.8201e+00_r8,3.8564e+00_r8,2.8926e+00_r8, &
     &1.9289e+00_r8,9.6516e-01_r8,1.3538e-01_r8/)
      kao(:, 2, 2,11) = (/ &
     &7.7553e+00_r8,6.7857e+00_r8,5.8167e+00_r8,4.8473e+00_r8,3.8784e+00_r8,2.9091e+00_r8, &
     &1.9400e+00_r8,9.7434e-01_r8,1.7899e-01_r8/)
      kao(:, 3, 2,11) = (/ &
     &7.7777e+00_r8,6.8060e+00_r8,5.8332e+00_r8,4.8617e+00_r8,3.8897e+00_r8,2.9178e+00_r8, &
     &1.9457e+00_r8,1.0175e+00_r8,2.2662e-01_r8/)
      kao(:, 4, 2,11) = (/ &
     &7.7756e+00_r8,6.8039e+00_r8,5.8323e+00_r8,4.8602e+00_r8,3.8885e+00_r8,2.9169e+00_r8, &
     &1.9452e+00_r8,1.0634e+00_r8,2.8531e-01_r8/)
      kao(:, 5, 2,11) = (/ &
     &7.7495e+00_r8,6.7817e+00_r8,5.8131e+00_r8,4.8446e+00_r8,3.8758e+00_r8,2.9075e+00_r8, &
     &1.9643e+00_r8,1.0863e+00_r8,3.5634e-01_r8/)
      kao(:, 1, 3,11) = (/ &
     &1.5932e+01_r8,1.3941e+01_r8,1.1949e+01_r8,9.9578e+00_r8,7.9671e+00_r8,5.9754e+00_r8, &
     &3.9840e+00_r8,1.9926e+00_r8,1.2714e-01_r8/)
      kao(:, 2, 3,11) = (/ &
     &1.6076e+01_r8,1.4067e+01_r8,1.2058e+01_r8,1.0048e+01_r8,8.0387e+00_r8,6.0296e+00_r8, &
     &4.0199e+00_r8,2.0105e+00_r8,1.7056e-01_r8/)
      kao(:, 3, 3,11) = (/ &
     &1.6164e+01_r8,1.4145e+01_r8,1.2124e+01_r8,1.0103e+01_r8,8.0829e+00_r8,6.0627e+00_r8, &
     &4.0424e+00_r8,2.0217e+00_r8,2.2135e-01_r8/)
      kao(:, 4, 3,11) = (/ &
     &1.6211e+01_r8,1.4185e+01_r8,1.2159e+01_r8,1.0132e+01_r8,8.1062e+00_r8,6.0800e+00_r8, &
     &4.0538e+00_r8,2.0361e+00_r8,2.7967e-01_r8/)
      kao(:, 5, 3,11) = (/ &
     &1.6213e+01_r8,1.4187e+01_r8,1.2160e+01_r8,1.0134e+01_r8,8.1068e+00_r8,6.0810e+00_r8, &
     &4.0544e+00_r8,2.0887e+00_r8,3.5085e-01_r8/)
      kao(:, 1, 4,11) = (/ &
     &3.3505e+01_r8,2.9316e+01_r8,2.5128e+01_r8,2.0940e+01_r8,1.6753e+01_r8,1.2564e+01_r8, &
     &8.3770e+00_r8,4.1888e+00_r8,1.1343e-01_r8/)
      kao(:, 2, 4,11) = (/ &
     &3.3957e+01_r8,2.9712e+01_r8,2.5469e+01_r8,2.1224e+01_r8,1.6979e+01_r8,1.2735e+01_r8, &
     &8.4899e+00_r8,4.2456e+00_r8,1.5601e-01_r8/)
      kao(:, 3, 4,11) = (/ &
     &3.4273e+01_r8,2.9992e+01_r8,2.5707e+01_r8,2.1421e+01_r8,1.7138e+01_r8,1.2854e+01_r8, &
     &8.5693e+00_r8,4.2852e+00_r8,2.0536e-01_r8/)
      kao(:, 4, 4,11) = (/ &
     &3.4537e+01_r8,3.0216e+01_r8,2.5901e+01_r8,2.1585e+01_r8,1.7269e+01_r8,1.2951e+01_r8, &
     &8.6346e+00_r8,4.3178e+00_r8,2.6462e-01_r8/)
      kao(:, 5, 4,11) = (/ &
     &3.4713e+01_r8,3.0370e+01_r8,2.6032e+01_r8,2.1696e+01_r8,1.7356e+01_r8,1.3018e+01_r8, &
     &8.6791e+00_r8,4.3400e+00_r8,3.3230e-01_r8/)
      kao(:, 1, 5,11) = (/ &
     &6.4813e+01_r8,5.6712e+01_r8,4.8608e+01_r8,4.0507e+01_r8,3.2408e+01_r8,2.4306e+01_r8, &
     &1.6204e+01_r8,8.1017e+00_r8,9.6356e-02_r8/)
      kao(:, 2, 5,11) = (/ &
     &6.6164e+01_r8,5.7895e+01_r8,4.9623e+01_r8,4.1352e+01_r8,3.3084e+01_r8,2.4813e+01_r8, &
     &1.6542e+01_r8,8.2707e+00_r8,1.3652e-01_r8/)
      kao(:, 3, 5,11) = (/ &
     &6.7228e+01_r8,5.8826e+01_r8,5.0425e+01_r8,4.2018e+01_r8,3.3613e+01_r8,2.5211e+01_r8, &
     &1.6808e+01_r8,8.4044e+00_r8,1.8472e-01_r8/)
      kao(:, 4, 5,11) = (/ &
     &6.8035e+01_r8,5.9536e+01_r8,5.1024e+01_r8,4.2523e+01_r8,3.4019e+01_r8,2.5513e+01_r8, &
     &1.7010e+01_r8,8.5064e+00_r8,2.4242e-01_r8/)
      kao(:, 5, 5,11) = (/ &
     &6.8554e+01_r8,5.9987e+01_r8,5.1420e+01_r8,4.2849e+01_r8,3.4277e+01_r8,2.5710e+01_r8, &
     &1.7140e+01_r8,8.5702e+00_r8,3.0919e-01_r8/)
      kao(:, 1, 6,11) = (/ &
     &1.1801e+02_r8,1.0326e+02_r8,8.8506e+01_r8,7.3757e+01_r8,5.9002e+01_r8,4.4254e+01_r8, &
     &2.9503e+01_r8,1.4751e+01_r8,7.7344e-02_r8/)
      kao(:, 2, 6,11) = (/ &
     &1.2108e+02_r8,1.0594e+02_r8,9.0808e+01_r8,7.5672e+01_r8,6.0541e+01_r8,4.5406e+01_r8, &
     &3.0271e+01_r8,1.5134e+01_r8,1.1263e-01_r8/)
      kao(:, 3, 6,11) = (/ &
     &1.2354e+02_r8,1.0810e+02_r8,9.2652e+01_r8,7.7213e+01_r8,6.1769e+01_r8,4.6330e+01_r8, &
     &3.0886e+01_r8,1.5443e+01_r8,1.5682e-01_r8/)
      kao(:, 4, 6,11) = (/ &
     &1.2526e+02_r8,1.0960e+02_r8,9.3943e+01_r8,7.8284e+01_r8,6.2629e+01_r8,4.6975e+01_r8, &
     &3.1316e+01_r8,1.5657e+01_r8,2.1207e-01_r8/)
      kao(:, 5, 6,11) = (/ &
     &1.2664e+02_r8,1.1081e+02_r8,9.4976e+01_r8,7.9149e+01_r8,6.3321e+01_r8,4.7490e+01_r8, &
     &3.1658e+01_r8,1.5831e+01_r8,2.7724e-01_r8/)
      kao(:, 1, 7,11) = (/ &
     &2.3249e+02_r8,2.0341e+02_r8,1.7435e+02_r8,1.4529e+02_r8,1.1624e+02_r8,8.7178e+01_r8, &
     &5.8117e+01_r8,2.9059e+01_r8,6.0308e-02_r8/)
      kao(:, 2, 7,11) = (/ &
     &2.3796e+02_r8,2.0820e+02_r8,1.7846e+02_r8,1.4871e+02_r8,1.1897e+02_r8,8.9231e+01_r8, &
     &5.9488e+01_r8,2.9745e+01_r8,9.0208e-02_r8/)
      kao(:, 3, 7,11) = (/ &
     &2.4226e+02_r8,2.1197e+02_r8,1.8170e+02_r8,1.5141e+02_r8,1.2113e+02_r8,9.0843e+01_r8, &
     &6.0568e+01_r8,3.0281e+01_r8,1.2927e-01_r8/)
      kao(:, 4, 7,11) = (/ &
     &2.4544e+02_r8,2.1477e+02_r8,1.8409e+02_r8,1.5341e+02_r8,1.2272e+02_r8,9.2044e+01_r8, &
     &6.1361e+01_r8,3.0682e+01_r8,1.7878e-01_r8/)
      kao(:, 5, 7,11) = (/ &
     &2.4764e+02_r8,2.1668e+02_r8,1.8573e+02_r8,1.5477e+02_r8,1.2381e+02_r8,9.2866e+01_r8, &
     &6.1907e+01_r8,3.0956e+01_r8,2.3824e-01_r8/)
      kao(:, 1, 8,11) = (/ &
     &5.7428e+02_r8,5.0249e+02_r8,4.3070e+02_r8,3.5893e+02_r8,2.8714e+02_r8,2.1536e+02_r8, &
     &1.4357e+02_r8,7.1786e+01_r8,4.7227e-02_r8/)
      kao(:, 2, 8,11) = (/ &
     &5.8499e+02_r8,5.1190e+02_r8,4.3878e+02_r8,3.6564e+02_r8,2.9252e+02_r8,2.1939e+02_r8, &
     &1.4626e+02_r8,7.3130e+01_r8,7.2171e-02_r8/)
      kao(:, 3, 8,11) = (/ &
     &5.9291e+02_r8,5.1879e+02_r8,4.4470e+02_r8,3.7058e+02_r8,2.9645e+02_r8,2.2235e+02_r8, &
     &1.4822e+02_r8,7.4114e+01_r8,1.0536e-01_r8/)
      kao(:, 4, 8,11) = (/ &
     &5.9816e+02_r8,5.2341e+02_r8,4.4862e+02_r8,3.7386e+02_r8,2.9908e+02_r8,2.2431e+02_r8, &
     &1.4954e+02_r8,7.4773e+01_r8,1.4833e-01_r8/)
      kao(:, 5, 8,11) = (/ &
     &6.0144e+02_r8,5.2627e+02_r8,4.5109e+02_r8,3.7590e+02_r8,3.0070e+02_r8,2.2554e+02_r8, &
     &1.5036e+02_r8,7.5181e+01_r8,1.9981e-01_r8/)
      kao(:, 1, 9,11) = (/ &
     &2.7514e+03_r8,2.4073e+03_r8,2.0635e+03_r8,1.7196e+03_r8,1.3757e+03_r8,1.0318e+03_r8, &
     &6.8788e+02_r8,3.4393e+02_r8,3.3107e-02_r8/)
      kao(:, 2, 9,11) = (/ &
     &2.7973e+03_r8,2.4476e+03_r8,2.0979e+03_r8,1.7482e+03_r8,1.3986e+03_r8,1.0490e+03_r8, &
     &6.9932e+02_r8,3.4966e+02_r8,5.6998e-02_r8/)
      kao(:, 3, 9,11) = (/ &
     &2.8265e+03_r8,2.4731e+03_r8,2.1197e+03_r8,1.7664e+03_r8,1.4131e+03_r8,1.0599e+03_r8, &
     &7.0662e+02_r8,3.5330e+02_r8,8.5901e-02_r8/)
      kao(:, 4, 9,11) = (/ &
     &2.8388e+03_r8,2.4841e+03_r8,2.1291e+03_r8,1.7743e+03_r8,1.4194e+03_r8,1.0646e+03_r8, &
     &7.0974e+02_r8,3.5484e+02_r8,1.2233e-01_r8/)
      kao(:, 5, 9,11) = (/ &
     &2.8373e+03_r8,2.4828e+03_r8,2.1280e+03_r8,1.7734e+03_r8,1.4187e+03_r8,1.0640e+03_r8, &
     &7.0933e+02_r8,3.5467e+02_r8,1.6642e-01_r8/)
      kao(:, 1,10,11) = (/ &
     &1.4796e+04_r8,1.2947e+04_r8,1.1097e+04_r8,9.2476e+03_r8,7.3982e+03_r8,5.5489e+03_r8, &
     &3.6992e+03_r8,1.8496e+03_r8,1.7335e-02_r8/)
      kao(:, 2,10,11) = (/ &
     &1.4975e+04_r8,1.3103e+04_r8,1.1231e+04_r8,9.3585e+03_r8,7.4871e+03_r8,5.6155e+03_r8, &
     &3.7435e+03_r8,1.8717e+03_r8,3.1226e-02_r8/)
      kao(:, 3,10,11) = (/ &
     &1.5074e+04_r8,1.3189e+04_r8,1.1305e+04_r8,9.4210e+03_r8,7.5370e+03_r8,5.6528e+03_r8, &
     &3.7685e+03_r8,1.8842e+03_r8,4.3228e-02_r8/)
      kao(:, 4,10,11) = (/ &
     &1.5109e+04_r8,1.3220e+04_r8,1.1331e+04_r8,9.4424e+03_r8,7.5542e+03_r8,5.6659e+03_r8, &
     &3.7773e+03_r8,1.8886e+03_r8,5.6685e-02_r8/)
      kao(:, 5,10,11) = (/ &
     &1.5082e+04_r8,1.3196e+04_r8,1.1311e+04_r8,9.4257e+03_r8,7.5405e+03_r8,5.6555e+03_r8, &
     &3.7704e+03_r8,1.8852e+03_r8,8.6311e-02_r8/)
      kao(:, 1,11,11) = (/ &
     &2.7889e+04_r8,2.4402e+04_r8,2.0916e+04_r8,1.7430e+04_r8,1.3944e+04_r8,1.0458e+04_r8, &
     &6.9720e+03_r8,3.4860e+03_r8,1.1432e-02_r8/)
      kao(:, 2,11,11) = (/ &
     &2.8116e+04_r8,2.4602e+04_r8,2.1087e+04_r8,1.7573e+04_r8,1.4058e+04_r8,1.0543e+04_r8, &
     &7.0292e+03_r8,3.5144e+03_r8,1.1075e-02_r8/)
      kao(:, 3,11,11) = (/ &
     &2.8224e+04_r8,2.4695e+04_r8,2.1166e+04_r8,1.7640e+04_r8,1.4112e+04_r8,1.0583e+04_r8, &
     &7.0560e+03_r8,3.5276e+03_r8,4.6547e-02_r8/)
      kao(:, 4,11,11) = (/ &
     &2.8217e+04_r8,2.4690e+04_r8,2.1162e+04_r8,1.7636e+04_r8,1.4108e+04_r8,1.0581e+04_r8, &
     &7.0540e+03_r8,3.5272e+03_r8,6.2488e-02_r8/)
      kao(:, 5,11,11) = (/ &
     &2.8126e+04_r8,2.4609e+04_r8,2.1093e+04_r8,1.7578e+04_r8,1.4063e+04_r8,1.0547e+04_r8, &
     &7.0311e+03_r8,3.5155e+03_r8,7.5051e-02_r8/)
      kao(:, 1,12,11) = (/ &
     &3.8808e+04_r8,3.3958e+04_r8,2.9106e+04_r8,2.4255e+04_r8,1.9403e+04_r8,1.4552e+04_r8, &
     &9.7020e+03_r8,4.8510e+03_r8,3.0879e-04_r8/)
      kao(:, 2,12,11) = (/ &
     &3.8964e+04_r8,3.4093e+04_r8,2.9222e+04_r8,2.4351e+04_r8,1.9482e+04_r8,1.4612e+04_r8, &
     &9.7411e+03_r8,4.8703e+03_r8,1.3840e-02_r8/)
      kao(:, 3,12,11) = (/ &
     &3.8935e+04_r8,3.4067e+04_r8,2.9198e+04_r8,2.4333e+04_r8,1.9466e+04_r8,1.4600e+04_r8, &
     &9.7333e+03_r8,4.8667e+03_r8,2.1306e-02_r8/)
      kao(:, 4,12,11) = (/ &
     &3.8831e+04_r8,3.3979e+04_r8,2.9123e+04_r8,2.4270e+04_r8,1.9417e+04_r8,1.4562e+04_r8, &
     &9.7077e+03_r8,4.8538e+03_r8,6.5973e-02_r8/)
      kao(:, 5,12,11) = (/ &
     &3.8549e+04_r8,3.3728e+04_r8,2.8909e+04_r8,2.4091e+04_r8,1.9273e+04_r8,1.4455e+04_r8, &
     &9.6358e+03_r8,4.8182e+03_r8,7.9959e-02_r8/)
      kao(:, 1,13,11) = (/ &
     &4.2486e+04_r8,3.7175e+04_r8,3.1864e+04_r8,2.6552e+04_r8,2.1242e+04_r8,1.5932e+04_r8, &
     &1.0621e+04_r8,5.3106e+03_r8,2.4053e-04_r8/)
      kao(:, 2,13,11) = (/ &
     &4.2536e+04_r8,3.7221e+04_r8,3.1903e+04_r8,2.6585e+04_r8,2.1268e+04_r8,1.5951e+04_r8, &
     &1.0634e+04_r8,5.3169e+03_r8,2.3604e-02_r8/)
      kao(:, 3,13,11) = (/ &
     &4.2342e+04_r8,3.7047e+04_r8,3.1757e+04_r8,2.6467e+04_r8,2.1172e+04_r8,1.5879e+04_r8, &
     &1.0585e+04_r8,5.2925e+03_r8,1.5018e-02_r8/)
      kao(:, 4,13,11) = (/ &
     &4.2048e+04_r8,3.6792e+04_r8,3.1537e+04_r8,2.6281e+04_r8,2.1024e+04_r8,1.5767e+04_r8, &
     &1.0512e+04_r8,5.2560e+03_r8,5.3807e-02_r8/)
      kao(:, 5,13,11) = (/ &
     &4.1662e+04_r8,3.6457e+04_r8,3.1248e+04_r8,2.6040e+04_r8,2.0833e+04_r8,1.5623e+04_r8, &
     &1.0416e+04_r8,5.2082e+03_r8,6.8318e-02_r8/)
      kao(:, 1, 1,12) = (/ &
     &7.2849e+00_r8,6.3745e+00_r8,5.4643e+00_r8,4.5537e+00_r8,3.6431e+00_r8,2.7326e+00_r8, &
     &1.8223e+00_r8,9.1190e-01_r8,1.6091e-01_r8/)
      kao(:, 2, 1,12) = (/ &
     &7.1530e+00_r8,6.2588e+00_r8,5.3648e+00_r8,4.4709e+00_r8,3.5770e+00_r8,2.6830e+00_r8, &
     &1.7891e+00_r8,8.9548e-01_r8,2.2421e-01_r8/)
      kao(:, 3, 1,12) = (/ &
     &7.0158e+00_r8,6.1389e+00_r8,5.2624e+00_r8,4.3853e+00_r8,3.5089e+00_r8,2.6317e+00_r8, &
     &1.7551e+00_r8,9.0204e-01_r8,3.0513e-01_r8/)
      kao(:, 4, 1,12) = (/ &
     &6.8752e+00_r8,6.0158e+00_r8,5.1568e+00_r8,4.2975e+00_r8,3.4386e+00_r8,2.5792e+00_r8, &
     &1.7200e+00_r8,9.2056e-01_r8,4.0130e-01_r8/)
      kao(:, 5, 1,12) = (/ &
     &6.7312e+00_r8,5.8897e+00_r8,5.0486e+00_r8,4.2075e+00_r8,3.3663e+00_r8,2.5251e+00_r8, &
     &1.6886e+00_r8,9.1312e-01_r8,5.1163e-01_r8/)
      kao(:, 1, 2,12) = (/ &
     &1.1380e+01_r8,9.9571e+00_r8,8.5349e+00_r8,7.1126e+00_r8,5.6896e+00_r8,4.2680e+00_r8, &
     &2.8456e+00_r8,1.4234e+00_r8,1.6023e-01_r8/)
      kao(:, 2, 2,12) = (/ &
     &1.1190e+01_r8,9.7913e+00_r8,8.3926e+00_r8,6.9944e+00_r8,5.5956e+00_r8,4.1971e+00_r8, &
     &2.7983e+00_r8,1.3998e+00_r8,2.1092e-01_r8/)
      kao(:, 3, 2,12) = (/ &
     &1.0994e+01_r8,9.6196e+00_r8,8.2451e+00_r8,6.8714e+00_r8,5.4970e+00_r8,4.1233e+00_r8, &
     &2.7491e+00_r8,1.3753e+00_r8,2.8249e-01_r8/)
      kao(:, 4, 2,12) = (/ &
     &1.0789e+01_r8,9.4404e+00_r8,8.0917e+00_r8,6.7431e+00_r8,5.3950e+00_r8,4.0464e+00_r8, &
     &2.6980e+00_r8,1.3854e+00_r8,3.7167e-01_r8/)
      kao(:, 5, 2,12) = (/ &
     &1.0574e+01_r8,9.2528e+00_r8,7.9306e+00_r8,6.6095e+00_r8,5.2877e+00_r8,3.9662e+00_r8, &
     &2.6446e+00_r8,1.3862e+00_r8,4.7628e-01_r8/)
      kao(:, 1, 3,12) = (/ &
     &2.4019e+01_r8,2.1015e+01_r8,1.8012e+01_r8,1.5011e+01_r8,1.2010e+01_r8,9.0070e+00_r8, &
     &6.0051e+00_r8,3.0029e+00_r8,1.5458e-01_r8/)
      kao(:, 2, 3,12) = (/ &
     &2.3668e+01_r8,2.0712e+01_r8,1.7752e+01_r8,1.4794e+01_r8,1.1835e+01_r8,8.8764e+00_r8, &
     &5.9181e+00_r8,2.9594e+00_r8,2.0548e-01_r8/)
      kao(:, 3, 3,12) = (/ &
     &2.3299e+01_r8,2.0389e+01_r8,1.7475e+01_r8,1.4563e+01_r8,1.1650e+01_r8,8.7378e+00_r8, &
     &5.8256e+00_r8,2.9134e+00_r8,2.6510e-01_r8/)
      kao(:, 4, 3,12) = (/ &
     &2.2895e+01_r8,2.0033e+01_r8,1.7172e+01_r8,1.4310e+01_r8,1.1449e+01_r8,8.5868e+00_r8, &
     &5.7250e+00_r8,2.8629e+00_r8,3.4340e-01_r8/)
      kao(:, 5, 3,12) = (/ &
     &2.2457e+01_r8,1.9650e+01_r8,1.6845e+01_r8,1.4036e+01_r8,1.1229e+01_r8,8.4225e+00_r8, &
     &5.6152e+00_r8,2.8081e+00_r8,4.3834e-01_r8/)
      kao(:, 1, 4,12) = (/ &
     &5.1943e+01_r8,4.5448e+01_r8,3.8958e+01_r8,3.2464e+01_r8,2.5972e+01_r8,1.9479e+01_r8, &
     &1.2986e+01_r8,6.4930e+00_r8,1.4248e-01_r8/)
      kao(:, 2, 4,12) = (/ &
     &5.1352e+01_r8,4.4935e+01_r8,3.8514e+01_r8,3.2094e+01_r8,2.5675e+01_r8,1.9257e+01_r8, &
     &1.2838e+01_r8,6.4195e+00_r8,1.9502e-01_r8/)
      kao(:, 3, 4,12) = (/ &
     &5.0623e+01_r8,4.4294e+01_r8,3.7964e+01_r8,3.1639e+01_r8,2.5309e+01_r8,1.8983e+01_r8, &
     &1.2655e+01_r8,6.3280e+00_r8,2.5898e-01_r8/)
      kao(:, 4, 4,12) = (/ &
     &4.9799e+01_r8,4.3576e+01_r8,3.7352e+01_r8,3.1124e+01_r8,2.4901e+01_r8,1.8676e+01_r8, &
     &1.2451e+01_r8,6.2257e+00_r8,3.3035e-01_r8/)
      kao(:, 5, 4,12) = (/ &
     &4.8898e+01_r8,4.2791e+01_r8,3.6677e+01_r8,3.0566e+01_r8,2.4452e+01_r8,1.8340e+01_r8, &
     &1.2226e+01_r8,6.1134e+00_r8,4.1835e-01_r8/)
      kao(:, 1, 5,12) = (/ &
     &1.0373e+02_r8,9.0759e+01_r8,7.7796e+01_r8,6.4826e+01_r8,5.1857e+01_r8,3.8894e+01_r8, &
     &2.5931e+01_r8,1.2966e+01_r8,1.2887e-01_r8/)
      kao(:, 2, 5,12) = (/ &
     &1.0276e+02_r8,8.9908e+01_r8,7.7065e+01_r8,6.4222e+01_r8,5.1382e+01_r8,3.8535e+01_r8, &
     &2.5690e+01_r8,1.2845e+01_r8,1.8027e-01_r8/)
      kao(:, 3, 5,12) = (/ &
     &1.0148e+02_r8,8.8794e+01_r8,7.6113e+01_r8,6.3420e+01_r8,5.0736e+01_r8,3.8055e+01_r8, &
     &2.5371e+01_r8,1.2686e+01_r8,2.4350e-01_r8/)
      kao(:, 4, 5,12) = (/ &
     &9.9981e+01_r8,8.7486e+01_r8,7.4989e+01_r8,6.2492e+01_r8,4.9992e+01_r8,3.7496e+01_r8, &
     &2.4996e+01_r8,1.2498e+01_r8,3.1895e-01_r8/)
      kao(:, 5, 5,12) = (/ &
     &9.8403e+01_r8,8.6098e+01_r8,7.3801e+01_r8,6.1498e+01_r8,4.9199e+01_r8,3.6902e+01_r8, &
     &2.4598e+01_r8,1.2301e+01_r8,4.0491e-01_r8/)
      kao(:, 1, 6,12) = (/ &
     &1.9449e+02_r8,1.7021e+02_r8,1.4589e+02_r8,1.2157e+02_r8,9.7258e+01_r8,7.2943e+01_r8, &
     &4.8628e+01_r8,2.4314e+01_r8,1.1014e-01_r8/)
      kao(:, 2, 6,12) = (/ &
     &1.9309e+02_r8,1.6897e+02_r8,1.4483e+02_r8,1.2070e+02_r8,9.6559e+01_r8,7.2419e+01_r8, &
     &4.8279e+01_r8,2.4139e+01_r8,1.6004e-01_r8/)
      kao(:, 3, 6,12) = (/ &
     &1.9140e+02_r8,1.6747e+02_r8,1.4356e+02_r8,1.1963e+02_r8,9.5709e+01_r8,7.1777e+01_r8, &
     &4.7853e+01_r8,2.3926e+01_r8,2.2190e-01_r8/)
      kao(:, 4, 6,12) = (/ &
     &1.8899e+02_r8,1.6537e+02_r8,1.4174e+02_r8,1.1810e+02_r8,9.4493e+01_r8,7.0867e+01_r8, &
     &4.7246e+01_r8,2.3622e+01_r8,2.9571e-01_r8/)
      kao(:, 5, 6,12) = (/ &
     &1.8566e+02_r8,1.6245e+02_r8,1.3925e+02_r8,1.1603e+02_r8,9.2834e+01_r8,6.9623e+01_r8, &
     &4.6415e+01_r8,2.3209e+01_r8,3.8274e-01_r8/)
      kao(:, 1, 7,12) = (/ &
     &3.8417e+02_r8,3.3613e+02_r8,2.8811e+02_r8,2.4009e+02_r8,1.9205e+02_r8,1.4405e+02_r8, &
     &9.6037e+01_r8,4.8023e+01_r8,9.0335e-02_r8/)
      kao(:, 2, 7,12) = (/ &
     &3.8253e+02_r8,3.3473e+02_r8,2.8690e+02_r8,2.3908e+02_r8,1.9128e+02_r8,1.4345e+02_r8, &
     &9.5632e+01_r8,4.7816e+01_r8,1.3557e-01_r8/)
      kao(:, 3, 7,12) = (/ &
     &3.7949e+02_r8,3.3204e+02_r8,2.8460e+02_r8,2.3719e+02_r8,1.8975e+02_r8,1.4230e+02_r8, &
     &9.4872e+01_r8,4.7438e+01_r8,1.9476e-01_r8/)
      kao(:, 4, 7,12) = (/ &
     &3.7465e+02_r8,3.2783e+02_r8,2.8099e+02_r8,2.3416e+02_r8,1.8732e+02_r8,1.4050e+02_r8, &
     &9.3670e+01_r8,4.6831e+01_r8,2.6694e-01_r8/)
      kao(:, 5, 7,12) = (/ &
     &3.6931e+02_r8,3.2313e+02_r8,2.7696e+02_r8,2.3080e+02_r8,1.8464e+02_r8,1.3849e+02_r8, &
     &9.2317e+01_r8,4.6160e+01_r8,3.5213e-01_r8/)
      kao(:, 1, 8,12) = (/ &
     &9.0810e+02_r8,7.9455e+02_r8,6.8107e+02_r8,5.6755e+02_r8,4.5403e+02_r8,3.4053e+02_r8, &
     &2.2701e+02_r8,1.1352e+02_r8,7.1564e-02_r8/)
      kao(:, 2, 8,12) = (/ &
     &9.0605e+02_r8,7.9275e+02_r8,6.7956e+02_r8,5.6628e+02_r8,4.5302e+02_r8,3.3978e+02_r8, &
     &2.2652e+02_r8,1.1325e+02_r8,1.1086e-01_r8/)
      kao(:, 3, 8,12) = (/ &
     &9.0093e+02_r8,7.8832e+02_r8,6.7569e+02_r8,5.6306e+02_r8,4.5046e+02_r8,3.3783e+02_r8, &
     &2.2521e+02_r8,1.1262e+02_r8,1.6463e-01_r8/)
      kao(:, 4, 8,12) = (/ &
     &8.9363e+02_r8,7.8197e+02_r8,6.7027e+02_r8,5.5850e+02_r8,4.4681e+02_r8,3.3513e+02_r8, &
     &2.2342e+02_r8,1.1170e+02_r8,2.3145e-01_r8/)
      kao(:, 5, 8,12) = (/ &
     &8.8174e+02_r8,7.7148e+02_r8,6.6129e+02_r8,5.5110e+02_r8,4.4085e+02_r8,3.3064e+02_r8, &
     &2.2045e+02_r8,1.1021e+02_r8,3.1429e-01_r8/)
      kao(:, 1, 9,12) = (/ &
     &4.0575e+03_r8,3.5502e+03_r8,3.0431e+03_r8,2.5358e+03_r8,2.0286e+03_r8,1.5215e+03_r8, &
     &1.0143e+03_r8,5.0720e+02_r8,5.5603e-02_r8/)
      kao(:, 2, 9,12) = (/ &
     &4.0575e+03_r8,3.5503e+03_r8,3.0431e+03_r8,2.5359e+03_r8,2.0286e+03_r8,1.5216e+03_r8, &
     &1.0143e+03_r8,5.0715e+02_r8,8.8381e-02_r8/)
      kao(:, 3, 9,12) = (/ &
     &4.0490e+03_r8,3.5425e+03_r8,3.0365e+03_r8,2.5303e+03_r8,2.0243e+03_r8,1.5183e+03_r8, &
     &1.0122e+03_r8,5.0611e+02_r8,1.3462e-01_r8/)
      kao(:, 4, 9,12) = (/ &
     &4.0163e+03_r8,3.5141e+03_r8,3.0122e+03_r8,2.5100e+03_r8,2.0082e+03_r8,1.5061e+03_r8, &
     &1.0041e+03_r8,5.0202e+02_r8,1.9418e-01_r8/)
      kao(:, 5, 9,12) = (/ &
     &3.9738e+03_r8,3.4768e+03_r8,2.9801e+03_r8,2.4835e+03_r8,1.9868e+03_r8,1.4900e+03_r8, &
     &9.9338e+02_r8,4.9668e+02_r8,2.7001e-01_r8/)
      kao(:, 1,10,12) = (/ &
     &2.0782e+04_r8,1.8184e+04_r8,1.5586e+04_r8,1.2989e+04_r8,1.0391e+04_r8,7.7931e+03_r8, &
     &5.1956e+03_r8,2.5977e+03_r8,1.5076e-02_r8/)
      kao(:, 2,10,12) = (/ &
     &2.0847e+04_r8,1.8242e+04_r8,1.5636e+04_r8,1.3030e+04_r8,1.0424e+04_r8,7.8180e+03_r8, &
     &5.2120e+03_r8,2.6061e+03_r8,3.9283e-02_r8/)
      kao(:, 3,10,12) = (/ &
     &2.0776e+04_r8,1.8179e+04_r8,1.5582e+04_r8,1.2985e+04_r8,1.0387e+04_r8,7.7905e+03_r8, &
     &5.1937e+03_r8,2.5968e+03_r8,5.3678e-02_r8/)
      kao(:, 4,10,12) = (/ &
     &2.0635e+04_r8,1.8055e+04_r8,1.5476e+04_r8,1.2897e+04_r8,1.0317e+04_r8,7.7379e+03_r8, &
     &5.1584e+03_r8,2.5793e+03_r8,8.4869e-02_r8/)
      kao(:, 5,10,12) = (/ &
     &2.0468e+04_r8,1.7910e+04_r8,1.5352e+04_r8,1.2793e+04_r8,1.0235e+04_r8,7.6761e+03_r8, &
     &5.1174e+03_r8,2.5585e+03_r8,1.7840e-01_r8/)
      kao(:, 1,11,12) = (/ &
     &3.8086e+04_r8,3.3327e+04_r8,2.8563e+04_r8,2.3804e+04_r8,1.9042e+04_r8,1.4282e+04_r8, &
     &9.5217e+03_r8,4.7607e+03_r8,3.5535e-02_r8/)
      kao(:, 2,11,12) = (/ &
     &3.8167e+04_r8,3.3395e+04_r8,2.8624e+04_r8,2.3853e+04_r8,1.9083e+04_r8,1.4312e+04_r8, &
     &9.5414e+03_r8,4.7707e+03_r8,2.0336e-02_r8/)
      kao(:, 3,11,12) = (/ &
     &3.8095e+04_r8,3.3333e+04_r8,2.8571e+04_r8,2.3809e+04_r8,1.9048e+04_r8,1.4285e+04_r8, &
     &9.5235e+03_r8,4.7617e+03_r8,7.3058e-02_r8/)
      kao(:, 4,11,12) = (/ &
     &3.7840e+04_r8,3.3110e+04_r8,2.8380e+04_r8,2.3651e+04_r8,1.8921e+04_r8,1.4191e+04_r8, &
     &9.4603e+03_r8,4.7302e+03_r8,9.2342e-02_r8/)
      kao(:, 5,11,12) = (/ &
     &3.7466e+04_r8,3.2782e+04_r8,2.8098e+04_r8,2.3416e+04_r8,1.8732e+04_r8,1.4049e+04_r8, &
     &9.3659e+03_r8,4.6831e+03_r8,1.1387e-01_r8/)
      kao(:, 1,12,12) = (/ &
     &5.3068e+04_r8,4.6434e+04_r8,3.9801e+04_r8,3.3167e+04_r8,2.6533e+04_r8,1.9901e+04_r8, &
     &1.3266e+04_r8,6.6334e+03_r8,5.3631e-05_r8/)
      kao(:, 2,12,12) = (/ &
     &5.2912e+04_r8,4.6296e+04_r8,3.9684e+04_r8,3.3067e+04_r8,2.6455e+04_r8,1.9841e+04_r8, &
     &1.3228e+04_r8,6.6136e+03_r8,3.3045e-02_r8/)
      kao(:, 3,12,12) = (/ &
     &5.2742e+04_r8,4.6150e+04_r8,3.9556e+04_r8,3.2963e+04_r8,2.6372e+04_r8,1.9779e+04_r8, &
     &1.3186e+04_r8,6.5925e+03_r8,2.4038e-02_r8/)
      kao(:, 4,12,12) = (/ &
     &5.2329e+04_r8,4.5788e+04_r8,3.9248e+04_r8,3.2707e+04_r8,2.6165e+04_r8,1.9623e+04_r8, &
     &1.3082e+04_r8,6.5410e+03_r8,8.8033e-02_r8/)
      kao(:, 5,12,12) = (/ &
     &5.1702e+04_r8,4.5237e+04_r8,3.8772e+04_r8,3.2311e+04_r8,2.5848e+04_r8,1.9386e+04_r8, &
     &1.2925e+04_r8,6.4623e+03_r8,1.0528e-01_r8/)
      kao(:, 1,13,12) = (/ &
     &5.9181e+04_r8,5.1784e+04_r8,4.4385e+04_r8,3.6986e+04_r8,2.9590e+04_r8,2.2192e+04_r8, &
     &1.4795e+04_r8,7.3976e+03_r8,6.3472e-05_r8/)
      kao(:, 2,13,12) = (/ &
     &5.9042e+04_r8,5.1661e+04_r8,4.4282e+04_r8,3.6901e+04_r8,2.9521e+04_r8,2.2141e+04_r8, &
     &1.4760e+04_r8,7.3802e+03_r8,8.2093e-03_r8/)
      kao(:, 3,13,12) = (/ &
     &5.8661e+04_r8,5.1328e+04_r8,4.3997e+04_r8,3.6663e+04_r8,2.9331e+04_r8,2.1998e+04_r8, &
     &1.4665e+04_r8,7.3324e+03_r8,2.9843e-02_r8/)
      kao(:, 4,13,12) = (/ &
     &5.8145e+04_r8,5.0874e+04_r8,4.3608e+04_r8,3.6342e+04_r8,2.9072e+04_r8,2.1804e+04_r8, &
     &1.4536e+04_r8,7.2678e+03_r8,5.7821e-02_r8/)
      kao(:, 5,13,12) = (/ &
     &5.7447e+04_r8,5.0266e+04_r8,4.3086e+04_r8,3.5905e+04_r8,2.8722e+04_r8,2.1542e+04_r8, &
     &1.4361e+04_r8,7.1808e+03_r8,1.1510e-01_r8/)
      kao(:, 1, 1,13) = (/ &
     &9.2441e+00_r8,8.0893e+00_r8,6.9334e+00_r8,5.7782e+00_r8,4.6228e+00_r8,3.4672e+00_r8, &
     &2.3119e+00_r8,1.1567e+00_r8,2.2855e-01_r8/)
      kao(:, 2, 1,13) = (/ &
     &8.8623e+00_r8,7.7552e+00_r8,6.6473e+00_r8,5.5397e+00_r8,4.4320e+00_r8,3.3245e+00_r8, &
     &2.2168e+00_r8,1.1091e+00_r8,3.2335e-01_r8/)
      kao(:, 3, 1,13) = (/ &
     &8.4833e+00_r8,7.4233e+00_r8,6.3625e+00_r8,5.3026e+00_r8,4.2423e+00_r8,3.1825e+00_r8, &
     &2.1219e+00_r8,1.0618e+00_r8,4.4367e-01_r8/)
      kao(:, 4, 1,13) = (/ &
     &8.1215e+00_r8,7.1065e+00_r8,6.0917e+00_r8,5.0761e+00_r8,4.0614e+00_r8,3.0468e+00_r8, &
     &2.0316e+00_r8,1.0641e+00_r8,5.9167e-01_r8/)
      kao(:, 5, 1,13) = (/ &
     &7.7672e+00_r8,6.7964e+00_r8,5.8258e+00_r8,4.8545e+00_r8,3.8845e+00_r8,2.9137e+00_r8, &
     &1.9430e+00_r8,1.0446e+00_r8,7.6901e-01_r8/)
      kao(:, 1, 2,13) = (/ &
     &1.4699e+01_r8,1.2863e+01_r8,1.1024e+01_r8,9.1876e+00_r8,7.3499e+00_r8,5.5129e+00_r8, &
     &3.6758e+00_r8,1.8383e+00_r8,2.1901e-01_r8/)
      kao(:, 2, 2,13) = (/ &
     &1.4081e+01_r8,1.2321e+01_r8,1.0561e+01_r8,8.8012e+00_r8,7.0414e+00_r8,5.2809e+00_r8, &
     &3.5211e+00_r8,1.7613e+00_r8,3.1665e-01_r8/)
      kao(:, 3, 2,13) = (/ &
     &1.3470e+01_r8,1.1786e+01_r8,1.0102e+01_r8,8.4178e+00_r8,6.7345e+00_r8,5.0512e+00_r8, &
     &3.3678e+00_r8,1.6847e+00_r8,4.4141e-01_r8/)
      kao(:, 4, 2,13) = (/ &
     &1.2871e+01_r8,1.1263e+01_r8,9.6542e+00_r8,8.0452e+00_r8,6.4365e+00_r8,4.8276e+00_r8, &
     &3.2187e+00_r8,1.6111e+00_r8,5.9558e-01_r8/)
      kao(:, 5, 2,13) = (/ &
     &1.2298e+01_r8,1.0761e+01_r8,9.2242e+00_r8,7.6869e+00_r8,6.1502e+00_r8,4.6127e+00_r8, &
     &3.0756e+00_r8,1.6035e+00_r8,7.7652e-01_r8/)
      kao(:, 1, 3,13) = (/ &
     &3.1779e+01_r8,2.7807e+01_r8,2.3834e+01_r8,1.9863e+01_r8,1.5890e+01_r8,1.1918e+01_r8, &
     &7.9454e+00_r8,3.9733e+00_r8,1.9638e-01_r8/)
      kao(:, 2, 3,13) = (/ &
     &3.0431e+01_r8,2.6628e+01_r8,2.2823e+01_r8,1.9020e+01_r8,1.5217e+01_r8,1.1412e+01_r8, &
     &7.6086e+00_r8,3.8049e+00_r8,2.7736e-01_r8/)
      kao(:, 3, 3,13) = (/ &
     &2.9103e+01_r8,2.5465e+01_r8,2.1826e+01_r8,1.8188e+01_r8,1.4551e+01_r8,1.0914e+01_r8, &
     &7.2766e+00_r8,3.6387e+00_r8,3.9551e-01_r8/)
      kao(:, 4, 3,13) = (/ &
     &2.7810e+01_r8,2.4334e+01_r8,2.0858e+01_r8,1.7381e+01_r8,1.3906e+01_r8,1.0429e+01_r8, &
     &6.9532e+00_r8,3.4769e+00_r8,5.4452e-01_r8/)
      kao(:, 5, 3,13) = (/ &
     &2.6585e+01_r8,2.3262e+01_r8,1.9938e+01_r8,1.6616e+01_r8,1.3293e+01_r8,9.9693e+00_r8, &
     &6.6465e+00_r8,3.3243e+00_r8,7.1925e-01_r8/)
      kao(:, 1, 4,13) = (/ &
     &7.0542e+01_r8,6.1725e+01_r8,5.2909e+01_r8,4.4087e+01_r8,3.5272e+01_r8,2.6453e+01_r8, &
     &1.7635e+01_r8,8.8184e+00_r8,1.8199e-01_r8/)
      kao(:, 2, 4,13) = (/ &
     &6.7511e+01_r8,5.9069e+01_r8,5.0634e+01_r8,4.2192e+01_r8,3.3755e+01_r8,2.5317e+01_r8, &
     &1.6878e+01_r8,8.4389e+00_r8,2.4599e-01_r8/)
      kao(:, 3, 4,13) = (/ &
     &6.4633e+01_r8,5.6554e+01_r8,4.8477e+01_r8,4.0397e+01_r8,3.2316e+01_r8,2.4237e+01_r8, &
     &1.6158e+01_r8,8.0799e+00_r8,3.3970e-01_r8/)
      kao(:, 4, 4,13) = (/ &
     &6.1828e+01_r8,5.4103e+01_r8,4.6370e+01_r8,3.8643e+01_r8,3.0915e+01_r8,2.3186e+01_r8, &
     &1.5458e+01_r8,7.7299e+00_r8,4.6987e-01_r8/)
      kao(:, 5, 4,13) = (/ &
     &5.9112e+01_r8,5.1730e+01_r8,4.4337e+01_r8,3.6946e+01_r8,2.9558e+01_r8,2.2169e+01_r8, &
     &1.4779e+01_r8,7.3903e+00_r8,6.3062e-01_r8/)
      kao(:, 1, 5,13) = (/ &
     &1.4439e+02_r8,1.2634e+02_r8,1.0830e+02_r8,9.0248e+01_r8,7.2199e+01_r8,5.4151e+01_r8, &
     &3.6099e+01_r8,1.8050e+01_r8,1.6579e-01_r8/)
      kao(:, 2, 5,13) = (/ &
     &1.3838e+02_r8,1.2109e+02_r8,1.0378e+02_r8,8.6480e+01_r8,6.9180e+01_r8,5.1890e+01_r8, &
     &3.4593e+01_r8,1.7299e+01_r8,2.2988e-01_r8/)
      kao(:, 3, 5,13) = (/ &
     &1.3259e+02_r8,1.1602e+02_r8,9.9432e+01_r8,8.2860e+01_r8,6.6285e+01_r8,4.9718e+01_r8, &
     &3.3146e+01_r8,1.6573e+01_r8,3.1063e-01_r8/)
      kao(:, 4, 5,13) = (/ &
     &1.2697e+02_r8,1.1110e+02_r8,9.5219e+01_r8,7.9357e+01_r8,6.3482e+01_r8,4.7609e+01_r8, &
     &3.1740e+01_r8,1.5871e+01_r8,4.1510e-01_r8/)
      kao(:, 5, 5,13) = (/ &
     &1.2152e+02_r8,1.0632e+02_r8,9.1129e+01_r8,7.5942e+01_r8,6.0752e+01_r8,4.5568e+01_r8, &
     &3.0378e+01_r8,1.5190e+01_r8,5.5503e-01_r8/)
      kao(:, 1, 6,13) = (/ &
     &2.7815e+02_r8,2.4339e+02_r8,2.0862e+02_r8,1.7384e+02_r8,1.3908e+02_r8,1.0430e+02_r8, &
     &6.9541e+01_r8,3.4769e+01_r8,1.4932e-01_r8/)
      kao(:, 2, 6,13) = (/ &
     &2.6703e+02_r8,2.3365e+02_r8,2.0028e+02_r8,1.6690e+02_r8,1.3351e+02_r8,1.0014e+02_r8, &
     &6.6764e+01_r8,3.3381e+01_r8,2.1038e-01_r8/)
      kao(:, 3, 6,13) = (/ &
     &2.5610e+02_r8,2.2409e+02_r8,1.9207e+02_r8,1.6007e+02_r8,1.2805e+02_r8,9.6039e+01_r8, &
     &6.4025e+01_r8,3.2016e+01_r8,2.9193e-01_r8/)
      kao(:, 4, 6,13) = (/ &
     &2.4602e+02_r8,2.1527e+02_r8,1.8451e+02_r8,1.5376e+02_r8,1.2300e+02_r8,9.2253e+01_r8, &
     &6.1503e+01_r8,3.0752e+01_r8,3.8735e-01_r8/)
      kao(:, 5, 6,13) = (/ &
     &2.3698e+02_r8,2.0737e+02_r8,1.7775e+02_r8,1.4811e+02_r8,1.1849e+02_r8,8.8866e+01_r8, &
     &5.9248e+01_r8,2.9622e+01_r8,5.0567e-01_r8/)
      kao(:, 1, 7,13) = (/ &
     &5.6531e+02_r8,4.9465e+02_r8,4.2396e+02_r8,3.5331e+02_r8,2.8267e+02_r8,2.1198e+02_r8, &
     &1.4132e+02_r8,7.0665e+01_r8,1.3236e-01_r8/)
      kao(:, 2, 7,13) = (/ &
     &5.4477e+02_r8,4.7663e+02_r8,4.0854e+02_r8,3.4045e+02_r8,2.7236e+02_r8,2.0426e+02_r8, &
     &1.3618e+02_r8,6.8089e+01_r8,1.9224e-01_r8/)
      kao(:, 3, 7,13) = (/ &
     &5.2553e+02_r8,4.5986e+02_r8,3.9416e+02_r8,3.2848e+02_r8,2.6277e+02_r8,1.9706e+02_r8, &
     &1.3138e+02_r8,6.5693e+01_r8,2.7007e-01_r8/)
      kao(:, 4, 7,13) = (/ &
     &5.0736e+02_r8,4.4395e+02_r8,3.8050e+02_r8,3.1709e+02_r8,2.5367e+02_r8,1.9026e+02_r8, &
     &1.2684e+02_r8,6.3421e+01_r8,3.6853e-01_r8/)
      kao(:, 5, 7,13) = (/ &
     &4.8966e+02_r8,4.2846e+02_r8,3.6727e+02_r8,3.0605e+02_r8,2.4484e+02_r8,1.8364e+02_r8, &
     &1.2242e+02_r8,6.1208e+01_r8,4.8516e-01_r8/)
      kao(:, 1, 8,13) = (/ &
     &1.3865e+03_r8,1.2132e+03_r8,1.0399e+03_r8,8.6656e+02_r8,6.9323e+02_r8,5.1995e+02_r8, &
     &3.4663e+02_r8,1.7332e+02_r8,1.1342e-01_r8/)
      kao(:, 2, 8,13) = (/ &
     &1.3418e+03_r8,1.1740e+03_r8,1.0063e+03_r8,8.3858e+02_r8,6.7084e+02_r8,5.0312e+02_r8, &
     &3.3544e+02_r8,1.6771e+02_r8,1.7153e-01_r8/)
      kao(:, 3, 8,13) = (/ &
     &1.2982e+03_r8,1.1360e+03_r8,9.7362e+02_r8,8.1138e+02_r8,6.4912e+02_r8,4.8683e+02_r8, &
     &3.2456e+02_r8,1.6229e+02_r8,2.4648e-01_r8/)
      kao(:, 4, 8,13) = (/ &
     &1.2554e+03_r8,1.0986e+03_r8,9.4155e+02_r8,7.8470e+02_r8,6.2776e+02_r8,4.7081e+02_r8, &
     &3.1388e+02_r8,1.5694e+02_r8,3.4456e-01_r8/)
      kao(:, 5, 8,13) = (/ &
     &1.2173e+03_r8,1.0650e+03_r8,9.1289e+02_r8,7.6069e+02_r8,6.0860e+02_r8,4.5645e+02_r8, &
     &3.0428e+02_r8,1.5215e+02_r8,4.6320e-01_r8/)
      kao(:, 1, 9,13) = (/ &
     &6.4287e+03_r8,5.6254e+03_r8,4.8220e+03_r8,4.0184e+03_r8,3.2146e+03_r8,2.4108e+03_r8, &
     &1.6072e+03_r8,8.0366e+02_r8,9.3435e-02_r8/)
      kao(:, 2, 9,13) = (/ &
     &6.2433e+03_r8,5.4627e+03_r8,4.6824e+03_r8,3.9018e+03_r8,3.1215e+03_r8,2.3411e+03_r8, &
     &1.5608e+03_r8,7.8032e+02_r8,1.4681e-01_r8/)
      kao(:, 3, 9,13) = (/ &
     &6.0612e+03_r8,5.3034e+03_r8,4.5455e+03_r8,3.7883e+03_r8,3.0305e+03_r8,2.2728e+03_r8, &
     &1.5153e+03_r8,7.5756e+02_r8,2.1819e-01_r8/)
      kao(:, 4, 9,13) = (/ &
     &5.8977e+03_r8,5.1604e+03_r8,4.4231e+03_r8,3.6861e+03_r8,2.9487e+03_r8,2.2117e+03_r8, &
     &1.4744e+03_r8,7.3720e+02_r8,3.1394e-01_r8/)
      kao(:, 5, 9,13) = (/ &
     &5.7293e+03_r8,5.0131e+03_r8,4.2969e+03_r8,3.5807e+03_r8,2.8646e+03_r8,2.1484e+03_r8, &
     &1.4323e+03_r8,7.1617e+02_r8,4.3083e-01_r8/)
      kao(:, 1,10,13) = (/ &
     &3.3200e+04_r8,2.9050e+04_r8,2.4899e+04_r8,2.0749e+04_r8,1.6600e+04_r8,1.2450e+04_r8, &
     &8.2998e+03_r8,4.1501e+03_r8,1.3035e-02_r8/)
      kao(:, 2,10,13) = (/ &
     &3.2379e+04_r8,2.8331e+04_r8,2.4286e+04_r8,2.0236e+04_r8,1.6189e+04_r8,1.2142e+04_r8, &
     &8.0946e+03_r8,4.0474e+03_r8,6.4014e-02_r8/)
      kao(:, 3,10,13) = (/ &
     &3.1566e+04_r8,2.7621e+04_r8,2.3674e+04_r8,1.9730e+04_r8,1.5784e+04_r8,1.1837e+04_r8, &
     &7.8919e+03_r8,3.9461e+03_r8,1.0897e-01_r8/)
      kao(:, 4,10,13) = (/ &
     &3.0728e+04_r8,2.6888e+04_r8,2.3048e+04_r8,1.9205e+04_r8,1.5364e+04_r8,1.1523e+04_r8, &
     &7.6820e+03_r8,3.8409e+03_r8,2.5342e-01_r8/)
      kao(:, 5,10,13) = (/ &
     &2.9824e+04_r8,2.6098e+04_r8,2.2369e+04_r8,1.8641e+04_r8,1.4913e+04_r8,1.1185e+04_r8, &
     &7.4563e+03_r8,3.7282e+03_r8,3.9865e-01_r8/)
      kao(:, 1,11,13) = (/ &
     &5.8997e+04_r8,5.1626e+04_r8,4.4246e+04_r8,3.6876e+04_r8,2.9498e+04_r8,2.2124e+04_r8, &
     &1.4750e+04_r8,7.3749e+03_r8,3.4853e-05_r8/)
      kao(:, 2,11,13) = (/ &
     &5.7601e+04_r8,5.0403e+04_r8,4.3203e+04_r8,3.6002e+04_r8,2.8802e+04_r8,2.1601e+04_r8, &
     &1.4400e+04_r8,7.2004e+03_r8,3.9149e-02_r8/)
      kao(:, 3,11,13) = (/ &
     &5.6184e+04_r8,4.9162e+04_r8,4.2136e+04_r8,3.5117e+04_r8,2.8092e+04_r8,2.1068e+04_r8, &
     &1.4046e+04_r8,7.0226e+03_r8,4.1745e-02_r8/)
      kao(:, 4,11,13) = (/ &
     &5.4639e+04_r8,4.7807e+04_r8,4.0979e+04_r8,3.4149e+04_r8,2.7319e+04_r8,2.0489e+04_r8, &
     &1.3659e+04_r8,6.8303e+03_r8,1.4397e-01_r8/)
      kao(:, 5,11,13) = (/ &
     &5.3017e+04_r8,4.6389e+04_r8,3.9763e+04_r8,3.3137e+04_r8,2.6509e+04_r8,1.9881e+04_r8, &
     &1.3255e+04_r8,6.6269e+03_r8,2.2772e-01_r8/)
      kao(:, 1,12,13) = (/ &
     &7.7971e+04_r8,6.8226e+04_r8,5.8475e+04_r8,4.8732e+04_r8,3.8985e+04_r8,2.9238e+04_r8, &
     &1.9491e+04_r8,9.7458e+03_r8,2.6211e-05_r8/)
      kao(:, 2,12,13) = (/ &
     &7.6358e+04_r8,6.6812e+04_r8,5.7265e+04_r8,4.7721e+04_r8,3.8180e+04_r8,2.8631e+04_r8, &
     &1.9088e+04_r8,9.5449e+03_r8,1.6658e-02_r8/)
      kao(:, 3,12,13) = (/ &
     &7.4598e+04_r8,6.5272e+04_r8,5.5949e+04_r8,4.6623e+04_r8,3.7300e+04_r8,2.7976e+04_r8, &
     &1.8650e+04_r8,9.3250e+03_r8,6.1472e-02_r8/)
      kao(:, 4,12,13) = (/ &
     &7.2683e+04_r8,6.3600e+04_r8,5.4513e+04_r8,4.5429e+04_r8,3.6343e+04_r8,2.7256e+04_r8, &
     &1.8171e+04_r8,9.0852e+03_r8,8.7020e-02_r8/)
      kao(:, 5,12,13) = (/ &
     &7.0749e+04_r8,6.1901e+04_r8,5.3059e+04_r8,4.4221e+04_r8,3.5375e+04_r8,2.6529e+04_r8, &
     &1.7687e+04_r8,8.8438e+03_r8,2.2135e-01_r8/)
      kao(:, 1,13,13) = (/ &
     &8.4389e+04_r8,7.3841e+04_r8,6.3292e+04_r8,5.2741e+04_r8,4.2193e+04_r8,3.1646e+04_r8, &
     &2.1097e+04_r8,1.0548e+04_r8,3.5977e-05_r8/)
      kao(:, 2,13,13) = (/ &
     &8.2810e+04_r8,7.2462e+04_r8,6.2107e+04_r8,5.1755e+04_r8,4.1404e+04_r8,3.1055e+04_r8, &
     &2.0703e+04_r8,1.0351e+04_r8,2.8201e-02_r8/)
      kao(:, 3,13,13) = (/ &
     &8.1175e+04_r8,7.1028e+04_r8,6.0878e+04_r8,5.0733e+04_r8,4.0585e+04_r8,3.0440e+04_r8, &
     &2.0293e+04_r8,1.0147e+04_r8,3.8140e-02_r8/)
      kao(:, 4,13,13) = (/ &
     &7.9409e+04_r8,6.9476e+04_r8,5.9554e+04_r8,4.9626e+04_r8,3.9700e+04_r8,2.9777e+04_r8, &
     &1.9850e+04_r8,9.9254e+03_r8,1.0573e-01_r8/)
      kao(:, 5,13,13) = (/ &
     &7.7670e+04_r8,6.7959e+04_r8,5.8251e+04_r8,4.8545e+04_r8,3.8836e+04_r8,2.9127e+04_r8, &
     &1.9417e+04_r8,9.7081e+03_r8,2.2322e-01_r8/)
      kao(:, 1, 1,14) = (/ &
     &1.0586e+01_r8,9.2639e+00_r8,7.9401e+00_r8,6.6170e+00_r8,5.2941e+00_r8,3.9707e+00_r8, &
     &2.6478e+00_r8,1.3250e+00_r8,4.3918e-01_r8/)
      kao(:, 2, 1,14) = (/ &
     &1.0067e+01_r8,8.8090e+00_r8,7.5510e+00_r8,6.2924e+00_r8,5.0343e+00_r8,3.7761e+00_r8, &
     &2.5179e+00_r8,1.2597e+00_r8,5.9709e-01_r8/)
      kao(:, 3, 1,14) = (/ &
     &9.5510e+00_r8,8.3580e+00_r8,7.1635e+00_r8,5.9699e+00_r8,4.7763e+00_r8,3.5829e+00_r8, &
     &2.3891e+00_r8,1.1957e+00_r8,7.8623e-01_r8/)
      kao(:, 4, 1,14) = (/ &
     &9.0745e+00_r8,7.9402e+00_r8,6.8068e+00_r8,5.6724e+00_r8,4.5382e+00_r8,3.4039e+00_r8, &
     &2.2698e+00_r8,1.1544e+00_r8,1.0064e+00_r8/)
      kao(:, 5, 1,14) = (/ &
     &8.6119e+00_r8,7.5354e+00_r8,6.4586e+00_r8,5.3823e+00_r8,4.3069e+00_r8,3.2305e+00_r8, &
     &2.1544e+00_r8,1.1513e+00_r8,1.2568e+00_r8/)
      kao(:, 1, 2,14) = (/ &
     &1.7127e+01_r8,1.4988e+01_r8,1.2847e+01_r8,1.0706e+01_r8,8.5644e+00_r8,6.4237e+00_r8, &
     &4.2830e+00_r8,2.1424e+00_r8,4.0087e-01_r8/)
      kao(:, 2, 2,14) = (/ &
     &1.6266e+01_r8,1.4233e+01_r8,1.2199e+01_r8,1.0167e+01_r8,8.1334e+00_r8,6.1003e+00_r8, &
     &4.0675e+00_r8,2.0344e+00_r8,5.5811e-01_r8/)
      kao(:, 3, 2,14) = (/ &
     &1.5417e+01_r8,1.3492e+01_r8,1.1564e+01_r8,9.6364e+00_r8,7.7096e+00_r8,5.7829e+00_r8, &
     &3.8557e+00_r8,1.9285e+00_r8,7.4958e-01_r8/)
      kao(:, 4, 2,14) = (/ &
     &1.4610e+01_r8,1.2785e+01_r8,1.0958e+01_r8,9.1323e+00_r8,7.3057e+00_r8,5.4803e+00_r8, &
     &3.6538e+00_r8,1.8278e+00_r8,9.7668e-01_r8/)
      kao(:, 5, 2,14) = (/ &
     &1.3849e+01_r8,1.2118e+01_r8,1.0388e+01_r8,8.6567e+00_r8,6.9253e+00_r8,5.1944e+00_r8, &
     &3.4637e+00_r8,1.7621e+00_r8,1.2463e+00_r8/)
      kao(:, 1, 3,14) = (/ &
     &3.7731e+01_r8,3.3014e+01_r8,2.8298e+01_r8,2.3584e+01_r8,1.8865e+01_r8,1.4149e+01_r8, &
     &9.4337e+00_r8,4.7180e+00_r8,3.4082e-01_r8/)
      kao(:, 2, 3,14) = (/ &
     &3.5785e+01_r8,3.1314e+01_r8,2.6842e+01_r8,2.2368e+01_r8,1.7895e+01_r8,1.3421e+01_r8, &
     &8.9480e+00_r8,4.4747e+00_r8,4.8919e-01_r8/)
      kao(:, 3, 3,14) = (/ &
     &3.3896e+01_r8,2.9659e+01_r8,2.5426e+01_r8,2.1185e+01_r8,1.6948e+01_r8,1.2712e+01_r8, &
     &8.4759e+00_r8,4.2386e+00_r8,6.7406e-01_r8/)
      kao(:, 4, 3,14) = (/ &
     &3.2057e+01_r8,2.8051e+01_r8,2.4047e+01_r8,2.0037e+01_r8,1.6031e+01_r8,1.2024e+01_r8, &
     &8.0158e+00_r8,4.0086e+00_r8,8.9895e-01_r8/)
      kao(:, 5, 3,14) = (/ &
     &3.0352e+01_r8,2.6560e+01_r8,2.2767e+01_r8,1.8972e+01_r8,1.5176e+01_r8,1.1383e+01_r8, &
     &7.5899e+00_r8,3.7954e+00_r8,1.1745e+00_r8/)
      kao(:, 1, 4,14) = (/ &
     &8.5512e+01_r8,7.4816e+01_r8,6.4130e+01_r8,5.3439e+01_r8,4.2750e+01_r8,3.2066e+01_r8, &
     &2.1376e+01_r8,1.0689e+01_r8,2.7979e-01_r8/)
      kao(:, 2, 4,14) = (/ &
     &8.0825e+01_r8,7.0719e+01_r8,6.0615e+01_r8,5.0514e+01_r8,4.0410e+01_r8,3.0306e+01_r8, &
     &2.0206e+01_r8,1.0104e+01_r8,4.1456e-01_r8/)
      kao(:, 3, 4,14) = (/ &
     &7.6512e+01_r8,6.6951e+01_r8,5.7383e+01_r8,4.7821e+01_r8,3.8259e+01_r8,2.8694e+01_r8, &
     &1.9130e+01_r8,9.5655e+00_r8,5.8875e-01_r8/)
      kao(:, 4, 4,14) = (/ &
     &7.2339e+01_r8,6.3299e+01_r8,5.4254e+01_r8,4.5213e+01_r8,3.6173e+01_r8,2.7127e+01_r8, &
     &1.8087e+01_r8,9.0435e+00_r8,8.0998e-01_r8/)
      kao(:, 5, 4,14) = (/ &
     &6.8331e+01_r8,5.9800e+01_r8,5.1253e+01_r8,4.2714e+01_r8,3.4172e+01_r8,2.5627e+01_r8, &
     &1.7086e+01_r8,8.5443e+00_r8,1.0852e+00_r8/)
      kao(:, 1, 5,14) = (/ &
     &1.7862e+02_r8,1.5630e+02_r8,1.3397e+02_r8,1.1164e+02_r8,8.9317e+01_r8,6.6992e+01_r8, &
     &4.4659e+01_r8,2.2329e+01_r8,2.4222e-01_r8/)
      kao(:, 2, 5,14) = (/ &
     &1.6866e+02_r8,1.4756e+02_r8,1.2649e+02_r8,1.0541e+02_r8,8.4332e+01_r8,6.3244e+01_r8, &
     &4.2162e+01_r8,2.1082e+01_r8,3.4856e-01_r8/)
      kao(:, 3, 5,14) = (/ &
     &1.5941e+02_r8,1.3948e+02_r8,1.1955e+02_r8,9.9631e+01_r8,7.9709e+01_r8,5.9780e+01_r8, &
     &3.9852e+01_r8,1.9927e+01_r8,5.0734e-01_r8/)
      kao(:, 4, 5,14) = (/ &
     &1.5067e+02_r8,1.3184e+02_r8,1.1302e+02_r8,9.4183e+01_r8,7.5341e+01_r8,5.6507e+01_r8, &
     &3.7674e+01_r8,1.8837e+01_r8,7.2180e-01_r8/)
      kao(:, 5, 5,14) = (/ &
     &1.4230e+02_r8,1.2451e+02_r8,1.0671e+02_r8,8.8935e+01_r8,7.1153e+01_r8,5.3363e+01_r8, &
     &3.5577e+01_r8,1.7789e+01_r8,9.9362e-01_r8/)
      kao(:, 1, 6,14) = (/ &
     &3.5096e+02_r8,3.0703e+02_r8,2.6318e+02_r8,2.1933e+02_r8,1.7546e+02_r8,1.3159e+02_r8, &
     &8.7733e+01_r8,4.3865e+01_r8,2.1734e-01_r8/)
      kao(:, 2, 6,14) = (/ &
     &3.3138e+02_r8,2.8996e+02_r8,2.4854e+02_r8,2.0711e+02_r8,1.6569e+02_r8,1.2426e+02_r8, &
     &8.2845e+01_r8,4.1423e+01_r8,3.0507e-01_r8/)
      kao(:, 3, 6,14) = (/ &
     &3.1254e+02_r8,2.7346e+02_r8,2.3441e+02_r8,1.9532e+02_r8,1.5627e+02_r8,1.1720e+02_r8, &
     &7.8130e+01_r8,3.9066e+01_r8,4.3270e-01_r8/)
      kao(:, 4, 6,14) = (/ &
     &2.9529e+02_r8,2.5841e+02_r8,2.2148e+02_r8,1.8456e+02_r8,1.4764e+02_r8,1.1074e+02_r8, &
     &7.3826e+01_r8,3.6914e+01_r8,6.2701e-01_r8/)
      kao(:, 5, 6,14) = (/ &
     &2.7880e+02_r8,2.4396e+02_r8,2.0911e+02_r8,1.7424e+02_r8,1.3940e+02_r8,1.0455e+02_r8, &
     &6.9706e+01_r8,3.4852e+01_r8,8.8890e-01_r8/)
      kao(:, 1, 7,14) = (/ &
     &7.2513e+02_r8,6.3446e+02_r8,5.4381e+02_r8,4.5320e+02_r8,3.6257e+02_r8,2.7191e+02_r8, &
     &1.8128e+02_r8,9.0650e+01_r8,1.9831e-01_r8/)
      kao(:, 2, 7,14) = (/ &
     &6.8456e+02_r8,5.9902e+02_r8,5.1343e+02_r8,4.2785e+02_r8,3.4230e+02_r8,2.5672e+02_r8, &
     &1.7115e+02_r8,8.5572e+01_r8,2.7818e-01_r8/)
      kao(:, 3, 7,14) = (/ &
     &6.4547e+02_r8,5.6482e+02_r8,4.8412e+02_r8,4.0342e+02_r8,3.2273e+02_r8,2.4204e+02_r8, &
     &1.6137e+02_r8,8.0688e+01_r8,3.8833e-01_r8/)
      kao(:, 4, 7,14) = (/ &
     &6.0978e+02_r8,5.3357e+02_r8,4.5735e+02_r8,3.8114e+02_r8,3.0489e+02_r8,2.2868e+02_r8, &
     &1.5246e+02_r8,7.6224e+01_r8,5.4866e-01_r8/)
      kao(:, 5, 7,14) = (/ &
     &5.7729e+02_r8,5.0509e+02_r8,4.3294e+02_r8,3.6078e+02_r8,2.8862e+02_r8,2.1646e+02_r8, &
     &1.4432e+02_r8,7.2163e+01_r8,7.7837e-01_r8/)
      kao(:, 1, 8,14) = (/ &
     &1.7967e+03_r8,1.5721e+03_r8,1.3476e+03_r8,1.1230e+03_r8,8.9837e+02_r8,6.7379e+02_r8, &
     &4.4917e+02_r8,2.2458e+02_r8,1.7788e-01_r8/)
      kao(:, 2, 8,14) = (/ &
     &1.7006e+03_r8,1.4881e+03_r8,1.2754e+03_r8,1.0629e+03_r8,8.5028e+02_r8,6.3778e+02_r8, &
     &4.2515e+02_r8,2.1258e+02_r8,2.5421e-01_r8/)
      kao(:, 3, 8,14) = (/ &
     &1.6106e+03_r8,1.4094e+03_r8,1.2079e+03_r8,1.0068e+03_r8,8.0532e+02_r8,6.0404e+02_r8, &
     &4.0268e+02_r8,2.0135e+02_r8,3.5995e-01_r8/)
      kao(:, 4, 8,14) = (/ &
     &1.5246e+03_r8,1.3340e+03_r8,1.1435e+03_r8,9.5278e+02_r8,7.6226e+02_r8,5.7172e+02_r8, &
     &3.8114e+02_r8,1.9058e+02_r8,4.9908e-01_r8/)
      kao(:, 5, 8,14) = (/ &
     &1.4465e+03_r8,1.2656e+03_r8,1.0849e+03_r8,9.0407e+02_r8,7.2320e+02_r8,5.4242e+02_r8, &
     &3.6158e+02_r8,1.8081e+02_r8,6.9586e-01_r8/)
      kao(:, 1, 9,14) = (/ &
     &8.4840e+03_r8,7.4233e+03_r8,6.3628e+03_r8,5.3023e+03_r8,4.2423e+03_r8,3.1813e+03_r8, &
     &2.1210e+03_r8,1.0605e+03_r8,1.5591e-01_r8/)
      kao(:, 2, 9,14) = (/ &
     &8.0479e+03_r8,7.0418e+03_r8,6.0359e+03_r8,5.0301e+03_r8,4.0241e+03_r8,3.0180e+03_r8, &
     &2.0121e+03_r8,1.0060e+03_r8,2.2879e-01_r8/)
      kao(:, 3, 9,14) = (/ &
     &7.6325e+03_r8,6.6786e+03_r8,5.7241e+03_r8,4.7707e+03_r8,3.8161e+03_r8,2.8622e+03_r8, &
     &1.9081e+03_r8,9.5403e+02_r8,3.3113e-01_r8/)
      kao(:, 4, 9,14) = (/ &
     &7.2431e+03_r8,6.3376e+03_r8,5.4325e+03_r8,4.5268e+03_r8,3.6217e+03_r8,2.7162e+03_r8, &
     &1.8109e+03_r8,9.0539e+02_r8,4.6545e-01_r8/)
      kao(:, 5, 9,14) = (/ &
     &6.8956e+03_r8,6.0340e+03_r8,5.1720e+03_r8,4.3099e+03_r8,3.4482e+03_r8,2.5859e+03_r8, &
     &1.7240e+03_r8,8.6204e+02_r8,6.4091e-01_r8/)
      kao(:, 1,10,14) = (/ &
     &4.4703e+04_r8,3.9114e+04_r8,3.3523e+04_r8,2.7938e+04_r8,2.2351e+04_r8,1.6764e+04_r8, &
     &1.1175e+04_r8,5.5874e+03_r8,4.1455e-02_r8/)
      kao(:, 2,10,14) = (/ &
     &4.2474e+04_r8,3.7167e+04_r8,3.1854e+04_r8,2.6544e+04_r8,2.1238e+04_r8,1.5927e+04_r8, &
     &1.0619e+04_r8,5.3089e+03_r8,6.6750e-02_r8/)
      kao(:, 3,10,14) = (/ &
     &4.0460e+04_r8,3.5405e+04_r8,3.0347e+04_r8,2.5289e+04_r8,2.0232e+04_r8,1.5174e+04_r8, &
     &1.0116e+04_r8,5.0578e+03_r8,2.7442e-01_r8/)
      kao(:, 4,10,14) = (/ &
     &3.8625e+04_r8,3.3797e+04_r8,2.8970e+04_r8,2.4141e+04_r8,1.9313e+04_r8,1.4484e+04_r8, &
     &9.6562e+03_r8,4.8282e+03_r8,4.4714e-01_r8/)
      kao(:, 5,10,14) = (/ &
     &3.6998e+04_r8,3.2375e+04_r8,2.7750e+04_r8,2.3124e+04_r8,1.8498e+04_r8,1.3874e+04_r8, &
     &9.2495e+03_r8,4.6247e+03_r8,6.1795e-01_r8/)
      kao(:, 1,11,14) = (/ &
     &8.0689e+04_r8,7.0605e+04_r8,6.0514e+04_r8,5.0431e+04_r8,4.0345e+04_r8,3.0258e+04_r8, &
     &2.0175e+04_r8,1.0088e+04_r8,2.7556e-05_r8/)
      kao(:, 2,11,14) = (/ &
     &7.7103e+04_r8,6.7463e+04_r8,5.7832e+04_r8,4.8186e+04_r8,3.8550e+04_r8,2.8913e+04_r8, &
     &1.9275e+04_r8,9.6376e+03_r8,4.0930e-02_r8/)
      kao(:, 3,11,14) = (/ &
     &7.3820e+04_r8,6.4596e+04_r8,5.5369e+04_r8,4.6139e+04_r8,3.6913e+04_r8,2.7687e+04_r8, &
     &1.8457e+04_r8,9.2272e+03_r8,8.1894e-02_r8/)
      kao(:, 4,11,14) = (/ &
     &7.1047e+04_r8,6.2162e+04_r8,5.3281e+04_r8,4.4402e+04_r8,3.5522e+04_r8,2.6643e+04_r8, &
     &1.7761e+04_r8,8.8802e+03_r8,2.3203e-01_r8/)
      kao(:, 5,11,14) = (/ &
     &6.8729e+04_r8,6.0139e+04_r8,5.1549e+04_r8,4.2956e+04_r8,3.4366e+04_r8,2.5774e+04_r8, &
     &1.7184e+04_r8,8.5912e+03_r8,5.4821e-01_r8/)
      kao(:, 1,12,14) = (/ &
     &1.0931e+05_r8,9.5652e+04_r8,8.1990e+04_r8,6.8319e+04_r8,5.4655e+04_r8,4.0991e+04_r8, &
     &2.7328e+04_r8,1.3665e+04_r8,2.8846e-05_r8/)
      kao(:, 2,12,14) = (/ &
     &1.0521e+05_r8,9.2062e+04_r8,7.8903e+04_r8,6.5759e+04_r8,5.2606e+04_r8,3.9453e+04_r8, &
     &2.6301e+04_r8,1.3151e+04_r8,4.7358e-02_r8/)
      kao(:, 3,12,14) = (/ &
     &1.0163e+05_r8,8.8927e+04_r8,7.6219e+04_r8,6.3520e+04_r8,5.0816e+04_r8,3.8110e+04_r8, &
     &2.5405e+04_r8,1.2704e+04_r8,2.4382e-02_r8/)
      kao(:, 4,12,14) = (/ &
     &9.8710e+04_r8,8.6365e+04_r8,7.4034e+04_r8,6.1691e+04_r8,4.9353e+04_r8,3.7016e+04_r8, &
     &2.4677e+04_r8,1.2338e+04_r8,1.4381e-01_r8/)
      kao(:, 5,12,14) = (/ &
     &9.6361e+04_r8,8.4318e+04_r8,7.2271e+04_r8,6.0231e+04_r8,4.8183e+04_r8,3.6135e+04_r8, &
     &2.4090e+04_r8,1.2044e+04_r8,3.4843e-01_r8/)
      kao(:, 1,13,14) = (/ &
     &1.2026e+05_r8,1.0522e+05_r8,9.0197e+04_r8,7.5158e+04_r8,6.0121e+04_r8,4.5095e+04_r8, &
     &3.0062e+04_r8,1.5030e+04_r8,2.3562e-05_r8/)
      kao(:, 2,13,14) = (/ &
     &1.1659e+05_r8,1.0201e+05_r8,8.7436e+04_r8,7.2864e+04_r8,5.8293e+04_r8,4.3717e+04_r8, &
     &2.9144e+04_r8,1.4573e+04_r8,1.6351e-02_r8/)
      kao(:, 3,13,14) = (/ &
     &1.1367e+05_r8,9.9464e+04_r8,8.5255e+04_r8,7.1046e+04_r8,5.6835e+04_r8,4.2627e+04_r8, &
     &2.8420e+04_r8,1.4209e+04_r8,2.9522e-02_r8/)
      kao(:, 4,13,14) = (/ &
     &1.1129e+05_r8,9.7380e+04_r8,8.3472e+04_r8,6.9552e+04_r8,5.5648e+04_r8,4.1732e+04_r8, &
     &2.7823e+04_r8,1.3911e+04_r8,7.5810e-02_r8/)
      kao(:, 5,13,14) = (/ &
     &1.0918e+05_r8,9.5534e+04_r8,8.1880e+04_r8,6.8241e+04_r8,5.4595e+04_r8,4.0946e+04_r8, &
     &2.7297e+04_r8,1.3648e+04_r8,2.4333e-01_r8/)
      kao(:, 1, 1,15) = (/ &
     &1.0978e+01_r8,9.6088e+00_r8,8.2350e+00_r8,6.8632e+00_r8,5.4910e+00_r8,4.1182e+00_r8, &
     &2.7459e+00_r8,1.3741e+00_r8,7.5097e-01_r8/)
      kao(:, 2, 1,15) = (/ &
     &1.0420e+01_r8,9.1192e+00_r8,7.8159e+00_r8,6.5136e+00_r8,5.2114e+00_r8,3.9092e+00_r8, &
     &2.6067e+00_r8,1.3044e+00_r8,1.0341e+00_r8/)
      kao(:, 3, 1,15) = (/ &
     &9.8688e+00_r8,8.6360e+00_r8,7.4026e+00_r8,6.1689e+00_r8,4.9358e+00_r8,3.7018e+00_r8, &
     &2.4689e+00_r8,1.2355e+00_r8,1.3726e+00_r8/)
      kao(:, 4, 1,15) = (/ &
     &9.3623e+00_r8,8.1910e+00_r8,7.0229e+00_r8,5.8526e+00_r8,4.6825e+00_r8,3.5124e+00_r8, &
     &2.3423e+00_r8,1.1838e+00_r8,1.7645e+00_r8/)
      kao(:, 5, 1,15) = (/ &
     &8.8716e+00_r8,7.7621e+00_r8,6.6540e+00_r8,5.5450e+00_r8,4.4367e+00_r8,3.3283e+00_r8, &
     &2.2197e+00_r8,1.4532e+00_r8,2.2082e+00_r8/)
      kao(:, 1, 2,15) = (/ &
     &1.7872e+01_r8,1.5635e+01_r8,1.3402e+01_r8,1.1169e+01_r8,8.9360e+00_r8,6.7019e+00_r8, &
     &4.4692e+00_r8,2.2349e+00_r8,7.8713e-01_r8/)
      kao(:, 2, 2,15) = (/ &
     &1.6936e+01_r8,1.4818e+01_r8,1.2703e+01_r8,1.0586e+01_r8,8.4684e+00_r8,6.3517e+00_r8, &
     &4.2352e+00_r8,2.1186e+00_r8,1.1015e+00_r8/)
      kao(:, 3, 2,15) = (/ &
     &1.6019e+01_r8,1.4019e+01_r8,1.2014e+01_r8,1.0011e+01_r8,8.0107e+00_r8,6.0080e+00_r8, &
     &4.0069e+00_r8,2.0039e+00_r8,1.4812e+00_r8/)
      kao(:, 4, 2,15) = (/ &
     &1.5152e+01_r8,1.3257e+01_r8,1.1364e+01_r8,9.4698e+00_r8,7.5770e+00_r8,5.6829e+00_r8, &
     &3.7895e+00_r8,1.8958e+00_r8,1.9253e+00_r8/)
      kao(:, 5, 2,15) = (/ &
     &1.4341e+01_r8,1.2547e+01_r8,1.0755e+01_r8,8.9625e+00_r8,7.1702e+00_r8,5.3783e+00_r8, &
     &3.5866e+00_r8,1.8251e+00_r8,2.4314e+00_r8/)
      kao(:, 1, 3,15) = (/ &
     &3.9644e+01_r8,3.4688e+01_r8,2.9736e+01_r8,2.4782e+01_r8,1.9827e+01_r8,1.4870e+01_r8, &
     &9.9132e+00_r8,4.9569e+00_r8,7.5098e-01_r8/)
      kao(:, 2, 3,15) = (/ &
     &3.7522e+01_r8,3.2831e+01_r8,2.8147e+01_r8,2.3453e+01_r8,1.8762e+01_r8,1.4073e+01_r8, &
     &9.3827e+00_r8,4.6920e+00_r8,1.0782e+00_r8/)
      kao(:, 3, 3,15) = (/ &
     &3.5460e+01_r8,3.1027e+01_r8,2.6599e+01_r8,2.2162e+01_r8,1.7731e+01_r8,1.3300e+01_r8, &
     &8.8666e+00_r8,4.4344e+00_r8,1.4809e+00_r8/)
      kao(:, 4, 3,15) = (/ &
     &3.3460e+01_r8,2.9273e+01_r8,2.5092e+01_r8,2.0911e+01_r8,1.6733e+01_r8,1.2547e+01_r8, &
     &8.3663e+00_r8,4.1837e+00_r8,1.9598e+00_r8/)
      kao(:, 5, 3,15) = (/ &
     &3.1621e+01_r8,2.7670e+01_r8,2.3718e+01_r8,1.9764e+01_r8,1.5811e+01_r8,1.1859e+01_r8, &
     &7.9074e+00_r8,3.9548e+00_r8,2.5132e+00_r8/)
      kao(:, 1, 4,15) = (/ &
     &9.0592e+01_r8,7.9274e+01_r8,6.7952e+01_r8,5.6623e+01_r8,4.5292e+01_r8,3.3974e+01_r8, &
     &2.2650e+01_r8,1.1327e+01_r8,6.7358e-01_r8/)
      kao(:, 2, 4,15) = (/ &
     &8.5357e+01_r8,7.4682e+01_r8,6.4009e+01_r8,5.3347e+01_r8,4.2676e+01_r8,3.2015e+01_r8, &
     &2.1340e+01_r8,1.0671e+01_r8,9.9693e-01_r8/)
      kao(:, 3, 4,15) = (/ &
     &8.0608e+01_r8,7.0531e+01_r8,6.0449e+01_r8,5.0384e+01_r8,4.0308e+01_r8,3.0230e+01_r8, &
     &2.0154e+01_r8,1.0079e+01_r8,1.4044e+00_r8/)
      kao(:, 4, 4,15) = (/ &
     &7.6021e+01_r8,6.6519e+01_r8,5.7017e+01_r8,4.7513e+01_r8,3.8009e+01_r8,2.8510e+01_r8, &
     &1.9006e+01_r8,9.5047e+00_r8,1.8983e+00_r8/)
      kao(:, 5, 4,15) = (/ &
     &7.1646e+01_r8,6.2695e+01_r8,5.3735e+01_r8,4.4783e+01_r8,3.5822e+01_r8,2.6870e+01_r8, &
     &1.7917e+01_r8,8.9586e+00_r8,2.4776e+00_r8/)
      kao(:, 1, 5,15) = (/ &
     &1.9065e+02_r8,1.6683e+02_r8,1.4299e+02_r8,1.1917e+02_r8,9.5320e+01_r8,7.1489e+01_r8, &
     &4.7665e+01_r8,2.3834e+01_r8,5.8170e-01_r8/)
      kao(:, 2, 5,15) = (/ &
     &1.7924e+02_r8,1.5681e+02_r8,1.3443e+02_r8,1.1201e+02_r8,8.9613e+01_r8,6.7209e+01_r8, &
     &4.4814e+01_r8,2.2406e+01_r8,8.9003e-01_r8/)
      kao(:, 3, 5,15) = (/ &
     &1.6878e+02_r8,1.4769e+02_r8,1.2660e+02_r8,1.0549e+02_r8,8.4396e+01_r8,6.3295e+01_r8, &
     &4.2198e+01_r8,2.1098e+01_r8,1.2889e+00_r8/)
      kao(:, 4, 5,15) = (/ &
     &1.5901e+02_r8,1.3914e+02_r8,1.1927e+02_r8,9.9403e+01_r8,7.9524e+01_r8,5.9641e+01_r8, &
     &3.9759e+01_r8,1.9881e+01_r8,1.7818e+00_r8/)
      kao(:, 5, 5,15) = (/ &
     &1.4967e+02_r8,1.3098e+02_r8,1.1227e+02_r8,9.3560e+01_r8,7.4846e+01_r8,5.6123e+01_r8, &
     &3.7423e+01_r8,1.8714e+01_r8,2.3703e+00_r8/)
      kao(:, 1, 6,15) = (/ &
     &3.7689e+02_r8,3.2969e+02_r8,2.8264e+02_r8,2.3553e+02_r8,1.8841e+02_r8,1.4134e+02_r8, &
     &9.4214e+01_r8,4.7104e+01_r8,4.7634e-01_r8/)
      kao(:, 2, 6,15) = (/ &
     &3.5386e+02_r8,3.0960e+02_r8,2.6540e+02_r8,2.2119e+02_r8,1.7694e+02_r8,1.3270e+02_r8, &
     &8.8456e+01_r8,4.4232e+01_r8,7.5759e-01_r8/)
      kao(:, 3, 6,15) = (/ &
     &3.3202e+02_r8,2.9052e+02_r8,2.4901e+02_r8,2.0752e+02_r8,1.6601e+02_r8,1.2451e+02_r8, &
     &8.3003e+01_r8,4.1506e+01_r8,1.1321e+00_r8/)
      kao(:, 4, 6,15) = (/ &
     &3.1280e+02_r8,2.7368e+02_r8,2.3460e+02_r8,1.9550e+02_r8,1.5640e+02_r8,1.1729e+02_r8, &
     &7.8200e+01_r8,3.9102e+01_r8,1.6067e+00_r8/)
      kao(:, 5, 6,15) = (/ &
     &2.9457e+02_r8,2.5772e+02_r8,2.2093e+02_r8,1.8412e+02_r8,1.4729e+02_r8,1.1048e+02_r8, &
     &7.3641e+01_r8,3.6825e+01_r8,2.1838e+00_r8/)
      kao(:, 1, 7,15) = (/ &
     &7.8539e+02_r8,6.8719e+02_r8,5.8900e+02_r8,4.9081e+02_r8,3.9268e+02_r8,2.9449e+02_r8, &
     &1.9633e+02_r8,9.8167e+01_r8,3.8693e-01_r8/)
      kao(:, 2, 7,15) = (/ &
     &7.3697e+02_r8,6.4481e+02_r8,5.5276e+02_r8,4.6063e+02_r8,3.6848e+02_r8,2.7636e+02_r8, &
     &1.8426e+02_r8,9.2135e+01_r8,6.2265e-01_r8/)
      kao(:, 3, 7,15) = (/ &
     &6.9166e+02_r8,6.0516e+02_r8,5.1875e+02_r8,4.3231e+02_r8,3.4580e+02_r8,2.5935e+02_r8, &
     &1.7293e+02_r8,8.6458e+01_r8,9.6225e-01_r8/)
      kao(:, 4, 7,15) = (/ &
     &6.5012e+02_r8,5.6880e+02_r8,4.8758e+02_r8,4.0634e+02_r8,3.2506e+02_r8,2.4380e+02_r8, &
     &1.6251e+02_r8,8.1260e+01_r8,1.4063e+00_r8/)
      kao(:, 5, 7,15) = (/ &
     &6.1251e+02_r8,5.3595e+02_r8,4.5937e+02_r8,3.8280e+02_r8,3.0627e+02_r8,2.2970e+02_r8, &
     &1.5314e+02_r8,7.6572e+01_r8,1.9665e+00_r8/)
      kao(:, 1, 8,15) = (/ &
     &1.9678e+03_r8,1.7217e+03_r8,1.4759e+03_r8,1.2298e+03_r8,9.8389e+02_r8,7.3793e+02_r8, &
     &4.9200e+02_r8,2.4597e+02_r8,3.3326e-01_r8/)
      kao(:, 2, 8,15) = (/ &
     &1.8454e+03_r8,1.6147e+03_r8,1.3840e+03_r8,1.1533e+03_r8,9.2274e+02_r8,6.9199e+02_r8, &
     &4.6133e+02_r8,2.3066e+02_r8,5.2281e-01_r8/)
      kao(:, 3, 8,15) = (/ &
     &1.7316e+03_r8,1.5151e+03_r8,1.2986e+03_r8,1.0821e+03_r8,8.6576e+02_r8,6.4926e+02_r8, &
     &4.3287e+02_r8,2.1643e+02_r8,8.0537e-01_r8/)
      kao(:, 4, 8,15) = (/ &
     &1.6274e+03_r8,1.4239e+03_r8,1.2204e+03_r8,1.0169e+03_r8,8.1360e+02_r8,6.1025e+02_r8, &
     &4.0681e+02_r8,2.0342e+02_r8,1.2167e+00_r8/)
      kao(:, 5, 8,15) = (/ &
     &1.5364e+03_r8,1.3443e+03_r8,1.1523e+03_r8,9.6013e+02_r8,7.6820e+02_r8,5.7614e+02_r8, &
     &3.8407e+02_r8,1.9205e+02_r8,1.7524e+00_r8/)
      kao(:, 1, 9,15) = (/ &
     &9.3073e+03_r8,8.1544e+03_r8,6.9894e+03_r8,5.8248e+03_r8,4.6604e+03_r8,3.4950e+03_r8, &
     &2.3299e+03_r8,1.1651e+03_r8,2.9954e-01_r8/)
      kao(:, 2, 9,15) = (/ &
     &8.7551e+03_r8,7.6608e+03_r8,6.5662e+03_r8,5.4720e+03_r8,4.3776e+03_r8,3.2831e+03_r8, &
     &2.1886e+03_r8,1.0944e+03_r8,4.5642e-01_r8/)
      kao(:, 3, 9,15) = (/ &
     &8.2482e+03_r8,7.2167e+03_r8,6.1860e+03_r8,5.1552e+03_r8,4.1239e+03_r8,3.0929e+03_r8, &
     &2.0618e+03_r8,1.0309e+03_r8,6.9066e-01_r8/)
      kao(:, 4, 9,15) = (/ &
     &7.8082e+03_r8,6.8324e+03_r8,5.8568e+03_r8,4.8805e+03_r8,3.9039e+03_r8,2.9280e+03_r8, &
     &1.9520e+03_r8,9.7612e+02_r8,1.0400e+00_r8/)
      kao(:, 5, 9,15) = (/ &
     &7.4317e+03_r8,6.5021e+03_r8,5.5734e+03_r8,4.6446e+03_r8,3.7157e+03_r8,2.7869e+03_r8, &
     &1.8578e+03_r8,9.2892e+02_r8,1.5452e+00_r8/)
      kao(:, 1,10,15) = (/ &
     &4.9432e+04_r8,4.3258e+04_r8,3.7074e+04_r8,3.0897e+04_r8,2.4721e+04_r8,1.8537e+04_r8, &
     &1.2358e+04_r8,6.1790e+03_r8,1.8223e-01_r8/)
      kao(:, 2,10,15) = (/ &
     &4.6742e+04_r8,4.0903e+04_r8,3.5058e+04_r8,2.9212e+04_r8,2.3371e+04_r8,1.7528e+04_r8, &
     &1.1686e+04_r8,5.8428e+03_r8,4.2300e-01_r8/)
      kao(:, 3,10,15) = (/ &
     &4.4467e+04_r8,3.8905e+04_r8,3.3347e+04_r8,2.7787e+04_r8,2.2232e+04_r8,1.6675e+04_r8, &
     &1.1116e+04_r8,5.5580e+03_r8,6.2837e-01_r8/)
      kao(:, 4,10,15) = (/ &
     &4.2571e+04_r8,3.7248e+04_r8,3.1929e+04_r8,2.6604e+04_r8,2.1284e+04_r8,1.5965e+04_r8, &
     &1.0643e+04_r8,5.3212e+03_r8,9.2886e-01_r8/)
      kao(:, 5,10,15) = (/ &
     &4.1045e+04_r8,3.5912e+04_r8,3.0783e+04_r8,2.5652e+04_r8,2.0522e+04_r8,1.5392e+04_r8, &
     &1.0261e+04_r8,5.1304e+03_r8,1.3856e+00_r8/)
      kao(:, 1,11,15) = (/ &
     &9.0769e+04_r8,7.9427e+04_r8,6.8076e+04_r8,5.6731e+04_r8,4.5387e+04_r8,3.4039e+04_r8, &
     &2.2692e+04_r8,1.1348e+04_r8,6.3351e-06_r8/)
      kao(:, 2,11,15) = (/ &
     &8.7118e+04_r8,7.6228e+04_r8,6.5339e+04_r8,5.4453e+04_r8,4.3558e+04_r8,3.2668e+04_r8, &
     &2.1780e+04_r8,1.0890e+04_r8,1.2897e-01_r8/)
      kao(:, 3,11,15) = (/ &
     &8.4111e+04_r8,7.3597e+04_r8,6.3086e+04_r8,5.2568e+04_r8,4.2058e+04_r8,3.1544e+04_r8, &
     &2.1027e+04_r8,1.0514e+04_r8,3.6063e-01_r8/)
      kao(:, 4,11,15) = (/ &
     &8.1812e+04_r8,7.1584e+04_r8,6.1356e+04_r8,5.1132e+04_r8,4.0904e+04_r8,3.0678e+04_r8, &
     &2.0453e+04_r8,1.0225e+04_r8,8.1674e-01_r8/)
      kao(:, 5,11,15) = (/ &
     &7.9895e+04_r8,6.9910e+04_r8,5.9923e+04_r8,4.9935e+04_r8,3.9950e+04_r8,2.9961e+04_r8, &
     &1.9975e+04_r8,9.9870e+03_r8,1.4894e+00_r8/)
      kao(:, 1,12,15) = (/ &
     &1.2814e+05_r8,1.1213e+05_r8,9.6104e+04_r8,8.0085e+04_r8,6.4069e+04_r8,4.8051e+04_r8, &
     &3.2036e+04_r8,1.6017e+04_r8,4.6990e-06_r8/)
      kao(:, 2,12,15) = (/ &
     &1.2486e+05_r8,1.0925e+05_r8,9.3637e+04_r8,7.8034e+04_r8,6.2430e+04_r8,4.6820e+04_r8, &
     &3.1210e+04_r8,1.5606e+04_r8,1.4051e-05_r8/)
      kao(:, 3,12,15) = (/ &
     &1.2228e+05_r8,1.0700e+05_r8,9.1710e+04_r8,7.6429e+04_r8,6.1136e+04_r8,4.5856e+04_r8, &
     &3.0569e+04_r8,1.5285e+04_r8,1.5080e-01_r8/)
      kao(:, 4,12,15) = (/ &
     &1.2022e+05_r8,1.0520e+05_r8,9.0163e+04_r8,7.5135e+04_r8,6.0115e+04_r8,4.5084e+04_r8, &
     &3.0055e+04_r8,1.5027e+04_r8,4.4115e-01_r8/)
      kao(:, 5,12,15) = (/ &
     &1.1876e+05_r8,1.0392e+05_r8,8.9071e+04_r8,7.4229e+04_r8,5.9383e+04_r8,4.4534e+04_r8, &
     &2.9691e+04_r8,1.4845e+04_r8,1.2230e+00_r8/)
      kao(:, 1,13,15) = (/ &
     &1.4959e+05_r8,1.3089e+05_r8,1.1219e+05_r8,9.3492e+04_r8,7.4791e+04_r8,5.6100e+04_r8, &
     &3.7396e+04_r8,1.8698e+04_r8,1.6068e-05_r8/)
      kao(:, 2,13,15) = (/ &
     &1.4739e+05_r8,1.2897e+05_r8,1.1053e+05_r8,9.2121e+04_r8,7.3693e+04_r8,5.5270e+04_r8, &
     &3.6845e+04_r8,1.8424e+04_r8,2.4216e-05_r8/)
      kao(:, 3,13,15) = (/ &
     &1.4569e+05_r8,1.2748e+05_r8,1.0927e+05_r8,9.1057e+04_r8,7.2849e+04_r8,5.4630e+04_r8, &
     &3.6423e+04_r8,1.8211e+04_r8,2.3267e-01_r8/)
      kao(:, 4,13,15) = (/ &
     &1.4449e+05_r8,1.2643e+05_r8,1.0837e+05_r8,9.0297e+04_r8,7.2240e+04_r8,5.4184e+04_r8, &
     &3.6121e+04_r8,1.8059e+04_r8,3.2297e-01_r8/)
      kao(:, 5,13,15) = (/ &
     &1.4334e+05_r8,1.2542e+05_r8,1.0750e+05_r8,8.9583e+04_r8,7.1673e+04_r8,5.3754e+04_r8, &
     &3.5834e+04_r8,1.7916e+04_r8,9.5703e-01_r8/)
      kao(:, 1, 1,16) = (/ &
     &1.1012e+01_r8,9.6385e+00_r8,8.2597e+00_r8,6.8841e+00_r8,5.5077e+00_r8,4.1310e+00_r8, &
     &2.7545e+00_r8,1.3780e+00_r8,8.0170e-01_r8/)
      kao(:, 2, 1,16) = (/ &
     &1.0449e+01_r8,9.1438e+00_r8,7.8382e+00_r8,6.5335e+00_r8,5.2262e+00_r8,3.9202e+00_r8, &
     &2.6149e+00_r8,1.3083e+00_r8,1.1089e+00_r8/)
      kao(:, 3, 1,16) = (/ &
     &9.8963e+00_r8,8.6604e+00_r8,7.4233e+00_r8,6.1853e+00_r8,4.9489e+00_r8,3.7122e+00_r8, &
     &2.4757e+00_r8,1.2390e+00_r8,1.4762e+00_r8/)
      kao(:, 4, 1,16) = (/ &
     &9.3879e+00_r8,8.2127e+00_r8,7.0407e+00_r8,5.8670e+00_r8,4.6947e+00_r8,3.5210e+00_r8, &
     &2.3483e+00_r8,1.2086e+00_r8,1.9022e+00_r8/)
      kao(:, 5, 1,16) = (/ &
     &8.8935e+00_r8,7.7813e+00_r8,6.6705e+00_r8,5.5589e+00_r8,4.4480e+00_r8,3.3366e+00_r8, &
     &2.2250e+00_r8,1.5141e+00_r8,2.3892e+00_r8/)
      kao(:, 1, 2,16) = (/ &
     &1.7937e+01_r8,1.5695e+01_r8,1.3452e+01_r8,1.1211e+01_r8,8.9664e+00_r8,6.7267e+00_r8, &
     &4.4861e+00_r8,2.2435e+00_r8,8.6848e-01_r8/)
      kao(:, 2, 2,16) = (/ &
     &1.6997e+01_r8,1.4871e+01_r8,1.2749e+01_r8,1.0624e+01_r8,8.4984e+00_r8,6.3745e+00_r8, &
     &4.2497e+00_r8,2.1262e+00_r8,1.2205e+00_r8/)
      kao(:, 3, 2,16) = (/ &
     &1.6073e+01_r8,1.4067e+01_r8,1.2054e+01_r8,1.0046e+01_r8,8.0383e+00_r8,6.0294e+00_r8, &
     &4.0202e+00_r8,2.0108e+00_r8,1.6477e+00_r8/)
      kao(:, 4, 2,16) = (/ &
     &1.5204e+01_r8,1.3304e+01_r8,1.1402e+01_r8,9.4999e+00_r8,7.6031e+00_r8,5.7017e+00_r8, &
     &3.8022e+00_r8,1.9021e+00_r8,2.1539e+00_r8/)
      kao(:, 5, 2,16) = (/ &
     &1.4385e+01_r8,1.2589e+01_r8,1.0791e+01_r8,8.9907e+00_r8,7.1928e+00_r8,5.3962e+00_r8, &
     &3.5994e+00_r8,1.9006e+00_r8,2.7317e+00_r8/)
      kao(:, 1, 3,16) = (/ &
     &3.9826e+01_r8,3.4837e+01_r8,2.9874e+01_r8,2.4893e+01_r8,1.9916e+01_r8,1.4937e+01_r8, &
     &9.9605e+00_r8,4.9801e+00_r8,8.6605e-01_r8/)
      kao(:, 2, 3,16) = (/ &
     &3.7687e+01_r8,3.2981e+01_r8,2.8272e+01_r8,2.3555e+01_r8,1.8843e+01_r8,1.4136e+01_r8, &
     &9.4254e+00_r8,4.7126e+00_r8,1.2506e+00_r8/)
      kao(:, 3, 3,16) = (/ &
     &3.5608e+01_r8,3.1162e+01_r8,2.6711e+01_r8,2.2256e+01_r8,1.7812e+01_r8,1.3358e+01_r8, &
     &8.9032e+00_r8,4.4535e+00_r8,1.7305e+00_r8/)
      kao(:, 4, 3,16) = (/ &
     &3.3599e+01_r8,2.9402e+01_r8,2.5206e+01_r8,2.1000e+01_r8,1.6804e+01_r8,1.2601e+01_r8, &
     &8.4019e+00_r8,4.2020e+00_r8,2.3040e+00_r8/)
      kao(:, 5, 3,16) = (/ &
     &3.1757e+01_r8,2.7783e+01_r8,2.3809e+01_r8,1.9848e+01_r8,1.5875e+01_r8,1.1908e+01_r8, &
     &7.9407e+00_r8,3.9713e+00_r8,2.9736e+00_r8/)
      kao(:, 1, 4,16) = (/ &
     &9.1010e+01_r8,7.9617e+01_r8,6.8261e+01_r8,5.6883e+01_r8,4.5501e+01_r8,3.4135e+01_r8, &
     &2.2756e+01_r8,1.1381e+01_r8,8.2098e-01_r8/)
      kao(:, 2, 4,16) = (/ &
     &8.5710e+01_r8,7.5003e+01_r8,6.4275e+01_r8,5.3587e+01_r8,4.2849e+01_r8,3.2139e+01_r8, &
     &2.1425e+01_r8,1.0717e+01_r8,1.2260e+00_r8/)
      kao(:, 3, 4,16) = (/ &
     &8.0903e+01_r8,7.0806e+01_r8,6.0673e+01_r8,5.0561e+01_r8,4.0455e+01_r8,3.0343e+01_r8, &
     &2.0221e+01_r8,1.0019e+01_r8,1.7427e+00_r8/)
      kao(:, 4, 4,16) = (/ &
     &7.6250e+01_r8,6.6729e+01_r8,5.7190e+01_r8,4.7658e+01_r8,3.8119e+01_r8,2.8596e+01_r8, &
     &1.9064e+01_r8,9.5357e+00_r8,2.3756e+00_r8/)
      kao(:, 5, 4,16) = (/ &
     &7.1845e+01_r8,6.2892e+01_r8,5.3881e+01_r8,4.4904e+01_r8,3.5931e+01_r8,2.6946e+01_r8, &
     &1.7968e+01_r8,8.9829e+00_r8,3.1270e+00_r8/)
      kao(:, 1, 5,16) = (/ &
     &1.9171e+02_r8,1.6775e+02_r8,1.4380e+02_r8,1.1981e+02_r8,9.5875e+01_r8,7.1871e+01_r8, &
     &4.7928e+01_r8,2.3964e+01_r8,7.5940e-01_r8/)
      kao(:, 2, 5,16) = (/ &
     &1.8016e+02_r8,1.5760e+02_r8,1.3509e+02_r8,1.1260e+02_r8,9.0071e+01_r8,6.7551e+01_r8, &
     &4.5046e+01_r8,2.2517e+01_r8,1.1757e+00_r8/)
      kao(:, 3, 5,16) = (/ &
     &1.6962e+02_r8,1.4839e+02_r8,1.2718e+02_r8,1.0601e+02_r8,8.4813e+01_r8,6.3608e+01_r8, &
     &4.2403e+01_r8,2.1198e+01_r8,1.7223e+00_r8/)
      kao(:, 4, 5,16) = (/ &
     &1.5982e+02_r8,1.3980e+02_r8,1.1984e+02_r8,9.9881e+01_r8,7.9889e+01_r8,5.9924e+01_r8, &
     &3.9950e+01_r8,1.9975e+01_r8,2.4076e+00_r8/)
      kao(:, 5, 5,16) = (/ &
     &1.5041e+02_r8,1.3158e+02_r8,1.1281e+02_r8,9.3993e+01_r8,7.5196e+01_r8,5.6401e+01_r8, &
     &3.7598e+01_r8,1.8805e+01_r8,3.2368e+00_r8/)
      kao(:, 1, 6,16) = (/ &
     &3.8096e+02_r8,3.3337e+02_r8,2.8576e+02_r8,2.3807e+02_r8,1.9047e+02_r8,1.4289e+02_r8, &
     &9.5250e+01_r8,4.7621e+01_r8,6.7593e-01_r8/)
      kao(:, 2, 6,16) = (/ &
     &3.5801e+02_r8,3.1325e+02_r8,2.6851e+02_r8,2.2376e+02_r8,1.7905e+02_r8,1.3426e+02_r8, &
     &8.9499e+01_r8,4.4742e+01_r8,1.0913e+00_r8/)
      kao(:, 3, 6,16) = (/ &
     &3.3608e+02_r8,2.9405e+02_r8,2.5208e+02_r8,2.1010e+02_r8,1.6803e+02_r8,1.2602e+02_r8, &
     &8.4040e+01_r8,4.2005e+01_r8,1.6542e+00_r8/)
      kao(:, 4, 6,16) = (/ &
     &3.1667e+02_r8,2.7704e+02_r8,2.3752e+02_r8,1.9794e+02_r8,1.5835e+02_r8,1.1877e+02_r8, &
     &7.9157e+01_r8,3.9584e+01_r8,2.3801e+00_r8/)
      kao(:, 5, 6,16) = (/ &
     &2.9810e+02_r8,2.6093e+02_r8,2.2364e+02_r8,1.8637e+02_r8,1.4910e+02_r8,1.1183e+02_r8, &
     &7.4550e+01_r8,3.7278e+01_r8,3.2789e+00_r8/)
      kao(:, 1, 7,16) = (/ &
     &7.9749e+02_r8,6.9796e+02_r8,5.9825e+02_r8,4.9855e+02_r8,3.9886e+02_r8,2.9907e+02_r8, &
     &1.9939e+02_r8,9.9689e+01_r8,5.8719e-01_r8/)
      kao(:, 2, 7,16) = (/ &
     &7.4948e+02_r8,6.5592e+02_r8,5.6211e+02_r8,4.6855e+02_r8,3.7478e+02_r8,2.8116e+02_r8, &
     &1.8738e+02_r8,9.3692e+01_r8,9.9296e-01_r8/)
      kao(:, 3, 7,16) = (/ &
     &7.0403e+02_r8,6.1598e+02_r8,5.2804e+02_r8,4.4008e+02_r8,3.5206e+02_r8,2.6406e+02_r8, &
     &1.7605e+02_r8,8.8000e+01_r8,1.5629e+00_r8/)
      kao(:, 4, 7,16) = (/ &
     &6.6205e+02_r8,5.7919e+02_r8,4.9648e+02_r8,4.1378e+02_r8,3.3107e+02_r8,2.4827e+02_r8, &
     &1.6552e+02_r8,8.2766e+01_r8,2.3202e+00_r8/)
      kao(:, 5, 7,16) = (/ &
     &6.2380e+02_r8,5.4580e+02_r8,4.6792e+02_r8,3.8985e+02_r8,3.1191e+02_r8,2.3394e+02_r8, &
     &1.5598e+02_r8,7.7978e+01_r8,3.2803e+00_r8/)
      kao(:, 1, 8,16) = (/ &
     &2.0029e+03_r8,1.7526e+03_r8,1.5027e+03_r8,1.2518e+03_r8,1.0017e+03_r8,7.5137e+02_r8, &
     &5.0076e+02_r8,2.5041e+02_r8,5.0039e-01_r8/)
      kao(:, 2, 8,16) = (/ &
     &1.8839e+03_r8,1.6487e+03_r8,1.4132e+03_r8,1.1775e+03_r8,9.4211e+02_r8,7.0656e+02_r8, &
     &4.7103e+02_r8,2.3550e+02_r8,8.8968e-01_r8/)
      kao(:, 3, 8,16) = (/ &
     &1.7724e+03_r8,1.5508e+03_r8,1.3295e+03_r8,1.1080e+03_r8,8.8638e+02_r8,6.6461e+02_r8, &
     &4.4304e+02_r8,2.2162e+02_r8,1.4586e+00_r8/)
      kao(:, 4, 8,16) = (/ &
     &1.6681e+03_r8,1.4594e+03_r8,1.2510e+03_r8,1.0422e+03_r8,8.3394e+02_r8,6.2548e+02_r8, &
     &4.1698e+02_r8,2.0850e+02_r8,2.2386e+00_r8/)
      kao(:, 5, 8,16) = (/ &
     &1.5734e+03_r8,1.3768e+03_r8,1.1803e+03_r8,9.8337e+02_r8,7.8678e+02_r8,5.9008e+02_r8, &
     &3.9340e+02_r8,1.9668e+02_r8,3.2542e+00_r8/)
      kao(:, 1, 9,16) = (/ &
     &9.5422e+03_r8,8.3482e+03_r8,7.1572e+03_r8,5.9648e+03_r8,4.7724e+03_r8,3.5785e+03_r8, &
     &2.3856e+03_r8,1.1929e+03_r8,4.1531e-01_r8/)
      kao(:, 2, 9,16) = (/ &
     &8.9979e+03_r8,7.8727e+03_r8,6.7481e+03_r8,5.6240e+03_r8,4.4988e+03_r8,3.3743e+03_r8, &
     &2.2493e+03_r8,1.1247e+03_r8,7.8014e-01_r8/)
      kao(:, 3, 9,16) = (/ &
     &8.4879e+03_r8,7.4273e+03_r8,6.3662e+03_r8,5.3047e+03_r8,4.2442e+03_r8,3.1830e+03_r8, &
     &2.1217e+03_r8,1.0610e+03_r8,1.3368e+00_r8/)
      kao(:, 4, 9,16) = (/ &
     &8.0145e+03_r8,7.0116e+03_r8,6.0099e+03_r8,5.0094e+03_r8,4.0072e+03_r8,3.0052e+03_r8, &
     &2.0036e+03_r8,1.0018e+03_r8,2.1276e+00_r8/)
      kao(:, 5, 9,16) = (/ &
     &7.6138e+03_r8,6.6618e+03_r8,5.7100e+03_r8,4.7582e+03_r8,3.8067e+03_r8,2.8551e+03_r8, &
     &1.9031e+03_r8,9.5177e+02_r8,3.1866e+00_r8/)
      kao(:, 1,10,16) = (/ &
     &5.0991e+04_r8,4.4616e+04_r8,3.8235e+04_r8,3.1865e+04_r8,2.5493e+04_r8,1.9119e+04_r8, &
     &1.2748e+04_r8,6.3734e+03_r8,3.5386e-01_r8/)
      kao(:, 2,10,16) = (/ &
     &4.8246e+04_r8,4.2216e+04_r8,3.6189e+04_r8,3.0155e+04_r8,2.4122e+04_r8,1.8092e+04_r8, &
     &1.2062e+04_r8,6.0316e+03_r8,7.0256e-01_r8/)
      kao(:, 3,10,16) = (/ &
     &4.5828e+04_r8,4.0101e+04_r8,3.4373e+04_r8,2.8642e+04_r8,2.2916e+04_r8,1.7187e+04_r8, &
     &1.1458e+04_r8,5.7294e+03_r8,1.2547e+00_r8/)
      kao(:, 4,10,16) = (/ &
     &4.3978e+04_r8,3.8481e+04_r8,3.2983e+04_r8,2.7486e+04_r8,2.1988e+04_r8,1.6492e+04_r8, &
     &1.0995e+04_r8,5.4969e+03_r8,2.0651e+00_r8/)
      kao(:, 5,10,16) = (/ &
     &4.2519e+04_r8,3.7205e+04_r8,3.1889e+04_r8,2.6577e+04_r8,2.1264e+04_r8,1.5948e+04_r8, &
     &1.0631e+04_r8,5.3154e+03_r8,3.1779e+00_r8/)
      kao(:, 1,11,16) = (/ &
     &9.4155e+04_r8,8.2392e+04_r8,7.0618e+04_r8,5.8856e+04_r8,4.7081e+04_r8,3.5308e+04_r8, &
     &2.3542e+04_r8,1.1770e+04_r8,6.1346e-06_r8/)
      kao(:, 2,11,16) = (/ &
     &9.0590e+04_r8,7.9258e+04_r8,6.7935e+04_r8,5.6620e+04_r8,4.5292e+04_r8,3.3967e+04_r8, &
     &2.2646e+04_r8,1.1323e+04_r8,3.3281e-01_r8/)
      kao(:, 3,11,16) = (/ &
     &8.8119e+04_r8,7.7104e+04_r8,6.6094e+04_r8,5.5078e+04_r8,4.4061e+04_r8,3.3053e+04_r8, &
     &2.2031e+04_r8,1.1015e+04_r8,1.5023e+00_r8/)
      kao(:, 4,11,16) = (/ &
     &8.6175e+04_r8,7.5401e+04_r8,6.4627e+04_r8,5.3860e+04_r8,4.3092e+04_r8,3.2317e+04_r8, &
     &2.1545e+04_r8,1.0771e+04_r8,2.4696e+00_r8/)
      kao(:, 5,11,16) = (/ &
     &8.4570e+04_r8,7.4002e+04_r8,6.3432e+04_r8,5.2859e+04_r8,4.2288e+04_r8,3.1714e+04_r8, &
     &2.1142e+04_r8,1.0572e+04_r8,3.7979e+00_r8/)
      kao(:, 1,12,16) = (/ &
     &1.3547e+05_r8,1.1853e+05_r8,1.0160e+05_r8,8.4660e+04_r8,6.7729e+04_r8,5.0794e+04_r8, &
     &3.3867e+04_r8,1.6929e+04_r8,5.0265e-06_r8/)
      kao(:, 2,12,16) = (/ &
     &1.3284e+05_r8,1.1623e+05_r8,9.9623e+04_r8,8.3023e+04_r8,6.6416e+04_r8,4.9810e+04_r8, &
     &3.3206e+04_r8,1.6603e+04_r8,9.0705e-06_r8/)
      kao(:, 3,12,16) = (/ &
     &1.3111e+05_r8,1.1471e+05_r8,9.8324e+04_r8,8.1946e+04_r8,6.5544e+04_r8,4.9165e+04_r8, &
     &3.2777e+04_r8,1.6388e+04_r8,1.7901e+00_r8/)
      kao(:, 4,12,16) = (/ &
     &1.2947e+05_r8,1.1329e+05_r8,9.7103e+04_r8,8.0920e+04_r8,6.4734e+04_r8,4.8090e+04_r8, &
     &3.2370e+04_r8,1.6184e+04_r8,2.9393e+00_r8/)
      kao(:, 5,12,16) = (/ &
     &1.2773e+05_r8,1.1176e+05_r8,9.5799e+04_r8,7.9830e+04_r8,6.3866e+04_r8,4.7901e+04_r8, &
     &3.1932e+04_r8,1.5966e+04_r8,4.5138e+00_r8/)
      kao(:, 1,13,16) = (/ &
     &1.6206e+05_r8,1.4180e+05_r8,1.2155e+05_r8,1.0128e+05_r8,8.1025e+04_r8,6.0775e+04_r8, &
     &4.0514e+04_r8,2.0257e+04_r8,4.1164e-06_r8/)
      kao(:, 2,13,16) = (/ &
     &1.6103e+05_r8,1.4091e+05_r8,1.2078e+05_r8,1.0065e+05_r8,8.0525e+04_r8,6.0389e+04_r8, &
     &4.0260e+04_r8,2.0131e+04_r8,7.4285e-06_r8/)
      kao(:, 3,13,16) = (/ &
     &1.6003e+05_r8,1.4003e+05_r8,1.2001e+05_r8,1.0001e+05_r8,8.0009e+04_r8,6.0009e+04_r8, &
     &4.0005e+04_r8,2.0004e+04_r8,8.7132e-01_r8/)
      kao(:, 4,13,16) = (/ &
     &1.5863e+05_r8,1.3882e+05_r8,1.1899e+05_r8,9.9157e+04_r8,7.9319e+04_r8,5.9492e+04_r8, &
     &3.9661e+04_r8,1.9830e+04_r8,3.4650e+00_r8/)
      kao(:, 5,13,16) = (/ &
     &1.5756e+05_r8,1.3786e+05_r8,1.1816e+05_r8,9.8476e+04_r8,7.8780e+04_r8,5.9085e+04_r8, &
     &3.9388e+04_r8,1.9695e+04_r8,5.3123e+00_r8/) 

!     The array KBO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels  < ~100mb, temperatures, and ratios
!     of H2O to CO2.  The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amount ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 
!     to that of gas2.  The second index, JT, which
!     runs from 1 to 5, corresponds to different temperatures.  More 
!     specifically, JT = 3 means that the data are for the corresponding 
!     reference temperature TREF for this  pressure level, JT = 2 refers 
!     to the TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and
!     JT = 5 is for TREF+30.  The third index, JP, runs from 13 to 59 and
!     refers to the corresponding pressure level in PREF (e.g. JP = 13 is
!     for a pressure of 95.5835 mb).  The fourth index, IG, goes from 1 to
!     16, and tells us which g-interval the absorption coefficients are for.

      kbo(:, 1,13, 1) = (/ &
     &1.9283e+01_r8,1.4533e+01_r8,9.7765e+00_r8,4.9986e+00_r8,1.2562e-02_r8/)
      kbo(:, 2,13, 1) = (/ &
     &2.3187e+01_r8,1.7461e+01_r8,1.1734e+01_r8,5.9860e+00_r8,1.4622e-02_r8/)
      kbo(:, 3,13, 1) = (/ &
     &2.7169e+01_r8,2.0447e+01_r8,1.3724e+01_r8,6.9897e+00_r8,1.6755e-02_r8/)
      kbo(:, 4,13, 1) = (/ &
     &3.1114e+01_r8,2.3405e+01_r8,1.5695e+01_r8,7.9803e+00_r8,1.8932e-02_r8/)
      kbo(:, 5,13, 1) = (/ &
     &3.5056e+01_r8,2.6360e+01_r8,1.7664e+01_r8,8.9659e+00_r8,2.1071e-02_r8/)
      kbo(:, 1,14, 1) = (/ &
     &1.0180e+01_r8,7.7052e+00_r8,5.2175e+00_r8,2.7059e+00_r8,1.0725e-02_r8/)
      kbo(:, 2,14, 1) = (/ &
     &1.2216e+01_r8,9.2332e+00_r8,6.2420e+00_r8,3.2235e+00_r8,1.2472e-02_r8/)
      kbo(:, 3,14, 1) = (/ &
     &1.4258e+01_r8,1.0764e+01_r8,7.2673e+00_r8,3.7434e+00_r8,1.4271e-02_r8/)
      kbo(:, 4,14, 1) = (/ &
     &1.6297e+01_r8,1.2292e+01_r8,8.2867e+00_r8,4.2597e+00_r8,1.6035e-02_r8/)
      kbo(:, 5,14, 1) = (/ &
     &1.8337e+01_r8,1.3822e+01_r8,9.3061e+00_r8,4.7742e+00_r8,1.7777e-02_r8/)
      kbo(:, 1,15, 1) = (/ &
     &5.4843e+00_r8,4.1814e+00_r8,2.8583e+00_r8,1.5122e+00_r8,9.1712e-03_r8/)
      kbo(:, 2,15, 1) = (/ &
     &6.5509e+00_r8,4.9839e+00_r8,3.3981e+00_r8,1.7878e+00_r8,1.0654e-02_r8/)
      kbo(:, 3,15, 1) = (/ &
     &7.6172e+00_r8,5.7836e+00_r8,3.9371e+00_r8,2.0620e+00_r8,1.2109e-02_r8/)
      kbo(:, 4,15, 1) = (/ &
     &8.6919e+00_r8,6.5886e+00_r8,4.4776e+00_r8,2.3372e+00_r8,1.3585e-02_r8/)
      kbo(:, 5,15, 1) = (/ &
     &9.7770e+00_r8,7.4027e+00_r8,5.0231e+00_r8,2.6136e+00_r8,1.5008e-02_r8/)
      kbo(:, 1,16, 1) = (/ &
     &3.5143e+00_r8,2.7004e+00_r8,1.8632e+00_r8,1.0005e+00_r8,7.8549e-03_r8/)
      kbo(:, 2,16, 1) = (/ &
     &4.1782e+00_r8,3.2010e+00_r8,2.2008e+00_r8,1.1754e+00_r8,9.0596e-03_r8/)
      kbo(:, 3,16, 1) = (/ &
     &4.8461e+00_r8,3.7036e+00_r8,2.5395e+00_r8,1.3499e+00_r8,1.0291e-02_r8/)
      kbo(:, 4,16, 1) = (/ &
     &5.5241e+00_r8,4.2125e+00_r8,2.8833e+00_r8,1.5266e+00_r8,1.1500e-02_r8/)
      kbo(:, 5,16, 1) = (/ &
     &6.2095e+00_r8,4.7270e+00_r8,3.2297e+00_r8,1.7035e+00_r8,1.2669e-02_r8/)
      kbo(:, 1,17, 1) = (/ &
     &2.3317e+00_r8,1.8082e+00_r8,1.2606e+00_r8,6.8451e-01_r8,6.6638e-03_r8/)
      kbo(:, 2,17, 1) = (/ &
     &2.7625e+00_r8,2.1339e+00_r8,1.4816e+00_r8,7.9994e-01_r8,7.6839e-03_r8/)
      kbo(:, 3,17, 1) = (/ &
     &3.1980e+00_r8,2.4632e+00_r8,1.7043e+00_r8,9.1671e-01_r8,8.7134e-03_r8/)
      kbo(:, 4,17, 1) = (/ &
     &3.6437e+00_r8,2.7995e+00_r8,1.9319e+00_r8,1.0349e+00_r8,9.7011e-03_r8/)
      kbo(:, 5,17, 1) = (/ &
     &4.0944e+00_r8,3.1388e+00_r8,2.1608e+00_r8,1.1535e+00_r8,1.0621e-02_r8/)
      kbo(:, 1,18, 1) = (/ &
     &1.5862e+00_r8,1.2436e+00_r8,8.7489e-01_r8,4.7986e-01_r8,5.6356e-03_r8/)
      kbo(:, 2,18, 1) = (/ &
     &1.8744e+00_r8,1.4623e+00_r8,1.0242e+00_r8,5.5874e-01_r8,6.4918e-03_r8/)
      kbo(:, 3,18, 1) = (/ &
     &2.1671e+00_r8,1.6845e+00_r8,1.1763e+00_r8,6.3905e-01_r8,7.3340e-03_r8/)
      kbo(:, 4,18, 1) = (/ &
     &2.4666e+00_r8,1.9117e+00_r8,1.3311e+00_r8,7.2008e-01_r8,8.1312e-03_r8/)
      kbo(:, 5,18, 1) = (/ &
     &2.7713e+00_r8,2.1418e+00_r8,1.4869e+00_r8,8.0122e-01_r8,8.8525e-03_r8/)
      kbo(:, 1,19, 1) = (/ &
     &1.0610e+00_r8,8.4360e-01_r8,5.9805e-01_r8,3.3172e-01_r8,4.7490e-03_r8/)
      kbo(:, 2,19, 1) = (/ &
     &1.2512e+00_r8,9.8882e-01_r8,6.9811e-01_r8,3.8521e-01_r8,5.4538e-03_r8/)
      kbo(:, 3,19, 1) = (/ &
     &1.4451e+00_r8,1.1370e+00_r8,8.0056e-01_r8,4.3959e-01_r8,6.1291e-03_r8/)
      kbo(:, 4,19, 1) = (/ &
     &1.6437e+00_r8,1.2883e+00_r8,9.0437e-01_r8,4.9444e-01_r8,6.7635e-03_r8/)
      kbo(:, 5,19, 1) = (/ &
     &1.8467e+00_r8,1.4425e+00_r8,1.0099e+00_r8,5.4929e-01_r8,7.3353e-03_r8/)
      kbo(:, 1,20, 1) = (/ &
     &7.7133e-01_r8,6.2032e-01_r8,4.4197e-01_r8,2.4707e-01_r8,4.0032e-03_r8/)
      kbo(:, 2,20, 1) = (/ &
     &9.0743e-01_r8,7.2503e-01_r8,5.1466e-01_r8,2.8622e-01_r8,4.5715e-03_r8/)
      kbo(:, 3,20, 1) = (/ &
     &1.0470e+00_r8,8.3267e-01_r8,5.8918e-01_r8,3.2603e-01_r8,5.1125e-03_r8/)
      kbo(:, 4,20, 1) = (/ &
     &1.1900e+00_r8,9.4226e-01_r8,6.6481e-01_r8,3.6603e-01_r8,5.6145e-03_r8/)
      kbo(:, 5,20, 1) = (/ &
     &1.3362e+00_r8,1.0539e+00_r8,7.4130e-01_r8,4.0582e-01_r8,6.0699e-03_r8/)
      kbo(:, 1,21, 1) = (/ &
     &5.7866e-01_r8,4.6986e-01_r8,3.3621e-01_r8,1.8917e-01_r8,3.3621e-03_r8/)
      kbo(:, 2,21, 1) = (/ &
     &6.7950e-01_r8,5.4811e-01_r8,3.9072e-01_r8,2.1877e-01_r8,3.8183e-03_r8/)
      kbo(:, 3,21, 1) = (/ &
     &7.8326e-01_r8,6.2869e-01_r8,4.4658e-01_r8,2.4873e-01_r8,4.2512e-03_r8/)
      kbo(:, 4,21, 1) = (/ &
     &8.8933e-01_r8,7.1063e-01_r8,5.0334e-01_r8,2.7872e-01_r8,4.6532e-03_r8/)
      kbo(:, 5,21, 1) = (/ &
     &9.9790e-01_r8,7.9397e-01_r8,5.6013e-01_r8,3.0841e-01_r8,5.0189e-03_r8/)
      kbo(:, 1,22, 1) = (/ &
     &4.5035e-01_r8,3.6838e-01_r8,2.6449e-01_r8,1.4961e-01_r8,2.8371e-03_r8/)
      kbo(:, 2,22, 1) = (/ &
     &5.2710e-01_r8,4.2854e-01_r8,3.0641e-01_r8,1.7248e-01_r8,3.2033e-03_r8/)
      kbo(:, 3,22, 1) = (/ &
     &6.0621e-01_r8,4.9027e-01_r8,3.4931e-01_r8,1.9546e-01_r8,3.5507e-03_r8/)
      kbo(:, 4,22, 1) = (/ &
     &6.8687e-01_r8,5.5302e-01_r8,3.9268e-01_r8,2.1836e-01_r8,3.8721e-03_r8/)
      kbo(:, 5,22, 1) = (/ &
     &7.6986e-01_r8,6.1676e-01_r8,4.3619e-01_r8,2.4105e-01_r8,4.1644e-03_r8/)
      kbo(:, 1,23, 1) = (/ &
     &3.5288e-01_r8,2.9059e-01_r8,2.0929e-01_r8,1.1896e-01_r8,2.3878e-03_r8/)
      kbo(:, 2,23, 1) = (/ &
     &4.1165e-01_r8,3.3703e-01_r8,2.4169e-01_r8,1.3668e-01_r8,2.6830e-03_r8/)
      kbo(:, 3,23, 1) = (/ &
     &4.7210e-01_r8,3.8447e-01_r8,2.7478e-01_r8,1.5435e-01_r8,2.9616e-03_r8/)
      kbo(:, 4,23, 1) = (/ &
     &5.3412e-01_r8,4.3294e-01_r8,3.0818e-01_r8,1.7203e-01_r8,3.2196e-03_r8/)
      kbo(:, 5,23, 1) = (/ &
     &5.9758e-01_r8,4.8162e-01_r8,3.4147e-01_r8,1.8925e-01_r8,3.4517e-03_r8/)
      kbo(:, 1,24, 1) = (/ &
     &2.7554e-01_r8,2.2847e-01_r8,1.6509e-01_r8,9.4305e-02_r8,2.0058e-03_r8/)
      kbo(:, 2,24, 1) = (/ &
     &3.2038e-01_r8,2.6411e-01_r8,1.9003e-01_r8,1.0793e-01_r8,2.2440e-03_r8/)
      kbo(:, 3,24, 1) = (/ &
     &3.6644e-01_r8,3.0049e-01_r8,2.1543e-01_r8,1.2148e-01_r8,2.4688e-03_r8/)
      kbo(:, 4,24, 1) = (/ &
     &4.1394e-01_r8,3.3761e-01_r8,2.4100e-01_r8,1.3500e-01_r8,2.6754e-03_r8/)
      kbo(:, 5,24, 1) = (/ &
     &4.6205e-01_r8,3.7459e-01_r8,2.6626e-01_r8,1.4798e-01_r8,2.8597e-03_r8/)
      kbo(:, 1,25, 1) = (/ &
     &2.1831e-01_r8,1.8211e-01_r8,1.3197e-01_r8,7.5672e-02_r8,1.6848e-03_r8/)
      kbo(:, 2,25, 1) = (/ &
     &2.5300e-01_r8,2.0977e-01_r8,1.5139e-01_r8,8.6229e-02_r8,1.8770e-03_r8/)
      kbo(:, 3,25, 1) = (/ &
     &2.8861e-01_r8,2.3809e-01_r8,1.7109e-01_r8,9.6778e-02_r8,2.0567e-03_r8/)
      kbo(:, 4,25, 1) = (/ &
     &3.2559e-01_r8,2.6686e-01_r8,1.9096e-01_r8,1.0719e-01_r8,2.2230e-03_r8/)
      kbo(:, 5,25, 1) = (/ &
     &3.6217e-01_r8,2.9511e-01_r8,2.1013e-01_r8,1.1707e-01_r8,2.3678e-03_r8/)
      kbo(:, 1,26, 1) = (/ &
     &1.7639e-01_r8,1.4786e-01_r8,1.0735e-01_r8,6.1680e-02_r8,1.4167e-03_r8/)
      kbo(:, 2,26, 1) = (/ &
     &2.0373e-01_r8,1.6972e-01_r8,1.2271e-01_r8,7.0008e-02_r8,1.5712e-03_r8/)
      kbo(:, 3,26, 1) = (/ &
     &2.3189e-01_r8,1.9218e-01_r8,1.3830e-01_r8,7.8351e-02_r8,1.7155e-03_r8/)
      kbo(:, 4,26, 1) = (/ &
     &2.6096e-01_r8,2.1478e-01_r8,1.5388e-01_r8,8.6437e-02_r8,1.8482e-03_r8/)
      kbo(:, 5,26, 1) = (/ &
     &2.8921e-01_r8,2.3658e-01_r8,1.6864e-01_r8,9.4016e-02_r8,1.9628e-03_r8/)
      kbo(:, 1,27, 1) = (/ &
     &1.4816e-01_r8,1.2446e-01_r8,9.0381e-02_r8,5.1884e-02_r8,1.1905e-03_r8/)
      kbo(:, 2,27, 1) = (/ &
     &1.7052e-01_r8,1.4243e-01_r8,1.0297e-01_r8,5.8708e-02_r8,1.3153e-03_r8/)
      kbo(:, 3,27, 1) = (/ &
     &1.9369e-01_r8,1.6085e-01_r8,1.1575e-01_r8,6.5493e-02_r8,1.4309e-03_r8/)
      kbo(:, 4,27, 1) = (/ &
     &2.1729e-01_r8,1.7923e-01_r8,1.2834e-01_r8,7.1951e-02_r8,1.5370e-03_r8/)
      kbo(:, 5,27, 1) = (/ &
     &2.3994e-01_r8,1.9663e-01_r8,1.4015e-01_r8,7.7968e-02_r8,1.6265e-03_r8/)
      kbo(:, 1,28, 1) = (/ &
     &1.2786e-01_r8,1.0743e-01_r8,7.7947e-02_r8,4.4624e-02_r8,1.0001e-03_r8/)
      kbo(:, 2,28, 1) = (/ &
     &1.4668e-01_r8,1.2262e-01_r8,8.8533e-02_r8,5.0350e-02_r8,1.1007e-03_r8/)
      kbo(:, 3,28, 1) = (/ &
     &1.6624e-01_r8,1.3809e-01_r8,9.9259e-02_r8,5.5949e-02_r8,1.1936e-03_r8/)
      kbo(:, 4,28, 1) = (/ &
     &1.8582e-01_r8,1.5336e-01_r8,1.0964e-01_r8,6.1251e-02_r8,1.2774e-03_r8/)
      kbo(:, 5,28, 1) = (/ &
     &2.0447e-01_r8,1.6760e-01_r8,1.1929e-01_r8,6.6127e-02_r8,1.3481e-03_r8/)
      kbo(:, 1,29, 1) = (/ &
     &1.1723e-01_r8,9.8203e-02_r8,7.1006e-02_r8,4.0413e-02_r8,8.4082e-04_r8/)
      kbo(:, 2,29, 1) = (/ &
     &1.3410e-01_r8,1.1181e-01_r8,8.0444e-02_r8,4.5462e-02_r8,9.2201e-04_r8/)
      kbo(:, 3,29, 1) = (/ &
     &1.5159e-01_r8,1.2556e-01_r8,8.9943e-02_r8,5.0342e-02_r8,9.9652e-04_r8/)
      kbo(:, 4,29, 1) = (/ &
     &1.6878e-01_r8,1.3892e-01_r8,9.8991e-02_r8,5.4945e-02_r8,1.0624e-03_r8/)
      kbo(:, 5,29, 1) = (/ &
     &1.8506e-01_r8,1.5133e-01_r8,1.0733e-01_r8,5.9130e-02_r8,1.1186e-03_r8/)
      kbo(:, 1,30, 1) = (/ &
     &1.1017e-01_r8,9.1915e-02_r8,6.6158e-02_r8,3.7385e-02_r8,7.0716e-04_r8/)
      kbo(:, 2,30, 1) = (/ &
     &1.2571e-01_r8,1.0438e-01_r8,7.4791e-02_r8,4.1937e-02_r8,7.7222e-04_r8/)
      kbo(:, 3,30, 1) = (/ &
     &1.4165e-01_r8,1.1688e-01_r8,8.3361e-02_r8,4.6295e-02_r8,8.3205e-04_r8/)
      kbo(:, 4,30, 1) = (/ &
     &1.5709e-01_r8,1.2882e-01_r8,9.1412e-02_r8,5.0358e-02_r8,8.8422e-04_r8/)
      kbo(:, 5,30, 1) = (/ &
     &1.7161e-01_r8,1.3989e-01_r8,9.8798e-02_r8,5.4060e-02_r8,9.2829e-04_r8/)
      kbo(:, 1,31, 1) = (/ &
     &1.0894e-01_r8,9.0338e-02_r8,6.4636e-02_r8,3.6175e-02_r8,5.9489e-04_r8/)
      kbo(:, 2,31, 1) = (/ &
     &1.2399e-01_r8,1.0230e-01_r8,7.2900e-02_r8,4.0465e-02_r8,6.4753e-04_r8/)
      kbo(:, 3,31, 1) = (/ &
     &1.3920e-01_r8,1.1419e-01_r8,8.0980e-02_r8,4.4552e-02_r8,6.9507e-04_r8/)
      kbo(:, 4,31, 1) = (/ &
     &1.5373e-01_r8,1.2537e-01_r8,8.8479e-02_r8,4.8317e-02_r8,7.3661e-04_r8/)
      kbo(:, 5,31, 1) = (/ &
     &1.6735e-01_r8,1.3577e-01_r8,9.5380e-02_r8,5.1770e-02_r8,7.7104e-04_r8/)
      kbo(:, 1,32, 1) = (/ &
     &1.0900e-01_r8,8.9827e-02_r8,6.3903e-02_r8,3.5410e-02_r8,5.0043e-04_r8/)
      kbo(:, 2,32, 1) = (/ &
     &1.2373e-01_r8,1.0144e-01_r8,7.1880e-02_r8,3.9506e-02_r8,5.4269e-04_r8/)
      kbo(:, 3,32, 1) = (/ &
     &1.3829e-01_r8,1.1278e-01_r8,7.9528e-02_r8,4.3367e-02_r8,5.8080e-04_r8/)
      kbo(:, 4,32, 1) = (/ &
     &1.5213e-01_r8,1.2340e-01_r8,8.6611e-02_r8,4.6908e-02_r8,6.1297e-04_r8/)
      kbo(:, 5,32, 1) = (/ &
     &1.6513e-01_r8,1.3334e-01_r8,9.3188e-02_r8,5.0191e-02_r8,6.4067e-04_r8/)
      kbo(:, 1,33, 1) = (/ &
     &1.1105e-01_r8,9.0919e-02_r8,6.4301e-02_r8,3.5277e-02_r8,4.2055e-04_r8/)
      kbo(:, 2,33, 1) = (/ &
     &1.2562e-01_r8,1.0235e-01_r8,7.2096e-02_r8,3.9245e-02_r8,4.5474e-04_r8/)
      kbo(:, 3,33, 1) = (/ &
     &1.3981e-01_r8,1.1334e-01_r8,7.9473e-02_r8,4.2949e-02_r8,4.8461e-04_r8/)
      kbo(:, 4,33, 1) = (/ &
     &1.5326e-01_r8,1.2363e-01_r8,8.6303e-02_r8,4.6360e-02_r8,5.1014e-04_r8/)
      kbo(:, 5,33, 1) = (/ &
     &1.6587e-01_r8,1.3331e-01_r8,9.2704e-02_r8,4.9561e-02_r8,5.3252e-04_r8/)
      kbo(:, 1,34, 1) = (/ &
     &1.0980e-01_r8,8.9454e-02_r8,6.2967e-02_r8,3.4264e-02_r8,3.5179e-04_r8/)
      kbo(:, 2,34, 1) = (/ &
     &1.2374e-01_r8,1.0037e-01_r8,7.0363e-02_r8,3.8004e-02_r8,3.7955e-04_r8/)
      kbo(:, 3,34, 1) = (/ &
     &1.3725e-01_r8,1.1080e-01_r8,7.7340e-02_r8,4.1494e-02_r8,4.0292e-04_r8/)
      kbo(:, 4,34, 1) = (/ &
     &1.5005e-01_r8,1.2058e-01_r8,8.3803e-02_r8,4.4722e-02_r8,4.2388e-04_r8/)
      kbo(:, 5,34, 1) = (/ &
     &1.6190e-01_r8,1.2971e-01_r8,8.9844e-02_r8,4.7765e-02_r8,4.4175e-04_r8/)
      kbo(:, 1,35, 1) = (/ &
     &1.0733e-01_r8,8.7091e-02_r8,6.1056e-02_r8,3.2994e-02_r8,2.9230e-04_r8/)
      kbo(:, 2,35, 1) = (/ &
     &1.2074e-01_r8,9.7561e-02_r8,6.8117e-02_r8,3.6550e-02_r8,3.1434e-04_r8/)
      kbo(:, 3,35, 1) = (/ &
     &1.3369e-01_r8,1.0755e-01_r8,7.4768e-02_r8,3.9873e-02_r8,3.3363e-04_r8/)
      kbo(:, 4,35, 1) = (/ &
     &1.4588e-01_r8,1.1689e-01_r8,8.0950e-02_r8,4.2958e-02_r8,3.5062e-04_r8/)
      kbo(:, 5,35, 1) = (/ &
     &1.5707e-01_r8,1.2552e-01_r8,8.6668e-02_r8,4.5847e-02_r8,3.6479e-04_r8/)
      kbo(:, 1,36, 1) = (/ &
     &1.0289e-01_r8,8.3241e-02_r8,5.8159e-02_r8,3.1253e-02_r8,2.4069e-04_r8/)
      kbo(:, 2,36, 1) = (/ &
     &1.1571e-01_r8,9.3253e-02_r8,6.4895e-02_r8,3.4641e-02_r8,2.5868e-04_r8/)
      kbo(:, 3,36, 1) = (/ &
     &1.2815e-01_r8,1.0284e-01_r8,7.1277e-02_r8,3.7824e-02_r8,2.7449e-04_r8/)
      kbo(:, 4,36, 1) = (/ &
     &1.3974e-01_r8,1.1174e-01_r8,7.7168e-02_r8,4.0766e-02_r8,2.8849e-04_r8/)
      kbo(:, 5,36, 1) = (/ &
     &1.5033e-01_r8,1.1990e-01_r8,8.2576e-02_r8,4.3496e-02_r8,2.9983e-04_r8/)
      kbo(:, 1,37, 1) = (/ &
     &9.4340e-02_r8,7.6226e-02_r8,5.3140e-02_r8,2.8456e-02_r8,1.9559e-04_r8/)
      kbo(:, 2,37, 1) = (/ &
     &1.0634e-01_r8,8.5612e-02_r8,5.9452e-02_r8,3.1630e-02_r8,2.1059e-04_r8/)
      kbo(:, 3,37, 1) = (/ &
     &1.1803e-01_r8,9.4641e-02_r8,6.5469e-02_r8,3.4631e-02_r8,2.2381e-04_r8/)
      kbo(:, 4,37, 1) = (/ &
     &1.2893e-01_r8,1.0302e-01_r8,7.1019e-02_r8,3.7400e-02_r8,2.3549e-04_r8/)
      kbo(:, 5,37, 1) = (/ &
     &1.3882e-01_r8,1.1066e-01_r8,7.6074e-02_r8,3.9944e-02_r8,2.4505e-04_r8/)
      kbo(:, 1,38, 1) = (/ &
     &8.7666e-02_r8,7.0724e-02_r8,4.9189e-02_r8,2.6244e-02_r8,1.5881e-04_r8/)
      kbo(:, 2,38, 1) = (/ &
     &9.9075e-02_r8,7.9666e-02_r8,5.5208e-02_r8,2.9270e-02_r8,1.7135e-04_r8/)
      kbo(:, 3,38, 1) = (/ &
     &1.1022e-01_r8,8.8294e-02_r8,6.0961e-02_r8,3.2140e-02_r8,1.8248e-04_r8/)
      kbo(:, 4,38, 1) = (/ &
     &1.2063e-01_r8,9.6310e-02_r8,6.6270e-02_r8,3.4786e-02_r8,1.9228e-04_r8/)
      kbo(:, 5,38, 1) = (/ &
     &1.3002e-01_r8,1.0355e-01_r8,7.1058e-02_r8,3.7188e-02_r8,2.0028e-04_r8/)
      kbo(:, 1,39, 1) = (/ &
     &8.3319e-02_r8,6.7083e-02_r8,4.6540e-02_r8,2.4732e-02_r8,1.2903e-04_r8/)
      kbo(:, 2,39, 1) = (/ &
     &9.4409e-02_r8,7.5788e-02_r8,5.2401e-02_r8,2.7679e-02_r8,1.3958e-04_r8/)
      kbo(:, 3,39, 1) = (/ &
     &1.0530e-01_r8,8.4225e-02_r8,5.8027e-02_r8,3.0486e-02_r8,1.4894e-04_r8/)
      kbo(:, 4,39, 1) = (/ &
     &1.1544e-01_r8,9.2061e-02_r8,6.3226e-02_r8,3.3071e-02_r8,1.5713e-04_r8/)
      kbo(:, 5,39, 1) = (/ &
     &1.2457e-01_r8,9.9102e-02_r8,6.7879e-02_r8,3.5400e-02_r8,1.6372e-04_r8/)
      kbo(:, 1,40, 1) = (/ &
     &7.3382e-02_r8,5.9091e-02_r8,4.0949e-02_r8,2.1720e-02_r8,1.0369e-04_r8/)
      kbo(:, 2,40, 1) = (/ &
     &8.3492e-02_r8,6.7054e-02_r8,4.6317e-02_r8,2.4422e-02_r8,1.1258e-04_r8/)
      kbo(:, 3,40, 1) = (/ &
     &9.3502e-02_r8,7.4845e-02_r8,5.1514e-02_r8,2.7021e-02_r8,1.2049e-04_r8/)
      kbo(:, 4,40, 1) = (/ &
     &1.0289e-01_r8,8.2115e-02_r8,5.6339e-02_r8,2.9419e-02_r8,1.2744e-04_r8/)
      kbo(:, 5,40, 1) = (/ &
     &1.1132e-01_r8,8.8604e-02_r8,6.0629e-02_r8,3.1559e-02_r8,1.3317e-04_r8/)
      kbo(:, 1,41, 1) = (/ &
     &6.4289e-02_r8,5.1783e-02_r8,3.5851e-02_r8,1.8983e-02_r8,8.3205e-05_r8/)
      kbo(:, 2,41, 1) = (/ &
     &7.3486e-02_r8,5.9047e-02_r8,4.0756e-02_r8,2.1456e-02_r8,9.0601e-05_r8/)
      kbo(:, 3,41, 1) = (/ &
     &8.2657e-02_r8,6.6211e-02_r8,4.5539e-02_r8,2.3850e-02_r8,9.7309e-05_r8/)
      kbo(:, 4,41, 1) = (/ &
     &9.1325e-02_r8,7.2956e-02_r8,5.0013e-02_r8,2.6075e-02_r8,1.0320e-04_r8/)
      kbo(:, 5,41, 1) = (/ &
     &9.9149e-02_r8,7.8969e-02_r8,5.3991e-02_r8,2.8057e-02_r8,1.0825e-04_r8/)
      kbo(:, 1,42, 1) = (/ &
     &5.6899e-02_r8,4.5812e-02_r8,3.1686e-02_r8,1.6747e-02_r8,6.6719e-05_r8/)
      kbo(:, 2,42, 1) = (/ &
     &6.5316e-02_r8,5.2494e-02_r8,3.6198e-02_r8,1.9026e-02_r8,7.2862e-05_r8/)
      kbo(:, 3,42, 1) = (/ &
     &7.3779e-02_r8,5.9136e-02_r8,4.0639e-02_r8,2.1249e-02_r8,7.8557e-05_r8/)
      kbo(:, 4,42, 1) = (/ &
     &8.1877e-02_r8,6.5448e-02_r8,4.4826e-02_r8,2.3334e-02_r8,8.3575e-05_r8/)
      kbo(:, 5,42, 1) = (/ &
     &8.9207e-02_r8,7.1094e-02_r8,4.8562e-02_r8,2.5195e-02_r8,8.7912e-05_r8/)
      kbo(:, 1,43, 1) = (/ &
     &5.0334e-02_r8,4.0495e-02_r8,2.7979e-02_r8,1.4764e-02_r8,5.3104e-05_r8/)
      kbo(:, 2,43, 1) = (/ &
     &5.8063e-02_r8,4.6679e-02_r8,3.2159e-02_r8,1.6880e-02_r8,5.8298e-05_r8/)
      kbo(:, 3,43, 1) = (/ &
     &6.5961e-02_r8,5.2905e-02_r8,3.6327e-02_r8,1.8968e-02_r8,6.3123e-05_r8/)
      kbo(:, 4,43, 1) = (/ &
     &7.3585e-02_r8,5.8862e-02_r8,4.0291e-02_r8,2.0945e-02_r8,6.7425e-05_r8/)
      kbo(:, 5,43, 1) = (/ &
     &8.0560e-02_r8,6.4257e-02_r8,4.3859e-02_r8,2.2720e-02_r8,7.1177e-05_r8/)
      kbo(:, 1,44, 1) = (/ &
     &4.4899e-02_r8,3.6074e-02_r8,2.4891e-02_r8,1.3115e-02_r8,4.2029e-05_r8/)
      kbo(:, 2,44, 1) = (/ &
     &5.2065e-02_r8,4.1850e-02_r8,2.8809e-02_r8,1.5097e-02_r8,4.6479e-05_r8/)
      kbo(:, 3,44, 1) = (/ &
     &5.9485e-02_r8,4.7740e-02_r8,3.2758e-02_r8,1.7077e-02_r8,5.0599e-05_r8/)
      kbo(:, 4,44, 1) = (/ &
     &6.6781e-02_r8,5.3454e-02_r8,3.6566e-02_r8,1.8982e-02_r8,5.4263e-05_r8/)
      kbo(:, 5,44, 1) = (/ &
     &7.3522e-02_r8,5.8690e-02_r8,4.0031e-02_r8,2.0702e-02_r8,5.7530e-05_r8/)
      kbo(:, 1,45, 1) = (/ &
     &4.0792e-02_r8,3.2725e-02_r8,2.2543e-02_r8,1.1850e-02_r8,3.3244e-05_r8/)
      kbo(:, 2,45, 1) = (/ &
     &4.7552e-02_r8,3.8195e-02_r8,2.6267e-02_r8,1.3739e-02_r8,3.7011e-05_r8/)
      kbo(:, 3,45, 1) = (/ &
     &5.4656e-02_r8,4.3858e-02_r8,3.0076e-02_r8,1.5653e-02_r8,4.0475e-05_r8/)
      kbo(:, 4,45, 1) = (/ &
     &6.1725e-02_r8,4.9413e-02_r8,3.3782e-02_r8,1.7505e-02_r8,4.3662e-05_r8/)
      kbo(:, 5,45, 1) = (/ &
     &6.8362e-02_r8,5.4599e-02_r8,3.7216e-02_r8,1.9215e-02_r8,4.6426e-05_r8/)
      kbo(:, 1,46, 1) = (/ &
     &3.7210e-02_r8,2.9813e-02_r8,2.0505e-02_r8,1.0753e-02_r8,2.6192e-05_r8/)
      kbo(:, 2,46, 1) = (/ &
     &4.3666e-02_r8,3.5023e-02_r8,2.4062e-02_r8,1.2564e-02_r8,2.9338e-05_r8/)
      kbo(:, 3,46, 1) = (/ &
     &5.0484e-02_r8,4.0487e-02_r8,2.7746e-02_r8,1.4418e-02_r8,3.2269e-05_r8/)
      kbo(:, 4,46, 1) = (/ &
     &5.7389e-02_r8,4.5948e-02_r8,3.1393e-02_r8,1.6243e-02_r8,3.5047e-05_r8/)
      kbo(:, 5,46, 1) = (/ &
     &6.3983e-02_r8,5.1116e-02_r8,3.4828e-02_r8,1.7955e-02_r8,3.7412e-05_r8/)
      kbo(:, 1,47, 1) = (/ &
     &3.3307e-02_r8,2.6647e-02_r8,1.8307e-02_r8,9.5851e-03_r8,2.0446e-05_r8/)
      kbo(:, 2,47, 1) = (/ &
     &3.9395e-02_r8,3.1552e-02_r8,2.1654e-02_r8,1.1293e-02_r8,2.3124e-05_r8/)
      kbo(:, 3,47, 1) = (/ &
     &4.5832e-02_r8,3.6752e-02_r8,2.5172e-02_r8,1.3065e-02_r8,2.5601e-05_r8/)
      kbo(:, 4,47, 1) = (/ &
     &5.2491e-02_r8,4.2052e-02_r8,2.8722e-02_r8,1.4843e-02_r8,2.7940e-05_r8/)
      kbo(:, 5,47, 1) = (/ &
     &5.8958e-02_r8,4.7137e-02_r8,3.2108e-02_r8,1.6536e-02_r8,3.0007e-05_r8/)
      kbo(:, 1,48, 1) = (/ &
     &3.0577e-02_r8,2.4411e-02_r8,1.6745e-02_r8,8.7495e-03_r8,1.5922e-05_r8/)
      kbo(:, 2,48, 1) = (/ &
     &3.6464e-02_r8,2.9147e-02_r8,1.9975e-02_r8,1.0397e-02_r8,1.8148e-05_r8/)
      kbo(:, 3,48, 1) = (/ &
     &4.2691e-02_r8,3.4197e-02_r8,2.3406e-02_r8,1.2132e-02_r8,2.0290e-05_r8/)
      kbo(:, 4,48, 1) = (/ &
     &4.9243e-02_r8,3.9438e-02_r8,2.6932e-02_r8,1.3903e-02_r8,2.2244e-05_r8/)
      kbo(:, 5,48, 1) = (/ &
     &5.5751e-02_r8,4.4571e-02_r8,3.0355e-02_r8,1.5610e-02_r8,2.4044e-05_r8/)
      kbo(:, 1,49, 1) = (/ &
     &2.9139e-02_r8,2.3202e-02_r8,1.5887e-02_r8,8.2788e-03_r8,1.2379e-05_r8/)
      kbo(:, 2,49, 1) = (/ &
     &3.5049e-02_r8,2.7954e-02_r8,1.9124e-02_r8,9.9302e-03_r8,1.4214e-05_r8/)
      kbo(:, 3,49, 1) = (/ &
     &4.1342e-02_r8,3.3034e-02_r8,2.2588e-02_r8,1.1686e-02_r8,1.6044e-05_r8/)
      kbo(:, 4,49, 1) = (/ &
     &4.8011e-02_r8,3.8402e-02_r8,2.6208e-02_r8,1.3508e-02_r8,1.7733e-05_r8/)
      kbo(:, 5,49, 1) = (/ &
     &5.4790e-02_r8,4.3771e-02_r8,2.9799e-02_r8,1.5302e-02_r8,1.9282e-05_r8/)
      kbo(:, 1,50, 1) = (/ &
     &2.6464e-02_r8,2.1057e-02_r8,1.4400e-02_r8,7.4918e-03_r8,9.6160e-06_r8/)
      kbo(:, 2,50, 1) = (/ &
     &3.2138e-02_r8,2.5589e-02_r8,1.7489e-02_r8,9.0674e-03_r8,1.1117e-05_r8/)
      kbo(:, 3,50, 1) = (/ &
     &3.8201e-02_r8,3.0472e-02_r8,2.0816e-02_r8,1.0758e-02_r8,1.2650e-05_r8/)
      kbo(:, 4,50, 1) = (/ &
     &4.4627e-02_r8,3.5684e-02_r8,2.4344e-02_r8,1.2533e-02_r8,1.4094e-05_r8/)
      kbo(:, 5,50, 1) = (/ &
     &5.1304e-02_r8,4.1009e-02_r8,2.7917e-02_r8,1.4322e-02_r8,1.5452e-05_r8/)
      kbo(:, 1,51, 1) = (/ &
     &2.3471e-02_r8,1.8670e-02_r8,1.2760e-02_r8,6.6303e-03_r8,7.4600e-06_r8/)
      kbo(:, 2,51, 1) = (/ &
     &2.8809e-02_r8,2.2911e-02_r8,1.5642e-02_r8,8.0988e-03_r8,8.6870e-06_r8/)
      kbo(:, 3,51, 1) = (/ &
     &3.4515e-02_r8,2.7502e-02_r8,1.8771e-02_r8,9.6885e-03_r8,9.9502e-06_r8/)
      kbo(:, 4,51, 1) = (/ &
     &4.0564e-02_r8,3.2426e-02_r8,2.2116e-02_r8,1.1378e-02_r8,1.1172e-05_r8/)
      kbo(:, 5,51, 1) = (/ &
     &4.6952e-02_r8,3.7546e-02_r8,2.5560e-02_r8,1.3107e-02_r8,1.2317e-05_r8/)
      kbo(:, 1,52, 1) = (/ &
     &2.1330e-02_r8,1.6945e-02_r8,1.1569e-02_r8,6.0043e-03_r8,5.7740e-06_r8/)
      kbo(:, 2,52, 1) = (/ &
     &2.6486e-02_r8,2.1033e-02_r8,1.4344e-02_r8,7.4158e-03_r8,6.7739e-06_r8/)
      kbo(:, 3,52, 1) = (/ &
     &3.1984e-02_r8,2.5459e-02_r8,1.7358e-02_r8,8.9483e-03_r8,7.8163e-06_r8/)
      kbo(:, 4,52, 1) = (/ &
     &3.7859e-02_r8,3.0220e-02_r8,2.0602e-02_r8,1.0589e-02_r8,8.8379e-06_r8/)
      kbo(:, 5,52, 1) = (/ &
     &4.4095e-02_r8,3.5255e-02_r8,2.3994e-02_r8,1.2295e-02_r8,9.8102e-06_r8/)
      kbo(:, 1,53, 1) = (/ &
     &2.0104e-02_r8,1.5937e-02_r8,1.0867e-02_r8,5.6295e-03_r8,4.4532e-06_r8/)
      kbo(:, 2,53, 1) = (/ &
     &2.5267e-02_r8,2.0039e-02_r8,1.3647e-02_r8,7.0429e-03_r8,5.2727e-06_r8/)
      kbo(:, 3,53, 1) = (/ &
     &3.0800e-02_r8,2.4464e-02_r8,1.6661e-02_r8,8.5763e-03_r8,6.1352e-06_r8/)
      kbo(:, 4,53, 1) = (/ &
     &3.6739e-02_r8,2.9255e-02_r8,1.9925e-02_r8,1.0232e-02_r8,6.9843e-06_r8/)
      kbo(:, 5,53, 1) = (/ &
     &4.3045e-02_r8,3.4379e-02_r8,2.3392e-02_r8,1.1975e-02_r8,7.8095e-06_r8/)
      kbo(:, 1,54, 1) = (/ &
     &1.6441e-02_r8,1.3030e-02_r8,8.8847e-03_r8,4.6022e-03_r8,3.4230e-06_r8/)
      kbo(:, 2,54, 1) = (/ &
     &2.0888e-02_r8,1.6582e-02_r8,1.1293e-02_r8,5.8278e-03_r8,4.0956e-06_r8/)
      kbo(:, 3,54, 1) = (/ &
     &2.5721e-02_r8,2.0433e-02_r8,1.3910e-02_r8,7.1575e-03_r8,4.7876e-06_r8/)
      kbo(:, 4,54, 1) = (/ &
     &3.0904e-02_r8,2.4618e-02_r8,1.6759e-02_r8,8.6032e-03_r8,5.4982e-06_r8/)
      kbo(:, 5,54, 1) = (/ &
     &3.6412e-02_r8,2.9120e-02_r8,1.9814e-02_r8,1.0143e-02_r8,6.1750e-06_r8/)
      kbo(:, 1,55, 1) = (/ &
     &1.2258e-02_r8,9.7268e-03_r8,6.6366e-03_r8,3.4428e-03_r8,2.6213e-06_r8/)
      kbo(:, 2,55, 1) = (/ &
     &1.5748e-02_r8,1.2527e-02_r8,8.5365e-03_r8,4.4115e-03_r8,3.1717e-06_r8/)
      kbo(:, 3,55, 1) = (/ &
     &1.9594e-02_r8,1.5595e-02_r8,1.0619e-02_r8,5.4666e-03_r8,3.7237e-06_r8/)
      kbo(:, 4,55, 1) = (/ &
     &2.3710e-02_r8,1.8931e-02_r8,1.2889e-02_r8,6.6186e-03_r8,4.3031e-06_r8/)
      kbo(:, 5,55, 1) = (/ &
     &2.8112e-02_r8,2.2537e-02_r8,1.5336e-02_r8,7.8537e-03_r8,4.8648e-06_r8/)
      kbo(:, 1,56, 1) = (/ &
     &9.1055e-03_r8,7.2363e-03_r8,4.9401e-03_r8,2.5664e-03_r8,1.9997e-06_r8/)
      kbo(:, 2,56, 1) = (/ &
     &1.1834e-02_r8,9.4303e-03_r8,6.4310e-03_r8,3.3278e-03_r8,2.4479e-06_r8/)
      kbo(:, 3,56, 1) = (/ &
     &1.4882e-02_r8,1.1870e-02_r8,8.0848e-03_r8,4.1651e-03_r8,2.8963e-06_r8/)
      kbo(:, 4,56, 1) = (/ &
     &1.8155e-02_r8,1.4526e-02_r8,9.8917e-03_r8,5.0809e-03_r8,3.3616e-06_r8/)
      kbo(:, 5,56, 1) = (/ &
     &2.1671e-02_r8,1.7405e-02_r8,1.1845e-02_r8,6.0691e-03_r8,3.8293e-06_r8/)
      kbo(:, 1,57, 1) = (/ &
     &6.7286e-03_r8,5.3591e-03_r8,3.6618e-03_r8,1.9048e-03_r8,1.5179e-06_r8/)
      kbo(:, 2,57, 1) = (/ &
     &8.8620e-03_r8,7.0733e-03_r8,4.8264e-03_r8,2.5013e-03_r8,1.8807e-06_r8/)
      kbo(:, 3,57, 1) = (/ &
     &1.1265e-02_r8,9.0088e-03_r8,6.1382e-03_r8,3.1650e-03_r8,2.2483e-06_r8/)
      kbo(:, 4,57, 1) = (/ &
     &1.3873e-02_r8,1.1116e-02_r8,7.5709e-03_r8,3.8911e-03_r8,2.6184e-06_r8/)
      kbo(:, 5,57, 1) = (/ &
     &1.6676e-02_r8,1.3415e-02_r8,9.1296e-03_r8,4.6803e-03_r8,3.0020e-06_r8/)
      kbo(:, 1,58, 1) = (/ &
     &1.3112e-03_r8,1.2811e-03_r8,1.1274e-03_r8,8.2340e-04_r8,1.1519e-06_r8/)
      kbo(:, 2,58, 1) = (/ &
     &1.7518e-03_r8,1.7126e-03_r8,1.5045e-03_r8,1.0941e-03_r8,1.4467e-06_r8/)
      kbo(:, 3,58, 1) = (/ &
     &2.2498e-03_r8,2.2053e-03_r8,1.9345e-03_r8,1.3994e-03_r8,1.7445e-06_r8/)
      kbo(:, 4,58, 1) = (/ &
     &2.7980e-03_r8,2.7467e-03_r8,2.4064e-03_r8,1.7337e-03_r8,2.0427e-06_r8/)
      kbo(:, 5,58, 1) = (/ &
     &3.3868e-03_r8,3.3394e-03_r8,2.9224e-03_r8,2.0998e-03_r8,2.3542e-06_r8/)
      kbo(:, 1,59, 1) = (/ &
     &1.2094e-03_r8,1.1351e-03_r8,9.3340e-04_r8,6.0964e-04_r8,9.0654e-07_r8/)
      kbo(:, 2,59, 1) = (/ &
     &1.6257e-03_r8,1.5254e-03_r8,1.2509e-03_r8,8.1260e-04_r8,1.1440e-06_r8/)
      kbo(:, 3,59, 1) = (/ &
     &2.0981e-03_r8,1.9741e-03_r8,1.6151e-03_r8,1.0426e-03_r8,1.3852e-06_r8/)
      kbo(:, 4,59, 1) = (/ &
     &2.6203e-03_r8,2.4691e-03_r8,2.0150e-03_r8,1.2943e-03_r8,1.6270e-06_r8/)
      kbo(:, 5,59, 1) = (/ &
     &3.1814e-03_r8,3.0122e-03_r8,2.4540e-03_r8,1.5709e-03_r8,1.8687e-06_r8/)
      kbo(:, 1,13, 2) = (/ &
     &6.6529e+01_r8,4.9985e+01_r8,3.3446e+01_r8,1.6923e+01_r8,3.5914e-02_r8/)
      kbo(:, 2,13, 2) = (/ &
     &7.4095e+01_r8,5.5661e+01_r8,3.7226e+01_r8,1.8804e+01_r8,3.9958e-02_r8/)
      kbo(:, 3,13, 2) = (/ &
     &8.0840e+01_r8,6.0720e+01_r8,4.0598e+01_r8,2.0484e+01_r8,4.3881e-02_r8/)
      kbo(:, 4,13, 2) = (/ &
     &8.6396e+01_r8,6.4888e+01_r8,4.3378e+01_r8,2.1867e+01_r8,4.7563e-02_r8/)
      kbo(:, 5,13, 2) = (/ &
     &9.0642e+01_r8,6.8073e+01_r8,4.5503e+01_r8,2.2931e+01_r8,5.1188e-02_r8/)
      kbo(:, 1,14, 2) = (/ &
     &3.4987e+01_r8,2.6327e+01_r8,1.7678e+01_r8,9.0444e+00_r8,3.1025e-02_r8/)
      kbo(:, 2,14, 2) = (/ &
     &3.8934e+01_r8,2.9288e+01_r8,1.9648e+01_r8,1.0023e+01_r8,3.4459e-02_r8/)
      kbo(:, 3,14, 2) = (/ &
     &4.2399e+01_r8,3.1888e+01_r8,2.1376e+01_r8,1.0881e+01_r8,3.7786e-02_r8/)
      kbo(:, 4,14, 2) = (/ &
     &4.5141e+01_r8,3.3946e+01_r8,2.2749e+01_r8,1.1559e+01_r8,4.1037e-02_r8/)
      kbo(:, 5,14, 2) = (/ &
     &4.7193e+01_r8,3.5485e+01_r8,2.3775e+01_r8,1.2071e+01_r8,4.3970e-02_r8/)
      kbo(:, 1,15, 2) = (/ &
     &1.8797e+01_r8,1.4186e+01_r8,9.5905e+00_r8,4.9916e+00_r8,2.6741e-02_r8/)
      kbo(:, 2,15, 2) = (/ &
     &2.0897e+01_r8,1.5761e+01_r8,1.0636e+01_r8,5.5075e+00_r8,2.9658e-02_r8/)
      kbo(:, 3,15, 2) = (/ &
     &2.2675e+01_r8,1.7093e+01_r8,1.1518e+01_r8,5.9424e+00_r8,3.2475e-02_r8/)
      kbo(:, 4,15, 2) = (/ &
     &2.4040e+01_r8,1.8121e+01_r8,1.2200e+01_r8,6.2773e+00_r8,3.5159e-02_r8/)
      kbo(:, 5,15, 2) = (/ &
     &2.5038e+01_r8,1.8870e+01_r8,1.2700e+01_r8,6.5270e+00_r8,3.7635e-02_r8/)
      kbo(:, 1,16, 2) = (/ &
     &1.2062e+01_r8,9.1374e+00_r8,6.2260e+00_r8,3.2778e+00_r8,2.3010e-02_r8/)
      kbo(:, 2,16, 2) = (/ &
     &1.3368e+01_r8,1.0114e+01_r8,6.8731e+00_r8,3.5955e+00_r8,2.5515e-02_r8/)
      kbo(:, 3,16, 2) = (/ &
     &1.4432e+01_r8,1.0911e+01_r8,7.4005e+00_r8,3.8523e+00_r8,2.7873e-02_r8/)
      kbo(:, 4,16, 2) = (/ &
     &1.5210e+01_r8,1.1498e+01_r8,7.7878e+00_r8,4.0427e+00_r8,3.0096e-02_r8/)
      kbo(:, 5,16, 2) = (/ &
     &1.5795e+01_r8,1.1938e+01_r8,8.0810e+00_r8,4.1897e+00_r8,3.2123e-02_r8/)
      kbo(:, 1,17, 2) = (/ &
     &8.0343e+00_r8,6.1202e+00_r8,4.2057e+00_r8,2.2416e+00_r8,1.9722e-02_r8/)
      kbo(:, 2,17, 2) = (/ &
     &8.8550e+00_r8,6.7335e+00_r8,4.6112e+00_r8,2.4399e+00_r8,2.1833e-02_r8/)
      kbo(:, 3,17, 2) = (/ &
     &9.5028e+00_r8,7.2176e+00_r8,4.9290e+00_r8,2.5918e+00_r8,2.3771e-02_r8/)
      kbo(:, 4,17, 2) = (/ &
     &9.9681e+00_r8,7.5665e+00_r8,5.1592e+00_r8,2.7054e+00_r8,2.5587e-02_r8/)
      kbo(:, 5,17, 2) = (/ &
     &1.0341e+01_r8,7.8464e+00_r8,5.3464e+00_r8,2.7998e+00_r8,2.7262e-02_r8/)
      kbo(:, 1,18, 2) = (/ &
     &5.4784e+00_r8,4.2063e+00_r8,2.9118e+00_r8,1.5707e+00_r8,1.6843e-02_r8/)
      kbo(:, 2,18, 2) = (/ &
     &6.0003e+00_r8,4.5949e+00_r8,3.1671e+00_r8,1.6950e+00_r8,1.8568e-02_r8/)
      kbo(:, 3,18, 2) = (/ &
     &6.4044e+00_r8,4.8955e+00_r8,3.3617e+00_r8,1.7866e+00_r8,2.0170e-02_r8/)
      kbo(:, 4,18, 2) = (/ &
     &6.7000e+00_r8,5.1163e+00_r8,3.5087e+00_r8,1.8600e+00_r8,2.1658e-02_r8/)
      kbo(:, 5,18, 2) = (/ &
     &6.9467e+00_r8,5.3017e+00_r8,3.6339e+00_r8,1.9245e+00_r8,2.2992e-02_r8/)
      kbo(:, 1,19, 2) = (/ &
     &3.6607e+00_r8,2.8397e+00_r8,1.9832e+00_r8,1.0810e+00_r8,1.4294e-02_r8/)
      kbo(:, 2,19, 2) = (/ &
     &3.9888e+00_r8,3.0825e+00_r8,2.1422e+00_r8,1.1564e+00_r8,1.5700e-02_r8/)
      kbo(:, 3,19, 2) = (/ &
     &4.2403e+00_r8,3.2678e+00_r8,2.2604e+00_r8,1.2129e+00_r8,1.7026e-02_r8/)
      kbo(:, 4,19, 2) = (/ &
     &4.4304e+00_r8,3.4105e+00_r8,2.3562e+00_r8,1.2611e+00_r8,1.8223e-02_r8/)
      kbo(:, 5,19, 2) = (/ &
     &4.5892e+00_r8,3.5305e+00_r8,2.4376e+00_r8,1.3052e+00_r8,1.9250e-02_r8/)
      kbo(:, 1,20, 2) = (/ &
     &2.6484e+00_r8,2.0725e+00_r8,1.4576e+00_r8,7.9887e-01_r8,1.2095e-02_r8/)
      kbo(:, 2,20, 2) = (/ &
     &2.8723e+00_r8,2.2377e+00_r8,1.5638e+00_r8,8.4850e-01_r8,1.3258e-02_r8/)
      kbo(:, 3,20, 2) = (/ &
     &3.0432e+00_r8,2.3620e+00_r8,1.6433e+00_r8,8.8749e-01_r8,1.4323e-02_r8/)
      kbo(:, 4,20, 2) = (/ &
     &3.1766e+00_r8,2.4628e+00_r8,1.7113e+00_r8,9.2233e-01_r8,1.5251e-02_r8/)
      kbo(:, 5,20, 2) = (/ &
     &3.2896e+00_r8,2.5490e+00_r8,1.7710e+00_r8,9.5551e-01_r8,1.6040e-02_r8/)
      kbo(:, 1,21, 2) = (/ &
     &1.9737e+00_r8,1.5589e+00_r8,1.1005e+00_r8,6.0564e-01_r8,1.0202e-02_r8/)
      kbo(:, 2,21, 2) = (/ &
     &2.1324e+00_r8,1.6743e+00_r8,1.1736e+00_r8,6.4004e-01_r8,1.1146e-02_r8/)
      kbo(:, 3,21, 2) = (/ &
     &2.2543e+00_r8,1.7630e+00_r8,1.2313e+00_r8,6.6865e-01_r8,1.1981e-02_r8/)
      kbo(:, 4,21, 2) = (/ &
     &2.3508e+00_r8,1.8360e+00_r8,1.2809e+00_r8,6.9497e-01_r8,1.2686e-02_r8/)
      kbo(:, 5,21, 2) = (/ &
     &2.4312e+00_r8,1.8986e+00_r8,1.3258e+00_r8,7.2010e-01_r8,1.3291e-02_r8/)
      kbo(:, 1,22, 2) = (/ &
     &1.5156e+00_r8,1.2064e+00_r8,8.5276e-01_r8,4.7037e-01_r8,8.6256e-03_r8/)
      kbo(:, 2,22, 2) = (/ &
     &1.6299e+00_r8,1.2880e+00_r8,9.0439e-01_r8,4.9507e-01_r8,9.3659e-03_r8/)
      kbo(:, 3,22, 2) = (/ &
     &1.7167e+00_r8,1.3521e+00_r8,9.4701e-01_r8,5.1663e-01_r8,1.0004e-02_r8/)
      kbo(:, 4,22, 2) = (/ &
     &1.7876e+00_r8,1.4059e+00_r8,9.8421e-01_r8,5.3690e-01_r8,1.0541e-02_r8/)
      kbo(:, 5,22, 2) = (/ &
     &1.8482e+00_r8,1.4540e+00_r8,1.0190e+00_r8,5.5667e-01_r8,1.1012e-02_r8/)
      kbo(:, 1,23, 2) = (/ &
     &1.1701e+00_r8,9.3735e-01_r8,6.6344e-01_r8,3.6672e-01_r8,7.2585e-03_r8/)
      kbo(:, 2,23, 2) = (/ &
     &1.2526e+00_r8,9.9560e-01_r8,7.0066e-01_r8,3.8497e-01_r8,7.8298e-03_r8/)
      kbo(:, 3,23, 2) = (/ &
     &1.3157e+00_r8,1.0429e+00_r8,7.3247e-01_r8,4.0155e-01_r8,8.3206e-03_r8/)
      kbo(:, 4,23, 2) = (/ &
     &1.3685e+00_r8,1.0835e+00_r8,7.6114e-01_r8,4.1717e-01_r8,8.7383e-03_r8/)
      kbo(:, 5,23, 2) = (/ &
     &1.4146e+00_r8,1.1207e+00_r8,7.8818e-01_r8,4.3301e-01_r8,9.1036e-03_r8/)
      kbo(:, 1,24, 2) = (/ &
     &8.9949e-01_r8,7.2462e-01_r8,5.1357e-01_r8,2.8470e-01_r8,6.0789e-03_r8/)
      kbo(:, 2,24, 2) = (/ &
     &9.5867e-01_r8,7.6639e-01_r8,5.4063e-01_r8,2.9829e-01_r8,6.5218e-03_r8/)
      kbo(:, 3,24, 2) = (/ &
     &1.0042e+00_r8,8.0114e-01_r8,5.6436e-01_r8,3.1100e-01_r8,6.9029e-03_r8/)
      kbo(:, 4,24, 2) = (/ &
     &1.0431e+00_r8,8.3179e-01_r8,5.8619e-01_r8,3.2299e-01_r8,7.2295e-03_r8/)
      kbo(:, 5,24, 2) = (/ &
     &1.0790e+00_r8,8.6138e-01_r8,6.0791e-01_r8,3.3588e-01_r8,7.5120e-03_r8/)
      kbo(:, 1,25, 2) = (/ &
     &7.0112e-01_r8,5.6715e-01_r8,4.0233e-01_r8,2.2369e-01_r8,5.0763e-03_r8/)
      kbo(:, 2,25, 2) = (/ &
     &7.4350e-01_r8,5.9764e-01_r8,4.2250e-01_r8,2.3404e-01_r8,5.4222e-03_r8/)
      kbo(:, 3,25, 2) = (/ &
     &7.7710e-01_r8,6.2349e-01_r8,4.4048e-01_r8,2.4369e-01_r8,5.7195e-03_r8/)
      kbo(:, 4,25, 2) = (/ &
     &8.0619e-01_r8,6.4737e-01_r8,4.5753e-01_r8,2.5334e-01_r8,5.9744e-03_r8/)
      kbo(:, 5,25, 2) = (/ &
     &8.3531e-01_r8,6.7147e-01_r8,4.7545e-01_r8,2.6391e-01_r8,6.1951e-03_r8/)
      kbo(:, 1,26, 2) = (/ &
     &5.5605e-01_r8,4.5118e-01_r8,3.2039e-01_r8,1.7855e-01_r8,4.2346e-03_r8/)
      kbo(:, 2,26, 2) = (/ &
     &5.8683e-01_r8,4.7392e-01_r8,3.3566e-01_r8,1.8647e-01_r8,4.5042e-03_r8/)
      kbo(:, 3,26, 2) = (/ &
     &6.1229e-01_r8,4.9380e-01_r8,3.4972e-01_r8,1.9404e-01_r8,4.7382e-03_r8/)
      kbo(:, 4,26, 2) = (/ &
     &6.3488e-01_r8,5.1281e-01_r8,3.6343e-01_r8,2.0206e-01_r8,4.9373e-03_r8/)
      kbo(:, 5,26, 2) = (/ &
     &6.5886e-01_r8,5.3298e-01_r8,3.7847e-01_r8,2.1092e-01_r8,5.1112e-03_r8/)
      kbo(:, 1,27, 2) = (/ &
     &4.5766e-01_r8,3.7194e-01_r8,2.6418e-01_r8,1.4728e-01_r8,3.5266e-03_r8/)
      kbo(:, 2,27, 2) = (/ &
     &4.8116e-01_r8,3.8971e-01_r8,2.7627e-01_r8,1.5359e-01_r8,3.7388e-03_r8/)
      kbo(:, 3,27, 2) = (/ &
     &5.0141e-01_r8,4.0592e-01_r8,2.8779e-01_r8,1.5989e-01_r8,3.9220e-03_r8/)
      kbo(:, 4,27, 2) = (/ &
     &5.1998e-01_r8,4.2171e-01_r8,2.9940e-01_r8,1.6680e-01_r8,4.0803e-03_r8/)
      kbo(:, 5,27, 2) = (/ &
     &5.4049e-01_r8,4.3926e-01_r8,3.1241e-01_r8,1.7445e-01_r8,4.2171e-03_r8/)
      kbo(:, 1,28, 2) = (/ &
     &3.8656e-01_r8,3.1440e-01_r8,2.2322e-01_r8,1.2431e-01_r8,2.9341e-03_r8/)
      kbo(:, 2,28, 2) = (/ &
     &4.0539e-01_r8,3.2888e-01_r8,2.3321e-01_r8,1.2952e-01_r8,3.1008e-03_r8/)
      kbo(:, 3,28, 2) = (/ &
     &4.2208e-01_r8,3.4256e-01_r8,2.4291e-01_r8,1.3505e-01_r8,3.2456e-03_r8/)
      kbo(:, 4,28, 2) = (/ &
     &4.3788e-01_r8,3.5618e-01_r8,2.5311e-01_r8,1.4108e-01_r8,3.3707e-03_r8/)
      kbo(:, 5,28, 2) = (/ &
     &4.5599e-01_r8,3.7197e-01_r8,2.6475e-01_r8,1.4784e-01_r8,3.4778e-03_r8/)
      kbo(:, 1,29, 2) = (/ &
     &3.4663e-01_r8,2.8147e-01_r8,1.9935e-01_r8,1.1053e-01_r8,2.4407e-03_r8/)
      kbo(:, 2,29, 2) = (/ &
     &3.6288e-01_r8,2.9416e-01_r8,2.0825e-01_r8,1.1525e-01_r8,2.5726e-03_r8/)
      kbo(:, 3,29, 2) = (/ &
     &3.7738e-01_r8,3.0636e-01_r8,2.1696e-01_r8,1.2034e-01_r8,2.6876e-03_r8/)
      kbo(:, 4,29, 2) = (/ &
     &3.9208e-01_r8,3.1911e-01_r8,2.2648e-01_r8,1.2589e-01_r8,2.7881e-03_r8/)
      kbo(:, 5,29, 2) = (/ &
     &4.0886e-01_r8,3.3389e-01_r8,2.3740e-01_r8,1.3220e-01_r8,2.8698e-03_r8/)
      kbo(:, 1,30, 2) = (/ &
     &3.1859e-01_r8,2.5807e-01_r8,1.8226e-01_r8,1.0052e-01_r8,2.0286e-03_r8/)
      kbo(:, 2,30, 2) = (/ &
     &3.3300e-01_r8,2.6960e-01_r8,1.9038e-01_r8,1.0493e-01_r8,2.1345e-03_r8/)
      kbo(:, 3,30, 2) = (/ &
     &3.4608e-01_r8,2.8079e-01_r8,1.9849e-01_r8,1.0968e-01_r8,2.2264e-03_r8/)
      kbo(:, 4,30, 2) = (/ &
     &3.6002e-01_r8,2.9303e-01_r8,2.0760e-01_r8,1.1495e-01_r8,2.3052e-03_r8/)
      kbo(:, 5,30, 2) = (/ &
     &3.7616e-01_r8,3.0718e-01_r8,2.1802e-01_r8,1.2086e-01_r8,2.3703e-03_r8/)
      kbo(:, 1,31, 2) = (/ &
     &3.0804e-01_r8,2.4854e-01_r8,1.7488e-01_r8,9.5771e-02_r8,1.6879e-03_r8/)
      kbo(:, 2,31, 2) = (/ &
     &3.2148e-01_r8,2.5954e-01_r8,1.8261e-01_r8,1.0007e-01_r8,1.7724e-03_r8/)
      kbo(:, 3,31, 2) = (/ &
     &3.3418e-01_r8,2.7047e-01_r8,1.9064e-01_r8,1.0472e-01_r8,1.8461e-03_r8/)
      kbo(:, 4,31, 2) = (/ &
     &3.4816e-01_r8,2.8282e-01_r8,1.9976e-01_r8,1.0990e-01_r8,1.9082e-03_r8/)
      kbo(:, 5,31, 2) = (/ &
     &3.6451e-01_r8,2.9706e-01_r8,2.1019e-01_r8,1.1572e-01_r8,1.9578e-03_r8/)
      kbo(:, 1,32, 2) = (/ &
     &3.0134e-01_r8,2.4222e-01_r8,1.6982e-01_r8,9.2391e-02_r8,1.4045e-03_r8/)
      kbo(:, 2,32, 2) = (/ &
     &3.1413e-01_r8,2.5288e-01_r8,1.7732e-01_r8,9.6600e-02_r8,1.4719e-03_r8/)
      kbo(:, 3,32, 2) = (/ &
     &3.2677e-01_r8,2.6386e-01_r8,1.8545e-01_r8,1.0123e-01_r8,1.5309e-03_r8/)
      kbo(:, 4,32, 2) = (/ &
     &3.4104e-01_r8,2.7646e-01_r8,1.9466e-01_r8,1.0637e-01_r8,1.5796e-03_r8/)
      kbo(:, 5,32, 2) = (/ &
     &3.5782e-01_r8,2.9105e-01_r8,2.0529e-01_r8,1.1222e-01_r8,1.6199e-03_r8/)
      kbo(:, 1,33, 2) = (/ &
     &3.0007e-01_r8,2.4036e-01_r8,1.6789e-01_r8,9.0749e-02_r8,1.1692e-03_r8/)
      kbo(:, 2,33, 2) = (/ &
     &3.1257e-01_r8,2.5093e-01_r8,1.7540e-01_r8,9.4970e-02_r8,1.2231e-03_r8/)
      kbo(:, 3,33, 2) = (/ &
     &3.2551e-01_r8,2.6224e-01_r8,1.8373e-01_r8,9.9635e-02_r8,1.2703e-03_r8/)
      kbo(:, 4,33, 2) = (/ &
     &3.4043e-01_r8,2.7535e-01_r8,1.9325e-01_r8,1.0486e-01_r8,1.3103e-03_r8/)
      kbo(:, 5,33, 2) = (/ &
     &3.5814e-01_r8,2.9066e-01_r8,2.0432e-01_r8,1.1086e-01_r8,1.3413e-03_r8/)
      kbo(:, 1,34, 2) = (/ &
     &2.9092e-01_r8,2.3257e-01_r8,1.6200e-01_r8,8.7114e-02_r8,9.7104e-04_r8/)
      kbo(:, 2,34, 2) = (/ &
     &3.0301e-01_r8,2.4286e-01_r8,1.6939e-01_r8,9.1256e-02_r8,1.0146e-03_r8/)
      kbo(:, 3,34, 2) = (/ &
     &3.1600e-01_r8,2.5431e-01_r8,1.7773e-01_r8,9.5863e-02_r8,1.0532e-03_r8/)
      kbo(:, 4,34, 2) = (/ &
     &3.3116e-01_r8,2.6756e-01_r8,1.8732e-01_r8,1.0106e-01_r8,1.0840e-03_r8/)
      kbo(:, 5,34, 2) = (/ &
     &3.4944e-01_r8,2.8336e-01_r8,1.9862e-01_r8,1.0710e-01_r8,1.1076e-03_r8/)
      kbo(:, 1,35, 2) = (/ &
     &2.8133e-01_r8,2.2448e-01_r8,1.5598e-01_r8,8.3470e-02_r8,8.0326e-04_r8/)
      kbo(:, 2,35, 2) = (/ &
     &2.9315e-01_r8,2.3461e-01_r8,1.6327e-01_r8,8.7518e-02_r8,8.3948e-04_r8/)
      kbo(:, 3,35, 2) = (/ &
     &3.0606e-01_r8,2.4602e-01_r8,1.7152e-01_r8,9.2018e-02_r8,8.6953e-04_r8/)
      kbo(:, 4,35, 2) = (/ &
     &3.2135e-01_r8,2.5937e-01_r8,1.8112e-01_r8,9.7174e-02_r8,8.9330e-04_r8/)
      kbo(:, 5,35, 2) = (/ &
     &3.3996e-01_r8,2.7548e-01_r8,1.9256e-01_r8,1.0324e-01_r8,9.1326e-04_r8/)
      kbo(:, 1,36, 2) = (/ &
     &2.6927e-01_r8,2.1450e-01_r8,1.4871e-01_r8,7.9228e-02_r8,6.6044e-04_r8/)
      kbo(:, 2,36, 2) = (/ &
     &2.8072e-01_r8,2.2434e-01_r8,1.5577e-01_r8,8.3114e-02_r8,6.9019e-04_r8/)
      kbo(:, 3,36, 2) = (/ &
     &2.9329e-01_r8,2.3546e-01_r8,1.6379e-01_r8,8.7445e-02_r8,7.1471e-04_r8/)
      kbo(:, 4,36, 2) = (/ &
     &3.0843e-01_r8,2.4872e-01_r8,1.7326e-01_r8,9.2498e-02_r8,7.3506e-04_r8/)
      kbo(:, 5,36, 2) = (/ &
     &3.2685e-01_r8,2.6470e-01_r8,1.8459e-01_r8,9.8476e-02_r8,7.5121e-04_r8/)
      kbo(:, 1,37, 2) = (/ &
     &2.4965e-01_r8,1.9865e-01_r8,1.3749e-01_r8,7.2983e-02_r8,5.3914e-04_r8/)
      kbo(:, 2,37, 2) = (/ &
     &2.6042e-01_r8,2.0789e-01_r8,1.4407e-01_r8,7.6575e-02_r8,5.6372e-04_r8/)
      kbo(:, 3,37, 2) = (/ &
     &2.7217e-01_r8,2.1833e-01_r8,1.5157e-01_r8,8.0593e-02_r8,5.8448e-04_r8/)
      kbo(:, 4,37, 2) = (/ &
     &2.8633e-01_r8,2.3076e-01_r8,1.6043e-01_r8,8.5310e-02_r8,6.0216e-04_r8/)
      kbo(:, 5,37, 2) = (/ &
     &3.0356e-01_r8,2.4582e-01_r8,1.7110e-01_r8,9.0929e-02_r8,6.1615e-04_r8/)
      kbo(:, 1,38, 2) = (/ &
     &2.3485e-01_r8,1.8661e-01_r8,1.2891e-01_r8,6.8178e-02_r8,4.3970e-04_r8/)
      kbo(:, 2,38, 2) = (/ &
     &2.4515e-01_r8,1.9543e-01_r8,1.3515e-01_r8,7.1546e-02_r8,4.6052e-04_r8/)
      kbo(:, 3,38, 2) = (/ &
     &2.5629e-01_r8,2.0533e-01_r8,1.4225e-01_r8,7.5330e-02_r8,4.7811e-04_r8/)
      kbo(:, 4,38, 2) = (/ &
     &2.6971e-01_r8,2.1715e-01_r8,1.5065e-01_r8,7.9788e-02_r8,4.9330e-04_r8/)
      kbo(:, 5,38, 2) = (/ &
     &2.8605e-01_r8,2.3151e-01_r8,1.6083e-01_r8,8.5133e-02_r8,5.0547e-04_r8/)
      kbo(:, 1,39, 2) = (/ &
     &2.2602e-01_r8,1.7927e-01_r8,1.2358e-01_r8,6.5103e-02_r8,3.5893e-04_r8/)
      kbo(:, 2,39, 2) = (/ &
     &2.3611e-01_r8,1.8789e-01_r8,1.2965e-01_r8,6.8347e-02_r8,3.7626e-04_r8/)
      kbo(:, 3,39, 2) = (/ &
     &2.4693e-01_r8,1.9751e-01_r8,1.3653e-01_r8,7.1994e-02_r8,3.9112e-04_r8/)
      kbo(:, 4,39, 2) = (/ &
     &2.5998e-01_r8,2.0903e-01_r8,1.4470e-01_r8,7.6316e-02_r8,4.0431e-04_r8/)
      kbo(:, 5,39, 2) = (/ &
     &2.7577e-01_r8,2.2297e-01_r8,1.5458e-01_r8,8.1500e-02_r8,4.1520e-04_r8/)
      kbo(:, 1,40, 2) = (/ &
     &2.0347e-01_r8,1.6128e-01_r8,1.1107e-01_r8,5.8373e-02_r8,2.9088e-04_r8/)
      kbo(:, 2,40, 2) = (/ &
     &2.1275e-01_r8,1.6921e-01_r8,1.1659e-01_r8,6.1296e-02_r8,3.0550e-04_r8/)
      kbo(:, 3,40, 2) = (/ &
     &2.2248e-01_r8,1.7787e-01_r8,1.2279e-01_r8,6.4562e-02_r8,3.1830e-04_r8/)
      kbo(:, 4,40, 2) = (/ &
     &2.3419e-01_r8,1.8824e-01_r8,1.3013e-01_r8,6.8434e-02_r8,3.2975e-04_r8/)
      kbo(:, 5,40, 2) = (/ &
     &2.4824e-01_r8,2.0081e-01_r8,1.3903e-01_r8,7.3098e-02_r8,3.3913e-04_r8/)
      kbo(:, 1,41, 2) = (/ &
     &1.8258e-01_r8,1.4470e-01_r8,9.9535e-02_r8,5.2202e-02_r8,2.3535e-04_r8/)
      kbo(:, 2,41, 2) = (/ &
     &1.9113e-01_r8,1.5197e-01_r8,1.0458e-01_r8,5.4844e-02_r8,2.4773e-04_r8/)
      kbo(:, 3,41, 2) = (/ &
     &1.9995e-01_r8,1.5977e-01_r8,1.1015e-01_r8,5.7766e-02_r8,2.5866e-04_r8/)
      kbo(:, 4,41, 2) = (/ &
     &2.1035e-01_r8,1.6906e-01_r8,1.1672e-01_r8,6.1215e-02_r8,2.6866e-04_r8/)
      kbo(:, 5,41, 2) = (/ &
     &2.2281e-01_r8,1.8031e-01_r8,1.2469e-01_r8,6.5393e-02_r8,2.7675e-04_r8/)
      kbo(:, 1,42, 2) = (/ &
     &1.6555e-01_r8,1.3118e-01_r8,9.0125e-02_r8,4.7172e-02_r8,1.9035e-04_r8/)
      kbo(:, 2,42, 2) = (/ &
     &1.7351e-01_r8,1.3791e-01_r8,9.4797e-02_r8,4.9586e-02_r8,2.0086e-04_r8/)
      kbo(:, 3,42, 2) = (/ &
     &1.8167e-01_r8,1.4504e-01_r8,9.9843e-02_r8,5.2229e-02_r8,2.1016e-04_r8/)
      kbo(:, 4,42, 2) = (/ &
     &1.9101e-01_r8,1.5346e-01_r8,1.0581e-01_r8,5.5333e-02_r8,2.1875e-04_r8/)
      kbo(:, 5,42, 2) = (/ &
     &2.0220e-01_r8,1.6362e-01_r8,1.1299e-01_r8,5.9103e-02_r8,2.2587e-04_r8/)
      kbo(:, 1,43, 2) = (/ &
     &1.5093e-01_r8,1.1961e-01_r8,8.2075e-02_r8,4.2874e-02_r8,1.5326e-04_r8/)
      kbo(:, 2,43, 2) = (/ &
     &1.5853e-01_r8,1.2589e-01_r8,8.6428e-02_r8,4.5110e-02_r8,1.6227e-04_r8/)
      kbo(:, 3,43, 2) = (/ &
     &1.6609e-01_r8,1.3244e-01_r8,9.1034e-02_r8,4.7504e-02_r8,1.7029e-04_r8/)
      kbo(:, 4,43, 2) = (/ &
     &1.7452e-01_r8,1.4008e-01_r8,9.6428e-02_r8,5.0296e-02_r8,1.7773e-04_r8/)
      kbo(:, 5,43, 2) = (/ &
     &1.8456e-01_r8,1.4921e-01_r8,1.0290e-01_r8,5.3684e-02_r8,1.8398e-04_r8/)
      kbo(:, 1,44, 2) = (/ &
     &1.3921e-01_r8,1.1030e-01_r8,7.5620e-02_r8,3.9420e-02_r8,1.2316e-04_r8/)
      kbo(:, 2,44, 2) = (/ &
     &1.4661e-01_r8,1.1628e-01_r8,7.9723e-02_r8,4.1521e-02_r8,1.3084e-04_r8/)
      kbo(:, 3,44, 2) = (/ &
     &1.5377e-01_r8,1.2242e-01_r8,8.4004e-02_r8,4.3727e-02_r8,1.3764e-04_r8/)
      kbo(:, 4,44, 2) = (/ &
     &1.6148e-01_r8,1.2941e-01_r8,8.8933e-02_r8,4.6269e-02_r8,1.4416e-04_r8/)
      kbo(:, 5,44, 2) = (/ &
     &1.7060e-01_r8,1.3772e-01_r8,9.4815e-02_r8,4.9343e-02_r8,1.4964e-04_r8/)
      kbo(:, 1,45, 2) = (/ &
     &1.3086e-01_r8,1.0364e-01_r8,7.0980e-02_r8,3.6935e-02_r8,9.8771e-05_r8/)
      kbo(:, 2,45, 2) = (/ &
     &1.3832e-01_r8,1.0957e-01_r8,7.5010e-02_r8,3.8986e-02_r8,1.0533e-04_r8/)
      kbo(:, 3,45, 2) = (/ &
     &1.4520e-01_r8,1.1543e-01_r8,7.9072e-02_r8,4.1056e-02_r8,1.1127e-04_r8/)
      kbo(:, 4,45, 2) = (/ &
     &1.5249e-01_r8,1.2195e-01_r8,8.3674e-02_r8,4.3425e-02_r8,1.1690e-04_r8/)
      kbo(:, 5,45, 2) = (/ &
     &1.6094e-01_r8,1.2967e-01_r8,8.9124e-02_r8,4.6256e-02_r8,1.2176e-04_r8/)
      kbo(:, 1,46, 2) = (/ &
     &1.2395e-01_r8,9.8133e-02_r8,6.7135e-02_r8,3.4876e-02_r8,7.8972e-05_r8/)
      kbo(:, 2,46, 2) = (/ &
     &1.3154e-01_r8,1.0413e-01_r8,7.1186e-02_r8,3.6923e-02_r8,8.4580e-05_r8/)
      kbo(:, 3,46, 2) = (/ &
     &1.3835e-01_r8,1.0981e-01_r8,7.5111e-02_r8,3.8913e-02_r8,8.9707e-05_r8/)
      kbo(:, 4,46, 2) = (/ &
     &1.4539e-01_r8,1.1598e-01_r8,7.9454e-02_r8,4.1140e-02_r8,9.4570e-05_r8/)
      kbo(:, 5,46, 2) = (/ &
     &1.5328e-01_r8,1.2322e-01_r8,8.4552e-02_r8,4.3768e-02_r8,9.8952e-05_r8/)
      kbo(:, 1,47, 2) = (/ &
     &1.1561e-01_r8,9.1621e-02_r8,6.2646e-02_r8,3.2504e-02_r8,6.2836e-05_r8/)
      kbo(:, 2,47, 2) = (/ &
     &1.2359e-01_r8,9.7799e-02_r8,6.6803e-02_r8,3.4586e-02_r8,6.7612e-05_r8/)
      kbo(:, 3,47, 2) = (/ &
     &1.3036e-01_r8,1.0330e-01_r8,7.0567e-02_r8,3.6497e-02_r8,7.2040e-05_r8/)
      kbo(:, 4,47, 2) = (/ &
     &1.3710e-01_r8,1.0912e-01_r8,7.4632e-02_r8,3.8567e-02_r8,7.6196e-05_r8/)
      kbo(:, 5,47, 2) = (/ &
     &1.4440e-01_r8,1.1580e-01_r8,7.9334e-02_r8,4.0981e-02_r8,8.0080e-05_r8/)
      kbo(:, 1,48, 2) = (/ &
     &1.1035e-01_r8,8.7581e-02_r8,5.9868e-02_r8,3.1032e-02_r8,4.9884e-05_r8/)
      kbo(:, 2,48, 2) = (/ &
     &1.1928e-01_r8,9.4310e-02_r8,6.4353e-02_r8,3.3267e-02_r8,5.4019e-05_r8/)
      kbo(:, 3,48, 2) = (/ &
     &1.2628e-01_r8,9.9898e-02_r8,6.8156e-02_r8,3.5187e-02_r8,5.7777e-05_r8/)
      kbo(:, 4,48, 2) = (/ &
     &1.3294e-01_r8,1.0557e-01_r8,7.2080e-02_r8,3.7168e-02_r8,6.1393e-05_r8/)
      kbo(:, 5,48, 2) = (/ &
     &1.3996e-01_r8,1.1191e-01_r8,7.6553e-02_r8,3.9465e-02_r8,6.4815e-05_r8/)
      kbo(:, 1,49, 2) = (/ &
     &1.0914e-01_r8,8.6684e-02_r8,5.9236e-02_r8,3.0679e-02_r8,3.9521e-05_r8/)
      kbo(:, 2,49, 2) = (/ &
     &1.1962e-01_r8,9.4485e-02_r8,6.4406e-02_r8,3.3233e-02_r8,4.3077e-05_r8/)
      kbo(:, 3,49, 2) = (/ &
     &1.2732e-01_r8,1.0058e-01_r8,6.8523e-02_r8,3.5308e-02_r8,4.6318e-05_r8/)
      kbo(:, 4,49, 2) = (/ &
     &1.3429e-01_r8,1.0636e-01_r8,7.2504e-02_r8,3.7320e-02_r8,4.9451e-05_r8/)
      kbo(:, 5,49, 2) = (/ &
     &1.4147e-01_r8,1.1268e-01_r8,7.6951e-02_r8,3.9591e-02_r8,5.2405e-05_r8/)
      kbo(:, 1,50, 2) = (/ &
     &1.0267e-01_r8,8.1582e-02_r8,5.5735e-02_r8,2.8850e-02_r8,3.1268e-05_r8/)
      kbo(:, 2,50, 2) = (/ &
     &1.1402e-01_r8,9.0165e-02_r8,6.1437e-02_r8,3.1671e-02_r8,3.4319e-05_r8/)
      kbo(:, 3,50, 2) = (/ &
     &1.2234e-01_r8,9.6602e-02_r8,6.5766e-02_r8,3.3840e-02_r8,3.7076e-05_r8/)
      kbo(:, 4,50, 2) = (/ &
     &1.2939e-01_r8,1.0230e-01_r8,6.9668e-02_r8,3.5813e-02_r8,3.9737e-05_r8/)
      kbo(:, 5,50, 2) = (/ &
     &1.3639e-01_r8,1.0837e-01_r8,7.3903e-02_r8,3.7967e-02_r8,4.2232e-05_r8/)
      kbo(:, 1,51, 2) = (/ &
     &9.4284e-02_r8,7.4953e-02_r8,5.1186e-02_r8,2.6482e-02_r8,2.4659e-05_r8/)
      kbo(:, 2,51, 2) = (/ &
     &1.0593e-01_r8,8.3948e-02_r8,5.7209e-02_r8,2.9486e-02_r8,2.7298e-05_r8/)
      kbo(:, 3,51, 2) = (/ &
     &1.1492e-01_r8,9.0727e-02_r8,6.1733e-02_r8,3.1740e-02_r8,2.9657e-05_r8/)
      kbo(:, 4,51, 2) = (/ &
     &1.2197e-01_r8,9.6371e-02_r8,6.5573e-02_r8,3.3673e-02_r8,3.1882e-05_r8/)
      kbo(:, 5,51, 2) = (/ &
     &1.2870e-01_r8,1.0212e-01_r8,6.9569e-02_r8,3.5694e-02_r8,3.4030e-05_r8/)
      kbo(:, 1,52, 2) = (/ &
     &8.8743e-02_r8,7.0542e-02_r8,4.8148e-02_r8,2.4885e-02_r8,1.9415e-05_r8/)
      kbo(:, 2,52, 2) = (/ &
     &1.0078e-01_r8,7.9976e-02_r8,5.4503e-02_r8,2.8085e-02_r8,2.1689e-05_r8/)
      kbo(:, 3,52, 2) = (/ &
     &1.1078e-01_r8,8.7454e-02_r8,5.9476e-02_r8,3.0551e-02_r8,2.3703e-05_r8/)
      kbo(:, 4,52, 2) = (/ &
     &1.1817e-01_r8,9.3325e-02_r8,6.3448e-02_r8,3.2545e-02_r8,2.5596e-05_r8/)
      kbo(:, 5,52, 2) = (/ &
     &1.2490e-01_r8,9.8940e-02_r8,6.7340e-02_r8,3.4514e-02_r8,2.7422e-05_r8/)
      kbo(:, 1,53, 2) = (/ &
     &8.6662e-02_r8,6.8864e-02_r8,4.6962e-02_r8,2.4236e-02_r8,1.5263e-05_r8/)
      kbo(:, 2,53, 2) = (/ &
     &9.9515e-02_r8,7.8952e-02_r8,5.3787e-02_r8,2.7692e-02_r8,1.7200e-05_r8/)
      kbo(:, 3,53, 2) = (/ &
     &1.1085e-01_r8,8.7554e-02_r8,5.9520e-02_r8,3.0542e-02_r8,1.8920e-05_r8/)
      kbo(:, 4,53, 2) = (/ &
     &1.1918e-01_r8,9.4022e-02_r8,6.3885e-02_r8,3.2726e-02_r8,2.0582e-05_r8/)
      kbo(:, 5,53, 2) = (/ &
     &1.2628e-01_r8,9.9818e-02_r8,6.7862e-02_r8,3.4747e-02_r8,2.2128e-05_r8/)
      kbo(:, 1,54, 2) = (/ &
     &7.3195e-02_r8,5.8286e-02_r8,3.9755e-02_r8,2.0520e-02_r8,1.1967e-05_r8/)
      kbo(:, 2,54, 2) = (/ &
     &8.4972e-02_r8,6.7544e-02_r8,4.6023e-02_r8,2.3702e-02_r8,1.3585e-05_r8/)
      kbo(:, 3,54, 2) = (/ &
     &9.5709e-02_r8,7.5855e-02_r8,5.1595e-02_r8,2.6489e-02_r8,1.5051e-05_r8/)
      kbo(:, 4,54, 2) = (/ &
     &1.0394e-01_r8,8.2096e-02_r8,5.5779e-02_r8,2.8575e-02_r8,1.6406e-05_r8/)
      kbo(:, 5,54, 2) = (/ &
     &1.1051e-01_r8,8.7391e-02_r8,5.9394e-02_r8,3.0393e-02_r8,1.7745e-05_r8/)
      kbo(:, 1,55, 2) = (/ &
     &5.6277e-02_r8,4.4947e-02_r8,3.0672e-02_r8,1.5850e-02_r8,9.3585e-06_r8/)
      kbo(:, 2,55, 2) = (/ &
     &6.6102e-02_r8,5.2729e-02_r8,3.5949e-02_r8,1.8531e-02_r8,1.0684e-05_r8/)
      kbo(:, 3,55, 2) = (/ &
     &7.5193e-02_r8,5.9877e-02_r8,4.0765e-02_r8,2.0959e-02_r8,1.1938e-05_r8/)
      kbo(:, 4,55, 2) = (/ &
     &8.2620e-02_r8,6.5458e-02_r8,4.4488e-02_r8,2.2798e-02_r8,1.3050e-05_r8/)
      kbo(:, 5,55, 2) = (/ &
     &8.8216e-02_r8,6.9936e-02_r8,4.7530e-02_r8,2.4316e-02_r8,1.4154e-05_r8/)
      kbo(:, 1,56, 2) = (/ &
     &4.3039e-02_r8,3.4453e-02_r8,2.3524e-02_r8,1.2170e-02_r8,7.2880e-06_r8/)
      kbo(:, 2,56, 2) = (/ &
     &5.1258e-02_r8,4.1038e-02_r8,2.7994e-02_r8,1.4446e-02_r8,8.3961e-06_r8/)
      kbo(:, 3,56, 2) = (/ &
     &5.8906e-02_r8,4.7098e-02_r8,3.2089e-02_r8,1.6519e-02_r8,9.4488e-06_r8/)
      kbo(:, 4,56, 2) = (/ &
     &6.5506e-02_r8,5.2094e-02_r8,3.5421e-02_r8,1.8161e-02_r8,1.0382e-05_r8/)
      kbo(:, 5,56, 2) = (/ &
     &7.0360e-02_r8,5.5940e-02_r8,3.8018e-02_r8,1.9445e-02_r8,1.1248e-05_r8/)
      kbo(:, 1,57, 2) = (/ &
     &3.2674e-02_r8,2.6237e-02_r8,1.7922e-02_r8,9.2805e-03_r8,5.6715e-06_r8/)
      kbo(:, 2,57, 2) = (/ &
     &3.9609e-02_r8,3.1835e-02_r8,2.1730e-02_r8,1.1223e-02_r8,6.5904e-06_r8/)
      kbo(:, 3,57, 2) = (/ &
     &4.6006e-02_r8,3.6922e-02_r8,2.5172e-02_r8,1.2973e-02_r8,7.4542e-06_r8/)
      kbo(:, 4,57, 2) = (/ &
     &5.1740e-02_r8,4.1352e-02_r8,2.8137e-02_r8,1.4436e-02_r8,8.2537e-06_r8/)
      kbo(:, 5,57, 2) = (/ &
     &5.6054e-02_r8,4.4686e-02_r8,3.0382e-02_r8,1.5541e-02_r8,8.9675e-06_r8/)
      kbo(:, 1,58, 2) = (/ &
     &6.5163e-03_r8,6.4215e-03_r8,5.6470e-03_r8,4.1032e-03_r8,4.4127e-06_r8/)
      kbo(:, 2,58, 2) = (/ &
     &8.0617e-03_r8,7.9508e-03_r8,6.9853e-03_r8,5.0619e-03_r8,5.1550e-06_r8/)
      kbo(:, 3,58, 2) = (/ &
     &9.4685e-03_r8,9.3297e-03_r8,8.1872e-03_r8,5.9187e-03_r8,5.8809e-06_r8/)
      kbo(:, 4,58, 2) = (/ &
     &1.0753e-02_r8,1.0568e-02_r8,9.2585e-03_r8,6.6629e-03_r8,6.5571e-06_r8/)
      kbo(:, 5,58, 2) = (/ &
     &1.1773e-02_r8,1.1514e-02_r8,1.0073e-02_r8,7.2198e-03_r8,7.1478e-06_r8/)
      kbo(:, 1,59, 2) = (/ &
     &6.0678e-03_r8,5.7484e-03_r8,4.7181e-03_r8,3.0625e-03_r8,3.5292e-06_r8/)
      kbo(:, 2,59, 2) = (/ &
     &7.5775e-03_r8,7.1843e-03_r8,5.8871e-03_r8,3.8076e-03_r8,4.1244e-06_r8/)
      kbo(:, 3,59, 2) = (/ &
     &8.9504e-03_r8,8.4793e-03_r8,6.9385e-03_r8,4.4706e-03_r8,4.7056e-06_r8/)
      kbo(:, 4,59, 2) = (/ &
     &1.0202e-02_r8,9.6400e-03_r8,7.8732e-03_r8,5.0416e-03_r8,5.2546e-06_r8/)
      kbo(:, 5,59, 2) = (/ &
     &1.1221e-02_r8,1.0539e-02_r8,8.5853e-03_r8,5.4711e-03_r8,5.7591e-06_r8/)
      kbo(:, 1,13, 3) = (/ &
     &1.3886e+02_r8,1.0424e+02_r8,6.9618e+01_r8,3.4998e+01_r8,6.8908e-02_r8/)
      kbo(:, 2,13, 3) = (/ &
     &1.3847e+02_r8,1.0394e+02_r8,6.9423e+01_r8,3.4905e+01_r8,7.3584e-02_r8/)
      kbo(:, 3,13, 3) = (/ &
     &1.3854e+02_r8,1.0400e+02_r8,6.9461e+01_r8,3.4924e+01_r8,7.8137e-02_r8/)
      kbo(:, 4,13, 3) = (/ &
     &1.4034e+02_r8,1.0534e+02_r8,7.0354e+01_r8,3.5368e+01_r8,8.2835e-02_r8/)
      kbo(:, 5,13, 3) = (/ &
     &1.4333e+02_r8,1.0759e+02_r8,7.1853e+01_r8,3.6116e+01_r8,8.7500e-02_r8/)
      kbo(:, 1,14, 3) = (/ &
     &7.1765e+01_r8,5.3918e+01_r8,3.6073e+01_r8,1.8228e+01_r8,5.9867e-02_r8/)
      kbo(:, 2,14, 3) = (/ &
     &7.1567e+01_r8,5.3771e+01_r8,3.5977e+01_r8,1.8183e+01_r8,6.3947e-02_r8/)
      kbo(:, 3,14, 3) = (/ &
     &7.1902e+01_r8,5.4021e+01_r8,3.6141e+01_r8,1.8266e+01_r8,6.8160e-02_r8/)
      kbo(:, 4,14, 3) = (/ &
     &7.3101e+01_r8,5.4919e+01_r8,3.6739e+01_r8,1.8569e+01_r8,7.2138e-02_r8/)
      kbo(:, 5,14, 3) = (/ &
     &7.4813e+01_r8,5.6202e+01_r8,3.7593e+01_r8,1.8992e+01_r8,7.6299e-02_r8/)
      kbo(:, 1,15, 3) = (/ &
     &3.7762e+01_r8,2.8418e+01_r8,1.9073e+01_r8,9.7323e+00_r8,5.1937e-02_r8/)
      kbo(:, 2,15, 3) = (/ &
     &3.7725e+01_r8,2.8390e+01_r8,1.9057e+01_r8,9.7303e+00_r8,5.5591e-02_r8/)
      kbo(:, 3,15, 3) = (/ &
     &3.8048e+01_r8,2.8634e+01_r8,1.9221e+01_r8,9.8224e+00_r8,5.9263e-02_r8/)
      kbo(:, 4,15, 3) = (/ &
     &3.8784e+01_r8,2.9182e+01_r8,1.9585e+01_r8,1.0010e+01_r8,6.2883e-02_r8/)
      kbo(:, 5,15, 3) = (/ &
     &3.9804e+01_r8,2.9945e+01_r8,2.0089e+01_r8,1.0260e+01_r8,6.6326e-02_r8/)
      kbo(:, 1,16, 3) = (/ &
     &2.3667e+01_r8,1.7845e+01_r8,1.2024e+01_r8,6.2150e+00_r8,4.4961e-02_r8/)
      kbo(:, 2,16, 3) = (/ &
     &2.3710e+01_r8,1.7881e+01_r8,1.2053e+01_r8,6.2413e+00_r8,4.8227e-02_r8/)
      kbo(:, 3,16, 3) = (/ &
     &2.3983e+01_r8,1.8085e+01_r8,1.2193e+01_r8,6.3263e+00_r8,5.1418e-02_r8/)
      kbo(:, 4,16, 3) = (/ &
     &2.4541e+01_r8,1.8499e+01_r8,1.2468e+01_r8,6.4708e+00_r8,5.4587e-02_r8/)
      kbo(:, 5,16, 3) = (/ &
     &2.5247e+01_r8,1.9026e+01_r8,1.2815e+01_r8,6.6457e+00_r8,5.7578e-02_r8/)
      kbo(:, 1,17, 3) = (/ &
     &1.5411e+01_r8,1.1654e+01_r8,7.9029e+00_r8,4.1290e+00_r8,3.8761e-02_r8/)
      kbo(:, 2,17, 3) = (/ &
     &1.5483e+01_r8,1.1712e+01_r8,7.9484e+00_r8,4.1656e+00_r8,4.1564e-02_r8/)
      kbo(:, 3,17, 3) = (/ &
     &1.5715e+01_r8,1.1885e+01_r8,8.0713e+00_r8,4.2451e+00_r8,4.4369e-02_r8/)
      kbo(:, 4,17, 3) = (/ &
     &1.6109e+01_r8,1.2177e+01_r8,8.2663e+00_r8,4.3534e+00_r8,4.7100e-02_r8/)
      kbo(:, 5,17, 3) = (/ &
     &1.6611e+01_r8,1.2551e+01_r8,8.5125e+00_r8,4.4825e+00_r8,4.9594e-02_r8/)
      kbo(:, 1,18, 3) = (/ &
     &1.0325e+01_r8,7.8390e+00_r8,5.3612e+00_r8,2.8294e+00_r8,3.3186e-02_r8/)
      kbo(:, 2,18, 3) = (/ &
     &1.0398e+01_r8,7.8984e+00_r8,5.4111e+00_r8,2.8675e+00_r8,3.5625e-02_r8/)
      kbo(:, 3,18, 3) = (/ &
     &1.0571e+01_r8,8.0297e+00_r8,5.5102e+00_r8,2.9332e+00_r8,3.8042e-02_r8/)
      kbo(:, 4,18, 3) = (/ &
     &1.0854e+01_r8,8.2395e+00_r8,5.6528e+00_r8,3.0140e+00_r8,4.0327e-02_r8/)
      kbo(:, 5,18, 3) = (/ &
     &1.1221e+01_r8,8.5111e+00_r8,5.8333e+00_r8,3.1124e+00_r8,4.2414e-02_r8/)
      kbo(:, 1,19, 3) = (/ &
     &6.8208e+00_r8,5.2153e+00_r8,3.5957e+00_r8,1.9227e+00_r8,2.8261e-02_r8/)
      kbo(:, 2,19, 3) = (/ &
     &6.8751e+00_r8,5.2621e+00_r8,3.6379e+00_r8,1.9560e+00_r8,3.0383e-02_r8/)
      kbo(:, 3,19, 3) = (/ &
     &7.0006e+00_r8,5.3588e+00_r8,3.7145e+00_r8,2.0054e+00_r8,3.2394e-02_r8/)
      kbo(:, 4,19, 3) = (/ &
     &7.2016e+00_r8,5.5069e+00_r8,3.8180e+00_r8,2.0649e+00_r8,3.4293e-02_r8/)
      kbo(:, 5,19, 3) = (/ &
     &7.4662e+00_r8,5.7018e+00_r8,3.9518e+00_r8,2.1403e+00_r8,3.6047e-02_r8/)
      kbo(:, 1,20, 3) = (/ &
     &4.8794e+00_r8,3.7616e+00_r8,2.6099e+00_r8,1.4082e+00_r8,2.4010e-02_r8/)
      kbo(:, 2,20, 3) = (/ &
     &4.9222e+00_r8,3.8008e+00_r8,2.6471e+00_r8,1.4364e+00_r8,2.5795e-02_r8/)
      kbo(:, 3,20, 3) = (/ &
     &5.0241e+00_r8,3.8811e+00_r8,2.7106e+00_r8,1.4758e+00_r8,2.7487e-02_r8/)
      kbo(:, 4,20, 3) = (/ &
     &5.1822e+00_r8,3.9983e+00_r8,2.7942e+00_r8,1.5252e+00_r8,2.9078e-02_r8/)
      kbo(:, 5,20, 3) = (/ &
     &5.3938e+00_r8,4.1543e+00_r8,2.9036e+00_r8,1.5872e+00_r8,3.0457e-02_r8/)
      kbo(:, 1,21, 3) = (/ &
     &3.5976e+00_r8,2.7957e+00_r8,1.9525e+00_r8,1.0602e+00_r8,2.0310e-02_r8/)
      kbo(:, 2,21, 3) = (/ &
     &3.6356e+00_r8,2.8321e+00_r8,1.9867e+00_r8,1.0846e+00_r8,2.1803e-02_r8/)
      kbo(:, 3,21, 3) = (/ &
     &3.7222e+00_r8,2.9011e+00_r8,2.0401e+00_r8,1.1175e+00_r8,2.3227e-02_r8/)
      kbo(:, 4,21, 3) = (/ &
     &3.8497e+00_r8,2.9972e+00_r8,2.1098e+00_r8,1.1593e+00_r8,2.4505e-02_r8/)
      kbo(:, 5,21, 3) = (/ &
     &4.0214e+00_r8,3.1255e+00_r8,2.2004e+00_r8,1.2111e+00_r8,2.5550e-02_r8/)
      kbo(:, 1,22, 3) = (/ &
     &2.7203e+00_r8,2.1314e+00_r8,1.4964e+00_r8,8.1782e-01_r8,1.7205e-02_r8/)
      kbo(:, 2,22, 3) = (/ &
     &2.7584e+00_r8,2.1682e+00_r8,1.5287e+00_r8,8.3963e-01_r8,1.8458e-02_r8/)
      kbo(:, 3,22, 3) = (/ &
     &2.8354e+00_r8,2.2296e+00_r8,1.5749e+00_r8,8.6850e-01_r8,1.9598e-02_r8/)
      kbo(:, 4,22, 3) = (/ &
     &2.9415e+00_r8,2.3111e+00_r8,1.6346e+00_r8,9.0426e-01_r8,2.0559e-02_r8/)
      kbo(:, 5,22, 3) = (/ &
     &3.0867e+00_r8,2.4212e+00_r8,1.7134e+00_r8,9.4960e-01_r8,2.1311e-02_r8/)
      kbo(:, 1,23, 3) = (/ &
     &2.0695e+00_r8,1.6369e+00_r8,1.1532e+00_r8,6.3485e-01_r8,1.4544e-02_r8/)
      kbo(:, 2,23, 3) = (/ &
     &2.1080e+00_r8,1.6730e+00_r8,1.1833e+00_r8,6.5423e-01_r8,1.5557e-02_r8/)
      kbo(:, 3,23, 3) = (/ &
     &2.1745e+00_r8,1.7262e+00_r8,1.2233e+00_r8,6.7947e-01_r8,1.6419e-02_r8/)
      kbo(:, 4,23, 3) = (/ &
     &2.2647e+00_r8,1.7970e+00_r8,1.2752e+00_r8,7.1089e-01_r8,1.7120e-02_r8/)
      kbo(:, 5,23, 3) = (/ &
     &2.3823e+00_r8,1.8879e+00_r8,1.3412e+00_r8,7.4903e-01_r8,1.7674e-02_r8/)
      kbo(:, 1,24, 3) = (/ &
     &1.5697e+00_r8,1.2531e+00_r8,8.8637e-01_r8,4.9139e-01_r8,1.2257e-02_r8/)
      kbo(:, 2,24, 3) = (/ &
     &1.6055e+00_r8,1.2864e+00_r8,9.1332e-01_r8,5.0866e-01_r8,1.3031e-02_r8/)
      kbo(:, 3,24, 3) = (/ &
     &1.6631e+00_r8,1.3329e+00_r8,9.4834e-01_r8,5.3086e-01_r8,1.3670e-02_r8/)
      kbo(:, 4,24, 3) = (/ &
     &1.7374e+00_r8,1.3923e+00_r8,9.9245e-01_r8,5.5764e-01_r8,1.4194e-02_r8/)
      kbo(:, 5,24, 3) = (/ &
     &1.8327e+00_r8,1.4671e+00_r8,1.0467e+00_r8,5.8890e-01_r8,1.4611e-02_r8/)
      kbo(:, 1,25, 3) = (/ &
     &1.2086e+00_r8,9.7309e-01_r8,6.9155e-01_r8,3.8568e-01_r8,1.0281e-02_r8/)
      kbo(:, 2,25, 3) = (/ &
     &1.2420e+00_r8,1.0035e+00_r8,7.1528e-01_r8,4.0109e-01_r8,1.0857e-02_r8/)
      kbo(:, 3,25, 3) = (/ &
     &1.2906e+00_r8,1.0433e+00_r8,7.4566e-01_r8,4.2042e-01_r8,1.1339e-02_r8/)
      kbo(:, 4,25, 3) = (/ &
     &1.3533e+00_r8,1.0941e+00_r8,7.8339e-01_r8,4.4308e-01_r8,1.1737e-02_r8/)
      kbo(:, 5,25, 3) = (/ &
     &1.4315e+00_r8,1.1563e+00_r8,8.2868e-01_r8,4.6855e-01_r8,1.2054e-02_r8/)
      kbo(:, 1,26, 3) = (/ &
     &9.4867e-01_r8,7.6987e-01_r8,5.4929e-01_r8,3.0788e-01_r8,8.5827e-03_r8/)
      kbo(:, 2,26, 3) = (/ &
     &9.7957e-01_r8,7.9721e-01_r8,5.7050e-01_r8,3.2189e-01_r8,9.0225e-03_r8/)
      kbo(:, 3,26, 3) = (/ &
     &1.0209e+00_r8,8.3198e-01_r8,5.9699e-01_r8,3.3862e-01_r8,9.3908e-03_r8/)
      kbo(:, 4,26, 3) = (/ &
     &1.0742e+00_r8,8.7561e-01_r8,6.2951e-01_r8,3.5776e-01_r8,9.6952e-03_r8/)
      kbo(:, 5,26, 3) = (/ &
     &1.1410e+00_r8,9.2907e-01_r8,6.6837e-01_r8,3.7907e-01_r8,9.9345e-03_r8/)
      kbo(:, 1,27, 3) = (/ &
     &7.7558e-01_r8,6.3324e-01_r8,4.5279e-01_r8,2.5468e-01_r8,7.1414e-03_r8/)
      kbo(:, 2,27, 3) = (/ &
     &8.0374e-01_r8,6.5793e-01_r8,4.7219e-01_r8,2.6746e-01_r8,7.4832e-03_r8/)
      kbo(:, 3,27, 3) = (/ &
     &8.4002e-01_r8,6.8874e-01_r8,4.9567e-01_r8,2.8203e-01_r8,7.7674e-03_r8/)
      kbo(:, 4,27, 3) = (/ &
     &8.8798e-01_r8,7.2827e-01_r8,5.2483e-01_r8,2.9866e-01_r8,7.9993e-03_r8/)
      kbo(:, 5,27, 3) = (/ &
     &9.4670e-01_r8,7.7585e-01_r8,5.5890e-01_r8,3.1722e-01_r8,8.1810e-03_r8/)
      kbo(:, 1,28, 3) = (/ &
     &6.5247e-01_r8,5.3505e-01_r8,3.8309e-01_r8,2.1606e-01_r8,5.9313e-03_r8/)
      kbo(:, 2,28, 3) = (/ &
     &6.7805e-01_r8,5.5765e-01_r8,4.0088e-01_r8,2.2763e-01_r8,6.1964e-03_r8/)
      kbo(:, 3,28, 3) = (/ &
     &7.1138e-01_r8,5.8602e-01_r8,4.2234e-01_r8,2.4051e-01_r8,6.4170e-03_r8/)
      kbo(:, 4,28, 3) = (/ &
     &7.5565e-01_r8,6.2271e-01_r8,4.4913e-01_r8,2.5531e-01_r8,6.5956e-03_r8/)
      kbo(:, 5,28, 3) = (/ &
     &8.0810e-01_r8,6.6536e-01_r8,4.7931e-01_r8,2.7186e-01_r8,6.7356e-03_r8/)
      kbo(:, 1,29, 3) = (/ &
     &5.8359e-01_r8,4.7922e-01_r8,3.4299e-01_r8,1.9330e-01_r8,4.9222e-03_r8/)
      kbo(:, 2,29, 3) = (/ &
     &6.0836e-01_r8,5.0105e-01_r8,3.5992e-01_r8,2.0402e-01_r8,5.1279e-03_r8/)
      kbo(:, 3,29, 3) = (/ &
     &6.4169e-01_r8,5.2929e-01_r8,3.8096e-01_r8,2.1613e-01_r8,5.2989e-03_r8/)
      kbo(:, 4,29, 3) = (/ &
     &6.8418e-01_r8,5.6479e-01_r8,4.0659e-01_r8,2.3010e-01_r8,5.4376e-03_r8/)
      kbo(:, 5,29, 3) = (/ &
     &7.3388e-01_r8,6.0487e-01_r8,4.3487e-01_r8,2.4554e-01_r8,5.5459e-03_r8/)
      kbo(:, 1,30, 3) = (/ &
     &5.3559e-01_r8,4.3987e-01_r8,3.1446e-01_r8,1.7681e-01_r8,4.0812e-03_r8/)
      kbo(:, 2,30, 3) = (/ &
     &5.6092e-01_r8,4.6195e-01_r8,3.3123e-01_r8,1.8699e-01_r8,4.2410e-03_r8/)
      kbo(:, 3,30, 3) = (/ &
     &5.9467e-01_r8,4.9061e-01_r8,3.5234e-01_r8,1.9880e-01_r8,4.3756e-03_r8/)
      kbo(:, 4,30, 3) = (/ &
     &6.3620e-01_r8,5.2529e-01_r8,3.7692e-01_r8,2.1218e-01_r8,4.4820e-03_r8/)
      kbo(:, 5,30, 3) = (/ &
     &6.8416e-01_r8,5.6390e-01_r8,4.0420e-01_r8,2.2692e-01_r8,4.5637e-03_r8/)
      kbo(:, 1,31, 3) = (/ &
     &5.1816e-01_r8,4.2464e-01_r8,3.0261e-01_r8,1.6922e-01_r8,3.3825e-03_r8/)
      kbo(:, 2,31, 3) = (/ &
     &5.4536e-01_r8,4.4814e-01_r8,3.2013e-01_r8,1.7945e-01_r8,3.5084e-03_r8/)
      kbo(:, 3,31, 3) = (/ &
     &5.8079e-01_r8,4.7822e-01_r8,3.4203e-01_r8,1.9145e-01_r8,3.6133e-03_r8/)
      kbo(:, 4,31, 3) = (/ &
     &6.2360e-01_r8,5.1355e-01_r8,3.6685e-01_r8,2.0495e-01_r8,3.6964e-03_r8/)
      kbo(:, 5,31, 3) = (/ &
     &6.7136e-01_r8,5.5242e-01_r8,3.9433e-01_r8,2.1968e-01_r8,3.7632e-03_r8/)
      kbo(:, 1,32, 3) = (/ &
     &5.0836e-01_r8,4.1565e-01_r8,2.9513e-01_r8,1.6401e-01_r8,2.8023e-03_r8/)
      kbo(:, 2,32, 3) = (/ &
     &5.3755e-01_r8,4.4081e-01_r8,3.1373e-01_r8,1.7458e-01_r8,2.9031e-03_r8/)
      kbo(:, 3,32, 3) = (/ &
     &5.7518e-01_r8,4.7260e-01_r8,3.3647e-01_r8,1.8685e-01_r8,2.9841e-03_r8/)
      kbo(:, 4,32, 3) = (/ &
     &6.1917e-01_r8,5.0863e-01_r8,3.6188e-01_r8,2.0060e-01_r8,3.0523e-03_r8/)
      kbo(:, 5,32, 3) = (/ &
     &6.6737e-01_r8,5.4799e-01_r8,3.8954e-01_r8,2.1543e-01_r8,3.1032e-03_r8/)
      kbo(:, 1,33, 3) = (/ &
     &5.0907e-01_r8,4.1513e-01_r8,2.9365e-01_r8,1.6205e-01_r8,2.3233e-03_r8/)
      kbo(:, 2,33, 3) = (/ &
     &5.4095e-01_r8,4.4243e-01_r8,3.1363e-01_r8,1.7315e-01_r8,2.4017e-03_r8/)
      kbo(:, 3,33, 3) = (/ &
     &5.8099e-01_r8,4.7617e-01_r8,3.3742e-01_r8,1.8595e-01_r8,2.4676e-03_r8/)
      kbo(:, 4,33, 3) = (/ &
     &6.2648e-01_r8,5.1328e-01_r8,3.6375e-01_r8,2.0009e-01_r8,2.5196e-03_r8/)
      kbo(:, 5,33, 3) = (/ &
     &6.7646e-01_r8,5.5394e-01_r8,3.9218e-01_r8,2.1533e-01_r8,2.5609e-03_r8/)
      kbo(:, 1,34, 3) = (/ &
     &4.9704e-01_r8,4.0480e-01_r8,2.8555e-01_r8,1.5673e-01_r8,1.9225e-03_r8/)
      kbo(:, 2,34, 3) = (/ &
     &5.3069e-01_r8,4.3364e-01_r8,3.0643e-01_r8,1.6807e-01_r8,1.9847e-03_r8/)
      kbo(:, 3,34, 3) = (/ &
     &5.7151e-01_r8,4.6776e-01_r8,3.3046e-01_r8,1.8101e-01_r8,2.0370e-03_r8/)
      kbo(:, 4,34, 3) = (/ &
     &6.1711e-01_r8,5.0510e-01_r8,3.5686e-01_r8,1.9508e-01_r8,2.0801e-03_r8/)
      kbo(:, 5,34, 3) = (/ &
     &6.6746e-01_r8,5.4585e-01_r8,3.8550e-01_r8,2.1045e-01_r8,2.1144e-03_r8/)
      kbo(:, 1,35, 3) = (/ &
     &4.8386e-01_r8,3.9362e-01_r8,2.7689e-01_r8,1.5116e-01_r8,1.5847e-03_r8/)
      kbo(:, 2,35, 3) = (/ &
     &5.1832e-01_r8,4.2323e-01_r8,2.9822e-01_r8,1.6263e-01_r8,1.6362e-03_r8/)
      kbo(:, 3,35, 3) = (/ &
     &5.5929e-01_r8,4.5721e-01_r8,3.2219e-01_r8,1.7550e-01_r8,1.6795e-03_r8/)
      kbo(:, 4,35, 3) = (/ &
     &6.0482e-01_r8,4.9463e-01_r8,3.4852e-01_r8,1.8949e-01_r8,1.7156e-03_r8/)
      kbo(:, 5,35, 3) = (/ &
     &6.5512e-01_r8,5.3534e-01_r8,3.7729e-01_r8,2.0487e-01_r8,1.7410e-03_r8/)
      kbo(:, 1,36, 3) = (/ &
     &4.6553e-01_r8,3.7836e-01_r8,2.6548e-01_r8,1.4421e-01_r8,1.3024e-03_r8/)
      kbo(:, 2,36, 3) = (/ &
     &4.9953e-01_r8,4.0773e-01_r8,2.8657e-01_r8,1.5552e-01_r8,1.3449e-03_r8/)
      kbo(:, 3,36, 3) = (/ &
     &5.3980e-01_r8,4.4109e-01_r8,3.1015e-01_r8,1.6814e-01_r8,1.3813e-03_r8/)
      kbo(:, 4,36, 3) = (/ &
     &5.8461e-01_r8,4.7793e-01_r8,3.3603e-01_r8,1.8187e-01_r8,1.4105e-03_r8/)
      kbo(:, 5,36, 3) = (/ &
     &6.3401e-01_r8,5.1804e-01_r8,3.6447e-01_r8,1.9702e-01_r8,1.4329e-03_r8/)
      kbo(:, 1,37, 3) = (/ &
     &4.3247e-01_r8,3.5136e-01_r8,2.4603e-01_r8,1.3313e-01_r8,1.0644e-03_r8/)
      kbo(:, 2,37, 3) = (/ &
     &4.6409e-01_r8,3.7893e-01_r8,2.6588e-01_r8,1.4378e-01_r8,1.1011e-03_r8/)
      kbo(:, 3,37, 3) = (/ &
     &5.0193e-01_r8,4.1040e-01_r8,2.8814e-01_r8,1.5568e-01_r8,1.1313e-03_r8/)
      kbo(:, 4,37, 3) = (/ &
     &5.4423e-01_r8,4.4538e-01_r8,3.1275e-01_r8,1.6870e-01_r8,1.1563e-03_r8/)
      kbo(:, 5,37, 3) = (/ &
     &5.9125e-01_r8,4.8359e-01_r8,3.3982e-01_r8,1.8310e-01_r8,1.1762e-03_r8/)
      kbo(:, 1,38, 3) = (/ &
     &4.0752e-01_r8,3.3084e-01_r8,2.3116e-01_r8,1.2457e-01_r8,8.6985e-04_r8/)
      kbo(:, 2,38, 3) = (/ &
     &4.3734e-01_r8,3.5701e-01_r8,2.5006e-01_r8,1.3472e-01_r8,9.0011e-04_r8/)
      kbo(:, 3,38, 3) = (/ &
     &4.7342e-01_r8,3.8717e-01_r8,2.7137e-01_r8,1.4611e-01_r8,9.2699e-04_r8/)
      kbo(:, 4,38, 3) = (/ &
     &5.1398e-01_r8,4.2080e-01_r8,2.9507e-01_r8,1.5862e-01_r8,9.4795e-04_r8/)
      kbo(:, 5,38, 3) = (/ &
     &5.5926e-01_r8,4.5769e-01_r8,3.2123e-01_r8,1.7252e-01_r8,9.6539e-04_r8/)
      kbo(:, 1,39, 3) = (/ &
     &3.9286e-01_r8,3.1853e-01_r8,2.2204e-01_r8,1.1910e-01_r8,7.1027e-04_r8/)
      kbo(:, 2,39, 3) = (/ &
     &4.2168e-01_r8,3.4392e-01_r8,2.4040e-01_r8,1.2899e-01_r8,7.3606e-04_r8/)
      kbo(:, 3,39, 3) = (/ &
     &4.5685e-01_r8,3.7344e-01_r8,2.6129e-01_r8,1.4014e-01_r8,7.5956e-04_r8/)
      kbo(:, 4,39, 3) = (/ &
     &4.9667e-01_r8,4.0652e-01_r8,2.8462e-01_r8,1.5245e-01_r8,7.7770e-04_r8/)
      kbo(:, 5,39, 3) = (/ &
     &5.4133e-01_r8,4.4296e-01_r8,3.1045e-01_r8,1.6619e-01_r8,7.9334e-04_r8/)
      kbo(:, 1,40, 3) = (/ &
     &3.5355e-01_r8,2.8669e-01_r8,1.9956e-01_r8,1.0673e-01_r8,5.7721e-04_r8/)
      kbo(:, 2,40, 3) = (/ &
     &3.7907e-01_r8,3.0944e-01_r8,2.1608e-01_r8,1.1569e-01_r8,5.9933e-04_r8/)
      kbo(:, 3,40, 3) = (/ &
     &4.1075e-01_r8,3.3635e-01_r8,2.3514e-01_r8,1.2587e-01_r8,6.1943e-04_r8/)
      kbo(:, 4,40, 3) = (/ &
     &4.4707e-01_r8,3.6668e-01_r8,2.5658e-01_r8,1.3717e-01_r8,6.3526e-04_r8/)
      kbo(:, 5,40, 3) = (/ &
     &4.8803e-01_r8,4.0025e-01_r8,2.8039e-01_r8,1.4981e-01_r8,6.4905e-04_r8/)
      kbo(:, 1,41, 3) = (/ &
     &3.1722e-01_r8,2.5721e-01_r8,1.7878e-01_r8,9.5352e-02_r8,4.6830e-04_r8/)
      kbo(:, 2,41, 3) = (/ &
     &3.3984e-01_r8,2.7762e-01_r8,1.9366e-01_r8,1.0349e-01_r8,4.8763e-04_r8/)
      kbo(:, 3,41, 3) = (/ &
     &3.6801e-01_r8,3.0195e-01_r8,2.1092e-01_r8,1.1268e-01_r8,5.0461e-04_r8/)
      kbo(:, 4,41, 3) = (/ &
     &4.0101e-01_r8,3.2964e-01_r8,2.3053e-01_r8,1.2303e-01_r8,5.1866e-04_r8/)
      kbo(:, 5,41, 3) = (/ &
     &4.3854e-01_r8,3.6057e-01_r8,2.5249e-01_r8,1.3467e-01_r8,5.3060e-04_r8/)
      kbo(:, 1,42, 3) = (/ &
     &2.8780e-01_r8,2.3320e-01_r8,1.6182e-01_r8,8.6050e-02_r8,3.7987e-04_r8/)
      kbo(:, 2,42, 3) = (/ &
     &3.0806e-01_r8,2.5171e-01_r8,1.7535e-01_r8,9.3494e-02_r8,3.9649e-04_r8/)
      kbo(:, 3,42, 3) = (/ &
     &3.3326e-01_r8,2.7383e-01_r8,1.9111e-01_r8,1.0188e-01_r8,4.1103e-04_r8/)
      kbo(:, 4,42, 3) = (/ &
     &3.6352e-01_r8,2.9931e-01_r8,2.0921e-01_r8,1.1145e-01_r8,4.2329e-04_r8/)
      kbo(:, 5,42, 3) = (/ &
     &3.9814e-01_r8,3.2805e-01_r8,2.2962e-01_r8,1.2223e-01_r8,4.3386e-04_r8/)
      kbo(:, 1,43, 3) = (/ &
     &2.6265e-01_r8,2.1245e-01_r8,1.4714e-01_r8,7.7969e-02_r8,3.0714e-04_r8/)
      kbo(:, 2,43, 3) = (/ &
     &2.8068e-01_r8,2.2918e-01_r8,1.5940e-01_r8,8.4750e-02_r8,3.2151e-04_r8/)
      kbo(:, 3,43, 3) = (/ &
     &3.0314e-01_r8,2.4932e-01_r8,1.7384e-01_r8,9.2466e-02_r8,3.3415e-04_r8/)
      kbo(:, 4,43, 3) = (/ &
     &3.3080e-01_r8,2.7269e-01_r8,1.9045e-01_r8,1.0127e-01_r8,3.4470e-04_r8/)
      kbo(:, 5,43, 3) = (/ &
     &3.6272e-01_r8,2.9942e-01_r8,2.0942e-01_r8,1.1129e-01_r8,3.5407e-04_r8/)
      kbo(:, 1,44, 3) = (/ &
     &2.4281e-01_r8,1.9594e-01_r8,1.3540e-01_r8,7.1467e-02_r8,2.4789e-04_r8/)
      kbo(:, 2,44, 3) = (/ &
     &2.5884e-01_r8,2.1103e-01_r8,1.4648e-01_r8,7.7626e-02_r8,2.6014e-04_r8/)
      kbo(:, 3,44, 3) = (/ &
     &2.7897e-01_r8,2.2939e-01_r8,1.5978e-01_r8,8.4794e-02_r8,2.7117e-04_r8/)
      kbo(:, 4,44, 3) = (/ &
     &3.0448e-01_r8,2.5115e-01_r8,1.7522e-01_r8,9.2989e-02_r8,2.8049e-04_r8/)
      kbo(:, 5,44, 3) = (/ &
     &3.3408e-01_r8,2.7612e-01_r8,1.9297e-01_r8,1.0236e-01_r8,2.8861e-04_r8/)
      kbo(:, 1,45, 3) = (/ &
     &2.2924e-01_r8,1.8447e-01_r8,1.2716e-01_r8,6.6832e-02_r8,2.0004e-04_r8/)
      kbo(:, 2,45, 3) = (/ &
     &2.4373e-01_r8,1.9820e-01_r8,1.3728e-01_r8,7.2484e-02_r8,2.1065e-04_r8/)
      kbo(:, 3,45, 3) = (/ &
     &2.6228e-01_r8,2.1536e-01_r8,1.4978e-01_r8,7.9297e-02_r8,2.1996e-04_r8/)
      kbo(:, 4,45, 3) = (/ &
     &2.8578e-01_r8,2.3573e-01_r8,1.6427e-01_r8,8.6976e-02_r8,2.2795e-04_r8/)
      kbo(:, 5,45, 3) = (/ &
     &3.1387e-01_r8,2.5954e-01_r8,1.8123e-01_r8,9.5940e-02_r8,2.3501e-04_r8/)
      kbo(:, 1,46, 3) = (/ &
     &2.1864e-01_r8,1.7537e-01_r8,1.2059e-01_r8,6.3114e-02_r8,1.6106e-04_r8/)
      kbo(:, 2,46, 3) = (/ &
     &2.3164e-01_r8,1.8773e-01_r8,1.2971e-01_r8,6.8234e-02_r8,1.7008e-04_r8/)
      kbo(:, 3,46, 3) = (/ &
     &2.4878e-01_r8,2.0380e-01_r8,1.4148e-01_r8,7.4690e-02_r8,1.7817e-04_r8/)
      kbo(:, 4,46, 3) = (/ &
     &2.7041e-01_r8,2.2298e-01_r8,1.5518e-01_r8,8.1986e-02_r8,1.8514e-04_r8/)
      kbo(:, 5,46, 3) = (/ &
     &2.9717e-01_r8,2.4573e-01_r8,1.7143e-01_r8,9.0585e-02_r8,1.9112e-04_r8/)
      kbo(:, 1,47, 3) = (/ &
     &2.0666e-01_r8,1.6515e-01_r8,1.1329e-01_r8,5.9056e-02_r8,1.2901e-04_r8/)
      kbo(:, 2,47, 3) = (/ &
     &2.1779e-01_r8,1.7589e-01_r8,1.2122e-01_r8,6.3515e-02_r8,1.3680e-04_r8/)
      kbo(:, 3,47, 3) = (/ &
     &2.3320e-01_r8,1.9053e-01_r8,1.3198e-01_r8,6.9466e-02_r8,1.4384e-04_r8/)
      kbo(:, 4,47, 3) = (/ &
     &2.5274e-01_r8,2.0828e-01_r8,1.4478e-01_r8,7.6351e-02_r8,1.4999e-04_r8/)
      kbo(:, 5,47, 3) = (/ &
     &2.7761e-01_r8,2.2954e-01_r8,1.5995e-01_r8,8.4385e-02_r8,1.5514e-04_r8/)
      kbo(:, 1,48, 3) = (/ &
     &2.0159e-01_r8,1.6032e-01_r8,1.0970e-01_r8,5.6945e-02_r8,1.0330e-04_r8/)
      kbo(:, 2,48, 3) = (/ &
     &2.1094e-01_r8,1.6966e-01_r8,1.1661e-01_r8,6.0834e-02_r8,1.0997e-04_r8/)
      kbo(:, 3,48, 3) = (/ &
     &2.2505e-01_r8,1.8313e-01_r8,1.2656e-01_r8,6.6365e-02_r8,1.1606e-04_r8/)
      kbo(:, 4,48, 3) = (/ &
     &2.4321e-01_r8,1.9993e-01_r8,1.3877e-01_r8,7.3027e-02_r8,1.2143e-04_r8/)
      kbo(:, 5,48, 3) = (/ &
     &2.6669e-01_r8,2.2023e-01_r8,1.5323e-01_r8,8.0709e-02_r8,1.2582e-04_r8/)
      kbo(:, 1,49, 3) = (/ &
     &2.0550e-01_r8,1.6255e-01_r8,1.1090e-01_r8,5.7322e-02_r8,8.2624e-05_r8/)
      kbo(:, 2,49, 3) = (/ &
     &2.1330e-01_r8,1.7068e-01_r8,1.1698e-01_r8,6.0751e-02_r8,8.8378e-05_r8/)
      kbo(:, 3,49, 3) = (/ &
     &2.2651e-01_r8,1.8330e-01_r8,1.2630e-01_r8,6.5972e-02_r8,9.3615e-05_r8/)
      kbo(:, 4,49, 3) = (/ &
     &2.4409e-01_r8,1.9975e-01_r8,1.3835e-01_r8,7.2591e-02_r8,9.8246e-05_r8/)
      kbo(:, 5,49, 3) = (/ &
     &2.6685e-01_r8,2.1980e-01_r8,1.5269e-01_r8,8.0258e-02_r8,1.0201e-04_r8/)
      kbo(:, 1,50, 3) = (/ &
     &2.0001e-01_r8,1.5763e-01_r8,1.0735e-01_r8,5.5313e-02_r8,6.6052e-05_r8/)
      kbo(:, 2,50, 3) = (/ &
     &2.0622e-01_r8,1.6433e-01_r8,1.1239e-01_r8,5.8166e-02_r8,7.0964e-05_r8/)
      kbo(:, 3,50, 3) = (/ &
     &2.1782e-01_r8,1.7560e-01_r8,1.2070e-01_r8,6.2821e-02_r8,7.5460e-05_r8/)
      kbo(:, 4,50, 3) = (/ &
     &2.3393e-01_r8,1.9090e-01_r8,1.3196e-01_r8,6.9056e-02_r8,7.9402e-05_r8/)
      kbo(:, 5,50, 3) = (/ &
     &2.5520e-01_r8,2.0998e-01_r8,1.4571e-01_r8,7.6464e-02_r8,8.2692e-05_r8/)
      kbo(:, 1,51, 3) = (/ &
     &1.9065e-01_r8,1.4985e-01_r8,1.0188e-01_r8,5.2372e-02_r8,5.2796e-05_r8/)
      kbo(:, 2,51, 3) = (/ &
     &1.9564e-01_r8,1.5535e-01_r8,1.0604e-01_r8,5.4717e-02_r8,5.6909e-05_r8/)
      kbo(:, 3,51, 3) = (/ &
     &2.0531e-01_r8,1.6500e-01_r8,1.1319e-01_r8,5.8726e-02_r8,6.0736e-05_r8/)
      kbo(:, 4,51, 3) = (/ &
     &2.1974e-01_r8,1.7886e-01_r8,1.2342e-01_r8,6.4424e-02_r8,6.4172e-05_r8/)
      kbo(:, 5,51, 3) = (/ &
     &2.3909e-01_r8,1.9652e-01_r8,1.3622e-01_r8,7.1393e-02_r8,6.6971e-05_r8/)
      kbo(:, 1,52, 3) = (/ &
     &1.8687e-01_r8,1.4652e-01_r8,9.9463e-02_r8,5.1012e-02_r8,4.2174e-05_r8/)
      kbo(:, 2,52, 3) = (/ &
     &1.9141e-01_r8,1.5137e-01_r8,1.0312e-01_r8,5.3053e-02_r8,4.5594e-05_r8/)
      kbo(:, 3,52, 3) = (/ &
     &1.9940e-01_r8,1.5962e-01_r8,1.0927e-01_r8,5.6516e-02_r8,4.8848e-05_r8/)
      kbo(:, 4,52, 3) = (/ &
     &2.1252e-01_r8,1.7228e-01_r8,1.1865e-01_r8,6.1768e-02_r8,5.1771e-05_r8/)
      kbo(:, 5,52, 3) = (/ &
     &2.3051e-01_r8,1.8896e-01_r8,1.3079e-01_r8,6.8431e-02_r8,5.4234e-05_r8/)
      kbo(:, 1,53, 3) = (/ &
     &1.9049e-01_r8,1.4907e-01_r8,1.0107e-01_r8,5.1727e-02_r8,3.3675e-05_r8/)
      kbo(:, 2,53, 3) = (/ &
     &1.9537e-01_r8,1.5387e-01_r8,1.0462e-01_r8,5.3675e-02_r8,3.6498e-05_r8/)
      kbo(:, 3,53, 3) = (/ &
     &2.0221e-01_r8,1.6109e-01_r8,1.1002e-01_r8,5.6715e-02_r8,3.9286e-05_r8/)
      kbo(:, 4,53, 3) = (/ &
     &2.1438e-01_r8,1.7292e-01_r8,1.1878e-01_r8,6.1645e-02_r8,4.1745e-05_r8/)
      kbo(:, 5,53, 3) = (/ &
     &2.3164e-01_r8,1.8913e-01_r8,1.3065e-01_r8,6.8198e-02_r8,4.3903e-05_r8/)
      kbo(:, 1,54, 3) = (/ &
     &1.6750e-01_r8,1.3117e-01_r8,8.8914e-02_r8,4.5482e-02_r8,2.6834e-05_r8/)
      kbo(:, 2,54, 3) = (/ &
     &1.7260e-01_r8,1.3577e-01_r8,9.2225e-02_r8,4.7257e-02_r8,2.9152e-05_r8/)
      kbo(:, 3,54, 3) = (/ &
     &1.7790e-01_r8,1.4144e-01_r8,9.6473e-02_r8,4.9632e-02_r8,3.1487e-05_r8/)
      kbo(:, 4,54, 3) = (/ &
     &1.8750e-01_r8,1.5107e-01_r8,1.0362e-01_r8,5.3663e-02_r8,3.3610e-05_r8/)
      kbo(:, 5,54, 3) = (/ &
     &2.0185e-01_r8,1.6484e-01_r8,1.1376e-01_r8,5.9292e-02_r8,3.5416e-05_r8/)
      kbo(:, 1,55, 3) = (/ &
     &1.3399e-01_r8,1.0522e-01_r8,7.1343e-02_r8,3.6503e-02_r8,2.1364e-05_r8/)
      kbo(:, 2,55, 3) = (/ &
     &1.3914e-01_r8,1.0951e-01_r8,7.4357e-02_r8,3.8080e-02_r8,2.3275e-05_r8/)
      kbo(:, 3,55, 3) = (/ &
     &1.4309e-01_r8,1.1374e-01_r8,7.7519e-02_r8,3.9837e-02_r8,2.5155e-05_r8/)
      kbo(:, 4,55, 3) = (/ &
     &1.4990e-01_r8,1.2087e-01_r8,8.2841e-02_r8,4.2848e-02_r8,2.6955e-05_r8/)
      kbo(:, 5,55, 3) = (/ &
     &1.6076e-01_r8,1.3155e-01_r8,9.0755e-02_r8,4.7259e-02_r8,2.8512e-05_r8/)
      kbo(:, 1,56, 3) = (/ &
     &1.0674e-01_r8,8.4150e-02_r8,5.7088e-02_r8,2.9230e-02_r8,1.7018e-05_r8/)
      kbo(:, 2,56, 3) = (/ &
     &1.1202e-01_r8,8.8284e-02_r8,5.9924e-02_r8,3.0675e-02_r8,1.8552e-05_r8/)
      kbo(:, 3,56, 3) = (/ &
     &1.1522e-01_r8,9.1603e-02_r8,6.2380e-02_r8,3.2028e-02_r8,2.0079e-05_r8/)
      kbo(:, 4,56, 3) = (/ &
     &1.2002e-01_r8,9.6801e-02_r8,6.6273e-02_r8,3.4240e-02_r8,2.1582e-05_r8/)
      kbo(:, 5,56, 3) = (/ &
     &1.2813e-01_r8,1.0499e-01_r8,7.2382e-02_r8,3.7660e-02_r8,2.2972e-05_r8/)
      kbo(:, 1,57, 3) = (/ &
     &8.4657e-02_r8,6.6996e-02_r8,4.5488e-02_r8,2.3320e-02_r8,1.3524e-05_r8/)
      kbo(:, 2,57, 3) = (/ &
     &8.9961e-02_r8,7.1035e-02_r8,4.8219e-02_r8,2.4686e-02_r8,1.4787e-05_r8/)
      kbo(:, 3,57, 3) = (/ &
     &9.2828e-02_r8,7.3808e-02_r8,5.0230e-02_r8,2.5772e-02_r8,1.6030e-05_r8/)
      kbo(:, 4,57, 3) = (/ &
     &9.6271e-02_r8,7.7620e-02_r8,5.3068e-02_r8,2.7385e-02_r8,1.7279e-05_r8/)
      kbo(:, 5,57, 3) = (/ &
     &1.0221e-01_r8,8.3835e-02_r8,5.7725e-02_r8,3.0004e-02_r8,1.8442e-05_r8/)
      kbo(:, 1,58, 3) = (/ &
     &1.7656e-02_r8,1.7150e-02_r8,1.4988e-02_r8,1.0779e-02_r8,1.0747e-05_r8/)
      kbo(:, 2,58, 3) = (/ &
     &1.9015e-02_r8,1.8411e-02_r8,1.6077e-02_r8,1.1536e-02_r8,1.1805e-05_r8/)
      kbo(:, 3,58, 3) = (/ &
     &1.9736e-02_r8,1.9199e-02_r8,1.6794e-02_r8,1.2067e-02_r8,1.2808e-05_r8/)
      kbo(:, 4,58, 3) = (/ &
     &2.0419e-02_r8,2.0127e-02_r8,1.7678e-02_r8,1.2766e-02_r8,1.3807e-05_r8/)
      kbo(:, 5,58, 3) = (/ &
     &2.1547e-02_r8,2.1640e-02_r8,1.9143e-02_r8,1.3925e-02_r8,1.4766e-05_r8/)
      kbo(:, 1,59, 3) = (/ &
     &1.6768e-02_r8,1.5635e-02_r8,1.2738e-02_r8,8.1686e-03_r8,8.6706e-06_r8/)
      kbo(:, 2,59, 3) = (/ &
     &1.8151e-02_r8,1.6868e-02_r8,1.3724e-02_r8,8.7749e-03_r8,9.5360e-06_r8/)
      kbo(:, 3,59, 3) = (/ &
     &1.8900e-02_r8,1.7641e-02_r8,1.4372e-02_r8,9.2015e-03_r8,1.0356e-05_r8/)
      kbo(:, 4,59, 3) = (/ &
     &1.9564e-02_r8,1.8529e-02_r8,1.5159e-02_r8,9.7488e-03_r8,1.1149e-05_r8/)
      kbo(:, 5,59, 3) = (/ &
     &2.0620e-02_r8,1.9962e-02_r8,1.6458e-02_r8,1.0647e-02_r8,1.1905e-05_r8/)
      kbo(:, 1,13, 4) = (/ &
     &2.1586e+02_r8,1.6199e+02_r8,1.0811e+02_r8,5.4245e+01_r8,1.2105e-01_r8/)
      kbo(:, 2,13, 4) = (/ &
     &2.1869e+02_r8,1.6410e+02_r8,1.0952e+02_r8,5.4940e+01_r8,1.2618e-01_r8/)
      kbo(:, 3,13, 4) = (/ &
     &2.2370e+02_r8,1.6786e+02_r8,1.1202e+02_r8,5.6190e+01_r8,1.3118e-01_r8/)
      kbo(:, 4,13, 4) = (/ &
     &2.3070e+02_r8,1.7312e+02_r8,1.1553e+02_r8,5.7947e+01_r8,1.3630e-01_r8/)
      kbo(:, 5,13, 4) = (/ &
     &2.4034e+02_r8,1.8034e+02_r8,1.2035e+02_r8,6.0352e+01_r8,1.4080e-01_r8/)
      kbo(:, 1,14, 4) = (/ &
     &1.1263e+02_r8,8.4567e+01_r8,5.6502e+01_r8,2.8444e+01_r8,1.0638e-01_r8/)
      kbo(:, 2,14, 4) = (/ &
     &1.1465e+02_r8,8.6072e+01_r8,5.7500e+01_r8,2.8941e+01_r8,1.1108e-01_r8/)
      kbo(:, 3,14, 4) = (/ &
     &1.1796e+02_r8,8.8560e+01_r8,5.9161e+01_r8,2.9768e+01_r8,1.1550e-01_r8/)
      kbo(:, 4,14, 4) = (/ &
     &1.2248e+02_r8,9.1950e+01_r8,6.1421e+01_r8,3.0896e+01_r8,1.2021e-01_r8/)
      kbo(:, 5,14, 4) = (/ &
     &1.2816e+02_r8,9.6211e+01_r8,6.4260e+01_r8,3.2312e+01_r8,1.2485e-01_r8/)
      kbo(:, 1,15, 4) = (/ &
     &5.9854e+01_r8,4.4984e+01_r8,3.0119e+01_r8,1.5274e+01_r8,9.2887e-02_r8/)
      kbo(:, 2,15, 4) = (/ &
     &6.1271e+01_r8,4.6045e+01_r8,3.0823e+01_r8,1.5619e+01_r8,9.7129e-02_r8/)
      kbo(:, 3,15, 4) = (/ &
     &6.3412e+01_r8,4.7652e+01_r8,3.1894e+01_r8,1.6144e+01_r8,1.0153e-01_r8/)
      kbo(:, 4,15, 4) = (/ &
     &6.6234e+01_r8,4.9767e+01_r8,3.3302e+01_r8,1.6842e+01_r8,1.0585e-01_r8/)
      kbo(:, 5,15, 4) = (/ &
     &6.9392e+01_r8,5.2133e+01_r8,3.4876e+01_r8,1.7625e+01_r8,1.1025e-01_r8/)
      kbo(:, 1,16, 4) = (/ &
     &3.7898e+01_r8,2.8521e+01_r8,1.9151e+01_r8,9.8246e+00_r8,8.0720e-02_r8/)
      kbo(:, 2,16, 4) = (/ &
     &3.9024e+01_r8,2.9361e+01_r8,1.9706e+01_r8,1.0088e+01_r8,8.4821e-02_r8/)
      kbo(:, 3,16, 4) = (/ &
     &4.0630e+01_r8,3.0565e+01_r8,2.0505e+01_r8,1.0472e+01_r8,8.9056e-02_r8/)
      kbo(:, 4,16, 4) = (/ &
     &4.2559e+01_r8,3.2011e+01_r8,2.1467e+01_r8,1.0943e+01_r8,9.3186e-02_r8/)
      kbo(:, 5,16, 4) = (/ &
     &4.4564e+01_r8,3.3513e+01_r8,2.2465e+01_r8,1.1432e+01_r8,9.7171e-02_r8/)
      kbo(:, 1,17, 4) = (/ &
     &2.4925e+01_r8,1.8792e+01_r8,1.2674e+01_r8,6.6287e+00_r8,6.9974e-02_r8/)
      kbo(:, 2,17, 4) = (/ &
     &2.5814e+01_r8,1.9454e+01_r8,1.3108e+01_r8,6.8325e+00_r8,7.3907e-02_r8/)
      kbo(:, 3,17, 4) = (/ &
     &2.6980e+01_r8,2.0330e+01_r8,1.3687e+01_r8,7.1100e+00_r8,7.7821e-02_r8/)
      kbo(:, 4,17, 4) = (/ &
     &2.8287e+01_r8,2.1307e+01_r8,1.4334e+01_r8,7.4176e+00_r8,8.1565e-02_r8/)
      kbo(:, 5,17, 4) = (/ &
     &2.9635e+01_r8,2.2318e+01_r8,1.5005e+01_r8,7.7402e+00_r8,8.5222e-02_r8/)
      kbo(:, 1,18, 4) = (/ &
     &1.6833e+01_r8,1.2726e+01_r8,8.6533e+00_r8,4.6132e+00_r8,6.0568e-02_r8/)
      kbo(:, 2,18, 4) = (/ &
     &1.7515e+01_r8,1.3234e+01_r8,8.9835e+00_r8,4.7781e+00_r8,6.4137e-02_r8/)
      kbo(:, 3,18, 4) = (/ &
     &1.8359e+01_r8,1.3866e+01_r8,9.3947e+00_r8,4.9795e+00_r8,6.7564e-02_r8/)
      kbo(:, 4,18, 4) = (/ &
     &1.9269e+01_r8,1.4545e+01_r8,9.8365e+00_r8,5.1909e+00_r8,7.0941e-02_r8/)
      kbo(:, 5,18, 4) = (/ &
     &2.0186e+01_r8,1.5233e+01_r8,1.0291e+01_r8,5.4115e+00_r8,7.4160e-02_r8/)
      kbo(:, 1,19, 4) = (/ &
     &1.1200e+01_r8,8.5062e+00_r8,5.8670e+00_r8,3.1832e+00_r8,5.2174e-02_r8/)
      kbo(:, 2,19, 4) = (/ &
     &1.1703e+01_r8,8.8805e+00_r8,6.1092e+00_r8,3.3121e+00_r8,5.5280e-02_r8/)
      kbo(:, 3,19, 4) = (/ &
     &1.2289e+01_r8,9.3153e+00_r8,6.3897e+00_r8,3.4520e+00_r8,5.8298e-02_r8/)
      kbo(:, 4,19, 4) = (/ &
     &1.2879e+01_r8,9.7549e+00_r8,6.6727e+00_r8,3.5951e+00_r8,6.1230e-02_r8/)
      kbo(:, 5,19, 4) = (/ &
     &1.3509e+01_r8,1.0228e+01_r8,6.9797e+00_r8,3.7461e+00_r8,6.3987e-02_r8/)
      kbo(:, 1,20, 4) = (/ &
     &8.1017e+00_r8,6.1940e+00_r8,4.3223e+00_r8,2.3773e+00_r8,4.4725e-02_r8/)
      kbo(:, 2,20, 4) = (/ &
     &8.4816e+00_r8,6.4735e+00_r8,4.5091e+00_r8,2.4775e+00_r8,4.7408e-02_r8/)
      kbo(:, 3,20, 4) = (/ &
     &8.8970e+00_r8,6.7793e+00_r8,4.7079e+00_r8,2.5791e+00_r8,5.0027e-02_r8/)
      kbo(:, 4,20, 4) = (/ &
     &9.3252e+00_r8,7.0958e+00_r8,4.9137e+00_r8,2.6856e+00_r8,5.2539e-02_r8/)
      kbo(:, 5,20, 4) = (/ &
     &9.8057e+00_r8,7.4546e+00_r8,5.1456e+00_r8,2.8027e+00_r8,5.4910e-02_r8/)
      kbo(:, 1,21, 4) = (/ &
     &6.0501e+00_r8,4.6688e+00_r8,3.2884e+00_r8,1.8254e+00_r8,3.8136e-02_r8/)
      kbo(:, 2,21, 4) = (/ &
     &6.3357e+00_r8,4.8779e+00_r8,3.4312e+00_r8,1.9011e+00_r8,4.0441e-02_r8/)
      kbo(:, 3,21, 4) = (/ &
     &6.6449e+00_r8,5.1029e+00_r8,3.5792e+00_r8,1.9785e+00_r8,4.2660e-02_r8/)
      kbo(:, 4,21, 4) = (/ &
     &6.9762e+00_r8,5.3455e+00_r8,3.7404e+00_r8,2.0617e+00_r8,4.4823e-02_r8/)
      kbo(:, 5,21, 4) = (/ &
     &7.3528e+00_r8,5.6235e+00_r8,3.9228e+00_r8,2.1569e+00_r8,4.6872e-02_r8/)
      kbo(:, 1,22, 4) = (/ &
     &4.6404e+00_r8,3.6182e+00_r8,2.5692e+00_r8,1.4322e+00_r8,3.2495e-02_r8/)
      kbo(:, 2,22, 4) = (/ &
     &4.8647e+00_r8,3.7820e+00_r8,2.6806e+00_r8,1.4906e+00_r8,3.4441e-02_r8/)
      kbo(:, 3,22, 4) = (/ &
     &5.1076e+00_r8,3.9577e+00_r8,2.7989e+00_r8,1.5529e+00_r8,3.6349e-02_r8/)
      kbo(:, 4,22, 4) = (/ &
     &5.3767e+00_r8,4.1547e+00_r8,2.9316e+00_r8,1.6226e+00_r8,3.8200e-02_r8/)
      kbo(:, 5,22, 4) = (/ &
     &5.6763e+00_r8,4.3747e+00_r8,3.0789e+00_r8,1.7012e+00_r8,3.9814e-02_r8/)
      kbo(:, 1,23, 4) = (/ &
     &3.5795e+00_r8,2.8211e+00_r8,2.0153e+00_r8,1.1263e+00_r8,2.7571e-02_r8/)
      kbo(:, 2,23, 4) = (/ &
     &3.7577e+00_r8,2.9513e+00_r8,2.1035e+00_r8,1.1732e+00_r8,2.9222e-02_r8/)
      kbo(:, 3,23, 4) = (/ &
     &3.9530e+00_r8,3.0936e+00_r8,2.2016e+00_r8,1.2254e+00_r8,3.0874e-02_r8/)
      kbo(:, 4,23, 4) = (/ &
     &4.1701e+00_r8,3.2524e+00_r8,2.3097e+00_r8,1.2838e+00_r8,3.2339e-02_r8/)
      kbo(:, 5,23, 4) = (/ &
     &4.4121e+00_r8,3.4311e+00_r8,2.4318e+00_r8,1.3490e+00_r8,3.3498e-02_r8/)
      kbo(:, 1,24, 4) = (/ &
     &2.7499e+00_r8,2.1929e+00_r8,1.5716e+00_r8,8.8208e-01_r8,2.3328e-02_r8/)
      kbo(:, 2,24, 4) = (/ &
     &2.8912e+00_r8,2.2961e+00_r8,1.6422e+00_r8,9.2052e-01_r8,2.4747e-02_r8/)
      kbo(:, 3,24, 4) = (/ &
     &3.0489e+00_r8,2.4127e+00_r8,1.7231e+00_r8,9.6426e-01_r8,2.6067e-02_r8/)
      kbo(:, 4,24, 4) = (/ &
     &3.2231e+00_r8,2.5412e+00_r8,1.8120e+00_r8,1.0128e+00_r8,2.7124e-02_r8/)
      kbo(:, 5,24, 4) = (/ &
     &3.4149e+00_r8,2.6844e+00_r8,1.9115e+00_r8,1.0663e+00_r8,2.7906e-02_r8/)
      kbo(:, 1,25, 4) = (/ &
     &2.1432e+00_r8,1.7277e+00_r8,1.2393e+00_r8,6.9912e-01_r8,1.9707e-02_r8/)
      kbo(:, 2,25, 4) = (/ &
     &2.2580e+00_r8,1.8124e+00_r8,1.2983e+00_r8,7.3186e-01_r8,2.0862e-02_r8/)
      kbo(:, 3,25, 4) = (/ &
     &2.3862e+00_r8,1.9090e+00_r8,1.3657e+00_r8,7.6856e-01_r8,2.1834e-02_r8/)
      kbo(:, 4,25, 4) = (/ &
     &2.5268e+00_r8,2.0149e+00_r8,1.4403e+00_r8,8.0968e-01_r8,2.2567e-02_r8/)
      kbo(:, 5,25, 4) = (/ &
     &2.6782e+00_r8,2.1290e+00_r8,1.5196e+00_r8,8.5344e-01_r8,2.3120e-02_r8/)
      kbo(:, 1,26, 4) = (/ &
     &1.7021e+00_r8,1.3844e+00_r8,9.9410e-01_r8,5.6358e-01_r8,1.6610e-02_r8/)
      kbo(:, 2,26, 4) = (/ &
     &1.7967e+00_r8,1.4558e+00_r8,1.0446e+00_r8,5.9163e-01_r8,1.7478e-02_r8/)
      kbo(:, 3,26, 4) = (/ &
     &1.9029e+00_r8,1.5366e+00_r8,1.1015e+00_r8,6.2314e-01_r8,1.8168e-02_r8/)
      kbo(:, 4,26, 4) = (/ &
     &2.0167e+00_r8,1.6240e+00_r8,1.1633e+00_r8,6.5758e-01_r8,1.8695e-02_r8/)
      kbo(:, 5,26, 4) = (/ &
     &2.1386e+00_r8,1.7169e+00_r8,1.2284e+00_r8,6.9400e-01_r8,1.9096e-02_r8/)
      kbo(:, 1,27, 4) = (/ &
     &1.4057e+00_r8,1.1500e+00_r8,8.2663e-01_r8,4.7009e-01_r8,1.3925e-02_r8/)
      kbo(:, 2,27, 4) = (/ &
     &1.4879e+00_r8,1.2132e+00_r8,8.7128e-01_r8,4.9476e-01_r8,1.4552e-02_r8/)
      kbo(:, 3,27, 4) = (/ &
     &1.5769e+00_r8,1.2821e+00_r8,9.2036e-01_r8,5.2229e-01_r8,1.5059e-02_r8/)
      kbo(:, 4,27, 4) = (/ &
     &1.6734e+00_r8,1.3576e+00_r8,9.7388e-01_r8,5.5224e-01_r8,1.5448e-02_r8/)
      kbo(:, 5,27, 4) = (/ &
     &1.7761e+00_r8,1.4364e+00_r8,1.0297e+00_r8,5.8351e-01_r8,1.5741e-02_r8/)
      kbo(:, 1,28, 4) = (/ &
     &1.1944e+00_r8,9.8092e-01_r8,7.0555e-01_r8,4.0148e-01_r8,1.1607e-02_r8/)
      kbo(:, 2,28, 4) = (/ &
     &1.2669e+00_r8,1.0377e+00_r8,7.4577e-01_r8,4.2386e-01_r8,1.2073e-02_r8/)
      kbo(:, 3,28, 4) = (/ &
     &1.3434e+00_r8,1.0982e+00_r8,7.8916e-01_r8,4.4819e-01_r8,1.2454e-02_r8/)
      kbo(:, 4,28, 4) = (/ &
     &1.4276e+00_r8,1.1642e+00_r8,8.3605e-01_r8,4.7463e-01_r8,1.2747e-02_r8/)
      kbo(:, 5,28, 4) = (/ &
     &1.5174e+00_r8,1.2340e+00_r8,8.8572e-01_r8,5.0242e-01_r8,1.2962e-02_r8/)
      kbo(:, 1,29, 4) = (/ &
     &1.0796e+00_r8,8.8738e-01_r8,6.3729e-01_r8,3.6140e-01_r8,9.6469e-03_r8/)
      kbo(:, 2,29, 4) = (/ &
     &1.1462e+00_r8,9.4012e-01_r8,6.7481e-01_r8,3.8241e-01_r8,1.0006e-02_r8/)
      kbo(:, 3,29, 4) = (/ &
     &1.2166e+00_r8,9.9676e-01_r8,7.1549e-01_r8,4.0534e-01_r8,1.0291e-02_r8/)
      kbo(:, 4,29, 4) = (/ &
     &1.2950e+00_r8,1.0580e+00_r8,7.5913e-01_r8,4.2989e-01_r8,1.0512e-02_r8/)
      kbo(:, 5,29, 4) = (/ &
     &1.3796e+00_r8,1.1246e+00_r8,8.0670e-01_r8,4.5638e-01_r8,1.0678e-02_r8/)
      kbo(:, 1,30, 4) = (/ &
     &1.0009e+00_r8,8.2254e-01_r8,5.8934e-01_r8,3.3271e-01_r8,8.0058e-03_r8/)
      kbo(:, 2,30, 4) = (/ &
     &1.0631e+00_r8,8.7256e-01_r8,6.2533e-01_r8,3.5305e-01_r8,8.2800e-03_r8/)
      kbo(:, 3,30, 4) = (/ &
     &1.1308e+00_r8,9.2710e-01_r8,6.6420e-01_r8,3.7481e-01_r8,8.4963e-03_r8/)
      kbo(:, 4,30, 4) = (/ &
     &1.2063e+00_r8,9.8617e-01_r8,7.0646e-01_r8,3.9833e-01_r8,8.6678e-03_r8/)
      kbo(:, 5,30, 4) = (/ &
     &1.2872e+00_r8,1.0507e+00_r8,7.5301e-01_r8,4.2433e-01_r8,8.7939e-03_r8/)
      kbo(:, 1,31, 4) = (/ &
     &9.7660e-01_r8,8.0084e-01_r8,5.7177e-01_r8,3.2070e-01_r8,6.6382e-03_r8/)
      kbo(:, 2,31, 4) = (/ &
     &1.0374e+00_r8,8.5014e-01_r8,6.0734e-01_r8,3.4069e-01_r8,6.8456e-03_r8/)
      kbo(:, 3,31, 4) = (/ &
     &1.1075e+00_r8,9.0581e-01_r8,6.4681e-01_r8,3.6261e-01_r8,7.0127e-03_r8/)
      kbo(:, 4,31, 4) = (/ &
     &1.1834e+00_r8,9.6644e-01_r8,6.9039e-01_r8,3.8675e-01_r8,7.1469e-03_r8/)
      kbo(:, 5,31, 4) = (/ &
     &1.2660e+00_r8,1.0326e+00_r8,7.3825e-01_r8,4.1334e-01_r8,7.2367e-03_r8/)
      kbo(:, 1,32, 4) = (/ &
     &9.6422e-01_r8,7.8878e-01_r8,5.6132e-01_r8,3.1280e-01_r8,5.4958e-03_r8/)
      kbo(:, 2,32, 4) = (/ &
     &1.0268e+00_r8,8.3964e-01_r8,5.9767e-01_r8,3.3295e-01_r8,5.6574e-03_r8/)
      kbo(:, 3,32, 4) = (/ &
     &1.0993e+00_r8,8.9729e-01_r8,6.3870e-01_r8,3.5556e-01_r8,5.7908e-03_r8/)
      kbo(:, 4,32, 4) = (/ &
     &1.1769e+00_r8,9.5960e-01_r8,6.8365e-01_r8,3.8056e-01_r8,5.8892e-03_r8/)
      kbo(:, 5,32, 4) = (/ &
     &1.2618e+00_r8,1.0283e+00_r8,7.3351e-01_r8,4.0808e-01_r8,5.9563e-03_r8/)
      kbo(:, 1,33, 4) = (/ &
     &9.7044e-01_r8,7.9175e-01_r8,5.6148e-01_r8,3.1071e-01_r8,4.5479e-03_r8/)
      kbo(:, 2,33, 4) = (/ &
     &1.0377e+00_r8,8.4609e-01_r8,5.9989e-01_r8,3.3169e-01_r8,4.6770e-03_r8/)
      kbo(:, 3,33, 4) = (/ &
     &1.1127e+00_r8,9.0612e-01_r8,6.4309e-01_r8,3.5556e-01_r8,4.7785e-03_r8/)
      kbo(:, 4,33, 4) = (/ &
     &1.1941e+00_r8,9.7205e-01_r8,6.9062e-01_r8,3.8191e-01_r8,4.8530e-03_r8/)
      kbo(:, 5,33, 4) = (/ &
     &1.2827e+00_r8,1.0440e+00_r8,7.4287e-01_r8,4.1072e-01_r8,4.9022e-03_r8/)
      kbo(:, 1,34, 4) = (/ &
     &9.5216e-01_r8,7.7596e-01_r8,5.4886e-01_r8,3.0190e-01_r8,3.7602e-03_r8/)
      kbo(:, 2,34, 4) = (/ &
     &1.0214e+00_r8,8.3168e-01_r8,5.8836e-01_r8,3.2354e-01_r8,3.8612e-03_r8/)
      kbo(:, 3,34, 4) = (/ &
     &1.0976e+00_r8,8.9321e-01_r8,6.3261e-01_r8,3.4797e-01_r8,3.9398e-03_r8/)
      kbo(:, 4,34, 4) = (/ &
     &1.1802e+00_r8,9.6059e-01_r8,6.8153e-01_r8,3.7517e-01_r8,3.9961e-03_r8/)
      kbo(:, 5,34, 4) = (/ &
     &1.2700e+00_r8,1.0340e+00_r8,7.3462e-01_r8,4.0436e-01_r8,4.0321e-03_r8/)
      kbo(:, 1,35, 4) = (/ &
     &9.3109e-01_r8,7.5807e-01_r8,5.3485e-01_r8,2.9258e-01_r8,3.0990e-03_r8/)
      kbo(:, 2,35, 4) = (/ &
     &1.0014e+00_r8,8.1463e-01_r8,5.7510e-01_r8,3.1470e-01_r8,3.1794e-03_r8/)
      kbo(:, 3,35, 4) = (/ &
     &1.0779e+00_r8,8.7703e-01_r8,6.2017e-01_r8,3.3965e-01_r8,3.2414e-03_r8/)
      kbo(:, 4,35, 4) = (/ &
     &1.1611e+00_r8,9.4542e-01_r8,6.6993e-01_r8,3.6723e-01_r8,3.2866e-03_r8/)
      kbo(:, 5,35, 4) = (/ &
     &1.2524e+00_r8,1.0199e+00_r8,7.2388e-01_r8,3.9699e-01_r8,3.3190e-03_r8/)
      kbo(:, 1,36, 4) = (/ &
     &8.9907e-01_r8,7.3170e-01_r8,5.1516e-01_r8,2.8053e-01_r8,2.5454e-03_r8/)
      kbo(:, 2,36, 4) = (/ &
     &9.6904e-01_r8,7.8811e-01_r8,5.5541e-01_r8,3.0260e-01_r8,2.6116e-03_r8/)
      kbo(:, 3,36, 4) = (/ &
     &1.0454e+00_r8,8.5074e-01_r8,6.0077e-01_r8,3.2780e-01_r8,2.6639e-03_r8/)
      kbo(:, 4,36, 4) = (/ &
     &1.1275e+00_r8,9.1876e-01_r8,6.5041e-01_r8,3.5533e-01_r8,2.7017e-03_r8/)
      kbo(:, 5,36, 4) = (/ &
     &1.2188e+00_r8,9.9337e-01_r8,7.0446e-01_r8,3.8526e-01_r8,2.7298e-03_r8/)
      kbo(:, 1,37, 4) = (/ &
     &8.3748e-01_r8,6.8208e-01_r8,4.7958e-01_r8,2.6026e-01_r8,2.0819e-03_r8/)
      kbo(:, 2,37, 4) = (/ &
     &9.0437e-01_r8,7.3619e-01_r8,5.1822e-01_r8,2.8144e-01_r8,2.1383e-03_r8/)
      kbo(:, 3,37, 4) = (/ &
     &9.7724e-01_r8,7.9645e-01_r8,5.6196e-01_r8,3.0574e-01_r8,2.1835e-03_r8/)
      kbo(:, 4,37, 4) = (/ &
     &1.0560e+00_r8,8.6198e-01_r8,6.0986e-01_r8,3.3246e-01_r8,2.2167e-03_r8/)
      kbo(:, 5,37, 4) = (/ &
     &1.1435e+00_r8,9.3399e-01_r8,6.6218e-01_r8,3.6148e-01_r8,2.2423e-03_r8/)
      kbo(:, 1,38, 4) = (/ &
     &7.9164e-01_r8,6.4489e-01_r8,4.5275e-01_r8,2.4481e-01_r8,1.7033e-03_r8/)
      kbo(:, 2,38, 4) = (/ &
     &8.5631e-01_r8,6.9735e-01_r8,4.9025e-01_r8,2.6537e-01_r8,1.7520e-03_r8/)
      kbo(:, 3,38, 4) = (/ &
     &9.2681e-01_r8,7.5605e-01_r8,5.3294e-01_r8,2.8911e-01_r8,1.7893e-03_r8/)
      kbo(:, 4,38, 4) = (/ &
     &1.0032e+00_r8,8.1986e-01_r8,5.7959e-01_r8,3.1521e-01_r8,1.8197e-03_r8/)
      kbo(:, 5,38, 4) = (/ &
     &1.0885e+00_r8,8.9047e-01_r8,6.3102e-01_r8,3.4379e-01_r8,1.8432e-03_r8/)
      kbo(:, 1,39, 4) = (/ &
     &7.6561e-01_r8,6.2337e-01_r8,4.3685e-01_r8,2.3531e-01_r8,1.3951e-03_r8/)
      kbo(:, 2,39, 4) = (/ &
     &8.2959e-01_r8,6.7544e-01_r8,4.7411e-01_r8,2.5572e-01_r8,1.4362e-03_r8/)
      kbo(:, 3,39, 4) = (/ &
     &8.9955e-01_r8,7.3386e-01_r8,5.1664e-01_r8,2.7941e-01_r8,1.4681e-03_r8/)
      kbo(:, 4,39, 4) = (/ &
     &9.7533e-01_r8,7.9745e-01_r8,5.6319e-01_r8,3.0547e-01_r8,1.4952e-03_r8/)
      kbo(:, 5,39, 4) = (/ &
     &1.0606e+00_r8,8.6829e-01_r8,6.1487e-01_r8,3.3424e-01_r8,1.5163e-03_r8/)
      kbo(:, 1,40, 4) = (/ &
     &6.9042e-01_r8,5.6314e-01_r8,3.9439e-01_r8,2.1202e-01_r8,1.1367e-03_r8/)
      kbo(:, 2,40, 4) = (/ &
     &7.4888e-01_r8,6.1108e-01_r8,4.2878e-01_r8,2.3085e-01_r8,1.1721e-03_r8/)
      kbo(:, 3,40, 4) = (/ &
     &8.1362e-01_r8,6.6539e-01_r8,4.6832e-01_r8,2.5287e-01_r8,1.1998e-03_r8/)
      kbo(:, 4,40, 4) = (/ &
     &8.8373e-01_r8,7.2479e-01_r8,5.1188e-01_r8,2.7730e-01_r8,1.2242e-03_r8/)
      kbo(:, 5,40, 4) = (/ &
     &9.6254e-01_r8,7.9070e-01_r8,5.6015e-01_r8,3.0430e-01_r8,1.2434e-03_r8/)
      kbo(:, 1,41, 4) = (/ &
     &6.2032e-01_r8,5.0688e-01_r8,3.5482e-01_r8,1.9040e-01_r8,9.2546e-04_r8/)
      kbo(:, 2,41, 4) = (/ &
     &6.7393e-01_r8,5.5118e-01_r8,3.8660e-01_r8,2.0779e-01_r8,9.5549e-04_r8/)
      kbo(:, 3,41, 4) = (/ &
     &7.3329e-01_r8,6.0114e-01_r8,4.2302e-01_r8,2.2810e-01_r8,9.8005e-04_r8/)
      kbo(:, 4,41, 4) = (/ &
     &7.9788e-01_r8,6.5636e-01_r8,4.6356e-01_r8,2.5084e-01_r8,1.0016e-03_r8/)
      kbo(:, 5,41, 4) = (/ &
     &8.7082e-01_r8,7.1789e-01_r8,5.0871e-01_r8,2.7615e-01_r8,1.0188e-03_r8/)
      kbo(:, 1,42, 4) = (/ &
     &5.6327e-01_r8,4.6093e-01_r8,3.2241e-01_r8,1.7266e-01_r8,7.5328e-04_r8/)
      kbo(:, 2,42, 4) = (/ &
     &6.1295e-01_r8,5.0232e-01_r8,3.5212e-01_r8,1.8890e-01_r8,7.7877e-04_r8/)
      kbo(:, 3,42, 4) = (/ &
     &6.6777e-01_r8,5.4861e-01_r8,3.8590e-01_r8,2.0776e-01_r8,8.0043e-04_r8/)
      kbo(:, 4,42, 4) = (/ &
     &7.2797e-01_r8,6.0039e-01_r8,4.2397e-01_r8,2.2912e-01_r8,8.1936e-04_r8/)
      kbo(:, 5,42, 4) = (/ &
     &7.9621e-01_r8,6.5839e-01_r8,4.6656e-01_r8,2.5303e-01_r8,8.3483e-04_r8/)
      kbo(:, 1,43, 4) = (/ &
     &5.1362e-01_r8,4.2068e-01_r8,2.9391e-01_r8,1.5704e-01_r8,6.1131e-04_r8/)
      kbo(:, 2,43, 4) = (/ &
     &5.5956e-01_r8,4.5932e-01_r8,3.2171e-01_r8,1.7223e-01_r8,6.3359e-04_r8/)
      kbo(:, 3,43, 4) = (/ &
     &6.1053e-01_r8,5.0241e-01_r8,3.5315e-01_r8,1.8977e-01_r8,6.5237e-04_r8/)
      kbo(:, 4,43, 4) = (/ &
     &6.6664e-01_r8,5.5084e-01_r8,3.8881e-01_r8,2.0981e-01_r8,6.6921e-04_r8/)
      kbo(:, 5,43, 4) = (/ &
     &7.3047e-01_r8,6.0544e-01_r8,4.2894e-01_r8,2.3232e-01_r8,6.8300e-04_r8/)
      kbo(:, 1,44, 4) = (/ &
     &4.7369e-01_r8,3.8803e-01_r8,2.7069e-01_r8,1.4426e-01_r8,4.9540e-04_r8/)
      kbo(:, 2,44, 4) = (/ &
     &5.1629e-01_r8,4.2426e-01_r8,2.9688e-01_r8,1.5856e-01_r8,5.1475e-04_r8/)
      kbo(:, 3,44, 4) = (/ &
     &5.6430e-01_r8,4.6484e-01_r8,3.2640e-01_r8,1.7499e-01_r8,5.3131e-04_r8/)
      kbo(:, 4,44, 4) = (/ &
     &6.1717e-01_r8,5.1049e-01_r8,3.6006e-01_r8,1.9393e-01_r8,5.4642e-04_r8/)
      kbo(:, 5,44, 4) = (/ &
     &6.7746e-01_r8,5.6241e-01_r8,3.9820e-01_r8,2.1537e-01_r8,5.5870e-04_r8/)
      kbo(:, 1,45, 4) = (/ &
     &4.4552e-01_r8,3.6469e-01_r8,2.5398e-01_r8,1.3497e-01_r8,4.0119e-04_r8/)
      kbo(:, 2,45, 4) = (/ &
     &4.8593e-01_r8,3.9940e-01_r8,2.7911e-01_r8,1.4871e-01_r8,4.1803e-04_r8/)
      kbo(:, 3,45, 4) = (/ &
     &5.3210e-01_r8,4.3837e-01_r8,3.0742e-01_r8,1.6436e-01_r8,4.3281e-04_r8/)
      kbo(:, 4,45, 4) = (/ &
     &5.8266e-01_r8,4.8202e-01_r8,3.3961e-01_r8,1.8254e-01_r8,4.4586e-04_r8/)
      kbo(:, 5,45, 4) = (/ &
     &6.4061e-01_r8,5.3215e-01_r8,3.7643e-01_r8,2.0327e-01_r8,4.5687e-04_r8/)
      kbo(:, 1,46, 4) = (/ &
     &4.2249e-01_r8,3.4536e-01_r8,2.4007e-01_r8,1.2719e-01_r8,3.2444e-04_r8/)
      kbo(:, 2,46, 4) = (/ &
     &4.6085e-01_r8,3.7858e-01_r8,2.6416e-01_r8,1.4037e-01_r8,3.3911e-04_r8/)
      kbo(:, 3,46, 4) = (/ &
     &5.0558e-01_r8,4.1641e-01_r8,2.9158e-01_r8,1.5550e-01_r8,3.5210e-04_r8/)
      kbo(:, 4,46, 4) = (/ &
     &5.5446e-01_r8,4.5852e-01_r8,3.2261e-01_r8,1.7296e-01_r8,3.6323e-04_r8/)
      kbo(:, 5,46, 4) = (/ &
     &6.1034e-01_r8,5.0695e-01_r8,3.5817e-01_r8,1.9305e-01_r8,3.7330e-04_r8/)
      kbo(:, 1,47, 4) = (/ &
     &3.9554e-01_r8,3.2291e-01_r8,2.2401e-01_r8,1.1833e-01_r8,2.6160e-04_r8/)
      kbo(:, 2,47, 4) = (/ &
     &4.3146e-01_r8,3.5412e-01_r8,2.4668e-01_r8,1.3078e-01_r8,2.7433e-04_r8/)
      kbo(:, 3,47, 4) = (/ &
     &4.7369e-01_r8,3.9022e-01_r8,2.7284e-01_r8,1.4515e-01_r8,2.8554e-04_r8/)
      kbo(:, 4,47, 4) = (/ &
     &5.2055e-01_r8,4.3044e-01_r8,3.0232e-01_r8,1.6167e-01_r8,2.9527e-04_r8/)
      kbo(:, 5,47, 4) = (/ &
     &5.7336e-01_r8,4.7635e-01_r8,3.3620e-01_r8,1.8084e-01_r8,3.0428e-04_r8/)
      kbo(:, 1,48, 4) = (/ &
     &3.8090e-01_r8,3.1036e-01_r8,2.1482e-01_r8,1.1310e-01_r8,2.1085e-04_r8/)
      kbo(:, 2,48, 4) = (/ &
     &4.1533e-01_r8,3.4019e-01_r8,2.3651e-01_r8,1.2501e-01_r8,2.2180e-04_r8/)
      kbo(:, 3,48, 4) = (/ &
     &4.5614e-01_r8,3.7537e-01_r8,2.6197e-01_r8,1.3898e-01_r8,2.3143e-04_r8/)
      kbo(:, 4,48, 4) = (/ &
     &5.0246e-01_r8,4.1492e-01_r8,2.9081e-01_r8,1.5505e-01_r8,2.3998e-04_r8/)
      kbo(:, 5,48, 4) = (/ &
     &5.5365e-01_r8,4.5945e-01_r8,3.2372e-01_r8,1.7366e-01_r8,2.4799e-04_r8/)
      kbo(:, 1,49, 4) = (/ &
     &3.8223e-01_r8,3.1052e-01_r8,2.1444e-01_r8,1.1246e-01_r8,1.6987e-04_r8/)
      kbo(:, 2,49, 4) = (/ &
     &4.1659e-01_r8,3.4001e-01_r8,2.3576e-01_r8,1.2419e-01_r8,1.7919e-04_r8/)
      kbo(:, 3,49, 4) = (/ &
     &4.5734e-01_r8,3.7525e-01_r8,2.6133e-01_r8,1.3821e-01_r8,1.8743e-04_r8/)
      kbo(:, 4,49, 4) = (/ &
     &5.0487e-01_r8,4.1574e-01_r8,2.9072e-01_r8,1.5448e-01_r8,1.9508e-04_r8/)
      kbo(:, 5,49, 4) = (/ &
     &5.5695e-01_r8,4.6079e-01_r8,3.2385e-01_r8,1.7317e-01_r8,2.0224e-04_r8/)
      kbo(:, 1,50, 4) = (/ &
     &3.6631e-01_r8,2.9712e-01_r8,2.0481e-01_r8,1.0712e-01_r8,1.3672e-04_r8/)
      kbo(:, 2,50, 4) = (/ &
     &3.9879e-01_r8,3.2486e-01_r8,2.2483e-01_r8,1.1811e-01_r8,1.4458e-04_r8/)
      kbo(:, 3,50, 4) = (/ &
     &4.3761e-01_r8,3.5858e-01_r8,2.4934e-01_r8,1.3160e-01_r8,1.5166e-04_r8/)
      kbo(:, 4,50, 4) = (/ &
     &4.8398e-01_r8,3.9821e-01_r8,2.7799e-01_r8,1.4737e-01_r8,1.5830e-04_r8/)
      kbo(:, 5,50, 4) = (/ &
     &5.3499e-01_r8,4.4212e-01_r8,3.1022e-01_r8,1.6549e-01_r8,1.6465e-04_r8/)
      kbo(:, 1,51, 4) = (/ &
     &3.4406e-01_r8,2.7861e-01_r8,1.9179e-01_r8,1.0006e-01_r8,1.0998e-04_r8/)
      kbo(:, 2,51, 4) = (/ &
     &3.7372e-01_r8,3.0420e-01_r8,2.1018e-01_r8,1.1015e-01_r8,1.1652e-04_r8/)
      kbo(:, 3,51, 4) = (/ &
     &4.0998e-01_r8,3.3570e-01_r8,2.3310e-01_r8,1.2281e-01_r8,1.2263e-04_r8/)
      kbo(:, 4,51, 4) = (/ &
     &4.5397e-01_r8,3.7347e-01_r8,2.6041e-01_r8,1.3780e-01_r8,1.2829e-04_r8/)
      kbo(:, 5,51, 4) = (/ &
     &5.0293e-01_r8,4.1560e-01_r8,2.9124e-01_r8,1.5503e-01_r8,1.3386e-04_r8/)
      kbo(:, 1,52, 4) = (/ &
     &3.3305e-01_r8,2.6887e-01_r8,1.8470e-01_r8,9.6116e-02_r8,8.8414e-05_r8/)
      kbo(:, 2,52, 4) = (/ &
     &3.6030e-01_r8,2.9285e-01_r8,2.0201e-01_r8,1.0559e-01_r8,9.3941e-05_r8/)
      kbo(:, 3,52, 4) = (/ &
     &3.9501e-01_r8,3.2288e-01_r8,2.2382e-01_r8,1.1765e-01_r8,9.9142e-05_r8/)
      kbo(:, 4,52, 4) = (/ &
     &4.3753e-01_r8,3.5954e-01_r8,2.5031e-01_r8,1.3217e-01_r8,1.0404e-04_r8/)
      kbo(:, 5,52, 4) = (/ &
     &4.8592e-01_r8,4.0113e-01_r8,2.8062e-01_r8,1.4902e-01_r8,1.0887e-04_r8/)
      kbo(:, 1,53, 4) = (/ &
     &3.3673e-01_r8,2.7062e-01_r8,1.8541e-01_r8,9.6126e-02_r8,7.1043e-05_r8/)
      kbo(:, 2,53, 4) = (/ &
     &3.6211e-01_r8,2.9355e-01_r8,2.0209e-01_r8,1.0535e-01_r8,7.5715e-05_r8/)
      kbo(:, 3,53, 4) = (/ &
     &3.9659e-01_r8,3.2308e-01_r8,2.2347e-01_r8,1.1715e-01_r8,8.0134e-05_r8/)
      kbo(:, 4,53, 4) = (/ &
     &4.3895e-01_r8,3.5976e-01_r8,2.5000e-01_r8,1.3170e-01_r8,8.4354e-05_r8/)
      kbo(:, 5,53, 4) = (/ &
     &4.8875e-01_r8,4.0230e-01_r8,2.8086e-01_r8,1.4875e-01_r8,8.8431e-05_r8/)
      kbo(:, 1,54, 4) = (/ &
     &2.9565e-01_r8,2.3718e-01_r8,1.6225e-01_r8,8.3929e-02_r8,5.7062e-05_r8/)
      kbo(:, 2,54, 4) = (/ &
     &3.1566e-01_r8,2.5610e-01_r8,1.7621e-01_r8,9.1726e-02_r8,6.0930e-05_r8/)
      kbo(:, 3,54, 4) = (/ &
     &3.4501e-01_r8,2.8145e-01_r8,1.9453e-01_r8,1.0184e-01_r8,6.4630e-05_r8/)
      kbo(:, 4,54, 4) = (/ &
     &3.8166e-01_r8,3.1342e-01_r8,2.1772e-01_r8,1.1458e-01_r8,6.8122e-05_r8/)
      kbo(:, 5,54, 4) = (/ &
     &4.2580e-01_r8,3.5139e-01_r8,2.4524e-01_r8,1.2978e-01_r8,7.1556e-05_r8/)
      kbo(:, 1,55, 4) = (/ &
     &2.3763e-01_r8,1.9054e-01_r8,1.3023e-01_r8,6.7270e-02_r8,4.5734e-05_r8/)
      kbo(:, 2,55, 4) = (/ &
     &2.5160e-01_r8,2.0457e-01_r8,1.4076e-01_r8,7.3233e-02_r8,4.8936e-05_r8/)
      kbo(:, 3,55, 4) = (/ &
     &2.7408e-01_r8,2.2452e-01_r8,1.5520e-01_r8,8.1193e-02_r8,5.2040e-05_r8/)
      kbo(:, 4,55, 4) = (/ &
     &3.0302e-01_r8,2.4999e-01_r8,1.7374e-01_r8,9.1409e-02_r8,5.4914e-05_r8/)
      kbo(:, 5,55, 4) = (/ &
     &3.3851e-01_r8,2.8105e-01_r8,1.9629e-01_r8,1.0386e-01_r8,5.7717e-05_r8/)
      kbo(:, 1,56, 4) = (/ &
     &1.9160e-01_r8,1.5340e-01_r8,1.0472e-01_r8,5.4007e-02_r8,3.6625e-05_r8/)
      kbo(:, 2,56, 4) = (/ &
     &2.0095e-01_r8,1.6357e-01_r8,1.1247e-01_r8,5.8467e-02_r8,3.9320e-05_r8/)
      kbo(:, 3,56, 4) = (/ &
     &2.1781e-01_r8,1.7908e-01_r8,1.2379e-01_r8,6.4708e-02_r8,4.1872e-05_r8/)
      kbo(:, 4,56, 4) = (/ &
     &2.4047e-01_r8,1.9929e-01_r8,1.3856e-01_r8,7.2864e-02_r8,4.4297e-05_r8/)
      kbo(:, 5,56, 4) = (/ &
     &2.6886e-01_r8,2.2463e-01_r8,1.5695e-01_r8,8.3003e-02_r8,4.6496e-05_r8/)
      kbo(:, 1,57, 4) = (/ &
     &1.5488e-01_r8,1.2382e-01_r8,8.4407e-02_r8,4.3459e-02_r8,2.9307e-05_r8/)
      kbo(:, 2,57, 4) = (/ &
     &1.6082e-01_r8,1.3093e-01_r8,8.9925e-02_r8,4.6681e-02_r8,3.1559e-05_r8/)
      kbo(:, 3,57, 4) = (/ &
     &1.7312e-01_r8,1.4284e-01_r8,9.8719e-02_r8,5.1558e-02_r8,3.3681e-05_r8/)
      kbo(:, 4,57, 4) = (/ &
     &1.9084e-01_r8,1.5883e-01_r8,1.1043e-01_r8,5.8031e-02_r8,3.5680e-05_r8/)
      kbo(:, 5,57, 4) = (/ &
     &2.1336e-01_r8,1.7931e-01_r8,1.2534e-01_r8,6.6236e-02_r8,3.7524e-05_r8/)
      kbo(:, 1,58, 4) = (/ &
     &3.3087e-02_r8,3.2322e-02_r8,2.8310e-02_r8,2.0395e-02_r8,2.3455e-05_r8/)
      kbo(:, 2,58, 4) = (/ &
     &3.4053e-02_r8,3.3907e-02_r8,2.9921e-02_r8,2.1729e-02_r8,2.5336e-05_r8/)
      kbo(:, 3,58, 4) = (/ &
     &3.6376e-02_r8,3.6839e-02_r8,3.2736e-02_r8,2.3935e-02_r8,2.7095e-05_r8/)
      kbo(:, 4,58, 4) = (/ &
     &4.0009e-02_r8,4.0914e-02_r8,3.6586e-02_r8,2.6918e-02_r8,2.8737e-05_r8/)
      kbo(:, 5,58, 4) = (/ &
     &4.4706e-02_r8,4.6236e-02_r8,4.1585e-02_r8,3.0778e-02_r8,3.0324e-05_r8/)
      kbo(:, 1,59, 4) = (/ &
     &3.1774e-02_r8,2.9779e-02_r8,2.4302e-02_r8,1.5595e-02_r8,1.9010e-05_r8/)
      kbo(:, 2,59, 4) = (/ &
     &3.2644e-02_r8,3.1267e-02_r8,2.5718e-02_r8,1.6636e-02_r8,2.0536e-05_r8/)
      kbo(:, 3,59, 4) = (/ &
     &3.4800e-02_r8,3.4041e-02_r8,2.8207e-02_r8,1.8368e-02_r8,2.1957e-05_r8/)
      kbo(:, 4,59, 4) = (/ &
     &3.8295e-02_r8,3.7946e-02_r8,3.1647e-02_r8,2.0746e-02_r8,2.3288e-05_r8/)
      kbo(:, 5,59, 4) = (/ &
     &4.2857e-02_r8,4.3069e-02_r8,3.6135e-02_r8,2.3842e-02_r8,2.4528e-05_r8/)
      kbo(:, 1,13, 5) = (/ &
     &3.9549e+02_r8,2.9672e+02_r8,1.9794e+02_r8,9.9160e+01_r8,2.1101e-01_r8/)
      kbo(:, 2,13, 5) = (/ &
     &4.0510e+02_r8,3.0393e+02_r8,2.0275e+02_r8,1.0157e+02_r8,2.1805e-01_r8/)
      kbo(:, 3,13, 5) = (/ &
     &4.1502e+02_r8,3.1136e+02_r8,2.0770e+02_r8,1.0405e+02_r8,2.2406e-01_r8/)
      kbo(:, 4,13, 5) = (/ &
     &4.2481e+02_r8,3.1871e+02_r8,2.1261e+02_r8,1.0651e+02_r8,2.2934e-01_r8/)
      kbo(:, 5,13, 5) = (/ &
     &4.3504e+02_r8,3.2638e+02_r8,2.1772e+02_r8,1.0907e+02_r8,2.3453e-01_r8/)
      kbo(:, 1,14, 5) = (/ &
     &2.0979e+02_r8,1.5743e+02_r8,1.0508e+02_r8,5.2736e+01_r8,1.8842e-01_r8/)
      kbo(:, 2,14, 5) = (/ &
     &2.1502e+02_r8,1.6136e+02_r8,1.0770e+02_r8,5.4046e+01_r8,1.9486e-01_r8/)
      kbo(:, 3,14, 5) = (/ &
     &2.2030e+02_r8,1.6532e+02_r8,1.1034e+02_r8,5.5365e+01_r8,2.0050e-01_r8/)
      kbo(:, 4,14, 5) = (/ &
     &2.2600e+02_r8,1.6960e+02_r8,1.1320e+02_r8,5.6802e+01_r8,2.0562e-01_r8/)
      kbo(:, 5,14, 5) = (/ &
     &2.3272e+02_r8,1.7464e+02_r8,1.1657e+02_r8,5.8488e+01_r8,2.1024e-01_r8/)
      kbo(:, 1,15, 5) = (/ &
     &1.1299e+02_r8,8.4842e+01_r8,5.6692e+01_r8,2.8544e+01_r8,1.6706e-01_r8/)
      kbo(:, 2,15, 5) = (/ &
     &1.1594e+02_r8,8.7050e+01_r8,5.8163e+01_r8,2.9281e+01_r8,1.7285e-01_r8/)
      kbo(:, 3,15, 5) = (/ &
     &1.1912e+02_r8,8.9439e+01_r8,5.9757e+01_r8,3.0081e+01_r8,1.7816e-01_r8/)
      kbo(:, 4,15, 5) = (/ &
     &1.2274e+02_r8,9.2159e+01_r8,6.1575e+01_r8,3.0997e+01_r8,1.8306e-01_r8/)
      kbo(:, 5,15, 5) = (/ &
     &1.2711e+02_r8,9.5434e+01_r8,6.3760e+01_r8,3.2089e+01_r8,1.8793e-01_r8/)
      kbo(:, 1,16, 5) = (/ &
     &7.2342e+01_r8,5.4353e+01_r8,3.6365e+01_r8,1.8388e+01_r8,1.4721e-01_r8/)
      kbo(:, 2,16, 5) = (/ &
     &7.4310e+01_r8,5.5827e+01_r8,3.7348e+01_r8,1.8883e+01_r8,1.5241e-01_r8/)
      kbo(:, 3,16, 5) = (/ &
     &7.6651e+01_r8,5.7588e+01_r8,3.8528e+01_r8,1.9478e+01_r8,1.5739e-01_r8/)
      kbo(:, 4,16, 5) = (/ &
     &7.9417e+01_r8,5.9665e+01_r8,3.9914e+01_r8,2.0174e+01_r8,1.6237e-01_r8/)
      kbo(:, 5,16, 5) = (/ &
     &8.2509e+01_r8,6.1984e+01_r8,4.1462e+01_r8,2.0947e+01_r8,1.6729e-01_r8/)
      kbo(:, 1,17, 5) = (/ &
     &4.7912e+01_r8,3.6032e+01_r8,2.4156e+01_r8,1.2312e+01_r8,1.2867e-01_r8/)
      kbo(:, 2,17, 5) = (/ &
     &4.9396e+01_r8,3.7145e+01_r8,2.4898e+01_r8,1.2683e+01_r8,1.3345e-01_r8/)
      kbo(:, 3,17, 5) = (/ &
     &5.1211e+01_r8,3.8509e+01_r8,2.5812e+01_r8,1.3139e+01_r8,1.3833e-01_r8/)
      kbo(:, 4,17, 5) = (/ &
     &5.3243e+01_r8,4.0036e+01_r8,2.6830e+01_r8,1.3649e+01_r8,1.4345e-01_r8/)
      kbo(:, 5,17, 5) = (/ &
     &5.5359e+01_r8,4.1621e+01_r8,2.7887e+01_r8,1.4174e+01_r8,1.4839e-01_r8/)
      kbo(:, 1,18, 5) = (/ &
     &3.2517e+01_r8,2.4486e+01_r8,1.6464e+01_r8,8.5255e+00_r8,1.1175e-01_r8/)
      kbo(:, 2,18, 5) = (/ &
     &3.3702e+01_r8,2.5376e+01_r8,1.7056e+01_r8,8.8105e+00_r8,1.1647e-01_r8/)
      kbo(:, 3,18, 5) = (/ &
     &3.5055e+01_r8,2.6392e+01_r8,1.7736e+01_r8,9.1463e+00_r8,1.2136e-01_r8/)
      kbo(:, 4,18, 5) = (/ &
     &3.6466e+01_r8,2.7452e+01_r8,1.8446e+01_r8,9.5008e+00_r8,1.2627e-01_r8/)
      kbo(:, 5,18, 5) = (/ &
     &3.7955e+01_r8,2.8569e+01_r8,1.9189e+01_r8,9.8619e+00_r8,1.3101e-01_r8/)
      kbo(:, 1,19, 5) = (/ &
     &2.1727e+01_r8,1.6393e+01_r8,1.1086e+01_r8,5.8761e+00_r8,9.6819e-02_r8/)
      kbo(:, 2,19, 5) = (/ &
     &2.2617e+01_r8,1.7062e+01_r8,1.1530e+01_r8,6.0896e+00_r8,1.0144e-01_r8/)
      kbo(:, 3,19, 5) = (/ &
     &2.3543e+01_r8,1.7760e+01_r8,1.1998e+01_r8,6.3260e+00_r8,1.0605e-01_r8/)
      kbo(:, 4,19, 5) = (/ &
     &2.4512e+01_r8,1.8488e+01_r8,1.2483e+01_r8,6.5653e+00_r8,1.1055e-01_r8/)
      kbo(:, 5,19, 5) = (/ &
     &2.5548e+01_r8,1.9265e+01_r8,1.2998e+01_r8,6.8170e+00_r8,1.1478e-01_r8/)
      kbo(:, 1,20, 5) = (/ &
     &1.5756e+01_r8,1.1916e+01_r8,8.1383e+00_r8,4.3914e+00_r8,8.3853e-02_r8/)
      kbo(:, 2,20, 5) = (/ &
     &1.6431e+01_r8,1.2425e+01_r8,8.4724e+00_r8,4.5624e+00_r8,8.8103e-02_r8/)
      kbo(:, 3,20, 5) = (/ &
     &1.7121e+01_r8,1.2945e+01_r8,8.8179e+00_r8,4.7428e+00_r8,9.2252e-02_r8/)
      kbo(:, 4,20, 5) = (/ &
     &1.7848e+01_r8,1.3492e+01_r8,9.1779e+00_r8,4.9264e+00_r8,9.6228e-02_r8/)
      kbo(:, 5,20, 5) = (/ &
     &1.8606e+01_r8,1.4060e+01_r8,9.5528e+00_r8,5.1134e+00_r8,9.9993e-02_r8/)
      kbo(:, 1,21, 5) = (/ &
     &1.1787e+01_r8,8.9459e+00_r8,6.1836e+00_r8,3.3861e+00_r8,7.2353e-02_r8/)
      kbo(:, 2,21, 5) = (/ &
     &1.2303e+01_r8,9.3354e+00_r8,6.4401e+00_r8,3.5254e+00_r8,7.6084e-02_r8/)
      kbo(:, 3,21, 5) = (/ &
     &1.2826e+01_r8,9.7292e+00_r8,6.7034e+00_r8,3.6681e+00_r8,7.9750e-02_r8/)
      kbo(:, 4,21, 5) = (/ &
     &1.3367e+01_r8,1.0136e+01_r8,6.9714e+00_r8,3.8111e+00_r8,8.3233e-02_r8/)
      kbo(:, 5,21, 5) = (/ &
     &1.3957e+01_r8,1.0578e+01_r8,7.2613e+00_r8,3.9589e+00_r8,8.6478e-02_r8/)
      kbo(:, 1,22, 5) = (/ &
     &9.0718e+00_r8,6.9242e+00_r8,4.8361e+00_r8,2.6781e+00_r8,6.2307e-02_r8/)
      kbo(:, 2,22, 5) = (/ &
     &9.4616e+00_r8,7.2180e+00_r8,5.0370e+00_r8,2.7912e+00_r8,6.5577e-02_r8/)
      kbo(:, 3,22, 5) = (/ &
     &9.8598e+00_r8,7.5169e+00_r8,5.2399e+00_r8,2.9065e+00_r8,6.8755e-02_r8/)
      kbo(:, 4,22, 5) = (/ &
     &1.0285e+01_r8,7.8355e+00_r8,5.4531e+00_r8,3.0213e+00_r8,7.1732e-02_r8/)
      kbo(:, 5,22, 5) = (/ &
     &1.0774e+01_r8,8.1994e+00_r8,5.6924e+00_r8,3.1454e+00_r8,7.4544e-02_r8/)
      kbo(:, 1,23, 5) = (/ &
     &7.0162e+00_r8,5.3998e+00_r8,3.8098e+00_r8,2.1262e+00_r8,5.3397e-02_r8/)
      kbo(:, 2,23, 5) = (/ &
     &7.3118e+00_r8,5.6231e+00_r8,3.9665e+00_r8,2.2161e+00_r8,5.6221e-02_r8/)
      kbo(:, 3,23, 5) = (/ &
     &7.6257e+00_r8,5.8582e+00_r8,4.1301e+00_r8,2.3090e+00_r8,5.8902e-02_r8/)
      kbo(:, 4,23, 5) = (/ &
     &7.9740e+00_r8,6.1181e+00_r8,4.3060e+00_r8,2.4033e+00_r8,6.1507e-02_r8/)
      kbo(:, 5,23, 5) = (/ &
     &8.3852e+00_r8,6.4219e+00_r8,4.5083e+00_r8,2.5100e+00_r8,6.3983e-02_r8/)
      kbo(:, 1,24, 5) = (/ &
     &5.3945e+00_r8,4.1959e+00_r8,2.9887e+00_r8,1.6764e+00_r8,4.5562e-02_r8/)
      kbo(:, 2,24, 5) = (/ &
     &5.6263e+00_r8,4.3723e+00_r8,3.1153e+00_r8,1.7491e+00_r8,4.7953e-02_r8/)
      kbo(:, 3,24, 5) = (/ &
     &5.8803e+00_r8,4.5632e+00_r8,3.2505e+00_r8,1.8236e+00_r8,5.0272e-02_r8/)
      kbo(:, 4,24, 5) = (/ &
     &6.1740e+00_r8,4.7820e+00_r8,3.4008e+00_r8,1.9048e+00_r8,5.2561e-02_r8/)
      kbo(:, 5,24, 5) = (/ &
     &6.5136e+00_r8,5.0303e+00_r8,3.5679e+00_r8,1.9952e+00_r8,5.4580e-02_r8/)
      kbo(:, 1,25, 5) = (/ &
     &4.2050e+00_r8,3.3091e+00_r8,2.3724e+00_r8,1.3359e+00_r8,3.8734e-02_r8/)
      kbo(:, 2,25, 5) = (/ &
     &4.3935e+00_r8,3.4537e+00_r8,2.4783e+00_r8,1.3955e+00_r8,4.0785e-02_r8/)
      kbo(:, 3,25, 5) = (/ &
     &4.6090e+00_r8,3.6169e+00_r8,2.5944e+00_r8,1.4600e+00_r8,4.2817e-02_r8/)
      kbo(:, 4,25, 5) = (/ &
     &4.8571e+00_r8,3.8012e+00_r8,2.7227e+00_r8,1.5304e+00_r8,4.4658e-02_r8/)
      kbo(:, 5,25, 5) = (/ &
     &5.1379e+00_r8,4.0071e+00_r8,2.8658e+00_r8,1.6091e+00_r8,4.6106e-02_r8/)
      kbo(:, 1,26, 5) = (/ &
     &3.3393e+00_r8,2.6590e+00_r8,1.9126e+00_r8,1.0812e+00_r8,3.2872e-02_r8/)
      kbo(:, 2,26, 5) = (/ &
     &3.4998e+00_r8,2.7840e+00_r8,2.0042e+00_r8,1.1322e+00_r8,3.4655e-02_r8/)
      kbo(:, 3,26, 5) = (/ &
     &3.6839e+00_r8,2.9244e+00_r8,2.1044e+00_r8,1.1892e+00_r8,3.6289e-02_r8/)
      kbo(:, 4,26, 5) = (/ &
     &3.8971e+00_r8,3.0834e+00_r8,2.2165e+00_r8,1.2514e+00_r8,3.7614e-02_r8/)
      kbo(:, 5,26, 5) = (/ &
     &4.1266e+00_r8,3.2542e+00_r8,2.3379e+00_r8,1.3199e+00_r8,3.8535e-02_r8/)
      kbo(:, 1,27, 5) = (/ &
     &2.7587e+00_r8,2.2186e+00_r8,1.5971e+00_r8,9.0467e-01_r8,2.7863e-02_r8/)
      kbo(:, 2,27, 5) = (/ &
     &2.9012e+00_r8,2.3317e+00_r8,1.6793e+00_r8,9.5148e-01_r8,2.9310e-02_r8/)
      kbo(:, 3,27, 5) = (/ &
     &3.0653e+00_r8,2.4577e+00_r8,1.7694e+00_r8,1.0026e+00_r8,3.0500e-02_r8/)
      kbo(:, 4,27, 5) = (/ &
     &3.2491e+00_r8,2.5968e+00_r8,1.8696e+00_r8,1.0593e+00_r8,3.1389e-02_r8/)
      kbo(:, 5,27, 5) = (/ &
     &3.4443e+00_r8,2.7432e+00_r8,1.9752e+00_r8,1.1204e+00_r8,3.1994e-02_r8/)
      kbo(:, 1,28, 5) = (/ &
     &2.3461e+00_r8,1.9019e+00_r8,1.3684e+00_r8,7.7601e-01_r8,2.3534e-02_r8/)
      kbo(:, 2,28, 5) = (/ &
     &2.4760e+00_r8,2.0059e+00_r8,1.4439e+00_r8,8.1944e-01_r8,2.4611e-02_r8/)
      kbo(:, 3,28, 5) = (/ &
     &2.6235e+00_r8,2.1209e+00_r8,1.5268e+00_r8,8.6687e-01_r8,2.5434e-02_r8/)
      kbo(:, 4,28, 5) = (/ &
     &2.7836e+00_r8,2.2441e+00_r8,1.6160e+00_r8,9.1849e-01_r8,2.6044e-02_r8/)
      kbo(:, 5,28, 5) = (/ &
     &2.9562e+00_r8,2.3753e+00_r8,1.7120e+00_r8,9.7389e-01_r8,2.6449e-02_r8/)
      kbo(:, 1,29, 5) = (/ &
     &2.1229e+00_r8,1.7281e+00_r8,1.2411e+00_r8,7.0258e-01_r8,1.9767e-02_r8/)
      kbo(:, 2,29, 5) = (/ &
     &2.2483e+00_r8,1.8286e+00_r8,1.3142e+00_r8,7.4438e-01_r8,2.0526e-02_r8/)
      kbo(:, 3,29, 5) = (/ &
     &2.3867e+00_r8,1.9376e+00_r8,1.3932e+00_r8,7.8990e-01_r8,2.1121e-02_r8/)
      kbo(:, 4,29, 5) = (/ &
     &2.5370e+00_r8,2.0544e+00_r8,1.4782e+00_r8,8.3936e-01_r8,2.1540e-02_r8/)
      kbo(:, 5,29, 5) = (/ &
     &2.7005e+00_r8,2.1808e+00_r8,1.5709e+00_r8,8.9251e-01_r8,2.1826e-02_r8/)
      kbo(:, 1,30, 5) = (/ &
     &1.9731e+00_r8,1.6098e+00_r8,1.1534e+00_r8,6.5097e-01_r8,1.6498e-02_r8/)
      kbo(:, 2,30, 5) = (/ &
     &2.0958e+00_r8,1.7088e+00_r8,1.2257e+00_r8,6.9208e-01_r8,1.7054e-02_r8/)
      kbo(:, 3,30, 5) = (/ &
     &2.2285e+00_r8,1.8139e+00_r8,1.3022e+00_r8,7.3642e-01_r8,1.7482e-02_r8/)
      kbo(:, 4,30, 5) = (/ &
     &2.3729e+00_r8,1.9280e+00_r8,1.3861e+00_r8,7.8518e-01_r8,1.7790e-02_r8/)
      kbo(:, 5,30, 5) = (/ &
     &2.5353e+00_r8,2.0546e+00_r8,1.4785e+00_r8,8.3767e-01_r8,1.7989e-02_r8/)
      kbo(:, 1,31, 5) = (/ &
     &1.9340e+00_r8,1.5772e+00_r8,1.1264e+00_r8,6.3182e-01_r8,1.3731e-02_r8/)
      kbo(:, 2,31, 5) = (/ &
     &2.0574e+00_r8,1.6773e+00_r8,1.1995e+00_r8,6.7358e-01_r8,1.4152e-02_r8/)
      kbo(:, 3,31, 5) = (/ &
     &2.1914e+00_r8,1.7848e+00_r8,1.2781e+00_r8,7.1915e-01_r8,1.4466e-02_r8/)
      kbo(:, 4,31, 5) = (/ &
     &2.3406e+00_r8,1.9025e+00_r8,1.3648e+00_r8,7.6925e-01_r8,1.4687e-02_r8/)
      kbo(:, 5,31, 5) = (/ &
     &2.5107e+00_r8,2.0354e+00_r8,1.4612e+00_r8,8.2397e-01_r8,1.4843e-02_r8/)
      kbo(:, 1,32, 5) = (/ &
     &1.9204e+00_r8,1.5654e+00_r8,1.1148e+00_r8,6.2147e-01_r8,1.1411e-02_r8/)
      kbo(:, 2,32, 5) = (/ &
     &2.0455e+00_r8,1.6672e+00_r8,1.1895e+00_r8,6.6431e-01_r8,1.1723e-02_r8/)
      kbo(:, 3,32, 5) = (/ &
     &2.1839e+00_r8,1.7785e+00_r8,1.2711e+00_r8,7.1180e-01_r8,1.1953e-02_r8/)
      kbo(:, 4,32, 5) = (/ &
     &2.3424e+00_r8,1.9038e+00_r8,1.3629e+00_r8,7.6419e-01_r8,1.2125e-02_r8/)
      kbo(:, 5,32, 5) = (/ &
     &2.5216e+00_r8,2.0435e+00_r8,1.4643e+00_r8,8.2232e-01_r8,1.2240e-02_r8/)
      kbo(:, 1,33, 5) = (/ &
     &1.9423e+00_r8,1.5823e+00_r8,1.1236e+00_r8,6.2280e-01_r8,9.4667e-03_r8/)
      kbo(:, 2,33, 5) = (/ &
     &2.0728e+00_r8,1.6884e+00_r8,1.2018e+00_r8,6.6778e-01_r8,9.6991e-03_r8/)
      kbo(:, 3,33, 5) = (/ &
     &2.2222e+00_r8,1.8079e+00_r8,1.2892e+00_r8,7.1818e-01_r8,9.8807e-03_r8/)
      kbo(:, 4,33, 5) = (/ &
     &2.3928e+00_r8,1.9430e+00_r8,1.3880e+00_r8,7.7444e-01_r8,1.0013e-02_r8/)
      kbo(:, 5,33, 5) = (/ &
     &2.5873e+00_r8,2.0935e+00_r8,1.4975e+00_r8,8.3717e-01_r8,1.0093e-02_r8/)
      kbo(:, 1,34, 5) = (/ &
     &1.9127e+00_r8,1.5588e+00_r8,1.1053e+00_r8,6.1048e-01_r8,7.8309e-03_r8/)
      kbo(:, 2,34, 5) = (/ &
     &2.0473e+00_r8,1.6687e+00_r8,1.1862e+00_r8,6.5698e-01_r8,8.0168e-03_r8/)
      kbo(:, 3,34, 5) = (/ &
     &2.2050e+00_r8,1.7947e+00_r8,1.2785e+00_r8,7.0977e-01_r8,8.1571e-03_r8/)
      kbo(:, 4,34, 5) = (/ &
     &2.3844e+00_r8,1.9366e+00_r8,1.3818e+00_r8,7.6872e-01_r8,8.2588e-03_r8/)
      kbo(:, 5,34, 5) = (/ &
     &2.5878e+00_r8,2.0945e+00_r8,1.4977e+00_r8,8.3524e-01_r8,8.3102e-03_r8/)
      kbo(:, 1,35, 5) = (/ &
     &1.8762e+00_r8,1.5298e+00_r8,1.0833e+00_r8,5.9624e-01_r8,6.4645e-03_r8/)
      kbo(:, 2,35, 5) = (/ &
     &2.0161e+00_r8,1.6440e+00_r8,1.1673e+00_r8,6.4448e-01_r8,6.6144e-03_r8/)
      kbo(:, 3,35, 5) = (/ &
     &2.1796e+00_r8,1.7750e+00_r8,1.2632e+00_r8,6.9909e-01_r8,6.7276e-03_r8/)
      kbo(:, 4,35, 5) = (/ &
     &2.3668e+00_r8,1.9227e+00_r8,1.3710e+00_r8,7.6090e-01_r8,6.8022e-03_r8/)
      kbo(:, 5,35, 5) = (/ &
     &2.5757e+00_r8,2.0863e+00_r8,1.4915e+00_r8,8.3029e-01_r8,6.8468e-03_r8/)
      kbo(:, 1,36, 5) = (/ &
     &1.8177e+00_r8,1.4833e+00_r8,1.0492e+00_r8,5.7567e-01_r8,5.3254e-03_r8/)
      kbo(:, 2,36, 5) = (/ &
     &1.9605e+00_r8,1.6001e+00_r8,1.1349e+00_r8,6.2477e-01_r8,5.4464e-03_r8/)
      kbo(:, 3,36, 5) = (/ &
     &2.1269e+00_r8,1.7343e+00_r8,1.2332e+00_r8,6.8062e-01_r8,5.5407e-03_r8/)
      kbo(:, 4,36, 5) = (/ &
     &2.3182e+00_r8,1.8849e+00_r8,1.3435e+00_r8,7.4416e-01_r8,5.6019e-03_r8/)
      kbo(:, 5,36, 5) = (/ &
     &2.5291e+00_r8,2.0513e+00_r8,1.4663e+00_r8,8.1509e-01_r8,5.6408e-03_r8/)
      kbo(:, 1,37, 5) = (/ &
     &1.6997e+00_r8,1.3894e+00_r8,9.8190e-01_r8,5.3748e-01_r8,4.3666e-03_r8/)
      kbo(:, 2,37, 5) = (/ &
     &1.8378e+00_r8,1.5030e+00_r8,1.0654e+00_r8,5.8540e-01_r8,4.4691e-03_r8/)
      kbo(:, 3,37, 5) = (/ &
     &1.9994e+00_r8,1.6341e+00_r8,1.1617e+00_r8,6.4019e-01_r8,4.5481e-03_r8/)
      kbo(:, 4,37, 5) = (/ &
     &2.1860e+00_r8,1.7826e+00_r8,1.2707e+00_r8,7.0283e-01_r8,4.6056e-03_r8/)
      kbo(:, 5,37, 5) = (/ &
     &2.3914e+00_r8,1.9456e+00_r8,1.3911e+00_r8,7.7270e-01_r8,4.6416e-03_r8/)
      kbo(:, 1,38, 5) = (/ &
     &1.6123e+00_r8,1.3193e+00_r8,9.3139e-01_r8,5.0849e-01_r8,3.5784e-03_r8/)
      kbo(:, 2,38, 5) = (/ &
     &1.7479e+00_r8,1.4316e+00_r8,1.0139e+00_r8,5.5580e-01_r8,3.6670e-03_r8/)
      kbo(:, 3,38, 5) = (/ &
     &1.9074e+00_r8,1.5615e+00_r8,1.1092e+00_r8,6.1015e-01_r8,3.7371e-03_r8/)
      kbo(:, 4,38, 5) = (/ &
     &2.0911e+00_r8,1.7089e+00_r8,1.2176e+00_r8,6.7256e-01_r8,3.7869e-03_r8/)
      kbo(:, 5,38, 5) = (/ &
     &2.2948e+00_r8,1.8712e+00_r8,1.3379e+00_r8,7.4236e-01_r8,3.8180e-03_r8/)
      kbo(:, 1,39, 5) = (/ &
     &1.5653e+00_r8,1.2809e+00_r8,9.0306e-01_r8,4.9152e-01_r8,2.9339e-03_r8/)
      kbo(:, 2,39, 5) = (/ &
     &1.7011e+00_r8,1.3939e+00_r8,9.8605e-01_r8,5.3903e-01_r8,3.0110e-03_r8/)
      kbo(:, 3,39, 5) = (/ &
     &1.8625e+00_r8,1.5257e+00_r8,1.0827e+00_r8,5.9416e-01_r8,3.0720e-03_r8/)
      kbo(:, 4,39, 5) = (/ &
     &2.0480e+00_r8,1.6749e+00_r8,1.1927e+00_r8,6.5763e-01_r8,3.1176e-03_r8/)
      kbo(:, 5,39, 5) = (/ &
     &2.2545e+00_r8,1.8403e+00_r8,1.3150e+00_r8,7.2854e-01_r8,3.1424e-03_r8/)
      kbo(:, 1,40, 5) = (/ &
     &1.4161e+00_r8,1.1618e+00_r8,8.1883e-01_r8,4.4506e-01_r8,2.3961e-03_r8/)
      kbo(:, 2,40, 5) = (/ &
     &1.5422e+00_r8,1.2675e+00_r8,8.9661e-01_r8,4.8961e-01_r8,2.4634e-03_r8/)
      kbo(:, 3,40, 5) = (/ &
     &1.6929e+00_r8,1.3914e+00_r8,9.8762e-01_r8,5.4178e-01_r8,2.5182e-03_r8/)
      kbo(:, 4,40, 5) = (/ &
     &1.8671e+00_r8,1.5327e+00_r8,1.0918e+00_r8,6.0196e-01_r8,2.5595e-03_r8/)
      kbo(:, 5,40, 5) = (/ &
     &2.0610e+00_r8,1.6900e+00_r8,1.2084e+00_r8,6.6961e-01_r8,2.5831e-03_r8/)
      kbo(:, 1,41, 5) = (/ &
     &1.2765e+00_r8,1.0500e+00_r8,7.3977e-01_r8,4.0158e-01_r8,1.9558e-03_r8/)
      kbo(:, 2,41, 5) = (/ &
     &1.3934e+00_r8,1.1486e+00_r8,8.1252e-01_r8,4.4320e-01_r8,2.0159e-03_r8/)
      kbo(:, 3,41, 5) = (/ &
     &1.5329e+00_r8,1.2644e+00_r8,8.9774e-01_r8,4.9220e-01_r8,2.0644e-03_r8/)
      kbo(:, 4,41, 5) = (/ &
     &1.6957e+00_r8,1.3977e+00_r8,9.9605e-01_r8,5.4916e-01_r8,2.0998e-03_r8/)
      kbo(:, 5,41, 5) = (/ &
     &1.8778e+00_r8,1.5466e+00_r8,1.1067e+00_r8,6.1346e-01_r8,2.1224e-03_r8/)
      kbo(:, 1,42, 5) = (/ &
     &1.1627e+00_r8,9.5841e-01_r8,6.7494e-01_r8,3.6583e-01_r8,1.5975e-03_r8/)
      kbo(:, 2,42, 5) = (/ &
     &1.2723e+00_r8,1.0513e+00_r8,7.4339e-01_r8,4.0496e-01_r8,1.6498e-03_r8/)
      kbo(:, 3,42, 5) = (/ &
     &1.4029e+00_r8,1.1604e+00_r8,8.2397e-01_r8,4.5136e-01_r8,1.6921e-03_r8/)
      kbo(:, 4,42, 5) = (/ &
     &1.5564e+00_r8,1.2873e+00_r8,9.1770e-01_r8,5.0574e-01_r8,1.7229e-03_r8/)
      kbo(:, 5,42, 5) = (/ &
     &1.7292e+00_r8,1.4295e+00_r8,1.0235e+00_r8,5.6732e-01_r8,1.7439e-03_r8/)
      kbo(:, 1,43, 5) = (/ &
     &1.0630e+00_r8,8.7767e-01_r8,6.1763e-01_r8,3.3410e-01_r8,1.3020e-03_r8/)
      kbo(:, 2,43, 5) = (/ &
     &1.1654e+00_r8,9.6474e-01_r8,6.8178e-01_r8,3.7078e-01_r8,1.3472e-03_r8/)
      kbo(:, 3,43, 5) = (/ &
     &1.2879e+00_r8,1.0676e+00_r8,7.5775e-01_r8,4.1456e-01_r8,1.3843e-03_r8/)
      kbo(:, 4,43, 5) = (/ &
     &1.4323e+00_r8,1.1883e+00_r8,8.4702e-01_r8,4.6628e-01_r8,1.4122e-03_r8/)
      kbo(:, 5,43, 5) = (/ &
     &1.5961e+00_r8,1.3241e+00_r8,9.4813e-01_r8,5.2525e-01_r8,1.4316e-03_r8/)
      kbo(:, 1,44, 5) = (/ &
     &9.8265e-01_r8,8.1189e-01_r8,5.7078e-01_r8,3.0805e-01_r8,1.0595e-03_r8/)
      kbo(:, 2,44, 5) = (/ &
     &1.0790e+00_r8,8.9402e-01_r8,6.3105e-01_r8,3.4248e-01_r8,1.0984e-03_r8/)
      kbo(:, 3,44, 5) = (/ &
     &1.1944e+00_r8,9.9169e-01_r8,7.0312e-01_r8,3.8396e-01_r8,1.1318e-03_r8/)
      kbo(:, 4,44, 5) = (/ &
     &1.3318e+00_r8,1.1077e+00_r8,7.8899e-01_r8,4.3356e-01_r8,1.1566e-03_r8/)
      kbo(:, 5,44, 5) = (/ &
     &1.4887e+00_r8,1.2383e+00_r8,8.8644e-01_r8,4.9053e-01_r8,1.1752e-03_r8/)
      kbo(:, 1,45, 5) = (/ &
     &9.2676e-01_r8,7.6543e-01_r8,5.3731e-01_r8,2.8917e-01_r8,8.6207e-04_r8/)
      kbo(:, 2,45, 5) = (/ &
     &1.0188e+00_r8,8.4420e-01_r8,5.9503e-01_r8,3.2211e-01_r8,8.9589e-04_r8/)
      kbo(:, 3,45, 5) = (/ &
     &1.1295e+00_r8,9.3840e-01_r8,6.6449e-01_r8,3.6207e-01_r8,9.2491e-04_r8/)
      kbo(:, 4,45, 5) = (/ &
     &1.2624e+00_r8,1.0512e+00_r8,7.4797e-01_r8,4.1011e-01_r8,9.4724e-04_r8/)
      kbo(:, 5,45, 5) = (/ &
     &1.4159e+00_r8,1.1794e+00_r8,8.4359e-01_r8,4.6598e-01_r8,9.6431e-04_r8/)
      kbo(:, 1,46, 5) = (/ &
     &8.8115e-01_r8,7.2712e-01_r8,5.0946e-01_r8,2.7333e-01_r8,7.0044e-04_r8/)
      kbo(:, 2,46, 5) = (/ &
     &9.6873e-01_r8,8.0252e-01_r8,5.6477e-01_r8,3.0486e-01_r8,7.2940e-04_r8/)
      kbo(:, 3,46, 5) = (/ &
     &1.0759e+00_r8,8.9393e-01_r8,6.3210e-01_r8,3.4344e-01_r8,7.5456e-04_r8/)
      kbo(:, 4,46, 5) = (/ &
     &1.2051e+00_r8,1.0038e+00_r8,7.1323e-01_r8,3.9017e-01_r8,7.7543e-04_r8/)
      kbo(:, 5,46, 5) = (/ &
     &1.3559e+00_r8,1.1306e+00_r8,8.0761e-01_r8,4.4513e-01_r8,7.9123e-04_r8/)
      kbo(:, 1,47, 5) = (/ &
     &8.2708e-01_r8,6.8179e-01_r8,4.7670e-01_r8,2.5496e-01_r8,5.6723e-04_r8/)
      kbo(:, 2,47, 5) = (/ &
     &9.0841e-01_r8,7.5254e-01_r8,5.2877e-01_r8,2.8459e-01_r8,5.9237e-04_r8/)
      kbo(:, 3,47, 5) = (/ &
     &1.0102e+00_r8,8.3938e-01_r8,5.9264e-01_r8,3.2108e-01_r8,6.1461e-04_r8/)
      kbo(:, 4,47, 5) = (/ &
     &1.1336e+00_r8,9.4433e-01_r8,6.7005e-01_r8,3.6564e-01_r8,6.3367e-04_r8/)
      kbo(:, 5,47, 5) = (/ &
     &1.2789e+00_r8,1.0675e+00_r8,7.6147e-01_r8,4.1873e-01_r8,6.4826e-04_r8/)
      kbo(:, 1,48, 5) = (/ &
     &7.9882e-01_r8,6.5670e-01_r8,4.5801e-01_r8,2.4404e-01_r8,4.5910e-04_r8/)
      kbo(:, 2,48, 5) = (/ &
     &8.7602e-01_r8,7.2469e-01_r8,5.0814e-01_r8,2.7259e-01_r8,4.8082e-04_r8/)
      kbo(:, 3,48, 5) = (/ &
     &9.7485e-01_r8,8.0906e-01_r8,5.6998e-01_r8,3.0783e-01_r8,5.0059e-04_r8/)
      kbo(:, 4,48, 5) = (/ &
     &1.0951e+00_r8,9.1136e-01_r8,6.4533e-01_r8,3.5105e-01_r8,5.1769e-04_r8/)
      kbo(:, 5,48, 5) = (/ &
     &1.2389e+00_r8,1.0335e+00_r8,7.3563e-01_r8,4.0331e-01_r8,5.3087e-04_r8/)
      kbo(:, 1,49, 5) = (/ &
     &8.0402e-01_r8,6.5823e-01_r8,4.5761e-01_r8,2.4276e-01_r8,3.7137e-04_r8/)
      kbo(:, 2,49, 5) = (/ &
     &8.8031e-01_r8,7.2577e-01_r8,5.0751e-01_r8,2.7123e-01_r8,3.9017e-04_r8/)
      kbo(:, 3,49, 5) = (/ &
     &9.7946e-01_r8,8.1065e-01_r8,5.6941e-01_r8,3.0628e-01_r8,4.0777e-04_r8/)
      kbo(:, 4,49, 5) = (/ &
     &1.1011e+00_r8,9.1410e-01_r8,6.4521e-01_r8,3.4961e-01_r8,4.2272e-04_r8/)
      kbo(:, 5,49, 5) = (/ &
     &1.2484e+00_r8,1.0389e+00_r8,7.3730e-01_r8,4.0277e-01_r8,4.3479e-04_r8/)
      kbo(:, 1,50, 5) = (/ &
     &7.7254e-01_r8,6.3104e-01_r8,4.3765e-01_r8,2.3137e-01_r8,3.0017e-04_r8/)
      kbo(:, 2,50, 5) = (/ &
     &8.4478e-01_r8,6.9541e-01_r8,4.8529e-01_r8,2.5862e-01_r8,3.1617e-04_r8/)
      kbo(:, 3,50, 5) = (/ &
     &9.3925e-01_r8,7.7679e-01_r8,5.4465e-01_r8,2.9213e-01_r8,3.3160e-04_r8/)
      kbo(:, 4,50, 5) = (/ &
     &1.0567e+00_r8,8.7678e-01_r8,6.1788e-01_r8,3.3395e-01_r8,3.4487e-04_r8/)
      kbo(:, 5,50, 5) = (/ &
     &1.2008e+00_r8,9.9924e-01_r8,7.0798e-01_r8,3.8577e-01_r8,3.5577e-04_r8/)
      kbo(:, 1,51, 5) = (/ &
     &7.2669e-01_r8,5.9284e-01_r8,4.1030e-01_r8,2.1627e-01_r8,2.4246e-04_r8/)
      kbo(:, 2,51, 5) = (/ &
     &7.9410e-01_r8,6.5300e-01_r8,4.5497e-01_r8,2.4184e-01_r8,2.5602e-04_r8/)
      kbo(:, 3,51, 5) = (/ &
     &8.8167e-01_r8,7.2916e-01_r8,5.1056e-01_r8,2.7327e-01_r8,2.6933e-04_r8/)
      kbo(:, 4,51, 5) = (/ &
     &9.9265e-01_r8,8.2410e-01_r8,5.8011e-01_r8,3.1286e-01_r8,2.8099e-04_r8/)
      kbo(:, 5,51, 5) = (/ &
     &1.1303e+00_r8,9.4117e-01_r8,6.6603e-01_r8,3.6222e-01_r8,2.9075e-04_r8/)
      kbo(:, 1,52, 5) = (/ &
     &7.0293e-01_r8,5.7224e-01_r8,3.9526e-01_r8,2.0761e-01_r8,1.9566e-04_r8/)
      kbo(:, 2,52, 5) = (/ &
     &7.6814e-01_r8,6.3021e-01_r8,4.3806e-01_r8,2.3215e-01_r8,2.0717e-04_r8/)
      kbo(:, 3,52, 5) = (/ &
     &8.5099e-01_r8,7.0282e-01_r8,4.9133e-01_r8,2.6231e-01_r8,2.1874e-04_r8/)
      kbo(:, 4,52, 5) = (/ &
     &9.5857e-01_r8,7.9517e-01_r8,5.5876e-01_r8,3.0061e-01_r8,2.2893e-04_r8/)
      kbo(:, 5,52, 5) = (/ &
     &1.0928e+00_r8,9.0923e-01_r8,6.4230e-01_r8,3.4850e-01_r8,2.3751e-04_r8/)
      kbo(:, 1,53, 5) = (/ &
     &7.0799e-01_r8,5.7451e-01_r8,3.9589e-01_r8,2.0725e-01_r8,1.5775e-04_r8/)
      kbo(:, 2,53, 5) = (/ &
     &7.7421e-01_r8,6.3284e-01_r8,4.3870e-01_r8,2.3160e-01_r8,1.6771e-04_r8/)
      kbo(:, 3,53, 5) = (/ &
     &8.5551e-01_r8,7.0456e-01_r8,4.9136e-01_r8,2.6152e-01_r8,1.7761e-04_r8/)
      kbo(:, 4,53, 5) = (/ &
     &9.6362e-01_r8,7.9737e-01_r8,5.5891e-01_r8,2.9974e-01_r8,1.8647e-04_r8/)
      kbo(:, 5,53, 5) = (/ &
     &1.0993e+00_r8,9.1246e-01_r8,6.4296e-01_r8,3.4771e-01_r8,1.9425e-04_r8/)
      kbo(:, 1,54, 5) = (/ &
     &6.1781e-01_r8,5.0174e-01_r8,3.4551e-01_r8,1.8062e-01_r8,1.2698e-04_r8/)
      kbo(:, 2,54, 5) = (/ &
     &6.7617e-01_r8,5.5332e-01_r8,3.8324e-01_r8,2.0204e-01_r8,1.3548e-04_r8/)
      kbo(:, 3,54, 5) = (/ &
     &7.4609e-01_r8,6.1568e-01_r8,4.2927e-01_r8,2.2831e-01_r8,1.4360e-04_r8/)
      kbo(:, 4,54, 5) = (/ &
     &8.3975e-01_r8,6.9703e-01_r8,4.8868e-01_r8,2.6191e-01_r8,1.5134e-04_r8/)
      kbo(:, 5,54, 5) = (/ &
     &9.5851e-01_r8,7.9875e-01_r8,5.6310e-01_r8,3.0440e-01_r8,1.5803e-04_r8/)
      kbo(:, 1,55, 5) = (/ &
     &4.9218e-01_r8,4.0097e-01_r8,2.7614e-01_r8,1.4430e-01_r8,1.0197e-04_r8/)
      kbo(:, 2,55, 5) = (/ &
     &5.3911e-01_r8,4.4293e-01_r8,3.0686e-01_r8,1.6168e-01_r8,1.0930e-04_r8/)
      kbo(:, 3,55, 5) = (/ &
     &5.9446e-01_r8,4.9291e-01_r8,3.4401e-01_r8,1.8302e-01_r8,1.1592e-04_r8/)
      kbo(:, 4,55, 5) = (/ &
     &6.6816e-01_r8,5.5826e-01_r8,3.9205e-01_r8,2.1030e-01_r8,1.2249e-04_r8/)
      kbo(:, 5,55, 5) = (/ &
     &7.6300e-01_r8,6.4076e-01_r8,4.5273e-01_r8,2.4510e-01_r8,1.2815e-04_r8/)
      kbo(:, 1,56, 5) = (/ &
     &3.9213e-01_r8,3.2040e-01_r8,2.2062e-01_r8,1.1519e-01_r8,8.1886e-05_r8/)
      kbo(:, 2,56, 5) = (/ &
     &4.2970e-01_r8,3.5433e-01_r8,2.4555e-01_r8,1.2928e-01_r8,8.8029e-05_r8/)
      kbo(:, 3,56, 5) = (/ &
     &4.7372e-01_r8,3.9458e-01_r8,2.7557e-01_r8,1.4657e-01_r8,9.3592e-05_r8/)
      kbo(:, 4,56, 5) = (/ &
     &5.3136e-01_r8,4.4682e-01_r8,3.1425e-01_r8,1.6867e-01_r8,9.8924e-05_r8/)
      kbo(:, 5,56, 5) = (/ &
     &6.0680e-01_r8,5.1356e-01_r8,3.6377e-01_r8,1.9714e-01_r8,1.0388e-04_r8/)
      kbo(:, 1,57, 5) = (/ &
     &3.1256e-01_r8,2.5603e-01_r8,1.7627e-01_r8,9.1926e-02_r8,6.5686e-05_r8/)
      kbo(:, 2,57, 5) = (/ &
     &3.4230e-01_r8,2.8322e-01_r8,1.9630e-01_r8,1.0325e-01_r8,7.0810e-05_r8/)
      kbo(:, 3,57, 5) = (/ &
     &3.7748e-01_r8,3.1574e-01_r8,2.2058e-01_r8,1.1723e-01_r8,7.5533e-05_r8/)
      kbo(:, 4,57, 5) = (/ &
     &4.2229e-01_r8,3.5725e-01_r8,2.5162e-01_r8,1.3506e-01_r8,7.9907e-05_r8/)
      kbo(:, 5,57, 5) = (/ &
     &4.8209e-01_r8,4.1127e-01_r8,2.9188e-01_r8,1.5833e-01_r8,8.4096e-05_r8/)
      kbo(:, 1,58, 5) = (/ &
     &6.5834e-02_r8,6.6132e-02_r8,5.8548e-02_r8,4.2734e-02_r8,5.2667e-05_r8/)
      kbo(:, 2,58, 5) = (/ &
     &7.1968e-02_r8,7.3109e-02_r8,6.5197e-02_r8,4.8002e-02_r8,5.6984e-05_r8/)
      kbo(:, 3,58, 5) = (/ &
     &7.9437e-02_r8,8.1656e-02_r8,7.3428e-02_r8,5.4631e-02_r8,6.0874e-05_r8/)
      kbo(:, 4,58, 5) = (/ &
     &8.8662e-02_r8,9.2383e-02_r8,8.3809e-02_r8,6.3035e-02_r8,6.4619e-05_r8/)
      kbo(:, 5,58, 5) = (/ &
     &1.0118e-01_r8,1.0653e-01_r8,9.7458e-02_r8,7.4110e-02_r8,6.7988e-05_r8/)
      kbo(:, 1,59, 5) = (/ &
     &6.3055e-02_r8,6.1069e-02_r8,5.0451e-02_r8,3.2825e-02_r8,4.2796e-05_r8/)
      kbo(:, 2,59, 5) = (/ &
     &6.8995e-02_r8,6.7782e-02_r8,5.6462e-02_r8,3.7059e-02_r8,4.6289e-05_r8/)
      kbo(:, 3,59, 5) = (/ &
     &7.6280e-02_r8,7.6111e-02_r8,6.4009e-02_r8,4.2464e-02_r8,4.9459e-05_r8/)
      kbo(:, 4,59, 5) = (/ &
     &8.5284e-02_r8,8.6606e-02_r8,7.3583e-02_r8,4.9384e-02_r8,5.2442e-05_r8/)
      kbo(:, 5,59, 5) = (/ &
     &9.7585e-02_r8,1.0050e-01_r8,8.6230e-02_r8,5.8574e-02_r8,5.5198e-05_r8/)
      kbo(:, 1,13, 6) = (/ &
     &7.7180e+02_r8,5.7896e+02_r8,3.8611e+02_r8,1.9327e+02_r8,3.6289e-01_r8/)
      kbo(:, 2,13, 6) = (/ &
     &7.9285e+02_r8,5.9474e+02_r8,3.9664e+02_r8,1.9853e+02_r8,3.7298e-01_r8/)
      kbo(:, 3,13, 6) = (/ &
     &8.1518e+02_r8,6.1149e+02_r8,4.0780e+02_r8,2.0411e+02_r8,3.8121e-01_r8/)
      kbo(:, 4,13, 6) = (/ &
     &8.3776e+02_r8,6.2842e+02_r8,4.1908e+02_r8,2.0974e+02_r8,3.8734e-01_r8/)
      kbo(:, 5,13, 6) = (/ &
     &8.6087e+02_r8,6.4575e+02_r8,4.3063e+02_r8,2.1551e+02_r8,3.9230e-01_r8/)
      kbo(:, 1,14, 6) = (/ &
     &4.1395e+02_r8,3.1056e+02_r8,2.0718e+02_r8,1.0380e+02_r8,3.3381e-01_r8/)
      kbo(:, 2,14, 6) = (/ &
     &4.2539e+02_r8,3.1915e+02_r8,2.1290e+02_r8,1.0666e+02_r8,3.4169e-01_r8/)
      kbo(:, 3,14, 6) = (/ &
     &4.3723e+02_r8,3.2803e+02_r8,2.1882e+02_r8,1.0962e+02_r8,3.4947e-01_r8/)
      kbo(:, 4,14, 6) = (/ &
     &4.4927e+02_r8,3.3705e+02_r8,2.2483e+02_r8,1.1261e+02_r8,3.5567e-01_r8/)
      kbo(:, 5,14, 6) = (/ &
     &4.6195e+02_r8,3.4656e+02_r8,2.3117e+02_r8,1.1578e+02_r8,3.6065e-01_r8/)
      kbo(:, 1,15, 6) = (/ &
     &2.2585e+02_r8,1.6949e+02_r8,1.1313e+02_r8,5.6770e+01_r8,3.0356e-01_r8/)
      kbo(:, 2,15, 6) = (/ &
     &2.3201e+02_r8,1.7411e+02_r8,1.1621e+02_r8,5.8311e+01_r8,3.1091e-01_r8/)
      kbo(:, 3,15, 6) = (/ &
     &2.3839e+02_r8,1.7889e+02_r8,1.1939e+02_r8,5.9899e+01_r8,3.1810e-01_r8/)
      kbo(:, 4,15, 6) = (/ &
     &2.4502e+02_r8,1.8386e+02_r8,1.2270e+02_r8,6.1544e+01_r8,3.2391e-01_r8/)
      kbo(:, 5,15, 6) = (/ &
     &2.5289e+02_r8,1.8977e+02_r8,1.2664e+02_r8,6.3520e+01_r8,3.2850e-01_r8/)
      kbo(:, 1,16, 6) = (/ &
     &1.4635e+02_r8,1.0986e+02_r8,7.3372e+01_r8,3.6890e+01_r8,2.7344e-01_r8/)
      kbo(:, 2,16, 6) = (/ &
     &1.5031e+02_r8,1.1283e+02_r8,7.5356e+01_r8,3.7881e+01_r8,2.8092e-01_r8/)
      kbo(:, 3,16, 6) = (/ &
     &1.5444e+02_r8,1.1592e+02_r8,7.7407e+01_r8,3.8900e+01_r8,2.8781e-01_r8/)
      kbo(:, 4,16, 6) = (/ &
     &1.5922e+02_r8,1.1951e+02_r8,7.9797e+01_r8,4.0091e+01_r8,2.9332e-01_r8/)
      kbo(:, 5,16, 6) = (/ &
     &1.6548e+02_r8,1.2420e+02_r8,8.2930e+01_r8,4.1661e+01_r8,2.9808e-01_r8/)
      kbo(:, 1,17, 6) = (/ &
     &9.8142e+01_r8,7.3705e+01_r8,4.9268e+01_r8,2.4840e+01_r8,2.4429e-01_r8/)
      kbo(:, 2,17, 6) = (/ &
     &1.0076e+02_r8,7.5668e+01_r8,5.0576e+01_r8,2.5493e+01_r8,2.5184e-01_r8/)
      kbo(:, 3,17, 6) = (/ &
     &1.0378e+02_r8,7.7926e+01_r8,5.2073e+01_r8,2.6235e+01_r8,2.5821e-01_r8/)
      kbo(:, 4,17, 6) = (/ &
     &1.0768e+02_r8,8.0849e+01_r8,5.4024e+01_r8,2.7211e+01_r8,2.6339e-01_r8/)
      kbo(:, 5,17, 6) = (/ &
     &1.1267e+02_r8,8.4599e+01_r8,5.6526e+01_r8,2.8462e+01_r8,2.6841e-01_r8/)
      kbo(:, 1,18, 6) = (/ &
     &6.7329e+01_r8,5.0594e+01_r8,3.3862e+01_r8,1.7162e+01_r8,2.1677e-01_r8/)
      kbo(:, 2,18, 6) = (/ &
     &6.9224e+01_r8,5.2009e+01_r8,3.4803e+01_r8,1.7627e+01_r8,2.2376e-01_r8/)
      kbo(:, 3,18, 6) = (/ &
     &7.1671e+01_r8,5.3842e+01_r8,3.6019e+01_r8,1.8223e+01_r8,2.2981e-01_r8/)
      kbo(:, 4,18, 6) = (/ &
     &7.4922e+01_r8,5.6283e+01_r8,3.7648e+01_r8,1.9036e+01_r8,2.3516e-01_r8/)
      kbo(:, 5,18, 6) = (/ &
     &7.8609e+01_r8,5.9048e+01_r8,3.9493e+01_r8,1.9956e+01_r8,2.4055e-01_r8/)
      kbo(:, 1,19, 6) = (/ &
     &4.5351e+01_r8,3.4111e+01_r8,2.2879e+01_r8,1.1748e+01_r8,1.9068e-01_r8/)
      kbo(:, 2,19, 6) = (/ &
     &4.6788e+01_r8,3.5180e+01_r8,2.3587e+01_r8,1.2086e+01_r8,1.9727e-01_r8/)
      kbo(:, 3,19, 6) = (/ &
     &4.8819e+01_r8,3.6704e+01_r8,2.4596e+01_r8,1.2571e+01_r8,2.0322e-01_r8/)
      kbo(:, 4,19, 6) = (/ &
     &5.1243e+01_r8,3.8523e+01_r8,2.5810e+01_r8,1.3165e+01_r8,2.0895e-01_r8/)
      kbo(:, 5,19, 6) = (/ &
     &5.3759e+01_r8,4.0411e+01_r8,2.7071e+01_r8,1.3784e+01_r8,2.1468e-01_r8/)
      kbo(:, 1,20, 6) = (/ &
     &3.3050e+01_r8,2.4885e+01_r8,1.6741e+01_r8,8.7700e+00_r8,1.6695e-01_r8/)
      kbo(:, 2,20, 6) = (/ &
     &3.4346e+01_r8,2.5850e+01_r8,1.7375e+01_r8,9.0666e+00_r8,1.7321e-01_r8/)
      kbo(:, 3,20, 6) = (/ &
     &3.6031e+01_r8,2.7114e+01_r8,1.8213e+01_r8,9.4660e+00_r8,1.7929e-01_r8/)
      kbo(:, 4,20, 6) = (/ &
     &3.7866e+01_r8,2.8491e+01_r8,1.9130e+01_r8,9.9045e+00_r8,1.8515e-01_r8/)
      kbo(:, 5,20, 6) = (/ &
     &3.9713e+01_r8,2.9876e+01_r8,2.0052e+01_r8,1.0350e+01_r8,1.9066e-01_r8/)
      kbo(:, 1,21, 6) = (/ &
     &2.4844e+01_r8,1.8731e+01_r8,1.2673e+01_r8,6.7851e+00_r8,1.4553e-01_r8/)
      kbo(:, 2,21, 6) = (/ &
     &2.6012e+01_r8,1.9600e+01_r8,1.3239e+01_r8,7.0557e+00_r8,1.5180e-01_r8/)
      kbo(:, 3,21, 6) = (/ &
     &2.7347e+01_r8,2.0602e+01_r8,1.3900e+01_r8,7.3743e+00_r8,1.5767e-01_r8/)
      kbo(:, 4,21, 6) = (/ &
     &2.8734e+01_r8,2.1643e+01_r8,1.4586e+01_r8,7.7037e+00_r8,1.6319e-01_r8/)
      kbo(:, 5,21, 6) = (/ &
     &3.0137e+01_r8,2.2696e+01_r8,1.5284e+01_r8,8.0405e+00_r8,1.6831e-01_r8/)
      kbo(:, 1,22, 6) = (/ &
     &1.9244e+01_r8,1.4532e+01_r8,9.9298e+00_r8,5.4125e+00_r8,1.2703e-01_r8/)
      kbo(:, 2,22, 6) = (/ &
     &2.0224e+01_r8,1.5263e+01_r8,1.0402e+01_r8,5.6515e+00_r8,1.3287e-01_r8/)
      kbo(:, 3,22, 6) = (/ &
     &2.1278e+01_r8,1.6053e+01_r8,1.0915e+01_r8,5.9058e+00_r8,1.3815e-01_r8/)
      kbo(:, 4,22, 6) = (/ &
     &2.2359e+01_r8,1.6864e+01_r8,1.1443e+01_r8,6.1676e+00_r8,1.4315e-01_r8/)
      kbo(:, 5,22, 6) = (/ &
     &2.3448e+01_r8,1.7683e+01_r8,1.1980e+01_r8,6.4316e+00_r8,1.4780e-01_r8/)
      kbo(:, 1,23, 6) = (/ &
     &1.5003e+01_r8,1.1361e+01_r8,7.8631e+00_r8,4.3544e+00_r8,1.1053e-01_r8/)
      kbo(:, 2,23, 6) = (/ &
     &1.5788e+01_r8,1.1946e+01_r8,8.2434e+00_r8,4.5541e+00_r8,1.1564e-01_r8/)
      kbo(:, 3,23, 6) = (/ &
     &1.6609e+01_r8,1.2560e+01_r8,8.6387e+00_r8,4.7603e+00_r8,1.2034e-01_r8/)
      kbo(:, 4,23, 6) = (/ &
     &1.7444e+01_r8,1.3184e+01_r8,9.0429e+00_r8,4.9691e+00_r8,1.2479e-01_r8/)
      kbo(:, 5,23, 6) = (/ &
     &1.8318e+01_r8,1.3840e+01_r8,9.4687e+00_r8,5.1869e+00_r8,1.2894e-01_r8/)
      kbo(:, 1,24, 6) = (/ &
     &1.1642e+01_r8,8.8646e+00_r8,6.2180e+00_r8,3.4890e+00_r8,9.5642e-02_r8/)
      kbo(:, 2,24, 6) = (/ &
     &1.2250e+01_r8,9.3143e+00_r8,6.5164e+00_r8,3.6525e+00_r8,1.0007e-01_r8/)
      kbo(:, 3,24, 6) = (/ &
     &1.2878e+01_r8,9.7800e+00_r8,6.8207e+00_r8,3.8184e+00_r8,1.0423e-01_r8/)
      kbo(:, 4,24, 6) = (/ &
     &1.3534e+01_r8,1.0267e+01_r8,7.1387e+00_r8,3.9893e+00_r8,1.0818e-01_r8/)
      kbo(:, 5,24, 6) = (/ &
     &1.4255e+01_r8,1.0806e+01_r8,7.4905e+00_r8,4.1737e+00_r8,1.1190e-01_r8/)
      kbo(:, 1,25, 6) = (/ &
     &9.1475e+00_r8,7.0241e+00_r8,4.9880e+00_r8,2.8234e+00_r8,8.2353e-02_r8/)
      kbo(:, 2,25, 6) = (/ &
     &9.6194e+00_r8,7.3705e+00_r8,5.2236e+00_r8,2.9556e+00_r8,8.6208e-02_r8/)
      kbo(:, 3,25, 6) = (/ &
     &1.0118e+01_r8,7.7356e+00_r8,5.4684e+00_r8,3.0922e+00_r8,8.9882e-02_r8/)
      kbo(:, 4,25, 6) = (/ &
     &1.0662e+01_r8,8.1371e+00_r8,5.7357e+00_r8,3.2382e+00_r8,9.3407e-02_r8/)
      kbo(:, 5,25, 6) = (/ &
     &1.1279e+01_r8,8.5947e+00_r8,6.0377e+00_r8,3.4015e+00_r8,9.6770e-02_r8/)
      kbo(:, 1,26, 6) = (/ &
     &7.3112e+00_r8,5.6725e+00_r8,4.0689e+00_r8,2.3123e+00_r8,7.0640e-02_r8/)
      kbo(:, 2,26, 6) = (/ &
     &7.6950e+00_r8,5.9535e+00_r8,4.2634e+00_r8,2.4227e+00_r8,7.4010e-02_r8/)
      kbo(:, 3,26, 6) = (/ &
     &8.1066e+00_r8,6.2538e+00_r8,4.4719e+00_r8,2.5387e+00_r8,7.7271e-02_r8/)
      kbo(:, 4,26, 6) = (/ &
     &8.5794e+00_r8,6.6014e+00_r8,4.7086e+00_r8,2.6686e+00_r8,8.0450e-02_r8/)
      kbo(:, 5,26, 6) = (/ &
     &9.1099e+00_r8,6.9909e+00_r8,4.9735e+00_r8,2.8158e+00_r8,8.3380e-02_r8/)
      kbo(:, 1,27, 6) = (/ &
     &6.0744e+00_r8,4.7606e+00_r8,3.4368e+00_r8,1.9534e+00_r8,6.0404e-02_r8/)
      kbo(:, 2,27, 6) = (/ &
     &6.4010e+00_r8,4.9996e+00_r8,3.6064e+00_r8,2.0495e+00_r8,6.3391e-02_r8/)
      kbo(:, 3,27, 6) = (/ &
     &6.7712e+00_r8,5.2713e+00_r8,3.7979e+00_r8,2.1556e+00_r8,6.6293e-02_r8/)
      kbo(:, 4,27, 6) = (/ &
     &7.1986e+00_r8,5.5846e+00_r8,4.0153e+00_r8,2.2772e+00_r8,6.9007e-02_r8/)
      kbo(:, 5,27, 6) = (/ &
     &7.6755e+00_r8,5.9357e+00_r8,4.2585e+00_r8,2.4127e+00_r8,7.1247e-02_r8/)
      kbo(:, 1,28, 6) = (/ &
     &5.1866e+00_r8,4.1033e+00_r8,2.9724e+00_r8,1.6878e+00_r8,5.1571e-02_r8/)
      kbo(:, 2,28, 6) = (/ &
     &5.4861e+00_r8,4.3239e+00_r8,3.1305e+00_r8,1.7765e+00_r8,5.4219e-02_r8/)
      kbo(:, 3,28, 6) = (/ &
     &5.8320e+00_r8,4.5795e+00_r8,3.3130e+00_r8,1.8782e+00_r8,5.6690e-02_r8/)
      kbo(:, 4,28, 6) = (/ &
     &6.2247e+00_r8,4.8686e+00_r8,3.5188e+00_r8,1.9940e+00_r8,5.8750e-02_r8/)
      kbo(:, 5,28, 6) = (/ &
     &6.6558e+00_r8,5.1871e+00_r8,3.7446e+00_r8,2.1214e+00_r8,6.0243e-02_r8/)
      kbo(:, 1,29, 6) = (/ &
     &4.7142e+00_r8,3.7524e+00_r8,2.7162e+00_r8,1.5365e+00_r8,4.4039e-02_r8/)
      kbo(:, 2,29, 6) = (/ &
     &5.0090e+00_r8,3.9723e+00_r8,2.8754e+00_r8,1.6258e+00_r8,4.6277e-02_r8/)
      kbo(:, 3,29, 6) = (/ &
     &5.3480e+00_r8,4.2236e+00_r8,3.0565e+00_r8,1.7286e+00_r8,4.8156e-02_r8/)
      kbo(:, 4,29, 6) = (/ &
     &5.7292e+00_r8,4.5074e+00_r8,3.2622e+00_r8,1.8442e+00_r8,4.9560e-02_r8/)
      kbo(:, 5,29, 6) = (/ &
     &6.1329e+00_r8,4.8058e+00_r8,3.4771e+00_r8,1.9687e+00_r8,5.0487e-02_r8/)
      kbo(:, 1,30, 6) = (/ &
     &4.4038e+00_r8,3.5211e+00_r8,2.5447e+00_r8,1.4336e+00_r8,3.7528e-02_r8/)
      kbo(:, 2,30, 6) = (/ &
     &4.6996e+00_r8,3.7441e+00_r8,2.7067e+00_r8,1.5257e+00_r8,3.9262e-02_r8/)
      kbo(:, 3,30, 6) = (/ &
     &5.0396e+00_r8,3.9983e+00_r8,2.8921e+00_r8,1.6308e+00_r8,4.0573e-02_r8/)
      kbo(:, 4,30, 6) = (/ &
     &5.4089e+00_r8,4.2744e+00_r8,3.0942e+00_r8,1.7467e+00_r8,4.1475e-02_r8/)
      kbo(:, 5,30, 6) = (/ &
     &5.8026e+00_r8,4.5655e+00_r8,3.3058e+00_r8,1.8693e+00_r8,4.2084e-02_r8/)
      kbo(:, 1,31, 6) = (/ &
     &4.3406e+00_r8,3.4756e+00_r8,2.5043e+00_r8,1.4029e+00_r8,3.1837e-02_r8/)
      kbo(:, 2,31, 6) = (/ &
     &4.6530e+00_r8,3.7116e+00_r8,2.6766e+00_r8,1.5014e+00_r8,3.3063e-02_r8/)
      kbo(:, 3,31, 6) = (/ &
     &5.0025e+00_r8,3.9754e+00_r8,2.8716e+00_r8,1.6130e+00_r8,3.3948e-02_r8/)
      kbo(:, 4,31, 6) = (/ &
     &5.3785e+00_r8,4.2562e+00_r8,3.0774e+00_r8,1.7319e+00_r8,3.4570e-02_r8/)
      kbo(:, 5,31, 6) = (/ &
     &5.7889e+00_r8,4.5595e+00_r8,3.2989e+00_r8,1.8598e+00_r8,3.4986e-02_r8/)
      kbo(:, 1,32, 6) = (/ &
     &4.3396e+00_r8,3.4769e+00_r8,2.4992e+00_r8,1.3933e+00_r8,2.6827e-02_r8/)
      kbo(:, 2,32, 6) = (/ &
     &4.6714e+00_r8,3.7286e+00_r8,2.6844e+00_r8,1.4997e+00_r8,2.7685e-02_r8/)
      kbo(:, 3,32, 6) = (/ &
     &5.0312e+00_r8,4.0002e+00_r8,2.8855e+00_r8,1.6156e+00_r8,2.8303e-02_r8/)
      kbo(:, 4,32, 6) = (/ &
     &5.4256e+00_r8,4.2946e+00_r8,3.1010e+00_r8,1.7399e+00_r8,2.8748e-02_r8/)
      kbo(:, 5,32, 6) = (/ &
     &5.8665e+00_r8,4.6212e+00_r8,3.3393e+00_r8,1.8767e+00_r8,2.9064e-02_r8/)
      kbo(:, 1,33, 6) = (/ &
     &4.4332e+00_r8,3.5489e+00_r8,2.5452e+00_r8,1.4121e+00_r8,2.2496e-02_r8/)
      kbo(:, 2,33, 6) = (/ &
     &4.7823e+00_r8,3.8149e+00_r8,2.7429e+00_r8,1.5266e+00_r8,2.3111e-02_r8/)
      kbo(:, 3,33, 6) = (/ &
     &5.1647e+00_r8,4.1029e+00_r8,2.9548e+00_r8,1.6483e+00_r8,2.3573e-02_r8/)
      kbo(:, 4,33, 6) = (/ &
     &5.5917e+00_r8,4.4208e+00_r8,3.1884e+00_r8,1.7830e+00_r8,2.3904e-02_r8/)
      kbo(:, 5,33, 6) = (/ &
     &6.0743e+00_r8,4.7788e+00_r8,3.4474e+00_r8,1.9321e+00_r8,2.4134e-02_r8/)
      kbo(:, 1,34, 6) = (/ &
     &4.4125e+00_r8,3.5356e+00_r8,2.5335e+00_r8,1.4023e+00_r8,1.8787e-02_r8/)
      kbo(:, 2,34, 6) = (/ &
     &4.7724e+00_r8,3.8103e+00_r8,2.7374e+00_r8,1.5195e+00_r8,1.9239e-02_r8/)
      kbo(:, 3,34, 6) = (/ &
     &5.1721e+00_r8,4.1112e+00_r8,2.9584e+00_r8,1.6475e+00_r8,1.9590e-02_r8/)
      kbo(:, 4,34, 6) = (/ &
     &5.6244e+00_r8,4.4492e+00_r8,3.2069e+00_r8,1.7903e+00_r8,1.9843e-02_r8/)
      kbo(:, 5,34, 6) = (/ &
     &6.1384e+00_r8,4.8292e+00_r8,3.4834e+00_r8,1.9492e+00_r8,2.0036e-02_r8/)
      kbo(:, 1,35, 6) = (/ &
     &4.3717e+00_r8,3.5073e+00_r8,2.5119e+00_r8,1.3871e+00_r8,1.5622e-02_r8/)
      kbo(:, 2,35, 6) = (/ &
     &4.7431e+00_r8,3.7911e+00_r8,2.7216e+00_r8,1.5076e+00_r8,1.5975e-02_r8/)
      kbo(:, 3,35, 6) = (/ &
     &5.1596e+00_r8,4.1047e+00_r8,2.9535e+00_r8,1.6419e+00_r8,1.6252e-02_r8/)
      kbo(:, 4,35, 6) = (/ &
     &5.6365e+00_r8,4.4612e+00_r8,3.2141e+00_r8,1.7918e+00_r8,1.6461e-02_r8/)
      kbo(:, 5,35, 6) = (/ &
     &6.1774e+00_r8,4.8609e+00_r8,3.5048e+00_r8,1.9589e+00_r8,1.6599e-02_r8/)
      kbo(:, 1,36, 6) = (/ &
     &4.2736e+00_r8,3.4354e+00_r8,2.4585e+00_r8,1.3548e+00_r8,1.2936e-02_r8/)
      kbo(:, 2,36, 6) = (/ &
     &4.6496e+00_r8,3.7234e+00_r8,2.6724e+00_r8,1.4783e+00_r8,1.3228e-02_r8/)
      kbo(:, 3,36, 6) = (/ &
     &5.0769e+00_r8,4.0460e+00_r8,2.9111e+00_r8,1.6163e+00_r8,1.3462e-02_r8/)
      kbo(:, 4,36, 6) = (/ &
     &5.5708e+00_r8,4.4155e+00_r8,3.1813e+00_r8,1.7716e+00_r8,1.3637e-02_r8/)
      kbo(:, 5,36, 6) = (/ &
     &6.1338e+00_r8,4.8311e+00_r8,3.4822e+00_r8,1.9445e+00_r8,1.3753e-02_r8/)
      kbo(:, 1,37, 6) = (/ &
     &4.0234e+00_r8,3.2473e+00_r8,2.3232e+00_r8,1.2788e+00_r8,1.0671e-02_r8/)
      kbo(:, 2,37, 6) = (/ &
     &4.3892e+00_r8,3.5290e+00_r8,2.5324e+00_r8,1.3998e+00_r8,1.0924e-02_r8/)
      kbo(:, 3,37, 6) = (/ &
     &4.8090e+00_r8,3.8477e+00_r8,2.7688e+00_r8,1.5370e+00_r8,1.1122e-02_r8/)
      kbo(:, 4,37, 6) = (/ &
     &5.2982e+00_r8,4.2143e+00_r8,3.0374e+00_r8,1.6915e+00_r8,1.1275e-02_r8/)
      kbo(:, 5,37, 6) = (/ &
     &5.8599e+00_r8,4.6308e+00_r8,3.3399e+00_r8,1.8652e+00_r8,1.1382e-02_r8/)
      kbo(:, 1,38, 6) = (/ &
     &3.8405e+00_r8,3.1094e+00_r8,2.2232e+00_r8,1.2223e+00_r8,8.8011e-03_r8/)
      kbo(:, 2,38, 6) = (/ &
     &4.2026e+00_r8,3.3894e+00_r8,2.4317e+00_r8,1.3429e+00_r8,9.0204e-03_r8/)
      kbo(:, 3,38, 6) = (/ &
     &4.6223e+00_r8,3.7094e+00_r8,2.6688e+00_r8,1.4805e+00_r8,9.1889e-03_r8/)
      kbo(:, 4,38, 6) = (/ &
     &5.1135e+00_r8,4.0786e+00_r8,2.9400e+00_r8,1.6366e+00_r8,9.3266e-03_r8/)
      kbo(:, 5,38, 6) = (/ &
     &5.6812e+00_r8,4.4997e+00_r8,3.2457e+00_r8,1.8125e+00_r8,9.4327e-03_r8/)
      kbo(:, 1,39, 6) = (/ &
     &3.7513e+00_r8,3.0429e+00_r8,2.1735e+00_r8,1.1927e+00_r8,7.2681e-03_r8/)
      kbo(:, 2,39, 6) = (/ &
     &4.1185e+00_r8,3.3272e+00_r8,2.3853e+00_r8,1.3156e+00_r8,7.4517e-03_r8/)
      kbo(:, 3,39, 6) = (/ &
     &4.5480e+00_r8,3.6554e+00_r8,2.6285e+00_r8,1.4564e+00_r8,7.6013e-03_r8/)
      kbo(:, 4,39, 6) = (/ &
     &5.0522e+00_r8,4.0351e+00_r8,2.9074e+00_r8,1.6167e+00_r8,7.7185e-03_r8/)
      kbo(:, 5,39, 6) = (/ &
     &5.6411e+00_r8,4.4721e+00_r8,3.2250e+00_r8,1.7992e+00_r8,7.8245e-03_r8/)
      kbo(:, 1,40, 6) = (/ &
     &3.4100e+00_r8,2.7806e+00_r8,1.9856e+00_r8,1.0896e+00_r8,5.9768e-03_r8/)
      kbo(:, 2,40, 6) = (/ &
     &3.7541e+00_r8,3.0505e+00_r8,2.1868e+00_r8,1.2067e+00_r8,6.1348e-03_r8/)
      kbo(:, 3,40, 6) = (/ &
     &4.1600e+00_r8,3.3636e+00_r8,2.4194e+00_r8,1.3415e+00_r8,6.2676e-03_r8/)
      kbo(:, 4,40, 6) = (/ &
     &4.6404e+00_r8,3.7278e+00_r8,2.6880e+00_r8,1.4963e+00_r8,6.3713e-03_r8/)
      kbo(:, 5,40, 6) = (/ &
     &5.2035e+00_r8,4.1476e+00_r8,2.9948e+00_r8,1.6730e+00_r8,6.4667e-03_r8/)
      kbo(:, 1,41, 6) = (/ &
     &3.0891e+00_r8,2.5323e+00_r8,1.8076e+00_r8,9.9199e-01_r8,4.9106e-03_r8/)
      kbo(:, 2,41, 6) = (/ &
     &3.4100e+00_r8,2.7866e+00_r8,1.9972e+00_r8,1.1027e+00_r8,5.0459e-03_r8/)
      kbo(:, 3,41, 6) = (/ &
     &3.7913e+00_r8,3.0833e+00_r8,2.2185e+00_r8,1.2311e+00_r8,5.1622e-03_r8/)
      kbo(:, 4,41, 6) = (/ &
     &4.2439e+00_r8,3.4304e+00_r8,2.4754e+00_r8,1.3795e+00_r8,5.2594e-03_r8/)
      kbo(:, 5,41, 6) = (/ &
     &4.7807e+00_r8,3.8337e+00_r8,2.7715e+00_r8,1.5507e+00_r8,5.3436e-03_r8/)
      kbo(:, 1,42, 6) = (/ &
     &2.8278e+00_r8,2.3283e+00_r8,1.6611e+00_r8,9.1142e-01_r8,4.0331e-03_r8/)
      kbo(:, 2,42, 6) = (/ &
     &3.1295e+00_r8,2.5702e+00_r8,1.8417e+00_r8,1.0169e+00_r8,4.1507e-03_r8/)
      kbo(:, 3,42, 6) = (/ &
     &3.4910e+00_r8,2.8544e+00_r8,2.0536e+00_r8,1.1401e+00_r8,4.2525e-03_r8/)
      kbo(:, 4,42, 6) = (/ &
     &3.9235e+00_r8,3.1883e+00_r8,2.3016e+00_r8,1.2837e+00_r8,4.3408e-03_r8/)
      kbo(:, 5,42, 6) = (/ &
     &4.4380e+00_r8,3.5784e+00_r8,2.5896e+00_r8,1.4506e+00_r8,4.4170e-03_r8/)
      kbo(:, 1,43, 6) = (/ &
     &2.5971e+00_r8,2.1460e+00_r8,1.5298e+00_r8,8.3854e-01_r8,3.3049e-03_r8/)
      kbo(:, 2,43, 6) = (/ &
     &2.8799e+00_r8,2.3759e+00_r8,1.7013e+00_r8,9.3880e-01_r8,3.4092e-03_r8/)
      kbo(:, 3,43, 6) = (/ &
     &3.2202e+00_r8,2.6461e+00_r8,1.9035e+00_r8,1.0566e+00_r8,3.5003e-03_r8/)
      kbo(:, 4,43, 6) = (/ &
     &3.6329e+00_r8,2.9678e+00_r8,2.1426e+00_r8,1.1949e+00_r8,3.5773e-03_r8/)
      kbo(:, 5,43, 6) = (/ &
     &4.1275e+00_r8,3.3455e+00_r8,2.4216e+00_r8,1.3572e+00_r8,3.6480e-03_r8/)
      kbo(:, 1,44, 6) = (/ &
     &2.4109e+00_r8,1.9983e+00_r8,1.4225e+00_r8,7.7812e-01_r8,2.7054e-03_r8/)
      kbo(:, 2,44, 6) = (/ &
     &2.6776e+00_r8,2.2170e+00_r8,1.5862e+00_r8,8.7403e-01_r8,2.7971e-03_r8/)
      kbo(:, 3,44, 6) = (/ &
     &3.0022e+00_r8,2.4769e+00_r8,1.7806e+00_r8,9.8740e-01_r8,2.8773e-03_r8/)
      kbo(:, 4,44, 6) = (/ &
     &3.3965e+00_r8,2.7871e+00_r8,2.0115e+00_r8,1.1213e+00_r8,2.9478e-03_r8/)
      kbo(:, 5,44, 6) = (/ &
     &3.8747e+00_r8,3.1555e+00_r8,2.2836e+00_r8,1.2791e+00_r8,3.0101e-03_r8/)
      kbo(:, 1,45, 6) = (/ &
     &2.2815e+00_r8,1.8944e+00_r8,1.3464e+00_r8,7.3467e-01_r8,2.2130e-03_r8/)
      kbo(:, 2,45, 6) = (/ &
     &2.5401e+00_r8,2.1081e+00_r8,1.5065e+00_r8,8.2816e-01_r8,2.2948e-03_r8/)
      kbo(:, 3,45, 6) = (/ &
     &2.8533e+00_r8,2.3602e+00_r8,1.6948e+00_r8,9.3826e-01_r8,2.3656e-03_r8/)
      kbo(:, 4,45, 6) = (/ &
     &3.2382e+00_r8,2.6655e+00_r8,1.9218e+00_r8,1.0700e+00_r8,2.4291e-03_r8/)
      kbo(:, 5,45, 6) = (/ &
     &3.7076e+00_r8,3.0298e+00_r8,2.1912e+00_r8,1.2259e+00_r8,2.4852e-03_r8/)
      kbo(:, 1,46, 6) = (/ &
     &2.1752e+00_r8,1.8075e+00_r8,1.2824e+00_r8,6.9758e-01_r8,1.8083e-03_r8/)
      kbo(:, 2,46, 6) = (/ &
     &2.4262e+00_r8,2.0168e+00_r8,1.4391e+00_r8,7.8916e-01_r8,1.8803e-03_r8/)
      kbo(:, 3,46, 6) = (/ &
     &2.7306e+00_r8,2.2636e+00_r8,1.6229e+00_r8,8.9649e-01_r8,1.9453e-03_r8/)
      kbo(:, 4,46, 6) = (/ &
     &3.1079e+00_r8,2.5651e+00_r8,1.8473e+00_r8,1.0263e+00_r8,2.0023e-03_r8/)
      kbo(:, 5,46, 6) = (/ &
     &3.5715e+00_r8,2.9262e+00_r8,2.1144e+00_r8,1.1808e+00_r8,2.0547e-03_r8/)
      kbo(:, 1,47, 6) = (/ &
     &2.0439e+00_r8,1.6998e+00_r8,1.2039e+00_r8,6.5284e-01_r8,1.4728e-03_r8/)
      kbo(:, 2,47, 6) = (/ &
     &2.2849e+00_r8,1.9026e+00_r8,1.3552e+00_r8,7.4124e-01_r8,1.5378e-03_r8/)
      kbo(:, 3,47, 6) = (/ &
     &2.5739e+00_r8,2.1396e+00_r8,1.5317e+00_r8,8.4434e-01_r8,1.5971e-03_r8/)
      kbo(:, 4,47, 6) = (/ &
     &2.9355e+00_r8,2.4308e+00_r8,1.7484e+00_r8,9.6939e-01_r8,1.6478e-03_r8/)
      kbo(:, 5,47, 6) = (/ &
     &3.3837e+00_r8,2.7824e+00_r8,2.0088e+00_r8,1.1198e+00_r8,1.6945e-03_r8/)
      kbo(:, 1,48, 6) = (/ &
     &1.9729e+00_r8,1.6396e+00_r8,1.1585e+00_r8,6.2585e-01_r8,1.1998e-03_r8/)
      kbo(:, 2,48, 6) = (/ &
     &2.2114e+00_r8,1.8415e+00_r8,1.3088e+00_r8,7.1328e-01_r8,1.2575e-03_r8/)
      kbo(:, 3,48, 6) = (/ &
     &2.4937e+00_r8,2.0747e+00_r8,1.4825e+00_r8,8.1439e-01_r8,1.3096e-03_r8/)
      kbo(:, 4,48, 6) = (/ &
     &2.8486e+00_r8,2.3616e+00_r8,1.6960e+00_r8,9.3764e-01_r8,1.3556e-03_r8/)
      kbo(:, 5,48, 6) = (/ &
     &3.2936e+00_r8,2.7131e+00_r8,1.9561e+00_r8,1.0874e+00_r8,1.3979e-03_r8/)
      kbo(:, 1,49, 6) = (/ &
     &1.9817e+00_r8,1.6421e+00_r8,1.1570e+00_r8,6.2210e-01_r8,9.7602e-04_r8/)
      kbo(:, 2,49, 6) = (/ &
     &2.2272e+00_r8,1.8506e+00_r8,1.3118e+00_r8,7.1147e-01_r8,1.0279e-03_r8/)
      kbo(:, 3,49, 6) = (/ &
     &2.5150e+00_r8,2.0896e+00_r8,1.4898e+00_r8,8.1454e-01_r8,1.0745e-03_r8/)
      kbo(:, 4,49, 6) = (/ &
     &2.8769e+00_r8,2.3813e+00_r8,1.7067e+00_r8,9.3965e-01_r8,1.1160e-03_r8/)
      kbo(:, 5,49, 6) = (/ &
     &3.3353e+00_r8,2.7446e+00_r8,1.9747e+00_r8,1.0933e+00_r8,1.1545e-03_r8/)
      kbo(:, 1,50, 6) = (/ &
     &1.8978e+00_r8,1.5720e+00_r8,1.1055e+00_r8,5.9245e-01_r8,7.9308e-04_r8/)
      kbo(:, 2,50, 6) = (/ &
     &2.1399e+00_r8,1.7779e+00_r8,1.2580e+00_r8,6.8007e-01_r8,8.3888e-04_r8/)
      kbo(:, 3,50, 6) = (/ &
     &2.4218e+00_r8,2.0138e+00_r8,1.4333e+00_r8,7.8150e-01_r8,8.7996e-04_r8/)
      kbo(:, 4,50, 6) = (/ &
     &2.7742e+00_r8,2.2995e+00_r8,1.6455e+00_r8,9.0381e-01_r8,9.1698e-04_r8/)
      kbo(:, 5,50, 6) = (/ &
     &3.2255e+00_r8,2.6590e+00_r8,1.9107e+00_r8,1.0555e+00_r8,9.5164e-04_r8/)
      kbo(:, 1,51, 6) = (/ &
     &1.7787e+00_r8,1.4741e+00_r8,1.0351e+00_r8,5.5321e-01_r8,6.4322e-04_r8/)
      kbo(:, 2,51, 6) = (/ &
     &2.0121e+00_r8,1.6731e+00_r8,1.1819e+00_r8,6.3736e-01_r8,6.8396e-04_r8/)
      kbo(:, 3,51, 6) = (/ &
     &2.2825e+00_r8,1.9012e+00_r8,1.3514e+00_r8,7.3514e-01_r8,7.1977e-04_r8/)
      kbo(:, 4,51, 6) = (/ &
     &2.6184e+00_r8,2.1760e+00_r8,1.5550e+00_r8,8.5263e-01_r8,7.5276e-04_r8/)
      kbo(:, 5,51, 6) = (/ &
     &3.0526e+00_r8,2.5248e+00_r8,1.8126e+00_r8,9.9966e-01_r8,7.8322e-04_r8/)
      kbo(:, 1,52, 6) = (/ &
     &1.7138e+00_r8,1.4190e+00_r8,9.9450e-01_r8,5.2987e-01_r8,5.2154e-04_r8/)
      kbo(:, 2,52, 6) = (/ &
     &1.9434e+00_r8,1.6150e+00_r8,1.1387e+00_r8,6.1204e-01_r8,5.5749e-04_r8/)
      kbo(:, 3,52, 6) = (/ &
     &2.2115e+00_r8,1.8422e+00_r8,1.3069e+00_r8,7.0863e-01_r8,5.8864e-04_r8/)
      kbo(:, 4,52, 6) = (/ &
     &2.5398e+00_r8,2.1125e+00_r8,1.5071e+00_r8,8.2393e-01_r8,6.1775e-04_r8/)
      kbo(:, 5,52, 6) = (/ &
     &2.9672e+00_r8,2.4581e+00_r8,1.7623e+00_r8,9.6952e-01_r8,6.4493e-04_r8/)
      kbo(:, 1,53, 6) = (/ &
     &1.7198e+00_r8,1.4203e+00_r8,9.9324e-01_r8,5.2715e-01_r8,4.2262e-04_r8/)
      kbo(:, 2,53, 6) = (/ &
     &1.9529e+00_r8,1.6185e+00_r8,1.1384e+00_r8,6.0925e-01_r8,4.5399e-04_r8/)
      kbo(:, 3,53, 6) = (/ &
     &2.2293e+00_r8,1.8530e+00_r8,1.3116e+00_r8,7.0805e-01_r8,4.8128e-04_r8/)
      kbo(:, 4,53, 6) = (/ &
     &2.5636e+00_r8,2.1294e+00_r8,1.5160e+00_r8,8.2535e-01_r8,5.0713e-04_r8/)
      kbo(:, 5,53, 6) = (/ &
     &3.0004e+00_r8,2.4827e+00_r8,1.7770e+00_r8,9.7383e-01_r8,5.3111e-04_r8/)
      kbo(:, 1,54, 6) = (/ &
     &1.4969e+00_r8,1.2401e+00_r8,8.6613e-01_r8,4.5904e-01_r8,3.4135e-04_r8/)
      kbo(:, 2,54, 6) = (/ &
     &1.7004e+00_r8,1.4146e+00_r8,9.9400e-01_r8,5.3139e-01_r8,3.6835e-04_r8/)
      kbo(:, 3,54, 6) = (/ &
     &1.9475e+00_r8,1.6269e+00_r8,1.1506e+00_r8,6.2081e-01_r8,3.9232e-04_r8/)
      kbo(:, 4,54, 6) = (/ &
     &2.2441e+00_r8,1.8758e+00_r8,1.3350e+00_r8,7.2699e-01_r8,4.1441e-04_r8/)
      kbo(:, 5,54, 6) = (/ &
     &2.6322e+00_r8,2.1931e+00_r8,1.5695e+00_r8,8.6094e-01_r8,4.3501e-04_r8/)
      kbo(:, 1,55, 6) = (/ &
     &1.1902e+00_r8,9.9203e-01_r8,6.9261e-01_r8,3.6696e-01_r8,2.7539e-04_r8/)
      kbo(:, 2,55, 6) = (/ &
     &1.3514e+00_r8,1.1327e+00_r8,7.9579e-01_r8,4.2578e-01_r8,2.9805e-04_r8/)
      kbo(:, 3,55, 6) = (/ &
     &1.5528e+00_r8,1.3090e+00_r8,9.2585e-01_r8,5.0048e-01_r8,3.1883e-04_r8/)
      kbo(:, 4,55, 6) = (/ &
     &1.7945e+00_r8,1.5161e+00_r8,1.0797e+00_r8,5.8958e-01_r8,3.3758e-04_r8/)
      kbo(:, 5,55, 6) = (/ &
     &2.1091e+00_r8,1.7786e+00_r8,1.2743e+00_r8,7.0161e-01_r8,3.5497e-04_r8/)
      kbo(:, 1,56, 6) = (/ &
     &9.4564e-01_r8,7.9256e-01_r8,5.5332e-01_r8,2.9317e-01_r8,2.2189e-04_r8/)
      kbo(:, 2,56, 6) = (/ &
     &1.0727e+00_r8,9.0556e-01_r8,6.3622e-01_r8,3.4063e-01_r8,2.4090e-04_r8/)
      kbo(:, 3,56, 6) = (/ &
     &1.2368e+00_r8,1.0514e+00_r8,7.4402e-01_r8,4.0280e-01_r8,2.5859e-04_r8/)
      kbo(:, 4,56, 6) = (/ &
     &1.4335e+00_r8,1.2238e+00_r8,8.7212e-01_r8,4.7748e-01_r8,2.7478e-04_r8/)
      kbo(:, 5,56, 6) = (/ &
     &1.6876e+00_r8,1.4404e+00_r8,1.0331e+00_r8,5.7092e-01_r8,2.8964e-04_r8/)
      kbo(:, 1,57, 6) = (/ &
     &7.5151e-01_r8,6.3315e-01_r8,4.4196e-01_r8,2.3414e-01_r8,1.7834e-04_r8/)
      kbo(:, 2,57, 6) = (/ &
     &8.5091e-01_r8,7.2306e-01_r8,5.0804e-01_r8,2.7214e-01_r8,1.9471e-04_r8/)
      kbo(:, 3,57, 6) = (/ &
     &9.8353e-01_r8,8.4281e-01_r8,5.9656e-01_r8,3.2337e-01_r8,2.0961e-04_r8/)
      kbo(:, 4,57, 6) = (/ &
     &1.1433e+00_r8,9.8609e-01_r8,7.0325e-01_r8,3.8594e-01_r8,2.2327e-04_r8/)
      kbo(:, 5,57, 6) = (/ &
     &1.3484e+00_r8,1.1650e+00_r8,8.3657e-01_r8,4.6393e-01_r8,2.3604e-04_r8/)
      kbo(:, 1,58, 6) = (/ &
     &1.5793e-01_r8,1.6356e-01_r8,1.4683e-01_r8,1.0896e-01_r8,1.4326e-04_r8/)
      kbo(:, 2,58, 6) = (/ &
     &1.7834e-01_r8,1.8665e-01_r8,1.6872e-01_r8,1.2675e-01_r8,1.5731e-04_r8/)
      kbo(:, 3,58, 6) = (/ &
     &2.0650e-01_r8,2.1828e-01_r8,1.9887e-01_r8,1.5129e-01_r8,1.6986e-04_r8/)
      kbo(:, 4,58, 6) = (/ &
     &2.4084e-01_r8,2.5688e-01_r8,2.3602e-01_r8,1.8197e-01_r8,1.8127e-04_r8/)
      kbo(:, 5,58, 6) = (/ &
     &2.8453e-01_r8,3.0466e-01_r8,2.8209e-01_r8,2.2013e-01_r8,1.9222e-04_r8/)
      kbo(:, 1,59, 6) = (/ &
     &1.5159e-01_r8,1.5229e-01_r8,1.2764e-01_r8,8.4631e-02_r8,1.1680e-04_r8/)
      kbo(:, 2,59, 6) = (/ &
     &1.7166e-01_r8,1.7481e-01_r8,1.4781e-01_r8,9.9479e-02_r8,1.2840e-04_r8/)
      kbo(:, 3,59, 6) = (/ &
     &1.9953e-01_r8,2.0595e-01_r8,1.7587e-01_r8,1.2013e-01_r8,1.3871e-04_r8/)
      kbo(:, 4,59, 6) = (/ &
     &2.3377e-01_r8,2.4439e-01_r8,2.1097e-01_r8,1.4631e-01_r8,1.4804e-04_r8/)
      kbo(:, 5,59, 6) = (/ &
     &2.7769e-01_r8,2.9243e-01_r8,2.5484e-01_r8,1.7920e-01_r8,1.5678e-04_r8/)
      kbo(:, 1,13, 7) = (/ &
     &1.7755e+03_r8,1.3317e+03_r8,8.8796e+02_r8,4.4421e+02_r8,6.5972e-01_r8/)
      kbo(:, 2,13, 7) = (/ &
     &1.8279e+03_r8,1.3710e+03_r8,9.1418e+02_r8,4.5731e+02_r8,6.6173e-01_r8/)
      kbo(:, 3,13, 7) = (/ &
     &1.8885e+03_r8,1.4165e+03_r8,9.4446e+02_r8,4.7244e+02_r8,6.6577e-01_r8/)
      kbo(:, 4,13, 7) = (/ &
     &1.9490e+03_r8,1.4619e+03_r8,9.7472e+02_r8,4.8757e+02_r8,6.7090e-01_r8/)
      kbo(:, 5,13, 7) = (/ &
     &2.0075e+03_r8,1.5058e+03_r8,1.0040e+03_r8,5.0220e+02_r8,6.7193e-01_r8/)
      kbo(:, 1,14, 7) = (/ &
     &9.7594e+02_r8,7.3206e+02_r8,4.8819e+02_r8,2.4432e+02_r8,6.3121e-01_r8/)
      kbo(:, 2,14, 7) = (/ &
     &1.0087e+03_r8,7.5661e+02_r8,5.0455e+02_r8,2.5249e+02_r8,6.3502e-01_r8/)
      kbo(:, 3,14, 7) = (/ &
     &1.0415e+03_r8,7.8124e+02_r8,5.2096e+02_r8,2.6069e+02_r8,6.3710e-01_r8/)
      kbo(:, 4,14, 7) = (/ &
     &1.0744e+03_r8,8.0589e+02_r8,5.3739e+02_r8,2.6890e+02_r8,6.4004e-01_r8/)
      kbo(:, 5,14, 7) = (/ &
     &1.1054e+03_r8,8.2913e+02_r8,5.5288e+02_r8,2.7664e+02_r8,6.4122e-01_r8/)
      kbo(:, 1,15, 7) = (/ &
     &5.4478e+02_r8,4.0870e+02_r8,2.7262e+02_r8,1.3654e+02_r8,5.9523e-01_r8/)
      kbo(:, 2,15, 7) = (/ &
     &5.6305e+02_r8,4.2240e+02_r8,2.8175e+02_r8,1.4110e+02_r8,6.0003e-01_r8/)
      kbo(:, 3,15, 7) = (/ &
     &5.8123e+02_r8,4.3603e+02_r8,2.9083e+02_r8,1.4563e+02_r8,6.0181e-01_r8/)
      kbo(:, 4,15, 7) = (/ &
     &5.9882e+02_r8,4.4922e+02_r8,2.9962e+02_r8,1.5002e+02_r8,6.0320e-01_r8/)
      kbo(:, 5,15, 7) = (/ &
     &6.1530e+02_r8,4.6158e+02_r8,3.0785e+02_r8,1.5413e+02_r8,6.0492e-01_r8/)
      kbo(:, 1,16, 7) = (/ &
     &3.5993e+02_r8,2.7006e+02_r8,1.8020e+02_r8,9.0332e+01_r8,5.5493e-01_r8/)
      kbo(:, 2,16, 7) = (/ &
     &3.7215e+02_r8,2.7922e+02_r8,1.8629e+02_r8,9.3372e+01_r8,5.5851e-01_r8/)
      kbo(:, 3,16, 7) = (/ &
     &3.8394e+02_r8,2.8806e+02_r8,1.9218e+02_r8,9.6308e+01_r8,5.6035e-01_r8/)
      kbo(:, 4,16, 7) = (/ &
     &3.9518e+02_r8,2.9649e+02_r8,1.9779e+02_r8,9.9106e+01_r8,5.6267e-01_r8/)
      kbo(:, 5,16, 7) = (/ &
     &4.0564e+02_r8,3.0433e+02_r8,2.0302e+02_r8,1.0171e+02_r8,5.6476e-01_r8/)
      kbo(:, 1,17, 7) = (/ &
     &2.4595e+02_r8,1.8458e+02_r8,1.2320e+02_r8,6.1838e+01_r8,5.0905e-01_r8/)
      kbo(:, 2,17, 7) = (/ &
     &2.5413e+02_r8,1.9070e+02_r8,1.2728e+02_r8,6.3868e+01_r8,5.1185e-01_r8/)
      kbo(:, 3,17, 7) = (/ &
     &2.6187e+02_r8,1.9651e+02_r8,1.3115e+02_r8,6.5795e+01_r8,5.1474e-01_r8/)
      kbo(:, 4,17, 7) = (/ &
     &2.6921e+02_r8,2.0201e+02_r8,1.3481e+02_r8,6.7615e+01_r8,5.1865e-01_r8/)
      kbo(:, 5,17, 7) = (/ &
     &2.7688e+02_r8,2.0776e+02_r8,1.3865e+02_r8,6.9531e+01_r8,5.2170e-01_r8/)
      kbo(:, 1,18, 7) = (/ &
     &1.7164e+02_r8,1.2884e+02_r8,8.6050e+01_r8,4.3266e+01_r8,4.6055e-01_r8/)
      kbo(:, 2,18, 7) = (/ &
     &1.7713e+02_r8,1.3296e+02_r8,8.8791e+01_r8,4.4628e+01_r8,4.6405e-01_r8/)
      kbo(:, 3,18, 7) = (/ &
     &1.8233e+02_r8,1.3686e+02_r8,9.1384e+01_r8,4.5916e+01_r8,4.6825e-01_r8/)
      kbo(:, 4,18, 7) = (/ &
     &1.8765e+02_r8,1.4084e+02_r8,9.4032e+01_r8,4.7229e+01_r8,4.7329e-01_r8/)
      kbo(:, 5,18, 7) = (/ &
     &1.9405e+02_r8,1.4564e+02_r8,9.7227e+01_r8,4.8824e+01_r8,4.7705e-01_r8/)
      kbo(:, 1,19, 7) = (/ &
     &1.1725e+02_r8,8.8048e+01_r8,5.8853e+01_r8,2.9674e+01_r8,4.1247e-01_r8/)
      kbo(:, 2,19, 7) = (/ &
     &1.2086e+02_r8,9.0759e+01_r8,6.0656e+01_r8,3.0566e+01_r8,4.1661e-01_r8/)
      kbo(:, 3,19, 7) = (/ &
     &1.2440e+02_r8,9.3403e+01_r8,6.2413e+01_r8,3.1438e+01_r8,4.2213e-01_r8/)
      kbo(:, 4,19, 7) = (/ &
     &1.2864e+02_r8,9.6587e+01_r8,6.4532e+01_r8,3.2489e+01_r8,4.2779e-01_r8/)
      kbo(:, 5,19, 7) = (/ &
     &1.3396e+02_r8,1.0057e+02_r8,6.7181e+01_r8,3.3807e+01_r8,4.3260e-01_r8/)
      kbo(:, 1,20, 7) = (/ &
     &8.6468e+01_r8,6.4964e+01_r8,4.3467e+01_r8,2.2017e+01_r8,3.6582e-01_r8/)
      kbo(:, 2,20, 7) = (/ &
     &8.9024e+01_r8,6.6879e+01_r8,4.4738e+01_r8,2.2636e+01_r8,3.7131e-01_r8/)
      kbo(:, 3,20, 7) = (/ &
     &9.1943e+01_r8,6.9064e+01_r8,4.6188e+01_r8,2.3347e+01_r8,3.7766e-01_r8/)
      kbo(:, 4,20, 7) = (/ &
     &9.5737e+01_r8,7.1906e+01_r8,4.8080e+01_r8,2.4283e+01_r8,3.8413e-01_r8/)
      kbo(:, 5,20, 7) = (/ &
     &1.0032e+02_r8,7.5342e+01_r8,5.0362e+01_r8,2.5410e+01_r8,3.9048e-01_r8/)
      kbo(:, 1,21, 7) = (/ &
     &6.5580e+01_r8,4.9300e+01_r8,3.3030e+01_r8,1.6896e+01_r8,3.2248e-01_r8/)
      kbo(:, 2,21, 7) = (/ &
     &6.7679e+01_r8,5.0870e+01_r8,3.4072e+01_r8,1.7386e+01_r8,3.2902e-01_r8/)
      kbo(:, 3,21, 7) = (/ &
     &7.0353e+01_r8,5.2872e+01_r8,3.5398e+01_r8,1.8022e+01_r8,3.3617e-01_r8/)
      kbo(:, 4,21, 7) = (/ &
     &7.3710e+01_r8,5.5384e+01_r8,3.7067e+01_r8,1.8833e+01_r8,3.4337e-01_r8/)
      kbo(:, 5,21, 7) = (/ &
     &7.7378e+01_r8,5.8129e+01_r8,3.8887e+01_r8,1.9718e+01_r8,3.5091e-01_r8/)
      kbo(:, 1,22, 7) = (/ &
     &5.0990e+01_r8,3.8360e+01_r8,2.5747e+01_r8,1.3390e+01_r8,2.8355e-01_r8/)
      kbo(:, 2,22, 7) = (/ &
     &5.2937e+01_r8,3.9813e+01_r8,2.6706e+01_r8,1.3827e+01_r8,2.9084e-01_r8/)
      kbo(:, 3,22, 7) = (/ &
     &5.5472e+01_r8,4.1712e+01_r8,2.7965e+01_r8,1.4417e+01_r8,2.9863e-01_r8/)
      kbo(:, 4,22, 7) = (/ &
     &5.8295e+01_r8,4.3822e+01_r8,2.9362e+01_r8,1.5079e+01_r8,3.0668e-01_r8/)
      kbo(:, 5,22, 7) = (/ &
     &6.1215e+01_r8,4.6005e+01_r8,3.0807e+01_r8,1.5766e+01_r8,3.1501e-01_r8/)
      kbo(:, 1,23, 7) = (/ &
     &3.9928e+01_r8,3.0064e+01_r8,2.0251e+01_r8,1.0753e+01_r8,2.4875e-01_r8/)
      kbo(:, 2,23, 7) = (/ &
     &4.1783e+01_r8,3.1450e+01_r8,2.1160e+01_r8,1.1173e+01_r8,2.5662e-01_r8/)
      kbo(:, 3,23, 7) = (/ &
     &4.3954e+01_r8,3.3072e+01_r8,2.2227e+01_r8,1.1670e+01_r8,2.6505e-01_r8/)
      kbo(:, 4,23, 7) = (/ &
     &4.6239e+01_r8,3.4779e+01_r8,2.3350e+01_r8,1.2195e+01_r8,2.7351e-01_r8/)
      kbo(:, 5,23, 7) = (/ &
     &4.8555e+01_r8,3.6509e+01_r8,2.4489e+01_r8,1.2725e+01_r8,2.8191e-01_r8/)
      kbo(:, 1,24, 7) = (/ &
     &3.1198e+01_r8,2.3518e+01_r8,1.5962e+01_r8,8.6666e+00_r8,2.1812e-01_r8/)
      kbo(:, 2,24, 7) = (/ &
     &3.2836e+01_r8,2.4742e+01_r8,1.6752e+01_r8,9.0412e+00_r8,2.2642e-01_r8/)
      kbo(:, 3,24, 7) = (/ &
     &3.4586e+01_r8,2.6047e+01_r8,1.7597e+01_r8,9.4445e+00_r8,2.3475e-01_r8/)
      kbo(:, 4,24, 7) = (/ &
     &3.6388e+01_r8,2.7390e+01_r8,1.8470e+01_r8,9.8567e+00_r8,2.4289e-01_r8/)
      kbo(:, 5,24, 7) = (/ &
     &3.8237e+01_r8,2.8772e+01_r8,1.9370e+01_r8,1.0281e+01_r8,2.5096e-01_r8/)
      kbo(:, 1,25, 7) = (/ &
     &2.4765e+01_r8,1.8701e+01_r8,1.2839e+01_r8,7.1044e+00_r8,1.9118e-01_r8/)
      kbo(:, 2,25, 7) = (/ &
     &2.6117e+01_r8,1.9708e+01_r8,1.3481e+01_r8,7.4248e+00_r8,1.9923e-01_r8/)
      kbo(:, 3,25, 7) = (/ &
     &2.7518e+01_r8,2.0749e+01_r8,1.4145e+01_r8,7.7545e+00_r8,2.0704e-01_r8/)
      kbo(:, 4,25, 7) = (/ &
     &2.8948e+01_r8,2.1814e+01_r8,1.4825e+01_r8,8.0892e+00_r8,2.1475e-01_r8/)
      kbo(:, 5,25, 7) = (/ &
     &3.0459e+01_r8,2.2943e+01_r8,1.5551e+01_r8,8.4409e+00_r8,2.2240e-01_r8/)
      kbo(:, 1,26, 7) = (/ &
     &1.9997e+01_r8,1.5145e+01_r8,1.0541e+01_r8,5.9203e+00_r8,1.6734e-01_r8/)
      kbo(:, 2,26, 7) = (/ &
     &2.1098e+01_r8,1.5958e+01_r8,1.1060e+01_r8,6.1929e+00_r8,1.7471e-01_r8/)
      kbo(:, 3,26, 7) = (/ &
     &2.2238e+01_r8,1.6802e+01_r8,1.1594e+01_r8,6.4727e+00_r8,1.8196e-01_r8/)
      kbo(:, 4,26, 7) = (/ &
     &2.3407e+01_r8,1.7668e+01_r8,1.2141e+01_r8,6.7596e+00_r8,1.8921e-01_r8/)
      kbo(:, 5,26, 7) = (/ &
     &2.4698e+01_r8,1.8629e+01_r8,1.2749e+01_r8,7.0654e+00_r8,1.9648e-01_r8/)
      kbo(:, 1,27, 7) = (/ &
     &1.6756e+01_r8,1.2745e+01_r8,8.9780e+00_r8,5.0906e+00_r8,1.4596e-01_r8/)
      kbo(:, 2,27, 7) = (/ &
     &1.7682e+01_r8,1.3422e+01_r8,9.4167e+00_r8,5.3320e+00_r8,1.5263e-01_r8/)
      kbo(:, 3,27, 7) = (/ &
     &1.8639e+01_r8,1.4123e+01_r8,9.8653e+00_r8,5.5814e+00_r8,1.5946e-01_r8/)
      kbo(:, 4,27, 7) = (/ &
     &1.9672e+01_r8,1.4884e+01_r8,1.0349e+01_r8,5.8433e+00_r8,1.6641e-01_r8/)
      kbo(:, 5,27, 7) = (/ &
     &2.0853e+01_r8,1.5759e+01_r8,1.0902e+01_r8,6.1333e+00_r8,1.7345e-01_r8/)
      kbo(:, 1,28, 7) = (/ &
     &1.4405e+01_r8,1.1016e+01_r8,7.8395e+00_r8,4.4691e+00_r8,1.2690e-01_r8/)
      kbo(:, 2,28, 7) = (/ &
     &1.5206e+01_r8,1.1594e+01_r8,8.2236e+00_r8,4.6907e+00_r8,1.3310e-01_r8/)
      kbo(:, 3,28, 7) = (/ &
     &1.6055e+01_r8,1.2210e+01_r8,8.6248e+00_r8,4.9200e+00_r8,1.3960e-01_r8/)
      kbo(:, 4,28, 7) = (/ &
     &1.7030e+01_r8,1.2924e+01_r8,9.0823e+00_r8,5.1747e+00_r8,1.4629e-01_r8/)
      kbo(:, 5,28, 7) = (/ &
     &1.8152e+01_r8,1.3752e+01_r8,9.6123e+00_r8,5.4653e+00_r8,1.5306e-01_r8/)
      kbo(:, 1,29, 7) = (/ &
     &1.3149e+01_r8,1.0099e+01_r8,7.2312e+00_r8,4.1269e+00_r8,1.1016e-01_r8/)
      kbo(:, 2,29, 7) = (/ &
     &1.3892e+01_r8,1.0633e+01_r8,7.5916e+00_r8,4.3391e+00_r8,1.1614e-01_r8/)
      kbo(:, 3,29, 7) = (/ &
     &1.4735e+01_r8,1.1242e+01_r8,7.9958e+00_r8,4.5718e+00_r8,1.2237e-01_r8/)
      kbo(:, 4,29, 7) = (/ &
     &1.5717e+01_r8,1.1957e+01_r8,8.4609e+00_r8,4.8366e+00_r8,1.2878e-01_r8/)
      kbo(:, 5,29, 7) = (/ &
     &1.6850e+01_r8,1.2790e+01_r8,8.9991e+00_r8,5.1366e+00_r8,1.3504e-01_r8/)
      kbo(:, 1,30, 7) = (/ &
     &1.2314e+01_r8,9.4945e+00_r8,6.8243e+00_r8,3.8903e+00_r8,9.5721e-02_r8/)
      kbo(:, 2,30, 7) = (/ &
     &1.3054e+01_r8,1.0024e+01_r8,7.1887e+00_r8,4.1054e+00_r8,1.0142e-01_r8/)
      kbo(:, 3,30, 7) = (/ &
     &1.3921e+01_r8,1.0650e+01_r8,7.6093e+00_r8,4.3517e+00_r8,1.0739e-01_r8/)
      kbo(:, 4,30, 7) = (/ &
     &1.4944e+01_r8,1.1393e+01_r8,8.1010e+00_r8,4.6344e+00_r8,1.1328e-01_r8/)
      kbo(:, 5,30, 7) = (/ &
     &1.6104e+01_r8,1.2245e+01_r8,8.6565e+00_r8,4.9501e+00_r8,1.1877e-01_r8/)
      kbo(:, 1,31, 7) = (/ &
     &1.2157e+01_r8,9.3878e+00_r8,6.7548e+00_r8,3.8381e+00_r8,8.3345e-02_r8/)
      kbo(:, 2,31, 7) = (/ &
     &1.2955e+01_r8,9.9594e+00_r8,7.1498e+00_r8,4.0728e+00_r8,8.8771e-02_r8/)
      kbo(:, 3,31, 7) = (/ &
     &1.3911e+01_r8,1.0649e+01_r8,7.6174e+00_r8,4.3452e+00_r8,9.4250e-02_r8/)
      kbo(:, 4,31, 7) = (/ &
     &1.5017e+01_r8,1.1456e+01_r8,8.1532e+00_r8,4.6551e+00_r8,9.9406e-02_r8/)
      kbo(:, 5,31, 7) = (/ &
     &1.6266e+01_r8,1.2373e+01_r8,8.7552e+00_r8,5.0004e+00_r8,1.0401e-01_r8/)
      kbo(:, 1,32, 7) = (/ &
     &1.2189e+01_r8,9.4190e+00_r8,6.7775e+00_r8,3.8398e+00_r8,7.2780e-02_r8/)
      kbo(:, 2,32, 7) = (/ &
     &1.3084e+01_r8,1.0062e+01_r8,7.2229e+00_r8,4.1020e+00_r8,7.7761e-02_r8/)
      kbo(:, 3,32, 7) = (/ &
     &1.4139e+01_r8,1.0827e+01_r8,7.7437e+00_r8,4.4056e+00_r8,8.2541e-02_r8/)
      kbo(:, 4,32, 7) = (/ &
     &1.5347e+01_r8,1.1710e+01_r8,8.3333e+00_r8,4.7481e+00_r8,8.6905e-02_r8/)
      kbo(:, 5,32, 7) = (/ &
     &1.6687e+01_r8,1.2692e+01_r8,8.9809e+00_r8,5.1206e+00_r8,9.0564e-02_r8/)
      kbo(:, 1,33, 7) = (/ &
     &1.2504e+01_r8,9.6581e+00_r8,6.9429e+00_r8,3.9220e+00_r8,6.3643e-02_r8/)
      kbo(:, 2,33, 7) = (/ &
     &1.3523e+01_r8,1.0393e+01_r8,7.4532e+00_r8,4.2218e+00_r8,6.8037e-02_r8/)
      kbo(:, 3,33, 7) = (/ &
     &1.4701e+01_r8,1.1251e+01_r8,8.0374e+00_r8,4.5635e+00_r8,7.2051e-02_r8/)
      kbo(:, 4,33, 7) = (/ &
     &1.6035e+01_r8,1.2227e+01_r8,8.6879e+00_r8,4.9410e+00_r8,7.5520e-02_r8/)
      kbo(:, 5,33, 7) = (/ &
     &1.7498e+01_r8,1.3301e+01_r8,9.3946e+00_r8,5.3470e+00_r8,7.8343e-02_r8/)
      kbo(:, 1,34, 7) = (/ &
     &1.2544e+01_r8,9.6932e+00_r8,6.9709e+00_r8,3.9324e+00_r8,5.5495e-02_r8/)
      kbo(:, 2,34, 7) = (/ &
     &1.3652e+01_r8,1.0495e+01_r8,7.5288e+00_r8,4.2613e+00_r8,5.9207e-02_r8/)
      kbo(:, 3,34, 7) = (/ &
     &1.4931e+01_r8,1.1428e+01_r8,8.1665e+00_r8,4.6328e+00_r8,6.2449e-02_r8/)
      kbo(:, 4,34, 7) = (/ &
     &1.6342e+01_r8,1.2460e+01_r8,8.8567e+00_r8,5.0367e+00_r8,6.5144e-02_r8/)
      kbo(:, 5,34, 7) = (/ &
     &1.7926e+01_r8,1.3623e+01_r8,9.6166e+00_r8,5.4694e+00_r8,6.7469e-02_r8/)
      kbo(:, 1,35, 7) = (/ &
     &1.2550e+01_r8,9.7037e+00_r8,6.9833e+00_r8,3.9358e+00_r8,4.7960e-02_r8/)
      kbo(:, 2,35, 7) = (/ &
     &1.3742e+01_r8,1.0569e+01_r8,7.5854e+00_r8,4.2904e+00_r8,5.1023e-02_r8/)
      kbo(:, 3,35, 7) = (/ &
     &1.5093e+01_r8,1.1555e+01_r8,8.2621e+00_r8,4.6878e+00_r8,5.3624e-02_r8/)
      kbo(:, 4,35, 7) = (/ &
     &1.6591e+01_r8,1.2650e+01_r8,8.9950e+00_r8,5.1151e+00_r8,5.5900e-02_r8/)
      kbo(:, 5,35, 7) = (/ &
     &1.8304e+01_r8,1.3907e+01_r8,9.8148e+00_r8,5.5812e+00_r8,5.7988e-02_r8/)
      kbo(:, 1,36, 7) = (/ &
     &1.2397e+01_r8,9.5976e+00_r8,6.9138e+00_r8,3.8949e+00_r8,4.1048e-02_r8/)
      kbo(:, 2,36, 7) = (/ &
     &1.3655e+01_r8,1.0513e+01_r8,7.5553e+00_r8,4.2704e+00_r8,4.3574e-02_r8/)
      kbo(:, 3,36, 7) = (/ &
     &1.5056e+01_r8,1.1535e+01_r8,8.2577e+00_r8,4.6863e+00_r8,4.5767e-02_r8/)
      kbo(:, 4,36, 7) = (/ &
     &1.6621e+01_r8,1.2678e+01_r8,9.0220e+00_r8,5.1309e+00_r8,4.7778e-02_r8/)
      kbo(:, 5,36, 7) = (/ &
     &1.8454e+01_r8,1.4024e+01_r8,9.9036e+00_r8,5.6291e+00_r8,4.9683e-02_r8/)
      kbo(:, 1,37, 7) = (/ &
     &1.1793e+01_r8,9.1604e+00_r8,6.6146e+00_r8,3.7234e+00_r8,3.4707e-02_r8/)
      kbo(:, 2,37, 7) = (/ &
     &1.3041e+01_r8,1.0070e+01_r8,7.2604e+00_r8,4.1046e+00_r8,3.6864e-02_r8/)
      kbo(:, 3,37, 7) = (/ &
     &1.4439e+01_r8,1.1088e+01_r8,7.9659e+00_r8,4.5244e+00_r8,3.8795e-02_r8/)
      kbo(:, 4,37, 7) = (/ &
     &1.6025e+01_r8,1.2245e+01_r8,8.7442e+00_r8,4.9773e+00_r8,4.0613e-02_r8/)
      kbo(:, 5,37, 7) = (/ &
     &1.7882e+01_r8,1.3605e+01_r8,9.6420e+00_r8,5.4880e+00_r8,4.2339e-02_r8/)
      kbo(:, 1,38, 7) = (/ &
     &1.1383e+01_r8,8.8666e+00_r8,6.4134e+00_r8,3.6072e+00_r8,2.9298e-02_r8/)
      kbo(:, 2,38, 7) = (/ &
     &1.2643e+01_r8,9.7859e+00_r8,7.0699e+00_r8,3.9972e+00_r8,3.1148e-02_r8/)
      kbo(:, 3,38, 7) = (/ &
     &1.4056e+01_r8,1.0814e+01_r8,7.7862e+00_r8,4.4229e+00_r8,3.2867e-02_r8/)
      kbo(:, 4,38, 7) = (/ &
     &1.5686e+01_r8,1.2002e+01_r8,8.5915e+00_r8,4.8935e+00_r8,3.4517e-02_r8/)
      kbo(:, 5,38, 7) = (/ &
     &1.7595e+01_r8,1.3400e+01_r8,9.5179e+00_r8,5.4208e+00_r8,3.6067e-02_r8/)
      kbo(:, 1,39, 7) = (/ &
     &1.1254e+01_r8,8.7785e+00_r8,6.3532e+00_r8,3.5698e+00_r8,2.4703e-02_r8/)
      kbo(:, 2,39, 7) = (/ &
     &1.2546e+01_r8,9.7238e+00_r8,7.0319e+00_r8,3.9725e+00_r8,2.6328e-02_r8/)
      kbo(:, 3,39, 7) = (/ &
     &1.4010e+01_r8,1.0789e+01_r8,7.7764e+00_r8,4.4152e+00_r8,2.7854e-02_r8/)
      kbo(:, 4,39, 7) = (/ &
     &1.5714e+01_r8,1.2031e+01_r8,8.6190e+00_r8,4.9070e+00_r8,2.9325e-02_r8/)
      kbo(:, 5,39, 7) = (/ &
     &1.7752e+01_r8,1.3525e+01_r8,9.6124e+00_r8,5.4718e+00_r8,3.0788e-02_r8/)
      kbo(:, 1,40, 7) = (/ &
     &1.0343e+01_r8,8.1149e+00_r8,5.8880e+00_r8,3.3077e+00_r8,2.0662e-02_r8/)
      kbo(:, 2,40, 7) = (/ &
     &1.1581e+01_r8,9.0215e+00_r8,6.5477e+00_r8,3.7008e+00_r8,2.2084e-02_r8/)
      kbo(:, 3,40, 7) = (/ &
     &1.2986e+01_r8,1.0044e+01_r8,7.2710e+00_r8,4.1322e+00_r8,2.3431e-02_r8/)
      kbo(:, 4,40, 7) = (/ &
     &1.4638e+01_r8,1.1247e+01_r8,8.0993e+00_r8,4.6196e+00_r8,2.4776e-02_r8/)
      kbo(:, 5,40, 7) = (/ &
     &1.6625e+01_r8,1.2700e+01_r8,9.0740e+00_r8,5.1787e+00_r8,2.6103e-02_r8/)
      kbo(:, 1,41, 7) = (/ &
     &9.4683e+00_r8,7.4757e+00_r8,5.4378e+00_r8,3.0540e+00_r8,1.7243e-02_r8/)
      kbo(:, 2,41, 7) = (/ &
     &1.0645e+01_r8,8.3400e+00_r8,6.0743e+00_r8,3.4334e+00_r8,1.8487e-02_r8/)
      kbo(:, 3,41, 7) = (/ &
     &1.1996e+01_r8,9.3250e+00_r8,6.7794e+00_r8,3.8546e+00_r8,1.9684e-02_r8/)
      kbo(:, 4,41, 7) = (/ &
     &1.3587e+01_r8,1.0480e+01_r8,7.5843e+00_r8,4.3322e+00_r8,2.0909e-02_r8/)
      kbo(:, 5,41, 7) = (/ &
     &1.5513e+01_r8,1.1886e+01_r8,8.5396e+00_r8,4.8864e+00_r8,2.2113e-02_r8/)
      kbo(:, 1,42, 7) = (/ &
     &8.7596e+00_r8,6.9575e+00_r8,5.0695e+00_r8,2.8442e+00_r8,1.4375e-02_r8/)
      kbo(:, 2,42, 7) = (/ &
     &9.8918e+00_r8,7.7921e+00_r8,5.6895e+00_r8,3.2145e+00_r8,1.5469e-02_r8/)
      kbo(:, 3,42, 7) = (/ &
     &1.1196e+01_r8,8.7450e+00_r8,6.3808e+00_r8,3.6290e+00_r8,1.6542e-02_r8/)
      kbo(:, 4,42, 7) = (/ &
     &1.2750e+01_r8,9.8741e+00_r8,7.1757e+00_r8,4.1018e+00_r8,1.7643e-02_r8/)
      kbo(:, 5,42, 7) = (/ &
     &1.4631e+01_r8,1.1244e+01_r8,8.1146e+00_r8,4.6494e+00_r8,1.8736e-02_r8/)
      kbo(:, 1,43, 7) = (/ &
     &8.1129e+00_r8,6.4828e+00_r8,4.7282e+00_r8,2.6502e+00_r8,1.1920e-02_r8/)
      kbo(:, 2,43, 7) = (/ &
     &9.2040e+00_r8,7.2919e+00_r8,5.3332e+00_r8,3.0110e+00_r8,1.2884e-02_r8/)
      kbo(:, 3,43, 7) = (/ &
     &1.0467e+01_r8,8.2176e+00_r8,6.0123e+00_r8,3.4195e+00_r8,1.3839e-02_r8/)
      kbo(:, 4,43, 7) = (/ &
     &1.1975e+01_r8,9.3139e+00_r8,6.7911e+00_r8,3.8837e+00_r8,1.4824e-02_r8/)
      kbo(:, 5,43, 7) = (/ &
     &1.3821e+01_r8,1.0658e+01_r8,7.7247e+00_r8,4.4294e+00_r8,1.5816e-02_r8/)
      kbo(:, 1,44, 7) = (/ &
     &7.5813e+00_r8,6.0889e+00_r8,4.4438e+00_r8,2.4886e+00_r8,9.8504e-03_r8/)
      kbo(:, 2,44, 7) = (/ &
     &8.6433e+00_r8,6.8838e+00_r8,5.0388e+00_r8,2.8416e+00_r8,1.0695e-02_r8/)
      kbo(:, 3,44, 7) = (/ &
     &9.8815e+00_r8,7.7937e+00_r8,5.7119e+00_r8,3.2452e+00_r8,1.1549e-02_r8/)
      kbo(:, 4,44, 7) = (/ &
     &1.1354e+01_r8,8.8664e+00_r8,6.4827e+00_r8,3.7047e+00_r8,1.2430e-02_r8/)
      kbo(:, 5,44, 7) = (/ &
     &1.3162e+01_r8,1.0183e+01_r8,7.4060e+00_r8,4.2473e+00_r8,1.3335e-02_r8/)
      kbo(:, 1,45, 7) = (/ &
     &7.2186e+00_r8,5.8199e+00_r8,4.2461e+00_r8,2.3747e+00_r8,8.1314e-03_r8/)
      kbo(:, 2,45, 7) = (/ &
     &8.2698e+00_r8,6.6114e+00_r8,4.8385e+00_r8,2.7251e+00_r8,8.8750e-03_r8/)
      kbo(:, 3,45, 7) = (/ &
     &9.5031e+00_r8,7.5246e+00_r8,5.5174e+00_r8,3.1306e+00_r8,9.6297e-03_r8/)
      kbo(:, 4,45, 7) = (/ &
     &1.0974e+01_r8,8.5972e+00_r8,6.2944e+00_r8,3.5936e+00_r8,1.0417e-02_r8/)
      kbo(:, 5,45, 7) = (/ &
     &1.2791e+01_r8,9.9194e+00_r8,7.2286e+00_r8,4.1456e+00_r8,1.1234e-02_r8/)
      kbo(:, 1,46, 7) = (/ &
     &6.9141e+00_r8,5.5940e+00_r8,4.0776e+00_r8,2.2758e+00_r8,6.6876e-03_r8/)
      kbo(:, 2,46, 7) = (/ &
     &7.9503e+00_r8,6.3788e+00_r8,4.6670e+00_r8,2.6226e+00_r8,7.3399e-03_r8/)
      kbo(:, 3,46, 7) = (/ &
     &9.1864e+00_r8,7.2991e+00_r8,5.3560e+00_r8,3.0335e+00_r8,8.0038e-03_r8/)
      kbo(:, 4,46, 7) = (/ &
     &1.0667e+01_r8,8.3803e+00_r8,6.1440e+00_r8,3.5030e+00_r8,8.7040e-03_r8/)
      kbo(:, 5,46, 7) = (/ &
     &1.2488e+01_r8,9.7091e+00_r8,7.0857e+00_r8,4.0595e+00_r8,9.4400e-03_r8/)
      kbo(:, 1,47, 7) = (/ &
     &6.5158e+00_r8,5.2952e+00_r8,3.8553e+00_r8,2.1461e+00_r8,5.4578e-03_r8/)
      kbo(:, 2,47, 7) = (/ &
     &7.5125e+00_r8,6.0542e+00_r8,4.4282e+00_r8,2.4823e+00_r8,6.0287e-03_r8/)
      kbo(:, 3,47, 7) = (/ &
     &8.7277e+00_r8,6.9654e+00_r8,5.1130e+00_r8,2.8905e+00_r8,6.6123e-03_r8/)
      kbo(:, 4,47, 7) = (/ &
     &1.0180e+01_r8,8.0330e+00_r8,5.8977e+00_r8,3.3599e+00_r8,7.2304e-03_r8/)
      kbo(:, 5,47, 7) = (/ &
     &1.1985e+01_r8,9.3498e+00_r8,6.8393e+00_r8,3.9162e+00_r8,7.8875e-03_r8/)
      kbo(:, 1,48, 7) = (/ &
     &6.3104e+00_r8,5.1398e+00_r8,3.7343e+00_r8,2.0712e+00_r8,4.4438e-03_r8/)
      kbo(:, 2,48, 7) = (/ &
     &7.2865e+00_r8,5.8865e+00_r8,4.2999e+00_r8,2.4038e+00_r8,4.9412e-03_r8/)
      kbo(:, 3,48, 7) = (/ &
     &8.5071e+00_r8,6.8079e+00_r8,4.9920e+00_r8,2.8153e+00_r8,5.4521e-03_r8/)
      kbo(:, 4,48, 7) = (/ &
     &9.9728e+00_r8,7.8905e+00_r8,5.7928e+00_r8,3.2942e+00_r8,5.9945e-03_r8/)
      kbo(:, 5,48, 7) = (/ &
     &1.1799e+01_r8,9.2259e+00_r8,6.7537e+00_r8,3.8639e+00_r8,6.5748e-03_r8/)
      kbo(:, 1,49, 7) = (/ &
     &6.3637e+00_r8,5.1793e+00_r8,3.7516e+00_r8,2.0723e+00_r8,3.6085e-03_r8/)
      kbo(:, 2,49, 7) = (/ &
     &7.3474e+00_r8,5.9332e+00_r8,4.3233e+00_r8,2.4087e+00_r8,4.0406e-03_r8/)
      kbo(:, 3,49, 7) = (/ &
     &8.6221e+00_r8,6.8978e+00_r8,5.0458e+00_r8,2.8357e+00_r8,4.4876e-03_r8/)
      kbo(:, 4,49, 7) = (/ &
     &1.0155e+01_r8,8.0340e+00_r8,5.8866e+00_r8,3.3379e+00_r8,4.9641e-03_r8/)
      kbo(:, 5,49, 7) = (/ &
     &1.2071e+01_r8,9.4371e+00_r8,6.8986e+00_r8,3.9361e+00_r8,5.4780e-03_r8/)
      kbo(:, 1,50, 7) = (/ &
     &6.1287e+00_r8,4.9982e+00_r8,3.6130e+00_r8,1.9898e+00_r8,2.9263e-03_r8/)
      kbo(:, 2,50, 7) = (/ &
     &7.0793e+00_r8,5.7315e+00_r8,4.1690e+00_r8,2.3166e+00_r8,3.3022e-03_r8/)
      kbo(:, 3,50, 7) = (/ &
     &8.3385e+00_r8,6.6892e+00_r8,4.8872e+00_r8,2.7388e+00_r8,3.6894e-03_r8/)
      kbo(:, 4,50, 7) = (/ &
     &9.8705e+00_r8,7.8310e+00_r8,5.7364e+00_r8,3.2460e+00_r8,4.1061e-03_r8/)
      kbo(:, 5,50, 7) = (/ &
     &1.1792e+01_r8,9.2428e+00_r8,6.7611e+00_r8,3.8534e+00_r8,4.5631e-03_r8/)
      kbo(:, 1,51, 7) = (/ &
     &5.7768e+00_r8,4.7273e+00_r8,3.4121e+00_r8,1.8743e+00_r8,2.3693e-03_r8/)
      kbo(:, 2,51, 7) = (/ &
     &6.6763e+00_r8,5.4272e+00_r8,3.9426e+00_r8,2.1849e+00_r8,2.6931e-03_r8/)
      kbo(:, 3,51, 7) = (/ &
     &7.8931e+00_r8,6.3576e+00_r8,4.6398e+00_r8,2.5939e+00_r8,3.0298e-03_r8/)
      kbo(:, 4,51, 7) = (/ &
     &9.3905e+00_r8,7.4818e+00_r8,5.4825e+00_r8,3.0966e+00_r8,3.3909e-03_r8/)
      kbo(:, 5,51, 7) = (/ &
     &1.1270e+01_r8,8.8663e+00_r8,6.4953e+00_r8,3.6986e+00_r8,3.7911e-03_r8/)
      kbo(:, 1,52, 7) = (/ &
     &5.5982e+00_r8,4.5875e+00_r8,3.3045e+00_r8,1.8093e+00_r8,1.9133e-03_r8/)
      kbo(:, 2,52, 7) = (/ &
     &6.4669e+00_r8,5.2676e+00_r8,3.8189e+00_r8,2.1105e+00_r8,2.1929e-03_r8/)
      kbo(:, 3,52, 7) = (/ &
     &7.6692e+00_r8,6.1904e+00_r8,4.5114e+00_r8,2.5133e+00_r8,2.4833e-03_r8/)
      kbo(:, 4,52, 7) = (/ &
     &9.1760e+00_r8,7.3261e+00_r8,5.3623e+00_r8,3.0203e+00_r8,2.7953e-03_r8/)
      kbo(:, 5,52, 7) = (/ &
     &1.1059e+01_r8,8.7181e+00_r8,6.3851e+00_r8,3.6291e+00_r8,3.1452e-03_r8/)
      kbo(:, 1,53, 7) = (/ &
     &5.6498e+00_r8,4.6222e+00_r8,3.3203e+00_r8,1.8115e+00_r8,1.5408e-03_r8/)
      kbo(:, 2,53, 7) = (/ &
     &6.5197e+00_r8,5.3054e+00_r8,3.8365e+00_r8,2.1129e+00_r8,1.7821e-03_r8/)
      kbo(:, 3,53, 7) = (/ &
     &7.7464e+00_r8,6.2478e+00_r8,4.5414e+00_r8,2.5222e+00_r8,2.0319e-03_r8/)
      kbo(:, 4,53, 7) = (/ &
     &9.3204e+00_r8,7.4376e+00_r8,5.4308e+00_r8,3.0476e+00_r8,2.3029e-03_r8/)
      kbo(:, 5,53, 7) = (/ &
     &1.1294e+01_r8,8.9013e+00_r8,6.5042e+00_r8,3.6848e+00_r8,2.6089e-03_r8/)
      kbo(:, 1,54, 7) = (/ &
     &4.9410e+00_r8,4.0701e+00_r8,2.9220e+00_r8,1.5920e+00_r8,1.2393e-03_r8/)
      kbo(:, 2,54, 7) = (/ &
     &5.7011e+00_r8,4.6779e+00_r8,3.3818e+00_r8,1.8599e+00_r8,1.4465e-03_r8/)
      kbo(:, 3,54, 7) = (/ &
     &6.7851e+00_r8,5.5214e+00_r8,4.0167e+00_r8,2.2288e+00_r8,1.6602e-03_r8/)
      kbo(:, 4,54, 7) = (/ &
     &8.2133e+00_r8,6.6133e+00_r8,4.8372e+00_r8,2.7129e+00_r8,1.8918e-03_r8/)
      kbo(:, 5,54, 7) = (/ &
     &1.0009e+01_r8,7.9570e+00_r8,5.8358e+00_r8,3.3045e+00_r8,2.1561e-03_r8/)
      kbo(:, 1,55, 7) = (/ &
     &3.9448e+00_r8,3.2894e+00_r8,2.3617e+00_r8,1.2863e+00_r8,9.9479e-04_r8/)
      kbo(:, 2,55, 7) = (/ &
     &4.5510e+00_r8,3.7868e+00_r8,2.7406e+00_r8,1.5076e+00_r8,1.1698e-03_r8/)
      kbo(:, 3,55, 7) = (/ &
     &5.4272e+00_r8,4.4849e+00_r8,3.2681e+00_r8,1.8142e+00_r8,1.3510e-03_r8/)
      kbo(:, 4,55, 7) = (/ &
     &6.6050e+00_r8,5.4031e+00_r8,3.9651e+00_r8,2.2259e+00_r8,1.5494e-03_r8/)
      kbo(:, 5,55, 7) = (/ &
     &8.0992e+00_r8,6.5420e+00_r8,4.8249e+00_r8,2.7373e+00_r8,1.7731e-03_r8/)
      kbo(:, 1,56, 7) = (/ &
     &3.1456e+00_r8,2.6539e+00_r8,1.9051e+00_r8,1.0370e+00_r8,7.9618e-04_r8/)
      kbo(:, 2,56, 7) = (/ &
     &3.6287e+00_r8,3.0618e+00_r8,2.2169e+00_r8,1.2199e+00_r8,9.4437e-04_r8/)
      kbo(:, 3,56, 7) = (/ &
     &4.3315e+00_r8,3.6363e+00_r8,2.6526e+00_r8,1.4737e+00_r8,1.0978e-03_r8/)
      kbo(:, 4,56, 7) = (/ &
     &5.3003e+00_r8,4.4092e+00_r8,3.2425e+00_r8,1.8210e+00_r8,1.2654e-03_r8/)
      kbo(:, 5,56, 7) = (/ &
     &6.5412e+00_r8,5.3749e+00_r8,3.9813e+00_r8,2.2622e+00_r8,1.4546e-03_r8/)
      kbo(:, 1,57, 7) = (/ &
     &2.5050e+00_r8,2.1372e+00_r8,1.5333e+00_r8,8.3409e-01_r8,6.3524e-04_r8/)
      kbo(:, 2,57, 7) = (/ &
     &2.8897e+00_r8,2.4717e+00_r8,1.7900e+00_r8,9.8489e-01_r8,7.5959e-04_r8/)
      kbo(:, 3,57, 7) = (/ &
     &3.4502e+00_r8,2.9412e+00_r8,2.1481e+00_r8,1.1943e+00_r8,8.8948e-04_r8/)
      kbo(:, 4,57, 7) = (/ &
     &4.2411e+00_r8,3.5892e+00_r8,2.6434e+00_r8,1.4858e+00_r8,1.0311e-03_r8/)
      kbo(:, 5,57, 7) = (/ &
     &5.2712e+00_r8,4.4105e+00_r8,3.2776e+00_r8,1.8647e+00_r8,1.1913e-03_r8/)
      kbo(:, 1,58, 7) = (/ &
     &5.2639e-01_r8,5.5628e-01_r8,5.1310e-01_r8,3.9091e-01_r8,5.0641e-04_r8/)
      kbo(:, 2,58, 7) = (/ &
     &6.0772e-01_r8,6.4553e-01_r8,6.0135e-01_r8,4.6372e-01_r8,6.1035e-04_r8/)
      kbo(:, 3,58, 7) = (/ &
     &7.2539e-01_r8,7.7016e-01_r8,7.2403e-01_r8,5.6463e-01_r8,7.2056e-04_r8/)
      kbo(:, 4,58, 7) = (/ &
     &8.9558e-01_r8,9.4507e-01_r8,8.9682e-01_r8,7.0739e-01_r8,8.3918e-04_r8/)
      kbo(:, 5,58, 7) = (/ &
     &1.1215e+00_r8,1.1728e+00_r8,1.1240e+00_r8,8.9769e-01_r8,9.7498e-04_r8/)
      kbo(:, 1,59, 7) = (/ &
     &5.0774e-01_r8,5.2725e-01_r8,4.5400e-01_r8,3.0925e-01_r8,4.1598e-04_r8/)
      kbo(:, 2,59, 7) = (/ &
     &5.8906e-01_r8,6.1772e-01_r8,5.3777e-01_r8,3.7151e-01_r8,5.0342e-04_r8/)
      kbo(:, 3,59, 7) = (/ &
     &7.0796e-01_r8,7.4490e-01_r8,6.5525e-01_r8,4.5851e-01_r8,5.9609e-04_r8/)
      kbo(:, 4,59, 7) = (/ &
     &8.8130e-01_r8,9.2517e-01_r8,8.2251e-01_r8,5.8308e-01_r8,6.9661e-04_r8/)
      kbo(:, 5,59, 7) = (/ &
     &1.1130e+00_r8,1.1619e+00_r8,1.0449e+00_r8,7.5118e-01_r8,8.1226e-04_r8/)
      kbo(:, 1,13, 8) = (/ &
     &5.5674e+03_r8,4.1757e+03_r8,2.7839e+03_r8,1.3922e+03_r8,1.1827e+00_r8/)
      kbo(:, 2,13, 8) = (/ &
     &5.5672e+03_r8,4.1755e+03_r8,2.7838e+03_r8,1.3922e+03_r8,1.1780e+00_r8/)
      kbo(:, 3,13, 8) = (/ &
     &5.5974e+03_r8,4.1981e+03_r8,2.7989e+03_r8,1.3997e+03_r8,1.1714e+00_r8/)
      kbo(:, 4,13, 8) = (/ &
     &5.6743e+03_r8,4.2558e+03_r8,2.8374e+03_r8,1.4189e+03_r8,1.1612e+00_r8/)
      kbo(:, 5,13, 8) = (/ &
     &5.7999e+03_r8,4.3500e+03_r8,2.9002e+03_r8,1.4503e+03_r8,1.1566e+00_r8/)
      kbo(:, 1,14, 8) = (/ &
     &3.0072e+03_r8,2.2555e+03_r8,1.5038e+03_r8,7.5211e+02_r8,1.1873e+00_r8/)
      kbo(:, 2,14, 8) = (/ &
     &3.0260e+03_r8,2.2696e+03_r8,1.5132e+03_r8,7.5683e+02_r8,1.1778e+00_r8/)
      kbo(:, 3,14, 8) = (/ &
     &3.0739e+03_r8,2.3055e+03_r8,1.5371e+03_r8,7.6880e+02_r8,1.1759e+00_r8/)
      kbo(:, 4,14, 8) = (/ &
     &3.1534e+03_r8,2.3651e+03_r8,1.5769e+03_r8,7.8868e+02_r8,1.1686e+00_r8/)
      kbo(:, 5,14, 8) = (/ &
     &3.2601e+03_r8,2.4451e+03_r8,1.6302e+03_r8,8.1536e+02_r8,1.1588e+00_r8/)
      kbo(:, 1,15, 8) = (/ &
     &1.6681e+03_r8,1.2512e+03_r8,8.3428e+02_r8,4.1737e+02_r8,1.1796e+00_r8/)
      kbo(:, 2,15, 8) = (/ &
     &1.6959e+03_r8,1.2720e+03_r8,8.4818e+02_r8,4.2432e+02_r8,1.1712e+00_r8/)
      kbo(:, 3,15, 8) = (/ &
     &1.7438e+03_r8,1.3080e+03_r8,8.7214e+02_r8,4.3631e+02_r8,1.1630e+00_r8/)
      kbo(:, 4,15, 8) = (/ &
     &1.8057e+03_r8,1.3544e+03_r8,9.0311e+02_r8,4.5180e+02_r8,1.1584e+00_r8/)
      kbo(:, 5,15, 8) = (/ &
     &1.8729e+03_r8,1.4048e+03_r8,9.3671e+02_r8,4.6860e+02_r8,1.1490e+00_r8/)
      kbo(:, 1,16, 8) = (/ &
     &1.1127e+03_r8,8.3463e+02_r8,5.5657e+02_r8,2.7851e+02_r8,1.1544e+00_r8/)
      kbo(:, 2,16, 8) = (/ &
     &1.1452e+03_r8,8.5902e+02_r8,5.7284e+02_r8,2.8665e+02_r8,1.1489e+00_r8/)
      kbo(:, 3,16, 8) = (/ &
     &1.1859e+03_r8,8.8958e+02_r8,5.9321e+02_r8,2.9685e+02_r8,1.1423e+00_r8/)
      kbo(:, 4,16, 8) = (/ &
     &1.2314e+03_r8,9.2370e+02_r8,6.1596e+02_r8,3.0822e+02_r8,1.1380e+00_r8/)
      kbo(:, 5,16, 8) = (/ &
     &1.2793e+03_r8,9.5963e+02_r8,6.3991e+02_r8,3.2020e+02_r8,1.1307e+00_r8/)
      kbo(:, 1,17, 8) = (/ &
     &7.7661e+02_r8,5.8258e+02_r8,3.8854e+02_r8,1.9450e+02_r8,1.1162e+00_r8/)
      kbo(:, 2,17, 8) = (/ &
     &8.0415e+02_r8,6.0323e+02_r8,4.0231e+02_r8,2.0139e+02_r8,1.1130e+00_r8/)
      kbo(:, 3,17, 8) = (/ &
     &8.3554e+02_r8,6.2677e+02_r8,4.1801e+02_r8,2.0924e+02_r8,1.1093e+00_r8/)
      kbo(:, 4,17, 8) = (/ &
     &8.6787e+02_r8,6.5102e+02_r8,4.3418e+02_r8,2.1733e+02_r8,1.1057e+00_r8/)
      kbo(:, 5,17, 8) = (/ &
     &9.0039e+02_r8,6.7541e+02_r8,4.5043e+02_r8,2.2545e+02_r8,1.0994e+00_r8/)
      kbo(:, 1,18, 8) = (/ &
     &5.5593e+02_r8,4.1706e+02_r8,2.7819e+02_r8,1.3933e+02_r8,1.0653e+00_r8/)
      kbo(:, 2,18, 8) = (/ &
     &5.7731e+02_r8,4.3309e+02_r8,2.8888e+02_r8,1.4467e+02_r8,1.0637e+00_r8/)
      kbo(:, 3,18, 8) = (/ &
     &5.9962e+02_r8,4.4983e+02_r8,3.0005e+02_r8,1.5026e+02_r8,1.0625e+00_r8/)
      kbo(:, 4,18, 8) = (/ &
     &6.2213e+02_r8,4.6672e+02_r8,3.1130e+02_r8,1.5589e+02_r8,1.0595e+00_r8/)
      kbo(:, 5,18, 8) = (/ &
     &6.4470e+02_r8,4.8364e+02_r8,3.2258e+02_r8,1.6152e+02_r8,1.0552e+00_r8/)
      kbo(:, 1,19, 8) = (/ &
     &3.9059e+02_r8,2.9306e+02_r8,1.9552e+02_r8,9.7992e+01_r8,1.0025e+00_r8/)
      kbo(:, 2,19, 8) = (/ &
     &4.0544e+02_r8,3.0420e+02_r8,2.0295e+02_r8,1.0172e+02_r8,1.0019e+00_r8/)
      kbo(:, 3,19, 8) = (/ &
     &4.2056e+02_r8,3.1554e+02_r8,2.1052e+02_r8,1.0550e+02_r8,1.0025e+00_r8/)
      kbo(:, 4,19, 8) = (/ &
     &4.3576e+02_r8,3.2693e+02_r8,2.1811e+02_r8,1.0930e+02_r8,1.0012e+00_r8/)
      kbo(:, 5,19, 8) = (/ &
     &4.5126e+02_r8,3.3856e+02_r8,2.2586e+02_r8,1.1317e+02_r8,9.9899e-01_r8/)
      kbo(:, 1,20, 8) = (/ &
     &2.9617e+02_r8,2.2224e+02_r8,1.4831e+02_r8,7.4392e+01_r8,9.3059e-01_r8/)
      kbo(:, 2,20, 8) = (/ &
     &3.0716e+02_r8,2.3049e+02_r8,1.5382e+02_r8,7.7154e+01_r8,9.3219e-01_r8/)
      kbo(:, 3,20, 8) = (/ &
     &3.1816e+02_r8,2.3874e+02_r8,1.5932e+02_r8,7.9908e+01_r8,9.3370e-01_r8/)
      kbo(:, 4,20, 8) = (/ &
     &3.2952e+02_r8,2.4726e+02_r8,1.6500e+02_r8,8.2741e+01_r8,9.3435e-01_r8/)
      kbo(:, 5,20, 8) = (/ &
     &3.4150e+02_r8,2.5625e+02_r8,1.7099e+02_r8,8.5741e+01_r8,9.3474e-01_r8/)
      kbo(:, 1,21, 8) = (/ &
     &2.3042e+02_r8,1.7293e+02_r8,1.1544e+02_r8,5.7965e+01_r8,8.5235e-01_r8/)
      kbo(:, 2,21, 8) = (/ &
     &2.3880e+02_r8,1.7922e+02_r8,1.1964e+02_r8,6.0070e+01_r8,8.5599e-01_r8/)
      kbo(:, 3,21, 8) = (/ &
     &2.4721e+02_r8,1.8553e+02_r8,1.2385e+02_r8,6.2177e+01_r8,8.5938e-01_r8/)
      kbo(:, 4,21, 8) = (/ &
     &2.5622e+02_r8,1.9229e+02_r8,1.2835e+02_r8,6.4426e+01_r8,8.6241e-01_r8/)
      kbo(:, 5,21, 8) = (/ &
     &2.6653e+02_r8,2.0002e+02_r8,1.3351e+02_r8,6.7009e+01_r8,8.6670e-01_r8/)
      kbo(:, 1,22, 8) = (/ &
     &1.8346e+02_r8,1.3771e+02_r8,9.1962e+01_r8,4.6247e+01_r8,7.7175e-01_r8/)
      kbo(:, 2,22, 8) = (/ &
     &1.8996e+02_r8,1.4259e+02_r8,9.5222e+01_r8,4.7880e+01_r8,7.7757e-01_r8/)
      kbo(:, 3,22, 8) = (/ &
     &1.9685e+02_r8,1.4775e+02_r8,9.8665e+01_r8,4.9599e+01_r8,7.8369e-01_r8/)
      kbo(:, 4,22, 8) = (/ &
     &2.0481e+02_r8,1.5373e+02_r8,1.0265e+02_r8,5.1591e+01_r8,7.9052e-01_r8/)
      kbo(:, 5,22, 8) = (/ &
     &2.1438e+02_r8,1.6091e+02_r8,1.0745e+02_r8,5.3989e+01_r8,7.9865e-01_r8/)
      kbo(:, 1,23, 8) = (/ &
     &1.4619e+02_r8,1.0976e+02_r8,7.3333e+01_r8,3.7009e+01_r8,6.9269e-01_r8/)
      kbo(:, 2,23, 8) = (/ &
     &1.5146e+02_r8,1.1371e+02_r8,7.5969e+01_r8,3.8312e+01_r8,7.0058e-01_r8/)
      kbo(:, 3,23, 8) = (/ &
     &1.5752e+02_r8,1.1826e+02_r8,7.9004e+01_r8,3.9812e+01_r8,7.0997e-01_r8/)
      kbo(:, 4,23, 8) = (/ &
     &1.6498e+02_r8,1.2386e+02_r8,8.2742e+01_r8,4.1669e+01_r8,7.2082e-01_r8/)
      kbo(:, 5,23, 8) = (/ &
     &1.7382e+02_r8,1.3049e+02_r8,8.7175e+01_r8,4.3881e+01_r8,7.3247e-01_r8/)
      kbo(:, 1,24, 8) = (/ &
     &1.1546e+02_r8,8.6713e+01_r8,5.7975e+01_r8,2.9484e+01_r8,6.1736e-01_r8/)
      kbo(:, 2,24, 8) = (/ &
     &1.1997e+02_r8,9.0096e+01_r8,6.0229e+01_r8,3.0574e+01_r8,6.2822e-01_r8/)
      kbo(:, 3,24, 8) = (/ &
     &1.2560e+02_r8,9.4324e+01_r8,6.3051e+01_r8,3.1946e+01_r8,6.4118e-01_r8/)
      kbo(:, 4,24, 8) = (/ &
     &1.3251e+02_r8,9.9515e+01_r8,6.6517e+01_r8,3.3646e+01_r8,6.5583e-01_r8/)
      kbo(:, 5,24, 8) = (/ &
     &1.4039e+02_r8,1.0542e+02_r8,7.0467e+01_r8,3.5600e+01_r8,6.7045e-01_r8/)
      kbo(:, 1,25, 8) = (/ &
     &9.2335e+01_r8,6.9366e+01_r8,4.6428e+01_r8,2.3921e+01_r8,5.4857e-01_r8/)
      kbo(:, 2,25, 8) = (/ &
     &9.6533e+01_r8,7.2518e+01_r8,4.8524e+01_r8,2.4911e+01_r8,5.6301e-01_r8/)
      kbo(:, 3,25, 8) = (/ &
     &1.0186e+02_r8,7.6521e+01_r8,5.1191e+01_r8,2.6188e+01_r8,5.7925e-01_r8/)
      kbo(:, 4,25, 8) = (/ &
     &1.0808e+02_r8,8.1193e+01_r8,5.4315e+01_r8,2.7693e+01_r8,5.9615e-01_r8/)
      kbo(:, 5,25, 8) = (/ &
     &1.1475e+02_r8,8.6195e+01_r8,5.7652e+01_r8,2.9318e+01_r8,6.1289e-01_r8/)
      kbo(:, 1,26, 8) = (/ &
     &7.5309e+01_r8,5.6599e+01_r8,3.7963e+01_r8,1.9911e+01_r8,4.8832e-01_r8/)
      kbo(:, 2,26, 8) = (/ &
     &7.9402e+01_r8,5.9672e+01_r8,3.9995e+01_r8,2.0863e+01_r8,5.0531e-01_r8/)
      kbo(:, 3,26, 8) = (/ &
     &8.4365e+01_r8,6.3403e+01_r8,4.2472e+01_r8,2.2029e+01_r8,5.2357e-01_r8/)
      kbo(:, 4,26, 8) = (/ &
     &8.9751e+01_r8,6.7447e+01_r8,4.5169e+01_r8,2.3307e+01_r8,5.4165e-01_r8/)
      kbo(:, 5,26, 8) = (/ &
     &9.5432e+01_r8,7.1708e+01_r8,4.8005e+01_r8,2.4657e+01_r8,5.6018e-01_r8/)
      kbo(:, 1,27, 8) = (/ &
     &6.4036e+01_r8,4.8147e+01_r8,3.2405e+01_r8,1.7310e+01_r8,4.3584e-01_r8/)
      kbo(:, 2,27, 8) = (/ &
     &6.8098e+01_r8,5.1198e+01_r8,3.4406e+01_r8,1.8250e+01_r8,4.5420e-01_r8/)
      kbo(:, 3,27, 8) = (/ &
     &7.2623e+01_r8,5.4602e+01_r8,3.6656e+01_r8,1.9303e+01_r8,4.7326e-01_r8/)
      kbo(:, 4,27, 8) = (/ &
     &7.7443e+01_r8,5.8217e+01_r8,3.9050e+01_r8,2.0426e+01_r8,4.9239e-01_r8/)
      kbo(:, 5,27, 8) = (/ &
     &8.2321e+01_r8,6.1875e+01_r8,4.1476e+01_r8,2.1557e+01_r8,5.1192e-01_r8/)
      kbo(:, 1,28, 8) = (/ &
     &5.6234e+01_r8,4.2299e+01_r8,2.8597e+01_r8,1.5531e+01_r8,3.8958e-01_r8/)
      kbo(:, 2,28, 8) = (/ &
     &6.0088e+01_r8,4.5199e+01_r8,3.0486e+01_r8,1.6430e+01_r8,4.0865e-01_r8/)
      kbo(:, 3,28, 8) = (/ &
     &6.4206e+01_r8,4.8292e+01_r8,3.2515e+01_r8,1.7385e+01_r8,4.2800e-01_r8/)
      kbo(:, 4,28, 8) = (/ &
     &6.8496e+01_r8,5.1510e+01_r8,3.4630e+01_r8,1.8368e+01_r8,4.4785e-01_r8/)
      kbo(:, 5,28, 8) = (/ &
     &7.2933e+01_r8,5.4831e+01_r8,3.6814e+01_r8,1.9374e+01_r8,4.6830e-01_r8/)
      kbo(:, 1,29, 8) = (/ &
     &5.2522e+01_r8,3.9524e+01_r8,2.6825e+01_r8,1.4721e+01_r8,3.4924e-01_r8/)
      kbo(:, 2,29, 8) = (/ &
     &5.6330e+01_r8,4.2387e+01_r8,2.8683e+01_r8,1.5618e+01_r8,3.6822e-01_r8/)
      kbo(:, 3,29, 8) = (/ &
     &6.0271e+01_r8,4.5343e+01_r8,3.0606e+01_r8,1.6531e+01_r8,3.8784e-01_r8/)
      kbo(:, 4,29, 8) = (/ &
     &6.4389e+01_r8,4.8431e+01_r8,3.2623e+01_r8,1.7468e+01_r8,4.0814e-01_r8/)
      kbo(:, 5,29, 8) = (/ &
     &6.8669e+01_r8,5.1633e+01_r8,3.4713e+01_r8,1.8422e+01_r8,4.2953e-01_r8/)
      kbo(:, 1,30, 8) = (/ &
     &5.0335e+01_r8,3.7896e+01_r8,2.5810e+01_r8,1.4271e+01_r8,3.1347e-01_r8/)
      kbo(:, 2,30, 8) = (/ &
     &5.4100e+01_r8,4.0719e+01_r8,2.7633e+01_r8,1.5165e+01_r8,3.3234e-01_r8/)
      kbo(:, 3,30, 8) = (/ &
     &5.7975e+01_r8,4.3625e+01_r8,2.9511e+01_r8,1.6060e+01_r8,3.5217e-01_r8/)
      kbo(:, 4,30, 8) = (/ &
     &6.2057e+01_r8,4.6681e+01_r8,3.1490e+01_r8,1.6979e+01_r8,3.7324e-01_r8/)
      kbo(:, 5,30, 8) = (/ &
     &6.6429e+01_r8,4.9951e+01_r8,3.3616e+01_r8,1.7947e+01_r8,3.9520e-01_r8/)
      kbo(:, 1,31, 8) = (/ &
     &5.0736e+01_r8,3.8204e+01_r8,2.6057e+01_r8,1.4444e+01_r8,2.8199e-01_r8/)
      kbo(:, 2,31, 8) = (/ &
     &5.4607e+01_r8,4.1105e+01_r8,2.7922e+01_r8,1.5358e+01_r8,3.0094e-01_r8/)
      kbo(:, 3,31, 8) = (/ &
     &5.8681e+01_r8,4.4155e+01_r8,2.9887e+01_r8,1.6295e+01_r8,3.2130e-01_r8/)
      kbo(:, 4,31, 8) = (/ &
     &6.3068e+01_r8,4.7436e+01_r8,3.2008e+01_r8,1.7279e+01_r8,3.4300e-01_r8/)
      kbo(:, 5,31, 8) = (/ &
     &6.7873e+01_r8,5.1031e+01_r8,3.4344e+01_r8,1.8340e+01_r8,3.6582e-01_r8/)
      kbo(:, 1,32, 8) = (/ &
     &5.1816e+01_r8,3.9019e+01_r8,2.6627e+01_r8,1.4770e+01_r8,2.5449e-01_r8/)
      kbo(:, 2,32, 8) = (/ &
     &5.5914e+01_r8,4.2088e+01_r8,2.8597e+01_r8,1.5735e+01_r8,2.7379e-01_r8/)
      kbo(:, 3,32, 8) = (/ &
     &6.0292e+01_r8,4.5361e+01_r8,3.0700e+01_r8,1.6736e+01_r8,2.9480e-01_r8/)
      kbo(:, 4,32, 8) = (/ &
     &6.5110e+01_r8,4.8965e+01_r8,3.3030e+01_r8,1.7812e+01_r8,3.1717e-01_r8/)
      kbo(:, 5,32, 8) = (/ &
     &7.0477e+01_r8,5.2981e+01_r8,3.5640e+01_r8,1.8999e+01_r8,3.4101e-01_r8/)
      kbo(:, 1,33, 8) = (/ &
     &5.3927e+01_r8,4.0606e+01_r8,2.7695e+01_r8,1.5341e+01_r8,2.3093e-01_r8/)
      kbo(:, 2,33, 8) = (/ &
     &5.8395e+01_r8,4.3947e+01_r8,2.9836e+01_r8,1.6383e+01_r8,2.5073e-01_r8/)
      kbo(:, 3,33, 8) = (/ &
     &6.3254e+01_r8,4.7578e+01_r8,3.2172e+01_r8,1.7485e+01_r8,2.7229e-01_r8/)
      kbo(:, 4,33, 8) = (/ &
     &6.8732e+01_r8,5.1678e+01_r8,3.4827e+01_r8,1.8707e+01_r8,2.9562e-01_r8/)
      kbo(:, 5,33, 8) = (/ &
     &7.4993e+01_r8,5.6366e+01_r8,3.7885e+01_r8,2.0105e+01_r8,3.2058e-01_r8/)
      kbo(:, 1,34, 8) = (/ &
     &5.4725e+01_r8,4.1207e+01_r8,2.8111e+01_r8,1.5582e+01_r8,2.1030e-01_r8/)
      kbo(:, 2,34, 8) = (/ &
     &5.9482e+01_r8,4.4761e+01_r8,3.0384e+01_r8,1.6682e+01_r8,2.3046e-01_r8/)
      kbo(:, 3,34, 8) = (/ &
     &6.4816e+01_r8,4.8747e+01_r8,3.2949e+01_r8,1.7887e+01_r8,2.5288e-01_r8/)
      kbo(:, 4,34, 8) = (/ &
     &7.0970e+01_r8,5.3352e+01_r8,3.5935e+01_r8,1.9263e+01_r8,2.7720e-01_r8/)
      kbo(:, 5,34, 8) = (/ &
     &7.8000e+01_r8,5.8622e+01_r8,3.9384e+01_r8,2.0853e+01_r8,3.0314e-01_r8/)
      kbo(:, 1,35, 8) = (/ &
     &5.5341e+01_r8,4.1670e+01_r8,2.8432e+01_r8,1.5766e+01_r8,1.9105e-01_r8/)
      kbo(:, 2,35, 8) = (/ &
     &6.0475e+01_r8,4.5504e+01_r8,3.0887e+01_r8,1.6952e+01_r8,2.1167e-01_r8/)
      kbo(:, 3,35, 8) = (/ &
     &6.6351e+01_r8,4.9895e+01_r8,3.3711e+01_r8,1.8277e+01_r8,2.3461e-01_r8/)
      kbo(:, 4,35, 8) = (/ &
     &7.3222e+01_r8,5.5040e+01_r8,3.7057e+01_r8,1.9828e+01_r8,2.5964e-01_r8/)
      kbo(:, 5,35, 8) = (/ &
     &8.0936e+01_r8,6.0824e+01_r8,4.0848e+01_r8,2.1583e+01_r8,2.8629e-01_r8/)
      kbo(:, 1,36, 8) = (/ &
     &5.5260e+01_r8,4.1610e+01_r8,2.8415e+01_r8,1.5779e+01_r8,1.7255e-01_r8/)
      kbo(:, 2,36, 8) = (/ &
     &6.0687e+01_r8,4.5661e+01_r8,3.1003e+01_r8,1.7034e+01_r8,1.9343e-01_r8/)
      kbo(:, 3,36, 8) = (/ &
     &6.7095e+01_r8,5.0451e+01_r8,3.4089e+01_r8,1.8486e+01_r8,2.1666e-01_r8/)
      kbo(:, 4,36, 8) = (/ &
     &7.4593e+01_r8,5.6070e+01_r8,3.7750e+01_r8,2.0193e+01_r8,2.4210e-01_r8/)
      kbo(:, 5,36, 8) = (/ &
     &8.2912e+01_r8,6.2305e+01_r8,4.1836e+01_r8,2.2093e+01_r8,2.6939e-01_r8/)
      kbo(:, 1,37, 8) = (/ &
     &5.3136e+01_r8,4.0024e+01_r8,2.7403e+01_r8,1.5295e+01_r8,1.5374e-01_r8/)
      kbo(:, 2,37, 8) = (/ &
     &5.8700e+01_r8,4.4173e+01_r8,3.0048e+01_r8,1.6588e+01_r8,1.7430e-01_r8/)
      kbo(:, 3,37, 8) = (/ &
     &6.5370e+01_r8,4.9158e+01_r8,3.3257e+01_r8,1.8110e+01_r8,1.9744e-01_r8/)
      kbo(:, 4,37, 8) = (/ &
     &7.3079e+01_r8,5.4934e+01_r8,3.7017e+01_r8,1.9876e+01_r8,2.2299e-01_r8/)
      kbo(:, 5,37, 8) = (/ &
     &8.1729e+01_r8,6.1417e+01_r8,4.1258e+01_r8,2.1852e+01_r8,2.5074e-01_r8/)
      kbo(:, 1,38, 8) = (/ &
     &5.1889e+01_r8,3.9094e+01_r8,2.6819e+01_r8,1.5017e+01_r8,1.3711e-01_r8/)
      kbo(:, 2,38, 8) = (/ &
     &5.7665e+01_r8,4.3397e+01_r8,2.9561e+01_r8,1.6368e+01_r8,1.5734e-01_r8/)
      kbo(:, 3,38, 8) = (/ &
     &6.4668e+01_r8,4.8631e+01_r8,3.2933e+01_r8,1.7981e+01_r8,1.8028e-01_r8/)
      kbo(:, 4,38, 8) = (/ &
     &7.2785e+01_r8,5.4713e+01_r8,3.6887e+01_r8,1.9846e+01_r8,2.0601e-01_r8/)
      kbo(:, 5,38, 8) = (/ &
     &8.1846e+01_r8,6.1504e+01_r8,4.1328e+01_r8,2.1921e+01_r8,2.3415e-01_r8/)
      kbo(:, 1,39, 8) = (/ &
     &5.1946e+01_r8,3.9141e+01_r8,2.6874e+01_r8,1.5056e+01_r8,1.2254e-01_r8/)
      kbo(:, 2,39, 8) = (/ &
     &5.8115e+01_r8,4.3735e+01_r8,2.9803e+01_r8,1.6507e+01_r8,1.4241e-01_r8/)
      kbo(:, 3,39, 8) = (/ &
     &6.5638e+01_r8,4.9361e+01_r8,3.3432e+01_r8,1.8252e+01_r8,1.6535e-01_r8/)
      kbo(:, 4,39, 8) = (/ &
     &7.4281e+01_r8,5.5835e+01_r8,3.7644e+01_r8,2.0246e+01_r8,1.9114e-01_r8/)
      kbo(:, 5,39, 8) = (/ &
     &8.4117e+01_r8,6.3205e+01_r8,4.2465e+01_r8,2.2507e+01_r8,2.1954e-01_r8/)
      kbo(:, 1,40, 8) = (/ &
     &4.8372e+01_r8,3.6476e+01_r8,2.5167e+01_r8,1.4200e+01_r8,1.0786e-01_r8/)
      kbo(:, 2,40, 8) = (/ &
     &5.4435e+01_r8,4.0985e+01_r8,2.8035e+01_r8,1.5644e+01_r8,1.2713e-01_r8/)
      kbo(:, 3,40, 8) = (/ &
     &6.1814e+01_r8,4.6498e+01_r8,3.1582e+01_r8,1.7371e+01_r8,1.4957e-01_r8/)
      kbo(:, 4,40, 8) = (/ &
     &7.0455e+01_r8,5.2966e+01_r8,3.5777e+01_r8,1.9373e+01_r8,1.7507e-01_r8/)
      kbo(:, 5,40, 8) = (/ &
     &8.0314e+01_r8,6.0352e+01_r8,4.0598e+01_r8,2.1643e+01_r8,2.0339e-01_r8/)
      kbo(:, 1,41, 8) = (/ &
     &4.4863e+01_r8,3.3865e+01_r8,2.3494e+01_r8,1.3347e+01_r8,9.4622e-02_r8/)
      kbo(:, 2,41, 8) = (/ &
     &5.0838e+01_r8,3.8301e+01_r8,2.6314e+01_r8,1.4793e+01_r8,1.1320e-01_r8/)
      kbo(:, 3,41, 8) = (/ &
     &5.8061e+01_r8,4.3692e+01_r8,2.9774e+01_r8,1.6500e+01_r8,1.3504e-01_r8/)
      kbo(:, 4,41, 8) = (/ &
     &6.6603e+01_r8,5.0081e+01_r8,3.3908e+01_r8,1.8494e+01_r8,1.6019e-01_r8/)
      kbo(:, 5,41, 8) = (/ &
     &7.6448e+01_r8,5.7454e+01_r8,3.8706e+01_r8,2.0765e+01_r8,1.8828e-01_r8/)
      kbo(:, 1,42, 8) = (/ &
     &4.2143e+01_r8,3.1846e+01_r8,2.2204e+01_r8,1.2680e+01_r8,8.2928e-02_r8/)
      kbo(:, 2,42, 8) = (/ &
     &4.7973e+01_r8,3.6167e+01_r8,2.4953e+01_r8,1.4117e+01_r8,1.0072e-01_r8/)
      kbo(:, 3,42, 8) = (/ &
     &5.5183e+01_r8,4.1542e+01_r8,2.8395e+01_r8,1.5835e+01_r8,1.2195e-01_r8/)
      kbo(:, 4,42, 8) = (/ &
     &6.3709e+01_r8,4.7914e+01_r8,3.2510e+01_r8,1.7836e+01_r8,1.4663e-01_r8/)
      kbo(:, 5,42, 8) = (/ &
     &7.3621e+01_r8,5.5334e+01_r8,3.7330e+01_r8,2.0134e+01_r8,1.7447e-01_r8/)
      kbo(:, 1,43, 8) = (/ &
     &3.9594e+01_r8,2.9962e+01_r8,2.1003e+01_r8,1.2048e+01_r8,7.1693e-02_r8/)
      kbo(:, 2,43, 8) = (/ &
     &4.5330e+01_r8,3.4203e+01_r8,2.3706e+01_r8,1.3485e+01_r8,8.8502e-02_r8/)
      kbo(:, 3,43, 8) = (/ &
     &5.2493e+01_r8,3.9537e+01_r8,2.7118e+01_r8,1.5213e+01_r8,1.0887e-01_r8/)
      kbo(:, 4,43, 8) = (/ &
     &6.1012e+01_r8,4.5896e+01_r8,3.1221e+01_r8,1.7230e+01_r8,1.3283e-01_r8/)
      kbo(:, 5,43, 8) = (/ &
     &7.1011e+01_r8,5.3379e+01_r8,3.6070e+01_r8,1.9559e+01_r8,1.6011e-01_r8/)
      kbo(:, 1,44, 8) = (/ &
     &3.7616e+01_r8,2.8507e+01_r8,2.0078e+01_r8,1.1553e+01_r8,6.1401e-02_r8/)
      kbo(:, 2,44, 8) = (/ &
     &4.3274e+01_r8,3.2681e+01_r8,2.2747e+01_r8,1.2992e+01_r8,7.7099e-02_r8/)
      kbo(:, 3,44, 8) = (/ &
     &5.0385e+01_r8,3.7971e+01_r8,2.6133e+01_r8,1.4732e+01_r8,9.6479e-02_r8/)
      kbo(:, 4,44, 8) = (/ &
     &5.8976e+01_r8,4.4379e+01_r8,3.0259e+01_r8,1.6785e+01_r8,1.1952e-01_r8/)
      kbo(:, 5,44, 8) = (/ &
     &6.9172e+01_r8,5.2003e+01_r8,3.5195e+01_r8,1.9170e+01_r8,1.4606e-01_r8/)
      kbo(:, 1,45, 8) = (/ &
     &3.6417e+01_r8,2.7634e+01_r8,1.9534e+01_r8,1.1252e+01_r8,5.2391e-02_r8/)
      kbo(:, 2,45, 8) = (/ &
     &4.2083e+01_r8,3.1808e+01_r8,2.2209e+01_r8,1.2716e+01_r8,6.6909e-02_r8/)
      kbo(:, 3,45, 8) = (/ &
     &4.9318e+01_r8,3.7181e+01_r8,2.5653e+01_r8,1.4499e+01_r8,8.5223e-02_r8/)
      kbo(:, 4,45, 8) = (/ &
     &5.8109e+01_r8,4.3735e+01_r8,2.9873e+01_r8,1.6620e+01_r8,1.0731e-01_r8/)
      kbo(:, 5,45, 8) = (/ &
     &6.8675e+01_r8,5.1635e+01_r8,3.4984e+01_r8,1.9103e+01_r8,1.3302e-01_r8/)
      kbo(:, 1,46, 8) = (/ &
     &3.5397e+01_r8,2.6895e+01_r8,1.9070e+01_r8,1.0989e+01_r8,4.4228e-02_r8/)
      kbo(:, 2,46, 8) = (/ &
     &4.1150e+01_r8,3.1127e+01_r8,2.1795e+01_r8,1.2497e+01_r8,5.7487e-02_r8/)
      kbo(:, 3,46, 8) = (/ &
     &4.8494e+01_r8,3.6574e+01_r8,2.5287e+01_r8,1.4324e+01_r8,7.4577e-02_r8/)
      kbo(:, 4,46, 8) = (/ &
     &5.7598e+01_r8,4.3359e+01_r8,2.9657e+01_r8,1.6535e+01_r8,9.5575e-02_r8/)
      kbo(:, 5,46, 8) = (/ &
     &6.8559e+01_r8,5.1549e+01_r8,3.4961e+01_r8,1.9128e+01_r8,1.2028e-01_r8/)
      kbo(:, 1,47, 8) = (/ &
     &3.3892e+01_r8,2.5799e+01_r8,1.8369e+01_r8,1.0592e+01_r8,3.6658e-02_r8/)
      kbo(:, 2,47, 8) = (/ &
     &3.9558e+01_r8,2.9961e+01_r8,2.1065e+01_r8,1.2104e+01_r8,4.8512e-02_r8/)
      kbo(:, 3,47, 8) = (/ &
     &4.6821e+01_r8,3.5338e+01_r8,2.4514e+01_r8,1.3933e+01_r8,6.4199e-02_r8/)
      kbo(:, 4,47, 8) = (/ &
     &5.6038e+01_r8,4.2200e+01_r8,2.8934e+01_r8,1.6192e+01_r8,8.3849e-02_r8/)
      kbo(:, 5,47, 8) = (/ &
     &6.7239e+01_r8,5.0568e+01_r8,3.4350e+01_r8,1.8859e+01_r8,1.0731e-01_r8/)
      kbo(:, 1,48, 8) = (/ &
     &3.3363e+01_r8,2.5430e+01_r8,1.8144e+01_r8,1.0446e+01_r8,3.0177e-02_r8/)
      kbo(:, 2,48, 8) = (/ &
     &3.9055e+01_r8,2.9607e+01_r8,2.0861e+01_r8,1.1982e+01_r8,4.0640e-02_r8/)
      kbo(:, 3,48, 8) = (/ &
     &4.6430e+01_r8,3.5057e+01_r8,2.4367e+01_r8,1.3859e+01_r8,5.4873e-02_r8/)
      kbo(:, 4,48, 8) = (/ &
     &5.5939e+01_r8,4.2134e+01_r8,2.8926e+01_r8,1.6205e+01_r8,7.3130e-02_r8/)
      kbo(:, 5,48, 8) = (/ &
     &6.7675e+01_r8,5.0896e+01_r8,3.4598e+01_r8,1.9010e+01_r8,9.5352e-02_r8/)
      kbo(:, 1,49, 8) = (/ &
     &3.4087e+01_r8,2.5989e+01_r8,1.8530e+01_r8,1.0628e+01_r8,2.4642e-02_r8/)
      kbo(:, 2,49, 8) = (/ &
     &4.0143e+01_r8,3.0436e+01_r8,2.1433e+01_r8,1.2264e+01_r8,3.3771e-02_r8/)
      kbo(:, 3,49, 8) = (/ &
     &4.7859e+01_r8,3.6137e+01_r8,2.5106e+01_r8,1.4243e+01_r8,4.6570e-02_r8/)
      kbo(:, 4,49, 8) = (/ &
     &5.8042e+01_r8,4.3715e+01_r8,2.9997e+01_r8,1.6759e+01_r8,6.3406e-02_r8/)
      kbo(:, 5,49, 8) = (/ &
     &7.0774e+01_r8,5.3220e+01_r8,3.6156e+01_r8,1.9813e+01_r8,8.4317e-02_r8/)
      kbo(:, 1,50, 8) = (/ &
     &3.3271e+01_r8,2.5407e+01_r8,1.8155e+01_r8,1.0394e+01_r8,2.0105e-02_r8/)
      kbo(:, 2,50, 8) = (/ &
     &3.9337e+01_r8,2.9859e+01_r8,2.1080e+01_r8,1.2062e+01_r8,2.8045e-02_r8/)
      kbo(:, 3,50, 8) = (/ &
     &4.7124e+01_r8,3.5606e+01_r8,2.4793e+01_r8,1.4082e+01_r8,3.9522e-02_r8/)
      kbo(:, 4,50, 8) = (/ &
     &5.7525e+01_r8,4.3340e+01_r8,2.9788e+01_r8,1.6668e+01_r8,5.4974e-02_r8/)
      kbo(:, 5,50, 8) = (/ &
     &7.0694e+01_r8,5.3165e+01_r8,3.6155e+01_r8,1.9842e+01_r8,7.4569e-02_r8/)
      kbo(:, 1,51, 8) = (/ &
     &3.1799e+01_r8,2.4339e+01_r8,1.7448e+01_r8,9.9788e+00_r8,1.6322e-02_r8/)
      kbo(:, 2,51, 8) = (/ &
     &3.7729e+01_r8,2.8686e+01_r8,2.0331e+01_r8,1.1646e+01_r8,2.3187e-02_r8/)
      kbo(:, 3,51, 8) = (/ &
     &4.5428e+01_r8,3.4361e+01_r8,2.4014e+01_r8,1.3675e+01_r8,3.3395e-02_r8/)
      kbo(:, 4,51, 8) = (/ &
     &5.5764e+01_r8,4.2036e+01_r8,2.8971e+01_r8,1.6259e+01_r8,4.7474e-02_r8/)
      kbo(:, 5,51, 8) = (/ &
     &6.9086e+01_r8,5.1969e+01_r8,3.5405e+01_r8,1.9496e+01_r8,6.5720e-02_r8/)
      kbo(:, 1,52, 8) = (/ &
     &3.1125e+01_r8,2.3861e+01_r8,1.7130e+01_r8,9.7762e+00_r8,1.3165e-02_r8/)
      kbo(:, 2,52, 8) = (/ &
     &3.7206e+01_r8,2.8320e+01_r8,2.0110e+01_r8,1.1507e+01_r8,1.9020e-02_r8/)
      kbo(:, 3,52, 8) = (/ &
     &4.4966e+01_r8,3.4037e+01_r8,2.3832e+01_r8,1.3576e+01_r8,2.8007e-02_r8/)
      kbo(:, 4,52, 8) = (/ &
     &5.5475e+01_r8,4.1834e+01_r8,2.8875e+01_r8,1.6222e+01_r8,4.0752e-02_r8/)
      kbo(:, 5,52, 8) = (/ &
     &6.9286e+01_r8,5.2127e+01_r8,3.5547e+01_r8,1.9593e+01_r8,5.7616e-02_r8/)
      kbo(:, 1,53, 8) = (/ &
     &3.1628e+01_r8,2.4253e+01_r8,1.7391e+01_r8,9.8844e+00_r8,1.0543e-02_r8/)
      kbo(:, 2,53, 8) = (/ &
     &3.8058e+01_r8,2.8975e+01_r8,2.0560e+01_r8,1.1731e+01_r8,1.5472e-02_r8/)
      kbo(:, 3,53, 8) = (/ &
     &4.6305e+01_r8,3.5054e+01_r8,2.4529e+01_r8,1.3933e+01_r8,2.3276e-02_r8/)
      kbo(:, 4,53, 8) = (/ &
     &5.7328e+01_r8,4.3229e+01_r8,2.9824e+01_r8,1.6717e+01_r8,3.4695e-02_r8/)
      kbo(:, 5,53, 8) = (/ &
     &7.2228e+01_r8,5.4335e+01_r8,3.7034e+01_r8,2.0360e+01_r8,5.0210e-02_r8/)
      kbo(:, 1,54, 8) = (/ &
     &2.7866e+01_r8,2.1495e+01_r8,1.5519e+01_r8,8.8346e+00_r8,8.4580e-03_r8/)
      kbo(:, 2,54, 8) = (/ &
     &3.3763e+01_r8,2.5815e+01_r8,1.8473e+01_r8,1.0588e+01_r8,1.2602e-02_r8/)
      kbo(:, 3,54, 8) = (/ &
     &4.1361e+01_r8,3.1401e+01_r8,2.2155e+01_r8,1.2668e+01_r8,1.9366e-02_r8/)
      kbo(:, 4,54, 8) = (/ &
     &5.1507e+01_r8,3.8906e+01_r8,2.7027e+01_r8,1.5284e+01_r8,2.9589e-02_r8/)
      kbo(:, 5,54, 8) = (/ &
     &6.5378e+01_r8,4.9225e+01_r8,3.3718e+01_r8,1.8724e+01_r8,4.3797e-02_r8/)
      kbo(:, 1,55, 8) = (/ &
     &2.2404e+01_r8,1.7484e+01_r8,1.2754e+01_r8,7.2917e+00_r8,6.7620e-03_r8/)
      kbo(:, 2,55, 8) = (/ &
     &2.7309e+01_r8,2.1069e+01_r8,1.5293e+01_r8,8.8299e+00_r8,1.0220e-02_r8/)
      kbo(:, 3,55, 8) = (/ &
     &3.3683e+01_r8,2.5733e+01_r8,1.8431e+01_r8,1.0660e+01_r8,1.6054e-02_r8/)
      kbo(:, 4,55, 8) = (/ &
     &4.2194e+01_r8,3.1999e+01_r8,2.2529e+01_r8,1.2931e+01_r8,2.5150e-02_r8/)
      kbo(:, 5,55, 8) = (/ &
     &5.4011e+01_r8,4.0754e+01_r8,2.8208e+01_r8,1.5935e+01_r8,3.8077e-02_r8/)
      kbo(:, 1,56, 8) = (/ &
     &1.7963e+01_r8,1.4222e+01_r8,1.0460e+01_r8,5.9968e+00_r8,5.3696e-03_r8/)
      kbo(:, 2,56, 8) = (/ &
     &2.2011e+01_r8,1.7185e+01_r8,1.2632e+01_r8,7.3359e+00_r8,8.2238e-03_r8/)
      kbo(:, 3,56, 8) = (/ &
     &2.7341e+01_r8,2.1070e+01_r8,1.5329e+01_r8,8.9492e+00_r8,1.3200e-02_r8/)
      kbo(:, 4,56, 8) = (/ &
     &3.4490e+01_r8,2.6306e+01_r8,1.8809e+01_r8,1.0943e+01_r8,2.1214e-02_r8/)
      kbo(:, 5,56, 8) = (/ &
     &4.4535e+01_r8,3.3715e+01_r8,2.3630e+01_r8,1.3559e+01_r8,3.2915e-02_r8/)
      kbo(:, 1,57, 8) = (/ &
     &1.4368e+01_r8,1.1564e+01_r8,8.5550e+00_r8,4.9118e+00_r8,4.2402e-03_r8/)
      kbo(:, 2,57, 8) = (/ &
     &1.7718e+01_r8,1.4043e+01_r8,1.0433e+01_r8,6.0838e+00_r8,6.5672e-03_r8/)
      kbo(:, 3,57, 8) = (/ &
     &2.2119e+01_r8,1.7250e+01_r8,1.2736e+01_r8,7.4914e+00_r8,1.0750e-02_r8/)
      kbo(:, 4,57, 8) = (/ &
     &2.8111e+01_r8,2.1614e+01_r8,1.5710e+01_r8,9.2466e+00_r8,1.7729e-02_r8/)
      kbo(:, 5,57, 8) = (/ &
     &3.6581e+01_r8,2.7832e+01_r8,1.9800e+01_r8,1.1525e+01_r8,2.8247e-02_r8/)
      kbo(:, 1,58, 8) = (/ &
     &3.0334e+00_r8,3.0458e+00_r8,2.9118e+00_r8,2.3449e+00_r8,3.3480e-03_r8/)
      kbo(:, 2,58, 8) = (/ &
     &3.7595e+00_r8,3.7165e+00_r8,3.5857e+00_r8,2.9410e+00_r8,5.2345e-03_r8/)
      kbo(:, 3,58, 8) = (/ &
     &4.7309e+00_r8,4.5866e+00_r8,4.4204e+00_r8,3.6685e+00_r8,8.7466e-03_r8/)
      kbo(:, 4,58, 8) = (/ &
     &6.0543e+00_r8,5.7620e+00_r8,5.4869e+00_r8,4.5723e+00_r8,1.4810e-02_r8/)
      kbo(:, 5,58, 8) = (/ &
     &7.9336e+00_r8,7.4372e+00_r8,6.9325e+00_r8,5.7367e+00_r8,2.4215e-02_r8/)
      kbo(:, 1,59, 8) = (/ &
     &2.9765e+00_r8,2.9765e+00_r8,2.6845e+00_r8,1.9427e+00_r8,2.8320e-03_r8/)
      kbo(:, 2,59, 8) = (/ &
     &3.7193e+00_r8,3.6697e+00_r8,3.3576e+00_r8,2.4792e+00_r8,4.5261e-03_r8/)
      kbo(:, 3,59, 8) = (/ &
     &4.7245e+00_r8,4.5542e+00_r8,4.1916e+00_r8,3.1428e+00_r8,7.7669e-03_r8/)
      kbo(:, 4,59, 8) = (/ &
     &6.1120e+00_r8,5.7342e+00_r8,5.2520e+00_r8,3.9688e+00_r8,1.3461e-02_r8/)
      kbo(:, 5,59, 8) = (/ &
     &8.1086e+00_r8,7.4151e+00_r8,6.6769e+00_r8,5.0327e+00_r8,2.2363e-02_r8/)
      kbo(:, 1,13, 9) = (/ &
     &3.9255e+04_r8,2.9441e+04_r8,1.9628e+04_r8,9.8141e+03_r8,2.1650e+00_r8/)
      kbo(:, 2,13, 9) = (/ &
     &3.9490e+04_r8,2.9618e+04_r8,1.9745e+04_r8,9.8730e+03_r8,2.1321e+00_r8/)
      kbo(:, 3,13, 9) = (/ &
     &3.9631e+04_r8,2.9723e+04_r8,1.9816e+04_r8,9.9081e+03_r8,2.0803e+00_r8/)
      kbo(:, 4,13, 9) = (/ &
     &3.9707e+04_r8,2.9781e+04_r8,1.9854e+04_r8,9.9272e+03_r8,2.0587e+00_r8/)
      kbo(:, 5,13, 9) = (/ &
     &3.9690e+04_r8,2.9768e+04_r8,1.9845e+04_r8,9.9229e+03_r8,2.0351e+00_r8/)
      kbo(:, 1,14, 9) = (/ &
     &2.2391e+04_r8,1.6793e+04_r8,1.1196e+04_r8,5.5981e+03_r8,2.2958e+00_r8/)
      kbo(:, 2,14, 9) = (/ &
     &2.2483e+04_r8,1.6862e+04_r8,1.1241e+04_r8,5.6209e+03_r8,2.2646e+00_r8/)
      kbo(:, 3,14, 9) = (/ &
     &2.2517e+04_r8,1.6888e+04_r8,1.1259e+04_r8,5.6296e+03_r8,2.2164e+00_r8/)
      kbo(:, 4,14, 9) = (/ &
     &2.2511e+04_r8,1.6883e+04_r8,1.1256e+04_r8,5.6281e+03_r8,2.1692e+00_r8/)
      kbo(:, 5,14, 9) = (/ &
     &2.2470e+04_r8,1.6853e+04_r8,1.1235e+04_r8,5.6178e+03_r8,2.1488e+00_r8/)
      kbo(:, 1,15, 9) = (/ &
     &1.2806e+04_r8,9.6046e+03_r8,6.4033e+03_r8,3.2019e+03_r8,2.4251e+00_r8/)
      kbo(:, 2,15, 9) = (/ &
     &1.2828e+04_r8,9.6209e+03_r8,6.4142e+03_r8,3.2073e+03_r8,2.3960e+00_r8/)
      kbo(:, 3,15, 9) = (/ &
     &1.2826e+04_r8,9.6195e+03_r8,6.4132e+03_r8,3.2069e+03_r8,2.3588e+00_r8/)
      kbo(:, 4,15, 9) = (/ &
     &1.2818e+04_r8,9.6139e+03_r8,6.4095e+03_r8,3.2050e+03_r8,2.3106e+00_r8/)
      kbo(:, 5,15, 9) = (/ &
     &1.2808e+04_r8,9.6063e+03_r8,6.4044e+03_r8,3.2025e+03_r8,2.2722e+00_r8/)
      kbo(:, 1,16, 9) = (/ &
     &8.5967e+03_r8,6.4476e+03_r8,4.2986e+03_r8,2.1496e+03_r8,2.5476e+00_r8/)
      kbo(:, 2,16, 9) = (/ &
     &8.5987e+03_r8,6.4492e+03_r8,4.2996e+03_r8,2.1501e+03_r8,2.5204e+00_r8/)
      kbo(:, 3,16, 9) = (/ &
     &8.5999e+03_r8,6.4500e+03_r8,4.3002e+03_r8,2.1504e+03_r8,2.4878e+00_r8/)
      kbo(:, 4,16, 9) = (/ &
     &8.6043e+03_r8,6.4534e+03_r8,4.3024e+03_r8,2.1515e+03_r8,2.4397e+00_r8/)
      kbo(:, 5,16, 9) = (/ &
     &8.6176e+03_r8,6.4634e+03_r8,4.3091e+03_r8,2.1548e+03_r8,2.4008e+00_r8/)
      kbo(:, 1,17, 9) = (/ &
     &5.9284e+03_r8,4.4464e+03_r8,2.9645e+03_r8,1.4825e+03_r8,2.6544e+00_r8/)
      kbo(:, 2,17, 9) = (/ &
     &5.9327e+03_r8,4.4497e+03_r8,2.9666e+03_r8,1.4836e+03_r8,2.6300e+00_r8/)
      kbo(:, 3,17, 9) = (/ &
     &5.9411e+03_r8,4.4560e+03_r8,2.9708e+03_r8,1.4857e+03_r8,2.5993e+00_r8/)
      kbo(:, 4,17, 9) = (/ &
     &5.9634e+03_r8,4.4727e+03_r8,2.9820e+03_r8,1.4912e+03_r8,2.5553e+00_r8/)
      kbo(:, 5,17, 9) = (/ &
     &6.0032e+03_r8,4.5025e+03_r8,3.0018e+03_r8,1.5012e+03_r8,2.5167e+00_r8/)
      kbo(:, 1,18, 9) = (/ &
     &4.1696e+03_r8,3.1274e+03_r8,2.0851e+03_r8,1.0428e+03_r8,2.7386e+00_r8/)
      kbo(:, 2,18, 9) = (/ &
     &4.1796e+03_r8,3.1348e+03_r8,2.0901e+03_r8,1.0453e+03_r8,2.7184e+00_r8/)
      kbo(:, 3,18, 9) = (/ &
     &4.2028e+03_r8,3.1522e+03_r8,2.1017e+03_r8,1.0511e+03_r8,2.6888e+00_r8/)
      kbo(:, 4,18, 9) = (/ &
     &4.2429e+03_r8,3.1823e+03_r8,2.1217e+03_r8,1.0611e+03_r8,2.6491e+00_r8/)
      kbo(:, 5,18, 9) = (/ &
     &4.2973e+03_r8,3.2231e+03_r8,2.1489e+03_r8,1.0747e+03_r8,2.6124e+00_r8/)
      kbo(:, 1,19, 9) = (/ &
     &2.8753e+03_r8,2.1566e+03_r8,1.4379e+03_r8,7.1922e+02_r8,2.7969e+00_r8/)
      kbo(:, 2,19, 9) = (/ &
     &2.8953e+03_r8,2.1716e+03_r8,1.4479e+03_r8,7.2422e+02_r8,2.7817e+00_r8/)
      kbo(:, 3,19, 9) = (/ &
     &2.9302e+03_r8,2.1978e+03_r8,1.4654e+03_r8,7.3295e+02_r8,2.7548e+00_r8/)
      kbo(:, 4,19, 9) = (/ &
     &2.9782e+03_r8,2.2338e+03_r8,1.4894e+03_r8,7.4494e+02_r8,2.7189e+00_r8/)
      kbo(:, 5,19, 9) = (/ &
     &3.0360e+03_r8,2.2771e+03_r8,1.5183e+03_r8,7.5939e+02_r8,2.6829e+00_r8/)
      kbo(:, 1,20, 9) = (/ &
     &2.1517e+03_r8,1.6139e+03_r8,1.0761e+03_r8,5.3833e+02_r8,2.8251e+00_r8/)
      kbo(:, 2,20, 9) = (/ &
     &2.1814e+03_r8,1.6362e+03_r8,1.0910e+03_r8,5.4575e+02_r8,2.8122e+00_r8/)
      kbo(:, 3,20, 9) = (/ &
     &2.2241e+03_r8,1.6682e+03_r8,1.1123e+03_r8,5.5643e+02_r8,2.7893e+00_r8/)
      kbo(:, 4,20, 9) = (/ &
     &2.2758e+03_r8,1.7069e+03_r8,1.1381e+03_r8,5.6933e+02_r8,2.7572e+00_r8/)
      kbo(:, 5,20, 9) = (/ &
     &2.3338e+03_r8,1.7505e+03_r8,1.1672e+03_r8,5.8384e+02_r8,2.7245e+00_r8/)
      kbo(:, 1,21, 9) = (/ &
     &1.6700e+03_r8,1.2526e+03_r8,8.3526e+02_r8,4.1790e+02_r8,2.8188e+00_r8/)
      kbo(:, 2,21, 9) = (/ &
     &1.7058e+03_r8,1.2795e+03_r8,8.5318e+02_r8,4.2686e+02_r8,2.8087e+00_r8/)
      kbo(:, 3,21, 9) = (/ &
     &1.7510e+03_r8,1.3134e+03_r8,8.7578e+02_r8,4.3816e+02_r8,2.7899e+00_r8/)
      kbo(:, 4,21, 9) = (/ &
     &1.8029e+03_r8,1.3523e+03_r8,9.0173e+02_r8,4.5113e+02_r8,2.7632e+00_r8/)
      kbo(:, 5,21, 9) = (/ &
     &1.8601e+03_r8,1.3952e+03_r8,9.3032e+02_r8,4.6542e+02_r8,2.7328e+00_r8/)
      kbo(:, 1,22, 9) = (/ &
     &1.3403e+03_r8,1.0054e+03_r8,6.7043e+02_r8,3.3549e+02_r8,2.7778e+00_r8/)
      kbo(:, 2,22, 9) = (/ &
     &1.3792e+03_r8,1.0345e+03_r8,6.8985e+02_r8,3.4520e+02_r8,2.7715e+00_r8/)
      kbo(:, 3,22, 9) = (/ &
     &1.4248e+03_r8,1.0688e+03_r8,7.1269e+02_r8,3.5661e+02_r8,2.7559e+00_r8/)
      kbo(:, 4,22, 9) = (/ &
     &1.4749e+03_r8,1.1063e+03_r8,7.3770e+02_r8,3.6911e+02_r8,2.7316e+00_r8/)
      kbo(:, 5,22, 9) = (/ &
     &1.5223e+03_r8,1.1418e+03_r8,7.6138e+02_r8,3.8094e+02_r8,2.7088e+00_r8/)
      kbo(:, 1,23, 9) = (/ &
     &1.0891e+03_r8,8.1698e+02_r8,5.4484e+02_r8,2.7270e+02_r8,2.7041e+00_r8/)
      kbo(:, 2,23, 9) = (/ &
     &1.1283e+03_r8,8.4637e+02_r8,5.6443e+02_r8,2.8249e+02_r8,2.7027e+00_r8/)
      kbo(:, 3,23, 9) = (/ &
     &1.1704e+03_r8,8.7791e+02_r8,5.8545e+02_r8,2.9300e+02_r8,2.6907e+00_r8/)
      kbo(:, 4,23, 9) = (/ &
     &1.2113e+03_r8,9.0862e+02_r8,6.0592e+02_r8,3.0322e+02_r8,2.6730e+00_r8/)
      kbo(:, 5,23, 9) = (/ &
     &1.2507e+03_r8,9.3816e+02_r8,6.2560e+02_r8,3.1305e+02_r8,2.6594e+00_r8/)
      kbo(:, 1,24, 9) = (/ &
     &8.8581e+02_r8,6.6450e+02_r8,4.4318e+02_r8,2.2188e+02_r8,2.6023e+00_r8/)
      kbo(:, 2,24, 9) = (/ &
     &9.2040e+02_r8,6.9044e+02_r8,4.6047e+02_r8,2.3052e+02_r8,2.6060e+00_r8/)
      kbo(:, 3,24, 9) = (/ &
     &9.5496e+02_r8,7.1635e+02_r8,4.7775e+02_r8,2.3914e+02_r8,2.6005e+00_r8/)
      kbo(:, 4,24, 9) = (/ &
     &9.8776e+02_r8,7.4094e+02_r8,4.9413e+02_r8,2.4733e+02_r8,2.5922e+00_r8/)
      kbo(:, 5,24, 9) = (/ &
     &1.0196e+03_r8,7.6479e+02_r8,5.1001e+02_r8,2.5525e+02_r8,2.5914e+00_r8/)
      kbo(:, 1,25, 9) = (/ &
     &7.3035e+02_r8,5.4790e+02_r8,3.6545e+02_r8,1.8302e+02_r8,2.4806e+00_r8/)
      kbo(:, 2,25, 9) = (/ &
     &7.5932e+02_r8,5.6963e+02_r8,3.7993e+02_r8,1.9025e+02_r8,2.4895e+00_r8/)
      kbo(:, 3,25, 9) = (/ &
     &7.8665e+02_r8,5.9012e+02_r8,3.9359e+02_r8,1.9707e+02_r8,2.4921e+00_r8/)
      kbo(:, 4,25, 9) = (/ &
     &8.1328e+02_r8,6.1007e+02_r8,4.0688e+02_r8,2.0370e+02_r8,2.4969e+00_r8/)
      kbo(:, 5,25, 9) = (/ &
     &8.3956e+02_r8,6.2979e+02_r8,4.2001e+02_r8,2.1025e+02_r8,2.5085e+00_r8/)
      kbo(:, 1,26, 9) = (/ &
     &6.1100e+02_r8,4.5838e+02_r8,3.0577e+02_r8,1.5319e+02_r8,2.3442e+00_r8/)
      kbo(:, 2,26, 9) = (/ &
     &6.3406e+02_r8,4.7568e+02_r8,3.1730e+02_r8,1.5893e+02_r8,2.3618e+00_r8/)
      kbo(:, 3,26, 9) = (/ &
     &6.5658e+02_r8,4.9255e+02_r8,3.2854e+02_r8,1.6455e+02_r8,2.3770e+00_r8/)
      kbo(:, 4,26, 9) = (/ &
     &6.7915e+02_r8,5.0948e+02_r8,3.3981e+02_r8,1.7016e+02_r8,2.3964e+00_r8/)
      kbo(:, 5,26, 9) = (/ &
     &7.0247e+02_r8,5.2696e+02_r8,3.5146e+02_r8,1.7598e+02_r8,2.4222e+00_r8/)
      kbo(:, 1,27, 9) = (/ &
     &5.2844e+02_r8,3.9646e+02_r8,2.6449e+02_r8,1.3259e+02_r8,2.2032e+00_r8/)
      kbo(:, 2,27, 9) = (/ &
     &5.4789e+02_r8,4.1105e+02_r8,2.7421e+02_r8,1.3742e+02_r8,2.2331e+00_r8/)
      kbo(:, 3,27, 9) = (/ &
     &5.6778e+02_r8,4.2595e+02_r8,2.8414e+02_r8,1.4236e+02_r8,2.2623e+00_r8/)
      kbo(:, 4,27, 9) = (/ &
     &5.8850e+02_r8,4.4149e+02_r8,2.9449e+02_r8,1.4751e+02_r8,2.3009e+00_r8/)
      kbo(:, 5,27, 9) = (/ &
     &6.1090e+02_r8,4.5829e+02_r8,3.0567e+02_r8,1.5309e+02_r8,2.3382e+00_r8/)
      kbo(:, 1,28, 9) = (/ &
     &4.6826e+02_r8,3.5133e+02_r8,2.3440e+02_r8,1.1763e+02_r8,2.0680e+00_r8/)
      kbo(:, 2,28, 9) = (/ &
     &4.8590e+02_r8,3.6454e+02_r8,2.4321e+02_r8,1.2197e+02_r8,2.1100e+00_r8/)
      kbo(:, 3,28, 9) = (/ &
     &5.0445e+02_r8,3.7846e+02_r8,2.5247e+02_r8,1.2655e+02_r8,2.1567e+00_r8/)
      kbo(:, 4,28, 9) = (/ &
     &5.2474e+02_r8,3.9367e+02_r8,2.6260e+02_r8,1.3159e+02_r8,2.2098e+00_r8/)
      kbo(:, 5,28, 9) = (/ &
     &5.4720e+02_r8,4.1051e+02_r8,2.7382e+02_r8,1.3717e+02_r8,2.2620e+00_r8/)
      kbo(:, 1,29, 9) = (/ &
     &4.4072e+02_r8,3.3067e+02_r8,2.2063e+02_r8,1.1082e+02_r8,1.9419e+00_r8/)
      kbo(:, 2,29, 9) = (/ &
     &4.5821e+02_r8,3.4378e+02_r8,2.2936e+02_r8,1.1511e+02_r8,1.9998e+00_r8/)
      kbo(:, 3,29, 9) = (/ &
     &4.7729e+02_r8,3.5808e+02_r8,2.3889e+02_r8,1.1980e+02_r8,2.0671e+00_r8/)
      kbo(:, 4,29, 9) = (/ &
     &4.9882e+02_r8,3.7422e+02_r8,2.4964e+02_r8,1.2512e+02_r8,2.1341e+00_r8/)
      kbo(:, 5,29, 9) = (/ &
     &5.2331e+02_r8,3.9259e+02_r8,2.6188e+02_r8,1.3121e+02_r8,2.1979e+00_r8/)
      kbo(:, 1,30, 9) = (/ &
     &4.2556e+02_r8,3.1930e+02_r8,2.1305e+02_r8,1.0711e+02_r8,1.8309e+00_r8/)
      kbo(:, 2,30, 9) = (/ &
     &4.4407e+02_r8,3.3317e+02_r8,2.2229e+02_r8,1.1161e+02_r8,1.9101e+00_r8/)
      kbo(:, 3,30, 9) = (/ &
     &4.6505e+02_r8,3.4890e+02_r8,2.3276e+02_r8,1.1676e+02_r8,1.9914e+00_r8/)
      kbo(:, 4,30, 9) = (/ &
     &4.8908e+02_r8,3.6692e+02_r8,2.4477e+02_r8,1.2270e+02_r8,2.0709e+00_r8/)
      kbo(:, 5,30, 9) = (/ &
     &5.1660e+02_r8,3.8756e+02_r8,2.5853e+02_r8,1.2954e+02_r8,2.1480e+00_r8/)
      kbo(:, 1,31, 9) = (/ &
     &4.3357e+02_r8,3.2530e+02_r8,2.1704e+02_r8,1.0913e+02_r8,1.7458e+00_r8/)
      kbo(:, 2,31, 9) = (/ &
     &4.5478e+02_r8,3.4120e+02_r8,2.2764e+02_r8,1.1430e+02_r8,1.8393e+00_r8/)
      kbo(:, 3,31, 9) = (/ &
     &4.7940e+02_r8,3.5966e+02_r8,2.3993e+02_r8,1.2035e+02_r8,1.9333e+00_r8/)
      kbo(:, 4,31, 9) = (/ &
     &5.0804e+02_r8,3.8115e+02_r8,2.5425e+02_r8,1.2744e+02_r8,2.0234e+00_r8/)
      kbo(:, 5,31, 9) = (/ &
     &5.4033e+02_r8,4.0536e+02_r8,2.7039e+02_r8,1.3548e+02_r8,2.1150e+00_r8/)
      kbo(:, 1,32, 9) = (/ &
     &4.4897e+02_r8,3.3685e+02_r8,2.2474e+02_r8,1.1298e+02_r8,1.6787e+00_r8/)
      kbo(:, 2,32, 9) = (/ &
     &4.7419e+02_r8,3.5576e+02_r8,2.3734e+02_r8,1.1915e+02_r8,1.7859e+00_r8/)
      kbo(:, 3,32, 9) = (/ &
     &5.0379e+02_r8,3.7796e+02_r8,2.5213e+02_r8,1.2644e+02_r8,1.8899e+00_r8/)
      kbo(:, 4,32, 9) = (/ &
     &5.3795e+02_r8,4.0357e+02_r8,2.6921e+02_r8,1.3492e+02_r8,1.9968e+00_r8/)
      kbo(:, 5,32, 9) = (/ &
     &5.7556e+02_r8,4.3179e+02_r8,2.8802e+02_r8,1.4429e+02_r8,2.0977e+00_r8/)
      kbo(:, 1,33, 9) = (/ &
     &4.7613e+02_r8,3.5721e+02_r8,2.3831e+02_r8,1.1974e+02_r8,1.6313e+00_r8/)
      kbo(:, 2,33, 9) = (/ &
     &5.0727e+02_r8,3.8056e+02_r8,2.5387e+02_r8,1.2739e+02_r8,1.7486e+00_r8/)
      kbo(:, 3,33, 9) = (/ &
     &5.4363e+02_r8,4.0783e+02_r8,2.7205e+02_r8,1.3639e+02_r8,1.8695e+00_r8/)
      kbo(:, 4,33, 9) = (/ &
     &5.8421e+02_r8,4.3828e+02_r8,2.9234e+02_r8,1.4648e+02_r8,1.9835e+00_r8/)
      kbo(:, 5,33, 9) = (/ &
     &6.2742e+02_r8,4.7068e+02_r8,3.1394e+02_r8,1.5725e+02_r8,2.0938e+00_r8/)
      kbo(:, 1,34, 9) = (/ &
     &4.9479e+02_r8,3.7120e+02_r8,2.4764e+02_r8,1.2439e+02_r8,1.5951e+00_r8/)
      kbo(:, 2,34, 9) = (/ &
     &5.3209e+02_r8,3.9918e+02_r8,2.6628e+02_r8,1.3359e+02_r8,1.7258e+00_r8/)
      kbo(:, 3,34, 9) = (/ &
     &5.7463e+02_r8,4.3109e+02_r8,2.8755e+02_r8,1.4413e+02_r8,1.8546e+00_r8/)
      kbo(:, 4,34, 9) = (/ &
     &6.2052e+02_r8,4.6551e+02_r8,3.1050e+02_r8,1.5556e+02_r8,1.9770e+00_r8/)
      kbo(:, 5,34, 9) = (/ &
     &6.6892e+02_r8,5.0180e+02_r8,3.3469e+02_r8,1.6762e+02_r8,2.0917e+00_r8/)
      kbo(:, 1,35, 9) = (/ &
     &5.1474e+02_r8,3.8617e+02_r8,2.5762e+02_r8,1.2939e+02_r8,1.5620e+00_r8/)
      kbo(:, 2,35, 9) = (/ &
     &5.5847e+02_r8,4.1897e+02_r8,2.7948e+02_r8,1.4019e+02_r8,1.7022e+00_r8/)
      kbo(:, 3,35, 9) = (/ &
     &6.0709e+02_r8,4.5544e+02_r8,3.0379e+02_r8,1.5226e+02_r8,1.8365e+00_r8/)
      kbo(:, 4,35, 9) = (/ &
     &6.5852e+02_r8,4.9401e+02_r8,3.2950e+02_r8,1.6506e+02_r8,1.9663e+00_r8/)
      kbo(:, 5,35, 9) = (/ &
     &7.1282e+02_r8,5.3473e+02_r8,3.5664e+02_r8,1.7860e+02_r8,2.0876e+00_r8/)
      kbo(:, 1,36, 9) = (/ &
     &5.3040e+02_r8,3.9792e+02_r8,2.6545e+02_r8,1.3332e+02_r8,1.5229e+00_r8/)
      kbo(:, 2,36, 9) = (/ &
     &5.8002e+02_r8,4.3513e+02_r8,2.9026e+02_r8,1.4559e+02_r8,1.6698e+00_r8/)
      kbo(:, 3,36, 9) = (/ &
     &6.3422e+02_r8,4.7578e+02_r8,3.1736e+02_r8,1.5904e+02_r8,1.8112e+00_r8/)
      kbo(:, 4,36, 9) = (/ &
     &6.9154e+02_r8,5.1877e+02_r8,3.4601e+02_r8,1.7331e+02_r8,1.9470e+00_r8/)
      kbo(:, 5,36, 9) = (/ &
     &7.5259e+02_r8,5.6456e+02_r8,3.7653e+02_r8,1.8854e+02_r8,2.0786e+00_r8/)
      kbo(:, 1,37, 9) = (/ &
     &5.2761e+02_r8,3.9583e+02_r8,2.6405e+02_r8,1.3269e+02_r8,1.4669e+00_r8/)
      kbo(:, 2,37, 9) = (/ &
     &5.8107e+02_r8,4.3593e+02_r8,2.9079e+02_r8,1.4590e+02_r8,1.6200e+00_r8/)
      kbo(:, 3,37, 9) = (/ &
     &6.3936e+02_r8,4.7964e+02_r8,3.1993e+02_r8,1.6036e+02_r8,1.7687e+00_r8/)
      kbo(:, 4,37, 9) = (/ &
     &7.0149e+02_r8,5.2623e+02_r8,3.5098e+02_r8,1.7581e+02_r8,1.9104e+00_r8/)
      kbo(:, 5,37, 9) = (/ &
     &7.6801e+02_r8,5.7612e+02_r8,3.8424e+02_r8,1.9240e+02_r8,2.0492e+00_r8/)
      kbo(:, 1,38, 9) = (/ &
     &5.3320e+02_r8,4.0002e+02_r8,2.6686e+02_r8,1.3414e+02_r8,1.4150e+00_r8/)
      kbo(:, 2,38, 9) = (/ &
     &5.9148e+02_r8,4.4373e+02_r8,2.9599e+02_r8,1.4854e+02_r8,1.5738e+00_r8/)
      kbo(:, 3,38, 9) = (/ &
     &6.5505e+02_r8,4.9141e+02_r8,3.2778e+02_r8,1.6430e+02_r8,1.7289e+00_r8/)
      kbo(:, 4,38, 9) = (/ &
     &7.2345e+02_r8,5.4270e+02_r8,3.6197e+02_r8,1.8131e+02_r8,1.8759e+00_r8/)
      kbo(:, 5,38, 9) = (/ &
     &7.9740e+02_r8,5.9816e+02_r8,3.9894e+02_r8,1.9975e+02_r8,2.0221e+00_r8/)
      kbo(:, 1,39, 9) = (/ &
     &5.5268e+02_r8,4.1463e+02_r8,2.7660e+02_r8,1.3905e+02_r8,1.3683e+00_r8/)
      kbo(:, 2,39, 9) = (/ &
     &6.1737e+02_r8,4.6316e+02_r8,3.0895e+02_r8,1.5504e+02_r8,1.5320e+00_r8/)
      kbo(:, 3,39, 9) = (/ &
     &6.8821e+02_r8,5.1628e+02_r8,3.4436e+02_r8,1.7260e+02_r8,1.6920e+00_r8/)
      kbo(:, 4,39, 9) = (/ &
     &7.6555e+02_r8,5.7429e+02_r8,3.8302e+02_r8,1.9184e+02_r8,1.8468e+00_r8/)
      kbo(:, 5,39, 9) = (/ &
     &8.4965e+02_r8,6.3736e+02_r8,4.2508e+02_r8,2.1282e+02_r8,1.9969e+00_r8/)
      kbo(:, 1,40, 9) = (/ &
     &5.3311e+02_r8,3.9996e+02_r8,2.6682e+02_r8,1.3428e+02_r8,1.3069e+00_r8/)
      kbo(:, 2,40, 9) = (/ &
     &5.9979e+02_r8,4.4997e+02_r8,3.0016e+02_r8,1.5072e+02_r8,1.4753e+00_r8/)
      kbo(:, 3,40, 9) = (/ &
     &6.7343e+02_r8,5.0519e+02_r8,3.3697e+02_r8,1.6896e+02_r8,1.6406e+00_r8/)
      kbo(:, 4,40, 9) = (/ &
     &7.5472e+02_r8,5.6615e+02_r8,3.7760e+02_r8,1.8916e+02_r8,1.7999e+00_r8/)
      kbo(:, 5,40, 9) = (/ &
     &8.4379e+02_r8,6.3296e+02_r8,4.2214e+02_r8,2.1136e+02_r8,1.9558e+00_r8/)
      kbo(:, 1,41, 9) = (/ &
     &5.1260e+02_r8,3.8458e+02_r8,2.5658e+02_r8,1.2928e+02_r8,1.2459e+00_r8/)
      kbo(:, 2,41, 9) = (/ &
     &5.8131e+02_r8,4.3611e+02_r8,2.9093e+02_r8,1.4621e+02_r8,1.4179e+00_r8/)
      kbo(:, 3,41, 9) = (/ &
     &6.5741e+02_r8,4.9318e+02_r8,3.2896e+02_r8,1.6503e+02_r8,1.5871e+00_r8/)
      kbo(:, 4,41, 9) = (/ &
     &7.4227e+02_r8,5.5683e+02_r8,3.7139e+02_r8,1.8609e+02_r8,1.7498e+00_r8/)
      kbo(:, 5,41, 9) = (/ &
     &8.3623e+02_r8,6.2730e+02_r8,4.1837e+02_r8,2.0950e+02_r8,1.9122e+00_r8/)
      kbo(:, 1,42, 9) = (/ &
     &4.9831e+02_r8,3.7386e+02_r8,2.4944e+02_r8,1.2584e+02_r8,1.1865e+00_r8/)
      kbo(:, 2,42, 9) = (/ &
     &5.6980e+02_r8,4.2748e+02_r8,2.8517e+02_r8,1.4342e+02_r8,1.3622e+00_r8/)
      kbo(:, 3,42, 9) = (/ &
     &6.4955e+02_r8,4.8728e+02_r8,3.2503e+02_r8,1.6313e+02_r8,1.5361e+00_r8/)
      kbo(:, 4,42, 9) = (/ &
     &7.3900e+02_r8,5.5437e+02_r8,3.6975e+02_r8,1.8531e+02_r8,1.7026e+00_r8/)
      kbo(:, 5,42, 9) = (/ &
     &8.3900e+02_r8,6.2937e+02_r8,4.1975e+02_r8,2.1021e+02_r8,1.8688e+00_r8/)
      kbo(:, 1,43, 9) = (/ &
     &4.8522e+02_r8,3.6405e+02_r8,2.4292e+02_r8,1.2271e+02_r8,1.1188e+00_r8/)
      kbo(:, 2,43, 9) = (/ &
     &5.5936e+02_r8,4.1965e+02_r8,2.7996e+02_r8,1.4092e+02_r8,1.2979e+00_r8/)
      kbo(:, 3,43, 9) = (/ &
     &6.4330e+02_r8,4.8260e+02_r8,3.2191e+02_r8,1.6164e+02_r8,1.4736e+00_r8/)
      kbo(:, 4,43, 9) = (/ &
     &7.3773e+02_r8,5.5342e+02_r8,3.6912e+02_r8,1.8505e+02_r8,1.6463e+00_r8/)
      kbo(:, 5,43, 9) = (/ &
     &8.4419e+02_r8,6.3327e+02_r8,4.2235e+02_r8,2.1154e+02_r8,1.8168e+00_r8/)
      kbo(:, 1,44, 9) = (/ &
     &4.7662e+02_r8,3.5759e+02_r8,2.3863e+02_r8,1.2069e+02_r8,1.0480e+00_r8/)
      kbo(:, 2,44, 9) = (/ &
     &5.5453e+02_r8,4.1603e+02_r8,2.7755e+02_r8,1.3982e+02_r8,1.2297e+00_r8/)
      kbo(:, 3,44, 9) = (/ &
     &6.4348e+02_r8,4.8273e+02_r8,3.2200e+02_r8,1.6176e+02_r8,1.4085e+00_r8/)
      kbo(:, 4,44, 9) = (/ &
     &7.4447e+02_r8,5.5848e+02_r8,3.7249e+02_r8,1.8678e+02_r8,1.5847e+00_r8/)
      kbo(:, 5,44, 9) = (/ &
     &8.5855e+02_r8,6.4403e+02_r8,4.2953e+02_r8,2.1515e+02_r8,1.7587e+00_r8/)
      kbo(:, 1,45, 9) = (/ &
     &4.7694e+02_r8,3.5784e+02_r8,2.3881e+02_r8,1.2088e+02_r8,9.8025e-01_r8/)
      kbo(:, 2,45, 9) = (/ &
     &5.6049e+02_r8,4.2050e+02_r8,2.8054e+02_r8,1.4139e+02_r8,1.1623e+00_r8/)
      kbo(:, 3,45, 9) = (/ &
     &6.5632e+02_r8,4.9237e+02_r8,3.2842e+02_r8,1.6503e+02_r8,1.3439e+00_r8/)
      kbo(:, 4,45, 9) = (/ &
     &7.6635e+02_r8,5.7488e+02_r8,3.8343e+02_r8,1.9228e+02_r8,1.5236e+00_r8/)
      kbo(:, 5,45, 9) = (/ &
     &8.9123e+02_r8,6.6854e+02_r8,4.4587e+02_r8,2.2334e+02_r8,1.7007e+00_r8/)
      kbo(:, 1,46, 9) = (/ &
     &4.7924e+02_r8,3.5957e+02_r8,2.3999e+02_r8,1.2157e+02_r8,9.0983e-01_r8/)
      kbo(:, 2,46, 9) = (/ &
     &5.6922e+02_r8,4.2705e+02_r8,2.8491e+02_r8,1.4366e+02_r8,1.0922e+00_r8/)
      kbo(:, 3,46, 9) = (/ &
     &6.7352e+02_r8,5.0527e+02_r8,3.3703e+02_r8,1.6939e+02_r8,1.2757e+00_r8/)
      kbo(:, 4,46, 9) = (/ &
     &7.9367e+02_r8,5.9538e+02_r8,3.9709e+02_r8,1.9915e+02_r8,1.4579e+00_r8/)
      kbo(:, 5,46, 9) = (/ &
     &9.3189e+02_r8,6.9904e+02_r8,4.6620e+02_r8,2.3352e+02_r8,1.6382e+00_r8/)
      kbo(:, 1,47, 9) = (/ &
     &4.7215e+02_r8,3.5425e+02_r8,2.3648e+02_r8,1.1995e+02_r8,8.3319e-01_r8/)
      kbo(:, 2,47, 9) = (/ &
     &5.6710e+02_r8,4.2546e+02_r8,2.8387e+02_r8,1.4325e+02_r8,1.0142e+00_r8/)
      kbo(:, 3,47, 9) = (/ &
     &6.7881e+02_r8,5.0924e+02_r8,3.3968e+02_r8,1.7081e+02_r8,1.1988e+00_r8/)
      kbo(:, 4,47, 9) = (/ &
     &8.0796e+02_r8,6.0609e+02_r8,4.0424e+02_r8,2.0278e+02_r8,1.3835e+00_r8/)
      kbo(:, 5,47, 9) = (/ &
     &9.5794e+02_r8,7.1858e+02_r8,4.7923e+02_r8,2.4007e+02_r8,1.5668e+00_r8/)
      kbo(:, 1,48, 9) = (/ &
     &4.7667e+02_r8,3.5764e+02_r8,2.3876e+02_r8,1.2119e+02_r8,7.5823e-01_r8/)
      kbo(:, 2,48, 9) = (/ &
     &5.7865e+02_r8,4.3413e+02_r8,2.8965e+02_r8,1.4623e+02_r8,9.3799e-01_r8/)
      kbo(:, 3,48, 9) = (/ &
     &7.0145e+02_r8,5.2622e+02_r8,3.5101e+02_r8,1.7653e+02_r8,1.1229e+00_r8/)
      kbo(:, 4,48, 9) = (/ &
     &8.4427e+02_r8,6.3333e+02_r8,4.2240e+02_r8,2.1190e+02_r8,1.3089e+00_r8/)
      kbo(:, 5,48, 9) = (/ &
     &1.0109e+03_r8,7.5832e+02_r8,5.0573e+02_r8,2.5334e+02_r8,1.4951e+00_r8/)
      kbo(:, 1,49, 9) = (/ &
     &4.9957e+02_r8,3.7481e+02_r8,2.5022e+02_r8,1.2697e+02_r8,6.8631e-01_r8/)
      kbo(:, 2,49, 9) = (/ &
     &6.1224e+02_r8,4.5931e+02_r8,3.0645e+02_r8,1.5466e+02_r8,8.6353e-01_r8/)
      kbo(:, 3,49, 9) = (/ &
     &7.5197e+02_r8,5.6411e+02_r8,3.7627e+02_r8,1.8917e+02_r8,1.0480e+00_r8/)
      kbo(:, 4,49, 9) = (/ &
     &9.1643e+02_r8,6.8745e+02_r8,4.5848e+02_r8,2.2994e+02_r8,1.2341e+00_r8/)
      kbo(:, 5,49, 9) = (/ &
     &1.1094e+03_r8,8.3219e+02_r8,5.5497e+02_r8,2.7795e+02_r8,1.4234e+00_r8/)
      kbo(:, 1,50, 9) = (/ &
     &4.9927e+02_r8,3.7459e+02_r8,2.5011e+02_r8,1.2702e+02_r8,6.2082e-01_r8/)
      kbo(:, 2,50, 9) = (/ &
     &6.1745e+02_r8,4.6322e+02_r8,3.0907e+02_r8,1.5606e+02_r8,7.9337e-01_r8/)
      kbo(:, 3,50, 9) = (/ &
     &7.6850e+02_r8,5.7651e+02_r8,3.8454e+02_r8,1.9338e+02_r8,9.7702e-01_r8/)
      kbo(:, 4,50, 9) = (/ &
     &9.4909e+02_r8,7.1195e+02_r8,4.7482e+02_r8,2.3816e+02_r8,1.1637e+00_r8/)
      kbo(:, 5,50, 9) = (/ &
     &1.1628e+03_r8,8.7227e+02_r8,5.8169e+02_r8,2.9133e+02_r8,1.3527e+00_r8/)
      kbo(:, 1,51, 9) = (/ &
     &4.8758e+02_r8,3.6583e+02_r8,2.4432e+02_r8,1.2426e+02_r8,5.5888e-01_r8/)
      kbo(:, 2,51, 9) = (/ &
     &6.0851e+02_r8,4.5652e+02_r8,3.0463e+02_r8,1.5396e+02_r8,7.2702e-01_r8/)
      kbo(:, 3,51, 9) = (/ &
     &7.6706e+02_r8,5.7543e+02_r8,3.8383e+02_r8,1.9312e+02_r8,9.0804e-01_r8/)
      kbo(:, 4,51, 9) = (/ &
     &9.6042e+02_r8,7.2045e+02_r8,4.8049e+02_r8,2.4107e+02_r8,1.0946e+00_r8/)
      kbo(:, 5,51, 9) = (/ &
     &1.1920e+03_r8,8.9415e+02_r8,5.9629e+02_r8,2.9867e+02_r8,1.2844e+00_r8/)
      kbo(:, 1,52, 9) = (/ &
     &4.8860e+02_r8,3.6660e+02_r8,2.4488e+02_r8,1.2464e+02_r8,4.9962e-01_r8/)
      kbo(:, 2,52, 9) = (/ &
     &6.1451e+02_r8,4.6102e+02_r8,3.0765e+02_r8,1.5555e+02_r8,6.6320e-01_r8/)
      kbo(:, 3,52, 9) = (/ &
     &7.8418e+02_r8,5.8827e+02_r8,3.9240e+02_r8,1.9747e+02_r8,8.4128e-01_r8/)
      kbo(:, 4,52, 9) = (/ &
     &9.9602e+02_r8,7.4715e+02_r8,4.9829e+02_r8,2.5001e+02_r8,1.0268e+00_r8/)
      kbo(:, 5,52, 9) = (/ &
     &1.2534e+03_r8,9.4018e+02_r8,6.2698e+02_r8,3.1403e+02_r8,1.2165e+00_r8/)
      kbo(:, 1,53, 9) = (/ &
     &5.0881e+02_r8,3.8175e+02_r8,2.5500e+02_r8,1.2975e+02_r8,4.4418e-01_r8/)
      kbo(:, 2,53, 9) = (/ &
     &6.4426e+02_r8,4.8334e+02_r8,3.2253e+02_r8,1.6302e+02_r8,6.0138e-01_r8/)
      kbo(:, 3,53, 9) = (/ &
     &8.3158e+02_r8,6.2382e+02_r8,4.1611e+02_r8,2.0933e+02_r8,7.7570e-01_r8/)
      kbo(:, 4,53, 9) = (/ &
     &1.0715e+03_r8,8.0375e+02_r8,5.3603e+02_r8,2.6888e+02_r8,9.5940e-01_r8/)
      kbo(:, 5,53, 9) = (/ &
     &1.3680e+03_r8,1.0262e+03_r8,6.8430e+02_r8,3.4269e+02_r8,1.1487e+00_r8/)
      kbo(:, 1,54, 9) = (/ &
     &4.6019e+02_r8,3.4529e+02_r8,2.3082e+02_r8,1.1788e+02_r8,3.9422e-01_r8/)
      kbo(:, 2,54, 9) = (/ &
     &5.8633e+02_r8,4.3988e+02_r8,2.9364e+02_r8,1.4879e+02_r8,5.4422e-01_r8/)
      kbo(:, 3,54, 9) = (/ &
     &7.6477e+02_r8,5.7372e+02_r8,3.8273e+02_r8,1.9285e+02_r8,7.1419e-01_r8/)
      kbo(:, 4,54, 9) = (/ &
     &9.9975e+02_r8,7.4995e+02_r8,5.0017e+02_r8,2.5112e+02_r8,8.9603e-01_r8/)
      kbo(:, 5,54, 9) = (/ &
     &1.2952e+03_r8,9.7153e+02_r8,6.4788e+02_r8,3.2458e+02_r8,1.0830e+00_r8/)
      kbo(:, 1,55, 9) = (/ &
     &3.8020e+02_r8,2.8531e+02_r8,1.9107e+02_r8,9.8307e+01_r8,3.4739e-01_r8/)
      kbo(:, 2,55, 9) = (/ &
     &4.8735e+02_r8,3.6565e+02_r8,2.4430e+02_r8,1.2445e+02_r8,4.9078e-01_r8/)
      kbo(:, 3,55, 9) = (/ &
     &6.4163e+02_r8,4.8136e+02_r8,3.2124e+02_r8,1.6243e+02_r8,6.5484e-01_r8/)
      kbo(:, 4,55, 9) = (/ &
     &8.5082e+02_r8,6.3825e+02_r8,4.2573e+02_r8,2.1419e+02_r8,8.3371e-01_r8/)
      kbo(:, 5,55, 9) = (/ &
     &1.1188e+03_r8,8.3927e+02_r8,5.5970e+02_r8,2.8072e+02_r8,1.0198e+00_r8/)
      kbo(:, 1,56, 9) = (/ &
     &3.1368e+02_r8,2.3545e+02_r8,1.5809e+02_r8,8.2086e+01_r8,3.0410e-01_r8/)
      kbo(:, 2,56, 9) = (/ &
     &4.0416e+02_r8,3.0326e+02_r8,2.0292e+02_r8,1.0407e+02_r8,4.3985e-01_r8/)
      kbo(:, 3,56, 9) = (/ &
     &5.3658e+02_r8,4.0257e+02_r8,2.6883e+02_r8,1.3655e+02_r8,5.9766e-01_r8/)
      kbo(:, 4,56, 9) = (/ &
     &7.2129e+02_r8,5.4110e+02_r8,3.6102e+02_r8,1.8214e+02_r8,7.7256e-01_r8/)
      kbo(:, 5,56, 9) = (/ &
     &9.6339e+02_r8,7.2268e+02_r8,4.8200e+02_r8,2.4214e+02_r8,9.5689e-01_r8/)
      kbo(:, 1,57, 9) = (/ &
     &2.5819e+02_r8,1.9390e+02_r8,1.3066e+02_r8,6.8602e+01_r8,2.6463e-01_r8/)
      kbo(:, 2,57, 9) = (/ &
     &3.3457e+02_r8,2.5110e+02_r8,1.6838e+02_r8,8.7076e+01_r8,3.9133e-01_r8/)
      kbo(:, 3,57, 9) = (/ &
     &4.4726e+02_r8,3.3558e+02_r8,2.2435e+02_r8,1.1462e+02_r8,5.4231e-01_r8/)
      kbo(:, 4,57, 9) = (/ &
     &6.0897e+02_r8,4.5687e+02_r8,3.0496e+02_r8,1.5443e+02_r8,7.1198e-01_r8/)
      kbo(:, 5,57, 9) = (/ &
     &8.2628e+02_r8,6.1985e+02_r8,4.1347e+02_r8,2.0818e+02_r8,8.9451e-01_r8/)
      kbo(:, 1,58, 9) = (/ &
     &5.6144e+01_r8,5.1598e+01_r8,4.4952e+01_r8,3.3575e+01_r8,2.2945e-01_r8/)
      kbo(:, 2,58, 9) = (/ &
     &7.3248e+01_r8,6.7230e+01_r8,5.8185e+01_r8,4.2642e+01_r8,3.4680e-01_r8/)
      kbo(:, 3,58, 9) = (/ &
     &9.8566e+01_r8,9.0421e+01_r8,7.7903e+01_r8,5.6215e+01_r8,4.9127e-01_r8/)
      kbo(:, 4,58, 9) = (/ &
     &1.3577e+02_r8,1.2452e+02_r8,1.0700e+02_r8,7.6316e+01_r8,6.5580e-01_r8/)
      kbo(:, 5,58, 9) = (/ &
     &1.8716e+02_r8,1.7164e+02_r8,1.4731e+02_r8,1.0424e+02_r8,8.3481e-01_r8/)
      kbo(:, 1,59, 9) = (/ &
     &5.7246e+01_r8,5.0299e+01_r8,4.1347e+01_r8,2.8542e+01_r8,2.1390e-01_r8/)
      kbo(:, 2,59, 9) = (/ &
     &7.5569e+01_r8,6.6181e+01_r8,5.3818e+01_r8,3.6138e+01_r8,3.2687e-01_r8/)
      kbo(:, 3,59, 9) = (/ &
     &1.0297e+02_r8,9.0031e+01_r8,7.2620e+01_r8,4.7606e+01_r8,4.6582e-01_r8/)
      kbo(:, 4,59, 9) = (/ &
     &1.4369e+02_r8,1.2555e+02_r8,1.0072e+02_r8,6.4807e+01_r8,6.2712e-01_r8/)
      kbo(:, 5,59, 9) = (/ &
     &2.0105e+02_r8,1.7562e+02_r8,1.4046e+02_r8,8.9199e+01_r8,8.0292e-01_r8/)
      kbo(:, 1,13,10) = (/ &
     &1.3594e+05_r8,1.0195e+05_r8,6.7969e+04_r8,3.3985e+04_r8,3.3627e+00_r8/)
      kbo(:, 2,13,10) = (/ &
     &1.3605e+05_r8,1.0204e+05_r8,6.8026e+04_r8,3.4013e+04_r8,3.2528e+00_r8/)
      kbo(:, 3,13,10) = (/ &
     &1.3597e+05_r8,1.0198e+05_r8,6.7984e+04_r8,3.3992e+04_r8,3.1814e+00_r8/)
      kbo(:, 4,13,10) = (/ &
     &1.3504e+05_r8,1.0128e+05_r8,6.7520e+04_r8,3.3760e+04_r8,3.0515e+00_r8/)
      kbo(:, 5,13,10) = (/ &
     &1.3382e+05_r8,1.0037e+05_r8,6.6910e+04_r8,3.3456e+04_r8,3.0303e+00_r8/)
      kbo(:, 1,14,10) = (/ &
     &8.3672e+04_r8,6.2754e+04_r8,4.1836e+04_r8,2.0918e+04_r8,3.6220e+00_r8/)
      kbo(:, 2,14,10) = (/ &
     &8.3355e+04_r8,6.2516e+04_r8,4.1677e+04_r8,2.0839e+04_r8,3.5454e+00_r8/)
      kbo(:, 3,14,10) = (/ &
     &8.2924e+04_r8,6.2193e+04_r8,4.1462e+04_r8,2.0731e+04_r8,3.4328e+00_r8/)
      kbo(:, 4,14,10) = (/ &
     &8.2189e+04_r8,6.1641e+04_r8,4.1094e+04_r8,2.0547e+04_r8,3.3922e+00_r8/)
      kbo(:, 5,14,10) = (/ &
     &8.1205e+04_r8,6.0904e+04_r8,4.0602e+04_r8,2.0301e+04_r8,3.2425e+00_r8/)
      kbo(:, 1,15,10) = (/ &
     &5.1150e+04_r8,3.8363e+04_r8,2.5576e+04_r8,1.2788e+04_r8,3.9145e+00_r8/)
      kbo(:, 2,15,10) = (/ &
     &5.0875e+04_r8,3.8157e+04_r8,2.5438e+04_r8,1.2719e+04_r8,3.8152e+00_r8/)
      kbo(:, 3,15,10) = (/ &
     &5.0407e+04_r8,3.7806e+04_r8,2.5204e+04_r8,1.2602e+04_r8,3.7733e+00_r8/)
      kbo(:, 4,15,10) = (/ &
     &4.9693e+04_r8,3.7270e+04_r8,2.4847e+04_r8,1.2424e+04_r8,3.6717e+00_r8/)
      kbo(:, 5,15,10) = (/ &
     &4.8987e+04_r8,3.6740e+04_r8,2.4494e+04_r8,1.2247e+04_r8,3.5647e+00_r8/)
      kbo(:, 1,16,10) = (/ &
     &3.6535e+04_r8,2.7401e+04_r8,1.8268e+04_r8,9.1341e+03_r8,4.2542e+00_r8/)
      kbo(:, 2,16,10) = (/ &
     &3.6151e+04_r8,2.7114e+04_r8,1.8076e+04_r8,9.0383e+03_r8,4.1666e+00_r8/)
      kbo(:, 3,16,10) = (/ &
     &3.5666e+04_r8,2.6750e+04_r8,1.7833e+04_r8,8.9169e+03_r8,4.1063e+00_r8/)
      kbo(:, 4,16,10) = (/ &
     &3.5133e+04_r8,2.6350e+04_r8,1.7567e+04_r8,8.7838e+03_r8,4.0309e+00_r8/)
      kbo(:, 5,16,10) = (/ &
     &3.4526e+04_r8,2.5894e+04_r8,1.7263e+04_r8,8.6318e+03_r8,3.8978e+00_r8/)
      kbo(:, 1,17,10) = (/ &
     &2.6414e+04_r8,1.9811e+04_r8,1.3207e+04_r8,6.6039e+03_r8,4.6454e+00_r8/)
      kbo(:, 2,17,10) = (/ &
     &2.6068e+04_r8,1.9551e+04_r8,1.3034e+04_r8,6.5174e+03_r8,4.5633e+00_r8/)
      kbo(:, 3,17,10) = (/ &
     &2.5689e+04_r8,1.9267e+04_r8,1.2845e+04_r8,6.4225e+03_r8,4.4826e+00_r8/)
      kbo(:, 4,17,10) = (/ &
     &2.5209e+04_r8,1.8907e+04_r8,1.2605e+04_r8,6.3027e+03_r8,4.3889e+00_r8/)
      kbo(:, 5,17,10) = (/ &
     &2.4661e+04_r8,1.8496e+04_r8,1.2331e+04_r8,6.1658e+03_r8,4.2589e+00_r8/)
      kbo(:, 1,18,10) = (/ &
     &1.9208e+04_r8,1.4406e+04_r8,9.6044e+03_r8,4.8025e+03_r8,5.0342e+00_r8/)
      kbo(:, 2,18,10) = (/ &
     &1.8927e+04_r8,1.4195e+04_r8,9.4636e+03_r8,4.7320e+03_r8,4.9453e+00_r8/)
      kbo(:, 3,18,10) = (/ &
     &1.8575e+04_r8,1.3931e+04_r8,9.2875e+03_r8,4.6440e+03_r8,4.8565e+00_r8/)
      kbo(:, 4,18,10) = (/ &
     &1.8151e+04_r8,1.3614e+04_r8,9.0760e+03_r8,4.5383e+03_r8,4.7616e+00_r8/)
      kbo(:, 5,18,10) = (/ &
     &1.7715e+04_r8,1.3287e+04_r8,8.8579e+03_r8,4.4292e+03_r8,4.6381e+00_r8/)
      kbo(:, 1,19,10) = (/ &
     &1.3561e+04_r8,1.0171e+04_r8,6.7808e+03_r8,3.3906e+03_r8,5.4045e+00_r8/)
      kbo(:, 2,19,10) = (/ &
     &1.3305e+04_r8,9.9790e+03_r8,6.6528e+03_r8,3.3267e+03_r8,5.3114e+00_r8/)
      kbo(:, 3,19,10) = (/ &
     &1.3001e+04_r8,9.7507e+03_r8,6.5006e+03_r8,3.2506e+03_r8,5.2250e+00_r8/)
      kbo(:, 4,19,10) = (/ &
     &1.2687e+04_r8,9.5155e+03_r8,6.3438e+03_r8,3.1722e+03_r8,5.1407e+00_r8/)
      kbo(:, 5,19,10) = (/ &
     &1.2394e+04_r8,9.2960e+03_r8,6.1975e+03_r8,3.0991e+03_r8,5.0251e+00_r8/)
      kbo(:, 1,20,10) = (/ &
     &1.0195e+04_r8,7.6466e+03_r8,5.0979e+03_r8,2.5492e+03_r8,5.7652e+00_r8/)
      kbo(:, 2,20,10) = (/ &
     &9.9631e+03_r8,7.4725e+03_r8,4.9818e+03_r8,2.4912e+03_r8,5.6804e+00_r8/)
      kbo(:, 3,20,10) = (/ &
     &9.7293e+03_r8,7.2971e+03_r8,4.8649e+03_r8,2.4328e+03_r8,5.6092e+00_r8/)
      kbo(:, 4,20,10) = (/ &
     &9.5227e+03_r8,7.1421e+03_r8,4.7616e+03_r8,2.3811e+03_r8,5.5285e+00_r8/)
      kbo(:, 5,20,10) = (/ &
     &9.3625e+03_r8,7.0220e+03_r8,4.6816e+03_r8,2.3411e+03_r8,5.3995e+00_r8/)
      kbo(:, 1,21,10) = (/ &
     &7.7885e+03_r8,5.8415e+03_r8,3.8945e+03_r8,1.9475e+03_r8,6.1280e+00_r8/)
      kbo(:, 2,21,10) = (/ &
     &7.6092e+03_r8,5.7071e+03_r8,3.8049e+03_r8,1.9027e+03_r8,6.0467e+00_r8/)
      kbo(:, 3,21,10) = (/ &
     &7.4658e+03_r8,5.5995e+03_r8,3.7332e+03_r8,1.8669e+03_r8,5.9782e+00_r8/)
      kbo(:, 4,21,10) = (/ &
     &7.3647e+03_r8,5.5237e+03_r8,3.6826e+03_r8,1.8416e+03_r8,5.8911e+00_r8/)
      kbo(:, 5,21,10) = (/ &
     &7.2928e+03_r8,5.4698e+03_r8,3.6467e+03_r8,1.8237e+03_r8,5.7660e+00_r8/)
      kbo(:, 1,22,10) = (/ &
     &6.0472e+03_r8,4.5355e+03_r8,3.0239e+03_r8,1.5122e+03_r8,6.4389e+00_r8/)
      kbo(:, 2,22,10) = (/ &
     &5.9457e+03_r8,4.4594e+03_r8,2.9731e+03_r8,1.4868e+03_r8,6.3534e+00_r8/)
      kbo(:, 3,22,10) = (/ &
     &5.8843e+03_r8,4.4133e+03_r8,2.9424e+03_r8,1.4715e+03_r8,6.3043e+00_r8/)
      kbo(:, 4,22,10) = (/ &
     &5.8543e+03_r8,4.3909e+03_r8,2.9274e+03_r8,1.4640e+03_r8,6.2309e+00_r8/)
      kbo(:, 5,22,10) = (/ &
     &5.8906e+03_r8,4.4181e+03_r8,2.9456e+03_r8,1.4732e+03_r8,6.0993e+00_r8/)
      kbo(:, 1,23,10) = (/ &
     &4.7512e+03_r8,3.5635e+03_r8,2.3758e+03_r8,1.1882e+03_r8,6.6888e+00_r8/)
      kbo(:, 2,23,10) = (/ &
     &4.7151e+03_r8,3.5365e+03_r8,2.3578e+03_r8,1.1792e+03_r8,6.6289e+00_r8/)
      kbo(:, 3,23,10) = (/ &
     &4.7153e+03_r8,3.5366e+03_r8,2.3579e+03_r8,1.1792e+03_r8,6.5888e+00_r8/)
      kbo(:, 4,23,10) = (/ &
     &4.7757e+03_r8,3.5820e+03_r8,2.3882e+03_r8,1.1944e+03_r8,6.5103e+00_r8/)
      kbo(:, 5,23,10) = (/ &
     &4.8784e+03_r8,3.6590e+03_r8,2.4396e+03_r8,1.2201e+03_r8,6.3750e+00_r8/)
      kbo(:, 1,24,10) = (/ &
     &3.7664e+03_r8,2.8249e+03_r8,1.8835e+03_r8,9.4199e+02_r8,6.8939e+00_r8/)
      kbo(:, 2,24,10) = (/ &
     &3.7833e+03_r8,2.8376e+03_r8,1.8919e+03_r8,9.4626e+02_r8,6.8560e+00_r8/)
      kbo(:, 3,24,10) = (/ &
     &3.8524e+03_r8,2.8895e+03_r8,1.9265e+03_r8,9.6361e+02_r8,6.8233e+00_r8/)
      kbo(:, 4,24,10) = (/ &
     &3.9503e+03_r8,2.9629e+03_r8,1.9755e+03_r8,9.8811e+02_r8,6.7364e+00_r8/)
      kbo(:, 5,24,10) = (/ &
     &4.0500e+03_r8,3.0377e+03_r8,2.0254e+03_r8,1.0130e+03_r8,6.5861e+00_r8/)
      kbo(:, 1,25,10) = (/ &
     &3.0705e+03_r8,2.3030e+03_r8,1.5356e+03_r8,7.6808e+02_r8,7.0352e+00_r8/)
      kbo(:, 2,25,10) = (/ &
     &3.1368e+03_r8,2.3527e+03_r8,1.5687e+03_r8,7.8472e+02_r8,7.0310e+00_r8/)
      kbo(:, 3,25,10) = (/ &
     &3.2299e+03_r8,2.4226e+03_r8,1.6153e+03_r8,8.0803e+02_r8,7.0074e+00_r8/)
      kbo(:, 4,25,10) = (/ &
     &3.3291e+03_r8,2.4970e+03_r8,1.6649e+03_r8,8.3282e+02_r8,6.9138e+00_r8/)
      kbo(:, 5,25,10) = (/ &
     &3.4334e+03_r8,2.5753e+03_r8,1.7171e+03_r8,8.5889e+02_r8,6.7836e+00_r8/)
      kbo(:, 1,26,10) = (/ &
     &2.5973e+03_r8,1.9481e+03_r8,1.2990e+03_r8,6.4986e+02_r8,7.1301e+00_r8/)
      kbo(:, 2,26,10) = (/ &
     &2.6809e+03_r8,2.0109e+03_r8,1.3408e+03_r8,6.7078e+02_r8,7.1546e+00_r8/)
      kbo(:, 3,26,10) = (/ &
     &2.7748e+03_r8,2.0813e+03_r8,1.3878e+03_r8,6.9426e+02_r8,7.1359e+00_r8/)
      kbo(:, 4,26,10) = (/ &
     &2.8656e+03_r8,2.1494e+03_r8,1.4332e+03_r8,7.1694e+02_r8,7.0388e+00_r8/)
      kbo(:, 5,26,10) = (/ &
     &2.9554e+03_r8,2.2167e+03_r8,1.4780e+03_r8,7.3936e+02_r8,6.9309e+00_r8/)
      kbo(:, 1,27,10) = (/ &
     &2.3040e+03_r8,1.7282e+03_r8,1.1524e+03_r8,5.7657e+02_r8,7.1805e+00_r8/)
      kbo(:, 2,27,10) = (/ &
     &2.3938e+03_r8,1.7956e+03_r8,1.1973e+03_r8,5.9902e+02_r8,7.2265e+00_r8/)
      kbo(:, 3,27,10) = (/ &
     &2.4776e+03_r8,1.8584e+03_r8,1.2392e+03_r8,6.1996e+02_r8,7.2160e+00_r8/)
      kbo(:, 4,27,10) = (/ &
     &2.5592e+03_r8,1.9196e+03_r8,1.2799e+03_r8,6.4031e+02_r8,7.1019e+00_r8/)
      kbo(:, 5,27,10) = (/ &
     &2.6344e+03_r8,1.9760e+03_r8,1.3176e+03_r8,6.5914e+02_r8,7.0533e+00_r8/)
      kbo(:, 1,28,10) = (/ &
     &2.1016e+03_r8,1.5764e+03_r8,1.0512e+03_r8,5.2597e+02_r8,7.1943e+00_r8/)
      kbo(:, 2,28,10) = (/ &
     &2.1832e+03_r8,1.6376e+03_r8,1.0920e+03_r8,5.4637e+02_r8,7.2562e+00_r8/)
      kbo(:, 3,28,10) = (/ &
     &2.2626e+03_r8,1.6971e+03_r8,1.1316e+03_r8,5.6618e+02_r8,7.2356e+00_r8/)
      kbo(:, 4,28,10) = (/ &
     &2.3367e+03_r8,1.7527e+03_r8,1.1687e+03_r8,5.8470e+02_r8,7.1672e+00_r8/)
      kbo(:, 5,28,10) = (/ &
     &2.4052e+03_r8,1.8041e+03_r8,1.2030e+03_r8,6.0186e+02_r8,7.1806e+00_r8/)
      kbo(:, 1,29,10) = (/ &
     &2.0213e+03_r8,1.5162e+03_r8,1.0110e+03_r8,5.0592e+02_r8,7.1826e+00_r8/)
      kbo(:, 2,29,10) = (/ &
     &2.1025e+03_r8,1.5771e+03_r8,1.0516e+03_r8,5.2618e+02_r8,7.2449e+00_r8/)
      kbo(:, 3,29,10) = (/ &
     &2.1817e+03_r8,1.6365e+03_r8,1.0912e+03_r8,5.4596e+02_r8,7.2200e+00_r8/)
      kbo(:, 4,29,10) = (/ &
     &2.2556e+03_r8,1.6919e+03_r8,1.1282e+03_r8,5.6447e+02_r8,7.2591e+00_r8/)
      kbo(:, 5,29,10) = (/ &
     &2.3246e+03_r8,1.7436e+03_r8,1.1626e+03_r8,5.8167e+02_r8,7.2912e+00_r8/)
      kbo(:, 1,30,10) = (/ &
     &1.9891e+03_r8,1.4920e+03_r8,9.9489e+02_r8,4.9783e+02_r8,7.1696e+00_r8/)
      kbo(:, 2,30,10) = (/ &
     &2.0704e+03_r8,1.5530e+03_r8,1.0355e+03_r8,5.1812e+02_r8,7.1996e+00_r8/)
      kbo(:, 3,30,10) = (/ &
     &2.1486e+03_r8,1.6117e+03_r8,1.0747e+03_r8,5.3773e+02_r8,7.2564e+00_r8/)
      kbo(:, 4,30,10) = (/ &
     &2.2243e+03_r8,1.6684e+03_r8,1.1125e+03_r8,5.5660e+02_r8,7.3491e+00_r8/)
      kbo(:, 5,30,10) = (/ &
     &2.2969e+03_r8,1.7228e+03_r8,1.1488e+03_r8,5.7471e+02_r8,7.3950e+00_r8/)
      kbo(:, 1,31,10) = (/ &
     &2.0600e+03_r8,1.5452e+03_r8,1.0303e+03_r8,5.1552e+02_r8,7.0891e+00_r8/)
      kbo(:, 2,31,10) = (/ &
     &2.1442e+03_r8,1.6083e+03_r8,1.0725e+03_r8,5.3661e+02_r8,7.1940e+00_r8/)
      kbo(:, 3,31,10) = (/ &
     &2.2267e+03_r8,1.6702e+03_r8,1.1137e+03_r8,5.5720e+02_r8,7.3519e+00_r8/)
      kbo(:, 4,31,10) = (/ &
     &2.3069e+03_r8,1.7303e+03_r8,1.1538e+03_r8,5.7721e+02_r8,7.4783e+00_r8/)
      kbo(:, 5,31,10) = (/ &
     &2.3951e+03_r8,1.7965e+03_r8,1.1978e+03_r8,5.9922e+02_r8,7.4978e+00_r8/)
      kbo(:, 1,32,10) = (/ &
     &2.1607e+03_r8,1.6207e+03_r8,1.0807e+03_r8,5.4073e+02_r8,7.0921e+00_r8/)
      kbo(:, 2,32,10) = (/ &
     &2.2499e+03_r8,1.6876e+03_r8,1.1253e+03_r8,5.6302e+02_r8,7.2853e+00_r8/)
      kbo(:, 3,32,10) = (/ &
     &2.3389e+03_r8,1.7543e+03_r8,1.1698e+03_r8,5.8523e+02_r8,7.4637e+00_r8/)
      kbo(:, 4,32,10) = (/ &
     &2.4345e+03_r8,1.8261e+03_r8,1.2176e+03_r8,6.0908e+02_r8,7.5300e+00_r8/)
      kbo(:, 5,32,10) = (/ &
     &2.5534e+03_r8,1.9152e+03_r8,1.2769e+03_r8,6.3872e+02_r8,7.5836e+00_r8/)
      kbo(:, 1,33,10) = (/ &
     &2.3147e+03_r8,1.7362e+03_r8,1.1577e+03_r8,5.7922e+02_r8,7.1422e+00_r8/)
      kbo(:, 2,33,10) = (/ &
     &2.4114e+03_r8,1.8087e+03_r8,1.2060e+03_r8,6.0335e+02_r8,7.3798e+00_r8/)
      kbo(:, 3,33,10) = (/ &
     &2.5142e+03_r8,1.8858e+03_r8,1.2574e+03_r8,6.2900e+02_r8,7.4990e+00_r8/)
      kbo(:, 4,33,10) = (/ &
     &2.6436e+03_r8,1.9829e+03_r8,1.3221e+03_r8,6.6129e+02_r8,7.6018e+00_r8/)
      kbo(:, 5,33,10) = (/ &
     &2.8166e+03_r8,2.1125e+03_r8,1.4085e+03_r8,7.0447e+02_r8,7.6468e+00_r8/)
      kbo(:, 1,34,10) = (/ &
     &2.4210e+03_r8,1.8159e+03_r8,1.2108e+03_r8,6.0577e+02_r8,7.2083e+00_r8/)
      kbo(:, 2,34,10) = (/ &
     &2.5284e+03_r8,1.8965e+03_r8,1.2645e+03_r8,6.3255e+02_r8,7.4180e+00_r8/)
      kbo(:, 3,34,10) = (/ &
     &2.6591e+03_r8,1.9944e+03_r8,1.3298e+03_r8,6.6516e+02_r8,7.5418e+00_r8/)
      kbo(:, 4,34,10) = (/ &
     &2.8359e+03_r8,2.1270e+03_r8,1.4182e+03_r8,7.0928e+02_r8,7.6931e+00_r8/)
      kbo(:, 5,34,10) = (/ &
     &3.0680e+03_r8,2.3011e+03_r8,1.5342e+03_r8,7.6730e+02_r8,7.7811e+00_r8/)
      kbo(:, 1,35,10) = (/ &
     &2.5363e+03_r8,1.9024e+03_r8,1.2685e+03_r8,6.3456e+02_r8,7.2309e+00_r8/)
      kbo(:, 2,35,10) = (/ &
     &2.6634e+03_r8,1.9977e+03_r8,1.3320e+03_r8,6.6631e+02_r8,7.4393e+00_r8/)
      kbo(:, 3,35,10) = (/ &
     &2.8345e+03_r8,2.1260e+03_r8,1.4175e+03_r8,7.0897e+02_r8,7.6569e+00_r8/)
      kbo(:, 4,35,10) = (/ &
     &3.0674e+03_r8,2.3007e+03_r8,1.5339e+03_r8,7.6716e+02_r8,7.7801e+00_r8/)
      kbo(:, 5,35,10) = (/ &
     &3.3573e+03_r8,2.5181e+03_r8,1.6788e+03_r8,8.3963e+02_r8,7.8561e+00_r8/)
      kbo(:, 1,36,10) = (/ &
     &2.6451e+03_r8,1.9840e+03_r8,1.3229e+03_r8,6.6175e+02_r8,7.2395e+00_r8/)
      kbo(:, 2,36,10) = (/ &
     &2.7976e+03_r8,2.0983e+03_r8,1.3991e+03_r8,6.9981e+02_r8,7.4813e+00_r8/)
      kbo(:, 3,36,10) = (/ &
     &3.0125e+03_r8,2.2595e+03_r8,1.5065e+03_r8,7.5346e+02_r8,7.7309e+00_r8/)
      kbo(:, 4,36,10) = (/ &
     &3.2979e+03_r8,2.4736e+03_r8,1.6492e+03_r8,8.2479e+02_r8,7.8735e+00_r8/)
      kbo(:, 5,36,10) = (/ &
     &3.6475e+03_r8,2.7357e+03_r8,1.8239e+03_r8,9.1218e+02_r8,7.9027e+00_r8/)
      kbo(:, 1,37,10) = (/ &
     &2.6819e+03_r8,2.0116e+03_r8,1.3413e+03_r8,6.7096e+02_r8,7.2017e+00_r8/)
      kbo(:, 2,37,10) = (/ &
     &2.8583e+03_r8,2.1439e+03_r8,1.4294e+03_r8,7.1495e+02_r8,7.5003e+00_r8/)
      kbo(:, 3,37,10) = (/ &
     &3.1042e+03_r8,2.3283e+03_r8,1.5523e+03_r8,7.7640e+02_r8,7.7646e+00_r8/)
      kbo(:, 4,37,10) = (/ &
     &3.4272e+03_r8,2.5705e+03_r8,1.7138e+03_r8,8.5714e+02_r8,7.9233e+00_r8/)
      kbo(:, 5,37,10) = (/ &
     &3.8225e+03_r8,2.8670e+03_r8,1.9115e+03_r8,9.5596e+02_r8,7.9456e+00_r8/)
      kbo(:, 1,38,10) = (/ &
     &2.7669e+03_r8,2.0753e+03_r8,1.3837e+03_r8,6.9217e+02_r8,7.1724e+00_r8/)
      kbo(:, 2,38,10) = (/ &
     &2.9772e+03_r8,2.2330e+03_r8,1.4888e+03_r8,7.4467e+02_r8,7.5382e+00_r8/)
      kbo(:, 3,38,10) = (/ &
     &3.2630e+03_r8,2.4473e+03_r8,1.6317e+03_r8,8.1609e+02_r8,7.7857e+00_r8/)
      kbo(:, 4,38,10) = (/ &
     &3.6292e+03_r8,2.7220e+03_r8,1.8149e+03_r8,9.0769e+02_r8,7.9649e+00_r8/)
      kbo(:, 5,38,10) = (/ &
     &4.0743e+03_r8,3.0559e+03_r8,2.0374e+03_r8,1.0190e+03_r8,7.9771e+00_r8/)
      kbo(:, 1,39,10) = (/ &
     &2.9268e+03_r8,2.1953e+03_r8,1.4637e+03_r8,7.3213e+02_r8,7.1691e+00_r8/)
      kbo(:, 2,39,10) = (/ &
     &3.1832e+03_r8,2.3875e+03_r8,1.5919e+03_r8,7.9619e+02_r8,7.5536e+00_r8/)
      kbo(:, 3,39,10) = (/ &
     &3.5251e+03_r8,2.6440e+03_r8,1.7628e+03_r8,8.8168e+02_r8,7.8089e+00_r8/)
      kbo(:, 4,39,10) = (/ &
     &3.9504e+03_r8,2.9629e+03_r8,1.9755e+03_r8,9.8804e+02_r8,7.9786e+00_r8/)
      kbo(:, 5,39,10) = (/ &
     &4.4598e+03_r8,3.3450e+03_r8,2.2302e+03_r8,1.1154e+03_r8,8.0073e+00_r8/)
      kbo(:, 1,40,10) = (/ &
     &2.8874e+03_r8,2.1657e+03_r8,1.4439e+03_r8,7.2221e+02_r8,7.0746e+00_r8/)
      kbo(:, 2,40,10) = (/ &
     &3.1724e+03_r8,2.3794e+03_r8,1.5864e+03_r8,7.9346e+02_r8,7.4831e+00_r8/)
      kbo(:, 3,40,10) = (/ &
     &3.5465e+03_r8,2.6600e+03_r8,1.7735e+03_r8,8.8703e+02_r8,7.7692e+00_r8/)
      kbo(:, 4,40,10) = (/ &
     &4.0044e+03_r8,3.0035e+03_r8,2.0025e+03_r8,1.0016e+03_r8,7.9632e+00_r8/)
      kbo(:, 5,40,10) = (/ &
     &4.5454e+03_r8,3.4092e+03_r8,2.2730e+03_r8,1.1368e+03_r8,8.0081e+00_r8/)
      kbo(:, 1,41,10) = (/ &
     &2.8406e+03_r8,2.1306e+03_r8,1.4205e+03_r8,7.1050e+02_r8,6.9600e+00_r8/)
      kbo(:, 2,41,10) = (/ &
     &3.1484e+03_r8,2.3614e+03_r8,1.5744e+03_r8,7.8747e+02_r8,7.3954e+00_r8/)
      kbo(:, 3,41,10) = (/ &
     &3.5576e+03_r8,2.6684e+03_r8,1.7791e+03_r8,8.8987e+02_r8,7.7179e+00_r8/)
      kbo(:, 4,41,10) = (/ &
     &4.0527e+03_r8,3.0397e+03_r8,2.0267e+03_r8,1.0137e+03_r8,7.9444e+00_r8/)
      kbo(:, 5,41,10) = (/ &
     &4.6270e+03_r8,3.4704e+03_r8,2.3138e+03_r8,1.1572e+03_r8,8.0108e+00_r8/)
      kbo(:, 1,42,10) = (/ &
     &2.8258e+03_r8,2.1194e+03_r8,1.4131e+03_r8,7.0678e+02_r8,6.8517e+00_r8/)
      kbo(:, 2,42,10) = (/ &
     &3.1581e+03_r8,2.3687e+03_r8,1.5793e+03_r8,7.8990e+02_r8,7.3049e+00_r8/)
      kbo(:, 3,42,10) = (/ &
     &3.6059e+03_r8,2.7046e+03_r8,1.8032e+03_r8,9.0193e+02_r8,7.6524e+00_r8/)
      kbo(:, 4,42,10) = (/ &
     &4.1499e+03_r8,3.1126e+03_r8,2.0753e+03_r8,1.0380e+03_r8,7.9111e+00_r8/)
      kbo(:, 5,42,10) = (/ &
     &4.7763e+03_r8,3.5824e+03_r8,2.3885e+03_r8,1.1945e+03_r8,8.0026e+00_r8/)
      kbo(:, 1,43,10) = (/ &
     &2.8194e+03_r8,2.1147e+03_r8,1.4100e+03_r8,7.0522e+02_r8,6.7032e+00_r8/)
      kbo(:, 2,43,10) = (/ &
     &3.1747e+03_r8,2.3812e+03_r8,1.5876e+03_r8,7.9408e+02_r8,7.1735e+00_r8/)
      kbo(:, 3,43,10) = (/ &
     &3.6549e+03_r8,2.7413e+03_r8,1.8278e+03_r8,9.1420e+02_r8,7.5844e+00_r8/)
      kbo(:, 4,43,10) = (/ &
     &4.2522e+03_r8,3.1893e+03_r8,2.1264e+03_r8,1.0635e+03_r8,7.8420e+00_r8/)
      kbo(:, 5,43,10) = (/ &
     &4.9421e+03_r8,3.7067e+03_r8,2.4714e+03_r8,1.2360e+03_r8,7.9777e+00_r8/)
      kbo(:, 1,44,10) = (/ &
     &2.8469e+03_r8,2.1353e+03_r8,1.4237e+03_r8,7.1206e+02_r8,6.5380e+00_r8/)
      kbo(:, 2,44,10) = (/ &
     &3.2203e+03_r8,2.4153e+03_r8,1.6104e+03_r8,8.0548e+02_r8,7.0393e+00_r8/)
      kbo(:, 3,44,10) = (/ &
     &3.7360e+03_r8,2.8021e+03_r8,1.8683e+03_r8,9.3448e+02_r8,7.4778e+00_r8/)
      kbo(:, 4,44,10) = (/ &
     &4.3910e+03_r8,3.2934e+03_r8,2.1958e+03_r8,1.0982e+03_r8,7.7716e+00_r8/)
      kbo(:, 5,44,10) = (/ &
     &5.1620e+03_r8,3.8716e+03_r8,2.5813e+03_r8,1.2909e+03_r8,7.9568e+00_r8/)
      kbo(:, 1,45,10) = (/ &
     &2.9370e+03_r8,2.2029e+03_r8,1.4687e+03_r8,7.3461e+02_r8,6.3596e+00_r8/)
      kbo(:, 2,45,10) = (/ &
     &3.3323e+03_r8,2.4994e+03_r8,1.6664e+03_r8,8.3351e+02_r8,6.8956e+00_r8/)
      kbo(:, 3,45,10) = (/ &
     &3.8921e+03_r8,2.9193e+03_r8,1.9464e+03_r8,9.7354e+02_r8,7.3748e+00_r8/)
      kbo(:, 4,45,10) = (/ &
     &4.6196e+03_r8,3.4648e+03_r8,2.3101e+03_r8,1.1554e+03_r8,7.7094e+00_r8/)
      kbo(:, 5,45,10) = (/ &
     &5.4975e+03_r8,4.1233e+03_r8,2.7490e+03_r8,1.3748e+03_r8,7.9394e+00_r8/)
      kbo(:, 1,46,10) = (/ &
     &3.0543e+03_r8,2.2908e+03_r8,1.5274e+03_r8,7.6393e+02_r8,6.1665e+00_r8/)
      kbo(:, 2,46,10) = (/ &
     &3.4757e+03_r8,2.6069e+03_r8,1.7382e+03_r8,8.6940e+02_r8,6.7524e+00_r8/)
      kbo(:, 3,46,10) = (/ &
     &4.0758e+03_r8,3.0570e+03_r8,2.0382e+03_r8,1.0195e+03_r8,7.2688e+00_r8/)
      kbo(:, 4,46,10) = (/ &
     &4.8832e+03_r8,3.6626e+03_r8,2.4419e+03_r8,1.2213e+03_r8,7.6299e+00_r8/)
      kbo(:, 5,46,10) = (/ &
     &5.8799e+03_r8,4.4101e+03_r8,2.9402e+03_r8,1.4704e+03_r8,7.9039e+00_r8/)
      kbo(:, 1,47,10) = (/ &
     &3.1321e+03_r8,2.3492e+03_r8,1.5663e+03_r8,7.8341e+02_r8,5.9258e+00_r8/)
      kbo(:, 2,47,10) = (/ &
     &3.5703e+03_r8,2.6779e+03_r8,1.7855e+03_r8,8.9306e+02_r8,6.5564e+00_r8/)
      kbo(:, 3,47,10) = (/ &
     &4.1981e+03_r8,3.1488e+03_r8,2.0994e+03_r8,1.0501e+03_r8,7.1267e+00_r8/)
      kbo(:, 4,47,10) = (/ &
     &5.0652e+03_r8,3.7991e+03_r8,2.5329e+03_r8,1.2668e+03_r8,7.5455e+00_r8/)
      kbo(:, 5,47,10) = (/ &
     &6.1689e+03_r8,4.6268e+03_r8,3.0847e+03_r8,1.5426e+03_r8,7.8470e+00_r8/)
      kbo(:, 1,48,10) = (/ &
     &3.3047e+03_r8,2.4787e+03_r8,1.6526e+03_r8,8.2657e+02_r8,5.6694e+00_r8/)
      kbo(:, 2,48,10) = (/ &
     &3.7747e+03_r8,2.8312e+03_r8,1.8877e+03_r8,9.4418e+02_r8,6.3589e+00_r8/)
      kbo(:, 3,48,10) = (/ &
     &4.4483e+03_r8,3.3364e+03_r8,2.2245e+03_r8,1.1126e+03_r8,6.9569e+00_r8/)
      kbo(:, 4,48,10) = (/ &
     &5.3940e+03_r8,4.0457e+03_r8,2.6973e+03_r8,1.3490e+03_r8,7.4395e+00_r8/)
      kbo(:, 5,48,10) = (/ &
     &6.6398e+03_r8,4.9800e+03_r8,3.3201e+03_r8,1.6603e+03_r8,7.7751e+00_r8/)
      kbo(:, 1,49,10) = (/ &
     &3.6256e+03_r8,2.7194e+03_r8,1.8131e+03_r8,9.0682e+02_r8,5.4147e+00_r8/)
      kbo(:, 2,49,10) = (/ &
     &4.1643e+03_r8,3.1234e+03_r8,2.0825e+03_r8,1.0416e+03_r8,6.1453e+00_r8/)
      kbo(:, 3,49,10) = (/ &
     &4.9094e+03_r8,3.6822e+03_r8,2.4550e+03_r8,1.2279e+03_r8,6.7872e+00_r8/)
      kbo(:, 4,49,10) = (/ &
     &5.9847e+03_r8,4.4886e+03_r8,2.9926e+03_r8,1.4966e+03_r8,7.3168e+00_r8/)
      kbo(:, 5,49,10) = (/ &
     &7.4258e+03_r8,5.5695e+03_r8,3.7131e+03_r8,1.8568e+03_r8,7.6869e+00_r8/)
      kbo(:, 1,50,10) = (/ &
     &3.7913e+03_r8,2.8436e+03_r8,1.8959e+03_r8,9.4825e+02_r8,5.1338e+00_r8/)
      kbo(:, 2,50,10) = (/ &
     &4.3920e+03_r8,3.2942e+03_r8,2.1963e+03_r8,1.0985e+03_r8,5.9203e+00_r8/)
      kbo(:, 3,50,10) = (/ &
     &5.1851e+03_r8,3.8890e+03_r8,2.5929e+03_r8,1.2968e+03_r8,6.5802e+00_r8/)
      kbo(:, 4,50,10) = (/ &
     &6.3489e+03_r8,4.7618e+03_r8,3.1748e+03_r8,1.5877e+03_r8,7.1705e+00_r8/)
      kbo(:, 5,50,10) = (/ &
     &7.9377e+03_r8,5.9534e+03_r8,3.9691e+03_r8,1.9848e+03_r8,7.5922e+00_r8/)
      kbo(:, 1,51,10) = (/ &
     &3.8669e+03_r8,2.9003e+03_r8,1.9338e+03_r8,9.6719e+02_r8,4.8302e+00_r8/)
      kbo(:, 2,51,10) = (/ &
     &4.5318e+03_r8,3.3991e+03_r8,2.2663e+03_r8,1.1335e+03_r8,5.6653e+00_r8/)
      kbo(:, 3,51,10) = (/ &
     &5.3773e+03_r8,4.0331e+03_r8,2.6890e+03_r8,1.3448e+03_r8,6.3736e+00_r8/)
      kbo(:, 4,51,10) = (/ &
     &6.6015e+03_r8,4.9513e+03_r8,3.3010e+03_r8,1.6508e+03_r8,7.0028e+00_r8/)
      kbo(:, 5,51,10) = (/ &
     &8.3208e+03_r8,6.2407e+03_r8,4.1606e+03_r8,2.0805e+03_r8,7.4729e+00_r8/)
      kbo(:, 1,52,10) = (/ &
     &4.0341e+03_r8,3.0258e+03_r8,2.0174e+03_r8,1.0090e+03_r8,4.5505e+00_r8/)
      kbo(:, 2,52,10) = (/ &
     &4.7982e+03_r8,3.5989e+03_r8,2.3995e+03_r8,1.2001e+03_r8,5.4004e+00_r8/)
      kbo(:, 3,52,10) = (/ &
     &5.7356e+03_r8,4.3019e+03_r8,2.8682e+03_r8,1.4344e+03_r8,6.1556e+00_r8/)
      kbo(:, 4,52,10) = (/ &
     &7.0672e+03_r8,5.3005e+03_r8,3.5339e+03_r8,1.7672e+03_r8,6.8208e+00_r8/)
      kbo(:, 5,52,10) = (/ &
     &8.9657e+03_r8,6.7244e+03_r8,4.4831e+03_r8,2.2418e+03_r8,7.3432e+00_r8/)
      kbo(:, 1,53,10) = (/ &
     &4.3581e+03_r8,3.2687e+03_r8,2.1794e+03_r8,1.0900e+03_r8,4.2696e+00_r8/)
      kbo(:, 2,53,10) = (/ &
     &5.2688e+03_r8,3.9518e+03_r8,2.6348e+03_r8,1.3178e+03_r8,5.1422e+00_r8/)
      kbo(:, 3,53,10) = (/ &
     &6.3653e+03_r8,4.7742e+03_r8,3.1830e+03_r8,1.5919e+03_r8,5.9288e+00_r8/)
      kbo(:, 4,53,10) = (/ &
     &7.8870e+03_r8,5.9154e+03_r8,3.9438e+03_r8,1.9722e+03_r8,6.6345e+00_r8/)
      kbo(:, 5,53,10) = (/ &
     &1.0051e+04_r8,7.5383e+03_r8,5.0257e+03_r8,2.5131e+03_r8,7.2054e+00_r8/)
      kbo(:, 1,54,10) = (/ &
     &4.0664e+03_r8,3.0500e+03_r8,2.0336e+03_r8,1.0171e+03_r8,3.9912e+00_r8/)
      kbo(:, 2,54,10) = (/ &
     &5.0070e+03_r8,3.7555e+03_r8,2.5039e+03_r8,1.2523e+03_r8,4.8673e+00_r8/)
      kbo(:, 3,54,10) = (/ &
     &6.1329e+03_r8,4.5998e+03_r8,3.0668e+03_r8,1.5337e+03_r8,5.6727e+00_r8/)
      kbo(:, 4,54,10) = (/ &
     &7.6570e+03_r8,5.7429e+03_r8,3.8288e+03_r8,1.9147e+03_r8,6.4112e+00_r8/)
      kbo(:, 5,54,10) = (/ &
     &9.8073e+03_r8,7.3556e+03_r8,4.9039e+03_r8,2.4522e+03_r8,7.0431e+00_r8/)
      kbo(:, 1,55,10) = (/ &
     &3.4487e+03_r8,2.5868e+03_r8,1.7247e+03_r8,8.6275e+02_r8,3.7023e+00_r8/)
      kbo(:, 2,55,10) = (/ &
     &4.3277e+03_r8,3.2460e+03_r8,2.1642e+03_r8,1.0825e+03_r8,4.5324e+00_r8/)
      kbo(:, 3,55,10) = (/ &
     &5.3892e+03_r8,4.0421e+03_r8,2.6950e+03_r8,1.3479e+03_r8,5.4035e+00_r8/)
      kbo(:, 4,55,10) = (/ &
     &6.7963e+03_r8,5.0973e+03_r8,3.3984e+03_r8,1.6995e+03_r8,6.1546e+00_r8/)
      kbo(:, 5,55,10) = (/ &
     &8.7627e+03_r8,6.5722e+03_r8,4.3816e+03_r8,2.1910e+03_r8,6.8267e+00_r8/)
      kbo(:, 1,56,10) = (/ &
     &2.9072e+03_r8,2.1806e+03_r8,1.4540e+03_r8,7.2734e+02_r8,3.4115e+00_r8/)
      kbo(:, 2,56,10) = (/ &
     &3.7198e+03_r8,2.7901e+03_r8,1.8603e+03_r8,9.3056e+02_r8,4.2571e+00_r8/)
      kbo(:, 3,56,10) = (/ &
     &4.7203e+03_r8,3.5403e+03_r8,2.3605e+03_r8,1.1806e+03_r8,5.1151e+00_r8/)
      kbo(:, 4,56,10) = (/ &
     &6.0279e+03_r8,4.5211e+03_r8,3.0142e+03_r8,1.5074e+03_r8,5.8984e+00_r8/)
      kbo(:, 5,56,10) = (/ &
     &7.8366e+03_r8,5.8775e+03_r8,3.9185e+03_r8,1.9594e+03_r8,6.6003e+00_r8/)
      kbo(:, 1,57,10) = (/ &
     &2.4367e+03_r8,1.8277e+03_r8,1.2187e+03_r8,6.0970e+02_r8,3.1098e+00_r8/)
      kbo(:, 2,57,10) = (/ &
     &3.1766e+03_r8,2.3826e+03_r8,1.5887e+03_r8,7.9475e+02_r8,3.9704e+00_r8/)
      kbo(:, 3,57,10) = (/ &
     &4.1136e+03_r8,3.0854e+03_r8,2.0572e+03_r8,1.0290e+03_r8,4.8038e+00_r8/)
      kbo(:, 4,57,10) = (/ &
     &5.3345e+03_r8,4.0010e+03_r8,2.6675e+03_r8,1.3340e+03_r8,5.6428e+00_r8/)
      kbo(:, 5,57,10) = (/ &
     &7.0017e+03_r8,5.2513e+03_r8,3.5010e+03_r8,1.7507e+03_r8,6.3564e+00_r8/)
      kbo(:, 1,58,10) = (/ &
     &5.3797e+02_r8,4.9330e+02_r8,4.2306e+02_r8,2.9653e+02_r8,2.8402e+00_r8/)
      kbo(:, 2,58,10) = (/ &
     &7.1438e+02_r8,6.5505e+02_r8,5.6177e+02_r8,3.9372e+02_r8,3.6954e+00_r8/)
      kbo(:, 3,58,10) = (/ &
     &9.4508e+02_r8,8.6656e+02_r8,7.4311e+02_r8,5.2072e+02_r8,4.5299e+00_r8/)
      kbo(:, 4,58,10) = (/ &
     &1.2473e+03_r8,1.1436e+03_r8,9.8061e+02_r8,6.8699e+02_r8,5.3595e+00_r8/)
      kbo(:, 5,58,10) = (/ &
     &1.6559e+03_r8,1.5182e+03_r8,1.3018e+03_r8,9.1191e+02_r8,6.1054e+00_r8/)
      kbo(:, 1,59,10) = (/ &
     &5.5953e+02_r8,4.8866e+02_r8,3.8993e+02_r8,2.4311e+02_r8,2.7081e+00_r8/)
      kbo(:, 2,59,10) = (/ &
     &7.5600e+02_r8,6.6022e+02_r8,5.2680e+02_r8,3.2817e+02_r8,3.5280e+00_r8/)
      kbo(:, 3,59,10) = (/ &
     &1.0213e+03_r8,8.9185e+02_r8,7.1155e+02_r8,4.4309e+02_r8,4.3511e+00_r8/)
      kbo(:, 4,59,10) = (/ &
     &1.3747e+03_r8,1.2004e+03_r8,9.5765e+02_r8,5.9615e+02_r8,5.1215e+00_r8/)
      kbo(:, 5,59,10) = (/ &
     &1.8474e+03_r8,1.6131e+03_r8,1.2868e+03_r8,8.0091e+02_r8,5.9179e+00_r8/)
      kbo(:, 1,13,11) = (/ &
     &1.9556e+05_r8,1.4667e+05_r8,9.7780e+04_r8,4.8890e+04_r8,3.8293e+00_r8/)
      kbo(:, 2,13,11) = (/ &
     &1.9579e+05_r8,1.4684e+05_r8,9.7894e+04_r8,4.8947e+04_r8,3.6477e+00_r8/)
      kbo(:, 3,13,11) = (/ &
     &1.9489e+05_r8,1.4617e+05_r8,9.7447e+04_r8,4.8724e+04_r8,3.6240e+00_r8/)
      kbo(:, 4,13,11) = (/ &
     &1.9354e+05_r8,1.4515e+05_r8,9.6770e+04_r8,4.8385e+04_r8,3.4253e+00_r8/)
      kbo(:, 5,13,11) = (/ &
     &1.9176e+05_r8,1.4382e+05_r8,9.5882e+04_r8,4.7942e+04_r8,3.3965e+00_r8/)
      kbo(:, 1,14,11) = (/ &
     &1.2532e+05_r8,9.3990e+04_r8,6.2660e+04_r8,3.1330e+04_r8,4.2132e+00_r8/)
      kbo(:, 2,14,11) = (/ &
     &1.2490e+05_r8,9.3675e+04_r8,6.2450e+04_r8,3.1225e+04_r8,4.0914e+00_r8/)
      kbo(:, 3,14,11) = (/ &
     &1.2400e+05_r8,9.3003e+04_r8,6.2001e+04_r8,3.1001e+04_r8,4.0126e+00_r8/)
      kbo(:, 4,14,11) = (/ &
     &1.2262e+05_r8,9.1963e+04_r8,6.1309e+04_r8,3.0654e+04_r8,3.8288e+00_r8/)
      kbo(:, 5,14,11) = (/ &
     &1.2099e+05_r8,9.0745e+04_r8,6.0496e+04_r8,3.0248e+04_r8,3.6494e+00_r8/)
      kbo(:, 1,15,11) = (/ &
     &8.0146e+04_r8,6.0110e+04_r8,4.0074e+04_r8,2.0037e+04_r8,4.6025e+00_r8/)
      kbo(:, 2,15,11) = (/ &
     &7.9365e+04_r8,5.9524e+04_r8,3.9683e+04_r8,1.9842e+04_r8,4.5011e+00_r8/)
      kbo(:, 3,15,11) = (/ &
     &7.8437e+04_r8,5.8828e+04_r8,3.9219e+04_r8,1.9610e+04_r8,4.3995e+00_r8/)
      kbo(:, 4,15,11) = (/ &
     &7.7471e+04_r8,5.8104e+04_r8,3.8736e+04_r8,1.9369e+04_r8,4.3087e+00_r8/)
      kbo(:, 5,15,11) = (/ &
     &7.6167e+04_r8,5.7126e+04_r8,3.8084e+04_r8,1.9043e+04_r8,4.1657e+00_r8/)
      kbo(:, 1,16,11) = (/ &
     &5.9412e+04_r8,4.4559e+04_r8,2.9706e+04_r8,1.4854e+04_r8,4.9879e+00_r8/)
      kbo(:, 2,16,11) = (/ &
     &5.8737e+04_r8,4.4053e+04_r8,2.9369e+04_r8,1.4685e+04_r8,4.8952e+00_r8/)
      kbo(:, 3,16,11) = (/ &
     &5.7913e+04_r8,4.3435e+04_r8,2.8957e+04_r8,1.4479e+04_r8,4.7931e+00_r8/)
      kbo(:, 4,16,11) = (/ &
     &5.6912e+04_r8,4.2684e+04_r8,2.8456e+04_r8,1.4229e+04_r8,4.7058e+00_r8/)
      kbo(:, 5,16,11) = (/ &
     &5.5858e+04_r8,4.1894e+04_r8,2.7929e+04_r8,1.3965e+04_r8,4.5654e+00_r8/)
      kbo(:, 1,17,11) = (/ &
     &4.4739e+04_r8,3.3554e+04_r8,2.2370e+04_r8,1.1185e+04_r8,5.4258e+00_r8/)
      kbo(:, 2,17,11) = (/ &
     &4.4040e+04_r8,3.3030e+04_r8,2.2020e+04_r8,1.1011e+04_r8,5.3316e+00_r8/)
      kbo(:, 3,17,11) = (/ &
     &4.3278e+04_r8,3.2459e+04_r8,2.1639e+04_r8,1.0820e+04_r8,5.2258e+00_r8/)
      kbo(:, 4,17,11) = (/ &
     &4.2484e+04_r8,3.1863e+04_r8,2.1242e+04_r8,1.0622e+04_r8,5.1306e+00_r8/)
      kbo(:, 5,17,11) = (/ &
     &4.1610e+04_r8,3.1208e+04_r8,2.0805e+04_r8,1.0403e+04_r8,4.9611e+00_r8/)
      kbo(:, 1,18,11) = (/ &
     &3.3808e+04_r8,2.5356e+04_r8,1.6904e+04_r8,8.4526e+03_r8,5.9588e+00_r8/)
      kbo(:, 2,18,11) = (/ &
     &3.3205e+04_r8,2.4904e+04_r8,1.6603e+04_r8,8.3019e+03_r8,5.8553e+00_r8/)
      kbo(:, 3,18,11) = (/ &
     &3.2587e+04_r8,2.4440e+04_r8,1.6294e+04_r8,8.1473e+03_r8,5.7407e+00_r8/)
      kbo(:, 4,18,11) = (/ &
     &3.1890e+04_r8,2.3917e+04_r8,1.5945e+04_r8,7.9729e+03_r8,5.6396e+00_r8/)
      kbo(:, 5,18,11) = (/ &
     &3.1157e+04_r8,2.3368e+04_r8,1.5579e+04_r8,7.7897e+03_r8,5.4685e+00_r8/)
      kbo(:, 1,19,11) = (/ &
     &2.4641e+04_r8,1.8481e+04_r8,1.2321e+04_r8,6.1608e+03_r8,6.5634e+00_r8/)
      kbo(:, 2,19,11) = (/ &
     &2.4168e+04_r8,1.8126e+04_r8,1.2084e+04_r8,6.0424e+03_r8,6.4593e+00_r8/)
      kbo(:, 3,19,11) = (/ &
     &2.3646e+04_r8,1.7735e+04_r8,1.1823e+04_r8,5.9120e+03_r8,6.3292e+00_r8/)
      kbo(:, 4,19,11) = (/ &
     &2.3077e+04_r8,1.7308e+04_r8,1.1539e+04_r8,5.7697e+03_r8,6.2034e+00_r8/)
      kbo(:, 5,19,11) = (/ &
     &2.2489e+04_r8,1.6867e+04_r8,1.1245e+04_r8,5.6226e+03_r8,6.0369e+00_r8/)
      kbo(:, 1,20,11) = (/ &
     &1.9106e+04_r8,1.4330e+04_r8,9.5533e+03_r8,4.7770e+03_r8,7.1646e+00_r8/)
      kbo(:, 2,20,11) = (/ &
     &1.8682e+04_r8,1.4011e+04_r8,9.3411e+03_r8,4.6709e+03_r8,7.0409e+00_r8/)
      kbo(:, 3,20,11) = (/ &
     &1.8224e+04_r8,1.3668e+04_r8,9.1125e+03_r8,4.5566e+03_r8,6.8869e+00_r8/)
      kbo(:, 4,20,11) = (/ &
     &1.7734e+04_r8,1.3300e+04_r8,8.8671e+03_r8,4.4339e+03_r8,6.7557e+00_r8/)
      kbo(:, 5,20,11) = (/ &
     &1.7241e+04_r8,1.2931e+04_r8,8.6211e+03_r8,4.3109e+03_r8,6.6027e+00_r8/)
      kbo(:, 1,21,11) = (/ &
     &1.5039e+04_r8,1.1280e+04_r8,7.5200e+03_r8,3.7604e+03_r8,7.7170e+00_r8/)
      kbo(:, 2,21,11) = (/ &
     &1.4660e+04_r8,1.0995e+04_r8,7.3306e+03_r8,3.6657e+03_r8,7.5835e+00_r8/)
      kbo(:, 3,21,11) = (/ &
     &1.4253e+04_r8,1.0690e+04_r8,7.1270e+03_r8,3.5639e+03_r8,7.4413e+00_r8/)
      kbo(:, 4,21,11) = (/ &
     &1.3848e+04_r8,1.0387e+04_r8,6.9246e+03_r8,3.4627e+03_r8,7.3214e+00_r8/)
      kbo(:, 5,21,11) = (/ &
     &1.3474e+04_r8,1.0106e+04_r8,6.7374e+03_r8,3.3691e+03_r8,7.1721e+00_r8/)
      kbo(:, 1,22,11) = (/ &
     &1.1928e+04_r8,8.9459e+03_r8,5.9642e+03_r8,2.9825e+03_r8,8.2536e+00_r8/)
      kbo(:, 2,22,11) = (/ &
     &1.1588e+04_r8,8.6914e+03_r8,5.7946e+03_r8,2.8977e+03_r8,8.1353e+00_r8/)
      kbo(:, 3,22,11) = (/ &
     &1.1261e+04_r8,8.4462e+03_r8,5.6311e+03_r8,2.8159e+03_r8,8.0046e+00_r8/)
      kbo(:, 4,22,11) = (/ &
     &1.0981e+04_r8,8.2362e+03_r8,5.4911e+03_r8,2.7459e+03_r8,7.8868e+00_r8/)
      kbo(:, 5,22,11) = (/ &
     &1.0767e+04_r8,8.0756e+03_r8,5.3840e+03_r8,2.6924e+03_r8,7.7103e+00_r8/)
      kbo(:, 1,23,11) = (/ &
     &9.3738e+03_r8,7.0305e+03_r8,4.6873e+03_r8,2.3441e+03_r8,8.7957e+00_r8/)
      kbo(:, 2,23,11) = (/ &
     &9.1120e+03_r8,6.8342e+03_r8,4.5564e+03_r8,2.2786e+03_r8,8.6750e+00_r8/)
      kbo(:, 3,23,11) = (/ &
     &8.9119e+03_r8,6.6842e+03_r8,4.4564e+03_r8,2.2286e+03_r8,8.5667e+00_r8/)
      kbo(:, 4,23,11) = (/ &
     &8.7698e+03_r8,6.5776e+03_r8,4.3853e+03_r8,2.1931e+03_r8,8.4437e+00_r8/)
      kbo(:, 5,23,11) = (/ &
     &8.7064e+03_r8,6.5300e+03_r8,4.3536e+03_r8,2.1772e+03_r8,8.2499e+00_r8/)
      kbo(:, 1,24,11) = (/ &
     &7.2818e+03_r8,5.4615e+03_r8,3.6413e+03_r8,1.8211e+03_r8,9.3047e+00_r8/)
      kbo(:, 2,24,11) = (/ &
     &7.1398e+03_r8,5.3551e+03_r8,3.5703e+03_r8,1.7856e+03_r8,9.1844e+00_r8/)
      kbo(:, 3,24,11) = (/ &
     &7.0551e+03_r8,5.2916e+03_r8,3.5280e+03_r8,1.7644e+03_r8,9.0906e+00_r8/)
      kbo(:, 4,24,11) = (/ &
     &7.0561e+03_r8,5.2923e+03_r8,3.5284e+03_r8,1.7646e+03_r8,8.9639e+00_r8/)
      kbo(:, 5,24,11) = (/ &
     &7.1200e+03_r8,5.3402e+03_r8,3.5604e+03_r8,1.7806e+03_r8,8.7597e+00_r8/)
      kbo(:, 1,25,11) = (/ &
     &5.7829e+03_r8,4.3374e+03_r8,2.8918e+03_r8,1.4463e+03_r8,9.7531e+00_r8/)
      kbo(:, 2,25,11) = (/ &
     &5.7416e+03_r8,4.3064e+03_r8,2.8712e+03_r8,1.4360e+03_r8,9.6333e+00_r8/)
      kbo(:, 3,25,11) = (/ &
     &5.7703e+03_r8,4.3279e+03_r8,2.8855e+03_r8,1.4432e+03_r8,9.5575e+00_r8/)
      kbo(:, 4,25,11) = (/ &
     &5.8528e+03_r8,4.3898e+03_r8,2.9268e+03_r8,1.4638e+03_r8,9.4320e+00_r8/)
      kbo(:, 5,25,11) = (/ &
     &5.9946e+03_r8,4.4961e+03_r8,2.9977e+03_r8,1.4993e+03_r8,9.2048e+00_r8/)
      kbo(:, 1,26,11) = (/ &
     &4.7547e+03_r8,3.5662e+03_r8,2.3777e+03_r8,1.1892e+03_r8,1.0127e+01_r8/)
      kbo(:, 2,26,11) = (/ &
     &4.7969e+03_r8,3.5979e+03_r8,2.3989e+03_r8,1.1999e+03_r8,1.0014e+01_r8/)
      kbo(:, 3,26,11) = (/ &
     &4.8916e+03_r8,3.6689e+03_r8,2.4462e+03_r8,1.2235e+03_r8,9.9567e+00_r8/)
      kbo(:, 4,26,11) = (/ &
     &5.0339e+03_r8,3.7756e+03_r8,2.5174e+03_r8,1.2591e+03_r8,9.8430e+00_r8/)
      kbo(:, 5,26,11) = (/ &
     &5.1881e+03_r8,3.8913e+03_r8,2.5944e+03_r8,1.2976e+03_r8,9.5879e+00_r8/)
      kbo(:, 1,27,11) = (/ &
     &4.1434e+03_r8,3.1078e+03_r8,2.0721e+03_r8,1.0365e+03_r8,1.0438e+01_r8/)
      kbo(:, 2,27,11) = (/ &
     &4.2449e+03_r8,3.1839e+03_r8,2.1229e+03_r8,1.0619e+03_r8,1.0375e+01_r8/)
      kbo(:, 3,27,11) = (/ &
     &4.3814e+03_r8,3.2863e+03_r8,2.1911e+03_r8,1.0960e+03_r8,1.0314e+01_r8/)
      kbo(:, 4,27,11) = (/ &
     &4.5344e+03_r8,3.4010e+03_r8,2.2676e+03_r8,1.1342e+03_r8,1.0178e+01_r8/)
      kbo(:, 5,27,11) = (/ &
     &4.7035e+03_r8,3.5278e+03_r8,2.3521e+03_r8,1.1764e+03_r8,9.9184e+00_r8/)
      kbo(:, 1,28,11) = (/ &
     &3.7712e+03_r8,2.8287e+03_r8,1.8861e+03_r8,9.4351e+02_r8,1.0688e+01_r8/)
      kbo(:, 2,28,11) = (/ &
     &3.9032e+03_r8,2.9276e+03_r8,1.9520e+03_r8,9.7644e+02_r8,1.0679e+01_r8/)
      kbo(:, 3,28,11) = (/ &
     &4.0571e+03_r8,3.0430e+03_r8,2.0289e+03_r8,1.0148e+03_r8,1.0623e+01_r8/)
      kbo(:, 4,28,11) = (/ &
     &4.2272e+03_r8,3.1706e+03_r8,2.1139e+03_r8,1.0573e+03_r8,1.0454e+01_r8/)
      kbo(:, 5,28,11) = (/ &
     &4.4031e+03_r8,3.3025e+03_r8,2.2018e+03_r8,1.1012e+03_r8,1.0168e+01_r8/)
      kbo(:, 1,29,11) = (/ &
     &3.6879e+03_r8,2.7661e+03_r8,1.8444e+03_r8,9.2260e+02_r8,1.0914e+01_r8/)
      kbo(:, 2,29,11) = (/ &
     &3.8440e+03_r8,2.8832e+03_r8,1.9224e+03_r8,9.6157e+02_r8,1.0945e+01_r8/)
      kbo(:, 3,29,11) = (/ &
     &4.0134e+03_r8,3.0102e+03_r8,2.0070e+03_r8,1.0038e+03_r8,1.0853e+01_r8/)
      kbo(:, 4,29,11) = (/ &
     &4.1909e+03_r8,3.1433e+03_r8,2.0957e+03_r8,1.0481e+03_r8,1.0578e+01_r8/)
      kbo(:, 5,29,11) = (/ &
     &4.3726e+03_r8,3.2796e+03_r8,2.1866e+03_r8,1.0936e+03_r8,1.0403e+01_r8/)
      kbo(:, 1,30,11) = (/ &
     &3.7192e+03_r8,2.7896e+03_r8,1.8600e+03_r8,9.3035e+02_r8,1.1141e+01_r8/)
      kbo(:, 2,30,11) = (/ &
     &3.8944e+03_r8,2.9210e+03_r8,1.9475e+03_r8,9.7411e+02_r8,1.1139e+01_r8/)
      kbo(:, 3,30,11) = (/ &
     &4.0753e+03_r8,3.0566e+03_r8,2.0379e+03_r8,1.0192e+03_r8,1.0970e+01_r8/)
      kbo(:, 4,30,11) = (/ &
     &4.2621e+03_r8,3.1967e+03_r8,2.1313e+03_r8,1.0660e+03_r8,1.0736e+01_r8/)
      kbo(:, 5,30,11) = (/ &
     &4.4544e+03_r8,3.3410e+03_r8,2.2275e+03_r8,1.1141e+03_r8,1.0663e+01_r8/)
      kbo(:, 1,31,11) = (/ &
     &3.9494e+03_r8,2.9622e+03_r8,1.9750e+03_r8,9.8786e+02_r8,1.1309e+01_r8/)
      kbo(:, 2,31,11) = (/ &
     &4.1497e+03_r8,3.1124e+03_r8,2.0751e+03_r8,1.0378e+03_r8,1.1233e+01_r8/)
      kbo(:, 3,31,11) = (/ &
     &4.3564e+03_r8,3.2674e+03_r8,2.1785e+03_r8,1.0895e+03_r8,1.1031e+01_r8/)
      kbo(:, 4,31,11) = (/ &
     &4.5677e+03_r8,3.4259e+03_r8,2.2841e+03_r8,1.1423e+03_r8,1.1018e+01_r8/)
      kbo(:, 5,31,11) = (/ &
     &4.7823e+03_r8,3.5869e+03_r8,2.3915e+03_r8,1.1960e+03_r8,1.0922e+01_r8/)
      kbo(:, 1,32,11) = (/ &
     &4.2398e+03_r8,3.1800e+03_r8,2.1202e+03_r8,1.0604e+03_r8,1.1395e+01_r8/)
      kbo(:, 2,32,11) = (/ &
     &4.4759e+03_r8,3.3571e+03_r8,2.2382e+03_r8,1.1194e+03_r8,1.1282e+01_r8/)
      kbo(:, 3,32,11) = (/ &
     &4.7161e+03_r8,3.5372e+03_r8,2.3583e+03_r8,1.1795e+03_r8,1.1286e+01_r8/)
      kbo(:, 4,32,11) = (/ &
     &4.9603e+03_r8,3.7204e+03_r8,2.4805e+03_r8,1.2406e+03_r8,1.1267e+01_r8/)
      kbo(:, 5,32,11) = (/ &
     &5.2103e+03_r8,3.9079e+03_r8,2.6055e+03_r8,1.3031e+03_r8,1.1177e+01_r8/)
      kbo(:, 1,33,11) = (/ &
     &4.6404e+03_r8,3.4804e+03_r8,2.3205e+03_r8,1.1605e+03_r8,1.1433e+01_r8/)
      kbo(:, 2,33,11) = (/ &
     &4.9200e+03_r8,3.6901e+03_r8,2.4603e+03_r8,1.2304e+03_r8,1.1468e+01_r8/)
      kbo(:, 3,33,11) = (/ &
     &5.2076e+03_r8,3.9059e+03_r8,2.6041e+03_r8,1.3024e+03_r8,1.1541e+01_r8/)
      kbo(:, 4,33,11) = (/ &
     &5.4986e+03_r8,4.1241e+03_r8,2.7496e+03_r8,1.3751e+03_r8,1.1519e+01_r8/)
      kbo(:, 5,33,11) = (/ &
     &5.8045e+03_r8,4.3535e+03_r8,2.9026e+03_r8,1.4516e+03_r8,1.1398e+01_r8/)
      kbo(:, 1,34,11) = (/ &
     &4.9577e+03_r8,3.7184e+03_r8,2.4791e+03_r8,1.2399e+03_r8,1.1582e+01_r8/)
      kbo(:, 2,34,11) = (/ &
     &5.2771e+03_r8,3.9580e+03_r8,2.6389e+03_r8,1.3198e+03_r8,1.1708e+01_r8/)
      kbo(:, 3,34,11) = (/ &
     &5.6109e+03_r8,4.2083e+03_r8,2.8058e+03_r8,1.4032e+03_r8,1.1770e+01_r8/)
      kbo(:, 4,34,11) = (/ &
     &5.9588e+03_r8,4.4693e+03_r8,2.9798e+03_r8,1.4902e+03_r8,1.1629e+01_r8/)
      kbo(:, 5,34,11) = (/ &
     &6.3300e+03_r8,4.7477e+03_r8,3.1654e+03_r8,1.5830e+03_r8,1.1520e+01_r8/)
      kbo(:, 1,35,11) = (/ &
     &5.2909e+03_r8,3.9683e+03_r8,2.6458e+03_r8,1.3232e+03_r8,1.1741e+01_r8/)
      kbo(:, 2,35,11) = (/ &
     &5.6548e+03_r8,4.2413e+03_r8,2.8277e+03_r8,1.4142e+03_r8,1.1903e+01_r8/)
      kbo(:, 3,35,11) = (/ &
     &6.0420e+03_r8,4.5317e+03_r8,3.0214e+03_r8,1.5110e+03_r8,1.1866e+01_r8/)
      kbo(:, 4,35,11) = (/ &
     &6.4601e+03_r8,4.8453e+03_r8,3.2304e+03_r8,1.6156e+03_r8,1.1803e+01_r8/)
      kbo(:, 5,35,11) = (/ &
     &6.9268e+03_r8,5.1953e+03_r8,3.4637e+03_r8,1.7322e+03_r8,1.1652e+01_r8/)
      kbo(:, 1,36,11) = (/ &
     &5.5884e+03_r8,4.1915e+03_r8,2.7945e+03_r8,1.3976e+03_r8,1.1878e+01_r8/)
      kbo(:, 2,36,11) = (/ &
     &6.0018e+03_r8,4.5015e+03_r8,3.0012e+03_r8,1.5010e+03_r8,1.2049e+01_r8/)
      kbo(:, 3,36,11) = (/ &
     &6.4517e+03_r8,4.8389e+03_r8,3.2262e+03_r8,1.6135e+03_r8,1.1951e+01_r8/)
      kbo(:, 4,36,11) = (/ &
     &6.9515e+03_r8,5.2138e+03_r8,3.4761e+03_r8,1.7384e+03_r8,1.1938e+01_r8/)
      kbo(:, 5,36,11) = (/ &
     &7.5289e+03_r8,5.6469e+03_r8,3.7648e+03_r8,1.8827e+03_r8,1.1892e+01_r8/)
      kbo(:, 1,37,11) = (/ &
     &5.7114e+03_r8,4.2838e+03_r8,2.8561e+03_r8,1.4284e+03_r8,1.1983e+01_r8/)
      kbo(:, 2,37,11) = (/ &
     &6.1629e+03_r8,4.6224e+03_r8,3.0818e+03_r8,1.5413e+03_r8,1.2105e+01_r8/)
      kbo(:, 3,37,11) = (/ &
     &6.6668e+03_r8,5.0003e+03_r8,3.3338e+03_r8,1.6673e+03_r8,1.2063e+01_r8/)
      kbo(:, 4,37,11) = (/ &
     &7.2441e+03_r8,5.4333e+03_r8,3.6224e+03_r8,1.8115e+03_r8,1.2103e+01_r8/)
      kbo(:, 5,37,11) = (/ &
     &7.9256e+03_r8,5.9443e+03_r8,3.9631e+03_r8,1.9819e+03_r8,1.2052e+01_r8/)
      kbo(:, 1,38,11) = (/ &
     &5.9457e+03_r8,4.4595e+03_r8,2.9732e+03_r8,1.4870e+03_r8,1.2040e+01_r8/)
      kbo(:, 2,38,11) = (/ &
     &6.4404e+03_r8,4.8305e+03_r8,3.2206e+03_r8,1.6107e+03_r8,1.2135e+01_r8/)
      kbo(:, 3,38,11) = (/ &
     &7.0103e+03_r8,5.2579e+03_r8,3.5055e+03_r8,1.7531e+03_r8,1.2201e+01_r8/)
      kbo(:, 4,38,11) = (/ &
     &7.6883e+03_r8,5.7664e+03_r8,3.8444e+03_r8,1.9225e+03_r8,1.2264e+01_r8/)
      kbo(:, 5,38,11) = (/ &
     &8.5003e+03_r8,6.3754e+03_r8,4.2504e+03_r8,2.1255e+03_r8,1.2214e+01_r8/)
      kbo(:, 1,39,11) = (/ &
     &6.3574e+03_r8,4.7683e+03_r8,3.1792e+03_r8,1.5900e+03_r8,1.2058e+01_r8/)
      kbo(:, 2,39,11) = (/ &
     &6.9172e+03_r8,5.1882e+03_r8,3.4591e+03_r8,1.7299e+03_r8,1.2221e+01_r8/)
      kbo(:, 3,39,11) = (/ &
     &7.5768e+03_r8,5.6828e+03_r8,3.7888e+03_r8,1.8948e+03_r8,1.2385e+01_r8/)
      kbo(:, 4,39,11) = (/ &
     &8.3852e+03_r8,6.2891e+03_r8,4.1930e+03_r8,2.0968e+03_r8,1.2417e+01_r8/)
      kbo(:, 5,39,11) = (/ &
     &9.3744e+03_r8,7.0310e+03_r8,4.6875e+03_r8,2.3441e+03_r8,1.2400e+01_r8/)
      kbo(:, 1,40,11) = (/ &
     &6.3544e+03_r8,4.7660e+03_r8,3.1776e+03_r8,1.5893e+03_r8,1.2034e+01_r8/)
      kbo(:, 2,40,11) = (/ &
     &6.9547e+03_r8,5.2162e+03_r8,3.4777e+03_r8,1.7393e+03_r8,1.2252e+01_r8/)
      kbo(:, 3,40,11) = (/ &
     &7.6538e+03_r8,5.7405e+03_r8,3.8272e+03_r8,1.9140e+03_r8,1.2461e+01_r8/)
      kbo(:, 4,40,11) = (/ &
     &8.5373e+03_r8,6.4031e+03_r8,4.2689e+03_r8,2.1348e+03_r8,1.2533e+01_r8/)
      kbo(:, 5,40,11) = (/ &
     &9.6388e+03_r8,7.2292e+03_r8,4.8196e+03_r8,2.4101e+03_r8,1.2526e+01_r8/)
      kbo(:, 1,41,11) = (/ &
     &6.3521e+03_r8,4.7643e+03_r8,3.1765e+03_r8,1.5887e+03_r8,1.1995e+01_r8/)
      kbo(:, 2,41,11) = (/ &
     &6.9920e+03_r8,5.2442e+03_r8,3.4964e+03_r8,1.7486e+03_r8,1.2280e+01_r8/)
      kbo(:, 3,41,11) = (/ &
     &7.7375e+03_r8,5.8033e+03_r8,3.8691e+03_r8,1.9349e+03_r8,1.2499e+01_r8/)
      kbo(:, 4,41,11) = (/ &
     &8.6900e+03_r8,6.5177e+03_r8,4.3453e+03_r8,2.1730e+03_r8,1.2628e+01_r8/)
      kbo(:, 5,41,11) = (/ &
     &9.9008e+03_r8,7.4257e+03_r8,4.9507e+03_r8,2.4756e+03_r8,1.2622e+01_r8/)
      kbo(:, 1,42,11) = (/ &
     &6.4377e+03_r8,4.8285e+03_r8,3.2193e+03_r8,1.6101e+03_r8,1.1943e+01_r8/)
      kbo(:, 2,42,11) = (/ &
     &7.1284e+03_r8,5.3465e+03_r8,3.5646e+03_r8,1.7827e+03_r8,1.2311e+01_r8/)
      kbo(:, 3,42,11) = (/ &
     &7.9472e+03_r8,5.9606e+03_r8,3.9739e+03_r8,1.9873e+03_r8,1.2580e+01_r8/)
      kbo(:, 4,42,11) = (/ &
     &8.9767e+03_r8,6.7326e+03_r8,4.4886e+03_r8,2.2446e+03_r8,1.2710e+01_r8/)
      kbo(:, 5,42,11) = (/ &
     &1.0302e+04_r8,7.7266e+03_r8,5.1512e+03_r8,2.5758e+03_r8,1.2734e+01_r8/)
      kbo(:, 1,43,11) = (/ &
     &6.5684e+03_r8,4.9266e+03_r8,3.2847e+03_r8,1.6428e+03_r8,1.1839e+01_r8/)
      kbo(:, 2,43,11) = (/ &
     &7.3100e+03_r8,5.4827e+03_r8,3.6554e+03_r8,1.8281e+03_r8,1.2298e+01_r8/)
      kbo(:, 3,43,11) = (/ &
     &8.2069e+03_r8,6.1553e+03_r8,4.1038e+03_r8,2.0523e+03_r8,1.2585e+01_r8/)
      kbo(:, 4,43,11) = (/ &
     &9.3215e+03_r8,6.9913e+03_r8,4.6611e+03_r8,2.3308e+03_r8,1.2796e+01_r8/)
      kbo(:, 5,43,11) = (/ &
     &1.0756e+04_r8,8.0671e+03_r8,5.3782e+03_r8,2.6894e+03_r8,1.2802e+01_r8/)
      kbo(:, 1,44,11) = (/ &
     &6.7770e+03_r8,5.0829e+03_r8,3.3889e+03_r8,1.6949e+03_r8,1.1696e+01_r8/)
      kbo(:, 2,44,11) = (/ &
     &7.6014e+03_r8,5.7012e+03_r8,3.8011e+03_r8,1.9009e+03_r8,1.2235e+01_r8/)
      kbo(:, 3,44,11) = (/ &
     &8.5905e+03_r8,6.4430e+03_r8,4.2955e+03_r8,2.1481e+03_r8,1.2598e+01_r8/)
      kbo(:, 4,44,11) = (/ &
     &9.8167e+03_r8,7.3626e+03_r8,4.9086e+03_r8,2.4546e+03_r8,1.2843e+01_r8/)
      kbo(:, 5,44,11) = (/ &
     &1.1370e+04_r8,8.5274e+03_r8,5.6850e+03_r8,2.8427e+03_r8,1.2862e+01_r8/)
      kbo(:, 1,45,11) = (/ &
     &7.1337e+03_r8,5.3505e+03_r8,3.5673e+03_r8,1.7841e+03_r8,1.1553e+01_r8/)
      kbo(:, 2,45,11) = (/ &
     &8.0813e+03_r8,6.0612e+03_r8,4.0411e+03_r8,2.0209e+03_r8,1.2213e+01_r8/)
      kbo(:, 3,45,11) = (/ &
     &9.1915e+03_r8,6.8938e+03_r8,4.5961e+03_r8,2.2984e+03_r8,1.2577e+01_r8/)
      kbo(:, 4,45,11) = (/ &
     &1.0572e+04_r8,7.9290e+03_r8,5.2862e+03_r8,2.6434e+03_r8,1.2862e+01_r8/)
      kbo(:, 5,45,11) = (/ &
     &1.2294e+04_r8,9.2203e+03_r8,6.1470e+03_r8,3.0738e+03_r8,1.2905e+01_r8/)
      kbo(:, 1,46,11) = (/ &
     &7.5574e+03_r8,5.6683e+03_r8,3.7792e+03_r8,1.8901e+03_r8,1.1372e+01_r8/)
      kbo(:, 2,46,11) = (/ &
     &8.6566e+03_r8,6.4927e+03_r8,4.3287e+03_r8,2.1648e+03_r8,1.2098e+01_r8/)
      kbo(:, 3,46,11) = (/ &
     &9.9311e+03_r8,7.4485e+03_r8,4.9659e+03_r8,2.4833e+03_r8,1.2508e+01_r8/)
      kbo(:, 4,46,11) = (/ &
     &1.1483e+04_r8,8.6121e+03_r8,5.7416e+03_r8,2.8711e+03_r8,1.2889e+01_r8/)
      kbo(:, 5,46,11) = (/ &
     &1.3417e+04_r8,1.0063e+04_r8,6.7088e+03_r8,3.3546e+03_r8,1.2962e+01_r8/)
      kbo(:, 1,47,11) = (/ &
     &7.8727e+03_r8,5.9048e+03_r8,3.9368e+03_r8,1.9689e+03_r8,1.1120e+01_r8/)
      kbo(:, 2,47,11) = (/ &
     &9.1356e+03_r8,6.8519e+03_r8,4.5682e+03_r8,2.2845e+03_r8,1.1918e+01_r8/)
      kbo(:, 3,47,11) = (/ &
     &1.0582e+04_r8,7.9368e+03_r8,5.2914e+03_r8,2.6461e+03_r8,1.2406e+01_r8/)
      kbo(:, 4,47,11) = (/ &
     &1.2301e+04_r8,9.2260e+03_r8,6.1509e+03_r8,3.0757e+03_r8,1.2816e+01_r8/)
      kbo(:, 5,47,11) = (/ &
     &1.4433e+04_r8,1.0825e+04_r8,7.2167e+03_r8,3.6086e+03_r8,1.2983e+01_r8/)
      kbo(:, 1,48,11) = (/ &
     &8.4035e+03_r8,6.3029e+03_r8,4.2022e+03_r8,2.1016e+03_r8,1.0897e+01_r8/)
      kbo(:, 2,48,11) = (/ &
     &9.8931e+03_r8,7.4200e+03_r8,4.9470e+03_r8,2.4739e+03_r8,1.1706e+01_r8/)
      kbo(:, 3,48,11) = (/ &
     &1.1589e+04_r8,8.6922e+03_r8,5.7950e+03_r8,2.8979e+03_r8,1.2313e+01_r8/)
      kbo(:, 4,48,11) = (/ &
     &1.3567e+04_r8,1.0175e+04_r8,6.7839e+03_r8,3.3922e+03_r8,1.2741e+01_r8/)
      kbo(:, 5,48,11) = (/ &
     &1.5977e+04_r8,1.1983e+04_r8,7.9888e+03_r8,3.9947e+03_r8,1.2994e+01_r8/)
      kbo(:, 1,49,11) = (/ &
     &9.3222e+03_r8,6.9919e+03_r8,4.6615e+03_r8,2.3312e+03_r8,1.0633e+01_r8/)
      kbo(:, 2,49,11) = (/ &
     &1.1123e+04_r8,8.3424e+03_r8,5.5619e+03_r8,2.7813e+03_r8,1.1478e+01_r8/)
      kbo(:, 3,49,11) = (/ &
     &1.3212e+04_r8,9.9089e+03_r8,6.6061e+03_r8,3.3034e+03_r8,1.2190e+01_r8/)
      kbo(:, 4,49,11) = (/ &
     &1.5603e+04_r8,1.1702e+04_r8,7.8017e+03_r8,3.9011e+03_r8,1.2697e+01_r8/)
      kbo(:, 5,49,11) = (/ &
     &1.8442e+04_r8,1.3832e+04_r8,9.2215e+03_r8,4.6110e+03_r8,1.3027e+01_r8/)
      kbo(:, 1,50,11) = (/ &
     &9.8729e+03_r8,7.4049e+03_r8,4.9369e+03_r8,2.4688e+03_r8,1.0346e+01_r8/)
      kbo(:, 2,50,11) = (/ &
     &1.1927e+04_r8,8.9452e+03_r8,5.9637e+03_r8,2.9822e+03_r8,1.1213e+01_r8/)
      kbo(:, 3,50,11) = (/ &
     &1.4376e+04_r8,1.0782e+04_r8,7.1884e+03_r8,3.5945e+03_r8,1.2042e+01_r8/)
      kbo(:, 4,50,11) = (/ &
     &1.7156e+04_r8,1.2867e+04_r8,8.5782e+03_r8,4.2894e+03_r8,1.2592e+01_r8/)
      kbo(:, 5,50,11) = (/ &
     &2.0387e+04_r8,1.5290e+04_r8,1.0194e+04_r8,5.0970e+03_r8,1.3035e+01_r8/)
      kbo(:, 1,51,11) = (/ &
     &1.0246e+04_r8,7.6846e+03_r8,5.1234e+03_r8,2.5621e+03_r8,1.0080e+01_r8/)
      kbo(:, 2,51,11) = (/ &
     &1.2504e+04_r8,9.3781e+03_r8,6.2523e+03_r8,3.1265e+03_r8,1.0959e+01_r8/)
      kbo(:, 3,51,11) = (/ &
     &1.5294e+04_r8,1.1471e+04_r8,7.6476e+03_r8,3.8241e+03_r8,1.1913e+01_r8/)
      kbo(:, 4,51,11) = (/ &
     &1.8483e+04_r8,1.3863e+04_r8,9.2420e+03_r8,4.6213e+03_r8,1.2523e+01_r8/)
      kbo(:, 5,51,11) = (/ &
     &2.2103e+04_r8,1.6577e+04_r8,1.1052e+04_r8,5.5261e+03_r8,1.3008e+01_r8/)
      kbo(:, 1,52,11) = (/ &
     &1.0919e+04_r8,8.1898e+03_r8,5.4601e+03_r8,2.7304e+03_r8,9.7365e+00_r8/)
      kbo(:, 2,52,11) = (/ &
     &1.3474e+04_r8,1.0106e+04_r8,6.7375e+03_r8,3.3691e+03_r8,1.0715e+01_r8/)
      kbo(:, 3,52,11) = (/ &
     &1.6692e+04_r8,1.2519e+04_r8,8.3465e+03_r8,4.1736e+03_r8,1.1714e+01_r8/)
      kbo(:, 4,52,11) = (/ &
     &2.0445e+04_r8,1.5334e+04_r8,1.0223e+04_r8,5.1117e+03_r8,1.2415e+01_r8/)
      kbo(:, 5,52,11) = (/ &
     &2.4642e+04_r8,1.8481e+04_r8,1.2321e+04_r8,6.1608e+03_r8,1.2964e+01_r8/)
      kbo(:, 1,53,11) = (/ &
     &1.2096e+04_r8,9.0720e+03_r8,6.0483e+03_r8,3.0245e+03_r8,9.3807e+00_r8/)
      kbo(:, 2,53,11) = (/ &
     &1.5115e+04_r8,1.1337e+04_r8,7.5582e+03_r8,3.7794e+03_r8,1.0467e+01_r8/)
      kbo(:, 3,53,11) = (/ &
     &1.8931e+04_r8,1.4199e+04_r8,9.4661e+03_r8,4.7334e+03_r8,1.1520e+01_r8/)
      kbo(:, 4,53,11) = (/ &
     &2.3491e+04_r8,1.7618e+04_r8,1.1746e+04_r8,5.8732e+03_r8,1.2292e+01_r8/)
      kbo(:, 5,53,11) = (/ &
     &2.8602e+04_r8,2.1452e+04_r8,1.4301e+04_r8,7.1510e+03_r8,1.2913e+01_r8/)
      kbo(:, 1,54,11) = (/ &
     &1.1628e+04_r8,8.7215e+03_r8,5.8146e+03_r8,2.9077e+03_r8,8.9653e+00_r8/)
      kbo(:, 2,54,11) = (/ &
     &1.4721e+04_r8,1.1041e+04_r8,7.3608e+03_r8,3.6808e+03_r8,1.0130e+01_r8/)
      kbo(:, 3,54,11) = (/ &
     &1.8638e+04_r8,1.3979e+04_r8,9.3193e+03_r8,4.6600e+03_r8,1.1195e+01_r8/)
      kbo(:, 4,54,11) = (/ &
     &2.3417e+04_r8,1.7563e+04_r8,1.1709e+04_r8,5.8547e+03_r8,1.2060e+01_r8/)
      kbo(:, 5,54,11) = (/ &
     &2.8828e+04_r8,2.1621e+04_r8,1.4414e+04_r8,7.2075e+03_r8,1.2739e+01_r8/)
      kbo(:, 1,55,11) = (/ &
     &1.0209e+04_r8,7.6567e+03_r8,5.1047e+03_r8,2.5527e+03_r8,8.5323e+00_r8/)
      kbo(:, 2,55,11) = (/ &
     &1.3095e+04_r8,9.8211e+03_r8,6.5477e+03_r8,3.2742e+03_r8,9.7667e+00_r8/)
      kbo(:, 3,55,11) = (/ &
     &1.6780e+04_r8,1.2585e+04_r8,8.3901e+03_r8,4.1954e+03_r8,1.0760e+01_r8/)
      kbo(:, 4,55,11) = (/ &
     &2.1308e+04_r8,1.5981e+04_r8,1.0654e+04_r8,5.3275e+03_r8,1.1787e+01_r8/)
      kbo(:, 5,55,11) = (/ &
     &2.6526e+04_r8,1.9895e+04_r8,1.3264e+04_r8,6.6321e+03_r8,1.2490e+01_r8/)
      kbo(:, 1,56,11) = (/ &
     &8.9242e+03_r8,6.6933e+03_r8,4.4624e+03_r8,2.2315e+03_r8,8.1192e+00_r8/)
      kbo(:, 2,56,11) = (/ &
     &1.1623e+04_r8,8.7170e+03_r8,5.8115e+03_r8,2.9061e+03_r8,9.3346e+00_r8/)
      kbo(:, 3,56,11) = (/ &
     &1.5096e+04_r8,1.1322e+04_r8,7.5482e+03_r8,3.7744e+03_r8,1.0408e+01_r8/)
      kbo(:, 4,56,11) = (/ &
     &1.9354e+04_r8,1.4515e+04_r8,9.6771e+03_r8,4.8388e+03_r8,1.1396e+01_r8/)
      kbo(:, 5,56,11) = (/ &
     &2.4338e+04_r8,1.8253e+04_r8,1.2169e+04_r8,6.0847e+03_r8,1.2212e+01_r8/)
      kbo(:, 1,57,11) = (/ &
     &7.7622e+03_r8,5.8218e+03_r8,3.8814e+03_r8,1.9410e+03_r8,7.7106e+00_r8/)
      kbo(:, 2,57,11) = (/ &
     &1.0290e+04_r8,7.7178e+03_r8,5.1454e+03_r8,2.5730e+03_r8,8.9363e+00_r8/)
      kbo(:, 3,57,11) = (/ &
     &1.3552e+04_r8,1.0164e+04_r8,6.7760e+03_r8,3.3882e+03_r8,1.0051e+01_r8/)
      kbo(:, 4,57,11) = (/ &
     &1.7543e+04_r8,1.3157e+04_r8,8.7715e+03_r8,4.3860e+03_r8,1.0990e+01_r8/)
      kbo(:, 5,57,11) = (/ &
     &2.2284e+04_r8,1.6713e+04_r8,1.1142e+04_r8,5.5714e+03_r8,1.1934e+01_r8/)
      kbo(:, 1,58,11) = (/ &
     &1.7767e+03_r8,1.6290e+03_r8,1.3968e+03_r8,9.7855e+02_r8,7.2858e+00_r8/)
      kbo(:, 2,58,11) = (/ &
     &2.4068e+03_r8,2.2067e+03_r8,1.8922e+03_r8,1.3254e+03_r8,8.5609e+00_r8/)
      kbo(:, 3,58,11) = (/ &
     &3.2122e+03_r8,2.9452e+03_r8,2.5253e+03_r8,1.7688e+03_r8,9.6597e+00_r8/)
      kbo(:, 4,58,11) = (/ &
     &4.2027e+03_r8,3.8533e+03_r8,3.3039e+03_r8,2.3142e+03_r8,1.0637e+01_r8/)
      kbo(:, 5,58,11) = (/ &
     &5.3882e+03_r8,4.9402e+03_r8,4.2359e+03_r8,2.9669e+03_r8,1.1542e+01_r8/)
      kbo(:, 1,59,11) = (/ &
     &1.9233e+03_r8,1.6794e+03_r8,1.3397e+03_r8,8.3393e+02_r8,7.1275e+00_r8/)
      kbo(:, 2,59,11) = (/ &
     &2.6585e+03_r8,2.3214e+03_r8,1.8518e+03_r8,1.1525e+03_r8,8.4302e+00_r8/)
      kbo(:, 3,59,11) = (/ &
     &3.5898e+03_r8,3.1345e+03_r8,2.5004e+03_r8,1.5561e+03_r8,9.5360e+00_r8/)
      kbo(:, 4,59,11) = (/ &
     &4.7292e+03_r8,4.1294e+03_r8,3.2940e+03_r8,2.0499e+03_r8,1.0472e+01_r8/)
      kbo(:, 5,59,11) = (/ &
     &6.0902e+03_r8,5.3178e+03_r8,4.2419e+03_r8,2.6398e+03_r8,1.1150e+01_r8/)
      kbo(:, 1,13,12) = (/ &
     &2.7240e+05_r8,2.0430e+05_r8,1.3620e+05_r8,6.8101e+04_r8,4.4161e+00_r8/)
      kbo(:, 2,13,12) = (/ &
     &2.7176e+05_r8,2.0382e+05_r8,1.3588e+05_r8,6.7942e+04_r8,4.2840e+00_r8/)
      kbo(:, 3,13,12) = (/ &
     &2.7001e+05_r8,2.0251e+05_r8,1.3501e+05_r8,6.7503e+04_r8,4.1173e+00_r8/)
      kbo(:, 4,13,12) = (/ &
     &2.6763e+05_r8,2.0073e+05_r8,1.3382e+05_r8,6.6909e+04_r8,3.9336e+00_r8/)
      kbo(:, 5,13,12) = (/ &
     &2.6442e+05_r8,1.9831e+05_r8,1.3221e+05_r8,6.6105e+04_r8,3.6961e+00_r8/)
      kbo(:, 1,14,12) = (/ &
     &1.8113e+05_r8,1.3585e+05_r8,9.0565e+04_r8,4.5283e+04_r8,4.8454e+00_r8/)
      kbo(:, 2,14,12) = (/ &
     &1.8030e+05_r8,1.3523e+05_r8,9.0150e+04_r8,4.5075e+04_r8,4.6873e+00_r8/)
      kbo(:, 3,14,12) = (/ &
     &1.7856e+05_r8,1.3392e+05_r8,8.9279e+04_r8,4.4640e+04_r8,4.6210e+00_r8/)
      kbo(:, 4,14,12) = (/ &
     &1.7661e+05_r8,1.3246e+05_r8,8.8303e+04_r8,4.4152e+04_r8,4.4506e+00_r8/)
      kbo(:, 5,14,12) = (/ &
     &1.7414e+05_r8,1.3060e+05_r8,8.7069e+04_r8,4.3535e+04_r8,4.3231e+00_r8/)
      kbo(:, 1,15,12) = (/ &
     &1.2085e+05_r8,9.0635e+04_r8,6.0424e+04_r8,3.0213e+04_r8,5.3476e+00_r8/)
      kbo(:, 2,15,12) = (/ &
     &1.1987e+05_r8,8.9903e+04_r8,5.9936e+04_r8,2.9969e+04_r8,5.2285e+00_r8/)
      kbo(:, 3,15,12) = (/ &
     &1.1863e+05_r8,8.8976e+04_r8,5.9318e+04_r8,2.9660e+04_r8,5.0918e+00_r8/)
      kbo(:, 4,15,12) = (/ &
     &1.1686e+05_r8,8.7649e+04_r8,5.8433e+04_r8,2.9217e+04_r8,4.9903e+00_r8/)
      kbo(:, 5,15,12) = (/ &
     &1.1485e+05_r8,8.6139e+04_r8,5.7427e+04_r8,2.8714e+04_r8,4.7856e+00_r8/)
      kbo(:, 1,16,12) = (/ &
     &9.4371e+04_r8,7.0779e+04_r8,4.7186e+04_r8,2.3593e+04_r8,5.9193e+00_r8/)
      kbo(:, 2,16,12) = (/ &
     &9.3237e+04_r8,6.9928e+04_r8,4.6619e+04_r8,2.3310e+04_r8,5.7778e+00_r8/)
      kbo(:, 3,16,12) = (/ &
     &9.1868e+04_r8,6.8901e+04_r8,4.5935e+04_r8,2.2968e+04_r8,5.6214e+00_r8/)
      kbo(:, 4,16,12) = (/ &
     &9.0372e+04_r8,6.7780e+04_r8,4.5187e+04_r8,2.2594e+04_r8,5.5103e+00_r8/)
      kbo(:, 5,16,12) = (/ &
     &8.8699e+04_r8,6.6525e+04_r8,4.4350e+04_r8,2.2176e+04_r8,5.3472e+00_r8/)
      kbo(:, 1,17,12) = (/ &
     &7.4737e+04_r8,5.6053e+04_r8,3.7369e+04_r8,1.8685e+04_r8,6.5296e+00_r8/)
      kbo(:, 2,17,12) = (/ &
     &7.3678e+04_r8,5.5259e+04_r8,3.6840e+04_r8,1.8420e+04_r8,6.3899e+00_r8/)
      kbo(:, 3,17,12) = (/ &
     &7.2463e+04_r8,5.4347e+04_r8,3.6232e+04_r8,1.8116e+04_r8,6.2234e+00_r8/)
      kbo(:, 4,17,12) = (/ &
     &7.1178e+04_r8,5.3383e+04_r8,3.5589e+04_r8,1.7795e+04_r8,6.1262e+00_r8/)
      kbo(:, 5,17,12) = (/ &
     &6.9846e+04_r8,5.2385e+04_r8,3.4923e+04_r8,1.7462e+04_r8,6.0038e+00_r8/)
      kbo(:, 1,18,12) = (/ &
     &5.9561e+04_r8,4.4671e+04_r8,2.9781e+04_r8,1.4891e+04_r8,7.2106e+00_r8/)
      kbo(:, 2,18,12) = (/ &
     &5.8573e+04_r8,4.3930e+04_r8,2.9287e+04_r8,1.4644e+04_r8,7.0772e+00_r8/)
      kbo(:, 3,18,12) = (/ &
     &5.7514e+04_r8,4.3136e+04_r8,2.8757e+04_r8,1.4379e+04_r8,6.9067e+00_r8/)
      kbo(:, 4,18,12) = (/ &
     &5.6474e+04_r8,4.2356e+04_r8,2.8238e+04_r8,1.4119e+04_r8,6.7942e+00_r8/)
      kbo(:, 5,18,12) = (/ &
     &5.5403e+04_r8,4.1552e+04_r8,2.7702e+04_r8,1.3851e+04_r8,6.6477e+00_r8/)
      kbo(:, 1,19,12) = (/ &
     &4.5689e+04_r8,3.4267e+04_r8,2.2845e+04_r8,1.1423e+04_r8,7.9750e+00_r8/)
      kbo(:, 2,19,12) = (/ &
     &4.4876e+04_r8,3.3657e+04_r8,2.2438e+04_r8,1.1220e+04_r8,7.8278e+00_r8/)
      kbo(:, 3,19,12) = (/ &
     &4.4040e+04_r8,3.3030e+04_r8,2.2021e+04_r8,1.1011e+04_r8,7.6237e+00_r8/)
      kbo(:, 4,19,12) = (/ &
     &4.3227e+04_r8,3.2420e+04_r8,2.1614e+04_r8,1.0807e+04_r8,7.5070e+00_r8/)
      kbo(:, 5,19,12) = (/ &
     &4.2374e+04_r8,3.1781e+04_r8,2.1187e+04_r8,1.0594e+04_r8,7.3430e+00_r8/)
      kbo(:, 1,20,12) = (/ &
     &3.7246e+04_r8,2.7935e+04_r8,1.8623e+04_r8,9.3122e+03_r8,8.8153e+00_r8/)
      kbo(:, 2,20,12) = (/ &
     &3.6550e+04_r8,2.7413e+04_r8,1.8276e+04_r8,9.1383e+03_r8,8.6532e+00_r8/)
      kbo(:, 3,20,12) = (/ &
     &3.5840e+04_r8,2.6880e+04_r8,1.7920e+04_r8,8.9607e+03_r8,8.4391e+00_r8/)
      kbo(:, 4,20,12) = (/ &
     &3.5149e+04_r8,2.6362e+04_r8,1.7575e+04_r8,8.7878e+03_r8,8.2995e+00_r8/)
      kbo(:, 5,20,12) = (/ &
     &3.4405e+04_r8,2.5804e+04_r8,1.7203e+04_r8,8.6018e+03_r8,8.1167e+00_r8/)
      kbo(:, 1,21,12) = (/ &
     &3.0709e+04_r8,2.3032e+04_r8,1.5355e+04_r8,7.6780e+03_r8,9.7372e+00_r8/)
      kbo(:, 2,21,12) = (/ &
     &3.0108e+04_r8,2.2581e+04_r8,1.5055e+04_r8,7.5277e+03_r8,9.5645e+00_r8/)
      kbo(:, 3,21,12) = (/ &
     &2.9509e+04_r8,2.2132e+04_r8,1.4755e+04_r8,7.3780e+03_r8,9.3267e+00_r8/)
      kbo(:, 4,21,12) = (/ &
     &2.8892e+04_r8,2.1670e+04_r8,1.4447e+04_r8,7.2238e+03_r8,9.1690e+00_r8/)
      kbo(:, 5,21,12) = (/ &
     &2.8241e+04_r8,2.1181e+04_r8,1.4121e+04_r8,7.0607e+03_r8,8.9671e+00_r8/)
      kbo(:, 1,22,12) = (/ &
     &2.5484e+04_r8,1.9113e+04_r8,1.2742e+04_r8,6.3717e+03_r8,1.0681e+01_r8/)
      kbo(:, 2,22,12) = (/ &
     &2.4964e+04_r8,1.8723e+04_r8,1.2483e+04_r8,6.2417e+03_r8,1.0497e+01_r8/)
      kbo(:, 3,22,12) = (/ &
     &2.4423e+04_r8,1.8317e+04_r8,1.2212e+04_r8,6.1064e+03_r8,1.0234e+01_r8/)
      kbo(:, 4,22,12) = (/ &
     &2.3869e+04_r8,1.7902e+04_r8,1.1935e+04_r8,5.9678e+03_r8,1.0059e+01_r8/)
      kbo(:, 5,22,12) = (/ &
     &2.3286e+04_r8,1.7465e+04_r8,1.1643e+04_r8,5.8221e+03_r8,9.8315e+00_r8/)
      kbo(:, 1,23,12) = (/ &
     &2.0918e+04_r8,1.5688e+04_r8,1.0459e+04_r8,5.2302e+03_r8,1.1614e+01_r8/)
      kbo(:, 2,23,12) = (/ &
     &2.0451e+04_r8,1.5339e+04_r8,1.0226e+04_r8,5.1135e+03_r8,1.1417e+01_r8/)
      kbo(:, 3,23,12) = (/ &
     &1.9969e+04_r8,1.4977e+04_r8,9.9848e+03_r8,4.9928e+03_r8,1.1125e+01_r8/)
      kbo(:, 4,23,12) = (/ &
     &1.9481e+04_r8,1.4611e+04_r8,9.7407e+03_r8,4.8708e+03_r8,1.0942e+01_r8/)
      kbo(:, 5,23,12) = (/ &
     &1.8998e+04_r8,1.4249e+04_r8,9.4994e+03_r8,4.7501e+03_r8,1.0699e+01_r8/)
      kbo(:, 1,24,12) = (/ &
     &1.6828e+04_r8,1.2621e+04_r8,8.4145e+03_r8,4.2078e+03_r8,1.2522e+01_r8/)
      kbo(:, 2,24,12) = (/ &
     &1.6415e+04_r8,1.2311e+04_r8,8.2079e+03_r8,4.1044e+03_r8,1.2299e+01_r8/)
      kbo(:, 3,24,12) = (/ &
     &1.6005e+04_r8,1.2004e+04_r8,8.0027e+03_r8,4.0018e+03_r8,1.2004e+01_r8/)
      kbo(:, 4,24,12) = (/ &
     &1.5632e+04_r8,1.1724e+04_r8,7.8164e+03_r8,3.9086e+03_r8,1.1796e+01_r8/)
      kbo(:, 5,24,12) = (/ &
     &1.5350e+04_r8,1.1513e+04_r8,7.6755e+03_r8,3.8381e+03_r8,1.1532e+01_r8/)
      kbo(:, 1,25,12) = (/ &
     &1.3517e+04_r8,1.0138e+04_r8,6.7590e+03_r8,3.3800e+03_r8,1.3378e+01_r8/)
      kbo(:, 2,25,12) = (/ &
     &1.3176e+04_r8,9.8826e+03_r8,6.5887e+03_r8,3.2948e+03_r8,1.3150e+01_r8/)
      kbo(:, 3,25,12) = (/ &
     &1.2900e+04_r8,9.6753e+03_r8,6.4505e+03_r8,3.2257e+03_r8,1.2858e+01_r8/)
      kbo(:, 4,25,12) = (/ &
     &1.2719e+04_r8,9.5392e+03_r8,6.3597e+03_r8,3.1803e+03_r8,1.2628e+01_r8/)
      kbo(:, 5,25,12) = (/ &
     &1.2623e+04_r8,9.4672e+03_r8,6.3117e+03_r8,3.1562e+03_r8,1.2342e+01_r8/)
      kbo(:, 1,26,12) = (/ &
     &1.0917e+04_r8,8.1877e+03_r8,5.4588e+03_r8,2.7299e+03_r8,1.4213e+01_r8/)
      kbo(:, 2,26,12) = (/ &
     &1.0711e+04_r8,8.0332e+03_r8,5.3557e+03_r8,2.6783e+03_r8,1.3979e+01_r8/)
      kbo(:, 3,26,12) = (/ &
     &1.0602e+04_r8,7.9514e+03_r8,5.3012e+03_r8,2.6510e+03_r8,1.3677e+01_r8/)
      kbo(:, 4,26,12) = (/ &
     &1.0604e+04_r8,7.9535e+03_r8,5.3026e+03_r8,2.6517e+03_r8,1.3410e+01_r8/)
      kbo(:, 5,26,12) = (/ &
     &1.0730e+04_r8,8.0477e+03_r8,5.3654e+03_r8,2.6831e+03_r8,1.3099e+01_r8/)
      kbo(:, 1,27,12) = (/ &
     &9.1749e+03_r8,6.8814e+03_r8,4.5879e+03_r8,2.2944e+03_r8,1.5000e+01_r8/)
      kbo(:, 2,27,12) = (/ &
     &9.1157e+03_r8,6.8370e+03_r8,4.5583e+03_r8,2.2796e+03_r8,1.4706e+01_r8/)
      kbo(:, 3,27,12) = (/ &
     &9.1873e+03_r8,6.8907e+03_r8,4.5941e+03_r8,2.2975e+03_r8,1.4431e+01_r8/)
      kbo(:, 4,27,12) = (/ &
     &9.3840e+03_r8,7.0382e+03_r8,4.6924e+03_r8,2.3467e+03_r8,1.4137e+01_r8/)
      kbo(:, 5,27,12) = (/ &
     &9.6488e+03_r8,7.2368e+03_r8,4.8249e+03_r8,2.4129e+03_r8,1.3775e+01_r8/)
      kbo(:, 1,28,12) = (/ &
     &8.0307e+03_r8,6.0232e+03_r8,4.0158e+03_r8,2.0083e+03_r8,1.5711e+01_r8/)
      kbo(:, 2,28,12) = (/ &
     &8.1446e+03_r8,6.1087e+03_r8,4.0727e+03_r8,2.0368e+03_r8,1.5384e+01_r8/)
      kbo(:, 3,28,12) = (/ &
     &8.3784e+03_r8,6.2841e+03_r8,4.1897e+03_r8,2.0953e+03_r8,1.5123e+01_r8/)
      kbo(:, 4,28,12) = (/ &
     &8.6648e+03_r8,6.4989e+03_r8,4.3329e+03_r8,2.1669e+03_r8,1.4791e+01_r8/)
      kbo(:, 5,28,12) = (/ &
     &9.0065e+03_r8,6.7551e+03_r8,4.5037e+03_r8,2.2523e+03_r8,1.4343e+01_r8/)
      kbo(:, 1,29,12) = (/ &
     &7.6471e+03_r8,5.7356e+03_r8,3.8240e+03_r8,1.9124e+03_r8,1.6341e+01_r8/)
      kbo(:, 2,29,12) = (/ &
     &7.9071e+03_r8,5.9306e+03_r8,3.9540e+03_r8,1.9775e+03_r8,1.6013e+01_r8/)
      kbo(:, 3,29,12) = (/ &
     &8.2292e+03_r8,6.1721e+03_r8,4.1151e+03_r8,2.0580e+03_r8,1.5732e+01_r8/)
      kbo(:, 4,29,12) = (/ &
     &8.6240e+03_r8,6.4682e+03_r8,4.3125e+03_r8,2.1567e+03_r8,1.5372e+01_r8/)
      kbo(:, 5,29,12) = (/ &
     &9.0598e+03_r8,6.7951e+03_r8,4.5304e+03_r8,2.2657e+03_r8,1.4767e+01_r8/)
      kbo(:, 1,30,12) = (/ &
     &7.6323e+03_r8,5.7245e+03_r8,3.8166e+03_r8,1.9088e+03_r8,1.6832e+01_r8/)
      kbo(:, 2,30,12) = (/ &
     &7.9856e+03_r8,5.9894e+03_r8,3.9933e+03_r8,1.9972e+03_r8,1.6592e+01_r8/)
      kbo(:, 3,30,12) = (/ &
     &8.4256e+03_r8,6.3195e+03_r8,4.2133e+03_r8,2.1072e+03_r8,1.6260e+01_r8/)
      kbo(:, 4,30,12) = (/ &
     &8.9027e+03_r8,6.6772e+03_r8,4.4518e+03_r8,2.2264e+03_r8,1.5767e+01_r8/)
      kbo(:, 5,30,12) = (/ &
     &9.4138e+03_r8,7.0606e+03_r8,4.7073e+03_r8,2.3541e+03_r8,1.5140e+01_r8/)
      kbo(:, 1,31,12) = (/ &
     &8.1459e+03_r8,6.1097e+03_r8,4.0735e+03_r8,2.0373e+03_r8,1.7334e+01_r8/)
      kbo(:, 2,31,12) = (/ &
     &8.6243e+03_r8,6.4685e+03_r8,4.3127e+03_r8,2.1569e+03_r8,1.7064e+01_r8/)
      kbo(:, 3,31,12) = (/ &
     &9.1518e+03_r8,6.8642e+03_r8,4.5764e+03_r8,2.2887e+03_r8,1.6609e+01_r8/)
      kbo(:, 4,31,12) = (/ &
     &9.7356e+03_r8,7.3019e+03_r8,4.8683e+03_r8,2.4346e+03_r8,1.5848e+01_r8/)
      kbo(:, 5,31,12) = (/ &
     &1.0365e+04_r8,7.7736e+03_r8,5.1827e+03_r8,2.5918e+03_r8,1.5376e+01_r8/)
      kbo(:, 1,32,12) = (/ &
     &8.9083e+03_r8,6.6815e+03_r8,4.4547e+03_r8,2.2279e+03_r8,1.7730e+01_r8/)
      kbo(:, 2,32,12) = (/ &
     &9.4979e+03_r8,7.1237e+03_r8,4.7495e+03_r8,2.3753e+03_r8,1.7331e+01_r8/)
      kbo(:, 3,32,12) = (/ &
     &1.0147e+04_r8,7.6108e+03_r8,5.0742e+03_r8,2.5376e+03_r8,1.6589e+01_r8/)
      kbo(:, 4,32,12) = (/ &
     &1.0867e+04_r8,8.1507e+03_r8,5.4341e+03_r8,2.7175e+03_r8,1.6156e+01_r8/)
      kbo(:, 5,32,12) = (/ &
     &1.1646e+04_r8,8.7350e+03_r8,5.8236e+03_r8,2.9122e+03_r8,1.5848e+01_r8/)
      kbo(:, 1,33,12) = (/ &
     &9.9979e+03_r8,7.4987e+03_r8,4.9995e+03_r8,2.5003e+03_r8,1.7989e+01_r8/)
      kbo(:, 2,33,12) = (/ &
     &1.0743e+04_r8,8.0578e+03_r8,5.3722e+03_r8,2.6866e+03_r8,1.7365e+01_r8/)
      kbo(:, 3,33,12) = (/ &
     &1.1568e+04_r8,8.6761e+03_r8,5.7844e+03_r8,2.8926e+03_r8,1.6901e+01_r8/)
      kbo(:, 4,33,12) = (/ &
     &1.2466e+04_r8,9.3497e+03_r8,6.2334e+03_r8,3.1171e+03_r8,1.6592e+01_r8/)
      kbo(:, 5,33,12) = (/ &
     &1.3441e+04_r8,1.0081e+04_r8,6.7208e+03_r8,3.3608e+03_r8,1.6160e+01_r8/)
      kbo(:, 1,34,12) = (/ &
     &1.1005e+04_r8,8.2543e+03_r8,5.5032e+03_r8,2.7521e+03_r8,1.8094e+01_r8/)
      kbo(:, 2,34,12) = (/ &
     &1.1925e+04_r8,8.9436e+03_r8,5.9627e+03_r8,2.9818e+03_r8,1.7503e+01_r8/)
      kbo(:, 3,34,12) = (/ &
     &1.2929e+04_r8,9.6970e+03_r8,6.4650e+03_r8,3.2329e+03_r8,1.7258e+01_r8/)
      kbo(:, 4,34,12) = (/ &
     &1.4013e+04_r8,1.0510e+04_r8,7.0067e+03_r8,3.5037e+03_r8,1.6964e+01_r8/)
      kbo(:, 5,34,12) = (/ &
     &1.5204e+04_r8,1.1403e+04_r8,7.6022e+03_r8,3.8015e+03_r8,1.6506e+01_r8/)
      kbo(:, 1,35,12) = (/ &
     &1.2135e+04_r8,9.1016e+03_r8,6.0680e+03_r8,3.0345e+03_r8,1.8232e+01_r8/)
      kbo(:, 2,35,12) = (/ &
     &1.3244e+04_r8,9.9331e+03_r8,6.6223e+03_r8,3.3116e+03_r8,1.7908e+01_r8/)
      kbo(:, 3,35,12) = (/ &
     &1.4457e+04_r8,1.0843e+04_r8,7.2288e+03_r8,3.6148e+03_r8,1.7659e+01_r8/)
      kbo(:, 4,35,12) = (/ &
     &1.5776e+04_r8,1.1833e+04_r8,7.8886e+03_r8,3.9447e+03_r8,1.7305e+01_r8/)
      kbo(:, 5,35,12) = (/ &
     &1.7218e+04_r8,1.2914e+04_r8,8.6094e+03_r8,4.3051e+03_r8,1.6889e+01_r8/)
      kbo(:, 1,36,12) = (/ &
     &1.3247e+04_r8,9.9356e+03_r8,6.6240e+03_r8,3.3125e+03_r8,1.8488e+01_r8/)
      kbo(:, 2,36,12) = (/ &
     &1.4560e+04_r8,1.0920e+04_r8,7.2802e+03_r8,3.6405e+03_r8,1.8270e+01_r8/)
      kbo(:, 3,36,12) = (/ &
     &1.6016e+04_r8,1.2012e+04_r8,8.0085e+03_r8,4.0046e+03_r8,1.8063e+01_r8/)
      kbo(:, 4,36,12) = (/ &
     &1.7602e+04_r8,1.3202e+04_r8,8.8012e+03_r8,4.4010e+03_r8,1.7553e+01_r8/)
      kbo(:, 5,36,12) = (/ &
     &1.9328e+04_r8,1.4496e+04_r8,9.6641e+03_r8,4.8324e+03_r8,1.7048e+01_r8/)
      kbo(:, 1,37,12) = (/ &
     &1.3952e+04_r8,1.0464e+04_r8,6.9765e+03_r8,3.4887e+03_r8,1.8801e+01_r8/)
      kbo(:, 2,37,12) = (/ &
     &1.5457e+04_r8,1.1593e+04_r8,7.7287e+03_r8,3.8648e+03_r8,1.8637e+01_r8/)
      kbo(:, 3,37,12) = (/ &
     &1.7141e+04_r8,1.2856e+04_r8,8.5707e+03_r8,4.2857e+03_r8,1.8420e+01_r8/)
      kbo(:, 4,37,12) = (/ &
     &1.8985e+04_r8,1.4239e+04_r8,9.4928e+03_r8,4.7467e+03_r8,1.7805e+01_r8/)
      kbo(:, 5,37,12) = (/ &
     &2.0966e+04_r8,1.5724e+04_r8,1.0483e+04_r8,5.2419e+03_r8,1.7343e+01_r8/)
      kbo(:, 1,38,12) = (/ &
     &1.4936e+04_r8,1.1202e+04_r8,7.4684e+03_r8,3.7346e+03_r8,1.9067e+01_r8/)
      kbo(:, 2,38,12) = (/ &
     &1.6693e+04_r8,1.2520e+04_r8,8.3467e+03_r8,4.1737e+03_r8,1.8968e+01_r8/)
      kbo(:, 3,38,12) = (/ &
     &1.8667e+04_r8,1.4000e+04_r8,9.3337e+03_r8,4.6672e+03_r8,1.8667e+01_r8/)
      kbo(:, 4,38,12) = (/ &
     &2.0838e+04_r8,1.5628e+04_r8,1.0419e+04_r8,5.2098e+03_r8,1.8090e+01_r8/)
      kbo(:, 5,38,12) = (/ &
     &2.3152e+04_r8,1.7364e+04_r8,1.1576e+04_r8,5.7883e+03_r8,1.7634e+01_r8/)
      kbo(:, 1,39,12) = (/ &
     &1.6411e+04_r8,1.2309e+04_r8,8.2062e+03_r8,4.1035e+03_r8,1.9362e+01_r8/)
      kbo(:, 2,39,12) = (/ &
     &1.8520e+04_r8,1.3890e+04_r8,9.2603e+03_r8,4.6305e+03_r8,1.9256e+01_r8/)
      kbo(:, 3,39,12) = (/ &
     &2.0878e+04_r8,1.5659e+04_r8,1.0439e+04_r8,5.2200e+03_r8,1.8842e+01_r8/)
      kbo(:, 4,39,12) = (/ &
     &2.3481e+04_r8,1.7611e+04_r8,1.1741e+04_r8,5.8709e+03_r8,1.8427e+01_r8/)
      kbo(:, 5,39,12) = (/ &
     &2.6258e+04_r8,1.9693e+04_r8,1.3129e+04_r8,6.5649e+03_r8,1.8005e+01_r8/)
      kbo(:, 1,40,12) = (/ &
     &1.6779e+04_r8,1.2584e+04_r8,8.3898e+03_r8,4.1952e+03_r8,1.9573e+01_r8/)
      kbo(:, 2,40,12) = (/ &
     &1.9118e+04_r8,1.4339e+04_r8,9.5593e+03_r8,4.7800e+03_r8,1.9496e+01_r8/)
      kbo(:, 3,40,12) = (/ &
     &2.1747e+04_r8,1.6310e+04_r8,1.0874e+04_r8,5.4372e+03_r8,1.9078e+01_r8/)
      kbo(:, 4,40,12) = (/ &
     &2.4641e+04_r8,1.8481e+04_r8,1.2321e+04_r8,6.1605e+03_r8,1.8680e+01_r8/)
      kbo(:, 5,40,12) = (/ &
     &2.7741e+04_r8,2.0806e+04_r8,1.3871e+04_r8,6.9356e+03_r8,1.8305e+01_r8/)
      kbo(:, 1,41,12) = (/ &
     &1.7108e+04_r8,1.2831e+04_r8,8.5543e+03_r8,4.2775e+03_r8,1.9752e+01_r8/)
      kbo(:, 2,41,12) = (/ &
     &1.9696e+04_r8,1.4772e+04_r8,9.8483e+03_r8,4.9245e+03_r8,1.9665e+01_r8/)
      kbo(:, 3,41,12) = (/ &
     &2.2603e+04_r8,1.6953e+04_r8,1.1302e+04_r8,5.6514e+03_r8,1.9347e+01_r8/)
      kbo(:, 4,41,12) = (/ &
     &2.5797e+04_r8,1.9348e+04_r8,1.2899e+04_r8,6.4497e+03_r8,1.8925e+01_r8/)
      kbo(:, 5,41,12) = (/ &
     &2.9237e+04_r8,2.1928e+04_r8,1.4619e+04_r8,7.3098e+03_r8,1.8587e+01_r8/)
      kbo(:, 1,42,12) = (/ &
     &1.7650e+04_r8,1.3238e+04_r8,8.8253e+03_r8,4.4130e+03_r8,1.9913e+01_r8/)
      kbo(:, 2,42,12) = (/ &
     &2.0552e+04_r8,1.5414e+04_r8,1.0276e+04_r8,5.1385e+03_r8,1.9817e+01_r8/)
      kbo(:, 3,42,12) = (/ &
     &2.3780e+04_r8,1.7835e+04_r8,1.1890e+04_r8,5.9455e+03_r8,1.9487e+01_r8/)
      kbo(:, 4,42,12) = (/ &
     &2.7331e+04_r8,2.0498e+04_r8,1.3666e+04_r8,6.8331e+03_r8,1.9141e+01_r8/)
      kbo(:, 5,42,12) = (/ &
     &3.1174e+04_r8,2.3380e+04_r8,1.5587e+04_r8,7.7938e+03_r8,1.8842e+01_r8/)
      kbo(:, 1,43,12) = (/ &
     &1.8226e+04_r8,1.3670e+04_r8,9.1135e+03_r8,4.5571e+03_r8,2.0107e+01_r8/)
      kbo(:, 2,43,12) = (/ &
     &2.1466e+04_r8,1.6100e+04_r8,1.0734e+04_r8,5.3672e+03_r8,1.9969e+01_r8/)
      kbo(:, 3,43,12) = (/ &
     &2.5067e+04_r8,1.8800e+04_r8,1.2534e+04_r8,6.2672e+03_r8,1.9715e+01_r8/)
      kbo(:, 4,43,12) = (/ &
     &2.9022e+04_r8,2.1767e+04_r8,1.4512e+04_r8,7.2561e+03_r8,1.9331e+01_r8/)
      kbo(:, 5,43,12) = (/ &
     &3.3314e+04_r8,2.4986e+04_r8,1.6658e+04_r8,8.3291e+03_r8,1.9158e+01_r8/)
      kbo(:, 1,44,12) = (/ &
     &1.9005e+04_r8,1.4254e+04_r8,9.5029e+03_r8,4.7518e+03_r8,2.0271e+01_r8/)
      kbo(:, 2,44,12) = (/ &
     &2.2627e+04_r8,1.6970e+04_r8,1.1314e+04_r8,5.6570e+03_r8,2.0045e+01_r8/)
      kbo(:, 3,44,12) = (/ &
     &2.6689e+04_r8,2.0017e+04_r8,1.3345e+04_r8,6.6725e+03_r8,1.9909e+01_r8/)
      kbo(:, 4,44,12) = (/ &
     &3.1132e+04_r8,2.3349e+04_r8,1.5566e+04_r8,7.7832e+03_r8,1.9596e+01_r8/)
      kbo(:, 5,44,12) = (/ &
     &3.5955e+04_r8,2.6966e+04_r8,1.7978e+04_r8,8.9890e+03_r8,1.9454e+01_r8/)
      kbo(:, 1,45,12) = (/ &
     &2.0230e+04_r8,1.5173e+04_r8,1.0115e+04_r8,5.0580e+03_r8,2.0360e+01_r8/)
      kbo(:, 2,45,12) = (/ &
     &2.4315e+04_r8,1.8237e+04_r8,1.2158e+04_r8,6.0793e+03_r8,2.0061e+01_r8/)
      kbo(:, 3,45,12) = (/ &
     &2.8985e+04_r8,2.1739e+04_r8,1.4493e+04_r8,7.2467e+03_r8,2.0123e+01_r8/)
      kbo(:, 4,45,12) = (/ &
     &3.4069e+04_r8,2.5552e+04_r8,1.7035e+04_r8,8.5176e+03_r8,1.9825e+01_r8/)
      kbo(:, 5,45,12) = (/ &
     &3.9583e+04_r8,2.9687e+04_r8,1.9792e+04_r8,9.8961e+03_r8,1.9819e+01_r8/)
      kbo(:, 1,46,12) = (/ &
     &2.1692e+04_r8,1.6269e+04_r8,1.0846e+04_r8,5.4233e+03_r8,2.0397e+01_r8/)
      kbo(:, 2,46,12) = (/ &
     &2.6275e+04_r8,1.9706e+04_r8,1.3138e+04_r8,6.5691e+03_r8,2.0140e+01_r8/)
      kbo(:, 3,46,12) = (/ &
     &3.1629e+04_r8,2.3722e+04_r8,1.5815e+04_r8,7.9076e+03_r8,2.0308e+01_r8/)
      kbo(:, 4,46,12) = (/ &
     &3.7518e+04_r8,2.8139e+04_r8,1.8759e+04_r8,9.3799e+03_r8,2.0045e+01_r8/)
      kbo(:, 5,46,12) = (/ &
     &4.3856e+04_r8,3.2892e+04_r8,2.1928e+04_r8,1.0964e+04_r8,2.0102e+01_r8/)
      kbo(:, 1,47,12) = (/ &
     &2.2886e+04_r8,1.7165e+04_r8,1.1443e+04_r8,5.7220e+03_r8,2.0376e+01_r8/)
      kbo(:, 2,47,12) = (/ &
     &2.7889e+04_r8,2.0917e+04_r8,1.3945e+04_r8,6.9727e+03_r8,2.0171e+01_r8/)
      kbo(:, 3,47,12) = (/ &
     &3.3867e+04_r8,2.5401e+04_r8,1.6934e+04_r8,8.4673e+03_r8,2.0409e+01_r8/)
      kbo(:, 4,47,12) = (/ &
     &4.0597e+04_r8,3.0448e+04_r8,2.0299e+04_r8,1.0150e+04_r8,2.0291e+01_r8/)
      kbo(:, 5,47,12) = (/ &
     &4.7822e+04_r8,3.5866e+04_r8,2.3911e+04_r8,1.1956e+04_r8,2.0384e+01_r8/)
      kbo(:, 1,48,12) = (/ &
     &2.4867e+04_r8,1.8651e+04_r8,1.2434e+04_r8,6.2173e+03_r8,2.0295e+01_r8/)
      kbo(:, 2,48,12) = (/ &
     &3.0432e+04_r8,2.2824e+04_r8,1.5216e+04_r8,7.6085e+03_r8,2.0270e+01_r8/)
      kbo(:, 3,48,12) = (/ &
     &3.7235e+04_r8,2.7926e+04_r8,1.8618e+04_r8,9.3091e+03_r8,2.0484e+01_r8/)
      kbo(:, 4,48,12) = (/ &
     &4.5063e+04_r8,3.3797e+04_r8,2.2532e+04_r8,1.1266e+04_r8,2.0580e+01_r8/)
      kbo(:, 5,48,12) = (/ &
     &5.3530e+04_r8,4.0148e+04_r8,2.6765e+04_r8,1.3383e+04_r8,2.0621e+01_r8/)
      kbo(:, 1,49,12) = (/ &
     &2.8095e+04_r8,2.1071e+04_r8,1.4048e+04_r8,7.0242e+03_r8,2.0197e+01_r8/)
      kbo(:, 2,49,12) = (/ &
     &3.4618e+04_r8,2.5963e+04_r8,1.7309e+04_r8,8.6547e+03_r8,2.0319e+01_r8/)
      kbo(:, 3,49,12) = (/ &
     &4.2591e+04_r8,3.1943e+04_r8,2.1296e+04_r8,1.0648e+04_r8,2.0559e+01_r8/)
      kbo(:, 4,49,12) = (/ &
     &5.1945e+04_r8,3.8959e+04_r8,2.5973e+04_r8,1.2987e+04_r8,2.0853e+01_r8/)
      kbo(:, 5,49,12) = (/ &
     &6.2325e+04_r8,4.6744e+04_r8,3.1163e+04_r8,1.5581e+04_r8,2.0890e+01_r8/)
      kbo(:, 1,50,12) = (/ &
     &3.0354e+04_r8,2.2766e+04_r8,1.5178e+04_r8,7.5891e+03_r8,2.0062e+01_r8/)
      kbo(:, 2,50,12) = (/ &
     &3.7734e+04_r8,2.8300e+04_r8,1.8867e+04_r8,9.4338e+03_r8,2.0363e+01_r8/)
      kbo(:, 3,50,12) = (/ &
     &4.6589e+04_r8,3.4942e+04_r8,2.3295e+04_r8,1.1648e+04_r8,2.0543e+01_r8/)
      kbo(:, 4,50,12) = (/ &
     &5.7214e+04_r8,4.2910e+04_r8,2.8607e+04_r8,1.4304e+04_r8,2.0993e+01_r8/)
      kbo(:, 5,50,12) = (/ &
     &6.9238e+04_r8,5.1929e+04_r8,3.4619e+04_r8,1.7310e+04_r8,2.1035e+01_r8/)
      kbo(:, 1,51,12) = (/ &
     &3.2115e+04_r8,2.4086e+04_r8,1.6058e+04_r8,8.0292e+03_r8,1.9809e+01_r8/)
      kbo(:, 2,51,12) = (/ &
     &4.0277e+04_r8,3.0208e+04_r8,2.0139e+04_r8,1.0070e+04_r8,2.0313e+01_r8/)
      kbo(:, 3,51,12) = (/ &
     &4.9958e+04_r8,3.7469e+04_r8,2.4979e+04_r8,1.2490e+04_r8,2.0455e+01_r8/)
      kbo(:, 4,51,12) = (/ &
     &6.1681e+04_r8,4.6261e+04_r8,3.0841e+04_r8,1.5421e+04_r8,2.0964e+01_r8/)
      kbo(:, 5,51,12) = (/ &
     &7.5206e+04_r8,5.6405e+04_r8,3.7603e+04_r8,1.8802e+04_r8,2.1060e+01_r8/)
      kbo(:, 1,52,12) = (/ &
     &3.4912e+04_r8,2.6184e+04_r8,1.7456e+04_r8,8.7285e+03_r8,1.9582e+01_r8/)
      kbo(:, 2,52,12) = (/ &
     &4.4146e+04_r8,3.3110e+04_r8,2.2073e+04_r8,1.1037e+04_r8,2.0163e+01_r8/)
      kbo(:, 3,52,12) = (/ &
     &5.5147e+04_r8,4.1361e+04_r8,2.7574e+04_r8,1.3787e+04_r8,2.0386e+01_r8/)
      kbo(:, 4,52,12) = (/ &
     &6.8326e+04_r8,5.1245e+04_r8,3.4163e+04_r8,1.7082e+04_r8,2.0999e+01_r8/)
      kbo(:, 5,52,12) = (/ &
     &8.3853e+04_r8,6.2890e+04_r8,4.1927e+04_r8,2.0964e+04_r8,2.1183e+01_r8/)
      kbo(:, 1,53,12) = (/ &
     &3.9402e+04_r8,2.9552e+04_r8,1.9702e+04_r8,9.8513e+03_r8,1.9267e+01_r8/)
      kbo(:, 2,53,12) = (/ &
     &5.0308e+04_r8,3.7732e+04_r8,2.5155e+04_r8,1.2578e+04_r8,1.9908e+01_r8/)
      kbo(:, 3,53,12) = (/ &
     &6.3383e+04_r8,4.7538e+04_r8,3.1692e+04_r8,1.5846e+04_r8,2.0279e+01_r8/)
      kbo(:, 4,53,12) = (/ &
     &7.8778e+04_r8,5.9084e+04_r8,3.9389e+04_r8,1.9695e+04_r8,2.1039e+01_r8/)
      kbo(:, 5,53,12) = (/ &
     &9.7229e+04_r8,7.2923e+04_r8,4.8615e+04_r8,2.4308e+04_r8,2.1293e+01_r8/)
      kbo(:, 1,54,12) = (/ &
     &3.8624e+04_r8,2.8968e+04_r8,1.9312e+04_r8,9.6566e+03_r8,1.8946e+01_r8/)
      kbo(:, 2,54,12) = (/ &
     &4.9869e+04_r8,3.7402e+04_r8,2.4935e+04_r8,1.2468e+04_r8,1.9724e+01_r8/)
      kbo(:, 3,54,12) = (/ &
     &6.3267e+04_r8,4.7450e+04_r8,3.1634e+04_r8,1.5817e+04_r8,2.0221e+01_r8/)
      kbo(:, 4,54,12) = (/ &
     &7.9005e+04_r8,5.9254e+04_r8,3.9503e+04_r8,1.9752e+04_r8,2.0891e+01_r8/)
      kbo(:, 5,54,12) = (/ &
     &9.7899e+04_r8,7.3425e+04_r8,4.8950e+04_r8,2.4475e+04_r8,2.1235e+01_r8/)
      kbo(:, 1,55,12) = (/ &
     &3.4504e+04_r8,2.5878e+04_r8,1.7253e+04_r8,8.6267e+03_r8,1.8561e+01_r8/)
      kbo(:, 2,55,12) = (/ &
     &4.5154e+04_r8,3.3866e+04_r8,2.2578e+04_r8,1.1289e+04_r8,1.9514e+01_r8/)
      kbo(:, 3,55,12) = (/ &
     &5.7700e+04_r8,4.3275e+04_r8,2.8850e+04_r8,1.4425e+04_r8,2.0143e+01_r8/)
      kbo(:, 4,55,12) = (/ &
     &7.2513e+04_r8,5.4385e+04_r8,3.6257e+04_r8,1.8129e+04_r8,2.0526e+01_r8/)
      kbo(:, 5,55,12) = (/ &
     &9.0097e+04_r8,6.7573e+04_r8,4.5049e+04_r8,2.2525e+04_r8,2.1145e+01_r8/)
      kbo(:, 1,56,12) = (/ &
     &3.0670e+04_r8,2.3003e+04_r8,1.5335e+04_r8,7.6681e+03_r8,1.8208e+01_r8/)
      kbo(:, 2,56,12) = (/ &
     &4.0775e+04_r8,3.0581e+04_r8,2.0388e+04_r8,1.0194e+04_r8,1.9345e+01_r8/)
      kbo(:, 3,56,12) = (/ &
     &5.2534e+04_r8,3.9401e+04_r8,2.6267e+04_r8,1.3134e+04_r8,1.9986e+01_r8/)
      kbo(:, 4,56,12) = (/ &
     &6.6490e+04_r8,4.9868e+04_r8,3.3245e+04_r8,1.6623e+04_r8,2.0300e+01_r8/)
      kbo(:, 5,56,12) = (/ &
     &8.2863e+04_r8,6.2147e+04_r8,4.1431e+04_r8,2.0716e+04_r8,2.0929e+01_r8/)
      kbo(:, 1,57,12) = (/ &
     &2.7134e+04_r8,2.0351e+04_r8,1.3567e+04_r8,6.7841e+03_r8,1.7766e+01_r8/)
      kbo(:, 2,57,12) = (/ &
     &3.6730e+04_r8,2.7547e+04_r8,1.8365e+04_r8,9.1827e+03_r8,1.8983e+01_r8/)
      kbo(:, 3,57,12) = (/ &
     &4.7798e+04_r8,3.5848e+04_r8,2.3899e+04_r8,1.1950e+04_r8,1.9837e+01_r8/)
      kbo(:, 4,57,12) = (/ &
     &6.0858e+04_r8,4.5644e+04_r8,3.0429e+04_r8,1.5215e+04_r8,2.0288e+01_r8/)
      kbo(:, 5,57,12) = (/ &
     &7.6170e+04_r8,5.7127e+04_r8,3.8085e+04_r8,1.9043e+04_r8,2.0539e+01_r8/)
      kbo(:, 1,58,12) = (/ &
     &6.3468e+03_r8,5.8191e+03_r8,4.9895e+03_r8,3.4949e+03_r8,1.7351e+01_r8/)
      kbo(:, 2,58,12) = (/ &
     &8.7238e+03_r8,7.9984e+03_r8,6.8580e+03_r8,4.8035e+03_r8,1.8673e+01_r8/)
      kbo(:, 3,58,12) = (/ &
     &1.1493e+04_r8,1.0537e+04_r8,9.0349e+03_r8,6.3281e+03_r8,1.9708e+01_r8/)
      kbo(:, 4,58,12) = (/ &
     &1.4729e+04_r8,1.3504e+04_r8,1.1579e+04_r8,8.1099e+03_r8,2.0210e+01_r8/)
      kbo(:, 5,58,12) = (/ &
     &1.8531e+04_r8,1.6990e+04_r8,1.4568e+04_r8,1.0203e+04_r8,2.0346e+01_r8/)
      kbo(:, 1,59,12) = (/ &
     &7.0593e+03_r8,6.1640e+03_r8,4.9170e+03_r8,3.0600e+03_r8,1.7147e+01_r8/)
      kbo(:, 2,59,12) = (/ &
     &9.7799e+03_r8,8.5396e+03_r8,6.8118e+03_r8,4.2390e+03_r8,1.8584e+01_r8/)
      kbo(:, 3,59,12) = (/ &
     &1.2964e+04_r8,1.1320e+04_r8,9.0293e+03_r8,5.6188e+03_r8,1.9434e+01_r8/)
      kbo(:, 4,59,12) = (/ &
     &1.6671e+04_r8,1.4556e+04_r8,1.1611e+04_r8,7.2253e+03_r8,2.0175e+01_r8/)
      kbo(:, 5,59,12) = (/ &
     &2.1035e+04_r8,1.8367e+04_r8,1.4651e+04_r8,9.1168e+03_r8,2.0516e+01_r8/)
      kbo(:, 1,13,13) = (/ &
     &3.8843e+05_r8,2.9132e+05_r8,1.9422e+05_r8,9.7109e+04_r8,5.4111e+00_r8/)
      kbo(:, 2,13,13) = (/ &
     &3.8116e+05_r8,2.8587e+05_r8,1.9058e+05_r8,9.5291e+04_r8,5.1021e+00_r8/)
      kbo(:, 3,13,13) = (/ &
     &3.7364e+05_r8,2.8023e+05_r8,1.8682e+05_r8,9.3410e+04_r8,4.8974e+00_r8/)
      kbo(:, 4,13,13) = (/ &
     &3.6551e+05_r8,2.7413e+05_r8,1.8276e+05_r8,9.1378e+04_r8,4.4934e+00_r8/)
      kbo(:, 5,13,13) = (/ &
     &3.5750e+05_r8,2.6813e+05_r8,1.7875e+05_r8,8.9377e+04_r8,3.9773e+00_r8/)
      kbo(:, 1,14,13) = (/ &
     &2.5525e+05_r8,1.9143e+05_r8,1.2762e+05_r8,6.3811e+04_r8,5.8071e+00_r8/)
      kbo(:, 2,14,13) = (/ &
     &2.5096e+05_r8,1.8822e+05_r8,1.2548e+05_r8,6.2740e+04_r8,5.6102e+00_r8/)
      kbo(:, 3,14,13) = (/ &
     &2.4685e+05_r8,1.8514e+05_r8,1.2343e+05_r8,6.1713e+04_r8,5.4048e+00_r8/)
      kbo(:, 4,14,13) = (/ &
     &2.4253e+05_r8,1.8190e+05_r8,1.2126e+05_r8,6.0632e+04_r8,5.2557e+00_r8/)
      kbo(:, 5,14,13) = (/ &
     &2.3845e+05_r8,1.7884e+05_r8,1.1922e+05_r8,5.9612e+04_r8,4.9044e+00_r8/)
      kbo(:, 1,15,13) = (/ &
     &1.7262e+05_r8,1.2947e+05_r8,8.6313e+04_r8,4.3157e+04_r8,6.3397e+00_r8/)
      kbo(:, 2,15,13) = (/ &
     &1.7029e+05_r8,1.2772e+05_r8,8.5146e+04_r8,4.2574e+04_r8,6.1559e+00_r8/)
      kbo(:, 3,15,13) = (/ &
     &1.6778e+05_r8,1.2583e+05_r8,8.3891e+04_r8,4.1946e+04_r8,5.9275e+00_r8/)
      kbo(:, 4,15,13) = (/ &
     &1.6564e+05_r8,1.2423e+05_r8,8.2824e+04_r8,4.1413e+04_r8,5.8142e+00_r8/)
      kbo(:, 5,15,13) = (/ &
     &1.6363e+05_r8,1.2273e+05_r8,8.1819e+04_r8,4.0910e+04_r8,5.6466e+00_r8/)
      kbo(:, 1,16,13) = (/ &
     &1.3945e+05_r8,1.0459e+05_r8,6.9724e+04_r8,3.4863e+04_r8,7.0725e+00_r8/)
      kbo(:, 2,16,13) = (/ &
     &1.3799e+05_r8,1.0349e+05_r8,6.8996e+04_r8,3.4499e+04_r8,6.9039e+00_r8/)
      kbo(:, 3,16,13) = (/ &
     &1.3667e+05_r8,1.0250e+05_r8,6.8336e+04_r8,3.4169e+04_r8,6.6526e+00_r8/)
      kbo(:, 4,16,13) = (/ &
     &1.3532e+05_r8,1.0149e+05_r8,6.7659e+04_r8,3.3830e+04_r8,6.5506e+00_r8/)
      kbo(:, 5,16,13) = (/ &
     &1.3401e+05_r8,1.0051e+05_r8,6.7008e+04_r8,3.3505e+04_r8,6.3946e+00_r8/)
      kbo(:, 1,17,13) = (/ &
     &1.1728e+05_r8,8.7962e+04_r8,5.8642e+04_r8,2.9322e+04_r8,7.9743e+00_r8/)
      kbo(:, 2,17,13) = (/ &
     &1.1635e+05_r8,8.7266e+04_r8,5.8178e+04_r8,2.9090e+04_r8,7.7873e+00_r8/)
      kbo(:, 3,17,13) = (/ &
     &1.1534e+05_r8,8.6504e+04_r8,5.7670e+04_r8,2.8835e+04_r8,7.5449e+00_r8/)
      kbo(:, 4,17,13) = (/ &
     &1.1432e+05_r8,8.5738e+04_r8,5.7159e+04_r8,2.8580e+04_r8,7.3894e+00_r8/)
      kbo(:, 5,17,13) = (/ &
     &1.1312e+05_r8,8.4838e+04_r8,5.6559e+04_r8,2.8280e+04_r8,7.2243e+00_r8/)
      kbo(:, 1,18,13) = (/ &
     &1.0020e+05_r8,7.5148e+04_r8,5.0099e+04_r8,2.5050e+04_r8,8.9803e+00_r8/)
      kbo(:, 2,18,13) = (/ &
     &9.9423e+04_r8,7.4567e+04_r8,4.9712e+04_r8,2.4856e+04_r8,8.7551e+00_r8/)
      kbo(:, 3,18,13) = (/ &
     &9.8635e+04_r8,7.3977e+04_r8,4.9318e+04_r8,2.4660e+04_r8,8.5049e+00_r8/)
      kbo(:, 4,18,13) = (/ &
     &9.7679e+04_r8,7.3260e+04_r8,4.8840e+04_r8,2.4421e+04_r8,8.3083e+00_r8/)
      kbo(:, 5,18,13) = (/ &
     &9.6616e+04_r8,7.2462e+04_r8,4.8308e+04_r8,2.4155e+04_r8,8.1253e+00_r8/)
      kbo(:, 1,19,13) = (/ &
     &8.3124e+04_r8,6.2343e+04_r8,4.1562e+04_r8,2.0782e+04_r8,1.0036e+01_r8/)
      kbo(:, 2,19,13) = (/ &
     &8.2434e+04_r8,6.1826e+04_r8,4.1217e+04_r8,2.0609e+04_r8,9.7882e+00_r8/)
      kbo(:, 3,19,13) = (/ &
     &8.1692e+04_r8,6.1269e+04_r8,4.0847e+04_r8,2.0424e+04_r8,9.5505e+00_r8/)
      kbo(:, 4,19,13) = (/ &
     &8.0821e+04_r8,6.0616e+04_r8,4.0411e+04_r8,2.0206e+04_r8,9.2995e+00_r8/)
      kbo(:, 5,19,13) = (/ &
     &7.9844e+04_r8,5.9883e+04_r8,3.9922e+04_r8,1.9962e+04_r8,9.1204e+00_r8/)
      kbo(:, 1,20,13) = (/ &
     &7.3434e+04_r8,5.5076e+04_r8,3.6717e+04_r8,1.8359e+04_r8,1.1173e+01_r8/)
      kbo(:, 2,20,13) = (/ &
     &7.2781e+04_r8,5.4586e+04_r8,3.6391e+04_r8,1.8196e+04_r8,1.0919e+01_r8/)
      kbo(:, 3,20,13) = (/ &
     &7.2073e+04_r8,5.4055e+04_r8,3.6037e+04_r8,1.8019e+04_r8,1.0676e+01_r8/)
      kbo(:, 4,20,13) = (/ &
     &7.1226e+04_r8,5.3419e+04_r8,3.5613e+04_r8,1.7807e+04_r8,1.0406e+01_r8/)
      kbo(:, 5,20,13) = (/ &
     &7.0326e+04_r8,5.2745e+04_r8,3.5164e+04_r8,1.7582e+04_r8,1.0205e+01_r8/)
      kbo(:, 1,21,13) = (/ &
     &6.5684e+04_r8,4.9263e+04_r8,3.2843e+04_r8,1.6422e+04_r8,1.2437e+01_r8/)
      kbo(:, 2,21,13) = (/ &
     &6.5060e+04_r8,4.8795e+04_r8,3.2531e+04_r8,1.6266e+04_r8,1.2175e+01_r8/)
      kbo(:, 3,21,13) = (/ &
     &6.4347e+04_r8,4.8261e+04_r8,3.2174e+04_r8,1.6088e+04_r8,1.1913e+01_r8/)
      kbo(:, 4,21,13) = (/ &
     &6.3551e+04_r8,4.7664e+04_r8,3.1776e+04_r8,1.5889e+04_r8,1.1602e+01_r8/)
      kbo(:, 5,21,13) = (/ &
     &6.2699e+04_r8,4.7025e+04_r8,3.1350e+04_r8,1.5676e+04_r8,1.1366e+01_r8/)
      kbo(:, 1,22,13) = (/ &
     &5.8992e+04_r8,4.4244e+04_r8,2.9497e+04_r8,1.4749e+04_r8,1.3817e+01_r8/)
      kbo(:, 2,22,13) = (/ &
     &5.8377e+04_r8,4.3783e+04_r8,2.9189e+04_r8,1.4595e+04_r8,1.3522e+01_r8/)
      kbo(:, 3,22,13) = (/ &
     &5.7726e+04_r8,4.3295e+04_r8,2.8863e+04_r8,1.4432e+04_r8,1.3217e+01_r8/)
      kbo(:, 4,22,13) = (/ &
     &5.7003e+04_r8,4.2753e+04_r8,2.8502e+04_r8,1.4252e+04_r8,1.2864e+01_r8/)
      kbo(:, 5,22,13) = (/ &
     &5.6242e+04_r8,4.2182e+04_r8,2.8121e+04_r8,1.4061e+04_r8,1.2581e+01_r8/)
      kbo(:, 1,23,13) = (/ &
     &5.2234e+04_r8,3.9176e+04_r8,2.6118e+04_r8,1.3059e+04_r8,1.5301e+01_r8/)
      kbo(:, 2,23,13) = (/ &
     &5.1719e+04_r8,3.8789e+04_r8,2.5860e+04_r8,1.2931e+04_r8,1.4943e+01_r8/)
      kbo(:, 3,23,13) = (/ &
     &5.1144e+04_r8,3.8358e+04_r8,2.5572e+04_r8,1.2787e+04_r8,1.4585e+01_r8/)
      kbo(:, 4,23,13) = (/ &
     &5.0530e+04_r8,3.7898e+04_r8,2.5266e+04_r8,1.2633e+04_r8,1.4170e+01_r8/)
      kbo(:, 5,23,13) = (/ &
     &4.9854e+04_r8,3.7391e+04_r8,2.4928e+04_r8,1.2464e+04_r8,1.3822e+01_r8/)
      kbo(:, 1,24,13) = (/ &
     &4.5231e+04_r8,3.3923e+04_r8,2.2616e+04_r8,1.1309e+04_r8,1.6829e+01_r8/)
      kbo(:, 2,24,13) = (/ &
     &4.4807e+04_r8,3.3606e+04_r8,2.2404e+04_r8,1.1203e+04_r8,1.6434e+01_r8/)
      kbo(:, 3,24,13) = (/ &
     &4.4319e+04_r8,3.3240e+04_r8,2.2160e+04_r8,1.1081e+04_r8,1.5981e+01_r8/)
      kbo(:, 4,24,13) = (/ &
     &4.3813e+04_r8,3.2860e+04_r8,2.1907e+04_r8,1.0954e+04_r8,1.5519e+01_r8/)
      kbo(:, 5,24,13) = (/ &
     &4.3229e+04_r8,3.2422e+04_r8,2.1615e+04_r8,1.0808e+04_r8,1.5118e+01_r8/)
      kbo(:, 1,25,13) = (/ &
     &3.9084e+04_r8,2.9314e+04_r8,1.9543e+04_r8,9.7719e+03_r8,1.8397e+01_r8/)
      kbo(:, 2,25,13) = (/ &
     &3.8734e+04_r8,2.9050e+04_r8,1.9367e+04_r8,9.6842e+03_r8,1.7930e+01_r8/)
      kbo(:, 3,25,13) = (/ &
     &3.8359e+04_r8,2.8770e+04_r8,1.9180e+04_r8,9.5907e+03_r8,1.7387e+01_r8/)
      kbo(:, 4,25,13) = (/ &
     &3.7930e+04_r8,2.8448e+04_r8,1.8965e+04_r8,9.4832e+03_r8,1.6873e+01_r8/)
      kbo(:, 5,25,13) = (/ &
     &3.7467e+04_r8,2.8100e+04_r8,1.8734e+04_r8,9.3675e+03_r8,1.6400e+01_r8/)
      kbo(:, 1,26,13) = (/ &
     &3.3890e+04_r8,2.5418e+04_r8,1.6946e+04_r8,8.4734e+03_r8,1.9920e+01_r8/)
      kbo(:, 2,26,13) = (/ &
     &3.3621e+04_r8,2.5216e+04_r8,1.6811e+04_r8,8.4060e+03_r8,1.9382e+01_r8/)
      kbo(:, 3,26,13) = (/ &
     &3.3332e+04_r8,2.4999e+04_r8,1.6667e+04_r8,8.3338e+03_r8,1.8740e+01_r8/)
      kbo(:, 4,26,13) = (/ &
     &3.3002e+04_r8,2.4752e+04_r8,1.6501e+04_r8,8.2512e+03_r8,1.8176e+01_r8/)
      kbo(:, 5,26,13) = (/ &
     &3.2656e+04_r8,2.4492e+04_r8,1.6328e+04_r8,8.1646e+03_r8,1.7620e+01_r8/)
      kbo(:, 1,27,13) = (/ &
     &3.0166e+04_r8,2.2624e+04_r8,1.5083e+04_r8,7.5423e+03_r8,2.1376e+01_r8/)
      kbo(:, 2,27,13) = (/ &
     &2.9996e+04_r8,2.2497e+04_r8,1.4998e+04_r8,7.4998e+03_r8,2.0763e+01_r8/)
      kbo(:, 3,27,13) = (/ &
     &2.9787e+04_r8,2.2341e+04_r8,1.4894e+04_r8,7.4476e+03_r8,2.0015e+01_r8/)
      kbo(:, 4,27,13) = (/ &
     &2.9581e+04_r8,2.2186e+04_r8,1.4791e+04_r8,7.3962e+03_r8,1.9407e+01_r8/)
      kbo(:, 5,27,13) = (/ &
     &2.9406e+04_r8,2.2055e+04_r8,1.4703e+04_r8,7.3522e+03_r8,1.8770e+01_r8/)
      kbo(:, 1,28,13) = (/ &
     &2.7326e+04_r8,2.0495e+04_r8,1.3664e+04_r8,6.8324e+03_r8,2.2732e+01_r8/)
      kbo(:, 2,28,13) = (/ &
     &2.7236e+04_r8,2.0428e+04_r8,1.3619e+04_r8,6.8100e+03_r8,2.2041e+01_r8/)
      kbo(:, 3,28,13) = (/ &
     &2.7174e+04_r8,2.0381e+04_r8,1.3588e+04_r8,6.7945e+03_r8,2.1170e+01_r8/)
      kbo(:, 4,28,13) = (/ &
     &2.7191e+04_r8,2.0394e+04_r8,1.3596e+04_r8,6.7985e+03_r8,2.0533e+01_r8/)
      kbo(:, 5,28,13) = (/ &
     &2.7306e+04_r8,2.0480e+04_r8,1.3654e+04_r8,6.8273e+03_r8,1.9803e+01_r8/)
      kbo(:, 1,29,13) = (/ &
     &2.6107e+04_r8,1.9580e+04_r8,1.3054e+04_r8,6.5276e+03_r8,2.3952e+01_r8/)
      kbo(:, 2,29,13) = (/ &
     &2.6178e+04_r8,1.9634e+04_r8,1.3090e+04_r8,6.5453e+03_r8,2.3128e+01_r8/)
      kbo(:, 3,29,13) = (/ &
     &2.6373e+04_r8,1.9780e+04_r8,1.3187e+04_r8,6.5941e+03_r8,2.2276e+01_r8/)
      kbo(:, 4,29,13) = (/ &
     &2.6674e+04_r8,2.0006e+04_r8,1.3338e+04_r8,6.6693e+03_r8,2.1526e+01_r8/)
      kbo(:, 5,29,13) = (/ &
     &2.7070e+04_r8,2.0303e+04_r8,1.3535e+04_r8,6.7681e+03_r8,2.0703e+01_r8/)
      kbo(:, 1,30,13) = (/ &
     &2.5565e+04_r8,1.9174e+04_r8,1.2783e+04_r8,6.3921e+03_r8,2.5015e+01_r8/)
      kbo(:, 2,30,13) = (/ &
     &2.5924e+04_r8,1.9443e+04_r8,1.2962e+04_r8,6.4818e+03_r8,2.4026e+01_r8/)
      kbo(:, 3,30,13) = (/ &
     &2.6425e+04_r8,1.9819e+04_r8,1.3213e+04_r8,6.6070e+03_r8,2.3238e+01_r8/)
      kbo(:, 4,30,13) = (/ &
     &2.7081e+04_r8,2.0311e+04_r8,1.3541e+04_r8,6.7710e+03_r8,2.2369e+01_r8/)
      kbo(:, 5,30,13) = (/ &
     &2.7860e+04_r8,2.0896e+04_r8,1.3931e+04_r8,6.9658e+03_r8,2.1263e+01_r8/)
      kbo(:, 1,31,13) = (/ &
     &2.6519e+04_r8,1.9890e+04_r8,1.3260e+04_r8,6.6306e+03_r8,2.5829e+01_r8/)
      kbo(:, 2,31,13) = (/ &
     &2.7266e+04_r8,2.0450e+04_r8,1.3634e+04_r8,6.8173e+03_r8,2.4917e+01_r8/)
      kbo(:, 3,31,13) = (/ &
     &2.8229e+04_r8,2.1172e+04_r8,1.4115e+04_r8,7.0579e+03_r8,2.4029e+01_r8/)
      kbo(:, 4,31,13) = (/ &
     &2.9353e+04_r8,2.2015e+04_r8,1.4677e+04_r8,7.3390e+03_r8,2.2989e+01_r8/)
      kbo(:, 5,31,13) = (/ &
     &3.0590e+04_r8,2.2943e+04_r8,1.5295e+04_r8,7.6481e+03_r8,2.1638e+01_r8/)
      kbo(:, 1,32,13) = (/ &
     &2.8188e+04_r8,2.1141e+04_r8,1.4095e+04_r8,7.0478e+03_r8,2.6468e+01_r8/)
      kbo(:, 2,32,13) = (/ &
     &2.9479e+04_r8,2.2110e+04_r8,1.4740e+04_r8,7.3705e+03_r8,2.5641e+01_r8/)
      kbo(:, 3,32,13) = (/ &
     &3.0998e+04_r8,2.3249e+04_r8,1.5500e+04_r8,7.7503e+03_r8,2.4646e+01_r8/)
      kbo(:, 4,32,13) = (/ &
     &3.2677e+04_r8,2.4508e+04_r8,1.6339e+04_r8,8.1700e+03_r8,2.3083e+01_r8/)
      kbo(:, 5,32,13) = (/ &
     &3.4456e+04_r8,2.5842e+04_r8,1.7228e+04_r8,8.6146e+03_r8,2.1888e+01_r8/)
      kbo(:, 1,33,13) = (/ &
     &3.1038e+04_r8,2.3278e+04_r8,1.5519e+04_r8,7.7602e+03_r8,2.7208e+01_r8/)
      kbo(:, 2,33,13) = (/ &
     &3.2999e+04_r8,2.4749e+04_r8,1.6500e+04_r8,8.2505e+03_r8,2.6145e+01_r8/)
      kbo(:, 3,33,13) = (/ &
     &3.5228e+04_r8,2.6421e+04_r8,1.7614e+04_r8,8.8077e+03_r8,2.4544e+01_r8/)
      kbo(:, 4,33,13) = (/ &
     &3.7600e+04_r8,2.8200e+04_r8,1.8800e+04_r8,9.4007e+03_r8,2.3159e+01_r8/)
      kbo(:, 5,33,13) = (/ &
     &4.0073e+04_r8,3.0055e+04_r8,2.0037e+04_r8,1.0019e+04_r8,2.2387e+01_r8/)
      kbo(:, 1,34,13) = (/ &
     &3.3858e+04_r8,2.5394e+04_r8,1.6930e+04_r8,8.4653e+03_r8,2.7625e+01_r8/)
      kbo(:, 2,34,13) = (/ &
     &3.6566e+04_r8,2.7425e+04_r8,1.8284e+04_r8,9.1422e+03_r8,2.6243e+01_r8/)
      kbo(:, 3,34,13) = (/ &
     &3.9555e+04_r8,2.9666e+04_r8,1.9778e+04_r8,9.8893e+03_r8,2.4430e+01_r8/)
      kbo(:, 4,34,13) = (/ &
     &4.2704e+04_r8,3.2028e+04_r8,2.1352e+04_r8,1.0677e+04_r8,2.3679e+01_r8/)
      kbo(:, 5,34,13) = (/ &
     &4.5894e+04_r8,3.4420e+04_r8,2.2947e+04_r8,1.1474e+04_r8,2.2773e+01_r8/)
      kbo(:, 1,35,13) = (/ &
     &3.7312e+04_r8,2.7984e+04_r8,1.8657e+04_r8,9.3288e+03_r8,2.7942e+01_r8/)
      kbo(:, 2,35,13) = (/ &
     &4.0881e+04_r8,3.0661e+04_r8,2.0441e+04_r8,1.0221e+04_r8,2.6106e+01_r8/)
      kbo(:, 3,35,13) = (/ &
     &4.4738e+04_r8,3.3554e+04_r8,2.2369e+04_r8,1.1185e+04_r8,2.5080e+01_r8/)
      kbo(:, 4,35,13) = (/ &
     &4.8754e+04_r8,3.6566e+04_r8,2.4377e+04_r8,1.2189e+04_r8,2.4179e+01_r8/)
      kbo(:, 5,35,13) = (/ &
     &5.2762e+04_r8,3.9572e+04_r8,2.6381e+04_r8,1.3191e+04_r8,2.3224e+01_r8/)
      kbo(:, 1,36,13) = (/ &
     &4.0999e+04_r8,3.0749e+04_r8,2.0500e+04_r8,1.0250e+04_r8,2.8213e+01_r8/)
      kbo(:, 2,36,13) = (/ &
     &4.5493e+04_r8,3.4120e+04_r8,2.2747e+04_r8,1.1374e+04_r8,2.6516e+01_r8/)
      kbo(:, 3,36,13) = (/ &
     &5.0302e+04_r8,3.7726e+04_r8,2.5151e+04_r8,1.2576e+04_r8,2.5690e+01_r8/)
      kbo(:, 4,36,13) = (/ &
     &5.5257e+04_r8,4.1443e+04_r8,2.7629e+04_r8,1.3815e+04_r8,2.4819e+01_r8/)
      kbo(:, 5,36,13) = (/ &
     &6.0175e+04_r8,4.5131e+04_r8,3.0088e+04_r8,1.5044e+04_r8,2.3837e+01_r8/)
      kbo(:, 1,37,13) = (/ &
     &4.3597e+04_r8,3.2698e+04_r8,2.1799e+04_r8,1.0900e+04_r8,2.8678e+01_r8/)
      kbo(:, 2,37,13) = (/ &
     &4.8963e+04_r8,3.6723e+04_r8,2.4482e+04_r8,1.2241e+04_r8,2.7079e+01_r8/)
      kbo(:, 3,37,13) = (/ &
     &5.4655e+04_r8,4.0991e+04_r8,2.7328e+04_r8,1.3664e+04_r8,2.6274e+01_r8/)
      kbo(:, 4,37,13) = (/ &
     &6.0506e+04_r8,4.5380e+04_r8,3.0253e+04_r8,1.5127e+04_r8,2.5504e+01_r8/)
      kbo(:, 5,37,13) = (/ &
     &6.6353e+04_r8,4.9765e+04_r8,3.3177e+04_r8,1.6589e+04_r8,2.4385e+01_r8/)
      kbo(:, 1,38,13) = (/ &
     &4.7296e+04_r8,3.5472e+04_r8,2.3648e+04_r8,1.1825e+04_r8,2.9114e+01_r8/)
      kbo(:, 2,38,13) = (/ &
     &5.3691e+04_r8,4.0269e+04_r8,2.6846e+04_r8,1.3423e+04_r8,2.7730e+01_r8/)
      kbo(:, 3,38,13) = (/ &
     &6.0448e+04_r8,4.5336e+04_r8,3.0224e+04_r8,1.5113e+04_r8,2.6995e+01_r8/)
      kbo(:, 4,38,13) = (/ &
     &6.7408e+04_r8,5.0556e+04_r8,3.3704e+04_r8,1.6852e+04_r8,2.6164e+01_r8/)
      kbo(:, 5,38,13) = (/ &
     &7.4361e+04_r8,5.5771e+04_r8,3.7181e+04_r8,1.8591e+04_r8,2.5025e+01_r8/)
      kbo(:, 1,39,13) = (/ &
     &5.2787e+04_r8,3.9591e+04_r8,2.6394e+04_r8,1.3198e+04_r8,2.9543e+01_r8/)
      kbo(:, 2,39,13) = (/ &
     &6.0481e+04_r8,4.5362e+04_r8,3.0242e+04_r8,1.5121e+04_r8,2.8398e+01_r8/)
      kbo(:, 3,39,13) = (/ &
     &6.8644e+04_r8,5.1483e+04_r8,3.4323e+04_r8,1.7162e+04_r8,2.7686e+01_r8/)
      kbo(:, 4,39,13) = (/ &
     &7.7024e+04_r8,5.7768e+04_r8,3.8513e+04_r8,1.9257e+04_r8,2.6627e+01_r8/)
      kbo(:, 5,39,13) = (/ &
     &8.5404e+04_r8,6.4053e+04_r8,4.2703e+04_r8,2.1352e+04_r8,2.5499e+01_r8/)
      kbo(:, 1,40,13) = (/ &
     &5.4787e+04_r8,4.1090e+04_r8,2.7394e+04_r8,1.3697e+04_r8,3.0183e+01_r8/)
      kbo(:, 2,40,13) = (/ &
     &6.3323e+04_r8,4.7492e+04_r8,3.1662e+04_r8,1.5831e+04_r8,2.8961e+01_r8/)
      kbo(:, 3,40,13) = (/ &
     &7.2463e+04_r8,5.4348e+04_r8,3.6232e+04_r8,1.8116e+04_r8,2.8295e+01_r8/)
      kbo(:, 4,40,13) = (/ &
     &8.1867e+04_r8,6.1400e+04_r8,4.0933e+04_r8,2.0467e+04_r8,2.7184e+01_r8/)
      kbo(:, 5,40,13) = (/ &
     &9.1325e+04_r8,6.8494e+04_r8,4.5663e+04_r8,2.2832e+04_r8,2.5988e+01_r8/)
      kbo(:, 1,41,13) = (/ &
     &5.6764e+04_r8,4.2573e+04_r8,2.8383e+04_r8,1.4192e+04_r8,3.0791e+01_r8/)
      kbo(:, 2,41,13) = (/ &
     &6.6130e+04_r8,4.9598e+04_r8,3.3066e+04_r8,1.6533e+04_r8,2.9538e+01_r8/)
      kbo(:, 3,41,13) = (/ &
     &7.6243e+04_r8,5.7183e+04_r8,3.8122e+04_r8,1.9062e+04_r8,2.8774e+01_r8/)
      kbo(:, 4,41,13) = (/ &
     &8.6738e+04_r8,6.5054e+04_r8,4.3370e+04_r8,2.1685e+04_r8,2.7771e+01_r8/)
      kbo(:, 5,41,13) = (/ &
     &9.7338e+04_r8,7.3004e+04_r8,4.8670e+04_r8,2.4335e+04_r8,2.6481e+01_r8/)
      kbo(:, 1,42,13) = (/ &
     &5.9574e+04_r8,4.4680e+04_r8,2.9787e+04_r8,1.4894e+04_r8,3.1338e+01_r8/)
      kbo(:, 2,42,13) = (/ &
     &6.9874e+04_r8,5.2405e+04_r8,3.4937e+04_r8,1.7469e+04_r8,3.0066e+01_r8/)
      kbo(:, 3,42,13) = (/ &
     &8.1118e+04_r8,6.0839e+04_r8,4.0559e+04_r8,2.0280e+04_r8,2.9330e+01_r8/)
      kbo(:, 4,42,13) = (/ &
     &9.2915e+04_r8,6.9686e+04_r8,4.6457e+04_r8,2.3229e+04_r8,2.8281e+01_r8/)
      kbo(:, 5,42,13) = (/ &
     &1.0485e+05_r8,7.8636e+04_r8,5.2424e+04_r8,2.6212e+04_r8,2.6956e+01_r8/)
      kbo(:, 1,43,13) = (/ &
     &6.2565e+04_r8,4.6924e+04_r8,3.1283e+04_r8,1.5642e+04_r8,3.1947e+01_r8/)
      kbo(:, 2,43,13) = (/ &
     &7.3881e+04_r8,5.5411e+04_r8,3.6941e+04_r8,1.8471e+04_r8,3.0710e+01_r8/)
      kbo(:, 3,43,13) = (/ &
     &8.6376e+04_r8,6.4783e+04_r8,4.3189e+04_r8,2.1595e+04_r8,2.9823e+01_r8/)
      kbo(:, 4,43,13) = (/ &
     &9.9633e+04_r8,7.4725e+04_r8,4.9817e+04_r8,2.4909e+04_r8,2.8916e+01_r8/)
      kbo(:, 5,43,13) = (/ &
     &1.1317e+05_r8,8.4879e+04_r8,5.6586e+04_r8,2.8294e+04_r8,2.7433e+01_r8/)
      kbo(:, 1,44,13) = (/ &
     &6.6377e+04_r8,4.9783e+04_r8,3.3188e+04_r8,1.6595e+04_r8,3.2537e+01_r8/)
      kbo(:, 2,44,13) = (/ &
     &7.8875e+04_r8,5.9156e+04_r8,3.9437e+04_r8,1.9719e+04_r8,3.1463e+01_r8/)
      kbo(:, 3,44,13) = (/ &
     &9.2826e+04_r8,6.9619e+04_r8,4.6413e+04_r8,2.3207e+04_r8,3.0339e+01_r8/)
      kbo(:, 4,44,13) = (/ &
     &1.0782e+05_r8,8.0864e+04_r8,5.3909e+04_r8,2.6955e+04_r8,2.9519e+01_r8/)
      kbo(:, 5,44,13) = (/ &
     &1.2335e+05_r8,9.2508e+04_r8,6.1672e+04_r8,3.0836e+04_r8,2.7886e+01_r8/)
      kbo(:, 1,45,13) = (/ &
     &7.1874e+04_r8,5.3905e+04_r8,3.5937e+04_r8,1.7969e+04_r8,3.3146e+01_r8/)
      kbo(:, 2,45,13) = (/ &
     &8.5887e+04_r8,6.4415e+04_r8,4.2944e+04_r8,2.1472e+04_r8,3.2123e+01_r8/)
      kbo(:, 3,45,13) = (/ &
     &1.0168e+05_r8,7.6262e+04_r8,5.0841e+04_r8,2.5421e+04_r8,3.0727e+01_r8/)
      kbo(:, 4,45,13) = (/ &
     &1.1891e+05_r8,8.9181e+04_r8,5.9454e+04_r8,2.9727e+04_r8,3.0052e+01_r8/)
      kbo(:, 5,45,13) = (/ &
     &1.3695e+05_r8,1.0272e+05_r8,6.8477e+04_r8,3.4239e+04_r8,2.8423e+01_r8/)
      kbo(:, 1,46,13) = (/ &
     &7.8328e+04_r8,5.8747e+04_r8,3.9165e+04_r8,1.9583e+04_r8,3.3800e+01_r8/)
      kbo(:, 2,46,13) = (/ &
     &9.4082e+04_r8,7.0562e+04_r8,4.7041e+04_r8,2.3521e+04_r8,3.2751e+01_r8/)
      kbo(:, 3,46,13) = (/ &
     &1.1205e+05_r8,8.4041e+04_r8,5.6028e+04_r8,2.8014e+04_r8,3.1210e+01_r8/)
      kbo(:, 4,46,13) = (/ &
     &1.3188e+05_r8,9.8910e+04_r8,6.5940e+04_r8,3.2971e+04_r8,3.0670e+01_r8/)
      kbo(:, 5,46,13) = (/ &
     &1.5296e+05_r8,1.1472e+05_r8,7.6478e+04_r8,3.8239e+04_r8,2.9020e+01_r8/)
      kbo(:, 1,47,13) = (/ &
     &8.3810e+04_r8,6.2858e+04_r8,4.1906e+04_r8,2.0953e+04_r8,3.4456e+01_r8/)
      kbo(:, 2,47,13) = (/ &
     &1.0129e+05_r8,7.5968e+04_r8,5.0646e+04_r8,2.5323e+04_r8,3.3326e+01_r8/)
      kbo(:, 3,47,13) = (/ &
     &1.2133e+05_r8,9.0998e+04_r8,6.0666e+04_r8,3.0333e+04_r8,3.1897e+01_r8/)
      kbo(:, 4,47,13) = (/ &
     &1.4374e+05_r8,1.0781e+05_r8,7.1871e+04_r8,3.5936e+04_r8,3.1165e+01_r8/)
      kbo(:, 5,47,13) = (/ &
     &1.6790e+05_r8,1.2593e+05_r8,8.3952e+04_r8,4.1976e+04_r8,2.9653e+01_r8/)
      kbo(:, 1,48,13) = (/ &
     &9.2009e+04_r8,6.9007e+04_r8,4.6005e+04_r8,2.3003e+04_r8,3.5004e+01_r8/)
      kbo(:, 2,48,13) = (/ &
     &1.1207e+05_r8,8.4051e+04_r8,5.6034e+04_r8,2.8018e+04_r8,3.3918e+01_r8/)
      kbo(:, 3,48,13) = (/ &
     &1.3494e+05_r8,1.0121e+05_r8,6.7471e+04_r8,3.3736e+04_r8,3.2425e+01_r8/)
      kbo(:, 4,48,13) = (/ &
     &1.6083e+05_r8,1.2063e+05_r8,8.0418e+04_r8,4.0210e+04_r8,3.1652e+01_r8/)
      kbo(:, 5,48,13) = (/ &
     &1.8920e+05_r8,1.4190e+05_r8,9.4599e+04_r8,4.7300e+04_r8,3.0396e+01_r8/)
      kbo(:, 1,49,13) = (/ &
     &1.0515e+05_r8,7.8866e+04_r8,5.2577e+04_r8,2.6289e+04_r8,3.5598e+01_r8/)
      kbo(:, 2,49,13) = (/ &
     &1.2899e+05_r8,9.6745e+04_r8,6.4497e+04_r8,3.2249e+04_r8,3.4541e+01_r8/)
      kbo(:, 3,49,13) = (/ &
     &1.5618e+05_r8,1.1714e+05_r8,7.8092e+04_r8,3.9046e+04_r8,3.3166e+01_r8/)
      kbo(:, 4,49,13) = (/ &
     &1.8721e+05_r8,1.4041e+05_r8,9.3606e+04_r8,4.6803e+04_r8,3.2127e+01_r8/)
      kbo(:, 5,49,13) = (/ &
     &2.2166e+05_r8,1.6624e+05_r8,1.1083e+05_r8,5.5414e+04_r8,3.1114e+01_r8/)
      kbo(:, 1,50,13) = (/ &
     &1.1492e+05_r8,8.6190e+04_r8,5.7460e+04_r8,2.8730e+04_r8,3.5920e+01_r8/)
      kbo(:, 2,50,13) = (/ &
     &1.4177e+05_r8,1.0633e+05_r8,7.0884e+04_r8,3.5442e+04_r8,3.5009e+01_r8/)
      kbo(:, 3,50,13) = (/ &
     &1.7284e+05_r8,1.2963e+05_r8,8.6422e+04_r8,4.3212e+04_r8,3.3840e+01_r8/)
      kbo(:, 4,50,13) = (/ &
     &2.0816e+05_r8,1.5612e+05_r8,1.0408e+05_r8,5.2042e+04_r8,3.2614e+01_r8/)
      kbo(:, 5,50,13) = (/ &
     &2.4789e+05_r8,1.8591e+05_r8,1.2394e+05_r8,6.1972e+04_r8,3.1787e+01_r8/)
      kbo(:, 1,51,13) = (/ &
     &1.2316e+05_r8,9.2372e+04_r8,6.1582e+04_r8,3.0791e+04_r8,3.6248e+01_r8/)
      kbo(:, 2,51,13) = (/ &
     &1.5257e+05_r8,1.1443e+05_r8,7.6284e+04_r8,3.8142e+04_r8,3.5464e+01_r8/)
      kbo(:, 3,51,13) = (/ &
     &1.8735e+05_r8,1.4051e+05_r8,9.3677e+04_r8,4.6839e+04_r8,3.4431e+01_r8/)
      kbo(:, 4,51,13) = (/ &
     &2.2663e+05_r8,1.6997e+05_r8,1.1332e+05_r8,5.6659e+04_r8,3.2971e+01_r8/)
      kbo(:, 5,51,13) = (/ &
     &2.7128e+05_r8,2.0346e+05_r8,1.3564e+05_r8,6.7820e+04_r8,3.2477e+01_r8/)
      kbo(:, 1,52,13) = (/ &
     &1.3564e+05_r8,1.0173e+05_r8,6.7822e+04_r8,3.3911e+04_r8,3.6511e+01_r8/)
      kbo(:, 2,52,13) = (/ &
     &1.6873e+05_r8,1.2655e+05_r8,8.4367e+04_r8,4.2184e+04_r8,3.5955e+01_r8/)
      kbo(:, 3,52,13) = (/ &
     &2.0841e+05_r8,1.5631e+05_r8,1.0421e+05_r8,5.2104e+04_r8,3.4988e+01_r8/)
      kbo(:, 4,52,13) = (/ &
     &2.5356e+05_r8,1.9017e+05_r8,1.2678e+05_r8,6.3390e+04_r8,3.3412e+01_r8/)
      kbo(:, 5,52,13) = (/ &
     &3.0501e+05_r8,2.2876e+05_r8,1.5250e+05_r8,7.6253e+04_r8,3.3108e+01_r8/)
      kbo(:, 1,53,13) = (/ &
     &1.5552e+05_r8,1.1664e+05_r8,7.7762e+04_r8,3.8882e+04_r8,3.6856e+01_r8/)
      kbo(:, 2,53,13) = (/ &
     &1.9425e+05_r8,1.4569e+05_r8,9.7128e+04_r8,4.8565e+04_r8,3.6432e+01_r8/)
      kbo(:, 3,53,13) = (/ &
     &2.4103e+05_r8,1.8077e+05_r8,1.2051e+05_r8,6.0258e+04_r8,3.5535e+01_r8/)
      kbo(:, 4,53,13) = (/ &
     &2.9532e+05_r8,2.2149e+05_r8,1.4766e+05_r8,7.3832e+04_r8,3.3878e+01_r8/)
      kbo(:, 5,53,13) = (/ &
     &3.5673e+05_r8,2.6755e+05_r8,1.7837e+05_r8,8.9184e+04_r8,3.3830e+01_r8/)
      kbo(:, 1,54,13) = (/ &
     &1.5519e+05_r8,1.1639e+05_r8,7.7595e+04_r8,3.8798e+04_r8,3.7137e+01_r8/)
      kbo(:, 2,54,13) = (/ &
     &1.9455e+05_r8,1.4591e+05_r8,9.7277e+04_r8,4.8639e+04_r8,3.6719e+01_r8/)
      kbo(:, 3,54,13) = (/ &
     &2.4223e+05_r8,1.8167e+05_r8,1.2111e+05_r8,6.0558e+04_r8,3.5737e+01_r8/)
      kbo(:, 4,54,13) = (/ &
     &2.9863e+05_r8,2.2398e+05_r8,1.4932e+05_r8,7.4660e+04_r8,3.4182e+01_r8/)
      kbo(:, 5,54,13) = (/ &
     &3.6225e+05_r8,2.7169e+05_r8,1.8113e+05_r8,9.0564e+04_r8,3.4090e+01_r8/)
      kbo(:, 1,55,13) = (/ &
     &1.4179e+05_r8,1.0634e+05_r8,7.0895e+04_r8,3.5448e+04_r8,3.7500e+01_r8/)
      kbo(:, 2,55,13) = (/ &
     &1.7805e+05_r8,1.3354e+05_r8,8.9025e+04_r8,4.4513e+04_r8,3.6673e+01_r8/)
      kbo(:, 3,55,13) = (/ &
     &2.2250e+05_r8,1.6688e+05_r8,1.1125e+05_r8,5.5626e+04_r8,3.6002e+01_r8/)
      kbo(:, 4,55,13) = (/ &
     &2.7565e+05_r8,2.0674e+05_r8,1.3783e+05_r8,6.8913e+04_r8,3.4967e+01_r8/)
      kbo(:, 5,55,13) = (/ &
     &3.3613e+05_r8,2.5210e+05_r8,1.6807e+05_r8,8.4034e+04_r8,3.3605e+01_r8/)
      kbo(:, 1,56,13) = (/ &
     &1.2955e+05_r8,9.7160e+04_r8,6.4773e+04_r8,3.2387e+04_r8,3.7592e+01_r8/)
      kbo(:, 2,56,13) = (/ &
     &1.6291e+05_r8,1.2218e+05_r8,8.1452e+04_r8,4.0726e+04_r8,3.6892e+01_r8/)
      kbo(:, 3,56,13) = (/ &
     &2.0430e+05_r8,1.5322e+05_r8,1.0215e+05_r8,5.1074e+04_r8,3.6401e+01_r8/)
      kbo(:, 4,56,13) = (/ &
     &2.5407e+05_r8,1.9055e+05_r8,1.2704e+05_r8,6.3518e+04_r8,3.5416e+01_r8/)
      kbo(:, 5,56,13) = (/ &
     &3.1173e+05_r8,2.3380e+05_r8,1.5586e+05_r8,7.7932e+04_r8,3.3725e+01_r8/)
      kbo(:, 1,57,13) = (/ &
     &1.1844e+05_r8,8.8830e+04_r8,5.9220e+04_r8,2.9610e+04_r8,3.7590e+01_r8/)
      kbo(:, 2,57,13) = (/ &
     &1.4902e+05_r8,1.1176e+05_r8,7.4508e+04_r8,3.7254e+04_r8,3.7340e+01_r8/)
      kbo(:, 3,57,13) = (/ &
     &1.8747e+05_r8,1.4060e+05_r8,9.3736e+04_r8,4.6868e+04_r8,3.6437e+01_r8/)
      kbo(:, 4,57,13) = (/ &
     &2.3395e+05_r8,1.7546e+05_r8,1.1697e+05_r8,5.8487e+04_r8,3.5598e+01_r8/)
      kbo(:, 5,57,13) = (/ &
     &2.8870e+05_r8,2.1653e+05_r8,1.4435e+05_r8,7.2175e+04_r8,3.4562e+01_r8/)
      kbo(:, 1,58,13) = (/ &
     &2.8654e+04_r8,2.6272e+04_r8,2.2526e+04_r8,1.5777e+04_r8,3.7286e+01_r8/)
      kbo(:, 2,58,13) = (/ &
     &3.6090e+04_r8,3.3089e+04_r8,2.8371e+04_r8,1.9871e+04_r8,3.7547e+01_r8/)
      kbo(:, 3,58,13) = (/ &
     &4.5492e+04_r8,4.1710e+04_r8,3.5762e+04_r8,2.5048e+04_r8,3.6650e+01_r8/)
      kbo(:, 4,58,13) = (/ &
     &5.6953e+04_r8,5.2217e+04_r8,4.4772e+04_r8,3.1358e+04_r8,3.6005e+01_r8/)
      kbo(:, 5,58,13) = (/ &
     &7.0617e+04_r8,6.4745e+04_r8,5.5513e+04_r8,3.8881e+04_r8,3.4983e+01_r8/)
      kbo(:, 1,59,13) = (/ &
     &3.2425e+04_r8,2.8312e+04_r8,2.2583e+04_r8,1.4053e+04_r8,3.7337e+01_r8/)
      kbo(:, 2,59,13) = (/ &
     &4.0874e+04_r8,3.5689e+04_r8,2.8468e+04_r8,1.7715e+04_r8,3.7354e+01_r8/)
      kbo(:, 3,59,13) = (/ &
     &5.1569e+04_r8,4.5029e+04_r8,3.5917e+04_r8,2.2350e+04_r8,3.7146e+01_r8/)
      kbo(:, 4,59,13) = (/ &
     &6.4659e+04_r8,5.6458e+04_r8,4.5034e+04_r8,2.8023e+04_r8,3.5794e+01_r8/)
      kbo(:, 5,59,13) = (/ &
     &8.0312e+04_r8,7.0125e+04_r8,5.5936e+04_r8,3.4807e+04_r8,3.4858e+01_r8/)
      kbo(:, 1,13,14) = (/ &
     &5.5354e+05_r8,4.1516e+05_r8,2.7677e+05_r8,1.3839e+05_r8,6.6359e+00_r8/)
      kbo(:, 2,13,14) = (/ &
     &5.3662e+05_r8,4.0247e+05_r8,2.6831e+05_r8,1.3416e+05_r8,6.3521e+00_r8/)
      kbo(:, 3,13,14) = (/ &
     &5.2321e+05_r8,3.9241e+05_r8,2.6161e+05_r8,1.3080e+05_r8,6.1777e+00_r8/)
      kbo(:, 4,13,14) = (/ &
     &5.1223e+05_r8,3.8417e+05_r8,2.5612e+05_r8,1.2806e+05_r8,5.8113e+00_r8/)
      kbo(:, 5,13,14) = (/ &
     &5.0254e+05_r8,3.7690e+05_r8,2.5127e+05_r8,1.2564e+05_r8,5.1461e+00_r8/)
      kbo(:, 1,14,14) = (/ &
     &3.6531e+05_r8,2.7398e+05_r8,1.8265e+05_r8,9.1327e+04_r8,7.3146e+00_r8/)
      kbo(:, 2,14,14) = (/ &
     &3.5777e+05_r8,2.6833e+05_r8,1.7888e+05_r8,8.9442e+04_r8,7.0661e+00_r8/)
      kbo(:, 3,14,14) = (/ &
     &3.5166e+05_r8,2.6375e+05_r8,1.7583e+05_r8,8.7915e+04_r8,6.6597e+00_r8/)
      kbo(:, 4,14,14) = (/ &
     &3.4675e+05_r8,2.6006e+05_r8,1.7337e+05_r8,8.6687e+04_r8,6.5607e+00_r8/)
      kbo(:, 5,14,14) = (/ &
     &3.4224e+05_r8,2.5668e+05_r8,1.7112e+05_r8,8.5559e+04_r8,6.0728e+00_r8/)
      kbo(:, 1,15,14) = (/ &
     &2.5038e+05_r8,1.8779e+05_r8,1.2519e+05_r8,6.2598e+04_r8,8.1437e+00_r8/)
      kbo(:, 2,15,14) = (/ &
     &2.4740e+05_r8,1.8555e+05_r8,1.2370e+05_r8,6.1853e+04_r8,7.8645e+00_r8/)
      kbo(:, 3,15,14) = (/ &
     &2.4508e+05_r8,1.8381e+05_r8,1.2254e+05_r8,6.1272e+04_r8,7.4907e+00_r8/)
      kbo(:, 4,15,14) = (/ &
     &2.4271e+05_r8,1.8203e+05_r8,1.2136e+05_r8,6.0680e+04_r8,7.2641e+00_r8/)
      kbo(:, 5,15,14) = (/ &
     &2.4052e+05_r8,1.8039e+05_r8,1.2026e+05_r8,6.0131e+04_r8,7.0682e+00_r8/)
      kbo(:, 1,16,14) = (/ &
     &2.0782e+05_r8,1.5587e+05_r8,1.0391e+05_r8,5.1957e+04_r8,9.0703e+00_r8/)
      kbo(:, 2,16,14) = (/ &
     &2.0661e+05_r8,1.5496e+05_r8,1.0331e+05_r8,5.1654e+04_r8,8.7622e+00_r8/)
      kbo(:, 3,16,14) = (/ &
     &2.0513e+05_r8,1.5385e+05_r8,1.0257e+05_r8,5.1284e+04_r8,8.4635e+00_r8/)
      kbo(:, 4,16,14) = (/ &
     &2.0374e+05_r8,1.5280e+05_r8,1.0187e+05_r8,5.0936e+04_r8,8.1015e+00_r8/)
      kbo(:, 5,16,14) = (/ &
     &2.0191e+05_r8,1.5143e+05_r8,1.0096e+05_r8,5.0479e+04_r8,7.9045e+00_r8/)
      kbo(:, 1,17,14) = (/ &
     &1.8037e+05_r8,1.3528e+05_r8,9.0185e+04_r8,4.5093e+04_r8,1.0108e+01_r8/)
      kbo(:, 2,17,14) = (/ &
     &1.7972e+05_r8,1.3479e+05_r8,8.9862e+04_r8,4.4932e+04_r8,9.7857e+00_r8/)
      kbo(:, 3,17,14) = (/ &
     &1.7906e+05_r8,1.3430e+05_r8,8.9533e+04_r8,4.4767e+04_r8,9.4761e+00_r8/)
      kbo(:, 4,17,14) = (/ &
     &1.7788e+05_r8,1.3341e+05_r8,8.8942e+04_r8,4.4472e+04_r8,9.0551e+00_r8/)
      kbo(:, 5,17,14) = (/ &
     &1.7662e+05_r8,1.3247e+05_r8,8.8311e+04_r8,4.4156e+04_r8,8.8726e+00_r8/)
      kbo(:, 1,18,14) = (/ &
     &1.6160e+05_r8,1.2120e+05_r8,8.0801e+04_r8,4.0401e+04_r8,1.1327e+01_r8/)
      kbo(:, 2,18,14) = (/ &
     &1.6141e+05_r8,1.2106e+05_r8,8.0704e+04_r8,4.0353e+04_r8,1.1010e+01_r8/)
      kbo(:, 3,18,14) = (/ &
     &1.6076e+05_r8,1.2057e+05_r8,8.0382e+04_r8,4.0192e+04_r8,1.0693e+01_r8/)
      kbo(:, 4,18,14) = (/ &
     &1.6001e+05_r8,1.2001e+05_r8,8.0005e+04_r8,4.0003e+04_r8,1.0193e+01_r8/)
      kbo(:, 5,18,14) = (/ &
     &1.5881e+05_r8,1.1911e+05_r8,7.9406e+04_r8,3.9704e+04_r8,1.0071e+01_r8/)
      kbo(:, 1,19,14) = (/ &
     &1.4270e+05_r8,1.0702e+05_r8,7.1350e+04_r8,3.5676e+04_r8,1.2821e+01_r8/)
      kbo(:, 2,19,14) = (/ &
     &1.4247e+05_r8,1.0685e+05_r8,7.1236e+04_r8,3.5619e+04_r8,1.2498e+01_r8/)
      kbo(:, 3,19,14) = (/ &
     &1.4204e+05_r8,1.0653e+05_r8,7.1022e+04_r8,3.5511e+04_r8,1.2171e+01_r8/)
      kbo(:, 4,19,14) = (/ &
     &1.4126e+05_r8,1.0594e+05_r8,7.0629e+04_r8,3.5315e+04_r8,1.1680e+01_r8/)
      kbo(:, 5,19,14) = (/ &
     &1.4024e+05_r8,1.0518e+05_r8,7.0119e+04_r8,3.5060e+04_r8,1.1491e+01_r8/)
      kbo(:, 1,20,14) = (/ &
     &1.3563e+05_r8,1.0173e+05_r8,6.7817e+04_r8,3.3909e+04_r8,1.4618e+01_r8/)
      kbo(:, 2,20,14) = (/ &
     &1.3541e+05_r8,1.0156e+05_r8,6.7708e+04_r8,3.3855e+04_r8,1.4263e+01_r8/)
      kbo(:, 3,20,14) = (/ &
     &1.3484e+05_r8,1.0113e+05_r8,6.7419e+04_r8,3.3710e+04_r8,1.3906e+01_r8/)
      kbo(:, 4,20,14) = (/ &
     &1.3404e+05_r8,1.0053e+05_r8,6.7023e+04_r8,3.3512e+04_r8,1.3385e+01_r8/)
      kbo(:, 5,20,14) = (/ &
     &1.3293e+05_r8,9.9699e+04_r8,6.6466e+04_r8,3.3234e+04_r8,1.3122e+01_r8/)
      kbo(:, 1,21,14) = (/ &
     &1.3198e+05_r8,9.8983e+04_r8,6.5989e+04_r8,3.2995e+04_r8,1.6661e+01_r8/)
      kbo(:, 2,21,14) = (/ &
     &1.3158e+05_r8,9.8688e+04_r8,6.5792e+04_r8,3.2897e+04_r8,1.6248e+01_r8/)
      kbo(:, 3,21,14) = (/ &
     &1.3094e+05_r8,9.8202e+04_r8,6.5468e+04_r8,3.2735e+04_r8,1.5812e+01_r8/)
      kbo(:, 4,21,14) = (/ &
     &1.3001e+05_r8,9.7504e+04_r8,6.5003e+04_r8,3.2502e+04_r8,1.5225e+01_r8/)
      kbo(:, 5,21,14) = (/ &
     &1.2884e+05_r8,9.6632e+04_r8,6.4422e+04_r8,3.2211e+04_r8,1.4867e+01_r8/)
      kbo(:, 1,22,14) = (/ &
     &1.3028e+05_r8,9.7707e+04_r8,6.5139e+04_r8,3.2570e+04_r8,1.8806e+01_r8/)
      kbo(:, 2,22,14) = (/ &
     &1.2981e+05_r8,9.7355e+04_r8,6.4904e+04_r8,3.2452e+04_r8,1.8310e+01_r8/)
      kbo(:, 3,22,14) = (/ &
     &1.2902e+05_r8,9.6763e+04_r8,6.4509e+04_r8,3.2255e+04_r8,1.7798e+01_r8/)
      kbo(:, 4,22,14) = (/ &
     &1.2795e+05_r8,9.5966e+04_r8,6.3978e+04_r8,3.1989e+04_r8,1.7136e+01_r8/)
      kbo(:, 5,22,14) = (/ &
     &1.2666e+05_r8,9.4996e+04_r8,6.3331e+04_r8,3.1666e+04_r8,1.6711e+01_r8/)
      kbo(:, 1,23,14) = (/ &
     &1.2794e+05_r8,9.5952e+04_r8,6.3968e+04_r8,3.1985e+04_r8,2.1073e+01_r8/)
      kbo(:, 2,23,14) = (/ &
     &1.2735e+05_r8,9.5515e+04_r8,6.3677e+04_r8,3.1839e+04_r8,2.0511e+01_r8/)
      kbo(:, 3,23,14) = (/ &
     &1.2647e+05_r8,9.4850e+04_r8,6.3234e+04_r8,3.1617e+04_r8,1.9930e+01_r8/)
      kbo(:, 4,23,14) = (/ &
     &1.2537e+05_r8,9.4025e+04_r8,6.2684e+04_r8,3.1342e+04_r8,1.9174e+01_r8/)
      kbo(:, 5,23,14) = (/ &
     &1.2398e+05_r8,9.2985e+04_r8,6.1990e+04_r8,3.0996e+04_r8,1.8667e+01_r8/)
      kbo(:, 1,24,14) = (/ &
     &1.2343e+05_r8,9.2570e+04_r8,6.1714e+04_r8,3.0858e+04_r8,2.3485e+01_r8/)
      kbo(:, 2,24,14) = (/ &
     &1.2276e+05_r8,9.2074e+04_r8,6.1383e+04_r8,3.0692e+04_r8,2.2824e+01_r8/)
      kbo(:, 3,24,14) = (/ &
     &1.2194e+05_r8,9.1458e+04_r8,6.0973e+04_r8,3.0487e+04_r8,2.2153e+01_r8/)
      kbo(:, 4,24,14) = (/ &
     &1.2080e+05_r8,9.0601e+04_r8,6.0401e+04_r8,3.0201e+04_r8,2.1291e+01_r8/)
      kbo(:, 5,24,14) = (/ &
     &1.1949e+05_r8,8.9617e+04_r8,5.9745e+04_r8,2.9873e+04_r8,2.0633e+01_r8/)
      kbo(:, 1,25,14) = (/ &
     &1.1905e+05_r8,8.9291e+04_r8,5.9528e+04_r8,2.9764e+04_r8,2.5966e+01_r8/)
      kbo(:, 2,25,14) = (/ &
     &1.1853e+05_r8,8.8894e+04_r8,5.9263e+04_r8,2.9632e+04_r8,2.5184e+01_r8/)
      kbo(:, 3,25,14) = (/ &
     &1.1769e+05_r8,8.8271e+04_r8,5.8848e+04_r8,2.9424e+04_r8,2.4373e+01_r8/)
      kbo(:, 4,25,14) = (/ &
     &1.1666e+05_r8,8.7497e+04_r8,5.8331e+04_r8,2.9166e+04_r8,2.3367e+01_r8/)
      kbo(:, 5,25,14) = (/ &
     &1.1542e+05_r8,8.6565e+04_r8,5.7710e+04_r8,2.8855e+04_r8,2.2586e+01_r8/)
      kbo(:, 1,26,14) = (/ &
     &1.1553e+05_r8,8.6651e+04_r8,5.7768e+04_r8,2.8884e+04_r8,2.8441e+01_r8/)
      kbo(:, 2,26,14) = (/ &
     &1.1511e+05_r8,8.6329e+04_r8,5.7553e+04_r8,2.8777e+04_r8,2.7500e+01_r8/)
      kbo(:, 3,26,14) = (/ &
     &1.1443e+05_r8,8.5820e+04_r8,5.7213e+04_r8,2.8607e+04_r8,2.6532e+01_r8/)
      kbo(:, 4,26,14) = (/ &
     &1.1356e+05_r8,8.5172e+04_r8,5.6781e+04_r8,2.8391e+04_r8,2.5362e+01_r8/)
      kbo(:, 5,26,14) = (/ &
     &1.1241e+05_r8,8.4309e+04_r8,5.6206e+04_r8,2.8103e+04_r8,2.4468e+01_r8/)
      kbo(:, 1,27,14) = (/ &
     &1.1545e+05_r8,8.6587e+04_r8,5.7725e+04_r8,2.8863e+04_r8,3.0839e+01_r8/)
      kbo(:, 2,27,14) = (/ &
     &1.1514e+05_r8,8.6352e+04_r8,5.7568e+04_r8,2.8785e+04_r8,2.9713e+01_r8/)
      kbo(:, 3,27,14) = (/ &
     &1.1466e+05_r8,8.5998e+04_r8,5.7332e+04_r8,2.8667e+04_r8,2.8580e+01_r8/)
      kbo(:, 4,27,14) = (/ &
     &1.1391e+05_r8,8.5436e+04_r8,5.6958e+04_r8,2.8479e+04_r8,2.7213e+01_r8/)
      kbo(:, 5,27,14) = (/ &
     &1.1293e+05_r8,8.4701e+04_r8,5.6467e+04_r8,2.8234e+04_r8,2.6212e+01_r8/)
      kbo(:, 1,28,14) = (/ &
     &1.1769e+05_r8,8.8268e+04_r8,5.8845e+04_r8,2.9423e+04_r8,3.3091e+01_r8/)
      kbo(:, 2,28,14) = (/ &
     &1.1765e+05_r8,8.8234e+04_r8,5.8823e+04_r8,2.9412e+04_r8,3.1766e+01_r8/)
      kbo(:, 3,28,14) = (/ &
     &1.1733e+05_r8,8.7997e+04_r8,5.8665e+04_r8,2.9333e+04_r8,3.0463e+01_r8/)
      kbo(:, 4,28,14) = (/ &
     &1.1677e+05_r8,8.7580e+04_r8,5.8387e+04_r8,2.9194e+04_r8,2.8874e+01_r8/)
      kbo(:, 5,28,14) = (/ &
     &1.1593e+05_r8,8.6950e+04_r8,5.7967e+04_r8,2.8984e+04_r8,2.7821e+01_r8/)
      kbo(:, 1,29,14) = (/ &
     &1.2676e+05_r8,9.5071e+04_r8,6.3381e+04_r8,3.1691e+04_r8,3.5131e+01_r8/)
      kbo(:, 2,29,14) = (/ &
     &1.2709e+05_r8,9.5318e+04_r8,6.3545e+04_r8,3.1773e+04_r8,3.3613e+01_r8/)
      kbo(:, 3,29,14) = (/ &
     &1.2701e+05_r8,9.5260e+04_r8,6.3507e+04_r8,3.1754e+04_r8,3.1981e+01_r8/)
      kbo(:, 4,29,14) = (/ &
     &1.2660e+05_r8,9.4952e+04_r8,6.3301e+04_r8,3.1651e+04_r8,3.0369e+01_r8/)
      kbo(:, 5,29,14) = (/ &
     &1.2589e+05_r8,9.4414e+04_r8,6.2943e+04_r8,3.1472e+04_r8,2.9250e+01_r8/)
      kbo(:, 1,30,14) = (/ &
     &1.3959e+05_r8,1.0469e+05_r8,6.9793e+04_r8,3.4897e+04_r8,3.6931e+01_r8/)
      kbo(:, 2,30,14) = (/ &
     &1.4034e+05_r8,1.0525e+05_r8,7.0169e+04_r8,3.5085e+04_r8,3.5216e+01_r8/)
      kbo(:, 3,30,14) = (/ &
     &1.4057e+05_r8,1.0543e+05_r8,7.0285e+04_r8,3.5143e+04_r8,3.3253e+01_r8/)
      kbo(:, 4,30,14) = (/ &
     &1.4040e+05_r8,1.0530e+05_r8,7.0200e+04_r8,3.5100e+04_r8,3.1871e+01_r8/)
      kbo(:, 5,30,14) = (/ &
     &1.3970e+05_r8,1.0477e+05_r8,6.9850e+04_r8,3.4925e+04_r8,3.0435e+01_r8/)
      kbo(:, 1,31,14) = (/ &
     &1.6150e+05_r8,1.2112e+05_r8,8.0748e+04_r8,4.0374e+04_r8,3.8448e+01_r8/)
      kbo(:, 2,31,14) = (/ &
     &1.6274e+05_r8,1.2205e+05_r8,8.1369e+04_r8,4.0685e+04_r8,3.6340e+01_r8/)
      kbo(:, 3,31,14) = (/ &
     &1.6341e+05_r8,1.2256e+05_r8,8.1707e+04_r8,4.0854e+04_r8,3.4532e+01_r8/)
      kbo(:, 4,31,14) = (/ &
     &1.6341e+05_r8,1.2256e+05_r8,8.1706e+04_r8,4.0853e+04_r8,3.3032e+01_r8/)
      kbo(:, 5,31,14) = (/ &
     &1.6281e+05_r8,1.2211e+05_r8,8.1407e+04_r8,4.0704e+04_r8,3.1374e+01_r8/)
      kbo(:, 1,32,14) = (/ &
     &1.8902e+05_r8,1.4177e+05_r8,9.4511e+04_r8,4.7256e+04_r8,3.9673e+01_r8/)
      kbo(:, 2,32,14) = (/ &
     &1.9095e+05_r8,1.4322e+05_r8,9.5478e+04_r8,4.7739e+04_r8,3.7210e+01_r8/)
      kbo(:, 3,32,14) = (/ &
     &1.9208e+05_r8,1.4406e+05_r8,9.6041e+04_r8,4.8021e+04_r8,3.5668e+01_r8/)
      kbo(:, 4,32,14) = (/ &
     &1.9230e+05_r8,1.4423e+05_r8,9.6153e+04_r8,4.8077e+04_r8,3.3902e+01_r8/)
      kbo(:, 5,32,14) = (/ &
     &1.9178e+05_r8,1.4383e+05_r8,9.5890e+04_r8,4.7945e+04_r8,3.1255e+01_r8/)
      kbo(:, 1,33,14) = (/ &
     &2.2548e+05_r8,1.6911e+05_r8,1.1274e+05_r8,5.6370e+04_r8,4.0253e+01_r8/)
      kbo(:, 2,33,14) = (/ &
     &2.2820e+05_r8,1.7115e+05_r8,1.1410e+05_r8,5.7051e+04_r8,3.8356e+01_r8/)
      kbo(:, 3,33,14) = (/ &
     &2.2980e+05_r8,1.7235e+05_r8,1.1490e+05_r8,5.7450e+04_r8,3.6454e+01_r8/)
      kbo(:, 4,33,14) = (/ &
     &2.3033e+05_r8,1.7275e+05_r8,1.1517e+05_r8,5.7584e+04_r8,3.3797e+01_r8/)
      kbo(:, 5,33,14) = (/ &
     &2.2985e+05_r8,1.7239e+05_r8,1.1492e+05_r8,5.7463e+04_r8,3.1363e+01_r8/)
      kbo(:, 1,34,14) = (/ &
     &2.6250e+05_r8,1.9687e+05_r8,1.3125e+05_r8,6.5624e+04_r8,4.1136e+01_r8/)
      kbo(:, 2,34,14) = (/ &
     &2.6605e+05_r8,1.9954e+05_r8,1.3302e+05_r8,6.6512e+04_r8,3.9143e+01_r8/)
      kbo(:, 3,34,14) = (/ &
     &2.6820e+05_r8,2.0115e+05_r8,1.3410e+05_r8,6.7050e+04_r8,3.6807e+01_r8/)
      kbo(:, 4,34,14) = (/ &
     &2.6900e+05_r8,2.0175e+05_r8,1.3450e+05_r8,6.7251e+04_r8,3.3160e+01_r8/)
      kbo(:, 5,34,14) = (/ &
     &2.6861e+05_r8,2.0146e+05_r8,1.3431e+05_r8,6.7153e+04_r8,3.1344e+01_r8/)
      kbo(:, 1,35,14) = (/ &
     &3.0587e+05_r8,2.2940e+05_r8,1.5293e+05_r8,7.6467e+04_r8,4.2099e+01_r8/)
      kbo(:, 2,35,14) = (/ &
     &3.1048e+05_r8,2.3286e+05_r8,1.5524e+05_r8,7.7621e+04_r8,3.9785e+01_r8/)
      kbo(:, 3,35,14) = (/ &
     &3.1341e+05_r8,2.3506e+05_r8,1.5670e+05_r8,7.8352e+04_r8,3.6072e+01_r8/)
      kbo(:, 4,35,14) = (/ &
     &3.1462e+05_r8,2.3596e+05_r8,1.5731e+05_r8,7.8655e+04_r8,3.3490e+01_r8/)
      kbo(:, 5,35,14) = (/ &
     &3.1438e+05_r8,2.3579e+05_r8,1.5719e+05_r8,7.8596e+04_r8,3.1828e+01_r8/)
      kbo(:, 1,36,14) = (/ &
     &3.5380e+05_r8,2.6535e+05_r8,1.7690e+05_r8,8.8450e+04_r8,4.2948e+01_r8/)
      kbo(:, 2,36,14) = (/ &
     &3.5987e+05_r8,2.6990e+05_r8,1.7993e+05_r8,8.9967e+04_r8,3.9945e+01_r8/)
      kbo(:, 3,36,14) = (/ &
     &3.6383e+05_r8,2.7287e+05_r8,1.8191e+05_r8,9.0957e+04_r8,3.5908e+01_r8/)
      kbo(:, 4,36,14) = (/ &
     &3.6571e+05_r8,2.7429e+05_r8,1.8286e+05_r8,9.1429e+04_r8,3.3881e+01_r8/)
      kbo(:, 5,36,14) = (/ &
     &3.6576e+05_r8,2.7432e+05_r8,1.8288e+05_r8,9.1441e+04_r8,3.2580e+01_r8/)
      kbo(:, 1,37,14) = (/ &
     &3.9789e+05_r8,2.9842e+05_r8,1.9894e+05_r8,9.9472e+04_r8,4.3924e+01_r8/)
      kbo(:, 2,37,14) = (/ &
     &4.0582e+05_r8,3.0436e+05_r8,2.0291e+05_r8,1.0145e+05_r8,4.0613e+01_r8/)
      kbo(:, 3,37,14) = (/ &
     &4.1126e+05_r8,3.0845e+05_r8,2.0563e+05_r8,1.0282e+05_r8,3.6440e+01_r8/)
      kbo(:, 4,37,14) = (/ &
     &4.1422e+05_r8,3.1066e+05_r8,2.0711e+05_r8,1.0355e+05_r8,3.4966e+01_r8/)
      kbo(:, 5,37,14) = (/ &
     &4.1491e+05_r8,3.1118e+05_r8,2.0745e+05_r8,1.0373e+05_r8,3.3736e+01_r8/)
      kbo(:, 1,38,14) = (/ &
     &4.5404e+05_r8,3.4053e+05_r8,2.2702e+05_r8,1.1351e+05_r8,4.4908e+01_r8/)
      kbo(:, 2,38,14) = (/ &
     &4.6441e+05_r8,3.4830e+05_r8,2.3220e+05_r8,1.1610e+05_r8,4.0968e+01_r8/)
      kbo(:, 3,38,14) = (/ &
     &4.7167e+05_r8,3.5375e+05_r8,2.3583e+05_r8,1.1792e+05_r8,3.7185e+01_r8/)
      kbo(:, 4,38,14) = (/ &
     &4.7591e+05_r8,3.5693e+05_r8,2.3796e+05_r8,1.1898e+05_r8,3.5958e+01_r8/)
      kbo(:, 5,38,14) = (/ &
     &4.7747e+05_r8,3.5810e+05_r8,2.3873e+05_r8,1.1937e+05_r8,3.4345e+01_r8/)
      kbo(:, 1,39,14) = (/ &
     &5.3006e+05_r8,3.9755e+05_r8,2.6503e+05_r8,1.3252e+05_r8,4.5571e+01_r8/)
      kbo(:, 2,39,14) = (/ &
     &5.4370e+05_r8,4.0778e+05_r8,2.7185e+05_r8,1.3593e+05_r8,4.1350e+01_r8/)
      kbo(:, 3,39,14) = (/ &
     &5.5324e+05_r8,4.1494e+05_r8,2.7663e+05_r8,1.3831e+05_r8,3.8461e+01_r8/)
      kbo(:, 4,39,14) = (/ &
     &5.5931e+05_r8,4.1948e+05_r8,2.7966e+05_r8,1.3983e+05_r8,3.7172e+01_r8/)
      kbo(:, 5,39,14) = (/ &
     &5.6198e+05_r8,4.2149e+05_r8,2.8099e+05_r8,1.4050e+05_r8,3.5387e+01_r8/)
      kbo(:, 1,40,14) = (/ &
     &5.7962e+05_r8,4.3471e+05_r8,2.8981e+05_r8,1.4490e+05_r8,4.6708e+01_r8/)
      kbo(:, 2,40,14) = (/ &
     &5.9661e+05_r8,4.4745e+05_r8,2.9830e+05_r8,1.4915e+05_r8,4.2510e+01_r8/)
      kbo(:, 3,40,14) = (/ &
     &6.0879e+05_r8,4.5659e+05_r8,3.0439e+05_r8,1.5220e+05_r8,3.9273e+01_r8/)
      kbo(:, 4,40,14) = (/ &
     &6.1695e+05_r8,4.6271e+05_r8,3.0847e+05_r8,1.5424e+05_r8,3.8101e+01_r8/)
      kbo(:, 5,40,14) = (/ &
     &6.2122e+05_r8,4.6592e+05_r8,3.1061e+05_r8,1.5530e+05_r8,3.6493e+01_r8/)
      kbo(:, 1,41,14) = (/ &
     &6.3170e+05_r8,4.7378e+05_r8,3.1585e+05_r8,1.5793e+05_r8,4.7871e+01_r8/)
      kbo(:, 2,41,14) = (/ &
     &6.5265e+05_r8,4.8949e+05_r8,3.2633e+05_r8,1.6317e+05_r8,4.3729e+01_r8/)
      kbo(:, 3,41,14) = (/ &
     &6.6799e+05_r8,5.0099e+05_r8,3.3400e+05_r8,1.6700e+05_r8,4.0263e+01_r8/)
      kbo(:, 4,41,14) = (/ &
     &6.7856e+05_r8,5.0892e+05_r8,3.3928e+05_r8,1.6964e+05_r8,3.8971e+01_r8/)
      kbo(:, 5,41,14) = (/ &
     &6.8482e+05_r8,5.1361e+05_r8,3.4241e+05_r8,1.7121e+05_r8,3.7519e+01_r8/)
      kbo(:, 1,42,14) = (/ &
     &6.9554e+05_r8,5.2166e+05_r8,3.4777e+05_r8,1.7388e+05_r8,4.9144e+01_r8/)
      kbo(:, 2,42,14) = (/ &
     &7.2122e+05_r8,5.4091e+05_r8,3.6061e+05_r8,1.8030e+05_r8,4.4903e+01_r8/)
      kbo(:, 3,42,14) = (/ &
     &7.4054e+05_r8,5.5540e+05_r8,3.7027e+05_r8,1.8513e+05_r8,4.1239e+01_r8/)
      kbo(:, 4,42,14) = (/ &
     &7.5407e+05_r8,5.6555e+05_r8,3.7703e+05_r8,1.8852e+05_r8,4.0019e+01_r8/)
      kbo(:, 5,42,14) = (/ &
     &7.6271e+05_r8,5.7203e+05_r8,3.8135e+05_r8,1.9067e+05_r8,3.8545e+01_r8/)
      kbo(:, 1,43,14) = (/ &
     &7.7014e+05_r8,5.7761e+05_r8,3.8508e+05_r8,1.9254e+05_r8,5.0575e+01_r8/)
      kbo(:, 2,43,14) = (/ &
     &8.0215e+05_r8,6.0161e+05_r8,4.0108e+05_r8,2.0054e+05_r8,4.6180e+01_r8/)
      kbo(:, 3,43,14) = (/ &
     &8.2687e+05_r8,6.2015e+05_r8,4.1344e+05_r8,2.0672e+05_r8,4.2529e+01_r8/)
      kbo(:, 4,43,14) = (/ &
     &8.4441e+05_r8,6.3331e+05_r8,4.2221e+05_r8,2.1110e+05_r8,4.0958e+01_r8/)
      kbo(:, 5,43,14) = (/ &
     &8.5614e+05_r8,6.4211e+05_r8,4.2807e+05_r8,2.1404e+05_r8,3.9632e+01_r8/)
      kbo(:, 1,44,14) = (/ &
     &8.6239e+05_r8,6.4679e+05_r8,4.3119e+05_r8,2.1559e+05_r8,5.2080e+01_r8/)
      kbo(:, 2,44,14) = (/ &
     &9.0261e+05_r8,6.7696e+05_r8,4.5130e+05_r8,2.2565e+05_r8,4.7569e+01_r8/)
      kbo(:, 3,44,14) = (/ &
     &9.3442e+05_r8,7.0081e+05_r8,4.6721e+05_r8,2.3360e+05_r8,4.3904e+01_r8/)
      kbo(:, 4,44,14) = (/ &
     &9.5755e+05_r8,7.1816e+05_r8,4.7877e+05_r8,2.3938e+05_r8,4.2000e+01_r8/)
      kbo(:, 5,44,14) = (/ &
     &9.7341e+05_r8,7.3005e+05_r8,4.8670e+05_r8,2.4335e+05_r8,4.0861e+01_r8/)
      kbo(:, 1,45,14) = (/ &
     &9.8377e+05_r8,7.3783e+05_r8,4.9189e+05_r8,2.4594e+05_r8,5.3464e+01_r8/)
      kbo(:, 2,45,14) = (/ &
     &1.0352e+06_r8,7.7641e+05_r8,5.1760e+05_r8,2.5880e+05_r8,4.8989e+01_r8/)
      kbo(:, 3,45,14) = (/ &
     &1.0762e+06_r8,8.0713e+05_r8,5.3809e+05_r8,2.6904e+05_r8,4.5355e+01_r8/)
      kbo(:, 4,45,14) = (/ &
     &1.1070e+06_r8,8.3023e+05_r8,5.5349e+05_r8,2.7674e+05_r8,4.3217e+01_r8/)
      kbo(:, 5,45,14) = (/ &
     &1.1287e+06_r8,8.4649e+05_r8,5.6433e+05_r8,2.8216e+05_r8,4.1953e+01_r8/)
      kbo(:, 1,46,14) = (/ &
     &1.1307e+06_r8,8.4801e+05_r8,5.6534e+05_r8,2.8267e+05_r8,5.4903e+01_r8/)
      kbo(:, 2,46,14) = (/ &
     &1.1967e+06_r8,8.9750e+05_r8,5.9834e+05_r8,2.9917e+05_r8,5.0473e+01_r8/)
      kbo(:, 3,46,14) = (/ &
     &1.2497e+06_r8,9.3728e+05_r8,6.2485e+05_r8,3.1243e+05_r8,4.7017e+01_r8/)
      kbo(:, 4,46,14) = (/ &
     &1.2910e+06_r8,9.6823e+05_r8,6.4549e+05_r8,3.2274e+05_r8,4.4343e+01_r8/)
      kbo(:, 5,46,14) = (/ &
     &1.3205e+06_r8,9.9037e+05_r8,6.6025e+05_r8,3.3012e+05_r8,4.3085e+01_r8/)
      kbo(:, 1,47,14) = (/ &
     &1.2818e+06_r8,9.6133e+05_r8,6.4089e+05_r8,3.2045e+05_r8,5.6436e+01_r8/)
      kbo(:, 2,47,14) = (/ &
     &1.3655e+06_r8,1.0241e+06_r8,6.8273e+05_r8,3.4137e+05_r8,5.2412e+01_r8/)
      kbo(:, 3,47,14) = (/ &
     &1.4341e+06_r8,1.0756e+06_r8,7.1708e+05_r8,3.5854e+05_r8,4.8254e+01_r8/)
      kbo(:, 4,47,14) = (/ &
     &1.4885e+06_r8,1.1164e+06_r8,7.4427e+05_r8,3.7214e+05_r8,4.5497e+01_r8/)
      kbo(:, 5,47,14) = (/ &
     &1.5285e+06_r8,1.1464e+06_r8,7.6425e+05_r8,3.8213e+05_r8,4.4276e+01_r8/)
      kbo(:, 1,48,14) = (/ &
     &1.4912e+06_r8,1.1184e+06_r8,7.4558e+05_r8,3.7279e+05_r8,5.8070e+01_r8/)
      kbo(:, 2,48,14) = (/ &
     &1.5992e+06_r8,1.1994e+06_r8,7.9959e+05_r8,3.9979e+05_r8,5.4067e+01_r8/)
      kbo(:, 3,48,14) = (/ &
     &1.6898e+06_r8,1.2674e+06_r8,8.4492e+05_r8,4.2246e+05_r8,5.0095e+01_r8/)
      kbo(:, 4,48,14) = (/ &
     &1.7626e+06_r8,1.3220e+06_r8,8.8132e+05_r8,4.4066e+05_r8,4.6945e+01_r8/)
      kbo(:, 5,48,14) = (/ &
     &1.8180e+06_r8,1.3635e+06_r8,9.0900e+05_r8,4.5450e+05_r8,4.5438e+01_r8/)
      kbo(:, 1,49,14) = (/ &
     &1.8033e+06_r8,1.3525e+06_r8,9.0165e+05_r8,4.5083e+05_r8,5.9742e+01_r8/)
      kbo(:, 2,49,14) = (/ &
     &1.9472e+06_r8,1.4604e+06_r8,9.7361e+05_r8,4.8680e+05_r8,5.5654e+01_r8/)
      kbo(:, 3,49,14) = (/ &
     &2.0706e+06_r8,1.5529e+06_r8,1.0353e+06_r8,5.1764e+05_r8,5.1796e+01_r8/)
      kbo(:, 4,49,14) = (/ &
     &2.1711e+06_r8,1.6283e+06_r8,1.0855e+06_r8,5.4277e+05_r8,4.8429e+01_r8/)
      kbo(:, 5,49,14) = (/ &
     &2.2497e+06_r8,1.6872e+06_r8,1.1248e+06_r8,5.6241e+05_r8,4.6805e+01_r8/)
      kbo(:, 1,50,14) = (/ &
     &2.0759e+06_r8,1.5569e+06_r8,1.0379e+06_r8,5.1897e+05_r8,6.1720e+01_r8/)
      kbo(:, 2,50,14) = (/ &
     &2.2580e+06_r8,1.6935e+06_r8,1.1290e+06_r8,5.6451e+05_r8,5.7265e+01_r8/)
      kbo(:, 3,50,14) = (/ &
     &2.4154e+06_r8,1.8116e+06_r8,1.2077e+06_r8,6.0386e+05_r8,5.3335e+01_r8/)
      kbo(:, 4,50,14) = (/ &
     &2.5463e+06_r8,1.9097e+06_r8,1.2731e+06_r8,6.3657e+05_r8,5.0026e+01_r8/)
      kbo(:, 5,50,14) = (/ &
     &2.6508e+06_r8,1.9881e+06_r8,1.3254e+06_r8,6.6270e+05_r8,4.7879e+01_r8/)
      kbo(:, 1,51,14) = (/ &
     &2.3343e+06_r8,1.7507e+06_r8,1.1671e+06_r8,5.8357e+05_r8,6.3629e+01_r8/)
      kbo(:, 2,51,14) = (/ &
     &2.5583e+06_r8,1.9187e+06_r8,1.2791e+06_r8,6.3957e+05_r8,5.8823e+01_r8/)
      kbo(:, 3,51,14) = (/ &
     &2.7536e+06_r8,2.0652e+06_r8,1.3768e+06_r8,6.8840e+05_r8,5.4830e+01_r8/)
      kbo(:, 4,51,14) = (/ &
     &2.9192e+06_r8,2.1894e+06_r8,1.4596e+06_r8,7.2979e+05_r8,5.1797e+01_r8/)
      kbo(:, 5,51,14) = (/ &
     &3.0520e+06_r8,2.2890e+06_r8,1.5260e+06_r8,7.6300e+05_r8,4.8739e+01_r8/)
      kbo(:, 1,52,14) = (/ &
     &2.6927e+06_r8,2.0196e+06_r8,1.3464e+06_r8,6.7319e+05_r8,6.5473e+01_r8/)
      kbo(:, 2,52,14) = (/ &
     &2.9755e+06_r8,2.2317e+06_r8,1.4878e+06_r8,7.4389e+05_r8,6.0202e+01_r8/)
      kbo(:, 3,52,14) = (/ &
     &3.2232e+06_r8,2.4174e+06_r8,1.6116e+06_r8,8.0581e+05_r8,5.6406e+01_r8/)
      kbo(:, 4,52,14) = (/ &
     &3.4356e+06_r8,2.5767e+06_r8,1.7178e+06_r8,8.5891e+05_r8,5.3338e+01_r8/)
      kbo(:, 5,52,14) = (/ &
     &3.6105e+06_r8,2.7079e+06_r8,1.8053e+06_r8,9.0264e+05_r8,4.9535e+01_r8/)
      kbo(:, 1,53,14) = (/ &
     &3.2282e+06_r8,2.4212e+06_r8,1.6141e+06_r8,8.0707e+05_r8,6.7136e+01_r8/)
      kbo(:, 2,53,14) = (/ &
     &3.5968e+06_r8,2.6976e+06_r8,1.7984e+06_r8,8.9921e+05_r8,6.1503e+01_r8/)
      kbo(:, 3,53,14) = (/ &
     &3.9238e+06_r8,2.9429e+06_r8,1.9619e+06_r8,9.8097e+05_r8,5.8062e+01_r8/)
      kbo(:, 4,53,14) = (/ &
     &4.2071e+06_r8,3.1553e+06_r8,2.1035e+06_r8,1.0518e+06_r8,5.4982e+01_r8/)
      kbo(:, 5,53,14) = (/ &
     &4.4446e+06_r8,3.3334e+06_r8,2.2223e+06_r8,1.1112e+06_r8,5.0414e+01_r8/)
      kbo(:, 1,54,14) = (/ &
     &3.3478e+06_r8,2.5109e+06_r8,1.6739e+06_r8,8.3696e+05_r8,6.8647e+01_r8/)
      kbo(:, 2,54,14) = (/ &
     &3.7598e+06_r8,2.8199e+06_r8,1.8799e+06_r8,9.3996e+05_r8,6.3327e+01_r8/)
      kbo(:, 3,54,14) = (/ &
     &4.1308e+06_r8,3.0981e+06_r8,2.0654e+06_r8,1.0327e+06_r8,5.9705e+01_r8/)
      kbo(:, 4,54,14) = (/ &
     &4.4534e+06_r8,3.3401e+06_r8,2.2267e+06_r8,1.1134e+06_r8,5.5841e+01_r8/)
      kbo(:, 5,54,14) = (/ &
     &4.7287e+06_r8,3.5465e+06_r8,2.3644e+06_r8,1.1822e+06_r8,5.1312e+01_r8/)
      kbo(:, 1,55,14) = (/ &
     &3.1636e+06_r8,2.3727e+06_r8,1.5818e+06_r8,7.9090e+05_r8,6.9800e+01_r8/)
      kbo(:, 2,55,14) = (/ &
     &3.5827e+06_r8,2.6870e+06_r8,1.7914e+06_r8,8.9569e+05_r8,6.5650e+01_r8/)
      kbo(:, 3,55,14) = (/ &
     &3.9638e+06_r8,2.9728e+06_r8,1.9819e+06_r8,9.9095e+05_r8,6.0566e+01_r8/)
      kbo(:, 4,55,14) = (/ &
     &4.2985e+06_r8,3.2239e+06_r8,2.1493e+06_r8,1.0746e+06_r8,5.6657e+01_r8/)
      kbo(:, 5,55,14) = (/ &
     &4.5858e+06_r8,3.4394e+06_r8,2.2929e+06_r8,1.1465e+06_r8,5.3531e+01_r8/)
      kbo(:, 1,56,14) = (/ &
     &2.9822e+06_r8,2.2367e+06_r8,1.4911e+06_r8,7.4555e+05_r8,7.1031e+01_r8/)
      kbo(:, 2,56,14) = (/ &
     &3.4067e+06_r8,2.5550e+06_r8,1.7033e+06_r8,8.5166e+05_r8,6.7133e+01_r8/)
      kbo(:, 3,56,14) = (/ &
     &3.7967e+06_r8,2.8475e+06_r8,1.8983e+06_r8,9.4915e+05_r8,6.1784e+01_r8/)
      kbo(:, 4,56,14) = (/ &
     &4.1424e+06_r8,3.1068e+06_r8,2.0712e+06_r8,1.0356e+06_r8,5.8142e+01_r8/)
      kbo(:, 5,56,14) = (/ &
     &4.4422e+06_r8,3.3317e+06_r8,2.2211e+06_r8,1.1105e+06_r8,5.4348e+01_r8/)
      kbo(:, 1,57,14) = (/ &
     &2.8003e+06_r8,2.1002e+06_r8,1.4001e+06_r8,7.0006e+05_r8,7.2686e+01_r8/)
      kbo(:, 2,57,14) = (/ &
     &3.2322e+06_r8,2.4241e+06_r8,1.6161e+06_r8,8.0804e+05_r8,6.8121e+01_r8/)
      kbo(:, 3,57,14) = (/ &
     &3.6290e+06_r8,2.7217e+06_r8,1.8145e+06_r8,9.0724e+05_r8,6.3933e+01_r8/)
      kbo(:, 4,57,14) = (/ &
     &3.9857e+06_r8,2.9893e+06_r8,1.9928e+06_r8,9.9642e+05_r8,5.9242e+01_r8/)
      kbo(:, 5,57,14) = (/ &
     &4.2966e+06_r8,3.2224e+06_r8,2.1482e+06_r8,1.0741e+06_r8,5.5180e+01_r8/)
      kbo(:, 1,58,14) = (/ &
     &6.9277e+05_r8,6.3516e+05_r8,5.4460e+05_r8,3.8143e+05_r8,7.4521e+01_r8/)
      kbo(:, 2,58,14) = (/ &
     &8.0841e+05_r8,7.4119e+05_r8,6.3550e+05_r8,4.4510e+05_r8,6.9466e+01_r8/)
      kbo(:, 3,58,14) = (/ &
     &9.1451e+05_r8,8.3847e+05_r8,7.1891e+05_r8,5.0352e+05_r8,6.5445e+01_r8/)
      kbo(:, 4,58,14) = (/ &
     &1.0112e+06_r8,9.2715e+05_r8,7.9494e+05_r8,5.5677e+05_r8,6.0252e+01_r8/)
      kbo(:, 5,58,14) = (/ &
     &1.0957e+06_r8,1.0046e+06_r8,8.6135e+05_r8,6.0328e+05_r8,5.6261e+01_r8/)
      kbo(:, 1,59,14) = (/ &
     &7.9105e+05_r8,6.9072e+05_r8,5.5096e+05_r8,3.4284e+05_r8,7.5082e+01_r8/)
      kbo(:, 2,59,14) = (/ &
     &9.2759e+05_r8,8.0994e+05_r8,6.4605e+05_r8,4.0201e+05_r8,7.0591e+01_r8/)
      kbo(:, 3,59,14) = (/ &
     &1.0529e+06_r8,9.1931e+05_r8,7.3330e+05_r8,4.5630e+05_r8,6.5689e+01_r8/)
      kbo(:, 4,59,14) = (/ &
     &1.1673e+06_r8,1.0193e+06_r8,8.1302e+05_r8,5.0591e+05_r8,6.1427e+01_r8/)
      kbo(:, 5,59,14) = (/ &
     &1.2680e+06_r8,1.1071e+06_r8,8.8311e+05_r8,5.4953e+05_r8,5.7108e+01_r8/)
      kbo(:, 1,13,15) = (/ &
     &6.8853e+05_r8,5.1640e+05_r8,3.4427e+05_r8,1.7213e+05_r8,8.3646e+00_r8/)
      kbo(:, 2,13,15) = (/ &
     &6.7841e+05_r8,5.0881e+05_r8,3.3921e+05_r8,1.6961e+05_r8,8.1557e+00_r8/)
      kbo(:, 3,13,15) = (/ &
     &6.7058e+05_r8,5.0293e+05_r8,3.3529e+05_r8,1.6765e+05_r8,7.2355e+00_r8/)
      kbo(:, 4,13,15) = (/ &
     &6.6505e+05_r8,4.9879e+05_r8,3.3253e+05_r8,1.6627e+05_r8,7.1104e+00_r8/)
      kbo(:, 5,13,15) = (/ &
     &6.5977e+05_r8,4.9483e+05_r8,3.2989e+05_r8,1.6494e+05_r8,5.0356e+00_r8/)
      kbo(:, 1,14,15) = (/ &
     &4.8859e+05_r8,3.6644e+05_r8,2.4429e+05_r8,1.2215e+05_r8,9.3416e+00_r8/)
      kbo(:, 2,14,15) = (/ &
     &4.8530e+05_r8,3.6397e+05_r8,2.4265e+05_r8,1.2132e+05_r8,9.0997e+00_r8/)
      kbo(:, 3,14,15) = (/ &
     &4.8323e+05_r8,3.6243e+05_r8,2.4161e+05_r8,1.2081e+05_r8,8.4842e+00_r8/)
      kbo(:, 4,14,15) = (/ &
     &4.8076e+05_r8,3.6057e+05_r8,2.4038e+05_r8,1.2019e+05_r8,8.2141e+00_r8/)
      kbo(:, 5,14,15) = (/ &
     &4.7824e+05_r8,3.5868e+05_r8,2.3912e+05_r8,1.1956e+05_r8,7.9624e+00_r8/)
      kbo(:, 1,15,15) = (/ &
     &3.5725e+05_r8,2.6794e+05_r8,1.7863e+05_r8,8.9315e+04_r8,1.0416e+01_r8/)
      kbo(:, 2,15,15) = (/ &
     &3.5701e+05_r8,2.6776e+05_r8,1.7851e+05_r8,8.9255e+04_r8,1.0132e+01_r8/)
      kbo(:, 3,15,15) = (/ &
     &3.5620e+05_r8,2.6715e+05_r8,1.7810e+05_r8,8.9053e+04_r8,9.8342e+00_r8/)
      kbo(:, 4,15,15) = (/ &
     &3.5534e+05_r8,2.6651e+05_r8,1.7767e+05_r8,8.8838e+04_r8,8.7353e+00_r8/)
      kbo(:, 5,15,15) = (/ &
     &3.5411e+05_r8,2.6559e+05_r8,1.7706e+05_r8,8.8531e+04_r8,9.0528e+00_r8/)
      kbo(:, 1,16,15) = (/ &
     &3.1303e+05_r8,2.3478e+05_r8,1.5652e+05_r8,7.8260e+04_r8,1.1678e+01_r8/)
      kbo(:, 2,16,15) = (/ &
     &3.1296e+05_r8,2.3472e+05_r8,1.5648e+05_r8,7.8243e+04_r8,1.1373e+01_r8/)
      kbo(:, 3,16,15) = (/ &
     &3.1311e+05_r8,2.3483e+05_r8,1.5655e+05_r8,7.8278e+04_r8,1.1063e+01_r8/)
      kbo(:, 4,16,15) = (/ &
     &3.1270e+05_r8,2.3452e+05_r8,1.5635e+05_r8,7.8176e+04_r8,1.0185e+01_r8/)
      kbo(:, 5,16,15) = (/ &
     &3.1216e+05_r8,2.3412e+05_r8,1.5608e+05_r8,7.8040e+04_r8,1.0166e+01_r8/)
      kbo(:, 1,17,15) = (/ &
     &2.8440e+05_r8,2.1330e+05_r8,1.4220e+05_r8,7.1101e+04_r8,1.3334e+01_r8/)
      kbo(:, 2,17,15) = (/ &
     &2.8479e+05_r8,2.1359e+05_r8,1.4240e+05_r8,7.1199e+04_r8,1.2996e+01_r8/)
      kbo(:, 3,17,15) = (/ &
     &2.8480e+05_r8,2.1360e+05_r8,1.4240e+05_r8,7.1202e+04_r8,1.2651e+01_r8/)
      kbo(:, 4,17,15) = (/ &
     &2.8481e+05_r8,2.1361e+05_r8,1.4240e+05_r8,7.1203e+04_r8,1.1964e+01_r8/)
      kbo(:, 5,17,15) = (/ &
     &2.8402e+05_r8,2.1301e+05_r8,1.4201e+05_r8,7.1006e+04_r8,1.1649e+01_r8/)
      kbo(:, 1,18,15) = (/ &
     &2.6460e+05_r8,1.9845e+05_r8,1.3230e+05_r8,6.6150e+04_r8,1.5350e+01_r8/)
      kbo(:, 2,18,15) = (/ &
     &2.6490e+05_r8,1.9868e+05_r8,1.3245e+05_r8,6.6227e+04_r8,1.4954e+01_r8/)
      kbo(:, 3,18,15) = (/ &
     &2.6505e+05_r8,1.9879e+05_r8,1.3252e+05_r8,6.6263e+04_r8,1.4553e+01_r8/)
      kbo(:, 4,18,15) = (/ &
     &2.6448e+05_r8,1.9836e+05_r8,1.3224e+05_r8,6.6121e+04_r8,1.4057e+01_r8/)
      kbo(:, 5,18,15) = (/ &
     &2.6357e+05_r8,1.9768e+05_r8,1.3179e+05_r8,6.5894e+04_r8,1.3341e+01_r8/)
      kbo(:, 1,19,15) = (/ &
     &2.4108e+05_r8,1.8081e+05_r8,1.2054e+05_r8,6.0272e+04_r8,1.7626e+01_r8/)
      kbo(:, 2,19,15) = (/ &
     &2.4160e+05_r8,1.8120e+05_r8,1.2080e+05_r8,6.0400e+04_r8,1.7162e+01_r8/)
      kbo(:, 3,19,15) = (/ &
     &2.4138e+05_r8,1.8103e+05_r8,1.2069e+05_r8,6.0347e+04_r8,1.6660e+01_r8/)
      kbo(:, 4,19,15) = (/ &
     &2.4078e+05_r8,1.8058e+05_r8,1.2039e+05_r8,6.0195e+04_r8,1.6133e+01_r8/)
      kbo(:, 5,19,15) = (/ &
     &2.3956e+05_r8,1.7967e+05_r8,1.1978e+05_r8,5.9892e+04_r8,1.5032e+01_r8/)
      kbo(:, 1,20,15) = (/ &
     &2.3801e+05_r8,1.7851e+05_r8,1.1901e+05_r8,5.9503e+04_r8,2.0107e+01_r8/)
      kbo(:, 2,20,15) = (/ &
     &2.3824e+05_r8,1.7868e+05_r8,1.1912e+05_r8,5.9560e+04_r8,1.9545e+01_r8/)
      kbo(:, 3,20,15) = (/ &
     &2.3790e+05_r8,1.7842e+05_r8,1.1895e+05_r8,5.9475e+04_r8,1.8935e+01_r8/)
      kbo(:, 4,20,15) = (/ &
     &2.3694e+05_r8,1.7770e+05_r8,1.1847e+05_r8,5.9235e+04_r8,1.8318e+01_r8/)
      kbo(:, 5,20,15) = (/ &
     &2.3546e+05_r8,1.7659e+05_r8,1.1773e+05_r8,5.8866e+04_r8,1.6971e+01_r8/)
      kbo(:, 1,21,15) = (/ &
     &2.4153e+05_r8,1.8115e+05_r8,1.2077e+05_r8,6.0385e+04_r8,2.2844e+01_r8/)
      kbo(:, 2,21,15) = (/ &
     &2.4153e+05_r8,1.8115e+05_r8,1.2076e+05_r8,6.0383e+04_r8,2.2202e+01_r8/)
      kbo(:, 3,21,15) = (/ &
     &2.4090e+05_r8,1.8068e+05_r8,1.2045e+05_r8,6.0226e+04_r8,2.1535e+01_r8/)
      kbo(:, 4,21,15) = (/ &
     &2.3957e+05_r8,1.7968e+05_r8,1.1978e+05_r8,5.9893e+04_r8,2.0842e+01_r8/)
      kbo(:, 5,21,15) = (/ &
     &2.3762e+05_r8,1.7822e+05_r8,1.1881e+05_r8,5.9406e+04_r8,1.9479e+01_r8/)
      kbo(:, 1,22,15) = (/ &
     &2.5014e+05_r8,1.8760e+05_r8,1.2507e+05_r8,6.2536e+04_r8,2.6039e+01_r8/)
      kbo(:, 2,22,15) = (/ &
     &2.4958e+05_r8,1.8719e+05_r8,1.2479e+05_r8,6.2397e+04_r8,2.5280e+01_r8/)
      kbo(:, 3,22,15) = (/ &
     &2.4838e+05_r8,1.8628e+05_r8,1.2419e+05_r8,6.2096e+04_r8,2.4490e+01_r8/)
      kbo(:, 4,22,15) = (/ &
     &2.4655e+05_r8,1.8492e+05_r8,1.2328e+05_r8,6.1639e+04_r8,2.3671e+01_r8/)
      kbo(:, 5,22,15) = (/ &
     &2.4402e+05_r8,1.8302e+05_r8,1.2201e+05_r8,6.1006e+04_r8,2.2182e+01_r8/)
      kbo(:, 1,23,15) = (/ &
     &2.5892e+05_r8,1.9419e+05_r8,1.2946e+05_r8,6.4730e+04_r8,2.9635e+01_r8/)
      kbo(:, 2,23,15) = (/ &
     &2.5767e+05_r8,1.9325e+05_r8,1.2883e+05_r8,6.4418e+04_r8,2.8708e+01_r8/)
      kbo(:, 3,23,15) = (/ &
     &2.5584e+05_r8,1.9188e+05_r8,1.2792e+05_r8,6.3960e+04_r8,2.7743e+01_r8/)
      kbo(:, 4,23,15) = (/ &
     &2.5321e+05_r8,1.8991e+05_r8,1.2660e+05_r8,6.3303e+04_r8,2.6764e+01_r8/)
      kbo(:, 5,23,15) = (/ &
     &2.5010e+05_r8,1.8758e+05_r8,1.2505e+05_r8,6.2526e+04_r8,2.5122e+01_r8/)
      kbo(:, 1,24,15) = (/ &
     &2.6502e+05_r8,1.9877e+05_r8,1.3251e+05_r8,6.6257e+04_r8,3.3543e+01_r8/)
      kbo(:, 2,24,15) = (/ &
     &2.6308e+05_r8,1.9731e+05_r8,1.3154e+05_r8,6.5771e+04_r8,3.2390e+01_r8/)
      kbo(:, 3,24,15) = (/ &
     &2.6033e+05_r8,1.9524e+05_r8,1.3016e+05_r8,6.5082e+04_r8,3.1202e+01_r8/)
      kbo(:, 4,24,15) = (/ &
     &2.5704e+05_r8,1.9278e+05_r8,1.2852e+05_r8,6.4262e+04_r8,3.0027e+01_r8/)
      kbo(:, 5,24,15) = (/ &
     &2.5313e+05_r8,1.8984e+05_r8,1.2656e+05_r8,6.3282e+04_r8,2.8238e+01_r8/)
      kbo(:, 1,25,15) = (/ &
     &2.7306e+05_r8,2.0480e+05_r8,1.3653e+05_r8,6.8266e+04_r8,3.7656e+01_r8/)
      kbo(:, 2,25,15) = (/ &
     &2.7003e+05_r8,2.0252e+05_r8,1.3501e+05_r8,6.7507e+04_r8,3.6233e+01_r8/)
      kbo(:, 3,25,15) = (/ &
     &2.6644e+05_r8,1.9983e+05_r8,1.3322e+05_r8,6.6611e+04_r8,3.4804e+01_r8/)
      kbo(:, 4,25,15) = (/ &
     &2.6230e+05_r8,1.9672e+05_r8,1.3115e+05_r8,6.5574e+04_r8,3.3361e+01_r8/)
      kbo(:, 5,25,15) = (/ &
     &2.5745e+05_r8,1.9309e+05_r8,1.2873e+05_r8,6.4363e+04_r8,3.1338e+01_r8/)
      kbo(:, 1,26,15) = (/ &
     &2.8347e+05_r8,2.1261e+05_r8,1.4174e+05_r8,7.0869e+04_r8,4.1820e+01_r8/)
      kbo(:, 2,26,15) = (/ &
     &2.7951e+05_r8,2.0963e+05_r8,1.3976e+05_r8,6.9878e+04_r8,4.0076e+01_r8/)
      kbo(:, 3,26,15) = (/ &
     &2.7489e+05_r8,2.0617e+05_r8,1.3745e+05_r8,6.8723e+04_r8,3.8351e+01_r8/)
      kbo(:, 4,26,15) = (/ &
     &2.6958e+05_r8,2.0219e+05_r8,1.3479e+05_r8,6.7396e+04_r8,3.6631e+01_r8/)
      kbo(:, 5,26,15) = (/ &
     &2.6383e+05_r8,1.9788e+05_r8,1.3192e+05_r8,6.5959e+04_r8,3.4286e+01_r8/)
      kbo(:, 1,27,15) = (/ &
     &3.0277e+05_r8,2.2708e+05_r8,1.5139e+05_r8,7.5694e+04_r8,4.5895e+01_r8/)
      kbo(:, 2,27,15) = (/ &
     &2.9771e+05_r8,2.2329e+05_r8,1.4886e+05_r8,7.4429e+04_r8,4.3819e+01_r8/)
      kbo(:, 3,27,15) = (/ &
     &2.9175e+05_r8,2.1881e+05_r8,1.4587e+05_r8,7.2938e+04_r8,4.1746e+01_r8/)
      kbo(:, 4,27,15) = (/ &
     &2.8521e+05_r8,2.1391e+05_r8,1.4261e+05_r8,7.1304e+04_r8,3.9720e+01_r8/)
      kbo(:, 5,27,15) = (/ &
     &2.7826e+05_r8,2.0870e+05_r8,1.3913e+05_r8,6.9566e+04_r8,3.6964e+01_r8/)
      kbo(:, 1,28,15) = (/ &
     &3.2897e+05_r8,2.4673e+05_r8,1.6449e+05_r8,8.2243e+04_r8,4.9767e+01_r8/)
      kbo(:, 2,28,15) = (/ &
     &3.2244e+05_r8,2.4183e+05_r8,1.6122e+05_r8,8.0610e+04_r8,4.7309e+01_r8/)
      kbo(:, 3,28,15) = (/ &
     &3.1503e+05_r8,2.3628e+05_r8,1.5752e+05_r8,7.8759e+04_r8,4.4889e+01_r8/)
      kbo(:, 4,28,15) = (/ &
     &3.0709e+05_r8,2.3032e+05_r8,1.5355e+05_r8,7.6774e+04_r8,4.2541e+01_r8/)
      kbo(:, 5,28,15) = (/ &
     &2.9858e+05_r8,2.2393e+05_r8,1.4929e+05_r8,7.4645e+04_r8,3.9310e+01_r8/)
      kbo(:, 1,29,15) = (/ &
     &3.7585e+05_r8,2.8188e+05_r8,1.8792e+05_r8,9.3962e+04_r8,5.3281e+01_r8/)
      kbo(:, 2,29,15) = (/ &
     &3.6712e+05_r8,2.7534e+05_r8,1.8356e+05_r8,9.1780e+04_r8,5.0424e+01_r8/)
      kbo(:, 3,29,15) = (/ &
     &3.5767e+05_r8,2.6826e+05_r8,1.7884e+05_r8,8.9419e+04_r8,4.7662e+01_r8/)
      kbo(:, 4,29,15) = (/ &
     &3.4765e+05_r8,2.6073e+05_r8,1.7382e+05_r8,8.6912e+04_r8,4.4800e+01_r8/)
      kbo(:, 5,29,15) = (/ &
     &3.3714e+05_r8,2.5285e+05_r8,1.6857e+05_r8,8.4284e+04_r8,4.1166e+01_r8/)
      kbo(:, 1,30,15) = (/ &
     &4.3604e+05_r8,3.2703e+05_r8,2.1802e+05_r8,1.0901e+05_r8,5.6346e+01_r8/)
      kbo(:, 2,30,15) = (/ &
     &4.2462e+05_r8,3.1847e+05_r8,2.1231e+05_r8,1.0616e+05_r8,5.3119e+01_r8/)
      kbo(:, 3,30,15) = (/ &
     &4.1259e+05_r8,3.0944e+05_r8,2.0629e+05_r8,1.0315e+05_r8,5.0028e+01_r8/)
      kbo(:, 4,30,15) = (/ &
     &3.9989e+05_r8,2.9992e+05_r8,1.9995e+05_r8,9.9973e+04_r8,4.6067e+01_r8/)
      kbo(:, 5,30,15) = (/ &
     &3.8696e+05_r8,2.9022e+05_r8,1.9348e+05_r8,9.6741e+04_r8,4.3622e+01_r8/)
      kbo(:, 1,31,15) = (/ &
     &5.2737e+05_r8,3.9553e+05_r8,2.6369e+05_r8,1.3184e+05_r8,5.8898e+01_r8/)
      kbo(:, 2,31,15) = (/ &
     &5.1226e+05_r8,3.8420e+05_r8,2.5613e+05_r8,1.2807e+05_r8,5.5332e+01_r8/)
      kbo(:, 3,31,15) = (/ &
     &4.9638e+05_r8,3.7229e+05_r8,2.4819e+05_r8,1.2410e+05_r8,5.1303e+01_r8/)
      kbo(:, 4,31,15) = (/ &
     &4.8006e+05_r8,3.6004e+05_r8,2.4003e+05_r8,1.2001e+05_r8,4.7154e+01_r8/)
      kbo(:, 5,31,15) = (/ &
     &4.6345e+05_r8,3.4759e+05_r8,2.3173e+05_r8,1.1586e+05_r8,4.5673e+01_r8/)
      kbo(:, 1,32,15) = (/ &
     &6.4038e+05_r8,4.8028e+05_r8,3.2019e+05_r8,1.6010e+05_r8,6.0926e+01_r8/)
      kbo(:, 2,32,15) = (/ &
     &6.2037e+05_r8,4.6528e+05_r8,3.1019e+05_r8,1.5509e+05_r8,5.7062e+01_r8/)
      kbo(:, 3,32,15) = (/ &
     &5.9976e+05_r8,4.4982e+05_r8,2.9988e+05_r8,1.4994e+05_r8,5.1911e+01_r8/)
      kbo(:, 4,32,15) = (/ &
     &5.7886e+05_r8,4.3415e+05_r8,2.8943e+05_r8,1.4472e+05_r8,4.9758e+01_r8/)
      kbo(:, 5,32,15) = (/ &
     &5.5779e+05_r8,4.1835e+05_r8,2.7890e+05_r8,1.3945e+05_r8,4.7124e+01_r8/)
      kbo(:, 1,33,15) = (/ &
     &7.8604e+05_r8,5.8953e+05_r8,3.9302e+05_r8,1.9651e+05_r8,6.2449e+01_r8/)
      kbo(:, 2,33,15) = (/ &
     &7.5994e+05_r8,5.6995e+05_r8,3.7997e+05_r8,1.8999e+05_r8,5.7026e+01_r8/)
      kbo(:, 3,33,15) = (/ &
     &7.3324e+05_r8,5.4993e+05_r8,3.6662e+05_r8,1.8331e+05_r8,5.3959e+01_r8/)
      kbo(:, 4,33,15) = (/ &
     &7.0633e+05_r8,5.2975e+05_r8,3.5316e+05_r8,1.7658e+05_r8,5.1185e+01_r8/)
      kbo(:, 5,33,15) = (/ &
     &6.7933e+05_r8,5.0950e+05_r8,3.3967e+05_r8,1.6983e+05_r8,4.6145e+01_r8/)
      kbo(:, 1,34,15) = (/ &
     &9.3629e+05_r8,7.0222e+05_r8,4.6814e+05_r8,2.3407e+05_r8,6.2950e+01_r8/)
      kbo(:, 2,34,15) = (/ &
     &9.0361e+05_r8,6.7770e+05_r8,4.5180e+05_r8,2.2590e+05_r8,5.7628e+01_r8/)
      kbo(:, 3,34,15) = (/ &
     &8.7048e+05_r8,6.5286e+05_r8,4.3524e+05_r8,2.1762e+05_r8,5.5397e+01_r8/)
      kbo(:, 4,34,15) = (/ &
     &8.3718e+05_r8,6.2788e+05_r8,4.1859e+05_r8,2.0929e+05_r8,5.1885e+01_r8/)
      kbo(:, 5,34,15) = (/ &
     &8.0393e+05_r8,6.0294e+05_r8,4.0196e+05_r8,2.0098e+05_r8,4.4833e+01_r8/)
      kbo(:, 1,35,15) = (/ &
     &1.1151e+06_r8,8.3633e+05_r8,5.5755e+05_r8,2.7878e+05_r8,6.3401e+01_r8/)
      kbo(:, 2,35,15) = (/ &
     &1.0748e+06_r8,8.0608e+05_r8,5.3739e+05_r8,2.6869e+05_r8,5.9975e+01_r8/)
      kbo(:, 3,35,15) = (/ &
     &1.0341e+06_r8,7.7556e+05_r8,5.1704e+05_r8,2.5852e+05_r8,5.6633e+01_r8/)
      kbo(:, 4,35,15) = (/ &
     &9.9325e+05_r8,7.4494e+05_r8,4.9662e+05_r8,2.4831e+05_r8,5.0172e+01_r8/)
      kbo(:, 5,35,15) = (/ &
     &9.5274e+05_r8,7.1455e+05_r8,4.7637e+05_r8,2.3818e+05_r8,4.3180e+01_r8/)
      kbo(:, 1,36,15) = (/ &
     &1.3204e+06_r8,9.9032e+05_r8,6.6021e+05_r8,3.3011e+05_r8,6.4479e+01_r8/)
      kbo(:, 2,36,15) = (/ &
     &1.2713e+06_r8,9.5347e+05_r8,6.3565e+05_r8,3.1782e+05_r8,6.1661e+01_r8/)
      kbo(:, 3,36,15) = (/ &
     &1.2219e+06_r8,9.1640e+05_r8,6.1093e+05_r8,3.0547e+05_r8,5.7543e+01_r8/)
      kbo(:, 4,36,15) = (/ &
     &1.1726e+06_r8,8.7947e+05_r8,5.8632e+05_r8,2.9316e+05_r8,4.9268e+01_r8/)
      kbo(:, 5,36,15) = (/ &
     &1.1240e+06_r8,8.4303e+05_r8,5.6202e+05_r8,2.8101e+05_r8,4.3422e+01_r8/)
      kbo(:, 1,37,15) = (/ &
     &1.5283e+06_r8,1.1462e+06_r8,7.6413e+05_r8,3.8207e+05_r8,6.6367e+01_r8/)
      kbo(:, 2,37,15) = (/ &
     &1.4706e+06_r8,1.1030e+06_r8,7.3532e+05_r8,3.6766e+05_r8,6.3620e+01_r8/)
      kbo(:, 3,37,15) = (/ &
     &1.4128e+06_r8,1.0596e+06_r8,7.0638e+05_r8,3.5319e+05_r8,5.8851e+01_r8/)
      kbo(:, 4,37,15) = (/ &
     &1.3549e+06_r8,1.0162e+06_r8,6.7744e+05_r8,3.3872e+05_r8,4.8460e+01_r8/)
      kbo(:, 5,37,15) = (/ &
     &1.2980e+06_r8,9.7352e+05_r8,6.4901e+05_r8,3.2451e+05_r8,4.3139e+01_r8/)
      kbo(:, 1,38,15) = (/ &
     &1.7917e+06_r8,1.3437e+06_r8,8.9582e+05_r8,4.4791e+05_r8,6.8827e+01_r8/)
      kbo(:, 2,38,15) = (/ &
     &1.7232e+06_r8,1.2924e+06_r8,8.6157e+05_r8,4.3078e+05_r8,6.5495e+01_r8/)
      kbo(:, 3,38,15) = (/ &
     &1.6545e+06_r8,1.2409e+06_r8,8.2724e+05_r8,4.1362e+05_r8,5.8860e+01_r8/)
      kbo(:, 4,38,15) = (/ &
     &1.5862e+06_r8,1.1896e+06_r8,7.9309e+05_r8,3.9654e+05_r8,4.7251e+01_r8/)
      kbo(:, 5,38,15) = (/ &
     &1.5188e+06_r8,1.1391e+06_r8,7.5940e+05_r8,3.7970e+05_r8,4.3731e+01_r8/)
      kbo(:, 1,39,15) = (/ &
     &2.1445e+06_r8,1.6084e+06_r8,1.0723e+06_r8,5.3613e+05_r8,7.1068e+01_r8/)
      kbo(:, 2,39,15) = (/ &
     &2.0613e+06_r8,1.5460e+06_r8,1.0307e+06_r8,5.1533e+05_r8,6.6419e+01_r8/)
      kbo(:, 3,39,15) = (/ &
     &1.9786e+06_r8,1.4840e+06_r8,9.8932e+05_r8,4.9466e+05_r8,5.6988e+01_r8/)
      kbo(:, 4,39,15) = (/ &
     &1.8964e+06_r8,1.4223e+06_r8,9.4822e+05_r8,4.7411e+05_r8,4.6537e+01_r8/)
      kbo(:, 5,39,15) = (/ &
     &1.8152e+06_r8,1.3614e+06_r8,9.0762e+05_r8,4.5381e+05_r8,4.1463e+01_r8/)
      kbo(:, 1,40,15) = (/ &
     &2.4170e+06_r8,1.8127e+06_r8,1.2085e+06_r8,6.0424e+05_r8,7.3096e+01_r8/)
      kbo(:, 2,40,15) = (/ &
     &2.3226e+06_r8,1.7420e+06_r8,1.1613e+06_r8,5.8063e+05_r8,6.8150e+01_r8/)
      kbo(:, 3,40,15) = (/ &
     &2.2296e+06_r8,1.6722e+06_r8,1.1148e+06_r8,5.5739e+05_r8,5.8979e+01_r8/)
      kbo(:, 4,40,15) = (/ &
     &2.1366e+06_r8,1.6025e+06_r8,1.0683e+06_r8,5.3415e+05_r8,4.7816e+01_r8/)
      kbo(:, 5,40,15) = (/ &
     &2.0448e+06_r8,1.5336e+06_r8,1.0224e+06_r8,5.1120e+05_r8,4.2008e+01_r8/)
      kbo(:, 1,41,15) = (/ &
     &2.7164e+06_r8,2.0373e+06_r8,1.3582e+06_r8,6.7911e+05_r8,7.4782e+01_r8/)
      kbo(:, 2,41,15) = (/ &
     &2.6095e+06_r8,1.9571e+06_r8,1.3048e+06_r8,6.5238e+05_r8,6.9972e+01_r8/)
      kbo(:, 3,41,15) = (/ &
     &2.5049e+06_r8,1.8787e+06_r8,1.2525e+06_r8,6.2623e+05_r8,6.0957e+01_r8/)
      kbo(:, 4,41,15) = (/ &
     &2.4006e+06_r8,1.8005e+06_r8,1.2003e+06_r8,6.0017e+05_r8,4.9097e+01_r8/)
      kbo(:, 5,41,15) = (/ &
     &2.2975e+06_r8,1.7231e+06_r8,1.1487e+06_r8,5.7438e+05_r8,4.2980e+01_r8/)
      kbo(:, 1,42,15) = (/ &
     &3.0827e+06_r8,2.3120e+06_r8,1.5413e+06_r8,7.7067e+05_r8,7.6123e+01_r8/)
      kbo(:, 2,42,15) = (/ &
     &2.9612e+06_r8,2.2209e+06_r8,1.4806e+06_r8,7.4030e+05_r8,7.1662e+01_r8/)
      kbo(:, 3,42,15) = (/ &
     &2.8423e+06_r8,2.1317e+06_r8,1.4211e+06_r8,7.1056e+05_r8,6.2602e+01_r8/)
      kbo(:, 4,42,15) = (/ &
     &2.7244e+06_r8,2.0433e+06_r8,1.3622e+06_r8,6.8108e+05_r8,5.0093e+01_r8/)
      kbo(:, 5,42,15) = (/ &
     &2.6071e+06_r8,1.9553e+06_r8,1.3035e+06_r8,6.5176e+05_r8,4.3774e+01_r8/)
      kbo(:, 1,43,15) = (/ &
     &3.5341e+06_r8,2.6506e+06_r8,1.7671e+06_r8,8.8353e+05_r8,7.8436e+01_r8/)
      kbo(:, 2,43,15) = (/ &
     &3.3959e+06_r8,2.5467e+06_r8,1.6978e+06_r8,8.4891e+05_r8,7.3775e+01_r8/)
      kbo(:, 3,43,15) = (/ &
     &3.2585e+06_r8,2.4439e+06_r8,1.6293e+06_r8,8.1464e+05_r8,6.4695e+01_r8/)
      kbo(:, 4,43,15) = (/ &
     &3.1244e+06_r8,2.3433e+06_r8,1.5622e+06_r8,7.8111e+05_r8,5.1912e+01_r8/)
      kbo(:, 5,43,15) = (/ &
     &2.9906e+06_r8,2.2429e+06_r8,1.4953e+06_r8,7.4765e+05_r8,4.5444e+01_r8/)
      kbo(:, 1,44,15) = (/ &
     &4.1097e+06_r8,3.0823e+06_r8,2.0548e+06_r8,1.0274e+06_r8,8.1119e+01_r8/)
      kbo(:, 2,44,15) = (/ &
     &3.9487e+06_r8,2.9615e+06_r8,1.9743e+06_r8,9.8717e+05_r8,7.5797e+01_r8/)
      kbo(:, 3,44,15) = (/ &
     &3.7894e+06_r8,2.8420e+06_r8,1.8947e+06_r8,9.4733e+05_r8,6.6793e+01_r8/)
      kbo(:, 4,44,15) = (/ &
     &3.6341e+06_r8,2.7256e+06_r8,1.8170e+06_r8,9.0851e+05_r8,5.3433e+01_r8/)
      kbo(:, 5,44,15) = (/ &
     &3.4797e+06_r8,2.6097e+06_r8,1.7398e+06_r8,8.6990e+05_r8,4.7406e+01_r8/)
      kbo(:, 1,45,15) = (/ &
     &4.8722e+06_r8,3.6542e+06_r8,2.4361e+06_r8,1.2181e+06_r8,8.3949e+01_r8/)
      kbo(:, 2,45,15) = (/ &
     &4.6827e+06_r8,3.5120e+06_r8,2.3413e+06_r8,1.1707e+06_r8,7.7974e+01_r8/)
      kbo(:, 3,45,15) = (/ &
     &4.4945e+06_r8,3.3709e+06_r8,2.2473e+06_r8,1.1236e+06_r8,6.9073e+01_r8/)
      kbo(:, 4,45,15) = (/ &
     &4.3103e+06_r8,3.2327e+06_r8,2.1551e+06_r8,1.0776e+06_r8,5.6213e+01_r8/)
      kbo(:, 5,45,15) = (/ &
     &4.1290e+06_r8,3.0968e+06_r8,2.0645e+06_r8,1.0323e+06_r8,4.8762e+01_r8/)
      kbo(:, 1,46,15) = (/ &
     &5.8372e+06_r8,4.3779e+06_r8,2.9186e+06_r8,1.4593e+06_r8,8.7007e+01_r8/)
      kbo(:, 2,46,15) = (/ &
     &5.6126e+06_r8,4.2094e+06_r8,2.8063e+06_r8,1.4031e+06_r8,8.0166e+01_r8/)
      kbo(:, 3,46,15) = (/ &
     &5.3885e+06_r8,4.0414e+06_r8,2.6943e+06_r8,1.3471e+06_r8,7.0991e+01_r8/)
      kbo(:, 4,46,15) = (/ &
     &5.1687e+06_r8,3.8765e+06_r8,2.5843e+06_r8,1.2922e+06_r8,5.9015e+01_r8/)
      kbo(:, 5,46,15) = (/ &
     &4.9529e+06_r8,3.7147e+06_r8,2.4764e+06_r8,1.2382e+06_r8,5.0566e+01_r8/)
      kbo(:, 1,47,15) = (/ &
     &6.9385e+06_r8,5.2039e+06_r8,3.4693e+06_r8,1.7346e+06_r8,9.1194e+01_r8/)
      kbo(:, 2,47,15) = (/ &
     &6.6774e+06_r8,5.0081e+06_r8,3.3387e+06_r8,1.6694e+06_r8,8.2417e+01_r8/)
      kbo(:, 3,47,15) = (/ &
     &6.4127e+06_r8,4.8095e+06_r8,3.2064e+06_r8,1.6032e+06_r8,7.5225e+01_r8/)
      kbo(:, 4,47,15) = (/ &
     &6.1518e+06_r8,4.6139e+06_r8,3.0759e+06_r8,1.5380e+06_r8,6.2982e+01_r8/)
      kbo(:, 5,47,15) = (/ &
     &5.8970e+06_r8,4.4228e+06_r8,2.9485e+06_r8,1.4743e+06_r8,5.3315e+01_r8/)
      kbo(:, 1,48,15) = (/ &
     &8.4803e+06_r8,6.3603e+06_r8,4.2402e+06_r8,2.1201e+06_r8,9.5233e+01_r8/)
      kbo(:, 2,48,15) = (/ &
     &8.1666e+06_r8,6.1249e+06_r8,4.0833e+06_r8,2.0417e+06_r8,8.3938e+01_r8/)
      kbo(:, 3,48,15) = (/ &
     &7.8474e+06_r8,5.8855e+06_r8,3.9237e+06_r8,1.9618e+06_r8,7.8581e+01_r8/)
      kbo(:, 4,48,15) = (/ &
     &7.5308e+06_r8,5.6481e+06_r8,3.7654e+06_r8,1.8827e+06_r8,6.5837e+01_r8/)
      kbo(:, 5,48,15) = (/ &
     &7.2194e+06_r8,5.4145e+06_r8,3.6097e+06_r8,1.8049e+06_r8,5.5833e+01_r8/)
      kbo(:, 1,49,15) = (/ &
     &1.0795e+07_r8,8.0961e+06_r8,5.3974e+06_r8,2.6987e+06_r8,9.8694e+01_r8/)
      kbo(:, 2,49,15) = (/ &
     &1.0405e+07_r8,7.8035e+06_r8,5.2023e+06_r8,2.6011e+06_r8,8.7441e+01_r8/)
      kbo(:, 3,49,15) = (/ &
     &1.0006e+07_r8,7.5045e+06_r8,5.0030e+06_r8,2.5015e+06_r8,8.1233e+01_r8/)
      kbo(:, 4,49,15) = (/ &
     &9.6057e+06_r8,7.2043e+06_r8,4.8028e+06_r8,2.4014e+06_r8,6.9160e+01_r8/)
      kbo(:, 5,49,15) = (/ &
     &9.2104e+06_r8,6.9078e+06_r8,4.6052e+06_r8,2.3026e+06_r8,5.7442e+01_r8/)
      kbo(:, 1,50,15) = (/ &
     &1.3074e+07_r8,9.8054e+06_r8,6.5369e+06_r8,3.2685e+06_r8,1.0218e+02_r8/)
      kbo(:, 2,50,15) = (/ &
     &1.2610e+07_r8,9.4575e+06_r8,6.3050e+06_r8,3.1525e+06_r8,9.1395e+01_r8/)
      kbo(:, 3,50,15) = (/ &
     &1.2137e+07_r8,9.1025e+06_r8,6.0683e+06_r8,3.0342e+06_r8,8.4017e+01_r8/)
      kbo(:, 4,50,15) = (/ &
     &1.1655e+07_r8,8.7414e+06_r8,5.8276e+06_r8,2.9138e+06_r8,7.1620e+01_r8/)
      kbo(:, 5,50,15) = (/ &
     &1.1180e+07_r8,8.3848e+06_r8,5.5899e+06_r8,2.7949e+06_r8,6.0411e+01_r8/)
      kbo(:, 1,51,15) = (/ &
     &1.5480e+07_r8,1.1610e+07_r8,7.7399e+06_r8,3.8700e+06_r8,1.0595e+02_r8/)
      kbo(:, 2,51,15) = (/ &
     &1.4942e+07_r8,1.1207e+07_r8,7.4711e+06_r8,3.7356e+06_r8,9.5091e+01_r8/)
      kbo(:, 3,51,15) = (/ &
     &1.4390e+07_r8,1.0793e+07_r8,7.1952e+06_r8,3.5976e+06_r8,8.6843e+01_r8/)
      kbo(:, 4,51,15) = (/ &
     &1.3829e+07_r8,1.0371e+07_r8,6.9143e+06_r8,3.4572e+06_r8,7.4583e+01_r8/)
      kbo(:, 5,51,15) = (/ &
     &1.3268e+07_r8,9.9514e+06_r8,6.6343e+06_r8,3.3171e+06_r8,6.4529e+01_r8/)
      kbo(:, 1,52,15) = (/ &
     &1.8848e+07_r8,1.4136e+07_r8,9.4240e+06_r8,4.7120e+06_r8,1.0974e+02_r8/)
      kbo(:, 2,52,15) = (/ &
     &1.8206e+07_r8,1.3654e+07_r8,9.1030e+06_r8,4.5515e+06_r8,9.9547e+01_r8/)
      kbo(:, 3,52,15) = (/ &
     &1.7547e+07_r8,1.3161e+07_r8,8.7738e+06_r8,4.3869e+06_r8,8.9552e+01_r8/)
      kbo(:, 4,52,15) = (/ &
     &1.6877e+07_r8,1.2658e+07_r8,8.4384e+06_r8,4.2192e+06_r8,7.7635e+01_r8/)
      kbo(:, 5,52,15) = (/ &
     &1.6199e+07_r8,1.2149e+07_r8,8.0997e+06_r8,4.0499e+06_r8,6.8061e+01_r8/)
      kbo(:, 1,53,15) = (/ &
     &2.3903e+07_r8,1.7928e+07_r8,1.1952e+07_r8,5.9760e+06_r8,1.1360e+02_r8/)
      kbo(:, 2,53,15) = (/ &
     &2.3112e+07_r8,1.7334e+07_r8,1.1556e+07_r8,5.7781e+06_r8,1.0455e+02_r8/)
      kbo(:, 3,53,15) = (/ &
     &2.2293e+07_r8,1.6719e+07_r8,1.1146e+07_r8,5.5732e+06_r8,9.2320e+01_r8/)
      kbo(:, 4,53,15) = (/ &
     &2.1455e+07_r8,1.6091e+07_r8,1.0728e+07_r8,5.3638e+06_r8,8.0467e+01_r8/)
      kbo(:, 5,53,15) = (/ &
     &2.0604e+07_r8,1.5453e+07_r8,1.0302e+07_r8,5.1511e+06_r8,7.1688e+01_r8/)
      kbo(:, 1,54,15) = (/ &
     &2.6168e+07_r8,1.9626e+07_r8,1.3084e+07_r8,6.5420e+06_r8,1.1792e+02_r8/)
      kbo(:, 2,54,15) = (/ &
     &2.5326e+07_r8,1.8995e+07_r8,1.2663e+07_r8,6.3316e+06_r8,1.0689e+02_r8/)
      kbo(:, 3,54,15) = (/ &
     &2.4445e+07_r8,1.8334e+07_r8,1.2223e+07_r8,6.1114e+06_r8,9.4623e+01_r8/)
      kbo(:, 4,54,15) = (/ &
     &2.3543e+07_r8,1.7657e+07_r8,1.1772e+07_r8,5.8858e+06_r8,8.6034e+01_r8/)
      kbo(:, 5,54,15) = (/ &
     &2.2624e+07_r8,1.6968e+07_r8,1.1312e+07_r8,5.6560e+06_r8,7.5610e+01_r8/)
      kbo(:, 1,55,15) = (/ &
     &2.6110e+07_r8,1.9583e+07_r8,1.3055e+07_r8,6.5277e+06_r8,1.2293e+02_r8/)
      kbo(:, 2,55,15) = (/ &
     &2.5298e+07_r8,1.8974e+07_r8,1.2649e+07_r8,6.3247e+06_r8,1.0996e+02_r8/)
      kbo(:, 3,55,15) = (/ &
     &2.4435e+07_r8,1.8326e+07_r8,1.2218e+07_r8,6.1089e+06_r8,1.0025e+02_r8/)
      kbo(:, 4,55,15) = (/ &
     &2.3548e+07_r8,1.7661e+07_r8,1.1774e+07_r8,5.8870e+06_r8,8.9943e+01_r8/)
      kbo(:, 5,55,15) = (/ &
     &2.2646e+07_r8,1.6984e+07_r8,1.1323e+07_r8,5.6615e+06_r8,7.8052e+01_r8/)
      kbo(:, 1,56,15) = (/ &
     &2.6049e+07_r8,1.9537e+07_r8,1.3025e+07_r8,6.5123e+06_r8,1.2801e+02_r8/)
      kbo(:, 2,56,15) = (/ &
     &2.5263e+07_r8,1.8947e+07_r8,1.2631e+07_r8,6.3155e+06_r8,1.1426e+02_r8/)
      kbo(:, 3,56,15) = (/ &
     &2.4422e+07_r8,1.8316e+07_r8,1.2211e+07_r8,6.1054e+06_r8,1.0290e+02_r8/)
      kbo(:, 4,56,15) = (/ &
     &2.3554e+07_r8,1.7665e+07_r8,1.1777e+07_r8,5.8883e+06_r8,9.1587e+01_r8/)
      kbo(:, 5,56,15) = (/ &
     &2.2663e+07_r8,1.6997e+07_r8,1.1331e+07_r8,5.6657e+06_r8,8.3726e+01_r8/)
      kbo(:, 1,57,15) = (/ &
     &2.5975e+07_r8,1.9481e+07_r8,1.2987e+07_r8,6.4936e+06_r8,1.3227e+02_r8/)
      kbo(:, 2,57,15) = (/ &
     &2.5221e+07_r8,1.8915e+07_r8,1.2610e+07_r8,6.3050e+06_r8,1.1939e+02_r8/)
      kbo(:, 3,57,15) = (/ &
     &2.4401e+07_r8,1.8301e+07_r8,1.2201e+07_r8,6.1003e+06_r8,1.0672e+02_r8/)
      kbo(:, 4,57,15) = (/ &
     &2.3548e+07_r8,1.7661e+07_r8,1.1774e+07_r8,5.8869e+06_r8,9.6378e+01_r8/)
      kbo(:, 5,57,15) = (/ &
     &2.2676e+07_r8,1.7007e+07_r8,1.1338e+07_r8,5.6688e+06_r8,8.7523e+01_r8/)
      kbo(:, 1,58,15) = (/ &
     &6.8249e+06_r8,6.2574e+06_r8,5.3652e+06_r8,3.7577e+06_r8,1.3651e+02_r8/)
      kbo(:, 2,58,15) = (/ &
     &6.6343e+06_r8,6.0826e+06_r8,5.2153e+06_r8,3.6528e+06_r8,1.2352e+02_r8/)
      kbo(:, 3,58,15) = (/ &
     &6.4258e+06_r8,5.8914e+06_r8,5.0514e+06_r8,3.5379e+06_r8,1.1077e+02_r8/)
      kbo(:, 4,58,15) = (/ &
     &6.2048e+06_r8,5.6888e+06_r8,4.8776e+06_r8,3.4163e+06_r8,9.9878e+01_r8/)
      kbo(:, 5,58,15) = (/ &
     &5.9792e+06_r8,5.4820e+06_r8,4.7004e+06_r8,3.2921e+06_r8,8.9433e+01_r8/)
      kbo(:, 1,59,15) = (/ &
     &7.9949e+06_r8,6.9809e+06_r8,5.5683e+06_r8,3.4650e+06_r8,1.3832e+02_r8/)
      kbo(:, 2,59,15) = (/ &
     &7.7778e+06_r8,6.7913e+06_r8,5.4171e+06_r8,3.3709e+06_r8,1.2505e+02_r8/)
      kbo(:, 3,59,15) = (/ &
     &7.5359e+06_r8,6.5801e+06_r8,5.2486e+06_r8,3.2660e+06_r8,1.1363e+02_r8/)
      kbo(:, 4,59,15) = (/ &
     &7.2794e+06_r8,6.3561e+06_r8,5.0700e+06_r8,3.1549e+06_r8,1.0324e+02_r8/)
      kbo(:, 5,59,15) = (/ &
     &7.0157e+06_r8,6.1258e+06_r8,4.8863e+06_r8,3.0406e+06_r8,9.1722e+01_r8/)
      kbo(:, 1,13,16) = (/ &
     &7.4591e+05_r8,5.5944e+05_r8,3.7296e+05_r8,1.8648e+05_r8,1.0589e+01_r8/)
      kbo(:, 2,13,16) = (/ &
     &7.4121e+05_r8,5.5591e+05_r8,3.7061e+05_r8,1.8530e+05_r8,1.0476e+01_r8/)
      kbo(:, 3,13,16) = (/ &
     &7.3660e+05_r8,5.5245e+05_r8,3.6830e+05_r8,1.8415e+05_r8,6.4518e+00_r8/)
      kbo(:, 4,13,16) = (/ &
     &7.3017e+05_r8,5.4763e+05_r8,3.6509e+05_r8,1.8254e+05_r8,7.2400e-02_r8/)
      kbo(:, 5,13,16) = (/ &
     &7.2523e+05_r8,5.4392e+05_r8,3.6262e+05_r8,1.8131e+05_r8,8.3840e-02_r8/)
      kbo(:, 1,14,16) = (/ &
     &5.4546e+05_r8,4.0910e+05_r8,2.7273e+05_r8,1.3636e+05_r8,1.2083e+01_r8/)
      kbo(:, 2,14,16) = (/ &
     &5.4530e+05_r8,4.0897e+05_r8,2.7264e+05_r8,1.3632e+05_r8,1.1940e+01_r8/)
      kbo(:, 3,14,16) = (/ &
     &5.4326e+05_r8,4.0739e+05_r8,2.7163e+05_r8,1.3581e+05_r8,1.1721e+01_r8/)
      kbo(:, 4,14,16) = (/ &
     &5.4132e+05_r8,4.0599e+05_r8,2.7066e+05_r8,1.3533e+05_r8,4.5827e+00_r8/)
      kbo(:, 5,14,16) = (/ &
     &5.3886e+05_r8,4.0414e+05_r8,2.6943e+05_r8,1.3471e+05_r8,7.8150e-02_r8/)
      kbo(:, 1,15,16) = (/ &
     &4.1181e+05_r8,3.0886e+05_r8,2.0591e+05_r8,1.0295e+05_r8,1.3732e+01_r8/)
      kbo(:, 2,15,16) = (/ &
     &4.1235e+05_r8,3.0926e+05_r8,2.0618e+05_r8,1.0309e+05_r8,1.3536e+01_r8/)
      kbo(:, 3,15,16) = (/ &
     &4.1248e+05_r8,3.0936e+05_r8,2.0624e+05_r8,1.0312e+05_r8,1.3259e+01_r8/)
      kbo(:, 4,15,16) = (/ &
     &4.1181e+05_r8,3.0886e+05_r8,2.0591e+05_r8,1.0296e+05_r8,1.2919e+01_r8/)
      kbo(:, 5,15,16) = (/ &
     &4.1010e+05_r8,3.0757e+05_r8,2.0505e+05_r8,1.0253e+05_r8,4.0719e+00_r8/)
      kbo(:, 1,16,16) = (/ &
     &3.7257e+05_r8,2.7672e+05_r8,1.8628e+05_r8,9.3143e+04_r8,1.5485e+01_r8/)
      kbo(:, 2,16,16) = (/ &
     &3.7431e+05_r8,2.8074e+05_r8,1.8716e+05_r8,9.3579e+04_r8,1.5222e+01_r8/)
      kbo(:, 3,16,16) = (/ &
     &3.7500e+05_r8,2.8129e+05_r8,1.8753e+05_r8,9.3763e+04_r8,1.4862e+01_r8/)
      kbo(:, 4,16,16) = (/ &
     &3.7444e+05_r8,2.8083e+05_r8,1.8722e+05_r8,9.3612e+04_r8,1.4438e+01_r8/)
      kbo(:, 5,16,16) = (/ &
     &3.7332e+05_r8,2.7999e+05_r8,1.8666e+05_r8,9.3332e+04_r8,7.6230e+00_r8/)
      kbo(:, 1,17,16) = (/ &
     &3.5182e+05_r8,2.6386e+05_r8,1.7591e+05_r8,8.7955e+04_r8,1.7290e+01_r8/)
      kbo(:, 2,17,16) = (/ &
     &3.5397e+05_r8,2.6547e+05_r8,1.7698e+05_r8,8.8492e+04_r8,1.6932e+01_r8/)
      kbo(:, 3,17,16) = (/ &
     &3.5462e+05_r8,2.6597e+05_r8,1.7731e+05_r8,8.8656e+04_r8,1.6480e+01_r8/)
      kbo(:, 4,17,16) = (/ &
     &3.5402e+05_r8,2.6552e+05_r8,1.7701e+05_r8,8.8507e+04_r8,1.5962e+01_r8/)
      kbo(:, 5,17,16) = (/ &
     &3.5314e+05_r8,2.6486e+05_r8,1.7657e+05_r8,8.8287e+04_r8,1.0353e+01_r8/)
      kbo(:, 1,18,16) = (/ &
     &3.4176e+05_r8,2.5632e+05_r8,1.7088e+05_r8,8.5439e+04_r8,1.9139e+01_r8/)
      kbo(:, 2,18,16) = (/ &
     &3.4367e+05_r8,2.5775e+05_r8,1.7183e+05_r8,8.5917e+04_r8,1.8641e+01_r8/)
      kbo(:, 3,18,16) = (/ &
     &3.4399e+05_r8,2.5800e+05_r8,1.7200e+05_r8,8.5999e+04_r8,1.8079e+01_r8/)
      kbo(:, 4,18,16) = (/ &
     &3.4376e+05_r8,2.5782e+05_r8,1.7188e+05_r8,8.5941e+04_r8,1.7627e+01_r8/)
      kbo(:, 5,18,16) = (/ &
     &3.4258e+05_r8,2.5694e+05_r8,1.7129e+05_r8,8.5646e+04_r8,1.3174e+01_r8/)
      kbo(:, 1,19,16) = (/ &
     &3.2677e+05_r8,2.4508e+05_r8,1.6338e+05_r8,8.1692e+04_r8,2.1598e+01_r8/)
      kbo(:, 2,19,16) = (/ &
     &3.2775e+05_r8,2.4581e+05_r8,1.6387e+05_r8,8.1937e+04_r8,2.1013e+01_r8/)
      kbo(:, 3,19,16) = (/ &
     &3.2835e+05_r8,2.4626e+05_r8,1.6417e+05_r8,8.2068e+04_r8,2.0530e+01_r8/)
      kbo(:, 4,19,16) = (/ &
     &3.2780e+05_r8,2.4585e+05_r8,1.6390e+05_r8,8.1950e+04_r8,2.0057e+01_r8/)
      kbo(:, 5,19,16) = (/ &
     &3.2322e+05_r8,2.4484e+05_r8,1.6323e+05_r8,8.1613e+04_r8,1.8218e+01_r8/)
      kbo(:, 1,20,16) = (/ &
     &3.3791e+05_r8,2.5343e+05_r8,1.6896e+05_r8,8.4478e+04_r8,2.4811e+01_r8/)
      kbo(:, 2,20,16) = (/ &
     &3.3834e+05_r8,2.5376e+05_r8,1.6917e+05_r8,8.4586e+04_r8,2.4163e+01_r8/)
      kbo(:, 3,20,16) = (/ &
     &3.3842e+05_r8,2.5381e+05_r8,1.6921e+05_r8,8.4605e+04_r8,2.3647e+01_r8/)
      kbo(:, 4,20,16) = (/ &
     &3.3728e+05_r8,2.5296e+05_r8,1.6864e+05_r8,8.4321e+04_r8,2.3144e+01_r8/)
      kbo(:, 5,20,16) = (/ &
     &3.3569e+05_r8,2.5177e+05_r8,1.6785e+05_r8,8.3923e+04_r8,2.2618e+01_r8/)
      kbo(:, 1,21,16) = (/ &
     &3.5913e+05_r8,2.6935e+05_r8,1.7956e+05_r8,8.9782e+04_r8,2.8889e+01_r8/)
      kbo(:, 2,21,16) = (/ &
     &3.5914e+05_r8,2.6936e+05_r8,1.7957e+05_r8,8.9786e+04_r8,2.8114e+01_r8/)
      kbo(:, 3,21,16) = (/ &
     &3.5794e+05_r8,2.6846e+05_r8,1.7897e+05_r8,8.9486e+04_r8,2.7459e+01_r8/)
      kbo(:, 4,21,16) = (/ &
     &3.5626e+05_r8,2.6720e+05_r8,1.7813e+05_r8,8.9066e+04_r8,2.6836e+01_r8/)
      kbo(:, 5,21,16) = (/ &
     &3.5369e+05_r8,2.6527e+05_r8,1.7684e+05_r8,8.8423e+04_r8,2.6161e+01_r8/)
      kbo(:, 1,22,16) = (/ &
     &3.8948e+05_r8,2.9211e+05_r8,1.9474e+05_r8,9.7369e+04_r8,3.3724e+01_r8/)
      kbo(:, 2,22,16) = (/ &
     &3.8828e+05_r8,2.9121e+05_r8,1.9414e+05_r8,9.7069e+04_r8,3.2720e+01_r8/)
      kbo(:, 3,22,16) = (/ &
     &3.8560e+05_r8,2.8920e+05_r8,1.9280e+05_r8,9.6401e+04_r8,3.1834e+01_r8/)
      kbo(:, 4,22,16) = (/ &
     &3.8253e+05_r8,2.8690e+05_r8,1.9127e+05_r8,9.5633e+04_r8,3.0971e+01_r8/)
      kbo(:, 5,22,16) = (/ &
     &3.7845e+05_r8,2.8383e+05_r8,1.8922e+05_r8,9.4612e+04_r8,3.0080e+01_r8/)
      kbo(:, 1,23,16) = (/ &
     &4.2147e+05_r8,3.1611e+05_r8,2.1074e+05_r8,1.0537e+05_r8,3.9276e+01_r8/)
      kbo(:, 2,23,16) = (/ &
     &4.1843e+05_r8,3.1382e+05_r8,2.0921e+05_r8,1.0461e+05_r8,3.7947e+01_r8/)
      kbo(:, 3,23,16) = (/ &
     &4.1438e+05_r8,3.1079e+05_r8,2.0719e+05_r8,1.0360e+05_r8,3.6734e+01_r8/)
      kbo(:, 4,23,16) = (/ &
     &4.0918e+05_r8,3.0688e+05_r8,2.0459e+05_r8,1.0230e+05_r8,3.5522e+01_r8/)
      kbo(:, 5,23,16) = (/ &
     &4.0269e+05_r8,3.0202e+05_r8,2.0135e+05_r8,1.0067e+05_r8,3.4322e+01_r8/)
      kbo(:, 1,24,16) = (/ &
     &4.4910e+05_r8,3.3682e+05_r8,2.2455e+05_r8,1.1228e+05_r8,4.5446e+01_r8/)
      kbo(:, 2,24,16) = (/ &
     &4.4436e+05_r8,3.3327e+05_r8,2.2218e+05_r8,1.1109e+05_r8,4.3684e+01_r8/)
      kbo(:, 3,24,16) = (/ &
     &4.3822e+05_r8,3.2867e+05_r8,2.1911e+05_r8,1.0956e+05_r8,4.2010e+01_r8/)
      kbo(:, 4,24,16) = (/ &
     &4.3055e+05_r8,3.2291e+05_r8,2.1528e+05_r8,1.0764e+05_r8,4.0380e+01_r8/)
      kbo(:, 5,24,16) = (/ &
     &4.2183e+05_r8,3.1637e+05_r8,2.1092e+05_r8,1.0546e+05_r8,3.8819e+01_r8/)
      kbo(:, 1,25,16) = (/ &
     &4.7951e+05_r8,3.5963e+05_r8,2.3975e+05_r8,1.1988e+05_r8,5.2030e+01_r8/)
      kbo(:, 2,25,16) = (/ &
     &4.7236e+05_r8,3.5427e+05_r8,2.3618e+05_r8,1.1809e+05_r8,4.9759e+01_r8/)
      kbo(:, 3,25,16) = (/ &
     &4.6345e+05_r8,3.4759e+05_r8,2.3173e+05_r8,1.1586e+05_r8,4.7513e+01_r8/)
      kbo(:, 4,25,16) = (/ &
     &4.5307e+05_r8,3.3980e+05_r8,2.2654e+05_r8,1.1327e+05_r8,4.5411e+01_r8/)
      kbo(:, 5,25,16) = (/ &
     &4.4201e+05_r8,3.3151e+05_r8,2.2101e+05_r8,1.1050e+05_r8,4.3416e+01_r8/)
      kbo(:, 1,26,16) = (/ &
     &5.1412e+05_r8,3.8559e+05_r8,2.5706e+05_r8,1.2853e+05_r8,5.8735e+01_r8/)
      kbo(:, 2,26,16) = (/ &
     &5.0368e+05_r8,3.7776e+05_r8,2.5184e+05_r8,1.2592e+05_r8,5.5868e+01_r8/)
      kbo(:, 3,26,16) = (/ &
     &4.9157e+05_r8,3.6868e+05_r8,2.4579e+05_r8,1.2289e+05_r8,5.3078e+01_r8/)
      kbo(:, 4,26,16) = (/ &
     &4.7856e+05_r8,3.5892e+05_r8,2.3928e+05_r8,1.1964e+05_r8,5.0425e+01_r8/)
      kbo(:, 5,26,16) = (/ &
     &4.6464e+05_r8,3.4848e+05_r8,2.3232e+05_r8,1.1616e+05_r8,4.7921e+01_r8/)
      kbo(:, 1,27,16) = (/ &
     &5.6504e+05_r8,4.2378e+05_r8,2.8252e+05_r8,1.4126e+05_r8,6.5394e+01_r8/)
      kbo(:, 2,27,16) = (/ &
     &5.5002e+05_r8,4.1252e+05_r8,2.7501e+05_r8,1.3751e+05_r8,6.1825e+01_r8/)
      kbo(:, 3,27,16) = (/ &
     &5.3436e+05_r8,4.0077e+05_r8,2.6718e+05_r8,1.3359e+05_r8,5.8497e+01_r8/)
      kbo(:, 4,27,16) = (/ &
     &5.1782e+05_r8,3.8837e+05_r8,2.5891e+05_r8,1.2946e+05_r8,5.5282e+01_r8/)
      kbo(:, 5,27,16) = (/ &
     &5.0051e+05_r8,3.7538e+05_r8,2.5025e+05_r8,1.2513e+05_r8,5.2211e+01_r8/)
      kbo(:, 1,28,16) = (/ &
     &6.2869e+05_r8,4.7152e+05_r8,3.1435e+05_r8,1.5717e+05_r8,7.1700e+01_r8/)
      kbo(:, 2,28,16) = (/ &
     &6.0862e+05_r8,4.5646e+05_r8,3.0431e+05_r8,1.5215e+05_r8,6.7460e+01_r8/)
      kbo(:, 3,28,16) = (/ &
     &5.8860e+05_r8,4.4145e+05_r8,2.9430e+05_r8,1.4715e+05_r8,6.3511e+01_r8/)
      kbo(:, 4,28,16) = (/ &
     &5.6780e+05_r8,4.2585e+05_r8,2.8390e+05_r8,1.4195e+05_r8,5.9746e+01_r8/)
      kbo(:, 5,28,16) = (/ &
     &5.4624e+05_r8,4.0968e+05_r8,2.7312e+05_r8,1.3656e+05_r8,5.6156e+01_r8/)
      kbo(:, 1,29,16) = (/ &
     &7.3240e+05_r8,5.4930e+05_r8,3.6620e+05_r8,1.8310e+05_r8,7.7436e+01_r8/)
      kbo(:, 2,29,16) = (/ &
     &7.0567e+05_r8,5.2925e+05_r8,3.5284e+05_r8,1.7642e+05_r8,7.2532e+01_r8/)
      kbo(:, 3,29,16) = (/ &
     &6.7920e+05_r8,5.0940e+05_r8,3.3960e+05_r8,1.6980e+05_r8,6.7962e+01_r8/)
      kbo(:, 4,29,16) = (/ &
     &6.5231e+05_r8,4.8923e+05_r8,3.2615e+05_r8,1.6308e+05_r8,6.3669e+01_r8/)
      kbo(:, 5,29,16) = (/ &
     &6.2510e+05_r8,4.6882e+05_r8,3.1255e+05_r8,1.5627e+05_r8,5.9600e+01_r8/)
      kbo(:, 1,30,16) = (/ &
     &8.6319e+05_r8,6.4740e+05_r8,4.3160e+05_r8,2.1580e+05_r8,8.2489e+01_r8/)
      kbo(:, 2,30,16) = (/ &
     &8.2811e+05_r8,6.2108e+05_r8,4.1405e+05_r8,2.0703e+05_r8,7.6918e+01_r8/)
      kbo(:, 3,30,16) = (/ &
     &7.9339e+05_r8,5.9504e+05_r8,3.9669e+05_r8,1.9835e+05_r8,7.1793e+01_r8/)
      kbo(:, 4,30,16) = (/ &
     &7.5902e+05_r8,5.6926e+05_r8,3.7951e+05_r8,1.8975e+05_r8,6.6976e+01_r8/)
      kbo(:, 5,30,16) = (/ &
     &7.2513e+05_r8,5.4385e+05_r8,3.6256e+05_r8,1.8128e+05_r8,5.5921e+01_r8/)
      kbo(:, 1,31,16) = (/ &
     &1.0572e+06_r8,7.9291e+05_r8,5.2861e+05_r8,2.6430e+05_r8,8.6704e+01_r8/)
      kbo(:, 2,31,16) = (/ &
     &1.0099e+06_r8,7.5744e+05_r8,5.0496e+05_r8,2.5248e+05_r8,8.0546e+01_r8/)
      kbo(:, 3,31,16) = (/ &
     &9.6381e+05_r8,7.2285e+05_r8,4.8190e+05_r8,2.4095e+05_r8,7.4889e+01_r8/)
      kbo(:, 4,31,16) = (/ &
     &9.1917e+05_r8,6.8937e+05_r8,4.5958e+05_r8,2.2979e+05_r8,6.9630e+01_r8/)
      kbo(:, 5,31,16) = (/ &
     &8.7558e+05_r8,6.5669e+05_r8,4.3779e+05_r8,2.1889e+05_r8,5.1048e+01_r8/)
      kbo(:, 1,32,16) = (/ &
     &1.2953e+06_r8,9.7146e+05_r8,6.4764e+05_r8,3.2382e+05_r8,9.0053e+01_r8/)
      kbo(:, 2,32,16) = (/ &
     &1.2332e+06_r8,9.2492e+05_r8,6.1662e+05_r8,3.0831e+05_r8,8.3375e+01_r8/)
      kbo(:, 3,32,16) = (/ &
     &1.1732e+06_r8,8.7992e+05_r8,5.8661e+05_r8,2.9331e+05_r8,7.7283e+01_r8/)
      kbo(:, 4,32,16) = (/ &
     &1.1156e+06_r8,8.3672e+05_r8,5.5781e+05_r8,2.7891e+05_r8,5.9068e+01_r8/)
      kbo(:, 5,32,16) = (/ &
     &1.0600e+06_r8,7.9499e+05_r8,5.3000e+05_r8,2.6500e+05_r8,4.7615e+01_r8/)
      kbo(:, 1,33,16) = (/ &
     &1.6005e+06_r8,1.2004e+06_r8,8.0025e+05_r8,4.0013e+05_r8,9.2564e+01_r8/)
      kbo(:, 2,33,16) = (/ &
     &1.5042e+06_r8,1.1396e+06_r8,7.5976e+05_r8,3.7988e+05_r8,8.5451e+01_r8/)
      kbo(:, 3,33,16) = (/ &
     &1.4412e+06_r8,1.0809e+06_r8,7.2060e+05_r8,3.6030e+05_r8,6.7956e+01_r8/)
      kbo(:, 4,33,16) = (/ &
     &1.3676e+06_r8,1.0257e+06_r8,6.8379e+05_r8,3.4189e+05_r8,5.3693e+01_r8/)
      kbo(:, 5,33,16) = (/ &
     &1.2966e+06_r8,9.7245e+05_r8,6.4830e+05_r8,3.2415e+05_r8,4.3539e+01_r8/)
      kbo(:, 1,34,16) = (/ &
     &1.9162e+06_r8,1.4372e+06_r8,9.5812e+05_r8,4.7906e+05_r8,9.4564e+01_r8/)
      kbo(:, 2,34,16) = (/ &
     &1.8147e+06_r8,1.3610e+06_r8,9.0734e+05_r8,4.5367e+05_r8,8.5602e+01_r8/)
      kbo(:, 3,34,16) = (/ &
     &1.7177e+06_r8,1.2883e+06_r8,8.5884e+05_r8,4.2942e+05_r8,6.2695e+01_r8/)
      kbo(:, 4,34,16) = (/ &
     &1.6266e+06_r8,1.2199e+06_r8,8.1329e+05_r8,4.0664e+05_r8,5.0461e+01_r8/)
      kbo(:, 5,34,16) = (/ &
     &1.5395e+06_r8,1.1546e+06_r8,7.6973e+05_r8,3.8486e+05_r8,4.1009e+01_r8/)
      kbo(:, 1,35,16) = (/ &
     &2.2940e+06_r8,1.7205e+06_r8,1.1470e+06_r8,5.7350e+05_r8,9.6683e+01_r8/)
      kbo(:, 2,35,16) = (/ &
     &2.1679e+06_r8,1.6259e+06_r8,1.0839e+06_r8,5.4197e+05_r8,7.5706e+01_r8/)
      kbo(:, 3,35,16) = (/ &
     &2.0487e+06_r8,1.5365e+06_r8,1.0243e+06_r8,5.1216e+05_r8,5.9415e+01_r8/)
      kbo(:, 4,35,16) = (/ &
     &1.9369e+06_r8,1.4527e+06_r8,9.6844e+05_r8,4.8422e+05_r8,4.7837e+01_r8/)
      kbo(:, 5,35,16) = (/ &
     &1.8303e+06_r8,1.3728e+06_r8,9.1517e+05_r8,4.5758e+05_r8,3.3167e+01_r8/)
      kbo(:, 1,36,16) = (/ &
     &2.7323e+06_r8,2.0492e+06_r8,1.3661e+06_r8,6.8307e+05_r8,9.9200e+01_r8/)
      kbo(:, 2,36,16) = (/ &
     &2.5780e+06_r8,1.9335e+06_r8,1.2890e+06_r8,6.4450e+05_r8,7.2688e+01_r8/)
      kbo(:, 3,36,16) = (/ &
     &2.4326e+06_r8,1.8244e+06_r8,1.2163e+06_r8,6.0814e+05_r8,5.7708e+01_r8/)
      kbo(:, 4,36,16) = (/ &
     &2.2967e+06_r8,1.7225e+06_r8,1.1483e+06_r8,5.7417e+05_r8,4.6712e+01_r8/)
      kbo(:, 5,36,16) = (/ &
     &2.1679e+06_r8,1.6259e+06_r8,1.0839e+06_r8,5.4197e+05_r8,1.2791e+01_r8/)
      kbo(:, 1,37,16) = (/ &
     &3.1885e+06_r8,2.3914e+06_r8,1.5942e+06_r8,7.9711e+05_r8,1.0268e+02_r8/)
      kbo(:, 2,37,16) = (/ &
     &3.0040e+06_r8,2.2530e+06_r8,1.5020e+06_r8,7.5099e+05_r8,7.3443e+01_r8/)
      kbo(:, 3,37,16) = (/ &
     &2.8309e+06_r8,2.1232e+06_r8,1.4155e+06_r8,7.0773e+05_r8,5.8756e+01_r8/)
      kbo(:, 4,37,16) = (/ &
     &2.6696e+06_r8,2.0022e+06_r8,1.3348e+06_r8,6.6739e+05_r8,4.7388e+01_r8/)
      kbo(:, 5,37,16) = (/ &
     &2.5177e+06_r8,1.8883e+06_r8,1.2588e+06_r8,6.2942e+05_r8,7.8483e+00_r8/)
      kbo(:, 1,38,16) = (/ &
     &3.7660e+06_r8,2.8245e+06_r8,1.8830e+06_r8,9.4149e+05_r8,1.0053e+02_r8/)
      kbo(:, 2,38,16) = (/ &
     &3.5441e+06_r8,2.6581e+06_r8,1.7720e+06_r8,8.8602e+05_r8,7.3960e+01_r8/)
      kbo(:, 3,38,16) = (/ &
     &3.3357e+06_r8,2.5018e+06_r8,1.6678e+06_r8,8.3391e+05_r8,5.9673e+01_r8/)
      kbo(:, 4,38,16) = (/ &
     &3.1421e+06_r8,2.3566e+06_r8,1.5711e+06_r8,7.8553e+05_r8,4.7953e+01_r8/)
      kbo(:, 5,38,16) = (/ &
     &2.9610e+06_r8,2.2207e+06_r8,1.4805e+06_r8,7.4024e+05_r8,7.1016e-04_r8/)
      kbo(:, 1,39,16) = (/ &
     &4.5378e+06_r8,3.4034e+06_r8,2.2689e+06_r8,1.1345e+06_r8,9.8727e+01_r8/)
      kbo(:, 2,39,16) = (/ &
     &4.2667e+06_r8,3.2000e+06_r8,2.1334e+06_r8,1.0667e+06_r8,7.4242e+01_r8/)
      kbo(:, 3,39,16) = (/ &
     &4.0124e+06_r8,3.0093e+06_r8,2.0062e+06_r8,1.0031e+06_r8,5.9575e+01_r8/)
      kbo(:, 4,39,16) = (/ &
     &3.7760e+06_r8,2.8320e+06_r8,1.8880e+06_r8,9.4400e+05_r8,3.9674e+01_r8/)
      kbo(:, 5,39,16) = (/ &
     &3.5558e+06_r8,2.6669e+06_r8,1.7591e+06_r8,8.8898e+05_r8,5.7405e-04_r8/)
      kbo(:, 1,40,16) = (/ &
     &5.1586e+06_r8,3.8690e+06_r8,2.5793e+06_r8,1.2896e+06_r8,1.0433e+02_r8/)
      kbo(:, 2,40,16) = (/ &
     &4.8469e+06_r8,3.6347e+06_r8,2.4234e+06_r8,1.2117e+06_r8,7.7760e+01_r8/)
      kbo(:, 3,40,16) = (/ &
     &4.5541e+06_r8,3.4156e+06_r8,2.2770e+06_r8,1.1385e+06_r8,6.1585e+01_r8/)
      kbo(:, 4,40,16) = (/ &
     &4.2818e+06_r8,3.2114e+06_r8,2.1409e+06_r8,1.0704e+06_r8,4.0940e+01_r8/)
      kbo(:, 5,40,16) = (/ &
     &4.0296e+06_r8,3.0222e+06_r8,2.0148e+06_r8,1.0074e+06_r8,4.6888e-04_r8/)
      kbo(:, 1,41,16) = (/ &
     &5.8465e+06_r8,4.3849e+06_r8,2.9233e+06_r8,1.4616e+06_r8,1.1317e+02_r8/)
      kbo(:, 2,41,16) = (/ &
     &5.4907e+06_r8,4.1180e+06_r8,2.7454e+06_r8,1.3727e+06_r8,8.1398e+01_r8/)
      kbo(:, 3,41,16) = (/ &
     &5.1550e+06_r8,3.8663e+06_r8,2.5775e+06_r8,1.2888e+06_r8,6.4536e+01_r8/)
      kbo(:, 4,41,16) = (/ &
     &4.8434e+06_r8,3.6326e+06_r8,2.4217e+06_r8,1.2109e+06_r8,4.3960e+01_r8/)
      kbo(:, 5,41,16) = (/ &
     &4.5548e+06_r8,3.4161e+06_r8,2.2774e+06_r8,1.1387e+06_r8,3.7799e-04_r8/)
      kbo(:, 1,42,16) = (/ &
     &6.6900e+06_r8,5.0175e+06_r8,3.3450e+06_r8,1.6725e+06_r8,1.2124e+02_r8/)
      kbo(:, 2,42,16) = (/ &
     &6.2794e+06_r8,4.7096e+06_r8,3.1397e+06_r8,1.5698e+06_r8,8.5097e+01_r8/)
      kbo(:, 3,42,16) = (/ &
     &5.8926e+06_r8,4.4195e+06_r8,2.9463e+06_r8,1.4731e+06_r8,6.7520e+01_r8/)
      kbo(:, 4,42,16) = (/ &
     &5.5323e+06_r8,4.1492e+06_r8,2.7661e+06_r8,1.3831e+06_r8,4.6182e+01_r8/)
      kbo(:, 5,42,16) = (/ &
     &5.1983e+06_r8,3.8987e+06_r8,2.5991e+06_r8,1.2996e+06_r8,3.0509e-04_r8/)
      kbo(:, 1,43,16) = (/ &
     &7.7419e+06_r8,5.8065e+06_r8,3.8710e+06_r8,1.9355e+06_r8,1.2600e+02_r8/)
      kbo(:, 2,43,16) = (/ &
     &7.2619e+06_r8,5.4481e+06_r8,3.6321e+06_r8,1.8161e+06_r8,9.0385e+01_r8/)
      kbo(:, 3,43,16) = (/ &
     &6.8139e+06_r8,5.1104e+06_r8,3.4070e+06_r8,1.7035e+06_r8,7.0944e+01_r8/)
      kbo(:, 4,43,16) = (/ &
     &6.3928e+06_r8,4.7946e+06_r8,3.1964e+06_r8,1.5982e+06_r8,5.0507e+01_r8/)
      kbo(:, 5,43,16) = (/ &
     &6.0029e+06_r8,4.5022e+06_r8,3.0015e+06_r8,1.5007e+06_r8,2.4615e-04_r8/)
      kbo(:, 1,44,16) = (/ &
     &9.0918e+06_r8,6.8188e+06_r8,4.5458e+06_r8,2.2729e+06_r8,1.3122e+02_r8/)
      kbo(:, 2,44,16) = (/ &
     &8.5266e+06_r8,6.3949e+06_r8,4.2633e+06_r8,2.1316e+06_r8,9.7168e+01_r8/)
      kbo(:, 3,44,16) = (/ &
     &7.9959e+06_r8,5.9969e+06_r8,3.9979e+06_r8,1.9989e+06_r8,7.5640e+01_r8/)
      kbo(:, 4,44,16) = (/ &
     &7.4967e+06_r8,5.6225e+06_r8,3.7483e+06_r8,1.8741e+06_r8,5.7032e+01_r8/)
      kbo(:, 5,44,16) = (/ &
     &7.0357e+06_r8,5.2767e+06_r8,3.5178e+06_r8,1.7589e+06_r8,1.1125e-02_r8/)
      kbo(:, 1,45,16) = (/ &
     &1.0890e+07_r8,8.1678e+06_r8,5.4452e+06_r8,2.7226e+06_r8,1.3511e+02_r8/)
      kbo(:, 2,45,16) = (/ &
     &1.0206e+07_r8,7.6543e+06_r8,5.1028e+06_r8,2.5514e+06_r8,1.0320e+02_r8/)
      kbo(:, 3,45,16) = (/ &
     &9.5676e+06_r8,7.1757e+06_r8,4.7838e+06_r8,2.3919e+06_r8,7.9521e+01_r8/)
      kbo(:, 4,45,16) = (/ &
     &8.9682e+06_r8,6.7261e+06_r8,4.4841e+06_r8,2.2420e+06_r8,5.3314e+01_r8/)
      kbo(:, 5,45,16) = (/ &
     &8.4107e+06_r8,6.3080e+06_r8,4.2053e+06_r8,2.1027e+06_r8,2.2542e-04_r8/)
      kbo(:, 1,46,16) = (/ &
     &1.3200e+07_r8,9.8998e+06_r8,6.5999e+06_r8,3.2999e+06_r8,1.4245e+02_r8/)
      kbo(:, 2,46,16) = (/ &
     &1.2354e+07_r8,9.2658e+06_r8,6.1772e+06_r8,3.0886e+06_r8,1.1090e+02_r8/)
      kbo(:, 3,46,16) = (/ &
     &1.1578e+07_r8,8.6832e+06_r8,5.7888e+06_r8,2.8944e+06_r8,8.3717e+01_r8/)
      kbo(:, 4,46,16) = (/ &
     &1.0851e+07_r8,8.1384e+06_r8,5.4256e+06_r8,2.7128e+06_r8,5.1335e+01_r8/)
      kbo(:, 5,46,16) = (/ &
     &1.0172e+07_r8,7.6289e+06_r8,5.0860e+06_r8,2.5430e+06_r8,1.9729e-04_r8/)
      kbo(:, 1,47,16) = (/ &
     &1.5899e+07_r8,1.1924e+07_r8,7.9494e+06_r8,3.9747e+06_r8,1.4926e+02_r8/)
      kbo(:, 2,47,16) = (/ &
     &1.4859e+07_r8,1.1144e+07_r8,7.4297e+06_r8,3.7148e+06_r8,1.2298e+02_r8/)
      kbo(:, 3,47,16) = (/ &
     &1.3924e+07_r8,1.0443e+07_r8,6.9621e+06_r8,3.4810e+06_r8,8.5230e+01_r8/)
      kbo(:, 4,47,16) = (/ &
     &1.3046e+07_r8,9.7847e+06_r8,6.5231e+06_r8,3.2616e+06_r8,5.3561e+01_r8/)
      kbo(:, 5,47,16) = (/ &
     &1.2222e+07_r8,9.1665e+06_r8,6.1110e+06_r8,3.0555e+06_r8,1.6606e-04_r8/)
      kbo(:, 1,48,16) = (/ &
     &1.9701e+07_r8,1.4775e+07_r8,9.8503e+06_r8,4.9251e+06_r8,1.5645e+02_r8/)
      kbo(:, 2,48,16) = (/ &
     &1.8394e+07_r8,1.3796e+07_r8,9.1972e+06_r8,4.5986e+06_r8,1.4059e+02_r8/)
      kbo(:, 3,48,16) = (/ &
     &1.7217e+07_r8,1.2913e+07_r8,8.6087e+06_r8,4.3044e+06_r8,8.5580e+01_r8/)
      kbo(:, 4,48,16) = (/ &
     &1.6130e+07_r8,1.2097e+07_r8,8.0649e+06_r8,4.0324e+06_r8,5.5884e+01_r8/)
      kbo(:, 5,48,16) = (/ &
     &1.5108e+07_r8,1.1331e+07_r8,7.5542e+06_r8,3.7771e+06_r8,1.4110e-04_r8/)
      kbo(:, 1,49,16) = (/ &
     &2.5446e+07_r8,1.9085e+07_r8,1.2723e+07_r8,6.3615e+06_r8,1.6402e+02_r8/)
      kbo(:, 2,49,16) = (/ &
     &2.3735e+07_r8,1.7801e+07_r8,1.1868e+07_r8,5.9337e+06_r8,1.4463e+02_r8/)
      kbo(:, 3,49,16) = (/ &
     &2.2185e+07_r8,1.6639e+07_r8,1.1093e+07_r8,5.5463e+06_r8,8.5806e+01_r8/)
      kbo(:, 4,49,16) = (/ &
     &2.0781e+07_r8,1.5586e+07_r8,1.0390e+07_r8,5.1952e+06_r8,5.2515e+01_r8/)
      kbo(:, 5,49,16) = (/ &
     &1.9463e+07_r8,1.4597e+07_r8,9.7313e+06_r8,4.8656e+06_r8,1.1804e-04_r8/)
      kbo(:, 1,50,16) = (/ &
     &3.1256e+07_r8,2.3442e+07_r8,1.5628e+07_r8,7.8139e+06_r8,1.7145e+02_r8/)
      kbo(:, 2,50,16) = (/ &
     &2.9123e+07_r8,2.1842e+07_r8,1.4562e+07_r8,7.2808e+06_r8,1.4715e+02_r8/)
      kbo(:, 3,50,16) = (/ &
     &2.7197e+07_r8,2.0398e+07_r8,1.3599e+07_r8,6.7993e+06_r8,9.2079e+01_r8/)
      kbo(:, 4,50,16) = (/ &
     &2.5458e+07_r8,1.9094e+07_r8,1.2729e+07_r8,6.3645e+06_r8,5.7113e+01_r8/)
      kbo(:, 5,50,16) = (/ &
     &2.3842e+07_r8,1.7882e+07_r8,1.1921e+07_r8,5.9606e+06_r8,9.7879e-05_r8/)
      kbo(:, 1,51,16) = (/ &
     &3.7532e+07_r8,2.8149e+07_r8,1.8766e+07_r8,9.3831e+06_r8,1.7913e+02_r8/)
      kbo(:, 2,51,16) = (/ &
     &3.4951e+07_r8,2.6213e+07_r8,1.7476e+07_r8,8.7379e+06_r8,1.5348e+02_r8/)
      kbo(:, 3,51,16) = (/ &
     &3.2604e+07_r8,2.4453e+07_r8,1.6302e+07_r8,8.1511e+06_r8,9.9906e+01_r8/)
      kbo(:, 4,51,16) = (/ &
     &3.0489e+07_r8,2.2867e+07_r8,1.5245e+07_r8,7.6224e+06_r8,6.1926e+01_r8/)
      kbo(:, 5,51,16) = (/ &
     &2.8553e+07_r8,2.1415e+07_r8,1.4277e+07_r8,7.1383e+06_r8,8.2332e-05_r8/)
      kbo(:, 1,52,16) = (/ &
     &4.6363e+07_r8,3.4773e+07_r8,2.3182e+07_r8,1.1591e+07_r8,1.8724e+02_r8/)
      kbo(:, 2,52,16) = (/ &
     &4.3154e+07_r8,3.2365e+07_r8,2.1577e+07_r8,1.0789e+07_r8,1.5735e+02_r8/)
      kbo(:, 3,52,16) = (/ &
     &4.0219e+07_r8,3.0165e+07_r8,2.0110e+07_r8,1.0055e+07_r8,1.0819e+02_r8/)
      kbo(:, 4,52,16) = (/ &
     &3.7571e+07_r8,2.8178e+07_r8,1.8786e+07_r8,9.3929e+06_r8,6.5746e+01_r8/)
      kbo(:, 5,52,16) = (/ &
     &3.5175e+07_r8,2.6382e+07_r8,1.7588e+07_r8,8.7937e+06_r8,2.5991e+00_r8/)
      kbo(:, 1,53,16) = (/ &
     &5.9694e+07_r8,4.4771e+07_r8,2.9847e+07_r8,1.4924e+07_r8,1.9593e+02_r8/)
      kbo(:, 2,53,16) = (/ &
     &5.5520e+07_r8,4.1640e+07_r8,2.7760e+07_r8,1.3880e+07_r8,1.5986e+02_r8/)
      kbo(:, 3,53,16) = (/ &
     &5.1713e+07_r8,3.8785e+07_r8,2.5857e+07_r8,1.2928e+07_r8,1.1418e+02_r8/)
      kbo(:, 4,53,16) = (/ &
     &4.8267e+07_r8,3.6200e+07_r8,2.4134e+07_r8,1.2067e+07_r8,6.7101e+01_r8/)
      kbo(:, 5,53,16) = (/ &
     &4.5154e+07_r8,3.3866e+07_r8,2.2577e+07_r8,1.1289e+07_r8,5.4836e-05_r8/)
      kbo(:, 1,54,16) = (/ &
     &6.6291e+07_r8,4.9719e+07_r8,3.3146e+07_r8,1.6573e+07_r8,2.0438e+02_r8/)
      kbo(:, 2,54,16) = (/ &
     &6.1631e+07_r8,4.6223e+07_r8,3.0816e+07_r8,1.5408e+07_r8,1.7539e+02_r8/)
      kbo(:, 3,54,16) = (/ &
     &5.7374e+07_r8,4.3031e+07_r8,2.8687e+07_r8,1.4344e+07_r8,1.3582e+02_r8/)
      kbo(:, 4,54,16) = (/ &
     &5.3498e+07_r8,4.0123e+07_r8,2.6749e+07_r8,1.3375e+07_r8,7.9383e+01_r8/)
      kbo(:, 5,54,16) = (/ &
     &5.0001e+07_r8,3.7501e+07_r8,2.5001e+07_r8,1.2501e+07_r8,1.9380e+01_r8/)
      kbo(:, 1,55,16) = (/ &
     &6.7110e+07_r8,5.0333e+07_r8,3.3555e+07_r8,1.6778e+07_r8,2.1302e+02_r8/)
      kbo(:, 2,55,16) = (/ &
     &6.2350e+07_r8,4.6763e+07_r8,3.1175e+07_r8,1.5588e+07_r8,1.8842e+02_r8/)
      kbo(:, 3,55,16) = (/ &
     &5.8012e+07_r8,4.3509e+07_r8,2.9006e+07_r8,1.4503e+07_r8,1.5117e+02_r8/)
      kbo(:, 4,55,16) = (/ &
     &5.4054e+07_r8,4.0541e+07_r8,2.7027e+07_r8,1.3514e+07_r8,1.0060e+02_r8/)
      kbo(:, 5,55,16) = (/ &
     &5.0479e+07_r8,3.7859e+07_r8,2.5240e+07_r8,1.2620e+07_r8,5.1596e+01_r8/)
      kbo(:, 1,56,16) = (/ &
     &6.7946e+07_r8,5.0959e+07_r8,3.3973e+07_r8,1.6986e+07_r8,2.2213e+02_r8/)
      kbo(:, 2,56,16) = (/ &
     &6.3087e+07_r8,4.7315e+07_r8,3.1543e+07_r8,1.5771e+07_r8,1.9599e+02_r8/)
      kbo(:, 3,56,16) = (/ &
     &5.8660e+07_r8,4.3995e+07_r8,2.9330e+07_r8,1.4665e+07_r8,1.7426e+02_r8/)
      kbo(:, 4,56,16) = (/ &
     &5.4632e+07_r8,4.0974e+07_r8,2.7316e+07_r8,1.3658e+07_r8,1.3341e+02_r8/)
      kbo(:, 5,56,16) = (/ &
     &5.0980e+07_r8,3.8235e+07_r8,2.5490e+07_r8,1.2745e+07_r8,7.5113e+01_r8/)
      kbo(:, 1,57,16) = (/ &
     &6.8848e+07_r8,5.1636e+07_r8,3.4424e+07_r8,1.7212e+07_r8,2.3193e+02_r8/)
      kbo(:, 2,57,16) = (/ &
     &6.3831e+07_r8,4.7873e+07_r8,3.1915e+07_r8,1.5958e+07_r8,2.0396e+02_r8/)
      kbo(:, 3,57,16) = (/ &
     &5.9337e+07_r8,4.4503e+07_r8,2.9325e+07_r8,1.4834e+07_r8,1.8090e+02_r8/)
      kbo(:, 4,57,16) = (/ &
     &5.5232e+07_r8,4.1423e+07_r8,2.7615e+07_r8,1.3808e+07_r8,1.4946e+02_r8/)
      kbo(:, 5,57,16) = (/ &
     &5.1498e+07_r8,3.8623e+07_r8,2.5749e+07_r8,1.2874e+07_r8,9.6802e+01_r8/)
      kbo(:, 1,58,16) = (/ &
     &1.8392e+07_r8,1.6863e+07_r8,1.4458e+07_r8,1.0126e+07_r8,2.4193e+02_r8/)
      kbo(:, 2,58,16) = (/ &
     &1.7018e+07_r8,1.5603e+07_r8,1.3378e+07_r8,9.3701e+06_r8,2.1195e+02_r8/)
      kbo(:, 3,58,16) = (/ &
     &1.5812e+07_r8,1.4497e+07_r8,1.2430e+07_r8,8.7057e+06_r8,1.8755e+02_r8/)
      kbo(:, 4,58,16) = (/ &
     &1.4710e+07_r8,1.3487e+07_r8,1.1564e+07_r8,8.0993e+06_r8,1.6722e+02_r8/)
      kbo(:, 5,58,16) = (/ &
     &1.3707e+07_r8,1.2567e+07_r8,1.0775e+07_r8,7.5470e+06_r8,1.3461e+02_r8/)
      kbo(:, 1,59,16) = (/ &
     &2.1701e+07_r8,1.8948e+07_r8,1.5114e+07_r8,9.4051e+06_r8,2.4616e+02_r8/)
      kbo(:, 2,59,16) = (/ &
     &2.0062e+07_r8,1.7517e+07_r8,1.3973e+07_r8,8.5918e+06_r8,2.1536e+02_r8/)
      kbo(:, 3,59,16) = (/ &
     &1.8637e+07_r8,1.6273e+07_r8,1.2980e+07_r8,8.0770e+06_r8,1.9038e+02_r8/)
      kbo(:, 4,59,16) = (/ &
     &1.7332e+07_r8,1.5134e+07_r8,1.2072e+07_r8,7.5118e+06_r8,1.6959e+02_r8/)
      kbo(:, 5,59,16) = (/ &
     &1.6145e+07_r8,1.4097e+07_r8,1.1245e+07_r8,6.9973e+06_r8,1.5180e+02_r8/)

!     The array FORREFO contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  The first 
!     index refers to reference temperature (296,260,224,260) and 
!     pressure (970,475,219,3 mbar) levels.  The second index 
!     runs over the g-channel (1 to 16).

      forrefo(1,:) = (/ &
     &3.3839e-04_r8,2.4739e-04_r8,2.2846e-04_r8,2.3376e-04_r8,2.2622e-04_r8,2.3188e-04_r8, &
     &2.2990e-04_r8,2.2532e-04_r8,2.1233e-04_r8,2.0593e-04_r8,2.0716e-04_r8,2.0809e-04_r8, &
     &2.0889e-04_r8,2.0932e-04_r8,2.0944e-04_r8,2.0945e-04_r8/)
      forrefo(2,:) = (/ &
     &3.4391e-04_r8,2.6022e-04_r8,2.3449e-04_r8,2.4544e-04_r8,2.3831e-04_r8,2.3014e-04_r8, &
     &2.3729e-04_r8,2.2726e-04_r8,2.1892e-04_r8,1.9223e-04_r8,2.1291e-04_r8,2.1406e-04_r8, &
     &2.1491e-04_r8,2.1548e-04_r8,2.1562e-04_r8,2.1567e-04_r8/)
      forrefo(3,:) = (/ &
     &3.4219e-04_r8,2.7334e-04_r8,2.3727e-04_r8,2.4515e-04_r8,2.5272e-04_r8,2.4212e-04_r8, &
     &2.3824e-04_r8,2.3615e-04_r8,2.2724e-04_r8,2.2381e-04_r8,1.9634e-04_r8,2.1625e-04_r8, &
     &2.1963e-04_r8,2.2032e-04_r8,2.2057e-04_r8,2.2058e-04_r8/)
      forrefo(4,:) = (/ &
     &3.1684e-04_r8,2.4823e-04_r8,2.4890e-04_r8,2.4577e-04_r8,2.4106e-04_r8,2.4353e-04_r8, &
     &2.4038e-04_r8,2.3932e-04_r8,2.3604e-04_r8,2.3773e-04_r8,2.4243e-04_r8,2.2597e-04_r8, &
     &2.2879e-04_r8,2.2440e-04_r8,2.1104e-04_r8,2.1460e-04_r8/)

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      selfrefo(:, 1) = (/ &
     & 2.62922e-01_r8, 2.29106e-01_r8, 1.99640e-01_r8, 1.73964e-01_r8, 1.51589e-01_r8, &
     & 1.32093e-01_r8, 1.15104e-01_r8, 1.00300e-01_r8, 8.74000e-02_r8, 7.61592e-02_r8/)
      selfrefo(:, 2) = (/ &
     & 2.45448e-01_r8, 2.13212e-01_r8, 1.85210e-01_r8, 1.60886e-01_r8, 1.39756e-01_r8, &
     & 1.21401e-01_r8, 1.05457e-01_r8, 9.16070e-02_r8, 7.95759e-02_r8, 6.91249e-02_r8/)
      selfrefo(:, 3) = (/ &
     & 2.41595e-01_r8, 2.09697e-01_r8, 1.82010e-01_r8, 1.57979e-01_r8, 1.37121e-01_r8, &
     & 1.19016e-01_r8, 1.03302e-01_r8, 8.96630e-02_r8, 7.78246e-02_r8, 6.75492e-02_r8/)
      selfrefo(:, 4) = (/ &
     & 2.44818e-01_r8, 2.12172e-01_r8, 1.83880e-01_r8, 1.59360e-01_r8, 1.38110e-01_r8, &
     & 1.19694e-01_r8, 1.03733e-01_r8, 8.99010e-02_r8, 7.79131e-02_r8, 6.75238e-02_r8/)
      selfrefo(:, 5) = (/ &
     & 2.43458e-01_r8, 2.10983e-01_r8, 1.82840e-01_r8, 1.58451e-01_r8, 1.37315e-01_r8, &
     & 1.18998e-01_r8, 1.03125e-01_r8, 8.93690e-02_r8, 7.74480e-02_r8, 6.71171e-02_r8/)
      selfrefo(:, 6) = (/ &
     & 2.40186e-01_r8, 2.08745e-01_r8, 1.81420e-01_r8, 1.57672e-01_r8, 1.37032e-01_r8, &
     & 1.19095e-01_r8, 1.03505e-01_r8, 8.99560e-02_r8, 7.81806e-02_r8, 6.79467e-02_r8/)
      selfrefo(:, 7) = (/ &
     & 2.42752e-01_r8, 2.10579e-01_r8, 1.82670e-01_r8, 1.58460e-01_r8, 1.37459e-01_r8, &
     & 1.19240e-01_r8, 1.03437e-01_r8, 8.97280e-02_r8, 7.78359e-02_r8, 6.75200e-02_r8/)
      selfrefo(:, 8) = (/ &
     & 2.39620e-01_r8, 2.08166e-01_r8, 1.80840e-01_r8, 1.57101e-01_r8, 1.36479e-01_r8, &
     & 1.18563e-01_r8, 1.03000e-01_r8, 8.94790e-02_r8, 7.77332e-02_r8, 6.75292e-02_r8/)
      selfrefo(:, 9) = (/ &
     & 2.38856e-01_r8, 2.07166e-01_r8, 1.79680e-01_r8, 1.55841e-01_r8, 1.35165e-01_r8, &
     & 1.17232e-01_r8, 1.01678e-01_r8, 8.81880e-02_r8, 7.64877e-02_r8, 6.63397e-02_r8/)
      selfrefo(:,10) = (/ &
     & 2.29821e-01_r8, 2.00586e-01_r8, 1.75070e-01_r8, 1.52800e-01_r8, 1.33363e-01_r8, &
     & 1.16398e-01_r8, 1.01591e-01_r8, 8.86680e-02_r8, 7.73887e-02_r8, 6.75443e-02_r8/)
      selfrefo(:,11) = (/ &
     & 2.39945e-01_r8, 2.08186e-01_r8, 1.80630e-01_r8, 1.56722e-01_r8, 1.35978e-01_r8, &
     & 1.17980e-01_r8, 1.02364e-01_r8, 8.88150e-02_r8, 7.70594e-02_r8, 6.68598e-02_r8/)
      selfrefo(:,12) = (/ &
     & 2.40271e-01_r8, 2.08465e-01_r8, 1.80870e-01_r8, 1.56927e-01_r8, 1.36154e-01_r8, &
     & 1.18131e-01_r8, 1.02494e-01_r8, 8.89260e-02_r8, 7.71545e-02_r8, 6.69412e-02_r8/)
      selfrefo(:,13) = (/ &
     & 2.40503e-01_r8, 2.08670e-01_r8, 1.81050e-01_r8, 1.57086e-01_r8, 1.36294e-01_r8, &
     & 1.18254e-01_r8, 1.02602e-01_r8, 8.90210e-02_r8, 7.72380e-02_r8, 6.70147e-02_r8/)
      selfrefo(:,14) = (/ &
     & 2.40670e-01_r8, 2.08811e-01_r8, 1.81170e-01_r8, 1.57188e-01_r8, 1.36380e-01_r8, &
     & 1.18327e-01_r8, 1.02663e-01_r8, 8.90730e-02_r8, 7.72819e-02_r8, 6.70517e-02_r8/)
      selfrefo(:,15) = (/ &
     & 2.40711e-01_r8, 2.08846e-01_r8, 1.81200e-01_r8, 1.57213e-01_r8, 1.36402e-01_r8, &
     & 1.18346e-01_r8, 1.02679e-01_r8, 8.90870e-02_r8, 7.72939e-02_r8, 6.70621e-02_r8/)
      selfrefo(:,16) = (/ &
     & 2.40727e-01_r8, 2.08859e-01_r8, 1.81210e-01_r8, 1.57221e-01_r8, 1.36408e-01_r8, &
     & 1.18350e-01_r8, 1.02682e-01_r8, 8.90890e-02_r8, 7.72952e-02_r8, 6.70627e-02_r8/)

      end subroutine lw_kgb04

! **************************************************************************
