!     path:      $Source: /storm/rc1/cvsroot/rc/rrtmg_lw/src/rrtmg_lw_k_g.f90,v $
!     author:    $Author: mike $
!     revision:  $Revision: 1.2 $
!     created:   $Date: 2007/08/22 19:20:03 $
!
!  --------------------------------------------------------------------------
! |                                                                          |
! |  Copyright 2002-2007, Atmospheric & Environmental Research, Inc. (AER).  |
! |  This software may be used, copied, or redistributed as long as it is    |
! |  not sold and this copyright notice is reproduced on each copy made.     |
! |  This model is provided as is without any express or implied warranties. |
! |                       (http://www.rtweb.aer.com/)                        |
! |                                                                          |
!  --------------------------------------------------------------------------

! **************************************************************************
!      subroutine lw_kgbnn
! **************************************************************************
!  RRTM Longwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original version:   E. J. Mlawer, et al.
!  Revision for GCMs:  Michael J. Iacono; October, 2002
!
!  This file contains 16 subroutines that include the 
!  absorption coefficients and other data for each of the 16 longwave
!  spectral bands used in RRTM.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_LW_INIT to reduce
!  the total number of g-points from 256 to 140 for use in the GCM.
! **************************************************************************
      subroutine lw_kgb01
! **************************************************************************

      use shr_kind_mod, only: r8 => shr_kind_r8

!      use parkind, only : jpim, jprb 
      use rrlw_kg01, only : fracrefao, fracrefbo, kao, kbo, kao_mn2, kbo_mn2, &
                            selfrefo, forrefo
      use rrlw_vsn, only: hvrkg, hnamkg

      implicit none
      save

      hvrkg = '$Revision: 1.2 $'

! Planck fraction mapping level: P = 212.7250 mbar, T = 223.06 K
      fracrefao(:) = (/ &
        2.1227E-01_r8,1.8897E-01_r8,1.3934E-01_r8,1.1557E-01_r8,9.5282E-02_r8,8.3359E-02_r8, &
        6.5333E-02_r8,5.2016E-02_r8,3.4272E-02_r8,4.0257E-03_r8,3.1857E-03_r8,2.6014E-03_r8, &
        1.9141E-03_r8,1.2612E-03_r8,5.3169E-04_r8,7.6476E-05_r8/)

! Planck fraction mapping level: P = 212.7250 mbar, T = 223.06 K
! These Planck fractions were calculated using lower atmosphere
! parameters.
      fracrefbo(:) = (/ &
        2.1227E-01_r8,1.8897E-01_r8,1.3934E-01_r8,1.1557E-01_r8,9.5282E-02_r8,8.3359E-02_r8, &
        6.5333E-02_r8,5.2016E-02_r8,3.4272E-02_r8,4.0257E-03_r8,3.1857E-03_r8,2.6014E-03_r8, &
        1.9141E-03_r8,1.2612E-03_r8,5.3169E-04_r8,7.6476E-05_r8/)

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels > ~100mb and temperatures.  The first
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the corresponding TREF for this  pressure level, 
!     JT = 2 refers to the temperatureTREF-15, JT = 1 is for TREF-30, 
!     JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  The second 
!     index, JP, runs from 1 to 13 and refers to the corresponding 
!     pressure level in PREF (e.g. JP = 1 is for a pressure of 1053.63 mb).  
!     The third index, IG, goes from 1 to 16, and tells us which 
!     g-interval the absorption coefficients are for.

      kao(:, 1, 1) = (/ &
     &1.1936e-01_r8,1.2127e-01_r8,1.2290e-01_r8,1.2324e-01_r8,1.2302e-01_r8/)
      kao(:, 2, 1) = (/ &
     &9.3666e-02_r8,9.6336e-02_r8,9.8457e-02_r8,9.9155e-02_r8,9.9330e-02_r8/)
      kao(:, 3, 1) = (/ &
     &7.3480e-02_r8,7.5571e-02_r8,7.7998e-02_r8,7.9619e-02_r8,8.0000e-02_r8/)
      kao(:, 4, 1) = (/ &
     &5.8417e-02_r8,6.0062e-02_r8,6.2150e-02_r8,6.4024e-02_r8,6.4943e-02_r8/)
      kao(:, 5, 1) = (/ &
     &4.6742e-02_r8,4.8171e-02_r8,4.9840e-02_r8,5.1580e-02_r8,5.2974e-02_r8/)
      kao(:, 6, 1) = (/ &
     &3.7093e-02_r8,3.8712e-02_r8,4.0031e-02_r8,4.1473e-02_r8,4.2868e-02_r8/)
      kao(:, 7, 1) = (/ &
     &2.9515e-02_r8,3.1114e-02_r8,3.2344e-02_r8,3.3496e-02_r8,3.4715e-02_r8/)
      kao(:, 8, 1) = (/ &
     &2.3548e-02_r8,2.5012e-02_r8,2.6176e-02_r8,2.7253e-02_r8,2.8263e-02_r8/)
      kao(:, 9, 1) = (/ &
     &1.9136e-02_r8,2.0420e-02_r8,2.1607e-02_r8,2.2607e-02_r8,2.3502e-02_r8/)
      kao(:,10, 1) = (/ &
     &1.6947e-02_r8,1.8986e-02_r8,2.0617e-02_r8,2.1896e-02_r8,2.2928e-02_r8/)
      kao(:,11, 1) = (/ &
     &1.4724e-02_r8,1.6490e-02_r8,1.8468e-02_r8,1.9875e-02_r8,2.1095e-02_r8/)
      kao(:,12, 1) = (/ &
     &1.2332e-02_r8,1.3992e-02_r8,1.5549e-02_r8,1.7137e-02_r8,1.8190e-02_r8/)
      kao(:,13, 1) = (/ &
     &1.0144e-02_r8,1.1539e-02_r8,1.2861e-02_r8,1.4225e-02_r8,1.5224e-02_r8/)
      kao(:, 1, 2) = (/ &
     &3.5138e-01_r8,3.5502e-01_r8,3.5774e-01_r8,3.5894e-01_r8,3.5740e-01_r8/)
      kao(:, 2, 2) = (/ &
     &2.8740e-01_r8,2.8961e-01_r8,2.9119e-01_r8,2.9268e-01_r8,2.9128e-01_r8/)
      kao(:, 3, 2) = (/ &
     &2.3142e-01_r8,2.3495e-01_r8,2.3595e-01_r8,2.3731e-01_r8,2.3828e-01_r8/)
      kao(:, 4, 2) = (/ &
     &1.8684e-01_r8,1.9090e-01_r8,1.9387e-01_r8,1.9355e-01_r8,1.9518e-01_r8/)
      kao(:, 5, 2) = (/ &
     &1.5108e-01_r8,1.5525e-01_r8,1.5832e-01_r8,1.5904e-01_r8,1.5962e-01_r8/)
      kao(:, 6, 2) = (/ &
     &1.2219e-01_r8,1.2585e-01_r8,1.2901e-01_r8,1.3090e-01_r8,1.3158e-01_r8/)
      kao(:, 7, 2) = (/ &
     &9.8743e-02_r8,1.0185e-01_r8,1.0506e-01_r8,1.0763e-01_r8,1.0820e-01_r8/)
      kao(:, 8, 2) = (/ &
     &7.9966e-02_r8,8.2922e-02_r8,8.5859e-02_r8,8.8462e-02_r8,8.9282e-02_r8/)
      kao(:, 9, 2) = (/ &
     &6.5726e-02_r8,6.8954e-02_r8,7.1786e-02_r8,7.3678e-02_r8,7.5233e-02_r8/)
      kao(:,10, 2) = (/ &
     &6.0011e-02_r8,6.2230e-02_r8,6.5254e-02_r8,6.7031e-02_r8,6.9052e-02_r8/)
      kao(:,11, 2) = (/ &
     &5.5743e-02_r8,5.7099e-02_r8,5.8802e-02_r8,6.0875e-02_r8,6.2690e-02_r8/)
      kao(:,12, 2) = (/ &
     &4.9598e-02_r8,5.1234e-02_r8,5.2659e-02_r8,5.3951e-02_r8,5.5431e-02_r8/)
      kao(:,13, 2) = (/ &
     &4.1938e-02_r8,4.3540e-02_r8,4.4990e-02_r8,4.6074e-02_r8,4.6999e-02_r8/)
      kao(:, 1, 3) = (/ &
     &8.4590e-01_r8,8.4151e-01_r8,8.3682e-01_r8,8.3729e-01_r8,8.3944e-01_r8/)
      kao(:, 2, 3) = (/ &
     &6.8809e-01_r8,6.8696e-01_r8,6.8512e-01_r8,6.8470e-01_r8,6.8864e-01_r8/)
      kao(:, 3, 3) = (/ &
     &5.6065e-01_r8,5.5891e-01_r8,5.5871e-01_r8,5.5784e-01_r8,5.6029e-01_r8/)
      kao(:, 4, 3) = (/ &
     &4.6097e-01_r8,4.6021e-01_r8,4.5874e-01_r8,4.6110e-01_r8,4.6088e-01_r8/)
      kao(:, 5, 3) = (/ &
     &3.8076e-01_r8,3.8128e-01_r8,3.8007e-01_r8,3.8126e-01_r8,3.8214e-01_r8/)
      kao(:, 6, 3) = (/ &
     &3.1396e-01_r8,3.1576e-01_r8,3.1554e-01_r8,3.1478e-01_r8,3.1602e-01_r8/)
      kao(:, 7, 3) = (/ &
     &2.5841e-01_r8,2.6039e-01_r8,2.6160e-01_r8,2.6034e-01_r8,2.6147e-01_r8/)
      kao(:, 8, 3) = (/ &
     &2.1354e-01_r8,2.1540e-01_r8,2.1664e-01_r8,2.1675e-01_r8,2.1689e-01_r8/)
      kao(:, 9, 3) = (/ &
     &1.8409e-01_r8,1.8340e-01_r8,1.8423e-01_r8,1.8535e-01_r8,1.8550e-01_r8/)
      kao(:,10, 3) = (/ &
     &1.7687e-01_r8,1.8149e-01_r8,1.8138e-01_r8,1.8043e-01_r8,1.8050e-01_r8/)
      kao(:,11, 3) = (/ &
     &1.6660e-01_r8,1.6980e-01_r8,1.7005e-01_r8,1.7156e-01_r8,1.6983e-01_r8/)
      kao(:,12, 3) = (/ &
     &1.4699e-01_r8,1.5037e-01_r8,1.5032e-01_r8,1.5012e-01_r8,1.5041e-01_r8/)
      kao(:,13, 3) = (/ &
     &1.2497e-01_r8,1.2733e-01_r8,1.2732e-01_r8,1.2710e-01_r8,1.2722e-01_r8/)
      kao(:, 1, 4) = (/ &
     &1.8528e+00_r8,1.8358e+00_r8,1.8100e+00_r8,1.7728e+00_r8,1.7348e+00_r8/)
      kao(:, 2, 4) = (/ &
     &1.5191e+00_r8,1.5067e+00_r8,1.4864e+00_r8,1.4586e+00_r8,1.4273e+00_r8/)
      kao(:, 3, 4) = (/ &
     &1.2421e+00_r8,1.2332e+00_r8,1.2184e+00_r8,1.1999e+00_r8,1.1763e+00_r8/)
      kao(:, 4, 4) = (/ &
     &1.0235e+00_r8,1.0199e+00_r8,1.0105e+00_r8,9.9649e-01_r8,9.8141e-01_r8/)
      kao(:, 5, 4) = (/ &
     &8.4444e-01_r8,8.4579e-01_r8,8.4104e-01_r8,8.3201e-01_r8,8.2148e-01_r8/)
      kao(:, 6, 4) = (/ &
     &6.9623e-01_r8,7.0066e-01_r8,6.9879e-01_r8,6.9507e-01_r8,6.8745e-01_r8/)
      kao(:, 7, 4) = (/ &
     &5.7271e-01_r8,5.7848e-01_r8,5.7971e-01_r8,5.7773e-01_r8,5.7376e-01_r8/)
      kao(:, 8, 4) = (/ &
     &4.7082e-01_r8,4.7730e-01_r8,4.8061e-01_r8,4.7996e-01_r8,4.7783e-01_r8/)
      kao(:, 9, 4) = (/ &
     &3.8997e-01_r8,3.9821e-01_r8,4.0249e-01_r8,4.0315e-01_r8,4.0145e-01_r8/)
      kao(:,10, 4) = (/ &
     &3.5012e-01_r8,3.4335e-01_r8,3.3833e-01_r8,3.3654e-01_r8,3.3448e-01_r8/)
      kao(:,11, 4) = (/ &
     &3.1060e-01_r8,3.1084e-01_r8,3.0440e-01_r8,2.9201e-01_r8,2.8482e-01_r8/)
      kao(:,12, 4) = (/ &
     &2.7883e-01_r8,2.7190e-01_r8,2.6805e-01_r8,2.5917e-01_r8,2.4860e-01_r8/)
      kao(:,13, 4) = (/ &
     &2.3244e-01_r8,2.2666e-01_r8,2.2365e-01_r8,2.1647e-01_r8,2.0828e-01_r8/)
      kao(:, 1, 5) = (/ &
     &3.3225e+00_r8,3.2784e+00_r8,3.2423e+00_r8,3.2074e+00_r8,3.1704e+00_r8/)
      kao(:, 2, 5) = (/ &
     &2.7581e+00_r8,2.7256e+00_r8,2.6962e+00_r8,2.6686e+00_r8,2.6375e+00_r8/)
      kao(:, 3, 5) = (/ &
     &2.2798e+00_r8,2.2570e+00_r8,2.2330e+00_r8,2.2089e+00_r8,2.1829e+00_r8/)
      kao(:, 4, 5) = (/ &
     &1.8979e+00_r8,1.8796e+00_r8,1.8601e+00_r8,1.8393e+00_r8,1.8181e+00_r8/)
      kao(:, 5, 5) = (/ &
     &1.5861e+00_r8,1.5695e+00_r8,1.5550e+00_r8,1.5372e+00_r8,1.5203e+00_r8/)
      kao(:, 6, 5) = (/ &
     &1.3252e+00_r8,1.3124e+00_r8,1.3013e+00_r8,1.2872e+00_r8,1.2740e+00_r8/)
      kao(:, 7, 5) = (/ &
     &1.1027e+00_r8,1.0966e+00_r8,1.0870e+00_r8,1.0776e+00_r8,1.0667e+00_r8/)
      kao(:, 8, 5) = (/ &
     &9.1563e-01_r8,9.1410e-01_r8,9.0764e-01_r8,8.9982e-01_r8,8.9251e-01_r8/)
      kao(:, 9, 5) = (/ &
     &7.6595e-01_r8,7.6784e-01_r8,7.6494e-01_r8,7.5888e-01_r8,7.5288e-01_r8/)
      kao(:,10, 5) = (/ &
     &6.3388e-01_r8,6.4169e-01_r8,6.4724e-01_r8,6.4562e-01_r8,6.3971e-01_r8/)
      kao(:,11, 5) = (/ &
     &5.2794e-01_r8,5.2411e-01_r8,5.2455e-01_r8,5.2936e-01_r8,5.2927e-01_r8/)
      kao(:,12, 5) = (/ &
     &4.3721e-01_r8,4.3826e-01_r8,4.3490e-01_r8,4.3598e-01_r8,4.3794e-01_r8/)
      kao(:,13, 5) = (/ &
     &3.6693e-01_r8,3.6670e-01_r8,3.6374e-01_r8,3.6513e-01_r8,3.6694e-01_r8/)
      kao(:, 1, 6) = (/ &
     &6.6283e+00_r8,6.5357e+00_r8,6.4205e+00_r8,6.3046e+00_r8,6.1937e+00_r8/)
      kao(:, 2, 6) = (/ &
     &5.5921e+00_r8,5.5122e+00_r8,5.4227e+00_r8,5.3355e+00_r8,5.2548e+00_r8/)
      kao(:, 3, 6) = (/ &
     &4.6918e+00_r8,4.6295e+00_r8,4.5667e+00_r8,4.5016e+00_r8,4.4390e+00_r8/)
      kao(:, 4, 6) = (/ &
     &3.9477e+00_r8,3.9046e+00_r8,3.8607e+00_r8,3.8148e+00_r8,3.7628e+00_r8/)
      kao(:, 5, 6) = (/ &
     &3.3255e+00_r8,3.2963e+00_r8,3.2647e+00_r8,3.2299e+00_r8,3.1875e+00_r8/)
      kao(:, 6, 6) = (/ &
     &2.7972e+00_r8,2.7784e+00_r8,2.7561e+00_r8,2.7282e+00_r8,2.6941e+00_r8/)
      kao(:, 7, 6) = (/ &
     &2.3458e+00_r8,2.3342e+00_r8,2.3185e+00_r8,2.2969e+00_r8,2.2704e+00_r8/)
      kao(:, 8, 6) = (/ &
     &1.9572e+00_r8,1.9527e+00_r8,1.9423e+00_r8,1.9266e+00_r8,1.9056e+00_r8/)
      kao(:, 9, 6) = (/ &
     &1.6385e+00_r8,1.6357e+00_r8,1.6281e+00_r8,1.6171e+00_r8,1.6000e+00_r8/)
      kao(:,10, 6) = (/ &
     &1.4144e+00_r8,1.4143e+00_r8,1.4078e+00_r8,1.4009e+00_r8,1.3895e+00_r8/)
      kao(:,11, 6) = (/ &
     &1.1820e+00_r8,1.1847e+00_r8,1.1842e+00_r8,1.1773e+00_r8,1.1681e+00_r8/)
      kao(:,12, 6) = (/ &
     &9.7725e-01_r8,9.8091e-01_r8,9.8204e-01_r8,9.7703e-01_r8,9.7159e-01_r8/)
      kao(:,13, 6) = (/ &
     &8.1815e-01_r8,8.2185e-01_r8,8.2056e-01_r8,8.1693e-01_r8,8.1119e-01_r8/)
      kao(:, 1, 7) = (/ &
     &1.4313e+01_r8,1.4082e+01_r8,1.3850e+01_r8,1.3623e+01_r8,1.3382e+01_r8/)
      kao(:, 2, 7) = (/ &
     &1.2515e+01_r8,1.2314e+01_r8,1.2108e+01_r8,1.1882e+01_r8,1.1633e+01_r8/)
      kao(:, 3, 7) = (/ &
     &1.0802e+01_r8,1.0631e+01_r8,1.0439e+01_r8,1.0228e+01_r8,1.0005e+01_r8/)
      kao(:, 4, 7) = (/ &
     &9.2958e+00_r8,9.1469e+00_r8,8.9753e+00_r8,8.7884e+00_r8,8.6020e+00_r8/)
      kao(:, 5, 7) = (/ &
     &7.9646e+00_r8,7.8400e+00_r8,7.6929e+00_r8,7.5385e+00_r8,7.3901e+00_r8/)
      kao(:, 6, 7) = (/ &
     &6.7986e+00_r8,6.6983e+00_r8,6.5761e+00_r8,6.4518e+00_r8,6.3346e+00_r8/)
      kao(:, 7, 7) = (/ &
     &5.7703e+00_r8,5.6909e+00_r8,5.5962e+00_r8,5.4989e+00_r8,5.4062e+00_r8/)
      kao(:, 8, 7) = (/ &
     &4.8763e+00_r8,4.8159e+00_r8,4.7441e+00_r8,4.6692e+00_r8,4.5978e+00_r8/)
      kao(:, 9, 7) = (/ &
     &4.0868e+00_r8,4.0475e+00_r8,3.9918e+00_r8,3.9346e+00_r8,3.8784e+00_r8/)
      kao(:,10, 7) = (/ &
     &3.5589e+00_r8,3.5215e+00_r8,3.4698e+00_r8,3.4096e+00_r8,3.3531e+00_r8/)
      kao(:,11, 7) = (/ &
     &3.0702e+00_r8,3.0357e+00_r8,2.9927e+00_r8,2.9456e+00_r8,2.8950e+00_r8/)
      kao(:,12, 7) = (/ &
     &2.6022e+00_r8,2.5722e+00_r8,2.5392e+00_r8,2.5002e+00_r8,2.4548e+00_r8/)
      kao(:,13, 7) = (/ &
     &2.1727e+00_r8,2.1507e+00_r8,2.1220e+00_r8,2.0892e+00_r8,2.0541e+00_r8/)
      kao(:, 1, 8) = (/ &
     &3.4174e+01_r8,3.3741e+01_r8,3.3273e+01_r8,3.2762e+01_r8,3.2231e+01_r8/)
      kao(:, 2, 8) = (/ &
     &3.1501e+01_r8,3.1077e+01_r8,3.0621e+01_r8,3.0167e+01_r8,2.9717e+01_r8/)
      kao(:, 3, 8) = (/ &
     &2.8624e+01_r8,2.8247e+01_r8,2.7846e+01_r8,2.7455e+01_r8,2.7037e+01_r8/)
      kao(:, 4, 8) = (/ &
     &2.5860e+01_r8,2.5530e+01_r8,2.5179e+01_r8,2.4813e+01_r8,2.4424e+01_r8/)
      kao(:, 5, 8) = (/ &
     &2.3133e+01_r8,2.2868e+01_r8,2.2552e+01_r8,2.2222e+01_r8,2.1874e+01_r8/)
      kao(:, 6, 8) = (/ &
     &2.0417e+01_r8,2.0203e+01_r8,1.9954e+01_r8,1.9685e+01_r8,1.9370e+01_r8/)
      kao(:, 7, 8) = (/ &
     &1.7808e+01_r8,1.7656e+01_r8,1.7468e+01_r8,1.7234e+01_r8,1.6957e+01_r8/)
      kao(:, 8, 8) = (/ &
     &1.5349e+01_r8,1.5257e+01_r8,1.5109e+01_r8,1.4918e+01_r8,1.4683e+01_r8/)
      kao(:, 9, 8) = (/ &
     &1.3085e+01_r8,1.3031e+01_r8,1.2930e+01_r8,1.2779e+01_r8,1.2590e+01_r8/)
      kao(:,10, 8) = (/ &
     &1.0971e+01_r8,1.0917e+01_r8,1.0852e+01_r8,1.0748e+01_r8,1.0603e+01_r8/)
      kao(:,11, 8) = (/ &
     &9.5673e+00_r8,9.4985e+00_r8,9.4337e+00_r8,9.3153e+00_r8,9.1800e+00_r8/)
      kao(:,12, 8) = (/ &
     &8.2885e+00_r8,8.2471e+00_r8,8.1591e+00_r8,8.0541e+00_r8,7.9348e+00_r8/)
      kao(:,13, 8) = (/ &
     &7.1017e+00_r8,7.0462e+00_r8,6.9629e+00_r8,6.8569e+00_r8,6.7518e+00_r8/)
      kao(:, 1, 9) = (/ &
     &9.9761e+01_r8,9.8762e+01_r8,9.7605e+01_r8,9.6340e+01_r8,9.4995e+01_r8/)
      kao(:, 2, 9) = (/ &
     &9.9948e+01_r8,9.8866e+01_r8,9.7644e+01_r8,9.6363e+01_r8,9.4985e+01_r8/)
      kao(:, 3, 9) = (/ &
     &9.9007e+01_r8,9.8007e+01_r8,9.6838e+01_r8,9.5570e+01_r8,9.4251e+01_r8/)
      kao(:, 4, 9) = (/ &
     &9.6662e+01_r8,9.5791e+01_r8,9.4804e+01_r8,9.3746e+01_r8,9.2558e+01_r8/)
      kao(:, 5, 9) = (/ &
     &9.3093e+01_r8,9.2470e+01_r8,9.1704e+01_r8,9.0779e+01_r8,8.9739e+01_r8/)
      kao(:, 6, 9) = (/ &
     &8.8508e+01_r8,8.8114e+01_r8,8.7530e+01_r8,8.6816e+01_r8,8.5948e+01_r8/)
      kao(:, 7, 9) = (/ &
     &8.2974e+01_r8,8.2771e+01_r8,8.2394e+01_r8,8.1879e+01_r8,8.1118e+01_r8/)
      kao(:, 8, 9) = (/ &
     &7.6684e+01_r8,7.6645e+01_r8,7.6457e+01_r8,7.6020e+01_r8,7.5326e+01_r8/)
      kao(:, 9, 9) = (/ &
     &6.9973e+01_r8,7.0055e+01_r8,6.9978e+01_r8,6.9596e+01_r8,6.8941e+01_r8/)
      kao(:,10, 9) = (/ &
     &6.2676e+01_r8,6.2928e+01_r8,6.2907e+01_r8,6.2549e+01_r8,6.1993e+01_r8/)
      kao(:,11, 9) = (/ &
     &5.5263e+01_r8,5.5480e+01_r8,5.5306e+01_r8,5.4944e+01_r8,5.4442e+01_r8/)
      kao(:,12, 9) = (/ &
     &4.8636e+01_r8,4.8624e+01_r8,4.8458e+01_r8,4.8148e+01_r8,4.7712e+01_r8/)
      kao(:,13, 9) = (/ &
     &4.2167e+01_r8,4.2169e+01_r8,4.2037e+01_r8,4.1794e+01_r8,4.1453e+01_r8/)
      kao(:, 1,10) = (/ &
     &2.2059e+02_r8,2.1997e+02_r8,2.1921e+02_r8,2.1843e+02_r8,2.1743e+02_r8/)
      kao(:, 2,10) = (/ &
     &2.3102e+02_r8,2.3132e+02_r8,2.3151e+02_r8,2.3081e+02_r8,2.3008e+02_r8/)
      kao(:, 3,10) = (/ &
     &2.4111e+02_r8,2.4197e+02_r8,2.4166e+02_r8,2.4016e+02_r8,2.3836e+02_r8/)
      kao(:, 4,10) = (/ &
     &2.5158e+02_r8,2.5229e+02_r8,2.5082e+02_r8,2.4795e+02_r8,2.4522e+02_r8/)
      kao(:, 5,10) = (/ &
     &2.5765e+02_r8,2.5772e+02_r8,2.5582e+02_r8,2.5268e+02_r8,2.4923e+02_r8/)
      kao(:, 6,10) = (/ &
     &2.5856e+02_r8,2.5749e+02_r8,2.5502e+02_r8,2.5166e+02_r8,2.4826e+02_r8/)
      kao(:, 7,10) = (/ &
     &2.5368e+02_r8,2.5237e+02_r8,2.4999e+02_r8,2.4711e+02_r8,2.4470e+02_r8/)
      kao(:, 8,10) = (/ &
     &2.4476e+02_r8,2.4415e+02_r8,2.4213e+02_r8,2.4060e+02_r8,2.3968e+02_r8/)
      kao(:, 9,10) = (/ &
     &2.3178e+02_r8,2.3169e+02_r8,2.3048e+02_r8,2.3066e+02_r8,2.3132e+02_r8/)
      kao(:,10,10) = (/ &
     &2.1736e+02_r8,2.1726e+02_r8,2.1730e+02_r8,2.1880e+02_r8,2.1934e+02_r8/)
      kao(:,11,10) = (/ &
     &2.0114e+02_r8,2.0172e+02_r8,2.0351e+02_r8,2.0457e+02_r8,2.0387e+02_r8/)
      kao(:,12,10) = (/ &
     &1.8488e+02_r8,1.8650e+02_r8,1.8715e+02_r8,1.8619e+02_r8,1.8458e+02_r8/)
      kao(:,13,10) = (/ &
     &1.7142e+02_r8,1.7281e+02_r8,1.7236e+02_r8,1.7114e+02_r8,1.6934e+02_r8/)
      kao(:, 1,11) = (/ &
     &2.9459e+02_r8,2.9267e+02_r8,2.9151e+02_r8,2.8931e+02_r8,2.8695e+02_r8/)
      kao(:, 2,11) = (/ &
     &3.1654e+02_r8,3.1722e+02_r8,3.1773e+02_r8,3.1519e+02_r8,3.1185e+02_r8/)
      kao(:, 3,11) = (/ &
     &3.3345e+02_r8,3.3361e+02_r8,3.3487e+02_r8,3.3474e+02_r8,3.3330e+02_r8/)
      kao(:, 4,11) = (/ &
     &3.4222e+02_r8,3.4143e+02_r8,3.4230e+02_r8,3.4254e+02_r8,3.4132e+02_r8/)
      kao(:, 5,11) = (/ &
     &3.5206e+02_r8,3.5057e+02_r8,3.4997e+02_r8,3.4857e+02_r8,3.4588e+02_r8/)
      kao(:, 6,11) = (/ &
     &3.6028e+02_r8,3.6070e+02_r8,3.6119e+02_r8,3.5790e+02_r8,3.5262e+02_r8/)
      kao(:, 7,11) = (/ &
     &3.6620e+02_r8,3.6652e+02_r8,3.6631e+02_r8,3.6276e+02_r8,3.5799e+02_r8/)
      kao(:, 8,11) = (/ &
     &3.6855e+02_r8,3.6845e+02_r8,3.6741e+02_r8,3.6316e+02_r8,3.5815e+02_r8/)
      kao(:, 9,11) = (/ &
     &3.6490e+02_r8,3.6506e+02_r8,3.6353e+02_r8,3.5922e+02_r8,3.5455e+02_r8/)
      kao(:,10,11) = (/ &
     &3.5317e+02_r8,3.5433e+02_r8,3.5339e+02_r8,3.5013e+02_r8,3.4719e+02_r8/)
      kao(:,11,11) = (/ &
     &3.3639e+02_r8,3.3748e+02_r8,3.3591e+02_r8,3.3444e+02_r8,3.3466e+02_r8/)
      kao(:,12,11) = (/ &
     &3.1388e+02_r8,3.1454e+02_r8,3.1501e+02_r8,3.1656e+02_r8,3.1666e+02_r8/)
      kao(:,13,11) = (/ &
     &2.9044e+02_r8,2.9107e+02_r8,2.9274e+02_r8,2.9324e+02_r8,2.9124e+02_r8/)
      kao(:, 1,12) = (/ &
     &3.8243e+02_r8,3.8335e+02_r8,3.8560e+02_r8,3.8967e+02_r8,3.9390e+02_r8/)
      kao(:, 2,12) = (/ &
     &4.2476e+02_r8,4.2018e+02_r8,4.1643e+02_r8,4.1764e+02_r8,4.1841e+02_r8/)
      kao(:, 3,12) = (/ &
     &4.5902e+02_r8,4.5366e+02_r8,4.4789e+02_r8,4.4616e+02_r8,4.4366e+02_r8/)
      kao(:, 4,12) = (/ &
     &4.8576e+02_r8,4.8192e+02_r8,4.7838e+02_r8,4.7712e+02_r8,4.7436e+02_r8/)
      kao(:, 5,12) = (/ &
     &5.0548e+02_r8,5.0130e+02_r8,4.9886e+02_r8,4.9965e+02_r8,4.9992e+02_r8/)
      kao(:, 6,12) = (/ &
     &5.2714e+02_r8,5.1902e+02_r8,5.1379e+02_r8,5.1543e+02_r8,5.1780e+02_r8/)
      kao(:, 7,12) = (/ &
     &5.5149e+02_r8,5.4136e+02_r8,5.3395e+02_r8,5.3343e+02_r8,5.3337e+02_r8/)
      kao(:, 8,12) = (/ &
     &5.7260e+02_r8,5.6332e+02_r8,5.5702e+02_r8,5.5596e+02_r8,5.5242e+02_r8/)
      kao(:, 9,12) = (/ &
     &5.8640e+02_r8,5.7843e+02_r8,5.7443e+02_r8,5.7374e+02_r8,5.6970e+02_r8/)
      kao(:,10,12) = (/ &
     &5.9437e+02_r8,5.8760e+02_r8,5.8375e+02_r8,5.8166e+02_r8,5.7639e+02_r8/)
      kao(:,11,12) = (/ &
     &5.8998e+02_r8,5.8468e+02_r8,5.8336e+02_r8,5.7943e+02_r8,5.7161e+02_r8/)
      kao(:,12,12) = (/ &
     &5.7429e+02_r8,5.7360e+02_r8,5.7128e+02_r8,5.6564e+02_r8,5.6011e+02_r8/)
      kao(:,13,12) = (/ &
     &5.5035e+02_r8,5.5083e+02_r8,5.4893e+02_r8,5.4549e+02_r8,5.4357e+02_r8/)
      kao(:, 1,13) = (/ &
     &4.9343e+02_r8,4.9586e+02_r8,4.9750e+02_r8,4.9873e+02_r8,4.9898e+02_r8/)
      kao(:, 2,13) = (/ &
     &5.4485e+02_r8,5.4781e+02_r8,5.5082e+02_r8,5.5168e+02_r8,5.5417e+02_r8/)
      kao(:, 3,13) = (/ &
     &6.1399e+02_r8,6.1257e+02_r8,6.1216e+02_r8,6.1051e+02_r8,6.1193e+02_r8/)
      kao(:, 4,13) = (/ &
     &6.9330e+02_r8,6.8682e+02_r8,6.8040e+02_r8,6.7417e+02_r8,6.7247e+02_r8/)
      kao(:, 5,13) = (/ &
     &7.6881e+02_r8,7.6265e+02_r8,7.5375e+02_r8,7.4386e+02_r8,7.3721e+02_r8/)
      kao(:, 6,13) = (/ &
     &8.3052e+02_r8,8.2987e+02_r8,8.2363e+02_r8,8.1336e+02_r8,8.0445e+02_r8/)
      kao(:, 7,13) = (/ &
     &8.8082e+02_r8,8.8344e+02_r8,8.8117e+02_r8,8.7395e+02_r8,8.6653e+02_r8/)
      kao(:, 8,13) = (/ &
     &9.2485e+02_r8,9.2603e+02_r8,9.2355e+02_r8,9.1727e+02_r8,9.1414e+02_r8/)
      kao(:, 9,13) = (/ &
     &9.7276e+02_r8,9.7146e+02_r8,9.6566e+02_r8,9.5635e+02_r8,9.5212e+02_r8/)
      kao(:,10,13) = (/ &
     &1.0175e+03_r8,1.0163e+03_r8,1.0069e+03_r8,9.9610e+02_r8,9.9075e+02_r8/)
      kao(:,11,13) = (/ &
     &1.0564e+03_r8,1.0547e+03_r8,1.0423e+03_r8,1.0316e+03_r8,1.0272e+03_r8/)
      kao(:,12,13) = (/ &
     &1.0856e+03_r8,1.0807e+03_r8,1.0716e+03_r8,1.0657e+03_r8,1.0617e+03_r8/)
      kao(:,13,13) = (/ &
     &1.1006e+03_r8,1.0930e+03_r8,1.0868e+03_r8,1.0845e+03_r8,1.0783e+03_r8/)
      kao(:, 1,14) = (/ &
     &7.0211e+02_r8,7.0175e+02_r8,7.0131e+02_r8,6.9909e+02_r8,6.9776e+02_r8/)
      kao(:, 2,14) = (/ &
     &7.9113e+02_r8,7.9461e+02_r8,7.9834e+02_r8,7.9969e+02_r8,7.9813e+02_r8/)
      kao(:, 3,14) = (/ &
     &8.8896e+02_r8,8.9686e+02_r8,9.0679e+02_r8,9.1320e+02_r8,9.1562e+02_r8/)
      kao(:, 4,14) = (/ &
     &9.9457e+02_r8,1.0048e+03_r8,1.0163e+03_r8,1.0256e+03_r8,1.0309e+03_r8/)
      kao(:, 5,14) = (/ &
     &1.1171e+03_r8,1.1226e+03_r8,1.1342e+03_r8,1.1464e+03_r8,1.1541e+03_r8/)
      kao(:, 6,14) = (/ &
     &1.2650e+03_r8,1.2607e+03_r8,1.2659e+03_r8,1.2764e+03_r8,1.2854e+03_r8/)
      kao(:, 7,14) = (/ &
     &1.4362e+03_r8,1.4239e+03_r8,1.4228e+03_r8,1.4266e+03_r8,1.4315e+03_r8/)
      kao(:, 8,14) = (/ &
     &1.6263e+03_r8,1.6088e+03_r8,1.5994e+03_r8,1.5975e+03_r8,1.5958e+03_r8/)
      kao(:, 9,14) = (/ &
     &1.8039e+03_r8,1.7901e+03_r8,1.7817e+03_r8,1.7757e+03_r8,1.7698e+03_r8/)
      kao(:,10,14) = (/ &
     &1.9623e+03_r8,1.9495e+03_r8,1.9467e+03_r8,1.9462e+03_r8,1.9411e+03_r8/)
      kao(:,11,14) = (/ &
     &2.1010e+03_r8,2.0894e+03_r8,2.0912e+03_r8,2.0963e+03_r8,2.0914e+03_r8/)
      kao(:,12,14) = (/ &
     &2.2319e+03_r8,2.2209e+03_r8,2.2201e+03_r8,2.2217e+03_r8,2.2137e+03_r8/)
      kao(:,13,14) = (/ &
     &2.3516e+03_r8,2.3425e+03_r8,2.3393e+03_r8,2.3344e+03_r8,2.3274e+03_r8/)
      kao(:, 1,15) = (/ &
     &1.0409e+03_r8,1.0602e+03_r8,1.0710e+03_r8,1.0853e+03_r8,1.1018e+03_r8/)
      kao(:, 2,15) = (/ &
     &1.2151e+03_r8,1.2303e+03_r8,1.2347e+03_r8,1.2478e+03_r8,1.2680e+03_r8/)
      kao(:, 3,15) = (/ &
     &1.4193e+03_r8,1.4320e+03_r8,1.4382e+03_r8,1.4463e+03_r8,1.4605e+03_r8/)
      kao(:, 4,15) = (/ &
     &1.6341e+03_r8,1.6472e+03_r8,1.6601e+03_r8,1.6700e+03_r8,1.6846e+03_r8/)
      kao(:, 5,15) = (/ &
     &1.8786e+03_r8,1.8904e+03_r8,1.9028e+03_r8,1.9104e+03_r8,1.9250e+03_r8/)
      kao(:, 6,15) = (/ &
     &2.1492e+03_r8,2.1663e+03_r8,2.1776e+03_r8,2.1833e+03_r8,2.1940e+03_r8/)
      kao(:, 7,15) = (/ &
     &2.4310e+03_r8,2.4567e+03_r8,2.4727e+03_r8,2.4804e+03_r8,2.4891e+03_r8/)
      kao(:, 8,15) = (/ &
     &2.7261e+03_r8,2.7552e+03_r8,2.7803e+03_r8,2.7970e+03_r8,2.8141e+03_r8/)
      kao(:, 9,15) = (/ &
     &3.0867e+03_r8,3.0994e+03_r8,3.1170e+03_r8,3.1402e+03_r8,3.1679e+03_r8/)
      kao(:,10,15) = (/ &
     &3.5269e+03_r8,3.5204e+03_r8,3.5225e+03_r8,3.5345e+03_r8,3.5601e+03_r8/)
      kao(:,11,15) = (/ &
     &4.0271e+03_r8,4.0096e+03_r8,4.0024e+03_r8,4.0052e+03_r8,4.0246e+03_r8/)
      kao(:,12,15) = (/ &
     &4.5798e+03_r8,4.5585e+03_r8,4.5503e+03_r8,4.5442e+03_r8,4.5532e+03_r8/)
      kao(:,13,15) = (/ &
     &5.1911e+03_r8,5.1717e+03_r8,5.1553e+03_r8,5.1395e+03_r8,5.1397e+03_r8/)
      kao(:, 1,16) = (/ &
     &1.2071e+03_r8,1.2414e+03_r8,1.3062e+03_r8,1.3645e+03_r8,1.4123e+03_r8/)
      kao(:, 2,16) = (/ &
     &1.4670e+03_r8,1.4886e+03_r8,1.5547e+03_r8,1.6269e+03_r8,1.6875e+03_r8/)
      kao(:, 3,16) = (/ &
     &1.7847e+03_r8,1.7994e+03_r8,1.8394e+03_r8,1.9097e+03_r8,1.9863e+03_r8/)
      kao(:, 4,16) = (/ &
     &2.1409e+03_r8,2.1717e+03_r8,2.1953e+03_r8,2.2438e+03_r8,2.3059e+03_r8/)
      kao(:, 5,16) = (/ &
     &2.5417e+03_r8,2.5918e+03_r8,2.6196e+03_r8,2.6591e+03_r8,2.7124e+03_r8/)
      kao(:, 6,16) = (/ &
     &3.0242e+03_r8,3.0688e+03_r8,3.1113e+03_r8,3.1534e+03_r8,3.2074e+03_r8/)
      kao(:, 7,16) = (/ &
     &3.6491e+03_r8,3.6695e+03_r8,3.6939e+03_r8,3.7229e+03_r8,3.7906e+03_r8/)
      kao(:, 8,16) = (/ &
     &4.4223e+03_r8,4.4232e+03_r8,4.4297e+03_r8,4.4268e+03_r8,4.4608e+03_r8/)
      kao(:, 9,16) = (/ &
     &5.3502e+03_r8,5.3400e+03_r8,5.3338e+03_r8,5.3140e+03_r8,5.2816e+03_r8/)
      kao(:,10,16) = (/ &
     &6.4333e+03_r8,6.4257e+03_r8,6.4093e+03_r8,6.3744e+03_r8,6.3162e+03_r8/)
      kao(:,11,16) = (/ &
     &7.6805e+03_r8,7.6778e+03_r8,7.6466e+03_r8,7.5865e+03_r8,7.5106e+03_r8/)
      kao(:,12,16) = (/ &
     &9.1073e+03_r8,9.0972e+03_r8,9.0428e+03_r8,8.9445e+03_r8,8.8997e+03_r8/)
      kao(:,13,16) = (/ &
     &1.0699e+04_r8,1.0668e+04_r8,1.0580e+04_r8,1.0493e+04_r8,1.0473e+04_r8/)

!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

      kbo(:,13, 1) = (/ &
     &1.0144e-02_r8,1.1539e-02_r8,1.2861e-02_r8,1.4225e-02_r8,1.5224e-02_r8/)
      kbo(:,14, 1) = (/ &
     &8.4327e-03_r8,9.5989e-03_r8,1.0734e-02_r8,1.1890e-02_r8,1.2872e-02_r8/)
      kbo(:,15, 1) = (/ &
     &6.9967e-03_r8,7.9676e-03_r8,8.9559e-03_r8,9.9119e-03_r8,1.0533e-02_r8/)
      kbo(:,16, 1) = (/ &
     &5.7988e-03_r8,6.6068e-03_r8,7.4553e-03_r8,8.2402e-03_r8,8.5310e-03_r8/)
      kbo(:,17, 1) = (/ &
     &4.8055e-03_r8,5.4781e-03_r8,6.1884e-03_r8,6.8148e-03_r8,6.9563e-03_r8/)
      kbo(:,18, 1) = (/ &
     &3.9877e-03_r8,4.5423e-03_r8,5.1325e-03_r8,5.5098e-03_r8,5.6946e-03_r8/)
      kbo(:,19, 1) = (/ &
     &3.3110e-03_r8,3.7880e-03_r8,4.2806e-03_r8,4.4996e-03_r8,4.6784e-03_r8/)
      kbo(:,20, 1) = (/ &
     &2.7631e-03_r8,3.1756e-03_r8,3.5803e-03_r8,3.7100e-03_r8,3.8598e-03_r8/)
      kbo(:,21, 1) = (/ &
     &2.3113e-03_r8,2.6584e-03_r8,2.9347e-03_r8,3.0481e-03_r8,3.1824e-03_r8/)
      kbo(:,22, 1) = (/ &
     &1.9510e-03_r8,2.2389e-03_r8,2.4076e-03_r8,2.5106e-03_r8,2.6293e-03_r8/)
      kbo(:,23, 1) = (/ &
     &1.6490e-03_r8,1.8833e-03_r8,1.9839e-03_r8,2.0707e-03_r8,2.1757e-03_r8/)
      kbo(:,24, 1) = (/ &
     &1.3921e-03_r8,1.5822e-03_r8,1.6416e-03_r8,1.7136e-03_r8,1.8019e-03_r8/)
      kbo(:,25, 1) = (/ &
     &1.1754e-03_r8,1.2986e-03_r8,1.3546e-03_r8,1.4184e-03_r8,1.4951e-03_r8/)
      kbo(:,26, 1) = (/ &
     &9.9384e-04_r8,1.0692e-03_r8,1.1181e-03_r8,1.1767e-03_r8,1.2423e-03_r8/)
      kbo(:,27, 1) = (/ &
     &8.3932e-04_r8,8.8446e-04_r8,9.2496e-04_r8,9.7555e-04_r8,1.0286e-03_r8/)
      kbo(:,28, 1) = (/ &
     &7.0655e-04_r8,7.3418e-04_r8,7.6647e-04_r8,8.0853e-04_r8,8.5091e-04_r8/)
      kbo(:,29, 1) = (/ &
     &5.8016e-04_r8,6.0558e-04_r8,6.3439e-04_r8,6.6940e-04_r8,7.0187e-04_r8/)
      kbo(:,30, 1) = (/ &
     &4.7757e-04_r8,4.9924e-04_r8,5.2442e-04_r8,5.5397e-04_r8,5.7829e-04_r8/)
      kbo(:,31, 1) = (/ &
     &3.9420e-04_r8,4.1123e-04_r8,4.3298e-04_r8,4.5563e-04_r8,4.7437e-04_r8/)
      kbo(:,32, 1) = (/ &
     &3.2571e-04_r8,3.3960e-04_r8,3.5704e-04_r8,3.7387e-04_r8,3.8849e-04_r8/)
      kbo(:,33, 1) = (/ &
     &2.6741e-04_r8,2.8027e-04_r8,2.9349e-04_r8,3.0636e-04_r8,3.1790e-04_r8/)
      kbo(:,34, 1) = (/ &
     &2.2029e-04_r8,2.3073e-04_r8,2.4120e-04_r8,2.5116e-04_r8,2.5977e-04_r8/)
      kbo(:,35, 1) = (/ &
     &1.8092e-04_r8,1.8913e-04_r8,1.9723e-04_r8,2.0490e-04_r8,2.1120e-04_r8/)
      kbo(:,36, 1) = (/ &
     &1.4775e-04_r8,1.5426e-04_r8,1.6038e-04_r8,1.6643e-04_r8,1.7137e-04_r8/)
      kbo(:,37, 1) = (/ &
     &1.2005e-04_r8,1.2534e-04_r8,1.3001e-04_r8,1.3495e-04_r8,1.3888e-04_r8/)
      kbo(:,38, 1) = (/ &
     &9.7560e-05_r8,1.0177e-04_r8,1.0540e-04_r8,1.0924e-04_r8,1.1256e-04_r8/)
      kbo(:,39, 1) = (/ &
     &7.9344e-05_r8,8.2615e-05_r8,8.5368e-05_r8,8.8405e-05_r8,9.1186e-05_r8/)
      kbo(:,40, 1) = (/ &
     &6.4575e-05_r8,6.7008e-05_r8,6.9369e-05_r8,7.1740e-05_r8,7.4003e-05_r8/)
      kbo(:,41, 1) = (/ &
     &5.2697e-05_r8,5.4334e-05_r8,5.6409e-05_r8,5.8228e-05_r8,6.0014e-05_r8/)
      kbo(:,42, 1) = (/ &
     &4.3089e-05_r8,4.4120e-05_r8,4.5815e-05_r8,4.7218e-05_r8,4.8658e-05_r8/)
      kbo(:,43, 1) = (/ &
     &3.4429e-05_r8,3.5847e-05_r8,3.7149e-05_r8,3.8380e-05_r8,3.9479e-05_r8/)
      kbo(:,44, 1) = (/ &
     &2.7169e-05_r8,2.9300e-05_r8,3.0128e-05_r8,3.1175e-05_r8,3.2021e-05_r8/)
      kbo(:,45, 1) = (/ &
     &2.1411e-05_r8,2.3782e-05_r8,2.4360e-05_r8,2.5287e-05_r8,2.6025e-05_r8/)
      kbo(:,46, 1) = (/ &
     &1.6754e-05_r8,1.8795e-05_r8,1.9931e-05_r8,2.0532e-05_r8,2.1145e-05_r8/)
      kbo(:,47, 1) = (/ &
     &1.3067e-05_r8,1.4757e-05_r8,1.6247e-05_r8,1.6575e-05_r8,1.7184e-05_r8/)
      kbo(:,48, 1) = (/ &
     &1.0193e-05_r8,1.1527e-05_r8,1.2841e-05_r8,1.3599e-05_r8,1.3946e-05_r8/)
      kbo(:,49, 1) = (/ &
     &7.9417e-06_r8,8.9971e-06_r8,1.0112e-05_r8,1.1045e-05_r8,1.1285e-05_r8/)
      kbo(:,50, 1) = (/ &
     &6.1950e-06_r8,7.0678e-06_r8,7.9571e-06_r8,8.7859e-06_r8,9.3116e-06_r8/)
      kbo(:,51, 1) = (/ &
     &4.8121e-06_r8,5.5540e-06_r8,6.2634e-06_r8,6.9968e-06_r8,7.5750e-06_r8/)
      kbo(:,52, 1) = (/ &
     &3.7732e-06_r8,4.3400e-06_r8,4.9368e-06_r8,5.5255e-06_r8,6.0507e-06_r8/)
      kbo(:,53, 1) = (/ &
     &2.9588e-06_r8,3.3855e-06_r8,3.8934e-06_r8,4.3558e-06_r8,4.8377e-06_r8/)
      kbo(:,54, 1) = (/ &
     &2.2637e-06_r8,2.6550e-06_r8,3.0640e-06_r8,3.4670e-06_r8,3.8645e-06_r8/)
      kbo(:,55, 1) = (/ &
     &1.7394e-06_r8,2.1318e-06_r8,2.4092e-06_r8,2.7718e-06_r8,3.0969e-06_r8/)
      kbo(:,56, 1) = (/ &
     &1.3379e-06_r8,1.6962e-06_r8,1.9182e-06_r8,2.2019e-06_r8,2.5057e-06_r8/)
      kbo(:,57, 1) = (/ &
     &1.0894e-06_r8,1.3086e-06_r8,1.5250e-06_r8,1.7825e-06_r8,2.0078e-06_r8/)
      kbo(:,58, 1) = (/ &
     &8.2505e-07_r8,1.0180e-06_r8,1.2548e-06_r8,1.4584e-06_r8,1.7398e-06_r8/)
      kbo(:,59, 1) = (/ &
     &7.1802e-07_r8,8.6784e-07_r8,1.0974e-06_r8,1.3504e-06_r8,1.4314e-06_r8/)
      kbo(:,13, 2) = (/ &
     &4.1938e-02_r8,4.3540e-02_r8,4.4990e-02_r8,4.6074e-02_r8,4.6999e-02_r8/)
      kbo(:,14, 2) = (/ &
     &3.5928e-02_r8,3.7447e-02_r8,3.8935e-02_r8,3.9816e-02_r8,4.0666e-02_r8/)
      kbo(:,15, 2) = (/ &
     &3.0539e-02_r8,3.1836e-02_r8,3.3086e-02_r8,3.4096e-02_r8,3.5203e-02_r8/)
      kbo(:,16, 2) = (/ &
     &2.5542e-02_r8,2.6607e-02_r8,2.7654e-02_r8,2.8622e-02_r8,2.9849e-02_r8/)
      kbo(:,17, 2) = (/ &
     &2.1059e-02_r8,2.2159e-02_r8,2.3097e-02_r8,2.3970e-02_r8,2.5021e-02_r8/)
      kbo(:,18, 2) = (/ &
     &1.7420e-02_r8,1.8344e-02_r8,1.9223e-02_r8,2.0092e-02_r8,2.0887e-02_r8/)
      kbo(:,19, 2) = (/ &
     &1.4527e-02_r8,1.5294e-02_r8,1.6071e-02_r8,1.6950e-02_r8,1.7660e-02_r8/)
      kbo(:,20, 2) = (/ &
     &1.2057e-02_r8,1.2740e-02_r8,1.3375e-02_r8,1.4212e-02_r8,1.4836e-02_r8/)
      kbo(:,21, 2) = (/ &
     &1.0024e-02_r8,1.0630e-02_r8,1.1202e-02_r8,1.1918e-02_r8,1.2460e-02_r8/)
      kbo(:,22, 2) = (/ &
     &8.3586e-03_r8,8.8721e-03_r8,9.4319e-03_r8,1.0016e-02_r8,1.0451e-02_r8/)
      kbo(:,23, 2) = (/ &
     &7.0023e-03_r8,7.4292e-03_r8,7.9425e-03_r8,8.4001e-03_r8,8.6668e-03_r8/)
      kbo(:,24, 2) = (/ &
     &5.8805e-03_r8,6.2414e-03_r8,6.6855e-03_r8,7.0380e-03_r8,7.1881e-03_r8/)
      kbo(:,25, 2) = (/ &
     &4.9300e-03_r8,5.2659e-03_r8,5.6130e-03_r8,5.8139e-03_r8,5.9744e-03_r8/)
      kbo(:,26, 2) = (/ &
     &4.1346e-03_r8,4.4268e-03_r8,4.6994e-03_r8,4.8189e-03_r8,4.9700e-03_r8/)
      kbo(:,27, 2) = (/ &
     &3.4478e-03_r8,3.6949e-03_r8,3.8760e-03_r8,3.9800e-03_r8,4.1083e-03_r8/)
      kbo(:,28, 2) = (/ &
     &2.8662e-03_r8,3.0720e-03_r8,3.1855e-03_r8,3.2844e-03_r8,3.3841e-03_r8/)
      kbo(:,29, 2) = (/ &
     &2.3700e-03_r8,2.5289e-03_r8,2.6049e-03_r8,2.6846e-03_r8,2.7555e-03_r8/)
      kbo(:,30, 2) = (/ &
     &1.9529e-03_r8,2.0734e-03_r8,2.1236e-03_r8,2.1766e-03_r8,2.2279e-03_r8/)
      kbo(:,31, 2) = (/ &
     &1.5951e-03_r8,1.6761e-03_r8,1.7103e-03_r8,1.7458e-03_r8,1.7856e-03_r8/)
      kbo(:,32, 2) = (/ &
     &1.2965e-03_r8,1.3546e-03_r8,1.3767e-03_r8,1.4016e-03_r8,1.4345e-03_r8/)
      kbo(:,33, 2) = (/ &
     &1.0497e-03_r8,1.0916e-03_r8,1.1061e-03_r8,1.1259e-03_r8,1.1490e-03_r8/)
      kbo(:,34, 2) = (/ &
     &8.5263e-04_r8,8.8439e-04_r8,8.9299e-04_r8,9.0901e-04_r8,9.2683e-04_r8/)
      kbo(:,35, 2) = (/ &
     &6.8961e-04_r8,7.1452e-04_r8,7.2125e-04_r8,7.3408e-04_r8,7.4718e-04_r8/)
      kbo(:,36, 2) = (/ &
     &5.5538e-04_r8,5.7454e-04_r8,5.8468e-04_r8,5.9295e-04_r8,6.0312e-04_r8/)
      kbo(:,37, 2) = (/ &
     &4.4687e-04_r8,4.6228e-04_r8,4.7485e-04_r8,4.8052e-04_r8,4.8826e-04_r8/)
      kbo(:,38, 2) = (/ &
     &3.5911e-04_r8,3.7176e-04_r8,3.8278e-04_r8,3.8998e-04_r8,3.9487e-04_r8/)
      kbo(:,39, 2) = (/ &
     &2.8825e-04_r8,2.9868e-04_r8,3.0761e-04_r8,3.1500e-04_r8,3.2065e-04_r8/)
      kbo(:,40, 2) = (/ &
     &2.3221e-04_r8,2.4117e-04_r8,2.4916e-04_r8,2.5539e-04_r8,2.6149e-04_r8/)
      kbo(:,41, 2) = (/ &
     &1.8711e-04_r8,1.9520e-04_r8,2.0184e-04_r8,2.0732e-04_r8,2.1208e-04_r8/)
      kbo(:,42, 2) = (/ &
     &1.5044e-04_r8,1.5806e-04_r8,1.6349e-04_r8,1.6813e-04_r8,1.7186e-04_r8/)
      kbo(:,43, 2) = (/ &
     &1.2147e-04_r8,1.2754e-04_r8,1.3202e-04_r8,1.3603e-04_r8,1.3922e-04_r8/)
      kbo(:,44, 2) = (/ &
     &9.7631e-05_r8,1.0254e-04_r8,1.0664e-04_r8,1.1000e-04_r8,1.1278e-04_r8/)
      kbo(:,45, 2) = (/ &
     &7.8551e-05_r8,8.2386e-05_r8,8.6252e-05_r8,8.8821e-05_r8,9.1113e-05_r8/)
      kbo(:,46, 2) = (/ &
     &6.3082e-05_r8,6.6217e-05_r8,6.9264e-05_r8,7.1597e-05_r8,7.3596e-05_r8/)
      kbo(:,47, 2) = (/ &
     &5.0668e-05_r8,5.3148e-05_r8,5.5648e-05_r8,5.8023e-05_r8,5.9460e-05_r8/)
      kbo(:,48, 2) = (/ &
     &4.0723e-05_r8,4.2652e-05_r8,4.4714e-05_r8,4.6562e-05_r8,4.8110e-05_r8/)
      kbo(:,49, 2) = (/ &
     &3.2577e-05_r8,3.4241e-05_r8,3.5845e-05_r8,3.7418e-05_r8,3.8704e-05_r8/)
      kbo(:,50, 2) = (/ &
     &2.6548e-05_r8,2.7645e-05_r8,2.8887e-05_r8,3.0243e-05_r8,3.1285e-05_r8/)
      kbo(:,51, 2) = (/ &
     &2.1632e-05_r8,2.2305e-05_r8,2.3402e-05_r8,2.4420e-05_r8,2.5424e-05_r8/)
      kbo(:,52, 2) = (/ &
     &1.7494e-05_r8,1.8158e-05_r8,1.8946e-05_r8,1.9746e-05_r8,2.0626e-05_r8/)
      kbo(:,53, 2) = (/ &
     &1.4060e-05_r8,1.4924e-05_r8,1.5296e-05_r8,1.6047e-05_r8,1.6661e-05_r8/)
      kbo(:,54, 2) = (/ &
     &1.1502e-05_r8,1.2189e-05_r8,1.2591e-05_r8,1.3072e-05_r8,1.3585e-05_r8/)
      kbo(:,55, 2) = (/ &
     &9.4731e-06_r8,9.9000e-06_r8,1.0499e-05_r8,1.0730e-05_r8,1.1201e-05_r8/)
      kbo(:,56, 2) = (/ &
     &7.7842e-06_r8,8.0609e-06_r8,8.6328e-06_r8,8.9073e-06_r8,9.2258e-06_r8/)
      kbo(:,57, 2) = (/ &
     &6.1271e-06_r8,6.6999e-06_r8,7.0368e-06_r8,7.4466e-06_r8,7.6395e-06_r8/)
      kbo(:,58, 2) = (/ &
     &4.7873e-06_r8,5.5615e-06_r8,5.7470e-06_r8,6.1637e-06_r8,6.3705e-06_r8/)
      kbo(:,59, 2) = (/ &
     &3.8649e-06_r8,4.5966e-06_r8,4.7965e-06_r8,5.1490e-06_r8,5.3880e-06_r8/)
      kbo(:,13, 3) = (/ &
     &1.2497e-01_r8,1.2733e-01_r8,1.2732e-01_r8,1.2710e-01_r8,1.2722e-01_r8/)
      kbo(:,14, 3) = (/ &
     &1.0770e-01_r8,1.1044e-01_r8,1.0994e-01_r8,1.0972e-01_r8,1.0842e-01_r8/)
      kbo(:,15, 3) = (/ &
     &9.2313e-02_r8,9.4782e-02_r8,9.3928e-02_r8,9.2439e-02_r8,9.0946e-02_r8/)
      kbo(:,16, 3) = (/ &
     &7.7737e-02_r8,7.9134e-02_r8,7.7340e-02_r8,7.6811e-02_r8,7.6114e-02_r8/)
      kbo(:,17, 3) = (/ &
     &6.5446e-02_r8,6.4598e-02_r8,6.3955e-02_r8,6.3795e-02_r8,6.3695e-02_r8/)
      kbo(:,18, 3) = (/ &
     &5.3197e-02_r8,5.2989e-02_r8,5.2755e-02_r8,5.2824e-02_r8,5.2780e-02_r8/)
      kbo(:,19, 3) = (/ &
     &4.3741e-02_r8,4.3850e-02_r8,4.3971e-02_r8,4.3934e-02_r8,4.3215e-02_r8/)
      kbo(:,20, 3) = (/ &
     &3.6203e-02_r8,3.6356e-02_r8,3.6481e-02_r8,3.6039e-02_r8,3.5482e-02_r8/)
      kbo(:,21, 3) = (/ &
     &2.9983e-02_r8,3.0109e-02_r8,3.0136e-02_r8,2.9600e-02_r8,2.9205e-02_r8/)
      kbo(:,22, 3) = (/ &
     &2.4798e-02_r8,2.4802e-02_r8,2.4628e-02_r8,2.4239e-02_r8,2.4061e-02_r8/)
      kbo(:,23, 3) = (/ &
     &2.0477e-02_r8,2.0405e-02_r8,2.0149e-02_r8,1.9990e-02_r8,1.9997e-02_r8/)
      kbo(:,24, 3) = (/ &
     &1.6953e-02_r8,1.6782e-02_r8,1.6632e-02_r8,1.6618e-02_r8,1.6673e-02_r8/)
      kbo(:,25, 3) = (/ &
     &1.3995e-02_r8,1.3802e-02_r8,1.3748e-02_r8,1.3853e-02_r8,1.3849e-02_r8/)
      kbo(:,26, 3) = (/ &
     &1.1507e-02_r8,1.1388e-02_r8,1.1372e-02_r8,1.1472e-02_r8,1.1479e-02_r8/)
      kbo(:,27, 3) = (/ &
     &9.4100e-03_r8,9.3552e-03_r8,9.3927e-03_r8,9.4480e-03_r8,9.4683e-03_r8/)
      kbo(:,28, 3) = (/ &
     &7.6709e-03_r8,7.6555e-03_r8,7.7364e-03_r8,7.7513e-03_r8,7.7691e-03_r8/)
      kbo(:,29, 3) = (/ &
     &6.2318e-03_r8,6.2179e-03_r8,6.2783e-03_r8,6.2823e-03_r8,6.2984e-03_r8/)
      kbo(:,30, 3) = (/ &
     &5.0369e-03_r8,5.0223e-03_r8,5.0690e-03_r8,5.0675e-03_r8,5.0877e-03_r8/)
      kbo(:,31, 3) = (/ &
     &4.0270e-03_r8,4.0248e-03_r8,4.0530e-03_r8,4.0550e-03_r8,4.0668e-03_r8/)
      kbo(:,32, 3) = (/ &
     &3.2266e-03_r8,3.2233e-03_r8,3.2444e-03_r8,3.2484e-03_r8,3.2485e-03_r8/)
      kbo(:,33, 3) = (/ &
     &2.5826e-03_r8,2.5793e-03_r8,2.5980e-03_r8,2.5954e-03_r8,2.5860e-03_r8/)
      kbo(:,34, 3) = (/ &
     &2.0751e-03_r8,2.0785e-03_r8,2.0913e-03_r8,2.0819e-03_r8,2.0719e-03_r8/)
      kbo(:,35, 3) = (/ &
     &1.6732e-03_r8,1.6746e-03_r8,1.6840e-03_r8,1.6712e-03_r8,1.6630e-03_r8/)
      kbo(:,36, 3) = (/ &
     &1.3540e-03_r8,1.3534e-03_r8,1.3539e-03_r8,1.3458e-03_r8,1.3380e-03_r8/)
      kbo(:,37, 3) = (/ &
     &1.1025e-03_r8,1.0986e-03_r8,1.0965e-03_r8,1.0906e-03_r8,1.0838e-03_r8/)
      kbo(:,38, 3) = (/ &
     &8.9827e-04_r8,8.9144e-04_r8,8.8894e-04_r8,8.8260e-04_r8,8.7601e-04_r8/)
      kbo(:,39, 3) = (/ &
     &7.3039e-04_r8,7.2351e-04_r8,7.1956e-04_r8,7.1446e-04_r8,7.0735e-04_r8/)
      kbo(:,40, 3) = (/ &
     &6.0257e-04_r8,5.9335e-04_r8,5.8899e-04_r8,5.8497e-04_r8,5.7809e-04_r8/)
      kbo(:,41, 3) = (/ &
     &4.9748e-04_r8,4.8829e-04_r8,4.8330e-04_r8,4.7897e-04_r8,4.7418e-04_r8/)
      kbo(:,42, 3) = (/ &
     &4.0962e-04_r8,4.0192e-04_r8,3.9631e-04_r8,3.9272e-04_r8,3.8922e-04_r8/)
      kbo(:,43, 3) = (/ &
     &3.3511e-04_r8,3.3335e-04_r8,3.2739e-04_r8,3.2309e-04_r8,3.2009e-04_r8/)
      kbo(:,44, 3) = (/ &
     &2.7494e-04_r8,2.7440e-04_r8,2.7166e-04_r8,2.6681e-04_r8,2.6291e-04_r8/)
      kbo(:,45, 3) = (/ &
     &2.2409e-04_r8,2.2465e-04_r8,2.2546e-04_r8,2.2120e-04_r8,2.1688e-04_r8/)
      kbo(:,46, 3) = (/ &
     &1.8344e-04_r8,1.8445e-04_r8,1.8370e-04_r8,1.8435e-04_r8,1.8060e-04_r8/)
      kbo(:,47, 3) = (/ &
     &1.5220e-04_r8,1.5094e-04_r8,1.5093e-04_r8,1.5107e-04_r8,1.5073e-04_r8/)
      kbo(:,48, 3) = (/ &
     &1.2685e-04_r8,1.2406e-04_r8,1.2418e-04_r8,1.2347e-04_r8,1.2407e-04_r8/)
      kbo(:,49, 3) = (/ &
     &1.0283e-04_r8,1.0360e-04_r8,1.0186e-04_r8,1.0181e-04_r8,1.0123e-04_r8/)
      kbo(:,50, 3) = (/ &
     &8.3231e-05_r8,8.5593e-05_r8,8.4616e-05_r8,8.3839e-05_r8,8.3224e-05_r8/)
      kbo(:,51, 3) = (/ &
     &6.6892e-05_r8,7.0153e-05_r8,7.0699e-05_r8,6.9691e-05_r8,6.9167e-05_r8/)
      kbo(:,52, 3) = (/ &
     &5.4090e-05_r8,5.6975e-05_r8,5.8223e-05_r8,5.8345e-05_r8,5.7364e-05_r8/)
      kbo(:,53, 3) = (/ &
     &4.3363e-05_r8,4.5702e-05_r8,4.7865e-05_r8,4.7887e-05_r8,4.7945e-05_r8/)
      kbo(:,54, 3) = (/ &
     &3.4722e-05_r8,3.7579e-05_r8,3.9122e-05_r8,3.9883e-05_r8,3.9754e-05_r8/)
      kbo(:,55, 3) = (/ &
     &2.7984e-05_r8,3.0530e-05_r8,3.1930e-05_r8,3.3227e-05_r8,3.3134e-05_r8/)
      kbo(:,56, 3) = (/ &
     &2.2565e-05_r8,2.4737e-05_r8,2.6495e-05_r8,2.7386e-05_r8,2.7845e-05_r8/)
      kbo(:,57, 3) = (/ &
     &1.8624e-05_r8,1.9996e-05_r8,2.1604e-05_r8,2.2454e-05_r8,2.3200e-05_r8/)
      kbo(:,58, 3) = (/ &
     &1.5567e-05_r8,1.6215e-05_r8,1.7630e-05_r8,1.8795e-05_r8,1.9192e-05_r8/)
      kbo(:,59, 3) = (/ &
     &1.3180e-05_r8,1.3591e-05_r8,1.4748e-05_r8,1.5698e-05_r8,1.6153e-05_r8/)
      kbo(:,13, 4) = (/ &
     &2.3244e-01_r8,2.2666e-01_r8,2.2365e-01_r8,2.1647e-01_r8,2.0828e-01_r8/)
      kbo(:,14, 4) = (/ &
     &1.9358e-01_r8,1.8830e-01_r8,1.8743e-01_r8,1.8019e-01_r8,1.7506e-01_r8/)
      kbo(:,15, 4) = (/ &
     &1.6047e-01_r8,1.5782e-01_r8,1.5488e-01_r8,1.5178e-01_r8,1.4896e-01_r8/)
      kbo(:,16, 4) = (/ &
     &1.3221e-01_r8,1.3030e-01_r8,1.2930e-01_r8,1.2731e-01_r8,1.2502e-01_r8/)
      kbo(:,17, 4) = (/ &
     &1.0863e-01_r8,1.0862e-01_r8,1.0815e-01_r8,1.0706e-01_r8,1.0464e-01_r8/)
      kbo(:,18, 4) = (/ &
     &9.0031e-02_r8,9.0210e-02_r8,9.0179e-02_r8,8.8891e-02_r8,8.7072e-02_r8/)
      kbo(:,19, 4) = (/ &
     &7.4933e-02_r8,7.5517e-02_r8,7.5432e-02_r8,7.4716e-02_r8,7.4259e-02_r8/)
      kbo(:,20, 4) = (/ &
     &6.2292e-02_r8,6.2900e-02_r8,6.2796e-02_r8,6.2799e-02_r8,6.2655e-02_r8/)
      kbo(:,21, 4) = (/ &
     &5.1753e-02_r8,5.2259e-02_r8,5.2338e-02_r8,5.2648e-02_r8,5.2692e-02_r8/)
      kbo(:,22, 4) = (/ &
     &4.2879e-02_r8,4.3337e-02_r8,4.3671e-02_r8,4.3911e-02_r8,4.3964e-02_r8/)
      kbo(:,23, 4) = (/ &
     &3.5511e-02_r8,3.5957e-02_r8,3.6400e-02_r8,3.6560e-02_r8,3.6588e-02_r8/)
      kbo(:,24, 4) = (/ &
     &2.9490e-02_r8,3.0002e-02_r8,3.0363e-02_r8,3.0503e-02_r8,3.0607e-02_r8/)
      kbo(:,25, 4) = (/ &
     &2.4491e-02_r8,2.5028e-02_r8,2.5370e-02_r8,2.5485e-02_r8,2.5616e-02_r8/)
      kbo(:,26, 4) = (/ &
     &2.0405e-02_r8,2.0858e-02_r8,2.1166e-02_r8,2.1267e-02_r8,2.1358e-02_r8/)
      kbo(:,27, 4) = (/ &
     &1.6966e-02_r8,1.7305e-02_r8,1.7522e-02_r8,1.7603e-02_r8,1.7664e-02_r8/)
      kbo(:,28, 4) = (/ &
     &1.4041e-02_r8,1.4283e-02_r8,1.4398e-02_r8,1.4482e-02_r8,1.4540e-02_r8/)
      kbo(:,29, 4) = (/ &
     &1.1473e-02_r8,1.1643e-02_r8,1.1712e-02_r8,1.1784e-02_r8,1.1808e-02_r8/)
      kbo(:,30, 4) = (/ &
     &9.3128e-03_r8,9.4393e-03_r8,9.4816e-03_r8,9.5274e-03_r8,9.5277e-03_r8/)
      kbo(:,31, 4) = (/ &
     &7.5018e-03_r8,7.5697e-03_r8,7.5938e-03_r8,7.6234e-03_r8,7.6068e-03_r8/)
      kbo(:,32, 4) = (/ &
     &6.0276e-03_r8,6.0587e-03_r8,6.0760e-03_r8,6.0793e-03_r8,6.0890e-03_r8/)
      kbo(:,33, 4) = (/ &
     &4.8317e-03_r8,4.8465e-03_r8,4.8480e-03_r8,4.8590e-03_r8,4.8679e-03_r8/)
      kbo(:,34, 4) = (/ &
     &3.8930e-03_r8,3.8936e-03_r8,3.8908e-03_r8,3.9081e-03_r8,3.9148e-03_r8/)
      kbo(:,35, 4) = (/ &
     &3.1327e-03_r8,3.1329e-03_r8,3.1313e-03_r8,3.1437e-03_r8,3.1485e-03_r8/)
      kbo(:,36, 4) = (/ &
     &2.5288e-03_r8,2.5255e-03_r8,2.5228e-03_r8,2.5303e-03_r8,2.5349e-03_r8/)
      kbo(:,37, 4) = (/ &
     &2.0481e-03_r8,2.0483e-03_r8,2.0398e-03_r8,2.0467e-03_r8,2.0499e-03_r8/)
      kbo(:,38, 4) = (/ &
     &1.6558e-03_r8,1.6596e-03_r8,1.6492e-03_r8,1.6534e-03_r8,1.6569e-03_r8/)
      kbo(:,39, 4) = (/ &
     &1.3374e-03_r8,1.3400e-03_r8,1.3351e-03_r8,1.3347e-03_r8,1.3383e-03_r8/)
      kbo(:,40, 4) = (/ &
     &1.0845e-03_r8,1.0921e-03_r8,1.0887e-03_r8,1.0875e-03_r8,1.0897e-03_r8/)
      kbo(:,41, 4) = (/ &
     &8.8154e-04_r8,8.8864e-04_r8,8.8779e-04_r8,8.8674e-04_r8,8.8749e-04_r8/)
      kbo(:,42, 4) = (/ &
     &7.1843e-04_r8,7.2263e-04_r8,7.2341e-04_r8,7.2250e-04_r8,7.2207e-04_r8/)
      kbo(:,43, 4) = (/ &
     &5.8799e-04_r8,5.8635e-04_r8,5.8966e-04_r8,5.8857e-04_r8,5.8778e-04_r8/)
      kbo(:,44, 4) = (/ &
     &4.7968e-04_r8,4.7905e-04_r8,4.7843e-04_r8,4.7895e-04_r8,4.7900e-04_r8/)
      kbo(:,45, 4) = (/ &
     &3.9220e-04_r8,3.9274e-04_r8,3.8844e-04_r8,3.8841e-04_r8,3.8937e-04_r8/)
      kbo(:,46, 4) = (/ &
     &3.2002e-04_r8,3.2007e-04_r8,3.1928e-04_r8,3.1499e-04_r8,3.1489e-04_r8/)
      kbo(:,47, 4) = (/ &
     &2.6159e-04_r8,2.6272e-04_r8,2.6214e-04_r8,2.5941e-04_r8,2.5552e-04_r8/)
      kbo(:,48, 4) = (/ &
     &2.1397e-04_r8,2.1500e-04_r8,2.1426e-04_r8,2.1370e-04_r8,2.0956e-04_r8/)
      kbo(:,49, 4) = (/ &
     &1.7795e-04_r8,1.7554e-04_r8,1.7551e-04_r8,1.7452e-04_r8,1.7328e-04_r8/)
      kbo(:,50, 4) = (/ &
     &1.4762e-04_r8,1.4610e-04_r8,1.4428e-04_r8,1.4351e-04_r8,1.4273e-04_r8/)
      kbo(:,51, 4) = (/ &
     &1.2354e-04_r8,1.2144e-04_r8,1.1938e-04_r8,1.1805e-04_r8,1.1688e-04_r8/)
      kbo(:,52, 4) = (/ &
     &1.0353e-04_r8,1.0111e-04_r8,9.9958e-05_r8,9.7469e-05_r8,9.6574e-05_r8/)
      kbo(:,53, 4) = (/ &
     &8.8311e-05_r8,8.4522e-05_r8,8.3164e-05_r8,8.1847e-05_r8,7.9623e-05_r8/)
      kbo(:,54, 4) = (/ &
     &7.5002e-05_r8,7.1277e-05_r8,6.9429e-05_r8,6.8546e-05_r8,6.7044e-05_r8/)
      kbo(:,55, 4) = (/ &
     &6.4688e-05_r8,6.1558e-05_r8,5.8597e-05_r8,5.7310e-05_r8,5.6741e-05_r8/)
      kbo(:,56, 4) = (/ &
     &5.4545e-05_r8,5.2835e-05_r8,4.9722e-05_r8,4.8222e-05_r8,4.7437e-05_r8/)
      kbo(:,57, 4) = (/ &
     &4.5567e-05_r8,4.5770e-05_r8,4.3541e-05_r8,4.1141e-05_r8,3.9867e-05_r8/)
      kbo(:,58, 4) = (/ &
     &3.8423e-05_r8,3.8314e-05_r8,3.7767e-05_r8,3.5438e-05_r8,3.3984e-05_r8/)
      kbo(:,59, 4) = (/ &
     &3.2695e-05_r8,3.2545e-05_r8,3.2199e-05_r8,3.0741e-05_r8,2.9151e-05_r8/)
      kbo(:,13, 5) = (/ &
     &3.6693e-01_r8,3.6670e-01_r8,3.6374e-01_r8,3.6513e-01_r8,3.6694e-01_r8/)
      kbo(:,14, 5) = (/ &
     &3.1193e-01_r8,3.1009e-01_r8,3.0785e-01_r8,3.1108e-01_r8,3.1338e-01_r8/)
      kbo(:,15, 5) = (/ &
     &2.6635e-01_r8,2.6398e-01_r8,2.6603e-01_r8,2.6792e-01_r8,2.6974e-01_r8/)
      kbo(:,16, 5) = (/ &
     &2.2560e-01_r8,2.2536e-01_r8,2.2722e-01_r8,2.2790e-01_r8,2.2934e-01_r8/)
      kbo(:,17, 5) = (/ &
     &1.9102e-01_r8,1.9205e-01_r8,1.9235e-01_r8,1.9256e-01_r8,1.9454e-01_r8/)
      kbo(:,18, 5) = (/ &
     &1.6220e-01_r8,1.6268e-01_r8,1.6247e-01_r8,1.6354e-01_r8,1.6555e-01_r8/)
      kbo(:,19, 5) = (/ &
     &1.3796e-01_r8,1.3803e-01_r8,1.3823e-01_r8,1.3977e-01_r8,1.4117e-01_r8/)
      kbo(:,20, 5) = (/ &
     &1.1636e-01_r8,1.1631e-01_r8,1.1719e-01_r8,1.1821e-01_r8,1.1915e-01_r8/)
      kbo(:,21, 5) = (/ &
     &9.7502e-02_r8,9.7703e-02_r8,9.8615e-02_r8,9.9561e-02_r8,1.0025e-01_r8/)
      kbo(:,22, 5) = (/ &
     &8.1562e-02_r8,8.1981e-02_r8,8.2659e-02_r8,8.3450e-02_r8,8.3918e-02_r8/)
      kbo(:,23, 5) = (/ &
     &6.8080e-02_r8,6.8683e-02_r8,6.9366e-02_r8,6.9894e-02_r8,7.0282e-02_r8/)
      kbo(:,24, 5) = (/ &
     &5.7119e-02_r8,5.7682e-02_r8,5.8192e-02_r8,5.8547e-02_r8,5.9029e-02_r8/)
      kbo(:,25, 5) = (/ &
     &4.7811e-02_r8,4.8293e-02_r8,4.8606e-02_r8,4.8996e-02_r8,4.9473e-02_r8/)
      kbo(:,26, 5) = (/ &
     &3.9890e-02_r8,4.0316e-02_r8,4.0576e-02_r8,4.1016e-02_r8,4.1455e-02_r8/)
      kbo(:,27, 5) = (/ &
     &3.3117e-02_r8,3.3470e-02_r8,3.3770e-02_r8,3.4189e-02_r8,3.4527e-02_r8/)
      kbo(:,28, 5) = (/ &
     &2.7406e-02_r8,2.7694e-02_r8,2.7971e-02_r8,2.8332e-02_r8,2.8599e-02_r8/)
      kbo(:,29, 5) = (/ &
     &2.2401e-02_r8,2.2630e-02_r8,2.2890e-02_r8,2.3150e-02_r8,2.3396e-02_r8/)
      kbo(:,30, 5) = (/ &
     &1.8227e-02_r8,1.8399e-02_r8,1.8623e-02_r8,1.8850e-02_r8,1.9028e-02_r8/)
      kbo(:,31, 5) = (/ &
     &1.4683e-02_r8,1.4830e-02_r8,1.5011e-02_r8,1.5187e-02_r8,1.5326e-02_r8/)
      kbo(:,32, 5) = (/ &
     &1.1826e-02_r8,1.1971e-02_r8,1.2101e-02_r8,1.2245e-02_r8,1.2313e-02_r8/)
      kbo(:,33, 5) = (/ &
     &9.5307e-03_r8,9.6419e-03_r8,9.7421e-03_r8,9.8284e-03_r8,9.8826e-03_r8/)
      kbo(:,34, 5) = (/ &
     &7.7176e-03_r8,7.8031e-03_r8,7.8838e-03_r8,7.9405e-03_r8,7.9679e-03_r8/)
      kbo(:,35, 5) = (/ &
     &6.2512e-03_r8,6.3124e-03_r8,6.3712e-03_r8,6.4126e-03_r8,6.4324e-03_r8/)
      kbo(:,36, 5) = (/ &
     &5.0560e-03_r8,5.1076e-03_r8,5.1576e-03_r8,5.1918e-03_r8,5.2018e-03_r8/)
      kbo(:,37, 5) = (/ &
     &4.0965e-03_r8,4.1427e-03_r8,4.1869e-03_r8,4.2164e-03_r8,4.2222e-03_r8/)
      kbo(:,38, 5) = (/ &
     &3.3169e-03_r8,3.3541e-03_r8,3.3940e-03_r8,3.4174e-03_r8,3.4236e-03_r8/)
      kbo(:,39, 5) = (/ &
     &2.6806e-03_r8,2.7157e-03_r8,2.7440e-03_r8,2.7658e-03_r8,2.7739e-03_r8/)
      kbo(:,40, 5) = (/ &
     &2.1766e-03_r8,2.2105e-03_r8,2.2356e-03_r8,2.2533e-03_r8,2.2654e-03_r8/)
      kbo(:,41, 5) = (/ &
     &1.7690e-03_r8,1.7997e-03_r8,1.8217e-03_r8,1.8373e-03_r8,1.8492e-03_r8/)
      kbo(:,42, 5) = (/ &
     &1.4370e-03_r8,1.4625e-03_r8,1.4833e-03_r8,1.4970e-03_r8,1.5072e-03_r8/)
      kbo(:,43, 5) = (/ &
     &1.1671e-03_r8,1.1863e-03_r8,1.2051e-03_r8,1.2193e-03_r8,1.2276e-03_r8/)
      kbo(:,44, 5) = (/ &
     &9.4820e-04_r8,9.6187e-04_r8,9.7830e-04_r8,9.9143e-04_r8,9.9963e-04_r8/)
      kbo(:,45, 5) = (/ &
     &7.6916e-04_r8,7.7831e-04_r8,7.9153e-04_r8,8.0495e-04_r8,8.1281e-04_r8/)
      kbo(:,46, 5) = (/ &
     &6.2348e-04_r8,6.3114e-04_r8,6.4009e-04_r8,6.5199e-04_r8,6.6002e-04_r8/)
      kbo(:,47, 5) = (/ &
     &5.0390e-04_r8,5.1138e-04_r8,5.1807e-04_r8,5.2655e-04_r8,5.3606e-04_r8/)
      kbo(:,48, 5) = (/ &
     &4.0606e-04_r8,4.1379e-04_r8,4.1952e-04_r8,4.2537e-04_r8,4.3314e-04_r8/)
      kbo(:,49, 5) = (/ &
     &3.2659e-04_r8,3.3285e-04_r8,3.3902e-04_r8,3.4315e-04_r8,3.4880e-04_r8/)
      kbo(:,50, 5) = (/ &
     &2.6466e-04_r8,2.6781e-04_r8,2.7393e-04_r8,2.7826e-04_r8,2.8216e-04_r8/)
      kbo(:,51, 5) = (/ &
     &2.1507e-04_r8,2.1721e-04_r8,2.2109e-04_r8,2.2570e-04_r8,2.2911e-04_r8/)
      kbo(:,52, 5) = (/ &
     &1.7470e-04_r8,1.7639e-04_r8,1.7813e-04_r8,1.8197e-04_r8,1.8512e-04_r8/)
      kbo(:,53, 5) = (/ &
     &1.4115e-04_r8,1.4348e-04_r8,1.4425e-04_r8,1.4633e-04_r8,1.4939e-04_r8/)
      kbo(:,54, 5) = (/ &
     &1.1575e-04_r8,1.1704e-04_r8,1.1812e-04_r8,1.1890e-04_r8,1.2106e-04_r8/)
      kbo(:,55, 5) = (/ &
     &9.4726e-05_r8,9.5455e-05_r8,9.6825e-05_r8,9.7465e-05_r8,9.8412e-05_r8/)
      kbo(:,56, 5) = (/ &
     &7.9719e-05_r8,7.8475e-05_r8,7.9571e-05_r8,8.0057e-05_r8,8.0565e-05_r8/)
      kbo(:,57, 5) = (/ &
     &6.7373e-05_r8,6.4174e-05_r8,6.4600e-05_r8,6.5492e-05_r8,6.6130e-05_r8/)
      kbo(:,58, 5) = (/ &
     &5.8248e-05_r8,5.4990e-05_r8,5.3012e-05_r8,5.3610e-05_r8,5.4283e-05_r8/)
      kbo(:,59, 5) = (/ &
     &5.0210e-05_r8,4.6885e-05_r8,4.4678e-05_r8,4.4690e-05_r8,4.5330e-05_r8/)
      kbo(:,13, 6) = (/ &
     &8.1815e-01_r8,8.2185e-01_r8,8.2056e-01_r8,8.1693e-01_r8,8.1119e-01_r8/)
      kbo(:,14, 6) = (/ &
     &6.9938e-01_r8,7.0403e-01_r8,7.0310e-01_r8,6.9893e-01_r8,6.9382e-01_r8/)
      kbo(:,15, 6) = (/ &
     &6.0306e-01_r8,6.0562e-01_r8,6.0433e-01_r8,6.0124e-01_r8,5.9539e-01_r8/)
      kbo(:,16, 6) = (/ &
     &5.1717e-01_r8,5.1741e-01_r8,5.1602e-01_r8,5.1303e-01_r8,5.0799e-01_r8/)
      kbo(:,17, 6) = (/ &
     &4.3954e-01_r8,4.3996e-01_r8,4.3917e-01_r8,4.3585e-01_r8,4.3144e-01_r8/)
      kbo(:,18, 6) = (/ &
     &3.7098e-01_r8,3.7164e-01_r8,3.7046e-01_r8,3.6778e-01_r8,3.6412e-01_r8/)
      kbo(:,19, 6) = (/ &
     &3.1410e-01_r8,3.1452e-01_r8,3.1318e-01_r8,3.1054e-01_r8,3.0829e-01_r8/)
      kbo(:,20, 6) = (/ &
     &2.6425e-01_r8,2.6434e-01_r8,2.6287e-01_r8,2.6129e-01_r8,2.6054e-01_r8/)
      kbo(:,21, 6) = (/ &
     &2.2166e-01_r8,2.2161e-01_r8,2.2078e-01_r8,2.2017e-01_r8,2.1929e-01_r8/)
      kbo(:,22, 6) = (/ &
     &1.8499e-01_r8,1.8512e-01_r8,1.8480e-01_r8,1.8474e-01_r8,1.8395e-01_r8/)
      kbo(:,23, 6) = (/ &
     &1.5462e-01_r8,1.5460e-01_r8,1.5448e-01_r8,1.5440e-01_r8,1.5366e-01_r8/)
      kbo(:,24, 6) = (/ &
     &1.2929e-01_r8,1.2940e-01_r8,1.2953e-01_r8,1.2932e-01_r8,1.2872e-01_r8/)
      kbo(:,25, 6) = (/ &
     &1.0802e-01_r8,1.0819e-01_r8,1.0834e-01_r8,1.0817e-01_r8,1.0761e-01_r8/)
      kbo(:,26, 6) = (/ &
     &9.0060e-02_r8,9.0350e-02_r8,9.0334e-02_r8,9.0150e-02_r8,8.9781e-02_r8/)
      kbo(:,27, 6) = (/ &
     &7.4680e-02_r8,7.4863e-02_r8,7.4908e-02_r8,7.4831e-02_r8,7.4608e-02_r8/)
      kbo(:,28, 6) = (/ &
     &6.1687e-02_r8,6.1865e-02_r8,6.1970e-02_r8,6.1917e-02_r8,6.1874e-02_r8/)
      kbo(:,29, 6) = (/ &
     &5.0513e-02_r8,5.0701e-02_r8,5.0801e-02_r8,5.0773e-02_r8,5.0734e-02_r8/)
      kbo(:,30, 6) = (/ &
     &4.1201e-02_r8,4.1379e-02_r8,4.1449e-02_r8,4.1422e-02_r8,4.1408e-02_r8/)
      kbo(:,31, 6) = (/ &
     &3.3339e-02_r8,3.3480e-02_r8,3.3517e-02_r8,3.3503e-02_r8,3.3496e-02_r8/)
      kbo(:,32, 6) = (/ &
     &2.6941e-02_r8,2.7025e-02_r8,2.7045e-02_r8,2.7032e-02_r8,2.7041e-02_r8/)
      kbo(:,33, 6) = (/ &
     &2.1746e-02_r8,2.1784e-02_r8,2.1791e-02_r8,2.1788e-02_r8,2.1780e-02_r8/)
      kbo(:,34, 6) = (/ &
     &1.7618e-02_r8,1.7652e-02_r8,1.7653e-02_r8,1.7651e-02_r8,1.7645e-02_r8/)
      kbo(:,35, 6) = (/ &
     &1.4278e-02_r8,1.4314e-02_r8,1.4305e-02_r8,1.4306e-02_r8,1.4294e-02_r8/)
      kbo(:,36, 6) = (/ &
     &1.1580e-02_r8,1.1612e-02_r8,1.1606e-02_r8,1.1608e-02_r8,1.1605e-02_r8/)
      kbo(:,37, 6) = (/ &
     &9.4219e-03_r8,9.4537e-03_r8,9.4624e-03_r8,9.4565e-03_r8,9.4577e-03_r8/)
      kbo(:,38, 6) = (/ &
     &7.6536e-03_r8,7.6870e-03_r8,7.7033e-03_r8,7.6954e-03_r8,7.6994e-03_r8/)
      kbo(:,39, 6) = (/ &
     &6.2054e-03_r8,6.2357e-03_r8,6.2573e-03_r8,6.2573e-03_r8,6.2600e-03_r8/)
      kbo(:,40, 6) = (/ &
     &5.0787e-03_r8,5.1000e-03_r8,5.1231e-03_r8,5.1304e-03_r8,5.1270e-03_r8/)
      kbo(:,41, 6) = (/ &
     &4.1553e-03_r8,4.1734e-03_r8,4.1950e-03_r8,4.2100e-03_r8,4.2073e-03_r8/)
      kbo(:,42, 6) = (/ &
     &3.3951e-03_r8,3.4115e-03_r8,3.4321e-03_r8,3.4456e-03_r8,3.4459e-03_r8/)
      kbo(:,43, 6) = (/ &
     &2.7739e-03_r8,2.7892e-03_r8,2.8063e-03_r8,2.8198e-03_r8,2.8248e-03_r8/)
      kbo(:,44, 6) = (/ &
     &2.2638e-03_r8,2.2784e-03_r8,2.2918e-03_r8,2.3046e-03_r8,2.3113e-03_r8/)
      kbo(:,45, 6) = (/ &
     &1.8451e-03_r8,1.8580e-03_r8,1.8678e-03_r8,1.8806e-03_r8,1.8860e-03_r8/)
      kbo(:,46, 6) = (/ &
     &1.5013e-03_r8,1.5134e-03_r8,1.5237e-03_r8,1.5316e-03_r8,1.5391e-03_r8/)
      kbo(:,47, 6) = (/ &
     &1.2205e-03_r8,1.2340e-03_r8,1.2429e-03_r8,1.2503e-03_r8,1.2568e-03_r8/)
      kbo(:,48, 6) = (/ &
     &9.8959e-04_r8,1.0036e-03_r8,1.0115e-03_r8,1.0182e-03_r8,1.0235e-03_r8/)
      kbo(:,49, 6) = (/ &
     &8.0128e-04_r8,8.1327e-04_r8,8.2211e-04_r8,8.2807e-04_r8,8.3181e-04_r8/)
      kbo(:,50, 6) = (/ &
     &6.5077e-04_r8,6.6049e-04_r8,6.6942e-04_r8,6.7493e-04_r8,6.7909e-04_r8/)
      kbo(:,51, 6) = (/ &
     &5.2860e-04_r8,5.3765e-04_r8,5.4562e-04_r8,5.5099e-04_r8,5.5519e-04_r8/)
      kbo(:,52, 6) = (/ &
     &4.2741e-04_r8,4.3678e-04_r8,4.4379e-04_r8,4.4944e-04_r8,4.5321e-04_r8/)
      kbo(:,53, 6) = (/ &
     &3.4420e-04_r8,3.5368e-04_r8,3.5979e-04_r8,3.6513e-04_r8,3.6858e-04_r8/)
      kbo(:,54, 6) = (/ &
     &2.7911e-04_r8,2.8752e-04_r8,2.9393e-04_r8,2.9865e-04_r8,3.0238e-04_r8/)
      kbo(:,55, 6) = (/ &
     &2.2659e-04_r8,2.3415e-04_r8,2.4084e-04_r8,2.4534e-04_r8,2.4896e-04_r8/)
      kbo(:,56, 6) = (/ &
     &1.8317e-04_r8,1.9078e-04_r8,1.9656e-04_r8,2.0135e-04_r8,2.0466e-04_r8/)
      kbo(:,57, 6) = (/ &
     &1.4828e-04_r8,1.5527e-04_r8,1.6035e-04_r8,1.6503e-04_r8,1.6825e-04_r8/)
      kbo(:,58, 6) = (/ &
     &1.1818e-04_r8,1.2542e-04_r8,1.3082e-04_r8,1.3476e-04_r8,1.3831e-04_r8/)
      kbo(:,59, 6) = (/ &
     &9.6673e-05_r8,1.0368e-04_r8,1.0861e-04_r8,1.1211e-04_r8,1.1553e-04_r8/)
      kbo(:,13, 7) = (/ &
     &2.1727e+00_r8,2.1507e+00_r8,2.1220e+00_r8,2.0892e+00_r8,2.0541e+00_r8/)
      kbo(:,14, 7) = (/ &
     &1.7980e+00_r8,1.7753e+00_r8,1.7493e+00_r8,1.7241e+00_r8,1.6941e+00_r8/)
      kbo(:,15, 7) = (/ &
     &1.5327e+00_r8,1.5148e+00_r8,1.4951e+00_r8,1.4705e+00_r8,1.4480e+00_r8/)
      kbo(:,16, 7) = (/ &
     &1.3007e+00_r8,1.2909e+00_r8,1.2720e+00_r8,1.2527e+00_r8,1.2359e+00_r8/)
      kbo(:,17, 7) = (/ &
     &1.1117e+00_r8,1.1002e+00_r8,1.0859e+00_r8,1.0728e+00_r8,1.0608e+00_r8/)
      kbo(:,18, 7) = (/ &
     &9.4895e-01_r8,9.3669e-01_r8,9.2658e-01_r8,9.1630e-01_r8,9.0461e-01_r8/)
      kbo(:,19, 7) = (/ &
     &8.0771e-01_r8,7.9960e-01_r8,7.9052e-01_r8,7.8134e-01_r8,7.7103e-01_r8/)
      kbo(:,20, 7) = (/ &
     &6.8397e-01_r8,6.7733e-01_r8,6.6931e-01_r8,6.6104e-01_r8,6.5276e-01_r8/)
      kbo(:,21, 7) = (/ &
     &5.7680e-01_r8,5.7078e-01_r8,5.6416e-01_r8,5.5706e-01_r8,5.4996e-01_r8/)
      kbo(:,22, 7) = (/ &
     &4.8402e-01_r8,4.7901e-01_r8,4.7292e-01_r8,4.6701e-01_r8,4.6224e-01_r8/)
      kbo(:,23, 7) = (/ &
     &4.0435e-01_r8,4.0004e-01_r8,3.9588e-01_r8,3.9219e-01_r8,3.8835e-01_r8/)
      kbo(:,24, 7) = (/ &
     &3.3766e-01_r8,3.3478e-01_r8,3.3178e-01_r8,3.2887e-01_r8,3.2604e-01_r8/)
      kbo(:,25, 7) = (/ &
     &2.8141e-01_r8,2.7941e-01_r8,2.7716e-01_r8,2.7469e-01_r8,2.7266e-01_r8/)
      kbo(:,26, 7) = (/ &
     &2.3429e-01_r8,2.3260e-01_r8,2.3087e-01_r8,2.2897e-01_r8,2.2751e-01_r8/)
      kbo(:,27, 7) = (/ &
     &1.9420e-01_r8,1.9275e-01_r8,1.9122e-01_r8,1.8991e-01_r8,1.8923e-01_r8/)
      kbo(:,28, 7) = (/ &
     &1.6015e-01_r8,1.5905e-01_r8,1.5800e-01_r8,1.5718e-01_r8,1.5696e-01_r8/)
      kbo(:,29, 7) = (/ &
     &1.3094e-01_r8,1.3014e-01_r8,1.2944e-01_r8,1.2906e-01_r8,1.2899e-01_r8/)
      kbo(:,30, 7) = (/ &
     &1.0666e-01_r8,1.0604e-01_r8,1.0563e-01_r8,1.0549e-01_r8,1.0548e-01_r8/)
      kbo(:,31, 7) = (/ &
     &8.6275e-02_r8,8.5845e-02_r8,8.5617e-02_r8,8.5505e-02_r8,8.5535e-02_r8/)
      kbo(:,32, 7) = (/ &
     &6.9798e-02_r8,6.9528e-02_r8,6.9393e-02_r8,6.9336e-02_r8,6.9374e-02_r8/)
      kbo(:,33, 7) = (/ &
     &5.6418e-02_r8,5.6253e-02_r8,5.6185e-02_r8,5.6126e-02_r8,5.6165e-02_r8/)
      kbo(:,34, 7) = (/ &
     &4.5866e-02_r8,4.5727e-02_r8,4.5682e-02_r8,4.5616e-02_r8,4.5707e-02_r8/)
      kbo(:,35, 7) = (/ &
     &3.7274e-02_r8,3.7180e-02_r8,3.7143e-02_r8,3.7120e-02_r8,3.7200e-02_r8/)
      kbo(:,36, 7) = (/ &
     &3.0350e-02_r8,3.0274e-02_r8,3.0257e-02_r8,3.0235e-02_r8,3.0299e-02_r8/)
      kbo(:,37, 7) = (/ &
     &2.4821e-02_r8,2.4753e-02_r8,2.4742e-02_r8,2.4741e-02_r8,2.4790e-02_r8/)
      kbo(:,38, 7) = (/ &
     &2.0268e-02_r8,2.0223e-02_r8,2.0196e-02_r8,2.0200e-02_r8,2.0236e-02_r8/)
      kbo(:,39, 7) = (/ &
     &1.6521e-02_r8,1.6487e-02_r8,1.6459e-02_r8,1.6462e-02_r8,1.6499e-02_r8/)
      kbo(:,40, 7) = (/ &
     &1.3551e-02_r8,1.3542e-02_r8,1.3531e-02_r8,1.3538e-02_r8,1.3571e-02_r8/)
      kbo(:,41, 7) = (/ &
     &1.1139e-02_r8,1.1135e-02_r8,1.1130e-02_r8,1.1141e-02_r8,1.1171e-02_r8/)
      kbo(:,42, 7) = (/ &
     &9.1492e-03_r8,9.1515e-03_r8,9.1518e-03_r8,9.1649e-03_r8,9.1900e-03_r8/)
      kbo(:,43, 7) = (/ &
     &7.5083e-03_r8,7.5191e-03_r8,7.5258e-03_r8,7.5334e-03_r8,7.5552e-03_r8/)
      kbo(:,44, 7) = (/ &
     &6.1594e-03_r8,6.1707e-03_r8,6.1785e-03_r8,6.1865e-03_r8,6.2090e-03_r8/)
      kbo(:,45, 7) = (/ &
     &5.0436e-03_r8,5.0526e-03_r8,5.0656e-03_r8,5.0711e-03_r8,5.0867e-03_r8/)
      kbo(:,46, 7) = (/ &
     &4.1291e-03_r8,4.1408e-03_r8,4.1483e-03_r8,4.1539e-03_r8,4.1670e-03_r8/)
      kbo(:,47, 7) = (/ &
     &3.3808e-03_r8,3.3903e-03_r8,3.4014e-03_r8,3.4059e-03_r8,3.4179e-03_r8/)
      kbo(:,48, 7) = (/ &
     &2.7630e-03_r8,2.7730e-03_r8,2.7794e-03_r8,2.7876e-03_r8,2.7961e-03_r8/)
      kbo(:,49, 7) = (/ &
     &2.2529e-03_r8,2.2614e-03_r8,2.2681e-03_r8,2.2743e-03_r8,2.2825e-03_r8/)
      kbo(:,50, 7) = (/ &
     &1.8409e-03_r8,1.8507e-03_r8,1.8571e-03_r8,1.8629e-03_r8,1.8694e-03_r8/)
      kbo(:,51, 7) = (/ &
     &1.5059e-03_r8,1.5160e-03_r8,1.5224e-03_r8,1.5287e-03_r8,1.5343e-03_r8/)
      kbo(:,52, 7) = (/ &
     &1.2303e-03_r8,1.2392e-03_r8,1.2461e-03_r8,1.2522e-03_r8,1.2570e-03_r8/)
      kbo(:,53, 7) = (/ &
     &1.0020e-03_r8,1.0115e-03_r8,1.0178e-03_r8,1.0227e-03_r8,1.0281e-03_r8/)
      kbo(:,54, 7) = (/ &
     &8.2130e-04_r8,8.3060e-04_r8,8.3778e-04_r8,8.4304e-04_r8,8.4741e-04_r8/)
      kbo(:,55, 7) = (/ &
     &6.7498e-04_r8,6.8670e-04_r8,6.9292e-04_r8,6.9895e-04_r8,7.0313e-04_r8/)
      kbo(:,56, 7) = (/ &
     &5.5427e-04_r8,5.6524e-04_r8,5.7318e-04_r8,5.7892e-04_r8,5.8355e-04_r8/)
      kbo(:,57, 7) = (/ &
     &4.5437e-04_r8,4.6585e-04_r8,4.7333e-04_r8,4.7899e-04_r8,4.8346e-04_r8/)
      kbo(:,58, 7) = (/ &
     &3.7314e-04_r8,3.8385e-04_r8,3.9164e-04_r8,3.9732e-04_r8,4.0183e-04_r8/)
      kbo(:,59, 7) = (/ &
     &3.1164e-04_r8,3.2163e-04_r8,3.2929e-04_r8,3.3498e-04_r8,3.3967e-04_r8/)
      kbo(:,13, 8) = (/ &
     &7.1017e+00_r8,7.0462e+00_r8,6.9629e+00_r8,6.8569e+00_r8,6.7518e+00_r8/)
      kbo(:,14, 8) = (/ &
     &5.9884e+00_r8,5.9470e+00_r8,5.8924e+00_r8,5.8216e+00_r8,5.7342e+00_r8/)
      kbo(:,15, 8) = (/ &
     &4.9849e+00_r8,4.9563e+00_r8,4.9071e+00_r8,4.8502e+00_r8,4.7771e+00_r8/)
      kbo(:,16, 8) = (/ &
     &4.1453e+00_r8,4.1136e+00_r8,4.0790e+00_r8,4.0345e+00_r8,3.9753e+00_r8/)
      kbo(:,17, 8) = (/ &
     &3.5269e+00_r8,3.5022e+00_r8,3.4717e+00_r8,3.4323e+00_r8,3.3830e+00_r8/)
      kbo(:,18, 8) = (/ &
     &3.0258e+00_r8,3.0139e+00_r8,2.9887e+00_r8,2.9518e+00_r8,2.9096e+00_r8/)
      kbo(:,19, 8) = (/ &
     &2.6100e+00_r8,2.6057e+00_r8,2.5839e+00_r8,2.5531e+00_r8,2.5181e+00_r8/)
      kbo(:,20, 8) = (/ &
     &2.2532e+00_r8,2.2444e+00_r8,2.2242e+00_r8,2.2015e+00_r8,2.1737e+00_r8/)
      kbo(:,21, 8) = (/ &
     &1.9361e+00_r8,1.9257e+00_r8,1.9080e+00_r8,1.8885e+00_r8,1.8663e+00_r8/)
      kbo(:,22, 8) = (/ &
     &1.6493e+00_r8,1.6394e+00_r8,1.6256e+00_r8,1.6084e+00_r8,1.5911e+00_r8/)
      kbo(:,23, 8) = (/ &
     &1.3971e+00_r8,1.3901e+00_r8,1.3774e+00_r8,1.3628e+00_r8,1.3482e+00_r8/)
      kbo(:,24, 8) = (/ &
     &1.1828e+00_r8,1.1757e+00_r8,1.1653e+00_r8,1.1541e+00_r8,1.1420e+00_r8/)
      kbo(:,25, 8) = (/ &
     &9.9841e-01_r8,9.9173e-01_r8,9.8314e-01_r8,9.7419e-01_r8,9.6526e-01_r8/)
      kbo(:,26, 8) = (/ &
     &8.3815e-01_r8,8.3237e-01_r8,8.2631e-01_r8,8.2072e-01_r8,8.1439e-01_r8/)
      kbo(:,27, 8) = (/ &
     &6.9885e-01_r8,6.9534e-01_r8,6.9172e-01_r8,6.8787e-01_r8,6.8202e-01_r8/)
      kbo(:,28, 8) = (/ &
     &5.8056e-01_r8,5.7858e-01_r8,5.7609e-01_r8,5.7252e-01_r8,5.6730e-01_r8/)
      kbo(:,29, 8) = (/ &
     &4.7795e-01_r8,4.7646e-01_r8,4.7447e-01_r8,4.7127e-01_r8,4.6716e-01_r8/)
      kbo(:,30, 8) = (/ &
     &3.9180e-01_r8,3.9040e-01_r8,3.8874e-01_r8,3.8567e-01_r8,3.8256e-01_r8/)
      kbo(:,31, 8) = (/ &
     &3.1850e-01_r8,3.1735e-01_r8,3.1544e-01_r8,3.1324e-01_r8,3.1109e-01_r8/)
      kbo(:,32, 8) = (/ &
     &2.5851e-01_r8,2.5736e-01_r8,2.5590e-01_r8,2.5439e-01_r8,2.5264e-01_r8/)
      kbo(:,33, 8) = (/ &
     &2.0938e-01_r8,2.0841e-01_r8,2.0741e-01_r8,2.0615e-01_r8,2.0501e-01_r8/)
      kbo(:,34, 8) = (/ &
     &1.7037e-01_r8,1.6964e-01_r8,1.6891e-01_r8,1.6812e-01_r8,1.6728e-01_r8/)
      kbo(:,35, 8) = (/ &
     &1.3875e-01_r8,1.3827e-01_r8,1.3776e-01_r8,1.3724e-01_r8,1.3661e-01_r8/)
      kbo(:,36, 8) = (/ &
     &1.1324e-01_r8,1.1288e-01_r8,1.1260e-01_r8,1.1226e-01_r8,1.1182e-01_r8/)
      kbo(:,37, 8) = (/ &
     &9.2766e-02_r8,9.2595e-02_r8,9.2422e-02_r8,9.2186e-02_r8,9.1910e-02_r8/)
      kbo(:,38, 8) = (/ &
     &7.5939e-02_r8,7.5826e-02_r8,7.5761e-02_r8,7.5637e-02_r8,7.5518e-02_r8/)
      kbo(:,39, 8) = (/ &
     &6.2076e-02_r8,6.2014e-02_r8,6.2019e-02_r8,6.2000e-02_r8,6.1957e-02_r8/)
      kbo(:,40, 8) = (/ &
     &5.1067e-02_r8,5.1119e-02_r8,5.1147e-02_r8,5.1217e-02_r8,5.1232e-02_r8/)
      kbo(:,41, 8) = (/ &
     &4.2004e-02_r8,4.2110e-02_r8,4.2194e-02_r8,4.2288e-02_r8,4.2348e-02_r8/)
      kbo(:,42, 8) = (/ &
     &3.4565e-02_r8,3.4686e-02_r8,3.4772e-02_r8,3.4891e-02_r8,3.5001e-02_r8/)
      kbo(:,43, 8) = (/ &
     &2.8439e-02_r8,2.8558e-02_r8,2.8651e-02_r8,2.8781e-02_r8,2.8908e-02_r8/)
      kbo(:,44, 8) = (/ &
     &2.3381e-02_r8,2.3495e-02_r8,2.3607e-02_r8,2.3736e-02_r8,2.3863e-02_r8/)
      kbo(:,45, 8) = (/ &
     &1.9178e-02_r8,1.9302e-02_r8,1.9411e-02_r8,1.9527e-02_r8,1.9645e-02_r8/)
      kbo(:,46, 8) = (/ &
     &1.5718e-02_r8,1.5824e-02_r8,1.5935e-02_r8,1.6052e-02_r8,1.6161e-02_r8/)
      kbo(:,47, 8) = (/ &
     &1.2888e-02_r8,1.2994e-02_r8,1.3091e-02_r8,1.3201e-02_r8,1.3310e-02_r8/)
      kbo(:,48, 8) = (/ &
     &1.0534e-02_r8,1.0644e-02_r8,1.0741e-02_r8,1.0828e-02_r8,1.0922e-02_r8/)
      kbo(:,49, 8) = (/ &
     &8.5773e-03_r8,8.6840e-03_r8,8.7716e-03_r8,8.8561e-03_r8,8.9344e-03_r8/)
      kbo(:,50, 8) = (/ &
     &7.0118e-03_r8,7.1121e-03_r8,7.1954e-03_r8,7.2655e-03_r8,7.3372e-03_r8/)
      kbo(:,51, 8) = (/ &
     &5.7344e-03_r8,5.8326e-03_r8,5.9098e-03_r8,5.9770e-03_r8,6.0423e-03_r8/)
      kbo(:,52, 8) = (/ &
     &4.6784e-03_r8,4.7703e-03_r8,4.8415e-03_r8,4.9016e-03_r8,4.9646e-03_r8/)
      kbo(:,53, 8) = (/ &
     &3.8084e-03_r8,3.8892e-03_r8,3.9565e-03_r8,4.0107e-03_r8,4.0624e-03_r8/)
      kbo(:,54, 8) = (/ &
     &3.1302e-03_r8,3.1988e-03_r8,3.2604e-03_r8,3.3140e-03_r8,3.3627e-03_r8/)
      kbo(:,55, 8) = (/ &
     &2.5815e-03_r8,2.6417e-03_r8,2.7045e-03_r8,2.7548e-03_r8,2.8045e-03_r8/)
      kbo(:,56, 8) = (/ &
     &2.1299e-03_r8,2.1858e-03_r8,2.2412e-03_r8,2.2906e-03_r8,2.3394e-03_r8/)
      kbo(:,57, 8) = (/ &
     &1.7549e-03_r8,1.8058e-03_r8,1.8577e-03_r8,1.9050e-03_r8,1.9496e-03_r8/)
      kbo(:,58, 8) = (/ &
     &1.4508e-03_r8,1.4946e-03_r8,1.5437e-03_r8,1.5867e-03_r8,1.6288e-03_r8/)
      kbo(:,59, 8) = (/ &
     &1.2226e-03_r8,1.2669e-03_r8,1.3143e-03_r8,1.3547e-03_r8,1.3969e-03_r8/)
      kbo(:,13, 9) = (/ &
     &4.2167e+01_r8,4.2169e+01_r8,4.2037e+01_r8,4.1794e+01_r8,4.1453e+01_r8/)
      kbo(:,14, 9) = (/ &
     &3.6302e+01_r8,3.6287e+01_r8,3.6134e+01_r8,3.5895e+01_r8,3.5553e+01_r8/)
      kbo(:,15, 9) = (/ &
     &3.1018e+01_r8,3.0974e+01_r8,3.0831e+01_r8,3.0595e+01_r8,3.0284e+01_r8/)
      kbo(:,16, 9) = (/ &
     &2.6381e+01_r8,2.6327e+01_r8,2.6171e+01_r8,2.5940e+01_r8,2.5630e+01_r8/)
      kbo(:,17, 9) = (/ &
     &2.2159e+01_r8,2.2069e+01_r8,2.1921e+01_r8,2.1709e+01_r8,2.1443e+01_r8/)
      kbo(:,18, 9) = (/ &
     &1.8546e+01_r8,1.8422e+01_r8,1.8249e+01_r8,1.8049e+01_r8,1.7832e+01_r8/)
      kbo(:,19, 9) = (/ &
     &1.5581e+01_r8,1.5418e+01_r8,1.5257e+01_r8,1.5071e+01_r8,1.4880e+01_r8/)
      kbo(:,20, 9) = (/ &
     &1.3153e+01_r8,1.2997e+01_r8,1.2837e+01_r8,1.2663e+01_r8,1.2482e+01_r8/)
      kbo(:,21, 9) = (/ &
     &1.1154e+01_r8,1.1003e+01_r8,1.0876e+01_r8,1.0723e+01_r8,1.0559e+01_r8/)
      kbo(:,22, 9) = (/ &
     &9.6248e+00_r8,9.4985e+00_r8,9.3603e+00_r8,9.2175e+00_r8,9.0746e+00_r8/)
      kbo(:,23, 9) = (/ &
     &8.3452e+00_r8,8.2318e+00_r8,8.1134e+00_r8,7.9935e+00_r8,7.8653e+00_r8/)
      kbo(:,24, 9) = (/ &
     &7.2560e+00_r8,7.1534e+00_r8,7.0580e+00_r8,6.9498e+00_r8,6.8440e+00_r8/)
      kbo(:,25, 9) = (/ &
     &6.3013e+00_r8,6.2279e+00_r8,6.1411e+00_r8,6.0460e+00_r8,5.9566e+00_r8/)
      kbo(:,26, 9) = (/ &
     &5.4473e+00_r8,5.3837e+00_r8,5.3066e+00_r8,5.2353e+00_r8,5.1609e+00_r8/)
      kbo(:,27, 9) = (/ &
     &4.6665e+00_r8,4.6055e+00_r8,4.5477e+00_r8,4.4876e+00_r8,4.4277e+00_r8/)
      kbo(:,28, 9) = (/ &
     &3.9616e+00_r8,3.9145e+00_r8,3.8668e+00_r8,3.8180e+00_r8,3.7694e+00_r8/)
      kbo(:,29, 9) = (/ &
     &3.3226e+00_r8,3.2862e+00_r8,3.2469e+00_r8,3.2091e+00_r8,3.1718e+00_r8/)
      kbo(:,30, 9) = (/ &
     &2.7659e+00_r8,2.7390e+00_r8,2.7094e+00_r8,2.6815e+00_r8,2.6543e+00_r8/)
      kbo(:,31, 9) = (/ &
     &2.2826e+00_r8,2.2617e+00_r8,2.2409e+00_r8,2.2203e+00_r8,2.1979e+00_r8/)
      kbo(:,32, 9) = (/ &
     &1.8802e+00_r8,1.8648e+00_r8,1.8493e+00_r8,1.8340e+00_r8,1.8168e+00_r8/)
      kbo(:,33, 9) = (/ &
     &1.5466e+00_r8,1.5353e+00_r8,1.5232e+00_r8,1.5114e+00_r8,1.4999e+00_r8/)
      kbo(:,34, 9) = (/ &
     &1.2752e+00_r8,1.2674e+00_r8,1.2588e+00_r8,1.2512e+00_r8,1.2426e+00_r8/)
      kbo(:,35, 9) = (/ &
     &1.0520e+00_r8,1.0466e+00_r8,1.0412e+00_r8,1.0356e+00_r8,1.0296e+00_r8/)
      kbo(:,36, 9) = (/ &
     &8.6897e-01_r8,8.6546e-01_r8,8.6220e-01_r8,8.5818e-01_r8,8.5421e-01_r8/)
      kbo(:,37, 9) = (/ &
     &7.1978e-01_r8,7.1767e-01_r8,7.1572e-01_r8,7.1373e-01_r8,7.1176e-01_r8/)
      kbo(:,38, 9) = (/ &
     &5.9482e-01_r8,5.9396e-01_r8,5.9353e-01_r8,5.9295e-01_r8,5.9232e-01_r8/)
      kbo(:,39, 9) = (/ &
     &4.9071e-01_r8,4.9116e-01_r8,4.9162e-01_r8,4.9173e-01_r8,4.9201e-01_r8/)
      kbo(:,40, 9) = (/ &
     &4.0707e-01_r8,4.0846e-01_r8,4.0948e-01_r8,4.1018e-01_r8,4.1089e-01_r8/)
      kbo(:,41, 9) = (/ &
     &3.3813e-01_r8,3.3959e-01_r8,3.4089e-01_r8,3.4218e-01_r8,3.4329e-01_r8/)
      kbo(:,42, 9) = (/ &
     &2.8061e-01_r8,2.8231e-01_r8,2.8363e-01_r8,2.8501e-01_r8,2.8630e-01_r8/)
      kbo(:,43, 9) = (/ &
     &2.3284e-01_r8,2.3448e-01_r8,2.3606e-01_r8,2.3737e-01_r8,2.3893e-01_r8/)
      kbo(:,44, 9) = (/ &
     &1.9306e-01_r8,1.9456e-01_r8,1.9627e-01_r8,1.9759e-01_r8,1.9913e-01_r8/)
      kbo(:,45, 9) = (/ &
     &1.5984e-01_r8,1.6139e-01_r8,1.6282e-01_r8,1.6435e-01_r8,1.6569e-01_r8/)
      kbo(:,46, 9) = (/ &
     &1.3218e-01_r8,1.3367e-01_r8,1.3504e-01_r8,1.3656e-01_r8,1.3780e-01_r8/)
      kbo(:,47, 9) = (/ &
     &1.0925e-01_r8,1.1079e-01_r8,1.1209e-01_r8,1.1337e-01_r8,1.1463e-01_r8/)
      kbo(:,48, 9) = (/ &
     &9.0249e-02_r8,9.1522e-02_r8,9.2774e-02_r8,9.3960e-02_r8,9.5177e-02_r8/)
      kbo(:,49, 9) = (/ &
     &7.4377e-02_r8,7.5400e-02_r8,7.6569e-02_r8,7.7633e-02_r8,7.8742e-02_r8/)
      kbo(:,50, 9) = (/ &
     &6.1418e-02_r8,6.2415e-02_r8,6.3422e-02_r8,6.4413e-02_r8,6.5389e-02_r8/)
      kbo(:,51, 9) = (/ &
     &5.0729e-02_r8,5.1644e-02_r8,5.2564e-02_r8,5.3444e-02_r8,5.4353e-02_r8/)
      kbo(:,52, 9) = (/ &
     &4.1908e-02_r8,4.2660e-02_r8,4.3502e-02_r8,4.4323e-02_r8,4.5095e-02_r8/)
      kbo(:,53, 9) = (/ &
     &3.4462e-02_r8,3.5223e-02_r8,3.5939e-02_r8,3.6640e-02_r8,3.7360e-02_r8/)
      kbo(:,54, 9) = (/ &
     &2.8588e-02_r8,2.9269e-02_r8,2.9929e-02_r8,3.0560e-02_r8,3.1160e-02_r8/)
      kbo(:,55, 9) = (/ &
     &2.3807e-02_r8,2.4406e-02_r8,2.4997e-02_r8,2.5573e-02_r8,2.6196e-02_r8/)
      kbo(:,56, 9) = (/ &
     &1.9841e-02_r8,2.0395e-02_r8,2.0945e-02_r8,2.1491e-02_r8,2.2006e-02_r8/)
      kbo(:,57, 9) = (/ &
     &1.6519e-02_r8,1.7032e-02_r8,1.7546e-02_r8,1.8054e-02_r8,1.8550e-02_r8/)
      kbo(:,58, 9) = (/ &
     &1.3793e-02_r8,1.4292e-02_r8,1.4753e-02_r8,1.5213e-02_r8,1.5695e-02_r8/)
      kbo(:,59, 9) = (/ &
     &1.1809e-02_r8,1.2269e-02_r8,1.2713e-02_r8,1.3163e-02_r8,1.3635e-02_r8/)
      kbo(:,13,10) = (/ &
     &1.7142e+02_r8,1.7281e+02_r8,1.7236e+02_r8,1.7114e+02_r8,1.6934e+02_r8/)
      kbo(:,14,10) = (/ &
     &1.5574e+02_r8,1.5556e+02_r8,1.5469e+02_r8,1.5334e+02_r8,1.5193e+02_r8/)
      kbo(:,15,10) = (/ &
     &1.3728e+02_r8,1.3704e+02_r8,1.3637e+02_r8,1.3560e+02_r8,1.3459e+02_r8/)
      kbo(:,16,10) = (/ &
     &1.1953e+02_r8,1.1932e+02_r8,1.1895e+02_r8,1.1818e+02_r8,1.1715e+02_r8/)
      kbo(:,17,10) = (/ &
     &1.0359e+02_r8,1.0375e+02_r8,1.0320e+02_r8,1.0240e+02_r8,1.0131e+02_r8/)
      kbo(:,18,10) = (/ &
     &8.8878e+01_r8,8.9020e+01_r8,8.8706e+01_r8,8.7973e+01_r8,8.6746e+01_r8/)
      kbo(:,19,10) = (/ &
     &7.4020e+01_r8,7.4305e+01_r8,7.4019e+01_r8,7.3466e+01_r8,7.2562e+01_r8/)
      kbo(:,20,10) = (/ &
     &6.0721e+01_r8,6.1015e+01_r8,6.0921e+01_r8,6.0532e+01_r8,5.9983e+01_r8/)
      kbo(:,21,10) = (/ &
     &5.0465e+01_r8,5.0665e+01_r8,5.0241e+01_r8,4.9849e+01_r8,4.9385e+01_r8/)
      kbo(:,22,10) = (/ &
     &4.0819e+01_r8,4.0731e+01_r8,4.0529e+01_r8,4.0271e+01_r8,3.9749e+01_r8/)
      kbo(:,23,10) = (/ &
     &3.4205e+01_r8,3.4202e+01_r8,3.4020e+01_r8,3.3582e+01_r8,3.3186e+01_r8/)
      kbo(:,24,10) = (/ &
     &2.9307e+01_r8,2.9168e+01_r8,2.8849e+01_r8,2.8552e+01_r8,2.8160e+01_r8/)
      kbo(:,25,10) = (/ &
     &2.5427e+01_r8,2.5125e+01_r8,2.4814e+01_r8,2.4511e+01_r8,2.4195e+01_r8/)
      kbo(:,26,10) = (/ &
     &2.2227e+01_r8,2.1953e+01_r8,2.1723e+01_r8,2.1344e+01_r8,2.1061e+01_r8/)
      kbo(:,27,10) = (/ &
     &1.9562e+01_r8,1.9387e+01_r8,1.9087e+01_r8,1.8779e+01_r8,1.8567e+01_r8/)
      kbo(:,28,10) = (/ &
     &1.7147e+01_r8,1.6935e+01_r8,1.6668e+01_r8,1.6479e+01_r8,1.6263e+01_r8/)
      kbo(:,29,10) = (/ &
     &1.4781e+01_r8,1.4573e+01_r8,1.4404e+01_r8,1.4242e+01_r8,1.4093e+01_r8/)
      kbo(:,30,10) = (/ &
     &1.2615e+01_r8,1.2471e+01_r8,1.2325e+01_r8,1.2193e+01_r8,1.2047e+01_r8/)
      kbo(:,31,10) = (/ &
     &1.0637e+01_r8,1.0540e+01_r8,1.0405e+01_r8,1.0303e+01_r8,1.0219e+01_r8/)
      kbo(:,32,10) = (/ &
     &8.9113e+00_r8,8.8364e+00_r8,8.7502e+00_r8,8.6801e+00_r8,8.6141e+00_r8/)
      kbo(:,33,10) = (/ &
     &7.4220e+00_r8,7.3714e+00_r8,7.3296e+00_r8,7.2916e+00_r8,7.2335e+00_r8/)
      kbo(:,34,10) = (/ &
     &6.2166e+00_r8,6.1844e+00_r8,6.1565e+00_r8,6.1097e+00_r8,6.0839e+00_r8/)
      kbo(:,35,10) = (/ &
     &5.1978e+00_r8,5.1804e+00_r8,5.1597e+00_r8,5.1357e+00_r8,5.1182e+00_r8/)
      kbo(:,36,10) = (/ &
     &4.3470e+00_r8,4.3385e+00_r8,4.3233e+00_r8,4.3177e+00_r8,4.3104e+00_r8/)
      kbo(:,37,10) = (/ &
     &3.6398e+00_r8,3.6424e+00_r8,3.6345e+00_r8,3.6386e+00_r8,3.6334e+00_r8/)
      kbo(:,38,10) = (/ &
     &3.0434e+00_r8,3.0512e+00_r8,3.0559e+00_r8,3.0639e+00_r8,3.0639e+00_r8/)
      kbo(:,39,10) = (/ &
     &2.5458e+00_r8,2.5538e+00_r8,2.5569e+00_r8,2.5728e+00_r8,2.5769e+00_r8/)
      kbo(:,40,10) = (/ &
     &2.1317e+00_r8,2.1438e+00_r8,2.1539e+00_r8,2.1706e+00_r8,2.1835e+00_r8/)
      kbo(:,41,10) = (/ &
     &1.7848e+00_r8,1.8052e+00_r8,1.8158e+00_r8,1.8336e+00_r8,1.8470e+00_r8/)
      kbo(:,42,10) = (/ &
     &1.4932e+00_r8,1.5091e+00_r8,1.5289e+00_r8,1.5466e+00_r8,1.5621e+00_r8/)
      kbo(:,43,10) = (/ &
     &1.2466e+00_r8,1.2672e+00_r8,1.2843e+00_r8,1.3063e+00_r8,1.3216e+00_r8/)
      kbo(:,44,10) = (/ &
     &1.0395e+00_r8,1.0592e+00_r8,1.0758e+00_r8,1.0990e+00_r8,1.1149e+00_r8/)
      kbo(:,45,10) = (/ &
     &8.6570e-01_r8,8.8331e-01_r8,9.0051e-01_r8,9.1956e-01_r8,9.3855e-01_r8/)
      kbo(:,46,10) = (/ &
     &7.2006e-01_r8,7.3467e-01_r8,7.5104e-01_r8,7.6845e-01_r8,7.8787e-01_r8/)
      kbo(:,47,10) = (/ &
     &5.9818e-01_r8,6.0970e-01_r8,6.2444e-01_r8,6.4248e-01_r8,6.5898e-01_r8/)
      kbo(:,48,10) = (/ &
     &4.9441e-01_r8,5.0661e-01_r8,5.1925e-01_r8,5.3379e-01_r8,5.5029e-01_r8/)
      kbo(:,49,10) = (/ &
     &4.0883e-01_r8,4.1946e-01_r8,4.3019e-01_r8,4.4310e-01_r8,4.5870e-01_r8/)
      kbo(:,50,10) = (/ &
     &3.3724e-01_r8,3.4698e-01_r8,3.5791e-01_r8,3.6811e-01_r8,3.8262e-01_r8/)
      kbo(:,51,10) = (/ &
     &2.7937e-01_r8,2.8820e-01_r8,2.9748e-01_r8,3.0671e-01_r8,3.1956e-01_r8/)
      kbo(:,52,10) = (/ &
     &2.3100e-01_r8,2.3806e-01_r8,2.4610e-01_r8,2.5504e-01_r8,2.6621e-01_r8/)
      kbo(:,53,10) = (/ &
     &1.9108e-01_r8,1.9654e-01_r8,2.0325e-01_r8,2.1194e-01_r8,2.2154e-01_r8/)
      kbo(:,54,10) = (/ &
     &1.5899e-01_r8,1.6347e-01_r8,1.6947e-01_r8,1.7655e-01_r8,1.8610e-01_r8/)
      kbo(:,55,10) = (/ &
     &1.3326e-01_r8,1.3696e-01_r8,1.4221e-01_r8,1.4834e-01_r8,1.5647e-01_r8/)
      kbo(:,56,10) = (/ &
     &1.1049e-01_r8,1.1469e-01_r8,1.1935e-01_r8,1.2428e-01_r8,1.3176e-01_r8/)
      kbo(:,57,10) = (/ &
     &9.2761e-02_r8,9.6003e-02_r8,9.9705e-02_r8,1.0515e-01_r8,1.1098e-01_r8/)
      kbo(:,58,10) = (/ &
     &7.7951e-02_r8,8.0603e-02_r8,8.4255e-02_r8,8.8708e-02_r8,9.3824e-02_r8/)
      kbo(:,59,10) = (/ &
     &6.6831e-02_r8,6.9853e-02_r8,7.3196e-02_r8,7.7714e-02_r8,8.2447e-02_r8/)
      kbo(:,13,11) = (/ &
     &2.9044e+02_r8,2.9107e+02_r8,2.9274e+02_r8,2.9324e+02_r8,2.9124e+02_r8/)
      kbo(:,14,11) = (/ &
     &2.7118e+02_r8,2.7257e+02_r8,2.7251e+02_r8,2.7007e+02_r8,2.6710e+02_r8/)
      kbo(:,15,11) = (/ &
     &2.5062e+02_r8,2.5131e+02_r8,2.4974e+02_r8,2.4698e+02_r8,2.4378e+02_r8/)
      kbo(:,16,11) = (/ &
     &2.2673e+02_r8,2.2541e+02_r8,2.2341e+02_r8,2.2106e+02_r8,2.1873e+02_r8/)
      kbo(:,17,11) = (/ &
     &1.9976e+02_r8,1.9861e+02_r8,1.9716e+02_r8,1.9539e+02_r8,1.9362e+02_r8/)
      kbo(:,18,11) = (/ &
     &1.7313e+02_r8,1.7242e+02_r8,1.7179e+02_r8,1.7065e+02_r8,1.6917e+02_r8/)
      kbo(:,19,11) = (/ &
     &1.5014e+02_r8,1.4982e+02_r8,1.4894e+02_r8,1.4750e+02_r8,1.4584e+02_r8/)
      kbo(:,20,11) = (/ &
     &1.2916e+02_r8,1.2859e+02_r8,1.2771e+02_r8,1.2637e+02_r8,1.2459e+02_r8/)
      kbo(:,21,11) = (/ &
     &1.0806e+02_r8,1.0775e+02_r8,1.0718e+02_r8,1.0610e+02_r8,1.0475e+02_r8/)
      kbo(:,22,11) = (/ &
     &8.9165e+01_r8,8.9073e+01_r8,8.8652e+01_r8,8.7815e+01_r8,8.6979e+01_r8/)
      kbo(:,23,11) = (/ &
     &7.2556e+01_r8,7.2172e+01_r8,7.1575e+01_r8,7.1058e+01_r8,7.0305e+01_r8/)
      kbo(:,24,11) = (/ &
     &5.8830e+01_r8,5.8306e+01_r8,5.7758e+01_r8,5.7080e+01_r8,5.6291e+01_r8/)
      kbo(:,25,11) = (/ &
     &4.9821e+01_r8,4.9499e+01_r8,4.8965e+01_r8,4.8414e+01_r8,4.7810e+01_r8/)
      kbo(:,26,11) = (/ &
     &4.2622e+01_r8,4.2267e+01_r8,4.1876e+01_r8,4.1470e+01_r8,4.0806e+01_r8/)
      kbo(:,27,11) = (/ &
     &3.6706e+01_r8,3.6324e+01_r8,3.5968e+01_r8,3.5540e+01_r8,3.5058e+01_r8/)
      kbo(:,28,11) = (/ &
     &3.1978e+01_r8,3.1566e+01_r8,3.1237e+01_r8,3.0772e+01_r8,3.0454e+01_r8/)
      kbo(:,29,11) = (/ &
     &2.7828e+01_r8,2.7575e+01_r8,2.7171e+01_r8,2.6860e+01_r8,2.6508e+01_r8/)
      kbo(:,30,11) = (/ &
     &2.4147e+01_r8,2.3835e+01_r8,2.3571e+01_r8,2.3332e+01_r8,2.3114e+01_r8/)
      kbo(:,31,11) = (/ &
     &2.0703e+01_r8,2.0408e+01_r8,2.0254e+01_r8,2.0067e+01_r8,1.9883e+01_r8/)
      kbo(:,32,11) = (/ &
     &1.7639e+01_r8,1.7476e+01_r8,1.7324e+01_r8,1.7159e+01_r8,1.7076e+01_r8/)
      kbo(:,33,11) = (/ &
     &1.4975e+01_r8,1.4865e+01_r8,1.4744e+01_r8,1.4668e+01_r8,1.4624e+01_r8/)
      kbo(:,34,11) = (/ &
     &1.2711e+01_r8,1.2631e+01_r8,1.2589e+01_r8,1.2550e+01_r8,1.2508e+01_r8/)
      kbo(:,35,11) = (/ &
     &1.0751e+01_r8,1.0723e+01_r8,1.0704e+01_r8,1.0702e+01_r8,1.0681e+01_r8/)
      kbo(:,36,11) = (/ &
     &9.0814e+00_r8,9.0752e+00_r8,9.0908e+00_r8,9.1081e+00_r8,9.1217e+00_r8/)
      kbo(:,37,11) = (/ &
     &7.6820e+00_r8,7.7040e+00_r8,7.7379e+00_r8,7.7515e+00_r8,7.7864e+00_r8/)
      kbo(:,38,11) = (/ &
     &6.4923e+00_r8,6.5176e+00_r8,6.5490e+00_r8,6.5779e+00_r8,6.6281e+00_r8/)
      kbo(:,39,11) = (/ &
     &5.4567e+00_r8,5.4975e+00_r8,5.5468e+00_r8,5.5843e+00_r8,5.6396e+00_r8/)
      kbo(:,40,11) = (/ &
     &4.6201e+00_r8,4.6597e+00_r8,4.7074e+00_r8,4.7531e+00_r8,4.8054e+00_r8/)
      kbo(:,41,11) = (/ &
     &3.8974e+00_r8,3.9399e+00_r8,3.9967e+00_r8,4.0418e+00_r8,4.1011e+00_r8/)
      kbo(:,42,11) = (/ &
     &3.2907e+00_r8,3.3361e+00_r8,3.3839e+00_r8,3.4382e+00_r8,3.4997e+00_r8/)
      kbo(:,43,11) = (/ &
     &2.7732e+00_r8,2.8146e+00_r8,2.8677e+00_r8,2.9201e+00_r8,2.9866e+00_r8/)
      kbo(:,44,11) = (/ &
     &2.3284e+00_r8,2.3728e+00_r8,2.4251e+00_r8,2.4785e+00_r8,2.5440e+00_r8/)
      kbo(:,45,11) = (/ &
     &1.9528e+00_r8,1.9951e+00_r8,2.0498e+00_r8,2.1003e+00_r8,2.1644e+00_r8/)
      kbo(:,46,11) = (/ &
     &1.6318e+00_r8,1.6755e+00_r8,1.7227e+00_r8,1.7737e+00_r8,1.8354e+00_r8/)
      kbo(:,47,11) = (/ &
     &1.3599e+00_r8,1.4032e+00_r8,1.4486e+00_r8,1.4978e+00_r8,1.5556e+00_r8/)
      kbo(:,48,11) = (/ &
     &1.1311e+00_r8,1.1685e+00_r8,1.2136e+00_r8,1.2615e+00_r8,1.3144e+00_r8/)
      kbo(:,49,11) = (/ &
     &9.3555e-01_r8,9.7341e-01_r8,1.0126e+00_r8,1.0587e+00_r8,1.1063e+00_r8/)
      kbo(:,50,11) = (/ &
     &7.7693e-01_r8,8.0966e-01_r8,8.4684e-01_r8,8.9020e-01_r8,9.3317e-01_r8/)
      kbo(:,51,11) = (/ &
     &6.4536e-01_r8,6.7488e-01_r8,7.0604e-01_r8,7.4875e-01_r8,7.8723e-01_r8/)
      kbo(:,52,11) = (/ &
     &5.3457e-01_r8,5.5971e-01_r8,5.9092e-01_r8,6.2609e-01_r8,6.6312e-01_r8/)
      kbo(:,53,11) = (/ &
     &4.4222e-01_r8,4.6435e-01_r8,4.9056e-01_r8,5.2208e-01_r8,5.5614e-01_r8/)
      kbo(:,54,11) = (/ &
     &3.6743e-01_r8,3.8638e-01_r8,4.1127e-01_r8,4.3844e-01_r8,4.6892e-01_r8/)
      kbo(:,55,11) = (/ &
     &3.0658e-01_r8,3.2360e-01_r8,3.4391e-01_r8,3.6924e-01_r8,3.9670e-01_r8/)
      kbo(:,56,11) = (/ &
     &2.5551e-01_r8,2.6954e-01_r8,2.8819e-01_r8,3.1080e-01_r8,3.3508e-01_r8/)
      kbo(:,57,11) = (/ &
     &2.1322e-01_r8,2.2632e-01_r8,2.4139e-01_r8,2.5957e-01_r8,2.8310e-01_r8/)
      kbo(:,58,11) = (/ &
     &1.7898e-01_r8,1.8948e-01_r8,2.0228e-01_r8,2.1870e-01_r8,2.4000e-01_r8/)
      kbo(:,59,11) = (/ &
     &1.5351e-01_r8,1.6320e-01_r8,1.7439e-01_r8,1.8953e-01_r8,2.0982e-01_r8/)
      kbo(:,13,12) = (/ &
     &5.5035e+02_r8,5.5083e+02_r8,5.4893e+02_r8,5.4549e+02_r8,5.4357e+02_r8/)
      kbo(:,14,12) = (/ &
     &5.1666e+02_r8,5.1747e+02_r8,5.1731e+02_r8,5.1865e+02_r8,5.1926e+02_r8/)
      kbo(:,15,12) = (/ &
     &4.8259e+02_r8,4.8322e+02_r8,4.8500e+02_r8,4.8625e+02_r8,4.8440e+02_r8/)
      kbo(:,16,12) = (/ &
     &4.4814e+02_r8,4.5080e+02_r8,4.5253e+02_r8,4.5080e+02_r8,4.4664e+02_r8/)
      kbo(:,17,12) = (/ &
     &4.1611e+02_r8,4.1780e+02_r8,4.1594e+02_r8,4.1174e+02_r8,4.0672e+02_r8/)
      kbo(:,18,12) = (/ &
     &3.8097e+02_r8,3.8017e+02_r8,3.7694e+02_r8,3.7269e+02_r8,3.6847e+02_r8/)
      kbo(:,19,12) = (/ &
     &3.3900e+02_r8,3.3735e+02_r8,3.3499e+02_r8,3.3205e+02_r8,3.2864e+02_r8/)
      kbo(:,20,12) = (/ &
     &2.9644e+02_r8,2.9567e+02_r8,2.9387e+02_r8,2.9171e+02_r8,2.8914e+02_r8/)
      kbo(:,21,12) = (/ &
     &2.5711e+02_r8,2.5659e+02_r8,2.5545e+02_r8,2.5349e+02_r8,2.5090e+02_r8/)
      kbo(:,22,12) = (/ &
     &2.2227e+02_r8,2.2144e+02_r8,2.1973e+02_r8,2.1742e+02_r8,2.1472e+02_r8/)
      kbo(:,23,12) = (/ &
     &1.8874e+02_r8,1.8786e+02_r8,1.8655e+02_r8,1.8434e+02_r8,1.8190e+02_r8/)
      kbo(:,24,12) = (/ &
     &1.5708e+02_r8,1.5682e+02_r8,1.5564e+02_r8,1.5414e+02_r8,1.5250e+02_r8/)
      kbo(:,25,12) = (/ &
     &1.2691e+02_r8,1.2649e+02_r8,1.2582e+02_r8,1.2476e+02_r8,1.2335e+02_r8/)
      kbo(:,26,12) = (/ &
     &1.0261e+02_r8,1.0208e+02_r8,1.0124e+02_r8,1.0027e+02_r8,9.9263e+01_r8/)
      kbo(:,27,12) = (/ &
     &8.5769e+01_r8,8.4989e+01_r8,8.4207e+01_r8,8.3351e+01_r8,8.2249e+01_r8/)
      kbo(:,28,12) = (/ &
     &7.3314e+01_r8,7.2801e+01_r8,7.2005e+01_r8,7.1293e+01_r8,7.0277e+01_r8/)
      kbo(:,29,12) = (/ &
     &6.2526e+01_r8,6.2052e+01_r8,6.1497e+01_r8,6.0774e+01_r8,6.0060e+01_r8/)
      kbo(:,30,12) = (/ &
     &5.3636e+01_r8,5.3199e+01_r8,5.2692e+01_r8,5.1970e+01_r8,5.1392e+01_r8/)
      kbo(:,31,12) = (/ &
     &4.6032e+01_r8,4.5690e+01_r8,4.5122e+01_r8,4.4615e+01_r8,4.4345e+01_r8/)
      kbo(:,32,12) = (/ &
     &3.9736e+01_r8,3.9262e+01_r8,3.8850e+01_r8,3.8552e+01_r8,3.8247e+01_r8/)
      kbo(:,33,12) = (/ &
     &3.4154e+01_r8,3.3807e+01_r8,3.3534e+01_r8,3.3264e+01_r8,3.3008e+01_r8/)
      kbo(:,34,12) = (/ &
     &2.9451e+01_r8,2.9219e+01_r8,2.9024e+01_r8,2.8833e+01_r8,2.8685e+01_r8/)
      kbo(:,35,12) = (/ &
     &2.5346e+01_r8,2.5246e+01_r8,2.5119e+01_r8,2.4977e+01_r8,2.4976e+01_r8/)
      kbo(:,36,12) = (/ &
     &2.1817e+01_r8,2.1779e+01_r8,2.1703e+01_r8,2.1681e+01_r8,2.1750e+01_r8/)
      kbo(:,37,12) = (/ &
     &1.8813e+01_r8,1.8767e+01_r8,1.8799e+01_r8,1.8847e+01_r8,1.8941e+01_r8/)
      kbo(:,38,12) = (/ &
     &1.6125e+01_r8,1.6141e+01_r8,1.6208e+01_r8,1.6337e+01_r8,1.6455e+01_r8/)
      kbo(:,39,12) = (/ &
     &1.3770e+01_r8,1.3861e+01_r8,1.3953e+01_r8,1.4099e+01_r8,1.4238e+01_r8/)
      kbo(:,40,12) = (/ &
     &1.1787e+01_r8,1.1887e+01_r8,1.2028e+01_r8,1.2178e+01_r8,1.2352e+01_r8/)
      kbo(:,41,12) = (/ &
     &1.0073e+01_r8,1.0213e+01_r8,1.0351e+01_r8,1.0547e+01_r8,1.0724e+01_r8/)
      kbo(:,42,12) = (/ &
     &8.5925e+00_r8,8.7331e+00_r8,8.9300e+00_r8,9.0948e+00_r8,9.2833e+00_r8/)
      kbo(:,43,12) = (/ &
     &7.3118e+00_r8,7.4895e+00_r8,7.6577e+00_r8,7.8465e+00_r8,8.0457e+00_r8/)
      kbo(:,44,12) = (/ &
     &6.2222e+00_r8,6.3886e+00_r8,6.5774e+00_r8,6.7646e+00_r8,6.9710e+00_r8/)
      kbo(:,45,12) = (/ &
     &5.2923e+00_r8,5.4528e+00_r8,5.6365e+00_r8,5.8147e+00_r8,6.0122e+00_r8/)
      kbo(:,46,12) = (/ &
     &4.4844e+00_r8,4.6394e+00_r8,4.8198e+00_r8,4.9986e+00_r8,5.1861e+00_r8/)
      kbo(:,47,12) = (/ &
     &3.7915e+00_r8,3.9458e+00_r8,4.1119e+00_r8,4.2905e+00_r8,4.4702e+00_r8/)
      kbo(:,48,12) = (/ &
     &3.2031e+00_r8,3.3449e+00_r8,3.4984e+00_r8,3.6554e+00_r8,3.8276e+00_r8/)
      kbo(:,49,12) = (/ &
     &2.6829e+00_r8,2.8156e+00_r8,2.9666e+00_r8,3.1113e+00_r8,3.2647e+00_r8/)
      kbo(:,50,12) = (/ &
     &2.2570e+00_r8,2.3778e+00_r8,2.5052e+00_r8,2.6542e+00_r8,2.7988e+00_r8/)
      kbo(:,51,12) = (/ &
     &1.8957e+00_r8,2.0048e+00_r8,2.1275e+00_r8,2.2538e+00_r8,2.3944e+00_r8/)
      kbo(:,52,12) = (/ &
     &1.5859e+00_r8,1.6936e+00_r8,1.7982e+00_r8,1.9164e+00_r8,2.0433e+00_r8/)
      kbo(:,53,12) = (/ &
     &1.3268e+00_r8,1.4138e+00_r8,1.5132e+00_r8,1.6183e+00_r8,1.7346e+00_r8/)
      kbo(:,54,12) = (/ &
     &1.1132e+00_r8,1.1981e+00_r8,1.2847e+00_r8,1.3880e+00_r8,1.4926e+00_r8/)
      kbo(:,55,12) = (/ &
     &9.3399e-01_r8,1.0137e+00_r8,1.0949e+00_r8,1.1891e+00_r8,1.2944e+00_r8/)
      kbo(:,56,12) = (/ &
     &7.8822e-01_r8,8.5806e-01_r8,9.3275e-01_r8,1.0165e+00_r8,1.1194e+00_r8/)
      kbo(:,57,12) = (/ &
     &6.5846e-01_r8,7.2237e-01_r8,7.9487e-01_r8,8.7625e-01_r8,9.6708e-01_r8/)
      kbo(:,58,12) = (/ &
     &5.5082e-01_r8,6.0932e-01_r8,6.7677e-01_r8,7.5228e-01_r8,8.3907e-01_r8/)
      kbo(:,59,12) = (/ &
     &4.7097e-01_r8,5.2693e-01_r8,5.8955e-01_r8,6.6574e-01_r8,7.5245e-01_r8/)
      kbo(:,13,13) = (/ &
     &1.1006e+03_r8,1.0930e+03_r8,1.0868e+03_r8,1.0845e+03_r8,1.0783e+03_r8/)
      kbo(:,14,13) = (/ &
     &1.0959e+03_r8,1.0919e+03_r8,1.0910e+03_r8,1.0859e+03_r8,1.0743e+03_r8/)
      kbo(:,15,13) = (/ &
     &1.0739e+03_r8,1.0736e+03_r8,1.0715e+03_r8,1.0637e+03_r8,1.0554e+03_r8/)
      kbo(:,16,13) = (/ &
     &1.0348e+03_r8,1.0368e+03_r8,1.0336e+03_r8,1.0297e+03_r8,1.0251e+03_r8/)
      kbo(:,17,13) = (/ &
     &9.8104e+02_r8,9.8318e+02_r8,9.8416e+02_r8,9.8388e+02_r8,9.8177e+02_r8/)
      kbo(:,18,13) = (/ &
     &9.1939e+02_r8,9.2259e+02_r8,9.2492e+02_r8,9.2597e+02_r8,9.2235e+02_r8/)
      kbo(:,19,13) = (/ &
     &8.5744e+02_r8,8.6138e+02_r8,8.6320e+02_r8,8.6092e+02_r8,8.5380e+02_r8/)
      kbo(:,20,13) = (/ &
     &7.9222e+02_r8,7.9480e+02_r8,7.9309e+02_r8,7.8688e+02_r8,7.7879e+02_r8/)
      kbo(:,21,13) = (/ &
     &7.2352e+02_r8,7.2196e+02_r8,7.1706e+02_r8,7.1061e+02_r8,7.0329e+02_r8/)
      kbo(:,22,13) = (/ &
     &6.4947e+02_r8,6.4590e+02_r8,6.4130e+02_r8,6.3579e+02_r8,6.2875e+02_r8/)
      kbo(:,23,13) = (/ &
     &5.7230e+02_r8,5.6958e+02_r8,5.6554e+02_r8,5.6079e+02_r8,5.5572e+02_r8/)
      kbo(:,24,13) = (/ &
     &4.9907e+02_r8,4.9687e+02_r8,4.9379e+02_r8,4.8982e+02_r8,4.8472e+02_r8/)
      kbo(:,25,13) = (/ &
     &4.3090e+02_r8,4.2914e+02_r8,4.2610e+02_r8,4.2208e+02_r8,4.1721e+02_r8/)
      kbo(:,26,13) = (/ &
     &3.6834e+02_r8,3.6617e+02_r8,3.6313e+02_r8,3.5932e+02_r8,3.5509e+02_r8/)
      kbo(:,27,13) = (/ &
     &3.0815e+02_r8,3.0692e+02_r8,3.0435e+02_r8,3.0103e+02_r8,2.9773e+02_r8/)
      kbo(:,28,13) = (/ &
     &2.5402e+02_r8,2.5274e+02_r8,2.5083e+02_r8,2.4862e+02_r8,2.4624e+02_r8/)
      kbo(:,29,13) = (/ &
     &2.0985e+02_r8,2.0878e+02_r8,2.0729e+02_r8,2.0573e+02_r8,2.0375e+02_r8/)
      kbo(:,30,13) = (/ &
     &1.7400e+02_r8,1.7284e+02_r8,1.7160e+02_r8,1.7041e+02_r8,1.6891e+02_r8/)
      kbo(:,31,13) = (/ &
     &1.4590e+02_r8,1.4515e+02_r8,1.4409e+02_r8,1.4281e+02_r8,1.4174e+02_r8/)
      kbo(:,32,13) = (/ &
     &1.2352e+02_r8,1.2281e+02_r8,1.2185e+02_r8,1.2095e+02_r8,1.2000e+02_r8/)
      kbo(:,33,13) = (/ &
     &1.0504e+02_r8,1.0445e+02_r8,1.0374e+02_r8,1.0318e+02_r8,1.0254e+02_r8/)
      kbo(:,34,13) = (/ &
     &8.9914e+01_r8,8.9264e+01_r8,8.8774e+01_r8,8.8232e+01_r8,8.7968e+01_r8/)
      kbo(:,35,13) = (/ &
     &7.7137e+01_r8,7.6673e+01_r8,7.6351e+01_r8,7.5989e+01_r8,7.5812e+01_r8/)
      kbo(:,36,13) = (/ &
     &6.6630e+01_r8,6.6370e+01_r8,6.6000e+01_r8,6.5870e+01_r8,6.5834e+01_r8/)
      kbo(:,37,13) = (/ &
     &5.7835e+01_r8,5.7711e+01_r8,5.7500e+01_r8,5.7478e+01_r8,5.7625e+01_r8/)
      kbo(:,38,13) = (/ &
     &5.0326e+01_r8,5.0239e+01_r8,5.0196e+01_r8,5.0287e+01_r8,5.0433e+01_r8/)
      kbo(:,39,13) = (/ &
     &4.3783e+01_r8,4.3749e+01_r8,4.3859e+01_r8,4.3984e+01_r8,4.4262e+01_r8/)
      kbo(:,40,13) = (/ &
     &3.8311e+01_r8,3.8366e+01_r8,3.8494e+01_r8,3.8770e+01_r8,3.9082e+01_r8/)
      kbo(:,41,13) = (/ &
     &3.3505e+01_r8,3.3696e+01_r8,3.3809e+01_r8,3.4139e+01_r8,3.4534e+01_r8/)
      kbo(:,42,13) = (/ &
     &2.9251e+01_r8,2.9507e+01_r8,2.9744e+01_r8,3.0106e+01_r8,3.0543e+01_r8/)
      kbo(:,43,13) = (/ &
     &2.5517e+01_r8,2.5852e+01_r8,2.6152e+01_r8,2.6566e+01_r8,2.7067e+01_r8/)
      kbo(:,44,13) = (/ &
     &2.2216e+01_r8,2.2648e+01_r8,2.3006e+01_r8,2.3424e+01_r8,2.3903e+01_r8/)
      kbo(:,45,13) = (/ &
     &1.9313e+01_r8,1.9753e+01_r8,2.0163e+01_r8,2.0601e+01_r8,2.1122e+01_r8/)
      kbo(:,46,13) = (/ &
     &1.6765e+01_r8,1.7207e+01_r8,1.7660e+01_r8,1.8173e+01_r8,1.8710e+01_r8/)
      kbo(:,47,13) = (/ &
     &1.4512e+01_r8,1.4984e+01_r8,1.5402e+01_r8,1.5957e+01_r8,1.6479e+01_r8/)
      kbo(:,48,13) = (/ &
     &1.2486e+01_r8,1.2967e+01_r8,1.3459e+01_r8,1.3983e+01_r8,1.4524e+01_r8/)
      kbo(:,49,13) = (/ &
     &1.0733e+01_r8,1.1206e+01_r8,1.1665e+01_r8,1.2207e+01_r8,1.2773e+01_r8/)
      kbo(:,50,13) = (/ &
     &9.2157e+00_r8,9.6749e+00_r8,1.0151e+01_r8,1.0704e+01_r8,1.1247e+01_r8/)
      kbo(:,51,13) = (/ &
     &7.9591e+00_r8,8.3907e+00_r8,8.8535e+00_r8,9.3811e+00_r8,9.9247e+00_r8/)
      kbo(:,52,13) = (/ &
     &6.8068e+00_r8,7.2371e+00_r8,7.6934e+00_r8,8.2063e+00_r8,8.7553e+00_r8/)
      kbo(:,53,13) = (/ &
     &5.7967e+00_r8,6.2085e+00_r8,6.6421e+00_r8,7.1263e+00_r8,7.6815e+00_r8/)
      kbo(:,54,13) = (/ &
     &4.9653e+00_r8,5.3639e+00_r8,5.8069e+00_r8,6.2889e+00_r8,6.8002e+00_r8/)
      kbo(:,55,13) = (/ &
     &4.2889e+00_r8,4.6915e+00_r8,5.1242e+00_r8,5.6024e+00_r8,6.0981e+00_r8/)
      kbo(:,56,13) = (/ &
     &3.6900e+00_r8,4.0833e+00_r8,4.5086e+00_r8,4.9809e+00_r8,5.4831e+00_r8/)
      kbo(:,57,13) = (/ &
     &3.1898e+00_r8,3.5703e+00_r8,3.9801e+00_r8,4.4470e+00_r8,4.9431e+00_r8/)
      kbo(:,58,13) = (/ &
     &2.7316e+00_r8,3.0989e+00_r8,3.5187e+00_r8,3.9710e+00_r8,4.4675e+00_r8/)
      kbo(:,59,13) = (/ &
     &2.4661e+00_r8,2.8142e+00_r8,3.2518e+00_r8,3.7206e+00_r8,4.2604e+00_r8/)
      kbo(:,13,14) = (/ &
     &2.3516e+03_r8,2.3425e+03_r8,2.3393e+03_r8,2.3344e+03_r8,2.3274e+03_r8/)
      kbo(:,14,14) = (/ &
     &2.4560e+03_r8,2.4460e+03_r8,2.4416e+03_r8,2.4361e+03_r8,2.4328e+03_r8/)
      kbo(:,15,14) = (/ &
     &2.5504e+03_r8,2.5434e+03_r8,2.5388e+03_r8,2.5327e+03_r8,2.5248e+03_r8/)
      kbo(:,16,14) = (/ &
     &2.6346e+03_r8,2.6312e+03_r8,2.6203e+03_r8,2.6088e+03_r8,2.5971e+03_r8/)
      kbo(:,17,14) = (/ &
     &2.7008e+03_r8,2.6935e+03_r8,2.6794e+03_r8,2.6636e+03_r8,2.6477e+03_r8/)
      kbo(:,18,14) = (/ &
     &2.7305e+03_r8,2.7239e+03_r8,2.7111e+03_r8,2.6981e+03_r8,2.6813e+03_r8/)
      kbo(:,19,14) = (/ &
     &2.7180e+03_r8,2.7110e+03_r8,2.7049e+03_r8,2.6968e+03_r8,2.6814e+03_r8/)
      kbo(:,20,14) = (/ &
     &2.6672e+03_r8,2.6665e+03_r8,2.6675e+03_r8,2.6606e+03_r8,2.6429e+03_r8/)
      kbo(:,21,14) = (/ &
     &2.5815e+03_r8,2.5893e+03_r8,2.5905e+03_r8,2.5819e+03_r8,2.5661e+03_r8/)
      kbo(:,22,14) = (/ &
     &2.4673e+03_r8,2.4773e+03_r8,2.4773e+03_r8,2.4699e+03_r8,2.4562e+03_r8/)
      kbo(:,23,14) = (/ &
     &2.3326e+03_r8,2.3404e+03_r8,2.3409e+03_r8,2.3341e+03_r8,2.3220e+03_r8/)
      kbo(:,24,14) = (/ &
     &2.1770e+03_r8,2.1831e+03_r8,2.1839e+03_r8,2.1779e+03_r8,2.1650e+03_r8/)
      kbo(:,25,14) = (/ &
     &2.0113e+03_r8,2.0166e+03_r8,2.0154e+03_r8,2.0063e+03_r8,1.9910e+03_r8/)
      kbo(:,26,14) = (/ &
     &1.8365e+03_r8,1.8415e+03_r8,1.8363e+03_r8,1.8253e+03_r8,1.8117e+03_r8/)
      kbo(:,27,14) = (/ &
     &1.6595e+03_r8,1.6581e+03_r8,1.6515e+03_r8,1.6428e+03_r8,1.6322e+03_r8/)
      kbo(:,28,14) = (/ &
     &1.4809e+03_r8,1.4771e+03_r8,1.4724e+03_r8,1.4658e+03_r8,1.4569e+03_r8/)
      kbo(:,29,14) = (/ &
     &1.3089e+03_r8,1.3068e+03_r8,1.3044e+03_r8,1.2991e+03_r8,1.2930e+03_r8/)
      kbo(:,30,14) = (/ &
     &1.1460e+03_r8,1.1478e+03_r8,1.1472e+03_r8,1.1450e+03_r8,1.1415e+03_r8/)
      kbo(:,31,14) = (/ &
     &9.9693e+02_r8,1.0002e+03_r8,1.0008e+03_r8,1.0017e+03_r8,1.0008e+03_r8/)
      kbo(:,32,14) = (/ &
     &8.6070e+02_r8,8.6544e+02_r8,8.6833e+02_r8,8.7044e+02_r8,8.7331e+02_r8/)
      kbo(:,33,14) = (/ &
     &7.4260e+02_r8,7.4642e+02_r8,7.5058e+02_r8,7.5528e+02_r8,7.5991e+02_r8/)
      kbo(:,34,14) = (/ &
     &6.3829e+02_r8,6.4348e+02_r8,6.4940e+02_r8,6.5551e+02_r8,6.6078e+02_r8/)
      kbo(:,35,14) = (/ &
     &5.4846e+02_r8,5.5540e+02_r8,5.6285e+02_r8,5.6932e+02_r8,5.7603e+02_r8/)
      kbo(:,36,14) = (/ &
     &4.7198e+02_r8,4.7993e+02_r8,4.8784e+02_r8,4.9478e+02_r8,5.0307e+02_r8/)
      kbo(:,37,14) = (/ &
     &4.0498e+02_r8,4.1318e+02_r8,4.2147e+02_r8,4.2948e+02_r8,4.3820e+02_r8/)
      kbo(:,38,14) = (/ &
     &3.4831e+02_r8,3.5680e+02_r8,3.6471e+02_r8,3.7305e+02_r8,3.8282e+02_r8/)
      kbo(:,39,14) = (/ &
     &3.0154e+02_r8,3.0929e+02_r8,3.1734e+02_r8,3.2632e+02_r8,3.3596e+02_r8/)
      kbo(:,40,14) = (/ &
     &2.6084e+02_r8,2.6836e+02_r8,2.7578e+02_r8,2.8455e+02_r8,2.9457e+02_r8/)
      kbo(:,41,14) = (/ &
     &2.2737e+02_r8,2.3379e+02_r8,2.4131e+02_r8,2.4917e+02_r8,2.5928e+02_r8/)
      kbo(:,42,14) = (/ &
     &1.9807e+02_r8,2.0493e+02_r8,2.1238e+02_r8,2.2005e+02_r8,2.2904e+02_r8/)
      kbo(:,43,14) = (/ &
     &1.7261e+02_r8,1.7936e+02_r8,1.8667e+02_r8,1.9473e+02_r8,2.0355e+02_r8/)
      kbo(:,44,14) = (/ &
     &1.5104e+02_r8,1.5759e+02_r8,1.6444e+02_r8,1.7229e+02_r8,1.8143e+02_r8/)
      kbo(:,45,14) = (/ &
     &1.3320e+02_r8,1.3908e+02_r8,1.4536e+02_r8,1.5288e+02_r8,1.6210e+02_r8/)
      kbo(:,46,14) = (/ &
     &1.1788e+02_r8,1.2339e+02_r8,1.2957e+02_r8,1.3630e+02_r8,1.4477e+02_r8/)
      kbo(:,47,14) = (/ &
     &1.0441e+02_r8,1.0994e+02_r8,1.1542e+02_r8,1.2186e+02_r8,1.2998e+02_r8/)
      kbo(:,48,14) = (/ &
     &9.2989e+01_r8,9.8393e+01_r8,1.0367e+02_r8,1.0970e+02_r8,1.1684e+02_r8/)
      kbo(:,49,14) = (/ &
     &8.3245e+01_r8,8.8109e+01_r8,9.3736e+01_r8,9.8882e+01_r8,1.0570e+02_r8/)
      kbo(:,50,14) = (/ &
     &7.4420e+01_r8,7.9603e+01_r8,8.4592e+01_r8,9.0187e+01_r8,9.6226e+01_r8/)
      kbo(:,51,14) = (/ &
     &6.6553e+01_r8,7.2000e+01_r8,7.7144e+01_r8,8.2193e+01_r8,8.8503e+01_r8/)
      kbo(:,52,14) = (/ &
     &5.9519e+01_r8,6.4793e+01_r8,7.0321e+01_r8,7.5806e+01_r8,8.1580e+01_r8/)
      kbo(:,53,14) = (/ &
     &5.3233e+01_r8,5.8402e+01_r8,6.4217e+01_r8,6.9900e+01_r8,7.5580e+01_r8/)
      kbo(:,54,14) = (/ &
     &4.7589e+01_r8,5.2923e+01_r8,5.8451e+01_r8,6.4196e+01_r8,7.0322e+01_r8/)
      kbo(:,55,14) = (/ &
     &4.2742e+01_r8,4.7820e+01_r8,5.3445e+01_r8,5.9447e+01_r8,6.5405e+01_r8/)
      kbo(:,56,14) = (/ &
     &3.8175e+01_r8,4.3483e+01_r8,4.9069e+01_r8,5.5046e+01_r8,6.1266e+01_r8/)
      kbo(:,57,14) = (/ &
     &3.4510e+01_r8,3.9326e+01_r8,4.4806e+01_r8,5.1166e+01_r8,5.7169e+01_r8/)
      kbo(:,58,14) = (/ &
     &3.1419e+01_r8,3.6120e+01_r8,4.1281e+01_r8,4.7436e+01_r8,5.4030e+01_r8/)
      kbo(:,59,14) = (/ &
     &3.0087e+01_r8,3.4624e+01_r8,3.9514e+01_r8,4.5129e+01_r8,5.1873e+01_r8/)
      kbo(:,13,15) = (/ &
     &5.1911e+03_r8,5.1717e+03_r8,5.1553e+03_r8,5.1395e+03_r8,5.1397e+03_r8/)
      kbo(:,14,15) = (/ &
     &5.8547e+03_r8,5.8285e+03_r8,5.7963e+03_r8,5.7766e+03_r8,5.7715e+03_r8/)
      kbo(:,15,15) = (/ &
     &6.5298e+03_r8,6.4858e+03_r8,6.4506e+03_r8,6.4312e+03_r8,6.4243e+03_r8/)
      kbo(:,16,15) = (/ &
     &7.2117e+03_r8,7.1510e+03_r8,7.1189e+03_r8,7.1000e+03_r8,7.0870e+03_r8/)
      kbo(:,17,15) = (/ &
     &7.8953e+03_r8,7.8291e+03_r8,7.7890e+03_r8,7.7670e+03_r8,7.7489e+03_r8/)
      kbo(:,18,15) = (/ &
     &8.5855e+03_r8,8.5208e+03_r8,8.4668e+03_r8,8.4206e+03_r8,8.3980e+03_r8/)
      kbo(:,19,15) = (/ &
     &9.2674e+03_r8,9.2049e+03_r8,9.1326e+03_r8,9.0736e+03_r8,9.0525e+03_r8/)
      kbo(:,20,15) = (/ &
     &9.9108e+03_r8,9.8356e+03_r8,9.7636e+03_r8,9.7141e+03_r8,9.6905e+03_r8/)
      kbo(:,21,15) = (/ &
     &1.0486e+04_r8,1.0415e+04_r8,1.0355e+04_r8,1.0317e+04_r8,1.0287e+04_r8/)
      kbo(:,22,15) = (/ &
     &1.0985e+04_r8,1.0920e+04_r8,1.0875e+04_r8,1.0845e+04_r8,1.0804e+04_r8/)
      kbo(:,23,15) = (/ &
     &1.1398e+04_r8,1.1342e+04_r8,1.1308e+04_r8,1.1276e+04_r8,1.1234e+04_r8/)
      kbo(:,24,15) = (/ &
     &1.1709e+04_r8,1.1672e+04_r8,1.1645e+04_r8,1.1614e+04_r8,1.1576e+04_r8/)
      kbo(:,25,15) = (/ &
     &1.1914e+04_r8,1.1896e+04_r8,1.1878e+04_r8,1.1862e+04_r8,1.1837e+04_r8/)
      kbo(:,26,15) = (/ &
     &1.2040e+04_r8,1.2031e+04_r8,1.2029e+04_r8,1.2020e+04_r8,1.1998e+04_r8/)
      kbo(:,27,15) = (/ &
     &1.2071e+04_r8,1.2081e+04_r8,1.2089e+04_r8,1.2085e+04_r8,1.2069e+04_r8/)
      kbo(:,28,15) = (/ &
     &1.2021e+04_r8,1.2058e+04_r8,1.2068e+04_r8,1.2068e+04_r8,1.2073e+04_r8/)
      kbo(:,29,15) = (/ &
     &1.1886e+04_r8,1.1940e+04_r8,1.1970e+04_r8,1.1995e+04_r8,1.2017e+04_r8/)
      kbo(:,30,15) = (/ &
     &1.1676e+04_r8,1.1749e+04_r8,1.1808e+04_r8,1.1861e+04_r8,1.1908e+04_r8/)
      kbo(:,31,15) = (/ &
     &1.1416e+04_r8,1.1515e+04_r8,1.1609e+04_r8,1.1694e+04_r8,1.1764e+04_r8/)
      kbo(:,32,15) = (/ &
     &1.1108e+04_r8,1.1250e+04_r8,1.1385e+04_r8,1.1503e+04_r8,1.1598e+04_r8/)
      kbo(:,33,15) = (/ &
     &1.0773e+04_r8,1.0963e+04_r8,1.1141e+04_r8,1.1294e+04_r8,1.1425e+04_r8/)
      kbo(:,34,15) = (/ &
     &1.0438e+04_r8,1.0673e+04_r8,1.0885e+04_r8,1.1077e+04_r8,1.1249e+04_r8/)
      kbo(:,35,15) = (/ &
     &1.0089e+04_r8,1.0368e+04_r8,1.0621e+04_r8,1.0852e+04_r8,1.1064e+04_r8/)
      kbo(:,36,15) = (/ &
     &9.7201e+03_r8,1.0041e+04_r8,1.0341e+04_r8,1.0614e+04_r8,1.0861e+04_r8/)
      kbo(:,37,15) = (/ &
     &9.3163e+03_r8,9.6805e+03_r8,1.0024e+04_r8,1.0342e+04_r8,1.0632e+04_r8/)
      kbo(:,38,15) = (/ &
     &8.9272e+03_r8,9.3307e+03_r8,9.7169e+03_r8,1.0074e+04_r8,1.0402e+04_r8/)
      kbo(:,39,15) = (/ &
     &8.5526e+03_r8,8.9993e+03_r8,9.4206e+03_r8,9.8154e+03_r8,1.0180e+04_r8/)
      kbo(:,40,15) = (/ &
     &8.1494e+03_r8,8.6355e+03_r8,9.0962e+03_r8,9.5285e+03_r8,9.9305e+03_r8/)
      kbo(:,41,15) = (/ &
     &7.7529e+03_r8,8.2788e+03_r8,8.7766e+03_r8,9.2446e+03_r8,9.6773e+03_r8/)
      kbo(:,42,15) = (/ &
     &7.3760e+03_r8,7.9339e+03_r8,8.4681e+03_r8,8.9681e+03_r8,9.4340e+03_r8/)
      kbo(:,43,15) = (/ &
     &6.9819e+03_r8,7.5721e+03_r8,8.1409e+03_r8,8.6746e+03_r8,9.1691e+03_r8/)
      kbo(:,44,15) = (/ &
     &6.5827e+03_r8,7.2081e+03_r8,7.8084e+03_r8,8.3740e+03_r8,8.8982e+03_r8/)
      kbo(:,45,15) = (/ &
     &6.1901e+03_r8,6.8485e+03_r8,7.4795e+03_r8,8.0786e+03_r8,8.6303e+03_r8/)
      kbo(:,46,15) = (/ &
     &5.8024e+03_r8,6.4801e+03_r8,7.1413e+03_r8,7.7702e+03_r8,8.3548e+03_r8/)
      kbo(:,47,15) = (/ &
     &5.3938e+03_r8,6.0870e+03_r8,6.7778e+03_r8,7.4341e+03_r8,8.0495e+03_r8/)
      kbo(:,48,15) = (/ &
     &5.0092e+03_r8,5.7052e+03_r8,6.4111e+03_r8,7.0962e+03_r8,7.7409e+03_r8/)
      kbo(:,49,15) = (/ &
     &4.6045e+03_r8,5.3446e+03_r8,6.0469e+03_r8,6.7562e+03_r8,7.4302e+03_r8/)
      kbo(:,50,15) = (/ &
     &4.2414e+03_r8,4.9940e+03_r8,5.7177e+03_r8,6.4318e+03_r8,7.1308e+03_r8/)
      kbo(:,51,15) = (/ &
     &3.9058e+03_r8,4.6435e+03_r8,5.4144e+03_r8,6.1320e+03_r8,6.8340e+03_r8/)
      kbo(:,52,15) = (/ &
     &3.5828e+03_r8,4.3242e+03_r8,5.0835e+03_r8,5.8308e+03_r8,6.5455e+03_r8/)
      kbo(:,53,15) = (/ &
     &3.2733e+03_r8,3.9950e+03_r8,4.7590e+03_r8,5.5300e+03_r8,6.2613e+03_r8/)
      kbo(:,54,15) = (/ &
     &2.9973e+03_r8,3.7033e+03_r8,4.4798e+03_r8,5.2468e+03_r8,6.0054e+03_r8/)
      kbo(:,55,15) = (/ &
     &2.7347e+03_r8,3.4529e+03_r8,4.2020e+03_r8,4.9932e+03_r8,5.7360e+03_r8/)
      kbo(:,56,15) = (/ &
     &2.4953e+03_r8,3.1956e+03_r8,3.9366e+03_r8,4.7176e+03_r8,5.4818e+03_r8/)
      kbo(:,57,15) = (/ &
     &2.2617e+03_r8,2.9413e+03_r8,3.6881e+03_r8,4.4499e+03_r8,5.2349e+03_r8/)
      kbo(:,58,15) = (/ &
     &2.0370e+03_r8,2.7148e+03_r8,3.4460e+03_r8,4.2224e+03_r8,4.9906e+03_r8/)
      kbo(:,59,15) = (/ &
     &1.9478e+03_r8,2.6130e+03_r8,3.3529e+03_r8,4.1205e+03_r8,4.8990e+03_r8/)
      kbo(:,13,16) = (/ &
     &1.0699e+04_r8,1.0668e+04_r8,1.0580e+04_r8,1.0493e+04_r8,1.0473e+04_r8/)
      kbo(:,14,16) = (/ &
     &1.2469e+04_r8,1.2443e+04_r8,1.2338e+04_r8,1.2279e+04_r8,1.2260e+04_r8/)
      kbo(:,15,16) = (/ &
     &1.4513e+04_r8,1.4466e+04_r8,1.4361e+04_r8,1.4360e+04_r8,1.4376e+04_r8/)
      kbo(:,16,16) = (/ &
     &1.6769e+04_r8,1.6706e+04_r8,1.6727e+04_r8,1.6775e+04_r8,1.6795e+04_r8/)
      kbo(:,17,16) = (/ &
     &1.9233e+04_r8,1.9285e+04_r8,1.9387e+04_r8,1.9445e+04_r8,1.9443e+04_r8/)
      kbo(:,18,16) = (/ &
     &2.2082e+04_r8,2.2141e+04_r8,2.2296e+04_r8,2.2362e+04_r8,2.2373e+04_r8/)
      kbo(:,19,16) = (/ &
     &2.5392e+04_r8,2.5419e+04_r8,2.5533e+04_r8,2.5623e+04_r8,2.5622e+04_r8/)
      kbo(:,20,16) = (/ &
     &2.9227e+04_r8,2.9228e+04_r8,2.9232e+04_r8,2.9272e+04_r8,2.9286e+04_r8/)
      kbo(:,21,16) = (/ &
     &3.3689e+04_r8,3.3556e+04_r8,3.3511e+04_r8,3.3436e+04_r8,3.3399e+04_r8/)
      kbo(:,22,16) = (/ &
     &3.8640e+04_r8,3.8494e+04_r8,3.8304e+04_r8,3.8118e+04_r8,3.8006e+04_r8/)
      kbo(:,23,16) = (/ &
     &4.4135e+04_r8,4.3894e+04_r8,4.3600e+04_r8,4.3191e+04_r8,4.3063e+04_r8/)
      kbo(:,24,16) = (/ &
     &5.0120e+04_r8,4.9723e+04_r8,4.9276e+04_r8,4.8847e+04_r8,4.8550e+04_r8/)
      kbo(:,25,16) = (/ &
     &5.6400e+04_r8,5.5824e+04_r8,5.5260e+04_r8,5.4753e+04_r8,5.4318e+04_r8/)
      kbo(:,26,16) = (/ &
     &6.2742e+04_r8,6.2101e+04_r8,6.1449e+04_r8,6.0838e+04_r8,6.0246e+04_r8/)
      kbo(:,27,16) = (/ &
     &6.9256e+04_r8,6.8498e+04_r8,6.7755e+04_r8,6.7035e+04_r8,6.6255e+04_r8/)
      kbo(:,28,16) = (/ &
     &7.5845e+04_r8,7.4890e+04_r8,7.4038e+04_r8,7.3125e+04_r8,7.2119e+04_r8/)
      kbo(:,29,16) = (/ &
     &8.2416e+04_r8,8.1292e+04_r8,8.0172e+04_r8,7.8988e+04_r8,7.7733e+04_r8/)
      kbo(:,30,16) = (/ &
     &8.8923e+04_r8,8.7524e+04_r8,8.6114e+04_r8,8.4633e+04_r8,8.3083e+04_r8/)
      kbo(:,31,16) = (/ &
     &9.5128e+04_r8,9.3474e+04_r8,9.1409e+04_r8,8.9609e+04_r8,8.8121e+04_r8/)
      kbo(:,32,16) = (/ &
     &1.0109e+05_r8,9.9056e+04_r8,9.6959e+04_r8,9.4838e+04_r8,9.2728e+04_r8/)
      kbo(:,33,16) = (/ &
     &1.0668e+05_r8,1.0426e+05_r8,1.0177e+05_r8,9.9309e+04_r8,9.6864e+04_r8/)
      kbo(:,34,16) = (/ &
     &1.1181e+05_r8,1.0901e+05_r8,1.0619e+05_r8,1.0339e+05_r8,1.0062e+05_r8/)
      kbo(:,35,16) = (/ &
     &1.1669e+05_r8,1.1352e+05_r8,1.1036e+05_r8,1.0724e+05_r8,1.0414e+05_r8/)
      kbo(:,36,16) = (/ &
     &1.2143e+05_r8,1.1741e+05_r8,1.1444e+05_r8,1.1099e+05_r8,1.0759e+05_r8/)
      kbo(:,37,16) = (/ &
     &1.2629e+05_r8,1.2248e+05_r8,1.1868e+05_r8,1.1492e+05_r8,1.1120e+05_r8/)
      kbo(:,38,16) = (/ &
     &1.3077e+05_r8,1.2669e+05_r8,1.2260e+05_r8,1.1857e+05_r8,1.1458e+05_r8/)
      kbo(:,39,16) = (/ &
     &1.3413e+05_r8,1.3013e+05_r8,1.2620e+05_r8,1.2191e+05_r8,1.1768e+05_r8/)
      kbo(:,40,16) = (/ &
     &1.3905e+05_r8,1.3448e+05_r8,1.2993e+05_r8,1.2540e+05_r8,1.2095e+05_r8/)
      kbo(:,41,16) = (/ &
     &1.4302e+05_r8,1.3822e+05_r8,1.3346e+05_r8,1.2873e+05_r8,1.2407e+05_r8/)
      kbo(:,42,16) = (/ &
     &1.4675e+05_r8,1.4173e+05_r8,1.3673e+05_r8,1.3182e+05_r8,1.2698e+05_r8/)
      kbo(:,43,16) = (/ &
     &1.5047e+05_r8,1.4528e+05_r8,1.4010e+05_r8,1.3500e+05_r8,1.2941e+05_r8/)
      kbo(:,44,16) = (/ &
     &1.5413e+05_r8,1.4878e+05_r8,1.4344e+05_r8,1.3816e+05_r8,1.3300e+05_r8/)
      kbo(:,45,16) = (/ &
     &1.5764e+05_r8,1.5214e+05_r8,1.4665e+05_r8,1.4055e+05_r8,1.3586e+05_r8/)
      kbo(:,46,16) = (/ &
     &1.6104e+05_r8,1.5546e+05_r8,1.4981e+05_r8,1.4422e+05_r8,1.3874e+05_r8/)
      kbo(:,47,16) = (/ &
     &1.6453e+05_r8,1.5891e+05_r8,1.5314e+05_r8,1.4742e+05_r8,1.4180e+05_r8/)
      kbo(:,48,16) = (/ &
     &1.6775e+05_r8,1.6219e+05_r8,1.5640e+05_r8,1.5054e+05_r8,1.4481e+05_r8/)
      kbo(:,49,16) = (/ &
     &1.7104e+05_r8,1.6528e+05_r8,1.5957e+05_r8,1.5363e+05_r8,1.4773e+05_r8/)
      kbo(:,50,16) = (/ &
     &1.7401e+05_r8,1.6818e+05_r8,1.6240e+05_r8,1.5648e+05_r8,1.5051e+05_r8/)
      kbo(:,51,16) = (/ &
     &1.7667e+05_r8,1.7104e+05_r8,1.6499e+05_r8,1.5912e+05_r8,1.5318e+05_r8/)
      kbo(:,52,16) = (/ &
     &1.7922e+05_r8,1.7356e+05_r8,1.6772e+05_r8,1.6169e+05_r8,1.5572e+05_r8/)
      kbo(:,53,16) = (/ &
     &1.8153e+05_r8,1.7622e+05_r8,1.7035e+05_r8,1.6422e+05_r8,1.5819e+05_r8/)
      kbo(:,54,16) = (/ &
     &1.8363e+05_r8,1.7848e+05_r8,1.7259e+05_r8,1.6657e+05_r8,1.6042e+05_r8/)
      kbo(:,55,16) = (/ &
     &1.8551e+05_r8,1.8043e+05_r8,1.7479e+05_r8,1.6867e+05_r8,1.6267e+05_r8/)
      kbo(:,56,16) = (/ &
     &1.8723e+05_r8,1.8233e+05_r8,1.7687e+05_r8,1.7089e+05_r8,1.6480e+05_r8/)
      kbo(:,57,16) = (/ &
     &1.8886e+05_r8,1.8420e+05_r8,1.7883e+05_r8,1.7299e+05_r8,1.6681e+05_r8/)
      kbo(:,58,16) = (/ &
     &1.9037e+05_r8,1.8581e+05_r8,1.8067e+05_r8,1.7477e+05_r8,1.6881e+05_r8/)
      kbo(:,59,16) = (/ &
     &1.9100e+05_r8,1.8659e+05_r8,1.8132e+05_r8,1.7562e+05_r8,1.6956e+05_r8/)

      kao_mn2(:, 1) = (/ &
     & 5.12042e-08_r8, 5.51239e-08_r8, 5.93436e-08_r8, 6.38863e-08_r8, 6.87767e-08_r8, &
     & 7.40415e-08_r8, 7.97093e-08_r8, 8.58110e-08_r8, 9.23797e-08_r8, 9.94513e-08_r8, &
     & 1.07064e-07_r8, 1.15260e-07_r8, 1.24083e-07_r8, 1.33581e-07_r8, 1.43807e-07_r8, &
     & 1.54815e-07_r8, 1.66666e-07_r8, 1.79424e-07_r8, 1.93159e-07_r8/)
      kao_mn2(:, 2) = (/ &
     & 2.30938e-07_r8, 2.41696e-07_r8, 2.52955e-07_r8, 2.64738e-07_r8, 2.77071e-07_r8, &
     & 2.89978e-07_r8, 3.03486e-07_r8, 3.17623e-07_r8, 3.32419e-07_r8, 3.47904e-07_r8, &
     & 3.64111e-07_r8, 3.81072e-07_r8, 3.98824e-07_r8, 4.17402e-07_r8, 4.36846e-07_r8, &
     & 4.57196e-07_r8, 4.78494e-07_r8, 5.00784e-07_r8, 5.24112e-07_r8/)
      kao_mn2(:, 3) = (/ &
     & 6.70458e-07_r8, 7.04274e-07_r8, 7.39795e-07_r8, 7.77109e-07_r8, 8.16304e-07_r8, &
     & 8.57476e-07_r8, 9.00724e-07_r8, 9.46154e-07_r8, 9.93876e-07_r8, 1.04400e-06_r8, &
     & 1.09666e-06_r8, 1.15197e-06_r8, 1.21008e-06_r8, 1.27111e-06_r8, 1.33522e-06_r8, &
     & 1.40256e-06_r8, 1.47331e-06_r8, 1.54761e-06_r8, 1.62567e-06_r8/)
      kao_mn2(:, 4) = (/ &
     & 1.84182e-06_r8, 1.89203e-06_r8, 1.94360e-06_r8, 1.99658e-06_r8, 2.05101e-06_r8, &
     & 2.10692e-06_r8, 2.16435e-06_r8, 2.22335e-06_r8, 2.28396e-06_r8, 2.34622e-06_r8, &
     & 2.41017e-06_r8, 2.47587e-06_r8, 2.54337e-06_r8, 2.61270e-06_r8, 2.68392e-06_r8, &
     & 2.75708e-06_r8, 2.83224e-06_r8, 2.90944e-06_r8, 2.98875e-06_r8/)
      kao_mn2(:, 5) = (/ &
     & 3.41996e-06_r8, 3.32758e-06_r8, 3.23770e-06_r8, 3.15024e-06_r8, 3.06515e-06_r8, &
     & 2.98235e-06_r8, 2.90180e-06_r8, 2.82341e-06_r8, 2.74715e-06_r8, 2.67294e-06_r8, &
     & 2.60074e-06_r8, 2.53049e-06_r8, 2.46214e-06_r8, 2.39563e-06_r8, 2.33092e-06_r8, &
     & 2.26796e-06_r8, 2.20670e-06_r8, 2.14709e-06_r8, 2.08910e-06_r8/)
      kao_mn2(:, 6) = (/ &
     & 3.38746e-06_r8, 3.25966e-06_r8, 3.13669e-06_r8, 3.01836e-06_r8, 2.90449e-06_r8, &
     & 2.79491e-06_r8, 2.68947e-06_r8, 2.58801e-06_r8, 2.49037e-06_r8, 2.39642e-06_r8, &
     & 2.30601e-06_r8, 2.21902e-06_r8, 2.13530e-06_r8, 2.05475e-06_r8, 1.97723e-06_r8, &
     & 1.90264e-06_r8, 1.83086e-06_r8, 1.76179e-06_r8, 1.69532e-06_r8/)
      kao_mn2(:, 7) = (/ &
     & 3.17530e-06_r8, 3.07196e-06_r8, 2.97199e-06_r8, 2.87527e-06_r8, 2.78170e-06_r8, &
     & 2.69118e-06_r8, 2.60360e-06_r8, 2.51887e-06_r8, 2.43690e-06_r8, 2.35759e-06_r8, &
     & 2.28087e-06_r8, 2.20664e-06_r8, 2.13483e-06_r8, 2.06536e-06_r8, 1.99814e-06_r8, &
     & 1.93312e-06_r8, 1.87021e-06_r8, 1.80934e-06_r8, 1.75046e-06_r8/)
      kao_mn2(:, 8) = (/ &
     & 2.84701e-06_r8, 2.77007e-06_r8, 2.69521e-06_r8, 2.62237e-06_r8, 2.55150e-06_r8, &
     & 2.48254e-06_r8, 2.41545e-06_r8, 2.35017e-06_r8, 2.28666e-06_r8, 2.22486e-06_r8, &
     & 2.16473e-06_r8, 2.10623e-06_r8, 2.04930e-06_r8, 1.99392e-06_r8, 1.94003e-06_r8, &
     & 1.88760e-06_r8, 1.83659e-06_r8, 1.78695e-06_r8, 1.73866e-06_r8/)
      kao_mn2(:, 9) = (/ &
     & 2.79917e-06_r8, 2.73207e-06_r8, 2.66658e-06_r8, 2.60266e-06_r8, 2.54027e-06_r8, &
     & 2.47937e-06_r8, 2.41994e-06_r8, 2.36192e-06_r8, 2.30530e-06_r8, 2.25004e-06_r8, &
     & 2.19610e-06_r8, 2.14346e-06_r8, 2.09208e-06_r8, 2.04193e-06_r8, 1.99298e-06_r8, &
     & 1.94520e-06_r8, 1.89857e-06_r8, 1.85306e-06_r8, 1.80864e-06_r8/)
      kao_mn2(:,10) = (/ &
     & 2.74910e-06_r8, 2.64462e-06_r8, 2.54412e-06_r8, 2.44743e-06_r8, 2.35442e-06_r8, &
     & 2.26495e-06_r8, 2.17887e-06_r8, 2.09606e-06_r8, 2.01641e-06_r8, 1.93978e-06_r8, &
     & 1.86606e-06_r8, 1.79514e-06_r8, 1.72692e-06_r8, 1.66129e-06_r8, 1.59815e-06_r8, &
     & 1.53742e-06_r8, 1.47899e-06_r8, 1.42278e-06_r8, 1.36871e-06_r8/)
      kao_mn2(:,11) = (/ &
     & 2.63952e-06_r8, 2.60263e-06_r8, 2.56626e-06_r8, 2.53039e-06_r8, 2.49503e-06_r8, &
     & 2.46016e-06_r8, 2.42578e-06_r8, 2.39188e-06_r8, 2.35845e-06_r8, 2.32549e-06_r8, &
     & 2.29299e-06_r8, 2.26094e-06_r8, 2.22934e-06_r8, 2.19819e-06_r8, 2.16747e-06_r8, &
     & 2.13717e-06_r8, 2.10731e-06_r8, 2.07786e-06_r8, 2.04882e-06_r8/)
      kao_mn2(:,12) = (/ &
     & 2.94106e-06_r8, 2.82819e-06_r8, 2.71966e-06_r8, 2.61528e-06_r8, 2.51492e-06_r8, &
     & 2.41841e-06_r8, 2.32560e-06_r8, 2.23635e-06_r8, 2.15053e-06_r8, 2.06800e-06_r8, &
     & 1.98863e-06_r8, 1.91232e-06_r8, 1.83893e-06_r8, 1.76836e-06_r8, 1.70049e-06_r8, &
     & 1.63524e-06_r8, 1.57248e-06_r8, 1.51214e-06_r8, 1.45411e-06_r8/)
      kao_mn2(:,13) = (/ &
     & 2.94607e-06_r8, 2.87369e-06_r8, 2.80309e-06_r8, 2.73422e-06_r8, 2.66705e-06_r8, &
     & 2.60152e-06_r8, 2.53760e-06_r8, 2.47526e-06_r8, 2.41445e-06_r8, 2.35513e-06_r8, &
     & 2.29726e-06_r8, 2.24082e-06_r8, 2.18577e-06_r8, 2.13207e-06_r8, 2.07969e-06_r8, &
     & 2.02859e-06_r8, 1.97875e-06_r8, 1.93014e-06_r8, 1.88272e-06_r8/)
      kao_mn2(:,14) = (/ &
     & 2.58051e-06_r8, 2.48749e-06_r8, 2.39782e-06_r8, 2.31139e-06_r8, 2.22807e-06_r8, &
     & 2.14775e-06_r8, 2.07033e-06_r8, 1.99570e-06_r8, 1.92376e-06_r8, 1.85441e-06_r8, &
     & 1.78756e-06_r8, 1.72313e-06_r8, 1.66101e-06_r8, 1.60114e-06_r8, 1.54342e-06_r8, &
     & 1.48778e-06_r8, 1.43415e-06_r8, 1.38245e-06_r8, 1.33262e-06_r8/)
      kao_mn2(:,15) = (/ &
     & 3.03447e-06_r8, 2.88559e-06_r8, 2.74401e-06_r8, 2.60938e-06_r8, 2.48135e-06_r8, &
     & 2.35961e-06_r8, 2.24384e-06_r8, 2.13375e-06_r8, 2.02906e-06_r8, 1.92951e-06_r8, &
     & 1.83484e-06_r8, 1.74481e-06_r8, 1.65921e-06_r8, 1.57780e-06_r8, 1.50039e-06_r8, &
     & 1.42677e-06_r8, 1.35677e-06_r8, 1.29020e-06_r8, 1.22690e-06_r8/)
      kao_mn2(:,16) = (/ &
     & 1.48655e-06_r8, 1.48283e-06_r8, 1.47913e-06_r8, 1.47543e-06_r8, 1.47174e-06_r8, &
     & 1.46806e-06_r8, 1.46439e-06_r8, 1.46072e-06_r8, 1.45707e-06_r8, 1.45343e-06_r8, &
     & 1.44979e-06_r8, 1.44617e-06_r8, 1.44255e-06_r8, 1.43894e-06_r8, 1.43534e-06_r8, &
     & 1.43176e-06_r8, 1.42817e-06_r8, 1.42460e-06_r8, 1.42104e-06_r8/)
      kbo_mn2(:, 1) = (/ &
     & 5.12042e-08_r8, 5.51239e-08_r8, 5.93436e-08_r8, 6.38863e-08_r8, 6.87767e-08_r8, &
     & 7.40415e-08_r8, 7.97093e-08_r8, 8.58110e-08_r8, 9.23797e-08_r8, 9.94513e-08_r8, &
     & 1.07064e-07_r8, 1.15260e-07_r8, 1.24083e-07_r8, 1.33581e-07_r8, 1.43807e-07_r8, &
     & 1.54815e-07_r8, 1.66666e-07_r8, 1.79424e-07_r8, 1.93159e-07_r8/)
      kbo_mn2(:, 2) = (/ &
     & 2.30938e-07_r8, 2.41696e-07_r8, 2.52955e-07_r8, 2.64738e-07_r8, 2.77071e-07_r8, &
     & 2.89978e-07_r8, 3.03486e-07_r8, 3.17623e-07_r8, 3.32419e-07_r8, 3.47904e-07_r8, &
     & 3.64111e-07_r8, 3.81072e-07_r8, 3.98824e-07_r8, 4.17402e-07_r8, 4.36846e-07_r8, &
     & 4.57196e-07_r8, 4.78494e-07_r8, 5.00784e-07_r8, 5.24112e-07_r8/)
      kbo_mn2(:, 3) = (/ &
     & 6.70458e-07_r8, 7.04274e-07_r8, 7.39795e-07_r8, 7.77109e-07_r8, 8.16304e-07_r8, &
     & 8.57476e-07_r8, 9.00724e-07_r8, 9.46154e-07_r8, 9.93876e-07_r8, 1.04400e-06_r8, &
     & 1.09666e-06_r8, 1.15197e-06_r8, 1.21008e-06_r8, 1.27111e-06_r8, 1.33522e-06_r8, &
     & 1.40256e-06_r8, 1.47331e-06_r8, 1.54761e-06_r8, 1.62567e-06_r8/)
      kbo_mn2(:, 4) = (/ &
     & 1.84182e-06_r8, 1.89203e-06_r8, 1.94360e-06_r8, 1.99658e-06_r8, 2.05101e-06_r8, &
     & 2.10692e-06_r8, 2.16435e-06_r8, 2.22335e-06_r8, 2.28396e-06_r8, 2.34622e-06_r8, &
     & 2.41017e-06_r8, 2.47587e-06_r8, 2.54337e-06_r8, 2.61270e-06_r8, 2.68392e-06_r8, &
     & 2.75708e-06_r8, 2.83224e-06_r8, 2.90944e-06_r8, 2.98875e-06_r8/)
      kbo_mn2(:, 5) = (/ &
     & 3.41996e-06_r8, 3.32758e-06_r8, 3.23770e-06_r8, 3.15024e-06_r8, 3.06515e-06_r8, &
     & 2.98235e-06_r8, 2.90180e-06_r8, 2.82341e-06_r8, 2.74715e-06_r8, 2.67294e-06_r8, &
     & 2.60074e-06_r8, 2.53049e-06_r8, 2.46214e-06_r8, 2.39563e-06_r8, 2.33092e-06_r8, &
     & 2.26796e-06_r8, 2.20670e-06_r8, 2.14709e-06_r8, 2.08910e-06_r8/)
      kbo_mn2(:, 6) = (/ &
     & 3.38746e-06_r8, 3.25966e-06_r8, 3.13669e-06_r8, 3.01836e-06_r8, 2.90449e-06_r8, &
     & 2.79491e-06_r8, 2.68947e-06_r8, 2.58801e-06_r8, 2.49037e-06_r8, 2.39642e-06_r8, &
     & 2.30601e-06_r8, 2.21902e-06_r8, 2.13530e-06_r8, 2.05475e-06_r8, 1.97723e-06_r8, &
     & 1.90264e-06_r8, 1.83086e-06_r8, 1.76179e-06_r8, 1.69532e-06_r8/)
      kbo_mn2(:, 7) = (/ &
     & 3.17530e-06_r8, 3.07196e-06_r8, 2.97199e-06_r8, 2.87527e-06_r8, 2.78170e-06_r8, &
     & 2.69118e-06_r8, 2.60360e-06_r8, 2.51887e-06_r8, 2.43690e-06_r8, 2.35759e-06_r8, &
     & 2.28087e-06_r8, 2.20664e-06_r8, 2.13483e-06_r8, 2.06536e-06_r8, 1.99814e-06_r8, &
     & 1.93312e-06_r8, 1.87021e-06_r8, 1.80934e-06_r8, 1.75046e-06_r8/)
      kbo_mn2(:, 8) = (/ &
     & 2.84701e-06_r8, 2.77007e-06_r8, 2.69521e-06_r8, 2.62237e-06_r8, 2.55150e-06_r8, &
     & 2.48254e-06_r8, 2.41545e-06_r8, 2.35017e-06_r8, 2.28666e-06_r8, 2.22486e-06_r8, &
     & 2.16473e-06_r8, 2.10623e-06_r8, 2.04930e-06_r8, 1.99392e-06_r8, 1.94003e-06_r8, &
     & 1.88760e-06_r8, 1.83659e-06_r8, 1.78695e-06_r8, 1.73866e-06_r8/)
      kbo_mn2(:, 9) = (/ &
     & 2.79917e-06_r8, 2.73207e-06_r8, 2.66658e-06_r8, 2.60266e-06_r8, 2.54027e-06_r8, &
     & 2.47937e-06_r8, 2.41994e-06_r8, 2.36192e-06_r8, 2.30530e-06_r8, 2.25004e-06_r8, &
     & 2.19610e-06_r8, 2.14346e-06_r8, 2.09208e-06_r8, 2.04193e-06_r8, 1.99298e-06_r8, &
     & 1.94520e-06_r8, 1.89857e-06_r8, 1.85306e-06_r8, 1.80864e-06_r8/)
      kbo_mn2(:,10) = (/ &
     & 2.74910e-06_r8, 2.64462e-06_r8, 2.54412e-06_r8, 2.44743e-06_r8, 2.35442e-06_r8, &
     & 2.26495e-06_r8, 2.17887e-06_r8, 2.09606e-06_r8, 2.01641e-06_r8, 1.93978e-06_r8, &
     & 1.86606e-06_r8, 1.79514e-06_r8, 1.72692e-06_r8, 1.66129e-06_r8, 1.59815e-06_r8, &
     & 1.53742e-06_r8, 1.47899e-06_r8, 1.42278e-06_r8, 1.36871e-06_r8/)
      kbo_mn2(:,11) = (/ &
     & 2.63952e-06_r8, 2.60263e-06_r8, 2.56626e-06_r8, 2.53039e-06_r8, 2.49503e-06_r8, &
     & 2.46016e-06_r8, 2.42578e-06_r8, 2.39188e-06_r8, 2.35845e-06_r8, 2.32549e-06_r8, &
     & 2.29299e-06_r8, 2.26094e-06_r8, 2.22934e-06_r8, 2.19819e-06_r8, 2.16747e-06_r8, &
     & 2.13717e-06_r8, 2.10731e-06_r8, 2.07786e-06_r8, 2.04882e-06_r8/)
      kbo_mn2(:,12) = (/ &
     & 2.94106e-06_r8, 2.82819e-06_r8, 2.71966e-06_r8, 2.61528e-06_r8, 2.51492e-06_r8, &
     & 2.41841e-06_r8, 2.32560e-06_r8, 2.23635e-06_r8, 2.15053e-06_r8, 2.06800e-06_r8, &
     & 1.98863e-06_r8, 1.91232e-06_r8, 1.83893e-06_r8, 1.76836e-06_r8, 1.70049e-06_r8, &
     & 1.63524e-06_r8, 1.57248e-06_r8, 1.51214e-06_r8, 1.45411e-06_r8/)
      kbo_mn2(:,13) = (/ &
     & 2.94607e-06_r8, 2.87369e-06_r8, 2.80309e-06_r8, 2.73422e-06_r8, 2.66705e-06_r8, &
     & 2.60152e-06_r8, 2.53760e-06_r8, 2.47526e-06_r8, 2.41445e-06_r8, 2.35513e-06_r8, &
     & 2.29726e-06_r8, 2.24082e-06_r8, 2.18577e-06_r8, 2.13207e-06_r8, 2.07969e-06_r8, &
     & 2.02859e-06_r8, 1.97875e-06_r8, 1.93014e-06_r8, 1.88272e-06_r8/)
      kbo_mn2(:,14) = (/ &
     & 2.58051e-06_r8, 2.48749e-06_r8, 2.39782e-06_r8, 2.31139e-06_r8, 2.22807e-06_r8, &
     & 2.14775e-06_r8, 2.07033e-06_r8, 1.99570e-06_r8, 1.92376e-06_r8, 1.85441e-06_r8, &
     & 1.78756e-06_r8, 1.72313e-06_r8, 1.66101e-06_r8, 1.60114e-06_r8, 1.54342e-06_r8, &
     & 1.48778e-06_r8, 1.43415e-06_r8, 1.38245e-06_r8, 1.33262e-06_r8/)
      kbo_mn2(:,15) = (/ &
     & 3.03447e-06_r8, 2.88559e-06_r8, 2.74401e-06_r8, 2.60938e-06_r8, 2.48135e-06_r8, &
     & 2.35961e-06_r8, 2.24384e-06_r8, 2.13375e-06_r8, 2.02906e-06_r8, 1.92951e-06_r8, &
     & 1.83484e-06_r8, 1.74481e-06_r8, 1.65921e-06_r8, 1.57780e-06_r8, 1.50039e-06_r8, &
     & 1.42677e-06_r8, 1.35677e-06_r8, 1.29020e-06_r8, 1.22690e-06_r8/)
      kbo_mn2(:,16) = (/ &
     & 1.48655e-06_r8, 1.48283e-06_r8, 1.47913e-06_r8, 1.47543e-06_r8, 1.47174e-06_r8, &
     & 1.46806e-06_r8, 1.46439e-06_r8, 1.46072e-06_r8, 1.45707e-06_r8, 1.45343e-06_r8, &
     & 1.44979e-06_r8, 1.44617e-06_r8, 1.44255e-06_r8, 1.43894e-06_r8, 1.43534e-06_r8, &
     & 1.43176e-06_r8, 1.42817e-06_r8, 1.42460e-06_r8, 1.42104e-06_r8/)

!     The array FORREFO contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  The first 
!     index refers to reference temperature (296,260,224,260) and 
!     pressure (970,475,219,3 mbar) levels.  The second index 
!     runs over the g-channel (1 to 16).

      forrefo(1,:) = (/ &
     &3.6742e-02_r8,1.0664e-01_r8,2.6132e-01_r8,2.7906e-01_r8,2.8151e-01_r8,2.7465e-01_r8, &
     &2.8530e-01_r8,2.9123e-01_r8,3.0697e-01_r8,3.1801e-01_r8,3.2444e-01_r8,2.7746e-01_r8, &
     &3.1994e-01_r8,2.9750e-01_r8,2.1226e-01_r8,1.2847e-01_r8/)
      forrefo(2,:) = (/ &
     &4.0450e-02_r8,1.1085e-01_r8,2.9205e-01_r8,3.1934e-01_r8,3.1739e-01_r8,3.1450e-01_r8, &
     &3.2797e-01_r8,3.2223e-01_r8,3.3099e-01_r8,3.4800e-01_r8,3.4046e-01_r8,3.5700e-01_r8, &
     &3.8264e-01_r8,3.6679e-01_r8,3.3481e-01_r8,3.2113e-01_r8/)
      forrefo(3,:) = (/ &
     &4.6952e-02_r8,1.1999e-01_r8,3.1473e-01_r8,3.7015e-01_r8,3.6913e-01_r8,3.6352e-01_r8, &
     &3.7754e-01_r8,3.7402e-01_r8,3.7113e-01_r8,3.7720e-01_r8,3.8365e-01_r8,4.0876e-01_r8, &
     &4.2968e-01_r8,4.4186e-01_r8,4.3468e-01_r8,4.7083e-01_r8/)
      forrefo(4,:) = (/ &
     &7.0645e-02_r8,1.6618e-01_r8,2.8516e-01_r8,3.1819e-01_r8,3.0131e-01_r8,2.9552e-01_r8, &
     &2.8972e-01_r8,2.9348e-01_r8,2.8668e-01_r8,2.8483e-01_r8,2.8130e-01_r8,2.7757e-01_r8, &
     &2.9735e-01_r8,3.1684e-01_r8,3.0681e-01_r8,3.6778e-01_r8/)

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      selfrefo(:, 1) = (/ &
     & 2.16803e+00_r8, 1.98236e+00_r8, 1.81260e+00_r8, 1.65737e+00_r8, 1.51544e+00_r8, &
     & 1.38567e+00_r8, 1.26700e+00_r8, 1.15850e+00_r8, 1.05929e+00_r8, 9.68576e-01_r8/)
      selfrefo(:, 2) = (/ &
     & 3.70149e+00_r8, 3.43145e+00_r8, 3.18110e+00_r8, 2.94902e+00_r8, 2.73387e+00_r8, &
     & 2.53441e+00_r8, 2.34951e+00_r8, 2.17810e+00_r8, 2.01919e+00_r8, 1.87188e+00_r8/)
      selfrefo(:, 3) = (/ &
     & 6.17433e+00_r8, 5.62207e+00_r8, 5.11920e+00_r8, 4.66131e+00_r8, 4.24438e+00_r8, &
     & 3.86474e+00_r8, 3.51906e+00_r8, 3.20430e+00_r8, 2.91769e+00_r8, 2.65672e+00_r8/)
      selfrefo(:, 4) = (/ &
     & 6.56459e+00_r8, 5.94787e+00_r8, 5.38910e+00_r8, 4.88282e+00_r8, 4.42410e+00_r8, &
     & 4.00848e+00_r8, 3.63190e+00_r8, 3.29070e+00_r8, 2.98155e+00_r8, 2.70145e+00_r8/)
      selfrefo(:, 5) = (/ &
     & 6.49581e+00_r8, 5.91114e+00_r8, 5.37910e+00_r8, 4.89494e+00_r8, 4.45436e+00_r8, &
     & 4.05344e+00_r8, 3.68860e+00_r8, 3.35660e+00_r8, 3.05448e+00_r8, 2.77956e+00_r8/)
      selfrefo(:, 6) = (/ &
     & 6.50189e+00_r8, 5.89381e+00_r8, 5.34260e+00_r8, 4.84294e+00_r8, 4.39001e+00_r8, &
     & 3.97944e+00_r8, 3.60727e+00_r8, 3.26990e+00_r8, 2.96409e+00_r8, 2.68687e+00_r8/)
      selfrefo(:, 7) = (/ &
     & 6.64768e+00_r8, 6.01719e+00_r8, 5.44650e+00_r8, 4.92993e+00_r8, 4.46236e+00_r8, &
     & 4.03914e+00_r8, 3.65605e+00_r8, 3.30930e+00_r8, 2.99543e+00_r8, 2.71134e+00_r8/)
      selfrefo(:, 8) = (/ &
     & 6.43744e+00_r8, 5.87166e+00_r8, 5.35560e+00_r8, 4.88490e+00_r8, 4.45557e+00_r8, &
     & 4.06397e+00_r8, 3.70679e+00_r8, 3.38100e+00_r8, 3.08384e+00_r8, 2.81281e+00_r8/)
      selfrefo(:, 9) = (/ &
     & 6.55466e+00_r8, 5.99777e+00_r8, 5.48820e+00_r8, 5.02192e+00_r8, 4.59525e+00_r8, &
     & 4.20484e+00_r8, 3.84759e+00_r8, 3.52070e+00_r8, 3.22158e+00_r8, 2.94787e+00_r8/)
      selfrefo(:,10) = (/ &
     & 6.84510e+00_r8, 6.26933e+00_r8, 5.74200e+00_r8, 5.25902e+00_r8, 4.81667e+00_r8, &
     & 4.41152e+00_r8, 4.04046e+00_r8, 3.70060e+00_r8, 3.38933e+00_r8, 3.10424e+00_r8/)
      selfrefo(:,11) = (/ &
     & 6.83128e+00_r8, 6.25536e+00_r8, 5.72800e+00_r8, 5.24510e+00_r8, 4.80291e+00_r8, &
     & 4.39799e+00_r8, 4.02722e+00_r8, 3.68770e+00_r8, 3.37681e+00_r8, 3.09212e+00_r8/)
      selfrefo(:,12) = (/ &
     & 7.35969e+00_r8, 6.61719e+00_r8, 5.94960e+00_r8, 5.34936e+00_r8, 4.80968e+00_r8, &
     & 4.32445e+00_r8, 3.88817e+00_r8, 3.49590e+00_r8, 3.14321e+00_r8, 2.82610e+00_r8/)
      selfrefo(:,13) = (/ &
     & 7.50064e+00_r8, 6.80749e+00_r8, 6.17840e+00_r8, 5.60744e+00_r8, 5.08925e+00_r8, &
     & 4.61894e+00_r8, 4.19210e+00_r8, 3.80470e+00_r8, 3.45310e+00_r8, 3.13399e+00_r8/)
      selfrefo(:,14) = (/ &
     & 7.40801e+00_r8, 6.71328e+00_r8, 6.08370e+00_r8, 5.51316e+00_r8, 4.99613e+00_r8, &
     & 4.52759e+00_r8, 4.10298e+00_r8, 3.71820e+00_r8, 3.36950e+00_r8, 3.05351e+00_r8/)
      selfrefo(:,15) = (/ &
     & 7.51895e+00_r8, 6.68846e+00_r8, 5.94970e+00_r8, 5.29254e+00_r8, 4.70796e+00_r8, &
     & 4.18795e+00_r8, 3.72538e+00_r8, 3.31390e+00_r8, 2.94787e+00_r8, 2.62227e+00_r8/)
      selfrefo(:,16) = (/ &
     & 7.84774e+00_r8, 6.80673e+00_r8, 5.90380e+00_r8, 5.12065e+00_r8, 4.44138e+00_r8, &
     & 3.85223e+00_r8, 3.34122e+00_r8, 2.89800e+00_r8, 2.51357e+00_r8, 2.18014e+00_r8/)

      end subroutine lw_kgb01

