!     path:      $Source: /storm/rc1/cvsroot/rc/rrtmg_lw/src/rrtmg_lw_k_g.f90,v $
!     author:    $Author: mike $
!     revision:  $Revision: 1.2 $
!     created:   $Date: 2007/08/22 19:20:03 $
!
!  --------------------------------------------------------------------------
! |                                                                          |
! |  Copyright 2002-2007, Atmospheric & Environmental Research, Inc. (AER).  |
! |  This software may be used, copied, or redistributed as long as it is    |
! |  not sold and this copyright notice is reproduced on each copy made.     |
! |  This model is provided as is without any express or implied warranties. |
! |                       (http://www.rtweb.aer.com/)                        |
! |                                                                          |
!  --------------------------------------------------------------------------

! **************************************************************************
      MODULE lw_kgbnn
      
      CONTAINS
! **************************************************************************
!  RRTM Longwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original version:   E. J. Mlawer, et al.
!  Revision for GCMs:  Michael J. Iacono; October, 2002
!
!  This file contains 16 subroutines that include the 
!  absorption coefficients and other data for each of the 16 longwave
!  spectral bands used in RRTM.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_LW_INIT to reduce
!  the total number of g-points from 256 to 140 for use in the GCM.
! **************************************************************************
      subroutine lw_kgb03
! **************************************************************************

      use shr_kind_mod, only: r8 => shr_kind_r8

!      use parkind, only : jpim, jprb 
      use rrlw_kg03, only : fracrefao, fracrefbo, kao, kbo, kao_mn2o, &
                            kbo_mn2o, selfrefo, forrefo

      implicit none
      save

! Planck fraction mapping level: P=212.7250 mbar, T = 223.06 K
      fracrefao(:, 1) = (/ &
     &   1.6251e-01_r8,1.5572e-01_r8,1.4557e-01_r8,1.3208e-01_r8,1.1582e-01_r8,9.6895e-02_r8, &
     &   7.8720e-02_r8,5.8462e-02_r8,3.9631e-02_r8,4.3001e-03_r8,3.5555e-03_r8,2.8101e-03_r8, &
     &   2.0547e-03_r8,1.3109e-03_r8,4.9403e-04_r8,6.9515e-05_r8/)
      fracrefao(:, 2) = (/ &
     &   1.6006e-01_r8,1.5576e-01_r8,1.4609e-01_r8,1.3276e-01_r8,1.1594e-01_r8,9.7336e-02_r8, &
     &   7.9035e-02_r8,5.8696e-02_r8,3.9723e-02_r8,4.3001e-03_r8,3.5555e-03_r8,2.8101e-03_r8, &
     &   2.0547e-03_r8,1.3109e-03_r8,4.9403e-04_r8,6.9515e-05_r8/)
      fracrefao(:, 3) = (/ &
     &   1.5952e-01_r8,1.5566e-01_r8,1.4590e-01_r8,1.3294e-01_r8,1.1599e-01_r8,9.7511e-02_r8, &
     &   7.9127e-02_r8,5.8888e-02_r8,3.9874e-02_r8,4.3001e-03_r8,3.5555e-03_r8,2.8102e-03_r8, &
     &   2.0547e-03_r8,1.3109e-03_r8,4.9403e-04_r8,6.9515e-05_r8/)
      fracrefao(:, 4) = (/ &
     &   1.5907e-01_r8,1.5541e-01_r8,1.4585e-01_r8,1.3316e-01_r8,1.1596e-01_r8,9.7647e-02_r8, &
     &   7.9243e-02_r8,5.9024e-02_r8,4.0028e-02_r8,4.3112e-03_r8,3.5555e-03_r8,2.8102e-03_r8, &
     &   2.0547e-03_r8,1.3109e-03_r8,4.9403e-04_r8,6.9515e-05_r8/)
      fracrefao(:, 5) = (/ &
     &   1.5862e-01_r8,1.5517e-01_r8,1.4588e-01_r8,1.3328e-01_r8,1.1585e-01_r8,9.7840e-02_r8, &
     &   7.9364e-02_r8,5.9174e-02_r8,4.0160e-02_r8,4.3403e-03_r8,3.5900e-03_r8,2.8102e-03_r8, &
     &   2.0547e-03_r8,1.3109e-03_r8,4.9403e-04_r8,6.9515e-05_r8/)
      fracrefao(:, 6) = (/ &
     &   1.5830e-01_r8,1.5490e-01_r8,1.4582e-01_r8,1.3331e-01_r8,1.1567e-01_r8,9.8079e-02_r8, &
     &   7.9510e-02_r8,5.9369e-02_r8,4.0326e-02_r8,4.3343e-03_r8,3.5908e-03_r8,2.8527e-03_r8, &
     &   2.0655e-03_r8,1.3109e-03_r8,4.9403e-04_r8,6.9515e-05_r8/)
      fracrefao(:, 7) = (/ &
     &   1.5789e-01_r8,1.5435e-01_r8,1.4595e-01_r8,1.3304e-01_r8,1.1566e-01_r8,9.8426e-02_r8, &
     &   7.9704e-02_r8,5.9618e-02_r8,4.0520e-02_r8,4.3812e-03_r8,3.6147e-03_r8,2.8395e-03_r8, &
     &   2.1301e-03_r8,1.3145e-03_r8,4.9403e-04_r8,6.9515e-05_r8/)
      fracrefao(:, 8) = (/ &
     &   1.5704e-01_r8,1.5398e-01_r8,1.4564e-01_r8,1.3222e-01_r8,1.1586e-01_r8,9.9230e-02_r8, &
     &   8.0011e-02_r8,6.0149e-02_r8,4.0790e-02_r8,4.4253e-03_r8,3.6534e-03_r8,2.9191e-03_r8, &
     &   2.1373e-03_r8,1.3558e-03_r8,5.1631e-04_r8,7.8794e-05_r8/)
      fracrefao(:, 9) = (/ &
     &   1.5270e-01_r8,1.5126e-01_r8,1.4264e-01_r8,1.3106e-01_r8,1.1740e-01_r8,1.0137e-01_r8, &
     &   8.3057e-02_r8,6.2282e-02_r8,4.2301e-02_r8,4.6486e-03_r8,3.8159e-03_r8,3.0472e-03_r8, &
     &   2.2870e-03_r8,1.4818e-03_r8,5.6773e-04_r8,7.8794e-05_r8/)

! Planck fraction mapping level: p = 95.8 mbar, t = 215.7 k
      fracrefbo(:, 1) = (/ &
     &   1.6413e-01_r8,1.5665e-01_r8,1.4606e-01_r8,1.3184e-01_r8,1.1517e-01_r8,9.6243e-02_r8, &
     &   7.7982e-02_r8,5.8165e-02_r8,3.9311e-02_r8,4.2586e-03_r8,3.5189e-03_r8,2.7793e-03_r8, &
     &   2.0376e-03_r8,1.2938e-03_r8,4.8853e-04_r8,6.8745e-05_r8/)
      fracrefbo(:, 2) = (/ &
     &   1.6254e-01_r8,1.5674e-01_r8,1.4652e-01_r8,1.3221e-01_r8,1.1535e-01_r8,9.6439e-02_r8, &
     &   7.8155e-02_r8,5.8254e-02_r8,3.9343e-02_r8,4.2586e-03_r8,3.5189e-03_r8,2.7793e-03_r8, &
     &   2.0376e-03_r8,1.2938e-03_r8,4.8853e-04_r8,6.8745e-05_r8/)
      fracrefbo(:, 3) = (/ &
     &   1.6177e-01_r8,1.5664e-01_r8,1.4669e-01_r8,1.3242e-01_r8,1.1541e-01_r8,9.6536e-02_r8, &
     &   7.8257e-02_r8,5.8387e-02_r8,3.9431e-02_r8,4.2587e-03_r8,3.5189e-03_r8,2.7793e-03_r8, &
     &   2.0376e-03_r8,1.2938e-03_r8,4.8853e-04_r8,6.8745e-05_r8/)
      fracrefbo(:, 4) = (/ &
     &   1.6077e-01_r8,1.5679e-01_r8,1.4648e-01_r8,1.3273e-01_r8,1.1546e-01_r8,9.6779e-02_r8, &
     &   7.8371e-02_r8,5.8546e-02_r8,3.9611e-02_r8,4.2772e-03_r8,3.5190e-03_r8,2.7793e-03_r8, &
     &   2.0376e-03_r8,1.2938e-03_r8,4.8853e-04_r8,6.8745e-05_r8/)
      fracrefbo(:, 5) = (/ &
     &   1.6067e-01_r8,1.5608e-01_r8,1.4247e-01_r8,1.2881e-01_r8,1.1449e-01_r8,9.8802e-02_r8, &
     &   8.0828e-02_r8,6.0977e-02_r8,4.1494e-02_r8,4.5116e-03_r8,3.7290e-03_r8,2.9460e-03_r8, &
     &   2.1948e-03_r8,1.3778e-03_r8,5.4552e-04_r8,7.9969e-05_r8/)

!     The array KAO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels > ~100mb, temperatures, and ratios
!     of water vapor to CO2.  The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amount ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 
!     to that of gas2.
!     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
!     to different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this  pressure 
!     level, JT = 2 refers to the temperature
!     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the reference pressure level (e.g. JP = 1 is for a
!     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

      kao(:, 1, 1, 1) = (/ &
     &3.1886e-07_r8,1.8969e-04_r8,4.1239e-04_r8,6.4667e-04_r8,8.5292e-04_r8,1.1836e-03_r8, &
     &1.4006e-03_r8,1.5411e-03_r8,8.3293e-04_r8/)
      kao(:, 2, 1, 1) = (/ &
     &4.3208e-07_r8,2.2286e-04_r8,4.4627e-04_r8,7.2330e-04_r8,9.3694e-04_r8,1.2337e-03_r8, &
     &1.5482e-03_r8,1.7773e-03_r8,1.0038e-03_r8/)
      kao(:, 3, 1, 1) = (/ &
     &5.8834e-07_r8,2.6143e-04_r8,5.0441e-04_r8,7.7424e-04_r8,1.0403e-03_r8,1.3331e-03_r8, &
     &1.7908e-03_r8,2.0845e-03_r8,1.1619e-03_r8/)
      kao(:, 4, 1, 1) = (/ &
     &7.9926e-07_r8,3.0532e-04_r8,5.7655e-04_r8,8.4667e-04_r8,1.1189e-03_r8,1.4849e-03_r8, &
     &1.7793e-03_r8,2.3392e-03_r8,1.2758e-03_r8/)
      kao(:, 5, 1, 1) = (/ &
     &1.0726e-06_r8,3.5559e-04_r8,6.6472e-04_r8,9.5586e-04_r8,1.2287e-03_r8,1.5629e-03_r8, &
     &1.9684e-03_r8,2.6521e-03_r8,1.4781e-03_r8/)
      kao(:, 1, 2, 1) = (/ &
     &3.7301e-07_r8,1.5101e-04_r8,3.0613e-04_r8,5.2444e-04_r8,6.6785e-04_r8,9.0347e-04_r8, &
     &1.1047e-03_r8,1.2717e-03_r8,6.0920e-04_r8/)
      kao(:, 2, 2, 1) = (/ &
     &5.0464e-07_r8,1.7900e-04_r8,3.4606e-04_r8,5.4112e-04_r8,7.7706e-04_r8,9.3108e-04_r8, &
     &1.2909e-03_r8,1.4671e-03_r8,7.3637e-04_r8/)
      kao(:, 3, 2, 1) = (/ &
     &6.9109e-07_r8,2.1210e-04_r8,4.0308e-04_r8,5.9670e-04_r8,8.3572e-04_r8,1.0539e-03_r8, &
     &1.2895e-03_r8,1.6281e-03_r8,8.3917e-04_r8/)
      kao(:, 4, 2, 1) = (/ &
     &9.4449e-07_r8,2.4973e-04_r8,4.6862e-04_r8,6.7662e-04_r8,9.0294e-04_r8,1.1388e-03_r8, &
     &1.4230e-03_r8,1.8780e-03_r8,9.5236e-04_r8/)
      kao(:, 5, 2, 1) = (/ &
     &1.2785e-06_r8,2.9283e-04_r8,5.4407e-04_r8,7.7522e-04_r8,1.0053e-03_r8,1.2254e-03_r8, &
     &1.5592e-03_r8,1.9031e-03_r8,1.1164e-03_r8/)
      kao(:, 1, 3, 1) = (/ &
     &5.5921e-07_r8,1.1924e-04_r8,2.2509e-04_r8,3.4318e-04_r8,5.2308e-04_r8,6.5616e-04_r8, &
     &8.5230e-04_r8,1.0069e-03_r8,4.1268e-04_r8/)
      kao(:, 2, 3, 1) = (/ &
     &7.5055e-07_r8,1.4483e-04_r8,2.6805e-04_r8,3.9345e-04_r8,5.4245e-04_r8,7.6863e-04_r8, &
     &8.6931e-04_r8,1.1266e-03_r8,5.0829e-04_r8/)
      kao(:, 3, 3, 1) = (/ &
     &1.0282e-06_r8,1.7418e-04_r8,3.1823e-04_r8,4.6052e-04_r8,6.0646e-04_r8,8.0699e-04_r8, &
     &9.9010e-04_r8,1.2822e-03_r8,5.8353e-04_r8/)
      kao(:, 4, 3, 1) = (/ &
     &1.4165e-06_r8,2.0776e-04_r8,3.7640e-04_r8,5.3896e-04_r8,6.9736e-04_r8,8.7108e-04_r8, &
     &1.0948e-03_r8,1.3035e-03_r8,6.8429e-04_r8/)
      kao(:, 5, 3, 1) = (/ &
     &1.9344e-06_r8,2.4744e-04_r8,4.4263e-04_r8,6.2983e-04_r8,8.0258e-04_r8,9.7503e-04_r8, &
     &1.1651e-03_r8,1.4497e-03_r8,8.1461e-04_r8/)
      kao(:, 1, 4, 1) = (/ &
     &8.5732e-07_r8,9.6467e-05_r8,1.7424e-04_r8,2.5100e-04_r8,3.3065e-04_r8,4.8724e-04_r8, &
     &6.0299e-04_r8,7.8582e-04_r8,2.9808e-04_r8/)
      kao(:, 2, 4, 1) = (/ &
     &1.1308e-06_r8,1.1826e-04_r8,2.1303e-04_r8,3.0261e-04_r8,3.9186e-04_r8,5.0849e-04_r8, &
     &7.0322e-04_r8,8.2275e-04_r8,3.5462e-04_r8/)
      kao(:, 3, 4, 1) = (/ &
     &1.5409e-06_r8,1.4413e-04_r8,2.5818e-04_r8,3.6263e-04_r8,4.6469e-04_r8,5.7592e-04_r8, &
     &7.3867e-04_r8,8.7496e-04_r8,4.2760e-04_r8/)
      kao(:, 4, 4, 1) = (/ &
     &2.1300e-06_r8,1.7563e-04_r8,3.1026e-04_r8,4.3228e-04_r8,5.4859e-04_r8,6.6681e-04_r8, &
     &7.9581e-04_r8,9.9932e-04_r8,5.0892e-04_r8/)
      kao(:, 5, 4, 1) = (/ &
     &2.9291e-06_r8,2.1272e-04_r8,3.6864e-04_r8,5.1165e-04_r8,6.4677e-04_r8,7.7619e-04_r8, &
     &8.9814e-04_r8,1.0897e-03_r8,6.0064e-04_r8/)
      kao(:, 1, 5, 1) = (/ &
     &1.2415e-06_r8,7.8277e-05_r8,1.3778e-04_r8,1.9284e-04_r8,2.4740e-04_r8,3.0422e-04_r8, &
     &4.5046e-04_r8,5.5097e-04_r8,2.1557e-04_r8/)
      kao(:, 2, 5, 1) = (/ &
     &1.5909e-06_r8,9.7521e-05_r8,1.7125e-04_r8,2.3852e-04_r8,3.0221e-04_r8,3.6563e-04_r8, &
     &4.6525e-04_r8,6.1320e-04_r8,2.5987e-04_r8/)
      kao(:, 3, 5, 1) = (/ &
     &2.1423e-06_r8,1.2163e-04_r8,2.0881e-04_r8,2.9129e-04_r8,3.6625e-04_r8,4.3908e-04_r8, &
     &5.2524e-04_r8,7.1422e-04_r8,3.1853e-04_r8/)
      kao(:, 4, 5, 1) = (/ &
     &2.9538e-06_r8,1.5072e-04_r8,2.5416e-04_r8,3.5255e-04_r8,4.4063e-04_r8,5.2156e-04_r8, &
     &6.0639e-04_r8,7.4820e-04_r8,3.8686e-04_r8/)
      kao(:, 5, 5, 1) = (/ &
     &4.0808e-06_r8,1.8492e-04_r8,3.0793e-04_r8,4.2155e-04_r8,5.2630e-04_r8,6.1892e-04_r8, &
     &7.0820e-04_r8,8.0049e-04_r8,4.6257e-04_r8/)
      kao(:, 1, 6, 1) = (/ &
     &1.7276e-06_r8,6.3066e-05_r8,1.0985e-04_r8,1.5043e-04_r8,1.8792e-04_r8,2.2547e-04_r8, &
     &2.7278e-04_r8,4.0029e-04_r8,1.5625e-04_r8/)
      kao(:, 2, 6, 1) = (/ &
     &2.1189e-06_r8,8.0476e-05_r8,1.3664e-04_r8,1.8841e-04_r8,2.3492e-04_r8,2.7888e-04_r8, &
     &3.2236e-04_r8,4.6057e-04_r8,1.9653e-04_r8/)
      kao(:, 3, 6, 1) = (/ &
     &2.7917e-06_r8,1.0200e-04_r8,1.6954e-04_r8,2.3141e-04_r8,2.8961e-04_r8,3.4143e-04_r8, &
     &3.9023e-04_r8,4.8352e-04_r8,2.3947e-04_r8/)
      kao(:, 4, 6, 1) = (/ &
     &3.8168e-06_r8,1.2811e-04_r8,2.1054e-04_r8,2.8370e-04_r8,3.5217e-04_r8,4.1385e-04_r8, &
     &4.6780e-04_r8,5.3253e-04_r8,2.9421e-04_r8/)
      kao(:, 5, 6, 1) = (/ &
     &5.2799e-06_r8,1.5893e-04_r8,2.5910e-04_r8,3.4517e-04_r8,4.2434e-04_r8,4.9842e-04_r8, &
     &5.5728e-04_r8,6.1195e-04_r8,3.4978e-04_r8/)
      kao(:, 1, 7, 1) = (/ &
     &2.6141e-06_r8,5.1662e-05_r8,8.7249e-05_r8,1.2099e-04_r8,1.4820e-04_r8,1.7386e-04_r8, &
     &1.9973e-04_r8,2.8823e-04_r8,1.2462e-04_r8/)
      kao(:, 2, 7, 1) = (/ &
     &3.0451e-06_r8,6.6903e-05_r8,1.1099e-04_r8,1.5079e-04_r8,1.8779e-04_r8,2.1746e-04_r8, &
     &2.4532e-04_r8,2.8791e-04_r8,1.5686e-04_r8/)
      kao(:, 3, 7, 1) = (/ &
     &3.8821e-06_r8,8.6234e-05_r8,1.4155e-04_r8,1.8817e-04_r8,2.3079e-04_r8,2.7142e-04_r8, &
     &3.0362e-04_r8,3.3424e-04_r8,1.9309e-04_r8/)
      kao(:, 4, 7, 1) = (/ &
     &5.2168e-06_r8,1.0990e-04_r8,1.7879e-04_r8,2.3488e-04_r8,2.8585e-04_r8,3.3138e-04_r8, &
     &3.7038e-04_r8,4.0029e-04_r8,2.2841e-04_r8/)
      kao(:, 5, 7, 1) = (/ &
     &7.1879e-06_r8,1.3891e-04_r8,2.2275e-04_r8,2.9114e-04_r8,3.5068e-04_r8,4.0298e-04_r8, &
     &4.4929e-04_r8,4.7758e-04_r8,2.7333e-04_r8/)
      kao(:, 1, 8, 1) = (/ &
     &4.8895e-06_r8,4.6642e-05_r8,7.3353e-05_r8,9.8230e-05_r8,1.2186e-04_r8,1.4040e-04_r8, &
     &1.5472e-04_r8,1.7158e-04_r8,1.2116e-04_r8/)
      kao(:, 2, 8, 1) = (/ &
     &5.4032e-06_r8,6.0479e-05_r8,9.5191e-05_r8,1.2606e-04_r8,1.5260e-04_r8,1.7774e-04_r8, &
     &1.9641e-04_r8,2.0965e-04_r8,1.4264e-04_r8/)
      kao(:, 3, 8, 1) = (/ &
     &6.5997e-06_r8,7.8772e-05_r8,1.2353e-04_r8,1.6212e-04_r8,1.9427e-04_r8,2.2313e-04_r8, &
     &2.4636e-04_r8,2.5986e-04_r8,1.7188e-04_r8/)
      kao(:, 4, 8, 1) = (/ &
     &8.6548e-06_r8,1.0205e-04_r8,1.5903e-04_r8,2.0720e-04_r8,2.4581e-04_r8,2.7759e-04_r8, &
     &3.0314e-04_r8,3.2037e-04_r8,2.0203e-04_r8/)
      kao(:, 5, 8, 1) = (/ &
     &1.1792e-05_r8,1.3168e-04_r8,2.0236e-04_r8,2.6066e-04_r8,3.0759e-04_r8,3.4497e-04_r8, &
     &3.7389e-04_r8,3.8968e-04_r8,2.4008e-04_r8/)
      kao(:, 1, 9, 1) = (/ &
     &1.7686e-05_r8,6.2925e-05_r8,8.5198e-05_r8,1.0213e-04_r8,1.1543e-04_r8,1.2780e-04_r8, &
     &1.3994e-04_r8,1.4164e-04_r8,1.0306e-04_r8/)
      kao(:, 2, 9, 1) = (/ &
     &1.8629e-05_r8,7.9145e-05_r8,1.0839e-04_r8,1.3177e-04_r8,1.5002e-04_r8,1.6481e-04_r8, &
     &1.7578e-04_r8,1.8331e-04_r8,1.3692e-04_r8/)
      kao(:, 3, 9, 1) = (/ &
     &2.1655e-05_r8,1.0259e-04_r8,1.4047e-04_r8,1.7139e-04_r8,1.9624e-04_r8,2.1451e-04_r8, &
     &2.2698e-04_r8,2.2863e-04_r8,1.7350e-04_r8/)
      kao(:, 4, 9, 1) = (/ &
     &2.7461e-05_r8,1.3575e-04_r8,1.8409e-04_r8,2.2366e-04_r8,2.5484e-04_r8,2.7815e-04_r8, &
     &2.9152e-04_r8,2.8719e-04_r8,2.1425e-04_r8/)
      kao(:, 5, 9, 1) = (/ &
     &3.6727e-05_r8,1.8189e-04_r8,2.4258e-04_r8,2.9022e-04_r8,3.2921e-04_r8,3.5617e-04_r8, &
     &3.6983e-04_r8,3.5850e-04_r8,2.5866e-04_r8/)
      kao(:, 1,10, 1) = (/ &
     &7.2663e-05_r8,1.2805e-04_r8,1.4610e-04_r8,1.5523e-04_r8,1.5931e-04_r8,1.5768e-04_r8, &
     &1.4950e-04_r8,1.3593e-04_r8,1.1207e-04_r8/)
      kao(:, 2,10, 1) = (/ &
     &7.4019e-05_r8,1.5108e-04_r8,1.7625e-04_r8,1.9103e-04_r8,1.9729e-04_r8,1.9817e-04_r8, &
     &1.9144e-04_r8,1.7408e-04_r8,1.5499e-04_r8/)
      kao(:, 3,10, 1) = (/ &
     &8.2403e-05_r8,1.8863e-04_r8,2.2414e-04_r8,2.4536e-04_r8,2.5373e-04_r8,2.5549e-04_r8, &
     &2.4939e-04_r8,2.2811e-04_r8,2.0551e-04_r8/)
      kao(:, 4,10, 1) = (/ &
     &1.0093e-04_r8,2.4723e-04_r8,2.9626e-04_r8,3.2296e-04_r8,3.3348e-04_r8,3.3522e-04_r8, &
     &3.2677e-04_r8,2.9826e-04_r8,2.6379e-04_r8/)
      kao(:, 5,10, 1) = (/ &
     &1.3200e-04_r8,3.3367e-04_r8,4.0011e-04_r8,4.3332e-04_r8,4.4493e-04_r8,4.4261e-04_r8, &
     &4.2611e-04_r8,3.8581e-04_r8,3.2912e-04_r8/)
      kao(:, 1,11, 1) = (/ &
     &1.0393e-04_r8,1.5840e-04_r8,1.7203e-04_r8,1.7648e-04_r8,1.7454e-04_r8,1.6667e-04_r8, &
     &1.5308e-04_r8,1.2939e-04_r8,1.0993e-04_r8/)
      kao(:, 2,11, 1) = (/ &
     &1.0623e-04_r8,1.8473e-04_r8,2.0510e-04_r8,2.1424e-04_r8,2.1529e-04_r8,2.0732e-04_r8, &
     &1.9332e-04_r8,1.6735e-04_r8,1.5034e-04_r8/)
      kao(:, 3,11, 1) = (/ &
     &1.1880e-04_r8,2.2821e-04_r8,2.5935e-04_r8,2.7369e-04_r8,2.7717e-04_r8,2.6782e-04_r8, &
     &2.5002e-04_r8,2.1993e-04_r8,1.9822e-04_r8/)
      kao(:, 4,11, 1) = (/ &
     &1.4561e-04_r8,2.9665e-04_r8,3.4318e-04_r8,3.6287e-04_r8,3.6642e-04_r8,3.5386e-04_r8, &
     &3.2944e-04_r8,2.8811e-04_r8,2.5319e-04_r8/)
      kao(:, 5,11, 1) = (/ &
     &1.9054e-04_r8,3.9809e-04_r8,4.6486e-04_r8,4.9198e-04_r8,4.9373e-04_r8,4.7462e-04_r8, &
     &4.3676e-04_r8,3.7664e-04_r8,3.1222e-04_r8/)
      kao(:, 1,12, 1) = (/ &
     &1.1070e-04_r8,1.5948e-04_r8,1.6935e-04_r8,1.7123e-04_r8,1.6742e-04_r8,1.5636e-04_r8, &
     &1.4108e-04_r8,1.1641e-04_r8,9.3609e-05_r8/)
      kao(:, 2,12, 1) = (/ &
     &1.1350e-04_r8,1.8499e-04_r8,2.0156e-04_r8,2.0690e-04_r8,2.0458e-04_r8,1.9450e-04_r8, &
     &1.7678e-04_r8,1.4985e-04_r8,1.2839e-04_r8/)
      kao(:, 3,12, 1) = (/ &
     &1.2733e-04_r8,2.2735e-04_r8,2.5402e-04_r8,2.6442e-04_r8,2.6348e-04_r8,2.5189e-04_r8, &
     &2.2992e-04_r8,1.9655e-04_r8,1.6928e-04_r8/)
      kao(:, 4,12, 1) = (/ &
     &1.5627e-04_r8,2.9456e-04_r8,3.3549e-04_r8,3.5142e-04_r8,3.5055e-04_r8,3.3475e-04_r8, &
     &3.0473e-04_r8,2.5892e-04_r8,2.1653e-04_r8/)
      kao(:, 5,12, 1) = (/ &
     &2.0441e-04_r8,3.9462e-04_r8,4.5461e-04_r8,4.7637e-04_r8,4.7456e-04_r8,4.5071e-04_r8, &
     &4.0805e-04_r8,3.4047e-04_r8,2.6779e-04_r8/)
      kao(:, 1,13, 1) = (/ &
     &9.4796e-05_r8,1.3566e-04_r8,1.4361e-04_r8,1.4479e-04_r8,1.4118e-04_r8,1.3147e-04_r8, &
     &1.1819e-04_r8,9.7170e-05_r8,7.6303e-05_r8/)
      kao(:, 2,13, 1) = (/ &
     &9.7387e-05_r8,1.5742e-04_r8,1.7115e-04_r8,1.7535e-04_r8,1.7300e-04_r8,1.6383e-04_r8, &
     &1.4824e-04_r8,1.2513e-04_r8,1.0469e-04_r8/)
      kao(:, 3,13, 1) = (/ &
     &1.0948e-04_r8,1.9354e-04_r8,2.1601e-04_r8,2.2450e-04_r8,2.2321e-04_r8,2.1287e-04_r8, &
     &1.9350e-04_r8,1.6433e-04_r8,1.3819e-04_r8/)
      kao(:, 4,13, 1) = (/ &
     &1.3445e-04_r8,2.5083e-04_r8,2.8549e-04_r8,2.9847e-04_r8,2.9725e-04_r8,2.8343e-04_r8, &
     &2.5763e-04_r8,2.1720e-04_r8,1.7601e-04_r8/)
      kao(:, 5,13, 1) = (/ &
     &1.7573e-04_r8,3.3657e-04_r8,3.8710e-04_r8,4.0560e-04_r8,4.0357e-04_r8,3.8257e-04_r8, &
     &3.4653e-04_r8,2.8685e-04_r8,2.1855e-04_r8/)
      kao(:, 1, 1, 2) = (/ &
     &1.3073e-06_r8,4.2059e-04_r8,6.7561e-04_r8,8.6609e-04_r8,1.3520e-03_r8,1.6085e-03_r8, &
     &2.0908e-03_r8,3.5262e-03_r8,1.7846e-03_r8/)
      kao(:, 2, 1, 2) = (/ &
     &1.8197e-06_r8,5.0768e-04_r8,8.4110e-04_r8,1.0238e-03_r8,1.3765e-03_r8,1.9239e-03_r8, &
     &2.2997e-03_r8,3.5756e-03_r8,2.0767e-03_r8/)
      kao(:, 3, 1, 2) = (/ &
     &2.5084e-06_r8,6.1290e-04_r8,1.0202e-03_r8,1.2693e-03_r8,1.5516e-03_r8,2.0078e-03_r8, &
     &2.5461e-03_r8,3.4922e-03_r8,2.2668e-03_r8/)
      kao(:, 4, 1, 2) = (/ &
     &3.4224e-06_r8,7.3392e-04_r8,1.2104e-03_r8,1.5455e-03_r8,1.8866e-03_r8,2.1966e-03_r8, &
     &2.9624e-03_r8,3.8708e-03_r8,2.5909e-03_r8/)
      kao(:, 5, 1, 2) = (/ &
     &4.5990e-06_r8,8.7030e-04_r8,1.4253e-03_r8,1.8395e-03_r8,2.2537e-03_r8,2.6314e-03_r8, &
     &3.0779e-03_r8,4.2442e-03_r8,2.9663e-03_r8/)
      kao(:, 1, 2, 2) = (/ &
     &1.5178e-06_r8,3.4269e-04_r8,6.0748e-04_r8,7.1986e-04_r8,9.3674e-04_r8,1.3121e-03_r8, &
     &1.6102e-03_r8,2.4069e-03_r8,1.3247e-03_r8/)
      kao(:, 2, 2, 2) = (/ &
     &2.1299e-06_r8,4.2524e-04_r8,7.3703e-04_r8,9.3776e-04_r8,1.0398e-03_r8,1.4367e-03_r8, &
     &1.7353e-03_r8,2.4061e-03_r8,1.5243e-03_r8/)
      kao(:, 3, 2, 2) = (/ &
     &2.9612e-06_r8,5.1753e-04_r8,8.8626e-04_r8,1.1500e-03_r8,1.2896e-03_r8,1.5263e-03_r8, &
     &2.0876e-03_r8,2.6389e-03_r8,1.6966e-03_r8/)
      kao(:, 4, 2, 2) = (/ &
     &4.0897e-06_r8,6.2596e-04_r8,1.0597e-03_r8,1.3843e-03_r8,1.5850e-03_r8,1.8098e-03_r8, &
     &2.1268e-03_r8,2.8656e-03_r8,1.9584e-03_r8/)
      kao(:, 5, 2, 2) = (/ &
     &5.5687e-06_r8,7.4555e-04_r8,1.2600e-03_r8,1.6347e-03_r8,1.9070e-03_r8,2.1914e-03_r8, &
     &2.4166e-03_r8,3.3007e-03_r8,2.2669e-03_r8/)
      kao(:, 1, 3, 2) = (/ &
     &2.2234e-06_r8,2.7444e-04_r8,5.0085e-04_r8,6.9534e-04_r8,7.7629e-04_r8,8.8854e-04_r8, &
     &1.1917e-03_r8,1.5373e-03_r8,9.1595e-04_r8/)
      kao(:, 2, 3, 2) = (/ &
     &3.1317e-06_r8,3.4263e-04_r8,6.2257e-04_r8,8.4941e-04_r8,1.0127e-03_r8,1.0143e-03_r8, &
     &1.3362e-03_r8,1.6583e-03_r8,1.0393e-03_r8/)
      kao(:, 3, 3, 2) = (/ &
     &4.4080e-06_r8,4.2422e-04_r8,7.6347e-04_r8,1.0279e-03_r8,1.2387e-03_r8,1.2967e-03_r8, &
     &1.3932e-03_r8,1.8408e-03_r8,1.2152e-03_r8/)
      kao(:, 4, 3, 2) = (/ &
     &6.1670e-06_r8,5.2130e-04_r8,9.2425e-04_r8,1.2412e-03_r8,1.4849e-03_r8,1.6022e-03_r8, &
     &1.6415e-03_r8,2.0935e-03_r8,1.4201e-03_r8/)
      kao(:, 5, 3, 2) = (/ &
     &8.5264e-06_r8,6.3507e-04_r8,1.1072e-03_r8,1.4843e-03_r8,1.7747e-03_r8,1.9362e-03_r8, &
     &2.0233e-03_r8,2.1572e-03_r8,1.6619e-03_r8/)
      kao(:, 1, 4, 2) = (/ &
     &3.2835e-06_r8,2.2111e-04_r8,3.9199e-04_r8,5.4782e-04_r8,7.1479e-04_r8,7.6154e-04_r8, &
     &8.2345e-04_r8,1.0888e-03_r8,6.1749e-04_r8/)
      kao(:, 2, 4, 2) = (/ &
     &4.6177e-06_r8,2.8239e-04_r8,4.9392e-04_r8,6.9299e-04_r8,8.7089e-04_r8,1.0035e-03_r8, &
     &9.4113e-04_r8,1.2776e-03_r8,7.2212e-04_r8/)
      kao(:, 3, 4, 2) = (/ &
     &6.5470e-06_r8,3.5777e-04_r8,6.1550e-04_r8,8.6066e-04_r8,1.0686e-03_r8,1.2181e-03_r8, &
     &1.2204e-03_r8,1.3196e-03_r8,8.5856e-04_r8/)
      kao(:, 4, 4, 2) = (/ &
     &9.2896e-06_r8,4.4826e-04_r8,7.6106e-04_r8,1.0547e-03_r8,1.2989e-03_r8,1.4671e-03_r8, &
     &1.5260e-03_r8,1.4238e-03_r8,1.0237e-03_r8/)
      kao(:, 5, 4, 2) = (/ &
     &1.3071e-05_r8,5.5733e-04_r8,9.3625e-04_r8,1.2821e-03_r8,1.5559e-03_r8,1.7516e-03_r8, &
     &1.8364e-03_r8,1.7115e-03_r8,1.2165e-03_r8/)
      kao(:, 1, 5, 2) = (/ &
     &4.5002e-06_r8,1.7869e-04_r8,3.1112e-04_r8,4.2906e-04_r8,5.3570e-04_r8,6.6321e-04_r8, &
     &6.6606e-04_r8,8.0088e-04_r8,4.3845e-04_r8/)
      kao(:, 2, 5, 2) = (/ &
     &6.2709e-06_r8,2.3526e-04_r8,3.9946e-04_r8,5.4822e-04_r8,6.8446e-04_r8,8.1650e-04_r8, &
     &8.9841e-04_r8,8.3661e-04_r8,5.3250e-04_r8/)
      kao(:, 3, 5, 2) = (/ &
     &8.9215e-06_r8,3.0515e-04_r8,5.1007e-04_r8,6.9053e-04_r8,8.5739e-04_r8,1.0092e-03_r8, &
     &1.0997e-03_r8,9.5118e-04_r8,6.4123e-04_r8/)
      kao(:, 4, 5, 2) = (/ &
     &1.2814e-05_r8,3.9188e-04_r8,6.4418e-04_r8,8.6120e-04_r8,1.0618e-03_r8,1.2430e-03_r8, &
     &1.3327e-03_r8,1.2360e-03_r8,7.6830e-04_r8/)
      kao(:, 5, 5, 2) = (/ &
     &1.8376e-05_r8,4.9865e-04_r8,8.0644e-04_r8,1.0670e-03_r8,1.3038e-03_r8,1.5043e-03_r8, &
     &1.6049e-03_r8,1.5432e-03_r8,9.1314e-04_r8/)
      kao(:, 1, 6, 2) = (/ &
     &5.7892e-06_r8,1.4663e-04_r8,2.4065e-04_r8,3.3064e-04_r8,4.1135e-04_r8,4.8169e-04_r8, &
     &5.8379e-04_r8,5.7710e-04_r8,3.1814e-04_r8/)
      kao(:, 2, 6, 2) = (/ &
     &7.9690e-06_r8,1.9590e-04_r8,3.2041e-04_r8,4.3222e-04_r8,5.3334e-04_r8,6.2056e-04_r8, &
     &7.1751e-04_r8,6.6758e-04_r8,3.9067e-04_r8/)
      kao(:, 3, 6, 2) = (/ &
     &1.1323e-05_r8,2.6004e-04_r8,4.1914e-04_r8,5.5855e-04_r8,6.8140e-04_r8,7.8989e-04_r8, &
     &8.8852e-04_r8,8.8775e-04_r8,4.8310e-04_r8/)
      kao(:, 4, 6, 2) = (/ &
     &1.6358e-05_r8,3.4053e-04_r8,5.4044e-04_r8,7.1305e-04_r8,8.6088e-04_r8,9.8765e-04_r8, &
     &1.0974e-03_r8,1.1000e-03_r8,5.7948e-04_r8/)
      kao(:, 5, 6, 2) = (/ &
     &2.3775e-05_r8,4.4089e-04_r8,6.9082e-04_r8,9.0148e-04_r8,1.0783e-03_r8,1.2236e-03_r8, &
     &1.3409e-03_r8,1.3317e-03_r8,6.9627e-04_r8/)
      kao(:, 1, 7, 2) = (/ &
     &8.0091e-06_r8,1.2605e-04_r8,1.9716e-04_r8,2.5635e-04_r8,3.1697e-04_r8,3.6727e-04_r8, &
     &4.1064e-04_r8,4.3234e-04_r8,2.4150e-04_r8/)
      kao(:, 2, 7, 2) = (/ &
     &1.0776e-05_r8,1.7034e-04_r8,2.6589e-04_r8,3.4715e-04_r8,4.2062e-04_r8,4.8583e-04_r8, &
     &5.3757e-04_r8,5.9551e-04_r8,2.9725e-04_r8/)
      kao(:, 3, 7, 2) = (/ &
     &1.5189e-05_r8,2.2959e-04_r8,3.5476e-04_r8,4.5964e-04_r8,5.5426e-04_r8,6.3049e-04_r8, &
     &6.9328e-04_r8,7.3902e-04_r8,3.6802e-04_r8/)
      kao(:, 4, 7, 2) = (/ &
     &2.2007e-05_r8,3.0657e-04_r8,4.6692e-04_r8,5.9983e-04_r8,7.1322e-04_r8,8.0913e-04_r8, &
     &8.7898e-04_r8,9.1398e-04_r8,4.5358e-04_r8/)
      kao(:, 5, 7, 2) = (/ &
     &3.2377e-05_r8,4.0363e-04_r8,6.0728e-04_r8,7.7481e-04_r8,9.1139e-04_r8,1.0238e-03_r8, &
     &1.0988e-03_r8,1.1244e-03_r8,5.4283e-04_r8/)
      kao(:, 1, 8, 2) = (/ &
     &1.3646e-05_r8,1.1718e-04_r8,1.7739e-04_r8,2.2327e-04_r8,2.5768e-04_r8,2.9227e-04_r8, &
     &3.2168e-04_r8,3.3945e-04_r8,2.0435e-04_r8/)
      kao(:, 2, 8, 2) = (/ &
     &1.7797e-05_r8,1.5982e-04_r8,2.4160e-04_r8,3.0351e-04_r8,3.5441e-04_r8,3.9644e-04_r8, &
     &4.3035e-04_r8,4.4547e-04_r8,2.6027e-04_r8/)
      kao(:, 3, 8, 2) = (/ &
     &2.4726e-05_r8,2.1816e-04_r8,3.2650e-04_r8,4.0893e-04_r8,4.7479e-04_r8,5.2784e-04_r8, &
     &5.6990e-04_r8,5.8414e-04_r8,3.2342e-04_r8/)
      kao(:, 4, 8, 2) = (/ &
     &3.5739e-05_r8,2.9719e-04_r8,4.3967e-04_r8,5.4459e-04_r8,6.2961e-04_r8,6.9435e-04_r8, &
     &7.4016e-04_r8,7.4703e-04_r8,3.9508e-04_r8/)
      kao(:, 5, 8, 2) = (/ &
     &5.2993e-05_r8,4.0333e-04_r8,5.8500e-04_r8,7.1845e-04_r8,8.2505e-04_r8,9.0108e-04_r8, &
     &9.4665e-04_r8,9.4587e-04_r8,4.7280e-04_r8/)
      kao(:, 1, 9, 2) = (/ &
     &4.5250e-05_r8,1.4686e-04_r8,2.0230e-04_r8,2.4828e-04_r8,2.8036e-04_r8,2.9801e-04_r8, &
     &2.9921e-04_r8,2.8815e-04_r8,2.4577e-04_r8/)
      kao(:, 2, 9, 2) = (/ &
     &5.6592e-05_r8,2.0110e-04_r8,2.8181e-04_r8,3.4405e-04_r8,3.8167e-04_r8,4.0863e-04_r8, &
     &4.1514e-04_r8,3.9115e-04_r8,3.2441e-04_r8/)
      kao(:, 3, 9, 2) = (/ &
     &7.7017e-05_r8,2.8027e-04_r8,3.9316e-04_r8,4.7187e-04_r8,5.1925e-04_r8,5.5669e-04_r8, &
     &5.6308e-04_r8,5.3177e-04_r8,4.1003e-04_r8/)
      kao(:, 4, 9, 2) = (/ &
     &1.1025e-04_r8,3.9471e-04_r8,5.4612e-04_r8,6.4824e-04_r8,7.1055e-04_r8,7.5245e-04_r8, &
     &7.5557e-04_r8,7.0714e-04_r8,5.0547e-04_r8/)
      kao(:, 5, 9, 2) = (/ &
     &1.6377e-04_r8,5.5266e-04_r8,7.5260e-04_r8,8.8463e-04_r8,9.6217e-04_r8,1.0084e-03_r8, &
     &1.0010e-03_r8,9.2831e-04_r8,5.9992e-04_r8/)
      kao(:, 1,10, 2) = (/ &
     &1.7408e-04_r8,2.8709e-04_r8,3.2527e-04_r8,3.4835e-04_r8,3.5894e-04_r8,3.5919e-04_r8, &
     &3.5263e-04_r8,3.1484e-04_r8,2.7571e-04_r8/)
      kao(:, 2,10, 2) = (/ &
     &2.0961e-04_r8,3.6816e-04_r8,4.3143e-04_r8,4.6881e-04_r8,4.9659e-04_r8,5.0147e-04_r8, &
     &4.9272e-04_r8,4.3339e-04_r8,3.8859e-04_r8/)
      kao(:, 3,10, 2) = (/ &
     &2.7776e-04_r8,5.0192e-04_r8,5.9603e-04_r8,6.5181e-04_r8,6.9357e-04_r8,7.0312e-04_r8, &
     &6.7864e-04_r8,5.9253e-04_r8,5.1467e-04_r8/)
      kao(:, 4,10, 2) = (/ &
     &3.9424e-04_r8,7.1243e-04_r8,8.4498e-04_r8,9.2473e-04_r8,9.7484e-04_r8,9.8216e-04_r8, &
     &9.3644e-04_r8,8.0724e-04_r8,6.5632e-04_r8/)
      kao(:, 5,10, 2) = (/ &
     &5.8403e-04_r8,1.0226e-03_r8,1.2011e-03_r8,1.3089e-03_r8,1.3689e-03_r8,1.3686e-03_r8, &
     &1.2847e-03_r8,1.0916e-03_r8,8.0745e-04_r8/)
      kao(:, 1,11, 2) = (/ &
     &2.5093e-04_r8,3.5665e-04_r8,3.8701e-04_r8,3.9631e-04_r8,3.9372e-04_r8,3.8144e-04_r8, &
     &3.5373e-04_r8,3.1423e-04_r8,3.0104e-04_r8/)
      kao(:, 2,11, 2) = (/ &
     &3.0561e-04_r8,4.5397e-04_r8,5.0521e-04_r8,5.3017e-04_r8,5.3366e-04_r8,5.2816e-04_r8, &
     &4.9620e-04_r8,4.3115e-04_r8,4.1409e-04_r8/)
      kao(:, 3,11, 2) = (/ &
     &4.0935e-04_r8,6.2197e-04_r8,6.9995e-04_r8,7.3845e-04_r8,7.4646e-04_r8,7.4054e-04_r8, &
     &7.0035e-04_r8,5.8985e-04_r8,5.4448e-04_r8/)
      kao(:, 4,11, 2) = (/ &
     &5.8584e-04_r8,8.9030e-04_r8,1.0016e-03_r8,1.0495e-03_r8,1.0645e-03_r8,1.0487e-03_r8, &
     &9.8184e-04_r8,8.1405e-04_r8,6.7706e-04_r8/)
      kao(:, 5,11, 2) = (/ &
     &8.7589e-04_r8,1.3050e-03_r8,1.4464e-03_r8,1.5053e-03_r8,1.5175e-03_r8,1.4779e-03_r8, &
     &1.3691e-03_r8,1.1154e-03_r8,8.3668e-04_r8/)
      kao(:, 1,12, 2) = (/ &
     &2.6981e-04_r8,3.6165e-04_r8,3.8393e-04_r8,3.8621e-04_r8,3.7773e-04_r8,3.5863e-04_r8, &
     &3.2723e-04_r8,2.8136e-04_r8,2.7937e-04_r8/)
      kao(:, 2,12, 2) = (/ &
     &3.3189e-04_r8,4.6172e-04_r8,5.0224e-04_r8,5.1546e-04_r8,5.1134e-04_r8,4.9419e-04_r8, &
     &4.6078e-04_r8,3.9503e-04_r8,3.8165e-04_r8/)
      kao(:, 3,12, 2) = (/ &
     &4.4945e-04_r8,6.3614e-04_r8,7.0015e-04_r8,7.2309e-04_r8,7.1840e-04_r8,6.9882e-04_r8, &
     &6.5062e-04_r8,5.4697e-04_r8,5.0283e-04_r8/)
      kao(:, 4,12, 2) = (/ &
     &6.4949e-04_r8,9.2459e-04_r8,1.0096e-03_r8,1.0404e-03_r8,1.0301e-03_r8,9.9704e-04_r8, &
     &9.2064e-04_r8,7.5726e-04_r8,6.3715e-04_r8/)
      kao(:, 5,12, 2) = (/ &
     &9.7948e-04_r8,1.3695e-03_r8,1.4755e-03_r8,1.5098e-03_r8,1.4823e-03_r8,1.4173e-03_r8, &
     &1.2918e-03_r8,1.0472e-03_r8,7.8120e-04_r8/)
      kao(:, 1,13, 2) = (/ &
     &2.3347e-04_r8,3.0984e-04_r8,3.2740e-04_r8,3.2836e-04_r8,3.1964e-04_r8,3.0307e-04_r8, &
     &2.7562e-04_r8,2.3564e-04_r8,2.3674e-04_r8/)
      kao(:, 2,13, 2) = (/ &
     &2.9027e-04_r8,3.9857e-04_r8,4.3170e-04_r8,4.4144e-04_r8,4.3482e-04_r8,4.1943e-04_r8, &
     &3.8943e-04_r8,3.3194e-04_r8,3.2365e-04_r8/)
      kao(:, 3,13, 2) = (/ &
     &3.9524e-04_r8,5.5472e-04_r8,6.0676e-04_r8,6.2319e-04_r8,6.1597e-04_r8,5.9710e-04_r8, &
     &5.5278e-04_r8,4.6213e-04_r8,4.2552e-04_r8/)
      kao(:, 4,13, 2) = (/ &
     &5.7486e-04_r8,8.1393e-04_r8,8.8216e-04_r8,9.0454e-04_r8,8.9206e-04_r8,8.5566e-04_r8, &
     &7.8499e-04_r8,6.4422e-04_r8,5.3476e-04_r8/)
      kao(:, 5,13, 2) = (/ &
     &8.7246e-04_r8,1.2122e-03_r8,1.2989e-03_r8,1.3221e-03_r8,1.2955e-03_r8,1.2260e-03_r8, &
     &1.1071e-03_r8,8.9174e-04_r8,6.5849e-04_r8/)
      kao(:, 1, 1, 3) = (/ &
     &5.2546e-06_r8,7.1189e-04_r8,1.0882e-03_r8,1.5407e-03_r8,1.6694e-03_r8,2.0484e-03_r8, &
     &2.8523e-03_r8,4.1696e-03_r8,2.5067e-03_r8/)
      kao(:, 2, 1, 3) = (/ &
     &7.7092e-06_r8,8.7649e-04_r8,1.3426e-03_r8,1.8360e-03_r8,2.2345e-03_r8,2.3018e-03_r8, &
     &2.9500e-03_r8,4.8247e-03_r8,2.8678e-03_r8/)
      kao(:, 3, 1, 3) = (/ &
     &1.1096e-05_r8,1.0569e-03_r8,1.6133e-03_r8,2.2145e-03_r8,2.7396e-03_r8,3.0159e-03_r8, &
     &3.2179e-03_r8,5.1113e-03_r8,3.6024e-03_r8/)
      kao(:, 4, 1, 3) = (/ &
     &1.5736e-05_r8,1.2601e-03_r8,1.9380e-03_r8,2.6510e-03_r8,3.2424e-03_r8,3.7893e-03_r8, &
     &3.9992e-03_r8,5.0794e-03_r8,4.4455e-03_r8/)
      kao(:, 5, 1, 3) = (/ &
     &2.1768e-05_r8,1.4881e-03_r8,2.3013e-03_r8,3.1272e-03_r8,3.8505e-03_r8,4.4934e-03_r8, &
     &5.1336e-03_r8,5.8796e-03_r8,5.3642e-03_r8/)
      kao(:, 1, 2, 3) = (/ &
     &6.4189e-06_r8,6.4436e-04_r8,9.4389e-04_r8,1.2239e-03_r8,1.5862e-03_r8,1.5943e-03_r8, &
     &2.1761e-03_r8,2.9768e-03_r8,1.8319e-03_r8/)
      kao(:, 2, 2, 3) = (/ &
     &9.5139e-06_r8,7.9863e-04_r8,1.1748e-03_r8,1.5104e-03_r8,1.9094e-03_r8,2.0876e-03_r8, &
     &2.2172e-03_r8,3.3690e-03_r8,2.2079e-03_r8/)
      kao(:, 3, 2, 3) = (/ &
     &1.3920e-05_r8,9.7738e-04_r8,1.4337e-03_r8,1.8422e-03_r8,2.2904e-03_r8,2.6664e-03_r8, &
     &2.6655e-03_r8,3.3322e-03_r8,2.7973e-03_r8/)
      kao(:, 4, 2, 3) = (/ &
     &1.9815e-05_r8,1.1745e-03_r8,1.7255e-03_r8,2.2150e-03_r8,2.7638e-03_r8,3.1950e-03_r8, &
     &3.5144e-03_r8,3.6601e-03_r8,3.4291e-03_r8/)
      kao(:, 5, 2, 3) = (/ &
     &2.7567e-05_r8,1.3937e-03_r8,2.0553e-03_r8,2.6513e-03_r8,3.2736e-03_r8,3.7952e-03_r8, &
     &4.2837e-03_r8,4.4922e-03_r8,4.1160e-03_r8/)
      kao(:, 1, 3, 3) = (/ &
     &9.6319e-06_r8,5.9789e-04_r8,9.0789e-04_r8,1.1077e-03_r8,1.2525e-03_r8,1.5120e-03_r8, &
     &1.4959e-03_r8,2.1276e-03_r8,1.3456e-03_r8/)
      kao(:, 2, 3, 3) = (/ &
     &1.4531e-05_r8,7.5640e-04_r8,1.1412e-03_r8,1.3989e-03_r8,1.5703e-03_r8,1.7944e-03_r8, &
     &1.9386e-03_r8,2.1696e-03_r8,1.7109e-03_r8/)
      kao(:, 3, 3, 3) = (/ &
     &2.1457e-05_r8,9.3610e-04_r8,1.4115e-03_r8,1.7272e-03_r8,1.9369e-03_r8,2.2003e-03_r8, &
     &2.5012e-03_r8,2.3167e-03_r8,2.1265e-03_r8/)
      kao(:, 4, 3, 3) = (/ &
     &3.1112e-05_r8,1.1388e-03_r8,1.7200e-03_r8,2.0901e-03_r8,2.3590e-03_r8,2.6864e-03_r8, &
     &2.9768e-03_r8,2.9114e-03_r8,2.5844e-03_r8/)
      kao(:, 5, 3, 3) = (/ &
     &4.3735e-05_r8,1.3632e-03_r8,2.0663e-03_r8,2.5031e-03_r8,2.8359e-03_r8,3.2124e-03_r8, &
     &3.5643e-03_r8,3.8138e-03_r8,3.0766e-03_r8/)
      kao(:, 1, 4, 3) = (/ &
     &1.4332e-05_r8,5.0481e-04_r8,8.3885e-04_r8,1.0386e-03_r8,1.1528e-03_r8,1.2153e-03_r8, &
     &1.3236e-03_r8,1.3236e-03_r8,9.9177e-04_r8/)
      kao(:, 2, 4, 3) = (/ &
     &2.1745e-05_r8,6.5797e-04_r8,1.0771e-03_r8,1.3282e-03_r8,1.4860e-03_r8,1.5492e-03_r8, &
     &1.6188e-03_r8,1.5468e-03_r8,1.2757e-03_r8/)
      kao(:, 3, 4, 3) = (/ &
     &3.2667e-05_r8,8.3614e-04_r8,1.3479e-03_r8,1.6673e-03_r8,1.8582e-03_r8,1.9416e-03_r8, &
     &2.0036e-03_r8,2.1024e-03_r8,1.5754e-03_r8/)
      kao(:, 4, 4, 3) = (/ &
     &4.8093e-05_r8,1.0472e-03_r8,1.6541e-03_r8,2.0462e-03_r8,2.2910e-03_r8,2.3927e-03_r8, &
     &2.4569e-03_r8,2.6010e-03_r8,1.9210e-03_r8/)
      kao(:, 5, 4, 3) = (/ &
     &6.8610e-05_r8,1.2933e-03_r8,1.9995e-03_r8,2.4752e-03_r8,2.7858e-03_r8,2.9107e-03_r8, &
     &2.9847e-03_r8,3.0912e-03_r8,2.3242e-03_r8/)
      kao(:, 1, 5, 3) = (/ &
     &1.9357e-05_r8,4.3188e-04_r8,6.9760e-04_r8,9.1881e-04_r8,1.0444e-03_r8,1.0861e-03_r8, &
     &1.0808e-03_r8,1.0528e-03_r8,7.6202e-04_r8/)
      kao(:, 2, 5, 3) = (/ &
     &2.9833e-05_r8,5.6548e-04_r8,9.1440e-04_r8,1.2005e-03_r8,1.3604e-03_r8,1.4256e-03_r8, &
     &1.3945e-03_r8,1.3872e-03_r8,9.4421e-04_r8/)
      kao(:, 3, 5, 3) = (/ &
     &4.5578e-05_r8,7.2730e-04_r8,1.1762e-03_r8,1.5269e-03_r8,1.7329e-03_r8,1.8168e-03_r8, &
     &1.7751e-03_r8,1.6935e-03_r8,1.1652e-03_r8/)
      kao(:, 4, 5, 3) = (/ &
     &6.7915e-05_r8,9.2227e-04_r8,1.4839e-03_r8,1.8964e-03_r8,2.1540e-03_r8,2.2580e-03_r8, &
     &2.2284e-03_r8,2.0768e-03_r8,1.4187e-03_r8/)
      kao(:, 5, 5, 3) = (/ &
     &9.8232e-05_r8,1.1614e-03_r8,1.8417e-03_r8,2.3162e-03_r8,2.6333e-03_r8,2.7678e-03_r8, &
     &2.7278e-03_r8,2.5343e-03_r8,1.7135e-03_r8/)
      kao(:, 1, 6, 3) = (/ &
     &2.4087e-05_r8,3.6023e-04_r8,5.7620e-04_r8,7.4775e-04_r8,8.9007e-04_r8,9.5429e-04_r8, &
     &9.1764e-04_r8,8.4636e-04_r8,5.7959e-04_r8/)
      kao(:, 2, 6, 3) = (/ &
     &3.7139e-05_r8,4.8232e-04_r8,7.6564e-04_r8,9.9341e-04_r8,1.1781e-03_r8,1.2665e-03_r8, &
     &1.2330e-03_r8,1.0918e-03_r8,7.2688e-04_r8/)
      kao(:, 3, 6, 3) = (/ &
     &5.7836e-05_r8,6.3457e-04_r8,9.9482e-04_r8,1.2902e-03_r8,1.5235e-03_r8,1.6284e-03_r8, &
     &1.5983e-03_r8,1.4005e-03_r8,8.9110e-04_r8/)
      kao(:, 4, 6, 3) = (/ &
     &8.7827e-05_r8,8.3029e-04_r8,1.2776e-03_r8,1.6365e-03_r8,1.9214e-03_r8,2.0538e-03_r8, &
     &2.0181e-03_r8,1.7675e-03_r8,1.0912e-03_r8/)
      kao(:, 5, 6, 3) = (/ &
     &1.2951e-04_r8,1.0725e-03_r8,1.6206e-03_r8,2.0554e-03_r8,2.3768e-03_r8,2.5369e-03_r8, &
     &2.5004e-03_r8,2.2047e-03_r8,1.3222e-03_r8/)
      kao(:, 1, 7, 3) = (/ &
     &3.1610e-05_r8,3.0736e-04_r8,4.8099e-04_r8,6.1875e-04_r8,7.2425e-04_r8,8.0714e-04_r8, &
     &8.2765e-04_r8,7.1397e-04_r8,4.2627e-04_r8/)
      kao(:, 2, 7, 3) = (/ &
     &4.8734e-05_r8,4.2352e-04_r8,6.5473e-04_r8,8.3909e-04_r8,9.8036e-04_r8,1.0919e-03_r8, &
     &1.1195e-03_r8,9.5621e-04_r8,5.5009e-04_r8/)
      kao(:, 3, 7, 3) = (/ &
     &7.5777e-05_r8,5.7189e-04_r8,8.6982e-04_r8,1.1085e-03_r8,1.2941e-03_r8,1.4332e-03_r8, &
     &1.4595e-03_r8,1.2666e-03_r8,6.8930e-04_r8/)
      kao(:, 4, 7, 3) = (/ &
     &1.1758e-04_r8,7.6635e-04_r8,1.1428e-03_r8,1.4431e-03_r8,1.6723e-03_r8,1.8359e-03_r8, &
     &1.8555e-03_r8,1.6214e-03_r8,8.4503e-04_r8/)
      kao(:, 5, 7, 3) = (/ &
     &1.7719e-04_r8,1.0176e-03_r8,1.4892e-03_r8,1.8529e-03_r8,2.1284e-03_r8,2.3074e-03_r8, &
     &2.3192e-03_r8,2.0277e-03_r8,1.0269e-03_r8/)
      kao(:, 1, 8, 3) = (/ &
     &5.0016e-05_r8,3.0350e-04_r8,4.3130e-04_r8,5.4117e-04_r8,6.2740e-04_r8,6.8603e-04_r8, &
     &7.1531e-04_r8,6.7206e-04_r8,3.4534e-04_r8/)
      kao(:, 2, 8, 3) = (/ &
     &7.6305e-05_r8,4.2110e-04_r8,6.0202e-04_r8,7.5262e-04_r8,8.6967e-04_r8,9.4998e-04_r8, &
     &9.8539e-04_r8,9.2682e-04_r8,4.4615e-04_r8/)
      kao(:, 3, 8, 3) = (/ &
     &1.1911e-04_r8,5.8304e-04_r8,8.2209e-04_r8,1.0213e-03_r8,1.1738e-03_r8,1.2774e-03_r8, &
     &1.3191e-03_r8,1.2307e-03_r8,5.5948e-04_r8/)
      kao(:, 4, 8, 3) = (/ &
     &1.8649e-04_r8,7.9923e-04_r8,1.1102e-03_r8,1.3602e-03_r8,1.5530e-03_r8,1.6805e-03_r8, &
     &1.7288e-03_r8,1.5932e-03_r8,6.8951e-04_r8/)
      kao(:, 5, 8, 3) = (/ &
     &2.8664e-04_r8,1.0891e-03_r8,1.4894e-03_r8,1.7956e-03_r8,2.0238e-03_r8,2.1795e-03_r8, &
     &2.2144e-03_r8,2.0105e-03_r8,8.3262e-04_r8/)
      kao(:, 1, 9, 3) = (/ &
     &1.5293e-04_r8,4.6711e-04_r8,5.9429e-04_r8,6.7143e-04_r8,7.0270e-04_r8,7.2578e-04_r8, &
     &7.2031e-04_r8,6.7023e-04_r8,4.6857e-04_r8/)
      kao(:, 2, 9, 3) = (/ &
     &2.2743e-04_r8,6.5435e-04_r8,8.3260e-04_r8,9.2221e-04_r8,9.8476e-04_r8,1.0204e-03_r8, &
     &1.0235e-03_r8,9.4955e-04_r8,5.6708e-04_r8/)
      kao(:, 3, 9, 3) = (/ &
     &3.5601e-04_r8,9.4855e-04_r8,1.1602e-03_r8,1.2875e-03_r8,1.3640e-03_r8,1.4067e-03_r8, &
     &1.4070e-03_r8,1.3032e-03_r8,6.4714e-04_r8/)
      kao(:, 4, 9, 3) = (/ &
     &5.5911e-04_r8,1.3606e-03_r8,1.6272e-03_r8,1.7782e-03_r8,1.8671e-03_r8,1.9159e-03_r8, &
     &1.8899e-03_r8,1.7374e-03_r8,7.3858e-04_r8/)
      kao(:, 5, 9, 3) = (/ &
     &8.7081e-04_r8,1.9356e-03_r8,2.2669e-03_r8,2.4429e-03_r8,2.5498e-03_r8,2.5834e-03_r8, &
     &2.5150e-03_r8,2.2763e-03_r8,8.7139e-04_r8/)
      kao(:, 1,10, 3) = (/ &
     &5.5025e-04_r8,9.1638e-04_r8,1.0524e-03_r8,1.1151e-03_r8,1.1173e-03_r8,1.0672e-03_r8, &
     &9.7649e-04_r8,7.7345e-04_r8,6.5002e-04_r8/)
      kao(:, 2,10, 3) = (/ &
     &7.9126e-04_r8,1.3002e-03_r8,1.4860e-03_r8,1.5598e-03_r8,1.5441e-03_r8,1.5015e-03_r8, &
     &1.3399e-03_r8,1.0909e-03_r8,8.3499e-04_r8/)
      kao(:, 3,10, 3) = (/ &
     &1.2237e-03_r8,1.9321e-03_r8,2.1587e-03_r8,2.2526e-03_r8,2.2235e-03_r8,2.1040e-03_r8, &
     &1.8744e-03_r8,1.5238e-03_r8,1.0298e-03_r8/)
      kao(:, 4,10, 3) = (/ &
     &1.9295e-03_r8,2.9068e-03_r8,3.1939e-03_r8,3.2884e-03_r8,3.1828e-03_r8,2.9739e-03_r8, &
     &2.6100e-03_r8,2.0967e-03_r8,1.2389e-03_r8/)
      kao(:, 5,10, 3) = (/ &
     &3.0420e-03_r8,4.3560e-03_r8,4.6911e-03_r8,4.7252e-03_r8,4.5246e-03_r8,4.1666e-03_r8, &
     &3.6292e-03_r8,2.8608e-03_r8,1.4677e-03_r8/)
      kao(:, 1,11, 3) = (/ &
     &8.0124e-04_r8,1.1600e-03_r8,1.2577e-03_r8,1.2913e-03_r8,1.2758e-03_r8,1.1948e-03_r8, &
     &1.0607e-03_r8,8.2464e-04_r8,6.8579e-04_r8/)
      kao(:, 2,11, 3) = (/ &
     &1.1673e-03_r8,1.6642e-03_r8,1.8003e-03_r8,1.8395e-03_r8,1.7987e-03_r8,1.6759e-03_r8, &
     &1.4977e-03_r8,1.1597e-03_r8,8.7714e-04_r8/)
      kao(:, 3,11, 3) = (/ &
     &1.8208e-03_r8,2.5072e-03_r8,2.6736e-03_r8,2.6935e-03_r8,2.6255e-03_r8,2.4196e-03_r8, &
     &2.1072e-03_r8,1.6350e-03_r8,1.1070e-03_r8/)
      kao(:, 4,11, 3) = (/ &
     &2.8872e-03_r8,3.8298e-03_r8,4.0028e-03_r8,4.0090e-03_r8,3.8400e-03_r8,3.4828e-03_r8, &
     &2.9827e-03_r8,2.2825e-03_r8,1.3306e-03_r8/)
      kao(:, 5,11, 3) = (/ &
     &4.5758e-03_r8,5.8214e-03_r8,5.9954e-03_r8,5.8806e-03_r8,5.5457e-03_r8,4.9671e-03_r8, &
     &4.1979e-03_r8,3.1537e-03_r8,1.5896e-03_r8/)
      kao(:, 1,12, 3) = (/ &
     &8.6957e-04_r8,1.1918e-03_r8,1.2597e-03_r8,1.2688e-03_r8,1.2375e-03_r8,1.1513e-03_r8, &
     &1.0110e-03_r8,7.8620e-04_r8,6.6607e-04_r8/)
      kao(:, 2,12, 3) = (/ &
     &1.2841e-03_r8,1.7262e-03_r8,1.8227e-03_r8,1.8310e-03_r8,1.7702e-03_r8,1.6364e-03_r8, &
     &1.4379e-03_r8,1.0990e-03_r8,8.6314e-04_r8/)
      kao(:, 3,12, 3) = (/ &
     &2.0183e-03_r8,2.6229e-03_r8,2.7286e-03_r8,2.7135e-03_r8,2.6112e-03_r8,2.3987e-03_r8, &
     &2.0472e-03_r8,1.5496e-03_r8,1.0681e-03_r8/)
      kao(:, 4,12, 3) = (/ &
     &3.2212e-03_r8,4.0504e-03_r8,4.1472e-03_r8,4.0702e-03_r8,3.8583e-03_r8,3.4748e-03_r8, &
     &2.9262e-03_r8,2.1914e-03_r8,1.2601e-03_r8/)
      kao(:, 5,12, 3) = (/ &
     &5.1511e-03_r8,6.2196e-03_r8,6.2591e-03_r8,6.0402e-03_r8,5.6302e-03_r8,4.9946e-03_r8, &
     &4.1641e-03_r8,3.0581e-03_r8,1.4932e-03_r8/)
      kao(:, 1,13, 3) = (/ &
     &7.5570e-04_r8,1.0245e-03_r8,1.0772e-03_r8,1.0860e-03_r8,1.0524e-03_r8,9.7557e-04_r8, &
     &8.5610e-04_r8,6.6220e-04_r8,5.7960e-04_r8/)
      kao(:, 2,13, 3) = (/ &
     &1.1289e-03_r8,1.4995e-03_r8,1.5736e-03_r8,1.5761e-03_r8,1.5191e-03_r8,1.4055e-03_r8, &
     &1.2213e-03_r8,9.3390e-04_r8,7.5295e-04_r8/)
      kao(:, 3,13, 3) = (/ &
     &1.7891e-03_r8,2.2942e-03_r8,2.3709e-03_r8,2.3513e-03_r8,2.2646e-03_r8,2.0616e-03_r8, &
     &1.7545e-03_r8,1.3283e-03_r8,9.2119e-04_r8/)
      kao(:, 4,13, 3) = (/ &
     &2.8872e-03_r8,3.5675e-03_r8,3.6372e-03_r8,3.5628e-03_r8,3.3407e-03_r8,3.0031e-03_r8, &
     &2.5207e-03_r8,1.8863e-03_r8,1.0888e-03_r8/)
      kao(:, 5,13, 3) = (/ &
     &4.6509e-03_r8,5.5327e-03_r8,5.4994e-03_r8,5.2862e-03_r8,4.8993e-03_r8,4.3534e-03_r8, &
     &3.6092e-03_r8,2.6447e-03_r8,1.2715e-03_r8/)
      kao(:, 1, 1, 4) = (/ &
     &2.0197e-05_r8,1.1667e-03_r8,1.8703e-03_r8,2.3597e-03_r8,2.8442e-03_r8,3.3004e-03_r8, &
     &3.9209e-03_r8,5.1050e-03_r8,4.4032e-03_r8/)
      kao(:, 2, 1, 4) = (/ &
     &2.9878e-05_r8,1.4283e-03_r8,2.2934e-03_r8,2.9621e-03_r8,3.4763e-03_r8,4.1665e-03_r8, &
     &4.8948e-03_r8,5.8620e-03_r8,5.4661e-03_r8/)
      kao(:, 3, 1, 4) = (/ &
     &4.2867e-05_r8,1.7152e-03_r8,2.7742e-03_r8,3.5744e-03_r8,4.2361e-03_r8,5.0272e-03_r8, &
     &5.9642e-03_r8,7.9378e-03_r8,6.6044e-03_r8/)
      kao(:, 4, 1, 4) = (/ &
     &5.9869e-05_r8,2.0335e-03_r8,3.2827e-03_r8,4.2442e-03_r8,5.1046e-03_r8,5.9179e-03_r8, &
     &7.1401e-03_r8,9.6601e-03_r8,7.8490e-03_r8/)
      kao(:, 5, 1, 4) = (/ &
     &8.1517e-05_r8,2.3834e-03_r8,3.8440e-03_r8,4.9959e-03_r8,6.0214e-03_r8,7.0692e-03_r8, &
     &8.4265e-03_r8,1.1443e-02_r8,9.2888e-03_r8/)
      kao(:, 1, 2, 4) = (/ &
     &2.5366e-05_r8,1.0671e-03_r8,1.6131e-03_r8,2.1123e-03_r8,2.3685e-03_r8,2.7185e-03_r8, &
     &3.0418e-03_r8,3.4879e-03_r8,3.3143e-03_r8/)
      kao(:, 2, 2, 4) = (/ &
     &3.7671e-05_r8,1.3088e-03_r8,2.0014e-03_r8,2.6106e-03_r8,3.0312e-03_r8,3.3873e-03_r8, &
     &3.9017e-03_r8,4.5215e-03_r8,4.1143e-03_r8/)
      kao(:, 3, 2, 4) = (/ &
     &5.4541e-05_r8,1.5795e-03_r8,2.4306e-03_r8,3.1726e-03_r8,3.7137e-03_r8,4.1208e-03_r8, &
     &4.7737e-03_r8,5.7376e-03_r8,4.9901e-03_r8/)
      kao(:, 4, 2, 4) = (/ &
     &7.7056e-05_r8,1.8857e-03_r8,2.9009e-03_r8,3.7836e-03_r8,4.4364e-03_r8,5.0235e-03_r8, &
     &5.6427e-03_r8,6.9365e-03_r8,5.9848e-03_r8/)
      kao(:, 5, 2, 4) = (/ &
     &1.0566e-04_r8,2.2344e-03_r8,3.4137e-03_r8,4.4552e-03_r8,5.2671e-03_r8,5.9853e-03_r8, &
     &6.7249e-03_r8,8.2397e-03_r8,7.1296e-03_r8/)
      kao(:, 1, 3, 4) = (/ &
     &3.9558e-05_r8,1.0742e-03_r8,1.5248e-03_r8,1.8501e-03_r8,2.1830e-03_r8,2.3261e-03_r8, &
     &2.4391e-03_r8,2.5890e-03_r8,2.3829e-03_r8/)
      kao(:, 2, 3, 4) = (/ &
     &5.9594e-05_r8,1.3476e-03_r8,1.8940e-03_r8,2.3182e-03_r8,2.7486e-03_r8,3.0410e-03_r8, &
     &3.0839e-03_r8,3.3287e-03_r8,2.9662e-03_r8/)
      kao(:, 3, 3, 4) = (/ &
     &8.7495e-05_r8,1.6651e-03_r8,2.3108e-03_r8,2.8515e-03_r8,3.3798e-03_r8,3.7359e-03_r8, &
     &3.8327e-03_r8,4.1905e-03_r8,3.5949e-03_r8/)
      kao(:, 4, 3, 4) = (/ &
     &1.2450e-04_r8,2.0293e-03_r8,2.7849e-03_r8,3.4502e-03_r8,4.0760e-03_r8,4.5002e-03_r8, &
     &4.7432e-03_r8,5.0708e-03_r8,4.3551e-03_r8/)
      kao(:, 5, 3, 4) = (/ &
     &1.7405e-04_r8,2.4316e-03_r8,3.3182e-03_r8,4.1142e-03_r8,4.8387e-03_r8,5.3673e-03_r8, &
     &5.6716e-03_r8,6.0036e-03_r8,5.2554e-03_r8/)
      kao(:, 1, 4, 4) = (/ &
     &6.0993e-05_r8,1.0865e-03_r8,1.5064e-03_r8,1.7956e-03_r8,1.9492e-03_r8,2.0758e-03_r8, &
     &2.1376e-03_r8,1.9974e-03_r8,1.7194e-03_r8/)
      kao(:, 2, 4, 4) = (/ &
     &9.3739e-05_r8,1.3938e-03_r8,1.9090e-03_r8,2.2655e-03_r8,2.4714e-03_r8,2.6468e-03_r8, &
     &2.7998e-03_r8,2.5993e-03_r8,2.1766e-03_r8/)
      kao(:, 3, 4, 4) = (/ &
     &1.3999e-04_r8,1.7512e-03_r8,2.3888e-03_r8,2.8018e-03_r8,3.0687e-03_r8,3.3097e-03_r8, &
     &3.4825e-03_r8,3.2297e-03_r8,2.6912e-03_r8/)
      kao(:, 4, 4, 4) = (/ &
     &2.0284e-04_r8,2.1576e-03_r8,2.9507e-03_r8,3.4179e-03_r8,3.7408e-03_r8,4.0628e-03_r8, &
     &4.2589e-03_r8,4.0554e-03_r8,3.2822e-03_r8/)
      kao(:, 5, 4, 4) = (/ &
     &2.8653e-04_r8,2.6101e-03_r8,3.5917e-03_r8,4.1189e-03_r8,4.5031e-03_r8,4.8876e-03_r8, &
     &5.1085e-03_r8,4.9728e-03_r8,3.9394e-03_r8/)
      kao(:, 1, 5, 4) = (/ &
     &8.6213e-05_r8,1.0235e-03_r8,1.4463e-03_r8,1.6932e-03_r8,1.8586e-03_r8,1.8899e-03_r8, &
     &1.8325e-03_r8,1.6931e-03_r8,1.2167e-03_r8/)
      kao(:, 2, 5, 4) = (/ &
     &1.3497e-04_r8,1.3639e-03_r8,1.8867e-03_r8,2.1813e-03_r8,2.3731e-03_r8,2.4352e-03_r8, &
     &2.3757e-03_r8,2.2169e-03_r8,1.5707e-03_r8/)
      kao(:, 3, 5, 4) = (/ &
     &2.0469e-04_r8,1.7684e-03_r8,2.3970e-03_r8,2.7679e-03_r8,2.9816e-03_r8,3.0549e-03_r8, &
     &3.0098e-03_r8,2.8798e-03_r8,1.9802e-03_r8/)
      kao(:, 4, 5, 4) = (/ &
     &3.0118e-04_r8,2.2412e-03_r8,2.9952e-03_r8,3.4514e-03_r8,3.7055e-03_r8,3.7675e-03_r8, &
     &3.7358e-03_r8,3.5681e-03_r8,2.4524e-03_r8/)
      kao(:, 5, 5, 4) = (/ &
     &4.3178e-04_r8,2.7692e-03_r8,3.6699e-03_r8,4.2507e-03_r8,4.5341e-03_r8,4.5904e-03_r8, &
     &4.5606e-03_r8,4.3497e-03_r8,2.9904e-03_r8/)
      kao(:, 1, 6, 4) = (/ &
     &1.1224e-04_r8,9.6248e-04_r8,1.3486e-03_r8,1.5651e-03_r8,1.6739e-03_r8,1.7217e-03_r8, &
     &1.6200e-03_r8,1.3812e-03_r8,9.3024e-04_r8/)
      kao(:, 2, 6, 4) = (/ &
     &1.7788e-04_r8,1.2979e-03_r8,1.7963e-03_r8,2.0621e-03_r8,2.2013e-03_r8,2.2377e-03_r8, &
     &2.1278e-03_r8,1.8809e-03_r8,1.2042e-03_r8/)
      kao(:, 3, 6, 4) = (/ &
     &2.7340e-04_r8,1.7148e-03_r8,2.3323e-03_r8,2.6619e-03_r8,2.8238e-03_r8,2.8631e-03_r8, &
     &2.7284e-03_r8,2.4183e-03_r8,1.5217e-03_r8/)
      kao(:, 4, 6, 4) = (/ &
     &4.0959e-04_r8,2.2331e-03_r8,2.9678e-03_r8,3.3799e-03_r8,3.5736e-03_r8,3.5928e-03_r8, &
     &3.4271e-03_r8,3.0552e-03_r8,1.8843e-03_r8/)
      kao(:, 5, 6, 4) = (/ &
     &5.9620e-04_r8,2.8328e-03_r8,3.7008e-03_r8,4.1972e-03_r8,4.4330e-03_r8,4.4525e-03_r8, &
     &4.2185e-03_r8,3.7711e-03_r8,2.2988e-03_r8/)
      kao(:, 1, 7, 4) = (/ &
     &1.5344e-04_r8,9.2316e-04_r8,1.2773e-03_r8,1.5000e-03_r8,1.6102e-03_r8,1.6127e-03_r8, &
     &1.5115e-03_r8,1.2377e-03_r8,7.0764e-04_r8/)
      kao(:, 2, 7, 4) = (/ &
     &2.4398e-04_r8,1.2809e-03_r8,1.7477e-03_r8,2.0347e-03_r8,2.1522e-03_r8,2.1311e-03_r8, &
     &1.9950e-03_r8,1.6669e-03_r8,9.1774e-04_r8/)
      kao(:, 3, 7, 4) = (/ &
     &3.8058e-04_r8,1.7477e-03_r8,2.3440e-03_r8,2.6829e-03_r8,2.8039e-03_r8,2.7555e-03_r8, &
     &2.5876e-03_r8,2.1763e-03_r8,1.1586e-03_r8/)
      kao(:, 4, 7, 4) = (/ &
     &5.7739e-04_r8,2.3349e-03_r8,3.0698e-03_r8,3.4470e-03_r8,3.5790e-03_r8,3.5331e-03_r8, &
     &3.3054e-03_r8,2.7805e-03_r8,1.4458e-03_r8/)
      kao(:, 5, 7, 4) = (/ &
     &8.5208e-04_r8,3.0383e-03_r8,3.9002e-03_r8,4.3347e-03_r8,4.5004e-03_r8,4.4415e-03_r8, &
     &4.1236e-03_r8,3.4788e-03_r8,1.7825e-03_r8/)
      kao(:, 1, 8, 4) = (/ &
     &2.5035e-04_r8,9.8089e-04_r8,1.3026e-03_r8,1.5173e-03_r8,1.6357e-03_r8,1.6535e-03_r8, &
     &1.5386e-03_r8,1.2613e-03_r8,5.4812e-04_r8/)
      kao(:, 2, 8, 4) = (/ &
     &3.9983e-04_r8,1.4074e-03_r8,1.8431e-03_r8,2.1183e-03_r8,2.2695e-03_r8,2.2610e-03_r8, &
     &2.0892e-03_r8,1.6966e-03_r8,7.0487e-04_r8/)
      kao(:, 3, 8, 4) = (/ &
     &6.2524e-04_r8,1.9883e-03_r8,2.5535e-03_r8,2.8971e-03_r8,3.0599e-03_r8,3.0259e-03_r8, &
     &2.7534e-03_r8,2.2128e-03_r8,8.9347e-04_r8/)
      kao(:, 4, 8, 4) = (/ &
     &9.6475e-04_r8,2.7489e-03_r8,3.4725e-03_r8,3.8856e-03_r8,4.0355e-03_r8,3.9357e-03_r8, &
     &3.5484e-03_r8,2.8450e-03_r8,1.1141e-03_r8/)
      kao(:, 5, 8, 4) = (/ &
     &1.4492e-03_r8,3.7234e-03_r8,4.6023e-03_r8,5.0761e-03_r8,5.1898e-03_r8,5.0041e-03_r8, &
     &4.4962e-03_r8,3.6082e-03_r8,1.3876e-03_r8/)
      kao(:, 1, 9, 4) = (/ &
     &7.7717e-04_r8,1.6076e-03_r8,1.9327e-03_r8,2.0950e-03_r8,2.1727e-03_r8,2.1507e-03_r8, &
     &2.0239e-03_r8,1.6619e-03_r8,6.5283e-04_r8/)
      kao(:, 2, 9, 4) = (/ &
     &1.2257e-03_r8,2.4216e-03_r8,2.8205e-03_r8,3.0706e-03_r8,3.1558e-03_r8,3.0893e-03_r8, &
     &2.8639e-03_r8,2.3215e-03_r8,8.1326e-04_r8/)
      kao(:, 3, 9, 4) = (/ &
     &1.9258e-03_r8,3.5788e-03_r8,4.1331e-03_r8,4.4121e-03_r8,4.4825e-03_r8,4.3456e-03_r8, &
     &3.9751e-03_r8,3.1546e-03_r8,1.0072e-03_r8/)
      kao(:, 4, 9, 4) = (/ &
     &3.0058e-03_r8,5.1816e-03_r8,5.8926e-03_r8,6.2133e-03_r8,6.2513e-03_r8,5.9943e-03_r8, &
     &5.4160e-03_r8,4.1735e-03_r8,1.2133e-03_r8/)
      kao(:, 5, 9, 4) = (/ &
     &4.5860e-03_r8,7.3561e-03_r8,8.1694e-03_r8,8.5315e-03_r8,8.5009e-03_r8,8.0696e-03_r8, &
     &7.1597e-03_r8,5.3914e-03_r8,1.4524e-03_r8/)
      kao(:, 1,10, 4) = (/ &
     &2.7632e-03_r8,3.7578e-03_r8,3.8929e-03_r8,3.8648e-03_r8,3.7150e-03_r8,3.4386e-03_r8, &
     &2.9824e-03_r8,2.3042e-03_r8,1.1595e-03_r8/)
      kao(:, 2,10, 4) = (/ &
     &4.3618e-03_r8,5.8439e-03_r8,6.0237e-03_r8,5.9173e-03_r8,5.6198e-03_r8,5.0739e-03_r8, &
     &4.3966e-03_r8,3.3846e-03_r8,1.3310e-03_r8/)
      kao(:, 3,10, 4) = (/ &
     &6.8076e-03_r8,8.8616e-03_r8,9.0867e-03_r8,8.8297e-03_r8,8.2980e-03_r8,7.5120e-03_r8, &
     &6.4366e-03_r8,4.8357e-03_r8,1.4427e-03_r8/)
      kao(:, 4,10, 4) = (/ &
     &1.0727e-02_r8,1.3247e-02_r8,1.3386e-02_r8,1.2895e-02_r8,1.2079e-02_r8,1.0841e-02_r8, &
     &9.1826e-03_r8,6.8074e-03_r8,1.5623e-03_r8/)
      kao(:, 5,10, 4) = (/ &
     &1.6578e-02_r8,1.9641e-02_r8,1.9517e-02_r8,1.8627e-02_r8,1.7184e-02_r8,1.5227e-02_r8, &
     &1.2710e-02_r8,9.3140e-03_r8,1.8266e-03_r8/)
      kao(:, 1,11, 4) = (/ &
     &4.3397e-03_r8,5.2633e-03_r8,5.2314e-03_r8,5.0017e-03_r8,4.6314e-03_r8,4.1308e-03_r8, &
     &3.4621e-03_r8,2.5597e-03_r8,1.2582e-03_r8/)
      kao(:, 2,11, 4) = (/ &
     &6.6934e-03_r8,8.1477e-03_r8,8.0949e-03_r8,7.7188e-03_r8,7.1188e-03_r8,6.2977e-03_r8, &
     &5.1713e-03_r8,3.7779e-03_r8,1.4574e-03_r8/)
      kao(:, 3,11, 4) = (/ &
     &1.0432e-02_r8,1.2428e-02_r8,1.2196e-02_r8,1.1560e-02_r8,1.0566e-02_r8,9.2464e-03_r8, &
     &7.6156e-03_r8,5.5141e-03_r8,1.6582e-03_r8/)
      kao(:, 4,11, 4) = (/ &
     &1.6491e-02_r8,1.8759e-02_r8,1.8258e-02_r8,1.7109e-02_r8,1.5472e-02_r8,1.3463e-02_r8, &
     &1.0963e-02_r8,7.7973e-03_r8,1.8335e-03_r8/)
      kao(:, 5,11, 4) = (/ &
     &2.5430e-02_r8,2.8078e-02_r8,2.7002e-02_r8,2.5032e-02_r8,2.2392e-02_r8,1.9261e-02_r8, &
     &1.5474e-02_r8,1.0784e-02_r8,2.0075e-03_r8/)
      kao(:, 1,12, 4) = (/ &
     &4.9273e-03_r8,5.7931e-03_r8,5.6746e-03_r8,5.3611e-03_r8,4.8847e-03_r8,4.2709e-03_r8, &
     &3.4855e-03_r8,2.4889e-03_r8,1.1526e-03_r8/)
      kao(:, 2,12, 4) = (/ &
     &7.6884e-03_r8,8.9132e-03_r8,8.6777e-03_r8,8.1782e-03_r8,7.4327e-03_r8,6.4648e-03_r8, &
     &5.2372e-03_r8,3.6981e-03_r8,1.3373e-03_r8/)
      kao(:, 3,12, 4) = (/ &
     &1.2107e-02_r8,1.3711e-02_r8,1.3177e-02_r8,1.2250e-02_r8,1.1036e-02_r8,9.5160e-03_r8, &
     &7.6801e-03_r8,5.4155e-03_r8,1.5194e-03_r8/)
      kao(:, 4,12, 4) = (/ &
     &1.8869e-02_r8,2.0811e-02_r8,1.9833e-02_r8,1.8325e-02_r8,1.6361e-02_r8,1.3983e-02_r8, &
     &1.1160e-02_r8,7.6837e-03_r8,1.7468e-03_r8/)
      kao(:, 5,12, 4) = (/ &
     &2.9063e-02_r8,3.1131e-02_r8,2.9461e-02_r8,2.6993e-02_r8,2.3838e-02_r8,2.0192e-02_r8, &
     &1.5924e-02_r8,1.0737e-02_r8,1.9884e-03_r8/)
      kao(:, 1,13, 4) = (/ &
     &4.3869e-03_r8,5.1798e-03_r8,5.0989e-03_r8,4.8169e-03_r8,4.3794e-03_r8,3.7839e-03_r8, &
     &3.0521e-03_r8,2.1587e-03_r8,9.4784e-04_r8/)
      kao(:, 2,13, 4) = (/ &
     &6.9481e-03_r8,8.0525e-03_r8,7.8458e-03_r8,7.3314e-03_r8,6.6078e-03_r8,5.7100e-03_r8, &
     &4.5663e-03_r8,3.2136e-03_r8,1.0961e-03_r8/)
      kao(:, 3,13, 4) = (/ &
     &1.1021e-02_r8,1.2458e-02_r8,1.1977e-02_r8,1.1021e-02_r8,9.8258e-03_r8,8.4083e-03_r8, &
     &6.7419e-03_r8,4.6947e-03_r8,1.2238e-03_r8/)
      kao(:, 4,13, 4) = (/ &
     &1.7310e-02_r8,1.8923e-02_r8,1.8001e-02_r8,1.6509e-02_r8,1.4657e-02_r8,1.2419e-02_r8, &
     &9.8548e-03_r8,6.6916e-03_r8,1.4326e-03_r8/)
      kao(:, 5,13, 4) = (/ &
     &2.6619e-02_r8,2.8296e-02_r8,2.6623e-02_r8,2.4187e-02_r8,2.1294e-02_r8,1.7939e-02_r8, &
     &1.4103e-02_r8,9.4141e-03_r8,1.6712e-03_r8/)
      kao(:, 1, 1, 5) = (/ &
     &1.5033e-04_r8,2.0446e-03_r8,3.1681e-03_r8,4.0928e-03_r8,4.9645e-03_r8,5.8752e-03_r8, &
     &6.8891e-03_r8,9.7460e-03_r8,8.2375e-03_r8/)
      kao(:, 2, 1, 5) = (/ &
     &2.0389e-04_r8,2.4966e-03_r8,3.8465e-03_r8,4.9929e-03_r8,6.1245e-03_r8,7.2940e-03_r8, &
     &8.7776e-03_r8,1.1499e-02_r8,1.0182e-02_r8/)
      kao(:, 3, 1, 5) = (/ &
     &2.6769e-04_r8,3.0079e-03_r8,4.6076e-03_r8,5.9938e-03_r8,7.3703e-03_r8,8.8250e-03_r8, &
     &1.0916e-02_r8,1.3468e-02_r8,1.2268e-02_r8/)
      kao(:, 4, 1, 5) = (/ &
     &3.4024e-04_r8,3.5831e-03_r8,5.4751e-03_r8,7.1124e-03_r8,8.7423e-03_r8,1.0600e-02_r8, &
     &1.2985e-02_r8,1.6757e-02_r8,1.4652e-02_r8/)
      kao(:, 5, 1, 5) = (/ &
     &4.2020e-04_r8,4.2180e-03_r8,6.4294e-03_r8,8.3453e-03_r8,1.0248e-02_r8,1.2449e-02_r8, &
     &1.5350e-02_r8,1.9955e-02_r8,1.7214e-02_r8/)
      kao(:, 1, 2, 5) = (/ &
     &1.8399e-04_r8,1.8419e-03_r8,2.8498e-03_r8,3.5822e-03_r8,4.2442e-03_r8,4.8814e-03_r8, &
     &5.3141e-03_r8,6.9582e-03_r8,6.1890e-03_r8/)
      kao(:, 2, 2, 5) = (/ &
     &2.5292e-04_r8,2.2771e-03_r8,3.4958e-03_r8,4.3938e-03_r8,5.2283e-03_r8,6.0330e-03_r8, &
     &6.8353e-03_r8,8.0230e-03_r8,7.6976e-03_r8/)
      kao(:, 3, 2, 5) = (/ &
     &3.3540e-04_r8,2.7711e-03_r8,4.2257e-03_r8,5.3109e-03_r8,6.3352e-03_r8,7.3450e-03_r8, &
     &8.3567e-03_r8,1.0142e-02_r8,9.3716e-03_r8/)
      kao(:, 4, 2, 5) = (/ &
     &4.2928e-04_r8,3.3267e-03_r8,5.0595e-03_r8,6.3597e-03_r8,7.5719e-03_r8,8.7753e-03_r8, &
     &1.0137e-02_r8,1.2487e-02_r8,1.1226e-02_r8/)
      kao(:, 5, 2, 5) = (/ &
     &5.3326e-04_r8,3.9397e-03_r8,5.9807e-03_r8,7.5174e-03_r8,8.9383e-03_r8,1.0365e-02_r8, &
     &1.1992e-02_r8,1.4789e-02_r8,1.3251e-02_r8/)
      kao(:, 1, 3, 5) = (/ &
     &2.8126e-04_r8,1.8765e-03_r8,2.6588e-03_r8,3.3485e-03_r8,3.8221e-03_r8,4.1636e-03_r8, &
     &4.4682e-03_r8,4.4846e-03_r8,4.3919e-03_r8/)
      kao(:, 2, 3, 5) = (/ &
     &3.9449e-04_r8,2.3306e-03_r8,3.3231e-03_r8,4.1650e-03_r8,4.7241e-03_r8,5.1684e-03_r8, &
     &5.5884e-03_r8,5.9167e-03_r8,5.5074e-03_r8/)
      kao(:, 3, 3, 5) = (/ &
     &5.3269e-04_r8,2.8500e-03_r8,4.0835e-03_r8,5.0834e-03_r8,5.7677e-03_r8,6.3235e-03_r8, &
     &6.8829e-03_r8,7.4745e-03_r8,6.8347e-03_r8/)
      kao(:, 4, 3, 5) = (/ &
     &6.9304e-04_r8,3.4418e-03_r8,4.9465e-03_r8,6.1263e-03_r8,6.9668e-03_r8,7.6366e-03_r8, &
     &8.3133e-03_r8,9.1010e-03_r8,8.2831e-03_r8/)
      kao(:, 5, 3, 5) = (/ &
     &8.7133e-04_r8,4.1178e-03_r8,5.9088e-03_r8,7.3026e-03_r8,8.3125e-03_r8,9.0996e-03_r8, &
     &9.9113e-03_r8,1.0888e-02_r8,9.8539e-03_r8/)
      kao(:, 1, 4, 5) = (/ &
     &4.2942e-04_r8,2.1209e-03_r8,2.6611e-03_r8,3.0954e-03_r8,3.5092e-03_r8,3.7795e-03_r8, &
     &3.7536e-03_r8,3.6803e-03_r8,3.1833e-03_r8/)
      kao(:, 2, 4, 5) = (/ &
     &6.1278e-04_r8,2.6801e-03_r8,3.3648e-03_r8,3.9108e-03_r8,4.4289e-03_r8,4.7305e-03_r8, &
     &4.7677e-03_r8,4.7187e-03_r8,4.0112e-03_r8/)
      kao(:, 3, 4, 5) = (/ &
     &8.4431e-04_r8,3.3316e-03_r8,4.1648e-03_r8,4.8597e-03_r8,5.4829e-03_r8,5.8484e-03_r8, &
     &5.9135e-03_r8,5.9451e-03_r8,4.9891e-03_r8/)
      kao(:, 4, 4, 5) = (/ &
     &1.1175e-03_r8,4.0506e-03_r8,5.0747e-03_r8,5.9647e-03_r8,6.6966e-03_r8,7.1102e-03_r8, &
     &7.2127e-03_r8,7.2668e-03_r8,6.0794e-03_r8/)
      kao(:, 5, 4, 5) = (/ &
     &1.4334e-03_r8,4.8948e-03_r8,6.1056e-03_r8,7.2069e-03_r8,8.0737e-03_r8,8.5555e-03_r8, &
     &8.6934e-03_r8,8.7560e-03_r8,7.1896e-03_r8/)
      kao(:, 1, 5, 5) = (/ &
     &6.0926e-04_r8,2.3529e-03_r8,2.8355e-03_r8,3.0797e-03_r8,3.2149e-03_r8,3.3400e-03_r8, &
     &3.3910e-03_r8,2.9801e-03_r8,2.2681e-03_r8/)
      kao(:, 2, 5, 5) = (/ &
     &8.8131e-04_r8,3.0196e-03_r8,3.6353e-03_r8,3.9718e-03_r8,4.1316e-03_r8,4.2694e-03_r8, &
     &4.3037e-03_r8,3.9012e-03_r8,2.9392e-03_r8/)
      kao(:, 3, 5, 5) = (/ &
     &1.2303e-03_r8,3.8066e-03_r8,4.5787e-03_r8,4.9631e-03_r8,5.1972e-03_r8,5.3645e-03_r8, &
     &5.3804e-03_r8,4.9263e-03_r8,3.6983e-03_r8/)
      kao(:, 4, 5, 5) = (/ &
     &1.6619e-03_r8,4.7363e-03_r8,5.6662e-03_r8,6.1253e-03_r8,6.4225e-03_r8,6.6560e-03_r8, &
     &6.6051e-03_r8,6.0844e-03_r8,4.5482e-03_r8/)
      kao(:, 5, 5, 5) = (/ &
     &2.1681e-03_r8,5.8273e-03_r8,6.8808e-03_r8,7.4389e-03_r8,7.8269e-03_r8,8.1204e-03_r8, &
     &8.0166e-03_r8,7.4003e-03_r8,5.4950e-03_r8/)
      kao(:, 1, 6, 5) = (/ &
     &8.3319e-04_r8,2.4541e-03_r8,2.9309e-03_r8,3.1239e-03_r8,3.1232e-03_r8,3.0304e-03_r8, &
     &2.8953e-03_r8,2.6232e-03_r8,1.6854e-03_r8/)
      kao(:, 2, 6, 5) = (/ &
     &1.2038e-03_r8,3.2544e-03_r8,3.8397e-03_r8,4.0740e-03_r8,4.0835e-03_r8,3.9879e-03_r8, &
     &3.7753e-03_r8,3.4082e-03_r8,2.1468e-03_r8/)
      kao(:, 3, 6, 5) = (/ &
     &1.6852e-03_r8,4.1990e-03_r8,4.9217e-03_r8,5.1945e-03_r8,5.2325e-03_r8,5.0738e-03_r8, &
     &4.7918e-03_r8,4.2939e-03_r8,2.6825e-03_r8/)
      kao(:, 4, 6, 5) = (/ &
     &2.3055e-03_r8,5.2874e-03_r8,6.1886e-03_r8,6.5148e-03_r8,6.5533e-03_r8,6.3614e-03_r8, &
     &5.9949e-03_r8,5.3440e-03_r8,3.2990e-03_r8/)
      kao(:, 5, 6, 5) = (/ &
     &3.0550e-03_r8,6.5592e-03_r8,7.6795e-03_r8,8.0591e-03_r8,8.0426e-03_r8,7.8256e-03_r8, &
     &7.4185e-03_r8,6.5412e-03_r8,4.0170e-03_r8/)
      kao(:, 1, 7, 5) = (/ &
     &1.2030e-03_r8,2.7895e-03_r8,3.1932e-03_r8,3.3085e-03_r8,3.2497e-03_r8,3.0373e-03_r8, &
     &2.6860e-03_r8,2.2491e-03_r8,1.3507e-03_r8/)
      kao(:, 2, 7, 5) = (/ &
     &1.7561e-03_r8,3.7366e-03_r8,4.1989e-03_r8,4.3780e-03_r8,4.3275e-03_r8,4.0454e-03_r8, &
     &3.5823e-03_r8,2.9962e-03_r8,1.7424e-03_r8/)
      kao(:, 3, 7, 5) = (/ &
     &2.4695e-03_r8,4.8641e-03_r8,5.4890e-03_r8,5.7046e-03_r8,5.6266e-03_r8,5.2456e-03_r8, &
     &4.6755e-03_r8,3.8694e-03_r8,2.1970e-03_r8/)
      kao(:, 4, 7, 5) = (/ &
     &3.4036e-03_r8,6.2572e-03_r8,7.0247e-03_r8,7.3182e-03_r8,7.1220e-03_r8,6.6595e-03_r8, &
     &5.9470e-03_r8,4.8905e-03_r8,2.7089e-03_r8/)
      kao(:, 5, 7, 5) = (/ &
     &4.5461e-03_r8,7.9331e-03_r8,8.8637e-03_r8,9.1326e-03_r8,8.9102e-03_r8,8.3275e-03_r8, &
     &7.4120e-03_r8,6.0989e-03_r8,3.2778e-03_r8/)
      kao(:, 1, 8, 5) = (/ &
     &2.0449e-03_r8,3.7053e-03_r8,4.0860e-03_r8,4.1499e-03_r8,3.9922e-03_r8,3.6227e-03_r8, &
     &3.0421e-03_r8,2.2282e-03_r8,1.0954e-03_r8/)
      kao(:, 2, 8, 5) = (/ &
     &3.0260e-03_r8,5.1232e-03_r8,5.5625e-03_r8,5.5873e-03_r8,5.3321e-03_r8,4.8458e-03_r8, &
     &4.0703e-03_r8,3.0319e-03_r8,1.4218e-03_r8/)
      kao(:, 3, 8, 5) = (/ &
     &4.3499e-03_r8,6.8685e-03_r8,7.3484e-03_r8,7.3183e-03_r8,6.9565e-03_r8,6.3086e-03_r8, &
     &5.3805e-03_r8,3.9991e-03_r8,1.7827e-03_r8/)
      kao(:, 4, 8, 5) = (/ &
     &6.0988e-03_r8,9.0048e-03_r8,9.4728e-03_r8,9.3798e-03_r8,8.9487e-03_r8,8.1669e-03_r8, &
     &6.9162e-03_r8,5.1727e-03_r8,2.2090e-03_r8/)
      kao(:, 5, 8, 5) = (/ &
     &8.2301e-03_r8,1.1592e-02_r8,1.2058e-02_r8,1.1936e-02_r8,1.1386e-02_r8,1.0345e-02_r8, &
     &8.7069e-03_r8,6.5415e-03_r8,2.6879e-03_r8/)
      kao(:, 1, 9, 5) = (/ &
     &6.4341e-03_r8,8.4932e-03_r8,8.6319e-03_r8,8.3108e-03_r8,7.7018e-03_r8,6.7763e-03_r8, &
     &5.5115e-03_r8,3.7767e-03_r8,9.5475e-04_r8/)
      kao(:, 2, 9, 5) = (/ &
     &9.6759e-03_r8,1.2213e-02_r8,1.2266e-02_r8,1.1725e-02_r8,1.0741e-02_r8,9.3855e-03_r8, &
     &7.5654e-03_r8,5.1517e-03_r8,1.1933e-03_r8/)
      kao(:, 3, 9, 5) = (/ &
     &1.4274e-02_r8,1.7116e-02_r8,1.6970e-02_r8,1.6030e-02_r8,1.4545e-02_r8,1.2624e-02_r8, &
     &1.0092e-02_r8,6.8273e-03_r8,1.4956e-03_r8/)
      kao(:, 4, 9, 5) = (/ &
     &2.0348e-02_r8,2.3456e-02_r8,2.2925e-02_r8,2.1415e-02_r8,1.9260e-02_r8,1.6502e-02_r8, &
     &1.3098e-02_r8,8.8597e-03_r8,1.8913e-03_r8/)
      kao(:, 5, 9, 5) = (/ &
     &2.7947e-02_r8,3.1392e-02_r8,3.0350e-02_r8,2.8042e-02_r8,2.4920e-02_r8,2.1171e-02_r8, &
     &1.6720e-02_r8,1.1275e-02_r8,2.3159e-03_r8/)
      kao(:, 1,10, 5) = (/ &
     &2.3218e-02_r8,2.4547e-02_r8,2.3456e-02_r8,2.1452e-02_r8,1.8855e-02_r8,1.5703e-02_r8, &
     &1.2047e-02_r8,7.7884e-03_r8,1.4115e-03_r8/)
      kao(:, 2,10, 5) = (/ &
     &3.5352e-02_r8,3.6479e-02_r8,3.4471e-02_r8,3.1299e-02_r8,2.7239e-02_r8,2.2668e-02_r8, &
     &1.7318e-02_r8,1.0990e-02_r8,1.7428e-03_r8/)
      kao(:, 3,10, 5) = (/ &
     &5.3041e-02_r8,5.3290e-02_r8,4.9753e-02_r8,4.4634e-02_r8,3.8593e-02_r8,3.1830e-02_r8, &
     &2.4004e-02_r8,1.5032e-02_r8,2.1711e-03_r8/)
      kao(:, 4,10, 5) = (/ &
     &7.6819e-02_r8,7.5905e-02_r8,7.0118e-02_r8,6.2386e-02_r8,5.3448e-02_r8,4.3595e-02_r8, &
     &3.2572e-02_r8,2.0010e-02_r8,2.6405e-03_r8/)
      kao(:, 5,10, 5) = (/ &
     &1.0741e-01_r8,1.0446e-01_r8,9.5780e-02_r8,8.4676e-02_r8,7.2117e-02_r8,5.8406e-02_r8, &
     &4.3338e-02_r8,2.6148e-02_r8,3.0152e-03_r8/)
      kao(:, 1,11, 5) = (/ &
     &3.5267e-02_r8,3.5419e-02_r8,3.3018e-02_r8,2.9652e-02_r8,2.5661e-02_r8,2.1081e-02_r8, &
     &1.5812e-02_r8,9.8203e-03_r8,1.5039e-03_r8/)
      kao(:, 2,11, 5) = (/ &
     &5.4088e-02_r8,5.3137e-02_r8,4.9102e-02_r8,4.3719e-02_r8,3.7498e-02_r8,3.0622e-02_r8, &
     &2.2914e-02_r8,1.4036e-02_r8,1.8588e-03_r8/)
      kao(:, 3,11, 5) = (/ &
     &8.1309e-02_r8,7.8515e-02_r8,7.1873e-02_r8,6.3455e-02_r8,5.4008e-02_r8,4.3709e-02_r8, &
     &3.2277e-02_r8,1.9424e-02_r8,2.2498e-03_r8/)
      kao(:, 4,11, 5) = (/ &
     &1.1800e-01_r8,1.1244e-01_r8,1.0217e-01_r8,8.9567e-02_r8,7.5664e-02_r8,6.0559e-02_r8, &
     &4.4387e-02_r8,2.6353e-02_r8,2.7248e-03_r8/)
      kao(:, 5,11, 5) = (/ &
     &1.6472e-01_r8,1.5538e-01_r8,1.4035e-01_r8,1.2265e-01_r8,1.0315e-01_r8,8.2131e-02_r8, &
     &5.9771e-02_r8,3.4979e-02_r8,3.2176e-03_r8/)
      kao(:, 1,12, 5) = (/ &
     &3.9647e-02_r8,3.8955e-02_r8,3.5866e-02_r8,3.1882e-02_r8,2.7372e-02_r8,2.2283e-02_r8, &
     &1.6581e-02_r8,1.0137e-02_r8,1.4428e-03_r8/)
      kao(:, 2,12, 5) = (/ &
     &6.1147e-02_r8,5.9154e-02_r8,5.3991e-02_r8,4.7633e-02_r8,4.0515e-02_r8,3.2821e-02_r8, &
     &2.4231e-02_r8,1.4611e-02_r8,1.7795e-03_r8/)
      kao(:, 3,12, 5) = (/ &
     &9.1962e-02_r8,8.7537e-02_r8,7.9486e-02_r8,6.9739e-02_r8,5.8957e-02_r8,4.7222e-02_r8, &
     &3.4488e-02_r8,2.0425e-02_r8,2.1548e-03_r8/)
      kao(:, 4,12, 5) = (/ &
     &1.3375e-01_r8,1.2593e-01_r8,1.1362e-01_r8,9.8983e-02_r8,8.2938e-02_r8,6.5961e-02_r8, &
     &4.7849e-02_r8,2.7977e-02_r8,2.5823e-03_r8/)
      kao(:, 5,12, 5) = (/ &
     &1.8619e-01_r8,1.7389e-01_r8,1.5614e-01_r8,1.3563e-01_r8,1.1356e-01_r8,8.9900e-02_r8, &
     &6.4743e-02_r8,3.7437e-02_r8,3.0416e-03_r8/)
      kao(:, 1,13, 5) = (/ &
     &3.5348e-02_r8,3.4594e-02_r8,3.1651e-02_r8,2.8032e-02_r8,2.3972e-02_r8,1.9476e-02_r8, &
     &1.4520e-02_r8,8.8483e-03_r8,1.2073e-03_r8/)
      kao(:, 2,13, 5) = (/ &
     &5.4657e-02_r8,5.2717e-02_r8,4.7880e-02_r8,4.2169e-02_r8,3.5919e-02_r8,2.9028e-02_r8, &
     &2.1424e-02_r8,1.2832e-02_r8,1.4997e-03_r8/)
      kao(:, 3,13, 5) = (/ &
     &8.2593e-02_r8,7.8668e-02_r8,7.1038e-02_r8,6.2226e-02_r8,5.2555e-02_r8,4.1980e-02_r8, &
     &3.0595e-02_r8,1.8057e-02_r8,1.8484e-03_r8/)
      kao(:, 4,13, 5) = (/ &
     &1.1968e-01_r8,1.1269e-01_r8,1.0134e-01_r8,8.8277e-02_r8,7.4125e-02_r8,5.9019e-02_r8, &
     &4.2726e-02_r8,2.4879e-02_r8,2.2113e-03_r8/)
      kao(:, 5,13, 5) = (/ &
     &1.6694e-01_r8,1.5606e-01_r8,1.3993e-01_r8,1.2146e-01_r8,1.0158e-01_r8,8.0368e-02_r8, &
     &5.7742e-02_r8,3.3361e-02_r8,2.6209e-03_r8/)
      kao(:, 1, 1, 6) = (/ &
     &5.8710e-04_r8,3.7447e-03_r8,5.6598e-03_r8,7.4215e-03_r8,9.2308e-03_r8,1.1302e-02_r8, &
     &1.3745e-02_r8,1.7130e-02_r8,1.6376e-02_r8/)
      kao(:, 2, 1, 6) = (/ &
     &7.1095e-04_r8,4.5295e-03_r8,6.8956e-03_r8,9.1329e-03_r8,1.1441e-02_r8,1.4069e-02_r8, &
     &1.7260e-02_r8,2.1984e-02_r8,2.0159e-02_r8/)
      kao(:, 3, 1, 6) = (/ &
     &8.4824e-04_r8,5.3994e-03_r8,8.2567e-03_r8,1.1010e-02_r8,1.3909e-02_r8,1.7204e-02_r8, &
     &2.1091e-02_r8,2.7132e-02_r8,2.4524e-02_r8/)
      kao(:, 4, 1, 6) = (/ &
     &9.9962e-04_r8,6.3675e-03_r8,9.7929e-03_r8,1.3116e-02_r8,1.6664e-02_r8,2.0670e-02_r8, &
     &2.5520e-02_r8,3.3009e-02_r8,2.9504e-02_r8/)
      kao(:, 5, 1, 6) = (/ &
     &1.1677e-03_r8,7.4449e-03_r8,1.1517e-02_r8,1.5476e-02_r8,1.9740e-02_r8,2.4530e-02_r8, &
     &3.0349e-02_r8,3.9385e-02_r8,3.5028e-02_r8/)
      kao(:, 1, 2, 6) = (/ &
     &7.3151e-04_r8,3.6448e-03_r8,5.2016e-03_r8,6.6421e-03_r8,7.9400e-03_r8,9.1018e-03_r8, &
     &1.0516e-02_r8,1.2549e-02_r8,1.2514e-02_r8/)
      kao(:, 2, 2, 6) = (/ &
     &8.8990e-04_r8,4.4216e-03_r8,6.3659e-03_r8,8.1663e-03_r8,9.8302e-03_r8,1.1392e-02_r8, &
     &1.3321e-02_r8,1.6283e-02_r8,1.5469e-02_r8/)
      kao(:, 3, 2, 6) = (/ &
     &1.0714e-03_r8,5.2883e-03_r8,7.6564e-03_r8,9.8457e-03_r8,1.1909e-02_r8,1.3940e-02_r8, &
     &1.6405e-02_r8,2.0166e-02_r8,1.8847e-02_r8/)
      kao(:, 4, 2, 6) = (/ &
     &1.2782e-03_r8,6.2637e-03_r8,9.0995e-03_r8,1.1738e-02_r8,1.4242e-02_r8,1.6761e-02_r8, &
     &1.9871e-02_r8,2.4604e-02_r8,2.2753e-02_r8/)
      kao(:, 5, 2, 6) = (/ &
     &1.5101e-03_r8,7.3491e-03_r8,1.0728e-02_r8,1.3865e-02_r8,1.6850e-02_r8,1.9892e-02_r8, &
     &2.3687e-02_r8,2.9581e-02_r8,2.7171e-02_r8/)
      kao(:, 1, 3, 6) = (/ &
     &1.1614e-03_r8,3.9286e-03_r8,5.2992e-03_r8,6.2920e-03_r8,7.1803e-03_r8,7.9571e-03_r8, &
     &8.5455e-03_r8,9.0349e-03_r8,9.0567e-03_r8/)
      kao(:, 2, 3, 6) = (/ &
     &1.4526e-03_r8,4.8338e-03_r8,6.5076e-03_r8,7.7704e-03_r8,8.9197e-03_r8,9.9629e-03_r8, &
     &1.0799e-02_r8,1.1625e-02_r8,1.1298e-02_r8/)
      kao(:, 3, 3, 6) = (/ &
     &1.7725e-03_r8,5.8343e-03_r8,7.8680e-03_r8,9.4298e-03_r8,1.0866e-02_r8,1.2179e-02_r8, &
     &1.3264e-02_r8,1.4525e-02_r8,1.3847e-02_r8/)
      kao(:, 4, 3, 6) = (/ &
     &2.1368e-03_r8,6.9576e-03_r8,9.3967e-03_r8,1.1298e-02_r8,1.3038e-02_r8,1.4633e-02_r8, &
     &1.6013e-02_r8,1.7774e-02_r8,1.6807e-02_r8/)
      kao(:, 5, 3, 6) = (/ &
     &2.5530e-03_r8,8.2213e-03_r8,1.1119e-02_r8,1.3386e-02_r8,1.5467e-02_r8,1.7396e-02_r8, &
     &1.9105e-02_r8,2.1405e-02_r8,2.0198e-02_r8/)
      kao(:, 1, 4, 6) = (/ &
     &1.8393e-03_r8,4.2719e-03_r8,5.6108e-03_r8,6.4238e-03_r8,6.8867e-03_r8,7.1924e-03_r8, &
     &7.4060e-03_r8,7.2862e-03_r8,6.3156e-03_r8/)
      kao(:, 2, 4, 6) = (/ &
     &2.3510e-03_r8,5.3330e-03_r8,6.9923e-03_r8,7.9801e-03_r8,8.5829e-03_r8,9.0352e-03_r8, &
     &9.3670e-03_r8,9.3790e-03_r8,7.9787e-03_r8/)
      kao(:, 3, 4, 6) = (/ &
     &2.9328e-03_r8,6.5477e-03_r8,8.5524e-03_r8,9.7522e-03_r8,1.0523e-02_r8,1.1105e-02_r8, &
     &1.1571e-02_r8,1.1684e-02_r8,9.9124e-03_r8/)
      kao(:, 4, 4, 6) = (/ &
     &3.6136e-03_r8,7.9708e-03_r8,1.0306e-02_r8,1.1748e-02_r8,1.2708e-02_r8,1.3440e-02_r8, &
     &1.4032e-02_r8,1.4271e-02_r8,1.2172e-02_r8/)
      kao(:, 5, 4, 6) = (/ &
     &4.3442e-03_r8,9.5761e-03_r8,1.2277e-02_r8,1.3997e-02_r8,1.5163e-02_r8,1.6053e-02_r8, &
     &1.6795e-02_r8,1.7163e-02_r8,1.4922e-02_r8/)
      kao(:, 1, 5, 6) = (/ &
     &2.6688e-03_r8,4.8052e-03_r8,5.7832e-03_r8,6.4797e-03_r8,6.8502e-03_r8,6.8218e-03_r8, &
     &6.5242e-03_r8,6.0722e-03_r8,4.6753e-03_r8/)
      kao(:, 2, 5, 6) = (/ &
     &3.4688e-03_r8,6.1297e-03_r8,7.3230e-03_r8,8.1782e-03_r8,8.6322e-03_r8,8.6195e-03_r8, &
     &8.3126e-03_r8,7.8540e-03_r8,5.9385e-03_r8/)
      kao(:, 3, 5, 6) = (/ &
     &4.4058e-03_r8,7.6630e-03_r8,9.1013e-03_r8,1.0147e-02_r8,1.0667e-02_r8,1.0680e-02_r8, &
     &1.0355e-02_r8,9.8543e-03_r8,7.3828e-03_r8/)
      kao(:, 4, 5, 6) = (/ &
     &5.5115e-03_r8,9.4361e-03_r8,1.1163e-02_r8,1.2385e-02_r8,1.2986e-02_r8,1.3010e-02_r8, &
     &1.2662e-02_r8,1.2099e-02_r8,9.0803e-03_r8/)
      kao(:, 5, 5, 6) = (/ &
     &6.7862e-03_r8,1.1482e-02_r8,1.3563e-02_r8,1.4942e-02_r8,1.5588e-02_r8,1.5643e-02_r8, &
     &1.5261e-02_r8,1.4627e-02_r8,1.1026e-02_r8/)
      kao(:, 1, 6, 6) = (/ &
     &3.5724e-03_r8,5.4370e-03_r8,6.0294e-03_r8,6.3914e-03_r8,6.6047e-03_r8,6.5232e-03_r8, &
     &6.0277e-03_r8,5.0661e-03_r8,3.1530e-03_r8/)
      kao(:, 2, 6, 6) = (/ &
     &4.7182e-03_r8,7.1382e-03_r8,7.8365e-03_r8,8.2706e-03_r8,8.5053e-03_r8,8.3495e-03_r8, &
     &7.7282e-03_r8,6.6198e-03_r8,4.1407e-03_r8/)
      kao(:, 3, 6, 6) = (/ &
     &6.1150e-03_r8,9.1981e-03_r8,9.9430e-03_r8,1.0464e-02_r8,1.0671e-02_r8,1.0482e-02_r8, &
     &9.6931e-03_r8,8.3868e-03_r8,5.3331e-03_r8/)
      kao(:, 4, 6, 6) = (/ &
     &7.7447e-03_r8,1.1494e-02_r8,1.2445e-02_r8,1.3024e-02_r8,1.3207e-02_r8,1.2894e-02_r8, &
     &1.1946e-02_r8,1.0395e-02_r8,6.6921e-03_r8/)
      kao(:, 5, 6, 6) = (/ &
     &9.6796e-03_r8,1.4190e-02_r8,1.5330e-02_r8,1.5967e-02_r8,1.6158e-02_r8,1.5661e-02_r8, &
     &1.4492e-02_r8,1.2674e-02_r8,8.2498e-03_r8/)
      kao(:, 1, 7, 6) = (/ &
     &4.9616e-03_r8,6.6121e-03_r8,6.8416e-03_r8,6.8101e-03_r8,6.6768e-03_r8,6.3696e-03_r8, &
     &5.8141e-03_r8,4.6733e-03_r8,2.5227e-03_r8/)
      kao(:, 2, 7, 6) = (/ &
     &6.6954e-03_r8,8.8189e-03_r8,9.1778e-03_r8,9.1281e-03_r8,8.8939e-03_r8,8.4196e-03_r8, &
     &7.6478e-03_r8,6.1227e-03_r8,3.2129e-03_r8/)
      kao(:, 3, 7, 6) = (/ &
     &8.9023e-03_r8,1.1584e-02_r8,1.1984e-02_r8,1.1899e-02_r8,1.1446e-02_r8,1.0830e-02_r8, &
     &9.7223e-03_r8,7.7935e-03_r8,4.0071e-03_r8/)
      kao(:, 4, 7, 6) = (/ &
     &1.1382e-02_r8,1.4883e-02_r8,1.5340e-02_r8,1.5077e-02_r8,1.4572e-02_r8,1.3613e-02_r8, &
     &1.2124e-02_r8,9.7242e-03_r8,4.9238e-03_r8/)
      kao(:, 5, 7, 6) = (/ &
     &1.4371e-02_r8,1.8723e-02_r8,1.9154e-02_r8,1.8910e-02_r8,1.8193e-02_r8,1.6854e-02_r8, &
     &1.4917e-02_r8,1.1939e-02_r8,6.0317e-03_r8/)
      kao(:, 1, 8, 6) = (/ &
     &8.7001e-03_r8,9.7747e-03_r8,9.5071e-03_r8,8.9379e-03_r8,8.2227e-03_r8,7.2962e-03_r8, &
     &6.1868e-03_r8,4.7953e-03_r8,2.0794e-03_r8/)
      kao(:, 2, 8, 6) = (/ &
     &1.1618e-02_r8,1.3178e-02_r8,1.2958e-02_r8,1.2245e-02_r8,1.1180e-02_r8,9.8759e-03_r8, &
     &8.4959e-03_r8,6.4689e-03_r8,2.6798e-03_r8/)
      kao(:, 3, 8, 6) = (/ &
     &1.5351e-02_r8,1.7665e-02_r8,1.7319e-02_r8,1.6267e-02_r8,1.4838e-02_r8,1.3188e-02_r8, &
     &1.1167e-02_r8,8.4425e-03_r8,3.4113e-03_r8/)
      kao(:, 4, 8, 6) = (/ &
     &2.0092e-02_r8,2.2911e-02_r8,2.2431e-02_r8,2.1181e-02_r8,1.9393e-02_r8,1.7119e-02_r8, &
     &1.4369e-02_r8,1.0695e-02_r8,4.2567e-03_r8/)
      kao(:, 5, 8, 6) = (/ &
     &2.5625e-02_r8,2.9136e-02_r8,2.8640e-02_r8,2.6980e-02_r8,2.4612e-02_r8,2.1703e-02_r8, &
     &1.8202e-02_r8,1.3310e-02_r8,5.2101e-03_r8/)
      kao(:, 1, 9, 6) = (/ &
     &2.8411e-02_r8,2.7805e-02_r8,2.5436e-02_r8,2.2677e-02_r8,1.9516e-02_r8,1.5867e-02_r8, &
     &1.1958e-02_r8,7.5969e-03_r8,2.0612e-03_r8/)
      kao(:, 2, 9, 6) = (/ &
     &3.8814e-02_r8,3.7908e-02_r8,3.4867e-02_r8,3.0948e-02_r8,2.6641e-02_r8,2.1668e-02_r8, &
     &1.6345e-02_r8,1.0429e-02_r8,2.5903e-03_r8/)
      kao(:, 3, 9, 6) = (/ &
     &5.1537e-02_r8,5.0347e-02_r8,4.6262e-02_r8,4.1144e-02_r8,3.5324e-02_r8,2.8924e-02_r8, &
     &2.1923e-02_r8,1.4064e-02_r8,3.2116e-03_r8/)
      kao(:, 4, 9, 6) = (/ &
     &6.6909e-02_r8,6.5234e-02_r8,6.0364e-02_r8,5.3943e-02_r8,4.6443e-02_r8,3.8124e-02_r8, &
     &2.8947e-02_r8,1.8549e-02_r8,3.8623e-03_r8/)
      kao(:, 5, 9, 6) = (/ &
     &8.6078e-02_r8,8.4018e-02_r8,7.7843e-02_r8,6.9506e-02_r8,5.9853e-02_r8,4.9159e-02_r8, &
     &3.7146e-02_r8,2.3977e-02_r8,4.6095e-03_r8/)
      kao(:, 1,10, 6) = (/ &
     &1.0479e-01_r8,9.4804e-02_r8,8.4158e-02_r8,7.2419e-02_r8,5.9897e-02_r8,4.7014e-02_r8, &
     &3.3513e-02_r8,1.8915e-02_r8,2.3959e-03_r8/)
      kao(:, 2,10, 6) = (/ &
     &1.4593e-01_r8,1.3214e-01_r8,1.1705e-01_r8,1.0074e-01_r8,8.3547e-02_r8,6.5542e-02_r8, &
     &4.6772e-02_r8,2.6375e-02_r8,2.8756e-03_r8/)
      kao(:, 3,10, 6) = (/ &
     &1.9678e-01_r8,1.7825e-01_r8,1.5773e-01_r8,1.3590e-01_r8,1.1277e-01_r8,8.8462e-02_r8, &
     &6.3144e-02_r8,3.5733e-02_r8,3.4719e-03_r8/)
      kao(:, 4,10, 6) = (/ &
     &2.5901e-01_r8,2.3451e-01_r8,2.0787e-01_r8,1.7931e-01_r8,1.4891e-01_r8,1.1693e-01_r8, &
     &8.3230e-02_r8,4.7067e-02_r8,4.3129e-03_r8/)
      kao(:, 5,10, 6) = (/ &
     &3.3485e-01_r8,3.0286e-01_r8,2.6808e-01_r8,2.3135e-01_r8,1.9236e-01_r8,1.5087e-01_r8, &
     &1.0672e-01_r8,6.0498e-02_r8,5.2412e-03_r8/)
      kao(:, 1,11, 6) = (/ &
     &1.5729e-01_r8,1.4058e-01_r8,1.2399e-01_r8,1.0596e-01_r8,8.6953e-02_r8,6.7449e-02_r8, &
     &4.7388e-02_r8,2.6098e-02_r8,2.4928e-03_r8/)
      kao(:, 2,11, 6) = (/ &
     &2.1957e-01_r8,1.9641e-01_r8,1.7272e-01_r8,1.4763e-01_r8,1.2135e-01_r8,9.4358e-02_r8, &
     &6.6246e-02_r8,3.6579e-02_r8,3.1141e-03_r8/)
      kao(:, 3,11, 6) = (/ &
     &2.9796e-01_r8,2.6647e-01_r8,2.3432e-01_r8,2.0028e-01_r8,1.6476e-01_r8,1.2810e-01_r8, &
     &8.9989e-02_r8,4.9741e-02_r8,3.7347e-03_r8/)
      kao(:, 4,11, 6) = (/ &
     &3.9483e-01_r8,3.5349e-01_r8,3.1058e-01_r8,2.6565e-01_r8,2.1911e-01_r8,1.7032e-01_r8, &
     &1.1939e-01_r8,6.5674e-02_r8,4.4794e-03_r8/)
      kao(:, 5,11, 6) = (/ &
     &5.1293e-01_r8,4.5889e-01_r8,4.0288e-01_r8,3.4402e-01_r8,2.8339e-01_r8,2.1998e-01_r8, &
     &1.5383e-01_r8,8.4493e-02_r8,5.3916e-03_r8/)
      kao(:, 1,12, 6) = (/ &
     &1.7496e-01_r8,1.5620e-01_r8,1.3720e-01_r8,1.1692e-01_r8,9.5664e-02_r8,7.3896e-02_r8, &
     &5.1517e-02_r8,2.8131e-02_r8,2.4011e-03_r8/)
      kao(:, 2,12, 6) = (/ &
     &2.4535e-01_r8,2.1911e-01_r8,1.9222e-01_r8,1.6394e-01_r8,1.3439e-01_r8,1.0379e-01_r8, &
     &7.2409e-02_r8,3.9528e-02_r8,2.9367e-03_r8/)
      kao(:, 3,12, 6) = (/ &
     &3.3489e-01_r8,2.9916e-01_r8,2.6204e-01_r8,2.2337e-01_r8,1.8311e-01_r8,1.4171e-01_r8, &
     &9.8967e-02_r8,5.4062e-02_r8,3.5110e-03_r8/)
      kao(:, 4,12, 6) = (/ &
     &4.4645e-01_r8,3.9881e-01_r8,3.4940e-01_r8,2.9764e-01_r8,2.4438e-01_r8,1.8899e-01_r8, &
     &1.3169e-01_r8,7.1745e-02_r8,4.2744e-03_r8/)
      kao(:, 5,12, 6) = (/ &
     &5.8440e-01_r8,5.2135e-01_r8,4.5608e-01_r8,3.8804e-01_r8,3.1784e-01_r8,2.4555e-01_r8, &
     &1.7082e-01_r8,9.2836e-02_r8,5.0546e-03_r8/)
      kao(:, 1,13, 6) = (/ &
     &1.5548e-01_r8,1.3934e-01_r8,1.2226e-01_r8,1.0396e-01_r8,8.5068e-02_r8,6.5711e-02_r8, &
     &4.5702e-02_r8,2.4873e-02_r8,2.0740e-03_r8/)
      kao(:, 2,13, 6) = (/ &
     &2.1897e-01_r8,1.9631e-01_r8,1.7240e-01_r8,1.4676e-01_r8,1.2003e-01_r8,9.2645e-02_r8, &
     &6.4538e-02_r8,3.5191e-02_r8,2.5124e-03_r8/)
      kao(:, 3,13, 6) = (/ &
     &3.0093e-01_r8,2.6954e-01_r8,2.3618e-01_r8,2.0119e-01_r8,1.6478e-01_r8,1.2740e-01_r8, &
     &8.8848e-02_r8,4.8366e-02_r8,3.0385e-03_r8/)
      kao(:, 4,13, 6) = (/ &
     &4.0480e-01_r8,3.6240e-01_r8,3.1715e-01_r8,2.6983e-01_r8,2.2076e-01_r8,1.7039e-01_r8, &
     &1.1847e-01_r8,6.4388e-02_r8,3.6949e-03_r8/)
      kao(:, 5,13, 6) = (/ &
     &5.3109e-01_r8,4.7451e-01_r8,4.1461e-01_r8,3.5239e-01_r8,2.8790e-01_r8,2.2202e-01_r8, &
     &1.5435e-01_r8,8.3628e-02_r8,4.3087e-03_r8/)
      kao(:, 1, 1, 7) = (/ &
     &1.3848e-03_r8,7.4265e-03_r8,1.1328e-02_r8,1.5765e-02_r8,2.0617e-02_r8,2.5760e-02_r8, &
     &3.1394e-02_r8,3.9174e-02_r8,3.7962e-02_r8/)
      kao(:, 2, 1, 7) = (/ &
     &1.6671e-03_r8,8.9945e-03_r8,1.3803e-02_r8,1.9211e-02_r8,2.5130e-02_r8,3.1434e-02_r8, &
     &3.8541e-02_r8,4.9244e-02_r8,4.6325e-02_r8/)
      kao(:, 3, 1, 7) = (/ &
     &1.9714e-03_r8,1.0738e-02_r8,1.6621e-02_r8,2.3153e-02_r8,3.0242e-02_r8,3.7827e-02_r8, &
     &4.6470e-02_r8,6.0286e-02_r8,5.5806e-02_r8/)
      kao(:, 4, 1, 7) = (/ &
     &2.3028e-03_r8,1.2683e-02_r8,1.9788e-02_r8,2.7634e-02_r8,3.6042e-02_r8,4.5063e-02_r8, &
     &5.5400e-02_r8,7.2329e-02_r8,6.6551e-02_r8/)
      kao(:, 5, 1, 7) = (/ &
     &2.6597e-03_r8,1.4839e-02_r8,2.3341e-02_r8,3.2680e-02_r8,4.2600e-02_r8,5.3211e-02_r8, &
     &6.5429e-02_r8,8.5816e-02_r8,7.8751e-02_r8/)
      kao(:, 1, 2, 7) = (/ &
     &1.7365e-03_r8,7.5104e-03_r8,1.0855e-02_r8,1.3649e-02_r8,1.6794e-02_r8,2.0487e-02_r8, &
     &2.4622e-02_r8,2.9785e-02_r8,2.9296e-02_r8/)
      kao(:, 2, 2, 7) = (/ &
     &2.1191e-03_r8,9.1841e-03_r8,1.3246e-02_r8,1.6722e-02_r8,2.0613e-02_r8,2.5164e-02_r8, &
     &3.0319e-02_r8,3.7310e-02_r8,3.6002e-02_r8/)
      kao(:, 3, 2, 7) = (/ &
     &2.5333e-03_r8,1.1030e-02_r8,1.5921e-02_r8,2.0206e-02_r8,2.4966e-02_r8,3.0432e-02_r8, &
     &3.6701e-02_r8,4.5559e-02_r8,4.3603e-02_r8/)
      kao(:, 4, 2, 7) = (/ &
     &2.9828e-03_r8,1.3051e-02_r8,1.8932e-02_r8,2.4145e-02_r8,2.9915e-02_r8,3.6454e-02_r8, &
     &4.3919e-02_r8,5.4674e-02_r8,5.2233e-02_r8/)
      kao(:, 5, 2, 7) = (/ &
     &3.4709e-03_r8,1.5291e-02_r8,2.2279e-02_r8,2.8573e-02_r8,3.5520e-02_r8,4.3284e-02_r8, &
     &5.2127e-02_r8,6.5008e-02_r8,6.1979e-02_r8/)
      kao(:, 1, 3, 7) = (/ &
     &2.8092e-03_r8,8.4318e-03_r8,1.1352e-02_r8,1.3672e-02_r8,1.5434e-02_r8,1.6834e-02_r8, &
     &1.8680e-02_r8,2.1551e-02_r8,2.1437e-02_r8/)
      kao(:, 2, 3, 7) = (/ &
     &3.4524e-03_r8,1.0436e-02_r8,1.4060e-02_r8,1.6891e-02_r8,1.9071e-02_r8,2.0847e-02_r8, &
     &2.3206e-02_r8,2.6955e-02_r8,2.6565e-02_r8/)
      kao(:, 3, 3, 7) = (/ &
     &4.1827e-03_r8,1.2653e-02_r8,1.7072e-02_r8,2.0477e-02_r8,2.3160e-02_r8,2.5389e-02_r8, &
     &2.8361e-02_r8,3.3016e-02_r8,3.2451e-02_r8/)
      kao(:, 4, 3, 7) = (/ &
     &4.9958e-03_r8,1.5103e-02_r8,2.0380e-02_r8,2.4512e-02_r8,2.7790e-02_r8,3.0621e-02_r8, &
     &3.4270e-02_r8,3.9878e-02_r8,3.9158e-02_r8/)
      kao(:, 5, 3, 7) = (/ &
     &5.8802e-03_r8,1.7776e-02_r8,2.4055e-02_r8,2.9030e-02_r8,3.2999e-02_r8,3.6516e-02_r8, &
     &4.0970e-02_r8,4.7651e-02_r8,4.6784e-02_r8/)
      kao(:, 1, 4, 7) = (/ &
     &4.5589e-03_r8,1.0079e-02_r8,1.2337e-02_r8,1.3994e-02_r8,1.5249e-02_r8,1.6070e-02_r8, &
     &1.6321e-02_r8,1.6191e-02_r8,1.5492e-02_r8/)
      kao(:, 2, 4, 7) = (/ &
     &5.6834e-03_r8,1.2638e-02_r8,1.5464e-02_r8,1.7583e-02_r8,1.9154e-02_r8,2.0166e-02_r8, &
     &2.0456e-02_r8,2.0438e-02_r8,1.9456e-02_r8/)
      kao(:, 3, 4, 7) = (/ &
     &6.9619e-03_r8,1.5492e-02_r8,1.8969e-02_r8,2.1612e-02_r8,2.3568e-02_r8,2.4770e-02_r8, &
     &2.5120e-02_r8,2.5223e-02_r8,2.3997e-02_r8/)
      kao(:, 4, 4, 7) = (/ &
     &8.4006e-03_r8,1.8644e-02_r8,2.2892e-02_r8,2.6108e-02_r8,2.8487e-02_r8,2.9981e-02_r8, &
     &3.0457e-02_r8,3.0724e-02_r8,2.9183e-02_r8/)
      kao(:, 5, 4, 7) = (/ &
     &1.0053e-02_r8,2.2099e-02_r8,2.7239e-02_r8,3.1080e-02_r8,3.3975e-02_r8,3.5831e-02_r8, &
     &3.6496e-02_r8,3.6989e-02_r8,3.5086e-02_r8/)
      kao(:, 1, 5, 7) = (/ &
     &6.7689e-03_r8,1.1903e-02_r8,1.3648e-02_r8,1.4571e-02_r8,1.5091e-02_r8,1.5249e-02_r8, &
     &1.4963e-02_r8,1.3941e-02_r8,1.1072e-02_r8/)
      kao(:, 2, 5, 7) = (/ &
     &8.5889e-03_r8,1.5080e-02_r8,1.7390e-02_r8,1.8530e-02_r8,1.9222e-02_r8,1.9473e-02_r8, &
     &1.9084e-02_r8,1.7764e-02_r8,1.3833e-02_r8/)
      kao(:, 3, 5, 7) = (/ &
     &1.0679e-02_r8,1.8745e-02_r8,2.1599e-02_r8,2.3039e-02_r8,2.3924e-02_r8,2.4268e-02_r8, &
     &2.3807e-02_r8,2.2090e-02_r8,1.7335e-02_r8/)
      kao(:, 4, 5, 7) = (/ &
     &1.3055e-02_r8,2.2828e-02_r8,2.6303e-02_r8,2.8136e-02_r8,2.9230e-02_r8,2.9685e-02_r8, &
     &2.9170e-02_r8,2.7046e-02_r8,2.1372e-02_r8/)
      kao(:, 5, 5, 7) = (/ &
     &1.5751e-02_r8,2.7271e-02_r8,3.1547e-02_r8,3.3833e-02_r8,3.5204e-02_r8,3.5707e-02_r8, &
     &3.5181e-02_r8,3.2654e-02_r8,2.6029e-02_r8/)
      kao(:, 1, 6, 7) = (/ &
     &9.2094e-03_r8,1.3724e-02_r8,1.5036e-02_r8,1.5371e-02_r8,1.5106e-02_r8,1.4473e-02_r8, &
     &1.3532e-02_r8,1.2020e-02_r8,8.1670e-03_r8/)
      kao(:, 2, 6, 7) = (/ &
     &1.1986e-02_r8,1.7634e-02_r8,1.9365e-02_r8,1.9834e-02_r8,1.9516e-02_r8,1.8750e-02_r8, &
     &1.7602e-02_r8,1.5593e-02_r8,1.0511e-02_r8/)
      kao(:, 3, 6, 7) = (/ &
     &1.5180e-02_r8,2.2067e-02_r8,2.4393e-02_r8,2.4963e-02_r8,2.4596e-02_r8,2.3680e-02_r8, &
     &2.2274e-02_r8,1.9750e-02_r8,1.3124e-02_r8/)
      kao(:, 4, 6, 7) = (/ &
     &1.8879e-02_r8,2.7272e-02_r8,3.0068e-02_r8,3.0821e-02_r8,3.0411e-02_r8,2.9355e-02_r8, &
     &2.7616e-02_r8,2.4539e-02_r8,1.6137e-02_r8/)
      kao(:, 5, 6, 7) = (/ &
     &2.3118e-02_r8,3.3049e-02_r8,3.6382e-02_r8,3.7419e-02_r8,3.7019e-02_r8,3.5790e-02_r8, &
     &3.3628e-02_r8,2.9915e-02_r8,1.9032e-02_r8/)
      kao(:, 1, 7, 7) = (/ &
     &1.3180e-02_r8,1.6672e-02_r8,1.7592e-02_r8,1.7458e-02_r8,1.6513e-02_r8,1.5058e-02_r8, &
     &1.3095e-02_r8,1.0650e-02_r8,5.4642e-03_r8/)
      kao(:, 2, 7, 7) = (/ &
     &1.7434e-02_r8,2.2125e-02_r8,2.3174e-02_r8,2.2835e-02_r8,2.1611e-02_r8,1.9729e-02_r8, &
     &1.7181e-02_r8,1.4117e-02_r8,7.1375e-03_r8/)
      kao(:, 3, 7, 7) = (/ &
     &2.2566e-02_r8,2.8274e-02_r8,2.9519e-02_r8,2.9093e-02_r8,2.7592e-02_r8,2.5177e-02_r8, &
     &2.2032e-02_r8,1.8185e-02_r8,9.3084e-03_r8/)
      kao(:, 4, 7, 7) = (/ &
     &2.8653e-02_r8,3.5321e-02_r8,3.6780e-02_r8,3.6287e-02_r8,3.4434e-02_r8,3.1535e-02_r8, &
     &2.7705e-02_r8,2.2900e-02_r8,1.1848e-02_r8/)
      kao(:, 5, 7, 7) = (/ &
     &3.5765e-02_r8,4.3430e-02_r8,4.5100e-02_r8,4.4435e-02_r8,4.2245e-02_r8,3.8834e-02_r8, &
     &3.4253e-02_r8,2.8260e-02_r8,1.4688e-02_r8/)
      kao(:, 1, 8, 7) = (/ &
     &2.1747e-02_r8,2.4454e-02_r8,2.4292e-02_r8,2.3080e-02_r8,2.1111e-02_r8,1.8543e-02_r8, &
     &1.5300e-02_r8,1.1054e-02_r8,4.8558e-03_r8/)
      kao(:, 2, 8, 7) = (/ &
     &3.0389e-02_r8,3.3327e-02_r8,3.2926e-02_r8,3.1134e-02_r8,2.8533e-02_r8,2.5003e-02_r8, &
     &2.0402e-02_r8,1.4724e-02_r8,6.1788e-03_r8/)
      kao(:, 3, 8, 7) = (/ &
     &4.0290e-02_r8,4.3505e-02_r8,4.2950e-02_r8,4.0676e-02_r8,3.7191e-02_r8,3.2422e-02_r8, &
     &2.6427e-02_r8,1.9111e-02_r8,7.6799e-03_r8/)
      kao(:, 4, 8, 7) = (/ &
     &5.2072e-02_r8,5.5809e-02_r8,5.4895e-02_r8,5.1714e-02_r8,4.6978e-02_r8,4.0907e-02_r8, &
     &3.3411e-02_r8,2.4362e-02_r8,9.3208e-03_r8/)
      kao(:, 5, 8, 7) = (/ &
     &6.6160e-02_r8,7.0258e-02_r8,6.8654e-02_r8,6.4320e-02_r8,5.8240e-02_r8,5.0667e-02_r8, &
     &4.1561e-02_r8,3.0531e-02_r8,1.1097e-02_r8/)
      kao(:, 1, 9, 7) = (/ &
     &6.9879e-02_r8,6.6386e-02_r8,6.1416e-02_r8,5.4862e-02_r8,4.7283e-02_r8,3.9112e-02_r8, &
     &2.9846e-02_r8,1.9026e-02_r8,5.0281e-03_r8/)
      kao(:, 2, 9, 7) = (/ &
     &9.7072e-02_r8,9.2199e-02_r8,8.5540e-02_r8,7.6855e-02_r8,6.6492e-02_r8,5.4707e-02_r8, &
     &4.1549e-02_r8,2.6366e-02_r8,6.3749e-03_r8/)
      kao(:, 3, 9, 7) = (/ &
     &1.3274e-01_r8,1.2639e-01_r8,1.1670e-01_r8,1.0412e-01_r8,8.9576e-02_r8,7.3400e-02_r8, &
     &5.5548e-02_r8,3.5017e-02_r8,7.9283e-03_r8/)
      kao(:, 4, 9, 7) = (/ &
     &1.7725e-01_r8,1.6726e-01_r8,1.5276e-01_r8,1.3606e-01_r8,1.1668e-01_r8,9.5385e-02_r8, &
     &7.1895e-02_r8,4.5017e-02_r8,9.7700e-03_r8/)
      kao(:, 5, 9, 7) = (/ &
     &2.2900e-01_r8,2.1469e-01_r8,1.9562e-01_r8,1.7346e-01_r8,1.4892e-01_r8,1.2126e-01_r8, &
     &9.1015e-02_r8,5.6621e-02_r8,1.1851e-02_r8/)
      kao(:, 1,10, 7) = (/ &
     &2.6110e-01_r8,2.3191e-01_r8,2.0431e-01_r8,1.7643e-01_r8,1.4693e-01_r8,1.1545e-01_r8, &
     &8.1908e-02_r8,4.6480e-02_r8,5.5448e-03_r8/)
      kao(:, 2,10, 7) = (/ &
     &3.6304e-01_r8,3.2305e-01_r8,2.8523e-01_r8,2.4612e-01_r8,2.0468e-01_r8,1.6117e-01_r8, &
     &1.1489e-01_r8,6.5350e-02_r8,7.0032e-03_r8/)
      kao(:, 3,10, 7) = (/ &
     &5.0185e-01_r8,4.4688e-01_r8,3.9417e-01_r8,3.3909e-01_r8,2.8117e-01_r8,2.2056e-01_r8, &
     &1.5648e-01_r8,8.9037e-02_r8,8.6105e-03_r8/)
      kao(:, 4,10, 7) = (/ &
     &6.7448e-01_r8,6.0038e-01_r8,5.2817e-01_r8,4.5305e-01_r8,3.7479e-01_r8,2.9367e-01_r8, &
     &2.0933e-01_r8,1.1852e-01_r8,1.0215e-02_r8/)
      kao(:, 5,10, 7) = (/ &
     &8.8770e-01_r8,7.8961e-01_r8,6.9429e-01_r8,5.9500e-01_r8,4.9158e-01_r8,3.8401e-01_r8, &
     &2.7292e-01_r8,1.5364e-01_r8,1.2140e-02_r8/)
      kao(:, 1,11, 7) = (/ &
     &4.0532e-01_r8,3.5824e-01_r8,3.1239e-01_r8,2.6732e-01_r8,2.2024e-01_r8,1.7123e-01_r8, &
     &1.1969e-01_r8,6.6094e-02_r8,5.4214e-03_r8/)
      kao(:, 2,11, 7) = (/ &
     &5.6606e-01_r8,5.0050e-01_r8,4.3693e-01_r8,3.7301e-01_r8,3.0650e-01_r8,2.3759e-01_r8, &
     &1.6618e-01_r8,9.1406e-02_r8,6.5476e-03_r8/)
      kao(:, 3,11, 7) = (/ &
     &7.7109e-01_r8,6.8230e-01_r8,5.9547e-01_r8,5.0803e-01_r8,4.1719e-01_r8,3.2299e-01_r8, &
     &2.2593e-01_r8,1.2450e-01_r8,7.8892e-03_r8/)
      kao(:, 4,11, 7) = (/ &
     &1.0345e+00_r8,9.1439e-01_r8,7.9746e-01_r8,6.7877e-01_r8,5.5627e-01_r8,4.3053e-01_r8, &
     &3.0103e-01_r8,1.6533e-01_r8,9.6823e-03_r8/)
      kao(:, 5,11, 7) = (/ &
     &1.3462e+00_r8,1.1891e+00_r8,1.0362e+00_r8,8.8065e-01_r8,7.2071e-01_r8,5.5791e-01_r8, &
     &3.9044e-01_r8,2.1464e-01_r8,1.1736e-02_r8/)
      kao(:, 1,12, 7) = (/ &
     &4.6420e-01_r8,4.0988e-01_r8,3.5698e-01_r8,3.0422e-01_r8,2.4918e-01_r8,1.9252e-01_r8, &
     &1.3423e-01_r8,7.3160e-02_r8,4.7396e-03_r8/)
      kao(:, 2,12, 7) = (/ &
     &6.5450e-01_r8,5.7811e-01_r8,5.0333e-01_r8,4.2804e-01_r8,3.4996e-01_r8,2.7019e-01_r8, &
     &1.8778e-01_r8,1.0212e-01_r8,5.9506e-03_r8/)
      kao(:, 3,12, 7) = (/ &
     &8.9348e-01_r8,7.8900e-01_r8,6.8666e-01_r8,5.8272e-01_r8,4.7603e-01_r8,3.6677e-01_r8, &
     &2.5473e-01_r8,1.3789e-01_r8,7.3179e-03_r8/)
      kao(:, 4,12, 7) = (/ &
     &1.1756e+00_r8,1.0374e+00_r8,9.0174e-01_r8,7.6533e-01_r8,6.2509e-01_r8,4.8180e-01_r8, &
     &3.3511e-01_r8,1.8185e-01_r8,8.9523e-03_r8/)
      kao(:, 5,12, 7) = (/ &
     &1.5297e+00_r8,1.3494e+00_r8,1.1729e+00_r8,9.9401e-01_r8,8.1052e-01_r8,6.2387e-01_r8, &
     &4.3290e-01_r8,2.3433e-01_r8,1.0845e-02_r8/)
      kao(:, 1,13, 7) = (/ &
     &4.2167e-01_r8,3.7276e-01_r8,3.2553e-01_r8,2.7726e-01_r8,2.2695e-01_r8,1.7522e-01_r8, &
     &1.2184e-01_r8,6.6143e-02_r8,4.0030e-03_r8/)
      kao(:, 2,13, 7) = (/ &
     &6.0140e-01_r8,5.3188e-01_r8,4.6380e-01_r8,3.9365e-01_r8,3.2184e-01_r8,2.4778e-01_r8, &
     &1.7190e-01_r8,9.3023e-02_r8,5.1104e-03_r8/)
      kao(:, 3,13, 7) = (/ &
     &8.1807e-01_r8,7.2295e-01_r8,6.3004e-01_r8,5.3457e-01_r8,4.3643e-01_r8,3.3605e-01_r8, &
     &2.3292e-01_r8,1.2549e-01_r8,6.4347e-03_r8/)
      kao(:, 4,13, 7) = (/ &
     &1.0778e+00_r8,9.5216e-01_r8,8.2890e-01_r8,7.0211e-01_r8,5.7259e-01_r8,4.4078e-01_r8, &
     &3.0511e-01_r8,1.6456e-01_r8,7.8490e-03_r8/)
      kao(:, 5,13, 7) = (/ &
     &1.3868e+00_r8,1.2246e+00_r8,1.0647e+00_r8,9.0150e-01_r8,7.3547e-01_r8,5.6615e-01_r8, &
     &3.9191e-01_r8,2.1135e-01_r8,9.6903e-03_r8/)
      kao(:, 1, 1, 8) = (/ &
     &3.5696e-03_r8,1.6007e-02_r8,2.9119e-02_r8,4.2110e-02_r8,5.4860e-02_r8,6.8076e-02_r8, &
     &8.3917e-02_r8,1.0558e-01_r8,1.0534e-01_r8/)
      kao(:, 2, 1, 8) = (/ &
     &4.2863e-03_r8,1.9722e-02_r8,3.5791e-02_r8,5.1660e-02_r8,6.7170e-02_r8,8.3493e-02_r8, &
     &1.0314e-01_r8,1.2980e-01_r8,1.2936e-01_r8/)
      kao(:, 3, 1, 8) = (/ &
     &5.0567e-03_r8,2.3939e-02_r8,4.3341e-02_r8,6.2437e-02_r8,8.1028e-02_r8,1.0094e-01_r8, &
     &1.2485e-01_r8,1.5697e-01_r8,1.5657e-01_r8/)
      kao(:, 4, 1, 8) = (/ &
     &5.8865e-03_r8,2.8699e-02_r8,5.1840e-02_r8,7.4548e-02_r8,9.6669e-02_r8,1.2066e-01_r8, &
     &1.4947e-01_r8,1.8794e-01_r8,1.8748e-01_r8/)
      kao(:, 5, 1, 8) = (/ &
     &6.7695e-03_r8,3.4031e-02_r8,6.1358e-02_r8,8.8096e-02_r8,1.1420e-01_r8,1.4289e-01_r8, &
     &1.7720e-01_r8,2.2237e-01_r8,2.2240e-01_r8/)
      kao(:, 1, 2, 8) = (/ &
     &4.7118e-03_r8,1.5877e-02_r8,2.5399e-02_r8,3.5918e-02_r8,4.6457e-02_r8,5.6939e-02_r8, &
     &6.8068e-02_r8,8.4536e-02_r8,8.5555e-02_r8/)
      kao(:, 2, 2, 8) = (/ &
     &5.7108e-03_r8,1.9571e-02_r8,3.1487e-02_r8,4.4433e-02_r8,5.7366e-02_r8,7.0154e-02_r8, &
     &8.4052e-02_r8,1.0472e-01_r8,1.0570e-01_r8/)
      kao(:, 3, 2, 8) = (/ &
     &6.7866e-03_r8,2.3743e-02_r8,3.8403e-02_r8,5.4069e-02_r8,6.9657e-02_r8,8.4997e-02_r8, &
     &1.0211e-01_r8,1.2762e-01_r8,1.2838e-01_r8/)
      kao(:, 4, 2, 8) = (/ &
     &7.9436e-03_r8,2.8460e-02_r8,4.6231e-02_r8,6.4990e-02_r8,8.3598e-02_r8,1.0182e-01_r8, &
     &1.2260e-01_r8,1.5356e-01_r8,1.5440e-01_r8/)
      kao(:, 5, 2, 8) = (/ &
     &9.1873e-03_r8,3.3722e-02_r8,5.4999e-02_r8,7.7194e-02_r8,9.9137e-02_r8,1.2068e-01_r8, &
     &1.4584e-01_r8,1.8285e-01_r8,1.8375e-01_r8/)
      kao(:, 1, 3, 8) = (/ &
     &7.9289e-03_r8,1.8898e-02_r8,2.5653e-02_r8,3.1610e-02_r8,3.8347e-02_r8,4.5822e-02_r8, &
     &5.3494e-02_r8,6.2174e-02_r8,6.4789e-02_r8/)
      kao(:, 2, 3, 8) = (/ &
     &9.7250e-03_r8,2.3378e-02_r8,3.1960e-02_r8,3.9650e-02_r8,4.8157e-02_r8,5.7463e-02_r8, &
     &6.6987e-02_r8,7.7905e-02_r8,8.1125e-02_r8/)
      kao(:, 3, 3, 8) = (/ &
     &1.1690e-02_r8,2.8477e-02_r8,3.9050e-02_r8,4.8735e-02_r8,5.9251e-02_r8,7.0590e-02_r8, &
     &8.2118e-02_r8,9.5596e-02_r8,9.9562e-02_r8/)
      kao(:, 4, 3, 8) = (/ &
     &1.3819e-02_r8,3.4230e-02_r8,4.7053e-02_r8,5.8936e-02_r8,7.1761e-02_r8,8.5391e-02_r8, &
     &9.9148e-02_r8,1.1547e-01_r8,1.2059e-01_r8/)
      kao(:, 5, 3, 8) = (/ &
     &1.6126e-02_r8,4.0610e-02_r8,5.5935e-02_r8,7.0350e-02_r8,8.5758e-02_r8,1.0193e-01_r8, &
     &1.1815e-01_r8,1.3794e-01_r8,1.4428e-01_r8/)
      kao(:, 1, 4, 8) = (/ &
     &1.3217e-02_r8,2.3479e-02_r8,2.9539e-02_r8,3.3751e-02_r8,3.6721e-02_r8,3.9161e-02_r8, &
     &4.2339e-02_r8,4.7025e-02_r8,4.7847e-02_r8/)
      kao(:, 2, 4, 8) = (/ &
     &1.6447e-02_r8,2.9417e-02_r8,3.7093e-02_r8,4.2546e-02_r8,4.6456e-02_r8,4.9765e-02_r8, &
     &5.3922e-02_r8,5.9724e-02_r8,6.0703e-02_r8/)
      kao(:, 3, 4, 8) = (/ &
     &2.0055e-02_r8,3.6163e-02_r8,4.5727e-02_r8,5.2541e-02_r8,5.7472e-02_r8,6.1844e-02_r8, &
     &6.7058e-02_r8,7.4090e-02_r8,7.5241e-02_r8/)
      kao(:, 4, 4, 8) = (/ &
     &2.4006e-02_r8,4.3785e-02_r8,5.5469e-02_r8,6.3755e-02_r8,6.9920e-02_r8,7.5527e-02_r8, &
     &8.2000e-02_r8,9.0387e-02_r8,9.1968e-02_r8/)
      kao(:, 5, 4, 8) = (/ &
     &2.8301e-02_r8,5.2295e-02_r8,6.6272e-02_r8,7.6263e-02_r8,8.3883e-02_r8,9.0941e-02_r8, &
     &9.8884e-02_r8,1.0876e-01_r8,1.1102e-01_r8/)
      kao(:, 1, 5, 8) = (/ &
     &1.9932e-02_r8,2.8909e-02_r8,3.3929e-02_r8,3.6963e-02_r8,3.8599e-02_r8,3.9090e-02_r8, &
     &3.8100e-02_r8,3.6647e-02_r8,3.4570e-02_r8/)
      kao(:, 2, 5, 8) = (/ &
     &2.5221e-02_r8,3.6867e-02_r8,4.3184e-02_r8,4.7147e-02_r8,4.9394e-02_r8,5.0060e-02_r8, &
     &4.9016e-02_r8,4.7379e-02_r8,4.4959e-02_r8/)
      kao(:, 3, 5, 8) = (/ &
     &3.1232e-02_r8,4.5824e-02_r8,5.3773e-02_r8,5.8918e-02_r8,6.1826e-02_r8,6.2626e-02_r8, &
     &6.1399e-02_r8,5.9643e-02_r8,5.6358e-02_r8/)
      kao(:, 4, 5, 8) = (/ &
     &3.7911e-02_r8,5.5890e-02_r8,6.5835e-02_r8,7.2317e-02_r8,7.5820e-02_r8,7.6769e-02_r8, &
     &7.5408e-02_r8,7.3611e-02_r8,6.9498e-02_r8/)
      kao(:, 5, 5, 8) = (/ &
     &4.5225e-02_r8,6.7203e-02_r8,7.9322e-02_r8,8.7058e-02_r8,9.1394e-02_r8,9.2728e-02_r8, &
     &9.1290e-02_r8,8.9467e-02_r8,8.4545e-02_r8/)
      kao(:, 1, 6, 8) = (/ &
     &2.7668e-02_r8,3.4842e-02_r8,3.8147e-02_r8,3.9719e-02_r8,4.0056e-02_r8,3.9073e-02_r8, &
     &3.6625e-02_r8,3.2055e-02_r8,2.4026e-02_r8/)
      kao(:, 2, 6, 8) = (/ &
     &3.5525e-02_r8,4.5073e-02_r8,4.9553e-02_r8,5.1630e-02_r8,5.2026e-02_r8,5.0818e-02_r8, &
     &4.7728e-02_r8,4.1935e-02_r8,3.1627e-02_r8/)
      kao(:, 3, 6, 8) = (/ &
     &4.4689e-02_r8,5.6776e-02_r8,6.2560e-02_r8,6.5413e-02_r8,6.6041e-02_r8,6.4568e-02_r8, &
     &6.0721e-02_r8,5.3252e-02_r8,4.0421e-02_r8/)
      kao(:, 4, 6, 8) = (/ &
     &5.5122e-02_r8,7.0187e-02_r8,7.7371e-02_r8,8.1166e-02_r8,8.2060e-02_r8,8.0200e-02_r8, &
     &7.5289e-02_r8,6.6107e-02_r8,5.0711e-02_r8/)
      kao(:, 5, 6, 8) = (/ &
     &6.6674e-02_r8,8.5247e-02_r8,9.4184e-02_r8,9.8741e-02_r8,9.9891e-02_r8,9.7702e-02_r8, &
     &9.1660e-02_r8,8.0784e-02_r8,6.3321e-02_r8/)
      kao(:, 1, 7, 8) = (/ &
     &4.0056e-02_r8,4.4898e-02_r8,4.5971e-02_r8,4.5352e-02_r8,4.3659e-02_r8,4.0747e-02_r8, &
     &3.6554e-02_r8,3.0205e-02_r8,1.8196e-02_r8/)
      kao(:, 2, 7, 8) = (/ &
     &5.2185e-02_r8,5.8633e-02_r8,6.0480e-02_r8,6.0085e-02_r8,5.7874e-02_r8,5.4080e-02_r8, &
     &4.8546e-02_r8,4.0072e-02_r8,2.4060e-02_r8/)
      kao(:, 3, 7, 8) = (/ &
     &6.6434e-02_r8,7.5122e-02_r8,7.7544e-02_r8,7.7216e-02_r8,7.4584e-02_r8,6.9858e-02_r8, &
     &6.2703e-02_r8,5.1788e-02_r8,3.0507e-02_r8/)
      kao(:, 4, 7, 8) = (/ &
     &8.3239e-02_r8,9.4089e-02_r8,9.7312e-02_r8,9.7000e-02_r8,9.3885e-02_r8,8.8076e-02_r8, &
     &7.9042e-02_r8,6.5047e-02_r8,3.6382e-02_r8/)
      kao(:, 5, 7, 8) = (/ &
     &1.0221e-01_r8,1.1561e-01_r8,1.1992e-01_r8,1.1954e-01_r8,1.1572e-01_r8,1.0845e-01_r8, &
     &9.7278e-02_r8,8.0126e-02_r8,4.5426e-02_r8/)
      kao(:, 1, 8, 8) = (/ &
     &6.9306e-02_r8,6.9494e-02_r8,6.7600e-02_r8,6.3267e-02_r8,5.7322e-02_r8,5.0091e-02_r8, &
     &4.1741e-02_r8,3.1433e-02_r8,1.2053e-02_r8/)
      kao(:, 2, 8, 8) = (/ &
     &9.1357e-02_r8,9.2237e-02_r8,8.9335e-02_r8,8.3857e-02_r8,7.6444e-02_r8,6.7451e-02_r8, &
     &5.6474e-02_r8,4.2659e-02_r8,1.6127e-02_r8/)
      kao(:, 3, 8, 8) = (/ &
     &1.1801e-01_r8,1.1955e-01_r8,1.1588e-01_r8,1.0908e-01_r8,9.9881e-02_r8,8.8243e-02_r8, &
     &7.4146e-02_r8,5.6165e-02_r8,2.1600e-02_r8/)
      kao(:, 4, 8, 8) = (/ &
     &1.4950e-01_r8,1.5197e-01_r8,1.4749e-01_r8,1.3894e-01_r8,1.2736e-01_r8,1.1271e-01_r8, &
     &9.4953e-02_r8,7.1880e-02_r8,2.7972e-02_r8/)
      kao(:, 5, 8, 8) = (/ &
     &1.8646e-01_r8,1.8942e-01_r8,1.8392e-01_r8,1.7346e-01_r8,1.5924e-01_r8,1.4113e-01_r8, &
     &1.1856e-01_r8,8.9580e-02_r8,3.5566e-02_r8/)
      kao(:, 1, 9, 8) = (/ &
     &2.2096e-01_r8,1.9931e-01_r8,1.8126e-01_r8,1.6106e-01_r8,1.3834e-01_r8,1.1283e-01_r8, &
     &8.4790e-02_r8,5.3465e-02_r8,1.3124e-02_r8/)
      kao(:, 2, 9, 8) = (/ &
     &3.0111e-01_r8,2.7269e-01_r8,2.4731e-01_r8,2.1828e-01_r8,1.8616e-01_r8,1.5202e-01_r8, &
     &1.1457e-01_r8,7.2434e-02_r8,1.6890e-02_r8/)
      kao(:, 3, 9, 8) = (/ &
     &3.9547e-01_r8,3.5811e-01_r8,3.2380e-01_r8,2.8636e-01_r8,2.4465e-01_r8,1.9968e-01_r8, &
     &1.5075e-01_r8,9.6319e-02_r8,2.1030e-02_r8/)
      kao(:, 4, 9, 8) = (/ &
     &5.0622e-01_r8,4.6008e-01_r8,4.1701e-01_r8,3.6806e-01_r8,3.1477e-01_r8,2.5740e-01_r8, &
     &1.9504e-01_r8,1.2517e-01_r8,2.5567e-02_r8/)
      kao(:, 5, 9, 8) = (/ &
     &6.3970e-01_r8,5.8282e-01_r8,5.2753e-01_r8,4.6589e-01_r8,3.9821e-01_r8,3.2594e-01_r8, &
     &2.4744e-01_r8,1.5892e-01_r8,3.0707e-02_r8/)
      kao(:, 1,10, 8) = (/ &
     &7.9609e-01_r8,6.9877e-01_r8,6.0631e-01_r8,5.1323e-01_r8,4.2176e-01_r8,3.3040e-01_r8, &
     &2.3557e-01_r8,1.3340e-01_r8,1.8364e-02_r8/)
      kao(:, 2,10, 8) = (/ &
     &1.1185e+00_r8,9.8179e-01_r8,8.5163e-01_r8,7.2111e-01_r8,5.9292e-01_r8,4.6368e-01_r8, &
     &3.2777e-01_r8,1.8494e-01_r8,2.2731e-02_r8/)
      kao(:, 3,10, 8) = (/ &
     &1.4977e+00_r8,1.3152e+00_r8,1.1422e+00_r8,9.6927e-01_r8,7.9815e-01_r8,6.2269e-01_r8, &
     &4.4054e-01_r8,2.4719e-01_r8,2.7714e-02_r8/)
      kao(:, 4,10, 8) = (/ &
     &1.9588e+00_r8,1.7209e+00_r8,1.4963e+00_r8,1.2699e+00_r8,1.0440e+00_r8,8.1231e-01_r8, &
     &5.7215e-01_r8,3.2165e-01_r8,3.3541e-02_r8/)
      kao(:, 5,10, 8) = (/ &
     &2.4948e+00_r8,2.1931e+00_r8,1.9066e+00_r8,1.6194e+00_r8,1.3305e+00_r8,1.0363e+00_r8, &
     &7.3187e-01_r8,4.1258e-01_r8,3.9461e-02_r8/)
      kao(:, 1,11, 8) = (/ &
     &1.1786e+00_r8,1.0326e+00_r8,8.9194e-01_r8,7.5040e-01_r8,6.1100e-01_r8,4.7311e-01_r8, &
     &3.3100e-01_r8,1.8184e-01_r8,1.9912e-02_r8/)
      kao(:, 2,11, 8) = (/ &
     &1.6577e+00_r8,1.4527e+00_r8,1.2557e+00_r8,1.0583e+00_r8,8.6330e-01_r8,6.6758e-01_r8, &
     &4.6659e-01_r8,2.5585e-01_r8,2.4574e-02_r8/)
      kao(:, 3,11, 8) = (/ &
     &2.2529e+00_r8,1.9745e+00_r8,1.7078e+00_r8,1.4395e+00_r8,1.1743e+00_r8,9.0668e-01_r8, &
     &6.3142e-01_r8,3.4477e-01_r8,2.9771e-02_r8/)
      kao(:, 4,11, 8) = (/ &
     &2.9660e+00_r8,2.6012e+00_r8,2.2499e+00_r8,1.8975e+00_r8,1.5469e+00_r8,1.1941e+00_r8, &
     &8.2956e-01_r8,4.5247e-01_r8,3.5340e-02_r8/)
      kao(:, 5,11, 8) = (/ &
     &3.8252e+00_r8,3.3560e+00_r8,2.9025e+00_r8,2.4493e+00_r8,1.9962e+00_r8,1.5364e+00_r8, &
     &1.0662e+00_r8,5.8207e-01_r8,4.0740e-02_r8/)
      kao(:, 1,12, 8) = (/ &
     &1.3334e+00_r8,1.1683e+00_r8,1.0080e+00_r8,8.4695e-01_r8,6.8881e-01_r8,5.3043e-01_r8, &
     &3.6715e-01_r8,1.9749e-01_r8,1.8810e-02_r8/)
      kao(:, 2,12, 8) = (/ &
     &1.8510e+00_r8,1.6221e+00_r8,1.4015e+00_r8,1.1795e+00_r8,9.6045e-01_r8,7.4002e-01_r8, &
     &5.1281e-01_r8,2.7717e-01_r8,2.2865e-02_r8/)
      kao(:, 3,12, 8) = (/ &
     &2.5252e+00_r8,2.2140e+00_r8,1.9140e+00_r8,1.6128e+00_r8,1.3137e+00_r8,1.0115e+00_r8, &
     &6.9957e-01_r8,3.7776e-01_r8,2.7421e-02_r8/)
      kao(:, 4,12, 8) = (/ &
     &3.3724e+00_r8,2.9581e+00_r8,2.5564e+00_r8,2.1530e+00_r8,1.7520e+00_r8,1.3471e+00_r8, &
     &9.2947e-01_r8,5.0112e-01_r8,3.2393e-02_r8/)
      kao(:, 5,12, 8) = (/ &
     &4.3792e+00_r8,3.8422e+00_r8,3.3210e+00_r8,2.7983e+00_r8,2.2755e+00_r8,1.7461e+00_r8, &
     &1.2059e+00_r8,6.4752e-01_r8,3.7070e-02_r8/)
      kao(:, 1,13, 8) = (/ &
     &1.2116e+00_r8,1.0627e+00_r8,9.1758e-01_r8,7.7277e-01_r8,6.2996e-01_r8,4.8487e-01_r8, &
     &3.3536e-01_r8,1.7964e-01_r8,1.5468e-02_r8/)
      kao(:, 2,13, 8) = (/ &
     &1.6818e+00_r8,1.4755e+00_r8,1.2746e+00_r8,1.0748e+00_r8,8.7634e-01_r8,6.7377e-01_r8, &
     &4.6518e-01_r8,2.4901e-01_r8,1.8709e-02_r8/)
      kao(:, 3,13, 8) = (/ &
     &2.2861e+00_r8,2.0071e+00_r8,1.7358e+00_r8,1.4644e+00_r8,1.1940e+00_r8,9.1837e-01_r8, &
     &6.3513e-01_r8,3.4226e-01_r8,2.2464e-02_r8/)
      kao(:, 4,13, 8) = (/ &
     &3.0747e+00_r8,2.7003e+00_r8,2.3365e+00_r8,1.9712e+00_r8,1.6050e+00_r8,1.2324e+00_r8, &
     &8.5082e-01_r8,4.5761e-01_r8,2.6279e-02_r8/)
      kao(:, 5,13, 8) = (/ &
     &4.0462e+00_r8,3.5547e+00_r8,3.0752e+00_r8,2.5948e+00_r8,2.1107e+00_r8,1.6188e+00_r8, &
     &1.1159e+00_r8,5.9825e-01_r8,3.0261e-02_r8/)
      kao(:, 1, 1, 9) = (/ &
     &7.9433e-03_r8,4.9696e-02_r8,8.9399e-02_r8,1.2891e-01_r8,1.7031e-01_r8,2.1327e-01_r8, &
     &2.5635e-01_r8,2.9834e-01_r8,3.4005e-01_r8/)
      kao(:, 2, 1, 9) = (/ &
     &9.5773e-03_r8,6.0610e-02_r8,1.0882e-01_r8,1.5730e-01_r8,2.0827e-01_r8,2.6089e-01_r8, &
     &3.1374e-01_r8,3.6559e-01_r8,4.1584e-01_r8/)
      kao(:, 3, 1, 9) = (/ &
     &1.1355e-02_r8,7.2723e-02_r8,1.3048e-01_r8,1.8917e-01_r8,2.5096e-01_r8,3.1435e-01_r8, &
     &3.7828e-01_r8,4.4211e-01_r8,5.0107e-01_r8/)
      kao(:, 4, 1, 9) = (/ &
     &1.3277e-02_r8,8.6204e-02_r8,1.5483e-01_r8,2.2520e-01_r8,2.9933e-01_r8,3.7480e-01_r8, &
     &4.5117e-01_r8,5.2865e-01_r8,5.9762e-01_r8/)
      kao(:, 5, 1, 9) = (/ &
     &1.5326e-02_r8,1.0116e-01_r8,1.8188e-01_r8,2.6559e-01_r8,3.5380e-01_r8,4.4327e-01_r8, &
     &5.3402e-01_r8,6.2664e-01_r8,7.0640e-01_r8/)
      kao(:, 1, 2, 9) = (/ &
     &1.1776e-02_r8,4.7878e-02_r8,8.4972e-02_r8,1.1878e-01_r8,1.5366e-01_r8,1.9061e-01_r8, &
     &2.3033e-01_r8,2.7211e-01_r8,3.0314e-01_r8/)
      kao(:, 2, 2, 9) = (/ &
     &1.4294e-02_r8,5.8956e-02_r8,1.0416e-01_r8,1.4559e-01_r8,1.8871e-01_r8,2.3457e-01_r8, &
     &2.8358e-01_r8,3.3549e-01_r8,3.7290e-01_r8/)
      kao(:, 3, 2, 9) = (/ &
     &1.7066e-02_r8,7.1345e-02_r8,1.2565e-01_r8,1.7589e-01_r8,2.2857e-01_r8,2.8471e-01_r8, &
     &3.4402e-01_r8,4.0658e-01_r8,4.5272e-01_r8/)
      kao(:, 4, 2, 9) = (/ &
     &2.0089e-02_r8,8.5201e-02_r8,1.4972e-01_r8,2.1022e-01_r8,2.7384e-01_r8,3.4170e-01_r8, &
     &4.1272e-01_r8,4.8704e-01_r8,5.4350e-01_r8/)
      kao(:, 5, 2, 9) = (/ &
     &2.3307e-02_r8,1.0059e-01_r8,1.7602e-01_r8,2.4834e-01_r8,3.2442e-01_r8,4.0570e-01_r8, &
     &4.8998e-01_r8,5.7844e-01_r8,6.4523e-01_r8/)
      kao(:, 1, 3, 9) = (/ &
     &2.2348e-02_r8,5.0240e-02_r8,8.0496e-02_r8,1.1072e-01_r8,1.3814e-01_r8,1.6488e-01_r8, &
     &1.9401e-01_r8,2.2881e-01_r8,2.5470e-01_r8/)
      kao(:, 2, 3, 9) = (/ &
     &2.7442e-02_r8,6.2748e-02_r8,1.0008e-01_r8,1.3702e-01_r8,1.7047e-01_r8,2.0379e-01_r8, &
     &2.4015e-01_r8,2.8371e-01_r8,3.1563e-01_r8/)
      kao(:, 3, 3, 9) = (/ &
     &3.3066e-02_r8,7.6711e-02_r8,1.2229e-01_r8,1.6700e-01_r8,2.0740e-01_r8,2.4849e-01_r8, &
     &2.9339e-01_r8,3.4685e-01_r8,3.8604e-01_r8/)
      kao(:, 4, 3, 9) = (/ &
     &3.9269e-02_r8,9.2366e-02_r8,1.4749e-01_r8,2.0103e-01_r8,2.4924e-01_r8,2.9944e-01_r8, &
     &3.5443e-01_r8,4.1958e-01_r8,4.6663e-01_r8/)
      kao(:, 5, 3, 9) = (/ &
     &4.5933e-02_r8,1.0972e-01_r8,1.7562e-01_r8,2.3869e-01_r8,2.9592e-01_r8,3.5671e-01_r8, &
     &4.2354e-01_r8,5.0205e-01_r8,5.5762e-01_r8/)
      kao(:, 1, 4, 9) = (/ &
     &4.2106e-02_r8,6.4369e-02_r8,8.4555e-02_r8,1.0542e-01_r8,1.2690e-01_r8,1.4750e-01_r8, &
     &1.6487e-01_r8,1.8576e-01_r8,2.0651e-01_r8/)
      kao(:, 2, 4, 9) = (/ &
     &5.2576e-02_r8,8.1026e-02_r8,1.0683e-01_r8,1.3280e-01_r8,1.5950e-01_r8,1.8491e-01_r8, &
     &2.0655e-01_r8,2.3307e-01_r8,2.5966e-01_r8/)
      kao(:, 3, 4, 9) = (/ &
     &6.4079e-02_r8,9.9622e-02_r8,1.3194e-01_r8,1.6392e-01_r8,1.9672e-01_r8,2.2769e-01_r8, &
     &2.5451e-01_r8,2.8781e-01_r8,3.2142e-01_r8/)
      kao(:, 4, 4, 9) = (/ &
     &7.6781e-02_r8,1.2036e-01_r8,1.6040e-01_r8,1.9955e-01_r8,2.3909e-01_r8,2.7584e-01_r8, &
     &3.0872e-01_r8,3.5017e-01_r8,3.9149e-01_r8/)
      kao(:, 5, 4, 9) = (/ &
     &9.0605e-02_r8,1.4314e-01_r8,1.9223e-01_r8,2.3943e-01_r8,2.8645e-01_r8,3.2911e-01_r8, &
     &3.6945e-01_r8,4.2071e-01_r8,4.7061e-01_r8/)
      kao(:, 1, 5, 9) = (/ &
     &7.1850e-02_r8,8.9617e-02_r8,1.0358e-01_r8,1.1417e-01_r8,1.2410e-01_r8,1.3445e-01_r8, &
     &1.4500e-01_r8,1.5289e-01_r8,1.6393e-01_r8/)
      kao(:, 2, 5, 9) = (/ &
     &9.1160e-02_r8,1.1411e-01_r8,1.3218e-01_r8,1.4610e-01_r8,1.5890e-01_r8,1.7194e-01_r8, &
     &1.8487e-01_r8,1.9440e-01_r8,2.0899e-01_r8/)
      kao(:, 3, 5, 9) = (/ &
     &1.1266e-01_r8,1.4163e-01_r8,1.6452e-01_r8,1.8216e-01_r8,1.9856e-01_r8,2.1504e-01_r8, &
     &2.3093e-01_r8,2.4255e-01_r8,2.6179e-01_r8/)
      kao(:, 4, 5, 9) = (/ &
     &1.3642e-01_r8,1.7249e-01_r8,2.0078e-01_r8,2.2297e-01_r8,2.4396e-01_r8,2.6433e-01_r8, &
     &2.8347e-01_r8,2.9753e-01_r8,3.2213e-01_r8/)
      kao(:, 5, 5, 9) = (/ &
     &1.6239e-01_r8,2.0660e-01_r8,2.4114e-01_r8,2.6894e-01_r8,2.9484e-01_r8,3.1958e-01_r8, &
     &3.4207e-01_r8,3.5958e-01_r8,3.9095e-01_r8/)
      kao(:, 1, 6, 9) = (/ &
     &1.1140e-01_r8,1.2144e-01_r8,1.3218e-01_r8,1.3718e-01_r8,1.3653e-01_r8,1.3402e-01_r8, &
     &1.3174e-01_r8,1.2946e-01_r8,1.2677e-01_r8/)
      kao(:, 2, 6, 9) = (/ &
     &1.4420e-01_r8,1.5827e-01_r8,1.7119e-01_r8,1.7776e-01_r8,1.7742e-01_r8,1.7454e-01_r8, &
     &1.7134e-01_r8,1.6760e-01_r8,1.6399e-01_r8/)
      kao(:, 3, 6, 9) = (/ &
     &1.8124e-01_r8,2.0002e-01_r8,2.1589e-01_r8,2.2389e-01_r8,2.2423e-01_r8,2.2127e-01_r8, &
     &2.1711e-01_r8,2.1204e-01_r8,2.0793e-01_r8/)
      kao(:, 4, 6, 9) = (/ &
     &2.2248e-01_r8,2.4636e-01_r8,2.6609e-01_r8,2.7594e-01_r8,2.7715e-01_r8,2.7479e-01_r8, &
     &2.7017e-01_r8,2.6283e-01_r8,2.5856e-01_r8/)
      kao(:, 5, 6, 9) = (/ &
     &2.6774e-01_r8,2.9748e-01_r8,3.2183e-01_r8,3.3450e-01_r8,3.3675e-01_r8,3.3499e-01_r8, &
     &3.3006e-01_r8,3.2020e-01_r8,3.1680e-01_r8/)
      kao(:, 1, 7, 9) = (/ &
     &1.7732e-01_r8,1.7534e-01_r8,1.7803e-01_r8,1.7714e-01_r8,1.7022e-01_r8,1.5702e-01_r8, &
     &1.3821e-01_r8,1.1726e-01_r8,9.2624e-02_r8/)
      kao(:, 2, 7, 9) = (/ &
     &2.3477e-01_r8,2.3316e-01_r8,2.3664e-01_r8,2.3403e-01_r8,2.2497e-01_r8,2.0771e-01_r8, &
     &1.8285e-01_r8,1.5521e-01_r8,1.2312e-01_r8/)
      kao(:, 3, 7, 9) = (/ &
     &3.0054e-01_r8,2.9947e-01_r8,3.0371e-01_r8,2.9989e-01_r8,2.8797e-01_r8,2.6596e-01_r8, &
     &2.3476e-01_r8,1.9945e-01_r8,1.5929e-01_r8/)
      kao(:, 4, 7, 9) = (/ &
     &3.7459e-01_r8,3.7495e-01_r8,3.7937e-01_r8,3.7465e-01_r8,3.5915e-01_r8,3.3235e-01_r8, &
     &2.9471e-01_r8,2.5108e-01_r8,2.0370e-01_r8/)
      kao(:, 5, 7, 9) = (/ &
     &4.5653e-01_r8,4.5857e-01_r8,4.6346e-01_r8,4.5781e-01_r8,4.3887e-01_r8,4.0748e-01_r8, &
     &3.6268e-01_r8,3.0976e-01_r8,2.5195e-01_r8/)
      kao(:, 1, 8, 9) = (/ &
     &3.3219e-01_r8,3.0467e-01_r8,2.8618e-01_r8,2.6721e-01_r8,2.4601e-01_r8,2.1811e-01_r8, &
     &1.8145e-01_r8,1.3269e-01_r8,6.6401e-02_r8/)
      kao(:, 2, 8, 9) = (/ &
     &4.4950e-01_r8,4.1374e-01_r8,3.8999e-01_r8,3.6461e-01_r8,3.3388e-01_r8,2.9490e-01_r8, &
     &2.4508e-01_r8,1.7935e-01_r8,9.0026e-02_r8/)
      kao(:, 3, 8, 9) = (/ &
     &5.8717e-01_r8,5.4166e-01_r8,5.1100e-01_r8,4.7736e-01_r8,4.3579e-01_r8,3.8461e-01_r8, &
     &3.1925e-01_r8,2.3358e-01_r8,1.1833e-01_r8/)
      kao(:, 4, 8, 9) = (/ &
     &7.4406e-01_r8,6.8778e-01_r8,6.4996e-01_r8,6.0622e-01_r8,5.5241e-01_r8,4.8728e-01_r8, &
     &4.0419e-01_r8,2.9657e-01_r8,1.5189e-01_r8/)
      kao(:, 5, 8, 9) = (/ &
     &9.1907e-01_r8,8.5125e-01_r8,8.0569e-01_r8,7.5012e-01_r8,6.8369e-01_r8,6.0185e-01_r8, &
     &4.9995e-01_r8,3.6832e-01_r8,1.9101e-01_r8/)
      kao(:, 1, 9, 9) = (/ &
     &1.1485e+00_r8,1.0089e+00_r8,8.7880e-01_r8,7.5762e-01_r8,6.3622e-01_r8,5.1377e-01_r8, &
     &3.9068e-01_r8,2.5323e-01_r8,5.4057e-02_r8/)
      kao(:, 2, 9, 9) = (/ &
     &1.5919e+00_r8,1.3983e+00_r8,1.2193e+00_r8,1.0539e+00_r8,8.8759e-01_r8,7.1827e-01_r8, &
     &5.4603e-01_r8,3.5236e-01_r8,7.3567e-02_r8/)
      kao(:, 3, 9, 9) = (/ &
     &2.1202e+00_r8,1.8629e+00_r8,1.6282e+00_r8,1.4084e+00_r8,1.1875e+00_r8,9.6283e-01_r8, &
     &7.2992e-01_r8,4.6911e-01_r8,9.7269e-02_r8/)
      kao(:, 4, 9, 9) = (/ &
     &2.7354e+00_r8,2.4050e+00_r8,2.1038e+00_r8,1.8214e+00_r8,1.5366e+00_r8,1.2471e+00_r8, &
     &9.4177e-01_r8,6.0391e-01_r8,1.2338e-01_r8/)
      kao(:, 5, 9, 9) = (/ &
     &3.4317e+00_r8,3.0176e+00_r8,2.6421e+00_r8,2.2877e+00_r8,1.9310e+00_r8,1.5677e+00_r8, &
     &1.1814e+00_r8,7.5635e-01_r8,1.5353e-01_r8/)
      kao(:, 1,10, 9) = (/ &
     &4.4436e+00_r8,3.8882e+00_r8,3.3348e+00_r8,2.7888e+00_r8,2.2477e+00_r8,1.7134e+00_r8, &
     &1.1871e+00_r8,6.5782e-01_r8,7.0663e-02_r8/)
      kao(:, 2,10, 9) = (/ &
     &6.2997e+00_r8,5.5124e+00_r8,4.7288e+00_r8,3.9559e+00_r8,3.1897e+00_r8,2.4334e+00_r8, &
     &1.6915e+00_r8,9.3954e-01_r8,8.7418e-02_r8/)
      kao(:, 3,10, 9) = (/ &
     &8.5619e+00_r8,7.4925e+00_r8,6.4279e+00_r8,5.3771e+00_r8,4.3365e+00_r8,3.3136e+00_r8, &
     &2.3060e+00_r8,1.2843e+00_r8,1.0436e-01_r8/)
      kao(:, 4,10, 9) = (/ &
     &1.1219e+01_r8,9.8180e+00_r8,8.4228e+00_r8,7.0486e+00_r8,5.6898e+00_r8,4.3532e+00_r8, &
     &3.0319e+00_r8,1.6916e+00_r8,1.2593e-01_r8/)
      kao(:, 5,10, 9) = (/ &
     &1.4295e+01_r8,1.2510e+01_r8,1.0734e+01_r8,8.9819e+00_r8,7.2530e+00_r8,5.5514e+00_r8, &
     &3.8643e+00_r8,2.1564e+00_r8,1.5004e-01_r8/)
      kao(:, 1,11, 9) = (/ &
     &7.0050e+00_r8,6.1296e+00_r8,5.2549e+00_r8,4.3868e+00_r8,3.5242e+00_r8,2.6669e+00_r8, &
     &1.8245e+00_r8,9.8168e-01_r8,8.5745e-02_r8/)
      kao(:, 2,11, 9) = (/ &
     &9.9554e+00_r8,8.7114e+00_r8,7.4687e+00_r8,6.2351e+00_r8,5.0098e+00_r8,3.7942e+00_r8, &
     &2.5980e+00_r8,1.4001e+00_r8,1.0478e-01_r8/)
      kao(:, 3,11, 9) = (/ &
     &1.3533e+01_r8,1.1842e+01_r8,1.0152e+01_r8,8.4771e+00_r8,6.8123e+00_r8,5.1640e+00_r8, &
     &3.5405e+00_r8,1.9111e+00_r8,1.2573e-01_r8/)
      kao(:, 4,11, 9) = (/ &
     &1.7771e+01_r8,1.5551e+01_r8,1.3333e+01_r8,1.1134e+01_r8,8.9512e+00_r8,6.7876e+00_r8, &
     &4.6577e+00_r8,2.5172e+00_r8,1.4855e-01_r8/)
      kao(:, 5,11, 9) = (/ &
     &2.2680e+01_r8,1.9846e+01_r8,1.7019e+01_r8,1.4214e+01_r8,1.1430e+01_r8,8.6745e+00_r8, &
     &5.9538e+00_r8,3.2175e+00_r8,1.7203e-01_r8/)
      kao(:, 1,12, 9) = (/ &
     &8.1047e+00_r8,7.0920e+00_r8,6.0802e+00_r8,5.0761e+00_r8,4.0767e+00_r8,3.0841e+00_r8, &
     &2.1058e+00_r8,1.1266e+00_r8,9.0852e-02_r8/)
      kao(:, 2,12, 9) = (/ &
     &1.1567e+01_r8,1.0121e+01_r8,8.6775e+00_r8,7.2441e+00_r8,5.8181e+00_r8,4.4027e+00_r8, &
     &3.0080e+00_r8,1.6091e+00_r8,1.1081e-01_r8/)
      kao(:, 3,12, 9) = (/ &
     &1.5756e+01_r8,1.3787e+01_r8,1.1820e+01_r8,9.8684e+00_r8,7.9263e+00_r8,6.0014e+00_r8, &
     &4.1030e+00_r8,2.1969e+00_r8,1.3256e-01_r8/)
      kao(:, 4,12, 9) = (/ &
     &2.0731e+01_r8,1.8141e+01_r8,1.5554e+01_r8,1.2989e+01_r8,1.0436e+01_r8,7.9047e+00_r8, &
     &5.4071e+00_r8,2.8962e+00_r8,1.5690e-01_r8/)
      kao(:, 5,12, 9) = (/ &
     &2.6483e+01_r8,2.3176e+01_r8,1.9872e+01_r8,1.6594e+01_r8,1.3339e+01_r8,1.0111e+01_r8, &
     &6.9150e+00_r8,3.7095e+00_r8,1.8186e-01_r8/)
      kao(:, 1,13, 9) = (/ &
     &7.4699e+00_r8,6.5364e+00_r8,5.6062e+00_r8,4.6835e+00_r8,3.7650e+00_r8,2.8555e+00_r8, &
     &1.9560e+00_r8,1.0515e+00_r8,8.5273e-02_r8/)
      kao(:, 2,13, 9) = (/ &
     &1.0680e+01_r8,9.3454e+00_r8,8.0165e+00_r8,6.6976e+00_r8,5.3854e+00_r8,4.0877e+00_r8, &
     &2.8036e+00_r8,1.5078e+00_r8,1.0411e-01_r8/)
      kao(:, 3,13, 9) = (/ &
     &1.4620e+01_r8,1.2793e+01_r8,1.0973e+01_r8,9.1678e+00_r8,7.3735e+00_r8,5.5972e+00_r8, &
     &3.8382e+00_r8,2.0618e+00_r8,1.2386e-01_r8/)
      kao(:, 4,13, 9) = (/ &
     &1.9258e+01_r8,1.6852e+01_r8,1.4455e+01_r8,1.2079e+01_r8,9.7197e+00_r8,7.3817e+00_r8, &
     &5.0639e+00_r8,2.7225e+00_r8,1.4610e-01_r8/)
      kao(:, 5,13, 9) = (/ &
     &2.4621e+01_r8,2.1546e+01_r8,1.8485e+01_r8,1.5448e+01_r8,1.2432e+01_r8,9.4454e+00_r8, &
     &6.4771e+00_r8,3.4853e+00_r8,1.7007e-01_r8/)
      kao(:, 1, 1,10) = (/ &
     &1.3879e-02_r8,1.0986e-01_r8,1.9192e-01_r8,2.8700e-01_r8,3.8129e-01_r8,4.7527e-01_r8, &
     &5.7067e-01_r8,6.6779e-01_r8,7.6243e-01_r8/)
      kao(:, 2, 1,10) = (/ &
     &1.6954e-02_r8,1.3303e-01_r8,2.3564e-01_r8,3.5200e-01_r8,4.6702e-01_r8,5.8054e-01_r8, &
     &6.9523e-01_r8,8.1372e-01_r8,9.3367e-01_r8/)
      kao(:, 3, 1,10) = (/ &
     &2.0369e-02_r8,1.5906e-01_r8,2.8523e-01_r8,4.2640e-01_r8,5.6627e-01_r8,7.0405e-01_r8, &
     &8.3748e-01_r8,9.6604e-01_r8,1.1321e+00_r8/)
      kao(:, 4, 1,10) = (/ &
     &2.4061e-02_r8,1.8742e-01_r8,3.4065e-01_r8,5.0987e-01_r8,6.7810e-01_r8,8.4492e-01_r8, &
     &1.0078e+00_r8,1.1403e+00_r8,1.3558e+00_r8/)
      kao(:, 5, 1,10) = (/ &
     &2.7911e-02_r8,2.1680e-01_r8,4.0347e-01_r8,6.0365e-01_r8,8.0163e-01_r8,9.9663e-01_r8, &
     &1.1842e+00_r8,1.3430e+00_r8,1.6028e+00_r8/)
      kao(:, 1, 2,10) = (/ &
     &2.2158e-02_r8,1.1276e-01_r8,1.8891e-01_r8,2.7518e-01_r8,3.6524e-01_r8,4.5317e-01_r8, &
     &5.3652e-01_r8,6.1296e-01_r8,7.3020e-01_r8/)
      kao(:, 2, 2,10) = (/ &
     &2.7256e-02_r8,1.3808e-01_r8,2.3100e-01_r8,3.4051e-01_r8,4.5180e-01_r8,5.6015e-01_r8, &
     &6.6160e-01_r8,7.4973e-01_r8,9.0314e-01_r8/)
      kao(:, 3, 2,10) = (/ &
     &3.2742e-02_r8,1.6645e-01_r8,2.7575e-01_r8,4.1007e-01_r8,5.4427e-01_r8,6.7555e-01_r8, &
     &8.0050e-01_r8,9.1019e-01_r8,1.0879e+00_r8/)
      kao(:, 4, 2,10) = (/ &
     &3.8593e-02_r8,1.9807e-01_r8,3.2475e-01_r8,4.8552e-01_r8,6.4531e-01_r8,8.0341e-01_r8, &
     &9.5786e-01_r8,1.0994e+00_r8,1.2898e+00_r8/)
      kao(:, 5, 2,10) = (/ &
     &4.4713e-02_r8,2.3139e-01_r8,3.8401e-01_r8,5.7431e-01_r8,7.6329e-01_r8,9.5026e-01_r8, &
     &1.1317e+00_r8,1.3007e+00_r8,1.5256e+00_r8/)
      kao(:, 1, 3,10) = (/ &
     &4.4889e-02_r8,1.1945e-01_r8,1.9910e-01_r8,2.6592e-01_r8,3.2716e-01_r8,4.0820e-01_r8, &
     &4.8832e-01_r8,5.6450e-01_r8,6.5333e-01_r8/)
      kao(:, 2, 3,10) = (/ &
     &5.6096e-02_r8,1.4847e-01_r8,2.4845e-01_r8,3.3071e-01_r8,4.1171e-01_r8,5.1418e-01_r8, &
     &6.1578e-01_r8,7.1081e-01_r8,8.2224e-01_r8/)
      kao(:, 3, 3,10) = (/ &
     &6.8702e-02_r8,1.8161e-01_r8,3.0124e-01_r8,3.9617e-01_r8,5.0089e-01_r8,6.2554e-01_r8, &
     &7.4933e-01_r8,8.6662e-01_r8,1.0003e+00_r8/)
      kao(:, 4, 3,10) = (/ &
     &8.1949e-02_r8,2.1813e-01_r8,3.5788e-01_r8,4.6675e-01_r8,6.0112e-01_r8,7.4982e-01_r8, &
     &8.9722e-01_r8,1.0369e+00_r8,1.1996e+00_r8/)
      kao(:, 5, 3,10) = (/ &
     &9.5752e-02_r8,2.5792e-01_r8,4.1860e-01_r8,5.4742e-01_r8,7.1669e-01_r8,8.9255e-01_r8, &
     &1.0648e+00_r8,1.2234e+00_r8,1.4293e+00_r8/)
      kao(:, 1, 4,10) = (/ &
     &9.2779e-02_r8,1.3647e-01_r8,2.0374e-01_r8,2.6880e-01_r8,3.2474e-01_r8,3.6630e-01_r8, &
     &4.2915e-01_r8,4.9644e-01_r8,5.7357e-01_r8/)
      kao(:, 2, 4,10) = (/ &
     &1.1604e-01_r8,1.7477e-01_r8,2.5924e-01_r8,3.4288e-01_r8,4.1143e-01_r8,4.5661e-01_r8, &
     &5.3933e-01_r8,6.2792e-01_r8,7.1853e-01_r8/)
      kao(:, 3, 4,10) = (/ &
     &1.4325e-01_r8,2.1810e-01_r8,3.2204e-01_r8,4.2345e-01_r8,5.0270e-01_r8,5.5390e-01_r8, &
     &6.5839e-01_r8,7.6862e-01_r8,8.7526e-01_r8/)
      kao(:, 4, 4,10) = (/ &
     &1.7320e-01_r8,2.6694e-01_r8,3.8938e-01_r8,5.0945e-01_r8,6.0406e-01_r8,6.6936e-01_r8, &
     &8.0058e-01_r8,9.3405e-01_r8,1.0639e+00_r8/)
      kao(:, 5, 4,10) = (/ &
     &2.0528e-01_r8,3.2153e-01_r8,4.6268e-01_r8,6.0392e-01_r8,7.1636e-01_r8,8.0678e-01_r8, &
     &9.6596e-01_r8,1.1248e+00_r8,1.2848e+00_r8/)
      kao(:, 1, 5,10) = (/ &
     &1.7241e-01_r8,1.8815e-01_r8,2.2088e-01_r8,2.6810e-01_r8,3.2220e-01_r8,3.6810e-01_r8, &
     &3.9585e-01_r8,4.3476e-01_r8,4.9559e-01_r8/)
      kao(:, 2, 5,10) = (/ &
     &2.1928e-01_r8,2.4297e-01_r8,2.8762e-01_r8,3.4907e-01_r8,4.1506e-01_r8,4.6919e-01_r8, &
     &4.9756e-01_r8,5.5222e-01_r8,6.2884e-01_r8/)
      kao(:, 3, 5,10) = (/ &
     &2.7265e-01_r8,3.0607e-01_r8,3.6483e-01_r8,4.4370e-01_r8,5.1761e-01_r8,5.7690e-01_r8, &
     &6.0530e-01_r8,6.7866e-01_r8,7.7290e-01_r8/)
      kao(:, 4, 5,10) = (/ &
     &3.3288e-01_r8,3.7610e-01_r8,4.5166e-01_r8,5.4662e-01_r8,6.2951e-01_r8,6.9865e-01_r8, &
     &7.2973e-01_r8,8.2842e-01_r8,9.4575e-01_r8/)
      kao(:, 5, 5,10) = (/ &
     &3.9915e-01_r8,4.5195e-01_r8,5.4707e-01_r8,6.6103e-01_r8,7.5773e-01_r8,8.3891e-01_r8, &
     &8.7097e-01_r8,1.0005e+00_r8,1.1404e+00_r8/)
      kao(:, 1, 6,10) = (/ &
     &2.9778e-01_r8,2.8967e-01_r8,2.9242e-01_r8,2.9076e-01_r8,3.1606e-01_r8,3.5216e-01_r8, &
     &3.7514e-01_r8,3.6360e-01_r8,4.0286e-01_r8/)
      kao(:, 2, 6,10) = (/ &
     &3.8364e-01_r8,3.7347e-01_r8,3.8384e-01_r8,3.8402e-01_r8,4.1811e-01_r8,4.6141e-01_r8, &
     &4.8908e-01_r8,4.6937e-01_r8,5.2349e-01_r8/)
      kao(:, 3, 6,10) = (/ &
     &4.8196e-01_r8,4.7366e-01_r8,4.8805e-01_r8,4.9747e-01_r8,5.3761e-01_r8,5.8138e-01_r8, &
     &6.1239e-01_r8,5.8662e-01_r8,6.5890e-01_r8/)
      kao(:, 4, 6,10) = (/ &
     &5.9004e-01_r8,5.9246e-01_r8,6.0698e-01_r8,6.2535e-01_r8,6.7125e-01_r8,7.1432e-01_r8, &
     &7.4926e-01_r8,7.2627e-01_r8,8.2202e-01_r8/)
      kao(:, 5, 6,10) = (/ &
     &7.1225e-01_r8,7.2336e-01_r8,7.3969e-01_r8,7.6299e-01_r8,8.2248e-01_r8,8.6951e-01_r8, &
     &9.0679e-01_r8,8.7991e-01_r8,1.0003e+00_r8/)
      kao(:, 1, 7,10) = (/ &
     &5.2983e-01_r8,4.8709e-01_r8,4.4813e-01_r8,4.1883e-01_r8,3.8710e-01_r8,3.5910e-01_r8, &
     &3.5198e-01_r8,3.4364e-01_r8,3.2708e-01_r8/)
      kao(:, 2, 7,10) = (/ &
     &6.9820e-01_r8,6.4182e-01_r8,5.9773e-01_r8,5.6199e-01_r8,5.1585e-01_r8,4.8198e-01_r8, &
     &4.7538e-01_r8,4.5593e-01_r8,4.2838e-01_r8/)
      kao(:, 3, 7,10) = (/ &
     &8.9166e-01_r8,8.2011e-01_r8,7.7520e-01_r8,7.2195e-01_r8,6.6977e-01_r8,6.2908e-01_r8, &
     &6.1720e-01_r8,5.8358e-01_r8,5.4876e-01_r8/)
      kao(:, 4, 7,10) = (/ &
     &1.1048e+00_r8,1.0150e+00_r8,9.7493e-01_r8,9.0555e-01_r8,8.5261e-01_r8,7.9496e-01_r8, &
     &7.7495e-01_r8,7.2954e-01_r8,6.9328e-01_r8/)
      kao(:, 5, 7,10) = (/ &
     &1.3386e+00_r8,1.2295e+00_r8,1.1950e+00_r8,1.1151e+00_r8,1.0543e+00_r8,9.8064e-01_r8, &
     &9.5591e-01_r8,8.9484e-01_r8,8.5404e-01_r8/)
      kao(:, 1, 8,10) = (/ &
     &1.0881e+00_r8,9.5225e-01_r8,8.5699e-01_r8,7.4043e-01_r8,6.3719e-01_r8,5.4699e-01_r8, &
     &4.4366e-01_r8,3.3722e-01_r8,2.5365e-01_r8/)
      kao(:, 2, 8,10) = (/ &
     &1.4729e+00_r8,1.2892e+00_r8,1.1603e+00_r8,1.0057e+00_r8,8.7735e-01_r8,7.4624e-01_r8, &
     &6.0685e-01_r8,4.5839e-01_r8,3.4968e-01_r8/)
      kao(:, 3, 8,10) = (/ &
     &1.9193e+00_r8,1.6816e+00_r8,1.5156e+00_r8,1.3265e+00_r8,1.1534e+00_r8,9.7741e-01_r8, &
     &7.9951e-01_r8,6.0809e-01_r8,4.5275e-01_r8/)
      kao(:, 4, 8,10) = (/ &
     &2.4196e+00_r8,2.1220e+00_r8,1.9097e+00_r8,1.6942e+00_r8,1.4693e+00_r8,1.2439e+00_r8, &
     &1.0194e+00_r8,7.8139e-01_r8,5.7536e-01_r8/)
      kao(:, 5, 8,10) = (/ &
     &2.9662e+00_r8,2.6064e+00_r8,2.3390e+00_r8,2.0966e+00_r8,1.8122e+00_r8,1.5517e+00_r8, &
     &1.2698e+00_r8,9.8175e-01_r8,7.1420e-01_r8/)
      kao(:, 1, 9,10) = (/ &
     &4.0693e+00_r8,3.5609e+00_r8,3.0521e+00_r8,2.5470e+00_r8,2.0946e+00_r8,1.6231e+00_r8, &
     &1.1342e+00_r8,6.9341e-01_r8,2.3254e-01_r8/)
      kao(:, 2, 9,10) = (/ &
     &5.6525e+00_r8,4.9459e+00_r8,4.2396e+00_r8,3.5367e+00_r8,2.9143e+00_r8,2.2533e+00_r8, &
     &1.5867e+00_r8,9.6567e-01_r8,2.9706e-01_r8/)
      kao(:, 3, 9,10) = (/ &
     &7.5336e+00_r8,6.5921e+00_r8,5.6502e+00_r8,4.7197e+00_r8,3.8915e+00_r8,3.0030e+00_r8, &
     &2.1420e+00_r8,1.2862e+00_r8,3.6402e-01_r8/)
      kao(:, 4, 9,10) = (/ &
     &9.6696e+00_r8,8.4608e+00_r8,7.2526e+00_r8,6.0675e+00_r8,4.9886e+00_r8,3.8558e+00_r8, &
     &2.7779e+00_r8,1.6618e+00_r8,4.0961e-01_r8/)
      kao(:, 5, 9,10) = (/ &
     &1.2059e+01_r8,1.0552e+01_r8,9.0447e+00_r8,7.5858e+00_r8,6.2136e+00_r8,4.8233e+00_r8, &
     &3.4799e+00_r8,2.0915e+00_r8,3.7531e-01_r8/)
      kao(:, 1,10,10) = (/ &
     &1.7088e+01_r8,1.4952e+01_r8,1.2816e+01_r8,1.0681e+01_r8,8.5444e+00_r8,6.4081e+00_r8, &
     &4.3169e+00_r8,2.2612e+00_r8,1.5325e-01_r8/)
      kao(:, 2,10,10) = (/ &
     &2.4265e+01_r8,2.1232e+01_r8,1.8199e+01_r8,1.5167e+01_r8,1.2132e+01_r8,9.0996e+00_r8, &
     &6.1194e+00_r8,3.2115e+00_r8,2.0907e-01_r8/)
      kao(:, 3,10,10) = (/ &
     &3.2859e+01_r8,2.8752e+01_r8,2.4646e+01_r8,2.0537e+01_r8,1.6430e+01_r8,1.2323e+01_r8, &
     &8.2885e+00_r8,4.3528e+00_r8,2.8093e-01_r8/)
      kao(:, 4,10,10) = (/ &
     &4.2869e+01_r8,3.7512e+01_r8,3.2153e+01_r8,2.6795e+01_r8,2.1435e+01_r8,1.6077e+01_r8, &
     &1.0833e+01_r8,5.6764e+00_r8,3.4638e-01_r8/)
      kao(:, 5,10,10) = (/ &
     &5.4098e+01_r8,4.7336e+01_r8,4.0575e+01_r8,3.3816e+01_r8,2.7052e+01_r8,2.0291e+01_r8, &
     &1.3707e+01_r8,7.1952e+00_r8,4.8935e-01_r8/)
      kao(:, 1,11,10) = (/ &
     &2.9317e+01_r8,2.5652e+01_r8,2.1987e+01_r8,1.8324e+01_r8,1.4658e+01_r8,1.0994e+01_r8, &
     &7.3313e+00_r8,3.7877e+00_r8,2.2554e-01_r8/)
      kao(:, 2,11,10) = (/ &
     &4.1549e+01_r8,3.6355e+01_r8,3.1162e+01_r8,2.5968e+01_r8,2.0775e+01_r8,1.5581e+01_r8, &
     &1.0388e+01_r8,5.3868e+00_r8,2.3983e-01_r8/)
      kao(:, 3,11,10) = (/ &
     &5.6191e+01_r8,4.9168e+01_r8,4.2143e+01_r8,3.5117e+01_r8,2.8096e+01_r8,2.1071e+01_r8, &
     &1.4052e+01_r8,7.2903e+00_r8,2.8347e-01_r8/)
      kao(:, 4,11,10) = (/ &
     &7.3162e+01_r8,6.4016e+01_r8,5.4871e+01_r8,4.5729e+01_r8,3.6583e+01_r8,2.7439e+01_r8, &
     &1.8309e+01_r8,9.4965e+00_r8,3.4363e-01_r8/)
      kao(:, 5,11,10) = (/ &
     &9.2126e+01_r8,8.0611e+01_r8,6.9095e+01_r8,5.7582e+01_r8,4.6068e+01_r8,3.4554e+01_r8, &
     &2.3073e+01_r8,1.1954e+01_r8,4.6470e-01_r8/)
      kao(:, 1,12,10) = (/ &
     &3.6684e+01_r8,3.2099e+01_r8,2.7514e+01_r8,2.2927e+01_r8,1.8342e+01_r8,1.3757e+01_r8, &
     &9.1743e+00_r8,4.7217e+00_r8,2.6068e-01_r8/)
      kao(:, 2,12,10) = (/ &
     &5.1868e+01_r8,4.5387e+01_r8,3.8901e+01_r8,3.2419e+01_r8,2.5934e+01_r8,1.9452e+01_r8, &
     &1.2967e+01_r8,6.6916e+00_r8,2.7916e-01_r8/)
      kao(:, 3,12,10) = (/ &
     &7.0081e+01_r8,6.1322e+01_r8,5.2561e+01_r8,4.3801e+01_r8,3.5043e+01_r8,2.6282e+01_r8, &
     &1.7526e+01_r8,9.0530e+00_r8,3.3145e-01_r8/)
      kao(:, 4,12,10) = (/ &
     &9.0957e+01_r8,7.9591e+01_r8,6.8227e+01_r8,5.6859e+01_r8,4.5488e+01_r8,3.4114e+01_r8, &
     &2.2760e+01_r8,1.1751e+01_r8,3.6053e-01_r8/)
      kao(:, 5,12,10) = (/ &
     &1.1478e+02_r8,1.0044e+02_r8,8.6086e+01_r8,7.1743e+01_r8,5.7394e+01_r8,4.3046e+01_r8, &
     &2.8737e+01_r8,1.4814e+01_r8,4.5144e-01_r8/)
      kao(:, 1,13,10) = (/ &
     &3.5965e+01_r8,3.1472e+01_r8,2.6975e+01_r8,2.2479e+01_r8,1.7984e+01_r8,1.3488e+01_r8, &
     &9.0232e+00_r8,4.6648e+00_r8,2.4705e-01_r8/)
      kao(:, 2,13,10) = (/ &
     &5.0800e+01_r8,4.4451e+01_r8,3.8101e+01_r8,3.1752e+01_r8,2.5403e+01_r8,1.9053e+01_r8, &
     &1.2739e+01_r8,6.5982e+00_r8,2.8941e-01_r8/)
      kao(:, 3,13,10) = (/ &
     &6.8393e+01_r8,5.9846e+01_r8,5.1296e+01_r8,4.2746e+01_r8,3.4199e+01_r8,2.5650e+01_r8, &
     &1.7151e+01_r8,8.8890e+00_r8,3.3776e-01_r8/)
      kao(:, 4,13,10) = (/ &
     &8.8957e+01_r8,7.7837e+01_r8,6.6721e+01_r8,5.5604e+01_r8,4.4485e+01_r8,3.3364e+01_r8, &
     &2.2331e+01_r8,1.1554e+01_r8,3.9400e-01_r8/)
      kao(:, 5,13,10) = (/ &
     &1.1248e+02_r8,9.8422e+01_r8,8.4359e+01_r8,7.0296e+01_r8,5.6240e+01_r8,4.2182e+01_r8, &
     &2.8274e+01_r8,1.4614e+01_r8,4.6294e-01_r8/)
      kao(:, 1, 1,11) = (/ &
     &2.0991e-02_r8,1.4510e-01_r8,2.7530e-01_r8,4.1253e-01_r8,5.4888e-01_r8,6.8317e-01_r8, &
     &8.1040e-01_r8,9.0204e-01_r8,1.0977e+00_r8/)
      kao(:, 2, 1,11) = (/ &
     &2.6377e-02_r8,1.7420e-01_r8,3.3534e-01_r8,5.0284e-01_r8,6.6978e-01_r8,8.3508e-01_r8, &
     &9.9362e-01_r8,1.1152e+00_r8,1.3395e+00_r8/)
      kao(:, 3, 1,11) = (/ &
     &3.2301e-02_r8,2.0470e-01_r8,4.0014e-01_r8,5.9936e-01_r8,7.9730e-01_r8,9.9294e-01_r8, &
     &1.1840e+00_r8,1.3371e+00_r8,1.5943e+00_r8/)
      kao(:, 4, 1,11) = (/ &
     &3.8610e-02_r8,2.3990e-01_r8,4.7445e-01_r8,7.0939e-01_r8,9.4186e-01_r8,1.1687e+00_r8, &
     &1.3842e+00_r8,1.5657e+00_r8,1.8832e+00_r8/)
      kao(:, 5, 1,11) = (/ &
     &4.5285e-02_r8,2.8044e-01_r8,5.5866e-01_r8,8.3454e-01_r8,1.1074e+00_r8,1.3742e+00_r8, &
     &1.6243e+00_r8,1.8087e+00_r8,2.2141e+00_r8/)
      kao(:, 1, 2,11) = (/ &
     &3.0334e-02_r8,1.5806e-01_r8,2.5391e-01_r8,3.8056e-01_r8,5.0695e-01_r8,6.3318e-01_r8, &
     &7.5908e-01_r8,8.7813e-01_r8,1.0138e+00_r8/)
      kao(:, 2, 2,11) = (/ &
     &3.8224e-02_r8,1.9234e-01_r8,3.1173e-01_r8,4.6706e-01_r8,6.2209e-01_r8,7.7707e-01_r8, &
     &9.3334e-01_r8,1.0857e+00_r8,1.2438e+00_r8/)
      kao(:, 3, 2,11) = (/ &
     &4.7042e-02_r8,2.2793e-01_r8,3.7775e-01_r8,5.6573e-01_r8,7.5275e-01_r8,9.3856e-01_r8, &
     &1.1227e+00_r8,1.3034e+00_r8,1.5049e+00_r8/)
      kao(:, 4, 2,11) = (/ &
     &5.6790e-02_r8,2.6663e-01_r8,4.5515e-01_r8,6.8101e-01_r8,9.0489e-01_r8,1.1244e+00_r8, &
     &1.3363e+00_r8,1.5352e+00_r8,1.8090e+00_r8/)
      kao(:, 5, 2,11) = (/ &
     &6.7198e-02_r8,3.0909e-01_r8,5.3855e-01_r8,8.0620e-01_r8,1.0720e+00_r8,1.3339e+00_r8, &
     &1.5872e+00_r8,1.8075e+00_r8,2.1432e+00_r8/)
      kao(:, 1, 3,11) = (/ &
     &5.8386e-02_r8,1.7533e-01_r8,2.7134e-01_r8,3.4280e-01_r8,4.5327e-01_r8,5.6550e-01_r8, &
     &6.7606e-01_r8,7.8244e-01_r8,9.0646e-01_r8/)
      kao(:, 2, 3,11) = (/ &
     &7.4136e-02_r8,2.1912e-01_r8,3.3311e-01_r8,4.2266e-01_r8,5.6203e-01_r8,7.0075e-01_r8, &
     &8.3707e-01_r8,9.6959e-01_r8,1.1236e+00_r8/)
      kao(:, 3, 3,11) = (/ &
     &9.1573e-02_r8,2.6509e-01_r8,4.0096e-01_r8,5.1730e-01_r8,6.8812e-01_r8,8.5747e-01_r8, &
     &1.0237e+00_r8,1.1823e+00_r8,1.3753e+00_r8/)
      kao(:, 4, 3,11) = (/ &
     &1.1115e-01_r8,3.1410e-01_r8,4.7626e-01_r8,6.2447e-01_r8,8.3118e-01_r8,1.0365e+00_r8, &
     &1.2383e+00_r8,1.4280e+00_r8,1.6615e+00_r8/)
      kao(:, 5, 3,11) = (/ &
     &1.3245e-01_r8,3.6725e-01_r8,5.5683e-01_r8,7.4336e-01_r8,9.8988e-01_r8,1.2355e+00_r8, &
     &1.4780e+00_r8,1.7132e+00_r8,1.9788e+00_r8/)
      kao(:, 1, 4,11) = (/ &
     &1.1641e-01_r8,1.9770e-01_r8,2.9439e-01_r8,3.7525e-01_r8,4.3722e-01_r8,5.0094e-01_r8, &
     &6.0009e-01_r8,6.9731e-01_r8,8.0196e-01_r8/)
      kao(:, 2, 4,11) = (/ &
     &1.4966e-01_r8,2.5765e-01_r8,3.7252e-01_r8,4.6834e-01_r8,5.4216e-01_r8,6.3606e-01_r8, &
     &7.6075e-01_r8,8.7975e-01_r8,1.0184e+00_r8/)
      kao(:, 3, 4,11) = (/ &
     &1.8710e-01_r8,3.2245e-01_r8,4.5679e-01_r8,5.7205e-01_r8,6.6194e-01_r8,7.9151e-01_r8, &
     &9.4643e-01_r8,1.0919e+00_r8,1.2671e+00_r8/)
      kao(:, 4, 4,11) = (/ &
     &2.2853e-01_r8,3.9201e-01_r8,5.5041e-01_r8,6.8810e-01_r8,7.8876e-01_r8,9.5787e-01_r8, &
     &1.1458e+00_r8,1.3241e+00_r8,1.5335e+00_r8/)
      kao(:, 5, 4,11) = (/ &
     &2.7304e-01_r8,4.6530e-01_r8,6.5411e-01_r8,8.1513e-01_r8,9.2682e-01_r8,1.1406e+00_r8, &
     &1.3653e+00_r8,1.5825e+00_r8,1.8252e+00_r8/)
      kao(:, 1, 5,11) = (/ &
     &2.2361e-01_r8,2.4318e-01_r8,3.1539e-01_r8,3.9443e-01_r8,4.5716e-01_r8,5.0109e-01_r8, &
     &5.2154e-01_r8,6.0679e-01_r8,6.9571e-01_r8/)
      kao(:, 2, 5,11) = (/ &
     &2.8781e-01_r8,3.2451e-01_r8,4.1536e-01_r8,5.0630e-01_r8,5.8344e-01_r8,6.3855e-01_r8, &
     &6.7297e-01_r8,7.8266e-01_r8,8.9726e-01_r8/)
      kao(:, 3, 5,11) = (/ &
     &3.6159e-01_r8,4.1915e-01_r8,5.2707e-01_r8,6.2976e-01_r8,7.2674e-01_r8,7.9740e-01_r8, &
     &8.4985e-01_r8,9.8938e-01_r8,1.1325e+00_r8/)
      kao(:, 4, 5,11) = (/ &
     &4.4416e-01_r8,5.2452e-01_r8,6.5017e-01_r8,7.6880e-01_r8,8.8658e-01_r8,9.6270e-01_r8, &
     &1.0399e+00_r8,1.2125e+00_r8,1.3846e+00_r8/)
      kao(:, 5, 5,11) = (/ &
     &5.3394e-01_r8,6.3638e-01_r8,7.8407e-01_r8,9.2197e-01_r8,1.0572e+00_r8,1.1328e+00_r8, &
     &1.2555e+00_r8,1.4611e+00_r8,1.6711e+00_r8/)
      kao(:, 1, 6,11) = (/ &
     &3.9154e-01_r8,3.6960e-01_r8,3.6660e-01_r8,4.0826e-01_r8,4.6123e-01_r8,5.0084e-01_r8, &
     &5.2154e-01_r8,5.2728e-01_r8,6.0320e-01_r8/)
      kao(:, 2, 6,11) = (/ &
     &5.1275e-01_r8,4.8556e-01_r8,4.9732e-01_r8,5.4788e-01_r8,6.0699e-01_r8,6.5333e-01_r8, &
     &6.7418e-01_r8,6.8648e-01_r8,7.8580e-01_r8/)
      kao(:, 3, 6,11) = (/ &
     &6.5141e-01_r8,6.2128e-01_r8,6.5130e-01_r8,7.0712e-01_r8,7.7202e-01_r8,8.3303e-01_r8, &
     &8.5314e-01_r8,8.6953e-01_r8,9.9315e-01_r8/)
      kao(:, 4, 6,11) = (/ &
     &8.1112e-01_r8,7.6989e-01_r8,8.2193e-01_r8,8.8492e-01_r8,9.6073e-01_r8,1.0362e+00_r8, &
     &1.0443e+00_r8,1.0666e+00_r8,1.2159e+00_r8/)
      kao(:, 5, 6,11) = (/ &
     &9.8628e-01_r8,9.3596e-01_r8,1.0065e+00_r8,1.0840e+00_r8,1.1687e+00_r8,1.2489e+00_r8, &
     &1.2474e+00_r8,1.2983e+00_r8,1.4796e+00_r8/)
      kao(:, 1, 7,11) = (/ &
     &6.9811e-01_r8,6.2404e-01_r8,5.7431e-01_r8,5.2596e-01_r8,5.0219e-01_r8,5.1011e-01_r8, &
     &5.2289e-01_r8,4.9946e-01_r8,5.0228e-01_r8/)
      kao(:, 2, 7,11) = (/ &
     &9.3257e-01_r8,8.3430e-01_r8,7.6751e-01_r8,7.1360e-01_r8,6.8353e-01_r8,6.8813e-01_r8, &
     &6.9358e-01_r8,6.6018e-01_r8,6.7200e-01_r8/)
      kao(:, 3, 7,11) = (/ &
     &1.1984e+00_r8,1.0755e+00_r8,9.9660e-01_r8,9.4008e-01_r8,8.9760e-01_r8,8.9906e-01_r8, &
     &8.9631e-01_r8,8.4016e-01_r8,8.6247e-01_r8/)
      kao(:, 4, 7,11) = (/ &
     &1.5061e+00_r8,1.3555e+00_r8,1.2704e+00_r8,1.2009e+00_r8,1.1418e+00_r8,1.1469e+00_r8, &
     &1.1302e+00_r8,1.0283e+00_r8,1.0687e+00_r8/)
      kao(:, 5, 7,11) = (/ &
     &1.8551e+00_r8,1.6736e+00_r8,1.5791e+00_r8,1.4850e+00_r8,1.4175e+00_r8,1.4225e+00_r8, &
     &1.3804e+00_r8,1.2333e+00_r8,1.3098e+00_r8/)
      kao(:, 1, 8,11) = (/ &
     &1.4751e+00_r8,1.2907e+00_r8,1.1413e+00_r8,9.9788e-01_r8,8.3765e-01_r8,7.0312e-01_r8, &
     &5.8437e-01_r8,5.1212e-01_r8,4.0848e-01_r8/)
      kao(:, 2, 8,11) = (/ &
     &2.0110e+00_r8,1.7597e+00_r8,1.5595e+00_r8,1.3603e+00_r8,1.1539e+00_r8,9.7291e-01_r8, &
     &7.9698e-01_r8,7.0110e-01_r8,5.5259e-01_r8/)
      kao(:, 3, 8,11) = (/ &
     &2.6286e+00_r8,2.3001e+00_r8,2.0385e+00_r8,1.7785e+00_r8,1.5362e+00_r8,1.2889e+00_r8, &
     &1.0590e+00_r8,9.2250e-01_r8,7.2275e-01_r8/)
      kao(:, 4, 8,11) = (/ &
     &3.3350e+00_r8,2.9182e+00_r8,2.5850e+00_r8,2.2617e+00_r8,1.9780e+00_r8,1.6580e+00_r8, &
     &1.3758e+00_r8,1.1729e+00_r8,9.1532e-01_r8/)
      kao(:, 5, 8,11) = (/ &
     &4.1346e+00_r8,3.6181e+00_r8,3.2106e+00_r8,2.8264e+00_r8,2.4835e+00_r8,2.0714e+00_r8, &
     &1.7385e+00_r8,1.4468e+00_r8,1.1430e+00_r8/)
      kao(:, 1, 9,11) = (/ &
     &5.7681e+00_r8,5.0468e+00_r8,4.3260e+00_r8,3.6050e+00_r8,2.9109e+00_r8,2.2673e+00_r8, &
     &1.5776e+00_r8,9.1302e-01_r8,3.3856e-01_r8/)
      kao(:, 2, 9,11) = (/ &
     &8.0519e+00_r8,7.0463e+00_r8,6.0395e+00_r8,5.0331e+00_r8,4.0586e+00_r8,3.1762e+00_r8, &
     &2.2073e+00_r8,1.2968e+00_r8,3.9705e-01_r8/)
      kao(:, 3, 9,11) = (/ &
     &1.0740e+01_r8,9.3971e+00_r8,8.0549e+00_r8,6.7129e+00_r8,5.4190e+00_r8,4.2355e+00_r8, &
     &2.9531e+00_r8,1.7521e+00_r8,4.0437e-01_r8/)
      kao(:, 4, 9,11) = (/ &
     &1.3840e+01_r8,1.2110e+01_r8,1.0380e+01_r8,8.6502e+00_r8,7.0077e+00_r8,5.4549e+00_r8, &
     &3.8354e+00_r8,2.2704e+00_r8,5.4385e-01_r8/)
      kao(:, 5, 9,11) = (/ &
     &1.7291e+01_r8,1.5129e+01_r8,1.2969e+01_r8,1.0808e+01_r8,8.7913e+00_r8,6.8118e+00_r8, &
     &4.8594e+00_r8,2.8643e+00_r8,9.3844e-01_r8/)
      kao(:, 1,10,11) = (/ &
     &2.5281e+01_r8,2.2121e+01_r8,1.8961e+01_r8,1.5801e+01_r8,1.2641e+01_r8,9.4806e+00_r8, &
     &6.3207e+00_r8,3.2921e+00_r8,2.8225e-01_r8/)
      kao(:, 2,10,11) = (/ &
     &3.6089e+01_r8,3.1577e+01_r8,2.7066e+01_r8,2.2555e+01_r8,1.8044e+01_r8,1.3532e+01_r8, &
     &9.0226e+00_r8,4.7197e+00_r8,3.9375e-01_r8/)
      kao(:, 3,10,11) = (/ &
     &4.8997e+01_r8,4.2873e+01_r8,3.6749e+01_r8,3.0623e+01_r8,2.4498e+01_r8,1.8373e+01_r8, &
     &1.2249e+01_r8,6.4130e+00_r8,6.0950e-01_r8/)
      kao(:, 4,10,11) = (/ &
     &6.4090e+01_r8,5.6079e+01_r8,4.8068e+01_r8,4.0059e+01_r8,3.2048e+01_r8,2.4036e+01_r8, &
     &1.6029e+01_r8,8.3902e+00_r8,8.3229e-01_r8/)
      kao(:, 5,10,11) = (/ &
     &8.0977e+01_r8,7.0856e+01_r8,6.0735e+01_r8,5.0611e+01_r8,4.0489e+01_r8,3.0368e+01_r8, &
     &2.0260e+01_r8,1.0591e+01_r8,9.6456e-01_r8/)
      kao(:, 1,11,11) = (/ &
     &4.5405e+01_r8,3.9730e+01_r8,3.4055e+01_r8,2.8379e+01_r8,2.2704e+01_r8,1.7027e+01_r8, &
     &1.1352e+01_r8,5.7629e+00_r8,2.2978e-01_r8/)
      kao(:, 2,11,11) = (/ &
     &6.4516e+01_r8,5.6450e+01_r8,4.8385e+01_r8,4.0321e+01_r8,3.2258e+01_r8,2.4193e+01_r8, &
     &1.6129e+01_r8,8.1743e+00_r8,3.8450e-01_r8/)
      kao(:, 3,11,11) = (/ &
     &8.7570e+01_r8,7.6629e+01_r8,6.5678e+01_r8,5.4738e+01_r8,4.3785e+01_r8,3.2840e+01_r8, &
     &2.1894e+01_r8,1.1105e+01_r8,5.0528e-01_r8/)
      kao(:, 4,11,11) = (/ &
     &1.1421e+02_r8,9.9924e+01_r8,8.5650e+01_r8,7.1372e+01_r8,5.7099e+01_r8,4.2826e+01_r8, &
     &2.8549e+01_r8,1.4506e+01_r8,6.3580e-01_r8/)
      kao(:, 5,11,11) = (/ &
     &1.4404e+02_r8,1.2604e+02_r8,1.0803e+02_r8,9.0033e+01_r8,7.2026e+01_r8,5.4020e+01_r8, &
     &3.6011e+01_r8,1.8334e+01_r8,7.9612e-01_r8/)
      kao(:, 1,12,11) = (/ &
     &5.9271e+01_r8,5.1859e+01_r8,4.4453e+01_r8,3.7044e+01_r8,2.9635e+01_r8,2.2226e+01_r8, &
     &1.4818e+01_r8,7.4861e+00_r8,2.2024e-01_r8/)
      kao(:, 2,12,11) = (/ &
     &8.4185e+01_r8,7.3665e+01_r8,6.3138e+01_r8,5.2615e+01_r8,4.2094e+01_r8,3.1570e+01_r8, &
     &2.1046e+01_r8,1.0615e+01_r8,3.8802e-01_r8/)
      kao(:, 3,12,11) = (/ &
     &1.1399e+02_r8,9.9749e+01_r8,8.5496e+01_r8,7.1245e+01_r8,5.6997e+01_r8,4.2749e+01_r8, &
     &2.8499e+01_r8,1.4383e+01_r8,4.9342e-01_r8/)
      kao(:, 4,12,11) = (/ &
     &1.4842e+02_r8,1.2987e+02_r8,1.1132e+02_r8,9.2770e+01_r8,7.4216e+01_r8,5.5662e+01_r8, &
     &3.7107e+01_r8,1.8761e+01_r8,6.8194e-01_r8/)
      kao(:, 5,12,11) = (/ &
     &1.8694e+02_r8,1.6356e+02_r8,1.4020e+02_r8,1.1683e+02_r8,9.3474e+01_r8,7.0107e+01_r8, &
     &4.6738e+01_r8,2.3682e+01_r8,7.5051e-01_r8/)
      kao(:, 1,13,11) = (/ &
     &6.1162e+01_r8,5.3516e+01_r8,4.5871e+01_r8,3.8225e+01_r8,3.0581e+01_r8,2.2936e+01_r8, &
     &1.5291e+01_r8,7.7722e+00_r8,3.0501e-01_r8/)
      kao(:, 2,13,11) = (/ &
     &8.6643e+01_r8,7.5815e+01_r8,6.4984e+01_r8,5.4153e+01_r8,4.3324e+01_r8,3.2493e+01_r8, &
     &2.1662e+01_r8,1.1016e+01_r8,3.8069e-01_r8/)
      kao(:, 3,13,11) = (/ &
     &1.1697e+02_r8,1.0235e+02_r8,8.7727e+01_r8,7.3107e+01_r8,5.8486e+01_r8,4.3863e+01_r8, &
     &2.9242e+01_r8,1.4879e+01_r8,4.9510e-01_r8/)
      kao(:, 4,13,11) = (/ &
     &1.5186e+02_r8,1.3288e+02_r8,1.1389e+02_r8,9.4916e+01_r8,7.5936e+01_r8,5.6949e+01_r8, &
     &3.7967e+01_r8,1.9342e+01_r8,5.7912e-01_r8/)
      kao(:, 5,13,11) = (/ &
     &1.9078e+02_r8,1.6694e+02_r8,1.4309e+02_r8,1.1924e+02_r8,9.5394e+01_r8,7.1546e+01_r8, &
     &4.7697e+01_r8,2.4327e+01_r8,6.7000e-01_r8/)
      kao(:, 1, 1,12) = (/ &
     &4.4327e-02_r8,1.9901e-01_r8,3.9567e-01_r8,5.8848e-01_r8,7.7476e-01_r8,9.4853e-01_r8, &
     &1.0934e+00_r8,1.1527e+00_r8,1.5495e+00_r8/)
      kao(:, 2, 1,12) = (/ &
     &5.3905e-02_r8,2.4740e-01_r8,4.9242e-01_r8,7.3367e-01_r8,9.6823e-01_r8,1.1892e+00_r8, &
     &1.3767e+00_r8,1.4534e+00_r8,1.9364e+00_r8/)
      kao(:, 3, 1,12) = (/ &
     &6.4069e-02_r8,2.9762e-01_r8,5.9267e-01_r8,8.8396e-01_r8,1.1680e+00_r8,1.4379e+00_r8, &
     &1.6734e+00_r8,1.7853e+00_r8,2.3359e+00_r8/)
      kao(:, 4, 1,12) = (/ &
     &7.4599e-02_r8,3.4908e-01_r8,6.9548e-01_r8,1.0378e+00_r8,1.3725e+00_r8,1.6921e+00_r8, &
     &1.9734e+00_r8,2.1192e+00_r8,2.7449e+00_r8/)
      kao(:, 5, 1,12) = (/ &
     &8.5274e-02_r8,4.0394e-01_r8,8.0404e-01_r8,1.1983e+00_r8,1.5830e+00_r8,1.9477e+00_r8, &
     &2.2662e+00_r8,2.4521e+00_r8,3.1659e+00_r8/)
      kao(:, 1, 2,12) = (/ &
     &6.1665e-02_r8,2.1077e-01_r8,3.8355e-01_r8,5.7339e-01_r8,7.6055e-01_r8,9.4236e-01_r8, &
     &1.1091e+00_r8,1.2168e+00_r8,1.5210e+00_r8/)
      kao(:, 2, 2,12) = (/ &
     &7.6234e-02_r8,2.5639e-01_r8,4.7826e-01_r8,7.1532e-01_r8,9.5007e-01_r8,1.1793e+00_r8, &
     &1.3941e+00_r8,1.5452e+00_r8,1.9001e+00_r8/)
      kao(:, 3, 2,12) = (/ &
     &9.1892e-02_r8,3.0376e-01_r8,5.7761e-01_r8,8.6445e-01_r8,1.1488e+00_r8,1.4281e+00_r8, &
     &1.6923e+00_r8,1.8917e+00_r8,2.2975e+00_r8/)
      kao(:, 4, 2,12) = (/ &
     &1.0837e-01_r8,3.5273e-01_r8,6.8106e-01_r8,1.0192e+00_r8,1.3548e+00_r8,1.6858e+00_r8, &
     &2.0012e+00_r8,2.2488e+00_r8,2.7094e+00_r8/)
      kao(:, 5, 2,12) = (/ &
     &1.2523e-01_r8,4.0526e-01_r8,7.9735e-01_r8,1.1921e+00_r8,1.5816e+00_r8,1.9625e+00_r8, &
     &2.3213e+00_r8,2.6087e+00_r8,3.1625e+00_r8/)
      kao(:, 1, 3,12) = (/ &
     &1.1120e-01_r8,2.4868e-01_r8,3.6808e-01_r8,5.1840e-01_r8,6.9017e-01_r8,8.6056e-01_r8, &
     &1.0271e+00_r8,1.1758e+00_r8,1.3802e+00_r8/)
      kao(:, 2, 3,12) = (/ &
     &1.4053e-01_r8,3.1536e-01_r8,4.5583e-01_r8,6.5442e-01_r8,8.7173e-01_r8,1.0879e+00_r8, &
     &1.3003e+00_r8,1.4947e+00_r8,1.7433e+00_r8/)
      kao(:, 3, 3,12) = (/ &
     &1.7249e-01_r8,3.8643e-01_r8,5.4830e-01_r8,7.9885e-01_r8,1.0645e+00_r8,1.3292e+00_r8, &
     &1.5905e+00_r8,1.8338e+00_r8,2.1288e+00_r8/)
      kao(:, 4, 3,12) = (/ &
     &2.0676e-01_r8,4.5780e-01_r8,6.4549e-01_r8,9.5437e-01_r8,1.2710e+00_r8,1.5864e+00_r8, &
     &1.8970e+00_r8,2.1896e+00_r8,2.5411e+00_r8/)
      kao(:, 5, 3,12) = (/ &
     &2.4212e-01_r8,5.2871e-01_r8,7.5484e-01_r8,1.1269e+00_r8,1.5000e+00_r8,1.8700e+00_r8, &
     &2.2336e+00_r8,2.5647e+00_r8,2.9987e+00_r8/)
      kao(:, 1, 4,12) = (/ &
     &2.0092e-01_r8,3.0566e-01_r8,4.3321e-01_r8,5.2770e-01_r8,6.0160e-01_r8,7.5023e-01_r8, &
     &8.9870e-01_r8,1.0432e+00_r8,1.2013e+00_r8/)
      kao(:, 2, 4,12) = (/ &
     &2.6071e-01_r8,3.8703e-01_r8,5.5757e-01_r8,6.5930e-01_r8,7.6619e-01_r8,9.5732e-01_r8, &
     &1.1477e+00_r8,1.3364e+00_r8,1.5321e+00_r8/)
      kao(:, 3, 4,12) = (/ &
     &3.2640e-01_r8,4.7994e-01_r8,6.8737e-01_r8,7.9575e-01_r8,9.4617e-01_r8,1.1821e+00_r8, &
     &1.4178e+00_r8,1.6541e+00_r8,1.8914e+00_r8/)
      kao(:, 4, 4,12) = (/ &
     &3.9855e-01_r8,5.8348e-01_r8,8.2078e-01_r8,9.3830e-01_r8,1.1490e+00_r8,1.4352e+00_r8, &
     &1.7207e+00_r8,2.0041e+00_r8,2.2963e+00_r8/)
      kao(:, 5, 4,12) = (/ &
     &4.7570e-01_r8,6.9415e-01_r8,9.5472e-01_r8,1.0922e+00_r8,1.3776e+00_r8,1.7196e+00_r8, &
     &2.0594e+00_r8,2.3902e+00_r8,2.7528e+00_r8/)
      kao(:, 1, 5,12) = (/ &
     &3.3247e-01_r8,3.9594e-01_r8,4.9056e-01_r8,5.8813e-01_r8,6.5607e-01_r8,6.8035e-01_r8, &
     &7.9032e-01_r8,9.1840e-01_r8,1.0557e+00_r8/)
      kao(:, 2, 5,12) = (/ &
     &4.4282e-01_r8,5.1203e-01_r8,6.4486e-01_r8,7.7152e-01_r8,8.4090e-01_r8,8.6628e-01_r8, &
     &1.0179e+00_r8,1.1841e+00_r8,1.3589e+00_r8/)
      kao(:, 3, 5,12) = (/ &
     &5.6912e-01_r8,6.3900e-01_r8,8.2247e-01_r8,9.6727e-01_r8,1.0369e+00_r8,1.0698e+00_r8, &
     &1.2706e+00_r8,1.4785e+00_r8,1.6959e+00_r8/)
      kao(:, 4, 5,12) = (/ &
     &7.0931e-01_r8,7.8069e-01_r8,1.0153e+00_r8,1.1726e+00_r8,1.2423e+00_r8,1.3043e+00_r8, &
     &1.5604e+00_r8,1.8146e+00_r8,2.0829e+00_r8/)
      kao(:, 5, 5,12) = (/ &
     &8.5949e-01_r8,9.3825e-01_r8,1.2105e+00_r8,1.3829e+00_r8,1.4592e+00_r8,1.5748e+00_r8, &
     &1.8870e+00_r8,2.1938e+00_r8,2.5189e+00_r8/)
      kao(:, 1, 6,12) = (/ &
     &5.2509e-01_r8,5.1721e-01_r8,5.7378e-01_r8,6.3384e-01_r8,6.9692e-01_r8,7.3419e-01_r8, &
     &7.1864e-01_r8,7.9317e-01_r8,9.0866e-01_r8/)
      kao(:, 2, 6,12) = (/ &
     &7.0957e-01_r8,6.9625e-01_r8,7.6638e-01_r8,8.5821e-01_r8,9.3314e-01_r8,9.6244e-01_r8, &
     &9.2911e-01_r8,1.0410e+00_r8,1.1915e+00_r8/)
      kao(:, 3, 6,12) = (/ &
     &9.2892e-01_r8,9.0647e-01_r8,9.9421e-01_r8,1.1180e+00_r8,1.1912e+00_r8,1.2074e+00_r8, &
     &1.1606e+00_r8,1.3214e+00_r8,1.5144e+00_r8/)
      kao(:, 4, 6,12) = (/ &
     &1.1749e+00_r8,1.1432e+00_r8,1.2560e+00_r8,1.3977e+00_r8,1.4686e+00_r8,1.4691e+00_r8, &
     &1.4281e+00_r8,1.6462e+00_r8,1.8876e+00_r8/)
      kao(:, 5, 6,12) = (/ &
     &1.4442e+00_r8,1.4016e+00_r8,1.5480e+00_r8,1.6922e+00_r8,1.7621e+00_r8,1.7564e+00_r8, &
     &1.7321e+00_r8,2.0105e+00_r8,2.3048e+00_r8/)
      kao(:, 1, 7,12) = (/ &
     &9.1849e-01_r8,8.0624e-01_r8,7.9050e-01_r8,7.5675e-01_r8,7.6178e-01_r8,7.8133e-01_r8, &
     &7.7608e-01_r8,6.9116e-01_r8,7.7991e-01_r8/)
      kao(:, 2, 7,12) = (/ &
     &1.2413e+00_r8,1.0918e+00_r8,1.0769e+00_r8,1.0420e+00_r8,1.0608e+00_r8,1.0726e+00_r8, &
     &1.0404e+00_r8,9.1318e-01_r8,1.0358e+00_r8/)
      kao(:, 3, 7,12) = (/ &
     &1.6444e+00_r8,1.4500e+00_r8,1.4209e+00_r8,1.3929e+00_r8,1.4200e+00_r8,1.3992e+00_r8, &
     &1.3321e+00_r8,1.1740e+00_r8,1.3388e+00_r8/)
      kao(:, 4, 7,12) = (/ &
     &2.1122e+00_r8,1.8669e+00_r8,1.8040e+00_r8,1.8049e+00_r8,1.8188e+00_r8,1.7570e+00_r8, &
     &1.6501e+00_r8,1.4861e+00_r8,1.6989e+00_r8/)
      kao(:, 5, 7,12) = (/ &
     &2.6250e+00_r8,2.3265e+00_r8,2.2289e+00_r8,2.2673e+00_r8,2.2456e+00_r8,2.1426e+00_r8, &
     &2.0040e+00_r8,1.8373e+00_r8,2.0997e+00_r8/)
      kao(:, 1, 8,12) = (/ &
     &1.9827e+00_r8,1.7349e+00_r8,1.4981e+00_r8,1.3371e+00_r8,1.1453e+00_r8,9.6602e-01_r8, &
     &8.7309e-01_r8,7.7254e-01_r8,6.6571e-01_r8/)
      kao(:, 2, 8,12) = (/ &
     &2.7151e+00_r8,2.3758e+00_r8,2.0507e+00_r8,1.8313e+00_r8,1.5691e+00_r8,1.3551e+00_r8, &
     &1.2325e+00_r8,1.0537e+00_r8,8.9966e-01_r8/)
      kao(:, 3, 8,12) = (/ &
     &3.5997e+00_r8,3.1499e+00_r8,2.7291e+00_r8,2.4373e+00_r8,2.1034e+00_r8,1.8593e+00_r8, &
     &1.6579e+00_r8,1.3773e+00_r8,1.1789e+00_r8/)
      kao(:, 4, 8,12) = (/ &
     &4.6665e+00_r8,4.0832e+00_r8,3.5519e+00_r8,3.1544e+00_r8,2.7468e+00_r8,2.4617e+00_r8, &
     &2.1388e+00_r8,1.7464e+00_r8,1.5079e+00_r8/)
      kao(:, 5, 8,12) = (/ &
     &5.8669e+00_r8,5.1335e+00_r8,4.4792e+00_r8,3.9559e+00_r8,3.4817e+00_r8,3.1241e+00_r8, &
     &2.6649e+00_r8,2.1629e+00_r8,1.8732e+00_r8/)
      kao(:, 1, 9,12) = (/ &
     &8.0387e+00_r8,7.0340e+00_r8,6.0293e+00_r8,5.0245e+00_r8,4.0196e+00_r8,3.0957e+00_r8, &
     &2.1773e+00_r8,1.2357e+00_r8,4.2050e-01_r8/)
      kao(:, 2, 9,12) = (/ &
     &1.1280e+01_r8,9.8705e+00_r8,8.4601e+00_r8,7.0501e+00_r8,5.6402e+00_r8,4.3334e+00_r8, &
     &3.0492e+00_r8,1.7467e+00_r8,4.6837e-01_r8/)
      kao(:, 3, 9,12) = (/ &
     &1.5202e+01_r8,1.3302e+01_r8,1.1401e+01_r8,9.5008e+00_r8,7.6009e+00_r8,5.8446e+00_r8, &
     &4.1033e+00_r8,2.4072e+00_r8,9.0067e-01_r8/)
      kao(:, 4, 9,12) = (/ &
     &1.9804e+01_r8,1.7328e+01_r8,1.4853e+01_r8,1.2377e+01_r8,9.9040e+00_r8,7.6319e+00_r8, &
     &5.3589e+00_r8,3.2206e+00_r8,1.3277e+00_r8/)
      kao(:, 5, 9,12) = (/ &
     &2.5091e+01_r8,2.1955e+01_r8,1.8819e+01_r8,1.5683e+01_r8,1.2554e+01_r8,9.6970e+00_r8, &
     &6.8190e+00_r8,4.1412e+00_r8,1.6570e+00_r8/)
      kao(:, 1,10,12) = (/ &
     &3.6853e+01_r8,3.2247e+01_r8,2.7641e+01_r8,2.3035e+01_r8,1.8427e+01_r8,1.3820e+01_r8, &
     &9.2142e+00_r8,4.7017e+00_r8,5.2096e-01_r8/)
      kao(:, 2,10,12) = (/ &
     &5.2866e+01_r8,4.6255e+01_r8,3.9648e+01_r8,3.3040e+01_r8,2.6431e+01_r8,1.9825e+01_r8, &
     &1.3217e+01_r8,6.7223e+00_r8,8.5705e-01_r8/)
      kao(:, 3,10,12) = (/ &
     &7.2440e+01_r8,6.3382e+01_r8,5.4326e+01_r8,4.5272e+01_r8,3.6218e+01_r8,2.7164e+01_r8, &
     &1.8108e+01_r8,9.2103e+00_r8,9.7984e-01_r8/)
      kao(:, 4,10,12) = (/ &
     &9.5327e+01_r8,8.3414e+01_r8,7.1501e+01_r8,5.9582e+01_r8,4.7667e+01_r8,3.5750e+01_r8, &
     &2.3834e+01_r8,1.2146e+01_r8,1.1774e+00_r8/)
      kao(:, 5,10,12) = (/ &
     &1.2143e+02_r8,1.0625e+02_r8,9.1069e+01_r8,7.5889e+01_r8,6.0713e+01_r8,4.5537e+01_r8, &
     &3.0358e+01_r8,1.5516e+01_r8,1.3416e+00_r8/)
      kao(:, 1,11,12) = (/ &
     &6.9348e+01_r8,6.0680e+01_r8,5.2012e+01_r8,4.3342e+01_r8,3.4673e+01_r8,2.6006e+01_r8, &
     &1.7338e+01_r8,8.6702e+00_r8,3.0466e-01_r8/)
      kao(:, 2,11,12) = (/ &
     &9.9352e+01_r8,8.6930e+01_r8,7.4511e+01_r8,6.2093e+01_r8,4.9676e+01_r8,3.7257e+01_r8, &
     &2.4839e+01_r8,1.2419e+01_r8,6.8510e-01_r8/)
      kao(:, 3,11,12) = (/ &
     &1.3563e+02_r8,1.1868e+02_r8,1.0173e+02_r8,8.4769e+01_r8,6.7818e+01_r8,5.0866e+01_r8, &
     &3.3908e+01_r8,1.6957e+01_r8,1.0467e+00_r8/)
      kao(:, 4,11,12) = (/ &
     &1.7753e+02_r8,1.5535e+02_r8,1.3315e+02_r8,1.1096e+02_r8,8.8765e+01_r8,6.6576e+01_r8, &
     &4.4384e+01_r8,2.2206e+01_r8,1.3289e+00_r8/)
      kao(:, 5,11,12) = (/ &
     &2.2508e+02_r8,1.9694e+02_r8,1.6881e+02_r8,1.4068e+02_r8,1.1255e+02_r8,8.4405e+01_r8, &
     &5.6267e+01_r8,2.8168e+01_r8,1.6371e+00_r8/)
      kao(:, 1,12,12) = (/ &
     &9.5815e+01_r8,8.3836e+01_r8,7.1860e+01_r8,5.9885e+01_r8,4.7907e+01_r8,3.5931e+01_r8, &
     &2.3953e+01_r8,1.1977e+01_r8,2.4035e-01_r8/)
      kao(:, 2,12,12) = (/ &
     &1.3694e+02_r8,1.1982e+02_r8,1.0270e+02_r8,8.5588e+01_r8,6.8468e+01_r8,5.1352e+01_r8, &
     &3.4234e+01_r8,1.7118e+01_r8,5.7126e-01_r8/)
      kao(:, 3,12,12) = (/ &
     &1.8607e+02_r8,1.6282e+02_r8,1.3956e+02_r8,1.1630e+02_r8,9.3038e+01_r8,6.9781e+01_r8, &
     &4.6518e+01_r8,2.3259e+01_r8,8.8813e-01_r8/)
      kao(:, 4,12,12) = (/ &
     &2.4268e+02_r8,2.1235e+02_r8,1.8201e+02_r8,1.5168e+02_r8,1.2134e+02_r8,9.1010e+01_r8, &
     &6.0670e+01_r8,3.0335e+01_r8,1.1237e+00_r8/)
      kao(:, 5,12,12) = (/ &
     &3.0642e+02_r8,2.6813e+02_r8,2.2982e+02_r8,1.9152e+02_r8,1.5322e+02_r8,1.1491e+02_r8, &
     &7.6606e+01_r8,3.8310e+01_r8,1.5308e+00_r8/)
      kao(:, 1,13,12) = (/ &
     &1.0396e+02_r8,9.0973e+01_r8,7.7973e+01_r8,6.4982e+01_r8,5.1984e+01_r8,3.8991e+01_r8, &
     &2.5992e+01_r8,1.3003e+01_r8,2.8896e-01_r8/)
      kao(:, 2,13,12) = (/ &
     &1.4817e+02_r8,1.2965e+02_r8,1.1113e+02_r8,9.2604e+01_r8,7.4089e+01_r8,5.5562e+01_r8, &
     &3.7043e+01_r8,1.8523e+01_r8,6.4071e-01_r8/)
      kao(:, 3,13,12) = (/ &
     &2.0056e+02_r8,1.7549e+02_r8,1.5042e+02_r8,1.2535e+02_r8,1.0028e+02_r8,7.5210e+01_r8, &
     &5.0138e+01_r8,2.5080e+01_r8,7.6073e-01_r8/)
      kao(:, 4,13,12) = (/ &
     &2.6107e+02_r8,2.2842e+02_r8,1.9581e+02_r8,1.6317e+02_r8,1.3054e+02_r8,9.7901e+01_r8, &
     &6.5267e+01_r8,3.2665e+01_r8,1.0550e+00_r8/)
      kao(:, 5,13,12) = (/ &
     &3.2818e+02_r8,2.8717e+02_r8,2.4613e+02_r8,2.0512e+02_r8,1.6409e+02_r8,1.2307e+02_r8, &
     &8.2040e+01_r8,4.1093e+01_r8,1.4069e+00_r8/)
      kao(:, 1, 1,13) = (/ &
     &8.9189e-02_r8,2.7547e-01_r8,5.4755e-01_r8,8.1466e-01_r8,1.0734e+00_r8,1.3167e+00_r8, &
     &1.5262e+00_r8,1.6545e+00_r8,2.1467e+00_r8/)
      kao(:, 2, 1,13) = (/ &
     &1.0564e-01_r8,3.3448e-01_r8,6.6333e-01_r8,9.8354e-01_r8,1.2897e+00_r8,1.5719e+00_r8, &
     &1.8097e+00_r8,1.9474e+00_r8,2.5794e+00_r8/)
      kao(:, 3, 1,13) = (/ &
     &1.2232e-01_r8,4.0251e-01_r8,7.9745e-01_r8,1.1809e+00_r8,1.5463e+00_r8,1.8798e+00_r8, &
     &2.1512e+00_r8,2.2853e+00_r8,3.0925e+00_r8/)
      kao(:, 4, 1,13) = (/ &
     &1.3906e-01_r8,4.8151e-01_r8,9.5370e-01_r8,1.4117e+00_r8,1.8477e+00_r8,2.2440e+00_r8, &
     &2.5627e+00_r8,2.7054e+00_r8,3.6953e+00_r8/)
      kao(:, 5, 1,13) = (/ &
     &1.5537e-01_r8,5.6891e-01_r8,1.1282e+00_r8,1.6723e+00_r8,2.1918e+00_r8,2.6654e+00_r8, &
     &3.0480e+00_r8,3.1989e+00_r8,4.3834e+00_r8/)
      kao(:, 1, 2,13) = (/ &
     &1.2651e-01_r8,2.7511e-01_r8,5.4811e-01_r8,8.1792e-01_r8,1.0822e+00_r8,1.3369e+00_r8, &
     &1.5702e+00_r8,1.7388e+00_r8,2.1643e+00_r8/)
      kao(:, 2, 2,13) = (/ &
     &1.5153e-01_r8,3.4384e-01_r8,6.8417e-01_r8,1.0197e+00_r8,1.3466e+00_r8,1.6574e+00_r8, &
     &1.9318e+00_r8,2.0933e+00_r8,2.6930e+00_r8/)
      kao(:, 3, 2,13) = (/ &
     &1.7716e-01_r8,4.2323e-01_r8,8.4160e-01_r8,1.2530e+00_r8,1.6525e+00_r8,2.0285e+00_r8, &
     &2.3523e+00_r8,2.5052e+00_r8,3.3049e+00_r8/)
      kao(:, 4, 2,13) = (/ &
     &2.0304e-01_r8,5.0914e-01_r8,1.0128e+00_r8,1.5083e+00_r8,1.9894e+00_r8,2.4425e+00_r8, &
     &2.8273e+00_r8,2.9947e+00_r8,3.9785e+00_r8/)
      kao(:, 5, 2,13) = (/ &
     &2.2856e-01_r8,5.9708e-01_r8,1.1882e+00_r8,1.7705e+00_r8,2.3375e+00_r8,2.8753e+00_r8, &
     &3.3417e+00_r8,3.5598e+00_r8,4.6746e+00_r8/)
      kao(:, 1, 3,13) = (/ &
     &2.3155e-01_r8,3.6106e-01_r8,5.1524e-01_r8,7.7074e-01_r8,1.0237e+00_r8,1.2717e+00_r8, &
     &1.5079e+00_r8,1.7067e+00_r8,2.0474e+00_r8/)
      kao(:, 2, 3,13) = (/ &
     &2.8222e-01_r8,4.3122e-01_r8,6.6114e-01_r8,9.8854e-01_r8,1.3120e+00_r8,1.6278e+00_r8, &
     &1.9248e+00_r8,2.1616e+00_r8,2.6238e+00_r8/)
      kao(:, 3, 3,13) = (/ &
     &3.3490e-01_r8,5.0925e-01_r8,8.3049e-01_r8,1.2417e+00_r8,1.6476e+00_r8,2.0430e+00_r8, &
     &2.4133e+00_r8,2.6954e+00_r8,3.2949e+00_r8/)
      kao(:, 4, 3,13) = (/ &
     &3.8898e-01_r8,5.9951e-01_r8,1.0132e+00_r8,1.5151e+00_r8,2.0114e+00_r8,2.4964e+00_r8, &
     &2.9531e+00_r8,3.3043e+00_r8,4.0224e+00_r8/)
      kao(:, 5, 3,13) = (/ &
     &4.4295e-01_r8,6.9228e-01_r8,1.1941e+00_r8,1.7863e+00_r8,2.3719e+00_r8,2.9449e+00_r8, &
     &3.4879e+00_r8,3.9170e+00_r8,4.7434e+00_r8/)
      kao(:, 1, 4,13) = (/ &
     &4.2438e-01_r8,5.0777e-01_r8,6.1519e-01_r8,7.0596e-01_r8,9.3438e-01_r8,1.1645e+00_r8, &
     &1.3892e+00_r8,1.5946e+00_r8,1.8686e+00_r8/)
      kao(:, 2, 4,13) = (/ &
     &5.2911e-01_r8,6.2653e-01_r8,7.5903e-01_r8,9.2591e-01_r8,1.2320e+00_r8,1.5352e+00_r8, &
     &1.8307e+00_r8,2.0955e+00_r8,2.4637e+00_r8/)
      kao(:, 3, 4,13) = (/ &
     &6.3945e-01_r8,7.5086e-01_r8,9.2902e-01_r8,1.1816e+00_r8,1.5728e+00_r8,1.9600e+00_r8, &
     &2.3380e+00_r8,2.6793e+00_r8,3.1453e+00_r8/)
      kao(:, 4, 4,13) = (/ &
     &7.5432e-01_r8,8.7946e-01_r8,1.1073e+00_r8,1.4569e+00_r8,1.9394e+00_r8,2.4183e+00_r8, &
     &2.8875e+00_r8,3.3173e+00_r8,3.8782e+00_r8/)
      kao(:, 5, 4,13) = (/ &
     &8.7134e-01_r8,1.0123e+00_r8,1.2829e+00_r8,1.7403e+00_r8,2.3172e+00_r8,2.8902e+00_r8, &
     &3.4528e+00_r8,3.9744e+00_r8,4.6335e+00_r8/)
      kao(:, 1, 5,13) = (/ &
     &7.1207e-01_r8,6.8711e-01_r8,8.3241e-01_r8,8.6529e-01_r8,8.8550e-01_r8,1.0406e+00_r8, &
     &1.2451e+00_r8,1.4407e+00_r8,1.6670e+00_r8/)
      kao(:, 2, 5,13) = (/ &
     &9.0944e-01_r8,8.8418e-01_r8,1.0384e+00_r8,1.0957e+00_r8,1.1610e+00_r8,1.4029e+00_r8, &
     &1.6788e+00_r8,1.9429e+00_r8,2.2472e+00_r8/)
      kao(:, 3, 5,13) = (/ &
     &1.1217e+00_r8,1.1051e+00_r8,1.2550e+00_r8,1.3677e+00_r8,1.4770e+00_r8,1.8154e+00_r8, &
     &2.1738e+00_r8,2.5182e+00_r8,2.9077e+00_r8/)
      kao(:, 4, 5,13) = (/ &
     &1.3460e+00_r8,1.3429e+00_r8,1.4887e+00_r8,1.6567e+00_r8,1.8206e+00_r8,2.2609e+00_r8, &
     &2.7082e+00_r8,3.1425e+00_r8,3.6199e+00_r8/)
      kao(:, 5, 5,13) = (/ &
     &1.5795e+00_r8,1.5881e+00_r8,1.7517e+00_r8,1.9324e+00_r8,2.1859e+00_r8,2.7284e+00_r8, &
     &3.2694e+00_r8,3.7971e+00_r8,4.3676e+00_r8/)
      kao(:, 1, 6,13) = (/ &
     &1.1023e+00_r8,9.7526e-01_r8,1.0617e+00_r8,1.1008e+00_r8,1.0651e+00_r8,1.0178e+00_r8, &
     &1.0836e+00_r8,1.2590e+00_r8,1.4474e+00_r8/)
      kao(:, 2, 6,13) = (/ &
     &1.4464e+00_r8,1.2819e+00_r8,1.3748e+00_r8,1.4078e+00_r8,1.3857e+00_r8,1.3476e+00_r8, &
     &1.4882e+00_r8,1.7304e+00_r8,1.9875e+00_r8/)
      kao(:, 3, 6,13) = (/ &
     &1.8308e+00_r8,1.6242e+00_r8,1.7155e+00_r8,1.7456e+00_r8,1.7675e+00_r8,1.7237e+00_r8, &
     &1.9554e+00_r8,2.2760e+00_r8,2.6094e+00_r8/)
      kao(:, 4, 6,13) = (/ &
     &2.2453e+00_r8,1.9975e+00_r8,2.0781e+00_r8,2.1295e+00_r8,2.1828e+00_r8,2.1327e+00_r8, &
     &2.4652e+00_r8,2.8713e+00_r8,3.2893e+00_r8/)
      kao(:, 5, 6,13) = (/ &
     &2.6836e+00_r8,2.3986e+00_r8,2.4577e+00_r8,2.5567e+00_r8,2.5877e+00_r8,2.5663e+00_r8, &
     &3.0104e+00_r8,3.5064e+00_r8,4.0161e+00_r8/)
      kao(:, 1, 7,13) = (/ &
     &1.7788e+00_r8,1.5565e+00_r8,1.4296e+00_r8,1.4541e+00_r8,1.3809e+00_r8,1.2482e+00_r8, &
     &1.1009e+00_r8,1.0852e+00_r8,1.2442e+00_r8/)
      kao(:, 2, 7,13) = (/ &
     &2.4100e+00_r8,2.1089e+00_r8,1.9246e+00_r8,1.9363e+00_r8,1.8185e+00_r8,1.6636e+00_r8, &
     &1.4819e+00_r8,1.5124e+00_r8,1.7324e+00_r8/)
      kao(:, 3, 7,13) = (/ &
     &3.1319e+00_r8,2.7405e+00_r8,2.5003e+00_r8,2.4636e+00_r8,2.3111e+00_r8,2.1652e+00_r8, &
     &1.9114e+00_r8,2.0080e+00_r8,2.2982e+00_r8/)
      kao(:, 4, 7,13) = (/ &
     &3.9360e+00_r8,3.4440e+00_r8,3.1598e+00_r8,3.0372e+00_r8,2.8747e+00_r8,2.7334e+00_r8, &
     &2.3814e+00_r8,2.5579e+00_r8,2.9254e+00_r8/)
      kao(:, 5, 7,13) = (/ &
     &4.8010e+00_r8,4.2009e+00_r8,3.8764e+00_r8,3.6526e+00_r8,3.5065e+00_r8,3.3078e+00_r8, &
     &2.8824e+00_r8,3.1625e+00_r8,3.6156e+00_r8/)
      kao(:, 1, 8,13) = (/ &
     &3.4656e+00_r8,3.0324e+00_r8,2.5993e+00_r8,2.2536e+00_r8,2.0768e+00_r8,1.8323e+00_r8, &
     &1.4794e+00_r8,1.1100e+00_r8,1.0719e+00_r8/)
      kao(:, 2, 8,13) = (/ &
     &4.7953e+00_r8,4.1960e+00_r8,3.5964e+00_r8,3.1195e+00_r8,2.8558e+00_r8,2.4960e+00_r8, &
     &2.0234e+00_r8,1.5264e+00_r8,1.5151e+00_r8/)
      kao(:, 3, 8,13) = (/ &
     &6.4119e+00_r8,5.6106e+00_r8,4.8091e+00_r8,4.1637e+00_r8,3.7658e+00_r8,3.2529e+00_r8, &
     &2.6777e+00_r8,1.9921e+00_r8,2.0306e+00_r8/)
      kao(:, 4, 8,13) = (/ &
     &8.2532e+00_r8,7.2211e+00_r8,6.1898e+00_r8,5.3688e+00_r8,4.7948e+00_r8,4.1025e+00_r8, &
     &3.4458e+00_r8,2.5062e+00_r8,2.6143e+00_r8/)
      kao(:, 5, 8,13) = (/ &
     &1.0283e+01_r8,8.9971e+00_r8,7.7118e+00_r8,6.7087e+00_r8,5.9163e+00_r8,5.0630e+00_r8, &
     &4.2877e+00_r8,3.0597e+00_r8,3.2702e+00_r8/)
      kao(:, 1, 9,13) = (/ &
     &1.3039e+01_r8,1.1409e+01_r8,9.7786e+00_r8,8.1486e+00_r8,6.5192e+00_r8,4.9000e+00_r8, &
     &3.5526e+00_r8,2.2083e+00_r8,6.1249e-01_r8/)
      kao(:, 2, 9,13) = (/ &
     &1.8190e+01_r8,1.5916e+01_r8,1.3643e+01_r8,1.1369e+01_r8,9.0953e+00_r8,6.8331e+00_r8, &
     &4.9544e+00_r8,3.0917e+00_r8,1.3174e+00_r8/)
      kao(:, 3, 9,13) = (/ &
     &2.4717e+01_r8,2.1628e+01_r8,1.8538e+01_r8,1.5449e+01_r8,1.2359e+01_r8,9.2996e+00_r8, &
     &6.7414e+00_r8,4.1578e+00_r8,1.7841e+00_r8/)
      kao(:, 4, 9,13) = (/ &
     &3.2573e+01_r8,2.8503e+01_r8,2.4432e+01_r8,2.0359e+01_r8,1.6288e+01_r8,1.2267e+01_r8, &
     &8.8606e+00_r8,5.4011e+00_r8,2.3241e+00_r8/)
      kao(:, 5, 9,13) = (/ &
     &4.1562e+01_r8,3.6368e+01_r8,3.1173e+01_r8,2.5977e+01_r8,2.0781e+01_r8,1.5678e+01_r8, &
     &1.1261e+01_r8,6.8301e+00_r8,2.9541e+00_r8/)
      kao(:, 1,10,13) = (/ &
     &5.7951e+01_r8,5.0708e+01_r8,4.3464e+01_r8,3.6220e+01_r8,2.8976e+01_r8,2.1732e+01_r8, &
     &1.4488e+01_r8,7.2520e+00_r8,5.6538e-01_r8/)
      kao(:, 2,10,13) = (/ &
     &8.1306e+01_r8,7.1141e+01_r8,6.0979e+01_r8,5.0813e+01_r8,4.0652e+01_r8,3.0489e+01_r8, &
     &2.0326e+01_r8,1.0163e+01_r8,6.5761e-01_r8/)
      kao(:, 3,10,13) = (/ &
     &1.1158e+02_r8,9.7625e+01_r8,8.3679e+01_r8,6.9730e+01_r8,5.5786e+01_r8,4.1839e+01_r8, &
     &2.7893e+01_r8,1.3953e+01_r8,1.0530e+00_r8/)
      kao(:, 4,10,13) = (/ &
     &1.4877e+02_r8,1.3018e+02_r8,1.1158e+02_r8,9.2984e+01_r8,7.4388e+01_r8,5.5791e+01_r8, &
     &3.7194e+01_r8,1.8619e+01_r8,1.0469e+00_r8/)
      kao(:, 5,10,13) = (/ &
     &1.9259e+02_r8,1.6851e+02_r8,1.4444e+02_r8,1.2037e+02_r8,9.6298e+01_r8,7.2222e+01_r8, &
     &4.8145e+01_r8,2.4115e+01_r8,9.0336e-01_r8/)
      kao(:, 1,11,13) = (/ &
     &1.0724e+02_r8,9.3834e+01_r8,8.0425e+01_r8,6.7028e+01_r8,5.3621e+01_r8,4.0215e+01_r8, &
     &2.6808e+01_r8,1.3405e+01_r8,7.5947e-01_r8/)
      kao(:, 2,11,13) = (/ &
     &1.5135e+02_r8,1.3244e+02_r8,1.1352e+02_r8,9.4596e+01_r8,7.5677e+01_r8,5.6758e+01_r8, &
     &3.7839e+01_r8,1.8919e+01_r8,7.7568e-01_r8/)
      kao(:, 3,11,13) = (/ &
     &2.0634e+02_r8,1.8056e+02_r8,1.5476e+02_r8,1.2896e+02_r8,1.0317e+02_r8,7.7384e+01_r8, &
     &5.1587e+01_r8,2.5792e+01_r8,1.1446e+00_r8/)
      kao(:, 4,11,13) = (/ &
     &2.7388e+02_r8,2.3963e+02_r8,2.0540e+02_r8,1.7116e+02_r8,1.3692e+02_r8,1.0270e+02_r8, &
     &6.8464e+01_r8,3.4233e+01_r8,1.4967e+00_r8/)
      kao(:, 5,11,13) = (/ &
     &3.5254e+02_r8,3.0844e+02_r8,2.6442e+02_r8,2.2035e+02_r8,1.7628e+02_r8,1.3220e+02_r8, &
     &8.8134e+01_r8,4.4067e+01_r8,1.3951e+00_r8/)
      kao(:, 1,12,13) = (/ &
     &1.4929e+02_r8,1.3063e+02_r8,1.1197e+02_r8,9.3306e+01_r8,7.4648e+01_r8,5.5984e+01_r8, &
     &3.7322e+01_r8,1.8661e+01_r8,7.7179e-01_r8/)
      kao(:, 2,12,13) = (/ &
     &2.1213e+02_r8,1.8562e+02_r8,1.5909e+02_r8,1.3258e+02_r8,1.0606e+02_r8,7.9546e+01_r8, &
     &5.3033e+01_r8,2.6517e+01_r8,8.3102e-01_r8/)
      kao(:, 3,12,13) = (/ &
     &2.8848e+02_r8,2.5242e+02_r8,2.1635e+02_r8,1.8030e+02_r8,1.4425e+02_r8,1.0818e+02_r8, &
     &7.2116e+01_r8,3.6059e+01_r8,1.2769e+00_r8/)
      kao(:, 4,12,13) = (/ &
     &3.7976e+02_r8,3.3226e+02_r8,2.8481e+02_r8,2.3733e+02_r8,1.8986e+02_r8,1.4240e+02_r8, &
     &9.4932e+01_r8,4.7464e+01_r8,1.6812e+00_r8/)
      kao(:, 5,12,13) = (/ &
     &4.8508e+02_r8,4.2444e+02_r8,3.6380e+02_r8,3.0318e+02_r8,2.4253e+02_r8,1.8190e+02_r8, &
     &1.2127e+02_r8,6.0633e+01_r8,1.6837e+00_r8/)
      kao(:, 1,13,13) = (/ &
     &1.6844e+02_r8,1.4739e+02_r8,1.2633e+02_r8,1.0528e+02_r8,8.4219e+01_r8,6.3167e+01_r8, &
     &4.2110e+01_r8,2.1055e+01_r8,6.4746e-01_r8/)
      kao(:, 2,13,13) = (/ &
     &2.3974e+02_r8,2.0978e+02_r8,1.7981e+02_r8,1.4983e+02_r8,1.1987e+02_r8,8.9901e+01_r8, &
     &5.9937e+01_r8,2.9967e+01_r8,7.7977e-01_r8/)
      kao(:, 3,13,13) = (/ &
     &3.2617e+02_r8,2.8540e+02_r8,2.4462e+02_r8,2.0386e+02_r8,1.6309e+02_r8,1.2231e+02_r8, &
     &8.1544e+01_r8,4.0770e+01_r8,1.5118e+00_r8/)
      kao(:, 4,13,13) = (/ &
     &4.2665e+02_r8,3.7332e+02_r8,3.1999e+02_r8,2.6667e+02_r8,2.1333e+02_r8,1.5999e+02_r8, &
     &1.0667e+02_r8,5.3332e+01_r8,1.6652e+00_r8/)
      kao(:, 5,13,13) = (/ &
     &5.4098e+02_r8,4.7336e+02_r8,4.0573e+02_r8,3.3811e+02_r8,2.7048e+02_r8,2.0286e+02_r8, &
     &1.3525e+02_r8,6.7619e+01_r8,1.7274e+00_r8/)
      kao(:, 1, 1,14) = (/ &
     &1.4473e-01_r8,4.5196e-01_r8,8.9698e-01_r8,1.3316e+00_r8,1.7483e+00_r8,2.1329e+00_r8, &
     &2.4492e+00_r8,2.5366e+00_r8,3.4967e+00_r8/)
      kao(:, 2, 1,14) = (/ &
     &1.6846e-01_r8,5.5554e-01_r8,1.1039e+00_r8,1.6417e+00_r8,2.1611e+00_r8,2.6456e+00_r8, &
     &3.0463e+00_r8,3.1695e+00_r8,4.3222e+00_r8/)
      kao(:, 3, 1,14) = (/ &
     &1.9174e-01_r8,6.6749e-01_r8,1.3276e+00_r8,1.9756e+00_r8,2.6027e+00_r8,3.1886e+00_r8, &
     &3.6789e+00_r8,3.8433e+00_r8,5.2055e+00_r8/)
      kao(:, 4, 1,14) = (/ &
     &2.1490e-01_r8,7.8476e-01_r8,1.5609e+00_r8,2.3233e+00_r8,3.0639e+00_r8,3.7563e+00_r8, &
     &4.3396e+00_r8,4.5493e+00_r8,6.1279e+00_r8/)
      kao(:, 5, 1,14) = (/ &
     &2.3691e-01_r8,9.0765e-01_r8,1.8042e+00_r8,2.6834e+00_r8,3.5348e+00_r8,4.3362e+00_r8, &
     &5.0160e+00_r8,5.2774e+00_r8,7.0696e+00_r8/)
      kao(:, 1, 2,14) = (/ &
     &2.1296e-01_r8,4.6215e-01_r8,9.1984e-01_r8,1.3706e+00_r8,1.8091e+00_r8,2.2245e+00_r8, &
     &2.5860e+00_r8,2.7730e+00_r8,3.6182e+00_r8/)
      kao(:, 2, 2,14) = (/ &
     &2.5016e-01_r8,5.6432e-01_r8,1.1237e+00_r8,1.6756e+00_r8,2.2151e+00_r8,2.7294e+00_r8, &
     &3.1864e+00_r8,3.4606e+00_r8,4.4301e+00_r8/)
      kao(:, 3, 2,14) = (/ &
     &2.8692e-01_r8,6.7375e-01_r8,1.3425e+00_r8,2.0033e+00_r8,2.6512e+00_r8,3.2743e+00_r8, &
     &3.8384e+00_r8,4.2145e+00_r8,5.3023e+00_r8/)
      kao(:, 4, 2,14) = (/ &
     &3.2327e-01_r8,7.9645e-01_r8,1.5866e+00_r8,2.3669e+00_r8,3.1323e+00_r8,3.8679e+00_r8, &
     &4.5425e+00_r8,5.0100e+00_r8,6.2645e+00_r8/)
      kao(:, 5, 2,14) = (/ &
     &3.5851e-01_r8,9.3518e-01_r8,1.8621e+00_r8,2.7777e+00_r8,3.6730e+00_r8,4.5297e+00_r8, &
     &5.3029e+00_r8,5.8281e+00_r8,7.3458e+00_r8/)
      kao(:, 1, 3,14) = (/ &
     &4.0569e-01_r8,4.7346e-01_r8,9.0139e-01_r8,1.3483e+00_r8,1.7892e+00_r8,2.2204e+00_r8, &
     &2.6252e+00_r8,2.9358e+00_r8,3.5784e+00_r8/)
      kao(:, 2, 3,14) = (/ &
     &4.8357e-01_r8,5.7585e-01_r8,1.1016e+00_r8,1.6482e+00_r8,2.1888e+00_r8,2.7185e+00_r8, &
     &3.2205e+00_r8,3.6184e+00_r8,4.3777e+00_r8/)
      kao(:, 3, 3,14) = (/ &
     &5.6184e-01_r8,6.8539e-01_r8,1.3182e+00_r8,1.9726e+00_r8,2.6206e+00_r8,3.2555e+00_r8, &
     &3.8616e+00_r8,4.3597e+00_r8,5.2411e+00_r8/)
      kao(:, 4, 3,14) = (/ &
     &6.3937e-01_r8,8.0074e-01_r8,1.5659e+00_r8,2.3420e+00_r8,3.1101e+00_r8,3.8617e+00_r8, &
     &4.5735e+00_r8,5.1595e+00_r8,6.2201e+00_r8/)
      kao(:, 5, 3,14) = (/ &
     &7.1542e-01_r8,9.3290e-01_r8,1.8594e+00_r8,2.7803e+00_r8,3.6907e+00_r8,4.5815e+00_r8, &
     &5.4228e+00_r8,6.0997e+00_r8,7.3811e+00_r8/)
      kao(:, 1, 4,14) = (/ &
     &7.7613e-01_r8,7.2482e-01_r8,8.8213e-01_r8,1.2906e+00_r8,1.7174e+00_r8,2.1406e+00_r8, &
     &2.5536e+00_r8,2.9272e+00_r8,3.4348e+00_r8/)
      kao(:, 2, 4,14) = (/ &
     &9.4054e-01_r8,9.0136e-01_r8,1.0781e+00_r8,1.5850e+00_r8,2.1098e+00_r8,2.6295e+00_r8, &
     &3.1372e+00_r8,3.6020e+00_r8,4.2194e+00_r8/)
      kao(:, 3, 4,14) = (/ &
     &1.1095e+00_r8,1.0843e+00_r8,1.2887e+00_r8,1.9170e+00_r8,2.5512e+00_r8,3.1791e+00_r8, &
     &3.7919e+00_r8,4.3511e+00_r8,5.1021e+00_r8/)
      kao(:, 4, 4,14) = (/ &
     &1.2791e+00_r8,1.2603e+00_r8,1.5382e+00_r8,2.3038e+00_r8,3.0649e+00_r8,3.8173e+00_r8, &
     &4.5513e+00_r8,5.2083e+00_r8,6.1294e+00_r8/)
      kao(:, 5, 4,14) = (/ &
     &1.4465e+00_r8,1.4292e+00_r8,1.8362e+00_r8,2.7499e+00_r8,3.6579e+00_r8,4.5561e+00_r8, &
     &5.4280e+00_r8,6.2050e+00_r8,7.3150e+00_r8/)
      kao(:, 1, 5,14) = (/ &
     &1.3553e+00_r8,1.1859e+00_r8,1.1889e+00_r8,1.2820e+00_r8,1.6126e+00_r8,2.0133e+00_r8, &
     &2.4100e+00_r8,2.7917e+00_r8,3.2251e+00_r8/)
      kao(:, 2, 5,14) = (/ &
     &1.6746e+00_r8,1.4653e+00_r8,1.4722e+00_r8,1.5790e+00_r8,2.0132e+00_r8,2.5133e+00_r8, &
     &3.0071e+00_r8,3.4795e+00_r8,4.0262e+00_r8/)
      kao(:, 3, 5,14) = (/ &
     &2.0071e+00_r8,1.7563e+00_r8,1.7644e+00_r8,1.8926e+00_r8,2.4705e+00_r8,3.0826e+00_r8, &
     &3.6880e+00_r8,4.2630e+00_r8,4.9404e+00_r8/)
      kao(:, 4, 5,14) = (/ &
     &2.3461e+00_r8,2.0539e+00_r8,2.0623e+00_r8,2.2628e+00_r8,3.0107e+00_r8,3.7562e+00_r8, &
     &4.4918e+00_r8,5.1850e+00_r8,6.0203e+00_r8/)
      kao(:, 5, 5,14) = (/ &
     &2.6832e+00_r8,2.3569e+00_r8,2.3578e+00_r8,2.7266e+00_r8,3.6306e+00_r8,4.5292e+00_r8, &
     &5.4146e+00_r8,6.2480e+00_r8,7.2595e+00_r8/)
      kao(:, 1, 6,14) = (/ &
     &2.1798e+00_r8,1.9076e+00_r8,1.6634e+00_r8,1.6610e+00_r8,1.6126e+00_r8,1.8086e+00_r8, &
     &2.1681e+00_r8,2.5212e+00_r8,2.8955e+00_r8/)
      kao(:, 2, 6,14) = (/ &
     &2.7568e+00_r8,2.4124e+00_r8,2.1319e+00_r8,2.0890e+00_r8,2.0379e+00_r8,2.3402e+00_r8, &
     &2.8045e+00_r8,3.2592e+00_r8,3.7464e+00_r8/)
      kao(:, 3, 6,14) = (/ &
     &3.3653e+00_r8,2.9447e+00_r8,2.6494e+00_r8,2.5260e+00_r8,2.4774e+00_r8,2.9464e+00_r8, &
     &3.5300e+00_r8,4.0980e+00_r8,4.7178e+00_r8/)
      kao(:, 4, 6,14) = (/ &
     &3.9980e+00_r8,3.4981e+00_r8,3.2081e+00_r8,2.9759e+00_r8,2.9694e+00_r8,3.6441e+00_r8, &
     &4.3643e+00_r8,5.0633e+00_r8,5.8364e+00_r8/)
      kao(:, 5, 6,14) = (/ &
     &4.6371e+00_r8,4.0569e+00_r8,3.7676e+00_r8,3.4231e+00_r8,3.5724e+00_r8,4.4465e+00_r8, &
     &5.3245e+00_r8,6.1747e+00_r8,7.1186e+00_r8/)
      kao(:, 1, 7,14) = (/ &
     &3.6500e+00_r8,3.1940e+00_r8,2.7377e+00_r8,2.3521e+00_r8,2.2005e+00_r8,1.9226e+00_r8, &
     &1.8951e+00_r8,2.2032e+00_r8,2.5224e+00_r8/)
      kao(:, 2, 7,14) = (/ &
     &4.7380e+00_r8,4.1460e+00_r8,3.5535e+00_r8,3.0746e+00_r8,2.8560e+00_r8,2.4862e+00_r8, &
     &2.5325e+00_r8,2.9498e+00_r8,3.3790e+00_r8/)
      kao(:, 3, 7,14) = (/ &
     &5.9099e+00_r8,5.1713e+00_r8,4.4326e+00_r8,3.9038e+00_r8,3.5341e+00_r8,3.0823e+00_r8, &
     &3.2930e+00_r8,3.8333e+00_r8,4.3949e+00_r8/)
      kao(:, 4, 7,14) = (/ &
     &7.1406e+00_r8,6.2480e+00_r8,5.3561e+00_r8,4.7936e+00_r8,4.2290e+00_r8,3.7296e+00_r8, &
     &4.1867e+00_r8,4.8720e+00_r8,5.5890e+00_r8/)
      kao(:, 5, 7,14) = (/ &
     &8.4067e+00_r8,7.3559e+00_r8,6.3050e+00_r8,5.6953e+00_r8,4.9319e+00_r8,4.4981e+00_r8, &
     &5.2053e+00_r8,6.0551e+00_r8,6.9478e+00_r8/)
      kao(:, 1, 8,14) = (/ &
     &7.2793e+00_r8,6.3695e+00_r8,5.4593e+00_r8,4.5496e+00_r8,3.6668e+00_r8,3.0739e+00_r8, &
     &2.3812e+00_r8,1.8850e+00_r8,2.1414e+00_r8/)
      kao(:, 2, 8,14) = (/ &
     &9.7148e+00_r8,8.5004e+00_r8,7.2858e+00_r8,6.0719e+00_r8,4.9067e+00_r8,4.1050e+00_r8, &
     &3.1504e+00_r8,2.5960e+00_r8,2.9698e+00_r8/)
      kao(:, 3, 8,14) = (/ &
     &1.2408e+01_r8,1.0858e+01_r8,9.3058e+00_r8,7.7549e+00_r8,6.3008e+00_r8,5.2586e+00_r8, &
     &3.9820e+00_r8,3.4865e+00_r8,3.9886e+00_r8/)
      kao(:, 4, 8,14) = (/ &
     &1.5301e+01_r8,1.3388e+01_r8,1.1476e+01_r8,9.5632e+00_r8,7.8364e+00_r8,6.4696e+00_r8, &
     &4.8601e+00_r8,4.5513e+00_r8,5.2081e+00_r8/)
      kao(:, 5, 8,14) = (/ &
     &1.8319e+01_r8,1.6029e+01_r8,1.3740e+01_r8,1.1449e+01_r8,9.4798e+00_r8,7.7150e+00_r8, &
     &5.8215e+00_r8,5.7877e+00_r8,6.6226e+00_r8/)
      kao(:, 1, 9,14) = (/ &
     &2.7093e+01_r8,2.3706e+01_r8,2.0321e+01_r8,1.6934e+01_r8,1.3547e+01_r8,1.0161e+01_r8, &
     &6.7735e+00_r8,3.8947e+00_r8,1.7904e+00_r8/)
      kao(:, 2, 9,14) = (/ &
     &3.7356e+01_r8,3.2687e+01_r8,2.8017e+01_r8,2.3347e+01_r8,1.8679e+01_r8,1.4008e+01_r8, &
     &9.3393e+00_r8,5.3672e+00_r8,2.5563e+00_r8/)
      kao(:, 3, 9,14) = (/ &
     &4.9010e+01_r8,4.2883e+01_r8,3.6757e+01_r8,3.0630e+01_r8,2.4505e+01_r8,1.8379e+01_r8, &
     &1.2257e+01_r8,7.0400e+00_r8,3.5347e+00_r8/)
      kao(:, 4, 9,14) = (/ &
     &6.1735e+01_r8,5.4018e+01_r8,4.6300e+01_r8,3.8583e+01_r8,3.0868e+01_r8,2.3150e+01_r8, &
     &1.5458e+01_r8,8.8071e+00_r8,4.7393e+00_r8/)
      kao(:, 5, 9,14) = (/ &
     &7.5284e+01_r8,6.5873e+01_r8,5.6463e+01_r8,4.7052e+01_r8,3.7640e+01_r8,2.8233e+01_r8, &
     &1.8889e+01_r8,1.0654e+01_r8,6.1635e+00_r8/)
      kao(:, 1,10,14) = (/ &
     &1.1501e+02_r8,1.0064e+02_r8,8.6262e+01_r8,7.1883e+01_r8,5.7506e+01_r8,4.3130e+01_r8, &
     &2.8755e+01_r8,1.4378e+01_r8,5.7116e-01_r8/)
      kao(:, 2,10,14) = (/ &
     &1.6323e+02_r8,1.4283e+02_r8,1.2242e+02_r8,1.0202e+02_r8,8.1614e+01_r8,6.1213e+01_r8, &
     &4.0807e+01_r8,2.0405e+01_r8,4.6944e-01_r8/)
      kao(:, 3,10,14) = (/ &
     &2.1950e+02_r8,1.9206e+02_r8,1.6462e+02_r8,1.3718e+02_r8,1.0975e+02_r8,8.2311e+01_r8, &
     &5.4875e+01_r8,2.7438e+01_r8,1.0245e+00_r8/)
      kao(:, 4,10,14) = (/ &
     &2.8264e+02_r8,2.4730e+02_r8,2.1197e+02_r8,1.7666e+02_r8,1.4132e+02_r8,1.0599e+02_r8, &
     &7.0664e+01_r8,3.5330e+01_r8,2.8560e+00_r8/)
      kao(:, 5,10,14) = (/ &
     &3.5102e+02_r8,3.0716e+02_r8,2.6326e+02_r8,2.1939e+02_r8,1.7551e+02_r8,1.3164e+02_r8, &
     &8.7759e+01_r8,4.3879e+01_r8,5.5928e+00_r8/)
      kao(:, 1,11,14) = (/ &
     &2.0513e+02_r8,1.7948e+02_r8,1.5384e+02_r8,1.2821e+02_r8,1.0256e+02_r8,7.6924e+01_r8, &
     &5.1281e+01_r8,2.5640e+01_r8,9.4489e-01_r8/)
      kao(:, 2,11,14) = (/ &
     &2.8915e+02_r8,2.5300e+02_r8,2.1687e+02_r8,1.8072e+02_r8,1.4458e+02_r8,1.0844e+02_r8, &
     &7.2287e+01_r8,3.6146e+01_r8,1.0101e+00_r8/)
      kao(:, 3,11,14) = (/ &
     &3.8981e+02_r8,3.4108e+02_r8,2.9236e+02_r8,2.4364e+02_r8,1.9490e+02_r8,1.4617e+02_r8, &
     &9.7460e+01_r8,4.8730e+01_r8,5.8913e-01_r8/)
      kao(:, 4,11,14) = (/ &
     &5.0429e+02_r8,4.4124e+02_r8,3.7819e+02_r8,3.1515e+02_r8,2.5212e+02_r8,1.8910e+02_r8, &
     &1.2606e+02_r8,6.3034e+01_r8,1.0227e+00_r8/)
      kao(:, 5,11,14) = (/ &
     &6.2985e+02_r8,5.5113e+02_r8,4.7241e+02_r8,3.9368e+02_r8,3.1495e+02_r8,2.3621e+02_r8, &
     &1.5747e+02_r8,7.8734e+01_r8,3.1704e+00_r8/)
      kao(:, 1,12,14) = (/ &
     &2.7480e+02_r8,2.4043e+02_r8,2.0609e+02_r8,1.7173e+02_r8,1.3740e+02_r8,1.0305e+02_r8, &
     &6.8696e+01_r8,3.4350e+01_r8,1.0331e+00_r8/)
      kao(:, 2,12,14) = (/ &
     &3.8434e+02_r8,3.3629e+02_r8,2.8824e+02_r8,2.4020e+02_r8,1.9217e+02_r8,1.4412e+02_r8, &
     &9.6082e+01_r8,4.8041e+01_r8,1.0697e+00_r8/)
      kao(:, 3,12,14) = (/ &
     &5.1835e+02_r8,4.5357e+02_r8,3.8876e+02_r8,3.2398e+02_r8,2.5917e+02_r8,1.9438e+02_r8, &
     &1.2959e+02_r8,6.4795e+01_r8,6.6152e-01_r8/)
      kao(:, 4,12,14) = (/ &
     &6.7292e+02_r8,5.8878e+02_r8,5.0467e+02_r8,4.2055e+02_r8,3.3645e+02_r8,2.5234e+02_r8, &
     &1.6823e+02_r8,8.4112e+01_r8,1.1390e+00_r8/)
      kao(:, 5,12,14) = (/ &
     &8.4273e+02_r8,7.3739e+02_r8,6.3205e+02_r8,5.2668e+02_r8,4.2135e+02_r8,3.1602e+02_r8, &
     &2.1069e+02_r8,1.0534e+02_r8,2.2409e+00_r8/)
      kao(:, 1,13,14) = (/ &
     &2.9725e+02_r8,2.6009e+02_r8,2.2295e+02_r8,1.8578e+02_r8,1.4862e+02_r8,1.1147e+02_r8, &
     &7.4314e+01_r8,3.7158e+01_r8,8.5883e-01_r8/)
      kao(:, 2,13,14) = (/ &
     &4.1294e+02_r8,3.6134e+02_r8,3.0971e+02_r8,2.5809e+02_r8,2.0649e+02_r8,1.5487e+02_r8, &
     &1.0324e+02_r8,5.1621e+01_r8,7.4403e-01_r8/)
      kao(:, 3,13,14) = (/ &
     &5.5484e+02_r8,4.8548e+02_r8,4.1611e+02_r8,3.4677e+02_r8,2.7741e+02_r8,2.0806e+02_r8, &
     &1.3871e+02_r8,6.9351e+01_r8,6.5779e-01_r8/)
      kao(:, 4,13,14) = (/ &
     &7.2016e+02_r8,6.3017e+02_r8,5.4015e+02_r8,4.5013e+02_r8,3.6010e+02_r8,2.7007e+02_r8, &
     &1.8004e+02_r8,9.0025e+01_r8,1.1133e+00_r8/)
      kao(:, 5,13,14) = (/ &
     &9.0551e+02_r8,7.9235e+02_r8,6.7916e+02_r8,5.6596e+02_r8,4.5276e+02_r8,3.3958e+02_r8, &
     &2.2638e+02_r8,1.1319e+02_r8,2.5474e+00_r8/)
      kao(:, 1, 1,15) = (/ &
     &1.6993e-01_r8,6.2319e-01_r8,1.2302e+00_r8,1.8117e+00_r8,2.3534e+00_r8,2.8224e+00_r8, &
     &3.1427e+00_r8,3.0683e+00_r8,4.7067e+00_r8/)
      kao(:, 2, 1,15) = (/ &
     &1.9652e-01_r8,7.8355e-01_r8,1.5463e+00_r8,2.2775e+00_r8,2.9572e+00_r8,3.5450e+00_r8, &
     &3.9419e+00_r8,3.8320e+00_r8,5.9144e+00_r8/)
      kao(:, 3, 1,15) = (/ &
     &2.2200e-01_r8,9.5617e-01_r8,1.8872e+00_r8,2.7806e+00_r8,3.6114e+00_r8,4.3315e+00_r8, &
     &4.8212e+00_r8,4.6828e+00_r8,7.2228e+00_r8/)
      kao(:, 4, 1,15) = (/ &
     &2.4720e-01_r8,1.1411e+00_r8,2.2528e+00_r8,3.3193e+00_r8,4.3116e+00_r8,5.1713e+00_r8, &
     &5.7552e+00_r8,5.5959e+00_r8,8.6231e+00_r8/)
      kao(:, 5, 1,15) = (/ &
     &2.7067e-01_r8,1.3368e+00_r8,2.6392e+00_r8,3.8885e+00_r8,5.0531e+00_r8,6.0617e+00_r8, &
     &6.7490e+00_r8,6.5681e+00_r8,1.0106e+01_r8/)
      kao(:, 1, 2,15) = (/ &
     &2.5495e-01_r8,6.7714e-01_r8,1.3429e+00_r8,1.9911e+00_r8,2.6102e+00_r8,3.1741e+00_r8, &
     &3.6176e+00_r8,3.6989e+00_r8,5.2204e+00_r8/)
      kao(:, 2, 2,15) = (/ &
     &2.9713e-01_r8,8.6139e-01_r8,1.7085e+00_r8,2.5326e+00_r8,3.3191e+00_r8,4.0358e+00_r8, &
     &4.5977e+00_r8,4.6904e+00_r8,6.6382e+00_r8/)
      kao(:, 3, 2,15) = (/ &
     &3.3791e-01_r8,1.0632e+00_r8,2.1089e+00_r8,3.1273e+00_r8,4.0996e+00_r8,4.9862e+00_r8, &
     &5.6823e+00_r8,5.7948e+00_r8,8.1990e+00_r8/)
      kao(:, 4, 2,15) = (/ &
     &3.7751e-01_r8,1.2778e+00_r8,2.5347e+00_r8,3.7591e+00_r8,4.9277e+00_r8,5.9944e+00_r8, &
     &6.8345e+00_r8,6.9830e+00_r8,9.8554e+00_r8/)
      kao(:, 5, 2,15) = (/ &
     &4.1544e-01_r8,1.5054e+00_r8,2.9855e+00_r8,4.4278e+00_r8,5.8067e+00_r8,7.0647e+00_r8, &
     &8.0557e+00_r8,8.2364e+00_r8,1.1613e+01_r8/)
      kao(:, 1, 3,15) = (/ &
     &4.9608e-01_r8,6.8984e-01_r8,1.3746e+00_r8,2.0502e+00_r8,2.7121e+00_r8,3.3455e+00_r8, &
     &3.9122e+00_r8,4.2490e+00_r8,5.4242e+00_r8/)
      kao(:, 2, 3,15) = (/ &
     &5.8591e-01_r8,8.9422e-01_r8,1.7812e+00_r8,2.6579e+00_r8,3.5151e+00_r8,4.3360e+00_r8, &
     &5.0694e+00_r8,5.5020e+00_r8,7.0303e+00_r8/)
      kao(:, 3, 3,15) = (/ &
     &6.7409e-01_r8,1.1231e+00_r8,2.2377e+00_r8,3.3379e+00_r8,4.4153e+00_r8,5.4452e+00_r8, &
     &6.3666e+00_r8,6.9097e+00_r8,8.8307e+00_r8/)
      kao(:, 4, 3,15) = (/ &
     &7.5926e-01_r8,1.3688e+00_r8,2.7271e+00_r8,4.0692e+00_r8,5.3814e+00_r8,6.6410e+00_r8, &
     &7.7706e+00_r8,8.4452e+00_r8,1.0763e+01_r8/)
      kao(:, 5, 3,15) = (/ &
     &8.4200e-01_r8,1.6284e+00_r8,3.2443e+00_r8,4.8405e+00_r8,6.4040e+00_r8,7.9036e+00_r8, &
     &9.2460e+00_r8,1.0057e+01_r8,1.2808e+01_r8/)
      kao(:, 1, 4,15) = (/ &
     &9.7215e-01_r8,8.5067e-01_r8,1.3532e+00_r8,2.0247e+00_r8,2.6895e+00_r8,3.3419e+00_r8, &
     &3.9624e+00_r8,4.4662e+00_r8,5.3791e+00_r8/)
      kao(:, 2, 4,15) = (/ &
     &1.1632e+00_r8,1.0264e+00_r8,1.7937e+00_r8,2.6847e+00_r8,3.5667e+00_r8,4.4317e+00_r8, &
     &5.2538e+00_r8,5.9212e+00_r8,7.1333e+00_r8/)
      kao(:, 3, 4,15) = (/ &
     &1.3574e+00_r8,1.2217e+00_r8,2.2951e+00_r8,3.4352e+00_r8,4.5625e+00_r8,5.6686e+00_r8, &
     &6.7222e+00_r8,7.5788e+00_r8,9.1250e+00_r8/)
      kao(:, 4, 4,15) = (/ &
     &1.5473e+00_r8,1.4621e+00_r8,2.8487e+00_r8,4.2635e+00_r8,5.6651e+00_r8,7.0387e+00_r8, &
     &8.3491e+00_r8,9.4177e+00_r8,1.1330e+01_r8/)
      kao(:, 5, 4,15) = (/ &
     &1.7305e+00_r8,1.7312e+00_r8,3.4330e+00_r8,5.1366e+00_r8,6.8257e+00_r8,8.4825e+00_r8, &
     &1.0065e+01_r8,1.1356e+01_r8,1.3651e+01_r8/)
      kao(:, 1, 5,15) = (/ &
     &1.7388e+00_r8,1.5215e+00_r8,1.3772e+00_r8,1.9641e+00_r8,2.6140e+00_r8,3.2573e+00_r8, &
     &3.8853e+00_r8,4.4515e+00_r8,5.2280e+00_r8/)
      kao(:, 2, 5,15) = (/ &
     &2.1169e+00_r8,1.8521e+00_r8,1.7962e+00_r8,2.6470e+00_r8,3.5230e+00_r8,4.3915e+00_r8, &
     &5.2396e+00_r8,6.0117e+00_r8,7.0460e+00_r8/)
      kao(:, 3, 5,15) = (/ &
     &2.5041e+00_r8,2.1909e+00_r8,2.3110e+00_r8,3.4553e+00_r8,4.5986e+00_r8,5.7308e+00_r8, &
     &6.8405e+00_r8,7.8473e+00_r8,9.1972e+00_r8/)
      kao(:, 4, 5,15) = (/ &
     &2.8915e+00_r8,2.5301e+00_r8,2.9136e+00_r8,4.3640e+00_r8,5.8101e+00_r8,7.2418e+00_r8, &
     &8.6447e+00_r8,9.9184e+00_r8,1.1620e+01_r8/)
      kao(:, 5, 5,15) = (/ &
     &3.2655e+00_r8,2.8574e+00_r8,3.5660e+00_r8,5.3438e+00_r8,7.1123e+00_r8,8.8675e+00_r8, &
     &1.0583e+01_r8,1.2152e+01_r8,1.4224e+01_r8/)
      kao(:, 1, 6,15) = (/ &
     &2.8657e+00_r8,2.5077e+00_r8,2.1495e+00_r8,1.9426e+00_r8,2.5509e+00_r8,3.1827e+00_r8, &
     &3.8069e+00_r8,4.3973e+00_r8,5.1017e+00_r8/)
      kao(:, 2, 6,15) = (/ &
     &3.5656e+00_r8,3.1200e+00_r8,2.6742e+00_r8,2.5857e+00_r8,3.4175e+00_r8,4.2650e+00_r8, &
     &5.1021e+00_r8,5.8962e+00_r8,6.8350e+00_r8/)
      kao(:, 3, 6,15) = (/ &
     &4.2807e+00_r8,3.7458e+00_r8,3.2105e+00_r8,3.3891e+00_r8,4.4929e+00_r8,5.6082e+00_r8, &
     &6.7100e+00_r8,7.7616e+00_r8,8.9857e+00_r8/)
      kao(:, 4, 6,15) = (/ &
     &5.0170e+00_r8,4.3893e+00_r8,3.7667e+00_r8,4.3378e+00_r8,5.7738e+00_r8,7.2087e+00_r8, &
     &8.6270e+00_r8,9.9837e+00_r8,1.1548e+01_r8/)
      kao(:, 5, 6,15) = (/ &
     &5.7403e+00_r8,5.0226e+00_r8,4.3725e+00_r8,5.3984e+00_r8,7.1936e+00_r8,8.9774e+00_r8, &
     &1.0747e+01_r8,1.2440e+01_r8,1.4387e+01_r8/)
      kao(:, 1, 7,15) = (/ &
     &4.9113e+00_r8,4.2974e+00_r8,3.6835e+00_r8,3.0697e+00_r8,2.6153e+00_r8,3.1091e+00_r8, &
     &3.7251e+00_r8,4.3239e+00_r8,4.9783e+00_r8/)
      kao(:, 2, 7,15) = (/ &
     &6.2562e+00_r8,5.4743e+00_r8,4.6920e+00_r8,3.9102e+00_r8,3.4334e+00_r8,4.1812e+00_r8, &
     &5.0095e+00_r8,5.8168e+00_r8,6.6958e+00_r8/)
      kao(:, 3, 7,15) = (/ &
     &7.6604e+00_r8,6.7031e+00_r8,5.7453e+00_r8,4.7880e+00_r8,4.4844e+00_r8,5.5063e+00_r8, &
     &6.5975e+00_r8,7.6628e+00_r8,8.8178e+00_r8/)
      kao(:, 4, 7,15) = (/ &
     &9.1018e+00_r8,7.9643e+00_r8,6.8268e+00_r8,5.7331e+00_r8,5.7498e+00_r8,7.0854e+00_r8, &
     &8.4900e+00_r8,9.8659e+00_r8,1.1347e+01_r8/)
      kao(:, 5, 7,15) = (/ &
     &1.0558e+01_r8,9.2378e+00_r8,7.9183e+00_r8,6.7553e+00_r8,7.1878e+00_r8,8.8933e+00_r8, &
     &1.0658e+01_r8,1.2385e+01_r8,1.4238e+01_r8/)
      kao(:, 1, 8,15) = (/ &
     &1.0009e+01_r8,8.7571e+00_r8,7.5061e+00_r8,6.2547e+00_r8,5.0042e+00_r8,3.7993e+00_r8, &
     &3.6112e+00_r8,4.2052e+00_r8,4.8194e+00_r8/)
      kao(:, 2, 8,15) = (/ &
     &1.3089e+01_r8,1.1454e+01_r8,9.8171e+00_r8,8.1811e+00_r8,6.5451e+00_r8,5.0064e+00_r8, &
     &4.9059e+00_r8,5.7129e+00_r8,6.5481e+00_r8/)
      kao(:, 3, 8,15) = (/ &
     &1.6387e+01_r8,1.4339e+01_r8,1.2290e+01_r8,1.0242e+01_r8,8.1941e+00_r8,6.3517e+00_r8, &
     &6.5066e+00_r8,7.5778e+00_r8,8.6840e+00_r8/)
      kao(:, 4, 8,15) = (/ &
     &1.9809e+01_r8,1.7333e+01_r8,1.4856e+01_r8,1.2381e+01_r8,9.9047e+00_r8,7.9569e+00_r8, &
     &8.4189e+00_r8,9.8052e+00_r8,1.1235e+01_r8/)
      kao(:, 5, 8,15) = (/ &
     &2.3310e+01_r8,2.0396e+01_r8,1.7482e+01_r8,1.4569e+01_r8,1.1654e+01_r8,9.7998e+00_r8, &
     &1.0613e+01_r8,1.2362e+01_r8,1.4162e+01_r8/)
      kao(:, 1, 9,15) = (/ &
     &3.8130e+01_r8,3.3362e+01_r8,2.8596e+01_r8,2.3830e+01_r8,1.9065e+01_r8,1.4298e+01_r8, &
     &9.5322e+00_r8,4.9254e+00_r8,4.5210e+00_r8/)
      kao(:, 2, 9,15) = (/ &
     &5.1350e+01_r8,4.4933e+01_r8,3.8514e+01_r8,3.2094e+01_r8,2.5677e+01_r8,1.9258e+01_r8, &
     &1.2838e+01_r8,6.6242e+00_r8,6.3225e+00_r8/)
      kao(:, 3, 9,15) = (/ &
     &6.5865e+01_r8,5.7633e+01_r8,4.9398e+01_r8,4.1167e+01_r8,3.2931e+01_r8,2.4701e+01_r8, &
     &1.6465e+01_r8,8.5406e+00_r8,8.4711e+00_r8/)
      kao(:, 4, 9,15) = (/ &
     &8.1194e+01_r8,7.1041e+01_r8,6.0891e+01_r8,5.0738e+01_r8,4.0591e+01_r8,3.0449e+01_r8, &
     &2.0297e+01_r8,1.0902e+01_r8,1.1050e+01_r8/)
      kao(:, 5, 9,15) = (/ &
     &9.6976e+01_r8,8.4851e+01_r8,7.2734e+01_r8,6.0609e+01_r8,4.8485e+01_r8,3.6366e+01_r8, &
     &2.4244e+01_r8,1.3609e+01_r8,1.4022e+01_r8/)
      kao(:, 1,10,15) = (/ &
     &1.6495e+02_r8,1.4434e+02_r8,1.2371e+02_r8,1.0308e+02_r8,8.2478e+01_r8,6.1862e+01_r8, &
     &4.1240e+01_r8,2.0620e+01_r8,1.6305e+00_r8/)
      kao(:, 2,10,15) = (/ &
     &2.2828e+02_r8,1.9973e+02_r8,1.7121e+02_r8,1.4267e+02_r8,1.1414e+02_r8,8.5604e+01_r8, &
     &5.7062e+01_r8,2.8536e+01_r8,5.3393e+00_r8/)
      kao(:, 3,10,15) = (/ &
     &2.9925e+02_r8,2.6184e+02_r8,2.2444e+02_r8,1.8703e+02_r8,1.4963e+02_r8,1.1222e+02_r8, &
     &7.4815e+01_r8,3.7408e+01_r8,8.3308e+00_r8/)
      kao(:, 4,10,15) = (/ &
     &3.7719e+02_r8,3.3003e+02_r8,2.8287e+02_r8,2.3573e+02_r8,1.8859e+02_r8,1.4144e+02_r8, &
     &9.4294e+01_r8,4.7146e+01_r8,1.0953e+01_r8/)
      kao(:, 5,10,15) = (/ &
     &4.5955e+02_r8,4.0214e+02_r8,3.4467e+02_r8,2.8724e+02_r8,2.2979e+02_r8,1.7235e+02_r8, &
     &1.1490e+02_r8,5.7448e+01_r8,1.3975e+01_r8/)
      kao(:, 1,11,15) = (/ &
     &2.9347e+02_r8,2.5677e+02_r8,2.2010e+02_r8,1.8342e+02_r8,1.4673e+02_r8,1.1005e+02_r8, &
     &7.3365e+01_r8,3.6685e+01_r8,2.5030e-01_r8/)
      kao(:, 2,11,15) = (/ &
     &4.0846e+02_r8,3.5738e+02_r8,3.0635e+02_r8,2.5530e+02_r8,2.0423e+02_r8,1.5319e+02_r8, &
     &1.0212e+02_r8,5.1058e+01_r8,2.2261e+00_r8/)
      kao(:, 3,11,15) = (/ &
     &5.3934e+02_r8,4.7191e+02_r8,4.0450e+02_r8,3.3708e+02_r8,2.6969e+02_r8,2.0225e+02_r8, &
     &1.3483e+02_r8,6.7419e+01_r8,7.0745e+00_r8/)
      kao(:, 4,11,15) = (/ &
     &6.8280e+02_r8,5.9745e+02_r8,5.1209e+02_r8,4.2676e+02_r8,3.4141e+02_r8,2.5605e+02_r8, &
     &1.7070e+02_r8,8.5353e+01_r8,1.1909e+01_r8/)
      kao(:, 5,11,15) = (/ &
     &8.3619e+02_r8,7.3167e+02_r8,6.2713e+02_r8,5.2262e+02_r8,4.1810e+02_r8,3.1359e+02_r8, &
     &2.0904e+02_r8,1.0453e+02_r8,1.5372e+01_r8/)
      kao(:, 1,12,15) = (/ &
     &3.9587e+02_r8,3.4637e+02_r8,2.9690e+02_r8,2.4742e+02_r8,1.9794e+02_r8,1.4844e+02_r8, &
     &9.8964e+01_r8,4.9484e+01_r8,3.4642e-05_r8/)
      kao(:, 2,12,15) = (/ &
     &5.5272e+02_r8,4.8359e+02_r8,4.1455e+02_r8,3.4543e+02_r8,2.7636e+02_r8,2.0725e+02_r8, &
     &1.3818e+02_r8,6.9086e+01_r8,1.7207e+00_r8/)
      kao(:, 3,12,15) = (/ &
     &7.3408e+02_r8,6.4226e+02_r8,5.5052e+02_r8,4.5884e+02_r8,3.6704e+02_r8,2.7529e+02_r8, &
     &1.8352e+02_r8,9.1757e+01_r8,6.4555e+00_r8/)
      kao(:, 4,12,15) = (/ &
     &9.3778e+02_r8,8.2044e+02_r8,7.0331e+02_r8,5.8607e+02_r8,4.6883e+02_r8,3.5166e+02_r8, &
     &2.3443e+02_r8,1.1722e+02_r8,1.0884e+01_r8/)
      kao(:, 5,12,15) = (/ &
     &1.1629e+03_r8,1.0175e+03_r8,8.7216e+02_r8,7.2684e+02_r8,5.8142e+02_r8,4.3609e+02_r8, &
     &2.9073e+02_r8,1.4537e+02_r8,1.6871e+01_r8/)
      kao(:, 1,13,15) = (/ &
     &4.3408e+02_r8,3.7980e+02_r8,3.2553e+02_r8,2.7129e+02_r8,2.1704e+02_r8,1.6278e+02_r8, &
     &1.0851e+02_r8,5.4254e+01_r8,3.3387e-01_r8/)
      kao(:, 2,13,15) = (/ &
     &6.1113e+02_r8,5.3482e+02_r8,4.5841e+02_r8,3.8201e+02_r8,3.0560e+02_r8,2.2920e+02_r8, &
     &1.5279e+02_r8,7.6397e+01_r8,3.4060e+00_r8/)
      kao(:, 3,13,15) = (/ &
     &8.2033e+02_r8,7.1780e+02_r8,6.1525e+02_r8,5.1272e+02_r8,4.1017e+02_r8,3.0764e+02_r8, &
     &2.0509e+02_r8,1.0254e+02_r8,7.3848e+00_r8/)
      kao(:, 4,13,15) = (/ &
     &1.0623e+03_r8,9.2952e+02_r8,7.9671e+02_r8,6.6390e+02_r8,5.3111e+02_r8,3.9834e+02_r8, &
     &2.6556e+02_r8,1.3278e+02_r8,1.3310e+01_r8/)
      kao(:, 5,13,15) = (/ &
     &1.3308e+03_r8,1.1645e+03_r8,9.9813e+02_r8,8.3174e+02_r8,6.6542e+02_r8,4.9907e+02_r8, &
     &3.3271e+02_r8,1.6635e+02_r8,1.8499e+01_r8/)
      kao(:, 1, 1,16) = (/ &
     &1.7254e-01_r8,6.6462e-01_r8,1.3115e+00_r8,1.9318e+00_r8,2.5084e+00_r8,3.0076e+00_r8, &
     &3.3449e+00_r8,3.2523e+00_r8,5.0169e+00_r8/)
      kao(:, 2, 1,16) = (/ &
     &1.9945e-01_r8,8.1688e-01_r8,1.6118e+00_r8,2.3741e+00_r8,3.0836e+00_r8,3.6966e+00_r8, &
     &4.1116e+00_r8,3.9980e+00_r8,6.1673e+00_r8/)
      kao(:, 3, 1,16) = (/ &
     &2.2510e-01_r8,1.0070e+00_r8,1.9841e+00_r8,2.9159e+00_r8,3.7748e+00_r8,4.5037e+00_r8, &
     &4.9689e+00_r8,4.7883e+00_r8,7.5495e+00_r8/)
      kao(:, 4, 1,16) = (/ &
     &2.5048e-01_r8,1.2252e+00_r8,2.4140e+00_r8,3.5479e+00_r8,4.5928e+00_r8,5.4806e+00_r8, &
     &6.0471e+00_r8,5.7831e+00_r8,9.1856e+00_r8/)
      kao(:, 5, 1,16) = (/ &
     &2.7413e-01_r8,1.4585e+00_r8,2.8735e+00_r8,4.2233e+00_r8,5.4678e+00_r8,6.4913e+00_r8, &
     &7.1996e+00_r8,6.8835e+00_r8,1.0936e+01_r8/)
      kao(:, 1, 2,16) = (/ &
     &2.5949e-01_r8,7.4073e-01_r8,1.4685e+00_r8,2.1764e+00_r8,2.8509e+00_r8,3.4639e+00_r8, &
     &3.9405e+00_r8,4.0097e+00_r8,5.7017e+00_r8/)
      kao(:, 2, 2,16) = (/ &
     &3.0220e-01_r8,9.2128e-01_r8,1.8172e+00_r8,2.6931e+00_r8,3.5460e+00_r8,4.3080e+00_r8, &
     &4.9007e+00_r8,4.9876e+00_r8,7.0918e+00_r8/)
      kao(:, 3, 2,16) = (/ &
     &3.4341e-01_r8,1.1291e+00_r8,2.2360e+00_r8,3.3088e+00_r8,4.3252e+00_r8,5.2383e+00_r8, &
     &5.9360e+00_r8,6.0318e+00_r8,8.6502e+00_r8/)
      kao(:, 4, 2,16) = (/ &
     &3.8325e-01_r8,1.3874e+00_r8,2.7481e+00_r8,4.0666e+00_r8,5.3159e+00_r8,6.4367e+00_r8, &
     &7.2790e+00_r8,7.3059e+00_r8,1.0632e+01_r8/)
      kao(:, 5, 2,16) = (/ &
     &4.2153e-01_r8,1.6660e+00_r8,3.2992e+00_r8,4.8823e+00_r8,6.3819e+00_r8,7.7290e+00_r8, &
     &8.7410e+00_r8,8.7737e+00_r8,1.2764e+01_r8/)
      kao(:, 1, 3,16) = (/ &
     &5.0644e-01_r8,7.8255e-01_r8,1.5587e+00_r8,2.3239e+00_r8,3.0716e+00_r8,3.7848e+00_r8, &
     &4.4177e+00_r8,4.7740e+00_r8,6.1431e+00_r8/)
      kao(:, 2, 3,16) = (/ &
     &5.9759e-01_r8,9.9169e-01_r8,1.9751e+00_r8,2.9450e+00_r8,3.8926e+00_r8,4.7966e+00_r8, &
     &5.5986e+00_r8,6.0493e+00_r8,7.7852e+00_r8/)
      kao(:, 3, 3,16) = (/ &
     &6.8696e-01_r8,1.2186e+00_r8,2.4265e+00_r8,3.6186e+00_r8,4.7825e+00_r8,5.8630e+00_r8, &
     &6.8786e+00_r8,7.4328e+00_r8,9.5649e+00_r8/)
      kao(:, 4, 3,16) = (/ &
     &7.7291e-01_r8,1.5044e+00_r8,2.9942e+00_r8,4.4622e+00_r8,5.8918e+00_r8,7.2471e+00_r8, &
     &8.4308e+00_r8,9.0321e+00_r8,1.1784e+01_r8/)
      kao(:, 5, 3,16) = (/ &
     &8.5655e-01_r8,1.8308e+00_r8,3.6443e+00_r8,5.4303e+00_r8,7.1696e+00_r8,8.8191e+00_r8, &
     &1.0261e+01_r8,1.0994e+01_r8,1.4339e+01_r8/)
      kao(:, 1, 4,16) = (/ &
     &9.9660e-01_r8,8.7187e-01_r8,1.6058e+00_r8,2.4020e+00_r8,3.1900e+00_r8,3.9596e+00_r8, &
     &4.6884e+00_r8,5.2602e+00_r8,6.3800e+00_r8/)
      kao(:, 2, 4,16) = (/ &
     &1.1909e+00_r8,1.0454e+00_r8,2.0813e+00_r8,3.1135e+00_r8,4.1338e+00_r8,5.1320e+00_r8, &
     &6.0754e+00_r8,6.8176e+00_r8,8.2675e+00_r8/)
      kao(:, 3, 4,16) = (/ &
     &1.3883e+00_r8,1.3053e+00_r8,2.6054e+00_r8,3.8972e+00_r8,5.1746e+00_r8,6.4245e+00_r8, &
     &7.6056e+00_r8,8.5415e+00_r8,1.0349e+01_r8/)
      kao(:, 4, 4,16) = (/ &
     &1.5813e+00_r8,1.6017e+00_r8,3.1965e+00_r8,4.7803e+00_r8,6.3446e+00_r8,7.8728e+00_r8, &
     &9.3118e+00_r8,1.0423e+01_r8,1.2689e+01_r8/)
      kao(:, 5, 4,16) = (/ &
     &1.7666e+00_r8,1.9742e+00_r8,3.9398e+00_r8,5.8918e+00_r8,7.8191e+00_r8,9.6976e+00_r8, &
     &1.1463e+01_r8,1.2804e+01_r8,1.5638e+01_r8/)
      kao(:, 1, 5,16) = (/ &
     &1.7905e+00_r8,1.5668e+00_r8,1.6306e+00_r8,2.4424e+00_r8,3.2499e+00_r8,4.0478e+00_r8, &
     &4.8237e+00_r8,5.5141e+00_r8,6.4998e+00_r8/)
      kao(:, 2, 5,16) = (/ &
     &2.1763e+00_r8,1.9041e+00_r8,2.1658e+00_r8,3.2440e+00_r8,4.3166e+00_r8,5.3771e+00_r8, &
     &6.4071e+00_r8,7.3247e+00_r8,8.6332e+00_r8/)
      kao(:, 3, 5,16) = (/ &
     &2.5702e+00_r8,2.2488e+00_r8,2.7671e+00_r8,4.1446e+00_r8,5.5145e+00_r8,6.8692e+00_r8, &
     &8.1862e+00_r8,9.3584e+00_r8,1.1029e+01_r8/)
      kao(:, 4, 5,16) = (/ &
     &2.9652e+00_r8,2.5941e+00_r8,3.4291e+00_r8,5.1370e+00_r8,6.8346e+00_r8,8.5115e+00_r8, &
     &1.0142e+01_r8,1.1590e+01_r8,1.3669e+01_r8/)
      kao(:, 5, 5,16) = (/ &
     &3.3442e+00_r8,2.9260e+00_r8,4.2225e+00_r8,6.3231e+00_r8,8.4117e+00_r8,1.0473e+01_r8, &
     &1.2473e+01_r8,1.4226e+01_r8,1.6823e+01_r8/)
      kao(:, 1, 6,16) = (/ &
     &2.9659e+00_r8,2.5957e+00_r8,2.2251e+00_r8,2.4192e+00_r8,3.2212e+00_r8,4.0191e+00_r8, &
     &4.8055e+00_r8,5.5432e+00_r8,6.4424e+00_r8/)
      kao(:, 2, 6,16) = (/ &
     &3.6832e+00_r8,3.2223e+00_r8,2.7616e+00_r8,3.3057e+00_r8,4.4026e+00_r8,5.4931e+00_r8, &
     &6.5666e+00_r8,7.5768e+00_r8,8.8051e+00_r8/)
      kao(:, 3, 6,16) = (/ &
     &4.4116e+00_r8,3.8604e+00_r8,3.3096e+00_r8,4.3238e+00_r8,5.7589e+00_r8,7.1852e+00_r8, &
     &8.5905e+00_r8,9.9138e+00_r8,1.1518e+01_r8/)
      kao(:, 4, 6,16) = (/ &
     &5.1628e+00_r8,4.5167e+00_r8,3.8530e+00_r8,5.4598e+00_r8,7.2711e+00_r8,9.0722e+00_r8, &
     &1.0846e+01_r8,1.2515e+01_r8,1.4542e+01_r8/)
      kao(:, 5, 6,16) = (/ &
     &5.8968e+00_r8,5.1602e+00_r8,4.5054e+00_r8,6.7527e+00_r8,8.9935e+00_r8,1.1218e+01_r8, &
     &1.3409e+01_r8,1.5457e+01_r8,1.7987e+01_r8/)
      kao(:, 1, 7,16) = (/ &
     &5.1220e+00_r8,4.4578e+00_r8,3.8412e+00_r8,3.1847e+00_r8,3.1367e+00_r8,3.9170e+00_r8, &
     &4.6915e+00_r8,5.4417e+00_r8,6.2734e+00_r8/)
      kao(:, 2, 7,16) = (/ &
     &6.5146e+00_r8,5.7005e+00_r8,4.8852e+00_r8,4.0720e+00_r8,4.4224e+00_r8,5.5237e+00_r8, &
     &6.6151e+00_r8,7.6744e+00_r8,8.8447e+00_r8/)
      kao(:, 3, 7,16) = (/ &
     &7.9642e+00_r8,6.9679e+00_r8,5.9715e+00_r8,4.9772e+00_r8,5.9352e+00_r8,7.4116e+00_r8, &
     &8.8775e+00_r8,1.0298e+01_r8,1.1870e+01_r8/)
      kao(:, 4, 7,16) = (/ &
     &9.4454e+00_r8,8.2650e+00_r8,7.0847e+00_r8,5.9047e+00_r8,7.6537e+00_r8,9.5584e+00_r8, &
     &1.1448e+01_r8,1.3281e+01_r8,1.5307e+01_r8/)
      kao(:, 5, 7,16) = (/ &
     &1.0942e+01_r8,9.5731e+00_r8,8.2052e+00_r8,7.1985e+00_r8,9.5915e+00_r8,1.1978e+01_r8, &
     &1.4344e+01_r8,1.6634e+01_r8,1.9183e+01_r8/)
      kao(:, 1, 8,16) = (/ &
     &1.0533e+01_r8,9.2146e+00_r8,7.8983e+00_r8,6.5814e+00_r8,5.2661e+00_r8,3.9493e+00_r8, &
     &4.5315e+00_r8,5.2737e+00_r8,6.0497e+00_r8/)
      kao(:, 2, 8,16) = (/ &
     &1.3750e+01_r8,1.2032e+01_r8,1.0313e+01_r8,8.5934e+00_r8,6.8745e+00_r8,5.4846e+00_r8, &
     &6.5763e+00_r8,7.6139e+00_r8,8.7787e+00_r8/)
      kao(:, 3, 8,16) = (/ &
     &1.7175e+01_r8,1.5029e+01_r8,1.2881e+01_r8,1.0735e+01_r8,8.5883e+00_r8,7.5634e+00_r8, &
     &9.0692e+00_r8,1.0555e+01_r8,1.2107e+01_r8/)
      kao(:, 4, 8,16) = (/ &
     &2.0707e+01_r8,1.8120e+01_r8,1.5532e+01_r8,1.2944e+01_r8,1.0356e+01_r8,9.9766e+00_r8, &
     &1.1963e+01_r8,1.3921e+01_r8,1.5970e+01_r8/)
      kao(:, 5, 8,16) = (/ &
     &2.4320e+01_r8,2.1282e+01_r8,1.8238e+01_r8,1.5200e+01_r8,1.2161e+01_r8,1.2723e+01_r8, &
     &1.5254e+01_r8,1.7752e+01_r8,2.0364e+01_r8/)
      kao(:, 1, 9,16) = (/ &
     &4.0363e+01_r8,3.5318e+01_r8,3.0273e+01_r8,2.5227e+01_r8,2.0181e+01_r8,1.5134e+01_r8, &
     &1.0090e+01_r8,5.4212e+00_r8,6.1996e+00_r8/)
      kao(:, 2, 9,16) = (/ &
     &5.4231e+01_r8,4.7444e+01_r8,4.0667e+01_r8,3.3896e+01_r8,2.7114e+01_r8,2.0336e+01_r8, &
     &1.3557e+01_r8,7.4876e+00_r8,8.5638e+00_r8/)
      kao(:, 3, 9,16) = (/ &
     &6.9375e+01_r8,6.0706e+01_r8,5.2030e+01_r8,4.3363e+01_r8,3.4693e+01_r8,2.6019e+01_r8, &
     &1.7346e+01_r8,1.0642e+01_r8,1.2169e+01_r8/)
      kao(:, 4, 9,16) = (/ &
     &8.5364e+01_r8,7.4694e+01_r8,6.4003e+01_r8,5.3349e+01_r8,4.2675e+01_r8,3.2007e+01_r8, &
     &2.1338e+01_r8,1.4379e+01_r8,1.6444e+01_r8/)
      kao(:, 5, 9,16) = (/ &
     &1.0173e+02_r8,8.9011e+01_r8,7.6294e+01_r8,6.3578e+01_r8,5.0858e+01_r8,3.8147e+01_r8, &
     &2.5431e+01_r8,1.8715e+01_r8,2.1406e+01_r8/)
      kao(:, 1,10,16) = (/ &
     &1.7518e+02_r8,1.5326e+02_r8,1.3138e+02_r8,1.0946e+02_r8,8.7589e+01_r8,6.5684e+01_r8, &
     &4.3795e+01_r8,2.1898e+01_r8,6.6096e+00_r8/)
      kao(:, 2,10,16) = (/ &
     &2.4209e+02_r8,2.1181e+02_r8,1.8152e+02_r8,1.5127e+02_r8,1.2102e+02_r8,9.0779e+01_r8, &
     &6.0510e+01_r8,3.0258e+01_r8,8.7477e+00_r8/)
      kao(:, 3,10,16) = (/ &
     &3.1702e+02_r8,2.7739e+02_r8,2.3777e+02_r8,1.9810e+02_r8,1.5849e+02_r8,1.1888e+02_r8, &
     &7.9249e+01_r8,3.9623e+01_r8,1.2377e+01_r8/)
      kao(:, 4,10,16) = (/ &
     &3.9791e+02_r8,3.4817e+02_r8,2.9841e+02_r8,2.4869e+02_r8,1.9896e+02_r8,1.4923e+02_r8, &
     &9.9472e+01_r8,4.9736e+01_r8,1.7102e+01_r8/)
      kao(:, 5,10,16) = (/ &
     &4.8342e+02_r8,4.2295e+02_r8,3.6251e+02_r8,3.0211e+02_r8,2.4169e+02_r8,1.8128e+02_r8, &
     &1.2083e+02_r8,6.0427e+01_r8,2.2752e+01_r8/)
      kao(:, 1,11,16) = (/ &
     &3.1380e+02_r8,2.7453e+02_r8,2.3526e+02_r8,1.9609e+02_r8,1.5686e+02_r8,1.1764e+02_r8, &
     &7.8455e+01_r8,3.9219e+01_r8,4.1702e-05_r8/)
      kao(:, 2,11,16) = (/ &
     &4.3458e+02_r8,3.8032e+02_r8,3.2596e+02_r8,2.7165e+02_r8,2.1736e+02_r8,1.6300e+02_r8, &
     &1.0866e+02_r8,5.4331e+01_r8,1.0603e+01_r8/)
      kao(:, 3,11,16) = (/ &
     &5.7279e+02_r8,5.0121e+02_r8,4.2963e+02_r8,3.5802e+02_r8,2.8639e+02_r8,2.1479e+02_r8, &
     &1.4321e+02_r8,7.1606e+01_r8,1.4737e+01_r8/)
      kao(:, 4,11,16) = (/ &
     &7.2603e+02_r8,6.3199e+02_r8,5.4450e+02_r8,4.5379e+02_r8,3.6299e+02_r8,2.7226e+02_r8, &
     &1.8150e+02_r8,9.0755e+01_r8,2.0418e+01_r8/)
      kao(:, 5,11,16) = (/ &
     &8.9810e+02_r8,7.8584e+02_r8,6.7355e+02_r8,5.6126e+02_r8,4.4901e+02_r8,3.3674e+02_r8, &
     &2.2451e+02_r8,1.1225e+02_r8,2.7345e+01_r8/)
      kao(:, 1,12,16) = (/ &
     &4.2564e+02_r8,3.7252e+02_r8,3.1927e+02_r8,2.6605e+02_r8,2.1287e+02_r8,1.5962e+02_r8, &
     &1.0643e+02_r8,5.3212e+01_r8,3.3974e-05_r8/)
      kao(:, 2,12,16) = (/ &
     &5.9696e+02_r8,5.2232e+02_r8,4.4774e+02_r8,3.7307e+02_r8,2.9847e+02_r8,2.2385e+02_r8, &
     &1.4924e+02_r8,7.4619e+01_r8,1.2841e+01_r8/)
      kao(:, 3,12,16) = (/ &
     &8.0130e+02_r8,7.0109e+02_r8,6.0095e+02_r8,5.0082e+02_r8,4.0064e+02_r8,3.0049e+02_r8, &
     &2.0030e+02_r8,1.0016e+02_r8,1.7604e+01_r8/)
      kao(:, 4,12,16) = (/ &
     &1.0424e+03_r8,9.1209e+02_r8,7.8186e+02_r8,6.5151e+02_r8,5.2121e+02_r8,3.9092e+02_r8, &
     &2.6059e+02_r8,1.3030e+02_r8,2.4408e+01_r8/)
      kao(:, 5,12,16) = (/ &
     &1.3107e+03_r8,1.1467e+03_r8,9.8296e+02_r8,8.1915e+02_r8,6.5538e+02_r8,4.9148e+02_r8, &
     &3.2766e+02_r8,1.6385e+02_r8,3.2853e+01_r8/)
      kao(:, 1,13,16) = (/ &
     &4.8122e+02_r8,4.2105e+02_r8,3.6087e+02_r8,3.0076e+02_r8,2.4060e+02_r8,1.8046e+02_r8, &
     &1.2030e+02_r8,6.0148e+01_r8,7.3993e+00_r8/)
      kao(:, 2,13,16) = (/ &
     &6.9206e+02_r8,6.0557e+02_r8,5.1907e+02_r8,4.3255e+02_r8,3.4603e+02_r8,2.5955e+02_r8, &
     &1.7302e+02_r8,8.6508e+01_r8,1.5501e+01_r8/)
      kao(:, 3,13,16) = (/ &
     &9.4703e+02_r8,8.2867e+02_r8,7.1030e+02_r8,5.9189e+02_r8,4.7354e+02_r8,3.5512e+02_r8, &
     &2.3675e+02_r8,1.1838e+02_r8,2.1029e+01_r8/)
      kao(:, 4,13,16) = (/ &
     &1.2338e+03_r8,1.0854e+03_r8,9.3026e+02_r8,7.7526e+02_r8,6.2018e+02_r8,4.6513e+02_r8, &
     &3.1009e+02_r8,1.5423e+02_r8,2.9122e+01_r8/)
      kao(:, 5,13,16) = (/ &
     &1.5695e+03_r8,1.3734e+03_r8,1.1772e+03_r8,9.8104e+02_r8,7.8484e+02_r8,5.8860e+02_r8, &
     &3.9240e+02_r8,1.9620e+02_r8,3.9289e+01_r8/)

!     The array KAO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels > ~100mb, temperatures, and ratios
!     of water vapor to CO2.  The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amount ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 
!     to that of gas2.
!     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
!     to different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this  pressure 
!     level, JT = 2 refers to the temperature
!     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the reference pressure level (e.g. JP = 1 is for a
!     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

      kbo(:, 1,13, 1) = (/ &
     &9.4796e-05_r8,1.4361e-04_r8,1.4118e-04_r8,1.1819e-04_r8,7.6303e-05_r8/)
      kbo(:, 2,13, 1) = (/ &
     &9.7387e-05_r8,1.7115e-04_r8,1.7300e-04_r8,1.4824e-04_r8,1.0469e-04_r8/)
      kbo(:, 3,13, 1) = (/ &
     &1.0951e-04_r8,2.1604e-04_r8,2.2323e-04_r8,1.9350e-04_r8,1.3818e-04_r8/)
      kbo(:, 4,13, 1) = (/ &
     &1.3449e-04_r8,2.8552e-04_r8,2.9728e-04_r8,2.5764e-04_r8,1.7597e-04_r8/)
      kbo(:, 5,13, 1) = (/ &
     &1.7577e-04_r8,3.8714e-04_r8,4.0359e-04_r8,3.4654e-04_r8,2.1851e-04_r8/)
      kbo(:, 1,14, 1) = (/ &
     &7.9000e-05_r8,1.2113e-04_r8,1.1920e-04_r8,9.9664e-05_r8,6.3646e-05_r8/)
      kbo(:, 2,14, 1) = (/ &
     &8.1870e-05_r8,1.4526e-04_r8,1.4705e-04_r8,1.2557e-04_r8,8.6376e-05_r8/)
      kbo(:, 3,14, 1) = (/ &
     &9.2975e-05_r8,1.8451e-04_r8,1.9063e-04_r8,1.6489e-04_r8,1.1348e-04_r8/)
      kbo(:, 4,14, 1) = (/ &
     &1.1499e-04_r8,2.4478e-04_r8,2.5460e-04_r8,2.2031e-04_r8,1.4451e-04_r8/)
      kbo(:, 5,14, 1) = (/ &
     &1.5077e-04_r8,3.3228e-04_r8,3.4580e-04_r8,2.9716e-04_r8,1.7798e-04_r8/)
      kbo(:, 1,15, 1) = (/ &
     &6.3146e-05_r8,9.9373e-05_r8,9.8373e-05_r8,8.2691e-05_r8,5.2397e-05_r8/)
      kbo(:, 2,15, 1) = (/ &
     &6.6078e-05_r8,1.2006e-04_r8,1.2228e-04_r8,1.0469e-04_r8,7.0411e-05_r8/)
      kbo(:, 3,15, 1) = (/ &
     &7.5821e-05_r8,1.5360e-04_r8,1.5869e-04_r8,1.3814e-04_r8,9.1603e-05_r8/)
      kbo(:, 4,15, 1) = (/ &
     &9.4372e-05_r8,2.0448e-04_r8,2.1279e-04_r8,1.8521e-04_r8,1.1587e-04_r8/)
      kbo(:, 5,15, 1) = (/ &
     &1.2416e-04_r8,2.7753e-04_r8,2.8967e-04_r8,2.5010e-04_r8,1.4409e-04_r8/)
      kbo(:, 1,16, 1) = (/ &
     &4.9335e-05_r8,8.0237e-05_r8,8.0247e-05_r8,6.8036e-05_r8,4.2623e-05_r8/)
      kbo(:, 2,16, 1) = (/ &
     &5.2173e-05_r8,9.7834e-05_r8,1.0022e-04_r8,8.6725e-05_r8,5.7211e-05_r8/)
      kbo(:, 3,16, 1) = (/ &
     &6.0461e-05_r8,1.2605e-04_r8,1.3061e-04_r8,1.1470e-04_r8,7.4324e-05_r8/)
      kbo(:, 4,16, 1) = (/ &
     &7.5694e-05_r8,1.6827e-04_r8,1.7572e-04_r8,1.5404e-04_r8,9.3686e-05_r8/)
      kbo(:, 5,16, 1) = (/ &
     &9.9955e-05_r8,2.2866e-04_r8,2.3956e-04_r8,2.0826e-04_r8,1.1548e-04_r8/)
      kbo(:, 1,17, 1) = (/ &
     &3.8266e-05_r8,6.4449e-05_r8,6.5172e-05_r8,5.5789e-05_r8,3.5130e-05_r8/)
      kbo(:, 2,17, 1) = (/ &
     &4.0895e-05_r8,7.9297e-05_r8,8.1758e-05_r8,7.1548e-05_r8,4.6781e-05_r8/)
      kbo(:, 3,17, 1) = (/ &
     &4.7807e-05_r8,1.0278e-04_r8,1.0697e-04_r8,9.4840e-05_r8,6.0133e-05_r8/)
      kbo(:, 4,17, 1) = (/ &
     &6.0159e-05_r8,1.3765e-04_r8,1.4446e-04_r8,1.2759e-04_r8,7.5139e-05_r8/)
      kbo(:, 5,17, 1) = (/ &
     &7.9747e-05_r8,1.8704e-04_r8,1.9692e-04_r8,1.7259e-04_r8,9.1648e-05_r8/)
      kbo(:, 1,18, 1) = (/ &
     &2.9184e-05_r8,5.1211e-05_r8,5.2362e-05_r8,4.5451e-05_r8,2.8937e-05_r8/)
      kbo(:, 2,18, 1) = (/ &
     &3.1502e-05_r8,6.3605e-05_r8,6.6096e-05_r8,5.8591e-05_r8,3.8202e-05_r8/)
      kbo(:, 3,18, 1) = (/ &
     &3.7129e-05_r8,8.2865e-05_r8,8.6932e-05_r8,7.7931e-05_r8,4.8777e-05_r8/)
      kbo(:, 4,18, 1) = (/ &
     &4.6953e-05_r8,1.1128e-04_r8,1.1763e-04_r8,1.0496e-04_r8,6.0806e-05_r8/)
      kbo(:, 5,18, 1) = (/ &
     &6.2502e-05_r8,1.5129e-04_r8,1.6025e-04_r8,1.4184e-04_r8,7.4536e-05_r8/)
      kbo(:, 1,19, 1) = (/ &
     &2.2672e-05_r8,4.1242e-05_r8,4.2527e-05_r8,3.7342e-05_r8,2.3934e-05_r8/)
      kbo(:, 2,19, 1) = (/ &
     &2.4699e-05_r8,5.1600e-05_r8,5.3953e-05_r8,4.8350e-05_r8,3.1473e-05_r8/)
      kbo(:, 3,19, 1) = (/ &
     &2.9334e-05_r8,6.7547e-05_r8,7.1294e-05_r8,6.4461e-05_r8,4.0025e-05_r8/)
      kbo(:, 4,19, 1) = (/ &
     &3.7286e-05_r8,9.0838e-05_r8,9.6625e-05_r8,8.6862e-05_r8,4.9869e-05_r8/)
      kbo(:, 5,19, 1) = (/ &
     &4.9822e-05_r8,1.2352e-04_r8,1.3152e-04_r8,1.1713e-04_r8,6.1219e-05_r8/)
      kbo(:, 1,20, 1) = (/ &
     &1.8003e-05_r8,3.3802e-05_r8,3.5042e-05_r8,3.1068e-05_r8,2.0074e-05_r8/)
      kbo(:, 2,20, 1) = (/ &
     &1.9811e-05_r8,4.2600e-05_r8,4.4765e-05_r8,4.0426e-05_r8,2.6188e-05_r8/)
      kbo(:, 3,20, 1) = (/ &
     &2.3740e-05_r8,5.5990e-05_r8,5.9400e-05_r8,5.4019e-05_r8,3.3275e-05_r8/)
      kbo(:, 4,20, 1) = (/ &
     &3.0362e-05_r8,7.5435e-05_r8,8.0630e-05_r8,7.2808e-05_r8,4.1380e-05_r8/)
      kbo(:, 5,20, 1) = (/ &
     &4.0743e-05_r8,1.0263e-04_r8,1.0963e-04_r8,9.7998e-05_r8,5.0442e-05_r8/)
      kbo(:, 1,21, 1) = (/ &
     &1.4410e-05_r8,2.7872e-05_r8,2.9027e-05_r8,2.5943e-05_r8,1.6820e-05_r8/)
      kbo(:, 2,21, 1) = (/ &
     &1.6018e-05_r8,3.5348e-05_r8,3.7320e-05_r8,3.3900e-05_r8,2.1893e-05_r8/)
      kbo(:, 3,21, 1) = (/ &
     &1.9364e-05_r8,4.6630e-05_r8,4.9701e-05_r8,4.5376e-05_r8,2.7723e-05_r8/)
      kbo(:, 4,21, 1) = (/ &
     &2.4923e-05_r8,6.2936e-05_r8,6.7505e-05_r8,6.1129e-05_r8,3.4253e-05_r8/)
      kbo(:, 5,21, 1) = (/ &
     &3.3581e-05_r8,8.5657e-05_r8,9.1740e-05_r8,8.2183e-05_r8,4.1502e-05_r8/)
      kbo(:, 1,22, 1) = (/ &
     &1.1606e-05_r8,2.3345e-05_r8,2.4458e-05_r8,2.2044e-05_r8,1.4341e-05_r8/)
      kbo(:, 2,22, 1) = (/ &
     &1.3108e-05_r8,2.9860e-05_r8,3.1703e-05_r8,2.8973e-05_r8,1.8544e-05_r8/)
      kbo(:, 3,22, 1) = (/ &
     &1.6058e-05_r8,3.9598e-05_r8,4.2399e-05_r8,3.8843e-05_r8,2.3272e-05_r8/)
      kbo(:, 4,22, 1) = (/ &
     &2.0871e-05_r8,5.3592e-05_r8,5.7668e-05_r8,5.2303e-05_r8,2.8594e-05_r8/)
      kbo(:, 5,22, 1) = (/ &
     &2.8287e-05_r8,7.2910e-05_r8,7.8274e-05_r8,7.0191e-05_r8,3.4495e-05_r8/)
      kbo(:, 1,23, 1) = (/ &
     &9.3973e-06_r8,1.9636e-05_r8,2.0704e-05_r8,1.8793e-05_r8,1.2204e-05_r8/)
      kbo(:, 2,23, 1) = (/ &
     &1.0787e-05_r8,2.5322e-05_r8,2.7025e-05_r8,2.4831e-05_r8,1.5654e-05_r8/)
      kbo(:, 3,23, 1) = (/ &
     &1.3385e-05_r8,3.3729e-05_r8,3.6290e-05_r8,3.3307e-05_r8,1.9609e-05_r8/)
      kbo(:, 4,23, 1) = (/ &
     &1.7566e-05_r8,4.5745e-05_r8,4.9368e-05_r8,4.4833e-05_r8,2.3893e-05_r8/)
      kbo(:, 5,23, 1) = (/ &
     &2.3931e-05_r8,6.2215e-05_r8,6.6919e-05_r8,6.0045e-05_r8,2.8668e-05_r8/)
      kbo(:, 1,24, 1) = (/ &
     &7.7170e-06_r8,1.6679e-05_r8,1.7685e-05_r8,1.6128e-05_r8,1.0358e-05_r8/)
      kbo(:, 2,24, 1) = (/ &
     &9.0120e-06_r8,2.1659e-05_r8,2.3221e-05_r8,2.1395e-05_r8,1.3206e-05_r8/)
      kbo(:, 3,24, 1) = (/ &
     &1.1319e-05_r8,2.8989e-05_r8,3.1289e-05_r8,2.8717e-05_r8,1.6361e-05_r8/)
      kbo(:, 4,24, 1) = (/ &
     &1.4992e-05_r8,3.9385e-05_r8,4.2555e-05_r8,3.8633e-05_r8,1.9891e-05_r8/)
      kbo(:, 5,24, 1) = (/ &
     &2.0520e-05_r8,5.3479e-05_r8,5.7600e-05_r8,5.1654e-05_r8,2.3746e-05_r8/)
      kbo(:, 1,25, 1) = (/ &
     &6.3838e-06_r8,1.4248e-05_r8,1.5168e-05_r8,1.3906e-05_r8,8.8251e-06_r8/)
      kbo(:, 2,25, 1) = (/ &
     &7.5878e-06_r8,1.8635e-05_r8,2.0050e-05_r8,1.8513e-05_r8,1.1119e-05_r8/)
      kbo(:, 3,25, 1) = (/ &
     &9.6475e-06_r8,2.5052e-05_r8,2.7110e-05_r8,2.4846e-05_r8,1.3734e-05_r8/)
      kbo(:, 4,25, 1) = (/ &
     &1.2889e-05_r8,3.4075e-05_r8,3.6834e-05_r8,3.3385e-05_r8,1.6609e-05_r8/)
      kbo(:, 5,25, 1) = (/ &
     &1.7706e-05_r8,4.6181e-05_r8,4.9751e-05_r8,4.4544e-05_r8,1.9735e-05_r8/)
      kbo(:, 1,26, 1) = (/ &
     &5.3393e-06_r8,1.2288e-05_r8,1.3132e-05_r8,1.2096e-05_r8,7.5264e-06_r8/)
      kbo(:, 2,26, 1) = (/ &
     &6.4609e-06_r8,1.6189e-05_r8,1.7467e-05_r8,1.6131e-05_r8,9.4332e-06_r8/)
      kbo(:, 3,26, 1) = (/ &
     &8.3200e-06_r8,2.1853e-05_r8,2.3681e-05_r8,2.1653e-05_r8,1.1593e-05_r8/)
      kbo(:, 4,26, 1) = (/ &
     &1.1209e-05_r8,2.9737e-05_r8,3.2133e-05_r8,2.9046e-05_r8,1.3941e-05_r8/)
      kbo(:, 5,26, 1) = (/ &
     &1.5443e-05_r8,4.0196e-05_r8,4.3302e-05_r8,3.8639e-05_r8,1.6481e-05_r8/)
      kbo(:, 1,27, 1) = (/ &
     &4.5029e-06_r8,1.0646e-05_r8,1.1429e-05_r8,1.0549e-05_r8,6.4263e-06_r8/)
      kbo(:, 2,27, 1) = (/ &
     &5.5408e-06_r8,1.4124e-05_r8,1.5272e-05_r8,1.4080e-05_r8,8.0128e-06_r8/)
      kbo(:, 3,27, 1) = (/ &
     &7.2235e-06_r8,1.9128e-05_r8,2.0734e-05_r8,1.8902e-05_r8,9.7874e-06_r8/)
      kbo(:, 4,27, 1) = (/ &
     &9.8044e-06_r8,2.6022e-05_r8,2.8102e-05_r8,2.5321e-05_r8,1.1642e-05_r8/)
      kbo(:, 5,27, 1) = (/ &
     &1.3531e-05_r8,3.5058e-05_r8,3.7762e-05_r8,3.3580e-05_r8,1.3712e-05_r8/)
      kbo(:, 1,28, 1) = (/ &
     &3.8267e-06_r8,9.2605e-06_r8,9.9753e-06_r8,9.2087e-06_r8,5.4910e-06_r8/)
      kbo(:, 2,28, 1) = (/ &
     &4.7813e-06_r8,1.2361e-05_r8,1.3381e-05_r8,1.2301e-05_r8,6.7809e-06_r8/)
      kbo(:, 3,28, 1) = (/ &
     &6.3052e-06_r8,1.6784e-05_r8,1.8184e-05_r8,1.6520e-05_r8,8.1872e-06_r8/)
      kbo(:, 4,28, 1) = (/ &
     &8.6092e-06_r8,2.2800e-05_r8,2.4603e-05_r8,2.2078e-05_r8,9.6541e-06_r8/)
      kbo(:, 5,28, 1) = (/ &
     &1.1891e-05_r8,3.0613e-05_r8,3.2964e-05_r8,2.9199e-05_r8,1.1371e-05_r8/)
      kbo(:, 1,29, 1) = (/ &
     &3.2554e-06_r8,8.0646e-06_r8,8.7115e-06_r8,8.0443e-06_r8,4.6597e-06_r8/)
      kbo(:, 2,29, 1) = (/ &
     &4.1267e-06_r8,1.0826e-05_r8,1.1737e-05_r8,1.0754e-05_r8,5.7169e-06_r8/)
      kbo(:, 3,29, 1) = (/ &
     &5.4998e-06_r8,1.4722e-05_r8,1.5944e-05_r8,1.4441e-05_r8,6.8326e-06_r8/)
      kbo(:, 4,29, 1) = (/ &
     &7.5454e-06_r8,1.9957e-05_r8,2.1533e-05_r8,1.9256e-05_r8,8.0674e-06_r8/)
      kbo(:, 5,29, 1) = (/ &
     &1.0421e-05_r8,2.6692e-05_r8,2.8752e-05_r8,2.5378e-05_r8,9.4635e-06_r8/)
      kbo(:, 1,30, 1) = (/ &
     &2.7722e-06_r8,7.0257e-06_r8,7.6070e-06_r8,7.0209e-06_r8,3.9148e-06_r8/)
      kbo(:, 2,30, 1) = (/ &
     &3.5629e-06_r8,9.4753e-06_r8,1.0287e-05_r8,9.3951e-06_r8,4.7641e-06_r8/)
      kbo(:, 3,30, 1) = (/ &
     &4.7932e-06_r8,1.2893e-05_r8,1.3959e-05_r8,1.2600e-05_r8,5.6708e-06_r8/)
      kbo(:, 4,30, 1) = (/ &
     &6.5982e-06_r8,1.7431e-05_r8,1.8810e-05_r8,1.6759e-05_r8,6.6902e-06_r8/)
      kbo(:, 5,30, 1) = (/ &
     &9.1066e-06_r8,2.3231e-05_r8,2.5041e-05_r8,2.2031e-05_r8,7.8394e-06_r8/)
      kbo(:, 1,31, 1) = (/ &
     &2.3506e-06_r8,6.1052e-06_r8,6.6305e-06_r8,6.1196e-06_r8,3.2861e-06_r8/)
      kbo(:, 2,31, 1) = (/ &
     &3.0616e-06_r8,8.2670e-06_r8,8.9874e-06_r8,8.1933e-06_r8,3.9690e-06_r8/)
      kbo(:, 3,31, 1) = (/ &
     &4.1518e-06_r8,1.1245e-05_r8,1.2180e-05_r8,1.0973e-05_r8,4.7077e-06_r8/)
      kbo(:, 4,31, 1) = (/ &
     &5.7278e-06_r8,1.5154e-05_r8,1.6366e-05_r8,1.4549e-05_r8,5.5398e-06_r8/)
      kbo(:, 5,31, 1) = (/ &
     &7.8906e-06_r8,2.0109e-05_r8,2.1708e-05_r8,1.9053e-05_r8,6.4566e-06_r8/)
      kbo(:, 1,32, 1) = (/ &
     &2.0097e-06_r8,5.3323e-06_r8,5.8021e-06_r8,5.3502e-06_r8,2.7241e-06_r8/)
      kbo(:, 2,32, 1) = (/ &
     &2.6508e-06_r8,7.2383e-06_r8,7.8773e-06_r8,7.1648e-06_r8,3.2755e-06_r8/)
      kbo(:, 3,32, 1) = (/ &
     &3.6184e-06_r8,9.8348e-06_r8,1.0656e-05_r8,9.5737e-06_r8,3.8774e-06_r8/)
      kbo(:, 4,32, 1) = (/ &
     &4.9951e-06_r8,1.3205e-05_r8,1.4271e-05_r8,1.2656e-05_r8,4.5194e-06_r8/)
      kbo(:, 5,32, 1) = (/ &
     &6.8654e-06_r8,1.7445e-05_r8,1.8860e-05_r8,1.6511e-05_r8,5.2597e-06_r8/)
      kbo(:, 1,33, 1) = (/ &
     &1.7307e-06_r8,4.6719e-06_r8,5.0926e-06_r8,4.6864e-06_r8,2.2504e-06_r8/)
      kbo(:, 2,33, 1) = (/ &
     &2.3079e-06_r8,6.3540e-06_r8,6.9152e-06_r8,6.2764e-06_r8,2.6926e-06_r8/)
      kbo(:, 3,33, 1) = (/ &
     &3.1665e-06_r8,8.6147e-06_r8,9.3343e-06_r8,8.3614e-06_r8,3.1814e-06_r8/)
      kbo(:, 4,33, 1) = (/ &
     &4.3731e-06_r8,1.1528e-05_r8,1.2464e-05_r8,1.1023e-05_r8,3.7164e-06_r8/)
      kbo(:, 5,33, 1) = (/ &
     &5.9878e-06_r8,1.5151e-05_r8,1.6400e-05_r8,1.4316e-05_r8,4.2974e-06_r8/)
      kbo(:, 1,34, 1) = (/ &
     &1.4981e-06_r8,4.0834e-06_r8,4.4531e-06_r8,4.0843e-06_r8,1.8539e-06_r8/)
      kbo(:, 2,34, 1) = (/ &
     &2.0150e-06_r8,5.5569e-06_r8,6.0419e-06_r8,5.4716e-06_r8,2.2285e-06_r8/)
      kbo(:, 3,34, 1) = (/ &
     &2.7725e-06_r8,7.5151e-06_r8,8.1387e-06_r8,7.2690e-06_r8,2.6334e-06_r8/)
      kbo(:, 4,34, 1) = (/ &
     &3.8256e-06_r8,1.0019e-05_r8,1.0836e-05_r8,9.5549e-06_r8,3.0709e-06_r8/)
      kbo(:, 5,34, 1) = (/ &
     &5.2217e-06_r8,1.3116e-05_r8,1.4207e-05_r8,1.2368e-05_r8,3.5492e-06_r8/)
      kbo(:, 1,35, 1) = (/ &
     &1.2683e-06_r8,3.4717e-06_r8,3.7843e-06_r8,3.4639e-06_r8,1.5033e-06_r8/)
      kbo(:, 2,35, 1) = (/ &
     &1.7130e-06_r8,4.7242e-06_r8,5.1321e-06_r8,4.6386e-06_r8,1.8045e-06_r8/)
      kbo(:, 3,35, 1) = (/ &
     &2.3598e-06_r8,6.3794e-06_r8,6.9043e-06_r8,6.1552e-06_r8,2.1312e-06_r8/)
      kbo(:, 4,35, 1) = (/ &
     &3.2533e-06_r8,8.4861e-06_r8,9.1773e-06_r8,8.0771e-06_r8,2.4797e-06_r8/)
      kbo(:, 5,35, 1) = (/ &
     &4.4317e-06_r8,1.1084e-05_r8,1.2009e-05_r8,1.0436e-05_r8,2.8460e-06_r8/)
      kbo(:, 1,36, 1) = (/ &
     &1.0446e-06_r8,2.8596e-06_r8,3.1142e-06_r8,2.8488e-06_r8,1.1841e-06_r8/)
      kbo(:, 2,36, 1) = (/ &
     &1.4115e-06_r8,3.8911e-06_r8,4.2236e-06_r8,3.8148e-06_r8,1.4188e-06_r8/)
      kbo(:, 3,36, 1) = (/ &
     &1.9447e-06_r8,5.2529e-06_r8,5.6822e-06_r8,5.0612e-06_r8,1.6763e-06_r8/)
      kbo(:, 4,36, 1) = (/ &
     &2.6806e-06_r8,6.9854e-06_r8,7.5506e-06_r8,6.6402e-06_r8,1.9492e-06_r8/)
      kbo(:, 5,36, 1) = (/ &
     &3.6503e-06_r8,9.1210e-06_r8,9.8800e-06_r8,8.5784e-06_r8,2.2478e-06_r8/)
      kbo(:, 1,37, 1) = (/ &
     &8.3141e-07_r8,2.2606e-06_r8,2.4589e-06_r8,2.2521e-06_r8,9.1953e-07_r8/)
      kbo(:, 2,37, 1) = (/ &
     &1.1186e-06_r8,3.0759e-06_r8,3.3374e-06_r8,3.0170e-06_r8,1.1075e-06_r8/)
      kbo(:, 3,37, 1) = (/ &
     &1.5392e-06_r8,4.1590e-06_r8,4.4972e-06_r8,4.0085e-06_r8,1.3109e-06_r8/)
      kbo(:, 4,37, 1) = (/ &
     &2.1232e-06_r8,5.5433e-06_r8,5.9872e-06_r8,5.2697e-06_r8,1.5318e-06_r8/)
      kbo(:, 5,37, 1) = (/ &
     &2.8971e-06_r8,7.2549e-06_r8,7.8520e-06_r8,6.8216e-06_r8,1.7720e-06_r8/)
      kbo(:, 1,38, 1) = (/ &
     &6.6100e-07_r8,1.7834e-06_r8,1.9371e-06_r8,1.7763e-06_r8,7.1225e-07_r8/)
      kbo(:, 2,38, 1) = (/ &
     &8.8499e-07_r8,2.4255e-06_r8,2.6307e-06_r8,2.3793e-06_r8,8.6302e-07_r8/)
      kbo(:, 3,38, 1) = (/ &
     &1.2155e-06_r8,3.2848e-06_r8,3.5503e-06_r8,3.1675e-06_r8,1.0267e-06_r8/)
      kbo(:, 4,38, 1) = (/ &
     &1.6779e-06_r8,4.3885e-06_r8,4.7364e-06_r8,4.1721e-06_r8,1.2041e-06_r8/)
      kbo(:, 5,38, 1) = (/ &
     &2.2938e-06_r8,5.7578e-06_r8,6.2256e-06_r8,5.4129e-06_r8,1.3941e-06_r8/)
      kbo(:, 1,39, 1) = (/ &
     &5.2622e-07_r8,1.4074e-06_r8,1.5268e-06_r8,1.4013e-06_r8,5.4821e-07_r8/)
      kbo(:, 2,39, 1) = (/ &
     &7.0069e-07_r8,1.9130e-06_r8,2.0737e-06_r8,1.8765e-06_r8,6.6832e-07_r8/)
      kbo(:, 3,39, 1) = (/ &
     &9.6029e-07_r8,2.5942e-06_r8,2.8023e-06_r8,2.5024e-06_r8,8.0073e-07_r8/)
      kbo(:, 4,39, 1) = (/ &
     &1.3259e-06_r8,3.4737e-06_r8,3.7464e-06_r8,3.3022e-06_r8,9.3841e-07_r8/)
      kbo(:, 5,39, 1) = (/ &
     &1.8162e-06_r8,4.5691e-06_r8,4.9354e-06_r8,4.2944e-06_r8,1.0896e-06_r8/)
      kbo(:, 1,40, 1) = (/ &
     &4.1271e-07_r8,1.0842e-06_r8,1.1736e-06_r8,1.0777e-06_r8,4.1787e-07_r8/)
      kbo(:, 2,40, 1) = (/ &
     &5.4389e-07_r8,1.4709e-06_r8,1.5926e-06_r8,1.4421e-06_r8,5.1017e-07_r8/)
      kbo(:, 3,40, 1) = (/ &
     &7.4188e-07_r8,1.9982e-06_r8,2.1561e-06_r8,1.9284e-06_r8,6.1575e-07_r8/)
      kbo(:, 4,40, 1) = (/ &
     &1.0242e-06_r8,2.6854e-06_r8,2.8924e-06_r8,2.5529e-06_r8,7.2613e-07_r8/)
      kbo(:, 5,40, 1) = (/ &
     &1.4067e-06_r8,3.5476e-06_r8,3.8249e-06_r8,3.3331e-06_r8,8.4610e-07_r8/)
      kbo(:, 1,41, 1) = (/ &
     &3.2432e-07_r8,8.3392e-07_r8,9.0025e-07_r8,8.2659e-07_r8,3.1699e-07_r8/)
      kbo(:, 2,41, 1) = (/ &
     &4.2215e-07_r8,1.1277e-06_r8,1.2186e-06_r8,1.1049e-06_r8,3.8959e-07_r8/)
      kbo(:, 3,41, 1) = (/ &
     &5.7203e-07_r8,1.5335e-06_r8,1.6530e-06_r8,1.4808e-06_r8,4.7229e-07_r8/)
      kbo(:, 4,41, 1) = (/ &
     &7.8892e-07_r8,2.0682e-06_r8,2.2251e-06_r8,1.9663e-06_r8,5.6019e-07_r8/)
      kbo(:, 5,41, 1) = (/ &
     &1.0862e-06_r8,2.7447e-06_r8,2.9535e-06_r8,2.5776e-06_r8,6.5591e-07_r8/)
      kbo(:, 1,42, 1) = (/ &
     &2.5587e-07_r8,6.4253e-07_r8,6.9167e-07_r8,6.3420e-07_r8,2.3952e-07_r8/)
      kbo(:, 2,42, 1) = (/ &
     &3.2863e-07_r8,8.6497e-07_r8,9.3264e-07_r8,8.4649e-07_r8,2.9775e-07_r8/)
      kbo(:, 3,42, 1) = (/ &
     &4.4164e-07_r8,1.1761e-06_r8,1.2667e-06_r8,1.1361e-06_r8,3.6120e-07_r8/)
      kbo(:, 4,42, 1) = (/ &
     &6.0774e-07_r8,1.5914e-06_r8,1.7100e-06_r8,1.5131e-06_r8,4.3157e-07_r8/)
      kbo(:, 5,42, 1) = (/ &
     &8.3802e-07_r8,2.1211e-06_r8,2.2785e-06_r8,1.9912e-06_r8,5.0721e-07_r8/)
      kbo(:, 1,43, 1) = (/ &
     &2.0233e-07_r8,4.9120e-07_r8,5.2639e-07_r8,4.8089e-07_r8,1.7965e-07_r8/)
      kbo(:, 2,43, 1) = (/ &
     &2.5538e-07_r8,6.5692e-07_r8,7.0547e-07_r8,6.4075e-07_r8,2.2496e-07_r8/)
      kbo(:, 3,43, 1) = (/ &
     &3.3917e-07_r8,8.9179e-07_r8,9.5869e-07_r8,8.5986e-07_r8,2.7469e-07_r8/)
      kbo(:, 4,43, 1) = (/ &
     &4.6446e-07_r8,1.2101e-06_r8,1.2978e-06_r8,1.1498e-06_r8,3.3044e-07_r8/)
      kbo(:, 5,43, 1) = (/ &
     &6.4112e-07_r8,1.6212e-06_r8,1.7373e-06_r8,1.5201e-06_r8,3.9028e-07_r8/)
      kbo(:, 1,44, 1) = (/ &
     &1.6122e-07_r8,3.7551e-07_r8,3.9960e-07_r8,3.6377e-07_r8,1.3351e-07_r8/)
      kbo(:, 2,44, 1) = (/ &
     &1.9938e-07_r8,4.9773e-07_r8,5.3195e-07_r8,4.8258e-07_r8,1.6857e-07_r8/)
      kbo(:, 3,44, 1) = (/ &
     &2.6075e-07_r8,6.7334e-07_r8,7.2162e-07_r8,6.4719e-07_r8,2.0768e-07_r8/)
      kbo(:, 4,44, 1) = (/ &
     &3.5440e-07_r8,9.1528e-07_r8,9.7926e-07_r8,8.6831e-07_r8,2.5128e-07_r8/)
      kbo(:, 5,44, 1) = (/ &
     &4.8882e-07_r8,1.2321e-06_r8,1.3171e-06_r8,1.1536e-06_r8,2.9843e-07_r8/)
      kbo(:, 1,45, 1) = (/ &
     &1.2988e-07_r8,2.8870e-07_r8,3.0532e-07_r8,2.7582e-07_r8,9.8684e-08_r8/)
      kbo(:, 2,45, 1) = (/ &
     &1.5689e-07_r8,3.7846e-07_r8,4.0235e-07_r8,3.6402e-07_r8,1.2561e-07_r8/)
      kbo(:, 3,45, 1) = (/ &
     &2.0165e-07_r8,5.0920e-07_r8,5.4343e-07_r8,4.8733e-07_r8,1.5620e-07_r8/)
      kbo(:, 4,45, 1) = (/ &
     &2.7120e-07_r8,6.9216e-07_r8,7.3881e-07_r8,6.5533e-07_r8,1.9009e-07_r8/)
      kbo(:, 5,45, 1) = (/ &
     &3.7310e-07_r8,9.3568e-07_r8,9.9762e-07_r8,8.7425e-07_r8,2.2785e-07_r8/)
      kbo(:, 1,46, 1) = (/ &
     &1.0564e-07_r8,2.2197e-07_r8,2.3290e-07_r8,2.0875e-07_r8,7.2454e-08_r8/)
      kbo(:, 2,46, 1) = (/ &
     &1.2404e-07_r8,2.8745e-07_r8,3.0379e-07_r8,2.7335e-07_r8,9.2971e-08_r8/)
      kbo(:, 3,46, 1) = (/ &
     &1.5624e-07_r8,3.8369e-07_r8,4.0737e-07_r8,3.6500e-07_r8,1.1671e-07_r8/)
      kbo(:, 4,46, 1) = (/ &
     &2.0727e-07_r8,5.2051e-07_r8,5.5407e-07_r8,4.9156e-07_r8,1.4314e-07_r8/)
      kbo(:, 5,46, 1) = (/ &
     &2.8357e-07_r8,7.0586e-07_r8,7.5047e-07_r8,6.5798e-07_r8,1.7235e-07_r8/)
      kbo(:, 1,47, 1) = (/ &
     &8.6916e-08_r8,1.7066e-07_r8,1.7731e-07_r8,1.5740e-07_r8,5.2956e-08_r8/)
      kbo(:, 2,47, 1) = (/ &
     &9.8603e-08_r8,2.1737e-07_r8,2.2800e-07_r8,2.0365e-07_r8,6.8355e-08_r8/)
      kbo(:, 3,47, 1) = (/ &
     &1.2114e-07_r8,2.8693e-07_r8,3.0257e-07_r8,2.7060e-07_r8,8.6098e-08_r8/)
      kbo(:, 4,47, 1) = (/ &
     &1.5770e-07_r8,3.8735e-07_r8,4.1075e-07_r8,3.6401e-07_r8,1.0681e-07_r8/)
      kbo(:, 5,47, 1) = (/ &
     &2.1366e-07_r8,5.2607e-07_r8,5.5766e-07_r8,4.8899e-07_r8,1.2936e-07_r8/)
      kbo(:, 1,48, 1) = (/ &
     &7.2690e-08_r8,1.3243e-07_r8,1.3635e-07_r8,1.1959e-07_r8,3.9422e-08_r8/)
      kbo(:, 2,48, 1) = (/ &
     &7.9634e-08_r8,1.6556e-07_r8,1.7235e-07_r8,1.5270e-07_r8,4.9882e-08_r8/)
      kbo(:, 3,48, 1) = (/ &
     &9.5002e-08_r8,2.1570e-07_r8,2.2592e-07_r8,2.0102e-07_r8,6.3148e-08_r8/)
      kbo(:, 4,48, 1) = (/ &
     &1.2105e-07_r8,2.8907e-07_r8,3.0482e-07_r8,2.6976e-07_r8,7.9242e-08_r8/)
      kbo(:, 5,48, 1) = (/ &
     &1.6180e-07_r8,3.9224e-07_r8,4.1437e-07_r8,3.6322e-07_r8,9.6936e-08_r8/)
      kbo(:, 1,49, 1) = (/ &
     &6.1774e-08_r8,1.0401e-07_r8,1.0607e-07_r8,9.1394e-08_r8,2.9238e-08_r8/)
      kbo(:, 2,49, 1) = (/ &
     &6.5366e-08_r8,1.2732e-07_r8,1.3151e-07_r8,1.1526e-07_r8,3.6075e-08_r8/)
      kbo(:, 3,49, 1) = (/ &
     &7.5416e-08_r8,1.6321e-07_r8,1.6967e-07_r8,1.4985e-07_r8,4.6286e-08_r8/)
      kbo(:, 4,49, 1) = (/ &
     &9.3863e-08_r8,2.1656e-07_r8,2.2682e-07_r8,2.0018e-07_r8,5.8261e-08_r8/)
      kbo(:, 5,49, 1) = (/ &
     &1.2334e-07_r8,2.9285e-07_r8,3.0807e-07_r8,2.6986e-07_r8,7.1843e-08_r8/)
      kbo(:, 1,50, 1) = (/ &
     &5.3206e-08_r8,8.3103e-08_r8,8.3626e-08_r8,7.1042e-08_r8,2.0418e-08_r8/)
      kbo(:, 2,50, 1) = (/ &
     &5.4599e-08_r8,9.9314e-08_r8,1.0171e-07_r8,8.8074e-08_r8,2.6669e-08_r8/)
      kbo(:, 3,50, 1) = (/ &
     &6.0981e-08_r8,1.2515e-07_r8,1.2917e-07_r8,1.1305e-07_r8,3.4171e-08_r8/)
      kbo(:, 4,50, 1) = (/ &
     &7.3992e-08_r8,1.6416e-07_r8,1.7066e-07_r8,1.4995e-07_r8,4.3100e-08_r8/)
      kbo(:, 5,50, 1) = (/ &
     &9.5401e-08_r8,2.2074e-07_r8,2.3106e-07_r8,2.0200e-07_r8,5.3679e-08_r8/)
      kbo(:, 1,51, 1) = (/ &
     &4.6282e-08_r8,6.7151e-08_r8,6.6436e-08_r8,5.6117e-08_r8,1.4310e-08_r8/)
      kbo(:, 2,51, 1) = (/ &
     &4.6293e-08_r8,7.8464e-08_r8,7.9611e-08_r8,6.7952e-08_r8,2.0313e-08_r8/)
      kbo(:, 3,51, 1) = (/ &
     &5.0084e-08_r8,9.7036e-08_r8,9.9288e-08_r8,8.6023e-08_r8,2.5137e-08_r8/)
      kbo(:, 4,51, 1) = (/ &
     &5.9071e-08_r8,1.2553e-07_r8,1.2948e-07_r8,1.1300e-07_r8,3.2036e-08_r8/)
      kbo(:, 5,51, 1) = (/ &
     &7.4640e-08_r8,1.6747e-07_r8,1.7423e-07_r8,1.5170e-07_r8,4.0217e-08_r8/)
      kbo(:, 1,52, 1) = (/ &
     &4.0629e-08_r8,5.4875e-08_r8,5.3346e-08_r8,4.4940e-08_r8,9.9095e-09_r8/)
      kbo(:, 2,52, 1) = (/ &
     &3.9810e-08_r8,6.2753e-08_r8,6.2779e-08_r8,5.3045e-08_r8,1.4355e-08_r8/)
      kbo(:, 3,52, 1) = (/ &
     &4.1749e-08_r8,7.5935e-08_r8,7.6945e-08_r8,6.5932e-08_r8,1.8547e-08_r8/)
      kbo(:, 4,52, 1) = (/ &
     &4.7734e-08_r8,9.6672e-08_r8,9.8927e-08_r8,8.5559e-08_r8,2.3788e-08_r8/)
      kbo(:, 5,52, 1) = (/ &
     &5.9002e-08_r8,1.2763e-07_r8,1.3186e-07_r8,1.1423e-07_r8,2.9932e-08_r8/)
      kbo(:, 1,53, 1) = (/ &
     &3.5975e-08_r8,4.5399e-08_r8,4.2771e-08_r8,3.6200e-08_r8,6.7635e-09_r8/)
      kbo(:, 2,53, 1) = (/ &
     &3.4672e-08_r8,5.0776e-08_r8,4.9763e-08_r8,4.1778e-08_r8,1.0001e-08_r8/)
      kbo(:, 3,53, 1) = (/ &
     &3.5325e-08_r8,6.0020e-08_r8,6.0156e-08_r8,5.0998e-08_r8,1.3726e-08_r8/)
      kbo(:, 4,53, 1) = (/ &
     &3.9133e-08_r8,7.5038e-08_r8,7.6143e-08_r8,6.5063e-08_r8,1.7480e-08_r8/)
      kbo(:, 5,53, 1) = (/ &
     &4.7140e-08_r8,9.7792e-08_r8,1.0026e-07_r8,8.6276e-08_r8,2.2211e-08_r8/)
      kbo(:, 1,54, 1) = (/ &
     &3.2026e-08_r8,3.8173e-08_r8,3.4913e-08_r8,2.9554e-08_r8,4.7895e-09_r8/)
      kbo(:, 2,54, 1) = (/ &
     &3.0459e-08_r8,4.1712e-08_r8,4.0172e-08_r8,3.3417e-08_r8,7.2202e-09_r8/)
      kbo(:, 3,54, 1) = (/ &
     &3.0344e-08_r8,4.8248e-08_r8,4.7728e-08_r8,3.9999e-08_r8,1.0387e-08_r8/)
      kbo(:, 4,54, 1) = (/ &
     &3.2650e-08_r8,5.9169e-08_r8,5.9453e-08_r8,5.0241e-08_r8,1.3202e-08_r8/)
      kbo(:, 5,54, 1) = (/ &
     &3.8298e-08_r8,7.6040e-08_r8,7.7304e-08_r8,6.5975e-08_r8,1.6815e-08_r8/)
      kbo(:, 1,55, 1) = (/ &
     &2.8677e-08_r8,3.2441e-08_r8,2.8748e-08_r8,2.4151e-08_r8,3.5459e-09_r8/)
      kbo(:, 2,55, 1) = (/ &
     &2.6981e-08_r8,3.4720e-08_r8,3.2391e-08_r8,2.6974e-08_r8,5.3560e-09_r8/)
      kbo(:, 3,55, 1) = (/ &
     &2.6409e-08_r8,3.9355e-08_r8,3.8167e-08_r8,3.1739e-08_r8,7.7448e-09_r8/)
      kbo(:, 4,55, 1) = (/ &
     &2.7649e-08_r8,4.7215e-08_r8,4.6970e-08_r8,3.9144e-08_r8,1.0056e-08_r8/)
      kbo(:, 5,55, 1) = (/ &
     &3.1553e-08_r8,5.9776e-08_r8,6.0219e-08_r8,5.0851e-08_r8,1.2897e-08_r8/)
      kbo(:, 1,56, 1) = (/ &
     &2.5871e-08_r8,2.7896e-08_r8,2.4025e-08_r8,1.9941e-08_r8,2.5789e-09_r8/)
      kbo(:, 2,56, 1) = (/ &
     &2.4111e-08_r8,2.9230e-08_r8,2.6562e-08_r8,2.2012e-08_r8,3.9211e-09_r8/)
      kbo(:, 3,56, 1) = (/ &
     &2.3260e-08_r8,3.2443e-08_r8,3.0891e-08_r8,2.5392e-08_r8,5.7991e-09_r8/)
      kbo(:, 4,56, 1) = (/ &
     &2.3744e-08_r8,3.8105e-08_r8,3.7441e-08_r8,3.0750e-08_r8,7.7370e-09_r8/)
      kbo(:, 5,56, 1) = (/ &
     &2.6357e-08_r8,4.7419e-08_r8,4.7264e-08_r8,3.9435e-08_r8,9.8948e-09_r8/)
      kbo(:, 1,57, 1) = (/ &
     &2.3535e-08_r8,2.4259e-08_r8,2.0309e-08_r8,1.6435e-08_r8,1.8424e-09_r8/)
      kbo(:, 2,57, 1) = (/ &
     &2.1750e-08_r8,2.4981e-08_r8,2.1975e-08_r8,1.7965e-08_r8,2.8485e-09_r8/)
      kbo(:, 3,57, 1) = (/ &
     &2.0716e-08_r8,2.7095e-08_r8,2.5073e-08_r8,2.0518e-08_r8,4.3296e-09_r8/)
      kbo(:, 4,57, 1) = (/ &
     &2.0688e-08_r8,3.1150e-08_r8,2.9998e-08_r8,2.4389e-08_r8,6.0949e-09_r8/)
      kbo(:, 5,57, 1) = (/ &
     &2.2336e-08_r8,3.7957e-08_r8,3.7415e-08_r8,3.0783e-08_r8,7.5649e-09_r8/)
      kbo(:, 1,58, 1) = (/ &
     &1.0425e-08_r8,1.1830e-08_r8,1.1340e-08_r8,1.0982e-08_r8,1.3443e-09_r8/)
      kbo(:, 2,58, 1) = (/ &
     &9.5648e-09_r8,1.2002e-08_r8,1.2045e-08_r8,1.1710e-08_r8,2.0849e-09_r8/)
      kbo(:, 3,58, 1) = (/ &
     &9.0146e-09_r8,1.2747e-08_r8,1.3512e-08_r8,1.3201e-08_r8,3.2654e-09_r8/)
      kbo(:, 4,58, 1) = (/ &
     &8.8493e-09_r8,1.4369e-08_r8,1.5929e-08_r8,1.5466e-08_r8,4.7356e-09_r8/)
      kbo(:, 5,58, 1) = (/ &
     &9.3086e-09_r8,1.7138e-08_r8,1.9573e-08_r8,1.9214e-08_r8,5.8278e-09_r8/)
      kbo(:, 1,59, 1) = (/ &
     &9.0380e-09_r8,1.0080e-08_r8,9.6059e-09_r8,9.1584e-09_r8,1.1081e-09_r8/)
      kbo(:, 2,59, 1) = (/ &
     &8.2691e-09_r8,1.0165e-08_r8,1.0115e-08_r8,9.7014e-09_r8,1.7533e-09_r8/)
      kbo(:, 3,59, 1) = (/ &
     &7.7641e-09_r8,1.0688e-08_r8,1.1200e-08_r8,1.0889e-08_r8,2.7394e-09_r8/)
      kbo(:, 4,59, 1) = (/ &
     &7.5756e-09_r8,1.1927e-08_r8,1.3083e-08_r8,1.2667e-08_r8,3.9313e-09_r8/)
      kbo(:, 5,59, 1) = (/ &
     &7.8886e-09_r8,1.4088e-08_r8,1.5992e-08_r8,1.5688e-08_r8,4.8202e-09_r8/)
      kbo(:, 1,13, 2) = (/ &
     &2.3347e-04_r8,3.2740e-04_r8,3.1964e-04_r8,2.7562e-04_r8,2.3674e-04_r8/)
      kbo(:, 2,13, 2) = (/ &
     &2.9027e-04_r8,4.3170e-04_r8,4.3482e-04_r8,3.8943e-04_r8,3.2365e-04_r8/)
      kbo(:, 3,13, 2) = (/ &
     &3.9534e-04_r8,6.0684e-04_r8,6.1602e-04_r8,5.5281e-04_r8,4.2550e-04_r8/)
      kbo(:, 4,13, 2) = (/ &
     &5.7501e-04_r8,8.8229e-04_r8,8.9214e-04_r8,7.8504e-04_r8,5.3481e-04_r8/)
      kbo(:, 5,13, 2) = (/ &
     &8.7274e-04_r8,1.2992e-03_r8,1.2957e-03_r8,1.1072e-03_r8,6.5845e-04_r8/)
      kbo(:, 1,14, 2) = (/ &
     &2.0019e-04_r8,2.7999e-04_r8,2.7248e-04_r8,2.3561e-04_r8,2.0892e-04_r8/)
      kbo(:, 2,14, 2) = (/ &
     &2.5252e-04_r8,3.7448e-04_r8,3.7546e-04_r8,3.3478e-04_r8,2.8574e-04_r8/)
      kbo(:, 3,14, 2) = (/ &
     &3.4599e-04_r8,5.3246e-04_r8,5.3788e-04_r8,4.7751e-04_r8,3.6978e-04_r8/)
      kbo(:, 4,14, 2) = (/ &
     &5.0873e-04_r8,7.7992e-04_r8,7.8607e-04_r8,6.8145e-04_r8,4.6369e-04_r8/)
      kbo(:, 5,14, 2) = (/ &
     &7.7937e-04_r8,1.1544e-03_r8,1.1464e-03_r8,9.6300e-04_r8,5.7084e-04_r8/)
      kbo(:, 1,15, 2) = (/ &
     &1.6496e-04_r8,2.3313e-04_r8,2.2745e-04_r8,1.9815e-04_r8,1.7191e-04_r8/)
      kbo(:, 2,15, 2) = (/ &
     &2.0995e-04_r8,3.1642e-04_r8,3.1725e-04_r8,2.8352e-04_r8,2.3300e-04_r8/)
      kbo(:, 3,15, 2) = (/ &
     &2.9058e-04_r8,4.5406e-04_r8,4.6090e-04_r8,4.0582e-04_r8,3.0079e-04_r8/)
      kbo(:, 4,15, 2) = (/ &
     &4.3180e-04_r8,6.6786e-04_r8,6.7439e-04_r8,5.7938e-04_r8,3.7802e-04_r8/)
      kbo(:, 5,15, 2) = (/ &
     &6.6674e-04_r8,9.9697e-04_r8,9.8451e-04_r8,8.2076e-04_r8,4.7099e-04_r8/)
      kbo(:, 1,16, 2) = (/ &
     &1.3273e-04_r8,1.9160e-04_r8,1.8863e-04_r8,1.6534e-04_r8,1.4034e-04_r8/)
      kbo(:, 2,16, 2) = (/ &
     &1.7022e-04_r8,2.6274e-04_r8,2.6590e-04_r8,2.3774e-04_r8,1.8655e-04_r8/)
      kbo(:, 3,16, 2) = (/ &
     &2.3798e-04_r8,3.7894e-04_r8,3.8748e-04_r8,3.4032e-04_r8,2.3998e-04_r8/)
      kbo(:, 4,16, 2) = (/ &
     &3.5812e-04_r8,5.6381e-04_r8,5.6807e-04_r8,4.8599e-04_r8,3.0617e-04_r8/)
      kbo(:, 5,16, 2) = (/ &
     &5.5540e-04_r8,8.4478e-04_r8,8.3109e-04_r8,6.8770e-04_r8,3.7973e-04_r8/)
      kbo(:, 1,17, 2) = (/ &
     &1.0577e-04_r8,1.5680e-04_r8,1.5536e-04_r8,1.3786e-04_r8,1.1416e-04_r8/)
      kbo(:, 2,17, 2) = (/ &
     &1.3659e-04_r8,2.1658e-04_r8,2.2147e-04_r8,1.9766e-04_r8,1.5136e-04_r8/)
      kbo(:, 3,17, 2) = (/ &
     &1.9353e-04_r8,3.1591e-04_r8,3.2447e-04_r8,2.8337e-04_r8,1.9661e-04_r8/)
      kbo(:, 4,17, 2) = (/ &
     &2.9393e-04_r8,4.7241e-04_r8,4.7609e-04_r8,4.0460e-04_r8,2.4887e-04_r8/)
      kbo(:, 5,17, 2) = (/ &
     &4.5598e-04_r8,7.0740e-04_r8,6.9589e-04_r8,5.7452e-04_r8,3.0304e-04_r8/)
      kbo(:, 1,18, 2) = (/ &
     &8.2750e-05_r8,1.2686e-04_r8,1.2742e-04_r8,1.1403e-04_r8,9.3961e-05_r8/)
      kbo(:, 2,18, 2) = (/ &
     &1.0793e-04_r8,1.7707e-04_r8,1.8353e-04_r8,1.6336e-04_r8,1.2524e-04_r8/)
      kbo(:, 3,18, 2) = (/ &
     &1.5481e-04_r8,2.6078e-04_r8,2.6950e-04_r8,2.3444e-04_r8,1.6211e-04_r8/)
      kbo(:, 4,18, 2) = (/ &
     &2.3641e-04_r8,3.9024e-04_r8,3.9536e-04_r8,3.3586e-04_r8,2.0255e-04_r8/)
      kbo(:, 5,18, 2) = (/ &
     &3.6699e-04_r8,5.8299e-04_r8,5.7531e-04_r8,4.7694e-04_r8,2.4459e-04_r8/)
      kbo(:, 1,19, 2) = (/ &
     &6.5789e-05_r8,1.0377e-04_r8,1.0573e-04_r8,9.4747e-05_r8,7.8309e-05_r8/)
      kbo(:, 2,19, 2) = (/ &
     &8.6739e-05_r8,1.4667e-04_r8,1.5321e-04_r8,1.3630e-04_r8,1.0400e-04_r8/)
      kbo(:, 3,19, 2) = (/ &
     &1.2570e-04_r8,2.1696e-04_r8,2.2493e-04_r8,1.9585e-04_r8,1.3355e-04_r8/)
      kbo(:, 4,19, 2) = (/ &
     &1.9254e-04_r8,3.2492e-04_r8,3.2972e-04_r8,2.8110e-04_r8,1.6478e-04_r8/)
      kbo(:, 5,19, 2) = (/ &
     &2.9952e-04_r8,4.8402e-04_r8,4.8010e-04_r8,3.9892e-04_r8,1.9831e-04_r8/)
      kbo(:, 1,20, 2) = (/ &
     &5.3588e-05_r8,8.6632e-05_r8,8.9247e-05_r8,8.0067e-05_r8,6.5775e-05_r8/)
      kbo(:, 2,20, 2) = (/ &
     &7.1606e-05_r8,1.2377e-04_r8,1.3011e-04_r8,1.1561e-04_r8,8.7374e-05_r8/)
      kbo(:, 3,20, 2) = (/ &
     &1.0490e-04_r8,1.8400e-04_r8,1.9125e-04_r8,1.6630e-04_r8,1.1025e-04_r8/)
      kbo(:, 4,20, 2) = (/ &
     &1.6107e-04_r8,2.7570e-04_r8,2.7972e-04_r8,2.3864e-04_r8,1.3590e-04_r8/)
      kbo(:, 5,20, 2) = (/ &
     &2.5044e-04_r8,4.0870e-04_r8,4.0643e-04_r8,3.3832e-04_r8,1.6243e-04_r8/)
      kbo(:, 1,21, 2) = (/ &
     &4.3995e-05_r8,7.2776e-05_r8,7.5695e-05_r8,6.8050e-05_r8,5.5495e-05_r8/)
      kbo(:, 2,21, 2) = (/ &
     &5.9611e-05_r8,1.0482e-04_r8,1.1056e-04_r8,9.8202e-05_r8,7.3158e-05_r8/)
      kbo(:, 3,21, 2) = (/ &
     &8.7989e-05_r8,1.5634e-04_r8,1.6268e-04_r8,1.4172e-04_r8,9.0987e-05_r8/)
      kbo(:, 4,21, 2) = (/ &
     &1.3548e-04_r8,2.3394e-04_r8,2.3798e-04_r8,2.0295e-04_r8,1.1189e-04_r8/)
      kbo(:, 5,21, 2) = (/ &
     &2.1032e-04_r8,3.4525e-04_r8,3.4399e-04_r8,2.8683e-04_r8,1.3326e-04_r8/)
      kbo(:, 1,22, 2) = (/ &
     &3.6803e-05_r8,6.2518e-05_r8,6.5746e-05_r8,5.8989e-05_r8,4.7547e-05_r8/)
      kbo(:, 2,22, 2) = (/ &
     &5.0761e-05_r8,9.1003e-05_r8,9.6193e-05_r8,8.5393e-05_r8,6.0785e-05_r8/)
      kbo(:, 3,22, 2) = (/ &
     &7.5680e-05_r8,1.3601e-04_r8,1.4124e-04_r8,1.2316e-04_r8,7.5929e-05_r8/)
      kbo(:, 4,22, 2) = (/ &
     &1.1711e-04_r8,2.0303e-04_r8,2.0625e-04_r8,1.7599e-04_r8,9.2008e-05_r8/)
      kbo(:, 5,22, 2) = (/ &
     &1.8108e-04_r8,2.9768e-04_r8,2.9683e-04_r8,2.4768e-04_r8,1.0998e-04_r8/)
      kbo(:, 1,23, 2) = (/ &
     &3.1003e-05_r8,5.3823e-05_r8,5.7061e-05_r8,5.1271e-05_r8,4.0280e-05_r8/)
      kbo(:, 2,23, 2) = (/ &
     &4.3496e-05_r8,7.9103e-05_r8,8.3635e-05_r8,7.4369e-05_r8,5.0624e-05_r8/)
      kbo(:, 3,23, 2) = (/ &
     &6.5401e-05_r8,1.1830e-04_r8,1.2269e-04_r8,1.0707e-04_r8,6.2127e-05_r8/)
      kbo(:, 4,23, 2) = (/ &
     &1.0147e-04_r8,1.7576e-04_r8,1.7852e-04_r8,1.5248e-04_r8,7.5578e-05_r8/)
      kbo(:, 5,23, 2) = (/ &
     &1.5625e-04_r8,2.5690e-04_r8,2.5634e-04_r8,2.1357e-04_r8,9.0733e-05_r8/)
      kbo(:, 1,24, 2) = (/ &
     &2.6471e-05_r8,4.6863e-05_r8,4.9818e-05_r8,4.4807e-05_r8,3.2886e-05_r8/)
      kbo(:, 2,24, 2) = (/ &
     &3.7731e-05_r8,6.9280e-05_r8,7.2915e-05_r8,6.4892e-05_r8,4.1198e-05_r8/)
      kbo(:, 3,24, 2) = (/ &
     &5.7248e-05_r8,1.0347e-04_r8,1.0698e-04_r8,9.3403e-05_r8,5.0808e-05_r8/)
      kbo(:, 4,24, 2) = (/ &
     &8.8791e-05_r8,1.5319e-04_r8,1.5530e-04_r8,1.3247e-04_r8,6.1812e-05_r8/)
      kbo(:, 5,24, 2) = (/ &
     &1.3624e-04_r8,2.2303e-04_r8,2.2220e-04_r8,1.8474e-04_r8,7.4324e-05_r8/)
      kbo(:, 1,25, 2) = (/ &
     &2.2808e-05_r8,4.1048e-05_r8,4.3589e-05_r8,3.9316e-05_r8,2.6891e-05_r8/)
      kbo(:, 2,25, 2) = (/ &
     &3.2985e-05_r8,6.0936e-05_r8,6.3907e-05_r8,5.6898e-05_r8,3.3888e-05_r8/)
      kbo(:, 3,25, 2) = (/ &
     &5.0481e-05_r8,9.0713e-05_r8,9.3687e-05_r8,8.1693e-05_r8,4.1615e-05_r8/)
      kbo(:, 4,25, 2) = (/ &
     &7.8151e-05_r8,1.3406e-04_r8,1.3563e-04_r8,1.1547e-04_r8,5.0834e-05_r8/)
      kbo(:, 5,25, 2) = (/ &
     &1.1946e-04_r8,1.9452e-04_r8,1.9337e-04_r8,1.6037e-04_r8,6.0346e-05_r8/)
      kbo(:, 1,26, 2) = (/ &
     &1.9934e-05_r8,3.6349e-05_r8,3.8562e-05_r8,3.4809e-05_r8,2.2369e-05_r8/)
      kbo(:, 2,26, 2) = (/ &
     &2.9291e-05_r8,5.4051e-05_r8,5.6667e-05_r8,5.0301e-05_r8,2.7895e-05_r8/)
      kbo(:, 3,26, 2) = (/ &
     &4.5044e-05_r8,8.0419e-05_r8,8.2812e-05_r8,7.2007e-05_r8,3.4611e-05_r8/)
      kbo(:, 4,26, 2) = (/ &
     &6.9643e-05_r8,1.1855e-04_r8,1.1958e-04_r8,1.0144e-04_r8,4.1836e-05_r8/)
      kbo(:, 5,26, 2) = (/ &
     &1.0589e-04_r8,1.7128e-04_r8,1.6969e-04_r8,1.4033e-04_r8,4.9219e-05_r8/)
      kbo(:, 1,27, 2) = (/ &
     &1.7559e-05_r8,3.2313e-05_r8,3.4216e-05_r8,3.0835e-05_r8,1.8255e-05_r8/)
      kbo(:, 2,27, 2) = (/ &
     &2.6182e-05_r8,4.8079e-05_r8,5.0267e-05_r8,4.4498e-05_r8,2.3042e-05_r8/)
      kbo(:, 3,27, 2) = (/ &
     &4.0350e-05_r8,7.1540e-05_r8,7.3359e-05_r8,6.3538e-05_r8,2.8359e-05_r8/)
      kbo(:, 4,27, 2) = (/ &
     &6.2227e-05_r8,1.0500e-04_r8,1.0550e-04_r8,8.9231e-05_r8,3.3804e-05_r8/)
      kbo(:, 5,27, 2) = (/ &
     &9.4129e-05_r8,1.5114e-04_r8,1.4903e-04_r8,1.2285e-04_r8,4.0082e-05_r8/)
      kbo(:, 1,28, 2) = (/ &
     &1.5570e-05_r8,2.8729e-05_r8,3.0391e-05_r8,2.7331e-05_r8,1.4928e-05_r8/)
      kbo(:, 2,28, 2) = (/ &
     &2.3454e-05_r8,4.2868e-05_r8,4.4647e-05_r8,3.9416e-05_r8,1.8685e-05_r8/)
      kbo(:, 3,28, 2) = (/ &
     &3.6218e-05_r8,6.3627e-05_r8,6.4995e-05_r8,5.6106e-05_r8,2.2770e-05_r8/)
      kbo(:, 4,28, 2) = (/ &
     &5.5686e-05_r8,9.3113e-05_r8,9.3100e-05_r8,7.8497e-05_r8,2.7363e-05_r8/)
      kbo(:, 5,28, 2) = (/ &
     &8.3686e-05_r8,1.3339e-04_r8,1.3104e-04_r8,1.0755e-04_r8,3.2541e-05_r8/)
      kbo(:, 1,29, 2) = (/ &
     &1.3843e-05_r8,2.5623e-05_r8,2.7065e-05_r8,2.4295e-05_r8,1.2134e-05_r8/)
      kbo(:, 2,29, 2) = (/ &
     &2.1009e-05_r8,3.8248e-05_r8,3.9732e-05_r8,3.4977e-05_r8,1.5044e-05_r8/)
      kbo(:, 3,29, 2) = (/ &
     &3.2483e-05_r8,5.6676e-05_r8,5.7569e-05_r8,4.9592e-05_r8,1.8408e-05_r8/)
      kbo(:, 4,29, 2) = (/ &
     &4.9712e-05_r8,8.2574e-05_r8,8.2234e-05_r8,6.9025e-05_r8,2.2259e-05_r8/)
      kbo(:, 5,29, 2) = (/ &
     &7.4303e-05_r8,1.1753e-04_r8,1.1526e-04_r8,9.4159e-05_r8,2.6343e-05_r8/)
      kbo(:, 1,30, 2) = (/ &
     &1.2283e-05_r8,2.2826e-05_r8,2.4077e-05_r8,2.1586e-05_r8,9.7017e-06_r8/)
      kbo(:, 2,30, 2) = (/ &
     &1.8796e-05_r8,3.4070e-05_r8,3.5216e-05_r8,3.0990e-05_r8,1.2060e-05_r8/)
      kbo(:, 3,30, 2) = (/ &
     &2.9052e-05_r8,5.0361e-05_r8,5.0950e-05_r8,4.3716e-05_r8,1.4847e-05_r8/)
      kbo(:, 4,30, 2) = (/ &
     &4.4245e-05_r8,7.2929e-05_r8,7.2487e-05_r8,6.0571e-05_r8,1.7868e-05_r8/)
      kbo(:, 5,30, 2) = (/ &
     &6.5686e-05_r8,1.0336e-04_r8,1.0108e-04_r8,8.2235e-05_r8,2.0877e-05_r8/)
      kbo(:, 1,31, 2) = (/ &
     &1.0864e-05_r8,2.0303e-05_r8,2.1341e-05_r8,1.9138e-05_r8,7.8312e-06_r8/)
      kbo(:, 2,31, 2) = (/ &
     &1.6718e-05_r8,3.0263e-05_r8,3.1180e-05_r8,2.7363e-05_r8,9.6909e-06_r8/)
      kbo(:, 3,31, 2) = (/ &
     &2.5784e-05_r8,4.4485e-05_r8,4.4959e-05_r8,3.8436e-05_r8,1.1703e-05_r8/)
      kbo(:, 4,31, 2) = (/ &
     &3.9035e-05_r8,6.4113e-05_r8,6.3593e-05_r8,5.2930e-05_r8,1.4083e-05_r8/)
      kbo(:, 5,31, 2) = (/ &
     &5.7600e-05_r8,9.0427e-05_r8,8.8190e-05_r8,7.1491e-05_r8,1.6696e-05_r8/)
      kbo(:, 1,32, 2) = (/ &
     &9.6861e-06_r8,1.8129e-05_r8,1.9009e-05_r8,1.7005e-05_r8,6.3389e-06_r8/)
      kbo(:, 2,32, 2) = (/ &
     &1.4957e-05_r8,2.6929e-05_r8,2.7692e-05_r8,2.4209e-05_r8,7.7689e-06_r8/)
      kbo(:, 3,32, 2) = (/ &
     &2.2989e-05_r8,3.9434e-05_r8,3.9744e-05_r8,3.3837e-05_r8,9.3738e-06_r8/)
      kbo(:, 4,32, 2) = (/ &
     &3.4606e-05_r8,5.6545e-05_r8,5.5926e-05_r8,4.6356e-05_r8,1.1253e-05_r8/)
      kbo(:, 5,32, 2) = (/ &
     &5.0712e-05_r8,7.9301e-05_r8,7.7059e-05_r8,6.2285e-05_r8,1.3276e-05_r8/)
      kbo(:, 1,33, 2) = (/ &
     &8.6881e-06_r8,1.6215e-05_r8,1.6965e-05_r8,1.5122e-05_r8,5.0839e-06_r8/)
      kbo(:, 2,33, 2) = (/ &
     &1.3426e-05_r8,2.4037e-05_r8,2.4628e-05_r8,2.1434e-05_r8,6.2318e-06_r8/)
      kbo(:, 3,33, 2) = (/ &
     &2.0550e-05_r8,3.5027e-05_r8,3.5160e-05_r8,2.9820e-05_r8,7.5123e-06_r8/)
      kbo(:, 4,33, 2) = (/ &
     &3.0762e-05_r8,4.9971e-05_r8,4.9236e-05_r8,4.0640e-05_r8,8.9286e-06_r8/)
      kbo(:, 5,33, 2) = (/ &
     &4.4719e-05_r8,6.9592e-05_r8,6.7432e-05_r8,5.4322e-05_r8,1.0569e-05_r8/)
      kbo(:, 1,34, 2) = (/ &
     &7.7791e-06_r8,1.4442e-05_r8,1.5046e-05_r8,1.3360e-05_r8,4.1600e-06_r8/)
      kbo(:, 2,34, 2) = (/ &
     &1.2019e-05_r8,2.1346e-05_r8,2.1771e-05_r8,1.8857e-05_r8,5.0353e-06_r8/)
      kbo(:, 3,34, 2) = (/ &
     &1.8324e-05_r8,3.0972e-05_r8,3.0949e-05_r8,2.6117e-05_r8,6.0447e-06_r8/)
      kbo(:, 4,34, 2) = (/ &
     &2.7261e-05_r8,4.3932e-05_r8,4.3157e-05_r8,3.5442e-05_r8,7.1905e-06_r8/)
      kbo(:, 5,34, 2) = (/ &
     &3.9385e-05_r8,6.0888e-05_r8,5.8795e-05_r8,4.7179e-05_r8,8.5133e-06_r8/)
      kbo(:, 1,35, 2) = (/ &
     &6.6949e-06_r8,1.2390e-05_r8,1.2873e-05_r8,1.1410e-05_r8,3.2837e-06_r8/)
      kbo(:, 2,35, 2) = (/ &
     &1.0342e-05_r8,1.8289e-05_r8,1.8599e-05_r8,1.6068e-05_r8,4.0072e-06_r8/)
      kbo(:, 3,35, 2) = (/ &
     &1.5729e-05_r8,2.6447e-05_r8,2.6382e-05_r8,2.2198e-05_r8,4.8111e-06_r8/)
      kbo(:, 4,35, 2) = (/ &
     &2.3326e-05_r8,3.7424e-05_r8,3.6694e-05_r8,3.0052e-05_r8,5.7503e-06_r8/)
      kbo(:, 5,35, 2) = (/ &
     &3.3582e-05_r8,5.1735e-05_r8,4.9852e-05_r8,3.9921e-05_r8,6.8317e-06_r8/)
      kbo(:, 1,36, 2) = (/ &
     &5.5116e-06_r8,1.0195e-05_r8,1.0585e-05_r8,9.3814e-06_r8,2.5556e-06_r8/)
      kbo(:, 2,36, 2) = (/ &
     &8.5137e-06_r8,1.5037e-05_r8,1.5296e-05_r8,1.3209e-05_r8,3.1325e-06_r8/)
      kbo(:, 3,36, 2) = (/ &
     &1.2948e-05_r8,2.1753e-05_r8,2.1694e-05_r8,1.8250e-05_r8,3.7680e-06_r8/)
      kbo(:, 4,36, 2) = (/ &
     &1.9198e-05_r8,3.0787e-05_r8,3.0171e-05_r8,2.4706e-05_r8,4.5193e-06_r8/)
      kbo(:, 5,36, 2) = (/ &
     &2.7624e-05_r8,4.2550e-05_r8,4.0975e-05_r8,3.2811e-05_r8,5.3463e-06_r8/)
      kbo(:, 1,37, 2) = (/ &
     &4.2943e-06_r8,7.9625e-06_r8,8.2825e-06_r8,7.3555e-06_r8,1.9862e-06_r8/)
      kbo(:, 2,37, 2) = (/ &
     &6.6379e-06_r8,1.1772e-05_r8,1.1998e-05_r8,1.0386e-05_r8,2.4388e-06_r8/)
      kbo(:, 3,37, 2) = (/ &
     &1.0124e-05_r8,1.7087e-05_r8,1.7068e-05_r8,1.4395e-05_r8,2.9448e-06_r8/)
      kbo(:, 4,37, 2) = (/ &
     &1.5070e-05_r8,2.4266e-05_r8,2.3812e-05_r8,1.9543e-05_r8,3.5287e-06_r8/)
      kbo(:, 5,37, 2) = (/ &
     &2.1767e-05_r8,3.3653e-05_r8,3.2450e-05_r8,2.6024e-05_r8,4.1879e-06_r8/)
      kbo(:, 1,38, 2) = (/ &
     &3.3357e-06_r8,6.1963e-06_r8,6.4603e-06_r8,5.7499e-06_r8,1.5402e-06_r8/)
      kbo(:, 2,38, 2) = (/ &
     &5.1578e-06_r8,9.1863e-06_r8,9.3819e-06_r8,8.1434e-06_r8,1.8945e-06_r8/)
      kbo(:, 3,38, 2) = (/ &
     &7.8901e-06_r8,1.3380e-05_r8,1.3389e-05_r8,1.1321e-05_r8,2.2920e-06_r8/)
      kbo(:, 4,38, 2) = (/ &
     &1.1791e-05_r8,1.9066e-05_r8,1.8739e-05_r8,1.5418e-05_r8,2.7521e-06_r8/)
      kbo(:, 5,38, 2) = (/ &
     &1.7101e-05_r8,2.6537e-05_r8,2.5629e-05_r8,2.0591e-05_r8,3.2788e-06_r8/)
      kbo(:, 1,39, 2) = (/ &
     &2.5925e-06_r8,4.8221e-06_r8,5.0377e-06_r8,4.4928e-06_r8,1.1896e-06_r8/)
      kbo(:, 2,39, 2) = (/ &
     &4.0080e-06_r8,7.1657e-06_r8,7.3339e-06_r8,6.3822e-06_r8,1.4636e-06_r8/)
      kbo(:, 3,39, 2) = (/ &
     &6.1480e-06_r8,1.0471e-05_r8,1.0498e-05_r8,8.8998e-06_r8,1.7757e-06_r8/)
      kbo(:, 4,39, 2) = (/ &
     &9.2224e-06_r8,1.4975e-05_r8,1.4740e-05_r8,1.2159e-05_r8,2.1407e-06_r8/)
      kbo(:, 5,39, 2) = (/ &
     &1.3430e-05_r8,2.0919e-05_r8,2.0232e-05_r8,1.6286e-05_r8,2.5517e-06_r8/)
      kbo(:, 1,40, 2) = (/ &
     &1.9503e-06_r8,3.6256e-06_r8,3.7983e-06_r8,3.3983e-06_r8,9.0970e-07_r8/)
      kbo(:, 2,40, 2) = (/ &
     &3.0096e-06_r8,5.4072e-06_r8,5.5509e-06_r8,4.8509e-06_r8,1.1295e-06_r8/)
      kbo(:, 3,40, 2) = (/ &
     &4.6341e-06_r8,7.9436e-06_r8,7.9881e-06_r8,6.7974e-06_r8,1.3749e-06_r8/)
      kbo(:, 4,40, 2) = (/ &
     &6.9959e-06_r8,1.1429e-05_r8,1.1278e-05_r8,9.3390e-06_r8,1.6560e-06_r8/)
      kbo(:, 5,40, 2) = (/ &
     &1.0262e-05_r8,1.6061e-05_r8,1.5575e-05_r8,1.2573e-05_r8,1.9765e-06_r8/)
      kbo(:, 1,41, 2) = (/ &
     &1.4645e-06_r8,2.7131e-06_r8,2.8491e-06_r8,2.5571e-06_r8,6.9451e-07_r8/)
      kbo(:, 2,41, 2) = (/ &
     &2.2502e-06_r8,4.0586e-06_r8,4.1799e-06_r8,3.6674e-06_r8,8.6660e-07_r8/)
      kbo(:, 3,41, 2) = (/ &
     &3.4750e-06_r8,5.9931e-06_r8,6.0465e-06_r8,5.1654e-06_r8,1.0602e-06_r8/)
      kbo(:, 4,41, 2) = (/ &
     &5.2792e-06_r8,8.6774e-06_r8,8.5850e-06_r8,7.1396e-06_r8,1.2820e-06_r8/)
      kbo(:, 5,41, 2) = (/ &
     &7.8024e-06_r8,1.2273e-05_r8,1.1934e-05_r8,9.6653e-06_r8,1.5281e-06_r8/)
      kbo(:, 1,42, 2) = (/ &
     &1.1030e-06_r8,2.0298e-06_r8,2.1354e-06_r8,1.9220e-06_r8,5.2769e-07_r8/)
      kbo(:, 2,42, 2) = (/ &
     &1.6830e-06_r8,3.0429e-06_r8,3.1437e-06_r8,2.7680e-06_r8,6.5992e-07_r8/)
      kbo(:, 3,42, 2) = (/ &
     &2.6031e-06_r8,4.5149e-06_r8,4.5688e-06_r8,3.9192e-06_r8,8.1465e-07_r8/)
      kbo(:, 4,42, 2) = (/ &
     &3.9772e-06_r8,6.5768e-06_r8,6.5252e-06_r8,5.4495e-06_r8,9.8750e-07_r8/)
      kbo(:, 5,42, 2) = (/ &
     &5.9212e-06_r8,9.3604e-06_r8,9.1253e-06_r8,7.4182e-06_r8,1.1776e-06_r8/)
      kbo(:, 1,43, 2) = (/ &
     &8.2428e-07_r8,1.4953e-06_r8,1.5737e-06_r8,1.4196e-06_r8,3.9479e-07_r8/)
      kbo(:, 2,43, 2) = (/ &
     &1.2422e-06_r8,2.2430e-06_r8,2.3243e-06_r8,2.0532e-06_r8,4.9846e-07_r8/)
      kbo(:, 3,43, 2) = (/ &
     &1.9204e-06_r8,3.3444e-06_r8,3.3959e-06_r8,2.9263e-06_r8,6.1792e-07_r8/)
      kbo(:, 4,43, 2) = (/ &
     &2.9515e-06_r8,4.9083e-06_r8,4.8847e-06_r8,4.0977e-06_r8,7.5196e-07_r8/)
      kbo(:, 5,43, 2) = (/ &
     &4.4328e-06_r8,7.0409e-06_r8,6.8831e-06_r8,5.6178e-06_r8,9.0060e-07_r8/)
      kbo(:, 1,44, 2) = (/ &
     &6.1791e-07_r8,1.0964e-06_r8,1.1526e-06_r8,1.0396e-06_r8,2.9276e-07_r8/)
      kbo(:, 2,44, 2) = (/ &
     &9.1458e-07_r8,1.6410e-06_r8,1.7044e-06_r8,1.5103e-06_r8,3.7305e-07_r8/)
      kbo(:, 3,44, 2) = (/ &
     &1.4081e-06_r8,2.4567e-06_r8,2.5035e-06_r8,2.1667e-06_r8,4.6414e-07_r8/)
      kbo(:, 4,44, 2) = (/ &
     &2.1742e-06_r8,3.6323e-06_r8,3.6267e-06_r8,3.0560e-06_r8,5.6825e-07_r8/)
      kbo(:, 5,44, 2) = (/ &
     &3.2939e-06_r8,5.2553e-06_r8,5.1516e-06_r8,4.2228e-06_r8,6.8470e-07_r8/)
      kbo(:, 1,45, 2) = (/ &
     &4.6818e-07_r8,8.0720e-07_r8,8.4515e-07_r8,7.6099e-07_r8,2.1643e-07_r8/)
      kbo(:, 2,45, 2) = (/ &
     &6.7728e-07_r8,1.2013e-06_r8,1.2493e-06_r8,1.1096e-06_r8,2.7840e-07_r8/)
      kbo(:, 3,45, 2) = (/ &
     &1.0340e-06_r8,1.8032e-06_r8,1.8431e-06_r8,1.6011e-06_r8,3.4809e-07_r8/)
      kbo(:, 4,45, 2) = (/ &
     &1.6004e-06_r8,2.6834e-06_r8,2.6875e-06_r8,2.2740e-06_r8,4.2767e-07_r8/)
      kbo(:, 5,45, 2) = (/ &
     &2.4431e-06_r8,3.9144e-06_r8,3.8469e-06_r8,3.1675e-06_r8,5.1847e-07_r8/)
      kbo(:, 1,46, 2) = (/ &
     &3.5715e-07_r8,5.9421e-07_r8,6.1734e-07_r8,5.5305e-07_r8,1.5800e-07_r8/)
      kbo(:, 2,46, 2) = (/ &
     &5.0187e-07_r8,8.7381e-07_r8,9.0848e-07_r8,8.0843e-07_r8,2.0563e-07_r8/)
      kbo(:, 3,46, 2) = (/ &
     &7.5515e-07_r8,1.3118e-06_r8,1.3445e-06_r8,1.1721e-06_r8,2.5967e-07_r8/)
      kbo(:, 4,46, 2) = (/ &
     &1.1677e-06_r8,1.9633e-06_r8,1.9726e-06_r8,1.6766e-06_r8,3.2108e-07_r8/)
      kbo(:, 5,46, 2) = (/ &
     &1.7950e-06_r8,2.8885e-06_r8,2.8468e-06_r8,2.3553e-06_r8,3.9011e-07_r8/)
      kbo(:, 1,47, 2) = (/ &
     &2.7398e-07_r8,4.3581e-07_r8,4.4704e-07_r8,3.9668e-07_r8,1.1323e-07_r8/)
      kbo(:, 2,47, 2) = (/ &
     &3.7103e-07_r8,6.2850e-07_r8,6.5163e-07_r8,5.8000e-07_r8,1.4990e-07_r8/)
      kbo(:, 3,47, 2) = (/ &
     &5.4577e-07_r8,9.3956e-07_r8,9.6531e-07_r8,8.4415e-07_r8,1.9262e-07_r8/)
      kbo(:, 4,47, 2) = (/ &
     &8.3895e-07_r8,1.4116e-06_r8,1.4241e-06_r8,1.2169e-06_r8,2.3951e-07_r8/)
      kbo(:, 5,47, 2) = (/ &
     &1.2964e-06_r8,2.0956e-06_r8,2.0729e-06_r8,1.7247e-06_r8,2.9208e-07_r8/)
      kbo(:, 1,48, 2) = (/ &
     &2.1387e-07_r8,3.2471e-07_r8,3.2631e-07_r8,2.8559e-07_r8,7.9995e-08_r8/)
      kbo(:, 2,48, 2) = (/ &
     &2.7873e-07_r8,4.5569e-07_r8,4.6902e-07_r8,4.1584e-07_r8,1.0856e-07_r8/)
      kbo(:, 3,48, 2) = (/ &
     &3.9810e-07_r8,6.7425e-07_r8,6.9287e-07_r8,6.0740e-07_r8,1.4073e-07_r8/)
      kbo(:, 4,48, 2) = (/ &
     &6.0448e-07_r8,1.0143e-06_r8,1.0265e-06_r8,8.8097e-07_r8,1.7712e-07_r8/)
      kbo(:, 5,48, 2) = (/ &
     &9.3542e-07_r8,1.5166e-06_r8,1.5052e-06_r8,1.2587e-06_r8,2.1758e-07_r8/)
      kbo(:, 1,49, 2) = (/ &
     &1.6983e-07_r8,2.4624e-07_r8,2.4047e-07_r8,2.0742e-07_r8,5.5874e-08_r8/)
      kbo(:, 2,49, 2) = (/ &
     &2.1316e-07_r8,3.3392e-07_r8,3.3939e-07_r8,2.9852e-07_r8,7.7373e-08_r8/)
      kbo(:, 3,49, 2) = (/ &
     &2.9400e-07_r8,4.8579e-07_r8,4.9802e-07_r8,4.3681e-07_r8,1.0173e-07_r8/)
      kbo(:, 4,49, 2) = (/ &
     &4.3777e-07_r8,7.2867e-07_r8,7.3912e-07_r8,6.3632e-07_r8,1.2966e-07_r8/)
      kbo(:, 5,49, 2) = (/ &
     &6.7522e-07_r8,1.0953e-06_r8,1.0905e-06_r8,9.1600e-07_r8,1.6042e-07_r8/)
      kbo(:, 1,50, 2) = (/ &
     &1.3748e-07_r8,1.9105e-07_r8,1.8074e-07_r8,1.5294e-07_r8,4.0734e-08_r8/)
      kbo(:, 2,50, 2) = (/ &
     &1.6685e-07_r8,2.5027e-07_r8,2.4971e-07_r8,2.1712e-07_r8,5.5541e-08_r8/)
      kbo(:, 3,50, 2) = (/ &
     &2.2205e-07_r8,3.5580e-07_r8,3.6241e-07_r8,3.1709e-07_r8,7.4088e-08_r8/)
      kbo(:, 4,50, 2) = (/ &
     &3.2265e-07_r8,5.2953e-07_r8,5.3723e-07_r8,4.6323e-07_r8,9.5830e-08_r8/)
      kbo(:, 5,50, 2) = (/ &
     &4.9355e-07_r8,7.9777e-07_r8,7.9617e-07_r8,6.7111e-07_r8,1.2000e-07_r8/)
      kbo(:, 1,51, 2) = (/ &
     &1.1310e-07_r8,1.5095e-07_r8,1.3873e-07_r8,1.1416e-07_r8,2.8930e-08_r8/)
      kbo(:, 2,51, 2) = (/ &
     &1.3297e-07_r8,1.9104e-07_r8,1.8603e-07_r8,1.5944e-07_r8,3.9649e-08_r8/)
      kbo(:, 3,51, 2) = (/ &
     &1.7089e-07_r8,2.6387e-07_r8,2.6609e-07_r8,2.3142e-07_r8,5.4118e-08_r8/)
      kbo(:, 4,51, 2) = (/ &
     &2.4121e-07_r8,3.8782e-07_r8,3.9262e-07_r8,3.3860e-07_r8,7.0920e-08_r8/)
      kbo(:, 5,51, 2) = (/ &
     &3.6391e-07_r8,5.8370e-07_r8,5.8331e-07_r8,4.9304e-07_r8,8.9643e-08_r8/)
      kbo(:, 1,52, 2) = (/ &
     &9.4432e-08_r8,1.2100e-07_r8,1.0830e-07_r8,8.6173e-08_r8,2.0454e-08_r8/)
      kbo(:, 2,52, 2) = (/ &
     &1.0754e-07_r8,1.4816e-07_r8,1.4031e-07_r8,1.1784e-07_r8,2.8884e-08_r8/)
      kbo(:, 3,52, 2) = (/ &
     &1.3365e-07_r8,1.9803e-07_r8,1.9664e-07_r8,1.6925e-07_r8,3.9314e-08_r8/)
      kbo(:, 4,52, 2) = (/ &
     &1.8256e-07_r8,2.8565e-07_r8,2.8767e-07_r8,2.4757e-07_r8,5.1552e-08_r8/)
      kbo(:, 5,52, 2) = (/ &
     &2.7006e-07_r8,4.2782e-07_r8,4.2750e-07_r8,3.6187e-07_r8,6.6239e-08_r8/)
      kbo(:, 1,53, 2) = (/ &
     &7.9939e-08_r8,9.8272e-08_r8,8.6307e-08_r8,6.6012e-08_r8,1.4604e-08_r8/)
      kbo(:, 2,53, 2) = (/ &
     &8.8279e-08_r8,1.1673e-07_r8,1.0758e-07_r8,8.7937e-08_r8,2.0451e-08_r8/)
      kbo(:, 3,53, 2) = (/ &
     &1.0623e-07_r8,1.5078e-07_r8,1.4654e-07_r8,1.2425e-07_r8,2.8208e-08_r8/)
      kbo(:, 4,53, 2) = (/ &
     &1.4011e-07_r8,2.1203e-07_r8,2.1153e-07_r8,1.8129e-07_r8,3.7255e-08_r8/)
      kbo(:, 5,53, 2) = (/ &
     &2.0211e-07_r8,3.1443e-07_r8,3.1357e-07_r8,2.6539e-07_r8,4.8314e-08_r8/)
      kbo(:, 1,54, 2) = (/ &
     &6.8612e-08_r8,8.0858e-08_r8,7.0080e-08_r8,5.1088e-08_r8,1.0952e-08_r8/)
      kbo(:, 2,54, 2) = (/ &
     &7.3786e-08_r8,9.3902e-08_r8,8.4431e-08_r8,6.7059e-08_r8,1.4950e-08_r8/)
      kbo(:, 3,54, 2) = (/ &
     &8.6236e-08_r8,1.1751e-07_r8,1.1148e-07_r8,9.2909e-08_r8,2.0689e-08_r8/)
      kbo(:, 4,54, 2) = (/ &
     &1.1017e-07_r8,1.6065e-07_r8,1.5823e-07_r8,1.3458e-07_r8,2.7837e-08_r8/)
      kbo(:, 5,54, 2) = (/ &
     &1.5462e-07_r8,2.3495e-07_r8,2.3325e-07_r8,1.9698e-07_r8,3.6383e-08_r8/)
      kbo(:, 1,55, 2) = (/ &
     &5.9732e-08_r8,6.7403e-08_r8,5.7777e-08_r8,3.9915e-08_r8,8.5037e-09_r8/)
      kbo(:, 2,55, 2) = (/ &
     &6.2576e-08_r8,7.6690e-08_r8,6.7863e-08_r8,5.1930e-08_r8,1.1059e-08_r8/)
      kbo(:, 3,55, 2) = (/ &
     &7.1126e-08_r8,9.3200e-08_r8,8.6382e-08_r8,7.0395e-08_r8,1.5573e-08_r8/)
      kbo(:, 4,55, 2) = (/ &
     &8.8230e-08_r8,1.2378e-07_r8,1.1984e-07_r8,1.0085e-07_r8,2.1225e-08_r8/)
      kbo(:, 5,55, 2) = (/ &
     &1.2026e-07_r8,1.7765e-07_r8,1.7500e-07_r8,1.4721e-07_r8,2.7783e-08_r8/)
      kbo(:, 1,56, 2) = (/ &
     &5.2687e-08_r8,5.6857e-08_r8,4.7895e-08_r8,3.2001e-08_r8,6.6275e-09_r8/)
      kbo(:, 2,56, 2) = (/ &
     &5.3766e-08_r8,6.3415e-08_r8,5.5171e-08_r8,4.0341e-08_r8,8.2176e-09_r8/)
      kbo(:, 3,56, 2) = (/ &
     &5.9487e-08_r8,7.5070e-08_r8,6.7900e-08_r8,5.3874e-08_r8,1.1605e-08_r8/)
      kbo(:, 4,56, 2) = (/ &
     &7.1736e-08_r8,9.6663e-08_r8,9.1606e-08_r8,7.5983e-08_r8,1.6105e-08_r8/)
      kbo(:, 5,56, 2) = (/ &
     &9.4811e-08_r8,1.3547e-07_r8,1.3204e-07_r8,1.1036e-07_r8,2.1203e-08_r8/)
      kbo(:, 1,57, 2) = (/ &
     &4.7030e-08_r8,4.8568e-08_r8,3.9988e-08_r8,2.6219e-08_r8,4.9408e-09_r8/)
      kbo(:, 2,57, 2) = (/ &
     &4.6811e-08_r8,5.3015e-08_r8,4.5546e-08_r8,3.1769e-08_r8,6.1353e-09_r8/)
      kbo(:, 3,57, 2) = (/ &
     &5.0494e-08_r8,6.1370e-08_r8,5.4487e-08_r8,4.1710e-08_r8,8.6536e-09_r8/)
      kbo(:, 4,57, 2) = (/ &
     &5.9216e-08_r8,7.6592e-08_r8,7.0994e-08_r8,5.7693e-08_r8,1.1916e-08_r8/)
      kbo(:, 5,57, 2) = (/ &
     &7.5908e-08_r8,1.0451e-07_r8,1.0035e-07_r8,8.3097e-08_r8,1.6230e-08_r8/)
      kbo(:, 1,58, 2) = (/ &
     &2.0524e-08_r8,2.3377e-08_r8,2.2103e-08_r8,1.7291e-08_r8,3.6303e-09_r8/)
      kbo(:, 2,58, 2) = (/ &
     &2.0023e-08_r8,2.5008e-08_r8,2.4831e-08_r8,2.0273e-08_r8,4.7070e-09_r8/)
      kbo(:, 3,58, 2) = (/ &
     &2.1076e-08_r8,2.8356e-08_r8,2.8987e-08_r8,2.5840e-08_r8,6.5048e-09_r8/)
      kbo(:, 4,58, 2) = (/ &
     &2.4072e-08_r8,3.4377e-08_r8,3.6577e-08_r8,3.5144e-08_r8,8.9689e-09_r8/)
      kbo(:, 5,58, 2) = (/ &
     &3.0004e-08_r8,4.5626e-08_r8,5.0474e-08_r8,4.9976e-08_r8,1.2428e-08_r8/)
      kbo(:, 1,59, 2) = (/ &
     &1.7700e-08_r8,1.9843e-08_r8,1.8643e-08_r8,1.4520e-08_r8,2.9679e-09_r8/)
      kbo(:, 2,59, 2) = (/ &
     &1.7149e-08_r8,2.1008e-08_r8,2.0747e-08_r8,1.6830e-08_r8,3.9081e-09_r8/)
      kbo(:, 3,59, 2) = (/ &
     &1.7873e-08_r8,2.3612e-08_r8,2.4046e-08_r8,2.1098e-08_r8,5.4593e-09_r8/)
      kbo(:, 4,59, 2) = (/ &
     &2.0201e-08_r8,2.8287e-08_r8,2.9905e-08_r8,2.8473e-08_r8,7.4791e-09_r8/)
      kbo(:, 5,59, 2) = (/ &
     &2.4905e-08_r8,3.7065e-08_r8,4.0703e-08_r8,4.0125e-08_r8,1.0391e-08_r8/)
      kbo(:, 1,13, 3) = (/ &
     &7.5570e-04_r8,1.0772e-03_r8,1.0524e-03_r8,8.5610e-04_r8,5.7960e-04_r8/)
      kbo(:, 2,13, 3) = (/ &
     &1.1289e-03_r8,1.5736e-03_r8,1.5191e-03_r8,1.2213e-03_r8,7.5295e-04_r8/)
      kbo(:, 3,13, 3) = (/ &
     &1.7896e-03_r8,2.3714e-03_r8,2.2650e-03_r8,1.7547e-03_r8,9.2113e-04_r8/)
      kbo(:, 4,13, 3) = (/ &
     &2.8881e-03_r8,3.6381e-03_r8,3.3414e-03_r8,2.5211e-03_r8,1.0886e-03_r8/)
      kbo(:, 5,13, 3) = (/ &
     &4.6526e-03_r8,5.5012e-03_r8,4.9005e-03_r8,3.6099e-03_r8,1.2715e-03_r8/)
      kbo(:, 1,14, 3) = (/ &
     &6.5628e-04_r8,9.2369e-04_r8,9.0249e-04_r8,7.3144e-04_r8,5.2166e-04_r8/)
      kbo(:, 2,14, 3) = (/ &
     &1.0001e-03_r8,1.3681e-03_r8,1.3197e-03_r8,1.0469e-03_r8,6.6148e-04_r8/)
      kbo(:, 3,14, 3) = (/ &
     &1.6037e-03_r8,2.0859e-03_r8,1.9738e-03_r8,1.5151e-03_r8,7.9350e-04_r8/)
      kbo(:, 4,14, 3) = (/ &
     &2.6225e-03_r8,3.2284e-03_r8,2.9281e-03_r8,2.1941e-03_r8,9.2716e-04_r8/)
      kbo(:, 5,14, 3) = (/ &
     &4.2437e-03_r8,4.9002e-03_r8,4.3187e-03_r8,3.1691e-03_r8,1.0609e-03_r8/)
      kbo(:, 1,15, 3) = (/ &
     &5.5021e-04_r8,7.7058e-04_r8,7.4997e-04_r8,6.0721e-04_r8,4.5513e-04_r8/)
      kbo(:, 2,15, 3) = (/ &
     &8.5046e-04_r8,1.1533e-03_r8,1.1173e-03_r8,8.7626e-04_r8,5.6093e-04_r8/)
      kbo(:, 3,15, 3) = (/ &
     &1.3828e-03_r8,1.7898e-03_r8,1.6630e-03_r8,1.2772e-03_r8,6.6129e-04_r8/)
      kbo(:, 4,15, 3) = (/ &
     &2.2885e-03_r8,2.7671e-03_r8,2.4977e-03_r8,1.8674e-03_r8,7.6057e-04_r8/)
      kbo(:, 5,15, 3) = (/ &
     &3.7000e-03_r8,4.2354e-03_r8,3.7118e-03_r8,2.7146e-03_r8,8.7024e-04_r8/)
      kbo(:, 1,16, 3) = (/ &
     &4.5181e-04_r8,6.3192e-04_r8,6.1748e-04_r8,4.9522e-04_r8,3.6566e-04_r8/)
      kbo(:, 2,16, 3) = (/ &
     &7.0837e-04_r8,9.6443e-04_r8,9.2028e-04_r8,7.2449e-04_r8,4.4224e-04_r8/)
      kbo(:, 3,16, 3) = (/ &
     &1.1719e-03_r8,1.5071e-03_r8,1.3916e-03_r8,1.0704e-03_r8,5.1878e-04_r8/)
      kbo(:, 4,16, 3) = (/ &
     &1.9347e-03_r8,2.3410e-03_r8,2.1054e-03_r8,1.5750e-03_r8,5.9381e-04_r8/)
      kbo(:, 5,16, 3) = (/ &
     &3.1267e-03_r8,3.5933e-03_r8,3.1446e-03_r8,2.3012e-03_r8,6.8790e-04_r8/)
      kbo(:, 1,17, 3) = (/ &
     &3.7149e-04_r8,5.2008e-04_r8,5.0762e-04_r8,4.0757e-04_r8,2.8847e-04_r8/)
      kbo(:, 2,17, 3) = (/ &
     &5.8832e-04_r8,8.0612e-04_r8,7.6169e-04_r8,6.0348e-04_r8,3.4723e-04_r8/)
      kbo(:, 3,17, 3) = (/ &
     &9.7995e-04_r8,1.2582e-03_r8,1.1654e-03_r8,8.9803e-04_r8,4.0483e-04_r8/)
      kbo(:, 4,17, 3) = (/ &
     &1.6147e-03_r8,1.9685e-03_r8,1.7733e-03_r8,1.3298e-03_r8,4.7136e-04_r8/)
      kbo(:, 5,17, 3) = (/ &
     &2.6071e-03_r8,3.0247e-03_r8,2.6450e-03_r8,1.9458e-03_r8,5.5921e-04_r8/)
      kbo(:, 1,18, 3) = (/ &
     &3.0061e-04_r8,4.2884e-04_r8,4.1648e-04_r8,3.3754e-04_r8,2.3127e-04_r8/)
      kbo(:, 2,18, 3) = (/ &
     &4.8246e-04_r8,6.6793e-04_r8,6.3270e-04_r8,5.0432e-04_r8,2.7279e-04_r8/)
      kbo(:, 3,18, 3) = (/ &
     &8.0392e-04_r8,1.0486e-03_r8,9.7147e-04_r8,7.5301e-04_r8,3.2007e-04_r8/)
      kbo(:, 4,18, 3) = (/ &
     &1.3260e-03_r8,1.6386e-03_r8,1.4792e-03_r8,1.1164e-03_r8,3.8144e-04_r8/)
      kbo(:, 5,18, 3) = (/ &
     &2.1473e-03_r8,2.5126e-03_r8,2.2067e-03_r8,1.6276e-03_r8,4.4653e-04_r8/)
      kbo(:, 1,19, 3) = (/ &
     &2.4724e-04_r8,3.5910e-04_r8,3.4734e-04_r8,2.8349e-04_r8,1.8511e-04_r8/)
      kbo(:, 2,19, 3) = (/ &
     &4.0125e-04_r8,5.6017e-04_r8,5.3189e-04_r8,4.2493e-04_r8,2.2055e-04_r8/)
      kbo(:, 3,19, 3) = (/ &
     &6.6924e-04_r8,8.8342e-04_r8,8.2067e-04_r8,6.3860e-04_r8,2.6260e-04_r8/)
      kbo(:, 4,19, 3) = (/ &
     &1.1061e-03_r8,1.3792e-03_r8,1.2462e-03_r8,9.4376e-04_r8,3.1226e-04_r8/)
      kbo(:, 5,19, 3) = (/ &
     &1.7964e-03_r8,2.1126e-03_r8,1.8583e-03_r8,1.3721e-03_r8,3.6746e-04_r8/)
      kbo(:, 1,20, 3) = (/ &
     &2.0934e-04_r8,3.0700e-04_r8,2.9722e-04_r8,2.4267e-04_r8,1.4926e-04_r8/)
      kbo(:, 2,20, 3) = (/ &
     &3.4260e-04_r8,4.8187e-04_r8,4.5763e-04_r8,3.6566e-04_r8,1.7991e-04_r8/)
      kbo(:, 3,20, 3) = (/ &
     &5.7163e-04_r8,7.5991e-04_r8,7.0644e-04_r8,5.4990e-04_r8,2.1557e-04_r8/)
      kbo(:, 4,20, 3) = (/ &
     &9.4873e-04_r8,1.1845e-03_r8,1.0719e-03_r8,8.1150e-04_r8,2.5564e-04_r8/)
      kbo(:, 5,20, 3) = (/ &
     &1.5383e-03_r8,1.8175e-03_r8,1.5965e-03_r8,1.1755e-03_r8,3.0407e-04_r8/)
      kbo(:, 1,21, 3) = (/ &
     &1.7843e-04_r8,2.6350e-04_r8,2.5564e-04_r8,2.0870e-04_r8,1.2133e-04_r8/)
      kbo(:, 2,21, 3) = (/ &
     &2.9332e-04_r8,4.1557e-04_r8,3.9544e-04_r8,3.1597e-04_r8,1.4677e-04_r8/)
      kbo(:, 3,21, 3) = (/ &
     &4.9132e-04_r8,6.5537e-04_r8,6.0874e-04_r8,4.7437e-04_r8,1.7728e-04_r8/)
      kbo(:, 4,21, 3) = (/ &
     &8.1854e-04_r8,1.0220e-03_r8,9.2374e-04_r8,6.9881e-04_r8,2.1085e-04_r8/)
      kbo(:, 5,21, 3) = (/ &
     &1.3233e-03_r8,1.5674e-03_r8,1.3737e-03_r8,1.0105e-03_r8,2.5000e-04_r8/)
      kbo(:, 1,22, 3) = (/ &
     &1.5600e-04_r8,2.3165e-04_r8,2.2455e-04_r8,1.8380e-04_r8,9.8965e-05_r8/)
      kbo(:, 2,22, 3) = (/ &
     &2.5879e-04_r8,3.6647e-04_r8,3.4891e-04_r8,2.7934e-04_r8,1.2038e-04_r8/)
      kbo(:, 3,22, 3) = (/ &
     &4.3583e-04_r8,5.7888e-04_r8,5.3753e-04_r8,4.1782e-04_r8,1.4492e-04_r8/)
      kbo(:, 4,22, 3) = (/ &
     &7.2393e-04_r8,9.0328e-04_r8,8.1451e-04_r8,6.1366e-04_r8,1.7404e-04_r8/)
      kbo(:, 5,22, 3) = (/ &
     &1.1641e-03_r8,1.3807e-03_r8,1.2062e-03_r8,8.8532e-04_r8,2.0548e-04_r8/)
      kbo(:, 1,23, 3) = (/ &
     &1.3677e-04_r8,2.0433e-04_r8,1.9788e-04_r8,1.6232e-04_r8,8.0071e-05_r8/)
      kbo(:, 2,23, 3) = (/ &
     &2.2851e-04_r8,3.2392e-04_r8,3.0774e-04_r8,2.4623e-04_r8,9.8059e-05_r8/)
      kbo(:, 3,23, 3) = (/ &
     &3.8639e-04_r8,5.1167e-04_r8,4.7457e-04_r8,3.6749e-04_r8,1.1880e-04_r8/)
      kbo(:, 4,23, 3) = (/ &
     &6.3801e-04_r8,7.9694e-04_r8,7.1675e-04_r8,5.3954e-04_r8,1.4295e-04_r8/)
      kbo(:, 5,23, 3) = (/ &
     &1.0211e-03_r8,1.2096e-03_r8,1.0561e-03_r8,7.7552e-04_r8,1.6841e-04_r8/)
      kbo(:, 1,24, 3) = (/ &
     &1.2065e-04_r8,1.8059e-04_r8,1.7513e-04_r8,1.4381e-04_r8,6.4790e-05_r8/)
      kbo(:, 2,24, 3) = (/ &
     &2.0387e-04_r8,2.8742e-04_r8,2.7331e-04_r8,2.1771e-04_r8,7.9169e-05_r8/)
      kbo(:, 3,24, 3) = (/ &
     &3.4413e-04_r8,4.5518e-04_r8,4.2044e-04_r8,3.2458e-04_r8,9.5995e-05_r8/)
      kbo(:, 4,24, 3) = (/ &
     &5.6569e-04_r8,7.0542e-04_r8,6.3169e-04_r8,4.7542e-04_r8,1.1593e-04_r8/)
      kbo(:, 5,24, 3) = (/ &
     &8.9817e-04_r8,1.0616e-03_r8,9.2695e-04_r8,6.8043e-04_r8,1.3621e-04_r8/)
      kbo(:, 1,25, 3) = (/ &
     &1.0740e-04_r8,1.6092e-04_r8,1.5588e-04_r8,1.2763e-04_r8,5.2835e-05_r8/)
      kbo(:, 2,25, 3) = (/ &
     &1.8277e-04_r8,2.5653e-04_r8,2.4346e-04_r8,1.9325e-04_r8,6.4708e-05_r8/)
      kbo(:, 3,25, 3) = (/ &
     &3.0775e-04_r8,4.0577e-04_r8,3.7301e-04_r8,2.8766e-04_r8,7.8479e-05_r8/)
      kbo(:, 4,25, 3) = (/ &
     &5.0348e-04_r8,6.2434e-04_r8,5.5838e-04_r8,4.1972e-04_r8,9.2999e-05_r8/)
      kbo(:, 5,25, 3) = (/ &
     &7.9236e-04_r8,9.3393e-04_r8,8.1486e-04_r8,5.9712e-04_r8,1.1091e-04_r8/)
      kbo(:, 1,26, 3) = (/ &
     &9.7543e-05_r8,1.4515e-04_r8,1.4079e-04_r8,1.1469e-04_r8,4.3203e-05_r8/)
      kbo(:, 2,26, 3) = (/ &
     &1.6637e-04_r8,2.3211e-04_r8,2.1906e-04_r8,1.7338e-04_r8,5.3501e-05_r8/)
      kbo(:, 3,26, 3) = (/ &
     &2.7898e-04_r8,3.6497e-04_r8,3.3420e-04_r8,2.5717e-04_r8,6.4391e-05_r8/)
      kbo(:, 4,26, 3) = (/ &
     &4.5278e-04_r8,5.5785e-04_r8,4.9753e-04_r8,3.7293e-04_r8,7.6357e-05_r8/)
      kbo(:, 5,26, 3) = (/ &
     &7.0495e-04_r8,8.2859e-04_r8,7.2055e-04_r8,5.2702e-04_r8,9.1483e-05_r8/)
      kbo(:, 1,27, 3) = (/ &
     &8.8905e-05_r8,1.3136e-04_r8,1.2690e-04_r8,1.0312e-04_r8,3.5556e-05_r8/)
      kbo(:, 2,27, 3) = (/ &
     &1.5157e-04_r8,2.0993e-04_r8,1.9708e-04_r8,1.5550e-04_r8,4.3708e-05_r8/)
      kbo(:, 3,27, 3) = (/ &
     &2.5313e-04_r8,3.2779e-04_r8,2.9943e-04_r8,2.2974e-04_r8,5.2449e-05_r8/)
      kbo(:, 4,27, 3) = (/ &
     &4.0707e-04_r8,4.9850e-04_r8,4.4267e-04_r8,3.3107e-04_r8,6.3153e-05_r8/)
      kbo(:, 5,27, 3) = (/ &
     &6.2804e-04_r8,7.3434e-04_r8,6.3748e-04_r8,4.6470e-04_r8,7.4410e-05_r8/)
      kbo(:, 1,28, 3) = (/ &
     &8.1071e-05_r8,1.1893e-04_r8,1.1441e-04_r8,9.2670e-05_r8,2.9048e-05_r8/)
      kbo(:, 2,28, 3) = (/ &
     &1.3818e-04_r8,1.8937e-04_r8,1.7730e-04_r8,1.3932e-04_r8,3.5467e-05_r8/)
      kbo(:, 3,28, 3) = (/ &
     &2.2925e-04_r8,2.9449e-04_r8,2.6762e-04_r8,2.0484e-04_r8,4.2994e-05_r8/)
      kbo(:, 4,28, 3) = (/ &
     &3.6544e-04_r8,4.4427e-04_r8,3.9356e-04_r8,2.9338e-04_r8,5.1335e-05_r8/)
      kbo(:, 5,28, 3) = (/ &
     &5.5873e-04_r8,6.5113e-04_r8,5.6346e-04_r8,4.0933e-04_r8,6.0144e-05_r8/)
      kbo(:, 1,29, 3) = (/ &
     &7.4203e-05_r8,1.0781e-04_r8,1.0341e-04_r8,8.3458e-05_r8,2.3671e-05_r8/)
      kbo(:, 2,29, 3) = (/ &
     &1.2605e-04_r8,1.7113e-04_r8,1.5936e-04_r8,1.2487e-04_r8,2.9121e-05_r8/)
      kbo(:, 3,29, 3) = (/ &
     &2.0703e-04_r8,2.6395e-04_r8,2.3919e-04_r8,1.8248e-04_r8,3.5057e-05_r8/)
      kbo(:, 4,29, 3) = (/ &
     &3.2741e-04_r8,3.9598e-04_r8,3.4952e-04_r8,2.5961e-04_r8,4.1444e-05_r8/)
      kbo(:, 5,29, 3) = (/ &
     &4.9624e-04_r8,5.7661e-04_r8,4.9724e-04_r8,3.6006e-04_r8,4.8751e-05_r8/)
      kbo(:, 1,30, 3) = (/ &
     &6.7677e-05_r8,9.7468e-05_r8,9.3138e-05_r8,7.4923e-05_r8,1.9287e-05_r8/)
      kbo(:, 2,30, 3) = (/ &
     &1.1431e-04_r8,1.5374e-04_r8,1.4284e-04_r8,1.1153e-04_r8,2.3591e-05_r8/)
      kbo(:, 3,30, 3) = (/ &
     &1.8623e-04_r8,2.3583e-04_r8,2.1291e-04_r8,1.6193e-04_r8,2.8158e-05_r8/)
      kbo(:, 4,30, 3) = (/ &
     &2.9180e-04_r8,3.5163e-04_r8,3.0921e-04_r8,2.2892e-04_r8,3.3328e-05_r8/)
      kbo(:, 5,30, 3) = (/ &
     &4.3918e-04_r8,5.0854e-04_r8,4.3751e-04_r8,3.1569e-04_r8,3.9501e-05_r8/)
      kbo(:, 1,31, 3) = (/ &
     &6.1393e-05_r8,8.7694e-05_r8,8.3630e-05_r8,6.7048e-05_r8,1.5382e-05_r8/)
      kbo(:, 2,31, 3) = (/ &
     &1.0290e-04_r8,1.3743e-04_r8,1.2731e-04_r8,9.9241e-05_r8,1.8651e-05_r8/)
      kbo(:, 3,31, 3) = (/ &
     &1.6626e-04_r8,2.0956e-04_r8,1.8851e-04_r8,1.4301e-04_r8,2.2748e-05_r8/)
      kbo(:, 4,31, 3) = (/ &
     &2.5819e-04_r8,3.1016e-04_r8,2.7211e-04_r8,2.0081e-04_r8,2.7039e-05_r8/)
      kbo(:, 5,31, 3) = (/ &
     &3.8535e-04_r8,4.4535e-04_r8,3.8254e-04_r8,2.7522e-04_r8,3.1790e-05_r8/)
      kbo(:, 1,32, 3) = (/ &
     &5.5908e-05_r8,7.9178e-05_r8,7.5227e-05_r8,6.0166e-05_r8,1.2301e-05_r8/)
      kbo(:, 2,32, 3) = (/ &
     &9.3029e-05_r8,1.2336e-04_r8,1.1373e-04_r8,8.8415e-05_r8,1.5236e-05_r8/)
      kbo(:, 3,32, 3) = (/ &
     &1.4900e-04_r8,1.8677e-04_r8,1.6744e-04_r8,1.2652e-04_r8,1.8544e-05_r8/)
      kbo(:, 4,32, 3) = (/ &
     &2.2938e-04_r8,2.7443e-04_r8,2.4002e-04_r8,1.7648e-04_r8,2.2012e-05_r8/)
      kbo(:, 5,32, 3) = (/ &
     &3.3936e-04_r8,3.9112e-04_r8,3.3532e-04_r8,2.4040e-04_r8,2.5885e-05_r8/)
      kbo(:, 1,33, 3) = (/ &
     &5.1027e-05_r8,7.1592e-05_r8,6.7752e-05_r8,5.3984e-05_r8,1.0069e-05_r8/)
      kbo(:, 2,33, 3) = (/ &
     &8.4306e-05_r8,1.1082e-04_r8,1.0178e-04_r8,7.8786e-05_r8,1.2424e-05_r8/)
      kbo(:, 3,33, 3) = (/ &
     &1.3378e-04_r8,1.6666e-04_r8,1.4886e-04_r8,1.1198e-04_r8,1.5017e-05_r8/)
      kbo(:, 4,33, 3) = (/ &
     &2.0407e-04_r8,2.4310e-04_r8,2.1204e-04_r8,1.5519e-04_r8,1.7833e-05_r8/)
      kbo(:, 5,33, 3) = (/ &
     &2.9932e-04_r8,3.4399e-04_r8,2.9425e-04_r8,2.1002e-04_r8,2.0751e-05_r8/)
      kbo(:, 1,34, 3) = (/ &
     &4.6423e-05_r8,6.4385e-05_r8,6.0651e-05_r8,4.8084e-05_r8,8.2313e-06_r8/)
      kbo(:, 2,34, 3) = (/ &
     &7.6075e-05_r8,9.9124e-05_r8,9.0586e-05_r8,6.9780e-05_r8,1.0168e-05_r8/)
      kbo(:, 3,34, 3) = (/ &
     &1.1981e-04_r8,1.4811e-04_r8,1.3176e-04_r8,9.8597e-05_r8,1.2205e-05_r8/)
      kbo(:, 4,34, 3) = (/ &
     &1.8123e-04_r8,2.1472e-04_r8,1.8662e-04_r8,1.3590e-04_r8,1.4492e-05_r8/)
      kbo(:, 5,34, 3) = (/ &
     &2.6376e-04_r8,3.0190e-04_r8,2.5753e-04_r8,1.8301e-04_r8,1.6946e-05_r8/)
      kbo(:, 1,35, 3) = (/ &
     &4.0215e-05_r8,5.5516e-05_r8,5.2178e-05_r8,4.1265e-05_r8,6.6300e-06_r8/)
      kbo(:, 2,35, 3) = (/ &
     &6.5646e-05_r8,8.5207e-05_r8,7.7691e-05_r8,5.9694e-05_r8,8.1351e-06_r8/)
      kbo(:, 3,35, 3) = (/ &
     &1.0298e-04_r8,1.2694e-04_r8,1.1266e-04_r8,8.4059e-05_r8,9.8103e-06_r8/)
      kbo(:, 4,35, 3) = (/ &
     &1.5503e-04_r8,1.8334e-04_r8,1.5905e-04_r8,1.1551e-04_r8,1.1630e-05_r8/)
      kbo(:, 5,35, 3) = (/ &
     &2.2476e-04_r8,2.5697e-04_r8,2.1886e-04_r8,1.5514e-04_r8,1.3591e-05_r8/)
      kbo(:, 1,36, 3) = (/ &
     &3.2994e-05_r8,4.5660e-05_r8,4.2930e-05_r8,3.3969e-05_r8,5.1542e-06_r8/)
      kbo(:, 2,36, 3) = (/ &
     &5.3916e-05_r8,7.0104e-05_r8,6.3946e-05_r8,4.9132e-05_r8,6.3498e-06_r8/)
      kbo(:, 3,36, 3) = (/ &
     &8.4552e-05_r8,1.0443e-04_r8,9.2717e-05_r8,6.9170e-05_r8,7.6665e-06_r8/)
      kbo(:, 4,36, 3) = (/ &
     &1.2731e-04_r8,1.5086e-04_r8,1.3088e-04_r8,9.4999e-05_r8,9.0883e-06_r8/)
      kbo(:, 5,36, 3) = (/ &
     &1.8455e-04_r8,2.1131e-04_r8,1.8000e-04_r8,1.2756e-04_r8,1.0606e-05_r8/)
      kbo(:, 1,37, 3) = (/ &
     &2.5429e-05_r8,3.5502e-05_r8,3.3507e-05_r8,2.6612e-05_r8,3.9872e-06_r8/)
      kbo(:, 2,37, 3) = (/ &
     &4.1789e-05_r8,5.4774e-05_r8,5.0118e-05_r8,3.8644e-05_r8,4.9244e-06_r8/)
      kbo(:, 3,37, 3) = (/ &
     &6.5920e-05_r8,8.1963e-05_r8,7.2974e-05_r8,5.4610e-05_r8,5.9794e-06_r8/)
      kbo(:, 4,37, 3) = (/ &
     &9.9825e-05_r8,1.1892e-04_r8,1.0339e-04_r8,7.5254e-05_r8,7.1021e-06_r8/)
      kbo(:, 5,37, 3) = (/ &
     &1.4543e-04_r8,1.6731e-04_r8,1.4273e-04_r8,1.0135e-04_r8,8.2993e-06_r8/)
      kbo(:, 1,38, 3) = (/ &
     &1.9510e-05_r8,2.7499e-05_r8,2.6048e-05_r8,2.0774e-05_r8,3.0726e-06_r8/)
      kbo(:, 2,38, 3) = (/ &
     &3.2252e-05_r8,4.2623e-05_r8,3.9146e-05_r8,3.0291e-05_r8,3.8102e-06_r8/)
      kbo(:, 3,38, 3) = (/ &
     &5.1187e-05_r8,6.4097e-05_r8,5.7223e-05_r8,4.2970e-05_r8,4.6390e-06_r8/)
      kbo(:, 4,38, 3) = (/ &
     &7.8004e-05_r8,9.3430e-05_r8,8.1421e-05_r8,5.9437e-05_r8,5.5099e-06_r8/)
      kbo(:, 5,38, 3) = (/ &
     &1.1424e-04_r8,1.3207e-04_r8,1.1286e-04_r8,8.0305e-05_r8,6.4580e-06_r8/)
      kbo(:, 1,39, 3) = (/ &
     &1.4955e-05_r8,2.1282e-05_r8,2.0237e-05_r8,1.6208e-05_r8,2.3414e-06_r8/)
      kbo(:, 2,39, 3) = (/ &
     &2.4867e-05_r8,3.3144e-05_r8,3.0547e-05_r8,2.3724e-05_r8,2.9298e-06_r8/)
      kbo(:, 3,39, 3) = (/ &
     &3.9718e-05_r8,5.0092e-05_r8,4.4848e-05_r8,3.3792e-05_r8,3.5597e-06_r8/)
      kbo(:, 4,39, 3) = (/ &
     &6.0902e-05_r8,7.3365e-05_r8,6.4080e-05_r8,4.6913e-05_r8,4.2665e-06_r8/)
      kbo(:, 5,39, 3) = (/ &
     &8.9673e-05_r8,1.0416e-04_r8,8.9163e-05_r8,6.3592e-05_r8,5.0003e-06_r8/)
      kbo(:, 1,40, 3) = (/ &
     &1.0973e-05_r8,1.5834e-05_r8,1.5141e-05_r8,1.2207e-05_r8,1.7695e-06_r8/)
      kbo(:, 2,40, 3) = (/ &
     &1.8417e-05_r8,2.4851e-05_r8,2.3037e-05_r8,1.7992e-05_r8,2.2304e-06_r8/)
      kbo(:, 3,40, 3) = (/ &
     &2.9718e-05_r8,3.7867e-05_r8,3.4065e-05_r8,2.5810e-05_r8,2.7325e-06_r8/)
      kbo(:, 4,40, 3) = (/ &
     &4.6050e-05_r8,5.5927e-05_r8,4.9024e-05_r8,3.6065e-05_r8,3.2836e-06_r8/)
      kbo(:, 5,40, 3) = (/ &
     &6.8462e-05_r8,8.0022e-05_r8,6.8684e-05_r8,4.9179e-05_r8,3.8780e-06_r8/)
      kbo(:, 1,41, 3) = (/ &
     &7.9936e-06_r8,1.1702e-05_r8,1.1250e-05_r8,9.1326e-06_r8,1.3289e-06_r8/)
      kbo(:, 2,41, 3) = (/ &
     &1.3541e-05_r8,1.8510e-05_r8,1.7261e-05_r8,1.3563e-05_r8,1.6876e-06_r8/)
      kbo(:, 3,41, 3) = (/ &
     &2.2085e-05_r8,2.8450e-05_r8,2.5728e-05_r8,1.9606e-05_r8,2.0896e-06_r8/)
      kbo(:, 4,41, 3) = (/ &
     &3.4599e-05_r8,4.2393e-05_r8,3.7310e-05_r8,2.7591e-05_r8,2.5142e-06_r8/)
      kbo(:, 5,41, 3) = (/ &
     &5.1973e-05_r8,6.1166e-05_r8,5.2649e-05_r8,3.7859e-05_r8,2.9985e-06_r8/)
      kbo(:, 1,42, 3) = (/ &
     &5.8131e-06_r8,8.6287e-06_r8,8.3395e-06_r8,6.8180e-06_r8,9.9321e-07_r8/)
      kbo(:, 2,42, 3) = (/ &
     &9.9286e-06_r8,1.3753e-05_r8,1.2903e-05_r8,1.0201e-05_r8,1.2739e-06_r8/)
      kbo(:, 3,42, 3) = (/ &
     &1.6369e-05_r8,2.1324e-05_r8,1.9387e-05_r8,1.4861e-05_r8,1.5862e-06_r8/)
      kbo(:, 4,42, 3) = (/ &
     &2.5917e-05_r8,3.2058e-05_r8,2.8333e-05_r8,2.1064e-05_r8,1.9289e-06_r8/)
      kbo(:, 5,42, 3) = (/ &
     &3.9355e-05_r8,4.6652e-05_r8,4.0275e-05_r8,2.9099e-05_r8,2.3091e-06_r8/)
      kbo(:, 1,43, 3) = (/ &
     &4.1379e-06_r8,6.2276e-06_r8,6.0505e-06_r8,4.9862e-06_r8,7.3153e-07_r8/)
      kbo(:, 2,43, 3) = (/ &
     &7.1228e-06_r8,1.0012e-05_r8,9.4538e-06_r8,7.5288e-06_r8,9.4466e-07_r8/)
      kbo(:, 3,43, 3) = (/ &
     &1.1889e-05_r8,1.5688e-05_r8,1.4350e-05_r8,1.1075e-05_r8,1.1892e-06_r8/)
      kbo(:, 4,43, 3) = (/ &
     &1.9074e-05_r8,2.3844e-05_r8,2.1179e-05_r8,1.5845e-05_r8,1.4637e-06_r8/)
      kbo(:, 5,43, 3) = (/ &
     &2.9351e-05_r8,3.5073e-05_r8,3.0382e-05_r8,2.2068e-05_r8,1.7581e-06_r8/)
      kbo(:, 1,44, 3) = (/ &
     &2.9204e-06_r8,4.4462e-06_r8,4.3423e-06_r8,3.6069e-06_r8,5.3481e-07_r8/)
      kbo(:, 2,44, 3) = (/ &
     &5.0527e-06_r8,7.2110e-06_r8,6.8508e-06_r8,5.4982e-06_r8,6.9481e-07_r8/)
      kbo(:, 3,44, 3) = (/ &
     &8.5402e-06_r8,1.1419e-05_r8,1.0515e-05_r8,8.1724e-06_r8,8.8543e-07_r8/)
      kbo(:, 4,44, 3) = (/ &
     &1.3894e-05_r8,1.7562e-05_r8,1.5682e-05_r8,1.1814e-05_r8,1.0984e-06_r8/)
      kbo(:, 5,44, 3) = (/ &
     &2.1692e-05_r8,2.6150e-05_r8,2.2738e-05_r8,1.6619e-05_r8,1.3258e-06_r8/)
      kbo(:, 1,45, 3) = (/ &
     &2.0654e-06_r8,3.1706e-06_r8,3.1106e-06_r8,2.6027e-06_r8,3.8843e-07_r8/)
      kbo(:, 2,45, 3) = (/ &
     &3.5785e-06_r8,5.1800e-06_r8,4.9498e-06_r8,4.0029e-06_r8,5.0552e-07_r8/)
      kbo(:, 3,45, 3) = (/ &
     &6.1156e-06_r8,8.2899e-06_r8,7.6825e-06_r8,6.0114e-06_r8,6.4899e-07_r8/)
      kbo(:, 4,45, 3) = (/ &
     &1.0090e-05_r8,1.2899e-05_r8,1.1584e-05_r8,8.7849e-06_r8,8.1182e-07_r8/)
      kbo(:, 5,45, 3) = (/ &
     &1.5974e-05_r8,1.9436e-05_r8,1.6972e-05_r8,1.2481e-05_r8,9.9260e-07_r8/)
      kbo(:, 1,46, 3) = (/ &
     &1.4538e-06_r8,2.2381e-06_r8,2.2044e-06_r8,1.8570e-06_r8,2.7780e-07_r8/)
      kbo(:, 2,46, 3) = (/ &
     &2.5054e-06_r8,3.6761e-06_r8,3.5333e-06_r8,2.8803e-06_r8,3.6666e-07_r8/)
      kbo(:, 3,46, 3) = (/ &
     &4.3205e-06_r8,5.9430e-06_r8,5.5451e-06_r8,4.3709e-06_r8,4.7052e-07_r8/)
      kbo(:, 4,46, 3) = (/ &
     &7.2299e-06_r8,9.3616e-06_r8,8.4601e-06_r8,6.4628e-06_r8,5.9539e-07_r8/)
      kbo(:, 5,46, 3) = (/ &
     &1.1621e-05_r8,1.4285e-05_r8,1.2535e-05_r8,9.2836e-06_r8,7.3565e-07_r8/)
      kbo(:, 1,47, 3) = (/ &
     &1.0143e-06_r8,1.5538e-06_r8,1.5325e-06_r8,1.2979e-06_r8,1.9733e-07_r8/)
      kbo(:, 2,47, 3) = (/ &
     &1.7208e-06_r8,2.5538e-06_r8,2.4694e-06_r8,2.0305e-06_r8,2.6304e-07_r8/)
      kbo(:, 3,47, 3) = (/ &
     &2.9828e-06_r8,4.1702e-06_r8,3.9202e-06_r8,3.1167e-06_r8,3.4065e-07_r8/)
      kbo(:, 4,47, 3) = (/ &
     &5.0644e-06_r8,6.6541e-06_r8,6.0593e-06_r8,4.6660e-06_r8,4.3326e-07_r8/)
      kbo(:, 5,47, 3) = (/ &
     &8.2782e-06_r8,1.0300e-05_r8,9.0956e-06_r8,6.7879e-06_r8,5.4017e-07_r8/)
      kbo(:, 1,48, 3) = (/ &
     &7.2030e-07_r8,1.0845e-06_r8,1.0676e-06_r8,9.0611e-07_r8,1.3761e-07_r8/)
      kbo(:, 2,48, 3) = (/ &
     &1.1872e-06_r8,1.7730e-06_r8,1.7228e-06_r8,1.4271e-06_r8,1.8706e-07_r8/)
      kbo(:, 3,48, 3) = (/ &
     &2.0561e-06_r8,2.9161e-06_r8,2.7609e-06_r8,2.2135e-06_r8,2.4544e-07_r8/)
      kbo(:, 4,48, 3) = (/ &
     &3.5327e-06_r8,4.7102e-06_r8,4.3223e-06_r8,3.3540e-06_r8,3.1231e-07_r8/)
      kbo(:, 5,48, 3) = (/ &
     &5.8701e-06_r8,7.3943e-06_r8,6.5729e-06_r8,4.9432e-06_r8,3.9364e-07_r8/)
      kbo(:, 1,49, 3) = (/ &
     &5.2463e-07_r8,7.6406e-07_r8,7.4789e-07_r8,6.3224e-07_r8,9.4269e-08_r8/)
      kbo(:, 2,49, 3) = (/ &
     &8.2733e-07_r8,1.2326e-06_r8,1.2007e-06_r8,1.0005e-06_r8,1.3092e-07_r8/)
      kbo(:, 3,49, 3) = (/ &
     &1.4174e-06_r8,2.0342e-06_r8,1.9376e-06_r8,1.5657e-06_r8,1.7460e-07_r8/)
      kbo(:, 4,49, 3) = (/ &
     &2.4552e-06_r8,3.3221e-06_r8,3.0702e-06_r8,2.4004e-06_r8,2.2553e-07_r8/)
      kbo(:, 5,49, 3) = (/ &
     &4.1423e-06_r8,5.2851e-06_r8,4.7305e-06_r8,3.5840e-06_r8,2.8424e-07_r8/)
      kbo(:, 1,50, 3) = (/ &
     &3.9659e-07_r8,5.5178e-07_r8,5.3440e-07_r8,4.4722e-07_r8,6.5930e-08_r8/)
      kbo(:, 2,50, 3) = (/ &
     &5.9210e-07_r8,8.7140e-07_r8,8.4803e-07_r8,7.0817e-07_r8,9.3562e-08_r8/)
      kbo(:, 3,50, 3) = (/ &
     &9.9396e-07_r8,1.4345e-06_r8,1.3722e-06_r8,1.1160e-06_r8,1.2619e-07_r8/)
      kbo(:, 4,50, 3) = (/ &
     &1.7258e-06_r8,2.3624e-06_r8,2.1973e-06_r8,1.7292e-06_r8,1.6444e-07_r8/)
      kbo(:, 5,50, 3) = (/ &
     &2.9480e-06_r8,3.8052e-06_r8,3.4270e-06_r8,2.6131e-06_r8,2.0855e-07_r8/)
      kbo(:, 1,51, 3) = (/ &
     &3.0780e-07_r8,4.0724e-07_r8,3.8772e-07_r8,3.1909e-07_r8,4.7152e-08_r8/)
      kbo(:, 2,51, 3) = (/ &
     &4.3389e-07_r8,6.2376e-07_r8,6.0442e-07_r8,5.0387e-07_r8,6.6848e-08_r8/)
      kbo(:, 3,51, 3) = (/ &
     &7.0578e-07_r8,1.0183e-06_r8,9.7661e-07_r8,7.9773e-07_r8,9.1673e-08_r8/)
      kbo(:, 4,51, 3) = (/ &
     &1.2202e-06_r8,1.6857e-06_r8,1.5762e-06_r8,1.2481e-06_r8,1.2080e-07_r8/)
      kbo(:, 5,51, 3) = (/ &
     &2.1050e-06_r8,2.7463e-06_r8,2.4878e-06_r8,1.9078e-06_r8,1.5488e-07_r8/)
      kbo(:, 1,52, 3) = (/ &
     &2.4467e-07_r8,3.0672e-07_r8,2.8540e-07_r8,2.2927e-07_r8,3.3766e-08_r8/)
      kbo(:, 2,52, 3) = (/ &
     &3.2577e-07_r8,4.5139e-07_r8,4.3382e-07_r8,3.5906e-07_r8,4.7409e-08_r8/)
      kbo(:, 3,52, 3) = (/ &
     &5.0672e-07_r8,7.2555e-07_r8,6.9595e-07_r8,5.7001e-07_r8,6.5991e-08_r8/)
      kbo(:, 4,52, 3) = (/ &
     &8.6516e-07_r8,1.2018e-06_r8,1.1289e-06_r8,8.9884e-07_r8,8.8646e-08_r8/)
      kbo(:, 5,52, 3) = (/ &
     &1.5011e-06_r8,1.9777e-06_r8,1.8012e-06_r8,1.3890e-06_r8,1.1411e-07_r8/)
      kbo(:, 1,53, 3) = (/ &
     &1.9893e-07_r8,2.3655e-07_r8,2.1398e-07_r8,1.6650e-07_r8,2.3697e-08_r8/)
      kbo(:, 2,53, 3) = (/ &
     &2.5083e-07_r8,3.3159e-07_r8,3.1422e-07_r8,2.5680e-07_r8,3.3792e-08_r8/)
      kbo(:, 3,53, 3) = (/ &
     &3.6925e-07_r8,5.1963e-07_r8,4.9710e-07_r8,4.0705e-07_r8,4.7057e-08_r8/)
      kbo(:, 4,53, 3) = (/ &
     &6.1624e-07_r8,8.5716e-07_r8,8.0760e-07_r8,6.4558e-07_r8,6.4327e-08_r8/)
      kbo(:, 5,53, 3) = (/ &
     &1.0701e-06_r8,1.4207e-06_r8,1.3006e-06_r8,1.0081e-06_r8,8.3703e-08_r8/)
      kbo(:, 1,54, 3) = (/ &
     &1.6569e-07_r8,1.8826e-07_r8,1.6516e-07_r8,1.2463e-07_r8,1.7341e-08_r8/)
      kbo(:, 2,54, 3) = (/ &
     &1.9916e-07_r8,2.5095e-07_r8,2.3323e-07_r8,1.8716e-07_r8,2.4743e-08_r8/)
      kbo(:, 3,54, 3) = (/ &
     &2.7800e-07_r8,3.8083e-07_r8,3.6198e-07_r8,2.9489e-07_r8,3.4593e-08_r8/)
      kbo(:, 4,54, 3) = (/ &
     &4.4953e-07_r8,6.2218e-07_r8,5.8637e-07_r8,4.6947e-07_r8,4.7657e-08_r8/)
      kbo(:, 5,54, 3) = (/ &
     &7.7653e-07_r8,1.0348e-06_r8,9.5106e-07_r8,7.3964e-07_r8,6.2914e-08_r8/)
      kbo(:, 1,55, 3) = (/ &
     &1.4043e-07_r8,1.5348e-07_r8,1.3050e-07_r8,9.5790e-08_r8,1.3021e-08_r8/)
      kbo(:, 2,55, 3) = (/ &
     &1.6195e-07_r8,1.9454e-07_r8,1.7661e-07_r8,1.3842e-07_r8,1.8310e-08_r8/)
      kbo(:, 3,55, 3) = (/ &
     &2.1498e-07_r8,2.8400e-07_r8,2.6714e-07_r8,2.1561e-07_r8,2.5769e-08_r8/)
      kbo(:, 4,55, 3) = (/ &
     &3.3384e-07_r8,4.5663e-07_r8,4.2946e-07_r8,3.4367e-07_r8,3.5731e-08_r8/)
      kbo(:, 5,55, 3) = (/ &
     &5.6980e-07_r8,7.5956e-07_r8,6.9954e-07_r8,5.4544e-07_r8,4.7978e-08_r8/)
      kbo(:, 1,56, 3) = (/ &
     &1.2086e-07_r8,1.2723e-07_r8,1.0539e-07_r8,7.4446e-08_r8,9.2261e-09_r8/)
      kbo(:, 2,56, 3) = (/ &
     &1.3434e-07_r8,1.5407e-07_r8,1.3616e-07_r8,1.0396e-07_r8,1.3447e-08_r8/)
      kbo(:, 3,56, 3) = (/ &
     &1.7000e-07_r8,2.1506e-07_r8,1.9916e-07_r8,1.5861e-07_r8,1.9233e-08_r8/)
      kbo(:, 4,56, 3) = (/ &
     &2.5155e-07_r8,3.3746e-07_r8,3.1592e-07_r8,2.5204e-07_r8,2.6859e-08_r8/)
      kbo(:, 5,56, 3) = (/ &
     &4.2088e-07_r8,5.5907e-07_r8,5.1525e-07_r8,4.0220e-07_r8,3.6549e-08_r8/)
      kbo(:, 1,57, 3) = (/ &
     &1.0553e-07_r8,1.0707e-07_r8,8.7153e-08_r8,5.8944e-08_r8,6.8033e-09_r8/)
      kbo(:, 2,57, 3) = (/ &
     &1.1362e-07_r8,1.2487e-07_r8,1.0708e-07_r8,7.9506e-08_r8,9.8943e-09_r8/)
      kbo(:, 3,57, 3) = (/ &
     &1.3729e-07_r8,1.6577e-07_r8,1.5039e-07_r8,1.1755e-07_r8,1.4310e-08_r8/)
      kbo(:, 4,57, 3) = (/ &
     &1.9303e-07_r8,2.5185e-07_r8,2.3386e-07_r8,1.8533e-07_r8,2.0155e-08_r8/)
      kbo(:, 5,57, 3) = (/ &
     &3.1378e-07_r8,4.1313e-07_r8,3.8025e-07_r8,2.9656e-07_r8,2.7619e-08_r8/)
      kbo(:, 1,58, 3) = (/ &
     &4.5186e-08_r8,5.0890e-08_r8,4.7832e-08_r8,3.7472e-08_r8,5.1696e-09_r8/)
      kbo(:, 2,58, 3) = (/ &
     &4.7401e-08_r8,5.7618e-08_r8,5.6357e-08_r8,4.8955e-08_r8,7.4243e-09_r8/)
      kbo(:, 3,58, 3) = (/ &
     &5.5010e-08_r8,7.2882e-08_r8,7.5797e-08_r8,7.0136e-08_r8,1.0687e-08_r8/)
      kbo(:, 4,58, 3) = (/ &
     &7.3718e-08_r8,1.0653e-07_r8,1.1470e-07_r8,1.0884e-07_r8,1.5198e-08_r8/)
      kbo(:, 5,58, 3) = (/ &
     &1.1547e-07_r8,1.7203e-07_r8,1.8517e-07_r8,1.7422e-07_r8,2.1153e-08_r8/)
      kbo(:, 1,59, 3) = (/ &
     &3.8720e-08_r8,4.3027e-08_r8,4.0190e-08_r8,3.1252e-08_r8,4.1397e-09_r8/)
      kbo(:, 2,59, 3) = (/ &
     &4.0213e-08_r8,4.8103e-08_r8,4.6638e-08_r8,4.0062e-08_r8,6.0380e-09_r8/)
      kbo(:, 3,59, 3) = (/ &
     &4.5994e-08_r8,5.9694e-08_r8,6.1452e-08_r8,5.6505e-08_r8,8.8443e-09_r8/)
      kbo(:, 4,59, 3) = (/ &
     &6.0487e-08_r8,8.5685e-08_r8,9.1743e-08_r8,8.6818e-08_r8,1.2879e-08_r8/)
      kbo(:, 5,59, 3) = (/ &
     &9.3188e-08_r8,1.3722e-07_r8,1.4752e-07_r8,1.3892e-07_r8,1.7999e-08_r8/)
      kbo(:, 1,13, 4) = (/ &
     &4.3869e-03_r8,5.0989e-03_r8,4.3794e-03_r8,3.0521e-03_r8,9.4784e-04_r8/)
      kbo(:, 2,13, 4) = (/ &
     &6.9481e-03_r8,7.8458e-03_r8,6.6078e-03_r8,4.5663e-03_r8,1.0961e-03_r8/)
      kbo(:, 3,13, 4) = (/ &
     &1.1023e-02_r8,1.1980e-02_r8,9.8280e-03_r8,6.7431e-03_r8,1.2240e-03_r8/)
      kbo(:, 4,13, 4) = (/ &
     &1.7316e-02_r8,1.8007e-02_r8,1.4661e-02_r8,9.8568e-03_r8,1.4326e-03_r8/)
      kbo(:, 5,13, 4) = (/ &
     &2.6628e-02_r8,2.6632e-02_r8,2.1301e-02_r8,1.4107e-02_r8,1.6715e-03_r8/)
      kbo(:, 1,14, 4) = (/ &
     &3.8856e-03_r8,4.5615e-03_r8,3.8907e-03_r8,2.6924e-03_r8,7.6763e-04_r8/)
      kbo(:, 2,14, 4) = (/ &
     &6.2253e-03_r8,7.0528e-03_r8,5.8968e-03_r8,4.0418e-03_r8,8.6051e-04_r8/)
      kbo(:, 3,14, 4) = (/ &
     &1.0002e-02_r8,1.0752e-02_r8,8.8582e-03_r8,6.0065e-03_r8,1.0065e-03_r8/)
      kbo(:, 4,14, 4) = (/ &
     &1.5699e-02_r8,1.6229e-02_r8,1.3163e-02_r8,8.7970e-03_r8,1.2227e-03_r8/)
      kbo(:, 5,14, 4) = (/ &
     &2.4269e-02_r8,2.4030e-02_r8,1.9137e-02_r8,1.2536e-02_r8,1.4474e-03_r8/)
      kbo(:, 1,15, 4) = (/ &
     &3.2659e-03_r8,3.8770e-03_r8,3.3101e-03_r8,2.3048e-03_r8,5.7573e-04_r8/)
      kbo(:, 2,15, 4) = (/ &
     &5.3241e-03_r8,6.0372e-03_r8,5.0494e-03_r8,3.4916e-03_r8,6.8321e-04_r8/)
      kbo(:, 3,15, 4) = (/ &
     &8.6002e-03_r8,9.2086e-03_r8,7.6334e-03_r8,5.1974e-03_r8,8.4736e-04_r8/)
      kbo(:, 4,15, 4) = (/ &
     &1.3547e-02_r8,1.3992e-02_r8,1.1347e-02_r8,7.5834e-03_r8,1.0287e-03_r8/)
      kbo(:, 5,15, 4) = (/ &
     &2.1009e-02_r8,2.0762e-02_r8,1.6574e-02_r8,1.0811e-02_r8,1.2066e-03_r8/)
      kbo(:, 1,16, 4) = (/ &
     &2.6697e-03_r8,3.2234e-03_r8,2.7529e-03_r8,1.9451e-03_r8,4.4184e-04_r8/)
      kbo(:, 2,16, 4) = (/ &
     &4.4186e-03_r8,5.0347e-03_r8,4.2523e-03_r8,2.9486e-03_r8,5.5826e-04_r8/)
      kbo(:, 3,16, 4) = (/ &
     &7.1546e-03_r8,7.7280e-03_r8,6.4040e-03_r8,4.4001e-03_r8,6.8881e-04_r8/)
      kbo(:, 4,16, 4) = (/ &
     &1.1406e-02_r8,1.1811e-02_r8,9.5855e-03_r8,6.4241e-03_r8,8.3295e-04_r8/)
      kbo(:, 5,16, 4) = (/ &
     &1.7781e-02_r8,1.7577e-02_r8,1.4001e-02_r8,9.1645e-03_r8,9.7098e-04_r8/)
      kbo(:, 1,17, 4) = (/ &
     &2.1896e-03_r8,2.6538e-03_r8,2.2904e-03_r8,1.6414e-03_r8,3.5480e-04_r8/)
      kbo(:, 2,17, 4) = (/ &
     &3.6444e-03_r8,4.1897e-03_r8,3.5440e-03_r8,2.4805e-03_r8,4.4971e-04_r8/)
      kbo(:, 3,17, 4) = (/ &
     &5.9916e-03_r8,6.4686e-03_r8,5.3743e-03_r8,3.6974e-03_r8,5.5799e-04_r8/)
      kbo(:, 4,17, 4) = (/ &
     &9.5963e-03_r8,9.9128e-03_r8,8.0553e-03_r8,5.4068e-03_r8,6.7241e-04_r8/)
      kbo(:, 5,17, 4) = (/ &
     &1.5025e-02_r8,1.4809e-02_r8,1.1810e-02_r8,7.7160e-03_r8,7.7063e-04_r8/)
      kbo(:, 1,18, 4) = (/ &
     &1.7997e-03_r8,2.1886e-03_r8,1.9082e-03_r8,1.3670e-03_r8,2.9021e-04_r8/)
      kbo(:, 2,18, 4) = (/ &
     &3.0120e-03_r8,3.4746e-03_r8,2.9450e-03_r8,2.0706e-03_r8,3.7282e-04_r8/)
      kbo(:, 3,18, 4) = (/ &
     &4.9798e-03_r8,5.3990e-03_r8,4.4938e-03_r8,3.0816e-03_r8,4.5930e-04_r8/)
      kbo(:, 4,18, 4) = (/ &
     &8.0081e-03_r8,8.2644e-03_r8,6.7223e-03_r8,4.5032e-03_r8,5.4734e-04_r8/)
      kbo(:, 5,18, 4) = (/ &
     &1.2492e-02_r8,1.2373e-02_r8,9.8644e-03_r8,6.4255e-03_r8,6.3020e-04_r8/)
      kbo(:, 1,19, 4) = (/ &
     &1.5064e-03_r8,1.8451e-03_r8,1.6056e-03_r8,1.1522e-03_r8,2.4682e-04_r8/)
      kbo(:, 2,19, 4) = (/ &
     &2.5474e-03_r8,2.9294e-03_r8,2.4915e-03_r8,1.7507e-03_r8,3.1538e-04_r8/)
      kbo(:, 3,19, 4) = (/ &
     &4.2186e-03_r8,4.5798e-03_r8,3.8063e-03_r8,2.5988e-03_r8,3.8674e-04_r8/)
      kbo(:, 4,19, 4) = (/ &
     &6.8019e-03_r8,7.0063e-03_r8,5.6982e-03_r8,3.8032e-03_r8,4.6124e-04_r8/)
      kbo(:, 5,19, 4) = (/ &
     &1.0595e-02_r8,1.0486e-02_r8,8.3528e-03_r8,5.4249e-03_r8,5.3320e-04_r8/)
      kbo(:, 1,20, 4) = (/ &
     &1.3102e-03_r8,1.5983e-03_r8,1.3859e-03_r8,9.9291e-04_r8,2.1228e-04_r8/)
      kbo(:, 2,20, 4) = (/ &
     &2.2269e-03_r8,2.5410e-03_r8,2.1563e-03_r8,1.5072e-03_r8,2.6816e-04_r8/)
      kbo(:, 3,20, 4) = (/ &
     &3.6896e-03_r8,3.9778e-03_r8,3.2977e-03_r8,2.2454e-03_r8,3.2819e-04_r8/)
      kbo(:, 4,20, 4) = (/ &
     &5.9414e-03_r8,6.0960e-03_r8,4.9353e-03_r8,3.2744e-03_r8,3.9225e-04_r8/)
      kbo(:, 5,20, 4) = (/ &
     &9.2578e-03_r8,9.1102e-03_r8,7.2255e-03_r8,4.6712e-03_r8,4.5336e-04_r8/)
      kbo(:, 1,21, 4) = (/ &
     &1.1473e-03_r8,1.3888e-03_r8,1.2016e-03_r8,8.6011e-04_r8,1.8127e-04_r8/)
      kbo(:, 2,21, 4) = (/ &
     &1.9565e-03_r8,2.2181e-03_r8,1.8746e-03_r8,1.3038e-03_r8,2.2830e-04_r8/)
      kbo(:, 3,21, 4) = (/ &
     &3.2520e-03_r8,3.4808e-03_r8,2.8694e-03_r8,1.9461e-03_r8,2.7800e-04_r8/)
      kbo(:, 4,21, 4) = (/ &
     &5.2204e-03_r8,5.3317e-03_r8,4.2972e-03_r8,2.8342e-03_r8,3.3105e-04_r8/)
      kbo(:, 5,21, 4) = (/ &
     &8.1069e-03_r8,7.9508e-03_r8,6.2747e-03_r8,4.0360e-03_r8,3.8585e-04_r8/)
      kbo(:, 1,22, 4) = (/ &
     &1.0382e-03_r8,1.2396e-03_r8,1.0678e-03_r8,7.6273e-04_r8,1.5466e-04_r8/)
      kbo(:, 2,22, 4) = (/ &
     &1.7720e-03_r8,1.9893e-03_r8,1.6695e-03_r8,1.1556e-03_r8,1.9356e-04_r8/)
      kbo(:, 3,22, 4) = (/ &
     &2.9369e-03_r8,3.1200e-03_r8,2.5557e-03_r8,1.7237e-03_r8,2.3624e-04_r8/)
      kbo(:, 4,22, 4) = (/ &
     &4.6992e-03_r8,4.7636e-03_r8,3.8178e-03_r8,2.5063e-03_r8,2.7855e-04_r8/)
      kbo(:, 5,22, 4) = (/ &
     &7.2282e-03_r8,7.0542e-03_r8,5.5487e-03_r8,3.5490e-03_r8,3.2630e-04_r8/)
      kbo(:, 1,23, 4) = (/ &
     &9.4131e-04_r8,1.1095e-03_r8,9.5148e-04_r8,6.7660e-04_r8,1.3244e-04_r8/)
      kbo(:, 2,23, 4) = (/ &
     &1.6035e-03_r8,1.7844e-03_r8,1.4894e-03_r8,1.0262e-03_r8,1.6442e-04_r8/)
      kbo(:, 3,23, 4) = (/ &
     &2.6522e-03_r8,2.7950e-03_r8,2.2775e-03_r8,1.5271e-03_r8,2.0008e-04_r8/)
      kbo(:, 4,23, 4) = (/ &
     &4.2106e-03_r8,4.2402e-03_r8,3.3871e-03_r8,2.2131e-03_r8,2.3445e-04_r8/)
      kbo(:, 5,23, 4) = (/ &
     &6.4196e-03_r8,6.2427e-03_r8,4.8940e-03_r8,3.1130e-03_r8,2.7496e-04_r8/)
      kbo(:, 1,24, 4) = (/ &
     &8.5493e-04_r8,1.0008e-03_r8,8.5274e-04_r8,6.0213e-04_r8,1.1224e-04_r8/)
      kbo(:, 2,24, 4) = (/ &
     &1.4576e-03_r8,1.6070e-03_r8,1.3354e-03_r8,9.1642e-04_r8,1.3965e-04_r8/)
      kbo(:, 3,24, 4) = (/ &
     &2.4005e-03_r8,2.5083e-03_r8,2.0375e-03_r8,1.3606e-03_r8,1.6869e-04_r8/)
      kbo(:, 4,24, 4) = (/ &
     &3.7805e-03_r8,3.7882e-03_r8,3.0168e-03_r8,1.9590e-03_r8,1.9824e-04_r8/)
      kbo(:, 5,24, 4) = (/ &
     &5.7340e-03_r8,5.5429e-03_r8,4.3252e-03_r8,2.7397e-03_r8,2.2899e-04_r8/)
      kbo(:, 1,25, 4) = (/ &
     &7.8083e-04_r8,9.0613e-04_r8,7.6855e-04_r8,5.3955e-04_r8,9.3397e-05_r8/)
      kbo(:, 2,25, 4) = (/ &
     &1.3293e-03_r8,1.4516e-03_r8,1.2021e-03_r8,8.2125e-04_r8,1.1644e-04_r8/)
      kbo(:, 3,25, 4) = (/ &
     &2.1730e-03_r8,2.2546e-03_r8,1.8276e-03_r8,1.2136e-03_r8,1.4039e-04_r8/)
      kbo(:, 4,25, 4) = (/ &
     &3.3994e-03_r8,3.3901e-03_r8,2.6854e-03_r8,1.7374e-03_r8,1.6529e-04_r8/)
      kbo(:, 5,25, 4) = (/ &
     &5.1177e-03_r8,4.9296e-03_r8,3.8308e-03_r8,2.4138e-03_r8,1.9292e-04_r8/)
      kbo(:, 1,26, 4) = (/ &
     &7.2414e-04_r8,8.2998e-04_r8,6.9991e-04_r8,4.8962e-04_r8,7.9259e-05_r8/)
      kbo(:, 2,26, 4) = (/ &
     &1.2259e-03_r8,1.3255e-03_r8,1.0917e-03_r8,7.4177e-04_r8,9.7580e-05_r8/)
      kbo(:, 3,26, 4) = (/ &
     &1.9848e-03_r8,2.0462e-03_r8,1.6503e-03_r8,1.0895e-03_r8,1.1629e-04_r8/)
      kbo(:, 4,26, 4) = (/ &
     &3.0863e-03_r8,3.0554e-03_r8,2.4123e-03_r8,1.5502e-03_r8,1.3732e-04_r8/)
      kbo(:, 5,26, 4) = (/ &
     &4.5999e-03_r8,4.4081e-03_r8,3.4159e-03_r8,2.1402e-03_r8,1.6386e-04_r8/)
      kbo(:, 1,27, 4) = (/ &
     &6.7040e-04_r8,7.6049e-04_r8,6.3931e-04_r8,4.4424e-04_r8,6.5890e-05_r8/)
      kbo(:, 2,27, 4) = (/ &
     &1.1282e-03_r8,1.2096e-03_r8,9.9105e-04_r8,6.6941e-04_r8,8.0876e-05_r8/)
      kbo(:, 3,27, 4) = (/ &
     &1.8147e-03_r8,1.8556e-03_r8,1.4889e-03_r8,9.7714e-04_r8,9.6344e-05_r8/)
      kbo(:, 4,27, 4) = (/ &
     &2.7940e-03_r8,2.7516e-03_r8,2.1627e-03_r8,1.3811e-03_r8,1.1546e-04_r8/)
      kbo(:, 5,27, 4) = (/ &
     &4.1206e-03_r8,3.9340e-03_r8,3.0363e-03_r8,1.8956e-03_r8,1.3791e-04_r8/)
      kbo(:, 1,28, 4) = (/ &
     &6.1963e-04_r8,6.9617e-04_r8,5.8205e-04_r8,4.0239e-04_r8,5.3842e-05_r8/)
      kbo(:, 2,28, 4) = (/ &
     &1.0354e-03_r8,1.1013e-03_r8,8.9815e-04_r8,6.0298e-04_r8,6.6022e-05_r8/)
      kbo(:, 3,28, 4) = (/ &
     &1.6516e-03_r8,1.6797e-03_r8,1.3412e-03_r8,8.7507e-04_r8,8.0123e-05_r8/)
      kbo(:, 4,28, 4) = (/ &
     &2.5197e-03_r8,2.4709e-03_r8,1.9338e-03_r8,1.2274e-03_r8,9.7074e-05_r8/)
      kbo(:, 5,28, 4) = (/ &
     &3.6744e-03_r8,3.4958e-03_r8,2.6900e-03_r8,1.6731e-03_r8,1.1603e-04_r8/)
      kbo(:, 1,29, 4) = (/ &
     &5.7255e-04_r8,6.3719e-04_r8,5.3001e-04_r8,3.6415e-04_r8,4.3783e-05_r8/)
      kbo(:, 2,29, 4) = (/ &
     &9.4899e-04_r8,1.0006e-03_r8,8.1341e-04_r8,5.4243e-04_r8,5.3930e-05_r8/)
      kbo(:, 3,29, 4) = (/ &
     &1.4973e-03_r8,1.5143e-03_r8,1.2048e-03_r8,7.8083e-04_r8,6.6803e-05_r8/)
      kbo(:, 4,29, 4) = (/ &
     &2.2572e-03_r8,2.2044e-03_r8,1.7199e-03_r8,1.0861e-03_r8,8.0985e-05_r8/)
      kbo(:, 5,29, 4) = (/ &
     &3.2527e-03_r8,3.0849e-03_r8,2.3685e-03_r8,1.4686e-03_r8,9.6201e-05_r8/)
      kbo(:, 1,30, 4) = (/ &
     &5.2637e-04_r8,5.8081e-04_r8,4.8010e-04_r8,3.2816e-04_r8,3.5536e-05_r8/)
      kbo(:, 2,30, 4) = (/ &
     &8.6289e-04_r8,9.0357e-04_r8,7.3215e-04_r8,4.8521e-04_r8,4.4824e-05_r8/)
      kbo(:, 3,30, 4) = (/ &
     &1.3456e-03_r8,1.3553e-03_r8,1.0747e-03_r8,6.9223e-04_r8,5.5319e-05_r8/)
      kbo(:, 4,30, 4) = (/ &
     &2.0065e-03_r8,1.9507e-03_r8,1.5172e-03_r8,9.5518e-04_r8,6.6828e-05_r8/)
      kbo(:, 5,30, 4) = (/ &
     &2.8573e-03_r8,2.7008e-03_r8,2.0712e-03_r8,1.2802e-03_r8,7.9313e-05_r8/)
      kbo(:, 1,31, 4) = (/ &
     &4.7945e-04_r8,5.2447e-04_r8,4.3249e-04_r8,2.9383e-04_r8,2.9390e-05_r8/)
      kbo(:, 2,31, 4) = (/ &
     &7.7587e-04_r8,8.0972e-04_r8,6.5328e-04_r8,4.3065e-04_r8,3.6906e-05_r8/)
      kbo(:, 3,31, 4) = (/ &
     &1.1974e-03_r8,1.2004e-03_r8,9.4868e-04_r8,6.0827e-04_r8,4.5016e-05_r8/)
      kbo(:, 4,31, 4) = (/ &
     &1.7617e-03_r8,1.7074e-03_r8,1.3255e-03_r8,8.3172e-04_r8,5.4252e-05_r8/)
      kbo(:, 5,31, 4) = (/ &
     &2.4825e-03_r8,2.3423e-03_r8,1.7933e-03_r8,1.1061e-03_r8,6.4138e-05_r8/)
      kbo(:, 1,32, 4) = (/ &
     &4.3738e-04_r8,4.7509e-04_r8,3.9041e-04_r8,2.6369e-04_r8,2.4019e-05_r8/)
      kbo(:, 2,32, 4) = (/ &
     &6.9937e-04_r8,7.2599e-04_r8,5.8354e-04_r8,3.8245e-04_r8,2.9892e-05_r8/)
      kbo(:, 3,32, 4) = (/ &
     &1.0660e-03_r8,1.0639e-03_r8,8.3776e-04_r8,5.3497e-04_r8,3.6437e-05_r8/)
      kbo(:, 4,32, 4) = (/ &
     &1.5490e-03_r8,1.4965e-03_r8,1.1588e-03_r8,7.2497e-04_r8,4.3698e-05_r8/)
      kbo(:, 5,32, 4) = (/ &
     &2.1609e-03_r8,2.0352e-03_r8,1.5553e-03_r8,9.5666e-04_r8,5.1532e-05_r8/)
      kbo(:, 1,33, 4) = (/ &
     &3.9889e-04_r8,4.2999e-04_r8,3.5197e-04_r8,2.3634e-04_r8,1.9311e-05_r8/)
      kbo(:, 2,33, 4) = (/ &
     &6.2991e-04_r8,6.5021e-04_r8,5.2059e-04_r8,3.3932e-04_r8,2.4117e-05_r8/)
      kbo(:, 3,33, 4) = (/ &
     &9.4755e-04_r8,9.4129e-04_r8,7.3904e-04_r8,4.6991e-04_r8,2.9354e-05_r8/)
      kbo(:, 4,33, 4) = (/ &
     &1.3617e-03_r8,1.3113e-03_r8,1.0129e-03_r8,6.3180e-04_r8,3.5029e-05_r8/)
      kbo(:, 5,33, 4) = (/ &
     &1.8805e-03_r8,1.7688e-03_r8,1.3485e-03_r8,8.2760e-04_r8,4.1309e-05_r8/)
      kbo(:, 1,34, 4) = (/ &
     &3.6214e-04_r8,3.8716e-04_r8,3.1549e-04_r8,2.1059e-04_r8,1.5692e-05_r8/)
      kbo(:, 2,34, 4) = (/ &
     &5.6474e-04_r8,5.7963e-04_r8,4.6204e-04_r8,2.9966e-04_r8,1.9450e-05_r8/)
      kbo(:, 3,34, 4) = (/ &
     &8.4034e-04_r8,8.3067e-04_r8,6.4971e-04_r8,4.1144e-04_r8,2.3693e-05_r8/)
      kbo(:, 4,34, 4) = (/ &
     &1.1957e-03_r8,1.1475e-03_r8,8.8389e-04_r8,5.4962e-04_r8,2.8253e-05_r8/)
      kbo(:, 5,34, 4) = (/ &
     &1.6380e-03_r8,1.5373e-03_r8,1.1695e-03_r8,7.1576e-04_r8,3.2957e-05_r8/)
      kbo(:, 1,35, 4) = (/ &
     &3.1359e-04_r8,3.3446e-04_r8,2.7193e-04_r8,1.8091e-04_r8,1.2437e-05_r8/)
      kbo(:, 2,35, 4) = (/ &
     &4.8583e-04_r8,4.9752e-04_r8,3.9566e-04_r8,2.5593e-04_r8,1.5305e-05_r8/)
      kbo(:, 3,35, 4) = (/ &
     &7.1875e-04_r8,7.0909e-04_r8,5.5358e-04_r8,3.4993e-04_r8,1.8635e-05_r8/)
      kbo(:, 4,35, 4) = (/ &
     &1.0171e-03_r8,9.7513e-04_r8,7.5023e-04_r8,4.6569e-04_r8,2.2205e-05_r8/)
      kbo(:, 5,35, 4) = (/ &
     &1.3872e-03_r8,1.3015e-03_r8,9.8912e-04_r8,6.0449e-04_r8,2.6045e-05_r8/)
      kbo(:, 1,36, 4) = (/ &
     &2.5808e-04_r8,2.7599e-04_r8,2.2440e-04_r8,1.4937e-04_r8,9.6631e-06_r8/)
      kbo(:, 2,36, 4) = (/ &
     &3.9964e-04_r8,4.1003e-04_r8,3.2602e-04_r8,2.1097e-04_r8,1.1834e-05_r8/)
      kbo(:, 3,36, 4) = (/ &
     &5.9092e-04_r8,5.8383e-04_r8,4.5590e-04_r8,2.8824e-04_r8,1.4353e-05_r8/)
      kbo(:, 4,36, 4) = (/ &
     &8.3595e-04_r8,8.0277e-04_r8,6.1763e-04_r8,3.8334e-04_r8,1.7189e-05_r8/)
      kbo(:, 5,36, 4) = (/ &
     &1.1396e-03_r8,1.0707e-03_r8,8.1375e-04_r8,4.9743e-04_r8,2.0326e-05_r8/)
      kbo(:, 1,37, 4) = (/ &
     &2.0121e-04_r8,2.1647e-04_r8,1.7647e-04_r8,1.1785e-04_r8,7.4310e-06_r8/)
      kbo(:, 2,37, 4) = (/ &
     &3.1330e-04_r8,3.2327e-04_r8,2.5768e-04_r8,1.6717e-04_r8,9.1199e-06_r8/)
      kbo(:, 3,37, 4) = (/ &
     &4.6580e-04_r8,4.6262e-04_r8,3.6181e-04_r8,2.2919e-04_r8,1.1050e-05_r8/)
      kbo(:, 4,37, 4) = (/ &
     &6.6212e-04_r8,6.3859e-04_r8,4.9190e-04_r8,3.0576e-04_r8,1.3280e-05_r8/)
      kbo(:, 5,37, 4) = (/ &
     &9.0672e-04_r8,8.5472e-04_r8,6.5027e-04_r8,3.9796e-04_r8,1.5719e-05_r8/)
      kbo(:, 1,38, 4) = (/ &
     &1.5610e-04_r8,1.6913e-04_r8,1.3823e-04_r8,9.2645e-05_r8,5.6716e-06_r8/)
      kbo(:, 2,38, 4) = (/ &
     &2.4467e-04_r8,2.5398e-04_r8,2.0295e-04_r8,1.3206e-04_r8,6.9811e-06_r8/)
      kbo(:, 3,38, 4) = (/ &
     &3.6591e-04_r8,3.6541e-04_r8,2.8633e-04_r8,1.8175e-04_r8,8.4645e-06_r8/)
      kbo(:, 4,38, 4) = (/ &
     &5.2302e-04_r8,5.0671e-04_r8,3.9077e-04_r8,2.4331e-04_r8,1.0160e-05_r8/)
      kbo(:, 5,38, 4) = (/ &
     &7.1953e-04_r8,6.8071e-04_r8,5.1841e-04_r8,3.1771e-04_r8,1.2087e-05_r8/)
      kbo(:, 1,39, 4) = (/ &
     &1.2096e-04_r8,1.3199e-04_r8,1.0815e-04_r8,7.2736e-05_r8,4.3132e-06_r8/)
      kbo(:, 2,39, 4) = (/ &
     &1.9086e-04_r8,1.9937e-04_r8,1.5970e-04_r8,1.0426e-04_r8,5.3181e-06_r8/)
      kbo(:, 3,39, 4) = (/ &
     &2.8720e-04_r8,2.8844e-04_r8,2.2641e-04_r8,1.4405e-04_r8,6.4566e-06_r8/)
      kbo(:, 4,39, 4) = (/ &
     &4.1286e-04_r8,4.0180e-04_r8,3.1020e-04_r8,1.9350e-04_r8,7.7296e-06_r8/)
      kbo(:, 5,39, 4) = (/ &
     &5.7063e-04_r8,5.4191e-04_r8,4.1317e-04_r8,2.5355e-04_r8,9.2083e-06_r8/)
      kbo(:, 1,40, 4) = (/ &
     &9.0120e-05_r8,9.9405e-05_r8,8.1774e-05_r8,5.5348e-05_r8,3.2802e-06_r8/)
      kbo(:, 2,40, 4) = (/ &
     &1.4396e-04_r8,1.5172e-04_r8,1.2199e-04_r8,8.0081e-05_r8,4.0450e-06_r8/)
      kbo(:, 3,40, 4) = (/ &
     &2.1897e-04_r8,2.2172e-04_r8,1.7453e-04_r8,1.1150e-04_r8,4.9391e-06_r8/)
      kbo(:, 4,40, 4) = (/ &
     &3.1818e-04_r8,3.1148e-04_r8,2.4096e-04_r8,1.5075e-04_r8,5.9260e-06_r8/)
      kbo(:, 5,40, 4) = (/ &
     &4.4338e-04_r8,4.2299e-04_r8,3.2304e-04_r8,1.9869e-04_r8,7.0429e-06_r8/)
      kbo(:, 1,41, 4) = (/ &
     &6.6586e-05_r8,7.4344e-05_r8,6.1391e-05_r8,4.1826e-05_r8,2.4789e-06_r8/)
      kbo(:, 2,41, 4) = (/ &
     &1.0786e-04_r8,1.1471e-04_r8,9.2627e-05_r8,6.1134e-05_r8,3.0831e-06_r8/)
      kbo(:, 3,41, 4) = (/ &
     &1.6588e-04_r8,1.6943e-04_r8,1.3383e-04_r8,8.5899e-05_r8,3.7712e-06_r8/)
      kbo(:, 4,41, 4) = (/ &
     &2.4383e-04_r8,2.4037e-04_r8,1.8645e-04_r8,1.1700e-04_r8,4.5478e-06_r8/)
      kbo(:, 5,41, 4) = (/ &
     &3.4300e-04_r8,3.2889e-04_r8,2.5168e-04_r8,1.5514e-04_r8,5.3910e-06_r8/)
      kbo(:, 1,42, 4) = (/ &
     &4.8998e-05_r8,5.5419e-05_r8,4.5947e-05_r8,3.1516e-05_r8,1.8667e-06_r8/)
      kbo(:, 2,42, 4) = (/ &
     &8.0484e-05_r8,8.6481e-05_r8,7.0103e-05_r8,4.6544e-05_r8,2.3354e-06_r8/)
      kbo(:, 3,42, 4) = (/ &
     &1.2531e-04_r8,1.2923e-04_r8,1.0238e-04_r8,6.6044e-05_r8,2.8708e-06_r8/)
      kbo(:, 4,42, 4) = (/ &
     &1.8633e-04_r8,1.8503e-04_r8,1.4397e-04_r8,9.0645e-05_r8,3.4606e-06_r8/)
      kbo(:, 5,42, 4) = (/ &
     &2.6476e-04_r8,2.5534e-04_r8,1.9578e-04_r8,1.2098e-04_r8,4.1084e-06_r8/)
      kbo(:, 1,43, 4) = (/ &
     &3.5242e-05_r8,4.0436e-05_r8,3.3714e-05_r8,2.3281e-05_r8,1.3919e-06_r8/)
      kbo(:, 2,43, 4) = (/ &
     &5.8897e-05_r8,6.4054e-05_r8,5.2168e-05_r8,3.4865e-05_r8,1.7548e-06_r8/)
      kbo(:, 3,43, 4) = (/ &
     &9.3170e-05_r8,9.7046e-05_r8,7.7251e-05_r8,5.0106e-05_r8,2.1668e-06_r8/)
      kbo(:, 4,43, 4) = (/ &
     &1.4048e-04_r8,1.4075e-04_r8,1.0986e-04_r8,6.9448e-05_r8,2.6074e-06_r8/)
      kbo(:, 5,43, 4) = (/ &
     &2.0220e-04_r8,1.9644e-04_r8,1.5089e-04_r8,9.3492e-05_r8,3.1278e-06_r8/)
      kbo(:, 1,44, 4) = (/ &
     &2.5004e-05_r8,2.9138e-05_r8,2.4437e-05_r8,1.6989e-05_r8,1.0250e-06_r8/)
      kbo(:, 2,44, 4) = (/ &
     &4.2585e-05_r8,4.6938e-05_r8,3.8422e-05_r8,2.5865e-05_r8,1.3112e-06_r8/)
      kbo(:, 3,44, 4) = (/ &
     &6.8563e-05_r8,7.2232e-05_r8,5.7761e-05_r8,3.7700e-05_r8,1.6186e-06_r8/)
      kbo(:, 4,44, 4) = (/ &
     &1.0501e-04_r8,1.0630e-04_r8,8.3253e-05_r8,5.2860e-05_r8,1.9651e-06_r8/)
      kbo(:, 5,44, 4) = (/ &
     &1.5343e-04_r8,1.5019e-04_r8,1.1567e-04_r8,7.1872e-05_r8,2.3710e-06_r8/)
      kbo(:, 1,45, 4) = (/ &
     &1.7648e-05_r8,2.0899e-05_r8,1.7624e-05_r8,1.2332e-05_r8,7.4778e-07_r8/)
      kbo(:, 2,45, 4) = (/ &
     &3.0648e-05_r8,3.4228e-05_r8,2.8145e-05_r8,1.9101e-05_r8,9.7150e-07_r8/)
      kbo(:, 3,45, 4) = (/ &
     &5.0244e-05_r8,5.3520e-05_r8,4.3001e-05_r8,2.8243e-05_r8,1.2073e-06_r8/)
      kbo(:, 4,45, 4) = (/ &
     &7.8191e-05_r8,7.9995e-05_r8,6.2888e-05_r8,4.0157e-05_r8,1.4831e-06_r8/)
      kbo(:, 5,45, 4) = (/ &
     &1.1605e-04_r8,1.1449e-04_r8,8.8448e-05_r8,5.5140e-05_r8,1.7858e-06_r8/)
      kbo(:, 1,46, 4) = (/ &
     &1.2241e-05_r8,1.4754e-05_r8,1.2528e-05_r8,8.8151e-06_r8,5.3848e-07_r8/)
      kbo(:, 2,46, 4) = (/ &
     &2.1731e-05_r8,2.4625e-05_r8,2.0352e-05_r8,1.3921e-05_r8,7.0792e-07_r8/)
      kbo(:, 3,46, 4) = (/ &
     &3.6328e-05_r8,3.9139e-05_r8,3.1626e-05_r8,2.0940e-05_r8,8.9555e-07_r8/)
      kbo(:, 4,46, 4) = (/ &
     &5.7531e-05_r8,5.9510e-05_r8,4.7024e-05_r8,3.0210e-05_r8,1.1090e-06_r8/)
      kbo(:, 5,46, 4) = (/ &
     &8.6821e-05_r8,8.6443e-05_r8,6.7046e-05_r8,4.1968e-05_r8,1.3451e-06_r8/)
      kbo(:, 1,47, 4) = (/ &
     &8.2449e-06_r8,1.0146e-05_r8,8.6807e-06_r8,6.1518e-06_r8,3.8332e-07_r8/)
      kbo(:, 2,47, 4) = (/ &
     &1.4999e-05_r8,1.7293e-05_r8,1.4384e-05_r8,9.9184e-06_r8,5.1069e-07_r8/)
      kbo(:, 3,47, 4) = (/ &
     &2.5663e-05_r8,2.8031e-05_r8,2.2776e-05_r8,1.5214e-05_r8,6.5507e-07_r8/)
      kbo(:, 4,47, 4) = (/ &
     &4.1483e-05_r8,4.3442e-05_r8,3.4514e-05_r8,2.2339e-05_r8,8.2140e-07_r8/)
      kbo(:, 5,47, 4) = (/ &
     &6.3807e-05_r8,6.4263e-05_r8,5.0034e-05_r8,3.1504e-05_r8,1.0057e-06_r8/)
      kbo(:, 1,48, 4) = (/ &
     &5.5161e-06_r8,6.9345e-06_r8,5.9711e-06_r8,4.2630e-06_r8,2.7090e-07_r8/)
      kbo(:, 2,48, 4) = (/ &
     &1.0274e-05_r8,1.2067e-05_r8,1.0101e-05_r8,7.0075e-06_r8,3.6468e-07_r8/)
      kbo(:, 3,48, 4) = (/ &
     &1.7999e-05_r8,1.9964e-05_r8,1.6291e-05_r8,1.0982e-05_r8,4.7593e-07_r8/)
      kbo(:, 4,48, 4) = (/ &
     &2.9748e-05_r8,3.1502e-05_r8,2.5173e-05_r8,1.6424e-05_r8,6.0510e-07_r8/)
      kbo(:, 5,48, 4) = (/ &
     &4.6627e-05_r8,4.7519e-05_r8,3.7159e-05_r8,2.3556e-05_r8,7.4697e-07_r8/)
      kbo(:, 1,49, 4) = (/ &
     &3.6712e-06_r8,4.7085e-06_r8,4.0821e-06_r8,2.9344e-06_r8,1.8902e-07_r8/)
      kbo(:, 2,49, 4) = (/ &
     &6.9808e-06_r8,8.3574e-06_r8,7.0495e-06_r8,4.9158e-06_r8,2.5862e-07_r8/)
      kbo(:, 3,49, 4) = (/ &
     &1.2533e-05_r8,1.4129e-05_r8,1.1598e-05_r8,7.8741e-06_r8,3.4164e-07_r8/)
      kbo(:, 4,49, 4) = (/ &
     &2.1199e-05_r8,2.2725e-05_r8,1.8253e-05_r8,1.2008e-05_r8,4.3895e-07_r8/)
      kbo(:, 5,49, 4) = (/ &
     &3.3893e-05_r8,3.4945e-05_r8,2.7461e-05_r8,1.7529e-05_r8,5.4985e-07_r8/)
      kbo(:, 1,50, 4) = (/ &
     &2.4835e-06_r8,3.2299e-06_r8,2.8168e-06_r8,2.0358e-06_r8,1.3342e-07_r8/)
      kbo(:, 2,50, 4) = (/ &
     &4.7895e-06_r8,5.8338e-06_r8,4.9516e-06_r8,3.4721e-06_r8,1.8475e-07_r8/)
      kbo(:, 3,50, 4) = (/ &
     &8.7933e-06_r8,1.0062e-05_r8,8.3077e-06_r8,5.6722e-06_r8,2.4761e-07_r8/)
      kbo(:, 4,50, 4) = (/ &
     &1.5202e-05_r8,1.6503e-05_r8,1.3305e-05_r8,8.8168e-06_r8,3.2240e-07_r8/)
      kbo(:, 5,50, 4) = (/ &
     &2.4800e-05_r8,2.5828e-05_r8,2.0397e-05_r8,1.3093e-05_r8,4.0814e-07_r8/)
      kbo(:, 1,51, 4) = (/ &
     &1.7011e-06_r8,2.2256e-06_r8,1.9504e-06_r8,1.4154e-06_r8,9.4900e-08_r8/)
      kbo(:, 2,51, 4) = (/ &
     &3.2953e-06_r8,4.0790e-06_r8,3.4794e-06_r8,2.4537e-06_r8,1.3273e-07_r8/)
      kbo(:, 3,51, 4) = (/ &
     &6.1746e-06_r8,7.1689e-06_r8,5.9544e-06_r8,4.0832e-06_r8,1.8014e-07_r8/)
      kbo(:, 4,51, 4) = (/ &
     &1.0912e-05_r8,1.1993e-05_r8,9.7046e-06_r8,6.4754e-06_r8,2.3777e-07_r8/)
      kbo(:, 5,51, 4) = (/ &
     &1.8173e-05_r8,1.9097e-05_r8,1.5144e-05_r8,9.7867e-06_r8,3.0334e-07_r8/)
      kbo(:, 1,52, 4) = (/ &
     &1.1779e-06_r8,1.5381e-06_r8,1.3497e-06_r8,9.8158e-07_r8,6.6305e-08_r8/)
      kbo(:, 2,52, 4) = (/ &
     &2.2623e-06_r8,2.8412e-06_r8,2.4342e-06_r8,1.7266e-06_r8,9.4865e-08_r8/)
      kbo(:, 3,52, 4) = (/ &
     &4.3170e-06_r8,5.0854e-06_r8,4.2468e-06_r8,2.9260e-06_r8,1.3026e-07_r8/)
      kbo(:, 4,52, 4) = (/ &
     &7.7969e-06_r8,8.6772e-06_r8,7.0531e-06_r8,4.7333e-06_r8,1.7384e-07_r8/)
      kbo(:, 5,52, 4) = (/ &
     &1.3261e-05_r8,1.4075e-05_r8,1.1203e-05_r8,7.2837e-06_r8,2.2485e-07_r8/)
      kbo(:, 1,53, 4) = (/ &
     &8.3089e-07_r8,1.0687e-06_r8,9.3518e-07_r8,6.7997e-07_r8,4.5831e-08_r8/)
      kbo(:, 2,53, 4) = (/ &
     &1.5556e-06_r8,1.9711e-06_r8,1.6966e-06_r8,1.2083e-06_r8,6.7497e-08_r8/)
      kbo(:, 3,53, 4) = (/ &
     &3.0048e-06_r8,3.5908e-06_r8,3.0131e-06_r8,2.0844e-06_r8,9.3485e-08_r8/)
      kbo(:, 4,53, 4) = (/ &
     &5.5438e-06_r8,6.2468e-06_r8,5.1016e-06_r8,3.4387e-06_r8,1.2594e-07_r8/)
      kbo(:, 5,53, 4) = (/ &
     &9.6328e-06_r8,1.0329e-05_r8,8.2446e-06_r8,5.3978e-06_r8,1.6450e-07_r8/)
      kbo(:, 1,54, 4) = (/ &
     &6.1034e-07_r8,7.6407e-07_r8,6.6371e-07_r8,4.8016e-07_r8,3.1960e-08_r8/)
      kbo(:, 2,54, 4) = (/ &
     &1.0977e-06_r8,1.3930e-06_r8,1.2021e-06_r8,8.5784e-07_r8,4.9012e-08_r8/)
      kbo(:, 3,54, 4) = (/ &
     &2.1270e-06_r8,2.5705e-06_r8,2.1637e-06_r8,1.5024e-06_r8,6.8673e-08_r8/)
      kbo(:, 4,54, 4) = (/ &
     &3.9965e-06_r8,4.5514e-06_r8,3.7320e-06_r8,2.5226e-06_r8,9.3587e-08_r8/)
      kbo(:, 5,54, 4) = (/ &
     &7.0830e-06_r8,7.6654e-06_r8,6.1329e-06_r8,4.0351e-06_r8,1.2382e-07_r8/)
      kbo(:, 1,55, 4) = (/ &
     &4.6385e-07_r8,5.5921e-07_r8,4.8019e-07_r8,3.4337e-07_r8,2.2394e-08_r8/)
      kbo(:, 2,55, 4) = (/ &
     &7.8989e-07_r8,9.9640e-07_r8,8.5986e-07_r8,6.1313e-07_r8,3.5977e-08_r8/)
      kbo(:, 3,55, 4) = (/ &
     &1.5192e-06_r8,1.8516e-06_r8,1.5624e-06_r8,1.0878e-06_r8,5.1500e-08_r8/)
      kbo(:, 4,55, 4) = (/ &
     &2.8980e-06_r8,3.3321e-06_r8,2.7426e-06_r8,1.8581e-06_r8,7.0762e-08_r8/)
      kbo(:, 5,55, 4) = (/ &
     &5.2356e-06_r8,5.7136e-06_r8,4.5826e-06_r8,3.0253e-06_r8,9.4338e-08_r8/)
      kbo(:, 1,56, 4) = (/ &
     &3.6371e-07_r8,4.1822e-07_r8,3.5281e-07_r8,2.4786e-07_r8,1.6072e-08_r8/)
      kbo(:, 2,56, 4) = (/ &
     &5.7786e-07_r8,7.1776e-07_r8,6.1684e-07_r8,4.3889e-07_r8,2.6450e-08_r8/)
      kbo(:, 3,56, 4) = (/ &
     &1.0893e-06_r8,1.3335e-06_r8,1.1271e-06_r8,7.8636e-07_r8,3.8603e-08_r8/)
      kbo(:, 4,56, 4) = (/ &
     &2.1010e-06_r8,2.4368e-06_r8,2.0114e-06_r8,1.3652e-06_r8,5.3303e-08_r8/)
      kbo(:, 5,56, 4) = (/ &
     &3.8675e-06_r8,4.2536e-06_r8,3.4205e-06_r8,2.2622e-06_r8,7.1626e-08_r8/)
      kbo(:, 1,57, 4) = (/ &
     &2.9431e-07_r8,3.2133e-07_r8,2.6457e-07_r8,1.8146e-07_r8,1.1259e-08_r8/)
      kbo(:, 2,57, 4) = (/ &
     &4.3212e-07_r8,5.2280e-07_r8,4.4601e-07_r8,3.1527e-07_r8,1.9122e-08_r8/)
      kbo(:, 3,57, 4) = (/ &
     &7.8679e-07_r8,9.6129e-07_r8,8.1340e-07_r8,5.6766e-07_r8,2.8681e-08_r8/)
      kbo(:, 4,57, 4) = (/ &
     &1.5240e-06_r8,1.7810e-06_r8,1.4725e-06_r8,1.0013e-06_r8,4.0212e-08_r8/)
      kbo(:, 5,57, 4) = (/ &
     &2.8546e-06_r8,3.1617e-06_r8,2.5494e-06_r8,1.6875e-06_r8,5.4480e-08_r8/)
      kbo(:, 1,58, 4) = (/ &
     &1.1920e-07_r8,1.4193e-07_r8,1.3380e-07_r8,1.0782e-07_r8,7.9525e-09_r8/)
      kbo(:, 2,58, 4) = (/ &
     &1.6186e-07_r8,2.1696e-07_r8,2.1477e-07_r8,1.8165e-07_r8,1.3814e-08_r8/)
      kbo(:, 3,58, 4) = (/ &
     &2.8087e-07_r8,3.9076e-07_r8,3.8760e-07_r8,3.2679e-07_r8,2.1394e-08_r8/)
      kbo(:, 4,58, 4) = (/ &
     &5.4191e-07_r8,7.3009e-07_r8,7.0916e-07_r8,5.8413e-07_r8,3.0724e-08_r8/)
      kbo(:, 5,58, 4) = (/ &
     &1.0299e-06_r8,1.3167e-06_r8,1.2488e-06_r8,1.0008e-06_r8,4.1885e-08_r8/)
      kbo(:, 1,59, 4) = (/ &
     &1.0039e-07_r8,1.1714e-07_r8,1.0974e-07_r8,8.7504e-08_r8,6.4674e-09_r8/)
      kbo(:, 2,59, 4) = (/ &
     &1.3241e-07_r8,1.7435e-07_r8,1.7189e-07_r8,1.4496e-07_r8,1.1458e-08_r8/)
      kbo(:, 3,59, 4) = (/ &
     &2.2493e-07_r8,3.1060e-07_r8,3.0841e-07_r8,2.6052e-07_r8,1.7735e-08_r8/)
      kbo(:, 4,59, 4) = (/ &
     &4.3202e-07_r8,5.8172e-07_r8,5.6654e-07_r8,4.6829e-07_r8,2.5818e-08_r8/)
      kbo(:, 5,59, 4) = (/ &
     &8.2523e-07_r8,1.0563e-06_r8,1.0053e-06_r8,8.0852e-07_r8,3.5572e-08_r8/)
      kbo(:, 1,13, 5) = (/ &
     &3.5348e-02_r8,3.1651e-02_r8,2.3972e-02_r8,1.4520e-02_r8,1.2073e-03_r8/)
      kbo(:, 2,13, 5) = (/ &
     &5.4657e-02_r8,4.7880e-02_r8,3.5919e-02_r8,2.1424e-02_r8,1.4997e-03_r8/)
      kbo(:, 3,13, 5) = (/ &
     &8.2602e-02_r8,7.1045e-02_r8,5.2562e-02_r8,3.0599e-02_r8,1.8487e-03_r8/)
      kbo(:, 4,13, 5) = (/ &
     &1.1970e-01_r8,1.0136e-01_r8,7.4139e-02_r8,4.2733e-02_r8,2.2117e-03_r8/)
      kbo(:, 5,13, 5) = (/ &
     &1.6697e-01_r8,1.3996e-01_r8,1.0160e-01_r8,5.7755e-02_r8,2.6210e-03_r8/)
      kbo(:, 1,14, 5) = (/ &
     &3.1413e-02_r8,2.7971e-02_r8,2.1089e-02_r8,1.2782e-02_r8,9.9834e-04_r8/)
      kbo(:, 2,14, 5) = (/ &
     &4.9001e-02_r8,4.2669e-02_r8,3.1890e-02_r8,1.8901e-02_r8,1.2749e-03_r8/)
      kbo(:, 3,14, 5) = (/ &
     &7.3648e-02_r8,6.3169e-02_r8,4.6557e-02_r8,2.7140e-02_r8,1.5545e-03_r8/)
      kbo(:, 4,14, 5) = (/ &
     &1.0633e-01_r8,9.0035e-02_r8,6.5788e-02_r8,3.7842e-02_r8,1.8680e-03_r8/)
      kbo(:, 5,14, 5) = (/ &
     &1.4847e-01_r8,1.2452e-01_r8,9.0180e-02_r8,5.1123e-02_r8,2.2124e-03_r8/)
      kbo(:, 1,15, 5) = (/ &
     &2.6691e-02_r8,2.3767e-02_r8,1.7918e-02_r8,1.0846e-02_r8,8.4376e-04_r8/)
      kbo(:, 2,15, 5) = (/ &
     &4.1563e-02_r8,3.6328e-02_r8,2.7130e-02_r8,1.6082e-02_r8,1.0611e-03_r8/)
      kbo(:, 3,15, 5) = (/ &
     &6.2559e-02_r8,5.3858e-02_r8,3.9632e-02_r8,2.3133e-02_r8,1.2845e-03_r8/)
      kbo(:, 4,15, 5) = (/ &
     &9.0477e-02_r8,7.6844e-02_r8,5.6216e-02_r8,3.2223e-02_r8,1.5617e-03_r8/)
      kbo(:, 5,15, 5) = (/ &
     &1.2655e-01_r8,1.0613e-01_r8,7.6652e-02_r8,4.3561e-02_r8,1.9061e-03_r8/)
      kbo(:, 1,16, 5) = (/ &
     &2.1986e-02_r8,1.9716e-02_r8,1.4938e-02_r8,9.0172e-03_r8,6.9426e-04_r8/)
      kbo(:, 2,16, 5) = (/ &
     &3.4448e-02_r8,3.0201e-02_r8,2.2563e-02_r8,1.3402e-02_r8,8.6528e-04_r8/)
      kbo(:, 3,16, 5) = (/ &
     &5.1943e-02_r8,4.4837e-02_r8,3.3116e-02_r8,1.9274e-02_r8,1.0580e-03_r8/)
      kbo(:, 4,16, 5) = (/ &
     &7.5192e-02_r8,6.4048e-02_r8,4.6767e-02_r8,2.6829e-02_r8,1.3132e-03_r8/)
      kbo(:, 5,16, 5) = (/ &
     &1.0492e-01_r8,8.8109e-02_r8,6.3827e-02_r8,3.6312e-02_r8,1.6006e-03_r8/)
      kbo(:, 1,17, 5) = (/ &
     &1.8067e-02_r8,1.6242e-02_r8,1.2317e-02_r8,7.4587e-03_r8,5.8084e-04_r8/)
      kbo(:, 2,17, 5) = (/ &
     &2.8443e-02_r8,2.5054e-02_r8,1.8720e-02_r8,1.1098e-02_r8,7.2334e-04_r8/)
      kbo(:, 3,17, 5) = (/ &
     &4.2795e-02_r8,3.7062e-02_r8,2.7408e-02_r8,1.5965e-02_r8,9.0099e-04_r8/)
      kbo(:, 4,17, 5) = (/ &
     &6.1919e-02_r8,5.2891e-02_r8,3.8653e-02_r8,2.2221e-02_r8,1.1193e-03_r8/)
      kbo(:, 5,17, 5) = (/ &
     &8.6219e-02_r8,7.2608e-02_r8,5.2687e-02_r8,2.9957e-02_r8,1.3671e-03_r8/)
      kbo(:, 1,18, 5) = (/ &
     &1.4708e-02_r8,1.3327e-02_r8,1.0113e-02_r8,6.1290e-03_r8,4.8316e-04_r8/)
      kbo(:, 2,18, 5) = (/ &
     &2.3136e-02_r8,2.0491e-02_r8,1.5341e-02_r8,9.1147e-03_r8,6.0374e-04_r8/)
      kbo(:, 3,18, 5) = (/ &
     &3.4747e-02_r8,3.0283e-02_r8,2.2393e-02_r8,1.3077e-02_r8,7.6598e-04_r8/)
      kbo(:, 4,18, 5) = (/ &
     &5.0288e-02_r8,4.3057e-02_r8,3.1490e-02_r8,1.8130e-02_r8,9.5069e-04_r8/)
      kbo(:, 5,18, 5) = (/ &
     &6.9756e-02_r8,5.9005e-02_r8,4.2850e-02_r8,2.4412e-02_r8,1.1633e-03_r8/)
      kbo(:, 1,19, 5) = (/ &
     &1.2271e-02_r8,1.1130e-02_r8,8.4511e-03_r8,5.1168e-03_r8,4.1293e-04_r8/)
      kbo(:, 2,19, 5) = (/ &
     &1.9205e-02_r8,1.7036e-02_r8,1.2763e-02_r8,7.5902e-03_r8,5.1993e-04_r8/)
      kbo(:, 3,19, 5) = (/ &
     &2.8789e-02_r8,2.5103e-02_r8,1.8579e-02_r8,1.0864e-02_r8,6.5561e-04_r8/)
      kbo(:, 4,19, 5) = (/ &
     &4.1470e-02_r8,3.5549e-02_r8,2.6049e-02_r8,1.5006e-02_r8,8.1395e-04_r8/)
      kbo(:, 5,19, 5) = (/ &
     &5.7470e-02_r8,4.8743e-02_r8,3.5383e-02_r8,2.0175e-02_r8,9.9598e-04_r8/)
      kbo(:, 1,20, 5) = (/ &
     &1.0604e-02_r8,9.5861e-03_r8,7.2655e-03_r8,4.3823e-03_r8,3.5617e-04_r8/)
      kbo(:, 2,20, 5) = (/ &
     &1.6495e-02_r8,1.4613e-02_r8,1.0934e-02_r8,6.4798e-03_r8,4.4865e-04_r8/)
      kbo(:, 3,20, 5) = (/ &
     &2.4651e-02_r8,2.1430e-02_r8,1.5803e-02_r8,9.2155e-03_r8,5.6360e-04_r8/)
      kbo(:, 4,20, 5) = (/ &
     &3.5214e-02_r8,3.0218e-02_r8,2.2119e-02_r8,1.2722e-02_r8,7.0046e-04_r8/)
      kbo(:, 5,20, 5) = (/ &
     &4.8685e-02_r8,4.1243e-02_r8,2.9948e-02_r8,1.7048e-02_r8,8.5450e-04_r8/)
      kbo(:, 1,21, 5) = (/ &
     &9.2365e-03_r8,8.3349e-03_r8,6.3064e-03_r8,3.7870e-03_r8,3.0556e-04_r8/)
      kbo(:, 2,21, 5) = (/ &
     &1.4270e-02_r8,1.2642e-02_r8,9.4383e-03_r8,5.5694e-03_r8,3.8499e-04_r8/)
      kbo(:, 3,21, 5) = (/ &
     &2.1188e-02_r8,1.8415e-02_r8,1.3582e-02_r8,7.8888e-03_r8,4.8632e-04_r8/)
      kbo(:, 4,21, 5) = (/ &
     &3.0204e-02_r8,2.5895e-02_r8,1.8922e-02_r8,1.0859e-02_r8,6.0144e-04_r8/)
      kbo(:, 5,21, 5) = (/ &
     &4.1738e-02_r8,3.5266e-02_r8,2.5553e-02_r8,1.4491e-02_r8,7.3167e-04_r8/)
      kbo(:, 1,22, 5) = (/ &
     &8.2084e-03_r8,7.4154e-03_r8,5.5986e-03_r8,3.3447e-03_r8,2.6030e-04_r8/)
      kbo(:, 2,22, 5) = (/ &
     &1.2593e-02_r8,1.1132e-02_r8,8.2855e-03_r8,4.8830e-03_r8,3.3150e-04_r8/)
      kbo(:, 3,22, 5) = (/ &
     &1.8558e-02_r8,1.6118e-02_r8,1.1879e-02_r8,6.8818e-03_r8,4.1718e-04_r8/)
      kbo(:, 4,22, 5) = (/ &
     &2.6423e-02_r8,2.2608e-02_r8,1.6490e-02_r8,9.4242e-03_r8,5.1837e-04_r8/)
      kbo(:, 5,22, 5) = (/ &
     &3.6423e-02_r8,3.0712e-02_r8,2.2210e-02_r8,1.2556e-02_r8,6.2757e-04_r8/)
      kbo(:, 1,23, 5) = (/ &
     &7.2962e-03_r8,6.5767e-03_r8,4.9576e-03_r8,2.9518e-03_r8,2.2147e-04_r8/)
      kbo(:, 2,23, 5) = (/ &
     &1.1116e-02_r8,9.7878e-03_r8,7.2822e-03_r8,4.2736e-03_r8,2.8452e-04_r8/)
      kbo(:, 3,23, 5) = (/ &
     &1.6294e-02_r8,1.4142e-02_r8,1.0397e-02_r8,6.0039e-03_r8,3.5768e-04_r8/)
      kbo(:, 4,23, 5) = (/ &
     &2.3164e-02_r8,1.9768e-02_r8,1.4383e-02_r8,8.1899e-03_r8,4.4507e-04_r8/)
      kbo(:, 5,23, 5) = (/ &
     &3.1815e-02_r8,2.6782e-02_r8,1.9341e-02_r8,1.0913e-02_r8,5.3593e-04_r8/)
      kbo(:, 1,24, 5) = (/ &
     &6.5132e-03_r8,5.8530e-03_r8,4.4011e-03_r8,2.6156e-03_r8,1.8866e-04_r8/)
      kbo(:, 2,24, 5) = (/ &
     &9.8979e-03_r8,8.6925e-03_r8,6.4521e-03_r8,3.7670e-03_r8,2.4398e-04_r8/)
      kbo(:, 3,24, 5) = (/ &
     &1.4458e-02_r8,1.2498e-02_r8,9.1615e-03_r8,5.2667e-03_r8,3.0838e-04_r8/)
      kbo(:, 4,24, 5) = (/ &
     &2.0434e-02_r8,1.7400e-02_r8,1.2635e-02_r8,7.1775e-03_r8,3.8038e-04_r8/)
      kbo(:, 5,24, 5) = (/ &
     &2.8011e-02_r8,2.3552e-02_r8,1.6988e-02_r8,9.5542e-03_r8,4.5842e-04_r8/)
      kbo(:, 1,25, 5) = (/ &
     &5.8496e-03_r8,5.2463e-03_r8,3.9347e-03_r8,2.3271e-03_r8,1.6445e-04_r8/)
      kbo(:, 2,25, 5) = (/ &
     &8.8417e-03_r8,7.7604e-03_r8,5.7347e-03_r8,3.3321e-03_r8,2.1081e-04_r8/)
      kbo(:, 3,25, 5) = (/ &
     &1.2868e-02_r8,1.1077e-02_r8,8.0978e-03_r8,4.6433e-03_r8,2.6559e-04_r8/)
      kbo(:, 4,25, 5) = (/ &
     &1.8100e-02_r8,1.5382e-02_r8,1.1156e-02_r8,6.3115e-03_r8,3.2583e-04_r8/)
      kbo(:, 5,25, 5) = (/ &
     &2.4695e-02_r8,2.0722e-02_r8,1.4925e-02_r8,8.3824e-03_r8,3.9105e-04_r8/)
      kbo(:, 1,26, 5) = (/ &
     &5.3224e-03_r8,4.7440e-03_r8,3.5455e-03_r8,2.0856e-03_r8,1.4273e-04_r8/)
      kbo(:, 2,26, 5) = (/ &
     &7.9880e-03_r8,6.9773e-03_r8,5.1401e-03_r8,2.9750e-03_r8,1.8261e-04_r8/)
      kbo(:, 3,26, 5) = (/ &
     &1.1564e-02_r8,9.9215e-03_r8,7.2343e-03_r8,4.1334e-03_r8,2.2903e-04_r8/)
      kbo(:, 4,26, 5) = (/ &
     &1.6157e-02_r8,1.3698e-02_r8,9.9057e-03_r8,5.5934e-03_r8,2.7897e-04_r8/)
      kbo(:, 5,26, 5) = (/ &
     &2.1895e-02_r8,1.8349e-02_r8,1.3199e-02_r8,7.3992e-03_r8,3.3238e-04_r8/)
      kbo(:, 1,27, 5) = (/ &
     &4.8372e-03_r8,4.2909e-03_r8,3.1935e-03_r8,1.8703e-03_r8,1.2222e-04_r8/)
      kbo(:, 2,27, 5) = (/ &
     &7.2219e-03_r8,6.2785e-03_r8,4.6150e-03_r8,2.6594e-03_r8,1.5564e-04_r8/)
      kbo(:, 3,27, 5) = (/ &
     &1.0384e-02_r8,8.8912e-03_r8,6.4664e-03_r8,3.6778e-03_r8,1.9361e-04_r8/)
      kbo(:, 4,27, 5) = (/ &
     &1.4401e-02_r8,1.2183e-02_r8,8.7984e-03_r8,4.9566e-03_r8,2.3445e-04_r8/)
      kbo(:, 5,27, 5) = (/ &
     &1.9400e-02_r8,1.6243e-02_r8,1.1670e-02_r8,6.5316e-03_r8,2.7869e-04_r8/)
      kbo(:, 1,28, 5) = (/ &
     &4.3907e-03_r8,3.8800e-03_r8,2.8785e-03_r8,1.6793e-03_r8,1.0352e-04_r8/)
      kbo(:, 2,28, 5) = (/ &
     &6.5180e-03_r8,5.6500e-03_r8,4.1431e-03_r8,2.3781e-03_r8,1.3090e-04_r8/)
      kbo(:, 3,28, 5) = (/ &
     &9.2995e-03_r8,7.9428e-03_r8,5.7641e-03_r8,3.2684e-03_r8,1.6163e-04_r8/)
      kbo(:, 4,28, 5) = (/ &
     &1.2806e-02_r8,1.0816e-02_r8,7.7992e-03_r8,4.3863e-03_r8,1.9422e-04_r8/)
      kbo(:, 5,28, 5) = (/ &
     &1.7155e-02_r8,1.4361e-02_r8,1.0305e-02_r8,5.7599e-03_r8,2.3020e-04_r8/)
      kbo(:, 1,29, 5) = (/ &
     &3.9730e-03_r8,3.5033e-03_r8,2.5903e-03_r8,1.5043e-03_r8,8.6138e-05_r8/)
      kbo(:, 2,29, 5) = (/ &
     &5.8501e-03_r8,5.0589e-03_r8,3.6981e-03_r8,2.1165e-03_r8,1.0866e-04_r8/)
      kbo(:, 3,29, 5) = (/ &
     &8.2752e-03_r8,7.0540e-03_r8,5.1122e-03_r8,2.8938e-03_r8,1.3206e-04_r8/)
      kbo(:, 4,29, 5) = (/ &
     &1.1323e-02_r8,9.5548e-03_r8,6.8809e-03_r8,3.8639e-03_r8,1.5770e-04_r8/)
      kbo(:, 5,29, 5) = (/ &
     &1.5087e-02_r8,1.2624e-02_r8,9.0498e-03_r8,5.0491e-03_r8,1.8805e-04_r8/)
      kbo(:, 1,30, 5) = (/ &
     &3.5719e-03_r8,3.1399e-03_r8,2.3162e-03_r8,1.3392e-03_r8,7.1373e-05_r8/)
      kbo(:, 2,30, 5) = (/ &
     &5.2107e-03_r8,4.4986e-03_r8,3.2816e-03_r8,1.8730e-03_r8,8.8119e-05_r8/)
      kbo(:, 3,30, 5) = (/ &
     &7.3165e-03_r8,6.2315e-03_r8,4.5078e-03_r8,2.5469e-03_r8,1.0662e-04_r8/)
      kbo(:, 4,30, 5) = (/ &
     &9.9520e-03_r8,8.3892e-03_r8,6.0327e-03_r8,3.3847e-03_r8,1.2803e-04_r8/)
      kbo(:, 5,30, 5) = (/ &
     &1.3166e-02_r8,1.1029e-02_r8,7.9003e-03_r8,4.4030e-03_r8,1.5121e-04_r8/)
      kbo(:, 1,31, 5) = (/ &
     &3.1788e-03_r8,2.7864e-03_r8,2.0507e-03_r8,1.1825e-03_r8,5.7200e-05_r8/)
      kbo(:, 2,31, 5) = (/ &
     &4.5964e-03_r8,3.9617e-03_r8,2.8849e-03_r8,1.6429e-03_r8,7.0401e-05_r8/)
      kbo(:, 3,31, 5) = (/ &
     &6.4014e-03_r8,5.4495e-03_r8,3.9350e-03_r8,2.2208e-03_r8,8.5247e-05_r8/)
      kbo(:, 4,31, 5) = (/ &
     &8.6375e-03_r8,7.2878e-03_r8,5.2393e-03_r8,2.9385e-03_r8,1.0146e-04_r8/)
      kbo(:, 5,31, 5) = (/ &
     &1.1347e-02_r8,9.5229e-03_r8,6.8169e-03_r8,3.7997e-03_r8,1.1891e-04_r8/)
      kbo(:, 1,32, 5) = (/ &
     &2.8359e-03_r8,2.4792e-03_r8,1.8198e-03_r8,1.0462e-03_r8,4.5712e-05_r8/)
      kbo(:, 2,32, 5) = (/ &
     &4.0627e-03_r8,3.4962e-03_r8,2.5410e-03_r8,1.4431e-03_r8,5.6022e-05_r8/)
      kbo(:, 3,32, 5) = (/ &
     &5.6078e-03_r8,4.7711e-03_r8,3.4442e-03_r8,1.9418e-03_r8,6.7267e-05_r8/)
      kbo(:, 4,32, 5) = (/ &
     &7.5047e-03_r8,6.3406e-03_r8,4.5581e-03_r8,2.5548e-03_r8,7.9547e-05_r8/)
      kbo(:, 5,32, 5) = (/ &
     &9.7792e-03_r8,8.2213e-03_r8,5.8868e-03_r8,3.2848e-03_r8,9.2763e-05_r8/)
      kbo(:, 1,33, 5) = (/ &
     &2.5284e-03_r8,2.2057e-03_r8,1.6155e-03_r8,9.2588e-04_r8,3.6267e-05_r8/)
      kbo(:, 2,33, 5) = (/ &
     &3.5886e-03_r8,3.0844e-03_r8,2.2382e-03_r8,1.2695e-03_r8,4.4003e-05_r8/)
      kbo(:, 3,33, 5) = (/ &
     &4.9097e-03_r8,4.1805e-03_r8,3.0157e-03_r8,1.6993e-03_r8,5.2825e-05_r8/)
      kbo(:, 4,33, 5) = (/ &
     &6.5165e-03_r8,5.5167e-03_r8,3.9645e-03_r8,2.2215e-03_r8,6.1889e-05_r8/)
      kbo(:, 5,33, 5) = (/ &
     &8.4209e-03_r8,7.0899e-03_r8,5.0775e-03_r8,2.8354e-03_r8,7.2610e-05_r8/)
      kbo(:, 1,34, 5) = (/ &
     &2.2520e-03_r8,1.9602e-03_r8,1.4328e-03_r8,8.1868e-04_r8,2.9417e-05_r8/)
      kbo(:, 2,34, 5) = (/ &
     &3.1681e-03_r8,2.7215e-03_r8,1.9717e-03_r8,1.1166e-03_r8,3.5490e-05_r8/)
      kbo(:, 3,34, 5) = (/ &
     &4.2977e-03_r8,3.6615e-03_r8,2.6403e-03_r8,1.4869e-03_r8,4.1854e-05_r8/)
      kbo(:, 4,34, 5) = (/ &
     &5.6597e-03_r8,4.7967e-03_r8,3.4462e-03_r8,1.9298e-03_r8,4.9348e-05_r8/)
      kbo(:, 5,34, 5) = (/ &
     &7.2681e-03_r8,6.1253e-03_r8,4.3873e-03_r8,2.4514e-03_r8,5.8186e-05_r8/)
      kbo(:, 1,35, 5) = (/ &
     &1.9366e-03_r8,1.6854e-03_r8,1.2304e-03_r8,7.0199e-04_r8,2.3008e-05_r8/)
      kbo(:, 2,35, 5) = (/ &
     &2.7102e-03_r8,2.3296e-03_r8,1.6872e-03_r8,9.5490e-04_r8,2.7664e-05_r8/)
      kbo(:, 3,35, 5) = (/ &
     &3.6574e-03_r8,3.1206e-03_r8,2.2499e-03_r8,1.2662e-03_r8,3.3089e-05_r8/)
      kbo(:, 4,35, 5) = (/ &
     &4.7963e-03_r8,4.0694e-03_r8,2.9228e-03_r8,1.6371e-03_r8,3.9372e-05_r8/)
      kbo(:, 5,35, 5) = (/ &
     &6.1352e-03_r8,5.1795e-03_r8,3.7111e-03_r8,2.0740e-03_r8,4.6276e-05_r8/)
      kbo(:, 1,36, 5) = (/ &
     &1.6034e-03_r8,1.3976e-03_r8,1.0202e-03_r8,5.8186e-04_r8,1.7663e-05_r8/)
      kbo(:, 2,36, 5) = (/ &
     &2.2421e-03_r8,1.9307e-03_r8,1.3983e-03_r8,7.9118e-04_r8,2.1547e-05_r8/)
      kbo(:, 3,36, 5) = (/ &
     &3.0206e-03_r8,2.5824e-03_r8,1.8623e-03_r8,1.0484e-03_r8,2.5886e-05_r8/)
      kbo(:, 4,36, 5) = (/ &
     &3.9570e-03_r8,3.3630e-03_r8,2.4161e-03_r8,1.3541e-03_r8,3.0872e-05_r8/)
      kbo(:, 5,36, 5) = (/ &
     &5.0582e-03_r8,4.2785e-03_r8,3.0668e-03_r8,1.7150e-03_r8,3.6301e-05_r8/)
      kbo(:, 1,37, 5) = (/ &
     &1.2748e-03_r8,1.1146e-03_r8,8.1407e-04_r8,4.6450e-04_r8,1.3581e-05_r8/)
      kbo(:, 2,37, 5) = (/ &
     &1.7898e-03_r8,1.5447e-03_r8,1.1192e-03_r8,6.3354e-04_r8,1.6729e-05_r8/)
      kbo(:, 3,37, 5) = (/ &
     &2.4187e-03_r8,2.0714e-03_r8,1.4947e-03_r8,8.4187e-04_r8,2.0205e-05_r8/)
      kbo(:, 4,37, 5) = (/ &
     &3.1762e-03_r8,2.7057e-03_r8,1.9449e-03_r8,1.0902e-03_r8,2.4038e-05_r8/)
      kbo(:, 5,37, 5) = (/ &
     &4.0701e-03_r8,3.4504e-03_r8,2.4741e-03_r8,1.3836e-03_r8,2.8365e-05_r8/)
      kbo(:, 1,38, 5) = (/ &
     &1.0102e-03_r8,8.8559e-04_r8,6.4741e-04_r8,3.6947e-04_r8,1.0412e-05_r8/)
      kbo(:, 2,38, 5) = (/ &
     &1.4249e-03_r8,1.2327e-03_r8,8.9319e-04_r8,5.0584e-04_r8,1.2901e-05_r8/)
      kbo(:, 3,38, 5) = (/ &
     &1.9318e-03_r8,1.6579e-03_r8,1.1967e-03_r8,6.7434e-04_r8,1.5672e-05_r8/)
      kbo(:, 4,38, 5) = (/ &
     &2.5434e-03_r8,2.1714e-03_r8,1.5616e-03_r8,8.7562e-04_r8,1.8795e-05_r8/)
      kbo(:, 5,38, 5) = (/ &
     &3.2683e-03_r8,2.7765e-03_r8,1.9923e-03_r8,1.1142e-03_r8,2.2145e-05_r8/)
      kbo(:, 1,39, 5) = (/ &
     &7.9946e-04_r8,7.0298e-04_r8,5.1416e-04_r8,2.9368e-04_r8,7.9720e-06_r8/)
      kbo(:, 2,39, 5) = (/ &
     &1.1333e-03_r8,9.8290e-04_r8,7.1255e-04_r8,4.0353e-04_r8,9.9223e-06_r8/)
      kbo(:, 3,39, 5) = (/ &
     &1.5418e-03_r8,1.3259e-03_r8,9.5739e-04_r8,5.3970e-04_r8,1.2141e-05_r8/)
      kbo(:, 4,39, 5) = (/ &
     &2.0355e-03_r8,1.7418e-03_r8,1.2533e-03_r8,7.0303e-04_r8,1.4591e-05_r8/)
      kbo(:, 5,39, 5) = (/ &
     &2.6233e-03_r8,2.2332e-03_r8,1.6027e-03_r8,8.9673e-04_r8,1.7278e-05_r8/)
      kbo(:, 1,40, 5) = (/ &
     &6.1558e-04_r8,5.4339e-04_r8,3.9799e-04_r8,2.2761e-04_r8,6.0679e-06_r8/)
      kbo(:, 2,40, 5) = (/ &
     &8.8100e-04_r8,7.6638e-04_r8,5.5623e-04_r8,3.1507e-04_r8,7.6104e-06_r8/)
      kbo(:, 3,40, 5) = (/ &
     &1.2072e-03_r8,1.0404e-03_r8,7.5136e-04_r8,4.2373e-04_r8,9.3444e-06_r8/)
      kbo(:, 4,40, 5) = (/ &
     &1.6029e-03_r8,1.3742e-03_r8,9.8944e-04_r8,5.5501e-04_r8,1.1318e-05_r8/)
      kbo(:, 5,40, 5) = (/ &
     &2.0762e-03_r8,1.7710e-03_r8,1.2711e-03_r8,7.1134e-04_r8,1.3497e-05_r8/)
      kbo(:, 1,41, 5) = (/ &
     &4.7150e-04_r8,4.1786e-04_r8,3.0641e-04_r8,1.7559e-04_r8,4.6077e-06_r8/)
      kbo(:, 2,41, 5) = (/ &
     &6.8147e-04_r8,5.9486e-04_r8,4.3209e-04_r8,2.4498e-04_r8,5.8135e-06_r8/)
      kbo(:, 3,41, 5) = (/ &
     &9.4213e-04_r8,8.1372e-04_r8,5.8780e-04_r8,3.3145e-04_r8,7.1715e-06_r8/)
      kbo(:, 4,41, 5) = (/ &
     &1.2582e-03_r8,1.0809e-03_r8,7.7844e-04_r8,4.3685e-04_r8,8.7285e-06_r8/)
      kbo(:, 5,41, 5) = (/ &
     &1.6388e-03_r8,1.4010e-03_r8,1.0055e-03_r8,5.6266e-04_r8,1.0465e-05_r8/)
      kbo(:, 1,42, 5) = (/ &
     &3.6009e-04_r8,3.2039e-04_r8,2.3540e-04_r8,1.3511e-04_r8,3.4818e-06_r8/)
      kbo(:, 2,42, 5) = (/ &
     &5.2591e-04_r8,4.6075e-04_r8,3.3505e-04_r8,1.9005e-04_r8,4.4174e-06_r8/)
      kbo(:, 3,42, 5) = (/ &
     &7.3377e-04_r8,6.3539e-04_r8,4.5927e-04_r8,2.5904e-04_r8,5.4797e-06_r8/)
      kbo(:, 4,42, 5) = (/ &
     &9.8665e-04_r8,8.4900e-04_r8,6.1152e-04_r8,3.4335e-04_r8,6.7219e-06_r8/)
      kbo(:, 5,42, 5) = (/ &
     &1.2919e-03_r8,1.1071e-03_r8,7.9454e-04_r8,4.4455e-04_r8,8.0996e-06_r8/)
      kbo(:, 1,43, 5) = (/ &
     &2.7068e-04_r8,2.4195e-04_r8,1.7816e-04_r8,1.0249e-04_r8,2.5837e-06_r8/)
      kbo(:, 2,43, 5) = (/ &
     &4.0104e-04_r8,3.5254e-04_r8,2.5672e-04_r8,1.4582e-04_r8,3.3146e-06_r8/)
      kbo(:, 3,43, 5) = (/ &
     &5.6618e-04_r8,4.9150e-04_r8,3.5538e-04_r8,2.0045e-04_r8,4.1432e-06_r8/)
      kbo(:, 4,43, 5) = (/ &
     &7.6835e-04_r8,6.6216e-04_r8,4.7675e-04_r8,2.6781e-04_r8,5.1315e-06_r8/)
      kbo(:, 5,43, 5) = (/ &
     &1.0127e-03_r8,8.6923e-04_r8,6.2405e-04_r8,3.4899e-04_r8,6.1983e-06_r8/)
      kbo(:, 1,44, 5) = (/ &
     &2.0139e-04_r8,1.8106e-04_r8,1.3358e-04_r8,7.7094e-05_r8,1.8960e-06_r8/)
      kbo(:, 2,44, 5) = (/ &
     &3.0345e-04_r8,2.6774e-04_r8,1.9525e-04_r8,1.1112e-04_r8,2.4595e-06_r8/)
      kbo(:, 3,44, 5) = (/ &
     &4.3439e-04_r8,3.7822e-04_r8,2.7355e-04_r8,1.5433e-04_r8,3.1158e-06_r8/)
      kbo(:, 4,44, 5) = (/ &
     &5.9600e-04_r8,5.1425e-04_r8,3.7025e-04_r8,2.0795e-04_r8,3.8746e-06_r8/)
      kbo(:, 5,44, 5) = (/ &
     &7.9184e-04_r8,6.8038e-04_r8,4.8839e-04_r8,2.7303e-04_r8,4.7113e-06_r8/)
      kbo(:, 1,45, 5) = (/ &
     &1.4924e-04_r8,1.3479e-04_r8,9.9739e-05_r8,5.7756e-05_r8,1.3827e-06_r8/)
      kbo(:, 2,45, 5) = (/ &
     &2.2880e-04_r8,2.0270e-04_r8,1.4808e-04_r8,8.4395e-05_r8,1.8081e-06_r8/)
      kbo(:, 3,45, 5) = (/ &
     &3.3229e-04_r8,2.9032e-04_r8,2.1015e-04_r8,1.1857e-04_r8,2.3261e-06_r8/)
      kbo(:, 4,45, 5) = (/ &
     &4.6152e-04_r8,3.9893e-04_r8,2.8721e-04_r8,1.6120e-04_r8,2.9080e-06_r8/)
      kbo(:, 5,45, 5) = (/ &
     &6.1857e-04_r8,5.3204e-04_r8,3.8190e-04_r8,2.1341e-04_r8,3.5612e-06_r8/)
      kbo(:, 1,46, 5) = (/ &
     &1.0906e-04_r8,9.9059e-05_r8,7.3477e-05_r8,4.2734e-05_r8,1.0024e-06_r8/)
      kbo(:, 2,46, 5) = (/ &
     &1.7043e-04_r8,1.5165e-04_r8,1.1108e-04_r8,6.3473e-05_r8,1.3227e-06_r8/)
      kbo(:, 3,46, 5) = (/ &
     &2.5193e-04_r8,2.2079e-04_r8,1.6005e-04_r8,9.0376e-05_r8,1.7191e-06_r8/)
      kbo(:, 4,46, 5) = (/ &
     &3.5457e-04_r8,3.0711e-04_r8,2.2121e-04_r8,1.2412e-04_r8,2.1640e-06_r8/)
      kbo(:, 5,46, 5) = (/ &
     &4.8016e-04_r8,4.1350e-04_r8,2.9669e-04_r8,1.6585e-04_r8,2.6681e-06_r8/)
      kbo(:, 1,47, 5) = (/ &
     &7.7791e-05_r8,7.1164e-05_r8,5.2966e-05_r8,3.0950e-05_r8,7.1979e-07_r8/)
      kbo(:, 2,47, 5) = (/ &
     &1.2436e-04_r8,1.1134e-04_r8,8.1758e-05_r8,4.6856e-05_r8,9.5466e-07_r8/)
      kbo(:, 3,47, 5) = (/ &
     &1.8767e-04_r8,1.6518e-04_r8,1.1995e-04_r8,6.7855e-05_r8,1.2553e-06_r8/)
      kbo(:, 4,47, 5) = (/ &
     &2.6877e-04_r8,2.3350e-04_r8,1.6823e-04_r8,9.4438e-05_r8,1.6001e-06_r8/)
      kbo(:, 5,47, 5) = (/ &
     &3.6855e-04_r8,3.1774e-04_r8,2.2797e-04_r8,1.2742e-04_r8,1.9855e-06_r8/)
      kbo(:, 1,48, 5) = (/ &
     &5.5044e-05_r8,5.0693e-05_r8,3.7891e-05_r8,2.2267e-05_r8,5.1420e-07_r8/)
      kbo(:, 2,48, 5) = (/ &
     &9.0215e-05_r8,8.1170e-05_r8,5.9770e-05_r8,3.4413e-05_r8,6.9075e-07_r8/)
      kbo(:, 3,48, 5) = (/ &
     &1.3907e-04_r8,1.2292e-04_r8,8.9447e-05_r8,5.0716e-05_r8,9.0307e-07_r8/)
      kbo(:, 4,48, 5) = (/ &
     &2.0282e-04_r8,1.7688e-04_r8,1.2753e-04_r8,7.1593e-05_r8,1.1665e-06_r8/)
      kbo(:, 5,48, 5) = (/ &
     &2.8252e-04_r8,2.4382e-04_r8,1.7492e-04_r8,9.7702e-05_r8,1.4649e-06_r8/)
      kbo(:, 1,49, 5) = (/ &
     &3.8587e-05_r8,3.5798e-05_r8,2.6873e-05_r8,1.5895e-05_r8,3.6284e-07_r8/)
      kbo(:, 2,49, 5) = (/ &
     &6.4973e-05_r8,5.8784e-05_r8,4.3404e-05_r8,2.5118e-05_r8,4.9340e-07_r8/)
      kbo(:, 3,49, 5) = (/ &
     &1.0247e-04_r8,9.0960e-05_r8,6.6355e-05_r8,3.7720e-05_r8,6.5251e-07_r8/)
      kbo(:, 4,49, 5) = (/ &
     &1.5241e-04_r8,1.3334e-04_r8,9.6283e-05_r8,5.4131e-05_r8,8.4176e-07_r8/)
      kbo(:, 5,49, 5) = (/ &
     &2.1585e-04_r8,1.8661e-04_r8,1.3387e-04_r8,7.4762e-05_r8,1.0688e-06_r8/)
      kbo(:, 1,50, 5) = (/ &
     &2.7204e-05_r8,2.5412e-05_r8,1.9146e-05_r8,1.1397e-05_r8,2.5753e-07_r8/)
      kbo(:, 2,50, 5) = (/ &
     &4.7009e-05_r8,4.2778e-05_r8,3.1689e-05_r8,1.8416e-05_r8,3.5668e-07_r8/)
      kbo(:, 3,50, 5) = (/ &
     &7.5923e-05_r8,6.7680e-05_r8,4.9459e-05_r8,2.8188e-05_r8,4.7630e-07_r8/)
      kbo(:, 4,50, 5) = (/ &
     &1.1516e-04_r8,1.0107e-04_r8,7.3089e-05_r8,4.1129e-05_r8,6.1736e-07_r8/)
      kbo(:, 5,50, 5) = (/ &
     &1.6568e-04_r8,1.4364e-04_r8,1.0307e-04_r8,5.7556e-05_r8,7.8811e-07_r8/)
      kbo(:, 1,51, 5) = (/ &
     &1.9132e-05_r8,1.8022e-05_r8,1.3620e-05_r8,8.1585e-06_r8,1.8251e-07_r8/)
      kbo(:, 2,51, 5) = (/ &
     &3.4015e-05_r8,3.1104e-05_r8,2.3112e-05_r8,1.3493e-05_r8,2.5742e-07_r8/)
      kbo(:, 3,51, 5) = (/ &
     &5.6251e-05_r8,5.0351e-05_r8,3.6864e-05_r8,2.1082e-05_r8,3.4853e-07_r8/)
      kbo(:, 4,51, 5) = (/ &
     &8.7117e-05_r8,7.6686e-05_r8,5.5526e-05_r8,3.1296e-05_r8,4.5614e-07_r8/)
      kbo(:, 5,51, 5) = (/ &
     &1.2742e-04_r8,1.1075e-04_r8,7.9490e-05_r8,4.4386e-05_r8,5.8324e-07_r8/)
      kbo(:, 1,52, 5) = (/ &
     &1.3343e-05_r8,1.2680e-05_r8,9.6205e-06_r8,5.7937e-06_r8,1.2757e-07_r8/)
      kbo(:, 2,52, 5) = (/ &
     &2.4457e-05_r8,2.2489e-05_r8,1.6762e-05_r8,9.8342e-06_r8,1.8427e-07_r8/)
      kbo(:, 3,52, 5) = (/ &
     &4.1490e-05_r8,3.7272e-05_r8,2.7347e-05_r8,1.5697e-05_r8,2.5311e-07_r8/)
      kbo(:, 4,52, 5) = (/ &
     &6.5698e-05_r8,5.8019e-05_r8,4.2067e-05_r8,2.3741e-05_r8,3.3454e-07_r8/)
      kbo(:, 5,52, 5) = (/ &
     &9.7769e-05_r8,8.5199e-05_r8,6.1200e-05_r8,3.4184e-05_r8,4.3074e-07_r8/)
      kbo(:, 1,53, 5) = (/ &
     &9.2286e-06_r8,8.8438e-06_r8,6.7394e-06_r8,4.0796e-06_r8,8.7990e-08_r8/)
      kbo(:, 2,53, 5) = (/ &
     &1.7462e-05_r8,1.6145e-05_r8,1.2071e-05_r8,7.1204e-06_r8,1.3004e-07_r8/)
      kbo(:, 3,53, 5) = (/ &
     &3.0397e-05_r8,2.7436e-05_r8,2.0177e-05_r8,1.1626e-05_r8,1.8173e-07_r8/)
      kbo(:, 4,53, 5) = (/ &
     &4.9319e-05_r8,4.3681e-05_r8,3.1722e-05_r8,1.7943e-05_r8,2.4392e-07_r8/)
      kbo(:, 5,53, 5) = (/ &
     &7.4848e-05_r8,6.5369e-05_r8,4.7021e-05_r8,2.6269e-05_r8,3.1719e-07_r8/)
      kbo(:, 1,54, 5) = (/ &
     &6.4770e-06_r8,6.2515e-06_r8,4.7770e-06_r8,2.9074e-06_r8,6.2611e-08_r8/)
      kbo(:, 2,54, 5) = (/ &
     &1.2608e-05_r8,1.1724e-05_r8,8.7837e-06_r8,5.2044e-06_r8,9.4222e-08_r8/)
      kbo(:, 3,54, 5) = (/ &
     &2.2532e-05_r8,2.0405e-05_r8,1.5043e-05_r8,8.6950e-06_r8,1.3411e-07_r8/)
      kbo(:, 4,54, 5) = (/ &
     &3.7397e-05_r8,3.3212e-05_r8,2.4145e-05_r8,1.3685e-05_r8,1.8245e-07_r8/)
      kbo(:, 5,54, 5) = (/ &
     &5.7878e-05_r8,5.0645e-05_r8,3.6444e-05_r8,2.0382e-05_r8,2.3871e-07_r8/)
      kbo(:, 1,55, 5) = (/ &
     &4.5852e-06_r8,4.4390e-06_r8,3.4016e-06_r8,2.0767e-06_r8,4.4961e-08_r8/)
      kbo(:, 2,55, 5) = (/ &
     &9.1363e-06_r8,8.5468e-06_r8,6.4138e-06_r8,3.8136e-06_r8,6.9204e-08_r8/)
      kbo(:, 3,55, 5) = (/ &
     &1.6770e-05_r8,1.5238e-05_r8,1.1251e-05_r8,6.5245e-06_r8,1.0020e-07_r8/)
      kbo(:, 4,55, 5) = (/ &
     &2.8475e-05_r8,2.5343e-05_r8,1.8439e-05_r8,1.0474e-05_r8,1.3796e-07_r8/)
      kbo(:, 5,55, 5) = (/ &
     &4.4988e-05_r8,3.9423e-05_r8,2.8373e-05_r8,1.5872e-05_r8,1.8258e-07_r8/)
      kbo(:, 1,56, 5) = (/ &
     &3.2543e-06_r8,3.1469e-06_r8,2.4158e-06_r8,1.4787e-06_r8,3.1932e-08_r8/)
      kbo(:, 2,56, 5) = (/ &
     &6.5989e-06_r8,6.2038e-06_r8,4.6696e-06_r8,2.7831e-06_r8,5.0531e-08_r8/)
      kbo(:, 3,56, 5) = (/ &
     &1.2453e-05_r8,1.1352e-05_r8,8.3945e-06_r8,4.8820e-06_r8,7.4538e-08_r8/)
      kbo(:, 4,56, 5) = (/ &
     &2.1655e-05_r8,1.9314e-05_r8,1.4065e-05_r8,8.0028e-06_r8,1.0397e-07_r8/)
      kbo(:, 5,56, 5) = (/ &
     &3.4950e-05_r8,3.0673e-05_r8,2.2085e-05_r8,1.2363e-05_r8,1.3925e-07_r8/)
      kbo(:, 1,57, 5) = (/ &
     &2.3166e-06_r8,2.2390e-06_r8,1.7142e-06_r8,1.0504e-06_r8,2.2682e-08_r8/)
      kbo(:, 2,57, 5) = (/ &
     &4.7540e-06_r8,4.4892e-06_r8,3.3846e-06_r8,2.0245e-06_r8,3.6988e-08_r8/)
      kbo(:, 3,57, 5) = (/ &
     &9.2246e-06_r8,8.4320e-06_r8,6.2438e-06_r8,3.6425e-06_r8,5.5328e-08_r8/)
      kbo(:, 4,57, 5) = (/ &
     &1.6448e-05_r8,1.4704e-05_r8,1.0717e-05_r8,6.1069e-06_r8,7.8210e-08_r8/)
      kbo(:, 5,57, 5) = (/ &
     &2.7140e-05_r8,2.3849e-05_r8,1.7182e-05_r8,9.6233e-06_r8,1.0611e-07_r8/)
      kbo(:, 1,58, 5) = (/ &
     &8.1594e-07_r8,9.0016e-07_r8,8.0661e-07_r8,5.9543e-07_r8,1.6269e-08_r8/)
      kbo(:, 2,58, 5) = (/ &
     &1.6728e-06_r8,1.8193e-06_r8,1.6122e-06_r8,1.1689e-06_r8,2.7161e-08_r8/)
      kbo(:, 3,58, 5) = (/ &
     &3.3325e-06_r8,3.5076e-06_r8,3.0497e-06_r8,2.1581e-06_r8,4.1468e-08_r8/)
      kbo(:, 4,58, 5) = (/ &
     &6.0908e-06_r8,6.2615e-06_r8,5.3621e-06_r8,3.7018e-06_r8,5.9556e-08_r8/)
      kbo(:, 5,58, 5) = (/ &
     &1.0274e-05_r8,1.0375e-05_r8,8.7754e-06_r8,5.9519e-06_r8,8.1351e-08_r8/)
      kbo(:, 1,59, 5) = (/ &
     &6.5199e-07_r8,7.1682e-07_r8,6.4285e-07_r8,4.7533e-07_r8,1.3398e-08_r8/)
      kbo(:, 2,59, 5) = (/ &
     &1.3361e-06_r8,1.4531e-06_r8,1.2913e-06_r8,9.4099e-07_r8,2.2445e-08_r8/)
      kbo(:, 3,59, 5) = (/ &
     &2.6852e-06_r8,2.8341e-06_r8,2.4717e-06_r8,1.7572e-06_r8,3.4660e-08_r8/)
      kbo(:, 4,59, 5) = (/ &
     &4.9575e-06_r8,5.1104e-06_r8,4.3915e-06_r8,3.0485e-06_r8,4.9566e-08_r8/)
      kbo(:, 5,59, 5) = (/ &
     &8.4320e-06_r8,8.5398e-06_r8,7.2464e-06_r8,4.9418e-06_r8,6.8105e-08_r8/)
      kbo(:, 1,13, 6) = (/ &
     &1.5548e-01_r8,1.2226e-01_r8,8.5068e-02_r8,4.5702e-02_r8,2.0740e-03_r8/)
      kbo(:, 2,13, 6) = (/ &
     &2.1897e-01_r8,1.7240e-01_r8,1.2003e-01_r8,6.4538e-02_r8,2.5124e-03_r8/)
      kbo(:, 3,13, 6) = (/ &
     &3.0095e-01_r8,2.3621e-01_r8,1.6479e-01_r8,8.8859e-02_r8,3.0382e-03_r8/)
      kbo(:, 4,13, 6) = (/ &
     &4.0485e-01_r8,3.1719e-01_r8,2.2079e-01_r8,1.1848e-01_r8,3.6959e-03_r8/)
      kbo(:, 5,13, 6) = (/ &
     &5.3118e-01_r8,4.1467e-01_r8,2.8796e-01_r8,1.5438e-01_r8,4.3103e-03_r8/)
      kbo(:, 1,14, 6) = (/ &
     &1.3732e-01_r8,1.0825e-01_r8,7.5397e-02_r8,4.0495e-02_r8,1.7538e-03_r8/)
      kbo(:, 2,14, 6) = (/ &
     &1.9463e-01_r8,1.5344e-01_r8,1.0670e-01_r8,5.7417e-02_r8,2.1725e-03_r8/)
      kbo(:, 3,14, 6) = (/ &
     &2.6896e-01_r8,2.1173e-01_r8,1.4739e-01_r8,7.9254e-02_r8,2.6810e-03_r8/)
      kbo(:, 4,14, 6) = (/ &
     &3.6294e-01_r8,2.8446e-01_r8,1.9761e-01_r8,1.0591e-01_r8,3.1748e-03_r8/)
      kbo(:, 5,14, 6) = (/ &
     &4.7752e-01_r8,3.7323e-01_r8,2.5905e-01_r8,1.3864e-01_r8,3.7684e-03_r8/)
      kbo(:, 1,15, 6) = (/ &
     &1.1609e-01_r8,9.1864e-02_r8,6.4056e-02_r8,3.4496e-02_r8,1.4724e-03_r8/)
      kbo(:, 2,15, 6) = (/ &
     &1.6575e-01_r8,1.3099e-01_r8,9.1234e-02_r8,4.9161e-02_r8,1.8695e-03_r8/)
      kbo(:, 3,15, 6) = (/ &
     &2.2962e-01_r8,1.8109e-01_r8,1.2603e-01_r8,6.7814e-02_r8,2.2935e-03_r8/)
      kbo(:, 4,15, 6) = (/ &
     &3.1077e-01_r8,2.4430e-01_r8,1.6934e-01_r8,9.0957e-02_r8,2.7633e-03_r8/)
      kbo(:, 5,15, 6) = (/ &
     &4.0968e-01_r8,3.2160e-01_r8,2.2302e-01_r8,1.1925e-01_r8,3.2819e-03_r8/)
      kbo(:, 1,16, 6) = (/ &
     &9.6387e-02_r8,7.6493e-02_r8,5.3335e-02_r8,2.8835e-02_r8,1.2273e-03_r8/)
      kbo(:, 2,16, 6) = (/ &
     &1.3769e-01_r8,1.0917e-01_r8,7.6074e-02_r8,4.1117e-02_r8,1.5607e-03_r8/)
      kbo(:, 3,16, 6) = (/ &
     &1.9131e-01_r8,1.5123e-01_r8,1.0523e-01_r8,5.6738e-02_r8,1.9638e-03_r8/)
      kbo(:, 4,16, 6) = (/ &
     &2.5899e-01_r8,2.0399e-01_r8,1.4165e-01_r8,7.6203e-02_r8,2.3618e-03_r8/)
      kbo(:, 5,16, 6) = (/ &
     &3.4214e-01_r8,2.6934e-01_r8,1.8675e-01_r8,1.0014e-01_r8,2.8281e-03_r8/)
      kbo(:, 1,17, 6) = (/ &
     &7.9271e-02_r8,6.3126e-02_r8,4.4100e-02_r8,2.3917e-02_r8,1.0217e-03_r8/)
      kbo(:, 2,17, 6) = (/ &
     &1.1345e-01_r8,9.0182e-02_r8,6.2977e-02_r8,3.4156e-02_r8,1.3299e-03_r8/)
      kbo(:, 3,17, 6) = (/ &
     &1.5797e-01_r8,1.2511e-01_r8,8.7087e-02_r8,4.7059e-02_r8,1.6628e-03_r8/)
      kbo(:, 4,17, 6) = (/ &
     &2.1402e-01_r8,1.6897e-01_r8,1.1752e-01_r8,6.3332e-02_r8,2.0151e-03_r8/)
      kbo(:, 5,17, 6) = (/ &
     &2.8305e-01_r8,2.2332e-01_r8,1.5502e-01_r8,8.3415e-02_r8,2.4638e-03_r8/)
      kbo(:, 1,18, 6) = (/ &
     &6.4211e-02_r8,5.1302e-02_r8,3.5902e-02_r8,1.9554e-02_r8,8.7983e-04_r8/)
      kbo(:, 2,18, 6) = (/ &
     &9.2120e-02_r8,7.3433e-02_r8,5.1355e-02_r8,2.7890e-02_r8,1.1536e-03_r8/)
      kbo(:, 3,18, 6) = (/ &
     &1.2833e-01_r8,1.0186e-01_r8,7.1081e-02_r8,3.8483e-02_r8,1.4378e-03_r8/)
      kbo(:, 4,18, 6) = (/ &
     &1.7390e-01_r8,1.3787e-01_r8,9.6012e-02_r8,5.1930e-02_r8,1.7641e-03_r8/)
      kbo(:, 5,18, 6) = (/ &
     &2.3011e-01_r8,1.8206e-01_r8,1.2668e-01_r8,6.8404e-02_r8,2.1654e-03_r8/)
      kbo(:, 1,19, 6) = (/ &
     &5.2788e-02_r8,4.2299e-02_r8,2.9673e-02_r8,1.6227e-02_r8,7.6310e-04_r8/)
      kbo(:, 2,19, 6) = (/ &
     &7.5889e-02_r8,6.0648e-02_r8,4.2457e-02_r8,2.3108e-02_r8,1.0035e-03_r8/)
      kbo(:, 3,19, 6) = (/ &
     &1.0575e-01_r8,8.4190e-02_r8,5.8852e-02_r8,3.1993e-02_r8,1.2648e-03_r8/)
      kbo(:, 4,19, 6) = (/ &
     &1.4328e-01_r8,1.1394e-01_r8,7.9533e-02_r8,4.3155e-02_r8,1.5714e-03_r8/)
      kbo(:, 5,19, 6) = (/ &
     &1.8940e-01_r8,1.5028e-01_r8,1.0488e-01_r8,5.6817e-02_r8,1.9149e-03_r8/)
      kbo(:, 1,20, 6) = (/ &
     &4.4520e-02_r8,3.5758e-02_r8,2.5128e-02_r8,1.3753e-02_r8,6.6571e-04_r8/)
      kbo(:, 2,20, 6) = (/ &
     &6.4045e-02_r8,5.1271e-02_r8,3.5901e-02_r8,1.9582e-02_r8,8.7391e-04_r8/)
      kbo(:, 3,20, 6) = (/ &
     &8.9082e-02_r8,7.1164e-02_r8,4.9821e-02_r8,2.7122e-02_r8,1.1092e-03_r8/)
      kbo(:, 4,20, 6) = (/ &
     &1.2061e-01_r8,9.6051e-02_r8,6.7127e-02_r8,3.6518e-02_r8,1.3635e-03_r8/)
      kbo(:, 5,20, 6) = (/ &
     &1.5922e-01_r8,1.2658e-01_r8,8.8405e-02_r8,4.7977e-02_r8,1.6664e-03_r8/)
      kbo(:, 1,21, 6) = (/ &
     &3.7777e-02_r8,3.0383e-02_r8,2.1331e-02_r8,1.1694e-02_r8,5.7845e-04_r8/)
      kbo(:, 2,21, 6) = (/ &
     &5.4331e-02_r8,4.3484e-02_r8,3.0481e-02_r8,1.6684e-02_r8,7.5762e-04_r8/)
      kbo(:, 3,21, 6) = (/ &
     &7.5428e-02_r8,6.0294e-02_r8,4.2245e-02_r8,2.3058e-02_r8,9.5396e-04_r8/)
      kbo(:, 4,21, 6) = (/ &
     &1.0181e-01_r8,8.1193e-02_r8,5.6844e-02_r8,3.0978e-02_r8,1.1796e-03_r8/)
      kbo(:, 5,21, 6) = (/ &
     &1.3419e-01_r8,1.0693e-01_r8,7.4825e-02_r8,4.0693e-02_r8,1.4376e-03_r8/)
      kbo(:, 1,22, 6) = (/ &
     &3.2832e-02_r8,2.6387e-02_r8,1.8543e-02_r8,1.0190e-02_r8,5.0764e-04_r8/)
      kbo(:, 2,22, 6) = (/ &
     &4.6987e-02_r8,3.7684e-02_r8,2.6458e-02_r8,1.4480e-02_r8,6.6076e-04_r8/)
      kbo(:, 3,22, 6) = (/ &
     &6.5046e-02_r8,5.2018e-02_r8,3.6448e-02_r8,1.9932e-02_r8,8.2689e-04_r8/)
      kbo(:, 4,22, 6) = (/ &
     &8.7447e-02_r8,6.9814e-02_r8,4.8898e-02_r8,2.6679e-02_r8,1.0180e-03_r8/)
      kbo(:, 5,22, 6) = (/ &
     &1.1504e-01_r8,9.1878e-02_r8,6.4286e-02_r8,3.4972e-02_r8,1.2412e-03_r8/)
      kbo(:, 1,23, 6) = (/ &
     &2.8625e-02_r8,2.3013e-02_r8,1.6180e-02_r8,8.8954e-03_r8,4.4551e-04_r8/)
      kbo(:, 2,23, 6) = (/ &
     &4.0740e-02_r8,3.2715e-02_r8,2.2979e-02_r8,1.2589e-02_r8,5.7081e-04_r8/)
      kbo(:, 3,23, 6) = (/ &
     &5.6140e-02_r8,4.4931e-02_r8,3.1539e-02_r8,1.7244e-02_r8,7.1483e-04_r8/)
      kbo(:, 4,23, 6) = (/ &
     &7.5282e-02_r8,6.0221e-02_r8,4.2218e-02_r8,2.3054e-02_r8,8.7570e-04_r8/)
      kbo(:, 5,23, 6) = (/ &
     &9.9200e-02_r8,7.9197e-02_r8,5.5422e-02_r8,3.0138e-02_r8,1.0690e-03_r8/)
      kbo(:, 1,24, 6) = (/ &
     &2.5225e-02_r8,2.0294e-02_r8,1.4276e-02_r8,7.8427e-03_r8,3.8602e-04_r8/)
      kbo(:, 2,24, 6) = (/ &
     &3.5712e-02_r8,2.8695e-02_r8,2.0149e-02_r8,1.1049e-02_r8,4.9372e-04_r8/)
      kbo(:, 3,24, 6) = (/ &
     &4.9060e-02_r8,3.9310e-02_r8,2.7586e-02_r8,1.5091e-02_r8,6.1539e-04_r8/)
      kbo(:, 4,24, 6) = (/ &
     &6.5785e-02_r8,5.2643e-02_r8,3.6889e-02_r8,2.0124e-02_r8,7.5365e-04_r8/)
      kbo(:, 5,24, 6) = (/ &
     &8.6520e-02_r8,6.9119e-02_r8,4.8335e-02_r8,2.6295e-02_r8,9.2000e-04_r8/)
      kbo(:, 1,25, 6) = (/ &
     &2.2344e-02_r8,1.7976e-02_r8,1.2645e-02_r8,6.9412e-03_r8,3.3195e-04_r8/)
      kbo(:, 2,25, 6) = (/ &
     &3.1531e-02_r8,2.5281e-02_r8,1.7784e-02_r8,9.7415e-03_r8,4.2393e-04_r8/)
      kbo(:, 3,25, 6) = (/ &
     &4.3153e-02_r8,3.4621e-02_r8,2.4312e-02_r8,1.3288e-02_r8,5.2565e-04_r8/)
      kbo(:, 4,25, 6) = (/ &
     &5.7875e-02_r8,4.6285e-02_r8,3.2426e-02_r8,1.7676e-02_r8,6.4832e-04_r8/)
      kbo(:, 5,25, 6) = (/ &
     &7.6134e-02_r8,6.0793e-02_r8,4.2524e-02_r8,2.3109e-02_r8,7.8380e-04_r8/)
      kbo(:, 1,26, 6) = (/ &
     &1.9994e-02_r8,1.6102e-02_r8,1.1323e-02_r8,6.2216e-03_r8,2.8629e-04_r8/)
      kbo(:, 2,26, 6) = (/ &
     &2.8079e-02_r8,2.2581e-02_r8,1.5869e-02_r8,8.6875e-03_r8,3.6314e-04_r8/)
      kbo(:, 3,26, 6) = (/ &
     &3.8417e-02_r8,3.0834e-02_r8,2.1637e-02_r8,1.1805e-02_r8,4.5229e-04_r8/)
      kbo(:, 4,26, 6) = (/ &
     &5.1448e-02_r8,4.1174e-02_r8,2.8844e-02_r8,1.5712e-02_r8,5.5890e-04_r8/)
      kbo(:, 5,26, 6) = (/ &
     &6.7708e-02_r8,5.4151e-02_r8,3.7876e-02_r8,2.0559e-02_r8,6.6983e-04_r8/)
      kbo(:, 1,27, 6) = (/ &
     &1.7896e-02_r8,1.4429e-02_r8,1.0152e-02_r8,5.5772e-03_r8,2.4427e-04_r8/)
      kbo(:, 2,27, 6) = (/ &
     &2.5042e-02_r8,2.0157e-02_r8,1.4173e-02_r8,7.7571e-03_r8,3.0979e-04_r8/)
      kbo(:, 3,27, 6) = (/ &
     &3.4208e-02_r8,2.7475e-02_r8,1.9284e-02_r8,1.0527e-02_r8,3.8671e-04_r8/)
      kbo(:, 4,27, 6) = (/ &
     &4.5837e-02_r8,3.6717e-02_r8,2.5729e-02_r8,1.4005e-02_r8,4.7399e-04_r8/)
      kbo(:, 5,27, 6) = (/ &
     &6.0284e-02_r8,4.8205e-02_r8,3.3722e-02_r8,1.8275e-02_r8,5.6657e-04_r8/)
      kbo(:, 1,28, 6) = (/ &
     &1.6009e-02_r8,1.2912e-02_r8,9.0950e-03_r8,4.9907e-03_r8,2.0749e-04_r8/)
      kbo(:, 2,28, 6) = (/ &
     &2.2344e-02_r8,1.7993e-02_r8,1.2646e-02_r8,6.9273e-03_r8,2.6196e-04_r8/)
      kbo(:, 3,28, 6) = (/ &
     &3.0516e-02_r8,2.4521e-02_r8,1.7216e-02_r8,9.3897e-03_r8,3.2594e-04_r8/)
      kbo(:, 4,28, 6) = (/ &
     &4.0856e-02_r8,3.2755e-02_r8,2.2958e-02_r8,1.2475e-02_r8,3.9748e-04_r8/)
      kbo(:, 5,28, 6) = (/ &
     &5.3627e-02_r8,4.2900e-02_r8,3.0014e-02_r8,1.6247e-02_r8,4.7387e-04_r8/)
      kbo(:, 1,29, 6) = (/ &
     &1.4262e-02_r8,1.1522e-02_r8,8.1115e-03_r8,4.4530e-03_r8,1.7407e-04_r8/)
      kbo(:, 2,29, 6) = (/ &
     &1.9887e-02_r8,1.6027e-02_r8,1.1276e-02_r8,6.1687e-03_r8,2.1854e-04_r8/)
      kbo(:, 3,29, 6) = (/ &
     &2.7141e-02_r8,2.1827e-02_r8,1.5323e-02_r8,8.3518e-03_r8,2.7116e-04_r8/)
      kbo(:, 4,29, 6) = (/ &
     &3.6246e-02_r8,2.9092e-02_r8,2.0386e-02_r8,1.1064e-02_r8,3.2874e-04_r8/)
      kbo(:, 5,29, 6) = (/ &
     &4.7427e-02_r8,3.8019e-02_r8,2.6585e-02_r8,1.4385e-02_r8,3.8972e-04_r8/)
      kbo(:, 1,30, 6) = (/ &
     &1.2676e-02_r8,1.0246e-02_r8,7.2173e-03_r8,3.9637e-03_r8,1.4416e-04_r8/)
      kbo(:, 2,30, 6) = (/ &
     &1.7653e-02_r8,1.4244e-02_r8,1.0017e-02_r8,5.4770e-03_r8,1.8113e-04_r8/)
      kbo(:, 3,30, 6) = (/ &
     &2.4022e-02_r8,1.9341e-02_r8,1.3583e-02_r8,7.3998e-03_r8,2.2282e-04_r8/)
      kbo(:, 4,30, 6) = (/ &
     &3.1996e-02_r8,2.5721e-02_r8,1.8027e-02_r8,9.7785e-03_r8,2.6784e-04_r8/)
      kbo(:, 5,30, 6) = (/ &
     &4.1773e-02_r8,3.3512e-02_r8,2.3450e-02_r8,1.2688e-02_r8,3.1737e-04_r8/)
      kbo(:, 1,31, 6) = (/ &
     &1.1178e-02_r8,9.0514e-03_r8,6.3801e-03_r8,3.5048e-03_r8,1.1770e-04_r8/)
      kbo(:, 2,31, 6) = (/ &
     &1.5523e-02_r8,1.2547e-02_r8,8.8303e-03_r8,4.8276e-03_r8,1.4724e-04_r8/)
      kbo(:, 3,31, 6) = (/ &
     &2.1060e-02_r8,1.6992e-02_r8,1.1943e-02_r8,6.5025e-03_r8,1.7875e-04_r8/)
      kbo(:, 4,31, 6) = (/ &
     &2.7976e-02_r8,2.2531e-02_r8,1.5799e-02_r8,8.5667e-03_r8,2.1450e-04_r8/)
      kbo(:, 5,31, 6) = (/ &
     &3.6405e-02_r8,2.9271e-02_r8,2.0490e-02_r8,1.1088e-02_r8,2.5503e-04_r8/)
      kbo(:, 1,32, 6) = (/ &
     &9.9013e-03_r8,8.0343e-03_r8,5.6674e-03_r8,3.1129e-03_r8,9.6361e-05_r8/)
      kbo(:, 2,32, 6) = (/ &
     &1.3706e-02_r8,1.1101e-02_r8,7.8125e-03_r8,4.2746e-03_r8,1.1902e-04_r8/)
      kbo(:, 3,32, 6) = (/ &
     &1.8546e-02_r8,1.4995e-02_r8,1.0536e-02_r8,5.7328e-03_r8,1.4373e-04_r8/)
      kbo(:, 4,32, 6) = (/ &
     &2.4550e-02_r8,1.9811e-02_r8,1.3886e-02_r8,7.5313e-03_r8,1.7332e-04_r8/)
      kbo(:, 5,32, 6) = (/ &
     &3.1853e-02_r8,2.5667e-02_r8,1.7969e-02_r8,9.7246e-03_r8,2.0625e-04_r8/)
      kbo(:, 1,33, 6) = (/ &
     &8.7980e-03_r8,7.1519e-03_r8,5.0451e-03_r8,2.7712e-03_r8,7.8202e-05_r8/)
      kbo(:, 2,33, 6) = (/ &
     &1.2135e-02_r8,9.8435e-03_r8,6.9325e-03_r8,3.7902e-03_r8,9.6250e-05_r8/)
      kbo(:, 3,33, 6) = (/ &
     &1.6367e-02_r8,1.3251e-02_r8,9.3075e-03_r8,5.0637e-03_r8,1.1723e-04_r8/)
      kbo(:, 4,33, 6) = (/ &
     &2.1594e-02_r8,1.7451e-02_r8,1.2238e-02_r8,6.6390e-03_r8,1.4129e-04_r8/)
      kbo(:, 5,33, 6) = (/ &
     &2.7922e-02_r8,2.2553e-02_r8,1.5798e-02_r8,8.5480e-03_r8,1.6598e-04_r8/)
      kbo(:, 1,34, 6) = (/ &
     &7.8297e-03_r8,6.3727e-03_r8,4.4952e-03_r8,2.4671e-03_r8,6.3879e-05_r8/)
      kbo(:, 2,34, 6) = (/ &
     &1.0770e-02_r8,8.7510e-03_r8,6.1616e-03_r8,3.3644e-03_r8,7.9137e-05_r8/)
      kbo(:, 3,34, 6) = (/ &
     &1.4484e-02_r8,1.1741e-02_r8,8.2482e-03_r8,4.4844e-03_r8,9.6600e-05_r8/)
      kbo(:, 4,34, 6) = (/ &
     &1.9050e-02_r8,1.5427e-02_r8,1.0820e-02_r8,5.8678e-03_r8,1.1495e-04_r8/)
      kbo(:, 5,34, 6) = (/ &
     &2.4524e-02_r8,1.9867e-02_r8,1.3919e-02_r8,7.5292e-03_r8,1.3453e-04_r8/)
      kbo(:, 1,35, 6) = (/ &
     &6.7630e-03_r8,5.5126e-03_r8,3.8884e-03_r8,2.1340e-03_r8,5.1721e-05_r8/)
      kbo(:, 2,35, 6) = (/ &
     &9.2985e-03_r8,7.5662e-03_r8,5.3252e-03_r8,2.9070e-03_r8,6.4032e-05_r8/)
      kbo(:, 3,35, 6) = (/ &
     &1.2489e-02_r8,1.0141e-02_r8,7.1246e-03_r8,3.8749e-03_r8,7.6974e-05_r8/)
      kbo(:, 4,35, 6) = (/ &
     &1.6400e-02_r8,1.3312e-02_r8,9.3389e-03_r8,5.0659e-03_r8,9.1148e-05_r8/)
      kbo(:, 5,35, 6) = (/ &
     &2.1049e-02_r8,1.7098e-02_r8,1.1985e-02_r8,6.4857e-03_r8,1.0683e-04_r8/)
      kbo(:, 1,36, 6) = (/ &
     &5.6496e-03_r8,4.6119e-03_r8,3.2530e-03_r8,1.7852e-03_r8,4.0312e-05_r8/)
      kbo(:, 2,36, 6) = (/ &
     &7.7767e-03_r8,6.3372e-03_r8,4.4630e-03_r8,2.4380e-03_r8,4.9929e-05_r8/)
      kbo(:, 3,36, 6) = (/ &
     &1.0461e-02_r8,8.5144e-03_r8,5.9836e-03_r8,3.2549e-03_r8,6.0118e-05_r8/)
      kbo(:, 4,36, 6) = (/ &
     &1.3740e-02_r8,1.1182e-02_r8,7.8492e-03_r8,4.2598e-03_r8,7.1064e-05_r8/)
      kbo(:, 5,36, 6) = (/ &
     &1.7612e-02_r8,1.4350e-02_r8,1.0064e-02_r8,5.4485e-03_r8,8.3577e-05_r8/)
      kbo(:, 1,37, 6) = (/ &
     &4.5423e-03_r8,3.7134e-03_r8,2.6216e-03_r8,1.4392e-03_r8,3.1256e-05_r8/)
      kbo(:, 2,37, 6) = (/ &
     &6.2879e-03_r8,5.1321e-03_r8,3.6149e-03_r8,1.9739e-03_r8,3.8734e-05_r8/)
      kbo(:, 3,37, 6) = (/ &
     &8.4900e-03_r8,6.9227e-03_r8,4.8667e-03_r8,2.6482e-03_r8,4.6682e-05_r8/)
      kbo(:, 4,37, 6) = (/ &
     &1.1183e-02_r8,9.1172e-03_r8,6.4017e-03_r8,3.4761e-03_r8,5.5592e-05_r8/)
      kbo(:, 5,37, 6) = (/ &
     &1.4352e-02_r8,1.1719e-02_r8,8.2209e-03_r8,4.4549e-03_r8,6.5503e-05_r8/)
      kbo(:, 1,38, 6) = (/ &
     &3.6392e-03_r8,2.9801e-03_r8,2.1050e-03_r8,1.1562e-03_r8,2.4090e-05_r8/)
      kbo(:, 2,38, 6) = (/ &
     &5.0658e-03_r8,4.1416e-03_r8,2.9194e-03_r8,1.5946e-03_r8,2.9868e-05_r8/)
      kbo(:, 3,38, 6) = (/ &
     &6.8711e-03_r8,5.6107e-03_r8,3.9454e-03_r8,2.1481e-03_r8,3.6072e-05_r8/)
      kbo(:, 4,38, 6) = (/ &
     &9.0731e-03_r8,7.4127e-03_r8,5.2066e-03_r8,2.8281e-03_r8,4.3140e-05_r8/)
      kbo(:, 5,38, 6) = (/ &
     &1.1663e-02_r8,9.5418e-03_r8,6.6954e-03_r8,3.6310e-03_r8,5.1139e-05_r8/)
      kbo(:, 1,39, 6) = (/ &
     &2.9118e-03_r8,2.3886e-03_r8,1.6882e-03_r8,9.2755e-04_r8,1.8391e-05_r8/)
      kbo(:, 2,39, 6) = (/ &
     &4.0750e-03_r8,3.3381e-03_r8,2.3540e-03_r8,1.2863e-03_r8,2.2806e-05_r8/)
      kbo(:, 3,39, 6) = (/ &
     &5.5513e-03_r8,4.5420e-03_r8,3.1948e-03_r8,1.7397e-03_r8,2.7682e-05_r8/)
      kbo(:, 4,39, 6) = (/ &
     &7.3492e-03_r8,6.0179e-03_r8,4.2285e-03_r8,2.2979e-03_r8,3.3352e-05_r8/)
      kbo(:, 5,39, 6) = (/ &
     &9.4667e-03_r8,7.7616e-03_r8,5.4485e-03_r8,2.9560e-03_r8,3.9651e-05_r8/)
      kbo(:, 1,40, 6) = (/ &
     &2.2712e-03_r8,1.8658e-03_r8,1.3192e-03_r8,7.2479e-04_r8,1.3995e-05_r8/)
      kbo(:, 2,40, 6) = (/ &
     &3.2040e-03_r8,2.6288e-03_r8,1.8549e-03_r8,1.0140e-03_r8,1.7455e-05_r8/)
      kbo(:, 3,40, 6) = (/ &
     &4.3985e-03_r8,3.6050e-03_r8,2.5372e-03_r8,1.3813e-03_r8,2.1295e-05_r8/)
      kbo(:, 4,40, 6) = (/ &
     &5.8565e-03_r8,4.8013e-03_r8,3.3753e-03_r8,1.8342e-03_r8,2.5756e-05_r8/)
      kbo(:, 5,40, 6) = (/ &
     &7.5776e-03_r8,6.2219e-03_r8,4.3685e-03_r8,2.3699e-03_r8,3.0715e-05_r8/)
      kbo(:, 1,41, 6) = (/ &
     &1.7612e-03_r8,1.4492e-03_r8,1.0250e-03_r8,5.6325e-04_r8,1.0604e-05_r8/)
      kbo(:, 2,41, 6) = (/ &
     &2.5080e-03_r8,2.0608e-03_r8,1.4546e-03_r8,7.9552e-04_r8,1.3310e-05_r8/)
      kbo(:, 3,41, 6) = (/ &
     &3.4681e-03_r8,2.8477e-03_r8,2.0051e-03_r8,1.0923e-03_r8,1.6349e-05_r8/)
      kbo(:, 4,41, 6) = (/ &
     &4.6501e-03_r8,3.8188e-03_r8,2.6845e-03_r8,1.4588e-03_r8,1.9855e-05_r8/)
      kbo(:, 5,41, 6) = (/ &
     &6.0491e-03_r8,4.9741e-03_r8,3.4944e-03_r8,1.8953e-03_r8,2.3793e-05_r8/)
      kbo(:, 1,42, 6) = (/ &
     &1.3619e-03_r8,1.1225e-03_r8,7.9390e-04_r8,4.3654e-04_r8,7.9892e-06_r8/)
      kbo(:, 2,42, 6) = (/ &
     &1.9585e-03_r8,1.6109e-03_r8,1.1375e-03_r8,6.2244e-04_r8,1.0111e-05_r8/)
      kbo(:, 3,42, 6) = (/ &
     &2.7289e-03_r8,2.2437e-03_r8,1.5805e-03_r8,8.6127e-04_r8,1.2500e-05_r8/)
      kbo(:, 4,42, 6) = (/ &
     &3.6852e-03_r8,3.0311e-03_r8,2.1316e-03_r8,1.1583e-03_r8,1.5248e-05_r8/)
      kbo(:, 5,42, 6) = (/ &
     &4.8235e-03_r8,3.9702e-03_r8,2.7892e-03_r8,1.5134e-03_r8,1.8350e-05_r8/)
      kbo(:, 1,43, 6) = (/ &
     &1.0392e-03_r8,8.5695e-04_r8,6.0598e-04_r8,3.3332e-04_r8,5.9552e-06_r8/)
      kbo(:, 2,43, 6) = (/ &
     &1.5101e-03_r8,1.2436e-03_r8,8.7832e-04_r8,4.8071e-04_r8,7.5961e-06_r8/)
      kbo(:, 3,43, 6) = (/ &
     &2.1254e-03_r8,1.7498e-03_r8,1.2325e-03_r8,6.7181e-04_r8,9.4477e-06_r8/)
      kbo(:, 4,43, 6) = (/ &
     &2.8974e-03_r8,2.3860e-03_r8,1.6788e-03_r8,9.1195e-04_r8,1.1585e-05_r8/)
      kbo(:, 5,43, 6) = (/ &
     &3.8244e-03_r8,3.1517e-03_r8,2.2140e-03_r8,1.2005e-03_r8,1.4013e-05_r8/)
      kbo(:, 1,44, 6) = (/ &
     &7.8683e-04_r8,6.4875e-04_r8,4.5878e-04_r8,2.5223e-04_r8,4.3968e-06_r8/)
      kbo(:, 2,44, 6) = (/ &
     &1.1559e-03_r8,9.5305e-04_r8,6.7277e-04_r8,3.6830e-04_r8,5.6394e-06_r8/)
      kbo(:, 3,44, 6) = (/ &
     &1.6454e-03_r8,1.3558e-03_r8,9.5534e-04_r8,5.2055e-04_r8,7.0859e-06_r8/)
      kbo(:, 4,44, 6) = (/ &
     &2.2669e-03_r8,1.8686e-03_r8,1.3148e-03_r8,7.1399e-04_r8,8.7462e-06_r8/)
      kbo(:, 5,44, 6) = (/ &
     &3.0201e-03_r8,2.4917e-03_r8,1.7509e-03_r8,9.4904e-04_r8,1.0639e-05_r8/)
      kbo(:, 1,45, 6) = (/ &
     &5.9365e-04_r8,4.8959e-04_r8,3.4607e-04_r8,1.9020e-04_r8,3.2229e-06_r8/)
      kbo(:, 2,45, 6) = (/ &
     &8.8218e-04_r8,7.2803e-04_r8,5.1390e-04_r8,2.8115e-04_r8,4.1709e-06_r8/)
      kbo(:, 3,45, 6) = (/ &
     &1.2705e-03_r8,1.0482e-03_r8,7.3838e-04_r8,4.0225e-04_r8,5.2818e-06_r8/)
      kbo(:, 4,45, 6) = (/ &
     &1.7692e-03_r8,1.4597e-03_r8,1.0269e-03_r8,5.5768e-04_r8,6.5567e-06_r8/)
      kbo(:, 5,45, 6) = (/ &
     &2.3806e-03_r8,1.9657e-03_r8,1.3812e-03_r8,7.4841e-04_r8,8.0347e-06_r8/)
      kbo(:, 1,46, 6) = (/ &
     &4.4335e-04_r8,3.6560e-04_r8,2.5820e-04_r8,1.4186e-04_r8,2.3394e-06_r8/)
      kbo(:, 2,46, 6) = (/ &
     &6.6652e-04_r8,5.5048e-04_r8,3.8857e-04_r8,2.1254e-04_r8,3.0543e-06_r8/)
      kbo(:, 3,46, 6) = (/ &
     &9.7139e-04_r8,8.0233e-04_r8,5.6521e-04_r8,3.0796e-04_r8,3.9016e-06_r8/)
      kbo(:, 4,46, 6) = (/ &
     &1.3697e-03_r8,1.1313e-03_r8,7.9539e-04_r8,4.3177e-04_r8,4.8930e-06_r8/)
      kbo(:, 5,46, 6) = (/ &
     &1.8630e-03_r8,1.5401e-03_r8,1.0822e-03_r8,5.8603e-04_r8,6.0211e-06_r8/)
      kbo(:, 1,47, 6) = (/ &
     &3.2494e-04_r8,2.6781e-04_r8,1.8906e-04_r8,1.0379e-04_r8,1.6703e-06_r8/)
      kbo(:, 2,47, 6) = (/ &
     &4.9477e-04_r8,4.0876e-04_r8,2.8822e-04_r8,1.5780e-04_r8,2.2235e-06_r8/)
      kbo(:, 3,47, 6) = (/ &
     &7.3190e-04_r8,6.0441e-04_r8,4.2581e-04_r8,2.3196e-04_r8,2.8600e-06_r8/)
      kbo(:, 4,47, 6) = (/ &
     &1.0450e-03_r8,8.6362e-04_r8,6.0711e-04_r8,3.2954e-04_r8,3.6203e-06_r8/)
      kbo(:, 5,47, 6) = (/ &
     &1.4403e-03_r8,1.1920e-03_r8,8.3715e-04_r8,4.5311e-04_r8,4.4864e-06_r8/)
      kbo(:, 1,48, 6) = (/ &
     &2.3680e-04_r8,1.9527e-04_r8,1.3764e-04_r8,7.5497e-05_r8,1.1789e-06_r8/)
      kbo(:, 2,48, 6) = (/ &
     &3.6634e-04_r8,3.0233e-04_r8,2.1313e-04_r8,1.1661e-04_r8,1.5963e-06_r8/)
      kbo(:, 3,48, 6) = (/ &
     &5.4895e-04_r8,4.5372e-04_r8,3.1944e-04_r8,1.7402e-04_r8,2.0888e-06_r8/)
      kbo(:, 4,48, 6) = (/ &
     &7.9543e-04_r8,6.5717e-04_r8,4.6181e-04_r8,2.5062e-04_r8,2.6621e-06_r8/)
      kbo(:, 5,48, 6) = (/ &
     &1.1099e-03_r8,9.1890e-04_r8,6.4520e-04_r8,3.4917e-04_r8,3.3226e-06_r8/)
      kbo(:, 1,49, 6) = (/ &
     &1.7167e-04_r8,1.4156e-04_r8,9.9697e-05_r8,5.4621e-05_r8,8.2177e-07_r8/)
      kbo(:, 2,49, 6) = (/ &
     &2.6978e-04_r8,2.2270e-04_r8,1.5688e-04_r8,8.5772e-05_r8,1.1335e-06_r8/)
      kbo(:, 3,49, 6) = (/ &
     &4.1033e-04_r8,3.3911e-04_r8,2.3859e-04_r8,1.2993e-04_r8,1.5022e-06_r8/)
      kbo(:, 4,49, 6) = (/ &
     &6.0289e-04_r8,4.9870e-04_r8,3.5040e-04_r8,1.9001e-04_r8,1.9421e-06_r8/)
      kbo(:, 5,49, 6) = (/ &
     &8.5268e-04_r8,7.0612e-04_r8,4.9559e-04_r8,2.6808e-04_r8,2.4464e-06_r8/)
      kbo(:, 1,50, 6) = (/ &
     &1.2531e-04_r8,1.0333e-04_r8,7.2754e-05_r8,3.9781e-05_r8,5.8260e-07_r8/)
      kbo(:, 2,50, 6) = (/ &
     &2.0028e-04_r8,1.6520e-04_r8,1.1625e-04_r8,6.3517e-05_r8,8.1312e-07_r8/)
      kbo(:, 3,50, 6) = (/ &
     &3.0881e-04_r8,2.5524e-04_r8,1.7955e-04_r8,9.7765e-05_r8,1.0963e-06_r8/)
      kbo(:, 4,50, 6) = (/ &
     &4.6015e-04_r8,3.8061e-04_r8,2.6731e-04_r8,1.4488e-04_r8,1.4340e-06_r8/)
      kbo(:, 5,50, 6) = (/ &
     &6.5988e-04_r8,5.4636e-04_r8,3.8320e-04_r8,2.0709e-04_r8,1.8202e-06_r8/)
      kbo(:, 1,51, 6) = (/ &
     &9.1633e-05_r8,7.5509e-05_r8,5.3128e-05_r8,2.9020e-05_r8,4.1464e-07_r8/)
      kbo(:, 2,51, 6) = (/ &
     &1.4891e-04_r8,1.2270e-04_r8,8.6279e-05_r8,4.7099e-05_r8,5.8807e-07_r8/)
      kbo(:, 3,51, 6) = (/ &
     &2.3292e-04_r8,1.9249e-04_r8,1.3529e-04_r8,7.3646e-05_r8,8.0371e-07_r8/)
      kbo(:, 4,51, 6) = (/ &
     &3.5233e-04_r8,2.9123e-04_r8,2.0433e-04_r8,1.1072e-04_r8,1.0615e-06_r8/)
      kbo(:, 5,51, 6) = (/ &
     &5.1166e-04_r8,4.2368e-04_r8,2.9697e-04_r8,1.6038e-04_r8,1.3623e-06_r8/)
      kbo(:, 1,52, 6) = (/ &
     &6.6748e-05_r8,5.4951e-05_r8,3.8637e-05_r8,2.1072e-05_r8,2.9423e-07_r8/)
      kbo(:, 2,52, 6) = (/ &
     &1.1034e-04_r8,9.0898e-05_r8,6.3804e-05_r8,3.4773e-05_r8,4.2185e-07_r8/)
      kbo(:, 3,52, 6) = (/ &
     &1.7525e-04_r8,1.4472e-04_r8,1.0161e-04_r8,5.5277e-05_r8,5.8386e-07_r8/)
      kbo(:, 4,52, 6) = (/ &
     &2.6896e-04_r8,2.2246e-04_r8,1.5598e-04_r8,8.4497e-05_r8,7.8029e-07_r8/)
      kbo(:, 5,52, 6) = (/ &
     &3.9638e-04_r8,3.2814e-04_r8,2.2978e-04_r8,1.2397e-04_r8,1.0114e-06_r8/)
      kbo(:, 1,53, 6) = (/ &
     &4.8387e-05_r8,3.9789e-05_r8,2.7956e-05_r8,1.5224e-05_r8,2.0710e-07_r8/)
      kbo(:, 2,53, 6) = (/ &
     &8.1422e-05_r8,6.7055e-05_r8,4.7034e-05_r8,2.5569e-05_r8,3.0032e-07_r8/)
      kbo(:, 3,53, 6) = (/ &
     &1.3143e-04_r8,1.0846e-04_r8,7.6092e-05_r8,4.1325e-05_r8,4.2132e-07_r8/)
      kbo(:, 4,53, 6) = (/ &
     &2.0478e-04_r8,1.6937e-04_r8,1.1872e-04_r8,6.4236e-05_r8,5.6954e-07_r8/)
      kbo(:, 5,53, 6) = (/ &
     &3.0662e-04_r8,2.5374e-04_r8,1.7755e-04_r8,9.5705e-05_r8,7.4673e-07_r8/)
      kbo(:, 1,54, 6) = (/ &
     &3.5548e-05_r8,2.9201e-05_r8,2.0499e-05_r8,1.1142e-05_r8,1.4888e-07_r8/)
      kbo(:, 2,54, 6) = (/ &
     &6.0867e-05_r8,5.0080e-05_r8,3.5102e-05_r8,1.9053e-05_r8,2.1957e-07_r8/)
      kbo(:, 3,54, 6) = (/ &
     &9.9905e-05_r8,8.2294e-05_r8,5.7679e-05_r8,3.1278e-05_r8,3.1167e-07_r8/)
      kbo(:, 4,54, 6) = (/ &
     &1.5784e-04_r8,1.3048e-04_r8,9.1376e-05_r8,4.9396e-05_r8,4.2569e-07_r8/)
      kbo(:, 5,54, 6) = (/ &
     &2.3990e-04_r8,1.9844e-04_r8,1.3879e-04_r8,7.4726e-05_r8,5.6432e-07_r8/)
      kbo(:, 1,55, 6) = (/ &
     &2.6254e-05_r8,2.1551e-05_r8,1.5109e-05_r8,8.2013e-06_r8,1.0776e-07_r8/)
      kbo(:, 2,55, 6) = (/ &
     &4.5756e-05_r8,3.7594e-05_r8,2.6330e-05_r8,1.4266e-05_r8,1.6227e-07_r8/)
      kbo(:, 3,55, 6) = (/ &
     &7.6387e-05_r8,6.2840e-05_r8,4.3983e-05_r8,2.3813e-05_r8,2.3322e-07_r8/)
      kbo(:, 4,55, 6) = (/ &
     &1.2233e-04_r8,1.0105e-04_r8,7.0729e-05_r8,3.8184e-05_r8,3.2242e-07_r8/)
      kbo(:, 5,55, 6) = (/ &
     &1.8866e-04_r8,1.5604e-04_r8,1.0907e-04_r8,5.8660e-05_r8,4.3190e-07_r8/)
      kbo(:, 1,56, 6) = (/ &
     &1.9352e-05_r8,1.5886e-05_r8,1.1124e-05_r8,6.0284e-06_r8,7.7832e-08_r8/)
      kbo(:, 2,56, 6) = (/ &
     &3.4378e-05_r8,2.8197e-05_r8,1.9721e-05_r8,1.0667e-05_r8,1.1948e-07_r8/)
      kbo(:, 3,56, 6) = (/ &
     &5.8349e-05_r8,4.7950e-05_r8,3.3520e-05_r8,1.8111e-05_r8,1.7363e-07_r8/)
      kbo(:, 4,56, 6) = (/ &
     &9.4866e-05_r8,7.8290e-05_r8,5.4723e-05_r8,2.9510e-05_r8,2.4385e-07_r8/)
      kbo(:, 5,56, 6) = (/ &
     &1.4839e-04_r8,1.2273e-04_r8,8.5680e-05_r8,4.6045e-05_r8,3.3022e-07_r8/)
      kbo(:, 1,57, 6) = (/ &
     &1.4255e-05_r8,1.1680e-05_r8,8.1776e-06_r8,4.4235e-06_r8,5.5927e-08_r8/)
      kbo(:, 2,57, 6) = (/ &
     &2.5815e-05_r8,2.1132e-05_r8,1.4763e-05_r8,7.9663e-06_r8,8.7522e-08_r8/)
      kbo(:, 3,57, 6) = (/ &
     &4.4552e-05_r8,3.6579e-05_r8,2.5531e-05_r8,1.3761e-05_r8,1.2925e-07_r8/)
      kbo(:, 4,57, 6) = (/ &
     &7.3589e-05_r8,6.0640e-05_r8,4.2341e-05_r8,2.2797e-05_r8,1.8364e-07_r8/)
      kbo(:, 5,57, 6) = (/ &
     &1.1687e-04_r8,9.6565e-05_r8,6.7349e-05_r8,3.6145e-05_r8,2.5190e-07_r8/)
      kbo(:, 1,58, 6) = (/ &
     &5.1283e-06_r8,4.8164e-06_r8,3.9533e-06_r8,2.5844e-06_r8,4.0411e-08_r8/)
      kbo(:, 2,58, 6) = (/ &
     &9.4663e-06_r8,8.8829e-06_r8,7.2756e-06_r8,4.7397e-06_r8,6.4616e-08_r8/)
      kbo(:, 3,58, 6) = (/ &
     &1.6608e-05_r8,1.5628e-05_r8,1.2791e-05_r8,8.3232e-06_r8,9.6916e-08_r8/)
      kbo(:, 4,58, 6) = (/ &
     &2.7869e-05_r8,2.6331e-05_r8,2.1549e-05_r8,1.4010e-05_r8,1.3884e-07_r8/)
      kbo(:, 5,58, 6) = (/ &
     &4.4916e-05_r8,4.2582e-05_r8,3.4830e-05_r8,2.2586e-05_r8,1.9305e-07_r8/)
      kbo(:, 1,59, 6) = (/ &
     &4.1166e-06_r8,3.8763e-06_r8,3.1932e-06_r8,2.0984e-06_r8,3.3138e-08_r8/)
      kbo(:, 2,59, 6) = (/ &
     &7.6679e-06_r8,7.2183e-06_r8,5.9356e-06_r8,3.8849e-06_r8,5.3542e-08_r8/)
      kbo(:, 3,59, 6) = (/ &
     &1.3578e-05_r8,1.2809e-05_r8,1.0527e-05_r8,6.8844e-06_r8,8.1037e-08_r8/)
      kbo(:, 4,59, 6) = (/ &
     &2.2972e-05_r8,2.1775e-05_r8,1.7891e-05_r8,1.1690e-05_r8,1.1735e-07_r8/)
      kbo(:, 5,59, 6) = (/ &
     &3.7296e-05_r8,3.5490e-05_r8,2.9150e-05_r8,1.9007e-05_r8,1.6270e-07_r8/)
      kbo(:, 1,13, 7) = (/ &
     &4.2167e-01_r8,3.2553e-01_r8,2.2695e-01_r8,1.2184e-01_r8,4.0030e-03_r8/)
      kbo(:, 2,13, 7) = (/ &
     &6.0140e-01_r8,4.6380e-01_r8,3.2184e-01_r8,1.7190e-01_r8,5.1104e-03_r8/)
      kbo(:, 3,13, 7) = (/ &
     &8.1816e-01_r8,6.3015e-01_r8,4.3650e-01_r8,2.3296e-01_r8,6.4365e-03_r8/)
      kbo(:, 4,13, 7) = (/ &
     &1.0780e+00_r8,8.2908e-01_r8,5.7271e-01_r8,3.0519e-01_r8,7.8514e-03_r8/)
      kbo(:, 5,13, 7) = (/ &
     &1.3871e+00_r8,1.0650e+00_r8,7.3566e-01_r8,3.9202e-01_r8,9.6931e-03_r8/)
      kbo(:, 1,14, 7) = (/ &
     &3.8425e-01_r8,2.9801e-01_r8,2.0688e-01_r8,1.1055e-01_r8,3.4668e-03_r8/)
      kbo(:, 2,14, 7) = (/ &
     &5.4386e-01_r8,4.2093e-01_r8,2.9177e-01_r8,1.5544e-01_r8,4.5429e-03_r8/)
      kbo(:, 3,14, 7) = (/ &
     &7.3998e-01_r8,5.7137e-01_r8,3.9497e-01_r8,2.0995e-01_r8,5.6171e-03_r8/)
      kbo(:, 4,14, 7) = (/ &
     &9.7642e-01_r8,7.5246e-01_r8,5.1952e-01_r8,2.7577e-01_r8,6.9867e-03_r8/)
      kbo(:, 5,14, 7) = (/ &
     &1.2610e+00_r8,9.7017e-01_r8,6.6888e-01_r8,3.5427e-01_r8,8.6535e-03_r8/)
      kbo(:, 1,15, 7) = (/ &
     &3.3299e-01_r8,2.5933e-01_r8,1.7991e-01_r8,9.5905e-02_r8,2.9886e-03_r8/)
      kbo(:, 2,15, 7) = (/ &
     &4.6962e-01_r8,3.6448e-01_r8,2.5234e-01_r8,1.3421e-01_r8,3.8718e-03_r8/)
      kbo(:, 3,15, 7) = (/ &
     &6.3987e-01_r8,4.9512e-01_r8,3.4211e-01_r8,1.8150e-01_r8,4.8805e-03_r8/)
      kbo(:, 4,15, 7) = (/ &
     &8.4586e-01_r8,6.5388e-01_r8,4.5155e-01_r8,2.3908e-01_r8,6.1279e-03_r8/)
      kbo(:, 5,15, 7) = (/ &
     &1.0948e+00_r8,8.4428e-01_r8,5.8246e-01_r8,3.0839e-01_r8,7.4849e-03_r8/)
      kbo(:, 1,16, 7) = (/ &
     &2.8051e-01_r8,2.1899e-01_r8,1.5183e-01_r8,8.0896e-02_r8,2.5509e-03_r8/)
      kbo(:, 2,16, 7) = (/ &
     &3.9506e-01_r8,3.0781e-01_r8,2.1302e-01_r8,1.1324e-01_r8,3.3108e-03_r8/)
      kbo(:, 3,16, 7) = (/ &
     &5.3870e-01_r8,4.1855e-01_r8,2.8938e-01_r8,1.5357e-01_r8,4.2013e-03_r8/)
      kbo(:, 4,16, 7) = (/ &
     &7.1526e-01_r8,5.5449e-01_r8,3.8283e-01_r8,2.0269e-01_r8,5.1902e-03_r8/)
      kbo(:, 5,16, 7) = (/ &
     &9.2727e-01_r8,7.1785e-01_r8,4.9548e-01_r8,2.6200e-01_r8,6.4068e-03_r8/)
      kbo(:, 1,17, 7) = (/ &
     &2.3378e-01_r8,1.8318e-01_r8,1.2698e-01_r8,6.7717e-02_r8,2.1927e-03_r8/)
      kbo(:, 2,17, 7) = (/ &
     &3.2948e-01_r8,2.5742e-01_r8,1.7822e-01_r8,9.4896e-02_r8,2.8584e-03_r8/)
      kbo(:, 3,17, 7) = (/ &
     &4.5000e-01_r8,3.5080e-01_r8,2.4241e-01_r8,1.2872e-01_r8,3.6126e-03_r8/)
      kbo(:, 4,17, 7) = (/ &
     &5.9887e-01_r8,4.6579e-01_r8,3.2151e-01_r8,1.7042e-01_r8,4.5208e-03_r8/)
      kbo(:, 5,17, 7) = (/ &
     &7.7711e-01_r8,6.0357e-01_r8,4.1660e-01_r8,2.2035e-01_r8,5.5539e-03_r8/)
      kbo(:, 1,18, 7) = (/ &
     &1.9227e-01_r8,1.5110e-01_r8,1.0483e-01_r8,5.6032e-02_r8,1.9220e-03_r8/)
      kbo(:, 2,18, 7) = (/ &
     &2.7135e-01_r8,2.1238e-01_r8,1.4707e-01_r8,7.8382e-02_r8,2.4923e-03_r8/)
      kbo(:, 3,18, 7) = (/ &
     &3.7049e-01_r8,2.8960e-01_r8,2.0022e-01_r8,1.0642e-01_r8,3.1976e-03_r8/)
      kbo(:, 4,18, 7) = (/ &
     &4.9231e-01_r8,3.8398e-01_r8,2.6515e-01_r8,1.4069e-01_r8,3.9529e-03_r8/)
      kbo(:, 5,18, 7) = (/ &
     &6.4035e-01_r8,4.9892e-01_r8,3.4418e-01_r8,1.8220e-01_r8,4.8074e-03_r8/)
      kbo(:, 1,19, 7) = (/ &
     &1.6097e-01_r8,1.2681e-01_r8,8.7983e-02_r8,4.7067e-02_r8,1.6998e-03_r8/)
      kbo(:, 2,19, 7) = (/ &
     &2.2674e-01_r8,1.7812e-01_r8,1.2337e-01_r8,6.5758e-02_r8,2.2148e-03_r8/)
      kbo(:, 3,19, 7) = (/ &
     &3.0942e-01_r8,2.4239e-01_r8,1.6768e-01_r8,8.9247e-02_r8,2.8171e-03_r8/)
      kbo(:, 4,19, 7) = (/ &
     &4.1121e-01_r8,3.2156e-01_r8,2.2226e-01_r8,1.1805e-01_r8,3.4852e-03_r8/)
      kbo(:, 5,19, 7) = (/ &
     &5.3661e-01_r8,4.1891e-01_r8,2.8897e-01_r8,1.5308e-01_r8,4.2703e-03_r8/)
      kbo(:, 1,20, 7) = (/ &
     &1.3816e-01_r8,1.0899e-01_r8,7.5568e-02_r8,4.0384e-02_r8,1.5084e-03_r8/)
      kbo(:, 2,20, 7) = (/ &
     &1.9390e-01_r8,1.5237e-01_r8,1.0558e-01_r8,5.6347e-02_r8,1.9533e-03_r8/)
      kbo(:, 3,20, 7) = (/ &
     &2.6431e-01_r8,2.0734e-01_r8,1.4349e-01_r8,7.6381e-02_r8,2.4829e-03_r8/)
      kbo(:, 4,20, 7) = (/ &
     &3.5230e-01_r8,2.7579e-01_r8,1.9049e-01_r8,1.0107e-01_r8,3.1175e-03_r8/)
      kbo(:, 5,20, 7) = (/ &
     &4.5959e-01_r8,3.5917e-01_r8,2.4774e-01_r8,1.3132e-01_r8,3.8257e-03_r8/)
      kbo(:, 1,21, 7) = (/ &
     &1.1885e-01_r8,9.3725e-02_r8,6.5041e-02_r8,3.4803e-02_r8,1.3411e-03_r8/)
      kbo(:, 2,21, 7) = (/ &
     &1.6635e-01_r8,1.3102e-01_r8,9.0813e-02_r8,4.8481e-02_r8,1.7301e-03_r8/)
      kbo(:, 3,21, 7) = (/ &
     &2.2707e-01_r8,1.7845e-01_r8,1.2348e-01_r8,6.5731e-02_r8,2.2027e-03_r8/)
      kbo(:, 4,21, 7) = (/ &
     &3.0299e-01_r8,2.3748e-01_r8,1.6403e-01_r8,8.7154e-02_r8,2.7646e-03_r8/)
      kbo(:, 5,21, 7) = (/ &
     &3.9491e-01_r8,3.0909e-01_r8,2.1323e-01_r8,1.1320e-01_r8,3.3663e-03_r8/)
      kbo(:, 1,22, 7) = (/ &
     &1.0371e-01_r8,8.1936e-02_r8,5.6886e-02_r8,3.0452e-02_r8,1.1973e-03_r8/)
      kbo(:, 2,22, 7) = (/ &
     &1.4515e-01_r8,1.1443e-01_r8,7.9345e-02_r8,4.2377e-02_r8,1.5408e-03_r8/)
      kbo(:, 3,22, 7) = (/ &
     &1.9815e-01_r8,1.5584e-01_r8,1.0788e-01_r8,5.7461e-02_r8,1.9609e-03_r8/)
      kbo(:, 4,22, 7) = (/ &
     &2.6352e-01_r8,2.0697e-01_r8,1.4313e-01_r8,7.6128e-02_r8,2.4333e-03_r8/)
      kbo(:, 5,22, 7) = (/ &
     &3.4221e-01_r8,2.6821e-01_r8,1.8537e-01_r8,9.8647e-02_r8,2.9393e-03_r8/)
      kbo(:, 1,23, 7) = (/ &
     &9.0639e-02_r8,7.1734e-02_r8,4.9824e-02_r8,2.6695e-02_r8,1.0611e-03_r8/)
      kbo(:, 2,23, 7) = (/ &
     &1.2684e-01_r8,1.0014e-01_r8,6.9426e-02_r8,3.7107e-02_r8,1.3714e-03_r8/)
      kbo(:, 3,23, 7) = (/ &
     &1.7268e-01_r8,1.3597e-01_r8,9.4123e-02_r8,5.0237e-02_r8,1.7212e-03_r8/)
      kbo(:, 4,23, 7) = (/ &
     &2.2866e-01_r8,1.7972e-01_r8,1.2432e-01_r8,6.6277e-02_r8,2.1161e-03_r8/)
      kbo(:, 5,23, 7) = (/ &
     &2.9584e-01_r8,2.3227e-01_r8,1.6067e-01_r8,8.5547e-02_r8,2.5346e-03_r8/)
      kbo(:, 1,24, 7) = (/ &
     &8.0071e-02_r8,6.3444e-02_r8,4.4064e-02_r8,2.3644e-02_r8,9.3348e-04_r8/)
      kbo(:, 2,24, 7) = (/ &
     &1.1181e-01_r8,8.8354e-02_r8,6.1271e-02_r8,3.2794e-02_r8,1.1882e-03_r8/)
      kbo(:, 3,24, 7) = (/ &
     &1.5149e-01_r8,1.1939e-01_r8,8.2725e-02_r8,4.4223e-02_r8,1.4832e-03_r8/)
      kbo(:, 4,24, 7) = (/ &
     &1.9978e-01_r8,1.5722e-01_r8,1.0888e-01_r8,5.8128e-02_r8,1.8190e-03_r8/)
      kbo(:, 5,24, 7) = (/ &
     &2.5770e-01_r8,2.0260e-01_r8,1.4030e-01_r8,7.4844e-02_r8,2.1747e-03_r8/)
      kbo(:, 1,25, 7) = (/ &
     &7.0951e-02_r8,5.6269e-02_r8,3.9108e-02_r8,2.1016e-02_r8,8.0964e-04_r8/)
      kbo(:, 2,25, 7) = (/ &
     &9.8623e-02_r8,7.8013e-02_r8,5.4088e-02_r8,2.9015e-02_r8,1.0247e-03_r8/)
      kbo(:, 3,25, 7) = (/ &
     &1.3295e-01_r8,1.0488e-01_r8,7.2709e-02_r8,3.8919e-02_r8,1.2776e-03_r8/)
      kbo(:, 4,25, 7) = (/ &
     &1.7470e-01_r8,1.3764e-01_r8,9.5373e-02_r8,5.0958e-02_r8,1.5592e-03_r8/)
      kbo(:, 5,25, 7) = (/ &
     &2.2493e-01_r8,1.7708e-01_r8,1.2270e-01_r8,6.5502e-02_r8,1.8657e-03_r8/)
      kbo(:, 1,26, 7) = (/ &
     &6.3451e-02_r8,5.0352e-02_r8,3.4999e-02_r8,1.8811e-02_r8,7.0696e-04_r8/)
      kbo(:, 2,26, 7) = (/ &
     &8.7646e-02_r8,6.9321e-02_r8,4.8128e-02_r8,2.5820e-02_r8,8.9108e-04_r8/)
      kbo(:, 3,26, 7) = (/ &
     &1.1756e-01_r8,9.2804e-02_r8,6.4336e-02_r8,3.4465e-02_r8,1.1063e-03_r8/)
      kbo(:, 4,26, 7) = (/ &
     &1.5401e-01_r8,1.2150e-01_r8,8.4218e-02_r8,4.5022e-02_r8,1.3420e-03_r8/)
      kbo(:, 5,26, 7) = (/ &
     &1.9847e-01_r8,1.5626e-01_r8,1.0822e-01_r8,5.7833e-02_r8,1.6057e-03_r8/)
      kbo(:, 1,27, 7) = (/ &
     &5.6793e-02_r8,4.5057e-02_r8,3.1339e-02_r8,1.6842e-02_r8,6.0571e-04_r8/)
      kbo(:, 2,27, 7) = (/ &
     &7.8027e-02_r8,6.1732e-02_r8,4.2853e-02_r8,2.2968e-02_r8,7.6180e-04_r8/)
      kbo(:, 3,27, 7) = (/ &
     &1.0421e-01_r8,8.2314e-02_r8,5.7109e-02_r8,3.0579e-02_r8,9.4573e-04_r8/)
      kbo(:, 4,27, 7) = (/ &
     &1.3651e-01_r8,1.0769e-01_r8,7.4645e-02_r8,3.9915e-02_r8,1.1425e-03_r8/)
      kbo(:, 5,27, 7) = (/ &
     &1.7591e-01_r8,1.3862e-01_r8,9.6018e-02_r8,5.1325e-02_r8,1.3608e-03_r8/)
      kbo(:, 1,28, 7) = (/ &
     &5.0832e-02_r8,4.0335e-02_r8,2.8062e-02_r8,1.5080e-02_r8,5.0959e-04_r8/)
      kbo(:, 2,28, 7) = (/ &
     &6.9491e-02_r8,5.4973e-02_r8,3.8187e-02_r8,2.0466e-02_r8,6.4488e-04_r8/)
      kbo(:, 3,28, 7) = (/ &
     &9.2684e-02_r8,7.3230e-02_r8,5.0823e-02_r8,2.7216e-02_r8,7.9606e-04_r8/)
      kbo(:, 4,28, 7) = (/ &
     &1.2155e-01_r8,9.5886e-02_r8,6.6455e-02_r8,3.5548e-02_r8,9.5678e-04_r8/)
      kbo(:, 5,28, 7) = (/ &
     &1.5688e-01_r8,1.2363e-01_r8,8.5583e-02_r8,4.5732e-02_r8,1.1415e-03_r8/)
      kbo(:, 1,29, 7) = (/ &
     &4.5296e-02_r8,3.5922e-02_r8,2.4992e-02_r8,1.3423e-02_r8,4.2743e-04_r8/)
      kbo(:, 2,29, 7) = (/ &
     &6.1694e-02_r8,4.8833e-02_r8,3.3922e-02_r8,1.8191e-02_r8,5.3907e-04_r8/)
      kbo(:, 3,29, 7) = (/ &
     &8.2276e-02_r8,6.5053e-02_r8,4.5148e-02_r8,2.4171e-02_r8,6.5935e-04_r8/)
      kbo(:, 4,29, 7) = (/ &
     &1.0791e-01_r8,8.5197e-02_r8,5.9066e-02_r8,3.1598e-02_r8,7.9358e-04_r8/)
      kbo(:, 5,29, 7) = (/ &
     &1.3964e-01_r8,1.1005e-01_r8,7.6235e-02_r8,4.0713e-02_r8,9.4519e-04_r8/)
      kbo(:, 1,30, 7) = (/ &
     &4.0185e-02_r8,3.1886e-02_r8,2.2195e-02_r8,1.1919e-02_r8,3.5485e-04_r8/)
      kbo(:, 2,30, 7) = (/ &
     &5.4626e-02_r8,4.3278e-02_r8,3.0084e-02_r8,1.6135e-02_r8,4.4303e-04_r8/)
      kbo(:, 3,30, 7) = (/ &
     &7.2953e-02_r8,5.7701e-02_r8,4.0048e-02_r8,2.1442e-02_r8,5.4169e-04_r8/)
      kbo(:, 4,30, 7) = (/ &
     &9.5812e-02_r8,7.5701e-02_r8,5.2497e-02_r8,2.8075e-02_r8,6.5509e-04_r8/)
      kbo(:, 5,30, 7) = (/ &
     &1.2402e-01_r8,9.7862e-02_r8,6.7806e-02_r8,3.6235e-02_r8,7.7850e-04_r8/)
      kbo(:, 1,31, 7) = (/ &
     &3.5348e-02_r8,2.8090e-02_r8,1.9559e-02_r8,1.0513e-02_r8,2.9039e-04_r8/)
      kbo(:, 2,31, 7) = (/ &
     &4.8053e-02_r8,3.8118e-02_r8,2.6496e-02_r8,1.4221e-02_r8,3.5964e-04_r8/)
      kbo(:, 3,31, 7) = (/ &
     &6.4212e-02_r8,5.0845e-02_r8,3.5309e-02_r8,1.8919e-02_r8,4.4117e-04_r8/)
      kbo(:, 4,31, 7) = (/ &
     &8.4429e-02_r8,6.6772e-02_r8,4.6322e-02_r8,2.4787e-02_r8,5.3116e-04_r8/)
      kbo(:, 5,31, 7) = (/ &
     &1.0928e-01_r8,8.6339e-02_r8,5.9901e-02_r8,3.2032e-02_r8,6.3348e-04_r8/)
      kbo(:, 1,32, 7) = (/ &
     &3.1311e-02_r8,2.4896e-02_r8,1.7336e-02_r8,9.3247e-03_r8,2.3608e-04_r8/)
      kbo(:, 2,32, 7) = (/ &
     &4.2575e-02_r8,3.3801e-02_r8,2.3511e-02_r8,1.2616e-02_r8,2.9452e-04_r8/)
      kbo(:, 3,32, 7) = (/ &
     &5.6935e-02_r8,4.5129e-02_r8,3.1359e-02_r8,1.6809e-02_r8,3.6093e-04_r8/)
      kbo(:, 4,32, 7) = (/ &
     &7.4842e-02_r8,5.9256e-02_r8,4.1156e-02_r8,2.2039e-02_r8,4.3435e-04_r8/)
      kbo(:, 5,32, 7) = (/ &
     &9.6933e-02_r8,7.6740e-02_r8,5.3274e-02_r8,2.8476e-02_r8,5.1533e-04_r8/)
      kbo(:, 1,33, 7) = (/ &
     &2.7886e-02_r8,2.2206e-02_r8,1.5465e-02_r8,8.3176e-03_r8,1.9330e-04_r8/)
      kbo(:, 2,33, 7) = (/ &
     &3.7954e-02_r8,3.0161e-02_r8,2.0981e-02_r8,1.1260e-02_r8,2.4048e-04_r8/)
      kbo(:, 3,33, 7) = (/ &
     &5.0729e-02_r8,4.0269e-02_r8,2.7996e-02_r8,1.5008e-02_r8,2.9283e-04_r8/)
      kbo(:, 4,33, 7) = (/ &
     &6.6680e-02_r8,5.2910e-02_r8,3.6768e-02_r8,1.9685e-02_r8,3.5174e-04_r8/)
      kbo(:, 5,33, 7) = (/ &
     &8.6325e-02_r8,6.8491e-02_r8,4.7579e-02_r8,2.5448e-02_r8,4.1781e-04_r8/)
      kbo(:, 1,34, 7) = (/ &
     &2.4971e-02_r8,1.9901e-02_r8,1.3860e-02_r8,7.4508e-03_r8,1.5943e-04_r8/)
      kbo(:, 2,34, 7) = (/ &
     &3.3993e-02_r8,2.7044e-02_r8,1.8817e-02_r8,1.0102e-02_r8,1.9737e-04_r8/)
      kbo(:, 3,34, 7) = (/ &
     &4.5431e-02_r8,3.6116e-02_r8,2.5118e-02_r8,1.3468e-02_r8,2.4097e-04_r8/)
      kbo(:, 4,34, 7) = (/ &
     &5.9751e-02_r8,4.7485e-02_r8,3.3007e-02_r8,1.7673e-02_r8,2.8983e-04_r8/)
      kbo(:, 5,34, 7) = (/ &
     &7.7416e-02_r8,6.1530e-02_r8,4.2751e-02_r8,2.2863e-02_r8,3.4328e-04_r8/)
      kbo(:, 1,35, 7) = (/ &
     &2.1796e-02_r8,1.7387e-02_r8,1.2111e-02_r8,6.5084e-03_r8,1.2835e-04_r8/)
      kbo(:, 2,35, 7) = (/ &
     &2.9698e-02_r8,2.3666e-02_r8,1.6479e-02_r8,8.8433e-03_r8,1.5863e-04_r8/)
      kbo(:, 3,35, 7) = (/ &
     &3.9760e-02_r8,3.1675e-02_r8,2.2035e-02_r8,1.1812e-02_r8,1.9396e-04_r8/)
      kbo(:, 4,35, 7) = (/ &
     &5.2402e-02_r8,4.1735e-02_r8,2.9029e-02_r8,1.5538e-02_r8,2.3292e-04_r8/)
      kbo(:, 5,35, 7) = (/ &
     &6.8053e-02_r8,5.4173e-02_r8,3.7664e-02_r8,2.0141e-02_r8,2.7598e-04_r8/)
      kbo(:, 1,36, 7) = (/ &
     &1.8439e-02_r8,1.4736e-02_r8,1.0269e-02_r8,5.5181e-03_r8,1.0059e-04_r8/)
      kbo(:, 2,36, 7) = (/ &
     &2.5228e-02_r8,2.0135e-02_r8,1.4024e-02_r8,7.5257e-03_r8,1.2421e-04_r8/)
      kbo(:, 3,36, 7) = (/ &
     &3.3891e-02_r8,2.7058e-02_r8,1.8832e-02_r8,1.0097e-02_r8,1.5179e-04_r8/)
      kbo(:, 4,36, 7) = (/ &
     &4.4855e-02_r8,3.5783e-02_r8,2.4899e-02_r8,1.3331e-02_r8,1.8254e-04_r8/)
      kbo(:, 5,36, 7) = (/ &
     &5.8411e-02_r8,4.6611e-02_r8,3.2419e-02_r8,1.7335e-02_r8,2.1654e-04_r8/)
      kbo(:, 1,37, 7) = (/ &
     &1.5025e-02_r8,1.2025e-02_r8,8.3808e-03_r8,4.5043e-03_r8,7.8293e-05_r8/)
      kbo(:, 2,37, 7) = (/ &
     &2.0678e-02_r8,1.6540e-02_r8,1.1522e-02_r8,6.1849e-03_r8,9.7252e-05_r8/)
      kbo(:, 3,37, 7) = (/ &
     &2.7964e-02_r8,2.2364e-02_r8,1.5572e-02_r8,8.3486e-03_r8,1.1926e-04_r8/)
      kbo(:, 4,37, 7) = (/ &
     &3.7225e-02_r8,2.9764e-02_r8,2.0719e-02_r8,1.1092e-02_r8,1.4386e-04_r8/)
      kbo(:, 5,37, 7) = (/ &
     &4.8779e-02_r8,3.9013e-02_r8,2.7143e-02_r8,1.4513e-02_r8,1.7127e-04_r8/)
      kbo(:, 1,38, 7) = (/ &
     &1.2194e-02_r8,9.7772e-03_r8,6.8154e-03_r8,3.6630e-03_r8,6.0721e-05_r8/)
      kbo(:, 2,38, 7) = (/ &
     &1.6892e-02_r8,1.3540e-02_r8,9.4349e-03_r8,5.0655e-03_r8,7.5931e-05_r8/)
      kbo(:, 3,38, 7) = (/ &
     &2.2993e-02_r8,1.8427e-02_r8,1.2834e-02_r8,6.8825e-03_r8,9.3480e-05_r8/)
      kbo(:, 4,38, 7) = (/ &
     &3.0804e-02_r8,2.4686e-02_r8,1.7192e-02_r8,9.2065e-03_r8,1.1312e-04_r8/)
      kbo(:, 5,38, 7) = (/ &
     &4.0626e-02_r8,3.2569e-02_r8,2.2673e-02_r8,1.2127e-02_r8,1.3481e-04_r8/)
      kbo(:, 1,39, 7) = (/ &
     &9.8863e-03_r8,7.9385e-03_r8,5.5336e-03_r8,2.9753e-03_r8,4.6829e-05_r8/)
      kbo(:, 2,39, 7) = (/ &
     &1.3782e-02_r8,1.1068e-02_r8,7.7135e-03_r8,4.1426e-03_r8,5.8903e-05_r8/)
      kbo(:, 3,39, 7) = (/ &
     &1.8884e-02_r8,1.5163e-02_r8,1.0568e-02_r8,5.6692e-03_r8,7.2758e-05_r8/)
      kbo(:, 4,39, 7) = (/ &
     &2.5472e-02_r8,2.0459e-02_r8,1.4252e-02_r8,7.6329e-03_r8,8.8280e-05_r8/)
      kbo(:, 5,39, 7) = (/ &
     &3.3793e-02_r8,2.7159e-02_r8,1.8912e-02_r8,1.0123e-02_r8,1.0549e-04_r8/)
      kbo(:, 1,40, 7) = (/ &
     &7.8183e-03_r8,6.2872e-03_r8,4.3840e-03_r8,2.3583e-03_r8,3.5934e-05_r8/)
      kbo(:, 2,40, 7) = (/ &
     &1.1002e-02_r8,8.8456e-03_r8,6.1665e-03_r8,3.3129e-03_r8,4.5505e-05_r8/)
      kbo(:, 3,40, 7) = (/ &
     &1.5204e-02_r8,1.2224e-02_r8,8.5201e-03_r8,4.5727e-03_r8,5.6603e-05_r8/)
      kbo(:, 4,40, 7) = (/ &
     &2.0667e-02_r8,1.6639e-02_r8,1.1596e-02_r8,6.2148e-03_r8,6.8922e-05_r8/)
      kbo(:, 5,40, 7) = (/ &
     &2.7656e-02_r8,2.2280e-02_r8,1.5521e-02_r8,8.3102e-03_r8,8.2779e-05_r8/)
      kbo(:, 1,41, 7) = (/ &
     &6.1500e-03_r8,4.9524e-03_r8,3.4538e-03_r8,1.8579e-03_r8,2.7494e-05_r8/)
      kbo(:, 2,41, 7) = (/ &
     &8.7326e-03_r8,7.0361e-03_r8,4.9035e-03_r8,2.6349e-03_r8,3.5036e-05_r8/)
      kbo(:, 3,41, 7) = (/ &
     &1.2182e-02_r8,9.8121e-03_r8,6.8364e-03_r8,3.6704e-03_r8,4.3900e-05_r8/)
      kbo(:, 4,41, 7) = (/ &
     &1.6698e-02_r8,1.3470e-02_r8,9.3901e-03_r8,5.0360e-03_r8,5.3809e-05_r8/)
      kbo(:, 5,41, 7) = (/ &
     &2.2541e-02_r8,1.8202e-02_r8,1.2686e-02_r8,6.7978e-03_r8,6.4784e-05_r8/)
      kbo(:, 1,42, 7) = (/ &
     &4.8216e-03_r8,3.8878e-03_r8,2.7121e-03_r8,1.4585e-03_r8,2.0930e-05_r8/)
      kbo(:, 2,42, 7) = (/ &
     &6.9151e-03_r8,5.5793e-03_r8,3.8882e-03_r8,2.0902e-03_r8,2.6862e-05_r8/)
      kbo(:, 3,42, 7) = (/ &
     &9.7317e-03_r8,7.8533e-03_r8,5.4747e-03_r8,2.9388e-03_r8,3.3897e-05_r8/)
      kbo(:, 4,42, 7) = (/ &
     &1.3459e-02_r8,1.0876e-02_r8,7.5844e-03_r8,4.0697e-03_r8,4.1759e-05_r8/)
      kbo(:, 5,42, 7) = (/ &
     &1.8320e-02_r8,1.4838e-02_r8,1.0343e-02_r8,5.5456e-03_r8,5.0540e-05_r8/)
      kbo(:, 1,43, 7) = (/ &
     &3.7271e-03_r8,3.0076e-03_r8,2.0983e-03_r8,1.1283e-03_r8,1.5715e-05_r8/)
      kbo(:, 2,43, 7) = (/ &
     &5.4034e-03_r8,4.3650e-03_r8,3.0427e-03_r8,1.6347e-03_r8,2.0366e-05_r8/)
      kbo(:, 3,43, 7) = (/ &
     &7.6865e-03_r8,6.2120e-03_r8,4.3312e-03_r8,2.3251e-03_r8,2.5938e-05_r8/)
      kbo(:, 4,43, 7) = (/ &
     &1.0735e-02_r8,8.6871e-03_r8,6.0565e-03_r8,3.2504e-03_r8,3.2151e-05_r8/)
      kbo(:, 5,43, 7) = (/ &
     &1.4744e-02_r8,1.1965e-02_r8,8.3459e-03_r8,4.4756e-03_r8,3.9126e-05_r8/)
      kbo(:, 1,44, 7) = (/ &
     &2.8560e-03_r8,2.3067e-03_r8,1.6088e-03_r8,8.6423e-04_r8,1.1691e-05_r8/)
      kbo(:, 2,44, 7) = (/ &
     &4.1914e-03_r8,3.3878e-03_r8,2.3617e-03_r8,1.2680e-03_r8,1.5336e-05_r8/)
      kbo(:, 3,44, 7) = (/ &
     &6.0257e-03_r8,4.8753e-03_r8,3.3991e-03_r8,1.8248e-03_r8,1.9674e-05_r8/)
      kbo(:, 4,44, 7) = (/ &
     &8.5074e-03_r8,6.8953e-03_r8,4.8067e-03_r8,2.5783e-03_r8,2.4601e-05_r8/)
      kbo(:, 5,44, 7) = (/ &
     &1.1798e-02_r8,9.5893e-03_r8,6.6876e-03_r8,3.5866e-03_r8,3.0110e-05_r8/)
      kbo(:, 1,45, 7) = (/ &
     &2.1795e-03_r8,1.7620e-03_r8,1.2288e-03_r8,6.5976e-04_r8,8.6355e-06_r8/)
      kbo(:, 2,45, 7) = (/ &
     &3.2384e-03_r8,2.6190e-03_r8,1.8255e-03_r8,9.8000e-04_r8,1.1470e-05_r8/)
      kbo(:, 3,45, 7) = (/ &
     &4.7095e-03_r8,3.8135e-03_r8,2.6589e-03_r8,1.4269e-03_r8,1.4819e-05_r8/)
      kbo(:, 4,45, 7) = (/ &
     &6.7188e-03_r8,5.4533e-03_r8,3.8021e-03_r8,2.0391e-03_r8,1.8692e-05_r8/)
      kbo(:, 5,45, 7) = (/ &
     &9.4160e-03_r8,7.6627e-03_r8,5.3428e-03_r8,2.8648e-03_r8,2.3071e-05_r8/)
      kbo(:, 1,46, 7) = (/ &
     &1.6442e-03_r8,1.3301e-03_r8,9.2731e-04_r8,4.9724e-04_r8,6.3123e-06_r8/)
      kbo(:, 2,46, 7) = (/ &
     &2.4756e-03_r8,2.0038e-03_r8,1.3961e-03_r8,7.4858e-04_r8,8.4887e-06_r8/)
      kbo(:, 3,46, 7) = (/ &
     &3.6430e-03_r8,2.9527e-03_r8,2.0584e-03_r8,1.1034e-03_r8,1.1065e-05_r8/)
      kbo(:, 4,46, 7) = (/ &
     &5.2551e-03_r8,4.2702e-03_r8,2.9775e-03_r8,1.5960e-03_r8,1.4093e-05_r8/)
      kbo(:, 5,46, 7) = (/ &
     &7.4490e-03_r8,6.0700e-03_r8,4.2323e-03_r8,2.2675e-03_r8,1.7540e-05_r8/)
      kbo(:, 1,47, 7) = (/ &
     &1.2145e-03_r8,9.8337e-04_r8,6.8536e-04_r8,3.6730e-04_r8,4.5517e-06_r8/)
      kbo(:, 2,47, 7) = (/ &
     &1.8591e-03_r8,1.5045e-03_r8,1.0482e-03_r8,5.6130e-04_r8,6.1946e-06_r8/)
      kbo(:, 3,47, 7) = (/ &
     &2.7714e-03_r8,2.2470e-03_r8,1.5654e-03_r8,8.3875e-04_r8,8.1842e-06_r8/)
      kbo(:, 4,47, 7) = (/ &
     &4.0468e-03_r8,3.2903e-03_r8,2.2941e-03_r8,1.2283e-03_r8,1.0514e-05_r8/)
      kbo(:, 5,47, 7) = (/ &
     &5.8053e-03_r8,4.7349e-03_r8,3.3018e-03_r8,1.7685e-03_r8,1.3244e-05_r8/)
      kbo(:, 1,48, 7) = (/ &
     &8.9209e-04_r8,7.2273e-04_r8,5.0348e-04_r8,2.6958e-04_r8,3.2450e-06_r8/)
      kbo(:, 2,48, 7) = (/ &
     &1.3877e-03_r8,1.1243e-03_r8,7.8261e-04_r8,4.1863e-04_r8,4.4867e-06_r8/)
      kbo(:, 3,48, 7) = (/ &
     &2.0991e-03_r8,1.7020e-03_r8,1.1852e-03_r8,6.3416e-04_r8,6.0052e-06_r8/)
      kbo(:, 4,48, 7) = (/ &
     &3.1030e-03_r8,2.5246e-03_r8,1.7595e-03_r8,9.4166e-04_r8,7.8064e-06_r8/)
      kbo(:, 5,48, 7) = (/ &
     &4.5012e-03_r8,3.6752e-03_r8,2.5627e-03_r8,1.3716e-03_r8,9.9188e-06_r8/)
      kbo(:, 1,49, 7) = (/ &
     &6.5052e-04_r8,5.2741e-04_r8,3.6738e-04_r8,1.9665e-04_r8,2.2928e-06_r8/)
      kbo(:, 2,49, 7) = (/ &
     &1.0291e-03_r8,8.3378e-04_r8,5.8035e-04_r8,3.1024e-04_r8,3.2141e-06_r8/)
      kbo(:, 3,49, 7) = (/ &
     &1.5816e-03_r8,1.2832e-03_r8,8.9291e-04_r8,4.7687e-04_r8,4.3608e-06_r8/)
      kbo(:, 4,49, 7) = (/ &
     &2.3687e-03_r8,1.9273e-03_r8,1.3422e-03_r8,7.1737e-04_r8,5.7390e-06_r8/)
      kbo(:, 5,49, 7) = (/ &
     &3.4765e-03_r8,2.8403e-03_r8,1.9797e-03_r8,1.0580e-03_r8,7.3616e-06_r8/)
      kbo(:, 1,50, 7) = (/ &
     &4.7889e-04_r8,3.8798e-04_r8,2.7009e-04_r8,1.4448e-04_r8,1.6356e-06_r8/)
      kbo(:, 2,50, 7) = (/ &
     &7.6956e-04_r8,6.2385e-04_r8,4.3396e-04_r8,2.3170e-04_r8,2.3299e-06_r8/)
      kbo(:, 3,50, 7) = (/ &
     &1.1998e-03_r8,9.7385e-04_r8,6.7714e-04_r8,3.6138e-04_r8,3.2007e-06_r8/)
      kbo(:, 4,50, 7) = (/ &
     &1.8222e-03_r8,1.4833e-03_r8,1.0320e-03_r8,5.5070e-04_r8,4.2632e-06_r8/)
      kbo(:, 5,50, 7) = (/ &
     &2.7064e-03_r8,2.2113e-03_r8,1.5405e-03_r8,8.2234e-04_r8,5.5273e-06_r8/)
      kbo(:, 1,51, 7) = (/ &
     &3.5344e-04_r8,2.8635e-04_r8,1.9912e-04_r8,1.0636e-04_r8,1.1680e-06_r8/)
      kbo(:, 2,51, 7) = (/ &
     &5.7631e-04_r8,4.6738e-04_r8,3.2502e-04_r8,1.7332e-04_r8,1.6902e-06_r8/)
      kbo(:, 3,51, 7) = (/ &
     &9.1142e-04_r8,7.3982e-04_r8,5.1424e-04_r8,2.7410e-04_r8,2.3543e-06_r8/)
      kbo(:, 4,51, 7) = (/ &
     &1.4045e-03_r8,1.1437e-03_r8,7.9544e-04_r8,4.2395e-04_r8,3.1729e-06_r8/)
      kbo(:, 5,51, 7) = (/ &
     &2.1131e-03_r8,1.7268e-03_r8,1.2023e-03_r8,6.4090e-04_r8,4.1620e-06_r8/)
      kbo(:, 1,52, 7) = (/ &
     &2.5933e-04_r8,2.1020e-04_r8,1.4608e-04_r8,7.7951e-05_r8,8.2759e-07_r8/)
      kbo(:, 2,52, 7) = (/ &
     &4.3070e-04_r8,3.4917e-04_r8,2.4257e-04_r8,1.2919e-04_r8,1.2165e-06_r8/)
      kbo(:, 3,52, 7) = (/ &
     &6.9048e-04_r8,5.6079e-04_r8,3.8962e-04_r8,2.0733e-04_r8,1.7208e-06_r8/)
      kbo(:, 4,52, 7) = (/ &
     &1.0785e-03_r8,8.7815e-04_r8,6.1039e-04_r8,3.2491e-04_r8,2.3474e-06_r8/)
      kbo(:, 5,52, 7) = (/ &
     &1.6449e-03_r8,1.3448e-03_r8,9.3585e-04_r8,4.9830e-04_r8,3.1177e-06_r8/)
      kbo(:, 1,53, 7) = (/ &
     &1.8893e-04_r8,1.5324e-04_r8,1.0643e-04_r8,5.6765e-05_r8,5.8012e-07_r8/)
      kbo(:, 2,53, 7) = (/ &
     &3.2030e-04_r8,2.5977e-04_r8,1.8033e-04_r8,9.5988e-05_r8,8.6790e-07_r8/)
      kbo(:, 3,53, 7) = (/ &
     &5.2133e-04_r8,4.2303e-04_r8,2.9359e-04_r8,1.5604e-04_r8,1.2459e-06_r8/)
      kbo(:, 4,53, 7) = (/ &
     &8.2474e-04_r8,6.7149e-04_r8,4.6612e-04_r8,2.4781e-04_r8,1.7256e-06_r8/)
      kbo(:, 5,53, 7) = (/ &
     &1.2742e-03_r8,1.0424e-03_r8,7.2493e-04_r8,3.8558e-04_r8,2.3164e-06_r8/)
      kbo(:, 1,54, 7) = (/ &
     &1.3969e-04_r8,1.1317e-04_r8,7.8561e-05_r8,4.1870e-05_r8,4.1563e-07_r8/)
      kbo(:, 2,54, 7) = (/ &
     &2.4197e-04_r8,1.9607e-04_r8,1.3602e-04_r8,7.2325e-05_r8,6.3273e-07_r8/)
      kbo(:, 3,54, 7) = (/ &
     &4.0015e-04_r8,3.2487e-04_r8,2.2527e-04_r8,1.1951e-04_r8,9.2081e-07_r8/)
      kbo(:, 4,54, 7) = (/ &
     &6.4075e-04_r8,5.2162e-04_r8,3.6218e-04_r8,1.9219e-04_r8,1.2926e-06_r8/)
      kbo(:, 5,54, 7) = (/ &
     &1.0011e-03_r8,8.1978e-04_r8,5.6992e-04_r8,3.0275e-04_r8,1.7539e-06_r8/)
      kbo(:, 1,55, 7) = (/ &
     &1.0370e-04_r8,8.4064e-05_r8,5.8320e-05_r8,3.1035e-05_r8,3.0125e-07_r8/)
      kbo(:, 2,55, 7) = (/ &
     &1.8386e-04_r8,1.4899e-04_r8,1.0330e-04_r8,5.4881e-05_r8,4.6624e-07_r8/)
      kbo(:, 3,55, 7) = (/ &
     &3.0954e-04_r8,2.5123e-04_r8,1.7413e-04_r8,9.2312e-05_r8,6.8850e-07_r8/)
      kbo(:, 4,55, 7) = (/ &
     &5.0203e-04_r8,4.0855e-04_r8,2.8330e-04_r8,1.5019e-04_r8,9.7772e-07_r8/)
      kbo(:, 5,55, 7) = (/ &
     &7.9354e-04_r8,6.4976e-04_r8,4.5113e-04_r8,2.3954e-04_r8,1.3409e-06_r8/)
      kbo(:, 1,56, 7) = (/ &
     &7.6693e-05_r8,6.2162e-05_r8,4.3120e-05_r8,2.2933e-05_r8,2.1684e-07_r8/)
      kbo(:, 2,56, 7) = (/ &
     &1.3934e-04_r8,1.1294e-04_r8,7.8219e-05_r8,4.1520e-05_r8,3.4179e-07_r8/)
      kbo(:, 3,56, 7) = (/ &
     &2.3910e-04_r8,1.9403e-04_r8,1.3441e-04_r8,7.1189e-05_r8,5.1274e-07_r8/)
      kbo(:, 4,56, 7) = (/ &
     &3.9378e-04_r8,3.2054e-04_r8,2.2198e-04_r8,1.1748e-04_r8,7.3840e-07_r8/)
      kbo(:, 5,56, 7) = (/ &
     &6.2957e-04_r8,5.1531e-04_r8,3.5753e-04_r8,1.8952e-04_r8,1.0222e-06_r8/)
      kbo(:, 1,57, 7) = (/ &
     &5.6535e-05_r8,4.5829e-05_r8,3.1754e-05_r8,1.6880e-05_r8,1.5535e-07_r8/)
      kbo(:, 2,57, 7) = (/ &
     &1.0543e-04_r8,8.5393e-05_r8,5.9099e-05_r8,3.1336e-05_r8,2.4941e-07_r8/)
      kbo(:, 3,57, 7) = (/ &
     &1.8447e-04_r8,1.4976e-04_r8,1.0364e-04_r8,5.4850e-05_r8,3.7980e-07_r8/)
      kbo(:, 4,57, 7) = (/ &
     &3.0910e-04_r8,2.5132e-04_r8,1.7397e-04_r8,9.1976e-05_r8,5.5506e-07_r8/)
      kbo(:, 5,57, 7) = (/ &
     &4.9998e-04_r8,4.0888e-04_r8,2.8341e-04_r8,1.4999e-04_r8,7.7934e-07_r8/)
      kbo(:, 1,58, 7) = (/ &
     &2.0338e-05_r8,1.8913e-05_r8,1.5378e-05_r8,9.8853e-06_r8,1.1183e-07_r8/)
      kbo(:, 2,58, 7) = (/ &
     &3.8917e-05_r8,3.6144e-05_r8,2.9335e-05_r8,1.8800e-05_r8,1.8309e-07_r8/)
      kbo(:, 3,58, 7) = (/ &
     &6.9478e-05_r8,6.4684e-05_r8,5.2517e-05_r8,3.3620e-05_r8,2.8333e-07_r8/)
      kbo(:, 4,58, 7) = (/ &
     &1.1843e-04_r8,1.1052e-04_r8,8.9713e-05_r8,5.7328e-05_r8,4.1951e-07_r8/)
      kbo(:, 5,58, 7) = (/ &
     &1.9434e-04_r8,1.8218e-04_r8,1.4806e-04_r8,9.4685e-05_r8,5.9796e-07_r8/)
      kbo(:, 1,59, 7) = (/ &
     &1.6486e-05_r8,1.5394e-05_r8,1.2565e-05_r8,8.1204e-06_r8,9.1178e-08_r8/)
      kbo(:, 2,59, 7) = (/ &
     &3.1937e-05_r8,2.9800e-05_r8,2.4292e-05_r8,1.5665e-05_r8,1.5065e-07_r8/)
      kbo(:, 3,59, 7) = (/ &
     &5.7683e-05_r8,5.3905e-05_r8,4.3942e-05_r8,2.8299e-05_r8,2.3496e-07_r8/)
      kbo(:, 4,59, 7) = (/ &
     &9.9323e-05_r8,9.3088e-05_r8,7.5927e-05_r8,4.8813e-05_r8,3.4922e-07_r8/)
      kbo(:, 5,59, 7) = (/ &
     &1.6451e-04_r8,1.5507e-04_r8,1.2661e-04_r8,8.1439e-05_r8,5.0093e-07_r8/)
      kbo(:, 1,13, 8) = (/ &
     &1.2116e+00_r8,9.1758e-01_r8,6.2996e-01_r8,3.3536e-01_r8,1.5468e-02_r8/)
      kbo(:, 2,13, 8) = (/ &
     &1.6818e+00_r8,1.2746e+00_r8,8.7634e-01_r8,4.6518e-01_r8,1.8709e-02_r8/)
      kbo(:, 3,13, 8) = (/ &
     &2.2865e+00_r8,1.7360e+00_r8,1.1942e+00_r8,6.3525e-01_r8,2.2469e-02_r8/)
      kbo(:, 4,13, 8) = (/ &
     &3.0754e+00_r8,2.3371e+00_r8,1.6054e+00_r8,8.5102e-01_r8,2.6288e-02_r8/)
      kbo(:, 5,13, 8) = (/ &
     &4.0473e+00_r8,3.0761e+00_r8,2.1113e+00_r8,1.1162e+00_r8,3.0276e-02_r8/)
      kbo(:, 1,14, 8) = (/ &
     &1.1078e+00_r8,8.4059e-01_r8,5.7946e-01_r8,3.0612e-01_r8,1.2063e-02_r8/)
      kbo(:, 2,14, 8) = (/ &
     &1.5335e+00_r8,1.1661e+00_r8,8.0499e-01_r8,4.2627e-01_r8,1.4718e-02_r8/)
      kbo(:, 3,14, 8) = (/ &
     &2.0884e+00_r8,1.5886e+00_r8,1.0949e+00_r8,5.8050e-01_r8,1.7857e-02_r8/)
      kbo(:, 4,14, 8) = (/ &
     &2.8120e+00_r8,2.1413e+00_r8,1.4745e+00_r8,7.8098e-01_r8,2.1007e-02_r8/)
      kbo(:, 5,14, 8) = (/ &
     &3.6989e+00_r8,2.8189e+00_r8,1.9396e+00_r8,1.0257e+00_r8,2.4295e-02_r8/)
      kbo(:, 1,15, 8) = (/ &
     &9.7042e-01_r8,7.3947e-01_r8,5.1034e-01_r8,2.6949e-01_r8,9.7938e-03_r8/)
      kbo(:, 2,15, 8) = (/ &
     &1.3436e+00_r8,1.0262e+00_r8,7.0874e-01_r8,3.7517e-01_r8,1.2203e-02_r8/)
      kbo(:, 3,15, 8) = (/ &
     &1.8449e+00_r8,1.4109e+00_r8,9.7248e-01_r8,5.1316e-01_r8,1.4807e-02_r8/)
      kbo(:, 4,15, 8) = (/ &
     &2.4626e+00_r8,1.8840e+00_r8,1.3006e+00_r8,6.9030e-01_r8,1.7518e-02_r8/)
      kbo(:, 5,15, 8) = (/ &
     &3.2241e+00_r8,2.4640e+00_r8,1.6957e+00_r8,8.9766e-01_r8,2.0767e-02_r8/)
      kbo(:, 1,16, 8) = (/ &
     &8.2995e-01_r8,6.3671e-01_r8,4.3954e-01_r8,2.3206e-01_r8,8.0720e-03_r8/)
      kbo(:, 2,16, 8) = (/ &
     &1.1570e+00_r8,8.8835e-01_r8,6.1260e-01_r8,3.2369e-01_r8,1.0091e-02_r8/)
      kbo(:, 3,16, 8) = (/ &
     &1.5781e+00_r8,1.2128e+00_r8,8.3725e-01_r8,4.4354e-01_r8,1.2349e-02_r8/)
      kbo(:, 4,16, 8) = (/ &
     &2.1038e+00_r8,1.6176e+00_r8,1.1171e+00_r8,5.9216e-01_r8,1.4755e-02_r8/)
      kbo(:, 5,16, 8) = (/ &
     &2.7385e+00_r8,2.1023e+00_r8,1.4490e+00_r8,7.6892e-01_r8,1.7667e-02_r8/)
      kbo(:, 1,17, 8) = (/ &
     &7.0692e-01_r8,5.4586e-01_r8,3.7661e-01_r8,1.9889e-01_r8,6.7483e-03_r8/)
      kbo(:, 2,17, 8) = (/ &
     &9.8295e-01_r8,7.5893e-01_r8,5.2307e-01_r8,2.7659e-01_r8,8.4850e-03_r8/)
      kbo(:, 3,17, 8) = (/ &
     &1.3367e+00_r8,1.0327e+00_r8,7.1373e-01_r8,3.7884e-01_r8,1.0478e-02_r8/)
      kbo(:, 4,17, 8) = (/ &
     &1.7756e+00_r8,1.3697e+00_r8,9.4344e-01_r8,4.9980e-01_r8,1.2797e-02_r8/)
      kbo(:, 5,17, 8) = (/ &
     &2.3127e+00_r8,1.7838e+00_r8,1.2303e+00_r8,6.5347e-01_r8,1.5355e-02_r8/)
      kbo(:, 1,18, 8) = (/ &
     &5.9108e-01_r8,4.5836e-01_r8,3.1625e-01_r8,1.6744e-01_r8,5.7287e-03_r8/)
      kbo(:, 2,18, 8) = (/ &
     &8.2052e-01_r8,6.3681e-01_r8,4.3945e-01_r8,2.3289e-01_r8,7.3032e-03_r8/)
      kbo(:, 3,18, 8) = (/ &
     &1.1131e+00_r8,8.6338e-01_r8,5.9577e-01_r8,3.1578e-01_r8,9.0895e-03_r8/)
      kbo(:, 4,18, 8) = (/ &
     &1.4765e+00_r8,1.1444e+00_r8,7.8909e-01_r8,4.1827e-01_r8,1.1179e-02_r8/)
      kbo(:, 5,18, 8) = (/ &
     &1.9250e+00_r8,1.4898e+00_r8,1.0284e+00_r8,5.4576e-01_r8,1.3498e-02_r8/)
      kbo(:, 1,19, 8) = (/ &
     &5.0114e-01_r8,3.9028e-01_r8,2.6968e-01_r8,1.4303e-01_r8,5.0299e-03_r8/)
      kbo(:, 2,19, 8) = (/ &
     &6.9768e-01_r8,5.4308e-01_r8,3.7493e-01_r8,1.9896e-01_r8,6.4752e-03_r8/)
      kbo(:, 3,19, 8) = (/ &
     &9.4555e-01_r8,7.3537e-01_r8,5.0733e-01_r8,2.6864e-01_r8,8.1323e-03_r8/)
      kbo(:, 4,19, 8) = (/ &
     &1.2515e+00_r8,9.7204e-01_r8,6.7090e-01_r8,3.5577e-01_r8,1.0007e-02_r8/)
      kbo(:, 5,19, 8) = (/ &
     &1.6326e+00_r8,1.2674e+00_r8,8.7478e-01_r8,4.6363e-01_r8,1.2144e-02_r8/)
      kbo(:, 1,20, 8) = (/ &
     &4.3618e-01_r8,3.4070e-01_r8,2.3544e-01_r8,1.2514e-01_r8,4.4918e-03_r8/)
      kbo(:, 2,20, 8) = (/ &
     &6.0844e-01_r8,4.7506e-01_r8,3.2779e-01_r8,1.7405e-01_r8,5.8213e-03_r8/)
      kbo(:, 3,20, 8) = (/ &
     &8.2504e-01_r8,6.4315e-01_r8,4.4377e-01_r8,2.3521e-01_r8,7.3449e-03_r8/)
      kbo(:, 4,20, 8) = (/ &
     &1.0904e+00_r8,8.4892e-01_r8,5.8560e-01_r8,3.1033e-01_r8,9.1136e-03_r8/)
      kbo(:, 5,20, 8) = (/ &
     &1.4182e+00_r8,1.1040e+00_r8,7.6212e-01_r8,4.0404e-01_r8,1.1084e-02_r8/)
      kbo(:, 1,21, 8) = (/ &
     &3.8157e-01_r8,2.9889e-01_r8,2.0662e-01_r8,1.0989e-01_r8,4.0172e-03_r8/)
      kbo(:, 2,21, 8) = (/ &
     &5.3249e-01_r8,4.1652e-01_r8,2.8764e-01_r8,1.5288e-01_r8,5.2442e-03_r8/)
      kbo(:, 3,21, 8) = (/ &
     &7.2280e-01_r8,5.6456e-01_r8,3.8951e-01_r8,2.0661e-01_r8,6.6692e-03_r8/)
      kbo(:, 4,21, 8) = (/ &
     &9.5675e-01_r8,7.4634e-01_r8,5.1474e-01_r8,2.7285e-01_r8,8.2754e-03_r8/)
      kbo(:, 5,21, 8) = (/ &
     &1.2430e+00_r8,9.6862e-01_r8,6.6782e-01_r8,3.5364e-01_r8,1.0090e-02_r8/)
      kbo(:, 1,22, 8) = (/ &
     &3.4101e-01_r8,2.6749e-01_r8,1.8491e-01_r8,9.8339e-02_r8,3.6398e-03_r8/)
      kbo(:, 2,22, 8) = (/ &
     &4.7480e-01_r8,3.7184e-01_r8,2.5674e-01_r8,1.3643e-01_r8,4.7506e-03_r8/)
      kbo(:, 3,22, 8) = (/ &
     &6.4273e-01_r8,5.0295e-01_r8,3.4722e-01_r8,1.8435e-01_r8,6.0333e-03_r8/)
      kbo(:, 4,22, 8) = (/ &
     &8.5104e-01_r8,6.6530e-01_r8,4.5905e-01_r8,2.4340e-01_r8,7.4888e-03_r8/)
      kbo(:, 5,22, 8) = (/ &
     &1.1079e+00_r8,8.6526e-01_r8,5.9621e-01_r8,3.1544e-01_r8,9.1269e-03_r8/)
      kbo(:, 1,23, 8) = (/ &
     &3.0421e-01_r8,2.3897e-01_r8,1.6516e-01_r8,8.7923e-02_r8,3.2631e-03_r8/)
      kbo(:, 2,23, 8) = (/ &
     &4.2200e-01_r8,3.3116e-01_r8,2.2888e-01_r8,1.2169e-01_r8,4.2529e-03_r8/)
      kbo(:, 3,23, 8) = (/ &
     &5.7072e-01_r8,4.4747e-01_r8,3.0900e-01_r8,1.6407e-01_r8,5.3912e-03_r8/)
      kbo(:, 4,23, 8) = (/ &
     &7.5672e-01_r8,5.9253e-01_r8,4.0891e-01_r8,2.1688e-01_r8,6.6960e-03_r8/)
      kbo(:, 5,23, 8) = (/ &
     &9.8731e-01_r8,7.7239e-01_r8,5.3220e-01_r8,2.8204e-01_r8,8.2651e-03_r8/)
      kbo(:, 1,24, 8) = (/ &
     &2.7335e-01_r8,2.1493e-01_r8,1.4863e-01_r8,7.9120e-02_r8,2.9206e-03_r8/)
      kbo(:, 2,24, 8) = (/ &
     &3.7818e-01_r8,2.9704e-01_r8,2.0533e-01_r8,1.0922e-01_r8,3.7959e-03_r8/)
      kbo(:, 3,24, 8) = (/ &
     &5.1197e-01_r8,4.0167e-01_r8,2.7730e-01_r8,1.4723e-01_r8,4.8218e-03_r8/)
      kbo(:, 4,24, 8) = (/ &
     &6.8021e-01_r8,5.3323e-01_r8,3.6769e-01_r8,1.9508e-01_r8,6.0367e-03_r8/)
      kbo(:, 5,24, 8) = (/ &
     &8.8740e-01_r8,6.9520e-01_r8,4.7892e-01_r8,2.5373e-01_r8,7.4083e-03_r8/)
      kbo(:, 1,25, 8) = (/ &
     &2.4667e-01_r8,1.9408e-01_r8,1.3424e-01_r8,7.1436e-02_r8,2.6098e-03_r8/)
      kbo(:, 2,25, 8) = (/ &
     &3.4107e-01_r8,2.6809e-01_r8,1.8527e-01_r8,9.8480e-02_r8,3.3820e-03_r8/)
      kbo(:, 3,25, 8) = (/ &
     &4.6237e-01_r8,3.6308e-01_r8,2.5057e-01_r8,1.3298e-01_r8,4.3157e-03_r8/)
      kbo(:, 4,25, 8) = (/ &
     &6.1385e-01_r8,4.8168e-01_r8,3.3224e-01_r8,1.7632e-01_r8,5.3399e-03_r8/)
      kbo(:, 5,25, 8) = (/ &
     &7.9905e-01_r8,6.2682e-01_r8,4.3186e-01_r8,2.2913e-01_r8,6.4913e-03_r8/)
      kbo(:, 1,26, 8) = (/ &
     &2.2404e-01_r8,1.7649e-01_r8,1.2214e-01_r8,6.5022e-02_r8,2.3384e-03_r8/)
      kbo(:, 2,26, 8) = (/ &
     &3.1013e-01_r8,2.4403e-01_r8,1.6870e-01_r8,8.9741e-02_r8,3.0179e-03_r8/)
      kbo(:, 3,26, 8) = (/ &
     &4.2049e-01_r8,3.3066e-01_r8,2.2838e-01_r8,1.2138e-01_r8,3.8039e-03_r8/)
      kbo(:, 4,26, 8) = (/ &
     &5.5790e-01_r8,4.3821e-01_r8,3.0237e-01_r8,1.6056e-01_r8,4.6658e-03_r8/)
      kbo(:, 5,26, 8) = (/ &
     &7.2377e-01_r8,5.6837e-01_r8,3.9196e-01_r8,2.0795e-01_r8,5.6275e-03_r8/)
      kbo(:, 1,27, 8) = (/ &
     &2.0411e-01_r8,1.6088e-01_r8,1.1131e-01_r8,5.9303e-02_r8,2.0568e-03_r8/)
      kbo(:, 2,27, 8) = (/ &
     &2.8256e-01_r8,2.2260e-01_r8,1.5392e-01_r8,8.1961e-02_r8,2.6349e-03_r8/)
      kbo(:, 3,27, 8) = (/ &
     &3.8251e-01_r8,3.0112e-01_r8,2.0805e-01_r8,1.1068e-01_r8,3.2772e-03_r8/)
      kbo(:, 4,27, 8) = (/ &
     &5.0562e-01_r8,3.9785e-01_r8,2.7464e-01_r8,1.4598e-01_r8,4.0077e-03_r8/)
      kbo(:, 5,27, 8) = (/ &
     &6.5445e-01_r8,5.1441e-01_r8,3.5497e-01_r8,1.8851e-01_r8,4.8055e-03_r8/)
      kbo(:, 1,28, 8) = (/ &
     &1.8628e-01_r8,1.4699e-01_r8,1.0171e-01_r8,5.4235e-02_r8,1.7799e-03_r8/)
      kbo(:, 2,28, 8) = (/ &
     &2.5749e-01_r8,2.0322e-01_r8,1.4053e-01_r8,7.4881e-02_r8,2.2515e-03_r8/)
      kbo(:, 3,28, 8) = (/ &
     &3.4728e-01_r8,2.7380e-01_r8,1.8920e-01_r8,1.0075e-01_r8,2.7863e-03_r8/)
      kbo(:, 4,28, 8) = (/ &
     &4.5755e-01_r8,3.6044e-01_r8,2.4894e-01_r8,1.3243e-01_r8,3.3903e-03_r8/)
      kbo(:, 5,28, 8) = (/ &
     &5.9045e-01_r8,4.6494e-01_r8,3.2101e-01_r8,1.7052e-01_r8,4.0404e-03_r8/)
      kbo(:, 1,29, 8) = (/ &
     &1.6897e-01_r8,1.3358e-01_r8,9.2501e-02_r8,4.9422e-02_r8,1.5070e-03_r8/)
      kbo(:, 2,29, 8) = (/ &
     &2.3294e-01_r8,1.8406e-01_r8,1.2733e-01_r8,6.7942e-02_r8,1.8975e-03_r8/)
      kbo(:, 3,29, 8) = (/ &
     &3.1307e-01_r8,2.4704e-01_r8,1.7081e-01_r8,9.1043e-02_r8,2.3375e-03_r8/)
      kbo(:, 4,29, 8) = (/ &
     &4.1126e-01_r8,3.2432e-01_r8,2.2417e-01_r8,1.1931e-01_r8,2.8199e-03_r8/)
      kbo(:, 5,29, 8) = (/ &
     &5.2992e-01_r8,4.1770e-01_r8,2.8860e-01_r8,1.5337e-01_r8,3.3535e-03_r8/)
      kbo(:, 1,30, 8) = (/ &
     &1.5242e-01_r8,1.2071e-01_r8,8.3664e-02_r8,4.4778e-02_r8,1.2669e-03_r8/)
      kbo(:, 2,30, 8) = (/ &
     &2.0927e-01_r8,1.6559e-01_r8,1.1465e-01_r8,6.1290e-02_r8,1.5824e-03_r8/)
      kbo(:, 3,30, 8) = (/ &
     &2.8036e-01_r8,2.2167e-01_r8,1.5340e-01_r8,8.1865e-02_r8,1.9342e-03_r8/)
      kbo(:, 4,30, 8) = (/ &
     &3.6796e-01_r8,2.9065e-01_r8,2.0100e-01_r8,1.0707e-01_r8,2.3143e-03_r8/)
      kbo(:, 5,30, 8) = (/ &
     &4.7407e-01_r8,3.7431e-01_r8,2.5849e-01_r8,1.3745e-01_r8,2.7612e-03_r8/)
      kbo(:, 1,31, 8) = (/ &
     &1.3611e-01_r8,1.0796e-01_r8,7.4865e-02_r8,4.0122e-02_r8,1.0479e-03_r8/)
      kbo(:, 2,31, 8) = (/ &
     &1.8611e-01_r8,1.4751e-01_r8,1.0224e-01_r8,5.4734e-02_r8,1.2997e-03_r8/)
      kbo(:, 3,31, 8) = (/ &
     &2.4882e-01_r8,1.9706e-01_r8,1.3650e-01_r8,7.2954e-02_r8,1.5789e-03_r8/)
      kbo(:, 4,31, 8) = (/ &
     &3.2631e-01_r8,2.5819e-01_r8,1.7872e-01_r8,9.5286e-02_r8,1.8990e-03_r8/)
      kbo(:, 5,31, 8) = (/ &
     &4.2088e-01_r8,3.3264e-01_r8,2.2986e-01_r8,1.2231e-01_r8,2.2523e-03_r8/)
      kbo(:, 1,32, 8) = (/ &
     &1.2210e-01_r8,9.6994e-02_r8,6.7326e-02_r8,3.6123e-02_r8,8.5904e-04_r8/)
      kbo(:, 2,32, 8) = (/ &
     &1.6652e-01_r8,1.3210e-01_r8,9.1670e-02_r8,4.9107e-02_r8,1.0623e-03_r8/)
      kbo(:, 3,32, 8) = (/ &
     &2.2222e-01_r8,1.7626e-01_r8,1.2220e-01_r8,6.5357e-02_r8,1.2931e-03_r8/)
      kbo(:, 4,32, 8) = (/ &
     &2.9160e-01_r8,2.3096e-01_r8,1.5993e-01_r8,8.5342e-02_r8,1.5468e-03_r8/)
      kbo(:, 5,32, 8) = (/ &
     &3.7617e-01_r8,2.9768e-01_r8,2.0589e-01_r8,1.0971e-01_r8,1.8394e-03_r8/)
      kbo(:, 1,33, 8) = (/ &
     &1.0986e-01_r8,8.7382e-02_r8,6.0737e-02_r8,3.2609e-02_r8,7.0177e-04_r8/)
      kbo(:, 2,33, 8) = (/ &
     &1.4961e-01_r8,1.1887e-01_r8,8.2542e-02_r8,4.4260e-02_r8,8.6489e-04_r8/)
      kbo(:, 3,33, 8) = (/ &
     &1.9974e-01_r8,1.5861e-01_r8,1.0995e-01_r8,5.8836e-02_r8,1.0533e-03_r8/)
      kbo(:, 4,33, 8) = (/ &
     &2.6219e-01_r8,2.0793e-01_r8,1.4396e-01_r8,7.6884e-02_r8,1.2624e-03_r8/)
      kbo(:, 5,33, 8) = (/ &
     &3.3855e-01_r8,2.6852e-01_r8,1.8574e-01_r8,9.9060e-02_r8,1.4976e-03_r8/)
      kbo(:, 1,34, 8) = (/ &
     &9.9355e-02_r8,7.9091e-02_r8,5.5001e-02_r8,2.9534e-02_r8,5.8155e-04_r8/)
      kbo(:, 2,34, 8) = (/ &
     &1.3530e-01_r8,1.0764e-01_r8,7.4771e-02_r8,4.0076e-02_r8,7.1503e-04_r8/)
      kbo(:, 3,34, 8) = (/ &
     &1.8087e-01_r8,1.4373e-01_r8,9.9666e-02_r8,5.3339e-02_r8,8.6827e-04_r8/)
      kbo(:, 4,34, 8) = (/ &
     &2.3750e-01_r8,1.8867e-01_r8,1.3063e-01_r8,6.9822e-02_r8,1.0409e-03_r8/)
      kbo(:, 5,34, 8) = (/ &
     &3.0762e-01_r8,2.4432e-01_r8,1.6897e-01_r8,9.0140e-02_r8,1.2357e-03_r8/)
      kbo(:, 1,35, 8) = (/ &
     &8.7519e-02_r8,6.9769e-02_r8,4.8552e-02_r8,2.6085e-02_r8,4.6868e-04_r8/)
      kbo(:, 2,35, 8) = (/ &
     &1.1953e-01_r8,9.5204e-02_r8,6.6129e-02_r8,3.5470e-02_r8,5.7740e-04_r8/)
      kbo(:, 3,35, 8) = (/ &
     &1.6035e-01_r8,1.2756e-01_r8,8.8463e-02_r8,4.7361e-02_r8,7.0118e-04_r8/)
      kbo(:, 4,35, 8) = (/ &
     &2.1123e-01_r8,1.6801e-01_r8,1.1639e-01_r8,6.2235e-02_r8,8.4220e-04_r8/)
      kbo(:, 5,35, 8) = (/ &
     &2.7484e-01_r8,2.1861e-01_r8,1.5121e-01_r8,8.0717e-02_r8,1.0033e-03_r8/)
      kbo(:, 1,36, 8) = (/ &
     &7.4849e-02_r8,5.9737e-02_r8,4.1593e-02_r8,2.2353e-02_r8,3.6660e-04_r8/)
      kbo(:, 2,36, 8) = (/ &
     &1.0278e-01_r8,8.1972e-02_r8,5.6955e-02_r8,3.0544e-02_r8,4.5336e-04_r8/)
      kbo(:, 3,36, 8) = (/ &
     &1.3843e-01_r8,1.1029e-01_r8,7.6519e-02_r8,4.1000e-02_r8,5.5390e-04_r8/)
      kbo(:, 4,36, 8) = (/ &
     &1.8385e-01_r8,1.4649e-01_r8,1.0149e-01_r8,5.4257e-02_r8,6.6682e-04_r8/)
      kbo(:, 5,36, 8) = (/ &
     &2.4059e-01_r8,1.9160e-01_r8,1.3256e-01_r8,7.0808e-02_r8,7.9593e-04_r8/)
      kbo(:, 1,37, 8) = (/ &
     &6.1778e-02_r8,4.9350e-02_r8,3.4377e-02_r8,1.8481e-02_r8,2.8834e-04_r8/)
      kbo(:, 2,37, 8) = (/ &
     &8.5595e-02_r8,6.8343e-02_r8,4.7513e-02_r8,2.5474e-02_r8,3.5693e-04_r8/)
      kbo(:, 3,37, 8) = (/ &
     &1.1627e-01_r8,9.2744e-02_r8,6.4387e-02_r8,3.4481e-02_r8,4.3707e-04_r8/)
      kbo(:, 4,37, 8) = (/ &
     &1.5562e-01_r8,1.2411e-01_r8,8.6025e-02_r8,4.6007e-02_r8,5.2965e-04_r8/)
      kbo(:, 5,37, 8) = (/ &
     &2.0514e-01_r8,1.6357e-01_r8,1.1324e-01_r8,6.0461e-02_r8,6.3315e-04_r8/)
      kbo(:, 1,38, 8) = (/ &
     &5.0881e-02_r8,4.0678e-02_r8,2.8356e-02_r8,1.5247e-02_r8,2.2603e-04_r8/)
      kbo(:, 2,38, 8) = (/ &
     &7.1115e-02_r8,5.6873e-02_r8,3.9548e-02_r8,2.1211e-02_r8,2.8054e-04_r8/)
      kbo(:, 3,38, 8) = (/ &
     &9.7490e-02_r8,7.7896e-02_r8,5.4103e-02_r8,2.8959e-02_r8,3.4399e-04_r8/)
      kbo(:, 4,38, 8) = (/ &
     &1.3157e-01_r8,1.0506e-01_r8,7.2849e-02_r8,3.8945e-02_r8,4.1860e-04_r8/)
      kbo(:, 5,38, 8) = (/ &
     &1.7483e-01_r8,1.3966e-01_r8,9.6758e-02_r8,5.1645e-02_r8,5.0365e-04_r8/)
      kbo(:, 1,39, 8) = (/ &
     &4.1872e-02_r8,3.3548e-02_r8,2.3398e-02_r8,1.2576e-02_r8,1.7614e-04_r8/)
      kbo(:, 2,39, 8) = (/ &
     &5.9094e-02_r8,4.7316e-02_r8,3.2924e-02_r8,1.7662e-02_r8,2.1952e-04_r8/)
      kbo(:, 3,39, 8) = (/ &
     &8.1814e-02_r8,6.5458e-02_r8,4.5468e-02_r8,2.4343e-02_r8,2.7005e-04_r8/)
      kbo(:, 4,39, 8) = (/ &
     &1.1129e-01_r8,8.9026e-02_r8,6.1776e-02_r8,3.3031e-02_r8,3.3030e-04_r8/)
      kbo(:, 5,39, 8) = (/ &
     &1.4922e-01_r8,1.1944e-01_r8,8.2784e-02_r8,4.4132e-02_r8,4.0030e-04_r8/)
      kbo(:, 1,40, 8) = (/ &
     &3.3647e-02_r8,2.6996e-02_r8,1.8830e-02_r8,1.0123e-02_r8,1.3664e-04_r8/)
      kbo(:, 2,40, 8) = (/ &
     &4.8077e-02_r8,3.8535e-02_r8,2.6836e-02_r8,1.4394e-02_r8,1.7115e-04_r8/)
      kbo(:, 3,40, 8) = (/ &
     &6.7356e-02_r8,5.3948e-02_r8,3.7498e-02_r8,2.0063e-02_r8,2.1194e-04_r8/)
      kbo(:, 4,40, 8) = (/ &
     &9.2612e-02_r8,7.4161e-02_r8,5.1473e-02_r8,2.7514e-02_r8,2.6017e-04_r8/)
      kbo(:, 5,40, 8) = (/ &
     &1.2534e-01_r8,1.0040e-01_r8,6.9623e-02_r8,3.7148e-02_r8,3.1694e-04_r8/)
      kbo(:, 1,41, 8) = (/ &
     &2.6919e-02_r8,2.1625e-02_r8,1.5091e-02_r8,8.1073e-03_r8,1.0569e-04_r8/)
      kbo(:, 2,41, 8) = (/ &
     &3.8959e-02_r8,3.1258e-02_r8,2.1769e-02_r8,1.1674e-02_r8,1.3335e-04_r8/)
      kbo(:, 3,41, 8) = (/ &
     &5.5227e-02_r8,4.4304e-02_r8,3.0810e-02_r8,1.6485e-02_r8,1.6620e-04_r8/)
      kbo(:, 4,41, 8) = (/ &
     &7.6819e-02_r8,6.1609e-02_r8,4.2770e-02_r8,2.2843e-02_r8,2.0484e-04_r8/)
      kbo(:, 5,41, 8) = (/ &
     &1.0504e-01_r8,8.4290e-02_r8,5.8439e-02_r8,3.1171e-02_r8,2.5031e-04_r8/)
      kbo(:, 1,42, 8) = (/ &
     &2.1470e-02_r8,1.7281e-02_r8,1.2058e-02_r8,6.4788e-03_r8,8.1238e-05_r8/)
      kbo(:, 2,42, 8) = (/ &
     &3.1494e-02_r8,2.5316e-02_r8,1.7631e-02_r8,9.4523e-03_r8,1.0344e-04_r8/)
      kbo(:, 3,42, 8) = (/ &
     &4.5222e-02_r8,3.6333e-02_r8,2.5262e-02_r8,1.3522e-02_r8,1.2977e-04_r8/)
      kbo(:, 4,42, 8) = (/ &
     &6.3644e-02_r8,5.1128e-02_r8,3.5506e-02_r8,1.8951e-02_r8,1.6105e-04_r8/)
      kbo(:, 5,42, 8) = (/ &
     &8.7974e-02_r8,7.0671e-02_r8,4.9043e-02_r8,2.6143e-02_r8,1.9719e-04_r8/)
      kbo(:, 1,43, 8) = (/ &
     &1.6861e-02_r8,1.3590e-02_r8,9.4853e-03_r8,5.0945e-03_r8,6.1844e-05_r8/)
      kbo(:, 2,43, 8) = (/ &
     &2.5102e-02_r8,2.0210e-02_r8,1.4080e-02_r8,7.5450e-03_r8,7.9573e-05_r8/)
      kbo(:, 3,43, 8) = (/ &
     &3.6570e-02_r8,2.9430e-02_r8,2.0473e-02_r8,1.0954e-02_r8,1.0063e-04_r8/)
      kbo(:, 4,43, 8) = (/ &
     &5.2231e-02_r8,4.1980e-02_r8,2.9163e-02_r8,1.5562e-02_r8,1.2552e-04_r8/)
      kbo(:, 5,43, 8) = (/ &
     &7.3055e-02_r8,5.8741e-02_r8,4.0761e-02_r8,2.1719e-02_r8,1.5491e-04_r8/)
      kbo(:, 1,44, 8) = (/ &
     &1.3112e-02_r8,1.0583e-02_r8,7.3867e-03_r8,3.9656e-03_r8,4.6708e-05_r8/)
      kbo(:, 2,44, 8) = (/ &
     &1.9838e-02_r8,1.5995e-02_r8,1.1144e-02_r8,5.9703e-03_r8,6.0776e-05_r8/)
      kbo(:, 3,44, 8) = (/ &
     &2.9345e-02_r8,2.3649e-02_r8,1.6458e-02_r8,8.7984e-03_r8,7.7487e-05_r8/)
      kbo(:, 4,44, 8) = (/ &
     &4.2542e-02_r8,3.4237e-02_r8,2.3782e-02_r8,1.2696e-02_r8,9.7391e-05_r8/)
      kbo(:, 5,44, 8) = (/ &
     &6.0327e-02_r8,4.8544e-02_r8,3.3677e-02_r8,1.7934e-02_r8,1.2115e-04_r8/)
      kbo(:, 1,45, 8) = (/ &
     &1.0146e-02_r8,8.1985e-03_r8,5.7225e-03_r8,3.0712e-03_r8,3.5068e-05_r8/)
      kbo(:, 2,45, 8) = (/ &
     &1.5607e-02_r8,1.2601e-02_r8,8.7806e-03_r8,4.7019e-03_r8,4.6144e-05_r8/)
      kbo(:, 3,45, 8) = (/ &
     &2.3451e-02_r8,1.8930e-02_r8,1.3177e-02_r8,7.0434e-03_r8,5.9457e-05_r8/)
      kbo(:, 4,45, 8) = (/ &
     &3.4514e-02_r8,2.7825e-02_r8,1.9327e-02_r8,1.0311e-02_r8,7.5434e-05_r8/)
      kbo(:, 5,45, 8) = (/ &
     &4.9675e-02_r8,4.0043e-02_r8,2.7784e-02_r8,1.4786e-02_r8,9.4540e-05_r8/)
      kbo(:, 1,46, 8) = (/ &
     &7.7351e-03_r8,6.2590e-03_r8,4.3712e-03_r8,2.3470e-03_r8,2.6024e-05_r8/)
      kbo(:, 2,46, 8) = (/ &
     &1.2117e-02_r8,9.8019e-03_r8,6.8312e-03_r8,3.6581e-03_r8,3.4737e-05_r8/)
      kbo(:, 3,46, 8) = (/ &
     &1.8521e-02_r8,1.4972e-02_r8,1.0423e-02_r8,5.5707e-03_r8,4.5227e-05_r8/)
      kbo(:, 4,46, 8) = (/ &
     &2.7718e-02_r8,2.2376e-02_r8,1.5549e-02_r8,8.2942e-03_r8,5.8064e-05_r8/)
      kbo(:, 5,46, 8) = (/ &
     &4.0521e-02_r8,3.2720e-02_r8,2.2708e-02_r8,1.2084e-02_r8,7.3480e-05_r8/)
      kbo(:, 1,47, 8) = (/ &
     &5.7592e-03_r8,4.6672e-03_r8,3.2593e-03_r8,1.7501e-03_r8,1.9095e-05_r8/)
      kbo(:, 2,47, 8) = (/ &
     &9.2060e-03_r8,7.4576e-03_r8,5.1997e-03_r8,2.7848e-03_r8,2.5839e-05_r8/)
      kbo(:, 3,47, 8) = (/ &
     &1.4346e-02_r8,1.1614e-02_r8,8.0835e-03_r8,4.3208e-03_r8,3.4203e-05_r8/)
      kbo(:, 4,47, 8) = (/ &
     &2.1845e-02_r8,1.7678e-02_r8,1.2284e-02_r8,6.5493e-03_r8,4.4407e-05_r8/)
      kbo(:, 5,47, 8) = (/ &
     &3.2496e-02_r8,2.6280e-02_r8,1.8234e-02_r8,9.7018e-03_r8,5.6773e-05_r8/)
      kbo(:, 1,48, 8) = (/ &
     &4.2511e-03_r8,3.4498e-03_r8,2.4093e-03_r8,1.2936e-03_r8,1.3859e-05_r8/)
      kbo(:, 2,48, 8) = (/ &
     &6.9347e-03_r8,5.6254e-03_r8,3.9226e-03_r8,2.1019e-03_r8,1.9117e-05_r8/)
      kbo(:, 3,48, 8) = (/ &
     &1.1018e-02_r8,8.9390e-03_r8,6.2242e-03_r8,3.3284e-03_r8,2.5648e-05_r8/)
      kbo(:, 4,48, 8) = (/ &
     &1.7113e-02_r8,1.3870e-02_r8,9.6439e-03_r8,5.1401e-03_r8,3.3736e-05_r8/)
      kbo(:, 5,48, 8) = (/ &
     &2.5919e-02_r8,2.1005e-02_r8,1.4575e-02_r8,7.7539e-03_r8,4.3617e-05_r8/)
      kbo(:, 1,49, 8) = (/ &
     &3.1098e-03_r8,2.5273e-03_r8,1.7645e-03_r8,9.4708e-04_r8,9.9370e-06_r8/)
      kbo(:, 2,49, 8) = (/ &
     &5.1784e-03_r8,4.2068e-03_r8,2.9339e-03_r8,1.5725e-03_r8,1.3987e-05_r8/)
      kbo(:, 3,49, 8) = (/ &
     &8.3947e-03_r8,6.8228e-03_r8,4.7538e-03_r8,2.5418e-03_r8,1.9085e-05_r8/)
      kbo(:, 4,49, 8) = (/ &
     &1.3293e-02_r8,1.0799e-02_r8,7.5113e-03_r8,4.0058e-03_r8,2.5451e-05_r8/)
      kbo(:, 5,49, 8) = (/ &
     &2.0521e-02_r8,1.6668e-02_r8,1.1574e-02_r8,6.1522e-03_r8,3.3363e-05_r8/)
      kbo(:, 1,50, 8) = (/ &
     &2.2918e-03_r8,1.8636e-03_r8,1.3008e-03_r8,6.9789e-04_r8,7.1979e-06_r8/)
      kbo(:, 2,50, 8) = (/ &
     &3.8913e-03_r8,3.1670e-03_r8,2.2089e-03_r8,1.1842e-03_r8,1.0331e-05_r8/)
      kbo(:, 3,50, 8) = (/ &
     &6.4390e-03_r8,5.2441e-03_r8,3.6531e-03_r8,1.9538e-03_r8,1.4344e-05_r8/)
      kbo(:, 4,50, 8) = (/ &
     &1.0397e-02_r8,8.4649e-03_r8,5.8892e-03_r8,3.1423e-03_r8,1.9397e-05_r8/)
      kbo(:, 5,50, 8) = (/ &
     &1.6371e-02_r8,1.3317e-02_r8,9.2504e-03_r8,4.9185e-03_r8,2.5741e-05_r8/)
      kbo(:, 1,51, 8) = (/ &
     &1.6928e-03_r8,1.3767e-03_r8,9.6023e-04_r8,5.1382e-04_r8,5.2246e-06_r8/)
      kbo(:, 2,51, 8) = (/ &
     &2.9272e-03_r8,2.3839e-03_r8,1.6628e-03_r8,8.9103e-04_r8,7.6388e-06_r8/)
      kbo(:, 3,51, 8) = (/ &
     &4.9429e-03_r8,4.0319e-03_r8,2.8087e-03_r8,1.5020e-03_r8,1.0781e-05_r8/)
      kbo(:, 4,51, 8) = (/ &
     &8.1364e-03_r8,6.6389e-03_r8,4.6188e-03_r8,2.4654e-03_r8,1.4827e-05_r8/)
      kbo(:, 5,51, 8) = (/ &
     &1.3068e-02_r8,1.0656e-02_r8,7.4020e-03_r8,3.9372e-03_r8,1.9921e-05_r8/)
      kbo(:, 1,52, 8) = (/ &
     &1.2399e-03_r8,1.0091e-03_r8,7.0357e-04_r8,3.7650e-04_r8,3.7522e-06_r8/)
      kbo(:, 2,52, 8) = (/ &
     &2.1899e-03_r8,1.7829e-03_r8,1.2430e-03_r8,6.6579e-04_r8,5.6100e-06_r8/)
      kbo(:, 3,52, 8) = (/ &
     &3.7665e-03_r8,3.0795e-03_r8,2.1447e-03_r8,1.1464e-03_r8,8.0632e-06_r8/)
      kbo(:, 4,52, 8) = (/ &
     &6.3261e-03_r8,5.1729e-03_r8,3.5994e-03_r8,1.9224e-03_r8,1.1265e-05_r8/)
      kbo(:, 5,52, 8) = (/ &
     &1.0363e-02_r8,8.4710e-03_r8,5.8842e-03_r8,3.1302e-03_r8,1.5370e-05_r8/)
      kbo(:, 1,53, 8) = (/ &
     &9.0216e-04_r8,7.3408e-04_r8,5.1164e-04_r8,2.7340e-04_r8,2.6590e-06_r8/)
      kbo(:, 2,53, 8) = (/ &
     &1.6262e-03_r8,1.3270e-03_r8,9.2425e-04_r8,4.9425e-04_r8,4.0810e-06_r8/)
      kbo(:, 3,53, 8) = (/ &
     &2.8513e-03_r8,2.3327e-03_r8,1.6237e-03_r8,8.6789e-04_r8,5.9668e-06_r8/)
      kbo(:, 4,53, 8) = (/ &
     &4.8843e-03_r8,4.0007e-03_r8,2.7846e-03_r8,1.4866e-03_r8,8.4879e-06_r8/)
      kbo(:, 5,53, 8) = (/ &
     &8.1619e-03_r8,6.6885e-03_r8,4.6478e-03_r8,2.4735e-03_r8,1.1744e-05_r8/)
      kbo(:, 1,54, 8) = (/ &
     &6.6939e-04_r8,5.4497e-04_r8,3.7910e-04_r8,2.0225e-04_r8,1.9239e-06_r8/)
      kbo(:, 2,54, 8) = (/ &
     &1.2278e-03_r8,1.0030e-03_r8,6.9836e-04_r8,3.7314e-04_r8,3.0194e-06_r8/)
      kbo(:, 3,54, 8) = (/ &
     &2.1984e-03_r8,1.7996e-03_r8,1.2511e-03_r8,6.6777e-04_r8,4.5056e-06_r8/)
      kbo(:, 4,54, 8) = (/ &
     &3.8331e-03_r8,3.1457e-03_r8,2.1886e-03_r8,1.1687e-03_r8,6.4964e-06_r8/)
      kbo(:, 5,54, 8) = (/ &
     &6.5432e-03_r8,5.3709e-03_r8,3.7307e-03_r8,1.9859e-03_r8,9.1107e-06_r8/)
      kbo(:, 1,55, 8) = (/ &
     &5.0111e-04_r8,4.0755e-04_r8,2.8321e-04_r8,1.5081e-04_r8,1.4025e-06_r8/)
      kbo(:, 2,55, 8) = (/ &
     &9.3502e-04_r8,7.6365e-04_r8,5.3113e-04_r8,2.8338e-04_r8,2.2498e-06_r8/)
      kbo(:, 3,55, 8) = (/ &
     &1.7077e-03_r8,1.3993e-03_r8,9.7261e-04_r8,5.1891e-04_r8,3.4289e-06_r8/)
      kbo(:, 4,55, 8) = (/ &
     &3.0342e-03_r8,2.4941e-03_r8,1.7338e-03_r8,9.2454e-04_r8,5.0131e-06_r8/)
      kbo(:, 5,55, 8) = (/ &
     &5.2834e-03_r8,4.3447e-03_r8,3.0182e-03_r8,1.6053e-03_r8,7.1210e-06_r8/)
      kbo(:, 1,56, 8) = (/ &
     &3.7616e-04_r8,3.0519e-04_r8,2.1170e-04_r8,1.1247e-04_r8,1.0140e-06_r8/)
      kbo(:, 2,56, 8) = (/ &
     &7.1281e-04_r8,5.8173e-04_r8,4.0420e-04_r8,2.1505e-04_r8,1.6673e-06_r8/)
      kbo(:, 3,56, 8) = (/ &
     &1.3229e-03_r8,1.0846e-03_r8,7.5367e-04_r8,4.0126e-04_r8,2.5921e-06_r8/)
      kbo(:, 4,56, 8) = (/ &
     &2.4034e-03_r8,1.9754e-03_r8,1.3714e-03_r8,7.3027e-04_r8,3.8577e-06_r8/)
      kbo(:, 5,56, 8) = (/ &
     &4.2589e-03_r8,3.5089e-03_r8,2.4364e-03_r8,1.2956e-03_r8,5.5656e-06_r8/)
      kbo(:, 1,57, 8) = (/ &
     &2.8163e-04_r8,2.2851e-04_r8,1.5825e-04_r8,8.3801e-05_r8,7.2920e-07_r8/)
      kbo(:, 2,57, 8) = (/ &
     &5.4316e-04_r8,4.4288e-04_r8,3.0736e-04_r8,1.6324e-04_r8,1.2275e-06_r8/)
      kbo(:, 3,57, 8) = (/ &
     &1.0242e-03_r8,8.3907e-04_r8,5.8250e-04_r8,3.0984e-04_r8,1.9504e-06_r8/)
      kbo(:, 4,57, 8) = (/ &
     &1.8977e-03_r8,1.5630e-03_r8,1.0848e-03_r8,5.7691e-04_r8,2.9526e-06_r8/)
      kbo(:, 5,57, 8) = (/ &
     &3.4290e-03_r8,2.8298e-03_r8,1.9639e-03_r8,1.0437e-03_r8,4.3203e-06_r8/)
      kbo(:, 1,58, 8) = (/ &
     &1.0299e-04_r8,9.5896e-05_r8,7.7844e-05_r8,4.9788e-05_r8,5.2623e-07_r8/)
      kbo(:, 2,58, 8) = (/ &
     &2.0307e-04_r8,1.9013e-04_r8,1.5450e-04_r8,9.9035e-05_r8,9.0616e-07_r8/)
      kbo(:, 3,58, 8) = (/ &
     &3.8839e-04_r8,3.6515e-04_r8,2.9695e-04_r8,1.9078e-04_r8,1.4737e-06_r8/)
      kbo(:, 4,58, 8) = (/ &
     &7.3294e-04_r8,6.9303e-04_r8,5.6426e-04_r8,3.6255e-04_r8,2.2710e-06_r8/)
      kbo(:, 5,58, 8) = (/ &
     &1.3532e-03_r8,1.2806e-03_r8,1.0426e-03_r8,6.7017e-04_r8,3.3698e-06_r8/)
      kbo(:, 1,59, 8) = (/ &
     &8.5450e-05_r8,7.9848e-05_r8,6.5073e-05_r8,4.1875e-05_r8,4.3253e-07_r8/)
      kbo(:, 2,59, 8) = (/ &
     &1.7170e-04_r8,1.6133e-04_r8,1.3170e-04_r8,8.4866e-05_r8,7.5223e-07_r8/)
      kbo(:, 3,59, 8) = (/ &
     &3.3324e-04_r8,3.1480e-04_r8,2.5716e-04_r8,1.6610e-04_r8,1.2329e-06_r8/)
      kbo(:, 4,59, 8) = (/ &
     &6.4000e-04_r8,6.0786e-04_r8,4.9691e-04_r8,3.2112e-04_r8,1.9165e-06_r8/)
      kbo(:, 5,59, 8) = (/ &
     &1.2020e-03_r8,1.1456e-03_r8,9.3584e-04_r8,6.0398e-04_r8,2.8638e-06_r8/)
      kbo(:, 1,13, 9) = (/ &
     &7.4699e+00_r8,5.6062e+00_r8,3.7650e+00_r8,1.9560e+00_r8,8.5273e-02_r8/)
      kbo(:, 2,13, 9) = (/ &
     &1.0680e+01_r8,8.0165e+00_r8,5.3854e+00_r8,2.8036e+00_r8,1.0411e-01_r8/)
      kbo(:, 3,13, 9) = (/ &
     &1.4623e+01_r8,1.0976e+01_r8,7.3752e+00_r8,3.8391e+00_r8,1.2390e-01_r8/)
      kbo(:, 4,13, 9) = (/ &
     &1.9264e+01_r8,1.4459e+01_r8,9.7226e+00_r8,5.0654e+00_r8,1.4616e-01_r8/)
      kbo(:, 5,13, 9) = (/ &
     &2.4629e+01_r8,1.8491e+01_r8,1.2437e+01_r8,6.4792e+00_r8,1.7014e-01_r8/)
      kbo(:, 1,14, 9) = (/ &
     &6.8938e+00_r8,5.1783e+00_r8,3.4875e+00_r8,1.8264e+00_r8,7.6714e-02_r8/)
      kbo(:, 2,14, 9) = (/ &
     &9.8527e+00_r8,7.4006e+00_r8,4.9851e+00_r8,2.6106e+00_r8,9.2077e-02_r8/)
      kbo(:, 3,14, 9) = (/ &
     &1.3464e+01_r8,1.0115e+01_r8,6.8188e+00_r8,3.5707e+00_r8,1.0926e-01_r8/)
      kbo(:, 4,14, 9) = (/ &
     &1.7717e+01_r8,1.3311e+01_r8,8.9749e+00_r8,4.7000e+00_r8,1.2815e-01_r8/)
      kbo(:, 5,14, 9) = (/ &
     &2.2681e+01_r8,1.7041e+01_r8,1.1492e+01_r8,6.0178e+00_r8,1.4885e-01_r8/)
      kbo(:, 1,15, 9) = (/ &
     &6.1047e+00_r8,4.5908e+00_r8,3.1074e+00_r8,1.6392e+00_r8,6.2768e-02_r8/)
      kbo(:, 2,15, 9) = (/ &
     &8.7019e+00_r8,6.5442e+00_r8,4.4301e+00_r8,2.3356e+00_r8,7.5768e-02_r8/)
      kbo(:, 3,15, 9) = (/ &
     &1.1847e+01_r8,8.9091e+00_r8,6.0354e+00_r8,3.1840e+00_r8,9.0152e-02_r8/)
      kbo(:, 4,15, 9) = (/ &
     &1.5627e+01_r8,1.1753e+01_r8,7.9592e+00_r8,4.1918e+00_r8,1.0596e-01_r8/)
      kbo(:, 5,15, 9) = (/ &
     &2.0065e+01_r8,1.5096e+01_r8,1.0229e+01_r8,5.3867e+00_r8,1.2348e-01_r8/)
      kbo(:, 1,16, 9) = (/ &
     &5.2710e+00_r8,3.9706e+00_r8,2.7052e+00_r8,1.4383e+00_r8,5.0640e-02_r8/)
      kbo(:, 2,16, 9) = (/ &
     &7.4843e+00_r8,5.6386e+00_r8,3.8435e+00_r8,2.0428e+00_r8,6.0690e-02_r8/)
      kbo(:, 3,16, 9) = (/ &
     &1.0203e+01_r8,7.6869e+00_r8,5.2380e+00_r8,2.7809e+00_r8,7.2017e-02_r8/)
      kbo(:, 4,16, 9) = (/ &
     &1.3478e+01_r8,1.0155e+01_r8,6.9170e+00_r8,3.6687e+00_r8,8.5243e-02_r8/)
      kbo(:, 5,16, 9) = (/ &
     &1.7365e+01_r8,1.3088e+01_r8,8.9123e+00_r8,4.7182e+00_r8,9.9040e-02_r8/)
      kbo(:, 1,17, 9) = (/ &
     &4.4902e+00_r8,3.3911e+00_r8,2.3244e+00_r8,1.2481e+00_r8,4.0283e-02_r8/)
      kbo(:, 2,17, 9) = (/ &
     &6.3739e+00_r8,4.8152e+00_r8,3.3005e+00_r8,1.7693e+00_r8,4.9025e-02_r8/)
      kbo(:, 3,17, 9) = (/ &
     &8.7028e+00_r8,6.5740e+00_r8,4.5022e+00_r8,2.4070e+00_r8,5.9283e-02_r8/)
      kbo(:, 4,17, 9) = (/ &
     &1.1530e+01_r8,8.7139e+00_r8,5.9683e+00_r8,3.1839e+00_r8,7.0217e-02_r8/)
      kbo(:, 5,17, 9) = (/ &
     &1.4910e+01_r8,1.1266e+01_r8,7.7058e+00_r8,4.0973e+00_r8,8.1092e-02_r8/)
      kbo(:, 1,18, 9) = (/ &
     &3.7512e+00_r8,2.8459e+00_r8,1.9612e+00_r8,1.0622e+00_r8,3.4382e-02_r8/)
      kbo(:, 2,18, 9) = (/ &
     &5.3265e+00_r8,4.0412e+00_r8,2.7835e+00_r8,1.5026e+00_r8,4.2209e-02_r8/)
      kbo(:, 3,18, 9) = (/ &
     &7.2937e+00_r8,5.5341e+00_r8,3.8093e+00_r8,2.0485e+00_r8,5.1165e-02_r8/)
      kbo(:, 4,18, 9) = (/ &
     &9.7044e+00_r8,7.3625e+00_r8,5.0637e+00_r8,2.7136e+00_r8,6.0247e-02_r8/)
      kbo(:, 5,18, 9) = (/ &
     &1.2597e+01_r8,9.5561e+00_r8,6.5653e+00_r8,3.5052e+00_r8,7.0721e-02_r8/)
      kbo(:, 1,19, 9) = (/ &
     &3.1949e+00_r8,2.4358e+00_r8,1.6862e+00_r8,9.1523e-01_r8,2.9755e-02_r8/)
      kbo(:, 2,19, 9) = (/ &
     &4.5382e+00_r8,3.4601e+00_r8,2.3940e+00_r8,1.2945e+00_r8,3.7026e-02_r8/)
      kbo(:, 3,19, 9) = (/ &
     &6.2344e+00_r8,4.7532e+00_r8,3.2851e+00_r8,1.7697e+00_r8,4.5045e-02_r8/)
      kbo(:, 4,19, 9) = (/ &
     &8.3349e+00_r8,6.3521e+00_r8,4.3827e+00_r8,2.3518e+00_r8,5.3532e-02_r8/)
      kbo(:, 5,19, 9) = (/ &
     &1.0858e+01_r8,8.2689e+00_r8,5.6978e+00_r8,3.0490e+00_r8,6.2338e-02_r8/)
      kbo(:, 1,20, 9) = (/ &
     &2.7983e+00_r8,2.1430e+00_r8,1.4907e+00_r8,8.0787e-01_r8,2.6638e-02_r8/)
      kbo(:, 2,20, 9) = (/ &
     &3.9801e+00_r8,3.0473e+00_r8,2.1167e+00_r8,1.1423e+00_r8,3.3344e-02_r8/)
      kbo(:, 3,20, 9) = (/ &
     &5.4854e+00_r8,4.1978e+00_r8,2.9095e+00_r8,1.5650e+00_r8,4.0067e-02_r8/)
      kbo(:, 4,20, 9) = (/ &
     &7.3522e+00_r8,5.6240e+00_r8,3.8910e+00_r8,2.0868e+00_r8,4.7603e-02_r8/)
      kbo(:, 5,20, 9) = (/ &
     &9.6006e+00_r8,7.3375e+00_r8,5.0662e+00_r8,2.7087e+00_r8,5.5504e-02_r8/)
      kbo(:, 1,21, 9) = (/ &
     &2.4723e+00_r8,1.9017e+00_r8,1.3269e+00_r8,7.1717e-01_r8,2.3842e-02_r8/)
      kbo(:, 2,21, 9) = (/ &
     &3.5234e+00_r8,2.7089e+00_r8,1.8854e+00_r8,1.0156e+00_r8,2.9423e-02_r8/)
      kbo(:, 3,21, 9) = (/ &
     &4.8624e+00_r8,3.7359e+00_r8,2.5948e+00_r8,1.3934e+00_r8,3.5538e-02_r8/)
      kbo(:, 4,21, 9) = (/ &
     &6.5245e+00_r8,5.0095e+00_r8,3.4715e+00_r8,1.8586e+00_r8,4.1992e-02_r8/)
      kbo(:, 5,21, 9) = (/ &
     &8.5269e+00_r8,6.5419e+00_r8,4.5264e+00_r8,2.4180e+00_r8,4.9380e-02_r8/)
      kbo(:, 1,22, 9) = (/ &
     &2.2453e+00_r8,1.7353e+00_r8,1.2110e+00_r8,6.5234e-01_r8,2.1295e-02_r8/)
      kbo(:, 2,22, 9) = (/ &
     &3.1933e+00_r8,2.4664e+00_r8,1.7176e+00_r8,9.2252e-01_r8,2.6174e-02_r8/)
      kbo(:, 3,22, 9) = (/ &
     &4.4012e+00_r8,3.3958e+00_r8,2.3595e+00_r8,1.2638e+00_r8,3.1657e-02_r8/)
      kbo(:, 4,22, 9) = (/ &
     &5.8834e+00_r8,4.5350e+00_r8,3.1467e+00_r8,1.6824e+00_r8,3.7644e-02_r8/)
      kbo(:, 5,22, 9) = (/ &
     &7.6501e+00_r8,5.8912e+00_r8,4.0828e+00_r8,2.1806e+00_r8,4.4263e-02_r8/)
      kbo(:, 1,23, 9) = (/ &
     &2.0571e+00_r8,1.5967e+00_r8,1.1115e+00_r8,5.9605e-01_r8,1.8827e-02_r8/)
      kbo(:, 2,23, 9) = (/ &
     &2.9057e+00_r8,2.2535e+00_r8,1.5681e+00_r8,8.3999e-01_r8,2.3337e-02_r8/)
      kbo(:, 3,23, 9) = (/ &
     &3.9800e+00_r8,3.0833e+00_r8,2.1434e+00_r8,1.1464e+00_r8,2.8190e-02_r8/)
      kbo(:, 4,23, 9) = (/ &
     &5.2885e+00_r8,4.0922e+00_r8,2.8421e+00_r8,1.5182e+00_r8,3.3828e-02_r8/)
      kbo(:, 5,23, 9) = (/ &
     &6.8471e+00_r8,5.2918e+00_r8,3.6724e+00_r8,1.9594e+00_r8,3.9956e-02_r8/)
      kbo(:, 1,24, 9) = (/ &
     &1.9070e+00_r8,1.4857e+00_r8,1.0329e+00_r8,5.5181e-01_r8,1.6663e-02_r8/)
      kbo(:, 2,24, 9) = (/ &
     &2.6677e+00_r8,2.0773e+00_r8,1.4448e+00_r8,7.7214e-01_r8,2.0662e-02_r8/)
      kbo(:, 3,24, 9) = (/ &
     &3.6252e+00_r8,2.8187e+00_r8,1.9595e+00_r8,1.0463e+00_r8,2.5179e-02_r8/)
      kbo(:, 4,24, 9) = (/ &
     &4.7921e+00_r8,3.7213e+00_r8,2.5847e+00_r8,1.3784e+00_r8,3.0300e-02_r8/)
      kbo(:, 5,24, 9) = (/ &
     &6.1875e+00_r8,4.7981e+00_r8,3.3299e+00_r8,1.7738e+00_r8,3.5858e-02_r8/)
      kbo(:, 1,25, 9) = (/ &
     &1.7679e+00_r8,1.3823e+00_r8,9.6005e-01_r8,5.1215e-01_r8,1.4756e-02_r8/)
      kbo(:, 2,25, 9) = (/ &
     &2.4506e+00_r8,1.9149e+00_r8,1.3310e+00_r8,7.1009e-01_r8,1.8413e-02_r8/)
      kbo(:, 3,25, 9) = (/ &
     &3.3092e+00_r8,2.5821e+00_r8,1.7930e+00_r8,9.5566e-01_r8,2.2613e-02_r8/)
      kbo(:, 4,25, 9) = (/ &
     &4.3581e+00_r8,3.3956e+00_r8,2.3561e+00_r8,1.2539e+00_r8,2.7407e-02_r8/)
      kbo(:, 5,25, 9) = (/ &
     &5.6148e+00_r8,4.3684e+00_r8,3.0296e+00_r8,1.6108e+00_r8,3.2730e-02_r8/)
      kbo(:, 1,26, 9) = (/ &
     &1.6550e+00_r8,1.2970e+00_r8,8.9910e-01_r8,4.7856e-01_r8,1.3235e-02_r8/)
      kbo(:, 2,26, 9) = (/ &
     &2.2724e+00_r8,1.7804e+00_r8,1.2348e+00_r8,6.5702e-01_r8,1.6632e-02_r8/)
      kbo(:, 3,26, 9) = (/ &
     &3.0501e+00_r8,2.3862e+00_r8,1.6545e+00_r8,8.7945e-01_r8,2.0602e-02_r8/)
      kbo(:, 4,26, 9) = (/ &
     &3.9998e+00_r8,3.1253e+00_r8,2.1658e+00_r8,1.1505e+00_r8,2.5120e-02_r8/)
      kbo(:, 5,26, 9) = (/ &
     &5.1417e+00_r8,4.0125e+00_r8,2.7805e+00_r8,1.4756e+00_r8,3.0188e-02_r8/)
      kbo(:, 1,27, 9) = (/ &
     &1.5517e+00_r8,1.2181e+00_r8,8.4303e-01_r8,4.4762e-01_r8,1.1922e-02_r8/)
      kbo(:, 2,27, 9) = (/ &
     &2.1187e+00_r8,1.6625e+00_r8,1.1508e+00_r8,6.1078e-01_r8,1.5090e-02_r8/)
      kbo(:, 3,27, 9) = (/ &
     &2.8285e+00_r8,2.2174e+00_r8,1.5344e+00_r8,8.1390e-01_r8,1.8733e-02_r8/)
      kbo(:, 4,27, 9) = (/ &
     &3.6946e+00_r8,2.8938e+00_r8,2.0026e+00_r8,1.0611e+00_r8,2.2964e-02_r8/)
      kbo(:, 5,27, 9) = (/ &
     &4.7297e+00_r8,3.7026e+00_r8,2.5639e+00_r8,1.3585e+00_r8,2.7799e-02_r8/)
      kbo(:, 1,28, 9) = (/ &
     &1.4557e+00_r8,1.1450e+00_r8,7.9124e-01_r8,4.1922e-01_r8,1.0671e-02_r8/)
      kbo(:, 2,28, 9) = (/ &
     &1.9807e+00_r8,1.5572e+00_r8,1.0762e+00_r8,5.7024e-01_r8,1.3585e-02_r8/)
      kbo(:, 3,28, 9) = (/ &
     &2.6353e+00_r8,2.0694e+00_r8,1.4297e+00_r8,7.5652e-01_r8,1.7012e-02_r8/)
      kbo(:, 4,28, 9) = (/ &
     &3.4268e+00_r8,2.6900e+00_r8,1.8600e+00_r8,9.8357e-01_r8,2.1005e-02_r8/)
      kbo(:, 5,28, 9) = (/ &
     &4.3754e+00_r8,3.4337e+00_r8,2.3745e+00_r8,1.2550e+00_r8,2.5556e-02_r8/)
      kbo(:, 1,29, 9) = (/ &
     &1.3575e+00_r8,1.0707e+00_r8,7.3899e-01_r8,3.9163e-01_r8,9.5187e-03_r8/)
      kbo(:, 2,29, 9) = (/ &
     &1.8443e+00_r8,1.4534e+00_r8,1.0029e+00_r8,5.3089e-01_r8,1.2207e-02_r8/)
      kbo(:, 3,29, 9) = (/ &
     &2.4443e+00_r8,1.9245e+00_r8,1.3293e+00_r8,7.0249e-01_r8,1.5292e-02_r8/)
      kbo(:, 4,29, 9) = (/ &
     &3.1715e+00_r8,2.4958e+00_r8,1.7237e+00_r8,9.1036e-01_r8,1.8851e-02_r8/)
      kbo(:, 5,29, 9) = (/ &
     &4.0410e+00_r8,3.1790e+00_r8,2.1964e+00_r8,1.1590e+00_r8,2.3121e-02_r8/)
      kbo(:, 1,30, 9) = (/ &
     &1.2615e+00_r8,9.9705e-01_r8,6.8810e-01_r8,3.6451e-01_r8,8.4241e-03_r8/)
      kbo(:, 2,30, 9) = (/ &
     &1.7102e+00_r8,1.3510e+00_r8,9.3203e-01_r8,4.9262e-01_r8,1.0769e-02_r8/)
      kbo(:, 3,30, 9) = (/ &
     &2.2602e+00_r8,1.7845e+00_r8,1.2315e+00_r8,6.5024e-01_r8,1.3569e-02_r8/)
      kbo(:, 4,30, 9) = (/ &
     &2.9275e+00_r8,2.3103e+00_r8,1.5947e+00_r8,8.4085e-01_r8,1.6868e-02_r8/)
      kbo(:, 5,30, 9) = (/ &
     &3.7272e+00_r8,2.9401e+00_r8,2.0301e+00_r8,1.0701e+00_r8,2.0720e-02_r8/)
      kbo(:, 1,31, 9) = (/ &
     &1.1628e+00_r8,9.2130e-01_r8,6.3548e-01_r8,3.3629e-01_r8,7.3212e-03_r8/)
      kbo(:, 2,31, 9) = (/ &
     &1.5710e+00_r8,1.2442e+00_r8,8.5840e-01_r8,4.5341e-01_r8,9.4089e-03_r8/)
      kbo(:, 3,31, 9) = (/ &
     &2.0741e+00_r8,1.6418e+00_r8,1.1326e+00_r8,5.9743e-01_r8,1.1908e-02_r8/)
      kbo(:, 4,31, 9) = (/ &
     &2.6838e+00_r8,2.1236e+00_r8,1.4650e+00_r8,7.7246e-01_r8,1.4841e-02_r8/)
      kbo(:, 5,31, 9) = (/ &
     &3.4158e+00_r8,2.7036e+00_r8,1.8662e+00_r8,9.8360e-01_r8,1.8280e-02_r8/)
      kbo(:, 1,32, 9) = (/ &
     &1.0770e+00_r8,8.5530e-01_r8,5.8998e-01_r8,3.1205e-01_r8,6.3886e-03_r8/)
      kbo(:, 2,32, 9) = (/ &
     &1.4521e+00_r8,1.1529e+00_r8,7.9467e-01_r8,4.1942e-01_r8,8.2479e-03_r8/)
      kbo(:, 3,32, 9) = (/ &
     &1.9141e+00_r8,1.5187e+00_r8,1.0473e+00_r8,5.5229e-01_r8,1.0468e-02_r8/)
      kbo(:, 4,32, 9) = (/ &
     &2.4773e+00_r8,1.9665e+00_r8,1.3565e+00_r8,7.1494e-01_r8,1.3077e-02_r8/)
      kbo(:, 5,32, 9) = (/ &
     &3.1536e+00_r8,2.5044e+00_r8,1.7279e+00_r8,9.1011e-01_r8,1.6196e-02_r8/)
      kbo(:, 1,33, 9) = (/ &
     &1.0004e+00_r8,7.9686e-01_r8,5.4943e-01_r8,2.9036e-01_r8,5.6169e-03_r8/)
      kbo(:, 2,33, 9) = (/ &
     &1.3472e+00_r8,1.0720e+00_r8,7.3887e-01_r8,3.9002e-01_r8,7.2464e-03_r8/)
      kbo(:, 3,33, 9) = (/ &
     &1.7767e+00_r8,1.4145e+00_r8,9.7493e-01_r8,5.1400e-01_r8,9.1682e-03_r8/)
      kbo(:, 4,33, 9) = (/ &
     &2.3006e+00_r8,1.8321e+00_r8,1.2634e+00_r8,6.6568e-01_r8,1.1493e-02_r8/)
      kbo(:, 5,33, 9) = (/ &
     &2.9306e+00_r8,2.3339e+00_r8,1.6102e+00_r8,8.4827e-01_r8,1.4147e-02_r8/)
      kbo(:, 1,34, 9) = (/ &
     &9.3256e-01_r8,7.4416e-01_r8,5.1264e-01_r8,2.7079e-01_r8,4.9465e-03_r8/)
      kbo(:, 2,34, 9) = (/ &
     &1.2561e+00_r8,1.0020e+00_r8,6.9034e-01_r8,3.6434e-01_r8,6.3960e-03_r8/)
      kbo(:, 3,34, 9) = (/ &
     &1.6587e+00_r8,1.3239e+00_r8,9.1206e-01_r8,4.8092e-01_r8,8.1576e-03_r8/)
      kbo(:, 4,34, 9) = (/ &
     &2.1501e+00_r8,1.7167e+00_r8,1.1837e+00_r8,6.2351e-01_r8,1.0194e-02_r8/)
      kbo(:, 5,34, 9) = (/ &
     &2.7413e+00_r8,2.1905e+00_r8,1.5115e+00_r8,7.9635e-01_r8,1.2542e-02_r8/)
      kbo(:, 1,35, 9) = (/ &
     &8.4840e-01_r8,6.7846e-01_r8,4.6725e-01_r8,2.4678e-01_r8,4.2581e-03_r8/)
      kbo(:, 2,35, 9) = (/ &
     &1.1466e+00_r8,9.1713e-01_r8,6.3179e-01_r8,3.3319e-01_r8,5.5317e-03_r8/)
      kbo(:, 3,35, 9) = (/ &
     &1.5185e+00_r8,1.2151e+00_r8,8.3727e-01_r8,4.4133e-01_r8,7.0625e-03_r8/)
      kbo(:, 4,35, 9) = (/ &
     &1.9737e+00_r8,1.5810e+00_r8,1.0899e+00_r8,5.7421e-01_r8,8.8571e-03_r8/)
      kbo(:, 5,35, 9) = (/ &
     &2.5262e+00_r8,2.0251e+00_r8,1.3975e+00_r8,7.3625e-01_r8,1.0897e-02_r8/)
      kbo(:, 1,36, 9) = (/ &
     &7.5165e-01_r8,6.0226e-01_r8,4.1465e-01_r8,2.1892e-01_r8,3.5512e-03_r8/)
      kbo(:, 2,36, 9) = (/ &
     &1.0210e+00_r8,8.1866e-01_r8,5.6371e-01_r8,2.9729e-01_r8,4.6496e-03_r8/)
      kbo(:, 3,36, 9) = (/ &
     &1.3584e+00_r8,1.0902e+00_r8,7.5109e-01_r8,3.9583e-01_r8,5.9580e-03_r8/)
      kbo(:, 4,36, 9) = (/ &
     &1.7752e+00_r8,1.4261e+00_r8,9.8305e-01_r8,5.1817e-01_r8,7.4947e-03_r8/)
      kbo(:, 5,36, 9) = (/ &
     &2.2842e+00_r8,1.8370e+00_r8,1.2679e+00_r8,6.6806e-01_r8,9.2616e-03_r8/)
      kbo(:, 1,37, 9) = (/ &
     &6.4071e-01_r8,5.1457e-01_r8,3.5423e-01_r8,1.8691e-01_r8,2.9273e-03_r8/)
      kbo(:, 2,37, 9) = (/ &
     &8.7819e-01_r8,7.0566e-01_r8,4.8576e-01_r8,2.5612e-01_r8,3.8482e-03_r8/)
      kbo(:, 3,37, 9) = (/ &
     &1.1781e+00_r8,9.4755e-01_r8,6.5255e-01_r8,3.4395e-01_r8,4.9507e-03_r8/)
      kbo(:, 4,37, 9) = (/ &
     &1.5513e+00_r8,1.2498e+00_r8,8.6132e-01_r8,4.5404e-01_r8,6.2679e-03_r8/)
      kbo(:, 5,37, 9) = (/ &
     &2.0117e+00_r8,1.6227e+00_r8,1.1201e+00_r8,5.9042e-01_r8,7.7688e-03_r8/)
      kbo(:, 1,38, 9) = (/ &
     &5.4507e-01_r8,4.3885e-01_r8,3.0197e-01_r8,1.5934e-01_r8,2.3915e-03_r8/)
      kbo(:, 2,38, 9) = (/ &
     &7.5435e-01_r8,6.0772e-01_r8,4.1826e-01_r8,2.2053e-01_r8,3.1638e-03_r8/)
      kbo(:, 3,38, 9) = (/ &
     &1.0211e+00_r8,8.2323e-01_r8,5.6695e-01_r8,2.9883e-01_r8,4.0903e-03_r8/)
      kbo(:, 4,38, 9) = (/ &
     &1.3557e+00_r8,1.0950e+00_r8,7.5476e-01_r8,3.9799e-01_r8,5.2077e-03_r8/)
      kbo(:, 5,38, 9) = (/ &
     &1.7730e+00_r8,1.4345e+00_r8,9.9017e-01_r8,5.2203e-01_r8,6.5004e-03_r8/)
      kbo(:, 1,39, 9) = (/ &
     &4.6353e-01_r8,3.7406e-01_r8,2.5754e-01_r8,1.3588e-01_r8,1.9343e-03_r8/)
      kbo(:, 2,39, 9) = (/ &
     &6.4812e-01_r8,5.2360e-01_r8,3.6039e-01_r8,1.9002e-01_r8,2.5847e-03_r8/)
      kbo(:, 3,39, 9) = (/ &
     &8.8607e-01_r8,7.1665e-01_r8,4.9365e-01_r8,2.6013e-01_r8,3.3630e-03_r8/)
      kbo(:, 4,39, 9) = (/ &
     &1.1877e+00_r8,9.6199e-01_r8,6.6338e-01_r8,3.4986e-01_r8,4.2963e-03_r8/)
      kbo(:, 5,39, 9) = (/ &
     &1.5671e+00_r8,1.2712e+00_r8,8.7761e-01_r8,4.6286e-01_r8,5.3839e-03_r8/)
      kbo(:, 1,40, 9) = (/ &
     &3.8448e-01_r8,3.1107e-01_r8,2.1410e-01_r8,1.1297e-01_r8,1.5568e-03_r8/)
      kbo(:, 2,40, 9) = (/ &
     &5.4501e-01_r8,4.4126e-01_r8,3.0380e-01_r8,1.6009e-01_r8,2.1042e-03_r8/)
      kbo(:, 3,40, 9) = (/ &
     &7.5403e-01_r8,6.1132e-01_r8,4.2098e-01_r8,2.2180e-01_r8,2.7494e-03_r8/)
      kbo(:, 4,40, 9) = (/ &
     &1.0220e+00_r8,8.2995e-01_r8,5.7215e-01_r8,3.0165e-01_r8,3.5443e-03_r8/)
      kbo(:, 5,40, 9) = (/ &
     &1.3627e+00_r8,1.1080e+00_r8,7.6492e-01_r8,4.0348e-01_r8,4.4643e-03_r8/)
      kbo(:, 1,41, 9) = (/ &
     &3.1745e-01_r8,2.5733e-01_r8,1.7713e-01_r8,9.3436e-02_r8,1.2472e-03_r8/)
      kbo(:, 2,41, 9) = (/ &
     &4.5638e-01_r8,3.7042e-01_r8,2.5491e-01_r8,1.3436e-01_r8,1.6993e-03_r8/)
      kbo(:, 3,41, 9) = (/ &
     &6.3982e-01_r8,5.1972e-01_r8,3.5784e-01_r8,1.8851e-01_r8,2.2393e-03_r8/)
      kbo(:, 4,41, 9) = (/ &
     &8.7763e-01_r8,7.1397e-01_r8,4.9232e-01_r8,2.5948e-01_r8,2.9086e-03_r8/)
      kbo(:, 5,41, 9) = (/ &
     &1.1829e+00_r8,9.6420e-01_r8,6.6569e-01_r8,3.5114e-01_r8,3.6948e-03_r8/)
      kbo(:, 1,42, 9) = (/ &
     &2.6148e-01_r8,2.1244e-01_r8,1.4620e-01_r8,7.7106e-02_r8,9.9249e-04_r8/)
      kbo(:, 2,42, 9) = (/ &
     &3.8152e-01_r8,3.1036e-01_r8,2.1367e-01_r8,1.1258e-01_r8,1.3669e-03_r8/)
      kbo(:, 3,42, 9) = (/ &
     &5.4219e-01_r8,4.4152e-01_r8,3.0416e-01_r8,1.6017e-01_r8,1.8223e-03_r8/)
      kbo(:, 4,42, 9) = (/ &
     &7.5310e-01_r8,6.1412e-01_r8,4.2345e-01_r8,2.2321e-01_r8,2.3766e-03_r8/)
      kbo(:, 5,42, 9) = (/ &
     &1.0272e+00_r8,8.3945e-01_r8,5.7960e-01_r8,3.0577e-01_r8,3.0463e-03_r8/)
      kbo(:, 1,43, 9) = (/ &
     &2.1184e-01_r8,1.7233e-01_r8,1.1866e-01_r8,6.2577e-02_r8,7.7589e-04_r8/)
      kbo(:, 2,43, 9) = (/ &
     &3.1451e-01_r8,2.5652e-01_r8,1.7660e-01_r8,9.2987e-02_r8,1.0831e-03_r8/)
      kbo(:, 3,43, 9) = (/ &
     &4.5438e-01_r8,3.7074e-01_r8,2.5543e-01_r8,1.3448e-01_r8,1.4611e-03_r8/)
      kbo(:, 4,43, 9) = (/ &
     &6.4007e-01_r8,5.2328e-01_r8,3.6079e-01_r8,1.9007e-01_r8,1.9178e-03_r8/)
      kbo(:, 5,43, 9) = (/ &
     &8.8479e-01_r8,7.2477e-01_r8,5.0046e-01_r8,2.6398e-01_r8,2.4774e-03_r8/)
      kbo(:, 1,44, 9) = (/ &
     &1.6982e-01_r8,1.3846e-01_r8,9.5299e-02_r8,5.0248e-02_r8,5.9857e-04_r8/)
      kbo(:, 2,44, 9) = (/ &
     &2.5706e-01_r8,2.1005e-01_r8,1.4462e-01_r8,7.6126e-02_r8,8.4785e-04_r8/)
      kbo(:, 3,44, 9) = (/ &
     &3.7786e-01_r8,3.0904e-01_r8,2.1286e-01_r8,1.1204e-01_r8,1.1605e-03_r8/)
      kbo(:, 4,44, 9) = (/ &
     &5.4071e-01_r8,4.4303e-01_r8,3.0555e-01_r8,1.6090e-01_r8,1.5453e-03_r8/)
      kbo(:, 5,44, 9) = (/ &
     &7.5841e-01_r8,6.2258e-01_r8,4.2996e-01_r8,2.2675e-01_r8,1.9959e-03_r8/)
      kbo(:, 1,45, 9) = (/ &
     &1.3545e-01_r8,1.1062e-01_r8,7.6155e-02_r8,4.0151e-02_r8,4.5711e-04_r8/)
      kbo(:, 2,45, 9) = (/ &
     &2.0919e-01_r8,1.7120e-01_r8,1.1790e-01_r8,6.2073e-02_r8,6.5798e-04_r8/)
      kbo(:, 3,45, 9) = (/ &
     &3.1316e-01_r8,2.5663e-01_r8,1.7679e-01_r8,9.2995e-02_r8,9.1164e-04_r8/)
      kbo(:, 4,45, 9) = (/ &
     &4.5567e-01_r8,3.7416e-01_r8,2.5813e-01_r8,1.3590e-01_r8,1.2287e-03_r8/)
      kbo(:, 5,45, 9) = (/ &
     &6.4919e-01_r8,5.3401e-01_r8,3.6882e-01_r8,1.9448e-01_r8,1.6029e-03_r8/)
      kbo(:, 1,46, 9) = (/ &
     &1.0668e-01_r8,8.7165e-02_r8,6.0007e-02_r8,3.1628e-02_r8,3.4444e-04_r8/)
      kbo(:, 2,46, 9) = (/ &
     &1.6793e-01_r8,1.3770e-01_r8,9.4805e-02_r8,4.9929e-02_r8,5.0372e-04_r8/)
      kbo(:, 3,46, 9) = (/ &
     &2.5640e-01_r8,2.1057e-01_r8,1.4511e-01_r8,7.6324e-02_r8,7.0786e-04_r8/)
      kbo(:, 4,46, 9) = (/ &
     &3.8014e-01_r8,3.1276e-01_r8,2.1587e-01_r8,1.1362e-01_r8,9.6784e-04_r8/)
      kbo(:, 5,46, 9) = (/ &
     &5.5078e-01_r8,4.5406e-01_r8,3.1364e-01_r8,1.6534e-01_r8,1.2803e-03_r8/)
      kbo(:, 1,47, 9) = (/ &
     &8.2159e-02_r8,6.7194e-02_r8,4.6255e-02_r8,2.4369e-02_r8,2.5696e-04_r8/)
      kbo(:, 2,47, 9) = (/ &
     &1.3183e-01_r8,1.0829e-01_r8,7.4558e-02_r8,3.9260e-02_r8,3.8064e-04_r8/)
      kbo(:, 3,47, 9) = (/ &
     &2.0579e-01_r8,1.6932e-01_r8,1.1664e-01_r8,6.1365e-02_r8,5.4299e-04_r8/)
      kbo(:, 4,47, 9) = (/ &
     &3.1127e-01_r8,2.5673e-01_r8,1.7713e-01_r8,9.3234e-02_r8,7.5354e-04_r8/)
      kbo(:, 5,47, 9) = (/ &
     &4.5944e-01_r8,3.7947e-01_r8,2.6220e-01_r8,1.3818e-01_r8,1.0123e-03_r8/)
      kbo(:, 1,48, 9) = (/ &
     &6.2805e-02_r8,5.1372e-02_r8,3.5337e-02_r8,1.8627e-02_r8,1.8799e-04_r8/)
      kbo(:, 2,48, 9) = (/ &
     &1.0282e-01_r8,8.4440e-02_r8,5.8150e-02_r8,3.0624e-02_r8,2.8497e-04_r8/)
      kbo(:, 3,48, 9) = (/ &
     &1.6397e-01_r8,1.3516e-01_r8,9.3148e-02_r8,4.8994e-02_r8,4.1296e-04_r8/)
      kbo(:, 4,48, 9) = (/ &
     &2.5353e-01_r8,2.0948e-01_r8,1.4454e-01_r8,7.6030e-02_r8,5.7970e-04_r8/)
      kbo(:, 5,48, 9) = (/ &
     &3.8151e-01_r8,3.1578e-01_r8,2.1823e-01_r8,1.1499e-01_r8,7.9062e-04_r8/)
      kbo(:, 1,49, 9) = (/ &
     &4.7675e-02_r8,3.9033e-02_r8,2.6875e-02_r8,1.4167e-02_r8,1.3591e-04_r8/)
      kbo(:, 2,49, 9) = (/ &
     &7.9683e-02_r8,6.5540e-02_r8,4.5120e-02_r8,2.3756e-02_r8,2.0952e-04_r8/)
      kbo(:, 3,49, 9) = (/ &
     &1.2966e-01_r8,1.0708e-01_r8,7.3804e-02_r8,3.8837e-02_r8,3.0991e-04_r8/)
      kbo(:, 4,49, 9) = (/ &
     &2.0506e-01_r8,1.6980e-01_r8,1.1714e-01_r8,6.1628e-02_r8,4.4095e-04_r8/)
      kbo(:, 5,49, 9) = (/ &
     &3.1515e-01_r8,2.6147e-01_r8,1.8074e-01_r8,9.5226e-02_r8,6.0820e-04_r8/)
      kbo(:, 1,50, 9) = (/ &
     &3.6548e-02_r8,2.9943e-02_r8,2.0610e-02_r8,1.0865e-02_r8,9.9917e-05_r8/)
      kbo(:, 2,50, 9) = (/ &
     &6.2279e-02_r8,5.1209e-02_r8,3.5254e-02_r8,1.8566e-02_r8,1.5653e-04_r8/)
      kbo(:, 3,50, 9) = (/ &
     &1.0318e-01_r8,8.5332e-02_r8,5.8808e-02_r8,3.0962e-02_r8,2.3703e-04_r8/)
      kbo(:, 4,50, 9) = (/ &
     &1.6688e-01_r8,1.3839e-01_r8,9.5487e-02_r8,5.0236e-02_r8,3.4171e-04_r8/)
      kbo(:, 5,50, 9) = (/ &
     &2.6185e-01_r8,2.1767e-01_r8,1.5045e-01_r8,7.9263e-02_r8,4.7617e-04_r8/)
      kbo(:, 1,51, 9) = (/ &
     &2.7952e-02_r8,2.2969e-02_r8,1.5811e-02_r8,8.3417e-03_r8,7.4671e-05_r8/)
      kbo(:, 2,51, 9) = (/ &
     &4.8817e-02_r8,4.0171e-02_r8,2.7641e-02_r8,1.4555e-02_r8,1.1814e-04_r8/)
      kbo(:, 3,51, 9) = (/ &
     &8.2508e-02_r8,6.8219e-02_r8,4.6983e-02_r8,2.4707e-02_r8,1.8096e-04_r8/)
      kbo(:, 4,51, 9) = (/ &
     &1.3588e-01_r8,1.1285e-01_r8,7.7859e-02_r8,4.0970e-02_r8,2.6754e-04_r8/)
      kbo(:, 5,51, 9) = (/ &
     &2.1776e-01_r8,1.8131e-01_r8,1.2532e-01_r8,6.5999e-02_r8,3.7856e-04_r8/)
      kbo(:, 1,52, 9) = (/ &
     &2.1199e-02_r8,1.7459e-02_r8,1.2025e-02_r8,6.3452e-03_r8,5.5107e-05_r8/)
      kbo(:, 2,52, 9) = (/ &
     &3.8088e-02_r8,3.1354e-02_r8,2.1571e-02_r8,1.1353e-02_r8,8.8069e-05_r8/)
      kbo(:, 3,52, 9) = (/ &
     &6.5619e-02_r8,5.4321e-02_r8,3.7416e-02_r8,1.9692e-02_r8,1.3680e-04_r8/)
      kbo(:, 4,52, 9) = (/ &
     &1.1018e-01_r8,9.1593e-02_r8,6.3191e-02_r8,3.3254e-02_r8,2.0641e-04_r8/)
      kbo(:, 5,52, 9) = (/ &
     &1.8039e-01_r8,1.5044e-01_r8,1.0398e-01_r8,5.4762e-02_r8,2.9766e-04_r8/)
      kbo(:, 1,53, 9) = (/ &
     &1.5917e-02_r8,1.3124e-02_r8,9.0469e-03_r8,4.7728e-03_r8,4.0227e-05_r8/)
      kbo(:, 2,53, 9) = (/ &
     &2.9453e-02_r8,2.4295e-02_r8,1.6728e-02_r8,8.8064e-03_r8,6.5428e-05_r8/)
      kbo(:, 3,53, 9) = (/ &
     &5.2020e-02_r8,4.3058e-02_r8,2.9653e-02_r8,1.5599e-02_r8,1.0270e-04_r8/)
      kbo(:, 4,53, 9) = (/ &
     &8.9031e-02_r8,7.3955e-02_r8,5.0990e-02_r8,2.6843e-02_r8,1.5632e-04_r8/)
      kbo(:, 5,53, 9) = (/ &
     &1.4878e-01_r8,1.2427e-01_r8,8.5889e-02_r8,4.5242e-02_r8,2.3095e-04_r8/)
      kbo(:, 1,54, 9) = (/ &
     &1.2118e-02_r8,1.0014e-02_r8,6.9093e-03_r8,3.6479e-03_r8,3.0413e-05_r8/)
      kbo(:, 2,54, 9) = (/ &
     &2.3157e-02_r8,1.9122e-02_r8,1.3172e-02_r8,6.9364e-03_r8,5.0720e-05_r8/)
      kbo(:, 3,54, 9) = (/ &
     &4.1929e-02_r8,3.4711e-02_r8,2.3913e-02_r8,1.2578e-02_r8,8.0499e-05_r8/)
      kbo(:, 4,54, 9) = (/ &
     &7.3182e-02_r8,6.0821e-02_r8,4.1911e-02_r8,2.2054e-02_r8,1.2452e-04_r8/)
      kbo(:, 5,54, 9) = (/ &
     &1.2434e-01_r8,1.0391e-01_r8,7.1807e-02_r8,3.7810e-02_r8,1.8706e-04_r8/)
      kbo(:, 1,55, 9) = (/ &
     &9.2663e-03_r8,7.6785e-03_r8,5.3030e-03_r8,2.7962e-03_r8,2.3331e-05_r8/)
      kbo(:, 2,55, 9) = (/ &
     &1.8303e-02_r8,1.5169e-02_r8,1.0453e-02_r8,5.5039e-03_r8,4.0062e-05_r8/)
      kbo(:, 3,55, 9) = (/ &
     &3.4131e-02_r8,2.8258e-02_r8,1.9454e-02_r8,1.0230e-02_r8,6.4887e-05_r8/)
      kbo(:, 4,55, 9) = (/ &
     &6.0672e-02_r8,5.0398e-02_r8,3.4733e-02_r8,1.8270e-02_r8,1.0169e-04_r8/)
      kbo(:, 5,55, 9) = (/ &
     &1.0468e-01_r8,8.7488e-02_r8,6.0450e-02_r8,3.1810e-02_r8,1.5537e-04_r8/)
      kbo(:, 1,56, 9) = (/ &
     &7.0383e-03_r8,5.8452e-03_r8,4.0381e-03_r8,2.1288e-03_r8,1.7811e-05_r8/)
      kbo(:, 2,56, 9) = (/ &
     &1.4408e-02_r8,1.1966e-02_r8,8.2523e-03_r8,4.3448e-03_r8,3.1488e-05_r8/)
      kbo(:, 3,56, 9) = (/ &
     &2.7695e-02_r8,2.2953e-02_r8,1.5811e-02_r8,8.3080e-03_r8,5.2239e-05_r8/)
      kbo(:, 4,56, 9) = (/ &
     &5.0327e-02_r8,4.1815e-02_r8,2.8827e-02_r8,1.5149e-02_r8,8.2952e-05_r8/)
      kbo(:, 5,56, 9) = (/ &
     &8.8477e-02_r8,7.3786e-02_r8,5.0905e-02_r8,2.6783e-02_r8,1.2900e-04_r8/)
      kbo(:, 1,57, 9) = (/ &
     &5.2984e-03_r8,4.4048e-03_r8,3.0442e-03_r8,1.6062e-03_r8,1.3485e-05_r8/)
      kbo(:, 2,57, 9) = (/ &
     &1.1277e-02_r8,9.3839e-03_r8,6.4745e-03_r8,3.4126e-03_r8,2.4664e-05_r8/)
      kbo(:, 3,57, 9) = (/ &
     &2.2383e-02_r8,1.8598e-02_r8,1.2810e-02_r8,6.7278e-03_r8,4.2073e-05_r8/)
      kbo(:, 4,57, 9) = (/ &
     &4.1793e-02_r8,3.4722e-02_r8,2.3901e-02_r8,1.2561e-02_r8,6.8099e-05_r8/)
      kbo(:, 5,57, 9) = (/ &
     &7.4879e-02_r8,6.2449e-02_r8,4.3075e-02_r8,2.2643e-02_r8,1.0701e-04_r8/)
      kbo(:, 1,58, 9) = (/ &
     &1.9422e-03_r8,1.8562e-03_r8,1.5070e-03_r8,9.6178e-04_r8,1.0242e-05_r8/)
      kbo(:, 2,58, 9) = (/ &
     &4.2963e-03_r8,4.1126e-03_r8,3.3378e-03_r8,2.1278e-03_r8,1.9475e-05_r8/)
      kbo(:, 3,58, 9) = (/ &
     &8.8321e-03_r8,8.4312e-03_r8,6.8267e-03_r8,4.3437e-03_r8,3.4347e-05_r8/)
      kbo(:, 4,58, 9) = (/ &
     &1.7006e-02_r8,1.6220e-02_r8,1.3112e-02_r8,8.3245e-03_r8,5.6453e-05_r8/)
      kbo(:, 5,58, 9) = (/ &
     &3.1001e-02_r8,2.9664e-02_r8,2.4013e-02_r8,1.5274e-02_r8,9.0315e-05_r8/)
      kbo(:, 1,59, 9) = (/ &
     &1.6680e-03_r8,1.5995e-03_r8,1.3049e-03_r8,8.3836e-04_r8,9.2179e-06_r8/)
      kbo(:, 2,59, 9) = (/ &
     &3.7712e-03_r8,3.6258e-03_r8,2.9561e-03_r8,1.8979e-03_r8,1.8017e-05_r8/)
      kbo(:, 3,59, 9) = (/ &
     &7.9144e-03_r8,7.6082e-03_r8,6.1886e-03_r8,3.9647e-03_r8,3.2435e-05_r8/)
      kbo(:, 4,59, 9) = (/ &
     &1.5562e-02_r8,1.4917e-02_r8,1.2127e-02_r8,7.7579e-03_r8,5.4862e-05_r8/)
      kbo(:, 5,59, 9) = (/ &
     &2.8789e-02_r8,2.7607e-02_r8,2.2446e-02_r8,1.4356e-02_r8,8.9155e-05_r8/)
      kbo(:, 1,13,10) = (/ &
     &3.5965e+01_r8,2.6975e+01_r8,1.7984e+01_r8,9.0232e+00_r8,2.4705e-01_r8/)
      kbo(:, 2,13,10) = (/ &
     &5.0800e+01_r8,3.8101e+01_r8,2.5403e+01_r8,1.2739e+01_r8,2.8941e-01_r8/)
      kbo(:, 3,13,10) = (/ &
     &6.8409e+01_r8,5.1309e+01_r8,3.4208e+01_r8,1.7156e+01_r8,3.3771e-01_r8/)
      kbo(:, 4,13,10) = (/ &
     &8.8981e+01_r8,6.6739e+01_r8,4.4497e+01_r8,2.2337e+01_r8,3.9418e-01_r8/)
      kbo(:, 5,13,10) = (/ &
     &1.1252e+02_r8,8.4389e+01_r8,5.6260e+01_r8,2.8284e+01_r8,4.6348e-01_r8/)
      kbo(:, 1,14,10) = (/ &
     &3.4773e+01_r8,2.6079e+01_r8,1.7386e+01_r8,8.7850e+00_r8,2.3514e-01_r8/)
      kbo(:, 2,14,10) = (/ &
     &4.8754e+01_r8,3.6565e+01_r8,2.4376e+01_r8,1.2316e+01_r8,2.9035e-01_r8/)
      kbo(:, 3,14,10) = (/ &
     &6.5535e+01_r8,4.9151e+01_r8,3.2769e+01_r8,1.6566e+01_r8,3.5401e-01_r8/)
      kbo(:, 4,14,10) = (/ &
     &8.5152e+01_r8,6.3871e+01_r8,4.2583e+01_r8,2.1543e+01_r8,4.0952e-01_r8/)
      kbo(:, 5,14,10) = (/ &
     &1.0714e+02_r8,8.0354e+01_r8,5.3570e+01_r8,2.7127e+01_r8,4.6861e-01_r8/)
      kbo(:, 1,15,10) = (/ &
     &3.1708e+01_r8,2.3780e+01_r8,1.5854e+01_r8,8.0780e+00_r8,2.2725e-01_r8/)
      kbo(:, 2,15,10) = (/ &
     &4.4299e+01_r8,3.3227e+01_r8,2.2149e+01_r8,1.1301e+01_r8,2.7237e-01_r8/)
      kbo(:, 3,15,10) = (/ &
     &5.9451e+01_r8,4.4587e+01_r8,2.9727e+01_r8,1.5175e+01_r8,3.1480e-01_r8/)
      kbo(:, 4,15,10) = (/ &
     &7.6914e+01_r8,5.7688e+01_r8,3.8460e+01_r8,1.9633e+01_r8,3.5895e-01_r8/)
      kbo(:, 5,15,10) = (/ &
     &9.6187e+01_r8,7.2137e+01_r8,4.8097e+01_r8,2.4537e+01_r8,4.0136e-01_r8/)
      kbo(:, 1,16,10) = (/ &
     &2.8000e+01_r8,2.1001e+01_r8,1.4008e+01_r8,7.1879e+00_r8,1.8684e-01_r8/)
      kbo(:, 2,16,10) = (/ &
     &3.8983e+01_r8,2.9238e+01_r8,1.9500e+01_r8,1.0007e+01_r8,2.3111e-01_r8/)
      kbo(:, 3,16,10) = (/ &
     &5.2090e+01_r8,3.9071e+01_r8,2.6063e+01_r8,1.3380e+01_r8,2.7168e-01_r8/)
      kbo(:, 4,16,10) = (/ &
     &6.6962e+01_r8,5.0223e+01_r8,3.3517e+01_r8,1.7217e+01_r8,3.1091e-01_r8/)
      kbo(:, 5,16,10) = (/ &
     &8.3570e+01_r8,6.2687e+01_r8,4.1858e+01_r8,2.1531e+01_r8,3.6276e-01_r8/)
      kbo(:, 1,17,10) = (/ &
     &2.4264e+01_r8,1.8198e+01_r8,1.2195e+01_r8,6.2664e+00_r8,1.7021e-01_r8/)
      kbo(:, 2,17,10) = (/ &
     &3.3645e+01_r8,2.5234e+01_r8,1.6913e+01_r8,8.7049e+00_r8,1.9751e-01_r8/)
      kbo(:, 3,17,10) = (/ &
     &4.4643e+01_r8,3.3486e+01_r8,2.2452e+01_r8,1.1586e+01_r8,2.2201e-01_r8/)
      kbo(:, 4,17,10) = (/ &
     &5.7207e+01_r8,4.2902e+01_r8,2.8791e+01_r8,1.4899e+01_r8,2.5554e-01_r8/)
      kbo(:, 5,17,10) = (/ &
     &7.1193e+01_r8,5.3402e+01_r8,3.5856e+01_r8,1.8608e+01_r8,2.9547e-01_r8/)
      kbo(:, 1,18,10) = (/ &
     &2.0477e+01_r8,1.5356e+01_r8,1.0367e+01_r8,5.3622e+00_r8,1.3534e-01_r8/)
      kbo(:, 2,18,10) = (/ &
     &2.8178e+01_r8,2.1132e+01_r8,1.4278e+01_r8,7.4149e+00_r8,1.5634e-01_r8/)
      kbo(:, 3,18,10) = (/ &
     &3.7210e+01_r8,2.7911e+01_r8,1.8862e+01_r8,9.8384e+00_r8,1.8020e-01_r8/)
      kbo(:, 4,18,10) = (/ &
     &4.7546e+01_r8,3.5659e+01_r8,2.4100e+01_r8,1.2600e+01_r8,2.1507e-01_r8/)
      kbo(:, 5,18,10) = (/ &
     &5.8973e+01_r8,4.4229e+01_r8,2.9880e+01_r8,1.5650e+01_r8,2.3467e-01_r8/)
      kbo(:, 1,19,10) = (/ &
     &1.7373e+01_r8,1.3040e+01_r8,8.8390e+00_r8,4.6588e+00_r8,1.1972e-01_r8/)
      kbo(:, 2,19,10) = (/ &
     &2.3793e+01_r8,1.7857e+01_r8,1.2109e+01_r8,6.3963e+00_r8,1.3774e-01_r8/)
      kbo(:, 3,19,10) = (/ &
     &3.1336e+01_r8,2.3520e+01_r8,1.5961e+01_r8,8.4390e+00_r8,1.6091e-01_r8/)
      kbo(:, 4,19,10) = (/ &
     &3.9866e+01_r8,2.9935e+01_r8,2.0331e+01_r8,1.0756e+01_r8,1.7955e-01_r8/)
      kbo(:, 5,19,10) = (/ &
     &4.9495e+01_r8,3.7175e+01_r8,2.5257e+01_r8,1.3339e+01_r8,2.0663e-01_r8/)
      kbo(:, 1,20,10) = (/ &
     &1.5037e+01_r8,1.1322e+01_r8,7.6844e+00_r8,4.1127e+00_r8,1.0485e-01_r8/)
      kbo(:, 2,20,10) = (/ &
     &2.0515e+01_r8,1.5450e+01_r8,1.0499e+01_r8,5.6182e+00_r8,1.2148e-01_r8/)
      kbo(:, 3,20,10) = (/ &
     &2.6886e+01_r8,2.0252e+01_r8,1.3792e+01_r8,7.3741e+00_r8,1.4561e-01_r8/)
      kbo(:, 4,20,10) = (/ &
     &3.4287e+01_r8,2.5832e+01_r8,1.7615e+01_r8,9.3860e+00_r8,1.6294e-01_r8/)
      kbo(:, 5,20,10) = (/ &
     &4.2841e+01_r8,3.2278e+01_r8,2.2023e+01_r8,1.1711e+01_r8,1.8624e-01_r8/)
      kbo(:, 1,21,10) = (/ &
     &1.3152e+01_r8,9.9438e+00_r8,6.7780e+00_r8,3.6471e+00_r8,9.1853e-02_r8/)
      kbo(:, 2,21,10) = (/ &
     &1.7866e+01_r8,1.3511e+01_r8,9.2298e+00_r8,4.9595e+00_r8,1.1141e-01_r8/)
      kbo(:, 3,21,10) = (/ &
     &2.3469e+01_r8,1.7747e+01_r8,1.2135e+01_r8,6.5086e+00_r8,1.2785e-01_r8/)
      kbo(:, 4,21,10) = (/ &
     &3.0120e+01_r8,2.2761e+01_r8,1.5567e+01_r8,8.3305e+00_r8,1.5176e-01_r8/)
      kbo(:, 5,21,10) = (/ &
     &3.7884e+01_r8,2.8609e+01_r8,1.9560e+01_r8,1.0448e+01_r8,1.7309e-01_r8/)
      kbo(:, 1,22,10) = (/ &
     &1.1757e+01_r8,8.9118e+00_r8,6.1382e+00_r8,3.3115e+00_r8,8.1057e-02_r8/)
      kbo(:, 2,22,10) = (/ &
     &1.5980e+01_r8,1.2109e+01_r8,8.3336e+00_r8,4.4832e+00_r8,9.8906e-02_r8/)
      kbo(:, 3,22,10) = (/ &
     &2.1108e+01_r8,1.5991e+01_r8,1.0992e+01_r8,5.8971e+00_r8,1.1586e-01_r8/)
      kbo(:, 4,22,10) = (/ &
     &2.7285e+01_r8,2.0659e+01_r8,1.4174e+01_r8,7.5863e+00_r8,1.3507e-01_r8/)
      kbo(:, 5,22,10) = (/ &
     &3.4676e+01_r8,2.6248e+01_r8,1.7966e+01_r8,9.5810e+00_r8,1.5851e-01_r8/)
      kbo(:, 1,23,10) = (/ &
     &1.0481e+01_r8,7.9685e+00_r8,5.5490e+00_r8,2.9996e+00_r8,7.4309e-02_r8/)
      kbo(:, 2,23,10) = (/ &
     &1.4420e+01_r8,1.0955e+01_r8,7.5878e+00_r8,4.0805e+00_r8,8.6253e-02_r8/)
      kbo(:, 3,23,10) = (/ &
     &1.9219e+01_r8,1.4600e+01_r8,1.0073e+01_r8,5.3977e+00_r8,1.0580e-01_r8/)
      kbo(:, 4,23,10) = (/ &
     &2.5108e+01_r8,1.9069e+01_r8,1.3115e+01_r8,7.0020e+00_r8,1.2265e-01_r8/)
      kbo(:, 5,23,10) = (/ &
     &3.2043e+01_r8,2.4337e+01_r8,1.6704e+01_r8,8.8942e+00_r8,1.4381e-01_r8/)
      kbo(:, 1,24,10) = (/ &
     &9.5276e+00_r8,7.2768e+00_r8,5.0826e+00_r8,2.7465e+00_r8,6.4655e-02_r8/)
      kbo(:, 2,24,10) = (/ &
     &1.3271e+01_r8,1.0121e+01_r8,7.0214e+00_r8,3.7657e+00_r8,7.9291e-02_r8/)
      kbo(:, 3,24,10) = (/ &
     &1.7863e+01_r8,1.3622e+01_r8,9.4201e+00_r8,5.0307e+00_r8,9.5461e-02_r8/)
      kbo(:, 4,24,10) = (/ &
     &2.3325e+01_r8,1.7783e+01_r8,1.2273e+01_r8,6.5420e+00_r8,1.1274e-01_r8/)
      kbo(:, 5,24,10) = (/ &
     &2.9564e+01_r8,2.2536e+01_r8,1.5537e+01_r8,8.2816e+00_r8,1.3418e-01_r8/)
      kbo(:, 1,25,10) = (/ &
     &8.8160e+00_r8,6.7673e+00_r8,4.7220e+00_r8,2.5379e+00_r8,5.8489e-02_r8/)
      kbo(:, 2,25,10) = (/ &
     &1.2357e+01_r8,9.4685e+00_r8,6.5735e+00_r8,3.5130e+00_r8,7.2064e-02_r8/)
      kbo(:, 3,25,10) = (/ &
     &1.6557e+01_r8,1.2678e+01_r8,8.7976e+00_r8,4.6917e+00_r8,8.6281e-02_r8/)
      kbo(:, 4,25,10) = (/ &
     &2.1444e+01_r8,1.6408e+01_r8,1.1376e+01_r8,6.0717e+00_r8,1.0416e-01_r8/)
      kbo(:, 5,25,10) = (/ &
     &2.7072e+01_r8,2.0703e+01_r8,1.4347e+01_r8,7.6551e+00_r8,1.2572e-01_r8/)
      kbo(:, 1,26,10) = (/ &
     &8.2437e+00_r8,6.3645e+00_r8,4.4442e+00_r8,2.3799e+00_r8,5.3046e-02_r8/)
      kbo(:, 2,26,10) = (/ &
     &1.1483e+01_r8,8.8437e+00_r8,6.1605e+00_r8,3.2883e+00_r8,6.5278e-02_r8/)
      kbo(:, 3,26,10) = (/ &
     &1.5261e+01_r8,1.1739e+01_r8,8.1695e+00_r8,4.3593e+00_r8,8.0191e-02_r8/)
      kbo(:, 4,26,10) = (/ &
     &1.9700e+01_r8,1.5135e+01_r8,1.0534e+01_r8,5.6197e+00_r8,9.7601e-02_r8/)
      kbo(:, 5,26,10) = (/ &
     &2.4857e+01_r8,1.9072e+01_r8,1.3248e+01_r8,7.0653e+00_r8,1.1704e-01_r8/)
      kbo(:, 1,27,10) = (/ &
     &7.7081e+00_r8,5.9885e+00_r8,4.1814e+00_r8,2.2306e+00_r8,4.7409e-02_r8/)
      kbo(:, 2,27,10) = (/ &
     &1.0576e+01_r8,8.1915e+00_r8,5.7182e+00_r8,3.0504e+00_r8,5.8512e-02_r8/)
      kbo(:, 3,27,10) = (/ &
     &1.4014e+01_r8,1.0837e+01_r8,7.5629e+00_r8,4.0315e+00_r8,7.3955e-02_r8/)
      kbo(:, 4,27,10) = (/ &
     &1.8113e+01_r8,1.3973e+01_r8,9.7390e+00_r8,5.1847e+00_r8,9.0794e-02_r8/)
      kbo(:, 5,27,10) = (/ &
     &2.2862e+01_r8,1.7593e+01_r8,1.2246e+01_r8,6.5228e+00_r8,1.0871e-01_r8/)
      kbo(:, 1,28,10) = (/ &
     &7.2063e+00_r8,5.6196e+00_r8,3.9203e+00_r8,2.0882e+00_r8,4.3129e-02_r8/)
      kbo(:, 2,28,10) = (/ &
     &9.7817e+00_r8,7.6085e+00_r8,5.3084e+00_r8,2.8196e+00_r8,5.4812e-02_r8/)
      kbo(:, 3,28,10) = (/ &
     &1.2904e+01_r8,1.0029e+01_r8,7.0025e+00_r8,3.7236e+00_r8,6.8395e-02_r8/)
      kbo(:, 4,28,10) = (/ &
     &1.6696e+01_r8,1.2935e+01_r8,9.0135e+00_r8,4.7943e+00_r8,8.2716e-02_r8/)
      kbo(:, 5,28,10) = (/ &
     &2.1096e+01_r8,1.6309e+01_r8,1.1368e+01_r8,6.0506e+00_r8,9.9935e-02_r8/)
      kbo(:, 1,29,10) = (/ &
     &6.7278e+00_r8,5.2636e+00_r8,3.6717e+00_r8,1.9437e+00_r8,3.9266e-02_r8/)
      kbo(:, 2,29,10) = (/ &
     &9.0515e+00_r8,7.0710e+00_r8,4.9355e+00_r8,2.6130e+00_r8,4.9834e-02_r8/)
      kbo(:, 3,29,10) = (/ &
     &1.1919e+01_r8,9.2978e+00_r8,6.4770e+00_r8,3.4412e+00_r8,6.2077e-02_r8/)
      kbo(:, 4,29,10) = (/ &
     &1.5380e+01_r8,1.1978e+01_r8,8.3499e+00_r8,4.4362e+00_r8,7.6798e-02_r8/)
      kbo(:, 5,29,10) = (/ &
     &1.9420e+01_r8,1.5097e+01_r8,1.0536e+01_r8,5.6045e+00_r8,9.1669e-02_r8/)
      kbo(:, 1,30,10) = (/ &
     &6.2882e+00_r8,4.9355e+00_r8,3.4323e+00_r8,1.8115e+00_r8,3.5713e-02_r8/)
      kbo(:, 2,30,10) = (/ &
     &8.4169e+00_r8,6.5906e+00_r8,4.5841e+00_r8,2.4262e+00_r8,4.5752e-02_r8/)
      kbo(:, 3,30,10) = (/ &
     &1.1024e+01_r8,8.6363e+00_r8,6.0145e+00_r8,3.1864e+00_r8,5.7473e-02_r8/)
      kbo(:, 4,30,10) = (/ &
     &1.4192e+01_r8,1.1103e+01_r8,7.7439e+00_r8,4.1120e+00_r8,7.0729e-02_r8/)
      kbo(:, 5,30,10) = (/ &
     &1.7890e+01_r8,1.3978e+01_r8,9.7651e+00_r8,5.1860e+00_r8,8.5534e-02_r8/)
      kbo(:, 1,31,10) = (/ &
     &5.8439e+00_r8,4.6051e+00_r8,3.1957e+00_r8,1.6863e+00_r8,3.2654e-02_r8/)
      kbo(:, 2,31,10) = (/ &
     &7.8033e+00_r8,6.1378e+00_r8,4.2622e+00_r8,2.2515e+00_r8,4.2183e-02_r8/)
      kbo(:, 3,31,10) = (/ &
     &1.0196e+01_r8,8.0235e+00_r8,5.5836e+00_r8,2.9533e+00_r8,5.3011e-02_r8/)
      kbo(:, 4,31,10) = (/ &
     &1.3072e+01_r8,1.0286e+01_r8,7.1778e+00_r8,3.8005e+00_r8,6.4875e-02_r8/)
      kbo(:, 5,31,10) = (/ &
     &1.6463e+01_r8,1.2924e+01_r8,9.0292e+00_r8,4.7849e+00_r8,7.7772e-02_r8/)
      kbo(:, 1,32,10) = (/ &
     &5.4664e+00_r8,4.3291e+00_r8,2.9999e+00_r8,1.5808e+00_r8,2.9923e-02_r8/)
      kbo(:, 2,32,10) = (/ &
     &7.2874e+00_r8,5.7710e+00_r8,4.0068e+00_r8,2.1122e+00_r8,3.8267e-02_r8/)
      kbo(:, 3,32,10) = (/ &
     &9.5041e+00_r8,7.5231e+00_r8,5.2374e+00_r8,2.7661e+00_r8,4.7331e-02_r8/)
      kbo(:, 4,32,10) = (/ &
     &1.2176e+01_r8,9.6156e+00_r8,6.7066e+00_r8,3.5449e+00_r8,5.8625e-02_r8/)
      kbo(:, 5,32,10) = (/ &
     &1.5322e+01_r8,1.2084e+01_r8,8.4483e+00_r8,4.4709e+00_r8,6.9340e-02_r8/)
      kbo(:, 1,33,10) = (/ &
     &5.1512e+00_r8,4.0967e+00_r8,2.8362e+00_r8,1.4933e+00_r8,2.6393e-02_r8/)
      kbo(:, 2,33,10) = (/ &
     &6.8599e+00_r8,5.4552e+00_r8,3.7902e+00_r8,1.9993e+00_r8,3.4040e-02_r8/)
      kbo(:, 3,33,10) = (/ &
     &8.9395e+00_r8,7.1038e+00_r8,4.9489e+00_r8,2.6104e+00_r8,4.2820e-02_r8/)
      kbo(:, 4,33,10) = (/ &
     &1.1449e+01_r8,9.0816e+00_r8,6.3367e+00_r8,3.3421e+00_r8,5.1919e-02_r8/)
      kbo(:, 5,33,10) = (/ &
     &1.4423e+01_r8,1.1426e+01_r8,7.9850e+00_r8,4.2179e+00_r8,6.2402e-02_r8/)
      kbo(:, 1,34,10) = (/ &
     &4.8646e+00_r8,3.8880e+00_r8,2.6932e+00_r8,1.4194e+00_r8,2.3781e-02_r8/)
      kbo(:, 2,34,10) = (/ &
     &6.4672e+00_r8,5.1782e+00_r8,3.6018e+00_r8,1.8962e+00_r8,3.0492e-02_r8/)
      kbo(:, 3,34,10) = (/ &
     &8.4535e+00_r8,6.7497e+00_r8,4.7054e+00_r8,2.4770e+00_r8,3.8339e-02_r8/)
      kbo(:, 4,34,10) = (/ &
     &1.0856e+01_r8,8.6484e+00_r8,6.0350e+00_r8,3.1793e+00_r8,4.6570e-02_r8/)
      kbo(:, 5,34,10) = (/ &
     &1.3723e+01_r8,1.0909e+01_r8,7.6246e+00_r8,4.0214e+00_r8,5.6226e-02_r8/)
      kbo(:, 1,35,10) = (/ &
     &4.4902e+00_r8,3.6079e+00_r8,2.5027e+00_r8,1.3156e+00_r8,2.1238e-02_r8/)
      kbo(:, 2,35,10) = (/ &
     &5.9918e+00_r8,4.8154e+00_r8,3.3497e+00_r8,1.7639e+00_r8,2.7153e-02_r8/)
      kbo(:, 3,35,10) = (/ &
     &7.8693e+00_r8,6.3098e+00_r8,4.3964e+00_r8,2.3124e+00_r8,3.3573e-02_r8/)
      kbo(:, 4,35,10) = (/ &
     &1.0156e+01_r8,8.1193e+00_r8,5.6658e+00_r8,2.9812e+00_r8,4.1298e-02_r8/)
      kbo(:, 5,35,10) = (/ &
     &1.2867e+01_r8,1.0277e+01_r8,7.1860e+00_r8,3.7872e+00_r8,4.9619e-02_r8/)
      kbo(:, 1,36,10) = (/ &
     &4.0317e+00_r8,3.2575e+00_r8,2.2591e+00_r8,1.1864e+00_r8,1.8322e-02_r8/)
      kbo(:, 2,36,10) = (/ &
     &5.4230e+00_r8,4.3764e+00_r8,3.0444e+00_r8,1.6008e+00_r8,2.3437e-02_r8/)
      kbo(:, 3,36,10) = (/ &
     &7.1807e+00_r8,5.7770e+00_r8,4.0236e+00_r8,2.1147e+00_r8,2.8934e-02_r8/)
      kbo(:, 4,36,10) = (/ &
     &9.3214e+00_r8,7.4860e+00_r8,5.2247e+00_r8,2.7453e+00_r8,3.5476e-02_r8/)
      kbo(:, 5,36,10) = (/ &
     &1.1871e+01_r8,9.5152e+00_r8,6.6538e+00_r8,3.5057e+00_r8,4.2476e-02_r8/)
      kbo(:, 1,37,10) = (/ &
     &3.4945e+00_r8,2.8322e+00_r8,1.9642e+00_r8,1.0316e+00_r8,1.5292e-02_r8/)
      kbo(:, 2,37,10) = (/ &
     &4.7474e+00_r8,3.8477e+00_r8,2.6749e+00_r8,1.4057e+00_r8,1.9829e-02_r8/)
      kbo(:, 3,37,10) = (/ &
     &6.3563e+00_r8,5.1351e+00_r8,3.5754e+00_r8,1.8774e+00_r8,2.4925e-02_r8/)
      kbo(:, 4,37,10) = (/ &
     &8.3333e+00_r8,6.7182e+00_r8,4.6872e+00_r8,2.4610e+00_r8,3.0513e-02_r8/)
      kbo(:, 5,37,10) = (/ &
     &1.0705e+01_r8,8.6094e+00_r8,6.0143e+00_r8,3.1664e+00_r8,3.6834e-02_r8/)
      kbo(:, 1,38,10) = (/ &
     &3.0288e+00_r8,2.4619e+00_r8,1.7084e+00_r8,8.9674e-01_r8,1.2715e-02_r8/)
      kbo(:, 2,38,10) = (/ &
     &4.1608e+00_r8,3.3834e+00_r8,2.3515e+00_r8,1.2353e+00_r8,1.6555e-02_r8/)
      kbo(:, 3,38,10) = (/ &
     &5.6346e+00_r8,4.5721e+00_r8,3.1807e+00_r8,1.6688e+00_r8,2.1253e-02_r8/)
      kbo(:, 4,38,10) = (/ &
     &7.4639e+00_r8,6.0370e+00_r8,4.2092e+00_r8,2.2090e+00_r8,2.6215e-02_r8/)
      kbo(:, 5,38,10) = (/ &
     &9.6723e+00_r8,7.8054e+00_r8,5.4498e+00_r8,2.8669e+00_r8,3.1673e-02_r8/)
      kbo(:, 1,39,10) = (/ &
     &2.6346e+00_r8,2.1501e+00_r8,1.4897e+00_r8,7.8179e-01_r8,1.0494e-02_r8/)
      kbo(:, 2,39,10) = (/ &
     &3.6623e+00_r8,2.9868e+00_r8,2.0748e+00_r8,1.0900e+00_r8,1.3801e-02_r8/)
      kbo(:, 3,39,10) = (/ &
     &5.0149e+00_r8,4.0819e+00_r8,2.8376e+00_r8,1.4889e+00_r8,1.7948e-02_r8/)
      kbo(:, 4,39,10) = (/ &
     &6.7074e+00_r8,5.4432e+00_r8,3.7906e+00_r8,1.9883e+00_r8,2.2190e-02_r8/)
      kbo(:, 5,39,10) = (/ &
     &8.7675e+00_r8,7.1019e+00_r8,4.9572e+00_r8,2.6054e+00_r8,2.6961e-02_r8/)
      kbo(:, 1,40,10) = (/ &
     &2.2414e+00_r8,1.8312e+00_r8,1.2669e+00_r8,6.6464e-01_r8,8.6033e-03_r8/)
      kbo(:, 2,40,10) = (/ &
     &3.1461e+00_r8,2.5731e+00_r8,1.7855e+00_r8,9.3826e-01_r8,1.1425e-02_r8/)
      kbo(:, 3,40,10) = (/ &
     &4.3645e+00_r8,3.5639e+00_r8,2.4772e+00_r8,1.3001e+00_r8,1.5150e-02_r8/)
      kbo(:, 4,40,10) = (/ &
     &5.9195e+00_r8,4.8196e+00_r8,3.3561e+00_r8,1.7603e+00_r8,1.8984e-02_r8/)
      kbo(:, 5,40,10) = (/ &
     &7.8344e+00_r8,6.3662e+00_r8,4.4409e+00_r8,2.3324e+00_r8,2.3286e-02_r8/)
      kbo(:, 1,41,10) = (/ &
     &1.9009e+00_r8,1.5581e+00_r8,1.0772e+00_r8,5.6390e-01_r8,7.0145e-03_r8/)
      kbo(:, 2,41,10) = (/ &
     &2.6997e+00_r8,2.2094e+00_r8,1.5334e+00_r8,8.0488e-01_r8,9.5005e-03_r8/)
      kbo(:, 3,41,10) = (/ &
     &3.7885e+00_r8,3.1035e+00_r8,2.1567e+00_r8,1.1320e+00_r8,1.2665e-02_r8/)
      kbo(:, 4,41,10) = (/ &
     &5.2083e+00_r8,4.2587e+00_r8,2.9632e+00_r8,1.5552e+00_r8,1.6096e-02_r8/)
      kbo(:, 5,41,10) = (/ &
     &6.9899e+00_r8,5.6957e+00_r8,3.9715e+00_r8,2.0851e+00_r8,2.0007e-02_r8/)
      kbo(:, 1,42,10) = (/ &
     &1.6073e+00_r8,1.3214e+00_r8,9.1410e-01_r8,4.7869e-01_r8,5.6658e-03_r8/)
      kbo(:, 2,42,10) = (/ &
     &2.3166e+00_r8,1.9016e+00_r8,1.3175e+00_r8,6.9100e-01_r8,7.8082e-03_r8/)
      kbo(:, 3,42,10) = (/ &
     &3.2935e+00_r8,2.7045e+00_r8,1.8773e+00_r8,9.8575e-01_r8,1.0484e-02_r8/)
      kbo(:, 4,42,10) = (/ &
     &4.5881e+00_r8,3.7639e+00_r8,2.6177e+00_r8,1.3737e+00_r8,1.3601e-02_r8/)
      kbo(:, 5,42,10) = (/ &
     &6.2370e+00_r8,5.0967e+00_r8,3.5534e+00_r8,1.8654e+00_r8,1.7039e-02_r8/)
      kbo(:, 1,43,10) = (/ &
     &1.3404e+00_r8,1.1058e+00_r8,7.6461e-01_r8,4.0031e-01_r8,4.4847e-03_r8/)
      kbo(:, 2,43,10) = (/ &
     &1.9669e+00_r8,1.6173e+00_r8,1.1194e+00_r8,5.8704e-01_r8,6.2717e-03_r8/)
      kbo(:, 3,43,10) = (/ &
     &2.8361e+00_r8,2.3337e+00_r8,1.6185e+00_r8,8.4949e-01_r8,8.5308e-03_r8/)
      kbo(:, 4,43,10) = (/ &
     &4.0094e+00_r8,3.2948e+00_r8,2.2900e+00_r8,1.2020e+00_r8,1.1259e-02_r8/)
      kbo(:, 5,43,10) = (/ &
     &5.5262e+00_r8,4.5280e+00_r8,3.1542e+00_r8,1.6556e+00_r8,1.4384e-02_r8/)
      kbo(:, 1,44,10) = (/ &
     &1.1066e+00_r8,9.1547e-01_r8,6.3275e-01_r8,3.3150e-01_r8,3.4897e-03_r8/)
      kbo(:, 2,44,10) = (/ &
     &1.6542e+00_r8,1.3635e+00_r8,9.4399e-01_r8,4.9494e-01_r8,4.9430e-03_r8/)
      kbo(:, 3,44,10) = (/ &
     &2.4266e+00_r8,2.0020e+00_r8,1.3887e+00_r8,7.2847e-01_r8,6.8682e-03_r8/)
      kbo(:, 4,44,10) = (/ &
     &3.4886e+00_r8,2.8708e+00_r8,1.9931e+00_r8,1.0459e+00_r8,9.1381e-03_r8/)
      kbo(:, 5,44,10) = (/ &
     &4.8773e+00_r8,4.0046e+00_r8,2.7873e+00_r8,1.4630e+00_r8,1.1960e-02_r8/)
      kbo(:, 1,45,10) = (/ &
     &9.0739e-01_r8,7.5424e-01_r8,5.2128e-01_r8,2.7273e-01_r8,2.7098e-03_r8/)
      kbo(:, 2,45,10) = (/ &
     &1.3852e+00_r8,1.1467e+00_r8,7.9304e-01_r8,4.1578e-01_r8,3.8548e-03_r8/)
      kbo(:, 3,45,10) = (/ &
     &2.0713e+00_r8,1.7151e+00_r8,1.1892e+00_r8,6.2426e-01_r8,5.4604e-03_r8/)
      kbo(:, 4,45,10) = (/ &
     &3.0326e+00_r8,2.5006e+00_r8,1.7345e+00_r8,9.0988e-01_r8,7.3887e-03_r8/)
      kbo(:, 5,45,10) = (/ &
     &4.3008e+00_r8,3.5387e+00_r8,2.4612e+00_r8,1.2914e+00_r8,9.7321e-03_r8/)
      kbo(:, 1,46,10) = (/ &
     &7.3199e-01_r8,6.1145e-01_r8,4.2240e-01_r8,2.2117e-01_r8,2.0785e-03_r8/)
      kbo(:, 2,46,10) = (/ &
     &1.1438e+00_r8,9.5098e-01_r8,6.5833e-01_r8,3.4471e-01_r8,2.9805e-03_r8/)
      kbo(:, 3,46,10) = (/ &
     &1.7481e+00_r8,1.4525e+00_r8,1.0068e+00_r8,5.2845e-01_r8,4.2717e-03_r8/)
      kbo(:, 4,46,10) = (/ &
     &2.6098e+00_r8,2.1582e+00_r8,1.4963e+00_r8,7.8501e-01_r8,5.8631e-03_r8/)
      kbo(:, 5,46,10) = (/ &
     &3.7663e+00_r8,3.1031e+00_r8,2.1564e+00_r8,1.1312e+00_r8,7.7831e-03_r8/)
      kbo(:, 1,47,10) = (/ &
     &5.7232e-01_r8,4.8032e-01_r8,3.3210e-01_r8,1.7403e-01_r8,1.5461e-03_r8/)
      kbo(:, 2,47,10) = (/ &
     &9.2386e-01_r8,7.7116e-01_r8,5.3364e-01_r8,2.7934e-01_r8,2.3209e-03_r8/)
      kbo(:, 3,47,10) = (/ &
     &1.4429e+00_r8,1.2024e+00_r8,8.3406e-01_r8,4.3757e-01_r8,3.2763e-03_r8/)
      kbo(:, 4,47,10) = (/ &
     &2.2047e+00_r8,1.8273e+00_r8,1.2675e+00_r8,6.6495e-01_r8,4.5628e-03_r8/)
      kbo(:, 5,47,10) = (/ &
     &3.2456e+00_r8,2.6812e+00_r8,1.8614e+00_r8,9.7623e-01_r8,6.1070e-03_r8/)
      kbo(:, 1,48,10) = (/ &
     &4.4270e-01_r8,3.7313e-01_r8,2.5809e-01_r8,1.3535e-01_r8,1.1374e-03_r8/)
      kbo(:, 2,48,10) = (/ &
     &7.3749e-01_r8,6.1935e-01_r8,4.2906e-01_r8,2.2453e-01_r8,1.7379e-03_r8/)
      kbo(:, 3,48,10) = (/ &
     &1.1839e+00_r8,9.8928e-01_r8,6.8613e-01_r8,3.6002e-01_r8,2.5032e-03_r8/)
      kbo(:, 4,48,10) = (/ &
     &1.8512e+00_r8,1.5395e+00_r8,1.0677e+00_r8,5.6075e-01_r8,3.5238e-03_r8/)
      kbo(:, 5,48,10) = (/ &
     &2.7862e+00_r8,2.3065e+00_r8,1.6009e+00_r8,8.3981e-01_r8,4.7398e-03_r8/)
      kbo(:, 1,49,10) = (/ &
     &3.3829e-01_r8,2.8482e-01_r8,1.9699e-01_r8,1.0339e-01_r8,8.1861e-04_r8/)
      kbo(:, 2,49,10) = (/ &
     &5.8200e-01_r8,4.9068e-01_r8,3.4013e-01_r8,1.7816e-01_r8,1.2634e-03_r8/)
      kbo(:, 3,49,10) = (/ &
     &9.6365e-01_r8,8.0857e-01_r8,5.6081e-01_r8,2.9418e-01_r8,1.8795e-03_r8/)
      kbo(:, 4,49,10) = (/ &
     &1.5457e+00_r8,1.2894e+00_r8,8.9458e-01_r8,4.6973e-01_r8,2.7104e-03_r8/)
      kbo(:, 5,49,10) = (/ &
     &2.3812e+00_r8,1.9755e+00_r8,1.3708e+00_r8,7.1925e-01_r8,3.6105e-03_r8/)
      kbo(:, 1,50,10) = (/ &
     &2.5998e-01_r8,2.1962e-01_r8,1.5188e-01_r8,7.9506e-02_r8,6.0363e-04_r8/)
      kbo(:, 2,50,10) = (/ &
     &4.5974e-01_r8,3.8940e-01_r8,2.6982e-01_r8,1.4155e-01_r8,9.5023e-04_r8/)
      kbo(:, 3,50,10) = (/ &
     &7.8578e-01_r8,6.6189e-01_r8,4.5931e-01_r8,2.4091e-01_r8,1.4366e-03_r8/)
      kbo(:, 4,50,10) = (/ &
     &1.2930e+00_r8,1.0829e+00_r8,7.5147e-01_r8,3.9450e-01_r8,2.1250e-03_r8/)
      kbo(:, 5,50,10) = (/ &
     &2.0418e+00_r8,1.6990e+00_r8,1.1790e+00_r8,6.1880e-01_r8,2.8716e-03_r8/)
      kbo(:, 1,51,10) = (/ &
     &2.0132e-01_r8,1.6910e-01_r8,1.1674e-01_r8,6.1107e-02_r8,4.4485e-04_r8/)
      kbo(:, 2,51,10) = (/ &
     &3.6041e-01_r8,3.0656e-01_r8,2.1282e-01_r8,1.1161e-01_r8,7.3157e-04_r8/)
      kbo(:, 3,51,10) = (/ &
     &6.3582e-01_r8,5.3869e-01_r8,3.7423e-01_r8,1.9656e-01_r8,1.1225e-03_r8/)
      kbo(:, 4,51,10) = (/ &
     &1.0802e+00_r8,9.0777e-01_r8,6.3030e-01_r8,3.3074e-01_r8,1.6531e-03_r8/)
      kbo(:, 5,51,10) = (/ &
     &1.7498e+00_r8,1.4602e+00_r8,1.0135e+00_r8,5.3219e-01_r8,2.3172e-03_r8/)
      kbo(:, 1,52,10) = (/ &
     &1.5547e-01_r8,1.3052e-01_r8,9.0061e-02_r8,4.7075e-02_r8,3.3160e-04_r8/)
      kbo(:, 2,52,10) = (/ &
     &2.8347e-01_r8,2.4049e-01_r8,1.6666e-01_r8,8.7433e-02_r8,5.5078e-04_r8/)
      kbo(:, 3,52,10) = (/ &
     &5.1184e-01_r8,4.3501e-01_r8,3.0211e-01_r8,1.5868e-01_r8,8.7008e-04_r8/)
      kbo(:, 4,52,10) = (/ &
     &8.9697e-01_r8,7.5690e-01_r8,5.2561e-01_r8,2.7576e-01_r8,1.2672e-03_r8/)
      kbo(:, 5,52,10) = (/ &
     &1.4927e+00_r8,1.2493e+00_r8,8.6741e-01_r8,4.5551e-01_r8,1.8458e-03_r8/)
      kbo(:, 1,53,10) = (/ &
     &1.2003e-01_r8,1.0051e-01_r8,6.9268e-02_r8,3.6248e-02_r8,2.4457e-04_r8/)
      kbo(:, 2,53,10) = (/ &
     &2.2120e-01_r8,1.8754e-01_r8,1.2989e-01_r8,6.8226e-02_r8,4.0791e-04_r8/)
      kbo(:, 3,53,10) = (/ &
     &4.0694e-01_r8,3.4775e-01_r8,2.4176e-01_r8,1.2712e-01_r8,6.5057e-04_r8/)
      kbo(:, 4,53,10) = (/ &
     &7.3824e-01_r8,6.2670e-01_r8,4.3556e-01_r8,2.2862e-01_r8,9.8738e-04_r8/)
      kbo(:, 5,53,10) = (/ &
     &1.2666e+00_r8,1.0632e+00_r8,7.3852e-01_r8,3.8765e-01_r8,1.4077e-03_r8/)
      kbo(:, 1,54,10) = (/ &
     &9.3960e-02_r8,7.8771e-02_r8,5.4240e-02_r8,2.8401e-02_r8,1.9316e-04_r8/)
      kbo(:, 2,54,10) = (/ &
     &1.7676e-01_r8,1.4984e-01_r8,1.0336e-01_r8,5.4121e-02_r8,3.1568e-04_r8/)
      kbo(:, 3,54,10) = (/ &
     &3.2867e-01_r8,2.7969e-01_r8,1.9447e-01_r8,1.0231e-01_r8,5.2512e-04_r8/)
      kbo(:, 4,54,10) = (/ &
     &6.0965e-01_r8,5.1980e-01_r8,3.6169e-01_r8,1.9003e-01_r8,8.0976e-04_r8/)
      kbo(:, 5,54,10) = (/ &
     &1.0822e+00_r8,9.1223e-01_r8,6.3374e-01_r8,3.3269e-01_r8,1.1750e-03_r8/)
      kbo(:, 1,55,10) = (/ &
     &7.3906e-02_r8,6.2107e-02_r8,4.2864e-02_r8,2.2445e-02_r8,1.5599e-04_r8/)
      kbo(:, 2,55,10) = (/ &
     &1.4369e-01_r8,1.2050e-01_r8,8.3134e-02_r8,4.3567e-02_r8,2.5335e-04_r8/)
      kbo(:, 3,55,10) = (/ &
     &2.6760e-01_r8,2.2827e-01_r8,1.5835e-01_r8,8.3096e-02_r8,4.2909e-04_r8/)
      kbo(:, 4,55,10) = (/ &
     &5.0351e-01_r8,4.3105e-01_r8,3.0006e-01_r8,1.5782e-01_r8,6.9202e-04_r8/)
      kbo(:, 5,55,10) = (/ &
     &9.2458e-01_r8,7.8288e-01_r8,5.4396e-01_r8,2.8582e-01_r8,1.0207e-03_r8/)
      kbo(:, 1,56,10) = (/ &
     &5.7777e-02_r8,4.8496e-02_r8,3.3489e-02_r8,1.7579e-02_r8,1.2442e-04_r8/)
      kbo(:, 2,56,10) = (/ &
     &1.1665e-01_r8,9.7805e-02_r8,6.7433e-02_r8,3.5342e-02_r8,2.0689e-04_r8/)
      kbo(:, 3,56,10) = (/ &
     &2.1880e-01_r8,1.8636e-01_r8,1.2905e-01_r8,6.7804e-02_r8,3.5149e-04_r8/)
      kbo(:, 4,56,10) = (/ &
     &4.1579e-01_r8,3.5633e-01_r8,2.4779e-01_r8,1.3043e-01_r8,5.7437e-04_r8/)
      kbo(:, 5,56,10) = (/ &
     &7.8392e-01_r8,6.6810e-01_r8,4.6498e-01_r8,2.4434e-01_r8,8.7392e-04_r8/)
      kbo(:, 1,57,10) = (/ &
     &4.4962e-02_r8,3.7745e-02_r8,2.6020e-02_r8,1.3669e-02_r8,1.0074e-04_r8/)
      kbo(:, 2,57,10) = (/ &
     &9.3975e-02_r8,7.9039e-02_r8,5.4468e-02_r8,2.8583e-02_r8,1.6888e-04_r8/)
      kbo(:, 3,57,10) = (/ &
     &1.8083e-01_r8,1.5305e-01_r8,1.0598e-01_r8,5.5519e-02_r8,2.8180e-04_r8/)
      kbo(:, 4,57,10) = (/ &
     &3.4541e-01_r8,2.9431e-01_r8,2.0476e-01_r8,1.0780e-01_r8,4.7931e-04_r8/)
      kbo(:, 5,57,10) = (/ &
     &6.6212e-01_r8,5.6589e-01_r8,3.9390e-01_r8,2.0726e-01_r8,7.5979e-04_r8/)
      kbo(:, 1,58,10) = (/ &
     &1.7062e-02_r8,1.6422e-02_r8,1.3301e-02_r8,8.4676e-03_r8,8.2142e-05_r8/)
      kbo(:, 2,58,10) = (/ &
     &3.7044e-02_r8,3.5791e-02_r8,2.8933e-02_r8,1.8344e-02_r8,1.3979e-04_r8/)
      kbo(:, 3,58,10) = (/ &
     &7.3627e-02_r8,7.1176e-02_r8,5.7648e-02_r8,3.6534e-02_r8,2.3072e-04_r8/)
      kbo(:, 4,58,10) = (/ &
     &1.4036e-01_r8,1.3776e-01_r8,1.1219e-01_r8,7.1459e-02_r8,4.0521e-04_r8/)
      kbo(:, 5,58,10) = (/ &
     &2.7375e-01_r8,2.6857e-01_r8,2.1925e-01_r8,1.3965e-01_r8,6.6868e-04_r8/)
      kbo(:, 1,59,10) = (/ &
     &1.5026e-02_r8,1.4620e-02_r8,1.1891e-02_r8,7.6139e-03_r8,7.7772e-05_r8/)
      kbo(:, 2,59,10) = (/ &
     &3.3598e-02_r8,3.2618e-02_r8,2.6475e-02_r8,1.6873e-02_r8,1.3363e-04_r8/)
      kbo(:, 3,59,10) = (/ &
     &6.7778e-02_r8,6.5724e-02_r8,5.3548e-02_r8,3.4085e-02_r8,2.3127e-04_r8/)
      kbo(:, 4,59,10) = (/ &
     &1.2973e-01_r8,1.2749e-01_r8,1.0439e-01_r8,6.6705e-02_r8,3.9949e-04_r8/)
      kbo(:, 5,59,10) = (/ &
     &2.5383e-01_r8,2.5006e-01_r8,2.0520e-01_r8,1.3156e-01_r8,6.6551e-04_r8/)
      kbo(:, 1,13,11) = (/ &
     &6.1162e+01_r8,4.5871e+01_r8,3.0581e+01_r8,1.5291e+01_r8,3.0501e-01_r8/)
      kbo(:, 2,13,11) = (/ &
     &8.6643e+01_r8,6.4984e+01_r8,4.3324e+01_r8,2.1662e+01_r8,3.8069e-01_r8/)
      kbo(:, 3,13,11) = (/ &
     &1.1700e+02_r8,8.7751e+01_r8,5.8502e+01_r8,2.9250e+01_r8,4.9491e-01_r8/)
      kbo(:, 4,13,11) = (/ &
     &1.5190e+02_r8,1.1392e+02_r8,7.5955e+01_r8,3.7977e+01_r8,5.7908e-01_r8/)
      kbo(:, 5,13,11) = (/ &
     &1.9085e+02_r8,1.4314e+02_r8,9.5429e+01_r8,4.7715e+01_r8,6.6979e-01_r8/)
      kbo(:, 1,14,11) = (/ &
     &6.2014e+01_r8,4.6511e+01_r8,3.1007e+01_r8,1.5504e+01_r8,3.5592e-01_r8/)
      kbo(:, 2,14,11) = (/ &
     &8.7238e+01_r8,6.5431e+01_r8,4.3621e+01_r8,2.1811e+01_r8,3.9219e-01_r8/)
      kbo(:, 3,14,11) = (/ &
     &1.1714e+02_r8,8.7851e+01_r8,5.8570e+01_r8,2.9287e+01_r8,4.4292e-01_r8/)
      kbo(:, 4,14,11) = (/ &
     &1.5139e+02_r8,1.1354e+02_r8,7.5699e+01_r8,3.7864e+01_r8,5.2460e-01_r8/)
      kbo(:, 5,14,11) = (/ &
     &1.8982e+02_r8,1.4235e+02_r8,9.4908e+01_r8,4.7484e+01_r8,6.6257e-01_r8/)
      kbo(:, 1,15,11) = (/ &
     &5.9186e+01_r8,4.4388e+01_r8,2.9592e+01_r8,1.4841e+01_r8,3.2021e-01_r8/)
      kbo(:, 2,15,11) = (/ &
     &8.2638e+01_r8,6.1979e+01_r8,4.1319e+01_r8,2.0713e+01_r8,3.7708e-01_r8/)
      kbo(:, 3,15,11) = (/ &
     &1.1028e+02_r8,8.2716e+01_r8,5.5144e+01_r8,2.7652e+01_r8,4.6488e-01_r8/)
      kbo(:, 4,15,11) = (/ &
     &1.4201e+02_r8,1.0651e+02_r8,7.1008e+01_r8,3.5635e+01_r8,5.3643e-01_r8/)
      kbo(:, 5,15,11) = (/ &
     &1.7780e+02_r8,1.3336e+02_r8,8.8908e+01_r8,4.4680e+01_r8,6.1809e-01_r8/)
      kbo(:, 1,16,11) = (/ &
     &5.3877e+01_r8,4.0407e+01_r8,2.6940e+01_r8,1.3617e+01_r8,3.0459e-01_r8/)
      kbo(:, 2,16,11) = (/ &
     &7.4732e+01_r8,5.6052e+01_r8,3.7368e+01_r8,1.8895e+01_r8,3.6381e-01_r8/)
      kbo(:, 3,16,11) = (/ &
     &9.9303e+01_r8,7.4473e+01_r8,4.9649e+01_r8,2.5124e+01_r8,4.2325e-01_r8/)
      kbo(:, 4,16,11) = (/ &
     &1.2768e+02_r8,9.5754e+01_r8,6.3837e+01_r8,3.2325e+01_r8,4.7285e-01_r8/)
      kbo(:, 5,16,11) = (/ &
     &1.5927e+02_r8,1.1945e+02_r8,7.9632e+01_r8,4.0351e+01_r8,5.0976e-01_r8/)
      kbo(:, 1,17,11) = (/ &
     &4.7648e+01_r8,3.5735e+01_r8,2.3823e+01_r8,1.2164e+01_r8,2.5744e-01_r8/)
      kbo(:, 2,17,11) = (/ &
     &6.5724e+01_r8,4.9293e+01_r8,3.2863e+01_r8,1.6792e+01_r8,3.1059e-01_r8/)
      kbo(:, 3,17,11) = (/ &
     &8.7138e+01_r8,6.5349e+01_r8,4.3569e+01_r8,2.2270e+01_r8,3.5847e-01_r8/)
      kbo(:, 4,17,11) = (/ &
     &1.1169e+02_r8,8.3769e+01_r8,5.5845e+01_r8,2.8543e+01_r8,4.0184e-01_r8/)
      kbo(:, 5,17,11) = (/ &
     &1.3846e+02_r8,1.0385e+02_r8,6.9237e+01_r8,3.5386e+01_r8,4.6254e-01_r8/)
      kbo(:, 1,18,11) = (/ &
     &4.0731e+01_r8,3.0550e+01_r8,2.0398e+01_r8,1.0482e+01_r8,2.2929e-01_r8/)
      kbo(:, 2,18,11) = (/ &
     &5.6038e+01_r8,4.2027e+01_r8,2.8058e+01_r8,1.4421e+01_r8,2.6841e-01_r8/)
      kbo(:, 3,18,11) = (/ &
     &7.4130e+01_r8,5.5602e+01_r8,3.7127e+01_r8,1.9095e+01_r8,3.0083e-01_r8/)
      kbo(:, 4,18,11) = (/ &
     &9.4414e+01_r8,7.0811e+01_r8,4.7323e+01_r8,2.4371e+01_r8,3.4142e-01_r8/)
      kbo(:, 5,18,11) = (/ &
     &1.1687e+02_r8,8.7655e+01_r8,5.8604e+01_r8,3.0228e+01_r8,3.9932e-01_r8/)
      kbo(:, 1,19,11) = (/ &
     &3.5043e+01_r8,2.6281e+01_r8,1.7645e+01_r8,9.0880e+00_r8,1.9041e-01_r8/)
      kbo(:, 2,19,11) = (/ &
     &4.8095e+01_r8,3.6072e+01_r8,2.4224e+01_r8,1.2500e+01_r8,2.2005e-01_r8/)
      kbo(:, 3,19,11) = (/ &
     &6.3280e+01_r8,4.7465e+01_r8,3.1884e+01_r8,1.6505e+01_r8,2.5190e-01_r8/)
      kbo(:, 4,19,11) = (/ &
     &8.0459e+01_r8,6.0352e+01_r8,4.0562e+01_r8,2.1050e+01_r8,3.0347e-01_r8/)
      kbo(:, 5,19,11) = (/ &
     &9.9405e+01_r8,7.4555e+01_r8,5.0141e+01_r8,2.6072e+01_r8,3.3814e-01_r8/)
      kbo(:, 1,20,11) = (/ &
     &3.0698e+01_r8,2.3028e+01_r8,1.5559e+01_r8,8.0744e+00_r8,1.6851e-01_r8/)
      kbo(:, 2,20,11) = (/ &
     &4.1938e+01_r8,3.1449e+01_r8,2.1266e+01_r8,1.1075e+01_r8,1.9604e-01_r8/)
      kbo(:, 3,20,11) = (/ &
     &5.4971e+01_r8,4.1226e+01_r8,2.7873e+01_r8,1.4553e+01_r8,2.3334e-01_r8/)
      kbo(:, 4,20,11) = (/ &
     &6.9683e+01_r8,5.2264e+01_r8,3.5322e+01_r8,1.8474e+01_r8,2.8155e-01_r8/)
      kbo(:, 5,20,11) = (/ &
     &8.5796e+01_r8,6.4350e+01_r8,4.3496e+01_r8,2.2781e+01_r8,3.1819e-01_r8/)
      kbo(:, 1,21,11) = (/ &
     &2.6961e+01_r8,2.0239e+01_r8,1.3721e+01_r8,7.2357e+00_r8,1.5633e-01_r8/)
      kbo(:, 2,21,11) = (/ &
     &3.6624e+01_r8,2.7486e+01_r8,1.8642e+01_r8,9.8382e+00_r8,1.8477e-01_r8/)
      kbo(:, 3,21,11) = (/ &
     &4.7842e+01_r8,3.5913e+01_r8,2.4362e+01_r8,1.2852e+01_r8,2.2793e-01_r8/)
      kbo(:, 4,21,11) = (/ &
     &6.0403e+01_r8,4.5355e+01_r8,3.0794e+01_r8,1.6247e+01_r8,2.5875e-01_r8/)
      kbo(:, 5,21,11) = (/ &
     &7.4328e+01_r8,5.5827e+01_r8,3.7921e+01_r8,1.9978e+01_r8,3.0003e-01_r8/)
      kbo(:, 1,22,11) = (/ &
     &2.4106e+01_r8,1.8145e+01_r8,1.2318e+01_r8,6.5788e+00_r8,1.4346e-01_r8/)
      kbo(:, 2,22,11) = (/ &
     &3.2489e+01_r8,2.4455e+01_r8,1.6620e+01_r8,8.8645e+00_r8,1.7673e-01_r8/)
      kbo(:, 3,22,11) = (/ &
     &4.2111e+01_r8,3.1704e+01_r8,2.1585e+01_r8,1.1502e+01_r8,2.1135e-01_r8/)
      kbo(:, 4,22,11) = (/ &
     &5.3091e+01_r8,3.9979e+01_r8,2.7248e+01_r8,1.4479e+01_r8,2.4545e-01_r8/)
      kbo(:, 5,22,11) = (/ &
     &6.5531e+01_r8,4.9344e+01_r8,3.3661e+01_r8,1.7840e+01_r8,2.8184e-01_r8/)
      kbo(:, 1,23,11) = (/ &
     &2.1586e+01_r8,1.6314e+01_r8,1.1115e+01_r8,5.9696e+00_r8,1.3118e-01_r8/)
      kbo(:, 2,23,11) = (/ &
     &2.8872e+01_r8,2.1824e+01_r8,1.4900e+01_r8,7.9884e+00_r8,1.6791e-01_r8/)
      kbo(:, 3,23,11) = (/ &
     &3.7392e+01_r8,2.8256e+01_r8,1.9318e+01_r8,1.0333e+01_r8,1.9239e-01_r8/)
      kbo(:, 4,23,11) = (/ &
     &4.7286e+01_r8,3.5715e+01_r8,2.4417e+01_r8,1.3025e+01_r8,2.2854e-01_r8/)
      kbo(:, 5,23,11) = (/ &
     &5.8587e+01_r8,4.4225e+01_r8,3.0228e+01_r8,1.6103e+01_r8,2.6383e-01_r8/)
      kbo(:, 1,24,11) = (/ &
     &1.9610e+01_r8,1.4859e+01_r8,1.0204e+01_r8,5.4843e+00_r8,1.2305e-01_r8/)
      kbo(:, 2,24,11) = (/ &
     &2.6168e+01_r8,1.9825e+01_r8,1.3617e+01_r8,7.3028e+00_r8,1.4696e-01_r8/)
      kbo(:, 3,24,11) = (/ &
     &3.4009e+01_r8,2.5754e+01_r8,1.7666e+01_r8,9.4475e+00_r8,1.7619e-01_r8/)
      kbo(:, 4,24,11) = (/ &
     &4.3202e+01_r8,3.2697e+01_r8,2.2398e+01_r8,1.1966e+01_r8,2.0711e-01_r8/)
      kbo(:, 5,24,11) = (/ &
     &5.3950e+01_r8,4.0810e+01_r8,2.7914e+01_r8,1.4881e+01_r8,2.4491e-01_r8/)
      kbo(:, 1,25,11) = (/ &
     &1.7913e+01_r8,1.3599e+01_r8,9.4137e+00_r8,5.0616e+00_r8,1.1244e-01_r8/)
      kbo(:, 2,25,11) = (/ &
     &2.4002e+01_r8,1.8218e+01_r8,1.2577e+01_r8,6.7433e+00_r8,1.3574e-01_r8/)
      kbo(:, 3,25,11) = (/ &
     &3.1373e+01_r8,2.3808e+01_r8,1.6390e+01_r8,8.7732e+00_r8,1.6587e-01_r8/)
      kbo(:, 4,25,11) = (/ &
     &4.0212e+01_r8,3.0510e+01_r8,2.0949e+01_r8,1.1182e+01_r8,1.9353e-01_r8/)
      kbo(:, 5,25,11) = (/ &
     &5.0507e+01_r8,3.8314e+01_r8,2.6252e+01_r8,1.3993e+01_r8,2.2689e-01_r8/)
      kbo(:, 1,26,11) = (/ &
     &1.6610e+01_r8,1.2648e+01_r8,8.7899e+00_r8,4.7180e+00_r8,1.0410e-01_r8/)
      kbo(:, 2,26,11) = (/ &
     &2.2395e+01_r8,1.7048e+01_r8,1.1804e+01_r8,6.3257e+00_r8,1.2812e-01_r8/)
      kbo(:, 3,26,11) = (/ &
     &2.9495e+01_r8,2.2453e+01_r8,1.5498e+01_r8,8.2851e+00_r8,1.5321e-01_r8/)
      kbo(:, 4,26,11) = (/ &
     &3.7868e+01_r8,2.8829e+01_r8,1.9854e+01_r8,1.0593e+01_r8,1.8381e-01_r8/)
      kbo(:, 5,26,11) = (/ &
     &4.7321e+01_r8,3.6030e+01_r8,2.4795e+01_r8,1.3247e+01_r8,2.1577e-01_r8/)
      kbo(:, 1,27,11) = (/ &
     &1.5552e+01_r8,1.1893e+01_r8,8.2787e+00_r8,4.4401e+00_r8,9.5478e-02_r8/)
      kbo(:, 2,27,11) = (/ &
     &2.1129e+01_r8,1.6157e+01_r8,1.1211e+01_r8,5.9970e+00_r8,1.1930e-01_r8/)
      kbo(:, 3,27,11) = (/ &
     &2.7798e+01_r8,2.1248e+01_r8,1.4714e+01_r8,7.8588e+00_r8,1.4147e-01_r8/)
      kbo(:, 4,27,11) = (/ &
     &3.5437e+01_r8,2.7084e+01_r8,1.8740e+01_r8,1.0024e+01_r8,1.6966e-01_r8/)
      kbo(:, 5,27,11) = (/ &
     &4.4196e+01_r8,3.3778e+01_r8,2.3350e+01_r8,1.2494e+01_r8,2.0142e-01_r8/)
      kbo(:, 1,28,11) = (/ &
     &1.4683e+01_r8,1.1292e+01_r8,7.8718e+00_r8,4.2106e+00_r8,8.7356e-02_r8/)
      kbo(:, 2,28,11) = (/ &
     &1.9886e+01_r8,1.5281e+01_r8,1.0638e+01_r8,5.6861e+00_r8,1.0714e-01_r8/)
      kbo(:, 3,28,11) = (/ &
     &2.5973e+01_r8,1.9937e+01_r8,1.3871e+01_r8,7.4210e+00_r8,1.3061e-01_r8/)
      kbo(:, 4,28,11) = (/ &
     &3.3032e+01_r8,2.5345e+01_r8,1.7630e+01_r8,9.4399e+00_r8,1.5744e-01_r8/)
      kbo(:, 5,28,11) = (/ &
     &4.1210e+01_r8,3.1582e+01_r8,2.1933e+01_r8,1.1759e+01_r8,1.8456e-01_r8/)
      kbo(:, 1,29,11) = (/ &
     &1.3790e+01_r8,1.0662e+01_r8,7.4451e+00_r8,3.9766e+00_r8,7.8021e-02_r8/)
      kbo(:, 2,29,11) = (/ &
     &1.8507e+01_r8,1.4288e+01_r8,9.9758e+00_r8,5.3363e+00_r8,9.5820e-02_r8/)
      kbo(:, 3,29,11) = (/ &
     &2.4091e+01_r8,1.8575e+01_r8,1.2977e+01_r8,6.9398e+00_r8,1.1898e-01_r8/)
      kbo(:, 4,29,11) = (/ &
     &3.0652e+01_r8,2.3593e+01_r8,1.6474e+01_r8,8.8251e+00_r8,1.4373e-01_r8/)
      kbo(:, 5,29,11) = (/ &
     &3.8268e+01_r8,2.9419e+01_r8,2.0534e+01_r8,1.1026e+01_r8,1.6837e-01_r8/)
      kbo(:, 1,30,11) = (/ &
     &1.2835e+01_r8,9.9842e+00_r8,6.9893e+00_r8,3.7286e+00_r8,6.9765e-02_r8/)
      kbo(:, 2,30,11) = (/ &
     &1.7126e+01_r8,1.3305e+01_r8,9.3238e+00_r8,4.9785e+00_r8,8.7990e-02_r8/)
      kbo(:, 3,30,11) = (/ &
     &2.2319e+01_r8,1.7278e+01_r8,1.2100e+01_r8,6.4728e+00_r8,1.0830e-01_r8/)
      kbo(:, 4,30,11) = (/ &
     &2.8412e+01_r8,2.1956e+01_r8,1.5383e+01_r8,8.2493e+00_r8,1.2854e-01_r8/)
      kbo(:, 5,30,11) = (/ &
     &3.5540e+01_r8,2.7422e+01_r8,1.9221e+01_r8,1.0332e+01_r8,1.5041e-01_r8/)
      kbo(:, 1,31,11) = (/ &
     &1.1866e+01_r8,9.2840e+00_r8,6.5153e+00_r8,3.4693e+00_r8,6.2880e-02_r8/)
      kbo(:, 2,31,11) = (/ &
     &1.5808e+01_r8,1.2342e+01_r8,8.6596e+00_r8,4.6193e+00_r8,7.8616e-02_r8/)
      kbo(:, 3,31,11) = (/ &
     &2.0587e+01_r8,1.6022e+01_r8,1.1250e+01_r8,6.0171e+00_r8,9.4908e-02_r8/)
      kbo(:, 4,31,11) = (/ &
     &2.6251e+01_r8,2.0378e+01_r8,1.4318e+01_r8,7.6818e+00_r8,1.1384e-01_r8/)
      kbo(:, 5,31,11) = (/ &
     &3.2893e+01_r8,2.5487e+01_r8,1.7928e+01_r8,9.6467e+00_r8,1.3241e-01_r8/)
      kbo(:, 1,32,11) = (/ &
     &1.1095e+01_r8,8.7224e+00_r8,6.1226e+00_r8,3.2519e+00_r8,5.6839e-02_r8/)
      kbo(:, 2,32,11) = (/ &
     &1.4751e+01_r8,1.1560e+01_r8,8.1226e+00_r8,4.3325e+00_r8,7.0855e-02_r8/)
      kbo(:, 3,32,11) = (/ &
     &1.9205e+01_r8,1.5015e+01_r8,1.0554e+01_r8,5.6424e+00_r8,8.5721e-02_r8/)
      kbo(:, 4,32,11) = (/ &
     &2.4504e+01_r8,1.9119e+01_r8,1.3461e+01_r8,7.2214e+00_r8,1.0137e-01_r8/)
      kbo(:, 5,32,11) = (/ &
     &3.0723e+01_r8,2.3918e+01_r8,1.6887e+01_r8,9.0922e+00_r8,1.2101e-01_r8/)
      kbo(:, 1,33,11) = (/ &
     &1.0469e+01_r8,8.2653e+00_r8,5.8027e+00_r8,3.0803e+00_r8,5.1389e-02_r8/)
      kbo(:, 2,33,11) = (/ &
     &1.3905e+01_r8,1.0963e+01_r8,7.7038e+00_r8,4.0998e+00_r8,6.3408e-02_r8/)
      kbo(:, 3,33,11) = (/ &
     &1.8080e+01_r8,1.4209e+01_r8,9.9969e+00_r8,5.3421e+00_r8,7.7128e-02_r8/)
      kbo(:, 4,33,11) = (/ &
     &2.3055e+01_r8,1.8085e+01_r8,1.2765e+01_r8,6.8504e+00_r8,9.2141e-02_r8/)
      kbo(:, 5,33,11) = (/ &
     &2.8901e+01_r8,2.2629e+01_r8,1.6031e+01_r8,8.6400e+00_r8,1.0949e-01_r8/)
      kbo(:, 1,34,11) = (/ &
     &9.9524e+00_r8,7.8988e+00_r8,5.5437e+00_r8,2.9382e+00_r8,4.7321e-02_r8/)
      kbo(:, 2,34,11) = (/ &
     &1.3224e+01_r8,1.0461e+01_r8,7.3463e+00_r8,3.9087e+00_r8,5.8418e-02_r8/)
      kbo(:, 3,34,11) = (/ &
     &1.7166e+01_r8,1.3560e+01_r8,9.5537e+00_r8,5.1034e+00_r8,7.0181e-02_r8/)
      kbo(:, 4,34,11) = (/ &
     &2.1887e+01_r8,1.7264e+01_r8,1.2211e+01_r8,6.5526e+00_r8,8.4706e-02_r8/)
      kbo(:, 5,34,11) = (/ &
     &2.7487e+01_r8,2.1622e+01_r8,1.5350e+01_r8,8.2698e+00_r8,9.8588e-02_r8/)
      kbo(:, 1,35,11) = (/ &
     &9.2896e+00_r8,7.3988e+00_r8,5.1836e+00_r8,2.7478e+00_r8,4.1417e-02_r8/)
      kbo(:, 2,35,11) = (/ &
     &1.2346e+01_r8,9.8120e+00_r8,6.8895e+00_r8,3.6621e+00_r8,5.1614e-02_r8/)
      kbo(:, 3,35,11) = (/ &
     &1.6038e+01_r8,1.2737e+01_r8,8.9856e+00_r8,4.7992e+00_r8,6.2173e-02_r8/)
      kbo(:, 4,35,11) = (/ &
     &2.0501e+01_r8,1.6246e+01_r8,1.1507e+01_r8,6.1715e+00_r8,7.4346e-02_r8/)
      kbo(:, 5,35,11) = (/ &
     &2.5865e+01_r8,2.0429e+01_r8,1.4515e+01_r8,7.8139e+00_r8,8.6989e-02_r8/)
      kbo(:, 1,36,11) = (/ &
     &8.4641e+00_r8,6.7680e+00_r8,4.7384e+00_r8,2.5089e+00_r8,3.5370e-02_r8/)
      kbo(:, 2,36,11) = (/ &
     &1.1283e+01_r8,9.0077e+00_r8,6.3272e+00_r8,3.3586e+00_r8,4.3427e-02_r8/)
      kbo(:, 3,36,11) = (/ &
     &1.4709e+01_r8,1.1740e+01_r8,8.2852e+00_r8,4.4192e+00_r8,5.3699e-02_r8/)
      kbo(:, 4,36,11) = (/ &
     &1.8892e+01_r8,1.5035e+01_r8,1.0652e+01_r8,5.7082e+00_r8,6.4287e-02_r8/)
      kbo(:, 5,36,11) = (/ &
     &2.3976e+01_r8,1.9028e+01_r8,1.3526e+01_r8,7.2706e+00_r8,7.5870e-02_r8/)
      kbo(:, 1,37,11) = (/ &
     &7.4506e+00_r8,5.9897e+00_r8,4.1905e+00_r8,2.2153e+00_r8,2.9963e-02_r8/)
      kbo(:, 2,37,11) = (/ &
     &1.0029e+01_r8,8.0389e+00_r8,5.6426e+00_r8,2.9898e+00_r8,3.7220e-02_r8/)
      kbo(:, 3,37,11) = (/ &
     &1.3144e+01_r8,1.0534e+01_r8,7.4309e+00_r8,3.9559e+00_r8,4.6416e-02_r8/)
      kbo(:, 4,37,11) = (/ &
     &1.6999e+01_r8,1.3585e+01_r8,9.6217e+00_r8,5.1490e+00_r8,5.5486e-02_r8/)
      kbo(:, 5,37,11) = (/ &
     &2.1741e+01_r8,1.7327e+01_r8,1.2322e+01_r8,6.6152e+00_r8,6.5816e-02_r8/)
      kbo(:, 1,38,11) = (/ &
     &6.5566e+00_r8,5.3014e+00_r8,3.7057e+00_r8,1.9579e+00_r8,2.5356e-02_r8/)
      kbo(:, 2,38,11) = (/ &
     &8.9151e+00_r8,7.1841e+00_r8,5.0400e+00_r8,2.6656e+00_r8,3.1891e-02_r8/)
      kbo(:, 3,38,11) = (/ &
     &1.1778e+01_r8,9.4689e+00_r8,6.6768e+00_r8,3.5488e+00_r8,3.9709e-02_r8/)
      kbo(:, 4,38,11) = (/ &
     &1.5333e+01_r8,1.2304e+01_r8,8.7122e+00_r8,4.6542e+00_r8,4.7360e-02_r8/)
      kbo(:, 5,38,11) = (/ &
     &1.9762e+01_r8,1.5812e+01_r8,1.1244e+01_r8,6.0319e+00_r8,5.6650e-02_r8/)
      kbo(:, 1,39,11) = (/ &
     &5.7815e+00_r8,4.6987e+00_r8,3.2839e+00_r8,1.7336e+00_r8,2.1361e-02_r8/)
      kbo(:, 2,39,11) = (/ &
     &7.9403e+00_r8,6.4302e+00_r8,4.5109e+00_r8,2.3848e+00_r8,2.6909e-02_r8/)
      kbo(:, 3,39,11) = (/ &
     &1.0589e+01_r8,8.5486e+00_r8,6.0232e+00_r8,3.1966e+00_r8,3.3274e-02_r8/)
      kbo(:, 4,39,11) = (/ &
     &1.3890e+01_r8,1.1188e+01_r8,7.9191e+00_r8,4.2244e+00_r8,4.0390e-02_r8/)
      kbo(:, 5,39,11) = (/ &
     &1.8032e+01_r8,1.4487e+01_r8,1.0297e+01_r8,5.5201e+00_r8,4.8824e-02_r8/)
      kbo(:, 1,40,11) = (/ &
     &4.9663e+00_r8,4.0580e+00_r8,2.8368e+00_r8,1.4961e+00_r8,1.7977e-02_r8/)
      kbo(:, 2,40,11) = (/ &
     &6.9269e+00_r8,5.6391e+00_r8,3.9540e+00_r8,2.0894e+00_r8,2.2949e-02_r8/)
      kbo(:, 3,40,11) = (/ &
     &9.3578e+00_r8,7.5891e+00_r8,5.3452e+00_r8,2.8327e+00_r8,2.8350e-02_r8/)
      kbo(:, 4,40,11) = (/ &
     &1.2407e+01_r8,1.0028e+01_r8,7.0894e+00_r8,3.7744e+00_r8,3.4399e-02_r8/)
      kbo(:, 5,40,11) = (/ &
     &1.6240e+01_r8,1.3091e+01_r8,9.2991e+00_r8,4.9787e+00_r8,4.2027e-02_r8/)
      kbo(:, 1,41,11) = (/ &
     &4.2485e+00_r8,3.4862e+00_r8,2.4352e+00_r8,1.2849e+00_r8,1.5088e-02_r8/)
      kbo(:, 2,41,11) = (/ &
     &6.0166e+00_r8,4.9271e+00_r8,3.4537e+00_r8,1.8243e+00_r8,1.9453e-02_r8/)
      kbo(:, 3,41,11) = (/ &
     &8.2485e+00_r8,6.7221e+00_r8,4.7321e+00_r8,2.5060e+00_r8,2.4198e-02_r8/)
      kbo(:, 4,41,11) = (/ &
     &1.1066e+01_r8,8.9791e+00_r8,6.3459e+00_r8,3.3734e+00_r8,2.9570e-02_r8/)
      kbo(:, 5,41,11) = (/ &
     &1.4636e+01_r8,1.1834e+01_r8,8.3996e+00_r8,4.4886e+00_r8,3.6128e-02_r8/)
      kbo(:, 1,42,11) = (/ &
     &3.6346e+00_r8,2.9948e+00_r8,2.0896e+00_r8,1.1018e+00_r8,1.2599e-02_r8/)
      kbo(:, 2,42,11) = (/ &
     &5.2244e+00_r8,4.2974e+00_r8,3.0116e+00_r8,1.5911e+00_r8,1.6323e-02_r8/)
      kbo(:, 3,42,11) = (/ &
     &7.2643e+00_r8,5.9499e+00_r8,4.1877e+00_r8,2.2172e+00_r8,2.0619e-02_r8/)
      kbo(:, 4,42,11) = (/ &
     &9.8747e+00_r8,8.0447e+00_r8,5.6854e+00_r8,3.0206e+00_r8,2.5282e-02_r8/)
      kbo(:, 5,42,11) = (/ &
     &1.3206e+01_r8,1.0716e+01_r8,7.6001e+00_r8,4.0544e+00_r8,3.0876e-02_r8/)
      kbo(:, 1,43,11) = (/ &
     &3.0660e+00_r8,2.5370e+00_r8,1.7687e+00_r8,9.3216e-01_r8,1.0308e-02_r8/)
      kbo(:, 2,43,11) = (/ &
     &4.4856e+00_r8,3.7056e+00_r8,2.5945e+00_r8,1.3700e+00_r8,1.3601e-02_r8/)
      kbo(:, 3,43,11) = (/ &
     &6.3372e+00_r8,5.2140e+00_r8,3.6676e+00_r8,1.9419e+00_r8,1.7306e-02_r8/)
      kbo(:, 4,43,11) = (/ &
     &8.7409e+00_r8,7.1536e+00_r8,5.0545e+00_r8,2.6839e+00_r8,2.1526e-02_r8/)
      kbo(:, 5,43,11) = (/ &
     &1.1846e+01_r8,9.6432e+00_r8,6.8374e+00_r8,3.6437e+00_r8,2.6238e-02_r8/)
      kbo(:, 1,44,11) = (/ &
     &2.5664e+00_r8,2.1306e+00_r8,1.4853e+00_r8,7.8185e-01_r8,8.3390e-03_r8/)
      kbo(:, 2,44,11) = (/ &
     &3.8265e+00_r8,3.1748e+00_r8,2.2204e+00_r8,1.1717e+00_r8,1.1111e-02_r8/)
      kbo(:, 3,44,11) = (/ &
     &5.5006e+00_r8,4.5418e+00_r8,3.1915e+00_r8,1.6892e+00_r8,1.4312e-02_r8/)
      kbo(:, 4,44,11) = (/ &
     &7.6990e+00_r8,6.3295e+00_r8,4.4707e+00_r8,2.3728e+00_r8,1.8022e-02_r8/)
      kbo(:, 5,44,11) = (/ &
     &1.0590e+01_r8,8.6508e+00_r8,6.1308e+00_r8,3.2656e+00_r8,2.2284e-02_r8/)
      kbo(:, 1,45,11) = (/ &
     &2.1449e+00_r8,1.7852e+00_r8,1.2434e+00_r8,6.5459e-01_r8,6.5374e-03_r8/)
      kbo(:, 2,45,11) = (/ &
     &3.2586e+00_r8,2.7120e+00_r8,1.8962e+00_r8,1.0002e+00_r8,8.9661e-03_r8/)
      kbo(:, 3,45,11) = (/ &
     &4.7677e+00_r8,3.9512e+00_r8,2.7729e+00_r8,1.4668e+00_r8,1.1723e-02_r8/)
      kbo(:, 4,45,11) = (/ &
     &6.7759e+00_r8,5.5907e+00_r8,3.9459e+00_r8,2.0943e+00_r8,1.4893e-02_r8/)
      kbo(:, 5,45,11) = (/ &
     &9.4617e+00_r8,7.7574e+00_r8,5.4954e+00_r8,2.9257e+00_r8,1.8879e-02_r8/)
      kbo(:, 1,46,11) = (/ &
     &1.7693e+00_r8,1.4778e+00_r8,1.0286e+00_r8,5.4110e-01_r8,5.0474e-03_r8/)
      kbo(:, 2,46,11) = (/ &
     &2.7478e+00_r8,2.2930e+00_r8,1.6009e+00_r8,8.4457e-01_r8,7.0726e-03_r8/)
      kbo(:, 3,46,11) = (/ &
     &4.0941e+00_r8,3.4053e+00_r8,2.3875e+00_r8,1.2626e+00_r8,9.5023e-03_r8/)
      kbo(:, 4,46,11) = (/ &
     &5.9189e+00_r8,4.8999e+00_r8,3.4535e+00_r8,1.8324e+00_r8,1.2322e-02_r8/)
      kbo(:, 5,46,11) = (/ &
     &8.3887e+00_r8,6.9026e+00_r8,4.8893e+00_r8,2.6020e+00_r8,1.5617e-02_r8/)
      kbo(:, 1,47,11) = (/ &
     &1.4241e+00_r8,1.1941e+00_r8,8.3002e-01_r8,4.3643e-01_r8,3.7828e-03_r8/)
      kbo(:, 2,47,11) = (/ &
     &2.2698e+00_r8,1.8986e+00_r8,1.3247e+00_r8,6.9822e-01_r8,5.4676e-03_r8/)
      kbo(:, 3,47,11) = (/ &
     &3.4547e+00_r8,2.8836e+00_r8,2.0196e+00_r8,1.0678e+00_r8,7.6213e-03_r8/)
      kbo(:, 4,47,11) = (/ &
     &5.0871e+00_r8,4.2288e+00_r8,2.9766e+00_r8,1.5778e+00_r8,9.9658e-03_r8/)
      kbo(:, 5,47,11) = (/ &
     &7.3321e+00_r8,6.0542e+00_r8,4.2837e+00_r8,2.2790e+00_r8,1.3055e-02_r8/)
      kbo(:, 1,48,11) = (/ &
     &1.1337e+00_r8,9.5606e-01_r8,6.6479e-01_r8,3.4941e-01_r8,2.8319e-03_r8/)
      kbo(:, 2,48,11) = (/ &
     &1.8661e+00_r8,1.5653e+00_r8,1.0902e+00_r8,5.7432e-01_r8,4.1758e-03_r8/)
      kbo(:, 3,48,11) = (/ &
     &2.9045e+00_r8,2.4321e+00_r8,1.7012e+00_r8,8.9870e-01_r8,5.9617e-03_r8/)
      kbo(:, 4,48,11) = (/ &
     &4.3570e+00_r8,3.6357e+00_r8,2.5565e+00_r8,1.3546e+00_r8,7.9840e-03_r8/)
      kbo(:, 5,48,11) = (/ &
     &6.3922e+00_r8,5.2980e+00_r8,3.7432e+00_r8,1.9904e+00_r8,1.0519e-02_r8/)
      kbo(:, 1,49,11) = (/ &
     &8.9211e-01_r8,7.5781e-01_r8,5.2674e-01_r8,2.7699e-01_r8,2.0587e-03_r8/)
      kbo(:, 2,49,11) = (/ &
     &1.5203e+00_r8,1.2812e+00_r8,8.9206e-01_r8,4.6970e-01_r8,3.1077e-03_r8/)
      kbo(:, 3,49,11) = (/ &
     &2.4343e+00_r8,2.0415e+00_r8,1.4265e+00_r8,7.5292e-01_r8,4.5062e-03_r8/)
      kbo(:, 4,49,11) = (/ &
     &3.7205e+00_r8,3.1142e+00_r8,2.1868e+00_r8,1.1585e+00_r8,6.1377e-03_r8/)
      kbo(:, 5,49,11) = (/ &
     &5.5564e+00_r8,4.6243e+00_r8,3.2638e+00_r8,1.7346e+00_r8,8.3879e-03_r8/)
      kbo(:, 1,50,11) = (/ &
     &6.9944e-01_r8,5.9730e-01_r8,4.1544e-01_r8,2.1892e-01_r8,1.5159e-03_r8/)
      kbo(:, 2,50,11) = (/ &
     &1.2386e+00_r8,1.0495e+00_r8,7.3105e-01_r8,3.8493e-01_r8,2.3639e-03_r8/)
      kbo(:, 3,50,11) = (/ &
     &2.0475e+00_r8,1.7233e+00_r8,1.2030e+00_r8,6.3443e-01_r8,3.5129e-03_r8/)
      kbo(:, 4,50,11) = (/ &
     &3.1987e+00_r8,2.6838e+00_r8,1.8828e+00_r8,9.9721e-01_r8,4.9131e-03_r8/)
      kbo(:, 5,50,11) = (/ &
     &4.8613e+00_r8,4.0604e+00_r8,2.8638e+00_r8,1.5216e+00_r8,6.8102e-03_r8/)
      kbo(:, 1,51,11) = (/ &
     &5.4324e-01_r8,4.6725e-01_r8,3.2546e-01_r8,1.7172e-01_r8,1.1297e-03_r8/)
      kbo(:, 2,51,11) = (/ &
     &1.0054e+00_r8,8.5632e-01_r8,5.9623e-01_r8,3.1426e-01_r8,1.7844e-03_r8/)
      kbo(:, 3,51,11) = (/ &
     &1.7180e+00_r8,1.4523e+00_r8,1.0136e+00_r8,5.3456e-01_r8,2.7288e-03_r8/)
      kbo(:, 4,51,11) = (/ &
     &2.7560e+00_r8,2.3178e+00_r8,1.6244e+00_r8,8.6011e-01_r8,3.9147e-03_r8/)
      kbo(:, 5,51,11) = (/ &
     &4.2636e+00_r8,3.5725e+00_r8,2.5176e+00_r8,1.3376e+00_r8,5.4601e-03_r8/)
      kbo(:, 1,52,11) = (/ &
     &4.1659e-01_r8,3.6012e-01_r8,2.5102e-01_r8,1.3270e-01_r8,8.3775e-04_r8/)
      kbo(:, 2,52,11) = (/ &
     &8.0451e-01_r8,6.9074e-01_r8,4.8148e-01_r8,2.5404e-01_r8,1.3424e-03_r8/)
      kbo(:, 3,52,11) = (/ &
     &1.4303e+00_r8,1.2146e+00_r8,8.4783e-01_r8,4.4730e-01_r8,2.0961e-03_r8/)
      kbo(:, 4,52,11) = (/ &
     &2.3661e+00_r8,1.9968e+00_r8,1.3985e+00_r8,7.3984e-01_r8,3.0912e-03_r8/)
      kbo(:, 5,52,11) = (/ &
     &3.7364e+00_r8,3.1393e+00_r8,2.2101e+00_r8,1.1738e+00_r8,4.3230e-03_r8/)
      kbo(:, 1,53,11) = (/ &
     &3.1784e-01_r8,2.7470e-01_r8,1.9112e-01_r8,1.0099e-01_r8,6.0100e-04_r8/)
      kbo(:, 2,53,11) = (/ &
     &6.3733e-01_r8,5.5043e-01_r8,3.8376e-01_r8,2.0263e-01_r8,1.0152e-03_r8/)
      kbo(:, 3,53,11) = (/ &
     &1.1810e+00_r8,1.0077e+00_r8,7.0333e-01_r8,3.7118e-01_r8,1.5799e-03_r8/)
      kbo(:, 4,53,11) = (/ &
     &2.0184e+00_r8,1.7109e+00_r8,1.1985e+00_r8,6.3377e-01_r8,2.3636e-03_r8/)
      kbo(:, 5,53,11) = (/ &
     &3.2693e+00_r8,2.7525e+00_r8,1.9355e+00_r8,1.0278e+00_r8,3.4086e-03_r8/)
      kbo(:, 1,54,11) = (/ &
     &2.4587e-01_r8,2.1298e-01_r8,1.4829e-01_r8,7.8206e-02_r8,4.4874e-04_r8/)
      kbo(:, 2,54,11) = (/ &
     &5.0524e-01_r8,4.3896e-01_r8,3.0674e-01_r8,1.6236e-01_r8,7.8054e-04_r8/)
      kbo(:, 3,54,11) = (/ &
     &9.7870e-01_r8,8.4204e-01_r8,5.8784e-01_r8,3.1052e-01_r8,1.2701e-03_r8/)
      kbo(:, 4,54,11) = (/ &
     &1.7368e+00_r8,1.4787e+00_r8,1.0357e+00_r8,5.4775e-01_r8,1.9340e-03_r8/)
      kbo(:, 5,54,11) = (/ &
     &2.8933e+00_r8,2.4419e+00_r8,1.7163e+00_r8,9.1082e-01_r8,2.8443e-03_r8/)
      kbo(:, 1,55,11) = (/ &
     &1.9418e-01_r8,1.6698e-01_r8,1.1582e-01_r8,6.0924e-02_r8,3.5209e-04_r8/)
      kbo(:, 2,55,11) = (/ &
     &3.9791e-01_r8,3.4892e-01_r8,2.4392e-01_r8,1.2929e-01_r8,6.3188e-04_r8/)
      kbo(:, 3,55,11) = (/ &
     &8.0845e-01_r8,6.9946e-01_r8,4.8912e-01_r8,2.5894e-01_r8,1.0591e-03_r8/)
      kbo(:, 4,55,11) = (/ &
     &1.4970e+00_r8,1.2804e+00_r8,8.9678e-01_r8,4.7424e-01_r8,1.6138e-03_r8/)
      kbo(:, 5,55,11) = (/ &
     &2.5700e+00_r8,2.1774e+00_r8,1.5304e+00_r8,8.1150e-01_r8,2.4277e-03_r8/)
      kbo(:, 1,56,11) = (/ &
     &1.5370e-01_r8,1.3145e-01_r8,9.1321e-02_r8,4.8124e-02_r8,2.7531e-04_r8/)
      kbo(:, 2,56,11) = (/ &
     &3.1616e-01_r8,2.7583e-01_r8,1.9245e-01_r8,1.0171e-01_r8,5.0269e-04_r8/)
      kbo(:, 3,56,11) = (/ &
     &6.6199e-01_r8,5.7649e-01_r8,4.0352e-01_r8,2.1386e-01_r8,8.6775e-04_r8/)
      kbo(:, 4,56,11) = (/ &
     &1.2822e+00_r8,1.1021e+00_r8,7.7256e-01_r8,4.0891e-01_r8,1.3519e-03_r8/)
      kbo(:, 5,56,11) = (/ &
     &2.2783e+00_r8,1.9368e+00_r8,1.3622e+00_r8,7.2221e-01_r8,2.0801e-03_r8/)
      kbo(:, 1,57,11) = (/ &
     &1.2165e-01_r8,1.0433e-01_r8,7.2303e-02_r8,3.8009e-02_r8,2.1938e-04_r8/)
      kbo(:, 2,57,11) = (/ &
     &2.5198e-01_r8,2.1938e-01_r8,1.5311e-01_r8,8.0877e-02_r8,3.9875e-04_r8/)
      kbo(:, 3,57,11) = (/ &
     &5.3606e-01_r8,4.7039e-01_r8,3.2945e-01_r8,1.7508e-01_r8,6.9954e-04_r8/)
      kbo(:, 4,57,11) = (/ &
     &1.0880e+00_r8,9.4273e-01_r8,6.6142e-01_r8,3.5027e-01_r8,1.1454e-03_r8/)
      kbo(:, 5,57,11) = (/ &
     &2.0139e+00_r8,1.7191e+00_r8,1.2097e+00_r8,6.4100e-01_r8,1.7901e-03_r8/)
      kbo(:, 1,58,11) = (/ &
     &4.6919e-02_r8,4.6268e-02_r8,3.7584e-02_r8,2.3911e-02_r8,1.7988e-04_r8/)
      kbo(:, 2,58,11) = (/ &
     &9.9628e-02_r8,9.8832e-02_r8,8.0744e-02_r8,5.1438e-02_r8,3.2482e-04_r8/)
      kbo(:, 3,58,11) = (/ &
     &2.1097e-01_r8,2.1358e-01_r8,1.7570e-01_r8,1.1318e-01_r8,5.8194e-04_r8/)
      kbo(:, 4,58,11) = (/ &
     &4.4837e-01_r8,4.4802e-01_r8,3.6936e-01_r8,2.3727e-01_r8,9.7962e-04_r8/)
      kbo(:, 5,58,11) = (/ &
     &8.6568e-01_r8,8.5230e-01_r8,7.0456e-01_r8,4.5178e-01_r8,1.5789e-03_r8/)
      kbo(:, 1,59,11) = (/ &
     &4.1955e-02_r8,4.1496e-02_r8,3.3924e-02_r8,2.1748e-02_r8,1.7054e-04_r8/)
      kbo(:, 2,59,11) = (/ &
     &9.0096e-02_r8,8.9872e-02_r8,7.3696e-02_r8,4.7378e-02_r8,3.1638e-04_r8/)
      kbo(:, 3,59,11) = (/ &
     &1.9169e-01_r8,1.9390e-01_r8,1.6037e-01_r8,1.0394e-01_r8,5.9374e-04_r8/)
      kbo(:, 4,59,11) = (/ &
     &4.1170e-01_r8,4.1459e-01_r8,3.4386e-01_r8,2.2297e-01_r8,1.0082e-03_r8/)
      kbo(:, 5,59,11) = (/ &
     &8.1839e-01_r8,8.1107e-01_r8,6.7470e-01_r8,4.3624e-01_r8,1.6869e-03_r8/)
      kbo(:, 1,13,12) = (/ &
     &1.0396e+02_r8,7.7973e+01_r8,5.1984e+01_r8,2.5992e+01_r8,2.8896e-01_r8/)
      kbo(:, 2,13,12) = (/ &
     &1.4817e+02_r8,1.1113e+02_r8,7.4089e+01_r8,3.7043e+01_r8,6.4071e-01_r8/)
      kbo(:, 3,13,12) = (/ &
     &2.0061e+02_r8,1.5046e+02_r8,1.0030e+02_r8,5.0152e+01_r8,7.6116e-01_r8/)
      kbo(:, 4,13,12) = (/ &
     &2.6114e+02_r8,1.9586e+02_r8,1.3057e+02_r8,6.5284e+01_r8,1.0553e+00_r8/)
      kbo(:, 5,13,12) = (/ &
     &3.2831e+02_r8,2.4622e+02_r8,1.6415e+02_r8,8.2071e+01_r8,1.4067e+00_r8/)
      kbo(:, 1,14,12) = (/ &
     &1.1135e+02_r8,8.3512e+01_r8,5.5676e+01_r8,2.7839e+01_r8,4.1053e-01_r8/)
      kbo(:, 2,14,12) = (/ &
     &1.5695e+02_r8,1.1771e+02_r8,7.8475e+01_r8,3.9240e+01_r8,6.2372e-01_r8/)
      kbo(:, 3,14,12) = (/ &
     &2.1121e+02_r8,1.5841e+02_r8,1.0560e+02_r8,5.2802e+01_r8,8.0301e-01_r8/)
      kbo(:, 4,14,12) = (/ &
     &2.7313e+02_r8,2.0485e+02_r8,1.3657e+02_r8,6.8283e+01_r8,1.0170e+00_r8/)
      kbo(:, 5,14,12) = (/ &
     &3.4124e+02_r8,2.5592e+02_r8,1.7062e+02_r8,8.5308e+01_r8,1.1064e+00_r8/)
      kbo(:, 1,15,12) = (/ &
     &1.1186e+02_r8,8.3897e+01_r8,5.5935e+01_r8,2.7966e+01_r8,4.8952e-01_r8/)
      kbo(:, 2,15,12) = (/ &
     &1.5638e+02_r8,1.1729e+02_r8,7.8194e+01_r8,3.9097e+01_r8,5.8507e-01_r8/)
      kbo(:, 3,15,12) = (/ &
     &2.0878e+02_r8,1.5659e+02_r8,1.0439e+02_r8,5.2197e+01_r8,6.7687e-01_r8/)
      kbo(:, 4,15,12) = (/ &
     &2.6790e+02_r8,2.0092e+02_r8,1.3395e+02_r8,6.6979e+01_r8,7.8981e-01_r8/)
      kbo(:, 5,15,12) = (/ &
     &3.3305e+02_r8,2.4981e+02_r8,1.6654e+02_r8,8.3272e+01_r8,9.5540e-01_r8/)
      kbo(:, 1,16,12) = (/ &
     &1.0741e+02_r8,8.0552e+01_r8,5.3706e+01_r8,2.6852e+01_r8,4.1874e-01_r8/)
      kbo(:, 2,16,12) = (/ &
     &1.4898e+02_r8,1.1174e+02_r8,7.4489e+01_r8,3.7244e+01_r8,5.0405e-01_r8/)
      kbo(:, 3,16,12) = (/ &
     &1.9721e+02_r8,1.4789e+02_r8,9.8599e+01_r8,4.9301e+01_r8,6.1901e-01_r8/)
      kbo(:, 4,16,12) = (/ &
     &2.5144e+02_r8,1.8859e+02_r8,1.2573e+02_r8,6.2879e+01_r8,7.4947e-01_r8/)
      kbo(:, 5,16,12) = (/ &
     &3.1058e+02_r8,2.3295e+02_r8,1.5529e+02_r8,7.7686e+01_r8,8.7491e-01_r8/)
      kbo(:, 1,17,12) = (/ &
     &9.9838e+01_r8,7.4879e+01_r8,4.9919e+01_r8,2.5012e+01_r8,3.9338e-01_r8/)
      kbo(:, 2,17,12) = (/ &
     &1.3717e+02_r8,1.0287e+02_r8,6.8583e+01_r8,3.4361e+01_r8,4.7893e-01_r8/)
      kbo(:, 3,17,12) = (/ &
     &1.8052e+02_r8,1.3539e+02_r8,9.0259e+01_r8,4.5242e+01_r8,5.7262e-01_r8/)
      kbo(:, 4,17,12) = (/ &
     &2.2880e+02_r8,1.7160e+02_r8,1.1440e+02_r8,5.7395e+01_r8,6.8306e-01_r8/)
      kbo(:, 5,17,12) = (/ &
     &2.8220e+02_r8,2.1165e+02_r8,1.4109e+02_r8,7.0870e+01_r8,7.6022e-01_r8/)
      kbo(:, 1,18,12) = (/ &
     &8.8836e+01_r8,6.6627e+01_r8,4.4421e+01_r8,2.2423e+01_r8,3.7355e-01_r8/)
      kbo(:, 2,18,12) = (/ &
     &1.2136e+02_r8,9.1017e+01_r8,6.0679e+01_r8,3.0651e+01_r8,4.3123e-01_r8/)
      kbo(:, 3,18,12) = (/ &
     &1.5857e+02_r8,1.1893e+02_r8,7.9284e+01_r8,4.0088e+01_r8,5.1039e-01_r8/)
      kbo(:, 4,18,12) = (/ &
     &2.0050e+02_r8,1.5036e+02_r8,1.0025e+02_r8,5.0735e+01_r8,5.8388e-01_r8/)
      kbo(:, 5,18,12) = (/ &
     &2.4631e+02_r8,1.8473e+02_r8,1.2316e+02_r8,6.2388e+01_r8,6.7078e-01_r8/)
      kbo(:, 1,19,12) = (/ &
     &7.8886e+01_r8,5.9167e+01_r8,3.9445e+01_r8,2.0119e+01_r8,3.3866e-01_r8/)
      kbo(:, 2,19,12) = (/ &
     &1.0689e+02_r8,8.0167e+01_r8,5.3444e+01_r8,2.7289e+01_r8,4.0283e-01_r8/)
      kbo(:, 3,19,12) = (/ &
     &1.3921e+02_r8,1.0440e+02_r8,6.9601e+01_r8,3.5553e+01_r8,4.5001e-01_r8/)
      kbo(:, 4,19,12) = (/ &
     &1.7541e+02_r8,1.3156e+02_r8,8.7714e+01_r8,4.4793e+01_r8,5.0843e-01_r8/)
      kbo(:, 5,19,12) = (/ &
     &2.1523e+02_r8,1.6142e+02_r8,1.0764e+02_r8,5.4993e+01_r8,5.9607e-01_r8/)
      kbo(:, 1,20,12) = (/ &
     &7.0328e+01_r8,5.2750e+01_r8,3.5209e+01_r8,1.8081e+01_r8,3.1237e-01_r8/)
      kbo(:, 2,20,12) = (/ &
     &9.4812e+01_r8,7.1110e+01_r8,4.7453e+01_r8,2.4387e+01_r8,3.6655e-01_r8/)
      kbo(:, 3,20,12) = (/ &
     &1.2307e+02_r8,9.2305e+01_r8,6.1607e+01_r8,3.1685e+01_r8,4.1127e-01_r8/)
      kbo(:, 4,20,12) = (/ &
     &1.5482e+02_r8,1.1612e+02_r8,7.7556e+01_r8,3.9922e+01_r8,4.7264e-01_r8/)
      kbo(:, 5,20,12) = (/ &
     &1.8921e+02_r8,1.4190e+02_r8,9.4818e+01_r8,4.8866e+01_r8,5.5288e-01_r8/)
      kbo(:, 1,21,12) = (/ &
     &6.2329e+01_r8,4.6745e+01_r8,3.1314e+01_r8,1.6132e+01_r8,2.8533e-01_r8/)
      kbo(:, 2,21,12) = (/ &
     &8.3734e+01_r8,6.2791e+01_r8,4.2073e+01_r8,2.1717e+01_r8,3.3097e-01_r8/)
      kbo(:, 3,21,12) = (/ &
     &1.0843e+02_r8,8.1321e+01_r8,5.4516e+01_r8,2.8198e+01_r8,3.8205e-01_r8/)
      kbo(:, 4,21,12) = (/ &
     &1.3597e+02_r8,1.0198e+02_r8,6.8398e+01_r8,3.5455e+01_r8,4.6172e-01_r8/)
      kbo(:, 5,21,12) = (/ &
     &1.6566e+02_r8,1.2424e+02_r8,8.3370e+01_r8,4.3320e+01_r8,5.2289e-01_r8/)
      kbo(:, 1,22,12) = (/ &
     &5.5853e+01_r8,4.1896e+01_r8,2.8239e+01_r8,1.4630e+01_r8,2.6479e-01_r8/)
      kbo(:, 2,22,12) = (/ &
     &7.4659e+01_r8,5.5993e+01_r8,3.7758e+01_r8,1.9621e+01_r8,3.0587e-01_r8/)
      kbo(:, 3,22,12) = (/ &
     &9.6287e+01_r8,7.2215e+01_r8,4.8710e+01_r8,2.5388e+01_r8,3.6961e-01_r8/)
      kbo(:, 4,22,12) = (/ &
     &1.2002e+02_r8,9.0023e+01_r8,6.0736e+01_r8,3.1753e+01_r8,4.4273e-01_r8/)
      kbo(:, 5,22,12) = (/ &
     &1.4596e+02_r8,1.0947e+02_r8,7.3878e+01_r8,3.8690e+01_r8,5.0560e-01_r8/)
      kbo(:, 1,23,12) = (/ &
     &4.9987e+01_r8,3.7501e+01_r8,2.5418e+01_r8,1.3325e+01_r8,2.4880e-01_r8/)
      kbo(:, 2,23,12) = (/ &
     &6.6514e+01_r8,4.9903e+01_r8,3.3828e+01_r8,1.7769e+01_r8,2.9089e-01_r8/)
      kbo(:, 3,23,12) = (/ &
     &8.5155e+01_r8,6.3887e+01_r8,4.3325e+01_r8,2.2796e+01_r8,3.6730e-01_r8/)
      kbo(:, 4,23,12) = (/ &
     &1.0588e+02_r8,7.9440e+01_r8,5.3898e+01_r8,2.8390e+01_r8,4.2226e-01_r8/)
      kbo(:, 5,23,12) = (/ &
     &1.2867e+02_r8,9.6554e+01_r8,6.5521e+01_r8,3.4526e+01_r8,4.8786e-01_r8/)
      kbo(:, 1,24,12) = (/ &
     &4.5237e+01_r8,3.3990e+01_r8,2.3082e+01_r8,1.2266e+01_r8,2.3374e-01_r8/)
      kbo(:, 2,24,12) = (/ &
     &5.9731e+01_r8,4.4882e+01_r8,3.0518e+01_r8,1.6222e+01_r8,2.9093e-01_r8/)
      kbo(:, 3,24,12) = (/ &
     &7.6147e+01_r8,5.7227e+01_r8,3.8961e+01_r8,2.0700e+01_r8,3.4607e-01_r8/)
      kbo(:, 4,24,12) = (/ &
     &9.4592e+01_r8,7.1092e+01_r8,4.8449e+01_r8,2.5703e+01_r8,4.0338e-01_r8/)
      kbo(:, 5,24,12) = (/ &
     &1.1508e+02_r8,8.6507e+01_r8,5.8986e+01_r8,3.1241e+01_r8,4.6347e-01_r8/)
      kbo(:, 1,25,12) = (/ &
     &4.1207e+01_r8,3.1054e+01_r8,2.1145e+01_r8,1.1344e+01_r8,2.1959e-01_r8/)
      kbo(:, 2,25,12) = (/ &
     &5.4029e+01_r8,4.0717e+01_r8,2.7774e+01_r8,1.4878e+01_r8,2.7843e-01_r8/)
      kbo(:, 3,25,12) = (/ &
     &6.8735e+01_r8,5.1802e+01_r8,3.5391e+01_r8,1.8919e+01_r8,3.2302e-01_r8/)
      kbo(:, 4,25,12) = (/ &
     &8.5416e+01_r8,6.4368e+01_r8,4.4030e+01_r8,2.3485e+01_r8,3.8140e-01_r8/)
      kbo(:, 5,25,12) = (/ &
     &1.0430e+02_r8,7.8570e+01_r8,5.3767e+01_r8,2.8613e+01_r8,4.3338e-01_r8/)
      kbo(:, 1,26,12) = (/ &
     &3.7870e+01_r8,2.8646e+01_r8,1.9592e+01_r8,1.0560e+01_r8,2.1067e-01_r8/)
      kbo(:, 2,26,12) = (/ &
     &4.9486e+01_r8,3.7425e+01_r8,2.5645e+01_r8,1.3791e+01_r8,2.5277e-01_r8/)
      kbo(:, 3,26,12) = (/ &
     &6.2993e+01_r8,4.7626e+01_r8,3.2666e+01_r8,1.7516e+01_r8,3.0077e-01_r8/)
      kbo(:, 4,26,12) = (/ &
     &7.8659e+01_r8,5.9439e+01_r8,4.0756e+01_r8,2.1814e+01_r8,3.5095e-01_r8/)
      kbo(:, 5,26,12) = (/ &
     &9.6658e+01_r8,7.2997e+01_r8,5.0039e+01_r8,2.6742e+01_r8,4.0727e-01_r8/)
      kbo(:, 1,27,12) = (/ &
     &3.5089e+01_r8,2.6619e+01_r8,1.8325e+01_r8,9.8881e+00_r8,1.9876e-01_r8/)
      kbo(:, 2,27,12) = (/ &
     &4.5899e+01_r8,3.4800e+01_r8,2.3944e+01_r8,1.2890e+01_r8,2.3298e-01_r8/)
      kbo(:, 3,27,12) = (/ &
     &5.8737e+01_r8,4.4506e+01_r8,3.0596e+01_r8,1.6445e+01_r8,2.8191e-01_r8/)
      kbo(:, 4,27,12) = (/ &
     &7.3770e+01_r8,5.5858e+01_r8,3.8369e+01_r8,2.0601e+01_r8,3.2481e-01_r8/)
      kbo(:, 5,27,12) = (/ &
     &9.1107e+01_r8,6.8940e+01_r8,4.7296e+01_r8,2.5356e+01_r8,3.8171e-01_r8/)
      kbo(:, 1,28,12) = (/ &
     &3.2818e+01_r8,2.4943e+01_r8,1.7280e+01_r8,9.3226e+00_r8,1.7817e-01_r8/)
      kbo(:, 2,28,12) = (/ &
     &4.3184e+01_r8,3.2811e+01_r8,2.2668e+01_r8,1.2208e+01_r8,2.1857e-01_r8/)
      kbo(:, 3,28,12) = (/ &
     &5.5616e+01_r8,4.2235e+01_r8,2.9105e+01_r8,1.5656e+01_r8,2.5762e-01_r8/)
      kbo(:, 4,28,12) = (/ &
     &7.0259e+01_r8,5.3319e+01_r8,3.6659e+01_r8,1.9693e+01_r8,3.0371e-01_r8/)
      kbo(:, 5,28,12) = (/ &
     &8.7123e+01_r8,6.6079e+01_r8,4.5396e+01_r8,2.4379e+01_r8,3.5478e-01_r8/)
      kbo(:, 1,29,12) = (/ &
     &3.0859e+01_r8,2.3511e+01_r8,1.6360e+01_r8,8.8280e+00_r8,1.6679e-01_r8/)
      kbo(:, 2,29,12) = (/ &
     &4.0867e+01_r8,3.1128e+01_r8,2.1584e+01_r8,1.1631e+01_r8,2.0451e-01_r8/)
      kbo(:, 3,29,12) = (/ &
     &5.2915e+01_r8,4.0294e+01_r8,2.7845e+01_r8,1.4987e+01_r8,2.3670e-01_r8/)
      kbo(:, 4,29,12) = (/ &
     &6.7028e+01_r8,5.1030e+01_r8,3.5190e+01_r8,1.8944e+01_r8,2.7999e-01_r8/)
      kbo(:, 5,29,12) = (/ &
     &8.3169e+01_r8,6.3273e+01_r8,4.3571e+01_r8,2.3474e+01_r8,3.2963e-01_r8/)
      kbo(:, 1,30,12) = (/ &
     &2.9181e+01_r8,2.2308e+01_r8,1.5570e+01_r8,8.4046e+00_r8,1.5217e-01_r8/)
      kbo(:, 2,30,12) = (/ &
     &3.8810e+01_r8,2.9664e+01_r8,2.0634e+01_r8,1.1131e+01_r8,1.8255e-01_r8/)
      kbo(:, 3,30,12) = (/ &
     &5.0316e+01_r8,3.8456e+01_r8,2.6686e+01_r8,1.4393e+01_r8,2.1489e-01_r8/)
      kbo(:, 4,30,12) = (/ &
     &6.3652e+01_r8,4.8625e+01_r8,3.3675e+01_r8,1.8188e+01_r8,2.5258e-01_r8/)
      kbo(:, 5,30,12) = (/ &
     &7.8956e+01_r8,6.0282e+01_r8,4.1671e+01_r8,2.2569e+01_r8,2.9642e-01_r8/)
      kbo(:, 1,31,12) = (/ &
     &2.7538e+01_r8,2.1159e+01_r8,1.4815e+01_r8,8.0002e+00_r8,1.3523e-01_r8/)
      kbo(:, 2,31,12) = (/ &
     &3.6621e+01_r8,2.8123e+01_r8,1.9646e+01_r8,1.0617e+01_r8,1.6072e-01_r8/)
      kbo(:, 3,31,12) = (/ &
     &4.7347e+01_r8,3.6341e+01_r8,2.5341e+01_r8,1.3718e+01_r8,1.9204e-01_r8/)
      kbo(:, 4,31,12) = (/ &
     &5.9881e+01_r8,4.5936e+01_r8,3.1977e+01_r8,1.7350e+01_r8,2.2658e-01_r8/)
      kbo(:, 5,31,12) = (/ &
     &7.4375e+01_r8,5.6987e+01_r8,3.9602e+01_r8,2.1563e+01_r8,2.6205e-01_r8/)
      kbo(:, 1,32,12) = (/ &
     &2.6147e+01_r8,2.0200e+01_r8,1.4192e+01_r8,7.6720e+00_r8,1.1829e-01_r8/)
      kbo(:, 2,32,12) = (/ &
     &3.4618e+01_r8,2.6728e+01_r8,1.8768e+01_r8,1.0173e+01_r8,1.4448e-01_r8/)
      kbo(:, 3,32,12) = (/ &
     &4.4733e+01_r8,3.4488e+01_r8,2.4181e+01_r8,1.3140e+01_r8,1.7290e-01_r8/)
      kbo(:, 4,32,12) = (/ &
     &5.6644e+01_r8,4.3620e+01_r8,3.0542e+01_r8,1.6653e+01_r8,2.0200e-01_r8/)
      kbo(:, 5,32,12) = (/ &
     &7.0667e+01_r8,5.4331e+01_r8,3.7949e+01_r8,2.0755e+01_r8,2.3023e-01_r8/)
      kbo(:, 1,33,12) = (/ &
     &2.4867e+01_r8,1.9325e+01_r8,1.3642e+01_r8,7.3884e+00_r8,1.0477e-01_r8/)
      kbo(:, 2,33,12) = (/ &
     &3.2857e+01_r8,2.5486e+01_r8,1.7993e+01_r8,9.7748e+00_r8,1.2807e-01_r8/)
      kbo(:, 3,33,12) = (/ &
     &4.2482e+01_r8,3.2899e+01_r8,2.3208e+01_r8,1.2658e+01_r8,1.5122e-01_r8/)
      kbo(:, 4,33,12) = (/ &
     &5.4028e+01_r8,4.1749e+01_r8,2.9378e+01_r8,1.6087e+01_r8,1.7656e-01_r8/)
      kbo(:, 5,33,12) = (/ &
     &6.7699e+01_r8,5.2220e+01_r8,3.6682e+01_r8,2.0157e+01_r8,2.0029e-01_r8/)
      kbo(:, 1,34,12) = (/ &
     &2.3698e+01_r8,1.8505e+01_r8,1.3121e+01_r8,7.1187e+00_r8,9.5888e-02_r8/)
      kbo(:, 2,34,12) = (/ &
     &3.1359e+01_r8,2.4427e+01_r8,1.7335e+01_r8,9.4402e+00_r8,1.1540e-01_r8/)
      kbo(:, 3,34,12) = (/ &
     &4.0701e+01_r8,3.1624e+01_r8,2.2413e+01_r8,1.2266e+01_r8,1.3371e-01_r8/)
      kbo(:, 4,34,12) = (/ &
     &5.2041e+01_r8,4.0338e+01_r8,2.8530e+01_r8,1.5676e+01_r8,1.5490e-01_r8/)
      kbo(:, 5,34,12) = (/ &
     &6.5491e+01_r8,5.0663e+01_r8,3.5768e+01_r8,1.9755e+01_r8,1.8157e-01_r8/)
      kbo(:, 1,35,12) = (/ &
     &2.2108e+01_r8,1.7359e+01_r8,1.2354e+01_r8,6.7085e+00_r8,8.3925e-02_r8/)
      kbo(:, 2,35,12) = (/ &
     &2.9390e+01_r8,2.2999e+01_r8,1.6388e+01_r8,8.9464e+00_r8,9.9962e-02_r8/)
      kbo(:, 3,35,12) = (/ &
     &3.8435e+01_r8,2.9966e+01_r8,2.1324e+01_r8,1.1694e+01_r8,1.1806e-01_r8/)
      kbo(:, 4,35,12) = (/ &
     &4.9418e+01_r8,3.8439e+01_r8,2.7323e+01_r8,1.5063e+01_r8,1.3630e-01_r8/)
      kbo(:, 5,35,12) = (/ &
     &6.2546e+01_r8,4.8535e+01_r8,3.4447e+01_r8,1.9092e+01_r8,1.6585e-01_r8/)
      kbo(:, 1,36,12) = (/ &
     &2.0129e+01_r8,1.5891e+01_r8,1.1346e+01_r8,6.1643e+00_r8,7.2166e-02_r8/)
      kbo(:, 2,36,12) = (/ &
     &2.6967e+01_r8,2.1198e+01_r8,1.5154e+01_r8,8.2858e+00_r8,8.5917e-02_r8/)
      kbo(:, 3,36,12) = (/ &
     &3.5568e+01_r8,2.7847e+01_r8,1.9901e+01_r8,1.0934e+01_r8,1.0193e-01_r8/)
      kbo(:, 4,36,12) = (/ &
     &4.6092e+01_r8,3.5975e+01_r8,2.5697e+01_r8,1.4200e+01_r8,1.2167e-01_r8/)
      kbo(:, 5,36,12) = (/ &
     &5.8785e+01_r8,4.5750e+01_r8,3.2634e+01_r8,1.8141e+01_r8,1.4958e-01_r8/)
      kbo(:, 1,37,12) = (/ &
     &1.7737e+01_r8,1.4074e+01_r8,1.0069e+01_r8,5.4659e+00_r8,6.3045e-02_r8/)
      kbo(:, 2,37,12) = (/ &
     &2.3991e+01_r8,1.8955e+01_r8,1.3586e+01_r8,7.4275e+00_r8,7.4702e-02_r8/)
      kbo(:, 3,37,12) = (/ &
     &3.1985e+01_r8,2.5160e+01_r8,1.8048e+01_r8,9.9281e+00_r8,8.9095e-02_r8/)
      kbo(:, 4,37,12) = (/ &
     &4.1889e+01_r8,3.2824e+01_r8,2.3555e+01_r8,1.3031e+01_r8,1.0656e-01_r8/)
      kbo(:, 5,37,12) = (/ &
     &5.3988e+01_r8,4.2162e+01_r8,3.0205e+01_r8,1.6815e+01_r8,1.3149e-01_r8/)
      kbo(:, 1,38,12) = (/ &
     &1.5671e+01_r8,1.2491e+01_r8,8.9462e+00_r8,4.8489e+00_r8,5.4067e-02_r8/)
      kbo(:, 2,38,12) = (/ &
     &2.1387e+01_r8,1.6974e+01_r8,1.2184e+01_r8,6.6604e+00_r8,6.5509e-02_r8/)
      kbo(:, 3,38,12) = (/ &
     &2.8785e+01_r8,2.2756e+01_r8,1.6373e+01_r8,9.0146e+00_r8,7.7568e-02_r8/)
      kbo(:, 4,38,12) = (/ &
     &3.8117e+01_r8,2.9996e+01_r8,2.1601e+01_r8,1.1967e+01_r8,9.4071e-02_r8/)
      kbo(:, 5,38,12) = (/ &
     &4.9667e+01_r8,3.8921e+01_r8,2.7995e+01_r8,1.5610e+01_r8,1.1469e-01_r8/)
      kbo(:, 1,39,12) = (/ &
     &1.3901e+01_r8,1.1137e+01_r8,7.9846e+00_r8,4.3195e+00_r8,4.6183e-02_r8/)
      kbo(:, 2,39,12) = (/ &
     &1.9150e+01_r8,1.5270e+01_r8,1.0976e+01_r8,5.9905e+00_r8,5.6093e-02_r8/)
      kbo(:, 3,39,12) = (/ &
     &2.6010e+01_r8,2.0653e+01_r8,1.4897e+01_r8,8.2086e+00_r8,6.7656e-02_r8/)
      kbo(:, 4,39,12) = (/ &
     &3.4809e+01_r8,2.7511e+01_r8,1.9872e+01_r8,1.1026e+01_r8,8.1649e-02_r8/)
      kbo(:, 5,39,12) = (/ &
     &4.5848e+01_r8,3.6052e+01_r8,2.6039e+01_r8,1.4537e+01_r8,9.9747e-02_r8/)
      kbo(:, 1,40,12) = (/ &
     &1.2081e+01_r8,9.7243e+00_r8,6.9733e+00_r8,3.7653e+00_r8,3.9581e-02_r8/)
      kbo(:, 2,40,12) = (/ &
     &1.6838e+01_r8,1.3484e+01_r8,9.6953e+00_r8,5.2801e+00_r8,4.8568e-02_r8/)
      kbo(:, 3,40,12) = (/ &
     &2.3104e+01_r8,1.8425e+01_r8,1.3302e+01_r8,7.3218e+00_r8,5.8955e-02_r8/)
      kbo(:, 4,40,12) = (/ &
     &3.1273e+01_r8,2.4818e+01_r8,1.7967e+01_r8,9.9757e+00_r8,7.0859e-02_r8/)
      kbo(:, 5,40,12) = (/ &
     &4.1711e+01_r8,3.2920e+01_r8,2.3848e+01_r8,1.3319e+01_r8,8.6539e-02_r8/)
      kbo(:, 1,41,12) = (/ &
     &1.0485e+01_r8,8.4800e+00_r8,6.0787e+00_r8,3.2769e+00_r8,3.3606e-02_r8/)
      kbo(:, 2,41,12) = (/ &
     &1.4786e+01_r8,1.1894e+01_r8,8.5576e+00_r8,4.6493e+00_r8,4.1457e-02_r8/)
      kbo(:, 3,41,12) = (/ &
     &2.0530e+01_r8,1.6437e+01_r8,1.1871e+01_r8,6.5218e+00_r8,5.0842e-02_r8/)
      kbo(:, 4,41,12) = (/ &
     &2.8093e+01_r8,2.2374e+01_r8,1.6223e+01_r8,9.0068e+00_r8,6.1229e-02_r8/)
      kbo(:, 5,41,12) = (/ &
     &3.7921e+01_r8,3.0039e+01_r8,2.1812e+01_r8,1.2190e+01_r8,7.5282e-02_r8/)
      kbo(:, 1,42,12) = (/ &
     &9.1079e+00_r8,7.3993e+00_r8,5.3023e+00_r8,2.8534e+00_r8,2.8075e-02_r8/)
      kbo(:, 2,42,12) = (/ &
     &1.3005e+01_r8,1.0510e+01_r8,7.5619e+00_r8,4.1019e+00_r8,3.5441e-02_r8/)
      kbo(:, 3,42,12) = (/ &
     &1.8277e+01_r8,1.4697e+01_r8,1.0617e+01_r8,5.8190e+00_r8,4.3089e-02_r8/)
      kbo(:, 4,42,12) = (/ &
     &2.5289e+01_r8,2.0221e+01_r8,1.4670e+01_r8,8.1365e+00_r8,5.2317e-02_r8/)
      kbo(:, 5,42,12) = (/ &
     &3.4535e+01_r8,2.7452e+01_r8,1.9969e+01_r8,1.1164e+01_r8,6.5436e-02_r8/)
      kbo(:, 1,43,12) = (/ &
     &7.8247e+00_r8,6.3834e+00_r8,4.5697e+00_r8,2.4551e+00_r8,2.3117e-02_r8/)
      kbo(:, 2,43,12) = (/ &
     &1.1336e+01_r8,9.1978e+00_r8,6.6143e+00_r8,3.5804e+00_r8,2.9659e-02_r8/)
      kbo(:, 3,43,12) = (/ &
     &1.6137e+01_r8,1.3030e+01_r8,9.4153e+00_r8,5.1449e+00_r8,3.6857e-02_r8/)
      kbo(:, 4,43,12) = (/ &
     &2.2622e+01_r8,1.8150e+01_r8,1.3165e+01_r8,7.2856e+00_r8,4.4557e-02_r8/)
      kbo(:, 5,43,12) = (/ &
     &3.1253e+01_r8,2.4925e+01_r8,1.8144e+01_r8,1.0136e+01_r8,5.5864e-02_r8/)
      kbo(:, 1,44,12) = (/ &
     &6.6782e+00_r8,5.4729e+00_r8,3.9116e+00_r8,2.0984e+00_r8,1.9194e-02_r8/)
      kbo(:, 2,44,12) = (/ &
     &9.8370e+00_r8,8.0127e+00_r8,5.7576e+00_r8,3.1087e+00_r8,2.4741e-02_r8/)
      kbo(:, 3,44,12) = (/ &
     &1.4194e+01_r8,1.1506e+01_r8,8.3119e+00_r8,4.5308e+00_r8,3.1291e-02_r8/)
      kbo(:, 4,44,12) = (/ &
     &2.0172e+01_r8,1.6246e+01_r8,1.1781e+01_r8,6.4997e+00_r8,3.7622e-02_r8/)
      kbo(:, 5,44,12) = (/ &
     &2.8219e+01_r8,2.2570e+01_r8,1.6428e+01_r8,9.1628e+00_r8,4.7831e-02_r8/)
      kbo(:, 1,45,12) = (/ &
     &5.6770e+00_r8,4.6794e+00_r8,3.3425e+00_r8,1.7902e+00_r8,1.5806e-02_r8/)
      kbo(:, 2,45,12) = (/ &
     &8.5322e+00_r8,6.9760e+00_r8,5.0078e+00_r8,2.6991e+00_r8,2.0417e-02_r8/)
      kbo(:, 3,45,12) = (/ &
     &1.2498e+01_r8,1.0162e+01_r8,7.3367e+00_r8,3.9899e+00_r8,2.6093e-02_r8/)
      kbo(:, 4,45,12) = (/ &
     &1.7997e+01_r8,1.4548e+01_r8,1.0552e+01_r8,5.8018e+00_r8,3.2356e-02_r8/)
      kbo(:, 5,45,12) = (/ &
     &2.5510e+01_r8,2.0455e+01_r8,1.4885e+01_r8,8.2823e+00_r8,4.0610e-02_r8/)
      kbo(:, 1,46,12) = (/ &
     &4.7638e+00_r8,3.9496e+00_r8,2.8218e+00_r8,1.5105e+00_r8,1.2604e-02_r8/)
      kbo(:, 2,46,12) = (/ &
     &7.3248e+00_r8,6.0189e+00_r8,4.3157e+00_r8,2.3220e+00_r8,1.6943e-02_r8/)
      kbo(:, 3,46,12) = (/ &
     &1.0931e+01_r8,8.9155e+00_r8,6.4285e+00_r8,3.4858e+00_r8,2.1734e-02_r8/)
      kbo(:, 4,46,12) = (/ &
     &1.5948e+01_r8,1.2933e+01_r8,9.3805e+00_r8,5.1432e+00_r8,2.7407e-02_r8/)
      kbo(:, 5,46,12) = (/ &
     &2.2923e+01_r8,1.8438e+01_r8,1.3407e+01_r8,7.4358e+00_r8,3.4309e-02_r8/)
      kbo(:, 1,47,12) = (/ &
     &3.9080e+00_r8,3.2569e+00_r8,2.3263e+00_r8,1.2446e+00_r8,1.0169e-02_r8/)
      kbo(:, 2,47,12) = (/ &
     &6.1567e+00_r8,5.0883e+00_r8,3.6497e+00_r8,1.9607e+00_r8,1.3733e-02_r8/)
      kbo(:, 3,47,12) = (/ &
     &9.4053e+00_r8,7.6982e+00_r8,5.5432e+00_r8,2.9978e+00_r8,1.8162e-02_r8/)
      kbo(:, 4,47,12) = (/ &
     &1.3941e+01_r8,1.1337e+01_r8,8.2150e+00_r8,4.4897e+00_r8,2.3207e-02_r8/)
      kbo(:, 5,47,12) = (/ &
     &2.0314e+01_r8,1.6396e+01_r8,1.1915e+01_r8,6.5825e+00_r8,2.8974e-02_r8/)
      kbo(:, 1,48,12) = (/ &
     &3.1887e+00_r8,2.6690e+00_r8,1.9049e+00_r8,1.0177e+00_r8,7.9795e-03_r8/)
      kbo(:, 2,48,12) = (/ &
     &5.1425e+00_r8,4.2754e+00_r8,3.0657e+00_r8,1.6476e+00_r8,1.1064e-02_r8/)
      kbo(:, 3,48,12) = (/ &
     &8.0497e+00_r8,6.6225e+00_r8,4.7642e+00_r8,2.5722e+00_r8,1.4743e-02_r8/)
      kbo(:, 4,48,12) = (/ &
     &1.2183e+01_r8,9.9349e+00_r8,7.1838e+00_r8,3.9122e+00_r8,1.9211e-02_r8/)
      kbo(:, 5,48,12) = (/ &
     &1.7984e+01_r8,1.4555e+01_r8,1.0573e+01_r8,5.8220e+00_r8,2.4214e-02_r8/)
      kbo(:, 1,49,12) = (/ &
     &2.5869e+00_r8,2.1741e+00_r8,1.5486e+00_r8,8.2603e-01_r8,6.2330e-03_r8/)
      kbo(:, 2,49,12) = (/ &
     &4.2741e+00_r8,3.5702e+00_r8,2.5591e+00_r8,1.3745e+00_r8,8.6780e-03_r8/)
      kbo(:, 3,49,12) = (/ &
     &6.8485e+00_r8,5.6671e+00_r8,4.0787e+00_r8,2.1997e+00_r8,1.1935e-02_r8/)
      kbo(:, 4,49,12) = (/ &
     &1.0623e+01_r8,8.6880e+00_r8,6.2733e+00_r8,3.4054e+00_r8,1.5780e-02_r8/)
      kbo(:, 5,49,12) = (/ &
     &1.5914e+01_r8,1.2906e+01_r8,9.3651e+00_r8,5.1392e+00_r8,2.0415e-02_r8/)
      kbo(:, 1,50,12) = (/ &
     &2.1098e+00_r8,1.7804e+00_r8,1.2663e+00_r8,6.7426e-01_r8,4.8509e-03_r8/)
      kbo(:, 2,50,12) = (/ &
     &3.5764e+00_r8,2.9999e+00_r8,2.1487e+00_r8,1.1529e+00_r8,6.9665e-03_r8/)
      kbo(:, 3,50,12) = (/ &
     &5.8619e+00_r8,4.8746e+00_r8,3.5094e+00_r8,1.8934e+00_r8,9.7336e-03_r8/)
      kbo(:, 4,50,12) = (/ &
     &9.3128e+00_r8,7.6488e+00_r8,5.5163e+00_r8,2.9881e+00_r8,1.3124e-02_r8/)
      kbo(:, 5,50,12) = (/ &
     &1.4210e+01_r8,1.1543e+01_r8,8.3635e+00_r8,4.5727e+00_r8,1.7352e-02_r8/)
      kbo(:, 1,51,12) = (/ &
     &1.7153e+00_r8,1.4551e+00_r8,1.0341e+00_r8,5.4981e-01_r8,3.8011e-03_r8/)
      kbo(:, 2,51,12) = (/ &
     &2.9969e+00_r8,2.5231e+00_r8,1.8054e+00_r8,9.6765e-01_r8,5.5539e-03_r8/)
      kbo(:, 3,51,12) = (/ &
     &5.0265e+00_r8,4.1972e+00_r8,3.0205e+00_r8,1.6294e+00_r8,8.0318e-03_r8/)
      kbo(:, 4,51,12) = (/ &
     &8.1641e+00_r8,6.7342e+00_r8,4.8593e+00_r8,2.6284e+00_r8,1.0987e-02_r8/)
      kbo(:, 5,51,12) = (/ &
     &1.2731e+01_r8,1.0364e+01_r8,7.4966e+00_r8,4.0842e+00_r8,1.4784e-02_r8/)
      kbo(:, 1,52,12) = (/ &
     &1.3829e+00_r8,1.1793e+00_r8,8.3692e-01_r8,4.4489e-01_r8,2.9111e-03_r8/)
      kbo(:, 2,52,12) = (/ &
     &2.5001e+00_r8,2.1140e+00_r8,1.5110e+00_r8,8.0824e-01_r8,4.4285e-03_r8/)
      kbo(:, 3,52,12) = (/ &
     &4.2993e+00_r8,3.6038e+00_r8,2.5920e+00_r8,1.3972e+00_r8,6.4988e-03_r8/)
      kbo(:, 4,52,12) = (/ &
     &7.1362e+00_r8,5.9093e+00_r8,4.2654e+00_r8,2.3076e+00_r8,9.0777e-03_r8/)
      kbo(:, 5,52,12) = (/ &
     &1.1388e+01_r8,9.2949e+00_r8,6.7113e+00_r8,3.6475e+00_r8,1.2584e-02_r8/)
      kbo(:, 1,53,12) = (/ &
     &1.0996e+00_r8,9.4448e-01_r8,6.6999e-01_r8,3.5618e-01_r8,2.1752e-03_r8/)
      kbo(:, 2,53,12) = (/ &
     &2.0714e+00_r8,1.7598e+00_r8,1.2567e+00_r8,6.7105e-01_r8,3.4164e-03_r8/)
      kbo(:, 3,53,12) = (/ &
     &3.6653e+00_r8,3.0827e+00_r8,2.2148e+00_r8,1.1926e+00_r8,5.1289e-03_r8/)
      kbo(:, 4,53,12) = (/ &
     &6.2207e+00_r8,5.1680e+00_r8,3.7282e+00_r8,2.0166e+00_r8,7.4836e-03_r8/)
      kbo(:, 5,53,12) = (/ &
     &1.0144e+01_r8,8.3054e+00_r8,5.9967e+00_r8,3.2508e+00_r8,1.0390e-02_r8/)
      kbo(:, 1,54,12) = (/ &
     &8.8096e-01_r8,7.6003e-01_r8,5.3828e-01_r8,2.8652e-01_r8,1.7028e-03_r8/)
      kbo(:, 2,54,12) = (/ &
     &1.7342e+00_r8,1.4790e+00_r8,1.0559e+00_r8,5.6372e-01_r8,2.7715e-03_r8/)
      kbo(:, 3,54,12) = (/ &
     &3.1660e+00_r8,2.6700e+00_r8,1.9162e+00_r8,1.0305e+00_r8,4.2409e-03_r8/)
      kbo(:, 4,54,12) = (/ &
     &5.4916e+00_r8,4.5733e+00_r8,3.2967e+00_r8,1.7833e+00_r8,6.3614e-03_r8/)
      kbo(:, 5,54,12) = (/ &
     &9.1316e+00_r8,7.4962e+00_r8,5.4128e+00_r8,2.9325e+00_r8,9.0996e-03_r8/)
      kbo(:, 1,55,12) = (/ &
     &7.0080e-01_r8,6.0941e-01_r8,4.3132e-01_r8,2.2991e-01_r8,1.3497e-03_r8/)
      kbo(:, 2,55,12) = (/ &
     &1.4554e+00_r8,1.2471e+00_r8,8.8937e-01_r8,4.7463e-01_r8,2.3282e-03_r8/)
      kbo(:, 3,55,12) = (/ &
     &2.7458e+00_r8,2.3243e+00_r8,1.6671e+00_r8,8.9493e-01_r8,3.6585e-03_r8/)
      kbo(:, 4,55,12) = (/ &
     &4.8778e+00_r8,4.0704e+00_r8,2.9318e+00_r8,1.5851e+00_r8,5.5673e-03_r8/)
      kbo(:, 5,55,12) = (/ &
     &8.2670e+00_r8,6.7971e+00_r8,4.9063e+00_r8,2.6581e+00_r8,8.0481e-03_r8/)
      kbo(:, 1,56,12) = (/ &
     &5.5050e-01_r8,4.8277e-01_r8,3.4128e-01_r8,1.8181e-01_r8,1.0666e-03_r8/)
      kbo(:, 2,56,12) = (/ &
     &1.2088e+00_r8,1.0426e+00_r8,7.4350e-01_r8,3.9744e-01_r8,1.9421e-03_r8/)
      kbo(:, 3,56,12) = (/ &
     &2.3753e+00_r8,2.0178e+00_r8,1.4463e+00_r8,7.7559e-01_r8,3.1486e-03_r8/)
      kbo(:, 4,56,12) = (/ &
     &4.3336e+00_r8,3.6227e+00_r8,2.6061e+00_r8,1.4075e+00_r8,4.8772e-03_r8/)
      kbo(:, 5,56,12) = (/ &
     &7.4871e+00_r8,6.1648e+00_r8,4.4455e+00_r8,2.4084e+00_r8,7.2633e-03_r8/)
      kbo(:, 1,57,12) = (/ &
     &4.2691e-01_r8,3.7593e-01_r8,2.6606e-01_r8,1.4195e-01_r8,8.3793e-04_r8/)
      kbo(:, 2,57,12) = (/ &
     &9.9567e-01_r8,8.6325e-01_r8,6.1463e-01_r8,3.2859e-01_r8,1.6242e-03_r8/)
      kbo(:, 3,57,12) = (/ &
     &2.0486e+00_r8,1.7449e+00_r8,1.2502e+00_r8,6.7018e-01_r8,2.7399e-03_r8/)
      kbo(:, 4,57,12) = (/ &
     &3.8496e+00_r8,3.2234e+00_r8,2.3159e+00_r8,1.2492e+00_r8,4.2649e-03_r8/)
      kbo(:, 5,57,12) = (/ &
     &6.7867e+00_r8,5.5927e+00_r8,4.0285e+00_r8,2.1823e+00_r8,6.5093e-03_r8/)
      kbo(:, 1,58,12) = (/ &
     &1.6356e-01_r8,1.6482e-01_r8,1.3630e-01_r8,8.7916e-02_r8,6.5877e-04_r8/)
      kbo(:, 2,58,12) = (/ &
     &3.9653e-01_r8,3.9771e-01_r8,3.3219e-01_r8,2.1522e-01_r8,1.3561e-03_r8/)
      kbo(:, 3,58,12) = (/ &
     &8.5978e-01_r8,8.4388e-01_r8,7.0959e-01_r8,4.6009e-01_r8,2.4231e-03_r8/)
      kbo(:, 4,58,12) = (/ &
     &1.6685e+00_r8,1.6071e+00_r8,1.3546e+00_r8,8.8295e-01_r8,3.8944e-03_r8/)
      kbo(:, 5,58,12) = (/ &
     &3.0057e+00_r8,2.8445e+00_r8,2.4022e+00_r8,1.5741e+00_r8,5.9596e-03_r8/)
      kbo(:, 1,59,12) = (/ &
     &1.4551e-01_r8,1.4725e-01_r8,1.2251e-01_r8,7.9561e-02_r8,6.8074e-04_r8/)
      kbo(:, 2,59,12) = (/ &
     &3.6080e-01_r8,3.6451e-01_r8,3.0649e-01_r8,2.0003e-01_r8,1.4324e-03_r8/)
      kbo(:, 3,59,12) = (/ &
     &8.0811e-01_r8,7.9823e-01_r8,6.7489e-01_r8,4.4138e-01_r8,2.5709e-03_r8/)
      kbo(:, 4,59,12) = (/ &
     &1.6058e+00_r8,1.5512e+00_r8,1.3138e+00_r8,8.6244e-01_r8,4.2753e-03_r8/)
      kbo(:, 5,59,12) = (/ &
     &2.9249e+00_r8,2.7730e+00_r8,2.3517e+00_r8,1.5520e+00_r8,6.3367e-03_r8/)
      kbo(:, 1,13,13) = (/ &
     &1.6844e+02_r8,1.2633e+02_r8,8.4219e+01_r8,4.2110e+01_r8,6.4746e-01_r8/)
      kbo(:, 2,13,13) = (/ &
     &2.3974e+02_r8,1.7981e+02_r8,1.1987e+02_r8,5.9937e+01_r8,7.7977e-01_r8/)
      kbo(:, 3,13,13) = (/ &
     &3.2626e+02_r8,2.4469e+02_r8,1.6313e+02_r8,8.1566e+01_r8,1.5118e+00_r8/)
      kbo(:, 4,13,13) = (/ &
     &4.2676e+02_r8,3.2006e+02_r8,2.1338e+02_r8,1.0669e+02_r8,1.6642e+00_r8/)
      kbo(:, 5,13,13) = (/ &
     &5.4119e+02_r8,4.0589e+02_r8,2.7059e+02_r8,1.3530e+02_r8,1.7313e+00_r8/)
      kbo(:, 1,14,13) = (/ &
     &1.9041e+02_r8,1.4281e+02_r8,9.5205e+01_r8,4.7604e+01_r8,4.8593e-01_r8/)
      kbo(:, 2,14,13) = (/ &
     &2.6943e+02_r8,2.0207e+02_r8,1.3472e+02_r8,6.7360e+01_r8,1.0523e+00_r8/)
      kbo(:, 3,14,13) = (/ &
     &3.6326e+02_r8,2.7244e+02_r8,1.8162e+02_r8,9.0813e+01_r8,1.4658e+00_r8/)
      kbo(:, 4,14,13) = (/ &
     &4.7082e+02_r8,3.5312e+02_r8,2.3542e+02_r8,1.1771e+02_r8,1.6120e+00_r8/)
      kbo(:, 5,14,13) = (/ &
     &5.9086e+02_r8,4.4312e+02_r8,2.9542e+02_r8,1.4771e+02_r8,1.8462e+00_r8/)
      kbo(:, 1,15,13) = (/ &
     &2.0331e+02_r8,1.5249e+02_r8,1.0165e+02_r8,5.0828e+01_r8,7.0211e-01_r8/)
      kbo(:, 2,15,13) = (/ &
     &2.8491e+02_r8,2.1369e+02_r8,1.4246e+02_r8,7.1232e+01_r8,1.1193e+00_r8/)
      kbo(:, 3,15,13) = (/ &
     &3.8104e+02_r8,2.8579e+02_r8,1.9054e+02_r8,9.5263e+01_r8,1.3482e+00_r8/)
      kbo(:, 4,15,13) = (/ &
     &4.8986e+02_r8,3.6740e+02_r8,2.4492e+02_r8,1.2246e+02_r8,1.6094e+00_r8/)
      kbo(:, 5,15,13) = (/ &
     &6.0932e+02_r8,4.5699e+02_r8,3.0468e+02_r8,1.5233e+02_r8,1.6798e+00_r8/)
      kbo(:, 1,16,13) = (/ &
     &2.0774e+02_r8,1.5583e+02_r8,1.0388e+02_r8,5.1937e+01_r8,8.3999e-01_r8/)
      kbo(:, 2,16,13) = (/ &
     &2.8883e+02_r8,2.1662e+02_r8,1.4442e+02_r8,7.2209e+01_r8,1.0268e+00_r8/)
      kbo(:, 3,16,13) = (/ &
     &3.8302e+02_r8,2.8729e+02_r8,1.9153e+02_r8,9.5770e+01_r8,1.2054e+00_r8/)
      kbo(:, 4,16,13) = (/ &
     &4.8856e+02_r8,3.6642e+02_r8,2.4427e+02_r8,1.2213e+02_r8,1.2630e+00_r8/)
      kbo(:, 5,16,13) = (/ &
     &6.0471e+02_r8,4.5354e+02_r8,3.0235e+02_r8,1.5118e+02_r8,1.5611e+00_r8/)
      kbo(:, 1,17,13) = (/ &
     &2.0589e+02_r8,1.5442e+02_r8,1.0294e+02_r8,5.1473e+01_r8,7.0898e-01_r8/)
      kbo(:, 2,17,13) = (/ &
     &2.8383e+02_r8,2.1287e+02_r8,1.4191e+02_r8,7.0957e+01_r8,8.7566e-01_r8/)
      kbo(:, 3,17,13) = (/ &
     &3.7354e+02_r8,2.8016e+02_r8,1.8678e+02_r8,9.3389e+01_r8,1.0083e+00_r8/)
      kbo(:, 4,17,13) = (/ &
     &4.7406e+02_r8,3.5553e+02_r8,2.3702e+02_r8,1.1851e+02_r8,1.2409e+00_r8/)
      kbo(:, 5,17,13) = (/ &
     &5.8252e+02_r8,4.3688e+02_r8,2.9126e+02_r8,1.4563e+02_r8,1.5701e+00_r8/)
      kbo(:, 1,18,13) = (/ &
     &1.9631e+02_r8,1.4723e+02_r8,9.8151e+01_r8,4.9076e+01_r8,6.5277e-01_r8/)
      kbo(:, 2,18,13) = (/ &
     &2.6794e+02_r8,2.0095e+02_r8,1.3397e+02_r8,6.6983e+01_r8,7.9253e-01_r8/)
      kbo(:, 3,18,13) = (/ &
     &3.5060e+02_r8,2.6297e+02_r8,1.7531e+02_r8,8.7658e+01_r8,9.7984e-01_r8/)
      kbo(:, 4,18,13) = (/ &
     &4.4214e+02_r8,3.3161e+02_r8,2.2107e+02_r8,1.1054e+02_r8,1.2414e+00_r8/)
      kbo(:, 5,18,13) = (/ &
     &5.4117e+02_r8,4.0586e+02_r8,2.7058e+02_r8,1.3530e+02_r8,1.5487e+00_r8/)
      kbo(:, 1,19,13) = (/ &
     &1.8546e+02_r8,1.3909e+02_r8,9.2728e+01_r8,4.6396e+01_r8,6.1789e-01_r8/)
      kbo(:, 2,19,13) = (/ &
     &2.5191e+02_r8,1.8893e+02_r8,1.2596e+02_r8,6.3020e+01_r8,7.3049e-01_r8/)
      kbo(:, 3,19,13) = (/ &
     &3.2752e+02_r8,2.4563e+02_r8,1.6376e+02_r8,8.1963e+01_r8,9.1418e-01_r8/)
      kbo(:, 4,19,13) = (/ &
     &4.1109e+02_r8,3.0832e+02_r8,2.0555e+02_r8,1.0295e+02_r8,1.1663e+00_r8/)
      kbo(:, 5,19,13) = (/ &
     &5.0069e+02_r8,3.7554e+02_r8,2.5035e+02_r8,1.2551e+02_r8,1.4682e+00_r8/)
      kbo(:, 1,20,13) = (/ &
     &1.7660e+02_r8,1.3245e+02_r8,8.8301e+01_r8,4.4344e+01_r8,5.8624e-01_r8/)
      kbo(:, 2,20,13) = (/ &
     &2.3782e+02_r8,1.7835e+02_r8,1.1891e+02_r8,5.9734e+01_r8,7.0627e-01_r8/)
      kbo(:, 3,20,13) = (/ &
     &3.0729e+02_r8,2.3046e+02_r8,1.5365e+02_r8,7.7248e+01_r8,8.6369e-01_r8/)
      kbo(:, 4,20,13) = (/ &
     &3.8357e+02_r8,2.8768e+02_r8,1.9179e+02_r8,9.6513e+01_r8,1.0255e+00_r8/)
      kbo(:, 5,20,13) = (/ &
     &4.6652e+02_r8,3.4991e+02_r8,2.3327e+02_r8,1.1751e+02_r8,1.3105e+00_r8/)
      kbo(:, 1,21,13) = (/ &
     &1.6552e+02_r8,1.2414e+02_r8,8.2761e+01_r8,4.1834e+01_r8,5.4233e-01_r8/)
      kbo(:, 2,21,13) = (/ &
     &2.2144e+02_r8,1.6608e+02_r8,1.1072e+02_r8,5.6006e+01_r8,6.6551e-01_r8/)
      kbo(:, 3,21,13) = (/ &
     &2.8447e+02_r8,2.1334e+02_r8,1.4223e+02_r8,7.2029e+01_r8,7.8267e-01_r8/)
      kbo(:, 4,21,13) = (/ &
     &3.5426e+02_r8,2.6570e+02_r8,1.7714e+02_r8,8.9791e+01_r8,9.3322e-01_r8/)
      kbo(:, 5,21,13) = (/ &
     &4.3028e+02_r8,3.2271e+02_r8,2.1513e+02_r8,1.0915e+02_r8,1.1469e+00_r8/)
      kbo(:, 1,22,13) = (/ &
     &1.5536e+02_r8,1.1652e+02_r8,7.7681e+01_r8,3.9611e+01_r8,5.1617e-01_r8/)
      kbo(:, 2,22,13) = (/ &
     &2.0596e+02_r8,1.5446e+02_r8,1.0298e+02_r8,5.2572e+01_r8,6.2474e-01_r8/)
      kbo(:, 3,22,13) = (/ &
     &2.6312e+02_r8,1.9733e+02_r8,1.3157e+02_r8,6.7220e+01_r8,7.4033e-01_r8/)
      kbo(:, 4,22,13) = (/ &
     &3.2670e+02_r8,2.4500e+02_r8,1.6337e+02_r8,8.3538e+01_r8,8.8562e-01_r8/)
      kbo(:, 5,22,13) = (/ &
     &3.9539e+02_r8,2.9656e+02_r8,1.9778e+02_r8,1.0126e+02_r8,1.0777e+00_r8/)
      kbo(:, 1,23,13) = (/ &
     &1.4370e+02_r8,1.0779e+02_r8,7.1941e+01_r8,3.6979e+01_r8,5.0881e-01_r8/)
      kbo(:, 2,23,13) = (/ &
     &1.8910e+02_r8,1.4182e+02_r8,9.4675e+01_r8,4.8747e+01_r8,5.9561e-01_r8/)
      kbo(:, 3,23,13) = (/ &
     &2.4065e+02_r8,1.8048e+02_r8,1.2051e+02_r8,6.2134e+01_r8,7.0317e-01_r8/)
      kbo(:, 4,23,13) = (/ &
     &2.9775e+02_r8,2.2332e+02_r8,1.4916e+02_r8,7.6994e+01_r8,8.5956e-01_r8/)
      kbo(:, 5,23,13) = (/ &
     &3.5987e+02_r8,2.6990e+02_r8,1.8034e+02_r8,9.3182e+01_r8,1.0114e+00_r8/)
      kbo(:, 1,24,13) = (/ &
     &1.3242e+02_r8,9.9313e+01_r8,6.6507e+01_r8,3.4403e+01_r8,4.7778e-01_r8/)
      kbo(:, 2,24,13) = (/ &
     &1.7334e+02_r8,1.3001e+02_r8,8.7073e+01_r8,4.5133e+01_r8,5.5652e-01_r8/)
      kbo(:, 3,24,13) = (/ &
     &2.1981e+02_r8,1.6486e+02_r8,1.1045e+02_r8,5.7389e+01_r8,6.8303e-01_r8/)
      kbo(:, 4,24,13) = (/ &
     &2.7150e+02_r8,2.0360e+02_r8,1.3644e+02_r8,7.1035e+01_r8,8.3312e-01_r8/)
      kbo(:, 5,24,13) = (/ &
     &3.2837e+02_r8,2.4630e+02_r8,1.6509e+02_r8,8.6103e+01_r8,9.5638e-01_r8/)
      kbo(:, 1,25,13) = (/ &
     &1.2137e+02_r8,9.1042e+01_r8,6.1224e+01_r8,3.1886e+01_r8,4.5611e-01_r8/)
      kbo(:, 2,25,13) = (/ &
     &1.5823e+02_r8,1.1867e+02_r8,7.9841e+01_r8,4.1707e+01_r8,5.3430e-01_r8/)
      kbo(:, 3,25,13) = (/ &
     &2.0017e+02_r8,1.5012e+02_r8,1.0102e+02_r8,5.2903e+01_r8,6.6826e-01_r8/)
      kbo(:, 4,25,13) = (/ &
     &2.4727e+02_r8,1.8545e+02_r8,1.2481e+02_r8,6.5530e+01_r8,7.9106e-01_r8/)
      kbo(:, 5,25,13) = (/ &
     &2.9868e+02_r8,2.2401e+02_r8,1.5081e+02_r8,7.9363e+01_r8,9.2773e-01_r8/)
      kbo(:, 1,26,13) = (/ &
     &1.1166e+02_r8,8.3750e+01_r8,5.6641e+01_r8,2.9761e+01_r8,4.3741e-01_r8/)
      kbo(:, 2,26,13) = (/ &
     &1.4505e+02_r8,1.0880e+02_r8,7.3586e+01_r8,3.8778e+01_r8,5.3620e-01_r8/)
      kbo(:, 3,26,13) = (/ &
     &1.8336e+02_r8,1.3753e+02_r8,9.3041e+01_r8,4.9168e+01_r8,6.5727e-01_r8/)
      kbo(:, 4,26,13) = (/ &
     &2.2613e+02_r8,1.6961e+02_r8,1.1481e+02_r8,6.0809e+01_r8,7.5877e-01_r8/)
      kbo(:, 5,26,13) = (/ &
     &2.7339e+02_r8,2.0507e+02_r8,1.3883e+02_r8,7.3616e+01_r8,9.0221e-01_r8/)
      kbo(:, 1,27,13) = (/ &
     &1.0286e+02_r8,7.7197e+01_r8,5.2520e+01_r8,2.7881e+01_r8,4.2067e-01_r8/)
      kbo(:, 2,27,13) = (/ &
     &1.3339e+02_r8,1.0010e+02_r8,6.8159e+01_r8,3.6272e+01_r8,5.2994e-01_r8/)
      kbo(:, 3,27,13) = (/ &
     &1.6841e+02_r8,1.2640e+02_r8,8.6087e+01_r8,4.5886e+01_r8,6.2144e-01_r8/)
      kbo(:, 4,27,13) = (/ &
     &2.0796e+02_r8,1.5610e+02_r8,1.0629e+02_r8,5.6702e+01_r8,7.2963e-01_r8/)
      kbo(:, 5,27,13) = (/ &
     &2.5159e+02_r8,1.8888e+02_r8,1.2865e+02_r8,6.8691e+01_r8,8.6563e-01_r8/)
      kbo(:, 1,28,13) = (/ &
     &9.5256e+01_r8,7.1619e+01_r8,4.8936e+01_r8,2.6277e+01_r8,4.0676e-01_r8/)
      kbo(:, 2,28,13) = (/ &
     &1.2337e+02_r8,9.2726e+01_r8,6.3443e+01_r8,3.4072e+01_r8,4.9978e-01_r8/)
      kbo(:, 3,28,13) = (/ &
     &1.5583e+02_r8,1.1712e+02_r8,8.0174e+01_r8,4.3046e+01_r8,5.7218e-01_r8/)
      kbo(:, 4,28,13) = (/ &
     &1.9223e+02_r8,1.4447e+02_r8,9.8926e+01_r8,5.3164e+01_r8,6.9683e-01_r8/)
      kbo(:, 5,28,13) = (/ &
     &2.3315e+02_r8,1.7521e+02_r8,1.1992e+02_r8,6.4418e+01_r8,8.1878e-01_r8/)
      kbo(:, 1,29,13) = (/ &
     &8.8532e+01_r8,6.6695e+01_r8,4.5757e+01_r8,2.4810e+01_r8,3.8492e-01_r8/)
      kbo(:, 2,29,13) = (/ &
     &1.1463e+02_r8,8.6325e+01_r8,5.9300e+01_r8,3.2087e+01_r8,4.4646e-01_r8/)
      kbo(:, 3,29,13) = (/ &
     &1.4438e+02_r8,1.0869e+02_r8,7.4772e+01_r8,4.0468e+01_r8,5.3953e-01_r8/)
      kbo(:, 4,29,13) = (/ &
     &1.7851e+02_r8,1.3434e+02_r8,9.2412e+01_r8,4.9954e+01_r8,6.4107e-01_r8/)
      kbo(:, 5,29,13) = (/ &
     &2.1752e+02_r8,1.6365e+02_r8,1.1246e+02_r8,6.0724e+01_r8,7.6365e-01_r8/)
      kbo(:, 1,30,13) = (/ &
     &8.2710e+01_r8,6.2476e+01_r8,4.3045e+01_r8,2.3511e+01_r8,3.4189e-01_r8/)
      kbo(:, 2,30,13) = (/ &
     &1.0675e+02_r8,8.0586e+01_r8,5.5620e+01_r8,3.0345e+01_r8,4.0578e-01_r8/)
      kbo(:, 3,30,13) = (/ &
     &1.3482e+02_r8,1.0169e+02_r8,7.0226e+01_r8,3.8224e+01_r8,5.0418e-01_r8/)
      kbo(:, 4,30,13) = (/ &
     &1.6752e+02_r8,1.2628e+02_r8,8.7179e+01_r8,4.7334e+01_r8,5.9789e-01_r8/)
      kbo(:, 5,30,13) = (/ &
     &2.0548e+02_r8,1.5477e+02_r8,1.0678e+02_r8,5.7811e+01_r8,7.2304e-01_r8/)
      kbo(:, 1,31,13) = (/ &
     &7.6989e+01_r8,5.8322e+01_r8,4.0414e+01_r8,2.2252e+01_r8,3.0592e-01_r8/)
      kbo(:, 2,31,13) = (/ &
     &9.9596e+01_r8,7.5380e+01_r8,5.2274e+01_r8,2.8707e+01_r8,3.7677e-01_r8/)
      kbo(:, 3,31,13) = (/ &
     &1.2653e+02_r8,9.5656e+01_r8,6.6313e+01_r8,3.6293e+01_r8,4.5864e-01_r8/)
      kbo(:, 4,31,13) = (/ &
     &1.5839e+02_r8,1.1960e+02_r8,8.2835e+01_r8,4.5152e+01_r8,5.5168e-01_r8/)
      kbo(:, 5,31,13) = (/ &
     &1.9525e+02_r8,1.4733e+02_r8,1.0199e+02_r8,5.5418e+01_r8,6.7878e-01_r8/)
      kbo(:, 1,32,13) = (/ &
     &7.2617e+01_r8,5.5198e+01_r8,3.8454e+01_r8,2.1285e+01_r8,2.7831e-01_r8/)
      kbo(:, 2,32,13) = (/ &
     &9.4496e+01_r8,7.1727e+01_r8,4.9927e+01_r8,2.7539e+01_r8,3.4616e-01_r8/)
      kbo(:, 3,32,13) = (/ &
     &1.2095e+02_r8,9.1662e+01_r8,6.3739e+01_r8,3.5032e+01_r8,4.1226e-01_r8/)
      kbo(:, 4,32,13) = (/ &
     &1.5220e+02_r8,1.1521e+02_r8,8.0042e+01_r8,4.3833e+01_r8,5.1531e-01_r8/)
      kbo(:, 5,32,13) = (/ &
     &1.8837e+02_r8,1.4240e+02_r8,9.8836e+01_r8,5.3991e+01_r8,6.4895e-01_r8/)
      kbo(:, 1,33,13) = (/ &
     &6.9586e+01_r8,5.3075e+01_r8,3.7119e+01_r8,2.0620e+01_r8,2.5421e-01_r8/)
      kbo(:, 2,33,13) = (/ &
     &9.1190e+01_r8,6.9432e+01_r8,4.8467e+01_r8,2.6834e+01_r8,3.0964e-01_r8/)
      kbo(:, 3,33,13) = (/ &
     &1.1725e+02_r8,8.9117e+01_r8,6.2134e+01_r8,3.4318e+01_r8,3.8320e-01_r8/)
      kbo(:, 4,33,13) = (/ &
     &1.4810e+02_r8,1.1236e+02_r8,7.8257e+01_r8,4.3108e+01_r8,4.8588e-01_r8/)
      kbo(:, 5,33,13) = (/ &
     &1.8404e+02_r8,1.3940e+02_r8,9.6928e+01_r8,5.3246e+01_r8,6.2021e-01_r8/)
      kbo(:, 1,34,13) = (/ &
     &6.7703e+01_r8,5.1785e+01_r8,3.6334e+01_r8,2.0214e+01_r8,2.2826e-01_r8/)
      kbo(:, 2,34,13) = (/ &
     &8.9165e+01_r8,6.8046e+01_r8,4.7643e+01_r8,2.6485e+01_r8,2.7978e-01_r8/)
      kbo(:, 3,34,13) = (/ &
     &1.1511e+02_r8,8.7692e+01_r8,6.1290e+01_r8,3.4007e+01_r8,3.5723e-01_r8/)
      kbo(:, 4,34,13) = (/ &
     &1.4598e+02_r8,1.1096e+02_r8,7.7422e+01_r8,4.2877e+01_r8,4.6377e-01_r8/)
      kbo(:, 5,34,13) = (/ &
     &1.8238e+02_r8,1.3836e+02_r8,9.6327e+01_r8,5.3168e+01_r8,5.7690e-01_r8/)
      kbo(:, 1,35,13) = (/ &
     &6.4861e+01_r8,4.9746e+01_r8,3.5026e+01_r8,1.9551e+01_r8,2.0156e-01_r8/)
      kbo(:, 2,35,13) = (/ &
     &8.5976e+01_r8,6.5785e+01_r8,4.6175e+01_r8,2.5782e+01_r8,2.5401e-01_r8/)
      kbo(:, 3,35,13) = (/ &
     &1.1165e+02_r8,8.5245e+01_r8,5.9716e+01_r8,3.3273e+01_r8,3.2846e-01_r8/)
      kbo(:, 4,35,13) = (/ &
     &1.4250e+02_r8,1.0853e+02_r8,7.5838e+01_r8,4.2162e+01_r8,4.2675e-01_r8/)
      kbo(:, 5,35,13) = (/ &
     &1.7910e+02_r8,1.3608e+02_r8,9.4891e+01_r8,5.2581e+01_r8,5.2256e-01_r8/)
      kbo(:, 1,36,13) = (/ &
     &6.0764e+01_r8,4.6732e+01_r8,3.3052e+01_r8,1.8514e+01_r8,1.7227e-01_r8/)
      kbo(:, 2,36,13) = (/ &
     &8.1347e+01_r8,6.2416e+01_r8,4.3933e+01_r8,2.4619e+01_r8,2.3170e-01_r8/)
      kbo(:, 3,36,13) = (/ &
     &1.0653e+02_r8,8.1514e+01_r8,5.7203e+01_r8,3.2018e+01_r8,2.9859e-01_r8/)
      kbo(:, 4,36,13) = (/ &
     &1.3711e+02_r8,1.0461e+02_r8,7.3196e+01_r8,4.0838e+01_r8,3.8265e-01_r8/)
      kbo(:, 5,36,13) = (/ &
     &1.7349e+02_r8,1.3202e+02_r8,9.2179e+01_r8,5.1271e+01_r8,4.7154e-01_r8/)
      kbo(:, 1,37,13) = (/ &
     &5.5040e+01_r8,4.2456e+01_r8,3.0166e+01_r8,1.6967e+01_r8,1.4686e-01_r8/)
      kbo(:, 2,37,13) = (/ &
     &7.4751e+01_r8,5.7522e+01_r8,4.0627e+01_r8,2.2828e+01_r8,1.9745e-01_r8/)
      kbo(:, 3,37,13) = (/ &
     &9.9126e+01_r8,7.6001e+01_r8,5.3446e+01_r8,3.0003e+01_r8,2.5830e-01_r8/)
      kbo(:, 4,37,13) = (/ &
     &1.2888e+02_r8,9.8527e+01_r8,6.9056e+01_r8,3.8643e+01_r8,3.3278e-01_r8/)
      kbo(:, 5,37,13) = (/ &
     &1.6453e+02_r8,1.2541e+02_r8,8.7685e+01_r8,4.8918e+01_r8,4.1260e-01_r8/)
      kbo(:, 1,38,13) = (/ &
     &4.9859e+01_r8,3.8586e+01_r8,2.7550e+01_r8,1.5547e+01_r8,1.2396e-01_r8/)
      kbo(:, 2,38,13) = (/ &
     &6.8738e+01_r8,5.3032e+01_r8,3.7612e+01_r8,2.1200e+01_r8,1.6720e-01_r8/)
      kbo(:, 3,38,13) = (/ &
     &9.2373e+01_r8,7.0999e+01_r8,5.0053e+01_r8,2.8170e+01_r8,2.2370e-01_r8/)
      kbo(:, 4,38,13) = (/ &
     &1.2130e+02_r8,9.2918e+01_r8,6.5279e+01_r8,3.6626e+01_r8,2.8704e-01_r8/)
      kbo(:, 5,38,13) = (/ &
     &1.5627e+02_r8,1.1930e+02_r8,8.3547e+01_r8,4.6739e+01_r8,3.6180e-01_r8/)
      kbo(:, 1,39,13) = (/ &
     &4.5302e+01_r8,3.5171e+01_r8,2.5236e+01_r8,1.4286e+01_r8,1.0568e-01_r8/)
      kbo(:, 2,39,13) = (/ &
     &6.3391e+01_r8,4.9041e+01_r8,3.4923e+01_r8,1.9751e+01_r8,1.4249e-01_r8/)
      kbo(:, 3,39,13) = (/ &
     &8.6323e+01_r8,6.6507e+01_r8,4.7040e+01_r8,2.6533e+01_r8,1.9303e-01_r8/)
      kbo(:, 4,39,13) = (/ &
     &1.1457e+02_r8,8.7914e+01_r8,6.1899e+01_r8,3.4824e+01_r8,2.4868e-01_r8/)
      kbo(:, 5,39,13) = (/ &
     &1.4887e+02_r8,1.1383e+02_r8,7.9847e+01_r8,4.4779e+01_r8,3.1416e-01_r8/)
      kbo(:, 1,40,13) = (/ &
     &4.0177e+01_r8,3.1298e+01_r8,2.2565e+01_r8,1.2805e+01_r8,8.8138e-02_r8/)
      kbo(:, 2,40,13) = (/ &
     &5.7199e+01_r8,4.4376e+01_r8,3.1743e+01_r8,1.8006e+01_r8,1.1856e-01_r8/)
      kbo(:, 3,40,13) = (/ &
     &7.9150e+01_r8,6.1135e+01_r8,4.3398e+01_r8,2.4540e+01_r8,1.6359e-01_r8/)
      kbo(:, 4,40,13) = (/ &
     &1.0651e+02_r8,8.1890e+01_r8,5.7786e+01_r8,3.2576e+01_r8,2.1421e-01_r8/)
      kbo(:, 5,40,13) = (/ &
     &1.3985e+02_r8,1.0710e+02_r8,7.5255e+01_r8,4.2282e+01_r8,2.7560e-01_r8/)
      kbo(:, 1,41,13) = (/ &
     &3.5483e+01_r8,2.7745e+01_r8,2.0104e+01_r8,1.1435e+01_r8,7.4578e-02_r8/)
      kbo(:, 2,41,13) = (/ &
     &5.1443e+01_r8,4.0033e+01_r8,2.8766e+01_r8,1.6358e+01_r8,1.0080e-01_r8/)
      kbo(:, 3,41,13) = (/ &
     &7.2353e+01_r8,5.6024e+01_r8,3.9928e+01_r8,2.2644e+01_r8,1.3798e-01_r8/)
      kbo(:, 4,41,13) = (/ &
     &9.8821e+01_r8,7.6124e+01_r8,5.3862e+01_r8,3.0414e+01_r8,1.8395e-01_r8/)
      kbo(:, 5,41,13) = (/ &
     &1.3121e+02_r8,1.0062e+02_r8,7.0817e+01_r8,3.9858e+01_r8,2.3971e-01_r8/)
      kbo(:, 1,42,13) = (/ &
     &3.1312e+01_r8,2.4582e+01_r8,1.7898e+01_r8,1.0203e+01_r8,6.3311e-02_r8/)
      kbo(:, 2,42,13) = (/ &
     &4.6257e+01_r8,3.6106e+01_r8,2.6059e+01_r8,1.4850e+01_r8,8.5987e-02_r8/)
      kbo(:, 3,42,13) = (/ &
     &6.6134e+01_r8,5.1324e+01_r8,3.6711e+01_r8,2.0879e+01_r8,1.1696e-01_r8/)
      kbo(:, 4,42,13) = (/ &
     &9.1649e+01_r8,7.0739e+01_r8,5.0191e+01_r8,2.8396e+01_r8,1.5868e-01_r8/)
      kbo(:, 5,42,13) = (/ &
     &1.2315e+02_r8,9.4550e+01_r8,6.6649e+01_r8,3.7570e+01_r8,2.0886e-01_r8/)
      kbo(:, 1,43,13) = (/ &
     &2.7228e+01_r8,2.1458e+01_r8,1.5694e+01_r8,8.9614e+00_r8,5.3608e-02_r8/)
      kbo(:, 2,43,13) = (/ &
     &4.1053e+01_r8,3.2140e+01_r8,2.3306e+01_r8,1.3302e+01_r8,7.1800e-02_r8/)
      kbo(:, 3,43,13) = (/ &
     &5.9801e+01_r8,4.6516e+01_r8,3.3390e+01_r8,1.9030e+01_r8,9.7105e-02_r8/)
      kbo(:, 4,43,13) = (/ &
     &8.4239e+01_r8,6.5135e+01_r8,4.6335e+01_r8,2.6274e+01_r8,1.3391e-01_r8/)
      kbo(:, 5,43,13) = (/ &
     &1.1479e+02_r8,8.8247e+01_r8,6.2314e+01_r8,3.5145e+01_r8,1.7840e-01_r8/)
      kbo(:, 1,44,13) = (/ &
     &2.3465e+01_r8,1.8562e+01_r8,1.3638e+01_r8,7.7925e+00_r8,4.4874e-02_r8/)
      kbo(:, 2,44,13) = (/ &
     &3.6146e+01_r8,2.8382e+01_r8,2.0672e+01_r8,1.1814e+01_r8,5.9063e-02_r8/)
      kbo(:, 3,44,13) = (/ &
     &5.3714e+01_r8,4.1873e+01_r8,3.0165e+01_r8,1.7212e+01_r8,7.9828e-02_r8/)
      kbo(:, 4,44,13) = (/ &
     &7.6981e+01_r8,5.9614e+01_r8,4.2519e+01_r8,2.4160e+01_r8,1.1248e-01_r8/)
      kbo(:, 5,44,13) = (/ &
     &1.0651e+02_r8,8.1983e+01_r8,5.8013e+01_r8,3.2734e+01_r8,1.4901e-01_r8/)
      kbo(:, 1,45,13) = (/ &
     &2.0186e+01_r8,1.6021e+01_r8,1.1808e+01_r8,6.7511e+00_r8,3.7575e-02_r8/)
      kbo(:, 2,45,13) = (/ &
     &3.1735e+01_r8,2.4996e+01_r8,1.8280e+01_r8,1.0459e+01_r8,4.9524e-02_r8/)
      kbo(:, 3,45,13) = (/ &
     &4.8111e+01_r8,3.7595e+01_r8,2.7182e+01_r8,1.5526e+01_r8,6.7700e-02_r8/)
      kbo(:, 4,45,13) = (/ &
     &7.0180e+01_r8,5.4438e+01_r8,3.8926e+01_r8,2.2155e+01_r8,9.2168e-02_r8/)
      kbo(:, 5,45,13) = (/ &
     &9.8620e+01_r8,7.6015e+01_r8,5.3889e+01_r8,3.0449e+01_r8,1.2546e-01_r8/)
      kbo(:, 1,46,13) = (/ &
     &1.7168e+01_r8,1.3674e+01_r8,1.0102e+01_r8,5.7721e+00_r8,3.1506e-02_r8/)
      kbo(:, 2,46,13) = (/ &
     &2.7551e+01_r8,2.1759e+01_r8,1.5975e+01_r8,9.1472e+00_r8,4.1368e-02_r8/)
      kbo(:, 3,46,13) = (/ &
     &4.2631e+01_r8,3.3389e+01_r8,2.4233e+01_r8,1.3855e+01_r8,5.6581e-02_r8/)
      kbo(:, 4,46,13) = (/ &
     &6.3374e+01_r8,4.9245e+01_r8,3.5311e+01_r8,2.0117e+01_r8,7.4981e-02_r8/)
      kbo(:, 5,46,13) = (/ &
     &9.0545e+01_r8,6.9872e+01_r8,4.9627e+01_r8,2.8091e+01_r8,1.0356e-01_r8/)
      kbo(:, 1,47,13) = (/ &
     &1.4285e+01_r8,1.1420e+01_r8,8.4474e+00_r8,4.8173e+00_r8,2.6647e-02_r8/)
      kbo(:, 2,47,13) = (/ &
     &2.3421e+01_r8,1.8547e+01_r8,1.3658e+01_r8,7.8222e+00_r8,3.5142e-02_r8/)
      kbo(:, 3,47,13) = (/ &
     &3.7014e+01_r8,2.9064e+01_r8,2.1182e+01_r8,1.2119e+01_r8,4.6223e-02_r8/)
      kbo(:, 4,47,13) = (/ &
     &5.6196e+01_r8,4.3754e+01_r8,3.1477e+01_r8,1.7951e+01_r8,6.2561e-02_r8/)
      kbo(:, 5,47,13) = (/ &
     &8.1804e+01_r8,6.3215e+01_r8,4.5000e+01_r8,2.5512e+01_r8,8.4936e-02_r8/)
      kbo(:, 1,48,13) = (/ &
     &1.1839e+01_r8,9.5013e+00_r8,7.0342e+00_r8,3.9991e+00_r8,2.2276e-02_r8/)
      kbo(:, 2,48,13) = (/ &
     &1.9820e+01_r8,1.5737e+01_r8,1.1620e+01_r8,6.6464e+00_r8,2.9148e-02_r8/)
      kbo(:, 3,48,13) = (/ &
     &3.1994e+01_r8,2.5174e+01_r8,1.8417e+01_r8,1.0540e+01_r8,3.8297e-02_r8/)
      kbo(:, 4,48,13) = (/ &
     &4.9572e+01_r8,3.8675e+01_r8,2.7923e+01_r8,1.5936e+01_r8,5.2300e-02_r8/)
      kbo(:, 5,48,13) = (/ &
     &7.3600e+01_r8,5.6966e+01_r8,4.0638e+01_r8,2.3068e+01_r8,6.9650e-02_r8/)
      kbo(:, 1,49,13) = (/ &
     &9.7471e+00_r8,7.8584e+00_r8,5.8267e+00_r8,3.3020e+00_r8,1.8196e-02_r8/)
      kbo(:, 2,49,13) = (/ &
     &1.6704e+01_r8,1.3302e+01_r8,9.8376e+00_r8,5.6165e+00_r8,2.4552e-02_r8/)
      kbo(:, 3,49,13) = (/ &
     &2.7532e+01_r8,2.1706e+01_r8,1.5922e+01_r8,9.1112e+00_r8,3.1859e-02_r8/)
      kbo(:, 4,49,13) = (/ &
     &4.3516e+01_r8,3.4017e+01_r8,2.4645e+01_r8,1.4071e+01_r8,4.2368e-02_r8/)
      kbo(:, 5,49,13) = (/ &
     &6.5913e+01_r8,5.1094e+01_r8,3.6540e+01_r8,2.0762e+01_r8,5.7956e-02_r8/)
      kbo(:, 1,50,13) = (/ &
     &8.0804e+00_r8,6.5442e+00_r8,4.8528e+00_r8,2.7471e+00_r8,1.5480e-02_r8/)
      kbo(:, 2,50,13) = (/ &
     &1.4208e+01_r8,1.1343e+01_r8,8.3916e+00_r8,4.7793e+00_r8,2.1108e-02_r8/)
      kbo(:, 3,50,13) = (/ &
     &2.3865e+01_r8,1.8845e+01_r8,1.3856e+01_r8,7.9173e+00_r8,2.8070e-02_r8/)
      kbo(:, 4,50,13) = (/ &
     &3.8439e+01_r8,3.0084e+01_r8,2.1861e+01_r8,1.2484e+01_r8,3.6716e-02_r8/)
      kbo(:, 5,50,13) = (/ &
     &5.9311e+01_r8,4.6040e+01_r8,3.3007e+01_r8,1.8765e+01_r8,4.7982e-02_r8/)
      kbo(:, 1,51,13) = (/ &
     &6.6974e+00_r8,5.4506e+00_r8,4.0401e+00_r8,2.2835e+00_r8,1.2897e-02_r8/)
      kbo(:, 2,51,13) = (/ &
     &1.2105e+01_r8,9.6894e+00_r8,7.1742e+00_r8,4.0729e+00_r8,1.8234e-02_r8/)
      kbo(:, 3,51,13) = (/ &
     &2.0726e+01_r8,1.6392e+01_r8,1.2076e+01_r8,6.8856e+00_r8,2.4297e-02_r8/)
      kbo(:, 4,51,13) = (/ &
     &3.4010e+01_r8,2.6646e+01_r8,1.9402e+01_r8,1.1077e+01_r8,3.1447e-02_r8/)
      kbo(:, 5,51,13) = (/ &
     &5.3414e+01_r8,4.1508e+01_r8,2.9825e+01_r8,1.6965e+01_r8,4.1659e-02_r8/)
      kbo(:, 1,52,13) = (/ &
     &5.5139e+00_r8,4.5099e+00_r8,3.3452e+00_r8,1.8859e+00_r8,1.0839e-02_r8/)
      kbo(:, 2,52,13) = (/ &
     &1.0265e+01_r8,8.2392e+00_r8,6.1066e+00_r8,3.4594e+00_r8,1.5307e-02_r8/)
      kbo(:, 3,52,13) = (/ &
     &1.7969e+01_r8,1.4231e+01_r8,1.0492e+01_r8,5.9702e+00_r8,2.0782e-02_r8/)
      kbo(:, 4,52,13) = (/ &
     &3.0022e+01_r8,2.3539e+01_r8,1.7173e+01_r8,9.7942e+00_r8,2.7615e-02_r8/)
      kbo(:, 5,52,13) = (/ &
     &4.7976e+01_r8,3.7311e+01_r8,2.6868e+01_r8,1.5284e+01_r8,3.5883e-02_r8/)
      kbo(:, 1,53,13) = (/ &
     &4.5089e+00_r8,3.7050e+00_r8,2.7486e+00_r8,1.5449e+00_r8,8.8988e-03_r8/)
      kbo(:, 2,53,13) = (/ &
     &8.6595e+00_r8,6.9701e+00_r8,5.1646e+00_r8,2.9217e+00_r8,1.2928e-02_r8/)
      kbo(:, 3,53,13) = (/ &
     &1.5539e+01_r8,1.2324e+01_r8,9.0856e+00_r8,5.1569e+00_r8,1.7922e-02_r8/)
      kbo(:, 4,53,13) = (/ &
     &2.6425e+01_r8,2.0735e+01_r8,1.5153e+01_r8,8.6253e+00_r8,2.3907e-02_r8/)
      kbo(:, 5,53,13) = (/ &
     &4.2979e+01_r8,3.3444e+01_r8,2.4119e+01_r8,1.3719e+01_r8,3.1307e-02_r8/)
      kbo(:, 1,54,13) = (/ &
     &3.7369e+00_r8,3.0844e+00_r8,2.2855e+00_r8,1.2806e+00_r8,7.5969e-03_r8/)
      kbo(:, 2,54,13) = (/ &
     &7.3945e+00_r8,5.9700e+00_r8,4.4241e+00_r8,2.4976e+00_r8,1.1170e-02_r8/)
      kbo(:, 3,54,13) = (/ &
     &1.3610e+01_r8,1.0807e+01_r8,7.9714e+00_r8,4.5128e+00_r8,1.6129e-02_r8/)
      kbo(:, 4,54,13) = (/ &
     &2.3560e+01_r8,1.8494e+01_r8,1.3530e+01_r8,7.6837e+00_r8,2.1838e-02_r8/)
      kbo(:, 5,54,13) = (/ &
     &3.8949e+01_r8,3.0311e+01_r8,2.1882e+01_r8,1.2434e+01_r8,2.8239e-02_r8/)
      kbo(:, 1,55,13) = (/ &
     &3.1147e+00_r8,2.5777e+00_r8,1.9050e+00_r8,1.0637e+00_r8,6.5369e-03_r8/)
      kbo(:, 2,55,13) = (/ &
     &6.3439e+00_r8,5.1347e+00_r8,3.8054e+00_r8,2.1454e+00_r8,1.0024e-02_r8/)
      kbo(:, 3,55,13) = (/ &
     &1.1985e+01_r8,9.5229e+00_r8,7.0258e+00_r8,3.9713e+00_r8,1.4330e-02_r8/)
      kbo(:, 4,55,13) = (/ &
     &2.1145e+01_r8,1.6600e+01_r8,1.2148e+01_r8,6.8814e+00_r8,1.9929e-02_r8/)
      kbo(:, 5,55,13) = (/ &
     &3.5505e+01_r8,2.7628e+01_r8,1.9956e+01_r8,1.1323e+01_r8,2.6070e-02_r8/)
      kbo(:, 1,56,13) = (/ &
     &2.5841e+00_r8,2.1412e+00_r8,1.5792e+00_r8,8.7847e-01_r8,5.7272e-03_r8/)
      kbo(:, 2,56,13) = (/ &
     &5.4279e+00_r8,4.4047e+00_r8,3.2621e+00_r8,1.8370e+00_r8,9.0085e-03_r8/)
      kbo(:, 3,56,13) = (/ &
     &1.0541e+01_r8,8.3802e+00_r8,6.1801e+00_r8,3.4870e+00_r8,1.2894e-02_r8/)
      kbo(:, 4,56,13) = (/ &
     &1.8998e+01_r8,1.4914e+01_r8,1.0910e+01_r8,6.1631e+00_r8,1.8216e-02_r8/)
      kbo(:, 5,56,13) = (/ &
     &3.2387e+01_r8,2.5195e+01_r8,1.8200e+01_r8,1.0311e+01_r8,2.5017e-02_r8/)
      kbo(:, 1,57,13) = (/ &
     &2.1273e+00_r8,1.7663e+00_r8,1.2997e+00_r8,7.2182e-01_r8,4.9990e-03_r8/)
      kbo(:, 2,57,13) = (/ &
     &4.6288e+00_r8,3.7653e+00_r8,2.7876e+00_r8,1.5653e+00_r8,7.9939e-03_r8/)
      kbo(:, 3,57,13) = (/ &
     &9.2459e+00_r8,7.3572e+00_r8,5.4258e+00_r8,3.0550e+00_r8,1.1761e-02_r8/)
      kbo(:, 4,57,13) = (/ &
     &1.7067e+01_r8,1.3395e+01_r8,9.7952e+00_r8,5.5222e+00_r8,1.6851e-02_r8/)
      kbo(:, 5,57,13) = (/ &
     &2.9574e+01_r8,2.2993e+01_r8,1.6606e+01_r8,9.3912e+00_r8,2.2852e-02_r8/)
      kbo(:, 1,58,13) = (/ &
     &8.4744e-01_r8,8.1145e-01_r8,7.0194e-01_r8,4.7172e-01_r8,4.4639e-03_r8/)
      kbo(:, 2,58,13) = (/ &
     &1.9303e+00_r8,1.8049e+00_r8,1.5645e+00_r8,1.0595e+00_r8,7.1718e-03_r8/)
      kbo(:, 3,58,13) = (/ &
     &3.9593e+00_r8,3.6185e+00_r8,3.1318e+00_r8,2.1308e+00_r8,1.0759e-02_r8/)
      kbo(:, 4,58,13) = (/ &
     &7.4878e+00_r8,6.7423e+00_r8,5.7807e+00_r8,3.9390e+00_r8,1.5270e-02_r8/)
      kbo(:, 5,58,13) = (/ &
     &1.3201e+01_r8,1.1774e+01_r8,9.9717e+00_r8,6.8098e+00_r8,2.1046e-02_r8/)
      kbo(:, 1,59,13) = (/ &
     &7.8389e-01_r8,7.5361e-01_r8,6.5545e-01_r8,4.4390e-01_r8,4.7731e-03_r8/)
      kbo(:, 2,59,13) = (/ &
     &1.8316e+00_r8,1.7144e+00_r8,1.4906e+00_r8,1.0154e+00_r8,7.3182e-03_r8/)
      kbo(:, 3,59,13) = (/ &
     &3.8012e+00_r8,3.4796e+00_r8,3.0220e+00_r8,2.0697e+00_r8,1.0970e-02_r8/)
      kbo(:, 4,59,13) = (/ &
     &7.2668e+00_r8,6.5534e+00_r8,5.6332e+00_r8,3.8611e+00_r8,1.5317e-02_r8/)
      kbo(:, 5,59,13) = (/ &
     &1.2911e+01_r8,1.1536e+01_r8,9.7915e+00_r8,6.7229e+00_r8,2.2015e-02_r8/)
      kbo(:, 1,13,14) = (/ &
     &2.9725e+02_r8,2.2295e+02_r8,1.4862e+02_r8,7.4314e+01_r8,8.5883e-01_r8/)
      kbo(:, 2,13,14) = (/ &
     &4.1294e+02_r8,3.0971e+02_r8,2.0649e+02_r8,1.0324e+02_r8,7.4403e-01_r8/)
      kbo(:, 3,13,14) = (/ &
     &5.5502e+02_r8,4.1625e+02_r8,2.7751e+02_r8,1.3875e+02_r8,6.6008e-01_r8/)
      kbo(:, 4,13,14) = (/ &
     &7.2029e+02_r8,5.4024e+02_r8,3.6017e+02_r8,1.8008e+02_r8,1.1155e+00_r8/)
      kbo(:, 5,13,14) = (/ &
     &9.0592e+02_r8,6.7946e+02_r8,4.5296e+02_r8,2.2648e+02_r8,2.5465e+00_r8/)
      kbo(:, 1,14,14) = (/ &
     &3.2435e+02_r8,2.4326e+02_r8,1.6217e+02_r8,8.1092e+01_r8,7.8098e-01_r8/)
      kbo(:, 2,14,14) = (/ &
     &4.4892e+02_r8,3.3668e+02_r8,2.2444e+02_r8,1.1223e+02_r8,5.4602e-01_r8/)
      kbo(:, 3,14,14) = (/ &
     &6.0099e+02_r8,4.5075e+02_r8,3.0049e+02_r8,1.5025e+02_r8,1.0325e+00_r8/)
      kbo(:, 4,14,14) = (/ &
     &7.7937e+02_r8,5.8453e+02_r8,3.8969e+02_r8,1.9485e+02_r8,1.5016e+00_r8/)
      kbo(:, 5,14,14) = (/ &
     &9.8034e+02_r8,7.3527e+02_r8,4.9018e+02_r8,2.4510e+02_r8,3.4894e+00_r8/)
      kbo(:, 1,15,14) = (/ &
     &3.4430e+02_r8,2.5823e+02_r8,1.7215e+02_r8,8.6071e+01_r8,4.7442e-01_r8/)
      kbo(:, 2,15,14) = (/ &
     &4.7694e+02_r8,3.5770e+02_r8,2.3846e+02_r8,1.1924e+02_r8,9.8957e-01_r8/)
      kbo(:, 3,15,14) = (/ &
     &6.3659e+02_r8,4.7745e+02_r8,3.1829e+02_r8,1.5915e+02_r8,1.3277e+00_r8/)
      kbo(:, 4,15,14) = (/ &
     &8.2316e+02_r8,6.1735e+02_r8,4.1157e+02_r8,2.0578e+02_r8,2.6545e+00_r8/)
      kbo(:, 5,15,14) = (/ &
     &1.0339e+03_r8,7.7536e+02_r8,5.1695e+02_r8,2.5844e+02_r8,4.8753e+00_r8/)
      kbo(:, 1,16,14) = (/ &
     &3.6224e+02_r8,2.7168e+02_r8,1.8111e+02_r8,9.0555e+01_r8,8.6361e-01_r8/)
      kbo(:, 2,16,14) = (/ &
     &5.0155e+02_r8,3.7615e+02_r8,2.5077e+02_r8,1.2539e+02_r8,1.3098e+00_r8/)
      kbo(:, 3,16,14) = (/ &
     &6.6682e+02_r8,5.0012e+02_r8,3.3343e+02_r8,1.6672e+02_r8,2.0810e+00_r8/)
      kbo(:, 4,16,14) = (/ &
     &8.5980e+02_r8,6.4485e+02_r8,4.2990e+02_r8,2.1496e+02_r8,4.0118e+00_r8/)
      kbo(:, 5,16,14) = (/ &
     &1.0768e+03_r8,8.0756e+02_r8,5.3838e+02_r8,2.6919e+02_r8,6.0151e+00_r8/)
      kbo(:, 1,17,14) = (/ &
     &3.8011e+02_r8,2.8509e+02_r8,1.9007e+02_r8,9.5029e+01_r8,1.2720e+00_r8/)
      kbo(:, 2,17,14) = (/ &
     &5.2601e+02_r8,3.9448e+02_r8,2.6301e+02_r8,1.3150e+02_r8,1.5543e+00_r8/)
      kbo(:, 3,17,14) = (/ &
     &6.9761e+02_r8,5.2320e+02_r8,3.4880e+02_r8,1.7439e+02_r8,2.9841e+00_r8/)
      kbo(:, 4,17,14) = (/ &
     &8.9515e+02_r8,6.7136e+02_r8,4.4757e+02_r8,2.2378e+02_r8,4.6409e+00_r8/)
      kbo(:, 5,17,14) = (/ &
     &1.1181e+03_r8,8.3857e+02_r8,5.5903e+02_r8,2.7954e+02_r8,6.6157e+00_r8/)
      kbo(:, 1,18,14) = (/ &
     &3.9222e+02_r8,2.9415e+02_r8,1.9611e+02_r8,9.8051e+01_r8,1.3802e+00_r8/)
      kbo(:, 2,18,14) = (/ &
     &5.4105e+02_r8,4.0577e+02_r8,2.7053e+02_r8,1.3526e+02_r8,2.0079e+00_r8/)
      kbo(:, 3,18,14) = (/ &
     &7.1441e+02_r8,5.3583e+02_r8,3.5723e+02_r8,1.7861e+02_r8,3.3624e+00_r8/)
      kbo(:, 4,18,14) = (/ &
     &9.1265e+02_r8,6.8450e+02_r8,4.5632e+02_r8,2.2816e+02_r8,4.9650e+00_r8/)
      kbo(:, 5,18,14) = (/ &
     &1.1336e+03_r8,8.5015e+02_r8,5.6679e+02_r8,2.8338e+02_r8,6.8761e+00_r8/)
      kbo(:, 1,19,14) = (/ &
     &4.0839e+02_r8,3.0630e+02_r8,2.0420e+02_r8,1.0209e+02_r8,1.4198e+00_r8/)
      kbo(:, 2,19,14) = (/ &
     &5.5968e+02_r8,4.1977e+02_r8,2.7985e+02_r8,1.3992e+02_r8,2.2241e+00_r8/)
      kbo(:, 3,19,14) = (/ &
     &7.3637e+02_r8,5.5226e+02_r8,3.6818e+02_r8,1.8410e+02_r8,3.5653e+00_r8/)
      kbo(:, 4,19,14) = (/ &
     &9.3504e+02_r8,7.0126e+02_r8,4.6751e+02_r8,2.3375e+02_r8,5.1035e+00_r8/)
      kbo(:, 5,19,14) = (/ &
     &1.1560e+03_r8,8.6697e+02_r8,5.7801e+02_r8,2.8901e+02_r8,6.9044e+00_r8/)
      kbo(:, 1,20,14) = (/ &
     &4.2971e+02_r8,3.2229e+02_r8,2.1485e+02_r8,1.0743e+02_r8,1.5393e+00_r8/)
      kbo(:, 2,20,14) = (/ &
     &5.8587e+02_r8,4.3942e+02_r8,2.9293e+02_r8,1.4647e+02_r8,2.2601e+00_r8/)
      kbo(:, 3,20,14) = (/ &
     &7.6617e+02_r8,5.7464e+02_r8,3.8311e+02_r8,1.9155e+02_r8,3.5353e+00_r8/)
      kbo(:, 4,20,14) = (/ &
     &9.6798e+02_r8,7.2594e+02_r8,4.8398e+02_r8,2.4197e+02_r8,5.0919e+00_r8/)
      kbo(:, 5,20,14) = (/ &
     &1.1898e+03_r8,8.9235e+02_r8,5.9489e+02_r8,2.9744e+02_r8,6.7835e+00_r8/)
      kbo(:, 1,21,14) = (/ &
     &4.4889e+02_r8,3.3666e+02_r8,2.2444e+02_r8,1.1222e+02_r8,1.6427e+00_r8/)
      kbo(:, 2,21,14) = (/ &
     &6.0830e+02_r8,4.5623e+02_r8,3.0417e+02_r8,1.5208e+02_r8,2.2298e+00_r8/)
      kbo(:, 3,21,14) = (/ &
     &7.9080e+02_r8,5.9312e+02_r8,3.9541e+02_r8,1.9769e+02_r8,3.4367e+00_r8/)
      kbo(:, 4,21,14) = (/ &
     &9.9371e+02_r8,7.4527e+02_r8,4.9684e+02_r8,2.4842e+02_r8,4.8609e+00_r8/)
      kbo(:, 5,21,14) = (/ &
     &1.2155e+03_r8,9.1159e+02_r8,6.0771e+02_r8,3.0387e+02_r8,6.5479e+00_r8/)
      kbo(:, 1,22,14) = (/ &
     &4.7127e+02_r8,3.5343e+02_r8,2.3563e+02_r8,1.1782e+02_r8,1.6925e+00_r8/)
      kbo(:, 2,22,14) = (/ &
     &6.3239e+02_r8,4.7428e+02_r8,3.1618e+02_r8,1.5809e+02_r8,2.2427e+00_r8/)
      kbo(:, 3,22,14) = (/ &
     &8.1553e+02_r8,6.1164e+02_r8,4.0775e+02_r8,2.0390e+02_r8,3.3409e+00_r8/)
      kbo(:, 4,22,14) = (/ &
     &1.0189e+03_r8,7.6417e+02_r8,5.0944e+02_r8,2.5480e+02_r8,4.6697e+00_r8/)
      kbo(:, 5,22,14) = (/ &
     &1.2378e+03_r8,9.2835e+02_r8,6.1890e+02_r8,3.0965e+02_r8,6.2760e+00_r8/)
      kbo(:, 1,23,14) = (/ &
     &4.8713e+02_r8,3.6534e+02_r8,2.4356e+02_r8,1.2192e+02_r8,1.6599e+00_r8/)
      kbo(:, 2,23,14) = (/ &
     &6.4775e+02_r8,4.8583e+02_r8,3.2387e+02_r8,1.6212e+02_r8,2.1938e+00_r8/)
      kbo(:, 3,23,14) = (/ &
     &8.3023e+02_r8,6.2268e+02_r8,4.1512e+02_r8,2.0786e+02_r8,3.2003e+00_r8/)
      kbo(:, 4,23,14) = (/ &
     &1.0300e+03_r8,7.7249e+02_r8,5.1499e+02_r8,2.5803e+02_r8,4.4341e+00_r8/)
      kbo(:, 5,23,14) = (/ &
     &1.2450e+03_r8,9.3374e+02_r8,6.2249e+02_r8,3.1208e+02_r8,5.9729e+00_r8/)
      kbo(:, 1,24,14) = (/ &
     &5.0112e+02_r8,3.7583e+02_r8,2.5056e+02_r8,1.2575e+02_r8,1.5724e+00_r8/)
      kbo(:, 2,24,14) = (/ &
     &6.6153e+02_r8,4.9614e+02_r8,3.3076e+02_r8,1.6604e+02_r8,2.1250e+00_r8/)
      kbo(:, 3,24,14) = (/ &
     &8.4162e+02_r8,6.3120e+02_r8,4.2079e+02_r8,2.1132e+02_r8,3.0488e+00_r8/)
      kbo(:, 4,24,14) = (/ &
     &1.0387e+03_r8,7.7903e+02_r8,5.1934e+02_r8,2.6092e+02_r8,4.1964e+00_r8/)
      kbo(:, 5,24,14) = (/ &
     &1.2497e+03_r8,9.3727e+02_r8,6.2485e+02_r8,3.1407e+02_r8,5.6661e+00_r8/)
      kbo(:, 1,25,14) = (/ &
     &5.0957e+02_r8,3.8217e+02_r8,2.5479e+02_r8,1.2836e+02_r8,1.4865e+00_r8/)
      kbo(:, 2,25,14) = (/ &
     &6.6771e+02_r8,5.0078e+02_r8,3.3385e+02_r8,1.6824e+02_r8,2.0184e+00_r8/)
      kbo(:, 3,25,14) = (/ &
     &8.4466e+02_r8,6.3351e+02_r8,4.2233e+02_r8,2.1290e+02_r8,2.8760e+00_r8/)
      kbo(:, 4,25,14) = (/ &
     &1.0379e+03_r8,7.7843e+02_r8,5.1895e+02_r8,2.6171e+02_r8,3.9646e+00_r8/)
      kbo(:, 5,25,14) = (/ &
     &1.2454e+03_r8,9.3411e+02_r8,6.2273e+02_r8,3.1409e+02_r8,5.3432e+00_r8/)
      kbo(:, 1,26,14) = (/ &
     &5.1543e+02_r8,3.8657e+02_r8,2.5772e+02_r8,1.3040e+02_r8,1.4310e+00_r8/)
      kbo(:, 2,26,14) = (/ &
     &6.7055e+02_r8,5.0292e+02_r8,3.3528e+02_r8,1.6969e+02_r8,1.9779e+00_r8/)
      kbo(:, 3,26,14) = (/ &
     &8.4393e+02_r8,6.3294e+02_r8,4.2195e+02_r8,2.1362e+02_r8,2.7140e+00_r8/)
      kbo(:, 4,26,14) = (/ &
     &1.0339e+03_r8,7.7538e+02_r8,5.1691e+02_r8,2.6173e+02_r8,3.7614e+00_r8/)
      kbo(:, 5,26,14) = (/ &
     &1.2377e+03_r8,9.2822e+02_r8,6.1881e+02_r8,3.1339e+02_r8,5.0524e+00_r8/)
      kbo(:, 1,27,14) = (/ &
     &5.1680e+02_r8,3.8760e+02_r8,2.5844e+02_r8,1.3139e+02_r8,1.4644e+00_r8/)
      kbo(:, 2,27,14) = (/ &
     &6.6877e+02_r8,5.0158e+02_r8,3.3442e+02_r8,1.7006e+02_r8,1.9743e+00_r8/)
      kbo(:, 3,27,14) = (/ &
     &8.3912e+02_r8,6.2935e+02_r8,4.1964e+02_r8,2.1343e+02_r8,2.6423e+00_r8/)
      kbo(:, 4,27,14) = (/ &
     &1.0255e+03_r8,7.6907e+02_r8,5.1284e+02_r8,2.6091e+02_r8,3.5939e+00_r8/)
      kbo(:, 5,27,14) = (/ &
     &1.2273e+03_r8,9.2048e+02_r8,6.1378e+02_r8,3.1226e+02_r8,4.8265e+00_r8/)
      kbo(:, 1,28,14) = (/ &
     &5.1471e+02_r8,3.8604e+02_r8,2.5761e+02_r8,1.3161e+02_r8,1.4975e+00_r8/)
      kbo(:, 2,28,14) = (/ &
     &6.6390e+02_r8,4.9793e+02_r8,3.3227e+02_r8,1.6984e+02_r8,1.9755e+00_r8/)
      kbo(:, 3,28,14) = (/ &
     &8.3099e+02_r8,6.2328e+02_r8,4.1590e+02_r8,2.1266e+02_r8,2.6592e+00_r8/)
      kbo(:, 4,28,14) = (/ &
     &1.0159e+03_r8,7.6197e+02_r8,5.0842e+02_r8,2.5994e+02_r8,3.4854e+00_r8/)
      kbo(:, 5,28,14) = (/ &
     &1.2168e+03_r8,9.1262e+02_r8,6.0898e+02_r8,3.1138e+02_r8,4.6837e+00_r8/)
      kbo(:, 1,29,14) = (/ &
     &5.0817e+02_r8,3.8113e+02_r8,2.5474e+02_r8,1.3092e+02_r8,1.4861e+00_r8/)
      kbo(:, 2,29,14) = (/ &
     &6.5385e+02_r8,4.9038e+02_r8,3.2768e+02_r8,1.6851e+02_r8,1.9807e+00_r8/)
      kbo(:, 3,29,14) = (/ &
     &8.1862e+02_r8,6.1397e+02_r8,4.1013e+02_r8,2.1090e+02_r8,2.6083e+00_r8/)
      kbo(:, 4,29,14) = (/ &
     &1.0015e+03_r8,7.5115e+02_r8,5.0169e+02_r8,2.5799e+02_r8,3.4366e+00_r8/)
      kbo(:, 5,29,14) = (/ &
     &1.2004e+03_r8,9.0023e+02_r8,6.0130e+02_r8,3.0911e+02_r8,4.6309e+00_r8/)
      kbo(:, 1,30,14) = (/ &
     &4.9890e+02_r8,3.7416e+02_r8,2.5051e+02_r8,1.2967e+02_r8,1.4792e+00_r8/)
      kbo(:, 2,30,14) = (/ &
     &6.4183e+02_r8,4.8137e+02_r8,3.2213e+02_r8,1.6671e+02_r8,1.9639e+00_r8/)
      kbo(:, 3,30,14) = (/ &
     &8.0457e+02_r8,6.0342e+02_r8,4.0369e+02_r8,2.0889e+02_r8,2.5564e+00_r8/)
      kbo(:, 4,30,14) = (/ &
     &9.8521e+02_r8,7.3890e+02_r8,4.9415e+02_r8,2.5564e+02_r8,3.4162e+00_r8/)
      kbo(:, 5,30,14) = (/ &
     &1.1820e+03_r8,8.8651e+02_r8,5.9274e+02_r8,3.0646e+02_r8,4.6345e+00_r8/)
      kbo(:, 1,31,14) = (/ &
     &4.8682e+02_r8,3.6513e+02_r8,2.4494e+02_r8,1.2775e+02_r8,1.4549e+00_r8/)
      kbo(:, 2,31,14) = (/ &
     &6.2686e+02_r8,4.7014e+02_r8,3.1520e+02_r8,1.6432e+02_r8,1.8973e+00_r8/)
      kbo(:, 3,31,14) = (/ &
     &7.8640e+02_r8,5.8981e+02_r8,3.9524e+02_r8,2.0591e+02_r8,2.5203e+00_r8/)
      kbo(:, 4,31,14) = (/ &
     &9.6406e+02_r8,7.2305e+02_r8,4.8423e+02_r8,2.5217e+02_r8,3.4800e+00_r8/)
      kbo(:, 5,31,14) = (/ &
     &1.1586e+03_r8,8.6894e+02_r8,5.8171e+02_r8,3.0260e+02_r8,4.7311e+00_r8/)
      kbo(:, 1,32,14) = (/ &
     &4.7960e+02_r8,3.5970e+02_r8,2.4176e+02_r8,1.2713e+02_r8,1.4049e+00_r8/)
      kbo(:, 2,32,14) = (/ &
     &6.1788e+02_r8,4.6339e+02_r8,3.1125e+02_r8,1.6347e+02_r8,1.8610e+00_r8/)
      kbo(:, 3,32,14) = (/ &
     &7.7566e+02_r8,5.8175e+02_r8,3.9047e+02_r8,2.0479e+02_r8,2.5736e+00_r8/)
      kbo(:, 4,32,14) = (/ &
     &9.5231e+02_r8,7.1420e+02_r8,4.7904e+02_r8,2.5086e+02_r8,3.5724e+00_r8/)
      kbo(:, 5,32,14) = (/ &
     &1.1464e+03_r8,8.5978e+02_r8,5.7626e+02_r8,3.0128e+02_r8,4.8525e+00_r8/)
      kbo(:, 1,33,14) = (/ &
     &4.7673e+02_r8,3.5758e+02_r8,2.4086e+02_r8,1.2764e+02_r8,1.3592e+00_r8/)
      kbo(:, 2,33,14) = (/ &
     &6.1463e+02_r8,4.6099e+02_r8,3.1024e+02_r8,1.6404e+02_r8,1.8844e+00_r8/)
      kbo(:, 3,33,14) = (/ &
     &7.7253e+02_r8,5.7937e+02_r8,3.8948e+02_r8,2.0544e+02_r8,2.6672e+00_r8/)
      kbo(:, 4,33,14) = (/ &
     &9.4922e+02_r8,7.1189e+02_r8,4.7815e+02_r8,2.5158e+02_r8,3.7054e+00_r8/)
      kbo(:, 5,33,14) = (/ &
     &1.1446e+03_r8,8.5842e+02_r8,5.7603e+02_r8,3.0239e+02_r8,5.0353e+00_r8/)
      kbo(:, 1,34,14) = (/ &
     &4.7829e+02_r8,3.5882e+02_r8,2.4214e+02_r8,1.2917e+02_r8,1.3360e+00_r8/)
      kbo(:, 2,34,14) = (/ &
     &6.1765e+02_r8,4.6331e+02_r8,3.1226e+02_r8,1.6594e+02_r8,1.9203e+00_r8/)
      kbo(:, 3,34,14) = (/ &
     &7.7743e+02_r8,5.8310e+02_r8,3.9256e+02_r8,2.0792e+02_r8,2.7349e+00_r8/)
      kbo(:, 4,34,14) = (/ &
     &9.5686e+02_r8,7.1762e+02_r8,4.8256e+02_r8,2.5475e+02_r8,3.8031e+00_r8/)
      kbo(:, 5,34,14) = (/ &
     &1.1550e+03_r8,8.6629e+02_r8,5.8189e+02_r8,3.0631e+02_r8,5.2021e+00_r8/)
      kbo(:, 1,35,14) = (/ &
     &4.7226e+02_r8,3.5443e+02_r8,2.3957e+02_r8,1.2851e+02_r8,1.3086e+00_r8/)
      kbo(:, 2,35,14) = (/ &
     &6.1214e+02_r8,4.5923e+02_r8,3.0998e+02_r8,1.6546e+02_r8,1.9154e+00_r8/)
      kbo(:, 3,35,14) = (/ &
     &7.7280e+02_r8,5.7976e+02_r8,3.9077e+02_r8,2.0773e+02_r8,2.7357e+00_r8/)
      kbo(:, 4,35,14) = (/ &
     &9.5397e+02_r8,7.1554e+02_r8,4.8165e+02_r8,2.5508e+02_r8,3.8286e+00_r8/)
      kbo(:, 5,35,14) = (/ &
     &1.1540e+03_r8,8.6552e+02_r8,5.8187e+02_r8,3.0708e+02_r8,5.2636e+00_r8/)
      kbo(:, 1,36,14) = (/ &
     &4.5693e+02_r8,3.4301e+02_r8,2.3220e+02_r8,1.2520e+02_r8,1.2533e+00_r8/)
      kbo(:, 2,36,14) = (/ &
     &5.9574e+02_r8,4.4710e+02_r8,3.0221e+02_r8,1.6199e+02_r8,1.8411e+00_r8/)
      kbo(:, 3,36,14) = (/ &
     &7.5609e+02_r8,5.6723e+02_r8,3.8282e+02_r8,2.0421e+02_r8,2.6504e+00_r8/)
      kbo(:, 4,36,14) = (/ &
     &9.3751e+02_r8,7.0328e+02_r8,4.7386e+02_r8,2.5165e+02_r8,3.7407e+00_r8/)
      kbo(:, 5,36,14) = (/ &
     &1.1381e+03_r8,8.5353e+02_r8,5.7430e+02_r8,3.0378e+02_r8,5.1704e+00_r8/)
      kbo(:, 1,37,14) = (/ &
     &4.2922e+02_r8,3.2232e+02_r8,2.1847e+02_r8,1.1834e+02_r8,1.1213e+00_r8/)
      kbo(:, 2,37,14) = (/ &
     &5.6522e+02_r8,4.2422e+02_r8,2.8713e+02_r8,1.5453e+02_r8,1.6760e+00_r8/)
      kbo(:, 3,37,14) = (/ &
     &7.2332e+02_r8,5.4281e+02_r8,3.6673e+02_r8,1.9621e+02_r8,2.4344e+00_r8/)
      kbo(:, 4,37,14) = (/ &
     &9.0338e+02_r8,6.7777e+02_r8,4.5711e+02_r8,2.4334e+02_r8,3.4735e+00_r8/)
      kbo(:, 5,37,14) = (/ &
     &1.1034e+03_r8,8.2764e+02_r8,5.5725e+02_r8,2.9534e+02_r8,4.8510e+00_r8/)
      kbo(:, 1,38,14) = (/ &
     &4.0355e+02_r8,3.0314e+02_r8,2.0578e+02_r8,1.1195e+02_r8,1.0088e+00_r8/)
      kbo(:, 2,38,14) = (/ &
     &5.3660e+02_r8,4.0286e+02_r8,2.7296e+02_r8,1.4742e+02_r8,1.5281e+00_r8/)
      kbo(:, 3,38,14) = (/ &
     &6.9245e+02_r8,5.1973e+02_r8,3.5152e+02_r8,1.8858e+02_r8,2.2407e+00_r8/)
      kbo(:, 4,38,14) = (/ &
     &8.7113e+02_r8,6.5360e+02_r8,4.4117e+02_r8,2.3535e+02_r8,3.2324e+00_r8/)
      kbo(:, 5,38,14) = (/ &
     &1.0703e+03_r8,8.0291e+02_r8,5.4092e+02_r8,2.8714e+02_r8,4.5526e+00_r8/)
      kbo(:, 1,39,14) = (/ &
     &3.8048e+02_r8,2.8595e+02_r8,1.9433e+02_r8,1.0614e+02_r8,9.1242e-01_r8/)
      kbo(:, 2,39,14) = (/ &
     &5.1067e+02_r8,3.8348e+02_r8,2.6010e+02_r8,1.4089e+02_r8,1.4025e+00_r8/)
      kbo(:, 3,39,14) = (/ &
     &6.6451e+02_r8,4.9880e+02_r8,3.3759e+02_r8,1.8159e+02_r8,2.0765e+00_r8/)
      kbo(:, 4,39,14) = (/ &
     &8.4141e+02_r8,6.3140e+02_r8,4.2638e+02_r8,2.2792e+02_r8,3.0229e+00_r8/)
      kbo(:, 5,39,14) = (/ &
     &1.0396e+03_r8,7.7992e+02_r8,5.2571e+02_r8,2.7947e+02_r8,4.2952e+00_r8/)
      kbo(:, 1,40,14) = (/ &
     &3.5133e+02_r8,2.6415e+02_r8,1.7970e+02_r8,9.8495e+01_r8,7.8366e-01_r8/)
      kbo(:, 2,40,14) = (/ &
     &4.7771e+02_r8,3.5880e+02_r8,2.4356e+02_r8,1.3227e+02_r8,1.2276e+00_r8/)
      kbo(:, 3,40,14) = (/ &
     &6.2817e+02_r8,4.7163e+02_r8,3.1937e+02_r8,1.7209e+02_r8,1.8434e+00_r8/)
      kbo(:, 4,40,14) = (/ &
     &8.0277e+02_r8,6.0241e+02_r8,4.0711e+02_r8,2.1788e+02_r8,2.7123e+00_r8/)
      kbo(:, 5,40,14) = (/ &
     &9.9978e+02_r8,7.5011e+02_r8,5.0577e+02_r8,2.6911e+02_r8,3.8911e+00_r8/)
      kbo(:, 1,41,14) = (/ &
     &3.2342e+02_r8,2.4324e+02_r8,1.6567e+02_r8,9.1094e+01_r8,6.6818e-01_r8/)
      kbo(:, 2,41,14) = (/ &
     &4.4573e+02_r8,3.3493e+02_r8,2.2747e+02_r8,1.2382e+02_r8,1.0662e+00_r8/)
      kbo(:, 3,41,14) = (/ &
     &5.9252e+02_r8,4.4488e+02_r8,3.0145e+02_r8,1.6269e+02_r8,1.6310e+00_r8/)
      kbo(:, 4,41,14) = (/ &
     &7.6447e+02_r8,5.7369e+02_r8,3.8787e+02_r8,2.0780e+02_r8,2.4231e+00_r8/)
      kbo(:, 5,41,14) = (/ &
     &9.6002e+02_r8,7.2027e+02_r8,4.8589e+02_r8,2.5869e+02_r8,3.5110e+00_r8/)
      kbo(:, 1,42,14) = (/ &
     &2.9741e+02_r8,2.2375e+02_r8,1.5256e+02_r8,8.4130e+01_r8,5.7099e-01_r8/)
      kbo(:, 2,42,14) = (/ &
     &4.1545e+02_r8,3.1224e+02_r8,2.1217e+02_r8,1.1576e+02_r8,9.2628e-01_r8/)
      kbo(:, 3,42,14) = (/ &
     &5.5858e+02_r8,4.1944e+02_r8,2.8433e+02_r8,1.5367e+02_r8,1.4426e+00_r8/)
      kbo(:, 4,42,14) = (/ &
     &7.2759e+02_r8,5.4609e+02_r8,3.6933e+02_r8,1.9808e+02_r8,2.1657e+00_r8/)
      kbo(:, 5,42,14) = (/ &
     &9.2131e+02_r8,6.9128e+02_r8,4.6648e+02_r8,2.4850e+02_r8,3.1673e+00_r8/)
      kbo(:, 1,43,14) = (/ &
     &2.7012e+02_r8,2.0330e+02_r8,1.3875e+02_r8,7.6704e+01_r8,4.7188e-01_r8/)
      kbo(:, 2,43,14) = (/ &
     &3.8333e+02_r8,2.8816e+02_r8,1.9596e+02_r8,1.0707e+02_r8,7.8390e-01_r8/)
      kbo(:, 3,43,14) = (/ &
     &5.2268e+02_r8,3.9255e+02_r8,2.6617e+02_r8,1.4400e+02_r8,1.2434e+00_r8/)
      kbo(:, 4,43,14) = (/ &
     &6.8847e+02_r8,5.1676e+02_r8,3.4954e+02_r8,1.8752e+02_r8,1.8919e+00_r8/)
      kbo(:, 5,43,14) = (/ &
     &8.8050e+02_r8,6.6068e+02_r8,4.4591e+02_r8,2.3760e+02_r8,2.7970e+00_r8/)
      kbo(:, 1,44,14) = (/ &
     &2.4333e+02_r8,1.8320e+02_r8,1.2513e+02_r8,6.9324e+01_r8,3.8543e-01_r8/)
      kbo(:, 2,44,14) = (/ &
     &3.5160e+02_r8,2.6439e+02_r8,1.7983e+02_r8,9.8391e+01_r8,6.5410e-01_r8/)
      kbo(:, 3,44,14) = (/ &
     &4.8672e+02_r8,3.6559e+02_r8,2.4794e+02_r8,1.3422e+02_r8,1.0574e+00_r8/)
      kbo(:, 4,44,14) = (/ &
     &6.4907e+02_r8,4.8721e+02_r8,3.2959e+02_r8,1.7683e+02_r8,1.6338e+00_r8/)
      kbo(:, 5,44,14) = (/ &
     &8.3935e+02_r8,6.2981e+02_r8,4.2512e+02_r8,2.2646e+02_r8,2.4460e+00_r8/)
      kbo(:, 1,45,14) = (/ &
     &2.1826e+02_r8,1.6439e+02_r8,1.1240e+02_r8,6.2387e+01_r8,3.1362e-01_r8/)
      kbo(:, 2,45,14) = (/ &
     &3.2151e+02_r8,2.4179e+02_r8,1.6452e+02_r8,9.0130e+01_r8,5.4229e-01_r8/)
      kbo(:, 3,45,14) = (/ &
     &4.5202e+02_r8,3.3957e+02_r8,2.3034e+02_r8,1.2476e+02_r8,8.9432e-01_r8/)
      kbo(:, 4,45,14) = (/ &
     &6.1098e+02_r8,4.5864e+02_r8,3.1027e+02_r8,1.6648e+02_r8,1.4094e+00_r8/)
      kbo(:, 5,45,14) = (/ &
     &7.9903e+02_r8,5.9956e+02_r8,4.0465e+02_r8,2.1549e+02_r8,2.1336e+00_r8/)
      kbo(:, 1,46,14) = (/ &
     &1.9334e+02_r8,1.4567e+02_r8,9.9705e+01_r8,5.5445e+01_r8,2.5106e-01_r8/)
      kbo(:, 2,46,14) = (/ &
     &2.9084e+02_r8,2.1878e+02_r8,1.4895e+02_r8,8.1712e+01_r8,4.4167e-01_r8/)
      kbo(:, 3,46,14) = (/ &
     &4.1605e+02_r8,3.1260e+02_r8,2.1206e+02_r8,1.1494e+02_r8,7.4589e-01_r8/)
      kbo(:, 4,46,14) = (/ &
     &5.7087e+02_r8,4.2857e+02_r8,2.8993e+02_r8,1.5559e+02_r8,1.1995e+00_r8/)
      kbo(:, 5,46,14) = (/ &
     &7.5566e+02_r8,5.6703e+02_r8,3.8272e+02_r8,2.0372e+02_r8,1.8420e+00_r8/)
      kbo(:, 1,47,14) = (/ &
     &1.6734e+02_r8,1.2615e+02_r8,8.6467e+01_r8,4.8182e+01_r8,1.9607e-01_r8/)
      kbo(:, 2,47,14) = (/ &
     &2.5798e+02_r8,1.9414e+02_r8,1.3227e+02_r8,7.2690e+01_r8,3.4728e-01_r8/)
      kbo(:, 3,47,14) = (/ &
     &3.7682e+02_r8,2.8319e+02_r8,1.9216e+02_r8,1.0425e+02_r8,6.0496e-01_r8/)
      kbo(:, 4,47,14) = (/ &
     &5.2596e+02_r8,3.9489e+02_r8,2.6718e+02_r8,1.4343e+02_r8,9.9190e-01_r8/)
      kbo(:, 5,47,14) = (/ &
     &7.0637e+02_r8,5.3006e+02_r8,3.5776e+02_r8,1.9039e+02_r8,1.5539e+00_r8/)
      kbo(:, 1,48,14) = (/ &
     &1.4359e+02_r8,1.0831e+02_r8,7.4350e+01_r8,4.1515e+01_r8,1.5112e-01_r8/)
      kbo(:, 2,48,14) = (/ &
     &2.2736e+02_r8,1.7115e+02_r8,1.1670e+02_r8,6.4242e+01_r8,2.7228e-01_r8/)
      kbo(:, 3,48,14) = (/ &
     &3.3955e+02_r8,2.5527e+02_r8,1.7326e+02_r8,9.4064e+01_r8,4.8587e-01_r8/)
      kbo(:, 4,48,14) = (/ &
     &4.8257e+02_r8,3.6236e+02_r8,2.4521e+02_r8,1.3165e+02_r8,8.1598e-01_r8/)
      kbo(:, 5,48,14) = (/ &
     &6.5841e+02_r8,4.9408e+02_r8,3.3351e+02_r8,1.7744e+02_r8,1.3043e+00_r8/)
      kbo(:, 1,49,14) = (/ &
     &1.2205e+02_r8,9.2102e+01_r8,6.3332e+01_r8,3.5432e+01_r8,1.1595e-01_r8/)
      kbo(:, 2,49,14) = (/ &
     &1.9899e+02_r8,1.4985e+02_r8,1.0228e+02_r8,5.6393e+01_r8,2.1177e-01_r8/)
      kbo(:, 3,49,14) = (/ &
     &3.0425e+02_r8,2.2876e+02_r8,1.5534e+02_r8,8.4415e+01_r8,3.8749e-01_r8/)
      kbo(:, 4,49,14) = (/ &
     &4.4104e+02_r8,3.3122e+02_r8,2.2413e+02_r8,1.2036e+02_r8,6.6950e-01_r8/)
      kbo(:, 5,49,14) = (/ &
     &6.1182e+02_r8,4.5914e+02_r8,3.0987e+02_r8,1.6480e+02_r8,1.0872e+00_r8/)
      kbo(:, 1,50,14) = (/ &
     &1.0410e+02_r8,7.8601e+01_r8,5.4134e+01_r8,3.0320e+01_r8,8.9437e-02_r8/)
      kbo(:, 2,50,14) = (/ &
     &1.7476e+02_r8,1.3166e+02_r8,8.9943e+01_r8,4.9647e+01_r8,1.6487e-01_r8/)
      kbo(:, 3,50,14) = (/ &
     &2.7363e+02_r8,2.0578e+02_r8,1.3977e+02_r8,7.5998e+01_r8,3.0880e-01_r8/)
      kbo(:, 4,50,14) = (/ &
     &4.0470e+02_r8,3.0398e+02_r8,2.0569e+02_r8,1.1045e+02_r8,5.4711e-01_r8/)
      kbo(:, 5,50,14) = (/ &
     &5.7059e+02_r8,4.2823e+02_r8,2.8900e+02_r8,1.5363e+02_r8,9.1135e-01_r8/)
      kbo(:, 1,51,14) = (/ &
     &8.8591e+01_r8,6.6918e+01_r8,4.6161e+01_r8,2.5881e+01_r8,7.0825e-02_r8/)
      kbo(:, 2,51,14) = (/ &
     &1.5315e+02_r8,1.1542e+02_r8,7.8914e+01_r8,4.3611e+01_r8,1.2808e-01_r8/)
      kbo(:, 3,51,14) = (/ &
     &2.4591e+02_r8,1.8497e+02_r8,1.2567e+02_r8,6.8391e+01_r8,2.4633e-01_r8/)
      kbo(:, 4,51,14) = (/ &
     &3.7125e+02_r8,2.7889e+02_r8,1.8871e+02_r8,1.0133e+02_r8,4.4644e-01_r8/)
      kbo(:, 5,51,14) = (/ &
     &5.3232e+02_r8,3.9953e+02_r8,2.6959e+02_r8,1.4324e+02_r8,7.6098e-01_r8/)
      kbo(:, 1,52,14) = (/ &
     &7.4832e+01_r8,5.6551e+01_r8,3.9072e+01_r8,2.1921e+01_r8,5.8568e-02_r8/)
      kbo(:, 2,52,14) = (/ &
     &1.3340e+02_r8,1.0056e+02_r8,6.8804e+01_r8,3.8048e+01_r8,9.9737e-02_r8/)
      kbo(:, 3,52,14) = (/ &
     &2.2000e+02_r8,1.6553e+02_r8,1.1251e+02_r8,6.1251e+01_r8,1.9573e-01_r8/)
      kbo(:, 4,52,14) = (/ &
     &3.3944e+02_r8,2.5503e+02_r8,1.7256e+02_r8,9.2621e+01_r8,3.6167e-01_r8/)
      kbo(:, 5,52,14) = (/ &
     &4.9563e+02_r8,3.7201e+02_r8,2.5099e+02_r8,1.3326e+02_r8,6.3209e-01_r8/)
      kbo(:, 1,53,14) = (/ &
     &6.2655e+01_r8,4.7378e+01_r8,3.2786e+01_r8,1.8402e+01_r8,5.0324e-02_r8/)
      kbo(:, 2,53,14) = (/ &
     &1.1533e+02_r8,8.6961e+01_r8,5.9562e+01_r8,3.2947e+01_r8,7.6555e-02_r8/)
      kbo(:, 3,53,14) = (/ &
     &1.9565e+02_r8,1.4725e+02_r8,1.0014e+02_r8,5.4560e+01_r8,1.5441e-01_r8/)
      kbo(:, 4,53,14) = (/ &
     &3.0901e+02_r8,2.3220e+02_r8,1.5711e+02_r8,8.4327e+01_r8,2.9159e-01_r8/)
      kbo(:, 5,53,14) = (/ &
     &4.6024e+02_r8,3.4547e+02_r8,2.3304e+02_r8,1.2363e+02_r8,5.2012e-01_r8/)
      kbo(:, 1,54,14) = (/ &
     &5.3046e+01_r8,4.0133e+01_r8,2.7816e+01_r8,1.5611e+01_r8,4.2542e-02_r8/)
      kbo(:, 2,54,14) = (/ &
     &1.0074e+02_r8,7.5982e+01_r8,5.2075e+01_r8,2.8803e+01_r8,6.4322e-02_r8/)
      kbo(:, 3,54,14) = (/ &
     &1.7557e+02_r8,1.3215e+02_r8,8.9882e+01_r8,4.8976e+01_r8,1.2163e-01_r8/)
      kbo(:, 4,54,14) = (/ &
     &2.8382e+02_r8,2.1329e+02_r8,1.4431e+02_r8,7.7417e+01_r8,2.3542e-01_r8/)
      kbo(:, 5,54,14) = (/ &
     &4.3075e+02_r8,3.2335e+02_r8,2.1806e+02_r8,1.1557e+02_r8,4.2927e-01_r8/)
      kbo(:, 1,55,14) = (/ &
     &4.5010e+01_r8,3.4076e+01_r8,2.3656e+01_r8,1.3271e+01_r8,3.8508e-02_r8/)
      kbo(:, 2,55,14) = (/ &
     &8.8262e+01_r8,6.6580e+01_r8,4.5655e+01_r8,2.5232e+01_r8,5.7123e-02_r8/)
      kbo(:, 3,55,14) = (/ &
     &1.5805e+02_r8,1.1897e+02_r8,8.0930e+01_r8,4.4073e+01_r8,9.5519e-02_r8/)
      kbo(:, 4,55,14) = (/ &
     &2.6161e+02_r8,1.9662e+02_r8,1.3302e+02_r8,7.1301e+01_r8,1.9000e-01_r8/)
      kbo(:, 5,55,14) = (/ &
     &4.0466e+02_r8,3.0378e+02_r8,2.0480e+02_r8,1.0841e+02_r8,3.5396e-01_r8/)
      kbo(:, 1,56,14) = (/ &
     &3.7999e+01_r8,2.8791e+01_r8,2.0014e+01_r8,1.1214e+01_r8,3.4994e-02_r8/)
      kbo(:, 2,56,14) = (/ &
     &7.7059e+01_r8,5.8140e+01_r8,3.9888e+01_r8,2.2021e+01_r8,5.1685e-02_r8/)
      kbo(:, 3,56,14) = (/ &
     &1.4187e+02_r8,1.0680e+02_r8,7.2655e+01_r8,3.9531e+01_r8,7.7408e-02_r8/)
      kbo(:, 4,56,14) = (/ &
     &2.4069e+02_r8,1.8091e+02_r8,1.2237e+02_r8,6.5530e+01_r8,1.5216e-01_r8/)
      kbo(:, 5,56,14) = (/ &
     &3.8007e+02_r8,2.8533e+02_r8,1.9230e+02_r8,1.0164e+02_r8,2.8842e-01_r8/)
      kbo(:, 1,57,14) = (/ &
     &3.1951e+01_r8,2.4226e+01_r8,1.6863e+01_r8,9.4281e+00_r8,3.3086e-02_r8/)
      kbo(:, 2,57,14) = (/ &
     &6.6995e+01_r8,5.0555e+01_r8,3.4699e+01_r8,1.9133e+01_r8,4.5516e-02_r8/)
      kbo(:, 3,57,14) = (/ &
     &1.2705e+02_r8,9.5650e+01_r8,6.5062e+01_r8,3.5359e+01_r8,6.7958e-02_r8/)
      kbo(:, 4,57,14) = (/ &
     &2.2106e+02_r8,1.6616e+02_r8,1.1237e+02_r8,6.0096e+01_r8,1.2025e-01_r8/)
      kbo(:, 5,57,14) = (/ &
     &3.5683e+02_r8,2.6789e+02_r8,1.8049e+02_r8,9.5240e+01_r8,2.3463e-01_r8/)
      kbo(:, 1,58,14) = (/ &
     &1.3120e+01_r8,1.1427e+01_r8,9.3421e+00_r8,6.3041e+00_r8,2.9290e-02_r8/)
      kbo(:, 2,58,14) = (/ &
     &2.8375e+01_r8,2.4586e+01_r8,1.9815e+01_r8,1.3205e+01_r8,4.1783e-02_r8/)
      kbo(:, 3,58,14) = (/ &
     &5.5462e+01_r8,4.7938e+01_r8,3.8264e+01_r8,2.5126e+01_r8,6.2497e-02_r8/)
      kbo(:, 4,58,14) = (/ &
     &9.8962e+01_r8,8.5397e+01_r8,6.7764e+01_r8,4.3784e+01_r8,9.9579e-02_r8/)
      kbo(:, 5,58,14) = (/ &
     &1.6330e+02_r8,1.4075e+02_r8,1.1126e+02_r8,7.0923e+01_r8,1.9106e-01_r8/)
      kbo(:, 1,59,14) = (/ &
     &1.2384e+01_r8,1.0821e+01_r8,8.8760e+00_r8,6.0092e+00_r8,2.9802e-02_r8/)
      kbo(:, 2,59,14) = (/ &
     &2.7135e+01_r8,2.3592e+01_r8,1.9085e+01_r8,1.2767e+01_r8,4.3735e-02_r8/)
      kbo(:, 3,59,14) = (/ &
     &5.3692e+01_r8,4.6568e+01_r8,3.7314e+01_r8,2.4591e+01_r8,6.7061e-02_r8/)
      kbo(:, 4,59,14) = (/ &
     &9.6831e+01_r8,8.3852e+01_r8,6.6810e+01_r8,4.3324e+01_r8,1.0825e-01_r8/)
      kbo(:, 5,59,14) = (/ &
     &1.6129e+02_r8,1.3951e+02_r8,1.1076e+02_r8,7.0881e+01_r8,1.7652e-01_r8/)
      kbo(:, 1,13,15) = (/ &
     &4.3408e+02_r8,3.2553e+02_r8,2.1704e+02_r8,1.0851e+02_r8,3.3387e-01_r8/)
      kbo(:, 2,13,15) = (/ &
     &6.1113e+02_r8,4.5841e+02_r8,3.0560e+02_r8,1.5279e+02_r8,3.4060e+00_r8/)
      kbo(:, 3,13,15) = (/ &
     &8.2062e+02_r8,6.1547e+02_r8,4.1031e+02_r8,2.0516e+02_r8,7.3889e+00_r8/)
      kbo(:, 4,13,15) = (/ &
     &1.0625e+03_r8,7.9684e+02_r8,5.3120e+02_r8,2.6560e+02_r8,1.3324e+01_r8/)
      kbo(:, 5,13,15) = (/ &
     &1.3314e+03_r8,9.9861e+02_r8,6.6575e+02_r8,3.3287e+02_r8,1.8510e+01_r8/)
      kbo(:, 1,14,15) = (/ &
     &4.8927e+02_r8,3.6696e+02_r8,2.4465e+02_r8,1.2233e+02_r8,1.4639e+00_r8/)
      kbo(:, 2,14,15) = (/ &
     &6.9247e+02_r8,5.1938e+02_r8,3.4624e+02_r8,1.7311e+02_r8,5.0161e+00_r8/)
      kbo(:, 3,14,15) = (/ &
     &9.3693e+02_r8,7.0263e+02_r8,4.6839e+02_r8,2.3422e+02_r8,9.2136e+00_r8/)
      kbo(:, 4,14,15) = (/ &
     &1.2198e+03_r8,9.1484e+02_r8,6.0989e+02_r8,3.0495e+02_r8,1.6015e+01_r8/)
      kbo(:, 5,14,15) = (/ &
     &1.5424e+03_r8,1.1568e+03_r8,7.7122e+02_r8,3.8560e+02_r8,2.0607e+01_r8/)
      kbo(:, 1,15,15) = (/ &
     &5.4419e+02_r8,4.0815e+02_r8,2.7209e+02_r8,1.3605e+02_r8,3.3205e+00_r8/)
      kbo(:, 2,15,15) = (/ &
     &7.6785e+02_r8,5.7588e+02_r8,3.8392e+02_r8,1.9198e+02_r8,6.4585e+00_r8/)
      kbo(:, 3,15,15) = (/ &
     &1.0420e+03_r8,7.8154e+02_r8,5.2102e+02_r8,2.6050e+02_r8,1.2593e+01_r8/)
      kbo(:, 4,15,15) = (/ &
     &1.3650e+03_r8,1.0239e+03_r8,6.8254e+02_r8,3.4127e+02_r8,1.7743e+01_r8/)
      kbo(:, 5,15,15) = (/ &
     &1.7328e+03_r8,1.2995e+03_r8,8.6636e+02_r8,4.3319e+02_r8,2.2779e+01_r8/)
      kbo(:, 1,16,15) = (/ &
     &5.9961e+02_r8,4.4968e+02_r8,2.9978e+02_r8,1.4989e+02_r8,4.3949e+00_r8/)
      kbo(:, 2,16,15) = (/ &
     &8.4044e+02_r8,6.3032e+02_r8,4.2019e+02_r8,2.1011e+02_r8,9.1201e+00_r8/)
      kbo(:, 3,16,15) = (/ &
     &1.1438e+03_r8,8.5770e+02_r8,5.7195e+02_r8,2.8595e+02_r8,1.4709e+01_r8/)
      kbo(:, 4,16,15) = (/ &
     &1.4993e+03_r8,1.1245e+03_r8,7.4965e+02_r8,3.7484e+02_r8,1.9517e+01_r8/)
      kbo(:, 5,16,15) = (/ &
     &1.9026e+03_r8,1.4270e+03_r8,9.5133e+02_r8,4.7569e+02_r8,2.4995e+01_r8/)
      kbo(:, 1,17,15) = (/ &
     &6.5740e+02_r8,4.9304e+02_r8,3.2868e+02_r8,1.6434e+02_r8,5.9877e+00_r8/)
      kbo(:, 2,17,15) = (/ &
     &9.1769e+02_r8,6.8825e+02_r8,4.5884e+02_r8,2.2941e+02_r8,1.1589e+01_r8/)
      kbo(:, 3,17,15) = (/ &
     &1.2441e+03_r8,9.3311e+02_r8,6.2203e+02_r8,3.1103e+02_r8,1.6070e+01_r8/)
      kbo(:, 4,17,15) = (/ &
     &1.6286e+03_r8,1.2214e+03_r8,8.1435e+02_r8,4.0716e+02_r8,2.1263e+01_r8/)
      kbo(:, 5,17,15) = (/ &
     &2.0647e+03_r8,1.5485e+03_r8,1.0323e+03_r8,5.1617e+02_r8,2.7194e+01_r8/)
      kbo(:, 1,18,15) = (/ &
     &7.0743e+02_r8,5.3056e+02_r8,3.5371e+02_r8,1.7685e+02_r8,7.5465e+00_r8/)
      kbo(:, 2,18,15) = (/ &
     &9.8473e+02_r8,7.3856e+02_r8,4.9235e+02_r8,2.4618e+02_r8,1.2708e+01_r8/)
      kbo(:, 3,18,15) = (/ &
     &1.3299e+03_r8,9.9741e+02_r8,6.6495e+02_r8,3.3248e+02_r8,1.7433e+01_r8/)
      kbo(:, 4,18,15) = (/ &
     &1.7379e+03_r8,1.3034e+03_r8,8.6887e+02_r8,4.3447e+02_r8,2.2996e+01_r8/)
      kbo(:, 5,18,15) = (/ &
     &2.2009e+03_r8,1.6506e+03_r8,1.1004e+03_r8,5.5020e+02_r8,2.9358e+01_r8/)
      kbo(:, 1,19,15) = (/ &
     &7.7797e+02_r8,5.8347e+02_r8,3.8898e+02_r8,1.9449e+02_r8,8.9058e+00_r8/)
      kbo(:, 2,19,15) = (/ &
     &1.0795e+03_r8,8.0964e+02_r8,5.3974e+02_r8,2.6988e+02_r8,1.3760e+01_r8/)
      kbo(:, 3,19,15) = (/ &
     &1.4503e+03_r8,1.0877e+03_r8,7.2515e+02_r8,3.6258e+02_r8,1.8739e+01_r8/)
      kbo(:, 4,19,15) = (/ &
     &1.8906e+03_r8,1.4179e+03_r8,9.4523e+02_r8,4.7263e+02_r8,2.4641e+01_r8/)
      kbo(:, 5,19,15) = (/ &
     &2.3863e+03_r8,1.7897e+03_r8,1.1933e+03_r8,5.9656e+02_r8,3.1485e+01_r8/)
      kbo(:, 1,20,15) = (/ &
     &8.7874e+02_r8,6.5907e+02_r8,4.3939e+02_r8,2.1969e+02_r8,9.7556e+00_r8/)
      kbo(:, 2,20,15) = (/ &
     &1.2128e+03_r8,9.0962e+02_r8,6.0638e+02_r8,3.0319e+02_r8,1.4896e+01_r8/)
      kbo(:, 3,20,15) = (/ &
     &1.6209e+03_r8,1.2157e+03_r8,8.1051e+02_r8,4.0524e+02_r8,2.0180e+01_r8/)
      kbo(:, 4,20,15) = (/ &
     &2.1009e+03_r8,1.5756e+03_r8,1.0504e+03_r8,5.2525e+02_r8,2.6433e+01_r8/)
      kbo(:, 5,20,15) = (/ &
     &2.6410e+03_r8,1.9808e+03_r8,1.3205e+03_r8,6.6026e+02_r8,3.3724e+01_r8/)
      kbo(:, 1,21,15) = (/ &
     &9.9673e+02_r8,7.4761e+02_r8,4.9839e+02_r8,2.4919e+02_r8,1.0524e+01_r8/)
      kbo(:, 2,21,15) = (/ &
     &1.3673e+03_r8,1.0255e+03_r8,6.8366e+02_r8,3.4184e+02_r8,1.6075e+01_r8/)
      kbo(:, 3,21,15) = (/ &
     &1.8166e+03_r8,1.3625e+03_r8,9.0829e+02_r8,4.5412e+02_r8,2.1690e+01_r8/)
      kbo(:, 4,21,15) = (/ &
     &2.3404e+03_r8,1.7553e+03_r8,1.1702e+03_r8,5.8508e+02_r8,2.8346e+01_r8/)
      kbo(:, 5,21,15) = (/ &
     &2.9258e+03_r8,2.1942e+03_r8,1.4629e+03_r8,7.3140e+02_r8,3.6033e+01_r8/)
      kbo(:, 1,22,15) = (/ &
     &1.1483e+03_r8,8.6125e+02_r8,5.7415e+02_r8,2.8707e+02_r8,1.1768e+01_r8/)
      kbo(:, 2,22,15) = (/ &
     &1.5630e+03_r8,1.1723e+03_r8,7.8152e+02_r8,3.9076e+02_r8,1.7624e+01_r8/)
      kbo(:, 3,22,15) = (/ &
     &2.0593e+03_r8,1.5445e+03_r8,1.0296e+03_r8,5.1484e+02_r8,2.3654e+01_r8/)
      kbo(:, 4,22,15) = (/ &
     &2.6282e+03_r8,1.9711e+03_r8,1.3140e+03_r8,6.5702e+02_r8,3.0777e+01_r8/)
      kbo(:, 5,22,15) = (/ &
     &3.2625e+03_r8,2.4468e+03_r8,1.6313e+03_r8,8.1566e+02_r8,3.8871e+01_r8/)
      kbo(:, 1,23,15) = (/ &
     &1.3167e+03_r8,9.8756e+02_r8,6.5833e+02_r8,3.2919e+02_r8,1.3119e+01_r8/)
      kbo(:, 2,23,15) = (/ &
     &1.7766e+03_r8,1.3324e+03_r8,8.8830e+02_r8,4.4413e+02_r8,1.9267e+01_r8/)
      kbo(:, 3,23,15) = (/ &
     &2.3173e+03_r8,1.7380e+03_r8,1.1586e+03_r8,5.7933e+02_r8,2.5707e+01_r8/)
      kbo(:, 4,23,15) = (/ &
     &2.9343e+03_r8,2.2007e+03_r8,1.4671e+03_r8,7.3355e+02_r8,3.3186e+01_r8/)
      kbo(:, 5,23,15) = (/ &
     &3.6141e+03_r8,2.7105e+03_r8,1.8070e+03_r8,9.0351e+02_r8,4.1634e+01_r8/)
      kbo(:, 1,24,15) = (/ &
     &1.5139e+03_r8,1.1354e+03_r8,7.5695e+02_r8,3.7848e+02_r8,1.4766e+01_r8/)
      kbo(:, 2,24,15) = (/ &
     &2.0213e+03_r8,1.5159e+03_r8,1.0107e+03_r8,5.0532e+02_r8,2.1039e+01_r8/)
      kbo(:, 3,24,15) = (/ &
     &2.6132e+03_r8,1.9598e+03_r8,1.3066e+03_r8,6.5328e+02_r8,2.7799e+01_r8/)
      kbo(:, 4,24,15) = (/ &
     &3.2798e+03_r8,2.4598e+03_r8,1.6399e+03_r8,8.1993e+02_r8,3.5585e+01_r8/)
      kbo(:, 5,24,15) = (/ &
     &4.0096e+03_r8,3.0073e+03_r8,2.0048e+03_r8,1.0024e+03_r8,4.4343e+01_r8/)
      kbo(:, 1,25,15) = (/ &
     &1.7311e+03_r8,1.2983e+03_r8,8.6555e+02_r8,4.3279e+02_r8,1.6410e+01_r8/)
      kbo(:, 2,25,15) = (/ &
     &2.2880e+03_r8,1.7160e+03_r8,1.1440e+03_r8,5.7204e+02_r8,2.2852e+01_r8/)
      kbo(:, 3,25,15) = (/ &
     &2.9293e+03_r8,2.1970e+03_r8,1.4646e+03_r8,7.3234e+02_r8,2.9897e+01_r8/)
      kbo(:, 4,25,15) = (/ &
     &3.6441e+03_r8,2.7331e+03_r8,1.8220e+03_r8,9.1101e+02_r8,3.8003e+01_r8/)
      kbo(:, 5,25,15) = (/ &
     &4.4209e+03_r8,3.3157e+03_r8,2.2104e+03_r8,1.1052e+03_r8,4.7037e+01_r8/)
      kbo(:, 1,26,15) = (/ &
     &1.9753e+03_r8,1.4814e+03_r8,9.8766e+02_r8,4.9382e+02_r8,1.8018e+01_r8/)
      kbo(:, 2,26,15) = (/ &
     &2.5844e+03_r8,1.9383e+03_r8,1.2922e+03_r8,6.4606e+02_r8,2.4551e+01_r8/)
      kbo(:, 3,26,15) = (/ &
     &3.2758e+03_r8,2.4567e+03_r8,1.6379e+03_r8,8.1896e+02_r8,3.2091e+01_r8/)
      kbo(:, 4,26,15) = (/ &
     &4.0392e+03_r8,3.0293e+03_r8,2.0196e+03_r8,1.0098e+03_r8,4.0504e+01_r8/)
      kbo(:, 5,26,15) = (/ &
     &4.8643e+03_r8,3.6484e+03_r8,2.4323e+03_r8,1.2161e+03_r8,4.9853e+01_r8/)
      kbo(:, 1,27,15) = (/ &
     &2.2372e+03_r8,1.6779e+03_r8,1.1187e+03_r8,5.5932e+02_r8,1.9412e+01_r8/)
      kbo(:, 2,27,15) = (/ &
     &2.8964e+03_r8,2.1723e+03_r8,1.4482e+03_r8,7.2410e+02_r8,2.6199e+01_r8/)
      kbo(:, 3,27,15) = (/ &
     &3.6363e+03_r8,2.7272e+03_r8,1.8181e+03_r8,9.0912e+02_r8,3.4164e+01_r8/)
      kbo(:, 4,27,15) = (/ &
     &4.4487e+03_r8,3.3365e+03_r8,2.2244e+03_r8,1.1122e+03_r8,4.3003e+01_r8/)
      kbo(:, 5,27,15) = (/ &
     &5.3193e+03_r8,3.9894e+03_r8,2.6596e+03_r8,1.3298e+03_r8,5.2701e+01_r8/)
      kbo(:, 1,28,15) = (/ &
     &2.5116e+03_r8,1.8837e+03_r8,1.2558e+03_r8,6.2784e+02_r8,2.0876e+01_r8/)
      kbo(:, 2,28,15) = (/ &
     &3.2189e+03_r8,2.4142e+03_r8,1.6096e+03_r8,8.0476e+02_r8,2.7949e+01_r8/)
      kbo(:, 3,28,15) = (/ &
     &4.0085e+03_r8,3.0060e+03_r8,2.0042e+03_r8,1.0021e+03_r8,3.6156e+01_r8/)
      kbo(:, 4,28,15) = (/ &
     &4.8660e+03_r8,3.6495e+03_r8,2.4329e+03_r8,1.2165e+03_r8,4.5448e+01_r8/)
      kbo(:, 5,28,15) = (/ &
     &5.7764e+03_r8,4.3322e+03_r8,2.8883e+03_r8,1.4442e+03_r8,5.5591e+01_r8/)
      kbo(:, 1,29,15) = (/ &
     &2.7788e+03_r8,2.0842e+03_r8,1.3895e+03_r8,6.9477e+02_r8,2.2561e+01_r8/)
      kbo(:, 2,29,15) = (/ &
     &3.5298e+03_r8,2.6472e+03_r8,1.7648e+03_r8,8.8246e+02_r8,2.9936e+01_r8/)
      kbo(:, 3,29,15) = (/ &
     &4.3597e+03_r8,3.2696e+03_r8,2.1798e+03_r8,1.0899e+03_r8,3.8464e+01_r8/)
      kbo(:, 4,29,15) = (/ &
     &5.2526e+03_r8,3.9395e+03_r8,2.6263e+03_r8,1.3131e+03_r8,4.8125e+01_r8/)
      kbo(:, 5,29,15) = (/ &
     &6.1956e+03_r8,4.6467e+03_r8,3.0979e+03_r8,1.5489e+03_r8,5.8615e+01_r8/)
      kbo(:, 1,30,15) = (/ &
     &3.0369e+03_r8,2.2777e+03_r8,1.5185e+03_r8,7.5926e+02_r8,2.4413e+01_r8/)
      kbo(:, 2,30,15) = (/ &
     &3.8244e+03_r8,2.8684e+03_r8,1.9122e+03_r8,9.5609e+02_r8,3.2061e+01_r8/)
      kbo(:, 3,30,15) = (/ &
     &4.6859e+03_r8,3.5141e+03_r8,2.3430e+03_r8,1.1715e+03_r8,4.0933e+01_r8/)
      kbo(:, 4,30,15) = (/ &
     &5.6065e+03_r8,4.2050e+03_r8,2.8032e+03_r8,1.4016e+03_r8,5.0897e+01_r8/)
      kbo(:, 5,30,15) = (/ &
     &6.5717e+03_r8,4.9287e+03_r8,3.2858e+03_r8,1.6429e+03_r8,6.1721e+01_r8/)
      kbo(:, 1,31,15) = (/ &
     &3.2648e+03_r8,2.4486e+03_r8,1.6324e+03_r8,8.1618e+02_r8,2.6426e+01_r8/)
      kbo(:, 2,31,15) = (/ &
     &4.0756e+03_r8,3.0566e+03_r8,2.0378e+03_r8,1.0190e+03_r8,3.4471e+01_r8/)
      kbo(:, 3,31,15) = (/ &
     &4.9563e+03_r8,3.7173e+03_r8,2.4782e+03_r8,1.2392e+03_r8,4.3666e+01_r8/)
      kbo(:, 4,31,15) = (/ &
     &5.8911e+03_r8,4.4181e+03_r8,2.9455e+03_r8,1.4727e+03_r8,5.3750e+01_r8/)
      kbo(:, 5,31,15) = (/ &
     &6.8637e+03_r8,5.1477e+03_r8,3.4319e+03_r8,1.7160e+03_r8,6.4980e+01_r8/)
      kbo(:, 1,32,15) = (/ &
     &3.4972e+03_r8,2.6230e+03_r8,1.7487e+03_r8,8.7434e+02_r8,2.8607e+01_r8/)
      kbo(:, 2,32,15) = (/ &
     &4.3306e+03_r8,3.2480e+03_r8,2.1653e+03_r8,1.0827e+03_r8,3.6943e+01_r8/)
      kbo(:, 3,32,15) = (/ &
     &5.2288e+03_r8,3.9216e+03_r8,2.6144e+03_r8,1.3072e+03_r8,4.6342e+01_r8/)
      kbo(:, 4,32,15) = (/ &
     &6.1756e+03_r8,4.6314e+03_r8,3.0875e+03_r8,1.5439e+03_r8,5.6744e+01_r8/)
      kbo(:, 5,32,15) = (/ &
     &7.1543e+03_r8,5.3657e+03_r8,3.5769e+03_r8,1.7884e+03_r8,6.8387e+01_r8/)
      kbo(:, 1,33,15) = (/ &
     &3.7323e+03_r8,2.7993e+03_r8,1.8662e+03_r8,9.3310e+02_r8,3.0880e+01_r8/)
      kbo(:, 2,33,15) = (/ &
     &4.5855e+03_r8,3.4391e+03_r8,2.2927e+03_r8,1.1463e+03_r8,3.9458e+01_r8/)
      kbo(:, 3,33,15) = (/ &
     &5.4988e+03_r8,4.1239e+03_r8,2.7494e+03_r8,1.3747e+03_r8,4.9066e+01_r8/)
      kbo(:, 4,33,15) = (/ &
     &6.4556e+03_r8,4.8415e+03_r8,3.2279e+03_r8,1.6139e+03_r8,5.9834e+01_r8/)
      kbo(:, 5,33,15) = (/ &
     &7.4364e+03_r8,5.5775e+03_r8,3.7183e+03_r8,1.8591e+03_r8,7.1936e+01_r8/)
      kbo(:, 1,34,15) = (/ &
     &3.9743e+03_r8,2.9808e+03_r8,1.9872e+03_r8,9.9359e+02_r8,3.2850e+01_r8/)
      kbo(:, 2,34,15) = (/ &
     &4.8517e+03_r8,3.6384e+03_r8,2.4257e+03_r8,1.2129e+03_r8,4.1615e+01_r8/)
      kbo(:, 3,34,15) = (/ &
     &5.7848e+03_r8,4.3386e+03_r8,2.8923e+03_r8,1.4462e+03_r8,5.1514e+01_r8/)
      kbo(:, 4,34,15) = (/ &
     &6.7566e+03_r8,5.0673e+03_r8,3.3783e+03_r8,1.6891e+03_r8,6.2632e+01_r8/)
      kbo(:, 5,34,15) = (/ &
     &7.7467e+03_r8,5.8099e+03_r8,3.8734e+03_r8,1.9367e+03_r8,7.5129e+01_r8/)
      kbo(:, 1,35,15) = (/ &
     &4.1392e+03_r8,3.1044e+03_r8,2.0697e+03_r8,1.0348e+03_r8,3.4005e+01_r8/)
      kbo(:, 2,35,15) = (/ &
     &5.0338e+03_r8,3.7756e+03_r8,2.5169e+03_r8,1.2585e+03_r8,4.2889e+01_r8/)
      kbo(:, 3,35,15) = (/ &
     &5.9824e+03_r8,4.4867e+03_r8,2.9910e+03_r8,1.4955e+03_r8,5.2983e+01_r8/)
      kbo(:, 4,35,15) = (/ &
     &6.9652e+03_r8,5.2239e+03_r8,3.4826e+03_r8,1.7414e+03_r8,6.4327e+01_r8/)
      kbo(:, 5,35,15) = (/ &
     &7.9642e+03_r8,5.9733e+03_r8,3.9822e+03_r8,1.9911e+03_r8,7.7087e+01_r8/)
      kbo(:, 1,36,15) = (/ &
     &4.2146e+03_r8,3.1608e+03_r8,2.1072e+03_r8,1.0536e+03_r8,3.4225e+01_r8/)
      kbo(:, 2,36,15) = (/ &
     &5.1200e+03_r8,3.8401e+03_r8,2.5599e+03_r8,1.2800e+03_r8,4.3139e+01_r8/)
      kbo(:, 3,36,15) = (/ &
     &6.0791e+03_r8,4.5594e+03_r8,3.0396e+03_r8,1.5198e+03_r8,5.3291e+01_r8/)
      kbo(:, 4,36,15) = (/ &
     &7.0718e+03_r8,5.3037e+03_r8,3.5357e+03_r8,1.7679e+03_r8,6.4713e+01_r8/)
      kbo(:, 5,36,15) = (/ &
     &8.0803e+03_r8,6.0601e+03_r8,4.0401e+03_r8,2.0201e+03_r8,7.7535e+01_r8/)
      kbo(:, 1,37,15) = (/ &
     &4.1830e+03_r8,3.1372e+03_r8,2.0915e+03_r8,1.0457e+03_r8,3.3171e+01_r8/)
      kbo(:, 2,37,15) = (/ &
     &5.0955e+03_r8,3.8218e+03_r8,2.5477e+03_r8,1.2739e+03_r8,4.1938e+01_r8/)
      kbo(:, 3,37,15) = (/ &
     &6.0651e+03_r8,4.5490e+03_r8,3.0327e+03_r8,1.5163e+03_r8,5.1957e+01_r8/)
      kbo(:, 4,37,15) = (/ &
     &7.0708e+03_r8,5.3029e+03_r8,3.5354e+03_r8,1.7678e+03_r8,6.3244e+01_r8/)
      kbo(:, 5,37,15) = (/ &
     &8.0937e+03_r8,6.0708e+03_r8,4.0470e+03_r8,2.0235e+03_r8,7.5914e+01_r8/)
      kbo(:, 1,38,15) = (/ &
     &4.1367e+03_r8,3.1023e+03_r8,2.0683e+03_r8,1.0342e+03_r8,3.2061e+01_r8/)
      kbo(:, 2,38,15) = (/ &
     &5.0552e+03_r8,3.7913e+03_r8,2.5275e+03_r8,1.2638e+03_r8,4.0668e+01_r8/)
      kbo(:, 3,38,15) = (/ &
     &6.0331e+03_r8,4.5250e+03_r8,3.0168e+03_r8,1.5083e+03_r8,5.0542e+01_r8/)
      kbo(:, 4,38,15) = (/ &
     &7.0503e+03_r8,5.2874e+03_r8,3.5252e+03_r8,1.7626e+03_r8,6.1670e+01_r8/)
      kbo(:, 5,38,15) = (/ &
     &8.0886e+03_r8,6.0662e+03_r8,4.0441e+03_r8,2.0220e+03_r8,7.4175e+01_r8/)
      kbo(:, 1,39,15) = (/ &
     &4.0836e+03_r8,3.0625e+03_r8,2.0418e+03_r8,1.0208e+03_r8,3.0973e+01_r8/)
      kbo(:, 2,39,15) = (/ &
     &5.0068e+03_r8,3.7549e+03_r8,2.5034e+03_r8,1.2516e+03_r8,3.9423e+01_r8/)
      kbo(:, 3,39,15) = (/ &
     &5.9917e+03_r8,4.4934e+03_r8,2.9959e+03_r8,1.4979e+03_r8,4.9140e+01_r8/)
      kbo(:, 4,39,15) = (/ &
     &7.0190e+03_r8,5.2646e+03_r8,3.5096e+03_r8,1.7548e+03_r8,6.0110e+01_r8/)
      kbo(:, 5,39,15) = (/ &
     &8.0703e+03_r8,6.0526e+03_r8,4.0352e+03_r8,2.0176e+03_r8,7.2442e+01_r8/)
      kbo(:, 1,40,15) = (/ &
     &3.9731e+03_r8,2.9800e+03_r8,1.9865e+03_r8,9.9327e+02_r8,2.9119e+01_r8/)
      kbo(:, 2,40,15) = (/ &
     &4.9010e+03_r8,3.6760e+03_r8,2.4505e+03_r8,1.2252e+03_r8,3.7284e+01_r8/)
      kbo(:, 3,40,15) = (/ &
     &5.8967e+03_r8,4.4226e+03_r8,2.9482e+03_r8,1.4742e+03_r8,4.6706e+01_r8/)
      kbo(:, 4,40,15) = (/ &
     &6.9401e+03_r8,5.2049e+03_r8,3.4701e+03_r8,1.7350e+03_r8,5.7383e+01_r8/)
      kbo(:, 5,40,15) = (/ &
     &8.0134e+03_r8,6.0096e+03_r8,4.0066e+03_r8,2.0033e+03_r8,6.9395e+01_r8/)
      kbo(:, 1,41,15) = (/ &
     &3.8503e+03_r8,2.8877e+03_r8,1.9252e+03_r8,9.6258e+02_r8,2.7224e+01_r8/)
      kbo(:, 2,41,15) = (/ &
     &4.7815e+03_r8,3.5862e+03_r8,2.3908e+03_r8,1.1953e+03_r8,3.5101e+01_r8/)
      kbo(:, 3,41,15) = (/ &
     &5.7872e+03_r8,4.3401e+03_r8,2.8935e+03_r8,1.4467e+03_r8,4.4197e+01_r8/)
      kbo(:, 4,41,15) = (/ &
     &6.8458e+03_r8,5.1341e+03_r8,3.4225e+03_r8,1.7115e+03_r8,5.4583e+01_r8/)
      kbo(:, 5,41,15) = (/ &
     &7.9396e+03_r8,5.9547e+03_r8,3.9699e+03_r8,1.9849e+03_r8,6.6259e+01_r8/)
      kbo(:, 1,42,15) = (/ &
     &3.7218e+03_r8,2.7913e+03_r8,1.8581e+03_r8,9.3043e+02_r8,2.5397e+01_r8/)
      kbo(:, 2,42,15) = (/ &
     &4.6552e+03_r8,3.4913e+03_r8,2.3275e+03_r8,1.1638e+03_r8,3.2985e+01_r8/)
      kbo(:, 3,42,15) = (/ &
     &5.6676e+03_r8,4.2515e+03_r8,2.8342e+03_r8,1.4169e+03_r8,4.1777e+01_r8/)
      kbo(:, 4,42,15) = (/ &
     &6.7404e+03_r8,5.0552e+03_r8,3.3706e+03_r8,1.6852e+03_r8,5.1833e+01_r8/)
      kbo(:, 5,42,15) = (/ &
     &7.8548e+03_r8,5.8911e+03_r8,3.9277e+03_r8,1.9637e+03_r8,6.3188e+01_r8/)
      kbo(:, 1,43,15) = (/ &
     &3.5738e+03_r8,2.6801e+03_r8,1.7870e+03_r8,8.9342e+02_r8,2.3264e+01_r8/)
      kbo(:, 2,43,15) = (/ &
     &4.5111e+03_r8,3.3834e+03_r8,2.2559e+03_r8,1.1277e+03_r8,3.0494e+01_r8/)
      kbo(:, 3,43,15) = (/ &
     &5.5364e+03_r8,4.1522e+03_r8,2.7681e+03_r8,1.3841e+03_r8,3.8909e+01_r8/)
      kbo(:, 4,43,15) = (/ &
     &6.6297e+03_r8,4.9723e+03_r8,3.3147e+03_r8,1.6574e+03_r8,4.8575e+01_r8/)
      kbo(:, 5,43,15) = (/ &
     &7.7713e+03_r8,5.8285e+03_r8,3.8856e+03_r8,1.9429e+03_r8,5.9539e+01_r8/)
      kbo(:, 1,44,15) = (/ &
     &3.4144e+03_r8,2.5608e+03_r8,1.7072e+03_r8,8.5364e+02_r8,2.1065e+01_r8/)
      kbo(:, 2,44,15) = (/ &
     &4.3569e+03_r8,3.2674e+03_r8,2.1784e+03_r8,1.0893e+03_r8,2.7929e+01_r8/)
      kbo(:, 3,44,15) = (/ &
     &5.3944e+03_r8,4.0458e+03_r8,2.6971e+03_r8,1.3486e+03_r8,3.5943e+01_r8/)
      kbo(:, 4,44,15) = (/ &
     &6.5105e+03_r8,4.8828e+03_r8,3.2554e+03_r8,1.6276e+03_r8,4.5182e+01_r8/)
      kbo(:, 5,44,15) = (/ &
     &7.6829e+03_r8,5.7622e+03_r8,3.8414e+03_r8,1.9208e+03_r8,5.5715e+01_r8/)
      kbo(:, 1,45,15) = (/ &
     &3.2505e+03_r8,2.4379e+03_r8,1.6254e+03_r8,8.1271e+02_r8,1.8984e+01_r8/)
      kbo(:, 2,45,15) = (/ &
     &4.1974e+03_r8,3.1481e+03_r8,2.0989e+03_r8,1.0493e+03_r8,2.5493e+01_r8/)
      kbo(:, 3,45,15) = (/ &
     &5.2466e+03_r8,3.9350e+03_r8,2.6232e+03_r8,1.3117e+03_r8,3.3113e+01_r8/)
      kbo(:, 4,45,15) = (/ &
     &6.3833e+03_r8,4.7875e+03_r8,3.1918e+03_r8,1.5958e+03_r8,4.1930e+01_r8/)
      kbo(:, 5,45,15) = (/ &
     &7.5868e+03_r8,5.6901e+03_r8,3.7934e+03_r8,1.8967e+03_r8,5.2027e+01_r8/)
      kbo(:, 1,46,15) = (/ &
     &3.0662e+03_r8,2.2996e+03_r8,1.5331e+03_r8,7.6672e+02_r8,1.6905e+01_r8/)
      kbo(:, 2,46,15) = (/ &
     &4.0155e+03_r8,3.0116e+03_r8,2.0079e+03_r8,1.0039e+03_r8,2.3041e+01_r8/)
      kbo(:, 3,46,15) = (/ &
     &5.0741e+03_r8,3.8056e+03_r8,2.5370e+03_r8,1.2685e+03_r8,3.0241e+01_r8/)
      kbo(:, 4,46,15) = (/ &
     &6.2294e+03_r8,4.6721e+03_r8,3.1149e+03_r8,1.5573e+03_r8,3.8622e+01_r8/)
      kbo(:, 5,46,15) = (/ &
     &7.4637e+03_r8,5.5978e+03_r8,3.7320e+03_r8,1.8660e+03_r8,4.8257e+01_r8/)
      kbo(:, 1,47,15) = (/ &
     &2.8472e+03_r8,2.1354e+03_r8,1.4236e+03_r8,7.1208e+02_r8,1.4723e+01_r8/)
      kbo(:, 2,47,15) = (/ &
     &3.7952e+03_r8,2.8464e+03_r8,1.8976e+03_r8,9.4874e+02_r8,2.0451e+01_r8/)
      kbo(:, 3,47,15) = (/ &
     &4.8581e+03_r8,3.6436e+03_r8,2.4290e+03_r8,1.2145e+03_r8,2.7203e+01_r8/)
      kbo(:, 4,47,15) = (/ &
     &6.0303e+03_r8,4.5227e+03_r8,3.0151e+03_r8,1.5075e+03_r8,3.5112e+01_r8/)
      kbo(:, 5,47,15) = (/ &
     &7.2931e+03_r8,5.4698e+03_r8,3.6467e+03_r8,1.8233e+03_r8,4.4239e+01_r8/)
      kbo(:, 1,48,15) = (/ &
     &2.6253e+03_r8,1.9691e+03_r8,1.3127e+03_r8,6.5679e+02_r8,1.2715e+01_r8/)
      kbo(:, 2,48,15) = (/ &
     &3.5692e+03_r8,2.6769e+03_r8,1.7846e+03_r8,8.9231e+02_r8,1.8030e+01_r8/)
      kbo(:, 3,48,15) = (/ &
     &4.6375e+03_r8,3.4782e+03_r8,2.3188e+03_r8,1.1595e+03_r8,2.4364e+01_r8/)
      kbo(:, 4,48,15) = (/ &
     &5.8244e+03_r8,4.3683e+03_r8,2.9120e+03_r8,1.4560e+03_r8,3.1792e+01_r8/)
      kbo(:, 5,48,15) = (/ &
     &7.1141e+03_r8,5.3356e+03_r8,3.5570e+03_r8,1.7785e+03_r8,4.0424e+01_r8/)
      kbo(:, 1,49,15) = (/ &
     &2.4040e+03_r8,1.8030e+03_r8,1.2020e+03_r8,6.0155e+02_r8,1.0861e+01_r8/)
      kbo(:, 2,49,15) = (/ &
     &3.3401e+03_r8,2.5051e+03_r8,1.6700e+03_r8,8.3512e+02_r8,1.5777e+01_r8/)
      kbo(:, 3,49,15) = (/ &
     &4.4127e+03_r8,3.3095e+03_r8,2.2063e+03_r8,1.1031e+03_r8,2.1693e+01_r8/)
      kbo(:, 4,49,15) = (/ &
     &5.6115e+03_r8,4.2087e+03_r8,2.8058e+03_r8,1.4030e+03_r8,2.8659e+01_r8/)
      kbo(:, 5,49,15) = (/ &
     &6.9274e+03_r8,5.1956e+03_r8,3.4636e+03_r8,1.7318e+03_r8,3.6808e+01_r8/)
      kbo(:, 1,50,15) = (/ &
     &2.2030e+03_r8,1.6523e+03_r8,1.1015e+03_r8,5.5137e+02_r8,9.2813e+00_r8/)
      kbo(:, 2,50,15) = (/ &
     &3.1297e+03_r8,2.3473e+03_r8,1.5649e+03_r8,7.8265e+02_r8,1.3818e+01_r8/)
      kbo(:, 3,50,15) = (/ &
     &4.2081e+03_r8,3.1561e+03_r8,2.1041e+03_r8,1.0519e+03_r8,1.9341e+01_r8/)
      kbo(:, 4,50,15) = (/ &
     &5.4214e+03_r8,4.0660e+03_r8,2.7107e+03_r8,1.3553e+03_r8,2.5902e+01_r8/)
      kbo(:, 5,50,15) = (/ &
     &6.7641e+03_r8,5.0731e+03_r8,3.3821e+03_r8,1.6910e+03_r8,3.3602e+01_r8/)
      kbo(:, 1,51,15) = (/ &
     &2.0128e+03_r8,1.5096e+03_r8,1.0064e+03_r8,5.0390e+02_r8,7.8927e+00_r8/)
      kbo(:, 2,51,15) = (/ &
     &2.9276e+03_r8,2.1957e+03_r8,1.4638e+03_r8,7.3206e+02_r8,1.2046e+01_r8/)
      kbo(:, 3,51,15) = (/ &
     &4.0098e+03_r8,3.0073e+03_r8,2.0049e+03_r8,1.0025e+03_r8,1.7204e+01_r8/)
      kbo(:, 4,51,15) = (/ &
     &5.2399e+03_r8,3.9299e+03_r8,2.6200e+03_r8,1.3100e+03_r8,2.3387e+01_r8/)
      kbo(:, 5,51,15) = (/ &
     &6.6101e+03_r8,4.9575e+03_r8,3.3050e+03_r8,1.6525e+03_r8,3.0654e+01_r8/)
      kbo(:, 1,52,15) = (/ &
     &1.8272e+03_r8,1.3704e+03_r8,9.1373e+02_r8,4.5761e+02_r8,6.6428e+00_r8/)
      kbo(:, 2,52,15) = (/ &
     &2.7256e+03_r8,2.0442e+03_r8,1.3627e+03_r8,6.8167e+02_r8,1.0409e+01_r8/)
      kbo(:, 3,52,15) = (/ &
     &3.8098e+03_r8,2.8573e+03_r8,1.9049e+03_r8,9.5240e+02_r8,1.5205e+01_r8/)
      kbo(:, 4,52,15) = (/ &
     &5.0575e+03_r8,3.7931e+03_r8,2.5288e+03_r8,1.2643e+03_r8,2.1008e+01_r8/)
      kbo(:, 5,52,15) = (/ &
     &6.4544e+03_r8,4.8408e+03_r8,3.2272e+03_r8,1.6135e+03_r8,2.7863e+01_r8/)
      kbo(:, 1,53,15) = (/ &
     &1.6455e+03_r8,1.2341e+03_r8,8.2275e+02_r8,4.1218e+02_r8,5.5292e+00_r8/)
      kbo(:, 2,53,15) = (/ &
     &2.5225e+03_r8,1.8919e+03_r8,1.2613e+03_r8,6.3102e+02_r8,8.9199e+00_r8/)
      kbo(:, 3,53,15) = (/ &
     &3.6054e+03_r8,2.7042e+03_r8,1.8028e+03_r8,9.0141e+02_r8,1.3342e+01_r8/)
      kbo(:, 4,53,15) = (/ &
     &4.8703e+03_r8,3.6527e+03_r8,2.4352e+03_r8,1.2176e+03_r8,1.8766e+01_r8/)
      kbo(:, 5,53,15) = (/ &
     &6.2970e+03_r8,4.7228e+03_r8,3.1485e+03_r8,1.5742e+03_r8,2.5231e+01_r8/)
      kbo(:, 1,54,15) = (/ &
     &1.4905e+03_r8,1.1179e+03_r8,7.4526e+02_r8,3.7343e+02_r8,4.6241e+00_r8/)
      kbo(:, 2,54,15) = (/ &
     &2.3494e+03_r8,1.7621e+03_r8,1.1747e+03_r8,5.8778e+02_r8,7.6666e+00_r8/)
      kbo(:, 3,54,15) = (/ &
     &3.4317e+03_r8,2.5738e+03_r8,1.7159e+03_r8,8.5793e+02_r8,1.1744e+01_r8/)
      kbo(:, 4,54,15) = (/ &
     &4.7173e+03_r8,3.5380e+03_r8,2.3587e+03_r8,1.1793e+03_r8,1.6836e+01_r8/)
      kbo(:, 5,54,15) = (/ &
     &6.1810e+03_r8,4.6357e+03_r8,3.0905e+03_r8,1.5452e+03_r8,2.2955e+01_r8/)
      kbo(:, 1,55,15) = (/ &
     &1.3503e+03_r8,1.0127e+03_r8,6.7517e+02_r8,3.3837e+02_r8,3.8496e+00_r8/)
      kbo(:, 2,55,15) = (/ &
     &2.1922e+03_r8,1.6441e+03_r8,1.0961e+03_r8,5.4853e+02_r8,6.5708e+00_r8/)
      kbo(:, 3,55,15) = (/ &
     &3.2739e+03_r8,2.4554e+03_r8,1.6370e+03_r8,8.1853e+02_r8,1.0320e+01_r8/)
      kbo(:, 4,55,15) = (/ &
     &4.5818e+03_r8,3.4364e+03_r8,2.2910e+03_r8,1.1455e+03_r8,1.5094e+01_r8/)
      kbo(:, 5,55,15) = (/ &
     &6.0888e+03_r8,4.5666e+03_r8,3.0444e+03_r8,1.5222e+03_r8,2.0876e+01_r8/)
      kbo(:, 1,56,15) = (/ &
     &1.2164e+03_r8,9.1227e+02_r8,6.0818e+02_r8,3.0487e+02_r8,3.1724e+00_r8/)
      kbo(:, 2,56,15) = (/ &
     &2.0376e+03_r8,1.5282e+03_r8,1.0188e+03_r8,5.0989e+02_r8,5.5890e+00_r8/)
      kbo(:, 3,56,15) = (/ &
     &3.1175e+03_r8,2.3381e+03_r8,1.5588e+03_r8,7.7947e+02_r8,9.0060e+00_r8/)
      kbo(:, 4,56,15) = (/ &
     &4.4491e+03_r8,3.3368e+03_r8,2.2246e+03_r8,1.1123e+03_r8,1.3463e+01_r8/)
      kbo(:, 5,56,15) = (/ &
     &6.0027e+03_r8,4.5020e+03_r8,3.0014e+03_r8,1.5007e+03_r8,1.8912e+01_r8/)
      kbo(:, 1,57,15) = (/ &
     &1.0889e+03_r8,8.1664e+02_r8,5.4443e+02_r8,2.7298e+02_r8,2.5821e+00_r8/)
      kbo(:, 2,57,15) = (/ &
     &1.8871e+03_r8,1.4154e+03_r8,9.4357e+02_r8,4.7231e+02_r8,4.7102e+00_r8/)
      kbo(:, 3,57,15) = (/ &
     &2.9648e+03_r8,2.2236e+03_r8,1.4824e+03_r8,7.4131e+02_r8,7.7911e+00_r8/)
      kbo(:, 4,57,15) = (/ &
     &4.3194e+03_r8,3.2395e+03_r8,2.1597e+03_r8,1.0798e+03_r8,1.1924e+01_r8/)
      kbo(:, 5,57,15) = (/ &
     &5.9252e+03_r8,4.4439e+03_r8,2.9626e+03_r8,1.4813e+03_r8,1.7058e+01_r8/)
      kbo(:, 1,58,15) = (/ &
     &4.7296e+02_r8,4.0724e+02_r8,3.1867e+02_r8,1.9341e+02_r8,2.1052e+00_r8/)
      kbo(:, 2,58,15) = (/ &
     &8.4958e+02_r8,7.3152e+02_r8,5.7242e+02_r8,3.4682e+02_r8,3.9643e+00_r8/)
      kbo(:, 3,58,15) = (/ &
     &1.3719e+03_r8,1.1812e+03_r8,9.2434e+02_r8,5.5948e+02_r8,6.7352e+00_r8/)
      kbo(:, 4,58,15) = (/ &
     &2.0410e+03_r8,1.7574e+03_r8,1.3752e+03_r8,8.3221e+02_r8,1.0550e+01_r8/)
      kbo(:, 5,58,15) = (/ &
     &2.8472e+03_r8,2.4515e+03_r8,1.9184e+03_r8,1.1609e+03_r8,1.5395e+01_r8/)
      kbo(:, 1,59,15) = (/ &
     &4.5680e+02_r8,3.9477e+02_r8,3.1046e+02_r8,1.8976e+02_r8,1.9256e+00_r8/)
      kbo(:, 2,59,15) = (/ &
     &8.3327e+02_r8,7.2012e+02_r8,5.6632e+02_r8,3.4555e+02_r8,3.6779e+00_r8/)
      kbo(:, 3,59,15) = (/ &
     &1.3611e+03_r8,1.1763e+03_r8,9.2510e+02_r8,5.6393e+02_r8,6.3201e+00_r8/)
      kbo(:, 4,59,15) = (/ &
     &2.0429e+03_r8,1.7655e+03_r8,1.3884e+03_r8,8.4623e+02_r8,9.9804e+00_r8/)
      kbo(:, 5,59,15) = (/ &
     &2.8700e+03_r8,2.4803e+03_r8,1.9506e+03_r8,1.1889e+03_r8,1.4739e+01_r8/)
      kbo(:, 1,13,16) = (/ &
     &4.8122e+02_r8,3.6087e+02_r8,2.4060e+02_r8,1.2030e+02_r8,7.3993e+00_r8/)
      kbo(:, 2,13,16) = (/ &
     &6.9206e+02_r8,5.1907e+02_r8,3.4603e+02_r8,1.7302e+02_r8,1.5501e+01_r8/)
      kbo(:, 3,13,16) = (/ &
     &9.4738e+02_r8,7.1056e+02_r8,4.7372e+02_r8,2.3683e+02_r8,2.1040e+01_r8/)
      kbo(:, 4,13,16) = (/ &
     &1.2406e+03_r8,9.3042e+02_r8,6.2029e+02_r8,3.1014e+02_r8,2.9139e+01_r8/)
      kbo(:, 5,13,16) = (/ &
     &1.5703e+03_r8,1.1778e+03_r8,7.8522e+02_r8,3.9259e+02_r8,3.9308e+01_r8/)
      kbo(:, 1,14,16) = (/ &
     &5.7576e+02_r8,4.3182e+02_r8,2.8788e+02_r8,1.4394e+02_r8,1.4009e+01_r8/)
      kbo(:, 2,14,16) = (/ &
     &8.3244e+02_r8,6.2431e+02_r8,4.1619e+02_r8,2.0809e+02_r8,1.9135e+01_r8/)
      kbo(:, 3,14,16) = (/ &
     &1.1392e+03_r8,8.5436e+02_r8,5.6956e+02_r8,2.8480e+02_r8,2.5798e+01_r8/)
      kbo(:, 4,14,16) = (/ &
     &1.4970e+03_r8,1.1226e+03_r8,7.4844e+02_r8,3.7423e+02_r8,3.5612e+01_r8/)
      kbo(:, 5,14,16) = (/ &
     &1.8999e+03_r8,1.4249e+03_r8,9.4985e+02_r8,4.7498e+02_r8,4.7897e+01_r8/)
      kbo(:, 1,15,16) = (/ &
     &6.7686e+02_r8,5.0758e+02_r8,3.3845e+02_r8,1.6922e+02_r8,1.7232e+01_r8/)
      kbo(:, 2,15,16) = (/ &
     &9.7585e+02_r8,7.3193e+02_r8,4.8790e+02_r8,2.4395e+02_r8,2.3521e+01_r8/)
      kbo(:, 3,15,16) = (/ &
     &1.3377e+03_r8,1.0032e+03_r8,6.6881e+02_r8,3.3441e+02_r8,3.1740e+01_r8/)
      kbo(:, 4,15,16) = (/ &
     &1.7575e+03_r8,1.3181e+03_r8,8.7876e+02_r8,4.3935e+02_r8,4.3321e+01_r8/)
      kbo(:, 5,15,16) = (/ &
     &2.2308e+03_r8,1.6730e+03_r8,1.1154e+03_r8,5.5774e+02_r8,5.7999e+01_r8/)
      kbo(:, 1,16,16) = (/ &
     &7.8637e+02_r8,5.8983e+02_r8,3.9321e+02_r8,1.9661e+02_r8,2.1088e+01_r8/)
      kbo(:, 2,16,16) = (/ &
     &1.1333e+03_r8,8.4995e+02_r8,5.6666e+02_r8,2.8332e+02_r8,2.8690e+01_r8/)
      kbo(:, 3,16,16) = (/ &
     &1.5497e+03_r8,1.1623e+03_r8,7.7493e+02_r8,3.8745e+02_r8,3.8949e+01_r8/)
      kbo(:, 4,16,16) = (/ &
     &2.0330e+03_r8,1.5247e+03_r8,1.0164e+03_r8,5.0821e+02_r8,5.2500e+01_r8/)
      kbo(:, 5,16,16) = (/ &
     &2.5789e+03_r8,1.9342e+03_r8,1.2895e+03_r8,6.4478e+02_r8,6.9505e+01_r8/)
      kbo(:, 1,17,16) = (/ &
     &9.1371e+02_r8,6.8529e+02_r8,4.5686e+02_r8,2.2843e+02_r8,2.5518e+01_r8/)
      kbo(:, 2,17,16) = (/ &
     &1.3116e+03_r8,9.8366e+02_r8,6.5574e+02_r8,3.2788e+02_r8,3.4904e+01_r8/)
      kbo(:, 3,17,16) = (/ &
     &1.7880e+03_r8,1.3410e+03_r8,8.9396e+02_r8,4.4698e+02_r8,4.7412e+01_r8/)
      kbo(:, 4,17,16) = (/ &
     &2.3411e+03_r8,1.7558e+03_r8,1.1705e+03_r8,5.8526e+02_r8,6.3218e+01_r8/)
      kbo(:, 5,17,16) = (/ &
     &2.9603e+03_r8,2.2204e+03_r8,1.4801e+03_r8,7.4006e+02_r8,8.2344e+01_r8/)
      kbo(:, 1,18,16) = (/ &
     &1.0453e+03_r8,7.8401e+02_r8,5.2267e+02_r8,2.6132e+02_r8,3.0565e+01_r8/)
      kbo(:, 2,18,16) = (/ &
     &1.4935e+03_r8,1.1202e+03_r8,7.4674e+02_r8,3.7341e+02_r8,4.2204e+01_r8/)
      kbo(:, 3,18,16) = (/ &
     &2.0309e+03_r8,1.5232e+03_r8,1.0154e+03_r8,5.0502e+02_r8,5.7127e+01_r8/)
      kbo(:, 4,18,16) = (/ &
     &2.6479e+03_r8,1.9862e+03_r8,1.3241e+03_r8,6.6202e+02_r8,7.5429e+01_r8/)
      kbo(:, 5,18,16) = (/ &
     &3.3399e+03_r8,2.5049e+03_r8,1.6700e+03_r8,8.3500e+02_r8,9.7021e+01_r8/)
      kbo(:, 1,19,16) = (/ &
     &1.2157e+03_r8,9.1179e+02_r8,6.0790e+02_r8,3.0394e+02_r8,3.6497e+01_r8/)
      kbo(:, 2,19,16) = (/ &
     &1.7308e+03_r8,1.2981e+03_r8,8.6539e+02_r8,4.3270e+02_r8,5.0186e+01_r8/)
      kbo(:, 3,19,16) = (/ &
     &2.3421e+03_r8,1.7565e+03_r8,1.1710e+03_r8,5.8556e+02_r8,6.7960e+01_r8/)
      kbo(:, 4,19,16) = (/ &
     &3.0436e+03_r8,2.2829e+03_r8,1.5219e+03_r8,7.6093e+02_r8,8.8940e+01_r8/)
      kbo(:, 5,19,16) = (/ &
     &3.8257e+03_r8,2.8691e+03_r8,1.9129e+03_r8,9.5637e+02_r8,1.1320e+02_r8/)
      kbo(:, 1,20,16) = (/ &
     &1.4499e+03_r8,1.0875e+03_r8,7.2502e+02_r8,3.6250e+02_r8,4.3451e+01_r8/)
      kbo(:, 2,20,16) = (/ &
     &2.0494e+03_r8,1.5371e+03_r8,1.0247e+03_r8,5.1236e+02_r8,5.9923e+01_r8/)
      kbo(:, 3,20,16) = (/ &
     &2.7595e+03_r8,2.0695e+03_r8,1.3797e+03_r8,6.8984e+02_r8,8.0107e+01_r8/)
      kbo(:, 4,20,16) = (/ &
     &3.5702e+03_r8,2.6775e+03_r8,1.7850e+03_r8,8.9253e+02_r8,1.0388e+02_r8/)
      kbo(:, 5,20,16) = (/ &
     &4.4675e+03_r8,3.3505e+03_r8,2.2337e+03_r8,1.1168e+03_r8,1.3102e+02_r8/)
      kbo(:, 1,21,16) = (/ &
     &1.7354e+03_r8,1.3015e+03_r8,8.6762e+02_r8,4.3383e+02_r8,5.1121e+01_r8/)
      kbo(:, 2,21,16) = (/ &
     &2.4333e+03_r8,1.8248e+03_r8,1.2166e+03_r8,6.0831e+02_r8,7.0122e+01_r8/)
      kbo(:, 3,21,16) = (/ &
     &3.2566e+03_r8,2.4426e+03_r8,1.6283e+03_r8,8.1420e+02_r8,9.3037e+01_r8/)
      kbo(:, 4,21,16) = (/ &
     &4.1875e+03_r8,3.1404e+03_r8,2.0937e+03_r8,1.0468e+03_r8,1.1968e+02_r8/)
      kbo(:, 5,21,16) = (/ &
     &5.2269e+03_r8,3.9201e+03_r8,2.6133e+03_r8,1.3066e+03_r8,1.4963e+02_r8/)
      kbo(:, 1,22,16) = (/ &
     &2.1136e+03_r8,1.5853e+03_r8,1.0569e+03_r8,5.2844e+02_r8,6.0581e+01_r8/)
      kbo(:, 2,22,16) = (/ &
     &2.9316e+03_r8,2.1987e+03_r8,1.4659e+03_r8,7.3292e+02_r8,8.2385e+01_r8/)
      kbo(:, 3,22,16) = (/ &
     &3.8802e+03_r8,2.9101e+03_r8,1.9401e+03_r8,9.7007e+02_r8,1.0823e+02_r8/)
      kbo(:, 4,22,16) = (/ &
     &4.9544e+03_r8,3.7156e+03_r8,2.4770e+03_r8,1.2386e+03_r8,1.3781e+02_r8/)
      kbo(:, 5,22,16) = (/ &
     &6.1512e+03_r8,4.6135e+03_r8,3.0579e+03_r8,1.5378e+03_r8,1.7127e+02_r8/)
      kbo(:, 1,23,16) = (/ &
     &2.5612e+03_r8,1.9208e+03_r8,1.2805e+03_r8,6.4031e+02_r8,7.0795e+01_r8/)
      kbo(:, 2,23,16) = (/ &
     &3.5078e+03_r8,2.6308e+03_r8,1.7538e+03_r8,8.7684e+02_r8,9.5347e+01_r8/)
      kbo(:, 3,23,16) = (/ &
     &4.5972e+03_r8,3.4475e+03_r8,2.2984e+03_r8,1.1493e+03_r8,1.2411e+02_r8/)
      kbo(:, 4,23,16) = (/ &
     &5.8246e+03_r8,4.3680e+03_r8,2.9119e+03_r8,1.4559e+03_r8,1.5734e+02_r8/)
      kbo(:, 5,23,16) = (/ &
     &7.1749e+03_r8,5.3812e+03_r8,3.5874e+03_r8,1.7937e+03_r8,1.9485e+02_r8/)
      kbo(:, 1,24,16) = (/ &
     &3.1040e+03_r8,2.3279e+03_r8,1.5520e+03_r8,7.7603e+02_r8,8.1731e+01_r8/)
      kbo(:, 2,24,16) = (/ &
     &4.2015e+03_r8,3.1511e+03_r8,2.1007e+03_r8,1.0503e+03_r8,1.0915e+02_r8/)
      kbo(:, 3,24,16) = (/ &
     &5.4526e+03_r8,4.0896e+03_r8,2.7263e+03_r8,1.3632e+03_r8,1.4142e+02_r8/)
      kbo(:, 4,24,16) = (/ &
     &6.8486e+03_r8,5.1365e+03_r8,3.4243e+03_r8,1.7120e+03_r8,1.7856e+02_r8/)
      kbo(:, 5,24,16) = (/ &
     &8.3592e+03_r8,6.2694e+03_r8,4.1793e+03_r8,2.0896e+03_r8,2.2042e+02_r8/)
      kbo(:, 1,25,16) = (/ &
     &3.7353e+03_r8,2.8011e+03_r8,1.8675e+03_r8,9.3379e+02_r8,9.3752e+01_r8/)
      kbo(:, 2,25,16) = (/ &
     &4.9915e+03_r8,3.7438e+03_r8,2.4959e+03_r8,1.2479e+03_r8,1.2447e+02_r8/)
      kbo(:, 3,25,16) = (/ &
     &6.4159e+03_r8,4.8120e+03_r8,3.2081e+03_r8,1.6040e+03_r8,1.6041e+02_r8/)
      kbo(:, 4,25,16) = (/ &
     &7.9803e+03_r8,5.9849e+03_r8,3.9899e+03_r8,1.9951e+03_r8,2.0157e+02_r8/)
      kbo(:, 5,25,16) = (/ &
     &9.6532e+03_r8,7.2408e+03_r8,4.8272e+03_r8,2.4135e+03_r8,2.4756e+02_r8/)
      kbo(:, 1,26,16) = (/ &
     &4.4736e+03_r8,3.3551e+03_r8,2.2367e+03_r8,1.1183e+03_r8,1.0731e+02_r8/)
      kbo(:, 2,26,16) = (/ &
     &5.9023e+03_r8,4.4264e+03_r8,2.9511e+03_r8,1.4756e+03_r8,1.4156e+02_r8/)
      kbo(:, 3,26,16) = (/ &
     &7.5046e+03_r8,5.6279e+03_r8,3.7521e+03_r8,1.8761e+03_r8,1.8123e+02_r8/)
      kbo(:, 4,26,16) = (/ &
     &9.2412e+03_r8,6.9304e+03_r8,4.6207e+03_r8,2.3102e+03_r8,2.2639e+02_r8/)
      kbo(:, 5,26,16) = (/ &
     &1.1070e+04_r8,8.3029e+03_r8,5.5351e+03_r8,2.7676e+03_r8,2.7645e+02_r8/)
      kbo(:, 1,27,16) = (/ &
     &5.2658e+03_r8,3.9745e+03_r8,2.6497e+03_r8,1.3248e+03_r8,1.2199e+02_r8/)
      kbo(:, 2,27,16) = (/ &
     &6.9046e+03_r8,5.1781e+03_r8,3.4305e+03_r8,1.7261e+03_r8,1.5967e+02_r8/)
      kbo(:, 3,27,16) = (/ &
     &8.6809e+03_r8,6.5105e+03_r8,4.3403e+03_r8,2.1700e+03_r8,2.0317e+02_r8/)
      kbo(:, 4,27,16) = (/ &
     &1.0514e+04_r8,7.9337e+03_r8,5.2893e+03_r8,2.6448e+03_r8,2.5202e+02_r8/)
      kbo(:, 5,27,16) = (/ &
     &1.2548e+04_r8,9.4115e+03_r8,6.2746e+03_r8,3.1373e+03_r8,3.0568e+02_r8/)
      kbo(:, 1,28,16) = (/ &
     &6.2040e+03_r8,4.6529e+03_r8,3.1020e+03_r8,1.5511e+03_r8,1.3749e+02_r8/)
      kbo(:, 2,28,16) = (/ &
     &7.9799e+03_r8,5.9854e+03_r8,3.9901e+03_r8,1.9952e+03_r8,1.7869e+02_r8/)
      kbo(:, 3,28,16) = (/ &
     &9.9157e+03_r8,7.4385e+03_r8,4.9578e+03_r8,2.4793e+03_r8,2.2573e+02_r8/)
      kbo(:, 4,28,16) = (/ &
     &1.1961e+04_r8,8.9706e+03_r8,5.9799e+03_r8,2.9900e+03_r8,2.7806e+02_r8/)
      kbo(:, 5,28,16) = (/ &
     &1.4060e+04_r8,1.0545e+04_r8,7.0300e+03_r8,3.5151e+03_r8,3.3499e+02_r8/)
      kbo(:, 1,29,16) = (/ &
     &7.1341e+03_r8,5.3506e+03_r8,3.5671e+03_r8,1.7835e+03_r8,1.5398e+02_r8/)
      kbo(:, 2,29,16) = (/ &
     &9.0577e+03_r8,6.7935e+03_r8,4.5290e+03_r8,2.2643e+03_r8,1.9863e+02_r8/)
      kbo(:, 3,29,16) = (/ &
     &1.1122e+04_r8,8.3426e+03_r8,5.5615e+03_r8,2.7806e+03_r8,2.4903e+02_r8/)
      kbo(:, 4,29,16) = (/ &
     &1.3280e+04_r8,9.9609e+03_r8,6.6400e+03_r8,3.3199e+03_r8,3.0450e+02_r8/)
      kbo(:, 5,29,16) = (/ &
     &1.5478e+04_r8,1.1609e+04_r8,7.7394e+03_r8,3.8697e+03_r8,3.6431e+02_r8/)
      kbo(:, 1,30,16) = (/ &
     &8.0566e+03_r8,6.0423e+03_r8,4.0284e+03_r8,2.0142e+03_r8,1.7115e+02_r8/)
      kbo(:, 2,30,16) = (/ &
     &1.0101e+04_r8,7.5759e+03_r8,5.0505e+03_r8,2.5252e+03_r8,2.1901e+02_r8/)
      kbo(:, 3,30,16) = (/ &
     &1.2267e+04_r8,9.1995e+03_r8,6.1334e+03_r8,3.0668e+03_r8,2.7243e+02_r8/)
      kbo(:, 4,30,16) = (/ &
     &1.4511e+04_r8,1.0883e+04_r8,7.2556e+03_r8,3.6279e+03_r8,3.3082e+02_r8/)
      kbo(:, 5,30,16) = (/ &
     &1.6772e+04_r8,1.2579e+04_r8,8.3858e+03_r8,4.1931e+03_r8,3.9317e+02_r8/)
      kbo(:, 1,31,16) = (/ &
     &8.8982e+03_r8,6.6739e+03_r8,4.4493e+03_r8,2.2245e+03_r8,1.8901e+02_r8/)
      kbo(:, 2,31,16) = (/ &
     &1.1025e+04_r8,8.2681e+03_r8,5.5122e+03_r8,2.7560e+03_r8,2.3984e+02_r8/)
      kbo(:, 3,31,16) = (/ &
     &1.3250e+04_r8,9.9387e+03_r8,6.6258e+03_r8,3.3127e+03_r8,2.9609e+02_r8/)
      kbo(:, 4,31,16) = (/ &
     &1.5535e+04_r8,1.1652e+04_r8,7.7678e+03_r8,3.8841e+03_r8,3.5699e+02_r8/)
      kbo(:, 5,31,16) = (/ &
     &1.7813e+04_r8,1.3361e+04_r8,8.9075e+03_r8,4.4535e+03_r8,4.2172e+02_r8/)
      kbo(:, 1,32,16) = (/ &
     &9.7468e+03_r8,7.3100e+03_r8,4.8729e+03_r8,2.4366e+03_r8,2.0736e+02_r8/)
      kbo(:, 2,32,16) = (/ &
     &1.1942e+04_r8,8.9562e+03_r8,5.9708e+03_r8,2.9855e+03_r8,2.6092e+02_r8/)
      kbo(:, 3,32,16) = (/ &
     &1.4217e+04_r8,1.0663e+04_r8,7.1086e+03_r8,3.5542e+03_r8,3.1978e+02_r8/)
      kbo(:, 4,32,16) = (/ &
     &1.6526e+04_r8,1.2394e+04_r8,8.2625e+03_r8,4.1313e+03_r8,3.8300e+02_r8/)
      kbo(:, 5,32,16) = (/ &
     &1.8815e+04_r8,1.4111e+04_r8,9.4077e+03_r8,4.7034e+03_r8,4.4968e+02_r8/)
      kbo(:, 1,33,16) = (/ &
     &1.0585e+04_r8,7.8868e+03_r8,5.2924e+03_r8,2.6461e+03_r8,2.2603e+02_r8/)
      kbo(:, 2,33,16) = (/ &
     &1.2835e+04_r8,9.6280e+03_r8,6.4182e+03_r8,3.2091e+03_r8,2.8215e+02_r8/)
      kbo(:, 3,33,16) = (/ &
     &1.5147e+04_r8,1.1359e+04_r8,7.5723e+03_r8,3.7863e+03_r8,3.3983e+02_r8/)
      kbo(:, 4,33,16) = (/ &
     &1.7461e+04_r8,1.3096e+04_r8,8.7313e+03_r8,4.3654e+03_r8,4.0847e+02_r8/)
      kbo(:, 5,33,16) = (/ &
     &1.9631e+04_r8,1.4815e+04_r8,9.8770e+03_r8,4.9389e+03_r8,4.7201e+02_r8/)
      kbo(:, 1,34,16) = (/ &
     &1.1432e+04_r8,8.5737e+03_r8,5.7158e+03_r8,2.8579e+03_r8,2.4293e+02_r8/)
      kbo(:, 2,34,16) = (/ &
     &1.3656e+04_r8,1.0308e+04_r8,6.8715e+03_r8,3.4360e+03_r8,3.0114e+02_r8/)
      kbo(:, 3,34,16) = (/ &
     &1.6096e+04_r8,1.2073e+04_r8,8.0473e+03_r8,4.0240e+03_r8,3.6423e+02_r8/)
      kbo(:, 4,34,16) = (/ &
     &1.8435e+04_r8,1.3744e+04_r8,9.2181e+03_r8,4.6088e+03_r8,4.3111e+02_r8/)
      kbo(:, 5,34,16) = (/ &
     &2.0743e+04_r8,1.5458e+04_r8,1.0371e+04_r8,5.1857e+03_r8,5.0086e+02_r8/)
      kbo(:, 1,35,16) = (/ &
     &1.2052e+04_r8,9.0391e+03_r8,6.0261e+03_r8,3.0130e+03_r8,2.5425e+02_r8/)
      kbo(:, 2,35,16) = (/ &
     &1.4410e+04_r8,1.0808e+04_r8,7.2046e+03_r8,3.6026e+03_r8,3.1392e+02_r8/)
      kbo(:, 3,35,16) = (/ &
     &1.6796e+04_r8,1.2598e+04_r8,8.3987e+03_r8,4.1994e+03_r8,3.7832e+02_r8/)
      kbo(:, 4,35,16) = (/ &
     &1.9160e+04_r8,1.4370e+04_r8,9.5799e+03_r8,4.7904e+03_r8,4.4634e+02_r8/)
      kbo(:, 5,35,16) = (/ &
     &2.1483e+04_r8,1.6114e+04_r8,1.0742e+04_r8,5.3711e+03_r8,5.1708e+02_r8/)
      kbo(:, 1,36,16) = (/ &
     &1.2411e+04_r8,9.3078e+03_r8,6.2050e+03_r8,3.1026e+03_r8,2.5887e+02_r8/)
      kbo(:, 2,36,16) = (/ &
     &1.4808e+04_r8,1.1106e+04_r8,7.4043e+03_r8,3.7021e+03_r8,3.1927e+02_r8/)
      kbo(:, 3,36,16) = (/ &
     &1.7228e+04_r8,1.2921e+04_r8,8.6130e+03_r8,4.3067e+03_r8,3.8442e+02_r8/)
      kbo(:, 4,36,16) = (/ &
     &1.9618e+04_r8,1.4714e+04_r8,9.8092e+03_r8,4.9047e+03_r8,4.5297e+02_r8/)
      kbo(:, 5,36,16) = (/ &
     &2.1965e+04_r8,1.6474e+04_r8,1.0982e+04_r8,5.4915e+03_r8,5.1909e+02_r8/)
      kbo(:, 1,37,16) = (/ &
     &1.2464e+04_r8,9.3487e+03_r8,6.2318e+03_r8,3.1159e+03_r8,2.5416e+02_r8/)
      kbo(:, 2,37,16) = (/ &
     &1.4910e+04_r8,1.1181e+04_r8,7.4551e+03_r8,3.7272e+03_r8,3.1436e+02_r8/)
      kbo(:, 3,37,16) = (/ &
     &1.7377e+04_r8,1.3033e+04_r8,8.6893e+03_r8,4.3442e+03_r8,3.7942e+02_r8/)
      kbo(:, 4,37,16) = (/ &
     &1.9817e+04_r8,1.4862e+04_r8,9.9088e+03_r8,4.9531e+03_r8,4.4815e+02_r8/)
      kbo(:, 5,37,16) = (/ &
     &2.2212e+04_r8,1.6660e+04_r8,1.1107e+04_r8,5.5531e+03_r8,5.1970e+02_r8/)
      kbo(:, 1,38,16) = (/ &
     &1.2455e+04_r8,9.3421e+03_r8,6.2277e+03_r8,3.1139e+03_r8,2.4843e+02_r8/)
      kbo(:, 2,38,16) = (/ &
     &1.4944e+04_r8,1.1208e+04_r8,7.4715e+03_r8,3.7356e+03_r8,3.0837e+02_r8/)
      kbo(:, 3,38,16) = (/ &
     &1.7458e+04_r8,1.3093e+04_r8,8.7289e+03_r8,4.3646e+03_r8,3.7326e+02_r8/)
      kbo(:, 4,38,16) = (/ &
     &1.9945e+04_r8,1.4959e+04_r8,9.9720e+03_r8,4.9866e+03_r8,4.4198e+02_r8/)
      kbo(:, 5,38,16) = (/ &
     &2.2391e+04_r8,1.6792e+04_r8,1.1195e+04_r8,5.5974e+03_r8,5.1349e+02_r8/)
      kbo(:, 1,39,16) = (/ &
     &1.2406e+04_r8,9.3076e+03_r8,6.2035e+03_r8,3.1024e+03_r8,2.4239e+02_r8/)
      kbo(:, 2,39,16) = (/ &
     &1.4934e+04_r8,1.1200e+04_r8,7.4672e+03_r8,3.7337e+03_r8,3.0193e+02_r8/)
      kbo(:, 3,39,16) = (/ &
     &1.7492e+04_r8,1.3118e+04_r8,8.7456e+03_r8,4.3725e+03_r8,3.6650e+02_r8/)
      kbo(:, 4,39,16) = (/ &
     &2.0028e+04_r8,1.5022e+04_r8,1.0013e+04_r8,5.0072e+03_r8,4.3512e+02_r8/)
      kbo(:, 5,39,16) = (/ &
     &2.2512e+04_r8,1.6885e+04_r8,1.1257e+04_r8,5.6280e+03_r8,5.0671e+02_r8/)
      kbo(:, 1,40,16) = (/ &
     &1.2191e+04_r8,9.1428e+03_r8,6.0955e+03_r8,3.0476e+03_r8,2.3031e+02_r8/)
      kbo(:, 2,40,16) = (/ &
     &1.4768e+04_r8,1.1076e+04_r8,7.3840e+03_r8,3.6920e+03_r8,2.8879e+02_r8/)
      kbo(:, 3,40,16) = (/ &
     &1.7391e+04_r8,1.3044e+04_r8,8.6959e+03_r8,4.3483e+03_r8,3.5253e+02_r8/)
      kbo(:, 4,40,16) = (/ &
     &2.0001e+04_r8,1.5001e+04_r8,1.0001e+04_r8,5.0007e+03_r8,4.2055e+02_r8/)
      kbo(:, 5,40,16) = (/ &
     &2.2559e+04_r8,1.6919e+04_r8,1.1281e+04_r8,5.6404e+03_r8,4.9160e+02_r8/)
      kbo(:, 1,41,16) = (/ &
     &1.1918e+04_r8,8.9381e+03_r8,5.9590e+03_r8,2.9794e+03_r8,2.1766e+02_r8/)
      kbo(:, 2,41,16) = (/ &
     &1.4546e+04_r8,1.0910e+04_r8,7.2239e+03_r8,3.6364e+03_r8,2.7473e+02_r8/)
      kbo(:, 3,41,16) = (/ &
     &1.7237e+04_r8,1.2927e+04_r8,8.6187e+03_r8,4.3092e+03_r8,3.3421e+02_r8/)
      kbo(:, 4,41,16) = (/ &
     &1.9925e+04_r8,1.4942e+04_r8,9.9613e+03_r8,4.9808e+03_r8,4.0468e+02_r8/)
      kbo(:, 5,41,16) = (/ &
     &2.2566e+04_r8,1.6925e+04_r8,1.1282e+04_r8,5.6408e+03_r8,4.7546e+02_r8/)
      kbo(:, 1,42,16) = (/ &
     &1.1611e+04_r8,8.7088e+03_r8,5.8053e+03_r8,2.9027e+03_r8,2.0505e+02_r8/)
      kbo(:, 2,42,16) = (/ &
     &1.4284e+04_r8,1.0639e+04_r8,7.1417e+03_r8,3.5709e+03_r8,2.6066e+02_r8/)
      kbo(:, 3,42,16) = (/ &
     &1.7038e+04_r8,1.2778e+04_r8,8.5196e+03_r8,4.2591e+03_r8,3.2228e+02_r8/)
      kbo(:, 4,42,16) = (/ &
     &1.9799e+04_r8,1.4850e+04_r8,9.8997e+03_r8,4.9502e+03_r8,3.8865e+02_r8/)
      kbo(:, 5,42,16) = (/ &
     &2.2525e+04_r8,1.6894e+04_r8,1.1262e+04_r8,5.6311e+03_r8,4.5874e+02_r8/)
      kbo(:, 1,43,16) = (/ &
     &1.1239e+04_r8,8.4296e+03_r8,5.6199e+03_r8,2.8098e+03_r8,1.8981e+02_r8/)
      kbo(:, 2,43,16) = (/ &
     &1.3966e+04_r8,1.0473e+04_r8,6.9839e+03_r8,3.4914e+03_r8,2.4348e+02_r8/)
      kbo(:, 3,43,16) = (/ &
     &1.6803e+04_r8,1.2602e+04_r8,8.4011e+03_r8,4.2005e+03_r8,3.0350e+02_r8/)
      kbo(:, 4,43,16) = (/ &
     &1.9668e+04_r8,1.4751e+04_r8,9.8339e+03_r8,4.9166e+03_r8,3.6865e+02_r8/)
      kbo(:, 5,43,16) = (/ &
     &2.2506e+04_r8,1.6879e+04_r8,1.1254e+04_r8,5.6261e+03_r8,4.3789e+02_r8/)
      kbo(:, 1,44,16) = (/ &
     &1.0825e+04_r8,8.1186e+03_r8,5.4125e+03_r8,2.7064e+03_r8,1.7391e+02_r8/)
      kbo(:, 2,44,16) = (/ &
     &1.3603e+04_r8,1.0202e+04_r8,6.8014e+03_r8,3.4006e+03_r8,2.2526e+02_r8/)
      kbo(:, 3,44,16) = (/ &
     &1.6530e+04_r8,1.2398e+04_r8,8.2649e+03_r8,4.1327e+03_r8,2.8337e+02_r8/)
      kbo(:, 4,44,16) = (/ &
     &1.9511e+04_r8,1.4634e+04_r8,9.7557e+03_r8,4.8778e+03_r8,3.4703e+02_r8/)
      kbo(:, 5,44,16) = (/ &
     &2.2482e+04_r8,1.6861e+04_r8,1.1241e+04_r8,5.6203e+03_r8,4.1512e+02_r8/)
      kbo(:, 1,45,16) = (/ &
     &1.0398e+04_r8,7.7989e+03_r8,5.1994e+03_r8,2.5997e+03_r8,1.5876e+02_r8/)
      kbo(:, 2,45,16) = (/ &
     &1.3207e+04_r8,9.9052e+03_r8,6.6032e+03_r8,3.3018e+03_r8,2.0761e+02_r8/)
      kbo(:, 3,45,16) = (/ &
     &1.6220e+04_r8,1.2165e+04_r8,8.1095e+03_r8,4.0543e+03_r8,2.6368e+02_r8/)
      kbo(:, 4,45,16) = (/ &
     &1.9318e+04_r8,1.4390e+04_r8,9.6588e+03_r8,4.8297e+03_r8,3.2574e+02_r8/)
      kbo(:, 5,45,16) = (/ &
     &2.2424e+04_r8,1.6818e+04_r8,1.1212e+04_r8,5.6061e+03_r8,3.9259e+02_r8/)
      kbo(:, 1,46,16) = (/ &
     &9.9189e+03_r8,7.4400e+03_r8,4.9600e+03_r8,2.4797e+03_r8,1.4342e+02_r8/)
      kbo(:, 2,46,16) = (/ &
     &1.2731e+04_r8,9.5482e+03_r8,6.3653e+03_r8,3.1826e+03_r8,1.8954e+02_r8/)
      kbo(:, 3,46,16) = (/ &
     &1.5820e+04_r8,1.1865e+04_r8,7.9099e+03_r8,3.9548e+03_r8,2.4324e+02_r8/)
      kbo(:, 4,46,16) = (/ &
     &1.9036e+04_r8,1.4277e+04_r8,9.5173e+03_r8,4.7590e+03_r8,3.0340e+02_r8/)
      kbo(:, 5,46,16) = (/ &
     &2.2283e+04_r8,1.6712e+04_r8,1.1068e+04_r8,5.5708e+03_r8,3.6873e+02_r8/)
      kbo(:, 1,47,16) = (/ &
     &9.3465e+03_r8,7.0098e+03_r8,4.6733e+03_r8,2.3366e+03_r8,1.2741e+02_r8/)
      kbo(:, 2,47,16) = (/ &
     &1.2131e+04_r8,9.0979e+03_r8,6.0653e+03_r8,3.0325e+03_r8,1.7033e+02_r8/)
      kbo(:, 3,47,16) = (/ &
     &1.5279e+04_r8,1.1459e+04_r8,7.6395e+03_r8,3.8199e+03_r8,2.2121e+02_r8/)
      kbo(:, 4,47,16) = (/ &
     &1.8609e+04_r8,1.3956e+04_r8,9.3042e+03_r8,4.6522e+03_r8,2.7888e+02_r8/)
      kbo(:, 5,47,16) = (/ &
     &2.2011e+04_r8,1.6508e+04_r8,1.1006e+04_r8,5.5025e+03_r8,3.4244e+02_r8/)
      kbo(:, 1,48,16) = (/ &
     &8.7925e+03_r8,6.5945e+03_r8,4.3966e+03_r8,2.1981e+03_r8,1.1262e+02_r8/)
      kbo(:, 2,48,16) = (/ &
     &1.1529e+04_r8,8.6468e+03_r8,5.7644e+03_r8,2.8824e+03_r8,1.5232e+02_r8/)
      kbo(:, 3,48,16) = (/ &
     &1.4702e+04_r8,1.1027e+04_r8,7.3513e+03_r8,3.6755e+03_r8,2.0009e+02_r8/)
      kbo(:, 4,48,16) = (/ &
     &1.8139e+04_r8,1.3604e+04_r8,9.0700e+03_r8,4.5350e+03_r8,2.5528e+02_r8/)
      kbo(:, 5,48,16) = (/ &
     &2.1696e+04_r8,1.6272e+04_r8,1.0846e+04_r8,5.4236e+03_r8,3.1666e+02_r8/)
      kbo(:, 1,49,16) = (/ &
     &8.2532e+03_r8,6.1899e+03_r8,4.1262e+03_r8,2.0633e+03_r8,9.9158e+01_r8/)
      kbo(:, 2,49,16) = (/ &
     &1.0925e+04_r8,8.1939e+03_r8,5.4625e+03_r8,2.7312e+03_r8,1.3556e+02_r8/)
      kbo(:, 3,49,16) = (/ &
     &1.4098e+04_r8,1.0574e+04_r8,7.0499e+03_r8,3.5250e+03_r8,1.8015e+02_r8/)
      kbo(:, 4,49,16) = (/ &
     &1.7628e+04_r8,1.3221e+04_r8,8.8139e+03_r8,4.4071e+03_r8,2.3258e+02_r8/)
      kbo(:, 5,49,16) = (/ &
     &2.1334e+04_r8,1.6000e+04_r8,1.0668e+04_r8,5.3338e+03_r8,2.8877e+02_r8/)
      kbo(:, 1,50,16) = (/ &
     &7.7886e+03_r8,5.8414e+03_r8,3.8943e+03_r8,1.9471e+03_r8,8.7562e+01_r8/)
      kbo(:, 2,50,16) = (/ &
     &1.0399e+04_r8,7.7996e+03_r8,5.1995e+03_r8,2.6000e+03_r8,1.2099e+02_r8/)
      kbo(:, 3,50,16) = (/ &
     &1.3554e+04_r8,1.0165e+04_r8,6.7769e+03_r8,3.3882e+03_r8,1.6257e+02_r8/)
      kbo(:, 4,50,16) = (/ &
     &1.7158e+04_r8,1.2869e+04_r8,8.5791e+03_r8,4.2889e+03_r8,2.1215e+02_r8/)
      kbo(:, 5,50,16) = (/ &
     &2.1011e+04_r8,1.5758e+04_r8,1.0505e+04_r8,5.2531e+03_r8,2.6885e+02_r8/)
      kbo(:, 1,51,16) = (/ &
     &7.3653e+03_r8,5.5240e+03_r8,3.6827e+03_r8,1.8412e+03_r8,7.7231e+01_r8/)
      kbo(:, 2,51,16) = (/ &
     &9.9189e+03_r8,7.4392e+03_r8,4.9594e+03_r8,2.4660e+03_r8,1.0798e+02_r8/)
      kbo(:, 3,51,16) = (/ &
     &1.3047e+04_r8,9.7852e+03_r8,6.5235e+03_r8,3.2615e+03_r8,1.4656e+02_r8/)
      kbo(:, 4,51,16) = (/ &
     &1.6702e+04_r8,1.2527e+04_r8,8.3510e+03_r8,4.1752e+03_r8,1.9328e+02_r8/)
      kbo(:, 5,51,16) = (/ &
     &2.0693e+04_r8,1.5520e+04_r8,1.0347e+04_r8,5.1734e+03_r8,2.4760e+02_r8/)
      kbo(:, 1,52,16) = (/ &
     &6.9562e+03_r8,5.2172e+03_r8,3.4778e+03_r8,1.7389e+03_r8,6.7762e+01_r8/)
      kbo(:, 2,52,16) = (/ &
     &9.4563e+03_r8,7.0922e+03_r8,4.7284e+03_r8,2.3642e+03_r8,9.6034e+01_r8/)
      kbo(:, 3,52,16) = (/ &
     &1.2544e+04_r8,9.4081e+03_r8,6.2721e+03_r8,3.1358e+03_r8,1.3163e+02_r8/)
      kbo(:, 4,52,16) = (/ &
     &1.6228e+04_r8,1.2171e+04_r8,8.1139e+03_r8,4.0563e+03_r8,1.7544e+02_r8/)
      kbo(:, 5,52,16) = (/ &
     &2.0214e+04_r8,1.5266e+04_r8,1.0177e+04_r8,5.0897e+03_r8,2.2714e+02_r8/)
      kbo(:, 1,53,16) = (/ &
     &6.5707e+03_r8,4.8896e+03_r8,3.2854e+03_r8,1.6428e+03_r8,5.9086e+01_r8/)
      kbo(:, 2,53,16) = (/ &
     &9.0178e+03_r8,6.7633e+03_r8,4.5088e+03_r8,2.2544e+03_r8,8.4973e+01_r8/)
      kbo(:, 3,53,16) = (/ &
     &1.2063e+04_r8,9.0476e+03_r8,6.0317e+03_r8,3.0159e+03_r8,1.1770e+02_r8/)
      kbo(:, 4,53,16) = (/ &
     &1.5755e+04_r8,1.1816e+04_r8,7.8772e+03_r8,3.9386e+03_r8,1.5858e+02_r8/)
      kbo(:, 5,53,16) = (/ &
     &1.9999e+04_r8,1.4999e+04_r8,9.9995e+03_r8,5.0000e+03_r8,2.0751e+02_r8/)
      kbo(:, 1,54,16) = (/ &
     &6.2721e+03_r8,4.7041e+03_r8,3.1362e+03_r8,1.5681e+03_r8,5.1875e+01_r8/)
      kbo(:, 2,54,16) = (/ &
     &8.6741e+03_r8,6.5056e+03_r8,4.3370e+03_r8,2.1682e+03_r8,7.5628e+01_r8/)
      kbo(:, 3,54,16) = (/ &
     &1.1700e+04_r8,8.7748e+03_r8,5.8499e+03_r8,2.9249e+03_r8,1.0596e+02_r8/)
      kbo(:, 4,54,16) = (/ &
     &1.5404e+04_r8,1.1553e+04_r8,7.7020e+03_r8,3.8510e+03_r8,1.4404e+02_r8/)
      kbo(:, 5,54,16) = (/ &
     &1.9752e+04_r8,1.4814e+04_r8,9.8758e+03_r8,4.9379e+03_r8,1.9030e+02_r8/)
      kbo(:, 1,55,16) = (/ &
     &6.0231e+03_r8,4.5173e+03_r8,3.0116e+03_r8,1.5058e+03_r8,4.5583e+01_r8/)
      kbo(:, 2,55,16) = (/ &
     &8.3823e+03_r8,6.2868e+03_r8,4.1912e+03_r8,2.0956e+03_r8,6.7362e+01_r8/)
      kbo(:, 3,55,16) = (/ &
     &1.1398e+04_r8,8.5488e+03_r8,5.6992e+03_r8,2.8496e+03_r8,9.5542e+01_r8/)
      kbo(:, 4,55,16) = (/ &
     &1.5124e+04_r8,1.1343e+04_r8,7.5617e+03_r8,3.7808e+03_r8,1.3099e+02_r8/)
      kbo(:, 5,55,16) = (/ &
     &1.9568e+04_r8,1.4676e+04_r8,9.7841e+03_r8,4.8920e+03_r8,1.7464e+02_r8/)
      kbo(:, 1,56,16) = (/ &
     &5.7989e+03_r8,4.3492e+03_r8,2.8995e+03_r8,1.4497e+03_r8,3.9828e+01_r8/)
      kbo(:, 2,56,16) = (/ &
     &8.1232e+03_r8,6.0924e+03_r8,4.0616e+03_r8,2.0308e+03_r8,5.9729e+01_r8/)
      kbo(:, 3,56,16) = (/ &
     &1.1139e+04_r8,8.3546e+03_r8,5.5697e+03_r8,2.7849e+03_r8,8.5801e+01_r8/)
      kbo(:, 4,56,16) = (/ &
     &1.4890e+04_r8,1.1167e+04_r8,7.4448e+03_r8,3.7224e+03_r8,1.1874e+02_r8/)
      kbo(:, 5,56,16) = (/ &
     &1.9429e+04_r8,1.4572e+04_r8,9.7148e+03_r8,4.8574e+03_r8,1.5988e+02_r8/)
      kbo(:, 1,57,16) = (/ &
     &5.6021e+03_r8,4.2016e+03_r8,2.8010e+03_r8,1.4005e+03_r8,3.4593e+01_r8/)
      kbo(:, 2,57,16) = (/ &
     &7.9032e+03_r8,5.9274e+03_r8,3.9516e+03_r8,1.9758e+03_r8,5.2766e+01_r8/)
      kbo(:, 3,57,16) = (/ &
     &1.0919e+04_r8,8.1889e+03_r8,5.4593e+03_r8,2.7295e+03_r8,7.6784e+01_r8/)
      kbo(:, 4,57,16) = (/ &
     &1.4709e+04_r8,1.1031e+04_r8,7.3542e+03_r8,3.6771e+03_r8,1.0741e+02_r8/)
      kbo(:, 5,57,16) = (/ &
     &1.9344e+04_r8,1.4508e+04_r8,9.6719e+03_r8,4.8359e+03_r8,1.4582e+02_r8/)
      kbo(:, 1,58,16) = (/ &
     &2.6461e+03_r8,2.2784e+03_r8,1.7829e+03_r8,1.0638e+03_r8,3.0084e+01_r8/)
      kbo(:, 2,58,16) = (/ &
     &3.7547e+03_r8,3.2329e+03_r8,2.5298e+03_r8,1.5309e+03_r8,4.6706e+01_r8/)
      kbo(:, 3,58,16) = (/ &
     &5.2182e+03_r8,4.4930e+03_r8,3.5159e+03_r8,2.1276e+03_r8,6.8855e+01_r8/)
      kbo(:, 4,58,16) = (/ &
     &7.0852e+03_r8,6.1006e+03_r8,4.7738e+03_r8,2.8889e+03_r8,9.7411e+01_r8/)
      kbo(:, 5,58,16) = (/ &
     &9.3867e+03_r8,8.0822e+03_r8,6.3244e+03_r8,3.8273e+03_r8,1.3335e+02_r8/)
      kbo(:, 1,59,16) = (/ &
     &2.6519e+03_r8,2.2918e+03_r8,1.8023e+03_r8,1.0985e+03_r8,2.8399e+01_r8/)
      kbo(:, 2,59,16) = (/ &
     &3.7709e+03_r8,3.2589e+03_r8,2.5629e+03_r8,1.5620e+03_r8,4.4429e+01_r8/)
      kbo(:, 3,59,16) = (/ &
     &5.2534e+03_r8,4.5401e+03_r8,3.5704e+03_r8,2.1761e+03_r8,6.5844e+01_r8/)
      kbo(:, 4,59,16) = (/ &
     &7.1555e+03_r8,6.1839e+03_r8,4.8632e+03_r8,2.9640e+03_r8,9.3608e+01_r8/)
      kbo(:, 5,59,16) = (/ &
     &9.5069e+03_r8,8.2160e+03_r8,6.4613e+03_r8,3.9381e+03_r8,1.2854e+02_r8/)

!     The array KAO_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level below 100~ mb.   The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amount ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 
!     to that of gas2.  The second index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The third index 
!     runs over the g-channel (1 to 16).

      kao_mn2o( 1, :, 1) = (/ &
     & 1.28178e-05_r8, 1.55472e-05_r8, 1.88578e-05_r8, 2.28735e-05_r8, 2.77442e-05_r8, &
     & 3.36520e-05_r8, 4.08179e-05_r8, 4.95098e-05_r8, 6.00525e-05_r8, 7.28401e-05_r8, &
     & 8.83508e-05_r8, 1.07164e-04_r8, 1.29984e-04_r8, 1.57663e-04_r8, 1.91236e-04_r8, &
     & 2.31958e-04_r8, 2.81352e-04_r8, 3.41263e-04_r8, 4.13932e-04_r8/)
      kao_mn2o( 2, :, 1) = (/ &
     & 1.00725e-01_r8, 1.04470e-01_r8, 1.08355e-01_r8, 1.12384e-01_r8, 1.16563e-01_r8, &
     & 1.20898e-01_r8, 1.25394e-01_r8, 1.30057e-01_r8, 1.34893e-01_r8, 1.39909e-01_r8, &
     & 1.45112e-01_r8, 1.50508e-01_r8, 1.56104e-01_r8, 1.61909e-01_r8, 1.67930e-01_r8, &
     & 1.74175e-01_r8, 1.80652e-01_r8, 1.87369e-01_r8, 1.94337e-01_r8/)
      kao_mn2o( 3, :, 1) = (/ &
     & 1.94143e-01_r8, 1.97380e-01_r8, 2.00670e-01_r8, 2.04016e-01_r8, 2.07417e-01_r8, &
     & 2.10875e-01_r8, 2.14390e-01_r8, 2.17964e-01_r8, 2.21598e-01_r8, 2.25292e-01_r8, &
     & 2.29048e-01_r8, 2.32867e-01_r8, 2.36749e-01_r8, 2.40696e-01_r8, 2.44708e-01_r8, &
     & 2.48788e-01_r8, 2.52936e-01_r8, 2.57152e-01_r8, 2.61439e-01_r8/)
      kao_mn2o( 4, :, 1) = (/ &
     & 2.98127e-01_r8, 3.00016e-01_r8, 3.01916e-01_r8, 3.03829e-01_r8, 3.05754e-01_r8, &
     & 3.07691e-01_r8, 3.09640e-01_r8, 3.11601e-01_r8, 3.13575e-01_r8, 3.15562e-01_r8, &
     & 3.17561e-01_r8, 3.19572e-01_r8, 3.21597e-01_r8, 3.23634e-01_r8, 3.25684e-01_r8, &
     & 3.27748e-01_r8, 3.29824e-01_r8, 3.31913e-01_r8, 3.34016e-01_r8/)
      kao_mn2o( 5, :, 1) = (/ &
     & 4.45029e-01_r8, 4.45243e-01_r8, 4.45458e-01_r8, 4.45673e-01_r8, 4.45889e-01_r8, &
     & 4.46104e-01_r8, 4.46319e-01_r8, 4.46535e-01_r8, 4.46750e-01_r8, 4.46966e-01_r8, &
     & 4.47182e-01_r8, 4.47398e-01_r8, 4.47614e-01_r8, 4.47830e-01_r8, 4.48046e-01_r8, &
     & 4.48262e-01_r8, 4.48479e-01_r8, 4.48695e-01_r8, 4.48912e-01_r8/)
      kao_mn2o( 6, :, 1) = (/ &
     & 7.15677e-01_r8, 7.14564e-01_r8, 7.13452e-01_r8, 7.12342e-01_r8, 7.11234e-01_r8, &
     & 7.10127e-01_r8, 7.09022e-01_r8, 7.07919e-01_r8, 7.06818e-01_r8, 7.05718e-01_r8, &
     & 7.04620e-01_r8, 7.03524e-01_r8, 7.02429e-01_r8, 7.01336e-01_r8, 7.00245e-01_r8, &
     & 6.99156e-01_r8, 6.98068e-01_r8, 6.96982e-01_r8, 6.95898e-01_r8/)
      kao_mn2o( 7, :, 1) = (/ &
     & 9.89605e-01_r8, 9.85128e-01_r8, 9.80671e-01_r8, 9.76234e-01_r8, 9.71817e-01_r8, &
     & 9.67421e-01_r8, 9.63044e-01_r8, 9.58687e-01_r8, 9.54350e-01_r8, 9.50032e-01_r8, &
     & 9.45734e-01_r8, 9.41455e-01_r8, 9.37196e-01_r8, 9.32956e-01_r8, 9.28735e-01_r8, &
     & 9.24533e-01_r8, 9.20350e-01_r8, 9.16187e-01_r8, 9.12042e-01_r8/)
      kao_mn2o( 8, :, 1) = (/ &
     & 1.12229e+00_r8, 1.11502e+00_r8, 1.10779e+00_r8, 1.10061e+00_r8, 1.09348e+00_r8, &
     & 1.08639e+00_r8, 1.07935e+00_r8, 1.07235e+00_r8, 1.06540e+00_r8, 1.05850e+00_r8, &
     & 1.05164e+00_r8, 1.04482e+00_r8, 1.03805e+00_r8, 1.03132e+00_r8, 1.02464e+00_r8, &
     & 1.01799e+00_r8, 1.01140e+00_r8, 1.00484e+00_r8, 9.98328e-01_r8/)
      kao_mn2o( 9, :, 1) = (/ &
     & 7.20959e-01_r8, 7.22839e-01_r8, 7.24723e-01_r8, 7.26612e-01_r8, 7.28506e-01_r8, &
     & 7.30405e-01_r8, 7.32309e-01_r8, 7.34218e-01_r8, 7.36132e-01_r8, 7.38051e-01_r8, &
     & 7.39975e-01_r8, 7.41904e-01_r8, 7.43838e-01_r8, 7.45777e-01_r8, 7.47721e-01_r8, &
     & 7.49670e-01_r8, 7.51624e-01_r8, 7.53584e-01_r8, 7.55548e-01_r8/)
      kao_mn2o( 1, :, 2) = (/ &
     & 1.62152e-03_r8, 1.81627e-03_r8, 2.03443e-03_r8, 2.27878e-03_r8, 2.55248e-03_r8, &
     & 2.85906e-03_r8, 3.20245e-03_r8, 3.58710e-03_r8, 4.01794e-03_r8, 4.50053e-03_r8, &
     & 5.04109e-03_r8, 5.64657e-03_r8, 6.32477e-03_r8, 7.08444e-03_r8, 7.93534e-03_r8, &
     & 8.88845e-03_r8, 9.95603e-03_r8, 1.11518e-02_r8, 1.24913e-02_r8/)
      kao_mn2o( 2, :, 2) = (/ &
     & 3.73716e-01_r8, 3.72491e-01_r8, 3.71271e-01_r8, 3.70054e-01_r8, 3.68841e-01_r8, &
     & 3.67633e-01_r8, 3.66428e-01_r8, 3.65227e-01_r8, 3.64031e-01_r8, 3.62838e-01_r8, &
     & 3.61649e-01_r8, 3.60464e-01_r8, 3.59283e-01_r8, 3.58106e-01_r8, 3.56932e-01_r8, &
     & 3.55763e-01_r8, 3.54597e-01_r8, 3.53435e-01_r8, 3.52277e-01_r8/)
      kao_mn2o( 3, :, 2) = (/ &
     & 5.46240e-01_r8, 5.42972e-01_r8, 5.39724e-01_r8, 5.36495e-01_r8, 5.33285e-01_r8, &
     & 5.30095e-01_r8, 5.26923e-01_r8, 5.23771e-01_r8, 5.20637e-01_r8, 5.17523e-01_r8, &
     & 5.14426e-01_r8, 5.11349e-01_r8, 5.08290e-01_r8, 5.05249e-01_r8, 5.02226e-01_r8, &
     & 4.99221e-01_r8, 4.96235e-01_r8, 4.93266e-01_r8, 4.90315e-01_r8/)
      kao_mn2o( 4, :, 2) = (/ &
     & 8.35399e-01_r8, 8.36766e-01_r8, 8.38135e-01_r8, 8.39507e-01_r8, 8.40880e-01_r8, &
     & 8.42256e-01_r8, 8.43635e-01_r8, 8.45015e-01_r8, 8.46398e-01_r8, 8.47783e-01_r8, &
     & 8.49170e-01_r8, 8.50559e-01_r8, 8.51951e-01_r8, 8.53345e-01_r8, 8.54742e-01_r8, &
     & 8.56140e-01_r8, 8.57541e-01_r8, 8.58944e-01_r8, 8.60350e-01_r8/)
      kao_mn2o( 5, :, 2) = (/ &
     & 1.04433e+00_r8, 1.04864e+00_r8, 1.05297e+00_r8, 1.05731e+00_r8, 1.06168e+00_r8, &
     & 1.06606e+00_r8, 1.07046e+00_r8, 1.07488e+00_r8, 1.07932e+00_r8, 1.08377e+00_r8, &
     & 1.08824e+00_r8, 1.09274e+00_r8, 1.09725e+00_r8, 1.10178e+00_r8, 1.10632e+00_r8, &
     & 1.11089e+00_r8, 1.11547e+00_r8, 1.12008e+00_r8, 1.12470e+00_r8/)
      kao_mn2o( 6, :, 2) = (/ &
     & 1.22341e+00_r8, 1.22885e+00_r8, 1.23431e+00_r8, 1.23980e+00_r8, 1.24531e+00_r8, &
     & 1.25084e+00_r8, 1.25640e+00_r8, 1.26199e+00_r8, 1.26760e+00_r8, 1.27323e+00_r8, &
     & 1.27889e+00_r8, 1.28458e+00_r8, 1.29029e+00_r8, 1.29602e+00_r8, 1.30178e+00_r8, &
     & 1.30757e+00_r8, 1.31338e+00_r8, 1.31922e+00_r8, 1.32508e+00_r8/)
      kao_mn2o( 7, :, 2) = (/ &
     & 1.67595e+00_r8, 1.68296e+00_r8, 1.69000e+00_r8, 1.69707e+00_r8, 1.70417e+00_r8, &
     & 1.71130e+00_r8, 1.71846e+00_r8, 1.72565e+00_r8, 1.73287e+00_r8, 1.74012e+00_r8, &
     & 1.74740e+00_r8, 1.75471e+00_r8, 1.76206e+00_r8, 1.76943e+00_r8, 1.77683e+00_r8, &
     & 1.78426e+00_r8, 1.79173e+00_r8, 1.79922e+00_r8, 1.80675e+00_r8/)
      kao_mn2o( 8, :, 2) = (/ &
     & 2.76890e+00_r8, 2.76981e+00_r8, 2.77072e+00_r8, 2.77163e+00_r8, 2.77254e+00_r8, &
     & 2.77345e+00_r8, 2.77436e+00_r8, 2.77527e+00_r8, 2.77618e+00_r8, 2.77709e+00_r8, &
     & 2.77800e+00_r8, 2.77891e+00_r8, 2.77982e+00_r8, 2.78074e+00_r8, 2.78165e+00_r8, &
     & 2.78256e+00_r8, 2.78348e+00_r8, 2.78439e+00_r8, 2.78530e+00_r8/)
      kao_mn2o( 9, :, 2) = (/ &
     & 8.00944e-01_r8, 7.95531e-01_r8, 7.90155e-01_r8, 7.84815e-01_r8, 7.79511e-01_r8, &
     & 7.74243e-01_r8, 7.69011e-01_r8, 7.63813e-01_r8, 7.58652e-01_r8, 7.53525e-01_r8, &
     & 7.48432e-01_r8, 7.43374e-01_r8, 7.38350e-01_r8, 7.33360e-01_r8, 7.28404e-01_r8, &
     & 7.23482e-01_r8, 7.18592e-01_r8, 7.13736e-01_r8, 7.08912e-01_r8/)
      kao_mn2o( 1, :, 3) = (/ &
     & 5.26578e-02_r8, 5.59000e-02_r8, 5.93419e-02_r8, 6.29957e-02_r8, 6.68744e-02_r8, &
     & 7.09920e-02_r8, 7.53631e-02_r8, 8.00034e-02_r8, 8.49294e-02_r8, 9.01586e-02_r8, &
     & 9.57099e-02_r8, 1.01603e-01_r8, 1.07859e-01_r8, 1.14500e-01_r8, 1.21550e-01_r8, &
     & 1.29034e-01_r8, 1.36979e-01_r8, 1.45413e-01_r8, 1.54366e-01_r8/)
      kao_mn2o( 2, :, 3) = (/ &
     & 8.18393e-01_r8, 8.20623e-01_r8, 8.22860e-01_r8, 8.25103e-01_r8, 8.27352e-01_r8, &
     & 8.29608e-01_r8, 8.31869e-01_r8, 8.34137e-01_r8, 8.36410e-01_r8, 8.38690e-01_r8, &
     & 8.40976e-01_r8, 8.43269e-01_r8, 8.45567e-01_r8, 8.47872e-01_r8, 8.50183e-01_r8, &
     & 8.52501e-01_r8, 8.54825e-01_r8, 8.57155e-01_r8, 8.59491e-01_r8/)
      kao_mn2o( 3, :, 3) = (/ &
     & 1.02454e+00_r8, 1.03210e+00_r8, 1.03972e+00_r8, 1.04740e+00_r8, 1.05514e+00_r8, &
     & 1.06293e+00_r8, 1.07077e+00_r8, 1.07868e+00_r8, 1.08665e+00_r8, 1.09467e+00_r8, &
     & 1.10275e+00_r8, 1.11089e+00_r8, 1.11910e+00_r8, 1.12736e+00_r8, 1.13568e+00_r8, &
     & 1.14407e+00_r8, 1.15252e+00_r8, 1.16103e+00_r8, 1.16960e+00_r8/)
      kao_mn2o( 4, :, 3) = (/ &
     & 1.11755e+00_r8, 1.12348e+00_r8, 1.12944e+00_r8, 1.13543e+00_r8, 1.14146e+00_r8, &
     & 1.14752e+00_r8, 1.15360e+00_r8, 1.15972e+00_r8, 1.16588e+00_r8, 1.17206e+00_r8, &
     & 1.17828e+00_r8, 1.18453e+00_r8, 1.19082e+00_r8, 1.19714e+00_r8, 1.20349e+00_r8, &
     & 1.20988e+00_r8, 1.21630e+00_r8, 1.22275e+00_r8, 1.22924e+00_r8/)
      kao_mn2o( 5, :, 3) = (/ &
     & 1.41993e+00_r8, 1.42353e+00_r8, 1.42713e+00_r8, 1.43074e+00_r8, 1.43436e+00_r8, &
     & 1.43799e+00_r8, 1.44163e+00_r8, 1.44528e+00_r8, 1.44894e+00_r8, 1.45261e+00_r8, &
     & 1.45628e+00_r8, 1.45997e+00_r8, 1.46367e+00_r8, 1.46737e+00_r8, 1.47108e+00_r8, &
     & 1.47481e+00_r8, 1.47854e+00_r8, 1.48228e+00_r8, 1.48603e+00_r8/)
      kao_mn2o( 6, :, 3) = (/ &
     & 1.37725e+00_r8, 1.38029e+00_r8, 1.38334e+00_r8, 1.38640e+00_r8, 1.38947e+00_r8, &
     & 1.39254e+00_r8, 1.39562e+00_r8, 1.39870e+00_r8, 1.40179e+00_r8, 1.40489e+00_r8, &
     & 1.40800e+00_r8, 1.41111e+00_r8, 1.41423e+00_r8, 1.41736e+00_r8, 1.42049e+00_r8, &
     & 1.42363e+00_r8, 1.42678e+00_r8, 1.42993e+00_r8, 1.43309e+00_r8/)
      kao_mn2o( 7, :, 3) = (/ &
     & 1.34579e+00_r8, 1.34584e+00_r8, 1.34589e+00_r8, 1.34594e+00_r8, 1.34599e+00_r8, &
     & 1.34603e+00_r8, 1.34608e+00_r8, 1.34613e+00_r8, 1.34618e+00_r8, 1.34623e+00_r8, &
     & 1.34627e+00_r8, 1.34632e+00_r8, 1.34637e+00_r8, 1.34642e+00_r8, 1.34647e+00_r8, &
     & 1.34651e+00_r8, 1.34656e+00_r8, 1.34661e+00_r8, 1.34666e+00_r8/)
      kao_mn2o( 8, :, 3) = (/ &
     & 9.15268e-01_r8, 9.12779e-01_r8, 9.10298e-01_r8, 9.07823e-01_r8, 9.05355e-01_r8, &
     & 9.02893e-01_r8, 9.00438e-01_r8, 8.97990e-01_r8, 8.95549e-01_r8, 8.93114e-01_r8, &
     & 8.90686e-01_r8, 8.88264e-01_r8, 8.85849e-01_r8, 8.83441e-01_r8, 8.81039e-01_r8, &
     & 8.78644e-01_r8, 8.76255e-01_r8, 8.73873e-01_r8, 8.71497e-01_r8/)
      kao_mn2o( 9, :, 3) = (/ &
     & 1.12514e+00_r8, 1.13523e+00_r8, 1.14541e+00_r8, 1.15568e+00_r8, 1.16604e+00_r8, &
     & 1.17649e+00_r8, 1.18704e+00_r8, 1.19768e+00_r8, 1.20841e+00_r8, 1.21925e+00_r8, &
     & 1.23018e+00_r8, 1.24121e+00_r8, 1.25233e+00_r8, 1.26356e+00_r8, 1.27489e+00_r8, &
     & 1.28632e+00_r8, 1.29785e+00_r8, 1.30948e+00_r8, 1.32122e+00_r8/)
      kao_mn2o( 1, :, 4) = (/ &
     & 4.65135e-01_r8, 4.69677e-01_r8, 4.74264e-01_r8, 4.78895e-01_r8, 4.83572e-01_r8, &
     & 4.88294e-01_r8, 4.93063e-01_r8, 4.97878e-01_r8, 5.02740e-01_r8, 5.07649e-01_r8, &
     & 5.12607e-01_r8, 5.17613e-01_r8, 5.22667e-01_r8, 5.27771e-01_r8, 5.32925e-01_r8, &
     & 5.38130e-01_r8, 5.43385e-01_r8, 5.48691e-01_r8, 5.54049e-01_r8/)
      kao_mn2o( 2, :, 4) = (/ &
     & 9.71592e-01_r8, 9.74472e-01_r8, 9.77360e-01_r8, 9.80257e-01_r8, 9.83163e-01_r8, &
     & 9.86077e-01_r8, 9.89000e-01_r8, 9.91931e-01_r8, 9.94871e-01_r8, 9.97820e-01_r8, &
     & 1.00078e+00_r8, 1.00374e+00_r8, 1.00672e+00_r8, 1.00970e+00_r8, 1.01270e+00_r8, &
     & 1.01570e+00_r8, 1.01871e+00_r8, 1.02173e+00_r8, 1.02476e+00_r8/)
      kao_mn2o( 3, :, 4) = (/ &
     & 1.48090e+00_r8, 1.48238e+00_r8, 1.48385e+00_r8, 1.48532e+00_r8, 1.48680e+00_r8, &
     & 1.48828e+00_r8, 1.48976e+00_r8, 1.49124e+00_r8, 1.49272e+00_r8, 1.49420e+00_r8, &
     & 1.49569e+00_r8, 1.49717e+00_r8, 1.49866e+00_r8, 1.50015e+00_r8, 1.50164e+00_r8, &
     & 1.50313e+00_r8, 1.50463e+00_r8, 1.50612e+00_r8, 1.50762e+00_r8/)
      kao_mn2o( 4, :, 4) = (/ &
     & 1.50599e+00_r8, 1.50541e+00_r8, 1.50483e+00_r8, 1.50426e+00_r8, 1.50368e+00_r8, &
     & 1.50310e+00_r8, 1.50252e+00_r8, 1.50195e+00_r8, 1.50137e+00_r8, 1.50079e+00_r8, &
     & 1.50022e+00_r8, 1.49964e+00_r8, 1.49906e+00_r8, 1.49849e+00_r8, 1.49791e+00_r8, &
     & 1.49734e+00_r8, 1.49676e+00_r8, 1.49619e+00_r8, 1.49561e+00_r8/)
      kao_mn2o( 5, :, 4) = (/ &
     & 1.25396e+00_r8, 1.25230e+00_r8, 1.25065e+00_r8, 1.24900e+00_r8, 1.24735e+00_r8, &
     & 1.24570e+00_r8, 1.24405e+00_r8, 1.24241e+00_r8, 1.24077e+00_r8, 1.23913e+00_r8, &
     & 1.23749e+00_r8, 1.23586e+00_r8, 1.23423e+00_r8, 1.23260e+00_r8, 1.23097e+00_r8, &
     & 1.22934e+00_r8, 1.22772e+00_r8, 1.22610e+00_r8, 1.22448e+00_r8/)
      kao_mn2o( 6, :, 4) = (/ &
     & 1.27104e+00_r8, 1.26416e+00_r8, 1.25731e+00_r8, 1.25050e+00_r8, 1.24373e+00_r8, &
     & 1.23700e+00_r8, 1.23030e+00_r8, 1.22364e+00_r8, 1.21701e+00_r8, 1.21043e+00_r8, &
     & 1.20387e+00_r8, 1.19735e+00_r8, 1.19087e+00_r8, 1.18442e+00_r8, 1.17801e+00_r8, &
     & 1.17163e+00_r8, 1.16529e+00_r8, 1.15898e+00_r8, 1.15270e+00_r8/)
      kao_mn2o( 7, :, 4) = (/ &
     & 9.57877e-01_r8, 9.49712e-01_r8, 9.41617e-01_r8, 9.33591e-01_r8, 9.25633e-01_r8, &
     & 9.17743e-01_r8, 9.09920e-01_r8, 9.02164e-01_r8, 8.94473e-01_r8, 8.86849e-01_r8, &
     & 8.79289e-01_r8, 8.71794e-01_r8, 8.64363e-01_r8, 8.56995e-01_r8, 8.49690e-01_r8, &
     & 8.42447e-01_r8, 8.35266e-01_r8, 8.28147e-01_r8, 8.21087e-01_r8/)
      kao_mn2o( 8, :, 4) = (/ &
     & 4.75787e-01_r8, 4.77208e-01_r8, 4.78633e-01_r8, 4.80063e-01_r8, 4.81496e-01_r8, &
     & 4.82934e-01_r8, 4.84377e-01_r8, 4.85823e-01_r8, 4.87274e-01_r8, 4.88730e-01_r8, &
     & 4.90189e-01_r8, 4.91653e-01_r8, 4.93122e-01_r8, 4.94595e-01_r8, 4.96072e-01_r8, &
     & 4.97553e-01_r8, 4.99039e-01_r8, 5.00530e-01_r8, 5.02025e-01_r8/)
      kao_mn2o( 9, :, 4) = (/ &
     & 2.42533e+00_r8, 2.41357e+00_r8, 2.40188e+00_r8, 2.39024e+00_r8, 2.37866e+00_r8, &
     & 2.36713e+00_r8, 2.35566e+00_r8, 2.34425e+00_r8, 2.33289e+00_r8, 2.32158e+00_r8, &
     & 2.31033e+00_r8, 2.29914e+00_r8, 2.28800e+00_r8, 2.27691e+00_r8, 2.26588e+00_r8, &
     & 2.25490e+00_r8, 2.24397e+00_r8, 2.23310e+00_r8, 2.22228e+00_r8/)
      kao_mn2o( 1, :, 5) = (/ &
     & 1.53885e+00_r8, 1.53590e+00_r8, 1.53297e+00_r8, 1.53004e+00_r8, 1.52711e+00_r8, &
     & 1.52419e+00_r8, 1.52128e+00_r8, 1.51837e+00_r8, 1.51547e+00_r8, 1.51257e+00_r8, &
     & 1.50968e+00_r8, 1.50679e+00_r8, 1.50391e+00_r8, 1.50104e+00_r8, 1.49817e+00_r8, &
     & 1.49530e+00_r8, 1.49245e+00_r8, 1.48959e+00_r8, 1.48675e+00_r8/)
      kao_mn2o( 2, :, 5) = (/ &
     & 1.83368e+00_r8, 1.83530e+00_r8, 1.83692e+00_r8, 1.83854e+00_r8, 1.84016e+00_r8, &
     & 1.84178e+00_r8, 1.84340e+00_r8, 1.84503e+00_r8, 1.84665e+00_r8, 1.84828e+00_r8, &
     & 1.84991e+00_r8, 1.85154e+00_r8, 1.85317e+00_r8, 1.85480e+00_r8, 1.85644e+00_r8, &
     & 1.85807e+00_r8, 1.85971e+00_r8, 1.86135e+00_r8, 1.86299e+00_r8/)
      kao_mn2o( 3, :, 5) = (/ &
     & 1.49593e+00_r8, 1.49279e+00_r8, 1.48965e+00_r8, 1.48652e+00_r8, 1.48340e+00_r8, &
     & 1.48028e+00_r8, 1.47717e+00_r8, 1.47406e+00_r8, 1.47096e+00_r8, 1.46787e+00_r8, &
     & 1.46479e+00_r8, 1.46171e+00_r8, 1.45863e+00_r8, 1.45557e+00_r8, 1.45251e+00_r8, &
     & 1.44946e+00_r8, 1.44641e+00_r8, 1.44337e+00_r8, 1.44033e+00_r8/)
      kao_mn2o( 4, :, 5) = (/ &
     & 1.40048e+00_r8, 1.39228e+00_r8, 1.38413e+00_r8, 1.37603e+00_r8, 1.36798e+00_r8, &
     & 1.35997e+00_r8, 1.35201e+00_r8, 1.34410e+00_r8, 1.33623e+00_r8, 1.32841e+00_r8, &
     & 1.32064e+00_r8, 1.31291e+00_r8, 1.30522e+00_r8, 1.29758e+00_r8, 1.28999e+00_r8, &
     & 1.28244e+00_r8, 1.27493e+00_r8, 1.26747e+00_r8, 1.26005e+00_r8/)
      kao_mn2o( 5, :, 5) = (/ &
     & 1.22253e+00_r8, 1.21202e+00_r8, 1.20160e+00_r8, 1.19126e+00_r8, 1.18102e+00_r8, &
     & 1.17087e+00_r8, 1.16080e+00_r8, 1.15082e+00_r8, 1.14092e+00_r8, 1.13111e+00_r8, &
     & 1.12139e+00_r8, 1.11174e+00_r8, 1.10219e+00_r8, 1.09271e+00_r8, 1.08331e+00_r8, &
     & 1.07400e+00_r8, 1.06476e+00_r8, 1.05561e+00_r8, 1.04653e+00_r8/)
      kao_mn2o( 6, :, 5) = (/ &
     & 1.07930e+00_r8, 1.06998e+00_r8, 1.06075e+00_r8, 1.05159e+00_r8, 1.04251e+00_r8, &
     & 1.03352e+00_r8, 1.02459e+00_r8, 1.01575e+00_r8, 1.00698e+00_r8, 9.98291e-01_r8, &
     & 9.89674e-01_r8, 9.81131e-01_r8, 9.72663e-01_r8, 9.64267e-01_r8, 9.55944e-01_r8, &
     & 9.47692e-01_r8, 9.39512e-01_r8, 9.31402e-01_r8, 9.23363e-01_r8/)
      kao_mn2o( 7, :, 5) = (/ &
     & 7.87066e-01_r8, 7.82767e-01_r8, 7.78490e-01_r8, 7.74237e-01_r8, 7.70008e-01_r8, &
     & 7.65801e-01_r8, 7.61617e-01_r8, 7.57457e-01_r8, 7.53319e-01_r8, 7.49203e-01_r8, &
     & 7.45110e-01_r8, 7.41040e-01_r8, 7.36991e-01_r8, 7.32965e-01_r8, 7.28961e-01_r8, &
     & 7.24979e-01_r8, 7.21018e-01_r8, 7.17079e-01_r8, 7.13161e-01_r8/)
      kao_mn2o( 8, :, 5) = (/ &
     & 3.83362e-01_r8, 3.84405e-01_r8, 3.85452e-01_r8, 3.86501e-01_r8, 3.87552e-01_r8, &
     & 3.88607e-01_r8, 3.89665e-01_r8, 3.90725e-01_r8, 3.91788e-01_r8, 3.92855e-01_r8, &
     & 3.93924e-01_r8, 3.94996e-01_r8, 3.96071e-01_r8, 3.97149e-01_r8, 3.98229e-01_r8, &
     & 3.99313e-01_r8, 4.00400e-01_r8, 4.01489e-01_r8, 4.02582e-01_r8/)
      kao_mn2o( 9, :, 5) = (/ &
     & 8.97278e-01_r8, 8.92873e-01_r8, 8.88490e-01_r8, 8.84128e-01_r8, 8.79787e-01_r8, &
     & 8.75468e-01_r8, 8.71170e-01_r8, 8.66893e-01_r8, 8.62637e-01_r8, 8.58402e-01_r8, &
     & 8.54187e-01_r8, 8.49994e-01_r8, 8.45821e-01_r8, 8.41668e-01_r8, 8.37536e-01_r8, &
     & 8.33424e-01_r8, 8.29333e-01_r8, 8.25261e-01_r8, 8.21209e-01_r8/)
      kao_mn2o( 1, :, 6) = (/ &
     & 1.83809e+00_r8, 1.84036e+00_r8, 1.84264e+00_r8, 1.84491e+00_r8, 1.84720e+00_r8, &
     & 1.84948e+00_r8, 1.85177e+00_r8, 1.85406e+00_r8, 1.85635e+00_r8, 1.85864e+00_r8, &
     & 1.86094e+00_r8, 1.86324e+00_r8, 1.86555e+00_r8, 1.86785e+00_r8, 1.87016e+00_r8, &
     & 1.87247e+00_r8, 1.87479e+00_r8, 1.87711e+00_r8, 1.87943e+00_r8/)
      kao_mn2o( 2, :, 6) = (/ &
     & 1.82624e+00_r8, 1.81564e+00_r8, 1.80510e+00_r8, 1.79463e+00_r8, 1.78421e+00_r8, &
     & 1.77386e+00_r8, 1.76356e+00_r8, 1.75333e+00_r8, 1.74315e+00_r8, 1.73304e+00_r8, &
     & 1.72298e+00_r8, 1.71298e+00_r8, 1.70304e+00_r8, 1.69316e+00_r8, 1.68333e+00_r8, &
     & 1.67356e+00_r8, 1.66385e+00_r8, 1.65419e+00_r8, 1.64459e+00_r8/)
      kao_mn2o( 3, :, 6) = (/ &
     & 1.35442e+00_r8, 1.34174e+00_r8, 1.32918e+00_r8, 1.31673e+00_r8, 1.30440e+00_r8, &
     & 1.29219e+00_r8, 1.28010e+00_r8, 1.26811e+00_r8, 1.25624e+00_r8, 1.24448e+00_r8, &
     & 1.23283e+00_r8, 1.22129e+00_r8, 1.20985e+00_r8, 1.19853e+00_r8, 1.18731e+00_r8, &
     & 1.17619e+00_r8, 1.16518e+00_r8, 1.15427e+00_r8, 1.14347e+00_r8/)
      kao_mn2o( 4, :, 6) = (/ &
     & 1.10510e+00_r8, 1.09473e+00_r8, 1.08446e+00_r8, 1.07429e+00_r8, 1.06420e+00_r8, &
     & 1.05422e+00_r8, 1.04433e+00_r8, 1.03453e+00_r8, 1.02482e+00_r8, 1.01520e+00_r8, &
     & 1.00568e+00_r8, 9.96238e-01_r8, 9.86890e-01_r8, 9.77629e-01_r8, 9.68455e-01_r8, &
     & 9.59367e-01_r8, 9.50365e-01_r8, 9.41447e-01_r8, 9.32612e-01_r8/)
      kao_mn2o( 5, :, 6) = (/ &
     & 1.01083e+00_r8, 1.00221e+00_r8, 9.93656e-01_r8, 9.85178e-01_r8, 9.76772e-01_r8, &
     & 9.68437e-01_r8, 9.60174e-01_r8, 9.51981e-01_r8, 9.43859e-01_r8, 9.35805e-01_r8, &
     & 9.27821e-01_r8, 9.19904e-01_r8, 9.12055e-01_r8, 9.04273e-01_r8, 8.96557e-01_r8, &
     & 8.88907e-01_r8, 8.81323e-01_r8, 8.73803e-01_r8, 8.66347e-01_r8/)
      kao_mn2o( 6, :, 6) = (/ &
     & 5.91415e-01_r8, 5.90427e-01_r8, 5.89441e-01_r8, 5.88457e-01_r8, 5.87474e-01_r8, &
     & 5.86493e-01_r8, 5.85514e-01_r8, 5.84536e-01_r8, 5.83559e-01_r8, 5.82585e-01_r8, &
     & 5.81612e-01_r8, 5.80640e-01_r8, 5.79671e-01_r8, 5.78703e-01_r8, 5.77736e-01_r8, &
     & 5.76771e-01_r8, 5.75808e-01_r8, 5.74846e-01_r8, 5.73886e-01_r8/)
      kao_mn2o( 7, :, 6) = (/ &
     & 3.68189e-01_r8, 3.70029e-01_r8, 3.71877e-01_r8, 3.73735e-01_r8, 3.75603e-01_r8, &
     & 3.77479e-01_r8, 3.79365e-01_r8, 3.81260e-01_r8, 3.83165e-01_r8, 3.85079e-01_r8, &
     & 3.87003e-01_r8, 3.88937e-01_r8, 3.90880e-01_r8, 3.92833e-01_r8, 3.94795e-01_r8, &
     & 3.96768e-01_r8, 3.98750e-01_r8, 4.00742e-01_r8, 4.02744e-01_r8/)
      kao_mn2o( 8, :, 6) = (/ &
     & 2.98721e-01_r8, 2.99932e-01_r8, 3.01149e-01_r8, 3.02370e-01_r8, 3.03597e-01_r8, &
     & 3.04828e-01_r8, 3.06064e-01_r8, 3.07306e-01_r8, 3.08552e-01_r8, 3.09804e-01_r8, &
     & 3.11060e-01_r8, 3.12322e-01_r8, 3.13589e-01_r8, 3.14860e-01_r8, 3.16138e-01_r8, &
     & 3.17420e-01_r8, 3.18707e-01_r8, 3.20000e-01_r8, 3.21298e-01_r8/)
      kao_mn2o( 9, :, 6) = (/ &
     & 3.76116e-01_r8, 3.77276e-01_r8, 3.78439e-01_r8, 3.79606e-01_r8, 3.80777e-01_r8, &
     & 3.81951e-01_r8, 3.83129e-01_r8, 3.84310e-01_r8, 3.85495e-01_r8, 3.86684e-01_r8, &
     & 3.87876e-01_r8, 3.89072e-01_r8, 3.90272e-01_r8, 3.91475e-01_r8, 3.92682e-01_r8, &
     & 3.93893e-01_r8, 3.95107e-01_r8, 3.96326e-01_r8, 3.97548e-01_r8/)
      kao_mn2o( 1, :, 7) = (/ &
     & 3.22705e+00_r8, 3.21966e+00_r8, 3.21230e+00_r8, 3.20494e+00_r8, 3.19761e+00_r8, &
     & 3.19029e+00_r8, 3.18299e+00_r8, 3.17571e+00_r8, 3.16844e+00_r8, 3.16119e+00_r8, &
     & 3.15395e+00_r8, 3.14673e+00_r8, 3.13953e+00_r8, 3.13235e+00_r8, 3.12518e+00_r8, &
     & 3.11803e+00_r8, 3.11089e+00_r8, 3.10377e+00_r8, 3.09667e+00_r8/)
      kao_mn2o( 2, :, 7) = (/ &
     & 1.43811e+00_r8, 1.42367e+00_r8, 1.40938e+00_r8, 1.39522e+00_r8, 1.38121e+00_r8, &
     & 1.36735e+00_r8, 1.35362e+00_r8, 1.34002e+00_r8, 1.32657e+00_r8, 1.31325e+00_r8, &
     & 1.30006e+00_r8, 1.28701e+00_r8, 1.27408e+00_r8, 1.26129e+00_r8, 1.24862e+00_r8, &
     & 1.23609e+00_r8, 1.22367e+00_r8, 1.21139e+00_r8, 1.19922e+00_r8/)
      kao_mn2o( 3, :, 7) = (/ &
     & 1.22586e+00_r8, 1.21639e+00_r8, 1.20700e+00_r8, 1.19767e+00_r8, 1.18842e+00_r8, &
     & 1.17924e+00_r8, 1.17014e+00_r8, 1.16110e+00_r8, 1.15213e+00_r8, 1.14323e+00_r8, &
     & 1.13440e+00_r8, 1.12564e+00_r8, 1.11695e+00_r8, 1.10832e+00_r8, 1.09976e+00_r8, &
     & 1.09127e+00_r8, 1.08284e+00_r8, 1.07447e+00_r8, 1.06618e+00_r8/)
      kao_mn2o( 4, :, 7) = (/ &
     & 7.94380e-01_r8, 7.92795e-01_r8, 7.91213e-01_r8, 7.89634e-01_r8, 7.88059e-01_r8, &
     & 7.86486e-01_r8, 7.84917e-01_r8, 7.83351e-01_r8, 7.81787e-01_r8, 7.80227e-01_r8, &
     & 7.78671e-01_r8, 7.77117e-01_r8, 7.75566e-01_r8, 7.74019e-01_r8, 7.72474e-01_r8, &
     & 7.70933e-01_r8, 7.69394e-01_r8, 7.67859e-01_r8, 7.66327e-01_r8/)
      kao_mn2o( 5, :, 7) = (/ &
     & 4.46935e-01_r8, 4.49760e-01_r8, 4.52602e-01_r8, 4.55462e-01_r8, 4.58340e-01_r8, &
     & 4.61237e-01_r8, 4.64152e-01_r8, 4.67085e-01_r8, 4.70037e-01_r8, 4.73007e-01_r8, &
     & 4.75996e-01_r8, 4.79004e-01_r8, 4.82031e-01_r8, 4.85078e-01_r8, 4.88143e-01_r8, &
     & 4.91228e-01_r8, 4.94332e-01_r8, 4.97456e-01_r8, 5.00600e-01_r8/)
      kao_mn2o( 6, :, 7) = (/ &
     & 4.20211e-01_r8, 4.21711e-01_r8, 4.23216e-01_r8, 4.24726e-01_r8, 4.26242e-01_r8, &
     & 4.27763e-01_r8, 4.29290e-01_r8, 4.30822e-01_r8, 4.32359e-01_r8, 4.33902e-01_r8, &
     & 4.35450e-01_r8, 4.37004e-01_r8, 4.38564e-01_r8, 4.40129e-01_r8, 4.41700e-01_r8, &
     & 4.43276e-01_r8, 4.44858e-01_r8, 4.46445e-01_r8, 4.48038e-01_r8/)
      kao_mn2o( 7, :, 7) = (/ &
     & 3.42094e-01_r8, 3.43589e-01_r8, 3.45091e-01_r8, 3.46600e-01_r8, 3.48115e-01_r8, &
     & 3.49637e-01_r8, 3.51165e-01_r8, 3.52700e-01_r8, 3.54242e-01_r8, 3.55791e-01_r8, &
     & 3.57346e-01_r8, 3.58908e-01_r8, 3.60477e-01_r8, 3.62053e-01_r8, 3.63636e-01_r8, &
     & 3.65225e-01_r8, 3.66822e-01_r8, 3.68426e-01_r8, 3.70036e-01_r8/)
      kao_mn2o( 8, :, 7) = (/ &
     & 2.94919e-01_r8, 2.97460e-01_r8, 3.00022e-01_r8, 3.02606e-01_r8, 3.05212e-01_r8, &
     & 3.07841e-01_r8, 3.10492e-01_r8, 3.13167e-01_r8, 3.15864e-01_r8, 3.18584e-01_r8, &
     & 3.21328e-01_r8, 3.24096e-01_r8, 3.26887e-01_r8, 3.29703e-01_r8, 3.32543e-01_r8, &
     & 3.35407e-01_r8, 3.38296e-01_r8, 3.41210e-01_r8, 3.44148e-01_r8/)
      kao_mn2o( 9, :, 7) = (/ &
     & 2.97441e-01_r8, 2.99207e-01_r8, 3.00984e-01_r8, 3.02772e-01_r8, 3.04570e-01_r8, &
     & 3.06379e-01_r8, 3.08199e-01_r8, 3.10029e-01_r8, 3.11870e-01_r8, 3.13723e-01_r8, &
     & 3.15586e-01_r8, 3.17460e-01_r8, 3.19345e-01_r8, 3.21242e-01_r8, 3.23150e-01_r8, &
     & 3.25069e-01_r8, 3.27000e-01_r8, 3.28942e-01_r8, 3.30895e-01_r8/)
      kao_mn2o( 1, :, 8) = (/ &
     & 2.14641e+00_r8, 2.12585e+00_r8, 2.10549e+00_r8, 2.08532e+00_r8, 2.06534e+00_r8, &
     & 2.04556e+00_r8, 2.02596e+00_r8, 2.00656e+00_r8, 1.98733e+00_r8, 1.96830e+00_r8, &
     & 1.94944e+00_r8, 1.93077e+00_r8, 1.91227e+00_r8, 1.89395e+00_r8, 1.87581e+00_r8, &
     & 1.85784e+00_r8, 1.84004e+00_r8, 1.82242e+00_r8, 1.80496e+00_r8/)
      kao_mn2o( 2, :, 8) = (/ &
     & 8.83687e-01_r8, 8.83170e-01_r8, 8.82654e-01_r8, 8.82137e-01_r8, 8.81621e-01_r8, &
     & 8.81106e-01_r8, 8.80590e-01_r8, 8.80075e-01_r8, 8.79560e-01_r8, 8.79046e-01_r8, &
     & 8.78531e-01_r8, 8.78017e-01_r8, 8.77504e-01_r8, 8.76990e-01_r8, 8.76477e-01_r8, &
     & 8.75965e-01_r8, 8.75452e-01_r8, 8.74940e-01_r8, 8.74428e-01_r8/)
      kao_mn2o( 3, :, 8) = (/ &
     & 4.49840e-01_r8, 4.52683e-01_r8, 4.55543e-01_r8, 4.58421e-01_r8, 4.61318e-01_r8, &
     & 4.64233e-01_r8, 4.67166e-01_r8, 4.70118e-01_r8, 4.73088e-01_r8, 4.76078e-01_r8, &
     & 4.79086e-01_r8, 4.82113e-01_r8, 4.85159e-01_r8, 4.88225e-01_r8, 4.91310e-01_r8, &
     & 4.94414e-01_r8, 4.97538e-01_r8, 5.00682e-01_r8, 5.03845e-01_r8/)
      kao_mn2o( 4, :, 8) = (/ &
     & 3.92292e-01_r8, 3.93574e-01_r8, 3.94861e-01_r8, 3.96151e-01_r8, 3.97446e-01_r8, &
     & 3.98746e-01_r8, 4.00049e-01_r8, 4.01357e-01_r8, 4.02669e-01_r8, 4.03985e-01_r8, &
     & 4.05306e-01_r8, 4.06630e-01_r8, 4.07960e-01_r8, 4.09293e-01_r8, 4.10631e-01_r8, &
     & 4.11973e-01_r8, 4.13320e-01_r8, 4.14671e-01_r8, 4.16027e-01_r8/)
      kao_mn2o( 5, :, 8) = (/ &
     & 3.38920e-01_r8, 3.41151e-01_r8, 3.43397e-01_r8, 3.45658e-01_r8, 3.47934e-01_r8, &
     & 3.50225e-01_r8, 3.52531e-01_r8, 3.54852e-01_r8, 3.57189e-01_r8, 3.59541e-01_r8, &
     & 3.61908e-01_r8, 3.64291e-01_r8, 3.66689e-01_r8, 3.69104e-01_r8, 3.71534e-01_r8, &
     & 3.73980e-01_r8, 3.76443e-01_r8, 3.78921e-01_r8, 3.81416e-01_r8/)
      kao_mn2o( 6, :, 8) = (/ &
     & 3.01673e-01_r8, 3.04752e-01_r8, 3.07863e-01_r8, 3.11005e-01_r8, 3.14180e-01_r8, &
     & 3.17387e-01_r8, 3.20626e-01_r8, 3.23899e-01_r8, 3.27205e-01_r8, 3.30545e-01_r8, &
     & 3.33919e-01_r8, 3.37328e-01_r8, 3.40771e-01_r8, 3.44249e-01_r8, 3.47763e-01_r8, &
     & 3.51313e-01_r8, 3.54899e-01_r8, 3.58521e-01_r8, 3.62181e-01_r8/)
      kao_mn2o( 7, :, 8) = (/ &
     & 2.99381e-01_r8, 3.02431e-01_r8, 3.05512e-01_r8, 3.08624e-01_r8, 3.11768e-01_r8, &
     & 3.14945e-01_r8, 3.18153e-01_r8, 3.21394e-01_r8, 3.24668e-01_r8, 3.27976e-01_r8, &
     & 3.31317e-01_r8, 3.34693e-01_r8, 3.38102e-01_r8, 3.41547e-01_r8, 3.45026e-01_r8, &
     & 3.48541e-01_r8, 3.52092e-01_r8, 3.55679e-01_r8, 3.59302e-01_r8/)
      kao_mn2o( 8, :, 8) = (/ &
     & 2.87559e-01_r8, 2.89153e-01_r8, 2.90756e-01_r8, 2.92367e-01_r8, 2.93987e-01_r8, &
     & 2.95617e-01_r8, 2.97255e-01_r8, 2.98902e-01_r8, 3.00559e-01_r8, 3.02225e-01_r8, &
     & 3.03899e-01_r8, 3.05584e-01_r8, 3.07277e-01_r8, 3.08980e-01_r8, 3.10693e-01_r8, &
     & 3.12414e-01_r8, 3.14146e-01_r8, 3.15887e-01_r8, 3.17638e-01_r8/)
      kao_mn2o( 9, :, 8) = (/ &
     & 2.96238e-01_r8, 2.97588e-01_r8, 2.98945e-01_r8, 3.00309e-01_r8, 3.01678e-01_r8, &
     & 3.03054e-01_r8, 3.04436e-01_r8, 3.05824e-01_r8, 3.07219e-01_r8, 3.08620e-01_r8, &
     & 3.10027e-01_r8, 3.11441e-01_r8, 3.12861e-01_r8, 3.14288e-01_r8, 3.15721e-01_r8, &
     & 3.17161e-01_r8, 3.18607e-01_r8, 3.20060e-01_r8, 3.21520e-01_r8/)
      kao_mn2o( 1, :, 9) = (/ &
     & 1.56483e+00_r8, 1.55792e+00_r8, 1.55105e+00_r8, 1.54420e+00_r8, 1.53739e+00_r8, &
     & 1.53060e+00_r8, 1.52384e+00_r8, 1.51712e+00_r8, 1.51042e+00_r8, 1.50376e+00_r8, &
     & 1.49712e+00_r8, 1.49051e+00_r8, 1.48393e+00_r8, 1.47738e+00_r8, 1.47086e+00_r8, &
     & 1.46437e+00_r8, 1.45791e+00_r8, 1.45147e+00_r8, 1.44507e+00_r8/)
      kao_mn2o( 2, :, 9) = (/ &
     & 4.09526e-01_r8, 4.10301e-01_r8, 4.11078e-01_r8, 4.11857e-01_r8, 4.12637e-01_r8, &
     & 4.13418e-01_r8, 4.14201e-01_r8, 4.14986e-01_r8, 4.15771e-01_r8, 4.16559e-01_r8, &
     & 4.17348e-01_r8, 4.18138e-01_r8, 4.18930e-01_r8, 4.19723e-01_r8, 4.20518e-01_r8, &
     & 4.21315e-01_r8, 4.22112e-01_r8, 4.22912e-01_r8, 4.23713e-01_r8/)
      kao_mn2o( 3, :, 9) = (/ &
     & 3.35672e-01_r8, 3.38982e-01_r8, 3.42326e-01_r8, 3.45702e-01_r8, 3.49111e-01_r8, &
     & 3.52554e-01_r8, 3.56031e-01_r8, 3.59543e-01_r8, 3.63089e-01_r8, 3.66670e-01_r8, &
     & 3.70286e-01_r8, 3.73938e-01_r8, 3.77626e-01_r8, 3.81350e-01_r8, 3.85111e-01_r8, &
     & 3.88909e-01_r8, 3.92745e-01_r8, 3.96618e-01_r8, 4.00530e-01_r8/)
      kao_mn2o( 4, :, 9) = (/ &
     & 3.19130e-01_r8, 3.23028e-01_r8, 3.26973e-01_r8, 3.30966e-01_r8, 3.35008e-01_r8, &
     & 3.39100e-01_r8, 3.43241e-01_r8, 3.47433e-01_r8, 3.51676e-01_r8, 3.55971e-01_r8, &
     & 3.60319e-01_r8, 3.64719e-01_r8, 3.69173e-01_r8, 3.73682e-01_r8, 3.78246e-01_r8, &
     & 3.82865e-01_r8, 3.87541e-01_r8, 3.92274e-01_r8, 3.97065e-01_r8/)
      kao_mn2o( 5, :, 9) = (/ &
     & 3.04385e-01_r8, 3.07155e-01_r8, 3.09949e-01_r8, 3.12770e-01_r8, 3.15616e-01_r8, &
     & 3.18488e-01_r8, 3.21386e-01_r8, 3.24310e-01_r8, 3.27261e-01_r8, 3.30239e-01_r8, &
     & 3.33244e-01_r8, 3.36276e-01_r8, 3.39336e-01_r8, 3.42424e-01_r8, 3.45540e-01_r8, &
     & 3.48684e-01_r8, 3.51857e-01_r8, 3.55059e-01_r8, 3.58289e-01_r8/)
      kao_mn2o( 6, :, 9) = (/ &
     & 2.98789e-01_r8, 3.00996e-01_r8, 3.03220e-01_r8, 3.05460e-01_r8, 3.07717e-01_r8, &
     & 3.09990e-01_r8, 3.12281e-01_r8, 3.14588e-01_r8, 3.16912e-01_r8, 3.19253e-01_r8, &
     & 3.21612e-01_r8, 3.23988e-01_r8, 3.26382e-01_r8, 3.28793e-01_r8, 3.31222e-01_r8, &
     & 3.33669e-01_r8, 3.36134e-01_r8, 3.38618e-01_r8, 3.41119e-01_r8/)
      kao_mn2o( 7, :, 9) = (/ &
     & 3.08712e-01_r8, 3.10491e-01_r8, 3.12281e-01_r8, 3.14080e-01_r8, 3.15890e-01_r8, &
     & 3.17710e-01_r8, 3.19541e-01_r8, 3.21382e-01_r8, 3.23234e-01_r8, 3.25097e-01_r8, &
     & 3.26970e-01_r8, 3.28854e-01_r8, 3.30749e-01_r8, 3.32655e-01_r8, 3.34572e-01_r8, &
     & 3.36500e-01_r8, 3.38439e-01_r8, 3.40390e-01_r8, 3.42351e-01_r8/)
      kao_mn2o( 8, :, 9) = (/ &
     & 3.10571e-01_r8, 3.12262e-01_r8, 3.13961e-01_r8, 3.15670e-01_r8, 3.17388e-01_r8, &
     & 3.19115e-01_r8, 3.20852e-01_r8, 3.22598e-01_r8, 3.24354e-01_r8, 3.26120e-01_r8, &
     & 3.27895e-01_r8, 3.29679e-01_r8, 3.31474e-01_r8, 3.33278e-01_r8, 3.35092e-01_r8, &
     & 3.36915e-01_r8, 3.38749e-01_r8, 3.40593e-01_r8, 3.42447e-01_r8/)
      kao_mn2o( 9, :, 9) = (/ &
     & 3.16436e-01_r8, 3.18200e-01_r8, 3.19974e-01_r8, 3.21759e-01_r8, 3.23553e-01_r8, &
     & 3.25357e-01_r8, 3.27172e-01_r8, 3.28996e-01_r8, 3.30831e-01_r8, 3.32675e-01_r8, &
     & 3.34530e-01_r8, 3.36396e-01_r8, 3.38272e-01_r8, 3.40158e-01_r8, 3.42055e-01_r8, &
     & 3.43962e-01_r8, 3.45880e-01_r8, 3.47809e-01_r8, 3.49749e-01_r8/)
      kao_mn2o( 1, :,10) = (/ &
     & 7.68616e-01_r8, 7.63263e-01_r8, 7.57948e-01_r8, 7.52669e-01_r8, 7.47428e-01_r8, &
     & 7.42223e-01_r8, 7.37054e-01_r8, 7.31921e-01_r8, 7.26824e-01_r8, 7.21762e-01_r8, &
     & 7.16736e-01_r8, 7.11744e-01_r8, 7.06788e-01_r8, 7.01866e-01_r8, 6.96978e-01_r8, &
     & 6.92124e-01_r8, 6.87304e-01_r8, 6.82517e-01_r8, 6.77764e-01_r8/)
      kao_mn2o( 2, :,10) = (/ &
     & 4.97271e-01_r8, 5.10054e-01_r8, 5.23165e-01_r8, 5.36614e-01_r8, 5.50408e-01_r8, &
     & 5.64556e-01_r8, 5.79069e-01_r8, 5.93954e-01_r8, 6.09222e-01_r8, 6.24883e-01_r8, &
     & 6.40946e-01_r8, 6.57422e-01_r8, 6.74321e-01_r8, 6.91655e-01_r8, 7.09435e-01_r8, &
     & 7.27671e-01_r8, 7.46377e-01_r8, 7.65563e-01_r8, 7.85242e-01_r8/)
      kao_mn2o( 3, :,10) = (/ &
     & 2.44443e-01_r8, 2.47096e-01_r8, 2.49778e-01_r8, 2.52489e-01_r8, 2.55229e-01_r8, &
     & 2.57999e-01_r8, 2.60799e-01_r8, 2.63630e-01_r8, 2.66491e-01_r8, 2.69383e-01_r8, &
     & 2.72307e-01_r8, 2.75262e-01_r8, 2.78250e-01_r8, 2.81269e-01_r8, 2.84322e-01_r8, &
     & 2.87408e-01_r8, 2.90527e-01_r8, 2.93680e-01_r8, 2.96868e-01_r8/)
      kao_mn2o( 4, :,10) = (/ &
     & 2.01964e-01_r8, 2.02869e-01_r8, 2.03777e-01_r8, 2.04690e-01_r8, 2.05606e-01_r8, &
     & 2.06527e-01_r8, 2.07452e-01_r8, 2.08381e-01_r8, 2.09314e-01_r8, 2.10251e-01_r8, &
     & 2.11193e-01_r8, 2.12139e-01_r8, 2.13089e-01_r8, 2.14043e-01_r8, 2.15002e-01_r8, &
     & 2.15964e-01_r8, 2.16932e-01_r8, 2.17903e-01_r8, 2.18879e-01_r8/)
      kao_mn2o( 5, :,10) = (/ &
     & 2.56972e-01_r8, 2.56837e-01_r8, 2.56702e-01_r8, 2.56567e-01_r8, 2.56432e-01_r8, &
     & 2.56297e-01_r8, 2.56162e-01_r8, 2.56027e-01_r8, 2.55893e-01_r8, 2.55758e-01_r8, &
     & 2.55624e-01_r8, 2.55489e-01_r8, 2.55355e-01_r8, 2.55220e-01_r8, 2.55086e-01_r8, &
     & 2.54952e-01_r8, 2.54818e-01_r8, 2.54684e-01_r8, 2.54550e-01_r8/)
      kao_mn2o( 6, :,10) = (/ &
     & 2.57322e-01_r8, 2.57187e-01_r8, 2.57052e-01_r8, 2.56917e-01_r8, 2.56782e-01_r8, &
     & 2.56647e-01_r8, 2.56512e-01_r8, 2.56377e-01_r8, 2.56243e-01_r8, 2.56108e-01_r8, &
     & 2.55974e-01_r8, 2.55839e-01_r8, 2.55705e-01_r8, 2.55570e-01_r8, 2.55436e-01_r8, &
     & 2.55302e-01_r8, 2.55168e-01_r8, 2.55034e-01_r8, 2.54900e-01_r8/)
      kao_mn2o( 7, :,10) = (/ &
     & 2.56551e-01_r8, 2.56421e-01_r8, 2.56291e-01_r8, 2.56161e-01_r8, 2.56030e-01_r8, &
     & 2.55900e-01_r8, 2.55770e-01_r8, 2.55640e-01_r8, 2.55511e-01_r8, 2.55381e-01_r8, &
     & 2.55251e-01_r8, 2.55121e-01_r8, 2.54992e-01_r8, 2.54862e-01_r8, 2.54733e-01_r8, &
     & 2.54603e-01_r8, 2.54474e-01_r8, 2.54345e-01_r8, 2.54215e-01_r8/)
      kao_mn2o( 8, :,10) = (/ &
     & 2.73629e-01_r8, 2.73460e-01_r8, 2.73291e-01_r8, 2.73122e-01_r8, 2.72953e-01_r8, &
     & 2.72784e-01_r8, 2.72615e-01_r8, 2.72447e-01_r8, 2.72279e-01_r8, 2.72110e-01_r8, &
     & 2.71942e-01_r8, 2.71774e-01_r8, 2.71606e-01_r8, 2.71438e-01_r8, 2.71270e-01_r8, &
     & 2.71102e-01_r8, 2.70935e-01_r8, 2.70767e-01_r8, 2.70600e-01_r8/)
      kao_mn2o( 9, :,10) = (/ &
     & 2.57294e-01_r8, 2.57149e-01_r8, 2.57004e-01_r8, 2.56860e-01_r8, 2.56715e-01_r8, &
     & 2.56570e-01_r8, 2.56426e-01_r8, 2.56282e-01_r8, 2.56137e-01_r8, 2.55993e-01_r8, &
     & 2.55849e-01_r8, 2.55705e-01_r8, 2.55561e-01_r8, 2.55417e-01_r8, 2.55273e-01_r8, &
     & 2.55129e-01_r8, 2.54986e-01_r8, 2.54842e-01_r8, 2.54698e-01_r8/)
      kao_mn2o( 1, :,11) = (/ &
     & 6.91062e-01_r8, 6.84151e-01_r8, 6.77309e-01_r8, 6.70535e-01_r8, 6.63829e-01_r8, &
     & 6.57190e-01_r8, 6.50617e-01_r8, 6.44111e-01_r8, 6.37669e-01_r8, 6.31292e-01_r8, &
     & 6.24978e-01_r8, 6.18728e-01_r8, 6.12540e-01_r8, 6.06414e-01_r8, 6.00349e-01_r8, &
     & 5.94345e-01_r8, 5.88401e-01_r8, 5.82517e-01_r8, 5.76691e-01_r8/)
      kao_mn2o( 2, :,11) = (/ &
     & 1.98698e-01_r8, 2.01182e-01_r8, 2.03698e-01_r8, 2.06244e-01_r8, 2.08823e-01_r8, &
     & 2.11433e-01_r8, 2.14077e-01_r8, 2.16753e-01_r8, 2.19463e-01_r8, 2.22207e-01_r8, &
     & 2.24985e-01_r8, 2.27798e-01_r8, 2.30646e-01_r8, 2.33529e-01_r8, 2.36449e-01_r8, &
     & 2.39405e-01_r8, 2.42398e-01_r8, 2.45429e-01_r8, 2.48497e-01_r8/)
      kao_mn2o( 3, :,11) = (/ &
     & 2.11950e-01_r8, 2.13560e-01_r8, 2.15184e-01_r8, 2.16819e-01_r8, 2.18467e-01_r8, &
     & 2.20127e-01_r8, 2.21800e-01_r8, 2.23486e-01_r8, 2.25185e-01_r8, 2.26896e-01_r8, &
     & 2.28621e-01_r8, 2.30358e-01_r8, 2.32109e-01_r8, 2.33873e-01_r8, 2.35651e-01_r8, &
     & 2.37442e-01_r8, 2.39247e-01_r8, 2.41065e-01_r8, 2.42897e-01_r8/)
      kao_mn2o( 4, :,11) = (/ &
     & 3.14210e-01_r8, 3.13143e-01_r8, 3.12080e-01_r8, 3.11021e-01_r8, 3.09965e-01_r8, &
     & 3.08913e-01_r8, 3.07864e-01_r8, 3.06819e-01_r8, 3.05777e-01_r8, 3.04739e-01_r8, &
     & 3.03705e-01_r8, 3.02674e-01_r8, 3.01646e-01_r8, 3.00622e-01_r8, 2.99602e-01_r8, &
     & 2.98584e-01_r8, 2.97571e-01_r8, 2.96561e-01_r8, 2.95554e-01_r8/)
      kao_mn2o( 5, :,11) = (/ &
     & 3.13536e-01_r8, 3.12459e-01_r8, 3.11386e-01_r8, 3.10316e-01_r8, 3.09250e-01_r8, &
     & 3.08188e-01_r8, 3.07129e-01_r8, 3.06074e-01_r8, 3.05022e-01_r8, 3.03974e-01_r8, &
     & 3.02930e-01_r8, 3.01889e-01_r8, 3.00852e-01_r8, 2.99819e-01_r8, 2.98789e-01_r8, &
     & 2.97762e-01_r8, 2.96739e-01_r8, 2.95720e-01_r8, 2.94704e-01_r8/)
      kao_mn2o( 6, :,11) = (/ &
     & 3.13215e-01_r8, 3.12123e-01_r8, 3.11034e-01_r8, 3.09949e-01_r8, 3.08867e-01_r8, &
     & 3.07790e-01_r8, 3.06716e-01_r8, 3.05646e-01_r8, 3.04579e-01_r8, 3.03517e-01_r8, &
     & 3.02458e-01_r8, 3.01403e-01_r8, 3.00351e-01_r8, 2.99303e-01_r8, 2.98259e-01_r8, &
     & 2.97219e-01_r8, 2.96182e-01_r8, 2.95148e-01_r8, 2.94119e-01_r8/)
      kao_mn2o( 7, :,11) = (/ &
     & 3.14236e-01_r8, 3.13123e-01_r8, 3.12014e-01_r8, 3.10908e-01_r8, 3.09806e-01_r8, &
     & 3.08709e-01_r8, 3.07615e-01_r8, 3.06525e-01_r8, 3.05439e-01_r8, 3.04357e-01_r8, &
     & 3.03278e-01_r8, 3.02204e-01_r8, 3.01133e-01_r8, 3.00066e-01_r8, 2.99003e-01_r8, &
     & 2.97944e-01_r8, 2.96888e-01_r8, 2.95836e-01_r8, 2.94788e-01_r8/)
      kao_mn2o( 8, :,11) = (/ &
     & 2.97453e-01_r8, 2.96420e-01_r8, 2.95391e-01_r8, 2.94366e-01_r8, 2.93344e-01_r8, &
     & 2.92325e-01_r8, 2.91311e-01_r8, 2.90299e-01_r8, 2.89291e-01_r8, 2.88287e-01_r8, &
     & 2.87286e-01_r8, 2.86289e-01_r8, 2.85295e-01_r8, 2.84304e-01_r8, 2.83317e-01_r8, &
     & 2.82334e-01_r8, 2.81354e-01_r8, 2.80377e-01_r8, 2.79404e-01_r8/)
      kao_mn2o( 9, :,11) = (/ &
     & 3.12694e-01_r8, 3.11622e-01_r8, 3.10554e-01_r8, 3.09489e-01_r8, 3.08428e-01_r8, &
     & 3.07370e-01_r8, 3.06316e-01_r8, 3.05266e-01_r8, 3.04220e-01_r8, 3.03177e-01_r8, &
     & 3.02137e-01_r8, 3.01101e-01_r8, 3.00069e-01_r8, 2.99040e-01_r8, 2.98015e-01_r8, &
     & 2.96993e-01_r8, 2.95975e-01_r8, 2.94960e-01_r8, 2.93949e-01_r8/)
      kao_mn2o( 1, :,12) = (/ &
     & 5.30796e-01_r8, 5.50444e-01_r8, 5.70818e-01_r8, 5.91947e-01_r8, 6.13857e-01_r8, &
     & 6.36579e-01_r8, 6.60142e-01_r8, 6.84577e-01_r8, 7.09916e-01_r8, 7.36194e-01_r8, &
     & 7.63444e-01_r8, 7.91702e-01_r8, 8.21007e-01_r8, 8.51396e-01_r8, 8.82910e-01_r8, &
     & 9.15591e-01_r8, 9.49481e-01_r8, 9.84626e-01_r8, 1.02107e+00_r8/)
      kao_mn2o( 2, :,12) = (/ &
     & 1.38469e-01_r8, 1.40959e-01_r8, 1.43493e-01_r8, 1.46073e-01_r8, 1.48699e-01_r8, &
     & 1.51373e-01_r8, 1.54094e-01_r8, 1.56865e-01_r8, 1.59685e-01_r8, 1.62556e-01_r8, &
     & 1.65478e-01_r8, 1.68454e-01_r8, 1.71482e-01_r8, 1.74565e-01_r8, 1.77704e-01_r8, &
     & 1.80899e-01_r8, 1.84151e-01_r8, 1.87462e-01_r8, 1.90833e-01_r8/)
      kao_mn2o( 3, :,12) = (/ &
     & 1.50741e-01_r8, 1.50855e-01_r8, 1.50969e-01_r8, 1.51084e-01_r8, 1.51198e-01_r8, &
     & 1.51313e-01_r8, 1.51427e-01_r8, 1.51542e-01_r8, 1.51657e-01_r8, 1.51772e-01_r8, &
     & 1.51887e-01_r8, 1.52002e-01_r8, 1.52117e-01_r8, 1.52233e-01_r8, 1.52348e-01_r8, &
     & 1.52463e-01_r8, 1.52579e-01_r8, 1.52695e-01_r8, 1.52810e-01_r8/)
      kao_mn2o( 4, :,12) = (/ &
     & 1.80444e-01_r8, 1.79944e-01_r8, 1.79445e-01_r8, 1.78948e-01_r8, 1.78452e-01_r8, &
     & 1.77958e-01_r8, 1.77465e-01_r8, 1.76973e-01_r8, 1.76483e-01_r8, 1.75994e-01_r8, &
     & 1.75506e-01_r8, 1.75020e-01_r8, 1.74535e-01_r8, 1.74051e-01_r8, 1.73569e-01_r8, &
     & 1.73088e-01_r8, 1.72609e-01_r8, 1.72131e-01_r8, 1.71654e-01_r8/)
      kao_mn2o( 5, :,12) = (/ &
     & 1.80595e-01_r8, 1.80033e-01_r8, 1.79474e-01_r8, 1.78916e-01_r8, 1.78359e-01_r8, &
     & 1.77805e-01_r8, 1.77252e-01_r8, 1.76701e-01_r8, 1.76152e-01_r8, 1.75604e-01_r8, &
     & 1.75058e-01_r8, 1.74514e-01_r8, 1.73971e-01_r8, 1.73430e-01_r8, 1.72891e-01_r8, &
     & 1.72354e-01_r8, 1.71818e-01_r8, 1.71284e-01_r8, 1.70751e-01_r8/)
      kao_mn2o( 6, :,12) = (/ &
     & 1.79904e-01_r8, 1.79254e-01_r8, 1.78607e-01_r8, 1.77962e-01_r8, 1.77320e-01_r8, &
     & 1.76680e-01_r8, 1.76042e-01_r8, 1.75406e-01_r8, 1.74773e-01_r8, 1.74142e-01_r8, &
     & 1.73513e-01_r8, 1.72887e-01_r8, 1.72262e-01_r8, 1.71640e-01_r8, 1.71021e-01_r8, &
     & 1.70403e-01_r8, 1.69788e-01_r8, 1.69175e-01_r8, 1.68564e-01_r8/)
      kao_mn2o( 7, :,12) = (/ &
     & 1.78712e-01_r8, 1.77868e-01_r8, 1.77027e-01_r8, 1.76190e-01_r8, 1.75357e-01_r8, &
     & 1.74528e-01_r8, 1.73703e-01_r8, 1.72882e-01_r8, 1.72064e-01_r8, 1.71251e-01_r8, &
     & 1.70441e-01_r8, 1.69636e-01_r8, 1.68834e-01_r8, 1.68036e-01_r8, 1.67241e-01_r8, &
     & 1.66451e-01_r8, 1.65664e-01_r8, 1.64881e-01_r8, 1.64101e-01_r8/)
      kao_mn2o( 8, :,12) = (/ &
     & 1.72346e-01_r8, 1.70873e-01_r8, 1.69413e-01_r8, 1.67965e-01_r8, 1.66530e-01_r8, &
     & 1.65107e-01_r8, 1.63696e-01_r8, 1.62297e-01_r8, 1.60910e-01_r8, 1.59535e-01_r8, &
     & 1.58171e-01_r8, 1.56819e-01_r8, 1.55479e-01_r8, 1.54150e-01_r8, 1.52833e-01_r8, &
     & 1.51527e-01_r8, 1.50232e-01_r8, 1.48948e-01_r8, 1.47675e-01_r8/)
      kao_mn2o( 9, :,12) = (/ &
     & 1.80517e-01_r8, 1.79951e-01_r8, 1.79386e-01_r8, 1.78823e-01_r8, 1.78262e-01_r8, &
     & 1.77702e-01_r8, 1.77144e-01_r8, 1.76588e-01_r8, 1.76034e-01_r8, 1.75481e-01_r8, &
     & 1.74931e-01_r8, 1.74382e-01_r8, 1.73834e-01_r8, 1.73289e-01_r8, 1.72745e-01_r8, &
     & 1.72202e-01_r8, 1.71662e-01_r8, 1.71123e-01_r8, 1.70586e-01_r8/)
      kao_mn2o( 1, :,13) = (/ &
     & 2.41966e-01_r8, 2.50534e-01_r8, 2.59406e-01_r8, 2.68591e-01_r8, 2.78102e-01_r8, &
     & 2.87950e-01_r8, 2.98146e-01_r8, 3.08704e-01_r8, 3.19635e-01_r8, 3.30953e-01_r8, &
     & 3.42672e-01_r8, 3.54806e-01_r8, 3.67370e-01_r8, 3.80379e-01_r8, 3.93848e-01_r8, &
     & 4.07794e-01_r8, 4.22234e-01_r8, 4.37186e-01_r8, 4.52667e-01_r8/)
      kao_mn2o( 2, :,13) = (/ &
     & 1.54385e-01_r8, 1.54015e-01_r8, 1.53646e-01_r8, 1.53279e-01_r8, 1.52912e-01_r8, &
     & 1.52545e-01_r8, 1.52180e-01_r8, 1.51816e-01_r8, 1.51452e-01_r8, 1.51089e-01_r8, &
     & 1.50728e-01_r8, 1.50367e-01_r8, 1.50007e-01_r8, 1.49647e-01_r8, 1.49289e-01_r8, &
     & 1.48932e-01_r8, 1.48575e-01_r8, 1.48219e-01_r8, 1.47864e-01_r8/)
      kao_mn2o( 3, :,13) = (/ &
     & 2.00518e-01_r8, 1.94901e-01_r8, 1.89442e-01_r8, 1.84136e-01_r8, 1.78978e-01_r8, &
     & 1.73965e-01_r8, 1.69092e-01_r8, 1.64356e-01_r8, 1.59752e-01_r8, 1.55278e-01_r8, &
     & 1.50928e-01_r8, 1.46701e-01_r8, 1.42592e-01_r8, 1.38598e-01_r8, 1.34715e-01_r8, &
     & 1.30942e-01_r8, 1.27274e-01_r8, 1.23709e-01_r8, 1.20244e-01_r8/)
      kao_mn2o( 4, :,13) = (/ &
     & 2.03974e-01_r8, 1.98258e-01_r8, 1.92703e-01_r8, 1.87302e-01_r8, 1.82054e-01_r8, &
     & 1.76952e-01_r8, 1.71993e-01_r8, 1.67173e-01_r8, 1.62489e-01_r8, 1.57935e-01_r8, &
     & 1.53509e-01_r8, 1.49207e-01_r8, 1.45026e-01_r8, 1.40962e-01_r8, 1.37012e-01_r8, &
     & 1.33172e-01_r8, 1.29440e-01_r8, 1.25813e-01_r8, 1.22287e-01_r8/)
      kao_mn2o( 5, :,13) = (/ &
     & 2.09410e-01_r8, 2.03543e-01_r8, 1.97841e-01_r8, 1.92298e-01_r8, 1.86911e-01_r8, &
     & 1.81674e-01_r8, 1.76585e-01_r8, 1.71637e-01_r8, 1.66829e-01_r8, 1.62155e-01_r8, &
     & 1.57612e-01_r8, 1.53196e-01_r8, 1.48904e-01_r8, 1.44733e-01_r8, 1.40678e-01_r8, &
     & 1.36736e-01_r8, 1.32906e-01_r8, 1.29182e-01_r8, 1.25563e-01_r8/)
      kao_mn2o( 6, :,13) = (/ &
     & 2.19808e-01_r8, 2.13643e-01_r8, 2.07651e-01_r8, 2.01827e-01_r8, 1.96166e-01_r8, &
     & 1.90664e-01_r8, 1.85317e-01_r8, 1.80119e-01_r8, 1.75067e-01_r8, 1.70157e-01_r8, &
     & 1.65385e-01_r8, 1.60746e-01_r8, 1.56238e-01_r8, 1.51856e-01_r8, 1.47596e-01_r8, &
     & 1.43457e-01_r8, 1.39433e-01_r8, 1.35523e-01_r8, 1.31722e-01_r8/)
      kao_mn2o( 7, :,13) = (/ &
     & 2.47074e-01_r8, 2.40127e-01_r8, 2.33375e-01_r8, 2.26813e-01_r8, 2.20436e-01_r8, &
     & 2.14238e-01_r8, 2.08215e-01_r8, 2.02360e-01_r8, 1.96671e-01_r8, 1.91141e-01_r8, &
     & 1.85767e-01_r8, 1.80544e-01_r8, 1.75467e-01_r8, 1.70534e-01_r8, 1.65739e-01_r8, &
     & 1.61079e-01_r8, 1.56550e-01_r8, 1.52148e-01_r8, 1.47870e-01_r8/)
      kao_mn2o( 8, :,13) = (/ &
     & 2.55282e-01_r8, 2.48105e-01_r8, 2.41130e-01_r8, 2.34350e-01_r8, 2.27762e-01_r8, &
     & 2.21358e-01_r8, 2.15135e-01_r8, 2.09086e-01_r8, 2.03208e-01_r8, 1.97495e-01_r8, &
     & 1.91942e-01_r8, 1.86546e-01_r8, 1.81301e-01_r8, 1.76204e-01_r8, 1.71250e-01_r8, &
     & 1.66435e-01_r8, 1.61756e-01_r8, 1.57208e-01_r8, 1.52788e-01_r8/)
      kao_mn2o( 9, :,13) = (/ &
     & 2.09991e-01_r8, 2.04103e-01_r8, 1.98380e-01_r8, 1.92818e-01_r8, 1.87411e-01_r8, &
     & 1.82156e-01_r8, 1.77048e-01_r8, 1.72084e-01_r8, 1.67259e-01_r8, 1.62569e-01_r8, &
     & 1.58010e-01_r8, 1.53580e-01_r8, 1.49273e-01_r8, 1.45087e-01_r8, 1.41019e-01_r8, &
     & 1.37065e-01_r8, 1.33222e-01_r8, 1.29486e-01_r8, 1.25855e-01_r8/)
      kao_mn2o( 1, :,14) = (/ &
     & 9.08340e-02_r8, 9.50421e-02_r8, 9.94452e-02_r8, 1.04052e-01_r8, 1.08873e-01_r8, &
     & 1.13917e-01_r8, 1.19194e-01_r8, 1.24716e-01_r8, 1.30494e-01_r8, 1.36540e-01_r8, &
     & 1.42865e-01_r8, 1.49484e-01_r8, 1.56409e-01_r8, 1.63655e-01_r8, 1.71237e-01_r8, &
     & 1.79170e-01_r8, 1.87471e-01_r8, 1.96156e-01_r8, 2.05243e-01_r8/)
      kao_mn2o( 2, :,14) = (/ &
     & 3.36945e-02_r8, 3.45144e-02_r8, 3.53542e-02_r8, 3.62144e-02_r8, 3.70956e-02_r8, &
     & 3.79982e-02_r8, 3.89228e-02_r8, 3.98698e-02_r8, 4.08399e-02_r8, 4.18336e-02_r8, &
     & 4.28515e-02_r8, 4.38942e-02_r8, 4.49622e-02_r8, 4.60562e-02_r8, 4.71769e-02_r8, &
     & 4.83248e-02_r8, 4.95006e-02_r8, 5.07051e-02_r8, 5.19388e-02_r8/)
      kao_mn2o( 3, :,14) = (/ &
     & 9.11678e-02_r8, 8.85761e-02_r8, 8.60580e-02_r8, 8.36116e-02_r8, 8.12347e-02_r8, &
     & 7.89253e-02_r8, 7.66817e-02_r8, 7.45017e-02_r8, 7.23838e-02_r8, 7.03261e-02_r8, &
     & 6.83269e-02_r8, 6.63845e-02_r8, 6.44973e-02_r8, 6.26638e-02_r8, 6.08824e-02_r8, &
     & 5.91516e-02_r8, 5.74700e-02_r8, 5.58363e-02_r8, 5.42490e-02_r8/)
      kao_mn2o( 4, :,14) = (/ &
     & 8.43999e-02_r8, 8.20004e-02_r8, 7.96692e-02_r8, 7.74042e-02_r8, 7.52037e-02_r8, &
     & 7.30656e-02_r8, 7.09884e-02_r8, 6.89702e-02_r8, 6.70094e-02_r8, 6.51044e-02_r8, &
     & 6.32535e-02_r8, 6.14552e-02_r8, 5.97081e-02_r8, 5.80106e-02_r8, 5.63614e-02_r8, &
     & 5.47590e-02_r8, 5.32022e-02_r8, 5.16897e-02_r8, 5.02202e-02_r8/)
      kao_mn2o( 5, :,14) = (/ &
     & 7.41279e-02_r8, 7.20196e-02_r8, 6.99712e-02_r8, 6.79811e-02_r8, 6.60476e-02_r8, &
     & 6.41691e-02_r8, 6.23440e-02_r8, 6.05708e-02_r8, 5.88481e-02_r8, 5.71743e-02_r8, &
     & 5.55482e-02_r8, 5.39683e-02_r8, 5.24334e-02_r8, 5.09421e-02_r8, 4.94932e-02_r8, &
     & 4.80855e-02_r8, 4.67179e-02_r8, 4.53891e-02_r8, 4.40982e-02_r8/)
      kao_mn2o( 6, :,14) = (/ &
     & 5.66805e-02_r8, 5.50676e-02_r8, 5.35006e-02_r8, 5.19782e-02_r8, 5.04991e-02_r8, &
     & 4.90621e-02_r8, 4.76659e-02_r8, 4.63096e-02_r8, 4.49918e-02_r8, 4.37115e-02_r8, &
     & 4.24676e-02_r8, 4.12592e-02_r8, 4.00851e-02_r8, 3.89444e-02_r8, 3.78362e-02_r8, &
     & 3.67595e-02_r8, 3.57135e-02_r8, 3.46972e-02_r8, 3.37099e-02_r8/)
      kao_mn2o( 7, :,14) = (/ &
     & 1.23018e-02_r8, 1.19517e-02_r8, 1.16116e-02_r8, 1.12811e-02_r8, 1.09601e-02_r8, &
     & 1.06482e-02_r8, 1.03452e-02_r8, 1.00508e-02_r8, 9.76474e-03_r8, 9.48685e-03_r8, &
     & 9.21687e-03_r8, 8.95458e-03_r8, 8.69974e-03_r8, 8.45216e-03_r8, 8.21163e-03_r8, &
     & 7.97794e-03_r8, 7.75091e-03_r8, 7.53033e-03_r8, 7.31603e-03_r8/)
      kao_mn2o( 8, :,14) = (/ &
     & 3.22403e-07_r8, 3.75986e-07_r8, 4.38475e-07_r8, 5.11349e-07_r8, 5.96335e-07_r8, &
     & 6.95446e-07_r8, 8.11028e-07_r8, 9.45821e-07_r8, 1.10302e-06_r8, 1.28634e-06_r8, &
     & 1.50012e-06_r8, 1.74944e-06_r8, 2.04020e-06_r8, 2.37928e-06_r8, 2.77472e-06_r8, &
     & 3.23587e-06_r8, 3.77367e-06_r8, 4.40085e-06_r8, 5.13227e-06_r8/)
      kao_mn2o( 9, :,14) = (/ &
     & 7.33052e-02_r8, 7.12199e-02_r8, 6.91939e-02_r8, 6.72255e-02_r8, 6.53131e-02_r8, &
     & 6.34551e-02_r8, 6.16500e-02_r8, 5.98963e-02_r8, 5.81924e-02_r8, 5.65370e-02_r8, &
     & 5.49287e-02_r8, 5.33661e-02_r8, 5.18480e-02_r8, 5.03730e-02_r8, 4.89401e-02_r8, &
     & 4.75479e-02_r8, 4.61953e-02_r8, 4.48811e-02_r8, 4.36044e-02_r8/)
      kao_mn2o( 1, :,15) = (/ &
     & 8.80247e-02_r8, 9.01793e-02_r8, 9.23868e-02_r8, 9.46482e-02_r8, 9.69650e-02_r8, &
     & 9.93385e-02_r8, 1.01770e-01_r8, 1.04261e-01_r8, 1.06813e-01_r8, 1.09428e-01_r8, &
     & 1.12107e-01_r8, 1.14851e-01_r8, 1.17662e-01_r8, 1.20542e-01_r8, 1.23493e-01_r8, &
     & 1.26516e-01_r8, 1.29613e-01_r8, 1.32785e-01_r8, 1.36036e-01_r8/)
      kao_mn2o( 2, :,15) = (/ &
     & 3.89107e-07_r8, 4.53768e-07_r8, 5.29173e-07_r8, 6.17109e-07_r8, 7.19658e-07_r8, &
     & 8.39248e-07_r8, 9.78710e-07_r8, 1.14135e-06_r8, 1.33101e-06_r8, 1.55220e-06_r8, &
     & 1.81013e-06_r8, 2.11094e-06_r8, 2.46172e-06_r8, 2.87080e-06_r8, 3.34786e-06_r8, &
     & 3.90420e-06_r8, 4.55298e-06_r8, 5.30958e-06_r8, 6.19190e-06_r8/)
      kao_mn2o( 3, :,15) = (/ &
     & 3.86537e-07_r8, 4.50763e-07_r8, 5.25662e-07_r8, 6.13006e-07_r8, 7.14863e-07_r8, &
     & 8.33644e-07_r8, 9.72162e-07_r8, 1.13370e-06_r8, 1.32207e-06_r8, 1.54175e-06_r8, &
     & 1.79792e-06_r8, 2.09666e-06_r8, 2.44504e-06_r8, 2.85131e-06_r8, 3.32508e-06_r8, &
     & 3.87758e-06_r8, 4.52188e-06_r8, 5.27323e-06_r8, 6.14943e-06_r8/)
      kao_mn2o( 4, :,15) = (/ &
     & 3.81913e-07_r8, 4.45369e-07_r8, 5.19369e-07_r8, 6.05664e-07_r8, 7.06297e-07_r8, &
     & 8.23651e-07_r8, 9.60503e-07_r8, 1.12009e-06_r8, 1.30620e-06_r8, 1.52323e-06_r8, &
     & 1.77632e-06_r8, 2.07147e-06_r8, 2.41565e-06_r8, 2.81701e-06_r8, 3.28507e-06_r8, &
     & 3.83090e-06_r8, 4.46741e-06_r8, 5.20969e-06_r8, 6.07529e-06_r8/)
      kao_mn2o( 5, :,15) = (/ &
     & 3.77265e-07_r8, 4.39951e-07_r8, 5.13053e-07_r8, 5.98303e-07_r8, 6.97717e-07_r8, &
     & 8.13650e-07_r8, 9.48846e-07_r8, 1.10651e-06_r8, 1.29036e-06_r8, 1.50477e-06_r8, &
     & 1.75480e-06_r8, 2.04638e-06_r8, 2.38641e-06_r8, 2.78294e-06_r8, 3.24535e-06_r8, &
     & 3.78460e-06_r8, 4.41345e-06_r8, 5.14679e-06_r8, 6.00198e-06_r8/)
      kao_mn2o( 6, :,15) = (/ &
     & 3.77877e-07_r8, 4.40670e-07_r8, 5.13897e-07_r8, 5.99292e-07_r8, 6.98878e-07_r8, &
     & 8.15012e-07_r8, 9.50444e-07_r8, 1.10838e-06_r8, 1.29256e-06_r8, 1.50735e-06_r8, &
     & 1.75783e-06_r8, 2.04993e-06_r8, 2.39057e-06_r8, 2.78782e-06_r8, 3.25107e-06_r8, &
     & 3.79131e-06_r8, 4.42132e-06_r8, 5.15602e-06_r8, 6.01280e-06_r8/)
      kao_mn2o( 7, :,15) = (/ &
     & 3.80495e-07_r8, 4.43726e-07_r8, 5.17465e-07_r8, 6.03458e-07_r8, 7.03741e-07_r8, &
     & 8.20689e-07_r8, 9.57072e-07_r8, 1.11612e-06_r8, 1.30160e-06_r8, 1.51790e-06_r8, &
     & 1.77014e-06_r8, 2.06430e-06_r8, 2.40735e-06_r8, 2.80741e-06_r8, 3.27394e-06_r8, &
     & 3.81801e-06_r8, 4.45249e-06_r8, 5.19241e-06_r8, 6.05528e-06_r8/)
      kao_mn2o( 8, :,15) = (/ &
     & 3.87881e-07_r8, 4.52329e-07_r8, 5.27486e-07_r8, 6.15129e-07_r8, 7.17335e-07_r8, &
     & 8.36523e-07_r8, 9.75515e-07_r8, 1.13760e-06_r8, 1.32662e-06_r8, 1.54704e-06_r8, &
     & 1.80409e-06_r8, 2.10384e-06_r8, 2.45340e-06_r8, 2.86105e-06_r8, 3.33642e-06_r8, &
     & 3.89078e-06_r8, 4.53725e-06_r8, 5.29112e-06_r8, 6.17026e-06_r8/)
      kao_mn2o( 9, :,15) = (/ &
     & 3.77265e-07_r8, 4.39951e-07_r8, 5.13053e-07_r8, 5.98303e-07_r8, 6.97717e-07_r8, &
     & 8.13650e-07_r8, 9.48846e-07_r8, 1.10651e-06_r8, 1.29036e-06_r8, 1.50477e-06_r8, &
     & 1.75480e-06_r8, 2.04638e-06_r8, 2.38641e-06_r8, 2.78294e-06_r8, 3.24535e-06_r8, &
     & 3.78460e-06_r8, 4.41345e-06_r8, 5.14679e-06_r8, 6.00198e-06_r8/)
      kao_mn2o( 1, :,16) = (/ &
     & 8.84606e-02_r8, 9.05971e-02_r8, 9.27852e-02_r8, 9.50261e-02_r8, 9.73212e-02_r8, &
     & 9.96717e-02_r8, 1.02079e-01_r8, 1.04544e-01_r8, 1.07069e-01_r8, 1.09655e-01_r8, &
     & 1.12304e-01_r8, 1.15016e-01_r8, 1.17794e-01_r8, 1.20639e-01_r8, 1.23553e-01_r8, &
     & 1.26537e-01_r8, 1.29593e-01_r8, 1.32723e-01_r8, 1.35928e-01_r8/)
      kao_mn2o( 2, :,16) = (/ &
     & 8.13898e-07_r8, 9.49130e-07_r8, 1.10683e-06_r8, 1.29073e-06_r8, 1.50519e-06_r8, &
     & 1.75528e-06_r8, 2.04693e-06_r8, 2.38703e-06_r8, 2.78364e-06_r8, 3.24615e-06_r8, &
     & 3.78551e-06_r8, 4.41449e-06_r8, 5.14796e-06_r8, 6.00331e-06_r8, 7.00078e-06_r8, &
     & 8.16398e-06_r8, 9.52045e-06_r8, 1.11023e-05_r8, 1.29470e-05_r8/)
      kao_mn2o( 3, :,16) = (/ &
     & 8.32666e-07_r8, 9.71021e-07_r8, 1.13237e-06_r8, 1.32052e-06_r8, 1.53994e-06_r8, &
     & 1.79581e-06_r8, 2.09420e-06_r8, 2.44217e-06_r8, 2.84796e-06_r8, 3.32117e-06_r8, &
     & 3.87302e-06_r8, 4.51656e-06_r8, 5.26703e-06_r8, 6.14219e-06_r8, 7.16277e-06_r8, &
     & 8.35294e-06_r8, 9.74086e-06_r8, 1.13594e-05_r8, 1.32468e-05_r8/)
      kao_mn2o( 4, :,16) = (/ &
     & 8.70348e-07_r8, 1.01496e-06_r8, 1.18360e-06_r8, 1.38026e-06_r8, 1.60959e-06_r8, &
     & 1.87703e-06_r8, 2.18890e-06_r8, 2.55259e-06_r8, 2.97671e-06_r8, 3.47130e-06_r8, &
     & 4.04807e-06_r8, 4.72067e-06_r8, 5.50502e-06_r8, 6.41970e-06_r8, 7.48635e-06_r8, &
     & 8.73023e-06_r8, 1.01808e-05_r8, 1.18724e-05_r8, 1.38450e-05_r8/)
      kao_mn2o( 5, :,16) = (/ &
     & 9.07957e-07_r8, 1.05882e-06_r8, 1.23475e-06_r8, 1.43991e-06_r8, 1.67916e-06_r8, &
     & 1.95816e-06_r8, 2.28352e-06_r8, 2.66294e-06_r8, 3.10541e-06_r8, 3.62139e-06_r8, &
     & 4.22310e-06_r8, 4.92480e-06_r8, 5.74308e-06_r8, 6.69733e-06_r8, 7.81013e-06_r8, &
     & 9.10784e-06_r8, 1.06212e-05_r8, 1.23859e-05_r8, 1.44439e-05_r8/)
      kao_mn2o( 6, :,16) = (/ &
     & 8.59072e-04_r8, 9.19773e-04_r8, 9.84764e-04_r8, 1.05435e-03_r8, 1.12885e-03_r8, &
     & 1.20861e-03_r8, 1.29401e-03_r8, 1.38544e-03_r8, 1.48334e-03_r8, 1.58815e-03_r8, &
     & 1.70037e-03_r8, 1.82052e-03_r8, 1.94915e-03_r8, 2.08688e-03_r8, 2.23434e-03_r8, &
     & 2.39222e-03_r8, 2.56125e-03_r8, 2.74223e-03_r8, 2.93599e-03_r8/)
      kao_mn2o( 7, :,16) = (/ &
     & 9.17294e-07_r8, 1.06971e-06_r8, 1.24746e-06_r8, 1.45474e-06_r8, 1.69646e-06_r8, &
     & 1.97835e-06_r8, 2.30708e-06_r8, 2.69043e-06_r8, 3.13748e-06_r8, 3.65880e-06_r8, &
     & 4.26676e-06_r8, 4.97574e-06_r8, 5.80251e-06_r8, 6.76667e-06_r8, 7.89104e-06_r8, &
     & 9.20223e-06_r8, 1.07313e-05_r8, 1.25144e-05_r8, 1.45939e-05_r8/)
      kao_mn2o( 8, :,16) = (/ &
     & 9.17341e-07_r8, 1.06977e-06_r8, 1.24752e-06_r8, 1.45480e-06_r8, 1.69653e-06_r8, &
     & 1.97843e-06_r8, 2.30716e-06_r8, 2.69051e-06_r8, 3.13757e-06_r8, 3.65890e-06_r8, &
     & 4.26686e-06_r8, 4.97584e-06_r8, 5.80261e-06_r8, 6.76677e-06_r8, 7.89113e-06_r8, &
     & 9.20231e-06_r8, 1.07314e-05_r8, 1.25145e-05_r8, 1.45939e-05_r8/)
      kao_mn2o( 9, :,16) = (/ &
     & 9.07957e-07_r8, 1.05882e-06_r8, 1.23475e-06_r8, 1.43991e-06_r8, 1.67916e-06_r8, &
     & 1.95816e-06_r8, 2.28352e-06_r8, 2.66294e-06_r8, 3.10541e-06_r8, 3.62139e-06_r8, &
     & 4.22310e-06_r8, 4.92480e-06_r8, 5.74308e-06_r8, 6.69733e-06_r8, 7.81013e-06_r8, &
     & 9.10784e-06_r8, 1.06212e-05_r8, 1.23859e-05_r8, 1.44439e-05_r8/)

!     The array KBO_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level above 100~ mb.   The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amounts ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 to 
!     that of gas2.  The second index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The third index 
!     runs over the g-channel (1 to 16).

      kbo_mn2o( 1, :, 1) = (/ &
     & 7.72009e-08_r8, 1.15883e-07_r8, 1.73947e-07_r8, 2.61104e-07_r8, 3.91932e-07_r8, &
     & 5.88311e-07_r8, 8.83088e-07_r8, 1.32556e-06_r8, 1.98975e-06_r8, 2.98672e-06_r8, &
     & 4.48324e-06_r8, 6.72960e-06_r8, 1.01015e-05_r8, 1.51629e-05_r8, 2.27604e-05_r8, &
     & 3.41646e-05_r8, 5.12831e-05_r8, 7.69787e-05_r8, 1.15549e-04_r8/)
      kbo_mn2o( 2, :, 1) = (/ &
     & 1.29932e-05_r8, 1.78207e-05_r8, 2.44419e-05_r8, 3.35232e-05_r8, 4.59786e-05_r8, &
     & 6.30617e-05_r8, 8.64920e-05_r8, 1.18628e-04_r8, 1.62703e-04_r8, 2.23155e-04_r8, &
     & 3.06067e-04_r8, 4.19784e-04_r8, 5.75753e-04_r8, 7.89671e-04_r8, 1.08307e-03_r8, &
     & 1.48548e-03_r8, 2.03740e-03_r8, 2.79439e-03_r8, 3.83262e-03_r8/)
      kbo_mn2o( 3, :, 1) = (/ &
     & 6.44518e-05_r8, 8.10996e-05_r8, 1.02047e-04_r8, 1.28406e-04_r8, 1.61573e-04_r8, &
     & 2.03307e-04_r8, 2.55821e-04_r8, 3.21899e-04_r8, 4.05045e-04_r8, 5.09667e-04_r8, &
     & 6.41313e-04_r8, 8.06964e-04_r8, 1.01540e-03_r8, 1.27768e-03_r8, 1.60770e-03_r8, &
     & 2.02296e-03_r8, 2.54549e-03_r8, 3.20298e-03_r8, 4.03031e-03_r8/)
      kbo_mn2o( 4, :, 1) = (/ &
     & 3.23454e-04_r8, 3.82112e-04_r8, 4.51408e-04_r8, 5.33270e-04_r8, 6.29978e-04_r8, &
     & 7.44223e-04_r8, 8.79187e-04_r8, 1.03863e-03_r8, 1.22698e-03_r8, 1.44949e-03_r8, &
     & 1.71235e-03_r8, 2.02289e-03_r8, 2.38974e-03_r8, 2.82311e-03_r8, 3.33508e-03_r8, &
     & 3.93989e-03_r8, 4.65439e-03_r8, 5.49845e-03_r8, 6.49558e-03_r8/)
      kbo_mn2o( 5, :, 1) = (/ &
     & 1.45978e-04_r8, 1.75646e-04_r8, 2.11344e-04_r8, 2.54296e-04_r8, 3.05978e-04_r8, &
     & 3.68163e-04_r8, 4.42986e-04_r8, 5.33017e-04_r8, 6.41344e-04_r8, 7.71687e-04_r8, &
     & 9.28522e-04_r8, 1.11723e-03_r8, 1.34429e-03_r8, 1.61750e-03_r8, 1.94623e-03_r8, &
     & 2.34177e-03_r8, 2.81770e-03_r8, 3.39035e-03_r8, 4.07939e-03_r8/)
      kbo_mn2o( 1, :, 2) = (/ &
     & 1.94527e-04_r8, 2.38609e-04_r8, 2.92680e-04_r8, 3.59005e-04_r8, 4.40360e-04_r8, &
     & 5.40150e-04_r8, 6.62554e-04_r8, 8.12697e-04_r8, 9.96864e-04_r8, 1.22276e-03_r8, &
     & 1.49986e-03_r8, 1.83974e-03_r8, 2.25665e-03_r8, 2.76803e-03_r8, 3.39530e-03_r8, &
     & 4.16472e-03_r8, 5.10849e-03_r8, 6.26613e-03_r8, 7.68611e-03_r8/)
      kbo_mn2o( 2, :, 2) = (/ &
     & 7.49615e-04_r8, 8.82716e-04_r8, 1.03945e-03_r8, 1.22401e-03_r8, 1.44135e-03_r8, &
     & 1.69727e-03_r8, 1.99863e-03_r8, 2.35351e-03_r8, 2.77139e-03_r8, 3.26347e-03_r8, &
     & 3.84293e-03_r8, 4.52528e-03_r8, 5.32878e-03_r8, 6.27495e-03_r8, 7.38911e-03_r8, &
     & 8.70111e-03_r8, 1.02461e-02_r8, 1.20653e-02_r8, 1.42076e-02_r8/)
      kbo_mn2o( 3, :, 2) = (/ &
     & 1.39162e-03_r8, 1.59859e-03_r8, 1.83634e-03_r8, 2.10946e-03_r8, 2.42319e-03_r8, &
     & 2.78358e-03_r8, 3.19758e-03_r8, 3.67314e-03_r8, 4.21944e-03_r8, 4.84698e-03_r8, &
     & 5.56786e-03_r8, 6.39595e-03_r8, 7.34720e-03_r8, 8.43992e-03_r8, 9.69516e-03_r8, &
     & 1.11371e-02_r8, 1.27935e-02_r8, 1.46962e-02_r8, 1.68819e-02_r8/)
      kbo_mn2o( 4, :, 2) = (/ &
     & 2.42354e-03_r8, 2.73623e-03_r8, 3.08926e-03_r8, 3.48783e-03_r8, 3.93783e-03_r8, &
     & 4.44589e-03_r8, 5.01950e-03_r8, 5.66712e-03_r8, 6.39829e-03_r8, 7.22379e-03_r8, &
     & 8.15581e-03_r8, 9.20807e-03_r8, 1.03961e-02_r8, 1.17374e-02_r8, 1.32517e-02_r8, &
     & 1.49615e-02_r8, 1.68918e-02_r8, 1.90712e-02_r8, 2.15318e-02_r8/)
      kbo_mn2o( 5, :, 2) = (/ &
     & 1.39908e-03_r8, 1.59133e-03_r8, 1.81000e-03_r8, 2.05872e-03_r8, 2.34161e-03_r8, &
     & 2.66338e-03_r8, 3.02937e-03_r8, 3.44564e-03_r8, 3.91912e-03_r8, 4.45766e-03_r8, &
     & 5.07021e-03_r8, 5.76693e-03_r8, 6.55938e-03_r8, 7.46073e-03_r8, 8.48594e-03_r8, &
     & 9.65202e-03_r8, 1.09783e-02_r8, 1.24869e-02_r8, 1.42028e-02_r8/)
      kbo_mn2o( 1, :, 3) = (/ &
     & 8.74797e-03_r8, 9.66828e-03_r8, 1.06854e-02_r8, 1.18095e-02_r8, 1.30519e-02_r8, &
     & 1.44250e-02_r8, 1.59426e-02_r8, 1.76198e-02_r8, 1.94735e-02_r8, 2.15221e-02_r8, &
     & 2.37863e-02_r8, 2.62887e-02_r8, 2.90544e-02_r8, 3.21110e-02_r8, 3.54891e-02_r8, &
     & 3.92227e-02_r8, 4.33491e-02_r8, 4.79095e-02_r8, 5.29497e-02_r8/)
      kbo_mn2o( 2, :, 3) = (/ &
     & 1.43974e-02_r8, 1.56118e-02_r8, 1.69286e-02_r8, 1.83564e-02_r8, 1.99047e-02_r8, &
     & 2.15836e-02_r8, 2.34041e-02_r8, 2.53781e-02_r8, 2.75187e-02_r8, 2.98397e-02_r8, &
     & 3.23566e-02_r8, 3.50857e-02_r8, 3.80451e-02_r8, 4.12540e-02_r8, 4.47336e-02_r8, &
     & 4.85067e-02_r8, 5.25980e-02_r8, 5.70344e-02_r8, 6.18450e-02_r8/)
      kbo_mn2o( 3, :, 3) = (/ &
     & 1.83051e-02_r8, 1.96851e-02_r8, 2.11692e-02_r8, 2.27651e-02_r8, 2.44813e-02_r8, &
     & 2.63270e-02_r8, 2.83117e-02_r8, 3.04461e-02_r8, 3.27414e-02_r8, 3.52097e-02_r8, &
     & 3.78642e-02_r8, 4.07187e-02_r8, 4.37884e-02_r8, 4.70896e-02_r8, 5.06396e-02_r8, &
     & 5.44573e-02_r8, 5.85628e-02_r8, 6.29777e-02_r8, 6.77256e-02_r8/)
      kbo_mn2o( 4, :, 3) = (/ &
     & 2.81258e-02_r8, 2.97806e-02_r8, 3.15328e-02_r8, 3.33880e-02_r8, 3.53524e-02_r8, &
     & 3.74324e-02_r8, 3.96348e-02_r8, 4.19667e-02_r8, 4.44358e-02_r8, 4.70502e-02_r8, &
     & 4.98185e-02_r8, 5.27496e-02_r8, 5.58531e-02_r8, 5.91393e-02_r8, 6.26187e-02_r8, &
     & 6.63030e-02_r8, 7.02039e-02_r8, 7.43344e-02_r8, 7.87079e-02_r8/)
      kbo_mn2o( 5, :, 3) = (/ &
     & 8.82958e-03_r8, 9.53842e-03_r8, 1.03042e-02_r8, 1.11314e-02_r8, 1.20250e-02_r8, &
     & 1.29904e-02_r8, 1.40333e-02_r8, 1.51599e-02_r8, 1.63769e-02_r8, 1.76917e-02_r8, &
     & 1.91120e-02_r8, 2.06463e-02_r8, 2.23038e-02_r8, 2.40944e-02_r8, 2.60287e-02_r8, &
     & 2.81183e-02_r8, 3.03757e-02_r8, 3.28142e-02_r8, 3.54486e-02_r8/)
      kbo_mn2o( 1, :, 4) = (/ &
     & 1.18673e-01_r8, 1.22983e-01_r8, 1.27449e-01_r8, 1.32077e-01_r8, 1.36874e-01_r8, &
     & 1.41845e-01_r8, 1.46996e-01_r8, 1.52334e-01_r8, 1.57866e-01_r8, 1.63599e-01_r8, &
     & 1.69541e-01_r8, 1.75698e-01_r8, 1.82078e-01_r8, 1.88691e-01_r8, 1.95543e-01_r8, &
     & 2.02645e-01_r8, 2.10004e-01_r8, 2.17631e-01_r8, 2.25534e-01_r8/)
      kbo_mn2o( 2, :, 4) = (/ &
     & 1.32161e-01_r8, 1.36550e-01_r8, 1.41084e-01_r8, 1.45769e-01_r8, 1.50610e-01_r8, &
     & 1.55611e-01_r8, 1.60779e-01_r8, 1.66118e-01_r8, 1.71634e-01_r8, 1.77334e-01_r8, &
     & 1.83223e-01_r8, 1.89307e-01_r8, 1.95594e-01_r8, 2.02089e-01_r8, 2.08800e-01_r8, &
     & 2.15734e-01_r8, 2.22898e-01_r8, 2.30300e-01_r8, 2.37947e-01_r8/)
      kbo_mn2o( 3, :, 4) = (/ &
     & 1.44384e-01_r8, 1.48820e-01_r8, 1.53392e-01_r8, 1.58104e-01_r8, 1.62962e-01_r8, &
     & 1.67968e-01_r8, 1.73128e-01_r8, 1.78447e-01_r8, 1.83929e-01_r8, 1.89580e-01_r8, &
     & 1.95404e-01_r8, 2.01407e-01_r8, 2.07594e-01_r8, 2.13972e-01_r8, 2.20546e-01_r8, &
     & 2.27321e-01_r8, 2.34305e-01_r8, 2.41503e-01_r8, 2.48922e-01_r8/)
      kbo_mn2o( 4, :, 4) = (/ &
     & 1.58026e-01_r8, 1.62626e-01_r8, 1.67360e-01_r8, 1.72232e-01_r8, 1.77245e-01_r8, &
     & 1.82405e-01_r8, 1.87714e-01_r8, 1.93179e-01_r8, 1.98802e-01_r8, 2.04589e-01_r8, &
     & 2.10544e-01_r8, 2.16673e-01_r8, 2.22980e-01_r8, 2.29471e-01_r8, 2.36151e-01_r8, &
     & 2.43025e-01_r8, 2.50100e-01_r8, 2.57380e-01_r8, 2.64872e-01_r8/)
      kbo_mn2o( 5, :, 4) = (/ &
     & 4.04885e-02_r8, 4.16064e-02_r8, 4.27551e-02_r8, 4.39355e-02_r8, 4.51485e-02_r8, &
     & 4.63950e-02_r8, 4.76759e-02_r8, 4.89921e-02_r8, 5.03448e-02_r8, 5.17347e-02_r8, &
     & 5.31630e-02_r8, 5.46308e-02_r8, 5.61391e-02_r8, 5.76890e-02_r8, 5.92817e-02_r8, &
     & 6.09184e-02_r8, 6.26003e-02_r8, 6.43286e-02_r8, 6.61047e-02_r8/)
      kbo_mn2o( 1, :, 5) = (/ &
     & 3.97757e-01_r8, 4.01082e-01_r8, 4.04434e-01_r8, 4.07814e-01_r8, 4.11223e-01_r8, &
     & 4.14659e-01_r8, 4.18125e-01_r8, 4.21620e-01_r8, 4.25144e-01_r8, 4.28697e-01_r8, &
     & 4.32280e-01_r8, 4.35893e-01_r8, 4.39536e-01_r8, 4.43209e-01_r8, 4.46913e-01_r8, &
     & 4.50649e-01_r8, 4.54415e-01_r8, 4.58213e-01_r8, 4.62043e-01_r8/)
      kbo_mn2o( 2, :, 5) = (/ &
     & 3.99425e-01_r8, 4.02035e-01_r8, 4.04662e-01_r8, 4.07306e-01_r8, 4.09968e-01_r8, &
     & 4.12647e-01_r8, 4.15343e-01_r8, 4.18057e-01_r8, 4.20789e-01_r8, 4.23539e-01_r8, &
     & 4.26307e-01_r8, 4.29092e-01_r8, 4.31896e-01_r8, 4.34719e-01_r8, 4.37559e-01_r8, &
     & 4.40419e-01_r8, 4.43296e-01_r8, 4.46193e-01_r8, 4.49109e-01_r8/)
      kbo_mn2o( 3, :, 5) = (/ &
     & 4.00527e-01_r8, 4.02848e-01_r8, 4.05182e-01_r8, 4.07530e-01_r8, 4.09892e-01_r8, &
     & 4.12267e-01_r8, 4.14656e-01_r8, 4.17058e-01_r8, 4.19475e-01_r8, 4.21906e-01_r8, &
     & 4.24351e-01_r8, 4.26809e-01_r8, 4.29283e-01_r8, 4.31770e-01_r8, 4.34272e-01_r8, &
     & 4.36788e-01_r8, 4.39319e-01_r8, 4.41865e-01_r8, 4.44426e-01_r8/)
      kbo_mn2o( 4, :, 5) = (/ &
     & 4.11455e-01_r8, 4.13077e-01_r8, 4.14705e-01_r8, 4.16340e-01_r8, 4.17981e-01_r8, &
     & 4.19629e-01_r8, 4.21283e-01_r8, 4.22944e-01_r8, 4.24611e-01_r8, 4.26285e-01_r8, &
     & 4.27966e-01_r8, 4.29653e-01_r8, 4.31346e-01_r8, 4.33047e-01_r8, 4.34754e-01_r8, &
     & 4.36468e-01_r8, 4.38188e-01_r8, 4.39916e-01_r8, 4.41650e-01_r8/)
      kbo_mn2o( 5, :, 5) = (/ &
     & 8.65576e-02_r8, 8.83622e-02_r8, 9.02044e-02_r8, 9.20850e-02_r8, 9.40049e-02_r8, &
     & 9.59647e-02_r8, 9.79655e-02_r8, 1.00008e-01_r8, 1.02093e-01_r8, 1.04221e-01_r8, &
     & 1.06394e-01_r8, 1.08612e-01_r8, 1.10877e-01_r8, 1.13188e-01_r8, 1.15548e-01_r8, &
     & 1.17957e-01_r8, 1.20417e-01_r8, 1.22927e-01_r8, 1.25490e-01_r8/)
      kbo_mn2o( 1, :, 6) = (/ &
     & 6.98675e-01_r8, 7.00999e-01_r8, 7.03331e-01_r8, 7.05671e-01_r8, 7.08019e-01_r8, &
     & 7.10375e-01_r8, 7.12738e-01_r8, 7.15110e-01_r8, 7.17489e-01_r8, 7.19876e-01_r8, &
     & 7.22271e-01_r8, 7.24674e-01_r8, 7.27085e-01_r8, 7.29504e-01_r8, 7.31931e-01_r8, &
     & 7.34366e-01_r8, 7.36809e-01_r8, 7.39261e-01_r8, 7.41720e-01_r8/)
      kbo_mn2o( 2, :, 6) = (/ &
     & 6.98858e-01_r8, 7.01424e-01_r8, 7.03999e-01_r8, 7.06583e-01_r8, 7.09177e-01_r8, &
     & 7.11780e-01_r8, 7.14393e-01_r8, 7.17016e-01_r8, 7.19648e-01_r8, 7.22289e-01_r8, &
     & 7.24941e-01_r8, 7.27602e-01_r8, 7.30273e-01_r8, 7.32954e-01_r8, 7.35644e-01_r8, &
     & 7.38345e-01_r8, 7.41055e-01_r8, 7.43775e-01_r8, 7.46506e-01_r8/)
      kbo_mn2o( 3, :, 6) = (/ &
     & 7.08151e-01_r8, 7.10727e-01_r8, 7.13311e-01_r8, 7.15905e-01_r8, 7.18508e-01_r8, &
     & 7.21121e-01_r8, 7.23743e-01_r8, 7.26375e-01_r8, 7.29017e-01_r8, 7.31668e-01_r8, &
     & 7.34329e-01_r8, 7.36999e-01_r8, 7.39679e-01_r8, 7.42369e-01_r8, 7.45068e-01_r8, &
     & 7.47778e-01_r8, 7.50497e-01_r8, 7.53226e-01_r8, 7.55965e-01_r8/)
      kbo_mn2o( 4, :, 6) = (/ &
     & 7.22269e-01_r8, 7.24981e-01_r8, 7.27704e-01_r8, 7.30437e-01_r8, 7.33180e-01_r8, &
     & 7.35933e-01_r8, 7.38697e-01_r8, 7.41471e-01_r8, 7.44256e-01_r8, 7.47051e-01_r8, &
     & 7.49856e-01_r8, 7.52672e-01_r8, 7.55499e-01_r8, 7.58336e-01_r8, 7.61184e-01_r8, &
     & 7.64043e-01_r8, 7.66912e-01_r8, 7.69792e-01_r8, 7.72683e-01_r8/)
      kbo_mn2o( 5, :, 6) = (/ &
     & 1.75877e-01_r8, 1.78578e-01_r8, 1.81321e-01_r8, 1.84107e-01_r8, 1.86935e-01_r8, &
     & 1.89806e-01_r8, 1.92722e-01_r8, 1.95682e-01_r8, 1.98688e-01_r8, 2.01740e-01_r8, &
     & 2.04839e-01_r8, 2.07986e-01_r8, 2.11181e-01_r8, 2.14425e-01_r8, 2.17719e-01_r8, &
     & 2.21063e-01_r8, 2.24459e-01_r8, 2.27907e-01_r8, 2.31408e-01_r8/)
      kbo_mn2o( 1, :, 7) = (/ &
     & 1.82985e+00_r8, 1.83684e+00_r8, 1.84386e+00_r8, 1.85091e+00_r8, 1.85798e+00_r8, &
     & 1.86508e+00_r8, 1.87221e+00_r8, 1.87937e+00_r8, 1.88655e+00_r8, 1.89376e+00_r8, &
     & 1.90100e+00_r8, 1.90827e+00_r8, 1.91556e+00_r8, 1.92288e+00_r8, 1.93023e+00_r8, &
     & 1.93761e+00_r8, 1.94502e+00_r8, 1.95245e+00_r8, 1.95991e+00_r8/)
      kbo_mn2o( 2, :, 7) = (/ &
     & 1.83229e+00_r8, 1.83943e+00_r8, 1.84659e+00_r8, 1.85379e+00_r8, 1.86100e+00_r8, &
     & 1.86825e+00_r8, 1.87553e+00_r8, 1.88283e+00_r8, 1.89016e+00_r8, 1.89753e+00_r8, &
     & 1.90492e+00_r8, 1.91233e+00_r8, 1.91978e+00_r8, 1.92726e+00_r8, 1.93476e+00_r8, &
     & 1.94230e+00_r8, 1.94986e+00_r8, 1.95746e+00_r8, 1.96508e+00_r8/)
      kbo_mn2o( 3, :, 7) = (/ &
     & 1.84946e+00_r8, 1.85707e+00_r8, 1.86471e+00_r8, 1.87238e+00_r8, 1.88008e+00_r8, &
     & 1.88781e+00_r8, 1.89558e+00_r8, 1.90338e+00_r8, 1.91120e+00_r8, 1.91907e+00_r8, &
     & 1.92696e+00_r8, 1.93489e+00_r8, 1.94285e+00_r8, 1.95084e+00_r8, 1.95886e+00_r8, &
     & 1.96692e+00_r8, 1.97501e+00_r8, 1.98313e+00_r8, 1.99129e+00_r8/)
      kbo_mn2o( 4, :, 7) = (/ &
     & 1.88354e+00_r8, 1.89167e+00_r8, 1.89983e+00_r8, 1.90803e+00_r8, 1.91626e+00_r8, &
     & 1.92453e+00_r8, 1.93283e+00_r8, 1.94117e+00_r8, 1.94955e+00_r8, 1.95796e+00_r8, &
     & 1.96641e+00_r8, 1.97489e+00_r8, 1.98341e+00_r8, 1.99197e+00_r8, 2.00056e+00_r8, &
     & 2.00920e+00_r8, 2.01787e+00_r8, 2.02657e+00_r8, 2.03532e+00_r8/)
      kbo_mn2o( 5, :, 7) = (/ &
     & 3.35154e-01_r8, 3.43258e-01_r8, 3.51557e-01_r8, 3.60058e-01_r8, 3.68764e-01_r8, &
     & 3.77680e-01_r8, 3.86812e-01_r8, 3.96164e-01_r8, 4.05743e-01_r8, 4.15553e-01_r8, &
     & 4.25601e-01_r8, 4.35892e-01_r8, 4.46431e-01_r8, 4.57225e-01_r8, 4.68280e-01_r8, &
     & 4.79603e-01_r8, 4.91199e-01_r8, 5.03075e-01_r8, 5.15239e-01_r8/)
      kbo_mn2o( 1, :, 8) = (/ &
     & 4.46843e+00_r8, 4.49793e+00_r8, 4.52763e+00_r8, 4.55752e+00_r8, 4.58761e+00_r8, &
     & 4.61790e+00_r8, 4.64839e+00_r8, 4.67908e+00_r8, 4.70997e+00_r8, 4.74106e+00_r8, &
     & 4.77236e+00_r8, 4.80387e+00_r8, 4.83559e+00_r8, 4.86751e+00_r8, 4.89965e+00_r8, &
     & 4.93200e+00_r8, 4.96456e+00_r8, 4.99733e+00_r8, 5.03033e+00_r8/)
      kbo_mn2o( 2, :, 8) = (/ &
     & 4.44347e+00_r8, 4.47278e+00_r8, 4.50228e+00_r8, 4.53198e+00_r8, 4.56188e+00_r8, &
     & 4.59197e+00_r8, 4.62227e+00_r8, 4.65276e+00_r8, 4.68345e+00_r8, 4.71435e+00_r8, &
     & 4.74544e+00_r8, 4.77675e+00_r8, 4.80826e+00_r8, 4.83998e+00_r8, 4.87191e+00_r8, &
     & 4.90405e+00_r8, 4.93640e+00_r8, 4.96896e+00_r8, 5.00174e+00_r8/)
      kbo_mn2o( 3, :, 8) = (/ &
     & 4.43138e+00_r8, 4.46017e+00_r8, 4.48916e+00_r8, 4.51834e+00_r8, 4.54770e+00_r8, &
     & 4.57725e+00_r8, 4.60700e+00_r8, 4.63694e+00_r8, 4.66708e+00_r8, 4.69741e+00_r8, &
     & 4.72793e+00_r8, 4.75866e+00_r8, 4.78958e+00_r8, 4.82071e+00_r8, 4.85204e+00_r8, &
     & 4.88357e+00_r8, 4.91531e+00_r8, 4.94725e+00_r8, 4.97941e+00_r8/)
      kbo_mn2o( 4, :, 8) = (/ &
     & 4.47437e+00_r8, 4.50396e+00_r8, 4.53375e+00_r8, 4.56374e+00_r8, 4.59392e+00_r8, &
     & 4.62431e+00_r8, 4.65490e+00_r8, 4.68569e+00_r8, 4.71668e+00_r8, 4.74788e+00_r8, &
     & 4.77928e+00_r8, 4.81089e+00_r8, 4.84271e+00_r8, 4.87474e+00_r8, 4.90698e+00_r8, &
     & 4.93944e+00_r8, 4.97211e+00_r8, 5.00500e+00_r8, 5.03810e+00_r8/)
      kbo_mn2o( 5, :, 8) = (/ &
     & 8.82838e-01_r8, 8.92257e-01_r8, 9.01777e-01_r8, 9.11398e-01_r8, 9.21122e-01_r8, &
     & 9.30950e-01_r8, 9.40883e-01_r8, 9.50921e-01_r8, 9.61067e-01_r8, 9.71321e-01_r8, &
     & 9.81685e-01_r8, 9.92159e-01_r8, 1.00274e+00_r8, 1.01344e+00_r8, 1.02426e+00_r8, &
     & 1.03518e+00_r8, 1.04623e+00_r8, 1.05739e+00_r8, 1.06867e+00_r8/)
      kbo_mn2o( 1, :, 9) = (/ &
     & 7.92826e+00_r8, 7.83168e+00_r8, 7.73628e+00_r8, 7.64204e+00_r8, 7.54895e+00_r8, &
     & 7.45699e+00_r8, 7.36616e+00_r8, 7.27643e+00_r8, 7.18779e+00_r8, 7.10023e+00_r8, &
     & 7.01374e+00_r8, 6.92831e+00_r8, 6.84391e+00_r8, 6.76054e+00_r8, 6.67819e+00_r8, &
     & 6.59684e+00_r8, 6.51648e+00_r8, 6.43710e+00_r8, 6.35869e+00_r8/)
      kbo_mn2o( 2, :, 9) = (/ &
     & 7.89244e+00_r8, 7.79570e+00_r8, 7.70014e+00_r8, 7.60576e+00_r8, 7.51253e+00_r8, &
     & 7.42045e+00_r8, 7.32949e+00_r8, 7.23965e+00_r8, 7.15091e+00_r8, 7.06325e+00_r8, &
     & 6.97668e+00_r8, 6.89116e+00_r8, 6.80669e+00_r8, 6.72326e+00_r8, 6.64085e+00_r8, &
     & 6.55945e+00_r8, 6.47904e+00_r8, 6.39963e+00_r8, 6.32118e+00_r8/)
      kbo_mn2o( 3, :, 9) = (/ &
     & 7.79799e+00_r8, 7.70076e+00_r8, 7.60474e+00_r8, 7.50991e+00_r8, 7.41627e+00_r8, &
     & 7.32379e+00_r8, 7.23247e+00_r8, 7.14229e+00_r8, 7.05323e+00_r8, 6.96528e+00_r8, &
     & 6.87843e+00_r8, 6.79266e+00_r8, 6.70797e+00_r8, 6.62432e+00_r8, 6.54172e+00_r8, &
     & 6.46015e+00_r8, 6.37960e+00_r8, 6.30005e+00_r8, 6.22150e+00_r8/)
      kbo_mn2o( 4, :, 9) = (/ &
     & 7.53750e+00_r8, 7.43715e+00_r8, 7.33814e+00_r8, 7.24045e+00_r8, 7.14406e+00_r8, &
     & 7.04895e+00_r8, 6.95510e+00_r8, 6.86251e+00_r8, 6.77115e+00_r8, 6.68101e+00_r8, &
     & 6.59206e+00_r8, 6.50430e+00_r8, 6.41771e+00_r8, 6.33227e+00_r8, 6.24797e+00_r8, &
     & 6.16479e+00_r8, 6.08272e+00_r8, 6.00174e+00_r8, 5.92184e+00_r8/)
      kbo_mn2o( 5, :, 9) = (/ &
     & 5.06319e+00_r8, 5.08595e+00_r8, 5.10881e+00_r8, 5.13177e+00_r8, 5.15483e+00_r8, &
     & 5.17800e+00_r8, 5.20127e+00_r8, 5.22464e+00_r8, 5.24813e+00_r8, 5.27171e+00_r8, &
     & 5.29540e+00_r8, 5.31920e+00_r8, 5.34311e+00_r8, 5.36712e+00_r8, 5.39124e+00_r8, &
     & 5.41547e+00_r8, 5.43981e+00_r8, 5.46426e+00_r8, 5.48882e+00_r8/)
      kbo_mn2o( 1, :,10) = (/ &
     & 1.05265e+00_r8, 1.03986e+00_r8, 1.02723e+00_r8, 1.01475e+00_r8, 1.00243e+00_r8, &
     & 9.90250e-01_r8, 9.78220e-01_r8, 9.66338e-01_r8, 9.54599e-01_r8, 9.43003e-01_r8, &
     & 9.31548e-01_r8, 9.20232e-01_r8, 9.09054e-01_r8, 8.98011e-01_r8, 8.87102e-01_r8, &
     & 8.76326e-01_r8, 8.65681e-01_r8, 8.55165e-01_r8, 8.44777e-01_r8/)
      kbo_mn2o( 2, :,10) = (/ &
     & 1.05246e+00_r8, 1.03973e+00_r8, 1.02714e+00_r8, 1.01471e+00_r8, 1.00243e+00_r8, &
     & 9.90303e-01_r8, 9.78319e-01_r8, 9.66480e-01_r8, 9.54784e-01_r8, 9.43230e-01_r8, &
     & 9.31815e-01_r8, 9.20539e-01_r8, 9.09399e-01_r8, 8.98394e-01_r8, 8.87522e-01_r8, &
     & 8.76782e-01_r8, 8.66171e-01_r8, 8.55690e-01_r8, 8.45335e-01_r8/)
      kbo_mn2o( 3, :,10) = (/ &
     & 1.05236e+00_r8, 1.03963e+00_r8, 1.02704e+00_r8, 1.01461e+00_r8, 1.00233e+00_r8, &
     & 9.90203e-01_r8, 9.78219e-01_r8, 9.66380e-01_r8, 9.54684e-01_r8, 9.43130e-01_r8, &
     & 9.31715e-01_r8, 9.20439e-01_r8, 9.09300e-01_r8, 8.98295e-01_r8, 8.87423e-01_r8, &
     & 8.76683e-01_r8, 8.66073e-01_r8, 8.55591e-01_r8, 8.45236e-01_r8/)
      kbo_mn2o( 4, :,10) = (/ &
     & 9.30836e-01_r8, 9.21099e-01_r8, 9.11464e-01_r8, 9.01930e-01_r8, 8.92495e-01_r8, &
     & 8.83159e-01_r8, 8.73921e-01_r8, 8.64779e-01_r8, 8.55733e-01_r8, 8.46781e-01_r8, &
     & 8.37923e-01_r8, 8.29158e-01_r8, 8.20485e-01_r8, 8.11902e-01_r8, 8.03409e-01_r8, &
     & 7.95005e-01_r8, 7.86689e-01_r8, 7.78460e-01_r8, 7.70316e-01_r8/)
      kbo_mn2o( 5, :,10) = (/ &
     & 1.65786e+01_r8, 1.66541e+01_r8, 1.67299e+01_r8, 1.68062e+01_r8, 1.68827e+01_r8, &
     & 1.69596e+01_r8, 1.70369e+01_r8, 1.71145e+01_r8, 1.71925e+01_r8, 1.72708e+01_r8, &
     & 1.73495e+01_r8, 1.74285e+01_r8, 1.75079e+01_r8, 1.75877e+01_r8, 1.76678e+01_r8, &
     & 1.77483e+01_r8, 1.78291e+01_r8, 1.79103e+01_r8, 1.79919e+01_r8/)
      kbo_mn2o( 1, :,11) = (/ &
     & 1.74239e-01_r8, 1.77873e-01_r8, 1.81583e-01_r8, 1.85370e-01_r8, 1.89236e-01_r8, &
     & 1.93182e-01_r8, 1.97211e-01_r8, 2.01324e-01_r8, 2.05523e-01_r8, 2.09809e-01_r8, &
     & 2.14185e-01_r8, 2.18652e-01_r8, 2.23212e-01_r8, 2.27867e-01_r8, 2.32620e-01_r8, &
     & 2.37471e-01_r8, 2.42424e-01_r8, 2.47479e-01_r8, 2.52641e-01_r8/)
      kbo_mn2o( 2, :,11) = (/ &
     & 1.74114e-01_r8, 1.77756e-01_r8, 1.81475e-01_r8, 1.85271e-01_r8, 1.89147e-01_r8, &
     & 1.93104e-01_r8, 1.97144e-01_r8, 2.01268e-01_r8, 2.05479e-01_r8, 2.09778e-01_r8, &
     & 2.14166e-01_r8, 2.18647e-01_r8, 2.23221e-01_r8, 2.27890e-01_r8, 2.32658e-01_r8, &
     & 2.37525e-01_r8, 2.42494e-01_r8, 2.47567e-01_r8, 2.52746e-01_r8/)
      kbo_mn2o( 3, :,11) = (/ &
     & 1.74142e-01_r8, 1.77780e-01_r8, 1.81494e-01_r8, 1.85286e-01_r8, 1.89157e-01_r8, &
     & 1.93108e-01_r8, 1.97143e-01_r8, 2.01261e-01_r8, 2.05466e-01_r8, 2.09759e-01_r8, &
     & 2.14141e-01_r8, 2.18615e-01_r8, 2.23182e-01_r8, 2.27845e-01_r8, 2.32605e-01_r8, &
     & 2.37464e-01_r8, 2.42425e-01_r8, 2.47490e-01_r8, 2.52661e-01_r8/)
      kbo_mn2o( 4, :,11) = (/ &
     & 1.74074e-01_r8, 1.77716e-01_r8, 1.81435e-01_r8, 1.85231e-01_r8, 1.89107e-01_r8, &
     & 1.93064e-01_r8, 1.97104e-01_r8, 2.01229e-01_r8, 2.05439e-01_r8, 2.09738e-01_r8, &
     & 2.14127e-01_r8, 2.18607e-01_r8, 2.23181e-01_r8, 2.27852e-01_r8, 2.32619e-01_r8, &
     & 2.37487e-01_r8, 2.42456e-01_r8, 2.47529e-01_r8, 2.52709e-01_r8/)
      kbo_mn2o( 5, :,11) = (/ &
     & 2.31905e+01_r8, 2.33011e+01_r8, 2.34123e+01_r8, 2.35240e+01_r8, 2.36362e+01_r8, &
     & 2.37489e+01_r8, 2.38622e+01_r8, 2.39760e+01_r8, 2.40904e+01_r8, 2.42053e+01_r8, &
     & 2.43208e+01_r8, 2.44368e+01_r8, 2.45533e+01_r8, 2.46705e+01_r8, 2.47881e+01_r8, &
     & 2.49064e+01_r8, 2.50252e+01_r8, 2.51446e+01_r8, 2.52645e+01_r8/)
      kbo_mn2o( 1, :,12) = (/ &
     & 1.60269e-01_r8, 1.62873e-01_r8, 1.65519e-01_r8, 1.68208e-01_r8, 1.70940e-01_r8, &
     & 1.73717e-01_r8, 1.76540e-01_r8, 1.79408e-01_r8, 1.82322e-01_r8, 1.85284e-01_r8, &
     & 1.88295e-01_r8, 1.91354e-01_r8, 1.94462e-01_r8, 1.97622e-01_r8, 2.00832e-01_r8, &
     & 2.04095e-01_r8, 2.07411e-01_r8, 2.10780e-01_r8, 2.14205e-01_r8/)
      kbo_mn2o( 2, :,12) = (/ &
     & 1.60497e-01_r8, 1.63096e-01_r8, 1.65738e-01_r8, 1.68422e-01_r8, 1.71150e-01_r8, &
     & 1.73922e-01_r8, 1.76738e-01_r8, 1.79601e-01_r8, 1.82510e-01_r8, 1.85466e-01_r8, &
     & 1.88469e-01_r8, 1.91522e-01_r8, 1.94624e-01_r8, 1.97776e-01_r8, 2.00979e-01_r8, &
     & 2.04234e-01_r8, 2.07542e-01_r8, 2.10903e-01_r8, 2.14319e-01_r8/)
      kbo_mn2o( 3, :,12) = (/ &
     & 1.60407e-01_r8, 1.63006e-01_r8, 1.65648e-01_r8, 1.68332e-01_r8, 1.71060e-01_r8, &
     & 1.73832e-01_r8, 1.76649e-01_r8, 1.79511e-01_r8, 1.82420e-01_r8, 1.85376e-01_r8, &
     & 1.88380e-01_r8, 1.91433e-01_r8, 1.94535e-01_r8, 1.97687e-01_r8, 2.00891e-01_r8, &
     & 2.04146e-01_r8, 2.07454e-01_r8, 2.10816e-01_r8, 2.14232e-01_r8/)
      kbo_mn2o( 4, :,12) = (/ &
     & 1.60475e-01_r8, 1.63070e-01_r8, 1.65706e-01_r8, 1.68386e-01_r8, 1.71109e-01_r8, &
     & 1.73876e-01_r8, 1.76687e-01_r8, 1.79544e-01_r8, 1.82448e-01_r8, 1.85398e-01_r8, &
     & 1.88396e-01_r8, 1.91442e-01_r8, 1.94538e-01_r8, 1.97684e-01_r8, 2.00881e-01_r8, &
     & 2.04129e-01_r8, 2.07430e-01_r8, 2.10784e-01_r8, 2.14192e-01_r8/)
      kbo_mn2o( 5, :,12) = (/ &
     & 3.25743e+01_r8, 3.27992e+01_r8, 3.30256e+01_r8, 3.32536e+01_r8, 3.34832e+01_r8, &
     & 3.37143e+01_r8, 3.39471e+01_r8, 3.41815e+01_r8, 3.44174e+01_r8, 3.46550e+01_r8, &
     & 3.48943e+01_r8, 3.51352e+01_r8, 3.53778e+01_r8, 3.56220e+01_r8, 3.58679e+01_r8, &
     & 3.61156e+01_r8, 3.63649e+01_r8, 3.66159e+01_r8, 3.68687e+01_r8/)
      kbo_mn2o( 1, :,13) = (/ &
     & 2.01846e-01_r8, 2.03110e-01_r8, 2.04381e-01_r8, 2.05660e-01_r8, 2.06947e-01_r8, &
     & 2.08242e-01_r8, 2.09546e-01_r8, 2.10857e-01_r8, 2.12177e-01_r8, 2.13505e-01_r8, &
     & 2.14841e-01_r8, 2.16186e-01_r8, 2.17539e-01_r8, 2.18900e-01_r8, 2.20270e-01_r8, &
     & 2.21649e-01_r8, 2.23036e-01_r8, 2.24432e-01_r8, 2.25837e-01_r8/)
      kbo_mn2o( 2, :,13) = (/ &
     & 2.01756e-01_r8, 2.03020e-01_r8, 2.04291e-01_r8, 2.05570e-01_r8, 2.06857e-01_r8, &
     & 2.08152e-01_r8, 2.09456e-01_r8, 2.10767e-01_r8, 2.12087e-01_r8, 2.13415e-01_r8, &
     & 2.14751e-01_r8, 2.16096e-01_r8, 2.17449e-01_r8, 2.18810e-01_r8, 2.20181e-01_r8, &
     & 2.21559e-01_r8, 2.22946e-01_r8, 2.24342e-01_r8, 2.25747e-01_r8/)
      kbo_mn2o( 3, :,13) = (/ &
     & 2.01836e-01_r8, 2.03100e-01_r8, 2.04371e-01_r8, 2.05650e-01_r8, 2.06937e-01_r8, &
     & 2.08232e-01_r8, 2.09536e-01_r8, 2.10847e-01_r8, 2.12167e-01_r8, 2.13495e-01_r8, &
     & 2.14831e-01_r8, 2.16176e-01_r8, 2.17529e-01_r8, 2.18890e-01_r8, 2.20260e-01_r8, &
     & 2.21639e-01_r8, 2.23026e-01_r8, 2.24422e-01_r8, 2.25827e-01_r8/)
      kbo_mn2o( 4, :,13) = (/ &
     & 2.01845e-01_r8, 2.03103e-01_r8, 2.04370e-01_r8, 2.05644e-01_r8, 2.06926e-01_r8, &
     & 2.08217e-01_r8, 2.09515e-01_r8, 2.10822e-01_r8, 2.12136e-01_r8, 2.13459e-01_r8, &
     & 2.14790e-01_r8, 2.16129e-01_r8, 2.17477e-01_r8, 2.18833e-01_r8, 2.20198e-01_r8, &
     & 2.21571e-01_r8, 2.22952e-01_r8, 2.24343e-01_r8, 2.25741e-01_r8/)
      kbo_mn2o( 5, :,13) = (/ &
     & 5.34154e+01_r8, 5.31954e+01_r8, 5.29763e+01_r8, 5.27582e+01_r8, 5.25409e+01_r8, &
     & 5.23245e+01_r8, 5.21090e+01_r8, 5.18943e+01_r8, 5.16806e+01_r8, 5.14677e+01_r8, &
     & 5.12558e+01_r8, 5.10446e+01_r8, 5.08344e+01_r8, 5.06250e+01_r8, 5.04165e+01_r8, &
     & 5.02089e+01_r8, 5.00021e+01_r8, 4.97961e+01_r8, 4.95910e+01_r8/)
      kbo_mn2o( 1, :,14) = (/ &
     & 2.87818e-02_r8, 3.17868e-02_r8, 3.51056e-02_r8, 3.87708e-02_r8, 4.28187e-02_r8, &
     & 4.72893e-02_r8, 5.22266e-02_r8, 5.76794e-02_r8, 6.37015e-02_r8, 7.03523e-02_r8, &
     & 7.76976e-02_r8, 8.58097e-02_r8, 9.47688e-02_r8, 1.04663e-01_r8, 1.15591e-01_r8, &
     & 1.27659e-01_r8, 1.40988e-01_r8, 1.55708e-01_r8, 1.71965e-01_r8/)
      kbo_mn2o( 2, :,14) = (/ &
     & 2.88500e-02_r8, 3.18494e-02_r8, 3.51606e-02_r8, 3.88161e-02_r8, 4.28517e-02_r8, &
     & 4.73068e-02_r8, 5.22251e-02_r8, 5.76547e-02_r8, 6.36488e-02_r8, 7.02661e-02_r8, &
     & 7.75714e-02_r8, 8.56362e-02_r8, 9.45395e-02_r8, 1.04368e-01_r8, 1.15219e-01_r8, &
     & 1.27198e-01_r8, 1.40422e-01_r8, 1.55021e-01_r8, 1.71138e-01_r8/)
      kbo_mn2o( 3, :,14) = (/ &
     & 2.88036e-02_r8, 3.18109e-02_r8, 3.51322e-02_r8, 3.88002e-02_r8, 4.28512e-02_r8, &
     & 4.73252e-02_r8, 5.22663e-02_r8, 5.77232e-02_r8, 6.37499e-02_r8, 7.04058e-02_r8, &
     & 7.77567e-02_r8, 8.58751e-02_r8, 9.48410e-02_r8, 1.04743e-01_r8, 1.15679e-01_r8, &
     & 1.27757e-01_r8, 1.41095e-01_r8, 1.55827e-01_r8, 1.72096e-01_r8/)
      kbo_mn2o( 4, :,14) = (/ &
     & 2.87750e-02_r8, 3.17783e-02_r8, 3.50951e-02_r8, 3.87580e-02_r8, 4.28033e-02_r8, &
     & 4.72708e-02_r8, 5.22046e-02_r8, 5.76533e-02_r8, 6.36707e-02_r8, 7.03162e-02_r8, &
     & 7.76553e-02_r8, 8.57604e-02_r8, 9.47114e-02_r8, 1.04597e-01_r8, 1.15514e-01_r8, &
     & 1.27570e-01_r8, 1.40885e-01_r8, 1.55589e-01_r8, 1.71829e-01_r8/)
      kbo_mn2o( 5, :,14) = (/ &
     & 1.11848e+02_r8, 1.09489e+02_r8, 1.07179e+02_r8, 1.04918e+02_r8, 1.02705e+02_r8, &
     & 1.00538e+02_r8, 9.84175e+01_r8, 9.63414e+01_r8, 9.43091e+01_r8, 9.23196e+01_r8, &
     & 9.03722e+01_r8, 8.84658e+01_r8, 8.65996e+01_r8, 8.47728e+01_r8, 8.29845e+01_r8, &
     & 8.12339e+01_r8, 7.95203e+01_r8, 7.78428e+01_r8, 7.62007e+01_r8/)
      kbo_mn2o( 1, :,15) = (/ &
     & 1.52234e-02_r8, 1.69256e-02_r8, 1.88181e-02_r8, 2.09222e-02_r8, 2.32617e-02_r8, &
     & 2.58626e-02_r8, 2.87545e-02_r8, 3.19696e-02_r8, 3.55443e-02_r8, 3.95187e-02_r8, &
     & 4.39374e-02_r8, 4.88503e-02_r8, 5.43124e-02_r8, 6.03854e-02_r8, 6.71373e-02_r8, &
     & 7.46443e-02_r8, 8.29906e-02_r8, 9.22701e-02_r8, 1.02587e-01_r8/)
      kbo_mn2o( 2, :,15) = (/ &
     & 1.52234e-02_r8, 1.69256e-02_r8, 1.88181e-02_r8, 2.09222e-02_r8, 2.32617e-02_r8, &
     & 2.58626e-02_r8, 2.87545e-02_r8, 3.19696e-02_r8, 3.55443e-02_r8, 3.95187e-02_r8, &
     & 4.39374e-02_r8, 4.88503e-02_r8, 5.43124e-02_r8, 6.03854e-02_r8, 6.71373e-02_r8, &
     & 7.46443e-02_r8, 8.29906e-02_r8, 9.22701e-02_r8, 1.02587e-01_r8/)
      kbo_mn2o( 3, :,15) = (/ &
     & 1.52076e-02_r8, 1.69049e-02_r8, 1.87916e-02_r8, 2.08890e-02_r8, 2.32203e-02_r8, &
     & 2.58119e-02_r8, 2.86928e-02_r8, 3.18951e-02_r8, 3.54549e-02_r8, 3.94120e-02_r8, &
     & 4.38107e-02_r8, 4.87003e-02_r8, 5.41357e-02_r8, 6.01777e-02_r8, 6.68940e-02_r8, &
     & 7.43600e-02_r8, 8.26593e-02_r8, 9.18847e-02_r8, 1.02140e-01_r8/)
      kbo_mn2o( 4, :,15) = (/ &
     & 1.52422e-02_r8, 1.69488e-02_r8, 1.88464e-02_r8, 2.09565e-02_r8, 2.33028e-02_r8, &
     & 2.59118e-02_r8, 2.88129e-02_r8, 3.20389e-02_r8, 3.56260e-02_r8, 3.96148e-02_r8, &
     & 4.40501e-02_r8, 4.89821e-02_r8, 5.44662e-02_r8, 6.05643e-02_r8, 6.73452e-02_r8, &
     & 7.48853e-02_r8, 8.32696e-02_r8, 9.25927e-02_r8, 1.02959e-01_r8/)
      kbo_mn2o( 5, :,15) = (/ &
     & 6.94782e+01_r8, 6.73469e+01_r8, 6.52810e+01_r8, 6.32785e+01_r8, 6.13373e+01_r8, &
     & 5.94558e+01_r8, 5.76319e+01_r8, 5.58640e+01_r8, 5.41503e+01_r8, 5.24892e+01_r8, &
     & 5.08791e+01_r8, 4.93183e+01_r8, 4.78055e+01_r8, 4.63390e+01_r8, 4.49175e+01_r8, &
     & 4.35396e+01_r8, 4.22040e+01_r8, 4.09094e+01_r8, 3.96544e+01_r8/)
      kbo_mn2o( 1, :,16) = (/ &
     & 1.08257e-02_r8, 1.15188e-02_r8, 1.22563e-02_r8, 1.30410e-02_r8, 1.38759e-02_r8, &
     & 1.47643e-02_r8, 1.57096e-02_r8, 1.67154e-02_r8, 1.77857e-02_r8, 1.89244e-02_r8, &
     & 2.01360e-02_r8, 2.14252e-02_r8, 2.27970e-02_r8, 2.42565e-02_r8, 2.58096e-02_r8, &
     & 2.74620e-02_r8, 2.92203e-02_r8, 3.10911e-02_r8, 3.30817e-02_r8/)
      kbo_mn2o( 2, :,16) = (/ &
     & 1.08257e-02_r8, 1.15188e-02_r8, 1.22563e-02_r8, 1.30410e-02_r8, 1.38759e-02_r8, &
     & 1.47643e-02_r8, 1.57096e-02_r8, 1.67154e-02_r8, 1.77857e-02_r8, 1.89244e-02_r8, &
     & 2.01360e-02_r8, 2.14252e-02_r8, 2.27970e-02_r8, 2.42565e-02_r8, 2.58096e-02_r8, &
     & 2.74620e-02_r8, 2.92203e-02_r8, 3.10911e-02_r8, 3.30817e-02_r8/)
      kbo_mn2o( 3, :,16) = (/ &
     & 1.08257e-02_r8, 1.15188e-02_r8, 1.22563e-02_r8, 1.30410e-02_r8, 1.38759e-02_r8, &
     & 1.47643e-02_r8, 1.57096e-02_r8, 1.67154e-02_r8, 1.77857e-02_r8, 1.89244e-02_r8, &
     & 2.01360e-02_r8, 2.14252e-02_r8, 2.27970e-02_r8, 2.42565e-02_r8, 2.58096e-02_r8, &
     & 2.74620e-02_r8, 2.92203e-02_r8, 3.10911e-02_r8, 3.30817e-02_r8/)
      kbo_mn2o( 4, :,16) = (/ &
     & 1.08263e-02_r8, 1.15191e-02_r8, 1.22562e-02_r8, 1.30404e-02_r8, 1.38749e-02_r8, &
     & 1.47627e-02_r8, 1.57073e-02_r8, 1.67124e-02_r8, 1.77818e-02_r8, 1.89196e-02_r8, &
     & 2.01302e-02_r8, 2.14183e-02_r8, 2.27888e-02_r8, 2.42470e-02_r8, 2.57986e-02_r8, &
     & 2.74494e-02_r8, 2.92058e-02_r8, 3.10746e-02_r8, 3.30630e-02_r8/)
      kbo_mn2o( 5, :,16) = (/ &
     & 4.53450e-08_r8, 5.75193e-08_r8, 7.29620e-08_r8, 9.25509e-08_r8, 1.17399e-07_r8, &
     & 1.48918e-07_r8, 1.88900e-07_r8, 2.39616e-07_r8, 3.03948e-07_r8, 3.85551e-07_r8, &
     & 4.89064e-07_r8, 6.20369e-07_r8, 7.86925e-07_r8, 9.98199e-07_r8, 1.26619e-06_r8, &
     & 1.60614e-06_r8, 2.03736e-06_r8, 2.58435e-06_r8, 3.27819e-06_r8/)

!     The array FORREFO contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  The first 
!     index refers to reference temperature (296,260,224,260) and 
!     pressure (970,475,219,3 mbar) levels.  The second index 
!     runs over the g-channel (1 to 16).

      forrefo(1,:) = (/ &
     &9.0039e-04_r8,1.1081e-03_r8,1.0732e-03_r8,1.1881e-03_r8,1.2488e-03_r8,1.3170e-03_r8, &
     &1.3317e-03_r8,1.3168e-03_r8,1.3369e-03_r8,1.4228e-03_r8,1.5385e-03_r8,1.7376e-03_r8, &
     &1.7122e-03_r8,1.9002e-03_r8,1.8881e-03_r8,2.1595e-03_r8/)
      forrefo(2,:) = (/ &
     &1.2726e-03_r8,1.3680e-03_r8,1.2494e-03_r8,1.2049e-03_r8,1.2048e-03_r8,1.1256e-03_r8, &
     &1.1170e-03_r8,1.0697e-03_r8,1.1177e-03_r8,1.1883e-03_r8,1.2219e-03_r8,1.2179e-03_r8, &
     &1.5692e-03_r8,1.9103e-03_r8,2.0219e-03_r8,1.6937e-03_r8/)
      forrefo(3,:) = (/ &
     &1.5527e-03_r8,1.6477e-03_r8,1.4973e-03_r8,1.3400e-03_r8,1.0820e-03_r8,9.3315e-04_r8, &
     &8.8132e-04_r8,8.1508e-04_r8,8.3559e-04_r8,7.6492e-04_r8,8.2343e-04_r8,7.1274e-04_r8, &
     &6.6011e-04_r8,6.7179e-04_r8,6.7039e-04_r8,6.7021e-04_r8/)
      forrefo(4,:) = (/ &
     &1.6763e-03_r8,1.6066e-03_r8,1.3927e-03_r8,1.2087e-03_r8,9.8463e-04_r8,8.8414e-04_r8, &
     &8.0976e-04_r8,7.8758e-04_r8,7.7376e-04_r8,7.5785e-04_r8,7.4152e-04_r8,7.3814e-04_r8, &
     &7.4278e-04_r8,7.1745e-04_r8,6.7216e-04_r8,6.4097e-04_r8/)

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      selfrefo(:, 1) = (/ &
     & 5.11926e-01_r8, 4.32863e-01_r8, 3.66010e-01_r8, 3.09482e-01_r8, 2.61685e-01_r8, &
     & 2.21269e-01_r8, 1.87096e-01_r8, 1.58200e-01_r8, 1.33767e-01_r8, 1.13108e-01_r8/)
      selfrefo(:, 2) = (/ &
     & 5.02863e-01_r8, 4.35008e-01_r8, 3.76310e-01_r8, 3.25532e-01_r8, 2.81606e-01_r8, &
     & 2.43607e-01_r8, 2.10736e-01_r8, 1.82300e-01_r8, 1.57701e-01_r8, 1.36422e-01_r8/)
      selfrefo(:, 3) = (/ &
     & 4.57628e-01_r8, 3.99663e-01_r8, 3.49040e-01_r8, 3.04829e-01_r8, 2.66218e-01_r8, &
     & 2.32498e-01_r8, 2.03049e-01_r8, 1.77330e-01_r8, 1.54869e-01_r8, 1.35252e-01_r8/)
      selfrefo(:, 4) = (/ &
     & 4.28634e-01_r8, 3.81736e-01_r8, 3.39970e-01_r8, 3.02773e-01_r8, 2.69647e-01_r8, &
     & 2.40144e-01_r8, 2.13870e-01_r8, 1.90470e-01_r8, 1.69630e-01_r8, 1.51071e-01_r8/)
      selfrefo(:, 5) = (/ &
     & 4.21002e-01_r8, 3.77493e-01_r8, 3.38480e-01_r8, 3.03499e-01_r8, 2.72133e-01_r8, &
     & 2.44009e-01_r8, 2.18792e-01_r8, 1.96180e-01_r8, 1.75905e-01_r8, 1.57726e-01_r8/)
      selfrefo(:, 6) = (/ &
     & 3.97517e-01_r8, 3.61167e-01_r8, 3.28140e-01_r8, 2.98133e-01_r8, 2.70871e-01_r8, &
     & 2.46101e-01_r8, 2.23597e-01_r8, 2.03150e-01_r8, 1.84573e-01_r8, 1.67695e-01_r8/)
      selfrefo(:, 7) = (/ &
     & 3.92114e-01_r8, 3.57554e-01_r8, 3.26040e-01_r8, 2.97304e-01_r8, 2.71100e-01_r8, &
     & 2.47206e-01_r8, 2.25418e-01_r8, 2.05550e-01_r8, 1.87433e-01_r8, 1.70913e-01_r8/)
      selfrefo(:, 8) = (/ &
     & 3.79555e-01_r8, 3.47264e-01_r8, 3.17720e-01_r8, 2.90690e-01_r8, 2.65959e-01_r8, &
     & 2.43332e-01_r8, 2.22631e-01_r8, 2.03690e-01_r8, 1.86361e-01_r8, 1.70506e-01_r8/)
      selfrefo(:, 9) = (/ &
     & 3.92644e-01_r8, 3.58048e-01_r8, 3.26500e-01_r8, 2.97732e-01_r8, 2.71498e-01_r8, &
     & 2.47576e-01_r8, 2.25762e-01_r8, 2.05870e-01_r8, 1.87731e-01_r8, 1.71190e-01_r8/)
      selfrefo(:,10) = (/ &
     & 4.06542e-01_r8, 3.71200e-01_r8, 3.38930e-01_r8, 3.09465e-01_r8, 2.82562e-01_r8, &
     & 2.57998e-01_r8, 2.35569e-01_r8, 2.15090e-01_r8, 1.96391e-01_r8, 1.79318e-01_r8/)
      selfrefo(:,11) = (/ &
     & 4.09672e-01_r8, 3.76237e-01_r8, 3.45530e-01_r8, 3.17329e-01_r8, 2.91430e-01_r8, &
     & 2.67645e-01_r8, 2.45801e-01_r8, 2.25740e-01_r8, 2.07316e-01_r8, 1.90396e-01_r8/)
      selfrefo(:,12) = (/ &
     & 3.85140e-01_r8, 3.61989e-01_r8, 3.40230e-01_r8, 3.19779e-01_r8, 3.00557e-01_r8, &
     & 2.82490e-01_r8, 2.65510e-01_r8, 2.49550e-01_r8, 2.34549e-01_r8, 2.20451e-01_r8/)
      selfrefo(:,13) = (/ &
     & 4.87349e-01_r8, 4.42192e-01_r8, 4.01220e-01_r8, 3.64044e-01_r8, 3.30313e-01_r8, &
     & 2.99707e-01_r8, 2.71937e-01_r8, 2.46740e-01_r8, 2.23878e-01_r8, 2.03134e-01_r8/)
      selfrefo(:,14) = (/ &
     & 5.64339e-01_r8, 5.06194e-01_r8, 4.54040e-01_r8, 4.07259e-01_r8, 3.65298e-01_r8, &
     & 3.27661e-01_r8, 2.93901e-01_r8, 2.63620e-01_r8, 2.36459e-01_r8, 2.12096e-01_r8/)
      selfrefo(:,15) = (/ &
     & 5.91123e-01_r8, 5.26420e-01_r8, 4.68800e-01_r8, 4.17486e-01_r8, 3.71790e-01_r8, &
     & 3.31095e-01_r8, 2.94854e-01_r8, 2.62580e-01_r8, 2.33839e-01_r8, 2.08243e-01_r8/)
      selfrefo(:,16) = (/ &
     & 5.04590e-01_r8, 4.65235e-01_r8, 4.28950e-01_r8, 3.95495e-01_r8, 3.64649e-01_r8, &
     & 3.36209e-01_r8, 3.09987e-01_r8, 2.85810e-01_r8, 2.63519e-01_r8, 2.42966e-01_r8/)

      end subroutine lw_kgb03 

! **************************************************************************
END MODULE lw_kgbnn
