MODULE Sfc_SeaIceFlux_WRF_Model
  USE Constants, ONLY :     &
       cp,            &
       gasr

  IMPLICIT NONE

  PRIVATE
  ! Selecting Kinds
  INTEGER, PARAMETER :: r4 = SELECTED_REAL_KIND(6)  ! Kind for 32-bits Real Numbers
  INTEGER, PARAMETER :: i4 = SELECTED_INT_KIND(9)   ! Kind for 32-bits Integer Numbers
  INTEGER, PARAMETER :: r8 = SELECTED_REAL_KIND(15) ! Kind for 64-bits Real Numbers
  INTEGER, PARAMETER :: i8 = SELECTED_INT_KIND(14)  ! Kind for 64-bits Integer Numbers
  INTEGER, PARAMETER :: r16 = SELECTED_REAL_KIND(15)! Kind for 128-bits Real Numbers

  !This version of SSiB land-surface model includes a multi-layer snow scheme
  !For better results, please use the SSiB vegetation map (geog_data_res in WPS)
  !References for the SSiB:
  !Xue et al. 1991, J. Climate, 4, 345-364.
  !Sun and Xue, 2001,  Adv. in Atmos. Sci, 18, 335-354.
  !Xue et al., 2003, J. Geophy. Res. 108, D22, doi: 10.1029/2002JD003174. 
  !Coding by Fernando De Sales and  Zhengxin Liu (2011)

  REAL(KIND=r8), PARAMETER ::    CPAIR    = 1004.6_r8                  &
       ,STEFAN   = 5.669_r8 * 10E-9_r8           &
       ,GRAV     = 9.81_r8                    &
       ,VKC      = 0.4_r8                     &
       ,PIE      = 3.14159265_r8              &
       ,TIMCON   = PIE/86400.0_r8              &
       ,CLAI     = 4.2_r8 * 1000.0_r8 * 0.2_r8       &
       ,CW       = 4.2_r8 * 1000.0_r8 * 1000.0_r8     &
       ,TF       = 273.16_r8                  &
       ,HLAT     = 2.52E6_r8                  &
       ,SNOMEL   = 370518.5_r8 * 1000.0_r8
  INTEGER, PARAMETER   ::    ITRUNK   = 3

  !crr snow
  REAL(KIND=r8), PARAMETER      ::    SSISNOW  = 0.04_r8                    &
       ,FLMIN    = 0.03_r8                    &
       ,FLMAX    = 0.10_r8                    &
       ,DZMIN    = 0.002_r8                   &
       ,WOMIN    = 0.0004_r8                  &
       ,CL       = 4212.7_r8                  &
       ,DLM      = 3.335e5_r8                 &
       ,RHOWATER = 1000.0_r8                  &
       ,DICE     = 920.0_r8                   &
       ,DKSATSNOW= 0.01_r8                    &
       ,SNODEP_CR= 0.07_r8
  INTEGER, PARAMETER   ::    N        = 3                       &
       ,N1       = 4                       &
       ,N2       = 4


  !crr snow
  !ssib vegetation parameters

!  REAL(KIND=r8), DIMENSION (13,   2,3,2) :: tran0,ref0
!  REAL(KIND=r8), DIMENSION (13,12,2    ) :: green0,vcover0,zlt0
!  REAL(KIND=r8), DIMENSION (13,   2,3  ) :: rstpar0
!  REAL(KIND=r8), DIMENSION (13,12      ) :: z000,d0,z20,z10,rdc0,rbc0
!  REAL(KIND=r8), DIMENSION (13,     3  ) :: depth0,soref0
!  REAL(KIND=r8), DIMENSION (13,  2     ) :: chil0,topt0,tl0,tu0,defac0,ph10,ph20,rootd0
!  REAL(KIND=r8), DIMENSION (13         ) :: bee0,phsat0,poros0,satco0,slope0
  REAL(KIND=r8), DIMENSION(13,   2,3,2), PARAMETER :: tran0 = RESHAPE( (/      &
       0.5000000E-01_r8,  0.5000000E-01_r8,  0.5000000E-01_r8,  0.5000000E-01_r8,      &
       0.5000000E-01_r8,  0.5000000E-01_r8,  0.7000000E-01_r8,  0.5000000E-01_r8,      &
       0.5000000E-01_r8,  0.5000000E-01_r8,  0.1000000E-02_r8,  0.5000000E-01_r8,      &
       0.1000000E-02_r8,      &
       0.1000000E-02_r8,  0.1000000E-02_r8,  0.1000000E-02_r8,  0.1000000E-02_r8,      &
       0.1000000E-02_r8,  0.7000000E-01_r8,  0.1000000E-02_r8,  0.7000000E-01_r8,      &
       0.1000000E-02_r8,  0.7000000E-01_r8,  0.1000000E-02_r8,  0.7000000E-01_r8,      &
       0.1000000E-02_r8,      &
       0.2500000E+00_r8,  0.2500000E+00_r8,  0.1500000E+00_r8,  0.1000000E+00_r8,      &
       0.1000000E+00_r8,  0.2500000E+00_r8,  0.2475000E+00_r8,  0.2500000E+00_r8,      &
       0.2500000E+00_r8,  0.2500000E+00_r8,  0.1000000E-02_r8,  0.2500000E+00_r8,      &
       0.1000000E-02_r8,      &
       0.1000000E-02_r8,  0.1000000E-02_r8,  0.1000000E-02_r8,  0.1000000E-02_r8,      &
       0.1000000E-02_r8,  0.2475000E+00_r8,  0.1000000E-02_r8,  0.2475000E+00_r8,      &
       0.1000000E-02_r8,  0.2475000E+00_r8,  0.1000000E-02_r8,  0.2475000E+00_r8,      &
       0.1000000E-02_r8,      &
       0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8,      &
       0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8,      &
       0.1000000E-02_r8,  0.1000000E-02_r8,  0.1000000E-02_r8,  0.1000000E-02_r8,      &
       0.1000000E-02_r8,  0.1000000E-02_r8,  0.2200000E+00_r8,  0.1000000E-02_r8,      &
       0.1000000E-02_r8,  0.1000000E-02_r8,  0.1000000E-02_r8,  0.1000000E-02_r8,      &
       0.1000000E-02_r8,      &
       0.1000000E-02_r8,  0.1000000E-02_r8,  0.1000000E-02_r8,  0.1000000E-02_r8,      &
       0.1000000E-02_r8,  0.2200000E+00_r8,  0.1000000E-02_r8,  0.2200000E+00_r8,      &
       0.1000000E-02_r8,  0.2200000E+00_r8,  0.1000000E-02_r8,  0.2200000E+00_r8,      &
       0.1000000E-02_r8,      &
       0.1000000E-02_r8,  0.1000000E-02_r8,  0.1000000E-02_r8,  0.1000000E-02_r8,      &
       0.1000000E-02_r8,  0.1000000E-02_r8,  0.3750000E+00_r8,  0.1000000E-02_r8,      &
       0.1000000E-02_r8,  0.1000000E-02_r8,  0.1000000E-02_r8,  0.1000000E-02_r8,      &
       0.1000000E-02_r8,      &
       0.1000000E-02_r8,  0.1000000E-02_r8,  0.1000000E-02_r8,  0.1000000E-02_r8,      &
       0.1000000E-02_r8,  0.3750000E+00_r8,  0.1000000E-02_r8,  0.3750000E+00_r8,      &
       0.1000000E-02_r8,  0.3750000E+00_r8,  0.1000000E-02_r8,  0.3750000E+00_r8,      &
       0.1000000E-02_r8,      &
       0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8,      &
       0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8/), (/13,   2,3,2/) )

  REAL(KIND=r8), DIMENSION(13,   2,3,2), PARAMETER :: ref0 = RESHAPE( (/      &
       0.1000000E+00_r8,  0.1000000E+00_r8,  0.7000000E-01_r8,  0.7000000E-01_r8,      &
       0.7000000E-01_r8,  0.1000000E+00_r8,  0.1050000E+00_r8,  0.1000000E+00_r8,      &
       0.1000000E+00_r8,  0.1000000E+00_r8,  0.1000000E-02_r8,  0.1000000E+00_r8,      &
       0.1000000E-02_r8,      &
       0.1000000E-02_r8,  0.1000000E-02_r8,  0.1000000E-02_r8,  0.1000000E-02_r8,      &
       0.1000000E-02_r8,  0.1050000E+00_r8,  0.1000000E-02_r8,  0.1050000E+00_r8,      &
       0.1000000E-02_r8,  0.1050000E+00_r8,  0.1000000E-02_r8,  0.1050000E+00_r8,      &
       0.1000000E-02_r8,      &
       0.4500000E+00_r8,  0.4500000E+00_r8,  0.4000000E+00_r8,  0.3500000E+00_r8,      &
       0.3500000E+00_r8,  0.4500000E+00_r8,  0.5775000E+00_r8,  0.4500000E+00_r8,      &
       0.4500000E+00_r8,  0.4500000E+00_r8,  0.1000000E-02_r8,  0.4500000E+00_r8,      &
       0.1000000E-02_r8,      &
       0.1000000E-02_r8,  0.1000000E-02_r8,  0.1000000E-02_r8,  0.1000000E-02_r8,      &
       0.1000000E-02_r8,  0.5775000E+00_r8,  0.1000000E-02_r8,  0.5775000E+00_r8,      &
       0.1000000E-02_r8,  0.5775000E+00_r8,  0.1000000E-02_r8,  0.5775000E+00_r8,      &
       0.1000000E-02_r8,      &
       0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8,      &
       0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8,      &
       0.1600000E+00_r8,  0.1600000E+00_r8,  0.1600000E+00_r8,  0.1600000E+00_r8,      &
       0.1600000E+00_r8,  0.1600000E+00_r8,  0.3600000E+00_r8,  0.1600000E+00_r8,      &
       0.1600000E+00_r8,  0.1600000E+00_r8,  0.1000000E-02_r8,  0.1600000E+00_r8,      &
       0.1000000E-02_r8,      &
       0.1000000E-02_r8,  0.1000000E-02_r8,  0.1000000E-02_r8,  0.1000000E-02_r8,      &
       0.1000000E-02_r8,  0.3600000E+00_r8,  0.1000000E-02_r8,  0.3600000E+00_r8,      &
       0.1000000E-02_r8,  0.3600000E+00_r8,  0.1000000E-02_r8,  0.3600000E+00_r8,      &
       0.1000000E-02_r8,      &
       0.3900000E+00_r8,  0.3900000E+00_r8,  0.3900000E+00_r8,  0.3900000E+00_r8,      &
       0.3900000E+00_r8,  0.3900000E+00_r8,  0.5775000E+00_r8,  0.3900000E+00_r8,      &
       0.3900000E+00_r8,  0.3900000E+00_r8,  0.1000000E-02_r8,  0.3900000E+00_r8,      &
       0.1000000E-02_r8,      &
       0.1000000E-02_r8,  0.1000000E-02_r8,  0.1000000E-02_r8,  0.1000000E-02_r8,      &
       0.1000000E-02_r8,  0.5775000E+00_r8,  0.1000000E-02_r8,  0.5775000E+00_r8,      &
       0.1000000E-02_r8,  0.5775000E+00_r8,  0.1000000E-02_r8,  0.5775000E+00_r8,      &
       0.1000000E-02_r8,      &
       0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8,      &
       0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8/), (/13,   2,3,2/) )

  REAL(KIND=r8), DIMENSION(13,12,2    ), PARAMETER :: green0 = RESHAPE( (/      &
       0.9050000E+00_r8,  0.2564000E-01_r8,  0.8680600E+00_r8,  0.9132400E+00_r8,      &
       0.2475200E+00_r8,  0.6319100E+00_r8,  0.5681800E+00_r8,  0.7978700E+00_r8,      &
       0.8364300E+00_r8,  0.4512600E+00_r8,  0.1000000E-03_r8,  0.2083300E+00_r8,      &
       0.1000000E-03_r8,      &
       0.9050000E+00_r8,  0.2564000E-01_r8,  0.8717700E+00_r8,  0.9170300E+00_r8,      &
       0.2475200E+00_r8,  0.6566600E+00_r8,  0.6218900E+00_r8,  0.5319100E+00_r8,      &
       0.7172100E+00_r8,  0.4512600E+00_r8,  0.1000000E-03_r8,  0.2083300E+00_r8,      &
       0.1000000E-03_r8,      &
       0.9050000E+00_r8,  0.4153800E+00_r8,  0.8847300E+00_r8,  0.9226600E+00_r8,      &
       0.2475200E+00_r8,  0.5176000E+00_r8,  0.6637200E+00_r8,  0.3623200E+00_r8,      &
       0.2577300E+00_r8,  0.4512600E+00_r8,  0.1000000E-03_r8,  0.4411800E+00_r8,      &
       0.1000000E-03_r8,      &
       0.9050000E+00_r8,  0.7594900E+00_r8,  0.9061000E+00_r8,  0.9247000E+00_r8,      &
       0.6637200E+00_r8,  0.6527400E+00_r8,  0.6972100E+00_r8,  0.5681800E+00_r8,      &
       0.7246400E+00_r8,  0.4512600E+00_r8,  0.1000000E-03_r8,  0.7594900E+00_r8,      &
       0.1000000E-03_r8,      &
       0.9050000E+00_r8,  0.8875700E+00_r8,  0.9164200E+00_r8,  0.9266400E+00_r8,      &
       0.8104700E+00_r8,  0.6527400E+00_r8,  0.8104700E+00_r8,  0.5681800E+00_r8,      &
       0.1736100E+00_r8,  0.4512600E+00_r8,  0.1000000E-03_r8,  0.8875700E+00_r8,      &
       0.1000000E-03_r8,      &
       0.9050000E+00_r8,  0.9252000E+00_r8,  0.9259300E+00_r8,  0.9045800E+00_r8,      &
       0.8680600E+00_r8,  0.7246400E+00_r8,  0.9079900E+00_r8,  0.5681800E+00_r8,      &
       0.5681800E+00_r8,  0.6218900E+00_r8,  0.1000000E-03_r8,  0.9252000E+00_r8,      &
       0.1000000E-03_r8,      &
       0.9050000E+00_r8,  0.8364300E+00_r8,  0.9293700E+00_r8,  0.9021600E+00_r8,      &
       0.6040900E+00_r8,  0.8712500E+00_r8,  0.8132000E+00_r8,  0.5681800E+00_r8,      &
       0.5681800E+00_r8,  0.9200800E+00_r8,  0.1000000E-03_r8,  0.8364300E+00_r8,      &
       0.1000000E-03_r8,      &
       0.9050000E+00_r8,  0.6967200E+00_r8,  0.8209400E+00_r8,  0.9126500E+00_r8,      &
       0.5854000E+00_r8,  0.7966000E+00_r8,  0.3943200E+00_r8,  0.8680600E+00_r8,      &
       0.7246400E+00_r8,  0.6970300E+00_r8,  0.1000000E-03_r8,  0.6967200E+00_r8,      &
       0.1000000E-03_r8,      &
       0.9050000E+00_r8,  0.3306900E+00_r8,  0.7123000E+00_r8,  0.8982800E+00_r8,      &
       0.4990000E+00_r8,  0.7654600E+00_r8,  0.4434600E+00_r8,  0.6505600E+00_r8,      &
       0.8403400E+00_r8,  0.7567000E-01_r8,  0.1000000E-03_r8,  0.3439200E+00_r8,      &
       0.1000000E-03_r8,      &
       0.9050000E+00_r8,  0.1656400E+00_r8,  0.6145700E+00_r8,  0.8548200E+00_r8,      &
       0.3834400E+00_r8,  0.6146100E+00_r8,  0.5434800E+00_r8,  0.5154600E+00_r8,      &
       0.8680600E+00_r8,  0.4512600E+00_r8,  0.1000000E-03_r8,  0.1785700E+00_r8,      &
       0.1000000E-03_r8,      &
       0.9050000E+00_r8,  0.1538000E-01_r8,  0.8599500E+00_r8,  0.8733600E+00_r8,      &
       0.2487600E+00_r8,  0.5086500E+00_r8,  0.5531000E+00_r8,  0.6302500E+00_r8,      &
       0.8875700E+00_r8,  0.4512600E+00_r8,  0.1000000E-03_r8,  0.1470600E+00_r8,      &
       0.1000000E-03_r8,      &
       0.9050000E+00_r8,  0.2564000E-01_r8,  0.8599500E+00_r8,  0.9132400E+00_r8,      &
       0.1984100E+00_r8,  0.7898900E+00_r8,  0.4975100E+00_r8,  0.7978700E+00_r8,      &
       0.9132400E+00_r8,  0.4512600E+00_r8,  0.1000000E-03_r8,  0.2083300E+00_r8,      &
       0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8/), (/13,12,2/) )
  REAL(KIND=r8), DIMENSION(13,12,2    ), PARAMETER :: vcover0 = RESHAPE( (/      &
       0.9800000E+00_r8,  0.7500000E+00_r8,  0.7500000E+00_r8,  0.7500000E+00_r8,      &
       0.5000000E+00_r8,  0.3000000E+00_r8,  0.9000000E+00_r8,  0.1000000E+00_r8,      &
       0.1000000E+00_r8,  0.3000000E+00_r8,  0.1000000E-04_r8,  0.7500000E-01_r8,      &
       0.1000000E-04_r8,      &
       0.9800000E+00_r8,  0.7500000E+00_r8,  0.7500000E+00_r8,  0.7500000E+00_r8,      &
       0.5000000E+00_r8,  0.3000000E+00_r8,  0.9000000E+00_r8,  0.1000000E+00_r8,      &
       0.1000000E+00_r8,  0.3000000E+00_r8,  0.1000000E-04_r8,  0.7500000E-01_r8,      &
       0.1000000E-04_r8,      &
       0.9800000E+00_r8,  0.7500000E+00_r8,  0.7500000E+00_r8,  0.7500000E+00_r8,      &
       0.5000000E+00_r8,  0.3000000E+00_r8,  0.9000000E+00_r8,  0.1000000E+00_r8,      &
       0.1000000E+00_r8,  0.3000000E+00_r8,  0.1000000E-04_r8,  0.7500000E-01_r8,      &
       0.1000000E-04_r8,      &
       0.9800000E+00_r8,  0.7500000E+00_r8,  0.7500000E+00_r8,  0.7500000E+00_r8,      &
       0.5000000E+00_r8,  0.3000000E+00_r8,  0.9000000E+00_r8,  0.1000000E+00_r8,      &
       0.1000000E+00_r8,  0.3000000E+00_r8,  0.1000000E-04_r8,  0.7500000E-01_r8,      &
       0.1000000E-04_r8,      &
       0.9800000E+00_r8,  0.7500000E+00_r8,  0.7500000E+00_r8,  0.7500000E+00_r8,      &
       0.5000000E+00_r8,  0.3000000E+00_r8,  0.9000000E+00_r8,  0.1000000E+00_r8,      &
       0.1000000E+00_r8,  0.3000000E+00_r8,  0.1000000E-04_r8,  0.7500000E-01_r8,      &
       0.1000000E-04_r8,      &
       0.9800000E+00_r8,  0.7500000E+00_r8,  0.7500000E+00_r8,  0.7500000E+00_r8,      &
       0.5000000E+00_r8,  0.3000000E+00_r8,  0.9000000E+00_r8,  0.1000000E+00_r8,      &
       0.1000000E+00_r8,  0.3000000E+00_r8,  0.1000000E-04_r8,  0.7500000E-01_r8,      &
       0.1000000E-04_r8,      &
       0.9800000E+00_r8,  0.7500000E+00_r8,  0.7500000E+00_r8,  0.7500000E+00_r8,      &
       0.5000000E+00_r8,  0.3000000E+00_r8,  0.9000000E+00_r8,  0.1000000E+00_r8,      &
       0.1000000E+00_r8,  0.3000000E+00_r8,  0.1000000E-04_r8,  0.7500000E-01_r8,      &
       0.1000000E-04_r8,      &
       0.9800000E+00_r8,  0.7500000E+00_r8,  0.7500000E+00_r8,  0.7500000E+00_r8,      &
       0.5000000E+00_r8,  0.3000000E+00_r8,  0.9000000E+00_r8,  0.1000000E+00_r8,      &
       0.1000000E+00_r8,  0.3000000E+00_r8,  0.1000000E-04_r8,  0.7500000E-01_r8,      &
       0.1000000E-04_r8,      &
       0.9800000E+00_r8,  0.7500000E+00_r8,  0.7500000E+00_r8,  0.7500000E+00_r8,      &
       0.5000000E+00_r8,  0.3000000E+00_r8,  0.9000000E+00_r8,  0.1000000E+00_r8,      &
       0.1000000E+00_r8,  0.3000000E+00_r8,  0.1000000E-04_r8,  0.7500000E-01_r8,      &
       0.1000000E-04_r8,      &
       0.9800000E+00_r8,  0.7500000E+00_r8,  0.7500000E+00_r8,  0.7500000E+00_r8,      &
       0.5000000E+00_r8,  0.3000000E+00_r8,  0.9000000E+00_r8,  0.1000000E+00_r8,      &
       0.1000000E+00_r8,  0.3000000E+00_r8,  0.1000000E-04_r8,  0.7500000E-01_r8,      &
       0.1000000E-04_r8,      &
       0.9800000E+00_r8,  0.7500000E+00_r8,  0.7500000E+00_r8,  0.7500000E+00_r8,      &
       0.5000000E+00_r8,  0.3000000E+00_r8,  0.9000000E+00_r8,  0.1000000E+00_r8,      &
       0.1000000E+00_r8,  0.3000000E+00_r8,  0.1000000E-04_r8,  0.7500000E-01_r8,      &
       0.1000000E-04_r8,      &
       0.9800000E+00_r8,  0.7500000E+00_r8,  0.7500000E+00_r8,  0.7500000E+00_r8,      &
       0.5000000E+00_r8,  0.3000000E+00_r8,  0.9000000E+00_r8,  0.1000000E+00_r8,      &
       0.1000000E+00_r8,  0.3000000E+00_r8,  0.1000000E-04_r8,  0.7500000E-01_r8,      &
       0.1000000E-04_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-04_r8,  0.1000000E-03_r8,      &
       0.1000000E-04_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-04_r8,  0.1000000E-03_r8,      &
       0.1000000E-04_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-04_r8,  0.1000000E-03_r8,      &
       0.1000000E-04_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-04_r8,  0.1000000E-03_r8,      &
       0.1000000E-04_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-04_r8,  0.1000000E-03_r8,      &
       0.1000000E-04_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-04_r8,  0.1000000E-03_r8,      &
       0.1000000E-04_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-04_r8,  0.1000000E-03_r8,      &
       0.1000000E-04_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-04_r8,  0.1000000E-03_r8,      &
       0.1000000E-04_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-04_r8,  0.1000000E-03_r8,      &
       0.1000000E-04_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-04_r8,  0.1000000E-03_r8,      &
       0.1000000E-04_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-04_r8,  0.1000000E-03_r8,      &
       0.1000000E-04_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-04_r8,  0.1000000E-03_r8,      &
       0.1000000E-04_r8/), (/13,12,2/) )
  REAL(KIND=r8), DIMENSION (13,  2  ), PARAMETER :: chil0 = RESHAPE( (/      &
       0.1000000E+00_r8,  0.2500000E+00_r8,  0.1300000E+00_r8,  0.1000000E-01_r8,      &
       0.1000000E-01_r8,  0.1000000E-01_r8, -0.3000000E+00_r8,  0.1000000E-01_r8,      &
       0.1000000E-01_r8,  0.2000000E+00_r8,  0.1000000E-01_r8, -0.2000000E-01_r8,      &
       0.1000000E-01_r8,      &
       0.1000000E+00_r8,  0.2500000E+00_r8,  0.1300000E+00_r8,  0.1000000E-01_r8,      &
       0.1000000E-01_r8, -0.3000000E+00_r8, -0.3000000E+00_r8, -0.3000000E+00_r8,      &
       0.1000000E-01_r8,  0.2000000E+00_r8,  0.1000000E-01_r8, -0.2000000E-01_r8,      &
       0.1000000E-01_r8/), (/13,2/) )
  REAL(KIND=r8), DIMENSION (13,   2,3  ), PARAMETER :: rstpar0 = RESHAPE( (/      &
       0.2335900E+04_r8,  0.9802230E+04_r8,  0.6335955E+04_r8,  0.2869680E+04_r8,      &
       0.2869680E+04_r8,  0.5665121E+05_r8,  0.2582010E+04_r8,  0.9398942E+05_r8,      &
       0.9398942E+05_r8,  0.9802230E+04_r8,  0.1000000E+04_r8,  0.7459000E+04_r8,      &
       0.1000000E+04_r8,      &
       0.2335900E+04_r8,  0.9802230E+04_r8,  0.6335955E+04_r8,  0.2869680E+04_r8,      &
       0.2869680E+04_r8,  0.2582010E+04_r8,  0.2582010E+04_r8,  0.2582010E+04_r8,      &
       0.1000000E+01_r8,  0.2582010E+04_r8,  0.1000000E+04_r8,  0.7459000E+04_r8,      &
       0.1000000E+04_r8,      &
       0.1450000E-01_r8,  0.1055000E+02_r8,  0.7120000E+01_r8,  0.3690000E+01_r8,      &
       0.3690000E+01_r8,  0.1083000E+02_r8,  0.1090000E+01_r8,  0.1000000E-01_r8,      &
       0.1000000E-01_r8,  0.1055000E+02_r8,  0.1000000E+04_r8,  0.5700000E+01_r8,      &
       0.1000000E+04_r8,      &
       0.1450000E-01_r8,  0.1055000E+02_r8,  0.7120000E+01_r8,  0.3690000E+01_r8,      &
       0.3690000E+01_r8,  0.1090000E+01_r8,  0.1090000E+01_r8,  0.1090000E+01_r8,      &
       0.1000000E+01_r8,  0.1090000E+01_r8,  0.1000000E+04_r8,  0.5700000E+01_r8,      &
       0.1000000E+04_r8,      &
       0.1534900E+03_r8,  0.1800000E+03_r8,  0.2065000E+03_r8,  0.2330000E+03_r8,      &
       0.2330000E+03_r8,  0.1650000E+03_r8,  0.1100000E+03_r8,  0.8550000E+03_r8,      &
       0.8550000E+03_r8,  0.1800000E+03_r8,  0.1000000E+04_r8,  0.2520000E+02_r8,      &
       0.1000000E+04_r8,      &
       0.1534900E+03_r8,  0.1800000E+03_r8,  0.2065000E+03_r8,  0.2330000E+03_r8,      &
       0.2330000E+03_r8,  0.1100000E+03_r8,  0.1100000E+03_r8,  0.1100000E+03_r8,      &
       0.1000000E+01_r8,  0.1100000E+03_r8,  0.1000000E+04_r8,  0.2520000E+02_r8,      &
       0.1000000E+04_r8/), (/13,2,3/) )
  REAL(KIND=r8), DIMENSION (13,  2  ), PARAMETER :: topt0 = RESHAPE( (/      &
       0.3030000E+03_r8,  0.3000000E+03_r8,  0.2940000E+03_r8,  0.2880000E+03_r8,      &
       0.2880000E+03_r8,  0.2970000E+03_r8,  0.3130000E+03_r8,  0.3150000E+03_r8,      &
       0.3150000E+03_r8,  0.3000000E+03_r8,  0.3100000E+03_r8,  0.3000000E+03_r8,      &
       0.3100000E+03_r8,      &
       0.3030000E+03_r8,  0.3000000E+03_r8,  0.2940000E+03_r8,  0.2880000E+03_r8,      &
       0.2880000E+03_r8,  0.3120000E+03_r8,  0.3130000E+03_r8,  0.3130000E+03_r8,      &
       0.3150000E+03_r8,  0.2890000E+03_r8,  0.3100000E+03_r8,  0.3000000E+03_r8,      &
       0.3100000E+03_r8/), (/13,2/) )
  REAL(KIND=r8), DIMENSION (13,  2  ), PARAMETER :: tl0 = RESHAPE( (/      &
       0.2730000E+03_r8,  0.2730000E+03_r8,  0.2700000E+03_r8,  0.2680000E+03_r8,      &
       0.2680000E+03_r8,  0.2730000E+03_r8,  0.2830000E+03_r8,  0.2830000E+03_r8,      &
       0.2830000E+03_r8,  0.2730000E+03_r8,  0.3000000E+03_r8,  0.2730000E+03_r8,      &
       0.3000000E+03_r8,      &
       0.2730000E+03_r8,  0.2730000E+03_r8,  0.2700000E+03_r8,  0.2680000E+03_r8,      &
       0.2680000E+03_r8,  0.2730000E+03_r8,  0.2830000E+03_r8,  0.2830000E+03_r8,      &
       0.2830000E+03_r8,  0.2730000E+03_r8,  0.3000000E+03_r8,  0.2730000E+03_r8,      &
       0.3000000E+03_r8/), (/13,2/) )
  REAL(KIND=r8), DIMENSION (13,  2  ), PARAMETER :: tu0 = RESHAPE( (/      &
       0.3180000E+03_r8,  0.3180000E+03_r8,  0.3150000E+03_r8,  0.3130000E+03_r8,      &
       0.3130000E+03_r8,  0.3230000E+03_r8,  0.3280000E+03_r8,  0.3230000E+03_r8,      &
       0.3230000E+03_r8,  0.3230000E+03_r8,  0.3200000E+03_r8,  0.3180000E+03_r8,      &
       0.3200000E+03_r8,      &
       0.3180000E+03_r8,  0.3180000E+03_r8,  0.3150000E+03_r8,  0.3130000E+03_r8,      &
       0.3130000E+03_r8,  0.3230000E+03_r8,  0.3280000E+03_r8,  0.3280000E+03_r8,      &
       0.3230000E+03_r8,  0.3090000E+03_r8,  0.3200000E+03_r8,  0.3150000E+03_r8,      &
       0.3200000E+03_r8/), (/13,2/) )
  REAL(KIND=r8), DIMENSION (13,  2  ), PARAMETER :: defac0 = RESHAPE( (/      &
       0.2730000E-01_r8,  0.3570000E-01_r8,  0.3400000E-01_r8,  0.3100000E-01_r8,      &
       0.3100000E-01_r8,  0.3570000E-01_r8,  0.2380000E-01_r8,  0.2750000E-01_r8,      &
       0.2750000E-01_r8,  0.2750000E-01_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8,      &
       0.2730000E-01_r8,  0.3570000E-01_r8,  0.3400000E-01_r8,  0.3100000E-01_r8,      &
       0.3100000E-01_r8,  0.2380000E-01_r8,  0.2380000E-01_r8,  0.2380000E-01_r8,      &
       0.2380000E-01_r8,  0.2380000E-01_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8/), (/13,2/) )
  REAL(KIND=r8), DIMENSION (13,  2  ), PARAMETER :: ph10 = RESHAPE( (/      &
       0.1200000E+01_r8,  0.5350000E+01_r8,  0.1920000E+01_r8,  0.3700000E+01_r8,      &
       0.7800000E+01_r8,  0.1800000E+01_r8,  0.1730000E+01_r8,  0.1920000E+01_r8,      &
       0.1390000E+01_r8,  0.9600000E+00_r8,  0.3000000E+01_r8,  0.1800000E+01_r8,      &
       0.3000000E+01_r8,      &
       0.1200000E+01_r8,  0.5350000E+01_r8,  0.1920000E+01_r8,  0.3700000E+01_r8,      &
       0.7800000E+01_r8,  0.1800000E+01_r8,  0.1730000E+01_r8,  0.1920000E+01_r8,      &
       0.1390000E+01_r8,  0.9600000E+00_r8,  0.3000000E+01_r8,  0.1800000E+01_r8,      &
       0.3000000E+01_r8/), (/13,2/) )
  REAL(KIND=r8), DIMENSION (13,  2  ), PARAMETER :: ph20 = RESHAPE( (/      &
       0.6250000E+01_r8,  0.5570000E+01_r8,  0.5730000E+01_r8,  0.5530000E+01_r8,      &
       0.5660000E+01_r8,  0.5670000E+01_r8,  0.5800000E+01_r8,  0.5610000E+01_r8,      &
       0.6370000E+01_r8,  0.5370000E+01_r8,  0.6000000E+01_r8,  0.5670000E+01_r8,      &
       0.6000000E+01_r8,      &
       0.6250000E+01_r8,  0.5570000E+01_r8,  0.5730000E+01_r8,  0.5530000E+01_r8,      &
       0.5660000E+01_r8,  0.5670000E+01_r8,  0.5800000E+01_r8,  0.5610000E+01_r8,      &
       0.6370000E+01_r8,  0.5370000E+01_r8,  0.6000000E+01_r8,  0.5670000E+01_r8,      &
       0.6000000E+01_r8/), (/13,2/) )
  REAL(KIND=r8), DIMENSION(13,12,2    ), PARAMETER :: zlt0 = RESHAPE( (/      &
       0.5014160E+01_r8,  0.3900000E+00_r8,  0.3456000E+01_r8,  0.6570000E+01_r8,      &
       0.4040000E+00_r8,  0.1766000E+01_r8,  0.7040000E+00_r8,  0.5780000E+00_r8,      &
       0.1076000E+01_r8,  0.3776000E+00_r8,  0.1000000E-03_r8,  0.4800000E-01_r8,      &
       0.1000000E-03_r8,      &
       0.5014160E+01_r8,  0.3900000E+00_r8,  0.3556000E+01_r8,  0.6870000E+01_r8,      &
       0.4040000E+00_r8,  0.1546000E+01_r8,  0.8040000E+00_r8,  0.5780000E+00_r8,      &
       0.9760000E+00_r8,  0.3776000E+00_r8,  0.1000000E-03_r8,  0.4800000E-01_r8,      &
       0.1000000E-03_r8,      &
       0.5014160E+01_r8,  0.6500000E+00_r8,  0.3956000E+01_r8,  0.7370000E+01_r8,      &
       0.4040000E+00_r8,  0.1416000E+01_r8,  0.9040000E+00_r8,  0.4480000E+00_r8,      &
       0.7760000E+00_r8,  0.3776000E+00_r8,  0.1000000E-03_r8,  0.6800000E-01_r8,      &
       0.1000000E-03_r8,      &
       0.5014160E+01_r8,  0.1580000E+01_r8,  0.4856000E+01_r8,  0.7570000E+01_r8,      &
       0.9040000E+00_r8,  0.1216000E+01_r8,  0.1004000E+01_r8,  0.2880000E+00_r8,      &
       0.2760000E+00_r8,  0.3776000E+00_r8,  0.1000000E-03_r8,  0.1580000E+00_r8,      &
       0.1000000E-03_r8,      &
       0.5014160E+01_r8,  0.3380000E+01_r8,  0.5456000E+01_r8,  0.7770000E+01_r8,      &
       0.1604000E+01_r8,  0.1186000E+01_r8,  0.1604000E+01_r8,  0.2580000E+00_r8,      &
       0.5760000E+00_r8,  0.3776000E+00_r8,  0.1000000E-03_r8,  0.3380000E+00_r8,      &
       0.1000000E-03_r8,      &
       0.5014160E+01_r8,  0.5080000E+01_r8,  0.6156000E+01_r8,  0.8070000E+01_r8,      &
       0.2304000E+01_r8,  0.1416000E+01_r8,  0.3304000E+01_r8,  0.2580000E+00_r8,      &
       0.1760000E+00_r8,  0.5076000E+00_r8,  0.1000000E-03_r8,  0.5080000E+00_r8,      &
       0.1000000E-03_r8,      &
       0.5014160E+01_r8,  0.5380000E+01_r8,  0.6456000E+01_r8,  0.7870000E+01_r8,      &
       0.4304000E+01_r8,  0.2606000E+01_r8,  0.4304000E+01_r8,  0.2580000E+00_r8,      &
       0.1760000E+00_r8,  0.1737600E+01_r8,  0.1000000E-03_r8,  0.5380000E+00_r8,      &
       0.1000000E-03_r8,      &
       0.5014160E+01_r8,  0.4880000E+01_r8,  0.6456000E+01_r8,  0.7670000E+01_r8,      &
       0.2904000E+01_r8,  0.5206000E+01_r8,  0.3804000E+01_r8,  0.8080000E+00_r8,      &
       0.2760000E+00_r8,  0.1937600E+01_r8,  0.1000000E-03_r8,  0.4880000E+00_r8,      &
       0.1000000E-03_r8,      &
       0.5014160E+01_r8,  0.3780000E+01_r8,  0.5756000E+01_r8,  0.7570000E+01_r8,      &
       0.2004000E+01_r8,  0.4556000E+01_r8,  0.1804000E+01_r8,  0.1508000E+01_r8,      &
       0.4760000E+00_r8,  0.1477600E+01_r8,  0.1000000E-03_r8,  0.3780000E+00_r8,      &
       0.1000000E-03_r8,      &
       0.5014160E+01_r8,  0.1630000E+01_r8,  0.4556000E+01_r8,  0.7370000E+01_r8,      &
       0.1304000E+01_r8,  0.3816000E+01_r8,  0.1104000E+01_r8,  0.1148000E+01_r8,      &
       0.5760000E+00_r8,  0.3776000E+00_r8,  0.1000000E-03_r8,  0.1680000E+00_r8,      &
       0.1000000E-03_r8,      &
       0.5014160E+01_r8,  0.6500000E+00_r8,  0.3256000E+01_r8,  0.6870000E+01_r8,      &
       0.8040000E+00_r8,  0.2806000E+01_r8,  0.9040000E+00_r8,  0.7480000E+00_r8,      &
       0.6760000E+00_r8,  0.3776000E+00_r8,  0.1000000E-03_r8,  0.6800000E-01_r8,      &
       0.1000000E-03_r8,      &
       0.5014160E+01_r8,  0.3900000E+00_r8,  0.3256000E+01_r8,  0.6570000E+01_r8,      &
       0.5040000E+00_r8,  0.1866000E+01_r8,  0.8040000E+00_r8,  0.5780000E+00_r8,      &
       0.8760000E+00_r8,  0.3776000E+00_r8,  0.1000000E-03_r8,  0.4800000E-01_r8,      &
       0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,  0.1000000E-03_r8,      &
       0.1000000E-03_r8/), (/13,12,2/) )
       !    REAL(KIND=r8), PARAMETER :: Z0SICE=0.0002e0_r8! 0.1011000E-01_r8
  REAL(KIND=r8), DIMENSION(13,12   ), PARAMETER :: z000 = RESHAPE( (/      &
       0.2652970E+01_r8,  0.5201000E+00_r8,  0.5706300E+00_r8,  0.1112210E+01_r8,      &
       0.6414000E+00_r8,  0.8427100E+00_r8,  0.7771000E-01_r8,  0.2446700E+00_r8,      &
       0.6559000E-01_r8,  0.7524000E-01_r8,  0.1118000E-01_r8,  0.1448500E+00_r8,      &
       0.0002e0_r8,      &
       0.2652970E+01_r8,  0.5201000E+00_r8,  0.5696600E+00_r8,  0.1102780E+01_r8,      &
       0.6414000E+00_r8,  0.8087800E+00_r8,  0.7779000E-01_r8,  0.2446700E+00_r8,      &
       0.6549000E-01_r8,  0.7524000E-01_r8,  0.1118000E-01_r8,  0.1448500E+00_r8,      &
       0.0002e0_r8,      &
       0.2652970E+01_r8,  0.6664900E+00_r8,  0.5656600E+00_r8,  0.1087660E+01_r8,      &
       0.6414000E+00_r8,  0.7875000E+00_r8,  0.7785000E-01_r8,  0.2272100E+00_r8,      &
       0.6521000E-01_r8,  0.7524000E-01_r8,  0.1118000E-01_r8,  0.1752100E+00_r8,      &
       0.0002e0_r8,      &
       0.2652970E+01_r8,  0.9105300E+00_r8,  0.5654400E+00_r8,  0.1081830E+01_r8,      &
       0.8633500E+00_r8,  0.7284100E+00_r8,  0.7788000E-01_r8,  0.1998800E+00_r8,      &
       0.6360000E-01_r8,  0.7524000E-01_r8,  0.1118000E-01_r8,  0.2871900E+00_r8,      &
       0.0002e0_r8,      &
       0.2652970E+01_r8,  0.1031200E+01_r8,  0.5592300E+00_r8,  0.1076120E+01_r8,      &
       0.9728300E+00_r8,  0.7284100E+00_r8,  0.7779000E-01_r8,  0.1998800E+00_r8,      &
       0.6480000E-01_r8,  0.7524000E-01_r8,  0.1118000E-01_r8,  0.4302000E+00_r8,      &
       0.0002e0_r8,      &
       0.2652970E+01_r8,  0.1043680E+01_r8,  0.5524400E+00_r8,  0.1067790E+01_r8,      &
       0.1005600E+01_r8,  0.7875000E+00_r8,  0.7712000E-01_r8,  0.1998800E+00_r8,      &
       0.6331000E-01_r8,  0.7575000E-01_r8,  0.1118000E-01_r8,  0.5087600E+00_r8,      &
       0.0002e0_r8,      &
       0.2652970E+01_r8,  0.1041940E+01_r8,  0.5497000E+00_r8,  0.1073310E+01_r8,      &
       0.9967700E+00_r8,  0.9266800E+00_r8,  0.7594000E-01_r8,  0.1998800E+00_r8,      &
       0.6331000E-01_r8,  0.7767000E-01_r8,  0.1118000E-01_r8,  0.5200300E+00_r8,      &
       0.0002e0_r8,      &
       0.2652970E+01_r8,  0.1037530E+01_r8,  0.5497000E+00_r8,  0.1078960E+01_r8,      &
       0.1011190E+01_r8,  0.9715300E+00_r8,  0.7658000E-01_r8,  0.2674000E+00_r8,      &
       0.6360000E-01_r8,  0.7782000E-01_r8,  0.1118000E-01_r8,  0.5009500E+00_r8,      &
       0.0002e0_r8,      &
       0.2652970E+01_r8,  0.1036510E+01_r8,  0.5562600E+00_r8,  0.1081830E+01_r8,      &
       0.9965000E+00_r8,  0.9658800E+00_r8,  0.7776000E-01_r8,  0.2923300E+00_r8,      &
       0.6446000E-01_r8,  0.7745000E-01_r8,  0.1118000E-01_r8,  0.4503800E+00_r8,      &
       0.0002e0_r8,      &
       0.2652970E+01_r8,  0.9170700E+00_r8,  0.5686600E+00_r8,  0.1087660E+01_r8,      &
       0.9386100E+00_r8,  0.9555100E+00_r8,  0.7790000E-01_r8,  0.2803400E+00_r8,      &
       0.6480000E-01_r8,  0.7524000E-01_r8,  0.1118000E-01_r8,  0.2973700E+00_r8,      &
       0.0002e0_r8,      &
       0.2652970E+01_r8,  0.6664900E+00_r8,  0.5725100E+00_r8,  0.1102780E+01_r8,      &
       0.8346400E+00_r8,  0.9204000E+00_r8,  0.7785000E-01_r8,  0.2580600E+00_r8,      &
       0.6510000E-01_r8,  0.7524000E-01_r8,  0.1118000E-01_r8,  0.1752100E+00_r8,      &
       0.0002e0_r8,      &
       0.2652970E+01_r8,  0.5201000E+00_r8,  0.5725100E+00_r8,  0.1112210E+01_r8,      &
       0.7049800E+00_r8,  0.8427100E+00_r8,  0.7779000E-01_r8,  0.2446700E+00_r8,      &
       0.6537000E-01_r8,  0.7524000E-01_r8,  0.1118000E-01_r8,  0.1448500E+00_r8,      &
       0.0002e0_r8/), (/13,12/) )

  REAL(KIND=r8), DIMENSION(13,12   ), PARAMETER :: d0 = RESHAPE( (/      &
       0.2737261E+02_r8,  0.1366377E+02_r8,  0.1813464E+02_r8,  0.1376361E+02_r8,      &
       0.9193320E+01_r8,  0.1390777E+02_r8,  0.2185200E+00_r8,  0.2812600E+01_r8,      &
       0.1638000E+00_r8,  0.1062900E+00_r8,  0.6000000E-04_r8,  0.6314240E+01_r8,      &
       0.4000000E-04_r8,      &
       0.2737261E+02_r8,  0.1366377E+02_r8,  0.1814677E+02_r8,  0.1380041E+02_r8,      &
       0.9193320E+01_r8,  0.1376090E+02_r8,  0.2265800E+00_r8,  0.2812600E+01_r8,      &
       0.1548100E+00_r8,  0.1062900E+00_r8,  0.6000000E-04_r8,  0.6314240E+01_r8,      &
       0.4000000E-04_r8,      &
       0.2737261E+02_r8,  0.1461883E+02_r8,  0.1819051E+02_r8,  0.1385740E+02_r8,      &
       0.9193320E+01_r8,  0.1367074E+02_r8,  0.2332800E+00_r8,  0.2662290E+01_r8,      &
       0.1343400E+00_r8,  0.1062900E+00_r8,  0.6000000E-04_r8,  0.7639520E+01_r8,      &
       0.4000000E-04_r8,      &
       0.2737261E+02_r8,  0.1569677E+02_r8,  0.1825890E+02_r8,  0.1387880E+02_r8,      &
       0.9903400E+01_r8,  0.1344527E+02_r8,  0.2389500E+00_r8,  0.2390910E+01_r8,      &
       0.6191000E-01_r8,  0.1062900E+00_r8,  0.6000000E-04_r8,  0.1070958E+02_r8,      &
       0.4000000E-04_r8,      &
       0.2737261E+02_r8,  0.1632865E+02_r8,  0.1829956E+02_r8,  0.1389946E+02_r8,      &
       0.1030010E+02_r8,  0.1344527E+02_r8,  0.2605400E+00_r8,  0.2390910E+01_r8,      &
       0.1096800E+00_r8,  0.1062900E+00_r8,  0.6000000E-04_r8,  0.1278272E+02_r8,      &
       0.4000000E-04_r8,      &
       0.2737261E+02_r8,  0.1662263E+02_r8,  0.1833903E+02_r8,  0.1392915E+02_r8,      &
       0.1053455E+02_r8,  0.1367074E+02_r8,  0.2988000E+00_r8,  0.2390910E+01_r8,      &
       0.5103000E-01_r8,  0.1229900E+00_r8,  0.6000000E-04_r8,  0.1356813E+02_r8,      &
       0.4000000E-04_r8,      &
       0.2737261E+02_r8,  0.1666297E+02_r8,  0.1835387E+02_r8,  0.1390953E+02_r8,      &
       0.1091967E+02_r8,  0.1425275E+02_r8,  0.3251800E+00_r8,  0.2390910E+01_r8,      &
       0.5103000E-01_r8,  0.2152100E+00_r8,  0.6000000E-04_r8,  0.1366182E+02_r8,      &
       0.4000000E-04_r8,      &
       0.2737261E+02_r8,  0.1660123E+02_r8,  0.1835387E+02_r8,  0.1388922E+02_r8,      &
       0.1068047E+02_r8,  0.1459719E+02_r8,  0.3130700E+00_r8,  0.2974600E+01_r8,      &
       0.6191000E-01_r8,  0.2289700E+00_r8,  0.6000000E-04_r8,  0.1349985E+02_r8,      &
       0.4000000E-04_r8,      &
       0.2737261E+02_r8,  0.1641343E+02_r8,  0.1831739E+02_r8,  0.1387880E+02_r8,      &
       0.1044517E+02_r8,  0.1452246E+02_r8,  0.2649800E+00_r8,  0.3137710E+01_r8,      &
       0.9547000E-01_r8,  0.1996100E+00_r8,  0.6000000E-04_r8,  0.1301951E+02_r8,      &
       0.4000000E-04_r8,      &
       0.2737261E+02_r8,  0.1572679E+02_r8,  0.1823553E+02_r8,  0.1385740E+02_r8,      &
       0.1016423E+02_r8,  0.1443002E+02_r8,  0.2438100E+00_r8,  0.3062460E+01_r8,      &
       0.1096800E+00_r8,  0.1062900E+00_r8,  0.6000000E-04_r8,  0.1090759E+02_r8,      &
       0.4000000E-04_r8,      &
       0.2737261E+02_r8,  0.1461883E+02_r8,  0.1810866E+02_r8,  0.1380041E+02_r8,      &
       0.9814290E+01_r8,  0.1422050E+02_r8,  0.2332800E+00_r8,  0.2907360E+01_r8,      &
       0.1225000E+00_r8,  0.1062900E+00_r8,  0.6000000E-04_r8,  0.7639520E+01_r8,      &
       0.4000000E-04_r8,      &
       0.2737261E+02_r8,  0.1366377E+02_r8,  0.1810866E+02_r8,  0.1376361E+02_r8,      &
       0.9417390E+01_r8,  0.1390777E+02_r8,  0.2265800E+00_r8,  0.2812600E+01_r8,      &
       0.1450200E+00_r8,  0.1062900E+00_r8,  0.6000000E-04_r8,  0.6314240E+01_r8,      &
       0.4000000E-04_r8/), (/13,12/) )
  REAL(KIND=r8), DIMENSION(13,12   ), PARAMETER :: z10 = RESHAPE( (/      &
       0.1000000E+01_r8,  0.1150000E+02_r8,  0.1600000E+02_r8,  0.8500000E+01_r8,      &
       0.7000000E+01_r8,  0.1000000E+02_r8,  0.1000000E+00_r8,  0.2000000E+01_r8,      &
       0.1000000E+00_r8,  0.1000000E+00_r8,  0.1000000E-01_r8,  0.1150000E+02_r8,      &
       0.1000000E-04_r8,      &
       0.1000000E+01_r8,  0.1150000E+02_r8,  0.1600000E+02_r8,  0.8500000E+01_r8,      &
       0.7000000E+01_r8,  0.1000000E+02_r8,  0.1000000E+00_r8,  0.2000000E+01_r8,      &
       0.1000000E+00_r8,  0.1000000E+00_r8,  0.1000000E-01_r8,  0.1150000E+02_r8,      &
       0.1000000E-04_r8,      &
       0.1000000E+01_r8,  0.1150000E+02_r8,  0.1600000E+02_r8,  0.8500000E+01_r8,      &
       0.7000000E+01_r8,  0.1000000E+02_r8,  0.1000000E+00_r8,  0.2000000E+01_r8,      &
       0.1000000E+00_r8,  0.1000000E+00_r8,  0.1000000E-01_r8,  0.1150000E+02_r8,      &
       0.1000000E-04_r8,      &
       0.1000000E+01_r8,  0.1150000E+02_r8,  0.1600000E+02_r8,  0.8500000E+01_r8,      &
       0.7000000E+01_r8,  0.1000000E+02_r8,  0.1000000E+00_r8,  0.2000000E+01_r8,      &
       0.1000000E+00_r8,  0.1000000E+00_r8,  0.1000000E-01_r8,  0.1150000E+02_r8,      &
       0.1000000E-04_r8,      &
       0.1000000E+01_r8,  0.1150000E+02_r8,  0.1600000E+02_r8,  0.8500000E+01_r8,      &
       0.7000000E+01_r8,  0.1000000E+02_r8,  0.1000000E+00_r8,  0.2000000E+01_r8,      &
       0.1000000E+00_r8,  0.1000000E+00_r8,  0.1000000E-01_r8,  0.1150000E+02_r8,      &
       0.1000000E-04_r8,      &
       0.1000000E+01_r8,  0.1150000E+02_r8,  0.1600000E+02_r8,  0.8500000E+01_r8,      &
       0.7000000E+01_r8,  0.1000000E+02_r8,  0.1000000E+00_r8,  0.2000000E+01_r8,      &
       0.1000000E+00_r8,  0.1000000E+00_r8,  0.1000000E-01_r8,  0.1150000E+02_r8,      &
       0.1000000E-04_r8,      &
       0.1000000E+01_r8,  0.1150000E+02_r8,  0.1600000E+02_r8,  0.8500000E+01_r8,      &
       0.7000000E+01_r8,  0.1000000E+02_r8,  0.1000000E+00_r8,  0.2000000E+01_r8,      &
       0.1000000E+00_r8,  0.1000000E+00_r8,  0.1000000E-01_r8,  0.1150000E+02_r8,      &
       0.1000000E-04_r8,      &
       0.1000000E+01_r8,  0.1150000E+02_r8,  0.1600000E+02_r8,  0.8500000E+01_r8,      &
       0.7000000E+01_r8,  0.1000000E+02_r8,  0.1000000E+00_r8,  0.2000000E+01_r8,      &
       0.1000000E+00_r8,  0.1000000E+00_r8,  0.1000000E-01_r8,  0.1150000E+02_r8,      &
       0.1000000E-04_r8,      &
       0.1000000E+01_r8,  0.1150000E+02_r8,  0.1600000E+02_r8,  0.8500000E+01_r8,      &
       0.7000000E+01_r8,  0.1000000E+02_r8,  0.1000000E+00_r8,  0.2000000E+01_r8,      &
       0.1000000E+00_r8,  0.1000000E+00_r8,  0.1000000E-01_r8,  0.1150000E+02_r8,      &
       0.1000000E-04_r8,      &
       0.1000000E+01_r8,  0.1150000E+02_r8,  0.1600000E+02_r8,  0.8500000E+01_r8,      &
       0.7000000E+01_r8,  0.1000000E+02_r8,  0.1000000E+00_r8,  0.2000000E+01_r8,      &
       0.1000000E+00_r8,  0.1000000E+00_r8,  0.1000000E-01_r8,  0.1150000E+02_r8,      &
       0.1000000E-04_r8,      &
       0.1000000E+01_r8,  0.1150000E+02_r8,  0.1600000E+02_r8,  0.8500000E+01_r8,      &
       0.7000000E+01_r8,  0.1000000E+02_r8,  0.1000000E+00_r8,  0.2000000E+01_r8,      &
       0.1000000E+00_r8,  0.1000000E+00_r8,  0.1000000E-01_r8,  0.1150000E+02_r8,      &
       0.1000000E-04_r8,      &
       0.1000000E+01_r8,  0.1150000E+02_r8,  0.1600000E+02_r8,  0.8500000E+01_r8,      &
       0.7000000E+01_r8,  0.1000000E+02_r8,  0.1000000E+00_r8,  0.2000000E+01_r8,      &
       0.1000000E+00_r8,  0.1000000E+00_r8,  0.1000000E-01_r8,  0.1150000E+02_r8,      &
       0.1000000E-04_r8/), (/13,12/) )
  REAL(KIND=r8), DIMENSION(13,12   ), PARAMETER :: z20 = RESHAPE( (/      &
       0.3500000E+02_r8,  0.2000000E+02_r8,  0.2000000E+02_r8,  0.1700000E+02_r8,      &
       0.1400000E+02_r8,  0.1800000E+02_r8,  0.6000000E+00_r8,  0.5000000E+01_r8,      &
       0.5000000E+00_r8,  0.6000000E+00_r8,  0.1000000E+00_r8,  0.2000000E+02_r8,      &
       0.1000000E+00_r8,      &
       0.3500000E+02_r8,  0.2000000E+02_r8,  0.2000000E+02_r8,  0.1700000E+02_r8,      &
       0.1400000E+02_r8,  0.1800000E+02_r8,  0.6000000E+00_r8,  0.5000000E+01_r8,      &
       0.5000000E+00_r8,  0.6000000E+00_r8,  0.1000000E+00_r8,  0.2000000E+02_r8,      &
       0.1000000E+00_r8,      &
       0.3500000E+02_r8,  0.2000000E+02_r8,  0.2000000E+02_r8,  0.1700000E+02_r8,      &
       0.1400000E+02_r8,  0.1800000E+02_r8,  0.6000000E+00_r8,  0.5000000E+01_r8,      &
       0.5000000E+00_r8,  0.6000000E+00_r8,  0.1000000E+00_r8,  0.2000000E+02_r8,      &
       0.1000000E+00_r8,      &
       0.3500000E+02_r8,  0.2000000E+02_r8,  0.2000000E+02_r8,  0.1700000E+02_r8,      &
       0.1400000E+02_r8,  0.1800000E+02_r8,  0.6000000E+00_r8,  0.5000000E+01_r8,      &
       0.5000000E+00_r8,  0.6000000E+00_r8,  0.1000000E+00_r8,  0.2000000E+02_r8,      &
       0.1000000E+00_r8,      &
       0.3500000E+02_r8,  0.2000000E+02_r8,  0.2000000E+02_r8,  0.1700000E+02_r8,      &
       0.1400000E+02_r8,  0.1800000E+02_r8,  0.6000000E+00_r8,  0.5000000E+01_r8,      &
       0.5000000E+00_r8,  0.6000000E+00_r8,  0.1000000E+00_r8,  0.2000000E+02_r8,      &
       0.1000000E+00_r8,      &
       0.3500000E+02_r8,  0.2000000E+02_r8,  0.2000000E+02_r8,  0.1700000E+02_r8,      &
       0.1400000E+02_r8,  0.1800000E+02_r8,  0.6000000E+00_r8,  0.5000000E+01_r8,      &
       0.5000000E+00_r8,  0.6000000E+00_r8,  0.1000000E+00_r8,  0.2000000E+02_r8,      &
       0.1000000E+00_r8,      &
       0.3500000E+02_r8,  0.2000000E+02_r8,  0.2000000E+02_r8,  0.1700000E+02_r8,      &
       0.1400000E+02_r8,  0.1800000E+02_r8,  0.6000000E+00_r8,  0.5000000E+01_r8,      &
       0.5000000E+00_r8,  0.6000000E+00_r8,  0.1000000E+00_r8,  0.2000000E+02_r8,      &
       0.1000000E+00_r8,      &
       0.3500000E+02_r8,  0.2000000E+02_r8,  0.2000000E+02_r8,  0.1700000E+02_r8,      &
       0.1400000E+02_r8,  0.1800000E+02_r8,  0.6000000E+00_r8,  0.5000000E+01_r8,      &
       0.5000000E+00_r8,  0.6000000E+00_r8,  0.1000000E+00_r8,  0.2000000E+02_r8,      &
       0.1000000E+00_r8,      &
       0.3500000E+02_r8,  0.2000000E+02_r8,  0.2000000E+02_r8,  0.1700000E+02_r8,      &
       0.1400000E+02_r8,  0.1800000E+02_r8,  0.6000000E+00_r8,  0.5000000E+01_r8,      &
       0.5000000E+00_r8,  0.6000000E+00_r8,  0.1000000E+00_r8,  0.2000000E+02_r8,      &
       0.1000000E+00_r8,      &
       0.3500000E+02_r8,  0.2000000E+02_r8,  0.2000000E+02_r8,  0.1700000E+02_r8,      &
       0.1400000E+02_r8,  0.1800000E+02_r8,  0.6000000E+00_r8,  0.5000000E+01_r8,      &
       0.5000000E+00_r8,  0.6000000E+00_r8,  0.1000000E+00_r8,  0.2000000E+02_r8,      &
       0.1000000E+00_r8,      &
       0.3500000E+02_r8,  0.2000000E+02_r8,  0.2000000E+02_r8,  0.1700000E+02_r8,      &
       0.1400000E+02_r8,  0.1800000E+02_r8,  0.6000000E+00_r8,  0.5000000E+01_r8,      &
       0.5000000E+00_r8,  0.6000000E+00_r8,  0.1000000E+00_r8,  0.2000000E+02_r8,      &
       0.1000000E+00_r8,      &
       0.3500000E+02_r8,  0.2000000E+02_r8,  0.2000000E+02_r8,  0.1700000E+02_r8,      &
       0.1400000E+02_r8,  0.1800000E+02_r8,  0.6000000E+00_r8,  0.5000000E+01_r8,      &
       0.5000000E+00_r8,  0.6000000E+00_r8,  0.1000000E+00_r8,  0.2000000E+02_r8,      &
       0.1000000E+00_r8/), (/13,12/) )

  REAL(KIND=r8), DIMENSION(13,12   ), PARAMETER :: rdc0 = RESHAPE( (/      &
       0.2858700E+03_r8,  0.2113200E+03_r8,  0.2985200E+03_r8,  0.5654100E+03_r8,      &
       0.1852000E+03_r8,  0.2301300E+03_r8,  0.2443000E+02_r8,  0.1036000E+03_r8,      &
       0.2311000E+02_r8,  0.2286000E+02_r8,  0.2376000E+02_r8,  0.1949000E+03_r8,      &
       0.2850000E+02_r8,      &
       0.2858700E+03_r8,  0.2113200E+03_r8,  0.3013500E+03_r8,  0.5870500E+03_r8,      &
       0.1852000E+03_r8,  0.2244200E+03_r8,  0.2463000E+02_r8,  0.1036000E+03_r8,      &
       0.2294000E+02_r8,  0.2286000E+02_r8,  0.2376000E+02_r8,  0.1949000E+03_r8,      &
       0.2850000E+02_r8,      &
       0.2858700E+03_r8,  0.2187800E+03_r8,  0.3124600E+03_r8,  0.6234600E+03_r8,      &
       0.1852000E+03_r8,  0.2215700E+03_r8,  0.2480000E+02_r8,  0.1023500E+03_r8,      &
       0.2262000E+02_r8,  0.2286000E+02_r8,  0.2376000E+02_r8,  0.1964400E+03_r8,      &
       0.2850000E+02_r8,      &
       0.2858700E+03_r8,  0.2434000E+03_r8,  0.3312300E+03_r8,  0.6381300E+03_r8,      &
       0.2048700E+03_r8,  0.2164100E+03_r8,  0.2496000E+02_r8,  0.1007200E+03_r8,      &
       0.2189000E+02_r8,  0.2286000E+02_r8,  0.2376000E+02_r8,  0.2014400E+03_r8,      &
       0.2850000E+02_r8,      &
       0.2858700E+03_r8,  0.2948700E+03_r8,  0.3458300E+03_r8,  0.6528600E+03_r8,      &
       0.2330100E+03_r8,  0.2164100E+03_r8,  0.2572000E+02_r8,  0.1007200E+03_r8,      &
       0.2230000E+02_r8,  0.2286000E+02_r8,  0.2376000E+02_r8,  0.2071300E+03_r8,      &
       0.2850000E+02_r8,      &
       0.2858700E+03_r8,  0.3459000E+03_r8,  0.3619400E+03_r8,  0.6750500E+03_r8,      &
       0.2620800E+03_r8,  0.2215700E+03_r8,  0.2774000E+02_r8,  0.1007200E+03_r8,      &
       0.2182000E+02_r8,  0.2301000E+02_r8,  0.2376000E+02_r8,  0.2107900E+03_r8,      &
       0.2850000E+02_r8,      &
       0.2858700E+03_r8,  0.3551800E+03_r8,  0.3685400E+03_r8,  0.6602400E+03_r8,      &
       0.3443100E+03_r8,  0.2500700E+03_r8,  0.3006000E+02_r8,  0.1007200E+03_r8,      &
       0.2182000E+02_r8,  0.2436000E+02_r8,  0.2376000E+02_r8,  0.2113100E+03_r8,      &
       0.2850000E+02_r8,      &
       0.2858700E+03_r8,  0.3418400E+03_r8,  0.3685400E+03_r8,  0.6454900E+03_r8,      &
       0.2870900E+03_r8,  0.2885700E+03_r8,  0.2886000E+02_r8,  0.1053000E+03_r8,      &
       0.2189000E+02_r8,  0.2469000E+02_r8,  0.2376000E+02_r8,  0.2104200E+03_r8,      &
       0.2850000E+02_r8,      &
       0.2858700E+03_r8,  0.3072200E+03_r8,  0.3528500E+03_r8,  0.6381300E+03_r8,      &
       0.2495800E+03_r8,  0.2780300E+03_r8,  0.2590000E+02_r8,  0.1079400E+03_r8,      &
       0.2216000E+02_r8,  0.2404000E+02_r8,  0.2376000E+02_r8,  0.2081500E+03_r8,      &
       0.2850000E+02_r8,      &
       0.2858700E+03_r8,  0.2448400E+03_r8,  0.3236500E+03_r8,  0.6231300E+03_r8,      &
       0.2211200E+03_r8,  0.2668400E+03_r8,  0.2511000E+02_r8,  0.1065900E+03_r8,      &
       0.2230000E+02_r8,  0.2286000E+02_r8,  0.2376000E+02_r8,  0.2018800E+03_r8,      &
       0.2850000E+02_r8,      &
       0.2858700E+03_r8,  0.2187800E+03_r8,  0.2927900E+03_r8,  0.5870500E+03_r8,      &
       0.2008900E+03_r8,  0.2475700E+03_r8,  0.2480000E+02_r8,  0.1044900E+03_r8,      &
       0.2244000E+02_r8,  0.2286000E+02_r8,  0.2376000E+02_r8,  0.1964400E+03_r8,      &
       0.2850000E+02_r8,      &
       0.2858700E+03_r8,  0.2113200E+03_r8,  0.2927900E+03_r8,  0.5654100E+03_r8,      &
       0.1892600E+03_r8,  0.2301300E+03_r8,  0.2464000E+02_r8,  0.1036000E+03_r8,      &
       0.2277000E+02_r8,  0.2286000E+02_r8,  0.2376000E+02_r8,  0.1949000E+03_r8,      &
       0.2850000E+02_r8/), (/13,12/) )
  REAL(KIND=r8), DIMENSION(13,12   ), PARAMETER :: rbc0 = RESHAPE( (/      &
       0.5430000E+01_r8,  0.6936000E+02_r8,  0.8590000E+01_r8,  0.8800000E+00_r8,      &
       0.7850000E+01_r8,  0.2661000E+02_r8,  0.2207000E+02_r8,  0.2188000E+02_r8,      &
       0.1761000E+02_r8,  0.4351000E+02_r8,  0.3592951E+05_r8,  0.5600000E+03_r8,      &
       0.3546177E+05_r8,      &
       0.5430000E+01_r8,  0.6936000E+02_r8,  0.8450000E+01_r8,  0.8600000E+00_r8,      &
       0.7850000E+01_r8,  0.3044000E+02_r8,  0.2053000E+02_r8,  0.2188000E+02_r8,      &
       0.1942000E+02_r8,  0.4351000E+02_r8,  0.3592951E+05_r8,  0.5600000E+03_r8,      &
       0.3546177E+05_r8,      &
       0.5430000E+01_r8,  0.4257000E+02_r8,  0.7980000E+01_r8,  0.8400000E+00_r8,      &
       0.7850000E+01_r8,  0.3295000E+02_r8,  0.1934000E+02_r8,  0.2673000E+02_r8,      &
       0.2446000E+02_r8,  0.4351000E+02_r8,  0.3592951E+05_r8,  0.4019700E+03_r8,      &
       0.3546177E+05_r8,      &
       0.5430000E+01_r8,  0.1897000E+02_r8,  0.7180000E+01_r8,  0.8300000E+00_r8,      &
       0.3810000E+01_r8,  0.4003000E+02_r8,  0.1838000E+02_r8,  0.3712000E+02_r8,      &
       0.6928000E+02_r8,  0.4351000E+02_r8,  0.3592951E+05_r8,  0.1855200E+03_r8,      &
       0.3546177E+05_r8,      &
       0.5430000E+01_r8,  0.1035000E+02_r8,  0.6810000E+01_r8,  0.8200000E+00_r8,      &
       0.2400000E+01_r8,  0.4003000E+02_r8,  0.1516000E+02_r8,  0.3712000E+02_r8,      &
       0.3303000E+02_r8,  0.4351000E+02_r8,  0.3592951E+05_r8,  0.9801000E+02_r8,      &
       0.3546177E+05_r8,      &
       0.5430000E+01_r8,  0.7880000E+01_r8,  0.6480000E+01_r8,  0.8100000E+00_r8,      &
       0.1860000E+01_r8,  0.3295000E+02_r8,  0.1068000E+02_r8,  0.3712000E+02_r8,      &
       0.8702000E+02_r8,  0.3568000E+02_r8,  0.3592951E+05_r8,  0.7224000E+02_r8,      &
       0.3546177E+05_r8,      &
       0.5430000E+01_r8,  0.7610000E+01_r8,  0.6360000E+01_r8,  0.8200000E+00_r8,      &
       0.1290000E+01_r8,  0.1870000E+02_r8,  0.8300000E+01_r8,  0.3712000E+02_r8,      &
       0.8702000E+02_r8,  0.1449000E+02_r8,  0.3592951E+05_r8,  0.6938000E+02_r8,      &
       0.3546177E+05_r8,      &
       0.5430000E+01_r8,  0.8090000E+01_r8,  0.6360000E+01_r8,  0.8300000E+00_r8,      &
       0.1600000E+01_r8,  0.1318000E+02_r8,  0.9330000E+01_r8,  0.1722000E+02_r8,      &
       0.6928000E+02_r8,  0.1281000E+02_r8,  0.3592951E+05_r8,  0.7434000E+02_r8,      &
       0.3546177E+05_r8,      &
       0.5430000E+01_r8,  0.9570000E+01_r8,  0.6660000E+01_r8,  0.8300000E+00_r8,      &
       0.2040000E+01_r8,  0.1420000E+02_r8,  0.1457000E+02_r8,  0.1317000E+02_r8,      &
       0.4003000E+02_r8,  0.1669000E+02_r8,  0.3592951E+05_r8,  0.8988000E+02_r8,      &
       0.3546177E+05_r8,      &
       0.5430000E+01_r8,  0.1847000E+02_r8,  0.7400000E+01_r8,  0.8400000E+00_r8,      &
       0.2820000E+01_r8,  0.1559000E+02_r8,  0.1760000E+02_r8,  0.1497000E+02_r8,      &
       0.3303000E+02_r8,  0.4351000E+02_r8,  0.3592951E+05_r8,  0.1757600E+03_r8,      &
       0.3546177E+05_r8,      &
       0.5430000E+01_r8,  0.4257000E+02_r8,  0.8880000E+01_r8,  0.8600000E+00_r8,      &
       0.4210000E+01_r8,  0.1933000E+02_r8,  0.1934000E+02_r8,  0.1906000E+02_r8,      &
       0.2810000E+02_r8,  0.4351000E+02_r8,  0.3592951E+05_r8,  0.4019700E+03_r8,      &
       0.3546177E+05_r8,      &
       0.5430000E+01_r8,  0.6936000E+02_r8,  0.8880000E+01_r8,  0.8800000E+00_r8,      &
       0.6400000E+01_r8,  0.2661000E+02_r8,  0.2053000E+02_r8,  0.2188000E+02_r8,      &
       0.2165000E+02_r8,  0.4351000E+02_r8,  0.3592951E+05_r8,  0.5600000E+03_r8,      &
       0.3546177E+05_r8/), (/13,12/) )
  REAL(KIND=r8), DIMENSION(13,2   ), PARAMETER :: rootd0 = RESHAPE( (/      &
       0.1000000E+01_r8,  0.1000000E+01_r8,  0.1000000E+01_r8,  0.5000000E+00_r8,      &
       0.5000000E+00_r8,  0.5000000E+00_r8,  0.5000000E+00_r8,  0.5000000E+00_r8,      &
       0.5000000E+00_r8,  0.2000000E+00_r8,  0.1000000E+00_r8,  0.1000000E+01_r8,      &
       0.2100000E+01_r8,      &
       0.1000000E+01_r8,  0.1000000E+01_r8,  0.1000000E+01_r8,  0.5000000E+00_r8,      &
       0.5000000E+00_r8,  0.5000000E+00_r8,  0.5000000E+00_r8,  0.5000000E+00_r8,      &
       0.5000000E+00_r8,  0.2000000E+00_r8,  0.1000000E+00_r8,  0.1000000E+01_r8,      &
       0.2100000E+01_r8/), (/13,2/) )
  REAL(KIND=r8), DIMENSION(13,3   ), PARAMETER :: soref0 = RESHAPE( (/      &
       0.1100000E+00_r8,  0.1100000E+00_r8,  0.1100000E+00_r8,  0.1100000E+00_r8,      &
       0.1100000E+00_r8,  0.1100000E+00_r8,  0.1000000E+00_r8,  0.1000000E+00_r8,      &
       0.3000000E+00_r8,  0.1000000E+00_r8,  0.3000000E+00_r8,  0.1000000E+00_r8,      &
       0.1000000E+00_r8,      &
       0.2250000E+00_r8,  0.2250000E+00_r8,  0.2250000E+00_r8,  0.2250000E+00_r8,      &
       0.2250000E+00_r8,  0.2250000E+00_r8,  0.2000000E+00_r8,  0.2000000E+00_r8,      &
       0.3500000E+00_r8,  0.2000000E+00_r8,  0.3500000E+00_r8,  0.1500000E+00_r8,      &
       0.1500000E+00_r8,      &
       0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,  0.0000000E+00_r8,      &
       0.0000000E+00_r8/), (/13,3/) )
  REAL(KIND=r8), DIMENSION(13   ), PARAMETER :: bee0 = RESHAPE( (/      &
       0.7120000E+01_r8,  0.7120000E+01_r8,  0.7120000E+01_r8,  0.7120000E+01_r8,      &
       0.7120000E+01_r8,  0.7120000E+01_r8,  0.7120000E+01_r8,  0.4050000E+01_r8,      &
       0.4050000E+01_r8,  0.7120000E+01_r8,  0.4050000E+01_r8,  0.7797000E+01_r8,      &
       0.4804000E+01_r8/), (/13/) )
  REAL(KIND=r8), DIMENSION(13   ), PARAMETER :: phsat0 = RESHAPE( (/      &
       -0.8600000E-01_r8, -0.8600000E-01_r8, -0.8600000E-01_r8, -0.8600000E-01_r8,      &
       -0.8600000E-01_r8, -0.8600000E-01_r8, -0.8600000E-01_r8, -0.3500000E-01_r8,      &
       -0.3500000E-01_r8, -0.8600000E-01_r8, -0.3500000E-01_r8, -0.1980000E+00_r8,      &
       -0.1670000E+00_r8/), (/13/) )
  REAL(KIND=r8), DIMENSION(13   ), PARAMETER :: poros0 = RESHAPE( (/      &
       0.4200000E+00_r8,  0.4200000E+00_r8,  0.4200000E+00_r8,  0.4200000E+00_r8,      &
       0.4200000E+00_r8,  0.4200000E+00_r8,  0.4200000E+00_r8,  0.4352000E+00_r8,      &
       0.4352000E+00_r8,  0.4200000E+00_r8,  0.4352000E+00_r8,  0.4577000E+00_r8,      &
       0.4352000E+00_r8/), (/13/) )
  REAL(KIND=r8), DIMENSION(13   ), PARAMETER :: satco0 = RESHAPE( (/      &
       0.2000000E-04_r8,  0.2000000E-04_r8,  0.2000000E-04_r8,  0.2000000E-04_r8,      &
       0.2000000E-04_r8,  0.2000000E-04_r8,  0.2000000E-04_r8,  0.1760000E-03_r8,      &
       0.1760000E-03_r8,  0.2000000E-04_r8,  0.1760000E-03_r8,  0.3500000E-05_r8,      &
       0.7620000E-04_r8/), (/13/) )
  REAL(KIND=r8), DIMENSION(13   ), PARAMETER :: slope0 = RESHAPE( (/      &
       0.1736000E+00_r8,  0.1736000E+00_r8,  0.1736000E+00_r8,  0.1736000E+00_r8,      &
       0.1736000E+00_r8,  0.1736000E+00_r8,  0.1736000E+00_r8,  0.8720000E-01_r8,      &
       0.8720000E-01_r8,  0.1736000E+00_r8,  0.8720000E-01_r8,  0.3420000E+00_r8,      &
       0.8720000E-01_r8/), (/13/) )
  REAL(KIND=r8), DIMENSION(13,3   ), PARAMETER :: depth0 = RESHAPE( (/      &
       0.2000000E-01_r8,  0.2000000E-01_r8,  0.2000000E-01_r8,  0.2000000E-01_r8,      &
       0.2000000E-01_r8,  0.2000000E-01_r8,  0.2000000E-01_r8,  0.2000000E-01_r8,      &
       0.2000000E-01_r8,  0.2000000E-01_r8,  0.2000000E-01_r8,  0.2000000E-01_r8,      &
       0.1000000E+01_r8,      &
       0.1480000E+01_r8,  0.1480000E+01_r8,  0.1480000E+01_r8,  0.1480000E+01_r8,      &
       0.1480000E+01_r8,  0.1480000E+01_r8,  0.4700000E+00_r8,  0.4700000E+00_r8,      &
       0.4700000E+00_r8,  0.1700000E+00_r8,  0.1700000E+00_r8,  0.1480000E+01_r8,      &
       0.1000000E+01_r8,      &
       0.2000000E+01_r8,  0.2000000E+01_r8,  0.2000000E+01_r8,  0.2000000E+01_r8,      &
       0.2000000E+01_r8,  0.2000000E+01_r8,  0.1000000E+01_r8,  0.1000000E+01_r8,      &
       0.1000000E+01_r8,  0.1000000E+01_r8,  0.3000000E+00_r8,  0.2000000E+01_r8,      &
       0.1000000E+01_r8/), (/13,3/) )


  REAL(KIND=r8)   , PARAMETER :: TD_DEPTH(13)=(/1.5_r8, 1.5_r8, 1.5_r8, 1.5_r8, 1.5_r8, &
       1.5_r8, 1.0_r8, 1.0_r8, 1.0_r8, 0.5_r8, &
       0.5_r8, 1.5_r8, 1.5_r8/)
  REAL (KIND=r8), PARAMETER   :: tice   =      271.16e0_r8! constant tice

  !------------------------------------------------------------------------
  REAL(KIND=r8),PUBLIC   , ALLOCATABLE :: TC_SeaIce   (:,:)
  REAL(KIND=r8),PUBLIC   , ALLOCATABLE :: TGS_SeaIce  (:,:)
  REAL(KIND=r8),PUBLIC   , ALLOCATABLE :: TD_SeaIce   (:,:)
  REAL(KIND=r8),PUBLIC   , ALLOCATABLE :: TA_SeaIce   (:,:)
  REAL(KIND=r8),PUBLIC   , ALLOCATABLE :: SNOA_SeaIce (:,:)
  REAL(KIND=r8),PUBLIC   , ALLOCATABLE :: SNOB_SeaIce (:,:)

  PUBLIC :: InitSeaIce
  PUBLIC :: GetIceOceanAlb
  PUBLIC :: GetFluxSeaIceModel
CONTAINS
  SUBROUTINE InitSeaIce(ibMax,jbMax,kMax,ibMaxPerJB,fgtmp,RESTART)
    IMPLICIT NONE
    INTEGER, INTENT(IN   ) :: ibMax
    INTEGER, INTENT(IN   ) :: jbMax
    INTEGER, INTENT(IN   ) :: kMax
    INTEGER, INTENT(IN   ) :: ibMaxPerJB(jbMax)
    REAL(KIND=r8)   , INTENT(IN   ) :: fgtmp(ibMax,kMax,jbMax)
    LOGICAL         , INTENT(IN   ) ::  RESTART

    REAL(KIND=r8)    :: STLEV1
    REAL(KIND=r8)    :: STLEV2
    INTEGER :: ITYPE ,ib,jb
    REAL(KIND=r8)    :: DEPTH 
    ALLOCATE(TC_SeaIce   (ibMax,jbMax)); TC_SeaIce    =0.0_r8  
    ALLOCATE(TGS_SeaIce  (ibMax,jbMax)); TGS_SeaIce   =0.0_r8  
    ALLOCATE(TD_SeaIce   (ibMax,jbMax)); TD_SeaIce    =0.0_r8  
    ALLOCATE(TA_SeaIce   (ibMax,jbMax)); TA_SeaIce    =0.0_r8  
    ALLOCATE(SNOA_SeaIce (ibMax,jbMax)); SNOA_SeaIce  =0.0_r8  
    ALLOCATE(SNOB_SeaIce (ibMax,jbMax)); SNOB_SeaIce  =0.0_r8  
    IF(.not.RESTART)THEN
       DO jb=1,jbMax
          DO ib=1,ibMaxPerJB(jb)
             TC_SeaIce  (ib,jb)=fgtmp(ib,1,jb)
             TGS_SeaIce (ib,jb)=fgtmp(ib,1,jb)
             TD_SeaIce  (ib,jb)=fgtmp(ib,1,jb)
             TA_SeaIce  (ib,jb)=fgtmp(ib,1,jb)
             SNOA_SeaIce(ib,jb)=0.0_r8
             SNOB_SeaIce(ib,jb)=0.0_r8
          END DO
       END DO
       !
       !crr ------------ STC initialization ------------------------------------
       !      IF (ITIME.EQ.1) THEN
       STLEV1=0.05_r8    ! half of 10cm layer
       STLEV2=1.05_r8    ! half of second + first layer
       ITYPE =13
       DEPTH = TD_DEPTH(ITYPE)
       DO jb=1,jbMax
          DO ib=1,ibMaxPerJB(jb)
             IF     (DEPTH.GT.STLEV1.AND.DEPTH.LE.STLEV2)THEN ! interp.
                TC_SeaIce(ib,jb) = ( (STLEV2-DEPTH)*TGS_SeaIce (ib,jb) + (DEPTH-STLEV1)*TD_SeaIce  (ib,jb) )             &
                     &                        /(STLEV2-STLEV1)
             ELSE IF(DEPTH.GT.STLEV2)THEN                     ! extrap.
                TC_SeaIce(ib,jb) = ( (DEPTH-STLEV1)*TD_SeaIce  (ib,jb)  - (DEPTH-STLEV2)*TGS_SeaIce (ib,jb))             &
                     &                        /(STLEV2-STLEV1)
             END IF
          END DO
       END DO
    END IF
    !      ENDIF

  END SUBROUTINE InitSeaIce

  !
  !-----------------------------------------------------------------------
  !**********************************************
  SUBROUTINE GetFluxSeaIceModel (&
                                ! Model information
       nCols    ,kMax    ,latco  , &
                                ! Model Geometry
       zenith   ,sinclt  ,mskant , &
                                ! Time info
       DDTT     ,month   ,&
                                ! Atmospheric fields
       prsi,prsl,phii,phil,&
       tsea     ,gu      ,gv     ,    gt   , &
       gq       ,ppli   ,    ppci , &
                                ! LW Radiation fields at last integer hour
       LwSfcDown,&
                                ! Radiation field (Interpolated) at time = tod
       xvisb    ,xvisd   ,xnirb  ,xnird    , &
                                ! Surface Flux of SeaIce Scheme
       ELATEN,    HFLUX ,    rmi   ,    rhi   ,tsurf)



    IMPLICIT NONE

    !**********************************************
    !-----------------------------------------------------------------------
    !   THERE ARE A MAIN SSIB PROGRAM AND 12 SUBROUTINE FILES, WHICH ARE:
    !              VEGOUT
    !              CROPS
    !              RADAB
    !              ROOT1
    !              STOMA1
    !              INTERC
    !              TEMRS1
    !              UPDAT1
    !              RASIT5
    !              STRES1
    !              NEWTON
    !                                      YONGKANG XUE
    !-----------------------------------------------------------------------
    !                              INPUT
    !     DDTT:      TIME INTERVAL
    !     SUNANGLE:  SOLAR ZENITH ANGLE
    !     SWDOWN:   SHORT WAVE DOWN(W/M*M);
    !     RADFRAC:  SHORT WAVE COMPONENTS (visible and near IR; direct and diffuse)
    !     RLWDOWN:   LONG WAVE DOWN(W/M*M);
    !     PPL, PPC: LARGE SCALE AND CONVECTIVE PRECIPITATIONS AT THE TIME STEP (mm)
    !     TM:       TEMPERETURE AT LOWEST MODEL LAYER (K)
    !     UMM,VMM:  ZONAL AND MERIDIONAL WINDS AT LOWEST MODEL LAYER (m/S)
    !     QM:       WATER VAPOR AT LOWEST MODEL LAYER;
    !     PSURF:    SURFACE PRESSURE (mb)
    !     ZWIND:    HEIGHT (m) OF LOWEST MODEL LAYER
    !     ITYPE:    VEGETATION TYPE
    !     ZLAT:     LATITUDE, SOUTH POLE IS -90 DEGREE AND NORTH POLE IS 90 DEGREE
    !     MONTH:    MONTH
    !     DAY:      CALENDER DATE
    !     IYEAR:    YEAR
    !                             OUTPUT
    !     ETMASS:   EVAPORATION (mm/step)
    !     ELATEN:   LATENT HEAT FLUX (w/m*m)
    !     EVAPSOIL,EVAPWC,EVAPDC,EVAPSN: LATENT HEAT FROM (SOIL, INTERCEPTION,
    !               TRANSPIRATION, AND SNOW SURFACE)
    !     HFLUX:    SENSIBLE HEAT FLUX(w/m*m)
    !     GHTFLX:   GROUND HEAT FLUX(w/m*m) = CHF+SHF
    !     USTAR:    FRICTION VELOCITY (m/s)
    !     DRAG:     MOMENTUM FLUX (kg/m/s**2)
    !     DRAGU:    U COMPONENT OF MOMENTUM FLUX (kg/m/s**2)
    !     DRAGV:    V COMPONENT OF MOMENTUM FLUX (kg/m/s**2)
    !     TGEFF:    RADIATIVE TEMPERATURE (K)
    !     BEDO:     TOTAL ALBEDO
    !     SALB:     ALBEDO FOR 4 COMPONENTS
    !     RADT:     NET RADIATION AT CANOPY AND GROUND LEVELS
    !     TGS:      SOIL SURFACE TEMPERATURE (K)
    !     TC:       CANOPY TEMPERATURE (K)
    !     TD:       DEEP SOIL TEMPERATURE (K)
    !     TA:       TEMPERATURE AT CANOPY AIR SPACE (K)
    !     CAPAC:    INTERCEPTION AT CANOPY (1) and SNOW DEPTH (2)
    !     WWW:      SOIL MOISTURE
    !     SOILM:    TOTAL SOIL WATER CONTENT
    !     ROFF:     RUN OFF
    ! rmi...........RMI   (I)=CU(I)*USTAR(I), WHERE
    !               CU IS FRICTION  TRANSFER COEFFICIENTS
    !               USTAR IS SURFACE FRICTION VELOCITY  (M/S)
    ! rhi...........RHI   (I)=CT(I)*USTAR(I), WHERE
    !               CT IS HEAT TRANSFER COEFFICIENTS.
    !               USTAR IS SURFACE FRICTION VELOCITY  (M/S)
    !
    !----------------------------------------------------------------------

    ! Model information
    INTEGER         , INTENT(IN   ) :: nCols
    INTEGER         , INTENT(IN   ) :: kMax
    INTEGER         , INTENT(IN   ) :: latco
    ! Model Geometry
    REAL(KIND=r8)   , INTENT(IN   ) :: zenith   (nCols)
    REAL(KIND=r8)   , INTENT(IN   ) :: sinclt(ncols)
    INTEGER(KIND=i8), INTENT(IN   ) :: mskant(ncols)
    ! Time info
    REAL(KIND=r8)   , INTENT(IN   ) :: DDTT
    INTEGER         , INTENT(IN   ) :: month(nCols)
    ! Atmospheric fields
    REAL(KIND=r8), INTENT(IN   ) :: prsi     (nCols,kMax+1)  !     prsi     - real, pressure at layer interfaces             ix,levs+1  Pa
    REAL(KIND=r8), INTENT(IN   ) :: prsl     (nCols,kMax)    !     prsl     - real, mean layer presure                       ix,levs   Pa
    REAL(KIND=r8), INTENT(IN   ) :: phii     (nCols,kMax+1)  !===>  PHIH(K+1)  INPUT GEOPOTENTIAL @ EDGES  IN MKS units (m)
    REAL(KIND=r8), INTENT(IN   ) :: phil     (nCols,kMax)    !===>  PHIL(K)    INPUT GEOPOTENTIAL @ LAYERS IN MKS units (m)
    REAL(KIND=r8)   , INTENT(IN   ) :: tsea(nCols)
    REAL(KIND=r8)   , INTENT(IN   ) :: gu   (ncols,kMax) ! gu.........(zonal      velocity)*sin(colat)
    REAL(KIND=r8)   , INTENT(IN   ) :: gv   (ncols,kMax) ! gv.........(meridional velocity)*sin(colat)
    REAL(KIND=r8)   , INTENT(IN   ) :: gt   (ncols,kMax) ! gt.........Temperature
    REAL(KIND=r8)   , INTENT(IN   ) :: gq   (ncols,kMax) ! gq.........Specific humidity
    REAL(KIND=r8)   , INTENT(IN   ) :: ppli     (nCols)! Precipitation rate ( large scale )       (mm)
    REAL(KIND=r8)   , INTENT(IN   ) :: ppci     (nCols)! Precipitation rate ( cumulus )           (mm)
    ! LW Radiation fields at last integer hour
    REAL(KIND=r8)   , INTENT(IN   ) :: LwSfcDown(1:nCols)
    ! Radiation field (Interpolated) at time = tod
    REAL(KIND=r8)   , INTENT(IN   ) :: xvisb(1:nCols)    !.Downward Surface shortwave fluxe visible beam (cloudy)
    REAL(KIND=r8)   , INTENT(IN   ) :: xvisd(1:nCols)    !.Downward Surface shortwave fluxe visible diffuse (cloudy)
    REAL(KIND=r8)   , INTENT(IN   ) :: xnirb(1:nCols)    !.Downward Surface shortwave fluxe Near-IR beam (cloudy)
    REAL(KIND=r8)   , INTENT(IN   ) :: xnird(1:nCols)    !.Downward Surface shortwave fluxe Near-IR diffuse (cloudy)
    ! Surface Flux of SeaIce Scheme
    REAL(KIND=r8)    :: DeltaP   (ncols,kMax) ! gq.........Specific humidity
    REAL(KIND=r8)   , INTENT(OUT  ) :: ELATEN(1:nCols)
    REAL(KIND=r8)   , INTENT(OUT  ) :: HFLUX(1:nCols)
    REAL(KIND=r8)   , INTENT(INOUT) :: rmi(1:nCols)
    REAL(KIND=r8)   , INTENT(INOUT) :: rhi(1:nCols)
    REAL(KIND=r8)   , INTENT(OUT  ) :: tsurf(1:nCols)
    REAL(KIND=r8)   :: SUNANGLE(1:nCols)
    REAL(KIND=r8)   :: PPL(1:nCols)
    REAL(KIND=r8)   :: PPC(1:nCols)
    REAL(KIND=r8)   :: RLWDOWN(1:nCols)
    REAL(KIND=r8)   :: ZWIND2(1:nCols)
    REAL(KIND=r8)   :: YICE(1:nCols)
    REAL(KIND=r8)   :: UMM(1:nCols)
    REAL(KIND=r8)   :: VMM(1:nCols)
    REAL(KIND=r8)   :: QM(1:nCols)
    REAL(KIND=r8)   :: TM(1:nCols)
    REAL(KIND=r8)   :: PM(1:nCols)
    REAL(KIND=r8)   :: PSUR(1:nCols)
    REAL(KIND=r8)   :: RADFRAC11(1:nCols)
    REAL(KIND=r8)   :: RADFRAC12(1:nCols)
    REAL(KIND=r8)   :: RADFRAC21(1:nCols)
    REAL(KIND=r8)   :: RADFRAC22(1:nCols)
    INTEGER :: II,k
    REAL(KIND=r8)   , PARAMETER :: ice_threshold  = 0.5_r8
    REAL (KIND=r8), PARAMETER   :: grav  =                   9.8e0_r8! gravity constant               (m/s**2)
    REAL (KIND=r8), PARAMETER   :: gasr  =                  287.05_r8! gas constant of dry air        (j/kg/k)
    ELATEN=0.0_r8; HFLUX=0.0_r8; tsurf=0.0_r8; SUNANGLE=0.0_r8;
    PPL=0.0_r8; PPC=0.0_r8; RLWDOWN=0.0_r8; ZWIND2=0.0_r8;
    YICE=0.0_r8; UMM=0.0_r8; VMM=0.0_r8; QM=0.0_r8;
    TM=0.0_r8; PM=0.0_r8; PSUR=0.0_r8; RADFRAC11=0.0_r8;
    RADFRAC12=0.0_r8; RADFRAC21=0.0_r8; RADFRAC22=0.0_r8;
    !rbyg  =gasr/grav*delsig(1)*0.5_r8
    DO k=1,kmax
       DO ii = 1,ncols
         DeltaP(ii,k) = ((prsi(ii,k)) - (prsi(ii,k+1)))/prsi(ii,1)
       END DO
    END DO


    DO ii=1,nCols
       IF(mskant(ii) == 1_i8)THEN
          IF (tsea(ii) < 0.0_r8 .AND. ABS(tsea(ii)) < tice+0.01_r8) THEN
             SUNANGLE(ii)  = MAX(zenith(ii),0.0e0_r8 )
             PPL     (ii)  = ppli(ii)
             PPC     (ii)  = ppci(ii)
             RLWDOWN (ii)  = LwSfcDown(ii)
             ZWIND2  (ii)  = gt(ii,1)*(gasr/grav)*DeltaP(ii,1)*0.5_r8
             YICE     (ii) = ice_threshold    ! previously water, now sea-ice
             radfrac11(ii) = MAX(xvisb(ii),0.025_r8)
             radfrac12(ii) = MAX(xvisd(ii),0.025_r8)
             radfrac21(ii) = MAX(xnirb(ii),0.025_r8)
             radfrac22(ii) = MAX(xnird(ii),0.025_r8)
             UMM     (ii)  = gu (ii,1)/sinclt(ii)
             VMM     (ii)  = gv (ii,1)/sinclt(ii)
             QM       (ii) = gq (ii,1)
             TM      (ii)  = gt (ii,1)
             PSUR    (ii)  = prsi(ii,1)
             !PM        = gps(ii)*100.0_r8 - gps(ii)*delsig(1)*100.0_r8
             !P3D   (i) = gps(i)*100.0_r8 - gps(i)*delsig(1)*100.0_r8
             PM      (ii)  = prsi(ii,1) - prsi(ii,1)*DeltaP(ii,1)

             CALL SEAICE (                       & !
                  II           , & !  INTEGER      , INTENT(IN   ) :: II
                  latco        , & !  INTEGER      , INTENT(IN   ) :: latco
                  DDTT         , & !  REAL(KIND=r8), INTENT(IN   ) :: DDTT
                  month    (ii), & !  REAL(KIND=r8), INTENT(IN   ) :: month
                  SUNANGLE (ii), & !  REAL(KIND=r8), INTENT(IN   ) :: SUNANGLE
                  PPL      (ii), & !  REAL(KIND=r8), INTENT(IN   ) :: PPL
                  PPC      (ii), & !  REAL(KIND=r8), INTENT(IN   ) :: PPC
                  RLWDOWN  (ii), & !  REAL(KIND=r8), INTENT(IN   ) :: RLWDOWN
                  ZWIND2   (ii), & !  REAL(KIND=r8), INTENT(IN   ) :: ZWIND2
                  YICE     (ii), & !  REAL(KIND=r8), INTENT(IN   ) :: YICE
                  UMM      (ii), & !  REAL(KIND=r8), INTENT(IN   ) :: UMM
                  VMM      (ii), & !  REAL(KIND=r8), INTENT(IN   ) :: VMM
                  QM       (ii), & !  REAL(KIND=r8), INTENT(IN   ) :: QM
                  TM       (ii), & !  REAL(KIND=r8), INTENT(IN   ) :: TM
                  PM       (ii), & !  REAL(KIND=r8), INTENT(IN   ) :: PM
                  PSUR     (ii), & !  REAL(KIND=r8), INTENT(IN   ) :: PSUR
                  RADFRAC11(ii), & !  REAL(KIND=r8), INTENT(INOUT) :: RADFRAC11
                  RADFRAC12(ii), & !  REAL(KIND=r8), INTENT(INOUT) :: RADFRAC12
                  RADFRAC21(ii), & !  REAL(KIND=r8), INTENT(INOUT) :: RADFRAC21
                  RADFRAC22(ii), & !  REAL(KIND=r8), INTENT(INOUT) :: RADFRAC22
                  ELATEN   (ii), & !  REAL(KIND=r8), INTENT(OUT  ) :: ELATEN
                  HFLUX    (ii), & !  REAL(KIND=r8), INTENT(OUT  ) :: HFLUX
                  rmi      (ii), &
                  rhi      (ii), &
                  tsurf    (ii)  &
                  )
          END IF
       END IF
    END DO





  END SUBROUTINE GetFluxSeaIceModel

  FUNCTION GetIceOceanAlb(lon,latco,MONTH,xvisb,xvisd,xnirb,xnird,sunang,RLWDOWN)
    INTEGER, INTENT(IN   ) :: lon
    INTEGER, INTENT(IN   ) :: latco
    INTEGER, INTENT(IN   ) :: MONTH
    REAL(KIND=r8), INTENT(IN   ) :: xvisb    !.Downward Surface shortwave fluxe visible beam (cloudy)
    REAL(KIND=r8), INTENT(IN   ) :: xvisd    !.Downward Surface shortwave fluxe visible diffuse (cloudy)
    REAL(KIND=r8), INTENT(IN   ) :: xnirb    !.Downward Surface shortwave fluxe Near-IR beam (cloudy)
    REAL(KIND=r8), INTENT(IN   ) :: xnird    !.Downward Surface shortwave fluxe Near-IR diffuse (cloudy)
    REAL(KIND=r8), INTENT(IN   ) :: sunang  
    REAL(KIND=r8), INTENT(IN   ) :: RLWDOWN    !     RLWDOWN:   LONG WAVE DOWN(W/M*M);
    REAL(KIND=r8)                :: GetIceOceanAlb (2,2)  

    REAL(KIND=r8) :: fsdown
    REAL(KIND=r8) :: fldown
    REAL(KIND=r8) :: fsup
    REAL(KIND=r8) :: flup
    REAL(KIND=r8) :: radfrac11
    REAL(KIND=r8) :: radfrac12
    REAL(KIND=r8) :: radfrac21
    REAL(KIND=r8) :: radfrac22
    REAL(KIND=r8) :: swdown
    REAL(KIND=r8) :: TRAN(2,3,2)
    REAL(KIND=r8) :: REF(2,3,2)
    REAL(KIND=r8) :: GREEN(2)
    REAL(KIND=r8) :: VCOVER (2)
    REAL(KIND=r8) :: CHIL (2)
    REAL(KIND=r8) :: ZLT  (2)
    REAL(KIND=r8) :: Z2
    REAL(KIND=r8) :: Z1
    REAL(KIND=r8) :: SOREF  (3)
    REAL(KIND=r8) :: TC
    REAL(KIND=r8) :: TGS
    REAL(KIND=r8) :: SATCAP(2)
    REAL(KIND=r8) :: EXTK  (2,3,2)
    REAL(KIND=r8) :: CLOSS
    REAL(KIND=r8) :: GLOSS
    REAL(KIND=r8) :: THERMK
    REAL(KIND=r8) :: P1F
    REAL(KIND=r8) :: P2F
    REAL(KIND=r8) :: RADT (2) 
    REAL(KIND=r8) :: PAR  (2) 
    REAL(KIND=r8) :: PD   (2) 
    REAL(KIND=r8) :: SALB (2,2)  
    REAL(KIND=r8) :: ALBEDO (2,3,2)
    REAL(KIND=r8) :: TGEFF
    REAL(KIND=r8) :: xadj
    REAL(KIND=r8) :: RADN (3,2)  
    REAL(KIND=r8) :: bedo
    REAL(KIND=r8) :: ZLWUP
    REAL(KIND=r8) :: SNOCV            ! REAL(KIND=r8), INTENT(OUT  ) :: SCOV2

    REAL(KIND=r8) :: PHSAT
    REAL(KIND=r8) :: RSTPAR(2,3)
    REAL(KIND=r8) :: BEE     
    REAL(KIND=r8) :: RADFRAC(2,2)  
    REAL(KIND=r8) :: TOPT(2)
    REAL(KIND=r8) :: TL(2)
    REAL(KIND=r8) :: TU(2)
    REAL(KIND=r8) :: DEFAC(2)
    REAL(KIND=r8) :: PH1(2)
    REAL(KIND=r8) :: PH2(2)
    REAL(KIND=r8) :: ROOTD(2)
    REAL(KIND=r8) :: ZDEPTH(3)
    REAL(KIND=r8) :: POROS
    REAL(KIND=r8) :: RBC
    REAL(KIND=r8) :: RDC
    REAL(KIND=r8) :: SATCO
    REAL(KIND=r8) :: SLOPE
    REAL(KIND=r8) :: XDD
    REAL(KIND=r8) :: Z0
    INTEGER, PARAMETER :: ITYPE=13
    REAL(KIND=r8) :: CAPAC  (2)
    GetIceOceanAlb=0.4e0_r8
    fsdown=0.0_r8;fldown=0.0_r8;fsup=0.0_r8;flup=0.0_r8;
    radfrac11=0.0_r8;radfrac12=0.0_r8;radfrac21=0.0_r8;radfrac22=0.0_r8;
    swdown=0.0_r8;TRAN=0.0_r8;REF=0.0_r8;GREEN=0.0_r8;
    VCOVER =0.0_r8;CHIL =0.0_r8;ZLT  =0.0_r8;Z2=0.0_r8;
    Z1=0.0_r8;SOREF =0.0_r8;TC=0.0_r8;TGS=0.0_r8;
    SATCAP=0.0_r8;EXTK  =0.0_r8;CLOSS=0.0_r8;GLOSS=0.0_r8;
    THERMK=0.0_r8;P1F=0.0_r8;P2F=0.0_r8;RADT =0.0_r8;
    PAR  =0.0_r8;PD  =0.0_r8;SALB =0.0_r8;ALBEDO =0.0_r8;
    TGEFF=0.0_r8;xadj=0.0_r8;RADN =0.0_r8;bedo=0.0_r8;
    ZLWUP=0.0_r8;SNOCV=0.0_r8;PHSAT=0.0_r8;RSTPAR=0.0_r8;
    BEE=0.0_r8;RADFRAC=0.0_r8;TOPT=0.0_r8;TL=0.0_r8;
    TU=0.0_r8;DEFAC=0.0_r8;PH1=0.0_r8;PH2=0.0_r8;
    ROOTD=0.0_r8;ZDEPTH=0.0_r8;POROS=0.0_r8;RBC=0.0_r8;
    RDC=0.0_r8;SATCO=0.0_r8;SLOPE=0.0_r8;XDD=0.0_r8;
    Z0=0.0_r8;CAPAC=0.0_r8;

    !
    CAPAC(1)  = SNOA_SeaIce(lon,latco)
    CAPAC(2)  = SNOB_SeaIce(lon,latco)
    TC        = TC_SeaIce  (lon,latco)
    TGS       = TGS_SeaIce (lon,latco)

    !     The final albedo=original albedo+XADJ
    XADJ=0.0_r8
    radn(1,1) = xvisb 
    radn(1,2) = xvisd 
    radn(2,1) = xnirb 
    radn(2,2) = xnird 
    RADN(3,1) = 0.0_r8
    RADN(3,2) = RLWDOWN

    radfrac11 = MAX(xvisb,0.1_r8)
    radfrac12 = MAX(xvisd,0.1_r8)
    radfrac21 = MAX(xnirb,0.1_r8)
    radfrac22 = MAX(xnird,0.1_r8)

    swdown = radfrac11 + radfrac12 + radfrac21 + radfrac22

    RADFRAC(1,1) = radfrac11/swdown
    RADFRAC(1,2) = radfrac12/swdown
    RADFRAC(2,1) = radfrac21/swdown
    RADFRAC(2,2) = radfrac22/swdown

    CALL VEGOUT(&
         TRAN       , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XTRAN   (2,3,2)
         REF        , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XREF    (2,3,2)
         GREEN      , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XGREEN  (2)
         VCOVER     , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XVCOVER (2)
         CHIL       , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XCHIL   (2)
         RSTPAR     , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XRSTPAR (2,3)
         TOPT       , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XTOPT   (2)
         TL         , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XTL     (2)
         TU         , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XTU     (2)
         DEFAC      , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XDEFAC  (2)
         PH1        , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XPH1    (2)
         PH2        , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XPH2    (2)
         ZLT        , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XZLT    (2)
         Z0         , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XZ0 
         XDD        , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XDD 
         Z2         , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XZ2
         Z1         , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XZ1
         RDC        , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XRDC
         RBC        , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XRBC
         ROOTD      , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XROOTD  (2) 
         SOREF      , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XSOREF  (3)
         BEE        , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XBEE
         PHSAT      , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XPHSAT
         POROS      , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XPOROS
         SATCO      , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XSATCO
         SLOPE      , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XSLOPE 
         ZDEPTH     , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XDEPTH  (3)
         MONTH      , &!INTEGER         , INTENT(IN   )  :: MONTH
         ITYPE        )!INTEGER         , INTENT(IN   )  :: ITYPE


    CALL RADAB_ICE( &
         TRAN       , &! REAL(KIND=r8), INTENT(IN   ) :: TRAN (2,3,2)
         REF        , &! REAL(KIND=r8), INTENT(IN   ) :: REF  (2,3,2)
         GREEN      , &! REAL(KIND=r8), INTENT(IN   ) :: GREEN  (2)
         VCOVER     , &! REAL(KIND=r8), INTENT(IN   ) :: VCOVER (2)
         CHIL       , &! REAL(KIND=r8), INTENT(IN   ) :: CHIL (2)
         ZLT        , &! REAL(KIND=r8), INTENT(IN   ) :: ZLT  (2)
         Z2         , &! REAL(KIND=r8), INTENT(IN   ) :: Z2
         Z1         , &! REAL(KIND=r8), INTENT(IN   ) :: Z1
         SOREF      , &! REAL(KIND=r8), INTENT(IN   ) :: SOREF  (3)
         TC         , &! REAL(KIND=r8), INTENT(IN   ) :: TC
         TGS        , &! REAL(KIND=r8), INTENT(IN   ) :: TGS
         SATCAP     , &! REAL(KIND=r8), INTENT(OUT  ) :: SATCAP(2)
         EXTK       , &! REAL(KIND=r8), INTENT(OUT  ) :: EXTK  (2,3,2)
         CLOSS      , &! REAL(KIND=r8), INTENT(OUT  ) :: CLOSS
         GLOSS      , &! REAL(KIND=r8), INTENT(OUT  ) :: GLOSS
         THERMK     , &! REAL(KIND=r8), INTENT(OUT  ) :: THERMK
         P1F        , &! REAL(KIND=r8), INTENT(OUT  ) :: P1F
         P2F        , &! REAL(KIND=r8), INTENT(OUT  ) :: P2F
         RADT       , &! REAL(KIND=r8), INTENT(OUT  ) :: RADT (2)    
         PAR        , &! REAL(KIND=r8), INTENT(OUT  ) :: PAR  (2)    
         PD         , &! REAL(KIND=r8), INTENT(OUT  ) :: PD   (2)    
         SALB       , &! REAL(KIND=r8), INTENT(OUT  ) :: SALB (2,2)  
         ALBEDO     , &! REAL(KIND=r8), INTENT(OUT  ) :: ALBEDO (2,3,2)
         TGEFF      , &! REAL(KIND=r8), INTENT(OUT  ) :: TGEFF
         SUNANG     , &! REAL(KIND=r8), INTENT(IN   ) :: sunang
         XADJ       , &! REAL(KIND=r8), INTENT(IN   ) :: xadj
         CAPAC      , &! REAL(KIND=r8), INTENT(IN   ) :: CAPAC  (2)
         RADN       , &! REAL(KIND=r8), INTENT(IN   ) :: RADN (3,2)  
         BEDO       , &! REAL(KIND=r8), INTENT(OUT  ) :: bedo
         ZLWUP      , &! REAL(KIND=r8), INTENT(OUT  ) :: ZLWUP
         RADFRAC    , &! REAL(KIND=r8), INTENT(IN   ) :: RADFRAC(2,2)  
         SWDOWN     , &! REAL(KIND=r8), INTENT(IN   ) :: SWDOWN
         SNOCV      , &! REAL(KIND=r8), INTENT(OUT  ) :: SCOV2
         1          , &! INTEGER      , INTENT(IN   ) :: ISICE
         fsdown     , &! REAL(KIND=r8), INTENT(OUT  ) :: fsdown
         fldown     , &! REAL(KIND=r8), INTENT(OUT  ) :: fldown
         fsup       , &! REAL(KIND=r8), INTENT(OUT  ) :: fsup
         flup         )! REAL(KIND=r8), INTENT(OUT  ) :: flup
    GetIceOceanAlb=SALB
  END FUNCTION GetIceOceanAlb
  !
  !-----------------------------------------------------------------------
  !**********************************************
  SUBROUTINE SEAICE (                       & !
       II           , & !  INTEGER      , INTENT(IN   ) :: II
       latco        , & !  INTEGER      , INTENT(IN   ) :: latco
       DDTT         , & !  REAL(KIND=r8), INTENT(IN   ) :: DDTT
       MON_COR      , & !  REAL(KIND=r8), INTENT(IN   ) :: DAY
       SUNANGLE     , & !  REAL(KIND=r8), INTENT(IN   ) :: SUNANGLE
       PPL          , & !  REAL(KIND=r8), INTENT(IN   ) :: PPL
       PPC          , & !  REAL(KIND=r8), INTENT(IN   ) :: PPC
       RLWDOWN      , & !  REAL(KIND=r8), INTENT(IN   ) :: RLWDOWN
       ZWIND2       , & !  REAL(KIND=r8), INTENT(IN   ) :: ZWIND2
       YICE         , & !  REAL(KIND=r8), INTENT(IN   ) :: YICE
       UMM          , & !  REAL(KIND=r8), INTENT(IN   ) :: UMM
       VMM          , & !  REAL(KIND=r8), INTENT(IN   ) :: VMM
       QM           , & !  REAL(KIND=r8), INTENT(IN   ) :: QM
       TM           , & !  REAL(KIND=r8), INTENT(IN   ) :: TM
       PM           , & !  REAL(KIND=r8), INTENT(IN   ) :: PM
       PSUR         , & !  REAL(KIND=r8), INTENT(IN   ) :: PSUR
       RADFRAC11    , & !  REAL(KIND=r8), INTENT(INOUT) :: RADFRAC11
       RADFRAC12    , & !  REAL(KIND=r8), INTENT(INOUT) :: RADFRAC12
       RADFRAC21    , & !  REAL(KIND=r8), INTENT(INOUT) :: RADFRAC21
       RADFRAC22    , & !  REAL(KIND=r8), INTENT(INOUT) :: RADFRAC22
       ELATEN       , & !  REAL(KIND=r8), INTENT(OUT  ) :: ELATEN
       xhsflx       , & !  REAL(KIND=r8), INTENT(OUT  ) :: HFLUX
       rmi          , &  
       rhi          , &
       tsurf          &
       ) 


    IMPLICIT NONE

    !**********************************************
    !-----------------------------------------------------------------------
    !   THERE ARE A MAIN SSIB PROGRAM AND 12 SUBROUTINE FILES, WHICH ARE:
    !              VEGOUT
    !              CROPS
    !              RADAB
    !              ROOT1
    !              STOMA1
    !              INTERC
    !              TEMRS1
    !              UPDAT1
    !              RASIT5
    !              STRES1
    !              NEWTON
    !                                      YONGKANG XUE
    !-----------------------------------------------------------------------
    !                              INPUT
    !     DDTT:      TIME INTERVAL
    !     SUNANGLE:  SOLAR ZENITH ANGLE
    !     SWDOWN:   SHORT WAVE DOWN(W/M*M);
    !     RADFRAC:  SHORT WAVE COMPONENTS (visible and near IR; direct and diffuse)
    !     RLWDOWN:   LONG WAVE DOWN(W/M*M);
    !     PPL, PPC: LARGE SCALE AND CONVECTIVE PRECIPITATIONS AT THE TIME STEP (mm)
    !     TM:       TEMPERETURE AT LOWEST MODEL LAYER (K)
    !     UMM,VMM:  ZONAL AND MERIDIONAL WINDS AT LOWEST MODEL LAYER (m/S)
    !     QM:       WATER VAPOR AT LOWEST MODEL LAYER;
    !     PSURF:    SURFACE PRESSURE (mb)
    !     ZWIND:    HEIGHT (m) OF LOWEST MODEL LAYER
    !     ITYPE:    VEGETATION TYPE
    !     MONTH:    MONTH
    !     MON_COR:      CALENDER DATE
    !     IYEAR:    YEAR
    !                             OUTPUT
    !     ETMASS:   EVAPORATION (mm/step)
    !     ELATEN:   LATENT HEAT FLUX (w/m*m)
    !     EVAPSOIL,EVAPWC,EVAPDC,EVAPSN: LATENT HEAT FROM (SOIL, INTERCEPTION,
    !               TRANSPIRATION, AND SNOW SURFACE)
    !     HFLUX:    SENSIBLE HEAT FLUX(w/m*m)
    !     GHTFLX:   GROUND HEAT FLUX(w/m*m) = CHF+SHF
    !     USTAR:    FRICTION VELOCITY (m/s)
    !     DRAG:     MOMENTUM FLUX (kg/m/s**2)
    !     DRAGU:    U COMPONENT OF MOMENTUM FLUX (kg/m/s**2)
    !     DRAGV:    V COMPONENT OF MOMENTUM FLUX (kg/m/s**2)
    !     TGEFF:    RADIATIVE TEMPERATURE (K)
    !     BEDO:     TOTAL ALBEDO
    !     SALB:     ALBEDO FOR 4 COMPONENTS
    !     RADT:     NET RADIATION AT CANOPY AND GROUND LEVELS
    !     TGS:      SOIL SURFACE TEMPERATURE (K)
    !     TC:       CANOPY TEMPERATURE (K)
    !     TD:       DEEP SOIL TEMPERATURE (K)
    !     TA:       TEMPERATURE AT CANOPY AIR SPACE (K)
    !     CAPAC:    INTERCEPTION AT CANOPY (1) and SNOW DEPTH (2)
    !     WWW:      SOIL MOISTURE
    !     SOILM:    TOTAL SOIL WATER CONTENT
    !     ROFF:     RUN OFF
    !
    !----------------------------------------------------------------------

    INTEGER, INTENT(IN   ) :: II
    INTEGER, INTENT(IN   ) :: latco
    REAL(KIND=r8)   , INTENT(IN   ) :: DDTT
    INTEGER         , INTENT(IN   ) :: MON_COR
    REAL(KIND=r8)   , INTENT(IN   ) :: SUNANGLE
    REAL(KIND=r8)   , INTENT(IN   ) :: PPL
    REAL(KIND=r8)   , INTENT(IN   ) :: PPC
    REAL(KIND=r8)   , INTENT(IN   ) :: RLWDOWN
    REAL(KIND=r8)   , INTENT(IN   ) :: ZWIND2
    REAL(KIND=r8)   , INTENT(IN   ) :: YICE
    REAL(KIND=r8)   , INTENT(IN   ) :: UMM
    REAL(KIND=r8)   , INTENT(IN   ) :: VMM
    REAL(KIND=r8)   , INTENT(IN   ) :: QM
    REAL(KIND=r8)   , INTENT(IN   ) :: TM
    REAL(KIND=r8)   , INTENT(IN   ) :: PM
    REAL(KIND=r8)   , INTENT(IN   ) :: PSUR
    REAL(KIND=r8)   , INTENT(INOUT) :: RADFRAC11
    REAL(KIND=r8)   , INTENT(INOUT) :: RADFRAC12
    REAL(KIND=r8)   , INTENT(INOUT) :: RADFRAC21
    REAL(KIND=r8)   , INTENT(INOUT) :: RADFRAC22
    REAL(KIND=r8)   , INTENT(OUT  ) :: ELATEN
    REAL(KIND=r8)   , INTENT(OUT  ) :: xhsflx
    REAL(KIND=r8)   , INTENT(INOUT) :: rmi  
    REAL(KIND=r8)   , INTENT(INOUT) :: rhi  
    REAL(KIND=r8)   , INTENT(OUT  ) :: tsurf
    !
    !
    ! LOCAL
    !
    !    
    REAL(KIND=r8)    :: HFLUX
    REAL(KIND=r8)    :: GHTFLX
    REAL(KIND=r8)    :: XHLFLX
    REAL(KIND=r8)    :: TGEFF
    REAL(KIND=r8)    :: USTAR
    REAL(KIND=r8)    :: RIB
    REAL(KIND=r8)    :: FM
    REAL(KIND=r8)    :: FH
    REAL(KIND=r8)    :: CM
    REAL(KIND=r8)    :: XLHF
    REAL(KIND=r8)    :: XSHF
    REAL(KIND=r8)    :: XGHF
    REAL(KIND=r8)    :: XSDN
    REAL(KIND=r8)    :: XSUP
    REAL(KIND=r8)    :: XLDN
    REAL(KIND=r8)    :: XLUP
    REAL(KIND=r8)    :: XWAT
    REAL(KIND=r8)    :: XXZ0
    REAL(KIND=r8)    :: XVEG
    REAL(KIND=r8)    :: Q2M
    REAL(KIND=r8)    :: BEDO

    REAL(KIND=r8)    :: TC
    REAL(KIND=r8)    :: TGS
    REAL(KIND=r8)    :: TD
    REAL(KIND=r8)    :: TA
    REAL(KIND=r8)    :: SNOA
    REAL(KIND=r8)    :: SNOB

    REAL(KIND=r8)    :: ROFF  
    REAL(KIND=r8)    :: WWW1
    REAL(KIND=r8)    :: WWW2
    REAL(KIND=r8)    :: WWW3
    REAL(KIND=r8)    :: SALB11
    REAL(KIND=r8)    :: SALB12
    REAL(KIND=r8)    :: SALB21
    REAL(KIND=r8)    :: SALB22
    REAL(KIND=r8)    :: AKAPPA
    REAL(KIND=r8)    :: BEE
    REAL(KIND=r8)    :: BPS
    REAL(KIND=r8)    :: CCX
    REAL(KIND=r8)    :: CG
    REAL(KIND=r8)    :: CH
    REAL(KIND=r8)    :: CHF
    REAL(KIND=r8)    :: CLOSS
    REAL(KIND=r8)    :: CTLPA
    REAL(KIND=r8)    :: CU
    REAL(KIND=r8)    :: DTC
    REAL(KIND=r8)    :: DTG
    REAL(KIND=r8)    :: DTT
    REAL(KIND=r8)    :: EA
    REAL(KIND=r8)    :: EC
    REAL(KIND=r8)    :: ECI
    REAL(KIND=r8)    :: ECT
    REAL(KIND=r8)    :: EG
    REAL(KIND=r8)    :: EGI
    REAL(KIND=r8)    :: EGS
    REAL(KIND=r8)    :: EGT
    REAL(KIND=r8)    :: EM

    REAL(KIND=r8)    :: ETMASS
    REAL(KIND=r8)    :: EVAP
    REAL(KIND=r8)    :: FILTR
    REAL(KIND=r8)    :: fldown
    REAL(KIND=r8)    :: flup
    REAL(KIND=r8)    :: fsdown
    REAL(KIND=r8)    :: fsup
    REAL(KIND=r8)    :: GLOSS
    REAL(KIND=r8)    :: HC
    REAL(KIND=r8)    :: HG
    REAL(KIND=r8)    :: HLFLX
    REAL(KIND=r8)    :: HSFLX
    REAL(KIND=r8)    :: P1F
    REAL(KIND=r8)    :: P2F
    REAL(KIND=r8)    :: PHSAT
    REAL(KIND=r8)    :: POROS
    REAL(KIND=r8)    :: POROSAVE
    REAL(KIND=r8)    :: PSURF
    REAL(KIND=r8)    :: RA
    REAL(KIND=r8)    :: RBC
    REAL(KIND=r8)    :: RCC
    REAL(KIND=r8)    :: RDC
    REAL(KIND=r8)    :: RHOAIR
    REAL(KIND=r8)    :: RNOFFB
    REAL(KIND=r8)    :: RNOFFS
    REAL(KIND=r8)    :: SATCO
    REAL(KIND=r8)    :: SHF
    REAL(KIND=r8)    :: SLOPE
    REAL(KIND=r8)    :: SMELT
    REAL(KIND=r8)    :: SNOCV
    REAL(KIND=r8)    :: SNOWDEN
    REAL(KIND=r8)    :: SOILDIF
    REAL(KIND=r8)    :: SOILDRA
    REAL(KIND=r8)    :: SOILM
    REAL(KIND=r8)    :: SPWET
    REAL(KIND=r8)    :: swdown
    REAL(KIND=r8)    :: THERMK
    REAL(KIND=r8)    :: ULWSF1
    REAL(KIND=r8)    :: UM
    REAL(KIND=r8)    :: UMOM
    REAL(KIND=r8)    :: VMOM
    REAL(KIND=r8)    :: XADIA
    REAL(KIND=r8)    :: XADJ
    REAL(KIND=r8)    :: XCT
    REAL(KIND=r8)    :: XDD
    REAL(KIND=r8)    :: XX
    REAL(KIND=r8)    :: Z0
    REAL(KIND=r8)    :: Z1
    REAL(KIND=r8)    :: Z2
    REAL(KIND=r8)    :: ZLWUP
    REAL(KIND=r8)    :: ZWIND
    REAL(KIND=r8)    :: sunang
    !INTEGER :: IDAY
    !INTEGER :: IMONTH
    INTEGER :: INTG
    INTEGER :: ISNOW
    INTEGER :: ITYPE
    INTEGER :: NROOT
    REAL(KIND=r8) :: CAPAC(2), SATCAP(2), GREEN(2), VCOVER(2), ZLT(2), CHIL(2), TOPT(2), TL(2), &
         TU(2), DEFAC(2), PH1(2), PH2(2), RST(2), ROOTD(2), RADT(2), PAR(2), PD(2)
    REAL(KIND=r8) :: WWW(3), SOREF(3), ZDEPTH(3), ROOTP(3), PHSOIL(3)
    REAL(KIND=r8) :: RADFRAC(2,2), SALB(2,2)
    REAL(KIND=r8) :: RSTPAR(2,3)
    REAL(KIND=r8) :: RSTFAC(2,4)
    REAL(KIND=r8) :: RADN(3,2)
    REAL(KIND=r8) :: TRAN(2,3,2), REF(2,3,2), ALBEDO(2,3,2), EXTK(2,3,2)

    !
    INTEGER, PARAMETER :: IDAYS(12)=(/31,59,90,120,151,181,212,243,273,304,334,366/)

    ! if ( fractional_seaice == 0 ) then
    REAL(KIND=r8)   , PARAMETER :: ice_threshold  = 0.5_r8
    ! else if ( fractional_seaice == 1 ) then
    !     xice_threshold = 0.02_r8
    ! endif


    CAPAC=0.0_r8; SATCAP=0.0_r8; GREEN=0.0_r8; VCOVER=0.0_r8; 
    ZLT=0.0_r8; CHIL=0.0_r8; TOPT=0.0_r8; TL=0.0_r8
    TU=0.0_r8; DEFAC=0.0_r8; PH1=0.0_r8; PH2=0.0_r8; RST=0.0_r8; 
    ROOTD=0.0_r8; RADT=0.0_r8; PAR=0.0_r8; PD=0.0_r8; 
    WWW=0.0_r8; SOREF=0.0_r8; ZDEPTH=0.0_r8; ROOTP=0.0_r8; PHSOIL=0.0_r8;
    RADFRAC=0.0_r8; SALB=0.0_r8;
    RSTPAR=0.0_r8;
    RSTFAC=0.0_r8;
    RADN=0.0_r8;
    TRAN=0.0_r8; REF=0.0_r8; ALBEDO=0.0_r8; EXTK=0.0_r8;
 
 
    ELATEN=0.0_r8;xhsflx=0.0_r8;tsurf=0.0_r8;
    HFLUX=0.0_r8;GHTFLX=0.0_r8;XHLFLX=0.0_r8;TGEFF=0.0_r8;
    USTAR=0.0_r8;RIB=0.0_r8;FM=0.0_r8;FH=0.0_r8;
    CM=0.0_r8;XLHF=0.0_r8;XSHF=0.0_r8;XGHF=0.0_r8;
    XSDN=0.0_r8;XSUP=0.0_r8;XLDN=0.0_r8;XLUP=0.0_r8;
    XWAT=0.0_r8;XXZ0=0.0_r8;XVEG=0.0_r8;Q2M=0.0_r8;BEDO=0.0_r8;

    TC=0.0_r8;TGS=0.0_r8;TD=0.0_r8;TA=0.0_r8;SNOA=0.0_r8;SNOB=0.0_r8;

    ROFF  =0.0_r8;WWW1=0.0_r8;WWW2=0.0_r8;WWW3=0.0_r8;
    SALB11=0.0_r8;SALB12=0.0_r8;SALB21=0.0_r8;SALB22=0.0_r8;
    AKAPPA=0.0_r8;BEE=0.0_r8;BPS=0.0_r8;CCX=0.0_r8;
    CG=0.0_r8;CH=0.0_r8;CHF=0.0_r8;CLOSS=0.0_r8;
    CTLPA=0.0_r8;CU=0.0_r8;DTC=0.0_r8;DTG=0.0_r8;
    DTT=0.0_r8;EA=0.0_r8;EC=0.0_r8;ECI=0.0_r8;
    ECT=0.0_r8;EG=0.0_r8;EGI=0.0_r8;EGS=0.0_r8;
    EGT=0.0_r8;EM=0.0_r8;

    ETMASS=0.0_r8;EVAP=0.0_r8;
    FILTR=0.0_r8;fldown=0.0_r8;
    flup=0.0_r8;fsdown=0.0_r8;
    fsup=0.0_r8;GLOSS=0.0_r8;
    HC=0.0_r8;HG=0.0_r8;
    HLFLX=0.0_r8;HSFLX=0.0_r8;
    P1F=0.0_r8;P2F=0.0_r8;
    PHSAT=0.0_r8;POROS=0.0_r8;
    POROSAVE=0.0_r8;PSURF=0.0_r8;
    RA=0.0_r8;RBC=0.0_r8;
    RCC=0.0_r8;RDC=0.0_r8;
    RHOAIR=0.0_r8;RNOFFB=0.0_r8;
    RNOFFS=0.0_r8;SATCO=0.0_r8;
    SHF=0.0_r8;SLOPE=0.0_r8;
    SMELT=0.0_r8;SNOCV=0.0_r8;
    SNOWDEN=0.0_r8;SOILDIF=0.0_r8;
    SOILDRA=0.0_r8;SOILM=0.0_r8;
    SPWET=0.0_r8;swdown=0.0_r8;
    THERMK=0.0_r8;ULWSF1=0.0_r8;
    UM=0.0_r8;UMOM=0.0_r8;
    VMOM=0.0_r8;XADIA=0.0_r8;
    XADJ=0.0_r8;XCT=0.0_r8;
    XDD=0.0_r8;XX=0.0_r8;
    Z0=0.0_r8;Z1=0.0_r8;
    Z2=0.0_r8;ZLWUP=0.0_r8;
    ZWIND=0.0_r8;sunang=0.0_r8;


    TC    = TC_SeaIce   (ii,latco)
    TGS   = TGS_SeaIce  (ii,latco) 
    TD    = TD_SeaIce   (ii,latco)
    TA    = TA_SeaIce   (ii,latco)
    SNOA  = SNOA_SeaIce (ii,latco)
    SNOB  = SNOB_SeaIce (ii,latco)
    !**********************************************
    !     The final albedo=original albedo+XADJ
    XADJ=0.0_r8
    !     CTLPA controls stomatal resistance;
    !     Final stomatal resistance=ctlpa * stomatal resistance
    CTLPA=1.0_r8
    !     NROOT controls root distribution. nroot=1: root uniformly distributes
    !           in the soil layer;
    !     If NROOT not =1, root distribution is controled by rootp.
    NROOT=1
    !     INTG=?   TIME INTEGRATION OF SURFACE PHYSICAL VARIABLE IS DONE
    !     INTG=2:  LEAP-FROG IMPLICIT SCHEME.   INTG=1 BACKWORD IMPLICIT SCHEME
    INTG=1  !!!!!! in MM5 version hardwired for INTG=1 !!!!!!!!!!!!!
    !------------------------------------------------
    ITYPE=13
    ZWIND=ZWIND2*0.5_r8
    !------------------------------------------------
    !     set DAY in year and current month MON_COR
    !------------------------------------------------
    !IMONTH=1
    !IDAY=INT(DAY)
    !DO I=1,12
    !   IF(IDAY.LE.IDAYS(I)) THEN
    !      IMONTH=I
    !      EXIT
    !   ENDIF
    !ENDDO
    !crr correction for southern hemisphere (reverse months) Ratko, Oct 28, 2005
    !IF(ZLAT.LT.0.0_r8) THEN
    !   MON_COR=IMONTH+6
    !   IF(MON_COR.GT.12) MON_COR=MON_COR-12
    !ELSE
    !   MON_COR=IMONTH
    !ENDIF
    !------------------------------------------------
    !PK      IF (ITIME.EQ.1) TA=TC
    !
    PSURF=PSUR*0.01_r8
    DTT =DDTT!*FLOAT(INTG)
    !------------------------------------------------
    ! **  Read in vegetation parameters
    CALL VEGOUT(&
         TRAN       , &!INTEGER, INTENT(IN   )  :: ITYPE
         REF        , &!INTEGER, INTENT(IN   )  :: MONTH
         GREEN      , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XGREEN  (2)
         VCOVER     , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XVCOVER (2)
         CHIL       , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XZLT    (2)
         RSTPAR     , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XCHIL   (2)
         TOPT       , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XTOPT   (2)
         TL         , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XTL     (2)
         TU         , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XTU     (2)
         DEFAC      , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XDEFAC  (2)
         PH1        , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XPH1    (2)
         PH2        , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XPH2    (2)
         ZLT        , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XROOTD  (2)
         Z0         , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XSOREF  (3)
         XDD        , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XDEPTH  (3)
         Z2         , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XRSTPAR (2,3)
         Z1         , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XTRAN   (2,3,2)
         RDC        , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XREF    (2,3,2)
         RBC        , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XZ0
         ROOTD      , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XDD
         SOREF      , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XZ2
         BEE        , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XZ1
         PHSAT      , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XRDC
         POROS      , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XRBC
         SATCO      , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XBEE
         SLOPE      , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XPHSAT
         ZDEPTH     , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XPOROS
         MON_COR    , &!REAL(KIND=r8)   , INTENT(OUT  )  :: XSATCO
         ITYPE        )!REAL(KIND=r8)   , INTENT(OUT  )  :: XSLOPE 
    !
    !crr ------------ STC initialization ------------------------------------
    !PK      IF (ITIME.EQ.1) THEN
    !PK           STLEV1=0.05    ! half of 10cm layer
    !PK           STLEV2=1.05    ! half of second + first layer
    !PK 
    !PK           DEPTH = TD_DEPTH(ITYPE)
    !PK 
    !PK             IF     (DEPTH.GT.STLEV1.AND.DEPTH.LE.STLEV2)THEN ! interp.
    !PK             TD = ( (STLEV2-DEPTH)*TGS + (DEPTH-STLEV1)*TD )             &
    !PK      &                        /(STLEV2-STLEV1)
    !PK             ELSE IF(DEPTH.GT.STLEV2)THEN                     ! extrap.
    !PK             TD = ( (DEPTH-STLEV1)*TD  - (DEPTH-STLEV2)*TGS)             &
    !PK      &                        /(STLEV2-STLEV1)
    !PK             ENDIF
    !PK       ENDIF
    !------------------------------------------------------------------------
    WWW(1)   = 1.0_r8
    WWW(2)   = 1.0_r8
    WWW(3)   = 1.0_r8
    !
    CAPAC(1)=SNOB
    CAPAC(2)=SNOA
    SNOWDEN = 3.75_r8   ! mchen add for initialization
    !PK       IF (ITIME.EQ.1) THEN
    !PK          TA=TGS
    !PK          CAPAC(1)=0.0_r8
    !PK          CAPAC(2)=0.0_r8
    !PK            IF (SNOA.GT.0.) CAPAC(1) = ZLT(1)  * 0.0001
    !PK            TC = MIN(TC ,273.15)
    !PK            TGS= MIN(TGS,273.15)
    !PK            TD = MIN(TD ,272.50)
    !PK       ELSE
    !        IF( YICE .LT. 0.5_r8 ) THEN     ! previous sea, now sea-ice
    IF( YICE .LE. ice_threshold ) THEN     ! previously water, now sea-ice
       CAPAC(1)= 0.0_r8
       CAPAC(2)= 0.0_r8
       XADIA = EXP(GASR/CPAIR*LOG(PSUR/PM))
       XX = MIN(TM*XADIA,273.15_r8)
       TC = MIN(TM*XADIA,273.15_r8)
       TGS= MIN(TM*XADIA,273.15_r8)
       IF(TD.EQ.0.0_r8) TD=272.5_r8
       TD = MIN(TD,272.5_r8)
    ENDIF
    !PK       ENDIF
    !
    UM=SQRT(UMM**2+VMM**2)
    RHOAIR=100.0_r8/GASR*(PSURF+0.01_r8*PM)/(TM+TA)
    AKAPPA = GASR/CPAIR
    BPS    =1.0_r8 / EXP ( AKAPPA * LOG (0.01_r8*PM/PSURF) )
    !
    !     CONVERT TO VAPOR PRES. TO MB
    EM=(PSURF*QM)/0.6220_r8
    !
    !PK       IF (ITIME.EQ.1) EA=EM
    !
    SUNANG=MAX(SUNANGLE,0.01746_r8)
    !
    ! By Zhenxin 2011-06-20
    !      IF (sw_physics.eq.3) THEN
    !       IF (sw_physics.eq.3 .or. sw_physics.eq.4) THEN
    ! End by Zhenxin 2011-06-20 

    !**********************************************
    !fds - RADFRAC from radiation scheme 3 (06/2010)
    !fds - Otherwise use cloud cover to calculate radfrac 
    radfrac11 = MAX(radfrac11,0.1_r8)
    radfrac12 = MAX(radfrac12,0.1_r8)
    radfrac21 = MAX(radfrac21,0.1_r8)
    radfrac22 = MAX(radfrac22,0.1_r8)
    swdown = radfrac11 + radfrac12 + radfrac21 + radfrac22
    RADFRAC(1,1) = radfrac11/swdown
    RADFRAC(1,2) = radfrac12/swdown
    RADFRAC(2,1) = radfrac21/swdown
    RADFRAC(2,2) = radfrac22/swdown
    !      ELSE
    ! ** CALCULATE THE CLOUD COVER USING AN EMPIRICAL EQUATION
    !    ONLY USE THIS PART WHEN IT IS NEEDED
    !  **  ONLY USE THIS PART WHEN SW_PHYSICS = 1 IS USED ** By Zhenxin 2011-06 
    !        swdown = MAX(swdown1,0.1_r8)
    !        CLOUD = MAX(CLOUD,0.0_r8)
    !        CLOUD = MIN(CLOUD,1.0_r8)
    !        CLOUD = MAX(0.58_r8,CLOUD)
    !
    !        DIFRAT = 0.0604 / ( SUNANG-0.0223 ) + 0.0683
    !        IF ( DIFRAT .LT. 0.0 ) DIFRAT = 0.0
    !        IF ( DIFRAT .GT. 1.0 ) DIFRAT = 1.0
    !!
    !        DIFRAT = DIFRAT + ( 1.0 - DIFRAT ) * CLOUD
    !        VNRAT = ( 580.0 - CLOUD*464.0 ) / ( ( 580.0-CLOUD*499.0) &
    !       &        + ( 580.0 - CLOUD*464.0 ) )
    !!
    !        RADFRAC(1,1) = (1.0-DIFRAT)*VNRAT
    !        RADFRAC(1,2) = DIFRAT*VNRAT
    !        RADFRAC(2,1) = (1.0-DIFRAT)*(1.0-VNRAT)
    !        RADFRAC(2,2) = DIFRAT*(1.0-VNRAT)
    !**********************************************
    !      ENDIF
    !
    RADN(1,1) = RADFRAC(1,1) * SWDOWN
    RADN(1,2) = RADFRAC(1,2) * SWDOWN
    RADN(2,1) = RADFRAC(2,1) * SWDOWN
    RADN(2,2) = RADFRAC(2,2) * SWDOWN
    RADN(3,1) = 0.0_r8
    RADN(3,2) = RLWDOWN
    !
    !     END OF EMPIRICAL EQUATIONS
    !     *********************************************************
    !
    CALL RADAB_ICE( &
         TRAN       , &! REAL(KIND=r8), INTENT(IN   ) :: TRAN (2,3,2)
         REF        , &! REAL(KIND=r8), INTENT(IN   ) :: REF  (2,3,2)
         GREEN      , &! REAL(KIND=r8), INTENT(IN   ) :: GREEN  (2)
         VCOVER     , &! REAL(KIND=r8), INTENT(IN   ) :: VCOVER (2)
         CHIL       , &! REAL(KIND=r8), INTENT(IN   ) :: CHIL (2)
         ZLT        , &! REAL(KIND=r8), INTENT(IN   ) :: ZLT  (2)
         Z2         , &! REAL(KIND=r8), INTENT(IN   ) :: Z2
         Z1         , &! REAL(KIND=r8), INTENT(IN   ) :: Z1
         SOREF      , &! REAL(KIND=r8), INTENT(IN   ) :: SOREF  (3)
         TC         , &! REAL(KIND=r8), INTENT(IN   ) :: TC
         TGS        , &! REAL(KIND=r8), INTENT(IN   ) :: TGS
         SATCAP     , &! REAL(KIND=r8), INTENT(OUT  ) :: SATCAP(2)
         EXTK       , &! REAL(KIND=r8), INTENT(OUT  ) :: EXTK  (2,3,2)
         CLOSS      , &! REAL(KIND=r8), INTENT(OUT  ) :: CLOSS
         GLOSS      , &! REAL(KIND=r8), INTENT(OUT  ) :: GLOSS
         THERMK     , &! REAL(KIND=r8), INTENT(OUT  ) :: THERMK
         P1F        , &! REAL(KIND=r8), INTENT(OUT  ) :: P1F
         P2F        , &! REAL(KIND=r8), INTENT(OUT  ) :: P2F
         RADT       , &! REAL(KIND=r8), INTENT(OUT  ) :: RADT (2)    
         PAR        , &! REAL(KIND=r8), INTENT(OUT  ) :: PAR  (2)    
         PD         , &! REAL(KIND=r8), INTENT(OUT  ) :: PD   (2)    
         SALB       , &! REAL(KIND=r8), INTENT(OUT  ) :: SALB (2,2)  
         ALBEDO     , &! REAL(KIND=r8), INTENT(OUT  ) :: ALBEDO (2,3,2)
         TGEFF      , &! REAL(KIND=r8), INTENT(OUT  ) :: TGEFF
         SUNANG     , &! REAL(KIND=r8), INTENT(IN   ) :: sunang
         XADJ       , &! REAL(KIND=r8), INTENT(IN   ) :: xadj
         CAPAC      , &! REAL(KIND=r8), INTENT(IN   ) :: CAPAC  (2)
         RADN       , &! REAL(KIND=r8), INTENT(IN   ) :: RADN (3,2)  
         BEDO       , &! REAL(KIND=r8), INTENT(OUT  ) :: bedo
         ZLWUP      , &! REAL(KIND=r8), INTENT(OUT  ) :: ZLWUP
         RADFRAC    , &! REAL(KIND=r8), INTENT(IN   ) :: RADFRAC(2,2)  
         SWDOWN     , &! REAL(KIND=r8), INTENT(IN   ) :: SWDOWN
         SNOCV      , &! REAL(KIND=r8), INTENT(OUT  ) :: SCOV2
         1          , &! INTEGER, INTENT(IN) :: ISICE
         fsdown     , &! REAL(KIND=r8), INTENT(OUT  ) :: fsdown
         fldown     , &! REAL(KIND=r8), INTENT(OUT  ) :: fldown
         fsup       , &! REAL(KIND=r8), INTENT(OUT  ) :: fsup
         flup         )! REAL(KIND=r8), INTENT(OUT  ) :: flup

    CALL ROOT1( &
         PHSAT   , &!REAL(KIND=r8), INTENT(IN   ) :: WWW   (3)
         BEE     , &!REAL(KIND=r8), INTENT(IN   ) :: PHSAT
         WWW     , &!REAL(KIND=r8), INTENT(IN   ) :: BEE
         PHSOIL    )!REAL(KIND=r8), INTENT(OUT  ) :: PHSOIL(3)

    CALL STOMA1(&
         GREEN   , &!REAL(KIND=r8), INTENT(IN   ) :: GREEN  (2)    
         VCOVER  , &!REAL(KIND=r8), INTENT(IN   ) :: VCOVER (2)    
         CHIL    , &!REAL(KIND=r8), INTENT(IN   ) :: CHIL   (2)    
         ZLT     , &!REAL(KIND=r8), INTENT(IN   ) :: ZLT    (2)    
         PAR     , &!REAL(KIND=r8), INTENT(IN   ) :: PAR    (2)    
         PD      , &!REAL(KIND=r8), INTENT(IN   ) :: PD     (2)    
         EXTK    , &!REAL(KIND=r8), INTENT(IN   ) :: EXTK   (2,3,2)
         SUNANG  , &!REAL(KIND=r8), INTENT(IN   ) :: SUNANG
         RST     , &!REAL(KIND=r8), INTENT(OUT  ) :: RST    (2)    
         RSTPAR  , &!REAL(KIND=r8), INTENT(IN   ) :: RSTPAR (2,3)
         CTLPA     )!REAL(KIND=r8), INTENT(IN   ) :: CTLPA  
    !***
    POROSAVE=POROS
    POROS=0.95_r8
    !***
    !
    CALL INTERC( &
         DTT     , & !REAL(KIND=r8), INTENT(IN   ) :: DTT
         VCOVER  , & !REAL(KIND=r8), INTENT(IN   ) :: VCOVER  (2)    
         ZLT     , & !REAL(KIND=r8), INTENT(IN   ) :: ZLT     (2)    
         TM      , & !REAL(KIND=r8), INTENT(IN   ) :: TM   
         TC      , & !REAL(KIND=r8), INTENT(INOUT) :: TC   
         TGS     , & !REAL(KIND=r8), INTENT(INOUT) :: TGS  
         CAPAC   , & !REAL(KIND=r8), INTENT(INOUT) :: CAPAC   (2)    
         WWW     , & !REAL(KIND=r8), INTENT(INOUT) :: WWW     (3)    
         PPC     , & !REAL(KIND=r8), INTENT(IN   ) :: PPC
         PPL     , & !REAL(KIND=r8), INTENT(IN   ) :: PPL
         ROFF    , & !REAL(KIND=r8), INTENT(OUT  ) :: ROFF
         ZDEPTH  , & !REAL(KIND=r8), INTENT(IN   ) :: ZDEPTH  (3)    
         POROS   , & !REAL(KIND=r8), INTENT(IN   ) :: POROS
         CCX     , & !REAL(KIND=r8), INTENT(OUT  ) :: CCX
         CG      , & !REAL(KIND=r8), INTENT(OUT  ) :: CG 
         SATCO   , & !REAL(KIND=r8), INTENT(IN   ) :: SATCO 
         SATCAP  , & !REAL(KIND=r8), INTENT(IN   ) :: SATCAP  (2)
         SPWET   , & !REAL(KIND=r8), INTENT(OUT  ) :: SPWET 
         EXTK    , & !REAL(KIND=r8), INTENT(IN   ) :: EXTK    (2,3,2)
         RNOFFS  , & !REAL(KIND=r8), INTENT(INOUT) :: RNOFFS
         FILTR   , & !REAL(KIND=r8), INTENT(INOUT) :: FILTR
         SMELT     ) !REAL(KIND=r8), INTENT(OUT  ) :: SMELT
    !
    CALL TEMRS1( &
         DTT     , &!REAL(KIND=r8), INTENT(IN   ) :: DTT
         TC      , &!REAL(KIND=r8), INTENT(INOUT) :: TC
         TGS     , &!REAL(KIND=r8), INTENT(INOUT) :: TGS
         TD      , &!REAL(KIND=r8), INTENT(IN   ) :: TD
         TA      , &!REAL(KIND=r8), INTENT(INOUT) :: TA
         TM      , &!REAL(KIND=r8), INTENT(IN   ) :: TM
         QM      , &!REAL(KIND=r8), INTENT(IN   ) :: QM
         EM      , &!REAL(KIND=r8), INTENT(IN   ) :: EM
         PSUR    , &!REAL(KIND=r8), INTENT(IN   ) :: PSURF
         WWW     , &!REAL(KIND=r8), INTENT(IN   ) :: WWW(3)
         CAPAC   , &!REAL(KIND=r8), INTENT(IN   ) :: CAPAC(2)
         SATCAP  , &!REAL(KIND=r8), INTENT(IN   ) :: SATCAP(2)
         DTC     , &!REAL(KIND=r8), INTENT(OUT  ) :: DTC
         DTG     , &!REAL(KIND=r8), INTENT(OUT  ) :: DTG
         RA      , &!REAL(KIND=r8), INTENT(OUT  ) :: RA
         RST     , &!REAL(KIND=r8), INTENT(INOUT) :: RST(2)
         ZDEPTH  , &!REAL(KIND=r8), INTENT(IN   ) :: ZDEPTH(3)
         BEE     , &!REAL(KIND=r8), INTENT(IN   ) :: BEE
         PHSAT   , &!REAL(KIND=r8), INTENT(IN   ) :: PHSAT
         POROS   , &!REAL(KIND=r8), INTENT(IN   ) :: POROS  
         XDD     , &!REAL(KIND=r8), INTENT(INOUT) :: D
         Z0      , &!REAL(KIND=r8), INTENT(INOUT) :: Z0
         RDC     , &!REAL(KIND=r8), INTENT(INOUT) :: RDC 
         RBC     , &!REAL(KIND=r8), INTENT(INOUT) :: RBC
         VCOVER  , &!REAL(KIND=r8), INTENT(INOUT) :: VCOVER(2)
         Z2      , &!REAL(KIND=r8), INTENT(IN   ) :: Z2 
         ZLT     , &!REAL(KIND=r8), INTENT(IN   ) :: ZLAI(2)
         DEFAC   , &!REAL(KIND=r8), INTENT(IN   ) :: DEFAC(2)
         TU      , &!REAL(KIND=r8), INTENT(IN   ) :: TU(2)
         TL      , &!REAL(KIND=r8), INTENT(IN   ) :: TL(2) 
         TOPT    , &!REAL(KIND=r8), INTENT(IN   ) :: TOPT(2)
         RSTFAC  , &!REAL(KIND=r8), INTENT(INOUT) :: RSTFAC(2,4)
         NROOT   , &!INTEGER, INTENT(IN) :: NROOT 
         ROOTD   , &!REAL(KIND=r8), INTENT(IN   ) :: ROOTD(2)
         PHSOIL  , &!REAL(KIND=r8), INTENT(IN   ) :: PHSOIL(3) 
         ROOTP   , &!REAL(KIND=r8), INTENT(IN   ) :: ROOTP(3)
         PH1     , &!REAL(KIND=r8), INTENT(IN   ) :: PH1(2)
         PH2     , &!REAL(KIND=r8), INTENT(IN   ) :: PH2(2)
         ECT     , &!REAL(KIND=r8), INTENT(OUT  ) :: ECT 
         ECI     , &!REAL(KIND=r8), INTENT(OUT  ) :: ECI 
         EGT     , &!REAL(KIND=r8), INTENT(OUT  ) :: EGT 
         EGI     , &!REAL(KIND=r8), INTENT(OUT  ) :: EGI 
         EGS     , &!REAL(KIND=r8), INTENT(OUT  ) :: EGS 
         HC      , &!REAL(KIND=r8), INTENT(OUT  ) :: HC 
         HG      , &!REAL(KIND=r8), INTENT(OUT  ) :: HG 
         EC      , &!REAL(KIND=r8), INTENT(OUT  ) :: EC 
         EG      , &!REAL(KIND=r8), INTENT(OUT  ) :: EG 
         EA      , &!REAL(KIND=r8), INTENT(OUT  ) :: EA 
         RADT    , &!REAL(KIND=r8), INTENT(INOUT) :: RADT(2)
         CHF     , &!REAL(KIND=r8), INTENT(OUT  ) :: CHF 
         SHF     , &!REAL(KIND=r8), INTENT(OUT  ) :: SHF 
         ALBEDO  , &!REAL(KIND=r8), INTENT(IN   ) :: ALBEDO(2,3,2)
         ZLWUP   , &!REAL(KIND=r8), INTENT(INOUT) :: ZLWUP 
         THERMK  , &!REAL(KIND=r8), INTENT(IN   ) :: THERMK   
         RHOAIR  , &!REAL(KIND=r8), INTENT(IN   ) :: RHOAIR   
         ZWIND   , &!REAL(KIND=r8), INTENT(IN   ) :: ZWIND 
         UM      , &!REAL(KIND=r8), INTENT(IN   ) :: UM 
         USTAR   , &!REAL(KIND=r8), INTENT(OUT  ) :: USTAR 
         CCX     , &!REAL(KIND=r8), INTENT(IN   ) :: CCX 
         CG      , &!REAL(KIND=r8), INTENT(IN   ) :: CG 
         ISNOW   , &!INTEGER, INTENT(IN) :: ISNOW 
         SNOWDEN , &!REAL(KIND=r8), INTENT(IN   ) :: SNOWDEN  
         BPS     , &!REAL(KIND=r8), INTENT(IN   ) :: BPS 
         rib     , &!REAL(KIND=r8), INTENT(OUT  ) :: rib 
         CU      , &!REAL(KIND=r8), INTENT(OUT  ) :: CU 
         XCT     , &!REAL(KIND=r8), INTENT(OUT  ) :: XCT 
         flup      )!REAL(KIND=r8), INTENT(INOUT) :: flup 
    !
    CALL UPDAT1_ICE( &
         DTT     , &! REAL(KIND=r8), INTENT(IN   ) :: DTT
         TC      , &! REAL(KIND=r8), INTENT(INOUT) :: TC
         TGS     , &! REAL(KIND=r8), INTENT(INOUT) :: TGS
         TD      , &! REAL(KIND=r8), INTENT(INOUT) :: TD
         CAPAC   , &! REAL(KIND=r8), INTENT(INOUT) :: CAPAC(2)
         DTC     , &! REAL(KIND=r8), INTENT(IN   ) :: DTC
         DTG     , &! REAL(KIND=r8), INTENT(IN   ) :: DTG
         ECT     , &! REAL(KIND=r8), INTENT(INOUT) :: ECT
         ECI     , &! REAL(KIND=r8), INTENT(INOUT) :: ECI
         EGT     , &! REAL(KIND=r8), INTENT(INOUT) :: EGT
         EGI     , &! REAL(KIND=r8), INTENT(INOUT) :: EGI
         EGS     , &! REAL(KIND=r8), INTENT(IN   ) :: EGS
         HC      , &! REAL(KIND=r8), INTENT(IN   ) :: HC
         HG      , &! REAL(KIND=r8), INTENT(IN   ) :: HG
         HFLUX   , &! REAL(KIND=r8), INTENT(OUT  ) :: HFLUX
         ETMASS  , &! REAL(KIND=r8), INTENT(OUT  ) :: ETMASS  
         FILTR   , &! REAL(KIND=r8), INTENT(INOUT) :: FILTR
         SOILDIF , &! REAL(KIND=r8), INTENT(INOUT) :: SOILDIF 
         SOILDRA , &! REAL(KIND=r8), INTENT(INOUT) :: SOILDRA 
         ROFF    , &! REAL(KIND=r8), INTENT(INOUT) :: ROFF
         RNOFFB  , &! REAL(KIND=r8), INTENT(INOUT) :: RNOFFB  
         RNOFFS  , &! REAL(KIND=r8), INTENT(INOUT) :: RNOFFS  
         NROOT   , &! INTEGER, INTENT(IN) :: NROOT
         ROOTD   , &! REAL(KIND=r8), INTENT(IN   ) :: ROOTD(2)
         ROOTP   , &! REAL(KIND=r8), INTENT(IN   ) :: ROOTP(3)
         POROS   , &! REAL(KIND=r8), INTENT(IN   ) :: POROS
         BEE     , &! REAL(KIND=r8), INTENT(IN   ) :: BEE
         SATCO   , &! REAL(KIND=r8), INTENT(IN   ) :: SATCO
         SLOPE   , &! REAL(KIND=r8), INTENT(IN   ) :: SLOPE
         PHSAT   , &! REAL(KIND=r8), INTENT(IN   ) :: PHSAT
         ZDEPTH  , &! REAL(KIND=r8), INTENT(IN   ) :: ZDEPTH  (3)
         WWW     , &! REAL(KIND=r8), INTENT(INOUT) :: WWW(3) 
         CCX     , &! REAL(KIND=r8), INTENT(IN   ) :: CCX
         CG      , &! REAL(KIND=r8), INTENT(IN   ) :: CG
         CHF     , &! REAL(KIND=r8), INTENT(IN   ) :: CHF
         SHF     , &! REAL(KIND=r8), INTENT(IN   ) :: SHF
         SMELT     )! REAL(KIND=r8), INTENT(INOUT) :: SMELT
    !***
    POROS=POROSAVE
    TD  = MAX(MIN(TD ,273.15_r8),248.15_r8)
    TC  = MAX(MIN(TC ,273.15_r8),248.15_r8)
    TGS = MAX(MIN(TGS,273.15_r8),248.15_r8)
    !***
    !
    !------------------------------------------------------------------------
    SOILM=(WWW(1)*ZDEPTH(1)+WWW(2)*ZDEPTH(2)+WWW(3)*ZDEPTH(3))*POROS
    !------------------------------------------------------------------------
    rmi=CU*USTAR
    rhi=XCT*USTAR
    UMOM=RHOAIR*CU*USTAR*UMM
    VMOM=RHOAIR*CU*USTAR*VMM
    HLFLX= ETMASS/RHOAIR/DTT
    HSFLX= HFLUX/CPAIR/RHOAIR/DTT
    ULWSF1=TGEFF*TGEFF*TGEFF*TGEFF*STEFAN
    Q2M=0.622_r8*EA/(PSURF-EA)
    EVAP=ETMASS*HLAT
    CM=(USTAR*USTAR)/(UM*UM)
    CH=1/(UM*RA)
    !
    FM=VKC/CU
    !      FH=VKC/CT   !fds corrected (02/2012)
    FH=VKC/XCT
    !
    !
    ELATEN=EVAP/DTT
    XHLFLX=ELATEN/HLAT
    GHTFLX=CHF+SHF
    !=====================================================================
    xhsflx=(hc+hg)/dtt
    !=====================================================================
    !
    WWW1=WWW(1)*POROS
    WWW2=WWW(2)*POROS
    WWW3=WWW(3)*POROS
    SNOA  = CAPAC(2)
    SNOB  = CAPAC(1)
    SALB11=SALB(1,1)
    SALB12=SALB(1,2)
    SALB21=SALB(2,1)
    SALB22=SALB(2,2)
    !
    ! later for output
    !
    xlhf = elaten
    xshf = xhsflx
    xghf = ghtflx
    xsdn = fsdown
    xsup = fsup
    xldn = fldown
    xlup = flup
    xwat = soilm
    xxz0 = z0
    xveg = float(itype)

    tsurf= TGS
    TC_SeaIce   (ii,latco) = TC
    TGS_SeaIce  (ii,latco) = TGS
    TD_SeaIce   (ii,latco) = TD
    TA_SeaIce   (ii,latco) = TA
    SNOA_SeaIce (ii,latco) = SNOA
    SNOB_SeaIce (ii,latco) = SNOB

    !
    !------------------------------------------------------
  END SUBROUTINE SEAICE
  !------------------------------------------------------

  !=======================================================================
  !
  SUBROUTINE UPDAT1_ICE(  &
       DTT     , &! REAL(KIND=r8), INTENT(IN   ) :: DTT
       TC      , &! REAL(KIND=r8), INTENT(INOUT) :: TC
       TGS     , &! REAL(KIND=r8), INTENT(INOUT) :: TGS
       TD      , &! REAL(KIND=r8), INTENT(INOUT) :: TD
       CAPAC   , &! REAL(KIND=r8), INTENT(INOUT) :: CAPAC(2)
       DTC     , &! REAL(KIND=r8), INTENT(IN   ) :: DTC
       DTG     , &! REAL(KIND=r8), INTENT(IN   ) :: DTG
       ECT     , &! REAL(KIND=r8), INTENT(INOUT) :: ECT
       ECI     , &! REAL(KIND=r8), INTENT(INOUT) :: ECI
       EGT     , &! REAL(KIND=r8), INTENT(INOUT) :: EGT
       EGI     , &! REAL(KIND=r8), INTENT(INOUT) :: EGI
       EGS     , &! REAL(KIND=r8), INTENT(IN   ) :: EGS
       HC      , &! REAL(KIND=r8), INTENT(IN   ) :: HC
       HG      , &! REAL(KIND=r8), INTENT(IN   ) :: HG
       HFLUX   , &! REAL(KIND=r8), INTENT(OUT  ) :: HFLUX
       ETMASS  , &! REAL(KIND=r8), INTENT(OUT  ) :: ETMASS  
       FILTR   , &! REAL(KIND=r8), INTENT(INOUT) :: FILTR
       SOILDIF , &! REAL(KIND=r8), INTENT(INOUT) :: SOILDIF 
       SOILDRA , &! REAL(KIND=r8), INTENT(INOUT) :: SOILDRA 
       ROFF    , &! REAL(KIND=r8), INTENT(INOUT) :: ROFF
       RNOFFB  , &! REAL(KIND=r8), INTENT(INOUT) :: RNOFFB  
       RNOFFS  , &! REAL(KIND=r8), INTENT(INOUT) :: RNOFFS  
       NROOT   , &! INTEGER, INTENT(IN) :: NROOT
       ROOTD   , &! REAL(KIND=r8), INTENT(IN   ) :: ROOTD(2)
       ROOTP   , &! REAL(KIND=r8), INTENT(IN   ) :: ROOTP(3)
       POROS   , &! REAL(KIND=r8), INTENT(IN   ) :: POROS
       BEE     , &! REAL(KIND=r8), INTENT(IN   ) :: BEE
       SATCO   , &! REAL(KIND=r8), INTENT(IN   ) :: SATCO
       SLOPE   , &! REAL(KIND=r8), INTENT(IN   ) :: SLOPE
       PHSAT   , &! REAL(KIND=r8), INTENT(IN   ) :: PHSAT
       ZDEPTH  , &! REAL(KIND=r8), INTENT(IN   ) :: ZDEPTH  (3)
       WWW     , &! REAL(KIND=r8), INTENT(INOUT) :: WWW(3) 
       CCX     , &! REAL(KIND=r8), INTENT(IN   ) :: CCX
       CG      , &! REAL(KIND=r8), INTENT(IN   ) :: CG
       CHF     , &! REAL(KIND=r8), INTENT(IN   ) :: CHF
       SHF     , &! REAL(KIND=r8), INTENT(IN   ) :: SHF
       SMELT     )! REAL(KIND=r8), INTENT(INOUT) :: SMELT
    !                                                         12 AUGUST 2000
    !=======================================================================
    !
    !     UPDATING OF SOIL MOISTURE STORES AND INTERCEPTION CAPACITY
    !
    !-----------------------------------------------------------------------
    !----------------------------------------------------------------------
    REAL(KIND=r8), INTENT(IN   ) :: DTT
    REAL(KIND=r8), INTENT(INOUT) :: TC
    REAL(KIND=r8), INTENT(INOUT) :: TGS
    REAL(KIND=r8), INTENT(INOUT) :: TD
    REAL(KIND=r8), INTENT(INOUT) :: CAPAC(2)
    REAL(KIND=r8), INTENT(IN   ) :: DTC
    REAL(KIND=r8), INTENT(IN   ) :: DTG
    REAL(KIND=r8), INTENT(INOUT) :: ECT
    REAL(KIND=r8), INTENT(INOUT) :: ECI
    REAL(KIND=r8), INTENT(INOUT) :: EGT
    REAL(KIND=r8), INTENT(INOUT) :: EGI
    REAL(KIND=r8), INTENT(IN   ) :: EGS
    REAL(KIND=r8), INTENT(IN   ) :: HC
    REAL(KIND=r8), INTENT(IN   ) :: HG
    REAL(KIND=r8), INTENT(OUT  ) :: HFLUX
    REAL(KIND=r8), INTENT(OUT  ) :: ETMASS  
    REAL(KIND=r8), INTENT(INOUT) :: FILTR
    REAL(KIND=r8), INTENT(INOUT) :: SOILDIF 
    REAL(KIND=r8), INTENT(INOUT) :: SOILDRA 
    REAL(KIND=r8), INTENT(INOUT) :: ROFF
    REAL(KIND=r8), INTENT(INOUT) :: RNOFFB  
    REAL(KIND=r8), INTENT(INOUT) :: RNOFFS  
    INTEGER, INTENT(IN) :: NROOT
    REAL(KIND=r8), INTENT(IN   ) :: ROOTD(2)
    REAL(KIND=r8), INTENT(IN   ) :: ROOTP(3)
    REAL(KIND=r8), INTENT(IN   ) :: POROS
    REAL(KIND=r8), INTENT(IN   ) :: BEE
    REAL(KIND=r8), INTENT(IN   ) :: SATCO
    REAL(KIND=r8), INTENT(IN   ) :: SLOPE
    REAL(KIND=r8), INTENT(IN   ) :: PHSAT
    REAL(KIND=r8), INTENT(IN   ) :: ZDEPTH  (3)
    REAL(KIND=r8), INTENT(INOUT) :: WWW(3) 
    REAL(KIND=r8), INTENT(IN   ) :: CCX
    REAL(KIND=r8), INTENT(IN   ) :: CG
    REAL(KIND=r8), INTENT(IN   ) :: CHF
    REAL(KIND=r8), INTENT(IN   ) :: SHF
    REAL(KIND=r8), INTENT(INOUT) :: SMELT

    INTEGER ::i ,IL,IVEG
    REAL(KIND=r8)  ::  SNOWW(2), aaa(2), bbb(2), ccc(2), qqq(2)
    REAL(KIND=r8)  ::  EF(3),   temw(3), temwp(3), temwpp(3)
    REAL(KIND=r8)  ::  ABSOIL
    REAL(KIND=r8)  ::  AREAS
    REAL(KIND=r8)  ::  AVK
    REAL(KIND=r8)  ::  AVKMAX
    REAL(KIND=r8)  ::  AVKMIN
    REAL(KIND=r8)  ::  CCT
    REAL(KIND=r8)  ::  CHANGE
    REAL(KIND=r8)  ::  DEFICIT
    REAL(KIND=r8)  ::  DENOM
    REAL(KIND=r8)  ::  DIV
    REAL(KIND=r8)  ::  DPDW
    REAL(KIND=r8)  ::  DPDWDZ
    REAL(KIND=r8)  ::  DTF2
    REAL(KIND=r8)  ::  DTF
    REAL(KIND=r8)  ::  DTIME1
    REAL(KIND=r8)  ::  DTIME2
    REAL(KIND=r8)  ::  DTS
    REAL(KIND=r8)  ::  ECMASS
    REAL(KIND=r8)  ::  EFT
    REAL(KIND=r8)  ::  EGMASS
    REAL(KIND=r8)  ::  EXCESS
    REAL(KIND=r8)  ::  FACKS
    REAL(KIND=r8)  ::  FCAP
    REAL(KIND=r8)  ::  FLUX
    REAL(KIND=r8)  ::  FLUXEF
    REAL(KIND=r8)  ::  HF
    REAL(KIND=r8)  ::  PMAX
    REAL(KIND=r8)  ::  PMIN
    REAL(KIND=r8)  ::  POWS
    REAL(KIND=r8)  ::  PROPS
    REAL(KIND=r8)  ::  Q3G
    REAL(KIND=r8)  ::  QMAX
    REAL(KIND=r8)  ::  QMIN
    REAL(KIND=r8)  ::  RDENOM
    REAL(KIND=r8)  ::  RSAME
    REAL(KIND=r8)  ::  SNOFAC
    REAL(KIND=r8)  ::  SPWET
    REAL(KIND=r8)  ::  TGG
    REAL(KIND=r8)  ::  TN
    REAL(KIND=r8)  ::  TOTDEP
    REAL(KIND=r8)  ::  TS
    REAL(KIND=r8)  ::  TSNOW
    REAL(KIND=r8)  ::  TTA
    REAL(KIND=r8)  ::  TTB
    REAL(KIND=r8)  ::  WMAX
    REAL(KIND=r8)  ::  WMIN
    REAL(KIND=r8)  ::  ZMELT
    HFLUX=0.0_r8;
    ETMASS=0.0_r8;
    SNOWW=0.0_r8; aaa=0.0_r8; bbb=0.0_r8;ccc=0.0_r8; qqq=0.0_r8;
    EF=0.0_r8;   temw=0.0_r8; temwp=0.0_r8; temwpp=0.0_r8;
    ABSOIL=0.0_r8;AREAS=0.0_r8;AVK=0.0_r8;
    AVKMAX=0.0_r8;AVKMIN=0.0_r8;CCT=0.0_r8;CHANGE=0.0_r8;
    DEFICIT=0.0_r8;DENOM=0.0_r8;DIV=0.0_r8;DPDW=0.0_r8;
    DPDWDZ=0.0_r8;DTF2=0.0_r8;DTF=0.0_r8;DTIME1=0.0_r8;
    DTIME2=0.0_r8;DTS=0.0_r8;ECMASS=0.0_r8;EFT=0.0_r8;
    EGMASS=0.0_r8;EXCESS=0.0_r8;FACKS=0.0_r8;FCAP=0.0_r8;
    FLUX=0.0_r8;FLUXEF=0.0_r8;HF=0.0_r8;PMAX=0.0_r8;
    PMIN=0.0_r8;POWS=0.0_r8;PROPS=0.0_r8;Q3G=0.0_r8;QMAX=0.0_r8;QMIN=0.0_r8;
    RDENOM=0.0_r8;RSAME=0.0_r8;SNOFAC=0.0_r8;SPWET=0.0_r8;
    TGG=0.0_r8;TN=0.0_r8;TOTDEP=0.0_r8;TS=0.0_r8;TSNOW=0.0_r8;TTA=0.0_r8;
    TTB=0.0_r8;WMAX=0.0_r8;WMIN=0.0_r8;ZMELT=0.0_r8;
    !FLTGGUX
    !----------------------------------------------------------------------
    !     EVAPORATION LOSSES ARE EXPRESSED IN J M-2 : WHEN DIVIDED BY
    !     ( HLAT*1000.) LOSS IS IN M M-2
    !     MASS TERMS ARE IN KG M-2 DT-1
    !----------------------------------------------------------------------
    !
    SNOFAC = HLAT / ( HLAT + SNOMEL /1000.0_r8 )
    FACKS = 1.0_r8
    IF ( (TC-DTC) .LE. TF ) FACKS = SNOFAC
    IF ( (ECT+ECI) .GT. 0.0_r8) GO TO 100
    ECI = ECT + ECI
    ECT = 0.0_r8
    FACKS = 1.0_r8 / FACKS
100 CAPAC(1)=CAPAC(1) - ECI*FACKS/HLAT/1000.0_r8
    !
    ECMASS = ( ECT + ECI * FACKS ) / HLAT
    !
    FACKS = 1.0_r8
    IF ( (TGS-DTG) .LE. TF ) FACKS = SNOFAC
    IF ( (EGT+EGI) .GT. 0.0_r8 ) GO TO 200
    EGI = EGT + EGI
    EGT = 0.0_r8
    FACKS = 1.0_r8 / FACKS
200 CAPAC(2)=CAPAC(2) - EGI*FACKS/HLAT/1000.0_r8
    !
    EGMASS = ( EGT + EGS + EGI * FACKS ) / HLAT
    !
    ETMASS = ECMASS + EGMASS
    !
    HFLUX =  HC + HG 
    !
    !----------------------------------------------------------------------
    !      DUMPING OF SMALL CAPAC VALUES ONTO SOIL SURFACE STORE
    !----------------------------------------------------------------------
    !
    DO  IVEG = 1, 2
       IF ( CAPAC(IVEG) .GT. 0.000001_r8 ) GO TO 300
       FILTR = FILTR + CAPAC(IVEG)
       WWW(1) = WWW(1) + CAPAC(IVEG) / ( POROS*ZDEPTH(1) )
       CAPAC(IVEG) = 0.0_r8
300    CONTINUE
    END DO!1000  CONTINUE
    !----------------------------------------------------------------------
    !     SNOWMELT / REFREEZE CALCULATION
    !----------------------------------------------------------------------
    !
    !     CALCULATION OF SNOWMELT AND MODIFICATION OF TEMPERATURES
    !     N.B. THIS VERSION DEALS WITH REFREEZING OF WATER
    !
    !-----------------------------------------------------------------------
    !
    DO  IVEG = 1, 2   !   DO 7000 IVEG = 1, 2
       !
       CCT = CCX
       TS = TC
       DTS = DTC
       FLUX = CHF
       IF ( IVEG .EQ. 1 ) GO TO 7100
       CCT = CG
       TS = TGS
       DTS = DTG
       FLUX = CCT * DTG / DTT

7100   CONTINUE
       !
       TTA = TS - DTS
       TTB = TS
       SNOWW(IVEG) = 0.0_r8
       IF ( TTA .LE. TF ) SNOWW(IVEG) = CAPAC(IVEG)
       CAPAC(IVEG) = CAPAC(IVEG) - SNOWW(IVEG)
       IF ( TTA .GT. TF .AND. TTB .GT. TF ) GO TO 7200
       IF ( TTA .LE. TF .AND. TTB .LE. TF ) GO TO 7200
       !
       DTF = TF - TTA
       DTIME1 = CCT * DTF /  FLUX
       HF = FLUX*(DTT-DTIME1)
       FCAP = - CAPAC(IVEG)  * SNOMEL
       SPWET = MIN( 5.0_r8 , SNOWW(IVEG) )
       IF ( DTS .GT. 0.0_r8 ) FCAP =  SPWET * SNOMEL
       DTIME2 = FCAP / FLUX
       DTF2 =   FLUX * (DTT-DTIME1-DTIME2)/CCT
       TN = TF + DTF2
       TS = TF - 0.1_r8
       IF (ABS(HF) .GE.ABS(FCAP) ) TS = TN
       CHANGE = HF
       IF (ABS(CHANGE) .GE.ABS(FCAP) ) CHANGE = FCAP
       !
       CHANGE = CHANGE / SNOMEL
       !
       IF (CHANGE.GT.0.0_r8) SMELT=CHANGE+SMELT
       !
       SNOWW(IVEG) = SNOWW(IVEG) - CHANGE
       CAPAC(IVEG) = CAPAC(IVEG) + CHANGE
       !
       IF ( IVEG .EQ. 1 ) TC = TS
       IF ( IVEG .EQ. 2 ) TGS = TS
       IF ( SNOWW(IVEG) .LT. 0.00001_r8 ) GO TO 7200
       ZMELT = 0.0_r8
       !     modified to force water into soil. Xue Feb. 1994
       ZMELT = CAPAC(IVEG)
       FILTR =  FILTR+ ZMELT
       WWW(1) = WWW(1) + ZMELT / ( POROS * ZDEPTH(1) )
       CAPAC(IVEG) = 0.0_r8
7200   CONTINUE
       !
       CAPAC(IVEG) = CAPAC(IVEG) + SNOWW(IVEG)
       !
    END DO !7000  CONTINUE
    !
    FLUXEF = SHF - CCT*DTG/DTT
    TD = TD + FLUXEF / ( CG * 2.0_r8 * SQRT ( PIE*365.0_r8 ) ) * DTT
    !
    change=0.0_r8
    !
    !----------------------------------------------------------------------
    !     BARE SOIL EVAPORATION LOSS
    !----------------------------------------------------------------------
    !
    FILTR = FILTR - EGS / HLAT / 1000.0_r8
    WWW(1) = WWW(1) - EGS / HLAT / 1000.0_r8 / ( POROS * ZDEPTH(1) )
    !
    !----------------------------------------------------------------------
    !   EXTRACTION OF TRANSPIRATION LOSS FROM ROOT ZONE
    !----------------------------------------------------------------------
    !
    DO  IVEG = 1, 2!DO 2000 IVEG = 1, 2
       !
       IF ( IVEG .EQ. 1 ) ABSOIL = ECT / HLAT / 1000.0_r8
       IF ( IVEG .EQ. 2 ) ABSOIL = EGT / HLAT / 1000.0_r8
       !
       IF (NROOT.EQ.1) THEN
          EF(2) = 0.0_r8
          EF(3) = 0.0_r8
          TOTDEP = ZDEPTH(1)
          !
          DO IL = 2, 3!  DO 3000 IL = 2, 3
             TOTDEP = TOTDEP + ZDEPTH(IL)
             !PK
             IF ( ROOTD(IVEG) <  TOTDEP ) THEN
                EF(IL) = ROOTD(IVEG) - TOTDEP + ZDEPTH(IL)
                EF(IL) = EF(IL) / ROOTD(IVEG)
                EXIT   !GO TO 600
             ELSE
                EF(IL) = ZDEPTH(IL) / ROOTD(IVEG)
                CYCLE
             END IF

             !PK 
             !
             !              IF ( ROOTD(IVEG) .LT. TOTDEP ) GO TO 400
             !
             !                EF(IL) = ZDEPTH(IL) / ROOTD(IVEG)
             !                GO TO 500
             !
             !400           CONTINUE!
             !
             !              EF(IL) = ROOTD(IVEG) - TOTDEP + ZDEPTH(IL)
             !              EF(IL) = EF(IL) / ROOTD(IVEG)
             !              GO TO 600
             !!
             !500      CONTINUE
          END DO !3000  CONTINUE
          !
          EFT = EF(2) + EF(3)
          !
          EFT = MAX(EFT,0.1E-5_r8)
          !
          EF(2) = EF(2) / EFT
          EF(3) = EF(3) / EFT
          !
          DO IL = 2, 3!      DO 4000 IL = 2, 3
             WWW(IL) = WWW(IL) - ABSOIL * EF(IL) / ( POROS * ZDEPTH(IL) )
          END DO  !4000  CONTINUE
       ELSE
          EF(1) = ROOTP(1)
          EF(2) = ROOTP(2)
          EF(3) = ROOTP(3)
          DO  IL = 1, 3!DO 4004 IL = 1, 3
             WWW(IL) = WWW(IL) - ABSOIL * EF(IL) / ( POROS * ZDEPTH(IL) )
          END DO!4004  CONTINUE
       END IF
       !
    END DO!2000  CONTINUE
    !
    !----------------------------------------------------------------------
    !
    !     CALCULATION OF INTERFLOW, INFILTRATION EXCESS AND LOSS TO
    !     GROUNDWATER .  ALL LOSSES ARE ASSIGNED TO VARIABLE 'ROFF' .
    !
    !----------------------------------------------------------------------
    !
    DO  IL = 1, 2  
       !IF ( WWW(IL) .GT. 0. ) GO TO 700
       IF ( WWW(IL) <= 0.0_r8 )THEN! GO TO 700

          WWW(IL+1) = WWW(IL+1) + WWW(IL) * ZDEPTH(IL)/ZDEPTH(IL+1)
          WWW(IL) = 0.0_r8
       END IF
       !700      CONTINUE
    END DO !5000  CONTINUE
    !
    !=======================================================================
    !    calculation of interflow, infiltration excess and loss to
    !    groundwater .  all losses are assigned to variable 'roff' .
    !----------------------------------------------------------------------
    !
    DO i = 1, 3
       !
       TEMW(I)   = MAX( 0.03_r8, WWW(I) )
       TEMWP(I)  = TEMW(I) ** ( -BEE )
       TEMWPP(I) = MIN( 1.0_r8, TEMW(I)) ** ( 2.0_r8*BEE+ 3.0_r8 )
    END DO!8000  CONTINUE
    !
    !-----------------------------------------------------------------------
    !
    !    calculation of gravitationally driven drainage from w(3) : taken
    !    as an integral of time varying conductivity.addition of liston
    !    baseflow term to original q3g to insure flow in
    !    dry season. modified liston baseflow constant scaled
    !    by available water.
    !
    !     q3g (q3) : equation (62) , SE-86
    !
    !-----------------------------------------------------------------------
    !
    POWS = 2.0_r8*BEE+2.0_r8
    Q3G = TEMW(3)**(-POWS) + SATCO/ZDEPTH(3)/POROS*SLOPE*POWS*DTT
    Q3G = Q3G ** ( 1.0_r8 / POWS )
    Q3G = - ( 1.0_r8 / Q3G - WWW(3) ) * POROS * ZDEPTH(3) / DTT
    Q3G = MAX( 0.0_r8, Q3G )
    Q3G = MIN( Q3G, WWW(3)*POROS*ZDEPTH(3)/DTT )
    !
    Q3G = Q3G + 0.002_r8*POROS*ZDEPTH(3)*0.5_r8 / 86400.0_r8 * WWW(3)
    !
    !----------------------------------------------------------------------
    !
    !    calculation of inter-layer exchanges of water due to gravitation
    !    and hydraulic gradient. the values of w(x) + dw(x) are used to
    !    calculate the potential gradients between layers.
    !    modified calculation of mean conductivities follows ME-82 ),
    !    reduces recharge flux to top layer.
    !
    !      dpdw           : estimated derivative of soil moisture potential
    !                       with respect to soil wetness. assumption of
    !                       gravitational drainage used to estimate likely
    !                       minimum wetness over the time step.
    !
    !      qqq  (q     )  : equation (61) , SE-86
    !             i,i+1
    !            -
    !      avk  (k     )  : equation (4.14) , ME-82
    !             i,i+1
    !
    !----------------------------------------------------------------------
    !
    WMAX = MAX( WWW(1), WWW(2), WWW(3), 0.05_r8 )
    WMAX = MIN( WMAX, 1.0_r8 )
    PMAX = WMAX**(-BEE)
    WMIN = (PMAX-2.0_r8/( PHSAT*(ZDEPTH(1)+2.0_r8*ZDEPTH(2)+ZDEPTH(3))))    &
         **(-1.0_r8/BEE)
    WMIN = MIN( WWW(1), WWW(2), WWW(3), WMIN )
    WMIN = MAX( WMIN, 0.02_r8 )
    PMIN = WMIN**(-BEE)
    DPDW = PHSAT*( PMAX-PMIN )/( WMAX-WMIN )
    !
    DO  I = 1, 2 ! DO 8200 I = 1, 2
       !
       RSAME = 0.0_r8
       AVK  = TEMWP(I)*TEMWPP(I) - TEMWP(I+1)*TEMWPP(I+1)
       DIV  = TEMWP(I+1) - TEMWP(I)
       IF ( ABS(DIV) .LT. 1.E-6_r8 ) RSAME = 1.0_r8
       AVK = SATCO*AVK / ( ( 1.0_r8 + 3.0_r8/BEE ) * DIV + RSAME )
       AVKMIN = SATCO * MIN( TEMWPP(I), TEMWPP(I+1) )
       AVKMAX = SATCO * MAX( TEMWPP(I), TEMWPP(I+1) )*1.01_r8
       AVK = MAX( AVK, AVKMIN )
       AVK = MIN( AVK, AVKMAX )
       !
       !-----------------------------------------------------------------------
       !     conductivities and base flow reduced when temperature drops below
       !     freezing.
       !-----------------------------------------------------------------------
       !
       TSNOW = MIN ( TF-0.01_r8, TGS )
       AREAS = MIN (0.999_r8,13.2_r8*SNOWW(2))
       TGG = TSNOW*AREAS + TGS*(1.0_r8-AREAS)
       TS    = TGG*(2-I) + TD*(I-1)
       PROPS = ( TS-(TF-10.0_r8) ) / 10.0_r8
       PROPS = MAX( 0.05_r8, MIN( 1.0_r8, PROPS ) )
       AVK  = AVK * PROPS
       Q3G  = Q3G * PROPS
       !
       !-----------------------------------------------------------------------
       !     backward implicit calculation of flows between soil layers.
       !-----------------------------------------------------------------------
       !
       DPDWDZ = DPDW * 2.0_r8/( ZDEPTH(I) + ZDEPTH(I+1) )
       AAA(I) = 1.0_r8 + AVK*DPDWDZ*( 1.0_r8/ZDEPTH(I)+1.0_r8/ZDEPTH(I+1) )         &
            *DTT/POROS
       BBB(I) =-AVK *   DPDWDZ * 1.0_r8/ZDEPTH(2)*DTT/POROS
       CCC(I) = AVK * ( DPDWDZ * ( WWW(I)-WWW(I+1) ) + 1.0_r8 +             &
            (I-1)*DPDWDZ*Q3G*1.0_r8/ZDEPTH(3)*DTT/POROS )
    END DO!8200  CONTINUE
    !
    DENOM  = ( AAA(1)*AAA(2) - BBB(1)*BBB(2) )
    RDENOM = 0.0_r8
    IF ( ABS(DENOM) .LT. 1.E-6_r8 ) RDENOM = 1.0_r8
    RDENOM = ( 1.0_r8-RDENOM)/( DENOM + RDENOM )
    QQQ(1)   = ( AAA(2)*CCC(1) - BBB(1)*CCC(2) ) * RDENOM
    QQQ(2)   = ( AAA(1)*CCC(2) - BBB(2)*CCC(1) ) * RDENOM
    !
    !-----------------------------------------------------------------------
    !     update wetness of each soil moisture layer due to layer interflow
    !        and base flow.
    !-----------------------------------------------------------------------
    !
    WWW(3) = WWW(3) - Q3G*DTT/(POROS*ZDEPTH(3))
    ROFF = ROFF + Q3G * DTT
    !
    DO  I = 1, 2 !DO 8300 I = 1, 2
       !
       QMAX   =  WWW(I)   * (POROS*ZDEPTH(I)  /DTT)
       QMIN   = -WWW(I+1) * (POROS*ZDEPTH(I+1)/DTT)
       QQQ(I) = MIN( QQQ(I),QMAX)
       QQQ(I) = MAX( QQQ(I),QMIN)
       WWW(I)   =   WWW(I)   - QQQ(I)/(POROS*ZDEPTH(I)  /DTT)
       WWW(I+1) =   WWW(I+1) + QQQ(I)/(POROS*ZDEPTH(I+1)/DTT)
    END DO!8300  CONTINUE
    !
    !       *** LOAD water flow & root-zone drainage PILPS DATA
    SOILDIF=SOILDIF+QQQ(1)*DTT*1000.0_r8
    SOILDRA=SOILDRA+Q3G*DTT*1000.0_r8
    !
    DO I = 1, 3 !DO 8400 I = 1, 3
       EXCESS = MAX(0.0_r8,(WWW(I) - 1.0_r8))
       WWW(I) = WWW(I) - EXCESS
       ROFF   = ROFF   + EXCESS * POROS*ZDEPTH(I)
       !
       !       *** LOAD IN as root-drainage for PILPS
       IF (I.LT.2) THEN
          RNOFFS= RNOFFS+ 1000.0_r8*EXCESS*POROS*ZDEPTH(I)
       ELSE
          RNOFFB= RNOFFB+ 1000.0_r8*EXCESS*POROS*ZDEPTH(I)
       ENDIF
    END DO!8400  CONTINUE
    !
    !-----------------------------------------------------------------------
    !     prevent negative values of www(i)
    !-----------------------------------------------------------------------
    !
    DO  I = 1,2!  DO 8402 I = 1,2
       DEFICIT   = MAX (0.0_r8,(1.E-12_r8 - WWW(I)))
       IF (I.EQ.1) SOILDIF=SOILDIF-DEFICIT*                            &
            ZDEPTH(1)*POROS
       WWW (I)   = WWW(I) + DEFICIT
       WWW (I+1) = WWW(I+1) - DEFICIT * ZDEPTH(I) / ZDEPTH (I+1)
    END DO! 8402 CONTINUE
    WWW(3)    = MAX (WWW(3),1.E-12_r8)
    !
    !800   CONTINUE
    !
    IF (WWW(1) .GT.1.0_r8) THEN
       WWW(2) = WWW(2) + (WWW(1)-1.0_r8) * ZDEPTH(1)/                   &
            ZDEPTH(2)
       SOILDIF=SOILDIF+(WWW(1)-1.0_r8)*ZDEPTH(1)                        &
            *POROS*1000.0_r8
       WWW(1) = 1.0_r8
    END IF
    IF (WWW(2) .GT.1.0_r8) WWW(3) = WWW(3) + (WWW(2)-1.0_r8) *               &
         ZDEPTH(2) / ZDEPTH(3)
    !
    !       *** LOAD IN AS PILP ROOT DRAINAGE
    IF (WWW(2) .GT.1.0_r8) WWW(2) = 1.0_r8
    IF (WWW(3) .GT.1.0_r8) THEN
       ROFF   = ROFF + (WWW(3)-1.0_r8)*POROS*ZDEPTH(3)
       RNOFFB=RNOFFB+((WWW(3)-1.0_r8)*ZDEPTH(3)*                        &
            POROS*1000.0_r8)
       WWW(3) = 1.0_r8
    END IF
    !
    !------------------------------------------------------
  END SUBROUTINE UPDAT1_ICE
  !------------------------------------------------------


  REAL(KIND=r8) FUNCTION E(X)
    IMPLICIT NONE
    REAL(KIND=r8), INTENT(IN   ) :: X 
    E = EXP( 21.18123_r8 - 5418.0_r8 / X ) / 0.622_r8
  END FUNCTION E

  REAL(KIND=r8) FUNCTION GE(X)
    IMPLICIT NONE
    REAL(KIND=r8), INTENT(IN   ) :: X 
    GE = EXP( 21.18123_r8 - 5418.0_r8 / X ) * 5418.0_r8  &
         / (X*X) / 0.622_r8
  END FUNCTION GE


  !=======================================================================
  !                                                                       
  SUBROUTINE TEMRS1                                                 &
       (DTT      , &!REAL(KIND=r8), INTENT(IN   ) :: DTT
       TC       , &!REAL(KIND=r8), INTENT(INOUT) :: TC
       TGS      , &!REAL(KIND=r8), INTENT(INOUT) :: TGS
       TD       , &!REAL(KIND=r8), INTENT(IN   ) :: TD
       TA       , &!REAL(KIND=r8), INTENT(INOUT) :: TA
       TM       , &!REAL(KIND=r8), INTENT(IN   ) :: TM
       QM       , &!REAL(KIND=r8), INTENT(IN   ) :: QM
       EM       , &!REAL(KIND=r8), INTENT(IN   ) :: EM
       PSURF    , &!REAL(KIND=r8), INTENT(IN   ) :: PSURF
       WWW      , &!REAL(KIND=r8), INTENT(IN   ) :: WWW(3)
       CAPAC    , &!REAL(KIND=r8), INTENT(IN   ) :: CAPAC(2)
       SATCAP   , &!REAL(KIND=r8), INTENT(IN   ) :: SATCAP(2)
       DTC      , &!REAL(KIND=r8), INTENT(OUT  ) :: DTC
       DTG      , &!REAL(KIND=r8), INTENT(OUT  ) :: DTG
       RA       , &!REAL(KIND=r8), INTENT(OUT  ) :: RA
       RST      , &!REAL(KIND=r8), INTENT(INOUT) :: RST(2)
       ZDEPTH   , &!REAL(KIND=r8), INTENT(IN   ) :: ZDEPTH(3)
       BEE      , &!REAL(KIND=r8), INTENT(IN   ) :: BEE
       PHSAT    , &!REAL(KIND=r8), INTENT(IN   ) :: PHSAT
       POROS    , &!REAL(KIND=r8), INTENT(IN   ) :: POROS  
       D        , &!REAL(KIND=r8), INTENT(INOUT) :: D           
       Z0       , &!REAL(KIND=r8), INTENT(INOUT) :: Z0
       RDC      , &!REAL(KIND=r8), INTENT(INOUT) :: RDC 
       RBC      , &!REAL(KIND=r8), INTENT(INOUT) :: RBC
       VCOVER   , &!REAL(KIND=r8), INTENT(INOUT) :: VCOVER(2)
       Z2       , &!REAL(KIND=r8), INTENT(IN   ) :: Z2 
       ZLAI     , &!REAL(KIND=r8), INTENT(IN   ) :: ZLAI(2)
       DEFAC    , &!REAL(KIND=r8), INTENT(IN   ) :: DEFAC(2)
       TU       , &!REAL(KIND=r8), INTENT(IN   ) :: TU(2)
       TL       , &!REAL(KIND=r8), INTENT(IN   ) :: TL(2) 
       TOPT     , &!REAL(KIND=r8), INTENT(IN   ) :: TOPT(2)
       RSTFAC   , &!REAL(KIND=r8), INTENT(INOUT) :: RSTFAC(2,4)
       NROOT    , &!INTEGER, INTENT(IN) :: NROOT 
       ROOTD    , &!REAL(KIND=r8), INTENT(IN   ) :: ROOTD(2)
       PHSOIL   , &!REAL(KIND=r8), INTENT(IN   ) :: PHSOIL(3) 
       ROOTP    , &!REAL(KIND=r8), INTENT(IN   ) :: ROOTP(3)
       PH1      , &!REAL(KIND=r8), INTENT(IN   ) :: PH1(2)
       PH2      , &!REAL(KIND=r8), INTENT(IN   ) :: PH2(2)
       ECT      , &!REAL(KIND=r8), INTENT(OUT  ) :: ECT 
       ECI      , &!REAL(KIND=r8), INTENT(OUT  ) :: ECI 
       EGT      , &!REAL(KIND=r8), INTENT(OUT  ) :: EGT 
       EGI      , &!REAL(KIND=r8), INTENT(OUT  ) :: EGI 
       EGS      , &!REAL(KIND=r8), INTENT(OUT  ) :: EGS 
       HC       , &!REAL(KIND=r8), INTENT(OUT  ) :: HC 
       HG       , &!REAL(KIND=r8), INTENT(OUT  ) :: HG 
       EC       , &!REAL(KIND=r8), INTENT(OUT  ) :: EC 
       EG       , &!REAL(KIND=r8), INTENT(OUT  ) :: EG 
       EA       , &!REAL(KIND=r8), INTENT(OUT  ) :: EA 
       RADT     , &!REAL(KIND=r8), INTENT(INOUT) :: RADT(2)
       CHF      , &!REAL(KIND=r8), INTENT(OUT  ) :: CHF 
       SHF      , &!REAL(KIND=r8), INTENT(OUT  ) :: SHF 
       ALBEDO   , &!REAL(KIND=r8), INTENT(IN   ) :: ALBEDO(2,3,2)
       ZLWUP    , &!REAL(KIND=r8), INTENT(INOUT) :: ZLWUP 
       THERMK   , &!REAL(KIND=r8), INTENT(IN   ) :: THERMK   
       RHOAIR   , &!REAL(KIND=r8), INTENT(IN   ) :: RHOAIR   
       ZWIND    , &!REAL(KIND=r8), INTENT(IN   ) :: ZWIND 
       UM       , &!REAL(KIND=r8), INTENT(IN   ) :: UM 
       USTAR    , &!REAL(KIND=r8), INTENT(OUT  ) :: USTAR 
       CCX      , &!REAL(KIND=r8), INTENT(IN   ) :: CCX 
       CG       , &!REAL(KIND=r8), INTENT(IN   ) :: CG 
       ISNOW    , &!INTEGER, INTENT(IN) :: ISNOW 
       SNOWDEN  , &!REAL(KIND=r8), INTENT(IN   ) :: SNOWDEN  
       BPS      , &!REAL(KIND=r8), INTENT(IN   ) :: BPS 
       rib      , &!REAL(KIND=r8), INTENT(OUT  ) :: rib 
       CU       , &!REAL(KIND=r8), INTENT(OUT  ) :: CU 
       XCT      , &!REAL(KIND=r8), INTENT(OUT  ) :: XCT 
       flup       )!REAL(KIND=r8), INTENT(INOUT) :: flup 

    !
    !=======================================================================
    ! ------------------------------------------------------------------7272
    !     A SIMPLIFIED VERSION (XUE ET AL. 1991)
    !     CORE ROUTINE: CALCULATION OF CANOPY AND GROUND TEMPERATURE
    !     INCREMENTS OVER TIME STEP, FLUXES DERIVED.
    !-----------------------------------------------------------------------
    !     SUBROUTINES IN THIS BLOCK : TEMRS1,DELRN,DELHF,DELEF,STRES1
    !-----------------------------------------------------------------------
    REAL(KIND=r8), INTENT(IN   ) :: DTT
    REAL(KIND=r8), INTENT(INOUT) :: TC
    REAL(KIND=r8), INTENT(INOUT) :: TGS
    REAL(KIND=r8), INTENT(IN   ) :: TD
    REAL(KIND=r8), INTENT(INOUT) :: TA
    REAL(KIND=r8), INTENT(IN   ) :: TM
    REAL(KIND=r8), INTENT(IN   ) :: QM
    REAL(KIND=r8), INTENT(IN   ) :: EM
    REAL(KIND=r8), INTENT(IN   ) :: PSURF
    REAL(KIND=r8), INTENT(IN   ) :: WWW(3)
    REAL(KIND=r8), INTENT(IN   ) :: CAPAC(2)
    REAL(KIND=r8), INTENT(IN   ) :: SATCAP(2)
    REAL(KIND=r8), INTENT(OUT  ) :: DTC
    REAL(KIND=r8), INTENT(OUT  ) :: DTG
    REAL(KIND=r8), INTENT(OUT  ) :: RA
    REAL(KIND=r8), INTENT(INOUT) :: RST(2)
    REAL(KIND=r8), INTENT(IN   ) :: ZDEPTH(3)
    REAL(KIND=r8), INTENT(IN   ) :: BEE
    REAL(KIND=r8), INTENT(IN   ) :: PHSAT
    REAL(KIND=r8), INTENT(IN   ) :: POROS  
    REAL(KIND=r8), INTENT(INOUT) :: D      
    REAL(KIND=r8), INTENT(INOUT) :: Z0
    REAL(KIND=r8), INTENT(INOUT) :: RDC 
    REAL(KIND=r8), INTENT(INOUT) :: RBC
    REAL(KIND=r8), INTENT(INOUT) :: VCOVER(2)
    REAL(KIND=r8), INTENT(IN   ) :: Z2 
    REAL(KIND=r8), INTENT(IN   ) :: ZLAI(2)
    REAL(KIND=r8), INTENT(IN   ) :: DEFAC(2)
    REAL(KIND=r8), INTENT(IN   ) :: TU(2)
    REAL(KIND=r8), INTENT(IN   ) :: TL(2) 
    REAL(KIND=r8), INTENT(IN   ) :: TOPT(2)
    REAL(KIND=r8), INTENT(INOUT) :: RSTFAC(2,4)
    INTEGER, INTENT(IN) :: NROOT 
    REAL(KIND=r8), INTENT(IN   ) :: ROOTD(2)
    REAL(KIND=r8), INTENT(IN   ) :: PHSOIL(3) 
    REAL(KIND=r8), INTENT(IN   ) :: ROOTP(3)
    REAL(KIND=r8), INTENT(IN   ) :: PH1(2)
    REAL(KIND=r8), INTENT(IN   ) :: PH2(2)
    REAL(KIND=r8), INTENT(OUT  ) :: ECT 
    REAL(KIND=r8), INTENT(OUT  ) :: ECI 
    REAL(KIND=r8), INTENT(OUT  ) :: EGT 
    REAL(KIND=r8), INTENT(OUT  ) :: EGI 
    REAL(KIND=r8), INTENT(OUT  ) :: EGS 
    REAL(KIND=r8), INTENT(OUT  ) :: HC 
    REAL(KIND=r8), INTENT(OUT  ) :: HG 
    REAL(KIND=r8), INTENT(OUT  ) :: EC 
    REAL(KIND=r8), INTENT(OUT  ) :: EG 
    REAL(KIND=r8), INTENT(OUT  ) :: EA 
    REAL(KIND=r8), INTENT(INOUT) :: RADT(2)
    REAL(KIND=r8), INTENT(OUT  ) :: CHF 
    REAL(KIND=r8), INTENT(OUT  ) :: SHF 
    REAL(KIND=r8), INTENT(IN   ) :: ALBEDO(2,3,2)
    REAL(KIND=r8), INTENT(INOUT) :: ZLWUP 
    REAL(KIND=r8), INTENT(IN   ) :: THERMK   
    REAL(KIND=r8), INTENT(IN   ) :: RHOAIR   
    REAL(KIND=r8), INTENT(IN   ) :: ZWIND 
    REAL(KIND=r8), INTENT(IN   ) :: UM 
    REAL(KIND=r8), INTENT(OUT  ) :: USTAR 
    REAL(KIND=r8), INTENT(IN   ) :: CCX 
    REAL(KIND=r8), INTENT(IN   ) :: CG 
    INTEGER, INTENT(IN) :: ISNOW 
    REAL(KIND=r8), INTENT(IN   ) :: SNOWDEN  
    REAL(KIND=r8), INTENT(IN   ) :: BPS 
    REAL(KIND=r8), INTENT(OUT  ) :: rib 
    REAL(KIND=r8), INTENT(OUT  ) :: CU 
    REAL(KIND=r8), INTENT(OUT  ) :: XCT 
    REAL(KIND=r8), INTENT(INOUT) :: flup 
    !
    !
    !  LOCAL
    !
    !
    REAL(KIND=r8) :: DRAG 

    REAL(KIND=r8) :: ZINC(3)
    REAL(KIND=r8) :: A2(3)
    REAL(KIND=r8) :: Y1(3)
    REAL(KIND=r8) :: ITEX(3)
    REAL(KIND=r8) :: RSTM(2)
    REAL(KIND=r8) :: AH
    REAL(KIND=r8) :: AK
    REAL(KIND=r8) :: ARGG
    REAL(KIND=r8) :: CCODTC
    REAL(KIND=r8) :: CCODTG
    REAL(KIND=r8) :: CCORHS
    REAL(KIND=r8) :: COC
    REAL(KIND=r8) :: COCT
    REAL(KIND=r8) :: COG1
    REAL(KIND=r8) :: COG2
    REAL(KIND=r8) :: COGS1
    REAL(KIND=r8) :: COGS2
    REAL(KIND=r8) :: COGT
    REAL(KIND=r8) :: CTNI
    REAL(KIND=r8) :: CUNI
    REAL(KIND=r8) :: D1
    REAL(KIND=r8) :: D2
    REAL(KIND=r8) :: DEADQM
    REAL(KIND=r8) :: DEADTC
    REAL(KIND=r8) :: DEADTG
    REAL(KIND=r8) :: DENOM
    REAL(KIND=r8) :: DEWC
    REAL(KIND=r8) :: DEWG
    REAL(KIND=r8) :: DROP
    REAL(KIND=r8) :: ECIDIF
    REAL(KIND=r8) :: ECPOT
    REAL(KIND=r8) :: ECDQM
    REAL(KIND=r8) :: ECDTC
    REAL(KIND=r8) :: ECDTG
    REAL(KIND=r8) :: ECF
    REAL(KIND=r8) :: EGDQM
    REAL(KIND=r8) :: EGDTC
    REAL(KIND=r8) :: EGDTG
    REAL(KIND=r8) :: EGF
    REAL(KIND=r8) :: EGIADD
    REAL(KIND=r8) :: EGIDIF
    REAL(KIND=r8) :: EGPOT
    REAL(KIND=r8) :: EGSMAX
    REAL(KIND=r8) :: ERIB
    REAL(KIND=r8) :: ETC
    REAL(KIND=r8) :: ETGS
    REAL(KIND=r8) :: FAC
    REAL(KIND=r8) :: FAC1
    REAL(KIND=r8) :: FAC2
    REAL(KIND=r8) :: FC
    REAL(KIND=r8) :: FG
    REAL(KIND=r8) ::  FIH
    REAL(KIND=r8) :: FINC
    REAL(KIND=r8) :: GCODTC
    REAL(KIND=r8) :: GCODTG
    REAL(KIND=r8) :: GCORHS
    REAL(KIND=r8) :: GETC
    REAL(KIND=r8) :: GETGS
    REAL(KIND=r8) :: HCDTC
    REAL(KIND=r8) :: HCDTG
    REAL(KIND=r8) :: HCDTM
    REAL(KIND=r8) :: HEND
    REAL(KIND=r8) :: HGDTC
    REAL(KIND=r8) :: HGDTG
    REAL(KIND=r8) :: HGDTM
    REAL(KIND=r8) :: HR
    REAL(KIND=r8) :: HRR
    REAL(KIND=r8) :: HT
    INTEGER :: I
    INTEGER :: ICOUNT
    INTEGER :: IFIRST
    INTEGER :: IONCE
    INTEGER :: IWALK
    INTEGER :: LX
    INTEGER :: NONPOS
    INTEGER :: NOX
    REAL(KIND=r8) :: PILPHR
    REAL(KIND=r8) :: PSIT
    REAL(KIND=r8) :: PSY
    REAL(KIND=r8) :: RB
    REAL(KIND=r8) :: RD
    REAL(KIND=r8) :: RCC
    REAL(KIND=r8) :: RCP
    REAL(KIND=r8) :: RESD
    REAL(KIND=r8) :: RESRBC
    REAL(KIND=r8) :: RESRDC
    REAL(KIND=r8) :: RESV2
    REAL(KIND=r8) :: RESZ0
    REAL(KIND=r8) :: RG
    REAL(KIND=r8) :: RNCDTC
    REAL(KIND=r8) :: RNCDTG
    REAL(KIND=r8) :: RNGDTC
    REAL(KIND=r8) :: RNGDTG
    REAL(KIND=r8) :: RSOIL
    REAL(KIND=r8) :: RSURF
    REAL(KIND=r8) :: SDEP
    REAL(KIND=r8) :: TAEN
    REAL(KIND=r8) :: TC3
    REAL(KIND=r8) :: TCEN
    REAL(KIND=r8) :: TEMDIF
    REAL(KIND=r8) :: TG3
    REAL(KIND=r8) :: TGEN
    REAL(KIND=r8) :: TGTA
    REAL(KIND=r8) :: TOP
    REAL(KIND=r8) :: TRIB
    REAL(KIND=r8) ::  U2
    REAL(KIND=r8) :: WC
    REAL(KIND=r8) :: WG
    REAL(KIND=r8) :: Y


    DTC=0.0_r8;DTG=0.0_r8;RA=0.0_r8;ECT =0.0_r8;ECI =0.0_r8;EGT =0.0_r8;   
    EGI =0.0_r8;EGS =0.0_r8;HC =0.0_r8;HG =0.0_r8;EC =0.0_r8;EG =0.0_r8;EA =0.0_r8;CHF =0.0_r8;
    SHF =0.0_r8;USTAR=0.0_r8;rib =0.0_r8;CU =0.0_r8;XCT =0.0_r8;

    DRAG =0.0_r8;ZINC=0.0_r8;A2=0.0_r8;Y1=0.0_r8;
    ITEX=0.0_r8;RSTM=0.0_r8;AH=0.0_r8;AK=0.0_r8;
    ARGG=0.0_r8;CCODTC=0.0_r8;CCODTG=0.0_r8;CCORHS=0.0_r8;
    COC=0.0_r8;COCT=0.0_r8;COG1=0.0_r8;COG2=0.0_r8;
    COGS1=0.0_r8;COGS2=0.0_r8;COGT=0.0_r8;CTNI=0.0_r8;
    CUNI=0.0_r8;D1=0.0_r8;D2=0.0_r8;DEADQM=0.0_r8;
    DEADTC=0.0_r8;DEADTG=0.0_r8;DENOM=0.0_r8;DEWC=0.0_r8;
    DEWG=0.0_r8;DROP=0.0_r8;ECIDIF=0.0_r8;ECPOT=0.0_r8;
    ECDQM=0.0_r8;ECDTC=0.0_r8;ECDTG=0.0_r8;ECF=0.0_r8;
    EGDQM=0.0_r8;EGDTC=0.0_r8;EGDTG=0.0_r8;EGF=0.0_r8;
    EGIADD=0.0_r8;EGIDIF=0.0_r8;EGPOT=0.0_r8;EGSMAX=0.0_r8;
    ERIB=0.0_r8;ETC=0.0_r8;ETGS=0.0_r8;FAC=0.0_r8;
    FAC1=0.0_r8;FAC2=0.0_r8;FC=0.0_r8;FG=0.0_r8;
    FIH=0.0_r8;FINC=0.0_r8;GCODTC=0.0_r8;GCODTG=0.0_r8;
    GCORHS=0.0_r8;GETC=0.0_r8;GETGS=0.0_r8;HCDTC=0.0_r8;
    HCDTG=0.0_r8;HCDTM=0.0_r8;HEND=0.0_r8;HGDTC=0.0_r8;
    HGDTG=0.0_r8;HGDTM=0.0_r8;HR=0.0_r8;HRR=0.0_r8;
    HT=0.0_r8;

    PILPHR=0.0_r8;PSIT=0.0_r8;PSY=0.0_r8;RB=0.0_r8;
    RD=0.0_r8;RCC=0.0_r8;RCP=0.0_r8;RESD=0.0_r8;
    RESRBC=0.0_r8;RESRDC=0.0_r8;RESV2=0.0_r8;RESZ0=0.0_r8;
    RG=0.0_r8;RNCDTC=0.0_r8;RNCDTG=0.0_r8;RNGDTC=0.0_r8;RNGDTG=0.0_r8;
    RSOIL=0.0_r8;RSURF=0.0_r8;SDEP=0.0_r8;TAEN=0.0_r8;    
    TC3=0.0_r8;TCEN=0.0_r8;TEMDIF=0.0_r8;TG3=0.0_r8;
    TGEN=0.0_r8;TGTA=0.0_r8;TOP=0.0_r8;TRIB=0.0_r8;
    U2=0.0_r8;WC=0.0_r8;WG=0.0_r8;Y=0.0_r8;
    !cl    add tHENDhe following arrays after common block "comsib3" was removed

    !
    !----------------------------------------------------------------------
    !     E(X) IS VAPOUR PRESSURE IN MBARS AS A FUNCTION OF TEMPERATURE
    !     GE(X) IS D E(X) / D ( TEMP )
    !----------------------------------------------------------------------
    !
    !      E(X) = EXP( 21.18123 - 5418. / X ) / .622
    !      GE(X) = EXP( 21.18123 - 5418. / X ) * 5418.  &
    !              / (X*X) / .622
    !
    ETC   = E(TC)
    ETGS  = E(TGS)
    GETC  = GE(TC)
    GETGS = GE(TGS)
    !crr   HLAT     = ( 3150.19 - 2.378 * TM ) * 1000.
    !crr   PSY      = CPAIR / HLAT * PSUR / .622
    PSY      = CPAIR / HLAT * PSURF/100.0_r8 / 0.622_r8
    RCP = RHOAIR * CPAIR
    !     RADD = 44.
    WC = MIN( 1.0_r8, CAPAC(1)/SATCAP(1) )
    WG = MIN( 1.0_r8, CAPAC(2)/SATCAP(2) )
    !----------------------------------------------------------------------
    !      RSOIL FUNCTION FROM FIT TO CAMILLO AND GURNEY (1984) DATA.
    !      WETNESS OF UPPER 0.5 CM OF SOIL CALCULATED FROM APPROXIMATION
    !      TO MILLY FLOW EQUATION WITH REDUCED (1/50 ) CONDUCTIVITY IN
    !      TOP LAYER.
    !----------------------------------------------------------------------
    !
    !     WT = WWW(1) + 0.75 * ZDEPTH(1) / ( ZDEPTH(1) + ZDEPTH(2) )
    !    &     * (WWW(1) - (WWW(2)**2)/WWW(1) ) / 2. * 50.
    !     FAC = MIN( WT, 0.99 )
    !     FAC = MAX( FAC, WWW(1) * 0.1 )
    !
    !------------------------------------------------------------
    ! --- soil resistance calculation alteration Y.K. Xue Feb. 1994**
    !------------------------------------------------------------
    FAC = MIN( www(1), 0.99_r8 )
    FAC = MAX( FAC, 0.02_r8 )
    RSOIL =  101840.0_r8 * (1.0_r8 - FAC ** 0.0027_r8)
    !
    PSIT = PHSAT * FAC ** (- BEE )
    ARGG = MAX(-10.0_r8,(PSIT*GRAV/461.5_r8/TGS))
    HR = EXP(ARGG)
    !cl    2001,1,10 added the following line according to Xue, 2000 August
    PILPHR = HR
    !----------------------------------------------------------------------
    !     ALTERATION OF AERODYNAMIC TRANSFER PROPERTIES IN CASE OF SNOW
    !     ACCUMULATION.
    !----------------------------------------------------------------------
    !
    RESD = D
    RESZ0 = Z0
    RESRDC = RDC
    RESRBC = RBC
    RESV2 = VCOVER(2)
    !
    IF ( TGS .GT. TF ) GO TO 100
    !
    SDEP = CAPAC(2) *SNOWDEN
    SDEP = MIN( SDEP, (Z2*0.95_r8) )
    D = Z2 - ( Z2-D ) / Z2 * ( Z2 - SDEP )
    Z0 = Z0 / ( Z2-RESD ) * ( Z2-D )
    RDC = RDC * ( Z2-SDEP ) / Z2
    RBC = RBC * Z2 / ( Z2-SDEP )
    VCOVER(2) = 1.0_r8
    WG = MIN( 1.0_r8, CAPAC(2) / 0.004_r8 )
    RST(2) = RSOIL
100 CONTINUE
    !----------------------------------------------------------------------
    !
    !      CALCULATION OF EA, TA, RA, RB, RD AND SOIL MOISTURE STRESS
    !      FOR THE BEGINNING OF THE TIME STEP
    !
    !----------------------------------------------------------------------
    IFIRST = 1
    ICOUNT = 0
    TGEN = TGS
    TCEN = TC
    FC = 1.0_r8
    FG = 1.0_r8
    !-- 2001,1,11 changed the following line according to Xue,August,2000(TA=TM)
    !cl    TA = TM
    TRIB = TA
    EA = EM
    HT = 0.0_r8
    IONCE = 0
1000 CONTINUE
    ICOUNT = ICOUNT + 1
    CALL RASIT5( &
         TRIB      , &!REAL(KIND=r8), INTENT(IN   ) :: TRIB
         CTNI      , &!REAL(KIND=r8), INTENT(OUT  ) :: CTNI
         CUNI      , &!REAL(KIND=r8), INTENT(OUT  ) :: CUNI
         RA        , &!REAL(KIND=r8), INTENT(OUT  ) :: RA
         Z2        , &!REAL(KIND=r8), INTENT(IN   ) :: Ztop2
         Z0        , &!REAL(KIND=r8), INTENT(IN   ) :: Z0
         D         , &!REAL(KIND=r8), INTENT(INOUT) :: D
         ZWIND     , &!REAL(KIND=r8), INTENT(IN   ) :: ZZWIND
         UM        , &!REAL(KIND=r8), INTENT(IN   ) :: UMM1
         RHOAIR    , &!REAL(KIND=r8), INTENT(IN   ) :: RHOA
         TM        , &!REAL(KIND=r8), INTENT(IN   ) :: TMM
         U2        , &!REAL(KIND=r8), INTENT(OUT  ) :: U2
         USTAR     , &!REAL(KIND=r8), INTENT(OUT  ) :: USTAR
         DRAG      , &!REAL(KIND=r8), INTENT(OUT  ) :: DRAG
         TA        , &!REAL(KIND=r8), INTENT(IN   ) :: TA
         bps       , &!REAL(KIND=r8), INTENT(IN   ) :: bps
         rib       , &!REAL(KIND=r8), INTENT(OUT  ) :: RIB
         CU        , &!REAL(KIND=r8), INTENT(OUT  ) :: CU
         XCT         )!REAL(KIND=r8), INTENT(OUT  ) :: CT
    !cl    ------------IF ( IFIRST .EQ. 1 ) CALL RBRD1 ------------
    IF ( IFIRST .EQ. 1 ) THEN
       !cl      TCTA = TC - TA
       RB  = 1.0_r8/(SQRT(U2)/RBC+ZLAI(1)*0.004_r8)
       !cl      X1 = TEMDIF
       TGTA = TGS- TA
       TEMDIF = ( TGTA + SQRT(TGTA*TGTA) ) / 2.0_r8 + 0.1_r8
       FIH = SQRT( 1.0_r8 + 9.0_r8 * GRAV *TEMDIF * Z2 / TGS / ( U2*U2) )
       RD  = RDC / U2 / FIH
    ENDIF
    !cl    ------------ END OF RBRD1 ---------------
    D1 = 1.0_r8/RA + 1.0_r8/RB + 1.0_r8/RD
    TA = ( TGS/RD + TC/RB + TM/RA *bps) / D1
    HT = ( TA - TM ) * RCP / RA
    RCC = RST(1)*FC + 2.0_r8 * RB
    COC = (1.0_r8-WC)/RCC + WC/(2.0_r8*RB)
    RG = RST(2)*FG
    RSURF = RSOIL*FG
    COG1 = VCOVER(2)*(1.0_r8-WG)/(RG+RD)+(1.0_r8-VCOVER(2))/(RSURF+RD)*HR    &
         + VCOVER(2)/(RSURF+RD+44.0_r8)*HR
    COG2 = VCOVER(2)*(1.0_r8-WG)/(RG+RD)+(1.0_r8-VCOVER(2))/(RSURF+RD)       &
         + VCOVER(2)/(RSURF+RD+44.0_r8)
    COG1 = COG1 + WG/RD * VCOVER(2)
    COG2 = COG2 + WG/RD * VCOVER(2)
    D2 = 1.0_r8/RA + COC + COG2
    TOP = COC * ETC + COG1 * ETGS + EM / RA
    EA = TOP / D2
    DROP = MAX( 0.0_r8, (E(TA)-EA) )
    !----------------------------------------------------------------------
    !
    CALL STRES1 ( &
         IFIRST   , &! INTEGER, INTENT(IN   ) :: IFIRST
         RSTM     , &! REAL(KIND=r8)   , INTENT(INOUT) :: RSTM  (2)
         ROOTP    , &! REAL(KIND=r8)   , INTENT(IN   ) :: ROOTP (3)
         RSTFAC   , &! REAL(KIND=r8)   , INTENT(INOUT) :: RSTFAC(2,4)
         RST      , &! REAL(KIND=r8)   , INTENT(INOUT) :: RST   (2)
         TC       , &! REAL(KIND=r8)   , INTENT(IN   ) :: TC
         ETC      , &! REAL(KIND=r8)   , INTENT(IN   ) :: ETC
         RB       , &! REAL(KIND=r8)   , INTENT(IN   ) :: RB
         TGS      , &! REAL(KIND=r8)   , INTENT(IN   ) :: TGS
         ETGS     , &! REAL(KIND=r8)   , INTENT(IN   ) :: ETGS
         RD       , &! REAL(KIND=r8)   , INTENT(IN   ) :: RD
         TU       , &! REAL(KIND=r8)   , INTENT(IN   ) :: TU    (2)
         TL       , &! REAL(KIND=r8)   , INTENT(IN   ) :: TL    (2)
         TOPT     , &! REAL(KIND=r8)   , INTENT(IN   ) :: TOPT  (2)
         EA       , &! REAL(KIND=r8)   , INTENT(IN   ) :: EA
         DEFAC    , &! REAL(KIND=r8)   , INTENT(IN   ) :: DEFAC (2)
         PH1      , &! REAL(KIND=r8)   , INTENT(IN   ) :: PH1   (2)
         PH2      , &! REAL(KIND=r8)   , INTENT(IN   ) :: PH2   (2)
         NROOT    , &! INTEGER, INTENT(IN   ) :: NROOT
         ZDEPTH   , &! REAL(KIND=r8)   , INTENT(IN   ) :: ZDEPTH(3)
         PHSOIL   , &! REAL(KIND=r8)   , INTENT(IN   ) :: PHSOIL(3)
         ROOTD    , &! REAL(KIND=r8)   , INTENT(IN   ) :: ROOTD (2)
         VCOVER   , &! REAL(KIND=r8)   , INTENT(IN   ) :: VCOVER(2)
         DROP       )! REAL(KIND=r8)   , INTENT(IN   ) :: DROP
    !----------------------------------------------------------------------
    IFIRST = 0
    ERIB = EA
    TRIB = TA
!!!
    IF ( ICOUNT .LE. 4 ) GO TO 1000
    !======================================================================
    !cl    CALL DELRN ( RNCDTC, RNCDTG, RNGDTG, RNGDTC )
    !     PARTIAL DERIVATIVES OF RADIATIVE AND SENSIBLE HEAT FLUXES
    TC3 = TC * TC * TC
    TG3 = TGS * TGS * TGS
    FAC1 = ( 1.0_r8 - ALBEDO(1,3,2) ) * ( 1.0_r8-THERMK ) * VCOVER(1)
    FAC2 =   1.0_r8 - ALBEDO(2,3,2)
    RNCDTC = - 2.0_r8 * 4.0_r8 * FAC1 * STEFAN * TC3
    RNCDTG = 4.0_r8 * FAC1 * FAC2 * STEFAN * TG3
    RNGDTG = - 4.0_r8 * FAC2 * STEFAN * TG3
    RNGDTC = 4.0_r8 * FAC1 * FAC2 * STEFAN * TC3
    !----------------------------------------------------------------------
    !
    !     DEW CALCULATION : DEW CONDITION IS SET AT BEGINNING OF TIME STEP.
    !     IF SURFACE CHANGES STATE DURING TIME STEP, LATENT HEAT FLUX IS
    !     SET TO ZERO.
    !
    !----------------------------------------------------------------------
    IF ( EA .GT. ETC ) FC = 0.0_r8
    IF ( EA .GT. ETGS) FG = 0.0_r8
    !
    !----------------------------------------------------------------------
    !
    !     WET FRACTION EXHAUSTION TEST : IF CAPAC(X) IS EXHAUSTED IN
    !     A TIME STEP, INTERCEPTION LOSS IS LIMITED TO CAPAC(X).
    !
    !----------------------------------------------------------------------
    !     START OF NON-NEUTRAL RESISTANCE CALCULATION LOOP
    !----------------------------------------------------------------------
    I = 0
    !    ----- INITIALIZE NEWTON-RAPHSON ITERATIVE ROUTINE FOR RASIT 3,5,8
    NOX = 0
    NONPOS = 1
    IWALK = 0
    LX = 2
    FINC = 1.0_r8
    ITEX(LX) = 0.0_r8
    ZINC(LX) = 0.0_r8
    A2(LX)   = 0.0_r8
    Y1(LX)   = 0.0_r8
2000 CONTINUE
    CALL RASIT5(&
         TRIB     , &!REAL(KIND=r8), INTENT(IN   ) :: TRIB
         CTNI     , &!REAL(KIND=r8), INTENT(OUT  ) :: CTNI
         CUNI     , &!REAL(KIND=r8), INTENT(OUT  ) :: CUNI
         RA       , &!REAL(KIND=r8), INTENT(OUT  ) :: RA
         Z2       , &!REAL(KIND=r8), INTENT(IN   ) :: Ztop2
         Z0       , &!REAL(KIND=r8), INTENT(IN   ) :: Z0
         D        , &!REAL(KIND=r8), INTENT(INOUT) :: D
         ZWIND    , &!REAL(KIND=r8), INTENT(IN   ) :: ZZWIND
         UM       , &!REAL(KIND=r8), INTENT(IN   ) :: UMM1
         RHOAIR   , &!REAL(KIND=r8), INTENT(IN   ) :: RHOA
         TM       , &!REAL(KIND=r8), INTENT(IN   ) :: TMM
         U2       , &!REAL(KIND=r8), INTENT(OUT  ) :: U2
         USTAR    , &!REAL(KIND=r8), INTENT(OUT  ) :: USTAR
         DRAG     , &!REAL(KIND=r8), INTENT(OUT  ) :: DRAG
         TA       , &!REAL(KIND=r8), INTENT(IN   ) :: TA
         bps      , &!REAL(KIND=r8), INTENT(IN   ) :: bps
         rib      , &!REAL(KIND=r8), INTENT(OUT  ) :: RIB
         CU       , &!REAL(KIND=r8), INTENT(OUT  ) :: CU
         XCT        )!REAL(KIND=r8), INTENT(OUT  ) :: CT
    !======================================================================
    !cl    CALL DELHF ( HCDTC, HCDTG, HGDTG, HGDTC )
    !     PARTIAL DERIVATIVES OF SENSIBLE HEAT FLUXES
    !
    RCP = RHOAIR * CPAIR
    D1 = 1.0_r8/RA + 1.0_r8/RB + 1.0_r8/RD
    TA = ( TGS/RD + TC/RB + TM/RA *bps) / D1
    !
    HC = RCP * ( TC - TA ) / RB * DTT
    HG = RCP * ( TGS - TA ) / RD * DTT
    !----------------------------------------------------------------------
    !     N.B. FLUXES EXPRESSED IN JOULES M-2
    !----------------------------------------------------------------------
    !
    HCDTC = RCP / RB * ( 1.0_r8/RA + 1.0_r8/RD ) / D1
    HCDTG = - RCP / ( RB * RD ) / D1
    ! FOR TM
    HCDTM = - RCP / ( RB * RA ) / D1 * BPS
    !
    HGDTG = RCP / RD * ( 1.0_r8/RA + 1.0_r8/RB ) / D1
    HGDTC = - RCP / ( RD * RB ) / D1
    ! FOR TM
    HGDTM = - RCP / ( RD * RA ) / D1 *BPS
    !======================================================================
    !     CALL DELEF ( ECDTC, ECDTG, EGDTG, EGDTC, DEADTC, DEADTG, EC, EG ,
    !    &             WC, WG, FC, FG, HR,MDLSNO,ISNOW )
    !======================================================================
    !     PARTIAL DERIVATIVES OF LATENT HEAT FLUXES
    !     MODIFICATION FOR SOIL DRYNESS : HR = REL. HUMIDITY IN TOP LAYER
    !----------------------------------------------------------------------
    !
    HRR = HR
    IF ( FG .LT. 0.5_r8 ) HRR = 1.0_r8
    !
    RCC = RST(1)*FC + 2.0_r8 * RB
    COC = (1.0_r8-WC)/RCC + WC/(2.0_r8*RB)
    RG = RST(2)*FG
    !cl    IF (MDLSNO.eq.0.and.ISNOW.eq.0) THEN
    IF (ISNOW.EQ.0) THEN
       RSURF=RSOIL
    ELSE
       RSURF = RSOIL*FG
    END IF
    COG1 = VCOVER(2)*(1.0_r8-WG)/(RG+RD)+(1.0_r8-VCOVER(2))/(RSURF+RD)*HRR   &
         + VCOVER(2)/(RSURF+RD+44.0_r8)*HRR
    COG2 = VCOVER(2)*(1.0_r8-WG)/(RG+RD)+(1.0_r8-VCOVER(2))/(RSURF+RD)       &
         + VCOVER(2)/(RSURF+RD+44.0_r8)
    COG1 = COG1 + WG/RD * VCOVER(2)
    COG2 = COG2 + WG/RD * VCOVER(2)
    !
    D2 = 1.0_r8/RA + COC + COG2
    TOP = COC * ETC + COG1 * ETGS + EM/RA
    EA = TOP / D2
    EC = ( ETC - EA ) * COC * RCP/PSY * DTT
    EG = ( ETGS*COG1 - EA*COG2 ) * RCP/PSY * DTT
    DEADTC = GETC * COC / D2
    DEADTG = GETGS * COG1 / D2
    !
    ECDTC = ( GETC - DEADTC ) * COC * RCP / PSY
    ECDTG = - DEADTG * COC * RCP / PSY
    !
    EGDTG = ( GETGS*COG1 - DEADTG*COG2 ) * RCP / PSY
    EGDTC = - DEADTC * COG2 * RCP / PSY
    !crr
    !   FOR QM
    DEADQM = 0.622_r8 * PSURF /( (0.622_r8+QM)**2 * RA * D2 )
    ECDQM =        -DEADQM * COC * RCP / PSY
    EGDQM =        -DEADQM * COG2 * RCP / PSY
    !   FOR YPDATING TM AND QM
    AK = 1/ RCP / BPS
    AH = 1/ (HLAT*RHOAIR)
    !crr
    !----------------------------------------------------------------------
    !     CALCULATION OF COEFFICIENTS OF TEMPERATURE TENDENCY EQUATIONS
    !        C - CANOPY
    !        G - GROUND
    !----------------------------------------------------------------------
    !
    CCODTC = CCX / DTT - RNCDTC + HCDTC + ECDTC
    CCODTG = - RNCDTG + HCDTG + ECDTG
    CCORHS = RADT(1) - ( HC + EC ) / DTT
    !----------------------------------------------------------------------
    !
    GCODTG = CG / DTT + TIMCON*CG*2.0_r8 - RNGDTG + HGDTG + EGDTG
    GCODTC = - RNGDTC + HGDTC + EGDTC
    GCORHS = RADT(2) - TIMCON*CG*2.0_r8 * ( TGS -TD ) - ( HG + EG ) / DTT
    !
    DENOM = CCODTC * GCODTG - CCODTG * GCODTC
    DTC = ( CCORHS * GCODTG - CCODTG * GCORHS ) / DENOM
    DTG = ( CCODTC * GCORHS - CCORHS * GCODTC ) / DENOM
    !----------------------------------------------------------------------
    !     CHECK IF INTERCEPTION LOSS TERM HAS EXCEEDED CANOPY STORAGE
    !----------------------------------------------------------------------
    !
    ECPOT = ( (ETC - EA) + (GETC - DEADTC)*DTC - DEADTG*DTG )
    ECI = ECPOT * WC /(2.0_r8*RB) * RCP/PSY * DTT
    ECIDIF=MAX(0.0_r8,(ECI-CAPAC(1)*1.E3_r8*HLAT))
    ECI   =MIN(ECI,(    CAPAC(1)*1.E3_r8*HLAT))
    !
    EGPOT = ( (ETGS - EA) + (GETGS - DEADTG)*DTG - DEADTC*DTC )
    EGI = EGPOT * VCOVER(2) * WG/RD * RCP/PSY * DTT
    EGIDIF=MAX(0.0_r8,(EGI-CAPAC(2)*1.E3_r8*HLAT))
    EGI   =MIN(EGI,(    CAPAC(2)*1.E3_r8*HLAT))
    !----------------------------------------------------------------------
    TGEN = TGS + DTG
    TCEN = TC + DTC
    D1 = 1.0_r8/RA + 1.0_r8/RB + 1.0_r8/RD
    TAEN = ( TGEN / RD + TCEN / RB + TM / RA *bps) / D1
    !
    HEND = ( TAEN - TM ) * RCP / RA + (ECIDIF + EGIDIF)/DTT
    Y= TRIB - TAEN
    I = I + 1
    HT   = HEND
    IF ( I .GT. 20 ) GO TO 200
    !cl    IF ( I .GT. ITRUNK ) GO TO 200
    !
    CALL NEWTON(&
         TRIB    , &!REAL(KIND=r8)   , INTENT(INOUT) :: A1
         Y       , &!REAL(KIND=r8)   , INTENT(INOUT) :: Y
         FINC    , &!REAL(KIND=r8)   , INTENT(IN   ) :: FINC
         NOX     , &!INTEGER, INTENT(INOUT) :: NOX
         NONPOS  , &!INTEGER, INTENT(IN   ) :: NONPOS
         IWALK   , &!INTEGER, INTENT(INOUT) :: IWOLK
         LX      , &!INTEGER, INTENT(IN   ) :: L
         ZINC    , &!REAL(KIND=r8)   , INTENT(INOUT  ) :: ZINC(3)
         A2      , &!REAL(KIND=r8)   , INTENT(INOUT) :: A2(3)
         Y1      , &!REAL(KIND=r8)   , INTENT(INOUT) :: Y1(3)
         ITEX      )!REAL(KIND=r8)   , INTENT(INOUT) :: ITER(3)

    IF(NOX.NE.1)GO TO 2000
200 CONTINUE
    !     IQIN = IQIN + I
    !     IF (I.GT.10) IQIN1 = IQIN1 + 1
    !
    !----------------------------------------------------------------------
    !     EXIT FROM NON-NEUTRAL CALCULATION
    !     EVAPOTRANSPIRATION FLUXES CALCULATED FIRST ( J M-2 )
    !----------------------------------------------------------------------
    HRR = HR
    IF ( FG .LT. 0.5_r8 ) HRR = 1.0_r8
    RSURF = RSOIL*FG
    !
    COCT = (1.0_r8-WC)/RCC
    COGT = VCOVER(2) * (1.0_r8-WG)/( RG + RD )
    COGS1 = (1.0_r8-VCOVER(2)) / ( RD + RSURF ) * HRR       &
         + VCOVER(2) / ( RD + RSURF + 44.0_r8) * HRR
    COGS2 = COGS1 / HRR
    !
    ECT = ECPOT * COCT * RCP/PSY * DTT
    !
    EGT = EGPOT * COGT * RCP/PSY * DTT
    EGS = (ETGS + GETGS*DTG ) * COGS1                   &
         - ( EA + DEADTG*DTG + DEADTC*DTC ) * COGS2
    EGS = EGS * RCP/PSY * DTT
    EGSMAX = WWW(1) / 2.0_r8 * ZDEPTH(1) * POROS * HLAT * 1000.0_r8
    EGIADD = MAX( 0.0_r8, EGS - EGSMAX )
    EGS = MIN ( EGS, EGSMAX )
    EGIDIF = EGIDIF + EGIADD
    !
    !----------------------------------------------------------------------
    !     SENSIBLE HEAT FLUX CALCULATED WITH LATENT HEAT FLUX CORRECTION
    !----------------------------------------------------------------------
    HC = HC + (HCDTC*DTC + HCDTG*DTG)*DTT + ECIDIF
    HG = HG + (HGDTC*DTC + HGDTG*DTG)*DTT + EGIDIF
    !----------------------------------------------------------------------
    !     TEST OF DEW CONDITION. LATENT HEAT FLUXES SET TO ZERO IF SIGN
    !     OF FLUX CHANGES OVER TIME STEP.EXCESS ENERGY DONATED TO SENSIBLE
    !     HEAT FLUX.
    !----------------------------------------------------------------------
    ECF = SIGN( 1.0_r8, ECPOT )
    EGF = SIGN( 1.0_r8, EGPOT )
    DEWC = FC * 2.0_r8 - 1.0_r8
    DEWG = FG * 2.0_r8 - 1.0_r8
    !
    IF(DEWC*ECF.GT.0.0_r8) GO TO 300
    HC = HC + ECI + ECT
    ECI = 0.0_r8
    ECT = 0.0_r8
300 IF(DEWG*EGF.GT.0.0_r8) GO TO 400
    HG = HG + EGS + EGI + EGT
    EGS = 0.0_r8
    EGI = 0.0_r8
    EGT = 0.0_r8
400 CONTINUE
    !
    EC = ECI + ECT
    EG = EGT + EGS + EGI
    !
    !----------------------------------------------------------------------
    !     ADJUSTMENT OF TEMPERATURES AND VAPOR PRESSURE , CALCULATION OF
    !     SENSIBLE HEAT FLUXES.
    !----------------------------------------------------------------------
    !
    TC  = TCEN
    TGS = TGEN
    TA  = TAEN
    EA = EA + DEADTC*DTC + DEADTG*DTG
    !
    RADT(1) = RADT(1) + RNCDTC*DTC + RNCDTG*DTG
    RADT(2) = RADT(2) + RNGDTC*DTC + RNGDTG*DTG
    !========================================================================
    FLUP = FLUP - (RNCDTC+RNGDTC)*DTC - (RNCDTG+RNGDTG)*DTG
    !========================================================================
    !
    ! ** simulated net all-wave radiation **
    !     sibnet(nmm,ndd,nhh) = RADT(1) + RADT(2)
    !
    CHF = CCX / DTT * DTC
    SHF = CG / DTT * DTG + TIMCON*CG*2.0_r8 * ( TGS - TD )
    !
    ZLWUP = ZLWUP - RNCDTC * DTC / 2.0_r8                             &
         - RNGDTG * DTG * (1.0_r8-VCOVER(1)*(1.0_r8-THERMK) )
    !
    IF ( TGS .GT. TF ) GO TO 500
    EGS = EG - EGI
    EGT = 0.0_r8
500 CONTINUE
    VCOVER(2) = RESV2
    D = RESD
    Z0 = RESZ0
    RDC = RESRDC
    RBC = RESRBC
    !------------------------------------------------------
  END SUBROUTINE TEMRS1
  !------------------------------------------------------


  !=======================================================================
  !                                                                       
  SUBROUTINE NEWTON( &
       A1        , & !REAL(KIND=r8)   , INTENT(INOUT) :: A1
       Y         , & !REAL(KIND=r8)   , INTENT(INOUT) :: Y
       FINC      , & !REAL(KIND=r8)   , INTENT(IN   ) :: FINC
       NOX       , & !INTEGER, INTENT(INOUT) :: NOX
       NONPOS    , & !INTEGER, INTENT(IN   ) :: NONPOS
       IWOLK     , & !INTEGER, INTENT(INOUT) :: IWOLK
       L         , & !INTEGER, INTENT(IN   ) :: L
       ZINC      , & !REAL(KIND=r8)   , INTENT(INOUT  ) :: ZINC(3)
       A2        , & !REAL(KIND=r8)   , INTENT(INOUT  ) :: A2(3)
       Y1        , & !REAL(KIND=r8)   , INTENT(INOUT) :: Y1(3)
       ITER        ) !REAL(KIND=r8)   , INTENT(INOUT) :: ITER(3)
    !
    !=======================================================================
    !
    !-----------------------------------------------------------------------
    ! ** VERSION ACQUIRED FROM EROS 2/19/86.
    !
    ! ** THE NEWTON RAPHSON ITERATIVE ROUTINE WILL BE USED TO GENERATE NEW
    ! ** VALUES OF A1 IF DABSOLUTE VALUE OF Y IS GREATER THAN ERTOL;
    ! ** A1 IS ESTIMATE, Y IS RESULTANT ERROR
    ! ** NEX IS EXIT CONDITION  (0=NO EXIT) OR (1 WHEN DABS(Y) LT ERTOL)
    ! ** ERTOL IS THE DABSOLUTE VALUE OF Y NECESSARY TO OBTAIN AN EXIT
    ! ** FINC IS INITIAL INCREMENT SIZE FOR SECOND ESTIMATE OF A1
    ! ** NONPOS=0 IF QUANTITY TO BE MINIMIZED CAN BE LESS THAN ZERO;
    ! ** NONPOS=1 IF QUANTITY CAN ONLY BE POSITIVE
    ! ** L IDENTIFIES WHICH QUANTITY IS BEING CALCULATED.
    !
    ! ** CONTROL VALUES: FINC,ERTOL,NOX,NONPOS,L:MUST BE SET BY USER
    !-----------------------------------------------------------------------
    !
    !cfds Changes according to Jack (Feb/2008)
    REAL(KIND=r8)   , INTENT(INOUT) :: A1
    REAL(KIND=r8)   , INTENT(INOUT) :: Y
    REAL(KIND=r8)   , INTENT(IN   ) :: FINC
    INTEGER, INTENT(INOUT) :: NOX
    INTEGER, INTENT(IN   ) :: NONPOS
    INTEGER, INTENT(INOUT) :: IWOLK
    INTEGER, INTENT(IN   ) :: L
    REAL(KIND=r8)   , INTENT(INOUT  ) :: ZINC(3)
    REAL(KIND=r8)   , INTENT(INOUT) :: A2(3)
    REAL(KIND=r8)   , INTENT(INOUT) :: Y1(3)
    REAL(KIND=r8)   , INTENT(INOUT) :: ITER(3)


    INTEGER          ::  IWALK(3)
    INTEGER          ::  NEX(3)
    REAL(KIND=r8)    ::  A
    REAL(KIND=r8)    ::  ERTOL

    !cfds  DIMENSION  IWALK(3), NEX(3)
    !cfds  DIMENSION  ZINC(3), A2(3), Y1(3),ITER3(3)
    REAL(KIND=r8), PARAMETER :: CONS=1.0_r8
    A=0.0_r8;ERTOL=0.0_r8;IWALK=0;NEX=0
    !
    ERTOL = 0.05_r8 * FINC
    IWALK(L) = IWOLK
    NEX(L)=NOX
    !
    IF ( ITER(L) .GE. 490 ) GO TO 160
    IF (ERTOL .LT. 0.00000001_r8) ERTOL=0.000001_r8
    IF (ABS(Y) .LE. ERTOL) GO TO 150
    IF((ABS(Y-Y1(L))).LE.0.01_r8*ERTOL .AND. IWALK(L).EQ.0 ) GO TO 8
    !
    IF(ABS(Y1(L)).GT.ERTOL) GO TO 1
    A2(L)=A1
    A1=A1-Y
    NEX(L)=0
    Y1(L)=Y
    ITER(L)=1
    IF (IWALK(L) .EQ. 3) GO TO 101
    IWALK(L)=0
    GO TO 101
1   ITER(L)=ITER(L)+1
    IF(ITER(L) .EQ. 10) IWALK(L)=1
    IF(IWALK(L) .NE. 0) GO TO 2
    IF(ABS(Y) .GT. ERTOL) GO TO 3
    NEX(L)=1
    GO TO 150
3   A=A1-Y*(A1-A2(L))/(Y-Y1(L))
    IF(ABS(A-A1).GT.(10.0_r8*FINC))                   &
         A=A1+10.0_r8*FINC*SIGN(CONS,(A-A1))
    A2(L)=A1
    A1=A
    Y1(L)=Y
    GO TO 101
2   IF(IWALK(L).EQ.2)GO TO 4
    IF(IWALK(L).EQ.3) GO TO 6
    IF(SIGN(CONS,Y).EQ.SIGN(CONS,Y1(L))) GO TO  3
    ZINC(L)=(A1-A2(L))/4.0_r8
    A1=A2(L)+ZINC(L)
    IWALK(L)=2
    NEX(L)=0
    GO TO 101
4   IF(SIGN(CONS,Y) .EQ.SIGN(CONS,Y1(L))) GO TO 5
    ZINC(L)=-ZINC(L)/4.0_r8
    A2(L)=A1
    A1=A1+ZINC(L)
    NEX(L)=0
    Y1(L)=Y
    GO TO 101
5   A2(L)=A1
    A1=A1+ZINC(L)
    Y1(L)=Y
    NEX(L)=0
    GO TO 101
6   IF(SIGN(CONS,Y).EQ.SIGN(CONS,Y1(L))) GO TO 7
    IWALK(L)=1
    GO TO 2
7   A2(L) = A1
    A1 = A1+FINC
    Y1(L)=Y
    NEX(L) = 0
    GO TO 101
8   A1 = A1 + FINC*2.0_r8
    NEX(L)=0
    GO TO 101
160 CONTINUE
    ! 900   FORMAT ( 3X,' FAILURE TO CONVERGE AFTER 490 ITERATIONS',      &
    !       /, 3X,' Y = ',2G12.5,2X,I14)
150 NEX(L) = 1
    ZINC(L)=0.0_r8
    ITER(L) = 0
    IWALK(L)=0
    Y1(L)=0.0_r8
    Y=0.0_r8
    A2(L)=0.0_r8
101 CONTINUE
    IF(NONPOS.EQ.1.AND.A1.LT.0.0_r8) A1=A2(L)/2.0_r8
    NOX = INT(NEX(L),KIND=i4)
    IWOLK = IWALK(L)
    !
    !------------------------------------------------------
  END SUBROUTINE NEWTON
  !------------------------------------------------------

  !=======================================================================
  !                                                                       
  SUBROUTINE STRES1 (&
       IFIRST    , &! INTEGER, INTENT(IN   ) :: IFIRST
       RSTM      , &! REAL(KIND=r8)   , INTENT(INOUT) :: RSTM  (2)
       ROOTP     , &! REAL(KIND=r8)   , INTENT(IN   ) :: ROOTP (3)
       RSTFAC    , &! REAL(KIND=r8)   , INTENT(INOUT) :: RSTFAC(2,4)
       RST       , &! REAL(KIND=r8)   , INTENT(INOUT) :: RST   (2)
       TC        , &! REAL(KIND=r8)   , INTENT(IN   ) :: TC
       ETC       , &! REAL(KIND=r8)   , INTENT(IN   ) :: ETC
       RB        , &! REAL(KIND=r8)   , INTENT(IN   ) :: RB
       TGS       , &! REAL(KIND=r8)   , INTENT(IN   ) :: TGS
       ETGS      , &! REAL(KIND=r8)   , INTENT(IN   ) :: ETGS
       RD        , &! REAL(KIND=r8)   , INTENT(IN   ) :: RD
       TU        , &! REAL(KIND=r8)   , INTENT(IN   ) :: TU    (2)
       TL        , &! REAL(KIND=r8)   , INTENT(IN   ) :: TL    (2)
       TOPT      , &! REAL(KIND=r8)   , INTENT(IN   ) :: TOPT  (2)
       EA        , &! REAL(KIND=r8)   , INTENT(IN   ) :: EA
       DEFAC     , &! REAL(KIND=r8)   , INTENT(IN   ) :: DEFAC (2)
       PH1       , &! REAL(KIND=r8)   , INTENT(IN   ) :: PH1   (2)
       PH2       , &! REAL(KIND=r8)   , INTENT(IN   ) :: PH2   (2)
       NROOT     , &! INTEGER, INTENT(IN   ) :: NROOT
       ZDEPTH    , &! REAL(KIND=r8)   , INTENT(IN   ) :: ZDEPTH(3)
       PHSOIL    , &! REAL(KIND=r8)   , INTENT(IN   ) :: PHSOIL(3)
       ROOTD     , &! REAL(KIND=r8)   , INTENT(IN   ) :: ROOTD (2)
       VCOVER    , &! REAL(KIND=r8)   , INTENT(IN   ) :: VCOVER(2)
       DROP        )! REAL(KIND=r8)   , INTENT(IN   ) :: DROP
    !
    !=======================================================================
    !
    !======================================================================
    !
    !     CALCULATION OF ADJUSTMENT TO LIGHT DEPENDENT STOMATAL RESISTANCE
    !     BY TEMPERATURE, HUMIDITY AND STRESS FACTORS
    !     SIMPLIFIED SEE XUE ET AL(1991)
    !
    !         RSTFAC(IVEG,1) = FD
    !         RSTFAC(IVEG,2) = FP
    !         RSTFAC(IVEG,3) = FT
    !         RSTFAC(IVEG,4) = FTPD
    !
    !----------------------------------------------------------------------
    !
    INTEGER, INTENT(IN   ) :: IFIRST
    REAL(KIND=r8)   , INTENT(INOUT) :: RSTM  (2)
    REAL(KIND=r8)   , INTENT(IN   ) :: ROOTP (3)
    REAL(KIND=r8)   , INTENT(INOUT) :: RSTFAC(2,4)
    REAL(KIND=r8)   , INTENT(INOUT) :: RST   (2)
    REAL(KIND=r8)   , INTENT(IN   ) :: TC
    REAL(KIND=r8)   , INTENT(IN   ) :: ETC
    REAL(KIND=r8)   , INTENT(IN   ) :: RB
    REAL(KIND=r8)   , INTENT(IN   ) :: TGS
    REAL(KIND=r8)   , INTENT(IN   ) :: ETGS
    REAL(KIND=r8)   , INTENT(IN   ) :: RD
    REAL(KIND=r8)   , INTENT(IN   ) :: TU    (2)
    REAL(KIND=r8)   , INTENT(IN   ) :: TL    (2)
    REAL(KIND=r8)   , INTENT(IN   ) :: TOPT  (2)
    REAL(KIND=r8)   , INTENT(IN   ) :: EA
    REAL(KIND=r8)   , INTENT(IN   ) :: DEFAC (2)
    REAL(KIND=r8)   , INTENT(IN   ) :: PH1   (2)
    REAL(KIND=r8)   , INTENT(IN   ) :: PH2   (2)
    INTEGER, INTENT(IN   ) :: NROOT
    REAL(KIND=r8)   , INTENT(IN   ) :: ZDEPTH(3)
    REAL(KIND=r8)   , INTENT(IN   ) :: PHSOIL(3)
    REAL(KIND=r8)   , INTENT(IN   ) :: ROOTD (2)
    REAL(KIND=r8)   , INTENT(IN   ) :: VCOVER(2)
    REAL(KIND=r8)   , INTENT(IN   ) :: DROP
    !
    !
    !  LOCAL
    !
    !
    INTEGER :: IVEG
    INTEGER :: I
    REAL(KIND=r8)    :: XDRR  (3)
    REAL(KIND=r8)    :: DEP   (3)
    REAL(KIND=r8)    :: D1
    REAL(KIND=r8)    :: D2
    REAL(KIND=r8)    :: EPOT
    REAL(KIND=r8)    :: ETV
    REAL(KIND=r8)    :: FTPD
    REAL(KIND=r8)    :: RAIR
    REAL(KIND=r8)    :: TV
    REAL(KIND=r8)    :: XDR
    REAL(KIND=r8)    :: XROT
    XDRR  =0.0_r8;DEP   =0.0_r8;D1=0.0_r8;D2=0.0_r8;
    EPOT=0.0_r8;ETV=0.0_r8;FTPD=0.0_r8;RAIR=0.0_r8;
    TV=0.0_r8;XDR=0.0_r8;XROT=0.0_r8;
    !
    !----------------------------------------------------------------------
    !     HUMIDITY, TEMPERATURE AND TRANSPIRATION FACTORS
    !----------------------------------------------------------------------
    !
    DO  IVEG = 1, 2
       !
       TV = TC
       ETV = ETC
       RAIR = RB * 2.0_r8
       IF ( IVEG .EQ. 1 ) GO TO 100
       TV = TGS
       ETV = ETGS
       RAIR = RD
100    CONTINUE
       !
       TV = MIN ( ( TU(IVEG) - 0.1_r8 ), TV )
       TV = MAX ( ( TL(IVEG) + 0.1_r8 ), TV )
       !
       IF( IFIRST .EQ. 0 ) GO TO 200
       RSTM(IVEG) = RST(IVEG)
       D2 = ( TU(IVEG) - TOPT(IVEG) ) / ( TOPT(IVEG) - TL(IVEG) )
       D1 = 1.0_r8 /(( TOPT(IVEG) - TL(IVEG) )*                  &
            EXP( LOG( TU(IVEG) - TOPT(IVEG))*D2))
       RSTFAC(IVEG,3) = D1*( TV-TL(IVEG)) * EXP(LOG(TU(IVEG)-TV)*D2)
       !
       IF (RSTFAC(IVEG,3).LT.0.0_r8) RSTFAC(IVEG,3) = 0.0_r8
       IF (RSTFAC(IVEG,3).GT.1.0_r8) RSTFAC(IVEG,3) = 1.0_r8
       !
       !----------------------------------------------------------------------
       !      SIMPLIFIED CALCULATION OF LEAF WATER POTENTIAL FACTOR , FP
       !----------------------------------------------------------------------
       !
       !---------new add------------
       XDRR(1)=-PHSOIL(1)
       XDRR(2)=-PHSOIL(2)
       XDRR(3)=-PHSOIL(3)
       IF(XDRR(1).LE.0.001_r8) XDRR(1)=0.001_r8
       IF(XDRR(2).LE.0.001_r8) XDRR(2)=0.001_r8
       IF(XDRR(3).LE.0.001_r8) XDRR(3)=0.001_r8
       XDRR(1)=LOG(XDRR(1))
       XDRR(2)=LOG(XDRR(2))
       XDRR(3)=LOG(XDRR(3))
       !------------------------------

       IF (NROOT.EQ.1) THEN
          XROT = ROOTD(1)
          DO I = 1, 3
             DEP(I) = 0.0_r8
          END DO
          DO  I = 1, 3
             DEP(I) = MIN(ZDEPTH(I), XROT)
             XROT = XROT - ZDEPTH(I)
             IF (XROT.LE.0.0_r8) GO TO 7410
          END DO!     7500 CONTINUE
7410      CONTINUE
          !      XDR = (PHSOIL(1) * DEP(1) + PHSOIL(2) * DEP(2)         &
          !            +PHSOIL(3) * DEP(3)) /ROOTD(1)
          XDR=(XDRR(1)*DEP(1)+XDRR(2)*DEP(2)+XDRR(3)*DEP(3))/ROOTD(1)

       ELSE
          !      XDR = PHSOIL(1) * ROOTP(1) + PHSOIL(2) * ROOTP(2)      &
          !            +PHSOIL(3) * ROOTP(3)
          XDR=XDRR(1)*ROOTP(1)+XDRR(2)*ROOTP(2)+XDRR(3)*ROOTP(3)
       END IF
       !      XDR = - XDR
       !      IF (XDR .LE. 0.001) XDR = 0.001
       !      XDR = LOG (XDR)
       !cl    2001,1,09 changed the following two lines back to the original ones.
       !cl    EXPONENT = MAX(-86.0, (- PH1(IVEG) * (PH2(IVEG) - XDR)) )
       !cl    RSTFAC(IVEG,2) = 1. - EXP(EXPONENT)
       RSTFAC(IVEG,2) = 1.0_r8 - EXP(- PH1(IVEG) * (PH2(IVEG) - XDR))
       IF (RSTFAC(IVEG,2).GT.1.0_r8) RSTFAC(IVEG,2) = 1.0_r8
       IF (RSTFAC(IVEG,2).LT.0.0_r8) RSTFAC(IVEG,2) = 0.0_r8
       !
200    RST(IVEG) = RSTM(IVEG)
       !
       EPOT = ETV - EA
       EPOT = MAX(0.0001_r8,(ETV-EA))
       !
       !               ---** PJS mod 10/9/92 ---**
       ! ---** based on Verma FIFE-87 function for C4 grasses ---**
       !
       RSTFAC(IVEG,1) = 1.0_r8/ ( 1 + DEFAC(IVEG)*DROP )
       !
       IF (RSTFAC(IVEG,1).LT.0.0_r8) RSTFAC(IVEG,1) = 0.0_r8
       IF (RSTFAC(IVEG,1).GT.1.0_r8) RSTFAC(IVEG,1) = 1.0_r8
       !----------------------------------------------------------------------
       !     VALUE OF FP FOUND
       !----------------------------------------------------------------------
       !
       FTPD = RSTFAC(IVEG,1) * RSTFAC(IVEG,2) * RSTFAC(IVEG,3)
       RSTFAC(IVEG,4) = MAX( FTPD, 0.00001_r8 )
       !----------------------------------------------------------------------
       !
       RST(IVEG) = RST(IVEG) / RSTFAC(IVEG,4) / VCOVER(IVEG)
       !
       RST(IVEG) = MIN( RST(IVEG), 100000.0_r8 )
    END DO  !1000  CONTINUE
    !                                                                       
    !------------------------------------------------------
  END SUBROUTINE STRES1
  !------------------------------------------------------


  !------------------------------------------------------
  !=======================================================================
  !                                                                       
  SUBROUTINE RASIT5( &
       TRIB      , &!REAL(KIND=r8), INTENT(IN   ) :: TRIB
       CTNI      , &!REAL(KIND=r8), INTENT(OUT  ) :: CTNI
       CUNI      , &!REAL(KIND=r8), INTENT(OUT  ) :: CUNI
       RA        , &!REAL(KIND=r8), INTENT(OUT  ) :: RA
       Ztop2     , &!REAL(KIND=r8), INTENT(IN   ) :: Ztop2
       Z0        , &!REAL(KIND=r8), INTENT(IN   ) :: Z0
       D         , &!REAL(KIND=r8), INTENT(INOUT) :: D
       ZZWIND    , &!REAL(KIND=r8), INTENT(IN   ) :: ZZWIND
       UMM1      , &!REAL(KIND=r8), INTENT(IN   ) :: UMM1
       RHOA      , &!REAL(KIND=r8), INTENT(IN   ) :: RHOA
       TMM       , &!REAL(KIND=r8), INTENT(IN   ) :: TMM
       U2        , &!REAL(KIND=r8), INTENT(OUT  ) :: U2
       USTAR     , &!REAL(KIND=r8), INTENT(OUT  ) :: USTAR
       DRAG      , &!REAL(KIND=r8), INTENT(OUT  ) :: DRAG
       TA        , &!REAL(KIND=r8), INTENT(IN   ) :: TA
       bps       , &!REAL(KIND=r8), INTENT(IN   ) :: bps
       rib       , &!REAL(KIND=r8), INTENT(OUT  ) :: RIB
       CU        , &!REAL(KIND=r8), INTENT(OUT  ) :: CU
       CT          )!REAL(KIND=r8), INTENT(OUT  ) :: CT
    IMPLICIT NONE
    REAL(KIND=r8), INTENT(IN   ) :: TRIB
    REAL(KIND=r8), INTENT(OUT  ) :: CTNI
    REAL(KIND=r8), INTENT(OUT  ) :: CUNI
    REAL(KIND=r8), INTENT(OUT  ) :: RA
    REAL(KIND=r8), INTENT(IN   ) :: Ztop2
    REAL(KIND=r8), INTENT(IN   ) :: Z0
    REAL(KIND=r8), INTENT(INOUT) :: D
    REAL(KIND=r8), INTENT(IN   ) :: ZZWIND
    REAL(KIND=r8), INTENT(IN   ) :: UMM1
    REAL(KIND=r8), INTENT(IN   ) :: RHOA
    REAL(KIND=r8), INTENT(IN   ) :: TMM
    REAL(KIND=r8), INTENT(OUT  ) :: U2
    REAL(KIND=r8), INTENT(OUT  ) :: USTAR
    REAL(KIND=r8), INTENT(OUT  ) :: DRAG
    REAL(KIND=r8), INTENT(IN   ) :: TA
    REAL(KIND=r8), INTENT(IN   ) :: bps
    REAL(KIND=r8), INTENT(OUT  ) :: RIB
    REAL(KIND=r8), INTENT(OUT  ) :: CU
    REAL(KIND=r8), INTENT(OUT  ) :: CT
    !
    !   LOCAL
    REAL(KIND=r8)                :: Z2
    REAL(KIND=r8)                :: CTI
    REAL(KIND=r8)                :: CUI
    REAL(KIND=r8)                :: FTT
    REAL(KIND=r8)                :: FVV
    REAL(KIND=r8)                :: G2
    REAL(KIND=r8)                :: G3
    REAL(KIND=r8)                :: GRIB
    REAL(KIND=r8)                :: GRZ2
    REAL(KIND=r8)                :: GRZL
    REAL(KIND=r8)                :: RAF
    REAL(KIND=r8)                :: RZ2
    REAL(KIND=r8)                :: RZL
    REAL(KIND=r8)                :: THM
    REAL(KIND=r8)                :: THVGM
    REAL(KIND=r8)                :: TM
    REAL(KIND=r8)                :: UEST
    REAL(KIND=r8)                :: UMM
    REAL(KIND=r8)                :: USTARN
    REAL(KIND=r8)                :: VENTN
    REAL(KIND=r8)                :: XCT1
    REAL(KIND=r8)                :: XCT2
    REAL(KIND=r8)                :: XCTU2
    REAL(KIND=r8)                :: Z22
    REAL(KIND=r8)                :: ZL
    REAL(KIND=r8)                :: UM
    REAL(KIND=r8)                :: ZWIND

    CTNI=0.0_r8;CUNI=0.0_r8;RA=0.0_r8;U2=0.0_r8;
    USTAR=0.0_r8;DRAG=0.0_r8;RIB=0.0_r8;CU=0.0_r8;CT=0.0_r8;

    Z2=0.0_r8;CTI=0.0_r8;CUI=0.0_r8;FTT=0.0_r8;
    FVV=0.0_r8;G2=0.0_r8;G3=0.0_r8;GRIB=0.0_r8;
    GRZ2=0.0_r8;GRZL=0.0_r8;RAF=0.0_r8;RZ2=0.0_r8;
    RZL=0.0_r8;THM=0.0_r8;THVGM=0.0_r8;TM=0.0_r8;
    UEST=0.0_r8;UMM=0.0_r8;USTARN=0.0_r8;VENTN=0.0_r8;XCT1=0.0_r8;XCT2=0.0_r8;
    XCTU2=0.0_r8;Z22=0.0_r8;ZL=0.0_r8;UM=0.0_r8;ZWIND=0.0_r8;
    !CUI
    !cxx             RHOA,TMM,U2,USTAR,DRAG,TA,bps0,bps1,rib,CU,CT)
    !                                                      2001,1,11
    !=======================================================================
    !
    !     CUU AND CTT ARE LINEAR  (A SIMPLIFIED VERSION, XUE ET AL. 1991)
    !
    !     FS(X) = 66.85 * X
    !     FT(X) = 0.904 * X
    !     FV(X) = 0.315 * X
    !
    !     CU AND CT ARE THE FRICTION AND HEAT TRANSFER COEFFICIENTS.
    !     CUN AND CTN ARE THE NEUTRAL FRICTION AND HEAT TRANSFER
    !     COEFFICIENTS.
    !
    G2= 0.75_r8
    G3= 0.75_r8
    Z22 = Ztop2
    Z2  = Ztop2
    ZL = Z2 + 11.785_r8 * Z0
    !crr
    ZWIND = ZZWIND
    TM    = TMM
    UMM   = UMM1
    !cxx  IF(ZWIND.LE.Z2) THEN
    !cxx     ZWIND=Z2+20.0     ! if trees are higher than model level
    !cxx                       ! increase model level by 10m
    !cxx     TM  = TMM  - (ZWIND - ZZWIND)*0.0065        ! adjust temp (lin.)
    !cxx     UMM = UMM1 + USTAR/VKC * LOG(ZWIND/ZZWIND) ! adjust wind (log.)
    !cxx  ENDIF
    !------------------------------------------------------------------------
    IF(zwind.LE.d.OR.zl.LE.d) d=MIN(zwind,zl)-0.1_r8
    !crr
    Z2 = D + Z0
    CUNI = LOG((ZWIND-D)/Z0)/VKC
    IF (ZL.LT.ZWIND) THEN
       XCT1 = LOG((ZWIND-D)/(ZL-D))
       XCT2 = LOG((ZL-D)/(Z2-D))
       XCTU2 = LOG((ZL-D)/(Z22-D))
       CTNI = (XCT1 + G3 * XCT2) / VKC
    ELSE
       XCT2 =  LOG((ZWIND-D)/(Z2-D))
       XCTU2 =  LOG((ZWIND-D)/(Z22-D))
       CTNI = G3 * XCT2 /VKC
    END IF
    !  --------------- NEUTRAL VALUES OF USTAR AND VENTMF ------------
    !
    UM=MAX(UMM,2.0_r8)
    USTARN=UM/CUNI
    VENTN =RHOA /CTNI*USTARN
    IF (ZL.LT.ZWIND) THEN
       U2 = UM - 1.0_r8 / VKC * USTARN * (XCT1 + G2 * XCTU2)
    ELSE
       U2 = UM - 1.0_r8 / VKC * USTARN * G2 * XCTU2
    END IF
    !crr
    IF(u2.LT.0.01_r8) u2=0.01_r8
    !crr
    !
    !     STABILITY BRANCH BASED ON BULK RICHARDSON NUMBER.
    !
    !      THM=TM*bps1
    !      THVGM= TRIB*bps0-THM
    THM=TM*bps !fds (06/2010)
    THVGM=TRIB-THM
    IF (TA.EQ.0.0_r8) THVGM = 0.0_r8
    RIB  = -THVGM*GRAV*(ZWIND-D) / (THM*(UM-U2)**2)
    RIB  = MAX(-10.E0_r8,RIB)
    RIB  = MIN(0.1643E0_r8,RIB)
    !
    !     NON-NEUTRON CORRECTION  (SEE XUE ET AL(1991))
    IF(RIB.LT.0.0_r8)THEN
       GRIB = +RIB
       GRZL = +RIB*(ZL-D)/(ZWIND-D)
       GRZ2 = +RIB*(Z2-D)/(ZWIND-D)
       FVV =  FV(GRIB)
       IF (ZL.LT.ZWIND) THEN
          FTT = FT(GRIB) + (G3-1.0_r8) * FT(GRZL) - G3 * FT(GRZ2)
       ELSE
          FTT = G3*(FT(GRIB) - FT(GRZ2))
       END IF
       CUI = CUNI + FVV
       CTI = CTNI + FTT
    ELSE
       RZL = RIB/(ZWIND-D)*(ZL-D)
       RZ2 = RIB/(ZWIND-D)*(Z2-D)
       FVV = FS(RIB)
       IF (ZL.LT.ZWIND) THEN
          FTT = FS(RIB) + (G3-1) * FS(RZL) - G3 * FS(RZ2)
       ELSE
          FTT = G3 * (FS(RIB) - FS(RZ2))
       END IF
       CUI = CUNI + FVV
       CTI = CTNI + FTT
    ENDIF
    !
    CU=1.0_r8/CUI
    CT=1.0_r8/CTI
    USTAR =UM*CU
    RAF = CTI / USTAR
    IF (RAF.LT.0.80_r8) RAF = 0.80_r8
    !
    RA  = RAF
    !
    UEST  = USTAR
    DRAG = RHOA * UEST*UEST
    Z2 = Z22
    !
    !------------------------------------------------------
  END SUBROUTINE RASIT5
  !------------------------------------------------------
  REAL(KIND=r8) FUNCTION FS(X)
    IMPLICIT NONE
    REAL(KIND=r8), INTENT(IN   ) :: X 
    FS = 66.85_r8 * X
  END FUNCTION FS

  REAL(KIND=r8) FUNCTION FT(X)
    IMPLICIT NONE
    REAL(KIND=r8), INTENT(IN   ) :: X 
    FT = 0.904_r8 * X
  END FUNCTION FT

  REAL(KIND=r8) FUNCTION FV(X)
    IMPLICIT NONE
    REAL(KIND=r8), INTENT(IN   ) :: X 
    FV = 0.315_r8 * X
  END FUNCTION FV

  !------------------------------------------------------
  !=======================================================================
  !
  SUBROUTINE INTERC( &
       DTT     , & !REAL(KIND=r8), INTENT(IN   ) :: DTT
       VCOVER  , & !REAL(KIND=r8), INTENT(IN   ) :: VCOVER  (2)    
       ZLT     , & !REAL(KIND=r8), INTENT(IN   ) :: ZLT     (2)    
       TM      , & !REAL(KIND=r8), INTENT(IN   ) :: TM   
       TC      , & !REAL(KIND=r8), INTENT(INOUT) :: TC   
       TGS     , & !REAL(KIND=r8), INTENT(INOUT) :: TGS  
       CAPAC   , & !REAL(KIND=r8), INTENT(INOUT) :: CAPAC   (2)    
       WWW     , & !REAL(KIND=r8), INTENT(INOUT) :: WWW     (3)    
       PPC     , & !REAL(KIND=r8), INTENT(IN   ) :: PPC
       PPL     , & !REAL(KIND=r8), INTENT(IN   ) :: PPL
       ROFF    , & !REAL(KIND=r8), INTENT(OUT  ) :: ROFF
       ZDEPTH  , & !REAL(KIND=r8), INTENT(IN   ) :: ZDEPTH  (3)    
       POROS   , & !REAL(KIND=r8), INTENT(IN   ) :: POROS
       CCX     , & !REAL(KIND=r8), INTENT(OUT  ) :: CCX
       CG      , & !REAL(KIND=r8), INTENT(OUT  ) :: CG 
       SATCO   , & !REAL(KIND=r8), INTENT(IN   ) :: SATCO 
       SATCAP  , & !REAL(KIND=r8), INTENT(IN   ) :: SATCAP  (2)
       SPWET   , & !REAL(KIND=r8), INTENT(OUT  ) :: SPWET    
       EXTK    , & !REAL(KIND=r8), INTENT(IN   ) :: EXTK     (2,3,2)
       RNOFFS  , & !REAL(KIND=r8), INTENT(INOUT) :: RNOFFS
       FILTR   , & !REAL(KIND=r8), INTENT(INOUT) :: FILTR
       SMELT     ) !REAL(KIND=r8), INTENT(OUT  ) :: SMELT
    !                                                         12 AUGUST 2000
    !=======================================================================
    !
    !     CALCULATION OF (1) INTERCEPTION AND DRAINAGE OF RAINFALL AND SNOW
    !                    (2) SPECIFIC HEAT TERMS FIXED FOR TIME STEP
    !
    !     MODIFICATION 30 DEC 1985 : NON-UNIFORM PRECIPITATION
    !     ------------      CONVECTIVE PPN. IS DESCRIBED BY AREA-INTENSITY
    !                       RELATIONSHIP :-
    !
    !                                        F(X) = A*EXP(-B*X)+C
    !
    !                       THROUGHFALL, INTERCEPTION AND INFILTRATION
    !                       EXCESS ARE FUNCTIONAL ON THIS RELATIONSHIP
    !                       AND PROPORTION OF LARGE-SCALE PPN.
    !----------------------------------------------------------------------
    !----------------------------------------------------------------------
    !
    REAL(KIND=r8), INTENT(IN   ) :: DTT
    REAL(KIND=r8), INTENT(IN   ) :: VCOVER  (2)    
    REAL(KIND=r8), INTENT(IN   ) :: ZLT     (2)    
    REAL(KIND=r8), INTENT(IN   ) :: TM   
    REAL(KIND=r8), INTENT(INOUT) :: TC   
    REAL(KIND=r8), INTENT(INOUT) :: TGS  
    REAL(KIND=r8), INTENT(INOUT) :: CAPAC   (2)    
    REAL(KIND=r8), INTENT(INOUT) :: WWW     (3)    
    REAL(KIND=r8), INTENT(IN   ) :: PPC
    REAL(KIND=r8), INTENT(IN   ) :: PPL
    REAL(KIND=r8), INTENT(OUT  ) :: ROFF
    REAL(KIND=r8), INTENT(IN   ) :: ZDEPTH  (3)    
    REAL(KIND=r8), INTENT(IN   ) :: POROS
    REAL(KIND=r8), INTENT(OUT  ) :: CCX
    REAL(KIND=r8), INTENT(OUT  ) :: CG 
    REAL(KIND=r8), INTENT(IN   ) :: SATCO 
    REAL(KIND=r8), INTENT(IN   ) :: SATCAP  (2)
    REAL(KIND=r8), INTENT(OUT  ) :: SPWET    
    REAL(KIND=r8), INTENT(IN   ) :: EXTK    (2,3,2)
    REAL(KIND=r8), INTENT(INOUT) :: RNOFFS
    REAL(KIND=r8), INTENT(INOUT) :: FILTR
    REAL(KIND=r8), INTENT(OUT  ) :: SMELT


    !
    !   LOCAL 
    !
    REAL(KIND=r8)    :: AP
    REAL(KIND=r8)    :: ARG
    REAL(KIND=r8)    :: CCA
    REAL(KIND=r8)    :: CCB
    REAL(KIND=r8)    :: CCC
    REAL(KIND=r8)    :: CCP
    REAL(KIND=r8)    :: CCT
    REAL(KIND=r8)    :: CHISL
    REAL(KIND=r8)    :: CP
    REAL(KIND=r8)    :: CSOIL
    REAL(KIND=r8)    :: D1
    REAL(KIND=r8)    :: DIFF
    REAL(KIND=r8)    :: DIFSL
    REAL(KIND=r8)    :: EQUDEP
    REAL(KIND=r8)    :: FPI
    REAL(KIND=r8)    :: FREEZE
    INTEGER :: IVEG
    REAL(KIND=r8)    :: OCEANS
    REAL(KIND=r8)    :: P0
    REAL(KIND=r8)    :: PINF
    REAL(KIND=r8)    :: POLAR
    REAL(KIND=r8)    :: ROCS
    REAL(KIND=r8)    :: ROFFO
    REAL(KIND=r8)    :: SPECHT
    REAL(KIND=r8)    :: SPWET1
    REAL(KIND=r8)    :: TEX
    REAL(KIND=r8)    :: THALAS
    REAL(KIND=r8)    :: THETA
    REAL(KIND=r8)    :: THRU
    REAL(KIND=r8)    :: TOTALP
    REAL(KIND=r8)    :: TS
    REAL(KIND=r8)    :: TSD
    REAL(KIND=r8)    :: TTA
    REAL(KIND=r8)    :: TTB
    REAL(KIND=r8)    :: TTI
    REAL(KIND=r8)    :: XS
    REAL(KIND=r8)    :: XSC
    REAL(KIND=r8)    :: ZLOAD
    REAL(KIND=r8)    :: ZMELT
    REAL(KIND=r8) :: SNOWW   (2)    
    REAL(KIND=r8) :: CAPACP  (2)    
    REAL(KIND=r8) :: SNOWP   (2)    
    REAL(KIND=r8), PARAMETER :: BP=20.0_r8
    REAL(KIND=r8) :: PCOEFS  (2,2)  
    DATA PCOEFS(1,1)/ 20.0_r8 /, PCOEFS(1,2)/ .206E-8_r8 /,                   &
         PCOEFS(2,1)/ 0.0001_r8 /, PCOEFS(2,2)/ 0.9999_r8 /

    ROFF=0.0_r8;CCX=0.0_r8;CG =0.0_r8;SPWET=0.0_r8;SMELT=0.0_r8;

    AP=0.0_r8;ARG=0.0_r8;CCA=0.0_r8;CCB=0.0_r8;
    CCC=0.0_r8;CCP=0.0_r8;CCT=0.0_r8;CHISL=0.0_r8;
    CP=0.0_r8;CSOIL=0.0_r8;D1=0.0_r8;DIFF=0.0_r8;DIFSL=0.0_r8;EQUDEP=0.0_r8;
    FPI=0.0_r8;FREEZE=0.0_r8;

    OCEANS=0.0_r8;P0=0.0_r8;PINF=0.0_r8;POLAR=0.0_r8;
    ROCS=0.0_r8;ROFFO=0.0_r8;SPECHT=0.0_r8;SPWET1=0.0_r8;
    TEX=0.0_r8;THALAS=0.0_r8;THETA=0.0_r8;THRU=0.0_r8;
    TOTALP=0.0_r8;TS=0.0_r8;TSD=0.0_r8;TTA=0.0_r8;
    TTB=0.0_r8;TTI=0.0_r8;XS=0.0_r8;XSC=0.0_r8;
    ZLOAD=0.0_r8;ZMELT=0.0_r8;SNOWW =0.0_r8;CAPACP=0.0_r8;SNOWP =0.0_r8;
    !
    AP = PCOEFS(2,1)
    CP = PCOEFS(2,2)
    TOTALP = PPC + PPL
    IF(TOTALP.LT.1.E-8_r8)GO TO 6000
    AP = PPC/TOTALP * PCOEFS(1,1) + PPL/TOTALP * PCOEFS(2,1)
    CP = PPC/TOTALP * PCOEFS(1,2) + PPL/TOTALP * PCOEFS(2,2)
6000 CONTINUE
    !
    ROFF = 0.0_r8
    THRU = 0.0_r8
    FPI  = 0.0_r8
    !
    !----------------------------------------------------------------------
    !     THERMAL CONDUCTIVITY OF THE SOIL, TAKING INTO ACCOUNT POROSITY
    !----------------------------------------------------------------------
    !
    THETA=WWW(1)*POROS
    CHISL=( 9.8E-4_r8 + 1.2E-3_r8 *THETA )/( 1.1_r8-0.4_r8*THETA )
    CHISL=CHISL*4.186E2_r8
    !
    !
    !----------------------------------------------------------------------
    !     THERMAL DIFFUSIVITY AND HEAT CAPACITYOF THE SOIL
    !----------------------------------------------------------------------
    !
    DIFSL=5.E-7_r8
    !
    ROCS =CHISL/DIFSL
    D1   =SQRT(DIFSL*86400.0_r8)
    CSOIL=ROCS*D1/SQRT(PIE)/2.0_r8
    THALAS=0.0_r8
    OCEANS=0.0_r8
    POLAR=0.0_r8
    CSOIL=CSOIL*(1.0_r8-THALAS)+10.E10_r8*OCEANS+POLAR*3.6_r8*4.2E4_r8
    !
    P0 = TOTALP * 0.001_r8
    !
    !----------------------------------------------------------------------
    !     INPUT PRECIPITATION IS GIVEN IN MM, CONVERTED TO M TO GIVE P0.
    !----------------------------------------------------------------------
    !
    DO  IVEG = 1, 2
       !
       SPWET1 = MIN ( 0.05_r8, CAPAC(IVEG))*CW
       !
       TS = TC
       SPECHT = ZLT(1) * CLAI
       IF ( IVEG .EQ. 1 ) GO TO 1100
       TS = TGS
       SPECHT = CSOIL
1100   CONTINUE
       !
       XSC = MAX(0.0_r8, CAPAC(IVEG) - SATCAP(IVEG) )
       IF(IVEG.EQ.2 .AND. TS.LE.TF )GO TO 1170
       CAPAC(IVEG) = CAPAC(IVEG) - XSC
       ROFF = ROFF + XSC
       RNOFFS = XSC*1000.0_r8 + RNOFFS
1170   CONTINUE
       CAPACP(IVEG) = 0.0_r8
       SNOWP(IVEG) = 0.0_r8
       !
       IF( TS .GT. TF ) CAPACP(IVEG) = CAPAC(IVEG)
       IF( TS .LE. TF ) SNOWP(IVEG) = CAPAC(IVEG)
       CAPAC(IVEG) = CAPACP(IVEG)
       SNOWW(IVEG) = SNOWP(IVEG)
       ZLOAD = CAPAC(IVEG) + SNOWW(IVEG)
       !
       FPI = ( 1.0_r8-EXP( - EXTK(IVEG,3,1) * ZLT(IVEG)/VCOVER(IVEG) ) )        &
            * VCOVER(IVEG)
       TTI = P0 * ( 1.0_r8-FPI )
       !
       !----------------------------------------------------------------------
       !    PROPORTIONAL SATURATED AREA (XS) AND LEAF DRAINAGE(TEX)
       !----------------------------------------------------------------------
       !
       XS = 1.0_r8
       IF ( P0 .LT. 1.E-9_r8 ) GO TO 1150
       ARG =  ( SATCAP(IVEG)-ZLOAD )/( P0*FPI*AP ) -CP/AP
       IF ( ARG .LT. 1.E-9_r8 ) GO TO 1150
       XS = -1.0_r8/BP * LOG( ARG )
       XS = MIN( XS, 1.0_r8 )
       XS = MAX( XS, 0.0_r8 )
1150   TEX = P0*FPI * ( AP/BP*( 1.0_r8- EXP( -BP*XS )) + CP*XS ) -           &
            ( SATCAP(IVEG) - ZLOAD ) * XS
       TEX = MAX( TEX, 0.0_r8 )
       !
       !----------------------------------------------------------------------
       !    TOTAL THROUGHFALL (THRU) AND STORE AUGMENTATION
       !----------------------------------------------------------------------
       !
       THRU = TTI + TEX
       IF(IVEG.EQ.2.AND.TGS.LE.TF)THRU = 0.0_r8
       !
       PINF = P0 - THRU
       IF( TM .GT. TF ) CAPAC(IVEG) = CAPAC(IVEG) + PINF
       IF( TM .LE. TF ) SNOWW(IVEG) = SNOWW(IVEG) + PINF
       !
       IF( IVEG .EQ. 1 ) GO TO 1300
       IF( TM .GT. TF ) GO TO 1200
       SNOWW(IVEG) = SNOWP(IVEG) + P0
       THRU = 0.0_r8
       GO TO 1300
       !
       !----------------------------------------------------------------------
       !    INSTANTANEOUS OVERLAND FLOW CONTRIBUTION ( ROFF )
       !----------------------------------------------------------------------
       !
1200   EQUDEP = SATCO * DTT
       !
       XS = 1.0_r8
       IF ( THRU .LT. 1.E-9_r8 ) GO TO 1250
       ARG = EQUDEP / ( THRU * AP ) -CP/AP
       IF ( ARG .LT. 1.E-9_r8 ) GO TO 1250
       XS = -1.0_r8/BP * LOG( ARG )
       XS = MIN( XS, 1.0_r8 )
       XS = MAX( XS, 0.0_r8 )
1250   ROFFO = THRU * ( AP/BP * ( 1.0_r8-EXP( -BP*XS )) + CP*XS )             &
            -EQUDEP*XS
       ROFFO = MAX ( ROFFO, 0.0_r8 )
       ROFF = ROFF + ROFFO
       RNOFFS = RNOFFS + ROFFO*1000.0_r8
       FILTR =  FILTR + (THRU - ROFFO)
       WWW(1) = WWW(1) + (THRU - ROFFO) / ( POROS*ZDEPTH(1) )
1300   CONTINUE
       !
       !----------------------------------------------------------------------
       !    TEMPERATURE CHANGE DUE TO ADDITION OF PRECIPITATION
       !----------------------------------------------------------------------
       !
       DIFF = ( CAPAC(IVEG)+SNOWW(IVEG) - CAPACP(IVEG)-SNOWP(IVEG) )*CW
       CCP = SPECHT + SPWET1
       CCT = SPECHT + SPWET1 + DIFF
       !
       TSD = ( TS * CCP + TM * DIFF ) / CCT
       !
       FREEZE = 0.0_r8
       IF ( TS .GT. TF .AND. TM .GT. TF ) GO TO 2000
       IF ( TS .LE. TF .AND. TM .LE. TF ) GO TO 2000
       !
       TTA = TS
       TTB = TM
       CCA = CCP
       CCB = DIFF
       IF ( TSD .GT. TF ) GO TO 2100
       !
       !----------------------------------------------------------------------
       !    FREEZING OF WATER ON CANOPY OR GROUND
       !----------------------------------------------------------------------
       !
       CCC = CAPACP(IVEG) * SNOMEL
       IF ( TS .LT. TM ) CCC = DIFF * SNOMEL / CW
       TSD = ( TTA * CCA + TTB * CCB + CCC ) / CCT
       !
       FREEZE = ( TF * CCT - ( TTA * CCA + TTB * CCB ) )
       FREEZE = (MIN ( CCC, FREEZE )) / SNOMEL
       IF(TSD .GT. TF)TSD = TF - 0.1_r8
       !
       GO TO 2000
       !
2100   CONTINUE
       !
       !----------------------------------------------------------------------
       !    MELTING OF SNOW ON CANOPY OR GROUND
       !----------------------------------------------------------------------
       !
       CCC = - SNOWW(IVEG) * SNOMEL
       IF ( TS .GT. TM ) CCC = - DIFF * SNOMEL / CW
       !
       TSD = ( TTA * CCA + TTB * CCB + CCC ) / CCT
       !
       FREEZE = ( TF * CCT - ( TTA * CCA + TTB * CCB ) )
       FREEZE = (MAX( CCC, FREEZE )) / SNOMEL
       IF(TSD .LE. TF)TSD = TF - 0.1_r8
       !
2000   CONTINUE
       SMELT = FREEZE
       SNOWW(IVEG) = SNOWW(IVEG) + FREEZE
       CAPAC(IVEG) = CAPAC(IVEG) - FREEZE
       !
       IF( IVEG .EQ. 1 ) TC = TSD
       IF( IVEG .EQ. 2 ) TGS = TSD
       IF( SNOWW(IVEG) .LT. 0.0000001_r8 ) GO TO 3000
       ZMELT = 0.0_r8
       !     modified to force water into soil. Xue Feb. 1994
       ZMELT = CAPAC(IVEG)
       !     IF ( TD .GT. TF ) ZMELT = CAPAC(IVEG)
       !     IF ( TD .LE. TF ) ROFF = ROFF + CAPAC(IVEG)
       CAPAC(IVEG) = 0.0_r8
       WWW(1) = WWW(1) + ZMELT / ( POROS * ZDEPTH(1) )
       FILTR = FILTR + ZMELT
       !
3000   CONTINUE
       !
       CAPAC(IVEG) = CAPAC(IVEG) + SNOWW(IVEG)
       SNOWW(IVEG) = 0.0_r8
       !
       !     **** LOAD PILPS PARAMETER
       !
       !     if (freeze.lt.0) snm(istat)=snm(istat)-freeze
       freeze=0.0_r8
       !
       P0 = THRU
       !
    END DO
    !
    !----------------------------------------------------------------------
    !    CALCULATION OF CANOPY AND GROUND HEAT CAPACITIES.
    !    N.B. THIS SPECIFICATION DOES NOT NECESSARILY CONSERVE ENERGY WHEN
    !    DEALING WITH VERY LATGE SNOWPACKS.
    !----------------------------------------------------------------------
    !
    CCX = ZLT(1) * CLAI + CAPAC(1) * CW
    SPWET = MIN ( 0.05_r8, CAPAC(2))*CW
    CG = (CSOIL + SPWET)
    !
    !------------------------------------------------------
  END SUBROUTINE INTERC
  !------------------------------------------------------

  !=======================================================================
  !                                                                       
  SUBROUTINE STOMA1( &
       GREEN    , &!   REAL(KIND=r8), INTENT(IN   ) :: GREEN  (2)    
       VCOVER   , &!   REAL(KIND=r8), INTENT(IN   ) :: VCOVER (2)    
       CHIL     , &!   REAL(KIND=r8), INTENT(IN   ) :: CHIL   (2)    
       ZLT      , &!   REAL(KIND=r8), INTENT(IN   ) :: ZLT    (2)    
       PAR      , &!   REAL(KIND=r8), INTENT(IN   ) :: PAR    (2)    
       PD       , &!   REAL(KIND=r8), INTENT(IN   ) :: PD     (2)    
       EXTK     , &!   REAL(KIND=r8), INTENT(IN   ) :: EXTK   (2,3,2)
       SUNANG   , &!   REAL(KIND=r8), INTENT(IN   ) :: SUNANG
       RST      , &!   REAL(KIND=r8), INTENT(OUT  ) :: RST    (2)    
       RSTPAR   , &!   REAL(KIND=r8), INTENT(IN   ) :: RSTPAR (2,3)
       CTLPA      )!   REAL(KIND=r8), INTENT(IN   ) :: CTLPA  
    !                                                         12 AUG 2000
    !=======================================================================
    !                                                                       
    !     CALCULATION OF PAR-LIMITED STOMATAL RESISTANCE                    
    !                                                                       
    !-----------------------------------------------------------------------
    !----------------------------------------------------------------------

    REAL(KIND=r8), INTENT(IN   ) :: GREEN  (2)    
    REAL(KIND=r8), INTENT(IN   ) :: VCOVER (2)    
    REAL(KIND=r8), INTENT(IN   ) :: CHIL   (2)    
    REAL(KIND=r8), INTENT(IN   ) :: ZLT    (2)    
    REAL(KIND=r8), INTENT(IN   ) :: PAR    (2)    
    REAL(KIND=r8), INTENT(IN   ) :: PD     (2)    
    REAL(KIND=r8), INTENT(IN   ) :: EXTK   (2,3,2)
    REAL(KIND=r8), INTENT(IN   ) :: SUNANG
    REAL(KIND=r8), INTENT(OUT  ) :: RST    (2)    
    REAL(KIND=r8), INTENT(IN   ) :: RSTPAR (2,3)
    REAL(KIND=r8), INTENT(IN   ) :: CTLPA  

    INTEGER :: IVEG
    REAL(KIND=r8)    :: AT
    REAL(KIND=r8)    :: AA
    REAL(KIND=r8)    :: BB
    REAL(KIND=r8)    :: AVFLUX
    REAL(KIND=r8)    :: EKAT
    REAL(KIND=r8)    :: GAMMA
    REAL(KIND=r8)    :: POW
    REAL(KIND=r8)    :: POW1
    REAL(KIND=r8)    :: POW2
    REAL(KIND=r8)    :: POWER1
    REAL(KIND=r8)    :: POWER2
    REAL(KIND=r8)    :: RHO4
    REAL(KIND=r8)    :: XABC
    REAL(KIND=r8)    :: ZAT
    REAL(KIND=r8)    :: ZK
    !          
    RST=0.0_r8;AT=0.0_r8;AA=0.0_r8;BB=0.0_r8;AVFLUX=0.0_r8;
    EKAT=0.0_r8;GAMMA=0.0_r8;POW=0.0_r8;POW1=0.0_r8;
    POW2=0.0_r8;POWER1=0.0_r8;POWER2=0.0_r8;RHO4=0.0_r8;
    XABC=0.0_r8;ZAT=0.0_r8;ZK=0.0_r8;
    
    DO  IVEG = 1, 2                                               
       !                                                                       
       AT = ZLT(IVEG) / VCOVER(IVEG)                                     
       !                                                                       
       IF (SUNANG .LE. 0.02_r8) THEN                                        
          XABC = RSTPAR(IVEG,1) / RSTPAR(IVEG,2) + RSTPAR(IVEG,3)        
          RST(IVEG) = 0.5_r8 / XABC * AT                                     
          IF (RST(IVEG) .LT. 0.0_r8) RST(IVEG) = 0.00001_r8                     
          GO TO 1010                                                     
       END IF
       !                                                                       
       GAMMA = ( RSTPAR(IVEG,1) + RSTPAR(IVEG,2) * RSTPAR(IVEG,3) ) /     &
            RSTPAR(IVEG,3)                                          
       !                                                                       
       POWER1 = MIN( 50.0_r8, AT * EXTK(IVEG,1,1) )                        
       POWER2 = MIN( 50.0_r8, AT * EXTK(IVEG,1,2) )                        
       !                                                                       
       !-----------------------------------------------------------------------
       !     ROSS INCLINATION FUNCTION                                         
       !-----------------------------------------------------------------------
       !                                                                       
       AA = 0.5_r8 - 0.633_r8 * CHIL(IVEG)- 0.33_r8 * CHIL(IVEG)* CHIL(IVEG)      
       BB = 0.877_r8 * ( 1.0_r8 - 2.0_r8 * AA )                                     
       !                                                                       
       !-----------------------------------------------------------------------
       !     COMBINED ESTIMATE OF K-PAR USING WEIGHTS FOR DIFFERENT COMPONENTS 
       !-----------------------------------------------------------------------
       !                                                                       
       ZAT = LOG( ( EXP(-POWER1) + 1.0_r8 )/2.0_r8 ) * PD(IVEG)                  &
            / ( POWER1/AT )                                             
       ZAT = ZAT + LOG( ( EXP(-POWER2) + 1.0_r8 )/2.0_r8 )                       &
            * ( 1.0_r8 - PD(IVEG) ) / ( POWER2/AT )                              
       !                                                                       
       POW1 = MIN( 50.0_r8, (POWER1*ZAT/AT) )                              
       POW2 = MIN( 50.0_r8, (POWER2*ZAT/AT) )                              
       !                                                                       
       ZK = 1.0_r8 / ZAT * LOG( PD(IVEG) * EXP ( POW1 )                      &
            + ( 1.0_r8 - PD(IVEG) ) * EXP ( POW2 ) )                        
       !                                                                       
       !                                                                       
       POW = MIN( 50.0_r8, ZK*AT )                                         
       EKAT = EXP ( POW )                                                
       !                                                                       
       AVFLUX = PAR(IVEG) * ( PD(IVEG) / SUNANG * ( AA + BB * SUNANG )   &
            + ( 1.0_r8 - PD(IVEG) )*( BB / 3.0_r8 + AA * 1.5_r8                    &
            + BB / 4.0_r8 * PIE ))                                          
       !                                                                       
       RHO4 = GAMMA / AVFLUX                                             
       !                                                                       
       RST(IVEG) = RSTPAR(IVEG,2)/GAMMA * LOG(( RHO4 * EKAT + 1.0_r8 ) /     &
            ( RHO4 + 1.0_r8 ) )                                     
       RST(IVEG) = RST(IVEG) - LOG (( RHO4 + 1.0_r8 / EKAT ) /               &
            ( RHO4 + 1.0_r8 ) )                                     
       RST(IVEG) = RST(IVEG) / ( ZK * RSTPAR(IVEG,3) )                   
       !                                                                       
       !---------------------------------------------------------------------- 
       !     MODIFICATIONS FOR GREEN FRACTION : RST UPRIGHT                    
       !---------------------------------------------------------------------- 
       !                                                                       
1010   RST(IVEG) = 1.0_r8 / ( RST(IVEG) * GREEN(IVEG) + 0.0000001_r8)           
    END DO!1000  CONTINUE                                                          
    !                                                                       
    RST(1) = RST(1) * CTLPA
    !
    !------------------------------------------------------
  END SUBROUTINE STOMA1
  !------------------------------------------------------

  !=======================================================================
  !                                                                       
  SUBROUTINE ROOT1( &
       PHSAT      , & !REAL(KIND=r8), INTENT(IN   ) :: WWW   (3)
       BEE        , & !REAL(KIND=r8), INTENT(IN   ) :: PHSAT
       WWW        , & !REAL(KIND=r8), INTENT(IN   ) :: BEE
       PHSOIL       ) !REAL(KIND=r8), INTENT(OUT  ) :: PHSOIL(3)
    !                                                         12 AUG 2000   
    !=======================================================================
    !                                                                       
    !    CALCULATION OF SOIL MOISTURE POTENTIALS IN ROOT ZONE OF EACH       
    !    VEGETATION LAYER AND SUMMED SOIL+ROOT RESISTANCE                   
    !                                                                       
    !-----------------------------------------------------------------------
    !----------------------------------------------------------------------
    REAL(KIND=r8), INTENT(IN   ) :: WWW   (3)
    REAL(KIND=r8), INTENT(IN   ) :: PHSAT
    REAL(KIND=r8), INTENT(IN   ) :: BEE
    REAL(KIND=r8), INTENT(OUT  ) :: PHSOIL(3)
    INTEGER :: IL
    !      
    PHSOIL=0.0_r8                                                                 
    DO  IL = 1, 3                                                 
       PHSOIL(IL) = PHSAT * MAX( 0.05_r8, WWW(IL) ) ** ( - BEE )          
    END DO
    !                                                                       
    !-----------------------------------------------------------------------
    !     AVERAGE SOIL MOISTURE POTENTIAL IN ROOT ZONE USED FOR SOURCE      
    !-----------------------------------------------------------------------
    !                                                                       
    !                                                                       
    !     PHROOT(1) = PHSOIL(1)-0.01_r8                                        
    !                                                                       
    !     DO 1200 I = 2 ,3                                                  
    !1200 PHROOT(1) = MAX( PHROOT(1), PHSOIL(I) )                         
    !     PHROOT(2) = PHROOT(1)                                             
    !                                                                       
    !                                                                       
    !------------------------------------------------------
  END SUBROUTINE ROOT1
  !------------------------------------------------------


  !=======================================================================
  !
  SUBROUTINE RADAB_ICE( &
       TRAN   , & ! REAL(KIND=r8), INTENT(IN   ) :: TRAN   (2,3,2)
       REF    , & ! REAL(KIND=r8), INTENT(IN   ) :: REF    (2,3,2)
       GREEN  , & ! REAL(KIND=r8), INTENT(IN   ) :: GREEN  (2)    
       VCOVER , & ! REAL(KIND=r8), INTENT(IN   ) :: VCOVER (2)    
       CHIL   , & ! REAL(KIND=r8), INTENT(IN   ) :: CHIL   (2)    
       ZLT    , & ! REAL(KIND=r8), INTENT(IN   ) :: ZLT    (2)    
       Z2     , & ! REAL(KIND=r8), INTENT(IN   ) :: Z2
       Z1     , & ! REAL(KIND=r8), INTENT(IN   ) :: Z1
       SOREF  , & ! REAL(KIND=r8), INTENT(IN   ) :: SOREF  (3)    
       TC     , & ! REAL(KIND=r8), INTENT(IN   ) :: TC
       TGS    , & ! REAL(KIND=r8), INTENT(IN   ) :: TGS
       SATCAP , & ! REAL(KIND=r8), INTENT(OUT  ) :: SATCAP (2)    
       EXTK   , & ! REAL(KIND=r8), INTENT(OUT  ) :: EXTK   (2,3,2)
       CLOSS  , & ! REAL(KIND=r8), INTENT(OUT  ) :: CLOSS
       GLOSS  , & ! REAL(KIND=r8), INTENT(OUT  ) :: GLOSS
       THERMK , & ! REAL(KIND=r8), INTENT(OUT  ) :: THERMK
       P1F    , & ! REAL(KIND=r8), INTENT(OUT  ) :: P1F
       P2F    , & ! REAL(KIND=r8), INTENT(OUT  ) :: P2F
       RADT   , & ! REAL(KIND=r8), INTENT(OUT  ) :: RADT   (2)    
       PAR    , & ! REAL(KIND=r8), INTENT(OUT  ) :: PAR    (2)    
       PD     , & ! REAL(KIND=r8), INTENT(OUT  ) :: PD     (2)    
       SALB   , & ! REAL(KIND=r8), INTENT(OUT  ) :: SALB   (2,2)  
       ALBEDO , & ! REAL(KIND=r8), INTENT(OUT  ) :: ALBEDO (2,3,2)
       TGEFF  , & ! REAL(KIND=r8), INTENT(OUT  ) :: TGEFF
       SUNANG , & ! REAL(KIND=r8), INTENT(IN   ) :: sunang
       XADJ   , & ! REAL(KIND=r8), INTENT(IN   ) :: xadj
       CAPAC  , & ! REAL(KIND=r8), INTENT(IN   ) :: CAPAC  (2)    
       RADN   , & ! REAL(KIND=r8), INTENT(IN   ) :: RADN   (3,2)  
       bedo   , & ! REAL(KIND=r8), INTENT(OUT  ) :: bedo
       ZLWUP  , & ! REAL(KIND=r8), INTENT(OUT  ) :: ZLWUP
       RADFRAC, & ! REAL(KIND=r8), INTENT(IN   ) :: RADFRAC(2,2)  
       SWDOWN , & ! REAL(KIND=r8), INTENT(IN   ) :: SWDOWN
       SCOV2  , & ! REAL(KIND=r8), INTENT(OUT  ) :: SCOV2
       ISICE  , & ! INTEGER, INTENT(IN) :: ISICE
       fsdown , & ! REAL(KIND=r8), INTENT(OUT  ) :: fsdown
       fldown , & ! REAL(KIND=r8), INTENT(OUT  ) :: fldown
       fsup   , & ! REAL(KIND=r8), INTENT(OUT  ) :: fsup
       flup     ) ! REAL(KIND=r8), INTENT(OUT  ) :: flup
    !                                                         11 AUGUST 2000
    !=======================================================================
    !
    !     CALCULATION OF ALBEDOS VIA TWO STREAM APPROXIMATION( DIRECT
    !     AND DIFFUSE ) AND PARTITION OF RADIANT ENERGY
    !
    !-----------------------------------------------------------------------
    !----------------------------------------------------------------------
    REAL(KIND=r8), INTENT(IN   ) :: TRAN   (2,3,2)
    REAL(KIND=r8), INTENT(IN   ) :: REF    (2,3,2)
    REAL(KIND=r8), INTENT(IN   ) :: GREEN  (2)    
    REAL(KIND=r8), INTENT(IN   ) :: VCOVER (2)    
    REAL(KIND=r8), INTENT(IN   ) :: CHIL   (2)    
    REAL(KIND=r8), INTENT(IN   ) :: ZLT    (2)    
    REAL(KIND=r8), INTENT(IN   ) :: Z2
    REAL(KIND=r8), INTENT(IN   ) :: Z1
    REAL(KIND=r8), INTENT(IN   ) :: SOREF  (3)    
    REAL(KIND=r8), INTENT(IN   ) :: TC
    REAL(KIND=r8), INTENT(IN   ) :: TGS
    REAL(KIND=r8), INTENT(OUT  ) :: SATCAP (2)    
    REAL(KIND=r8), INTENT(OUT  ) :: EXTK   (2,3,2)
    REAL(KIND=r8), INTENT(OUT  ) :: CLOSS
    REAL(KIND=r8), INTENT(OUT  ) :: GLOSS
    REAL(KIND=r8), INTENT(OUT  ) :: THERMK
    REAL(KIND=r8), INTENT(OUT  ) :: P1F
    REAL(KIND=r8), INTENT(OUT  ) :: P2F
    REAL(KIND=r8), INTENT(OUT  ) :: RADT   (2)    
    REAL(KIND=r8), INTENT(OUT  ) :: PAR    (2)    
    REAL(KIND=r8), INTENT(OUT  ) :: PD     (2)    
    REAL(KIND=r8), INTENT(OUT  ) :: SALB   (2,2)  
    REAL(KIND=r8), INTENT(OUT  ) :: ALBEDO (2,3,2)
    REAL(KIND=r8), INTENT(OUT  ) :: TGEFF
    REAL(KIND=r8), INTENT(IN   ) :: sunang
    REAL(KIND=r8), INTENT(IN   ) :: xadj
    REAL(KIND=r8), INTENT(IN   ) :: CAPAC  (2)    
    REAL(KIND=r8), INTENT(IN   ) :: RADN   (3,2)  
    REAL(KIND=r8), INTENT(OUT  ) :: bedo
    REAL(KIND=r8), INTENT(OUT  ) :: ZLWUP
    REAL(KIND=r8), INTENT(IN   ) :: RADFRAC(2,2)  
    REAL(KIND=r8), INTENT(IN   ) :: SWDOWN
    REAL(KIND=r8), INTENT(OUT  ) :: SCOV2
    INTEGER      , INTENT(IN) :: ISICE
    REAL(KIND=r8), INTENT(OUT  ) :: fsdown
    REAL(KIND=r8), INTENT(OUT  ) :: fldown
    REAL(KIND=r8), INTENT(OUT  ) :: fsup
    REAL(KIND=r8), INTENT(OUT  ) :: flup

    REAL(KIND=r8) :: TRANC1 (2)    
    REAL(KIND=r8) :: TRANC2 (2)    
    REAL(KIND=r8) :: TRANC3 (2)    
    REAL(KIND=r8) :: RADFAC (2,2,2)
    REAL(KIND=r8) :: RADSAV (12)   
    !
    ! LOCAL
    !
    REAL(KIND=r8)    :: AA
    REAL(KIND=r8)    :: ACSS
    REAL(KIND=r8)    :: ALPHA
    REAL(KIND=r8)    :: BB
    REAL(KIND=r8)    :: BE
    REAL(KIND=r8)    :: BETA
    REAL(KIND=r8)    :: BETAO
    REAL(KIND=r8)    :: BOT
    REAL(KIND=r8)    :: CCE
    REAL(KIND=r8)    :: CE
    REAL(KIND=r8)    :: CHIV
    REAL(KIND=r8)    :: DE
    REAL(KIND=r8)    :: DELTA
    REAL(KIND=r8)    :: DEN
    REAL(KIND=r8)    :: DEPCOV
    REAL(KIND=r8)    :: EK
    REAL(KIND=r8)    :: EPSI
    REAL(KIND=r8)    :: EXTKB
    REAL(KIND=r8)    :: f
    REAL(KIND=r8)    :: F1
    REAL(KIND=r8)    :: FAC
    REAL(KIND=r8)    :: FAC1
    REAL(KIND=r8)    :: FAC2
    REAL(KIND=r8)    :: FE
    REAL(KIND=r8)    :: FFE
    REAL(KIND=r8)    :: FMELT
    REAL(KIND=r8)    :: GAMMA
    REAL(KIND=r8)    :: GE
    INTEGER          :: irad
    INTEGER          :: IVDUM
    INTEGER          :: iveg
    INTEGER          :: iwave
    REAL(KIND=r8)    :: P1
    REAL(KIND=r8)    :: P2
    REAL(KIND=r8)    :: POWER1
    REAL(KIND=r8)    :: POWER2
    REAL(KIND=r8)    :: PROJ
    REAL(KIND=r8)    :: PSI
    REAL(KIND=r8)    :: REFF1
    INTEGER :: ii
    INTEGER :: jj
    INTEGER :: nymdh
    REAL(KIND=r8)    :: REFF2
    REAL(KIND=r8)    :: ROSB
    REAL(KIND=r8)    :: ROSD
    REAL(KIND=r8)    :: SCAT
    REAL(KIND=r8)    :: SCOV
    REAL(KIND=r8)    :: SDEP
    REAL(KIND=r8)    :: sibsu
    REAL(KIND=r8)    :: SIGE
    REAL(KIND=r8)    :: ssum
    REAL(KIND=r8)    :: SWCAN
    REAL(KIND=r8)    :: SWGND
    REAL(KIND=r8)    :: TC4
    REAL(KIND=r8)    :: TG4
    REAL(KIND=r8)    :: TORE
    REAL(KIND=r8)    :: TRAN1
    REAL(KIND=r8)    :: TRAN2
    REAL(KIND=r8)    :: UPSCAT
    REAL(KIND=r8)    :: x0
    REAL(KIND=r8)    :: x1
    REAL(KIND=r8)    :: x2
    REAL(KIND=r8)    :: x3
    REAL(KIND=r8)    :: xx
    REAL(KIND=r8)    :: xy
    REAL(KIND=r8)    :: ZAT
    REAL(KIND=r8)    :: ZKAT
    REAL(KIND=r8)    :: ZMEW
    REAL(KIND=r8)    :: ZMK
    REAL(KIND=r8)    :: ZP
    SATCAP =0.0_r8;EXTK   =0.0_r8;CLOSS=0.0_r8;GLOSS=0.0_r8
    THERMK=0.0_r8;P1F=0.0_r8;P2F=0.0_r8;RADT   =0.0_r8
    PAR    =0.0_r8;PD    =0.0_r8;SALB   =0.0_r8;ALBEDO =0.0_r8
    TGEFF=0.0_r8;bedo=0.0_r8;ZLWUP=0.0_r8;SCOV2=0.0_r8
   fsdown=0.0_r8;fldown=0.0_r8;fsup=0.0_r8;flup=0.0_r8
   
    AA=0.0_r8;ACSS=0.0_r8;ALPHA=0.0_r8;BB=0.0_r8;BE=0.0_r8
    BETA=0.0_r8;BETAO=0.0_r8   ;BOT=0.0_r8;CCE=0.0_r8
    CE=0.0_r8;CHIV=0.0_r8;DE=0.0_r8;DELTA=0.0_r8
    DEN=0.0_r8;DEPCOV=0.0_r8;EK=0.0_r8;EPSI=0.0_r8
    EXTKB=0.0_r8;f=0.0_r8;F1=0.0_r8;FAC=0.0_r8
    FAC1=0.0_r8;FAC2=0.0_r8;FE=0.0_r8;FFE=0.0_r8
    FMELT=0.0_r8;GAMMA=0.0_r8;GE=0.0_r8;irad=0
    IVDUM=0;iveg=0;iwave=0;P1=0.0_r8
    P2=0.0_r8;POWER1=0.0_r8;POWER2=0.0_r8;PROJ=0.0_r8
    PSI=0.0_r8;REFF1=0.0_r8



    REFF2=0.0_r8;ROSB=0.0_r8;ROSD=0.0_r8;SCAT=0.0_r8
    SCOV=0.0_r8;SDEP=0.0_r8;sibsu=0.0_r8;SIGE=0.0_r8
    ssum=0.0_r8;SWCAN=0.0_r8;SWGND=0.0_r8;TC4=0.0_r8
    TG4=0.0_r8;TORE=0.0_r8;TRAN1=0.0_r8;TRAN2=0.0_r8
    UPSCAT=0.0_r8;x0=0.0_r8;x1=0.0_r8;x2=0.0_r8
    x3=0.0_r8;xx=0.0_r8;xy=0.0_r8;ZAT=0.0_r8
    ZKAT=0.0_r8;ZMEW=0.0_r8;ZMK=0.0_r8;ZP=0.0_r8
    nymdh=0
    jj=0
    ii=0
    f=MAX(sunang,0.01746_r8)
    !
    !----------------------------------------------------------------------
    !     CALCULATION OF MAXIMUM WATER STORAGE VALUES.
    !----------------------------------------------------------------------
    !
    FMELT = 1.0_r8
    !PRINT*,'RADAB_ICE' ,ZLT(1), ZLT(2), TGS,TF

    IF ( ABS(TF-TGS) .LT. 0.5_r8 ) FMELT = 0.6_r8
    SATCAP(1) =  ZLT(1) * 0.0001_r8
    SATCAP(2) =  ZLT(2) * 0.0001_r8
    DEPCOV = MAX( 0.0_r8, (CAPAC(2)*5.0_r8-Z1) )
    DEPCOV = MIN( DEPCOV, (Z2-Z1)*0.95_r8 )
    SATCAP(1) = SATCAP(1) * ( 1.0_r8 - DEPCOV / ( Z2 - Z1 ) )
    !----------------------------------------------------------------------
    DO  iveg  = 1, 2
       DO  iwave = 1, 3
          DO  irad  = 1, 2
             albedo(iveg,iwave,irad)=0.0_r8
          END DO
       END DO
    END DO
    !----------------------------------------------------------------------
    DO IWAVE = 1,2
       !      DO 1000 IWAVE = 1,2
       !
       !DO 2000 IVDUM = 1,2 
       DO  IVDUM = 1,2
          IF ( IVDUM .EQ. 1 ) IVEG = 2
          IF ( IVDUM .EQ. 2 ) IVEG = 1
          !----------------------------------------------------------------------
          !----------------------------------------------------------------------
          !     MODIFICATION FOR EFFECT OF SNOW ON UPPER STOREY ALBEDO
          !         SNOW REFLECTANCE   = 0.80, 0.40 . MULTIPLY BY 0.6 IF MELTING
          !         SNOW TRANSMITTANCE = 0.20, 0.54
          !         SNOW REFLECTANCE   = 0.85, 0.65 . MULTIPLY BY 0.6 IF MELTING
          !
          !----------------------------------------------------------------------
          SCOV = 0.0_r8
          IF( IVEG .EQ. 2 ) GO TO 100
          IF( TC .LE. TF ) SCOV =  MIN( 0.5_r8, CAPAC(1) / SATCAP(1) )
100       CONTINUE
          REFF1 = ( 1.0_r8 - SCOV ) * REF(IVEG,IWAVE,1) + SCOV * ( 1.2_r8 -        &
               IWAVE * 0.4_r8 ) * FMELT
          REFF2 = ( 1.0_r8 - SCOV ) * REF(IVEG,IWAVE,2) + SCOV * ( 1.2_r8 -        &
               IWAVE * 0.4_r8 ) * FMELT
          TRAN1 = TRAN(IVEG,IWAVE,1) * ( 1.0_r8 - SCOV )                        &
               + SCOV * ( 1.0_r8- ( 1.2_r8 - IWAVE * 0.4_r8 ) * FMELT )            &
               * TRAN(IVEG,IWAVE,1)
          TRAN2 = TRAN(IVEG,IWAVE,2) * ( 1.0_r8 - SCOV )                        &
               + SCOV * ( 1.0_r8- ( 1.2_r8 - IWAVE * 0.4_r8 ) * FMELT ) * 0.9_r8      &
               * TRAN(IVEG,IWAVE,2)

          !----------------------------------------------------------------------
          !
          SCAT = GREEN(IVEG)*( TRAN1 + REFF1 ) +( 1.0_r8 - GREEN(IVEG) ) *      &
               ( TRAN2 + REFF2)
          CHIV = CHIL(IVEG)
          !
          IF ( ABS(CHIV) .LE. 0.01_r8 ) CHIV = 0.01_r8
          AA = 0.5_r8 - 0.633_r8 * CHIV - 0.33_r8 * CHIV * CHIV
          BB = 0.877_r8 * ( 1.0_r8 - 2.0_r8 * AA )
          !
          PROJ = AA + BB * F
          EXTKB = ( AA + BB * F ) / F
          ZMEW = 1.0_r8 / BB * ( 1.0_r8 - AA / BB * LOG ( ( AA + BB ) / AA ) )
          ACSS = SCAT / 2.0_r8 * PROJ / ( PROJ + F * BB )
          ACSS = ACSS * ( 1.0_r8 - F * AA / ( PROJ + F * BB ) * LOG ( ( PROJ   &
               +   F * BB + F * AA ) / ( F * AA ) ) )
          !
          EXTK( IVEG, IWAVE, 1 ) = PROJ / F * SQRT( 1.0_r8-SCAT )
          EXTK( IVEG, IWAVE, 2 ) = 1.0_r8 / ZMEW * SQRT( 1.0_r8-SCAT )
          EXTK( IVEG, 3, 1 ) = AA + BB
          EXTK( IVEG, 3, 2 ) = 1.0_r8/ZMEW
          !
          UPSCAT = GREEN(IVEG) * TRAN1 + ( 1.0_r8 - GREEN(IVEG) ) * TRAN2
          UPSCAT = 0.5_r8 * ( SCAT + ( SCAT - 2.0_r8 * UPSCAT ) *                  &
               (( 1.0 - CHIV ) / 2.0_r8 ) ** 2 )
          !
          BETAO = ( 1.0_r8 + ZMEW * EXTKB ) / ( SCAT * ZMEW * EXTKB ) * ACSS
          !
          !----------------------------------------------------------------------
          !
          !     DICKINSON'S VALUES
          !
          BE = 1.0_r8 - SCAT + UPSCAT
          CE = UPSCAT
          BOT = ( ZMEW * EXTKB ) ** 2 + ( CE**2 - BE**2 )
          IF ( ABS(BOT) .GT. 1.E-10_r8) GO TO 200
          SCAT = SCAT* 0.98_r8
          BE = 1.0_r8 - SCAT + UPSCAT
          BOT = ( ZMEW * EXTKB ) ** 2 + ( CE**2 - BE**2 )
200       CONTINUE
          DE = SCAT * ZMEW * EXTKB * BETAO
          FE = SCAT * ZMEW * EXTKB * ( 1.0_r8 - BETAO )
          !----------------------------------------------------------------------
          !
          CCE = DE * BE - ZMEW * DE * EXTKB + CE * FE
          FFE = BE * FE + ZMEW * FE * EXTKB + CE * DE
          !
          TORE = -CCE / BOT
          SIGE = -FFE / BOT
          !
          PSI = SQRT(BE**2 - CE**2)/ZMEW
          !
          !----------------------------------------------------------------------
          !     REDUCTION IN EXPOSED HEIGHT OF UPPER STOREY AS SNOW ACCUMULATES
          !
          SDEP = CAPAC(2) * 5.0_r8
          FAC = ( SDEP - Z1 ) / ( Z2 - Z1 )
          FAC = MAX( 0.0_r8, FAC )
          FAC = MIN( 0.99_r8, FAC )
          !
          ZAT = ZLT(IVEG) / VCOVER(IVEG)
          IF ( IVEG .EQ. 1 ) ZAT = ZAT * (1.0_r8-FAC)
          !
          POWER1 = MIN( PSI*ZAT, 50.0_r8 )
          POWER2 = MIN( EXTKB*ZAT, 50.0_r8 )
          EPSI = EXP( - POWER1 )
          EK = EXP ( - POWER2 )
          !
          ROSB = SOREF(IWAVE)
          ROSD = SOREF(IWAVE)
          IF ( IVEG .EQ. 2 ) GO TO 300
          ROSB = ALBEDO(2,IWAVE,1)
          ROSD = ALBEDO(2,IWAVE,2)
300       CONTINUE
          !
          GE = ROSB / ROSD
          !
          !-----------------------------------------------------------------------
          !     CALCULATION OF DIFFUSE ALBEDOS
          !-----------------------------------------------------------------------
          !
          F1 = BE - CE / ROSD
          ZP = ZMEW * PSI
          !
          DEN = ( BE + ZP ) * ( F1 - ZP ) / EPSI -                          &
               ( BE - ZP ) * ( F1 + ZP ) * EPSI
          ALPHA = CE * ( F1 - ZP ) / EPSI / DEN
          BETA = -CE * ( F1 + ZP ) * EPSI / DEN
          F1 = BE - CE * ROSD
          DEN = ( F1 + ZP ) / EPSI - ( F1 - ZP ) * EPSI
          !
          GAMMA = ( F1 + ZP ) / EPSI / DEN
          DELTA = - ( F1 - ZP ) * EPSI / DEN
          !
          ALBEDO(IVEG,IWAVE,2) =  ALPHA + BETA
          !
          IF ( IVEG .EQ. 1 ) GO TO 400
          SCOV2 = 0.0_r8
          !crr   CORRECTION FOR KEEPING ALBEDO HIGH OVER SNOW
          IF (ISICE.EQ.1) SCOV2=1.0_r8
          !
          IF ( TGS .LE. TF ) SCOV2 = MIN( 1.0_r8, CAPAC(2) / 0.004_r8 )
          ALBEDO(2,IWAVE,2)= ROSD * ( 1.0_r8 - VCOVER(2) ) + ALBEDO(2,IWAVE,2) * VCOVER(2)
          ALBEDO(2,IWAVE,2) =                                               &
               ( 1.0_r8 - SCOV2 ) * ALBEDO(2,IWAVE,2) + SCOV2 *                     &
               ( 1.2_r8-IWAVE*0.4_r8 ) * FMELT
400       CONTINUE
          !
          TRANC2(IWAVE) = GAMMA * EPSI + DELTA / EPSI
          !
          !-----------------------------------------------------------------------
          !     CALCULATION OF DIRECT ALBEDOS
          !-----------------------------------------------------------------------
          !
          F1 = BE - CE / ROSD
          ZMK = ZMEW * EXTKB
          !
          DEN = ( BE + ZP ) * ( F1 - ZP ) / EPSI -                          &
               ( BE - ZP ) * ( F1 + ZP ) * EPSI
          ALPHA = ( DE - TORE * ( BE + ZMK ) ) * ( F1 - ZP ) / EPSI -       &
               ( BE - ZP ) * ( DE - CE*GE - TORE * ( F1 + ZMK ) ) * EK
          ALPHA = ALPHA / DEN
          BETA = ( BE + ZP ) * (DE - CE*GE - TORE * ( F1 + ZMK ))* EK -     &
               ( DE - TORE * ( BE + ZMK ) ) * ( F1 + ZP ) * EPSI
          BETA = BETA / DEN
          F1 = BE - CE * ROSD
          DEN = ( F1 + ZP ) / EPSI - ( F1 - ZP ) * EPSI
          GAMMA = - SIGE * ( F1 + ZP ) / EPSI -                             &
               ( FE + CE * GE * ROSD + SIGE * ( ZMK - F1 ) ) * EK
          GAMMA = GAMMA / DEN
          DELTA = ( CE * GE * ROSD + FE + SIGE * ( ZMK - F1 ) ) * EK        &
               + SIGE * ( F1 - ZP ) * EPSI
          DELTA = DELTA / DEN
          !
          ALBEDO(IVEG,IWAVE,1) = TORE + ALPHA + BETA
          !
          !----------------------------------------------------------------------
          !
          IF( IVEG .EQ. 1 ) GO TO 500
          ALBEDO(2,IWAVE,1) = ROSB * ( 1.0_r8 - VCOVER(2) )                     &
               + ALBEDO(2,IWAVE,1) * VCOVER(2)
          ALBEDO(2,IWAVE,1) = ( 1.0_r8 - SCOV2 ) * ALBEDO(2,IWAVE,1) +          &
               SCOV2 * ( 1.2_r8-IWAVE*0.4_r8 ) * FMELT
          !
500       CONTINUE
          !
          TRANC1(IWAVE) = EK
          TRANC3(IWAVE) = SIGE * EK + GAMMA * EPSI + DELTA / EPSI
          !
       END DO!2000  CONTINUE
       !
       !----------------------------------------------------------------------
       !     CALCULATION OF TERMS WHICH MULTIPLY INCOMING SHORT WAVE FLUXES
       !     TO GIVE ABSORPTION OF RADIATION BY CANOPY AND GROUND
       !----------------------------------------------------------------------
       !
       RADFAC(2,IWAVE,1) = ( 1.0_r8-VCOVER(1) ) * ( 1.0_r8-ALBEDO(2,IWAVE,1) )   &
            + VCOVER(1) * ( TRANC1(IWAVE) * ( 1.0_r8-ALBEDO(2,IWAVE,1) )   &
            + TRANC3(IWAVE) * ( 1.0_r8-ALBEDO(2,IWAVE,2) ) )
       !
       RADFAC(2,IWAVE,2) = ( 1.0_r8-VCOVER(1) ) * ( 1.0_r8-ALBEDO(2,IWAVE,2) )   &
            + VCOVER(1) *  TRANC2(IWAVE) * ( 1.0_r8-ALBEDO(2,IWAVE,2) )
       !
       RADFAC(1,IWAVE,1) = VCOVER(1) * ( ( 1.0_r8-ALBEDO(1,IWAVE,1) )        &
            - TRANC1(IWAVE) * ( 1.0_r8-ALBEDO(2,IWAVE,1) )                 &
            - TRANC3(IWAVE) * ( 1.0_r8-ALBEDO(2,IWAVE,2) ) )
       !
       RADFAC(1,IWAVE,2) = VCOVER(1) * ( ( 1.0_r8-ALBEDO(1,IWAVE,2) )        &
            - TRANC2(IWAVE) * ( 1.0_r8-ALBEDO(2,IWAVE,2) ) )
       !
       !     XQQ(1,IWAVE,1) = RADFAC(1,IWAVE,1)
       !     XQQ(1,IWAVE,2) = RADFAC(1,IWAVE,2)
       !     XQQ(2,IWAVE,1) = RADFAC(2,IWAVE,1)
       !     XQQ(2,IWAVE,2) = RADFAC(2,IWAVE,2)
       !
       !----------------------------------------------------------------------
       !     CALCULATION OF TOTAL SURFACE ALBEDOS ( SALB )
       !
       DO  IRAD = 1, 2
          SALB(IWAVE,IRAD) = ( 1.0_r8-VCOVER(1) ) * ALBEDO(2,IWAVE,IRAD) +      &
                                      VCOVER(1) * ALBEDO(1,IWAVE,IRAD)
       END DO!3000  CONTINUE
       !
       !----------------------------------------------------------------------
       !     SAVING OF EXTINCTION COEFFICIENTS ( PAR ) FOR STOMAT CALCULATION
       !----------------------------------------------------------------------
       IF ( IWAVE .EQ. 2 ) GO TO 600
       RADSAV(1) = 1.0_r8 - VCOVER(1)                                        &
            + VCOVER(1) * ( TRANC1(IWAVE) + TRANC3(IWAVE) )
       RADSAV(2) = 1.0_r8 - VCOVER(1) + VCOVER(1) * TRANC2(IWAVE)
600    CONTINUE
       !
    END DO!1000  CONTINUE

    !
    !     albedo adjustment ==============================================
    !
    IF (xadj.EQ.0.0_r8) go to 730
    xx = radfac(1,1,2) + radsav(2)
    xy = radfac(1,1,1) + radsav(1)
    ssum = salb(1,1)*radfrac(1,1) + salb(1,2)*radfrac(1,2)+           &
         salb(2,1)*radfrac(2,1) + salb(2,2)*radfrac(2,2)
    !     for diffuse albedo
    DO  iwave = 1, 2
       salb(iwave,2) = salb(iwave,2) + xadj * salb(iwave,2) / ssum
       x0 = 1.0_r8 - salb(iwave,2)
       x1 = radfac(1,iwave,2) + radfac(2,iwave,2)
       x2 = radfac(1,iwave,2) / x1
       x3 = radfac(2,iwave,2) / x1
       radfac(1,iwave,2) = x0 * x2
       radfac(2,iwave,2) = x0 * x3
       IF (salb(iwave,2).GT.1.0_r8.OR.radfac(1,iwave,2).GT.1.0_r8.OR.            &
            radfac(2,iwave,2).GT.1.0_r8.OR.salb(iwave,2).LT.0.0_r8.OR.            &
            radfac(1,iwave,2).LT.0.0_r8.OR.radfac(2,iwave,2).LT.0.0_r8) THEN
          STOP 999
       END IF
    END DO!650  continue
    ! 
    !     for direct albedo
    !
    DO  iwave = 1, 2
       salb(iwave,1) = salb(iwave,1) + xadj * salb(iwave,1) / ssum
       x0 = 1.0_r8 - salb(iwave,1)
       x1 = radfac(1,iwave,1) + radfac(2,iwave,1)
       x2 = radfac(1,iwave,1) / x1
       x3 = radfac(2,iwave,1) / x1
       radfac(1,iwave,1) = x0 * x2
       radfac(2,iwave,1) = x0 * x3
       radsav(1) =  xy - radfac(1,1,1)
       radsav(2) =  xx - radfac(1,1,2)
       IF (salb(iwave,1).GT.1.0_r8.OR.radfac(1,iwave,1).GT.1.0_r8.OR.             &
            radfac(2,iwave,1).GT.1.0_r8.OR.salb(iwave,1).LT.0.0_r8.OR.             &
            radfac(1,iwave,1).LT.0.0_r8.OR.radfac(2,iwave,1).LT.0.0_r8) THEN
          WRITE(7,740) nymdh,iwave,salb(iwave,1),radfac(1,iwave,1),      &
               radfac(2,iwave,1)
          STOP 999
       END IF
    END DO
740 FORMAT(1x,'unREAL(KIND=r8)istic value',2i12,4e11.4)
730 CONTINUE
    !***************** end adjustment *******************************
    sibsu = radn(1,1)*salb(1,1) + radn(1,2)*salb(1,2)                   &
          + radn(2,1)*salb(2,1) + radn(2,2)*salb(2,2)
    IF ((swdown.GT.0.01_r8).AND.(sibsu.GT.0.01_r8)) THEN
       bedo = sibsu / swdown
       IF (bedo.GT.1.0_r8) THEN
          salb(1,1)=0.8_r8
          salb(1,2)=0.8_r8
          salb(2,1)=0.4_r8
          salb(2,1)=0.4_r8
          sibsu =  0.0_r8
          bedo = .1_r8
          PRINT*,'albebo incorrect',ii,jj,bedo,sibsu,swdown, &
               radn(1,1),radn(1,2),radn(2,1),radn(2,2)
       ENDIF
    ELSE
       sibsu = 0.0_r8
       bedo = .1_r8
    ENDIF
    !--------------------------------------------------------------------
    !     bedo = sibsu/swdown
    !     bedo = min(max(bedo,0.001),1.0)
    !--------------------------------------------------------------------
    !
    !     CALCULATION OF LONG-WAVE FLUX TERMS FROM CANOPY AND GROUND
    !
    !----------------------------------------------------------------------
    !
    TC4 = TC * TC * TC * TC
    TG4 = TGS * TGS * TGS * TGS
    !
    ZKAT = EXTK(1,3,2) * ZLT(1) / VCOVER(1)
    ZKAT = MIN( 50.0_r8 , ZKAT )
    ZKAT = MAX( 1.E-5_r8, ZKAT )
    THERMK = EXP(-ZKAT)
    !
    FAC1 =  VCOVER(1) * ( 1.0_r8-THERMK )
    FAC2 =  1.0_r8
    CLOSS =  2.0_r8 * FAC1 * STEFAN * TC4
    CLOSS =  CLOSS - FAC2 * FAC1 * STEFAN * TG4
    GLOSS =  FAC2 * STEFAN * TG4
    GLOSS =  GLOSS - FAC1 * FAC2 * STEFAN * TC4
    !
    ZLWUP =  FAC1 * STEFAN * TC4 + (1.0_r8 - FAC1 ) * FAC2 * STEFAN * TG4
    TGEFF = SQRT( SQRT ( ( ZLWUP / STEFAN ) ) )
    !
    RADSAV(3) = EXTK(1,1,1)
    RADSAV(4) = EXTK(1,1,2)
    RADSAV(5) = EXTK(2,1,1)
    RADSAV(6) = EXTK(2,1,2)
    RADSAV(7) = THERMK
    RADSAV(8) = EXTK(1,3,1)
    RADSAV(9) = EXTK(2,3,1)
    RADSAV(10)= CLOSS
    RADSAV(11)= GLOSS
    RADSAV(12)= TGEFF
    !
    !-----------------------------------------------------------------------
    !
    !     CALCULATION OF ABSORPTION OF RADIATION BY SURFACE
    !
    !-----------------------------------------------------------------------
    !
    P1F         = RADSAV(1)
    P2F         = RADSAV(2)
    EXTK(1,1,1) = RADSAV(3)
    EXTK(1,1,2) = RADSAV(4)
    EXTK(2,1,1) = RADSAV(5)
    EXTK(2,1,2) = RADSAV(6)
    THERMK      = RADSAV(7)
    EXTK(1,3,1) = RADSAV(8)
    EXTK(2,3,1) = RADSAV(9)
    CLOSS       = RADSAV(10)
    GLOSS       = RADSAV(11)
    TGEFF       = RADSAV(12)
    !
    !----------------------------------------------------------------------
    !     SUMMATION OF SHORT-WAVE RADIATION ABSORBED BY CANOPY AND GROUND
    !----------------------------------------------------------------------
    !
    RADT(1) = 0._r8
    RADT(2) = 0._r8
    !
    DO  IVEG  = 1, 2
       DO  IWAVE = 1, 2
          DO  IRAD  = 1, 2
             !
             RADT(IVEG) = RADT(IVEG)+RADFAC(IVEG,IWAVE,IRAD)*RADN(IWAVE,IRAD)
             !
          END DO
       END DO
    END DO
    !=========================================================================
    fsdown = radn(1,1)+radn(1,2)+radn(2,1)+radn(2,2)
    fsup   = fsdown-radt(1)-radt(2)
    !=========================================================================
    !
    SWCAN=RADT(1)
    SWGND=RADT(2)
    !
    RADT(1) = RADT(1) + RADN(3,2)*VCOVER(1)*(1.0_r8- THERMK)              &
         - CLOSS
    RADT(2) = RADT(2) + RADN(3,2)*( 1.0_r8-VCOVER(1)*(1-THERMK) )         &
         - GLOSS
    !=========================================================================
    fldown = radn(3,2)
    flup   = closs+gloss
    !=========================================================================
    !
    PAR(1) = RADN(1,1) + RADN(1,2) + 0.001_r8
    PD(1) = ( RADN(1,1) + 0.001_r8 ) / PAR(1)
    P1 = P1F * RADN(1,1) + 0.001_r8
    P2 = P2F * RADN(1,2)
    PAR(2) = P1 + P2
    PD(2) = P1 / PAR(2)
    !
    !------------------------------------------------------
  END SUBROUTINE RADAB_ICE

  !=======================================================================
  !                                                                       
  SUBROUTINE VEGOUT( &
       XTRAN     , & !INTEGER, INTENT(IN   )  :: ITYPE
       XREF      , & !INTEGER, INTENT(IN   )  :: MONTH
       XGREEN    , & !REAL(KIND=r8)   , INTENT(OUT  )  :: XGREEN  (2)
       XVCOVER   , & !REAL(KIND=r8)   , INTENT(OUT  )  :: XVCOVER (2)
       XCHIL     , & !REAL(KIND=r8)   , INTENT(OUT  )  :: XZLT    (2)
       XRSTPAR   , & !REAL(KIND=r8)   , INTENT(OUT  )  :: XCHIL   (2)
       XTOPT     , & !REAL(KIND=r8)   , INTENT(OUT  )  :: XTOPT   (2)
       XTL       , & !REAL(KIND=r8)   , INTENT(OUT  )  :: XTL     (2)
       XTU       , & !REAL(KIND=r8)   , INTENT(OUT  )  :: XTU     (2)
       XDEFAC    , & !REAL(KIND=r8)   , INTENT(OUT  )  :: XDEFAC  (2)
       XPH1      , & !REAL(KIND=r8)   , INTENT(OUT  )  :: XPH1    (2)
       XPH2      , & !REAL(KIND=r8)   , INTENT(OUT  )  :: XPH2    (2)
       XZLT      , & !REAL(KIND=r8)   , INTENT(OUT  )  :: XROOTD  (2)
       XZ0       , & !REAL(KIND=r8)   , INTENT(OUT  )  :: XSOREF  (3)
       XDD       , & !REAL(KIND=r8)   , INTENT(OUT  )  :: XDEPTH  (3)
       XZ2       , & !REAL(KIND=r8)   , INTENT(OUT  )  :: XRSTPAR (2,3)
       XZ1       , & !REAL(KIND=r8)   , INTENT(OUT  )  :: XTRAN   (2,3,2)
       XRDC      , & !REAL(KIND=r8)   , INTENT(OUT  )  :: XREF    (2,3,2)
       XRBC      , & !REAL(KIND=r8)   , INTENT(OUT  )  :: XZ0
       XROOTD    , & !REAL(KIND=r8)   , INTENT(OUT  )  :: XDD
       XSOREF    , & !REAL(KIND=r8)   , INTENT(OUT  )  :: XZ2
       XBEE      , & !REAL(KIND=r8)   , INTENT(OUT  )  :: XZ1
       XPHSAT    , & !REAL(KIND=r8)   , INTENT(OUT  )  :: XRDC
       XPOROS    , & !REAL(KIND=r8)   , INTENT(OUT  )  :: XRBC
       XSATCO    , & !REAL(KIND=r8)   , INTENT(OUT  )  :: XBEE
       XSLOPE    , & !REAL(KIND=r8)   , INTENT(OUT  )  :: XPHSAT
       XDEPTH    , & !REAL(KIND=r8)   , INTENT(OUT  )  :: XPOROS
       MONTH     , & !REAL(KIND=r8)   , INTENT(OUT  )  :: XSATCO
       ITYPE       ) !REAL(KIND=r8)   , INTENT(OUT  )  :: XSLOPE 
    !                                                     12 AUGUSTY 2000 
    !=======================================================================
    !                                                                       
    !     ASSIGN VEGETATION PHYSIOLOGY                                        
    !                                                                       
    !    SURFACE PARAMETERS ARE READ IN SAME ORDER AS IN GCM                
    !    SUBROUTINE SIBINP. ONLY EXCEPTION IS THAT 1-D VERSION READS IN     
    !    SITE SPECIFIC PARAMETERS CORB1 ... ZMET .                          
    !                                                                       
    !     VARIABLES THAT ENTER THROUGH COMSIB:                              
    !        SUBSCRIPTS (IV, IW, IL) :                                      
    !              IV = VEGETATION STORY; 1 = TOP AND 2 = BOTTOM            
    !              IW = RADIATION WAVELENGTH; 1 = VISIBLE, 2 = NEAR         
    !                   INFRARED AND 3 = THERMAL INFRARED                   
    !              IL = VEGETATION STATE; 1 = LIVE (GREEN) AND              
    !                   2 = DEAD (STEMS AND TRUNK)                          
    !                                                                       
    !   TRAN(IV,IW,IL): LEAF TRANSMITTANCE                                  
    !   REF (IV,IW,IL): LEAF REFLECTANCE                                    
    !   RSTPAR(IV,IW) : PAR-DEPENDENT LEAF STOMATAL RESISTANCE COEFFICIENTS 
    !                          A =(J/M**3) B = 2(W/M**2) C = 3(S/M)         
    !   SOREF(IW)     : SOIL REFLECTANCE                                    
    !   CHIL(IV)      : LEAF ANGLE DISTRIBUTION FACTOR                      
    !   TOPT(IV)      : OPTIMUM TEMPERATURE FOR STOMATAL FUNCTIONING        
    !   TL(IV)        : LOWER TEMPERATURE LIMIT FOR STOMATAL FUNCTIONING    
    !   TU(IV)        : UPPER TEMPERATURE LIMIT FOR STOMATAL FUNCTIONING    
    !   DEFAC(IV)     : VAPOR PRESSURE DEFICIT PARAMETER                    
    !   PH1(IV)       :                                                     
    !   PH2(IV)       :                                                     
    !   ROOTD(IV)     : ROOTING DEPTH                                       
    !   BEE           : SOIL WETNESS EXPONENT                               
    !   PHSAT         : SOIL TENSION AT SATURATION                          
    !   SATCO         : HYDRAULIC CONDUCTIVITY AT SATURATION                
    !   POROS         : SOIL POROSITY                                       
    !   ZDEPTH        : DEPTH OF 3 SOIL MOISTURE LAYERS                     
    !   Z0            : ROUGHNESS LENGTH                                    
    !   XDD           : ZERO PLANE DISPLACEMENT                             
    !   ZLT(IV)       : LEAF AREA INDEX                                     
    !   GREEN(IV)     : GREEN LEAF FRACTION                                 
    !   VCOVER(IV)    : VEGETATION COVER FRACTION                           
    !                                                                       
    !     VARIABLES ( SPECIFIC TO SIB 1-D VERSION ONLY ) FROM COMSIB        
    !                                                                       
    !      ZWIND  : REFERENCE HEIGHT FOR WIND MEASUREMENT                   
    !      ZMET   : REFERENCE HEIGHT FOR TEMPERATURE, HUMIDITY MEASUREMENT  
    !        THE ABOVE ARE GENERATED FROM SIBX + MOMOPT OUTPUT              
    !                                                                       
    !----------------------------------------------------------------------
    !----------------------------------------------------------------------
    ! USE module_ssib_veg
    !----------------------------------------------------------------------
    !
    INTEGER, INTENT(IN   )  :: ITYPE
    INTEGER, INTENT(IN   )  :: MONTH
    REAL(KIND=r8)   , INTENT(OUT  )  :: XGREEN  (2)
    REAL(KIND=r8)   , INTENT(OUT  )  :: XVCOVER (2)
    REAL(KIND=r8)   , INTENT(OUT  )  :: XZLT    (2)
    REAL(KIND=r8)   , INTENT(OUT  )  :: XCHIL   (2)
    REAL(KIND=r8)   , INTENT(OUT  )  :: XTOPT   (2)
    REAL(KIND=r8)   , INTENT(OUT  )  :: XTL     (2)
    REAL(KIND=r8)   , INTENT(OUT  )  :: XTU     (2)
    REAL(KIND=r8)   , INTENT(OUT  )  :: XDEFAC  (2)
    REAL(KIND=r8)   , INTENT(OUT  )  :: XPH1    (2)
    REAL(KIND=r8)   , INTENT(OUT  )  :: XPH2    (2)
    REAL(KIND=r8)   , INTENT(OUT  )  :: XROOTD  (2)
    REAL(KIND=r8)   , INTENT(OUT  )  :: XSOREF  (3)
    REAL(KIND=r8)   , INTENT(OUT  )  :: XDEPTH  (3)
    REAL(KIND=r8)   , INTENT(OUT  )  :: XRSTPAR (2,3)
    REAL(KIND=r8)   , INTENT(OUT  )  :: XTRAN   (2,3,2)
    REAL(KIND=r8)   , INTENT(OUT  )  :: XREF    (2,3,2)
    REAL(KIND=r8)   , INTENT(OUT  )  :: XZ0
    REAL(KIND=r8)   , INTENT(OUT  )  :: XDD
    REAL(KIND=r8)   , INTENT(OUT  )  :: XZ2
    REAL(KIND=r8)   , INTENT(OUT  )  :: XZ1
    REAL(KIND=r8)   , INTENT(OUT  )  :: XRDC
    REAL(KIND=r8)   , INTENT(OUT  )  :: XRBC
    REAL(KIND=r8)   , INTENT(OUT  )  :: XBEE
    REAL(KIND=r8)   , INTENT(OUT  )  :: XPHSAT
    REAL(KIND=r8)   , INTENT(OUT  )  :: XPOROS
    REAL(KIND=r8)   , INTENT(OUT  )  :: XSATCO
    REAL(KIND=r8)   , INTENT(OUT  )  :: XSLOPE 
    INTEGER   :: IW
    INTEGER   :: IV
    INTEGER   :: IDEP
    XGREEN=0.0_r8;XVCOVER=0.0_r8;XZLT  =0.0_r8;XCHIL =0.0_r8;XTOPT =0.0_r8
    XTL   =0.0_r8;XTU   =0.0_r8;XDEFAC=0.0_r8;XPH1  =0.0_r8;XPH2  =0.0_r8
    XROOTD=0.0_r8;XSOREF=0.0_r8;XDEPTH=0.0_r8;XRSTPAR=0.0_r8;XTRAN =0.0_r8
    XREF  =0.0_r8;XZ0=0.0_r8;XDD=0.0_r8;XZ2=0.0_r8;XZ1=0.0_r8;XRDC=0.0_r8
    XRBC=0.0_r8;XBEE=0.0_r8;XPHSAT=0.0_r8;XPOROS=0.0_r8;XSATCO=0.0_r8
    XSLOPE=0.0_r8;IW=0;IV=0;IDEP=0
    !-----------------------------------------------------------------------
    !                                                                       
    DO IW=1,3
       XTRAN(1,IW,1)=TRAN0(ITYPE,1,IW,1)
       XTRAN(1,IW,2)=TRAN0(ITYPE,1,IW,2)
       XTRAN(2,IW,1)=TRAN0(ITYPE,2,IW,1)
       XTRAN(2,IW,2)=TRAN0(ITYPE,2,IW,2)
       XREF (1,IW,1)= REF0(ITYPE,1,IW,1)
       XREF (1,IW,2)= REF0(ITYPE,1,IW,2)
       XREF (2,IW,1)= REF0(ITYPE,2,IW,1)
       XREF (2,IW,2)= REF0(ITYPE,2,IW,2)
       XRSTPAR(1,IW)=RSTPAR0(ITYPE,1,IW)
       XRSTPAR(2,IW)=RSTPAR0(ITYPE,2,IW)
       XSOREF  (IW) =SOREF0(ITYPE,IW)
    END DO

    DO IV=1,2
       XCHIL(IV)=CHIL0(ITYPE,IV) 
       XTOPT(IV)=TOPT0(ITYPE,IV)
       XTL(IV)=TL0(ITYPE,IV)
       XTU(IV)=TU0(ITYPE,IV)
       XDEFAC(IV)=DEFAC0(ITYPE,IV)
       XPH1(IV)=PH10(ITYPE,IV)
       XPH2(IV)=PH20(ITYPE,IV)
       XROOTD(IV)=ROOTD0(ITYPE,IV)
       XZLT(IV)=ZLT0(ITYPE,MONTH,IV)
       XGREEN(IV)=GREEN0(ITYPE,MONTH,IV)
       XVCOVER(IV)=VCOVER0(ITYPE,MONTH,IV)
    END DO
    DO IDEP=1,3
       XDEPTH(IDEP)=DEPTH0(ITYPE,IDEP)
    END DO
    !                   
    XBEE=BEE0(ITYPE)
    XPHSAT=PHSAT0(ITYPE)
    XSATCO=SATCO0(ITYPE)
    XPOROS=POROS0(ITYPE)
    XSLOPE=SLOPE0(ITYPE)
    XZ2=Z20(ITYPE,MONTH)
    XZ1=Z10(ITYPE,MONTH)
    XZ0= Z000(ITYPE,MONTH)
    XDD= D0(ITYPE,MONTH)
    XRBC=RBC0 (ITYPE,MONTH)
    XRDC=RDC0 (ITYPE,MONTH)
    !
    !------------------------------------------------------
  END SUBROUTINE VEGOUT
  !------------------------------------------------------

END MODULE Sfc_SeaIceFlux_WRF_Model
!PROGRAM MAIN
!  USE Sfc_SeaIceFlux_WRF_Model
!END PROGRAM MAIN
