PROGRAM Main
 IMPLICIT NONE
 REAL    :: jull
 INTEGER :: nlev
 INTEGER :: nrec_1d,nlev_1d,ntime
 REAL    :: psmb
 REAL    :: jull_1d,psmb_1d,aux_1d
 REAL, ALLOCATABLE :: zm    (:) 
 REAL, ALLOCATABLE :: pmb   (:)
 REAL, ALLOCATABLE :: tls_h (:)
 REAL, ALLOCATABLE :: qls_h (:)
 REAL, ALLOCATABLE :: uum_h (:)
 REAL, ALLOCATABLE :: vvm_h (:)
 REAL, ALLOCATABLE :: wwm_h (:)
 REAL, ALLOCATABLE :: tls_v (:)
 REAL, ALLOCATABLE :: qls_v (:)

 REAL, ALLOCATABLE :: pres_1d (:) !pressao mb
 REAL, ALLOCATABLE :: omeg_1d (:) !vertical velocity forcing
 REAL, ALLOCATABLE :: auvel_1d(:) ! u tendency
 REAL, ALLOCATABLE :: avvel_1d(:) ! v tendency
 REAL, ALLOCATABLE :: atemp_1d(:) !temp. absoluta tendendy C/s
 REAL, ALLOCATABLE :: aumid_1d(:) !umidade especifica. kg/kg

 REAL, ALLOCATABLE :: tendvT_1d(:) !temp. absoluta tendendy C/s
 REAL, ALLOCATABLE :: tendvQ_1d(:) !umidade especifica. kg/kg

 INTEGER :: k,jj,kk
 OPEN(unit=1,FILE='output_lsf_20140215_20140315_IOP1_KUBOTA.txt',&
      FORM='FORMATTED',ACCESS='SEQUENTIAL',STATUS='OLD',ACTION='READ')
 OPEN(unit=2,FILE='FORCINGS_ASCII_ORIG',&
      FORM='FORMATTED',ACCESS='SEQUENTIAL',STATUS='OLD',ACTION='READ')
 OPEN(unit=3,FILE='FORCINGS_ASCII_INPUT',&
      FORM='FORMATTED',ACCESS='SEQUENTIAL',STATUS='UNKNOWN',ACTION='WRITE')

 READ(1,'(1x)')
 READ(1,*)jull,nlev,psmb
 READ(2,*)nrec_1d,nlev_1d,jull_1d,psmb_1d,aux_1d

 ALLOCATE(zm    (nlev))
 ALLOCATE(pmb   (nlev))
 ALLOCATE(tls_h (nlev))
 ALLOCATE(qls_h (nlev))
 ALLOCATE(uum_h (nlev))
 ALLOCATE(vvm_h (nlev))
 ALLOCATE(wwm_h (nlev))
 ALLOCATE(tls_v (nlev))
 ALLOCATE(qls_v (nlev))

 ALLOCATE(pres_1d (nlev_1d))
 ALLOCATE(omeg_1d (nlev_1d))
 ALLOCATE(auvel_1d(nlev_1d))
 ALLOCATE(avvel_1d(nlev_1d))
 ALLOCATE(atemp_1d(nlev_1d))
 ALLOCATE(aumid_1d(nlev_1d))
 ALLOCATE(tendvT_1d(nlev_1d))
 ALLOCATE(tendvQ_1d(nlev_1d))
 REWIND(1)
 READ(1,'(1x)')
 REWIND(2)
 DO ntime=1,319
    READ(2,*)nrec_1d,nlev_1d,jull_1d,psmb_1d,aux_1d
    DO k=1,nlev_1d
       READ(2,*)pres_1d (k),omeg_1d (k),auvel_1d(k),avvel_1d(k),atemp_1d(k),aumid_1d(k)
    END DO
    REWIND(1)
    DO jj=1,319
      IF(jj == 1)READ(1,'(1x)',END=100)
      READ(1,*,END=100)jull,nlev,psmb
      DO k=1,nlev
         READ(1,*,END=100)zm(k),pmb(k),tls_h(k),qls_h(k),uum_h(k),vvm_h(k),wwm_h(k),tls_v(k),qls_v(k)
      END DO
      IF(jull_1d == jull)EXIT
    END DO
    PRINT*,jull_1d ,jull
    DO k=1,5
       omeg_1d (k)=(-9.8*wwm_h(1))*0.001
       auvel_1d(k) =uum_h(1)
       avvel_1d(k) =vvm_h(1)
       atemp_1d(k) =tls_h(1)
       aumid_1d(k) =qls_h(1)
       tendvT_1d(k)=tls_v(1)
       tendvQ_1d(k)=qls_v(1)
    END DO
    kk=0
    DO k=6,nlev_1d-4
       kk=kk+1
       omeg_1d (k)=(-9.8*wwm_h(kk))*0.001
       auvel_1d(k) = uum_h(kk)
       avvel_1d(k) = vvm_h(kk)
       atemp_1d(k) = tls_h(kk)
       aumid_1d(k) = qls_h(kk)
       tendvT_1d(k)= tls_v(kk)
       tendvQ_1d(k)= qls_v(kk)
    END DO
    DO k=nlev_1d-3,nlev_1d
       omeg_1d (k)=(-9.8*wwm_h(nlev))*0.001
       auvel_1d(k) = uum_h(nlev)
       avvel_1d(k) = vvm_h(nlev)
       atemp_1d(k) = tls_h(nlev)
       aumid_1d(k) = qls_h(nlev)
       tendvT_1d(k)= tls_v(nlev)
       tendvQ_1d(k)= qls_v(nlev)
    END DO
   100 CONTINUE

    WRITE(3,*)nrec_1d,nlev_1d,jull_1d,psmb_1d,aux_1d
    DO k=1,nlev_1d
       WRITE(3,*)pres_1d (k),omeg_1d (k),auvel_1d(k),avvel_1d(k),atemp_1d(k),aumid_1d(k),tendvT_1d(k),tendvQ_1d(k)
    END DO
 END DO
CONTAINS
 
END PROGRAM
