;************************************************
; Import Libraries
;************************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
;************************************************
;             MAIN
;************************************************
begin

;************************************************
; Open input file
;************************************************
f = addfile("~/Downloads/arm-iop/0eval-data/xie/scm-forcing/iop_at_mao/GOAMAZON/IOP1/mao180varanaecmwfanatrmmC1.c1.20140201.000000.cdf","r")

;************************************************
; Variables used
;************************************************

; Here we want to compute the FORCINGS_ASCII and SOND_IN for ARM9707 experiment
; - here we compute tendencies as time derivatives
; - but we also have them as divergences of temperature and moisture
; - compare them to see if here is the source of the error in ARM9707 experiment

;   float divT(time, lev, lat, lon) ;
;      divT:long_name = "Horizontal T Advective Tendency" ;
;      divT:units = "K/s" ;
;   float vertdivT(time, lev, lat, lon) ;
;      vertdivT:long_name = "Vertical T Advective Tendency" ;
;      vertdivT:units = "K/s" ;
;   float divq(time, lev, lat, lon) ;
;      divq:long_name = "Horizontal Q Advective Tendency" ;
;      divq:units = "kg/kg/s" ;
;   float vertdivq(time, lev, lat, lon) ;
;      vertdivq:long_name = "Vertical Q Advective Tendency" ;
;      vertdivq:units = "kg/kg/s" ;


BS="    "
fmt="%11.6f"
fmtOmg="%23.19f"
fmtTi="%13.6f"
fmtt="%17.13f"
fmtq="%17.13f"
ifmt="%4.3i"

evt=0.5 ;0.1
evq=0.5 ;1.0
eht=1.0
ehq=1.0

; Leap year determination
;yyyy = f->Year
cmonth = (/0,31,59,90,120,151,181,212,243,273,304,334/) ; 2014 not a leap year

;cmonth = (/0,31,60,91,121,152,182,213,244,274,305,335/) ; 1992 is leap year

idt=dimsizes(f->time_offset)
idz=dimsizes(f->lev)

; variables to store and plot computed tendencies
omg = new((/idt,idz/),"float")
aU  = new((/idt,idz/),"float")
aV  = new((/idt,idz/),"float")
aTC = new((/idt,idz/),"float")
aQV = new((/idt,idz/),"float")


 ;print("p,WOBS (m/s),dUOBS/dt (m/s2) ,dVOBS/dt (m/s2) ,d(TABSOBS-273.15)/dt (C/s), dQV/dt (1/s)")
 ;print("p,omgOBS (Pa/s),dUOBS/dt (m/s2) ,dVOBS/dt (m/s2) ,d(TABSOBS-273.15)/dt (C/s), dQV/dt (1/s)")
 

; Compute tendencies as time derivatives for each level and time (start)
 i=0
 do while ( i .lt. idt-1 )
 
  cum  = cmonth(f->month(0) - 1) 
  Jday =  (/cum/) + f->day(0) + (f->time_offset(i))/86400.0   ; Needs to include (Leap) Years

  Ps =  f->p_srf_aver(i)  ; 'mb'
  print(sprinti(ifmt,i+1)+sprinti(ifmt,idz)+sprintf(fmtTi,Jday)+sprintf(fmtTi,Ps)+sprintf(fmtTi,24.0*f->prec_srf(i)))

  do l = 0, idz-1
    p    = f->lev(l)    ;'Pa' to 'mb' and default recording inverted
    omg(i,l)  = f->omega(i,l)/3600./10.  ;'mb/hour' to 'cb/s'  vertical axis inverted
    ;
    dSec = (f->time_offset(i+1) - f->time_offset(i)) 
    dt   = dSec   ;'s' dt in seconds
    ; Here we save u,v and not tendency
       aU(i,l)   = f->u(i,l) ;  'm/s' zonal wind vertical axis inverted
       aV(i,l)   = f->v(i,l) ;  'm/s' meridional wind tendency vertical axis inverted
       ;
       ;


    ; Compute virtual temperature, use moisture tendency in g/kg so transform kg/kg to g/kg
       aTC(i,l)  = (1./3600.)*(eht*f->T_adv_h(i,l)+evt*f->T_adv_v(i,l)+(ehq*f->q_adv_h(i,l)+evq*f->q_adv_v(i,l))/6.) ;'C/s' Temp tend.
       ;

    ; Compute moisture tendendy
       aQV(i,l)  = (1./3600.)*(ehq*f->q_adv_h(i,l) + evq*f->q_adv_v(i,l))/1000.0 ;  Mixing Ratio tendency 
       ;
   
   ; if ( i .eq. 0 ) then
     print(sprintf(fmt,p)+sprintf(fmtOmg,omg(i,l))+sprintf(fmt,aU(i,l))+sprintf(fmt,aV(i,l))+sprintf(fmtt,-aTC(i,l))+sprintf(fmtq,-aQV(i,l))) 
   ; end if
  end do

 i=i+1
 end do
  
  aTC!0="time"
  aTC!1="lev"
  ;aTC&time = f->tsec
  aTC&lev = f->lev

; Compute tendencies as time derivatives for each level and time (end)

; ;Note that the last tendencies are repeated for the last time step.
; ; print(sprinti(ifmt,i)+sprinti(ifmt,idz)+sprintf(fmtTi,Jday+(f->tsec(i))/86400.0)+sprintf(fmtTi,Ps)+sprintf(fmtTi,f->Prec(i,0,0)))
; i=idt-1
; do l = 0, idz-1
;    p    = f->lev(idz-1-l)/100.    ;'Pa' to 'mb' and default recording inverted
;    ;p    = f->lev(l)/100.    ;'Pa' to 'mb' 
;    ;omg(i,l)  = f->omega(i,l,0,0)/10.  ;'Pa/s' to 'cb/s'  
;    omg(i,l)  = f->omega(i,idz-1-l,0,0)/10.  ;'Pa/s' to 'cb/s'  vertical axis inverted
;;  print(sprintf(fmt,p)+sprintf(fmtOmg,omg)+sprintf(fmt,aU)+sprintf(fmt,aV)+sprintf(fmt,aTC)+sprintf(fmtq,aQV))
; end do


end
