; ***********************************************
; panel_20.ncl
;
; Concepts illustrated:
;   - Drawing four different-sized plots on the same page using viewport resources
;   - Maximizing plots after they've been created
;
; ***********************************************
;
; These files are loaded by default in NCL V6.2.0 and newer
 load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
 load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
;************************************************
begin
;
; Read data for XY plot
;
 f = addfile("~/Downloads/arm-iop/0eval-data/xie/scm-forcing/iop_at_mao/GOAMAZON/IOP1/mao180varanaecmwfanatrmmC1.c1.20140201.000000.cdf","r")

 Prec        = f->prec_srf
 T_adv_h     = f->q_adv_h                                  ; get u data
 T_adv_v     = f->q_adv_v                                   ; get v data

 wks   = gsn_open_wks ("png","panel_q")           ; send graphics to PNG file

 xyres                  = True
 xyres@gsnFrame         = False                 ; don't advance frame
 xyres@gsnDraw          = False                 ; don't draw plots

 xyres@vpXF             = 0.09                  ; position and sizes
 xyres@vpYF             = 0.94                  ; for XY plot
 xyres@vpWidthF         = 0.41
 xyres@vpHeightF        = 0.21 ;40

 xyres@trXMinF          = min(Prec&time)                   ; y axis min
 xyres@trXMaxF          = max(Prec&time)                   ; y axis max

 xyres@tiMainString     = "Experiment:"            ; add title
 xyres@tmYLLabelsOn     = False                 ; turn off left labels

 xy0 = gsn_csm_xy (wks,Prec&time,Prec(:),xyres) ; create plot

 xyres@vpXF             = 0.53                  ; change x position
 xyres@tiMainString     = "GoAmazon"            ; add title
 xyres@tiYAxisString    = ""                    ; don't title this one
 xyres@tmYRLabelsOn     = True                  ; turn on right labels

 xy1 = gsn_csm_xy (wks,Prec&time,Prec(:),xyres) ; create plot

 Min = min(f->T_adv_h(lev|:,time|:))
 Max = max(f->T_adv_h(lev|:,time|:))
 MaxMax = max((/Max,abs(Min)/))
 NMax = 7.0

 cnres                      = True
 cnres@gsnFrame             = False                 ; don't advance frame
 cnres@gsnDraw              = False                 ; don't draw plots

 cnres@vpXF                 = 0.09                  ; position and size
 cnres@vpYF                 = 0.60 ;45                  ; for contour plots
 cnres@vpWidthF             = 0.41
 cnres@vpHeightF            = 0.40  ;22

 cnres@cnFillOn             = True                  ; turn on contour fill
 cnres@cnFillPalette        = "MPL_RdGy"           ; set color map
 cnres@cnFillPalette        = "hotcold_18lev"           ; set color map
 cnres@cnLevelSelectionMode = "ManualLevels"        ; set manual contour levels
 cnres@cnMinLevelValF       =  -MaxMax          ; set min contour level
 cnres@cnMaxLevelValF       =   MaxMax                  ; set max contour level
 cnres@cnLevelSpacingF      =   2*MaxMax/NMax                  ; set contour spacing

; cnres@tmYROn               = False                 ; turn off right ticks

; cnres@gsnCenterString      = "300 mb"              ; plot center string
; cnres@gsnRightString       = "Time = 0"            ; plot right string

  cnres@trYReverse = True                             ; Reverse Y axis

 cn0 = gsn_csm_contour(wks,f->q_adv_h(lev|:,time|:),cnres)

 Min = min(f->q_adv_v(lev|:,time|:))
 Max = max(f->q_adv_v(lev|:,time|:))
 MaxMax = max((/Max,abs(Min)/))

 cnres@cnLevelSelectionMode = "ManualLevels"        ; set manual contour levels
 cnres@cnMinLevelValF       =  -MaxMax          ; set min contour level
 cnres@cnMaxLevelValF       =   MaxMax                  ; set max contour level
 cnres@cnLevelSpacingF      =   2*MaxMax/NMax                  ; set contour spacing

 cnres@vpXF                 = 0.53                  ; change x position

 cnres@tmYROn               = True                  ; turn on right ticks
 cnres@tmYLOn               = False                 ; turn off left ticks
 cnres@tmYLLabelsOn         = False                 ; turn off left labels

; cnres@gsnRightString       = "Time = 1"            ; plot right string

 cn1 = gsn_csm_contour(wks,f->q_adv_v(lev|:,time|:),cnres)

;
; Maximize plots in frame.
;
 psres = True                                                               
 maximize_output(wks,psres)  ; calls draw and frame for you 

;
; If you try to use gsn_panel to panel different sized plots, you
; will get unexpected results. You can turn on gsnPanelDebug to
; see what viewport values are used, and then use these values
; to set the viewport resources for each individual plot.
; pnlres               = True
; pnlres@gsnPanelDebug = True    ; Use to print values for position, width,
                                ; and height.
; gsn_panel(wks,(/xy0,xy1,cn0,cn1/),(/2,2/),pnlres)
end
