MODULE Sfc_Ibis_Interface
!
! InitFieldsIbis__vegin
!              |                
!              |__RD_PARAM
!              |
!              |__readit__ibismap__cellbox
!              |                |
!              |                |__cellbox 
!              |
!              |__climanl__existence
!              |
!              |__initial__coldstart
!              |        |
!              |        |__restart__existence
!              |        |
!              |        |__inisurf
!              |        |
!              |        |__inisnow
!              |        |
!              |        |__inisoil
!              |        |    
!              |        |__iniveg
!              |        | 
!              |        |__inisum
!
! IbisDrv__Ibis__pheno
!       |     |
!       |     |__soilbgc
!       |     |
!       |     |__lsxmainn_______setsoi
!       |     |              |
!       |     |              |__fwetcal
!       |     |              |
!       |     |              |__solset
!       |     |              |
!       |     |              |__solsur
!       |     |              |
!       |     |              |__solalb___twostr__twoset
!       |     |              |        |
!       |     |              |        |__twostr__twoset
!       |     |              |
!       |     |              |__solarf
!       |     |              |
!       |     |              |__irrad
!       |     |              |
!       |     |              |__cascade___mix
!       |     |              |         | 
!       |     |              |         |__mix
!       |     |              |         |
!       |     |              |         |__steph2o__mix
!       |     |              |         |         |
!       |     |              |         |         |__mix
!       |     |              |         |
!       |     |              |         |__steph2o__mix
!       |     |              |         |         |
!       |     |              |         |         |__mix
!       |     |              |         |
!       |     |              |         |__mix
!       |     |              |         |
!       |     |              |         |__mix
!       |     |              |         |
!       |     |              |         |__steph2o__mix
!       |     |              |         |         |
!       |     |              |         |         |__mix  
!       |     |              |         |
!       |     |              |         |
!       |     |              |         |__mix
!       |     |              |         |
!       |     |              |         |__mix
!       |     |              | 
!       |     |              |__fwetcal
!       |     |              |
!       |     |              |__canopy__canini
!       |     |              |       |
!       |     |              |       |__drystress
!       |     |              |       |
!       |     |              |       |__turcof__fstrat
!       |     |              |       |       |
!       |     |              |       |       |__fstrat
!       |     |              |       |
!       |     |              |       |__stomata
!       |     |              |       |
!       |     |              |       |__turvap___impexp
!       |     |              |       |       |
!       |     |              |       |       |__impexp
!       |     |              |       |       |
!       |     |              |       |       |__impexp
!       |     |              |       |       |
!       |     |              |       |       |__impexp
!       |     |              |       |       |
!       |     |              |       |       |__impexp2
!       |     |              |       |       |
!       |     |              |       |       |__linsolve
!       |     |              |       |
!       |     |              |       |__tscreen
!       |     |              |       |
!       |     |              |       |__tscreen
!       |     |              |
!       |     |              |__cascad2__steph2o2
!       |     |              |        |
!       |     |              |        |__steph2o2
!       |     |              |        |
!       |     |              |        |__steph2o2
!       |     |              |
!       |     |              |__noveg
!       |     |              |
!       |     |              |__snow__snowheat___tridia
!       |     |              |     |
!       |     |              |     |__vadapt
!       |     |              |     |
!       |     |              |     |__MixSnow
!       |     |              |
!       |     |              |__soilctl__soilh2o__tridia
!       |     |                       |
!       |     |                       |__soilheat__tridia
!       |     |                       |
!       |     |                       |__wadjust
!       |     |                       |
!       |     |                       |__wadjust
!       |     |
!       |     |
!       |     |__sumnow
!       |     |
!       |     |__sumday
!       |     |
!       |     |__summonth
!       |     |
!       |     |__sumyear
!       |     |
!       |     |__solset
!       |     |
!       |     |__solsur
!       |     |
!       |     |__solalb___twostr__twoset
!       |     |       |
!       |     |       |___twostr__twoset
!       |     |
!       |     |__solarf
!       |
!       |__co2
!       |
!       |__dynaveg2__fire
!       |         |
!       |         |__vegmap
!       |
!       |__climanl2__existence
!
!
! Albedo_IBIS__fwetcal
!           |
!           |__solset
!           |
!           |__solsur
!           |
!           |__solalb___twostr__twoset
!                   |
!                   |___twostr__twoset

 USE Constants, ONLY :     &
       oceald   ,     &
       icealn   ,     &
       icealv   ,     &
       r8,i8,r4,i4

 USE Sfc_Ibis_Fiels , Only : spinmax ,isimco2 ,doalb,  &
        isimveg ,isimfire,nband, nsoilay, nsnolay,nlpoints,&
        pi,stef,vonk,grav,tmelt,hfus,hvap,hsub,ch2o,npft, &
        cice,cair,cvap,rair,rvap,cappa,rhow,co2init,epsilon,&
	ginvap  ,gsuvap  ,gtrans,gtransu,gtransl,grunof,& 
        gdrain  ,gadjust ,a10td,a10ancub,a10ancuc,a10ancls, & 
        a10ancl3,a10ancl4,a10scalparamu,a10daylightu,a10scalparaml,&
        a10daylightl,vmax_pft,tau15,kc15,ko15,cimax,gammaub,alpha3,&
        theta3,beta3,coefmub,coefbub,gsubmin,gammauc,coefmuc,coefbuc ,&
        gsucmin,gammals,coefmls,coefbls,gslsmin,gammal3,coefml3, &
        coefbl3,gsl3min,gammal4,alpha4,theta4,beta4,coefml4,coefbl4, &
        gsl4min, wliqu,wliqumax,wsnou,wsnoumax,tum,tu,tu0,wliqs,wliqsmax,& 
        wsnos,wsnosmax,ts,wliql,wliqlmax,wsnol,wsnolmax,tl,topparu,&
        topparl,fl,fu,lai,sai,rhoveg,tauveg,orieh,oriev,wliqmin, &
        wsnomin,t12,tdripu,tblowu,tdrips,tblows,t34,tdripl,tblowl,&
        ztop,alaiml,zbot,alaimu,froot,q34,q12,su,cleaf,dleaf,ss	,& 
        cstem,dstem,sl,cgrass,ciub,ciuc,exist,csub,gsub,csuc,gsuc,&
        agcub,agcuc,ancub,ancuc,totcondub,totconduc,cils,cil3,&	 
        cil4,csls,gsls,csl3,gsl3,csl4,gsl4,agcls,agcl4,agcl3,ancls,&	 
        ancl4,ancl3,totcondls,totcondl3,totcondl4,chu,chs,chl,frac,& 
        tlsub,z0sno,rhos,consno,hsnotop,hsnomin,fimin,fimax,fi,&     
        tsno,hsno,sand,clay,poros,wsoim,wsoi,wsoi0,wisoi,consoi,zwpmax, wpud,&	
        wipud,wpudmax, qglif ,tsoim ,tsoi,tsoi0,hvasug,hvasui,albsav,albsan,&
        tg,ti,z0soi,swilt,sfield,stressl,stressu,stresstl,stresstu,&
        csoi,rhosoi,hsoi,suction,bex,upsoiu,upsoil,heatg,heati,&
        hydraul,porosflo,ibex,bperm,hflo,o2conc,co2conc,cbiow,&
        sapfrac,cbior ,adrain,adsnow,adaet,adtrunoff,& 
        adsrunoff,addrainage,adrh,adsnod,adsnof,adwsoi,adtsoi, &
        adwisoi,adtlaysoi,adwlaysoi,adwsoic,adtsoic,adco2mic,adco2root, & 
        adco2soi,adco2ratio,adnmintot,decompl,decomps,tnmin,amrain,&     
        amsnow,amaet,amtrunoff,amsrunoff,amdrainage,amtemp,&    
        amqa,amsolar,amirup,amirdown,amsens,amlatent,amlaiu,& 
        amlail,amtsoi,amwsoi,amwisoi,amvwc,amawc,amsnod,amsnof,amnpp,adnpp,& 
        amnpptot,amco2mic,amco2root,amco2soi,amco2ratio,amneetot, &
        amnmintot,amts2,amtransu,amtransl,amsuvap,aminvap,amalbedo,&
        amtsoil,amwsoil,amwisoil,tnpptot,&
	aysolar,ayirup,ayirdown,aysens,aylatent,ayprcp,&    
        ayaet,aytrans,aytrunoff,aysrunoff,aydrainage,aydwtot,aywsoi, &
        aywisoi,aytsoi,ayvwc,ayawc,aystresstu,aystresstl,aygpp,aygpptot,&  
        aynpp,aynpptot,ayco2mic,ayco2root,ayco2soi,ayneetot,ayrootbio, & 
        aynmintot,ayalit,ayblit,aycsoi,aycmic,ayanlit,aybnlit,aynsoi,ayalbedo, &    
        totalit,totrlit,totcsoi,totcmic,totanlit,totrnlit,totnsoi,&   
        totnmic,totlit,totfall,totnlit,firefac,wtot,storedn,yrleach,& 
        ynleach,adfalll,adfallr,adfallw,falll,fallr,fallw,clitlm,clitls,clitrm,clitrs,clitwm,&  
        clitws,csoislop,csoislon,csoipas,clitll,clitrl,clitwl,tw,&
        tc,agddu,tempu,agddl,templ,dropu,dropls,dropl4,dropl3,plai,adplai,&
        deltat,gdd0,gdd0this,tcthis,twthis,tcmin,gdd5,gdd5this,TminL,&	
        TminU,Twarm,GDD,aleaf,awood,cbiol,aroot,specla,td ,vzero,&  
        biomass,totlaiu,totlail,totbiou,totbiol,woodnorm,vegtype0,&
        tauwood0,tauwood,tauleaf,tauroot,xminlai,cdisturb,ayanpp,&
        ayanpptot,garea,asurd,asuri,ndaypm,idateprev,iyear0,&
        ndtimes,nmtimes,nytimes,nppdummy,tco2root,&
        tneetot,tco2mic,iMaskIBIS,nVegClass,&
        ynleach_p ,tnmin_p   ,totnmic_p ,totnlit_p ,totanlit_p, &
        totrnlit_p,totnsoi_p ,storedn_p ,adcbiol,adcbior,adcbiow,beta1,beta2,stressfac,avmuir_factor

 USE Sfc_Ibis_LsxMain  , Only : co2,lsxmain, fwetcal,solset,solsur ,solalb,solarf

 USE Sfc_Ibis_Vegetation, Only : dynaveg1,dynaveg2,climanl2,gdiag,vdiag,DailyDynaVeg,&
                                 pheno ,sumnow,sumday,summonth,sumyear,soilbgc

 USE FieldsPhysics, ONLY: Tsfc0,Qsfc0,Tsfcm,Qsfcm,w0,wm,capac0,capacm,td0,tdm,tcm,tc0,tgm,tg0

 USE Parallelism, ONLY: &
       MsgOne,           &
       myId,             &
       maxNodes

 USE IbisOutput, ONLY : Grd,undef,maxstp,nVars

!USE Diagnostics, ONLY: &
!      updia, &
!      dodia, &
!      nDiag_biomau, &
!      nDiag_biomal, &
!      nDiag_tlaiup, & 
!      nDiag_tlailw, & 
!      nDiag_tstnsp, &
!      nDiag_wsttot, &
!      nDiag_lidecf, &
!      nDiag_somdfa, &
!      nDiag_facuca, &
!      nDiag_fsfclc, &
!      nDiag_frsnow, &
!      nDiag_insnpp, & ! instantaneous npp (mol-CO2 / m-2 / second)
!      nDiag_insnee, & ! instantaneous net ecosystem exchange of co2 per timestep (kg_C m-2/timestep)
!      nDiag_grbdy0, & ! annual total growing degree days for current year > 0C
!      nDiag_grbdy5, & ! annual total growing degree days for current year > 5C  
!      nDiag_avet2m, & ! monthly average 2-m surface-air temperature 
!      nDiag_monnpp, & ! monthly total npp for ecosystem (kg-C/m**2/month)
!      nDiag_monnee, & ! monthly total net ecosystem exchange of CO2 (kg-C/m**2/month)
!      nDiag_yeanpp, & ! annual total npp for ecosystem (kg-c/m**2/yr)
!      nDiag_yeanee, & ! annual total NEE for ecosystem (kg-C/m**2/yr) 
!      nDiag_upclai, & ! upper canopy single-sided leaf area index (area leaf/area veg)
!      nDiag_lwclai, & ! lower canopy single-sided leaf area index (area leaf/area veg)
!      nDiag_pfts01, & ! pft tropical broadleaf evergreen trees
!      nDiag_pfts02, & ! pft tropical broadleaf drought-deciduous trees
!      nDiag_pfts03, & ! pft warm-temperate broadleaf evergreen trees
!      nDiag_pfts04, & ! pft temperate conifer evergreen trees
!      nDiag_pfts05, & ! pft temperate broadleaf cold-deciduous trees
!      nDiag_pfts06, & ! pft boreal conifer evergreen trees
!      nDiag_pfts07, & ! pft boreal broadleaf cold-deciduous trees
!      nDiag_pfts08, & ! pft boreal conifer cold-deciduous trees
!      nDiag_pfts09, & ! pft evergreen shrubs
!      nDiag_pfts10, & ! pft cold-deciduous shrubs
!      nDiag_pfts11, & ! pft warm (c4) grasses
!      nDiag_pfts12, & ! pft cool (c3) grasses
!      nDiag_biol01, & ! cbiol tropical broadleaf evergreen trees
!      nDiag_biol02, & ! cbiol tropical broadleaf drought-deciduous trees
!      nDiag_biol03, & ! cbiol warm-temperate broadleaf evergreen trees
!      nDiag_biol04, & ! cbiol temperate conifer evergreen trees
!      nDiag_biol05, & ! cbiol temperate broadleaf cold-deciduous trees
!      nDiag_biol06, & ! cbiol boreal conifer evergreen trees
!      nDiag_biol07, & ! cbiol boreal broadleaf cold-deciduous trees
!      nDiag_biol08, & ! cbiol boreal conifer cold-deciduous trees
!      nDiag_biol09, & ! cbiol evergreen shrubs
!      nDiag_biol10, & ! cbiol cold-deciduous shrubs
!      nDiag_biol11, & ! cbiol warm (c4) grasses
!      nDiag_biol12, & ! cbiol cool (c3) grasses
!      nDiag_ynpp01, & ! ynpp tropical broadleaf evergreen trees
!      nDiag_ynpp02, & ! ynpp tropical broadleaf drought-deciduous trees
!      nDiag_ynpp03, & ! ynpp warm-temperate broadleaf evergreen trees
!      nDiag_ynpp04, & ! ynpp temperate conifer evergreen trees
!      nDiag_ynpp05, & ! ynpp temperate broadleaf cold-deciduous trees
!      nDiag_ynpp06, & ! ynpp boreal conifer evergreen trees
!      nDiag_ynpp07, & ! ynpp boreal broadleaf cold-deciduous trees
!      nDiag_ynpp08, & ! ynpp boreal conifer cold-deciduous trees
!      nDiag_ynpp09, & ! ynpp evergreen shrubs
!      nDiag_ynpp10, & ! ynpp cold-deciduous shrubs
!      nDiag_ynpp11, & ! ynpp warm (c4) grasses
!      nDiag_ynpp12, & ! ynpp cool (c3) grasses
!      nDiag_cmontp, & !coldest monthly temperature			 (C)
!      nDiag_wmontp, & !warmest monthly temperature			 (C)
!      nDiag_atogpp, & !annual total gpp for ecosystem  			   (kg-c/m**2/yr)
!      nDiag_toigpp, & !instantaneous gpp			   (mol-CO2 / m-2 / second)
!      nDiag_fxcsol, & !instantaneous fine co2 flux from soil			   (mol-CO2 / m-2 / second)
!      nDiag_mcsoil, & !instantaneous microbial co2 flux from soil	 (mol-CO2 / m-2 / second)
!      nDiag_cagcub, & !canopy average gross photosynthesis rate - broadleaf  (mol_co2 m-2 s-1)
!      nDiag_cagcuc, & !canopy average gross photosynthesis rate - conifer    (mol_co2 m-2 s-1)
!      nDiag_cagcls, & !canopy average gross photosynthesis rate - shrubs     (mol_co2 m-2 s-1)
!      nDiag_cagcl4, & !canopy average gross photosynthesis rate - c4 grasses (mol_co2 m-2 s-1)
!      nDiag_cagcl3, & !canopy average gross photosynthesis rate - c3 grasses (mol_co2 m-2 s-1)
!      nDiag_cancub, & !canopy average net photosynthesis rate - broadleaf    (mol_co2 m-2 s-1)
!      nDiag_cancuc, & !canopy average net photosynthesis rate - conifer      (mol_co2 m-2 s-1)
!      nDiag_cancls, & !canopy average net photosynthesis rate - shrubs 	(mol_co2 m-2 s-1)
!      nDiag_cancl4, & !canopy average net photosynthesis rate - c4 grasses   (mol_co2 m-2 s-1)
!      nDiag_cancl3, & !canopy average net photosynthesis rate - c3 grasses   (mol_co2 m-2 s-1)
!      nDiag_cicoub, & !intercellular co2 concentration - broadleaf	(mol_co2/mol_air)
!      nDiag_cicouc, & !intercellular co2 concentration - conifer	(mol_co2/mol_air)
!      nDiag_cscoub, & !leaf boundary layer co2 concentration - broadleaf     (mol_co2/mol_air)
!      nDiag_gscoub, & !upper canopy stomatal conductance - broadleaf		(mol_co2 m-2 s-1)
!      nDiag_cscouc, & !leaf boundary layer co2 concentration - conifer 	(mol_co2/mol_air)
!      nDiag_gscouc, & !upper canopy stomatal conductance - conifer	(mol_co2 m-2 s-1)
!      nDiag_cicols, & !intercellular co2 concentration - shrubs	(mol_co2/mol_air)
!      nDiag_cicol3, & !intercellular co2 concentration - c3 plants	(mol_co2/mol_air)
!      nDiag_cicol4, & !intercellular co2 concentration - c4 plants	(mol_co2/mol_air)
!      nDiag_cscols, & !leaf boundary layer co2 concentration - shrubs  	(mol_co2/mol_air)
!      nDiag_gscols, & !lower canopy stomatal conductance - shrubs	(mol_co2 m-2 s-1)
!      nDiag_cscol3, & !leaf boundary layer co2 concentration - c3 plants     (mol_co2/mol_air)
!      nDiag_gscol3, & !lower canopy stomatal conductance - c3 grasses  	(mol_co2 m-2 s-1)
!      nDiag_cscol4, & !leaf boundary layer co2 concentration - c4 plants     (mol_co2/mol_air)
!      nDiag_gscol4, & !lower canopy stomatal conductance - c4 grasses  	(mol_co2 m-2 s-1)
!      nDiag_tcthis, & !coldest monthly temperature of current year	  (C)
!      nDiag_twthis    !warmest monthly temperature of current year	  (C)
       
 IMPLICIT NONE
 PRIVATE
 
  REAL (KIND=r8), PARAMETER   :: z0ice  =       0.001e0_r8! 
  REAL(KIND=r8)   , PARAMETER   :: rgas   = 287.0_r8!  dry air gas constant (J deg^-1 kg^-1)
  REAL(KIND=r8)   , PARAMETER   :: kapa   = 0.2861328125_r8!  rgas/cp (unitless)
  REAL(KIND=r8)   , PARAMETER   :: cp     = rgas/kapa!  specific of heat of dry air at constant pressure (J deg^-1 kg^-1)
  REAL(KIND=r8)   , PARAMETER   :: hltm   = 2.52e6_r8            !  latent heat of vaporization (J kg^-1)
  REAL(KIND=r8)   , PARAMETER   :: stefan = 5.67e-8_r8           !  Stefan-Boltzmann constant
  real, parameter, public :: MAPL_AIRMW  = 28.97                  ! kg/Kmole
  real, parameter, public :: MAPL_H2OMW  = 18.01                  ! kg/Kmole

  real, parameter, public :: MAPL_VIREPS = MAPL_AIRMW/MAPL_H2OMW-1.0   ! --

  REAL(KIND=r8)   :: rbyg

 PUBLIC :: Ibis_Interface,Albedo_IBIS 

CONTAINS

SUBROUTINE Ibis_Interface(DELTAIN,dt                 ,intg              ,istrt             , &
            jdt                ,jb                   ,dtc3x             ,nCols             , &
            nmax               ,kMax                 ,ktm               ,initlz            , &
	    kt                 ,nsx                  ,iswrad            ,ilwrad            , &
	    tod	               ,idatec               ,filta             ,epsflt            , &
            gt                 ,gq                   ,gu                ,gv                , &
            gps	               ,tmtx                 ,qmtx              ,umtx              , &
            zenith             ,colrad               ,fira2             ,xvisb             , &
            xvisd              ,xnirb                ,xnird             ,ppli              , &
            ppci               ,snow                 ,sigki             ,delsig            , & 
            tseam              ,tsea                 ,mskant            ,speedm            , &
            slrad              ,tsurf                ,qsurf             ,zorl              , &
            taux               ,tauy                 ,sens              ,evap              , & 
	    umom               ,vmom                 ,rmi               ,rhi               , &
	    z0                 ,ustar                ,hc                ,hg                , & 
            ec                 ,eg                   ,ts2               ,qs2               , &
            qsfc               ,tsfc                 ,z0sea             ,d                 , &
            cu                 ,imask                ,Ustarm            ,tgrd              , &
            roff               ,ect                  ,eci               ,egt               , &
            egi                ,egs                  ,rho               ,bstar             , &
            slhf               ,sshf                 ,swdown            ,rootmode)

 IMPLICIT NONE
 REAL(KIND=r8), INTENT(IN   ) :: DELTAIN
 REAL(KIND=r8), INTENT(IN   ) :: dt
 INTEGER       , INTENT(IN   ) :: jdt
 REAL(KIND=r8), INTENT(IN   ) :: tod
 INTEGER       , INTENT(IN   ) :: idatec (4)  
 INTEGER       , INTENT(IN   ) :: nCols
 INTEGER       , INTENT(IN   ) :: kMax
 INTEGER       , INTENT(IN   ) :: jb
 INTEGER       , INTENT(IN   ) :: nmax
 INTEGER       , INTENT(IN   ) :: ktm
 INTEGER       , INTENT(IN   ) :: initlz
 INTEGER       , INTENT(IN   ) :: kt
 INTEGER       , INTENT(IN   ) :: nsx(nCols)	

 REAL(KIND=r8), INTENT(IN   ) :: dtc3x         ! model timestep (seconds)
 REAL(KIND=r8), INTENT(IN   ) :: gt	(nCols)        ! air temperature (K)
 REAL(KIND=r8), INTENT(IN   ) :: gq	(nCols)        ! specific humidity (kg_h2o/kg_air)
 REAL(KIND=r8), INTENT(IN   ) :: gu	(nCols)
 REAL(KIND=r8), INTENT(IN   ) :: gv	(nCols)
 REAL(KIND=r8), INTENT(IN   ) :: gps	(nCols)        ! surface pressure (nPa)
 REAL(KIND=r8), INTENT(IN   ) :: xvisb  (nCols)!solad(i,1).Downward Surface shortwave fluxe visible beam    (cloudy)
 REAL(KIND=r8), INTENT(IN   ) :: xvisd  (nCols)!solai(i,1) !.Downward Surface shortwave fluxe visible diffuse (cloudy)
 REAL(KIND=r8), INTENT(IN   ) :: xnirb  (nCols)!solad(i,2).Downward Surface shortwave fluxe Near-IR beam    (cloudy)
 REAL(KIND=r8), INTENT(IN   ) :: xnird  (nCols)!solai(1,2) !.Downward Surface shortwave fluxe Near-IR diffuse (cloudy)
 REAL(KIND=r8), INTENT(IN   ) :: fira2  (nCols)        ! incoming ir flux (W m-2)
 REAL(KIND=r8), INTENT(IN   ) :: zenith (nCols)        ! cosine of solar zenith angle
 REAL(KIND=r8), INTENT(IN   ) :: colrad (nCols)        
 REAL(KIND=r8), INTENT(IN   ) :: ppli	(nCols)! Precipitation rate ( large scale )	  (mm/s)
 REAL(KIND=r8), INTENT(IN   ) :: ppci	(nCols)! Precipitation rate ( cumulus ) 	  (mm/s)
 REAL(KIND=r8), INTENT(IN   ) :: snow	(nCols)! snowfall rate (mm/s or kg m-2 s-1 of water)
 REAL(KIND=r8), INTENT(IN   ) :: sigki  
 REAL(KIND=r8), INTENT(IN   ) :: delsig   

 REAL(KIND=r8), INTENT(INOUT) :: tseam  (nCols)
 REAL(KIND=r8), INTENT(INOUT) :: tsea   (nCols)

 INTEGER(KIND=i8), INTENT(IN   ) :: mskant(ncols)

 REAL(KIND=r8), INTENT(INOUT) :: speedm (nCols) ! wind speed (m s-1)
 REAL(KIND=r8), INTENT(INOUT) :: tmtx	(nCols,3)
 REAL(KIND=r8), INTENT(INOUT) :: qmtx	(nCols,3)
 REAL(KIND=r8), INTENT(INOUT) :: umtx	(nCols,4)
 REAL(KIND=r8), INTENT(IN   ) :: slrad  (nCols)
 REAL(KIND=r8), INTENT(INOUT) :: tsurf  (nCols) 
 REAL(KIND=r8), INTENT(IN   ) :: qsurf  (nCols) 
 REAL(KIND=r8), INTENT(INOUT) :: zorl	(nCols) 
 REAL(KIND=r8), INTENT(OUT  ) :: taux	(nCols)
 REAL(KIND=r8), INTENT(OUT  ) :: tauy	(nCols)
 REAL(KIND=r8), INTENT(INOUT) :: ts2	(nCols)
 REAL(KIND=r8), INTENT(INOUT) :: qs2	(nCols)
 REAL(KIND=r8), INTENT(IN   ) :: slhf   (nCols)
 REAL(KIND=r8), INTENT(IN   ) :: sshf   (nCols)
 REAL(KIND=r8), INTENT(IN   ) ::  swdown (nCols)
 REAL(KIND=r8), INTENT(IN   ) :: filta
 REAL(KIND=r8), INTENT(IN   ) :: epsflt
 INTEGER          , INTENT(IN   ) :: intg
 INTEGER          , INTENT(IN   ) :: istrt
 CHARACTER(len=*) , INTENT(IN   ) :: iswrad
 CHARACTER(len=*) , INTENT(IN   ) :: ilwrad
 REAL(KIND=r8)   , INTENT(INOUT) :: sens(1:nCols)
 REAL(KIND=r8)   , INTENT(INOUT) :: evap(1:nCols) 
 REAL(KIND=r8)   , INTENT(INOUT) :: umom  (1:nCols)
 REAL(KIND=r8)   , INTENT(INOUT) :: vmom  (1:nCols)
 REAL(KIND=r8)   , INTENT(INOUT) :: rmi   (1:nCols) 
 REAL(KIND=r8)   , INTENT(INOUT) :: rhi   (1:nCols)
 REAL(KIND=r8)   , INTENT(INOUT) :: tsfc  (1:nCols) 
 REAL(KIND=r8)   , INTENT(INOUT) :: qsfc  (1:nCols) 
 REAL(KIND=r8)   , INTENT(INOUT) :: z0    (1:nCols) 
 REAL(KIND=r8)   , INTENT(INOUT) :: ustar (1:nCols )
 REAL(KIND=r8)   , INTENT(OUT) :: hc (1:nCols)
 REAL(KIND=r8)   , INTENT(OUT) :: hg (1:nCols)
 REAL(KIND=r8)   , INTENT(OUT) :: ec (1:nCols)
 REAL(KIND=r8)   , INTENT(OUT) :: eg (1:nCols)
 REAL(KIND=r8)   , INTENT(OUT)   :: z0sea (1:nCols)
 REAL(KIND=r8)   , INTENT(OUT)   :: d(1:nCols)
 REAL(KIND=r8)   , INTENT(INOUT)   :: cu(1:nCols)
 INTEGER(KIND=i8) , INTENT(INOUT) :: imask    (nCols)
 REAL(KIND=r8)   , INTENT(INOUT)   :: Ustarm(nCols)
 REAL(KIND=r8)   , INTENT(INOUT)   :: tgrd(nCols)
 REAL(KIND=r8)   , INTENT(INOUT)   :: roff(nCols)
 REAL(KIND=r8)   , INTENT(INOUT)   :: ect(nCols)
 REAL(KIND=r8)   , INTENT(INOUT)   :: eci(nCols)
 REAL(KIND=r8)   , INTENT(INOUT)   :: egt(nCols)
 REAL(KIND=r8)   , INTENT(INOUT)   :: egi(nCols)
 REAL(KIND=r8)   , INTENT(INOUT)   :: egs(nCols)
 REAL(KIND=r8)   , INTENT(INOUT)   :: rho(nCols)
 REAL(KIND=r8)   , INTENT(OUT)     :: bstar(nCols)
 CHARACTER(len=*) , INTENT(IN   ) ::  rootmode
    !  idatec(1)....hour(00/12)
    !  idatec(2)....month
    !  idatec(3)....day of month
    !  idatec(4)....year
!   INCLUDE 'comatm.h'
 REAL(KIND=r8)   :: cond  (1:nCols)
 REAL(KIND=r8)   :: stor  (1:nCols)
 REAL(KIND=r8)   :: rnet  (1:nCols)
 REAL(KIND=r8)	 :: ta     (nCols)	! air temperature (K)
 REAL(KIND=r8)	 :: qa     (nCols)	! specific humidity (kg_h2o/kg_air)
 REAL(KIND=r8)	 :: ux     (nCols)
 REAL(KIND=r8)	 :: uy     (nCols)
 REAL(KIND=r8)	 :: psurf  (nCols)	! surface pressure (Pa)
 REAL(KIND=r8)	 :: solad  (nCols,nband) ! direct downward solar flux (W m-2)
 REAL(KIND=r8)	 :: solai  (nCols,nband) ! diffuse downward solar flux (W m-2)
 REAL(KIND=r8)	 :: fira   (nCols)	! incoming ir flux (W m-2)
 REAL(KIND=r8)	 :: coszen (nCols)	! cosine of solar zenith angle
 REAL(KIND=r8)	 :: raina  (nCols)	! rainfall rate (mm/s or kg m-2 s-1)
 REAL(KIND=r8)	 :: snowa  (nCols)	! snowfall rate (mm/s or kg m-2 s-1 of water)
 REAL(KIND=r8)	 :: ua     (nCols)	! wind speed (m s-1)
 REAL(KIND=r8)	 :: tmin   (nCols)	! minimun soil temperature (K)
 REAL(KIND=r8)	 :: tmax   (nCols)	! maximun soil temperature (K)
 INTEGER, PARAMETER :: ndaypy=365  ! number of days per year(365or366)
 REAL(KIND=r8)	 :: tgpptot(nCols) 
 REAL(KIND=r8)	 :: disturbf(nCols)    ! local annual fire disturbance regime (m2/m2/yr)
 REAL(KIND=r8)	 :: disturbo(nCols)    ! local fraction of biomass pool lost every year to disturbances other than fire
 REAL(KIND=r8)   :: fvapa    (nCols)	 ! local ! downward h2o vapor flux between za & z12 at za (kg m-2 s-1)
 REAL(KIND=r8)   :: fsena    (nCols)	 ! local ! downward sensible heat flux between za & z12 at za (W m-2)
 REAL(KIND=r8)   :: xsea       (1:nCols) 
 REAL(KIND=r8)   :: bstar1       (1:nCols)
 REAL(KIND=r8)   :: diag       (1:nCols)
 REAL(KIND=r8)   :: firb     (nCols)	  ! local ! net upward ir radiation at reference
          			                  ! atmospheric level za (W m-2)

    REAL(kind=r8)   :: za(nCols)
    REAL(kind=r8)   :: bps(nCols)
    ! atmospheric level za (W m-2)

 !
! Arguments (input)
!
 LOGICAL :: InitMod
 REAL(KIND=r8)    :: calday ,siga    ! current julian day (1-365.99)
!  INTEGER :: iday     ! current day in month (1-31 or 1-30, or 1-28)
 INTEGER :: iday	 ! day number  (passed in)
 INTEGER :: idayprev   ! day in month of previous timestep
   
!   integer:: imonth	 ! current month (1 - 12)
 INTEGER :: imonth	 ! month number (passed in)   
 INTEGER :: imonthprev ! month of previous timestep 
  
 INTEGER :: iyear
 INTEGER :: iyearprev  ! year of previous timestep 

 INTEGER :: idayout=0	 ! write out daily output
 INTEGER :: imonthout=0! write out daily output
 INTEGER :: iyearout=0 
 INTEGER :: nLndPts=0
 INTEGER :: i,k,ind,nint,IntSib,itr
 REAL (KIND=r8), PARAMETER   :: tice   =      271.16e0_r8! constant tice

    !  idatec(1)....hour(00/12)
    !  idatec(2)....month
    !  idatec(3)....day of month
    !  idatec(4)....year
 iday      = idatec   (3) ! current day in month (1-31 or 1-30, or 1-28)
 imonth    = idatec   (2) ! current month (1 - 12)  
 iyear     = idatec   (4) ! current year 
    
 imonthprev= idateprev(2) ! month of previous timestep 
 idayprev  = idateprev(3) ! day in month of previous timestep
 iyearprev = idateprev(4) ! year of previous timestep 
 
 calday = julday (imonth,iday,iyear,tod)
 rbyg  = 40 !rgas/grav*delsig*0.5_r8
 !CALL MsgOne(h," IBIS: IBIS Tendencies")
 !IF(myId ==0)WRITE(*,*)imonthprev
   nLndPts=0
   DO i=1,nCols
      IF (iMask(i) >= 1) THEN
         nLndPts=nLndPts+1           
         siga = 0.999_r8
!
!        tfac = 1.0_r8 / ((siga)**cappa)!rair/cair
!return
         bps    (nLndPts)   =  1.0_r8 / ((gps(i)/1000.0_r8)**cappa)!rair/cair	(prsi(i,1)/(prsi(i,2)))**(gasr/cp)
         za     (nLndPts  ) = 40.0_r8  !MAX((phii(i,2) - phii(i,1))*0.5_r8,0.5_r8)  
! make sure that atmospheric level is higher than canopy top
!
         za     (nLndPts) = max (za(nLndPts), ztop (nLndPts,2,jb) + 1.0_r8)
 

         ta     (nLndPts  ) = gt(i)
         qa     (nLndPts  ) = max(gq(i),0.00000012_r8) 
         ux     (nLndPts  ) = gu(i) /SIN(colrad(i))
         uy     (nLndPts  ) = gv(i) /SIN(colrad(i))
         psurf  (nLndPts  ) = gps    (i)*100.00_r8	  ! surface pressure hPa -> Pa
         solad  (nLndPts,1) = xvisb  (i)  !! number of solar radiation wavebands : vis, nir
         solai  (nLndPts,1) = xvisd  (i)
         solad  (nLndPts,2) = xnirb  (i)
         solai  (nLndPts,2) = xnird  (i)
         fira   (nLndPts  ) = fira2  (i)      
         coszen (nLndPts  ) = zenith (i)
         raina  (nLndPts  ) = (ppli(i) + ppci(i) )*1.0e-3_r8 *MAX(ABS(dt/dt),1.0_r8) !convert mm/s to m/s
         snowa  (nLndPts  ) = snow   (i) 
         ux     (nLndPts  ) = gu(i) /SIN(colrad(i))
         IF( ux(nLndPts  ) <= 0_r8 .and. ux(nLndPts) > -0.0001_r8)ux(nLndPts  )=-0.0001_r8
         IF( ux(nLndPts  ) >= 0_r8 .and. ux(nLndPts) <  0.0001_r8)ux(nLndPts  )= 0.0001_r8
         uy     (nLndPts  ) = gv(i) /SIN(colrad(i))
         IF( uy(nLndPts  ) <= 0_r8 .and. uy(nLndPts) > -0.0001_r8)uy(nLndPts  )=-0.0001_r8
         IF( uy(nLndPts  ) >= 0_r8 .and. uy(nLndPts) <  0.0001_r8)uy(nLndPts  )= 0.0001_r8
         speedm (nLndPts  ) = SQRT(( ux(nLndPts))**2  + ( uy(nLndPts))**2)
         speedm (nLndPts)=MAX(0.0001_r8 ,speedm(nLndPts))
         ua     (nLndPts  ) = speedm (nLndPts)
	 q34    (nLndPts,jb) =  max(q34(nLndPts,jb),0.00000012_r8) 
	 q12    (nLndPts,jb) =  max(q34(nLndPts,jb),0.00000012_r8) 
      END IF 
   END DO 
   InitMod = (initlz >= 0 .AND. ktm == -1 .AND. kt == 0 )
   IF(InitMod)THEN
      nLndPts=0
      DO i=1,nCols
         IF( iMask(i) >= 1)THEN 
            nLndPts=nLndPts+1
    	    tu0(nLndPts,jb) = ta     (nLndPts  )
	    tu (nLndPts,jb) = ta     (nLndPts  )
	    tum(nLndPts,jb) = ta     (nLndPts  )

	    ts (nLndPts,jb) = ta     (nLndPts  )
	    
	    tl (nLndPts,jb) = ta     (nLndPts  )
	    
	    t12(nLndPts,jb) = ta     (nLndPts  )
	    
	    t34(nLndPts,jb) = ta     (nLndPts  )       
	    
	    tgm(nLndPts,jb) = tg     (nLndPts,jb) 
	    
	    q12(nLndPts,jb) = qa     (nLndPts  )       
	    q34(nLndPts,jb) = qa     (nLndPts  )       
            DO k=1,nsoilay 
	         tsoi0(nLndPts,k,jb) =ta     (nLndPts  )! tsoi (nLndPts,k,jb)
	    	 tsoim(nLndPts,k,jb) =ta     (nLndPts  )! tsoi (nLndPts,k,jb)
	    	 tsoi (nLndPts,k,jb) =ta     (nLndPts  )! tsoi (nLndPts,k,jb)
            END DO
            DO k=1,nsoilay
	        wsoi0(nLndPts,k,jb)  = wsoi (nLndPts,k,jb)
          	wsoim(nLndPts,k,jb)  = wsoi (nLndPts,k,jb)
	    	wsoi (nLndPts,k,jb)  = wsoi (nLndPts,k,jb)
            END DO
         END IF
      END DO
   END IF
    nLndPts=0
    DO i=1,nCols
       IF( iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
!          wliqmin  =0.00_r8         !local !
!          wsnomin  =0.00_r8         !local !
!          grunof   (nLndPts,jb)=0.00_r8 !local !
!          ginvap   (nLndPts,jb)=0.00_r8 !local !
!          gsuvap   (nLndPts,jb)=0.00_r8 !local !
!          gtrans   (nLndPts,jb)=0.00_r8 !local !
!          gtransu  (nLndPts,jb)=0.00_r8 !local !
!          gtransl  (nLndPts,jb)=0.00_r8 !local !
!          gdrain   (nLndPts,jb)=0.00_r8 !local !
!          gadjust  (nLndPts,jb)=0.00_r8 !local !
!          topparu  (nLndPts,jb)=0.00_r8 !local !
!          topparl  (nLndPts,jb)=0.00_r8 !local !
!          su       (nLndPts,jb)=0.00_r8 !local !
!          ss       (nLndPts,jb)=0.00_r8 !local !
!          sl       (nLndPts,jb)=0.00_r8 !local !
!          agcub    (nLndPts,jb)=0.00_r8!local !
!          agcuc    (nLndPts,jb)=0.00_r8!local !
!          ancub    (nLndPts,jb)=0.00_r8!local !
!          ancuc    (nLndPts,jb)=0.00_r8!local !
!          totcondub(nLndPts,jb)=0.00_r8!local !
!          totconduc(nLndPts,jb)=0.00_r8!local !
!          agcls    (nLndPts,jb)=0.00_r8!local !
!          agcl4    (nLndPts,jb)=0.00_r8!local !
!          agcl3    (nLndPts,jb)=0.00_r8!local !
!          ancls    (nLndPts,jb)=0.00_r8!local !
!          ancl4    (nLndPts,jb)=0.00_r8!local !
!          ancl3    (nLndPts,jb)=0.00_r8!local !
!          totcondls(nLndPts,jb)=0.00_r8!local !
!          totcondl3(nLndPts,jb)=0.00_r8!local !
!         totcondl4(nLndPts,jb)=0.00_r8!local !
!          consoi   (nLndPts,1:nsoilay,jb)=0.00_r8!local ! 
!          qglif    (nLndPts,1:4,jb)=0.00_r8!local ! 
!          hvasug   (nLndPts,jb)=0.00_r8!local ! 
!          hvasui   (nLndPts,jb)=0.00_r8!local ! 
!          stressl  (nLndPts,1:nsoilay,jb)=0.00_r8!local ! 
!          stressu  (nLndPts,1:nsoilay,jb)=0.00_r8!local ! 
!          stresstl (nLndPts,jb)=0.00_r8!local !  
!          stresstu (nLndPts,jb)=0.00_r8!local ! 	
!          upsoiu   (nLndPts,1:nsoilay,jb)=0.00_r8!local ! 	
!          upsoil   (nLndPts,1:nsoilay,jb)=0.00_r8!local ! 	
!          heatg    (nLndPts,jb)=0.00_r8!local ! 		 
!          heati    (nLndPts,jb)=0.00_r8!local ! 		 
!          asurd    (nLndPts,1:nband,jb)=0.00_r8!local ! 		
!          asuri    (nLndPts,1:nband,jb)=0.00_r8!local ! 		
!          tmm     (ncount)  = tmgm  (ncount,latco)
!          tm0     (ncount)  = tmgp  (ncount,latco)
!          wpud(nLndPts,jb) = wpudmax
          DO k=1,nsoilay 
	       tsoi0(nLndPts,k,jb) = tsoi0 (nLndPts,k,jb)
	       tsoim(nLndPts,k,jb) = tsoim (nLndPts,k,jb)
	       tsoi (nLndPts,k,jb) = tsoi  (nLndPts,k,jb)
          END DO
          DO k=1,nsoilay
	      wsoi0(nLndPts,k,jb)  = wsoi0 (nLndPts,k,jb)
              wsoim(nLndPts,k,jb)  = wsoim (nLndPts,k,jb)
	      wsoi (nLndPts,k,jb)  = wsoi  (nLndPts,k,jb)
          END DO
       END IF
    END DO

    IF(InitMod)THEN
       nint=2
       IntSib=5
    ELSE
       nint=1
       IntSib=1
    END IF
    IF(TRIM(iswrad).NE.'NON'.AND.TRIM(ilwrad).NE.'NON') THEN
       IF(InitMod .and. nLndPts >= 1)THEN
         DO ind=1,nint
            nLndPts=0
            DO i=1,nCols
                IF (iMask(i) >= 1) THEN
                   nLndPts=nLndPts+1
                   !
                   !     precipitation
                   !
                   raina  (nLndPts  ) =0.0e0_r8*1.0e-3_r8*MAX(ABS(dt/dt),1.0_r8)  !convert mm/s to m/s
                END IF
             END DO
             DO itr=1,IntSib
                CALL IbisDrv (tod,pi,stef,vonk,grav,tmelt,hfus,hvap,hsub,ch2o,cice,cair,cvap,rair,rvap,cappa, &
	 rhow,nLndPts,nband,nsoilay,nsnolay,npft,epsilon,dtc3x,doalb,&
	 ginvap       (1:nLndPts,jb),gsuvap      (1:nLndPts,jb),gtrans	 (1:nLndPts,jb), &
	 gtransu      (1:nLndPts,jb),gtransl	(1:nLndPts,jb),grunof	 (1:nLndPts,jb),gdrain	   (1:nLndPts,jb), &
	 gadjust      (1:nLndPts,jb),a10scalparamu(1:nLndPts,jb),a10daylightu(1:nLndPts,jb),a10scalparaml(1:nLndPts,jb), &
	 a10daylightl (1:nLndPts,jb),vmax_pft	(1:npft)    ,tau15		     ,kc15		       , &
         ko15,cimax,gammaub,alpha3,theta3,beta3,coefmub,coefbub,gsubmin,gammauc,coefmuc,coefbuc, &
	 gsucmin,gammals,coefmls,coefbls,gslsmin,gammal3,coefml3,coefbl3, &
         gsl3min,gammal4,alpha4,theta4,beta4,coefml4,coefbl4,gsl4min,bps(1:nLndPts), &
	 wliqu        (1:nLndPts,jb),wliqumax		    ,wsnou	 (1:nLndPts,jb),wsnoumax  	       , &
	 tu	      (1:nLndPts,jb),wliqs	(1:nLndPts,jb),wliqsmax		     ,wsnos	   (1:nLndPts,jb), &
	 wsnosmax		  ,ts		(1:nLndPts,jb),wliql	 (1:nLndPts,jb),wliqlmax  	       , &  
         wsnol        (1:nLndPts,jb),wsnolmax		    ,tl 	 (1:nLndPts,jb),topparu	   (1:nLndPts,jb), &
	 topparl      (1:nLndPts,jb),fl		(1:nLndPts,jb),fu 	 (1:nLndPts,jb),lai      (1:nLndPts,1:2,jb), &
	 sai	  (1:nLndPts,1:2,jb),rhoveg      (1:nband,1:2),tauveg	(1:nband,1:2),orieh    (1:2)	       , &
	 oriev    (1:2) 	  ,wliqmin		    ,wsnomin		     ,t12	   (1:nLndPts,jb), &
	 tdripu 		  ,tblowu		    ,tdrips		     ,tblows		       , &
         t34	      (1:nLndPts,jb),tdripl		    ,tblowl		     ,ztop     (1:nLndPts,1:2,jb),za     (1:nLndPts), & 
	 alaiml 		  ,zbot     (1:nLndPts,1:2,jb),alaimu		     ,froot	(1:nLndPts,1:nsoilay,1:2,jb), &
	 q34	      (1:nLndPts,jb),q12  	(1:nLndPts,jb),su 	 (1:nLndPts,jb),cleaf		       , &
	 dleaf        (1:2)	  ,ss		(1:nLndPts,jb),cstem		     ,dstem		       , &
	 sl	      (1:nLndPts,jb),cgrass		    ,ciub	 (1:nLndPts,jb),ciuc	   (1:nLndPts,jb), &
         exist (1:nLndPts,1:npft,jb),csub 	(1:nLndPts,jb),gsub	 (1:nLndPts,jb),csuc	   (1:nLndPts,jb), &
	 gsuc	      (1:nLndPts,jb),agcub	(1:nLndPts,jb),agcuc	 (1:nLndPts,jb),ancub	   (1:nLndPts,jb), &
	 ancuc        (1:nLndPts,jb),totcondub	(1:nLndPts,jb),totconduc   (1:nLndPts,jb),cils	   (1:nLndPts,jb), &
	 cil3	      (1:nLndPts,jb),cil4 	(1:nLndPts,jb),csls	 (1:nLndPts,jb),gsls	   (1:nLndPts,jb), &
	 csl3	      (1:nLndPts,jb),gsl3 	(1:nLndPts,jb),csl4	 (1:nLndPts,jb),gsl4	   (1:nLndPts,jb), &
	 agcls        (1:nLndPts,jb),agcl4	(1:nLndPts,jb),agcl3	 (1:nLndPts,jb),ancls	   (1:nLndPts,jb), &
	 ancl4        (1:nLndPts,jb),ancl3	(1:nLndPts,jb),totcondls   (1:nLndPts,jb),totcondl3    (1:nLndPts,jb), &
	 totcondl4    (1:nLndPts,jb),chu(1:nVegClass),chs(1:nVegClass),chl(1:nVegClass),frac  (1:nLndPts,1:npft,jb),tlsub  	(1:nLndPts,jb),z0sno,rhos, &
	 consno 		  ,hsnotop		    ,hsnomin		     ,fimin		       , &
	 fimax  		  ,fi		(1:nLndPts,jb),tsno(1:nLndPts,1:nsnolay,jb),hsno(1:nLndPts,1:nsnolay,jb),&
	 sand(1:nLndPts,1:nsoilay,jb),clay(1:nLndPts,1:nsoilay,jb),poros(1:nLndPts,1:nsoilay,jb),wsoi(1:nLndPts,1:nsoilay,jb), &
	 wisoi(1:nLndPts,1:nsoilay,jb),consoi(1:nLndPts,1:nsoilay,jb),zwpmax	     ,wpud(1:nLndPts,jb)         , &
	 wipud        (1:nLndPts,jb),wpudmax		    ,qglif   (1:nLndPts,1:4,jb),tsoi(1:nLndPts,1:nsoilay,jb), &
	 hvasug       (1:nLndPts,jb),hvasui	(1:nLndPts,jb),albsav	 (1:nLndPts,jb),albsan	   (1:nLndPts,jb), &
	 tg	      (1:nLndPts,jb),ti		(1:nLndPts,jb),z0soi(1:nLndPts,jb)       ,swilt(1:nLndPts,1:nsoilay,jb), &
	 sfield(1:nLndPts,1:nsoilay,jb),stressl(1:nLndPts,1:nsoilay,jb),stressu(1:nLndPts,1:nsoilay,jb),stresstl(1:nLndPts,jb), &
	 stresstu (1:nLndPts,jb)    ,csoi(1:nLndPts,1:nsoilay,jb),rhosoi(1:nLndPts,1:nsoilay,jb),hsoi(1:nLndPts,1:nsoilay+1,jb)   , &
	 suction(1:nLndPts,1:nsoilay,jb),bex (1:nLndPts,1:nsoilay,jb),upsoiu(1:nLndPts,1:nsoilay,jb),upsoil(1:nLndPts,1:nsoilay,jb), &
	 heatg   (1:nLndPts,jb),heati   (1:nLndPts,jb),hydraul(1:nLndPts,1:nsoilay,jb),porosflo(1:nLndPts,1:nsoilay,jb), &
	 ibex(1:nLndPts,1:nsoilay,jb),bperm(1:nLndPts,jb),hflo      (1:nLndPts,1:nsoilay+1,jb),ta       (1:nLndPts)       , &
	 asurd (1:nLndPts,1:nBand,jb),asuri(1:nLndPts,1:nBand,jb),coszen(1:nLndPts)	      ,solad (1:nLndPts,1:nBand)  , &
	 solai (1:nLndPts,1:nBand)  ,fira      (1:nLndPts)      ,raina (1:nLndPts)	     ,qa    (1:nLndPts)	       , &
	 psurf    (1:nLndPts)	  ,snowa     (1:nLndPts)      ,ua    (1:nLndPts)	     ,o2conc		       , &
	 co2conc		  ,td	 (1:nLndPts,jb)	    ,vzero    (1:nLndPts,jb)   ,ndaypy		       , &
	 nppdummy(1:nLndPts,1:npft,jb) ,cbiow (1:nLndPts,1:npft,jb),sapfrac(1:nLndPts,jb)      ,cbior(1:nLndPts,1:npft,jb), &
	 tco2root(1:nLndPts,jb)	  ,tneetot(1:nLndPts,jb)	    ,tco2mic (1:nLndPts,jb)       ,a10td    (1:nLndPts,jb)    , &
         a10ancub(1:nLndPts,jb)	  ,a10ancuc(1:nLndPts,jb)     ,a10ancls(1:nLndPts,jb)    ,a10ancl3(1:nLndPts,jb)     , &
	 a10ancl4(1:nLndPts,jb)	  ,ndtimes(1:nLndPts,jb), &
	 adrain  (1:nLndPts,jb)	  ,adsnow  (1:nLndPts,jb),tnpptot(1:nLndPts,jb),adaet   (1:nLndPts,jb)    ,adtrunoff(1:nLndPts,jb)    , &
	 adsrunoff(1:nLndPts,jb)    ,addrainage(1:nLndPts,jb)   ,adrh    (1:nLndPts,jb)    ,adsnod   (1:nLndPts,jb)    , &
	 adsnof   (1:nLndPts,jb)    ,adwsoi    (1:nLndPts,jb)   ,adtsoi  (1:nLndPts,jb)    ,adwisoi  (1:nLndPts,jb)    , &
         adtlaysoi(1:nLndPts,jb)    ,adwlaysoi (1:nLndPts,jb)   ,adwsoic (1:nLndPts,jb)    ,adtsoic  (1:nLndPts,jb)    , &
	 adco2mic (1:nLndPts,jb)    ,adco2root (1:nLndPts,jb)   ,adco2soi(1:nLndPts,jb)    ,adco2ratio(1:nLndPts,jb)   , &
	 adnmintot(1:nLndPts,jb)    ,decompl   (1:nLndPts,jb)   ,decomps (1:nLndPts,jb)    ,tnmin    (1:nLndPts,jb)    , &
	 ndaypm 		  ,nmtimes(1:nLndPts,jb),amrain   (1:nLndPts,jb)    , &
	 amsnow    (1:nLndPts,jb)   ,amaet     (1:nLndPts,jb)   ,amtrunoff(1:nLndPts,jb)   ,amsrunoff(1:nLndPts,jb)    , &
         amdrainage(1:nLndPts,jb)   ,amtemp    (1:nLndPts,jb)   ,amqa     (1:nLndPts,jb)    , &
	 amsolar   (1:nLndPts,jb)   ,amirup   (1:nLndPts,jb)   ,amirdown (1:nLndPts,jb)    , &
	 amsens    (1:nLndPts,jb)   ,amlatent  (1:nLndPts,jb)   ,amlaiu   (1:nLndPts,jb)   ,amlail   (1:nLndPts,jb)    , &
	 amtsoi    (1:nLndPts,jb)   ,amwsoi    (1:nLndPts,jb)   ,amwisoi  (1:nLndPts,jb)   ,amvwc    (1:nLndPts,jb)    , &
	 amawc     (1:nLndPts,jb)   ,amsnod    (1:nLndPts,jb)   ,amsnof   (1:nLndPts,jb)   ,amnpp(1:nLndPts,1:npft,jb) , &
         amnpptot  (1:nLndPts,jb)   ,amco2mic  (1:nLndPts,jb)   ,amco2root(1:nLndPts,jb)   ,amco2soi (1:nLndPts,jb)    , &
	 amco2ratio(1:nLndPts,jb)   ,amneetot  (1:nLndPts,jb)   ,amnmintot(1:nLndPts,jb)   ,amalbedo (1:nLndPts,jb)    , &
         amtsoil(1:nLndPts,1:nsoilay,jb) ,amwsoil(1:nLndPts,1:nsoilay,jb),amwisoil(1:nLndPts,1:nsoilay,jb), nytimes(1:nLndPts,jb), &
	 aysolar   (1:nLndPts,jb)   ,ayirup    (1:nLndPts,jb)   ,ayirdown (1:nLndPts,jb)   ,aysens	(1:nLndPts,jb)   , &
	 aylatent  (1:nLndPts,jb)   ,ayprcp    (1:nLndPts,jb)   ,ayaet    (1:nLndPts,jb)   ,aytrans	(1:nLndPts,jb)   , &
	 aytrunoff (1:nLndPts,jb)   ,aysrunoff (1:nLndPts,jb)   ,aydrainage(1:nLndPts,jb)  ,aydwtot	(1:nLndPts,jb)   , & 
         aywsoi    (1:nLndPts,jb)   ,aywisoi   (1:nLndPts,jb)   ,aytsoi   (1:nLndPts,jb)   ,ayvwc	(1:nLndPts,jb)   , &
	 ayawc     (1:nLndPts,jb)   ,aystresstu(1:nLndPts,jb)   ,aystresstl(1:nLndPts,jb)  ,aygpp(1:nLndPts,1:npft,jb) , &
	 aygpptot  (1:nLndPts,jb)   ,aynpp(1:nLndPts,1:npft,jb) ,aynpptot (1:nLndPts,jb)   ,ayco2mic  (1:nLndPts,jb)   , &
	 ayco2root (1:nLndPts,jb)   ,ayco2soi  (1:nLndPts,jb)   ,ayneetot (1:nLndPts,jb)   ,ayrootbio (1:nLndPts,jb)   , &
	 aynmintot (1:nLndPts,jb)   ,ayalit    (1:nLndPts,jb)   ,ayblit   (1:nLndPts,jb)   ,aycsoi	(1:nLndPts,jb)   , & 
         aycmic    (1:nLndPts,jb)   ,ayanlit   (1:nLndPts,jb)   ,aybnlit  (1:nLndPts,jb)   ,aynsoi	(1:nLndPts,jb)   , &
	 ayalbedo  (1:nLndPts,jb)   ,totalit   (1:nLndPts,jb)   ,totrlit  (1:nLndPts,jb)   ,totcsoi  (1:nLndPts,jb)    , &
	 totcmic   (1:nLndPts,jb)   , &
	 totanlit  (1:nLndPts,jb)   ,totrnlit  (1:nLndPts,jb)   ,totnsoi  (1:nLndPts,jb)   ,totnmic	(1:nLndPts,jb)   , &
	 totlit    (1:nLndPts,jb)   ,totfall   (1:nLndPts,jb)   ,totnlit  (1:nLndPts,jb)   ,firefac	(1:nLndPts,jb)   , &
	 wtot	   (1:nLndPts,jb)   ,storedn   (1:nLndPts,jb)   ,yrleach  (1:nLndPts,jb)   ,ynleach	(1:nLndPts,jb)   , & 
         falll     (1:nLndPts,jb)   ,fallr     (1:nLndPts,jb)   ,fallw    (1:nLndPts,jb)   ,clitlm	(1:nLndPts,jb)   , &
	 clitls    (1:nLndPts,jb)   ,clitrm    (1:nLndPts,jb)   ,clitrs   (1:nLndPts,jb)   ,clitwm	(1:nLndPts,jb)   , &
	 clitws    (1:nLndPts,jb)   ,csoislop  (1:nLndPts,jb)   ,csoislon (1:nLndPts,jb)   ,csoipas	(1:nLndPts,jb)   , &
	 clitll    (1:nLndPts,jb)   ,clitrl    (1:nLndPts,jb)   ,clitwl   (1:nLndPts,jb)   ,tc	(1:nLndPts,jb)   , &
	 agddu     (1:nLndPts,jb)   ,tempu     (1:nLndPts,jb)   ,agddl    (1:nLndPts,jb)   ,templ	(1:nLndPts,jb)   , &
         dropu     (1:nLndPts,jb)   ,dropls    (1:nLndPts,jb)   ,dropl4   (1:nLndPts,jb)   ,dropl3	(1:nLndPts,jb)   , &
	 plai(1:nLndPts,1:npft,jb)  ,iday,imonth,iyear,iyear0,isimveg,spinmax, &
	 amts2     (1:nLndPts,jb)   ,amtransu  (1:nLndPts,jb)  ,amtransl (1:nLndPts,jb),   amsuvap  (1:nLndPts,jb)	,&
	 aminvap   (1:nLndPts,jb)   ,ux	     (1:nLndPts)      ,uy       (1:nLndPts)      ,taux	(1:nLndPts)      , &
	 tauy	   (1:nLndPts),ts2(1:nLndPts),qs2(1:nLndPts),deltat   (1:nLndPts,jb)   ,gdd0	(1:nLndPts,jb)   , &  
         gdd0this  (1:nLndPts,jb)   ,tcthis    (1:nLndPts,jb)   ,twthis   (1:nLndPts,jb)   ,tcmin	(1:nLndPts,jb)   , &
	 gdd5	   (1:nLndPts,jb)   ,gdd5this  (1:nLndPts,jb)   ,TminL    (1:npft)       ,TminU	(1:npft)       , &
	 Twarm     (1:npft)	  ,GDD       (1:npft)	    ,aleaf    (1:npft)       ,awood	(1:npft)       , &
	 cbiol(1:nLndPts,1:npft,jb) ,aroot     (1:npft)	    ,disturbf (1:nLndPts)      ,disturbo  (1:nLndPts)      , &
	 specla    (1:npft)	  ,biomass(1:nLndPts,1:npft,jb),totlaiu (1:nLndPts,jb)   ,totlail	(1:nLndPts,jb)   , &  
         totbiou   (1:nLndPts,jb)   ,totbiol   (1:nLndPts,jb)   ,woodnorm		     ,vegtype0  (1:nLndPts,jb)   , &
	 tauwood0  (1:npft)	  ,tauwood   (1:nLndPts,1:npft,jb)	    ,tauleaf  (1:npft)       ,tauroot	(1:npft)       , &
	 xminlai,cdisturb  (1:nLndPts,jb)   ,ayanpp(1:nLndPts,1:npft,jb),ayanpptot(1:nLndPts,jb),garea(1:nLndPts,jb),jdt,&
	 idayprev,imonthprev,iyearprev,idayout,imonthout,iyearout,isimco2,isimfire, co2init,calday,tw(1:nLndPts,jb),&
	 fvapa  (1:nLndPts),fsena (1:nLndPts),z0(1:nLndPts),ustar(1:nLndPts), hc(1:nLndPts),hg (1:nLndPts),ec (1:nLndPts),&
	 eg (1:nLndPts) ,d (1:nLndPts) ,cu (1:nLndPts),firb  (1:nLndPts),tgpptot (1:nLndPts),bstar1(1:nLndPts)   ,&
	 ynleach_p (1:nLndPts,jb) ,tnmin_p   (1:nLndPts,jb) ,totnmic_p (1:nLndPts,jb) ,totnlit_p (1:nLndPts,jb) , &
         totanlit_p(1:nLndPts,jb) ,totrnlit_p(1:nLndPts,jb),totnsoi_p (1:nLndPts,jb) ,storedn_p (1:nLndPts,jb),adnpp(1:nLndPts,1:npft,jb) ,&
	 adfalll     (1:nLndPts,jb)   ,adfallr     (1:nLndPts,jb)   ,adfallw    (1:nLndPts,jb),adcbiol(1:nLndPts,1:npft,jb),&
         adcbior(1:nLndPts,1:npft,jb),adcbiow(1:nLndPts,1:npft,jb),adplai(1:nLndPts,1:npft,jb),beta1,beta2,stressfac,avmuir_factor, iMask,nCols,jb,&
	 nVegClass ,rootmode)

              nLndPts=0
              DO i=1,nCols
                 IF (iMask(i) >= 1) THEN
                    nLndPts=nLndPts+1
		     tu (nLndPts,jb) = ta     (nLndPts  )
		     ts (nLndPts,jb) = ta     (nLndPts  )
		     tl (nLndPts,jb) = ta     (nLndPts  )
		     t12(nLndPts,jb) = ta     (nLndPts  )
		     t34(nLndPts,jb) = ta     (nLndPts  )	
		     tgm(nLndPts,jb) = tg     (nLndPts,jb) 
		     q12(nLndPts,jb) = qa     (nLndPts  )	
		     q34(nLndPts,jb) = qa     (nLndPts  )	
                 END IF
              END DO

              END DO
              DO k=1,nsoilay
                 DO i=1,nLndPts
		     tsoim(i,k,jb) = tsoi (i,k,jb)
		     tsoi (i,k,jb) = tsoim(i,k,jb)
                 END DO
              END DO
              DO k=1,nsoilay
                 DO i=1,nLndPts
                    wsoim(i,k,jb) = wsoi(i,k,jb)
		    wsoi(i,k,jb)  = wsoim(i,k,jb)
                 END DO
              END DO
              DO i=1,nLndPts
             !    capac(i,1)=capacm(i,1) wliqu
             !    capac(i,2)=capacm(i,2) wliqu
             !    tu   (i,jb)  =tum   (i,jb)
                 IF(ind.EQ.1) THEN
                    tmin (i) =tg (i,jb)
                 ELSE
                    tmax (i) =tg (i,jb)
                 END IF
		 tgm   (i,jb)=tg (i,jb)
                 tg   (i,jb) =tgm(i,jb)
              END DO	     
          END DO  
	  DO k=1,nsoilay
             DO i=1,nLndPts
	     !	  td   (i,k) =tdm   (i,k)
	        tsoi (i,k,jb) = tsoim(i,k,jb)
             !    td   (i,k) =0.9_r8*0.5_r8*(tmax(i)+tmin(i))+0.1_r8*tdm(i,k)
	        tsoi (i,k,jb) = 0.9_r8*0.5_r8*(tmax(i)+tmin(i))+0.1_r8*tsoim(i,k,jb)
             !    tdm  (i,k) =td(i,k)
	        tsoim(i,k,jb) = tsoi (i,k,jb)
             !    td0  (i,k) =td(i,k)
	        tsoi0(i,k,jb) = tsoi (i,k,jb)
             END DO
          END DO
          !
          !     this is a start of equilibrium tg,tc comp.
          !
          DO i=1,nLndPts
             IF(coszen(i).LT.0.0e0_r8) THEN
                tgm  (i,jb)  =tmin(i)
                tg0  (i,jb)  =tmin(i)
             END IF
          END DO
       END IF
    END IF

    !PPPPP

    IF(nLndPts.GE.1) THEN
       nLndPts=0
       DO i=1,nCols
          IF (iMask(i) >= 1) THEN
             nLndPts=nLndPts+1
             !
             !     precipitation
             !
             raina  (nLndPts  ) = (ppli(i) + ppci(i) )*1.0e-3_r8 * MAX(ABS(dt/dt),1.0_r8) !convert mm/s to m/s
          END IF
       END DO
                CALL IbisDrv (tod,pi,stef,vonk,grav,tmelt,hfus,hvap,hsub,ch2o,cice,cair,cvap,rair,rvap,cappa, &
	 rhow,nLndPts,nband,nsoilay,nsnolay,npft,epsilon,dtc3x,doalb,&
	 ginvap       (1:nLndPts,jb),gsuvap      (1:nLndPts,jb),gtrans	 (1:nLndPts,jb), &
	 gtransu      (1:nLndPts,jb),gtransl	(1:nLndPts,jb),grunof	 (1:nLndPts,jb),gdrain	   (1:nLndPts,jb), &
	 gadjust      (1:nLndPts,jb),a10scalparamu(1:nLndPts,jb),a10daylightu(1:nLndPts,jb),a10scalparaml(1:nLndPts,jb), &
	 a10daylightl (1:nLndPts,jb),vmax_pft	(1:npft)    ,tau15		     ,kc15		       , &
         ko15,cimax,gammaub,alpha3,theta3,beta3,coefmub,coefbub,gsubmin,gammauc,coefmuc,coefbuc, &
	 gsucmin,gammals,coefmls,coefbls,gslsmin,gammal3,coefml3,coefbl3, &
         gsl3min,gammal4,alpha4,theta4,beta4,coefml4,coefbl4,gsl4min,bps(1:nLndPts), &
	 wliqu        (1:nLndPts,jb),wliqumax		    ,wsnou	 (1:nLndPts,jb),wsnoumax  	       , &
	 tu	      (1:nLndPts,jb),wliqs	(1:nLndPts,jb),wliqsmax		     ,wsnos	   (1:nLndPts,jb), &
	 wsnosmax		  ,ts		(1:nLndPts,jb),wliql	 (1:nLndPts,jb),wliqlmax  	       , &  
         wsnol        (1:nLndPts,jb),wsnolmax		    ,tl 	 (1:nLndPts,jb),topparu	   (1:nLndPts,jb), &
	 topparl      (1:nLndPts,jb),fl		(1:nLndPts,jb),fu 	 (1:nLndPts,jb),lai      (1:nLndPts,1:2,jb), &
	 sai	  (1:nLndPts,1:2,jb),rhoveg      (1:nband,1:2),tauveg	(1:nband,1:2),orieh    (1:2)	       , &
	 oriev    (1:2) 	  ,wliqmin		    ,wsnomin		     ,t12	   (1:nLndPts,jb), &
	 tdripu 		  ,tblowu		    ,tdrips		     ,tblows		       , &
         t34	      (1:nLndPts,jb),tdripl		    ,tblowl		     ,ztop     (1:nLndPts,1:2,jb),za     (1:nLndPts), & 
	 alaiml 		  ,zbot     (1:nLndPts,1:2,jb),alaimu		     ,froot	(1:nLndPts,1:nsoilay,1:2,jb), &
	 q34	      (1:nLndPts,jb),q12  	(1:nLndPts,jb),su 	 (1:nLndPts,jb),cleaf		       , &
	 dleaf        (1:2)	  ,ss		(1:nLndPts,jb),cstem		     ,dstem		       , &
	 sl	      (1:nLndPts,jb),cgrass		    ,ciub	 (1:nLndPts,jb),ciuc	   (1:nLndPts,jb), &
         exist (1:nLndPts,1:npft,jb),csub 	(1:nLndPts,jb),gsub	 (1:nLndPts,jb),csuc	   (1:nLndPts,jb), &
	 gsuc	      (1:nLndPts,jb),agcub	(1:nLndPts,jb),agcuc	 (1:nLndPts,jb),ancub	   (1:nLndPts,jb), &
	 ancuc        (1:nLndPts,jb),totcondub	(1:nLndPts,jb),totconduc   (1:nLndPts,jb),cils	   (1:nLndPts,jb), &
	 cil3	      (1:nLndPts,jb),cil4 	(1:nLndPts,jb),csls	 (1:nLndPts,jb),gsls	   (1:nLndPts,jb), &
	 csl3	      (1:nLndPts,jb),gsl3 	(1:nLndPts,jb),csl4	 (1:nLndPts,jb),gsl4	   (1:nLndPts,jb), &
	 agcls        (1:nLndPts,jb),agcl4	(1:nLndPts,jb),agcl3	 (1:nLndPts,jb),ancls	   (1:nLndPts,jb), &
	 ancl4        (1:nLndPts,jb),ancl3	(1:nLndPts,jb),totcondls   (1:nLndPts,jb),totcondl3    (1:nLndPts,jb), &
	 totcondl4    (1:nLndPts,jb),chu(1:nVegClass),chs(1:nVegClass),chl(1:nVegClass),frac  (1:nLndPts,1:npft,jb),tlsub  	(1:nLndPts,jb),z0sno,rhos, &
	 consno 		  ,hsnotop		    ,hsnomin		     ,fimin		       , &
	 fimax  		  ,fi		(1:nLndPts,jb),tsno(1:nLndPts,1:nsnolay,jb),hsno(1:nLndPts,1:nsnolay,jb),&
	 sand(1:nLndPts,1:nsoilay,jb),clay(1:nLndPts,1:nsoilay,jb),poros(1:nLndPts,1:nsoilay,jb),wsoi(1:nLndPts,1:nsoilay,jb), &
	 wisoi(1:nLndPts,1:nsoilay,jb),consoi(1:nLndPts,1:nsoilay,jb),zwpmax	     ,wpud(1:nLndPts,jb)         , &
	 wipud        (1:nLndPts,jb),wpudmax		    ,qglif   (1:nLndPts,1:4,jb),tsoi(1:nLndPts,1:nsoilay,jb), &
	 hvasug       (1:nLndPts,jb),hvasui	(1:nLndPts,jb),albsav	 (1:nLndPts,jb),albsan	   (1:nLndPts,jb), &
	 tg	      (1:nLndPts,jb),ti		(1:nLndPts,jb),z0soi(1:nLndPts,jb)       ,swilt(1:nLndPts,1:nsoilay,jb), &
	 sfield(1:nLndPts,1:nsoilay,jb),stressl(1:nLndPts,1:nsoilay,jb),stressu(1:nLndPts,1:nsoilay,jb),stresstl(1:nLndPts,jb), &
	 stresstu (1:nLndPts,jb)    ,csoi(1:nLndPts,1:nsoilay,jb),rhosoi(1:nLndPts,1:nsoilay,jb),hsoi(1:nLndPts,1:nsoilay+1,jb)   , &
	 suction(1:nLndPts,1:nsoilay,jb),bex (1:nLndPts,1:nsoilay,jb),upsoiu(1:nLndPts,1:nsoilay,jb),upsoil(1:nLndPts,1:nsoilay,jb), &
	 heatg   (1:nLndPts,jb),heati   (1:nLndPts,jb),hydraul(1:nLndPts,1:nsoilay,jb),porosflo(1:nLndPts,1:nsoilay,jb), &
	 ibex(1:nLndPts,1:nsoilay,jb),bperm(1:nLndPts,jb),hflo      (1:nLndPts,1:nsoilay+1,jb),ta       (1:nLndPts)       , &
	 asurd (1:nLndPts,1:nBand,jb),asuri(1:nLndPts,1:nBand,jb),coszen(1:nLndPts)	      ,solad (1:nLndPts,1:nBand)  , &
	 solai (1:nLndPts,1:nBand)  ,fira      (1:nLndPts)      ,raina (1:nLndPts)	     ,qa    (1:nLndPts)	       , &
	 psurf    (1:nLndPts)	  ,snowa     (1:nLndPts)      ,ua    (1:nLndPts)	     ,o2conc		       , &
	 co2conc		  ,td	 (1:nLndPts,jb)	    ,vzero    (1:nLndPts,jb)   ,ndaypy		       , &
	 nppdummy(1:nLndPts,1:npft,jb) ,cbiow (1:nLndPts,1:npft,jb),sapfrac(1:nLndPts,jb)      ,cbior(1:nLndPts,1:npft,jb), &
	 tco2root(1:nLndPts,jb)	  ,tneetot(1:nLndPts,jb)	    ,tco2mic (1:nLndPts,jb)       ,a10td    (1:nLndPts,jb)    , &
         a10ancub(1:nLndPts,jb)	  ,a10ancuc(1:nLndPts,jb)     ,a10ancls(1:nLndPts,jb)    ,a10ancl3(1:nLndPts,jb)     , &
	 a10ancl4(1:nLndPts,jb)	  ,ndtimes(1:nLndPts,jb), &
	 adrain  (1:nLndPts,jb)	  ,adsnow  (1:nLndPts,jb),tnpptot(1:nLndPts,jb),adaet   (1:nLndPts,jb)    ,adtrunoff(1:nLndPts,jb), &
	 adsrunoff(1:nLndPts,jb)    ,addrainage(1:nLndPts,jb)   ,adrh    (1:nLndPts,jb)    ,adsnod   (1:nLndPts,jb)    , &
	 adsnof   (1:nLndPts,jb)    ,adwsoi    (1:nLndPts,jb)   ,adtsoi  (1:nLndPts,jb)    ,adwisoi  (1:nLndPts,jb)    , &
         adtlaysoi(1:nLndPts,jb)    ,adwlaysoi (1:nLndPts,jb)   ,adwsoic (1:nLndPts,jb)    ,adtsoic  (1:nLndPts,jb)    , &
	 adco2mic (1:nLndPts,jb)    ,adco2root (1:nLndPts,jb)   ,adco2soi(1:nLndPts,jb)    ,adco2ratio(1:nLndPts,jb)   , &
	 adnmintot(1:nLndPts,jb)    ,decompl   (1:nLndPts,jb)   ,decomps (1:nLndPts,jb)    ,tnmin    (1:nLndPts,jb)    , &
	 ndaypm 		  ,nmtimes(1:nLndPts,jb),amrain   (1:nLndPts,jb)    , &
	 amsnow    (1:nLndPts,jb)   ,amaet     (1:nLndPts,jb)   ,amtrunoff(1:nLndPts,jb)   ,amsrunoff(1:nLndPts,jb)    , &
         amdrainage(1:nLndPts,jb)   ,amtemp    (1:nLndPts,jb)   ,amqa     (1:nLndPts,jb)    , &
	 amsolar   (1:nLndPts,jb)   ,amirup   (1:nLndPts,jb)   ,amirdown (1:nLndPts,jb)    , &
	 amsens    (1:nLndPts,jb)   ,amlatent  (1:nLndPts,jb)   ,amlaiu   (1:nLndPts,jb)   ,amlail   (1:nLndPts,jb)    , &
	 amtsoi    (1:nLndPts,jb)   ,amwsoi    (1:nLndPts,jb)   ,amwisoi  (1:nLndPts,jb)   ,amvwc    (1:nLndPts,jb)    , &
	 amawc     (1:nLndPts,jb)   ,amsnod    (1:nLndPts,jb)   ,amsnof   (1:nLndPts,jb)   ,amnpp(1:nLndPts,1:npft,jb) , &
         amnpptot  (1:nLndPts,jb)   ,amco2mic  (1:nLndPts,jb)   ,amco2root(1:nLndPts,jb)   ,amco2soi (1:nLndPts,jb)    , &
	 amco2ratio(1:nLndPts,jb)   ,amneetot  (1:nLndPts,jb)   ,amnmintot(1:nLndPts,jb)   ,amalbedo (1:nLndPts,jb)    , &
         amtsoil(1:nLndPts,1:nsoilay,jb) ,amwsoil(1:nLndPts,1:nsoilay,jb),amwisoil(1:nLndPts,1:nsoilay,jb), nytimes(1:nLndPts,jb), &
	 aysolar   (1:nLndPts,jb)   ,ayirup    (1:nLndPts,jb)   ,ayirdown (1:nLndPts,jb)   ,aysens	(1:nLndPts,jb)   , &
	 aylatent  (1:nLndPts,jb)   ,ayprcp    (1:nLndPts,jb)   ,ayaet    (1:nLndPts,jb)   ,aytrans	(1:nLndPts,jb)   , &
	 aytrunoff (1:nLndPts,jb)   ,aysrunoff (1:nLndPts,jb)   ,aydrainage(1:nLndPts,jb)  ,aydwtot	(1:nLndPts,jb)   , & 
         aywsoi    (1:nLndPts,jb)   ,aywisoi   (1:nLndPts,jb)   ,aytsoi   (1:nLndPts,jb)   ,ayvwc	(1:nLndPts,jb)   , &
	 ayawc     (1:nLndPts,jb)   ,aystresstu(1:nLndPts,jb)   ,aystresstl(1:nLndPts,jb)  ,aygpp(1:nLndPts,1:npft,jb) , &
	 aygpptot  (1:nLndPts,jb)   ,aynpp(1:nLndPts,1:npft,jb) ,aynpptot (1:nLndPts,jb)   ,ayco2mic  (1:nLndPts,jb)   , &
	 ayco2root (1:nLndPts,jb)   ,ayco2soi  (1:nLndPts,jb)   ,ayneetot (1:nLndPts,jb)   ,ayrootbio (1:nLndPts,jb)   , &
	 aynmintot (1:nLndPts,jb)   ,ayalit    (1:nLndPts,jb)   ,ayblit   (1:nLndPts,jb)   ,aycsoi	(1:nLndPts,jb)   , & 
         aycmic    (1:nLndPts,jb)   ,ayanlit   (1:nLndPts,jb)   ,aybnlit  (1:nLndPts,jb)   ,aynsoi	(1:nLndPts,jb)   , &
	 ayalbedo  (1:nLndPts,jb)   ,totalit   (1:nLndPts,jb)   ,totrlit  (1:nLndPts,jb)   ,totcsoi  (1:nLndPts,jb)    , &
	 totcmic   (1:nLndPts,jb)   , &
	 totanlit  (1:nLndPts,jb)   ,totrnlit  (1:nLndPts,jb)   ,totnsoi  (1:nLndPts,jb)   ,totnmic	(1:nLndPts,jb)   , &
	 totlit    (1:nLndPts,jb)   ,totfall   (1:nLndPts,jb)   ,totnlit  (1:nLndPts,jb)   ,firefac	(1:nLndPts,jb)   , &
	 wtot	   (1:nLndPts,jb)   ,storedn   (1:nLndPts,jb)   ,yrleach  (1:nLndPts,jb)   ,ynleach	(1:nLndPts,jb)   , & 
         falll     (1:nLndPts,jb)   ,fallr     (1:nLndPts,jb)   ,fallw    (1:nLndPts,jb)   ,clitlm	(1:nLndPts,jb)   , &
	 clitls    (1:nLndPts,jb)   ,clitrm    (1:nLndPts,jb)   ,clitrs   (1:nLndPts,jb)   ,clitwm	(1:nLndPts,jb)   , &
	 clitws    (1:nLndPts,jb)   ,csoislop  (1:nLndPts,jb)   ,csoislon (1:nLndPts,jb)   ,csoipas	(1:nLndPts,jb)   , &
	 clitll    (1:nLndPts,jb)   ,clitrl    (1:nLndPts,jb)   ,clitwl   (1:nLndPts,jb)   ,tc	(1:nLndPts,jb)   , &
	 agddu     (1:nLndPts,jb)   ,tempu     (1:nLndPts,jb)   ,agddl    (1:nLndPts,jb)   ,templ	(1:nLndPts,jb)   , &
         dropu     (1:nLndPts,jb)   ,dropls    (1:nLndPts,jb)   ,dropl4   (1:nLndPts,jb)   ,dropl3	(1:nLndPts,jb)   , &
	 plai(1:nLndPts,1:npft,jb)  ,iday,imonth,iyear,iyear0,isimveg,spinmax, &
	 amts2     (1:nLndPts,jb)   ,amtransu  (1:nLndPts,jb)  ,amtransl (1:nLndPts,jb),   amsuvap  (1:nLndPts,jb)	,&
	 aminvap   (1:nLndPts,jb)   ,ux	     (1:nLndPts)      ,uy       (1:nLndPts)      ,taux	(1:nLndPts)      , &
	 tauy(1:nLndPts),ts2(1:nLndPts),qs2(1:nLndPts),deltat(1:nLndPts,jb),gdd0(1:nLndPts,jb), &  
         gdd0this  (1:nLndPts,jb)   ,tcthis    (1:nLndPts,jb)   ,twthis   (1:nLndPts,jb)   ,tcmin	(1:nLndPts,jb)   , &
	 gdd5	   (1:nLndPts,jb)   ,gdd5this  (1:nLndPts,jb)   ,TminL    (1:npft)       ,TminU	(1:npft)       , &
	 Twarm     (1:npft)	  ,GDD       (1:npft)	    ,aleaf    (1:npft)       ,awood	(1:npft)       , &
	 cbiol(1:nLndPts,1:npft,jb) ,aroot     (1:npft)	    ,disturbf (1:nLndPts)      ,disturbo  (1:nLndPts)      , &
	 specla    (1:npft)	  ,biomass(1:nLndPts,1:npft,jb),totlaiu (1:nLndPts,jb)   ,totlail	(1:nLndPts,jb)   , &  
         totbiou   (1:nLndPts,jb)   ,totbiol   (1:nLndPts,jb)   ,woodnorm		     ,vegtype0  (1:nLndPts,jb)   , &
	 tauwood0  (1:npft)	  ,tauwood   (1:nLndPts,1:npft,jb)	    ,tauleaf  (1:npft)       ,tauroot	(1:npft)       , &
	 xminlai		  ,cdisturb  (1:nLndPts,jb)   ,ayanpp(1:nLndPts,1:npft,jb),ayanpptot(1:nLndPts,jb)   , &
	 garea     (1:nLndPts,jb)   ,jdt,idayprev,imonthprev,iyearprev,idayout,imonthout,iyearout,isimco2,isimfire,&
	 co2init,calday,tw(1:nLndPts,jb),fvapa  (1:nLndPts),fsena (1:nLndPts),z0(1:nLndPts),ustar(1:nLndPts) ,hc(1:nLndPts),&
	 hg (1:nLndPts),ec (1:nLndPts),eg (1:nLndPts),d(1:nLndPts),cu(1:nLndPts),firb  (1:nLndPts),tgpptot (1:nLndPts),bstar1(1:nLndPts),&
         ynleach_p (1:nLndPts,jb) ,tnmin_p   (1:nLndPts,jb) ,totnmic_p (1:nLndPts,jb) ,totnlit_p (1:nLndPts,jb) ,&
         totanlit_p(1:nLndPts,jb) ,totrnlit_p(1:nLndPts,jb),totnsoi_p (1:nLndPts,jb) ,storedn_p (1:nLndPts,jb), adnpp(1:nLndPts,1:npft,jb),&
	 adfalll     (1:nLndPts,jb)   ,adfallr     (1:nLndPts,jb)   ,adfallw    (1:nLndPts,jb),adcbiol(1:nLndPts,1:npft,jb),&
         adcbior(1:nLndPts,1:npft,jb),adcbiow(1:nLndPts,1:npft,jb),adplai(1:nLndPts,1:npft,jb),beta1,beta2,stressfac,avmuir_factor, iMask,nCols,jb,&
	 nVegClass ,rootmode )


   END IF

    !
    !     sib time integaration and time filter
    !
    DO i=1,nLndPts
 !      qm(i)=MAX(1.0e-12_r8,qm(i))
    END DO

    nLndPts=0
    DO i=1,nCols
       IF (iMask(i) >= 1) THEN
          nLndPts=nLndPts+1
	 !tgeff(i)=SQRT ( SQRT (( zlwup(i)*stbi )))fu fi fl
	 ! tsea(i)    =(tu(nLndPts,jb) + tl(nLndPts,jb)+ti(nLndPts,jb) + tg(nLndPts,jb))/4.0_r8
          tsea(i)    =SQRT ( SQRT (( MIN(MAX(firb(nLndPts),0.0_r8),1000.0_r8)*(1.0_r8  /stef) )))!(tu(nLndPts,jb) + tl(nLndPts,jb)+ti(nLndPts,jb) + tg(nLndPts,jb))/4.0_r8
       END IF
    END DO
    DO k = 1, nsoilay
       nLndPts=0
       DO i=1,nCols
          IF (iMask(i) >= 1_i8)THEN
             nLndPts=nLndPts+1
             IF (INT(vegtype0  (nLndPts,jb))  == 15_i8) THEN
                !zorl (i) = zorl_landice (nLndPts  )
                !tsea (i) = tsea_landice  (nLndPts )
                !taux  (nLndPts )=taux_landice  (nLndPts )
                !tauy  (nLndPts )=tauy_landice  (nLndPts )
                !ustar (nLndPts )=ustar_landice (nLndPts )
                !bstar (nLndPts )=bstar_landice (nLndPts )
                !tsoi  (nLndPts,k,jb)=tsoi_landice  (nLndPts,k)
                !fvapa (nLndPts) = -evap_landice  (nLndPts )
                !fsena (nLndPts) = -hflx_landice  (nLndPts )
                !PRINT*,evap_landice  (nLndPts )*hvap,hflx_landice  (nLndPts ),-fsena (nLndPts),-fvapa (nLndPts)*hvap
                !
                !                 Antarctica ice
                !
                tsoi (nLndPts,k,jb) = MIN(MAX(218.00_r8,tsoi  (nLndPts,k,jb)),273.16_r8)
                wisoi(nLndPts,k,jb) = MIN(MAX(0.94_r8   ,wisoi (nLndPts,k,jb)),1.00_r8  )
                wsoi (nLndPts,k,jb) = MIN(MAX(0.4_r8   ,wsoi  (nLndPts,k,jb)),1.0_r8  )
             END IF
          END IF
       END DO
    END DO
    DO k =1, nsnolay
       nLndPts=0
       DO i=1,nCols
          IF (iMask(i) >= 1_i8)THEN
             nLndPts=nLndPts+1
             IF (INT(vegtype0  (nLndPts,jb))  == 15_i8) THEN
                !
                !                 Antarctica snow
                !
                fi   (nLndPts  ,jb) = 1.0_r8
                tg   (nLndPts  ,jb) = MIN(MAX(218.00_r8,tg   (nLndPts  ,jb)),273.16_r8)
                tsno (nLndPts,k,jb) = MIN(MAX(218.00_r8,tsno (nLndPts,k,jb)),273.16_r8)
                hsno (nLndPts,k,jb) = 2.0_r8
                IF(k==1)hsno(nLndPts,1,jb) = 0.050_r8
                IF(k==2)hsno(nLndPts,2,jb) = 2.0_r8
                IF(k==3)hsno(nLndPts,3,jb) = 2.0_r8
             END IF
          END IF
       END DO
    END DO

   nLndPts=0
   DO i=1,nCols
      IF (iMask(i) >= 1)THEN 
         nLndPts=nLndPts+1
	  sens    (i) =  -fsena (nLndPts)
          evap    (i) =  -fvapa (nLndPts)*hvap

	  tgm  (nLndPts,jb  ) = tgm     (nLndPts,jb )
 	  tg   (nLndPts,jb  ) = tg      (nLndPts,jb )
	  tg0  (nLndPts,jb  ) = tg0     (nLndPts,jb )

          DO k=1,nsoilay 
	       tsoi0(nLndPts,k,jb) = tsoi0 (nLndPts,k,jb)
	       tsoim(nLndPts,k,jb) = tsoim (nLndPts,k,jb)
	       tsoi (nLndPts,k,jb) = tsoi  (nLndPts,k,jb)
          END DO
          DO k=1,nsoilay
	      wsoi0(nLndPts,k,jb)  = wsoi0 (nLndPts,k,jb)
              wsoim(nLndPts,k,jb)  = wsoim (nLndPts,k,jb)
	      wsoi (nLndPts,k,jb)  = wsoi  (nLndPts,k,jb)
          END DO
      END IF
   END DO
    !
    !     sea or sea ice
    ! gu gv gps colrad sigki delsig sens evap umom vmom rmi rhi cond stor zorl rnet ztn2 THETA_2M VELC_2m MIXQ_2M
    ! THETA_10M VELC_10M MIXQ_10M
    ! mmax=ncols-nmax+1
    ! including case 1D physics

    IF(initlz.GE.0.AND.kt.EQ.0.AND.jdt.EQ.1)THEN
      Tsfc0(1:nCols,jb)=gt  (1:nCols)
      Qsfc0(1:nCols,jb)=gq  (1:nCols)
      Tsfcm(1:nCols,jb)=gt  (1:nCols)
      Qsfcm(1:nCols,jb)=gq  (1:nCols)
      tsfc (1:nCols)=gt  (1:nCols)
      qsfc (1:nCols)=gq  (1:nCols)
    END IF
    DO i=1,nCols
       IF(mskant(i) == 1)THEN
          xsea (i) = tseam(i)
          tsfc (i) = Tsfcm(i,jb)
          qsfc (i) = Qsfcm(i,jb)
       END IF   
    END DO
    CALL seasfc( tmtx  ,umtx  ,qmtx   ,& 
	   slrad       (1:nCols)	    ,&
	   tsurf (1:nCols)	,qsurf (1:nCols)    ,gu    (1:nCols)	  ,&
	   gv	 (1:nCols)	,gt    (1:nCols)    ,gq    (1:nCols)	  ,&
	   gps   (1:nCols)	,xsea  (1:nCols)    ,dtc3x		  ,&
	   SIN(colrad(1:nCols))	,sigki  	    ,delsig	          ,&
	   sens  (1:nCols)      ,evap  (1:nCols)    ,umom  (1:nCols)      ,&
	   vmom  (1:nCols)	,rmi   (1:nCols)    ,rhi   (1:nCols)	  ,&
	   cond  (1:nCols)	,stor  (1:nCols)    ,zorl  (1:nCols)	  ,&
	   rnet  (1:nCols)	,nCols  	    ,&
	   Ustarm(1:nCols)	,z0sea (1:nCols)    ,rho   (1:nCols)	  ,&
	   qsfc  (1:nCols)      ,tsfc  (1:nCols)    ,mskant(1:nCols)	  ,&
	   bstar)

    DO i=1,nCols
       IF(mskant(i) == 1 .and. tsea(i) <= 0.0e0_r8 .AND. tsurf(i) < tice+0.01e0_r8 ) THEN
   	  IF(intg.EQ.2) THEN
    	     IF(istrt.EQ.0) THEN
    		tseam(i)=filta*tsea (i) + epsflt*(tseam(i)+xsea(i))
    		qsfc (i)=MAX(1.0e-12_r8,qsfc(i))
    		Tsfcm(i,jb)=filta*Tsfc0 (i,jb) + epsflt*(Tsfcm(i,jb)+tsfc(i))
    		Qsfcm(i,jb)=filta*Qsfc0 (i,jb) + epsflt*(Qsfcm(i,jb)+qsfc(i))
    	     END IF
    	     tsea (i) = xsea(i)
    	     qsfc (i) = MAX(1.0e-12_r8,qsfc(i))
    	     Tsfc0(i,jb) = tsfc(i)
    	     Qsfc0(i,jb) = qsfc(i)
    	  ELSE
    	     tsea (i) = xsea(i)
    	     tseam(i) = xsea(i)
    	     qsfc (i) = MAX(1.0e-12_r8,qsfc(i))
    	     Tsfc0(i,jb) = tsfc(i)
    	     Qsfc0(i,jb) = qsfc(i)
    	     Tsfcm(i,jb) = tsfc(i)
    	     Qsfcm(i,jb) = qsfc(i)
    	  END IF
       END IF
       IF(mskant(i) == 1 .and. tsea(i).LT.0.0e0_r8.AND.tsurf(i).GE.tice+0.01e0_r8) THEN
    	  tseam(i) = tsea (i)
    	  Tsfcm(i,jb) = Tsfc0(i,jb)
    	  Qsfcm(i,jb) = Qsfc0(i,jb)
       END IF
    END DO

    nLndPts=0
    DO i=1,nCols
      IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
	  tgrd(nLndPts)= tg    (nLndPts,jb)
	  roff(nLndPts)= grunof(nLndPts,jb)
	  ect(nLndPts )= gtrans(nLndPts,jb) * hltm * dtc3x!Transpiracao no topo da copa (J/m*m)
	  eci(nLndPts )= ginvap(nLndPts,jb) * hltm * dtc3x!...Evaporacao da agua interceptada no topo da copa (J/m*m) ! (kg m-2 s-1 * J/kg*dt)
	  egt(nLndPts )= gtransu(nLndPts,jb)* hltm * dtc3x!Transpiracao na base da copa (J/m*m)
	  egi(nLndPts )= gtransl(nLndPts,jb)* hltm * dtc3x !Evaporacao da neve (J/m*m)
	  egs(nLndPts )= gsuvap (nLndPts,jb)* hltm * dtc3x !Evaporacao do solo arido (J/m*m)

	  !WRITE(*,'(A,5F12.5)')'pkubota', ect(nLndPts ),eci(nLndPts ),egt(nLndPts ),egi(nLndPts ),egs(nLndPts )

	  iMaskIBIS(nLndPts,jb) =  INT(vegtype0  (nLndPts,jb)) 
          umom     (i) =  taux  (nLndPts)
          vmom     (i) =  tauy  (nLndPts)
	  bstar    (i) =  bstar1(nLndPts)
	  sens     (i) =  -fsena (nLndPts)
          evap     (i) =  -fvapa (nLndPts)*hvap
	  Tsfc0    (i,jb)       = tg    (nLndPts,jb)
	  ! Tsfc0    (i,jb)       = ts2    (nLndPts)
	  ! Qsfc0    (i,jb)       = MAX   (1.0e-12_r8,qa (nLndPts))
	  Qsfc0    (i,jb)       = MAX   (1.0e-12_r8,qs2 (nLndPts))
	  Tsfcm    (i,jb)       = tg    (nLndPts,jb)
	  ! Tsfcm    (i,jb)       = ts2    (nLndPts)
	  ! Qsfcm    (i,jb)       = MAX   (1.0e-12_r8,qa (nLndPts))       
	  Qsfcm    (i,jb)       = MAX   (1.0e-12_r8,qs2 (nLndPts))       
	  w0       (nLndPts,1,jb) = wsoi(nLndPts,1,jb)
          w0       (nLndPts,2,jb) = wsoi(nLndPts,3,jb)
	  w0       (nLndPts,3,jb) = wsoi(nLndPts,nsoilay,jb)
	  wm       (nLndPts,1,jb) = wsoi(nLndPts,1,jb)
          wm       (nLndPts,2,jb) = wsoi(nLndPts,3,jb)
	  wm       (nLndPts,3,jb) = wsoi(nLndPts,nsoilay,jb)
          capac0   (nLndPts,1,jb) = wliqu(nLndPts,jb) + wliqs(nLndPts,jb)
	  capac0   (nLndPts,2,jb) = wliql(nLndPts,jb)
          capacm   (nLndPts,1,jb) = wliqu(nLndPts,jb) + wliqs(nLndPts,jb)
	  capacm   (nLndPts,2,jb) = wliql(nLndPts,jb)
    	  td0      (nLndPts,jb)   = tsoi(nLndPts,nsoilay,jb)  
    	  tdm      (nLndPts,jb)   = tsoi(nLndPts,nsoilay,jb)  
    	  tc0      (nLndPts,jb)   = tu    (nLndPts,jb)
    	  tcm      (nLndPts,jb)   = tu    (nLndPts,jb)
    	  tg0      (nLndPts,jb)   = tg    (nLndPts,jb)
    	  tgm      (nLndPts,jb)   = tg    (nLndPts,jb)
       END IF
    END DO    

    Grd(1)%Units='mb'
    Grd(1)%Name='Pressao'
    Grd(1)%NameG='pslc'
    DO i=1, nCols
       Grd(1)%Buffer(i,1,jb)=Grd(1)%Buffer(i,1,jb) + maxstp*(gps(i))   
    END DO
    Grd(2)%Units='W m-2'
    Grd(2)%Name='sensible heat flux'
    Grd(2)%NameG='sens'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(2)%Buffer(i,1,jb) = Grd(2)%Buffer(i,1,jb) + maxstp*MAX((-fsena (nLndPts)),-20.0_r8)
       ELSE
          Grd(2)%Buffer(i,1,jb) = undef
       END IF
    END DO
    
    Grd(3)%Units='W m-2'
    Grd(3)%Name='h2o vapor flux between'
    Grd(3)%NameG='evap'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(3)%Buffer(i,1,jb) = Grd(3)%Buffer(i,1,jb) + maxstp*MAX((-fvapa (nLndPts)*hvap) ,-10.0_r8)
       ELSE
          Grd(3)%Buffer(i,1,jb) = undef
       END IF
    END DO
    Grd(4)%Units='%'
    Grd(4)%Name='fraction of soil pore space containing liquid water'
    Grd(4)%NameG='mois'
    DO k=1,Grd(1)%nSoil
       nLndPts=0
       DO i=1, nCols
          IF(iMask(i) >= 1)THEN 
             nLndPts=nLndPts+1
             Grd(4)%Buffer(i,Grd(1)%nSoil+1-k,jb) = Grd(4)%Buffer(i,Grd(1)%nSoil+1-k,jb) + maxstp*(wsoi (nLndPts,k,jb)) 
          ELSE
             Grd(4)%Buffer(i,Grd(1)%nSoil+1-k,jb) = undef
          END IF
       END DO
    END DO
    Grd(5)%Units='K'
    Grd(5)%Name='soil skin temperature '
    Grd(5)%NameG='tskn'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(5)%Buffer(i,1,jb) = Grd(5)%Buffer(i,1,jb) + maxstp*(tg (nLndPts,jb)) 
       ELSE
          Grd(5)%Buffer(i,1,jb) = undef
       END IF
    END DO
    Grd(6)%Units='(K)'
    Grd(6)%Name='soil temperature for each layer '
    Grd(6)%NameG='tsoil'
    DO k=1,Grd(6)%nSoil
       nLndPts=0
       DO i=1, nCols
          IF(iMask(i) >= 1)THEN 
             nLndPts=nLndPts+1
             Grd(6)%Buffer(i,Grd(6)%nSoil+1-k,jb) = Grd(6)%Buffer(i,Grd(6)%nSoil+1-k,jb) + maxstp*(tsoi (nLndPts,k,jb)) 
          ELSE
             Grd(6)%Buffer(i,Grd(6)%nSoil+1-k,jb) = undef
          END IF
       END DO
    END DO

    Grd(7)%Units='W m-2'
    Grd(7)%Name='downward solar flux '
    Grd(7)%NameG='swrad'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(7)%Buffer(i,1,jb) = Grd(7)%Buffer(i,1,jb) + &
	  maxstp*((solad  (nLndPts,1)+solai  (nLndPts,1) + solad  (nLndPts,2) + solai  (nLndPts,2))) 
       ELSE
          Grd(7)%Buffer(i,1,jb) = undef
       END IF
    END DO

    Grd(8)%Units='W m-2'
    Grd(8)%Name='downward longwave flux '
    Grd(8)%NameG='lwrad'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(8)%Buffer(i,1,jb) = Grd(8)%Buffer(i,1,jb) + &
	  maxstp*(fira(nLndPts  )) 
       ELSE
          Grd(8)%Buffer(i,1,jb) = undef
       END IF
    END DO

    Grd(9)%Units='(mm)'
    Grd(9)%Name='rainfall  '
    Grd(9)%NameG='rain'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(9)%Buffer(i,1,jb) = Grd(9)%Buffer(i,1,jb) + &
	  maxstp*(raina  (nLndPts  )*(MAX(ABS((dt/dt)*DELTAIN),1.0_r8))) 
       ELSE
          Grd(9)%Buffer(i,1,jb) = undef
       END IF
    END DO

    Grd(10)%Units='(mm/s or kg m-2 s-1)'
    Grd(10)%Name=' surface runoff rate '
    Grd(10)%NameG='roff'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(10)%Buffer(i,1,jb) = Grd(10)%Buffer(i,1,jb) + &
	  maxstp*(roff  (nLndPts  )) 
       ELSE
          Grd(10)%Buffer(i,1,jb) = undef
       END IF
    END DO
    
    Grd(11)%Units='W/m^2'
    Grd(11)%Name=' Transpiracao no topo da copa '
    Grd(11)%NameG='ect'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(11)%Buffer(i,1,jb) = Grd(11)%Buffer(i,1,jb) + &
	  maxstp*(ect  (nLndPts  )/dtc3x) 
       ELSE
          Grd(11)%Buffer(i,1,jb) = undef
       END IF
    END DO
    
    Grd(12)%Units='W/m^2'
    Grd(12)%Name=' Evaporacao da agua interceptada no topo da copa '
    Grd(12)%NameG='eci'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(12)%Buffer(i,1,jb) = Grd(12)%Buffer(i,1,jb) + &
	  maxstp*(eci  (nLndPts  )/dtc3x) 
       ELSE
          Grd(12)%Buffer(i,1,jb) = undef
       END IF
    END DO
    
    Grd(13)%Units='W/m^2'
    Grd(13)%Name=' Transpiracao na base da copa '
    Grd(13)%NameG='egt'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(13)%Buffer(i,1,jb) = Grd(13)%Buffer(i,1,jb) + &
	  maxstp*(egt  (nLndPts  )/dtc3x) 
       ELSE
          Grd(13)%Buffer(i,1,jb) = undef
       END IF
    END DO
    
    Grd(14)%Units='W/m^2'
    Grd(14)%Name=' Evaporacao da neve  '
    Grd(14)%NameG='egi'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(14)%Buffer(i,1,jb) = Grd(14)%Buffer(i,1,jb) + &
	  maxstp*(egi  (nLndPts  )/dtc3x) 
       ELSE
          Grd(14)%Buffer(i,1,jb) = undef
       END IF
    END DO
    
    Grd(15)%Units='W/m^2'
    Grd(15)%Name=' Evaporacao do solo arido  '
    Grd(15)%NameG='egs'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(15)%Buffer(i,1,jb) = Grd(15)%Buffer(i,1,jb) + &
	  maxstp*(egs  (nLndPts  )/dtc3x) 
       ELSE
          Grd(15)%Buffer(i,1,jb) = undef
       END IF
    END DO
    
    Grd(16)%Units='K'
    Grd(16)%Name=' 2 meters Temperature  '
    Grd(16)%NameG='ts2'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(16)%Buffer(i,1,jb) = Grd(16)%Buffer(i,1,jb) + &
	  maxstp*(ts2  (nLndPts  )) 
       ELSE
          Grd(16)%Buffer(i,1,jb) = undef
       END IF
    END DO
    
    Grd(17)%Units='kg kg-1'
    Grd(17)%Name=' 2 meters specific humidity  '
    Grd(17)%NameG='qs2'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(17)%Buffer(i,1,jb) = Grd(17)%Buffer(i,1,jb) + &
	  maxstp*(qs2  (nLndPts  )) 
       ELSE
          Grd(17)%Buffer(i,1,jb) = undef
       END IF
    END DO

    Grd(18)%Units='rad'
    Grd(18)%Name=' cosine of solar zenith angle  '
    Grd(18)%NameG='cosz'
    DO i=1, nCols
          Grd(18)%Buffer(i,1,jb) = Grd(18)%Buffer(i,1,jb) + &
	  maxstp*(zenith (i) ) 
    END DO
    !     avisb(i)=asuri(ncount,1,jb)		   !asurd  (npoi,nband)   ! local  ! direct albedo of surface system
    !     avisd(i)=asurd(ncount,1,jb)		   !asuri  (npoi,nband)   ! local  ! diffuse albedo of surface system 
    !     anirb(i)=asuri(ncount,2,jb)
    !     anird(i)=asurd(ncount,2,jb)
    !REAL(KIND=r8)	 :: solad  (nCols,nband) ! direct downward solar flux (W m-2)
    !REAL(KIND=r8)	 :: solai  (nCols,nband) ! diffuse downward solar flux (W m-2)

    !     solad  (nLndPts,1) = xvisb  (i)  !! number of solar radiation wavebands : vis, nir
    !     solai  (nLndPts,1) = xvisd  (i)
    !     solad  (nLndPts,2) = xnirb  (i)
    !     solai  (nLndPts,2) = xnird  (i)
    
    
    Grd(19)%Units='W m-2'
    Grd(19)%Name=' Shortwave up  '
    Grd(19)%NameG='swup'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(19)%Buffer(i,1,jb) = Grd(19)%Buffer(i,1,jb) + &
	  maxstp*(    solad  (nLndPts,1)  * asurd(nLndPts,1,jb) + &
                      solad  (nLndPts,2)  * asurd(nLndPts,2,jb) + &
                      solai  (nLndPts,1)  * asuri(nLndPts,1,jb) + &
                      solai  (nLndPts,2)  * asuri(nLndPts,2,jb)   &
                 ) 
       ELSE
          Grd(19)%Buffer(i,1,jb) = undef
       END IF
    END DO

    Grd(20)%Units='m s-1'
    Grd(20)%Name=' wind velocity  '
    Grd(20)%NameG='speedw'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(20)%Buffer(i,1,jb) = Grd(20)%Buffer(i,1,jb) + maxstp*(SQRT((gu(i) /SIN(colrad(i)))**2  + (gv(i) /SIN(colrad(i)))**2)) 
       ELSE
          Grd(20)%Buffer(i,1,jb) = undef
       END IF
    END DO

    Grd(21)%Units='  K  '
    Grd(21)%Name=' Air Temperature   '
    Grd(21)%NameG='temp'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(21)%Buffer(i,1,jb) = Grd(21)%Buffer(i,1,jb) + maxstp*(gt(i)) 
       ELSE
          Grd(21)%Buffer(i,1,jb) = undef
       END IF
    END DO

    Grd(22)%Units='  kg/kg  '
    Grd(22)%Name=' Air specific humidity   '
    Grd(22)%NameG='umes '
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(22)%Buffer(i,1,jb) = Grd(22)%Buffer(i,1,jb) + maxstp*(gq(i)) 
       ELSE
          Grd(22)%Buffer(i,1,jb) = undef
       END IF
    END DO
!   IF(dodia(nDiag_biomau))THEN 
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!             nLndPts=nLndPts+1
!             diag(i) = totbiou (nLndPts,jb)
!	  END IF
!      END DO
!      CALL updia(diag,nDiag_biomau,jb)
!   ENDIF

    Grd(23)%Units=' (kg_C m-2) '
    Grd(23)%Name=' total biomass in the upper canopy   '
    Grd(23)%NameG='totbiou'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(23)%Buffer(i,1,jb) = Grd(23)%Buffer(i,1,jb) + maxstp*(totbiou (nLndPts,jb)) 
       ELSE
          Grd(23)%Buffer(i,1,jb) = undef
       END IF
    END DO
!   IF(dodia(nDiag_biomal))THEN 
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = totbiol (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_biomal,jb)
!   ENDIF

    Grd(24)%Units=' (kg_C m-2) '
    Grd(24)%Name=' total biomass in the lower canopy   '
    Grd(24)%NameG='totbiol'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(24)%Buffer(i,1,jb) = Grd(24)%Buffer(i,1,jb) + maxstp*(totbiol (nLndPts,jb)) 
       ELSE
          Grd(24)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   IF(dodia(nDiag_tlaiup))THEN 
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN
!             nLndPts=nLndPts+1
!            diag(i) = totlaiu(nLndPts,jb)
!	  END IF
!      END DO
!      CALL updia(diag,nDiag_tlaiup,jb)
!   ENDIF
    Grd(25)%Units=' # '
    Grd(25)%Name=' total leaf area index for the upper canopy   '
    Grd(25)%NameG='totlaiu'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(25)%Buffer(i,1,jb) = Grd(25)%Buffer(i,1,jb) + maxstp*(totlaiu(nLndPts,jb)) 
       ELSE
          Grd(25)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   IF(dodia(nDiag_tlailw))THEN 
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = totlail(nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_tlailw,jb)
!   ENDIF
    Grd(26)%Units=' # '
    Grd(26)%Name=' total leaf area index for the lower canopy   '
    Grd(26)%NameG='totlail'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(26)%Buffer(i,1,jb) = Grd(26)%Buffer(i,1,jb) + maxstp*(totlail(nLndPts,jb)) 
       ELSE
          Grd(26)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   IF(dodia(nDiag_tstnsp))THEN 
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = storedn(nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_tstnsp,jb)
!   ENDIF
!    
    Grd(27)%Units=' (kg_N m-2)  '
    Grd(27)%Name='  total storage of N in soil profile    '
    Grd(27)%NameG='storedn'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(27)%Buffer(i,1,jb) = Grd(27)%Buffer(i,1,jb) + maxstp*( storedn(nLndPts,jb)) 
       ELSE
          Grd(27)%Buffer(i,1,jb) = undef
       END IF
    END DO
   
!   
!   
!   IF(dodia(nDiag_somdfa))THEN 
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = decompl   (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_somdfa,jb)
!   ENDIF
    Grd(28)%Units='  #   '
    Grd(28)%Name='  litter decomposition factor '
    Grd(28)%NameG='decompl'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(28)%Buffer(i,1,jb) = Grd(28)%Buffer(i,1,jb) + maxstp*( decompl   (nLndPts,jb)) 
       ELSE
          Grd(28)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   IF(dodia(nDiag_lidecf))THEN 
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = decomps (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_lidecf,jb)
!   ENDIF
    Grd(29)%Units='  #   '
    Grd(29)%Name='  soil organic matter decomposition factor '
    Grd(29)%NameG='decomps'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(29)%Buffer(i,1,jb) = Grd(29)%Buffer(i,1,jb) + maxstp*( decomps (nLndPts,jb)) 
       ELSE
          Grd(29)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   IF(dodia(nDiag_wsttot))THEN 
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = wtot (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_wsttot,jb)
!   ENDIF

!   IF(dodia(nDiag_facuca))THEN 
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = fu (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_facuca,jb)
!   ENDIF
    Grd(30)%Units='  #   '
    Grd(30)%Name='   fraction of overall area covered by upper canopy '
    Grd(30)%NameG='fu '
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(30)%Buffer(i,1,jb) = Grd(30)%Buffer(i,1,jb) + maxstp*(fu (nLndPts,jb)) 
       ELSE
          Grd(30)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   IF(dodia(nDiag_fsfclc))THEN 
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = fl (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_fsfclc,jb)
!   ENDIF
    Grd(31)%Units='  #   '
    Grd(31)%Name='  fraction of snow-free area covered by lower  canopy '
    Grd(31)%NameG='fl '
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(31)%Buffer(i,1,jb) = Grd(31)%Buffer(i,1,jb) + maxstp*(fl (nLndPts,jb)) 
       ELSE
          Grd(31)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   IF(dodia(nDiag_frsnow))THEN !! fractional snow cover
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = fi (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_frsnow,jb)
!   ENDIF

!   IF(dodia(nDiag_insnpp))THEN ! instantaneous npp (mol-CO2 / m-2 / second)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = tnpptot (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_insnpp,jb)
!   ENDIF
    Grd(32)%Units='  (mol-CO2/m-2/s)   '
    Grd(32)%Name=' instantaneous npp  '
    Grd(32)%NameG='tnpptot '
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(32)%Buffer(i,1,jb) = Grd(32)%Buffer(i,1,jb) + maxstp*(tnpptot (nLndPts,jb)) 
       ELSE
          Grd(32)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   
!   IF(dodia(nDiag_insnee))THEN ! instantaneous net ecosystem exchange of co2 per timestep (kg_C m-2/timestep)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = tneetot (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_insnee,jb)
!   ENDIF
!   
    Grd(33)%Units='  (kg_C m-2/s)  '
    Grd(33)%Name=' instantaneous net ecosystem exchange of co2 per timestep  '
    Grd(33)%NameG='tneetot '
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(33)%Buffer(i,1,jb) = Grd(33)%Buffer(i,1,jb) + maxstp*(tneetot (nLndPts,jb)) 
       ELSE
          Grd(33)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   IF(dodia(nDiag_grbdy0))THEN ! annual total growing degree days for current year > 0C
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = gdd0this (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_grbdy0,jb)
!   ENDIF

!   IF(dodia(nDiag_grbdy5))THEN ! annual total growing degree days for current year > 5C  
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = gdd5this (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_grbdy5,jb)
!   ENDIF

!   IF(dodia(nDiag_avet2m))THEN ! monthly average 2-m surface-air temperature 
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = amts2 (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_avet2m,jb)
!   ENDIF

!   IF(dodia(nDiag_monnpp))THEN ! monthly total npp for ecosystem (kg-C/m**2/month)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = amnpptot (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_monnpp,jb)
!   ENDIF

!   IF(dodia(nDiag_monnee))THEN ! monthly total net ecosystem exchange of CO2 (kg-C/m**2/month)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = amneetot (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_monnee,jb)
!   ENDIF
!   
!   IF(dodia(nDiag_yeanpp))THEN ! annual total npp for ecosystem (kg-c/m**2/yr)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = aynpptot (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_yeanpp,jb)
!   ENDIF

!   IF(dodia(nDiag_yeanee))THEN ! annual total npp for ecosystem (kg-c/m**2/yr)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = ayneetot (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_yeanee,jb)
!   ENDIF

!  
!  
!  
!   IF(dodia(nDiag_upclai))THEN ! upper canopy single-sided leaf area index (area leaf/area veg)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = lai (nLndPts,2,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_upclai,jb)
!   ENDIF
    Grd(34)%Units='  #  '
    Grd(34)%Name=' upper canopy single-sided leaf area index 2 '
    Grd(34)%NameG='lai2 '
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(34)%Buffer(i,1,jb) = Grd(34)%Buffer(i,1,jb) + maxstp*( lai (nLndPts,2,jb)) 
       ELSE
          Grd(34)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   IF(dodia(nDiag_lwclai))THEN ! lower canopy single-sided leaf area index (area leaf/area veg)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = lai (nLndPts,1,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_lwclai,jb)
!   ENDIF
    Grd(35)%Units='  #  '
    Grd(35)%Name=' lower canopy single-sided leaf area index 1 '
    Grd(35)%NameG='lai1 '
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(35)%Buffer(i,1,jb) = Grd(35)%Buffer(i,1,jb) + maxstp*(lai (nLndPts,1,jb)) 
       ELSE
          Grd(35)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   IF(dodia(nDiag_biol01))THEN 
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = cbiol (nLndPts,1,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_biol01,jb)
!   ENDIF

!   IF(dodia(nDiag_biol02))THEN 
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = cbiol (nLndPts,2,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_biol02,jb)
!   ENDIF

!   IF(dodia(nDiag_biol03))THEN 
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = cbiol (nLndPts,3,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_biol03,jb)
!   ENDIF

!   IF(dodia(nDiag_biol04))THEN 
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = cbiol (nLndPts,4,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_biol04,jb)
!   ENDIF

!   IF(dodia(nDiag_biol05))THEN 
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = cbiol (nLndPts,5,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_biol05,jb)
!   ENDIF

!   IF(dodia(nDiag_biol06))THEN 
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = cbiol (nLndPts,6,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_biol06,jb)
!   ENDIF

!   IF(dodia(nDiag_biol07))THEN 
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = cbiol (nLndPts,7,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_biol07,jb)
!   ENDIF

!   IF(dodia(nDiag_biol08))THEN 
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = cbiol (nLndPts,8,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_biol08,jb)
!   ENDIF

!   IF(dodia(nDiag_biol09))THEN 
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = cbiol (nLndPts,9,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_biol09,jb)
!   ENDIF

!   IF(dodia(nDiag_biol10))THEN 
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = cbiol (nLndPts,10,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_biol10,jb)
!   ENDIF

!   IF(dodia(nDiag_biol11))THEN 
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = cbiol (nLndPts,11,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_biol11,jb)
!   ENDIF
!  
!  IF(dodia(nDiag_biol12))THEN 
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = cbiol (nLndPts,12,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_biol12,jb)
!   ENDIF


! !INTEGER, PUBLIC, PARAMETER :: nDiag_cmontp = 170 !coldest monthly temperature			     (C)
!  IF(dodia(nDiag_cmontp))THEN  !coldest monthly temperature			     (C)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = tc (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_cmontp,jb)
!   ENDIF

! !INTEGER, PUBLIC, PARAMETER :: nDiag_wmontp = 171 !warmest monthly temperature			     (C)
!  IF(dodia(nDiag_wmontp))THEN   !warmest monthly temperature			     (C)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = tw (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_wmontp,jb)
!   ENDIF

! !INTEGER, PUBLIC, PARAMETER :: nDiag_atogpp = 172 !annual total gpp for ecosystem			       (kg-c/m**2/yr)
!  IF(dodia(nDiag_atogpp))THEN  !annual total gpp for ecosystem			       (kg-c/m**2/yr)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = aygpptot (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_atogpp,jb)
!   ENDIF




! !INTEGER, PUBLIC, PARAMETER :: nDiag_tcthis = 201 !coldest monthly temperature of current year	      (C)
!  IF(dodia(nDiag_tcthis))THEN  !coldest monthly temperature of current year	      (C)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = tcthis (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_tcthis,jb)
!   ENDIF

! !INTEGER, PUBLIC, PARAMETER :: nDiag_twthis = 201 !warmest monthly temperature of current year	      (C)
!  IF(dodia(nDiag_twthis))THEN  !warmest monthly temperature of current year	      (C)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = twthis (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_twthis,jb)
!   ENDIF
    Grd(36)%Units=' (kg_P m-2)  '
    Grd(36)%Name='  total storage of P in soil profile    '
    Grd(36)%NameG='storedn_p'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(36)%Buffer(i,1,jb) = Grd(36)%Buffer(i,1,jb) + maxstp*( storedn_p(nLndPts,jb)) 
       ELSE
          Grd(36)%Buffer(i,1,jb) = undef
       END IF
    END DO
!         ynleach_p (1:nLndPts,jb) ,tnmin_p   (1:nLndPts,jb) ,totnmic_p (1:nLndPts,jb) ,totnlit_p (1:nLndPts,jb) ,&
!         totanlit_p(1:nLndPts,jb) ,totrnlit_p(1:nLndPts,jb),totnsoi_p (1:nLndPts,jb) ,storedn_p (1:nLndPts,jb) )

    Grd(37)%Units=' (kg_P m-2)  '
    Grd(37)%Name='  total phosphorus in soil    ' 
    Grd(37)%NameG='totnsoi_p'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(37)%Buffer(i,1,jb) = Grd(37)%Buffer(i,1,jb) + maxstp*( totnsoi_p(nLndPts,jb)) 
       ELSE
          Grd(37)%Buffer(i,1,jb) = undef
       END IF
    END DO
       
    Grd(38)%Units=' (kg_P m-2/timestep)  '
    Grd(38)%Name='  instantaneous phosphorus mineralization   ' 
    Grd(38)%NameG='tnmin_p'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(38)%Buffer(i,1,jb) = Grd(38)%Buffer(i,1,jb) + maxstp*( tnmin_p(nLndPts,jb)) 
       ELSE
          Grd(38)%Buffer(i,1,jb) = undef
       END IF
    END DO

    Grd(39)%Units=' (kg_P m-2)  '
    Grd(39)%Name='  total phosphorus residing in microbial pool   '   
    Grd(39)%NameG='totnmic_p'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(39)%Buffer(i,1,jb) = Grd(39)%Buffer(i,1,jb) + maxstp*( totnmic_p(nLndPts,jb)) 
       ELSE
          Grd(39)%Buffer(i,1,jb) = undef
       END IF
    END DO

    Grd(40)%Units=' (kg_P m-2)  '
    Grd(40)%Name='  total phosphorus in all litter pools     ' 
    Grd(40)%NameG='totnlit_p'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(40)%Buffer(i,1,jb) = Grd(40)%Buffer(i,1,jb) + maxstp*( totnlit_p(nLndPts,jb)) 
       ELSE
          Grd(40)%Buffer(i,1,jb) = undef
       END IF
    END DO

    Grd(41)%Units=' (kg_P m-2/yr)  '
    Grd(41)%Name='  annual total amount P leached from soil profile    '  
    Grd(41)%NameG='ynleach_p'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(41)%Buffer(i,1,jb) = Grd(41)%Buffer(i,1,jb) + maxstp*( ynleach_p(nLndPts,jb)) 
       ELSE
          Grd(41)%Buffer(i,1,jb) = undef
       END IF
    END DO

    Grd(42)%Units='%'
    Grd(42)%Name='  fraction of root in soil layer   1  '
    Grd(42)%NameG='froot1'
    DO k=1,Grd(1)%nSoil
       nLndPts=0
       DO i=1, nCols
          IF(iMask(i) >= 1)THEN 
             nLndPts=nLndPts+1
             Grd(42)%Buffer(i,Grd(1)%nSoil+1-k,jb) = Grd(42)%Buffer(i,Grd(1)%nSoil+1-k,jb) + maxstp*(froot (nLndPts,k,1,jb)) 
          ELSE
             Grd(42)%Buffer(i,Grd(1)%nSoil+1-k,jb) = undef
          END IF
       END DO
    END DO

    Grd(43)%Units='%'
    Grd(43)%Name='  fraction of root in soil layer   2  '
    Grd(43)%NameG='froot2'
    DO k=1,Grd(1)%nSoil
       nLndPts=0
       DO i=1, nCols
          IF(iMask(i) >= 1)THEN 
             nLndPts=nLndPts+1
             Grd(43)%Buffer(i,Grd(1)%nSoil+1-k,jb) = Grd(43)%Buffer(i,Grd(1)%nSoil+1-k,jb) + maxstp*(froot (nLndPts,k,2,jb)) 
          ELSE
             Grd(43)%Buffer(i,Grd(1)%nSoil+1-k,jb) = undef
          END IF
       END DO
    END DO


! !INTEGER, PUBLIC, PARAMETER :: nDiag_mcsoil = 175 !instantaneous microbial co2 flux from soil       (mol-CO2 / m-2 / second)
!  IF(dodia(nDiag_mcsoil))THEN  !instantaneous microbial co2 flux from soil       (mol-CO2 / m-2 / second)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = tco2mic (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_mcsoil,jb)
!   ENDIF

    Grd(44)%Units=' (mol-CO2 / m-2 / second)  '
    Grd(44)%Name=' instantaneous microbial co2 flux from soil    ' 
    Grd(44)%NameG='tco2mic'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(44)%Buffer(i,1,jb) = Grd(44)%Buffer(i,1,jb) + maxstp*( tco2mic (nLndPts,jb)) 
       ELSE
          Grd(44)%Buffer(i,1,jb) = undef
       END IF
    END DO
! !INTEGER, PUBLIC, PARAMETER :: nDiag_fxcsol = 174 !instantaneous fine co2 flux from soil       (mol-CO2 / m-2 / second)
!  IF(dodia(nDiag_fxcsol))THEN  !instantaneous fine co2 flux from soil		       (mol-CO2 / m-2 / second)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = tco2root(nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_fxcsol,jb)
!   ENDIF
    Grd(45)%Units=' (mol-CO2 / m-2 / second)  '
    Grd(45)%Name=' instantaneous fine co2 flux from soil   ' 
    Grd(45)%NameG='tco2root'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(45)%Buffer(i,1,jb) = Grd(45)%Buffer(i,1,jb) + maxstp*( tco2root(nLndPts,jb)) 
       ELSE
          Grd(45)%Buffer(i,1,jb) = undef
       END IF
    END DO
!   REAL(KIND=r8), INTENT(INOUT) :: tnmin     (npoi)! global! instantaneous nitrogen mineralization (kg_N m-2/timestep)

    Grd(46)%Units=' (kg_N m-2/timestep)  '
    Grd(46)%Name='  instantaneous nitrogen mineralization ' 
    Grd(46)%NameG='tnmin'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(46)%Buffer(i,1,jb) = Grd(46)%Buffer(i,1,jb) + maxstp*( tnmin(nLndPts,jb)) 
       ELSE
          Grd(46)%Buffer(i,1,jb) = undef
       END IF
    END DO    



! !INTEGER, PUBLIC, PARAMETER :: nDiag_cagcub = 176 !canopy average gross photosynthesis rate - broadleaf  (mol_co2 m-2 s-1)
!  IF(dodia(nDiag_cagcub))THEN !canopy average gross photosynthesis rate - broadleaf  (mol_co2 m-2 s-1)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = agcub (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_cagcub,jb)
!   ENDIF
    Grd(47)%Units=' (mol_co2 m-2 s-1)  '
    Grd(47)%Name=' canopy average gross photosynthesis rate - broadleaf  ' 
    Grd(47)%NameG='agcub'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(47)%Buffer(i,1,jb) = Grd(47)%Buffer(i,1,jb) + maxstp*( agcub (nLndPts,jb)) 
       ELSE
          Grd(47)%Buffer(i,1,jb) = undef
       END IF
    END DO    


! !INTEGER, PUBLIC, PARAMETER :: nDiag_cagcuc = 177 !canopy average gross photosynthesis rate - conifer    (mol_co2 m-2 s-1)
!  IF(dodia(nDiag_cagcuc))THEN  !canopy average gross photosynthesis rate - conifer    (mol_co2 m-2 s-1)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = agcuc (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_cagcuc,jb)
!   ENDIF
    Grd(48)%Units=' (mol_co2 m-2 s-1)  '
    Grd(48)%Name=' canopy average gross photosynthesis rate - conifer    ' 
    Grd(48)%NameG='agcuc'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(48)%Buffer(i,1,jb) = Grd(48)%Buffer(i,1,jb) + maxstp*( agcuc (nLndPts,jb)) 
       ELSE
          Grd(48)%Buffer(i,1,jb) = undef
       END IF
    END DO    

! !INTEGER, PUBLIC, PARAMETER :: nDiag_cagcls = 178 !canopy average gross photosynthesis rate - shrubs     (mol_co2 m-2 s-1)
!  IF(dodia(nDiag_cagcls))THEN  !canopy average gross photosynthesis rate - shrubs     (mol_co2 m-2 s-1)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = agcls (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_cagcls,jb)
!   ENDIF

    Grd(49)%Units=' (mol_co2 m-2 s-1)  '
    Grd(49)%Name=' canopy average gross photosynthesis rate - shrubs        ' 
    Grd(49)%NameG='agcls'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(49)%Buffer(i,1,jb) = Grd(49)%Buffer(i,1,jb) + maxstp*( agcls (nLndPts,jb)) 
       ELSE
          Grd(49)%Buffer(i,1,jb) = undef
       END IF
    END DO    

! !INTEGER, PUBLIC, PARAMETER :: nDiag_cagcl4 = 179 !canopy average gross photosynthesis rate - c4 grasses (mol_co2 m-2 s-1)
!  IF(dodia(nDiag_cagcl4))THEN  !canopy average gross photosynthesis rate - c4 grasses (mol_co2 m-2 s-1)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = agcl4 (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_cagcl4,jb)
!   ENDIF

    Grd(50)%Units=' (mol_co2 m-2 s-1) '
    Grd(50)%Name=' canopy average gross photosynthesis rate - c4 grasses     ' 
    Grd(50)%NameG='agcl4'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(50)%Buffer(i,1,jb) = Grd(50)%Buffer(i,1,jb) + maxstp*( agcl4 (nLndPts,jb)) 
       ELSE
          Grd(50)%Buffer(i,1,jb) = undef
       END IF
    END DO    

! !INTEGER, PUBLIC, PARAMETER :: nDiag_cagcl3 = 180 !canopy average gross photosynthesis rate - c3 grasses (mol_co2 m-2 s-1)
!  IF(dodia(nDiag_cagcl3))THEN  !canopy average gross photosynthesis rate - c3 grasses (mol_co2 m-2 s-1)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = agcl3 (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_cagcl3,jb)
!   ENDIF

    Grd(51)%Units=' (mol_co2 m-2 s-1) '
    Grd(51)%Name=' canopy average gross photosynthesis rate - c3 grasses     ' 
    Grd(51)%NameG='agcl3'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(51)%Buffer(i,1,jb) = Grd(51)%Buffer(i,1,jb) + maxstp*( agcl3 (nLndPts,jb)) 
       ELSE
          Grd(51)%Buffer(i,1,jb) = undef
       END IF
    END DO    

! !INTEGER, PUBLIC, PARAMETER :: nDiag_cancub = 181 !canopy average net photosynthesis rate - broadleaf    (mol_co2 m-2 s-1)
!  IF(dodia(nDiag_cancub))THEN  !canopy average net photosynthesis rate - broadleaf    (mol_co2 m-2 s-1)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = ancub (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_cancub,jb)
!   ENDIF
    Grd(52)%Units=' (mol_co2 m-2 s-1) '
    Grd(52)%Name=' canopy average net photosynthesis rate - broadleaf     ' 
    Grd(52)%NameG='ancub'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(52)%Buffer(i,1,jb) = Grd(52)%Buffer(i,1,jb) + maxstp*( ancub (nLndPts,jb)) 
       ELSE
          Grd(52)%Buffer(i,1,jb) = undef
       END IF
    END DO    

! !INTEGER, PUBLIC, PARAMETER :: nDiag_cancuc = 182 !canopy average net photosynthesis rate - conifer      (mol_co2 m-2 s-1)
!  IF(dodia(nDiag_cancuc))THEN  !canopy average net photosynthesis rate - conifer      (mol_co2 m-2 s-1)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = ancuc (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_cancuc,jb)
!   ENDIF
    Grd(53)%Units=' (mol_co2 m-2 s-1) '
    Grd(53)%Name=' canopy average net photosynthesis rate - conifer    ' 
    Grd(53)%NameG='ancuc'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(53)%Buffer(i,1,jb) = Grd(53)%Buffer(i,1,jb) + maxstp*( ancuc (nLndPts,jb)) 
       ELSE
          Grd(53)%Buffer(i,1,jb) = undef
       END IF
    END DO    

! !INTEGER, PUBLIC, PARAMETER :: nDiag_cancls = 183 !canopy average net photosynthesis rate - shrubs	    (mol_co2 m-2 s-1)
!  IF(dodia(nDiag_cancls))THEN  !canopy average net photosynthesis rate - shrubs	    (mol_co2 m-2 s-1)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = ancls (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_cancls,jb)
!   ENDIF
    Grd(54)%Units=' (mol_co2 m-2 s-1) '
    Grd(54)%Name=' canopy average net photosynthesis rate - shrubs    ' 
    Grd(54)%NameG='ancls'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(54)%Buffer(i,1,jb) = Grd(54)%Buffer(i,1,jb) + maxstp*( ancls (nLndPts,jb)) 
       ELSE
          Grd(54)%Buffer(i,1,jb) = undef
       END IF
    END DO    


! !INTEGER, PUBLIC, PARAMETER :: nDiag_cancl4 = 184 !canopy average net photosynthesis rate - c4 grasses   (mol_co2 m-2 s-1)
!  IF(dodia(nDiag_cancl4))THEN  !canopy average net photosynthesis rate - c4 grasses   (mol_co2 m-2 s-1)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = ancl4 (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_cancl4,jb)
!   ENDIF

!   ENDIF
    Grd(55)%Units=' (mol_co2 m-2 s-1) '
    Grd(55)%Name=' canopy average net photosynthesis rate - c4 grasses   ' 
    Grd(55)%NameG='ancl4'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(55)%Buffer(i,1,jb) = Grd(55)%Buffer(i,1,jb) + maxstp*( ancl4 (nLndPts,jb)) 
       ELSE
          Grd(55)%Buffer(i,1,jb) = undef
       END IF
    END DO    

! !INTEGER, PUBLIC, PARAMETER :: nDiag_cancl3 = 185 !canopy average net photosynthesis rate - c3 grasses   (mol_co2 m-2 s-1)
!  IF(dodia(nDiag_cancl3))THEN  !canopy average net photosynthesis rate - c3 grasses   (mol_co2 m-2 s-1)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = ancl3 (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_cancl3,jb)
!   ENDIF
    Grd(56)%Units=' (mol_co2 m-2 s-1) '
    Grd(56)%Name=' canopy average net photosynthesis rate - c3 grasses    ' 
    Grd(56)%NameG='ancl3'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(56)%Buffer(i,1,jb) = Grd(56)%Buffer(i,1,jb) + maxstp*( ancl3 (nLndPts,jb)) 
       ELSE
          Grd(56)%Buffer(i,1,jb) = undef
       END IF
    END DO    
! !INTEGER, PUBLIC, PARAMETER :: nDiag_gscouc = 191 !upper canopy stomatal conductance - conifer	    (mol_co2 m-2 s-1)
!  IF(dodia(nDiag_gscouc))THEN  !upper canopy stomatal conductance - conifer	    (mol_co2 m-2 s-1)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = gsuc (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_gscouc,jb)
!   ENDIF
    Grd(57)%Units=' (mol_co2 m-2 s-1) '
    Grd(57)%Name=' upper canopy stomatal conductance - conifer    ' 
    Grd(57)%NameG='gsuc'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(57)%Buffer(i,1,jb) = Grd(57)%Buffer(i,1,jb) + maxstp*( gsuc (nLndPts,jb)) 
       ELSE
          Grd(57)%Buffer(i,1,jb) = undef
       END IF
    END DO    

! !INTEGER, PUBLIC, PARAMETER :: nDiag_gscol3 = 198 !lower canopy stomatal conductance - c3 grasses	    (mol_co2 m-2 s-1)
!  IF(dodia(nDiag_gscol3))THEN  !lower canopy stomatal conductance - c3 grasses	    (mol_co2 m-2 s-1)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = gsl3 (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_gscol3,jb)
!   ENDIF
    Grd(58)%Units=' (mol_co2 m-2 s-1) '
    Grd(58)%Name=' lower canopy stomatal conductance - c3 grasses    ' 
    Grd(58)%NameG='gsl3'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(58)%Buffer(i,1,jb) = Grd(58)%Buffer(i,1,jb) + maxstp*( gsl3 (nLndPts,jb)) 
       ELSE
          Grd(58)%Buffer(i,1,jb) = undef
       END IF
    END DO    
! !INTEGER, PUBLIC, PARAMETER :: nDiag_gscol4 = 200 !lower canopy stomatal conductance - c4 grasses	    (mol_co2 m-2 s-1)
!  IF(dodia(nDiag_gscol4))THEN  ! lower canopy stomatal conductance - c4 grasses	    (mol_co2 m-2 s-1)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = gsl4 (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_gscol4,jb)
!   ENDIF
    Grd(59)%Units=' (mol_co2 m-2 s-1) '
    Grd(59)%Name=' lower canopy stomatal conductance - c4 grasses    ' 
    Grd(59)%NameG='gsl4'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(59)%Buffer(i,1,jb) = Grd(59)%Buffer(i,1,jb) + maxstp*( gsl4 (nLndPts,jb)) 
       ELSE
          Grd(59)%Buffer(i,1,jb) = undef
       END IF
    END DO    

! !INTEGER, PUBLIC, PARAMETER :: nDiag_gscoub = 189 !upper canopy stomatal conductance - broadleaf	    (mol_co2 m-2 s-1)
!  IF(dodia(nDiag_gscoub))THEN  !upper canopy stomatal conductance - broadleaf	    (mol_co2 m-2 s-1)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = gsub (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_gscoub,jb)
!   ENDIF
    Grd(60)%Units=' (mol_co2 m-2 s-1) '
    Grd(60)%Name=' upper canopy stomatal conductance - broadleaf    ' 
    Grd(60)%NameG='gsub'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(60)%Buffer(i,1,jb) = Grd(60)%Buffer(i,1,jb) + maxstp*( gsub (nLndPts,jb)) 
       ELSE
          Grd(60)%Buffer(i,1,jb) = undef
       END IF
    END DO    

! !INTEGER, PUBLIC, PARAMETER :: nDiag_gscols = 196 !lower canopy stomatal conductance - shrubs	    (mol_co2 m-2 s-1)
!  IF(dodia(nDiag_gscols))THEN  !lower canopy stomatal conductance - shrubs	    (mol_co2 m-2 s-1)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = gsls (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_gscols,jb)
!   ENDIF
    Grd(61)%Units=' (mol_co2 m-2 s-1) '
    Grd(61)%Name=' lower canopy stomatal conductance - shrubs    ' 
    Grd(61)%NameG='gsls'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(61)%Buffer(i,1,jb) = Grd(61)%Buffer(i,1,jb) + maxstp*( gsls (nLndPts,jb)) 
       ELSE
          Grd(61)%Buffer(i,1,jb) = undef
       END IF
    END DO    

! !INTEGER, PUBLIC, PARAMETER :: nDiag_cicoub = 186 !intercellular co2 concentration - broadleaf	    (mol_co2/mol_air)
!  IF(dodia(nDiag_cicoub))THEN  !intercellular co2 concentration - broadleaf	    (mol_co2/mol_air)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = ciub (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_cicoub,jb)
!   ENDIF
    Grd(62)%Units=' (mol_co2/mol_air) '
    Grd(62)%Name=' intercellular co2 concentration - broadleaf    ' 
    Grd(62)%NameG='ciub'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(62)%Buffer(i,1,jb) = Grd(62)%Buffer(i,1,jb) + maxstp*( ciub (nLndPts,jb)) 
       ELSE
          Grd(62)%Buffer(i,1,jb) = undef
       END IF
    END DO    


! !INTEGER, PUBLIC, PARAMETER :: nDiag_cicouc = 187 !intercellular co2 concentration - conifer 	    (mol_co2/mol_air)
!  IF(dodia(nDiag_cicouc))THEN  !intercellular co2 concentration - conifer 	    (mol_co2/mol_air)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = ciuc (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_cicouc,jb)
!   ENDIF

    Grd(63)%Units=' (mol_co2/mol_air) '
    Grd(63)%Name=' intercellular co2 concentration - conifer     ' 
    Grd(63)%NameG='ciuc'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(63)%Buffer(i,1,jb) = Grd(63)%Buffer(i,1,jb) + maxstp*( ciuc (nLndPts,jb)) 
       ELSE
          Grd(63)%Buffer(i,1,jb) = undef
       END IF
    END DO    

! !INTEGER, PUBLIC, PARAMETER :: nDiag_cscoub = 188 !leaf boundary layer co2 concentration - broadleaf     (mol_co2/mol_air)
!  IF(dodia(nDiag_cscoub))THEN  ! !leaf boundary layer co2 concentration - broadleaf     (mol_co2/mol_air)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = csub (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_cscoub,jb)
!   ENDIF

    Grd(64)%Units=' (mol_co2/mol_air) '
    Grd(64)%Name=' leaf boundary layer co2 concentration - broadleaf      ' 
    Grd(64)%NameG='csub'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(64)%Buffer(i,1,jb) = Grd(64)%Buffer(i,1,jb) + maxstp*( csub (nLndPts,jb)) 
       ELSE
          Grd(64)%Buffer(i,1,jb) = undef
       END IF
    END DO    


! !INTEGER, PUBLIC, PARAMETER :: nDiag_cscouc = 190 !leaf boundary layer co2 concentration - conifer	    (mol_co2/mol_air)
!  IF(dodia(nDiag_cscouc))THEN   !leaf boundary layer co2 concentration - conifer	    (mol_co2/mol_air)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = csuc (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_cscouc,jb)
!   ENDIF

    Grd(65)%Units=' (mol_co2/mol_air) '
    Grd(65)%Name=' leaf boundary layer co2 concentration - conifer      ' 
    Grd(65)%NameG='csuc'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(65)%Buffer(i,1,jb) = Grd(65)%Buffer(i,1,jb) + maxstp*( csuc (nLndPts,jb)) 
       ELSE
          Grd(65)%Buffer(i,1,jb) = undef
       END IF
    END DO    
!   REAL(KIND=r8), INTENT(INOUT) :: su       (npoi)   ! local ! air-vegetation transfer coefficients (*rhoa) for
                                                             ! upper canopy leaves (m s-1 * kg m-3) (A39a Pollard & Thompson 1995)
    Grd(66)%Units=' (m s-1 * kg m-3) '
    Grd(66)%Name=' air-vegetation transfer coefficients (*rhoa) for upper canopy leaves     ' 
    Grd(66)%NameG='su'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(66)%Buffer(i,1,jb) = Grd(66)%Buffer(i,1,jb) + maxstp*( su (nLndPts,jb)) 
       ELSE
          Grd(66)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   REAL(KIND=r8), INTENT(INOUT) :: stresstl(npoi)        ! local ! sum of stressl over all 6 soil layers (dimensionless)
    Grd(67)%Units=' dimensionless '
    Grd(67)%Name=' sum of stressl over all 6 soil layers     ' 
    Grd(67)%NameG='stresstl'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(67)%Buffer(i,1,jb) = Grd(67)%Buffer(i,1,jb) + maxstp*( stresstl (nLndPts,jb)) 
       ELSE
          Grd(67)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   REAL(KIND=r8), INTENT(INOUT) :: stresstu(npoi)        ! local ! sum of stressu over all 6 soil layers (dimensionless)
    Grd(68)%Units=' dimensionless '
    Grd(68)%Name=' sum of stressu over all 6 soil layers     ' 
    Grd(68)%NameG='stresstu'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(68)%Buffer(i,1,jb) = Grd(68)%Buffer(i,1,jb) + maxstp*( stresstl (nLndPts,jb)) 
       ELSE
          Grd(68)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   REAL(KIND=r8), INTENT(INOUT) :: stressl (npoi,nsoilay)! local ! soil moisture stress factor for the lower canopy (dimensionless)


    Grd(69)%Units='dimensionless'
    Grd(69)%Name='  soil moisture stress factor for the lower canopy   '
    Grd(69)%NameG='stressl'
    DO k=1,Grd(1)%nSoil
       nLndPts=0
       DO i=1, nCols
          IF(iMask(i) >= 1)THEN 
             nLndPts=nLndPts+1
             Grd(69)%Buffer(i,Grd(1)%nSoil+1-k,jb) = Grd(69)%Buffer(i,Grd(1)%nSoil+1-k,jb) + maxstp*(stressl (nLndPts,k,jb)) 
          ELSE
             Grd(69)%Buffer(i,Grd(1)%nSoil+1-k,jb) = undef
          END IF
       END DO
    END DO

!   REAL(KIND=r8), INTENT(INOUT) :: stressu (npoi,nsoilay)! local ! soil moisture stress factor for the upper canopy (dimensionless)


    Grd(70)%Units='dimensionless'
    Grd(70)%Name='  soil moisture stress factor for the upper canopy   '
    Grd(70)%NameG='stressu'
    DO k=1,Grd(1)%nSoil
       nLndPts=0
       DO i=1, nCols
          IF(iMask(i) >= 1)THEN 
             nLndPts=nLndPts+1
             Grd(70)%Buffer(i,Grd(1)%nSoil+1-k,jb) = Grd(70)%Buffer(i,Grd(1)%nSoil+1-k,jb) + maxstp*(stressu (nLndPts,k,jb)) 
          ELSE
             Grd(70)%Buffer(i,Grd(1)%nSoil+1-k,jb) = undef
          END IF
       END DO
    END DO
!   REAL(KIND=r8), INTENT(IN   ) :: sfield  (npoi,nsoilay)! global ! field capacity soil moisture value (fraction of pore space)

    Grd(71)%Units='fraction of pore space'
    Grd(71)%Name='  field capacity soil moisture value  '
    Grd(71)%NameG='sfield'
    DO k=1,Grd(1)%nSoil
       nLndPts=0
       DO i=1, nCols
          IF(iMask(i) >= 1)THEN 
             nLndPts=nLndPts+1
             Grd(71)%Buffer(i,Grd(1)%nSoil+1-k,jb) = Grd(71)%Buffer(i,Grd(1)%nSoil+1-k,jb) + maxstp*(sfield (nLndPts,k,jb)) 
          ELSE
             Grd(71)%Buffer(i,Grd(1)%nSoil+1-k,jb) = undef
          END IF
       END DO
    END DO

!   REAL(KIND=r8), INTENT(IN   ) :: swilt   (npoi,nsoilay)! global ! wilting soil moisture value (fraction of pore space)
    Grd(72)%Units='fraction of pore space'
    Grd(72)%Name=' wilting soil moisture value '
    Grd(72)%NameG='swilt'
    DO k=1,Grd(1)%nSoil
       nLndPts=0
       DO i=1, nCols
          IF(iMask(i) >= 1)THEN 
             nLndPts=nLndPts+1
             Grd(72)%Buffer(i,Grd(1)%nSoil+1-k,jb) = Grd(72)%Buffer(i,Grd(1)%nSoil+1-k,jb) + maxstp*(swilt (nLndPts,k,jb)) 
          ELSE
             Grd(72)%Buffer(i,Grd(1)%nSoil+1-k,jb) = undef
          END IF
       END DO
    END DO

!   REAL(KIND=r8), INTENT(INOUT) :: topparu  (npoi)  !local  ! total photosynthetically active raditaion absorbed 
                                                            ! by top leaves of upper canopy (W m-2)
    Grd(73)%Units=' (W m-2) '
    Grd(73)%Name=' total photosynthetically active raditaion absorbed by top leaves of upper canopy     ' 
    Grd(73)%NameG='topparu'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(73)%Buffer(i,1,jb) = Grd(73)%Buffer(i,1,jb) + maxstp*( topparu (nLndPts,jb)) 
       ELSE
          Grd(73)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!   REAL(KIND=r8), INTENT(INOUT) :: topparl  (npoi)  !local  ! total photosynthetically active raditaion absorbed
                                                            ! by top leaves of lower canopy (W m-2)
    Grd(74)%Units=' (W m-2) '
    Grd(74)%Name='total photosynthetically active raditaion absorbed by top leaves of lower canopy    ' 
    Grd(74)%NameG='topparl'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(74)%Buffer(i,1,jb) = Grd(74)%Buffer(i,1,jb) + maxstp*( topparl (nLndPts,jb)) 
       ELSE
          Grd(74)%Buffer(i,1,jb) = undef
       END IF
    END DO    


! !INTEGER, PUBLIC, PARAMETER :: nDiag_cicols = 192 !intercellular co2 concentration - shrubs  	    (mol_co2/mol_air)
!  IF(dodia(nDiag_cicols))THEN  !intercellular co2 concentration - shrubs  	    (mol_co2/mol_air)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = cils (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_cicols,jb)
!   ENDIF
    Grd(75)%Units='  (mol_co2/mol_air) '
    Grd(75)%Name='intercellular co2 concentration - shrubs   ' 
    Grd(75)%NameG='cils'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(75)%Buffer(i,1,jb) = Grd(75)%Buffer(i,1,jb) + maxstp*( cils (nLndPts,jb)) 
       ELSE
          Grd(75)%Buffer(i,1,jb) = undef
       END IF
    END DO    

! !INTEGER, PUBLIC, PARAMETER :: nDiag_cicol3 = 193 !intercellular co2 concentration - c3 plants	    (mol_co2/mol_air)
!  IF(dodia(nDiag_cicol3))THEN  !intercellular co2 concentration - c3 plants	    (mol_co2/mol_air)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = cil3 (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_cicol3,jb)
!   ENDIF
    Grd(76)%Units='  (mol_co2/mol_air) '
    Grd(76)%Name='intercellular co2 concentration - c3 plants   ' 
    Grd(76)%NameG='cil3'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(76)%Buffer(i,1,jb) = Grd(76)%Buffer(i,1,jb) + maxstp*( cil3 (nLndPts,jb)) 
       ELSE
          Grd(76)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!
! !INTEGER, PUBLIC, PARAMETER :: nDiag_cicol4 = 194 !intercellular co2 concentration - c4 plants	    (mol_co2/mol_air)
!  IF(dodia(nDiag_cicol4))THEN  !intercellular co2 concentration - c4 plants	    (mol_co2/mol_air)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = cil4 (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_cicol4,jb)
!   ENDIF
    Grd(77)%Units='  (mol_co2/mol_air) '
    Grd(77)%Name='intercellular co2 concentration - c4 plants   ' 
    Grd(77)%NameG='cil4'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(77)%Buffer(i,1,jb) = Grd(77)%Buffer(i,1,jb) + maxstp*( cil4 (nLndPts,jb)) 
       ELSE
          Grd(77)%Buffer(i,1,jb) = undef
       END IF
    END DO    

! !INTEGER, PUBLIC, PARAMETER :: nDiag_cscols = 195 !leaf boundary layer co2 concentration - shrubs	    (mol_co2/mol_air)
!  IF(dodia(nDiag_cscols))THEN  !leaf boundary layer co2 concentration - shrubs	    (mol_co2/mol_air)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = csls (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_cscols,jb)
!   ENDIF
    Grd(78)%Units='  (mol_co2/mol_air) '
    Grd(78)%Name='leaf boundary layer co2 concentration - shrubs   ' 
    Grd(78)%NameG='csls'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(78)%Buffer(i,1,jb) = Grd(78)%Buffer(i,1,jb) + maxstp*( csls (nLndPts,jb)) 
       ELSE
          Grd(78)%Buffer(i,1,jb) = undef
       END IF
    END DO    


! !INTEGER, PUBLIC, PARAMETER :: nDiag_cscol3 = 197 !leaf boundary layer co2 concentration - c3 plants     (mol_co2/mol_air)
!  IF(dodia(nDiag_cscol3))THEN  !leaf boundary layer co2 concentration - c3 plants     (mol_co2/mol_air)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = csl3 (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_cscol3,jb)
!   ENDIF

    Grd(79)%Units='  (mol_co2/mol_air) '
    Grd(79)%Name='leaf boundary layer co2 concentration - c3 plants ' 
    Grd(79)%NameG='csl3'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(79)%Buffer(i,1,jb) = Grd(79)%Buffer(i,1,jb) + maxstp*( csl3 (nLndPts,jb)) 
       ELSE
          Grd(79)%Buffer(i,1,jb) = undef
       END IF
    END DO    

! !INTEGER, PUBLIC, PARAMETER :: nDiag_cscol4 = 199 !leaf boundary layer co2 concentration - c4 plants     (mol_co2/mol_air)
!  IF(dodia(nDiag_cscol4))THEN  !leaf boundary layer co2 concentration - c4 plants     (mol_co2/mol_air)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = csl4 (nLndPts,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_cscol4,jb)
!   ENDIF

    Grd(80)%Units='  (mol_co2/mol_air) '
    Grd(80)%Name='leaf boundary layer co2 concentration - c4 plants  ' 
    Grd(80)%NameG='csl4'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(80)%Buffer(i,1,jb) = Grd(80)%Buffer(i,1,jb) + maxstp*( csl4 (nLndPts,jb)) 
       ELSE
          Grd(80)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   REAL(KIND=r8), INTENT(INOUT) :: ztop     (1:nLndPts,1:2,jb) ! global  ! height of plant top above ground (m)
    Grd(81)%Units='  (m) '
    Grd(81)%Name='height of plant top above ground 1' 
    Grd(81)%NameG='ztop1'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(81)%Buffer(i,1,jb) = Grd(81)%Buffer(i,1,jb) + maxstp*( ztop (nLndPts,1,jb)) 
       ELSE
          Grd(81)%Buffer(i,1,jb) = undef
       END IF
    END DO    

    Grd(82)%Units='  (m) '
    Grd(82)%Name='height of plant top above ground 2' 
    Grd(82)%NameG='ztop2'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(82)%Buffer(i,1,jb) = Grd(82)%Buffer(i,1,jb) + maxstp*( ztop (nLndPts,2,jb)) 
       ELSE
          Grd(82)%Buffer(i,1,jb) = undef
       END IF
    END DO    
!   REAL(KIND=r8), INTENT(INOUT) :: zbot    (1:nLndPts,1:2,jb)  ! global  ! height of lowest branches above ground (m)
    Grd(83)%Units='  (m) '
    Grd(83)%Name='height of lowest branches above ground 1' 
    Grd(83)%NameG='zbot1'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(83)%Buffer(i,1,jb) = Grd(83)%Buffer(i,1,jb) + maxstp*( zbot (nLndPts,1,jb)) 
       ELSE
          Grd(83)%Buffer(i,1,jb) = undef
       END IF
    END DO    

    Grd(84)%Units='  (m) '
    Grd(84)%Name='height of lowest branches above ground 2' 
    Grd(84)%NameG='zbot2'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(84)%Buffer(i,1,jb) = Grd(84)%Buffer(i,1,jb) + maxstp*( zbot (nLndPts,2,jb)) 
       ELSE
          Grd(84)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   REAL(KIND=r8), INTENT(INOUT) :: agddu   (npoi)          ! global  ! annual accumulated growing degree days for bud
   				                                     ! burst, upper canopy (day-degrees)
    Grd(85)%Units='  (day-degrees) '
    Grd(85)%Name='annual accumulated growing degree days for bud burst, upper canopy ' 
    Grd(85)%NameG='agddu'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(85)%Buffer(i,1,jb) = Grd(85)%Buffer(i,1,jb) + maxstp*( agddu (nLndPts,jb)) 
       ELSE
          Grd(85)%Buffer(i,1,jb) = undef
       END IF
    END DO    
!   REAL(KIND=r8), INTENT(INOUT) :: agddl   (npoi)          ! global  ! annual accumulated growing degree days for bud burst,
   				                                     ! lower canopy (day-degrees)

    Grd(86)%Units='  (day-degrees) '
    Grd(86)%Name='annual accumulated growing degree days for bud burst, lower canopy ' 
    Grd(86)%NameG='agddl'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(86)%Buffer(i,1,jb) = Grd(86)%Buffer(i,1,jb) + maxstp*( agddl (nLndPts,jb)) 
       ELSE
          Grd(86)%Buffer(i,1,jb) = undef
       END IF
    END DO    
!      REAL(KIND=r8), INTENT(IN   ) :: td     (1:nLndPts,jb)  ! daily average temperature (K)
    Grd(87)%Units='  (K) '
    Grd(87)%Name=' daily average temperature  ' 
    Grd(87)%NameG='td'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(87)%Buffer(i,1,jb) = Grd(87)%Buffer(i,1,jb) + maxstp*( td (nLndPts,jb)) 
       ELSE
          Grd(87)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!      REAL(KIND=r8), INTENT(IN   ) :: a10td    (1:nLndPts,jb)  ! 10-day average daily air temperature (K)
    Grd(88)%Units='  (K) '
    Grd(88)%Name=' 10-day average daily air temperature   ' 
    Grd(88)%NameG='a10td'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(88)%Buffer(i,1,jb) = Grd(88)%Buffer(i,1,jb) + maxstp*( a10td (nLndPts,jb)) 
       ELSE
          Grd(88)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!      REAL(KIND=r8), INTENT(INOUT) :: tempu    (npoi)	  ! cold-phenology trigger for trees (non-dimensional)
    Grd(89)%Units='  (non-dimensional) '
    Grd(89)%Name=' cold-phenology trigger for trees   ' 
    Grd(89)%NameG='tempu'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(89)%Buffer(i,1,jb) = Grd(89)%Buffer(i,1,jb) + maxstp*( tempu (nLndPts,jb)) 
       ELSE
          Grd(89)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!      REAL(KIND=r8), INTENT(INOUT) :: templ    (npoi)	  ! cold-phenology trigger for grasses/shrubs (non-dimensional)

    Grd(90)%Units='  (non-dimensional) '
    Grd(90)%Name=' cold-phenology trigger for grasses/shrubs   ' 
    Grd(90)%NameG='templ'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(90)%Buffer(i,1,jb) = Grd(90)%Buffer(i,1,jb) + maxstp*( templ (nLndPts,jb)) 
       ELSE
          Grd(90)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   REAL(KIND=r8), INTENT(INOUT) :: dropu   (npoi)          ! global  ! drought-phenology trigger for trees (non-dimensional)
    Grd(91)%Units='  (non-dimensional) '
    Grd(91)%Name=' drought-phenology trigger for trees   ' 
    Grd(91)%NameG='dropu'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(91)%Buffer(i,1,jb) = Grd(91)%Buffer(i,1,jb) + maxstp*( dropu (nLndPts,jb)) 
       ELSE
          Grd(91)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   REAL(KIND=r8), INTENT(INOUT) :: dropls  (npoi)          ! global  ! drought-phenology trigger for shrubs (non-dimensional)
    Grd(92)%Units='  (non-dimensional) '
    Grd(92)%Name=' drought-phenology trigger for shrubs   ' 
    Grd(92)%NameG='dropls'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(92)%Buffer(i,1,jb) = Grd(92)%Buffer(i,1,jb) + maxstp*( dropls (nLndPts,jb)) 
       ELSE
          Grd(92)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   REAL(KIND=r8), INTENT(INOUT) :: dropl4  (npoi)          ! global  ! drought-phenology trigger for c4 grasses (non-dimensional)
    Grd(93)%Units='  (non-dimensional) '
    Grd(93)%Name=' drought-phenology trigger for c4 grasses    ' 
    Grd(93)%NameG='dropl4'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(93)%Buffer(i,1,jb) = Grd(93)%Buffer(i,1,jb) + maxstp*( dropl4 (nLndPts,jb)) 
       ELSE
          Grd(93)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   REAL(KIND=r8), INTENT(INOUT) :: dropl3  (npoi)          ! global  ! drought-phenology trigger for c3 grasses (non-dimensional)
    Grd(94)%Units='  (non-dimensional) '
    Grd(94)%Name=' drought-phenology trigger for c4 grasses    ' 
    Grd(94)%NameG='dropl3'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(94)%Buffer(i,1,jb) = Grd(94)%Buffer(i,1,jb) + maxstp*( dropl3 (nLndPts,jb)) 
       ELSE
          Grd(94)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   REAL(KIND=r8), INTENT(INOUT) :: a10ancub (npoi)       ! global! 10-day average canopy photosynthesis rate - broadleaf  (mol_co2 m-2 s-1)
    Grd(95)%Units='  (mol_co2 m-2 s-1)'
    Grd(95)%Name=' 10-day average canopy photosynthesis rate - broadleaf    ' 
    Grd(95)%NameG='a10ancub'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(95)%Buffer(i,1,jb) = Grd(95)%Buffer(i,1,jb) + maxstp*( a10ancub (nLndPts,jb)) 
       ELSE
          Grd(95)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   REAL(KIND=r8), INTENT(INOUT) :: a10ancuc (npoi)       ! global! 10-day average canopy photosynthesis rate - conifer    (mol_co2 m-2 s-1)
    Grd(96)%Units='  (mol_co2 m-2 s-1)'
    Grd(96)%Name=' 10-day average canopy photosynthesis rate - conifer   ' 
    Grd(96)%NameG='a10ancuc'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(96)%Buffer(i,1,jb) = Grd(96)%Buffer(i,1,jb) + maxstp*( a10ancuc (nLndPts,jb)) 
       ELSE
          Grd(96)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   REAL(KIND=r8), INTENT(INOUT) :: a10ancls (npoi)       ! global! 10-day average canopy photosynthesis rate - shrubs     (mol_co2 m-2 s-1)
    Grd(97)%Units='  (mol_co2 m-2 s-1)'
    Grd(97)%Name=' 10-day average canopy photosynthesis rate - shrubs   ' 
    Grd(97)%NameG='a10ancls'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(97)%Buffer(i,1,jb) = Grd(97)%Buffer(i,1,jb) + maxstp*( a10ancls (nLndPts,jb)) 
       ELSE
          Grd(97)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   REAL(KIND=r8), INTENT(INOUT) :: a10ancl3 (npoi)       ! global! 10-day average canopy photosynthesis rate - c3 grasses (mol_co2 m-2 s-1)
    Grd(98)%Units='  (mol_co2 m-2 s-1)'
    Grd(98)%Name=' 10-day average canopy photosynthesis rate - c3 grasses   ' 
    Grd(98)%NameG='a10ancl3'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(98)%Buffer(i,1,jb) = Grd(98)%Buffer(i,1,jb) + maxstp*( a10ancl3 (nLndPts,jb)) 
       ELSE
          Grd(98)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   REAL(KIND=r8), INTENT(INOUT) :: a10ancl4 (npoi)       ! global! 10-day average canopy photosynthesis rate - c4 grasses (mol_co2 m-2 s-1)
    Grd(99)%Units='  (mol_co2 m-2 s-1)'
    Grd(99)%Name=' 10-day average canopy photosynthesis rate - c3 grasses   ' 
    Grd(99)%NameG='a10ancl3'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(99)%Buffer(i,1,jb) = Grd(99)%Buffer(i,1,jb) + maxstp*( a10ancl3 (nLndPts,jb)) 
       ELSE
          Grd(99)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!   IF(dodia(nDiag_pfts01))THEN  ! pft tropical broadleaf evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = plai (nLndPts,1,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts01,jb)
!   ENDIF
    Grd(100)%Units='  # lai'
    Grd(100)%Name=' pft tropical broadleaf evergreen trees   ' 
    Grd(100)%NameG='plai1'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(100)%Buffer(i,1,jb) = Grd(100)%Buffer(i,1,jb) + maxstp*( plai (nLndPts,1,jb)) 
       ELSE
          Grd(100)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts02))THEN  ! pft tropical broadleaf drought-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = plai (nLndPts,2,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts02,jb)
!   ENDIF
    Grd(101)%Units='  # lai'
    Grd(101)%Name=' pft tropical broadleaf drought-deciduous trees   ' 
    Grd(101)%NameG='plai2'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(101)%Buffer(i,1,jb) = Grd(101)%Buffer(i,1,jb) + maxstp*( plai (nLndPts,2,jb)) 
       ELSE
          Grd(101)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts03))THEN  ! pft warm-temperate broadleaf evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = plai (nLndPts,3,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts03,jb)
!   ENDIF
    Grd(102)%Units='  # lai'
    Grd(102)%Name=' pft warm-temperate broadleaf evergreen trees  ' 
    Grd(102)%NameG='plai3'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(102)%Buffer(i,1,jb) = Grd(102)%Buffer(i,1,jb) + maxstp*( plai (nLndPts,3,jb)) 
       ELSE
          Grd(102)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!   IF(dodia(nDiag_pfts04))THEN  ! pft temperate conifer evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = plai (nLndPts,4,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts04,jb)
!   ENDIF
    Grd(103)%Units='  # lai'
    Grd(103)%Name=' pft temperate conifer evergreen trees  ' 
    Grd(103)%NameG='plai4'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(103)%Buffer(i,1,jb) = Grd(103)%Buffer(i,1,jb) + maxstp*( plai (nLndPts,4,jb)) 
       ELSE
          Grd(103)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!   IF(dodia(nDiag_pfts05))THEN  ! pft temperate broadleaf cold-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = plai (nLndPts,5,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts05,jb)
!   ENDIF
    Grd(104)%Units='  # lai'
    Grd(104)%Name=' pft temperate broadleaf cold-deciduous trees  ' 
    Grd(104)%NameG='plai5'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(104)%Buffer(i,1,jb) = Grd(104)%Buffer(i,1,jb) + maxstp*( plai (nLndPts,5,jb)) 
       ELSE
          Grd(104)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!   IF(dodia(nDiag_pfts06))THEN  ! pft boreal conifer evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = plai (nLndPts,6,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts06,jb)
!   ENDIF
    Grd(105)%Units='  # lai'
    Grd(105)%Name='  pft boreal conifer evergreen trees  ' 
    Grd(105)%NameG='plai6'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(105)%Buffer(i,1,jb) = Grd(105)%Buffer(i,1,jb) + maxstp*( plai (nLndPts,6,jb)) 
       ELSE
          Grd(105)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts07))THEN  ! pft boreal broadleaf cold-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = plai (nLndPts,7,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts07,jb)
!   ENDIF
    Grd(106)%Units='  # lai'
    Grd(106)%Name='  pft boreal broadleaf cold-deciduous trees  ' 
    Grd(106)%NameG='plai7'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(106)%Buffer(i,1,jb) = Grd(106)%Buffer(i,1,jb) + maxstp*( plai (nLndPts,7,jb)) 
       ELSE
          Grd(106)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts08))THEN  ! pft boreal conifer cold-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = plai (nLndPts,8,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts08,jb)
!   ENDIF
    Grd(107)%Units='  # lai'
    Grd(107)%Name='  pft boreal conifer cold-deciduous trees ' 
    Grd(107)%NameG='plai8'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(107)%Buffer(i,1,jb) = Grd(107)%Buffer(i,1,jb) + maxstp*( plai (nLndPts,8,jb)) 
       ELSE
          Grd(107)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts09))THEN  ! pft evergreen shrubs
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = plai (nLndPts,9,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts09,jb)
!   ENDIF
    Grd(108)%Units='  # lai'
    Grd(108)%Name='   pft evergreen shrubs ' 
    Grd(108)%NameG='plai9'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(108)%Buffer(i,1,jb) = Grd(108)%Buffer(i,1,jb) + maxstp*( plai (nLndPts,9,jb)) 
       ELSE
          Grd(108)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts10))THEN  ! pft cold-deciduous shrubs
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = plai (nLndPts,10,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts10,jb)
!   ENDIF
    Grd(109)%Units='  # lai'
    Grd(109)%Name='   pft cold-deciduous shrubs ' 
    Grd(109)%NameG='plai10'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(109)%Buffer(i,1,jb) = Grd(109)%Buffer(i,1,jb) + maxstp*( plai (nLndPts,10,jb)) 
       ELSE
          Grd(109)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts11))THEN  ! pft cool (c4) grasses   
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = plai (nLndPts,11,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts11,jb)
!   ENDIF
    Grd(110)%Units='  # lai'
    Grd(110)%Name='   pft cool (c4) grasses ' 
    Grd(110)%NameG='plai11'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(110)%Buffer(i,1,jb) = Grd(110)%Buffer(i,1,jb) + maxstp*( plai (nLndPts,11,jb)) 
       ELSE
          Grd(110)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!  
!   IF(dodia(nDiag_pfts12))THEN   ! pft cool (c3) grasses   
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = plai (nLndPts,12,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts12,jb)
!   ENDIF
    Grd(111)%Units='  # lai'
    Grd(111)%Name='   pft cool (c3) grasses    ' 
    Grd(111)%NameG='plai12'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(111)%Buffer(i,1,jb) = Grd(111)%Buffer(i,1,jb) + maxstp*( plai (nLndPts,12,jb)) 
       ELSE
          Grd(111)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   REAL(KIND=r8), INTENT(OUT  ) :: biomass(1:nLndPts,1:nbiomass,jb) ! total biomass of each plant functional type  (kg_C m-2)


!   IF(dodia(nDiag_pfts01))THEN  ! biomass tropical broadleaf evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = biomass (nLndPts,1,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_biomasss01,jb)
!   ENDIF
    Grd(112)%Units='  (kg_C m-2)'
    Grd(112)%Name='  total biomass of each plant functional type tropical broadleaf evergreen trees   ' 
    Grd(112)%NameG='biomass1'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(112)%Buffer(i,1,jb) = Grd(112)%Buffer(i,1,jb) + maxstp*( biomass (nLndPts,1,jb)) 
       ELSE
          Grd(112)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_biomasss02))THEN  ! biomass tropical broadleaf drought-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = biomass (nLndPts,2,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_biomasss02,jb)
!   ENDIF
    Grd(113)%Units='  (kg_C m-2)'
    Grd(113)%Name='  total biomass of each plant functional type tropical broadleaf drought-deciduous trees   ' 
    Grd(113)%NameG='biomass2'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(113)%Buffer(i,1,jb) = Grd(113)%Buffer(i,1,jb) + maxstp*( biomass (nLndPts,2,jb)) 
       ELSE
          Grd(113)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_biomasss03))THEN  ! biomass warm-temperate broadleaf evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = biomass (nLndPts,3,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_biomasss03,jb)
!   ENDIF
    Grd(114)%Units='  # lai'
    Grd(114)%Name='  total biomass of each plant functional type warm-temperate broadleaf evergreen trees  ' 
    Grd(114)%NameG='biomass3'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(114)%Buffer(i,1,jb) = Grd(114)%Buffer(i,1,jb) + maxstp*( biomass (nLndPts,3,jb)) 
       ELSE
          Grd(114)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!   IF(dodia(nDiag_biomasss04))THEN  ! biomass temperate conifer evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = biomass (nLndPts,4,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_biomasss04,jb)
!   ENDIF
    Grd(115)%Units='  (kg_C m-2)'
    Grd(115)%Name='  total biomass of each plant functional type temperate conifer evergreen trees  ' 
    Grd(115)%NameG='biomass4'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(115)%Buffer(i,1,jb) = Grd(115)%Buffer(i,1,jb) + maxstp*( biomass (nLndPts,4,jb)) 
       ELSE
          Grd(115)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!   IF(dodia(nDiag_biomasss05))THEN  ! biomass temperate broadleaf cold-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = biomass (nLndPts,5,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_biomasss05,jb)
!   ENDIF
    Grd(116)%Units='  (kg_C m-2)'
    Grd(116)%Name='  total biomass of each plant functional type temperate broadleaf cold-deciduous trees  ' 
    Grd(116)%NameG='biomass5'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(116)%Buffer(i,1,jb) = Grd(116)%Buffer(i,1,jb) + maxstp*( biomass (nLndPts,5,jb)) 
       ELSE
          Grd(116)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!   IF(dodia(nDiag_biomasss06))THEN  ! biomass boreal conifer evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = biomass (nLndPts,6,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_biomasss06,jb)
!   ENDIF
    Grd(117)%Units='  (kg_C m-2)'
    Grd(117)%Name='   total biomass of each plant functional type boreal conifer evergreen trees  ' 
    Grd(117)%NameG='biomass6'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(117)%Buffer(i,1,jb) = Grd(117)%Buffer(i,1,jb) + maxstp*( biomass (nLndPts,6,jb)) 
       ELSE
          Grd(117)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_biomasss07))THEN  ! biomass boreal broadleaf cold-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = biomass (nLndPts,7,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_biomasss07,jb)
!   ENDIF
    Grd(118)%Units='  (kg_C m-2)'
    Grd(118)%Name='   total biomass of each plant functional type boreal broadleaf cold-deciduous trees  ' 
    Grd(118)%NameG='biomass7'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(118)%Buffer(i,1,jb) = Grd(118)%Buffer(i,1,jb) + maxstp*( biomass (nLndPts,7,jb)) 
       ELSE
          Grd(118)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_biomasss08))THEN  ! biomass boreal conifer cold-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = biomass (nLndPts,8,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_biomasss08,jb)
!   ENDIF
    Grd(119)%Units='  (kg_C m-2)'
    Grd(119)%Name='   total biomass of each plant functional type boreal conifer cold-deciduous trees ' 
    Grd(119)%NameG='biomass8'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(119)%Buffer(i,1,jb) = Grd(119)%Buffer(i,1,jb) + maxstp*( biomass (nLndPts,8,jb)) 
       ELSE
          Grd(119)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_biomasss09))THEN  ! biomass evergreen shrubs
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = biomass (nLndPts,9,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_biomasss09,jb)
!   ENDIF
    Grd(120)%Units='  (kg_C m-2)'
    Grd(120)%Name='    total biomass of each plant functional type evergreen shrubs ' 
    Grd(120)%NameG='biomass9'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(120)%Buffer(i,1,jb) = Grd(120)%Buffer(i,1,jb) + maxstp*( biomass (nLndPts,9,jb)) 
       ELSE
          Grd(120)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_biomasss10))THEN  ! biomass cold-deciduous shrubs
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = biomass (nLndPts,10,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_biomasss10,jb)
!   ENDIF
    Grd(121)%Units='  (kg_C m-2)'
    Grd(121)%Name='    total biomass of each plant functional type cold-deciduous shrubs ' 
    Grd(121)%NameG='biomass10'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(121)%Buffer(i,1,jb) = Grd(121)%Buffer(i,1,jb) + maxstp*( biomass (nLndPts,10,jb)) 
       ELSE
          Grd(121)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_biomasss11))THEN  ! biomass cool (c4) grasses   
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = biomass (nLndPts,11,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_biomasss11,jb)
!   ENDIF
    Grd(122)%Units='  (kg_C m-2)'
    Grd(122)%Name='    total biomass of each plant functional type cool (c4) grasses    ' 
    Grd(122)%NameG='biomass11'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(122)%Buffer(i,1,jb) = Grd(122)%Buffer(i,1,jb) + maxstp*( biomass (nLndPts,11,jb)) 
       ELSE
          Grd(122)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!  
!   IF(dodia(nDiag_biomasss12))THEN   ! biomass cool (c3) grasses   
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = biomass (nLndPts,12,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_biomasss12,jb)
!   ENDIF
    Grd(123)%Units='  (kg_C m-2)'
    Grd(123)%Name='    total biomass of each plant functional type cool (c3) grasses    ' 
    Grd(123)%NameG='biomass12'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(123)%Buffer(i,1,jb) = Grd(123)%Buffer(i,1,jb) + maxstp*( biomass (nLndPts,12,jb)) 
       ELSE
          Grd(123)%Buffer(i,1,jb) = undef
       END IF
    END DO    
! !INTEGER, PUBLIC, PARAMETER :: nDiag_toigpp = 173 !instantaneous gpp        (mol-CO2 / m-2 / second)
!  IF(dodia(nDiag_toigpp))THEN  !instantaneous gpp        (mol-CO2 / m-2 / second)
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = tgpptot (nLndPts)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_toigpp,jb)
!   ENDIF

    Grd(124)%Units='  (mol-CO2 / m-2 / second)'
    Grd(124)%Name='   instantaneous gpp    ' 
    Grd(124)%NameG='tgpptot'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(124)%Buffer(i,1,jb) = Grd(124)%Buffer(i,1,jb) + maxstp*( tgpptot (nLndPts)) 
       ELSE
          Grd(124)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!  IF(dodia(nDiag_ynpp01))THEN  ! ynpp tropical broadleaf evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = aynpp (nLndPts,1,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_ynpp01,jb)
!   ENDIF
    Grd(125)%Units=' (kg-c/m**2/yr) '
    Grd(125)%Name='  annual total npp for each plant type => tropical broadleaf evergreen trees    ' 
    Grd(125)%NameG='aynpp1'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(125)%Buffer(i,1,jb) = Grd(125)%Buffer(i,1,jb) + maxstp*( aynpp (nLndPts,1,jb)) 
       ELSE
          Grd(125)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!  IF(dodia(nDiag_ynpp02))THEN ! ynpp tropical broadleaf drought-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = aynpp (nLndPts,2,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_ynpp02,jb)
!   ENDIF
    Grd(126)%Units=' (kg-c/m**2/yr) '
    Grd(126)%Name='  annual total npp for each plant type => tropical broadleaf drought-deciduous trees    ' 
    Grd(126)%NameG='aynpp2'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(126)%Buffer(i,1,jb) = Grd(126)%Buffer(i,1,jb) + maxstp*( aynpp (nLndPts,2,jb)) 
       ELSE
          Grd(126)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!  IF(dodia(nDiag_ynpp03))THEN  ! ynpp warm-temperate broadleaf evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = aynpp (nLndPts,3,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_ynpp03,jb)
!   ENDIF
    Grd(127)%Units=' (kg-c/m**2/yr) '
    Grd(127)%Name='  annual total npp for each plant type => warm-temperate broadleaf evergreen trees   ' 
    Grd(127)%NameG='aynpp3'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(127)%Buffer(i,1,jb) = Grd(127)%Buffer(i,1,jb) + maxstp*( aynpp (nLndPts,3,jb)) 
       ELSE
          Grd(127)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!  IF(dodia(nDiag_ynpp04))THEN  ! ynpp temperate conifer evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = aynpp (nLndPts,4,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_ynpp04,jb)
!   ENDIF

    Grd(128)%Units=' (kg-c/m**2/yr) '
    Grd(128)%Name='  annual total npp for each plant type =>  temperate conifer evergreen trees  ' 
    Grd(128)%NameG='aynpp4'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(128)%Buffer(i,1,jb) = Grd(128)%Buffer(i,1,jb) + maxstp*( aynpp (nLndPts,4,jb)) 
       ELSE
          Grd(128)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!  IF(dodia(nDiag_ynpp05))THEN  ! ynpp temperate broadleaf cold-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = aynpp (nLndPts,5,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_ynpp05,jb)
!   ENDIF

    Grd(129)%Units=' (kg-c/m**2/yr) '
    Grd(129)%Name='  annual total npp for each plant type => temperate broadleaf cold-deciduous trees  ' 
    Grd(129)%NameG='aynpp5'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(129)%Buffer(i,1,jb) = Grd(129)%Buffer(i,1,jb) + maxstp*( aynpp (nLndPts,5,jb)) 
       ELSE
          Grd(129)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!  IF(dodia(nDiag_ynpp06))THEN  ! ynpp boreal conifer evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = aynpp (nLndPts,6,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_ynpp06,jb)
!   ENDIF

    Grd(130)%Units=' (kg-c/m**2/yr) '
    Grd(130)%Name='  annual total npp for each plant type => boreal conifer evergreen trees ' 
    Grd(130)%NameG='aynpp6'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(130)%Buffer(i,1,jb) = Grd(130)%Buffer(i,1,jb) + maxstp*( aynpp (nLndPts,6,jb)) 
       ELSE
          Grd(130)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!  IF(dodia(nDiag_ynpp07))THEN  !ynpp boreal broadleaf cold-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = aynpp (nLndPts,7,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_ynpp07,jb)
!   ENDIF

    Grd(131)%Units=' (kg-c/m**2/yr) '
    Grd(131)%Name='  annual total npp for each plant type =>  boreal broadleaf cold-deciduous trees ' 
    Grd(131)%NameG='aynpp7'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(131)%Buffer(i,1,jb) = Grd(131)%Buffer(i,1,jb) + maxstp*( aynpp (nLndPts,7,jb)) 
       ELSE
          Grd(131)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!  IF(dodia(nDiag_ynpp08))THEN  ! ynpp boreal conifer cold-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = aynpp (nLndPts,8,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_ynpp08,jb)
!   ENDIF


    Grd(132)%Units=' (kg-c/m**2/yr) '
    Grd(132)%Name='  annual total npp for each plant type =>   boreal conifer cold-deciduous trees' 
    Grd(132)%NameG='aynpp8'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(132)%Buffer(i,1,jb) = Grd(132)%Buffer(i,1,jb) + maxstp*( aynpp (nLndPts,8,jb)) 
       ELSE
          Grd(132)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!  IF(dodia(nDiag_ynpp09))THEN  ! ynpp evergreen shrubs
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = aynpp (nLndPts,9,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_ynpp09,jb)
!   ENDIF

    Grd(133)%Units=' (kg-c/m**2/yr) '
    Grd(133)%Name='  annual total npp for each plant type =>   evergreen shrubs' 
    Grd(133)%NameG='aynpp9'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(133)%Buffer(i,1,jb) = Grd(133)%Buffer(i,1,jb) + maxstp*( aynpp (nLndPts,9,jb)) 
       ELSE
          Grd(133)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!  IF(dodia(nDiag_ynpp10))THEN  ! ynpp cold-deciduous shrubs
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = aynpp (nLndPts,10,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_ynpp10,jb)
!   ENDIF
    Grd(134)%Units=' (kg-c/m**2/yr) '
    Grd(134)%Name='  annual total npp for each plant type =>   cold-deciduous shrubs' 
    Grd(134)%NameG='aynpp10'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(134)%Buffer(i,1,jb) = Grd(134)%Buffer(i,1,jb) + maxstp*( aynpp (nLndPts,10,jb)) 
       ELSE
          Grd(134)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!  IF(dodia(nDiag_ynpp11))THEN  !! ynpp warm (c4) grasses
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = aynpp (nLndPts,11,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_ynpp11,jb)
!   ENDIF
    Grd(135)%Units=' (kg-c/m**2/yr) '
    Grd(135)%Name='  annual total npp for each plant type =>  warm (c4) grasses' 
    Grd(135)%NameG='aynpp11'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(135)%Buffer(i,1,jb) = Grd(135)%Buffer(i,1,jb) + maxstp*( aynpp (nLndPts,11,jb)) 
       ELSE
          Grd(135)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!  IF(dodia(nDiag_ynpp12))THEN  ! ynpp cool (c3) grasses
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = aynpp (nLndPts,12,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_ynpp12,jb)
!   ENDIF
    Grd(136)%Units=' (kg-c/m**2/yr) '
    Grd(136)%Name='  annual total npp for each plant type =>  cool (c3) grasses' 
    Grd(136)%NameG='aynpp12'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(136)%Buffer(i,1,jb) = Grd(136)%Buffer(i,1,jb) + maxstp*( aynpp (nLndPts,12,jb)) 
       ELSE
          Grd(136)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   REAL(KIND=r8), INTENT(INOUT) :: falll    (1:nLndPts,jb)          ! global ! annual leaf litter fall     (kg_C m-2/year)
    Grd(137)%Units=' (kg_C m-2/year) '
    Grd(137)%Name=' annual leaf litter fall ' 
    Grd(137)%NameG='falll'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(137)%Buffer(i,1,jb) = Grd(137)%Buffer(i,1,jb) + maxstp*( falll (nLndPts,jb)) 
       ELSE
          Grd(137)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   REAL(KIND=r8), INTENT(INOUT) :: fallr    (1:nLndPts,jb)          ! global ! annual root litter input    (kg_C m-2/year)
    Grd(138)%Units=' (kg_C m-2/year) '
    Grd(138)%Name=' annual root litter input  ' 
    Grd(138)%NameG='fallr'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(138)%Buffer(i,1,jb) = Grd(138)%Buffer(i,1,jb) + maxstp*( fallr (nLndPts,jb)) 
       ELSE
          Grd(138)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!   REAL(KIND=r8), INTENT(INOUT) :: fallw    (1:nLndPts,jb)          ! global ! annual wood litter fall	    (kg_C m-2/year)
    Grd(139)%Units=' (kg_C m-2/year) '
    Grd(139)%Name=' annual wood litter fall  ' 
    Grd(139)%NameG='fallw'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(139)%Buffer(i,1,jb) = Grd(139)%Buffer(i,1,jb) + maxstp*( fallw (nLndPts,jb)) 
       ELSE
          Grd(139)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   REAL(KIND=r8), INTENT(OUT  ) :: disturbf (npoi)	 ! annual fire disturbance regime (m2/m2/yr)
    Grd(140)%Units=' (m2/m2/yr) '
    Grd(140)%Name=' annual fire disturbance regime  ' 
    Grd(140)%NameG='disturbf'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(140)%Buffer(i,1,jb) = Grd(140)%Buffer(i,1,jb) + maxstp*( disturbf (nLndPts)) 
       ELSE
          Grd(140)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   REAL(KIND=r8), INTENT(OUT  ) :: disturbo (npoi)	 ! fraction of biomass pool lost every year to disturbances other than fire
    Grd(141)%Units='% '
    Grd(141)%Name=' fraction of biomass pool lost every year to disturbances other than fire  ' 
    Grd(141)%NameG='disturbo'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(141)%Buffer(i,1,jb) = Grd(141)%Buffer(i,1,jb) + maxstp*( disturbo (nLndPts)) 
       ELSE
          Grd(141)%Buffer(i,1,jb) = undef
       END IF
    END DO    
!!!!!!!!!!!!!!!!

!adnpp(1:nLndPts,1:npft,jb) 



!  IF(dodia(nDiag_ynpp01))THEN  ! ynpp tropical broadleaf evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adnpp (nLndPts,1,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_ynpp01,jb)  NPP for each pft (mol-CO2 / m-2 / second)
!   ENDIF
    Grd(142)%Units='  (mol-CO2 / m-2 / second) '
    Grd(142)%Name='  10-day average  NPP for each pft  => tropical broadleaf evergreen trees    ' 
    Grd(142)%NameG='adnpp1'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(142)%Buffer(i,1,jb) = Grd(142)%Buffer(i,1,jb) + maxstp*( adnpp (nLndPts,1,jb)) 
       ELSE
          Grd(142)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!  IF(dodia(nDiag_ynpp02))THEN ! ynpp tropical broadleaf drought-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adnpp (nLndPts,2,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_ynpp02,jb)
!   ENDIF
    Grd(143)%Units=' (mol-CO2 / m-2 / second) '
    Grd(143)%Name='  10-day average  NPP for each pft => tropical broadleaf drought-deciduous trees    ' 
    Grd(143)%NameG='adnpp2'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(143)%Buffer(i,1,jb) = Grd(143)%Buffer(i,1,jb) + maxstp*( adnpp (nLndPts,2,jb)) 
       ELSE
          Grd(143)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!  IF(dodia(nDiag_ynpp03))THEN  ! ynpp warm-temperate broadleaf evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adnpp (nLndPts,3,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_ynpp03,jb)
!   ENDIF
    Grd(144)%Units='(mol-CO2 / m-2 / second) '
    Grd(144)%Name='  10-day average  NPP for each pft => warm-temperate broadleaf evergreen trees   ' 
    Grd(144)%NameG='adnpp3'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(144)%Buffer(i,1,jb) = Grd(144)%Buffer(i,1,jb) + maxstp*( adnpp (nLndPts,3,jb)) 
       ELSE
          Grd(144)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!  IF(dodia(nDiag_ynpp04))THEN  ! ynpp temperate conifer evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adnpp (nLndPts,4,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_ynpp04,jb)
!   ENDIF

    Grd(145)%Units='(mol-CO2 / m-2 / second)  '
    Grd(145)%Name='  10-day average  NPP for each pft =>  temperate conifer evergreen trees  ' 
    Grd(145)%NameG='adnpp4'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(145)%Buffer(i,1,jb) = Grd(145)%Buffer(i,1,jb) + maxstp*( adnpp (nLndPts,4,jb)) 
       ELSE
          Grd(145)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!  IF(dodia(nDiag_ynpp05))THEN  ! ynpp temperate broadleaf cold-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adnpp (nLndPts,5,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_ynpp05,jb)
!   ENDIF

    Grd(146)%Units=' (mol-CO2 / m-2 / second)  '
    Grd(146)%Name='  10-day average  NPP for each pft => temperate broadleaf cold-deciduous trees  ' 
    Grd(146)%NameG='adnpp5'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(146)%Buffer(i,1,jb) = Grd(146)%Buffer(i,1,jb) + maxstp*( adnpp (nLndPts,5,jb)) 
       ELSE
          Grd(146)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!  IF(dodia(nDiag_ynpp06))THEN  ! ynpp boreal conifer evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adnpp (nLndPts,6,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_ynpp06,jb)
!   ENDIF

    Grd(147)%Units=' (mol-CO2 / m-2 / second)  '
    Grd(147)%Name='  10-day average  NPP for each pft => boreal conifer evergreen trees ' 
    Grd(147)%NameG='adnpp6'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(147)%Buffer(i,1,jb) = Grd(147)%Buffer(i,1,jb) + maxstp*( adnpp (nLndPts,6,jb)) 
       ELSE
          Grd(147)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!  IF(dodia(nDiag_ynpp07))THEN  !ynpp boreal broadleaf cold-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adnpp (nLndPts,7,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_ynpp07,jb)
!   ENDIF

    Grd(148)%Units=' (mol-CO2 / m-2 / second)  '
    Grd(148)%Name='  10-day average  NPP for each pft =>  boreal broadleaf cold-deciduous trees ' 
    Grd(148)%NameG='adnpp7'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(148)%Buffer(i,1,jb) = Grd(148)%Buffer(i,1,jb) + maxstp*( adnpp (nLndPts,7,jb)) 
       ELSE
          Grd(148)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!  IF(dodia(nDiag_ynpp08))THEN  ! ynpp boreal conifer cold-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adnpp (nLndPts,8,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_ynpp08,jb)
!   ENDIF


    Grd(149)%Units=' (mol-CO2 / m-2 / second)  '
    Grd(149)%Name='  10-day average  NPP for each pft =>   boreal conifer cold-deciduous trees' 
    Grd(149)%NameG='adnpp8'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(149)%Buffer(i,1,jb) = Grd(149)%Buffer(i,1,jb) + maxstp*( adnpp (nLndPts,8,jb)) 
       ELSE
          Grd(149)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!  IF(dodia(nDiag_ynpp09))THEN  ! ynpp evergreen shrubs
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adnpp (nLndPts,9,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_ynpp09,jb)
!   ENDIF

    Grd(150)%Units=' (mol-CO2 / m-2 / second)  '
    Grd(150)%Name='  10-day average  NPP for each pft =>   evergreen shrubs' 
    Grd(150)%NameG='adnpp9'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(150)%Buffer(i,1,jb) = Grd(150)%Buffer(i,1,jb) + maxstp*( adnpp (nLndPts,9,jb)) 
       ELSE
          Grd(150)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!  IF(dodia(nDiag_ynpp10))THEN  ! ynpp cold-deciduous shrubs
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adnpp (nLndPts,10,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_ynpp10,jb)
!   ENDIF
    Grd(151)%Units=' (mol-CO2 / m-2 / second) '
    Grd(151)%Name='  10-day average  NPP for each pft =>   cold-deciduous shrubs' 
    Grd(151)%NameG='adnpp10'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(151)%Buffer(i,1,jb) = Grd(151)%Buffer(i,1,jb) + maxstp*( adnpp (nLndPts,10,jb)) 
       ELSE
          Grd(151)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!  IF(dodia(nDiag_ynpp11))THEN  !! ynpp warm (c4) grasses
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adnpp (nLndPts,11,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_ynpp11,jb)
!   ENDIF
    Grd(152)%Units=' (mol-CO2 / m-2 / second)  '
    Grd(152)%Name='  10-day average  NPP for each pft =>  warm (c4) grasses' 
    Grd(152)%NameG='adnpp11'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(152)%Buffer(i,1,jb) = Grd(152)%Buffer(i,1,jb) + maxstp*( adnpp (nLndPts,11,jb)) 
       ELSE
          Grd(152)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!  IF(dodia(nDiag_ynpp12))THEN  ! ynpp cool (c3) grasses
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adnpp (nLndPts,12,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_ynpp12,jb)
!   ENDIF
    Grd(153)%Units=' (mol-CO2 / m-2 / second) '
    Grd(153)%Name='  10-day average  NPP for each pft =>  cool (c3) grasses' 
    Grd(153)%NameG='adnpp12'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(153)%Buffer(i,1,jb) = Grd(153)%Buffer(i,1,jb) + maxstp*( adnpp (nLndPts,12,jb)) 
       ELSE
          Grd(153)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!adco2mic

!  IF(dodia(nDiag_ynpp12))THEN  ! ynpp cool (c3) grasses
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adnpp (nLndPts,12,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_ynpp12,jb)
!   ENDIF
    Grd(154)%Units=' (kg-C/m**2/10day ) '
    Grd(154)%Name='  10-day average  total CO2 flux from microbial respiration ' 
    Grd(154)%NameG='adco2mic'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(154)%Buffer(i,1,jb) = Grd(154)%Buffer(i,1,jb) + maxstp*( adco2mic (nLndPts,jb)) 
       ELSE
          Grd(154)%Buffer(i,1,jb) = undef
       END IF
    END DO    



!   IF(dodia(nDiag_pfts01))THEN  ! pft tropical broadleaf evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adplai (nLndPts,1,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts01,jb)
!   ENDIF
    Grd(155)%Units='  # daily lai'
    Grd(155)%Name=' pft tropical broadleaf evergreen trees   ' 
    Grd(155)%NameG='adplai1'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(155)%Buffer(i,1,jb) = Grd(155)%Buffer(i,1,jb) + maxstp*( adplai (nLndPts,1,jb)) 
       ELSE
          Grd(155)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts02))THEN  ! pft tropical broadleaf drought-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adplai (nLndPts,2,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts02,jb)
!   ENDIF
    Grd(156)%Units='  # daily lai'
    Grd(156)%Name=' pft tropical broadleaf drought-deciduous trees   ' 
    Grd(156)%NameG='adplai2'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(156)%Buffer(i,1,jb) = Grd(156)%Buffer(i,1,jb) + maxstp*( adplai (nLndPts,2,jb)) 
       ELSE
          Grd(156)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts03))THEN  ! pft warm-temperate broadleaf evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adplai (nLndPts,3,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts03,jb)
!   ENDIF
    Grd(157)%Units='  # daily lai'
    Grd(157)%Name=' pft warm-temperate broadleaf evergreen trees  ' 
    Grd(157)%NameG='adplai3'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(157)%Buffer(i,1,jb) = Grd(157)%Buffer(i,1,jb) + maxstp*( adplai (nLndPts,3,jb)) 
       ELSE
          Grd(157)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!   IF(dodia(nDiag_pfts04))THEN  ! pft temperate conifer evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adplai (nLndPts,4,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts04,jb)
!   ENDIF
    Grd(158)%Units='  # daily lai'
    Grd(158)%Name=' pft temperate conifer evergreen trees  ' 
    Grd(158)%NameG='adplai4'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(158)%Buffer(i,1,jb) = Grd(158)%Buffer(i,1,jb) + maxstp*( adplai (nLndPts,4,jb)) 
       ELSE
          Grd(158)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!   IF(dodia(nDiag_pfts05))THEN  ! pft temperate broadleaf cold-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adplai (nLndPts,5,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts05,jb)
!   ENDIF
    Grd(159)%Units='  # daily lai'
    Grd(159)%Name=' pft temperate broadleaf cold-deciduous trees  ' 
    Grd(159)%NameG='adplai5'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(159)%Buffer(i,1,jb) = Grd(159)%Buffer(i,1,jb) + maxstp*( adplai (nLndPts,5,jb)) 
       ELSE
          Grd(159)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!   IF(dodia(nDiag_pfts06))THEN  ! pft boreal conifer evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adplai (nLndPts,6,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts06,jb)
!   ENDIF
    Grd(160)%Units='  # daily lai'
    Grd(160)%Name='  pft boreal conifer evergreen trees  ' 
    Grd(160)%NameG='adplai6'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(160)%Buffer(i,1,jb) = Grd(160)%Buffer(i,1,jb) + maxstp*( adplai (nLndPts,6,jb)) 
       ELSE
          Grd(160)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts07))THEN  ! pft boreal broadleaf cold-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adplai (nLndPts,7,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts07,jb)
!   ENDIF
    Grd(161)%Units='  # daily lai'
    Grd(161)%Name='  pft boreal broadleaf cold-deciduous trees  ' 
    Grd(161)%NameG='adplai7'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(161)%Buffer(i,1,jb) = Grd(161)%Buffer(i,1,jb) + maxstp*( adplai (nLndPts,7,jb)) 
       ELSE
          Grd(161)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts08))THEN  ! pft boreal conifer cold-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adplai (nLndPts,8,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts08,jb)
!   ENDIF
    Grd(162)%Units='  # daily lai'
    Grd(162)%Name='  pft boreal conifer cold-deciduous trees ' 
    Grd(162)%NameG='adplai8'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(162)%Buffer(i,1,jb) = Grd(162)%Buffer(i,1,jb) + maxstp*( adplai (nLndPts,8,jb)) 
       ELSE
          Grd(162)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts09))THEN  ! pft evergreen shrubs
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adplai (nLndPts,9,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts09,jb)
!   ENDIF
    Grd(163)%Units='  # daily lai'
    Grd(163)%Name='   pft evergreen shrubs ' 
    Grd(163)%NameG='adplai9'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(163)%Buffer(i,1,jb) = Grd(163)%Buffer(i,1,jb) + maxstp*( adplai (nLndPts,9,jb)) 
       ELSE
          Grd(163)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts10))THEN  ! pft cold-deciduous shrubs
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adplai (nLndPts,10,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts10,jb)
!   ENDIF
    Grd(164)%Units='  # daily lai'
    Grd(164)%Name='   pft cold-deciduous shrubs ' 
    Grd(164)%NameG='adplai10'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(164)%Buffer(i,1,jb) = Grd(164)%Buffer(i,1,jb) + maxstp*( adplai (nLndPts,10,jb)) 
       ELSE
          Grd(164)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts11))THEN  ! pft cool (c4) grasses   
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adplai (nLndPts,11,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts11,jb)
!   ENDIF
    Grd(165)%Units='  # daily lai'
    Grd(165)%Name='   pft cool (c4) grasses ' 
    Grd(165)%NameG='adplai11'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(165)%Buffer(i,1,jb) = Grd(165)%Buffer(i,1,jb) + maxstp*( adplai (nLndPts,11,jb)) 
       ELSE
          Grd(165)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!  
!   IF(dodia(nDiag_pfts12))THEN   ! pft cool (c3) grasses   
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adplai (nLndPts,12,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts12,jb)
!   ENDIF
    Grd(166)%Units='  # daily lai'
    Grd(166)%Name='   pft cool (c3) grasses    ' 
    Grd(166)%NameG='adplai12'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(166)%Buffer(i,1,jb) = Grd(166)%Buffer(i,1,jb) + maxstp*( adplai (nLndPts,12,jb)) 
       ELSE
          Grd(166)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!adcbiol  carbon in leaf biomass pool (kg_C m-2)


!   IF(dodia(nDiag_pfts01))THEN  ! pft tropical broadleaf evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adplai (nLndPts,1,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts01,jb)
!   ENDIF
    Grd(167)%Units='  kg_C m-2'
    Grd(167)%Name='  carbon in leaf biomass pool pft tropical broadleaf evergreen trees   ' 
    Grd(167)%NameG='adcbiol1'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(167)%Buffer(i,1,jb) = Grd(167)%Buffer(i,1,jb) + maxstp*( adcbiol (nLndPts,1,jb)) 
       ELSE
          Grd(167)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts02))THEN  ! pft tropical broadleaf drought-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbiol (nLndPts,2,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts02,jb)
!   ENDIF
    Grd(168)%Units='  kg_C m-2'
    Grd(168)%Name='carbon in leaf biomass pool  pft tropical broadleaf drought-deciduous trees   ' 
    Grd(168)%NameG='adcbiol2'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(168)%Buffer(i,1,jb) = Grd(168)%Buffer(i,1,jb) + maxstp*( adcbiol (nLndPts,2,jb)) 
       ELSE
          Grd(168)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts03))THEN  ! pft warm-temperate broadleaf evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbiol (nLndPts,3,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts03,jb)
!   ENDIF
    Grd(169)%Units='  kg_C m-2'
    Grd(169)%Name='carbon in leaf biomass pool  pft warm-temperate broadleaf evergreen trees  ' 
    Grd(169)%NameG='adcbiol3'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(169)%Buffer(i,1,jb) = Grd(169)%Buffer(i,1,jb) + maxstp*( adcbiol (nLndPts,3,jb)) 
       ELSE
          Grd(169)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!   IF(dodia(nDiag_pfts04))THEN  ! pft temperate conifer evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbiol (nLndPts,4,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts04,jb)
!   ENDIF
    Grd(170)%Units='  kg_C m-2'
    Grd(170)%Name='carbon in leaf biomass pool  pft temperate conifer evergreen trees  ' 
    Grd(170)%NameG='adcbiol4'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(170)%Buffer(i,1,jb) = Grd(170)%Buffer(i,1,jb) + maxstp*( adcbiol (nLndPts,4,jb)) 
       ELSE
          Grd(170)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!   IF(dodia(nDiag_pfts05))THEN  ! pft temperate broadleaf cold-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbiol (nLndPts,5,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts05,jb)
!   ENDIF
    Grd(171)%Units='  kg_C m-2'
    Grd(171)%Name='carbon in leaf biomass pool  pft temperate broadleaf cold-deciduous trees  ' 
    Grd(171)%NameG='adcbiol5'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(171)%Buffer(i,1,jb) = Grd(171)%Buffer(i,1,jb) + maxstp*( adcbiol (nLndPts,5,jb)) 
       ELSE
          Grd(171)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!   IF(dodia(nDiag_pfts06))THEN  ! pft boreal conifer evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbiol (nLndPts,6,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts06,jb)
!   ENDIF
    Grd(172)%Units='  kg_C m-2'
    Grd(172)%Name=' carbon in leaf biomass pool  pft boreal conifer evergreen trees  ' 
    Grd(172)%NameG='adcbiol6'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(172)%Buffer(i,1,jb) = Grd(172)%Buffer(i,1,jb) + maxstp*( adcbiol (nLndPts,6,jb)) 
       ELSE
          Grd(172)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts07))THEN  ! pft boreal broadleaf cold-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbiol (nLndPts,7,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts07,jb)
!   ENDIF
    Grd(173)%Units='  kg_C m-2'
    Grd(173)%Name='carbon in leaf biomass pool   pft boreal broadleaf cold-deciduous trees  ' 
    Grd(173)%NameG='adcbiol7'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(173)%Buffer(i,1,jb) = Grd(173)%Buffer(i,1,jb) + maxstp*( adcbiol (nLndPts,7,jb)) 
       ELSE
          Grd(173)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts08))THEN  ! pft boreal conifer cold-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbiol (nLndPts,8,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts08,jb)
!   ENDIF
    Grd(174)%Units='  kg_C m-2'
    Grd(174)%Name='carbon in leaf biomass pool   pft boreal conifer cold-deciduous trees ' 
    Grd(174)%NameG='adcbiol8'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(174)%Buffer(i,1,jb) = Grd(174)%Buffer(i,1,jb) + maxstp*( adcbiol (nLndPts,8,jb)) 
       ELSE
          Grd(174)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts09))THEN  ! pft evergreen shrubs
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbiol (nLndPts,9,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts09,jb)
!   ENDIF
    Grd(175)%Units='  kg_C m-2'
    Grd(175)%Name='carbon in leaf biomass pool    pft evergreen shrubs ' 
    Grd(175)%NameG='adcbiol9'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(175)%Buffer(i,1,jb) = Grd(175)%Buffer(i,1,jb) + maxstp*( adcbiol (nLndPts,9,jb)) 
       ELSE
          Grd(175)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts10))THEN  ! pft cold-deciduous shrubs
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbiol (nLndPts,10,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts10,jb)
!   ENDIF
    Grd(176)%Units='  kg_C m-2'
    Grd(176)%Name='carbon in leaf biomass pool    pft cold-deciduous shrubs ' 
    Grd(176)%NameG='adcbiol10'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(176)%Buffer(i,1,jb) = Grd(176)%Buffer(i,1,jb) + maxstp*( adcbiol (nLndPts,10,jb)) 
       ELSE
          Grd(176)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts11))THEN  ! pft cool (c4) grasses   
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbiol (nLndPts,11,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts11,jb)
!   ENDIF
    Grd(177)%Units='  kg_C m-2'
    Grd(177)%Name='carbon in leaf biomass pool    pft cool (c4) grasses ' 
    Grd(177)%NameG='adcbiol11'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(177)%Buffer(i,1,jb) = Grd(177)%Buffer(i,1,jb) + maxstp*( adcbiol (nLndPts,11,jb)) 
       ELSE
          Grd(177)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!  
!   IF(dodia(nDiag_pfts12))THEN   ! pft cool (c3) grasses   
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbiol (nLndPts,12,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts12,jb)
!   ENDIF
    Grd(178)%Units='  kg_C m-2'
    Grd(178)%Name=' carbon in leaf biomass pool   pft cool (c3) grasses    ' 
    Grd(178)%NameG='adcbiol12'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(178)%Buffer(i,1,jb) = Grd(178)%Buffer(i,1,jb) + maxstp*( adcbiol (nLndPts,12,jb)) 
       ELSE
          Grd(178)%Buffer(i,1,jb) = undef
       END IF
    END DO    






!adcbior   carbon in fine root biomass pool (kg_C m-2)

!   IF(dodia(nDiag_pfts01))THEN  ! pft tropical broadleaf evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adplai (nLndPts,1,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts01,jb)
!   ENDIF
    Grd(179)%Units='  kg_C m-2'
    Grd(179)%Name='  carbon in fine root biomass pool  pft tropical broadleaf evergreen trees   ' 
    Grd(179)%NameG='adcbior1'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(179)%Buffer(i,1,jb) = Grd(179)%Buffer(i,1,jb) + maxstp*( adcbior (nLndPts,1,jb)) 
       ELSE
          Grd(179)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts02))THEN  ! pft tropical broadleaf drought-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbior (nLndPts,2,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts02,jb)
!   ENDIF
    Grd(180)%Units='  kg_C m-2'
    Grd(180)%Name='carbon in fine root biomass pool   pft tropical broadleaf drought-deciduous trees   ' 
    Grd(180)%NameG='adcbior2'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(180)%Buffer(i,1,jb) = Grd(180)%Buffer(i,1,jb) + maxstp*( adcbior (nLndPts,2,jb)) 
       ELSE
          Grd(180)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts03))THEN  ! pft warm-temperate broadleaf evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbior (nLndPts,3,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts03,jb)
!   ENDIF
    Grd(181)%Units='  kg_C m-2'
    Grd(181)%Name='carbon in fine root biomass pool   pft warm-temperate broadleaf evergreen trees  ' 
    Grd(181)%NameG='adcbior3'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(181)%Buffer(i,1,jb) = Grd(181)%Buffer(i,1,jb) + maxstp*( adcbior (nLndPts,3,jb)) 
       ELSE
          Grd(181)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!   IF(dodia(nDiag_pfts04))THEN  ! pft temperate conifer evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbior (nLndPts,4,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts04,jb)
!   ENDIF
    Grd(182)%Units='  kg_C m-2'
    Grd(182)%Name='carbon in fine root biomass pool   pft temperate conifer evergreen trees  ' 
    Grd(182)%NameG='adcbior4'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(182)%Buffer(i,1,jb) = Grd(182)%Buffer(i,1,jb) + maxstp*( adcbior (nLndPts,4,jb)) 
       ELSE
          Grd(182)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!   IF(dodia(nDiag_pfts05))THEN  ! pft temperate broadleaf cold-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbior (nLndPts,5,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts05,jb)
!   ENDIF
    Grd(183)%Units='  kg_C m-2'
    Grd(183)%Name='carbon in fine root biomass pool   pft temperate broadleaf cold-deciduous trees  ' 
    Grd(183)%NameG='adcbior5'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(183)%Buffer(i,1,jb) = Grd(183)%Buffer(i,1,jb) + maxstp*( adcbior (nLndPts,5,jb)) 
       ELSE
          Grd(183)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!   IF(dodia(nDiag_pfts06))THEN  ! pft boreal conifer evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbior (nLndPts,6,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts06,jb)
!   ENDIF
    Grd(184)%Units='  kg_C m-2'
    Grd(184)%Name=' carbon in fine root biomass pool   pft boreal conifer evergreen trees  ' 
    Grd(184)%NameG='adcbior6'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(184)%Buffer(i,1,jb) = Grd(184)%Buffer(i,1,jb) + maxstp*( adcbior (nLndPts,6,jb)) 
       ELSE
          Grd(184)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts07))THEN  ! pft boreal broadleaf cold-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbior (nLndPts,7,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts07,jb)
!   ENDIF
    Grd(185)%Units='  kg_C m-2'
    Grd(185)%Name='carbon in fine root biomass pool    pft boreal broadleaf cold-deciduous trees  ' 
    Grd(185)%NameG='adcbior7'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(185)%Buffer(i,1,jb) = Grd(185)%Buffer(i,1,jb) + maxstp*( adcbior (nLndPts,7,jb)) 
       ELSE
          Grd(185)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts08))THEN  ! pft boreal conifer cold-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbior (nLndPts,8,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts08,jb)
!   ENDIF
    Grd(186)%Units='  kg_C m-2'
    Grd(186)%Name='carbon in fine root biomass pool    pft boreal conifer cold-deciduous trees ' 
    Grd(186)%NameG='adcbior8'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(186)%Buffer(i,1,jb) = Grd(186)%Buffer(i,1,jb) + maxstp*( adcbior (nLndPts,8,jb)) 
       ELSE
          Grd(186)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts09))THEN  ! pft evergreen shrubs
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbior (nLndPts,9,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts09,jb)
!   ENDIF
    Grd(187)%Units='  kg_C m-2'
    Grd(187)%Name='carbon in fine root biomass pool     pft evergreen shrubs ' 
    Grd(187)%NameG='adcbior9'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(187)%Buffer(i,1,jb) = Grd(187)%Buffer(i,1,jb) + maxstp*( adcbior (nLndPts,9,jb)) 
       ELSE
          Grd(187)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts10))THEN  ! pft cold-deciduous shrubs
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbior (nLndPts,10,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts10,jb)
!   ENDIF
    Grd(188)%Units='  kg_C m-2'
    Grd(188)%Name='carbon in fine root biomass pool     pft cold-deciduous shrubs ' 
    Grd(188)%NameG='adcbior10'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(188)%Buffer(i,1,jb) = Grd(188)%Buffer(i,1,jb) + maxstp*( adcbior (nLndPts,10,jb)) 
       ELSE
          Grd(188)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts11))THEN  ! pft cool (c4) grasses   
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbior (nLndPts,11,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts11,jb)
!   ENDIF
    Grd(189)%Units='  kg_C m-2'
    Grd(189)%Name='carbon in fine root biomass pool     pft cool (c4) grasses ' 
    Grd(189)%NameG='adcbior11'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(189)%Buffer(i,1,jb) = Grd(189)%Buffer(i,1,jb) + maxstp*( adcbior (nLndPts,11,jb)) 
       ELSE
          Grd(189)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!  
!   IF(dodia(nDiag_pfts12))THEN   ! pft cool (c3) grasses   
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbior (nLndPts,12,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts12,jb)
!   ENDIF
    Grd(190)%Units='  kg_C m-2'
    Grd(190)%Name=' carbon in fine root biomass pool    pft cool (c3) grasses    ' 
    Grd(190)%NameG='adcbior12'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(190)%Buffer(i,1,jb) = Grd(190)%Buffer(i,1,jb) + maxstp*( adcbior (nLndPts,12,jb)) 
       ELSE
          Grd(190)%Buffer(i,1,jb) = undef
       END IF
    END DO    











!adcbiow   carbon in woody biomass pool (kg_C m-2)

!   IF(dodia(nDiag_pfts01))THEN  ! pft tropical broadleaf evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adplai (nLndPts,1,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts01,jb)
!   ENDIF
    Grd(191)%Units='  kg_C m-2'
    Grd(191)%Name='  carbon in woody biomass pool pft tropical broadleaf evergreen trees   ' 
    Grd(191)%NameG='adcbiow1'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(191)%Buffer(i,1,jb) = Grd(191)%Buffer(i,1,jb) + maxstp*( adcbiow (nLndPts,1,jb)) 
       ELSE
          Grd(191)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts02))THEN  ! pft tropical broadleaf drought-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbiow (nLndPts,2,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts02,jb)
!   ENDIF
    Grd(192)%Units='  kg_C m-2'
    Grd(192)%Name='carbon in woody biomass pool  pft tropical broadleaf drought-deciduous trees   ' 
    Grd(192)%NameG='adcbiow2'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(192)%Buffer(i,1,jb) = Grd(192)%Buffer(i,1,jb) + maxstp*( adcbiow (nLndPts,2,jb)) 
       ELSE
          Grd(192)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts03))THEN  ! pft warm-temperate broadleaf evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbiow (nLndPts,3,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts03,jb)
!   ENDIF
    Grd(193)%Units='  kg_C m-2'
    Grd(193)%Name='carbon in woody biomass pool  pft warm-temperate broadleaf evergreen trees  ' 
    Grd(193)%NameG='adcbiow3'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(193)%Buffer(i,1,jb) = Grd(193)%Buffer(i,1,jb) + maxstp*( adcbiow (nLndPts,3,jb)) 
       ELSE
          Grd(193)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!   IF(dodia(nDiag_pfts04))THEN  ! pft temperate conifer evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbiow (nLndPts,4,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts04,jb)
!   ENDIF
    Grd(194)%Units='  kg_C m-2'
    Grd(194)%Name='carbon in woody biomass pool  pft temperate conifer evergreen trees  ' 
    Grd(194)%NameG='adcbiow4'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(194)%Buffer(i,1,jb) = Grd(194)%Buffer(i,1,jb) + maxstp*( adcbiow (nLndPts,4,jb)) 
       ELSE
          Grd(194)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!   IF(dodia(nDiag_pfts05))THEN  ! pft temperate broadleaf cold-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbiow (nLndPts,5,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts05,jb)
!   ENDIF
    Grd(195)%Units='  kg_C m-2'
    Grd(195)%Name='carbon in woody biomass pool  pft temperate broadleaf cold-deciduous trees  ' 
    Grd(195)%NameG='adcbiow5'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(195)%Buffer(i,1,jb) = Grd(195)%Buffer(i,1,jb) + maxstp*( adcbiow (nLndPts,5,jb)) 
       ELSE
          Grd(195)%Buffer(i,1,jb) = undef
       END IF
    END DO    


!   IF(dodia(nDiag_pfts06))THEN  ! pft boreal conifer evergreen trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbiow (nLndPts,6,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts06,jb)
!   ENDIF
    Grd(196)%Units='  kg_C m-2'
    Grd(196)%Name=' carbon in woody biomass pool  pft boreal conifer evergreen trees  ' 
    Grd(196)%NameG='adcbiow6'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(196)%Buffer(i,1,jb) = Grd(196)%Buffer(i,1,jb) + maxstp*( adcbiow (nLndPts,6,jb)) 
       ELSE
          Grd(196)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts07))THEN  ! pft boreal broadleaf cold-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbiow (nLndPts,7,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts07,jb)
!   ENDIF
    Grd(197)%Units='  kg_C m-2'
    Grd(197)%Name='carbon in woody biomass pool   pft boreal broadleaf cold-deciduous trees  ' 
    Grd(197)%NameG='adcbiow7'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(197)%Buffer(i,1,jb) = Grd(197)%Buffer(i,1,jb) + maxstp*( adcbiow (nLndPts,7,jb)) 
       ELSE
          Grd(197)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts08))THEN  ! pft boreal conifer cold-deciduous trees
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbiow (nLndPts,8,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts08,jb)
!   ENDIF
    Grd(198)%Units='  kg_C m-2'
    Grd(198)%Name='carbon in woody biomass pool   pft boreal conifer cold-deciduous trees ' 
    Grd(198)%NameG='adcbiow8'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(198)%Buffer(i,1,jb) = Grd(198)%Buffer(i,1,jb) + maxstp*( adcbiow (nLndPts,8,jb)) 
       ELSE
          Grd(198)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts09))THEN  ! pft evergreen shrubs
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbiow (nLndPts,9,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts09,jb)
!   ENDIF
    Grd(199)%Units='  kg_C m-2'
    Grd(199)%Name='carbon in woody biomass pool    pft evergreen shrubs ' 
    Grd(199)%NameG='adcbiow9'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(199)%Buffer(i,1,jb) = Grd(199)%Buffer(i,1,jb) + maxstp*( adcbiow (nLndPts,9,jb)) 
       ELSE
          Grd(199)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts10))THEN  ! pft cold-deciduous shrubs
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbiow (nLndPts,10,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts10,jb)
!   ENDIF
    Grd(200)%Units='  kg_C m-2'
    Grd(200)%Name='carbon in woody biomass pool    pft cold-deciduous shrubs ' 
    Grd(200)%NameG='adcbiow10'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(200)%Buffer(i,1,jb) = Grd(200)%Buffer(i,1,jb) + maxstp*( adcbiow (nLndPts,10,jb)) 
       ELSE
          Grd(200)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!   IF(dodia(nDiag_pfts11))THEN  ! pft cool (c4) grasses   
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbiow (nLndPts,11,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts11,jb)
!   ENDIF
    Grd(201)%Units='  kg_C m-2'
    Grd(201)%Name='carbon in woody biomass pool    pft cool (c4) grasses ' 
    Grd(201)%NameG='adcbiow11'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(201)%Buffer(i,1,jb) = Grd(201)%Buffer(i,1,jb) + maxstp*( adcbiow (nLndPts,11,jb)) 
       ELSE
          Grd(201)%Buffer(i,1,jb) = undef
       END IF
    END DO    

!  
!   IF(dodia(nDiag_pfts12))THEN   ! pft cool (c3) grasses   
!      diag=0.0_r8
!      nLndPts=0
!      DO i=1, nCols
!         IF(iMask(i) >= 1)THEN 
!            nLndPts=nLndPts+1
!            diag(i) = adcbiow (nLndPts,12,jb)
!         END IF
!      END DO
!      CALL updia(diag,nDiag_pfts12,jb)
!   ENDIF
    Grd(202)%Units='  kg_C m-2'
    Grd(202)%Name=' carbon in woody biomass pool   pft cool (c3) grasses    ' 
    Grd(202)%NameG='adcbiow12'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(202)%Buffer(i,1,jb) = Grd(202)%Buffer(i,1,jb) + maxstp*( adcbiow (nLndPts,12,jb)) 
       ELSE
          Grd(202)%Buffer(i,1,jb) = undef
       END IF
    END DO    


    Grd(317)%Units='  W m-2'
    Grd(317)%Name=' Observation Surface latent heat flux  ' 
    Grd(317)%NameG='slhf'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(317)%Buffer(i,1,jb) = Grd(317)%Buffer(i,1,jb) + maxstp*( slhf (nLndPts)) 
       ELSE
          Grd(317)%Buffer(i,1,jb) = undef
       END IF
    END DO    

    Grd(318)%Units='  W m-2'
    Grd(318)%Name=' Observation Surface sensible heat flux      ' 
    Grd(318)%NameG='sshf'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(318)%Buffer(i,1,jb) = Grd(318)%Buffer(i,1,jb) + maxstp*( sshf (nLndPts)) 
       ELSE
          Grd(318)%Buffer(i,1,jb) = undef
       END IF
    END DO    

    Grd(319)%Units='W m-2'
    Grd(319)%Name='Observation downward solar flux '
    Grd(319)%NameG='slrad'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(319)%Buffer(i,1,jb) = Grd(319)%Buffer(i,1,jb) + maxstp*(swdown  (i)) 
       ELSE
          Grd(319)%Buffer(i,1,jb) = undef
       END IF
    END DO
!vegtype0  (1:nLndPts,jb)
    Grd(320)%Units='#'
    Grd(320)%Name='annual vegetation type - ibis classification '
    Grd(320)%NameG='vegtype0'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(320)%Buffer(i,1,jb) =vegtype0  ( nLndPts,jb) 
       ELSE
          Grd(320)%Buffer(i,1,jb) = undef
       END IF
    END DO

!    totcondub(1:nLndPts,jb)!calculate total canopy and boundary-layer total conductance for water vapor diffusion
    Grd(321)%Units='#'
    Grd(321)%Name=' calculate total canopy and boundary-layer total conductance for water vapor diffusion '
    Grd(321)%NameG='totcondub'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(321)%Buffer(i,1,jb) = Grd(321)%Buffer(i,1,jb) + maxstp*(totcondub  (nLndPts,jb)) 
       ELSE
          Grd(321)%Buffer(i,1,jb) = undef
       END IF
    END DO

!    totconduc(1:nLndPts,jb)
    Grd(322)%Units='#'
    Grd(322)%Name=' calculate total canopy and boundary-layer total conductance for water vapor diffusion uc'
    Grd(322)%NameG='totconduc'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(322)%Buffer(i,1,jb) = Grd(322)%Buffer(i,1,jb) + maxstp*(totconduc  (nLndPts,jb)) 
       ELSE
          Grd(322)%Buffer(i,1,jb) = undef
       END IF
    END DO

!    totcondls(1:nLndPts,jb)=   0.0_r8
    Grd(323)%Units='#'
    Grd(323)%Name=' calculate total canopy and boundary-layer total conductance for water vapor diffusion ls'
    Grd(323)%NameG='totcondls'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(323)%Buffer(i,1,jb) = Grd(323)%Buffer(i,1,jb) + maxstp*(totcondls  (nLndPts,jb)) 
       ELSE
          Grd(323)%Buffer(i,1,jb) = undef
       END IF
    END DO

!    totcondl3(1:nLndPts,jb)=   0.0_r8
    Grd(324)%Units='#'
    Grd(324)%Name=' calculate total canopy and boundary-layer total conductance for water vapor diffusion l3'
    Grd(324)%NameG='totcondl3'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(324)%Buffer(i,1,jb) = Grd(324)%Buffer(i,1,jb) + maxstp*(totcondl3  (nLndPts,jb)) 
       ELSE
          Grd(324)%Buffer(i,1,jb) = undef
       END IF
    END DO

!    totcondl4(1:nLndPts,jb)=   0.0_r8
    Grd(325)%Units='#'
    Grd(325)%Name=' calculate total canopy and boundary-layer total conductance for water vapor diffusion l4'
    Grd(325)%NameG='totcondl4'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(325)%Buffer(i,1,jb) = Grd(325)%Buffer(i,1,jb) + maxstp*(totcondl4  (nLndPts,jb)) 
       ELSE
          Grd(325)%Buffer(i,1,jb) = undef
       END IF
    END DO

   !
   DO k=1,nVars
      DO i=1, nCols
       IF(iMask(i) < 1)THEN 
          Grd(k)%Buffer(i,1,jb) = undef
       END IF
    END DO
  END DO

   idateprev=idatec
END SUBROUTINE Ibis_Interface



 SUBROUTINE IbisDrv(mcsec        ,pi          ,stef         ,vonk         ,grav        , &
                    tmelt        ,hfus        ,hvap         ,hsub         ,ch2o        , &
                    cice         ,cair        ,cvap         ,rair         ,rvap        , &
                    cappa        ,rhow        ,npoi         ,nband        ,nsoilay     , & 
                    nsnolay      ,npft        ,epsilon      ,dtime        ,doalb       , &
		    ginvap       ,gsuvap      ,gtrans       ,gtransu      ,gtransl     , &
                    grunof       ,gdrain      ,gadjust      ,a10scalparamu,a10daylightu, &
		    a10scalparaml,a10daylightl,vmax_pft     ,tau15        ,kc15        , &
                    ko15         ,cimax       ,gammaub      ,alpha3       ,theta3      , &
		    beta3        ,coefmub     ,coefbub      ,gsubmin      ,gammauc     , &
                    coefmuc      ,coefbuc     ,gsucmin      ,gammals      ,coefmls     , & 
                    coefbls      ,gslsmin     ,gammal3      ,coefml3      ,coefbl3     , &
                    gsl3min      ,gammal4     ,alpha4       ,theta4       ,beta4       , &
		    coefml4      ,coefbl4     ,gsl4min      ,bps          ,wliqu        ,wliqumax    , & 
                    wsnou        ,wsnoumax    ,tu           ,wliqs        ,wliqsmax    , & 
                    wsnos        ,wsnosmax    ,ts           ,wliql        ,wliqlmax    , &  
                    wsnol        ,wsnolmax    ,tl           ,topparu      ,topparl     , &
                    fl           ,fu          ,lai          ,sai          ,rhoveg      , &   
                    tauveg       ,orieh       ,oriev        ,wliqmin      ,wsnomin     , & 
                    t12          ,tdripu      ,tblowu       ,tdrips       ,tblows      , &
                    t34          ,tdripl      ,tblowl       ,ztop         ,za          ,alaiml      , &
                    zbot         ,alaimu      ,froot        ,q34          ,q12         , &
                    su	         ,cleaf       ,dleaf        ,ss           ,cstem       , & 
                    dstem        ,sl          ,cgrass       ,ciub         ,ciuc        , &
                    exist        ,csub        ,gsub         ,csuc         ,gsuc        , &
                    agcub        ,agcuc       ,ancub        ,ancuc        ,totcondub   , &
                    totconduc    ,cils        ,cil3         ,cil4         ,csls        , &
                    gsls         ,csl3        ,gsl3         ,csl4         ,gsl4        , &
		    agcls        ,agcl4       ,agcl3        ,ancls        ,ancl4       , &
		    ancl3       ,totcondls    ,totcondl3    ,totcondl4    ,chu         , &
                    chs          ,chl         ,frac         ,tlsub	  ,z0sno       , & 
                    rhos         ,consno      ,hsnotop      ,hsnomin      ,fimin       , &
		    fimax        ,fi          ,tsno         ,hsno         ,sand	       , &
                    clay         ,poros       ,wsoi         ,wisoi        ,consoi      , &  
                    zwpmax       ,wpud        ,wipud        ,wpudmax      ,qglif       , & 	
                    tsoi         ,hvasug      ,hvasui       ,albsav       ,albsan      , &
		    tg           ,ti          ,z0soi        ,swilt        ,sfield      , &
                    stressl      ,stressu     ,stresstl     ,stresstu     ,csoi        , & 	
                    rhosoi       ,hsoi        ,suction      ,bex          ,upsoiu      , &  
                    upsoil       ,heatg       ,heati        ,hydraul      ,porosflo    , &
                    ibex         ,bperm       ,hflo	    ,ta           ,asurd       , &  
                    asuri        ,coszen      ,solad        ,solai        ,fira	       , & 
                    raina        ,qa          ,psurf        ,snowa        ,ua	       , &   
                    o2conc       ,co2conc     ,&
		    td	         ,vzero       ,ndaypy       ,nppdummy     , & 
                    cbiow        ,sapfrac      ,cbior       , & 
                    tco2root    ,tneetot      ,tco2mic      ,a10td       , &
                    a10ancub     ,a10ancuc    ,a10ancls     ,a10ancl3     ,a10ancl4    , & 
                    ndtimes      ,adrain       ,adsnow      ,tnpptot, &
                    adaet        ,adtrunoff   ,adsrunoff    ,addrainage   ,adrh        , &
                    adsnod       ,adsnof      ,adwsoi       ,adtsoi       ,adwisoi     , &
                    adtlaysoi    ,adwlaysoi   ,adwsoic      ,adtsoic      ,adco2mic    , &
                    adco2root    ,adco2soi    ,adco2ratio   ,adnmintot    ,decompl     , &    
                    decomps      ,tnmin       ,ndaypm       ,nmtimes     , & 
                    amrain       ,amsnow      ,amaet        ,amtrunoff    ,amsrunoff   , &
                    amdrainage   ,amtemp      ,amqa         , &
                    amsolar      ,amirup      ,amirdown     ,amsens       ,amlatent    , &  
                    amlaiu       ,amlail      ,amtsoi       ,amwsoi       ,amwisoi     , &   
                    amvwc        ,amawc       ,amsnod       ,amsnof       ,amnpp       , &
                    amnpptot     ,amco2mic    ,amco2root    ,amco2soi     ,amco2ratio  , &
                    amneetot     ,amnmintot   ,amalbedo     ,amtsoil      ,amwsoil     , & 
                    amwisoil     ,nytimes      ,aysolar      ,ayirup      , &
                    ayirdown     ,aysens      ,aylatent     ,ayprcp       ,ayaet       , &  
                    aytrans      ,aytrunoff   ,aysrunoff    ,aydrainage   ,aydwtot     , & 
                    aywsoi       ,aywisoi     ,aytsoi       ,ayvwc        ,ayawc       , &  
                    aystresstu   ,aystresstl  ,aygpp	    ,aygpptot     ,aynpp       , & 
                    aynpptot     ,ayco2mic    ,ayco2root    ,ayco2soi     ,ayneetot    , &
		    ayrootbio    ,aynmintot   ,ayalit       ,ayblit       ,aycsoi      , & 
                    aycmic       ,ayanlit     ,aybnlit      ,aynsoi       ,ayalbedo    ,&
		    totalit     , &
                    totrlit      ,totcsoi     ,totcmic      ,totanlit     ,totrnlit    , &
                    totnsoi      ,totnmic     ,totlit       ,totfall      ,totnlit     , &
                    firefac      ,wtot        ,storedn      ,yrleach      ,ynleach     , & 
                    falll        ,fallr       ,fallw        ,clitlm       ,clitls      , &
                    clitrm       ,clitrs      ,clitwm       ,clitws       ,csoislop    , &
                    csoislon     ,csoipas     ,clitll       ,clitrl       ,clitwl      , &  
                    tc           ,agddu	      ,tempu	    ,agddl        ,templ       , &
                    dropu        ,dropls      ,dropl4       ,dropl3       ,plai	       , &
		    iday        ,imonth       ,iyear        ,iyear0       , &
                    isimveg      ,spinmax     ,amts2        ,amtransu     ,amtransl    , &
                    amsuvap      ,aminvap     ,ux	    ,uy	          ,taux        , &
		    tauy         ,ts2	      ,qs2          ,deltat       ,gdd0        , &  
                    gdd0this     ,tcthis      ,twthis       ,tcmin        ,gdd5        , & 
                    gdd5this     ,TminL       ,TminU        ,Twarm        ,GDD         , & 
                    aleaf        ,awood       ,cbiol        ,aroot        ,disturbf    , &
                    disturbo     ,specla      ,biomass      ,totlaiu      ,totlail     , &  
                    totbiou      ,totbiol     ,woodnorm     ,vegtype0     ,tauwood0    , & 
                    tauwood      ,tauleaf     ,tauroot      ,xminlai      ,cdisturb    , & 
                    ayanpp       ,ayanpptot   ,garea        , &
		    nstep	 ,idayprev    ,imonthprev   ,iyearprev    ,idayout     , &
		    imonthout    ,iyearout    ,isimco2      ,isimfire    , &
		    co2init      ,calday      ,tw           ,fvapa       ,fsena        , &
		    z0           ,ustar       ,hc           ,hg          ,ec           , &
                    eg           ,dispu       ,cu           ,firb        ,tgpptot      , &
		    bstar        ,ynleach_p   ,tnmin_p      ,totnmic_p   ,totnlit_p    , &
                    totanlit_p   ,totrnlit_p  ,totnsoi_p    ,storedn_p   ,adnpp        ,&
		    adfalll      ,adfallr     ,adfallw      ,adcbiol     ,adcbior      ,&
		    adcbiow      ,adplai      ,beta1        ,beta2       ,stressfac    ,&
		    avmuir_factor, iMask        ,nCols       ,jb           ,nVegClass   ,rootmode)

  IMPLICIT NONE
   REAL(KIND=r8), INTENT(IN	) :: mcsec!global  ! current seconds in day (0 - (86400 - dtime))
   REAL(KIND=r8), INTENT(IN	) :: pi   !global
   REAL(KIND=r8), INTENT(IN	) :: stef !global  ! stefan-boltzmann constant (W m-2 K-4)
   REAL(KIND=r8), INTENT(IN	) :: vonk !global  ! von karman constant (dimensionless)
   REAL(KIND=r8), INTENT(IN	) :: grav !global  ! gravitational acceleration (m s-2)
   REAL(KIND=r8), INTENT(IN	) :: tmelt!global  ! freezing point of water (K)
   REAL(KIND=r8), INTENT(IN	) :: hfus !global  ! latent heat of fusion of water (J kg-1)
   REAL(KIND=r8), INTENT(IN	) :: hvap !global  ! latent heat of vaporization of water (J kg-1)
   REAL(KIND=r8), INTENT(IN	) :: hsub !global  ! latent heat of sublimation of ice (J kg-1)
   REAL(KIND=r8), INTENT(IN	) :: ch2o !global  ! specific heat of liquid water (J deg-1 kg-1)
   REAL(KIND=r8), INTENT(IN	) :: cice !global  ! specific heat of ice (J deg-1 kg-1)
   REAL(KIND=r8), INTENT(IN	) :: cair !global  ! specific heat of dry air at constant pressure (J deg-1 kg-1)
   REAL(KIND=r8), INTENT(IN	) :: cvap !global  ! specific heat of water vapor at constant pressure (J deg-1 kg-1)
   REAL(KIND=r8), INTENT(IN	) :: rair !global  ! gas constant for dry air (J deg-1 kg-1)
   REAL(KIND=r8), INTENT(IN	) :: rvap !global  ! gas constant for water vapor (J deg-1 kg-1)
   REAL(KIND=r8), INTENT(IN	) :: cappa!global  ! rair/cair
   REAL(KIND=r8), INTENT(IN	) :: rhow !global  ! density of liquid water (all types) (kg m-3)

! 
!
   INTEGER, INTENT(IN   ) :: nVegClass
   INTEGER, INTENT(IN   ) :: nCols
   INTEGER, INTENT(IN   ) :: jb
   INTEGER, INTENT(IN   ) :: npoi   !global  
   INTEGER, INTENT(IN   ) :: nband  !global  
   INTEGER, INTENT(IN   ) :: nsoilay!global   ! number of soil layers
   INTEGER, INTENT(IN   ) :: nsnolay!global   ! number of snow layers
   INTEGER, INTENT(IN   ) :: npft   !global   ! number of plant functional types
   REAL(KIND=r8), INTENT(IN   ) :: epsilon!global   ! small quantity to avoid zero-divides and other
   		                       ! truncation or machine-limit troubles with small
   		                       ! values. should be slightly greater than o(1)
   		                       ! machine precision
   REAL(KIND=r8), INTENT(IN   )  :: dtime !global   ! model timestep (seconds)
   logical, INTENT(IN   )  :: doalb !global    ! true if surface albedo calculation time step

!      INCLUDE 'comhyd.h'
   REAL(KIND=r8), INTENT(OUT  ) :: ginvap (npoi)!local ! total evaporation rate from all intercepted h2o (kg_h2o m-2 s-1)
   REAL(KIND=r8), INTENT(OUT  ) :: gsuvap (npoi)!local ! total evaporation rate from surface (snow/soil) (kg_h2o m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: gtrans (npoi)!local ! total transpiration rate from all vegetation canopies (kg_h2o m-2 s-1)
   REAL(KIND=r8), INTENT(OUT  ) :: gtransu(npoi)!local ! transpiration from upper canopy (kg_h2o m-2 s-1)
   REAL(KIND=r8), INTENT(OUT  ) :: gtransl(npoi)!local ! transpiration from lower canopy (kg_h2o m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: grunof (npoi)!local ! surface runoff rate (kg_h2o m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: gdrain (npoi)!local ! drainage rate out of bottom of lowest soil layer (kg_h2o m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: gadjust(npoi)!local ! h2o flux due to adjustments in subroutine wadjust (kg_h2o m-2 s-1)
!      INCLUDE 'comsum.h'
   REAL(KIND=r8), INTENT(INOUT) :: a10scalparamu(npoi)!global ! 10-day average day-time scaling parameter - upper canopy (dimensionless)
   REAL(KIND=r8), INTENT(INOUT) :: a10daylightu (npoi)!global ! 10-day average day-time PAR - upper canopy (micro-Ein m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: a10scalparaml(npoi)!global ! 10-day average day-time scaling parameter - lower canopy (dimensionless)
   REAL(KIND=r8), INTENT(INOUT) :: a10daylightl (npoi)!global ! 10-day average day-time PAR - lower canopy (micro-Ein m-2 s-1)
!      INCLUDE 'compft.h'
   REAL(KIND=r8), INTENT(IN   ) :: vmax_pft(npft)!global ! nominal vmax of top leaf at 15 C (mol-co2/m**2/s) [not used]
   REAL(KIND=r8), INTENT(IN   ) :: tau15	   !global ! co2/o2 specificity ratio at 15 degrees C (dimensionless)
   REAL(KIND=r8), INTENT(IN   ) :: kc15	   !global ! co2 kinetic parameter (mol/mol)
   REAL(KIND=r8), INTENT(IN   ) :: ko15	   !global ! o2 kinetic parameter (mol/mol) 
   REAL(KIND=r8), INTENT(IN   ) :: cimax	   !global ! maximum value for ci (needed for model stability)
   REAL(KIND=r8), INTENT(IN   ) :: gammaub	   !global ! leaf respiration coefficient
   REAL(KIND=r8), INTENT(IN   ) :: alpha3	   !global ! intrinsic quantum efficiency for C3 plants (dimensionless)
   REAL(KIND=r8), INTENT(IN   ) :: theta3	   !global ! photosynthesis coupling coefficient for C3 plants (dimensionless)
   REAL(KIND=r8), INTENT(IN   ) :: beta3	   !global ! photosynthesis coupling coefficient for C3 plants (dimensionless)
   REAL(KIND=r8), INTENT(IN   ) :: coefmub	   !global ! 'm' coefficient for stomatal conductance relationship
   REAL(KIND=r8), INTENT(IN   ) :: coefbub	   !global ! 'b' coefficient for stomatal conductance relationship
   REAL(KIND=r8), INTENT(IN   ) :: gsubmin	   !global ! absolute minimum stomatal conductance
   REAL(KIND=r8), INTENT(IN   ) :: gammauc	   !global ! leaf respiration coefficient
   REAL(KIND=r8), INTENT(IN   ) :: coefmuc	   !global ! 'm' coefficient for stomatal conductance relationship  
   REAL(KIND=r8), INTENT(IN   ) :: coefbuc	   !global ! 'b' coefficient for stomatal conductance relationship  
   REAL(KIND=r8), INTENT(IN   ) :: gsucmin	   !global ! absolute minimum stomatal conductance
   REAL(KIND=r8), INTENT(IN   ) :: gammals	   !global ! leaf respiration coefficient
   REAL(KIND=r8), INTENT(IN   ) :: coefmls	   !global ! 'm' coefficient for stomatal conductance relationship 
   REAL(KIND=r8), INTENT(IN   ) :: coefbls	   !global ! 'b' coefficient for stomatal conductance relationship 
   REAL(KIND=r8), INTENT(IN   ) :: gslsmin	   !global ! absolute minimum stomatal conductance
   REAL(KIND=r8), INTENT(IN   ) :: gammal3	   !global ! leaf respiration coefficient
   REAL(KIND=r8), INTENT(IN   ) :: coefml3	   !global ! 'm' coefficient for stomatal conductance relationship 
   REAL(KIND=r8), INTENT(IN   ) :: coefbl3	   !global ! 'b' coefficient for stomatal conductance relationship 
   REAL(KIND=r8), INTENT(IN   ) :: gsl3min	   !global ! absolute minimum stomatal conductance
   REAL(KIND=r8), INTENT(IN   ) :: gammal4	   !global ! leaf respiration coefficient
   REAL(KIND=r8), INTENT(IN   ) :: alpha4	   !global ! intrinsic quantum efficiency for C4 plants (dimensionless)
   REAL(KIND=r8), INTENT(IN   ) :: theta4	   !global ! photosynthesis coupling coefficient for C4 plants (dimensionless) 
   REAL(KIND=r8), INTENT(IN   ) :: beta4	   !global ! photosynthesis coupling coefficient for C4 plants (dimensionless)
   REAL(KIND=r8), INTENT(IN   ) :: coefml4	   !global ! 'm' coefficient for stomatal conductance relationship
   REAL(KIND=r8), INTENT(IN   ) :: coefbl4	   !global ! 'b' coefficient for stomatal conductance relationship
   REAL(KIND=r8), INTENT(IN   ) :: gsl4min	   !global ! absolute minimum stomatal conductance
   REAL(KIND=r8), INTENT(INOUT) :: bps(npoi)
!      include 'comveg.h'
   REAL(KIND=r8), INTENT(INOUT) :: wliqu    (npoi)  !global ! intercepted liquid h2o on upper canopy leaf area (kg m-2)
   REAL(KIND=r8), INTENT(IN   ) :: wliqumax  	    !global ! maximum intercepted water on a unit upper canopy leaf area (kg m-2)
   REAL(KIND=r8), INTENT(INOUT) :: wsnou    (npoi)  !global ! intercepted frozen h2o (snow) on upper canopy leaf area (kg m-2)
   REAL(KIND=r8), INTENT(IN   ) :: wsnoumax  	    !global ! intercepted snow capacity for upper canopy leaves (kg m-2)
   REAL(KIND=r8), INTENT(INOUT) :: tu       (npoi)  !global ! temperature of upper canopy leaves (K)
   REAL(KIND=r8), INTENT(INOUT) :: wliqs    (npoi)  !global ! intercepted liquid h2o on upper canopy stem area (kg m-2)
   REAL(KIND=r8), INTENT(IN   ) :: wliqsmax  	    !global ! maximum intercepted water on a unit upper canopy stem area (kg m-2)
   REAL(KIND=r8), INTENT(INOUT) :: wsnos    (npoi)  !global ! intercepted frozen h2o (snow) on upper canopy stem area (kg m-2)
   REAL(KIND=r8), INTENT(IN   ) :: wsnosmax  	    !global ! intercepted snow capacity for upper canopy stems (kg m-2)
   REAL(KIND=r8), INTENT(INOUT) :: ts       (npoi)  !global ! temperature of upper canopy stems (K)
   REAL(KIND=r8), INTENT(INOUT) :: wliql    (npoi)  !global ! intercepted liquid h2o on lower canopy leaf and stem area (kg m-2)
   REAL(KIND=r8), INTENT(IN   ) :: wliqlmax  	    !global ! maximum intercepted water on a unit lower canopy stem & leaf area (kg m-2)
   REAL(KIND=r8), INTENT(INOUT) :: wsnol    (npoi)  !global ! intercepted frozen h2o (snow) on lower canopy leaf & stem area (kg m-2)
   REAL(KIND=r8), INTENT(IN   ) :: wsnolmax  	    !global ! intercepted snow capacity for lower canopy leaves & stems (kg m-2)
   REAL(KIND=r8), INTENT(INOUT) :: tl       (npoi)  !global ! temperature of lower canopy leaves & stems(K)
   REAL(KIND=r8), INTENT(INOUT) :: topparu  (npoi)  !local  ! total photosynthetically active raditaion absorbed 
                                                            ! by top leaves of upper canopy (W m-2)
   REAL(KIND=r8), INTENT(INOUT) :: topparl  (npoi)  !local  ! total photosynthetically active raditaion absorbed
                                                            ! by top leaves of lower canopy (W m-2)
   REAL(KIND=r8), INTENT(INOUT) :: fl       (npoi)   !global ! fraction of snow-free area covered by lower  canopy
   REAL(KIND=r8), INTENT(INOUT) :: fu       (npoi)   !global ! fraction of overall area covered by upper canopy
   REAL(KIND=r8), INTENT(INOUT) :: lai      (npoi,2) !global ! canopy single-sided leaf area index (area leaf/area veg)
   REAL(KIND=r8), INTENT(INOUT) :: sai      (npoi,2) !global ! current single-sided stem area index
   REAL(KIND=r8), INTENT(IN   ) :: rhoveg   (nband,2)!global ! reflectance of an average leaf/stem
   REAL(KIND=r8), INTENT(IN   ) :: tauveg   (nband,2)!global  ! transmittance of an average leaf/stem
   REAL(KIND=r8), INTENT(IN   ) :: orieh    (2)      !global! fraction of leaf/stems with horizontal orientation
   REAL(KIND=r8), INTENT(IN   ) :: oriev    (2)      !global! fraction of leaf/stems with vertical
   REAL(KIND=r8), INTENT(INOUT) :: wliqmin           !local ! minimum intercepted water on unit vegetated area (kg m-2)
   REAL(KIND=r8), INTENT(INOUT) :: wsnomin           !local ! minimum intercepted snow on unit vegetated area (kg m-2)
   REAL(KIND=r8), INTENT(INOUT) :: t12      (npoi)   !global ! air temperature at z12 (K)
   REAL(KIND=r8), INTENT(IN   ) :: tdripu            !global ! decay time for dripoff of liquid intercepted by upper canopy leaves (sec)
   REAL(KIND=r8), INTENT(IN   ) :: tblowu	     !global ! decay time for blowoff of snow intercepted by upper canopy leaves (sec)
   REAL(KIND=r8), INTENT(IN   ) :: tdrips	     !global ! decay time for dripoff of liquid intercepted by upper canopy stems (sec) 
   REAL(KIND=r8), INTENT(IN   ) :: tblows	     !global ! decay time for blowoff of snow intercepted by upper canopy stems (sec)
   REAL(KIND=r8), INTENT(INOUT) :: t34      (npoi)   !global ! air temperature at z34 (K)
   REAL(KIND=r8), INTENT(IN   ) :: tdripl            !global ! decay time for dripoff of liquid intercepted
                                                             ! by lower canopy leaves & stem (sec)
   REAL(KIND=r8), INTENT(IN   ) :: tblowl	     ! global	  ! decay time for blowoff of snow intercepted by lower canopy leaves & stems (sec)
   REAL(KIND=r8), INTENT(IN   ) :: za       (npoi)          ! local ! height above the surface of atmospheric forcing (m)
   REAL(KIND=r8), INTENT(INOUT) :: ztop     (npoi,2) ! global  ! height of plant top above ground (m)
   REAL(KIND=r8), INTENT(IN   ) :: alaiml	     ! global ! lower canopy leaf & stem maximum area (2 sided) for
                                                     ! normalization of drag coefficient (m2 m-2)
   REAL(KIND=r8), INTENT(INOUT) :: zbot     (npoi,2) ! global  ! height of lowest branches above ground (m)
   REAL(KIND=r8), INTENT(IN   ) :: alaimu	     ! global  ! upper canopy leaf & stem area (2 sided) for 
                                                     ! normalization of drag coefficient (m2 m-2)
   REAL(KIND=r8), INTENT(INOUT) :: froot    (npoi,nsoilay,2)! global! fraction of root in soil layer 
   REAL(KIND=r8), INTENT(INOUT) :: q34      (npoi)   ! global! specific humidity of air at z34
   REAL(KIND=r8), INTENT(INOUT) :: q12      (npoi)   ! global! specific humidity of air at z12
   REAL(KIND=r8), INTENT(INOUT) :: su       (npoi)   ! local ! air-vegetation transfer coefficients (*rhoa) for
                                                             ! upper canopy leaves (m s-1 * kg m-3) (A39a Pollard & Thompson 1995)
   REAL(KIND=r8), INTENT(IN   ) :: cleaf	     ! global! empirical constant in upper canopy leaf-air 
                                                             ! aerodynamic transfer coefficient (m s-0.5) (A39a Pollard & Thompson 95)
   REAL(KIND=r8), INTENT(IN   ) :: dleaf    (2)	     ! global ! typical linear leaf dimension in aerodynamic transfer coefficient (m)
   REAL(KIND=r8), INTENT(INOUT) :: ss       (npoi)   ! local! air-vegetation transfer coefficients (*rhoa) for 
                                                     ! upper canopy stems (m s-1 * kg m-3) (A39a Pollard & Thompson 1995)
   REAL(KIND=r8), INTENT(IN   ) :: cstem	     ! global ! empirical constant in upper canopy stem-air 
                                                              ! aerodynamic transfer coefficient (m s-0.5) (A39a Pollard & Thompson 95)
   REAL(KIND=r8), INTENT(IN   ) :: dstem    (2)	     ! global ! typical linear stem dimension in aerodynamic transfer coefficient (m)
   REAL(KIND=r8), INTENT(INOUT) :: sl       (npoi)   ! local ! air-vegetation transfer coefficients (*rhoa) for 
                                                             ! lower canopy leaves & stems (m s-1*kg m-3) (A39a Pollard & Thompson 1995)
   REAL(KIND=r8), INTENT(IN   ) :: cgrass	     ! global ! empirical constant in lower canopy-air aerodynamic 
                                                              ! transfer coefficient (m s-0.5) (A39a Pollard & Thompson 95)
   REAL(KIND=r8), INTENT(INOUT) :: ciub     (npoi)	 ! global ! intercellular co2 concentration - broadleaf (mol_co2/mol_air)
   REAL(KIND=r8), INTENT(INOUT) :: ciuc     (npoi)	 ! global ! intercellular co2 concentration - conifer	(mol_co2/mol_air)
   REAL(KIND=r8), INTENT(INOUT) :: exist    (npoi,npft)  ! global ! probability of existence of each plant functional type in a gridcell
   REAL(KIND=r8), INTENT(INOUT) :: csub     (npoi)	 ! global ! leaf boundary layer co2 concentration - broadleaf (mol_co2/mol_air)
   REAL(KIND=r8), INTENT(INOUT) :: gsub     (npoi)	 ! global ! upper canopy stomatal conductance - broadleaf  (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: csuc     (npoi)	 ! global ! leaf boundary layer co2 concentration - conifer   (mol_co2/mol_air)
   REAL(KIND=r8), INTENT(INOUT) :: gsuc     (npoi)	 ! global ! upper canopy stomatal conductance - conifer    (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: agcub    (npoi)	 ! local  ! canopy average gross photosynthesis rate - broadleaf  (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: agcuc    (npoi)	 ! local  ! canopy average gross photosynthesis rate - conifer    (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: ancub    (npoi)	 ! local  ! canopy average net photosynthesis rate - broadleaf    (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: ancuc    (npoi)	 ! local  ! canopy average net photosynthesis rate - conifer	  (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: totcondub(npoi)	 ! local  ! 
   REAL(KIND=r8), INTENT(INOUT) :: totconduc(npoi)	 ! local  !
   REAL(KIND=r8), INTENT(INOUT) :: cils     (npoi)	 ! global ! intercellular co2 concentration - shrubs	(mol_co2/mol_air)
   REAL(KIND=r8), INTENT(INOUT) :: cil3     (npoi)	 ! global ! intercellular co2 concentration - c3 plants (mol_co2/mol_air)
   REAL(KIND=r8), INTENT(INOUT) :: cil4     (npoi)	 ! global ! intercellular co2 concentration - c4 plants (mol_co2/mol_air)
   REAL(KIND=r8), INTENT(INOUT) :: csls     (npoi)	 ! global ! leaf boundary layer co2 concentration - shrubs   (mol_co2/mol_air)
   REAL(KIND=r8), INTENT(INOUT) :: gsls     (npoi)	 ! global ! lower canopy stomatal conductance - shrubs     (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: csl3     (npoi)	 ! global ! leaf boundary layer co2 concentration - c3 plants (mol_co2/mol_air)
   REAL(KIND=r8), INTENT(INOUT) :: gsl3     (npoi)	 ! global ! lower canopy stomatal conductance - c3 grasses (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: csl4     (npoi)	 ! global ! leaf boundary layer co2 concentration - c4 plants (mol_co2/mol_air)
   REAL(KIND=r8), INTENT(INOUT) :: gsl4     (npoi)	 ! global ! lower canopy stomatal conductance - c4 grasses (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: agcls    (npoi)	 ! local  ! canopy average gross photosynthesis rate - shrubs	  (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: agcl4    (npoi)	 ! local ! canopy average gross photosynthesis rate - c4 grasses (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: agcl3    (npoi)	 ! local ! canopy average gross photosynthesis rate - c3 grasses (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: ancls    (npoi)	 ! local ! canopy average net photosynthesis rate - shrubs	  (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: ancl4    (npoi)	 ! local ! canopy average net photosynthesis rate - c4 grasses   (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: ancl3    (npoi)	 ! local ! canopy average net photosynthesis rate - c3 grasses   (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: totcondls(npoi)	 ! local ! 
   REAL(KIND=r8), INTENT(INOUT) :: totcondl3(npoi)	 ! local !
   REAL(KIND=r8), INTENT(INOUT) :: totcondl4(npoi)	 ! local !
   REAL(KIND=r8), INTENT(IN   ) :: chu(1:nVegClass)             ! global ! heat capacity of upper canopy leaves per unit leaf area (J kg-1 m-2)
   REAL(KIND=r8), INTENT(IN   ) :: chs(1:nVegClass)             ! global ! heat capacity of upper canopy stems per unit stem area (J kg-1 m-2)
   REAL(KIND=r8), INTENT(IN   ) :: chl(1:nVegClass)             ! global ! heat capacity of lower canopy leaves & stems per unit leaf/stem area (J kg-1 m-2)
   REAL(KIND=r8), INTENT(INOUT) :: frac     (npoi,npft)  ! global ! fraction of canopy occupied by each plant functional type
   REAL(KIND=r8), INTENT(INOUT) :: tlsub    (npoi)	 ! global ! temperature of lower canopy vegetation buried by snow (K)
!      INCLUDE 'comsat.h'    
!      include 'comsno.h'
   REAL(KIND=r8), INTENT(IN   ) :: z0sno  ! global ! roughness length of snow surface (m)
   REAL(KIND=r8), INTENT(IN   ) :: rhos   ! global ! density of snow (kg m-3)
   REAL(KIND=r8), INTENT(IN   ) :: consno ! global ! thermal conductivity of snow (W m-1 K-1)
   REAL(KIND=r8), INTENT(IN   ) :: hsnotop! global ! thickness of top snow layer (m)
   REAL(KIND=r8), INTENT(IN   ) :: hsnomin! global ! minimum total thickness of snow (m)
   REAL(KIND=r8), INTENT(IN   ) :: fimin  ! global ! minimum fractional snow cover
   REAL(KIND=r8), INTENT(IN   ) :: fimax  ! global ! maximum fractional snow cover
   REAL(KIND=r8), INTENT(INOUT) :: fi     (npoi)! global ! fractional snow cover
   REAL(KIND=r8), INTENT(INOUT) :: tsno   (npoi,nsnolay)! global ! temperature of snow layers (K)
   REAL(KIND=r8), INTENT(INOUT) :: hsno   (npoi,nsnolay)! global ! thickness of snow layers (m)

!      INCLUDE 'comsoi.h'
   REAL(KIND=r8), INTENT(IN   ) :: sand    (npoi,nsoilay)! global ! percent sand of soil
   REAL(KIND=r8), INTENT(IN   ) :: clay    (npoi,nsoilay)! global ! percent clay of soil
   REAL(KIND=r8), INTENT(IN   ) :: poros   (npoi,nsoilay)! global ! porosity (mass of h2o per unit vol at sat / rhow)
   REAL(KIND=r8), INTENT(INOUT) :: wsoi    (npoi,nsoilay)! global ! fraction of soil pore space containing liquid water
   REAL(KIND=r8), INTENT(INOUT) :: wisoi   (npoi,nsoilay)! global ! fraction of soil pore space containing ice
   REAL(KIND=r8), INTENT(INOUT) :: consoi  (npoi,nsoilay)! local  ! thermal conductivity of each soil layer (W m-1 K-1)
   REAL(KIND=r8), INTENT(IN   ) :: zwpmax		 ! global ! assumed maximum fraction of soil surface 
   					                          ! covered by puddles (dimensionless)
   REAL(KIND=r8), INTENT(INOUT) :: wpud    (npoi)! global ! liquid content of puddles per soil area (kg m-2)
   REAL(KIND=r8), INTENT(INOUT) :: wipud   (npoi)! global ! ice content of puddles per soil area (kg m-2)
   REAL(KIND=r8), INTENT(IN   ) :: wpudmax	 ! global ! normalization constant for puddles (kg m-2)
   REAL(KIND=r8), INTENT(INOUT) :: qglif   (npoi,4) ! local ! 1: fraction of soil evap (fvapg) from soil liquid
   					! 2: fraction of soil evap (fvapg) from soil ice
   					! 3: fraction of soil evap (fvapg) from puddle liquid
   					! 4: fraction of soil evap (fvapg) from puddle ice
   REAL(KIND=r8), INTENT(INOUT) :: tsoi    (npoi,nsoilay)! global	! soil temperature for each layer (K)
   REAL(KIND=r8), INTENT(INOUT) :: hvasug  (npoi)        ! local ! latent heat of vap/subl, for soil surface (J kg-1)
   REAL(KIND=r8), INTENT(INOUT) :: hvasui  (npoi)        ! local ! latent heat of vap/subl, for snow surface (J kg-1)
   REAL(KIND=r8), INTENT(IN   ) :: albsav  (npoi)        ! global ! saturated soil surface albedo (visible waveband)
   REAL(KIND=r8), INTENT(IN   ) :: albsan  (npoi)        ! global ! saturated soil surface albedo (near-ir waveband)
   REAL(KIND=r8), INTENT(INOUT) :: tg      (npoi)        ! global ! soil skin temperature (K)
   REAL(KIND=r8), INTENT(INOUT) :: ti      (npoi)        ! global ! snow skin temperature (K)
   REAL(KIND=r8), INTENT(IN   ) :: z0soi   (npoi)        ! global ! roughness length of soil surface (m)
   REAL(KIND=r8), INTENT(IN   ) :: swilt   (npoi,nsoilay)! global ! wilting soil moisture value (fraction of pore space)
   REAL(KIND=r8), INTENT(IN   ) :: sfield  (npoi,nsoilay)! global ! field capacity soil moisture value (fraction of pore space)
   REAL(KIND=r8), INTENT(INOUT) :: stressl (npoi,nsoilay)! local ! soil moisture stress factor for the lower canopy (dimensionless)
   REAL(KIND=r8), INTENT(INOUT) :: stressu (npoi,nsoilay)! local ! soil moisture stress factor for the upper canopy (dimensionless)
   REAL(KIND=r8), INTENT(INOUT) :: stresstl(npoi)        ! local ! sum of stressl over all 6 soil layers (dimensionless)
   REAL(KIND=r8), INTENT(INOUT) :: stresstu(npoi)        ! local ! sum of stressu over all 6 soil layers (dimensionless)
   REAL(KIND=r8), INTENT(IN   ) :: csoi    (npoi,nsoilay)! global ! specific heat of soil, no pore spaces (J kg-1 deg-1)
   REAL(KIND=r8), INTENT(IN   ) :: rhosoi  (npoi,nsoilay)! global ! soil density (without pores, not bulk) (kg m-3)
   REAL(KIND=r8), INTENT(IN   ) :: hsoi    (npoi,nsoilay+1)   ! global ! soil layer thickness (m)
   REAL(KIND=r8), INTENT(IN   ) :: suction (npoi,nsoilay)! global ! saturated matric potential (m-h2o)
   REAL(KIND=r8), INTENT(IN   ) :: bex     (npoi,nsoilay)! global ! exponent "b" in soil water potential
   REAL(KIND=r8), INTENT(INOUT) :: upsoiu  (npoi,nsoilay)! local  ! soil water uptake from transpiration (kg_h2o m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: upsoil  (npoi,nsoilay)! local  ! soil water uptake from transpiration (kg_h2o m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: heatg   (npoi)	 ! local  ! net heat flux into soil surface (W m-2)
   REAL(KIND=r8), INTENT(INOUT) :: heati   (npoi)	 ! local  ! net heat flux into snow surface (W m-2)
   REAL(KIND=r8), INTENT(IN   ) :: hydraul (npoi,nsoilay)! global ! saturated hydraulic conductivity (m/s)
   REAL(KIND=r8), INTENT(INOUT) :: porosflo(npoi,nsoilay)! global ! porosity after reduction by ice content
   INTEGER      , INTENT(IN   ) :: ibex    (npoi,nsoilay)! global ! nint(bex), used for cpu speed
   REAL(KIND=r8), INTENT(IN   ) :: bperm    (npoi)       ! global ! lower b.c. for soil profile drainage 
   					                 ! (0.0 = impermeable; 1.0 = fully permeable)
   REAL(KIND=r8), INTENT(INOUT) :: hflo    (npoi,nsoilay+1)  ! downward heat transport through soil layers (W m-2)
 

!   INCLUDE 'comatm.h'
   REAL(KIND=r8), INTENT(IN   ) :: ta     (npoi)	 ! global ! air temperature (K)
   REAL(KIND=r8), INTENT(INOUT) :: asurd  (npoi,nband)   ! local  ! direct albedo of surface system
   REAL(KIND=r8), INTENT(INOUT) :: asuri  (npoi,nband)   ! local  ! diffuse albedo of surface system 
   REAL(KIND=r8), INTENT(IN   ) :: coszen (npoi)	 ! global ! cosine of solar zenith angle
   REAL(KIND=r8), INTENT(IN   ) :: solad  (npoi,nband)   ! global ! direct downward solar flux (W m-2)
   REAL(KIND=r8), INTENT(IN   ) :: solai  (npoi,nband)   ! global ! diffuse downward solar flux (W m-2)
   REAL(KIND=r8), INTENT(IN   ) :: fira   (npoi)	 ! global ! incoming ir flux (W m-2)
   REAL(KIND=r8), INTENT(IN   ) :: raina  (npoi)	 ! global ! rainfall rate (mm/s or kg m-2 s-1)
   REAL(KIND=r8), INTENT(IN   ) :: qa     (npoi)	 ! global ! specific humidity (kg_h2o/kg_air)
   REAL(KIND=r8), INTENT(IN   ) :: psurf  (npoi)	 ! global ! surface pressure (Pa)
   REAL(KIND=r8), INTENT(IN   ) :: snowa  (npoi)	 ! global ! snowfall rate (mm/s or kg m-2 s-1 of water)
   REAL(KIND=r8), INTENT(IN   ) :: ua     (npoi)	 ! global ! wind speed (m s-1)
   REAL(KIND=r8), INTENT(IN   ) :: o2conc		 ! global ! o2 concentration (mol/mol)
   REAL(KIND=r8), INTENT(INOUT) :: co2conc		 ! global ! co2 concentration (mol/mol)
   REAL(KIND=r8), INTENT(INOUT) :: z0(npoi)
   REAL(KIND=r8), INTENT(INOUT) :: ustar(npoi)
   REAL(KIND=r8), INTENT(OUT) :: hc (npoi)
   REAL(KIND=r8), INTENT(OUT) :: hg (npoi)
   REAL(KIND=r8), INTENT(OUT) :: ec (npoi)
   REAL(KIND=r8), INTENT(OUT) :: eg (npoi)
   REAL(KIND=r8), INTENT(INOUT) :: dispu    (npoi)	  ! local ! zero-plane displacement height for upper canopy (m)
   REAL(KIND=r8), INTENT(INOUT) :: cu       (npoi)	  ! local ! air transfer coefficient (*rhoa) (m s-1 kg m-3) for
                		          !         upper air region (z12 --> za) (A35 Pollard & Thompson 1995)
   REAL(KIND=r8), INTENT(INOUT) :: firb     (npoi)	  ! local ! net upward ir radiation at reference
          			                  ! atmospheric level za (W m-2)
   REAL(KIND=r8), INTENT(OUT) :: bstar(npoi)

   REAL(KIND=r8), INTENT(INOUT) :: ynleach_p (npoi) ! annual total amount P leached from soil profile (kg_N m-2/yr)
   REAL(KIND=r8), INTENT(OUT  ) :: tnmin_p   (npoi)   ! instantaneous phosphorus mineralization         (kg_N m-2/timestep)
   REAL(KIND=r8), INTENT(OUT  ) :: totnmic_p (npoi)   ! total phosphorus residing in microbial pool     (kg_N m-2)
   REAL(KIND=r8), INTENT(OUT  ) :: totnlit_p (npoi)   ! total phosphorus in all litter pools            (kg_N m-2)
   REAL(KIND=r8), INTENT(OUT  ) :: totanlit_p(npoi)   ! total standing aboveground phosphorus in litter (kg_N m-2)
   REAL(KIND=r8), INTENT(OUT  ) :: totrnlit_p(npoi)   ! total root litter phosphorus belowground        (kg_N m-2)
   REAL(KIND=r8), INTENT(OUT  ) :: totnsoi_p (npoi)   ! total phosphorus in soil                        (kg_N m-2)
   REAL(KIND=r8), INTENT(INOUT) :: storedn_p (npoi)   ! total storage of P in soil profile (kg_N m-2) 


!   INCLUDE 'com1d.h'
   REAL(KIND=r8) :: fwetu    (npoi)	  ! local ! fraction of upper canopy leaf area wetted by intercepted liquid and/or snow
   REAL(KIND=r8) :: rliqu    (npoi)	  ! local ! proportion of fwetu due to liquid
   REAL(KIND=r8) :: fwets    (npoi)	  ! local ! fraction of upper canopy stem area wetted by intercepted liquid and/or snow
   REAL(KIND=r8) :: rliqs    (npoi)	  ! local ! proportion of fwets due to liquid
   REAL(KIND=r8) :: fwetl    (npoi)	  ! local ! fraction of lower canopy stem & leaf area wetted by
          			          !         intercepted liquid and/or snow
   REAL(KIND=r8) :: rliql    (npoi)	  ! local ! proportion of fwetl due to liquid
   REAL(KIND=r8) :: solu     (npoi)	  ! local ! solar flux (direct + diffuse) absorbed by upper 
          			          !         canopy leaves per unit canopy area (W m-2)
   REAL(KIND=r8) :: sols     (npoi)	  ! local ! solar flux (direct + diffuse) absorbed by upper 
          			          !         canopy stems per unit canopy area (W m-2)
   REAL(KIND=r8) :: soll     (npoi)	  ! local ! solar flux (direct + diffuse) absorbed by lower 
          			          !         canopy leaves and stems per unit canopy area (W m-2)
   REAL(KIND=r8) :: solg     (npoi)	  ! local ! solar flux (direct + diffuse) absorbed by unit 
          			          !         snow-free soil (W m-2)
   REAL(KIND=r8) :: soli     (npoi)	  ! local ! solar flux (direct + diffuse) absorbed by unit 
                                                  ! snow surface (W m-2)
   REAL(KIND=r8) :: scalcoefl(npoi,4)     ! local ! term needed in lower canopy scaling
   REAL(KIND=r8) :: scalcoefu(npoi,4)     ! local ! term needed in upper canopy scaling
   INTEGER :: indsol   (npoi)	          ! local ! index of current strip for points with positive coszen
   REAL(KIND=r8) :: albsod   (npoi)	  ! local ! direct  albedo for soil surface (visible or IR)
   REAL(KIND=r8) :: albsoi   (npoi)	  ! local ! diffuse albedo for soil surface (visible or IR)
   REAL(KIND=r8) :: albsnd   (npoi)	  ! local ! direct  albedo for snow surface (visible or IR)
   REAL(KIND=r8) :: albsni   (npoi)	  ! local ! diffuse albedo for snow surface (visible or IR)
   REAL(KIND=r8) :: relod    (npoi)	  ! local ! upward direct radiation per unit icident direct beam on lower canopy (W m-2)
   REAL(KIND=r8) :: reloi    (npoi)	  ! local ! upward diffuse radiation per unit incident diffuse 
                                                  ! radiation on lower canopy (W m-2)
   REAL(KIND=r8) :: reupd    (npoi)	  ! local ! upward direct radiation per unit incident direct 
          			                  ! radiation on upper canopy (W m-2)
   REAL(KIND=r8) :: reupi    (npoi)	  ! local ! upward diffuse radiation per unit incident diffuse 
          			                  ! radiation on upper canopy (W m-2)
   REAL(KIND=r8) :: ablod    (npoi)	  ! local ! fraction of direct  radiation absorbed by lower canopy
   REAL(KIND=r8) :: abloi    (npoi)	  ! local ! fraction of diffuse radiation absorbed by lower canopy
   REAL(KIND=r8) :: flodd    (npoi)	  ! local ! downward direct radiation per unit incident direct
          			                  ! radiation on lower canopy (W m-2)
   REAL(KIND=r8) :: dummy    (npoi)	  ! local ! placeholder, always = 0: no direct flux produced for diffuse incident
   REAL(KIND=r8) :: flodi    (npoi)	  ! local ! downward diffuse radiation per unit incident direct
          			                  ! radiation on lower canopy (W m-2)
   REAL(KIND=r8) :: floii    (npoi)	  ! local ! downward diffuse radiation per unit incident 
          			                  ! diffuse radiation on lower canopy
   REAL(KIND=r8) :: terml    (npoi,7)     ! local ! term needed in lower canopy scaling
   REAL(KIND=r8) :: termu    (npoi,7)     ! local ! term needed in upper canopy scaling
   REAL(KIND=r8) :: abupd    (npoi)	  ! local ! fraction of direct  radiation absorbed by upper canopy
   REAL(KIND=r8) :: abupi    (npoi)	  ! local ! fraction of diffuse radiation absorbed by upper canopy
   REAL(KIND=r8) :: fupdd    (npoi)	  ! local ! downward direct radiation per unit incident direct
          			                  ! beam on upper canopy (W m-2)
   REAL(KIND=r8) :: fupdi    (npoi)	  ! local ! downward diffuse radiation per unit icident direct
          			                  ! radiation on upper canopy (W m-2)
   REAL(KIND=r8) :: fupii    (npoi)	  ! local ! downward diffuse radiation per unit incident diffuse
          			                  ! radiation on upper canopy (W m-2)
   REAL(KIND=r8) :: sol2d    (npoi)	  ! local ! direct downward radiation  out of upper canopy 
          			                  ! per unit vegetated (upper) area (W m-2)
   REAL(KIND=r8) :: sol2i    (npoi)	  ! local ! diffuse downward radiation out of upper
          			                  ! canopy per unit vegetated (upper) area(W m-2)
   REAL(KIND=r8) :: sol3d    (npoi)	  ! local ! direct downward radiation  out of upper
          			                  ! canopy + gaps per unit grid cell area (W m-2)
   REAL(KIND=r8) :: sol3i    (npoi)	  ! local ! diffuse downward radiation out of upper
          			                  ! canopy + gaps per unit grid cell area (W m-2)
   REAL(KIND=r8) :: firs     (npoi)	  ! local ! ir radiation absorbed by upper canopy stems (W m-2)
   REAL(KIND=r8) :: firu     (npoi)	  ! local ! ir raditaion absorbed by upper canopy leaves (W m-2)
   REAL(KIND=r8) :: firl     (npoi)	  ! local ! ir radiation absorbed by lower canopy leaves and stems (W m-2)
   REAL(KIND=r8) :: firg     (npoi)	  ! local ! ir radiation absorbed by soil/ice (W m-2)
   REAL(KIND=r8) :: firi     (npoi)	  ! local ! ir radiation absorbed by snow (W m-2)
   REAL(KIND=r8) :: snowg    (npoi)	  ! local ! snowfall rate at soil level (kg h2o m-2 s-1)
   REAL(KIND=r8) :: tsnowg   (npoi)	  ! local ! snowfall temperature at soil level (K) 
   REAL(KIND=r8) :: tsnowl   (npoi)	  ! local ! snowfall temperature below upper canopy (K)
   REAL(KIND=r8) :: pfluxl   (npoi)	  ! local ! heat flux on lower canopy leaves & stems due to intercepted h2o (W m-2)
   REAL(KIND=r8) :: raing    (npoi)	  ! local ! rainfall rate at soil level (kg m-2 s-1)
   REAL(KIND=r8) :: traing   (npoi)	  ! local ! rainfall temperature at soil level (K)
   REAL(KIND=r8) :: trainl   (npoi)	  ! local ! rainfall temperature below upper canopy (K)
   REAL(KIND=r8) :: snowl    (npoi)	  ! local ! snowfall rate below upper canopy (kg h2o m-2 s-1)
   REAL(KIND=r8) :: tsnowu   (npoi)	  ! local ! snowfall temperature above upper canopy (K)
   REAL(KIND=r8) :: pfluxu   (npoi)	  ! local ! heat flux on upper canopy leaves due to intercepted h2o (W m-2)
   REAL(KIND=r8) :: rainu    (npoi)	  ! local ! rainfall rate above upper canopy (kg m-2 s-1)
   REAL(KIND=r8) :: trainu   (npoi)	  ! local ! rainfall temperature above upper canopy (K)
   REAL(KIND=r8) :: snowu    (npoi)	  ! local ! snowfall rate above upper canopy (kg h2o m-2 s-1)
   REAL(KIND=r8) :: pfluxs   (npoi)	  ! local ! heat flux on upper canopy stems due to intercepted h2o (W m-2)
   REAL(KIND=r8) :: rainl    (npoi)	  ! local ! rainfall rate below upper canopy (kg m-2 s-1)
   REAL(KIND=r8) :: cp       (npoi)	  ! local ! specific heat of air at za (allowing for h2o vapor) (J kg-1 K-1)
   REAL(KIND=r8) :: bdl      (npoi)	  ! local ! aerodynamic coefficient ([(tau/rho)/u**2] for
                                                  ! laower canopy (A31/A30 Pollard & Thompson 1995)
   REAL(KIND=r8) :: dil      (npoi)	  ! local ! inverse of momentum diffusion coefficient within lower canopy (m)
   REAL(KIND=r8) :: z3       (npoi)	  ! local ! effective top of the lower canopy (for momentum) (m)
   REAL(KIND=r8) :: z4       (npoi)	  ! local ! effective bottom of the lower canopy (for momentum) (m)
   REAL(KIND=r8) :: z34      (npoi)	  ! local ! effective middle of the lower canopy (for momentum) (m)
   REAL(KIND=r8) :: exphl    (npoi)	  ! local ! exp(lamda/2*(z3-z4)) for lower canopy (A30 Pollard & Thompson)
   REAL(KIND=r8) :: expl     (npoi)	  ! local ! exphl**2
   REAL(KIND=r8) :: displ    (npoi)	  ! local ! zero-plane displacement height for lower canopy (m)
   REAL(KIND=r8) :: bdu      (npoi)	  ! local ! aerodynamic coefficient ([(tau/rho)/u**2] for upper
                                                  ! canopy (A31/A30 Pollard & Thompson 1995)
   REAL(KIND=r8) :: diu      (npoi)	  ! local ! inverse of momentum diffusion coefficient within upper canopy (m)
   REAL(KIND=r8) :: z1       (npoi)	  ! local ! effective top of upper canopy (for momentum) (m)
   REAL(KIND=r8) :: z2       (npoi)	  ! local ! effective bottom of the upper canopy (for momentum) (m)
   REAL(KIND=r8) :: z12      (npoi)	  ! local ! effective middle of the upper canopy (for momentum) (m)
   REAL(KIND=r8) :: exphu    (npoi)	  ! local ! exp(lamda/2*(z3-z4)) for upper canopy (A30 Pollard & Thompson)
   REAL(KIND=r8) :: expu     (npoi)	  ! local ! exphu**2
   REAL(KIND=r8) :: alogg    (npoi)	  ! local ! log of soil roughness
   REAL(KIND=r8) :: alogi    (npoi)	  ! local ! log of snow roughness
   REAL(KIND=r8) :: alogav   (npoi)	  ! local ! average of alogi and alogg 
   REAL(KIND=r8) :: alog4    (npoi)	  ! local ! log (max(z4, 1.1*z0sno, 1.1*z0soi)) 
   REAL(KIND=r8) :: alog3    (npoi)	  ! local ! log (z3 - displ)
   REAL(KIND=r8) :: alog2    (npoi)	  ! local ! log (z2 - displ)
   REAL(KIND=r8) :: alog1    (npoi)	  ! local ! log (z1 - dispu) 
   REAL(KIND=r8) :: aloga    (npoi)	  ! local ! log (za - dispu) 
   REAL(KIND=r8) :: u2       (npoi)	  ! local ! wind speed at level z2 (m s-1)
   REAL(KIND=r8) :: alogu    (npoi)	  ! local ! log (roughness length of upper canopy)
   REAL(KIND=r8) :: alogl    (npoi)	  ! local ! log (roughness length of lower canopy)
   REAL(KIND=r8) :: richl    (npoi)	  ! local ! richardson number for air above upper canopy (z3 to z2)
   REAL(KIND=r8) :: straml   (npoi)	  ! local ! momentum correction factor for stratif between
                                                  ! upper & lower canopy (z3 to z2) (louis et al.)
   REAL(KIND=r8) :: strahl   (npoi)	  ! local ! heat/vap correction factor for stratif between
                		          !         upper & lower canopy (z3 to z2) (louis et al.)
   REAL(KIND=r8) :: richu    (npoi)	  ! local ! richardson number for air between upper & lower canopy (z1 to za)
   REAL(KIND=r8) :: stramu   (npoi)	  ! local ! momentum correction factor for stratif above
                		          !         upper canopy (z1 to za) (louis et al.)
   REAL(KIND=r8) :: strahu   (npoi)	  ! local ! heat/vap correction factor for stratif above
                		          !         upper canopy (z1 to za) (louis et al.)
   REAL(KIND=r8) :: u1       (npoi)	  ! local ! wind speed at level z1 (m s-1)
   REAL(KIND=r8) :: u12      (npoi)	  ! local ! wind speed at level z12 (m s-1)
   REAL(KIND=r8) :: u3       (npoi)	  ! local ! wind speed at level z3 (m s-1)
   REAL(KIND=r8) :: u34      (npoi)	  ! local ! wind speed at level z34 (m s-1)
   REAL(KIND=r8) :: u4       (npoi)	  ! local ! wind speed at level z4 (m s-1)
   REAL(KIND=r8) :: cl       (npoi)	  ! local ! air transfer coefficient (*rhoa) (m s-1 kg m-3)
                		          !         between the 2 canopies (z34 --> z12) (A36 Pollard & Thompson 1995)
   REAL(KIND=r8) :: sg       (npoi)	  ! local ! air-soil transfer coefficient
   REAL(KIND=r8) :: si       (npoi)	  ! local ! air-snow transfer coefficient
   REAL(KIND=r8) :: fwetux   (npoi)	  ! local ! fraction of upper canopy leaf area wetted if dew forms
   REAL(KIND=r8) :: fwetsx   (npoi)	  ! local ! fraction of upper canopy stem area wetted if dew forms
   REAL(KIND=r8) :: fwetlx   (npoi)	  ! local ! fraction of lower canopy leaf and stem area wetted if dew forms
   REAL(KIND=r8) :: fsena    (npoi)	  ! local ! downward sensible heat flux between za & z12 at za (W m-2)
   REAL(KIND=r8) :: fseng    (npoi)	  ! local ! upward sensible heat flux between soil surface & air at z34 (W m-2)
   REAL(KIND=r8) :: fseni    (npoi)	  ! local ! upward sensible heat flux between snow surface & air at z34 (W m-2)
   REAL(KIND=r8) :: fsenu    (npoi)	  ! local ! sensible heat flux from upper canopy leaves to air (W m-2)
   REAL(KIND=r8) :: fsens    (npoi)	  ! local ! sensible heat flux from upper canopy stems to air (W m-2)
   REAL(KIND=r8) :: fsenl    (npoi)	  ! local ! sensible heat flux from lower canopy to air (W m-2)
   REAL(KIND=r8) :: fvapa    (npoi)	  ! local ! downward h2o vapor flux between za & z12 at za (kg m-2 s-1)
   REAL(KIND=r8) :: fvaput   (npoi)	  ! local ! h2o vapor flux (transpiration from dry parts) 
						  ! between upper canopy leaves and air at z12 (kg m-2 s-1/ LAI upper canopy/ fu)
   REAL(KIND=r8) :: fvaps    (npoi)       ! local ! h2o vapor flux (evaporation from wet surface)
		 	     	          !	    between upper canopy stems and air at z12 (kg m-2 s-1 / SAI lower canopy / fu)
   REAL(KIND=r8) :: fvaplw   (npoi)       ! local ! h2o vapor flux (evaporation from wet surface) 
	  		     	          !	    between lower canopy leaves & stems and air at z34 (kg m-2 s-1/ LAI lower canopy/ fl)
   REAL(KIND=r8) :: fvaplt   (npoi)       ! local ! h2o vapor flux (transpiration) 
	  		     	          !	    between lower canopy & air at z34 (kg m-2 s-1 / LAI lower canopy / fl)
   REAL(KIND=r8) :: fvapg    (npoi)       ! local ! h2o vapor flux (evaporation) between soil & air 
	  		     	          !         at z34 (kg m-2 s-1/bare ground fraction)
   REAL(KIND=r8) :: fvapi    (npoi)       ! local ! h2o vapor flux (evaporation) between snow & air at z34 (kg m-2 s-1 / fi )
   REAL(KIND=r8) :: fvapuw   (npoi)       ! local ! h2o vapor flux (evaporation from wet parts)
                                                  ! between upper canopy leaves and air at z12 (kg m-2 s-1/ LAI upper canopy/ fu)
   REAL(KIND=r8), INTENT(INOUT) :: td (npoi)   ! global! daily average temperature (K)
   REAL(KIND=r8), INTENT(IN   ) :: vzero(npoi) ! global! a real array of zeros, of length npoi

   INTEGER, INTENT(IN   ) :: ndaypy               ! global! number of days per year
   REAL(KIND=r8), INTENT(OUT  ) :: nppdummy (npoi,npft)! local ! canopy NPP before accounting for stem and root respiration
   REAL(KIND=r8) :: tgpp     (npoi,npft)                 ! local ! instantaneous GPP for each pft (mol-CO2 / m-2 / second)
   REAL(KIND=r8), INTENT(OUT  ) :: tgpptot  (npoi)	                 ! local ! instantaneous gpp (mol-CO2 / m-2 / second)
   REAL(KIND=r8) :: tnpp     (npoi,npft)                 ! local ! instantaneous NPP for each pft (mol-CO2 / m-2 / second)
   REAL(KIND=r8), INTENT(INOUT) :: cbiow    (npoi,npft)  ! global! carbon in woody biomass pool (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: sapfrac  (npoi)	 ! global! fraction of woody biomass that is in sapwood
   REAL(KIND=r8), INTENT(INOUT) :: cbior    (npoi,npft)  ! global! carbon in fine root biomass pool (kg_C m-2)
   REAL(KIND=r8), INTENT(OUT  ) :: tnpptot  (npoi)	                 ! local ! instantaneous npp (mol-CO2 / m-2 / second)
   REAL(KIND=r8), INTENT(INOUT) :: tco2root (npoi)	 ! local ! instantaneous fine co2 flux from soil (mol-CO2 / m-2 / second)
   REAL(KIND=r8), INTENT(OUT  ) :: tneetot  (npoi)	 ! local ! instantaneous net ecosystem exchange of co2 per timestep (kg_C m-2/timestep)
   REAL(KIND=r8), INTENT(INOUT) :: tco2mic  (npoi)	 ! local ! instantaneous microbial co2 flux from soil (mol-CO2 / m-2 / second)
   REAL(KIND=r8), INTENT(INOUT) :: a10td    (npoi)       ! global! 10-day average daily air temperature (K)
   REAL(KIND=r8), INTENT(INOUT) :: a10ancub (npoi)       ! global! 10-day average canopy photosynthesis rate - broadleaf (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: a10ancuc (npoi)       ! global! 10-day average canopy photosynthesis rate - conifer (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: a10ancls (npoi)       ! global! 10-day average canopy photosynthesis rate - shrubs (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: a10ancl3 (npoi)       ! global! 10-day average canopy photosynthesis rate - c3 grasses (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: a10ancl4 (npoi)       ! global! 10-day average canopy photosynthesis rate - c4 grasses (mol_co2 m-2 s-1)

   INTEGER, INTENT(INOUT) :: ndtimes	(npoi)! global! counter for daily average calculations
   REAL(KIND=r8), INTENT(INOUT) :: adrain    (npoi)! global! daily average rainfall rate (mm/day)
   REAL(KIND=r8), INTENT(INOUT) :: adsnow    (npoi)! global! daily average snowfall rate (mm/day)
   REAL(KIND=r8), INTENT(INOUT) :: adaet     (npoi)! global! daily average aet (mm/day)
   REAL(KIND=r8), INTENT(INOUT) :: adtrunoff (npoi)! global! daily average total runoff (mm/day)
   REAL(KIND=r8), INTENT(INOUT) :: adsrunoff (npoi)! global! daily average surface runoff (mm/day)
   REAL(KIND=r8), INTENT(INOUT) :: addrainage(npoi)! global! daily average drainage (mm/day)
   REAL(KIND=r8), INTENT(INOUT) :: adrh      (npoi)! global! daily average rh (percent)
   REAL(KIND=r8), INTENT(INOUT) :: adsnod    (npoi)! global! daily average snow depth (m)
   REAL(KIND=r8), INTENT(INOUT) :: adsnof    (npoi)! global! daily average snow fraction (fraction)
   REAL(KIND=r8), INTENT(INOUT) :: adwsoi    (npoi)! global! daily average soil moisture (fraction)
   REAL(KIND=r8), INTENT(INOUT) :: adtsoi    (npoi)! global! daily average soil temperature (c)
   REAL(KIND=r8), INTENT(INOUT) :: adwisoi   (npoi)! global! daily average soil ice (fraction)
   REAL(KIND=r8), INTENT(INOUT) :: adtlaysoi (npoi)! global! daily average soil temperature (c) of top layer
   REAL(KIND=r8), INTENT(INOUT) :: adwlaysoi (npoi)! global! daily average soil moisture of top layer(fraction)
   REAL(KIND=r8), INTENT(INOUT) :: adwsoic   (npoi)! global! daily average soil moisture using root profile weighting (fraction)
   REAL(KIND=r8), INTENT(INOUT) :: adtsoic   (npoi)! global! daily average soil temperature (c) using profile weighting
   REAL(KIND=r8), INTENT(INOUT) :: adco2mic  (npoi)! global! daily accumulated co2 respiration from microbes (kg_C m-2 /day)
   REAL(KIND=r8), INTENT(INOUT) :: adco2root (npoi)! global! daily accumulated co2 respiration from roots (kg_C m-2 /day)
   REAL(KIND=r8), INTENT(INOUT) :: adco2soi  (npoi)! global! daily accumulated co2 respiration from soil(total) (kg_C m-2 /day)
   REAL(KIND=r8), INTENT(INOUT) :: adco2ratio(npoi)! global! ratio of root to total co2 respiration
   REAL(KIND=r8), INTENT(INOUT) :: adnmintot (npoi)! global! daily accumulated net nitrogen mineralization (kg_N m-2 /day)
   REAL(KIND=r8), INTENT(INOUT) :: decompl   (npoi)! global! litter decomposition factor	      (dimensionless)
   REAL(KIND=r8), INTENT(INOUT) :: decomps   (npoi)! global! soil organic matter decomposition factor      (dimensionless)
   REAL(KIND=r8), INTENT(INOUT) :: tnmin     (npoi)! global! instantaneous nitrogen mineralization (kg_N m-2/timestep)

   INTEGER, INTENT(IN   ) :: ndaypm          (12)          ! global! number of days per month

   INTEGER, INTENT(INOUT) :: nmtimes	(npoi)                   ! global! counter for monthly average calculations
   REAL(KIND=r8), INTENT(INOUT) :: amrain	(npoi)     ! global! monthly average rainfall rate (mm/day)
   REAL(KIND=r8), INTENT(INOUT) :: amsnow	(npoi)     ! global! monthly average snowfall rate (mm/day)
   REAL(KIND=r8), INTENT(INOUT) :: amaet	(npoi)     ! global! monthly average aet (mm/day)
   REAL(KIND=r8), INTENT(INOUT) :: amtrunoff    (npoi)     ! global! monthly average total runoff (mm/day)
   REAL(KIND=r8), INTENT(INOUT) :: amsrunoff    (npoi)     ! global! monthly average surface runoff (mm/day)
   REAL(KIND=r8), INTENT(INOUT) :: amdrainage   (npoi)     ! global! monthly average drainage (mm/day)
   REAL(KIND=r8), INTENT(INOUT) :: amtemp	(npoi)     ! global! monthly average air temperature (C)
   REAL(KIND=r8), INTENT(INOUT) :: amqa         (npoi)     ! global! monthly average specific humidity (kg-h2o/kg-air)
   REAL(KIND=r8), INTENT(INOUT) :: amsolar	(npoi)     ! global! monthly average incident solar radiation (W/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: amirup	(npoi)     ! global! monthly average upward ir radiation (W/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: amirdown     (npoi)     ! global! monthly average downward ir radiation (W/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: amsens	(npoi)     ! global! monthly average sensible heat flux (W/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: amlatent     (npoi)     ! global! monthly average latent heat flux (W/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: amlaiu	(npoi)     ! global! monthly average lai for upper canopy (m**2/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: amlail	(npoi)     ! global! monthly average lai for lower canopy (m**2/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: amtsoi	(npoi)     ! global! monthly average 1m soil temperature (C)
   REAL(KIND=r8), INTENT(INOUT) :: amwsoi	(npoi)     ! global! monthly average 1m soil moisture (fraction)
   REAL(KIND=r8), INTENT(INOUT) :: amwisoi	(npoi)     ! global! monthly average 1m soil ice (fraction)
   REAL(KIND=r8), INTENT(INOUT) :: amvwc	(npoi)     ! global! monthly average 1m volumetric water content (fraction)
   REAL(KIND=r8), INTENT(INOUT) :: amawc	(npoi)     ! global! monthly average 1m plant-available water content (fraction)
   REAL(KIND=r8), INTENT(INOUT) :: amsnod	(npoi)     ! global! monthly average snow depth (m)
   REAL(KIND=r8), INTENT(INOUT) :: amsnof	(npoi)     ! global! monthly average snow fraction (fraction)
   REAL(KIND=r8), INTENT(INOUT) :: amnpp	(npoi,npft)! global! monthly total npp for each plant type (kg-C/m**2/month)
   REAL(KIND=r8), INTENT(INOUT) :: adnpp	(npoi,npft)! global! daily  total npp for each plant type (kg-C/m**2/day)
   REAL(KIND=r8), INTENT(OUT  ) :: amnpptot     (npoi)     ! local ! monthly total npp for ecosystem (kg-C/m**2/month)
   REAL(KIND=r8), INTENT(INOUT) :: amco2mic     (npoi)     ! global! monthly total CO2 flux from microbial respiration (kg-C/m**2/month)
   REAL(KIND=r8), INTENT(INOUT) :: amco2root    (npoi)     ! global! monthly total CO2 flux from soil due to root
                                                                   ! respiration (kg-C/m**2/month)
   REAL(KIND=r8), INTENT(OUT  ) :: amco2soi     (npoi)     ! local ! monthly total soil CO2 flux from microbial
   				                                   ! and root respiration (kg-C/m**2/month)
   REAL(KIND=r8), INTENT(OUT  ) :: amco2ratio   (npoi)       ! local ! monthly ratio of root to total co2 flux
   REAL(KIND=r8), INTENT(OUT  ) :: amneetot     (npoi)       ! local ! monthly total net ecosystem exchange of CO2 (kg-C/m**2/month)
   REAL(KIND=r8), INTENT(INOUT) :: amnmintot    (npoi)       ! global! monthly total N mineralization from microbes (kg-N/m**2/month)
   REAL(KIND=r8), INTENT(INOUT) :: amts2        (npoi)       ! global
   REAL(KIND=r8), INTENT(INOUT) :: amtransu     (npoi)       ! global
   REAL(KIND=r8), INTENT(INOUT) :: amtransl     (npoi)       ! global
   REAL(KIND=r8), INTENT(INOUT) :: amsuvap      (npoi)       ! global
   REAL(KIND=r8), INTENT(INOUT) :: aminvap      (npoi)       ! global
   REAL(KIND=r8), INTENT(INOUT) :: amalbedo     (npoi)	 
   REAL(KIND=r8), INTENT(INOUT) :: amtsoil    (npoi, nsoilay) 
   REAL(KIND=r8), INTENT(INOUT) :: amwsoil    (npoi, nsoilay) 
   REAL(KIND=r8), INTENT(INOUT) :: amwisoil   (npoi, nsoilay)

   INTEGER, INTENT(INOUT) :: nytimes (npoi)                ! global! counter for yearly average calculations
   REAL(KIND=r8), INTENT(INOUT) :: aysolar	(npoi)     ! global! annual average incident solar radiation (w/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: ayirup	(npoi)     ! global! annual average upward ir radiation (w/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: ayirdown   (npoi)       ! global! annual average downward ir radiation (w/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: aysens	(npoi)     ! global! annual average sensible heat flux (w/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: aylatent   (npoi)       ! global! annual average latent heat flux (w/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: ayprcp	(npoi)     ! global! annual average precipitation (mm/yr)
   REAL(KIND=r8), INTENT(INOUT) :: ayaet	(npoi)     ! global! annual average aet (mm/yr)
   REAL(KIND=r8), INTENT(INOUT) :: aytrans	(npoi)     ! global! annual average transpiration (mm/yr)
   REAL(KIND=r8), INTENT(INOUT) :: aytrunoff  (npoi)       ! global! annual average total runoff (mm/yr)
   REAL(KIND=r8), INTENT(INOUT) :: aysrunoff  (npoi)       ! global! annual average surface runoff (mm/yr)
   REAL(KIND=r8), INTENT(INOUT) :: aydrainage (npoi)       ! global! annual average drainage (mm/yr)
   REAL(KIND=r8), INTENT(INOUT) :: aydwtot	(npoi)     ! global! annual average soil+vegetation+snow water 
                                                                   ! recharge (mm/yr or kg_h2o/m**2/yr)
   REAL(KIND=r8), INTENT(INOUT) :: aywsoi	(npoi)     ! global! annual average 1m soil moisture (fraction)
   REAL(KIND=r8), INTENT(INOUT) :: aywisoi	(npoi)     ! global! annual average 1m soil ice (fraction)
   REAL(KIND=r8), INTENT(INOUT) :: aytsoi	(npoi)     ! global! annual average 1m soil temperature (C)
   REAL(KIND=r8), INTENT(INOUT) :: ayvwc	(npoi)     ! global! annual average 1m volumetric water content (fraction)
   REAL(KIND=r8), INTENT(INOUT) :: ayawc	(npoi)     ! global! annual average 1m plant-available water content (fraction)
   REAL(KIND=r8), INTENT(INOUT) :: aystresstu (npoi)       ! global! annual average soil moisture stress 
   						                   ! parameter for upper canopy (dimensionless)
   REAL(KIND=r8), INTENT(INOUT) :: aystresstl(npoi)        ! global! annual average soil moisture stress 
   				                                   ! parameter for lower canopy (dimensionless)
   REAL(KIND=r8), INTENT(INOUT) :: aygpp     (npoi,npft)   ! global! annual gross npp for each plant type(kg-c/m**2/yr)
   REAL(KIND=r8), INTENT(OUT  ) :: aygpptot  (npoi)        ! local ! annual total gpp for ecosystem (kg-c/m**2/yr)
   REAL(KIND=r8), INTENT(INOUT) :: aynpp     (npoi,npft)   ! global! annual total npp for each plant type(kg-c/m**2/yr)
   REAL(KIND=r8), INTENT(OUT  ) :: aynpptot  (npoi)        ! local ! annual total npp for ecosystem (kg-c/m**2/yr)
   REAL(KIND=r8), INTENT(INOUT) :: ayco2mic  (npoi)        ! global! annual total CO2 flux from microbial respiration (kg-C/m**2/yr)
   REAL(KIND=r8), INTENT(INOUT) :: ayco2root (npoi)        ! global! annual total CO2 flux from soil due to root respiration (kg-C/m**2/yr)
   REAL(KIND=r8), INTENT(OUT  ) :: ayco2soi  (npoi)        ! local ! annual total soil CO2 flux from microbial and 
                                                                   ! root respiration (kg-C/m**2/yr)
   REAL(KIND=r8), INTENT(OUT  ) :: ayneetot  (npoi)        ! local ! annual total NEE for ecosystem (kg-C/m**2/yr)
   REAL(KIND=r8), INTENT(INOUT) :: ayrootbio (npoi)        ! global! annual average live root biomass (kg-C / m**2)
   REAL(KIND=r8), INTENT(INOUT) :: aynmintot (npoi)        ! global! annual total nitrogen mineralization (kg-N/m**2/yr)
   REAL(KIND=r8), INTENT(INOUT) :: ayalit    (npoi)        ! global! aboveground litter (kg-c/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: ayblit    (npoi)        ! global! belowground litter (kg-c/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: aycsoi    (npoi)        ! global! total soil carbon (kg-c/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: aycmic    (npoi)        ! global! total soil carbon in microbial biomass (kg-c/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: ayanlit   (npoi)        ! global! aboveground litter nitrogen (kg-N/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: aybnlit   (npoi)        ! global! belowground litter nitrogen (kg-N/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: aynsoi    (npoi)        ! global! total soil nitrogen (kg-N/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: ayalbedo  (npoi)
   REAL(KIND=r8), INTENT(INOUT) :: totalit   (npoi)	   ! global! total standing aboveground litter (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: totrlit   (npoi)	   ! global! total root litter carbon belowground (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: totcsoi   (npoi)	   ! global! total carbon in all soil pools (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: totcmic   (npoi)	   ! global! total carbon residing in microbial pools (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: totanlit  (npoi)	   ! global! total standing aboveground nitrogen in litter (kg_N m-2)
   REAL(KIND=r8), INTENT(INOUT) :: totrnlit  (npoi)        ! global! total root litter nitrogen belowground (kg_N m-2)
   REAL(KIND=r8), INTENT(INOUT) :: totnsoi   (npoi)        ! global! total nitrogen in soil (kg_N m-2)
   REAL(KIND=r8), INTENT(OUT  ) :: totnmic   (npoi)        ! local! total nitrogen residing in microbial pool (kg_N m-2)
   REAL(KIND=r8), INTENT(INOUT) :: totlit    (npoi)        ! local! total carbon in all litter pools (kg_C m-2)
   REAL(KIND=r8), INTENT(OUT  ) :: totfall   (npoi)        ! local! total litterfall and root turnover (kg_C m-2/year)
   REAL(KIND=r8), INTENT(OUT  ) :: totnlit   (npoi)        ! local! total nitrogen in all litter pools (kg_N m-2)

   REAL(KIND=r8), INTENT(INOUT) :: firefac   (npoi)        ! global! factor that respresents the annual average
   REAL(KIND=r8), INTENT(INOUT) :: wtot      (npoi)        ! global! total amount of water stored in snow, soil,
                                                                   ! puddels, and on vegetation (kg_h2o)
   						                   ! fuel dryness of a grid cell, and hence characterizes the readiness to burn

   REAL(KIND=r8), INTENT(INOUT) :: storedn (npoi)	   ! global! total storage of N in soil profile (kg_N m-2) 
   REAL(KIND=r8), INTENT(INOUT) :: yrleach (npoi)	   ! global! annual total amount C leached from soil profile (kg_C m-2/yr)
   REAL(KIND=r8), INTENT(INOUT) :: ynleach (npoi)
   REAL(KIND=r8), INTENT(INOUT) :: falll   (npoi)          ! global ! annual leaf litter fall (kg_C m-2/year)
   REAL(KIND=r8), INTENT(INOUT) :: fallr   (npoi)          ! global ! annual root litter input		    (kg_C m-2/year)
   REAL(KIND=r8), INTENT(INOUT) :: fallw   (npoi)          ! global ! annual wood litter fall		    (kg_C m-2/year)
   REAL(KIND=r8), INTENT(INOUT) :: clitlm  (npoi)          ! global! carbon in leaf litter pool - metabolic       (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: clitls  (npoi)          ! global! carbon in leaf litter pool - structural      (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: clitrm  (npoi)          ! global! carbon in fine root litter pool - metabolic  (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: clitrs  (npoi)          ! global! carbon in fine root litter pool - structural (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: clitwm  (npoi)          ! global! carbon in woody litter pool - metabolic      (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: clitws  (npoi)          ! global! carbon in woody litter pool - structural     (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: csoislop(npoi)          ! global! carbon in soil - slow protected humus  	 (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: csoislon(npoi)          ! global! carbon in soil - slow nonprotected humus     (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: csoipas (npoi)          ! global! carbon in soil - passive humus 		  (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: clitll  (npoi)          ! global! carbon in leaf litter pool - lignin	   (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: clitrl  (npoi)          ! global! carbon in fine root litter pool - lignin     (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: clitwl  (npoi)          ! global! carbon in woody litter pool - lignin	   (kg_C m-2)


   REAL(KIND=r8), INTENT(INOUT) :: tc      (npoi)          ! global  ! coldest monthly temperature (C)
   REAL(KIND=r8), INTENT(INOUT) :: agddu   (npoi)          ! global  ! annual accumulated growing degree days for bud
   				                                     ! burst, upper canopy (day-degrees)
   REAL(KIND=r8), INTENT(INOUT) :: tempu   (npoi)          ! global  ! cold-phenology trigger for trees (non-dimensional)
   REAL(KIND=r8), INTENT(INOUT) :: agddl   (npoi)          ! global  ! annual accumulated growing degree days for bud burst,
   				                                     ! lower canopy (day-degrees)
   REAL(KIND=r8), INTENT(INOUT) :: templ   (npoi)	   ! global  ! cold-phenology trigger for grasses/shrubs (non-dimensional)
   REAL(KIND=r8), INTENT(INOUT) :: dropu   (npoi)          ! global  ! drought-phenology trigger for trees (non-dimensional)
   REAL(KIND=r8), INTENT(INOUT) :: dropls  (npoi)          ! global  ! drought-phenology trigger for shrubs (non-dimensional)
   REAL(KIND=r8), INTENT(INOUT) :: dropl4  (npoi)          ! global  ! drought-phenology trigger for c4 grasses (non-dimensional)
   REAL(KIND=r8), INTENT(INOUT) :: dropl3  (npoi)          ! global  ! drought-phenology trigger for c3 grasses (non-dimensional)
   REAL(KIND=r8), INTENT(INOUT) :: plai    (npoi,npft)     ! global  ! total leaf area index of each plant functional type
!
! Arguments (input)
!
   INTEGER, INTENT(IN   ) :: iday	 ! day number  (passed in)
   INTEGER, INTENT(IN   ) :: imonth	 ! month number (passed in)
   INTEGER, INTENT(IN   ) :: iyear
   INTEGER, INTENT(IN   ) :: iyear0
   INTEGER, INTENT(IN   ) :: isimveg 
   INTEGER, INTENT(IN   ) :: spinmax 
   REAL(KIND=r8), INTENT(IN	) :: ux  (npoi)
   REAL(KIND=r8), INTENT(IN	) :: uy  (npoi)
   REAL(KIND=r8), INTENT(OUT  ) :: taux(npoi)
   REAL(KIND=r8), INTENT(OUT  ) :: tauy(npoi)
   REAL(KIND=r8), INTENT(INOUT) :: ts2 (npoi)
   REAL(KIND=r8), INTENT(INOUT) :: qs2 (npoi)
   REAL(KIND=r8), INTENT(IN	) :: deltat   (npoi)      ! absolute minimum temperature -
             	                                 ! temp on average of coldest month (C)
   REAL(KIND=r8), INTENT(INOUT) :: gdd0     (npoi)	 ! growing degree days > 0C 
   REAL(KIND=r8), INTENT(INOUT) :: gdd0this (npoi)	 ! annual total growing degree days for current year
   REAL(KIND=r8), INTENT(INOUT) :: tcthis   (npoi)      ! coldest monthly temperature of current year (C)
   REAL(KIND=r8), INTENT(INOUT) :: twthis   (npoi)      ! warmest monthly temperature of current year (C)
   REAL(KIND=r8), INTENT(INOUT) :: tcmin    (npoi)      ! coldest daily temperature of current year (C)
   REAL(KIND=r8), INTENT(INOUT) :: gdd5     (npoi)      ! growing degree days > 5C
   REAL(KIND=r8), INTENT(INOUT) :: gdd5this (npoi)      ! annual total growing degree days for current year
   REAL(KIND=r8), INTENT(IN   ) :: TminL    (npft)      ! Absolute minimum temperature -- lower limit (upper canopy PFTs)
   REAL(KIND=r8), INTENT(IN   ) :: TminU    (npft)      ! Absolute minimum temperature -- upper limit (upper canopy PFTs)
   REAL(KIND=r8), INTENT(IN   ) :: Twarm    (npft)      ! Temperature of warmest month (lower canopy PFTs)
   REAL(KIND=r8), INTENT(IN   ) :: GDD      (npft)      ! minimum GDD needed (base 5 C for upper canopy PFTs, 
   REAL(KIND=r8), INTENT(IN   ) :: aleaf    (npft) 	 ! carbon allocation fraction to leaves
   REAL(KIND=r8), INTENT(IN   ) :: awood    (npft) 	 ! carbon allocation fraction to wood 
   REAL(KIND=r8), INTENT(INOUT) :: cbiol    (npoi,npft) ! carbon in leaf biomass pool (kg_C m-2)
   REAL(KIND=r8), INTENT(IN   ) :: aroot    (npft)	 ! carbon allocation fraction to fine roots
   REAL(KIND=r8), INTENT(OUT  ) :: disturbf (npoi)	 ! annual fire disturbance regime (m2/m2/yr)
   REAL(KIND=r8), INTENT(OUT  ) :: disturbo (npoi)	 ! fraction of biomass pool lost every year to disturbances other than fire
   REAL(KIND=r8), INTENT(IN   ) :: specla   (npft)	 ! specific leaf area (m**2/kg) 
   REAL(KIND=r8), INTENT(OUT  ) :: biomass  (npoi,npft) ! total biomass of each plant functional type  (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: totlaiu  (npoi)	 ! total leaf area index for the upper canopy
   REAL(KIND=r8), INTENT(INOUT) :: totlail  (npoi)	 ! total leaf area index for the lower canopy
   REAL(KIND=r8), INTENT(INOUT) :: totbiou  (npoi)	 ! total biomass in the upper canopy (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: totbiol  (npoi)	 ! total biomass in the lower canopy (kg_C m-2)
   REAL(KIND=r8), INTENT(IN   ) :: woodnorm  	         ! value of woody biomass for upper canopy closure
   						 ! (ie when wood = woodnorm fu = 1.0) (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: vegtype0 (npoi)      ! annual vegetation type - ibis classification
   REAL(KIND=r8), INTENT(IN   ) :: tauwood0 (npft)      ! normal (unstressed) turnover time for wood biomass (years)
   REAL(KIND=r8), INTENT(OUT  ) :: tauwood  (npoi,npft)      ! wood biomass turnover time constant (years)
   REAL(KIND=r8), INTENT(IN   ) :: tauleaf  (npft)      ! foliar biomass turnover time constant (years)
   REAL(KIND=r8), INTENT(IN   ) :: tauroot  (npft)      ! fine root biomass turnover time constant (years)
   REAL(KIND=r8), INTENT(IN   ) :: xminlai	         ! Minimum LAI for each existing PFT
   REAL(KIND=r8), INTENT(OUT  ) :: cdisturb (npoi)	 ! annual amount of vegetation carbon lost 
   						 ! to atmosphere due to fire  (biomass burning) (kg_C m-2/year)
   REAL(KIND=r8), INTENT(OUT  ) :: ayanpp   (npoi,npft)   ! annual above-ground npp for each plant type(kg-c/m**2/yr)
   REAL(KIND=r8), INTENT(OUT  ) :: ayanpptot(npoi)	     ! annual above-ground npp for ecosystem (kg-c/m**2/yr)
   REAL(KIND=r8), INTENT(IN   ) :: garea    (npoi)   ! area of each gridcell (m**2)
   REAL(KIND=r8), INTENT(INOUT) :: tw      (npoi)      ! warmest monthly temperature (C)
   REAL(KIND=r8), INTENT(INOUT) :: adfalll   (npoi)          ! global ! annual leaf litter fall (kg_C m-2/year)
   REAL(KIND=r8), INTENT(INOUT) :: adfallr   (npoi)          ! global ! annual root litter input		    (kg_C m-2/year)
   REAL(KIND=r8), INTENT(INOUT) :: adfallw   (npoi)          ! global ! annual wood litter fall		    (kg_C m-2/year)
   REAL(KIND=r8), INTENT(INOUT) :: adcbiol(npoi,npft)
   REAL(KIND=r8), INTENT(INOUT) :: adcbior(npoi,npft)
   REAL(KIND=r8), INTENT(INOUT) :: adcbiow(npoi,npft)
   REAL(KIND=r8), INTENT(INOUT) :: adplai    (npoi,npft)     ! global  ! total leaf area index of each plant functional type
   CHARACTER(len=*) , INTENT(IN   ) ::  rootmode

!
! Arguments (input)
!
   INTEGER, INTENT(IN   ) :: nstep      ! atm time step index
   INTEGER, INTENT(IN   ) :: idayprev   ! day in month of previous timestep
   INTEGER, INTENT(IN   ) :: imonthprev ! month of previous timestep 
   INTEGER, INTENT(IN   ) :: iyearprev  ! year of previous timestep 
   INTEGER, INTENT(IN   ) :: idayout	 ! write out daily output
   INTEGER, INTENT(IN   ) :: imonthout  ! write out daily output
   INTEGER, INTENT(IN   ) :: iyearout
   INTEGER, INTENT(IN   ) :: isimco2
   INTEGER, INTENT(IN   ) :: isimfire
   INTEGER, PARAMETER     :: lenMonth(12)=(/31,28,31,30,31,30,31,31,30,31,30,31/) 
   REAL(KIND=r8), INTENT(IN   ) :: co2init
   REAL(KIND=r8), INTENT(IN   ) :: beta1(nVegClass)
   REAL(KIND=r8), INTENT(IN   ) :: beta2(nVegClass)
   REAL(KIND=r8), INTENT(IN   ) :: stressfac(nVegClass)
   REAL(KIND=r8), INTENT(IN   ) :: avmuir_factor(nVegClass,2)
   INTEGER(Kind=i8), INTENT(IN   ) ::iMask(nCols)
   REAL(KIND=r8), INTENT(IN   ) :: calday     ! current julian day (1-365.99)
   			     !  decimals=fraction of day

!  INTEGER :: iday	 ! current day in month (1-31 or 1-30, or 1-28)
!   integer:: imonth	 ! current month (1 - 12)
   !INTEGER :: mcdate
   !REAL(KIND=r8) :: co2vmrgcm 	   ! modified co2 volume mixing ratio
   !REAL(KIND=r8) :: dtibis	     ! time step as passed from GCM, dtime from
   INTEGER :: lenMonthly,nLndPts

   INTEGER :: j
   INTEGER :: i
   INTEGER :: ndyn
   terml=0.0_r8
   termu=0.0_r8
   abupd=0.0_r8
   abupi=0.0_r8
   fupdd=0.0_r8


      IF (mcsec == 0.0_r8) THEN
           CALL DailyDynaVeg(isimfire  ,&
                              npoi      ,&!  INTEGER      , INTENT(IN   ) :: npoi                 ! total number of land points
                              npft     ,&!  INTEGER      , INTENT(IN   ) :: npft                 ! number of plant functional types
                              woodnorm ,&!  REAL(KIND=r8), INTENT(IN   ) :: woodnorm                ! value of woody biomass for upper canopy closure! (ie when wood = woodnorm fu = 1.0) (kg_C m-2)
                              xminlai  ,&!  REAL(KIND=r8), INTENT(IN   ) :: xminlai                ! Minimum LAI for each existing PFT
                              specla   ,&!  REAL(KIND=r8), INTENT(IN   ) :: specla    (npft)         ! specific leaf area (m**2/kg) 
                              aleaf    ,&!  REAL(KIND=r8), INTENT(IN   ) :: aleaf     (npft)         ! carbon allocation fraction to leaves
                              awood    ,&!  REAL(KIND=r8), INTENT(IN   ) :: awood     (npft)         ! carbon allocation fraction to wood 
                              tauwood0 ,&!  REAL(KIND=r8), INTENT(IN   ) :: tauwood0  (npft)         ! normal (unstressed) turnover time for wood biomass (years)
                              tauleaf  ,&!  REAL(KIND=r8), INTENT(IN   ) :: tauleaf   (npft)         ! foliar biomass turnover time constant (years)
                              tauroot  ,&!  REAL(KIND=r8), INTENT(IN   ) :: tauroot   (npft)         ! fine root biomass turnover time constant (years)
                              aroot    ,&!  REAL(KIND=r8), INTENT(IN   ) :: aroot     (npft)         ! carbon allocation fraction to fine roots
                              exist    ,&!  REAL(KIND=r8), INTENT(IN   ) :: exist     (npoi,npft)  ! probability of existence of each plant functional type in a gridcell
                              adco2mic ,&!  REAL(KIND=r8), INTENT(IN   ) :: adco2mic  (npoi)         ! global! daily accumulated co2 respiration from microbes (kg_C m-2 /day)
                              adnpp    ,&!  REAL(KIND=r8), INTENT(INOUT) :: adnpp     (npoi,npft)  ! annual total npp for each plant type(kg-c/m**2/day)
                              adcbiol  ,&!  REAL(KIND=r8), INTENT(INOUT) :: adcbiol   (npoi,npft)  ! carbon in leaf biomass pool (kg_C m-2)
                              adcbior  ,&!  REAL(KIND=r8), INTENT(INOUT) :: adcbior   (npoi,npft)  ! carbon in fine root biomass pool (kg_C m-2)
                              adcbiow  ,&!  REAL(KIND=r8), INTENT(INOUT) :: adcbiow   (npoi,npft)  ! carbon in woody biomass pool (kg_C m-2)
                              adplai   ,&!  REAL(KIND=r8), INTENT(INOUT) :: adplai    (npoi,npft)  ! global  ! total leaf area index of each plant functional type
                              adfalll  ,&!  REAL(KIND=r8), INTENT(OUT  ) :: adfalll   (npoi)         ! global ! annual leaf litter fall (kg_C m-2/day)
                              adfallr  ,&!  REAL(KIND=r8), INTENT(OUT  ) :: adfallr   (npoi)         ! global ! annual root litter input(kg_C m-2/day)
                              adfallw  ,&!  REAL(KIND=r8), INTENT(OUT  ) :: adfallw   (npoi)         ! global ! annual wood litter fall (kg_C m-2/day)
                              fu       ,&!  REAL(KIND=r8), INTENT(OUT  ) :: fu        (npoi) ! fraction of overall area covered by upper canopy
                              fl       ,&!  REAL(KIND=r8), INTENT(OUT  ) :: fl        (npoi) ! fraction of snow-free area covered by lower  canopy
                              zbot     ,&!  REAL(KIND=r8), INTENT(OUT  ) :: zbot      (npoi,2) ! height of lowest branches above ground (m)
                              ztop     ,&!  REAL(KIND=r8), INTENT(OUT  ) :: ztop      (npoi,2) ! height of plant top above ground (m)
                              sai      ,&!  REAL(KIND=r8), INTENT(OUT  ) :: sai       (npoi,2) ! current single-sided stem area index
                              sapfrac  ,&!  REAL(KIND=r8), INTENT(OUT  ) :: sapfrac   (npoi) ! fraction of woody biomass that is in sapwoodND=r8), INTENT(OUT  ) :: cdisturb  (npoi)        
                              totlit   ,&
                              firefac  )

     
      END IF

PRINT*,'pkubota',ztop(:,2),zbot(:,2),ztop(:,1),zbot(:,1)
!
!
      CALL Ibis    (mcsec         ,pi          ,stef         ,vonk         ,grav        , &
                    tmelt        ,hfus        ,hvap         ,hsub         ,ch2o        , &
                    cice         ,cair        ,cvap         ,rair         ,rvap        , &
                    cappa        ,rhow        ,npoi         ,nband        ,nsoilay     , & 
                    nsnolay      ,npft        ,epsilon      ,dtime        ,doalb       , &
		    ginvap       ,gsuvap      ,gtrans       ,gtransu      ,gtransl     , &
                    grunof       ,gdrain      ,gadjust      ,a10scalparamu,a10daylightu, &
		    a10scalparaml,a10daylightl,vmax_pft     ,tau15        ,kc15        , &
                    ko15         ,cimax       ,gammaub      ,alpha3       ,theta3      , &
		    beta3        ,coefmub     ,coefbub      ,gsubmin      ,gammauc     , &
                    coefmuc      ,coefbuc     ,gsucmin      ,gammals      ,coefmls     , & 
                    coefbls      ,gslsmin     ,gammal3      ,coefml3      ,coefbl3     , &
                    gsl3min      ,gammal4     ,alpha4       ,theta4       ,beta4       , &
		    coefml4      ,coefbl4     ,gsl4min      ,wliqu        ,wliqumax    , & 
                    wsnou        ,wsnoumax    ,tu           ,wliqs        ,wliqsmax    , & 
                    wsnos        ,wsnosmax    ,ts           ,wliql        ,wliqlmax    , &  
                    wsnol        ,wsnolmax    ,tl           ,topparu      ,topparl     , &
                    fl           ,fu          ,lai          ,sai          ,rhoveg      , &   
                    tauveg       ,orieh       ,oriev        ,wliqmin      ,wsnomin     , & 
                    t12          ,tdripu      ,tblowu       ,tdrips       ,tblows      , &
                    t34          ,tdripl      ,tblowl       ,ztop         ,alaiml      , &
                    zbot         ,alaimu      ,froot        ,q34          ,q12         , &
                    su	         ,cleaf       ,dleaf        ,ss           ,cstem       , & 
                    dstem        ,sl          ,cgrass       ,ciub         ,ciuc        , &
                    exist        ,csub        ,gsub         ,csuc         ,gsuc        , &
                    agcub        ,agcuc       ,ancub        ,ancuc        ,totcondub   , &
                    totconduc    ,cils        ,cil3         ,cil4         ,csls        , &
                    gsls         ,csl3        ,gsl3         ,csl4         ,gsl4        , &
		    agcls        ,agcl4       ,agcl3        ,ancls        ,ancl4       , &
		    ancl3        ,totcondls   ,totcondl3    ,totcondl4    ,chu         , &
                    chs          ,chl         ,frac         ,tlsub	  ,z0sno       , & 
                    rhos         ,consno      ,hsnotop      ,hsnomin      ,fimin       , &
		    fimax        ,fi          ,tsno         ,hsno         ,sand	       , &
                    clay         ,poros       ,wsoi         ,wisoi        ,consoi      , &  
                    zwpmax       ,wpud        ,wipud        ,wpudmax      ,qglif       , & 	
                    tsoi         ,hvasug      ,hvasui       ,albsav       ,albsan      , &
		    tg           ,ti          ,z0soi        ,swilt        ,sfield      , &
                    stressl      ,stressu     ,stresstl     ,stresstu     ,csoi        , & 	
                    rhosoi       ,hsoi        ,suction      ,bex          ,upsoiu      , &  
                    upsoil       ,heatg       ,heati        ,hydraul      ,porosflo    , &
                    ibex         ,bperm       ,hflo	    ,ta           ,asurd       , &  
                    asuri        ,coszen      ,solad        ,solai        ,fira	       , & 
                    raina        ,qa          ,psurf        ,snowa        ,ua	       , &   
                    o2conc       ,co2conc     ,fwetu        ,rliqu        ,fwets       , &
                    rliqs        ,fwetl       ,rliql        ,solu        , &	 
                    sols         ,soll        ,solg         ,soli         ,scalcoefl   , &
                    scalcoefu    ,indsol      ,albsod       ,albsoi       ,albsnd      , &
                    albsni       ,relod       ,reloi        ,reupd        ,reupi       , &
                    ablod        ,abloi	      ,flodd        ,dummy        ,flodi       , &
                    floii	 ,terml       ,termu        ,abupd        ,abupi       , & 
                    fupdd        ,fupdi       ,fupii        ,sol2d        ,sol2i       , & 
                    sol3d        ,sol3i       ,firb         ,firs         ,firu	       , &
                    firl         ,firg        ,firi         ,snowg        ,tsnowg      , &    
                    tsnowl       ,pfluxl      ,raing        ,traing       ,trainl      , &
                    snowl        ,tsnowu      ,pfluxu       ,rainu        ,trainu      , &   
                    snowu        ,pfluxs      ,rainl        ,bps          ,cp          , &  
                    za	         ,bdl         ,dil          ,z3           ,z4          , & 
                    z34	         ,exphl       ,expl         ,displ        ,bdu         , &
                    diu          ,z1          ,z2           ,z12          ,exphu       , &
                    expu         ,dispu       ,alogg        ,alogi        ,alogav      , & 
                    alog4        ,alog3       ,alog2        ,alog1        ,aloga       , & 	 
                    u2           ,alogu       ,alogl        ,richl        ,straml      , &
                    strahl       ,richu       ,stramu       ,strahu       ,u1          , & 
                    u12          ,u3          ,u34          ,u4           ,cu          , &
                    cl	         ,sg          ,si           ,fwetux       ,fwetsx      , &  
                    fwetlx       ,fsena       ,fseng        ,fseni        ,fsenu       , &
                    fsens        ,fsenl       ,fvapa        ,fvaput       ,fvaps       , &
                    fvaplw       ,fvaplt      ,fvapg        ,fvapi        ,fvapuw      , &
		    td	         ,vzero       ,ndaypy       ,nppdummy     ,tgpp        , & 
                    tgpptot      ,tnpp        ,cbiow        ,sapfrac      ,cbior       , & 
                    tnpptot      ,tco2root    ,tneetot      ,tco2mic      ,a10td       , &
                    a10ancub     ,a10ancuc    ,a10ancls     ,a10ancl3     ,a10ancl4    , & 
                    ndtimes      ,adrain       ,adsnow      , &
                    adaet        ,adtrunoff   ,adsrunoff    ,addrainage   ,adrh        , &
                    adsnod       ,adsnof      ,adwsoi       ,adtsoi       ,adwisoi     , &
                    adtlaysoi    ,adwlaysoi   ,adwsoic      ,adtsoic      ,adco2mic    , &
                    adco2root    ,adco2soi    ,adco2ratio   ,adnmintot    ,decompl     , &    
                    decomps      ,tnmin       ,ndaypm       ,nmtimes     , & 
                    amrain       ,amsnow      ,amaet        ,amtrunoff    ,amsrunoff   , &
                    amdrainage   ,amtemp      ,amqa         , &
                    amsolar      ,amirup      ,amirdown     ,amsens       ,amlatent    , &  
                    amlaiu       ,amlail      ,amtsoi       ,amwsoi       ,amwisoi     , &   
                    amvwc        ,amawc       ,amsnod       ,amsnof       ,amnpp       , &
                    amnpptot     ,amco2mic    ,amco2root    ,amco2soi     ,amco2ratio  , &
                    amneetot     ,amnmintot   ,nytimes      ,aysolar      ,ayirup      , &
                    ayirdown     ,aysens      ,aylatent     ,ayprcp       ,ayaet       , &  
                    aytrans      ,aytrunoff   ,aysrunoff    ,aydrainage   ,aydwtot     , & 
                    aywsoi       ,aywisoi     ,aytsoi       ,ayvwc        ,ayawc       , &  
                    aystresstu   ,aystresstl  ,aygpp	    ,aygpptot     ,aynpp       , & 
                    aynpptot     ,ayco2mic    ,ayco2root    ,ayco2soi     ,ayneetot    , &
		    ayrootbio    ,aynmintot   ,ayalit       ,ayblit       ,aycsoi      , & 
                    aycmic       ,ayanlit     ,aybnlit      ,aynsoi       ,ayalbedo    , &
                    beta1        ,beta2       ,stressfac    ,avmuir_factor,totalit      , &
                    totrlit      ,totcsoi     ,totcmic      ,totanlit     ,totrnlit    , &
                    totnsoi      ,totnmic     ,totlit       ,totfall      ,totnlit     , &
                    firefac      ,wtot        ,storedn      ,yrleach      ,ynleach     , & 
                    falll        ,fallr       ,fallw        ,clitlm       ,clitls      , &
                    clitrm       ,clitrs      ,clitwm       ,clitws       ,csoislop    , &
                    csoislon     ,csoipas     ,clitll       ,clitrl       ,clitwl      , &  
                    tc           ,agddu	      ,tempu	    ,agddl        ,templ       , &
                    dropu        ,dropls      ,dropl4       ,dropl3       ,plai	       , &
		    iday        ,imonth       ,iyear        ,iyear0      , &
                    isimveg      ,spinmax     ,amts2        ,amtransu    ,amtransl     , &
                    amsuvap      ,aminvap     ,amalbedo     ,amtsoil     ,amwsoil      , & 
                    amwisoil     ,ux          ,uy           ,taux        ,tauy         , &
		    ts2	         ,qs2         ,gdd0this     ,gdd5this    ,bstar        , &
		    vegtype0     ,ynleach_p   ,tnmin_p      ,totnmic_p   ,totnlit_p    , &
                    totanlit_p   ,totrnlit_p  ,totnsoi_p    ,storedn_p   ,adnpp       , &
                    adfalll      ,adfallr     ,adfallw      ,adcbiol     ,adcbior     ,&
                    adcbiow      ,adplai      ,nstep        ,iMask       ,nCols,jb    ,&
                    nVegClass    ,rootmode)

            DO i = 1, npoi
               z0    (i) =  exp(((alogu(i))))
               ustar (i) =  ua (i) * cu (i)
	       hc    (i) =  (fsena  (i) + fsenu    (i) + fsens     (i) + fsenl    (i) +fsenl(i) )*dtime
	       hg    (i) =  (fseng  (i) + fseni    (i)                                          )*dtime
               
	       !hltm   = 2.52e6_r8            !  latent heat of vaporization (J kg^-1)

               ec    (i) =  (fvaput (i) + fvaps    (i) + fvaplw    (i)  + fvaplt (i) +fvapuw (i))*hltm*dtime
	       eg    (i) =  (fvapg  (i) + fvapi    (i) 	                                        )*hltm*dtime
            END DO


      IF (nstep > 20) THEN
      ! IF (nstep /= 0) THEN
!        
         lenMonthly=lenMonth(imonth)
         IF(MOD(REAL(iyear,KIND=r8),4.0_r8) == 0.0_r8 .AND. imonth == 2) lenMonthly=29
         IF ((mcsec == 86400.0_r8-(dtime/2.0_r8)) .and. (iday == lenMonthly) ) THEN 
            !
            !     end of calculations done once a month
            !
            DO i = 1, npoi
               tcthis(i) = min (tcthis(i), (amts2(i) - 273.160_r8))
               twthis(i) = max (twthis(i), (amts2(i) - 273.160_r8))
            END DO
         END IF
         !
         ! calculations done once a year
         !
	 IF ((nstep > 360) .and.(mcsec == 86400.0_r8-(dtime/2.0_r8)) .and. (iday == lenMonthly) .and. (imonth == 12) ) THEN
!	 IF ((mcsec == 0.0_r8) .and. (iday == 1) .and. (imonth == 1) ) THEN

!
! get new o2 and co2 concentrations for this year
!
            IF (isimco2.eq.1) CALL co2 (co2init,  &! INTENT(IN   )
	                                co2conc,  &! INTENT(OUT  )
					iyear     )! INTENT(IN   )

!
! perform vegetation dynamics
!
            ndyn = 1
            DO j = 1, ndyn

              IF (isimveg /= 0) CALL dynaveg2 (isimfire   , &! INTENT(IN   )        dynaveg1 (isimfire , &! INTENT(IN   )
                                                tauwood0  , &! INTENT(IN   )                  tauwood0 , &! INTENT(IN   )
                                                tauwood   , &! INTENT(OUT  )                  tauwood  , &! INTENT(OUT  )
                                                tauleaf   , &! INTENT(IN   )                  tauleaf  , &! INTENT(IN   )
                                                tauroot   , &! INTENT(IN   )                  tauroot  , &! INTENT(IN   )
                                                xminlai   , &! INTENT(IN   )                  xminlai  , &! INTENT(IN   )
                                                falll     , &! INTENT(OUT  )                  falll    , &! INTENT(OUT  )
                                                fallr     , &! INTENT(OUT  )                  fallr    , &! INTENT(OUT  )
                                                fallw     , &! INTENT(OUT  )                  fallw    , &! INTENT(OUT  )
                                                cdisturb  , &! INTENT(OUT  )                  cdisturb , &! INTENT(OUT  )
                                                exist     , &! INTENT(OUT  )                  exist    , &! INTENT(IN   )
                                                aleaf     , &! INTENT(IN   )                  aleaf    , &! INTENT(IN   )
                                                awood     , &! INTENT(IN   )                  awood    , &! INTENT(IN   )
                                                cbiol     , &! INTENT(INOUT) global           cbiol    , &! INTENT(INOUT) global
                                                cbior     , &! INTENT(INOUT) global           cbior    , &! INTENT(INOUT) global
                                                cbiow     , &! INTENT(INOUT) global           cbiow    , &! INTENT(INOUT) global
                                                aroot     , &! INTENT(IN   )                  aroot    , &! INTENT(IN   )
                                                disturbf  , &! INTENT(OUT  )                  disturbf , &! INTENT(OUT  )
                                                disturbo  , &! INTENT(OUT  )                  disturbo , &! INTENT(OUT  )
                                                firefac   , &! INTENT(IN   )                  firefac  , &! INTENT(IN   )
                                                totlit    , &! INTENT(IN   )                  totlit   , &! INTENT(IN   )
                                                specla    , &! INTENT(IN   )                  specla   , &! INTENT(IN   )
                                                plai      , &! INTENT(INOUT) local            plai          , &! INTENT(INOUT) local
                                                biomass   , &! INTENT(OUT  )                  biomass  , &! INTENT(OUT  )
                                                totlaiu   , &! INTENT(INOUT) local            totlaiu  , &! INTENT(INOUT) local
                                                totlail   , &! INTENT(INOUT) local            totlail  , &! INTENT(INOUT) local
                                                totbiou   , &! INTENT(INOUT) local            totbiou  , &! INTENT(INOUT) local
                                                totbiol   , &! INTENT(OUT  )                  totbiol  , &! INTENT(OUT  )
                                                fu        , &! INTENT(OUT  )                  fu          , &! INTENT(OUT  )
                                                woodnorm  , &! INTENT(IN   )                  woodnorm , &! INTENT(IN   )
                                                fl        , &! INTENT(OUT  )                  fl          , &! INTENT(OUT  )
                                                zbot      , &! INTENT(OUT  )                  zbot          , &! INTENT(OUT  )
                                                ztop      , &! INTENT(OUT  )                  ztop          , &! INTENT(OUT  )
                                                sai       , &! INTENT(OUT  )                  sai          , &! INTENT(OUT  )
                                                sapfrac   , &! INTENT(OUT  )                  sapfrac  , &! INTENT(OUT  )
                                                vegtype0  , &! INTENT(OUT  )                  vegtype0 , &! INTENT(OUT  )
                                                gdd5      , &! INTENT(IN   )                  gdd5          , &! INTENT(IN   )
                                                gdd0      , &! INTENT(IN   )                  gdd0          , &! INTENT(IN   )
                                                aynpp     , &! INTENT(INOUT) global           aynpp    , &! INTENT(INOUT) global
                                                ayanpp    , &! INTENT(OUT  )                  ayanpp   , &! INTENT(OUT  )
                                                ayneetot  , &! INTENT(INOUT) global           ayneetot , &! INTENT(INOUT) global
                                                ayanpptot , &! INTENT(OUT  )                  ayanpptot, &! INTENT(OUT  )
                                                aynpptot  , &! INTENT(OUT  )                  npoi          , &!
                                                ayco2mic  , &! INTENT(IN   )                  npft            )! , isim_ac, year)
                                                npoi      , &!
                                                npft        )! , isim_ac, year)!

        !IF (isimveg /= 0) CALL dynaveg1 (isimfire , &! INTENT(IN        )
        !                             tauwood0 , &! INTENT(IN   )
        !                             tauwood  , &! INTENT(OUT  )
        !                             tauleaf  , &! INTENT(IN   )
        !                             tauroot  , &! INTENT(IN   )
        !                             xminlai  , &! INTENT(IN   )
        !                             falll    , &! INTENT(OUT  )
        !                             fallr    , &! INTENT(OUT  )
        !                             fallw    , &! INTENT(OUT  )
        !                             cdisturb , &! INTENT(OUT  )
        !                             exist    , &! INTENT(IN   )
        !                             aleaf    , &! INTENT(IN   )
        !                             awood    , &! INTENT(IN   )
        !                             cbiol    , &! INTENT(INOUT) global
        !                             cbior    , &! INTENT(INOUT) global
        !                             cbiow    , &! INTENT(INOUT) global
        !                             aroot    , &! INTENT(IN   )
        !                             disturbf , &! INTENT(OUT  )
        !                             disturbo , &! INTENT(OUT  )
        !                             firefac  , &! INTENT(IN   )
        !                             totlit   , &! INTENT(IN   )
        !                             specla   , &! INTENT(IN   )
        !                             plai     , &! INTENT(INOUT) local
        !                             biomass  , &! INTENT(OUT  )
        !                             totlaiu  , &! INTENT(INOUT) local
        !                             totlail  , &! INTENT(INOUT) local
        !                             totbiou  , &! INTENT(INOUT) local
        !                             totbiol  , &! INTENT(OUT  )
        !                             fu       , &! INTENT(OUT  )
        !                             woodnorm , &! INTENT(IN   )
        !                             fl       , &! INTENT(OUT  )
        !                             zbot     , &! INTENT(OUT  )
        !                             ztop     , &! INTENT(OUT  )
        !                             sai      , &! INTENT(OUT  )
        !                             sapfrac  , &! INTENT(OUT  )
        !                             vegtype0 , &! INTENT(OUT  )
        !                             gdd5     , &! INTENT(IN   )
        !                             gdd0     , &! INTENT(IN   )
        !                             aynpp    , &! INTENT(INOUT) global
        !                             ayanpp   , &! INTENT(OUT  )
        !                             ayneetot , &! INTENT(INOUT) global
        !                             ayanpptot, &! INTENT(OUT  )
        !                             npoi     , &!
        !                             npft        )! , isim_ac, year)
        !
        !
            END DO

!
!
!     recalculate bioclimatic parameters (used in dynaveg, calculated
!     even in fixed vegetation case when fixed vegetation is an
!     initialisation of a dynamic run)
!
         CALL climanl2(TminL    , &! INTENT(IN   )
                       TminU    , &! INTENT(IN   )
                       Twarm    , &! INTENT(IN   )
                       GDD      , &! INTENT(IN   )
                       gdd0     , &! INTENT(INOUT)
                       gdd0this , &! INTENT(IN   )
                       tc       , &! INTENT(INOUT)
                       tw       , &! INTENT(INOUT)
                       tcthis   , &! INTENT(INOUT)
                       twthis   , &! INTENT(INOUT)
                       tcmin    , &! INTENT(INOUT) local
                       gdd5     , &! INTENT(INOUT) local
                       gdd5this , &! INTENT(IN   )
                       exist    , &! INTENT(INOUT)
                       deltat   , &! INTENT(IN   )
                       npoi     , &! INTENT(IN   )
                       npft       )! INTENT(IN   )

         END IF

!         IF (imonthprev .ne. imonth) THEN
!
! write restart files
!
!            !CALL wrestart (mdcur, imonthprev, iyearprev, iyear0)
!         END IF
!
!     End of test on 1st time step
!
      END IF
    Grd(206)%Units='C'
    Grd(206)%Name=' coldest monthly temperature (C) '
    Grd(206)%NameG='tc'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(206)%Buffer(i,1,jb) = Grd(206)%Buffer(i,1,jb) + maxstp*(tc (nLndPts))
       ELSE
          Grd(206)%Buffer(i,1,jb) = undef
       END IF
    END DO


    Grd(207)%Units=' C'
    Grd(207)%Name=' warmest monthly temperature (C) ' 
    Grd(207)%NameG='tw'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(207)%Buffer(i,1,jb) = Grd(207)%Buffer(i,1,jb) + maxstp*(tw (nLndPts))
       ELSE
          Grd(207)%Buffer(i,1,jb) = undef
       END IF
    END DO

    Grd(208)%Units=' C'
    Grd(208)%Name=' coldest monthly temperature of current year (C) ' 
    Grd(208)%NameG='tcthis'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(208)%Buffer(i,1,jb) = Grd(208)%Buffer(i,1,jb) + maxstp*(tcthis (nLndPts))
       ELSE
          Grd(208)%Buffer(i,1,jb) = undef
       END IF
    END DO


    Grd(209)%Units=' C'
    Grd(209)%Name=' warmest monthly temperature of current year (C)' 
    Grd(209)%NameG='twthis'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(209)%Buffer(i,1,jb) = Grd(209)%Buffer(i,1,jb) + maxstp*(twthis (nLndPts))
       ELSE
          Grd(209)%Buffer(i,1,jb) = undef
       END IF
    END DO

    Grd(210)%Units=' (kg_C m-2/day)'
    Grd(210)%Name='  daily leaf litter fall ' 
    Grd(210)%NameG='adfalll'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(210)%Buffer(i,1,jb) = Grd(210)%Buffer(i,1,jb) + maxstp*(adfalll (nLndPts))
       ELSE
          Grd(210)%Buffer(i,1,jb) = undef
       END IF
    END DO


    Grd(211)%Units=' (kg_C m-2/day)'
    Grd(211)%Name='  daily root litter input' 
    Grd(211)%NameG='adfallr'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(211)%Buffer(i,1,jb) = Grd(211)%Buffer(i,1,jb) + maxstp*(adfallr (nLndPts))
       ELSE
          Grd(211)%Buffer(i,1,jb) = undef
       END IF
    END DO


    Grd(212)%Units=' (kg_C m-2/day)'
    Grd(212)%Name='  daily wood litter fall' 
    Grd(212)%NameG='adfallw'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(212)%Buffer(i,1,jb) = Grd(212)%Buffer(i,1,jb) + maxstp*(adfallw (nLndPts))
       ELSE
          Grd(212)%Buffer(i,1,jb) = undef
       END IF
    END DO



!   REAL(KIND=r8) :: fsena    (npoi)  ! local ! downward sensible heat flux between za & z12 at za (W m-2)
    Grd(326)%Units='  (W m-2)'
    Grd(326)%Name='  downward sensible heat flux between za & z12 at za' 
    Grd(326)%NameG='fsena'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(326)%Buffer(i,1,jb) = Grd(326)%Buffer(i,1,jb) + maxstp*(fsena (nLndPts))
       ELSE
          Grd(326)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8) :: fseng    (npoi)  ! local ! upward sensible heat flux between soil surface & air at z34 (W m-2)
    Grd(327)%Units='  (W m-2)'
    Grd(327)%Name=' upward sensible heat flux between soil surface & air at z34' 
    Grd(327)%NameG='fseng'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(327)%Buffer(i,1,jb) = Grd(327)%Buffer(i,1,jb) + maxstp*(fseng (nLndPts))
       ELSE
          Grd(327)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8) :: fseni    (npoi)  ! local ! upward sensible heat flux between snow surface & air at z34 (W m-2)
    Grd(328)%Units='  (W m-2)'
    Grd(328)%Name=' upward sensible heat flux between snow surface & air at z34' 
    Grd(328)%NameG='fseni'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(328)%Buffer(i,1,jb) = Grd(328)%Buffer(i,1,jb) + maxstp*(fseni (nLndPts))
       ELSE
          Grd(328)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8) :: fsenu    (npoi)   ! local ! sensible heat flux from upper canopy leaves to air (W m-2)
    Grd(329)%Units='  (W m-2)'
    Grd(329)%Name=' sensible heat flux from upper canopy leaves to air' 
    Grd(329)%NameG='fsenu'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(329)%Buffer(i,1,jb) = Grd(329)%Buffer(i,1,jb) + maxstp*(fsenu (nLndPts))
       ELSE
          Grd(329)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8) :: fsens    (npoi)  ! local ! sensible heat flux from upper canopy stems to air (W m-2)
    Grd(330)%Units='  (W m-2)'
    Grd(330)%Name='  sensible heat flux from upper canopy stems to air' 
    Grd(330)%NameG='fsens'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(330)%Buffer(i,1,jb) = Grd(330)%Buffer(i,1,jb) + maxstp*(fsens (nLndPts))
       ELSE
          Grd(330)%Buffer(i,1,jb) = undef
       END IF
    END DO


!   REAL(KIND=r8) :: fsenl    (npoi)  ! local ! sensible heat flux from lower canopy to air (W m-2)
    Grd(331)%Units='  (W m-2)'
    Grd(331)%Name='   sensible heat flux from lower canopy to air' 
    Grd(331)%NameG='fsenl'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(331)%Buffer(i,1,jb) = Grd(331)%Buffer(i,1,jb) + maxstp*(fsenl (nLndPts))
       ELSE
          Grd(331)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8) :: fvapa    (npoi)       ! local ! downward h2o vapor flux between za & z12 at za (kg m-2 s-1)
    Grd(332)%Units=' (kg m-2 s-1)'
    Grd(332)%Name='  downward h2o vapor flux between za & z12 at za (kg m-2 s-1)' 
    Grd(332)%NameG='fvapa'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(332)%Buffer(i,1,jb) = Grd(332)%Buffer(i,1,jb) + maxstp*(fvapa (nLndPts))
       ELSE
          Grd(332)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8) :: fvaput   (npoi)       ! local ! (transpiration from dry parts) between upper canopy leaves and air at z12 (kg m-2 s-1/ LAI upper canopy/ fu)
    Grd(333)%Units=' (kg m-2 s-1)'
    Grd(333)%Name='  transpiration from dry parts between upper canopy leaves and air at z12 (kg m-2 s-1/ LAI upper canopy/ fu)' 
    Grd(333)%NameG='fvaput'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(333)%Buffer(i,1,jb) = Grd(333)%Buffer(i,1,jb) + maxstp*(fvaput (nLndPts))
       ELSE
          Grd(333)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8) :: fvaps    (npoi)       ! local ! (evaporation from wet surface) between upper canopy stems and air at z12 (kg m-2 s-1 / SAI lower canopy / fu)
    Grd(334)%Units=' (kg m-2 s-1)'
    Grd(334)%Name=' evaporation from wet surface between upper canopy stems and air at z12 (kg m-2 s-1 / SAI lower canopy / fu)' 
    Grd(334)%NameG='fvaps'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(334)%Buffer(i,1,jb) = Grd(334)%Buffer(i,1,jb) + maxstp*(fvaps (nLndPts))
       ELSE
          Grd(334)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8) :: fvaplw   (npoi)       ! local ! (evaporation from wet surface) between lower canopy leaves & stems and air at z34 (kg m-2 s-1/ LAI lower canopy/ fl)
    Grd(335)%Units=' (kg m-2 s-1)'
    Grd(335)%Name='evap wet surface between lower canopy leaves e stems and air at z34 (kg m-2 s-1/ LAI lower canopy/ fl)' 
    Grd(335)%NameG='fvaplw'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(335)%Buffer(i,1,jb) = Grd(335)%Buffer(i,1,jb) + maxstp*(fvaplw (nLndPts))
       ELSE
          Grd(335)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8) :: fvaplt   (npoi)       ! local ! (transpiration) between lower canopy & air at z34 (kg m-2 s-1 / LAI lower canopy / fl)
    Grd(336)%Units=' (kg m-2 s-1)'
    Grd(336)%Name=' transpiration between lower canopy & air at z34 (kg m-2 s-1 / LAI lower canopy / fl)' 
    Grd(336)%NameG='fvaplt'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(336)%Buffer(i,1,jb) = Grd(336)%Buffer(i,1,jb) + maxstp*(fvaplt (nLndPts))
       ELSE
          Grd(336)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8) :: fvapg    (npoi)       ! local ! (evaporation) between soil & air at z34 (kg m-2 s-1/bare ground fraction)
    Grd(337)%Units=' (kg m-2 s-1)'
    Grd(337)%Name='  evaporation between soil & air at z34 (kg m-2 s-1/bare ground fraction)' 
    Grd(337)%NameG='fvapg'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(337)%Buffer(i,1,jb) = Grd(337)%Buffer(i,1,jb) + maxstp*(fvapg (nLndPts))
       ELSE
          Grd(337)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8) :: fvapi    (npoi)       ! local ! (evaporation) between snow & air at z34 (kg m-2 s-1 / fi )
    Grd(338)%Units=' (kg m-2 s-1)'
    Grd(338)%Name='  evaporation between snow & air at z34 (kg m-2 s-1 / fi )' 
    Grd(338)%NameG='fvapi'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(338)%Buffer(i,1,jb) = Grd(338)%Buffer(i,1,jb) + maxstp*(fvapi (nLndPts))
       ELSE
          Grd(338)%Buffer(i,1,jb) = undef
       END IF
    END DO


!   REAL(KIND=r8) :: fvapuw   (npoi)       ! local ! (evaporation from wet parts) between upper canopy leaves and air at z12 (kg m-2 s-1/ LAI upper canopy/ fu)
    Grd(339)%Units=' (kg m-2 s-1)'
    Grd(339)%Name=' evaporation from wet parts between upper canopy leaves and air at z12 (kg m-2 s-1/ LAI upper canopy/ fu)' 
    Grd(339)%NameG='fvapuw'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(339)%Buffer(i,1,jb) = Grd(339)%Buffer(i,1,jb) + maxstp*(fvapuw (nLndPts))
       ELSE
          Grd(339)%Buffer(i,1,jb) = undef
       END IF
    END DO


   !REAL(KIND=r8), INTENT(INOUT) :: t12      (npoi) !global ! air temperature at z12 (K)
    Grd(340)%Units=' (K)'
    Grd(340)%Name=' air temperature at z12' 
    Grd(340)%NameG='t12'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(340)%Buffer(i,1,jb) = Grd(340)%Buffer(i,1,jb) + maxstp*(t12 (nLndPts))
       ELSE
          Grd(340)%Buffer(i,1,jb) = undef
       END IF
    END DO


   !REAL(KIND=r8), INTENT(INOUT) :: t34      (npoi)! global ! air temperature at z34 (K)
    Grd(341)%Units=' (K)'
    Grd(341)%Name=' air temperature at z34 (K)' 
    Grd(341)%NameG='t34'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(341)%Buffer(i,1,jb) = Grd(341)%Buffer(i,1,jb) + maxstp*(t34 (nLndPts))
       ELSE
          Grd(341)%Buffer(i,1,jb) = undef
       END IF
    END DO


   !REAL(KIND=r8), INTENT(INOUT) :: q12      (npoi) !global ! specific humidity  at z12 (kg/kg)
    Grd(342)%Units=' (kg /kg)'
    Grd(342)%Name=' specific humidity  at z12 ' 
    Grd(342)%NameG='q12'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(342)%Buffer(i,1,jb) = Grd(342)%Buffer(i,1,jb) + maxstp*(q12 (nLndPts))
       ELSE
          Grd(342)%Buffer(i,1,jb) = undef
       END IF
    END DO


   !REAL(KIND=r8), INTENT(INOUT) :: q34      (npoi)! global ! specific humidity  at z34 (kg/kg)
    Grd(343)%Units=' (kg/kg)'
    Grd(343)%Name='  specific humidity  at z34 ' 
    Grd(343)%NameG='q34'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(343)%Buffer(i,1,jb) = Grd(343)%Buffer(i,1,jb) + maxstp*(q34 (nLndPts))
       ELSE
          Grd(343)%Buffer(i,1,jb) = undef
       END IF
    END DO


   ! REAL(KIND=r8), INTENT(INOUT) :: ss       (npoi)   ! air-vegetation transfer coefficients (*rhoa) for upper canopy stems (m s-1 * kg m-3) 
    Grd(344)%Units=' (m s-1 * kg m-3) '
    Grd(344)%Name=' air-vegetation transfer coefficients (*rhoa) for upper canopy stems  ' 
    Grd(344)%NameG='ss'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(344)%Buffer(i,1,jb) = Grd(344)%Buffer(i,1,jb) + maxstp*(ss (nLndPts))
       ELSE
          Grd(344)%Buffer(i,1,jb) = undef
       END IF
    END DO

   !REAL(KIND=r8), INTENT(INOUT) :: sl       (npoi)   ! air-vegetation transfer coefficients (*rhoa) for lower canopy leaves & stems (m s-1*kg m-3)
    Grd(345)%Units=' (m s-1*kg m-3)'
    Grd(345)%Name=' air-vegetation transfer coefficients (*rhoa) for lower canopy leaves & stems ' 
    Grd(345)%NameG='sl'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(345)%Buffer(i,1,jb) = Grd(345)%Buffer(i,1,jb) + maxstp*(sl (nLndPts))
       ELSE
          Grd(345)%Buffer(i,1,jb) = undef
       END IF
    END DO

  END SUBROUTINE IbisDrv






 SUBROUTINE Ibis   (mcsec        ,pi          ,stef         ,vonk         ,grav        , &
                    tmelt        ,hfus        ,hvap         ,hsub         ,ch2o        , &
                    cice         ,cair        ,cvap         ,rair         ,rvap        , &
                    cappa        ,rhow        ,npoi         ,nband        ,nsoilay     , & 
                    nsnolay      ,npft        ,epsilon      ,dtime        ,doalb       , &
		    ginvap       ,gsuvap      ,gtrans       ,gtransu      ,gtransl     , &
                    grunof       ,gdrain      ,gadjust      ,a10scalparamu,a10daylightu, &
		    a10scalparaml,a10daylightl,vmax_pft     ,tau15        ,kc15        , &
                    ko15         ,cimax       ,gammaub      ,alpha3       ,theta3      , &
		    beta3        ,coefmub     ,coefbub      ,gsubmin      ,gammauc     , &
                    coefmuc      ,coefbuc     ,gsucmin      ,gammals      ,coefmls     , & 
                    coefbls      ,gslsmin     ,gammal3      ,coefml3      ,coefbl3     , &
                    gsl3min      ,gammal4     ,alpha4       ,theta4       ,beta4       , &
		    coefml4      ,coefbl4     ,gsl4min      ,wliqu        ,wliqumax    , & 
                    wsnou        ,wsnoumax    ,tu           ,wliqs        ,wliqsmax    , & 
                    wsnos        ,wsnosmax    ,ts           ,wliql        ,wliqlmax    , &  
                    wsnol        ,wsnolmax    ,tl           ,topparu      ,topparl     , &
                    fl           ,fu          ,lai          ,sai          ,rhoveg      , &   
                    tauveg       ,orieh       ,oriev        ,wliqmin      ,wsnomin     , & 
                    t12          ,tdripu      ,tblowu       ,tdrips       ,tblows      , &
                    t34          ,tdripl      ,tblowl       ,ztop         ,alaiml      , &
                    zbot         ,alaimu      ,froot        ,q34          ,q12         , &
                    su	         ,cleaf       ,dleaf        ,ss           ,cstem       , & 
                    dstem        ,sl          ,cgrass       ,ciub         ,ciuc        , &
                    exist        ,csub        ,gsub         ,csuc         ,gsuc        , &
                    agcub        ,agcuc       ,ancub        ,ancuc        ,totcondub   , &
                    totconduc    ,cils        ,cil3         ,cil4         ,csls        , &
                    gsls         ,csl3        ,gsl3         ,csl4         ,gsl4        , &
		    agcls        ,agcl4       ,agcl3        ,ancls        ,ancl4       , &
		    ancl3       ,totcondls    ,totcondl3    ,totcondl4    ,chu         , &
                    chs          ,chl         ,frac         ,tlsub	  ,z0sno       , & 
                    rhos         ,consno      ,hsnotop      ,hsnomin      ,fimin       , &
		    fimax        ,fi          ,tsno         ,hsno         ,sand	       , &
                    clay         ,poros       ,wsoi         ,wisoi        ,consoi      , &  
                    zwpmax       ,wpud        ,wipud        ,wpudmax      ,qglif       , & 	
                    tsoi         ,hvasug      ,hvasui       ,albsav       ,albsan      , &
		    tg           ,ti          ,z0soi        ,swilt        ,sfield      , &
                    stressl      ,stressu     ,stresstl     ,stresstu     ,csoi        , & 	
                    rhosoi       ,hsoi        ,suction      ,bex          ,upsoiu      , &  
                    upsoil       ,heatg       ,heati        ,hydraul      ,porosflo    , &
                    ibex         ,bperm       ,hflo	    ,ta           ,asurd       , &  
                    asuri        ,coszen      ,solad        ,solai        ,fira	       , & 
                    raina        ,qa          ,psurf        ,snowa        ,ua	       , &   
                    o2conc       ,co2conc     ,fwetu        ,rliqu        ,fwets       , &
                    rliqs        ,fwetl       ,rliql        ,solu        , &	 
                    sols         ,soll        ,solg         ,soli         ,scalcoefl   , &
                    scalcoefu    ,indsol      ,albsod       ,albsoi       ,albsnd      , &
                    albsni       ,relod       ,reloi        ,reupd        ,reupi       , &
                    ablod        ,abloi	      ,flodd        ,dummy        ,flodi       , &
                    floii	 ,terml       ,termu        ,abupd        ,abupi       , & 
                    fupdd        ,fupdi       ,fupii        ,sol2d        ,sol2i       , & 
                    sol3d        ,sol3i       ,firb         ,firs         ,firu	       , &
                    firl         ,firg        ,firi         ,snowg        ,tsnowg      , &    
                    tsnowl       ,pfluxl      ,raing        ,traing       ,trainl      , &
                    snowl        ,tsnowu      ,pfluxu       ,rainu        ,trainu      , &   
                    snowu        ,pfluxs      ,rainl        ,bps          ,cp          , &  
                    za	         ,bdl         ,dil          ,z3           ,z4          , & 
                    z34	         ,exphl       ,expl         ,displ        ,bdu         , &
                    diu          ,z1          ,z2           ,z12          ,exphu       , &
                    expu         ,dispu       ,alogg        ,alogi        ,alogav      , & 
                    alog4        ,alog3       ,alog2        ,alog1        ,aloga       , & 	 
                    u2           ,alogu       ,alogl        ,richl        ,straml      , &
                    strahl       ,richu       ,stramu       ,strahu       ,u1          , & 
                    u12          ,u3          ,u34          ,u4           ,cu          , &
                    cl	         ,sg          ,si           ,fwetux       ,fwetsx      , &  
                    fwetlx       ,fsena       ,fseng        ,fseni        ,fsenu       , &
                    fsens        ,fsenl       ,fvapa        ,fvaput       ,fvaps       , &
                    fvaplw       ,fvaplt      ,fvapg        ,fvapi        ,fvapuw      , &
		    td	         ,vzero       ,ndaypy       ,nppdummy     ,tgpp        , & 
                    tgpptot      ,tnpp        ,cbiow        ,sapfrac      ,cbior       , & 
                    tnpptot      ,tco2root    ,tneetot      ,tco2mic      ,a10td       , &
                    a10ancub     ,a10ancuc    ,a10ancls     ,a10ancl3     ,a10ancl4    , & 
                    ndtimes      ,adrain       ,adsnow      , &
                    adaet        ,adtrunoff   ,adsrunoff    ,addrainage   ,adrh        , &
                    adsnod       ,adsnof      ,adwsoi       ,adtsoi       ,adwisoi     , &
                    adtlaysoi    ,adwlaysoi   ,adwsoic      ,adtsoic      ,adco2mic    , &
                    adco2root    ,adco2soi    ,adco2ratio   ,adnmintot    ,decompl     , &    
                    decomps      ,tnmin       ,ndaypm       ,nmtimes     , & 
                    amrain       ,amsnow      ,amaet        ,amtrunoff    ,amsrunoff   , &
                    amdrainage   ,amtemp      ,amqa         ,&
                    amsolar      ,amirup      ,amirdown     ,amsens       ,amlatent    , &  
                    amlaiu       ,amlail      ,amtsoi       ,amwsoi       ,amwisoi     , &   
                    amvwc        ,amawc       ,amsnod       ,amsnof       ,amnpp       , &
                    amnpptot     ,amco2mic    ,amco2root    ,amco2soi     ,amco2ratio  , &
                    amneetot     ,amnmintot   ,nytimes      ,aysolar      ,ayirup      , &
                    ayirdown     ,aysens      ,aylatent     ,ayprcp       ,ayaet       , &  
                    aytrans      ,aytrunoff   ,aysrunoff    ,aydrainage   ,aydwtot     , & 
                    aywsoi       ,aywisoi     ,aytsoi       ,ayvwc        ,ayawc       , &  
                    aystresstu   ,aystresstl  ,aygpp	    ,aygpptot     ,aynpp       , & 
                    aynpptot     ,ayco2mic    ,ayco2root    ,ayco2soi     ,ayneetot    , &
		    ayrootbio    ,aynmintot   ,ayalit       ,ayblit       ,aycsoi      , & 
                    aycmic       ,ayanlit     ,aybnlit      ,aynsoi       ,ayalbedo    , &
		    beta1        ,beta2       ,stressfac    ,avmuir_factor,totalit      , &
                    totrlit      ,totcsoi     ,totcmic      ,totanlit     ,totrnlit    , &
                    totnsoi      ,totnmic     ,totlit       ,totfall      ,totnlit     , &
                    firefac      ,wtot        ,storedn      ,yrleach      ,ynleach     , & 
                    falll        ,fallr       ,fallw        ,clitlm       ,clitls      , &
                    clitrm       ,clitrs      ,clitwm       ,clitws       ,csoislop    , &
                    csoislon     ,csoipas     ,clitll       ,clitrl       ,clitwl      , &  
                    tc           ,agddu	      ,tempu	    ,agddl        ,templ       , &
                    dropu        ,dropls      ,dropl4       ,dropl3       ,plai	       , &
		    iday        ,imonth       ,iyear        ,iyear0       , &
                    isimveg      ,spinmax     ,amts2        ,amtransu     ,amtransl    , &
                    amsuvap      ,aminvap     ,amalbedo     ,amtsoil      ,amwsoil     , & 
                    amwisoil     , ux	      ,uy           ,taux         ,tauy        , &
		    ts2	         ,qs2         ,gdd0this     ,gdd5this     ,bstar       , &
		    vegtype0     ,ynleach_p   ,tnmin_p      ,totnmic_p   ,totnlit_p    , &
                    totanlit_p   ,totrnlit_p  ,totnsoi_p    ,storedn_p   ,adnpp       ,&
		    adfalll     ,adfallr      ,adfallw      ,adcbiol     ,adcbior     ,&
                    adcbiow      ,adplai      ,nstep       ,iMask        ,nCols      ,jb, &
		     nVegClass    ,rootmode)
 
  IMPLICIT NONE
   REAL(KIND=r8), INTENT(IN	) :: mcsec!global  ! current seconds in day (0 - (86400 - dtime))
   REAL(KIND=r8), INTENT(IN	) :: pi   !global
   REAL(KIND=r8), INTENT(IN	) :: stef !global  ! stefan-boltzmann constant (W m-2 K-4)
   REAL(KIND=r8), INTENT(IN	) :: vonk !global  ! von karman constant (dimensionless)
   REAL(KIND=r8), INTENT(IN	) :: grav !global  ! gravitational acceleration (m s-2)
   REAL(KIND=r8), INTENT(IN	) :: tmelt!global  ! freezing point of water (K)
   REAL(KIND=r8), INTENT(IN	) :: hfus !global  ! latent heat of fusion of water (J kg-1)
   REAL(KIND=r8), INTENT(IN	) :: hvap !global  ! latent heat of vaporization of water (J kg-1)
   REAL(KIND=r8), INTENT(IN	) :: hsub !global  ! latent heat of sublimation of ice (J kg-1)
   REAL(KIND=r8), INTENT(IN	) :: ch2o !global  ! specific heat of liquid water (J deg-1 kg-1)
   REAL(KIND=r8), INTENT(IN	) :: cice !global  ! specific heat of ice (J deg-1 kg-1)
   REAL(KIND=r8), INTENT(IN	) :: cair !global  ! specific heat of dry air at constant pressure (J deg-1 kg-1)
   REAL(KIND=r8), INTENT(IN	) :: cvap !global  ! specific heat of water vapor at constant pressure (J deg-1 kg-1)
   REAL(KIND=r8), INTENT(IN	) :: rair !global  ! gas constant for dry air (J deg-1 kg-1)
   REAL(KIND=r8), INTENT(IN	) :: rvap !global  ! gas constant for water vapor (J deg-1 kg-1)
   REAL(KIND=r8), INTENT(IN	) :: cappa!global  ! rair/cair
   REAL(KIND=r8), INTENT(IN	) :: rhow !global  ! density of liquid water (all types) (kg m-3)

! 
!
   INTEGER, INTENT(IN   ) :: nVegClass
   INTEGER, INTENT(IN   ) :: nCols
   INTEGER, INTENT(IN   ) :: jb
   INTEGER, INTENT(IN   ) :: npoi   !global  
   INTEGER, INTENT(IN   ) :: nband  !global  
   INTEGER, INTENT(IN   ) :: nsoilay!global   ! number of soil layers
   INTEGER, INTENT(IN   ) :: nsnolay!global   ! number of snow layers
   INTEGER, INTENT(IN   ) :: npft   !global   ! number of plant functional types
   REAL(KIND=r8), INTENT(IN   ) :: epsilon!global   ! small quantity to avoid zero-divides and other
   		                       ! truncation or machine-limit troubles with small
   		                       ! values. should be slightly greater than o(1)
   		                       ! machine precision
   REAL(KIND=r8), INTENT(IN   )  :: dtime !global   ! model timestep (seconds)
   logical, INTENT(IN   )  :: doalb !global    ! true if surface albedo calculation time step

!      INCLUDE 'comhyd.h'
   REAL(KIND=r8), INTENT(OUT  ) :: ginvap (npoi)!local ! total evaporation rate from all intercepted h2o (kg_h2o m-2 s-1)
   REAL(KIND=r8), INTENT(OUT  ) :: gsuvap (npoi)!local ! total evaporation rate from surface (snow/soil) (kg_h2o m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: gtrans (npoi)!local ! total transpiration rate from all vegetation canopies (kg_h2o m-2 s-1)
   REAL(KIND=r8), INTENT(OUT  ) :: gtransu(npoi)!local ! transpiration from upper canopy (kg_h2o m-2 s-1)
   REAL(KIND=r8), INTENT(OUT  ) :: gtransl(npoi)!local ! transpiration from lower canopy (kg_h2o m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: grunof (npoi)!local ! surface runoff rate (kg_h2o m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: gdrain (npoi)!local ! drainage rate out of bottom of lowest soil layer (kg_h2o m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: gadjust(npoi)!local ! h2o flux due to adjustments in subroutine wadjust (kg_h2o m-2 s-1)
!      INCLUDE 'comsum.h'
   REAL(KIND=r8), INTENT(INOUT) :: a10scalparamu(npoi)!global ! 10-day average day-time scaling parameter - upper canopy (dimensionless)
   REAL(KIND=r8), INTENT(INOUT) :: a10daylightu (npoi)!global ! 10-day average day-time PAR - upper canopy (micro-Ein m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: a10scalparaml(npoi)!global ! 10-day average day-time scaling parameter - lower canopy (dimensionless)
   REAL(KIND=r8), INTENT(INOUT) :: a10daylightl (npoi)!global ! 10-day average day-time PAR - lower canopy (micro-Ein m-2 s-1)
!      INCLUDE 'compft.h'
   REAL(KIND=r8), INTENT(IN   ) :: vmax_pft(npft)!global ! nominal vmax of top leaf at 15 C (mol-co2/m**2/s) [not used]
   REAL(KIND=r8), INTENT(IN   ) :: tau15	   !global ! co2/o2 specificity ratio at 15 degrees C (dimensionless)
   REAL(KIND=r8), INTENT(IN   ) :: kc15	   !global ! co2 kinetic parameter (mol/mol)
   REAL(KIND=r8), INTENT(IN   ) :: ko15	   !global ! o2 kinetic parameter (mol/mol) 
   REAL(KIND=r8), INTENT(IN   ) :: cimax	   !global ! maximum value for ci (needed for model stability)
   REAL(KIND=r8), INTENT(IN   ) :: gammaub	   !global ! leaf respiration coefficient
   REAL(KIND=r8), INTENT(IN   ) :: alpha3	   !global ! intrinsic quantum efficiency for C3 plants (dimensionless)
   REAL(KIND=r8), INTENT(IN   ) :: theta3	   !global ! photosynthesis coupling coefficient for C3 plants (dimensionless)
   REAL(KIND=r8), INTENT(IN   ) :: beta3	   !global ! photosynthesis coupling coefficient for C3 plants (dimensionless)
   REAL(KIND=r8), INTENT(IN   ) :: coefmub	   !global ! 'm' coefficient for stomatal conductance relationship
   REAL(KIND=r8), INTENT(IN   ) :: coefbub	   !global ! 'b' coefficient for stomatal conductance relationship
   REAL(KIND=r8), INTENT(IN   ) :: gsubmin	   !global ! absolute minimum stomatal conductance
   REAL(KIND=r8), INTENT(IN   ) :: gammauc	   !global ! leaf respiration coefficient
   REAL(KIND=r8), INTENT(IN   ) :: coefmuc	   !global ! 'm' coefficient for stomatal conductance relationship  
   REAL(KIND=r8), INTENT(IN   ) :: coefbuc	   !global ! 'b' coefficient for stomatal conductance relationship  
   REAL(KIND=r8), INTENT(IN   ) :: gsucmin	   !global ! absolute minimum stomatal conductance
   REAL(KIND=r8), INTENT(IN   ) :: gammals	   !global ! leaf respiration coefficient
   REAL(KIND=r8), INTENT(IN   ) :: coefmls	   !global ! 'm' coefficient for stomatal conductance relationship 
   REAL(KIND=r8), INTENT(IN   ) :: coefbls	   !global ! 'b' coefficient for stomatal conductance relationship 
   REAL(KIND=r8), INTENT(IN   ) :: gslsmin	   !global ! absolute minimum stomatal conductance
   REAL(KIND=r8), INTENT(IN   ) :: gammal3	   !global ! leaf respiration coefficient
   REAL(KIND=r8), INTENT(IN   ) :: coefml3	   !global ! 'm' coefficient for stomatal conductance relationship 
   REAL(KIND=r8), INTENT(IN   ) :: coefbl3	   !global ! 'b' coefficient for stomatal conductance relationship 
   REAL(KIND=r8), INTENT(IN   ) :: gsl3min	   !global ! absolute minimum stomatal conductance
   REAL(KIND=r8), INTENT(IN   ) :: gammal4	   !global ! leaf respiration coefficient
   REAL(KIND=r8), INTENT(IN   ) :: alpha4	   !global ! intrinsic quantum efficiency for C4 plants (dimensionless)
   REAL(KIND=r8), INTENT(IN   ) :: theta4	   !global ! photosynthesis coupling coefficient for C4 plants (dimensionless) 
   REAL(KIND=r8), INTENT(IN   ) :: beta4	   !global ! photosynthesis coupling coefficient for C4 plants (dimensionless)
   REAL(KIND=r8), INTENT(IN   ) :: coefml4	   !global ! 'm' coefficient for stomatal conductance relationship
   REAL(KIND=r8), INTENT(IN   ) :: coefbl4	   !global ! 'b' coefficient for stomatal conductance relationship
   REAL(KIND=r8), INTENT(IN   ) :: gsl4min	   !global ! absolute minimum stomatal conductance
!      include 'comveg.h'
   REAL(KIND=r8), INTENT(INOUT) :: wliqu    (npoi)!global ! intercepted liquid h2o on upper canopy leaf area (kg m-2)
   REAL(KIND=r8), INTENT(IN   ) :: wliqumax  	    !global ! maximum intercepted water on a unit upper canopy leaf area (kg m-2)
   REAL(KIND=r8), INTENT(INOUT) :: wsnou    (npoi)!global ! intercepted frozen h2o (snow) on upper canopy leaf area (kg m-2)
   REAL(KIND=r8), INTENT(IN   ) :: wsnoumax  	    !global ! intercepted snow capacity for upper canopy leaves (kg m-2)
   REAL(KIND=r8), INTENT(INOUT) :: tu       (npoi)!global ! temperature of upper canopy leaves (K)
   REAL(KIND=r8), INTENT(INOUT) :: wliqs    (npoi)!global ! intercepted liquid h2o on upper canopy stem area (kg m-2)
   REAL(KIND=r8), INTENT(IN   ) :: wliqsmax  	    !global ! maximum intercepted water on a unit upper canopy stem area (kg m-2)
   REAL(KIND=r8), INTENT(INOUT) :: wsnos    (npoi)!global ! intercepted frozen h2o (snow) on upper canopy stem area (kg m-2)
   REAL(KIND=r8), INTENT(IN   ) :: wsnosmax  	    !global ! intercepted snow capacity for upper canopy stems (kg m-2)
   REAL(KIND=r8), INTENT(INOUT) :: ts       (npoi)!global ! temperature of upper canopy stems (K)
   REAL(KIND=r8), INTENT(INOUT) :: wliql    (npoi)!global ! intercepted liquid h2o on lower canopy leaf and stem area (kg m-2)
   REAL(KIND=r8), INTENT(IN   ) :: wliqlmax  	    !global ! maximum intercepted water on a unit lower canopy stem & leaf area (kg m-2)
   REAL(KIND=r8), INTENT(INOUT) :: wsnol    (npoi)!global ! intercepted frozen h2o (snow) on lower canopy leaf & stem area (kg m-2)
   REAL(KIND=r8), INTENT(IN   ) :: wsnolmax  	    !global ! intercepted snow capacity for lower canopy leaves & stems (kg m-2)
   REAL(KIND=r8), INTENT(INOUT) :: tl       (npoi)!global ! temperature of lower canopy leaves & stems(K)
   REAL(KIND=r8), INTENT(INOUT) :: topparu  (npoi)!local  ! total photosynthetically active raditaion absorbed 
                                                    ! by top leaves of upper canopy (W m-2)
   REAL(KIND=r8), INTENT(INOUT) :: topparl  (npoi)!local  ! total photosynthetically active raditaion absorbed
                                                    ! by top leaves of lower canopy (W m-2)
   REAL(KIND=r8), INTENT(IN   ) :: fl       (npoi)!global ! fraction of snow-free area covered by lower  canopy
   REAL(KIND=r8), INTENT(IN   ) :: fu       (npoi)!global ! fraction of overall area covered by upper canopy
   REAL(KIND=r8), INTENT(INOUT) :: lai      (npoi,2)!global ! canopy single-sided leaf area index (area leaf/area veg)
   REAL(KIND=r8), INTENT(IN   ) :: sai      (npoi,2)!global ! current single-sided stem area index
   REAL(KIND=r8), INTENT(IN   ) :: rhoveg   (nband,2)!global ! reflectance of an average leaf/stem
   REAL(KIND=r8), INTENT(IN   ) :: tauveg   (nband,2)  ! transmittance of an average leaf/stem
   REAL(KIND=r8), INTENT(IN   ) :: orieh    (2) ! fraction of leaf/stems with horizontal orientation
   REAL(KIND=r8), INTENT(IN   ) :: oriev    (2) ! fraction of leaf/stems with vertical
   REAL(KIND=r8), INTENT(INOUT) :: wliqmin      ! local ! minimum intercepted water on unit vegetated area (kg m-2)
   REAL(KIND=r8), INTENT(INOUT) :: wsnomin      ! local ! minimum intercepted snow on unit vegetated area (kg m-2)
   REAL(KIND=r8), INTENT(INOUT) :: t12      (npoi) !global ! air temperature at z12 (K)
   REAL(KIND=r8), INTENT(IN   ) :: tdripu       ! global ! decay time for dripoff of liquid intercepted by upper canopy leaves (sec)
   REAL(KIND=r8), INTENT(IN   ) :: tblowu	  ! global ! decay time for blowoff of snow intercepted by upper canopy leaves (sec)
   REAL(KIND=r8), INTENT(IN   ) :: tdrips	  ! global ! decay time for dripoff of liquid intercepted by upper canopy stems (sec) 
   REAL(KIND=r8), INTENT(IN   ) :: tblows	  ! global ! decay time for blowoff of snow intercepted by upper canopy stems (sec)
   REAL(KIND=r8), INTENT(INOUT) :: t34      (npoi)! global ! air temperature at z34 (K)
   REAL(KIND=r8), INTENT(IN   ) :: tdripl       ! global ! decay time for dripoff of liquid intercepted
                                                   ! by lower canopy leaves & stem (sec)
   REAL(KIND=r8), INTENT(IN   ) :: tblowl	  ! global	  ! decay time for blowoff of snow intercepted by lower canopy leaves & stems (sec)
   REAL(KIND=r8), INTENT(INOUT) :: ztop     (npoi,2) ! global  ! height of plant top above ground (m)
   REAL(KIND=r8), INTENT(IN   ) :: alaiml	  ! global ! lower canopy leaf & stem maximum area (2 sided) for
                                                   ! normalization of drag coefficient (m2 m-2)
   REAL(KIND=r8), INTENT(INOUT) :: zbot     (npoi,2) ! global  ! height of lowest branches above ground (m)
   REAL(KIND=r8), INTENT(IN   ) :: alaimu		! global  ! upper canopy leaf & stem area (2 sided) for 
                                                          ! normalization of drag coefficient (m2 m-2)
   REAL(KIND=r8), INTENT(INOUT) :: froot    (npoi,nsoilay,2)! global! fraction of root in soil layer 
   REAL(KIND=r8), INTENT(INOUT) :: q34      (npoi)	 ! global! specific humidity of air at z34
   REAL(KIND=r8), INTENT(INOUT) :: q12      (npoi)	 ! global! specific humidity of air at z12
   REAL(KIND=r8), INTENT(INOUT) :: su       (npoi)	 ! local ! air-vegetation transfer coefficients (*rhoa) for
                                                 ! upper canopy leaves (m s-1 * kg m-3) (A39a Pollard & Thompson 1995)
   REAL(KIND=r8), INTENT(IN   ) :: cleaf		 ! global ! empirical constant in upper canopy leaf-air 
                                                 ! aerodynamic transfer coefficient (m s-0.5) (A39a Pollard & Thompson 95)
   REAL(KIND=r8), INTENT(IN   ) :: dleaf    (2)	 ! global ! typical linear leaf dimension in aerodynamic transfer coefficient (m)
   REAL(KIND=r8), INTENT(INOUT) :: ss       (npoi)	 ! local! air-vegetation transfer coefficients (*rhoa) for 
                                                 ! upper canopy stems (m s-1 * kg m-3) (A39a Pollard & Thompson 1995)
   REAL(KIND=r8), INTENT(IN   ) :: cstem		 ! global ! empirical constant in upper canopy stem-air 
                                                 ! aerodynamic transfer coefficient (m s-0.5) (A39a Pollard & Thompson 95)
   REAL(KIND=r8), INTENT(IN   ) :: dstem    (2)	 ! global ! typical linear stem dimension in aerodynamic transfer coefficient (m)
   REAL(KIND=r8), INTENT(INOUT) :: sl       (npoi)	 ! local! air-vegetation transfer coefficients (*rhoa) for 
                                                 ! lower canopy leaves & stems (m s-1*kg m-3) (A39a Pollard & Thompson 1995)
   REAL(KIND=r8), INTENT(IN   ) :: cgrass		 ! global ! empirical constant in lower canopy-air aerodynamic 
                                                 ! transfer coefficient (m s-0.5) (A39a Pollard & Thompson 95)
   REAL(KIND=r8), INTENT(INOUT) :: ciub     (npoi)	 ! global ! intercellular co2 concentration - broadleaf (mol_co2/mol_air)
   REAL(KIND=r8), INTENT(INOUT) :: ciuc     (npoi)	 ! global ! intercellular co2 concentration - conifer	(mol_co2/mol_air)
   REAL(KIND=r8), INTENT(IN   ) :: exist    (npoi,npft)! global ! probability of existence of each plant functional type in a gridcell
   REAL(KIND=r8), INTENT(INOUT) :: csub     (npoi)	 ! global ! leaf boundary layer co2 concentration - broadleaf (mol_co2/mol_air)
   REAL(KIND=r8), INTENT(INOUT) :: gsub     (npoi)	 ! global ! upper canopy stomatal conductance - broadleaf  (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: csuc     (npoi)	 ! global ! leaf boundary layer co2 concentration - conifer   (mol_co2/mol_air)
   REAL(KIND=r8), INTENT(INOUT) :: gsuc     (npoi)	 ! global ! upper canopy stomatal conductance - conifer    (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: agcub    (npoi)	 ! local  ! canopy average gross photosynthesis rate - broadleaf  (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: agcuc    (npoi)	 ! local  ! canopy average gross photosynthesis rate - conifer    (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: ancub    (npoi)	 ! local ! canopy average net photosynthesis rate - broadleaf    (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: ancuc    (npoi)	 ! local ! canopy average net photosynthesis rate - conifer	  (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: totcondub(npoi)	 ! local ! 
   REAL(KIND=r8), INTENT(INOUT) :: totconduc(npoi)	 ! local !
   REAL(KIND=r8), INTENT(INOUT) :: cils     (npoi)	 ! global ! intercellular co2 concentration - shrubs	(mol_co2/mol_air)
   REAL(KIND=r8), INTENT(INOUT) :: cil3     (npoi)	 ! global ! intercellular co2 concentration - c3 plants (mol_co2/mol_air)
   REAL(KIND=r8), INTENT(INOUT) :: cil4     (npoi)	 ! global ! intercellular co2 concentration - c4 plants (mol_co2/mol_air)
   REAL(KIND=r8), INTENT(INOUT) :: csls     (npoi)	 ! global ! leaf boundary layer co2 concentration - shrubs   (mol_co2/mol_air)
   REAL(KIND=r8), INTENT(INOUT) :: gsls     (npoi)	 ! global ! lower canopy stomatal conductance - shrubs     (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: csl3     (npoi)	 ! global ! leaf boundary layer co2 concentration - c3 plants (mol_co2/mol_air)
   REAL(KIND=r8), INTENT(INOUT) :: gsl3     (npoi)	 ! global ! lower canopy stomatal conductance - c3 grasses (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: csl4     (npoi)	 ! global ! leaf boundary layer co2 concentration - c4 plants (mol_co2/mol_air)
   REAL(KIND=r8), INTENT(INOUT) :: gsl4     (npoi)	 ! global ! lower canopy stomatal conductance - c4 grasses (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: agcls    (npoi)	 ! local  ! canopy average gross photosynthesis rate - shrubs	  (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: agcl4    (npoi)	 ! local ! canopy average gross photosynthesis rate - c4 grasses (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: agcl3    (npoi)	 ! local ! canopy average gross photosynthesis rate - c3 grasses (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: ancls    (npoi)	 ! local ! canopy average net photosynthesis rate - shrubs	  (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: ancl4    (npoi)	 ! local ! canopy average net photosynthesis rate - c4 grasses   (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: ancl3    (npoi)	 ! local ! canopy average net photosynthesis rate - c3 grasses   (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: totcondls(npoi)	 ! local ! 
   REAL(KIND=r8), INTENT(INOUT) :: totcondl3(npoi)	 ! local !
   REAL(KIND=r8), INTENT(INOUT) :: totcondl4(npoi)	 ! local !
   REAL(KIND=r8), INTENT(IN   ) :: chu(1:nVegClass)             ! global ! heat capacity of upper canopy leaves per unit leaf area (J kg-1 m-2)
   REAL(KIND=r8), INTENT(IN   ) :: chs(1:nVegClass)             ! global ! heat capacity of upper canopy stems per unit stem area (J kg-1 m-2)
   REAL(KIND=r8), INTENT(IN   ) :: chl(1:nVegClass)             ! global ! heat capacity of lower canopy leaves & stems per unit leaf/stem area (J kg-1 m-2)
   REAL(KIND=r8), INTENT(INOUT) :: frac     (npoi,npft)  ! global ! fraction of canopy occupied by each plant functional type
   REAL(KIND=r8), INTENT(INOUT) :: tlsub    (npoi)	 ! global ! temperature of lower canopy vegetation buried by snow (K)
!      INCLUDE 'comsat.h'    
!      include 'comsno.h'
   REAL(KIND=r8), INTENT(IN   ) :: z0sno  ! global ! roughness length of snow surface (m)
   REAL(KIND=r8), INTENT(IN   ) :: rhos   ! global ! density of snow (kg m-3)
   REAL(KIND=r8), INTENT(IN   ) :: consno ! global ! thermal conductivity of snow (W m-1 K-1)
   REAL(KIND=r8), INTENT(IN   ) :: hsnotop! global ! thickness of top snow layer (m)
   REAL(KIND=r8), INTENT(IN   ) :: hsnomin! global ! minimum total thickness of snow (m)
   REAL(KIND=r8), INTENT(IN   ) :: fimin  ! global ! minimum fractional snow cover
   REAL(KIND=r8), INTENT(IN   ) :: fimax  ! global ! maximum fractional snow cover
   REAL(KIND=r8), INTENT(INOUT) :: fi     (npoi)! global ! fractional snow cover
   REAL(KIND=r8), INTENT(INOUT) :: tsno   (npoi,nsnolay)! global ! temperature of snow layers (K)
   REAL(KIND=r8), INTENT(INOUT) :: hsno   (npoi,nsnolay)! global ! thickness of snow layers (m)

!      INCLUDE 'comsoi.h'
   REAL(KIND=r8), INTENT(IN   ) :: sand    (npoi,nsoilay)! global ! percent sand of soil
   REAL(KIND=r8), INTENT(IN   ) :: clay    (npoi,nsoilay)! global ! percent clay of soil
   REAL(KIND=r8), INTENT(IN   ) :: poros   (npoi,nsoilay)! global ! porosity (mass of h2o per unit vol at sat / rhow)
   REAL(KIND=r8), INTENT(INOUT) :: wsoi    (npoi,nsoilay)! global ! fraction of soil pore space containing liquid water
   REAL(KIND=r8), INTENT(INOUT) :: wisoi   (npoi,nsoilay)! global ! fraction of soil pore space containing ice
   REAL(KIND=r8), INTENT(INOUT) :: consoi  (npoi,nsoilay)! local  ! thermal conductivity of each soil layer (W m-1 K-1)
   REAL(KIND=r8), INTENT(IN   ) :: zwpmax		   ! global ! assumed maximum fraction of soil surface 
   					! covered by puddles (dimensionless)
   REAL(KIND=r8), INTENT(INOUT) :: wpud    (npoi)! global ! liquid content of puddles per soil area (kg m-2)
   REAL(KIND=r8), INTENT(INOUT) :: wipud   (npoi)! global ! ice content of puddles per soil area (kg m-2)
   REAL(KIND=r8), INTENT(IN   ) :: wpudmax			! normalization constant for puddles (kg m-2)
   REAL(KIND=r8), INTENT(INOUT) :: qglif   (npoi,4) ! local ! 1: fraction of soil evap (fvapg) from soil liquid
   					! 2: fraction of soil evap (fvapg) from soil ice
   					! 3: fraction of soil evap (fvapg) from puddle liquid
   					! 4: fraction of soil evap (fvapg) from puddle ice
   REAL(KIND=r8), INTENT(INOUT) :: tsoi    (npoi,nsoilay)! global	! soil temperature for each layer (K)
   REAL(KIND=r8), INTENT(INOUT) :: hvasug  (npoi) ! local ! latent heat of vap/subl, for soil surface (J kg-1)
   REAL(KIND=r8), INTENT(INOUT) :: hvasui  (npoi)! local ! latent heat of vap/subl, for snow surface (J kg-1)
   REAL(KIND=r8), INTENT(IN   ) :: albsav  (npoi)! global ! saturated soil surface albedo (visible waveband)
   REAL(KIND=r8), INTENT(IN   ) :: albsan  (npoi)! global ! saturated soil surface albedo (near-ir waveband)
   REAL(KIND=r8), INTENT(INOUT) :: tg      (npoi)! global ! soil skin temperature (K)
   REAL(KIND=r8), INTENT(INOUT) :: ti      (npoi)! global ! snow skin temperature (K)
   REAL(KIND=r8), INTENT(IN   ) :: z0soi   (npoi)! global ! roughness length of soil surface (m)
   REAL(KIND=r8), INTENT(IN   ) :: swilt   (npoi,nsoilay)! global ! wilting soil moisture value (fraction of pore space)
   REAL(KIND=r8), INTENT(IN   ) :: sfield  (npoi,nsoilay)! global ! field capacity soil moisture value (fraction of pore space)
   REAL(KIND=r8), INTENT(INOUT) :: stressl (npoi,nsoilay)! local ! soil moisture stress factor for the lower canopy (dimensionless)
   REAL(KIND=r8), INTENT(INOUT) :: stressu (npoi,nsoilay)! local ! soil moisture stress factor for the upper canopy (dimensionless)
   REAL(KIND=r8), INTENT(INOUT) :: stresstl(npoi) ! local ! sum of stressl over all 6 soil layers (dimensionless)
   REAL(KIND=r8), INTENT(INOUT) :: stresstu(npoi)! local ! sum of stressu over all 6 soil layers (dimensionless)
   REAL(KIND=r8), INTENT(IN   ) :: csoi    (npoi,nsoilay)! global ! specific heat of soil, no pore spaces (J kg-1 deg-1)
   REAL(KIND=r8), INTENT(IN   ) :: rhosoi  (npoi,nsoilay)! global ! soil density (without pores, not bulk) (kg m-3)
   REAL(KIND=r8), INTENT(IN   ) :: hsoi    (npoi,nsoilay+1)   ! global ! soil layer thickness (m)
   REAL(KIND=r8), INTENT(IN   ) :: suction (npoi,nsoilay)! global ! saturated matric potential (m-h2o)
   REAL(KIND=r8), INTENT(IN   ) :: bex     (npoi,nsoilay)! global ! exponent "b" in soil water potential
   REAL(KIND=r8), INTENT(INOUT) :: upsoiu  (npoi,nsoilay)! local  ! soil water uptake from transpiration (kg_h2o m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: upsoil  (npoi,nsoilay)! local  ! soil water uptake from transpiration (kg_h2o m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: heatg   (npoi)	! local	! net heat flux into soil surface (W m-2)
   REAL(KIND=r8), INTENT(INOUT) :: heati   (npoi)	! local	! net heat flux into snow surface (W m-2)
   REAL(KIND=r8), INTENT(IN   ) :: hydraul (npoi,nsoilay)! global ! saturated hydraulic conductivity (m/s)
   REAL(KIND=r8), INTENT(INOUT) :: porosflo(npoi,nsoilay)! global ! porosity after reduction by ice content
   INTEGER, INTENT(IN   ) :: ibex    (npoi,nsoilay)! global ! nint(bex), used for cpu speed
   REAL(KIND=r8), INTENT(IN   ) :: bperm (npoi)  ! global! lower b.c. for soil profile drainage 
   					! (0.0 = impermeable; 1.0 = fully permeable)
   REAL(KIND=r8), INTENT(INOUT) :: hflo    (npoi,nsoilay+1)  ! downward heat transport through soil layers (W m-2)
 

!   INCLUDE 'comatm.h'
   REAL(KIND=r8), INTENT(IN   ) :: ta     (npoi)	 ! global ! air temperature (K)
   REAL(KIND=r8), INTENT(INOUT) :: asurd  (npoi,nband) ! local  ! direct albedo of surface system
   REAL(KIND=r8), INTENT(INOUT) :: asuri  (npoi,nband) ! local  ! diffuse albedo of surface system 
   REAL(KIND=r8), INTENT(IN   ) :: coszen (npoi)	 ! global ! cosine of solar zenith angle
   REAL(KIND=r8), INTENT(IN   ) :: solad  (npoi,nband) ! global ! direct downward solar flux (W m-2)
   REAL(KIND=r8), INTENT(IN   ) :: solai  (npoi,nband) ! global ! diffuse downward solar flux (W m-2)
   REAL(KIND=r8), INTENT(IN   ) :: fira   (npoi)	 ! global ! incoming ir flux (W m-2)
   REAL(KIND=r8), INTENT(IN   ) :: raina  (npoi)	 ! global ! rainfall rate (mm/s or kg m-2 s-1)
   REAL(KIND=r8), INTENT(IN   ) :: qa     (npoi)	 ! global ! specific humidity (kg_h2o/kg_air)
   REAL(KIND=r8), INTENT(IN   ) :: psurf  (npoi)	 ! global ! surface pressure (Pa)
   REAL(KIND=r8), INTENT(IN   ) :: snowa  (npoi)	 ! global ! snowfall rate (mm/s or kg m-2 s-1 of water)
   REAL(KIND=r8), INTENT(IN   ) :: ua     (npoi)	 ! global ! wind speed (m s-1)
   REAL(KIND=r8), INTENT(IN   ) :: o2conc		 ! global ! o2 concentration (mol/mol)
   REAL(KIND=r8), INTENT(IN   ) :: co2conc		 ! global ! co2 concentration (mol/mol)

!   INCLUDE 'com1d.h'
   REAL(KIND=r8), INTENT(INOUT) :: fwetu    (npoi)	 ! local ! fraction of upper canopy leaf area wetted by intercepted liquid and/or snow
   REAL(KIND=r8), INTENT(INOUT) :: rliqu    (npoi)	 ! local ! proportion of fwetu due to liquid
   REAL(KIND=r8), INTENT(INOUT) :: fwets    (npoi)	 ! local ! fraction of upper canopy stem area wetted by intercepted liquid and/or snow
   REAL(KIND=r8), INTENT(INOUT) :: rliqs    (npoi)	 ! local ! proportion of fwets due to liquid
   REAL(KIND=r8), INTENT(INOUT) :: fwetl    (npoi)	 ! local ! fraction of lower canopy stem & leaf area wetted by
                                                 ! intercepted liquid and/or snow
   REAL(KIND=r8), INTENT(INOUT) :: rliql    (npoi)	 ! local ! proportion of fwetl due to liquid
   REAL(KIND=r8), INTENT(INOUT) :: solu     (npoi)	 ! local ! solar flux (direct + diffuse) absorbed by upper 
                                                 ! canopy leaves per unit canopy area (W m-2)
   REAL(KIND=r8), INTENT(INOUT) :: sols     (npoi)	 ! local ! solar flux (direct + diffuse) absorbed by upper 
                                                 ! canopy stems per unit canopy area (W m-2)
   REAL(KIND=r8), INTENT(INOUT) :: soll     (npoi)	 ! local ! solar flux (direct + diffuse) absorbed by lower 
                                                 ! canopy leaves and stems per unit canopy area (W m-2)
   REAL(KIND=r8), INTENT(INOUT) :: solg     (npoi)	 ! local ! solar flux (direct + diffuse) absorbed by unit 
                                                 ! snow-free soil (W m-2)
   REAL(KIND=r8), INTENT(INOUT) :: soli     (npoi)	 ! local ! solar flux (direct + diffuse) absorbed by unit 
                                                 ! snow surface (W m-2)
   REAL(KIND=r8), INTENT(INOUT) :: scalcoefl(npoi,4)   ! local ! term needed in lower canopy scaling
   REAL(KIND=r8), INTENT(INOUT) :: scalcoefu(npoi,4)   ! local ! term needed in upper canopy scaling
   INTEGER, INTENT(INOUT) :: indsol   (npoi)	 ! local ! index of current strip for points with positive coszen
   REAL(KIND=r8), INTENT(INOUT) :: albsod   (npoi)	 ! local ! direct  albedo for soil surface (visible or IR)
   REAL(KIND=r8), INTENT(INOUT) :: albsoi   (npoi)	 ! local ! diffuse albedo for soil surface (visible or IR)
   REAL(KIND=r8), INTENT(INOUT) :: albsnd   (npoi)	 ! local ! direct  albedo for snow surface (visible or IR)
   REAL(KIND=r8), INTENT(INOUT) :: albsni   (npoi)	 ! local ! diffuse albedo for snow surface (visible or IR)
   REAL(KIND=r8), INTENT(OUT  ) :: relod    (npoi)	 ! local ! upward direct radiation per unit icident direct beam on lower canopy (W m-2)
   REAL(KIND=r8), INTENT(OUT  ) :: reloi    (npoi)	 ! local ! upward diffuse radiation per unit incident diffuse 
                                                 ! radiation on lower canopy (W m-2)
   REAL(KIND=r8), INTENT(OUT  ) :: reupd    (npoi)	 ! local ! upward direct radiation per unit incident direct 
                                                 ! radiation on upper canopy (W m-2)
   REAL(KIND=r8), INTENT(OUT  ) :: reupi    (npoi)	 ! local ! upward diffuse radiation per unit incident diffuse 
                                                 ! radiation on upper canopy (W m-2)
   REAL(KIND=r8), INTENT(INOUT) :: ablod    (npoi)	 ! local ! fraction of direct  radiation absorbed by lower canopy
   REAL(KIND=r8), INTENT(INOUT) :: abloi    (npoi)	 ! local ! fraction of diffuse radiation absorbed by lower canopy
   REAL(KIND=r8), INTENT(INOUT) :: flodd    (npoi)	 ! local ! downward direct radiation per unit incident direct
                                                 ! radiation on lower canopy (W m-2)
   REAL(KIND=r8), INTENT(OUT  ) :: dummy    (npoi)	 ! local ! placeholder, always = 0: no direct flux produced for diffuse incident
   REAL(KIND=r8), INTENT(INOUT) :: flodi    (npoi)	 ! local ! downward diffuse radiation per unit incident direct
                                                 ! radiation on lower canopy (W m-2)
   REAL(KIND=r8), INTENT(INOUT) :: floii    (npoi)	 ! local ! downward diffuse radiation per unit incident 
                                                 ! diffuse radiation on lower canopy
   REAL(KIND=r8), INTENT(INOUT) :: terml    (npoi,7)	 ! local ! term needed in lower canopy scaling
   REAL(KIND=r8), INTENT(INOUT) :: termu    (npoi,7)	 ! local ! term needed in upper canopy scaling
   REAL(KIND=r8), INTENT(INOUT) :: abupd    (npoi)	 ! local ! fraction of direct  radiation absorbed by upper canopy
   REAL(KIND=r8), INTENT(INOUT) :: abupi    (npoi)	 ! local ! fraction of diffuse radiation absorbed by upper canopy
   REAL(KIND=r8), INTENT(INOUT) :: fupdd    (npoi)	 ! local ! downward direct radiation per unit incident direct
                                                 ! beam on upper canopy (W m-2)
   REAL(KIND=r8), INTENT(INOUT) :: fupdi    (npoi)	 ! local ! downward diffuse radiation per unit icident direct
                                                 ! radiation on upper canopy (W m-2)
   REAL(KIND=r8), INTENT(INOUT) :: fupii    (npoi)	 ! local ! downward diffuse radiation per unit incident diffuse
                                                 ! radiation on upper canopy (W m-2)
   REAL(KIND=r8), INTENT(OUT  ) :: sol2d    (npoi)	 ! local ! direct downward radiation  out of upper canopy 
                                                 ! per unit vegetated (upper) area (W m-2)
   REAL(KIND=r8), INTENT(OUT  ) :: sol2i    (npoi)	 ! local ! diffuse downward radiation out of upper
                                                 ! canopy per unit vegetated (upper) area(W m-2)
   REAL(KIND=r8), INTENT(OUT  ) :: sol3d    (npoi)	 ! local ! direct downward radiation  out of upper
                                                 ! canopy + gaps per unit grid cell area (W m-2)
   REAL(KIND=r8), INTENT(OUT  ) :: sol3i    (npoi)	 ! local ! diffuse downward radiation out of upper
                                                 ! canopy + gaps per unit grid cell area (W m-2)
   REAL(KIND=r8), INTENT(INOUT) :: firb     (npoi)	 ! local ! net upward ir radiation at reference
                                                 ! atmospheric level za (W m-2)
   REAL(KIND=r8), INTENT(INOUT) :: firs     (npoi)	 ! local ! ir radiation absorbed by upper canopy stems (W m-2)
   REAL(KIND=r8), INTENT(INOUT) :: firu     (npoi)	 ! local ! ir raditaion absorbed by upper canopy leaves (W m-2)
   REAL(KIND=r8), INTENT(INOUT) :: firl     (npoi)	 ! local ! ir radiation absorbed by lower canopy leaves and stems (W m-2)
   REAL(KIND=r8), INTENT(INOUT) :: firg     (npoi)	 ! local ! ir radiation absorbed by soil/ice (W m-2)
   REAL(KIND=r8), INTENT(INOUT) :: firi     (npoi)	 ! local ! ir radiation absorbed by snow (W m-2)
   REAL(KIND=r8), INTENT(INOUT) :: snowg    (npoi)	 ! local ! snowfall rate at soil level (kg h2o m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: tsnowg   (npoi)	 ! local ! snowfall temperature at soil level (K) 
   REAL(KIND=r8), INTENT(INOUT) :: tsnowl   (npoi)	 ! local ! snowfall temperature below upper canopy (K)
   REAL(KIND=r8), INTENT(INOUT) :: pfluxl   (npoi)	 ! local ! heat flux on lower canopy leaves & stems due to intercepted h2o (W m-2)
   REAL(KIND=r8), INTENT(INOUT) :: raing    (npoi)	 ! local ! rainfall rate at soil level (kg m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: traing   (npoi)	 ! local ! rainfall temperature at soil level (K)
   REAL(KIND=r8), INTENT(INOUT) :: trainl   (npoi)	 ! local ! rainfall temperature below upper canopy (K)
   REAL(KIND=r8), INTENT(INOUT) :: snowl    (npoi)	 ! local ! snowfall rate below upper canopy (kg h2o m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: tsnowu   (npoi)	 ! local ! snowfall temperature above upper canopy (K)
   REAL(KIND=r8), INTENT(INOUT) :: pfluxu   (npoi)	 ! local ! heat flux on upper canopy leaves due to intercepted h2o (W m-2)
   REAL(KIND=r8), INTENT(INOUT) :: rainu    (npoi)	 ! local  ! rainfall rate above upper canopy (kg m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: trainu   (npoi)	 ! local  ! rainfall temperature above upper canopy (K)
   REAL(KIND=r8), INTENT(INOUT) :: snowu    (npoi)	 ! local ! snowfall rate above upper canopy (kg h2o m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: pfluxs   (npoi)	 ! local ! heat flux on upper canopy stems due to intercepted h2o (W m-2)
   REAL(KIND=r8), INTENT(INOUT) :: rainl    (npoi)	 ! local ! rainfall rate below upper canopy (kg m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: bps      (npoi)            ! local ! (ps/p) ** (rair/cair) for atmospheric level  (const)
   REAL(KIND=r8):: rhoa     (npoi)	 ! local ! air density at za (allowing for h2o vapor) (kg m-3)
   REAL(KIND=r8), INTENT(INOUT) :: cp       (npoi)	 ! local ! specific heat of air at za (allowing for h2o vapor) (J kg-1 K-1)
   REAL(KIND=r8), INTENT(IN   ) :: za       (npoi)	 ! local ! height above the surface of atmospheric forcing (m)
   REAL(KIND=r8), INTENT(INOUT) :: bdl      (npoi)	 ! local ! aerodynamic coefficient ([(tau/rho)/u**2] for
                                                 ! laower canopy (A31/A30 Pollard & Thompson 1995)
   REAL(KIND=r8), INTENT(INOUT) :: dil      (npoi)	 ! local ! inverse of momentum diffusion coefficient within lower canopy (m)
   REAL(KIND=r8), INTENT(INOUT) :: z3       (npoi)	 ! local ! effective top of the lower canopy (for momentum) (m)
   REAL(KIND=r8), INTENT(INOUT) :: z4       (npoi)	 ! local ! effective bottom of the lower canopy (for momentum) (m)
   REAL(KIND=r8), INTENT(INOUT) :: z34      (npoi)	 ! local ! effective middle of the lower canopy (for momentum) (m)
   REAL(KIND=r8), INTENT(INOUT) :: exphl    (npoi)	 ! local ! exp(lamda/2*(z3-z4)) for lower canopy (A30 Pollard & Thompson)
   REAL(KIND=r8), INTENT(INOUT) :: expl     (npoi)	 ! local ! exphl**2
   REAL(KIND=r8), INTENT(INOUT) :: displ    (npoi)	 ! local ! zero-plane displacement height for lower canopy (m)
   REAL(KIND=r8), INTENT(INOUT) :: bdu      (npoi)	 ! local ! aerodynamic coefficient ([(tau/rho)/u**2] for upper
                                                 ! canopy (A31/A30 Pollard & Thompson 1995)
   REAL(KIND=r8), INTENT(INOUT) :: diu      (npoi)	 ! local ! inverse of momentum diffusion coefficient within upper canopy (m)
   REAL(KIND=r8), INTENT(INOUT) :: z1       (npoi)	 ! local ! effective top of upper canopy (for momentum) (m)
   REAL(KIND=r8), INTENT(INOUT) :: z2       (npoi)	 ! local ! effective bottom of the upper canopy (for momentum) (m)
   REAL(KIND=r8), INTENT(INOUT) :: z12      (npoi)	 ! local ! effective middle of the upper canopy (for momentum) (m)
   REAL(KIND=r8), INTENT(INOUT) :: exphu    (npoi)	 ! local ! exp(lamda/2*(z3-z4)) for upper canopy (A30 Pollard & Thompson)
   REAL(KIND=r8), INTENT(INOUT) :: expu     (npoi)	 ! local ! exphu**2
   REAL(KIND=r8), INTENT(INOUT) :: dispu    (npoi)	 ! local ! zero-plane displacement height for upper canopy (m)
   REAL(KIND=r8), INTENT(INOUT) :: alogg    (npoi)	 ! local ! log of soil roughness
   REAL(KIND=r8), INTENT(INOUT) :: alogi    (npoi)	 ! local ! log of snow roughness
   REAL(KIND=r8), INTENT(INOUT) :: alogav   (npoi)	 ! local ! average of alogi and alogg 
   REAL(KIND=r8), INTENT(INOUT) :: alog4    (npoi)	 ! local ! log (max(z4, 1.1*z0sno, 1.1*z0soi)) 
   REAL(KIND=r8), INTENT(INOUT) :: alog3    (npoi)	 ! local ! log (z3 - displ)
   REAL(KIND=r8), INTENT(INOUT) :: alog2    (npoi)	 ! local ! log (z2 - displ)
   REAL(KIND=r8), INTENT(INOUT) :: alog1    (npoi)	 ! local ! log (z1 - dispu) 
   REAL(KIND=r8), INTENT(INOUT) :: aloga    (npoi)	 ! local ! log (za - dispu) 
   REAL(KIND=r8), INTENT(INOUT) :: u2       (npoi)	 ! local ! wind speed at level z2 (m s-1)
   REAL(KIND=r8), INTENT(INOUT) :: alogu    (npoi)	 ! local ! log (roughness length of upper canopy)
   REAL(KIND=r8), INTENT(INOUT) :: alogl    (npoi)	 ! local ! log (roughness length of lower canopy)
   REAL(KIND=r8), INTENT(INOUT) :: richl    (npoi)	 ! local ! richardson number for air above upper canopy (z3 to z2)
   REAL(KIND=r8), INTENT(INOUT) :: straml   (npoi)	 ! local ! momentum correction factor for stratif between
                                                         ! upper & lower canopy (z3 to z2) (louis et al.)
   REAL(KIND=r8), INTENT(INOUT)  :: strahl   (npoi)	 ! local ! heat/vap correction factor for stratif between
                                                         ! upper & lower canopy (z3 to z2) (louis et al.)
   REAL(KIND=r8), INTENT(INOUT)  :: richu    (npoi)	 ! local ! richardson number for air between upper & lower canopy (z1 to za)
   REAL(KIND=r8), INTENT(INOUT)  :: stramu   (npoi)	 ! local ! momentum correction factor for stratif above
                                                         ! upper canopy (z1 to za) (louis et al.)
   REAL(KIND=r8), INTENT(INOUT)  :: strahu   (npoi)	 ! local ! heat/vap correction factor for stratif above
                                                         ! upper canopy (z1 to za) (louis et al.)
   REAL(KIND=r8), INTENT(INOUT)  :: u1       (npoi)	 ! local ! wind speed at level z1 (m s-1)
   REAL(KIND=r8), INTENT(INOUT)  :: u12      (npoi)	 ! local ! wind speed at level z12 (m s-1)
   REAL(KIND=r8), INTENT(INOUT)  :: u3       (npoi)	 ! local ! wind speed at level z3 (m s-1)
   REAL(KIND=r8), INTENT(INOUT)  :: u34      (npoi)	 ! local ! wind speed at level z34 (m s-1)
   REAL(KIND=r8), INTENT(INOUT)  :: u4       (npoi)	 ! local ! wind speed at level z4 (m s-1)
   REAL(KIND=r8), INTENT(INOUT)  :: cu       (npoi)	 ! local ! air transfer coefficient (*rhoa) (m s-1 kg m-3) for
                                                          ! upper air region (z12 --> za) (A35 Pollard & Thompson 1995)
   REAL(KIND=r8), INTENT(INOUT)  :: cl       (npoi)	 ! local ! air transfer coefficient (*rhoa) (m s-1 kg m-3)
                                                 ! between the 2 canopies (z34 --> z12) (A36 Pollard & Thompson 1995)
   REAL(KIND=r8), INTENT(INOUT)  :: sg       (npoi)	 ! local ! air-soil transfer coefficient
   REAL(KIND=r8), INTENT(INOUT)  :: si       (npoi)	 ! local ! air-snow transfer coefficient
   REAL(KIND=r8), INTENT(INOUT)  :: fwetux   (npoi)	 ! local ! fraction of upper canopy leaf area wetted if dew forms
   REAL(KIND=r8), INTENT(INOUT)  :: fwetsx   (npoi)	 ! local ! fraction of upper canopy stem area wetted if dew forms
   REAL(KIND=r8), INTENT(INOUT)  :: fwetlx   (npoi)	 ! local ! fraction of lower canopy leaf and stem area wetted if dew forms
   REAL(KIND=r8), INTENT(INOUT)  :: fsena    (npoi)	 ! local ! downward sensible heat flux between za & z12 at za (W m-2)
   REAL(KIND=r8), INTENT(INOUT)  :: fseng    (npoi)	 ! local ! upward sensible heat flux between soil surface & air at z34 (W m-2)
   REAL(KIND=r8), INTENT(INOUT)  :: fseni    (npoi)	 ! local ! upward sensible heat flux between snow surface & air at z34 (W m-2)
   REAL(KIND=r8), INTENT(INOUT)  :: fsenu    (npoi)	 ! local ! sensible heat flux from upper canopy leaves to air (W m-2)
   REAL(KIND=r8), INTENT(INOUT)  :: fsens    (npoi)	 ! local ! sensible heat flux from upper canopy stems to air (W m-2)
   REAL(KIND=r8), INTENT(INOUT)  :: fsenl    (npoi)	 ! local ! sensible heat flux from lower canopy to air (W m-2)
   REAL(KIND=r8), INTENT(INOUT)  :: fvapa    (npoi)	 ! local ! downward h2o vapor flux between za & z12 at za (kg m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT)  :: fvaput   (npoi)	 ! local ! h2o vapor flux (transpiration from dry parts) 
						                 ! between upper canopy leaves and air at z12 (kg m-2 s-1/ LAI upper canopy/ fu)
   REAL(KIND=r8), INTENT(INOUT)  :: fvaps    (npoi)	 ! local ! h2o vapor flux (evaporation from wet surface)
						                 ! between upper canopy stems and air at z12 (kg m-2 s-1 / SAI lower canopy / fu)
   REAL(KIND=r8), INTENT(INOUT)  :: fvaplw   (npoi)	 ! local ! h2o vapor flux (evaporation from wet surface) 
	                                                         ! between lower canopy leaves & stems and air at z34 (kg m-2 s-1/ LAI lower canopy/ fl)
   REAL(KIND=r8), INTENT(INOUT)  :: fvaplt   (npoi)	 ! local ! h2o vapor flux (transpiration) 
	                                                         ! between lower canopy & air at z34 (kg m-2 s-1 / LAI lower canopy / fl)
   REAL(KIND=r8), INTENT(INOUT)  :: fvapg    (npoi)	 ! local ! h2o vapor flux (evaporation) between soil & air 
	                                                         ! at z34 (kg m-2 s-1/bare ground fraction)
   REAL(KIND=r8), INTENT(INOUT)  :: fvapi    (npoi)	 ! local ! h2o vapor flux (evaporation) between snow & air at z34 (kg m-2 s-1 / fi )
   REAL(KIND=r8), INTENT(INOUT)  :: fvapuw   (npoi)	 ! local ! h2o vapor flux (evaporation from wet parts)
                                                         ! between upper canopy leaves and air at z12 (kg m-2 s-1/ LAI upper canopy/ fu)
   REAL(KIND=r8), INTENT(INOUT)  :: td       (npoi)      ! global! daily average temperature (K)

   REAL(KIND=r8), INTENT(IN   )  :: vzero   (npoi)	 ! global! a real array of zeros, of length npoi


   INTEGER, INTENT(IN   ) :: ndaypy              ! global! number of days per year
   REAL(KIND=r8), INTENT(OUT  ) :: nppdummy (npoi,npft)! local ! canopy NPP before accounting for stem and root respiration
   REAL(KIND=r8), INTENT(INOUT) :: tgpp     (npoi,npft)! local ! instantaneous GPP for each pft (mol-CO2 / m-2 / second)
   REAL(KIND=r8), INTENT(OUT  ) :: tgpptot  (npoi)	 ! local ! instantaneous gpp (mol-CO2 / m-2 / second)
   REAL(KIND=r8), INTENT(INOUT) :: tnpp     (npoi,npft)! local ! instantaneous NPP for each pft (mol-CO2 / m-2 / second)
   REAL(KIND=r8), INTENT(IN   ) :: cbiow    (npoi,npft)! global! carbon in woody biomass pool (kg_C m-2)
   REAL(KIND=r8), INTENT(IN   ) :: sapfrac  (npoi)	 ! global! fraction of woody biomass that is in sapwood
   REAL(KIND=r8), INTENT(IN   ) :: cbior    (npoi,npft)! global! carbon in fine root biomass pool (kg_C m-2)
   REAL(KIND=r8), INTENT(OUT  ) :: tnpptot  (npoi)	 ! local ! instantaneous npp (mol-CO2 / m-2 / second)
   REAL(KIND=r8), INTENT(INOUT) :: tco2root (npoi)	 ! local ! instantaneous fine co2 flux from soil (mol-CO2 / m-2 / second)
   REAL(KIND=r8), INTENT(OUT  ) :: tneetot  (npoi)	 ! local ! instantaneous net ecosystem exchange of co2 per timestep (kg_C m-2/timestep)
   REAL(KIND=r8), INTENT(INOUT) :: tco2mic  (npoi)	 ! local ! instantaneous microbial co2 flux from soil (mol-CO2 / m-2 / second)
   REAL(KIND=r8), INTENT(INOUT) :: a10td    (npoi)     ! global! 10-day average daily air temperature (K)
   REAL(KIND=r8), INTENT(INOUT) :: a10ancub (npoi)     ! global! 10-day average canopy photosynthesis rate - broadleaf (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: a10ancuc (npoi)     ! global! 10-day average canopy photosynthesis rate - conifer (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: a10ancls (npoi)     ! global! 10-day average canopy photosynthesis rate - shrubs (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: a10ancl3 (npoi)     ! global! 10-day average canopy photosynthesis rate - c3 grasses (mol_co2 m-2 s-1)
   REAL(KIND=r8), INTENT(INOUT) :: a10ancl4 (npoi)     ! global! 10-day average canopy photosynthesis rate - c4 grasses (mol_co2 m-2 s-1)

   INTEGER, INTENT(INOUT) :: ndtimes(npoi)	     ! global! counter for daily average calculations
   REAL(KIND=r8), INTENT(INOUT) :: adrain    (npoi)! global! daily average rainfall rate (mm/day)
   REAL(KIND=r8), INTENT(INOUT) :: adsnow    (npoi)! global! daily average snowfall rate (mm/day)
   REAL(KIND=r8), INTENT(INOUT) :: adaet     (npoi)! global! daily average aet (mm/day)
   REAL(KIND=r8), INTENT(INOUT) :: adtrunoff (npoi)! global! daily average total runoff (mm/day)
   REAL(KIND=r8), INTENT(INOUT) :: adsrunoff (npoi)! global! daily average surface runoff (mm/day)
   REAL(KIND=r8), INTENT(INOUT) :: addrainage(npoi)! global! daily average drainage (mm/day)
   REAL(KIND=r8), INTENT(INOUT) :: adrh      (npoi)! global! daily average rh (percent)
   REAL(KIND=r8), INTENT(INOUT) :: adsnod    (npoi)! global! daily average snow depth (m)
   REAL(KIND=r8), INTENT(INOUT) :: adsnof    (npoi)! global! daily average snow fraction (fraction)
   REAL(KIND=r8), INTENT(INOUT) :: adwsoi    (npoi)! global! daily average soil moisture (fraction)
   REAL(KIND=r8), INTENT(INOUT) :: adtsoi    (npoi)! global! daily average soil temperature (c)
   REAL(KIND=r8), INTENT(INOUT) :: adwisoi   (npoi)! global! daily average soil ice (fraction)
   REAL(KIND=r8), INTENT(INOUT) :: adtlaysoi (npoi)! global! daily average soil temperature (c) of top layer
   REAL(KIND=r8), INTENT(INOUT) :: adwlaysoi (npoi)! global! daily average soil moisture of top layer(fraction)
   REAL(KIND=r8), INTENT(INOUT) :: adwsoic   (npoi)! global! daily average soil moisture using root profile weighting (fraction)
   REAL(KIND=r8), INTENT(INOUT) :: adtsoic   (npoi)! global! daily average soil temperature (c) using profile weighting
   REAL(KIND=r8), INTENT(INOUT) :: adco2mic  (npoi)! global! daily accumulated co2 respiration from microbes (kg_C m-2 /day)
   REAL(KIND=r8), INTENT(INOUT) :: adco2root (npoi)! global! daily accumulated co2 respiration from roots (kg_C m-2 /day)
   REAL(KIND=r8), INTENT(INOUT) :: adco2soi  (npoi)! global! daily accumulated co2 respiration from soil(total) (kg_C m-2 /day)
   REAL(KIND=r8), INTENT(INOUT) :: adco2ratio(npoi)! global! ratio of root to total co2 respiration
   REAL(KIND=r8), INTENT(INOUT) :: adnmintot (npoi)! global! daily accumulated net nitrogen mineralization (kg_N m-2 /day)
   REAL(KIND=r8), INTENT(INOUT) :: adnpp     (npoi,npft)! global! daily total npp for each plant type (kg-C/m**2/day)
   REAL(KIND=r8), INTENT(INOUT) :: decompl   (npoi)! global! litter decomposition factor	      (dimensionless)
   REAL(KIND=r8), INTENT(INOUT) :: decomps   (npoi)! global! soil organic matter decomposition factor      (dimensionless)
   REAL(KIND=r8), INTENT(INOUT) :: tnmin     (npoi)! global! instantaneous nitrogen mineralization (kg_N m-2/timestep)

   INTEGER, INTENT(IN   ) :: ndaypm    (12)  ! global! number of days per month


   INTEGER, INTENT(INOUT) :: nmtimes	(npoi)           ! global! counter for monthly average calculations
   REAL(KIND=r8), INTENT(INOUT) :: amrain	(npoi)     ! global! monthly average rainfall rate (mm/day)
   REAL(KIND=r8), INTENT(INOUT) :: amsnow	(npoi)     ! global! monthly average snowfall rate (mm/day)
   REAL(KIND=r8), INTENT(INOUT) :: amaet	(npoi)     ! global! monthly average aet (mm/day)
   REAL(KIND=r8), INTENT(INOUT) :: amtrunoff  (npoi)     ! global! monthly average total runoff (mm/day)
   REAL(KIND=r8), INTENT(INOUT) :: amsrunoff  (npoi)     ! global! monthly average surface runoff (mm/day)
   REAL(KIND=r8), INTENT(INOUT) :: amdrainage (npoi)     ! global! monthly average drainage (mm/day)
   REAL(KIND=r8), INTENT(INOUT) :: amtemp	(npoi)     ! global! monthly average air temperature (C)
   REAL(KIND=r8), INTENT(INOUT) :: amqa	(npoi)     ! global! monthly average specific humidity (kg-h2o/kg-air)
   REAL(KIND=r8), INTENT(INOUT) :: amsolar	(npoi)     ! global! monthly average incident solar radiation (W/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: amirup	(npoi)     ! global! monthly average upward ir radiation (W/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: amirdown   (npoi)     ! global! monthly average downward ir radiation (W/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: amsens	(npoi)     ! global! monthly average sensible heat flux (W/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: amlatent   (npoi)     ! global! monthly average latent heat flux (W/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: amlaiu	(npoi)     ! global! monthly average lai for upper canopy (m**2/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: amlail	(npoi)     ! global! monthly average lai for lower canopy (m**2/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: amtsoi	(npoi)     ! global! monthly average 1m soil temperature (C)
   REAL(KIND=r8), INTENT(INOUT) :: amwsoi	(npoi)     ! global! monthly average 1m soil moisture (fraction)
   REAL(KIND=r8), INTENT(INOUT) :: amwisoi	(npoi)     ! global! monthly average 1m soil ice (fraction)
   REAL(KIND=r8), INTENT(INOUT) :: amvwc	(npoi)     ! global! monthly average 1m volumetric water content (fraction)
   REAL(KIND=r8), INTENT(INOUT) :: amawc	(npoi)     ! global! monthly average 1m plant-available water content (fraction)
   REAL(KIND=r8), INTENT(INOUT) :: amsnod	(npoi)     ! global! monthly average snow depth (m)
   REAL(KIND=r8), INTENT(INOUT) :: amsnof	(npoi)     ! global! monthly average snow fraction (fraction)
   REAL(KIND=r8), INTENT(INOUT) :: amnpp	(npoi,npft)! global! monthly total npp for each plant type (kg-C/m**2/month)
   REAL(KIND=r8), INTENT(OUT  ) :: amnpptot   (npoi)     ! local ! monthly total npp for ecosystem (kg-C/m**2/month)
   REAL(KIND=r8), INTENT(INOUT) :: amco2mic   (npoi)     ! global! monthly total CO2 flux from microbial respiration (kg-C/m**2/month)
   REAL(KIND=r8), INTENT(INOUT) :: amco2root  (npoi)     ! global! monthly total CO2 flux from soil due to root
                                                   ! respiration (kg-C/m**2/month)
   REAL(KIND=r8), INTENT(OUT  ) :: amco2soi   (npoi)     ! local ! monthly total soil CO2 flux from microbial
   				                   !          and root respiration (kg-C/m**2/month)
   REAL(KIND=r8), INTENT(OUT  ) :: amco2ratio (npoi)     ! local ! monthly ratio of root to total co2 flux
   REAL(KIND=r8), INTENT(OUT  ) :: amneetot   (npoi)     ! local ! monthly total net ecosystem exchange of CO2 (kg-C/m**2/month)
   REAL(KIND=r8), INTENT(INOUT) :: amnmintot  (npoi)     ! global! monthly total N mineralization from microbes (kg-N/m**2/month)
   REAL(KIND=r8), INTENT(INOUT) :: amalbedo   (npoi)	 
   REAL(KIND=r8), INTENT(INOUT) :: amtsoil    (npoi, nsoilay) 
   REAL(KIND=r8), INTENT(INOUT) :: amwsoil    (npoi, nsoilay) 
   REAL(KIND=r8), INTENT(INOUT) :: amwisoil   (npoi, nsoilay)
   REAL(KIND=r8), INTENT(INOUT) :: amts2      (npoi)     ! global
   REAL(KIND=r8), INTENT(INOUT) :: amtransu   (npoi)     ! global
   REAL(KIND=r8), INTENT(INOUT) :: amtransl   (npoi)     ! global
   REAL(KIND=r8), INTENT(INOUT) :: amsuvap    (npoi)     ! global
   REAL(KIND=r8), INTENT(INOUT) :: aminvap    (npoi)     ! global
   INTEGER, INTENT(INOUT) :: nytimes	 (npoi)	   ! global! counter for yearly average calculations
   REAL(KIND=r8), INTENT(INOUT) :: aysolar	(npoi)     ! global! annual average incident solar radiation (w/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: ayirup	(npoi)     ! global! annual average upward ir radiation (w/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: ayirdown   (npoi)     ! global! annual average downward ir radiation (w/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: aysens	(npoi)     ! global! annual average sensible heat flux (w/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: aylatent   (npoi)     ! global! annual average latent heat flux (w/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: ayprcp	(npoi)     ! global! annual average precipitation (mm/yr)
   REAL(KIND=r8), INTENT(INOUT) :: ayaet	(npoi)     ! global! annual average aet (mm/yr)
   REAL(KIND=r8), INTENT(INOUT) :: aytrans	(npoi)     ! global! annual average transpiration (mm/yr)
   REAL(KIND=r8), INTENT(INOUT) :: aytrunoff  (npoi)     ! global! annual average total runoff (mm/yr)
   REAL(KIND=r8), INTENT(INOUT) :: aysrunoff  (npoi)     ! global! annual average surface runoff (mm/yr)
   REAL(KIND=r8), INTENT(INOUT) :: aydrainage (npoi)     ! global! annual average drainage (mm/yr)
   REAL(KIND=r8), INTENT(INOUT) :: aydwtot	(npoi)     ! global! annual average soil+vegetation+snow water 
                                                           ! recharge (mm/yr or kg_h2o/m**2/yr)
   REAL(KIND=r8), INTENT(INOUT) :: aywsoi	(npoi)     ! global! annual average 1m soil moisture (fraction)
   REAL(KIND=r8), INTENT(INOUT) :: aywisoi	(npoi)     ! global! annual average 1m soil ice (fraction)
   REAL(KIND=r8), INTENT(INOUT) :: aytsoi	(npoi)     ! global! annual average 1m soil temperature (C)
   REAL(KIND=r8), INTENT(INOUT) :: ayvwc	(npoi)     ! global! annual average 1m volumetric water content (fraction)
   REAL(KIND=r8), INTENT(INOUT) :: ayawc	(npoi)     ! global! annual average 1m plant-available water content (fraction)
   REAL(KIND=r8), INTENT(INOUT) :: aystresstu (npoi)     ! global! annual average soil moisture stress 
   						           ! parameter for upper canopy (dimensionless)
   REAL(KIND=r8), INTENT(INOUT) :: aystresstl(npoi)      ! global! annual average soil moisture stress 
   				                           ! parameter for lower canopy (dimensionless)
   REAL(KIND=r8), INTENT(INOUT) :: aygpp     (npoi,npft) ! global! annual gross npp for each plant type(kg-c/m**2/yr)
   REAL(KIND=r8), INTENT(OUT  ) :: aygpptot  (npoi)      ! local ! annual total gpp for ecosystem (kg-c/m**2/yr)
   REAL(KIND=r8), INTENT(INOUT) :: aynpp     (npoi,npft) ! global! annual total npp for each plant type(kg-c/m**2/yr)
   REAL(KIND=r8), INTENT(OUT  ) :: aynpptot  (npoi)      ! local ! annual total npp for ecosystem (kg-c/m**2/yr)
   REAL(KIND=r8), INTENT(INOUT) :: ayco2mic  (npoi)      ! global! annual total CO2 flux from microbial respiration (kg-C/m**2/yr)
   REAL(KIND=r8), INTENT(INOUT) :: ayco2root (npoi)      ! global! annual total CO2 flux from soil due to root respiration (kg-C/m**2/yr)
   REAL(KIND=r8), INTENT(OUT  ) :: ayco2soi  (npoi)      ! local ! annual total soil CO2 flux from microbial and 
                                                           ! root respiration (kg-C/m**2/yr)
   REAL(KIND=r8), INTENT(OUT  ) :: ayneetot  (npoi)      ! local! annual total NEE for ecosystem (kg-C/m**2/yr)
   REAL(KIND=r8), INTENT(INOUT) :: ayrootbio (npoi)      ! global! annual average live root biomass (kg-C / m**2)
   REAL(KIND=r8), INTENT(INOUT) :: aynmintot (npoi)      ! global! annual total nitrogen mineralization (kg-N/m**2/yr)
   REAL(KIND=r8), INTENT(INOUT) :: ayalit    (npoi)      ! global! aboveground litter (kg-c/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: ayblit    (npoi)      ! global! belowground litter (kg-c/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: aycsoi    (npoi)      ! global! total soil carbon (kg-c/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: aycmic    (npoi)      ! global! total soil carbon in microbial biomass (kg-c/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: ayanlit   (npoi)      ! global! aboveground litter nitrogen (kg-N/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: aybnlit   (npoi)      ! global! belowground litter nitrogen (kg-N/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: aynsoi    (npoi)      ! global! total soil nitrogen (kg-N/m**2)
   REAL(KIND=r8), INTENT(INOUT) :: ayalbedo  (npoi)  
   REAL(KIND=r8), INTENT(INOUT) :: totalit   (npoi)	   ! global! total standing aboveground litter (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: totrlit   (npoi)	   ! global! total root litter carbon belowground (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: totcsoi   (npoi)	   ! global! total carbon in all soil pools (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: totcmic   (npoi)	   ! global! total carbon residing in microbial pools (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: totanlit  (npoi)	   ! global! total standing aboveground nitrogen in litter (kg_N m-2)
   REAL(KIND=r8), INTENT(INOUT) :: totrnlit  (npoi)      ! global! total root litter nitrogen belowground (kg_N m-2)
   REAL(KIND=r8), INTENT(INOUT) :: totnsoi   (npoi)      ! global! total nitrogen in soil (kg_N m-2)
   REAL(KIND=r8), INTENT(OUT  ) :: totnmic   (npoi)      ! local! total nitrogen residing in microbial pool (kg_N m-2)
   REAL(KIND=r8), INTENT(INOUT) :: totlit    (npoi)      ! local! total carbon in all litter pools (kg_C m-2)
   REAL(KIND=r8), INTENT(OUT  ) :: totfall   (npoi)      ! local! total litterfall and root turnover (kg_C m-2/year)
   REAL(KIND=r8), INTENT(OUT  ) :: totnlit   (npoi)      ! local! total nitrogen in all litter pools (kg_N m-2)

   REAL(KIND=r8), INTENT(INOUT) :: firefac   (npoi)     ! global! factor that respresents the annual average
   REAL(KIND=r8), INTENT(INOUT) :: wtot      (npoi)     ! global! total amount of water stored in snow, soil,
                                                          ! puddels, and on vegetation (kg_h2o)
   						          ! fuel dryness of a grid cell, and hence characterizes the readiness to burn

   REAL(KIND=r8), INTENT(INOUT) :: storedn (npoi)	! global ! total storage of N in soil profile (kg_N m-2) 
   REAL(KIND=r8), INTENT(INOUT) :: yrleach (npoi)	! global ! annual total amount C leached from soil profile (kg_C m-2/yr)
   REAL(KIND=r8), INTENT(INOUT) :: ynleach (npoi)
   REAL(KIND=r8), INTENT(IN   ) :: falll   (npoi)     ! global ! annual leaf litter fall (kg_C m-2/year)
   REAL(KIND=r8), INTENT(IN   ) :: fallr   (npoi)     ! global ! annual root litter input		    (kg_C m-2/year)
   REAL(KIND=r8), INTENT(IN   ) :: fallw   (npoi)     ! global! annual wood litter fall		    (kg_C m-2/year)

   REAL(KIND=r8), INTENT(INOUT) :: clitlm  (npoi)     ! global! carbon in leaf litter pool - metabolic       (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: clitls  (npoi)     ! global! carbon in leaf litter pool - structural      (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: clitrm  (npoi)     ! global! carbon in fine root litter pool - metabolic  (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: clitrs  (npoi)     ! global! carbon in fine root litter pool - structural (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: clitwm  (npoi)     ! global! carbon in woody litter pool - metabolic      (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: clitws  (npoi)     ! global! carbon in woody litter pool - structural     (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: csoislop(npoi)     ! global! carbon in soil - slow protected humus  	 (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: csoislon(npoi)     ! global! carbon in soil - slow nonprotected humus     (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: csoipas (npoi)     ! global! carbon in soil - passive humus 		  (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: clitll  (npoi)     ! global! carbon in leaf litter pool - lignin	   (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: clitrl  (npoi)     ! global! carbon in fine root litter pool - lignin     (kg_C m-2)
   REAL(KIND=r8), INTENT(INOUT) :: clitwl  (npoi)     ! global! carbon in woody litter pool - lignin	   (kg_C m-2)


   REAL(KIND=r8), INTENT(IN   ) :: tc      (npoi)	! global  ! coldest monthly temperature (C)
   REAL(KIND=r8), INTENT(INOUT) :: agddu   (npoi)	! global  ! annual accumulated growing degree days for bud
   				                          ! burst, upper canopy (day-degrees)
   REAL(KIND=r8), INTENT(INOUT) :: tempu   (npoi)	! global  ! cold-phenology trigger for trees (non-dimensional)
   REAL(KIND=r8), INTENT(INOUT) :: agddl   (npoi)	! global  ! annual accumulated growing degree days for bud burst,
   				                          ! lower canopy (day-degrees)
   REAL(KIND=r8), INTENT(INOUT) :: templ   (npoi)	! global  ! cold-phenology trigger for grasses/shrubs (non-dimensional)
   REAL(KIND=r8), INTENT(INOUT) :: dropu   (npoi)	! global  ! drought-phenology trigger for trees (non-dimensional)
   REAL(KIND=r8), INTENT(INOUT) :: dropls  (npoi)	! global  ! drought-phenology trigger for shrubs (non-dimensional)
   REAL(KIND=r8), INTENT(INOUT) :: dropl4  (npoi)	! global  ! drought-phenology trigger for c4 grasses (non-dimensional)
   REAL(KIND=r8), INTENT(INOUT) :: dropl3  (npoi)	! global  ! drought-phenology trigger for c3 grasses (non-dimensional)
   REAL(KIND=r8), INTENT(IN   ) :: plai    (npoi,npft)! global  ! total leaf area index of each plant functional type

      REAL(KIND=r8), INTENT(INOUT) :: ynleach_p (npoi) ! annual total amount P leached from soil profile (kg_N m-2/yr)
      REAL(KIND=r8), INTENT(OUT  ) :: tnmin_p   (npoi)   ! instantaneous phosphorus mineralization         (kg_N m-2/timestep)
      REAL(KIND=r8), INTENT(OUT  ) :: totnmic_p (npoi)   ! total phosphorus residing in microbial pool     (kg_N m-2)
      REAL(KIND=r8), INTENT(OUT  ) :: totnlit_p (npoi)   ! total phosphorus in all litter pools            (kg_N m-2)
      REAL(KIND=r8), INTENT(OUT  ) :: totanlit_p(npoi)   ! total standing aboveground phosphorus in litter (kg_N m-2)
      REAL(KIND=r8), INTENT(OUT  ) :: totrnlit_p(npoi)   ! total root litter phosphorus belowground        (kg_N m-2)
      REAL(KIND=r8), INTENT(OUT  ) :: totnsoi_p (npoi)   ! total phosphorus in soil                        (kg_N m-2)
      REAL(KIND=r8), INTENT(INOUT) :: storedn_p (npoi)   ! total storage of P in soil profile (kg_N m-2) 
   REAL(KIND=r8), INTENT(IN   ) :: adfalll   (npoi)     ! global ! annual leaf litter fall (kg_C m-2/year)
   REAL(KIND=r8), INTENT(IN   ) :: adfallr   (npoi)     ! global ! annual root litter input		    (kg_C m-2/year)
   REAL(KIND=r8), INTENT(IN   ) :: adfallw   (npoi)     ! global! annual wood litter fall		    (kg_C m-2/year)
      REAL(KIND=r8), INTENT(INOUT) :: adcbiol (npoi,npft)   
      REAL(KIND=r8), INTENT(INOUT) :: adcbior (npoi,npft)  
      REAL(KIND=r8), INTENT(INOUT) :: adcbiow (npoi,npft)
   REAL(KIND=r8), INTENT(IN   ) :: adplai    (npoi,npft)! global  ! total leaf area index of each plant functional type
   INTEGER, INTENT(IN   ) :: nstep
    REAL(KIND=r8), INTENT(IN   ) :: beta1(nVegClass)
    REAL(KIND=r8), INTENT(IN   ) :: beta2(nVegClass)
    REAL(KIND=r8), INTENT(IN   ) :: stressfac(nVegClass)
    REAL(KIND=r8), INTENT(IN   ) :: avmuir_factor(nVegClass,2)

!
! Arguments (input)
!
   INTEGER, INTENT(IN   ) :: iday	 ! day number  (passed in)
   INTEGER, INTENT(IN   ) :: imonth	 ! month number (passed in)
   INTEGER, INTENT(IN   ) :: iyear
   INTEGER, INTENT(IN   ) :: iyear0
   INTEGER, INTENT(IN   ) :: isimveg 
   INTEGER, INTENT(IN   ) :: spinmax 
   REAL(KIND=r8), INTENT(IN	) :: ux  (npoi)
   REAL(KIND=r8), INTENT(IN	) :: uy  (npoi)
   REAL(KIND=r8), INTENT(OUT  ) :: taux(npoi)
   REAL(KIND=r8), INTENT(OUT  ) :: tauy(npoi)
   REAL(KIND=r8), INTENT(INOUT) :: ts2 (npoi)
   REAL(KIND=r8), INTENT(INOUT) :: qs2 (npoi)
   REAL(KIND=r8), INTENT(INOUT) :: gdd0this(npoi)	 
   REAL(KIND=r8), INTENT(INOUT) :: gdd5this(npoi) 
   REAL(KIND=r8), INTENT(OUT  ) :: bstar(npoi)
   REAL(KIND=r8), INTENT(IN   ) :: vegtype0 (npoi)      ! annual vegetation type - ibis classification
   INTEGER(Kind=i8), INTENT(IN   ) ::iMask(nCols)
   CHARACTER(len=*) , INTENT(IN   ) ::  rootmode
   REAL(KIND=r8) :: tthreshold (npoi)! temperature threshold for budburst and senescence
   REAL(KIND=r8) :: gthreshold (npoi)! temperature threshold for budburst and senescence
   REAL(KIND=r8) :: avglaiu    (npoi)  ! average lai of upper canopy 
   REAL(KIND=r8) :: avglail    (npoi)! average lai of lower canopy 

!
   INTEGER :: ib  ,i,nLndPts
   INTEGER :: nsol		  ! number of points in indsol
   INTEGER :: spin

!
! Compute current time step zenith angle
!
!      call ibiszen (calday  ,loni    ,lati    ,coszen, kpti ,kptj)
    tthreshold= undef
    gthreshold= undef
    avglaiu   = undef
    avglail   = undef

      IF (mcsec == 0.0_r8 .or. nstep ==1) THEN
! 
! Calculates phenology once a day (beginning of the day)
!
       
            CALL pheno(tc      , &! INTENT(IN        )
                       agddu   , &! INTENT(INOUT) global
                       tempu   , &! INTENT(INOUT) global
                       agddl   , &! INTENT(INOUT) global
                       templ   , &! INTENT(INOUT) global
                       dropu   , &! INTENT(INOUT) global
                       dropls  , &! INTENT(INOUT) global
                       dropl4  , &! INTENT(INOUT) global
                       dropl3  , &! INTENT(INOUT) global
                       vegtype0, &! INTENT(INOUT) global
                       froot   , &! INTENT(INOUT) global
                       hsoi    , &
                       beta1   , &
                       beta2   , &
                       plai    , &! INTENT(IN   )
                       adplai  , &! INTENT(IN   )
                       frac    , &! INTENT(OUT  )
                       lai     , &! INTENT(OUT  )
                       fl      , &! INTENT(IN   )
                       fu      , &! INTENT(IN   )
                       zbot    , &! INTENT(OUT  )
                       ztop    , &! INTENT(OUT  )
                       a10td   , &! INTENT(IN   )
                       a10ancub, &! INTENT(IN   )
                       a10ancls, &! INTENT(IN   )
                       a10ancl4, &! INTENT(IN   )
                       a10ancl3, &! INTENT(IN   )
                       td      , &! INTENT(IN   )
                       tthreshold, &! INTENT(OUT  )
                       gthreshold, &! INTENT(OUT  )
                       avglaiu   , &! INTENT(OUT  )
                       avglail   , &! INTENT(OUT  )
                       adnpp     , &! INTENT(IN   )
                       adtsoi    , &! INTENT(IN   )
                       adwsoi    , &! INTENT(IN   )
                       adwisoi   , &! INTENT(IN   )
                       poros   , &! INTENT(IN   )
                       rhow    , &! INTENT(IN   )
                       npoi    , &! INTENT(IN   )
                       npft    , &! INTENT(IN   )
                       nsoilay , &! INTENT(IN   )
                       nVegClass, &! INTENT(IN   )
                       rootmode, &! INTENT(IN   )
                       epsilon   )! INTENT(IN   )

!
        IF (isimveg .eq. 1 .or. isimveg == 2) THEN
!
! call soil biogeochemistry model
!

!
! Soil carbon acceleration model deleted in favor of spinmax
! specification at each restart (AAM - 3/14/02)
!

!          if (soicspin .eq. 1) then
!
!             if ((iyear - iyear0) .le.
!    >          (spinfrac * (nspinsoil - iyear0 - eqyears))) then
!                spinmax = int(spincons)
!
!             else if ((iyear - iyear0) .lt.
!    >              (nspinsoil - iyear0 -  eqyears)) then
!
!                slope   = spincons / ((nspinsoil - iyear0 - eqyears) -
!    >                    (spinfrac * (nspinsoil - iyear0 - eqyears)))
!
!                spinmax = int (spincons - (slope * ((iyear - iyear0) -
!    >                (spinfrac * (nspinsoil - iyear0 - eqyears)))))
!
!                spinmax = max(spinmax,1)
!
!             else
!
!                spinmax = 1
!
!             endif            ! if (iyear - iyear0) ....
!
!          else 
!
!             spinmax = 1
!
!          endif               ! if (soicspin = 1)

           DO  spin = 1, spinmax
              CALL soilbgc (iyear    , &! INTENT(IN   )
	                    iyear0   , &! INTENT(IN   )
			    imonth   , &! INTENT(IN   )
			    iday     , &! INTENT(IN   )
                            spin     , &! INTENT(IN   )
			    spinmax  , &! INTENT(IN   )
			    ayprcp   , &! INTENT(IN   )
			    adfalll  , &! INTENT(IN   )
                            adfallr  , &! INTENT(IN   )
			    adfallw  , &! INTENT(IN   )
			    falll    , &! INTENT(IN   )
                            fallr    , &! INTENT(IN   )
			    fallw    , &! INTENT(IN   )
			    clitlm   , &! INTENT(INOUT)
			    clitls   , &! INTENT(INOUT)
		            clitrm   , &! INTENT(INOUT)
     		            clitrs   , &! INTENT(INOUT)
			    clitwm   , &! INTENT(INOUT)
			    clitws   , &! INTENT(INOUT)
			    csoislop , &! INTENT(INOUT)
			    csoislon , &! INTENT(INOUT)
     		            csoipas  , &! INTENT(INOUT)
			    totcmic  , &! INTENT(INOUT)
			    clitll   , &! INTENT(INOUT)
			    clitrl   , &! INTENT(INOUT)
			    clitwl   , &! INTENT(INOUT)
     		            decomps  , &! INTENT(IN   )
			    decompl  , &! INTENT(IN   )
			    tnmin    , &! INTENT(OUT  )
			    totnmic  , &! INTENT(OUT  )
			    totlit   , &! INTENT(OUT  )
     		            totalit  , &! INTENT(OUT  )
			    totrlit  , &! INTENT(OUT  )
			    totcsoi  , &! INTENT(OUT  )
			    totfall  , &! INTENT(OUT  )
			    totnlit  , &! INTENT(OUT  )
     		            totanlit , &! INTENT(OUT  )
			    totrnlit , &! INTENT(OUT  )
			    totnsoi  , &! INTENT(OUT  )
			    tco2mic  , &! INTENT(OUT  )
			    storedn  , &! INTENT(INOUT)
     		            yrleach  , &! INTENT(INOUT)
			    ynleach  , &! INTENT(INOUT)
                            ynleach_p,&! 
                            tnmin_p  ,&! 
                            totnmic_p ,&! 
                            totnlit_p , &
                            totanlit_p,&! 
                            totrnlit_p,&! 
                            totnsoi_p,&! 
                            storedn_p,&! 
			    hsoi     , &! INTENT(IN   )
			    sand     , &! INTENT(IN   )
			    clay     , &! INTENT(IN   )
     		            npoi     , &! INTENT(IN   )
			    nsoilay  , &! INTENT(IN   )
			    ndaypy     )! INTENT(IN   )

           END DO
!

        END IF                  ! if (isimveg = 1)
!
      END IF                    ! if (msec < dtime)


    Grd(204)%Units='  K'
    Grd(204)%Name=' gdd threshold temperature for leaf budburst with a growing degree threshold of 100 units ' 
    Grd(204)%NameG='gthreshold'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(204)%Buffer(i,1,jb) = Grd(204)%Buffer(i,1,jb) + maxstp*(gthreshold  (nLndPts)) 
       ELSE
          Grd(204)%Buffer(i,1,jb) = undef
       END IF
    END DO


    Grd(205)%Units=' K'
    Grd(205)%Name=' temperature threshold is assumed to be 0 degrees C or 5 degrees warmer than the coldest monthly temperature ' 
    Grd(205)%NameG='tthreshold'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(205)%Buffer(i,1,jb) = Grd(205)%Buffer(i,1,jb) + maxstp*(tthreshold  (nLndPts)) 
       ELSE
          Grd(205)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8), INTENT(INOUT) :: clitlm  (npoi)     ! global! carbon in leaf litter pool - metabolic       (kg_C m-2)
    Grd(213)%Units='  (kg_C m-2)'
    Grd(213)%Name=' carbon in leaf litter pool - metabolic   ' 
    Grd(213)%NameG='clitlm'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(213)%Buffer(i,1,jb) = Grd(213)%Buffer(i,1,jb) + maxstp*(clitlm  (nLndPts)) 
       ELSE
          Grd(213)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8), INTENT(INOUT) :: clitls  (npoi)     ! global! carbon in leaf litter pool - structural      (kg_C m-2)
    Grd(214)%Units='  (kg_C m-2)'
    Grd(214)%Name=' carbon in leaf litter pool - structural   ' 
    Grd(214)%NameG='clitls'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(214)%Buffer(i,1,jb) = Grd(214)%Buffer(i,1,jb) + maxstp*(clitls  (nLndPts)) 
       ELSE
          Grd(214)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8), INTENT(INOUT) :: clitrm  (npoi)     ! global! carbon in fine root litter pool - metabolic  (kg_C m-2)
    Grd(215)%Units='  (kg_C m-2)'
    Grd(215)%Name=' carbon in fine root litter pool - metabolic  ' 
    Grd(215)%NameG='clitrm'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(215)%Buffer(i,1,jb) = Grd(215)%Buffer(i,1,jb) + maxstp*(clitrm  (nLndPts)) 
       ELSE
          Grd(215)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8), INTENT(INOUT) :: clitrs  (npoi)     ! global! carbon in fine root litter pool - structural (kg_C m-2)
    Grd(216)%Units='  (kg_C m-2)'
    Grd(216)%Name=' carbon in fine root litter pool - structural ' 
    Grd(216)%NameG='clitrs'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(216)%Buffer(i,1,jb) = Grd(216)%Buffer(i,1,jb) + maxstp*(clitrs  (nLndPts)) 
       ELSE
          Grd(216)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8), INTENT(INOUT) :: clitwm  (npoi)     ! global! carbon in woody litter pool - metabolic      (kg_C m-2)
    Grd(217)%Units='  (kg_C m-2)'
    Grd(217)%Name=' carbon in woody litter pool - metabolic ' 
    Grd(217)%NameG='clitwm'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(217)%Buffer(i,1,jb) = Grd(217)%Buffer(i,1,jb) + maxstp*(clitwm  (nLndPts)) 
       ELSE
          Grd(217)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8), INTENT(INOUT) :: clitws  (npoi)     ! global! carbon in woody litter pool - structural     (kg_C m-2)
    Grd(218)%Units='  (kg_C m-2)'
    Grd(218)%Name=' carbon in woody litter pool - structural ' 
    Grd(218)%NameG='clitws'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(218)%Buffer(i,1,jb) = Grd(218)%Buffer(i,1,jb) + maxstp*(clitws  (nLndPts)) 
       ELSE
          Grd(218)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8), INTENT(INOUT) :: csoislop(npoi)     ! global! carbon in soil - slow protected humus   (kg_C m-2)
    Grd(219)%Units='  (kg_C m-2)'
    Grd(219)%Name=' carbon in soil - slow protected humus   ' 
    Grd(219)%NameG='csoislop'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(219)%Buffer(i,1,jb) = Grd(219)%Buffer(i,1,jb) + maxstp*(csoislop  (nLndPts)) 
       ELSE
          Grd(219)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8), INTENT(INOUT) :: csoislon(npoi)     ! global! carbon in soil - slow nonprotected humus     (kg_C m-2)
    Grd(220)%Units='  (kg_C m-2)'
    Grd(220)%Name=' carbon in soil - slow nonprotected humus    ' 
    Grd(220)%NameG='csoislon'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(220)%Buffer(i,1,jb) = Grd(220)%Buffer(i,1,jb) + maxstp*(csoislon  (nLndPts)) 
       ELSE
          Grd(220)%Buffer(i,1,jb) = undef
       END IF
    END DO


!   REAL(KIND=r8), INTENT(INOUT) :: csoipas (npoi)     ! global! carbon in soil - passive humus   (kg_C m-2)
    Grd(221)%Units='  (kg_C m-2)'
    Grd(221)%Name=' carbon in soil - passive humus    ' 
    Grd(221)%NameG='csoipas'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(221)%Buffer(i,1,jb) = Grd(221)%Buffer(i,1,jb) + maxstp*(csoipas  (nLndPts)) 
       ELSE
          Grd(221)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8), INTENT(INOUT) :: clitll  (npoi)     ! global! carbon in leaf litter pool - lignin   (kg_C m-2)
    Grd(222)%Units='  (kg_C m-2)'
    Grd(222)%Name=' carbon in leaf litter pool - lignin    ' 
    Grd(222)%NameG='clitll'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(222)%Buffer(i,1,jb) = Grd(222)%Buffer(i,1,jb) + maxstp*(clitll  (nLndPts)) 
       ELSE
          Grd(222)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8), INTENT(INOUT) :: clitrl  (npoi)     ! global! carbon in fine root litter pool - lignin     (kg_C m-2)
    Grd(223)%Units='  (kg_C m-2)'
    Grd(223)%Name='  carbon in fine root litter pool - lignin    ' 
    Grd(223)%NameG='clitrl'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(223)%Buffer(i,1,jb) = Grd(223)%Buffer(i,1,jb) + maxstp*(clitrl  (nLndPts)) 
       ELSE
          Grd(223)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8), INTENT(INOUT) :: clitwl  (npoi)     ! global! carbon in woody litter pool - lignin	   (kg_C m-2)
    Grd(224)%Units='  (kg_C m-2)'
    Grd(224)%Name='  carbon in woody litter pool - lignin    ' 
    Grd(224)%NameG='clitwl'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(224)%Buffer(i,1,jb) = Grd(224)%Buffer(i,1,jb) + maxstp*(clitwl  (nLndPts)) 
       ELSE
          Grd(224)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8), INTENT(INOUT) :: totalit   (npoi)   ! global! total standing aboveground litter (kg_C m-2)
    Grd(225)%Units='  (kg_C m-2)'
    Grd(225)%Name=' total standing aboveground litter    ' 
    Grd(225)%NameG='totalit'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(225)%Buffer(i,1,jb) = Grd(225)%Buffer(i,1,jb) + maxstp*(totalit  (nLndPts)) 
       ELSE
          Grd(225)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8), INTENT(INOUT) :: totrlit   (npoi)   ! global! total root litter carbon belowground (kg_C m-2)
    Grd(226)%Units='  (kg_C m-2)'
    Grd(226)%Name=' total root litter carbon belowground     ' 
    Grd(226)%NameG='totrlit'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(226)%Buffer(i,1,jb) = Grd(226)%Buffer(i,1,jb) + maxstp*(totrlit  (nLndPts)) 
       ELSE
          Grd(226)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8), INTENT(INOUT) :: totcsoi   (npoi)   ! global! total carbon in all soil pools (kg_C m-2)
    Grd(227)%Units='  (kg_C m-2)'
    Grd(227)%Name=' total carbon in all soil pools ' 
    Grd(227)%NameG='totcsoi'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(227)%Buffer(i,1,jb) = Grd(227)%Buffer(i,1,jb) + maxstp*(totcsoi  (nLndPts)) 
       ELSE
          Grd(227)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8), INTENT(INOUT) :: totcmic   (npoi)   ! global! total carbon residing in microbial pools (kg_C m-2)
    Grd(228)%Units='  (kg_C m-2)'
    Grd(228)%Name='total carbon residing in microbial pools  ' 
    Grd(228)%NameG='totcmic'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(228)%Buffer(i,1,jb) = Grd(228)%Buffer(i,1,jb) + maxstp*(totcmic  (nLndPts)) 
       ELSE
          Grd(228)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8), INTENT(INOUT) :: totanlit  (npoi)   ! global! total standing aboveground nitrogen in litter (kg_N m-2)
    Grd(229)%Units='  (kg_N m-2)'
    Grd(229)%Name='total standing aboveground nitrogen in litter ' 
    Grd(229)%NameG='totanlit'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(229)%Buffer(i,1,jb) = Grd(229)%Buffer(i,1,jb) + maxstp*(totanlit  (nLndPts)) 
       ELSE
          Grd(229)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8), INTENT(INOUT) :: totrnlit  (npoi)   ! global! total root litter nitrogen belowground (kg_N m-2)
    Grd(230)%Units='  (kg_N m-2)'
    Grd(230)%Name='total root litter nitrogen belowground ' 
    Grd(230)%NameG='totrnlit'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(230)%Buffer(i,1,jb) = Grd(230)%Buffer(i,1,jb) + maxstp*(totrnlit  (nLndPts)) 
       ELSE
          Grd(230)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8), INTENT(INOUT) :: totnsoi   (npoi)   ! global! total nitrogen in soil (kg_N m-2)
    Grd(231)%Units='  (kg_N m-2)'
    Grd(231)%Name='total nitrogen in soil' 
    Grd(231)%NameG='totnsoi'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(231)%Buffer(i,1,jb) = Grd(231)%Buffer(i,1,jb) + maxstp*(totnsoi  (nLndPts)) 
       ELSE
          Grd(231)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8), INTENT(OUT  ) :: totnmic   (npoi)   ! local! total nitrogen residing in microbial pool (kg_N m-2)
    Grd(232)%Units='  (kg_N m-2)'
    Grd(232)%Name='total nitrogen residing in microbial pool' 
    Grd(232)%NameG='totnmic'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(232)%Buffer(i,1,jb) = Grd(232)%Buffer(i,1,jb) + maxstp*(totnmic  (nLndPts)) 
       ELSE
          Grd(232)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8), INTENT(OUT  ) :: totlit    (npoi)   ! local! total carbon in all litter pools (kg_C m-2)
    Grd(233)%Units='  (kg_C m-2)'
    Grd(233)%Name='total carbon in all litter pools ' 
    Grd(233)%NameG='totlit'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(233)%Buffer(i,1,jb) = Grd(233)%Buffer(i,1,jb) + maxstp*(totlit  (nLndPts)) 
       ELSE
          Grd(233)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8), INTENT(OUT  ) :: totnlit   (npoi)   ! local! total nitrogen in all litter pools (kg_N m-2)
    Grd(234)%Units='  (kg_N m-2)'
    Grd(234)%Name='total nitrogen in all litter pools  ' 
    Grd(234)%NameG='totnlit'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(234)%Buffer(i,1,jb) = Grd(234)%Buffer(i,1,jb) + maxstp*(totnlit  (nLndPts)) 
       ELSE
          Grd(234)%Buffer(i,1,jb) = undef
       END IF
    END DO

!   REAL(KIND=r8), INTENT(OUT  ) :: totfall   (npoi)   ! local! total litterfall and root turnover (kg_C m-2/year)
    Grd(235)%Units='  (kg_C m-2/year)'
    Grd(235)%Name='total litterfall and root turnover  ' 
    Grd(235)%NameG='totfall'
    nLndPts=0
    DO i=1, nCols
       IF(iMask(i) >= 1)THEN 
          nLndPts=nLndPts+1
          Grd(235)%Buffer(i,1,jb) = Grd(235)%Buffer(i,1,jb) + maxstp*(totfall  (nLndPts)) 
       ELSE
          Grd(235)%Buffer(i,1,jb) = undef
       END IF
    END DO

!call the land surface model

    CALL lsxmain(ginvap       ,gsuvap       , & 
		 gtrans       ,gtransu      , & 
		 gtransl      ,grunof       , & 
		 gdrain       ,gadjust      , & 
		 a10scalparamu,a10daylightu , & 
		 a10scalparaml,a10daylightl , & 
		 vmax_pft     ,tau15        , & 
		 kc15	      ,ko15	    , & 
		 cimax        ,gammaub      , & 
		 alpha3       ,theta3       , & 
		 beta3        ,coefmub      , & 
		 coefbub      ,gsubmin      , & 
		 gammauc      ,coefmuc      , & 
		 coefbuc      ,gsucmin      , & 
		 gammals      ,coefmls      , & 
		 coefbls      ,gslsmin      , & 
		 gammal3      ,coefml3      , & 
		 coefbl3      ,gsl3min      , & 
		 gammal4      ,alpha4       , & 
		 theta4       ,beta4        , & 
		 coefml4      ,coefbl4      , & 
		 gsl4min      ,wliqu        , & 
		 wliqumax     ,wsnou        , & 
		 wsnoumax     ,tu           , & 
		 wliqs        ,wliqsmax     , & 
		 wsnos        ,wsnosmax     , & 
		 ts	      ,wliql        , & 
		 wliqlmax     ,wsnol        , & 
		 wsnolmax     ,tl           , & 
		 topparu      ,topparl      , & 
		 fl	      ,fu           , & 
		 lai	      ,sai          , & 
		 rhoveg       ,tauveg       , & 
		 orieh        ,oriev        , & 
		 wliqmin      ,wsnomin      , & 
		 t12	      ,tdripu       , & 
		 tblowu       ,tdrips       , & 
		 tblows       ,t34	    , & 
		 tdripl       ,tblowl       , & 
		 ztop	      ,alaiml       , & 
		 zbot	      ,alaimu       , & 
		 froot        ,q34	    , & 
		 q12	      ,su	    , & 
		 cleaf        ,dleaf        , & 
		 ss	      ,cstem        , & 
		 dstem        ,sl	    , & 
		 cgrass       ,ciub	    , & 
		 ciuc	      ,exist        , & 
		 csub	      ,gsub	    , & 
		 csuc	      ,gsuc	    , & 
		 agcub        ,agcuc        , & 
		 ancub        ,ancuc        , & 
		 totcondub    ,totconduc    , & 
		 cils	      ,cil3	      , & 
		 cil4	      ,csls	      , & 
		 gsls	      ,csl3	      , & 
		 gsl3	      ,csl4	      , & 
		 gsl4	      ,agcls        , & 
		 agcl4        ,agcl3        , & 
		 ancls        ,ancl4        , & 
		 ancl3        ,totcondls    , & 
		 totcondl3    ,totcondl4    , & 
		 chu	      ,chs	      , & 
		 chl	      ,frac	      , & 
		 tlsub        , & 
		 z0sno        , & 
		 rhos	      , & 
		 consno       , & 
		 hsnotop      , & 
		 hsnomin      , & 
		 fimin        , & 
		 fimax        , & 
		 fi	      , & 
		 tsno	      , & 
		 hsno	      , & 
		 sand	      , & 
		 clay	      , & 
		 poros        , & 
		 wsoi	      , & 
		 wisoi        , & 
		 consoi       , & 
		 zwpmax       , & 
		 wpud	      , & 
		 wipud        , & 
		 wpudmax      , & 
		 qglif        , & 
		 tsoi	      , & 
		 hvasug       , & 
		 hvasui       , & 
		 albsav       , & 
		 albsan       , & 
		 tg	      , & 
		 ti	      , & 
		 z0soi        , & 
		 swilt        , & 
		 sfield       , & 
		 stressl      , & 
		 stressu      , & 
		 stresstl     , & 
		 stresstu     , & 
		 csoi	      , & 
		 rhosoi       , & 
		 hsoi	      , & 
		 suction      , & 
		 bex	      , & 
		 upsoiu       , & 
		 upsoil       , & 
		 heatg        , & 
		 heati        , & 
		 hydraul      , & 
		 porosflo     , & 
		 ibex	      , & 
		 bperm        , & 
		 hflo	      , & 
		 ta	      , & 
		 asurd        , & 
		 asuri        , & 
		 coszen       , & 
		 solad        , & 
		 solai        , & 
		 fira	      , & 
		 raina        , & 
		 qa	      , & 
		 psurf        , & 
		 snowa        , & 
		 ua	      , & 
		 o2conc       , & 
		 co2conc      , & 
		 fwetu        , & 
		 rliqu        , & 
		 fwets        , & 
		 rliqs        , & 
		 fwetl        , & 
		 rliql        , & 
		 !nsol	      , & 
		 solu	      , & 
		 sols	      , & 
		 soll	      , & 
		 solg	      , & 
		 soli	      , & 
		 scalcoefl    , & 
		 scalcoefu    , & 
		 indsol       , & 
		 albsod       , & 
		 albsoi       , & 
		 albsnd       , & 
		 albsni       , & 
		 relod        , & 
		 reloi        , & 
		 reupd        , & 
		 reupi        , & 
		 ablod        , & 
		 abloi        , & 
		 flodd        , & 
		 dummy        , & 
		 flodi        , & 
		 floii        , & 
		 terml        , & 
		 termu        , & 
		 abupd        , & 
		 abupi        , & 
		 fupdd        , & 
		 fupdi        , & 
		 fupii        , & 
		 sol2d        , & 
		 sol2i        , & 
		 sol3d        , & 
		 sol3i        , & 
		 firb	      , & 
		 firs	      , & 
		 firu	      , & 
		 firl	      , & 
		 firg	      , & 
		 firi	      , & 
		 snowg        , & 
		 tsnowg       , & 
		 tsnowl       , & 
		 pfluxl       , & 
		 raing        , & 
		 traing       , & 
		 trainl       , & 
		 snowl        , & 
		 tsnowu       , & 
		 pfluxu       , & 
		 rainu        , & 
		 trainu       , & 
		 snowu        , & 
		 pfluxs       , & 
		 rainl        , &
		 bps          , & 
		 rhoa	      , & 
		 cp	      , & 
		 za	      , & 
		 bdl	      , & 
		 dil	      , & 
		 z3	      , & 
		 z4	      , & 
		 z34	      , & 
		 exphl        , & 
		 expl	      , & 
		 displ        , & 
		 bdu	      , & 
		 diu	      , & 
		 z1	      , & 
		 z2	      , & 
		 z12	      , & 
		 exphu        , & 
		 expu	      , & 
		 dispu        , & 
		 alogg        , & 
		 alogi        , & 
		 alogav       , & 
		 alog4        , & 
		 alog3        , & 
		 alog2        , & 
		 alog1        , & 
		 aloga        , & 
		 u2	      , & 
		 alogu        , & 
		 alogl        , & 
		 richl        , & 
		 straml       , & 
		 strahl       , & 
		 richu        , & 
		 stramu       , & 
		 strahu       , & 
		 u1	      , & 
		 u12	      , & 
		 u3	      , & 
		 u34	      , & 
		 u4	      , & 
		 cu	      , & 
		 cl	      , & 
		 sg	      , & 
		 si	      , & 
		 fwetux       , & 
		 fwetsx       , & 
		 fwetlx       , & 
		 fsena        , & 
		 fseng        , & 
		 fseni        , & 
		 fsenu        , & 
		 fsens        , & 
		 fsenl        , & 
		 fvapa        , & 
		 fvaput       , & 
		 fvaps        , & 
		 fvaplw       , & 
		 fvaplt       , & 
		 fvapg        , & 
		 fvapi        , & 
		 fvapuw       , & 
		 npoi	      , & 
		 nband        , & 
		 nsoilay      , & 
		 nsnolay      , & 
		 npft	      , & 
		 epsilon      , & 
		 dtime        , & 
		 stef	      , & 
		 vonk	      , & 
		 grav	      , & 
		 tmelt        , & 
		 hfus	      , & 
		 hvap	      , & 
		 hsub	      , & 
		 ch2o	      , & 
		 cice	      , & 
		 cair	      , & 
		 cvap	      , & 
		 rair	      , & 
		 rvap	      , & 
		 cappa        , & 
		 rhow	      , & 
		 vzero        , & 
		 pi	      , &
		 ux	      , &! INTENT(IN	) !global
		 uy	      , &! INTENT(IN	) !global
		 taux	      , &! INTENT(OUT	) !local
		 tauy	      , &! INTENT(OUT	) !local
		 bstar        , &! INTENT(OUT	) !local
		 ts2	      , &! INTENT(OUT	) !local
		 qs2          , &! INTENT(OUT	) !local
		 vegtype0     , &! INTENT(IN	) !local
		 stressfac    , &
		 avmuir_factor, &
                 iMask        , &
		 nCols        , &
		 jb           , &
                 nVegClass     )

!
! accumulate some variables every timestep
!
              CALL  sumnow(a10td   , &! INTENT(INOUT) !global
	                   a10ancub, &! INTENT(INOUT) !global
			   a10ancuc, &! INTENT(INOUT) !global
			   a10ancls, &! INTENT(INOUT) !global
     		           a10ancl3, &! INTENT(INOUT) !global
			   a10ancl4, &! INTENT(INOUT) !global
			   nppdummy, &! INTENT(OUT  ) !local
			   frac    , &! INTENT(IN   ) !global
     		           ancub   , &! INTENT(IN   ) !global
			   lai	   , &! INTENT(IN   ) !global
			   fu	   , &! INTENT(IN   ) !global
			   ancuc   , &! INTENT(IN   ) !global
     		           ancls   , &! INTENT(IN   ) !global
			   fl	   , &! INTENT(IN   ) !global
			   ancl4   , &! INTENT(IN   ) !global
			   ancl3   , &! INTENT(IN   ) !global
     		           tgpp    , &! INTENT(OUT  ) !local
			   agcub   , &! INTENT(IN   ) !global
			   agcuc   , &! INTENT(IN   ) !global
			   agcls   , &! INTENT(IN   ) !global
     		           agcl4   , &! INTENT(IN   ) !global
			   agcl3   , &! INTENT(IN   ) !global
			   tgpptot , &! INTENT(OUT  ) !local
			   ts      , &! INTENT(IN   ) !global
     		           froot   , &! INTENT(IN   ) !global
			   tnpp	   , &! INTENT(OUT  ) !local
			   cbiow   , &! INTENT(IN   ) !global
			   sapfrac , &! INTENT(IN   ) !global
     		           cbior   , &! INTENT(IN   ) !global
			   tnpptot , &! INTENT(OUT  ) !local
			   tco2root, &! INTENT(OUT  ) !local
			   tneetot , &! INTENT(OUT  ) !local
     		           tco2mic , &! INTENT(IN   ) !global
			   tsoi	   , &! INTENT(IN   ) !global
			   fi	   , &! INTENT(IN   ) !global
			   td	   , &! INTENT(IN   ) !global
     		           npoi    , &! INTENT(IN   ) !global
			   nsoilay , &! INTENT(IN   ) !global
			   npft	   , &! INTENT(IN   ) !global
			   ndaypy  , &! INTENT(IN   ) !global
     		           dtime     )! INTENT(IN   ) !global

	      CALL sumday(adnpp     , &
			  tnpp      , &! INTENT(IN  ) !local
	                  raina     , &! INTENT(IN   )
			  snowa     , &! INTENT(IN   )
			  fvapa     , &! INTENT(IN   )
			  grunof    , &! INTENT(IN   )
			  gdrain    , &! INTENT(IN   )
			  hsno      , &! INTENT(IN   )
     			  fi        , &! INTENT(IN   )
			  hsoi      , &! INTENT(IN   )
			  tsoi      , &! INTENT(IN   )
			  wsoi      , &! INTENT(IN   )
			  wisoi     , &! INTENT(IN   )
     			  ndtimes   , &! INTENT(INOUT) global
			  adrain    , &! INTENT(INOUT) global
			  adsnow    , &! INTENT(INOUT) global
			  adaet     , &! INTENT(INOUT) global
     		          adtrunoff , &! INTENT(INOUT) global
			  adsrunoff , &! INTENT(INOUT) global
			  addrainage, &! INTENT(INOUT) global
     			  adrh      , &! INTENT(INOUT) global
			  adsnod    , &! INTENT(INOUT) global
			  adsnof    , &! INTENT(INOUT) global
			  adwsoi    , &! INTENT(INOUT) global
     			  adtsoi    , &! INTENT(INOUT) global
			  adwisoi   , &! INTENT(INOUT) global
			  adtlaysoi , &! INTENT(INOUT) global
			  adwlaysoi , &! INTENT(INOUT) global
     			  adwsoic   , &! INTENT(INOUT) global
			  adtsoic   , &! INTENT(INOUT) global
			  adco2mic  , &! INTENT(INOUT) global
			  adco2root , &! INTENT(INOUT) global
     			  adco2soi  , &! INTENT(INOUT) global
			  adco2ratio, &! INTENT(INOUT) global
			  adnmintot , &! INTENT(INOUT) global
     			  froot     , &! INTENT(IN   )
			  tco2mic   , &! INTENT(IN   )
			  tco2root  , &! INTENT(IN   )
			  decompl   , &! INTENT(INOUT) global
     			  decomps   , &! INTENT(INOUT) global
			  tnmin     , &! INTENT(IN   )
			  npoi      , &! INTENT(IN   )
			  npft      , &! INTENT(IN   ) !global
			  nsoilay   , &! INTENT(IN   )
     			  nsnolay   , &! INTENT(IN   )
			  dtime     , &! INTENT(IN   )
			  td	    , &! INTENT(IN   )
			  gdd0this  , &! INTENT(INOUT) global
			  gdd5this  , &! INTENT(INOUT) global
			  ts2       , &! INTENT(INOUT) global
			  mcsec	     ) ! INTENT(INOUT) global
			  
	   CALL summonth (dtime     , &! INTENT(IN   )!global
	                  mcsec     , &! INTENT(IN   )!global
	                  iday      , &! INTENT(IN   )!global
			  imonth    , &! INTENT(IN   )!global
			  nmtimes   , &! INTENT(INOUT)!global
			  amrain    , &! INTENT(INOUT)!global
   		          amsnow    , &! INTENT(INOUT)!global
			  amaet     , &! INTENT(INOUT)!global
			  amtrunoff , &! INTENT(INOUT)!global
			  amsrunoff , &! INTENT(INOUT)!global
   			  amdrainage, &! INTENT(INOUT)!global
			  amtemp    , &! INTENT(INOUT)!global
			  amqa	    , &! INTENT(INOUT)!global
			  amsolar   , &! INTENT(INOUT)!global
			  amirup    , &! INTENT(INOUT)!global
			  amirdown  , &! INTENT(INOUT)!global
   			  amsens    , &! INTENT(INOUT)!global
			  amlatent  , &! INTENT(INOUT)!global
			  amlaiu    , &! INTENT(INOUT)!global
			  amlail    , &! INTENT(INOUT)!global
   			  amtsoi    , &! INTENT(INOUT)!global
			  amwsoi    , &! INTENT(INOUT)!global
			  amwisoi   , &! INTENT(INOUT)!global
			  amvwc     , &! INTENT(INOUT)!global
   			  amawc     , &! INTENT(INOUT)!global
			  amsnod    , &! INTENT(INOUT)!global
			  amsnof    , &! INTENT(INOUT)!global
			  amnpp	    , &! INTENT(INOUT)!global
   			  amnpptot  , &! INTENT(OUT  )!local
			  amco2mic  , &! INTENT(INOUT)!global
			  amco2root , &! INTENT(INOUT)!global
			  amco2soi  , &! INTENT(OUT  )!local
   			  amco2ratio, &! INTENT(OUT  )!local
			  amneetot  , &! INTENT(OUT  )!local
			  amnmintot , &! INTENT(INOUT)!global
			  amts2     , &! INTENT(INOUT)!global
			  amtransu  , &! INTENT(INOUT)!global
			  amtransl  , &! INTENT(INOUT)!global
			  amsuvap   , &! INTENT(INOUT)!global
			  aminvap   , &! INTENT(INOUT)!global
			  amalbedo  , &! INTENT(INOUT)!global
			  amtsoil   , &! INTENT(INOUT)!global
			  amwsoil   , &! INTENT(INOUT)!global
			  amwisoil  , &! INTENT(INOUT)!global
  			  ts2       , &! INTENT(INOUT)!global
			  fu        , &! INTENT(IN   )!global
   			  lai       , &! INTENT(IN   )!global
			  fl	    , &! INTENT(IN   )!global
			  tnpp      , &! INTENT(IN   )!global
			  tco2mic   , &! INTENT(IN   )!global
   			  tco2root  , &! INTENT(IN   )!global
			  tnmin     , &! INTENT(IN   )!global
			  hsoi      , &! INTENT(IN   )!global
			  tsoi      , &! INTENT(IN   )!global
   			  wsoi      , &! INTENT(IN   )!global
			  wisoi	    , &! INTENT(IN   )!global
			  poros     , &! INTENT(IN   )!global
			  swilt	    , &! INTENT(IN   )!global
     		          hsno      , &! INTENT(IN   )!global
			  fi        , &! INTENT(IN   )!global
			  grunof    , &! INTENT(IN   )!global
			  gdrain    , &! INTENT(IN   )!global
			  gtransu   , &! INTENT(IN   )!global
			  gtransl   , &! INTENT(IN   )!global
			  gsuvap    , &! INTENT(IN   )!global
			  ginvap    , &! INTENT(IN   )!global
			  asurd     , &! INTENT(IN   )!global
			  asuri     , &! INTENT(IN   )!global
     		          fvapa     , &! INTENT(IN   )!global
			  firb	    , &! INTENT(IN   )!global
			  fsena     , &! INTENT(IN   )!global
			  raina     , &! INTENT(IN   )!global
     		          snowa     , &! INTENT(IN   )!global
			  ta        , &! INTENT(IN   )!global
			  qa        , &! INTENT(IN   )!global
			  solad	    , &! INTENT(IN   )!global
			  solai     , &! INTENT(IN   )!global
			  fira      , &! INTENT(IN   )!global
     		          npoi      , &! INTENT(IN   )!global
			  nband	    , &! INTENT(IN   )!global
			  nsoilay   , &! INTENT(IN   )!global
			  nsnolay   , &! INTENT(IN   )!global
     		          npft      , &! INTENT(IN   )!global
			  ndaypm    , &! INTENT(IN   )!global
			  hvap        )! INTENT(IN   )!global
    
	     CALL sumyear(dtime     , &! INTENT(IN   )
	                  mcsec     , &! INTENT(IN   )
	                  iday      , &! INTENT(IN   )
			  imonth    , &! INTENT(IN   )
			  wliqu     , &! INTENT(IN   )
			  wsnou     , &! INTENT(IN   )
   			  fu	    , &! INTENT(IN   )
			  lai	    , &! INTENT(IN   )
			  wliqs     , &! INTENT(IN   )
			  wsnos     , &! INTENT(IN   )
			  sai       , &! INTENT(IN   )
   		          wliql	    , &! INTENT(IN   )
			  wsnol     , &! INTENT(IN   )
			  fl        , &! INTENT(IN   )
			  tgpp      , &! INTENT(IN   )
			  tnpp      , &! INTENT(IN   )
   		          firefac   , &! INTENT(INOUT) global
			  tco2mic   , &! INTENT(IN   )
			  tco2root  , &! INTENT(IN   )
			  cbior     , &! INTENT(IN   )
			  tnmin     , &! INTENT(IN   )
   		          totalit   , &! INTENT(IN   )
			  totrlit   , &! INTENT(IN   )
			  totcsoi   , &! INTENT(IN   )
			  totcmic   , &! INTENT(IN   )
			  totanlit  , &! INTENT(IN   )
   		          totrnlit  , &! INTENT(IN   )
			  totnsoi   , &! INTENT(IN   )
			  nytimes   , &! INTENT(INOUT) global
			  aysolar   , &! INTENT(INOUT) global
			  ayirup    , &! INTENT(INOUT) global
   		          ayirdown  , &! INTENT(INOUT) global
			  aysens    , &! INTENT(INOUT) global
			  aylatent  , &! INTENT(INOUT) global
			  ayprcp    , &! INTENT(INOUT) global
			  ayaet     , &! INTENT(INOUT) global
   		          aytrans   , &! INTENT(INOUT) global
			  aytrunoff , &! INTENT(INOUT) global
			  aysrunoff , &! INTENT(INOUT) global
			  aydrainage, &! INTENT(INOUT) global
   		          aydwtot   , &! INTENT(INOUT) global
			  aywsoi    , &! INTENT(INOUT) global
			  aywisoi   , &! INTENT(INOUT) global
			  aytsoi    , &! INTENT(INOUT) global
			  ayvwc     , &! INTENT(INOUT) global
   		          ayawc     , &! INTENT(INOUT) global
			  aystresstu, &! INTENT(INOUT) global
			  aystresstl, &! INTENT(INOUT) global
			  aygpp     , &! INTENT(INOUT) global
   		          aygpptot  , &! INTENT(OUT  ) local
			  aynpp	    , &! INTENT(INOUT) global
			  aynpptot  , &! INTENT(OUT  ) local
			  ayco2mic  , &! INTENT(INOUT) global
   		          ayco2root , &! INTENT(INOUT) global
			  ayco2soi  , &! INTENT(OUT  ) global
			  ayneetot  , &! INTENT(OUT  ) global
			  ayrootbio , &! INTENT(INOUT) global
   		          aynmintot , &! INTENT(INOUT) global
			  ayalit    , &! INTENT(INOUT) global
			  ayblit    , &! INTENT(INOUT) global
			  aycsoi    , &! INTENT(INOUT) global
   		          aycmic    , &! INTENT(INOUT) global
			  ayanlit   , &! INTENT(INOUT) global
			  aybnlit   , &! INTENT(INOUT) global
			  aynsoi    , &! INTENT(INOUT) global
			  ayalbedo  , &! INTENT(INOUT) global
   		          hsoi	    , &! INTENT(IN   ) global
			  wpud	    , &! INTENT(IN   ) global
			  wipud     , &! INTENT(IN   ) global
			  poros     , &! INTENT(IN   ) global
   		          wsoi	    , &! INTENT(IN   ) global
			  wisoi     , &! INTENT(IN   ) global
			  tsoi	    , &! INTENT(IN   ) global
			  swilt     , &! INTENT(IN   ) global
   		          stresstu  , &! INTENT(IN   ) global
			  stresstl  , &! INTENT(IN   ) global
			  fi	    , &! INTENT(IN   ) global
			  rhos      , &! INTENT(IN   ) global
   		          hsno	    , &! INTENT(IN   ) global
			  gtrans    , &! INTENT(IN   ) global
			  grunof    , &! INTENT(IN   ) global
			  gdrain    , &! INTENT(IN   ) global
   		          wtot	    , &! INTENT(INOUT) global
			  firb	    , &! INTENT(IN   ) global
			  fsena     , &! INTENT(IN   ) global
			  fvapa     , &! INTENT(IN   ) global
   		          solad	    , &! INTENT(IN   ) global
			  solai     , &! INTENT(IN   ) global
			  fira      , &! INTENT(IN   ) global
			  raina     , &! INTENT(IN   ) global
   		          snowa	    , &! INTENT(IN   ) global
                          asurd     , &! INTENT(IN   ) global
		          asuri     , &! INTENT(IN   ) global
			  npoi	    , &! INTENT(IN   ) global
			  nband     , &! INTENT(IN   ) global
			  nsoilay   , &! INTENT(IN   ) global
   		          nsnolay   , &! INTENT(IN   ) global
			  npft      , &! INTENT(IN   ) global
			  ndaypy    , &! INTENT(IN   ) global
			  hvap      , &! INTENT(IN   ) global
   			  rhow        )! INTENT(IN   ) global
      IF (doalb) THEN
!
! Compute next time step zenith angle
!
!         CALL ibiszen (calday1, loni, lati, coszen, kpti ,kptj)
!
! Compute albedos (used in next step radiation computations)
! set up for solar calculations
!
!         CALL solset(loopi, kpti, kptj)
!
! set up for solar calculations
!
         CALL solset(npoi     , &! INTENT(IN   )
                  nsol     , &! INTENT(OUT  )
		  nband    , &! INTENT(IN   )
		  solu     , &! INTENT(OUT  )
                  sols     , &! INTENT(OUT  )
		  soll     , &! INTENT(OUT  )
		  solg     , &! INTENT(OUT  )
		  soli     , &! INTENT(OUT  )
                  scalcoefl, &! INTENT(OUT  )
		  scalcoefu, &! INTENT(OUT  )
		  indsol   , &! INTENT(OUT  )
		  topparu  , &! INTENT(OUT  )
                  topparl  , &! INTENT(OUT  )
		  asurd    , &! INTENT(OUT  )
		  asuri    , &! INTENT(OUT  )
		  coszen     )! INTENT(IN   )  

!
! solar calculations for each waveband
!
      DO  ib = 1, nband
!
! solsur sets surface albedos for soil and snow
! solalb performs the albedo calculations
! solarf uses the unit-incident-flux results from solalb
! to obtain absorbed fluxes sol[u,s,l,g,i] and 
! incident pars sunp[u,l]
!
        CALL solsur (ib       , &! INTENT(IN   )
	             tmelt    , &! INTENT(IN   )
		     nsol     , &! INTENT(IN   )
		     albsod   , &! INTENT(OUt  )
		     albsoi   , &! INTENT(OUt  )
		     albsnd   , &! INTENT(OUt  )
                     albsni   , &! INTENT(OUt  )
		     indsol   , &! INTENT(IN   )
		     wsoi     , &! INTENT(IN   )
		     wisoi    , &! INTENT(IN   )
		     albsav   , &! INTENT(IN   )
		     albsan   , &! INTENT(IN   )
                     tsno     , &! INTENT(IN   )
		     coszen   , &! INTENT(IN   )
		     npoi     , &! INTENT(IN   )
		     nsoilay  , &! INTENT(IN   )
		     nsnolay    )! INTENT(IN   )
		     
        CALL solalb (ib       , &! INTENT(IN   )
                     nVegClass , &! INTENT(IN   )
                     vegtype0     , &! INTENT(IN   )
                     avmuir_factor, &! INTENT(IN   )
	             relod    , &! INTENT(OUT  )
		     reloi    , &! INTENT(OUT  )
		     indsol   , &! INTENT(IN   )
		     reupd    , &! INTENT(OUT  )
     		     reupi    , &! INTENT(OUT  )
     		     albsnd   , &! INTENT(IN   )
		     albsni   , &! INTENT(IN   )
		     albsod   , &! INTENT(IN   )
		     albsoi   , &! INTENT(IN   )
     		     fl       , &! INTENT(IN   )
		     fu       , &! INTENT(IN   )
		     fi       , &! INTENT(IN   )
		     asurd    , &! INTENT(INOUT)! local
		     asuri    , &! INTENT(INOUT)! local
     		     npoi     , &! INTENT(IN   )
		     nband    , &! INTENT(IN   )
		     nsol     , &! INTENT(IN   )
		     ablod    , &! INTENT(OUT  )
		     abloi    , &! INTENT(OUT  )
     		     flodd    , &! INTENT(OUT  )
		     dummy    , &! INTENT(OUT  )
		     flodi    , &! INTENT(OUT  )
		     floii    , &! INTENT(OUT  )
		     coszen   , &! INTENT(IN   )
     		     terml    , &! INTENT(OUT  )
		     termu    , &! INTENT(OUT  )
		     lai      , &! INTENT(IN   )
		     sai      , &! INTENT(IN   )
		     abupd    , &! INTENT(OUT  )
     		     abupi    , &! INTENT(OUT  )
		     fupdd    , &! INTENT(OUT  )
		     fupdi    , &! INTENT(OUT  )
		     fupii    , &! INTENT(OUT  )
		     fwetl    , &! INTENT(IN   )
     		     rliql    , &! INTENT(IN   )
		     rliqu    , &! INTENT(IN   )
		     rliqs    , &! INTENT(IN   )
		     fwetu    , &! INTENT(IN   )
		     fwets    , &! INTENT(IN   )
     		     rhoveg   , &! INTENT(IN   )
		     tauveg   , &! INTENT(IN   )
		     orieh    , &! INTENT(IN   )
		     oriev    , &! INTENT(IN   )
		     tl       , &! INTENT(IN   )
     		     ts       , &! INTENT(IN   )
		     tu       , &! INTENT(IN   )
		     pi       , &! INTENT(IN   )
		     tmelt    , &! INTENT(IN   )
		     epsilon    )! INTENT(IN   )
     
        CALL solarf (ib       , & ! INTENT(IN	) 
	             nsol     , & ! INTENT(IN	) 
		     solu     , & ! INTENT(INOUT) !global
		     indsol   , & ! INTENT(IN	) 
		     abupd    , & ! INTENT(IN	) 
     		     abupi    , & ! INTENT(IN	) 
		     sols     , & ! INTENT(INOUT) !global
		     sol2d    , & ! INTENT(OUT  ) 
		     fupdd    , & ! INTENT(IN	) 
		     sol2i    , & ! INTENT(OUT  ) 
     		     fupii    , & ! INTENT(IN	) 
		     fupdi    , & ! INTENT(IN	) 
		     sol3d    , & ! INTENT(OUT  ) 
		     sol3i    , & ! INTENT(OUT  ) 
		     soll     , & ! INTENT(INOUT) !global
     		     ablod    , & ! INTENT(IN	) 
		     abloi    , & ! INTENT(IN	) 
		     flodd    , & ! INTENT(IN	) 
		     flodi    , & ! INTENT(IN	) 
		     floii    , & ! INTENT(IN	) 
     		     solg     , & ! INTENT(INOUT) !global
		     albsod   , & ! INTENT(IN	) 
		     albsoi   , & ! INTENT(IN	) 
		     soli     , & ! INTENT(INOUT) !global
		     albsnd   , & ! INTENT(IN	) 
     		     albsni   , & ! INTENT(IN	) 
		     scalcoefu, & ! INTENT(OUT  ) 
		     termu    , & ! INTENT(IN	) 
		     scalcoefl, & ! INTENT(OUT  ) 
		     terml    , & ! INTENT(IN	) 
     		     lai      , & ! INTENT(IN	) 
		     sai      , & ! INTENT(IN	) 
		     fu       , & ! INTENT(IN	)
		     fl       , & ! INTENT(IN	)
		     topparu  , & ! INTENT(OUT  ) 
     		     topparl  , & ! INTENT(OUT  ) 
		     solad    , & ! INTENT(IN	)
		     solai    , & ! INTENT(IN	)
		     npoi     , & ! INTENT(IN	) 
		     nband    , & ! INTENT(IN	) 
     		     epsilon    ) ! INTENT(IN	) 
!
      END DO
!
      END IF

 END SUBROUTINE Ibis







  SUBROUTINE seasfc(tmtx  ,umtx  ,qmtx   , &
       slrad ,tsurf ,qsurf , &
       gu    ,gv    ,t_sib    ,sh_sib    ,gps   ,tsea  ,dtc3x ,sinclt, &
       sigki ,delsig,sens  ,evap  ,umom  ,vmom  ,rmi   ,rhi   , &
       cond  ,stor  ,zorl  ,rnet  ,ncols ,Ustarm,z0    , &
       rho   ,qsfc  ,tsfc  ,mskant,bstar  )
    !
    !==========================================================================
    ! ncols......Number of grid points on a gaussian latitude circle
    ! kpbl.......Number of layers pbl process is included( for u v,t )
    ! kqpbl......Number of layers pbl process is included( for q     )
    ! tmtx.......Temperature related matrix
    !            gmt(i,k,1)*d(gt(i,k-1))/dt+gmt(i,k,2)*d(gt(i,k))/dt=gmt(i,k,3)
    !            gmt(i,1,1)=0.
    !            gmt(*,*,1)...dimensionless
    !            gmt(*,*,2)...dimensionless
    !            gmt(*,*,3)...deg/sec
    ! umtx.......Wind related matrix
    !            gmu(i,k,1)*d(gu(i,k-1))/dt+gmu(i,k,2)*d(gu(i,k))/dt=gmu(i,k,3)
    !            gmu(i,k,1)*d(gv(i,k-1))/dt+gmu(i,k,2)*d(gv(i,k))/dt=gmu(i,k,4)
    !            gmu(i,1,1)=0.
    !            gmu(*,*,1)...dimensionless
    !            gmu(*,*,2)...dimensionless
    !            gmu(*,*,3)...m/sec**2
    !            gmu(*,*,4)...m/sec**2
    ! qmtx.......specific humidity related matrix
    !            gmq(i,k,1)*d(gq(i,k-1))/dt+gmq(i,k,2)*d(gq(i,k))/dt=gmq(i,k,3)
    !            gmq(i,1,1)=0.
    !            gmq(*,*,1)...dimensionless
    !            gmq(*,*,2)...dimensionless
    !            gmq(*,*,3)...kg/kg/sec
    ! slrad......radiation interpolation
    ! tsurff.....earth's surface temperature used for radiation
    !            for the first time step when ground temperature is not yet
    !            computed (this is done by subr.tsinit ),
    ! qsurf......qsurf(i)=0.622e0*EXP(21.65605e0 -5418.0e0 /tsurf(i))/gps(i)
    ! gu.........(zonal      velocity)*sin(colat)
    ! gv.........(meridional velocity)*sin(colat)
    ! gt.........Temperature
    ! gq.........Specific humidity
    ! gps........Surface pressure in mb
    ! tsea.......effective surface radiative temperature ( tgeff )
    ! dtc3x......time increment dt
    ! sinclt.....sinclt=SIN(colrad(latitu))
    ! sigki......sigki (k)=1.0e0/EXP(akappa*LOG(sig(k))),  where "sig"
    !            sigma coordinate at middle of layer and akappa=gasr/cp
    ! delsig
    ! sens.......sensible heat flux
    ! evap.......latent heat flux  "evaporation"
    ! umom.......umom(i)=fmom*um(ncount),
    !            where .fmom  momentum flux      in n/m**2
    !            fmom= rhoair(ncount)*cu(ncount)*ustar(ncount)
    !            um  (ncount)=gu (i,1)/sinclt
    !            gu          = (zonal velocity)*sin(colat)
    ! vmom.......vmom(i)=rho(i)*gv(i)*rmi(i)
    !            rho  (i)=gps(i)/(gr100*gt(i))
    !            gr100 =gasr*0.01
    ! z0ice.......Roughness length of ice
    ! rmi.........rmi   (i)=cu(i)*ustar(i), where
    !             cu is friction  transfer coefficients
    !             ustar is surface friction velocity  (m/s)
    ! rhi.........rhi   (i)=ct(i)*ustar(i), where
    !             ct is heat transfer coefficients.
    !             ustar is surface friction velocity  (m/s)
    ! cond........cond(i)=gice*(tsurf(i)-tice) or
    !             cond(i)=(2.03/2.0)*(tsurf(i)-271.16)
    ! stor........stor(i)=hscap*c0(i)
    ! zorl........zorl (i)= 100.0 *zgrav*speedm(i)*rhi(i)
    !             zgrav =0.032 /grav
    ! rnet........rnet=-697.58*slrad(i)
    !             rnet(i)=rnet(i)-stefan*tsurf(i)**4
    ! cp..........specific heat of air           (j/kg/k)
    ! hl..........heat of evaporation of water     (j/kg)
    ! gasr........gas constant of dry air        (j/kg/k)
    ! grav........grav   gravity constant        (m/s**2)
    ! stefan......Stefan Boltzman constant
    !==========================================================================
    !
    INTEGER, INTENT(in   ) :: ncols
    REAL(KIND=r8),    INTENT(INOUT) :: tmtx (ncols,3)
    REAL(KIND=r8),    INTENT(INOUT) :: umtx (ncols,4)
    REAL(KIND=r8),    INTENT(INOUT) :: qmtx (ncols,3)
    REAL(KIND=r8),    INTENT(IN   ) :: slrad(ncols)
    REAL(KIND=r8),    INTENT(INOUT) :: tsurf(ncols)
    REAL(KIND=r8),    INTENT(IN   ) :: qsurf(ncols)
    REAL(KIND=r8),    INTENT(IN   ) :: gu   (ncols)
    REAL(KIND=r8),    INTENT(IN   ) :: gv   (ncols)
    REAL(KIND=r8),    INTENT(IN   ) :: t_sib(ncols)
    REAL(KIND=r8),    INTENT(IN   ) :: sh_sib(ncols)
    REAL(KIND=r8),    INTENT(IN   ) :: gps  (ncols)
    REAL(KIND=r8),    INTENT(INOUT) :: tsea (ncols)
    REAL(KIND=r8),    INTENT(IN   ) :: dtc3x
    REAL(KIND=r8),    INTENT(IN   ) :: sinclt(ncols)
    REAL(KIND=r8),    INTENT(IN   ) :: sigki
    REAL(KIND=r8),    INTENT(IN   ) :: delsig
    REAL(KIND=r8),    INTENT(INOUT  ) :: sens (ncols)
    REAL(KIND=r8),    INTENT(INOUT  ) :: evap (ncols)
    REAL(KIND=r8),    INTENT(INOUT  ) :: umom (ncols)
    REAL(KIND=r8),    INTENT(INOUT  ) :: vmom (ncols)
    REAL(KIND=r8),    INTENT(INOUT  ) :: rmi  (ncols)
    REAL(KIND=r8),    INTENT(INOUT  ) :: rhi  (ncols)
    REAL(KIND=r8),    INTENT(INOUT  ) :: cond (ncols)
    REAL(KIND=r8),    INTENT(INOUT  ) :: stor (ncols)
    REAL(KIND=r8),    INTENT(INOUT  ) :: zorl (ncols)
    REAL(KIND=r8),    INTENT(INOUT  ) :: rnet (ncols)
    REAL(KIND=r8),    INTENT(OUT    ) :: Ustarm  (ncols)
    REAL(KIND=r8),    INTENT(INOUT    ) :: z0      (ncols)
    REAL(KIND=r8),    INTENT(OUT    ) :: rho   (ncols)
    REAL(KIND=r8),    INTENT(INOUT    ) :: qsfc (ncols)
    REAL(KIND=r8),    INTENT(INOUT    ) ::  tsfc (ncols)
    INTEGER(KIND=i8), INTENT(IN )       :: mskant(ncols)
    REAL(KIND=r8),    INTENT(INOUT    ) ::  bstar(ncols)
    REAL(KIND=r8)    :: gt    (ncols) 
    REAL(KIND=r8)    :: gq    (ncols) 
    REAL(KIND=r8)    :: speedm  (ncols)
    REAL(KIND=r8)    :: ah    (ncols)
    REAL(KIND=r8)    :: al    (ncols)
    REAL(KIND=r8)    :: am    (ncols)
    REAL(KIND=r8)    :: cuni  (ncols)
    REAL(KIND=r8)    :: cui   (ncols)
    REAL(KIND=r8)    :: cu    (ncols)
    REAL(KIND=r8)    :: ctni  (ncols)
    REAL(KIND=r8)    :: cti   (ncols)
    REAL(KIND=r8)    :: ct    (ncols)
    REAL(KIND=r8)    :: um    (ncols)
    REAL(KIND=r8)    :: vm    (ncols)
    REAL(KIND=r8)    :: tha   (ncols)
    REAL(KIND=r8)    :: thm   (ncols)
    REAL(KIND=r8)    :: dzm   (ncols)
    REAL(KIND=r8)    :: thvgm (ncols)
    REAL(KIND=r8)    :: rib   (ncols)
    REAL(KIND=r8)    :: ustar (ncols)
    REAL(KIND=r8)    :: gtsav (ncols)
    REAL(KIND=r8)    :: gqsav (ncols)
    REAL(KIND=r8)    :: tmsav (ncols)
    REAL(KIND=r8)    :: qmsav (ncols)
    REAL(KIND=r8)    :: tssav (ncols)
    REAL(KIND=r8)    :: dqg0  (ncols)
    REAL(KIND=r8)    :: b00   (ncols)
    REAL(KIND=r8)    :: b03   (ncols)
    REAL(KIND=r8)    :: b04   (ncols)
    REAL(KIND=r8)    :: c0    (ncols)
    REAL(KIND=r8)    :: b30   (ncols)
    REAL(KIND=r8)    :: b33   (ncols)
    REAL(KIND=r8)    :: c3    (ncols)
    REAL(KIND=r8)    :: b40   (ncols)
    REAL(KIND=r8)    :: b44   (ncols)
    REAL(KIND=r8)    :: c4    (ncols)
    LOGICAL :: jstneu
    REAL(KIND=r8) :: u2 (ncols)

    INTEGER :: i
    INTEGER :: ncount
    REAL(KIND=r8)    :: gbyhl
    REAL(KIND=r8)    :: gbycp
    REAL(KIND=r8)    :: gr100
    REAL(KIND=r8)    :: gb100
    REAL(KIND=r8)    :: zgrav
    REAL(KIND=r8)    :: gice
    REAL(KIND=r8)    :: hscap
    REAL(KIND=r8)    :: sl1kap
    REAL(KIND=r8)    :: st4
    REAL(KIND=r8)    :: dti
    REAL(KIND=r8)    :: dtm
    REAL(KIND=r8)    :: dtmdt
    REAL(KIND=r8)    :: dqm
    REAL(KIND=r8)    :: dqmdt
    !*JPB REAL(KIND=r8), PARAMETER :: dd=0.05_r8
    REAL(KIND=r8), PARAMETER :: dd=3.0_r8 ! Total depth of the ice slab (m), Using ECMWF value
    REAL(KIND=r8), PARAMETER :: tice=271.16_r8
    REAL(KIND=r8), PARAMETER :: dice=2.0_r8
    REAL(KIND=r8), PARAMETER :: hice=2.03_r8
    REAL(KIND=r8), PARAMETER :: rhoice=920.0_r8 ! Mean ice density (kg/m3)
    REAL(KIND=r8), PARAMETER :: cice=2093.0_r8  ! Heat Capacity of Ice (J/Kg)
    RETURN

    gr100 =rgas*0.01_r8
    gbycp =grav/(cp*delsig*100.0_r8 *sigki)
    gbyhl =grav/(hltm*delsig*100.0_r8 )
    gb100 =grav/(   delsig*100.0_r8 )
    zgrav =0.032_r8 /grav
    gice  =hice/dice ! 2.03_r8/2.0_r8
    hscap =rhoice*cice*dd/dtc3x
    sl1kap=sigki
    st4   =stefan*4.0_r8
    dti   =1.0_r8 /dtc3x
    gt=t_sib
    gq=sh_sib
    DO i = 1, ncols
       IF(mskant(i) == 1)THEN
          rnet (i)=-697.58_r8*slrad(i)
          rho  (i)=gps(i)/(gr100*gt(i))
          ah   (i)=gbycp/gps(i)
          al   (i)=gbyhl/gps(i)
          dqg0 (i)=0.622_r8 *EXP(30.25353_r8 -5418.0_r8 /tsurf(i)) &
               /(tsurf(i)*tsurf(i)*gps(i))
          gtsav(i)=gt   (i)
          gqsav(i)=gq   (i)
          tssav(i)=tsurf(i)
          tmsav(i)=tmtx (i,3)
          qmsav(i)=qmtx (i,3)
        END IF
    END DO

    c0  =0.0_r8
    cond=0.0_r8
    stor=0.0_r8

    ncount=0
8000 CONTINUE
    ncount=ncount+1
   !
    !     the first call to vntlat just gets the neutral values of ustar
    !     and ventmf.
    !
    
!    jstneu=.TRUE.
!    CALL vntlt2 &
!       (rmi   ,rhi   ,gu    ,gv    ,gt    ,tsurf ,tsea  ,ncols , &
!       sigki ,cuni  ,cui   ,cu    ,ctni  ,cti   ,ct    ,speedm,tha   , &
!       thm   ,dzm   ,thvgm ,rib   ,z0    ,zorl  ,ustar ,sinclt,mskant,jstneu,u2  )
!
!   jstneu=.FALSE.
!    CALL vntlt2 &
!       (rmi   ,rhi   ,gu    ,gv    ,gt    ,tsurf ,tsea  ,ncols , &
!       sigki ,cuni  ,cui   ,cu    ,ctni  ,cti   ,ct    ,speedm,tha   , &
!       thm   ,dzm   ,thvgm ,rib   ,z0    ,zorl  ,ustar ,sinclt,mskant,jstneu,u2  )
!
    CALL vntlt1 ( &
         rmi   ,rhi   ,gu    ,gv    ,gt    ,tsurf ,tsea  ,ncols , &
         sigki ,cuni  ,cui   ,cu    ,ctni  ,cti   ,ct    ,speedm,tha   , &
         thm   ,dzm   ,thvgm ,rib   ,z0    ,zorl  ,ustar ,sinclt,mskant )
    DO i = 1, ncols
       IF(mskant(i) == 1)THEN
          gt  (i)    =gtsav(i)
          gq  (i)    =gqsav(i)
          tsurf(i)   =tssav(i)
          tmtx(i,3)=tmsav(i)
          qmtx(i,3)=qmsav(i)
       END IF
    END DO
    DO i = 1, ncols
       IF(mskant(i) == 1)THEN
          IF (tsea(i) < 0.0_r8 .AND. ABS(tsea(i)) < tice+0.01_r8) THEN
             b00(i)=   hscap+cp*rho(i)*rhi(i) &
                  +hltm*rho(i)*rhi(i)*dqg0(i) &
                  +gice+st4*tsurf(i)**3
             b03(i)=        -cp*rho(i)*rhi(i)*sl1kap
             b04(i)=-hltm*rho(i)*rhi(i)
             c0 (i)=rnet(i) -cp*rho(i)*rhi(i)*(tsurf(i)-sl1kap*gt(i)) &
                  -hltm*rho(i)*rhi(i)*(qsurf(i)-       gq(i)) &
                  -gice*(tsurf(i)-tice)-stefan*tsurf(i)**4
             b30(i)=               -ah (i)*cp*rho(i)*rhi(i)
             b33(i)=tmtx(i,2)*dti-b30(i)*          sl1kap
             c3 (i)=tmtx(i,3)    -b30(i)*(tsurf(i)-sl1kap*gt(i))
             b40(i)=               -al(i)*hltm*rho(i)*rhi(i)* dqg0 (i)
             b44(i)=qmtx(i,2)*dti+al(i)*hltm*rho(i)*rhi(i)
             c4 (i)=qmtx(i,3)    + &
                  al(i)*hltm*rho(i)*rhi(i)*(qsurf(i)-gq(i))
             b00(i)=b00(i)-b30(i)*b03(i)/b33(i)-b40(i)*b04(i)/b44(i)
             c0 (i)=c0 (i)-c3 (i)*b03(i)/b33(i)-c4 (i)*b04(i)/b44(i)
             c0 (i)=c0 (i)/b00(i)
             tsurf(i)=tsurf(i)+c0(i)
             tmtx(i,3)=(c3(i)-b30(i)*c0(i))/(b33(i)*dtc3x)
             qmtx(i,3)=(c4(i)-b40(i)*c0(i))/(b44(i)*dtc3x)
          ELSE IF (tsea(i) < 0.0_r8 .AND. ABS(tsea(i)) > tice+0.01_r8) THEN
             zorl (i)= 100.0_r8 *zgrav*speedm(i)*rhi(i)
             sens (i)= rho(i)*cp*(tsurf(i)-gt(i)*sigki)*rhi(i)
             evap (i)= rho(i)*hltm*(qsurf(i)-gq(i))*rhi(i)
             tmtx(i,3)=(tmtx(i,3)+ah(i)*sens(i)) &
                  /(tmtx(i,2)+dtc3x*ah(i)*rho(i)*cp*rhi(i))
             qmtx(i,3)=(qmtx(i,3)+al(i)*evap(i)) &
                  /(qmtx(i,2)+dtc3x*al(i)*rho(i)*hltm*rhi(i))
          END IF
       END IF	  
    END DO

    DO i = 1, ncols
       IF(mskant(i) == 1)THEN
          gt(i)=gt(i)+tmtx(i,3)*dtc3x
          gq(i)=gq(i)+qmtx(i,3)*dtc3x
       END IF
    END DO

    IF (ncount == 1) go to 8000

    DO i = 1, ncols
      IF(mskant(i) == 1)THEN
          sens(i)=rho(i)*cp*(tsurf(i)-gt(i)*sigki)*rhi(i)
          evap(i)=rho(i)*hltm*(qsurf(i)-gq(i)         )*rhi(i)
          dtmdt=(ah(i)*sens(i))/(tmtx(i,2)+dtc3x*ah(i)*rho(i)*cp*rhi(i)+0.0001)
          dqmdt=(al(i)*evap(i))/(qmtx(i,2)+dtc3x*al(i)*rho(i)*hltm*rhi(i)+0.0001)
          dtm=dtmdt*dtc3x
          dqm=dqmdt*dtc3x
          tsfc   (i)=gt(i)+dtm
          qsfc   (i)=gq(i)+dqm

          gt  (i)=gtsav(i)
          gq  (i)=gqsav(i)
          rnet(i)=rnet(i)-stefan*tsurf(i)**4
          IF (tsea(i) < 0.0_r8 .AND. ABS(tsea(i)) < tice+0.01_r8) THEN
             cond(i)=gice*(tsurf(i)-tice)
             stor(i)=hscap*c0(i)
             rnet(i)=rnet(i)-stefan*tsurf(i)**3*4.0_r8 *c0(i)
             tsurf(i)=MIN(tsurf(i),tice)
             tsea (i)=-   tsurf(i)
          END IF
       END IF
    END DO

    DO i = 1, ncols
       IF(mskant(i) == 1)THEN
          umom(i)=rho(i)*gu(i)*rmi(i)
          vmom(i)=rho(i)*gv(i)*rmi(i)
          am  (i)=gb100/gps(i)
          umtx(i,3)=(umtx(i,3)-am(i)*umom(i)) &
               /(umtx(i,2)+dtc3x*am(i)*rho(i)*rmi(i))
          umtx(i,4)=(umtx(i,4)-am(i)*vmom(i)) &
               /(umtx(i,2)+dtc3x*am(i)*rho(i)*rmi(i))
          !
             !     set surface stress use of pseudo winds to true winds
          !     for output diagnostics
          !
          umom(i)=umom(i)/sinclt(i)
          vmom(i)=vmom(i)/sinclt(i)
          Ustarm(i) = sqrt(umom(i)**2 + vmom(i)**2)
          IF(Ustarm(i)==0.0_r8)Ustarm(i)=0.007_r8
          um  (i)=gu (i)/sinclt(i)
          vm  (i)=gv (i)/sinclt(i)
          speedm(i)=SQRT(um(i)**2 + vm(i)**2)
          speedm(i)=MAX(2.0_r8 , speedm(i))
	  dzm   (i)=rbyg*gt(i)
  	  bstar(i)=cu(i)*grav*(ct(i)*(tsfc(i)-gt(i)-(grav/cp)*dzm(i))/gt(i))! + mapl_vireps*ct(i)*(qsfc(i)-gq(i)))
       END IF
    END DO
  END SUBROUTINE seasfc







  ! vntlt1 :performs ventilation mass flux, based on deardorff, mwr, 1972?.



  SUBROUTINE vntlt1 &
       (rmi   ,rhi   ,gu    ,gv    ,gt    ,tsurf ,tsea  ,ncols , &
       sigki ,cuni  ,cui   ,cu    ,ctni  ,cti   ,ct    ,speedm,tha   , &
       thm   ,dzm   ,thvgm ,rib   ,z0    ,zorl  ,ustar ,sinclt,mskant  )
    !
    !==========================================================================
    !==========================================================================
    !==========================================================================
    ! imax..........number of grid points on a gaussian latitude circle
    ! z0ice.........Roughness length of ice
    ! sinclt........sinclt=SIN(colrad(latitu))
    ! rmi...........rmi   (i)=cu(i)*ustar(i), where
    !               cu is friction  transfer coefficients
    !               ustar is surface friction velocity  (m/s)
    ! rhi...........rhi   (i)=ct(i)*ustar(i), where
    !               ct is heat transfer coefficients.
    !               ustar is surface friction velocity  (m/s)
    ! gu............(zonal      velocity)*sin(colat)
    ! gv............(meridional velocity)*sin(colat)
    ! gt............temperature
    ! tsurf.........earth's surface temperature used for radiation
    !               for the first time step when ground temperature is not yet
    !               computed (this is done by subr.tsinit ),
    ! tsea..........effective surface radiative temperature ( tgeff )
    ! zorl..........zorl (i)= 100.0 *zgrav*speedm(i)*rhi(i)
    !               zgrav =0.032 /grav
    ! delsig
    ! sigki ........sigki (k)=1.0e0/EXP(akappa*LOG(sig(k))),  where "sig"
    !               sigma coordinate at middle of layer and akappa=gasr/cp
    ! cuni..........neutral friction transfer  coefficients.
    ! cui...........cui   (i)=cuni(i)*EXP( aa-SQRT(aa*aa+bb*f))
    !               cui   (i)=cuni(i)*EXP(-tt+SQRT(tt*tt+ss*f))
    ! cu............Friction  transfer coefficients.
    ! ctni..........neutral heat transfer coefficients.
    ! cti...........cti   (i)=ctni(i)*EXP( qq-SQRT(qq*qq+rr*g))
    !               cti   (i)=cui (i)
    ! ct............heat transfer coefficients.
    ! speedm........speedm(i)=SQRT(gu(i)**2+gv(i)**2)*sincli, where
    !               sincli=1.0 /sinclt
    ! tha...........tha   (i)= tsurf(i)
    ! thm...........thm   (i)= gt(i)*sigki(1)
    ! dzm...........dzm   (i)=gt(i)*rbyg
    !               rbyg  =gasr/grav*delsig(1)*0.5
    ! thvgm.........thvgm (i)= tha(i)-thm(i)
    ! rib...........bulk richardson number.
    ! z0............Roughness length
    ! ustarr........surface friction velocity  (m/s)
    ! gasr..........gas constant of dry air        (j/kg/k)
    ! grav..........grav   gravity constant        (m/s**2)
    !==========================================================================
    !
    INTEGER, INTENT(in   ) :: ncols
    REAL(KIND=r8),    INTENT(in   ) :: sinclt(ncols)
    REAL(KIND=r8),    INTENT(inout  ) :: rmi   (ncols)
    REAL(KIND=r8),    INTENT(inout  ) :: rhi   (ncols)
    REAL(KIND=r8),    INTENT(in   ) :: gu    (ncols)
    REAL(KIND=r8),    INTENT(in   ) :: gv    (ncols)
    REAL(KIND=r8),    INTENT(in   ) :: gt    (ncols)
    REAL(KIND=r8),    INTENT(in   ) :: tsurf (ncols)
    REAL(KIND=r8),    INTENT(in   ) :: tsea  (ncols)
    REAL(KIND=r8),    INTENT(in   ) :: zorl  (ncols)
    REAL(KIND=r8),    INTENT(in   ) :: sigki  
    REAL(KIND=r8),    INTENT(inout) :: cuni  (ncols)
    REAL(KIND=r8),    INTENT(inout) :: cui   (ncols)
    REAL(KIND=r8),    INTENT(inout) :: cu    (ncols)
    REAL(KIND=r8),    INTENT(inout) :: ctni  (ncols)
    REAL(KIND=r8),    INTENT(inout) :: cti   (ncols)
    REAL(KIND=r8),    INTENT(inout) :: ct    (ncols)
    REAL(KIND=r8),    INTENT(inout) :: speedm(ncols)
    REAL(KIND=r8),    INTENT(inout) :: tha   (ncols)
    REAL(KIND=r8),    INTENT(inout) :: thm   (ncols)
    REAL(KIND=r8),    INTENT(inout) :: dzm   (ncols)
    REAL(KIND=r8),    INTENT(inout) :: thvgm (ncols)
    REAL(KIND=r8),    INTENT(inout) :: rib   (ncols)
    REAL(KIND=r8),    INTENT(inout) :: z0    (ncols)
    REAL(KIND=r8),    INTENT(inout) :: ustar (ncols)
    INTEGER(KIND=i8)      , INTENT(in   ) :: mskant(ncols)

    REAL(KIND=r8),        PARAMETER :: vkrmn=0.40_r8
    REAL(KIND=r8),        PARAMETER :: ribc=3.05_r8
    REAL(KIND=r8),        PARAMETER :: aa=1.2270_r8
    REAL(KIND=r8),        PARAMETER :: bb=1.2642_r8
    REAL(KIND=r8),        PARAMETER :: tt=1.8900_r8
    REAL(KIND=r8),        PARAMETER :: ss=5.0519_r8
    REAL(KIND=r8),        PARAMETER :: ee=1.2743_r8
    REAL(KIND=r8),        PARAMETER :: ff=3.4805_r8
    REAL(KIND=r8),        PARAMETER :: gg=0.87581_r8
    REAL(KIND=r8),        PARAMETER :: hh=-1.5630_r8
    REAL(KIND=r8),        PARAMETER :: pp=10.815_r8
    REAL(KIND=r8),        PARAMETER :: qq=1.3462_r8
    REAL(KIND=r8),        PARAMETER :: rr=1.8380_r8
    REAL(KIND=r8)                   :: sincli(ncols)
    REAL(KIND=r8)                   :: f
    REAL(KIND=r8)                   :: g
    INTEGER                :: i

    DO i = 1, ncols
       IF(mskant(i) == 1)THEN
          z0(i)=0.001_r8
          IF (tsea(i) < 0.0_r8 .AND. ABS(tsea(i)) >= 271.17_r8) THEN
             z0(i)=0.01_r8*zorl(i)
          ELSE IF (tsea(i) < 0.0_r8 .AND. ABS(tsea(i)) < 271.17_r8) THEN
            z0(i)=z0ice
          END IF
          sincli(i)=1.0_r8 /sinclt(i)
       END IF  
    END DO

    DO i = 1, ncols
       IF(mskant(i) == 1)THEN
          !IF (tsea(i) <= 0.0_r8) THEN
             speedm(i)=SQRT(gu(i)**2+gv(i)**2)*sincli(i)
             speedm(i)=MAX(2.0_r8 ,speedm(i))
             dzm   (i)=gt(i)*rbyg
             cuni(i)=LOG(dzm(i)/z0(i))/vkrmn*gg+hh
             ctni(i)=cuni(i)
             !
             !     stability branch based on bulk richardson number.
             !
             thm   (i)= gt(i)*sigki
             tha   (i)= tsurf(i)
             thvgm (i)= tha(i)-thm(i)
             rib   (i)=-thvgm(i)*grav*dzm(i)/ (thm(i)*speedm(i)**2)
             rib   (i)=MAX(-1.25_r8 ,rib(i))
             rib   (i)=MIN( 1.25_r8 ,rib(i))
             IF (rib(i) < 0.0_r8) THEN
                f        =LOG(1.0_r8-ee*rib(i))
                cui   (i)=cuni(i)*EXP( aa-SQRT(aa*aa+bb*f))
                g        =LOG(1.0_r8-ff*rib(i))
                cti   (i)=ctni(i)*EXP( qq-SQRT(qq*qq+rr*g))
             ELSE
                f        =LOG(1.0_r8+pp*rib(i))
                cui   (i)=cuni(i)*EXP(-tt+SQRT(tt*tt+ss*f))
                cti   (i)=cui (i)
             END IF
             cu    (i)=1.0_r8/cui(i)
             ct    (i)=1.0_r8/cti(i)
             !
             !     surface friction velocity and ventilation mass flux
             !
             ustar (i)=speedm(i)*cu(i)
             rmi   (i)=cu(i)*ustar(i)
             rhi   (i)=ct(i)*ustar(i)
         ! END IF
       END IF
    END DO
  END SUBROUTINE vntlt1






 ! vntlt1 :performs ventilation mass flux, based on deardorff, mwr, 1972?.



  SUBROUTINE vntlt2 &
       (rmi   ,rhi   ,gu    ,gv    ,gt    ,tsurf ,tsea  ,ncols , &
       sigki ,cuni  ,cui   ,cu    ,ctni  ,cti   ,ct    ,speedm,tha   , &
       thm   ,dzm   ,thvgm ,rib   ,z0    ,zorl  ,ustar ,sinclt,mskant,jstneu,u2  )
    !
    !==========================================================================
    !==========================================================================
    !==========================================================================
    ! imax..........number of grid points on a gaussian latitude circle
    ! z0ice.........Roughness length of ice
    ! sinclt........sinclt=SIN(colrad(latitu))
    ! rmi...........rmi   (i)=cu(i)*ustar(i), where
    !               cu is friction  transfer coefficients
    !               ustar is surface friction velocity  (m/s)
    ! rhi...........rhi   (i)=ct(i)*ustar(i), where
    !               ct is heat transfer coefficients.
    !               ustar is surface friction velocity  (m/s)
    ! gu............(zonal      velocity)*sin(colat)
    ! gv............(meridional velocity)*sin(colat)
    ! gt............temperature
    ! tsurf.........earth's surface temperature used for radiation
    !               for the first time step when ground temperature is not yet
    !               computed (this is done by subr.tsinit ),
    ! tsea..........effective surface radiative temperature ( tgeff )
    ! zorl..........zorl (i)= 100.0 *zgrav*speedm(i)*rhi(i)
    !               zgrav =0.032 /grav
    ! delsig
    ! sigki ........sigki (k)=1.0e0/EXP(akappa*LOG(sig(k))),  where "sig"
    !               sigma coordinate at middle of layer and akappa=gasr/cp
    ! cuni..........neutral friction transfer  coefficients.
    ! cui...........cui   (i)=cuni(i)*EXP( aa-SQRT(aa*aa+bb*f))
    !               cui   (i)=cuni(i)*EXP(-tt+SQRT(tt*tt+ss*f))
    ! cu............Friction  transfer coefficients.
    ! ctni..........neutral heat transfer coefficients.
    ! cti...........cti   (i)=ctni(i)*EXP( qq-SQRT(qq*qq+rr*g))
    !               cti   (i)=cui (i)
    ! ct............heat transfer coefficients.
    ! speedm........speedm(i)=SQRT(gu(i)**2+gv(i)**2)*sincli, where
    !               sincli=1.0 /sinclt
    ! tha...........tha   (i)= tsurf(i)
    ! thm...........thm   (i)= gt(i)*sigki(1)
    ! dzm...........dzm   (i)=gt(i)*rbyg
    !               rbyg  =gasr/grav*delsig(1)*0.5
    ! thvgm.........thvgm (i)= tha(i)-thm(i)
    ! rib...........bulk richardson number.
    ! z0............Roughness length
    ! ustarr........surface friction velocity  (m/s)
    ! gasr..........gas constant of dry air        (j/kg/k)
    ! grav..........grav   gravity constant        (m/s**2)
    !==========================================================================
    !
    INTEGER, INTENT(in   ) :: ncols
    INTEGER, PARAMETER :: r8 = 8
    INTEGER, PARAMETER :: i8 = 8

    REAL(KIND=r8),    INTENT(in   ) :: sinclt(ncols)
    REAL(KIND=r8),    INTENT(inout  ) :: rmi   (ncols)
    REAL(KIND=r8),    INTENT(inout  ) :: rhi   (ncols)
    REAL(KIND=r8),    INTENT(in   ) :: gu    (ncols)
    REAL(KIND=r8),    INTENT(in   ) :: gv    (ncols)
    REAL(KIND=r8),    INTENT(in   ) :: gt    (ncols)
    REAL(KIND=r8),    INTENT(in   ) :: tsurf (ncols)
    REAL(KIND=r8),    INTENT(in   ) :: tsea  (ncols)
    REAL(KIND=r8),    INTENT(in   ) :: zorl  (ncols)
    REAL(KIND=r8),    INTENT(in   ) :: sigki  
    REAL(KIND=r8),    INTENT(inout) :: cuni  (ncols)
    REAL(KIND=r8),    INTENT(inout) :: cui   (ncols)
    REAL(KIND=r8),    INTENT(inout) :: cu    (ncols)
    REAL(KIND=r8),    INTENT(inout) :: ctni  (ncols)
    REAL(KIND=r8),    INTENT(inout) :: cti   (ncols)
    REAL(KIND=r8),    INTENT(inout) :: ct    (ncols)
    REAL(KIND=r8),    INTENT(inout) :: speedm(ncols)
    REAL(KIND=r8),    INTENT(inout) :: tha   (ncols)
    REAL(KIND=r8),    INTENT(inout) :: thm   (ncols)
    REAL(KIND=r8),    INTENT(inout) :: dzm   (ncols)
    REAL(KIND=r8),    INTENT(inout) :: thvgm (ncols)
    REAL(KIND=r8),    INTENT(inout) :: rib   (ncols)
    REAL(KIND=r8),    INTENT(inout) :: z0    (ncols)
    REAL(KIND=r8),    INTENT(inout) :: ustar (ncols)
    INTEGER(KIND=i8)      , INTENT(in   ) :: mskant(ncols)
    LOGICAL, INTENT(in   ) :: jstneu
    REAL(KIND=r8),    INTENT(inout) :: u2 (ncols)

    REAL(KIND=r8),        PARAMETER :: vkrmn=0.40_r8
    REAL(KIND=r8),        PARAMETER :: ribc=3.05_r8
    REAL(KIND=r8),        PARAMETER :: aa=1.2270_r8
    REAL(KIND=r8),        PARAMETER :: bb=1.2642_r8
    REAL(KIND=r8),        PARAMETER :: tt=1.8900_r8
    REAL(KIND=r8),        PARAMETER :: ss=5.0519_r8
    REAL(KIND=r8),        PARAMETER :: ee=1.2743_r8
    REAL(KIND=r8),        PARAMETER :: ff=3.4805_r8
    REAL(KIND=r8),        PARAMETER :: gg=0.87581_r8
    REAL(KIND=r8),        PARAMETER :: hh=-1.5630_r8
    REAL(KIND=r8),        PARAMETER :: pp=10.815_r8
    REAL(KIND=r8),        PARAMETER :: qq=1.3462_r8
    REAL(KIND=r8),        PARAMETER :: rr=1.8380_r8
    REAL(KIND=r8), PARAMETER ::  fsc=66.85_r8
    REAL(KIND=r8), PARAMETER ::  ftc=0.904_r8
    REAL(KIND=r8), PARAMETER ::  fvc=0.315_r8

    REAL(KIND=r8)                   :: sincli(ncols)
    REAL(KIND=r8)                   :: f
    REAL(KIND=r8)                   :: g
    REAL(KIND=r8)                   :: zl
    REAL(KIND=r8)                   :: xct1
    REAL(KIND=r8)                   :: xct2
    REAL(KIND=r8)                   :: xctu1
    REAL(KIND=r8)                   :: xctu2
    REAL(KIND=r8)                   :: grib
    REAL(KIND=r8)                   :: grzl
    REAL(KIND=r8)                   :: grz2
    REAL(KIND=r8)                   :: fvv
    REAL(KIND=r8)                   :: ftt
    REAL(KIND=r8)                   :: rzl
    REAL(KIND=r8)                   :: rz2
    INTEGER                :: i
    REAL(KIND=r8) :: rfac
    REAL(KIND=r8) :: vkrmni
    REAL(KIND=r8) :: g2
    REAL(KIND=r8) :: z2(ncols)
    REAL(KIND=r8) :: d(ncols)
    REAL(KIND=r8) ::ustarn(ncols)
    rfac  =1.0e2_r8 /rair
    vkrmni=1.0_r8  /vkrmn
    g2 = 0.75_r8
    DO i = 1, ncols
    z2(i)  = 0.500_r8
    d (i)  = (0.500_r8+0.100_r8)/2.0_r8
       IF(mskant(i) == 1)THEN
          z0(i)=0.001_r8
          IF (tsea(i) < 0.0_r8 .AND. ABS(tsea(i)) >= 271.17_r8) THEN
             z0(i)=0.01_r8*zorl(i)
          ELSE IF (tsea(i) < 0.0_r8 .AND. ABS(tsea(i)) < 271.17_r8) THEN
            z0(i)=z0ice
          END IF
          sincli(i)=1.0_r8 /sinclt(i)
       END IF  
    END DO


 
    IF (jstneu) THEN
       DO i = 1, ncols
          IF(mskant(i) == 1)THEN
             speedm(i)=SQRT(gu(i)**2+gv(i)**2)*sincli(i)
             speedm(i)=MAX(0.5_r8 ,speedm(i))
             dzm   (i)=gt(i)*rbyg
             zl = z2(i) + 11.785_r8  * z0(i)
             cuni(i)=LOG((dzm(i)-d(i))/z0(i))*vkrmni
             ustarn(i)=speedm(i)/cuni(i)
             IF (zl < dzm(i)) THEN
                xct1 = LOG((dzm(i)-d(i))/(zl-d(i)))
                xct2 = LOG((zl-d(i))/z0(i))
                xctu1 = xct1
                xctu2 = LOG((zl-d(i))/(z2(i)-d(i)))
                ctni(i) = (xct1 + g2 * xct2) *vkrmni
             ELSE
                xct2 =  LOG((dzm(i)-d(i))/z0(i))
                xctu1 =  0.0_r8
                xctu2 =  LOG((dzm(i)-d(i))/(z2(i)-d(i)))
                ctni(i) = g2 * xct2 *vkrmni
             END IF
             !
             !     neutral values of ustar and ventmf
             !
             u2(i) = speedm(i) - ustarn(i)*vkrmni*(xctu1 + g2*xctu2)
          END IF
       END DO
       RETURN
    END IF
    !
    !     stability branch based on bulk richardson number.
    !
    DO i = 1, ncols
      IF(mskant(i) == 1)THEN
         IF (tsea(i) <= 0.0_r8) THEN

          !
          !     freelm(i)=.false.
          !
          speedm(i)=SQRT(gu(i)**2+gv(i)**2)*sincli(i)
          speedm(i)=MAX(0.5_r8 ,speedm(i))
          dzm	(i)=gt(i)*rbyg
          thm	(i)= gt(i)*sigki
          tha	(i)= tsurf(i)
          thvgm (i)= tha(i)-thm(i)        
          zl       = z2(i) + 11.785_r8  * z0(i)
          rib(i)   =-thvgm(i)   *grav*(dzm(i)-d(i)) &
               /( thm(i)*(speedm(i)-u2(i))**2)
          ! Manzi Suggestion:
          ! rib   (i)=max(-10.0_r8  ,rib(i))
          rib(i)      =MAX(-1.5_r8  ,rib(i)   )
          rib(i)      =MIN( 0.165_r8  ,rib (i)  )
          IF (rib(i)    < 0.0_r8) THEN
             grib = -rib(i)
             grzl = -rib(i)   * (zl-d(i))/(dzm(i)-d(i))
             grz2 = -rib(i)   * z0(i)/(dzm(i)-d(i))
             fvv = fvc*grib
             IF (zl < dzm(i)) THEN
                ftt = (ftc*grib) + (g2-1.0_r8) * (ftc*grzl) - g2 * (ftc*grz2)
             ELSE
                ftt = g2*((ftc*grib) - (ftc*grz2))
             END IF
             cui(i)   = cuni(i) - fvv
             cti(i)    = ctni(i) - ftt
          ELSE
             rzl = rib(i)   /(dzm(i)-d(i))*(zl-d(i))
             rz2 = rib(i)   /(dzm(i)-d(i))*z0(i)
             fvv = fsc*rib(i)
             IF (zl < dzm(i)) THEN
                ftt = (fsc*rib(i)) + (g2-1) * (fsc*rzl) - g2 * (fsc*rz2)
             ELSE
                ftt = g2 * ((fsc*rib(i)) - (fsc*rz2))
             END IF
             cui(i)    = cuni(i) + fvv
             cti(i)    = ctni(i) + ftt
          ENDIF
          cu    (i)=1.0_r8/cui(i)
          !**(JP)** ct is not used anywhere else
          ct    (i)=1.0_r8/cti(i)
          !
          !
          !     surface friction velocity and ventilation mass flux
          !
          ustar (i)=speedm(i)*cu(i)
          !**(JP)** ran is not used anywhere else
          !ran(i) = ctni(i) / ustarn(i)
          !ran(i) = MAX(ran(i), 0.8_r8 )
          rmi	(i)=cu(i)*ustar(i)
          rhi	(i)=ct(i)*ustar(i)
         END IF
      END IF
    END DO
  END SUBROUTINE vntlt2


  SUBROUTINE Albedo_IBIS(jb,nCols,nmax,zenith,tsea,imask,avisb       ,avisd     ,anirb      , &
	                  anird )

    IMPLICIT NONE
    INTEGER , INTENT(IN) :: jb
    INTEGER , INTENT(IN) :: nCols
    INTEGER , INTENT(IN) :: nmax
    REAL(KIND=r8) , INTENT(IN   ) :: zenith (nCols)       ! cosine of solar zenith angle   
    REAL(KIND=r8) , INTENT(IN   ) :: tsea   (nCols)       ! cosine of solar zenith angle   
    INTEGER(KIND=i8),INTENT(IN   ) :: imask (ncols)
    REAL(KIND=r8),INTENT(OUT  ) :: avisb (ncols)
    REAL(KIND=r8),INTENT(OUT  ) :: avisd (ncols)
    REAL(KIND=r8),INTENT(OUT  ) :: anirb (ncols)
    REAL(KIND=r8),INTENT(OUT  ) :: anird (ncols)

    INTEGER       :: nsol         ! number of points in indsol
    REAL(KIND=r8) :: solu   (nCols)! solar flux (direct + diffuse) absorbed by upper canopy leaves per unit canopy area (W m-2)
    REAL(KIND=r8) :: sols   (nCols)! solar flux (direct + diffuse) absorbed by upper canopy stems per unit canopy area (W m-2)
    REAL(KIND=r8) :: soll   (nCols)! solar flux (direct + diffuse) absorbed by lower canopy leaves and stems per unit canopy area (W m-2)
    REAL(KIND=r8) :: solg   (nCols)! solar flux (direct + diffuse) absorbed by unit snow-free soil (W m-2)
    REAL(KIND=r8) :: soli   (nCols)! solar flux (direct + diffuse) absorbed by unit snow surface (W m-2)
    REAL(KIND=r8) :: scalcoefl(nCols,4)   ! term needed in lower canopy scaling
    REAL(KIND=r8) :: scalcoefu(nCols,4)   ! term needed in upper canopy scaling
    INTEGER       :: indsol (nCols)	 ! index of current strip for points with positive coszen
    REAL(KIND=r8) :: topparu(nCols)	! total photosynthetically active raditaion absorbed by top leaves of upper canopy (W m-2)
    REAL(KIND=r8) :: topparl(nCols)	! total photosynthetically active raditaion absorbed by top leaves of lower canopy (W m-2)
    REAL(KIND=r8) :: albsod (nCols)	  ! direct  albedo for soil surface (visible or IR)
    REAL(KIND=r8) :: albsoi (nCols)	  ! diffuse albedo for soil surface (visible or IR)
    REAL(KIND=r8) :: albsnd (nCols)	  ! direct  albedo for snow surface (visible or IR)
    REAL(KIND=r8) :: albsni (nCols)	  ! diffuse albedo for snow surface (visible or IR)
    REAL(KIND=r8) :: relod  (nCols)	 ! upward direct radiation per unit icident direct beam on lower canopy (W m-2)
    REAL(KIND=r8) :: reloi  (nCols)	 ! upward diffuse radiation per unit incident diffuse radiation on lower canopy (W m-2)
    REAL(KIND=r8) :: reupd  (nCols)	 ! upward direct radiation per unit incident direct radiation on upper canopy (W m-2)
    REAL(KIND=r8) :: reupi  (nCols)	 ! upward diffuse radiation per unit incident diffuse radiation on upper canopy (W m-2)
    REAL(KIND=r8) :: ablod  (nCols)	  ! fraction of direct  radiation absorbed by lower canopy
    REAL(KIND=r8) :: abloi  (nCols)	  ! fraction of diffuse radiation absorbed by lower canopy
    REAL(KIND=r8) :: flodd  (nCols)	  ! downward direct radiation per unit incident direct radiation on lower canopy (W m-2)
    REAL(KIND=r8) :: dummy  (nCols)	  ! placeholder, always = 0: no direct flux produced for diffuse incident
    REAL(KIND=r8) :: flodi  (nCols)	 ! downward diffuse radiation per unit incident direct radiation on lower canopy (W m-2)
    REAL(KIND=r8) :: floii  (nCols)	 ! downward diffuse radiation per unit incident diffuse radiation on lower canopy
    REAL(KIND=r8) :: terml  (nCols,7)	  ! term needed in lower canopy scaling
    REAL(KIND=r8) :: termu  (nCols,7)	  ! term needed in upper canopy scaling
    REAL(KIND=r8) :: abupd  (nCols)       ! fraction of direct  radiation absorbed by upper canopy
    REAL(KIND=r8) :: abupi  (nCols)	 ! fraction of diffuse radiation absorbed by upper canopy
    REAL(KIND=r8) :: fupdd  (nCols)	 ! downward direct radiation per unit incident direct beam on upper canopy (W m-2)
    REAL(KIND=r8) :: fupdi  (nCols)	 ! downward diffuse radiation per unit icident direct radiation on upper canopy (W m-2)
    REAL(KIND=r8) :: fupii  (nCols)	 ! downward diffuse radiation per unit incident diffuse radiation on upper canopy (W m-2)
    REAL(KIND=r8) :: fwetu  (nCols)	 ! fraction of upper canopy leaf area wetted by intercepted liquid and/or snow
    REAL(KIND=r8) :: rliqu  (nCols)	 ! proportion of fwetu due to liquid
    REAL(KIND=r8) :: fwets  (nCols)	 ! fraction of upper canopy stem area wetted by intercepted liquid and/or snow
    REAL(KIND=r8) :: rliqs  (nCols)	 ! proportion of fwets due to liquid
    REAL(KIND=r8) :: fwetl  (nCols)	 ! fraction of lower canopy stem & leaf area wetted by intercepted liquid and/or snow
    REAL(KIND=r8) :: rliql  (nCols)	 ! proportion of fwetl due to liquid
    REAL(KIND=r8) :: coszen (nCols)       ! cosine of solar zenith angle
    REAL(KIND=r8) :: f
    REAL(KIND=r8) :: ocealb
    INTEGER       :: ncount
    INTEGER       :: ib  ,i, npoi
    npoi=0
    DO i=1,nCols
       IF (iMask(i) >= 1) THEN
    	 npoi=npoi+1 
         coszen(npoi) = zenith(i)
       END IF
    END DO

!
! calculate areal fractions wetted by intercepted h2o
!
      CALL fwetcal(npoi               , &! INTENT(IN   )
                   fwetu (1:npoi)     , &! INTENT(OUT  )
		   rliqu (1:npoi)     , &! INTENT(OUT  )
		   fwets (1:npoi)     , &! INTENT(OUT  )
		   rliqs (1:npoi)     , &! INTENT(OUT  )
		   fwetl (1:npoi)     , &! INTENT(OUT  )
		   rliql (1:npoi)     , &! INTENT(OUT  )
                   wliqu (1:npoi,jb)  , &! INTENT(IN   )
		   wliqumax           , &! INTENT(IN   ) ::
		   wsnou (1:npoi,jb)  , &! INTENT(IN   ) ::
		   wsnoumax           , &! INTENT(IN   ) ::
		   tu   (1:npoi,jb)   , &! INTENT(IN   )
		   wliqs(1:npoi,jb)   , &! INTENT(IN   )
                   wliqsmax           , &! INTENT(IN   )
		   wsnos(1:npoi,jb)   , &! INTENT(IN   )
		   wsnosmax           , &! INTENT(IN   )
		   ts   (1:npoi,jb)   , &! INTENT(IN   )
		   wliql(1:npoi,jb)   , &! INTENT(IN   )
		   wliqlmax           , &! INTENT(IN   )
                   wsnol(1:npoi,jb)   , &! INTENT(IN   )
		   wsnolmax           , &! INTENT(IN   )
		   tl   (1:npoi,jb)   , &! INTENT(IN   )
		   epsilon            , &! INTENT(IN   )
		   tmelt              )  ! INTENT(IN   )
!
! set up for solar calculations
!
      CALL solset(npoi                 , &! INTENT(IN   )
                  nsol                 , &! INTENT(OUT  )
		  nband                , &! INTENT(IN   )
		  solu     (1:npoi)    , &! INTENT(OUT  )
                  sols     (1:npoi)    , &! INTENT(OUT  )
		  soll     (1:npoi)    , &! INTENT(OUT  )
		  solg     (1:npoi)    , &! INTENT(OUT  )
		  soli     (1:npoi)    , &! INTENT(OUT  )
                  scalcoefl(1:npoi,1:4), &! INTENT(OUT  )
		  scalcoefu(1:npoi,1:4), &! INTENT(OUT  )
		  indsol   (1:npoi)    , &! INTENT(OUT  )
		  topparu  (1:npoi)    , &! INTENT(OUT  )
                  topparl  (1:npoi)    , &! INTENT(OUT  )
		  asurd    (1:npoi,1:nband,jb) , &! INTENT(OUT  )
		  asuri    (1:npoi,1:nband,jb) , &! INTENT(OUT  )
		  coszen   (1:npoi))      ! INTENT(IN   )  
!
! solar calculations for each waveband
!
      DO  ib = 1, nband
!
! solsur sets surface albedos for soil and snow
! solalb performs the albedo calculations
! solarf uses the unit-incident-flux results from solalb
! to obtain absorbed fluxes sol[u,s,l,g,i] and 
! incident pars sunp[u,l]
!
        CALL solsur (ib                               , &! INTENT(IN   )
	             tmelt                            , &! INTENT(IN   )
		     nsol                             , &! INTENT(IN   )
		     albsod (1:npoi)                  , &! INTENT(OUt  )
		     albsoi (1:npoi)                  , &! INTENT(OUt  )
		     albsnd (1:npoi)                  , &! INTENT(OUt  )
                     albsni (1:npoi)                  , &! INTENT(OUt  )
		     indsol (1:npoi)                  , &! INTENT(IN   )
		     wsoi   (1:npoi,1:nsoilay,jb)     , &! INTENT(IN   )
		     wisoi  (1:npoi,1:nsoilay,jb)     , &! INTENT(IN   )
		     albsav (1:npoi,jb)               , &! INTENT(IN   )
		     albsan (1:npoi,jb)               , &! INTENT(IN   )
                     tsno   (1:npoi,1:nsnolay,jb)     , &! INTENT(IN   )
		     coszen (1:npoi)                  , &! INTENT(IN   )
		     npoi                             , &! INTENT(IN   )
		     nsoilay                          , &! INTENT(IN   )
		     nsnolay                            )! INTENT(IN   )

        CALL solalb (ib               , &! INTENT(IN   )
                     nVegClass        , &! INTENT(IN   )
                     vegtype0(1:npoi,jb), &! INTENT(IN   )
                     avmuir_factor(1:nVegClass,1:2), &! INTENT(IN   )
	             relod (1:npoi)   , &! INTENT(OUT  )
		     reloi (1:npoi)   , &! INTENT(OUT  )
		     indsol(1:npoi)   , &! INTENT(IN   )
		     reupd (1:npoi)   , &! INTENT(OUT  )
     		     reupi (1:npoi)   , &! INTENT(OUT  )
     		     albsnd(1:npoi)   , &! INTENT(IN   )
		     albsni(1:npoi)   , &! INTENT(IN   )
		     albsod(1:npoi)   , &! INTENT(IN   )
		     albsoi(1:npoi)   , &! INTENT(IN   )
     		     fl    (1:npoi,jb), &! INTENT(IN   )
		     fu    (1:npoi,jb), &! INTENT(IN   )
		     fi    (1:npoi,jb), &! INTENT(IN   )
		     asurd (1:npoi,1:nband,jb) , &! INTENT(INOUT)! local
		     asuri (1:npoi,1:nband,jb) , &! INTENT(INOUT)! local
     		     npoi             , &! INTENT(IN   )
		     nband            , &! INTENT(IN   )
		     nsol             , &! INTENT(IN   )
		     ablod (1:npoi)   , &! INTENT(OUT  )
		     abloi (1:npoi)   , &! INTENT(OUT  )
     		     flodd (1:npoi)   , &! INTENT(OUT  )
		     dummy (1:npoi)   , &! INTENT(OUT  )
		     flodi (1:npoi)   , &! INTENT(OUT  )
		     floii (1:npoi)   , &! INTENT(OUT  )
		     coszen(1:npoi)   , &! INTENT(IN   )
     		     terml (1:npoi,1:7)  , &! INTENT(OUT  )
		     termu (1:npoi,1:7)  , &! INTENT(OUT  )
		     lai   (1:npoi,1:2,jb), &! INTENT(IN   )
		     sai   (1:npoi,1:2,jb), &! INTENT(IN   )
		     abupd (1:npoi)      , &! INTENT(OUT  )
     		     abupi (1:npoi)      , &! INTENT(OUT  )
		     fupdd (1:npoi)      , &! INTENT(OUT  )
		     fupdi (1:npoi)      , &! INTENT(OUT  )
		     fupii (1:npoi)      , &! INTENT(OUT  )
		     fwetl (1:npoi)      , &! INTENT(IN   )
     		     rliql (1:npoi)      , &! INTENT(IN   )
		     rliqu (1:npoi)      , &! INTENT(IN   )
		     rliqs (1:npoi)      , &! INTENT(IN   )
		     fwetu (1:npoi)      , &! INTENT(IN   )
		     fwets (1:npoi)      , &! INTENT(IN   )
     		     rhoveg(1:nband,1:2) , &! INTENT(IN   )
		     tauveg(1:nband,1:2) , &! INTENT(IN   )
		     orieh (1:2)	 , &! INTENT(IN   )
		     oriev (1:2)	 , &! INTENT(IN   )
		     tl    (1:npoi,jb)   , &! INTENT(IN   )
     		     ts    (1:npoi,jb)   , &! INTENT(IN   )
		     tu    (1:npoi,jb)   , &! INTENT(IN   )
		     pi                  , &! INTENT(IN   )
		     tmelt               , &! INTENT(IN   )
		     epsilon                )! INTENT(IN   )


      END DO

   ncount=0
   DO i=1,ncols
      IF(imask(i).GE.1_i8) THEN
         ncount=ncount+1
         avisb(i)=asuri(ncount,1,jb)		   !asurd  (npoi,nband)   ! local  ! direct albedo of surface system
         avisd(i)=asurd(ncount,1,jb)		   !asuri  (npoi,nband)   ! local  ! diffuse albedo of surface system 
         anirb(i)=asuri(ncount,2,jb)
         anird(i)=asurd(ncount,2,jb)
      ELSE IF(ABS(tsea(i)).GE.271.16e0_r8 +0.01e0_r8) THEN
         f=MAX(zenith(i),0.0e0_r8 )
         ocealb=0.12347e0_r8 +f*(0.34667e0_r8+f*(-1.7485e0_r8 + &
              f*(2.04630e0_r8 -0.74839e0_r8 *f)))
         avisb(i)=ocealb
         avisd(i)=oceald
         anirb(i)=ocealb
         anird(i)=oceald
      ELSE
         avisb(i)=icealv
         avisd(i)=icealv
         anirb(i)=icealn
         anird(i)=icealn
      END IF
   END DO

  END SUBROUTINE Albedo_IBIS
  !
  !***************************************************************************
  !                      (imonth,iday,iyear)
REAL(KIND=r8) FUNCTION julday (imonth,iday,iyear,tod)
  IMPLICIT NONE
  INTEGER, INTENT(IN   ) :: imonth
  INTEGER, INTENT(IN   ) :: iday
  INTEGER, INTENT(IN   ) :: iyear
  REAL(KIND=r8)   , INTENT(IN   ) :: tod
  !
  ! compute the julian day from a normal date
  !
  julday= iday  &
       + MIN(1,MAX(0,imonth-1))*31  &
       + MIN(1,MAX(0,imonth-2))*(28+(1-MIN(1,MOD(iyear,4))))  &
       + MIN(1,MAX(0,imonth-3))*31  &
       + MIN(1,MAX(0,imonth-4))*30  &
       + MIN(1,MAX(0,imonth-5))*31  &
       + MIN(1,MAX(0,imonth-6))*30  &
       + MIN(1,MAX(0,imonth-7))*31  &
       + MIN(1,MAX(0,imonth-8))*31  &
       + MIN(1,MAX(0,imonth-9))*30  &
       + MIN(1,MAX(0,imonth-10))*31  &
       + MIN(1,MAX(0,imonth-11))*30  &
       + MIN(1,MAX(0,imonth-12))*31  &
       + tod/86400.0

END FUNCTION julday
 
END MODULE Sfc_Ibis_Interface
