!
!  ###   ####### #                       #
!   #    #     # #         ####   #    # #        ######  #    #  ######  #
!   #    #     # #        #    #  #    # #        #       #    #  #       #
!   #    #     # #        #    #  #    # #        #####   #    #  #####   #
!   #    #     # #        #    #  # ## # #        #       #    #  #       #
!   #    #     # #        #    #  ##  ## #        #        #  #   #       #
!  ###   ####### #######   ####   #    # #######  ######    ##    ######  ######
!
!  $Author: pkubota $
!  $Date: 2009/04/07 19:52:01 $
!  $Revision: 1.13 $
!
MODULE IOLowLevel

 USE Constants, ONLY: &
       r4,i4, r8
!
!  $Author: pkubota $
!  $Date: 2008/09/23 17:51:54 $
!  $Revision: 1.9 $
!
  PUBLIC :: ReadGetNFTGZ
  PUBLIC :: ReadGetSLM

  INTERFACE ReadGetNFTGZ
     MODULE PROCEDURE ReadNFTGZ4, ReadNFTGZ8
  END INTERFACE
  INTERFACE ReadGetSLM 
     MODULE PROCEDURE ReadSLM4, ReadSLM8
  END INTERFACE

CONTAINS
  SUBROUTINE ReadNFTGZ4(n,irec,field1,field2,field3)
    INTEGER, INTENT(in   ) :: n 
    INTEGER, INTENT(in   ) :: irec
    REAL   (KIND=r8), INTENT(out  ) :: field1 (:,:)
    REAL   (KIND=r8), INTENT(out  ) :: field2 (:,:)
    REAL   (KIND=r8), INTENT(out  ) :: field3 (:,:)
    REAL   (KIND=r4)                :: raux1(SIZE(field1,1),SIZE(field1,2))
    REAL   (KIND=r4)                :: raux2(SIZE(field2,1),SIZE(field2,2))
    REAL   (KIND=r4)                :: raux3(SIZE(field3,1),SIZE(field3,2))

    READ (UNIT=n, Rec=irec) raux1
    READ (UNIT=n, Rec=irec+1) raux2
    READ (UNIT=n, Rec=irec+2) raux3

    field1 = REAL(raux1, r8)
    field2 = REAL(raux2, r8)
    field3 = REAL(raux3, r8)

    !REWIND(UNIT=n)
  END SUBROUTINE ReadNFTGZ4
  SUBROUTINE ReadNFTGZ8(n,irec,field1,field2,field3)
    INTEGER(KIND=i4), INTENT(in   ) :: n 
    INTEGER         , INTENT(in   ) :: irec
    REAL   (KIND=r4), INTENT(out  ) :: field1 (:,:)
    REAL   (KIND=r4), INTENT(out  ) :: field2 (:,:)
    REAL   (KIND=r4), INTENT(out  ) :: field3 (:,:)
    REAL   (KIND=r4)                :: raux1(SIZE(field1,1),SIZE(field1,2))
    REAL   (KIND=r4)                :: raux2(SIZE(field2,1),SIZE(field2,2))
    REAL   (KIND=r4)                :: raux3(SIZE(field3,1),SIZE(field3,2))

    READ (UNIT=n, Rec=irec ) raux1
    READ (UNIT=n, Rec=irec+1) raux2
    READ (UNIT=n, Rec=irec+2) raux3

    field1 = REAL(raux1, r4)
    field2 = REAL(raux2, r4)
    field3 = REAL(raux3, r4)

    REWIND(UNIT=n)
  END SUBROUTINE ReadNFTGZ8
  
  SUBROUTINE ReadSLM4(n,irec,field)
    INTEGER(KIND=i4)  , INTENT(in   ) :: n
    INTEGER           , INTENT(in   ) :: irec
    REAL     (KIND=r4), INTENT(out  ) :: field  (:,:) 
    REAL     (KIND=r4)                :: raux3(SIZE(field,1),SIZE(field,2))
    INTEGER(KIND=i4)                  :: i,j
    INTEGER(KIND=i4)                  :: idim,jdim
    idim=SIZE(field,1) ;jdim=SIZE(field,2)
    READ(UNIT=n,rec=irec) raux3
    DO j=1,jdim
      DO i=1,idim
        field(i,j) = raux3(i,j)
      END DO
    END DO  
  END SUBROUTINE ReadSLM4
  SUBROUTINE ReadSLM8(n,irec,field)
    INTEGER           , INTENT(in   ) :: n
    INTEGER           , INTENT(in   ) :: irec
    REAL     (KIND=r8), INTENT(out  ) :: field  (:,:)
    REAL     (KIND=r4)                :: raux3(SIZE(field,1),SIZE(field,2))
    INTEGER(KIND=i4)                  :: i,j
    INTEGER(KIND=i4)                  :: idim,jdim
    idim=SIZE(field,1) ;jdim=SIZE(field,2)
    READ(UNIT=n,rec=irec) raux3
    DO j=1,jdim
      DO i=1,idim
        field(i,j) = raux3(i,j)
      END DO
    END DO
  END SUBROUTINE ReadSLM8

END MODULE IOLowLevel
